﻿USE sofia;
DROP TABLE IF EXISTS sofia.mri_vpl;
CREATE TABLE mri_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mri_vpl WRITE;
INSERT INTO mri_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ko te pukapuka o te whakapapa o Īhu Karaiti, tama a Rāwiri, tama a Āperahama. ");
INSERT INTO mri_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nā, ko tā Āperahama ko Īhaka; tā Īhaka ko Hākopa; tā Hākopa ko Hūrā rātou ko ōna tuākana, ko ōna tēina; ");
INSERT INTO mri_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","tā Hūrā rāua ko Tāmara ko Parete rāua ko Hara; tā Parete ko Heteromo; tā Heteromo ko Arame; ");
INSERT INTO mri_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","tā Arame ko Aminarapa; tā Aminarapa ko Nāhona; tā Nāhona ko Haramono; ");
INSERT INTO mri_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","tā Haramono rāua ko Rahapa ko Poaha; tā Poaha rāua ko Rutu ko Ōpere; tā Ōpere ko Hehe; ");
INSERT INTO mri_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","tā Hehe ko Rāwiri, ko te kīngi. Tā Rāwiri kīngi rāua ko te wahine a Uria ko Horomona; ");
INSERT INTO mri_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","tā Horomona ko Rehopoama; tā Rehopoama ko Apia; tā Apia ko Aha. ");
INSERT INTO mri_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Tā Aha ko Iehohāpata; tā Iehohāpata; ko Iorama; tā Iorama ko Ohiaha; ");
INSERT INTO mri_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","tā Ohiaha ko Iotama; tā Iotama ko Āhata; tā Āhata ko Hetekia; ");
INSERT INTO mri_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","tā Hetekia ko Mānahi; tā Mānahi ko Amono; tā Amono ko Hōhia; ");
INSERT INTO mri_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","tā Hōhia ko Hekonia rātou ko ōna tēina; i te wā o te whakahekenga ki Papurōna. ");
INSERT INTO mri_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ā, i muri i te whakahekenga atu ki Pa­purōna, ka whānau tā Hekonia ko Haratiera; tā Haratiera ko Herupapera; ");
INSERT INTO mri_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","tā Herupapera ko Apiuru; tā Apiuru ko Eriakimi; tā Eriakimi ko Ātoro; ");
INSERT INTO mri_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","tā Ātoro ko Hāroko; tā Hāroko ko Ākimi; tā Ākimi ko Eriuru; ");
INSERT INTO mri_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","tā Eriuru ko Ereātara; tā Ereātara ko Matana; tā Matana ko Hākopa; ");
INSERT INTO mri_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tā Hākopa ko Hōhepa, ko te tahu a Meri; whānau ake tā Meri ko Īhu, e kīa nei ko te Karaiti. ");
INSERT INTO mri_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Heoi, ko ngā whakatupuranga katoa o Āperahama tae noa ki a Rāwiri, tekau mā whā ngā whakatupuranga; o Rāwiri tae noa ki te whakahekenga ki Papurōna tekau mā whā ngā whakatupuranga; ā, nō te whakahekenga ki Papurōna tae noa ki a te Karaiti tekau mā whā ngā whakatupuranga. ");
INSERT INTO mri_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nā, ko te whānautanga tēnei o Īhu Karaiti; he mea taumau a Meri, tōna whaea, mā Hōhepa, ā, i te mea kīanō rāua i tata noa ki a rāua, ka kitea kua hapū ia i te Wairua Tapu. ");
INSERT INTO mri_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Otirā, he tangata tika tāna tahu, a Hōhepa, ā, kāhore ōna ngākau kia whakakitea nuitia ia, ka mea kia whakarērea pukutia. ");
INSERT INTO mri_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Otiia, i a ia e hurihuri ana i ēnei mea, nā, ka puta moemoeā mai tētahi anahera a te Ariki ki a ia, ka mea, “E Hōhepa, e te tama a Rāwiri, kaua e hopohopo ki te tango i a Meri, i tāu wahine; nā te Wairua Tapu hoki tōna hapū. ");
INSERT INTO mri_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ā, e whānau ia he tama, me hua e koe tōna ingoa ko Īhu; nō te mea māna e whakaora tōna iwi i ō rātou hara.” ");
INSERT INTO mri_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nā, ka oti tēnei katoa, kātahi ka rite tā te Ariki, i kōrerotia e te poropiti, i mea ai ia, ");
INSERT INTO mri_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nā, ka hapū te wāhina, ka whānau hoki he tama, ā, ka huaina e rātou tōna ingoa ko Emānuera,” ko tōna whakamāoritanga tēnei, “Kei a tātou te Atua.” ");
INSERT INTO mri_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ā, ka ara ake a Hōhepa i te moe, ka meatia e ia tā te anahera a te Ariki i whakahau ai ki a ia, ā, tango ana ia i tāna wahine. ");
INSERT INTO mri_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ā, kīhai i mōhio ki a ia, whānau noa tāna tama mātāmua; ā, huaina ana e ia tōna ingoa ko Īhu. ");
INSERT INTO mri_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nā, i te mea kua whānau nei a Īhu ki Pēterehema o Hūria, i ngā rā o Kīngi Herora, nā, ka haere mai ētahi Maki i te rāwhiti ki Hiruhārama, ");
INSERT INTO mri_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ka mea, “Kei hea tēnei kua whānau nei hei kīngi mō ngā Hūrai? I kite hoki mātou i tōna whetū i te rāwhiti, ā, ka tae mai nei ki te koropiko ki a ia.” ");
INSERT INTO mri_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ā, nō te rongonga o Kīngi Herora, ka ohorere rātou ko Hiruhārama katoa. ");
INSERT INTO mri_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nā, whakaminea katoatia ana e ia ngā tohunga nui me ngā karaipi o te iwi, ā, ka ui ki a rātou ki te wāhi e whānau ai a te Karaiti. ");
INSERT INTO mri_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka mea rātou ki a ia, “Ki Pēterehema o Hūria; ko tā te poropiti hoki tēnei i tuhituhi ai: ");
INSERT INTO mri_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ā, ko koe, e Pēterehema, whenua o Hūrā, ehara rawa i te iti rawa i roto i ngā kāwana o Hūrā; e puta mai hoki i a koe he kāwana, hei hēpara mō tāku iwi, mō Īharaira.’ ” ");
INSERT INTO mri_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nā, ka oti ngā Maki te karanga puku e Herora, ka uia mārietia rātou ki te wā i puta mai ai te whetū. ");
INSERT INTO mri_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ā, ungā ana rātou e ia ki Pēterehema, i mea ia, “Haere, rapua mārietia te tamaiti; ā, ka kitea, ka whakahoki mai i te kōrero ki ahau, kia haere ai hoki ahau ki te koropiko ki a ia.” ");
INSERT INTO mri_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nā, ka rongo rātou i tā te kīngi, ka haere; nā, ko te whetū, i kite ai rātou i te rāwhiti, e haere ana i mua i a rātou, ā tae noa, tū noa ki runga ake i te takotoranga o te tamaiti. ");
INSERT INTO mri_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ā, i tō rātou kitenga i te whetū, ko te tino haringa i hari ai. ");
INSERT INTO mri_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ā, ka tae ki roto ki te whare, ka kite i te tamaiti rāua ko tōna whaea, ko Meri, nā, tāpapa ana rātou, koropiko ana ki a ia. Ā, nō ka māwhera ō rātou taonga, ka hoatu ētahi mea ki a ia, he kōura, he parakihe, he maira. ");
INSERT INTO mri_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ā, i whakatūpatoria rātou e te Atua, he mea moemoeā, kia kaua e hoki ki a Herora; nā, haere ana ki tō rātou kāinga he ara kē. ");
INSERT INTO mri_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ā, ka riro atu rātou, nā, ka puta moemoeā tētahi anahera a te Ariki ki a Hōhepa, ka mea, “E ara, tangohia te tamaiti rāua ko tōna whaea, e rere ki Īhipa, ā, hei reira koe kia kōrero rā anō ahau ki a koe; meāke hoki rapu a Herora i te tamaiti kia whakangaromia.” ");
INSERT INTO mri_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nā, ka ara ake ia, ka mau ki te tamaiti rāua ko tōna whaea i te pō, ā, haere ana ki Īhipa, ");
INSERT INTO mri_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ā, noho ana i reira, mate noa a Herora. Nā, ka rite tā te Ariki i kōrerotia e te poropiti, i mea ai ia, “He mea karanga nāku tāku tamaiti i Īhipa.” ");
INSERT INTO mri_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ā, nō te kitenga o Herora ka oti ia te tinihanga e ngā Maki, rahi rawa tōna riri, ka tono tāngata, ā, patua iho ngā tamariki katoa, ngā mea e rua nei ō rātou tau, me ō muri iho, i Pēterehema, i ngā wāhi katoa o reira, he mea whakarite ki te tāima i uia mārietia e ia ki ngā Maki. ");
INSERT INTO mri_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kātahi, ka rite tā Heremaia poropiti i kōrero ai, i mea ai: ");
INSERT INTO mri_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“I rangona he reo ki Rama, he uhunga, he tangi, he auē nui. Ko Rahera e tangi ana ki āna tamariki; ā, kīhai i pai kia whakamārietia, nō te mea kua kāhore rātou.” ");
INSERT INTO mri_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ā, nō ka mate a Herora, nā, ka puta moemoeā te anahera a te Ariki ki a Hōhepa ki Īhipa, ");
INSERT INTO mri_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ka mea, “Ara ake, tangohia te tamaiti rāua ko tōna whaea, ā, haere ki te whenua o Īharaira; kua mate hoki te hunga i whai kia patua te tamaiti.” ");
INSERT INTO mri_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ā, ko tōna aranga ake, ka mau ki te tamaiti rāua ko tōna whaea, ka haere ki te whenua o Īharaira. ");
INSERT INTO mri_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Otirā, ka rongo ia ko Arakerauha te kīngi o Hūria i muri i tōna matua, i a Herora, ka wehi ki te haere ki reira. Otiia, i whakamaharatia ia e te Atua, he mea moemoeā, ā, haere ana ki ngā wāhi o Kariri. ");
INSERT INTO mri_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ā, ka tae, ā, ka noho ki tētahi pā, ko Nahareta te ingoa; i rite ai tā ngā poropiti i mea ai, “Me hua ia he tangata nō Nahareta.” ");
INSERT INTO mri_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nā, i aua rā, ka puta a Hoani Kaiiriiri, ka kauwhau i te koraha o Hūria, ");
INSERT INTO mri_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ka mea, “Rīpenetā, kua tata hoki te rangatiratanga o te rangi.” ");
INSERT INTO mri_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ko tā Ihāia poropiti hoki tēnei i kōrero ai, i mea ai: “He reo nō tētahi i te koraha e karanga ana: ‘Whakapaia te huarahi o te Ariki, whakatikaia ōna ara.’ ” ");
INSERT INTO mri_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ā, ko te kākahu o taua Hoani he huruhuru kāmera, he hiako hoki te whītiki o tōna hope; ko tāna kai he māwhitiwhiti, he honi koraha. ");
INSERT INTO mri_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kātahi, ka haere ki a ia a Hiruhārama, me Hūria katoa, me ngā kāinga katoa e tūtata ana ki Horano, ");
INSERT INTO mri_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ā, iriiria ana rātou e ia ki Horano, me te whāki anō i ō rātou hara. ");
INSERT INTO mri_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nō tōna kitenga ia i te tini o ngā Parihi, o ngā Haruki e haere ana ki tāna iriiringa, ka mea ia ki a rātou, “E te uri nākahi, nā wai koutou i whakamahara kia rere i te riri meāke puta? ");
INSERT INTO mri_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nā, whakaputaina he hua e rite ana ki ō te rīpenetā. ");
INSERT INTO mri_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kei anga koutou kei mea i roto i a koutou, ‘Ko Āperahama tō tātou matua.’ Ko tāku kupu hoki tēnei ki a koutou, E āhei ana anō i te Atua te whakaara tamariki ake mā Āperahama i ēnei kōhatu. ");
INSERT INTO mri_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nā, tēnei ka pā te toki ki te pakiaka o ngā rākau; ā, ki te kāhore tētahi rākau e hua i te hua pai, ka tuaina, ka makā ki te ahi. ");
INSERT INTO mri_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ko ahau nei he iriiri tāku i a koutou ki te wai, hei mea rīpenetā; ko tēnei ia, e haere mai ana i muri i ahau, nui atu tōna mana i tōku, e kore ahau e tau hei mau i ōna hū. Māna koutou e iriiri ki te Wairua Tapu, ki te kāpura. ");
INSERT INTO mri_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ko tāna mea tahi kei tōna ringa, ā, e tino tahia e ia tāna patunga wīti, ā, e kohia āna wīti ki roto ki te whare wīti; tēnā ko te pāpapa e tahuna ki te kāpura e kore e tineia.” ");
INSERT INTO mri_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","I reira, ka haere a Īhu i Kariri ki Horano, ki a Hoani, kia iriiria e ia. ");
INSERT INTO mri_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Otirā, ka whakakāhore a Hoani ki a ia, ka mea, “Ko te tikanga rā ko ahau kia iriiria e koe, ā, e haere mai ana koe ki ahau?” ");
INSERT INTO mri_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nā, ka whakahoki a Īhu, ka mea ki a ia, “Tukua rā āianei; ko te tikanga hoki tēnei mā tāua kia whakarite i ngā mea tika katoa.” Nā, tukua ana ia e ia. ");
INSERT INTO mri_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ā, nō ka oti a Īhu te iriiri, tika tonu ake ia i te wai; nā, ko te rangi ka tuwhera ki a ia, ā, ka kite ia i te Wairua o te Atua e heke iho ana me he kūkupa, ā, tau ana ki runga ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nā, ko tētahi reo nō te rangi e mea ana, “Ko tāku Tama tēnei i aroha ai, ko tāku i āhuareka ai.” ");
INSERT INTO mri_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Me i reira ka ārahina a Īhu e te Wairua ki te koraha, kia whakamātautauria e te rēwera. ");
INSERT INTO mri_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ā, nō ka whā tekau ngā rā, ka whā tekau ngā pō i nohopuku ai, muri iho ka hiakai. ");
INSERT INTO mri_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nā, ka tae te kaiwhakamātautau ki a ia, ka mea, “Ki te mea ko te Tama koe a te Atua, kīa iho kia meinga ēnei kōhatu hei taro.” ");
INSERT INTO mri_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nā, ka whakahoki ia, ka mea, “Kua oti te tuhituhi, ‘E kore e ora te tangata i te taro kau, engari, i ngā kupu katoa e puta mai ana i te māngai o te Atua.’ ” ");
INSERT INTO mri_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Me i reira, ka kawe te rēwera i a ia ki te pā tapu, ā, whakatūria ana ia ki runga ki te keokeonga o te temepara, ");
INSERT INTO mri_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ā, ka mea ki a ia, “Ki te mea ko te Tama koe a te Atua, rere atu ki raro; kua oti hoki te tuhituhi: ‘Ka kōrerotia iho koe e ia ki āna anahera; mā rātou koe e hiki ake ki ō rātou ringa, kei tūtuki tōu waewae ki te kōhatu.’ ” ");
INSERT INTO mri_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mea atu ana a Īhu ki a ia, “Ka oti anō hoki te tuhituhi, ‘Kaua e whakamātautau ki te Ariki ki tōu Atua.’ ” ");
INSERT INTO mri_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ka kawe anō te rēwera i a ia ki runga ki tētahi maunga tiketike rawa, ā, whakakitea ana ki a ia ngā rangatiratanga katoa o te ao, me te korōria o aua mea; ");
INSERT INTO mri_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ā, mea ana ki a ia, “Ko ēnei mea katoa e hoatu e ahau ki a koe, ki te tāpapa koe, ki te koropiko ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nā, ka mea a Īhu ki a ia, “Haere atu, e Hātana! Kua oti hoki te tuhituhi; ‘Me koropiko koe ki te Ariki ki tōu Atua, me mahi anō ki a ia anake.’ ” ");
INSERT INTO mri_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nā, ka mahue ia i te rēwera, ā, ka haere mai ngā anahera ka mahi mea māna. ");
INSERT INTO mri_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ā, nō ka rongo a Īhu kua tukua a Hoani ki te whare herehere, ka haere ia ki Kariri. ");
INSERT INTO mri_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ā, ka mahue a Nahareta i a ia, ā, haere ana, ka noho ki Kaperenauma, ki te taha o te moana, ki ngā rohe o Hepurona, o Napatari. ");
INSERT INTO mri_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","I rite ai tā Ihāia poropiti i kōrero ai, i mea ai: ");
INSERT INTO mri_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ko te whenua o Hepurona, me te whenua o Napatari, i te ara o te moana, i tērā taha o Horano, Kariri o ngā tauiwi! ");
INSERT INTO mri_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ko te hunga i noho i te pōuri kua kite rātou i te mārama nui, ā, ko te hunga i noho i te wāhi i te ātārangi o te mate, kua puta ake te mārama ki a rātou.” ");
INSERT INTO mri_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nō reira anō a Īhu i tīmata ai te kauwhau, te mea, “Rīpenetā, kua tata hoki te rangatiratanga o te rangi.” ");
INSERT INTO mri_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ā, i a Īhu e haere ana i te taha o te moana o Kariri, ka kite ia i ētahi tāngata tokorua, he tuakana he teina, i a Haimona, tōna ingoa nei ko Pita, rāua ko tōna teina, ko Anaru, e maka ana i te kupenga ki te moana; he kaihao ika hoki rāua. ");
INSERT INTO mri_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nā, ka mea ia ki a rāua, “Arumia mai ahau, ā, māku kōrua e mea hei kaihao tāngata.” ");
INSERT INTO mri_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ā, mahue ake i a rāua ngā kupenga, ā, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ā, nō tōna haerenga i reira, tokorua anō āna i kite ai, he tuakana, he teina, ko Hēmi tama a Heperi rāua ko tōna teina, ko Hoani, i te kaipuke i a Heperi i tō rāua matua, e tā ana i ngā korenga o ā rātou kupenga, ā, karangatia ana rāua e ia. ");
INSERT INTO mri_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mahue tonu ake i a rāua te kaipuke me tō rāua matua, ā, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nā, ka hāereerea katoatia a Kariri e Īhu, whakaako ana i roto i ō rātou whare karakia, kauwhau ana i te rongopai o te rangatiratanga, me te whakaora i ngā mate katoa, i ngā tūrorotanga katoa o te iwi. ");
INSERT INTO mri_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ā, ka haere tōna rongo puta noa i Hīria, ā, kawea ana mai e rātou ki a ia ngā tāngata mate katoa e ngaua ana e te tini o ngā mate, o ngā mamae, me te hunga e nohoia ana e te rēwera, me te hunga haurangi, me ngā pararūtiki, ā, whakaorangia ake rātou e ia. ");
INSERT INTO mri_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ā, he rahi te hui i aru i a ia i Kariri, i Rekaporihi, i Hiruhārama, i Hūria, i tērā taha anō o Horano. ");
INSERT INTO mri_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ā, i tōna kitenga i te whakaminenga, ka haere ia ki runga ki te maunga; ā, nō ka noho ia, ka haere āna ākonga ki a ia, ");
INSERT INTO mri_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nā, ka puaki tōna māngai, ā, ka whakaako ia i a rātou, ka mea: ");
INSERT INTO mri_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ka koa te hunga he rawakore nei te wairua; nō rātou hoki te rangatiratanga o te rangi. ");
INSERT INTO mri_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ka koa te hunga e tangi ana; ka whakamārietia hoki rātou. ");
INSERT INTO mri_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ka koa te hunga ngākau māhaki; ka riro hoki i a rātou te whenua. ");
INSERT INTO mri_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ka koa te hunga e hiakai ana, e hiainu ana, ki te tika; e mākona hoki rātou. ");
INSERT INTO mri_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ka koa te hunga tohu tangata; e tohungia hoki rātou. ");
INSERT INTO mri_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ka koa te hunga ngākau mā; e kite hoki rātou i te Atua. ");
INSERT INTO mri_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ka koa te hunga hohou rongo; ka huaina hoki rātou he tamariki nā te Atua. ");
INSERT INTO mri_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ka koa te hunga e whakatoia ana mō te tika; nō rātou hoki te rangatiratanga o te rangi. ");
INSERT INTO mri_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ka koa koutou ina tāwai rātou i a koutou, ina whakatoi, ina puaki i a rātou ngā kupu kino katoa mō koutou, he mea teka, he whakaaro hoki ki ahau. ");
INSERT INTO mri_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kia hari, kia whakamanamana; he rahi hoki te utu mō koutou i te rangi; he pēnei hoki tā rātou whakatoi i ngā poropiti i mua i a koutou.” ");
INSERT INTO mri_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ko koutou te tote o te whenua; otirā, ki te hemo te hā o te tote, mā te aha e whai tikanga tote ai? Heoi anō tōna painga, nā, ka ākiritia ki waho, ka takahia e ngā tāngata. ");
INSERT INTO mri_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ko koutou te whakamārama o te ao. E kore e ngaro te pā e tū ana i runga i te maunga. ");
INSERT INTO mri_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","E kore hoki e tahuna te rama, e whakatūria ki raro o te mēhua, engari, ki runga ki te tūranga; ā, ka tīaho ki ngā tāngata katoa i roto i te whare. ");
INSERT INTO mri_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Waihoki, kia tīaho tō koutou mārama ki te aroaro o ngā tāngata, kia kite ai rātou i ā koutou hanga pai, kia whakakorōria ai i tō koutou Matua i te rangi.” ");
INSERT INTO mri_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kei mea koutou i haere mai ahau ki te whakakāhore i te ture, i ngā poropiti rānei; kīhai ahau i haere mai ki te whakakāhore, engari, ki te whakatutuki. ");
INSERT INTO mri_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","He tino pono hoki tāku e mea nei ki a koutou, pahemo noa te rangi me te whenua, e kore tētahi tongi, tētahi tohu rānei o te ture e pahemo, kia rite katoa rā anō. ");
INSERT INTO mri_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nā, ki te whakakāhore tētahi i tētahi mea iti rawa o ēnei kupu ako, ā, ka ako i ngā tāngata kia pērā, ka kīa ia ko te iti rawa i te rangatiratanga o te rangi; engari, ki te whakaritea e tētahi, ki te whakaakona, ka kīa ia he nui i te rangatiratanga o te rangi. ");
INSERT INTO mri_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ko tāku kupu hoki tēnei ki a koutou, Ki te kore e nui ake tā koutou mahi tika i tā ngā karaipi rātou ko ngā Parihi, e kore rawa koutou e tapoko ki te rangatiratanga o te rangi.” ");
INSERT INTO mri_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kua rongo koutou, i kōrerotia ki ngā tūpuna, ‘Kaua e patu tangata; ā, ki te patu tangata tētahi, ka tau te hē ki a ia.’ ");
INSERT INTO mri_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nā, ko tāku kupu tēnei ki a koutou, Ki te riri noa tētahi ki tōna teina, ka tau te hē ki a ia; ā, ki te mea tētahi ki tōna teina, ‘Wairangi!’ ka tika kia komititia. Nā, ki te mea tētahi, ‘Pōauau!’ ka tika mōna te kāpura o Kehena. ");
INSERT INTO mri_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nā reira, ki te mauria e koe tāu whakahere ki te āta, ā, ka mahara i reira i hara koe ki tōu hoa; ");
INSERT INTO mri_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","waiho tāu whakahere i reira, i mua o te āta, ā, haere, mātua houhia te rongo ki tōu teina, ka haere ai, ka mau ai i tāu whakahere. ");
INSERT INTO mri_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kia hohoro te whakarite i tā kōrua kōrero ko tōu hoa tauwhāinga, i a kōrua anō i te ara, kei tukua koe e te hoa tauwhāinga ki te kaiwhakawā, ā, ka tukua e te kaiwhakawā ki te kātipa, ā, ka makā koe ki te whare herehere. ");
INSERT INTO mri_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","He pono tāku e mea atu nei ki a koe, E kore rawa koe e puta i reira, kia utua rā anō te pātene whakamutunga.” ");
INSERT INTO mri_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kua rongo koutou, i kōrerotia, ‘Kaua e pūremu.’ ");
INSERT INTO mri_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nā, ko tāku kupu tēnei ki a koutou, Ki te titiro tētahi ki te wahine, he hiahia ki a ia, kua pūremu kē ia ki a ia i roto i tōna ngākau. ");
INSERT INTO mri_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ki te hē koe i tōu kanohi matau, tīkarohia, makā atu; he pai kē hoki ki a koe ki te ngaro tētahi wāhi ōu, ā, ka kore e makā tōu tinana katoa ki Kehena. ");
INSERT INTO mri_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ki te hē anō hoki koe i tōu ringa matau, pōutoa, makā atu; he pai kē ki te mate tētahi wāhi ōu, ā, ka kore e makā tōu tinana katoa ki Kehena.” ");
INSERT INTO mri_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“I kōrerotia anō, ‘Ki te whakarere tētahi i tāna wahine, me hoatu ki a ia tētahi pukapuka whakarere.’ ");
INSERT INTO mri_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nā, ko tāku kupu tēnei ki a koutou, Ki te whakarere tētahi i tāna wahine, hāunga mō te take moepuku, e mea ana ia i te wahine kia pūremu; ā, ki te mārena tētahi i te wahine i whakarērea, e pūremu ana ia.” ");
INSERT INTO mri_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kua rongo anō koutou, i kōrerotia ki ngā tūpuna, ‘Kaua e oati teka, engari, me whakamana āu oati ki te Ariki.’ ");
INSERT INTO mri_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nā, ko tāku kupu tēnei ki a koutou, Kaua rawa tētahi mea e oatitia; kaua te rangi, ko tō te Atua torōna hoki ia, ");
INSERT INTO mri_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kaua hoki te whenua, ko te tūranga hoki tērā o ōna waewae, kaua hoki a Hiruhārama; ko te pā hoki tērā o te Kīngi nui. ");
INSERT INTO mri_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kaua anō e oatitia tōu mātenga, e kore hoki e āhei i a koe te mea kia mā tētahi makawe, kia mangu rānei. ");
INSERT INTO mri_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Erangi, ko tēnei hei kupu mā koutou, ‘Āe, āe’; ‘Kāhore, kāhore’; nō te mea ki te maha atu i ēnā, nō te kino.” ");
INSERT INTO mri_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kua rongo koutou i kōrerotia, ‘He kanohi mō te kanohi, he niho mō te niho.’ ");
INSERT INTO mri_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nā, ko tāku kupu tēnei ki a koutou, Kaua e whakauaua atu ki te kino; erangi, ki te pākia tōu pāpāringa matau e tētahi, whakaangahia atu hoki tērā ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ā, ki te mea tētahi kia whakawākia koe, ka tangohia tōu koti, tukua atu hoki tōu ngeri ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ā, ki te tonoa koe e tētahi kia haere kotahi te māero, kia rua āu e haere tahi ai me ia. ");
INSERT INTO mri_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hoatu ki te tangata e tono mea ana i a koe, kaua hoki e tahuri kē i te tangata e mea ana ki te taonga tārewa i a koe.” ");
INSERT INTO mri_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kua rongo koutou i kōrerotia, ‘Kia aroha ki tōu hoa tata, kia kino hoki ki tōu hoa whawhai.’ ");
INSERT INTO mri_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nā, ko tāku kupu tēnei ki a koutou, Arohaina ō koutou hoa whawhai, manaakitia te hunga e kanga ana i a koutou, kia pai te mahi ki te hunga e kino ana ki a koutou, me īnoi hoki mō te hunga e whakawhiu ana i a koutou, e whakatoi ana i a koutou; ");
INSERT INTO mri_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kia tupu ai koutou hei tamariki mā tō koutou Matua i te rangi; e mea nei hoki ia i tōna rā kia whiti ki te hunga kino, ki te hunga pai, kia ua hoki te ua ki te hunga tika, ki te hunga hē. ");
INSERT INTO mri_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ki te aroha hoki koutou ki te hunga e aroha ana ki a koutou, he aha te utu e riro i a koutou? Kāhore ianei ngā pupirikana e pēnā? ");
INSERT INTO mri_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ā, ki te oha koutou ki ō koutou tēina anake, he aha tā koutou mahi i nui ake i tā ētahi? Kāhore ianei ngā tauiwi e pēnā hoki? ");
INSERT INTO mri_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nā, kia tika koutou, kia pērā me tō koutou Matua i te rangi e tika ana.” ");
INSERT INTO mri_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kia tūpato kei mahi i tā koutou mea tika i te aroaro o ngā tāngata, hei tirohanga mā rātou; pēnei kāhore he utu ki a koutou a tō koutou Matua i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nā, ka atawhai koe i te rawakore, aua e whakatangihia te tētere i mua i a koe, kei pērā me te hunga tinihanga i roto i ngā whare karakia, i ngā ara, kia whai korōria ai i ngā tāngata. He pono tāku e mea nei ki a koutou, kei a rātou anō te utu mō rātou. ");
INSERT INTO mri_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Erangi, ka atawhaitia e koe te rawakore, kei mōhio tōu mauī ki tā tōu matau e mea ai; ");
INSERT INTO mri_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kia ngaro ai tāu atawhainga rawakore; ā, ko tōu Matua e kite nei i te wāhi ngaro, māna koe e utu.” ");
INSERT INTO mri_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ā, ka īnoi koe, kaua e pērā me te hunga tinihanga; ko tā rātou hoki e pai ai ko te īnoi tū i roto i ngā whare karakia, i ngā kokinga o ngā ara, kia kitea ai e te tangata. He pono tāku e mea nei ki a koutou, Kei a rātou anō te utu mō rātou. ");
INSERT INTO mri_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nā, ka īnoi koe, tomo atu ki tōu rūma i roto rawa, ā, nō ka kati tōu tatau, īnoi ki tōu Matua i te wāhi ngaro; ā, ko tōu Matua e kite nei i te wāhi ngaro, māna koe e utu. ");
INSERT INTO mri_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nā, ka īnoi koutou, aua e whakahuatia noatia ko aua kupu anō, kei pērā me ngā tauiwi; ki tā rātou hoki mā ngā kupu maha e rangona ai rātou. ");
INSERT INTO mri_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nā, kei rite koutou ki a rātou; e mātau ana hoki tō koutou Matua ki ngā mea e matea ana e koutou, i te mea kīanō koutou i īnoi ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nā, kia pēnei tā koutou īnoi: ‘E tō mātou Matua i te rangi: Kia tapu tōu ingoa; ");
INSERT INTO mri_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kia tae mai tōu rangatiratanga; kia meatia tāu e pai ai ki runga ki te whenua kia rite anō ki tō te rangi. ");
INSERT INTO mri_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hōmai ki a mātou āianei he taro mā mātou mō tēnei rā. ");
INSERT INTO mri_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Murua ō mātou hara, me mātou hoki e muru nei i ō te hunga e hara ana ki a mātou. ");
INSERT INTO mri_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aua hoki mātou e kawea kia whakawaia; engari, whakaorangia mātou i te kino. Nōu hoki te rangatiratanga, te kaha, me te korōria, ake, ake. Āmine.’ ");
INSERT INTO mri_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ki te whakarērea noatia iho hoki e koutou ngā hē o te tangata, ka whakarērea noatia iho anō o koutou e tō koutou Matua i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ā, ki te kore e whakarērea noatia iho e koutou ngā hē o ngā tāngata, e kore anō e whakarērea noatia iho ō koutou hē e tō koutou Matua.” ");
INSERT INTO mri_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ka nohopuku hoki koutou, kei rite ki te hunga tinihanga, kaua e whakapoururu te kanohi; e whakaahua kē ana hoki rātou i ō rātou kanohi, kia kitea ai e te tangata, e nohopuku ana. He pono tāku e mea nei ki a koutou, Kei a rātou anō te utu mō rātou. ");
INSERT INTO mri_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Engari, ka nohopuku koe, kaukauria tōu ūpoko, horoia hoki tōu kanohi; ");
INSERT INTO mri_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kei kitea koe e te tangata e nohopuku ana, erangi, e tōu Matua i te wāhi ngaro; ā, ko tōu Matua e kite nei i te wāhi ngaro, māna koe e utu.” ");
INSERT INTO mri_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kaua e pūrangatia he taonga mō koutou ki te whenua, ki te wāhi e whakangaro ai te huhu, te waikura; ki te wāhi hoki e keri ai te tāhae, tāhae ai. ");
INSERT INTO mri_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Erangi, pūrangatia mō koutou he taonga ki te rangi, ki te wāhi e kore ai e whakangaro te huhu, te waikura, ki te wāhi hoki e kore ai e keri te tāhae, tāhae ai. ");
INSERT INTO mri_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ko te wāhi hoki i ō koutou taonga, ko reira anō ō koutou ngākau.” ");
INSERT INTO mri_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ko te kanohi te rama o te tinana. Nā, ki te ātea tōu kanohi, e mārama katoa tōu tinana. ");
INSERT INTO mri_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tēnā ki te kino tōu kanohi, ka pōuri katoa tōu tinana. Nā, ki te pōuri te mārama i roto i a koe, anō te nui o tēnā pōuri!” ");
INSERT INTO mri_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kāhore he tangata e pono te mahi ki ngā rangatira tokorua; ka kino hoki ki tētahi, ka aroha ki tētahi; ka ū rānei ki tētahi, ā, ka whakahāwea ki tētahi. E kore e pono i a koutou te mahi ki te Atua, ki te taonga. ");
INSERT INTO mri_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Koia ahau ka mea nei ki a koutou, kaua e mānukanuka ki tō koutou ora, ki tā koutou e kai ai, ki tā koutou e inu ai; ki ō koutou tinana rānei, ki tā koutou e kākahu ai. Ehara oti te ora i te rahi atu i te kai, me te tinana i te kākahu? ");
INSERT INTO mri_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tirohia ngā manu o te rangi; kāhore rātou e rui, kāhore e kokoti, e kohikohi rānei ki ngā whare wīti; heoi, e whāngainga ana rātou e tō koutou Matua i te rangi. Ehara oti koutou i te mea pai ake i ērā? ");
INSERT INTO mri_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ko wai o koutou e taea e ia te whakaaro iho, te hono tētahi wāhi ki tōna roa, kia kotahi te whatīanga? ");
INSERT INTO mri_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ā, he aha koutou i mānukanuka ai ki te kākahu? Maharatia ngā rengarenga o te whenua, te tupu; e kore nei e mahi, e kore nei anō e miro. ");
INSERT INTO mri_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ko tāku kupu tēnei ki a koutou, kīhai a Horomona, me tōna korōria katoa, i rite ki tētahi o ēnei te whai kākahu. ");
INSERT INTO mri_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ha, ki te pēnei tā te Atua whakakākahu i te tarutaru o te whenua, e tupu nei ināianei, ā, āpōpō ka makā ki te oumu, e kore ianei tāna i a koutou e rahi ake, e te hunga whakapono iti? ");
INSERT INTO mri_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nā, kaua rā e mānukanuka, e mea, ‘He aha tā tātou e kai ai? He aha tā tātou e inu ai? Me whakakākahu tātou ki te aha?’ ");
INSERT INTO mri_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ko ēnei mea katoa nei hoki tā ngā tauiwi e rapu ai; e mātau ana hoki tō koutou Matua i te rangi e matea ana e koutou ēnei mea katoa. ");
INSERT INTO mri_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Engari mātua rapua tōna rangatiratanga, me āna mea tika; ā, ka tāpiritia ēnei mea katoa mā koutou. ");
INSERT INTO mri_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nō reira, kaua e mānukanuka ki o āpōpō; mā āpōpō anō ia e mānukanuka. Kāti anō i tōna rā tōna kino.” ");
INSERT INTO mri_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kaua e whakawā, kei whakawākia koutou. ");
INSERT INTO mri_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nā, ko te whakawākanga e whakawā ai koutou, koia anō hei whakawākanga mō koutou, ā, ko te mēhua e mēhua ai koutou, hei mēhua anō tēnā ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ā, he aha tāu e titiro ki te otaota i roto i te kanohi o tōu teina, tē mahara ki te kurupae i roto i tōu? ");
INSERT INTO mri_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Me pēhea rānei tāu kupu ki tōu teina, ‘Iaua, kia kapea atu e ahau te otaota i tōu kanohi’, ā, he kurupae anō tēnā kei roto i tōu? ");
INSERT INTO mri_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","E te tangata tinihanga! Mātua kapea e koe te kurupae i tōu kanohi, kātahi koe ka mārama ki te kape i te otaota i roto i te kanohi o tōu teina. ");
INSERT INTO mri_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kaua e hoatu te mea tapu ki ngā kurī, kaua anō e makā ā koutou peara ki te aroaro o ngā poaka, kei takatakahia e ō rātou waewae, ā, ka tahuri, ka haehae i a koutou.” ");
INSERT INTO mri_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Īnoia, ā, ka hoatu ki a koutou; rapua, ā, ka kitea e koutou; pātōtō, ā, ka uakina ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ka whiwhi hoki te tangata ina īnoi, ka kite ina rapu; ka uakina hoki ki te tangata e pātōtō ana. ");
INSERT INTO mri_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ko tēhea tangata ianei o koutou, ina īnoi tāna tama ki a ia he taro, e hoatu ki a ia he kōhatu? ");
INSERT INTO mri_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ā, īnoi rānei he ika, e hoatu ki a ia he nākahi? ");
INSERT INTO mri_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nā, ki te mātau koutou, te hunga kino, ki te hoatu mea papai ki ā koutou tamariki, tērā noa ake te hōmaitanga o ngā mea papai e tō koutou Matua i te rangi ki te hunga e īnoi ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nā, ko ngā mea katoa, e pai ai koutou kia meatia e ngā tāngata, ki a koutou, meatia hoki e koutou ki a rātou; ko tēnei hoki tā te ture me tā ngā poropiti.” ");
INSERT INTO mri_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“E tomo mā te kūwaha whāiti; he whārahi hoki te kūwaha, he whānui te ara, e tika ana ki te ngaromanga, ā, he tokomaha e haere ana rā reira. ");
INSERT INTO mri_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","He kūiti hoki te kūwaha, he kikī te ara e tika ana ki te ora, ā, he tokoiti te hunga e kite.” ");
INSERT INTO mri_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kia tūpato ki ngā poropiti teka e haere nei ki a koutou, he hipi te kākahu, ko roto ia he wuruhi kai kino. ");
INSERT INTO mri_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mā ō rātou hua ka mōhiotia ai rātou e koutou. E whakia rānei te karepe i runga i te tātarāmoa, te piki rānei i te tūmatakuru? ");
INSERT INTO mri_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Waihoki he ātaahua ngā hua o te rākau pai, he kino ia ngā hua o te rākau kino. ");
INSERT INTO mri_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","E kore te rākau pai e āhei te hua i te hua kino, e kore anō te rākau kino e hua i te hua ātaahua. ");
INSERT INTO mri_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ko ngā rākau katoa e kore nei e hua i te hua ātaahua ka tuaina ki raro, ka makā ki te ahi. ");
INSERT INTO mri_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Inā, mā ō rātou hua ka mōhiotia ai rātou e koutou.” ");
INSERT INTO mri_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“E kore e tomo ki te rangatiratanga o te rangi ngā tāngata katoa e mea mai ana ki ahau, ‘E te Ariki, e te Ariki,’ engari, ia e mea ana i tā tōku Matua i te rangi i pai ai. ");
INSERT INTO mri_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","He tokomaha e mea mai ki ahau i taua rā, ‘E te Ariki, e te Ariki; kīhai koia mātou i poropiti i runga i tōu ingoa, i pei rēwera hoki i runga i tōu ingoa, he tini hoki ngā mahi nunui i meatia e mātou i runga i tōu ingoa?’ ");
INSERT INTO mri_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ko reira ahau mea ai ki a rātou, ‘Kāhore rawa ahau i mōhio ki a koutou; mawehe atu i ahau, e ngā kaimahi i te tutū.’ ” ");
INSERT INTO mri_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nā, ko te tangata e rongo ana ki ēnei kupu āku, e mahi ana hoki, ka whakaritea e ahau ki te tangata mahara, i hanga i tōna whare ki runga ki te kāmaka. ");
INSERT INTO mri_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ā, ka ua te ua, ka puta ngā waipuke, ka pupuhi ngā hau, te tino ākinga ki taua whare, kīhai hoki i hinga, nō te mea i hangā ki runga ki te kāmaka. ");
INSERT INTO mri_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ā, ko te tangata e rongo ana ki ēnei kupu āku, ā, kāhore e mahi, ka whakaritea ki te tangata whakaarokore i hanga i tōna whare ki runga ki te onepū. ");
INSERT INTO mri_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nā, ka ua te ua, ka puta ngā waipuke, ka pupuhi ngā hau, ā, pā ana ki taua whare, nā, kua hinga. He rahi anō tōna hinganga!” ");
INSERT INTO mri_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ā, nō ka mutu ēnei kōrero a Īhu, ka mīharo te whakaminenga ki tāna ako. ");
INSERT INTO mri_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","I rite hoki tāna ako i a rātou ki tā te tangata whai mana, kīhai hoki i rite ki tā ngā karaipi. ");
INSERT INTO mri_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ā, nō ka heke iho ia i te maunga, he rahi te hui i aru i a ia. ");
INSERT INTO mri_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nā, ka haere tētahi repera, ka koropiko ki a ia, ka mea, “E te Ariki, ki te pai koe, e taea ahau e koe te mea kia mā.” ");
INSERT INTO mri_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ā, ka totoro te ringa o Īhu, ka pā ki a ia, ka mea, “E pai ana ahau; kia mā koe!” Ā, mā tonu iho tōna repera. ");
INSERT INTO mri_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kātahi, ka mea a Īhu ki a ia, “Kia mahara, kei kōrerotia ki te tangata; erangi haere, kia kite te tohunga i a koe, mauria atu hoki te whakahere i whakaritea e Mohi, hei mea whakaatu ki a rātou.” ");
INSERT INTO mri_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ā, nō ka tae a Īhu ki Kaperenauma, ka haere ki a ia tētahi keneturio, ka īnoi ki a ia, ");
INSERT INTO mri_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ka mea, “E te Ariki, ko tāku pononga kei te whare e takoto ana, he pararūtiki, e ngaua kinotia ana.” ");
INSERT INTO mri_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ā, ka mea a Īhu ki a ia, “Ka haere ahau ki te whakaora i a ia.” ");
INSERT INTO mri_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nā, ko te whakahokinga a te keneturio, ko te meatanga, “E te Ariki, ehara ahau i te tikanga tangata e haere ake ai koe ki raro i tōku tuanui; engari, kia puaki kau tāu kupu, ā, ka ora tāku pononga. ");
INSERT INTO mri_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","He tangata hoki ahau e whakahaua ana, he hōia anō āku hei whakahaunga māku; ka mea ahau ki tēnei, ‘Haere,’ nā, ka haere ia; ki tētahi, ‘Haere mai,’ ā, ka haere mai; ki tāku pononga hoki, ‘Meatia tēnei,’ ā, ka meatia e ia.” ");
INSERT INTO mri_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ā, nō te rongonga o Īhu, ka mīharo, ka mea ki te hunga e aru ana, “He pono tāku e mea nei ki a koutou, Kāhore ahau i kite noa i te whakapono hei rite mō tēnei te nui i roto i a Īharaira. ");
INSERT INTO mri_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ko tāku kupu anō tēnei ki a koutou, he tokomaha e haere mai i te rāwhiti, i te hauāuru, ā, e noho tahi i a Āperahama, i a Īhaka, i a Hākopa, ki te rangatiratanga o te rangi. ");
INSERT INTO mri_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ko ngā tamariki ia o te rangatiratanga ka makā ki te pōuri i waho; ko te wāhi tērā o te tangi, o te tetēā o ngā niho.” ");
INSERT INTO mri_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nā, ka mea a Īhu ki te keneturio, “Haere, kia rite ki tōu whakapono te meatanga ki a koe.” Ā, ora ake ana taua pononga i taua wā pū anō. ");
INSERT INTO mri_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ā, nō ka tae a Īhu ki te whare o Pita, ka kite ia i tōna hungawai wahine e takoto mate ana, he kirikā. ");
INSERT INTO mri_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nā, ka pā ia ki tōna ringaringa, ā, mutu ake tōna kirikā; ā, ara ake ana ia ki te taka mea mā rātou. ");
INSERT INTO mri_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nā, i te ahiahi he tokomaha te hunga e nohoia ana e ngā rēwera i mauria mai ki a ia. Nā, ka peia e tāna kupu ngā wairua ki waho, ā, whakaorangia ake e ia te hunga mate katoa. ");
INSERT INTO mri_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","I rite ai tā Ihāia poropiti i kōrero ai, i mea ai, “Nāna i tango ō tātou ngoikore, i waha ō tātou mate.” ");
INSERT INTO mri_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nā, i te kitenga o Īhu he rahi te hui e mui ana ki a ia, ka whakahau ia kia whakawhiti ki tāwāhi. ");
INSERT INTO mri_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ā, ka haere tētahi karaipi, ka mea ki a ia, “E te Kaiwhakaako, ka aru ahau i a koe ki ngā wāhi katoa e haere ai koe.” ");
INSERT INTO mri_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ā, ka mea a Īhu ki a ia, “He rua o ngā pokiha, he kōwhanga o ngā manu o te rangi; tēnā ko te Tama a te tangata, kāhore ōna wāhi e takoto ai tōna mātenga.” ");
INSERT INTO mri_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ā, i mea tētahi atu o āna ākonga ki a ia, “E te Ariki tukua ahau kia mātua haere ki te tanu i tōku pāpā.” ");
INSERT INTO mri_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nā, ka mea a Īhu ki a ia, “Arumia ahau, ā, waiho mā ngā tūpāpaku e tanu ō rātou tūpāpaku.” ");
INSERT INTO mri_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ā, nō ka eke ia ki te kaipuke, ka aru āna ākonga i a ia. ");
INSERT INTO mri_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nā, ka tutū te puehu o te moana, ā, ngaro iho te kaipuke i te ngaru; i te moe hoki ia. ");
INSERT INTO mri_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ā, ka haere āna ākonga, ka whakaara i a ia, ka mea, “E te Ariki, whakaorangia tātou! Ka ngaro tātou.” ");
INSERT INTO mri_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ā, ka mea ia ki a rātou, “He aha tā koutou e wehi, e te hunga whakapono iti?” Me i reira ka ara ia, ā, rīria iho te hau me te moana; ā, takoto ana he marino nui. ");
INSERT INTO mri_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ā, mīharo noa ngā tāngata, ka mea, “He tangata aha tēnei? Inā, rongo rawa te hau me te moana ki a ia!” ");
INSERT INTO mri_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ā, nō ka whiti ia ki tarawāhi, ki te whenua o ngā Kerekehini, ka tūtaki ki a ia ētahi tāngata tokorua e nohoia ana e te rēwera, e puta ana mai i roto i ngā urupā, he hunga tutū rawa, tē taea taua ara te haere e te tangata. ");
INSERT INTO mri_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nā, ka karanga ake rāua, ka mea, “He aha māua nāu, e Īhu, e te Tama a te Atua? Kua tae mai oti koe ki te whakamamae i a māua i te mea kāhore anō i rite te tāima?” ");
INSERT INTO mri_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nā, tērā tētahi kāhui poaka i tawhiti atu i a rātou e kai ana, he tini. ");
INSERT INTO mri_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ā, ka īnoi ngā rēwera ki a ia, ka mea, “Ki te pei koe i a mātou, tukua mātou kia haere ki roto ki te kāhui poaka.” ");
INSERT INTO mri_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nā, ka mea ia ki a rātou, “Haere!” Nā, ko tō rātou putanga ki waho, haere ana ki roto ki te kāhui poaka. Nā, ko te tino rerenga o te kāhui poaka katoa rā te pari ki te moana, ā, mate iho ki roto ki te wai. ");
INSERT INTO mri_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nā, ka whati ngā kaiwhāngai, ā, haere ana ki te pā, kōrero ana i ngā mea katoa, me te meatanga ki te hunga i nohoia e ngā rēwera. ");
INSERT INTO mri_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nā, puta katoa ana te pā ki waho, ki te whakatau i a Īhu; ā, ka kite i a ia, ka tohe kia haere atu ia i ō rātou wāhi. ");
INSERT INTO mri_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nā, ka eke ia ki te kaipuke, ka whiti ki tāwāhi, ka haere ki tōna pā. ");
INSERT INTO mri_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nā, ka kawea mai e rātou ki a ia tētahi pararūtiki, e takoto ana i runga i te moenga; nō te kitenga o Īhu i tō rātou whakapono ka mea ia ki te pararūtiki, “E tama, kia māia; ka oti ōu hara te muru.” ");
INSERT INTO mri_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nā, ka mea ētahi o ngā karaipi ki a rātou anō, “E kohukohu ana tēnei tangata!” ");
INSERT INTO mri_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ā, ka kite a Īhu i ō rātou whakaaro, ka mea ia, “He aha i kino ai ngā whakaaro o roto o ō koutou ngākau? ");
INSERT INTO mri_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ko tēhea oti te mea takoto noa, ko te mea, ‘Ka oti ōu hara te muru,’ ko te mea rānei, ‘Whakatika, haere’? ");
INSERT INTO mri_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Otirā, kia mātau ai koutou he mana muru hara tō te Tama a te tangata i runga i te whenua.” Kātahi ia ka mea ki te pararūtiki, “Whakatika, tangohia ake tōu moenga, ā, haere ki tōu whare.” ");
INSERT INTO mri_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nā, whakatika ana ia, haere ana ki tōna whare. ");
INSERT INTO mri_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nō te kitenga ia o te hui, ka wehi, ka whakakorōria i te Atua, i hōmai ai tēnei mana ki ngā tāngata. ");
INSERT INTO mri_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ā, i a Īhu e haere ana i reira, ka kite ia i tētahi tangata, ko Matiu te ingoa, e noho ana i te wāhi tango takoha; ā, ka mea ki a ia, “Arumia ahau.” Nā, whakatika ana ia, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ā, i a ia e noho ana ki te kai i roto i te whare, nā, he tokomaha ngā pupirikana me ngā tāngata hara i haere mai, i noho tahi ki a Īhu rātou ko āna ākonga. ");
INSERT INTO mri_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ā, nō te kitenga o ngā Parihi, ka mea ki āna ākonga, “He aha tō koutou Kaiwhakaako ka kai tahi ai me ngā pupirikana, me ngā tāngata hara?” ");
INSERT INTO mri_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Otirā, ka rongo a Īhu, ka mea ki a rātou, “Kāhore he aha o ngā tāngata ora e meatia ai e te rata, engari, o te hunga e mate ana. ");
INSERT INTO mri_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nā, haere, ākona te tikanga o tēnei, ‘Ko tāku e pai ai ko te tohu tangata, hāunga te patunga tapu’. Kīhai hoki ahau i haere mai ki te karanga i te hunga tika, engari i te hunga hara, kia rīpenetā.” ");
INSERT INTO mri_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Me i reira ka haere mai ki a ia ngā ākonga a Hoani, ka mea, “He aha i maha ai o mātou ko ngā Parihi nohoanga pukutanga, ā, kāhore āu ākonga e nohopuku?” ");
INSERT INTO mri_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nā, ka mea a Īhu ki a rātou, “E āhei rānei ngā tamariki o te whare mārena te tangi, i te mea kei a rātou te tāne mārena hou? Nā, tērā e tae mai ngā rā, e tangohia ai te tāne mārena hou i a rātou, ā, ko reira nohopuku ai rātou. ");
INSERT INTO mri_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“E kore e meatia e te tangata tētahi wāhi o te kahu hou hei pāpaki mō te kahu tawhito, nō te mea ka riro tētahi wāhi o taua kākahu i te whakakapi, ā, ka nui rawa te pakaru. ");
INSERT INTO mri_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","E kore e ringihia te wāina hou ki ngā ipu tawhito; kei pakaru ngā ipu, ā, ka maringi te wāina, kore ake ngā ipu; erangi, e ringihia ana te wāina hou ki ngā ipu hou, ā, ka ora taua rua.” ");
INSERT INTO mri_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","I a ia e kōrero ana i ēnei mea ki a rātou, nā, ka haere mai tētahi rangatira, ka koropiko ki a ia, ka mea, “Tēnei kua marere tāku tamāhine; otirā, māu e haere ake, e whakapā tōu ringa ki a ia, ā, ka ora.” ");
INSERT INTO mri_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nā, ka whakatika a Īhu rātou ko āna ākonga, ā, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nā, ko te haerenga ki muri i a ia o tētahi wahine, tekau mā rua ngā tau i mate ai i te pākaruhanga toto, ā, ka pā ki te tāniko o tōna kākahu; ");
INSERT INTO mri_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","i mea hoki i roto i a ia, “Kia pā kau oti ahau ki tōna kākahu, ka ora ahau.” ");
INSERT INTO mri_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nā, ka tahuri a Īhu, ā, ka kite i a ia, ka mea, “Kia māia, e kō! Nā tōu whakapono koe i ora ai.” Ā, ora ake te wahine i taua wā anō. ");
INSERT INTO mri_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nā, i te taenga o Īhu ki te whare o te rangatira, ka kite i ngā kaiwhakatangi pūtōrino, i te huihui hoki e ngangau ana, ");
INSERT INTO mri_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ka mea ia ki a rātou, “Whakaatea! Kāhore hoki i mate te kōtiro, erangi e moe ana.” Ā, kataina iho ia e rātou. ");
INSERT INTO mri_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Heoi, ka oti te huihui te pei ki waho, ka tomo ia ki roto, ka mau ki tōna ringa, ā, ara ake ana te kōtiro. ");
INSERT INTO mri_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ā, pakū ana tēnei rongo puta noa i taua whenua. ");
INSERT INTO mri_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ā, i a Īhu e haere atu ana i reira, tokorua ngā matapō i aru i a ia, ka karanga ake, ka mea, “E te Tama a Rāwiri, kia aroha ki a māua!” ");
INSERT INTO mri_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ā, ka tapoko ia ki te whare, ka haere atu ngā matapō ki a ia; nā, ka mea a Īhu ki a rāua, “E whakapono ana rānei kōrua e taea tēnei e ahau?” Ka mea rāua ki a ia, “Āe, e te Ariki.” ");
INSERT INTO mri_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Me i reira ka pā ia ki ō rāua kanohi, ka mea, “Kia rite ki tō kōrua whakapono te meatanga ki a kōrua.” ");
INSERT INTO mri_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nā, kua kite ō rāua kanohi; kātahi ka whakatūpato a Īhu i a rāua ka mea, “Kia mahara kei rangona e te tangata.” ");
INSERT INTO mri_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ko rāua ia i puta atu ki waho, ā, kōrerotia nuitia ana ia puta noa i taua whenua. ");
INSERT INTO mri_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","I a rāua e puta ana ki waho, ka kawea mai ki a ia tētahi tangata wahangū, he rēwera tōna. ");
INSERT INTO mri_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ā, ka oti te rēwera te pei, ka whai reo te wahangū; ā, mīharo ana te mano, ka mea, “Kāhore anō i kitea te pēnei i roto i a Īharaira.” ");
INSERT INTO mri_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Otirā, ka mea ngā Parihi, “Nā te rangatira o ngā rēwera tāna peinga rēwera.” ");
INSERT INTO mri_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nā, ka hāereerea e Īhu ngā pā katoa me ngā kāinga, ā, ka ako i roto i ō rātou whare karakia, ka kauwhau i te rongopai o te rangatiratanga, me te whakaora i te tini o ngā mate, i te tini o ngā tūrorotanga o te iwi. ");
INSERT INTO mri_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ā, nō tōna kitenga i ngā mano, ka toko ake tōna ngākau aroha ki a rātou, e māuiui ana hoki rātou, e marara kē ana, me he hipi hēparakore. ");
INSERT INTO mri_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kātahi, ia ka mea ki āna ākonga, “He nui te kotinga, ko ngā kaimahi ia he ruarua. ");
INSERT INTO mri_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nā, īnoi atu ki te Ariki nāna te kotinga, kia tonoa e ia he kaimahi ki tāna kotinga.” ");
INSERT INTO mri_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ā, ka oti te karanga e ia āna ākonga i tekau mā rua, ka hoatu ki a rātou he mana hei pei i ngā wairua poke, hei whakaora hoki i ngā mate katoa me ngā tūrorotanga katoa. ");
INSERT INTO mri_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nā, ko ngā ingoa ēnei o ngā āpōtoro kotahi tekau mā rua; te tuatahi ko Haimona, e kīa nei ko Pita, rāua ko tōna teina ko Anaru; ko Hēmi tama a Heperi rāua ko tōna teina ko Hoani; ");
INSERT INTO mri_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ko Piripi rāua ko Patoromu; ko Tamati rāua ko Matiu pupirikana; ko Hēmi tama a Arapiu, ko Tariu; ");
INSERT INTO mri_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ko Haimona Kanaani rāua ko Hūrā Ikariote, nāna nei ia i tuku. ");
INSERT INTO mri_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ko tēnei tekau mā rua i tonoa e Īhu, i ako ia i a rātou, i mea: “Kaua e haere ki tētahi ara o ngā tauiwi, kaua anō hoki e tomo ki tētahi pā o ngā Hamari; ");
INSERT INTO mri_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","engari, me haere ki ngā hipi ngaro o te whare o Īharaira. ");
INSERT INTO mri_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Me kauwhau haere hoki, me kī, ‘Kua tata te rangatiratanga o te rangi.’ ");
INSERT INTO mri_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Whakaorangia ngā tūroro, meinga kia mā ngā repera, whakaarahia ngā tūpāpaku, peia ngā rēwera; ka riro noa nei i a koutou, me hoatu noa e koutou. ");
INSERT INTO mri_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kaua he kōura mā koutou, kaua he hiriwa, kaua he parāhi ki roto ki ō koutou whītiki; ");
INSERT INTO mri_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","kaua anō he pūtea mō te ara; kaua e takiruatia ngā koti, kaua he hū, kaua anō he tokotoko. Ka ea hoki i te kaimahi tāna kai. ");
INSERT INTO mri_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ā, ka tomo koutou ki tētahi pā, ki tētahi kāinga rānei, ui atu, ko wai te tangata pai o reira; ā, hei reira noho ai, ā, haere noa. ");
INSERT INTO mri_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ā, nō ka tomo ki tētahi whare, me oha atu. ");
INSERT INTO mri_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ā, ki te pai te whare, kia tau tā koutou rangimārie ki reira; ā, ki te kāhore e pai, kia hoki tā koutou rangimārie ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ki te kāhore hoki tētahi e manako ki a koutou, ki te kore e whakarongo ki ā koutou kupu, ka haere koutou ki waho o taua whare, o taua pā rānei, ka whakangahoro i te puehu o ō koutou waewae. ");
INSERT INTO mri_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","He pono tāku e mea nei ki a koutou, erangi tō te whenua o Horoma rāua ko Komora ā te rā whakawā e māmā i tō taua pā.” ");
INSERT INTO mri_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nana, ka tonoa nei koutou e ahau ānō he hipi ki roto ki ngā wuruhi. Nā, kia rite ki te nākahi te mahara, ki te kūkupa hoki te māhaki. ");
INSERT INTO mri_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kia tūpato ia i ngā tāngata; tērā hoki koutou e tukua e rātou ki ngā rūnanga, ā, tērā koutou e whiua i roto i ō rātou whare karakia. ");
INSERT INTO mri_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ā, ka kawea koutou ki ngā kāwana, ki ngā kīngi, mō te whakaaro ki ahau, hei mea whakaatu ki a rātou, ki ngā tauiwi hoki. ");
INSERT INTO mri_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ā, nō ka tukua koutou e rātou, kaua e mānukanuka ki te pēhea, ki te aha, e kōrero ai koutou; ka hoatu ki a koutou i taua wā tā koutou e kōrero ai. ");
INSERT INTO mri_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ehara hoki i a koutou ngā kōrero, engari, ko te Wairua o tō koutou Matua te kōrero ana i roto i a koutou. ");
INSERT INTO mri_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nā, ka tukua te tuakana e te teina ki te mate, te tama hoki e te pāpā; ka whakatika ngā tamariki ki ngā mātua, ka mea kia whakamatea; ");
INSERT INTO mri_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ā, ka kinongia koutou e ngā tāngata katoa, he mea hoki mō tōku ingoa; ko te tangata ia e ū ana ā taea noatia te mutunga, ka ora ia. ");
INSERT INTO mri_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nā, ki te whakatoia koutou i tēnei pā, rere atu ki tētahi; he pono hoki tāku e mea nei ki a koutou, e kore e poto i a koutou ngā pā o Īharaira te haere, ko te Tama a te tangata kua tae mai. ");
INSERT INTO mri_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kāhore e nui ake te ākonga i tōna kaiwhakaako, kāhore hoki te pononga e nui ake i tōna rangatira. ");
INSERT INTO mri_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Heoi, mā te ākonga ko ia kia rite ki tōna kaiwhakaako, mā te pononga kia rite ki tōna rangatira. Ki te kīa e rātou te rangatira o te whare ko Perehepura, tērā noa ake tā rātou mō ngā tāngata o tōna whare.” ");
INSERT INTO mri_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nā, kaua e wehi i a rātou; kāhore hoki he mea i hīpokina e mahue te hura, he mea rānei i huna e mahue te mōhio. ");
INSERT INTO mri_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ko tāku e kōrero nei ki a koutou i te pōuri, me kōrero e koutou i te mārama; ko tā ō koutou taringa e rongo ai, me kauwhau ki runga i ngā whare. ");
INSERT INTO mri_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ā, kaua e wehi i te hunga e whakamate nei i te tinana, ā, e kore nei e āhei te whakamate i te wairua; engari ia ko tā koutou e wehi ai, ko ia e kaha nei ki te whakangaro i te wairua rāua tahi ko te tinana ki roto ki Kehena. ");
INSERT INTO mri_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kāhore ianei e hokona ngā pīhoihoi e rua ki te pātene kotahi? Ā, ki te kāhore tō koutou Matua e mea, e kore tētahi o rāua e taka ki te whenua. ");
INSERT INTO mri_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Otiia, ko ngā makawe o ō koutou mātenga kua oti katoa te tatau. ");
INSERT INTO mri_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nō reira, kaua e wehi; erangi rā koutou i ngā pīhoihoi maha.” ");
INSERT INTO mri_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nā, ki te whakaae tētahi ki ahau i te aroaro o ngā tāngata, ka whakaaetia ia e ahau i te aroaro o tōku Matua i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ā, ki te whakakāhore tētahi i ahau i te aroaro o ngā tāngata, ka whakakāhoretia hoki ia e ahau i te aroaro o tōku Matua i te rangi.” ");
INSERT INTO mri_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kei mea i haere mai ahau ki te kawe mai i te rangimārie ki te whenua; kīhai ahau i haere mai ki te kawe mai i te rangimārie, engari i te hoari. ");
INSERT INTO mri_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","I haere mai hoki ahau ki te mea i te tangata kia whawhai ki tōna pāpā, i te tamāhine ki tōna whaea, i te hunaonga wahine ki tōna hungawai wahine; ");
INSERT INTO mri_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ā, ko ō te tangata hoariri ko ngā tāngata anō o tōna whare. ");
INSERT INTO mri_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ki te nui ake te aroha o tētahi ki tōna pāpā, whaea rānei, i tōna ki ahau, e kore ia e tikangatia māku; ki te nui ake hoki te aroha o tētahi ki tāna tama, tamāhine rānei, i tōna ki ahau, e kore ia e tikangatia māku. ");
INSERT INTO mri_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ki te kore hoki tētahi e mau ki tōna rīpeka, e aru i muri i ahau, e kore ia e tikangatia māku. ");
INSERT INTO mri_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ko te tangata i whiwhi ki te ora e mate anō ia, ā, ki te mate tētahi mōna i whakaaro ki ahau, ka whiwhi anō ia ki te ora.” ");
INSERT INTO mri_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ki te manako tētahi ki a koutou, e manako ana ia ki ahau, ā, ki te manako tētahi ki ahau, e manako ana ia ki tōku kaitono mai. ");
INSERT INTO mri_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ki te manako tētahi ki te poropiti i runga i te ingoa o te poropiti, ka riro i a ia te utu o te poropiti; ā, ki te manako tētahi ki te tangata tika i runga i te ingoa o te tangata tika, e riro i a ia te utu o te tangata tika. ");
INSERT INTO mri_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ā, ki te whakainumia e tētahi tētahi o ēnei mea nonohi, ahakoa kotahi anō te kapu wai mātao, i runga i te ingoa o te ākonga, he pono tāku e mea nei ki a koutou, e kore rawa ia e hapa i tōna utu.” ");
INSERT INTO mri_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ā, ka mutu tā Īhu whakarite kōrero ki āna ākonga kotahi tekau mā rua, ka haere atu ia i reira ki te whakaako, ki te kauwhau ki ō rātou pā. ");
INSERT INTO mri_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nā, i te rongonga o Hoani i roto i te whare herehere ki ngā mahi a te Karaiti, ka tonoa e ia ētahi o āna ākonga, ");
INSERT INTO mri_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ka mea ki a ia, “Ko koe rānei tēnei e haere mai nei, me tatari rānei tātou ki tētahi atu?” ");
INSERT INTO mri_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nā, ka whakahoki a Īhu, ka mea ki a rāua, “Haere, kōrerotia ki a Hoani ngā mea e rongo nei, e kite nei kōrua: ");
INSERT INTO mri_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ko ngā matapō e titiro ana, ko ngā kopa e hāereere ana, ko ngā repera e meinga ana kia mā, ko ngā turi e rongo ana, ko ngā tūpāpaku e whakaarahia ana, ā, e kauwhautia ana te rongopai ki te hunga rawakore. ");
INSERT INTO mri_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ā, ka koa te tangata e kore e hē ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ā, i a rāua e haere atu ana, ka tīmata a Īhu, ka kōrerotia a Hoani ki te mano: “I haere koutou ki te koraha kia kite i te aha? I te kākaho e whakangāueuetia ana e te hau? ");
INSERT INTO mri_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Anō rā, i haere koutou kia kite i te aha? I te tangata he kākahu māeneene ōna? Nā, kei ngā whare kīngi te hunga i ngā kākahu māeneene. ");
INSERT INTO mri_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Anō rā, i haere koutou kia kite i te aha? I te poropiti? Āe rā, ko tāku kupu tēnei ki a koutou, tērā atu anō i te poropiti. ");
INSERT INTO mri_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ko ia hoki tēnei mōna te mea i tuhituhia: ‘Nā, ka tonoa e ahau tāku karere ki mua i tōu aroaro, māna e whakapai tōu ara ki mua i a koe.’ ");
INSERT INTO mri_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","He pono tāku e mea nei ki a koutou, kāhore anō i maea ake i roto i ngā whānau a te wahine he rahi ake i a Hoani Kaiiriiri; heoi, rahi ake i a ia te iti rawa i te rangatiratanga o te rangi. ");
INSERT INTO mri_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ā, nō ngā rā mai anō i a Hoani Kaiiriiri ā mohoa noa nei e tūkinotia ana te rangatiratanga o te rangi, ā, e riro ana ia i te ringa kaha o ngā tāngata taikaha. ");
INSERT INTO mri_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nō te mea i poropiti ngā poropiti katoa me te ture ā taea noatia a Hoani. ");
INSERT INTO mri_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ā, ki te pai koutou koia rā, ko Irāia tēnei, i meinga rā e haere mai ana. ");
INSERT INTO mri_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ki te whai taringa tētahi hei whakarongo, kia rongo ia! ");
INSERT INTO mri_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Otiia, me whakarite e ahau tēnei whakatupuranga ki te aha? E rite ana ki ngā tamariki e noho ana i ngā wāhi hokohoko, e karanga ana ki ō rātou hoa, ");
INSERT INTO mri_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","e mea ana, ‘Whakatangi noa mātou i te pūtōrino ki a koutou, ā, kāhore koutou i kanikani mai. Auē noa mātou ki a koutou, ā, kāhore koutou i tangi mai.’ ");
INSERT INTO mri_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","I haere mai hoki a Hoani, kīhai i kai, kīhai i inu, heoi e mea ana rātou, ‘He rēwera tōna.’ ");
INSERT INTO mri_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","I haere mai te Tama a te tangata me te kai me te inu, ka mea rātou, ‘Nā, he tangata kakai, he tangata inu wāina, he hoa nō ngā pupirikana, nō ngā tāngata hara!’ Otirā, mā āna mahi e whakatika te whakaaro nui.” ");
INSERT INTO mri_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kātahi ia ka anga, ka tāwai ki ngā pā i meinga ai te maha o āna merekara, mō rātou kīhai i rīpenetā. ");
INSERT INTO mri_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Auē, te mate mōu, e Korahina! auē, te mate mōu, e Petahaira! Me i meatia ki Tāira, ki Hairona ngā merekara kua meatia nei ki a kōrua, kua rīpenetā kē rāua, he taratara te kākahu me te oke i te pungarehu. ");
INSERT INTO mri_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ko tāku kupu ia tēnei ki a koutou, Erangi, tō Tāira rāua ko Hairona e māmā i te rā whakawā i tō kōrua. ");
INSERT INTO mri_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Me koe hoki, e Kaperenauma, e whakateiteitia rānei koe ā tae noa ki te rangi? Ka heke koe ki te rēinga. Me i meatia hoki ki Horoma ngā merekara kua meatia nei ki a koe, kua tū tonu tērā, ā taea noatia tēnei rā. ");
INSERT INTO mri_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ko tāku kupu ia tēnei ki a koutou, Erangi, tō te whenua o Horoma e māmā i tōu i te rā whakawā.” ");
INSERT INTO mri_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","I taua wā ka oho a Īhu, ka mea “He whakawhetai atu tāku ki a koe, e Pā, e te Ariki o te rangi o te whenua, nō te mea kua hunā e koe ēnei mea i te hunga mātau, i te hunga mahara, ā, hurahia ana ki ngā kōhungahunga. ");
INSERT INTO mri_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Āe rā, e Pā, i pai hoki te pēnei ki tāu titiro. ");
INSERT INTO mri_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Kua tukua mai ngā mea katoa ki ahau e tōku Matua. Ā, kāhore tētahi e mātau ki te Tama, ko te Matua anake; kāhore hoki tētahi e mātau ki te Matua, ko te Tama anake, me te tangata hoki e pai ai te Tama kia whakakitea ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Haere mai ki ahau, e koutou katoa e māuiui ana, e taimaha ana, ā, māku koutou e whakaokioki. ");
INSERT INTO mri_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tangohia tāku ioka ki runga ki a koutou, kia whakaakona koutou e ahau; he ngākau māhaki hoki tōku, he ngākau pāpaku; ā, e whiwhi koutou ki te okiokinga mō ō koutou wairua. ");
INSERT INTO mri_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","He ngāwari hoki tāku ioka, he māmā tāku pīkaunga.” ");
INSERT INTO mri_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","I taua wā i haere a Īhu i te hāpati rā waenga wīti; ā, e hiakai ana āna ākonga, nā, ka anga rātou, ka kato i ngā wīti, ka kai. ");
INSERT INTO mri_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ā, nō te kitenga o ngā Parihi, ka mea ki a ia, “Nā, āu ākonga e mea nā i te mea e kore e tika kia meinga i te hāpati.” ");
INSERT INTO mri_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ka mea ia ki a rātou, “Kāhore koutou i kite i tā Rāwiri i mea ai, i a ia e hiakai ana, rātou ko ōna hoa? ");
INSERT INTO mri_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I tōna tomokanga ki te whare o te Atua, i tāna kainga i ngā taro aroaro, i ngā mea kīhai nei i tika kia kainga e ia, e ōna hoa rānei, engari, mā ngā tohunga anake? ");
INSERT INTO mri_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kāhore anō koutou i kite i roto i te ture, e whakanoatia ana te hāpati e ngā tohunga i roto i te temepara i ngā hāpati, ā, kāhore he hē? ");
INSERT INTO mri_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ko tāku kupu ia tēnei ki a koutou, kei konei tētahi, he rahi kē i te temepara. ");
INSERT INTO mri_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Otiia, me i mātau koutou ki tēnei, ‘Ko tāku e pai ai ko te tohu tangata, hāunga te patunga tapu.’ Kāhore koutou i whakahē i te hunga harakore; ");
INSERT INTO mri_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ko te Tama nei hoki a te tangata te Ariki o te hāpati.” ");
INSERT INTO mri_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nā, ka haere atu ia i reira, ka tomo ki tō rātou whare karakia; ");
INSERT INTO mri_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","nā, he tangata tērā kua memenge te ringa. Ā, ka ui rātou ki a ia, “He tika rānei te whakaora i te hāpati?” He mea hoki kia whakapāngia ai e rātou he hē ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nā, ka mea ia ki a rātou, “Ko tēhea tangata o koutou, ki te mea kotahi āna hipi, ā, ka taka ki roto ki te poka i te hāpati, e kore rānei ia e mau ki taua hipi, e hāpai ake? ");
INSERT INTO mri_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nā, tērā noa atu tō te tangata pai i tō te hipi. Inā, he tika anō te mahi pai i ngā hāpati”. ");
INSERT INTO mri_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Me i reira ka mea ia ki taua tangata, “Totoro mai tōu ringa.” Ā, nō te toronga, kua ora anō, kua pērā me tētahi. ");
INSERT INTO mri_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nā, ka haere ngā Parihi ki waho, ka rūnanga mōna me pēhea e ngaro ai ia i a rātou. ");
INSERT INTO mri_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Otirā, i mātau a Īhu, ā, haere atu ana i reira; ā, he rahi te hui i aru i a ia, ā, whakaorangia ana rātou katoa e ia; ");
INSERT INTO mri_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ā, i whakatūpato anō ia i a rātou kei whakakitea ia. ");
INSERT INTO mri_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nā, ka rite tā Ihāia poropiti i kōrero ai, i mea ai: ");
INSERT INTO mri_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nā, tāku pononga, tāku i whiriwhiri ai, tāku i aroha ai, tā tōku Wairua i āhuareka ai. Ka waiho e ahau tōku Wairua ki runga ki a ia, ā, māna e whakapuaki te whakawā ki ngā tauiwi. ");
INSERT INTO mri_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","E kore ia e totohe, e kore ia e hāmama, e kore anō e rangona tōna reo i ngā ara. ");
INSERT INTO mri_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","E kore e whatia porokeretia e ia te kākaho i mangungu, e kore e tineia te muka e whakapaoa ana. Kia puta rā anō i a ia te whakawā ki te wikitōria, ");
INSERT INTO mri_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ka tūmanako hoki ngā tauiwi ki tōna ingoa.” ");
INSERT INTO mri_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Me i reira ka kawea mai ki a ia he tangata e nohoia ana e te rēwera, he matapō, he wahangū; ā, whakaorangia ana e ia, nō ka kōrero, ka kite taua matapō, taua wahangū. ");
INSERT INTO mri_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ā, ka ohomauri te mano katoa, ka mea, “Ehara ianei tēnei i te Tama a Rāwiri?” ");
INSERT INTO mri_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ā, nō te rongonga o ngā Parihi, ka mea, “Ehara i a ia nāna i pei ngā rēwera nei, engari, nā Perehepura, nā te rangatira o ngā rēwera.” ");
INSERT INTO mri_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ā, i mātau a Īhu ki ō rātou whakaaro, ka mea ki a rātou, “Ki te tahuri iho tētahi rangatiratanga ki a ia anō, ka kore; ki te tahuri iho hoki ki a ia anō tētahi pā, tētahi whare rānei, e kore e tū. ");
INSERT INTO mri_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nā, ki te pei a Hātana i a Hātana anō, e tahuri iho ana ki a ia anō; me pēhea e tū ai tōna rangatiratanga? ");
INSERT INTO mri_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ā, ki te mea nā Perehepura tāku peinga rēwera, nā wai te peinga a ā koutou tamariki? Nā, ko rātou hei kaiwhakawā mō koutou. ");
INSERT INTO mri_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tēnā, ki te mea nā te Wairua o te Atua tāku peinga rēwera, inā, kua tae noa mai te rangatiratanga o te Atua ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Me pēhea oti ka tomo ai te tangata ki te whare o te tangata kaha, ka pāhua ai i ōna taonga, ki te kore ia e mātua here i taua tangata kaha? Ko reira pāhua ai i tōna whare. ");
INSERT INTO mri_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ko te tangata ehara i te hoa nōku, he hoariri ia ki ahau; ko te tangata kāhore e kohikohi tahi māua, e tītaritari ana. ");
INSERT INTO mri_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Koia ahau ka mea nei ki a koutou, ko ngā hara katoa me ngā kohukohu a te tangata e murua; tēnā ko te kohukohu ki te Wairua Tapu e kore e murua. ");
INSERT INTO mri_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ki te kōrero whakahē hoki tētahi mō te Tama a te tangata, e murua tāna; tēnā ki te kōrero whakahē tētahi mō te Wairua Tapu, e kore e murua tāna i tēnei ao, e kore anō i tērā atu.” ");
INSERT INTO mri_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Meinga rānei te rākau kia pai, ā, pai iho ōna hua; meinga rānei te rākau kia kino, ā, kino iho ōna hua; mā ngā hua hoki ka mōhiotia ai te rākau. ");
INSERT INTO mri_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E te uri nākahi, me pēhea ka kōrero pai ai koutou, te hunga kino? He pūrenatanga hoki nō te ngākau ngā kupu a te māngai. ");
INSERT INTO mri_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ko te tangata pai he pai ana e whakaputa ai i roto i ngā taonga pai o te ngākau; ko te tangata kino hoki he kino ana e whakaputa ai i roto i ngā taonga kino. ");
INSERT INTO mri_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nā, ko tāku kupu tēnei ki a koutou, me kōrero e ngā tāngata, i te rā whakawā, te tikanga o ngā kupu pokanoa katoa e puaki i a rātou. ");
INSERT INTO mri_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mā āu kupu hoki koe ka whakatikaia ai, mā āu kupu anō ka tau ai te hē ki a koe.” ");
INSERT INTO mri_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Me i reira ka kī ētahi o ngā karaipi, o ngā Parihi, ka mea, “E te Kaiwhakaako, e mea ana mātou kia kite i tētahi tohu i a koe.” ");
INSERT INTO mri_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nā, ka whakahoki ia, ka mea ki a rātou, “E rapu ana te whakatupuranga kino, pūremu, i tētahi tohu; ā, e kore tētahi tohu e hoatu, ko te tohu anake o Hona poropiti. ");
INSERT INTO mri_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E toru hoki ngā rā o Hona, e toru ngā pō, i roto i te kōpū o te tohorā; waihoki ka toru ngā rā, ka toru ngā pō o te Tama a te tangata ki te manawa o te whenua. ");
INSERT INTO mri_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","E ara ngā tāngata o Ninewe me tēnei whakatupuranga i te whakawākanga, e whakatau i te hē ki a rātou; i rīpenetā hoki rātou i te kauwhau a Hona; ā, tēnei tētahi he nui kē i a Hona. ");
INSERT INTO mri_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","E ara te kuīni o te tonga me tēnei whakatupuranga i te whakawākanga, e whakatau i te hē ki a rātou; i haere mai hoki ia i ngā pito o te whenua ki te whakarongo ki ngā whakaaro nui o Horomona; ā, tēnei tētahi he nui kē i a Horomona.” ");
INSERT INTO mri_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ka puta mai te wairua poke i roto i te tangata, ka hāereere rā ngā wāhi maroke rapu okiokinga ai, ā, tē kitea, ");
INSERT INTO mri_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ka mea ia, ‘Ka hoki ahau ki tōku whare i puta mai ai ahau.’ Ā, nō te taenga atu, rokohanga atu e takoto kau ana, oti rawa te tahi, te whakapai. ");
INSERT INTO mri_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nā, ka haere ia, ka tango i ētahi atu wairua tokowhitu hei hoa mōna, he kino noa atu i a ia, ka tomo rātou, ka noho ki reira; ā, kino atu i te tīmatanga te whakamutunga ki taua tangata. Tērā anō e pērā tēnei whakatupuranga kino.” ");
INSERT INTO mri_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","I a ia anō e kōrero ana ki te mano, nā, ko tōna whaea rātou ko ōna tēina e tū ana i waho, e whai ana kia kōrero ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ā, ka mea tētahi ki a ia, “Nā, tōu whaea me ōu tēina te tū mai nei i waho, e whai ana kia kōrero ki a koe.” ");
INSERT INTO mri_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nā, ka whakahoki ia, ka mea ki te tangata i kōrero ki a ia, “Ko wai tōku whaea? Ko wai hoki ōku tēina?” ");
INSERT INTO mri_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nā, ka totoro tōna ringa ki āna ākonga, ka mea, “Nā, tōku whaea, ōku tēina! ");
INSERT INTO mri_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ki te meatia hoki e tētahi tā tōku Matua i te rangi e pai ai, hei teina ia ki ahau, hei tuahine, hei whaea.” ");
INSERT INTO mri_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","I taua rā i haere atu a Īhu i te whare, ka noho ki te taha o te moana. ");
INSERT INTO mri_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nā, he rahi te hui i huihui ki a ia, ā, ka eke ia ki te kaipuke noho ai; i te takutai anō te hui katoa e tū ana. ");
INSERT INTO mri_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ā, he maha āna kōrero ki a rātou, he mea whakarite; i mea ia: “Nā, i haere te kairui ki te rui. ");
INSERT INTO mri_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ā, i a ia e rui ana, ka ngahoro ētahi o ngā purapura ki te taha o te ara, ā, ko te rerenga mai o ngā manu, kainga ake. ");
INSERT INTO mri_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ko ētahi i ngahoro ki ngā wāhi kāmaka, ki ngā wāhi kīhai i nui te oneone; nā, pihi tonu ake, kāhore hoki i hōhonu te oneone. ");
INSERT INTO mri_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ā, nō te whitinga o te rā, ngaua iho; ā, nō te mea kāhore he pūtake, memenge noa iho. ");
INSERT INTO mri_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ko ētahi i ngahoro ki roto ki ngā tātarāmoa; ā, nō te tupunga ake o ngā tātarāmoa, kōwaowaotia ana ngā purapura. ");
INSERT INTO mri_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ko ētahi i ngahoro ki te oneone pai, ā, ka hua, nō ētahi kotahi rau, nō ētahi e ono tekau, nō ētahi e toru tekau. ");
INSERT INTO mri_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Ki te whai taringa tētahi hei whakarongo, kia rongo ia.” ");
INSERT INTO mri_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ā, ka haere ngā ākonga, ka mea ki a ia, “He aha koe i kōrero whakarite tonu ai ki a rātou?” ");
INSERT INTO mri_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nā, ka whakahoki ia ki a rātou, ka mea, “Nō te mea kua hoatu ki a koutou te mātauranga ki ngā mea ngaro o te rangatiratanga o te rangi, ki a rātou ia kāhore i hoatu. ");
INSERT INTO mri_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ki te whai mea hoki tētahi, ka hoatu anō ki a ia, ā, ka maha atu ana. Ki te kāhore ia he mea a tētahi, ka tangohia i a ia āna ake. ");
INSERT INTO mri_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nā reira ēnei kupu whakarite āku ki a rātou; nō te mea kite rawa rātou, ā, kāhore e kite; rongo rawa, kāhore hoki e mātau. ");
INSERT INTO mri_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ā, ka rite i a rātou te poropititanga a Ihāia, e mea nei: ‘Rongo noa koutou, kāhore e mātau; titiro noa koutou, kāhore e kite. ");
INSERT INTO mri_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kua mātotoru hoki te ngākau o tēnei iwi, kua pūhoi ngā taringa ki te whakarongo, ko ngā kanohi kua oti te whakamoe e rātou; kei kite ō rātou kanohi, kei rongo ngā taringa, ā, ka mātau te ngākau, nā, ka tahuri rātou, ā, ka whakaorangia e ahau.’ ");
INSERT INTO mri_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ka koa ia ō koutou kanohi, nō te mea ka kite; ō koutou taringa hoki, nō te mea ka rongo. ");
INSERT INTO mri_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","He pono hoki tāku e mea nei ki a koutou, he tokomaha ngā poropiti me ngā tāngata tika i hiahia kia kite i ngā mea e kite nei koutou, ā, kāhore i kite; kia rongo hoki i ngā mea e rongo nei koutou, ā, kāhore i rongo.” ");
INSERT INTO mri_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nā, whakarongo ki te kupu i whakaritea ki te kairui. ");
INSERT INTO mri_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ki te rongo tētahi ki te kupu o te rangatiratanga, ā, e kore e mātau, nā, ka haere mai te wairua kino, ka kapo i te mea ka oti nā te rui ki tōna ngākau. Ko te tangata tēnei i ngā purapura i te taha o te ara. ");
INSERT INTO mri_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ko te tangata ia i ngā purapura i ngā wāhi kōhatu, ko te tangata i rongo ki te kupu, ā, hohoro tonu te tango, hari tonu; ");
INSERT INTO mri_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Otiia, kāhore ōna pakiaka i roto i a ia, e mau noa ana mō te wā poto, ā, nō te pānga o te whakapāwera, o te whakatoi rānei, mō te kupu, nā hē tonu iho. ");
INSERT INTO mri_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ko te tangata i ngā purapura i waenga tātarāmoa, ko te tangata tēnā i rongo ki te kupu; ā, ko te whakaaronga ki tēnei ao, me te hangarau o ngā taonga, hei whakakōwaowao i te kupu, ā, kore ake he hua. ");
INSERT INTO mri_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ko te tangata ia i ngā purapura i te oneone pai, ko te tangata e rongo ana ki te kupu, ā, e mātau ana; ā, ka whai hua, ea ake, nō tētahi kotahi rau, nō tētahi e ono tekau, nō tētahi e toru tekau.” ");
INSERT INTO mri_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tēnei ake anō tētahi kupu whakarite i makā e ia ki a rātou, i mea ia: “Ka rite te rangatiratanga o te rangi ki tētahi tangata i rui i te purapura pai ki tāna māra. ");
INSERT INTO mri_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ā, i ngā tāngata e moe ana, ka haere mai tōna hoariri, ruia iho he taru kino ki waenga wīti, ā, haere ana. ");
INSERT INTO mri_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ā, nō ka pihi ake te rau, ka hua, kātahi ka kitea hoki ngā taru. ");
INSERT INTO mri_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nā, ka haere mai ngā pononga a taua rangatira, ka mea ki a ia, ‘E mara, kīhai ianei koe i rui i te purapura pai ki tāu māra? Nō hea rā ōna taru?’ ");
INSERT INTO mri_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nā, ka kī atu ia ki a rātou, ‘Nā te hoariri tēnei i mea.’ Kātahi, ka mea ngā pononga ki a ia, ‘E pai rānei koe kia haere mātou ki te whakawhāiti i aua taru?’ ");
INSERT INTO mri_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ā, ka mea ia, ‘Kāhore; kei hūtia ngātahitia te wīti ina whakawhāititia ngā taru. ");
INSERT INTO mri_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tukua kia tupu tahi, ā taea noatia te kotinga; ā, i te wā o te kotinga ka mea ahau ki ngā kaikokoti, Mātua whakawhāiti i ngā taru, ka paihere ai hei paihere kia tahuna; ko te wīti ia me kohi ki tōku whare wīti.’ ” ");
INSERT INTO mri_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tēnei ake anō tētahi kupu whakarite i makā e ia ki a rātou, i mea ia: “He rite te rangatiratanga o te rangi ki te pua nanī, i kawea e te tangata, i ruia ki tāna māra. ");
INSERT INTO mri_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","He iti rawa ia i ngā purapura katoa, ā, ka tupu, ko ia te nui rawa o ngā otaota, ā, whakarākau ana, nō ka rere mai ngā manu o te rangi, ka noho ki ōna manga.” ");
INSERT INTO mri_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tēnei ake anō tētahi kupu whakarite i kōrerotia e ia ki a rātou: “He rite te rangatiratanga o te rangi ki te rēwena i tangohia e tētahi wahine, ā, whaongia ana ki roto ki ngā mēhua parāoa e toru, nō ka rēwenatia katoatia.” ");
INSERT INTO mri_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ko ēnei mea katoa i kōrerotia e Īhu ki te mano, he mea whakarite; ā, heoi anō āna kupu ki a rātou he kupu whakarite anake. ");
INSERT INTO mri_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I rite ai tā te poropiti i kōrero ai, i mea ai: “E puaki i tōku māngai ngā kupu whakarite; ka kōrerotia e ahau ngā mea i ngaro nō te tīmatanga rā anō o te ao.” ");
INSERT INTO mri_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kātahi ka mahue i a Īhu te mano, ka tomo ia ki te whare. Nā, ka haere mai āna ākonga ki a ia, ka mea, “Whakaaturia mai ki a mātou te kupu i whakaritea ki ngā taru i te māra.” ");
INSERT INTO mri_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nā, ka whakahoki ia, ka mea ki a rātou, “Ko te kairui o te purapura pai ko te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ko te māra ko te ao; ko te purapura pai ko ngā tamariki o te rangatiratanga; ngā taru ko ngā tamariki a te kino; ");
INSERT INTO mri_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ko te hoariri i ruia ai ko te rēwera; te kotinga ko te mutunga o te ao; ngā kaikokoti ko ngā anahera. ");
INSERT INTO mri_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nā, e huihuia ana ngā taru, e tahuna ana ki te ahi; ka pērā anō i te mutunga o tēnei ao. ");
INSERT INTO mri_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ka tono te Tama a te tangata i āna anahera ki te huihui i roto i tōna rangatiratanga i ngā mea katoa e tūtuki ai te waewae, i ngā kaimahi anō i te kino; ");
INSERT INTO mri_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ā, ka makā e rātou ki roto ki te oumu ahi; ko te wāhi tērā o te tangi me te tetēā o ngā niho. ");
INSERT INTO mri_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ko reira te hunga tika whiti ai me te rā i te rangatiratanga o tō rātou Matua. Ki te whai taringa tētahi hei whakarongo, kia rongo ia.” ");
INSERT INTO mri_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“He rite anō te rangatiratanga o te rangi ki te taonga i hunā ki te māra; nō te kitenga a tētahi tangata, nā, ka hunā e ia, ā haere ana, he koa hoki nōna, nā hokona ana āna mea katoa, ā, hokona ana mai taua māra māna.” ");
INSERT INTO mri_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“He rite anō te rangatiratanga o te rangi ki te kaihokohoko, e rapu ana i ngā peara papai. ");
INSERT INTO mri_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ā, nō tōna kitenga i tētahi peara utu nui, haere ana, hokona ana āna mea katoa, ā, hokona ana mai taua peara māna.” ");
INSERT INTO mri_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“He rite anō te rangatiratanga o te rangi ki te kupenga i tukua ki te moana, ā, haoa ana he ika o ia āhua, o ia āhua. ");
INSERT INTO mri_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ā, ka kī, ka kūmea ki uta, ā, noho ana, kohikohia ana ngā ika papai ki ngā kete, ko ngā mea kikino ia i ākiritia ki waho. ");
INSERT INTO mri_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ka pērā anō a te mutunga o te ao. Ka haere ngā anahera, ka wehewehe i te hunga kino i roto i te hunga tika, ");
INSERT INTO mri_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ā, ka maka i a rātou ki roto ki te oumu ahi; ko te wāhi tērā o te tangi, o te tetēā o ngā niho.” ");
INSERT INTO mri_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ka mea a Īhu ki a rātou, “Kua mātau rānei koutou ki ēnei mea katoa?” Ka mea rātou ki a ia, “Āe, e te Ariki.” ");
INSERT INTO mri_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nā, ka mea ia ki a rātou, “Koia te karaipi, i ākona ki te rangatiratanga o te rangi, i rite ai ki tētahi rangatira whare e whakaputa mai ana i ngā mea hou, i ngā mea tawhito, i roto i tāna toa.” ");
INSERT INTO mri_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ā, ka mutu ēnei kupu whakarite a Īhu, ka haere atu ia i reira. ");
INSERT INTO mri_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ā, ka tae ki tōna kāinga tupu ka ako i a rātou i roto i tō rātou whare karakia, ā, mīharo noa rātou, ka mea, “Nō hea ēnei whakaaro nui me ngā merekara a tēnei tangata? ");
INSERT INTO mri_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ehara ianei tēnei i te tama a te kāmura? He teka ianei ko Meri te ingoa o tōna whaea? Ko Hēmi hoki rātou ko Hōhepa, ko Haimona, ko Hūrā, ōna tēina? ");
INSERT INTO mri_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Me ōna tuāhine, kāhore ianei rātou katoa i a tātou nei? Nō hea rā ēnei mea katoa a tēnei tangata?” ");
INSERT INTO mri_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Heoi, ka hē rātou ki a ia. Otirā, ka mea a Īhu ki a rātou, “Kei tōna kāinga, kei tōna whare anake te poropiti hapa ai i te hōnore.” ");
INSERT INTO mri_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ā, kīhai i maha ngā merekara i meatia e ia ki reira, i tō rātou whakapono kore hoki. ");
INSERT INTO mri_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","I taua wā, ka rongo a Herora te tetaraki ki te rongo o Īhu, ");
INSERT INTO mri_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ā, ka mea ki āna pononga, “Ko Hoani Kaiiriiri tēnei; kua ara mai ia i te hunga mate; ā, nā reira i mahi ai ngā merekara i roto i a ia.” ");
INSERT INTO mri_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","I hopukia hoki a Hoani e Herora, ā, hereherea ana e ia, ā, makā ana ki te whare herehere, he mea hoki nā Herōriaha, nā te wahine a tōna tuakana, a Piripi. ");
INSERT INTO mri_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","I mea hoki a Hoani ki a ia, “E kore e tika kia riro ia i a koe.” ");
INSERT INTO mri_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ā, i a ia e mea ana ki te whakamate i a ia, ka wehi i te mano; ki tā rātou hoki he poropiti ia. ");
INSERT INTO mri_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Otirā, i te taenga ki te rā whānau o Herora, ka kanikani te tamāhine a Herōriaha i waenganui i a rātou, ā, ka āhuareka a Herora. ");
INSERT INTO mri_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kātahi ia ka mea ki a ia, oati rawa, kia hoatu ki a ia tāna mea e tono ai. ");
INSERT INTO mri_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nā, he mea whakakīkī ia nā tōna whaea, ka mea, “Hōmai ki konei ki ahau i runga i te rīhi te mātenga o Hoani Kaiiriiri.” ");
INSERT INTO mri_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Heoi, ka pōuri te kīngi; otiia, i whakaaro ia ki te oati, ki te hunga hoki e noho tahi ana me ia, ā, ka mea kia hoatu. ");
INSERT INTO mri_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nā, ka tono tāngata ia, ā, pōutoa ana te mātenga o Hoani i roto i te whare herehere. ");
INSERT INTO mri_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ā, i mauria tōna mātenga i runga i te rīhi, i hoatu ki te kōtiro; kawea atu ana e ia ki tōna whaea. ");
INSERT INTO mri_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nā, ka haere āna ākonga, ka tango i te tinana, ā, tanumia ana e rātou, ā, haere ana, kōrero ana ki a Īhu. ");
INSERT INTO mri_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nā, i te rongonga o Īhu, ka haere atu ia i reira rā te kaipuke ki te koraha, ki te wāhi motu kē. Ā, nō ka rongo te mano, ka aru i a ia rā uta i roto i ngā pā. ");
INSERT INTO mri_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ā, ka puta atu a Īhu, ka kite i te huihuinga nui, ka aroha ia ki a rātou, ā, whakaorangia ana e ia ō rātou tūroro. ");
INSERT INTO mri_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ā, nō ka ahiahi, ka haere atu āna ākonga ki a ia, ka mea, “He wāhi koraha tēnei, kua heke noa atu te rā; tonoa atu te mano, kia haere ai rātou ki ngā kāinga, ki te hoko kai mā rātou.” ");
INSERT INTO mri_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Anō rā ko Īhu ki a rātou, “Kāhore he mea e haere ai rātou; mā koutou e hoatu he kai mā rātou.” ");
INSERT INTO mri_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka mea rātou ki a ia, “Heoi anō a mātou i konei, e rima ngā taro, e rua hoki ngā ika.” ");
INSERT INTO mri_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nā, ka mea ia, “Mauria mai ki konei ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nā, ka mea ia ki te mano kia noho ki runga i te tarutaru, ka mau i ngā taro e rima, i ngā ika hoki e rua, ka titiro ki runga ki te rangi, ka whakapai, ka whawhati, ā, hoatu ana e ia ngā taro ki ngā ākonga, ā, nā ngā ākonga ki te mano. ");
INSERT INTO mri_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ā, kai katoa ana rātou, ā, ka mākona; ā, kotahi tekau mā rua ngā kete i kohia ake e rātou, kī tonu i ngā whatiwhatinga i toe. ");
INSERT INTO mri_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ko te hunga i kai rā me te mea e rima mano ngā tāne, hāunga ngā wāhine me ngā tamariki. ");
INSERT INTO mri_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nā, akiaki tonu a Īhu i āna ākonga kia eke ki te kaipuke, kia whakawhiti i mua i a ia ki tāwāhi, i a ia e tuku ana i ngā mano kia haere. ");
INSERT INTO mri_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ā, ka oti te mano te tuku, ka kake ia ki runga ki te maunga ki te wāhi motu kē ki te īnoi; nā, kua ahiahi, ā, ko ia anake i reira. ");
INSERT INTO mri_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nā, tērā te kaipuke te ākina rā e te ngaru i waenga moana; i hē hoki te i hau. ");
INSERT INTO mri_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ā, i te whā o ngā mataaratanga o te pō ka haere a Īhu ki a rātou, i haere māori i runga i te moana. ");
INSERT INTO mri_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ā, i te kitenga o ngā ākonga i a ia e haere ana i runga i te moana, ka ihiihi, ka mea, “He wairua!” Ka auē i te wehi. ");
INSERT INTO mri_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nā, kua hohoro te kōrero a Īhu ki a rātou, te mea, “Kia manawanui, ko ahau tēnei; aua e wehi.” ");
INSERT INTO mri_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nā, ka whakahoki a Pita ki a ia, ka mea, “E te Ariki, ki te mea ko koe tēnā, kīa mai ahau kia haere atu ki a koe i runga i te wai.” ");
INSERT INTO mri_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nā, ka mea ia, “Haere mai.” Ā, ka marere atu a Pita i te kaipuke, ka haere i runga i te wai, kia tae ai ki a Īhu. ");
INSERT INTO mri_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Otirā, ka kite ia i te hau e kaha ana, ka wehi; ā, ka tīmata te totohu, ka karanga ake, ka mea, “Ahau, e te Ariki, whakaorangia.” ");
INSERT INTO mri_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hohoro tonu te totoro o te ringa o Īhu, ka hopu i a ia, ka mea ki a ia, “E te tangata whakapono iti, he aha koe i ngākau rua ai?” ");
INSERT INTO mri_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Anō ka eke rāua ki te kaipuke, mutu pū te hau. ");
INSERT INTO mri_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nā, ka haere mai te hunga i runga i te kaipuke, ka koropiko ki a ia, ka mea, “He pono ko te Tama koe a te Atua!” ");
INSERT INTO mri_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ā, i tō rātou whitinga atu, ka tae ki te whenua o Kenehareta. ");
INSERT INTO mri_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ā, ka mōhio ngā tāngata o taua wāhi ki a ia, ka tono tāngata puta noa i ngā wāhi tūtata katoa o reira, hei kawe mai i ngā tūroro katoa ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ka īnoi ki a ia kia pā kau rātou ki te tāniko o tōna kākahu; ā, ora ake ngā tāngata katoa i pā. ");
INSERT INTO mri_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nā, ka haere ki a Īhu ētahi karaipi me ētahi Parihi nō Hiruhārama, ka mea, ");
INSERT INTO mri_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“He aha āu ākonga ka takahi ai i te whakarerenga iho a ngā kaumātua? Kāhore hoki rātou e horoi i ō rātou ringa ina kai taro.” ");
INSERT INTO mri_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nā, ka whakahoki ia, ka mea ki a rātou, “He aha hoki i waiho ai e koutou tā koutou whakarerenga iho hei takahi mō tā te Atua kupu ako? ");
INSERT INTO mri_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","I mea hoki te Atua, ‘Whakahōnoretia tōu pāpā me tōu whaea’, ā, ‘Ki te kohukohu hoki tētahi i tōna pāpā, i tōna whaea rānei kia mate ia, mate rawa.’ ");
INSERT INTO mri_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ko koutou ia hei mea, Ki te mea tētahi ki tōna pāpā, ki tōna whaea rānei, ‘Ko tāku mea hei atawhainga mōu kua tāpaea atu ki te Atua.’ ");
INSERT INTO mri_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nā, kaua ia e whakahōnore i tōna pāpā. Heoi, waiho ana e koutou tā koutou whakarerenga iho hei whakakāhore i te kupu a te Atua. ");
INSERT INTO mri_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","E te hunga tinihanga, tika rawa tā Ihāia i poropiti ai mō koutou, i mea ai: ");
INSERT INTO mri_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Te iwi nei ko ō rātou ngutu hei whakahōnore mōku; matara noa atu ia i ahau ō rātou ngākau. ");
INSERT INTO mri_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maumau karakia noa rātou ki ahau, ko tā rātou nei hoki e whakaako ai ko ngā whakahau a te tangata.’ ” ");
INSERT INTO mri_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ā, karangatia ana e ia te mano ki a ia, ka mea ki a rātou, “Kia rongo, kia mātau: ");
INSERT INTO mri_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","E kore te tangata e poke i te mea e tapoko ana ki te māngai; engari, te mea e puta mai ana i roto i te māngai, mā tēnā e poke ai te tangata.” ");
INSERT INTO mri_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Me i reira ka haere āna ākonga, ka mea ki a ia, “E mōhio ana rānei koe i hē ngā Parihi i tō rātou rongonga i taua kupu?” ");
INSERT INTO mri_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nā, ka whakahoki ia ka mea, “Ka hūtia ngā māhuri katoa kīhai i whakatōkia e tōku Matua i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Waiho atu rātou; he matapō rātou e ārahi ana i te matapō. Ki te ārahina te matapō e te matapō, ka taka tahi rāua ki te waikeri”. ");
INSERT INTO mri_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ka whakahoki a Pita, ka mea ki a ia, “Whakaaturia ki a mātou tēnei kupu whakarite.” ");
INSERT INTO mri_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ka mea a Īhu, “Kei te kūware tonu anō koutou? ");
INSERT INTO mri_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kīanō koutou i mātau noa, ko ngā mea katoa e tapoko atu ana ki te māngai ka riro ki roto ki te kōpū, ā, e ākiritia ana ki te poka? ");
INSERT INTO mri_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tēnā ko ngā mea e puta mai ana i te māngai e haere ake ana i te ngākau; mā ēnā e poke ai te tangata. ");
INSERT INTO mri_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nō roto hoki nō te ngākau te putanga ake o ngā whakaaro kino, o ngā kōhuru, o ngā pūremu, o ngā moepuku, o ngā tāhae, o ngā whakapae teka, o ngā kohukohu. ");
INSERT INTO mri_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ko ngā mea ēnei e noa ai te tangata; tēnā ko te kai me ngā ringa kīhai i horoia, e kore te tangata e noa i tēnā.” ");
INSERT INTO mri_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ā, ka haere atu a Īhu i reira, ka anga ki ngā wāhi o Tāira, o Hairona. ");
INSERT INTO mri_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nā, ko te haerenga mai i aua wāhi o tētahi wahine, he Kanaani, ka karanga ki a ia, ka mea, “E te Ariki e te Tama a Rāwiri, kia aroha ki ahau; ko tāku tamāhine e ngaua kinotia ana e te rēwera.” ");
INSERT INTO mri_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ā, kāhore āna kupu i whakahoki ai ki a ia. Nā, ka haere mai āna ākonga, ka tohe ki a ia, ka mea, “Tonoa kia haere; e karanga ana hoki i muri i a tātou.” ");
INSERT INTO mri_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Otirā, ka whakahoki ia, ka mea, “Heoi ngā mea i tonoa mai ai ahau, ko ngā hipi ngaro o te whare o Īharaira.” ");
INSERT INTO mri_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ka haere tonu mai tērā, ka koropiko ki a ia, ka mea, “E te Ariki, kia puta tōu whakaaro ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nā, ka whakahoki ia, ka mea, “Ehara i te tika kia tangohia te taro a ngā tamariki, kia makā mā ngā kurī.” ");
INSERT INTO mri_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ka mea tērā, “Āe rā, e te Ariki, e kai ana anō ngā kurī i ngā kongakonga e ngahoro iho ana i te tēpu a ō rātou rangatira.” ");
INSERT INTO mri_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kātahi ka whakahoki a Īhu, ka mea ki a ia, “E tai, nui atu tōu whakapono; waiho i tāu i pai ai.” Ā, ora ake tāna tamāhine i taua wā pū anō. ");
INSERT INTO mri_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nā, ka whakatika a Īhu i reira, ka haere ki te taha o te moana o Kariri, ā, kake ana ki te maunga, noho ana i reira. ");
INSERT INTO mri_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","He rahi hoki te hui i haere ki a ia, i a rātou anō ngā kopa, ngā matapō, ngā wahangū, ngā mutu, me te tini kē atu, ā, tukua iho e rātou ki ngā waewae o Īhu; ā, whakaorangia ana rātou e ia. ");
INSERT INTO mri_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mīharo noa te mano i tō rātou kitenga i ngā wahangū e kōrero ana, i ngā mutu e ora ana, i ngā kopa e haere ana, i ngā matapō e titiro ana; ā, whakakorōriatia ana e rātou te Atua o Īharaira. ");
INSERT INTO mri_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nā, ka karangatia e Īhu āna ākonga, ka mea, “E aroha ana ahau ki te huihui nei, ka toru nei hoki ō rātou rā e noho ana ki ahau, kāhore hoki ā rātou kai; e kore ahau e pai kia tonoa pukutia, kei hemo ki te ara.” ");
INSERT INTO mri_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nā, ko te meatanga a āna ākonga ki a ia, “Nō hea ā tātou taro i te koraha, e mākona ai tēnei ope nui?” ");
INSERT INTO mri_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nā, ka mea a Īhu ki a rātou, “E hia ā koutou taro?” Ka mea rātou, “E whitu, me ngā ika nonohi, torutoru nei.” ");
INSERT INTO mri_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nā, ka mea ia ki te mano kia noho ki te whenua; ");
INSERT INTO mri_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ā, ka mau ia ki ngā taro e whitu ki ngā ika; ka whakawhetai, ka whawhati, ā, hoatu ana e ia ki ngā ākonga, ā, nā ngā ākonga ki te mano. ");
INSERT INTO mri_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ā, kai ana rātou katoa, ā, ka mākona; e whitu hoki ngā kete i kohia e rātou, kī tonu i ngā whatiwhatinga i toe. ");
INSERT INTO mri_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ā, ko te hunga i kai, e whā mano ngā tāne, hāunga ngā wāhine, ngā tamariki. ");
INSERT INTO mri_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ā, ka oti te mano te tono atu e ia, ka eke ia ki te kaipuke; nā, kua ū ki ngā wāhi o Makarana. ");
INSERT INTO mri_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nā, ka haere mai ngā Parihi me ngā Haruki, ka whakamātautau ka tono kia whakakitea e ia ki a rātou tētahi tohu i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nā, ka whakahoki ia, ka mea ki a rātou: “Ka ahiahi, ka mea koutou, ‘He paki; inā he whero te rangi.’ ");
INSERT INTO mri_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ā, i te ata, ‘He āwhā āianei; he whero nei te rangi, e tukupū ana.’ E te hunga tinihanga, e mātau ana koutou ki te titiro ki te mata o te rangi; tē taea e koutou ngā tohu o ngā tāima. ");
INSERT INTO mri_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","E rapu tohu ana te whakatupuranga kino, pūremu; ā, heoi anō tohu e hoatu ki a rātou ko te tohu o Hona poropiti.” Nā, whakarērea ana rātou e ia, ā, haere ana. ");
INSERT INTO mri_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ā, ka ū ngā ākonga ki tērā taha kua wareware ki te mau taro atu. ");
INSERT INTO mri_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nā, ka mea a Īhu ki a rātou, “Kia mahara kia tūpato i te rēwena a ngā Parihi, a ngā Haruki.” ");
INSERT INTO mri_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ā, ka kōrerorero rātou ki a rātou anō, ka mea, “Nō te mea kāhore tātou i mau taro mai.” ");
INSERT INTO mri_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ā, ka mōhio a Īhu, ka mea ki a rātou: “He aha koutou ka kōrerorero ai ki a koutou, e te hunga whakapono iti, nō te mea kīhai i maua mai he taro e koutou? ");
INSERT INTO mri_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kīanō koutou i mātau noa, kīanō koutou i mahara ki ngā taro e rima a ngā mano e rima, ki te maha hoki o ngā kete i riro i a koutou? ");
INSERT INTO mri_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ki ngā taro hoki e whitu a ngā mano e whā, ki te maha anō o ngā kete i riro i a koutou? ");
INSERT INTO mri_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","He aha koutou tē mātau ai, ehara i te mea mō te taro tāku i mea ai ki a koutou, kia tūpato i te rēwena a ngā Parihi, a ngā Haruki?” ");
INSERT INTO mri_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kātahi rātou ka mātau kīhai ia i mea kia tūpato i te rēwena o te taro, engari i te ako a ngā Parihi, a ngā Haruki. ");
INSERT INTO mri_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ka tae a Īhu ki ngā wāhi o Hiharia Piripai, ka ui ia ki āna ākonga, ka mea, “Ko wai rā ahau te Tama a te tangata, ki tā ngā tāngata kī?” ");
INSERT INTO mri_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nā, ka mea rātou, “Ki tā ētahi ko Hoani Kaiiriiri; ki tā ētahi ko Irāia; ki tā ētahi ko Heremaia, ko tētahi rānei o ngā poropiti.” ");
INSERT INTO mri_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ka mea ia ki a rātou, “Ā, ki tā koutou ko wai ahau?” ");
INSERT INTO mri_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nā, ka whakahoki a Haimona Pita, ka mea, “Ko te Karaiti koe, ko te Tama a te Atua ora.” ");
INSERT INTO mri_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nā, ka whakahoki a Īhu, ka mea ki a ia: “Ka koa koe, e Haimona Parahona; ehara hoki i te kikokiko, i te toto, nāna tēnei i whakakite ki a koe, engari, nā tōku Matua i te rangi.” ");
INSERT INTO mri_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nā, ko tāku kupu anō tēnei ki a koe, “Ko Pita koe, ā, ka hangā e ahau tāku hāhi ki runga ki tēnei kāmaka; e kore anō e taea taua hāhi e ngā kūwaha o te rēinga. ");
INSERT INTO mri_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ka hoatu anō e ahau ki a koe ngā kī o te rangatiratanga o te rangi; ā, ko āu e here ai i te whenua e herea anō i te rangi; ko āu hoki e wewete ai i te whenua e wetekia anō i te rangi.” ");
INSERT INTO mri_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Me i reira ka whakatūpato ia i āna ākonga, kia kaua e kōrerotia e rātou ki te tangata ko te Karaiti ia. ");
INSERT INTO mri_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nō reira mai anō, i tīmata ai a Īhu te whakaatu ki āna ākonga, kua takoto te tikanga kia haere ia ki Hiruhārama, ā, he maha ngā mamae e mamae ai ia i ngā kaumātua, i ngā tohunga nui, i ngā karaipi, ā, ka whakamatea ia, ā, hei te toru o ngā rā ka ara. ");
INSERT INTO mri_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nā, ka mau a Pita ki a ia, ka anga, ka whakahē ki tāna, ka mea, “Auē! Kauaka, e te Ariki! Kauaka rā tēnei e pā ki a koe.” ");
INSERT INTO mri_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nā, ka tahuri ia, ka mea ki a Pita, “Haere ki muri i ahau, e Hātana, he tūtukitanga waewae koe ki ahau; kāhore hoki ōu ngākau ki ngā mea a te Atua, engari, ki a te tangata.” ");
INSERT INTO mri_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kātahi a Īhu ka mea ki āna ākonga: “Ki te mea tētahi kia haere mai ki te whai i ahau, me whakakāhore ia e ia anō, me amo tōna rīpeka, ka aru ai i ahau. ");
INSERT INTO mri_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ki te whai hoki tētahi kia ora, ka mate anō ia; ki te mate tētahi, mōna i whakaaro ki ahau, ka kite anō ia i te ora. ");
INSERT INTO mri_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","He aha hoki te pai ki te tangata, ki te riro i a ia te ao katoa, ā, ka kore he ora mōna? He aha hoki tā te tangata e hoatu ai hei utu mōna kia ora? ");
INSERT INTO mri_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tēnei ake hoki ka haere mai te Tama a te tangata, rātou ko āna anahera, i runga i te korōria o tōna Matua; ā, ko reira hoatu ai e ia ki tēnei, ki tēnei, te utu o tāna mahi. ");
INSERT INTO mri_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","He pono tāku e mea nei ki a koutou, Tēnei anō ētahi e tū nei e kore e pāngia e te mate, kia kite rā anō i te Tama a te tangata e haere mai ana i runga i tōna rangatiratanga.” ");
INSERT INTO mri_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ā, ka pahure ngā rā e ono, ka mau a Īhu ki a Pita, ki a Hēmi rāua ko tōna teina ko Hoani, nā, kawea ana rātou e ia ki runga ki tētahi maunga tiketike ki te wāhi motu kē. ");
INSERT INTO mri_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ā, ka puta kē tōna āhua i tō rātou aroaro; whiti tonu tōna mata me te rā, mā tonu ōna kākahu me te mārama. ");
INSERT INTO mri_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nā, ka kitea e rātou a Mohi rāua ko Irāia e kōrerorero ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kātahi ka oho a Pita, ka mea ki a Īhu, “E te Ariki, he pai kia noho tātou i konei; ki te pai koe, mā mātou e hanga ētahi wharau ki konei kia toru; kia kotahi mōu, kia kotahi mō Mohi, kia kotahi mō Irāia.” ");
INSERT INTO mri_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","I a ia anō e kōrero ana, nā, ka taumarumaru iho te kapua mārama i runga i a rātou; nā, he reo nō te kapua e mea ana, “Ko tāku Tama tēnei i aroha ai, ko tāku i āhuareka ai; whakarongo ki a ia!” ");
INSERT INTO mri_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A, nō ka rongo ngā ākonga, ka takoto tāpapa rātou, he nui hoki tō rātou wehi. ");
INSERT INTO mri_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nā, ka haere a Īhu, ka pā ki a rātou, ka mea, “Whakatika, kaua e wehi.” ");
INSERT INTO mri_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ā, nō ka ara ake ō rātou kanohi, kāhore he tangata i kitea e rātou, ko Īhu anake. ");
INSERT INTO mri_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nā, i a rātou e heke iho ana i te maunga, ka whakatūpato a Īhu i a rātou, ka mea, “Kaua e kōrerotia ki te tangata te mea i kitea nei, kia ara ake rā anō te Tama a te tangata i te hunga mate.” ");
INSERT INTO mri_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ā, ka ui āna ākonga ki a ia ka mea, “He aha ngā karaipi ka mea ai, ko Irāia kia mātua puta mai?” ");
INSERT INTO mri_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nā, ka whakahoki a Īhu, ka mea ki a rātou, “Ko Irāia anō e mātua puta hei whakatika i ngā mea katoa. ");
INSERT INTO mri_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ko tāku ia tēnei ki a koutou, kua tae noa mai a Irāia, ā, kīhai rātou i mōhio ki a ia, heoi, meatia ana e rātou ki a ia tā rātou i pai ai. E pērā anō te Tama a te tangata te mamae i a rātou.” ");
INSERT INTO mri_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kātahi ka mōhio ngā ākonga ko Hoani Kaiiriiri tāna i kōrero ai ki a rātou. ");
INSERT INTO mri_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ā, nō ka tae rātou ki te mano, ka haere mai ki a ia tētahi tangata, ka tūturi ngā turi ki a ia, ka mea, ");
INSERT INTO mri_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“E te Ariki, kia aroha ki tāku tama; he haurangi hoki ia, he kino tōna mamae; he maha hoki ōna hinganga ki te kāpura, he maha ki te wai. ");
INSERT INTO mri_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ā, i kawea ia e ahau ki āu ākonga, heoi, kīhai ia i taea te whakaora e rātou.” ");
INSERT INTO mri_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nā, ka oho a Īhu, ka mea, “E te uri whakapono kore, parori kē, kia pēhea te roa o tōku noho ki a koutou? Kia pēhea te roa o tōku manawanui ki a koutou? Kawea mai ia ki konei, ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nā, ka rīria te rēwera e Īhu; ā, puta ana i roto i a ia; ā, ora ake te tamaiti i taua wā pū anō. ");
INSERT INTO mri_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Me i reira ka haere puku ngā ākonga ki a Īhu, ka mea, “He aha rā tē āhei ai i a mātou te pei i a ia ki waho?” ");
INSERT INTO mri_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nā, ka mea a Īhu ki a rātou: “Nā, tō koutou whakapono iti; he pono hoki tāku e mea nei ki a koutou, ki te mea he whakapono tō koutou, pērā me tō te pua nanī te rahi, e mea koutou ki tēnei maunga, ‘Neke atu i konei ki tērā wāhi’; ā, ka neke; kāhore hoki he mea e kore e taea e koutou. ");
INSERT INTO mri_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Otirā, e kore e puta noa te pēnā, mā te īnoi anake mā te nohopuku.” ");
INSERT INTO mri_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ā, i a rātou e noho ana i Kariri, ka mea a Īhu ki a rātou, “Meāke tukua te Tama a te tangata ki ngā ringa o ngā tāngata; ");
INSERT INTO mri_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ā, ka whakamatea e rātou, ā, i te toru o ngā rā ka ara.” Ā, nui atu tō rātou pōuri. ");
INSERT INTO mri_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ā, nō tō rātou taenga ki Kapere­nauma, ka haere mai ki a Pita ngā kaikohikohi i te hāwhe hekere, ka mea, “E kore ianei tōu Kaiwhakaako e hōmai i te hāwhe hekere?” ");
INSERT INTO mri_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ka mea ia, “E hoatu anō.” Ā, nō ka tapoko ia ki te whare, ko Īhu kua kōrero ki a ia, kua mea, “E pēhea ana tōu whakaaro, e Haimona? E tangohia ana e ngā kīngi o te ao ngā takoha taonga me te takoha tangata i a wai? I ā rātou ake tama, i a ngā tāngata kē rānei?” ");
INSERT INTO mri_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ka mea a Pita ki a ia, “I a ngā tāngata kē.” Nā, ko te kīanga a Īhu ki a ia, “Ha, pēnā ka haere noa ngā tamariki. ");
INSERT INTO mri_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ahakoa rā, kei whai take hē mai rātou ki a tātou, haere ki te moana, piua tētahi matau, ā, ka eke te ika mātāmua, tangohia; nā, ka whakatuwhera i tōna māngai, ka kite ai koe i tētahi moni, tangohia tēnā, ka hoatu ki a rātou, hei mea mōku, mōu.” ");
INSERT INTO mri_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","I taua wā, ka haere mai ngā ākonga ki a Īhu, ka mea, “Ko wai te nui rawa i te rangatiratanga o te rangi?” ");
INSERT INTO mri_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nā, ka karangatia e Īhu tētahi tamaiti nohinohi, ka whakatūria e ia ki waenganui i a rātou, ");
INSERT INTO mri_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ka mea, “He pono tāku e mea nei ki a koutou, ki te kore koutou e tahuri, ā, e pēnei me ngā tamariki nonohi, e kore koutou e tomo ki te rangatiratanga o te rangi. ");
INSERT INTO mri_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nā, ki te whakaiti tētahi i a ia, ā, ka rite ki tēnei tamaiti nohinohi, ko ia te nui rawa i te rangatiratanga o te rangi. ");
INSERT INTO mri_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ā, ki te manako tētahi ki tētahi tamaiti nohinohi pēnei, he whakaaro hoki ki tōku ingoa, e manako ana ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tēnā ko tēnei, ka hē i tētahi tangata tētahi o ēnei mea nonohi e whakapono nei ki ahau, nui kē te pai ki a ia me i whakawerewerea ki tōna kakī te kōhatu mira kāihe, me i pungaia ia ki te rire o te moana. ");
INSERT INTO mri_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Auē te mate mō te ao i ngā take hē! Kua tino takoto rawa hoki he putanga mō ngā take hē; otiia, auē te mate mō tērā tangata e puta ai te take hē! ");
INSERT INTO mri_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ki te hē koe i tōu ringa, i tōu waewae rānei, pōutoa, makā atu; pai kē hoki mōu te tomo ki te ora he kopa, he ringa mutu, i te makā ki te ahi kā tonu, he ringa rua, he waewae rua. ");
INSERT INTO mri_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ki te hē hoki koe i tōu kanohi, tīkarohia, makā atu; pai kē hoki mōu te tomo kanohi tahi ki te ora, i te makā kanohi rua ki te kāpura o Kehena.” ");
INSERT INTO mri_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kia mahara kei whakahāwea ki tētahi o ēnei mea nonohi; ko tāku kupu hoki tēnei ki a koutou, E titiro tonu ana ō rātou anahera i te rangi ki te kanohi o tōku Matua i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","I haere mai hoki te Tama a te tangata ki te whakaora i te mea i ngaro. ");
INSERT INTO mri_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Pēhea tō koutou whakaaro? Ki te mea he rau ngā hipi a tētahi tangata, ā, ka kotiti kē tētahi, e kore ianei e waiho e ia ngā iwa tekau mā iwa, ka haere i runga i ngā maunga, rapu ai i te mea i kotiti kē? ");
INSERT INTO mri_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ā, ki te kitea, he pono tāku e mea nei ki a koutou, tērā atu tōna hari ki taua hipi, i te hari ki ngā iwa tekau mā iwa kīhai i kotiti kē. ");
INSERT INTO mri_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Waihoki kāhore he ngākau o tō koutou Matua i te rangi kia ngaro tētahi o ēnei mea nonohi.” ");
INSERT INTO mri_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ā, ki te hara tōu teina ki a koe, haere, kōrerotia tōna hara ki a ia, kōrua anake; ki te whakarongo ia ki a koe, ka riro i a koe tōu teina. ");
INSERT INTO mri_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ā, ki te kore ia e whakarongo, kawea atu hei hoa mōu kia kotahi, kia tokorua rānei, kia mau ai ngā kupu katoa i ngā māngai o ngā kaiwhakarongo tokorua, tokotoru rānei. ");
INSERT INTO mri_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ā, ki te pake ia ki a rāua, kōrerotia ki te hāhi; ā, ki te pake anō ia ki te hāhi, me waiho e koe hei tautangata, hei pupirikana.” ");
INSERT INTO mri_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“He pono tāku e mea nei ki a koutou, Ko ā koutou e here ai i te whenua e herea anō ki te rangi; ko ā koutou e wewete ai i te whenua e wetekia anō ki te rangi. ");
INSERT INTO mri_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Tēnei anō tāku kupu ki a koutou, Ki te mea ka tokorua o koutou e rite tahi ana ngā whakaaro i te whenua mō tētahi mea e īnoi ai rāua, e meinga anō mō rāua e tōku Matua i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nā, ko te wāhi e whakaminea ai te hunga tokorua, tokotoru rānei, he whakaaro ki tōku ingoa, kei reira ahau kei waenganui i a rātou.” ");
INSERT INTO mri_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kātahi, ka haere a Pita ki a ia, ka mea, “E te Ariki, kia hia ngā haranga o tōku teina ki ahau, me tāku whakarere noa iho i tōna hara? Kia whitu?” ");
INSERT INTO mri_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ka mea a Īhu ki a ia, “E kore ahau e mea ki a koe, Kia whitu, engari, kia whitu tekau whitu.” ");
INSERT INTO mri_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Koia, ka rite ai te rangatiratanga o te rangi ki tētahi kīngi, i mea kia kōrerotia ki a ia āna moni e āna pononga. ");
INSERT INTO mri_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ā, ka tīmata ia te ui, ka kawea ki a ia he tangata, tekau mano ngā taranata i a ia. ");
INSERT INTO mri_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ā, tē whai rawa ia hei utu, ka mea tōna ariki kia hokona ia, tāna wahine me āna tamariki, me āna taonga katoa, hei whakautu. ");
INSERT INTO mri_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nā, ka tāpapa iho taua pononga, ka koropiko ki a ia, ka mea, ‘E te Ariki, kia āta hanga ki ahau, ā, ka utua katoatia e ahau ki a koe.’ ");
INSERT INTO mri_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nā, ka oho i te aroha te ariki o taua pononga, tuku ana i a ia, ā, whakarērea noatia iho e ia āna moni tārewa. ");
INSERT INTO mri_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Heoi, te putanga o taua pononga ki waho, ka kite i tētahi o ōna hoa pononga, kotahi rau āna pene i a ia; nā, hopukia ana e ia, nōtia iho te kakī, me te kī anō, ‘Utua tāku nama.’ ");
INSERT INTO mri_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Heoi, tāpapa ana tōna hoa pononga ki ōna waewae, ka īnoi ki a ia, ka mea, ‘Kia āta hanga ki ahau, ā, ka utua katoatia e ahau ki a koe.’ ");
INSERT INTO mri_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ā, kīhai ia i pai; heoi haere ana, maka ana i a ia ki te whare herehere, kia utua katoatia rā anō te nama. ");
INSERT INTO mri_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Heoi, nō te kitenga o ōna hoa pononga i taua meatanga, nui atu tō rātou pōuri, ā, haere ana, whakaaturia ana ki tō rātou ariki ngā mea katoa i meatia. ");
INSERT INTO mri_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kātahi, ka karanga tōna ariki i a ia, ka mea ki a ia, ‘Pononga kino, i whakarērea noatia e ahau taua moni tārewa katoa i a koe, nāu hoki i īnoi ki ahau. ");
INSERT INTO mri_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ehara oti i te tika kia tohungia e koe tōu hoa pononga, me ahau hoki i tohu i a koe?’ ");
INSERT INTO mri_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nā, ka riri tōna ariki, ā, tukua ana ia ki ngā kaiwhakamamae, kia utua katoatia rā anō tāna nama. ");
INSERT INTO mri_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tērā anō, e pērā tōku Matua i te rangi ki a koutou, ki te kore e whakarērea noatia i roto i ō koutou ngākau ngā hē o te teina o tēnei, o tēnei, o koutou.” ");
INSERT INTO mri_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ā, ka mutu ēnei kupu a Īhu, ka tūria atu e ia i Kariri, ā, ka tae ki ngā wāhi o Hūria, ki tāwāhi atu o Horano. ");
INSERT INTO mri_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","He rahi hoki te hui i aru i a ia; ā, whakaorangia ana rātou e ia i reira. ");
INSERT INTO mri_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nā, ka haere mai ngā Parihi ki a ia, ki te whakamātautau i a ia, ka mea ki a ia, “He mea tika rānei kia whakarērea e te tangata tāna wahine mō tētahi take?” ");
INSERT INTO mri_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nā, ka whakahoki ia, ka mea ki a rātou, “Kīanō koutou i kite noa i hangā rāua e te Kaihanga i te tīmatanga, he tāne, he wahine? ");
INSERT INTO mri_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","I mea anō ia, ‘Mō konei ka mahue i te tangata tōna pāpā, tōna whaea ka piri ki tāna wahine, ā, hei kikokiko kotahi rāua tokorua’? ");
INSERT INTO mri_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nā, heoi anō tō rāua tokoruatanga, engari kotahi anō kikokiko. Nā, ko ā te Atua i hono ai, kaua e wehea e te tangata.” ");
INSERT INTO mri_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ka mea rātou ki a ia, “He aha rā a Mohi i ako ai kia hoatu he pukapuka whakarere, ka whakarere ai i a ia?” ");
INSERT INTO mri_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ka mea ia ki a rātou, “Nā, te pakeke o ō koutou ngākau i tukua ai koutou e Mohi kia whakarere i ā koutou wāhine; i te tīmatanga iho ia kāhore i pēnā. ");
INSERT INTO mri_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ā, tēnei tāku kupu ki a koutou, Ki te whakarere tētahi i tāna wahine, ehara nei i te take moepuku, ā, ka mārenatia ki tētahi atu, e pūremu ana ia; ā, ki te mārena tētahi i te wahine i whakarērea, e pūremu ana ia.” ");
INSERT INTO mri_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ka mea āna ākonga ki a ia, “Ki te pēnei te tikanga mō te tangata rāua ko tāna wahine, ehara te mārena.” ");
INSERT INTO mri_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Otirā, ka mea ia ki a rātou, “E kore tēnei kupu e rite i ngā tāngata katoa, engari, i te hunga i hoatu ai. ");
INSERT INTO mri_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","He ūnaka hoki ētahi nō te whānautanga mai i te kōpū o te whaea; ko ētahi ūnaka he mea whakaūnaka nā te tangata; ko ētahi ūnaka he mea whakaūnaka nā rātou anō, he whakaaro hoki ki te rangatiratanga o te rangi. Ki te taea tēnei te whakarite e tētahi, māna e whakarite.” ");
INSERT INTO mri_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","I reira, ka kawea mai he tamariki nonohi ki a ia, kia whakapā ai ia i ōna ringa ki a rātou, kia īnoi; ā, rīria iho rātou e ngā ākonga. ");
INSERT INTO mri_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nā, ko te kīanga a Īhu, “Tukua mai ngā tamariki nonohi, aua hoki e āraia atu tā rātou haere mai ki ahau; nō ngā pēnei hoki te rangatiratanga o te rangi.” ");
INSERT INTO mri_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ā, whakapākia iho e ia ōna ringa ki a rātou, ā, haere atu ana i reira. ");
INSERT INTO mri_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nā, ka haere mai tētahi ki a ia, ka mea, “E te Kaiwhakaako, he aha te mahi pai māku, e whiwhi ai ahau ki te ora tonu?” ");
INSERT INTO mri_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nā, ko tāna meatanga ki a ia, “He aha ka ui koe ki ahau mō te mea pai? Tērā anō tētahi i pai, kotahi tonu; ki te mea koe kia tomo ki te ora, whakaritea ngā ture.” ");
INSERT INTO mri_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ka mea ia ki a ia, “Ko ēhea?” Nā, ka mea a Īhu, “Kaua e patu tangata; kaua e pūremu; kaua e tāhae; kaua e whakapae teka; ");
INSERT INTO mri_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Whakahōnoretia tōu pāpā me tōu whaea; me tēnei; kia aroha ki tōu hoa tata ānō ko koe.” ");
INSERT INTO mri_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ka mea taua taitama ki a ia, “Kua rite i ahau ēnei mea katoa nō tōku tamarikitanga; tēnā hoki tētahi mea e hapa ana i ahau?” ");
INSERT INTO mri_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ka mea a Īhu ki a ia, “Ki te mea koe kia tino tika, haere, hokona ōu taonga, ka hoatu ki ngā rawakore, ā, e whai taonga koe ki te rangi; ā, haere mai i muri i ahau.” ");
INSERT INTO mri_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nā, ka rongo taua taitama i taua kupu, haere pōuri ana ia, he maha hoki ōna taonga. ");
INSERT INTO mri_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ka mea a Īhu ki āna ākonga, “He pono tāku kupu ki a koutou, e tapoko whakauaua te tangata taonga ki te rangatiratanga o te rangi. ");
INSERT INTO mri_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tēnei anō tāku kupu ki a koutou, he ngāwari kē atu te haere o te kāmera rā te kōwhao o te ngira i te haere o te tangata taonga ki roto ki te rangatiratanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ā, nō ka rongo āna ākonga, nui rawa tō rātou mīharo, ka mea, “Ko wai rā e ora?” ");
INSERT INTO mri_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nā, ka titiro a Īhu ki a rātou, ka mea, “Ki te tangata e kore tēnei e taea, ki te Atua ia e taea ngā mea katoa.” ");
INSERT INTO mri_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kātahi, ka whakahoki a Pita, ka mea ki a ia, “Nā, kua mahue nei i a mātou ngā mea katoa, kua aru nei i a koe, he aha rā mā mātou?” ");
INSERT INTO mri_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ka kī a Īhu ki a rātou, “He pono tāku e mea nei ki a koutou, ko koutou i aru nei i ahau, kia taea te whānautanga houtanga, te wā e noho ai te Tama a te tangata ki runga ki te torōna o tōna korōria, ka noho anō koutou ki runga ki ētahi torōna kotahi tekau mā rua, ki te whakawā i ngā iwi kotahi tekau mā rua o Īharaira. ");
INSERT INTO mri_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ā, ki te mea kua mahue i tētahi he whare, he tēina, he tuāhine rānei, he pāpā, he whaea, he tamariki, he whenua, i tōna whakaaro ki tōku ingoa, ka tātakirau ngā mea e riro i a ia, ā, ka whiwhi ia ki te ora tonu. ");
INSERT INTO mri_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","He tokomaha ia ō mua e waiho ki muri; ko ō muri ki mua.” ");
INSERT INTO mri_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“He rite hoki te rangatiratanga o te rangi ki tētahi rangatira whare, i haere i te atatū ki te kōrero kaimahi mō tāna māra wāina. ");
INSERT INTO mri_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ā, nō ka oti te whakarite ki ngā kaimahi kia kotahi rā he pene, tonoa ana rātou e ia ki tāna māra wāina. ");
INSERT INTO mri_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ā, ka haere atu ia i te toru o ngā hāora, ka kite i ētahi atu e tū māngere ana i te kāinga hokohoko, ");
INSERT INTO mri_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ka mea ki a rātou, ‘Haere hoki koutou ki te māra wāina, ā, ka hoatu e ahau ki a koutou te mea e tika ana.’ Nā, haere ana rātou. ");
INSERT INTO mri_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","I haere anō ia i te ono, i te iwa o ngā hāora, ā, pērā ana anō. ");
INSERT INTO mri_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","I te tekau mā tahi o ngā hāora ka haere atu anō ia, ka kite i ētahi atu e tū ana, ka mea ki a rātou, ‘He aha tā koutou e tū māngere i konei i te rā roa nei?’ ");
INSERT INTO mri_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ka mea rātou ki a ia, ‘Nō te mea rā kāhore he tangata i kōrero ki a mātou ki te mahi.’ Ka mea ia ki a rātou, ‘Haere anō koutou ki te māra wāina.’ ");
INSERT INTO mri_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ā, nō te ahiahi ka mea te rangatira o te māra wāina ki tāna kaiwhakahauhau, ‘Karangatia ngā kaimahi, utua hoki rātou, hei ō muri tīmata ai puta noa ki ō mua.’ ");
INSERT INTO mri_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ā, nō te taenga mai o te hunga i kōrerotia i te tekau mā tahi o ngā hāora, kotahi te pene i riro i tētahi, i tētahi. ");
INSERT INTO mri_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ka tae anō ō mua, hua noa rātou tērā atu te mea e riro i a rātou; heoi, kotahi anō te pene i riro i a rātou. ");
INSERT INTO mri_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ā, nō ka riro i a rātou, ka amuamu ki taua rangatira whare, ");
INSERT INTO mri_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ka mea, ‘Kotahi te hāora i mahi ai ēnei ō muri, ā, ka oti rātou te whakarite ki a mātou, ki te hunga i pēhia nei e te taimaha e te tīkākātanga o te rā.’ ");
INSERT INTO mri_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ā, ka whakahoki ia, ka mea ki tētahi o rātou, ‘E hoa, kāhore āku hē ki a koe; kīhai koe i whakarite ki ahau me pene? ");
INSERT INTO mri_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tangohia tāu, haere. E pai ana ahau kia rite ki tāu te mea e hoatu ki tēnei ō muri. ");
INSERT INTO mri_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ehara ianei i te tika kia meatia e ahau tāku e pai ai ki āku mea? He kino oti tōu kanohi nō te mea he pai ahau?’ ");
INSERT INTO mri_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Heoi, ko ō muri e meinga ki mua, ko ō mua ki muri; he tokomaha hoki e karangatia, he ruarua ia e whiriwhiria.” ");
INSERT INTO mri_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ā, i a Īhu e haere ana ki Hiruhārama, i a rātou i te ara, ka kawea e ia āna ākonga kotahi tekau mā rua ki tahaki, ā, ka mea ki a rātou, ");
INSERT INTO mri_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nā, e haere ana tēnei tātou ki Hiruhārama; ā, ka tukua te Tama a te tangata ki ngā tohunga nui, ki ngā karaipi, ka kīa ia e rātou kia mate, ");
INSERT INTO mri_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ka tukua ia ki ngā tauiwi kia tāwaia, kia whiua, kia rīpekatia; ā, i te toru o ngā rā ka whakaarahia ake.” ");
INSERT INTO mri_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Me i reira ka tae ki a ia te whaea o ngā tama a Heperi, rātou ko āna tama, ā, ka koropiko, ka īnoi ki tētahi mea i a ia. ");
INSERT INTO mri_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nā, ka mea ia ki a ia, “He hiahia aha tōu?” Ka mea ia ki a ia, “Whakaaetia ēnei tama tokorua āku, kia noho, tētahi ki tōu matau, tētahi ki tōu mauī, i tōu rangatiratanga.” ");
INSERT INTO mri_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Otirā, ka whakahoki a Īhu, ka mea, “Kāhore kōrua e mōhio ki tā kōrua e īnoi nei. E āhei rānei kōrua te inu i te kapu meāke inumia e ahau, kia iriiria hoki ki te iriiringa ka iriiria nei ahau?” Ka mea rāua ki a ia, “E āhei anō.” ");
INSERT INTO mri_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka mea ia ki a rāua, “E inu anō kōrua i tāku kapu, e iriiria ki te iriiringa e iriiria ai ahau; ko te noho ia ki tōku matau, ki tōku mauī, ehara i ahau māna e hoatu, engari, ka riro i te hunga i whakaritea nei e tōku Matua mō rātou.” ");
INSERT INTO mri_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ā, nō ka rongo te tekau, ka riri ki aua hoa tokorua. ");
INSERT INTO mri_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Otirā, ka karangatia rātou e Īhu, ā, ka mea ia, “E mātau ana koutou, ko ngā kāwana o ngā tauiwi hei whakatupu rangatira ki a rātou, ko ngā tāngata rarahi hei akiaki i a rātou. ");
INSERT INTO mri_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","E kore e pērā i roto i a koutou; engari, ki te mea tētahi kia tupu ia hei tangata nui i roto i a koutou, me whakatupu kaimahi ia mā koutou. ");
INSERT INTO mri_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ā, ki te mea tētahi kia tupu ko ia hei tino tangata i roto i a koutou, me whakatupu pononga ia mā koutou; ");
INSERT INTO mri_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","pērā i te Tama a te tangata, kīhai nei i haere mai kia mahia he mea māna, engari, kia mahi ia, ā, kia tuku i a ia kia mate hei whakautu mō ngā tāngata tokomaha.” ");
INSERT INTO mri_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ā, i a rātou e haere atu ana i Heriko, he rahi te hui i aru i a ia. ");
INSERT INTO mri_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nā, tokorua ngā matapō e noho ana i te taha o te ara; ka rongo rāua ko Īhu tērā e haere atu ana, ka karanga ake, ka mea, “Kia aroha ki a māua, e te Ariki, e te Tama a Rāwiri.” ");
INSERT INTO mri_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ā, i rīria rāua e te mano kia noho puku; heoi rahi ake tā rāua karanga, ka mea, “Kia aroha ki a māua, e te Ariki, e te Tama a Rāwiri.” ");
INSERT INTO mri_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nā, ka tū a Īhu, ka karanga i a rāua, ka mea, “Kia ahatia kōrua e ahau?” ");
INSERT INTO mri_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka mea rāua ki a ia, “E te Ariki, kia kite ō māua kanohi!” ");
INSERT INTO mri_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nā, ka aroha a Īhu, ka pā ki ō rāua kanohi; ā, titiro tonu ake ō rāua kanohi, ā, aru ana rāua i a ia. ");
INSERT INTO mri_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ā, nō ka tata rātou ki Hiru­hā­ra­ma, ka tae ki Petapaki, ki Maunga Ōriwa, ka tonoa atu e Īhu ngā ākonga tokorua, ");
INSERT INTO mri_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ka mea ia ki a rāua “Haere ki te kāinga e anga mai ana ki a kōrua; nā, ka kite tonu kōrua i tētahi kāihe e here ana me tāna kūao; wetekia, ka ārahi mai ki ahau. ");
INSERT INTO mri_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ā, ki te whai kupu tētahi tangata ki a kōrua, kī atu, ‘E mea ana te Ariki ki a rāua māna’; nā, ka tukua tonutia mai rāua e ia.” ");
INSERT INTO mri_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","I meinga tēnei katoa hei whakarite mō te kupu a te poropiti, i mea ai: ");
INSERT INTO mri_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mea atu ki te tamāhine o Hiona, ‘Nā, ko tōu kīngi e haere mai nā ki a koe, he ngākau māhaki tōna, e noho ana i runga i te kāihe, i te kūao hoki, i te tama a te kāihe.’ ” ");
INSERT INTO mri_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nā, haere ana ngā ākonga, meatia ana tā Īhu i mea ai ki a rāua: ");
INSERT INTO mri_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ārahina mai ana te kāihe me te kūao, whārikitia ana ki runga ō rāua kākahu, ā, noho ana ia ki runga. ");
INSERT INTO mri_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ā, he nui rawa te hui ki te whāriki i ō rātou kākahu ki te ara; ko ētahi i tapahi manga mai i ngā rākau, ā, whārikitia ana ki te ara. ");
INSERT INTO mri_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ko ngā mano i haere i mua, me te hunga i haere i muri, kei te karanga, kei te mea, “Ohana ki te Tama a Rāwiri! Ka whakapaingia tēnei e haere mai nei i runga i te ingoa o te Ariki! Ohana i runga rawa!” ");
INSERT INTO mri_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ā, nō ka uru ia ki Hiruhārama, ka oho katoa te pā, ka mea, “Ko wai tēnei?” ");
INSERT INTO mri_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka mea te mano, “Ko Īhu tēnei, ko te poropiti o Nahareta o Kariri.” ");
INSERT INTO mri_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ā, ka tomo a Īhu ki te temepara o te Atua, nā, peia katoatia ana e ia te hunga e hoko mai ana, e hoko atu ana i roto i te temepara, turakina ake ngā tēpu a ngā kaiwhakawhitiwhiti moni, me ngā nohoanga o te hunga hoko kūkupa. ");
INSERT INTO mri_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ā, ka mea ki a rātou, “Kua oti te tuhituhi, ‘Ka kīa tōku whare he whare īnoi’; heoi, kua oti nei te mea e koutou hei ana mō ngā kaipāhua.” ");
INSERT INTO mri_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ā, i haere mai ki a ia ki roto ki te temepara ngā matapō me ngā kopa, ā, whakaorangia ake rātou e ia. ");
INSERT INTO mri_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nō te kitenga ia o ngā tohunga nui, o ngā karaipi i ngā mea whakamīharo i meatia e ia, i ngā tamariki hoki e karanga ana i te temepara, e mea ana, “Ohana ki te Tama a Rāwiri”; ka riri rātou. ");
INSERT INTO mri_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ka mea ki a ia, “E rongo ana koe ki tā ēnei e mea nei?” Ka mea a Īhu ki a rātou, “Āe rā; kīanō koutou i kite noa, ‘Pūmau tonu i a koe te whakamoemiti a te waha o ngā kōhungahunga, o ngā mea ngote ū’?” ");
INSERT INTO mri_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ā, ka mahue rātou i a ia, haere ana ia ki waho o te pā, ki Petani, ā, moe ana i reira. ");
INSERT INTO mri_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nā, i te ata, i a ia e hoki ana ki te pā, ka hiakai ia. ");
INSERT INTO mri_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ā, i tōna kitenga i tētahi piki i te taha o te ara, ka haere ia ki taua rākau, heoi, kīhai i kitea tētahi mea i runga, he rau anake. Ka mea ia ki te rākau, “Kei whai hua koe ā ake ake!” Ā, maroke tonu ake te piki. ");
INSERT INTO mri_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ā, nō te kitenga o ngā ākonga, ka mīharo, ka mea, “I pēheatia i hohoro ai te maroke o te piki nei?” ");
INSERT INTO mri_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nā, ka whakahoki a Īhu, ka mea ki a rātou, “He pono tāku e mea nei ki a koutou, me he whakapono tō koutou, kāhore i ruarua te whakaaro, e kore e meatia e koutou ko tēnei anake i meatia nei ki te piki, engari, ahakoa mea noa koutou ki tēnei maunga, ‘Kia rangā atu koe, kia whakatakā ki te moana’; ka meatia. ");
INSERT INTO mri_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ko ngā mea katoa hoki e tono ai koutou ina īnoi, ki te whakapono, ka riro i a koutou.” ");
INSERT INTO mri_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ā, ka tae ia ki roto ki te temepara, ka haere mai ngā tohunga nui me ngā kaumātua o te iwi, i a ia anō e ako ana, ā, ka mea, “Tēnā koa te mana i meatia ai ēnei mea e koe? Nā wai hoatu tēnei mana ki a koe?” ");
INSERT INTO mri_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nā, ka whakahoki a Īhu, ka mea ki a rātou, “Māku e ui ki a koutou kia kotahi kupu, ki te kōrerotia e koutou ki ahau, māku hoki e kōrero ki a koutou te mana i mea ai ahau i ēnei mea. ");
INSERT INTO mri_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ko te iriiringa a Hoani, nō hea koia? Nō te rangi, nō ngā tāngata rānei?” Ā, ka kōrerorero rātou ki a rātou anō, ka mea, “Ki te mea tātou, ‘Nō te rangi,’ e mea mai ia ki a tātou, ‘Ha, he aha koutou tē whakapono ai ki a ia?’ ");
INSERT INTO mri_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ā, ki te mea tātou, ‘Nō ngā tāngata’; ka wehi tātou i te mano; ki tā rātou katoa hoki he poropiti a Hoani.” ");
INSERT INTO mri_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nā, ka whakahoki rātou ki a Īhu, ka mea, “Kāhore mātou e mōhio.” Nā, ko tāna meatanga ki a rātou, “E kore anō e kōrerotia e ahau ki a koutou te mana i mea ai ahau i ēnei mea.” ");
INSERT INTO mri_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nā, e pēhea ana tō koutou whakaaro? Tokorua ngā tama a tētahi tangata; ā, ka haere ia ki tō mua, ka mea, ‘E tama, haere ki te mahi āianei ki tāku māra wāina.’ ");
INSERT INTO mri_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nā, ka whakahoki ia, ka mea, ‘Kāhore ahau e pai’; otirā, i muri iho ka puta kē tōna whakaaro, ā, haere ana. ");
INSERT INTO mri_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ā, ka haere mai ia ki te tuarua, ka pērā anō tāna kupu. Nō, ka whakahoki tērā, ka mea, ‘E kara, ka haere ahau,’ ā, kīhai i tae. ");
INSERT INTO mri_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ko wai o taua tokorua i mea i tā tōna matua i pai ai?” Ka mea rātou ki a ia, “Ko tō mua.” Ka mea a Īhu ki a rātou, “He pono tāku e mea nei ki a koutou, ko ngā pupirikana me ngā wāhine kairau e tika ana i mua i a koutou ki te rangatiratanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","I haere hoki a Hoani ki a koutou rā te ara o te tika, ā, kīhai koutou i whakapono ki a ia; tēnā ko ngā pupirikana me ngā wāhine kairau i whakapono ki a ia; ko koutou ia, i tō koutou kitenga, kīhai i puta kē ō koutou whakaaro i muri, kīhai i whakapono ki a ia.” ");
INSERT INTO mri_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Whakarongo ki tētahi atu kupu whakarite. Tērā tētahi rangatira whare i whakatō i te māra wāina, ā, taiepatia ana, ā, taka noa, keria ana e ia te takahanga wāina i roto, hangā ana tētahi whare tiketike, tukua ana e ia ki ngā kaimahi, ā, haere ana ia ki tawhiti. ");
INSERT INTO mri_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ā, nō ka tata te pō hua, ka tonoa e ia āna pononga ki ngā kaimahi, ki te tiki i ōna hua. ");
INSERT INTO mri_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nā, ka mau ngā kaimahi ki āna pononga, whiua ana tētahi, whakamatea ana tētahi, ā, ākina ana tētahi ki te kōhatu. ");
INSERT INTO mri_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nā, ka tonoa anō e ia ētahi atu pononga, he tokomaha atu i ō mua; heoi, i pērātia anō rātou. ");
INSERT INTO mri_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nā, muri rawa iho, ka tono ia i tāna tama ki a rātou, i mea ia, ‘E hopohopo rātou ki tāku tama.’ ");
INSERT INTO mri_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nō te kitenga ia o ngā kaimahi i te tama, ka mea ki a rātou anō, ‘Ko te tangata tēnei mōna te kāinga; tēnā, tātou ka whakamate i a ia, ka tango i tōna kāinga.’ ");
INSERT INTO mri_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nā, ka mau rātou ki a ia, maka ana ki waho o te māra wāina, ā, whakamatea iho. ");
INSERT INTO mri_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nā, ina tae te rangatira o te māra wāina, ka pēheatia e ia aua kaimahi?” ");
INSERT INTO mri_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ka mea rātou ki a ia, “Pōuriuri ana āianei tāna whakangaro i taua hunga whakarihariha; ā, ka tukua te māra wāina ki ētahi atu kaimahi, ki te hunga e tukua ai ki a ia ngā hua i ngā pō hua.” ");
INSERT INTO mri_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ka mea a Īhu ki a rātou, “Kīanō koutou i kite noa i roto i ngā karaipiture? ‘Ko te kōhatu i kapea e ngā kaihanga, kua meinga tēnei hei ūpoko mō te kokonga; nā te Ariki tēnei, he mea whakamīharo hoki ki ō tātou kanohi!’ ");
INSERT INTO mri_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Koia, ahau ka mea nei ki a koutou, Ka tangohia te rangatiratanga o te Atua i a koutou, ā, ka hoatu ki tētahi iwi, e puta ai ngā hua o taua rangatiratanga. ");
INSERT INTO mri_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ko te tangata e hinga ki runga ki tēnei kōhatu, nā, mongamonga ana ia; ki te taka ia taua kōhatu ki runga ki tētahi, nā, ngotangota noa ia me he puehu.” ");
INSERT INTO mri_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ā, ka rongo ngā tohunga nui me ngā Parihi ki āna kupu whakarite, ka mōhio mō rātou āna kōrero. ");
INSERT INTO mri_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nā, i a rātou e whai ana kia hopukia ia, ka wehi i te mano, ki tā rātou hoki he poropiti ia. ");
INSERT INTO mri_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ā, ka oho ake a Īhu, ka kōrero kupu whakarite anō ki a rātou, ka mea, ");
INSERT INTO mri_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ka rite te rangatiratanga o te rangi ki tētahi kīngi, i whakatakoto mārena mō tāna tama. ");
INSERT INTO mri_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ā, tonoa ana āna pononga, hei karanga i te hunga i kōrerotia ki te mārena; heoi, kīhai rātou i pai ki te haere. ");
INSERT INTO mri_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ka tono anō ia i ērā atu pononga, ka mea, ‘Mea atu ki te hunga i kōrerotia; Nā, kua rite tāku hākari, kua oti āku pūru, āku mea mōmona te patu, ā, kua rite katoa ngā mea; haere mai ki te mārena.’ ");
INSERT INTO mri_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Otirā, i paopaongia e rātou, haere ana ko tētahi ki tāna māra, ko tētahi ki tāna hokohoko. ");
INSERT INTO mri_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nā, hopukina ana āna pononga e ngā mea i mahue, tūkinotia ana rātou, ā, whakamatea iho. ");
INSERT INTO mri_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Otiia, i riri te kīngi; ā, tonoa atu ana āna taua, whakangaromia ana taua hunga kōhuru, tahuna iho tō rātou pā. ");
INSERT INTO mri_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kātahi, ia ka mea ki āna pononga, ‘E rite ana te mārena, ko te hunga ia i karangatia kīhai i pai. ");
INSERT INTO mri_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nā, haere koutou ki ngā pekanga o ngā ara, ā, tonoa mai ki te mārena te hunga katoa e kite ai koutou.’ ");
INSERT INTO mri_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nā, ka haere aua pononga ki ngā ara, ā, huihuia katoatia ana te hunga i kitea e rātou, āna pai, āna kino; nā, kikī ana te mārena i ngā manuhiri. ");
INSERT INTO mri_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Otiia, nō te tapokoranga o te kīngi kia kite i ngā manuhiri, ka kitea e ia i reira he tangata kāhore nei ōna kākahu mārena; ");
INSERT INTO mri_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ā, ka mea ki a ia, ‘E hoa, he aha koe i tomo mai ai ki konei kāhore nei ōu kahu mārena?’ Heoi, kīhai ia i kuihi. ");
INSERT INTO mri_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nā, ka mea te kīngi ki ngā kaimahi, ‘Herea ōna ringa, ōna waewae, kawea atu, makā ki te pōuri i waho rawa; ko te wāhi tērā o te tangi, o te tetēā o ngā niho.’ ");
INSERT INTO mri_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“He tokomaha hoki e karangatia, he ruarua ia e whiriwhiria.” ");
INSERT INTO mri_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Me i reira ka haere ngā Parihi, ka rūnanga ki te pēhea e mau ai tētahi kupu āna. ");
INSERT INTO mri_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ā, ka tonoa ki a ia ā rātou ākonga me ngā tāngata piri ki a Herora, hei mea, “E te Kaiwhakaako, e mātau ana mātou he pono koe, e whakaako ana koe i te ara a te Atua i runga i te pono, e kore anō tā te tangata, e whakaaroa e koe; e kore nei hoki koe e titiro ki te kanohi tangata. ");
INSERT INTO mri_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tēnā, kōrerotia ki a mātou, e pēhea ana tōu whakaaro? He mea tika rānei te hoatu takoha ki a Hīhā, kāhore rānei?” ");
INSERT INTO mri_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Otiia, i mōhio a Īhu ki tō rātou whakaaro kino, ā, ka mea, “He aha tā koutou e whakamātautau nā i ahau, e te hunga tinihanga? ");
INSERT INTO mri_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tēnā koa, kia kite ahau i te moni i takoha.” Ā, mauria mai ana e rātou ki a ia he pene. ");
INSERT INTO mri_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nā, ka mea ia ki a rātou, “Nō wai tēnei āhua me te tuhituhinga?” ");
INSERT INTO mri_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ka mea rātou ki a ia, “Nō Hīhā.” Kātahi ia ka mea ki a rātou, “Hoatu ki a Hīhā, ngā mea a Hīhā, ki te Atua anō ngā mea a te Atua.” ");
INSERT INTO mri_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ka rongo rātou, ka mīharo; ā, mahue ake ia i a rātou, ā, haere ana rātou. ");
INSERT INTO mri_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","I taua rā ka haere mai ki a ia ngā Haruki, e mea nei kāhore he aranga, ka ui ki a ia, ");
INSERT INTO mri_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ka mea, “E te Kaiwhakaako, i mea a Mohi, ki te mate te tangata, ā, kāhore āna tamariki, mā tōna teina e mārena tāna wahine, e whakatupu ake he uri mō tōna tuakana. ");
INSERT INTO mri_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nā, tokowhitu tētahi whānau i a mātou, he tuākana, he tēina; te mārenatanga o te tuatahi, ka mate, ā, hore ōna uri, waiho iho tāna wahine mā tōna teina. ");
INSERT INTO mri_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Me te tuarua anō, me te tuatoru, puta noa i te tuawhitu. ");
INSERT INTO mri_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ā muri iho i a rātou katoa, ka mate te wahine. ");
INSERT INTO mri_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nā, i te aranga, mā wai o te tokowhitu te wahine? I a rātou katoa nei hoki ia.” ");
INSERT INTO mri_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nā, ka whakahoki a Īhu, ka mea ki a rātou, “E hē ana koutou, tē mōhio ki ngā karaipiture, ki te kaha anō o te Atua. ");
INSERT INTO mri_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","I te aranga hoki e kore rātou e mārena, e kore anō e hoatu kia mārenatia, engari, ka rite ki ngā anahera a te Atua i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nā, ko te aranga o te hunga mate, kāhore anō koutou i kite i tā te Atua i kōrero ai ki a koutou, i mea ai, ");
INSERT INTO mri_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ko ahau te Atua o Āperahama, te Atua o Īhaka, te Atua o Hākopa’? Ehara te Atua i te Atua nō te hunga mate, engari, nō te hunga ora.” ");
INSERT INTO mri_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ā, nō ka rongo te mano, ka mīharo ki tāna ako. ");
INSERT INTO mri_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nō te rongonga ia o ngā Parihi, kua kopi i a ia te māngai o ngā Haruki, ka whakamine tahi rātou. ");
INSERT INTO mri_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nā, ka ui tētahi o rātou, he kaiako i te ture, ka whakamātautau i a ia, ka mea, ");
INSERT INTO mri_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“E te Kaiwhakaako, ko tēhea te kupu nui o te ture?” ");
INSERT INTO mri_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka mea a Īhu ki a ia, “‘Kia whakapaua tōu ngākau, tōu wairua, tōu hinengaro, ki te aroha ki te Ariki, ki tōu Atua.’ ");
INSERT INTO mri_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ko te tuatahi tēnei, ko te kupu nui. ");
INSERT INTO mri_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","He rite anō te tuarua ki tēnei, ‘Kia aroha koe ki tōu hoa tata, ānō ko koe.’ ");
INSERT INTO mri_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kei runga i ēnei kupu e rua e iri ana te ture me ngā poropiti.” ");
INSERT INTO mri_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ā, i ngā Parihi e noho huihui ana, ka ui a Īhu ki a rātou, ");
INSERT INTO mri_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ka mea, “He pēhea ō koutou whakaaro ki a te Karaiti? Nā wai ia tama?” Ka mea rātou ki a ia, “Nā Rāwiri.” ");
INSERT INTO mri_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka mea ia ki a rātou, “He aha rā a Rāwiri, i a ia e nohoia ana e te Wairua, i karanga ai i a ia he Ariki? I mea hoki ia, ");
INSERT INTO mri_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘I mea te Ariki ki tōku Ariki: Hei tōku matau koe noho ai, kia meinga rā anō e ahau ōu hoariri hei tūranga waewae mōu.’ ");
INSERT INTO mri_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nā, ka kīa nei ia e Rāwiri he Ariki, he pēhea i tama ai ki a ia?” ");
INSERT INTO mri_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ā, hore he tangata i āhei te whakahoki kupu ki a ia, kīhai rawa anō tētahi i māia ki te ui ki a ia i taua rā iho anō. ");
INSERT INTO mri_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Me i reira ka kōrero a Īhu ki te mano, ki āna ākonga hoki, ");
INSERT INTO mri_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ka mea, “Kei te nohoanga o Mohi ngā karaipi rātou ko ngā Parihi e noho ana; ");
INSERT INTO mri_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ko ngā mea katoa e mea ai rātou hei pupuri mā koutou, puritia, mahia; kei rite ia ā koutou mahi ki ā rātou mahi; ko tā rātou hoki he kōrero, kāhore he mahi. ");
INSERT INTO mri_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","E hereherea ana hoki e rātou ngā wahanga taimaha, he uaua me ka pīkaua, ā, whakawahā iho ki runga ki ngā pokohiwi o te tangata; heoi, kāhore rātou e pai kia whakakorikoria ki tētahi o ō rātou maihao. ");
INSERT INTO mri_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ko ā rātou mahi katoa e meatia ana hei mātakitaki mā te tangata; e whakawhānuitia ana e rātou ā rātou pairakere; e whakanuia ana anō ngā tāniko o ō rātou kākahu. ");
INSERT INTO mri_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ko tā rātou e rawe ai ko ngā nohoanga rangatira i ngā hākari, me ngā nohoanga rangatira i ngā whare karakia, ");
INSERT INTO mri_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","me ngā ohatanga i ngā kāinga hokohoko, ā, kia karangatia e te tangata, ‘E Rapi.’ ");
INSERT INTO mri_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Otiia, aua koutou e karangatia, ‘E Rapi,’ kotahi hoki tō koutou kaiwhakaako; ā, he tuākana, he tēina, koutou katoa. ");
INSERT INTO mri_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kaua anō tētahi e kīa hei matua mō koutou i runga i te whenua; kotahi hoki tō koutou Matua, ko tērā i te rangi. ");
INSERT INTO mri_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kaua anō koutou e kīa he kaiārahi, kotahi anō tō koutou kaiārahi, ko te Karaiti. ");
INSERT INTO mri_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ko te mea nui rawa hoki o koutou, hei kaimahi ia mā koutou. ");
INSERT INTO mri_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ki te whakahira hoki tētahi i a ia, ka whakaititia, ā, ki te whakaiti tētahi i a ia, ka whakahirangia.” ");
INSERT INTO mri_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Auē, te mate mō koutou, e ngā karaipi, e ngā Parihi, e te hunga tinihanga! E tūtakina ana hoki e koutou te rangatiratanga o te rangi ki ngā tāngata. Kāhore koutou e tomo, kāhore anō e tukua te hunga e tomo ana kia tapoko. ");
INSERT INTO mri_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Auē, te mate mō koutou, e ngā karaipi, e ngā Parihi, e te hunga tinihanga! Nō te mea, ka pau i a koutou ngā whare o ngā pouaru, ā, e māminga ana ki te īnoi roa; mō reira he nui rawa te hē e tau ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Auē, te mate mō koutou, e ngā karaipi, e ngā Parihi, e te hunga tinihanga! E taiāwhiotia ana hoki e koutou te moana me te whenua, kia tahuri mai ai tētahi hei porohiraiti, ā, nō ka riro mai, ka meinga ia e koutou hei tamaiti mō Kehena, kino noa atu i a koutou. ");
INSERT INTO mri_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Auē, te mate mō koutou, e ngā kaiārahi matapō, e mea nei, ‘Ki te oatitia te whare tapu e tētahi, he mea noa anō; otirā, ki te oatitia e tētahi te kōura o te whare tapu, ka mau tāna!’ ");
INSERT INTO mri_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","E ngā kūware, e ngā matapō, ko tēhea te mea nui, ko te kōura rānei, ko te whare tapu rānei i tapu ai te kōura? ");
INSERT INTO mri_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Me tēnei, ‘Ki te oatitia e tētahi te āta, he mea noa anō; otirā, ki te oatitia te whakahere i runga i te āta, ka mau tāna.’ ");
INSERT INTO mri_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","E ngā kūware, e ngā matapō, ko tēhea te mea nui, ko te whakahere, ko te āta rānei, i tapu ai te whakahere? ");
INSERT INTO mri_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nā, ki te oatitia e tētahi te āta, e oatitia ana e ia tērā mea, me ngā mea katoa i runga. ");
INSERT INTO mri_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ki te oatitia e tētahi te whare tapu, e oatitia ana e ia tērā mea, me te kainoho o roto. ");
INSERT INTO mri_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ki te oatitia hoki e tētahi te rangi, e oatitia ana e ia te torōna o te Atua, me te kainoho o runga. ");
INSERT INTO mri_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Auē, te mate mō koutou, e ngā karaipi, e ngā Parihi, e te hunga tinihanga! E hoatu ana e koutou te wāhi whakatekau o te miniti, o te anihi, o te kumine, ā, kapea ake ngā mea nunui o te ture, te whakawā, te tohu tangata, te whakapono; he tika kia meatia e koutou ēnei, engari kaua tērā rā e kapea. ");
INSERT INTO mri_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","E ngā kaiārahi matapō, e tātari nei i te waeroa, ā, horomia ake te kāmera. ");
INSERT INTO mri_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Auē, te mate mō koutou e ngā karaipi, e ngā Parihi, e te hunga tinihanga! E horoi nei i waho o te kapu, o te pereti, ko roto ia kī tonu i te pāhua, i te taikaha. ");
INSERT INTO mri_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","E te Parihi matapō, mātua horoia a roto o te kapu, o te pereti, kia mā ai hoki a waho. ");
INSERT INTO mri_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Auē, te mate mō koutou, e ngā karaipi, e ngā Parihi, e te hunga tinihanga! He rite hoki koutou ki ngā urupā kua oti te pani ki te paru mā, ko waho he ātaahua ki te titiro atu, ko roto ia kī tonu i ngā kōiwi tūpāpaku, i ngā mea poke katoa. ");
INSERT INTO mri_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","He pēnā hoki koutou, ko waho e tika ana ki tā te tangata titiro, ko roto ia e kī ana i te tinihanga, i te kino. ");
INSERT INTO mri_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Auē, te mate mō koutou, e ngā karaipi, e ngā Parihi, e te hunga tinihanga! Ko koutou nei hoki hei hanga i ngā tanumanga o ngā poropiti, hei whakapaipai i ngā urupā o ngā tāngata tika, ");
INSERT INTO mri_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","me te kī anō, ‘Me i ngā rā tātou o ō tātou mātua, kīhai tātou i uru tahi me rātou ki te whakaheke i te toto o ngā poropiti.’ ");
INSERT INTO mri_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","He whakaatu tērā nā koutou, ko koutou ngā tamariki a te hunga nāna i patu ngā poropiti. ");
INSERT INTO mri_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tēnā rā, kia kī i a koutou te mēhua a ō koutou mātua. ");
INSERT INTO mri_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","E ngā neke, e te uri nākahi, me aha ka rere ai koutou i te kupu tuku ki te rēinga? ");
INSERT INTO mri_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nā, ka tonoa atu e ahau ki a koutou ngā poropiti, ngā tāngata mahara, ngā karaipi; ko ētahi o rātou e whakamatea e koutou, e rīpekatia; ko ētahi e whiua i roto i ō koutou whare karakia, e whāia hoki i tētahi pā ki tētahi pā. ");
INSERT INTO mri_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ā, ka utaina ki a koutou ngā toto katoa o te hunga tika i whakahekea ki te whenua, nō te toto o Āpera, o te tangata tika tae iho ki te toto o Hakaraia, o te tama a Parakia, i kōhurutia e koutou i waenganui o te whare tapu, o te āta. ");
INSERT INTO mri_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","He pono tāku e mea nei ki a koutou, tērā e pā ēnei mea katoa ki tēnei whakatupuranga. ");
INSERT INTO mri_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“E Hiruhārama, e Hiruhārama, e whakamate nei i ngā poropiti, e āki nei ki te kāmaka i te hunga e tonoa ana ki a koe, anō te tini o āku meatanga kia whakaminea āu tamariki, kia pērātia me te heihei e whakamine nei i āna pī ki raro i ōna parirau, ā, kīhai koutou i pai! ");
INSERT INTO mri_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nā, ka mahue atu ki a koutou tō koutou whare kia takoto noa ana. ");
INSERT INTO mri_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ko tāku kupu hoki tēnei ki a koutou, e kore koutou e kite i ahau ā mua ake nei, kia mea rā anō koutou ‘Ka whakapaingia ia e haere mai ana i runga i te ingoa o te Ariki.’ ” ");
INSERT INTO mri_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ā, ka puta atu a Īhu ki waho o te temepara, ka haere, nā, ka tae mai āna ākonga ki a ia kia whakakitea ki a ia ngā whare i hangā mō te temepara. ");
INSERT INTO mri_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Otirā, ka mea ia ki a rātou, “Kāhore ianei koutou e kite i ēnei mea katoa? He pono tāku e mea nei ki a koutou, e kore e toe ki konei tētahi kōhatu ki runga ake i tētahi kōhatu, engari ka whakahoroa katoatia.” ");
INSERT INTO mri_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ā, i a ia e noho ana i runga i Maunga Ōriwa, ka haere puku mai ngā ākonga ki a ia, ka mea, “Kōrerotia ki a mātou, ko āhea ēnei mea? He aha te tohu o tōu haerenga mai, o te mutunga hoki o te ao?” ");
INSERT INTO mri_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nā, ka whakahoki a Īhu, ka mea ki a rātou, “Kia tūpato kei māmingatia koutou e te tangata. ");
INSERT INTO mri_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","He tokomaha hoki e haere mai i runga i tōku ingoa, e mea, ‘Ko te Karaiti ahau’, ā, he tokomaha e whakapōhēhētia. ");
INSERT INTO mri_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ā, tērā koutou e rongo ki ngā pakanga, ki ngā hau kōrero pakanga; kia tūpato kei ohorere koutou; tā te mea kua rite kia puta ēnei mea katoa, taihoa ia te mutunga. ");
INSERT INTO mri_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","E whakatika hoki tētahi iwi ki tētahi iwi, tētahi rangatiratanga ki tētahi rangatiratanga; ā, e puta ngā pō matekai, ngā mate urutā, me ngā rū, ki ngā tini wāhi. ");
INSERT INTO mri_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Otirā, ko te tīmatanga kau ēnei katoa o ngā mamae. ");
INSERT INTO mri_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ko reira koutou tukua ai kia tūkinotia, ā, e whakamatea koutou; ā, e kino hoki ngā iwi katoa ki a koutou, he whakaaro ki tōku ingoa. ");
INSERT INTO mri_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ā, he tokomaha e hē, ā, ka tuku tētahi i tētahi, ka kino anō tētahi ki tētahi. ");
INSERT INTO mri_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","He tokomaha anō ngā poropiti teka e whakatika, ā, he tokomaha e whakapōhēhētia e rātou. ");
INSERT INTO mri_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ā, i te kino ka hua, ka mātoke haere te aroha o te tini tāngata. ");
INSERT INTO mri_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ko te tangata ia e ū ana, ā taea noatia te mutunga, ka ora ia. ");
INSERT INTO mri_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ā, e kauwhautia tēnei rongopai o te rangatiratanga puta noa i te ao, hei mea whakaatu ki ngā iwi katoa; ā, ko reira puta ai te mutunga.” ");
INSERT INTO mri_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ā, e kite koutou i te mea whakarihariha, i te mea whakangaro, i kōrerotia ai e Raniera poropiti, i a ia e tū ana i te wāhi tapu.” (Kia mātau te kaititiro pukapuka.) ");
INSERT INTO mri_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ko reira kia rere te hunga i Hūria ki ngā maunga; ");
INSERT INTO mri_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ko te tangata i runga i te whare kei heke iho ki te tiki mea i roto i tōna whare. ");
INSERT INTO mri_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kauaka anō te tangata i te māra e hoki ki te tiki i ōna kākahu. ");
INSERT INTO mri_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Auē, te mate mō te hunga e hapū ana, mō ngā mea hoki e whāngai ana ki te ū, i aua rā! ");
INSERT INTO mri_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Me īnoi koutou kei rokohanga koutou e te whati i te hōtoke, i te hāpati rānei. ");
INSERT INTO mri_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kei taua wā, hoki te whiu nui, kāhore ōna rite mai o te tīmatanga o te ao ā mohoa noa nei, e kore anō e pērā ā mua ake nei. ");
INSERT INTO mri_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ā, me i kāhore aua rā i poroa i waenga, hore he kikokiko e ora; otirā, ka whakaaroa te hunga i whiriwhiria, ā, ka poroa aua rā. ");
INSERT INTO mri_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ki te mea tētahi ki a koutou i reira, ‘Nā, tēnei a te Karaiti’; nā, ‘Tērā’; aua e whakaponohia. ");
INSERT INTO mri_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","E whakatika hoki ngā karaiti teka, me ngā poropiti teka, ā, ka hoatu e rātou ngā tohu nunui, me ngā mea whakamīharo; ā, mehemea e taea, ka māmingatia anō te hunga i whiriwhiria. ");
INSERT INTO mri_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nā, kua kōrerotia wawetia nei e ahau ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nā, ahakoa mea rātou ki a koutou ‘Nā, kei te koraha ia’; aua e haere atu. ‘Nā, kei ngā rūma o roto rawa’; aua e whakaponohia. ");
INSERT INTO mri_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ka rite hoki ki te uira e puta mai nei i te rāwhiti, ā, hiko tonu atu ki te uru, te haerenga mai o te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ko te wāhi hoki i te tūpāpaku, ko reira huihui ai ngā kāhu. ");
INSERT INTO mri_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ā muri tonu iho i te whakapāwera i aua rā, ‘Ka whakapōuritia te rā, e kore anō e titi te atarau, ka taka iho ngā whetū i te rangi, ā, ka ngāueue ngā mea kaha o ngā rangi.’ ");
INSERT INTO mri_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ko reira anō puta ai te tohu o te Tama a te tangata i te rangi; ā, ko reira ngā iwi katoa o te whenua tangi ai, ā, e kite rātou i te Tama a te tangata e haere mai ana i runga i ngā kapua o te rangi me te kaha, me te korōria nui. ");
INSERT INTO mri_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ā, e tonoa e ia āna anahera me te tētere tangi nui, ā, ka huihuia e rātou āna i whiriwhiri ai i ngā hau e whā, i tētahi pito o te rangi puta noa i tētahi pito. ");
INSERT INTO mri_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nā, kia ākona koutou e te piki ki tētahi kupu whakarite. I tōna manga e ngāwari ana anō, ā, ka puta ōna rau, ka mōhio koutou ka tata te raumati. ");
INSERT INTO mri_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Waihoki ko koutou, ina kite i ēnei mea katoa, ka mātau koutou ka tata ia, kei ngā kūwaha tonu. ");
INSERT INTO mri_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","He pono tāku e mea nei ki a koutou, E kore rawa tēnei whakatupuranga e pahemo, kia puta katoa rā anō ēnei mea. ");
INSERT INTO mri_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ko te rangi me te whenua e pahemo, ko āku kupu ia e kore e pahemo. ");
INSERT INTO mri_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Otirā, kāhore tētahi tangata e mōhio ki taua rā, ki taua hāora, kāhore rawa ngā anahera o te rangi, kāhore te Tama a te tangata, ko tōku Matua anake. ");
INSERT INTO mri_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ka rite hoki ki ngā rā i a Noa te haerenga mai o te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ka rite hoki ki tā rātou i ngā rā i mua atu o te waipuke; e kai ana, e inu ana, e mārena ana, e hoatu ana kia mārenatia, ā tae noa ki te rā i tomo ai a Noa ki roto ki te āka, ");
INSERT INTO mri_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ā, kāhore rātou i mōhio, ā, pakaru noa te waipuke, ā, kāhakina ana rātou katoa; e pērā anō te haerenga mai o te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","I taua wā tokorua ki te māra; kotahi e tangohia, kotahi e waiho. ");
INSERT INTO mri_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tokorua wāhine e huri ana i te mira; kotahi e tangohia, kotahi e waiho. ");
INSERT INTO mri_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kia mataara rāpea; e kore hoki koutou e mōhio ki te hāora e puta mai ai tō koutou Ariki. ");
INSERT INTO mri_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kia mōhio ki tēnei, me i mātau te tangata o te whare ki te mataaratanga e puta ai te tāhae, kua tautīaki ia, ā, kāhore i tukua tōna whare kia pokaia. ");
INSERT INTO mri_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nā, kia mataara hoki koutou; nō te mea ka puta mai te Tama a te tangata i te hāora e kore ai koutou e mahara. ");
INSERT INTO mri_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ko wai rā te pononga pono, mahara, i meinga e tōna ariki hei rangatira mō āna tāngata, hei hoatu i te kai mā rātou i te wā e tika ai? ");
INSERT INTO mri_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ka koa taua pononga ki te rokohanga e tōna ariki, ina haere mai, e pērā ana. ");
INSERT INTO mri_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","He pono tāku e mea nei ki a koutou, Ka meinga ia hei rangatira mō ōna taonga katoa. ");
INSERT INTO mri_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Otirā, ki te mea taua pononga kino i roto i tōna ngākau, ‘Ka roa te putanga mai o tōku ariki,’ ");
INSERT INTO mri_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ā, ka anga, ka patu i ōna hoa pononga, ka kai, ka inu tahi me te hunga haurangi. ");
INSERT INTO mri_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","E tae mai te ariki o taua pononga i te rā e kore ai ia e mahara, i te hāora e kore ai ia e mōhio. ");
INSERT INTO mri_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ka hātepea pūtia ia, ka meinga he wāhi mōna i roto i te hunga tinihanga; ko te wāhi tērā o te tangi, o te tetēā o ngā niho. ");
INSERT INTO mri_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nā, ka rite te rangatiratanga o te rangi ki ngā wāhina kotahi tekau, i mau i ā rātou rama, ā, haere ana ki te whakatau i te tāne mārena hou. ");
INSERT INTO mri_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tokorima o rātou he maharakore, tokorima he mahara. ");
INSERT INTO mri_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ko ngā mea maharakore i mau i ā rātou rama, kīhai ia i mau hinu. ");
INSERT INTO mri_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ko te hunga mahara i mau hinu atu i roto i ā rātou ipu me ā rātou rama. ");
INSERT INTO mri_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ka whakaroa te tāne mārena hou, ka tunewha rātou katoa, ka moe. ");
INSERT INTO mri_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nā, i waenganui pō, ka pā te karanga, ‘Ē, ko te tāne mārena hou! Puta mai koutou ki te whakatau i a ia.’ ");
INSERT INTO mri_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kātahi ka ara katoa aua wāhina, ka whakapai i ā rātou rama. ");
INSERT INTO mri_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nā, ka mea te hunga maharakore ki te hunga mahara, ‘Hōmai ki a mātou tētahi wāhi o tā koutou hinu; ka pirau hoki ā mātou rama.’ ");
INSERT INTO mri_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nā, ka whakahoki te hunga mahara, ka mea, ‘Kāhore! Kei kore e ranea mā mātou, mā koutou; engari, me haere koutou ki ngā kaihoko, hoko ai i tētahi mā koutou.’ ");
INSERT INTO mri_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ā, nō tō rātou haerenga atu ki te hoko, ka tae mai te tāne mārena hou; ā, tomo tahi ana me ia ki te mārena te hunga kua āta rite; ā, tūtakina ana te tatau. ");
INSERT INTO mri_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Muri iho ka tae ērā wāhina, ka mea, ‘E te ariki, e te ariki, uakina ki a mātou.’ ");
INSERT INTO mri_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nā, ka whakahoki ia, ka mea, ‘He pono tāku e mea nei ki a koutou, kāhore ahau e mōhio ki a koutou.’ ");
INSERT INTO mri_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Kia mataara rāpea koutou, e kore hoki koutou e mōhio ki te rā, ki te hāora, e puta mai ai te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ka rite hoki ki te tangata e haere ana ki tawhiti, karangatia ana e ia āna pononga ake, ā, hoatu ana ki a rātou āna taonga. ");
INSERT INTO mri_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ki tētahi i hoatu e ia e rima taranata, ki tētahi e rua, ki tētahi kotahi; ki ia tangata, ki ia tangata, he mea whakarite ki tō rātou uaua; ā, haere ana ia. ");
INSERT INTO mri_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nā, ko te haerenga o te tangata i a ia nei ngā taranata e rima, hokohokona ana aua mea e ia, ā, riro ana i a ia e rima atu ngā taranata. ");
INSERT INTO mri_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pērā anō hoki te tangata i ngā mea e rua; e rua atu i riro i a ia. ");
INSERT INTO mri_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ko te tangata ia i te mea kotahi, haere ana, kei te keri ki te whenua, ā, hunā ana e ia te moni a tōna ariki. ");
INSERT INTO mri_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ā roa rawa iho, ka puta te ariki o aua pononga, ka mea kia kōrerotia āna moni e rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ā, ko te haerenga o te tangata i a ia nei ngā taranata e rima, ka mauria mai e ia e rima atu ngā taranata, ā, ka mea, ‘E te ariki, e rima āu taranata i hōmai ai ki ahau; nā, e rima atu ngā taranata kua riro mai i ahau hei tāpiri mō ērā.’ ");
INSERT INTO mri_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ka mea tōna ariki ki a ia, ‘Pai rawa, e te pononga pai, e te pononga pono; pono tāu mahi ki ngā mea ruarua māku koe e mea hei rangatira mō ngā mea maha; uru mai koe ki te hari o tōu ariki.’ ");
INSERT INTO mri_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Me tērā hoki i a ia nei ngā taranata e rua, ka haere mai, ka mea, ‘E te ariki, e rua āu taranata i hōmai ai ki ahau; nā, e rua atu ngā taranata kua riro mai i ahau hei tāpiri mō ērā.’ ");
INSERT INTO mri_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ka mea tōna ariki ki a ia, ‘Pai rawa, e te pononga pai, e te pononga pono; pono tonu tāu mahi ki ngā mea ruarua, māku koe e mea hei rangatira mō ngā mea maha; uru mai koe ki te hari o tōu ariki.’ ");
INSERT INTO mri_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ā, ko te haerenga mai hoki o te tangata i a ia nei te taranata kotahi, ka mea, ‘E te ariki, i mātau ahau ki a koe he tangata pakeke koe, e kokoti ana i te wāhi kīhai i ruia e koe, e kohikohi ana i te wāhi kīhai i whakatītaria e koe. ");
INSERT INTO mri_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nā, ka wehi ahau, ā, haere ana, hunā ana i tāu taranata ki te whenua; nā, tāu nā.’ ");
INSERT INTO mri_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nā, ka whakahoki tōna ariki, ka mea ki a ia, ‘Pononga kino, pononga māngere, i mātau koe e kokoti ana ahau i te wāhi kīhai i ruia e ahau, e kohikohi ana i te wāhi kīhai i whakatītaria e ahau. ");
INSERT INTO mri_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ko te mea tika hoki kia kawea e koe tāku moni ki ngā rangatira pēke moni, ā, ka tae mai ahau, ka riro mai tāku me ōna hua anō. ");
INSERT INTO mri_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ko tēnei, tangohia te taranata i a ia, hoatu ki tērā i ngā taranata kotahi tekau. ");
INSERT INTO mri_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ki te whai mea hoki tētahi, ka hoatu anō ki a ia, ā, ka maha atu āna; ā, ki te kāhore he mea a tētahi, ko āna mea ake ka tangohia i a ia. ");
INSERT INTO mri_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nā, makā te pononga huakore ki te pōuri i waho; ko te wāhi tērā o te tangi, o te tetēā o ngā niho.’ ");
INSERT INTO mri_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nā, hei te taenga mai o te Tama a te tangata me tōna korōria, rātou tahi ko ngā anahera, ko reira ia noho ai ki runga ki te torōna o tōna korōria. ");
INSERT INTO mri_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ā, ka whakaminea ki tōna aroaro ngā iwi katoa; ka wehea rātou e ia ētahi i ētahi, ka pērātia me te hēpara e wehe nei i ngā hipi, i ngā koati. ");
INSERT INTO mri_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ka whakatūria e ia ngā hipi ki tōna matau, ko ngā koati ki mauī. ");
INSERT INTO mri_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kātahi, te Kīngi ka mea ki te hunga i tōna matau, ‘Haere mai, e te hunga whakapai a tōku Matua, nohoia te rangatiratanga kua rite noa ake mō koutou nō te orokohanganga rā anō o te ao. ");
INSERT INTO mri_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","I hiakai hoki ahau, ā, whāngainga ana e koutou. I matewai ahau, ā, whakainumia ana e koutou; he manene ahau, ā, whakamanuhiritia ana e koutou. ");
INSERT INTO mri_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","I tū tahanga, ā, whakakākahuria ana e koutou; he tūroro, ā, tirotirohia ana ahau e koutou; i te whare herehere ahau, ā, haere mai ana koutou ki ahau.’ ");
INSERT INTO mri_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Nā, ka whakahoki te hunga tika ki a ia, ka mea, ‘E te Ariki, nōnahea mātou i kite ai i a koe e hiakai ana, ā, whāngai ana i a koe? E mate ana rānei i te wai, ā, whakainu ana i a koe? ");
INSERT INTO mri_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nōnahea mātou i kite ai i a koe e manene ana, ā, whakamanuhiri ana i a koe? E tū tahanga ana rānei, ā, whakakākahu ana i a koe? ");
INSERT INTO mri_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nōnahea hoki mātou i kite ai i a koe e tūroro ana, i te whare herehere rānei, ā, haere ana ki a koe?’ ");
INSERT INTO mri_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ko reira whakahoki ai te Kīngi, mea ai ki a rātou, ‘He pono tāku e mea nei ki a koutou, ko tā koutou i mea ai ki tētahi o āku tēina, ahakoa ki te iti rawa, he meatanga tēnā ki ahau.’ ");
INSERT INTO mri_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ko reira ia kī atu ai ki te hunga i te taha ki mauī, ‘Mawehe atu i ahau, e te hunga ka oti nei te kanga, ki te ahi kā tonu, kua kā noa ake mō te rēwera rātou ko āna anahera. ");
INSERT INTO mri_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","I hiakai hoki ahau, ā, kīhai i whāngainga e koutou; i mate i te wai, ā, kīhai i whakainumia e koutou. ");
INSERT INTO mri_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","He manene ahau, ā, kīhai i whakamanuhiritia e koutou. I tū tahanga, ā, kīhai i whakakākahuria e koutou; he tūroro ahau, i te whare herehere, ā, kīhai koutou i tirotiro i ahau.’ ");
INSERT INTO mri_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ko reira anō rātou whakahoki ai ki a ia, mea ai, ‘E te Ariki, nōnahea mātou i kite ai i a koe e hiakai ana, e matewai ana, e manene ana, e tū tahanga ana, e tūroro ana, i te whare herehere rānei, ā, kīhai i mahi mea māu?’ ");
INSERT INTO mri_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ko reira whakahoki ai ia ki a rātou, mea ai, ‘He pono tāku e mea nei ki a koutou, I te mea kīhai nei i meatia e koutou ki tētahi o ngā nonohi rawa nei, inā, kīhai i meatia ki ahau.’ ");
INSERT INTO mri_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nā, ko ēnei e haere ki te whiu utu hara kāhore nei ōna mutunga; ko te hunga tika ia ki te ora tonu.” ");
INSERT INTO mri_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ā, ka mutu ēnei kupu katoa a Īhu, ka mea ia ki āna ākonga, ");
INSERT INTO mri_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“E mātau ana koutou kia rua ake rā ko te Kapenga, ā, ka tukua te Tama a te tangata kia rīpekatia.” ");
INSERT INTO mri_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nā, ka whakamine ngā tohunga nui, ngā karaipi, me ngā kaumātua o te iwi, ki te whare o te tohunga nui, ko Kaiapa te ingoa, ");
INSERT INTO mri_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ka whakatakoto tikanga nanakia e mau ai a Īhu, e whakamatea ai. ");
INSERT INTO mri_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Otirā, i mea rātou, “Kauaka i te hākari, kei ngangau te iwi.” ");
INSERT INTO mri_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nā, i a Īhu i Petani i te whare o Haimona repera, ");
INSERT INTO mri_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ka haere mai tētahi wahine ki a ia me te pouaka kōhatu, kī tonu i te hinu kakara utu nui, ā, ringihia ana ki runga ki tōna mātenga, i a ia e noho ana ki te kai. ");
INSERT INTO mri_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nō te kitenga ia o āna ākonga, ka riri, ka mea, “Hei aha tēnei maumau? ");
INSERT INTO mri_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","He nui hoki te utu me i hokona tēnei hinu kakara, ka hoatu ki te hunga rawakore.” ");
INSERT INTO mri_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ā, i mōhio a Īhu, ka mea ki a rātou, “He aha tā koutou e whakapāwerawera i te wahine nei? He mahi pai hoki tāna i mea nei ki ahau. ");
INSERT INTO mri_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kei a koutou tonu hoki te hunga rawakore i ngā wā katoa; tēnā ko ahau e kore e noho tonu ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I ringihia ai hoki tēnei hinu kakara ki tōku tinana, he mea mō tōku tanumanga. ");
INSERT INTO mri_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","He pono tāku e mea nei ki a koutou, Ko ngā wāhi o te ao katoa e kauwhautia ai tēnei rongopai, ka kōrerotia anō tā tēnei wahine i mea ai, hei whakamahara ki a ia.” ");
INSERT INTO mri_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kātahi, ka haere tētahi o te tekau mā rua, ko Hūrā Ikariote te ingoa, ki ngā tohunga nui, ");
INSERT INTO mri_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ka mea, “He aha tā koutou e pai ai kia hōmai ki ahau, ā, māku ia e tuku ki a koutou?” Ā, ka pāunatia e rātou e toru tekau hiriwa ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ā, nō reira mai anō ia i rapu ai i te wā pai e tukua ai ia. ");
INSERT INTO mri_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nā, i te rā tuatahi o te Taro Rēwenakore, ka haere ngā ākonga ki a Īhu, ka mea ki a ia, “Ko hea tāu e pai ai kia takā e mātou te Kapenga hei kai māu?” ");
INSERT INTO mri_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nā, ka mea ia, “Haere ki te pā, ki a mea, ka kī atu ki a ia, ‘E mea ana te Kaiwhakaako, Ka tata tōku tāima; hei a koe mātou ko āku ākonga mea ai i te Kapenga.’ ” ");
INSERT INTO mri_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ā, meatia ana e ngā ākonga tā Īhu i whakarite ai ki a rātou; takā ana e rātou te Kapenga. ");
INSERT INTO mri_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ka ahiahi, ka noho ia me te tekau mā rua. ");
INSERT INTO mri_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ā, i a rātou e kai ana, ka mea ia, “He pono tāku e mea nei ki a koutou, mā tētahi o koutou ahau e tuku.” ");
INSERT INTO mri_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ā, pōuri noa iho rātou, ka anga, ka kōrero takitahi ki a ia, “Ko ahau rānei, e te Ariki?” ");
INSERT INTO mri_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ā, ka whakahoki ia, ka mea, “Ko te tangata, e toutou tahi nei ō māua ringa ki te rīhi, māna ahau e tuku. ");
INSERT INTO mri_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","E haere ana hoki te Tama a te tangata, e pērā ana me te mea i tuhituhia mōna. Otiia, auē te mate mō te tangata e tukua ai te Tama a te tangata! He pai mō taua tangata me i kaua ia e whānau.” ");
INSERT INTO mri_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kātahi a Hūrā, tōna kaituku, ka oho ake, ka mea, “E te Kaiwhakaako, ko ahau rānei?” Anō rā ko ia ki a ia, “Kua kōrerotia nā e koe.” ");
INSERT INTO mri_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ā, i a rātou e kai ana, ka mau a Īhu ki te taro, ā, ka mutu te whakapai, ka whawhati. Ka hoatu ki ngā ākonga, ka mea, “Tangohia, kainga; ko tōku tinana tēnei.” ");
INSERT INTO mri_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nā, ka mau ia ki te kapu, ā, ka mutu te whakawhetai, ka hoatu ki a rātou, ka mea, “Inumia tētahi wāhi o tēnei e koutou katoa. ");
INSERT INTO mri_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ko ōku toto hoki ēnei, ko o te kawenata hou, e whakahekea ana mō te tini, hei murunga hara. ");
INSERT INTO mri_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nā, ko tāku kupu tēnei ki a koutou, e kore ahau e inu i tēnei hua o te wāina ā mua ake nei, kia taea rā anō taua rā e inumia houtia ai e tātou i te rangatiratanga o tōku Matua.” ");
INSERT INTO mri_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ā, nō ka mutu tā rātou hīmene, ka haere ki Maunga Ōriwa. ");
INSERT INTO mri_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kātahi, a Īhu ka mea ki a rātou, “Ka hē katoa koutou ki ahau i tēnei pō, kua oti hoki te tuhituhi, ‘Ka patua e ahau te hēpara, ā, ka whakamararatia ngā hipi o te kāhui.’ ");
INSERT INTO mri_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Otirā, muri iho i tōku aranga, ka haere ahau i mua i a koutou ki Kariri.” ");
INSERT INTO mri_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nā, ka whakahoki a Pita, ka mea ki a ia, “Ahakoa hē noa te katoa ki a koe, e kore rawa ahau e hē.” ");
INSERT INTO mri_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ka mea a Īhu ki a ia, “He pono tāku e mea nei ki a koe, ko tēnei pō anō, i te mea kāhore anō i tangi noa te tīkaokao, ka toru āu whakakāhoretanga i ahau.” ");
INSERT INTO mri_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ka mea a Pita ki a ia, “Ahakoa kua takoto te tikanga kia mate tahi tāua, e kore ahau e whakakāhore i a koe.” I pērā anō te kī a ngā ākonga katoa. ");
INSERT INTO mri_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kātahi, ka haere rātou ko Īhu ki tētahi wāhi, tōna ingoa nei ko Kehemane, ā, ka mea ia ki āna ākonga, “Hei konei koutou noho ai, kia haere ahau ki kōina īnoi ai.” ");
INSERT INTO mri_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nā, ka mau ia ki a Pita rātou ko ngā tama tokorua a Heperi, ā, ka tīmata te pōuri, te tūmatatenga. ");
INSERT INTO mri_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nā, ka mea ia ki a rātou, “Kī tonu tōku wairua i te pōuri, tata pū ki te mate; hei konei koutou noho ai, kia mataara tahi tātou.” ");
INSERT INTO mri_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ā, haere ana ia ki tahaki tata atu, ka takoto tāpapa, ka īnoi, ka mea, “E tōku Matua, ki te mea e āhei, kia pahemo atu tēnei kapu i ahau; otirā, kaua e waiho i tāku e pai ai, engari, i tāu.” ");
INSERT INTO mri_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ā, ka haere ia ki āna ākonga, rokohanga atu e moe ana, nā, ka mea ia ki a Pita, “Ha, ko tā koutou tēnei, tē mataara tahi tātou kia kotahi hāora? ");
INSERT INTO mri_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kia mataara me te īnoi, kei uru ki te whakamātautauranga. He hihiko te wairua, ko te kikokiko ia he ngoikore.” ");
INSERT INTO mri_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ka haere atu anō ia, ko te rua o ōna hokinga, ka īnoi, ka mea, “E tōku Matua, ki te kore e āhei kia pahemo atu tēnei kapu i ahau, ā, me inu anō e ahau, waiho i tāu i pai ai.” ");
INSERT INTO mri_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ko tōna haerenga mai anō, nā, rokohanga mai e moe ana anō rātou; i taimaha hoki ō rātou kanohi. ");
INSERT INTO mri_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nā, ka waiho anō rātou e ia, ā, haere ana anō, ka īnoi, ko te toru o ngā īnoinga, me te whakahua i taua kupu anō. ");
INSERT INTO mri_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kātahi, ia ka haere ki āna ākonga, ka mea ki a rātou, “Moe tonu, takoto mārie. Nā, ka tata te hāora, ka tukua te Tama a te tangata ki ngā ringa o te hunga hara. ");
INSERT INTO mri_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Maranga, ka haere tātou. Nana, ka tata te kaituku i ahau.” ");
INSERT INTO mri_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ā, i a ia anō e kōrero ana, nā, ka tae mai a Hūrā, tētahi o te tekau mā rua, he tini hoki ngā tāngata i a ia, me ngā hoari, me ngā patu, he mea tono mai nā ngā tohunga nui, nā ngā kaumātua o te iwi. ");
INSERT INTO mri_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kua oti hoki tētahi tohu te whakarite ki a rātou e tōna kaituku, i mea ia, “Nā, ko tāku tangata e kihi ai, koia tēnā; hopukia.” ");
INSERT INTO mri_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nā, tika tonu ia ki a Īhu, ka mea, “Tēnā koe, e te Kaiwhakaako!” ā, kihi ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nā, ka mea a Īhu ki a ia, “E hoa, meinga tāu i haere mai ai ki te mahi.” Me i reira ka haere mai rātou, ka pā ō rātou ringa ki a Īhu, ā, hopukia ana ia. ");
INSERT INTO mri_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nā, ka totoro te ringa o tētahi o ngā hoa o Īhu, ā, unuhia ana tāna hoari, ka hāua iho te pononga a te tino tohunga, tapahia ana tōna taringa. ");
INSERT INTO mri_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kātahi, ka mea a Īhu ki a ia, “Whakahokia iho tāu hoari ki tōna pūkoro; ka mate hoki i te hoari te hunga hāpai hoari. ");
INSERT INTO mri_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","E hua koe e kore e āhei i ahau āianei te īnoi ki tōku Matua, ā, e hōmai e ia ki ahau he anahera maha atu i ngā rihiona kotahi tekau mā rua? ");
INSERT INTO mri_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nei rā, mā te aha ka rite ai tā ngā karaipiture, arā, ko tēnei kia meatia?” ");
INSERT INTO mri_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","I taua wā, ka mea a Īhu ki ngā mano, “He tāhae ahau i haere mai ai koutou me ngā hoari me ngā patu ki te hopu i ahau? I a koutou ahau e noho ana i te temepara, e ako ana i tēnā rā, i tēnā rā, ā, kīhai koutou i hopu i ahau. ");
INSERT INTO mri_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nā, i meatia tēnei katoa hei whakarite mō ngā karaipiture a ngā poropiti.” Nā, ka whakarere ngā ākonga katoa i a ia, ā, oma ana. ");
INSERT INTO mri_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kātahi, ka kawea a Īhu e ngā kaihopu ki te whare o Kaiapa, o te tino tohunga, i reira hoki ngā karaipi me ngā kaumātua e huihui ana. ");
INSERT INTO mri_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ko Pita ia i aru i a ia i tawhiti ki te marae o te tino tohunga, ā, tomo atu ana, noho tahi ana me ngā kaimahi, kia kite i te mutunga. ");
INSERT INTO mri_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nā, ka rapu ngā tohunga nui, me ngā kaumātua, me te rūnanga katoa, ki te whakapae teka mō Īhu, kia mate ai ia. ");
INSERT INTO mri_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Heoi, kīhai i kitea; ahakoa he tokomaha ngā kaiwhakapae teka i haere mai. Muri iho ka puta ngā kaiwhakapae teka tokorua, ");
INSERT INTO mri_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ka kī, “I mea ia, ‘E taea e ahau te whakahoro te whare tapu o te Atua, ā, kia toru ngā rā ka oti i ahau te hanga.’ ” ");
INSERT INTO mri_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nā, kua whakatika te tino tohunga, ka mea ki a ia, “Kāhore āu kupu? He aha tā ēnei e whakaatu nei mōu?” ");
INSERT INTO mri_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Heoi, kīhai a Īhu i kuihi. Nā, ka kī anō te tino tohunga, ka mea ki a ia, “Ko te Atua ora tāku whakaoati mōu, nā, kōrero mai ki a mātou, ko te Karaiti rānei koe, ko te Tama a te Atua?” ");
INSERT INTO mri_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ka mea a Īhu ki a ia, “Kua kōrerotia mai nā e koe. Otirā, tēnei anō tāku kupu ki a koutou, ‘Tēnei ake ka kite koutou i te Tama a te tangata e noho ana ki matau o te kaha, e haere mai ana i runga i ngā kapua o te rangi.’ ” ");
INSERT INTO mri_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kātahi, ka haehae te tino tohunga i ōna kākahu, ka mea, “Kua kohukohu! Hei aha atu mā tātou ngā kaiwhakaatu? Nā, kua rongo nei koutou i tāna kohukohu. ");
INSERT INTO mri_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","E pēhea ana ō koutou whakaaro?” Nā, ka whakahoki rātou, ka mea, “Ka tika kia mate.” ");
INSERT INTO mri_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nā, ka tuwhaina tōna mata e rātou, ka kurua ia; ko ētahi i papaki i a ia, ");
INSERT INTO mri_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","i mea, “Poropiti ki a mātou, e te Karaiti! Nā wai koe i papaki?” ");
INSERT INTO mri_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nā, i waho a Pita e noho ana, i te marae; ā, ka haere mai tētahi kōtiro ki a ia, ka mea, “Ko koe hoki i a Īhu o Kariri.” ");
INSERT INTO mri_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Otirā, ka whakakāhore ia i te aroaro o rātou katoa, ka mea, “Kāhore ahau e mōhio ki tāu e kī mai nā.” ");
INSERT INTO mri_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ā, ka puta atu ia ki waho ki te whakamahau, ka kite anō tētahi atu kōtiro i a ia, ā, ka mea tērā ki te hunga i reira, “I a Īhu anō o Nahareta tēnei.” ");
INSERT INTO mri_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ā, ka whakakāhore anō ia, me te oati anō, “Kāhore ahau e mōhio ki tēnā tangata.” ");
INSERT INTO mri_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ā muri tata iho, ka haere mai te hunga e tū ana, ka mea ki a Pita, “Koia anō, ko koe tētahi o rātou; nā tōu reo koe i whakaatu.” ");
INSERT INTO mri_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kātahi ia, ka tīmata te kanga, te oati, “Kāhore rawa ahau e mōhio ki tēnā tangata!” Ā, tangi tonu iho te tīkaokao, ");
INSERT INTO mri_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","nā, ka mahara a Pita ki tā Īhu kupu i mea ai ki a ia, “E kore e tangi te tīkaokao, ka toru āu whakakāhoretanga i ahau.” Nā, haere ana ia ki waho, ā, nui atu tōna tangi. ");
INSERT INTO mri_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ā, ka tākiri te ata, ka rūnanga ngā tohunga nui katoa me ngā kaumātua o te iwi mō Īhu kia whakamatea. ");
INSERT INTO mri_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ā, nō ka oti ia te here, ka ārahina atu, tukua ana ki a Pirato, ki te kāwana. ");
INSERT INTO mri_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ā, nō te kitenga o Hūrā, o te kaituku i a ia, kua whakaaetia ia kia whakamatea, ka puta kē tōna whakaaro, whakahokia ana e ia ngā hiriwa e toru tekau ki ngā tohunga nui rātou ko ngā kaumātua, ");
INSERT INTO mri_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ka mea, “Kua hara ahau i tāku tukunga i te toto harakore.” Ka mea rātou, “Hei aha mā mātou? Māu tēnā e titiro.” ");
INSERT INTO mri_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nā, makā iho e ia ngā hiriwa ki te whare tapu, ā, puta ana ki waho, haere ana, tārona ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nā, ka tango ngā tohunga nui i ngā hiriwa, ka mea, “E kore e tika kia pangā ēnei ki te takotoranga moni, he utu toto hoki.” ");
INSERT INTO mri_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nō ka rūnanga rātou, ā, hokona ana ki aua mea te māra a te kaihanga rīhi, hei tanumanga mō ngā manene. ");
INSERT INTO mri_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nā reira hoki i huaina ai taua māra, “Ko te Māra o te Toto” ā mohoa noa nei. ");
INSERT INTO mri_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kātahi, ka rite tā Heremaia poropiti i kōrero ai, i mea ai: “Tangohia ana e rātou ngā hiriwa e toru tekau, te utu mō te tangata i whakaritea nei ōna utu, i whakaritea nei ngā utu e ētahi o ngā tama a Īharaira, ");
INSERT INTO mri_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ā, hoatu ana mō te māra a te kaihanga rīhi; i pērā anō me tā te Ariki i whakarite ai ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nā, i te tū tērā a Īhu i te aroaro o te kāwana; ka ui te kāwana ki a ia, ka mea, “Ko koe rānei te Kīngi o ngā Hūrai?” Ka mea a Īhu ki a ia, “Kua kōrerotia mai nā e koe.” ");
INSERT INTO mri_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ā, i te whakapānga a ngā tohunga nui rātou ko ngā kaumātua i tētahi hē ki a ia, kīhai ia i whakahoki kupu atu. ");
INSERT INTO mri_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kātahi, ka mea a Pirato ki a ia, “Kāhore koe e rongo i te tini o ngā mea e kōrerotia nei e rātou mōu?” ");
INSERT INTO mri_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Heoi, kāhore kia kotahi kupu i whakahokia e ia ki a ia; tino mīharo noa te kāwana. ");
INSERT INTO mri_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nā, ko tā te kāwana tikanga i taua hākari he tuku i tētahi herehere ki te iwi, i tā rātou e pai ai. ");
INSERT INTO mri_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","I reira anō i a rātou tētahi herehere ingoa nui, ko Parapa te ingoa. ");
INSERT INTO mri_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ā, nō rā ka mine rātou, ka mea a Pirato ki a rātou, “Ko wai tā koutou e pai ai kia tukua e ahau ki a koutou? Ko Parapa, ko Īhu rānei e huaina nei ko te Karaiti?” ");
INSERT INTO mri_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I mahara hoki ia he hae nō rātou i tukua ai ia. ");
INSERT INTO mri_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nā, i a ia e noho ana i runga i te nohoanga whakawā, ka tono tangata mai tāna wahine ki a ia, ka mea, “Kei ahatia e koe taua tangata tika. He maha hoki ngā mea i pā moemoeā mai ki ahau ināianei, he mea mōna.” ");
INSERT INTO mri_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Otiia, i whakakīkītia e ngā tohunga nui rātou ko ngā kaumātua te mano, kia īnoia a Parapa, kia whakangaromia a Īhu. ");
INSERT INTO mri_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nā, ka whakahoki te kāwana ka mea ki a rātou, “Ko tēhea o te tokorua tā koutou e pai ai kia tukua e ahau ki a koutou?” Ka mea rātou, “Ko Parapa!” ");
INSERT INTO mri_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ka mea a Pirato ki a rātou, “Me aha oti e ahau a Īhu, e huaina nei ko te Karaiti?” Ka mea rātou katoa ki a ia, “Rīpekatia!” ");
INSERT INTO mri_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nā, ka mea te kāwana, “He aha koia tāna kino i mea ai?” Heoi, nui noa atu tā rātou hāmama, ka mea, “Rīpekatia ia!” ");
INSERT INTO mri_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ā, i te kitenga o Pirato kāhore ia i whai wāhi, engari, ka nui kē atu te ngangau, ka mau ia ki te wai, ka horoi i ōna ringa i te aroaro o te mano, ka mea, “Kāhore ahau e whai hara i te toto o tēnei tangata tika; mā koutou tēnā e titiro.” ");
INSERT INTO mri_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nā, ka whakahoki te iwi katoa, ka mea, “Hei runga ōna toto i a mātou, i ā mātou tamariki.” ");
INSERT INTO mri_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nā, ka tukua e ia a Parapa ki a rātou; ā, ka oti a Īhu te whiu, ka tukua kia rīpekatia. ");
INSERT INTO mri_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kātahi ka mauria a Īhu e ngā hōia a te kāwana ki te whare whakawā, ā, whakaminea ana ki a ia te rōpū katoa. ");
INSERT INTO mri_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nā, ka tangohia e rātou ōna kākahu, ā, whakakākahuria ana ia ki te kākahu whero. ");
INSERT INTO mri_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ā, nō ka oti tētahi karauna tātarāmoa te whiri, ka pōtaea ki tōna mātenga, me te kākaho ki tōna ringa matau; ā, ka tukua ngā turi ki a ia, ka taunu ki a ia, ka mea, “Tēnā koe, e te Kīngi o ngā Hūrai!” ");
INSERT INTO mri_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ā, ka tuwhaina ia e rātou, ā, ka mau rātou ki te kākaho, ka patua ki tōna mātenga. ");
INSERT INTO mri_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nā, ka mutu tā rātou tāwai ki a ia, ka tīhorea atu i runga i a ia te kākahu rā, whakakākahuria ana ōna ki a ia, ā, ārahina ana ia kia rīpekatia. ");
INSERT INTO mri_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ā, i a rātou e haere ana ki waho, ka kitea e rātou he tangata nō Hairini, ko Haimona te ingoa; meinga ana ia e rātou kia haere tahi me rātou hei amo i tōna rīpeka. ");
INSERT INTO mri_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ā, i tō rātou taenga ki te wāhi e kīa nei ko Korokota, arā, ko “Te Wāhi Angaanga.” ");
INSERT INTO mri_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ka hoatu e rātou he wāina ki a ia kia inumia, he mea whakananu ki te au; ā, nō tāna whakamātauranga atu, kīhai i pai ki te inu. ");
INSERT INTO mri_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ā, ka oti ia te rīpeka, ka wehewehea ōna kākahu, he mea maka ki te rota; i rite ai te kupu i kōrerotia e te poropiti, “I wehewehea ōku weruweru mō rātou, i maka rota hoki mō tōku kākahu.” ");
INSERT INTO mri_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nā, noho ana rātou ki te tiaki i a ia i reira. ");
INSERT INTO mri_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ā, whakanohoia ana e rātou ki runga ake i tōna mātenga te mea i whakawākia ai ia, he mea tuhituhi, “Ko Īhu tēnei, ko te Kīngi o ngā Hūrai.” ");
INSERT INTO mri_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nā, tokorua ngā tāhae i rīpekatia ngātahitia me ia, kotahi ki matau, kotahi ki mauī. ");
INSERT INTO mri_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ā, ka kohukohu ki a ia te hunga e haere ana rā reira, me te oioi ō rātou mātenga, ");
INSERT INTO mri_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ka mea, “Ko koe hei whakahoro i te whare tapu, hei hanga anō i ngā rā e toru, whakaorangia koe e koe anō! Ki te mea ko te Tama koe a te Atua, heke iho i te rīpeka.” ");
INSERT INTO mri_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","I pēnā anō te tāwai a ngā tohunga nui, rātou ko ngā karaipi, ko ngā kaumātua, i mea, ");
INSERT INTO mri_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ko ērā atu i whakaorangia e ia; tē taea e ia te whakaora i a ia anō. Ko ia te Kīngi o Īharaira, tēnā kia heke iho oti ia i te rīpeka, ka whakapono mātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I whakawhirinaki ia ki te Atua; mā tērā ia e whakaora āianei, ki te pai ia ki a ia; nāna hoki te kī, ‘Ko te Tama ahau a te Atua.’ ” ");
INSERT INTO mri_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Me ngā tāhae hoki i rīpekatia tahitia rā me ia, i pērā anō tā rāua tāwai ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nā, ka pōuri a runga katoa o te whenua, nō te ono o ngā hāora ā taea noatia te iwa o ngā hāora. ");
INSERT INTO mri_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ā, ka tata ki te iwa o ngā hāora, ka karanga a Īhu, he nui te reo, ka mea, “Eri, Eri, rama hapakatani?” arā, “E tōku Atua, e tōku Atua, he aha koe i whakarere ai i ahau?” ");
INSERT INTO mri_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","I te rongonga o ētahi o te hunga e tū ana i reira, ka mea, “E karanga ana te tangata nei ki a Irāia.” ");
INSERT INTO mri_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nā, kua rere tētahi o rātou, kua mau ki te hautai, whakakīa ana ki te winika, ā, whakanohoia ana ki runga ki te kākaho, whakainumia ana māna. ");
INSERT INTO mri_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka mea ehinu, “Kāti, kia kite tātou e haere mai rānei a Irāia ki te whakaora i a ia.” ");
INSERT INTO mri_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nā, ka karanga anō a Īhu, he nui te reo, ā, tuku atu ana i tōna wairua. ");
INSERT INTO mri_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nā, ka wāhia te ārai o te whare tapu i waenganui pū, mai i runga, ā, ki raro. Ka rū te whenua, pakaru ana ngā kāmaka. ");
INSERT INTO mri_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ko ngā urupā tuwhera kau; ā, he maha ngā tinana o te hunga tapu kua moe i ara mai. ");
INSERT INTO mri_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ko te putanga ake i ngā urupā i muri iho o tōna aranga mai, haere ana ki roto ki te pā tapu, ā, he tokomaha te hunga i kite i a rātou. ");
INSERT INTO mri_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nā, i te kitenga o te keneturio rātou ko ōna hoa tiaki i a Īhu i te rū, i ngā mea anō i meatia, nui atu tō rātou wehi, ka mea, “He pono ko te Tama tēnei a te Atua.” ");
INSERT INTO mri_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ā, he tokomaha ngā wāhine i reira e mātakitaki ana mai i tawhiti, ngā mea i aru mai i a Īhu i Kariri, i mahi mea māna. ");
INSERT INTO mri_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","I roto i a rātou a Meri Makarini, a Meri whaea o Hēmi rāua ko Hohi, me te whaea hoki o ngā tama a Heperi. ");
INSERT INTO mri_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nā, ka ahiahi, ka haere mai tētahi tangata taonga nui o Arimatia, ko Hōhepa te ingoa, he ākonga anō ia nā Īhu. ");
INSERT INTO mri_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I haere taua tangata ki a Pirato, ā, tonoa ana e ia te tinana o Īhu. Nā, ka mea a Pirato kia hoatu te tinana. ");
INSERT INTO mri_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nā, ka tango a Hōhepa i te tinana, ā, takaia ana e ia ki te rīnena mā, ");
INSERT INTO mri_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","whakatakotoria ana ki tāna urupā hou, i hāua e ia ki roto ki te kāmaka. Nā, whakatakā atu ana e ia tētahi kōhatu nui ki te kūwaha o te urupā, ā, haere ana. ");
INSERT INTO mri_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","I reira anō a Meri Makarini, me tērā Meri, e noho ana i te ritenga atu o te tanumanga. ");
INSERT INTO mri_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nā, i te aonga ake, i te rā i muri i te Takanga hākari, ka haere ngā tohunga nui me ngā Parihi ki a Pirato, ");
INSERT INTO mri_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ka mea, “E mara, kei te mahara mātou ki te kōrero a tērā tangata tinihanga i a ia anō e ora ana, ‘Kia taka ngā rā e toru ka ara ahau.’ ");
INSERT INTO mri_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nā reira, whakahaua atu kia tiakina te tanumanga, ā tae noa ki te toru o ngā rā, kei haere āna ākonga i te pō, ka tāhae i a ia, ka mea ki te iwi, ‘Kua ara ia i te hunga mate,’ pēnei kino atu i tō mua tō muri hē.” ");
INSERT INTO mri_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ka mea a Pirato ki a rātou, “He kaitiaki anō a koutou; haere, kia puta ō koutou whakaaro kei taea atu ia.” ");
INSERT INTO mri_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nā, haere ana rātou, hīritia ana te kōhatu, me te whakanoho anō i ngā kaitiaki, kei taea atu te tanumanga. ");
INSERT INTO mri_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","I te mutunga o te hāpati i te mea ka tata tonu te pūao te rā tuatahi o te wiki, ka haere a Meri Makarini me tērā Meri kia kite i te tanumanga. ");
INSERT INTO mri_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nā, he nui te rū i puta mai; i heke iho hoki tētahi anahera a te Ariki i te rangi, ā, haere ana, whakatakā atu ana e ia te kōhatu i te kūwaha, ā, noho ana i runga. ");
INSERT INTO mri_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ko tōna āhua me te mea he uira, mā tonu tōna kākahu ānō he hukarere. ");
INSERT INTO mri_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ā, wiri noa iho ngā kaitiaki i te wehi ki a ia, ka rite ki te tūpāpaku. ");
INSERT INTO mri_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nā, ka oho te anahera, ka mea ki ngā wāhine, “Kei wehi kōrua; e mātau ana hoki ahau, e rapu ana kōrua i a Īhu i rīpekatia. ");
INSERT INTO mri_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kāhore ia i konei; kua ara kē, kua pērā me tāna i mea ai. Haere mai kia kite i te wāhi i takoto ai te Ariki. ");
INSERT INTO mri_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ā, hohoro te haere, kōrerotia ki āna ākonga, ‘Kua ara ia i te hunga mate; tēnā ia te haere nā i mua i a koutou ki Kariri; ko reira koutou kite ai i a ia.’ Nā, kua kōrero nei ahau ki a kōrua.” ");
INSERT INTO mri_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ā, hohoro tonu tā rāua haere atu i te urupā, me te wehi, me te harakoa nui, ā, oma ana ki te kōrero ki āna ākonga. ");
INSERT INTO mri_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nā, ka tūtaki a Īhu ki a rāua, ka mea mai, “E ia mā.” Nā, ka haere atu rāua, ka pupuri i ōna waewae, ka koropiko ki a ia. ");
INSERT INTO mri_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kātahi a Īhu ka mea ki a rāua, “Aua e wehi; haere, kī atu ki ōku tēina kia haere ki Kariri, ko reira hoki rātou kite ai i ahau.” ");
INSERT INTO mri_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ā, i a rāua e haere ana, nā, kua tae ētahi o ngā kaitiaki ki te pā, kua kōrero ki ngā tohunga nui i ngā mea katoa i meatia. ");
INSERT INTO mri_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nā, ka mutu tā rātou huihui ko ngā kaumātua, ā, ka rūnanga, ka hoatu e rātou he moni nui ki ngā hōia, ");
INSERT INTO mri_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ka mea atu, “Me kī e koutou, ‘I haere āna ākonga i te pō, ā, tāhaetia ana ia, i a mātou e moe ana.’ ");
INSERT INTO mri_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ā, ki te tae te rongo o tēnei ki te kāwana, mā mātou ia e whakamārie, ā, kāhore he mānukanuka mō koutou.” ");
INSERT INTO mri_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nā, ka tango rātou i ngā moni, ā, meinga ana ngā mea i ākona ai rātou. Heoi, kei te kōrerotia tēnei e ngā Hūrai, ā taea noatia tēnei rā. ");
INSERT INTO mri_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nā, ka haere ngā ākonga tekau mā tahi ki Kariri, ki te maunga i whakaritea e Īhu ki a rātou. ");
INSERT INTO mri_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ā, i tō rātou kitenga i a ia, ka koropiko ki a ia; ko ētahi ia i ruarua. ");
INSERT INTO mri_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nā, ka haere mai a Īhu, ka kōrero ki a rātou, ka mea, “Kua tukua katoatia mai ki ahau te mana i te rangi, ā, i runga i te whenua ");
INSERT INTO mri_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nā reira haere, meinga hei ākonga ngā iwi katoa, iriiria i runga i te ingoa o te Matua, o te Tama, o te Wairua Tapu, ");
INSERT INTO mri_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ākona rātou kia mau ki ngā mea katoa i whakahaua, e ahau ki a koutou. Nā, ko ahau tēnā hei hoa mō koutou i ngā rā katoa, ā te mutunga rā anō o te ao.” Āmine.");
INSERT INTO mri_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ko te tīma­tanga o te rongo­pai o Īhu Karaiti, o te Tama a te Atua. ");
INSERT INTO mri_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ko te mea ia i tuhi­tuhia i roto i tā Ihāia poro­piti: “Nā, ka tonoa e ahau tāku karere i mua i tōu aro­aro, māna e whaka­pai tōu ara i mua i a koe. ");
INSERT INTO mri_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","He reo nō tētahi i te koraha e karanga ana, ‘Whaka­paia te hua­rahi o te Ariki, whaka­tikaia ōna ara.’ ” ");
INSERT INTO mri_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","I haere mai a Hoani, ka iri­iri i te koraha, ka kauwhau i te iri­iri rīpe­netā hei muru­nga hara. ");
INSERT INTO mri_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nā, ka haere ki a ia te whenua katoa o Hūria, me ngā tāngata o Hiruhārama, ā, iri­iria katoa­tia ana e ia ki te awa ki Horano, me te whāki anō i ō rātou hara. ");
INSERT INTO mri_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nā, ko te kākahu o Hoani he huru­huru kāmera, he hiako hoki te whī­tiki o tōna hope; ko tāna kai he mā­whiti­whiti he honi koraha. ");
INSERT INTO mri_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ā, i kauwhau ia, i mea, “Tēnei te haere mai nei i muri i ahau tētahi he kaha rawa ake i ahau, e kore ahau e tau ki te piko iho wewete ai i te here o ōna hū. ");
INSERT INTO mri_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ko ahau nei, he iri­iri tāku i a koutou ki te wai; māna ia koutou e iri­iri ki te Wairua Tapu.” ");
INSERT INTO mri_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ā, i aua rā ka haere mai a Īhu i Nahareta o Kariri, ka iri­iria e Hoani ki Horano. ");
INSERT INTO mri_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ā, i taua wā anō i a ia e haere ake ana i te wai, ka kite ia i ngā rangi e wāhia ana kia tu­whera, me te Wairua, ānō he kūkupa, e heke iho ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ā, ka puta mai he reo nō te rangi, e mea ana, “Ko koe tāku Tama i aroha ai, tāku i āhua­reka ai.” ");
INSERT INTO mri_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ā, i reira pū anō ka tonoa ia e te Wairua ki te koraha. ");
INSERT INTO mri_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ā, e whā tekau ōna rā i reira i te koraha e whaka­mā­tau­tau­ria ana e Hātana; i roto ia i ngā kararehe mohoao; ko ngā ana­hera hoki ki te mahi mea māna. ");
INSERT INTO mri_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nā, i muri i a Hoani i tukua ai ki te here­here, ka haere a Īhu ki Kariri, ka kauwhau i te rongo­pai o te Atua, ");
INSERT INTO mri_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ka mea, “Kua rite tēnei te wā, kua tata hoki te ranga­tira­tanga o te Atua; rīpe­netā, whaka­pono­hia te rongo­pai.” ");
INSERT INTO mri_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nā, i a ia e haere ana i te taha o te moana o Kariri, ka kite i a Haimona rāua ko tōna teina, ko Anaru, e maka ana i te kupe­nga ki te moana, he kaihao ika hoki rāua. ");
INSERT INTO mri_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nā, ka mea a Īhu ki a rāua, “Haere mai i muri i ahau, ā, māku kōrua e mea hei kaihao tāngata.” ");
INSERT INTO mri_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ā, mahue tonu ake i a rāua, ngā kupe­nga, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ā, haere tata atu ana i reira, ka kite ia i a Hēmi, tama a Heperi, rāua ko tōna teina ko Hoani, i te kai­puke anō rāua, e tā ana i ngā kore­nga o ā rātou kupe­nga. ");
INSERT INTO mri_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nā, karanga tonu atu ia i a rāua; ā, mahue ake i a rāua tō rāua matua a Heperi i te kai­puke me ngā kai­mahi, ā, haere ana i muri i a ia. ");
INSERT INTO mri_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ā, ka tomo rātou ki Kaperenauma; nā, haere tonu ia i te hāpati ki te whare kara­kia, ka whaka­ako. ");
INSERT INTO mri_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ā, mīharo ana rātou ki tāna ako, i rite hoki tāna ako i a rātou ki tā te tangata whai mana, kīhai i rite ki tā ngā kara­ipi. ");
INSERT INTO mri_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nā, i tō rātou whare kara­kia tētahi tangata, he wairua poke tōna; ā, ka karanga ia, ");
INSERT INTO mri_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ka mea, “Kāti rā, he aha tā mātou ki a koe, e Īhu o Nahareta? Kua tae mai rānei koe ki te whaka­ngaro i a mātou? E mātau ana ahau ko wai koe, ko te Mea Tapu a te Atua.” ");
INSERT INTO mri_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ā, ka riri a Īhu ki a ia, ka mea, “Kāti te kōrero, puta mai i roto i a ia!” ");
INSERT INTO mri_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nā, ka hae­hae te wairua kino i a ia, nui atu hoki tōna reo ki te karanga, ā, puta ana mai i roto i a ia. ");
INSERT INTO mri_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ā, mīharo noa rātou katoa, uiui ana ki a rātou anō, mea ana, “He aha tēnei? He aha tēnei ako hou? Mana tonu tāna nei tono i ngā wairua poke, ā, rongo rawa ki a ia.” ");
INSERT INTO mri_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nā, pakū tonu atu tōna rongo ki ngā wāhi katoa e tata ana ki Kariri. ");
INSERT INTO mri_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nā, i reira tonu, i tō rātou pu­tanga mai i te whare kara­kia, tomo tonu atu rātou ko Hēmi, ko Hoani, ki te whare o Haimona rāua, ko Anaru. ");
INSERT INTO mri_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nā, i te takoto te hunga­wai wahine o Haimona, he kirikā, ā, kōrero­tia tonu­tia atu ia e rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Heoi, i tōna taenga atu, ka mau ki tōna ringa, whaka­ara­hia ana ia; mutu tonu ake tōna kirikā, ka tahuri ki te taka mea mā rātou. ");
INSERT INTO mri_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nā, i te ahi­ahi, i te toene­tanga o te rā, ka mauria mai ki a ia ngā tūroro katoa, me te hunga e nohoia ana e ngā rēwera. ");
INSERT INTO mri_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ā, hui­hui katoa ana te pā ki te kūwaha. ");
INSERT INTO mri_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","He toko­maha te hunga e ngaua ana e te tini o ngā mate i whaka­ora­ngia e ia, he maha hoki ngā rēwera i peia; ā, kīhai i tukua e ia ngā rēwera kia kōrero, nō te mea i mātau rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nā, i te atatū, i mua noa atu o te awa­tea, ka ara ia, ka puta ki waho, ka haere ki te wāhi koraha, ki reira īnoi ai. ");
INSERT INTO mri_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nā, ka whai a Haimona rātou ko ōna hoa i a ia. ");
INSERT INTO mri_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ā, ka kitea ia, ka mea ki a ia, “E rapu ana ngā tāngata katoa i a koe.” ");
INSERT INTO mri_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kātahi ia ka mea ki a rātou, “Tātou ka haere he wāhi kē ki ngā kāinga tata, ki reira ahau kauwhau ai. Ko tāku hoki tērā i haere mai ai.” ");
INSERT INTO mri_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nā, ka tomo ia ki roto i ō rātou whare kara­kia puta noa i Kariri, ka kauwhau, ka pei hoki i ngā rēwera ki waho. ");
INSERT INTO mri_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ā, ka haere mai ki a ia tētahi repera, ka īnoi ki a ia, tuku rawa ngā turi ki a ia, ka mea, “Ki te pai koe, e taea ahau e koe te mea kia mā.” ");
INSERT INTO mri_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nā, ka aroha a Īhu, ka totoro tōna ringa, ka pā ki a ia, ka mea ki a ia, “E pai ana ahau; kia mā koe.” ");
INSERT INTO mri_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ā, puaki kau tōna reo, kua kore tōna repera, nā, kua mā. ");
INSERT INTO mri_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nā, ka whaka­tūpato ia ki a ia, ā, tonoa tonu­tia atu, ");
INSERT INTO mri_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ka mea atu hoki ki a ia, “Kei kōrero­tia tētahi mea ki te tangata; engari haere, kia kite te tohu­nga i a koe, ā, mauria atu mō tōu whaka­mā­kanga ngā mea i whaka­ritea e Mohi, hei mea whaka­atu ki a rātou.” ");
INSERT INTO mri_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Heoi, i tōna pu­tanga atu, ka anga ki te kōrero nui haere, ka whaka­pua­kina taua mea, ā, kīhai a Īhu i āhei te haere nui ki te pā i muri iho. Engari i noho ia i waho i ngā wāhi koraha; ā, haere ana mai rātou ki a ia i ngā wāhi katoa. ");
INSERT INTO mri_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ā, i a ia i tomo ai anō ki Kaperenauma i ētahi rā mai, ka rangona kei te whare ia. ");
INSERT INTO mri_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nā, ka hui mai te tini o te tangata, kāhore rawa he wāhi e ō ai rātou, hore rawa i te taha o te kūwaha; ā, ka kōrero­tia e ia te kupu ki a rātou. ");
INSERT INTO mri_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka haere mai hoki ētahi, ka kawe mai i tētahi pararūtiki ki a ia, toko­whā ki te kauhoa. ");
INSERT INTO mri_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ā, tē taea te whaka­tata ki a ia i te mano hoki, ka pokaia te tuanui o te wāhi i noho ai ia; ā, ka oti te wāwāhi, ka tukua iho te moenga i takoto ai te pararūtiki. ");
INSERT INTO mri_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ā, nō te kite­nga o Īhu i tō rātou whaka­pono, ka mea ia ki te pararūtiki, “E tama, ka oti ōu hara te muru.” ");
INSERT INTO mri_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nā, i reira ētahi o ngā kara­ipi e noho ana, e whaka­aro­aro ana i roto i ō rātou ngākau, ");
INSERT INTO mri_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“He aha ēnei kupu kohu­kohu a tēnei tangata? Ko wai hei muru hara, kotahi tonu ko te Atua anake?” ");
INSERT INTO mri_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nā, mōhio tonu a Īhu i roto i tōna wairua, e pēnei ana ō rātou whaka­aro i roto i a rātou, ā, ka mea ia ki a rātou, “He aha koutou ka whaka­aro­aro ai i ēnei mea i roto i ō koutou ngākau? ");
INSERT INTO mri_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ko tēhea te mea takoto noa, ko te mea ki te pararūtiki, ‘Ka oti ōu hara te muru,’ ko te mea rānei, ‘Whaka­tika, tango­hia ake tōu moenga, haere’? ");
INSERT INTO mri_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Otirā, kia mātau ai koutou he mana muru hara tō te Tama a te tangata i runga i te whenua.” Ka mea ia ki te pararūtiki, ");
INSERT INTO mri_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ko tāku kupu tēnei ki a koe, whaka­tika, tango­hia ake tōu moenga, haere ki tōu whare.” ");
INSERT INTO mri_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nā, whaka­tika tonu ake ia, ā, tango­hia ake ana tōna moenga, haere atu ana i te aro­aro o rātou katoa. Nō, ka mīharo rātou katoa ka whaka­korōria i te Atua, ka mea, “Kāhore anō tātou i kite noa i te pēnei!” ");
INSERT INTO mri_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ā, haere atu ana ia i te taha o te moana; nā, ka tae te mano katoa ki a ia, ā, ka whaka­akona rātou e ia. ");
INSERT INTO mri_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ā, i a ia e haere ana, ka kite ia i a Rīwai tama a Arapiu e noho ana i te wāhi tango takoha, ka mea ki a ia, Aru­mia ahau. Nā, whaka­tika ana ia, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ā, i a ia e noho ana i tōna whare, he toko­maha ngā pupiri­kana me ngā tāngata hara e noho tahi ana ki a Īhu rātou ko āna ākonga; he toko­maha hoki rātou, ā, i aru i a ia. ");
INSERT INTO mri_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ā, nō te kite­nga o ngā kara­ipi a ngā Parihi i a ia e kai tahi ana me ngā pupiri­kana, me ngā tāngata hara, ka mea ki āna ākonga, “Kei te kai tahi ia, kei te inu tahi me ngā pupiri­kana me ngā tāngata hara.” ");
INSERT INTO mri_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ā, i te rongo­nga o Īhu, ka mea ia ki a rātou, “Kāhore he aha o ngā tāngata ora e meatia ai e te rata, engari o te hunga e mate ana; kīhai hoki ahau i haere mai ki te karanga i te hunga tika, engari i te hunga hara.” ");
INSERT INTO mri_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nā, kei te noho­puku ngā ākonga a Hoani rātou ko ā ngā Parihi; ā, ka haere mai rātou, ka mea ki a ia, “He aha ngā ākonga a Hoani me a ngā Parihi ka noho­puku ai, tēnā ko āu ākonga kāhore e noho­puku?” ");
INSERT INTO mri_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nā, ka mea a Īhu ki a rātou, “E āhei rānei ngā tama o te whare mārena te noho­puku i te mea kei a rātou te tāne mārena hou? E kore rātou e āhei te noho­puku i ngā wā kei a rātou nei te tāne mārena hou. ");
INSERT INTO mri_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nā, tērā e tae mai ngā rā e tango­hia ai te tāne mārena hou i a rātou, kātahi rātou ka noho­puku i aua rā. ");
INSERT INTO mri_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“E kore e tuia e te tangata tētahi wāhi o te kahu hou, hei pāpaki mō te kahu tawhito; kei riro tētahi wāhi o te kahu tawhito i tōna whaka­kapi hou, ā, ka nui rawa te pakaru. ");
INSERT INTO mri_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","E kore hoki e ringi­hia e te tangata te wāina hou ki ngā ipu tawhito; kei pakaru ngā ipu i te wāina hou, ā, ka ma­ringi te wāina, kore ake ngā ipu; engari me riri­ngi te wāina hou ki ngā ipu hou.” ");
INSERT INTO mri_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ā, i a ia e haere ana i waenga wīti i te hāpati, ka anga āna ākonga ka kakato haere i ngā puku wīti. ");
INSERT INTO mri_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nā, ka mea ngā Parihi ki a ia, “Nā, he aha rātou ka mahi ai i te mea e kore e tika i te hāpati?” ");
INSERT INTO mri_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ā, ka mea ia ki a rātou, “Kāhore anō koutou i kite noa i tā Rāwiri i mea ai, i a ia e ngaua ana e te hia­kai, rātou ko ōna hoa? ");
INSERT INTO mri_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","I tōna tomo­kanga ki te whare o te Atua i ngā rā o Apiata tohu­nga nui, ā, kainga ana e ia ngā taro aro­aro, ngā mea kīhai nei i tika kia kainga, mā ngā tohu­nga anake, ā, hoatu ana e ia ki ōna hoa?” ");
INSERT INTO mri_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","I mea anō ia ki a rātou, “Hei mea mō te tangata te hāpati, ehara i te mea ko te tangata mō te hāpati; ");
INSERT INTO mri_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","wai­hoki ko te Tama a te tangata te Ariki o te hāpati.” ");
INSERT INTO mri_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ā, ka tomo atu anō ia ki te whare kara­kia, nā, i reira tētahi tangata kua memenge tōna ringa. ");
INSERT INTO mri_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ā, ka whaka­mau tā rātou ti­tiro ki a ia, me kore ia e whaka­ora i a ia i te hāpati; he mea kia whaka­pā ai rātou i tētahi hē ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nā, ka mea ia ki te tangata i te ringa memenge, “Whaka­tika ki waenga­nui.” ");
INSERT INTO mri_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nā, ka mea ia ki a rātou, “He mea tika rānei te mahi pai i te hāpati, te mahi kino rānei? Te whaka­ora rānei, te whaka­mate rānei?” Heoi, kāhore rātou i kīkī. ");
INSERT INTO mri_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nā, ka tiro­tiro riri ia ki a rātou, he pōuri hoki mō te pakeke o ō rātou ngākau, ka mea ki taua tangata, “Totoro tōu ringa.” Ā, ko te toro­nga o tōna ringa, kua ora. ");
INSERT INTO mri_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nā, ka haere atu ngā Parihi, ka rū­nanga tahi me ngā Herōriana mōna, ki te pēhea e whaka­ngaro­mia ai ia. ");
INSERT INTO mri_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nā, ka maunu atu a Īhu rātou ko āna ākonga ki te moana; he nui hoki te tangata i aru i a ia i Kariri, i Hūria, ");
INSERT INTO mri_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","I Hiruhārama, i Irumia, i tāwāhi hoki o Horano; me te hunga hoki e tata ana ki Tāira, ki Hairona, nui atu te hui­hui; i tō rātou rongo­nga i ngā mea i mea ai ia, haere ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nā, ka mea ia ki āna ākonga kia noho tata mai tētahi kai­puke iti ki a ia, i te mano hoki, kei tute­tutea ia e rātou. ");
INSERT INTO mri_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","He toko­maha hoki i whaka­ora­ngia e ia; nō ka popō mai ki a ia te hunga katoa e mate ana, kia pā ai ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Me ngā wairua poke hoki, i tō rātou kite­nga i a ia, takoto ana ki tōna aro­aro, ka karanga, ka mea, “Ko te Tama koe a te Atua!” ");
INSERT INTO mri_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ā, he maha āna kupu ki a rātou kia kaua ia e whaka­atu­ria e rātou. ");
INSERT INTO mri_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nā, ka kake ia ki te maunga, karanga­tia ana ki a ia āna i pai ai, ā, ka tae rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ā, kotahi tekau mā rua āna i whaka­rite ai hei hoa mōna, hei tono­nga hoki māna ki te kauwhau, ");
INSERT INTO mri_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kia whai mana hoki e ora ai ngā mate, e peia ai ngā rēwera. ");
INSERT INTO mri_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ā, huaina iho e ia a Haimona ko Pita; ");
INSERT INTO mri_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ko Hēmi, tama a Heperi, rāua ko Hoani, teina o Hēmi; ā, huaina iho rāua ko Poaneki, arā, ko ngā Tama a te Whati­tiri; ");
INSERT INTO mri_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ko Anaru, ko Piripi, ko Patoromu, ko Matiu, ko Tamati, ko Hēmi, tama a Arapiu, ko Tariu ko Haimona Kanaani, ");
INSERT INTO mri_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ko Hūrā Ikariote hoki, nāna nei ia i tuku. Nā, ka tae ia ki te whare. ");
INSERT INTO mri_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nā, ka hui­hui anō te mano, nō kīhai rawa rātou i āhei te kai taro. ");
INSERT INTO mri_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ā, nō ka rongo ōna hoa, ka haere ki te pupuri i a ia: i mea hoki, “He pō­rewa­rewa ia.” ");
INSERT INTO mri_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nā, ka mea ngā kara­ipi i haere mai rā i Hiruhārama, “Kei a ia a Perehepura, ā, nā te ranga­tira o ngā rēwera tāna peinga rēwera.” ");
INSERT INTO mri_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nā, ka karanga­tia rātou e ia, ā, ka kōrero whaka­rite ki a rātou: “Me pēhea a Hātana ka pei ai i a Hātana? ");
INSERT INTO mri_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ki te tahuri iho hoki tētahi ranga­tira­tanga ki a ia anō, e kore taua ranga­tira­tanga e tū. ");
INSERT INTO mri_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ki te tahuri iho hoki tētahi whare ki a ia anō, e kore taua whare e tū. ");
INSERT INTO mri_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ki te whaka­tika a Hātana, ā, ka tahuri iho ki a ia anō, e kore ia e tū, engari, he mutu­nga tōna. ");
INSERT INTO mri_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“E kore te tangata e āhei te haere ki roto ki te whare o te tangata kaha, pāhua ai i ōna taonga, ki te kāhore e mātua herea te tangata kaha; ko reira pāhua ai i tōna whare. ");
INSERT INTO mri_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“He pono tāku e mea nei ki a koutou, Ko ngā hara katoa o ngā tama a ngā tāngata e murua, me ngā kohu­kohu e kohu­kohu ai rātou. ");
INSERT INTO mri_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tēnā ko te tangata e kohu­kohua ai te Wairua Tapu, e kore e murua tōna hara ā ake ake, engari ka tau te hē ki a ia ā ake ake.” ");
INSERT INTO mri_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mō rātou i kī, “He wairua poke tōna.” ");
INSERT INTO mri_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ā, ko te taenga mai o ōna tēina rātou ko tōna whaea, ka tū i waho, ka tono tāngata mai ki a ia, ki te karanga i a ia. ");
INSERT INTO mri_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","E noho ana hoki te mano i tētahi taha ōna, i tētahi taha, ā, ka mea rātou ki a ia, “Nā, tōu whaea me ōu tēina kei waho, e rapu ana i a koe.” ");
INSERT INTO mri_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nā, ka whaka­hoki ia ki a rātou, ka mea, “Ko wai tōku whaea, ko wai hoki ōku tēina?” ");
INSERT INTO mri_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nā, ka tiro­tiro ia ki te hunga e noho ana i tētahi taha ōna, i tētahi taha, ka mea, “Nā, tōku whaea, ōku tēina! ");
INSERT INTO mri_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ki te meatia hoki e tētahi tā te Atua i pai ai, hei teina ia ki ahau, hei tua­hine, hei whaea.” ");
INSERT INTO mri_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nā, ka tīmata anō ia te whaka­ako i te taha o te moana. He nui hoki te tangata i hui­hui ki a ia, nō ka eke ia ki runga ki te kai­puke, ka noho ki te moana; i uta te mano katoa i te taha o te moana. ");
INSERT INTO mri_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ā, he maha āna mea i whaka­ako ai ki a rātou, he mea whaka­rite, i mea hoki ki a rātou i a ia e ako ana: ");
INSERT INTO mri_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Whaka­rongo! Nā, i haere atu te kairui ki te rui. ");
INSERT INTO mri_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ā, i a ia e rui ana, ka nga­horo ētahi ki te taha o te ara, ā, ko te rere­nga mai o ngā manu o te rangi, nā, kainga ake. ");
INSERT INTO mri_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ko ētahi i nga­horo ki te wāhi kāmaka, ki te wāhi kīhai i nui te one­one; ā, pīhi tonu ake, kāhore hoki i hōhonu te one­one. ");
INSERT INTO mri_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ā, nō te whiti­nga o te rā, ngaua iho; ā, nō te mea kāhore he pūtake, memenge noa iho. ");
INSERT INTO mri_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ko ētahi i nga­horo ki roto ki ngā tā­tarā­moa, ā, nō te tupu­nga ake o ngā tā­tarā­moa, kōwao­wao­tia ana ngā pura­pura, ā, kore ake he hua. ");
INSERT INTO mri_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ko ētahi i nga­horo ki te one­one pai, ā, whai hua ana; ka tupu, ka nui, ka ea ake, nō ētahi e toru tekau, nō ētahi e ono tekau, nō ētahi kotahi rau.” ");
INSERT INTO mri_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","I mea anō ia ki a rātou, “Ki te whai tari­nga tētahi hei whaka­rongo, kia rongo ia.” ");
INSERT INTO mri_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nā, ka mahue ko ia anake, ka ui ki a ia ōna hoa me te tekau mā rua ki taua kupu whaka­rite. ");
INSERT INTO mri_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ka mea ia ki a rātou: “Kua hoatu ki a koutou te mātau­ranga ki te mea ngaro o te ranga­tira­tanga o te Atua; ki te hunga ia o waho e rā roto­tia ana ngā mea katoa i te kupu whaka­rite, ");
INSERT INTO mri_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","mō, ‘Te ti­tiro rawa atu rātou, nā, e kore e kite; rongo rawa, nā, e kore e mātau; kei tahuri, ā, ka murua ō rātou hara.’ ” ");
INSERT INTO mri_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","I mea anō ia ki a rātou, “Kāhore rānei koutou e mātau ki tēnei kupu whaka­rite? Ā, me pēhea ka mātau ai koutou ki ngā kupu whaka­rite katoa? ");
INSERT INTO mri_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ko te kairui e rui ana i te kupu. ");
INSERT INTO mri_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ko ēnei te hunga i te taha o te ara, i te wāhi e ruia ana te kupu; i tō rātou rongo­nga, nā, haere tonu mai a Hātana, kapo­hia ake te kupu i ruia ki ō rātou ngākau. ");
INSERT INTO mri_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ko ēnei anō te hunga i ngā pura­pura i ngā wāhi kāmaka; ko te hunga, i tō rātou rongo­nga ai i te kupu, hohoro tonu te tango, hari tonu. ");
INSERT INTO mri_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nā, kāhore ō rātou paki­aka, ka whaka­pakari kau noa; heoi, i te pānga o te whaka­pāwera, o te whaka­toi rānei mō te kupu, hē tonu iho. ");
INSERT INTO mri_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nā, ko ēnei te hunga i ngā pura­pura i roto i ngā tā­tarā­moa; ko ngā mea i rongo ki te kupu, ");
INSERT INTO mri_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ā, i te pu­tanga o te whaka­aro ki tēnei ao, o te hanga­rau o ngā taonga, o ngā hia­hia ki ērā atu mea, kōwao­wao­tia iho te kupu, ā, kore ake he hua. ");
INSERT INTO mri_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nā, ko ēnei te hunga i ngā pura­pura i te one­one pai: ko te hunga e rongo ana ki te kupu, ā, tango ana, ā, whai hua ana, o ētahi e toru tekau, o ētahi e ono tekau, o ētahi kotahi rau.” ");
INSERT INTO mri_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","I mea anō ia ki a rātou, “Ko raro koia i te mēhua whaka­tū ai i te rama, ina mauria mai, ko raro rānei i te moenga? He teka ianei me whaka­tū ki runga ki te tū­ranga? ");
INSERT INTO mri_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","E kore hoki tētahi mea i huna e mahue te whaka­kite; kāhore hoki tētahi mea i huna, engari, kia puta ki te mārama­tanga. ");
INSERT INTO mri_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ki te mea he tari­nga o tētahi hei whaka­rongo, kia rongo ia.” ");
INSERT INTO mri_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","I mea anō ia ki a rātou, “Kia tūpato ki tā koutou e rongo ai; ko te mēhua hoki e mēhua ai koutou, hei mēhua anō tēnā ki a koutou; ā, ka tāpiri­tia anō he mea mā koutou, mā ngā kai­whaka­rongo. ");
INSERT INTO mri_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ki te whai mea hoki tētahi, ka hoatu anō ki a ia; ki te kāhore he mea a tētahi, ka tango­hia i a ia āna ake.” ");
INSERT INTO mri_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","I mea anō ia, “I rite hoki te ranga­tira­tanga o te rangi ki te tangata i makā e ia he pura­pura ki te one­one; ");
INSERT INTO mri_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ā, ka moe, ka ara, i te pō, i te ao, me te tupu anō tērā te pura­pura, tē mātau ia nā te aha. ");
INSERT INTO mri_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","E hua ana hoki te whenua i tōna kaha ake anō; ko te rau ki mua, ko reira te puku, muri iho ko te wīti pakari i roto i te puku. ");
INSERT INTO mri_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Otirā, ka rite ngā hua, hohoro tonu tāna tuku atu i tāna toro­nai­hi, kua taea hoki te kotinga.” ");
INSERT INTO mri_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","I mea anō ia, “Me whaka­rite e tātou te ranga­tira­tanga o te Atua ki te aha? He aha oti te kupu whaka­rite hei whaka­ahua atu mā tātou? ");
INSERT INTO mri_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E rite ana ki te pua nanī, i tōna whaka­tōkanga ki te whenua, ko te iti rawa ia o ngā pura­pura katoa i runga i te whenua. ");
INSERT INTO mri_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Otirā, ka oti te whaka­tō, ka tupu, ka nui ake i ngā ota­ota katoa, ā, ka nunui ōna manga; nō ka noho ngā manu o te rangi i tōna tau­maru­maru­tanga iho.” ");
INSERT INTO mri_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nā, he maha āna kupu whaka­rite pērā, i kōrero­tia ai e ia te kupu ki a rātou, ko ā rātou i āhei ai te whaka­rongo. ");
INSERT INTO mri_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ā, heoi āna kupu ki a rātou he kupu whaka­rite anake; otiia, ka noho ko rātou anake, ka whaka­atu­ria e ia ngā mea katoa ki āna ākonga. ");
INSERT INTO mri_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nā, i taua rā, i te ahi­ahi, ka mea ia ki a rātou, “Tātou ka whaka­whiti ki tāwāhi.” ");
INSERT INTO mri_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nā, ka mahue iho te mano, ka mauria ia e rātou, i runga tonu anō ia i te kai­puke. I a ia anō ētahi atu kai­puke. ");
INSERT INTO mri_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nā, ko te pu­tanga o tētahi hau, he tūpuhi, ā, eke ana ngā ngaru ki runga ki te kai­puke, ā, tomo noa. ");
INSERT INTO mri_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nā, ko ia i te kei i runga i te urunga e moe ana; ā, ka whaka­ara rātou i a ia, ka mea ki a ia, “E te Kai­whaka­ako, kāhore ōu manawa­pā ki a tātou ka ngaro?” ");
INSERT INTO mri_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nā, ka ara ia, ā, rīria iho e ia te hau, ka mea ia ki te moana, “Kāti, whaka­mutua.” Nā, māriri tonu iho te hau, takoto ana he marino nui. ");
INSERT INTO mri_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kātahi ia ka mea ki a rātou, “He aha tā koutou e mataku nei? He aha koutou tē whaka­pono ai?” ");
INSERT INTO mri_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nā, ka mataku whaka­hara­hara rātou, ka mea tētahi ki tētahi, “Ko wai tēnei, inā ka rongo rawa te hau me te moana ki a ia?” ");
INSERT INTO mri_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ā, ka whiti rātou ki tāwāhi o te moana, ki te whenua o ngā Kararini. ");
INSERT INTO mri_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nā, mahuta kau i te kai­puke, ka tūtaki ki a ia tētahi tangata i puta mai i ngā urupā, he wairua poke tōna. ");
INSERT INTO mri_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kei ngā urupā nei tōna nohoa­nga; ā, ahakoa he meka­meka, hore rawa ia i taea e tētahi tangata te here. ");
INSERT INTO mri_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","He maha hoki ōna here­nga ki ngā here wae­wae, ki ngā meka­meka, heoi motu­motu­hia ana e ia ngā meka­meka, monga­monga noa anō ngā here wae­wae. Kīhai tētahi tangata i kaha ki te whaka­mārie i a ia. ");
INSERT INTO mri_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","I ngā urupā tonu ia, i ngā maunga i te pō, i te ao, e hāmama ana, e hae­hae ana i a ia ki te kōhatu. ");
INSERT INTO mri_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ā, i tōna kite­nga i a Īhu i tawhiti, oma ana ia, koro­piko ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","He nui tōna reo ki te karanga, ka mea, “Ko te aha tāku ki a koe, e Īhu, e te Tama a te Atua, a te Runga Rawa? Ko te Atua tāku whaka­oati mōu, nā, kaua ahau e whaka­mamae­tia.” ");
INSERT INTO mri_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","He mea­tanga hoki nāna ki a ia, “Puta mai i tēnei tangata, e te wairua poke.” ");
INSERT INTO mri_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nā, ka ui ia ki a ia, “Ko wai tōu ingoa?” Ka whaka­hokia e tērā, ka mea, “Ko Rihiona tōku ingoa; he toko­maha hoki mātou.” ");
INSERT INTO mri_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ā, he nui tāna īnoi ki a ia kia kaua rātou e tonoa atu i taua whenua. ");
INSERT INTO mri_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nā, kei reira, kei ngā maunga, tētahi kāhui poaka e kai ana, tōna tini. ");
INSERT INTO mri_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nā, ka īnoi ngā rēwera katoa ki a ia, ka mea, “Tonoa mātou ki ngā poaka, kia tomo mātou ki a rātou.” ");
INSERT INTO mri_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nā, tukua ana rātou e Īhu. Heoi, ko te pu­tanga o ngā wairua poke, ka tomo ki ngā poaka. Ko te tino rere­nga o te kāhui rā te pari ki te moana, ko te maha kei te rua mano, ā, paremo iho ki te moana. ");
INSERT INTO mri_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nā, whati ana ngā kai­whāngai o ngā poaka, ā, kōrero­tia ana ki te pā, ki aua whenua. Nā, ka puta rātou kia kite i taua mea kua meatia nei. ");
INSERT INTO mri_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ā, nō tō rātou taenga mai ki a Īhu, ka kite i te tangata i nohoia nei e ngā rēwera, tērā i te rihi­ona, e noho ana, kua oti te whaka­kākahu, kua tika ngā mahara, ka mataku rātou. ");
INSERT INTO mri_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ā, ka kōrero­tia ki a rātou, e te hunga i kite, te mea­tanga ki te tangata i ngā rēwera, ki ngā poaka hoki. ");
INSERT INTO mri_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nā, ka anga rātou, ka tohe ki a ia kia haere atu i ō rātou wāhi. ");
INSERT INTO mri_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ā, nō ka eke ia ki te kai­puke, ka īnoi ki a ia te tangata i ngā rēwera, kia waiho ia hei hoa mōna. ");
INSERT INTO mri_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Otirā, kīhai a Īhu i tuku i a ia, engari i mea atu ki a ia, “Haere ki tōu whare, ki ōu whanau­nga, ka kōrero ki a rātou i ngā mea nui i meinga e te Ariki ki a koe, i tāna ata­whai­tanga hoki i a koe.” ");
INSERT INTO mri_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nā, ka haere ia, ka anga, ka kōrero ki Rekaporihi, i ngā mea nunui i mea ai a Īhu ki a ia; ā, mīharo ana ngā tāngata katoa. ");
INSERT INTO mri_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ā, nō te whiti­nga atu anō o Īhu ki tāwāhi i runga i te kai­puke, he nui te tangata i hui­hui ki a ia; i te taha anō ia o te moana. ");
INSERT INTO mri_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nā, ko te haere­nga mai o tētahi o ngā ranga­tira o te whare kara­kia, ko Hairuha tōna ingoa; ka kite i a ia, ka takoto ki ōna wae­wae, ");
INSERT INTO mri_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","he nui tāna īnoi ki a ia, ka mea, “Ko tāku tamā­hine nohi­nohi kei te whaka­hemo­hemo! Kia haere ake koe ki te whaka­pā i ōu ringa ki a ia kia ora ai, ā, ka ora.” ");
INSERT INTO mri_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nā, haere tahi ana rāua; he tini hoki te tangata i aru i a ia, popō tonu ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nā, ko tētahi wahine e mate ana i te pākaru­hanga toto, ka tekau mā rua ngā tau. ");
INSERT INTO mri_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","He maha ngā mea­tanga a ngā rata toko­maha ki a ia, hemo noa āna rawa katoa, tē mātūtū ake tētahi wāhi, heoi, kake haere ana te mate. ");
INSERT INTO mri_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ā, nō tōna rongo­nga ki a Īhu, ka haere i muri i roto i te mano, ā, pā ana ki tōna kākahu. ");
INSERT INTO mri_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","I mea hoki, “Ahakoa pā kau ahau ki ōna kākahu, ka ora ahau.” ");
INSERT INTO mri_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ā, mimiti tonu ake te puna o ōna toto; nō ka mahara a roto o tōna tinana kua ora ia i te mate. ");
INSERT INTO mri_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nā, mōhio tonu a Īhu kua puta he mana i roto i a ia, ka tā­huri­huri i roto i te mano, ka mea, “Ko wai tēnei kua pā nei ki ōku kākahu?” ");
INSERT INTO mri_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka mea āna ākonga ki a ia, “E kite ana koe i te mano e popō nei ki a koe, ā, e mea ana koe, ‘Ko wai tēnei kua pā mai ki ahau?’ ” ");
INSERT INTO mri_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Heoi, tiro­tiro ana ia kia kite i te wahine i mea nei i tēnei mea. ");
INSERT INTO mri_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nā, ka haere mai te wahine me te wehi, me te wiri, i mahara hoki ki te mea i meatia ki a ia, ā, takoto ana ki tōna aro­aro, kōrero­tia katoa­tia ana e ia te tikanga ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Anō rā, ko Īhu ki a ia, “E kō, nā tōu whaka­pono koe i ora ai; haere mārie, kia ora koe i tōu mate.” ");
INSERT INTO mri_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","I a ia anō e kōrero ana, ka haere mai ētahi o ngā tāngata a te ranga­tira o te whare kara­kia, ka mea, “Kua mate tāu tamā­hine. Hei aha ake māu te whaka­raru­raru i te Kai­whaka­ako?” ");
INSERT INTO mri_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Otirā, kāhore a Īhu i aro ki te kupu i kōrero­tia, ka mea atu ki te ranga­tira o te whare kara­kia, “Kaua e wehi, ko te whaka­pono ia kia whaka­pono.” ");
INSERT INTO mri_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ā, kīhai tētahi tangata i tukua kia haere tahi me ia, ko Pita anake, ko Hēmi, ko Hoani teina o Hēmi. ");
INSERT INTO mri_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ā, nō te taenga atu ki te whare o te ranga­tira o te whare kara­kia, ka kite ia i te nga­ngau, i te nui hoki o te tangi, o te auē a ētahi. ");
INSERT INTO mri_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ā, i tōna tomo­kanga ki roto, ka mea ia ki a rātou, “He aha koutou ka nga­ngau ai, ka tangi ai? Kāhore te kōtiro i mate, engari e moe ana.” ");
INSERT INTO mri_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nā, kata­ina iho ia e rātou. Heoi, ka oti katoa te pei ki waho, ka mau ia ki te pāpā, ki te whaea o te kōtiro, rātou ko ōna hoa, ka tomo ki te wāhi i takoto ai te kōtiro. ");
INSERT INTO mri_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nā, ka mau ia ki te ringa o te kōtiro, ka mea ki a ia, “Tarita kumi!” ko tōna whaka­māori­tanga tēnei, “E kō, ko tāku kupu tēnei ki a koe, e ara!” ");
INSERT INTO mri_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nā, whaka­tika tonu ake te kōtiro, ā, haere ana; kotahi tekau mā rua hoki ōna tau. Nā, ko te tino mīharo­tanga i mīharo ai rātou. ");
INSERT INTO mri_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ā, he nui tāna whaka­tūpato i a rātou, kia kaua tēnei e mōhio­tia e tētahi tangata; ka kī kia hoatu he kai māna. ");
INSERT INTO mri_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ā, haere ia i reira, ā ka tae ki tōna kāinga tupu; me te aru anō āna ākonga i a ia. ");
INSERT INTO mri_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ā, ka taka mai te hāpati, ka anga ia, ka whaka­ako i roto i te whare kara­kia; ā, he toko­maha hoki, i tō rātou rongo­nga, i mīharo, i mea, “Nō hea ēnei mea a tēnei tangata? He mātau­ranga aha tēnei kua hoatu nei ki a ia, ā, he aha te tikanga o ēnei mere­kara nunui kua oti nei i ōna ringa? ");
INSERT INTO mri_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ehara ianei tēnei i te kāmura, i te tama a Meri, i te tua­kana o Hēmi, o Hohi, o Hūrā, o Haimona? Kāhore ianei ōna tuā­hine i konei, i a tātou nei?” Heoi hē ana rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Otirā, ka mea a Īhu ki a rātou, “Kei tōna kāinga anake, kei ōna whanau­nga, kei tōna whare, te poro­piti hapa ai i te hōnore.” ");
INSERT INTO mri_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ā, kīhai ia i āhei te mea i tētahi mere­kara ki reira, heoi anō, ko te whaka­pā i ōna ringa ki ētahi tāngata tūroro toru­toru kia ora ai. ");
INSERT INTO mri_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ā, mīharo ana ia ki tō rātou whaka­pono kore. Nā, hāere­erea ana e ia ngā kāinga ā tawhio noa, whaka­ako ai. ");
INSERT INTO mri_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kātahi ia ka karanga i te tekau mā rua, ka anga, ka tono i a rātou toko­rua, toko­rua; ā, hoatu ana ki a rātou he mana hei pei i ngā wairua poke. ");
INSERT INTO mri_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","I whaka­hau ia ki a rātou, kia kaua tētahi mea e mauria ki te ara, he toko­toko anake; kaua he pūtea, kaua he taro, kaua he moni mō roto i te whī­tiki. ");
INSERT INTO mri_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Engari ngā hū, e here nā; kaua hoki e taki­rua­tia he koti hei kākahu. ");
INSERT INTO mri_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","I mea anō ia ki a rātou, “Ka tapoko ki tētahi whare, hei reira noho ai, ā, haere noa i reira. ");
INSERT INTO mri_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ā, ki te kāhore ētahi e manako ki a koutou, ki te kore e whaka­rongo ki a koutou, ina haere atu koutou i reira, ruia atu te puehu i raro i ō koutou wae­wae hei whaka­atu ki a rātou.” ");
INSERT INTO mri_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nā, ka haere rātou, ka kauwhau kia rīpe­netā te tangata. ");
INSERT INTO mri_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","He maha hoki ngā rēwera i peia, he toko­maha anō ngā tūroro i kau­kau­ria ki te hinu, i whaka­ora­ngia. ");
INSERT INTO mri_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ā, ka rongo a Kīngi Herora ki ēnei mea; kua nui haere hoki tōna ingoa, ā, ka mea ia, “Kua ara a Hoani Kai­iri­iri i te hunga mate, nā reira i mahi ai ngā mere­kara i roto i a ia.” ");
INSERT INTO mri_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ko ētahi i mea, “Ko Irāia tēnei.” Ko ētahi, “He poro­piti ia, he pērā rānei me tētahi o ngā poro­piti.” ");
INSERT INTO mri_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heoi, i te rongo­nga o Herora, ka mea ia, “Ko Hoani tēnei i pōutoa e ahau te māte­nga; kua ara ia.” ");
INSERT INTO mri_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","I tono tāngata hoki taua Herora, ā, hopu­kia ana a Hoani, herea iho ki te whare here­here, he mea mō Herōriaha, mō te wahine a tōna tua­kana a Piripi; kua mārena­tia hoki e ia. ");
INSERT INTO mri_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nā, Hoani hoki i mea ki a Herora, “E kore e tika kia riro i a koe te wahine a tōu tua­kana.” ");
INSERT INTO mri_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nā, ka mauā­hara a Herōriaha ki a ia, ka mea kia whaka­matea ia; heoi, kīhai i taea. ");
INSERT INTO mri_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","I hopo­hopo hoki a Herora ki a Hoani, i mōhio hoki ki a ia he tangata tika, he tapu, nā, ka āta tiaki i a ia. I tōna rongo­nga ki a ia he nui tōna poro­raru; ā, i whaka­ahua­reka anō ki te whaka­rongo ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ā, ka tae ki tētahi wā pai, i te taka­nga ai a Herora i tōna rā whānau­tanga, he hākari mā āna tāngata nunui, mā ngā ranga­tira hōia, mā ngā tino tāngata o Kariri. ");
INSERT INTO mri_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ā, ka haere te tamā­hine a taua Herōriaha ki roto, ka kani­kani, ka āhua­reka a Herora rātou ko te hunga e noho tahi ana, ā, ka mea te kīngi ki te kōtiro rā, “Māu e tono ki ahau tāu e pai ai, ā, ka hoatu e ahau ki a koe.” ");
INSERT INTO mri_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nā, ka oati ia ki a ia, “Ko tāu e tono ai ki ahau, ahakoa ko tētahi taha o tōku ranga­tira­tanga, me hoatu e ahau ki a koe.” ");
INSERT INTO mri_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nā, ka haere ia, ka kōrero ki tōna whaea, “Me tono e ahau ki te aha?” Ka mea tērā, “Ki te māte­nga o Hoani Kai­iri­iri.” ");
INSERT INTO mri_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nā, hohoro tonu tōna haere ki te kīngi, ka tono, ka mea, “Ko tāku e pai ai, kia hōmai e koe ki ahau āia­nei ko te māte­nga o Hoani Kai­iri­iri i runga i te rīhi.” ");
INSERT INTO mri_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nā, nui atu te pōuri o te kīngi; otirā, i te whaka­aro ki āna oati, ki te hunga hoki e noho tahi ana me ia, kīhai i pai kia whaka­kāhore­tia tāna. ");
INSERT INTO mri_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nā, tonoa tonu­tia atu e te kīngi tētahi o āna hōia kai­tiaki me te whaka­hau atu kia mauria mai tōna māte­nga. Ā, haere ana tērā, pōutoa iho e ia tōna māte­nga i roto i te whare here­here, ");
INSERT INTO mri_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ā, mauria mai ana tōna māte­nga i runga i te rīhi, hoatu ana ki te kōtiro. Ā, nā te kōtiro i hoatu ki tōna whaea. ");
INSERT INTO mri_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ā, nō ka rongo āna ākonga, ka haere mai ka tango­hia tōna tinana, ā, whaka­takoto­ria ana ki te urupā. ");
INSERT INTO mri_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nā, ka hui­hui ngā āpō­toro ki a Īhu, kōrero­tia ana e rātou ki a ia ngā mea katoa i mea ai rātou, i whaka­ako ai. ");
INSERT INTO mri_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nā, ka mea ia ki a rātou, “Haere mai koutou nā ki te koraha ki te wāhi motu kē, kia tā ai te manawa.” He toko­maha hoki e haere mai ana, e haere atu ana, nō kīhai rawa rātou i wātea ki te kai. ");
INSERT INTO mri_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ā, haere puku ana rātou ki te koraha ki tētahi wāhi motu kē rā te kai­puke. ");
INSERT INTO mri_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ā, i kite ngā mano i tō rātou haere­nga, he toko­maha i mātau ki a ia, nā, ka oma ā-wae­wae ki reira i roto i ngā pā katoa, ā, ko rātou kua tae wawe. ");
INSERT INTO mri_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ā, ka puta a Īhu, ka kite i te hui nui, ka aroha ki a rātou, nō te mea i rite rātou ki te hipi hēpara­kore; ā, ka anga ia, ka whaka­ako i a rātou ki ngā mea maha. ");
INSERT INTO mri_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nā, kua heke noa atu te rā, ka haere atu āna ākonga ki a ia, ka mea, “He wāhi koraha tēnei, kua heke noa atu te rā. ");
INSERT INTO mri_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tonoa atu rātou kia haere ki ngā whenua, ki ngā kāinga i tētahi taha, i tētahi taha, ki te hoko kai mā rātou.” ");
INSERT INTO mri_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nā, ka whaka­hoki ia, ka mea ki a rātou, “Mā koutou e hoatu he kai mā rātou.” Ka mea rātou ki a ia, “Me haere oti mātou ki te hoko taro ki ngā pene e rua rau, ka hoatu ai hei kai mā rātou?” ");
INSERT INTO mri_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ka mea ia ki a rātou, “E hia ā koutou taro? Tīkina tiro­hia.” Ka mōhio rātou, nā ka mea, “E rima, e rua hoki ngā ika.” ");
INSERT INTO mri_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ka mea ia ki a rātou kia meinga rātou katoa kia noho, he nohoa­nga, he nohoa­nga, ki runga ki te taru­taru mato­mato. ");
INSERT INTO mri_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nā, ka noho rātou, he rōpū, he rōpū, tā­taki­rau, tā­taki­rima tekau. ");
INSERT INTO mri_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ā, ka mau ia ki ngā taro e rima, ki ngā ika hoki e rua, ka ti­tiro ki runga ki te rangi, ka whaka­pai, ka whawhati i ngā taro, ā, hoatu ana ki āna ākonga kia whaka­takoto­ria mā rātou; i tu­whai­na anō hoki e ia ngā ika e rua mā rātou katoa. ");
INSERT INTO mri_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ā, kai katoa ana rātou, ā, ka mākona. ");
INSERT INTO mri_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ā, kotahi tekau mā rua ngā kete i kohia e rātou, kī tonu i ngā whati­whatinga, i ngā ika hoki. ");
INSERT INTO mri_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ā, me te mea e rima mano ngā tāne i kai taro rā. ");
INSERT INTO mri_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ā, aki­aki tonu iho ia i āna ākonga kia eke ki te kai­puke, kia whaka­whiti i mua i a ia ki tāwāhi, ki Petahaira, i a ia e tono ana i te mano kia haere. ");
INSERT INTO mri_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nā, ka mutu tāna poro­poro­aki, ka haere ia ki te maunga ki te īnoi. ");
INSERT INTO mri_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nā, kua ahi­ahi, i waenga moana te kai­puke, ko ia anake hoki i uta. ");
INSERT INTO mri_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nā, ka kite ia i a rātou e ruwha ana i te hoenga; i hē hoki te hau ki a rātou; ā, i te whā o ngā mataara­tanga o te pō ka haere atu ia ki a rātou, i haere māori atu i runga i te moana. Me te mea hoki ka pahika kē i a rātou. ");
INSERT INTO mri_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ā, nō ka kite rātou i a ia e haere ana i runga i te moana, ka mahara he wairua, ka auē; ");
INSERT INTO mri_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","i kite hoki rātou katoa i a ia, ā, ihi­ihi ana. Otirā, ka hohoro ia te kōrero ki a rātou, ka mea ki a rātou, “Kia manawa­nui, ko ahau tēnei; kaua e wehi.” ");
INSERT INTO mri_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nā, ka eke ia ki te kai­puke ki a rātou; ā, māriri iho te hau. Ā, nui atu tō rātou oho­mauri, mīharo ana. ");
INSERT INTO mri_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kīhai hoki i mahara ki ngā taro, he pakeke hoki nō ō rātou ngākau. ");
INSERT INTO mri_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ā, nō tō rātou whiti­nga atu, ka tae ki te whenua o Kenehareta, ka herea te kai­puke ki uta. ");
INSERT INTO mri_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nō tō rātou mahuta­tanga i te kai­puke, mōhio tonu rātou ki a ia, ");
INSERT INTO mri_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ā, ka oma puta noa i taua whenua, ā, tawhio noa, ka anga, ka mau mai i ngā tūroro i runga i ngā moenga ki te wāhi, i rongo ai rātou kei reira ia. ");
INSERT INTO mri_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ā, i ōna haere­nga katoa­tanga ki ngā kāinga, ki ngā pā, ki ngā whenua rānei, ka whaka­takoto­ria e rātou ngā tūroro ki ngā kāinga hoko­hoko, ka īnoi ki a ia kia pā kau atu rātou ki te tāniko o tōna kākahu, ā, ora ake ngā tāngata katoa i pā ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nā, ka hui­hui ki a ia ngā Parihi, me ētahi o ngā kara­ipi i haere mai i Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ā, nō tō rātou kite­nga i ētahi o āna ākonga e kai taro ana me te noa anō ngā ringa, arā, kīhai i horoia, ka whaka­hē rātou. ");
INSERT INTO mri_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","E kore hoki ngā Parihi me ngā Hūrai katoa e kai, ki te kāhore i āta horoia ngā ringa, e pupuri ana hoki i te whaka­rere­nga iho a ngā kaumātua. ");
INSERT INTO mri_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","E kore anō rātou e kai ina hoki mai i te kāinga hoko­hoko, ki te mea kāhore i horoi. He maha hoki ērā atu mea tuku iho kia puri­tia e rātou, ngā horoi­nga o ngā kapu, o ngā pāta, o ngā mea parāhi, o ngā nohoa­nga. ");
INSERT INTO mri_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kātahi, ka ui ngā Parihi me ngā kara­ipi ki a ia, “He aha āu ākonga tē haere ai i runga i te whaka­rere­nga iho a ngā kaumātua, ā, kāhore e horoi i ngā ringa ina kai taro?” ");
INSERT INTO mri_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nā, ka mea ia ki a rātou: “Tika rawa tā Ihāia i poro­piti ai mō koutou, mō te hunga tini­hanga, te mea hoki i tuhi­tuhia, ‘Ko te iwi nei, ko ō rātou ngutu hei whaka­hōnore i ahau, ko ō rātou ngākau ia matara noa atu i ahau. ");
INSERT INTO mri_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Otirā, mau­mau kara­kia noa rātou ki ahau, ko tā rātou nei hoki e whaka­ako ai ko ngā whaka­hau a te tāngata.’ ");
INSERT INTO mri_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Kei te whaka­rere hoki koutou i tā te Atua kupu ako, ka mau ki te waiho­tanga iho a te tāngata.” ");
INSERT INTO mri_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ā, ka mea ia ki a rātou, “Tēnā rā tā koutou hanga ki te whaka­kāhore i te whaka­hau a te Atua, kia mau ai koutou ki tā koutou whaka­rere­nga iho. ");
INSERT INTO mri_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","I mea hoki a Mohi, ‘Whaka­hōnore­tia tōu pāpā me tōu whaea’; me tēnei, ‘Ki te kōrero kino tētahi mō tōna pāpā, mō tōna whaea rānei, kia mate ia, mate rawa.’ ");
INSERT INTO mri_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ko koutou ia hei mea, ‘Ki te mea tētahi ki tōna pāpā, ki tōna whaea rānei, ko tāku mea hei ata­whai­nga mōu he Koropana’ (arā, He mea i hoatu ki te Atua), ");
INSERT INTO mri_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kāhore koutou āia­nei i te tuku i a ia ki te mea i tētahi aha mā tōna pāpā, mā tōna whaea rānei; ");
INSERT INTO mri_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ka waiho e koutou tā koutou whaka­rere­nga iho, i whaka­rērea iho nei e koutou, hei whaka­kāhore mō tā te Atua kupu. He maha hoki ngā mea pēnā e meinga ana e koutou.” ");
INSERT INTO mri_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nā, karanga­tia ana anō e ia te mano ki a ia, ā, mea ana ki a rātou, “Whaka­rongo mai koutou katoa, kia mātau hoki. ");
INSERT INTO mri_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kāhore he mea o waho o te tāngata ka tapoko nei ki roto ki a ia hei whaka­noa i a ia; engari, ngā mea e puta ana mai i roto i a ia, mā ēnā e noa ai te tāngata. ");
INSERT INTO mri_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Ki te whai tari­nga tētahi hei whaka­rongo, kia rongo ia.” ");
INSERT INTO mri_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ā, nō ka mawehe kē ia i te mano ki te whare, ka ui āna ākonga ki a ia ki te tikanga o tēnā kupu whaka­rite. ");
INSERT INTO mri_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nā, ka mea ia ki a rātou, “Ha, he kūware anō koutou? Kāhore koutou i mātau, ko ngā mea katoa o waho e tapoko nei ki te tangata, e kore ia e noa i ērā; ");
INSERT INTO mri_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nō te mea e kore e tapoko ki tōna ngākau, engari, ki te kōpū a puta ana ki te poka?” He kōrero tēnei nāna kia kīa ai he mā ngā kai katoa. ");
INSERT INTO mri_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","I mea anō ia, “Ko te mea e puta ake ana i te tangata, mā tērā e noa ai te tangata. ");
INSERT INTO mri_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nō roto hoki, nō te ngākau o ngā tāngata te pu­tanga o ngā whaka­aro kino, o ngā moe­puku, ");
INSERT INTO mri_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","o ngā tāhae, o ngā kōhuru, o ngā pūremu, o ngā hia­hia apo, o ngā kino, o te tini­hanga, o te hia­hia tai­kaha, o te kanohi kino, o te kohu­kohu, o te whaka­peha­peha, o te wai­rangi. ");
INSERT INTO mri_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nō roto te pu­tanga ake o ēnei kino katoa, ā, mā reira e noa ai te tangata.” ");
INSERT INTO mri_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nā, ka whaka­tika atu ia i reira, ka haere ki ngā wāhi o Tāira, o Hairona; ā, tomo ana ki tētahi whare, kīhai hoki ia i pai kia rongo tētahi tangata. Otiia, kīhai ia i ngaro. ");
INSERT INTO mri_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","I reira hoki, ka rangona ia e tētahi wahine, he wairua poke tō tāna kōtiro, ā, haere ana mai, takoto ana ki ōna wae­wae. ");
INSERT INTO mri_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","He wahine Kariki hoki ia, ko Hairopinihia tōna iwi. Ka īnoi ki a ia kia peia e ia te rēwera i roto i tāna kōtiro. ");
INSERT INTO mri_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nā, ka mea a Īhu ki a ia, “Tukua kia mātua mākona ngā tama­riki. E kore hoki e pai kia tango­hia te taro a ngā tama­riki, kia makā mā ngā kurī.” ");
INSERT INTO mri_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Otirā, ka whaka­hoki ia, ka mea ki a ia, “Āe rā, e te Ariki, e kai ana anō ngā kurī i raro i te tēpu i ngā konga­konga a ngā tama­riki.” ");
INSERT INTO mri_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nā, ka mea ia ki a ia, “Koia kei tēnā kupu, haere; kua puta te rēwera i roto i tāu kōtiro.” ");
INSERT INTO mri_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ā, ka haere atu ia ki tōna whare, nā, roko­hanga atu e takoto ana tāna kōtiro i runga i te moenga, kua puta te rēwera. ");
INSERT INTO mri_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ā, i hoki anō ia i ngā wāhi o Tāira, o Hairona, haere ana ki te moana o Kariri, rā waenga o ngā wāhi o Rekaporihi. ");
INSERT INTO mri_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nā, ka mauria mai ki a ia he turi e whango ana; ka tohe ki a ia kia whaka­pā­kia iho tōna ringa ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nā, ka tango­hia ia e ia i roto i te mano ki tahaki, ā, kuhua ana ōna maihao ki ōna tari­nga, nā, ka tuwha, ka whaka­pā ki tōna arero. ");
INSERT INTO mri_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ka ti­tiro ki te rangi, ka whaka­pū­manawa, ka mea ki a ia, “Epata,” arā, “Kia puare.” ");
INSERT INTO mri_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nā, puare tonu iho ōna tari­nga, koro­koro noa ana te here o tōna arero, nā, kua tika āna kōrero. ");
INSERT INTO mri_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kātahi ia ka whaka­tūpato i a rātou kia kaua e kōrero­tia ki te tangata. Otirā, ahakoa te nui o tāna whaka­tūpato i a rātou, nui noa atu tā rātou kōrero haere. ");
INSERT INTO mri_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ā, tino mīharo rawa rātou, ka mea, “Pai tonu tāna mea­tanga i ngā mea katoa; e mea ana ia i ngā turi kia rongo, i ngā wa­hangū kia kōrero.” ");
INSERT INTO mri_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","I aua rā, i te mea he nui rawa te mano, kāhore hoki he kai mā rātou, ka karanga a Īhu ki āna ākonga, ka mea ki a rātou, ");
INSERT INTO mri_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“E aroha ana ahau ki ngā tāngata, ka toru nei hoki ō rātou rā e noho ana ki ahau, ā, kāhore ā rātou kai. ");
INSERT INTO mri_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ki te tonoa puku­tia rātou e ahau ki tō rātou kāinga, ka hemo ki te ara; i haere mai hoki ētahi o rātou i tawhiti.” ");
INSERT INTO mri_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nā, ka whaka­hokia e āna ākonga ki a ia, “Me aha e te tangata ka mākona ai ēnei i te taro i konei, i te koraha?” ");
INSERT INTO mri_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ka ui ia ki a rātou, “E hia ā koutou taro?” Ka mea rātou, “E whitu.” ");
INSERT INTO mri_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nā, ka mea ia ki te mano kia noho ki te whenua; ā, ka mau ki ngā taro e whitu, ka whaka­whetai, ka whawhati, ā, hoatu ana e ia ki āna ākonga kia whaka­takoto­ria ki mua i a rātou; whaka­takoto­ria ana e rātou mā te mano. ");
INSERT INTO mri_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","He ika anō a rātou toru­toru nei, he mea no­nohi, ā, ka mutu te whaka­pai, ka mea ia kia whaka­takoto­ria hoki ērā. ");
INSERT INTO mri_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nā, kai ana rātou, ā, ka mākona, ā, kohia ake ana o ngā whati­whatinga i toe e whitu ngā kete. ");
INSERT INTO mri_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Me te mea e whā mano te hunga i kai, ā, tonoa atu ana rātou e ia. ");
INSERT INTO mri_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nā, eke tonu ia rātou ko āna ākonga ki te kai­puke, ā, ka tae ki ngā wāhi o Taramanuta. ");
INSERT INTO mri_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nā, ka puta mai ngā Parihi, ka anga, ka totohe ki a ia, ka rapu tohu ki ia i te rangi, hei whaka­mā­tau­tau mōna. ");
INSERT INTO mri_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nā, ka hotu tōna wairua, ka mea ia, “He aha tēnei whaka­tupu­ranga ka rapu ai ki te tohu? He pono tāku e mea nei ki a koutou, e kore e hoatu he tohu ki tēnei whaka­tupu­ranga.” ");
INSERT INTO mri_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nā, mahue ake rātou i a ia, ā, eke ana anō ki te kai­puke, rere ana ki tērā taha. ");
INSERT INTO mri_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nā, i ware­ware rātou ki te mau taro, kotahi tonu ā rātou taro i te kai­puke. ");
INSERT INTO mri_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nā, ka whaka­tūpato ia i a rātou, ka mea, “Kia mahara, kia tūpato i te rēwena a ngā Parihi, i te rēwena hoki a Herora.” ");
INSERT INTO mri_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ā, ka kōrero­rero rātou ki a rātou anō, ka mea, “Nō te mea kāhore ā tātou taro.” ");
INSERT INTO mri_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ka mōhio a Īhu, ka mea ki a rātou, “He aha koutou ka kōrero­rero ai nō te mea kāhore ā koutou taro? Kīanō koutou i mātau noa, kīanō i mahara? E pakeke tonu ana anō rānei ō koutou ngākau? ");
INSERT INTO mri_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","He kanohi nei ō koutou, ā, kāhore e kite? He tari­nga nei ō koutou, ā, kāhore e rongo? Kāhore e mahara? ");
INSERT INTO mri_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","I ahau i whawhati i ngā taro e rima mā ngā mano e rima, e hia ngā kete kī o ngā whati­whatinga i kohia e koutou?” Ka mea rātou ki a ia, “Kotahi tekau mā rua.” ");
INSERT INTO mri_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ā, i ngā taro hoki e whitu mā ngā mano e whā, e hia ngā kete kī o ngā whati­whatinga i kohia e koutou?” Ka mea rātou, “E whitu.” ");
INSERT INTO mri_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nā, ka mea ia ki a rātou, “Kāhore anō ia koutou kia mātau noa?” ");
INSERT INTO mri_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ā, ka tae rātou ki Petahaira. Nā, ka kawea mai e rātou he matapō ki a ia, ka īnoi ki a ia kia whaka­pā­ngia e ia. ");
INSERT INTO mri_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nā, ka mau ia ki te ringa o te matapō, ka ārahi i a ia ki waho o te kāinga; ka tuwha ki ōna kanohi, ā, ka whaka­pā i ōna ringa ki a ia, ka ui ki a ia me kore ia e kite i tētahi mea. ");
INSERT INTO mri_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nā, ka ti­tiro ake ia, ka mea, “E kite ana ahau i ngā tāngata e hāere­ere ana me te mea he rākau.” ");
INSERT INTO mri_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Me i reira, ka whaka­pā­kia anō ngā ringa ki ōna kanohi, ka mea i a ia kia ti­tiro. Nā, ka ora ia, ā, ka mārama te ti­tiro ki ngā mea katoa. ");
INSERT INTO mri_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nā, ka tono ia i a ia ki tōna whare, ka mea atu, “Kaua e tomo ki te kāinga.” ");
INSERT INTO mri_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nā, ka haere a Īhu rātou ko āna ākonga ki ngā kāinga o Hiha­ria Piripai, ā, i te ara ka ui ia ki āna ākonga, ka mea ki a rātou, “Ki tā ngā tāngata kī, ko wai ahau?” ");
INSERT INTO mri_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nā, ko tā rātou whaka­hoki­nga, “Ko Hoani Kai­iri­iri; ki tā ētahi, ko Irāia; ki tā ētahi, ko tētahi o ngā poro­piti.” ");
INSERT INTO mri_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nā, ka mea ia ki a rātou, “Ki tā koutou nā kī, ko wai ahau?” Nā, ka whaka­hoki a Pita, ka mea ki a ia, “Ko te Karaiti koe.” ");
INSERT INTO mri_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nā, ka whaka­tūpato ia i a rātou, kia kaua ia e kōrero­tia ki te tangata. ");
INSERT INTO mri_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kātahi ia ka anga, ka whaka­ako i a rātou, kua takoto te tikanga kia maha ngā mamae o te Tama a te tangata, kia whaka­kino­ngia hoki e ngā kaumātua, e ngā tohu­nga nui, e ngā kara­ipi, ā, kia whaka­matea, ā, kia ara anō ina pahure ngā rā e toru. ");
INSERT INTO mri_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","I kōrero­tia mata­nui­tia anō taua kupu e ia. Nā, ka mau a Pita ki a ia, ka anga, ka whaka­hē ki tāna. ");
INSERT INTO mri_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Otirā, ka tahuri ia, ā, i te kite­nga i āna ākonga, ka whaka­hē ki tā Pita, ka mea, “Haere ki muri i ahau, e Hātana. Kāhore hoki ōu ngākau ki ngā mea a te Atua, engari, ki a te tangata.” ");
INSERT INTO mri_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nā, ka karanga­tia e ia te mano, rātou ko āna ākonga, ka mea ki a rātou, “Ki te mea tētahi tangata kia haere mai ki te whai i ahau, me whaka­kāhore ia i a ia anō, me amo i tōna rīpeka, ka aru ai i ahau. ");
INSERT INTO mri_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ki te whai tētahi kia ora, ka mate ia; ki te mate hoki tētahi, mōna i whaka­aro ki ahau, ki te rongo­pai hoki, ka ora ia. ");
INSERT INTO mri_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ā, he aha te pai ki te tangata, ki te riro i a ia te ao katoa, ā, ka kore he ora mōna? ");
INSERT INTO mri_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","He aha hoki tā te tangata e hoatu ai hei utu mōna kia ora? ");
INSERT INTO mri_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ki te whaka­mā hoki tētahi ki ahau, ki āku kōrero, i tēnei whaka­tupu­ranga pūremu, kino, ka whaka­mā anō te Tama a te tangata ki a ia, ina haere mai i runga i te korōria o tōna Matua, rātou ko ngā ana­hera tapu.” ");
INSERT INTO mri_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","I mea anō ia ki a rātou, “He pono tāku e mea nei ki a koutou, tēnei anō ētahi o te hunga e tū nei, e kore e pāngia e te mate, kia kite rā anō i te ranga­tira­tanga o te Atua e haere mai ana i runga i te kaha.” ");
INSERT INTO mri_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ā, ka pahure ngā rā e ono, ka mau a Īhu ki a Pita, ki a Hēmi, ki a Hoani, nā, kawea ana rātou e ia ki runga ki tētahi maunga tike­tike, ko rātou anake. Ā, ka puta kē tōna āhua i tō rātou aro­aro. ");
INSERT INTO mri_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nā, kanapa tonu ōna kākahu, mā tonu me te huka­rere; e kore e taea e te kai­horoi i runga i te whenua te mea kia pērā te mā. ");
INSERT INTO mri_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nā, ka puta mai ki a rātou a Irāia rāua ko Mohi; e kōrero­rero ana rāua ki a Īhu. ");
INSERT INTO mri_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nā, ka oho a Pita, ka mea ki a Īhu, “E te Kai­whaka­ako, he mea pai kia noho tātou ki konei; nā, kia hangā e mātou ētahi wharau kia toru; kia kotahi mōu, kia kotahi mō Mohi, kia kotahi mō Irāia.” ");
INSERT INTO mri_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kāhore hoki ia i mātau ki tāna e kōrero ai; i wehi hoki rātou. ");
INSERT INTO mri_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nā, ko tētahi kapua e tau­maru­maru ana ki runga ki a rātou; ā, ka puta he reo i te kapua, e mea ana, “Ko tāku Tama tēnei i aroha ai; whaka­rongo ki a ia.” ");
INSERT INTO mri_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ā, ti­tiro rawa ake rātou ki tētahi taha, ki tētahi taha kāhore ā rātou tāngata i kite ai, ko rātou anake, ko Īhu. ");
INSERT INTO mri_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ā, i a rātou e heke iho ana i te maunga, ka whaka­tūpato ia i a rātou kia kaua e kōrero­tia ki te tangata ā rātou i kite ai, kia ara rā anō te Tama a te tangata i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ā, i puri­tia taua kupu e rātou, ka uiui ki a rātou anō, he aha rā te aranga ake i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ā, ka ui rātou ki a ia, ka mea, “He aha ngā kara­ipi ka mea ai, ko Irāia kia mātua puta mai?” ");
INSERT INTO mri_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nā, ka whaka­hoki ia, ka mea ki a rātou, “E puta ana anō a Irāia i mua ki te whaka­tika i ngā mea katoa. Kua oti anō te tuhi­tuhi mō te Tama a te tangata, kia maha ōna mamae, kia whaka­kāhore­tia. ");
INSERT INTO mri_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko tāku kupu ia tēnei ki a koutou, Kua tae mai anō a Irāia, heoi, meatia ana e rātou ki a ia tā rātou i pai ai, ngā mea hoki i tuhi­tuhia mōna.” ");
INSERT INTO mri_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ā, nō tō rātou taenga ki ngā ākonga, ka kite rātou he rahi te hui e kara­poti ana i a rātou, me ngā kara­ipi e totohe ana ki a rātou. ");
INSERT INTO mri_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ā, kite kau te mano katoa i a ia, ka mīharo, ā, oma ana, oha ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nā, ka ui ia ki a rātou, “He aha tā koutou e totohe nā ki a rātou?” ");
INSERT INTO mri_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nā, ka whaka­hoki tētahi i roto i te mano, ka mea, “E te Kai­whaka­ako, i kawea mai e ahau tāku tama ki a koe, he wairua reo­kore tōna. ");
INSERT INTO mri_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ā, i ngā wāhi e hopu ai te wairua i a ia, ka tāia iho. Tutū ana te huka, tetēā ana ōna niho, ā, pakoko haere ana: i mea anō ahau ki āu ākonga kia peia ia ki waho; heoi, kīhai i taea e rātou.” ");
INSERT INTO mri_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nā, ko tāna whaka­hoki­nga ki a ia, ka mea, “E te uri whaka­pono kore, kia pēhea te roa o tōku noho ki a koutou? Kia pēhea te roa o tāku manawa­nui ki a koutou? Kawea mai ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nā, kawea ana mai ia ki a ia. Ā, i tōna kite­nga i a ia, nā, hāea tonu­tia iho ia e te wairua; ā, hinga ana ia ki te whenua, ka oke, ka huka. ");
INSERT INTO mri_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nā, ka ui ia ki tōna matua, “Ka pēhea te roa o te mea nei ki ia?” Ka mea ia, “Nō te tama­riki­tanga. ");
INSERT INTO mri_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","He maha āna tura­kanga i a ia ki te kāpura, ki te wai, kia ngaro ai: otirā ki te taea e koe te aha rānei, aroha­ina māua, kia puta tōu whaka­aro ki a māua.” ");
INSERT INTO mri_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ka mea a Īhu ki a ia, “Ki te taea e koe te whaka­pono, ka taea ngā mea katoa e te tangata whaka­pono.” ");
INSERT INTO mri_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nā, karanga tonu mai te matua o te tama, ka mea, “E whaka­pono ana ahau, e te Ariki; kia puta tōu whaka­aro ki tōku whaka­pono kore.” ");
INSERT INTO mri_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ā, nō te kite­nga o Īhu i te mano e oma mai ana, ka rīria e ia te wairua poke, ka mea ki a ia, “E te wairua reo­kore, turi, ko tāku tēnei ki a koe, Puta mai i roto i a ia, kaua anō e tomo ki roto ki a ia ā muri ake nei.” ");
INSERT INTO mri_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nā, hāmama ana tērā, hae­hae noa iho ana i a ia, ā, puta ana mai ki waho; nō ka pērā taua tangata me te tū­pā­paku, ā, he toko­maha i mea, “Kua mate.” ");
INSERT INTO mri_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Otirā, ka mau a Īhu ki tōna ringa, ka whaka­ara i a ia, ā, ka whaka­tika ia. ");
INSERT INTO mri_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ā, i a ia ka tomo ki te whare, ka ui puku āna ākonga ki a ia, “He aha mātou tē āhei ai te pei i a ia ki waho?” ");
INSERT INTO mri_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Anō rā, ko ia ki a rātou, “E kore e puta noa te pēnā, mā te īnoi anake, mā te noho­puku.” ");
INSERT INTO mri_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nā, ka hāpai­nga e rātou i reira, ā, haere ana rā waenga­nui o Kariri; kīhai hoki ia i pai kia rangona e tētahi. ");
INSERT INTO mri_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ko tāna hoki i whaka­ako ai ki āna ākonga, i mea ai ki a rātou, “Ka tukua te Tama a te tangata ki ngā ringa o ngā tāngata, ā, mā rātou ia e whaka­mate; ā, ka oti ia te whaka­mate, ka ara ake i te toru o ngā rā.” ");
INSERT INTO mri_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nā, kīhai rātou i mātau ki taua kupu, ka mataku hoki ki te ui ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nā, ka tae rātou ki Kaperenauma; ā, i a ia i roto i te whare, ka ui ia ki a rātou, “He aha tā koutou i kōrero­rero ai ki a koutou i te ara?” ");
INSERT INTO mri_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Otiia, kīhai rātou i kīkī; ko tā rātou hoki i kōrero­rero ai ki a rātou i te ara, ko wai te mea nui rawa. ");
INSERT INTO mri_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nā, ka noho ia, ka karanga i te tekau mā rua, ka mea ki a rātou, “Ki te whai tētahi kia whiti ko ia hei mua, ka waiho ia hei muri i te katoa, hei kai­mahi mā te katoa.” ");
INSERT INTO mri_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nā, ka mau ia ki tētahi tama­iti nohi­nohi, ā, whaka­tū­ria ana ki waenga­nui i a rātou; nā, ka oko­oko i a ia, ka mea ki a rātou, ");
INSERT INTO mri_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ki te manako tētahi ki tētahi o ngā tama­riki pēnei, he whaka­aro ki tōku ingoa, e manako ana ia ki ahau; ki tē manako hoki tētahi ki ahau, ehara i ahau tāna i manako ai, engari ko tōku kai­tono mai.” ");
INSERT INTO mri_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nā, ka mea a Hoani ki ia, “E te Kai­whaka­ako, i kite mātou i tētahi e pei rēwera ana i runga i tōu ingoa. Nā, rīria iho e mātou, kāhore hoki ia e haere tahi me tātou.” ");
INSERT INTO mri_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nā, ka mea a Īhu, “Kaua ia e rīria ki te mea hoki nōku te ingoa e mahi mere­kara ai tētahi, e kore e hohoro tāna kōrero kino mōku. ");
INSERT INTO mri_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ko ia hoki ehara i te hoa­riri ki a tātou, nō tātou ia. ");
INSERT INTO mri_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ki te whaka­inu­mia koutou e tētahi ki te kapu wai, he whaka­aro ki tōku ingoa, nō te mea nō te Karaiti koutou, he pono tāku e mea nei ki a koutou, e kore ia e hapa i tōna utu. ");
INSERT INTO mri_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nā, ki te mea tētahi kia hē tētahi o ēnei mea no­nohi e whaka­pono nei ki ahau, he pai kē ki a ia me i whaka­iria tētahi kōhatu mira ki tōna kakī, ā, ka makā ia ki te moana. ");
INSERT INTO mri_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nā, ki te hē koe i tōu ringa, pōutoa; pai kē hoki mōu te tomo mutu ki te ora i te makā ringa­rua­tia ki Kehena, ki te kāpura e kore e tineia. ");
INSERT INTO mri_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ki te wāhi e kore ai e mate tō rātou kutu­kutu, ki te kāpura e kore e tineia. ");
INSERT INTO mri_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ki te hē anō koe i tōu wae­wae, pōutoa. Pai kē hoki mōu te tomo kopa ki te ora i te makā wae­wae­rua­tia ki Kehena, ");
INSERT INTO mri_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ki te wāhi e kore ai e mate tō rātou kutu­kutu, ki te kāpura e kore e tineia. ");
INSERT INTO mri_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ā, ki te hē koe i tōu kanohi, makā atu; pai kē hoki mōu te tomo kanohi tahi ki te ranga­tira­tanga o te Atua i te makā kanohi­rua­tia ki Kehena, ");
INSERT INTO mri_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ki te wāhi e kore ai e mate tō rātou kutu­kutu, ki te kāpura e kore e tineia. ");
INSERT INTO mri_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tā te mea ka totea ngā tāngata katoa ki te kāpura. ");
INSERT INTO mri_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“He pai te tote; otirā, ki te pirau te tote, mā te aha e whai tikanga tote ai? “Kia whai tote i roto i a koutou, kia mau hoki te rongo a tētahi ki tētahi.” ");
INSERT INTO mri_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nā, ka whaka­tika ia i reira, haere ana ki ngā wāhi o Hūria ki tērā taha o Horano. Nā, ka hui­hui mai anō ngā mano ki a ia; ka whaka­ako anō ia i a rātou, ko tāna tikanga hoki tērā. ");
INSERT INTO mri_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nā, ka haere mai ngā Parihi, ka ui ki a ia, “He mea tika rānei kia whaka­rere te tangata i tāna wahine?” He whaka­mā­tau­tau hoki mōna. ");
INSERT INTO mri_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nā, ka whaka­hoki ia, ka mea ki a rātou, “He aha tā Mohi i mea ai ki a koutou?” ");
INSERT INTO mri_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ka kī rātou, “I tukua e Mohi kia tuhi­tuhia he puka­puka whaka­rere, ka whaka­rere ai.” ");
INSERT INTO mri_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Nā te pakeke o ō koutou ngākau i tuhi­tuhia ai e ia tēnei kupu ako ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","I te oroko­hanga­nga ia, ‘I hangā rāua e te Atua he tāne, he wahine. ");
INSERT INTO mri_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mō konei ka mahue i te tangata tōna pāpā me tōna whaea, ka piri ki tāna wahine; ");
INSERT INTO mri_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hei kiko­kiko kotahi hoki rāua toko­rua.’ Nā, heoi anō tō rāua toko­rua­tanga, engari, kotahi anō kiko­kiko. ");
INSERT INTO mri_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nā, ko ā te Atua i hono ai, kaua e wehea e te tangata.” ");
INSERT INTO mri_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ā, i te whare ka ui anō āna ākonga ki a ia ki taua mea. ");
INSERT INTO mri_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ka mea ia ki a rātou, “Ki te whaka­rere tētahi i tāna wahine, ā, ka mārena i tētahi atu, e pūremu ana ia, e hara ana ki tērā. ");
INSERT INTO mri_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ki te whaka­rere hoki te wahine i tāna tāne, ā, ka mārena­tia ki tētahi atu, e pūremu ana ia.” ");
INSERT INTO mri_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nā, ka kawea mai ki a ia ētahi tama­riki no­nohi, kia pā ai ia ki a rātou; otirā, ka rīria e ngā ākonga te hunga nāna i kawe mai. ");
INSERT INTO mri_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nō te kite­nga ia o Īhu, ka riri, ka mea ki a rātou, “Tukua ngā tama­riki no­nohi kia haere mai ki ahau, kaua hoki rātou e āraia atu; nō ngā pēnei hoki te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","He pono tāku e mea nei ki a koutou, ki te kāhore e rite te tango a tētahi i te ranga­tira­tanga o te Atua ki tā te tama­iti nohi­nohi, e kore ia e tomo ki roto.” ");
INSERT INTO mri_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nā, oko­okona ana rātou e ia, whaka­pā­kia iho ōna ringa ki a rātou, manaaki­tia ana rātou. ");
INSERT INTO mri_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nā, i a ia e haere ana i te hua­rahi, ka oma mai tētahi, ka tuku iho i ngā turi ki a ia, ka ui, “E te Kai­whaka­ako pai, me aha ahau ka whi­whi ai ki te ora tonu?” ");
INSERT INTO mri_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nā, ka mea a Īhu ki a ia, “He aha ahau i kīa ai e koe he pai? Kāhore tētahi i pai, kotahi anake, ko te Atua. ");
INSERT INTO mri_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E mātau ana koe ki ngā ture, ‘Kaua e pūremu. Kaua e patu tangata. Kaua e tāhae. Kaua e whaka­pae teka. Kaua e kaiā. Whaka­hōnore­tia tōu pāpā me tōu whaea.’ ” ");
INSERT INTO mri_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nā, ka whaka­hoki tērā, ka mea ki a ia, “E te Kai­whaka­ako, kua rite katoa ēnei mea i ahau nō tōku tama­riki­tanga ake.” ");
INSERT INTO mri_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nā, ka ti­tiro a Īhu ki a ia, ka aroha ki a ia, ka mea ki a ia, “Kotahi te mea kāhore nei i a koe. Haere, hokona āu mea, ka hoatu ki ngā rawa­kore, ā, e whai taonga koe ki te rangi. Kātahi ka haere mai, ka aru i ahau.” ");
INSERT INTO mri_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Otirā, ka tuku tōna mata i taua kupu, ā, haere pōuri atu ana; he maha hoki ōna taonga. ");
INSERT INTO mri_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nā, ka tiro­tiro a Īhu, ka mea ki āna ākonga, “Anō te whaka­uaua o te tapoko o te hunga taonga ki te ranga­tira­tanga o te Atua!” ");
INSERT INTO mri_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nā, ka mīharo ngā ākonga ki āna kupu. Otirā, ka whaka­hoki anō a Īhu, ka mea ki a rātou, “E tama mā, anō te whaka­uaua o te tapoko ki tō te Atua ranga­tira­tanga o te hunga e whaka­whiri­naki ana ki ngā taonga! ");
INSERT INTO mri_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Erangi, te haere o te kāmera rā te kōwhao o te ngira he mea takoto noa, he whaka­uaua rawa ia te haere o te tangata taonga ki roto ki te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nā, rahi rawa tō rātou mīharo, ka mea ki a rātou anō, “Ko wai rā e ora?” ");
INSERT INTO mri_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nā, ka ti­tiro a Īhu ki a rātou, ka mea, “E kore tēnei e taea e te tangata, ki te Atua ia ka taea; e taea hoki ngā mea katoa e te Atua.” ");
INSERT INTO mri_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kātahi, ka anga a Pita, ka mea ki a ia, “Nā, kua mahue nei i a mātou ngā mea katoa, kua aru nei i a koe.” ");
INSERT INTO mri_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nā, ka whaka­hoki a Īhu, ka mea, “He pono tāku e mea nei ki a koutou, ki te whaka­rērea e tētahi tangata, he whare, he tēina, he tuā­hine, he whaea, he pāpā, he tama­riki, he māra, he whaka­aro nōna ki ahau, ki te rongo­pai hoki, ");
INSERT INTO mri_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","inā, tā­taki­rau ngā mea e riro i a ia, i tēnei wā, he whare, he tēina, he tuā­hine, he whaea, he tama­riki, he māra, me te whaka­toi; ā, i te ao meāke puta, he ora tonu. ");
INSERT INTO mri_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","He toko­maha ia ō mua e waiho ki muri; ko ō muri hoki ki mua.” ");
INSERT INTO mri_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nā, i te hua­rahi rātou e haere ana ki Hiruhārama, me te haere anō a Īhu i mua i a rātou; nā, e mīharo ana rātou, e aru mataku ana. Heoi, ka mau anō ia i te tekau mā rua, ka anga, ka kōrero ki a rātou i ngā mea meāke pā ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nana, e haere ana tēnei tātou ki Hiruhārama; ā, ka tukua te Tama a te tangata ki ngā tohu­nga nui, ki ngā karai­pi; ka kīa e rātou kia mate, ka tuku hoki rātou i a ia ki ngā tauiwi; ");
INSERT INTO mri_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ka tāwaia ia, ka tu­whai­na, ka whiua, ka whaka­matea, ā, i te toru o ngā rā, ka ara.” ");
INSERT INTO mri_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nā, ka whaka­tata mai ki a ia a Hēmi rāua ko Hoani, ngā tama a Heperi, ka mea, “E te Kai­whaka­ako, e hia­hia ana māua kia meatia e koe tā māua e īnoi ai.” ");
INSERT INTO mri_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nā, ka mea ia ki a rāua, “He aha tā kōrua e hia­hia ai kia meatia e ahau mā kōrua?” ");
INSERT INTO mri_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ka mea rāua ki a ia, “Tukua ki a māua kia noho, tētahi ki tōu matau, tētahi ki tōu mauī, i tōu korōria.” ");
INSERT INTO mri_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nā, ko te mea­tanga a Īhu ki a rāua, “Kāhore kōrua e mātau ki tā kōrua e īnoi nei; e āhei rānei kōrua te inu i te kapu ka inumia nei e ahau? Kia iri­iria ki te iri­iri­nga ka iri­iria nei ahau?” ");
INSERT INTO mri_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ka mea rāua ki a ia, “E āhei anō.” Ka kī atu a Īhu ki a rāua, “E inu anō kōrua i te kapu ka inumia e ahau; e iri­iria kōrua ki te iri­iri­nga e iri­iria ai ahau. ");
INSERT INTO mri_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tēnā, ko te noho ki tōku matau, ki tōku mauī rānei, ehara i te mea māku e hoatu, engari, ka riro i te hunga i whaka­ritea nei mō rātou.” ");
INSERT INTO mri_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ā, nō te rongo­nga o te tekau, ka anga ka riri ki a Hēmi rāua ko Hoani. ");
INSERT INTO mri_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nā, karanga­tia ana rātou e Īhu ki a ia, ka mea ki a rātou, “E mahara ana koutou, ko te hunga e kīa ana he kāwana nō ngā tauiwi hei whaka­tupu ranga­tira ki a rātou; ko ō rātou tāngata rarahi hoki hei aki­aki i a rātou. ");
INSERT INTO mri_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Otirā, e kore e pērā i roto i a koutou; engari, ki te mea tētahi kia whaka­tupu tangata rahi i roto i a koutou, me whaka­tupu kai­mahi ia mā koutou. ");
INSERT INTO mri_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ki te mea hoki tētahi o koutou kia whaka­tupu tino tangata, me whaka­tupu pono­nga ia mā te katoa. ");
INSERT INTO mri_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kīhai nei hoki te Tama a te tangata i haere mai kia mahia he mea māna, engari, kia mahi ia, kia tuku hoki i a ia kia mate hei utu mō ngā tāngata toko­maha.” ");
INSERT INTO mri_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nā, ka tae rātou ki Heriko. A, i a ia e haere atu ana i roto i Heriko, rātou ko āna ākonga me te mano tini, e noho ana a Paratimiuha, tama a Timiuha, he matapō, i te taha o te ara, ki te tono mea māna. ");
INSERT INTO mri_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ā, i tōna rongo­nga ko Īhu o Nahareta tēnā, ka anga ia, ka karanga, ka mea, “E Īhu, e te Tama a Rāwiri, kia aroha ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ā, he toko­maha ki te riri i a ia kia noho puku, heoi, tino rahi ake tāna karanga, “E te Tama a Rāwiri, kia aroha ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nā, ka tū a Īhu, ka mea kia karanga­tia ia. Ā, karanga­tia ana e rātou te matapō, ka mea ki a ia, “Kia māia, whaka­tika; e karanga ana ia ki a koe.” ");
INSERT INTO mri_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nā, ka whaka­rērea e ia tōna kākahu, ā, whaka­tika ana, haere ana ki a Īhu. ");
INSERT INTO mri_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nā, ka oho a Īhu, ka mea ki a ia, “He aha tāu e hia­hia nā kia meatia e ahau māu?” Ka kī te matapō ki a ia, “E te Ariki, kia ti­tiro ahau.” ");
INSERT INTO mri_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ka mea a Īhu ki a ia, “Haere; nā tōu whaka­pono koe i ora ai.” Nā, ti­tiro tonu iho ia, aru ana i a Īhu i te ara. ");
INSERT INTO mri_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ā, nō ka tata rātou ki Hiruhārama, ki Petapaki, ki Petani, ā, ka tae ki Maunga Ōriwa, toko­rua āna ākonga i tonoa e ia, ");
INSERT INTO mri_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ā, i mea ia ki a rāua, “Haere ki te kāinga e anga mai ana ki a kōrua; e tomo kau ki reira, ka kite kōrua i tētahi kūao e here ana, kāhore anō kia nohoia e te tangata; wete­kina, āra­hina mai. ");
INSERT INTO mri_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ā, ki te kī mai tētahi tangata ki a kōrua, ‘He aha tēnei ka meinga ai e kōrua?’ Ka mea atu, ‘E mea ana te Ariki ki a ia māna; nā, ka tukua tonu­tia mai ki konei.’ ” ");
INSERT INTO mri_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nā, haere ana rāua, ka kite i te kūao e here ana ki te kūwaha i waho i te ara, ā, wete­kina ana e rāua. ");
INSERT INTO mri_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ā, ka mea ētahi o te hunga e tū ana i reira ki a rāua, “He aha tā kōrua e wewete nā i te kūao?” ");
INSERT INTO mri_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nā, ka kōrero­tia e rāua ki a rātou tā Īhu i mea ai; ā, tukua ana rāua e rātou. ");
INSERT INTO mri_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ka āra­hina te kūao ki a Īhu, nā, whā­riki­tia ana ō rāua kākahu ki runga ki a ia; ā, noho ana ia i runga. ");
INSERT INTO mri_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nā, he toko­maha i whā­riki i ō rātou kākahu ki te ara. Ko ētahi i kokoti i ngā manga o ngā rākau, whā­riki­tia ana ki te ara. ");
INSERT INTO mri_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ko te hunga i haere i mua, me te hunga i haere i muri, i karanga, i mea, “Ohana! Ka whaka­pai­ngia ia e haere mai ana i runga i te ingoa o te Ariki! ");
INSERT INTO mri_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ka whaka­pai­ngia te ranga­tira­tanga e haere mai ana, te ranga­tira­tanga o tō tātou matua o Rāwiri! Ohana i runga rawa!” ");
INSERT INTO mri_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nā, ka tomo a Īhu ki Hiruhārama, ki roto hoki ki te teme­para; ā, ka mutu tāna tiro­tiro i ngā mea katoa, ko te wā hoki o te ahi­ahi, ka haere rātou ko te tekau mā rua ki Petani. ");
INSERT INTO mri_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nā, i te aonga ake, i a rātou kua puta i Petani, ka hia­kai ia. ");
INSERT INTO mri_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ā, i tōna kite­nga i tētahi piki i tawhiti, he rau ōna, ka haere ia, me kore e kitea tētahi mea i runga; ā, nō tōna taenga, kīhai i kitea e ia tētahi mea, he rau anake: ehara hoki i te wā o te piki. ");
INSERT INTO mri_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nā, ka oho a Īhu, ka mea ki taua rākau, “Kaua rawa te tangata e kai i tētahi hua ōu ake tonu atu.” Me te whaka­rongo anō āna ākonga. ");
INSERT INTO mri_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ā, ka tae rātou ki Hiruhārama. Nā, ka tomo a Īhu ki te teme­para, ka anga ki te pei ki waho i te hunga e hoko atu ana, e hoko mai ana i roto i te teme­para, ā, whaka­tahuri­tia ake ngā tēpu o ngā kai­whaka­whiti­whiti moni, me ngā nohoa­nga o ngā kai­hoko kūkupa. ");
INSERT INTO mri_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ā, kīhai i tukua e ia kia mauria tētahi oko e te tangata rā te teme­para. ");
INSERT INTO mri_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ā, i whaka­ako ia, i mea ki a rātou, “Kāhore koia i tuhi­tuhia, ‘Ka kīa tōku whare he whare īnoi mō ngā tauiwi katoa’? Otiia, kua meinga nei e koutou hei ana mō ngā kai­pāhua.” ");
INSERT INTO mri_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","I rongo hoki ngā tohu­nga nui me ngā kara­ipi, ā, ka rapu ki te pēhea e whaka­ngaro­mia ai ia. I mataku hoki rātou i a ia, nō te mea i mīharo te mano katoa ki tāna ako. ");
INSERT INTO mri_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ā, i ngā ahi­ahi ka haere ia ki waho o te pā. ");
INSERT INTO mri_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ā, i te ata i a rātou e haere ana, ka kite i te piki, kua maroke ake i ngā paki­aka. ");
INSERT INTO mri_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nā, ka mahara a Pita, ka mea ki a ia, “E te Kai­whaka­ako, nā, te piki i kangā rā e koe, kua maroke.” ");
INSERT INTO mri_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Kia mau te whaka­pono ki te Atua. ");
INSERT INTO mri_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","He pono hoki tāku e mea nei ki a koutou, ki te mea tētahi ki tēnei maunga, ‘Kia rangā atu koe, kia whaka­takā ki te moana,’ e kore hoki e rua­rua tōna ngākau, engari, ka whaka­pono ia tērā e puta mai ngā mea i kīa e ia; ka whi­whi ia ki tāna i mea ai. ");
INSERT INTO mri_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Koia ahau ka mea nei ki a koutou, ko ngā mea katoa e tono ai koutou ina īnoi, me whaka­pono ka riro mai i a koutou, ā, ka whi­whi koutou. ");
INSERT INTO mri_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ā, ka tū koutou, ka kara­kia, ki te mea he take riri tā koutou ki tētahi, murua; kia murua ai hoki ō koutou hē e tō koutou Matua i te rangi. ");
INSERT INTO mri_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nā, ki te kore koutou e muru, e kore anō tō koutou Matua i te rangi e muru i ō koutou hē.” ");
INSERT INTO mri_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nā, ka tae anō rātou ki Hiruhārama. Ā, i a ia e hāere­ere ana i te teme­para, ka haere mai ki a ia ngā tohu­nga nui, me ngā kara­ipi, me ngā kaumātua ");
INSERT INTO mri_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ka mea ki a ia, “Tēnā, te mana i meatia ai ēnei mea e koe? Nā wai hoki tēnei mana i hoatu ki a koe, i mea ai koe i ēnei mea?” ");
INSERT INTO mri_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Māku hoki e ui ki a koutou kia kotahi kupu, mā koutou e whaka­hoki mai ki ahau, kātahi, ka kōrero­tia e ahau ki a koutou te mana i mea ai ahau i ēnei mea. ");
INSERT INTO mri_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ko te iri­iri­nga a Hoani, nō te rangi, nō te tangata rānei? Kōrero­tia mai ki ahau.” ");
INSERT INTO mri_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ā, ka kōrero­rero rātou ki a rātou anō, ka mea, “Ki te mea tātou, ‘Nō te rangi’; ka mea ia, ‘Ha, he aha koutou tē whaka­pono ai ki a ia?’ ");
INSERT INTO mri_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ā, ki te mea tātou, ‘Nō te tangata.’ ” (Ka mataku rātou i te iwi; ki tā rātou katoa hoki he poro­piti pono a Hoani.) ");
INSERT INTO mri_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nā, ka whaka­hoki rātou, ka mea ki a Īhu, “Kāhore mātou e mātau.” Nā, ka mea a Īhu ki a rātou, “E kore anō e kōrero­tia e ahau ki a koutou te mana i mea ai ahau i ēnei mea.” ");
INSERT INTO mri_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nā, ka tīmata ia ki te kōrero kupu whaka­rite ki a rātou: “I whaka­tō­kia e tētahi tangata he māra wāina, tai­epa­tia ana ki te taiepa, nā, ka keria te takoto­ranga wāina, hangā ana tētahi whare tike­tike, tukua ana e ia ki ngā kai­mahi, nā, ko tōna haere­nga ki tawhiti. ");
INSERT INTO mri_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ā, i te pō i tika ai ka tonoa e ia he pono­nga ki ngā kai­mahi ki te tiki i ētahi hua o te māra wāina i a rātou. ");
INSERT INTO mri_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nā, ka mau rātou ki a ia, ā, whiua ana, tonoa kautia atu ana. ");
INSERT INTO mri_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nā, ka tonoa anō e ia ki a rātou tētahi atu pono­nga; ā, ka ākina ia e rātou ki te kōhatu, ngawhā iho tōna māte­nga, ā, ka tūkino­tia ia e rātou ka tonoa atu. ");
INSERT INTO mri_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nā, ka tonoa anō e ia tētahi atu; ā, whaka­matea iho ia e rātou; me ērā atu, tōna tini, ko ētahi i whiua, ko ētahi i whaka­matea. ");
INSERT INTO mri_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nā, kotahi ake anō tāna, he tama aroha nāna, ko ia ō muri rawa i tonoa ai e ia ki a rātou, i mea hoki ia, ‘E hopo­hopo rātou ki tāku tama.’ ");
INSERT INTO mri_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nā, ka mea aua kai­mahi ki a rātou anō, ‘Ko te tangata tēnei mōna te kāinga; tēnā, tātou ka whaka­mate i a ia, ā, mō tātou te kāinga.’ ");
INSERT INTO mri_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nā, ka mau rātou ki a ia, whaka­matea iho, makā ana ki waho o te māra wāina. ");
INSERT INTO mri_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Nā, ka pēhea te ranga­tira o te māra wāina? Ka haere ia, ka whaka­ngaro i ngā kai­mahi, ka hoatu te māra wāina ki ētahi atu. ");
INSERT INTO mri_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kāhore koia koutou i kite i tēnei karaipi­ture: ‘Ko te kōhatu i kapea e ngā kai­hanga kua meinga hei ūpoko mō te koko­nga. ");
INSERT INTO mri_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nā te Ariki tēnei, ā, he mea whaka­mīharo hoki ki ō tātou kanohi.’?” ");
INSERT INTO mri_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nā, ka whai rātou kia hopu­kina ia, otiia, i mataku i te mano. I mātau hoki rātou mō rātou te kupu whaka­rite i kōrero­tia nei e ia; nā, whaka­rērea ana ia, haere ana rātou. ");
INSERT INTO mri_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nā, ka tonoa mai e rātou ki a ia ētahi o ngā Parihi, rātou ko ngā Herōriana, hei hopu mō tētahi kupu āna. ");
INSERT INTO mri_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ā, nō tō rātou taenga mai, ka mea ki a ia, “E te Kai­whaka­ako, e mātau ana mātou he kupu pono tāu, e kore anō tā te tangata e whaka­aroa e koe; e kore anō koe e ti­tiro ki te kanohi tangata, engari, ka whaka­ako i te ara a te Atua i runga i te pono. He mea tika rānei te hoatu takoha ki a Hīhā, ehara rānei? ");
INSERT INTO mri_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","“Me hoatu rānei e mātou, kaua rānei e hoatu?” Otirā, i mōhio ia ki tō rātou tini­hanga, ka mea ki a rātou, “He aha koutou ka whaka­mā­tau­tau ai i ahau? Mauria mai he pene ki ahau, kia kite ahau.” ");
INSERT INTO mri_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ā, mauria ana mai. Nā, ko tāna mea­tanga ki a rātou, “Nō wai tēnei āhua me te tuhi­tuhi­nga?” Ka mea rātou ki a ia, “Nō Hīhā.” ");
INSERT INTO mri_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Hoatu ki a Hīhā, ngā mea a Hīhā, ki te Atua ngā mea a te Atua.” Ā, mīharo ana rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nā, ka haere mai ki a ia ngā Haruki, e mea nei kāhore he aranga; ka ui ki a ia, ka mea, ");
INSERT INTO mri_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“E te kai­whaka­ako, i tuhi­tuhi a Mohi ki a mātou, ‘Ki te mate te tua­kana o tētahi tangata, mahue iho tāna wahine, kāhore he tama­riki hei waiho­tanga iho, me tango tāna wahine e tōna teina, ka whaka­tupu uri ai mō tōna tua­kana.’ ");
INSERT INTO mri_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nā, tērā tētahi whānau, toko­whitu, he tuā­kana, he tēina: ka tango tō mua i te wahine, ka mate, ā, kāhore he uri hei waiho­tanga iho. ");
INSERT INTO mri_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kātahi, ka tango te tuarua i a ia, ka mate, kāhore anō hoki ōna uri hei waiho­tanga iho. Pērā tonu anō hoki te tua­toru. ");
INSERT INTO mri_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","I tango anō te toko­whitu i a ia, ā, kāhore ō rātou uri hei waiho­tanga iho. Muri rawa iho ka mate ko te wahine. ");
INSERT INTO mri_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nā, i te aranga, i te mea ka ara rātou, mā wai o rātou te wahine? He wahine hoki ia nā rātou toko­whitu.” ");
INSERT INTO mri_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Ehara ianei tēnei i te mea i hē ai koutou, kāhore nei hoki e mōhio ki ngā karaipi­ture, ki te kaha hoki o te Atua? ");
INSERT INTO mri_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","I te mea hoki ka ara mai rātou i te hunga mate, e kore e mārena, e kore anō e hoatu kia mārena­tia; engari, ka rite ki ngā ana­hera o te rangi. ");
INSERT INTO mri_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nā, mō te hunga mate, mō tō rātou aranga mai; kāhore koutou i kite i roto i te Puka­puka a Mohi, i te wāhi ki te Rākau, i tā te Atua i kī ai ki a ia, i mea ai, ‘Ko te Atua ahau o Āperahama, ko te Atua o Īhaka, ko te Atua o Hākopa’? ");
INSERT INTO mri_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ehara ia i te Atua nō te hunga mate, engari, he Atua nō te hunga ora; nā, nui atu tō koutou hē!” ");
INSERT INTO mri_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ā, ko te haere­nga mai o tētahi o ngā kara­ipi, ko te rongo­nga ki a rātou e totohe ana, ka kite he pai tāna whaka­hoki ki a rātou, ka ui ki a ia, “Ko tēhea te tua­tahi o ngā ture katoa?” ");
INSERT INTO mri_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nā, ko te whaka­hoki­nga a Īhu ki a ia, “Ko te tua­tahi o ngā ture katoa, ‘Whaka­rongo, e Īharaira: Ko te Ariki, ko tō tātou Atua, he Ariki kotahi; ");
INSERT INTO mri_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","kia whaka­paua hoki tōu ngākau, tōu wairua, tōu hine­ngaro, tōu kaha, ki te aroha ki te Ariki, ki tōu Atua. Ko te ture tua­tahi tēnei.’ ");
INSERT INTO mri_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ko te tuarua tēnei, ‘Kia aroha koe ki tōu hoa tata, ānō ko koe.’ Kāhore he ture kē atu e rahi ake ana i ēnei.” ");
INSERT INTO mri_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nā, ka mea te kara­ipi ki a ia, “He pono, e te Kai­whaka­ako, he tika tāu kōrero kotahi tonu ia, ā, kāhore tētahi ko ia anake; ");
INSERT INTO mri_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ā, ‘Ko te whaka­pau i te ngākau, i te hine­ngaro, i te wairua, i te kaha, ki te aroha ki a ia, me te aroha ki tōna hoa tata, ānō ko ia,’ nui atu ēnā i ngā tahu­nga tinana, i ngā patu­nga tapu katoa.” ");
INSERT INTO mri_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ā, nō te kite­nga o Īhu he kupu mōhio tāna i whaka­hoki ai, ka mea ki a ia, “Kāhore koe i matara atu i te ranga­tira­tanga o te Atua.” Ā, kīhai tētahi tangata i māia ki te ui ki a ia i muri iho. ");
INSERT INTO mri_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nā, ka kī a Īhu, ka mea, i a ia e whaka­ako ana i roto i te teme­para, “Nā te aha ngā kara­ipi ka mea ai, he tama nā Rāwiri a te Karaiti? ");
INSERT INTO mri_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nā Rāwiri ake hoki te kupu i roto i te Wairua Tapu, ‘I mea te Ariki ki tōku Ariki: Hei tōku matau koe noho ai, kia meinga rā anō e ahau ōu hoa­riri hei tū­ranga wae­wae mōu.’ ");
INSERT INTO mri_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ko Rāwiri tonu tēnei e karanga nei ki a ia he Ariki; ā, nō hea ia i tama ai ki a ia?” Ā, āhua­reka ana te mano tini ki te whaka­rongo ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nā, i mea anō ia ki a rātou i tāna ako­ranga, “Kia tūpato ki ngā kara­ipi, ko tā rātou e rawe ai ko te hāere­ere i roto i ngā kākahu roroa, me ngā oha­tanga i ngā kāinga hoko­hoko, ");
INSERT INTO mri_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","me ngā nohoa­nga ranga­tira i ngā whare kara­kia, me ngā nohoa­nga ranga­tira i ngā hākari. ");
INSERT INTO mri_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ka pau nei i a rātou ngā whare o ngā pouaru, ā, ka māminga ki te īnoi roa. He nui rawa te mate e pā ki ēnei.” ");
INSERT INTO mri_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ā, ka noho a Īhu i te rite­nga atu o te takoto­ranga moni, ka mā­taki­taki ki te mano e panga moni ana ki te takoto­ranga moni; ā, he toko­maha ngā tāngata whai taonga i panga moni maha ki roto. ");
INSERT INTO mri_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nā, ko te haere­nga mai o tētahi pouaru rawa­kore, ka maka i ngā mea no­nohi e rua, kotahi pātene ki te huia. ");
INSERT INTO mri_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nā, ka karanga­tia e ia āna ākonga, ka mea ki a rātou, “He pono tāku e mea nei ki a koutou, ko tā tēnei pouaru rawa­kore i maka ai, nui atu i a rātou katoa e maka rā ki te takoto­ranga moni. ");
INSERT INTO mri_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ko rātou katoa hoki, he hira nei ō rātou taonga, i makā ko tētahi wāhi; tēnā ko ia i tōna rawa­kore­tanga i maka i āna mea katoa, arā, i tōna oranga katoa.” ");
INSERT INTO mri_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ā, i a ia e haere atu ana i te teme­para, ka mea tētahi o āna ākonga ki a ia, “E te Kai­whaka­ako, Nana, te tū o ngā kōhatu, te tū o ngā whare!” ");
INSERT INTO mri_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nā, ka whaka­hoki a Īhu, ka mea ki a ia, “Ka kite koe i ēnei whare nunui? E kore tētahi kōhatu e waiho i konei i runga ake i tētahi kōhatu, engari, ka whaka­horoa.” ");
INSERT INTO mri_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ā, i a ia e noho ana i runga i Maunga Ōriwa i te rite­nga atu o te teme­para, ka ui puku ki a ia a Pita, a Hēmi, a Hoani, a Anaru, ");
INSERT INTO mri_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kōrero­tia mai ki a mātou, ko āhea ēnei mea, ā, he aha te tohu ina tata ēnei mea katoa te rite?” ");
INSERT INTO mri_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nā, ka anga ia, ka kōrero ki a rātou, “Kia tūpato kei māminga­tia koutou e te tangata. ");
INSERT INTO mri_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","He toko­maha hoki e haere mai i runga i tōku ingoa, e mea, ‘Ko ahau ia!’ ā, he toko­maha e māminga­tia. ");
INSERT INTO mri_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","E rongo koutou ki ngā pakanga, ki ngā hau pakanga, kei oho­rere. Kua takoto hoki he pu­tanga mō aua mea; taihoa rawa ia te mutu­nga. ");
INSERT INTO mri_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ka whaka­tika hoki tētahi iwi ki tētahi iwi, tētahi ranga­tira­tanga ki tētahi ranga­tira­tanga; ā, he tini ngā wāhi e puta ai he rū; ka puta anō hoki he pō matekai. Ko te tīma­tanga ēnei o ngā mamae. ");
INSERT INTO mri_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nā, kia tūpato ki a koutou: ka tukua hoki koutou ki ngā rū­nanga; ka whiua koutou i roto i ngā whare kara­kia; ā, ka whaka­tū­ria koutou ki te aro­aro o ngā kāwana, o ngā kīngi, mō te whaka­aro ki ahau, hei mea whaka­atu ki a rātou. ");
INSERT INTO mri_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kua takoto ia te tikanga kia mātua kauwhau­tia te rongo­pai ki ngā tauiwi katoa. ");
INSERT INTO mri_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ina, āra­hina koutou ki te whaka­wā, ā, ka tukua atu, kaua e mā­nuka­nuka wawe ki tā koutou e kōrero ai: engari, ko te mea e hoatu ki a koutou i taua hāora, ko tēnā tā koutou e kōrero ai: ehara hoki i te mea mā koutou ngā kōrero, engari, mā te Wairua Tapu. ");
INSERT INTO mri_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nā, ka tukua te tua­kana e te teina ki te mate, te tama­iti hoki e te pāpā; ā, ka whaka­tika ngā tama­riki ki ngā mātua, ka mea kia whaka­matea. ");
INSERT INTO mri_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ā, ka kino­ngia koutou e ngā tāngata katoa, he mea mō tōku ingoa. Ko te tangata ia e ū ana ā taea noatia te mutu­nga, ko ia e ora.” ");
INSERT INTO mri_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ā, ki te kite koutou i te mea whaka­riha­riha, i te mea whaka­ngaro e tū ana i te wāhi e kore e tika, kia mātau te kai­titiro puka­puka, ko reira me rere te hunga i Hūria ki ngā maunga. ");
INSERT INTO mri_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ko te tangata hoki i runga i te whare kaua e heke iho ki roto ki te whare, kaua hoki e tomo ki te tiki i tētahi mea i roto i tōna whare. ");
INSERT INTO mri_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kaua anō te tangata i te māra e hoki ki muri, ki te tiki i tōna kākahu. ");
INSERT INTO mri_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Auē te mate mō te hunga e hapū ana, mō ngā mea hoki e whāngai ana ki te ū, i aua rā! ");
INSERT INTO mri_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mā koutou ia e īnoi kei roko­hanga koutou e te whati i te hōtoke. ");
INSERT INTO mri_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","He whaka­pāwera hoki aua rā, kāhore ōna rite o te oroko­hanga­nga rā anō i hangā nei e te Atua, ā, mohoa noa nei, kāhore hoki he pērā ā muri ake nei. ");
INSERT INTO mri_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Me i kāhore hoki aua rā i poroa i waenga e te Ariki, e kore tētahi kiko­kiko e ora. Otirā, ka whaka­aroa te hunga whiri­whiri i whiri­whiria e ia, ā, poroa ana aua rā i waenga. ");
INSERT INTO mri_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ki te mea tētahi ki a koutou i reira, ‘Nā, tēnei a te Karaiti.’ Nā, ‘Tērā!’ kaua e whaka­pono­hia. ");
INSERT INTO mri_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","E whaka­tika hoki ngā Karaiti teka, me ngā poro­piti teka, ka whaka­atu i ngā tohu me ngā mea whaka­mīharo, ā, me i taea, ka māminga­tia e rātou te hunga whiri­whiri. ");
INSERT INTO mri_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kia tūpato rā koutou; nā, kua kōrero­tia wawe­tia nei e ahau ngā mea katoa ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nā, i aua rā, i muri iho i taua whaka­pāwera, ka whaka­pōuri­tia te rā, e kore hoki e titi te ata­rau, ");
INSERT INTO mri_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ka taka iho ngā whetū o te rangi, ka ngā­ueue ngā mea kaha o ngā rangi. ");
INSERT INTO mri_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nā, ko reira kitea ai te Tama a te tangata e haere mai ana i runga i ngā kapua, me te kaha nui, me te korōria. ");
INSERT INTO mri_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ko reira anō ia tono ai i āna ana­hera, ā, ka hui­huia ana i whiri­whiri ai i ngā hau e whā, i te pito o te whenua tae noa ki te pito o te rangi.” ");
INSERT INTO mri_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nā, kia ākona koutou e te piki ki tētahi kupu whaka­rite. I tōna manga e ngā­wari ana, e puta ana hoki ngā rau, ka mōhio koutou ka tata te rau­mati. ");
INSERT INTO mri_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wai­hoki ko koutou, ina kite i ēnei mea e puta mai ana, ka mātau ka tata ia, kei ngā kūwaha. ");
INSERT INTO mri_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","He pono tāku e mea nei ki a koutou, E kore tēnei whaka­tupu­ranga e pahemo, kia puta rā anō ēnei mea katoa. ");
INSERT INTO mri_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ko te rangi me te whenua e pahemo, ko āku kupu ia e kore e pahemo.” ");
INSERT INTO mri_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Otiia, kāhore tētahi tangata e mātau ki taua rā, ki taua hāora, kāhore ngā ana­hera o te rangi, kāhore te Tama, ko te Matua anake. ");
INSERT INTO mri_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kia tūpato, kia mata­ara, me te īnoi anō. Kāhore hoki koutou e mātau ki te wā, ko āhea rānei. ");
INSERT INTO mri_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ka rite hoki ki te tangata e haere ana ki tawhiti, mahue iho i a ia tōna whare, ā, tukua iho e ia ngā tikanga ki āna pono­nga, tāna mahi mā tētahi, mā tētahi, ka whaka­hau iho hoki ki te kai­tiaki tatau kia mata­ara. ");
INSERT INTO mri_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Āe rā, kia mata­ara; kāhore hoki koutou e mātau ki te wā e haere mai ai te ranga­tira o te whare, ko te ahi­ahi, ko waenga­nui pō rānei, ko te tangi­hanga o te hei­hei, ko te atatū rānei; ");
INSERT INTO mri_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","kei puta whaka­rere mai, ka roko­hanga koutou e ia e moe ana. ");
INSERT INTO mri_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nā, ko tāku ka mea atu nei ki a koutou, e meatia ana anō ki te katoa: Kia mata­ara!” ");
INSERT INTO mri_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nā, kia rua ake ngā rā ko te Kape­nga me te Hākari o te Taro Rēwenakore. Nā, ka rapu ngā tohu­nga nui me ngā kara­ipi i tētahi tini­hanga e mau ai ia, e whaka­matea ai. ");
INSERT INTO mri_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","I mea hoki rātou, “Kauaka i te hākari, kei nga­ngau te iwi.” ");
INSERT INTO mri_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ā, i a ia i Petani i te whare o Haimona repera, i a ia anō e noho ana ka haere mai tētahi wahine me tētahi pouaka kōhatu, kī tonu i te hinu kakara, he tino nara, he mea utu nui; ā, wāhia ana e ia te pouaka kōhatu, ringi­hia ana ki tōna māte­nga. ");
INSERT INTO mri_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","I riri anō ētahi i roto i a rātou, i mea, “Hei aha tēnei mau­mau o te hinu kakara? ");
INSERT INTO mri_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Maha atu hoki i te toru rau ngā pene te utu me i hokona tēnei hinu, nā, ka hoatu ki te hunga rawa­kore.” Nā, ka amu­amu rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ka mea atu a Īhu, “Waiho atu ū āna! He aha tā koutou e whaka­pā­wera­wera nā i a ia? He mahi pai tāna i mea nei ki ahau. ");
INSERT INTO mri_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kei a koutou tonu hoki te hunga rawa­kore i ngā wā katoa, hei ata­whai­tanga hoki rātou mā koutou i ngā wā e pai ai koutou; e kore ia ahau e noho tonu ki a koutou. ");
INSERT INTO mri_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kua mahia e ia te mea e taea e ia; kua whaka­wahia e ia i mua nei tōku tinana mō te tanu­manga. ");
INSERT INTO mri_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","He pono tāku e mea nei ki a koutou, Ko ngā wāhi katoa o te ao e kauwhau­tia ai tēnei rongo­pai, ka kōrero­tia anō tā tēnei wahine i mea ai, hei whaka­mahara ki a ia.” ");
INSERT INTO mri_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nā, ka haere a Hūrā Ikariote, tētahi o te tekau mā rua, ki ngā tohu­nga nui, ki te tuku i a ia ki a rātou. ");
INSERT INTO mri_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ā, nō ka rongo rātou, ka hari, ka whaka­ae kia hoatu he moni māna. Nā, ka rapu ia ki te wā pai e tukua ai ia. ");
INSERT INTO mri_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ā, i te rā tua­tahi o te Taro Rēwenakore, i te wā e patua ai te Kape­nga, ka mea āna ākonga ki a ia, “Ko hea koe pai ai kia haere mātou ki te taka, kia kai ai koe i te Kape­nga?” ");
INSERT INTO mri_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nā, ka tonoa e ia toko­rua o āna ākonga, ka mea ki a rāua, “Haere ki te pā, ā, ka tūtaki mai ki a kōrua he tangata e mau ana i te tahā wai. Haere i muri i a ia. ");
INSERT INTO mri_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ā, ka mea ki te tangata o te whare e tomo ai ia, ‘E mea ana te Kai­whaka­ako, “Kei hea te rūma e kai ai mātou ko āku ākonga i te Kape­nga?” ’ ");
INSERT INTO mri_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ā, māna tonu e whaka­atu ki a kōrua he rūma nui i runga, oti rawa te whā­riki, te whaka­pai. Hei reira taka ai mā tātou.” ");
INSERT INTO mri_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nā, haere ana āna ākonga, ā, nō te taenga ki te pā, ka kite i tāna i kōrero ai ki a rāua; ā, takā ana e rāua te Kape­nga. ");
INSERT INTO mri_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ā, nō ka ahi­ahi, ka haere atu ia me te tekau mā rua. ");
INSERT INTO mri_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","I a rātou e noho ana, e kai ana, ka mea a Īhu, “He pono tāku e mea nei ki a koutou, Ko tētahi o koutou, kei tōku taha nei e kai ana, māna ahau e tuku.” ");
INSERT INTO mri_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nā, ka pā te pōuri ki a rātou, ka kī taki­tahi ki a ia, “Ko ahau koia?” ");
INSERT INTO mri_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nā, ka mea ia ki a rātou, “Ko tētahi o te tekau mā rua, ko ia e tou­tou tahi nei māua ki te rīhi. ");
INSERT INTO mri_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","E haere ana te Tama a te tangata, e pērā ana me te mea i tuhi­tuhia mōna; otiia, auē te mate mō te tangata e tukua ai te Tama a te tangata! He mea pai kē mō taua tangata me i kaua ia e whānau.” ");
INSERT INTO mri_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ā, i a rātou e kai ana, ka mau ia ki te taro, ā, ka mutu te whaka­pai, ka whawhati, nā, ka hoatu ki a rātou, ka mea, “Tango­hia, kainga: ko tōku tinana tēnei.” ");
INSERT INTO mri_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nā, ka mau ia ki te kapu, ā, ka mutu te whaka­whetai, ka hoatu ki a rātou; ā, ka inumia e rātou katoa. ");
INSERT INTO mri_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ā, ka mea ia ki a rātou, “Ko ōku toto ēnei, ko ō te kawe­nata hou, e whaka­hekea ana mō te tini. ");
INSERT INTO mri_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","He pono tāku e mea nei ki a koutou, E kore ahau e inu atu anō i te hua o te wāina, kia taea rā anō taua rā e inumia houtia ai e ahau i te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ā, nō ka mutu tā rātou hīmene, ka haere rātou ki Maunga Ōriwa. ");
INSERT INTO mri_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kātahi a Īhu ka mea ki a rātou, “Ko koutou katoa nā ka hē. Kua oti hoki te tuhi­tuhi, ‘Ka patua e ahau te hēpara, ā, ko ngā hipi ka whaka­marara­tia.’ ");
INSERT INTO mri_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Otirā, muri iho i tōku aranga, ka haere ahau i mua i a koutou ki Kariri.” ");
INSERT INTO mri_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nā, ka mea a Pita ki a ia, “Ahakoa hē te katoa, ko ahau e kore!” ");
INSERT INTO mri_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ā, ka mea a Īhu ki a ia, “He pono tāku e mea nei ki a koe, ko ākua­nei, i tēnei pō anō, i te mea kāhore anō kia rua ngā tangi­hanga o te tī­kao­kao, ka toru āu whaka­kore­nga i ahau.” ");
INSERT INTO mri_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kātahi, ka tino ārita rawa tāna mea­tanga atu, “Ahakoa kua takoto te tikanga kia mate tahi au me koe, e kore ahau e whaka­kāhore i a koe.” I pērā anō te kōrero a rātou katoa. ");
INSERT INTO mri_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ā, ka tae rātou ki tētahi wāhi, e huaina ana ko Kehemane. Nā, ka mea atu ia ki āna ākonga, “Hei konei koutou noho ai, kia īnoi ahau.” ");
INSERT INTO mri_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nā, ka mau ia ki a Pita rātou ko Hēmi, ko Hoani, ā, ka tīmata te koera, te tū­mata­te­nga; ");
INSERT INTO mri_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nā, ka mea ia ki a rātou, “Kei te tino pēhia tōku wairua e te pōuri, tata pū ki te mate; noho iho koutou i konei, kia mata­ara.” ");
INSERT INTO mri_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nā, ka haere ia ki pahaki tata atu, ka hinga ki te whenua, ka īnoi, me kāhore e āhei kia pahemo atu tēnei hāora i a ia. ");
INSERT INTO mri_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ā, ka mea ia, “E Apa, e Pā, ka taea e koe ngā mea katoa; tango­hia atu tēnei kapu i ahau. Otiia, kaua e waiho i tāku e pai ai, engari, i tāu.” ");
INSERT INTO mri_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nā, ka haere ia, ka roko­hanga atu e moe ana rātou, ā, ka mea ia ki a Pita, “E Haimona, kei te moe ia koe? E kore rānei e taea e koe te mata­ara kia kotahi hāora? ");
INSERT INTO mri_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kia mata­ara, me te īnoi, kei uru koutou ki te whaka­mā­tautau­ranga. Kei te hihiko te wairua, ko te kiko­kiko ia kei te ngoi­kore.” ");
INSERT INTO mri_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nā, ka haere atu anō ia, ka īnoi, me te whaka­hua i aua kupu anō. ");
INSERT INTO mri_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nā, ka hoki mai anō ia, ka roko­hanga e moe ana rātou, he nui hoki te tai­maha o ō rātou kanohi; ā, kīhai rātou i mātau ki tā rātou e whaka­hoki ai ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nā, haere ana anō ia, ko te toru o ngā haere­nga, ka mea ki a rātou, “E moe rā, whaka­tā i a koutou? Heoi rā, kua taea te hāora; nā, ka tukua te Tama a te tangata ki ngā ringa o te hunga hara. ");
INSERT INTO mri_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ma­ranga, ka haere tātou; nā, ka tata te kai­tuku i ahau.” ");
INSERT INTO mri_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nā, ina­mata, i a ia tonu e kōrero ana, kua puta a Hūrā, tētahi o te tekau mā rua, me te tini o te tangata, me ngā hoari, me ngā patu, i ahu mai i ngā tohu­nga nui, i ngā kara­ipi, i ngā kaumātua. ");
INSERT INTO mri_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nā, kua oti tētahi tohu te whaka­rite ki a rātou e tōna kai­tuku; i mea ia, “Ko tāku tangata e kihi ai, ko ia tērā; hopu­kina, kia mau te ārahi atu.” ");
INSERT INTO mri_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nā, i tōna taenga mai, tika tonu ki a ia, ka mea, “E Rapi!” ā, kihi ana i a ia. ");
INSERT INTO mri_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nā, ka mau ō rātou ringa ki a ia, ā, hopu­kina ana ia. ");
INSERT INTO mri_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nā, ka unuhia e tētahi o te hunga e tū ana i reira tāna hoari, hāua iho e ia te pono­nga a te tohu­nga nui, poroa ana tōna tari­nga. ");
INSERT INTO mri_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “He tāhae ahau, i haere mai ai koutou me ngā hoari, me ngā patu, ki te hopu i ahau? ");
INSERT INTO mri_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","I a koutou ahau e whaka­ako ana i te teme­para i tēnā rā, i tēnā rā, ā, kīhai koutou i hopu i ahau. Otirā, i mahia tēnei mea kia rite ai ngā karaipi­ture.” ");
INSERT INTO mri_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nā, whaka­rere ana rātou katoa i a ia, oma ana. ");
INSERT INTO mri_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nā, tērā tētahi tai­tama­riki i aru tahi mai me ia, takaia ai he kākahu rīnena ki runga ake i tōna kiri­kau. Nā, ka hopu­kina ia e rātou, ");
INSERT INTO mri_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","otirā, i whaka­rērea atu e ia te kākahu rīnena, ā, oma ta­ha­nga atu ana. ");
INSERT INTO mri_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nā, ka āra­hina atu e rātou a Īhu ki te tino tohu­nga, ā, ka hui­hui mai ki a ia ngā tohu­nga nui katoa, ngā kaumātua me ngā kara­ipi. ");
INSERT INTO mri_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nā, tērā a Pita te aru rā i a ia i tawhiti, tae noa ki roto, ki te marae o te tino tohu­nga; ā, tērā te noho rā me ngā kai­mahi, pā­ina­ina ai i a ia i te taha o te ahi. ");
INSERT INTO mri_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nā, i rapu ngā tohu­nga nui me te rū­nanga katoa i te kōrero mō Īhu, e whaka­matea ai; heoi, kīhai i kitea. ");
INSERT INTO mri_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","He toko­maha hoki ngā kai­whaka­pae teka mōna, otiia, kīhai i rite ā rātou kōrero. ");
INSERT INTO mri_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nā, ka whaka­tika ētahi, ka whaka­pae teka ki a ia, ka mea, ");
INSERT INTO mri_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“I rongo mātou ki a ia e mea ana, ‘Māku e whaka­horo tēnei whare tapu i hangā nei e te ringa, ā, kia toru ngā rā ka hangā e ahau tētahi atu, ehara i te ringa i mahi.’ ” ");
INSERT INTO mri_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ā, ahakoa tērā kīhai ā rātou kōrero i rite­rite. ");
INSERT INTO mri_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nā, ka whaka­tika te tohu­nga nui i waenga­nui, ka ui ki a Īhu, ka mea, “Kāhore āu kupu? He aha tā ēnei e whaka­atu nei mōu?” ");
INSERT INTO mri_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Heoi, kīhai ia i kuihi, kāhore hoki he kupu i whaka­hokia e ia. Nā, ka ui anō te tino tohu­nga ka mea ki a ia, “Ko koe rānei a te Karaiti, te Tama a tērā e Whaka­pai­ngia nei?” ");
INSERT INTO mri_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ka mea a Īhu ki a ia, “Ko ahau ia, ā, tērā koutou e kite i te Tama a te tangata e noho ana i te ringa matau o te kaha, e haere mai ana me ngā kapua o te rangi.” ");
INSERT INTO mri_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kātahi, ka hae­hae te tino tohu­nga i ōna kākahu, ka mea, “Hei aha atu mā tātou ētahi kai­whaka­atu anō? ");
INSERT INTO mri_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kua rongo koutou ki te kohu­kohu. E pēhea ana ō koutou whaka­aro?” Nā, ka whaka­ae rātou katoa ka tika te mate mōna. ");
INSERT INTO mri_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kātahi, ka anga ētahi, ka tuwha ki a ia, ka ārai i tōna kanohi, ka kuru i a ia, ā, ka mea ki a ia, “Poro­piti mai!” Ā, ka paki­pakia ia e ngā kai­mahi ki ō rātou ringa. ");
INSERT INTO mri_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ā, i a Pita i te marae i raro, ka haere mai tētahi o ngā kōtiro a te tino tohu­nga. ");
INSERT INTO mri_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ā, i tōna kite­nga i a Pita e pā­ina­ina ana, ka ti­tiro atu ki a ia, ā, ka mea, “Ko koe anō tētahi i te tangata o Nahareta, arā i a Īhu.” ");
INSERT INTO mri_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Otirā, ka whaka­kāhore ia, ka mea, “Kāhore rawa ahau i mātau, i mārama rānei ki tāu e kōrero mai nā.” Nā, ka puta atu ia ki te whaka­mahau, ā, ka tangi te tī­kao­kao. ");
INSERT INTO mri_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ā, ka kite te kōtiro i a ia, ka anga anō, ka kōrero ki te hunga e tū tata ana, “Nō rātou hoki tēnei.” ");
INSERT INTO mri_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Otirā, ka whaka­kāhore anō ia. Ā muri tata iho ka kōrero anō ki a Pita te hunga e tū tata ana, “He pono ko koe tētahi o rātou; nō Kariri hoki koe.” ");
INSERT INTO mri_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kātahi ia ka tīmata te kanga, te oati, “Kāhore ahau e mātau ki tēnā tangata e kōrero nā koutou.” ");
INSERT INTO mri_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I reira ka tangi anō te tī­kao­kao, ko te tuarua o ngā tangi­hanga. Nā, ka mahara a Pita ki te kupu i kōrero ai a Īhu ki a ia, “E kore e tuarua te tangi o te tī­kao­kao, ka toru āu whaka­kāhore­tanga i ahau.” Ā, ka whaka­aroa iho e ia, nā, ka tangi. ");
INSERT INTO mri_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ā, mea kau ake te ata, ka rū­nanga ngā tohu­nga nui, ngā kaumātua, ngā kara­ipi, me te rū­nanga katoa, ā, ka herea e rātou a Īhu, ka āra­hina atu, ā, tukua atu ana ki a Pirato. ");
INSERT INTO mri_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ka ui a Pirato ki a ia, “Ko koe rānei te Kīngi o ngā Hūrai?” Ka whaka­hokia e ia ki a ia, “Kua kōrero­tia nā e koe.” ");
INSERT INTO mri_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","He maha hoki ngā mea i whaka­paea ki a ia e ngā tohu­nga nui. ");
INSERT INTO mri_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ka ui anō a Pirato ki a ia, ka mea, “Kāhore āu kupu whaka­hoki? Nā, te tini o ngā kupu e kōrero nei rātou mōu.” ");
INSERT INTO mri_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Heoi, kāhore a Īhu i whaka­hoki atu anō; nō, ka mīharo a Pirato. ");
INSERT INTO mri_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nā, i taua hākari kotahi te here­here e tukua ana e ia ki a rātou, ko tā rātou e īnoi ai. ");
INSERT INTO mri_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nā, i reira tētahi tangata ko Parapa te ingoa, e here tahi ana me ōna hoa tutū, he hunga i patu tangata i te nga­ngare­tanga. ");
INSERT INTO mri_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nā, ka haere te mano, ka anga, ka tono ki a ia kia pērā­tia me tāna i mea ai ki a rātou i mua. ");
INSERT INTO mri_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nā, ka whaka­hoki a Pirato ki a rātou, ka mea, “E pai ana rānei koutou kia tukua e ahau ki a koutou te Kīngi o ngā Hūrai?” ");
INSERT INTO mri_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I mahara hoki ia he hae i tukua ai ia e ngā tohu­nga nui. ");
INSERT INTO mri_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Otirā, ka whaka­tūtehu­tia e rātou te mano, kia tukua e ia ko Parapa kē ki a rātou. ");
INSERT INTO mri_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nā, ka whaka­hoki anō a Pirato, ka mea ki a rātou, “He aha oti tā koutou e pai ai kia meatia e ahau ki tēnei e huaina nei e koutou ko te Kīngi o ngā Hūrai?” ");
INSERT INTO mri_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka karanga anō rātou, “Rīpekatia!” ");
INSERT INTO mri_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nā, ka mea a Pirato ki a rātou, “He aha koia tāna kino i mea ai?” Heoi, nui noa atu tā rātou hāmama, “Rīpekatia ia!” ");
INSERT INTO mri_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nā, i tōna hia­hia kia whaka­mārie­tia te mano, tukua ana e Pirato a Parapa ki a rātou, ā, ka oti a Īhu te whiu, ka tukua kia rīpeka­tia. ");
INSERT INTO mri_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nā, ka āra­hina ia e ngā hōia ki te marae, arā, ki te whare whaka­wā, ā, kāranga­ranga­tia ana te rōpū katoa. ");
INSERT INTO mri_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ka whaka­kākahu­ria ia ki te kākahu pāpura, ā, ka oti tētahi karauna tā­tarā­moa te whiri, ka pōtaea ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nā, ka anga rātou, ka oha ki a ia, “Tēnā koe, e te Kīngi o ngā Hūrai!” ");
INSERT INTO mri_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Patua ana e rātou tōna māte­nga ki te kākaho, tuwha ana ki a ia, ka tuku i ngā turi ki a ia, ā, koro­piko ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ā, nō ka mutu tā rātou taunu ki a ia, ka tango­hia te kahu pāpura i a ia, nā, whaka­kākahu­ria ana ia ki ōna ake kākahu, ā, āra­hina ana ia kia rīpeka­tia. ");
INSERT INTO mri_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nā, ka meinga e rātou tētahi tangata e tika ana nā reira, a Haimona o Hairini, i ahu mai i ngā whenua, ko te pāpā o Arēhanera rāua ko Rupuha, kia haere me rātou, kia riro ai māna e amo tōna rīpeka. ");
INSERT INTO mri_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nā, ka āra­hina ia ki tētahi wāhi, ki Korokota, tōna tikanga ina, whaka­māori­tia “Ko te Wāhi Anga­anga.” ");
INSERT INTO mri_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ā, hoatu ana ki a ia he wāina, he mea whaka­nanu ki te maira, kia inumia; otirā, kīhai i tango­hia e ia. ");
INSERT INTO mri_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ā, rīpeka­tia ana ia e rātou, ka wehe­wehea ōna kākahu, he mea maka ki te rota, kia kitea ai ko te aha e riro i tētahi, i tētahi. ");
INSERT INTO mri_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nā, ko te toru tērā o ngā hāora, ā, ka rīpeka­tia ia e rātou. ");
INSERT INTO mri_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ko te mea i whaka­wā­kia ai ia i tuhi­tuhia ki runga, “Ko te Kīngi o ngā Hūrai.” ");
INSERT INTO mri_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nā, toko­rua ngā tāhae i rīpeka­tia ngā­tahi­tia me ia; ko tētahi ki matau, ko tētahi ki tōna mauī. ");
INSERT INTO mri_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nā, ka rite te karaipi­ture e mea nei, “I tāua ngā­tahi­tia ia me te hunga hara.” ");
INSERT INTO mri_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ko te hunga e hāere­ere ana i reira ka tāwai ki a ia, ka rūrū i ō rātou māte­nga, ka mea, “Ha, ko koe ka whaka­horo nei i te whare tapu, ka hangā nei anō i ngā rā e toru! ");
INSERT INTO mri_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Whaka­ora i a koe anō, ka heke iho i te rīpeka!” ");
INSERT INTO mri_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wai­hoki ko ngā tohu­nga nui ka tāwai i a ia, rātou ko ngā kara­ipi, ka mea, “Ko ērā atu i whaka­ora­ngia e ia, tē taea e ia te whaka­ora a ia ake anō! ");
INSERT INTO mri_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tēnā rā, kia heke iho āia­nei a te Karaiti, te Kīngi o Īharaira, i te rīpeka, kia kite ai tātou, kia whaka­pono ai.” I tāwai hoki ki a ia te hunga i rīpeka­tia ngā­tahi­tia me ia. ");
INSERT INTO mri_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ā, nō ka tae ki te ono o ngā hāora, ka pōuri a runga o te whenua katoa, taea noatia te iwa o ngā hāora. ");
INSERT INTO mri_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ā, i te iwa o ngā hāora ka karanga a Īhu, he nui te reo, ka mea, “Eroi, Eroi, rama hapaka­tani?” Ko te tikanga tēnei ina whaka­māori­tia, “E tōku Atua, e tōku Atua, he aha koe i whaka­rere ai i ahau?” ");
INSERT INTO mri_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ā, nō te rongo­nga o ētahi o te hunga e tū ana i reira, ka mea, “Nana, e karanga ana ia i a Irāia.” ");
INSERT INTO mri_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nā, ka oma tētahi, ka whaka­kī i tētahi hau­tai ki te winika, whaka­noho­ia ana ki te kākaho, ka hoatu kia inumia e ia, ka mea, “Kāti; tēnā kia kite tātou me kore a Irāia e haere mai ki te tango i a ia ki raro.” ");
INSERT INTO mri_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nā, he nui te reo i puaki i a Īhu, ā, hemo ake. ");
INSERT INTO mri_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ā, ka wāhia te ārai o te teme­para i waenga­nui pū mai i runga ki raro. ");
INSERT INTO mri_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ā, nō te kite­nga o te kene­turio, e tū hāngai atu ana ki a ia, i pērā te āhua o tāna tuku­nga i tōna wairua, ka mea ia, “He pono ko te Tama a te Atua tēnei tangata.” ");
INSERT INTO mri_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nā, i reira ētahi wāhine e mā­taki­taki ana mai i tawhiti; i roto i a rātou a Meri Makarini, a Meri hoki whaea o Hēmi, te mea iti, rāua ko Hohi, me Hāromi; ");
INSERT INTO mri_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","arā, ko ngā wāhine i aru nei i a ia, i a ia i Kariri, i mahi mea nei māna; me ētahi atu wāhine toko­maha i haere tahi mai nei me ia ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nā, ka ahi­ahi, i te mea ko te rā Taka­nga, arā, ko te rā i mua ake o te hāpati. ");
INSERT INTO mri_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ka haere mai a Hōhepa o Arimatia, he ranga­tira rū­nanga, he tangata nui tonu, e tatari ana anō hoki ia ki te ranga­tira­tanga o te Atua; ā, ka haere māia tonu ki a Pirato, ka īnoi i te tinana o Īhu. ");
INSERT INTO mri_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nā, ka mīharo a Pirato, hua noa kāhore anō i mate; ka karanga­tia e ia te kene­turio, ka ui ki a ia, me­he­mea kua mate atu rā ia. ");
INSERT INTO mri_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ā, nō ka rongo ki te kene­turio kua mate, ka whaka­ae­tia e ia te tinana ki a Hōhepa. ");
INSERT INTO mri_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nā, ka hokona e tērā he rīnena, ka tango­hia mai ia ki raro, ā, takaia ana ki te rīnena; whaka­takoto­ria ana ia ki roto ki te urupā kua hāua atu ki te kāmaka, ā, whaka­takā atu ana he kōhatu ki te kūwaha o te urupā. ");
INSERT INTO mri_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","I kite a Meri Makarini, rāua ko Meri whaea o Hohi, i te wāhi i whaka­takoto­ria ai ia. ");
INSERT INTO mri_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ā, nō te pahemo­tanga o te hāpati, ka hokona he mea kakara e Meri Makarini, e Meri whaea o Hēmi, e Hāromi, kia haere ai rātou ki te whaka­wahi i a ia. ");
INSERT INTO mri_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nā, i te atatū o te rā tua­tahi o te wiki, ka haere rātou ki te urupā i te pu­tanga mai o te rā; ");
INSERT INTO mri_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ka kōrero­rero ki a rātou anō, “Ko wai rā hei whaka­taka mā tātou i te kōhatu i te kūwaha o te urupā?” ");
INSERT INTO mri_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ā, i tā rātou tiro­hanga ake, ka kite kua huri­hia atu te kōhatu; he mea nui whaka­hara­hara hoki. ");
INSERT INTO mri_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ā, nō ka tomo rātou ki te urupā, ka kite rātou i tētahi tai­tama­riki e noho ana i te taha matau, he kākahu mā tōna; nā, ka koera rātou. ");
INSERT INTO mri_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ā, ka mea ia ki a rātou, “Kaua e koera! E rapu ana koutou i a Īhu o Nahareta i rīpeka­tia. Kua ara ia; kāhore ia i konei. Tēnā! ti­tiro ki te wāhi i whaka­takoto­ria ai ia! ");
INSERT INTO mri_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Engari haere, kōrero­tia atu ki āna ākonga, ki a Pita hoki, kei te haere ia i mua i a koutou ki Kariri. Ko reira koutou kite ai i a ia, pērā i tāna i mea ai ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nā, ka puta atu rātou, ā, oma ana i te urupā; kua tae mai hoki te tūiri, te koera ki a rātou. Kīhai rawa i kōrero ki tētahi tangata; nō te mea i wehi rātou. ");
INSERT INTO mri_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nā, i tōna aranga ake i te atatū o te rā tua­tahi o te wiki, ka whaka­kite tua­tahi ia ki a Meri Makarini, i peia nei e ia e whitu ngā rēwera i roto i a ia. ");
INSERT INTO mri_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nā, ka haere tērā ka kōrero ki te hunga i piri rā ki a ia i mua, i a rātou e pōuri ana, e tangi ana. ");
INSERT INTO mri_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ā, ko rātou, i tō rātou rongo­nga kei te ora ia, ā, kua kitea e ia, kāhore i whaka­pono. ");
INSERT INTO mri_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nā, i muri iho i ēnei mea, ka puta ia, he āhua kē tōna, ki ētahi atu o rātou, toko­rua, i a rāua e haere ana, e anga ana ki ngā whenua. ");
INSERT INTO mri_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nā, ka haere hoki ēnā ka kōrero ki ētahi atu o rātou; otirā kāhore ērā i whaka­pono. ");
INSERT INTO mri_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muri iho ka puta ia ki te tekau mā tahi, i a rātou e noho ana ki te kai, ā, rīria iho e ia tō rātou whaka­pono kore, me te pakeke o te ngākau, mō rātou kīhai i whaka­pono ki te hunga i kite nei i a ia kua ara. ");
INSERT INTO mri_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ka mea ki a rātou, “Haere koutou ki te ao katoa, kauwhau­tia te rongo­pai ki ngā tāngata katoa. ");
INSERT INTO mri_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ko ia e whaka­pono ana, ka oti te iri­iri, ka whaka­ora­ngia; otirā, ko te tangata e kore e whaka­pono, ka whaka­taua te hē ki a ia. ");
INSERT INTO mri_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ka whai tahi hoki ēnei tohu i te hunga e whaka­pono ana. Mā tōku ingoa rātou ka pei rēwera ai; ka kōrero­tia ai e rātou ngā reo hou; ");
INSERT INTO mri_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ka tango ake ai rātou i ngā nākahi; ā, ki te inu i tētahi mea whaka­mate, e kore rātou e ahatia; ka pā ō rātou ringa ki ngā tūroro, ā, ka ora.” ");
INSERT INTO mri_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nā, i te mutu­nga o tāna kōrero ki a rātou, ka tango­hia atu te Ariki a Īhu ki te rangi, ā, noho ana ki te ringa matau o te Atua. ");
INSERT INTO mri_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nā, haere ana rātou, kauwhau ana i ngā wāhi katoa, me te mahi tahi anō te Ariki me rātou, me te whakaū i te kupu ki ngā tohu e whai ana i muri. Āmine.");
INSERT INTO mri_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nā, i te mea he toko­maha kua anga ki te whaka­kaupapa i te kōrero o ngā mea kua whaka­tutuki­tia nei i waenga­nui i a tātou. ");
INSERT INTO mri_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","He mea whaka­rite ki ngā mea i hōmai ki a tātou e te hunga i kite ā-kanohi, i mahi hoki i te kupu. ");
INSERT INTO mri_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Koia ahau i mahara ai, i te mea kua āta whaka­takina iho e ahau ngā mea katoa i te tīma­tanga mai, kia tuhi­tuhi whaka­tepe atu ki a koe, e Tiopira, e te tangata pai rawa, ");
INSERT INTO mri_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kia mātau ai koe ki te tūturu­tanga o ngā mea i whaka­akona ai koe. ");
INSERT INTO mri_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nō mua, nō ngā rā o Herora kīngi o Hūria, tērā tohu­nga, ko Hakaraia te ingoa, nō te wiki o Apia. Ko tāna wahine hoki nō ngā tamā­hine a Ārona, ko Erihāpeti tōna ingoa. ");
INSERT INTO mri_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","He hunga tika hoki rāua i te aro­aro o te Atua, kāhore he hē o tā rāua haere i runga i ngā kupu ako katoa, i ngā tikanga a te Ariki. ");
INSERT INTO mri_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nā, kāhore ā rāua tama­riki, he pākoko hoki a Erihāpeti, ā, i taua wā kua maha haere rawa ngā rā o tētahi, o tētahi. ");
INSERT INTO mri_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nā, tūpono tonu, i a ia e mahi ana i ā te tohu­nga mahi i te aro­aro o te Atua i te taka­nga o tāna wiki, ");
INSERT INTO mri_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","e whaka­rite ana i ngā rite­nga a ngā tohu­nga, ka taka māna te haere ki roto ki te whare tapu o te Ariki, tahu ai i te whaka­kakara. ");
INSERT INTO mri_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nā, i waho te nuinga katoa o te iwi e īnoi ana i te hāora whaka­kakara. ");
INSERT INTO mri_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ā, ka puta mai ki a ia tētahi ana­hera a te Ariki e tū ana i te taha matau o te āta whaka­kakara. ");
INSERT INTO mri_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nā, ka oho­rere a Hakaraia i tōna kite­nga i a ia, ā, tau ana te wehi ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Otirā, ka mea te ana­hera ki a ia, “Kaua e wehi, e Hakaraia. Kua rangona hoki tāu īnoi, ā, ka whānau i tāu wahine, i a Erihāpeti, he tama māu, ā, ka huaina e koe tōna ingoa ko Hoani. ");
INSERT INTO mri_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ā, ka whi­whi koe i te hari me te hara­koa; ā, he toko­maha hoki e hari i tōna whānau­tanga. ");
INSERT INTO mri_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","E nui hoki ia i te aro­aro o te Atua. E kore ia e inu i te wāina, i te wai whaka­hau­rangi rānei; ā, ka kī ia i te Wairua Tapu, mai anō o te kōpū o tōna whaea. ");
INSERT INTO mri_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","He toko­maha anō hoki o ngā tama a Īharaira ka whaka­tahuri­tia e ia ki te Ariki, ki tō rātou Atua. ");
INSERT INTO mri_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ka haere anō ia i tōna aro­aro i runga i te wairua, i te mana, o Irāia, hei whaka­tahuri i ngā ngākau o ngā mātua ki ngā tama­riki, i te hunga whaka­tuturi ki ngā whaka­aro o te hunga tika; hei whaka­rite mō te Ariki i tētahi iwi i āta takā mōna.” ");
INSERT INTO mri_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nā, ko te mea­tanga a Hakaraia ki te ana­hera, “Mā te aha ka mātau ai ahau ki tēnei mea? He koro­heke nei hoki ahau, kua maha haere hoki ngā rā o tāku wahine.” ");
INSERT INTO mri_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nā, ka whaka­hoki te ana­hera, ka mea ki a ia, “Ko Kapariera ahau, kei te aro­aro o te Atua tōku tū­ranga; kua tonoa mai hoki ahau ki te kōrero ki a koe ki te whaka­puaki i tēnei rongo pai ki a koe. ");
INSERT INTO mri_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nana, ka noho puku koe, kāhore hoki e puta te kōrero i a koe, kia tae mai rā anō te rā e meatia ai ēnei mea, mōu kīhai i whaka­pono ki āku kupu, ka mana nei i te wā e rite ai.” ");
INSERT INTO mri_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ā, tatari tonu te iwi ki a Hakaraia, me te mīharo anō i a ia e whaka­roa ana i roto i te whare tapu. ");
INSERT INTO mri_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ā, i tōna pu­tanga mai ki waho, kīhai ia i āhei te kōrero ki a rātou; ā, ka mōhio rātou kua kite ia i tētahi pu­tanga atua ki a ia i roto i te whare tapu. Hono tonu tāna wai­tohu ki a rātou me te wa­hangū anō. ");
INSERT INTO mri_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ā, ka rite ngā rā hei minita­tanga māna, ka hoki ia ki tōna whare. ");
INSERT INTO mri_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nā, muri iho i aua rā ka hapū tāna wahine, a Erihāpeti, ā, e rima ngā marama i whaka­ngaro ai i a ia, ā, i mea ia, ");
INSERT INTO mri_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ko tā te Ariki tēnei i mea ai ki ahau, i ngā rā i ti­tiro mai ai ia, ki te whaka­mutu i tōku tāwai­nga i roto i ngā tāngata.” ");
INSERT INTO mri_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nā, i te ono o ngā marama ka tonoa a Kapariera, te ana­hera, e te Atua ki tētahi pā o Kariri, ko Nahareta te ingoa, ");
INSERT INTO mri_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ki tētahi wāhina i tau­mau­tia mā tētahi tangata, ko Hōhepa te ingoa, nō te whare o Rāwiri; ko te ingoa o te wāhina ko Meri. ");
INSERT INTO mri_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nā, ko tōna haere­nga ki roto, ki a ia, ka mea, “Tēnā koe, e te wahine kua manako­hia nei; kei a koe te Ariki, ko koe te manaaki­tia i roto i ngā wāhine.” ");
INSERT INTO mri_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Otirā he nui tōna oho ki taua kupu, ka whaka­aro­aro ki te tikanga o tēnei oha­tanga. ");
INSERT INTO mri_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nā, ka mea te ana­hera ki a ia, “Kei wehi koe, e Meri; kua pai­ngia hoki koe e te Atua. ");
INSERT INTO mri_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nana, tērā koe e hapū, ka whānau he tama, ā, ka huaina e koe tōna ingoa ko Īhu. ");
INSERT INTO mri_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ka nui ia, ka kīa hoki ko te Tama a te Runga Rawa; ā, ka hoatu ki a ia e te Ariki, e te Atua, te torōna o Rāwiri, o tōna pāpā. ");
INSERT INTO mri_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hei kīngi hoki ia mō te whare o Hākopa ake ake; e kore anō e mutu tōna ranga­tira­tanga.” ");
INSERT INTO mri_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nā, ka mea a Meri ki te ana­hera, “E pēhea­tia tēnei, kāhore nei hoki ahau e mōhio ki te tāne?” ");
INSERT INTO mri_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nā, ka whaka­hoki te ana­hera, ka mea ki a ia, “Ka tae te Wairua Tapu ki runga ki a koe, ka tau­maru­maru iho te kaha o te Runga Rawa ki runga ki a koe; nō reira hoki ka kīa te mea e whānau mai he tapu, ko te Tama a te Atua. ");
INSERT INTO mri_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nā, ko tōu whanau­nga, ko Erihāpeti, kua hapū hoki ia i tōna rūruhi­tanga, he tama; ā, ko te ono tēnei o ngā marama ki a ia, i kīa rā he pākoko. ");
INSERT INTO mri_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kāhore hoki he kupu i ahu mai i te Atua i kore e whai mana!” ");
INSERT INTO mri_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Anō rā ko Meri, “Inā, te pono­nga a te Ariki; kia pērā­tia ahau me tāu i kōrero ai.” Ā, mawehe atu ana te ana­hera i a ia. ");
INSERT INTO mri_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nā, ka whaka­tika a Meri i aua rā, ā, haere kaikā ana ki te whenua puke­puke ki tētahi pā o Hūrā; ");
INSERT INTO mri_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ā, ka tomo ki te whare o Hakaraia, ka oha ki a Erihāpeti. ");
INSERT INTO mri_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ā, nō te rongo­nga o Erihāpeti, i te oha a Meri, ka koiri te tama­iti i roto i tōna kōpū; nā, kua kī a Erihāpeti i te Wairua Tapu. ");
INSERT INTO mri_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ā, he nui tōna reo ki te karanga, ka mea, “Ka manaaki­tia koe i roto i ngā wāhine, ka manaaki­tia anō te hua o tōu kōpū. ");
INSERT INTO mri_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nō hea hoki tēnei ki ahau, kia haere mai te whaea o tōku Ariki ki ahau? ");
INSERT INTO mri_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nā, pā kau mai te reo o tāu oha ki ōku tari­nga, ka oho te tama­iti i tōku kōpū i te hari. ");
INSERT INTO mri_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ka koa anō ia e whaka­pono ana, ka whaka­ritea hoki ngā mea i kōrero­tia ki a ia e te Ariki.” ");
INSERT INTO mri_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ā, ka mea a Meri, “Ka whaka­nui tōku wairua i te Ariki; ");
INSERT INTO mri_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","e hari ana tōku wairua ki te Atua, ki tōku Kai­whaka­ora; ");
INSERT INTO mri_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mōna i ti­tiro ki te iti o tāna pono­nga; tā te mea hoki kātahi ahau ka kīa e ngā whaka­tupu­ranga katoa e haere ake nei, he wahine hari. ");
INSERT INTO mri_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","He nui hoki ngā mahi a te Mea Kaha ki ahau. He tapu hoki tōna ingoa; ");
INSERT INTO mri_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","he mahi tohu tāna ki te hunga e wehi ana ki a ia, ki tēnei whaka­tupu­ranga, ki tēnei whaka­tupu­ranga. ");
INSERT INTO mri_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kua whaka­puta­ina he kaha e ia, arā e tōna ringa; nāna te hunga whaka­kake i marara ai, i te whaka­aro o ō rātou ngākau. ");
INSERT INTO mri_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kua whaka­takā e ia ngā piriniha i ō rātou torōna, ā, whaka­tei­tei­tia ake ana te hunga iti. ");
INSERT INTO mri_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kua whaka­kīa e ia te hunga mate hia­kai ki ngā mea pai; kua tonoa kautia atu te hunga taonga. ");
INSERT INTO mri_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kua tau­tokona e ia a Īharaira, tāna pono­nga, he whaka­mahara hoki ki tāna mahi tohu. ");
INSERT INTO mri_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ki a Āperahama rātou ko tāna whānau ake tonu atu, pērā hoki me tāna i kōrero ai ki ō tātou mātua.” ");
INSERT INTO mri_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nā, tata tonu ki te toru marama a Meri e noho ana ki a ia, ā, hoki ana ki tōna whare. ");
INSERT INTO mri_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ā, ka rite te tāima o Erihāpeti, e whānau ai; nā, ka whānau he tama. ");
INSERT INTO mri_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ā, ka rongo te hunga e noho tata ana, me ōna whanau­nga, kua whaka­nuia e te Ariki tōna aroha ki a ia; nā, ka hari tahi me ia. ");
INSERT INTO mri_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ā, i te waru o ngā rā ka haere mai rātou ki te kokoti i te tama­iti; ka mea kia huaina e rātou ko Hakaraia, ko te ingoa o tōna pāpā. ");
INSERT INTO mri_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nā, ka whaka­hoki tōna whaea, ka mea, “Kāhore; engari me hua ia ko Hoani.” ");
INSERT INTO mri_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nā, ko tā rātou mea­tanga ki a ia, “Arā, kāhore tēnei ingoa i huaina ki tētahi o ōu whanau­nga.” ");
INSERT INTO mri_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nā, ka ui rātou ki tōna pāpā, he mea wai­tohu, ko wai tāna e pai ai kia huaina ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ka mea ia ki tētahi papa tuhi­tuhi, ā, ka tuhi­tuhi, ka mea, “Ko Hoani hei ingoa mōna.” Ā, mīharo ana rātou katoa. ");
INSERT INTO mri_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nā, whai reo tonu iho tōna māngai, ka matara tōna arero, ka kōrero ia, ka whaka­pai ki te Atua. ");
INSERT INTO mri_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ā, tau ana te wehi ki te hunga katoa e noho tata ana ki a rātou, ka kōrero­tia ēnei mea katoa puta noa i te whenua puke­puke katoa o Hūria. ");
INSERT INTO mri_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nā, ka rongoā­tia ēnei mea e te hunga katoa i rangona ai ki roto ki ō rātou ngākau, ka mea, “He tama­iti aha ianei tēnei?” I a ia hoki te ringa o te Ariki. ");
INSERT INTO mri_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nā, kua kī a Hakaraia, tōna pāpā, i te Wairua Tapu, ka poro­piti, ka mea: ");
INSERT INTO mri_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kia whaka­pai­ngia te Ariki, te Atua o Īharaira! Kua ti­tiro mai hoki ia, kua hoko i tāna iwi. ");
INSERT INTO mri_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kua whaka­ara­hia ake e ia he hāona whaka­ora mō tātou, i roto i te whare o Rāwiri, o tāna pono­nga. ");
INSERT INTO mri_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ko tāna hoki ia i kōrero­tia e te māngai o āna poro­piti tapu, nō te tīma­tanga mai anō o te ao; ");
INSERT INTO mri_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","hei whaka­ora i a tātou i ō tātou hoa whawhai, i te ringa anō o te hunga katoa e kino ana ki a tātou; ");
INSERT INTO mri_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","hei whaka­puta i te mahi tohu ki ō tātou tūpuna, hei whaka­mahara ki tāna kawe­nata tapu. ");
INSERT INTO mri_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ki te oati i oati ai ia ki a Āperahama, ki tō tātou tupuna, ");
INSERT INTO mri_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kia tukua mai e ia ki a tātou he ora i te ringa o ō tātou hoa whawhai, kia mahi wehi­kore tātou ki a ia, ");
INSERT INTO mri_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","i runga i te tapu, i te tika, ki tōna aro­aro, i ngā rā katoa e ora ai tātou. ");
INSERT INTO mri_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ā, ko koe, e tama, ka kīa ko te poro­piti a te Runga Rawa. E haere hoki koe i te aro­aro o te Ariki, hei whaka­pai i ōna ara; ");
INSERT INTO mri_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","hei whaka­mātau i tāna iwi ki te ora, i ō rātou hara e murua ana. ");
INSERT INTO mri_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","He mea hoki nā te aroha, nā te mahi tohu a tō tātou Atua; nā reira hoki i puta mai ai te pūao­tanga o runga ki a tātou, ");
INSERT INTO mri_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","hei whaka­mārama i te hunga e noho ana i te pōuri, i te ātā­rangi hoki o te mate, hei whaka­tika i ō tātou wae­wae ki te hua­rahi o te rangi­mārie.” ");
INSERT INTO mri_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nā, ka tupu taua tama­iti, ā, ka kaha haere tōna wairua; ā, noho ana i ngā koraha, taea noatia te rā e whaka­kitea ai ia ki a Īharaira. ");
INSERT INTO mri_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","I aua rā ka whaka­takoto­ria he tikanga e Hīhā Ākuhata kia tuhi­tuhia te ao katoa. ");
INSERT INTO mri_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ko te tuhi­tuhi­nga tua­tahi tēnei i meatia i te wā ko Kuirinia te kāwana o Hīria. ");
INSERT INTO mri_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ā, ka haere ngā tāngata katoa kia tuhi­tuhia, ia tangata, ia tangata, ki tōna ake pā. ");
INSERT INTO mri_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","I haere atu anō a Hōhepa i Kariri, i te pā, i Nahareta, ki Hūria, ki te pā o Rāwiri, ko Pēterehema te ingoa; nō te mea nō te whare ia, nō te kāwei o Rāwiri. ");
INSERT INTO mri_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kia tuhi­tuhia ai rāua ko tāna wahine taumau, ko Meri, e hapū ana ia. ");
INSERT INTO mri_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ā, i a rāua i reira, ka rite ngā rā e whānau ai ia. ");
INSERT INTO mri_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nā, ka whānau tāna mātā­mua, ā, takaia ana e ia ki ngā kākahu, ka whaka­takoto­ria ki te takoto­ranga kai mā ngā kararehe; nō te mea kāhore he wāhi mō rātou i te whare. ");
INSERT INTO mri_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","I taua wāhi hoki ētahi hēpara e noho koraha ana, e tiaki ana i tā rātou kāhui i te pō. ");
INSERT INTO mri_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nā, tū ana tētahi ana­hera a te Ariki i ō rātou taha, ā, whiti ana te korōria o te Ariki ki a rātou, ā, tawhio noa; ā, nui whaka­hara­hara tō rātou wehi. ");
INSERT INTO mri_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nā, ka mea te ana­hera ki a rātou, “Kaua e mataku, tā te mea he kai­kauwhau tēnei ahau ki a koutou mō te hari nui, meāke puta mai ki te iwi katoa. ");
INSERT INTO mri_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nō nāia­nei hoki i whānau ai he Kai­whaka­ora mō koutou i te pā o Rāwiri, arā a te Karaiti, te Ariki. ");
INSERT INTO mri_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ko te tohu tēnei ki a koutou; e kite koutou i te tama­iti ka oti te tākai ki te kākahu, e takoto ana i te takoto­ranga kai mā ngā kararehe.” ");
INSERT INTO mri_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nā, oho­rere tonu ko tētahi ope nui o te rangi e tū tahi ana me taua ana­hera, e whaka­moe­miti ana ki te Atua, e mea ana: ");
INSERT INTO mri_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kia whai korōria te Atua i runga rawa, kia mau te rongo ki runga ki te whenua, me te whaka­aro pai ki ngā tāngata!” ");
INSERT INTO mri_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ā, ka mawehe atu ngā ana­hera i a rātou ki te rangi, ka mea ngā hēpara tētahi ki tētahi, “Tātou ka haere ki Pēterehema, kia kite i tēnei mea kua puta nei, kua whaka­pua­kina mai nei e te Ariki ki a tātou.” ");
INSERT INTO mri_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nā, kaikā tonu tā rātou haere, ā, ka kite i a Meri, i a Hōhepa i te tama­iti hoki e takoto ana i te takoto­ranga kai mā ngā kararehe. ");
INSERT INTO mri_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ā, nō ka kite, ka whaka­pua­kina te mea i kōrero­tia ki a rātou mō tēnei tama­iti. ");
INSERT INTO mri_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ā, mīharo ana ngā kai­whaka­rongo katoa ki ēnei mea, i kōrero­tia nei ki a rātou e ngā hēpara. ");
INSERT INTO mri_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ko Meri ia i āta rongoā i ēnei mea katoa, me te whaka­aro­aro i roto i tōna ngākau. ");
INSERT INTO mri_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nā, ka hoki ngā hēpara, me te whaka­korōria, me te whaka­moe­miti ki te Atua mō ngā mea katoa i rongo nei, i kite nei rātou, i rite nei ki ngā mea i kōrero­tia ki a rātou. ");
INSERT INTO mri_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ā, nō ka rite ngā rā e waru, e kotia ai te tama­iti, ka huaina tōna ingoa ko Īhu, ko tā te ana­hera i hua ai i te mea kāhore anō i hapū tōna whaea. ");
INSERT INTO mri_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ā, ka rite ngā rā e purea ai te whaea, e whaka­ritea ai te ture a Mohi, ka kawea ia e rātou ki Hiruhārama, kia tāpaea ki te Ariki. ");
INSERT INTO mri_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kia pērā­tia me te mea i tuhi­tuhia ki te ture a te Ariki: “Ko ngā tāne katoa e oroko puta mai i te kōpū, e kīa he tapu ki te Ariki.” ");
INSERT INTO mri_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kia hoatu anō he patu­nga tapu, te mea i kōrero­tia i roto i te ture a te Ariki, kia rua kūkupa, kia rua rānei pī kūkupa. ");
INSERT INTO mri_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nā, i Hiruhārama tētahi tangata, ko Himiona te ingoa; he tangata tika, he tangata whaka­aro, e tatari ana ki te whaka­hari­nga o Īharaira, kei runga hoki te Wairua Tapu i a ia. ");
INSERT INTO mri_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nā, kua whaka­mahara­tia ia e te Wairua Tapu, e kore ia e kite i te mate, kia kite rā anō ia i tā te Ariki Karaiti. ");
INSERT INTO mri_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nā, ka haere ia ki te teme­para, he mea­tanga nā te Wairua; ā, i ngā mātua e mau ana i te tama­iti, i a Īhu, kia meatia ai e rāua ki a ia tā te ture i whaka­rite ai, ");
INSERT INTO mri_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ka tango ia i a ia ki ōna ringa, ka whaka­pai ki te Atua, ka mea: ");
INSERT INTO mri_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kātahi, e te Ariki, ka tukua tāu pono­nga kia haere i runga i te rangi­mārie, ka pērā me tāu i kōrero ai. ");
INSERT INTO mri_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ka kite nei hoki ōku kanohi i tāu whaka­ora­nga, ");
INSERT INTO mri_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ka whaka­takoto­ria nei e koe ki te aro­aro o ngā iwi katoa; ");
INSERT INTO mri_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","hei whaka­mārama e kite ai ngā tauiwi, hei korōria hoki mō tāu iwi, mō Īharaira.” ");
INSERT INTO mri_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ā, mīharo tonu a Hōhepa rāua ko tōna whaea ki ngā kupu i kōrero­tia mōna. ");
INSERT INTO mri_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nā, ka manaaki a Himiona i a rāua, ā, ka mea ki tōna whaea, ki a Meri, “Nana, ka waiho tēnei tama hei taka­nga, hei aranga, mō te tini o te tangata i roto i a Īharaira; hei tohu hoki e kōrero­tia kino­tia. ");
INSERT INTO mri_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Āe rā, ka tika atu anō te hoari, ā, puta noa i tōu ake wairua, e hura­hia ai ngā whaka­aro o ngā ngākau maha.” ");
INSERT INTO mri_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ā, tērā hoki tētahi ko Ana, he poro­piti, he tamā­hine nā Panuera, nō te iwi o Āhera; kua kaumātua ia, e whitu ngā tau o tōna wāhina­tanga ake i noho ai i te tāne. ");
INSERT INTO mri_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","He pouaru, kua waru tekau mā whā rawa ōna tau e pērā ana; heoi, kīhai i mahue i a ia te teme­para; he kara­kia tonu tāna, he noho­puku, he īnoi, i te pō, i te ao. ");
INSERT INTO mri_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nā, ka tae atu ia i taua hāora anō, ka whaka­whetai ki te Ariki, ā, kōrero­tia ana ia e ia ki te hunga katoa o Hiruhārama e tatari ana ki te whaka­ora­nga. ");
INSERT INTO mri_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ā, nō ka oti ngā mea katoa e rite ana ki tā te Ariki ture, ka hoki rātou ki Kariri, ki tō rātou ake pā, ki Nahareta. ");
INSERT INTO mri_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nā, ka tupu te tama­iti, ka pakari haere, ka kī i ngā whaka­aro nunui, ā, i runga i a ia te aroha noa o te Atua. ");
INSERT INTO mri_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ā, i haere ōna mātua i ia tau, i ia tau ki Hiruhārama i te Hākari o te Kape­nga. ");
INSERT INTO mri_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ā, ka tekau mā rua ōna tau, ka haere rātou i runga i ngā rite­nga o te hākari. ");
INSERT INTO mri_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ā, ka rite ngā rā, i a rāua e hoki ana, ka whaka­ware iho te tama­iti, a Īhu, i Hiruhārama; kīhai hoki ōna mātua i mōhio. ");
INSERT INTO mri_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","I mahara hoki rāua kei roto ia i te tira, nā, ka haere, kotahi te rā ki te ara; ā, ka rapu rāua i a ia i roto i ngā whanau­nga, i ā rāua tāngata hoki i mōhio ai. ");
INSERT INTO mri_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ā, nō te kore­nga i kitea ia, hoki ana rāua ki Hiruhārama, ki te rapu i a ia. ");
INSERT INTO mri_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ā muri iho i ngā rā e toru ka kitea ia i roto i te teme­para, e noho ana i waenga­nui o ngā kai­whaka­ako, e whaka­rongo ana ki a rātou, e ui ana ki a rātou. ");
INSERT INTO mri_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ā, mīharo katoa ki tōna mātau­ranga, ki āna kōrero, te hunga i rongo ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ā, nō ka kite rāua i a ia, ka tino mīharo; ka mea tōna whaea ki a ia, “E tama, he aha koe i pēnei ai ki a māua? Nā, pōuri noa iho māua ko tōu pāpā, i a māua i rapu nei i a koe.” ");
INSERT INTO mri_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ka mea ia ki a rāua, “He aha kōrua i rapu ai i ahau? Kīhai kōrua i mahara kia noho ahau i te whare o tōku Matua?” ");
INSERT INTO mri_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Heoi, kīhai rāua i mātau ki te kupu i kōrero­tia rā e ia ki a rāua. ");
INSERT INTO mri_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nā, ka haere tahi atu ia me rāua ka tae ki Nahareta, ka ngohe­ngohe ia ki a rāua. Ko tōna whaea ia i rongoā i ēnei kupu katoa i roto i tōna ngākau. ");
INSERT INTO mri_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nā, ka kake haere a Īhu te whaka­aro nui, te kaumātua, ka pai­ngia anō e te Atua, e te tangata. ");
INSERT INTO mri_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nā, i te tekau mā rima o ngā tau o te ranga­tira­tanga o Tai­piria Hīhā, i a Ponotio Pirato e kāwana ana i Hūria, i a Herora e teta­raki ana i Kariri, i tōna teina hoki, i a Piripi, e teta­raki ana i Ituria, i te whenua hoki o Tarakonaiti, ko Raihānia, e teta­raki ana i Apirini; ");
INSERT INTO mri_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ko Anaha rāua ko Kaiapa ngā tohu­nga nui, ka puta te kupu a te Atua ki a Hoani tama a Hakaraia ki te koraha. ");
INSERT INTO mri_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nā, ka haere mai ia ki ngā wāhi katoa e pātata ana ki Horano, ka kauwhau i te iri­iri rīpe­netā hei muru­nga hara. ");
INSERT INTO mri_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","I pērā anō ia me te mea i tuhi­tuhia ki te puka­puka o ngā kōrero a Ihāia poro­piti: “He reo nō tētahi i te koraha e karanga ana: ‘Whaka­paia te hua­rahi o te Ariki, whaka­tikaia ōna ara! ");
INSERT INTO mri_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ka whaka­kīa ngā awa­awa katoa, ka whaka­horoa ngā maunga me ngā puke­puke katoa. E meinga hoki kia tika ngā wāhi kōpiko­piko, ko ngā wāhi tara­tara hei ara māeneene. ");
INSERT INTO mri_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ā, e kite ngā kiko­kiko katoa i te whaka­ora­nga a te Atua!’ ” ");
INSERT INTO mri_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nā reira, ka mea ia ki ngā mano i haere kia iri­iria e ia, “E te uri nākahi, nā wai koutou i whaka­mahara kia rere i te riri meāke puta mai? ");
INSERT INTO mri_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nā, whaka­puta­ina ngā hua e rite ana ki ō te rīpe­netā; kei anga kei mea i roto i a koutou, ‘Ko Āperahama tō tātou matua.’ Ko tāku kupu hoki tēnei ki a koutou, e āhei ana anō i te Atua te whaka­ara tama­riki ake mā Āperahama i roto i ēnei kōhatu. ");
INSERT INTO mri_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nā, ināia­nei anō kei te pā te toki ki te paki­aka o ngā rākau; ki te kāhore tētahi rākau e hua i te hua pai, ka tuaina, ka makā ki te ahi.” ");
INSERT INTO mri_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nā, ka ui ngā mano ki a ia, ka mea, “Me aha rā mātou?” ");
INSERT INTO mri_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nā, ka whaka­hoki ia, ka mea ki a rātou, “Ko te tangata i ngā koti e rua, kia hoatu ki te tangata kāhore ōna; me te tangata he kai tāna, kia pērā anō.” ");
INSERT INTO mri_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nā, ka haere mai hoki ngā pupiri­kana kia iri­iria ka mea ki a ia, “E te kai­whaka­ako, me aha mātou?” ");
INSERT INTO mri_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ka mea ia ki a rātou, “Kei nui ake i ngā mea i whaka­ritea mā koutou tā koutou e tango ai.” ");
INSERT INTO mri_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ka ui anō hoki ngā hōia ki a ia, ka mea, “Me aha hoki mātou?” Nā, ko tāna mea­tanga ki a rātou, “Kaua e tūkino­tia tētahi, kaua e muru noa i tētahi mea; kāti anō mā koutou ko ō koutou utu.” ");
INSERT INTO mri_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nā, i te iwi e tatari ana e whaka­aro­aro katoa ana i roto i ō rātou ngākau ki a Hoani, me­he­mea ko te Karaiti ia. ");
INSERT INTO mri_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ka whaka­hoki a Hoani, ka mea ki a rātou katoa, “Ko ahau nei, he iri­iri tāku i a koutou ki te wai; kei te haere mai ia tētahi he kaha rawa ake i ahau, e kore ahau e tāu hei wewete i te here o ōna hū. Māna koutou e iri­iri ki te Wairua Tapu, ki te kāpura. ");
INSERT INTO mri_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ko tāna mea tahi kei tōna ringa, hei tino tahi i tāna patu­nga wīti, hei kohi hoki i te wīti ki roto ki tāna whare wīti; ko te pāpapa ia e tahuna ki te kāpura e kore e tineia.” ");
INSERT INTO mri_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","He maha atu anō āna kupu whaka­hau i kauwhau ai ia i te rongo­pai ki te iwi. ");
INSERT INTO mri_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Otirā, nā tōna riri­nga i a Herora teta­raki mō Herōriaha, mō te wahine a tōna tua­kana, a Piripi, ā, mō ngā kino katoa hoki i meinga e Herora; ");
INSERT INTO mri_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ka āpiti­tia atu e Herora tēnei ki runga i ērā katoa, tū­taki­na ana e ia a Hoani ki te whare here­here. ");
INSERT INTO mri_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nā, ka poto katoa te iwi te iri­iri, i a Īhu kua oti te iri­iri, ā, i a ia e īnoi ana, ka tu­whera te rangi, ");
INSERT INTO mri_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ā, ka heke iho te Wairua Tapu, ka heke tinana iho, ānō he kūkupa, ki runga ki a ia, ā, ka puta mai he reo nō te rangi, e mea ana, “Ko koe tāku Tama i aroha ai, tāku i āhua­reka ai.” ");
INSERT INTO mri_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nā, ko Īhu, i a ia i tīmata ai ki te whaka­ako, kei te toru tekau ōna tau, ā, ki tā te tangata kī, he tama ia nā Hōhepa tama a Heri, ");
INSERT INTO mri_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ko ia he tama nā Matata, tama a Rīwai, tama a Mereki, tama a Iana, tama a Hōhepa, ");
INSERT INTO mri_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","tama a Matatiaha, tama a Āmoho, tama a Nahumu, tama a Eheri, tama a Nakai, ");
INSERT INTO mri_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","tama a Māta, tama a Matatiaha, tama a Hemei, tama a Hōhepa tama a Hūrā, ");
INSERT INTO mri_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","tama a Hoana, tama a Reha, tama a Herupapera, tama a Haratiera, tama a Neri, ");
INSERT INTO mri_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","tama a Mereki, tama a Ari, tama a Kohama, tama a Eremorama, tama a Ere, ");
INSERT INTO mri_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","tama a Hohe, tama a Eriētere, tama a Horimi, tama a Matata, tama a Rīwai, ");
INSERT INTO mri_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","tama a Himiona, tama a Hūrā, tama a Hōhepa tama a Honana, tama a Eriakimi, ");
INSERT INTO mri_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","tama a Merea, tama a Menana, tama a Matata, tama a Nātana, tama a Rāwiri, ");
INSERT INTO mri_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","tama a Hehe, tama a Ōpere, tama a Poaha, tama a Haramono, tama a Nāhona, ");
INSERT INTO mri_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","tama a Aminarapa, tama a Arame tama a Heteromo, tama a Parete, tama a Hūrā, ");
INSERT INTO mri_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","tama a Hākopa, tama a Īhaka, tama a Āperahama, tama a Tera, tama a Nahora, ");
INSERT INTO mri_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","tama a Haruku, tama a Rakau, tama a Pereke, tama a Ēpere, tama a Haraha, ");
INSERT INTO mri_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","tama a Kai­nana, tama a Arapahata, tama a Hema, tama a Noa, tama a Rameka, ");
INSERT INTO mri_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","tama a Matuhara, tama a Ēnoka, tama a Iarere, tama a Marerēre, tama a Kai­nana, ");
INSERT INTO mri_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","tama a Ēnoha, tama a Heta, tama a Ārama, a te tama a te Atua. ");
INSERT INTO mri_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nā, ko Īhu, kī tonu i te Wairua Tapu, hoki atu ana i Horano, ā, ka āra­hina e te Wairua i te koraha. ");
INSERT INTO mri_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mō ngā rā e whā tekau, whaka­mā­tau­tau­ria ai e te rēwera. Kīhai ia i kai i tētahi mea i aua rā, ā, nō ka pahemo, ka hia­kai ia. ");
INSERT INTO mri_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nā, ka mea te rēwera ki a ia, “Ki te mea ko te Tama koe a te Atua, kīa iho tēnei kōhatu kia meinga hei taro.” ");
INSERT INTO mri_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nā, ka whaka­hoki a Īhu ki a ia, ka mea, “Kua oti te tuhi­tuhi, ‘E kore e ora te tangata i te taro kau.’ ” ");
INSERT INTO mri_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kātahi ka āra­hina ia e ia ki runga, ā, mea kau iho kua whaka­kitea ki a ia ngā ranga­tira­tanga katoa o te ao. ");
INSERT INTO mri_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ka mea te rēwera ki a ia, “Māku e hoatu ki a koe tēnei ranga­tira­tanga katoa, me te korōria o ēnei mea; kua tukua hoki ki ahau, ā, ka hoatu e ahau ki tāku e pai ai. ");
INSERT INTO mri_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nā, ki te koro­piko koe ki tōku aro­aro, mōu katoa.” ");
INSERT INTO mri_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nā, ka whaka­hoki a Īhu ki a ia, ka mea, “Kua oti te tuhi­tuhi, ‘Me koro­piko koe ki te Ariki, ki tōu Atua, me mahi anō ki a ia anake!’ ” ");
INSERT INTO mri_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nā, ka kawea ia e ia ki Hiruhārama, ā, whaka­tū­ria ana ki runga ki te keo­keo­nga o te teme­para, nā, ka mea ia ki a ia, “Ki te mea ko te Tama koe a te Atua, rere atu i konei ki raro, ");
INSERT INTO mri_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kua oti hoki te tuhi­tuhi, ‘Ka kōrero­tia iho koe e ia ki āna ana­hera, kia tiaki­na koe.’ ");
INSERT INTO mri_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ā, ‘Mā rātou koe e hiki ake ki ō rātou ringa, kei tūtuki tōu wae­wae ki te kōhatu.’ ” ");
INSERT INTO mri_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nā, ka whaka­hoki a Īhu, ka mea ki a ia, “Kua takoto te kōrero, ‘Aua e whaka­mā­tau­tau ki te Ariki, ki tōu Atua.’ ” ");
INSERT INTO mri_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ā, ka mutu katoa ngā whaka­mā­tautau­ranga a te rēwera, ka mawehe atu i a ia mō tētahi wāhi. ");
INSERT INTO mri_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nā, ka hoki a Īhu i runga i te kaha o te Wairua ki Kariri, ā, haere ana tōna rongo, ā, puta noa i ngā wāhi tata katoa. ");
INSERT INTO mri_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ka whaka­ako ia i roto i ō rātou whare kara­kia, me te whaka­korōria te katoa i a ia. ");
INSERT INTO mri_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nā, ka haere ia ki Nahareta, ki te wāhi i whāngaia ai ia; ā, ka tomo i te rā hāpati ki te whare kara­kia, ko tāna hanga hoki ia, ka whaka­tika ki te kōrero puka­puka. ");
INSERT INTO mri_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ā, ka hoatu ki a ia te puka­puka a Ihāia poro­piti. Ā, nō ka whera­hia te puka­puka, ka kitea e ia te wāhi i tēnei tuhi­tuhi­nga: ");
INSERT INTO mri_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kei ahau te Wairua o te Ariki, nāna nei hoki ahau i whaka­wahi, hei kauwhau i te rongo­pai ki te hunga rawa­kore. Kua tonoa ahau e ia ki te kauwhau ki ngā here­here, kia haere noa, ki ngā matapō kia ti­tiro; ki te tuku i te hunga e marū ana, kia haere noa atu, ");
INSERT INTO mri_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ki te kauwhau i te tau manako­hanga mai a te Ariki.” ");
INSERT INTO mri_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nā, ka kopia e ia te puka­puka, ka hoatu ki te kai­tiaki, ā, noho ana. Nā, ka ti­tiro mata­tau ki a ia ngā kanohi o te hunga katoa i roto i te whare kara­kia. ");
INSERT INTO mri_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kātahi ia ka anga, ka kōrero ki a rātou, “Nō nāia­nei, i ō koutou tari­nga e whaka­rongo mai nei, i mana ai tēnei karaipi­ture.” ");
INSERT INTO mri_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ā, i whaka­pai rātou katoa ki a ia, i mīharo ki ngā kupu pai i puta i tōna māngai. Ka mea rātou, “Ehara ianei tēnei i te tama a Hōhepa?” ");
INSERT INTO mri_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ka mea ia ki a rātou, “Tērā pea e puaki mai i a koutou tēnei kupu whaka­rite ki ahau, ‘E rata, rongoā koe i a koe anō! Ko ngā mea i rongo ai mātou kua meinga ki Kaperenauma, meinga hoki ki konei, ki tōu whenua.’ ” ");
INSERT INTO mri_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","I mea anō ia, “He pono tāku e mea nei ki a koutou, e kore te poro­piti e manako­hia i tōna ake whenua. ");
INSERT INTO mri_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Otirā, he pono tāku e mea nei ki a koutou, he toko­maha ngā pouaru i roto i a Īharaira i ngā rā i a Irāia, i te rangi kua oti te kōpani i ngā tau e toru i ngā marama e ono, i te mate­kai­tanga nui o te whenua katoa. ");
INSERT INTO mri_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Heoi, kīhai a Irāia i tonoa ki tētahi o rātou, ki a Harepata anake o Hairona, ki te wahine pouaru. ");
INSERT INTO mri_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","He toko­maha hoki ngā repera i roto i a Īharaira, i ngā rā o Eriha poro­piti; ā, kīhai tētahi o rātou i whaka­mā­kia, ko Nāmana anake, ko te Hīriani.” ");
INSERT INTO mri_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ā, kī tonu i te riri te hunga katoa i te whare kara­kia, i te rongo­nga ki ēnei mea. ");
INSERT INTO mri_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nā, ko tō rātou whaka­tikanga ake, ka maka i a ia ki waho o te pā, ā, āra­hina ana ia ki te pari o te puke i hangā ai tō rātou pā, kia whaka­takā ai ia ki raro. ");
INSERT INTO mri_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Otirā, i tika ia rā waenga­nui o rātou, ā, haere ana. ");
INSERT INTO mri_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ā, ka tae ki Kaperenauma, ki tētahi pā o Kariri, ka whaka­ako i a rātou i te hāpati. ");
INSERT INTO mri_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nā, ka mīharo rātou ki tāna ako, i whai mana hoki tāna kupu. ");
INSERT INTO mri_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nā, i te whare kara­kia tētahi tangata he wairua rēwera poke tōna, nui atu tōna reo ki te karanga, ");
INSERT INTO mri_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ka mea, “Kāti rā; he aha mātou nāu, e Īhu o Nahareta; kua tae mai koe ki te whaka­ngaro i a mātou? E mōhio ana ahau ki a koe, ko wai koe; ko te Mea Tapu a te Atua!” ");
INSERT INTO mri_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nā, rīria iho ia e Īhu, ka mea ia, “Kāti te kōrero, puta mai hoki i roto i a ia.” Kātahi te rēwera ka turaki i a ia ki waenga­nui, ā, puta mai ana i roto i a ia, kīhai hoki tērā i ahatia. ");
INSERT INTO mri_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nā tau ana te mīharo ki a rātou katoa, ka kōrero­rero tētahi ki tētahi, ka mea, “He aha tēnei kupu? Mana tonu nei hoki tāna tono i ngā wairua poke, kaha tonu, ā, puta mai ana ki waho.” ");
INSERT INTO mri_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ā, pakū ana tōna rongo puta noa i ngā wāhi tūtata katoa. ");
INSERT INTO mri_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ā, ko tōna whaka­tikanga i te whare kara­kia, tomo tonu ki te whare o Haimona. Nā, e mate ana te whaea o te wahine a Haimona, he nui te kirikā; ka īnoi rātou ki a ia mōna. ");
INSERT INTO mri_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nā, ka tū ia ki runga i a ia, ā, rīria iho te kirikā; ā, mutu ake, nā, ara tonu ake ia kei te taka mea mā rātou. ");
INSERT INTO mri_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","I te toene­tanga o te rā, ka kawea mai ki a ia e ngā tāngata katoa ngā mea o rātou e mate ana i te tini o ngā mate; nā, whaka­pā­kia iho e ia ōna ringa ki tēnei, ki tēnei o rātou, ā, ora ake rātou. ");
INSERT INTO mri_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","He toko­maha hoki te hunga i puta mai ngā rēwera i roto i a rātou; i karanga hoki aua wairua i mea, “Ko te Tama koe a te Atua!” Ā, rīria ana rātou e ia, kīhai i tukua kia kōrero, i mātau hoki rātou ko te Karaiti ia. ");
INSERT INTO mri_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ka ao te rā, ka puta atu ia, ka haere ki tētahi wāhi koraha; ā, ka rapu ngā mano i a ia, ka tae ki a ia, nā, puri­tia ana ia, kei whaka­rērea rātou e ia. ");
INSERT INTO mri_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ka mea ia ki a rātou, “Me kauwhau e ahau te ranga­tira­tanga o te Atua ki ērā atu pā anō; koia hoki ahau i tonoa mai ai.” ");
INSERT INTO mri_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ā, kauwhau ana ia i ngā whare kara­kia o Kariri. ");
INSERT INTO mri_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ā, i te mano e āki ana ki a ia ki te whaka­rongo ki te kupu a te Atua, nā, e tū ana ia i te taha o te roto o Kenehareta, ");
INSERT INTO mri_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","nā, ka kite ia i ētahi kai­puke e rua e tū ana i te taha o te roto; ko ngā kaihao ia kua riro i runga, e horoi ana i ā rātou kupe­nga. ");
INSERT INTO mri_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nā, ka eke ia ki tētahi o ngā kai­puke, ki tō Haimona, ka mea ki a ia kia neke atu ki waho tata. Nā, noho ana ia, whaka­akona ana e ia te mano i runga i te kai­puke. ");
INSERT INTO mri_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ā, ka mutu tāna kōrero, ka mea ia ki a Haimona, “Neke atu ki te wāhi hōhonu, ka tuku ai i ā koutou kupe­nga ki te hao.” ");
INSERT INTO mri_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nā, ka whaka­hoki a Haimona, ka mea ki a ia, “E kara, mahi noa mātou i te pō roa nei, tē mau tētahi; heoi, nāu nā te kupu me tuku e ahau te kupe­nga.” ");
INSERT INTO mri_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ā, nō tā rātou mea­tanga i tēnei, he mano tini ngā ika i mau i a rātou; ka whaka­pakaru tā rātou kupe­nga. ");
INSERT INTO mri_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nā, ka tā­whiri rātou ki ō rātou hoa i tērā o ngā kai­puke kia hoe mai hei hoa mō rātou. Ā, i tō rātou taenga mai, whaka­kīa ana ngā kai­puke e rua, nō ka whaka­totohu. ");
INSERT INTO mri_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Otiia, nō te kite­nga o Haimona Pita, ka hinga iho ki ngā turi o Īhu, ka mea, “Mawehe atu i ahau, e te Ariki, he tangata hara hoki ahau.” ");
INSERT INTO mri_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mau tonu hoki tōna mīharo me tō ōna hoa katoa, ki te haonga o ngā ika i haoa nei e rātou; ");
INSERT INTO mri_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","i pērā anō hoki a Hēmi rāua ko Hoani, he tama rāua nā Heperi, he hoa hoki nō Haimona. Nā, ka mea a Īhu ki a Haimona, “Kaua e mataku; i ēnei wā e takoto ake nei ka hao tāngata koe.” ");
INSERT INTO mri_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ā, ka whaka­ūria ngā kai­puke ki uta, mahue ake ngā mea katoa i a rātou, ā, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nā, i a ia i tētahi o ngā pā, nā, ko tētahi tangata kapi tonu i te repera; ā, i tōna kite­nga i a Īhu, ka takoto tāpapa, ka īnoi ki a ia, ka mea, “E te Ariki, ki te pai koe, e taea ahau e koe te mea kia mā.” ");
INSERT INTO mri_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nā, ka totoro tōna ringa, ka pā ki a ia, ka mea, “E pai ana ahau. Kia mā koe.” Ā, mutu tonu ake tōna repera. ");
INSERT INTO mri_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ā, ka whaka­tūpato ia i a ia kia kaua e kōrero­tia ki te tangata, engari “Haere, kia kite te tohu­nga i a koe, kawea atu hoki mō tōu whaka­mā­kanga ngā mea i whaka­ritea e Mohi, hei mea whaka­atu ki a rātou.” ");
INSERT INTO mri_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Heoi, tino pakū atu ana tōna rongo; he toko­maha noa atu hoki i hui­hui ki te whaka­rongo, kia whaka­ora­ngia ai e ia ō rātou ngoi­kore­tanga. ");
INSERT INTO mri_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Otirā, haere ana ia, ko ia anake ki te koraha ki te īnoi. ");
INSERT INTO mri_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ā, i tētahi o aua rā, e whaka­ako ana ia, me te noho anō ngā Parihi me ngā kai­whaka­ako o te ture, i haere mai nei i ngā kāinga katoa o Kariri, o Hūria, o Hiruhārama; i reira anō te kaha o te Ariki hei whaka­ora i a rātou. ");
INSERT INTO mri_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nā, ka kawea mai e ētahi tāngata i runga i te moenga tētahi tangata, he pararūtiki; mea noa rātou kia kawea ia ki roto, kia whaka­takoto­ria ki tōna aro­aro. ");
INSERT INTO mri_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ā, i te kore­nga e kitea e rātou he hua­rahi hei kawe­nga mai i a ia ki roto, i te mano o te tangata, ka kakea te whare, ā, tukua iho ana ia rā ngā taera, me te moenga anō, ki waenga­nui, ki te aro­aro o Īhu. ");
INSERT INTO mri_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ā, i tōna kite­nga i tō rātou whaka­pono, ka mea ia ki a ia, “E hoa, ka oti ōu hara te muru.” ");
INSERT INTO mri_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nā, ka anga, ka whaka­aro­aro ngā kara­ipi me ngā Parihi, ka mea, “Ko wai tēnei nāna ngā kupu kohu­kohu? Ko wai hei muru hara? Ko te Atua anake.” ");
INSERT INTO mri_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Otirā, i mōhio a Īhu ki ā rātou whaka­aro­aro­nga, ka oho, ka mea ki a rātou, “He aha tā koutou e whaka­aro­aro nā i roto i ō koutou ngākau? ");
INSERT INTO mri_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ko tēhea te mea takoto noa, ko te mea, ‘Ka oti ōu hara te muru,’ ko te mea rānei, ‘Whaka­tika, haere’? ");
INSERT INTO mri_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Otiia, kia mātau ai koutou he mana muru hara tō te Tama a te tangata i runga i te whenua.” Ka mea ia ki te pararūtiki, “Ko tāku kupu tēnei ki a koe, whaka­tika, tango­hia ake tōu moenga, haere ki tōu whare.” ");
INSERT INTO mri_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nā, whaka­tika tonu ake ia i tō rātou aro­aro, tango­hia ake ana te mea i takoto ai ia, haere ana ki tōna whare, me te whaka­korōria i te Atua. ");
INSERT INTO mri_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nā, mīharo ana rātou katoa, ka whaka­korōria i te Atua, kī tonu hoki rātou i te mataku, ka mea, “Puta kē ngā mea i kite nei tātou ināia­nei!” ");
INSERT INTO mri_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ā, i muri i ēnei mea, ka haere ia, ka kite i tētahi pupiri­kana, ko Rīwai te ingoa, e noho ana i te wāhi tango takoha, ka mea ki a ia, “Aru­mia mai ahau.” ");
INSERT INTO mri_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nā, whaka­rērea ake e ia ngā mea katoa, whaka­tika ana, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nā, ka takā e Rīwai he hākari nui māna i tōna whare; he toko­maha hoki ngā pupiri­kana me ngā tāngata kē i noho tahi rātou. ");
INSERT INTO mri_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nā, ka amu­amu ngā Parihi me ō rātou kara­ipi ki āna ākonga, ka mea, “He aha koutou ka kai tahi ai, ka inu tahi ai me ngā pupiri­kana, me ngā tāngata hara?” ");
INSERT INTO mri_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Kāhore he aha o ngā tāngata ora e meatia ai e te rata, engari o te hunga e mate ana. ");
INSERT INTO mri_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kīhai ahau i haere mai ki te karanga i te hunga tika, engari i te hunga hara, kia rīpe­netā.” ");
INSERT INTO mri_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nā, ka mea rātou ki a ia, “Ko ngā ākonga a Hoani hono tonu te noho­puku, te īnoi, me ngā ākonga anō a ngā Parihi; ko āu ia e kai ana, e inu ana.” ");
INSERT INTO mri_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nā, ko te mea­tanga a Īhu ki a rātou, “E taea rānei e koutou te mea kia noho­puku ngā tama o te whare mārena, i te mea kei a rātou te tāne mārena hou? ");
INSERT INTO mri_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nā, tērā e tae mai ngā rā; ā, ina tango­hia te tāne mārena hou i a rātou, kātahi rātou ka noho­puku i aua rā.” ");
INSERT INTO mri_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","I kōrero­tia anō e ia tētahi kupu whaka­rite ki a rātou: “E kore e hāea e te tangata tētahi wāhi o te kahu hou hei pāpaki mō te kahu tawhito; kei pakaru te mea hou, ā, e kore te pāpaki i tango­hia i te mea hou e hāngai ki te mea tawhito. ");
INSERT INTO mri_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","E kore hoki te tangata e riri­ngi i te wāina hou ki ngā ipu tawhito; kei pakaru ngā ipu i te wāina hou, nā, ka ma­ringi, ā, kore ake ngā ipu. ");
INSERT INTO mri_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Engari me riri­ngi te wāina hou ki ngā ipu hou. ");
INSERT INTO mri_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ka inu hoki te tangata i te wāina tawhito, e kore ia e hia­hia ki te mea hou, e mea hoki ia, ‘Erangi te mea tawhito.’ ” ");
INSERT INTO mri_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nā, i te hāpati ka haere ia rā waenga wīti; ā, kato­hia ana e āna ākonga ngā puku, wīti, kainga ake, he mea kō­muku­muku ki te ringa. ");
INSERT INTO mri_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nā, ka mea ētahi o ngā Parihi, “He aha koutou ka mahi ai i te mea e kore e tika kia mahia i te hāpati?” ");
INSERT INTO mri_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Kāhore ianei koutou i kite i tā Rāwiri i mea ai, i a ia e mate ana i te hia­kai, rātou ko ōna hoa. ");
INSERT INTO mri_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I tōna tomo­kanga ki te whare o te Atua, ka tango ia i ngā taro aro­aro, nā, kainga ana e ia, hoatu ana hoki ki ōna hoa; ko ngā mea kīhai nei i tika kia kainga, engari mā ngā tohu­nga anake?” ");
INSERT INTO mri_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","I mea anō ia ki a rātou, “Ko te Tama a te tangata te Ariki o te hāpati.” ");
INSERT INTO mri_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ā, i tētahi atu hāpati ka tomo ia ki te whare kara­kia, ka whaka­ako; i reira anō tētahi tangata, ko tōna ringa matau kua memenge. ");
INSERT INTO mri_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ka ti­tiro whaka­mau ngā kara­ipi me ngā Parihi ki a ia, me kore ia e whaka­ora i te hāpati; kia whai take ai hei whaka­wā­kanga mōna. ");
INSERT INTO mri_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nā, ka mōhio ia ki ō rātou whaka­aro, ka mea ki te tangata i te ringa memenge, “Whaka­tika, e tū ki waenga­nui.” Ā, whaka­tika ana ia, tū ana. ");
INSERT INTO mri_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kātahi ka mea a Īhu ki a rātou, “Māku hoki e ui ki a koutou; he mea tika rānei te mahi pai i te hāpati, te mahi kino rānei? Te whaka­ora, te whaka­mate rānei?” ");
INSERT INTO mri_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nā, ka tiro­tiro ia ki a rātou katoa ka mea ki taua tangata, “Totoro mai tōu ringa.” Ā, pērā ana ia; nā, kua ora anō tōna ringa. ");
INSERT INTO mri_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nā, kī tonu rātou i te hono­honoā ka kōrero­rero ki a rātou anō, me aha rānei a Īhu e rātou. ");
INSERT INTO mri_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ā, i aua rā ka haere ia ki te maunga ki te īnoi, he īnoi tonu tāna i te roa o te pō ki te Atua. ");
INSERT INTO mri_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ā, ka ao te rā, ka karanga­tia e ia āna ākonga; ka whiri­whiria e ia kotahi tekau mā rua o rātou, ā, huaina ana hoki e ia hei āpō­toro: ");
INSERT INTO mri_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ko Haimona (i huaina hoki e ia ko Pita) ko tōna teina ko Anaru; ko Hēmi rāua ko Hoani, ko Piripi rāua ko Patoromu, ");
INSERT INTO mri_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ko Matiu rāua ko Tamati, ko Hēmi tama a Arapiu, ko Haimona (e kīa nei ko Heroti), ");
INSERT INTO mri_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ko Hūrā tama a Hēmi, ko Hūrā Ikariote hoki, ko ia nei te kai­tuku. ");
INSERT INTO mri_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nā, ka heke ngā­tahi iho rātou, tū ana i tētahi wāhi tai­rite, rātou ko te rōpū o āna ākonga, me te hui­hui­nga nui o te iwi i Hūria katoa, i Hiruhārama, i te taha hoki o te moana o Tāira o Hairona, i haere mai nei ki te whaka­rongo ki a ia, kia whaka­ora­ngia hoki ō rātou mate; ");
INSERT INTO mri_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","me te hunga anō e whaka­toia ana e ngā wairua poke, ā, whaka­ora­ngia ana rātou. ");
INSERT INTO mri_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","I whai anō te mano katoa kia pā ki a ia; i puta hoki he kaha i a ia, ā, whaka­ora­ngia ana rātou katoa. ");
INSERT INTO mri_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nā, ka ti­tiro ōna kanohi ki āna ākonga, ka mea ia, “Ka koa koutou, e ngā rawa­kore; mō koutou hoki te ranga­tira­tanga o te Atua! ");
INSERT INTO mri_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ka koa koutou e hia­kai nei ināia­nei; ka mākona hoki koutou! Ka koa koutou e tangi nei ināia­nei; e kata hoki koutou! ");
INSERT INTO mri_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ka koa koutou ina kino­ngia koutou e ngā tāngata, ina wehea atu i roto i a rātou, ina tāwaia ina rukea atu tō koutou ingoa, ānō he mea kino, mō te whaka­aro ki te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kia hari i taua rā, me te tū­peke­peke. He nui hoki tō koutou utu i te rangi; i pērā­tia hoki ngā poro­piti e ō rātou mātua. ");
INSERT INTO mri_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Otirā, auē te mate mō koutou, mō te hunga taonga; kua riro hoki i a koutou tō koutou whaka­mārie! ");
INSERT INTO mri_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Auē, te mate mō koutou, mō te hunga e mākona ana ināia­nei, e mate hoki koutou i te hia­kai! Auē, te mate mō koutou, mō te hunga e kata ana ināia­nei, ka auē hoki koutou, ka tangi! ");
INSERT INTO mri_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Auē, te mate mō koutou ua kōrero­tia paitia koutou e ngā tāngata katoa! I pērā hoki ō rātou mātua ki ngā poro­piti teka. ");
INSERT INTO mri_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nā, ko tāku kupu tēnei ki a koutou e whaka­rongo mai nei: aroha­ina ō koutou hoa whawhai; kia pai te mahi ki te hunga e kino ana ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Manaaki­tia te hunga e kanga ana i a koutou, me īnoi mō te hunga e whaka­whiu ana i a koutou. ");
INSERT INTO mri_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nā, ki te pākia tōu pā­pā­ringa e tētahi, whaka­anga­hia atu hoki tētahi; ki te tango­hia tōu ngeri e tētahi, kaua e kai­ponu­hia tōu koti. ");
INSERT INTO mri_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hoatu ki ngā tāngata katoa e īnoi ana ki a koe; kaua hoki e tonoa āu mea ki te tango­hia e te tangata. ");
INSERT INTO mri_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ā, ko tā koutou e pai ai kia meatia e ngā tāngata ki a koutou, meatia anō e koutou ki a rātou. ");
INSERT INTO mri_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ki te aroha koutou ki te hunga e aroha ana ki a koutou, kei hea he whaka­whetai ki a koutou? E aroha ana hoki te hunga hara ki te hunga e aroha ana ki a rātou. ");
INSERT INTO mri_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ki te ata­whai hoki koutou i te hunga e ata­whai ana i a koutou, kei hea he whaka­whetai ki a koutou? E pēnā ana anō te hunga hara. ");
INSERT INTO mri_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ki te tuku moni koutou ki te hunga e mea ai koutou ka utua mai rātou, kei hea he whaka­whetai ki a koutou? E tuku moni ana hoki te hunga hara ki te hunga hara, mō te pērā kia whaka­hokia ki a rātou. ");
INSERT INTO mri_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Engari, kia aroha ki ō koutou hoa whawhai, mahia te pai ki a rātou, ka tuku atu he moni, kaua anō e mutu te tū­mana­ko; ā, tērā e rahi te whaka­utu ki a koutou, ka tupu koutou hei tama­riki mā te Runga Rawa; e ata­whai ana hoki ia i te hunga e kore e whaka­whetai, i te hunga kino. ");
INSERT INTO mri_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kia ngā­wari rāpea koutou, kia pērā me tō koutou Matua e ngā­wari ana. ");
INSERT INTO mri_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kaua e whaka­wā, ā, e kore koutou e whaka­wā­kia; kaua e whaka­tau hē, e kore te hē, ā, e whaka­taua ki a koutou. Houhia te rongo, ā, e houhia anō te rongo ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Hoatu, ā, ka hōmai ki a koutou; he mēhua pai, pēhi rawa, oioi rawa, pūrena tonu tā rātou e hōmai ai ki te kokoru o ō koutou kākahu. Ko te mēhua hoki e mēhua ai koutou, hei mēhua anō tēnā ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ā, ka puaki tāna kupu whaka­rite ki a rātou: “E āhei rānei te matapō te ārahi i te matapō? E kore rānei e taka tahi rāua ki te poka? ");
INSERT INTO mri_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","E kore te ākonga e rahi ake i tōna kai­whaka­ako; engari, ka rite anō ki ō rātou kai­whaka­ako ngā tāngata katoa kua tino pū­kenga­tia. ");
INSERT INTO mri_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“He aha tāu e ti­tiro ki te ota­ota i roto i te kanohi o tōu teina, tē kite i te kuru­pae i tōu ake kanohi? ");
INSERT INTO mri_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ā, me pēhea e taea ai e koe te kōrero ki tōu teina, ‘E tōku teina, iaua, kia kapea atu e ahau te ota­ota i roto i tōu kanohi,’ tē kite i te kuru­pae i roto i tōu kanohi? E te tangata tini­hanga, mātua kapea atu e koe te kuru­pae i roto i tōu kanohi, kātahi koe ka mārama ai ki te kape i te ota­ota i roto i te kanohi o tōu teina. ");
INSERT INTO mri_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“E kore hoki te rākau āta­ahua e hua i te hua kino; e kore anō te rākau kino e hua i te hua āta­ahua. ");
INSERT INTO mri_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mā ōna hua tonu ka mōhio­tia ai tēnei rākau, tēnei rākau. E kore hoki e kohia he piki i runga i ngā tā­tarā­moa, e kore anō e whakia he karepe i runga i te tū­mata­kuru. ");
INSERT INTO mri_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","He tangata pai, he pai tāna e whaka­puta ai i roto i te taonga pai o tōna ngākau. He tangata kino, he kino tāna e whaka­puta ai i roto i ngā taonga kino o tōna ngākau. He pūrena­tanga hoki nō te ngākau ngā kupu a te māngai. ");
INSERT INTO mri_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“He aha koutou ka karanga ai ki ahau, ‘E te Ariki, e te Ariki,’ tē mahi i āku e kōrero ai? ");
INSERT INTO mri_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nā, ko te tangata e haere mai ana ki ahau, e rongo ana ki āku kupu, ā, e mahi ana, māku e whaka­atu ki a koutou tōna rite. ");
INSERT INTO mri_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ka rite ia ki te tangata i hanga i tētahi whare, i keri, i whaka­hōhonu, ā, whaka­takoto ana i te papa ki runga ki te toka. Ā, i te pu­tanga o te wai­puke, ka pakaru te roma ki taua whare, heoi kīhai i taea te whaka­ngāueue; nō te mea i ū tōna hanga­nga. ");
INSERT INTO mri_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tēnā ko te tangata i rongo, ā, kīhai i mahi, ka rite ia ki te tangata i hanga i tētahi whare ki runga ki te one­one, tē ai he tū­ranga; i te pākaru­tanga o te roma, nā, hinga tonu iho; ā, nui atu te pakaru o taua whare.” ");
INSERT INTO mri_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ā, nō ka mutu ēnei kupu katoa āna, me te whaka­rongo anō te iwi, ka tomo ia ki Kaperenauma. ");
INSERT INTO mri_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nā, e mate ana te pono­nga a tētahi kene­turio, meāke marere, ko tāna hoki i mate­nui ai. ");
INSERT INTO mri_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ā, nō tōna rongo­nga i a Īhu, ka tonoa mai ki a ia ētahi kaumātua o ngā Hūrai, hei mea ki a ia kia haere ki te whaka­ora i tāna pono­nga. ");
INSERT INTO mri_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ā, i tō rātou taenga ki a Īhu, he kaha tā rātou īnoi, ka mea, “He pai te tangata e meatia ai tēnei e koe, ");
INSERT INTO mri_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","E aroha ana hoki ia ki tō tātou iwi, nāna hoki i hanga te whare kara­kia mō mātou.” ");
INSERT INTO mri_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nā, haere tahi ana a Īhu me rātou. Ā, i a ia kāhore nei i matara i te whare, ka tono te kene­turio i ētahi hoa ki a ia, ka mea ki a ia, “E te Ariki, kei mau­mau nge­nge noa koe, ehara hoki ahau i te tikanga tangata e haere ake ai koe ki raro i tōku tuanui; ");
INSERT INTO mri_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","koia tē tae ai tōku aro ki te haere atu ki a koe. Engari kia puaki mai tāu kupu, ā, ka ora tāku pono­nga. ");
INSERT INTO mri_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","He tangata hoki ahau e whaka­haua ana, he hōia anō āku hei whaka­hau­nga māku, nā, ka mea ahau ki tēnei, ‘Haere,’ ā, ka haere; ki tētahi atu hoki, ‘Haere mai,’ ā, ka haere mai; ki tāku pono­nga anō hoki, ‘Meatia tēnei,’ ā, ka meatia e ia.” ");
INSERT INTO mri_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ā, i te rongo­nga o Īhu ki ēnei mea, ka mīharo ki a ia, ka tahuri, ka mea ki te mano e aru ana i a ia, “Ko tāku kupu tēnei ki a koutou, kāhore anō ahau i kite i te whaka­pono hei rite mō tēnei te nui, ahakoa i roto i a Īharaira.” ");
INSERT INTO mri_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ā, roko­hanga atu e te hunga i tonoa, i tō rātou hoki­nga atu ki te whare, kua ora te pono­nga rā. ");
INSERT INTO mri_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nā, i muri tata iho ka haere ia ki tētahi pā, ko Naina te ingoa; ā, i haere tahi āna ākonga me ia, he rahi hoki te hui. ");
INSERT INTO mri_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ā, ka whaka­tata ia ki te kūwaha o te pā, nā, he tū­pā­paku tērā e kauhoa­tia ana mai, he hua­tahi nā tōna whaea, ā, he pouaru tērā: he toko­maha o te pā e haere tahi ana me ia. ");
INSERT INTO mri_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ā, i te kite­nga o te Ariki i a ia, ka aroha ki a ia, ka mea ki a ia, “Kaua e tangi.” ");
INSERT INTO mri_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nā, ka whaka­tata ia, ka pā ki te kauhoa, ā, tū tonu ngā kai­kauhoa. Nā, ko tāna mea­tanga, “E tama, ko tāku kupu tēnei ki a koe, e ara.” ");
INSERT INTO mri_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nā, ka noho te tū­pā­paku ki runga, ka anga, ka kōrero, ā, hoatu ana ia e ia ki tōna whaea. ");
INSERT INTO mri_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nā, ka tau te wehi ki a rātou katoa; ka whaka­korōria i te Atua, ka mea, “Kua puta ake i roto i a tātou he poro­piti nui!” ā, “Kua ti­tiro mai hoki te Atua ki tāna iwi.” ");
INSERT INTO mri_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nā, haere ana tēnei kōrero mōna puta noa i Hūria, i ngā wāhi pātata katoa anō hoki. ");
INSERT INTO mri_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ā, ka kōrero­tia ēnei mea katoa ki a Hoani e āna ākonga. ");
INSERT INTO mri_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nā, ka karanga­tia e Hoani ētahi o āna ākonga toko­rua, ka tonoa ki te Ariki, mea ai, “Ko koe rānei tērā e haere mai ana? Me tatari rānei tātou ki tētahi atu?” ");
INSERT INTO mri_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ā, nō te taenga mai o aua tāngata ki a ia, ka mea, “Kua tonoa mai māua e Hoani Kai­iri­iri ki a koe, mea ai, Ko koe rānei tērā e haere mai ana? Me tatari rānei tātou ki tētahi atu?” ");
INSERT INTO mri_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","I taua wā pū anō he toko­maha te hunga i whaka­ora­ngia e ia i ngā tū­roro­tanga, i ngā mate, i ngā wairua kino; he toko­maha ngā matapō i meinga kia kite. ");
INSERT INTO mri_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ā, ka whaka­hoki ia, ka mea ki a rāua, “Haere, kōrero­tia ki a Hoani ngā mea e kite nei, e rongo nei kōrua; ko ngā matapō e ti­tiro ana, ko ngā kopa e hāere­ere ana, ko ngā repera kua mā, ko ngā turi e rongo ana, ko ngā tū­pā­paku e whaka­ara­hia ana, e kauwhau­tia ana te rongo­pai ki te hunga rawa­kore; ");
INSERT INTO mri_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","nā, ka koa te tangata e kore e hē ki ahau.” ");
INSERT INTO mri_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ā, nō te riro­nga atu o ngā karere a Hoani, ka tīmata ia ki te kōrero ki te mano mō Hoani: “I haere atu koutou ki te koraha kia kite i te aha? I te kākaho e whaka­ngāue­ue­tia ana e te hau? ");
INSERT INTO mri_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Anō rā, i haere koutou kia kite i te aha? I te tangata he kākahu māeneene ōna? Nā, kei ngā whare kīngi te hunga i ngā kākahu whaka­pai­pai, i ngā kai papai. ");
INSERT INTO mri_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Anō rā, i haere koutou kia kite i te aha? I te poro­piti? Āe rā, ko tāku kupu tēnei ki a koutou, tērā atu i te poro­piti. ");
INSERT INTO mri_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mōna te mea kua tuhi­tuhia nei, ‘Nā, ka tonoa e ahau tāku karere ki mua i tōu aro­aro, māna e whaka­pai tōu hua­rahi i mua i a koe.’ ");
INSERT INTO mri_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ko tāku kupu hoki tēnei ki a koutou, kāhore he poro­piti nui atu i a Hoani Kai­iri­iri i roto i ngā whānau a te wahine; heoi, rahi ake i a ia te nohi­nohi rawa o te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nā, i tō rātou rongo­nga ai, whaka­tikaia ana tā te Atua e te hunga katoa i rongo, e ngā pupiri­kana anō, i iri­iria hoki rātou ki te iri­iri a Hoani. ");
INSERT INTO mri_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ko ngā Parihi ia rātou ko ngā kai­whaka­ako o te ture i whaka­kāhore i tā te Atua whaka­aro ki a rātou, kīhai nei rātou i iri­iria e ia. ");
INSERT INTO mri_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Me whaka­rite e ahau ngā tāngata o tēnei whaka­papa­ranga ki te aha? He rite rātou ki te aha? ");
INSERT INTO mri_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","He rite ki ngā tama­riki e noho ana i te kāinga hoko­hoko, e karanga ana ki a rātou anō, e mea ana, ‘Whaka­tangi noa mātou i te pūtō­rino ki a koutou, ā, kāhore koutou i kani­kani. Auē noa mātou ki a koutou, nā, kāhore koutou i tangi.’ ");
INSERT INTO mri_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","I haere mai hoki a Hoani Kai­iri­iri, kīhai i kai taro, kīhai i inu wāina; heoi ka mea koutou, ‘He rēwera tōna.’ ");
INSERT INTO mri_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","I haere mai te Tama a te tangata me te kai, me te inu; ā, ka mea koutou, ‘Nā, he tangata kakai, he tangata inu wāina, he hoa nō ngā pupiri­kana, nō ngā tāngata hara!’ ");
INSERT INTO mri_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Otirā, e whaka­tikaia ana te whaka­aro nui e āna tama­riki katoa.” ");
INSERT INTO mri_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nā, ka mea tētahi o ngā Parihi ki a ia kia kai tahi rāua. Ā, ka tomo ia ki te whare o te Parihi, ka noho. ");
INSERT INTO mri_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nā, tērā tētahi wahine hara o te pā ka mōhio, kei te whare o te Parihi ia e noho ana; nā, ka kawea mai e ia tētahi pouaka kōhatu, he hinu i roto. ");
INSERT INTO mri_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ā, tū tangi ana i muri i ōna wae­wae, ka anga ka whaka­mākūkū i ōna wae­wae ki ōna roi­mata, ka muru ki ngā makawe o tōna māte­nga, ka kihi i ōna wae­wae, ka whaka­wahi ki te hinu kakara. ");
INSERT INTO mri_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nā, i te kite­nga o te Parihi nāna rā ia i karanga, ka kōrero i roto i a ia, ka mea, “Me he poro­piti tēnei, kua mātau ia ki te wahine e pā nei ki a ia, tōna pēhea­tanga; he wahine hara hoki.” ");
INSERT INTO mri_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nā, ka kōrero a Īhu, ka mea ki a ia, “E Haimona, he kupu tāku ki a koe.” Ka mea ia, “Kōrero, e te Kai­whaka­ako.” ");
INSERT INTO mri_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Nā, toko­rua ngā tāngata i a rāua te moni a tētahi kai­tuku moni; e rima rau ngā pene i tētahi, e rima tekau i tētahi. ");
INSERT INTO mri_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","I te kore ngā mea a rāua hei whaka­utu, whaka­rērea noatia ana e ia ki a rāua; tēnā, ko wai o rāua e tino nui tōna aroha ki a ia?” ");
INSERT INTO mri_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nā, ka whaka­hoki a Haimona, ka mea, “Ki tōku whaka­aro, ko te tangata nāna te mea nui i whaka­rērea noatia atu.” Nā, ko tāna mea­tanga ki a ia, “Tika rawa tāu.” ");
INSERT INTO mri_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nā, ka tahuri ia ki te wahine, ka mea ki a Haimona, “E kite ana koe i tēnei wahine? I haere mai ahau ki roto ki tōu whare, kāhore i hōmai e koe he wai mō ōku wae­wae; nāna ia i whaka­mākūkū ōku wae­wae ki ōna roi­mata, ā, murua iho ki ngā makawe o tōna māte­nga. ");
INSERT INTO mri_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kīhai koe i kihi i ahau; tēnā ko ia, mai o tōku taenga mai, kāhore anō i tāmutu te kihi i ōku wae­wae. ");
INSERT INTO mri_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kīhai koe i whaka­wahi i tōku māte­nga ki te hinu; nāna ia ōku wae­wae i whaka­wahi ki te hinu. ");
INSERT INTO mri_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Koia ahau ka mea nei ki a koe, kua murua ōna tini hara; he nui hoki tōna aroha; ko te tangata ia he iti ngā mea i murua ka iti anō tōna aroha.” ");
INSERT INTO mri_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ā, ka mea ia ki a ia, “Kua murua ōu hara.” ");
INSERT INTO mri_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nā, ka anga ōna hoa noho ka kōrero ki a rātou anō, “Ko wai tēnei, muru rawa hoki i ngā hara?” ");
INSERT INTO mri_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nā, ko tāna mea­tanga ki te wahine, “Nā, tōu whaka­pono koe i ora ai; haere mārie.” ");
INSERT INTO mri_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ā muri tata iho ka hāere­ere anō ia ki ngā pā ki ngā kāinga, ka kauwhau, ka whaka­puaki i te rongo­pai o te ranga­tira­tanga o te Atua. I a ia hoki te tekau mā rua, ");
INSERT INTO mri_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","me ētahi wāhine kua oti nei te whaka­ora i ngā wairua kino, i ngā ngoi­kore­tanga. Ko Meri (e huaina ana ko Makarini), e whitu nei ngā rēwera i puta mai i roto i a ia, ");
INSERT INTO mri_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ko Hoana hoki, ko te wahine a Kūha, a te kai­whaka­hau­hau a Herora, me Huhana, me te toko­maha noa atu. Nā rātou i mahi ētahi o ā rātou taonga hei mea mā rātou. ");
INSERT INTO mri_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nā, ka rahi te hui i mine mai, ā, ka haere mai ki a ia o ia pā, o ia pā, ka kōrero kupu whaka­rite ia: ");
INSERT INTO mri_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“I haere atu te kairui ki te rui i tāna pura­pura; ā, i a ia e rui ana, ka nga­horo ētahi ki te taha o te ara; ā, taka­hia ana ki raro, kainga ake e ngā manu o te rangi. ");
INSERT INTO mri_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ko ētahi i nga­horo ki runga ki te toka; ko te tupu­nga ake, kua maroke, kāhore hoki he mākūkū. ");
INSERT INTO mri_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ko ētahi i nga­horo ki roto ki ngā tā­tarā­moa; ā, tupu tahi ana ngā tā­tarā­moa, kōwao­wao­tia iho. ");
INSERT INTO mri_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ko ētahi i nga­horo ki te one­one pai; tupu ana, tā­taki­rau ngā hua.” Ka mutu ēnei kōrero, ka karanga ia, “Ko ia he tari­nga ōna hei whaka­rongo, kia rongo ia.” ");
INSERT INTO mri_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nā, ka ui āna ākonga ki a ia, ka mea, “He aha te tikanga o tēnei kupu whaka­rite?” ");
INSERT INTO mri_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ka mea ia, “Kua hoatu ki a koutou te mātau­ranga ki ngā mea ngaro o te ranga­tira­tanga o te Atua; ki ērā atu ia, he whaka­rite ngā kupu. Kia kite ai rātou, ā, e kore e kite, kia rongo ai, ā, kore ake e mātau.” ");
INSERT INTO mri_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nā, tēnei te kupu whaka­rite: Ko te pura­pura ko te kupu a te Atua. ");
INSERT INTO mri_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ko ērā i te hua­rahi, ko ngā kai­whaka­rongo; me i reira ka haere mai te rēwera, ka kapo i te kupu i roto i ō rātou ngākau, kei whaka­pono rātou, ā, ka ora. ");
INSERT INTO mri_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ko ērā i runga i te toka ko te hunga i tango i te kupu me te hari anō i tō rātou rongo­nga. Otirā kāhore ō rātou paki­aka, ka whaka­pono mō te wā poto nei, ā, i te wā o te whaka­mā­tau­tau ka taka atu. ");
INSERT INTO mri_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ko tērā i nga­horo ki roto ki ngā tā­tarā­moa, ko te hunga e whaka­rongo ana, ā, ko te haere­nga atu, ka kōwao­wao­tia e ngā mā­nuka­nuka, e ngā taonga, e ngā whaka­ahua­reka o te ao, ā, hore ake e pakari ō rātou hua. ");
INSERT INTO mri_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ko tērā i te one­one pai, ko te hunga e tika ana, e pai ana te ngākau, i te rongo­nga i te kupu, ka pupuri, ā, hua ana ngā hua i runga i te manawa­nui.” ");
INSERT INTO mri_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“E kore e tahuna te rama e tētahi, e hīpoki­na ki te oko, e waiho rānei i raro i te moenga; engari, ka whaka­tū­ria ki runga ki te tū­ranga, kia kitea ai te mārama e te hunga e tomo ana. ");
INSERT INTO mri_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“E kore hoki tētahi mea i huna, e mahue te whaka­kite; e kore anō tētahi mea i ngaro, e mahue te mōhio, te puta hoki ki te mārama. ");
INSERT INTO mri_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nā reira kia tūpato tā koutou whaka­rongo. Ki te whai mea hoki tētahi, ka hoatu anō ki a ia; ki te kāhore he mea a tētahi, ko te mea i mahara ai ia nāna ake, ka tango­hia i a ia.” ");
INSERT INTO mri_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nā, ka haere mai ki a ia tōna whaea, me ōna tēina, otirā, kāhore rātou i āhei te tutuki mai ki a ia, i te pipiri o te tangata. ");
INSERT INTO mri_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nā, ka kōrero­tia ki a ia, “Ko tōu whaea me ōu tēina te tū mai nei i waho, e mea ana kia kite i a koe.” ");
INSERT INTO mri_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Otirā, ka whaka­hoki ia, ka mea ki a rātou, “Ko ēnei, e whaka­rongo nei, ā, e mahi nei i te kupu a te Atua, tōku whaea me ōku tēina.” ");
INSERT INTO mri_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nā, i tētahi o aua rā ka eke ia, rātou ko āna ākonga ki te kai­puke, ā, ka mea ia ki a rātou, “Tātou ka whaka­whiti ki tāwāhi o te roto.” Nā, rere ana rātou. ");
INSERT INTO mri_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Otirā, i a rātou e rere ana, ka moe ia. Nā, ko te pu­tanga o tētahi hau, he tūpuhi, ki te roto; ā, ka tomo rātou, tata pū te totohu. ");
INSERT INTO mri_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nā, ka haere rātou, ka whaka­ara i a ia, ka mea, “E kara, e kara, ka mate tātou!” Nā, ka ara ia, ā, rīria ana e ia te hau, me te ngaru o te moana; ā, mutu iho, nā, kua marino. ");
INSERT INTO mri_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nā, ka mea ia ki a rātou, “Kei hea tō koutou whaka­pono?” Mataku ana rātou, mīharo ana, ka mea ki a rātou anō, “Ko wai rā tēnei, ka tapa nei ki ngā hau, ki te moana, ā, rongo rawa ki a ia?” ");
INSERT INTO mri_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nā, ka tae rātou ki te whenua o ngā Kararini, ki tāwāhi atu o Kariri. ");
INSERT INTO mri_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ā, nō tōna haere­nga atu ki uta, ka tūtaki ki a ia he tangata nō te pā, he rēwera ōna, he roa kāhore anō i mau kākahu, kīhai anō i noho i roto i te whare, engari ki ngā urupā. ");
INSERT INTO mri_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ā, i tōna kite­nga i a Īhu, ka karanga, ka takoto ki tōna aro­aro, he nui tōna reo ki te mea, “He aha tāku ki a koe e Īhu, e te Tama a te Atua, a te Runga Rawa? Ē, kaua rā ahau e whaka­mamae­tia.” ");
INSERT INTO mri_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I mea hoki ia ki te wairua poke kia puta i taua tangata. He maha hoki ngā wā i hopu­kia ai ia e ia, e tiaki­na ana hoki ia, he mea here ki ngā meka­meka, ki ngā here wae­wae; heoi, motu­motu­hia ana e ia ngā here, ā, āia ana ia e te rēwera ki te koraha. ");
INSERT INTO mri_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nā, ka ui a Īhu ki a ia, “Ko wai tōu ingoa?” Ka mea ia, “Ko Rihiona,” he toko­maha hoki ngā rēwera i tomo ki roto ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kātahi ka īnoi rātou ki a ia kia kaua rātou e tonoa e ia kia haere ki te hōhonu. ");
INSERT INTO mri_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nā, i reira tētahi kāhui poaka maha e kai ana i runga i te maunga; ā, ka īnoi rātou ki a ia kia tukua rātou kia tomo ki aua poaka. Ā, tukua ana rātou. ");
INSERT INTO mri_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ā, ko te pu­tanga o aua rēwera i roto i te tangata, ka tomo ki roto ki ngā poaka, nā, ko te tino rere­nga o te kāhui rā te pari ki te moana, ā, paremo iho. ");
INSERT INTO mri_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ā, nō ka kite ngā kai­whāngai i taua mea i meatia, ka whati, ka haere ka kōrero ki te pā, ki aua whenua hoki. ");
INSERT INTO mri_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nā, ka haere rātou kia kite i taua mea i meatia, ā, i tō rātou taenga mai ki a Īhu, ka kite i te tangata i puta nei ngā rēwera i roto i a ia, kua oti te whaka­kākahu, kua tika ōna whaka­aro, e noho ana i ngā wae­wae o Īhu, ā, ka mataku rātou. ");
INSERT INTO mri_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ā, kōrero­tia ana ki a rātou e te hunga i kite, te whaka­ora­nga o te tangata i ngā rēwera. ");
INSERT INTO mri_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nā, ka mea te hui­hui katoa o ngā kāinga pātata o ngā Kararini kia mawehe atu ia i a rātou, i mataku whaka­hara­hara hoki rātou; ā, eke ana ia ki te kai­puke, hoki ana. ");
INSERT INTO mri_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Otirā, ka īnoi ki a ia te tangata i puta rā ngā rēwera i roto i a ia, kia waiho ia hei hoa mōna. Heoi, ka tono atu a Īhu i a ia, ka mea, ");
INSERT INTO mri_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hoki atu ki tōu whare, kōrero­tia ngā mea nui kua meinga nei e te Atua ki a koe.” Nā, haere ana ia, kōrero­tia ana ki te pā katoa ngā mea nui i mea ai a Īhu ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ā, i a Īhu i hoki ai, ka koa te mano, i te tatari katoa hoki rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nā, ka haere mai tētahi tangata, ko Hairuha te ingoa, he ranga­tira nō te whare kara­kia. Ā, takoto ana ki ngā wae­wae o Īhu, ka īnoi ki a ia kia tomo ki tōna whare. ");
INSERT INTO mri_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kotahi tāna tamā­hine, he hua­tahi kei te tekau mā rua ōna tau, nā, e whaka­hemo­hemo ana. Nā, i tōna haere­nga atu, ka popō ngā mano ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nā, tērā tētahi wahine e mate ana i te pākaru­hanga toto, tekau mā rua ngā tau, ā, poto katoa tōna oranga ki ngā rata, kīhai rawa i taea te whaka­ora e tētahi. ");
INSERT INTO mri_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ka haere ia i muri i a ia, ka pā ki te tāniko o tōna kākahu; ā, mutu iho te rere o ōna toto. ");
INSERT INTO mri_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nā, ka mea a Īhu, “Ko wai tēnei kua pā nei ki ahau?” Ā, nō ka whaka­kāhore katoa, ka mea a Pita rātou ko ōna hoa, “E kara, e pipiri ana ngā mano ki a koe, e tute­tute ana.” ");
INSERT INTO mri_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Otirā, i mea a Īhu, “Ehara, kua pā tētahi ki ahau; e mōhio ana ahau, kua puta atu he mana i ahau.” ");
INSERT INTO mri_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ā, nō te kite­nga o te wahine kīhai ia i ngaro, haere wiri ana, takoto ana i tōna aro­aro, kōrero­tia ana e ia ki a ia i te aro­aro o te iwi katoa te take i pā ai ia ki a ia, me te hohoro o tōna oranga. ");
INSERT INTO mri_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nā, ka mea ia ki a ia, “E kō, nā tōu whaka­pono koe i ora ai; haere mārie.” ");
INSERT INTO mri_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","I a ia anō e kōrero ana, ka haere mai tētahi i te whare o te ranga­tira o te whare kara­kia, ka mea ki a ia, “Kua mate tāu tamā­hine; kaua e whaka­raru­raru i te Kai­whaka­ako.” ");
INSERT INTO mri_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Otiia, i te rongo­nga o Īhu, ka whaka­hoki ki a ia, ka mea, “Kaua e mataku; ko te whaka­pono ia kia whaka­pono, ā, ka ora ia.” ");
INSERT INTO mri_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ā, i tōna tomo­kanga ki te whare, kīhai tētahi i tukua e ia kia tapoko, ko Pita anake, ko Hēmi, ko Hoani, me te pāpā rāua ko te whaea o te kōtiro. ");
INSERT INTO mri_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","E tangi ana rātou katoa, e auē ana mōna. Nā, ka mea ia, “Kaua e tangi; kāhore ia i mate, engari e moe ana.” ");
INSERT INTO mri_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ā, kata­ina iho ia e rātou, i mōhio hoki rātou kua mate ia. ");
INSERT INTO mri_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Otirā, ka mau ia ki tōna ringa, ka karanga, ka mea, “E kō, e ara.” ");
INSERT INTO mri_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nā, hoki mai ana tōna wairua, ā, whaka­tika tonu ake ia. Nā ka whaka­hau­tia e ia kia hoatu he kai māna. ");
INSERT INTO mri_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ā, mīharo tonu ōna mātua; nā, ka whaka­tūpato ia i a rātou kia kaua e kōrero­tia taua mea­tanga ki tētahi. ");
INSERT INTO mri_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nā, ka karanga­tia e ia te tekau mā rua, ka hoatu ki a rātou he kaha, he mana, e peia ai ngā rēwera katoa, e ora ai ngā mate. ");
INSERT INTO mri_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ā, tonoa ana rātou e ia ki te kauwhau i te ranga­tira­tanga o te Atua, ki te whaka­ora hoki i te hunga e mate ana. ");
INSERT INTO mri_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I mea anō ia ki a rātou, “Kaua tētahi mea e mauria ki te ara, kaua he toko­toko, kaua he pūtea, kaua he taro, kaua he moni; kaua anō e taki­rua­tia he koti. ");
INSERT INTO mri_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ā, ka tomo koutou ki tētahi whare, hei reira noho ai, ā, haere noa i reira. ");
INSERT INTO mri_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ā, ki te kāhore ētahi e manako ki a koutou, ina haere atu koutou i taua pā, ruia atu te puehu o ō koutou wae­wae, hei mea whaka­atu ki a rātou.” ");
INSERT INTO mri_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nā, ko tō rātou mawehe­tanga atu, ka hāere­erea e rātou ngā kāinga, me te kauwhau i te rongo­pai, me te whaka­ora i ngā wāhi katoa. ");
INSERT INTO mri_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ā, ka rongo a Herora teta­raki i ngā mea katoa i meinga e ia; ā, he nui tōna poro­raru, nō te mea ki tā ētahi kī, kua ara mai a Hoani i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ki tā ētahi, kua puta mai a Irāia; ki tā ētahi, kua ara mai tētahi o ngā poro­piti ona­mata. ");
INSERT INTO mri_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nā, ka mea a Herora, “I pōutoa e ahau te māte­nga o Hoani; ko wai hoki tēnei mōna nei ēnei kōrero ka rangona nei e ahau?” Ā, ka whai ia kia kite i a ia. ");
INSERT INTO mri_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ā, nō te hoki­nga mai o ngā āpō­toro, ka kōrero­tia ki a ia ngā mea katoa i mea ai rātou. Ā, ka tango ia i a rātou, ka haere ko rātou anake ki tētahi pā, ko Petahaira te ingoa. ");
INSERT INTO mri_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Otirā, i te kite­nga o ngā mano, ka aru i a ia; ā, ka manaaki ia i a rātou, ka kōrero­tia ki a rātou te ranga­tira­tanga o te Atua, whaka­ora­ngia ana hoki e ia te hunga e mea ana kia rongoā­tia. ");
INSERT INTO mri_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nā, kua tītaha haere te rā; ā, ka haere mai te tekau mā rua, ka mea ki a ia, “Tonoa te mano, kia haere ai ki ngā kāinga, ki ngā whenua i tētahi taha, i tētahi taha, moe ai, ki te mea kai hoki mā rātou; he wāhi koraha hoki tēnei i a tātou nei.” ");
INSERT INTO mri_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ā, ka mea ia ki a rātou, “Mā koutou e hoatu he kai mā rātou.” Ka mea rātou, “Heoi anō a mātou e rima ngā taro, e rua ngā ika; ki te kāhore anō ia mātou e haere ki te hoko kai mā tēnei iwi katoa.” ");
INSERT INTO mri_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Me te mea anō, e rima mano ngā tāne.) Ka mea ia ki āna ākonga, “Meinga rātou kia noho, kia rima tekau ki te nohoa­nga.” ");
INSERT INTO mri_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ā, pērā ana rātou, meinga katoa­tia ana kia noho. ");
INSERT INTO mri_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nā, ka mau ia ki ngā taro e rima, ki ngā ika e rua, ka ti­tiro ake ki te rangi, ka whaka­pai i aua mea, ka whawhati, ka hoatu ki ngā ākonga kia whaka­takoto­ria atu mā te mano. ");
INSERT INTO mri_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nā, ka kai rātou, ka mākona katoa; ā, kotahi tekau mā rua ngā kete i kohia ake e rātou, he toenga nā rātou nō ngā whati­whatinga. ");
INSERT INTO mri_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ā, i a ia e īnoi ana ko ia anake, i a ia anō āna ākonga; nā, ka ui ia ki a rātou, ka mea, “Ko wai ahau ki te kī a te mano?” ");
INSERT INTO mri_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nā, ka whaka­hoki rātou, ka mea, “Ko Hoani Kai­iri­iri, ki tā ētahi ia; ko Irāia, ki tā ētahi; kua ara mai tētahi o ngā poro­piti ona­mata.” ");
INSERT INTO mri_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nā, ka mea ia ki a rātou, “Ki tā koutou nā kī, ko wai ahau?” Ka whaka­hoki a Pita, ka mea, “Ko te Karaiti a te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kātahi ia ka whaka­tūpato i a rātou, ka mea, “Kia kaua tēnei e kōrero­tia ki te tangata.” ");
INSERT INTO mri_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","I mea anō ia, “Kua takoto te tikanga kia maha ngā mamae o te Tama a te tangata, kia whaka­kāhore­tia anō ia e ngā kaumātua, e ngā tohu­nga nui, e ngā kara­ipi, kia whaka­matea, ā, i te toru o ngā rā ka whaka­ara­hia.” ");
INSERT INTO mri_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","I mea anō ia ki a rātou katoa, “Ki te mea tētahi kia haere mai i muri i ahau, me whaka­kāhore ia e ia anō, me amo tōna rīpeka i ngā rā katoa, ka aru ai i ahau. ");
INSERT INTO mri_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ki te whai hoki tētahi kia ora, ka mate ia; otirā, ki te mate tētahi, mōna i whaka­aro ki ahau, ka ora ia. ");
INSERT INTO mri_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","He aha oti te pai ki te tangata, ki te riro i a ia te ao katoa, ā, ka ngaro ko ia anō, ka riro rānei i te hē? ");
INSERT INTO mri_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ki te whaka­mā hoki tētahi ki ahau, ā, ki āku kōrero, ka whaka­mā anō te Tama a te tangata ki a ia, ina haere mai ia i runga i tōna ake korōria, i te korōria hoki o te Matua, o ngā ana­hera tapu. ");
INSERT INTO mri_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nā, he pono tāku kōrero ki a koutou, tēnei anō ētahi o te hunga e tū nei e kore e pāngia e te mate, kia kite rā anō i te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ā, ka tata ki te waru o ngā rā i muri i ēnei kōrero, ka mau ia ki a Pita, ki a Hoani, ki a Hēmi, ka haere ki runga ki te maunga ki te īnoi. ");
INSERT INTO mri_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ā, i a ia e īnoi ana, ka puta kē te āhua o tōna mata, mā tonu tōna kākahu, kanapa tonu. ");
INSERT INTO mri_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nā, toko­rua ngā tāngata e kōrero tahi ana me ia, ko Mohi rāua ko Irāia, ");
INSERT INTO mri_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","i puta korōria mai, i kōrero anō ki tōna mate­nga meāke nei rite i a ia ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","I pēhia hoki a Pita rātou ko ōna hoa e te moe; ā, i tō rātou aranga ake, ka kite i tōna korōria, me ngā tāngata toko­rua e tū tahi ana me ia. ");
INSERT INTO mri_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ā, i a rāua e mawehe atu ana i a ia, ka mea a Pita ki a Īhu, “E kara, he pai kia noho tātou i konei; nā, kia hangā e mātou ētahi wharau kia toru; kia kotahi mōu, kia kotahi mō Mohi, kia kotahi mō Irāia.” (Kīhai ia i mōhio ki tāna i kōrero ai.) ");
INSERT INTO mri_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ā, i a ia e kōrero ana i ēnei mea, ka puta he kapua, ā, tau­maru iho ana ki a rātou; ā, mataku ana rātou i tō rātou haere­nga ki roto ki te kapua. ");
INSERT INTO mri_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nā, ka puta mai he reo i te kapua e mea ana, “Ko tāku Tama tēnei, ko tāku i whiri­whiri ai; whaka­rongo ki a ia!” ");
INSERT INTO mri_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ā, nō te pu­tanga o te reo, ko Īhu anake i kitea. Ā, whaka­rongo puku ana rātou, kīhai hoki i kōrero­tia e rātou ki te tangata i aua rā tētahi o ngā mea i kite ai rātou. ");
INSERT INTO mri_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nā, i te aonga ake o te rā, i a rātou kua tatū iho i runga i te maunga, he rahi te hui i tūtaki ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nā, ka karanga tētahi tangata i roto i te mano, ka mea, “Tēnā koa, e te Kai­whaka­ako, ti­tiro mai ki tāku tama; ko ia anake hoki tāku. ");
INSERT INTO mri_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nā, ka hopu te wairua i a ia, ina­mata ka hāmama. Nā, ka hae­hae i a ia, tutū ana te huka i a ia. Whaka­uaua ana te whaka­rere i a ia, ā, marū iho ia. ");
INSERT INTO mri_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ā, i te īnoi ahau ki āu ākonga kia peia ia ki waho; heoi, kīhai i taea e rātou.” ");
INSERT INTO mri_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nā, ka whaka­hoki a Īhu, ka mea, “E te uri whaka­pono kore, parori kē, kia pēhea te roa o tōku noho ki a koutou, o tōku manawa­nui ki a koutou? Kawea mai tāu tama ki konei.” ");
INSERT INTO mri_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nā, i a ia e haere mai ana, ka tāia iho ia e te rēwera, hae­haea iho. Nā, ka rīria te wairua poke e Īhu, ā, whaka­ora­ngia ana te tama­iti, hoatu ana ki tōna pāpā. ");
INSERT INTO mri_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Oho mauri katoa ana rātou ki te nui o te Atua. Ā, i a rātou e mīharo ana ki ngā mea katoa i meinga e Īhu, ka mea ia ki āna ākonga, ");
INSERT INTO mri_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Rongoātia ēnei kōrero ki roto ki ō koutou tari­nga; meāke hoki tukua te Tama a te tangata ki ngā ringa o ngā tāngata.” ");
INSERT INTO mri_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Otirā, kīhai rātou i mōhio ki tēnei kupu, he mea huna hoki i a rātou, kei kite rātou; i mataku hoki rātou ki te ui ki a ia i taua kupu. ");
INSERT INTO mri_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nā, ka puta ake he kōrero­rero i roto i a rātou, ko wai o rātou te mea nui rawa. ");
INSERT INTO mri_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Otirā, i te kite­nga o Īhu i te whaka­aro­aro­nga a ō rātou ngākau, ka mau ia ki tētahi tama­iti nohi­nohi, ā, whaka­tū­ria ana ki tōna taha, ");
INSERT INTO mri_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ka mea ki a rātou, “Ki te manako tētahi ki tēnei tama­iti, nā te whaka­aro hoki ki tōku ingoa, e manako ana ia ki ahau. Ki te manako hoki tētahi ki ahau, e manako ana ia ki tōku kai­tono mai. Nā, ko te iti rawa i roto i a koutou katoa ko ia hei mea nui.” ");
INSERT INTO mri_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nā, ka whaka­hoki a Hoani, ka mea, “E kara, i kite mātou i tētahi e pei rēwera ana i runga i tōu ingoa; ā, rīria iho e mātou, mōna kāhore e haere tahi tātou.” ");
INSERT INTO mri_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Otirā, i mea a Īhu ki a ia, “Kaua e rīria; ki te mea hoki ehara tētahi i te hoa whawhai nō koutou, nō koutou ia.” ");
INSERT INTO mri_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ā, nō ka tata ngā rā mō tōna tango­hanga ki runga, ka whaka­mau tōna kanohi ki te haere ki Hiruhārama, ");
INSERT INTO mri_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ā, ka tonoa atu e ia he karere i mua i tōna aro­aro; ā, ka haere rātou, ka tomo ki tētahi kāinga o ngā Hamari ki te mea tuku­nga iho mōna. ");
INSERT INTO mri_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Heoi, kīhai ērā i manako ki a ia, ko te āhua hoki o tōna kanohi me te mea e haere ana ia ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ā, nō te kite­nga o āna ākonga, o Hēmi rāua ko Hoani, ka mea rāua, “E te Ariki, e pai ana rānei koe kia kōrero­tia e māua he kāpura kia heke iho i te rangi, hei whaka­ngaro i a rātou?” ");
INSERT INTO mri_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Otirā, ka tahuri ia, ka rīria rāua, “Kāhore kōrua e mātau nō tēhea wairua kōrua. ");
INSERT INTO mri_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kīhai hoki te Tama a te tangata i haere mai ki te whaka­mate tangata, engari ki te whaka­ora.” Nā, haere ana rātou he kāinga kē. ");
INSERT INTO mri_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ā, i a rātou e haere ana i te ara, ka mea tētahi tangata ki a ia, “Ka aru ahau i a koe ki ngā wāhi katoa e haere ai koe.” ");
INSERT INTO mri_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nā, ko te mea­tanga a Īhu ki a ia, “He rua o ngā pokiha, he kō­hanga o ngā manu o te rangi; tēnā ko te Tama a te tangata hore ōna wāhi e takoto ai tōna māte­nga.” ");
INSERT INTO mri_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ka mea ia ki tētahi atu, “Aru­mia mai ahau.” Ā, ka mea ia, “E te Ariki, tukua ahau kia mātua haere ki te tanu i tōku pāpā.” ");
INSERT INTO mri_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nā, ka mea a Īhu ki a ia, “Waiho mā ngā tū­pā­paku e tanu ō rātou nā tū­pā­paku. Ko koe ia me haere ki te kauwhau i te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ka mea hoki tētahi atu, “E te Ariki, ka aru ahau i a koe; otirā, tukua ahau kia mātua poro­poro­aki ki te hunga i tōku whare.” ");
INSERT INTO mri_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Otirā, ka mea a Īhu ki a ia, “Ki te pā te ringa o tētahi ki te parau, ā, ka ti­tiro ki muri, e kore ia e tau mō te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nā, i muri i ēnei mea ka whaka­ritea e te Ariki ētahi atu e whitu tekau, ā, tonoa ana rātou taki­rua, taki­rua, i mua i a ia ki ngā pā katoa, ki ngā wāhi meāke nei ia haere ki reira. ");
INSERT INTO mri_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","I mea anō ia ki a rātou, “He nui te kotinga, ko ngā kai­mahi ia he rua­rua; nā īnoi atu ki te Ariki nāna te kotinga, kia tonoa e ia he kai­mahi ki tāna kotinga. ");
INSERT INTO mri_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Haere! Nana, ka tonoa nei koutou e ahau, ānō he reme ki waenga­nui o ngā wuruhi. ");
INSERT INTO mri_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kaua e mauria he takoto­ranga moni, kaua he pūtea, kaua he hū; kaua anō e oha atu ki tētahi i te hua­rahi. ");
INSERT INTO mri_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ki te tomo koutou ki tētahi whare, mātua mea atu, ‘Kia tau te rangi­mārie ki tēnei whare.’ ");
INSERT INTO mri_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ā, ki te mea kei reira te tama a te rangi­mārie, ka tau tā koutou rangi­mārie ki a ia; ki te kāhore, e hoki anō ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nā, hei taua whare koutou noho ai, kai ai, inu ai i tā rātou e hōmai ai; ka tika hoki te utu mō te kai­mahi. Kaua e hāere­ere i tēnei whare ki tērā whare. ");
INSERT INTO mri_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ka tomo koutou ki tētahi pā, ā, ka manako rātou ki a koutou, kainga ngā mea e whaka­takoto­ria ana mā koutou. ");
INSERT INTO mri_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Me whaka­ora te hunga mate o reira, ka mea ki a rātou, ‘Kua tata ki a koutou te ranga­tira­tanga o te Atua.’ ");
INSERT INTO mri_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tēnā, ki te tomo koutou ki tētahi pā, ā, e kore rātou e manako ki a koutou, me haere atu ki ngā hua­rahi o reira, me kī atu, ");
INSERT INTO mri_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nā, ko te puehu o tō koutou pā e piri nei ki a mātou, tēnei ka tahia atu nei e mātou ki a koutou; otirā, kia mōhio koutou ki tēnei, kua tata ki a koutou te ranga­tira­tanga o te Atua.’ ");
INSERT INTO mri_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ko tāku kupu tēnei ki a koutou, Engari tō Horoma i taua rā e māmā i tō taua pā.” ");
INSERT INTO mri_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Auē, te mate mōu, e Kora­hina! Auē, te mate mōu, e Petahaira! Me i meatia hoki ki Tāira, ki Hairona ngā mere­kara kua meatia nei ki a kōrua, kua rīpe­netā kē rāua, he tara­tara hoki te kākahu, me te noho i roto i te punga­rehu. ");
INSERT INTO mri_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Otirā, erangi tō Tāira, tō Hairona i te whaka­wā e māmā i tō kōrua. ");
INSERT INTO mri_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ā, ko koe, e Kaperenauma, tērā koe e ike­ike, ā, tae noa ki te rangi? Ka whaka­takā koe ki te rēinga. ");
INSERT INTO mri_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Ki te whaka­rongo tētahi ki a koutou, e whaka­rongo ana ia ki ahau; ki te whaka­kāhore tētahi ki a koutou, e whaka­kāhore ana ia ki ahau; ki te whaka­kāhore tētahi ki ahau, e whaka­kāhore ana ki tōku kai­tono mai.” ");
INSERT INTO mri_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nā, hoki hari ana te whitu tekau, ka mea, “E te Ariki, rongo tonu ngā rēwera nei ki a mātou, he mea nā tōu ingoa!” ");
INSERT INTO mri_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ka mea ia ki a rātou, “I kite ahau i a Hātana, me te mea he uira te taka­nga i te rangi. ");
INSERT INTO mri_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nā, ka hoatu nei e ahau ki a koutou he mana e takahi ai koutou i runga i ngā nākahi, i ngā kopi­ona, i te kaha katoa anō o te hoa whawhai; ā, e kore rawa koutou e mate i tētahi mea. ");
INSERT INTO mri_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Otirā, kaua e hari ki tēnei, ki ngā wairua ka riro nei ki raro i a koutou; ko tā koutou ia e tino hari ai, ko ō koutou ingoa kua oti te tuhi­tuhi ki te rangi!” ");
INSERT INTO mri_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","I taua wā anō ka hari ia i te Wairua Tapu, ka mea, “Ka whaka­whetai ahau ki a koe, e Pā, e te Ariki o te rangi, o te whenua, kua hunā nei hoki e koe ēnei mea i te hunga mātau, i te hunga mahara, ā, whaka­kitea ana ki ngā kō­hunga­hunga; āe rā, e Pā, i pai hoki te pēnei ki tāu ti­tiro. ");
INSERT INTO mri_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Kua oti ngā mea katoa te tuku ki ahau e tōku Matua; e kore anō tētahi e mātau ki te Tama ko wai ia, ko te Matua anake; ko wai rānei te Matua, ko te Tama anake, me te tangata anō hoki e pai ai te Tama kia whaka­kitea ia.” ");
INSERT INTO mri_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nā, ka tahuri ia ki ngā ākonga, ka mea puku atu, “Ka hari ngā kanohi e kite ana i ngā mea e kite nei koutou! ");
INSERT INTO mri_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ko tāku kupu hoki tēnei ki a koutou, he toko­maha ngā poro­piti me ngā kīngi i hia­hia kia kite i ngā mea e kite nei koutou, ā, kāhore i kite; kia rongo anō i ngā mea e rongo nei koutou, ā, kāhore i rongo.” ");
INSERT INTO mri_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nā, ka whaka­tika tētahi kai­whaka­ako o te ture, ka whaka­mā­tau­tau i a ia, ka mea, “E te Kai­whaka­ako, me aha ahau ka whi­whi ai ki te ora tonu?” ");
INSERT INTO mri_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ka mea ia ki a ia, “He aha te mea i tuhi­tuhia ki te ture? Ka pēhea tāu kōrero?” ");
INSERT INTO mri_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nā, ka whaka­hoki ia, ka mea, “‘Kia whaka­paua tōu ngākau, tōu wairua, tōu kaha, tōu hine­ngaro, ki te aroha ki te Ariki, ki tōu Atua; me aroha hoki ki tōu hoa tata ānō ko koe.’ ” ");
INSERT INTO mri_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ka mea ia ki a ia, “Ka tika tāu kōrero; meinga tēnei, ā, ka ora koe.” ");
INSERT INTO mri_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Otirā, ka mea ia ki te whaka­tika i a ia, ka kī atu ki a Īhu, “Ko wai rā tōku hoa tata?” ");
INSERT INTO mri_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nā, ka whaka­hoki a Īhu, ka mea, “E haere iho ana tētahi tangata i Hiruhārama ki Heriko, ā, ka tūtaki ki ngā kai­pāhua, nā, ka huia ōna e rātou, ka tuki­tukia ia, ā, haere ana, whaka­rērea iho ia, me te mea kua mate. ");
INSERT INTO mri_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nā, ko tētahi tohu­nga e haere noa ana i taua ara, ā, i tōna kite­nga i a ia, ni­nihi kē ana nā tahaki. ");
INSERT INTO mri_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","I pēnā hoki tētahi Rīwaiti, tae kau ki taua wāhi, ka haere, ka ti­tiro, ni­nihi kē ana nā tahaki. ");
INSERT INTO mri_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Otirā, ko tētahi Hamari e haere ana ki ngā whenua, i te taenga ki a ia, ka kite i a ia, ka aroha. ");
INSERT INTO mri_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nā, ka haere, ka takai i ōna patu­nga, ringi­hia iho ki te hinu, ki te wāina, ka whaka­noho i a ia ki tōna ake kararehe, ā, kawea ana ia ki te whare tira, ata­whai­tia ana ia. ");
INSERT INTO mri_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","I te aonga ake, i tōna haere­nga, ka tango­hia e ia e rua ngā pene, hoatu ana ki te tangata i te whare, ka mea ki a ia, ‘Māu ia e tiaki; ā, ki te maha atu āu mea e pau, māku koe e utu ina hoki mai ahau.’ ");
INSERT INTO mri_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Nā, ki tōu whaka­aro, ko wai o tēnei toko­toru te hoa ōna i tūtaki nei ki ngā kai­pāhua?” ");
INSERT INTO mri_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ka mea ia, “Ko tērā i ata­whai­tia ai ia.” Nā, ka mea a Īhu ki a ia, “Haere, kia pērā anō tāu mahi.” ");
INSERT INTO mri_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ā, i tō rātou haere­nga atu, ka tomo ia ki tētahi kāinga, nā, ko tētahi wahine ko Māta te ingoa, i whaka­manu­hiri i a ia ki tōna whare. ");
INSERT INTO mri_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","He teina anō tōna, ko Meri te ingoa. Nā, ka noho tēnei ki ngā wae­wae o Īhu, whaka­rongo ai ki tāna kupu. ");
INSERT INTO mri_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nā, raru­raru noa iho a Māta i te nui o te mahi tuari, ā, haere ana, ka mea, “E te Ariki, he mea noa oti ki a koe kia waiho e tōku teina māku anake te tuari? Nā, kōrero atu kia haere mai ia hei hoa mōku.” ");
INSERT INTO mri_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ka whaka­hoki te Ariki, ka mea ki a ia, “E Māta, e Māta, e mā­nuka­nuka ana koe, e raru­raru ana ki ngā mea maha. ");
INSERT INTO mri_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kotahi ia te mea e matea ana; ā, kua whiri­whiria e Meri tēnā wāhi pai, e kore nei e tango­hia i a ia.” ");
INSERT INTO mri_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ā, i a ia e īnoi ana i tētahi wāhi, ā, ka mutu, ka kī atu tētahi o āna ākonga ki a ia, “E te Ariki, whaka­akona mātou ki te īnoi, me Hoani hoki i whaka­ako rā i āna ākonga.” ");
INSERT INTO mri_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ka mea ia ki a rātou, “Ka īnoi koutou, mea atu: ‘E tō mātou Matua i te rangi, kia tapu tōu ingoa. Kia tae mai tōu ranga­tira­tanga, kia meatia tāu e pai ai ki runga ki te whenua, kia rite anō ki tō te rangi. ");
INSERT INTO mri_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hōmai tā mātou taro ki a mātou, tō tēnei rā, tō tēnei rā. ");
INSERT INTO mri_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Murua ō mātou hara; e murua ana hoki e mātou o ngā tāngata katoa e hara ana ki a mātou. Aua hoki mātou e kawea kia whaka­waia.’ ” ");
INSERT INTO mri_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","I mea anō ia ki a rātou, “Ko wai o koutou ki te mea he hoa tōna, ā, ka tae atu ki a ia i waenga­nui pō, ka mea ki a ia, ‘E hoa, hōmai ki ahau ētahi taro, kia toru. ");
INSERT INTO mri_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kua tae mai hoki tōku hoa ki ahau i te ara, kāhore āku mea e whaka­takoto ai ahau māna.’ ");
INSERT INTO mri_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ā, ka whaka­hoki tērā i roto, ka mea, ‘Hōhā kī! Kāti rā; kua tū­taki­na noatia ake te tatau, kei te moenga mātou ko āku tama­riki; e kore e āhei kia whaka­tika atu ahau ki te hoatu ki a koe.’ ");
INSERT INTO mri_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ko tāku kupu tēnei ki a koutou, ahakoa kāhore ia i whaka­tika ki te hoatu ki a ia, nō te mea he hoa nōna, mā tāna tohe anō ka ara ake ai ia, ka hoatu ai ki a ia i ngā mea i tonoa e ia. ");
INSERT INTO mri_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ko tāku kupu anō tēnei ki a koutou; īnoi, ā, ka hoatu ki a koutou; e rapu, ā, ka kite koutou; pā­tukia, ā, ka uakina ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ka whi­whi hoki ngā tāngata katoa ina īnoi; ka kite ina rapu; ka uakina ki te tangata e pātuki ana. ");
INSERT INTO mri_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ko tēhea matua o koutou ki te īnoia e tāna tama tētahi taro, e hoatu rānei ki a ia he kāmaka? Ki te īnoia he ika, e hoatu rānei ki a ia he nākahi hei ika? ");
INSERT INTO mri_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ki te īnoia he hua manu, e hoatu rānei ki a ia he kopi­ona? ");
INSERT INTO mri_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ki te mea ko koutou, hunga kino nei, e mātau ana ki te hoatu mea papai ki ā koutou tama­riki; tērā noa ake te hōmai­tanga o te Wairua Tapu e tō koutou Matua i te rangi ki te hunga e īnoi ana ki a ia.” ");
INSERT INTO mri_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nā, e pei rēwera ana ia, he mea wa­hangū anō hoki. Ā, nō te pu­tanga o te rēwera ki waho, ka kōrero te wa­hangū; ā, mīharo ana te mano. ");
INSERT INTO mri_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nā, ka mea ētahi o rātou, “Nā te ranga­tira o ngā rēwera, nā Perehepura, tāna peinga rēwera.” ");
INSERT INTO mri_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nā, ka whaka­mā­tau­tau ētahi, ka mea ki tētahi tohu i a ia i te rangi. ");
INSERT INTO mri_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Otiia, i mātau ia ki ō rātou whaka­aro, ā, ka mea ki a rātou, “Ki te tahuri iho tētahi ranga­tira­tanga ki a ia anō, ka kore; ki te tahuri hoki tētahi whare ki tētahi whare, ka hinga. ");
INSERT INTO mri_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ā, ki te tahuri iho a Hātana ki a ia anō, me pēhea e tū ai tōna ranga­tira­tanga? E mea nā hoki koutou, nā Perehepura tāku peinga rēwera. ");
INSERT INTO mri_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nā, ki te mea nā Perehepura tāku peinga rēwera, nā wai te peinga a ā koutou tama? Mō konei hei kai­whaka­wā rātou mō koutou. ");
INSERT INTO mri_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tēnā ki te mea nā te ringa o te Atua tāku peinga rēwera, inā, kua tae mai te ranga­tira­tanga o te Atua ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ki te tiaki­na e te tangata kaha, he patu nei āna, tōna whare, ka āta takoto āna taonga. ");
INSERT INTO mri_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ki te puta mai ia te mea e kaha atu ana i a ia, ā, ka hinga tērā, nā, ka tango­hia āna patu i whaka­manawa ai ia, ka tu­whatu­whaia ōna taonga. ");
INSERT INTO mri_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ko te tangata ehara i te hoa nōku, he hoa­riri ia ki ahau, ko te tangata kāhore e kohi­kohi tahi māua, e tī­tari­tari ana. ");
INSERT INTO mri_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ka puta te wairua poke i roto i te tangata, ka hāere­ere ia rā ngā wāhi waikore rapu oki­oki­nga ai; ā, kāhore e kitea, ka mea ia, ‘Ka hoki ahau ki tōku whare i puta mai ai ahau.’ ");
INSERT INTO mri_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ā, nō te taenga atu, roko­hanga atu kua oti te tahi­tahi, te whaka­pai­pai. ");
INSERT INTO mri_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nā, ka haere ia, ka tango i ētahi atu wairua toko­whitu, he kino atu i a ia; ā, ka tomo atu, ka noho i reira; ā, kino atu i te tīma­tanga te whaka­mutu­nga o taua tangata.” ");
INSERT INTO mri_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ā, i a ia e kōrero ana i ēnei mea, ka karanga ake tētahi wahine i roto i te mano, ka mea ki a ia, “Koa tonu te kōpū i kawea ai koe, me ngā ū i ngotea e koe.” ");
INSERT INTO mri_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Anō rā hoki ko ia, “Engari rā, tino koa te hunga e whaka­rongo ana ki te kupu a te Atua, ā, e mahi ana.” ");
INSERT INTO mri_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ā, nō ka rūpeke te mano, ka anga ia ka kōrero, “He whaka­tupu­ranga kino tēnei; e rapu ana ki tētahi tohu, ā, e kore tētahi tohu e hoatu, ko te tohu anake o Hona poro­piti. ");
INSERT INTO mri_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","I waiho nei hoki a Hona hei tohu ki ngā tāngata o Ninewe, ka pērā anō te Tama a te tangata ki tēnei whaka­tupu­ranga. ");
INSERT INTO mri_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ka whaka­tika ngā­tahi te kuīni o te tonga i te whaka­wā­kanga me ngā tāngata o tēnei whaka­tupu­ranga, ka whaka­tau i te hē ki a rātou; i haere hoki ia i ngā pito o te whenua ki te whaka­rongo ki te whaka­aro nui o Horomona; ā, tēnei tētahi he nui kē atu i a Horomona. ");
INSERT INTO mri_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka whaka­tika ngā­tahi ngā tāngata o Ninewe i te whaka­wā­kanga me tēnei whaka­tupu­ranga, ka whaka­tau i te hē ki a rātou, i rīpe­netā hoki rātou i te kauwhau­tanga a Hona; ā, tēnei tētahi he nui kē atu i a Hona!” ");
INSERT INTO mri_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ka tahuna te rama, e kore e waiho e te tangata ki te wāhi ngaro, ki raro rānei i te pūhera, engari ki runga ki te tū­ranga, kia kitea ai te mārama e te hunga e tomo atu ana. ");
INSERT INTO mri_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ko te kanohi te rama o te tinana. Nā, ki te ātea tōu kanohi, ka mārama anō tōu tinana katoa; tēnā ki te kino, ka pōuri anō hoki tōu tinana. ");
INSERT INTO mri_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nā reira, kia āta ti­tiro me­he­mea ehara i te pōuri te mārama i roto i a koe. ");
INSERT INTO mri_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nā, ki te mārama tōu tinana katoa, ā, ki te kore ōna wāhi pōuri, ka mārama katoa anō, me te mea ko te mura o te rama e whaka­mārama ana i a koe.” ");
INSERT INTO mri_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nā, i a ia e kōrero ana, ka tono tētahi Parihi kia kai ia ki a ia; ā, haere ana ia ki roto, ka noho. ");
INSERT INTO mri_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ā, i te kite­nga o te Parihi, ka mīharo nō te mea kāhore ia e horoi i mua o te kainga. ");
INSERT INTO mri_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ka mea te Ariki ki a ia, “Tēnei koutou, e ngā Parihi, te horoi nei i waho o te kapu, o te rīhi; ko roto ia o koutou e kī ana i te pāhua, i te kino. ");
INSERT INTO mri_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","E te hunga kūware, kīhai ianei i hangā a roto e te kai­hanga o waho? ");
INSERT INTO mri_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Engari, hoatu ngā mea o roto hei ata­whai­nga mō ngā rawa­kore; ā, ka mā ngā mea katoa ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Otirā, auē, te mate mō koutou, e ngā Parihi! E hoatu ana hoki e koutou te wāhi whaka­tekau, o te miniti, o te rū, o ngā ota­ota katoa, ā, kapea ake te whaka­rite whaka­wā me te aroha ki te Atua; he tika anō ko ēnei kia meatia kia kaua anō hoki ērā e kapea. ");
INSERT INTO mri_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Auē, te mate mō koutou, e ngā Parihi! Ko tā koutou hoki e rawe ai ko ngā nohoa­nga ranga­tira i ngā whare kara­kia, me ngā oha­tanga i ngā kāinga hoko­hoko. ");
INSERT INTO mri_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Auē, te mate mō koutou, e ngā kara­ipi, e ngā Parihi, e te hunga tini­hanga! E rite nā koutou ki ngā urupā ngaro, e kore e kitea e ngā tāngata e hāere­ere ana i runga.” ");
INSERT INTO mri_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nā, ka whaka­hoki tētahi o ngā kai­whaka­ako o te ture, ka mea ki a ia, “E te Kai­whaka­ako, he whaka­hē anō hoki mō mātou ēnei kōrero āu.” ");
INSERT INTO mri_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nā, ko tāna mea­tanga, “Auē, te mate mō koutou hoki, e ngā kai­whaka­ako o te ture! E whaka­waha ana hoki koutou i ngā tāngata ki ngā kawe­nga tai­maha rawa hei pīkau­nga, ā, e kore tētahi o ō koutou mati­hao e pā atu ki aua kawe­nga. ");
INSERT INTO mri_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Auē, te mate mō koutou! Ko koutou nei hoki hei hanga i ngā urupā o ngā poro­piti, nā ō koutou mātua hoki rātou i whaka­mate. ");
INSERT INTO mri_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nā, he kai­whaka­atu koutou he kai­whakaae ki ngā mahi a ō koutou mātua; nā rātou hoki rātou i whaka­mate, ko koutou hoki hei hanga i ō rātou urupā. ");
INSERT INTO mri_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nā, konei anō te mātau­ranga o te Atua i mea ai, ‘Māku e tono he poro­piti, he āpō­toro ki a rātou, ā, ka whaka­mate, ka tūkino rātou i ētahi o rātou.’ ");
INSERT INTO mri_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kia rapua ai he utu i tēnei whaka­papa­ranga mō te toto o ngā poro­piti katoa i ringi­hia nei nō te tīma­tanga rā anō o te ao; ");
INSERT INTO mri_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nō te toto o Āpera, tae noa ki te toto o Hakaraia i mate nei ki waenga­nui o te āta o te wāhi tapu, āe rā, ka mea atu ahau ki a koutou, E rapua he utu i tēnei whaka­papa­ranga. ");
INSERT INTO mri_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Auē, te mate mō koutou, e ngā kai­whaka­ako o te ture! Kua tango­hia hoki e koutou te kī o te mātau­ranga; kīhai koutou i tomo ki roto, ā, i ārai hoki koutou i te hunga e tomo ana.” ");
INSERT INTO mri_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nā, i tōna pu­tanga mai ki waho, ā, ka tīmata te tohe­tohe kaha a ngā kara­ipi, a ngā Parihi ki a ia, he mea kia maha atu ai āna kōrero ");
INSERT INTO mri_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","e whaka­moho ana hoki, kia mau tētahi kupu a tōna māngai. ");
INSERT INTO mri_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nā, kei te hui­hui anō tērā ngā mano, tōna tini, nō ka taka­takahi i a rātou anō, ā, ka anga ia ka kōrero i te tua­tahi tonu ki āna ākonga, ka mea, “Kia tūpato i te rēwena o ngā Parihi; arā i te tini­hanga. ");
INSERT INTO mri_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kāhore hoki he mea i hīpoki­na e mahue te hura; kāhore hoki tētahi mea ngaro e mahue te mōhio. ");
INSERT INTO mri_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mō konei ko tā koutou e kōrero ai i te pōuri, ka rangona i te mārama. Ko tā koutou e kī ai ki te tari­nga i ngā rūma i roto rawa, ka kauwhau­tia i runga o ngā whare.” ");
INSERT INTO mri_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nā, ko tāku kupu tēnei ki a koutou, e ōku hoa, kaua e wehi ki te hunga e whaka­mate nei i te tinana, ā muri iho kāhore he mea e taea e rātou. ");
INSERT INTO mri_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Engari māku e whaka­atu ki a koutou tā koutou e wehi ai. E wehi ki a ia kei a ia nei te mana, i muri i tāna whaka­mate­nga, ki te maka ki Kehena. Āe rā hoki, ko tāku kupu tēnei ki a koutou, e wehi ki a ia! ");
INSERT INTO mri_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kāhore ianei e hokona ngā pī­hoi­hoi e rima ki ngā pātene e rua, ā, kāhore tētahi o rātou e ware­ware i te Atua? ");
INSERT INTO mri_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Heoi, kua oti katoa te tatau ngā makawe katoa nei o ō koutou māte­nga. Kaua e wehi; engari koutou i ngā pī­hoi­hoi maha.” ");
INSERT INTO mri_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ko tāku kupu tēnei ki a koutou, ki te whaka­ae tētahi ki ahau i te aro­aro o ngā tāngata, ka whaka­ae­tia anō ia e te Tama a te tangata i te aro­aro o ngā ana­hera a te Atua. ");
INSERT INTO mri_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ki te whaka­kāhore tētahi i ahau i te aro­aro o ngā tāngata, ka whaka­kāhore­tia anō ia i te aro­aro o ngā ana­hera a te Atua. ");
INSERT INTO mri_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ki te kōrero tētahi he whaka­hē mō te Tama a te tangata, ka murua tōna hara; tēnā ko te tangata e kohu­kohua ai te Wairua Tapu, e kore tōna e murua. ");
INSERT INTO mri_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ki te kawea koutou ki ngā whare kara­kia, ki ngā ranga­tira, ki te hunga whai mana, kaua e mā­nuka­nuka ki te pēhea, ki te aha rānei e whaka­hoki atu ai koutou, ki tā koutou rānei e kōrero ai. ");
INSERT INTO mri_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mā te Wairua Tapu hoki koutou e ako i taua hāora anō ki ngā mea e tika ana kia kōrero­tia e koutou.” ");
INSERT INTO mri_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nā, ka mea tētahi i roto i te mano ki a ia, “E te Kai­whaka­ako, mea atu ki tōku tua­kana, kia wehea mai mōku tētahi wāhi o te kāinga.” ");
INSERT INTO mri_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nā, ko tāna mea­tanga ki a ia, “E te tangata nei, nā wai ahau i mea hei kai­whaka­wā, hei kai­wehe­wehe i waenga­nui i a koutou?” ");
INSERT INTO mri_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","I mea anō ia ki a rātou, “Kia mahara, kia tūpato ki te apo; ehara i te mea mā te nui o ngā taonga a te tangata e ora ai ia.” ");
INSERT INTO mri_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nā, ka kōrero­tia e ia tētahi kupu whaka­rite ki a rātou, ka mea: “Nā, he nui te hua o te whenua o tētahi tangata whai taonga. ");
INSERT INTO mri_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nā, ka whaka­aro­aro ia i roto i a ia, ‘Me pēhea ahau? Kāhore hoki ōku wāhi hei putu­nga mō āku hua.’ ");
INSERT INTO mri_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ā, ka mea ia, ‘Tēnei tāku e mea ai, ka wā­wāhia e ahau ōku whare wīti, ā, ka hangā kia nui. Ā, ka kohiko­hia ki reira āku hua katoa, me āku taonga. ");
INSERT INTO mri_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kātahi ahau ka mea ki tōku wairua, E tōku wairua, ka maha āu mea papai kei te rongoā mō ngā tau e maha; noho noa iho, e kai, e inu, kia koa te ngākau.’ ");
INSERT INTO mri_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Otiia, ka mea te Atua ki a ia, ‘Kūware, ko ā tēnei pō anō tango­hia ai tōu wairua i a koe; ā, mā wai ngā mea kua pae nā i a koe?’ ");
INSERT INTO mri_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Nā, ka pēnā te tangata e whaka­pū­ranga ana i te taonga māna ake, ā, kāhore e hua tāna whaka te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nā, ka mea ia ki āna ākonga, “Koia ahau ka mea nei ki a koutou, kaua e mā­nuka­nuka ki tō koutou oranga, ki tā koutou e kai ai, ki te tinana rānei, ki tā koutou e kākahu ai. ");
INSERT INTO mri_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Rahi atu te ora i te kai, me te tinana i te kākahu. ");
INSERT INTO mri_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Whaka­aroa ngā raweni: kāhore nei e whaka­tō, kāhore e kokoti, kāhore ā rātou pākoro, kāhore he whare wīti, heoi, e whāngaia ana rātou e te Atua. Tērā noa ake koutou i ngā manu? ");
INSERT INTO mri_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ā, ko wai o koutou e taea e ia te whaka­aro iho, te hono tētahi wāhi ki tōna roa, kia kotahi te whatīa­nga? ");
INSERT INTO mri_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ā, ki te kore e taea e koutou te mea nohi­nohi rawa, he aha i mā­nuka­nuka ai ki tētahi atu? ");
INSERT INTO mri_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Whaka­aroa ngā renga­renga, tō rātou tupu; e kore nei e mahi, e kore e miro, nā, ko tāku tēnei ki a koutou, kīhai a Horomona me tōna korōria katoa i rite ki tētahi o ēnei te whai kākahu. ");
INSERT INTO mri_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nā, ki te pēnei tā te Atua whaka­kākahu i te taru­taru i te pārae, kei reira āia­nei, ā, āpōpō ka makā ki te oumu. Tērā noa ake tāna i a koutou, e te hunga whaka­pono iti. ");
INSERT INTO mri_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kaua rā e rapu ki tā koutou e kai ai, ki tā koutou e inu ai, kaua e tīrengi noa te whaka­aro. ");
INSERT INTO mri_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","E rapu ana hoki ngā iwi o te ao i ēnei mea katoa, otirā e mātau ana tō koutou Matua e matea ana e koutou ēnei mea. ");
INSERT INTO mri_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Engari rapua te ranga­tira­tanga o te Atua, ā, ka tāpiri­tia ēnei mea katoa mā koutou.” ");
INSERT INTO mri_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kaua e mataku, e te kāhui nohi­nohi; kua pai hoki tō koutou Matua ki te hōmai i te ranga­tira­tanga ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hokona ō koutou taonga, hoatu he mea mā te hunga rawa­kore. Hangā mā koutou he pēke moni e kore e tawhito­tia, he taonga ki te rangi e kore e memeha, ki te wāhi e kore nei e tata atu te tāhae, e kore anō te huhu e kai. ");
INSERT INTO mri_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ko te wāhi hoki i tō koutou taonga, ko reira anō ō koutou ngākau.” ");
INSERT INTO mri_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Whī­tiki­ria ō koutou hope, tahuna ngā rama kia kā; ");
INSERT INTO mri_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ko tō koutou rite hei ngā tāngata e tatari ana ki tō rātou ranga­tira, ina hoki mai i te hākari o te mārena, mō tōna tae rawa mai, ka pātōtō, nā uaki tonu atu rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ka koa ngā pono­nga e roko­hina mai e tō rātou ranga­tira, ā tōna taenga mai, e mata­ara ana. He pono tāku e mea nei ki a koutou, ka whī­tiki ia i a ia, ā, ka mea i a rātou kia noho, ka haere ki te mahi mea mā rātou. ");
INSERT INTO mri_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ā, ki te haere mai ia i te rua o ngā mataara­tanga, i te toru rānei, ā, ka roko­hina mai e pērā ana anō, ka koa aua pono­nga. ");
INSERT INTO mri_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Otirā, kia mōhio koutou ki tēnei, me i mātau te tangata i te whare, ki te wā e haere mai ai te tāhae, kua mata­ara ia, ā, kāhore i tukua kia pokaia tōna whare. ");
INSERT INTO mri_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kia ta­ta­nga rā koutou, nō te mea e puta mai te Tama a te tangata i te hāora e kore ai koutou e mahara.” ");
INSERT INTO mri_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nā, ka mea a Pita ki a ia, “E te Ariki, ki a mātou tēnei kupu whaka­rite e kōrero nei koe? Ki te katoa rānei?” ");
INSERT INTO mri_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nā, ka mea te Ariki, “Ko wai rā te tuari pono, mahara, e meinga e tōna ariki hei ranga­tira mō āna tāngata, hei hoatu i te mēhua kai i te wā e tika ai? ");
INSERT INTO mri_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ka koa taua pono­nga, ki te roko­hina e tōna ranga­tira ina tae mai, e pēnā ana. ");
INSERT INTO mri_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","He pono tāku e mea nei ki a koutou, ka meinga ia hei ranga­tira mō āna taonga katoa. ");
INSERT INTO mri_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Otirā, ki te mea taua pono­nga i roto i tōna ngākau, ‘Ka roa te haere­nga mai o tōku ariki’; ā, ka anga, ka whiu i ngā pono­nga tāne, i ngā pono­nga wāhine, ka kai, ka inu, ka hau­rangi, ");
INSERT INTO mri_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ka haere mai te ranga­tira o taua pono­nga i te rā e kore ai ia e mahara, i te hāora e kore ai ia e mōhio, ā, ka hau­topea ia, ka meinga mōna he wāhi i roto i te hunga whaka­pono kore. ");
INSERT INTO mri_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nā, ko taua pono­nga, i mōhio nei ki tā tōna ranga­tira i pai ai, ā, kīhai i whaka­aro wawe, kīhai hoki i mea i tāna i pai ai, he maha ngā whiu mōna. ");
INSERT INTO mri_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tēnā, ko ia kīhai i mōhio, ā, i mahi i ngā mea e tika ai kia whiua, he toru­toru ngā whiu mōna. Ko te tangata hoki i nui te hoatu­tanga ki a ia he nui anō hei hōmai­tanga māna; ā, ko te tangata i nui te tuku­nga ki a ia, hira noa atu te mea e tonoa i a ia.” ");
INSERT INTO mri_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“I haere mai ahau ki te maka kāpura ki te whenua; ā, ka pēhea ahau, me­he­mea kua kā kē? ");
INSERT INTO mri_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Otirā, he iri­iri­nga tōku e iri­iria ai ahau; anō tōku tā­kare­kare kia oti rā anō! ");
INSERT INTO mri_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","E mea ana rānei koutou, i haere mai ahau ki te hōmai i te rangi­mārire ki te whenua? Tēnei tāku kupu ki a koutou, kāhore; engari i te wehe­wehe. ");
INSERT INTO mri_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hei ngā rā hoki e takoto ake nei ka toko­rima i roto i te whare kotahi, ā, ka tahuri ki a rātou anō, toko­toru ki te toko­rua, toko­rua ki te toko­toru. ");
INSERT INTO mri_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ka tahuri atu te pāpā ki te tama, te tama ki te pāpā, te whaea ki te tamā­hine, te tamā­hine ki tōna whaea, te hunga­wai wahine ki tāna hunao­nga wahine, me te hunao­nga wahine ki tōna hunga­wai wahine.” ");
INSERT INTO mri_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ā, i mea anō ia ki ngā mano, “Ka kite koutou i te kapua e puta mai ana i te hau­āuru, nā, mea tonu ake koutou, ‘He ua te haere mai nei,’ ā, ko ia anō ia. ");
INSERT INTO mri_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ka kite koutou i te tonga e pupuhi ana, ka mea koutou, ‘Meāke ko te wera­wera’, ā, ko ia anō ia. ");
INSERT INTO mri_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","E te hunga tini­hanga, e mātau ana koutou ki te ti­tiro ki te mata o te whenua, o te rangi; he aha koutou tē mātau ai ki te ti­tiro ki tēnei tāima? ");
INSERT INTO mri_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ā, he aha koutou tē whaka­aro noa ake ai i te mea tika? ");
INSERT INTO mri_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","I a kōrua ko tōu hoa tau­whāi­nga e haere ana ki te kai­whaka­wā, hei te hua­rahi anō kia kaha te mea kia makere atu ia i a koe; kei tōia koe e ia ki te kai­whaka­wā, ā, ka tukua koe e te kai­whaka­wā ki te kātipa, ā, ka makā koe e te kātipa ki te whare here­here. ");
INSERT INTO mri_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ko tāku kupu tēnei ki a koe, E kore rawa koe e puta mai i reira, kia poto rā anō ngā moni iti rawa te utu e koe.” ");
INSERT INTO mri_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nā, i reira ētahi i taua wā, nāna i kōrero ki a ia ngā tāngata o Kariri, i whaka­ranua nei ō rātou toto e Pirato ki ā rātou patu­nga tapu. ");
INSERT INTO mri_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nā, ka whaka­hoki ia, ka mea ki a rātou, “E mea ana rānei koutou, he hara rawa aua tāngata o Kariri i ngā tāngata katoa o Kariri, nō te mea he pērā ō rātou mate? ");
INSERT INTO mri_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nā, ko tāku kupu tēnei ki a koutou, kāhore; engari ki te kore koutou e rīpe­netā, ka pērā anō hoki koutou katoa te mate. ");
INSERT INTO mri_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Me taua tekau mā waru i horoa nei e te pourewa o Hiroama, ā, mate iho, e mea ana oti koutou, he hara rawa rātou i ngā tāngata katoa e noho ana i Hiruhārama? ");
INSERT INTO mri_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ko tāku tēnei ki a koutou, kāhore; engari ki te kore koutou e rīpe­netā, ka pērā anō koutou katoa te mate.” ");
INSERT INTO mri_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ā, i kōrero­tia e ia tēnei kupu whaka­rite, “He piki tā tētahi tangata, he mea whaka­tō ki tāna māra wāina; nā, ka haere mai ia, ka rapu hua i runga, ā, kīhai i kitea. ");
INSERT INTO mri_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kātahi ia ka mea ki te kai­mahi wāina, ‘Nā, ka toru ēnei ōku tau e haere mai ana ki te rapu hua i runga i tēnei piki, heoi, kāhore i kitea. Tuaina ki raro; hei aha i mau­mau­ria ai hoki te whenua?’ ");
INSERT INTO mri_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nā, ka whaka­hoki tērā, ka mea ki a ia, ‘E te ariki, waiho anō hoki i tēnei tau, kia keria rā anō e ahau ngā taha kia makā hoki he wai­rākau. ");
INSERT INTO mri_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ā, ki te whai hua ā houa­nga, ka waiho; ki te kāhore, māu e tua ki raro.’ ” ");
INSERT INTO mri_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ā, i roto ia i tētahi o ngā whare kara­kia e whaka­ako ana i te hāpati. ");
INSERT INTO mri_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nā, ko tētahi wahine, he wairua ngoi­kore tōna, kotahi tekau mā waru ngā tau, piko tonu, kīhai rawa i āhei te whaka­tika ake. ");
INSERT INTO mri_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ā, nō te kite­nga o Īhu i a ia, ka karanga atu ki a ia, ka mea ki a ia, “E kui, ka oti tōu ngoi­kore te whaka­matara.” ");
INSERT INTO mri_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nā, whaka­pā­kia iho e ia ōna ringa ki a ia, ā, kīhai i aha kua tika, whaka­korōria ana i te Atua. ");
INSERT INTO mri_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nā, he riri nōna mō Īhu i whaka­ora i te hāpati, ka kōrero te ranga­tira o te whare kara­kia, ka mea ki te mano, “E ono ngā rā e tika ai te tangata te mahi. Hei reira koutou haere mai ai kia whaka­ora­ngia, kauaka i te hāpati.” ");
INSERT INTO mri_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nā, ka whaka­hoki te Ariki ki a ia, ka mea, “E ngā tāngata tini­hanga, e kore ianei tēnei tangata, tēnei tangata o koutou e wewete i tāna kau i te hāpati, i tāna kāihe rānei, ka ārahi atu ai i te tū­ranga ki te whaka­inu? ");
INSERT INTO mri_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kāhore rānei tēnei wahine, he tamā­hine nei nā Āperahama, i herea nei e Hātana i ēnei tau tekau mā waru, e tika kia wete­kina i tōna here i te rā hāpati?” ");
INSERT INTO mri_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ā, nō ka kōrero­tia ēnei mea e ia, ka whaka­mā katoa te hunga e whaka­hē ana ki a ia, ā, hari katoa te mano ki ngā mea korōria katoa i meinga e ia. ");
INSERT INTO mri_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nā, ka mea ia, “He rite te ranga­tira­tanga o te Atua ki te aha? Ā, me whaka­rite e ahau ki te aha? ");
INSERT INTO mri_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","He rite ki te pua nanī, i kawea e te tangata, i ruia ki tāna kāri; ā, ka tupu, ka whaka­rākau, nō ka noho ngā manu o te rangi ki ōna manga.” ");
INSERT INTO mri_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ā, i mea anō ia, “Me whaka­rite e ahau te ranga­tira­tanga o te Atua ki te aha? ");
INSERT INTO mri_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","He rite ki te rēwena i tango­hia e tētahi wahine, ā, whao­ngia ana ki roto ki ngā mēhua parāoa e toru, nō ka rēwena­tia katoa.” ");
INSERT INTO mri_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ā, ka hāere­erea e ia ngā pā, ngā kāinga, whaka­ako ai, me te ahu tonu ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nā, ka mea tētahi ki a ia, “E te Ariki, he toru­toru koia te hunga e ora?” Nā, ko tāna mea­tanga ki a rātou, ");
INSERT INTO mri_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kia kaha te tohe ki te tomo mā te kūwaha kūiti. Ko tāku kupu hoki tēnei ki a koutou, he toko­maha e whai ki te tomo, ā, e kore e taea. ");
INSERT INTO mri_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kia whaka­tika kau te tangata i te whare, kia tū­taki­na te tatau, kātahi koutou ka anga, ka tū i waho, ka pātuki ki te tatau, ka mea, ‘E te Ariki, uakina ki a mātou,’ nā, ka whaka­hoki ia, ka mea ki a koutou, ‘Kāhore ahau i mōhio ki a koutou, nō hea rānei.’ ");
INSERT INTO mri_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ko reira koutou tīmata ai te mea, ‘Kua kai mātou, kua inu i tōu aro­aro, i whaka­ako anō koe i ō mātou hua­rahi.’ ");
INSERT INTO mri_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ā, ka kī anō ia, ‘Ka mea atu ahau ki a koutou, kāhore ahau i mātau ki a koutou, nō hea rānei. Mawehe atu i ahau, e ngā kai­mahi katoa i te kino.’ ");
INSERT INTO mri_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ko te wā tēnā o te tangi, o te tetēā o ngā niho, ina kite koutou i a Āperahama, i a Īhaka, i a Hākopa, i ngā poro­piti katoa, kei te ranga­tira­tanga o te Atua, ā, ko koutou kua makā ki waho. ");
INSERT INTO mri_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ā, ka haere mai rātou i te rā­whiti, i te hau­āuru, i te hau­raro, i te tonga, ka noho ki te ranga­tira­tanga o te Atua ");
INSERT INTO mri_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nā, tērā ētahi ō muri e meinga ki mua, me ētahi ō mua ki muri.” ");
INSERT INTO mri_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","I taua hāora anō ka tae mai ētahi Parihi, ka mea ki a ia, “Haere, whaka­rērea a konei; e hia­hia ana hoki a Herora kia whaka­matea koe.” ");
INSERT INTO mri_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ka mea ia ki a rātou, “Haere, mea atu ki taua pokiha, ‘Nā, tēnei ahau te pei rēwera nei, te mahi nei i te mahi whaka­ora āia­nei, āpōpō, ā, i te toru o ngā rā ka oti tāku. ");
INSERT INTO mri_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Otiia, me hāere­ere ahau āia­nei, āpōpō, ā tahi rā; e kore hoki e āhei kia mate he poro­piti i waho o Hiruhārama.’ ");
INSERT INTO mri_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“E Hiruhārama, e Hiruhārama, e whaka­mate nei i ngā poro­piti, e āki nei ki te kāmaka i te hunga e tonoa ana ki a koe; anō te tini o āku mea­tanga kia whaka­minea āu tama­riki, kia pērā­tia me te hei­hei e whaka­mine nei i āna pī ki raro ki ōna pari­rau, ā, kīhai koutou i pai! ");
INSERT INTO mri_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nā, ka mahue atu ki a koutou tō koutou whare kia takoto noa ana. He pono tāku e mea nei ki a koutou, e kore koutou e kite i ahau, kia tae mai rā anō te rā e mea ai koutou, ‘Ka whaka­pai­ngia ia e haere mai ana i runga i te ingoa o te Ariki.’ ” ");
INSERT INTO mri_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ā, i tōna haere­nga ki te whare o tētahi o ngā ranga­tira, he Parihi, ki te kai taro i te hāpati, nā ti­tiro pū mai ana rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nā, ko tētahi tangata i tōna aro­aro, he kōpū tetere tōna mate. ");
INSERT INTO mri_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nā, ka oho a Īhu, ka kōrero ki ngā kai­whaka­ako o te ture, ki ngā Parihi, ka mea, “He mea tika rānei te whaka­ora i te hāpati?” ");
INSERT INTO mri_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ā, kīhai rātou i kīkī. Nā, ka mau ia ki a ia, ā, whaka­ora­ngia ana, tukua ana kia haere. ");
INSERT INTO mri_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nā, ka whaka­hoki ia ki a rātou, ka mea, “Ki te taka te kāihe, te kau rānei, a tētahi o koutou ki te poka, e kore ianei e hūtia ake e ia i reira pū anō i te rā hāpati?” ");
INSERT INTO mri_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ā, kīhai i taea e rātou te utu ēnei kupu āna. ");
INSERT INTO mri_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nā, ka kōrero­tia e ia tētahi kupu whaka­rite ki te hunga i karanga­tia, i tōna kite­nga i a rātou e whiri­whiri ana i ngā nohoa­nga ranga­tira; i mea ia ki a rātou, ");
INSERT INTO mri_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ki te karanga­tia koe e tētahi ki te mārena, kaua e noho ki te noho­anga ranga­tira, kei karanga­tia hoki e ia tētahi he nui atu i a koe, ");
INSERT INTO mri_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ā, ka haere mai te tangata i karanga­tia ai kōrua, ka mea ki a koe, ‘Tukua he nohoa­nga mō tēnei,’ ā, ka whaka­mā koe, ka haere ki tō muri rawa nohoa­nga noho ai. ");
INSERT INTO mri_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Engari, ka karanga­tia koe, haere, e noho ki tō muri rawa nohoa­nga. Mō te tae rawa mai o te tangata nāna koe i karanga, nā, ka mea ia ki a koe, ‘E hoa, neke ake.’ Ko reira hoki koe whai korōria ai i te aro­aro o ngā tāngata e noho tahi ana koutou. ");
INSERT INTO mri_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ki te whaka­nui hoki tētahi i a ia, ka whaka­iti­tia; ki te whaka­iti tētahi i a ia, ka whaka­nuia.” ");
INSERT INTO mri_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nā, ka mea ia ki te tangata nāna nei ia i karanga, “E taka koe i te tina, i te hapa rānei, kaua e karanga­tia ōu hoa, kaua hoki ōu tēina, kaua hoki ōu whanau­nga, kaua anō ngā tāngata taonga e noho tata ana; kei karanga­tia anō koe, ā, ka whai utu koe. ");
INSERT INTO mri_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Engari, ka taka hākari koe, karanga­tia ngā rawa­kore, ngā hauā, ngā kopa, ngā matapō. ");
INSERT INTO mri_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ā, ka koa koe; kāhore hoki ā rātou utu ki a koe; engari, ka utua koe ā te aranga o te hunga tika.” ");
INSERT INTO mri_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ā, nō ka rongo tētahi o te hunga e noho tahi ana ki te kai ki ēnei mea, ka mea ki a ia, “Ka koa te tangata kai taro i te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nā, ka mea ia ki a ia, “I takā he hapa nui e tētahi tangata, ā, he toko­maha i karanga­tia. ");
INSERT INTO mri_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ā, ka tonoa tāna pono­nga i te hāora o te hapa, hei mea ki te hunga i karanga­tia, ‘Haere mai; kua rite hoki ngā mea katoa.’ ");
INSERT INTO mri_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nā, ka anga rātou katoa ka whaka­kāhore ngā­tahi. Ka mea tō mua ki a ia, ‘Kua hokona e ahau he māra, me haere ahau kia kite. E mea ana ahau ki a koe, kia tukua ahau kia whaka­kāhore.’ ");
INSERT INTO mri_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nā, ko te mea­tanga a tētahi, ‘E rima taki­rua ngā ōkiha kua hokona e ahau, ka haere ahau ki te whaka­mātau. E mea ana ahau ki a koe, kia tukua ahau kia whaka­kāhore.’ ");
INSERT INTO mri_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","I mea anō tētahi, ‘Kua mārena­tia ahau ki te wahine. He mea tēnei e kore ai ahau e āhei te haere atu.’ ");
INSERT INTO mri_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ā, ko te haere­nga mai o taua pono­nga, ka kōrero­tia ēnei mea ki tōna ranga­tira, nā, ka riri te tangata i te whare, ka mea ki tāna pono­nga, ‘Hohoro te haere ki ngā ara, ki ngā hua­rahi o te pā, āra­hina mai ki konei ngā rawa­kore, ngā ngonge­ngonge, ngā matapō, me ngā kopa.’ ");
INSERT INTO mri_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nā, ka mea te pono­nga, ‘E kara, kua rite tāu i mea ai, ā, tēnei anō he wāhi takoto noa.’ ");
INSERT INTO mri_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ā, ka mea te ranga­tira ki te pono­nga, ‘Haere ki ngā hua­rahi, ki ngā taiepa, tōia mai ki roto nei, kia kī ai tōku whare. ");
INSERT INTO mri_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ko tāku kupu hoki tēnei ki a koutou, e kore tētahi o aua tāngata i karanga­tia rā e kai i tāku hapa.’ ” ");
INSERT INTO mri_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nā, he tini te tangata i haere tahi me ia, ā, ka tahuri ia, ka mea ki a rātou, ");
INSERT INTO mri_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ki te haere mai tētahi ki ahau, ā, ka kore e whaka­kino ki tōna pāpā, whaea, wahine, tama­riki, tēina, tuā­hine, āe rā ki te ora anō mōna ake, e kore ia e āhei hei ākonga māku. ");
INSERT INTO mri_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ki te kore tētahi e mau ki tōna rīpeka, e haere mai i muri i ahau, e kore ia e āhei hei ākonga māku. ");
INSERT INTO mri_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ko wai hoki o koutou, ki te mea ia ki te hanga tau­maihi, e kore e mātua noho ki te tatau i ngā utu, me­he­mea e ranea ana āna mea hei whaka­oti? ");
INSERT INTO mri_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kei whaka­takoto ia i te tū­ranga, ka kore e taea te whaka­oti, ā, ka tāwai mai ki a ia te hunga katoa e mā­taki­taki ana, ");
INSERT INTO mri_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ka mea, ‘I tīmata te tangata nei te hanga whare, ā, kīhai i taea te i whaka­oti.’ ");
INSERT INTO mri_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ko tēhea kīngi rānei e haere ana ki te whawhai ki tētahi atu kīngi, e kore e mātua noho, e whaka­aro, e taea rānei e ia me ngā mano kotahi tekau te tū ki te riri ki tērā e haere mai rā ki a ia me ngā mano e rua tekau? ");
INSERT INTO mri_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ā, ki te kāhore, i te mea i tawhiti anō tērā, ka tukua atu e ia he karere, ka mea ki ngā kaupapa e houhia ai te rongo. ");
INSERT INTO mri_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wai­hoki, ko te tangata o koutou e kore e whaka­rere i āna mea katoa, e kore e āhei hei ākonga māku. ");
INSERT INTO mri_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nō reira, he pai te tote; otirā ki te hemo te hā o te tote, mā te aha ka whai hā ai? ");
INSERT INTO mri_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","E kore e pai mō te whenua, e kore anō hei whaka­wairākau; ā, ka ākiri­tia ai e te tangata ki waho. Ko ia he tari­nga ōna hei whaka­rongo, kia rongo ia.” ");
INSERT INTO mri_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nā, ka whaka­tata ki a ia ngā pupiri­kana katoa me ngā tāngata hara, ki te whaka­rongo ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ā, ka amu­amu ngā Parihi, me ngā kara­ipi, ka mea, “E manako ana tēnei tangata ki ngā tāngata hara, e kai tahi ana me rātou.” ");
INSERT INTO mri_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nā, ka kōrero­tia e ia tēnei kupu whaka­rite ki a rātou, ā, ka mea: ");
INSERT INTO mri_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ko tēhea tangata o koutou he rau āna hipi, ā, ka ngaro tētahi o rātou, e kore ianei e waiho e ia ngā mea e iwa tekau mā iwa i te koraha, ā, ka haere ki taua mea i ngaro, kia kitea rā anō? ");
INSERT INTO mri_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ā, ka kitea, ka waha i runga i ōna poko­hiwi, ka koa. ");
INSERT INTO mri_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ā, nō ka tae ki te whare, ka karanga­tia ōna hoa me ngā tāngata e noho tata ana, ka mea ki a rātou, ‘Kia hari tahi tātou; kua kitea hoki tāku hipi i ngaro.’ ");
INSERT INTO mri_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ko tāku kupu tēnei ki a koutou, ka pērā anō te hari i te rangi mō te tangata hara kotahi ina rīpe­netā, nui atu i te hari mō ngā tāngata tika e iwa tekau mā iwa, kāhore nei ō rātou mea e rīpe­netā ai.” ");
INSERT INTO mri_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ko tēhea wahine rānei, kotahi tekau nei āna moni hiriwa, ki te ngaro tētahi, e kore ianei ia e tahu i te rama, e tahi i te whare, e rapu mārie, kia kitea rā anō? ");
INSERT INTO mri_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ā, nō ka kitea, ka karanga­tia e ia ōna hoa me te hunga e noho tata ana, ka mea, ‘Kia hari tahi me ahau, kua kitea hoki tāku moni i ngaro rā.’ ");
INSERT INTO mri_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wai­hoki, ko tāku kupu tēnei ki a koutou, he hari kei te aro­aro o ngā ana­hera a te Atua mō te tangata hara kotahi ina rīpe­netā.” ");
INSERT INTO mri_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","I mea anō ia, “Toko­rua ngā tama a tētahi tangata. ");
INSERT INTO mri_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ka mea tō muri o rāua ki tōna pāpā, ‘E pā, hōmai ki ahau te wāhi taonga e wehea e koe mōku.’ Nā, ka wehe­wehea e ia ki a rāua tōna oranga. ");
INSERT INTO mri_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ā, kīhai i maha ngā rā, ka kohiko­hia e te tama ō muri ngā mea katoa, ā, haere ana ki te whenua tawhiti, mau­mau­ria ana ōna taonga ki reira, he tō­rere­tanga ki te kino. ");
INSERT INTO mri_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ā, nō ka poto āna mea katoa, ka pā te matekai ki taua whenua, ā, ka tīmata ia te rawa­kore. ");
INSERT INTO mri_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nā, ka haere ia, ka piri ki tētahi o ngā tāngata o taua whenua; ka tonoa e ia ki āna māra ki te whāngai poaka. ");
INSERT INTO mri_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I hia­hia hoki ia kia whaka­kīa tōna kōpū ki ngā kiri e kainga ana e ngā poaka, heoi, kīhai i hoatu e tētahi ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nō te hoki­nga ake ia o ōna whaka­aro, ka mea ia, ‘Anō te tini o ngā kai­mahi a tōku pāpā, he nui noa atu ā rātou taro, ko ahau ia ka ngaro i te kai­kore! ");
INSERT INTO mri_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ka whaka­tika ahau, ka haere ki tōku matua, ka mea ki a ia, E pā, kua hara ahau ki te rangi, ki tōu aro­aro anō. ");
INSERT INTO mri_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ā, heoi anō tikanga kia kīa ahau he tama nāu; meinga ahau kia rite ki tētahi o āu kai­mahi.’ ");
INSERT INTO mri_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nā, ka whaka­tika ia, ā, haere ana ki tōna matua. “Nā, i a ia anō i tawhiti, ka kite tōna matua i a ia, ka aroha, ka oma, hinga iho ki tōna kakī kihi ana i a ia. ");
INSERT INTO mri_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nā, ko te mea­tanga a te tama ki a ia, ‘E pā, kua hara ahau ki te rangi, ki tōu aro­aro anō, ā, heoi anō tikanga kia kīa ahau he tama nāu.’ ");
INSERT INTO mri_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nā, ka mea te matua ki āna pono­nga, ‘Kia hohoro te mau mai i te kākahu pai rawa, ā, ka whaka­kākahu ki a ia; hōmai hoki he mō­whiti mō tōna ringa, he hū hoki mō ōna wae­wae. ");
INSERT INTO mri_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kawea mai anō te kūao kau, te mea whāngai, patua, kia kai tātou, kia koa te ngākau. ");
INSERT INTO mri_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ko tēnei tama hoki āku i mate, ā, kua ora; i ngaro, ā, kua kitea.’ Ā, ka anga rātou ka koa. ");
INSERT INTO mri_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nā, kei te māra tāna tama mātā­mua, ā, nō tōna haere­nga mai, ka whaka­tata ki te whare, ka rongo i te waiata, i te kani­kani. ");
INSERT INTO mri_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nā, karanga­tia ana e ia tētahi o ngā kai­mahi, ka ui atu, ‘He aha rā ēnei mea?’ ");
INSERT INTO mri_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nā, ka mea mai tērā ki a ia, ‘Kua tae mai tōu teina; kua patua e tōu matua te kūao mōmona a te kau, nō te mea kua tae ora mai ia ki a ia.’ ");
INSERT INTO mri_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nā, ka riri ia, kīhai hoki i pai kia haere ki roto; me i reira ka haere atu tōna matua ki waho, ka tohe ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nā, ka whaka­hoki ia, ka mea ki tōna matua, ‘Nana, te tini o ngā tau i mahi ai ahau ki a koe, kāhore rawa hoki i taka­takahi i tāu kupu; heoi, kāhore rawa i hōmai e koe ki ahau he kūao koati, kia koa tahi ai ahau me ōku hoa. ");
INSERT INTO mri_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Otirā, i te taenga mai o tēnei tama āu, i pau nei tōu oranga i a ia, rātou tahi ko ngā wāhine kairau, kua patua e koe te kūao mōmona a te kau māna.’ ");
INSERT INTO mri_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nā, ka mea tērā ki a ia, ‘E tama, kei ahau tonu koe, māu hoki āku mea katoa. ");
INSERT INTO mri_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","He tika ia kia koa tātou, kia hari; i mate hoki tōu teina nei, ā, kua ora, i ngaro, ā, kua kitea.’ ” ");
INSERT INTO mri_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ā, i mea anō ia ki āna ākonga, “Tērā tētahi tangata whai rawa i mua, he tuari taonga tōna; ā, ka kōrero­tia ki a ia kei te mau­mau­ria e ia āna taonga. ");
INSERT INTO mri_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nā, karanga­tia ana ia e ia, ā, ka mea atu ia ki a ia, ‘He aha tēnei e rangona nei e ahau mōu? Kōrero­tia mai te tikanga o ngā mea i tuari­tia e koe; e kore hoki e āhei kia waiho koe hei tuari.’ ");
INSERT INTO mri_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nā, ko te mea­tanga a taua tuari i roto i a ia, ‘Me aha ahau? E tango­hia ana hoki i ahau te tuari­tanga e tōku ariki; e kore ahau e kaha ki te keri; e whaka­mā ana ahau ki te tono mea māku. ");
INSERT INTO mri_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","E mōhio ana ahau ki tāku e mea ai, mō tōku peinga rawa­tanga atu i te tuari­tanga, ka ai ō rātou whare hei tuku­nga atu mōku.’ ");
INSERT INTO mri_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nā, ka karanga­tia e ia tēnei tangata, tēnei tangata o te hunga i a rātou nei ētahi mea a tōna ariki, ka mea ia ki te tua­tahi, ‘E hia ngā mea a tōku ariki i a koe?’ ");
INSERT INTO mri_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nā, ka mea tērā, ‘Kotahi rau mēhua hinu.’ Nā, ko tāna mea­tanga ki a ia, ‘Tango­hia tāu puka­puka, hohoro te noho, tuhi­tuhia e rima tekau.’ ");
INSERT INTO mri_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kātahi ia ka mea ki tētahi, ‘E hia hoki i a koe?’ ka mea ia, ‘Kotahi rau mēhua wīti.’ Nā, ka mea ia ki a ia, ‘Tango­hia tāu puka­puka, tuhi­tuhia e waru tekau.’ ");
INSERT INTO mri_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nā, ka mihia te tuari kino e tōna ariki, mōna i whai whaka­aro; engari hoki ngā tama­riki o tēnei ao, i tō rātou whaka­papa­ranga, nui kē te whaka­aro i tō ngā tama­riki o te mārama. ");
INSERT INTO mri_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nā, ko tāku kupu tēnei ki a koutou, waiho te taonga kino hei mea i ētahi hoa aroha mō koutou; mō te hē rawa iho, ka ai he tuku­nga atu mō koutou ki ngā whare ora tonu. ");
INSERT INTO mri_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ko ia e pono ana ki te mea nohi­nohi rawa, e pono anō i te mea nui; ko ia e kore e tika i te mea nohi­nohi rawa, e kore anō e tika i te mea nui. ");
INSERT INTO mri_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nā, ki te kāhore i pono tā koutou mahi ki te taonga hē, mā wai e tuku ki a koutou hei tiaki i te taonga pono? ");
INSERT INTO mri_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ki te kāhore koutou i pono i te mea a te tangata kē, mā wai e hoatu he mea mā koutou ake ki a koutou? ");
INSERT INTO mri_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“E kore e āhei i te pono­nga te mahi ki ngā ranga­tira toko­rua; ka kino hoki ki tētahi, ka aroha ki tētahi; ka ū rānei ki tētahi, ka whaka­hāwea ki tētahi. E kore e āhei i a koutou te mahi ki te Atua, ki te taonga.” ");
INSERT INTO mri_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ā, ko ngā Parihi, he hunga apoapo moni i rongo ki ēnei mea katoa, ā, ka whaka­hī rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nā, ko tāna mea­tanga ki a rātou, “Ko koutou te hunga e whaka­tika­tika ana i a koutou anō i te aro­aro o ngā tāngata; ko te Atua ia e mātau ana ki ō koutou ngākau; ko te mea hoki e whaka­nuia ana e ngā tāngata hei mea whaka­riha­riha i te aro­aro o te Atua. ");
INSERT INTO mri_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“I tutuki te ture me ngā poro­piti ki a Hoani; nō reira i kauwhau­tia mai ai te ranga­tira­tanga o te Atua, ā, tāruke ana ngā tāngata katoa ki roto. ");
INSERT INTO mri_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Erangi te pahemo­tanga o te rangi, o te whenua e takoto noa ana, e kore ia tētahi tohu o te ture e taka. ");
INSERT INTO mri_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ki te whaka­rere tētahi i tāna wahine, ā, ka mārena i tētahi atu, e pūremu ana ia; ki te mārena tētahi te wahine kua whaka­rērea e te tangata, e pūremu ana ia.” ");
INSERT INTO mri_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Nā, tērā tētahi tangata whai taonga i mua, he kākahu pāpura ōna, he rīnena pai, ā, ko tāna mahi he kai tonu i ngā kai papai i ngā rā katoa. ");
INSERT INTO mri_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nā, ka whaka­takoto­ria ki tōna kūwaha tētahi tangata rawa­kore, ko Raharuhi te ingoa, he tū­whenua, ");
INSERT INTO mri_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","e hia­hia ana hoki kia whāngaia ki ngā konga­konga e nga­horo ana i te tēpu a te tangata taonga; ā, ko ngā kurī rawa hoki i haere mai, ka miti­miti i ōna mate. ");
INSERT INTO mri_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nāwai ā, ka mate te tangata rawa­kore, ā, kawea ana e ngā ana­hera ki te uma o Āperahama. Ā, ka mate hoki ko te tangata taonga, ā, tanu­mia ana. ");
INSERT INTO mri_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ā, i te rēinga ka ti­tiro ake ia, i a ia e whaka­mamae­tia ana, ka kite i a Āperahama i tawhiti, me Raharuhi i tōna uma. ");
INSERT INTO mri_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nā, ka karanga ia, ka mea, ‘E pā, e Āperahama, kia aroha ki ahau, tonoa mai hoki a Raharuhi ki te tou i te pito o tōna mati­hao ki te wai, hei whaka­mātao i tōku arero; e mamae ana hoki ahau i tēnei mura.’ ");
INSERT INTO mri_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Otirā, ka mea a Āperahama, ‘E tama, kia mahara kua riro i a koe āu mea papai i a koe e ora ana, he kino ia ngā mea i a Raharuhi; nā, ka whaka­mārie­tia nei ia, e whaka­mamae­tia ana koe. ");
INSERT INTO mri_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hāunga anō ēnei mea katoa, kua oti te whaka­pūmau tētahi tawhā nui i waenga­nui o koutou, o mātou. Ā, ki te mea ētahi ki te whaka­whiti atu i konei ki a koutou, e kore e āhei; e kore anō e whiti mai i konā ki a mātou.’ ");
INSERT INTO mri_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Anō rā ko tērā, ‘Koia ahau ka mea nei ki a koe, e pā, kia tonoa ia ki te whare o tōku pāpā; ");
INSERT INTO mri_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","toko­rima hoki ōku tēina? Kia kōrero ai ia ki a rātou, kei haere mai hoki rātou ki tēnei wāhi mamae.’ ");
INSERT INTO mri_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ka mea a Āperahama ki a ia, ‘Kei a rātou rā a Mohi rātou ko ngā poro­piti; me whaka­rongo ki a rātou.’ ");
INSERT INTO mri_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ka mea ia, ‘Kāhore, e pā, e Āperahama, engari ki te haere atu tētahi ki a rātou o te hunga mate, ka rīpe­netā rātou.’ ");
INSERT INTO mri_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nā, ka mea tērā ki a ia, ‘Ki te kore rātou e whaka­rongo ki a Mohi, ki ngā poro­piti hoki, e kore anō e whaka­ae ahakoa ara ake te tangata i te hunga mate.’ ” ");
INSERT INTO mri_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nā, ka mea ia ki āna ākonga, “E kore e taea te whaka­kāhore te pu­tanga o ngā take hē; otiia, auē te mate mō te tangata e puta ai! ");
INSERT INTO mri_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","He nui te pai ki a ia ki te whaka­tārewa­tia ki tōna kakī te kōhatu mira kāihe, kia makā hoki ia ki te moana, ā, kia kaua e taka i a ia ki te hē tētahi ēnei mea no­nohi. ");
INSERT INTO mri_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kia tūpato ki a koutou! “Ki te hara tōu teina ki a koe, rīria; ā, ki te rīpe­netā, murua tōna. ");
INSERT INTO mri_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ā, ki te whitu ngā hara­nga ki a koe i te rā kotahi, ā, ka whitu ōna hoki­nga mai ki a koe, ā, ka mea, ‘E rīpe­netā ana ahau,’ murua tōna.” ");
INSERT INTO mri_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ā, ka mea ngā āpō­toro ki te Ariki, “Whaka­nuia tō mātou whaka­pono.” ");
INSERT INTO mri_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nā, ka mea te Ariki, “Ki te mea he whaka­pono tō koutou, me te pua nanī te rahi, ka mea koutou ki tēnei hika­maina, ‘Kia rangā atu koe, kia whaka­tō­kia ki te moana,’ nā, ka rongo ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nā, ko wai o koutou he pono­nga tāna e parau ana, e tiaki ana rānei i ngā hipi, e mea atu ki a ia, i tōna hoki­nga mai i te māra, ‘Haere tonu mai, ka noho ki te kai’? ");
INSERT INTO mri_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ā, e kore e mea ki a ia, ‘Takā he hapa māku, ka whī­tiki ai i a koe, ka tuari mai ki ahau, kia mutu rā tāku kai, tāku inu; ā muri iho ka kai ai koe, ka inu ai’? ");
INSERT INTO mri_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","E whaka­whetai oti ia ki taua pono­nga, mōna i mea i ngā mea i whaka­haua ai ia? ");
INSERT INTO mri_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wai­hoki ko koutou, ka oti ngā mea katoa i whaka­haua ai koutou, ka kī atu, ‘He pono­nga hua­kore mātou; ko tā mātou i mea ai ko te mea anō i whaka­ritea kia mahia e mātou.’ ” ");
INSERT INTO mri_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nā, i a rātou e haere ana ki Hiruhārama, ka haere ia rā waenga­nui o Hamaria, o Kariri. ");
INSERT INTO mri_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ā, i a ia e tomo ana ki tētahi kāinga, kotahi tekau ngā tāngata i tūtaki ki a ia, he repera, nā, ka tū mai rātou i tawhiti. ");
INSERT INTO mri_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ka karanga, ka mea, “E kara, e Īhu, kia aroha ki a mātou.” ");
INSERT INTO mri_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ā, i tōna kite­nga atu, ka mea ki a rātou, “Haere, kia kite ngā tohu­nga i a koutou.” Ā, i a rātou e haere ana, nā kua mā. ");
INSERT INTO mri_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ā, nō te kite­nga o tētahi o rātou kua ora ia, ka hoki, ā, he rahi tōna reo ki te whaka­korōria i te Atua. ");
INSERT INTO mri_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ā, takoto tāpapa ana ia ki ōna wae­wae, ka whaka­whetai ki a ia. Ā, nō Hamaria ia. ");
INSERT INTO mri_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ā, ka oho atu a Īhu, ka mea, “Kīhai rānei te tekau i whaka­ora­ngia? Ā, kei hea ngā toko­iwa? ");
INSERT INTO mri_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Heoi anō, ngā mea i kitea e hoki mai ana ki te hōmai i te korōria ki te Atua, ko tēnei tangata iwi kē.” ");
INSERT INTO mri_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nā, ka mea ia ki a ia, “Whaka­tika, haere; nā tōu whaka­pono koe i ora ai.” ");
INSERT INTO mri_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ā, i te uinga a ngā Parihi ki a ia, ko āhea puta mai ai te ranga­tira­tanga o te Atua, ka whaka­hoki ia ki a rātou, ka mea, “E kore e kitea te pu­tanga mai o te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","E kore anō rātou e mea, ‘Nā, tēnei!’, ‘Nā, tērā!’ Kei roto hoki i a koutou te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ā, ka mea ia ki ngā ākonga, “Tērā e tae mai ngā rā e hia­hia ai koutou kia kite i tētahi o ngā rā o te Tama a te tangata, ā, e kore koutou e kite. ");
INSERT INTO mri_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ā, e mea rātou ki a koutou, ‘Nā, tēnei!’, ‘Nā, tērā!’ Kaua e haere atu, kaua e aru atu. ");
INSERT INTO mri_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ka rite hoki ki te uira e hiko mai ana i tētahi wāhi i raro o te rangi; ā, tīaho atu ana ki tētahi atu wāhi i raro o te rangi. E pērā anō te Tama a te tangata ā tōna rā. ");
INSERT INTO mri_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Otiia, ko te tikanga tēnei kia maha ngā mamae mōna i mua, kia whaka­kino­ngia anō hoki e tēnei whaka­tupu­ranga. ");
INSERT INTO mri_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ka rite hoki ki ngā rā i a Noa ngā rā o te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","E kai ana rātou, e inu ana, e mārena ana, e tukua ana ki te mārena, taea noatia te rā i tomo ai a Noa ki te āka, ā, ko te pu­tanga mai o te wai­puke, nā, whaka­ngaro­mia katoa­tia rātou. ");
INSERT INTO mri_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ka rite anō hoki ki ngā rā i a Rota; e kai ana rātou, e inu ana, e hoko mai ana, e hoko atu ana, e whaka­tō ana, e hanga whare ana. ");
INSERT INTO mri_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Heoi, i te rā i puta mai ai a Rota i Horoma, ka uaina he kāpura, he whānā­riki i te rangi, nā, whaka­ngaro­mia katoa­tia rātou. ");
INSERT INTO mri_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ka pērā anō ā te rā e whaka­kitea ai te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“I taua rā, kei runga tētahi i te whare, me ōna taonga hoki i roto i te whare, kaua ia e heke iho ki te tiki i aua mea; ko te tangata hoki i te māra, kaua ia e hoki atu ki ngā mea ō muri. ");
INSERT INTO mri_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kia mahara ki te wahine a Rota. ");
INSERT INTO mri_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ki te whai tētahi kia ora ia, ka mate anō ia; ki te mate tētahi, ka ora anō ia. ");
INSERT INTO mri_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ko tāku kupu tēnei ki a koutou, I taua pō toko­rua i te moenga kotahi; kotahi e tango­hia, kotahi e waiho. ");
INSERT INTO mri_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Toko­rua ngā wāhine e huri ana; kotahi e tango­hia, kotahi e waiho. ");
INSERT INTO mri_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Toko­rua ngā tāngata i te māra; kotahi e tango­hia, kotahi e waiho.” ");
INSERT INTO mri_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nā, ka whaka­hoki rātou, ka mea ki ia, “Ko hea, e te Ariki?” Ka mea ia ki a rātou, “Ko te wāhi i te tū­pā­paku, ko reira hui­hui ai ngā ēkara.” ");
INSERT INTO mri_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nā, ka kōrero ia i tētahi kupu whaka­rite ki a rātou mō tēnei, kia īnoi rātou i ngā wā katoa, kia kaua e ngoi­kore. ");
INSERT INTO mri_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I mea ia, “I tētahi pā tērā tētahi kai­whaka­wā, he tangata kīhai nei i wehi ki te Atua, kīhai anō i hopo­hopo ki te tangata. ");
INSERT INTO mri_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","I taua pā anō tētahi pouaru; ā, ka haere mai tērā ki a ia, ka mea, ‘Taki­takina tōku mate i tōku hoa tau­whāi­nga.’ ");
INSERT INTO mri_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ā, he roa kīhai ia i pai, muri iho ka mea ia i roto i a ia, ‘Ahakoa kāhore ahau e wehi ki te Atua, e hopo­hopo ki te tangata, ");
INSERT INTO mri_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","heoi, ka pō­rea­rea ahau i te pouaru nei, nā, ka taki­takina e ahau tōna mate, kei haere tonu mai ka mate ahau i te hōhā.’ ” ");
INSERT INTO mri_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ka mea te Ariki, “Whaka­rongo ki tā te kai­whaka­wā kino i mea rā. ");
INSERT INTO mri_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ā, e kore rānei te Atua e ngaki i te mate o āna tāngata i whiri­whiri ai, e karanga nei ki a ia i te ao, i te pō, ahakoa whaka­roa noa ia ki a rātou? ");
INSERT INTO mri_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ko tāku kupu tēnei ki a koutou, ka hohoro ia te taki­taki i tō rātou mate. Otirā, ka tae mai te Tama a te tangata, e roko­hina mai rānei e ia he whaka­pono i runga i te whenua?” ");
INSERT INTO mri_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nā, ka kōrero anō ia i tēnei kupu whaka­rite ki ētahi, i whaka­manawa nei ki a rātou anō he tika, i whaka­kore­kore ki ērā atu katoa, ");
INSERT INTO mri_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Toko­rua ngā tāngata i haere ki te teme­para ki te īnoi; he Parihi tētahi, ko tētahi he pupiri­kana. ");
INSERT INTO mri_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Tū ana te Parihi ko ia anake, ko tāna kara­kia tēnei, ‘E te Atua, ka whaka­whetai ahau ki a koe, nō te mea kāhore ahau e rite ki ērā atu tāngata, ki te hunga hao taonga, kino, pūremu, mōku hoki tē rite ki tēnei pupiri­kana. ");
INSERT INTO mri_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Taki­rua āku nohoa­nga puku­tanga i te wiki, e hoatu ana e ahau te wāhi whaka­tekau o āku mea katoa.’ ");
INSERT INTO mri_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ko te pupiri­kana ia i tū mai i tawhiti, kīhai i mea kia anga ake ōna kanohi ki te rangi, heoi, pātuki ana ki tōna uma, ka mea, ‘E te Atua, tohu­ngia ahau, te tangata hara.’ ");
INSERT INTO mri_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ko tāku kupu tēnei ki a koutou, nui atu te tika o tēnei i tō tērā i te hoki­nga ki tōna whare; ki te whaka­nui hoki tētahi i a ia, ka whaka­iti­tia; ki te whaka­iti tētahi i a ia, ka whaka­nuia.” ");
INSERT INTO mri_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nā, ka kawea mai e rātou ki a ia ā rātou tama­riki no­nohi, kia pā ai ia ki a rātou; otiia, nō te kite­nga o āna ākonga, ka rīria atu rātou. ");
INSERT INTO mri_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Otirā, ka karanga­tia atu rātou e Īhu ki a ia, ka mea ia, “Tukua ngā tama­riki no­nohi kia haere mai ki ahau, kaua hoki rātou e āraia atu; nō ngā pēnei hoki te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","He pono tāku e mea nei ki a koutou, ki te kāhore e rite te tango a tētahi i te ranga­tira­tanga o te Atua ki tā te tama­iti nohi­nohi, e kore rawa ia e tomo ki roto.” ");
INSERT INTO mri_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nā, ka ui tētahi ranga­tira ki a ia, ka mea, “E te kai­whaka­ako pai, me aha ahau ka whi­whi ai ki te ora tonu?” ");
INSERT INTO mri_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nā, ko te mea­tanga a Īhu ki a ia, “He aha ahau i kīa ai e koe he pai? Kāhore tētahi i pai, kotahi anake, ko te Atua. ");
INSERT INTO mri_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","E mātau ana koe ki ngā ture, kaua e pūremu, kaua e patu tangata, kaua e tāhae, kaua e whaka­pae teka, whaka­hōnore­tia tōu pāpā me tōu whaea.” ");
INSERT INTO mri_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nā, ka mea ia, “Kua rite i ahau ēnei katoa nō tōku tama­riki­tanga ake.” ");
INSERT INTO mri_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ā, i te rongo­nga o Īhu ki tēnei, ka mea ki a ia, “Kotahi te mea kāhore anō i rite i a koe; hokona āu mea katoa, ka tuwha atu mā ngā mea rawa­kore, ā, e whai taonga koe ki te rangi, ā, haere mai i muri i ahau.” ");
INSERT INTO mri_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nā, ka rongo ia ki ēnei mea, ka pōuri rawa; he nui hoki ōna taonga. ");
INSERT INTO mri_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ā, ka kite a Īhu i a ia, ka mea, “Anō te whaka­uaua o te tapoko o te hunga taonga ki te ranga­tira­tanga o te Atua! ");
INSERT INTO mri_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Erangi hoki te haere o te kāmera rā te kōwhao o te ngira e takoto noa ana, he whaka­uaua rawa ia te tomo o te tangata taonga ki roto ki te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nā, ka mea ngā kai­whaka­rongo, “Ko wai rā e ora?” ");
INSERT INTO mri_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Otirā, i mea ia, “Ko ngā mea e kore e taea e te tangata, ka taea e te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ā, ka mea a Pita, “Nā, kua whaka­rērea nei e mātou ā mātou nei mea, ā, kua aru i a koe.” ");
INSERT INTO mri_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nā, ka mea ia ki a rātou, “He pono tāku e mea nei ki a koutou, kāhore he tangata i whaka­rere, he whare, he wahine, he tuā­kana, he mātua, he tama­riki, i te whaka­aro ki te ranga­tira­tanga o te Atua, ");
INSERT INTO mri_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","e kore e riro mai i a ia i tēnei wā ngā mea tini noa atu, ā, i te ao meāke puta ko te ora tonu.” ");
INSERT INTO mri_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ā, ka mau ia ki te tekau mā rua, ka mea ki a rātou, “Nā, e haere ana tēnei tātou ki Hiruhārama, ā, ka rite katoa ngā mea i tuhi­tuhia e ngā poro­piti mō te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ka tukua hoki ia ki ngā tauiwi, ka tāwaia, ka whaka­tupu­ria kino­tia, ka tu­whai­na. ");
INSERT INTO mri_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ā, ka oti ia te whiu, ka whaka­matea, ā, i te toru o ngā rā ka ara.” ");
INSERT INTO mri_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ā, kīhai rātou i mātau ki tētahi o ēnei mea; he mea huna hoki i a rātou tēnei kupu, kīhai rātou i mōhio ki ngā mea i kōrero­tia. ");
INSERT INTO mri_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ā, i a ia e whaka­tata ana ki Heriko, tērā tētahi matapō e noho ana i te taha o te hua­rahi e tono mea ana māna. ");
INSERT INTO mri_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ā, i tōna rongo­nga i te mano e haere ana, ka ui atu, “He aha tēnei?” ");
INSERT INTO mri_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ka mea rātou ki a ia, “Ko Īhu o Nahareta e haere ana.” ");
INSERT INTO mri_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kātahi ia ka karanga, ka mea, “E Īhu, e te Tama a Rāwiri, kia aroha ki ahau.” ");
INSERT INTO mri_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nā, ka rīria ia e te hunga i haere i mua kia noho puku; heoi rahi noa ake tāna karanga, “E te Tama a Rāwiri, kia aroha ki ahau.” ");
INSERT INTO mri_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nā, ka tū a Īhu, ka mea kia āra­hina mai ki a ia; ā, nō ka tata, ka ui ki a ia, ");
INSERT INTO mri_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ka mea, “Kia ahatia koe e ahau”? Ka mea ia, “E te Ariki, kia ti­tiro ahau.” ");
INSERT INTO mri_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ka mea a Īhu ki a ia, “Ti­tiro; nā tōu whaka­pono koe i whaka­ora.” ");
INSERT INTO mri_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ā, ti­tiro tonu ake ia, ā, aru ana i a ia, me te whaka­korōria i te Atua; ā, nō te kite­nga o te iwi katoa, ka whaka­moe­miti ki te Atua. ");
INSERT INTO mri_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ā, ka tomo ia, ā, tika ana rā waenga­nui o Heriko. ");
INSERT INTO mri_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nā, ko tētahi tangata, ko Hakiaha te ingoa i huaina ai, he ranga­tira pupiri­kana, he tangata taonga anō. ");
INSERT INTO mri_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I whai ia kia kite i a Īhu he pēhea rānei ia; heoi, kīhai i taea e ia i te mano, he tangata poto hoki. ");
INSERT INTO mri_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nā, ka oma ia ki mua, ā, kake ana ki tētahi hika­mora, kia kite i a ia, meāke hoki ia tika rā reira. ");
INSERT INTO mri_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ā, nō ka tae a Īhu ki taua wāhi, ka ti­tiro ake, ka mea ki a ia, “E Hakiaha, kia hohoro te heke iho; me noho hoki ahau ki tōu whare āia­nei.” ");
INSERT INTO mri_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ā, hohoro tonu tōna heke iho, ā, ka koa ki a ia hei manu­hiri māna. ");
INSERT INTO mri_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ā, i tō rātou kite­nga, ka amu­amu katoa, ka mea, “Kua riro ia ki te tangata hara noho ai.” ");
INSERT INTO mri_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nā, ka tū a Hakiaha, ka mea ki te Ariki, “E te Ariki, nā, e hoatu ana e ahau te hāwhe o āku taonga ki te hunga rawa­kore, ā, ki te mea kua riro hē mai i ahau te mea a tētahi, ka taki­whā­tia e ahau tāku utu.” ");
INSERT INTO mri_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nā, ko te mea­tanga a Īhu ki a ia, “Nō nāia­nei te ora i tae mai ai ki tēnei whare, he tama nei hoki ia nā Āperahama. ");
INSERT INTO mri_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","I haere mai hoki te Tama a te tangata ki te rapu, ki te whaka­ora i te mea i ngaro.” ");
INSERT INTO mri_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ā, i a rātou e whaka­rongo ana ki ēnei mea ka kōrero­tia anō e ia tētahi kupu whaka­rite, nō te mea e tata ana ia ki Hiruhārama, e mea ana hoki rātou, ko taua wā pū anō whaka­kitea ai te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nā reira ia ka mea, “I haere tētahi ranga­tira nui ki tētahi whenua mamao, kia riro mai i a ia tētahi ranga­tira­tanga, ka hoki mai ai. ");
INSERT INTO mri_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kotahi tekau āna pono­nga i karanga­tia e ia, kotahi tekau ngā pāuna i hoatu e ia ki a rātou, ka mea ki a rātou, ‘Mahia ēnei, kia hoki mai rā anō ahau.’ ");
INSERT INTO mri_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Otirā, i kino tōna iwi ki a ia, ka tono karere i muri i a ia, ka mea, ‘E kore mātou e pai ki tēnei hei kīngi mō mātou.’ ");
INSERT INTO mri_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ā, i tōna hoki­nga mai, kua riro mai hoki i a ia te ranga­tira­tanga, ka mea kia karanga­tia ki a ia aua pono­nga, i hoatu nei e ia te moni ki a rātou, kia kite ai ia i tā tētahi, i tā tētahi i mahi ai. ");
INSERT INTO mri_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ka tae mai tō mua, ka mea, ‘E te ariki, ka nga­huru ngā pāuna kua mahia ki tāu pāuna.’ ");
INSERT INTO mri_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ka mea ia ki a ia, ‘Ka pai, e te pono­nga pai; pono tonu tāu mahi i te mea nohi­nohi rawa, nā, hei ranga­tira koe mō ngā pā kotahi tekau.’ ");
INSERT INTO mri_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ā, ko te haere­nga mai o te tuarua, ka mea, ‘E te ariki, e rima ngā pāuna kua mahia ki tāu pāuna.’ ");
INSERT INTO mri_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ka mea ia ki tēnei, ‘Hei ranga­tira anō koe mō ngā pā e rima.’ ");
INSERT INTO mri_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nā, ko te haere­nga mai o tētahi, ka mea, ‘E te ariki, nā, tāu pāuna, i te rongoā hoki i ahau i roto i te tauera. ");
INSERT INTO mri_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","I mataku hoki ahau i a koe, nō te mea he tangata uaua koe; e tango ana koe i te mea kīhai i whaka­takoto­ria iho e koe, e kokoti ana i te mea kīhai i ruia e koe.’ ");
INSERT INTO mri_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nā, ko tāna mea­tanga ki a ia, ‘Kei tā tōu māngai he whaka­hēa­nga māku i a koe, e te pono­nga kino. I mōhio koe he tangata uaua ahau, e tango ana i te mea kīhai i whaka­takoto­ria e ahau, e kokoti ana i te mea kīhai i ruia e ahau. ");
INSERT INTO mri_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","He aha koe tē hoatu ai i tāku moni ki te pēke, pēnei kua riro mai taua mea i ahau, me ōna hua anō, i tōku taenga mai?’ ");
INSERT INTO mri_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nā, ka mea ia ki te hunga e tū tata ana, ‘Tango­hia te pāuna i a ia, hoatu hoki ki tērā i ngā pāuna kotahi tekau.’ ");
INSERT INTO mri_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ka mea rātou ki a ia, ‘E te ariki kotahi nei tekau āna pāuna.’ ");
INSERT INTO mri_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Ko tāku kupu hoki tēnei ki a koutou, Ki te whai mea tētahi, ka hoatu anō ki a ia; ki te kāhore he mea a tētahi, ko āna mea ake ka tango­hia i a ia. ");
INSERT INTO mri_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tēnā ko aua hoa­riri ōku kīhai nei i pai ki ahau hei kīngi mō rātou, āra­hina mai ki konei, ka patu ki tōku aro­aro!’ ” ");
INSERT INTO mri_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ā, nō ka mutu ēnei kōrero, ka tūria atu e ia ki mua, ka haere ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ā, nō ka tata ia ki Petapaki, ki Petani, ki te maunga e kīa nei ko tō ngā Ōriwa, nā, toko­rua āna ākonga i tonoa e ia. ");
INSERT INTO mri_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","I mea ia, “Haere kōrua ki te kāinga e anga mai ana ki a kōrua; ā, nō ka tomo atu, ka kite kōrua i tētahi kūao kāihe e here ana, he mea kāhore anō i nohoia noatia e te tangata. Wete­kina, āra­hina mai. ");
INSERT INTO mri_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ki te mea hoki tētahi, ki a kōrua, ‘He aha i wete­kina ai e kōrua?’ Kia pēnei tā kōrua kī atu, ‘E mea ana te Ariki ki a ia mōna.’ ” ");
INSERT INTO mri_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nā, haere atu ana te hunga i tonoa, roko­hanga atu, rite tonu ki tāna i kōrero ai ki a rāua. ");
INSERT INTO mri_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nā, i a rāua e wewete ana i te kūao, ka mea ōna ranga­tira ki a rāua “He aha kōrua ka wewete ai i te kūao nā?” ");
INSERT INTO mri_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nā, ko tā rāua mea­tanga atu, “E mea ana te Ariki ki a ia mōna,” ");
INSERT INTO mri_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","nā, ka āra­hina ia ki a Īhu; ā, pangā iho e rāua ō rāua kākahu ki runga ki te kūao, whaka­noho­ia ana a Īhu ki runga. ");
INSERT INTO mri_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ā, i a ia e haere ana, ka whā­riki­tia ō rātou kākahu ki te hua­rahi. ");
INSERT INTO mri_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ā, i a ia e whaka­tata ana ki te heke­tanga o Maunga Ōriwa, ka koa te hui­hui katoa o ngā ākonga, ka anga, ka whaka­moe­miti ki te Atua, he nui hoki te reo, mō ngā mere­kara katoa i kite ai rātou; ");
INSERT INTO mri_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ka mea, “Ka whaka­pai­ngia te Kīngi e haere mai ana i runga i te ingoa o te Ariki! He rongo mau ki runga ki te rangi, he korōria ki runga rawa.” ");
INSERT INTO mri_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nā, ka mea ētahi o ngā Parihi i roto i te mano ki a ia, “E te Kai­whaka­ako, rīria āu ākonga!” ");
INSERT INTO mri_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nā, ka whaka­hoki ia, ka mea, “Ko tāku kupu tēnei ki a koutou, me i noho puku ēnei, kua karanga ake ngā kāmaka.” ");
INSERT INTO mri_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ā, nō ka tata ia, ka kite i te pā, ka tangi­hia e ia. ");
INSERT INTO mri_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ka mea ia, “Me i mōhio koe, ā, koe anō, ahakoa i tēnei rā nei anō ōu, ki ngā mea e mau ai tōu rongo! Ko tēnei kua huna atu i ōu kanohi. ");
INSERT INTO mri_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tērā hoki e tae mai ngā rā ki a koe, e hangā ai e ōu hoa­riri he pare­pare mōu ā taka noa, ā, ka kara­potia koe, ka kōpania hoki i ngā taha katoa. ");
INSERT INTO mri_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ā, ka whaka­horoa koe ki raro, me āu tama­riki i roto i a koe. E kore anō e waiho tētahi kāmaka i runga i tētahi kāmaka i roto i a koe, nō te mea kīhai koe i mātau ki te wā i tiro­hia ai koe!” ");
INSERT INTO mri_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ā, ka tomo ia ki te teme­para, ka anga, ka pei ki waho i te hunga i reira e hoko ana. ");
INSERT INTO mri_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ka mea ki a rātou, “Kua oti te tuhi­tuhi, ‘Ko tōku whare hei whare īnoi,’ ā, kua meinga nei e koutou hei ana mō ngā kai­pāhua!” ");
INSERT INTO mri_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ā, whaka­ako ana ia i te teme­para i ia rā, i ia rā. Otiia, ka rapu ngā tohu­nga nui me ngā kara­ipi me ngā ranga­tira o te iwi kia whaka­ngaro­mia ia. ");
INSERT INTO mri_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Heoi, kīhai i kitea tā rātou e mea ai, nō te mea e ū ana ngā tāngata katoa ki a ia, e whaka­rongo ana. ");
INSERT INTO mri_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ā, i tētahi o aua rā, i a ia e whaka­ako ana i te iwi i roto i te teme­para, e kauwhau ana i te rongo­pai, ka tae mai ngā tohu­nga nui, ngā kara­ipi, me ngā kaumātua ki a ia, ");
INSERT INTO mri_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ka kōrero ki a ia, ka mea, “Kōrero­tia mai ki a mātou te mana i mea ai koe i ēnei mea? Nā wai hoki i hoatu tēnā mana ki a koe?” ");
INSERT INTO mri_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ka whaka­hoki ia, ka mea ki a rātou, “Māku hoki e ui ki a koutou kia kotahi kupu; mā koutou e mea mai ki ahau. ");
INSERT INTO mri_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ko te iri­iri­nga a Hoani, nō te rangi rānei, nō te tangata rānei?” ");
INSERT INTO mri_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ā, ka kōrero rātou ki a rātou anō, ka mea, “Ki te mea tātou, ‘Nō te rangi,’ ka mea mai ia, ‘Ha, he aha koutou tē whaka­pono ai ki a ia?’ ");
INSERT INTO mri_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ā, ki te mea tātou, ‘Nō te tangata,’ ka ākina tātou e te iwi katoa ki te kāmaka, e whaka­pono ana hoki rātou he poro­piti a Hoani.” ");
INSERT INTO mri_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nā, ka whaka­hokia e rātou, “E kore e kitea nō hea rānei.” ");
INSERT INTO mri_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nā, ko te mea­tanga a Īhu ki a rātou, “E kore anō e kōrero­tia e ahau ki a koutou te mana i mea ai ahau i ēnei mea.” ");
INSERT INTO mri_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nā, ka anga ia, ka kōrero i tēnei kupu whaka­rite ki te iwi: “I whaka­tō­kia tētahi māra wāina e tētahi tangata, ā, tukua ana ki ngā kai­mahi, ā, haere ana ki tawhiti, ā, maha noa ngā rā. ");
INSERT INTO mri_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ā, i te pō i tika ai ka tonoa e ia he pono­nga ki ngā kai­mahi, kia hoatu ai e rātou ki a ia ētahi o ngā hua o te māra wāina; otirā, ka whiua ia e ngā kai­mahi, whaka­hokia kautia ana. ");
INSERT INTO mri_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nā, ka tonoa anō e ia tētahi atu pono­nga; ā, ka whiua anō ia e rātou, ka tūkino­tia, whaka­hokia kautia ana. ");
INSERT INTO mri_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nā, ka tonoa anō hoki tētahi e ia, te tua­toru, ā, tuki­tukia ana ia e rātou, makā ana ki waho. ");
INSERT INTO mri_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nā, ka mea te ranga­tira o te māra wāina, ‘Me pēhea ahau? Ka tonoa e ahau tāku tama, tāku e aroha nei, tērā pea rātou e hopo­hopo ki a ia.’ ");
INSERT INTO mri_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Otirā, nō te kite­nga o ngā kai­mahi i a ia, ka kōrero­rero ki a rātou anō, ka mea, ‘Ko te ranga­tira tēnei mōna te kāinga, tēnā, tātou ka whaka­mate i a ia, kia riro mai ai te kāinga i a tātou.’ ");
INSERT INTO mri_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nā, makā ana ia ki waho o te māra wāina, whaka­matea iho. “Nā, ka aha te ranga­tira o te māra wāina ki a rātou? ");
INSERT INTO mri_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ka haere ia, ka whaka­ngaro i aua kai­mahi, ka hoatu te māra wāina ki ētahi atu.” Ā, ka rongo rātou, ka mea, “Kauaka!” ");
INSERT INTO mri_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ka ti­tiro ia ki a rātou, ka mea, “He aha rā tēnei kua oti nei te tuhi­tuhi, ‘Ko te kōhatu i kapea e ngā kai­hanga, kua meinga tēnei hei ūpoko mō te koko­nga?’ ");
INSERT INTO mri_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nā, ki te hinga tētahi ki runga ki tēnei kōhatu, monga­monga noa; ki te hinga tēnei kōhatu ki runga ki tētahi, ngota­ngota noa ia, ānō he puehu.” ");
INSERT INTO mri_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nā, ka whai ngā tohu­nga nui me ngā kara­ipi kia hopu­kia ia i taua wā anō, ka mataku rātou i te iwi, i mōhio hoki rātou i kōrero­tia e ia tēnei kupu whaka­rite mō rātou. ");
INSERT INTO mri_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nā, ka āta tiro­hia ia e rātou, ka tonoa mai he kai­whaka­rongo, anō te āhua kei tō te hunga tika, hei hopu mō tāna kōrero, kia tukua ai ia ki te ranga­tira­tanga, ki te kaha o te kāwana. ");
INSERT INTO mri_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ā, ka ui rātou ki a ia, ka mea, “E te Kai­whaka­ako, e mōhio ana mātou he tika tāu e kōrero nei, e whaka­ako nei, e kore anō e manako­hia e koe te kanohi tangata, engari e whaka­ako pono ana koe i te hua­rahi o te Atua. ");
INSERT INTO mri_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","He mea tika rānei te hoatu takoha e mātou ki a Hīhā, kāhore rānei?” ");
INSERT INTO mri_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Otirā, i kitea e ia tō rātou hīanga, ā, ka mea ki a rātou, “He aha koutou ka whaka­mā­tau­tau nei i ahau? ");
INSERT INTO mri_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kia kite ahau i tētahi pene. Nō wai tōna āhua me te tuhi­tuhi­nga?” Nā, ka whaka­hoki rātou, ka mea, “Nō Hīhā.” ");
INSERT INTO mri_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kātahi ia ka mea ki a rātou, “Hoatu rāpea ki a Hīhā ngā mea a Hīhā, ki te Atua anō ngā mea a te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Heoi, kīhai i taea e rātou te hopu i tētahi kōrero āna i te aro­aro o te iwi; nā, ka mīharo rātou ki tāna kupu, ā, whaka­rongo kau ana. ");
INSERT INTO mri_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nā, ka tae mai ētahi o ngā Haruki e mea nei kāhore he aranga; ka ui ki a ia, ");
INSERT INTO mri_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ka mea, “E te Kai­whaka­ako, i tuhi­tuhi a Mohi ki a mātou: ‘Ki te mate te tua­kana o tētahi tangata, he wahine anō tāna, ā, ka mate uri­kore ia, me tango te wahine e tōna teina, ka whaka­tupu uri ai mō tōna tua­kana.’ ");
INSERT INTO mri_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nā, toko­whitu taua whānau; ka tango tō mua i te wahine, ā, mate uri­kore āna. ");
INSERT INTO mri_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nā, ka tango te tuarua i te wahine, ā, ka mate uri­kore anō ia. ");
INSERT INTO mri_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nā, ka tango te tua­toru i a ia; pēnei anō ngā toko­whitu, kāhore ā rātou tama­riki i waiho ai, ā, mate iho rātou. ");
INSERT INTO mri_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nā, muri iho i te katoa ka mate hoki te wahine. ");
INSERT INTO mri_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nā, i te aranga, mā wai o rātou te wahine? He wahine hoki ia nā te toko­whitu.” ");
INSERT INTO mri_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ka whaka­hoki a Īhu, ka mea ki a rātou, “E mārena ana, e hoatu ana ki te mārena, ngā tama­riki o tēnei ao. ");
INSERT INTO mri_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tēnā, ko te hunga e pai­ngia ana kia whi­whi ki tērā ao, ki te aranga anō i roto i te hunga mate, e kore e mārena, e kore anō e hoatu ki te mārena. ");
INSERT INTO mri_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","E kore anō rātou e āhei kia mate. E rite ana hoki ki ngā ana­hera, he tama hoki rātou nā te Atua, he tama nā te aranga. ");
INSERT INTO mri_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nā, ko te aranga o te hunga mate, kua whaka­kitea mai tēnā e Mohi i tāna mō te Rākau, i karanga­tia ai te Ariki ‘Ko te Atua o Āperahama, ko te Atua o Īhaka, ko te Atua o Hākopa.’ ");
INSERT INTO mri_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nā, ehara ia i te Atua nō te hunga mate, engari nō te hunga ora, e ora katoa ana hoki i roto i a ia.” ");
INSERT INTO mri_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nā, ka whaka­hoki ētahi o ngā karai­pi ka mea, “E te Kai­whaka­ako, he pai tāu kōrero.” ");
INSERT INTO mri_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kīhai hoki rātou i māia ki te ui anō ki a ia i tētahi mea. ");
INSERT INTO mri_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nā, ka mea ia ki a rātou, “Nā te aha rātou i mea ai he tama nā Rāwiri a te Karaiti? ");
INSERT INTO mri_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kua mea nei a Rāwiri i te puka­puka o Ngā Waiata, ‘I mea te Ariki ki tōku Ariki, Hei tōku matau koe noho ai, ");
INSERT INTO mri_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kia meinga rā anō e ahau ōu hoa­riri hei tū­ranga wae­wae mōu.’ ");
INSERT INTO mri_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nā, ka kīa ia e Rāwiri he Ariki, ā, he pēhea i tama ai ki a ia?” ");
INSERT INTO mri_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ā, i te iwi katoa e whaka­rongo ana, ka mea ia ki āna ākonga, ");
INSERT INTO mri_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kia tūpato ki ngā kara­ipi, ko tā rātou nei e rawe ai ko ngā kākahu roroa ina hāere­ere rātou, e mate­nui ana ki ngā oha­tanga i ngā kāinga hoko­hoko, me ngā nohoa­nga ranga­tira i ngā whare kara­kia me ngā nohoa­nga ranga­tira i ngā hākari. ");
INSERT INTO mri_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pau ake hoki i a rātou ngā whare o ngā pouaru, e īnoi roa ana hoki, he āhua kau. Nui rawa te hē e tau ki a rātou!” ");
INSERT INTO mri_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nā, ka ti­tiro ake ia, ka kite i te hunga taonga, e maka ana i ā rātou moni hoatu noa ki te takoto­ranga moni. ");
INSERT INTO mri_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ā, ka kite ia i tētahi pouaru rawa­kore, e maka ana i ngā moni no­nohi rawa e rua ki reira. ");
INSERT INTO mri_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nā, ka mea ia, “He pono tāku e mea nei ki a koutou, nui kē tā tēnei pouaru rawa­kore i maka ai i a rātou katoa. ");
INSERT INTO mri_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ko rātou katoa hoki e makā ana ko tētahi wāhi o ā rātou mea hira noa atu ki roto ki ngā moni tuku noa, ko ia o tōna rawa­kore­tanga e maka ana i tōna oranga katoa.” ");
INSERT INTO mri_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ā, i ētahi e kōrero ana ki te teme­para, ka oti nei te whaka­pai­pai ki ngā kōhatu papai, ki ngā whaka­here, ka mea ia, ");
INSERT INTO mri_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nā, ko ēnei mea e kite nei koutou; tērā e tae mai ngā rā e kore ai e toe tētahi kōhatu i runga i tētahi kōhatu; engari ka whaka­horoa.” ");
INSERT INTO mri_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nā, ka ui rātou ki a ia, ka mea, “E te Kai­whaka­ako, ko āhea ēnei mea? He aha hoki te tohu ina tata ēnei mea te puta?” ");
INSERT INTO mri_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ā, ka mea ia, “Kia mahara kei māminga­tia koutou; he toko­maha hoki e haere mai i runga i tōku ingoa, e mea, ‘Ko ahau ia, kua tata te tāima.’ Nā, kei whai i muri i a rātou. ");
INSERT INTO mri_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nā, ka rongo koutou ki ngā taua, ki ngā whaka­oho, kaua e mataku. Kua takoto hoki te tikanga mō ēnei mea kia mātua puta mai; taihoa ia te mutu­nga.” ");
INSERT INTO mri_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kātahi ia ka mea ki a rātou, “Ka whaka­tika tētahi iwi ki tētahi iwi, tētahi ranga­tira­tanga ki tētahi ranga­tira­tanga. ");
INSERT INTO mri_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tērā hoki e puta ngā rū nunui, ā, i ngā tini wāhi ka pā te matekai me ngā mate urutā, me ngā mea whaka­mataku hoki, me ngā tohu nunui o te rangi. ");
INSERT INTO mri_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ā, ko mua ake i ēnei mea katoa pā ai ō rātou ringa ki a koutou, tūkino ai i a koutou, tuku ai i a koutou ki ngā whare whaka­wā, ki ngā whare here­here, me te ārahi i a koutou ki ngā kīngi, ki ngā kāwana, mō tōku ingoa. ");
INSERT INTO mri_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ā, ka waiho ki a koutou hei tohu whaka­atu. ");
INSERT INTO mri_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nā, whaka­tatū­tia iho ki ō koutou ngākau, kia kaua e whaka­aroa wawe­tia tā koutou kupu e whaka­hoki atu ai. ");
INSERT INTO mri_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Māku hoki e hoatu ki a koutou he māngai, he mātau­ranga, e kore e taea te whaka­kāhore, te pēhi, e ō koutou hoa whawhai katoa. ");
INSERT INTO mri_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ā, ka tukua atu koutou e ngā mātua, e ngā tēina, e ngā whanau­nga, e ngā hoa. Ka whaka­matea anō ētahi o koutou. ");
INSERT INTO mri_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ka kino anō ngā tāngata katoa ki a koutou, he whaka­aro ki tōku ingoa. ");
INSERT INTO mri_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Otiia, e kore e ngaro tētahi makawe o ō koutou ūpoko. ");
INSERT INTO mri_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mā te manawa­nui e mau ai ō koutou wairua. ");
INSERT INTO mri_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Otirā, ka kite koutou i Hiruhārama e kara­potia ana e ngā taua, ko reira koutou mōhio ai, kua tata tōna whaka­ngaro­manga. ");
INSERT INTO mri_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hei reira kia oma te hunga i Hūria ki ngā maunga; me te hunga i waenga­nui ōna kia haere atu ki waho, kei haere hoki ki reira te hunga i ngā tua­whenua. ");
INSERT INTO mri_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ko ngā rā hoki ēnei o te rapu­nga utu, e rite ai ngā mea katoa kua oti te tuhi­tuhi. ");
INSERT INTO mri_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Otirā, auē te mate o te hunga e hapū ana, o ngā mea e whāngai ana ki te ū, i aua rā! E nui hoki te aituā ki te whenua, me te riri ki tēnei iwi. ");
INSERT INTO mri_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ā, ka hinga rātou i te mata o te hoari, ka riro pārau ki ngā iwi katoa. Ā, ka taka­hia Hiruhārama e ngā tauiwi, kia rite rā anō ngā wā o ngā tauiwi. ");
INSERT INTO mri_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ā, ka whai tohu te rā, te marama, me ngā whetū, ā, ki runga ki te whenua he pāwera nō ngā tauiwi, he tū­mata­te­nga ki te haruru o te moana, o te ngaru. ");
INSERT INTO mri_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ka whiti ngā tāngata i te mataku, i te manawa­pā ki ngā mea e puta mai ana ki te ao, e ngā­ueue hoki ngā mea kaha o ngā rangi. ");
INSERT INTO mri_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ko reira rātou kite ai i te Tama a te tangata e haere mai ana i runga i te kapua, me te kaha, me te korōria nui. ");
INSERT INTO mri_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ā, nō ka tīmata ēnei mea te puta, ti­tiro ake, kia ara hoki ō koutou māte­nga; ka tata hoki tō koutou whaka­ora­nga.” ");
INSERT INTO mri_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nā, ka kōrero­tia e ia tētahi kupu whaka­rite ki a rātou: “Ti­tiro ki te piki, ki ngā rākau katoa. ");
INSERT INTO mri_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","I te mea e pihi ana, nā, ka kite koutou, ka mātau noa ake, kua tata te rau­mati. ");
INSERT INTO mri_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wai­hoki, ko koutou, ina kite i ēnei mea e puta ana, ka mātau kua tata te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“He pono tāku e mea nei ki a koutou, e kore rawa e pahemo tēnei whaka­tupu­ranga, kia puta rā anō ēnei mea katoa. ");
INSERT INTO mri_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","E pahemo te rangi me te whenua; ko āku kupu ia e kore e pahemo. ");
INSERT INTO mri_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Otirā, kia tūpato ki a koutou anō, kei tai­maha ō koutou ngākau i te kakai, i te hau­rangi, i ngā raru­raru o te ao, ā, ka puta whaka­rere mai taua rā, ānō he reti, ki a koutou. ");
INSERT INTO mri_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ka puta hoki ki ngā tāngata katoa e noho ana i te mata o te whenua katoa. ");
INSERT INTO mri_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mō konei rā kia mata­ara, i ngā wā katoa kia īnoi tonu, kia pai­ngia ai koutou kia mawhiti i ēnei mea katoa meāke nei puta, kia tū hoki i te aro­aro o te Tama a te tangata.” ");
INSERT INTO mri_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ā, i ia rā e whaka­ako ana ia i roto i te teme­para, ā, i ia pō e haere ana, ka noho i te maunga e kīa nei ko te Maunga o ngā Ōriwa. ");
INSERT INTO mri_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ā, i te atatū ka haere mai ngā tāngata ki a ia ki te teme­para, ki te whaka­rongo ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nā, kua tata te Hākari Taro Rēwenakore e kīa nei ko te Kape­nga. ");
INSERT INTO mri_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ā, ka rapu ngā tohu­nga nui me ngā kara­ipi ki te pēhea e whaka­mate ai rātou i a ia, i mataku hoki rātou i te iwi. ");
INSERT INTO mri_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nā, ka uru a Hātana ki a Hūrā, tōna ingoa nei ko Ikariote, ko ia nei tētahi o te tekau mā rua. ");
INSERT INTO mri_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ā, ka haere ia, ka kōrero ki ngā tohu­nga nui, ki ngā ranga­tira hōia, me pēhea e tukua ai ia e ia ki a rātou. ");
INSERT INTO mri_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ā, ka hari rātou, ka whaka­ae kia hoatu he moni ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nā, ka whaka­ae ia, ka rapu i te wā pai hei tuku­nga i a ia ki a rātou i te mea e ngaro atu ana te mano. ");
INSERT INTO mri_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nā, ka taka mai te rā o te Taro Rēwenakore i tika nei kia patua te Kape­nga. ");
INSERT INTO mri_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ka tonoa e ia a Pita rāua ko Hoani ka mea, “Tīkina, takā te Kape­nga mā tātou, kia kai ai tātou.” ");
INSERT INTO mri_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nā, ka mea rāua ki a ia, “Ko hea koe pai ai kia takā e māua?” ");
INSERT INTO mri_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ka mea ia ki a rāua “Nā, ka tomo kōrua ki te pā, ka tūtaki he tangata ki a kōrua e mau ana i te kāhaka wai, e aru kōrua i a ia ki te whare e tomo ai ia. ");
INSERT INTO mri_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ka kī atu ki te tangata i te whare, ‘E mea ana te Kai­whaka­ako ki a koe, “Kei hea te rūma e kai ai mātou ko āku ākonga i te Kape­nga?” ’ ");
INSERT INTO mri_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ā, ka whaka­atu­ria e ia ki a kōrua he rūma nui i runga, oti rawa te whā­riki; me taka e kōrua ki reira.” ");
INSERT INTO mri_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nā, haere ana rāua, ā, roko­hanga atu rite tonu ki tāna i kōrero ai ki a rāua, ā, takā ana e rāua te Kape­nga. ");
INSERT INTO mri_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ā, ka rite te hāora, ka noho ia, rātou ko ngā āpō­toro kotahi tekau mā rua. ");
INSERT INTO mri_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nā, ka mea ia ki a rātou, “Nui atu tōku hia­hia kia kai tahi tātou i tēnei Kape­nga, i te mea kāhore anō ahau i mate noa. ");
INSERT INTO mri_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ko tāku kupu hoki tēnei ki a koutou, e kore ahau e kai i tēnei ā muri ake nei, kia tino rite rā anō i te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nā, ka mau ia ki te kapu, ka mutu te whaka­whetai, ka mea ia, “Tango­hia tēnei, tu­whai­na mā koutou, ");
INSERT INTO mri_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ko tāku kupu hoki tēnei ki a koutou, e kore ahau e inu i te hua o te wāina, kia tae mai rā anō te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nā, ka mau ia ki te taro, ka mutu te whaka­whetai, ka whawhati, ka hoatu e ia ki a rātou, ka mea, “Ko tōku tinana tēnei e hoatu ana mō koutou; meinga tēnei hei whaka­mahara ki ahau.” ");
INSERT INTO mri_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","I pērā­tia anō hoki te kapu, i muri iho i te hapa, ā, i mea ia, “Ko te kawe­nata hou tēnei kapu i runga i ōku toto e ringi­hia nei mō koutou. ");
INSERT INTO mri_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Otirā, tēnei kei ahau nei, kei te tēpu, te ringa o te kai­tuku i ahau. ");
INSERT INTO mri_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","E haere ana hoki rā te Tama a te tangata, e pērā ana me te mea i whaka­ritea; otirā, auē mō te tangata e tukua ai ia!” ");
INSERT INTO mri_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nā, ka anga rātou, ka rapu ki a rātou anō, mā wai o rātou tēnei e mea. ");
INSERT INTO mri_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ā, ka ara anō he tau­tohe a rātou, ko wai o rātou e meinga ko te tangata tino nui. ");
INSERT INTO mri_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nā, ka mea ia ki a rātou, “Ko ngā kīngi o ngā tauiwi e whaka­rangatira ana ki a rātou; ko te hunga whai mana ki runga i a rātou ka kīa, ‘He hunga ata­whai’. ");
INSERT INTO mri_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Otiia, kaua koutou e pērā; engari, kia rite ki tō muri te mea nui o koutou kia rite anō te tino tangata ki te kai­mahi. ");
INSERT INTO mri_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ko wai hoki te mea nui, ko ia e noho ana ki te kai, ko te kai­mahi rānei? Ehara rānei te tangata e noho ana ki te kai? Tēnei rāia ahau i roto i a koutou te rite nei ki te kai­mahi. ");
INSERT INTO mri_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Otirā, ko koutou te hunga i noho tahi tonu me ahau i ōku whaka­mā­tautau­ranga. ");
INSERT INTO mri_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ā, ka whaka­rite ahau i te ranga­tira­tanga mō koutou, i te pērā me tā tōku Matua i whaka­rite ai mōku; ");
INSERT INTO mri_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kia kai ai, kia inu ai koutou ki tāku tēpu i tōku ranga­tira­tanga, ā, ka noho koutou ki runga ki ngā torōna, whaka­wā ai i ngā iwi kotahi tekau mā rua o Īharaira.” ");
INSERT INTO mri_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“E Haimona, e Haimona, nā, kua īnoi a Hātana kia riro koe i a ia, kia tā­tari­tia ai koutou e ia, ānō he wīti. ");
INSERT INTO mri_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Otiia, kua īnoi ahau mōu, kei hemo tōu whaka­pono, ā, ki te tahuri mai anō koe, whaka­kaha­ngia ōu tēina.” ");
INSERT INTO mri_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nā, ka mea tērā ki a ia, “E te Ariki, e pai ana ahau kia haere hei hoa mōu ki te whare here­here, ki te mate hoki.” ");
INSERT INTO mri_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Anō rā ko ia, “Tēnei tāku kupu ki a koe, e Pita, e kore te tī­kao­kao e tangi āia­nei, ka toru āu whaka­kāhore­tanga i tōu mātau ki ahau.” ");
INSERT INTO mri_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ā, ka mea ia ki a rātou, “I tāku tono­nga i a koutou, kāhore he pēke moni, kāhore he pūtea, kāhore he hū, i hapa rānei koutou i tētahi mea?” Ka mea rātou, “Kāhore.” ");
INSERT INTO mri_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Anō rā ko ia ki a rātou, “Tēnā, ko tēnei ki te mea he pēke moni tā tētahi, mauria atu, me te pūtea anō; me ia hoki kāhore āna hoari, hokona atu tōna kākahu, ka hoko mai ai i tētahi. ");
INSERT INTO mri_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ko tāku kupu hoki tēnei ki a koutou, ko te tikanga tēnei, kia rite i ahau te mea kua oti nei te tuhi­tuhi, arā, ‘Kua hui­huia ia ki te hunga hara,’ he tutuki­tanga hoki tō ngā mea mōku.” ");
INSERT INTO mri_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nā, ka mea rātou, “E te Ariki, nā, e rua ēnei hoari.” Ka mea ia ki a rātou, “Kāti anō.” ");
INSERT INTO mri_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nā, ka puta atu ia, ka haere ki Maunga Ōriwa, ko tāna hanga hoki tērā; me te aru anō āna ākonga i a ia. ");
INSERT INTO mri_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ā, i a ia i taua wāhi, ka mea ia ki a rātou, “Me īnoi kei uru koutou ki te whaka­mā­tautau­ranga.” ");
INSERT INTO mri_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nā, ka mawehe atu ia i a rātou, kei tō te taunga kāmaka te matara, ā, ka tuku i ōna turi ka īnoi, ");
INSERT INTO mri_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ka mea, “E Pā, ki te pai koe, tango­hia atu tēnei kapu i ahau; otirā kauaka e waiho i tāku e pai ai, engari i tāu.” ");
INSERT INTO mri_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nā, ka puta mai ki a ia tētahi ana­hera i te rangi, e whaka­kaha ana i a ia. ");
INSERT INTO mri_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ā, i te oke o tōna wairua, ka hōhonu ake tāna īnoi; ko tōna kakawa ka pēnā i te tepe toto e turu­turu iho ana ki te whenua. ");
INSERT INTO mri_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nā, ka ara ia i te īnoi, ā, ka tae ki āna ākonga, roko­hanga atu e moe ana rātou, he ngākau pōuri hoki. ");
INSERT INTO mri_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nā, ko tāna mea­tanga ki a rātou, “He aha koutou ka moe ai? Whaka­tika ki te īnoi, kei uru koutou ki te whaka­mā­tautau­ranga.” ");
INSERT INTO mri_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","I a ia e kōrero ana, nā, ko te hui­hui­nga tāngata, ā, ko tērā e huaina rā ko Hūrā, ko tētahi o te tekau mā rua, e haere ana i mua i a rātou; ā, ka whaka­tata ia ki a Īhu ki te kihi i a ia. ");
INSERT INTO mri_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Anō rā ko Īhu ki a ia, “E Hūrā, he kihi tāu hei tuku mō te Tama a te tangata?” ");
INSERT INTO mri_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ā, nō te kite­nga o te hunga i tōna taha i ngā mea tērā e tūpono, ka mea rātou, “E te Ariki, me patu rānei e mātou ki te hoari?” ");
INSERT INTO mri_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nā, hāua iho e tētahi o rātou te pono­nga a te tohu­nga nui, poroa ana tōna tari­nga matau. ");
INSERT INTO mri_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nā, ka oho a Īhu, ka mea, “Kāti rā i tēnei.” Whaka­pā­kia ana tōna tari­nga, nā kua ora. ");
INSERT INTO mri_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kātahi a Īhu ka mea ki ngā tohu­nga nui, ki ngā ranga­tira o te teme­para, ki ngā kaumātua, i haere atu ki a ia, “He tāhae ahau i haere mai ai koutou me ngā hoari, me ngā patu? ");
INSERT INTO mri_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","I ahau e noho ana i a koutou i te teme­para i ia rā, i ia rā, kīhai i totoro mai ō koutou ringa ki ahau. Otirā, nō koutou tēnei hāora, ko te kaha­nga hoki o te pōuri.” ");
INSERT INTO mri_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nā, ka hopu­kina ia e rātou, ka āra­hina atu, ā, kawea ana ki roto ki te whare o te tino tohu­nga. Ko Pita ia i aru mai i tawhiti. ");
INSERT INTO mri_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ā, nō ka oti i a rātou he kāpura te tahu ki waenga marae, i a rātou e noho tahi ana, ka noho hoki a Pita i waenga­nui o rātou. ");
INSERT INTO mri_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nā, ka kitea ia e tētahi kōtiro, i a ia e noho ana i te mārama o te kāpura, ā, mata­tau tonu te ti­tiro ki a ia, ka mea, “I a ia anō hoki tēnei.” ");
INSERT INTO mri_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nā, ka whaka­kāhore ia ki a ia, ka mea, “E kō, kāhore ahau e mōhio ki a ia.” ");
INSERT INTO mri_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ā, taro kau iho ka kite tētahi atu i a ia, ka mea, “Nō rātou hoki koe.” Nā, ka mea a Pita, “E mara, kāhore.” ");
INSERT INTO mri_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ā, me te mea kotahi te hāora i muri iho, ka tohe anō tētahi atu, ka mea, “He pono i a ia anō hoki tēnei; nō Kariri hoki.” ");
INSERT INTO mri_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ā, ka mea a Pita, “E mara, kāhore ahau e mātau ki tāu e mea nā.” Ā, i reira pū anō, i a ia e kōrero ana, ka tangi te tī­kao­kao. ");
INSERT INTO mri_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nā, ka tahuri te Ariki, ka ti­tiro ki a Pita. Ā, ka mahara a Pita ki te kupu a te Ariki, ki tāna mea­tanga ki a ia, “E kore e tangi te tī­kao­kao, ka toru āu whaka­kāhore­tanga i ahau.” ");
INSERT INTO mri_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nā, haere atu ana a Pita ki waho, ā, nui atu tōna tangi. ");
INSERT INTO mri_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nā, ka taunu ngā kai­pupuri o Īhu ki a ia, ka whiu i a ia. ");
INSERT INTO mri_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ka kōparea ōna kanohi, ā, ka ui rātou ki a ia, ka mea, “Poro­piti mai, nā wai koe i papaki?” ");
INSERT INTO mri_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","He maha hoki ērā atu kupu kino i kōrero ai rātou ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ā, i te aonga tonu­tanga o te rā, ka hui­hui ngā kaumātua o te iwi, ngā tohu­nga nui, me ngā kara­ipi, ā, āra­hina atu ana ia ki tō rātou rū­nanga, ka mea rātou, ");
INSERT INTO mri_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ki te mea ko te Karaiti koe, kōrero­tia mai ki a mātou.” Anō rā ko ia ki a rātou, “Ki te kōrero­tia e ahau ki a koutou, e kore koutou e whaka­pono; ");
INSERT INTO mri_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ki te ui ahau, e kore koutou e whaka­hoki kupu mai ki ahau. ");
INSERT INTO mri_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Haere ake nei ka noho te Tama a te tangata ki matau o te kaha o te Atua.” ");
INSERT INTO mri_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nā, ka mea rātou katoa, “Ko te Tama rānei koe a te Atua?” Anō rā ko ia ki a rātou, “Kua kōrero­tia mai nā e koutou ko ahau ia.” ");
INSERT INTO mri_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nā, ka mea rātou, “Hei aha ake he kai­whaka­atu mā tātou? Kua rongo nei hoki tātou i tā tōna māngai.” ");
INSERT INTO mri_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kātahi ka whaka­tika tō rātou hui­hui katoa, ā, āra­hina ana ia ki a Pirato. ");
INSERT INTO mri_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nā, ka anga rātou, ka whaka­pā hē ki a ia, ka mea, “Kua mau i a mātou tēnei tangata e kukume kē ana i te iwi, e mea ana kia kaua e hoatu te takoha ki a Hīhā, e kī ana he kīngi ia, ko te Karaiti.” ");
INSERT INTO mri_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nā, ka ui a Pirato ki a ia, ka mea, “Ko koe rānei te kīngi o ngā Hūrai?” Ka whaka­hoki ia ki a ia, ka mea, “Kua kōrero­tia mai nā e koe.” ");
INSERT INTO mri_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nā, ko te mea­tanga a Pirato ki ngā tohu­nga nui, ki ngā mano, “Kāhore tētahi hē o tēnei tangata i mau i ahau.” ");
INSERT INTO mri_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ā, nui atu tā rātou tohe ka mea, “E whaka­tūtehu ana ia i te iwi, e whaka­ako ana puta noa i Hūria, tīmata mai i Kariri, ā, tae noa mai ki konei.” ");
INSERT INTO mri_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","I te rongo­nga ia o Pirato ki Kariri, ka ui, “Nō Kariri rānei tēnei tangata?” ");
INSERT INTO mri_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ā, i tōna mōhio­tanga nō te ranga­tira­tanga ia o Herora, ka tonoa ia ki a Herora, i Hiruhārama hoki ia i aua rā. ");
INSERT INTO mri_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nā, i te kite­nga o Herora i a Īhu, nui rawa tōna hari, kua roa ia e hia­hia ana kia kite i a ia, he maha hoki ngā mea i rangona e ia mōna. Nā, ka tū­mana­ko ia kia kite i tētahi mere­kara e meinga ana e ia. ");
INSERT INTO mri_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nā, he maha ngā kupu i ui ai ia ki a ia; heoi, kāhore kau he kupu i whaka­hokia e ia. ");
INSERT INTO mri_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nā, tū ana ngā tohu­nga nui me ngā kara­ipi, kaha rawa hoki tā rātou whaka­pā hē ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nā, ka whākore­kore a Herora rātou ko āna hōia ki a ia, ka taunu, ā, ka oti ia te whaka­kākahu ki te kahu whaka­pai­pai, ka whaka­hokia atu ki a Pirato. ");
INSERT INTO mri_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","I taua rangi anō ka houhia te rongo a Pirato rāua ko Herora; i mua hoki e mauā­hara ana ki a rāua. ");
INSERT INTO mri_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nā, ka karanga­tia e Pirato ngā tohu­nga nui, ngā ranga­tira, me te iwi anō, ");
INSERT INTO mri_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ka mea ia ki a rātou, “Kua kawea mai nei e koutou tēnei tangata ki ahau, me te kī anō kei te kukume kē ia i te iwi; ā, ka oti nei ia te uiui e ahau i tō koutou aro­aro, nā, kīhai i mau i ahau tētahi hē o tēnei tangata i roto i ngā mea i whaka­pā­ngia nei e koutou ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ā, kīhai anō hoki a Herora, nāna ia i whaka­hoki mai ki a tātou, nā, kāhore āna mahi e tika ai kia mate ia. ");
INSERT INTO mri_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nā, me whiu ia e ahau, ka tuku atu ai.” ");
INSERT INTO mri_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kua takoto hoki te tikanga kia tukua atu tētahi ki a rātou i te hākari. ");
INSERT INTO mri_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nā, ka pānui rātou ki te karanga, ka mea, “Whaka­matea tēnei, ko Parapa te tuku mai ki a mātou” ");
INSERT INTO mri_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ko tēnei hoki i makā ki te whare here­here mō te nana­nga i nana ai ia i roto i te pā, mō te patu tangata.) ");
INSERT INTO mri_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nā, ka mea atu anō a Pirato, he mea hoki nāna kia tukua a Īhu. ");
INSERT INTO mri_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Heoi, hāmama ana rātou, mea ana, “Rīpekatia ia, rīpeka­tia!” ");
INSERT INTO mri_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ka mea anō ia ki a rātou, ko te toru o ngā mea­tanga, “He aha rā te kino i meinga e tēnei tangata? Kāhore anō i mau i ahau tētahi hē ōna e mate ai; māku ia e whiu, ka tuku atu ai.” ");
INSERT INTO mri_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Otirā, nui atu ō rātou reo ki te tohe e tono ana kia rīpeka­tia ia. Ā, riro rawa i tā ō rātou reo. ");
INSERT INTO mri_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nā, ka whaka­ōtia e Pirato kia waiho i tā rātou i tono ai. ");
INSERT INTO mri_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nā, ka tukua anō ki a rātou te tangata i makā ki te whare here­here mō te nana­nga, mō te patu tangata, tā rātou hoki i tono ai; ko Īhu ia i tukua ki tā rātou i pai ai. ");
INSERT INTO mri_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ā, i a rātou e ārahi ana i a ia, ka mau rātou ki tētahi tangata o Hairini, ki a Haimona, e haere mai ana i ngā whenua, ā, utaina ana ki a ia te rīpeka, kia amo­hia i muri i a Īhu. ");
INSERT INTO mri_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nā, he nui te hui­hui­nga o te iwi i aru i a ia, me ngā wāhine hoki e tangi ana, e auē ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nā, ka tahuri a Īhu ki a rātou, ka mea, “E ngā tamā­hine o Hiruhārama, kaua e tangi ki ahau, engari me tangi ki a koutou anō, ki ā koutou tama­riki. ");
INSERT INTO mri_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tērā hoki e puta ngā rā e mea ai rātou, ‘Koa tonu ngā pākoko, me ngā kōpū kāhore i whānau, me ngā ū kāhore i ngotea.’ ");
INSERT INTO mri_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ko reira tīmata ai rātou te mea ki ngā maunga, ‘Horo iho ki runga ki a mātou,’ ki ngā puke­puke hoki, ‘Hīpoki­na mātou.’ ");
INSERT INTO mri_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ki te meinga hoki ēnei mea e rātou i te rākau e kai­mata ana, ko te aha e meatia i te rākau ka maroke?” ");
INSERT INTO mri_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nā, tērā atu ētahi toko­rua, he hunga mahi kino, e āra­hina ngā­tahi­tia ana me ia kia whaka­matea. ");
INSERT INTO mri_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ā, ka tae rātou ki te wāhi e kīa nei ko Te Anga­anga, ka rīpeka­tia ia ki reira, me aua kai­mahi kino, kotahi ki matau, kotahi ki mauī. ");
INSERT INTO mri_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nā, ka mea a Īhu, “E Pā, houhia te rongo ki a rātou; kāhore hoki rātou e mōhio ki tā rātou e mea nei.” Ā, wehe­wehea ana ōna kākahu e rātou he mea maka ki te rota. ");
INSERT INTO mri_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Me te tū anō te iwi mā­taki­taki ai. Ko ngā ranga­tira hoki ka tāwai ki a ia, ka mea, “Ko ērā atu i whaka­ora­ngia e ia, māna anō ia e whaka­ora, ki te mea ia ko te Karaiti a te Atua, ko tāna i whiri­whiri ai!” ");
INSERT INTO mri_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ko ngā hōia ētahi i taunu ki a ia, ka haere mai me te kawe mai he winika ki a ia, ");
INSERT INTO mri_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ka mea, “Ki te mea ko koe te Kīngi o ngā Hūrai, whaka­ora i a koe.” ");
INSERT INTO mri_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ā, tērā te mea i tuhi­tuhia ki runga ake i a ia, “Ko te Kīngi tēnei o ngā Hūrai”. ");
INSERT INTO mri_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nā, ko tētahi o ngā kai­mahi kino i whaka­iria rā i kohu­kohu ki a ia, i mea, “Ki te mea ko te Karaiti koe, whaka­ora­ngia koe, māua hoki.” ");
INSERT INTO mri_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nā, ka whaka­hoki tētahi, ka riri ki a ia, ka mea, “E kore rānei koe e wehi ki te Atua, kei tēnei mate tahi nei hoki koe? ");
INSERT INTO mri_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ka tika rāia tō tāua; ka whi­whi hoki tāua ki ngā mea e tika ana mō ā tāua hanga; ko tēnei ia kāhore āna mahi hē.” ");
INSERT INTO mri_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nā, ko tāna mea­tanga ki a Īhu, “E te Ariki, kia mahara koe ki ahau ina haere mai koe i runga i tōu ranga­tira­tanga.” ");
INSERT INTO mri_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Anō rā ko Īhu ki a ia, “He pono tāku e mea nei ki a koe, ko āia­nei koe noho ai ki ahau ki Pararaiha.” ");
INSERT INTO mri_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nā, kua tata ki te ono o ngā hāora, ā, ka pōuri a runga o te whenua katoa, tae noa ki te iwa o ngā hāora. ");
INSERT INTO mri_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","I pōuri hoki te rā, ā, i wāhia te ārai o te whare tapu i waenga­nui pū. ");
INSERT INTO mri_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ā, nui atu te reo o Īhu ki te karanga; i mea ia, “E Pā, tēnei tōku wairua ka tukua atu nei ki ōu ringa.” Ka mutu ēnei kupu, ka hemo ia. ");
INSERT INTO mri_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ā, i te kite­nga o te kene­turio i taua mea, ka whaka­korōria ia i te Atua, ka mea, “He pono he tangata tika tēnei.” ");
INSERT INTO mri_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Me te hunga katoa hoki i hui­hui mai ki te mā­taki­taki, i tō rātou kite­nga i aua mea i meatia rā, ka pātuki i ō rātou uma, ā, hoki ana. ");
INSERT INTO mri_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ā, ko te hunga katoa i mōhio ki a ia, rātou ko ngā wāhine i aru mai i a ia i Kariri, i tū mai i tawhiti, mā­taki­taki ai ki ēnei mea. ");
INSERT INTO mri_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nā, tērā tētahi tangata, ko Hōhepa te ingoa, he tangata noho rū­nanga; he tangata pai, he tangata tika. ");
INSERT INTO mri_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kīhai ia i whaka­ae ki tō rātou whaka­aro, ki tā rātou mahi, nō Arimatia ia, nō tētahi pā o ngā Hūrai, ā, he tangata ia e tatari ana ki te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I haere ia ki a Pirato, ā, tonoa ana e ia te tinana o Īhu. ");
INSERT INTO mri_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nā, ka tango­hia iho e ia taua tinana, ā, takaia ana ki te rīnena, ka waiho ki te rua i hāua ki roto ki te kōhatu, kāhore hoki i takoto noa tētahi tangata ki reira. ");
INSERT INTO mri_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nā, ko te rā Taka­nga hākari ia, ā, meāke pūao te hāpati. ");
INSERT INTO mri_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","I aru anō ngā wāhine i haere tahi mai nei me ia i Kariri, ā, kite ana i te urupā, i te whaka­takoto­ranga anō o tōna tinana. ");
INSERT INTO mri_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nā, ka hoki rātou, ka mahi i ngā mea kakara, i ngā hinu. Ā, noho ana i te hāpati, he whaka­aro hoki ki te ture. ");
INSERT INTO mri_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nā, i te rā tua­tahi o te wiki, i te tino ata pō, ka haere mai rātou ki te urupā, me te mau mai i ngā mea kakara kua mahia nei e rātou. ");
INSERT INTO mri_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ā, roko­hanga atu e rātou kua huri­hia te kāmaka i te urupā. ");
INSERT INTO mri_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ā, ka tomo rātou ki roto, kīhai i kitea te tinana o te Ariki, o Īhu. ");
INSERT INTO mri_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nā, i a rātou e pō­kai­kaha ana ki tēnei, nā, tū ana ngā tāngata toko­rua i ō rātou taha, uira tonu ngā kākahu. ");
INSERT INTO mri_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nā, i a rātou e mataku ana, e kūpapa iho ana ō rātou kanohi ki te whenua, ka mea rāua ki a rātou, “He aha koutou ka rapu ai i te tangata ora i roto i te hunga mate? ");
INSERT INTO mri_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kāhore ia i konei, engari kua ara. Kia mahara ki tāna i mea ai ki a koutou i a ia anō i Kariri, ");
INSERT INTO mri_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ki tāna mea­tanga, ‘Kua takoto te tikanga kia tukua te Tama a te tangata ki ngā ringa o te hunga hara, kia rīpeka­tia, ā, i te toru o ngā rā ka ara.’ ” ");
INSERT INTO mri_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nā, ka mahara rātou ki āna kupu, ");
INSERT INTO mri_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ā, hoki mai ana i te urupā, ka kōrero i ēnei mea katoa ki te tekau mā tahi, ki a rātou ko ērā atu katoa. ");
INSERT INTO mri_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nā, ko Meri Makarini rātou ko Hoana, ko Meri whaea o Hēmi, ko ō rātou hoa wāhine, ngā kai­kōrero i ēnei mea ki ngā āpō­toro. ");
INSERT INTO mri_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ā, ko te āhua o aua kupu ki tā rātou whaka­aro he mea tito noa; kīhai i whaka­pono­hia e rātou. ");
INSERT INTO mri_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kātahi ka whaka­tika a Pita, ka oma ki te urupā. Ā, ko tōna piko­nga iho ka kite, ko ngā kākahu tākai anake e takoto ana; ā, hoki ana ki tōna whare me te mīharo anō i roto i a ia ki taua mea i meatia. ");
INSERT INTO mri_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nā, toko­rua o rātou e haere ana i taua rā ki tētahi kāinga, e ono tekau pā­ronga te matara i Hiruhārama, ko Emāuha te ingoa. ");
INSERT INTO mri_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","E kōrero­rero ana hoki rāua tētahi ki tētahi ki ēnei mea katoa i meinga. ");
INSERT INTO mri_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ā, i a rāua e kōrero­rero ana, e uiui ana ki a rāua, nā ko Īhu, ko ia tonu, kua whaka­tata, ā, haere tahi ana me rāua. ");
INSERT INTO mri_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","I puri­tia hoki ō rāua kanohi, i kore ai rāua e mōhio ki a ia. ");
INSERT INTO mri_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nā, ka mea ia ki a rāua, “He aha ēnei kupu e kōrero nei kōrua ki a kōrua, i a kōrua e haere nei?” Nā, ka tū rāua, kīhai i kori­kori, me te āhua pōuri. ");
INSERT INTO mri_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nā, ka whaka­hoki tētahi, ko Kereopa te ingoa, ka mea ki a ia, “I Hiruhārama koe e noho ana, ā, ko koe anake kāhore i mōhio ki ngā mea kua meinga nei ki reira i ēnei rā?” ");
INSERT INTO mri_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ka mea ia ki a rāua, “Ki ēhea mea?” Ka mea rāua ki a ia, “Ki ngā mea o Īhu o Nahareta, he poro­piti hoki ia, he kaha tāna mahi, tāna kupu, i te aro­aro o te Atua, o te iwi katoa. ");
INSERT INTO mri_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ki tōna hoatu­tanga e ngā tohu­nga nui, e ō mātou ranga­tira hoki kia tukua ki te mate, ā, rīpeka­tia ana ia. ");
INSERT INTO mri_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","I tū­mana­ko anō mātou ki a ia, māna e whaka­ora a Īharaira. Nā, i te taha o ēnei mea katoa, ko te toru tēnei o ngā rā i meinga ai ēnei mea. ");
INSERT INTO mri_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ā, mīharo noa iho mātou ki ētahi wāhine o mātou, i haere i te atatū ki te urupā; ");
INSERT INTO mri_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","heoi, i te kore­nga i kitea e rātou tōna tinana, ka hoki mai, ka mea, i kitea anō e rātou he pu­tanga ana­hera, e kī ana mai kei te ora ia. ");
INSERT INTO mri_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nā, ka haere atu ētahi o ō māua hoa ki te urupā, ā, roko­hanga atu, rite tonu ki tā ngā wāhine i kōrero ai; otirā, kīhai ia i kitea.” ");
INSERT INTO mri_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nā, ko tāna mea­tanga ki a rāua, “E te hunga whaka­aro­kore, ngākau pūhoi ki te whaka­pono ki ngā mea katoa i kōrero ai ngā poro­piti. ");
INSERT INTO mri_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kāhore ianei i takoto te tikanga kia pā ēnei mea ki a te Karaiti, kia tomo ia ki tōna korōria?” ");
INSERT INTO mri_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nā, ka tīmata ia ki tā Mohi, ki tā ngā poro­piti katoa, whaka­atu­ria ana ki a rāua ngā mea mōna o ngā karaipi­ture katoa. ");
INSERT INTO mri_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ā, ka tata ki te kāinga i haere ai rāua, nā, ka ahu atu ia, me te mea e haere tonu ana ia. ");
INSERT INTO mri_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nā, ka tohe rāua ki a ia, ka mea “E noho ki a māua; kua ahi­ahi hoki, kua tītaha te rā.” Nā, ka tomo atu ia, ka noho ki a rāua. ");
INSERT INTO mri_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ā, i tōna nohoa­nga iho ki a rāua ki te kai, ka mau ia ki te taro, ka whaka­pai, ka whawhati, ā, hoatu ana ki a rāua. ");
INSERT INTO mri_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nā, kua kite ō rāua kanohi, ā, ka mōhio ki a ia; ā, ngaro whaka­rere atu ia i a rāua. ");
INSERT INTO mri_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ā, ka mea rāua ki a rāua, “Kīhai koia ō tāua ngākau i mu­mura i roto i a tāua, i a ia e kōrero ana ki a tāua i te ara, e whaka­atu ana i ngā karaipi­ture ki a tāua?” ");
INSERT INTO mri_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nā, ka whaka­tika rāua i taua hāora anō, ā, hoki ana ki Hiruhārama, ā, roko­hanga atu kua hui­hui te tekau mā tahi me ō rātou hoa. ");
INSERT INTO mri_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","E mea ana, “Koia rawa anō! Kua ara te Ariki, kua puta ki a Haimona.” ");
INSERT INTO mri_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nā, ka kōrero­tia e rāua ngā mea­tanga i te ara, tō rāua mōhio­tanga hoki ki a ia i te whati­whatinga o te taro. ");
INSERT INTO mri_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ā, i a rāua e kōrero ana i ēnei mea, nā tērā ia tū ana i waenga­nui o rātou, mea ana ki a rātou, “Kia tau te rangi­mārie ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Otirā, koera ana rātou, wehi ana; i mahara hoki he wairua tā rātou i kite ai. ");
INSERT INTO mri_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nā, ko tāna mea­tanga ki a rātou, “He aha koutou ka poro­raru ai? Nā te aha hoki i puta ake ai ngā whaka­aro­aro­nga i roto i ō koutou ngākau? ");
INSERT INTO mri_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tiro­hia ōku ringa me ōku wae­wae, ko ahau tonu tēnei; whā­whā­kia ahau, kia kite ai koutou; kāhore hoki o te wairua kiko­kiko, wheua rānei, pēnei i ōku e kitea mai nā e koutou.” ");
INSERT INTO mri_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ā, nō ka kōrero­tia e ia tēnei, ka whaka­kitea e ia ki a rātou ōna ringa me ōna wae­wae. ");
INSERT INTO mri_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ā, i a rātou kāhore nei i whaka­pono i te hari, e mīharo ana hoki, ka mea ia ki a rātou, “He kai rānei tā koutou kei konei?” ");
INSERT INTO mri_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nā, ka hoatu e rātou ki a ia tētahi ika, he mea tunu­tunu. ");
INSERT INTO mri_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nā, ka tango ia, ā, kainga ana e ia i tō rātou aro­aro. ");
INSERT INTO mri_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","I mea anō ia ki a rātou, “Ko ngā kupu ēnei i kōrero ai ahau ki a koutou, i ahau anō i a koutou, me whaka­rite ngā mea katoa kua oti te tuhi­tuhi i roto i te ture a Mohi, i ngā poro­piti, i ngā waiata, mōku.” ");
INSERT INTO mri_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kātahi ia ka whaka­makoha i ō rātou hine­ngaro, kia mātau ai ki ngā karaipi­ture, ");
INSERT INTO mri_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ka mea ki a rātou, “Ko te mea tēnei i tuhi­tuhia: ko te tikanga anō tēnei, ko te Karaiti kia whaka­mamae­tia, kia ara anō i te hunga mate i te toru o ngā rā; ");
INSERT INTO mri_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","kia kauwhau­tia hoki te rīpe­netā me te muru­nga hara i runga i tōna ingoa ki ngā tauiwi katoa, ki Hiruhārama tīmata ai. ");
INSERT INTO mri_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nā, ko koutou hei kai­whaka­atu mō ēnei mea. ");
INSERT INTO mri_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nana, māku e tuku ki a koutou te mea i kōrero­tia i mua e tōku Matua; otiia, e noho koutou ki te pā, ki Hiruhārama, kia whi­whi rā anō ki te kaha i runga.” ");
INSERT INTO mri_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nā, āra­hina ana rātou e ia ki waho, ki Petani, nā, kua ara ōna ringa, whaka­pai­ngia ana rātou e ia. ");
INSERT INTO mri_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ā, i a ia e whaka­pai ana i a rātou, ka mawehe atu ia i a rātou, kā­hakina atu ana ki te rangi. ");
INSERT INTO mri_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nā, ka koro­piko rātou ki a ia, ā, hoki ana ki Hiruhārama, he nui hoki te koa. ");
INSERT INTO mri_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ā, noho tonu ai rātou i te teme­para, me te whaka­pai ki te Atua. Āmine.");
INSERT INTO mri_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","I te tīma­tanga te Kupu, i te Atua te Kupu, ko te Atua anō te Kupu. ");
INSERT INTO mri_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","I te Atua anō tēnei Kupu i te tīma­tanga. ");
INSERT INTO mri_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nāna ngā mea katoa i hanga; kāhore hoki tētahi mea i kore te hanga e ia o ngā mea i hangā. ");
INSERT INTO mri_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","I a ia te ora; ko te ora te mārama mō ngā tāngata. ");
INSERT INTO mri_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I roto i te pōuri te mārama e whiti ana; heoi, kīhai i mau i te pōuri. ");
INSERT INTO mri_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","I tonoa mai he tangata e te Atua, ko Hoani tōna ingoa. ");
INSERT INTO mri_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I haere mai ia hei kai­whaka­atu, hei whaka­atu mō te mārama, kia meinga ai e ia ngā tāngata katoa kia whaka­pono. ");
INSERT INTO mri_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ehara ia i te mārama, engari, i haere mai hei kai­whaka­atu mō te mārama. ");
INSERT INTO mri_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ko te mārama pono tērā, arā, ko te mārama e mārama ai ngā tāngata katoa e haere mai ana ki te ao. ");
INSERT INTO mri_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I te ao ia, i hangā anō e ia te ao, ā, kīhai te ao i mōhio ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I haere mai ia ki ōna, ā, kīhai ōna i manako ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tēnā ko te hunga i manako ki a ia i tukua e ia ki a rātou ngā tikanga e meinga ai rātou hei tama­riki mā te Atua, arā ki te hunga e whaka­pono ana ki tōna ingoa. ");
INSERT INTO mri_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ki te hunga ehara nei i te toto, ehara i tā te kiko­kiko i pai ai, ehara i tā te tangata i pai ai, engari, nā te Atua i whānau ai. ");
INSERT INTO mri_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","I whaka­kiko­kiko­tia te Kupu, ā, noho ana i a mātou, i kite anō mātou i tōna korōria he korōria e rite ana ki tō te Tama kotahi a te Matua, kī tonu i te aroha noa, i te pono. ");
INSERT INTO mri_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","I kōrero­tia ia e Hoani; i karanga tērā, i mea, “Ko ia tēnei i kōrero­tia rā e ahau, ‘Ko ia e haere mai ana i muri i ahau e meinga ana ki mua i ahau; nō mua hoki ia i ahau.’ ” ");
INSERT INTO mri_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kua riro hoki i a tātou katoa tētahi wāhi o tōna ranea­tanga, te aroha noa hono iho ki te aroha noa. ");
INSERT INTO mri_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nā Mohi hoki i hōmai te ture; ko te aroha noa me te pono i ahu mai i a Īhu Karaiti. ");
INSERT INTO mri_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kāhore anō he tangata i kite noa i te Atua; ko te Tama kotahi, kei te uma nei o te Matua, nāna ia i whaka­puaki. ");
INSERT INTO mri_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nā, ko te kōrero tēnei a Hoani, i te tono­nga mai a ngā Hūrai i Hiruhārama i ngā tohu­nga nui rātou ko ngā Rīwaiti hei ui ki a ia, “Ko wai koe?” ");
INSERT INTO mri_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nā, ka whākina e ia, kīhai i whaka­kāhore, i whāki hoki, “Ehara ahau i a te Karaiti.” ");
INSERT INTO mri_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ā, ka ui rātou ki a ia, “Tēnā, pēhea? Ko Irāia koe?” Ka mea ia, “Kāhore.” “Ko te poro­piti oti koe?” Ka whaka­hokia e ia, “Kāhore.” ");
INSERT INTO mri_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nā, ka mea rātou ki a ia, “Ko wai koia koe? Hei kupu whaka­hoki mā mātou ki te hunga i tonoa mai ai mātou. E pēhea ana koe ki a koe?” ");
INSERT INTO mri_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ka mea ia: “He reo ahau nō tētahi e karanga ana i te koraha, ‘Whaka­tikaia te hua­rahi o te Ariki!’ He pērā me tā Ihāia poro­piti i mea ai.” ");
INSERT INTO mri_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nō ngā Parihi hoki te hunga i tonoa mai rā. ");
INSERT INTO mri_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nā, ka ui rātou ki a ia, ka mea ki a ia, “He aha oti koe i iri­iri ai, ki te mea ehara koe i a te Karaiti, ehara i a Irāia, ehara i te poro­piti?” ");
INSERT INTO mri_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nā, ka whaka­hoki a Hoani ki a rātou, ka mea, “He iri­iri tāku ki te wai; otiia tēnā te tū nā i waenga­nui i a koutou tētahi kāhore e mōhio­tia e koutou. ");
INSERT INTO mri_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ko ia tēnei e haere mai ana i muri i ahau kāhore hoki ahau e tau hei wewete i te here o tōna hū.” ");
INSERT INTO mri_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","I meatia ēnei mea ki Petapara, ki tāwāhi atu o Horano, ki te wāhi e iri­iri ana a Hoani. ");
INSERT INTO mri_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","I te aonga ake, ka kite ia i a Īhu e haere ana mai ki a ia, ka mea, “Nā, te Reme a te Atua, hei waha atu i te hara o te ao! ");
INSERT INTO mri_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ko ia tēnei i kōrero ai ahau, ‘Kei te haere mai i muri i ahau tētahi tangata kua meinga ki mua i ahau; nō mua hoki ia i ahau.’ ");
INSERT INTO mri_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ā, kāhore ahau i mātau ki a ia; heoi, hei whaka­kite i a ia ki a Īharaira, i haere mai ai ahau me tāku iri­iri ki te wai.” ");
INSERT INTO mri_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nā, ka whaka­atu a Hoani, ka mea, “I kite ahau i te Wairua e heke iho ana i te rangi, ānō he kūkupa, ā, noho ana i runga i a ia. ");
INSERT INTO mri_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ā, kāhore ahau i mātau ki a ia; engari i kī mai ki ahau te kai­tono mai i ahau ki te iri­iri ki te wai, ‘Ko te tangata e kite ai koe i te Wairua e heke iho ana, e noho ana ki runga ki a ia, ko ia tēnā te kai­iri­iri ki te Wairua Tapu.’ ");
INSERT INTO mri_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ā, kua kite ahau, kua whaka­atu nei hoki, ko te Tama tēnei a te Atua.” ");
INSERT INTO mri_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","I te aonga ake i te tū anō a Hoani me āna ākonga toko­rua; ");
INSERT INTO mri_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","nā, ka ti­tiro ia ki a Īhu e haere ana, ka mea, “Nā, te Reme a te Atua!” ");
INSERT INTO mri_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ā, ka rongo ngā ākonga toko­rua ki a ia e kōrero ana, ā, aru ana rāua i a Īhu. ");
INSERT INTO mri_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ā, ka tahuri a Īhu, ka kite i a rāua e aru ana, ka mea ia ki a rāua “E rapu ana kōrua i te aha?” Nā, ko tā rāua mea­tanga ki a ia, “E Rapi” (ko te tikanga tēnei ina whaka­māori­tia, e te Kai­whaka­ako), “kei hea tōu kāinga?” ");
INSERT INTO mri_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ka mea ia ki a rāua, “Haere mai kia kite.” Haere ana rāua, ā, ka kite i tōna wāhi i noho ai, ā, noho ana i a ia i taua rā; ko te tekau hoki ia o ngā hāora. ");
INSERT INTO mri_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ko Anaru, teina o Haimona Pita tētahi o taua toko­rua i rongo nei ki a Hoani e kōrero ana, ā, aru ana i a ia. ");
INSERT INTO mri_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ko ia kua kite wawe i tōna tua­kana ake, i a Haimona, ka mea ki a ia, “Kua kitea e māua te Mīhaia.” (Ko te tikanga tēnei ina whaka­māori­tia, ko te Karaiti). ");
INSERT INTO mri_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nā, ka āra­hina mai ia e ia ki a Īhu. Ā, ka ti­tiro a Īhu ki a ia, ka mea, “Ko Haimona koe, ko te tama a Hona, me hua koe ko Kipa.” (Tōna whaka­māori­tanga ko Pita, arā ko Kōhatu). ");
INSERT INTO mri_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","I te aonga ake ka mea a Īhu kia haere ki Kariri, ā, ka kite i a Piripi; ā, ka mea a Īhu ki a ia, “E aru i ahau.” ");
INSERT INTO mri_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Nā, ko Piripi nō Petahaira, nō te pā o Anaru rāua ko Pita.) ");
INSERT INTO mri_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ka kite a Piripi i a Natanahira, ka mea ki a ia, “Kua kitea e mātou a ia, mōna nei te tuhi­tuhi a Mohi i roto i te ture, tā ngā poro­piti hoki, a Īhu o Nahareta te tama a Hōhepa.” ");
INSERT INTO mri_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nā, ka mea a Natanahira ki a ia, “E puta koia tētahi mea pai i Nahareta?” Ka mea a Piripi ki a ia, “Haere mai kia kite.” ");
INSERT INTO mri_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ka kite a Īhu i a Natanahira e haere ana mai ki a ia, ka puaki tāna kupu mōna, “Nā, he tino tangata nō Īharaira, kāhore ōna tini­hanga.” ");
INSERT INTO mri_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ka mea a Natanahira ki a ia, “Nō hea koe i mātau ai ki ahau?” Ka whaka­hoki a Īhu ki a ia, ka mea, “I te mea kīanō koe i karanga­tia e Piripi, i a koe anō i raro i te piki, i kite ahau i a koe.” ");
INSERT INTO mri_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nā, ka whaka­hoki a Natanahira, ka mea ki a ia, “E Rapi, ko te Tama koe a te Atua, ko te Kīngi koe o Īharaira!” ");
INSERT INTO mri_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nā, ka whaka­hoki a Īhu, ka mea ki a ia, “Nō tāku mea­tanga ki a koe, ‘I kite ahau i a koe i raro i te piki’, i whaka­pono ai koe? Rahi atu i ēnei ngā mea e kitea e koe.” ");
INSERT INTO mri_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","I mea anō ia ki a ia, “He pono, he pono tēnei kupu āku ki a koutou, tērā koutou e kite i te rangi e tu­whera ana, i ngā ana­hera a te Atua e piki ake ana, e heke iho ana ki te Tama a te tangata.” ");
INSERT INTO mri_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nā, i te toru o ngā rā he mārena i Kana o Kariri, ā, i reira te whaea o Īhu. ");
INSERT INTO mri_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","I karanga­tia anō a Īhu rātou ko āna ākonga ki te mārena. ");
INSERT INTO mri_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ā, i te paunga o te wāina, ka mea te whaea o Īhu ki a ia, “Kāhore ā rātou wāina.” ");
INSERT INTO mri_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ka mea a Īhu ki a ia, “E tai, he aha tāku ki a koe? Kāhore anō kia taea noatia tōku hāora.” ");
INSERT INTO mri_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ka mea tōna whaea ki ngā kai­mahi, “Ko tāna e mea ai ki a koutou, meatia.” ");
INSERT INTO mri_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nā, i reira ētahi ipu kōhatu e ono e tū ana, he tikanga nā ngā Hūrai mō te horoi, e rua, e toru ngā mēhua o tētahi, o tētahi, ina kī. ");
INSERT INTO mri_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ka mea a Īhu ki a rātou, “Whaka­kīa ngā ipu ki te wai.” Ā, whaka­kīa ana e rātou, pūrena noa. ");
INSERT INTO mri_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nā, ka mea ia ki a rātou, “Tēnā, utuhia, kawea atu ki te ranga­tira o te hākari.” Ā, kawea ana e rātou. ");
INSERT INTO mri_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ā, nō ka whaka­mātau te ranga­tira o te hākari i te wai i whaka­wāina­tia, ā, kīhai i mōhio nō hea rānei (ko ngā pono­nga ia i utuhia ai te wai i mōhio), ka karanga te ranga­tira o te hākari ki te tāne mārena hou, ");
INSERT INTO mri_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ka mea ki a ia, “E whaka­takoto­ria ana e ngā tāngata katoa te wāina pai i te tīma­tanga; ā, ka roa te inu­manga, mō reira te wāina he iti iho nei te pai ko koe ia, kua tohu i te wāina pai mō nāia­nei.” ");
INSERT INTO mri_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","I meatia tēnei tīma­tanga mere­kara e Īhu ki Kana o Kariri, i whaka­kitea e ia tōna korōria; ā, whaka­pono ana āna ākonga ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Muri iho i tēnei ka haere iho ia ki Kaperenauma, ā, ia, tōna whaea, ōna tēina, me āna ākonga; ā, kīhai i maha ngā rā i noho ai rātou ki reira. ");
INSERT INTO mri_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nā, kua tata te Kape­nga o ngā Hūrai, ā, ka haere a Īhu ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nā, roko­hanga atu e ia i roto i te teme­para e noho ana ngā kai­hoko kau, hipi, kūkupa, me ngā kai­whaka­whiti­whiti moni. ");
INSERT INTO mri_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ā, ka hangā e ia he whiu ki ngā aho no­nohi, ka whiua katoa­tia e ia ki waho i te teme­para, ngā hipi, me ngā kau; ringi­hia ana hoki te moni a ngā kai­whaka­whiti­whiti moni, tura­kina ake ngā tēpu. ");
INSERT INTO mri_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","I mea anō ia ki ngā kai­hoko kūkupa, “Tango­hia atu ēnei i konei; aua te whare o tōku Matua e meinga hei whare hoko­hoko.” ");
INSERT INTO mri_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ā, ka mahara āna ākonga ki te mea i tuhi­tuhia, “Ka pau ahau i te aroha ki tōu whare.” ");
INSERT INTO mri_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nā, ka whaka­hoki ngā Hūrai, ka mea ki a ia, “He aha te tohu e whaka­kitea ana e koe ki a mātou, inā koe ka mea nei i ēnei mea?” ");
INSERT INTO mri_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Wā­wāhia tēnei whare tapu, ā, kia toru ngā rā ka ara anō i ahau.” ");
INSERT INTO mri_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Anō rā ko ngā Hūrai, “E whā tekau mā ono ngā tau i hangā ai tēnei whare tapu, e oti rānei te hanga e koe i ngā rā e toru?” ");
INSERT INTO mri_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Otirā, ko te whare tapu o tōna tinana tāna i kōrero ai. ");
INSERT INTO mri_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nā reira, i tōna aranga ake i te hunga mate, ka mahara āna ākonga ki tāna kōrero­tanga i tēnei; ā, whaka­pono ana rātou ki te karaipi­ture, ki te kupu hoki i kōrero­tia e Īhu. ");
INSERT INTO mri_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nā, i a ia i Hiruhārama, i te Kape­nga, i te hākari, he toko­maha i whaka­pono ki tōna ingoa, i tō rātou kite­nga i āna mere­kara i meatia e ia. ");
INSERT INTO mri_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Otirā, kīhai a Īhu i tuku atu i a ia ki a rātou, i mōhio hoki ia ki ngā tāngata katoa. ");
INSERT INTO mri_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ā, kāhore āna mea­tanga kia whaka­atu­ria te tangata e tētahi; i mātau hoki ia ki te mea i roto i te tangata. ");
INSERT INTO mri_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nā, he tangata tērā nō ngā Parihi, ko Nikorima tōna ingoa, he ranga­tira nō ngā Hūrai. ");
INSERT INTO mri_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ka haere mai tēnei ki a Īhu i te pō, ka mea ki a ia, “E Rapi, e mātau ana mātou i haere mai koe i te Atua hei kai­whaka­ako, inā hoki e kore tētahi tangata e āhei te mea i ēnei mere­kara e meatia nei e koe, ki te kāhore te Atua i a ia.” ");
INSERT INTO mri_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ka whaka­hoki a Īhu, ka mea ki a ia, “He pono, he pono, tāku e mea nei ki a koe, ki te kāhore te tangata e whānau hou, e kore ia e āhei te kite i te ranga­tira­tanga o te Atua.” ");
INSERT INTO mri_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ka mea a Nikorima ki a ia, “Me pēhea ka whānau ai te tangata i tōna koro­heke­tanga? E taea rānei te tuarua o ngā haere­nga ki roto ki te kōpū o tōna whaea, whānau mai ai?” ");
INSERT INTO mri_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ka whaka­hokia e Īhu, “He pono, he pono tāku e mea nei ki a koe, Ki te kāhore te tangata e whānau i te wai, i te Wairua hoki, e kore ia e āhei te tomo ki te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ko tā te kiko­kiko e whānau ai he kiko­kiko; ko tā te Wairua e whānau ai he wairua. ");
INSERT INTO mri_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aua rā e mīharo ki tāku i mea nei ki a koe, ‘He mea tūturu tēnei kia whānau hou koutou.’ ");
INSERT INTO mri_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","E pupuhi ana te hau ki tāna wāhi e pai ai, ka rongo hoki koe ki tōna haruru otiia e kore e mōhio­tia e koe te wāhi i puta mai ai, e tae atu ai rānei. Ko te rite­nga tēnei ki te hunga katoa ka whānau i te Wairua.” ");
INSERT INTO mri_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ka whaka­hoki a Nikorima, ka mea ki a ia, “Me pēhea ka taea ai ēnei mea?” ");
INSERT INTO mri_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ka whaka­hoki a Īhu, ka mea ki a ia, “Ko koe te Kai­whaka­ako o Īharaira, ā, kāhore i mātau ki ēnei mea? ");
INSERT INTO mri_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","He pono, he pono tāku e mea nei ki a koe, e kōrero­tia ana e mātou tā mātou i mātau ai, e whaka­atu­ria ana tā mātou i kite ai; heoi, e kore koutou e tango ki tā mātou whaka­atu­ranga. ");
INSERT INTO mri_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ki te mea kua kōrero­tia e ahau ki a koutou ngā mea o te whenua, ā, kāhore koutou e whaka­pono, me pēhea ka whaka­pono ai ki te kōrero­tia e ahau ki a koutou ngā mea o te rangi? ");
INSERT INTO mri_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kāhore hoki he tangata i kake noa ki te rangi, ko ia anake i heke iho i te rangi, arā ko te Tama a te tangata, e noho mai nei i te rangi.” ");
INSERT INTO mri_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ka rite hoki ki tā Mohi whaka­iri­nga i te nākahi i te koraha, kua takoto te tikanga kia pērā te whaka­iri­nga o te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kia kāhore ai e ngaro te tangata e whaka­pono ana ki a ia, engari kia whi­whi ai ki te ora tonu. ");
INSERT INTO mri_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Koia anō te aroha o te Atua ki te ao, hōmai ana e ia tāna Tama kotahi, kia kāhore ai e ngaro te tangata e whaka­pono ana ki a ia, engari kia whi­whi ai ki te ora tonu. ");
INSERT INTO mri_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kīhai hoki te Atua i tono mai i tāna Tama ki te ao ki te whaka­hē i te ao; engari kia ora ai te ao i a ia. ");
INSERT INTO mri_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ko ia e whaka­pono ana ki a ia, e kore e tau te hē ki a ia; tēnā ko ia e kore e whaka­pono, kua whaka­hē­ngia noatia ake, mōna kīhai i whaka­pono ki te ingoa o te Tama kotahi a te Atua. ");
INSERT INTO mri_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ko te whaka­hē­nga hoki tēnei, nō te mea kua tae mai nei te mārama ki te ao, ā, nui atu tō ngā tāngata aroha ki te pōuri i tō rātou ki te mārama, he kino hoki nō ā rātou mahi. ");
INSERT INTO mri_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","E kino ana hoki ki te mārama ngā kai­mahi katoa i te kino, e kore anō hoki e haere mai ki te mārama, kei whaka­kitea ā rātou mahi. ");
INSERT INTO mri_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tēnā ko te kai­mahi i te pono, e haere mai ana ki te mārama, kia kitea ai āna mahi, he mea mahi i roto i te Atua. ");
INSERT INTO mri_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ā, nō muri i ēnei mea ka haere a Īhu, rātou ko āna ākonga, ki te whenua o Hūria; ā, noho tahi ana rātou ki reira, me tāna iri­iri anō. ");
INSERT INTO mri_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nā, i te iri­iri anō hoki a Hoani ki Ēnona, ki tētahi wāhi e tata ana ki Harema, nō te mea he nui te wai o reira; ā, ka haere mai rātou, ka iri­iria. ");
INSERT INTO mri_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kāhore anō hoki a Hoani i pangā ki te whare here­here. ");
INSERT INTO mri_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nā, ka ara he totohe a ngā ākonga a Hoani ki tētahi Hūrai mō te pure­nga. ");
INSERT INTO mri_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ā, ka haere rātou ki a Hoani, ka mea ki a ia, “E Rapi, ko te tangata i tāwāhi nā kōrua o Horano, ko tāu i whaka­atu mai nā, Nana, kei te iri­iri ia, e haere ana hoki te katoa ki a ia.” ");
INSERT INTO mri_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ka whaka­hoki a Hoani, ka mea, “E kore tētahi mea e riro i te tangata, ki te kore e hōmai ki a ia i te rangi. ");
INSERT INTO mri_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ko koutou hei kai­whakaae ki ahau, ki tāku mea­tanga, ‘Ehara ahau i a te Karaiti, engari i tonoa mai ahau i mua i a ia.’ ");
INSERT INTO mri_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ko te tangata i te wahine mārena hou, ko ia te tāne mārena hou. Nā, ko te hoa o te tāne mārena hou, e tū ana, e rongo ana ki a ia, ka hari pū ki te reo o te tāne mārena hou. Nā reira i tutuki ai tēnei hari ōku. ");
INSERT INTO mri_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ko te tikanga tēnei, ko ia kia nui haere, ko ahau kia iti haere.” ");
INSERT INTO mri_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ko ia e haere mai ana i runga, kei runga ake ia i te katoa; ko tō te whenua nō te whenua ia, nō te whenua anō āna kōrero. Ko ia e haere mai ana i te rangi, kei runga ake ia i te katoa. ");
INSERT INTO mri_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ā, ko tāna i kite ai, i rongo ai, ko ia tāna e whaka­atu ai; kāhore hoki tētahi tangata e tango atu ki tāna whaka­atu­ranga. ");
INSERT INTO mri_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ki te manako tētahi ki tāna whaka­atu­ranga, kua piri tāna tohu ki te pono o tā te Atua. ");
INSERT INTO mri_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ko tā te Atua i tono mai ai, e kōrero ana ia i ngā kupu a te Atua; kāhore hoki te Wairua e hōmai e te Atua i runga i te mēhua. ");
INSERT INTO mri_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","E aroha ana te Matua ki te Tama, kua hoatu anō ngā mea katoa ki tōna ringa. ");
INSERT INTO mri_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ko ia e whaka­pono ana ki te Tama, he ora tonu tōna; ko ia e kore e whaka­pono ki te Tama, e kore e kite i te ora, engari ka mau tonu te riri a te Atua ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ā, nō ka mōhio te Ariki, kua rongo ngā Parihi, ko ngā ākonga a Īhu i mea ai, i iri­iri ai, he toko­maha atu i a Hoani. ");
INSERT INTO mri_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(He ahakoa rā ehara i a Īhu nāna i iri­iri, nā āna ākonga ia.) ");
INSERT INTO mri_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ka mahue a Hūria i a ia, ā, hoki ana anō ki Kariri. ");
INSERT INTO mri_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nā, ko te ara mōna i tika nā Hamaria. ");
INSERT INTO mri_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ā, ka haere ia ki tētahi pā o Hamaria, ko Haika te ingoa, e pātata ana ki te wāhi i hoatu e Hākopa ki tāna tama, ki a Hōhepa. ");
INSERT INTO mri_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kei reira hoki te puna a Hākopa. Nā, kua nge­nge a Īhu i te haere­nga, heoi noho ana ia ki te taha o te puna, ā, meāke ko te ono o ngā hāora. ");
INSERT INTO mri_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ka haere mai tētahi wahine o Hamaria ki te utu wai. Ka mea a Īhu ki a ia, “Hōmai he wai mōku.” ");
INSERT INTO mri_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Kua riro hoki āna ākonga ki te pā, ki te hoko kai.) ");
INSERT INTO mri_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nā, ko te mea­tanga a te wahine o Hamaria ki a ia, “He aha koe, he Hūrai nā koe, ka tono mai ai i te wai i ahau, he wahine nei ahau nō Hamaria?” (Kāhore hoki e tātata ana ngā Hūrai ki ngā Hamari.) ");
INSERT INTO mri_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ka whaka­hoki a Īhu, ka mea ki a ia, “Me i mātau koe ki tā te Atua e hōmai ai, ki tēnei hoki e mea nei ki a koe, ‘Hōmai he wai mōku,’ pēnei kua tono koe ki a ia, ā, kua hoatu e ia te wai ora ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ka mea te wahine ki a ia, “E kara, kāhore āu mea hei utu wai, he hōhonu anō te puna. Nō hea tēnā wai ora āu? ");
INSERT INTO mri_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","He nui oti koe i tō mātou matua, i a Hākopa, i hōmai ai te puna ki a mātou, inu ana ia i konei, rātou ko āna tama­riki, me āna kararehe?” ");
INSERT INTO mri_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ka whaka­hoki a Īhu, ka mea ki a ia, “E mate anō i te wai te tangata e inu ana i tēnei wai; ");
INSERT INTO mri_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","tēnā ko te tangata e inu ana i te wai e hoatu e ahau ki a ia, e kore ia e mate i te wai ā ake ake. Engari, te wai e hoatu e ahau ki a ia, hei puna wai tēnā i roto i a ia e pupū ake ana, ā te ora tonu rā anō.” ");
INSERT INTO mri_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ka mea te wahine ki a ia, “E kara, hōmai ki ahau tēnei wai, kei mate ahau i te wai, kei haere mai hoki ki konei rawa utu ai.” ");
INSERT INTO mri_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ka mea a Īhu ki a ia, “Tīkina, karanga­tia tō tahu, ka hoki mai ai.” ");
INSERT INTO mri_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ka whaka­hoki te wahine, ka mea, “Kāhore āku tahu.” Ka mea a Īhu ki a ia, “He kōrero tika tāu, ‘Kāhore āku tahu’; ");
INSERT INTO mri_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","inā hoki kua toko­rima āu tahu, ko ia i a koe nei ehara i te tahu nāu. He pono tēnei kōrero āu.” ");
INSERT INTO mri_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ka mea te wahine ki a ia, “E kara, e kite ana ahau he poro­piti koe. ");
INSERT INTO mri_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","I kara­kia ō mātou mātua i runga i tēnei maunga; ā, e mea ana koutou, Ko Hiruhārama te wāhi e tika ai te kara­kia.” ");
INSERT INTO mri_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ka mea a Īhu ki a ia, “E tai, whaka­pono ki ahau, meāke puta te wā, e kore ai koutou e kara­kia ki te Matua i runga i tēnei maunga, e kore anō i Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kāhore koutou e mōhio ki tā koutou e kara­kia nei; e mātau ana mātou ki tā mātou e kara­kia nei; nō ngā Hūrai nei hoki te ora. ");
INSERT INTO mri_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Otirā, meāke puta te wā, ā, tēnei anō, e kara­kia ai ngā kai­karakia pono ki te Matua i runga i te wairua, i te pono; e rapu ana hoki te Matua ki te pērā hei kara­kia ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","He Wairua te Atua; me kara­kia hoki ngā kai­karakia ki a ia i runga i te wairua, i te pono.” ");
INSERT INTO mri_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ka mea te wahine ki a ia, “E mātau ana ahau kei te haere mai te Mīhaia,” (e kīa nei ko te Karaiti). “Ka tae mai ia, māna ngā mea katoa e kōrero ki a tātou.” ");
INSERT INTO mri_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ka mea a Īhu ki a ia, “Ko ahau anō ia e kōrero nei ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nā, ka puta i reira āna ākonga, ka mīharo ki tāna kōrero­tanga ki te wahine; heoi, kīhai tētahi i mea, “He aha tāu e rapu? He aha koe ka kōrero ai ki a ia?” ");
INSERT INTO mri_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nā, ka whaka­rērea e te wahine tāna ipu, ā, haere ana ki te pā, ka mea ki ngā tāngata, ");
INSERT INTO mri_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Haere mai, kia kite i te tangata i kōrero­tia mai ai ki ahau ngā mea katoa i mea ai ahau. Ehara rānei tēnei i a te Karaiti?” ");
INSERT INTO mri_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ka puta rātou ki waho o te pā, ā, ka ahu mai ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","I taua takiwā anō ka tohe ngā ākonga ki a ia, ka mea, “E te Kai­whaka­ako, e kai rā.” ");
INSERT INTO mri_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Otirā, ka mea ia ki a rātou, “He kai anō tāku hei kai māku, kāhore koutou e mātau.” ");
INSERT INTO mri_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nā, ka mea ngā ākonga tētahi ki tētahi, “I kawea mai rānei e tētahi he kai māna?” ");
INSERT INTO mri_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ka mea a Īhu ki a rātou, “Ko tāku kai tēnei, ko te mea i tā tōku kai­tono e pai ai, kia whaka­otia hoki tāna mahi.” ");
INSERT INTO mri_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","E kore ianei koutou e mea, “Kia whā atu ngā marama, ā, ka taea te kotinga? Nana, ko tāku kupu tēnei ki a koutou, kia ara ake ō koutou kanohi, ti­tiro ki ngā māra; kua mā noa ake; ko te kotinga tēnei. ");
INSERT INTO mri_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ka whi­whi te kai­kokoti ki te utu, ka kohia anō hoki e ia ngā hua mō te ora tonu; kia hari tahi ai te kairui rāua ko te kai­kokoti. ");
INSERT INTO mri_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nā, konei hoki i pono ai taua kī, ‘E rui ana tētahi, e kokoti ana tētahi.’ ");
INSERT INTO mri_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","I tonoa koutou e ahau ki te kokoti i te mea kīhai i mahia e koutou. He tangata kē nāna i mahi, ā, kua uru koutou ki ā rātou mahi.” ");
INSERT INTO mri_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ā, he toko­maha ngā Hamari o taua pā i whaka­pono ki a ia, mō te kī a te wahine i mea rā, “I kōrero­tia mai e ia ki ahau ngā mea katoa i mea ai ahau.” ");
INSERT INTO mri_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ā, nō ka tae ngā Hamari ki a ia, ka mea kia noho ia ki a rātou; ā, e rua ngā rā i noho ai ia ki reira. ");
INSERT INTO mri_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nā, hira noa ake ngā tāngata i whaka­pono, he mea hoki nā tāna kupu. ");
INSERT INTO mri_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","I mea anō ki te wahine, “Ehara i te mea nā tāu kupu i whaka­pono ai mātou ināia­nei; kua rongo nei hoki mātou ake, ā, ka mātau, ko te Karaiti pū tēnei, ko te Kai­whaka­ora o te ao.” ");
INSERT INTO mri_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ka pahure aua rā e rua, ka tūria atu e ia i reira, ā, haere ana ki Kariri. ");
INSERT INTO mri_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ko Īhu tonu hoki nāna te kī, kāhore he hōnore o te poro­piti i tōna kāinga ake. ");
INSERT INTO mri_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Heoi, i tōna taenga ki Kariri, ka whaka­manu­hiri­tia, ia e ngā tāngata o Kariri, i kite hoki rātou i ngā mea katoa i meatia e ia ki Hiruhārama i te hākari; i haere hoki rātou ki te hākari. ");
INSERT INTO mri_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ā, ka tae anō a Īhu ki Kana o Kariri, ki te wāhi i meatia ai e ia te wai hei wāina. Nā, ko tētahi tangata a te kīngi, kei Kaperenauma tāna tama e mate ana. ");
INSERT INTO mri_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ā, nō ka rongo ia kua tae mai a Īhu i Hūria ki Kariri, ka haere ki a ia, ka īnoi ki a ia kia haere ia ki te whaka­ora i tāna tama; meāke hoki marere. ");
INSERT INTO mri_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nā, ko te mea­tanga a Īhu ki a ia, “Ki te kāhore koutou e kite i ngā tohu, i ngā mere­kara, e kore rawa koutou e whaka­pono.” ");
INSERT INTO mri_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ka mea te tangata a te kīngi ki a ia, “E te Ariki, haere iho i te mea kāhore anō kia mate noa tāku tama­iti”. ");
INSERT INTO mri_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ka mea a Īhu ki a ia, “Haere; kua ora tāu tama.” Nā, whaka­pono ana te tangata ki te kupu i kōrero­tia e Īhu ki a ia, ā, haere ana. ");
INSERT INTO mri_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ā, i a ia e haere ana, ka tūtaki āna pono­nga ki a ia, ka kōrero, “Kua ora tāu tama­iti.” ");
INSERT INTO mri_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nā, ka ui ia ki a rātou ki te hāora i mātūtū ake ai ia. Ka mea rātou ki a ia, “Nō­nanahi, nō te whitu o ngā hāora, i mutu ai tōna kā.” ");
INSERT INTO mri_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nā, ka mōhio te pāpā, ko te tino hāora ia i mea ai a Īhu ki a ia, “Kua ora tāu tama.” Ā, whaka­pono ana ia, rātou ko tōna whare katoa. ");
INSERT INTO mri_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ko te rua anō tēnei o ngā mere­kara i meatia e Īhu, i muri i tōna haere­nga i Hūria ki Kariri. ");
INSERT INTO mri_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Muri iho i ēnei mea he hākari tā ngā Hūrai, ā, haere ana a Īhu ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nā, kei Hiruhārama tētahi wai kau­kau­ranga kei te tatau hipi, tōna ingoa Hiperu ko Petehera; e rima ōna whaka­mahau. ");
INSERT INTO mri_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nā, kei roto i ēnei e takoto ana tōna tini o ngā tūroro, o ngā matapō, o ngā kopa, o ngā memenge, e tatari ana ki te pō­kare­kare­nga o te wai. ");
INSERT INTO mri_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Heke iho ai hoki tētahi ana­hera i te wā i rite ai ki te kau­kau­ranga, whaka­pō­kare­kare ai i te wai; ā, ko ia kua tae wawe i muri iho o te pō­kare­kare­nga o te wai i ora i tōna mate, ahakoa he aha, he aha. ");
INSERT INTO mri_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nā, kei reira tētahi tangata, e toru tekau mā waru ngā tau e mate ana. ");
INSERT INTO mri_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nō te kite­nga o Īhu i a ia e takoto ana, ka mātau kua roa kē te wā ōna e mate ana, ka mea ki a ia, “E pai ana rānei koe kia whaka­ora­ngia?” ");
INSERT INTO mri_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ka whaka­hokia e taua tūroro ki a ia, “E te Ariki, kāhore āku tāngata hei tuku i ahau ki te kau­kau­ranga, ina whaka­pō­kare­karea te wai; heoi, i ahau e haere ana, ka heke iho tētahi i mua i ahau.” ");
INSERT INTO mri_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ka mea a Īhu ki a ia, “Whaka­tika, tango­hia ake tōu moenga, haere.” ");
INSERT INTO mri_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ā, ora tonu ake taua tangata, ā, tango­hia ake ana e ia tōna moenga, haere ana. Ko te hāpati anō taua rā. ");
INSERT INTO mri_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nā, ka mea ngā Hūrai ki taua tangata i whaka­ora­ngia rā, “Ko te hāpati tēnei; e kore e tika kia mauria e koe tōu moenga.” ");
INSERT INTO mri_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ka whaka­hokia e ia ki a rātou, “Ko te tangata i whaka­ora­ngia ai ahau, nāna i mea ki ahau, ‘Tango­hia ake tōu moenga, haere.’ ” ");
INSERT INTO mri_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nā, ka ui rātou ki a ia, “Ko wai tēnā tangata i mea nā ki a koe, ‘Tango­hia ake tōu moenga, haere’?” ");
INSERT INTO mri_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Otirā, kīhai taua tangata i whaka­ora­ngia rā i mōhio ko wai ia; i paheno atu hoki a Īhu, he toko­maha hoki ngā tāngata i taua wāhi. ");
INSERT INTO mri_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Muri iho i ēnei mea ka kite a Īhu i a ia i roto i te teme­para, ka mea ki a ia, “Nā, ka oti nei koe te whaka­ora. Kāti te hara kei kino rawa iho te mea e pā ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Haere ana taua tangata, kōrero ana ki ngā Hūrai, nā Īhu ia i whaka­ora. ");
INSERT INTO mri_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Koia ngā Hūrai i whai ai ki te tūkino i a Īhu, mōna i mea i ēnei mea i te hāpati. ");
INSERT INTO mri_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nā, ka whaka­hokia e Īhu ki a rātou, “E mahi ana tōku Matua ā taea noatia tēnei rā; e mahi ana anō ahau.” ");
INSERT INTO mri_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Koia ngā Hūrai i tino whai rawa ai kia patua ia, ehara hoki i te mea ko tāna takahi anake i te hāpati, engari, mōna i mea ko te Atua tōna Matua ake, i mea he rite ia ki te Atua te nui. ");
INSERT INTO mri_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “He pono, he pono tāku e mea nei ki a koutou, e kore e taea e te Tama te mea tētahi mea e ia anake, engari ngā mea e kite ai ia e meatia ana e te Matua; ko tāna hoki e mea ai, e meatia ana hoki e te Tama. ");
INSERT INTO mri_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","E aroha ana hoki te Matua ki te Tama, e whaka­kitea ana hoki ki a ia ngā mea katoa e mea ai ia; he nui atu i ēnei ngā mahi e whaka­kitea e ia ki a ia, kia mīharo ai koutou. ");
INSERT INTO mri_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ko tā te Matua hoki, he whaka­ara, he whaka­ora i ngā tū­pā­paku; ka pērā anō te Tama, ka whaka­ora i āna e pai ai. ");
INSERT INTO mri_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","E kore hoki te Matua e whaka­wā i tētahi, engari, kua tukua e ia ngā whaka­wā katoa ki te Tama; ");
INSERT INTO mri_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kia rite ai te whaka­hōnore a ngā tāngata katoa i te Tama ki tā rātou whaka­hōnore i te Matua. Ki te kāhore tētahi e whaka­hōnore i te Tama, e whaka­kāhore ana ia i te hōnore mō te Matua nāna nei ia i tono mai. ");
INSERT INTO mri_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“He pono, he pono tāku e mea atu nei ki a koutou, ko te tangata e rongo ana ki tāku kōrero, e whaka­pono ana hoki ki tōku kai­tono mai, he ora tonu tōna; e kore anō ia e riro ki te whaka­wā, engari, kua whiti i te mate ki te ora. ");
INSERT INTO mri_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","He pono, he pono tāku e mea nei ki a koutou, meāke puta te wā, ā, tēnei anō ināia­nei, e rongo ai ngā tū­pā­paku i te reo o tā te Atua Tama; ā, ko te hunga e rongo ana ka ora. ");
INSERT INTO mri_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tā te mea he ora tō te Matua kei roto i a ia; wai­hoki kua hōmai e ia ki te Tama, kia whai ora i roto i a ia; ");
INSERT INTO mri_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ā, kua hōmai anō ki a ia he tikanga mō te whaka­wā, nō te mea ko ia te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kaua e mīharo ki tēnei; nō te mea meāke puta te wā, e rongo ai i tōna reo ngā tāngata katoa i roto i ngā urupā, ");
INSERT INTO mri_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ā, ka puta; ko ngā kai­mahi i te pai ki te aranga o te ora; ko ngā kai­mahi i te kino ki te aranga o te whaka­wā. ");
INSERT INTO mri_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“E kore e āhei i ahau te mea tētahi mea e ahau anake; rite tonu tāku whaka­wā ki tāku e rongo ai. He tika hoki tāku whaka­wā; kāhore hoki ahau e rapu i tāku i pai ai, engari, i tā tōku kai­tono i pai ai.” ");
INSERT INTO mri_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Me­he­mea ko ahau hei whaka­atu i āku aha, i āku aha, ehara tāku i te whaka­atu pono. ");
INSERT INTO mri_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tērā atu anō tētahi kai­whaka­atu mōku; e mōhio ana anō ahau he whaka­atu pono tāna e whaka­atu nei mōku. ");
INSERT INTO mri_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","I tono tāngata koutou ki a Hoani, ā, i whaka­atu­ria e ia te pono. ");
INSERT INTO mri_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kāhore ahau e manako ki tā te tangata whaka­atu; engari, e kōrero­tia ana e ahau ēnei mea kia ora ai koutou. ");
INSERT INTO mri_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","He rama kā tērā, he rama mārama tonu; he wā anō i pai ai koutou kia hari ki tōna mārama. ");
INSERT INTO mri_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Otiia, he kai­whaka­atu anō tōku, nui atu i a Hoani. Ko ngā mahi hoki i hōmai e te Matua kia whaka­otia e ahau, ko aua mahi e mahia nei e ahau, hei whaka­atu mōku, i tonoa mai ahau e te Matua. ");
INSERT INTO mri_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nā, ko te Matua nāna nei ahau i tono mai, kua oti ahau te whaka­atu e ia. Kāhore anō koutou i rongo noa i tōna reo, kāhore anō i kite i tōna āhua. ");
INSERT INTO mri_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kāhore anō hoki i mau tāna kupu i roto i a koutou; inā kāhore anō koutou i whaka­pono ki tēnei i tonoa mai nei e ia. ");
INSERT INTO mri_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Whaka­takina ai e koutou ngā tikanga o ngā karaipi­ture; e mea ana hoki koutou kei reira te ora tonu mō koutou; ko ēnei hei kai­whaka­atu mōku. ");
INSERT INTO mri_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Heoi, kāhore koutou e pai kia haere mai ki ahau, kia whi­whi ai ki te ora. ");
INSERT INTO mri_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“He korōria tāngata, kāhore ahau e manako atu. ");
INSERT INTO mri_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nā, kua mātau ahau ki a koutou, kāhore te aroha o te Atua i roto i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kua tae mai nei ahau i runga i te ingoa o tōku Matua, ā, kāhore koutou e manako mai ki ahau; ki te haere mai tētahi i runga i tōna ake ingoa, ka manako koutou ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Me pēhea koutou ka whaka­pono ai, ka riro nei i a koutou te korōria e puta ana i a koutou anō, ā, kāhore e rapu i te korōria e puta ana i te Atua kotahi? ");
INSERT INTO mri_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kei mea koutou e kōrero­tia tō koutou hē e ahau ki te Matua; tērā te kai­kōrero mō tō koutou hē, ko Mohi, ko tā koutou e tū­mana­ko nei. ");
INSERT INTO mri_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Me i whaka­pono hoki koutou ki a Mohi, kua whaka­pono anō ki ahau; ko tāna hoki i tuhi­tuhi ai he mea mōku. ");
INSERT INTO mri_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Otirā, ki te kāhore koutou e whaka­pono ki āna i tuhi­tuhi ai, me pēhea ka whaka­pono ai ki āku kōrero?” ");
INSERT INTO mri_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Muri iho i ēnei mea ka whiti atu a Īhu i te moana o Kariri, (arā, i te moana o Tai­piria.) ");
INSERT INTO mri_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ā, he rahi te hui i aru i a ia, i kite hoki rātou i āna mere­kara i mea ai ia ki ngā tūroro. ");
INSERT INTO mri_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nā, ka haere a Īhu ki runga i te maunga, ā, noho ana i reira rātou ko āna ākonga. ");
INSERT INTO mri_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kua tata hoki te Kape­nga, te hākari a ngā Hūrai. ");
INSERT INTO mri_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ā, nō te maranga­tanga ake o ngā kanohi o Īhu, ka kite i te rahi o te hui e haere mai ana ki a ia; ka mea ia ki a Piripi, “Ko hea tātou hoko ai i ētahi taro, kia kai ai ēnei?” ");
INSERT INTO mri_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","I pēnei ai tāna kī hei whaka­mātau mōna; i mōhio hoki ia ki tāna e mea ai. ");
INSERT INTO mri_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ka mea a Piripi ki a ia, “E kore e ranea mā rātou ngā taro o ngā pene e rua rau, kia whi­whi ai tēnei, tēnei o rātou i tētahi wāhi iti.” ");
INSERT INTO mri_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ka mea tētahi o āna ākonga ki a ia, a Anaru, teina o Haimona Pita, ");
INSERT INTO mri_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“He tama­iti tēnei, e rima āna taro pāre, e rua ika no­nohi. Heoi, hei aha ēnei mā tēnei ope nui?” ");
INSERT INTO mri_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nā, ka mea a Īhu, “Meinga ngā tāngata kia noho.” (He nui hoki te taru­taru i taua wāhi.) Nā, noho ana ngā tāne ki raro, te toko­maha me te mea e rima mano. ");
INSERT INTO mri_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nā, ka mau a Īhu ki ngā taro; ā, ka mutu te whaka­whetai, ka tuwha atu ki te hunga e noho rā; me ngā ika anō, tā rātou i pai ai. ");
INSERT INTO mri_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ā, nō ka mākona rātou, ka mea ia ki āna ākonga, “Kohiko­hia ngā toenga o ngā whati­whatinga, kei mau­mau­ria tētahi wāhi.” ");
INSERT INTO mri_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nā, kohiko­hia ana e rātou, ā, whaka­kīa ana ngā kete tekau mā rua ki ngā whati­whatinga o ngā taro pāre e rima, ki ngā toenga a ngā tāngata i kai rā. ");
INSERT INTO mri_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ā, i te kite­nga o aua tāngata i te mere­kara i meatia e Īhu, ka kī rātou, “Ko ia anō tēnei, ko te poro­piti e haere mai ana ki te ao.” ");
INSERT INTO mri_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nā, ka mahara a Īhu, meāke rātou haere mai ki te tango i a ia, ki te whaka­kīngi i a ia, nā, maunu ana anō ia ki te maunga, ko ia anake. ");
INSERT INTO mri_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ā, nō ka ahi­ahi, ka haere āna ākonga ki te moana. ");
INSERT INTO mri_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nā, ka eke rātou ki te kai­puke, ka whaka­whiti ki tāwāhi o te moana, ki Kaperenauma. Ā, kua pōuri noa ake, kāhore anō a Īhu kia tae noa mai ki a rātou. ");
INSERT INTO mri_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nā, ko te tū­ranga o te moana, he nui hoki nō te pū­hanga o te hau. ");
INSERT INTO mri_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nā, i tō rātou hoenga atu, e rua tekau mā rima, e toru tekau rānei pā­ronga, ka kite i a Īhu e haere māori ana i runga i te moana, e whaka­tata ana ki te kai­puke; nā ka mataku rātou. ");
INSERT INTO mri_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nā, ka mea ia ki a rātou, “Ko ahau tēnei, aua e wehi.” ");
INSERT INTO mri_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nā, ka mea rātou kia eke ia ki te kai­puke; ā, kīhai i aha kua ū te kai­puke ki te wāhi i hoe ai rātou. ");
INSERT INTO mri_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","I te aonga ake, ka mahara te mano e tū ana ki tērā taha o te moana, kāhore he poti kē atu o reira, ko tērā anake i eke ai āna ākonga, kīhai hoki a Īhu i eke tahi rātou ko āna ākonga ki te poti, engari, ko āna ākonga anake i haere. ");
INSERT INTO mri_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","He poti kē rā ia i ū mai i Tai­piria ki pahaki atu o te wāhi i kai ai rātou i te taro i tā te Ariki whaka­whetai­nga. ");
INSERT INTO mri_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ā, i te kite­nga o te mano kāhore a Īhu i reira, kāhore anō hoki āna ākonga, ka eke hoki rātou ki ngā kai­puke, ka rere ki Kaperenauma ki te rapu i a Īhu. ");
INSERT INTO mri_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ā, nō tō rātou kite­nga i a ia i tāwāhi o te moana, ka mea ki a ia, “E Rapi, nōna­hea koe i tae mai ai ki konei?” ");
INSERT INTO mri_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ka whaka­hoki a Īhu ki a rātou, ka mea, “He pono, he pono tāku e mea nei ki a koutou, ehara i te mea he kite­nga nō koutou i ngā mere­kara i rapu ai koutou i ahau, engari, nō te mea i kai koutou i ngā taro, ā, ka mākona. ");
INSERT INTO mri_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aua e mahia te kai memeha, engari, te kai e mau tonu ana ā te ora tonu rā anō, ko tā te Tama hoki a te tangata e hoatu ai ki a koutou. Kua oti hoki ia te whai tohu e te Atua, e te Matua.” ");
INSERT INTO mri_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nā, ka mea rātou ki a ia, “Me aha mātou e mahi ai i ngā mahi a te Atua?” ");
INSERT INTO mri_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ka whaka­hoki a Īhu, ka mea ki a rātou, “Ko tā te Atua mahi tēnei, kia whaka­pono koutou ki tāna i tono mai ai.” ");
INSERT INTO mri_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nā, ka mea rātou ki a ia, “Ko tēhea tohu te meatia ana e koe kia kite ai mātou, kia whaka­pono ai ki a koe? Tēnā koa tāu mahi? ");
INSERT INTO mri_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","I kai ō tātou mātua i te mana i te koraha; ko te mea hoki tēnā i tuhi­tuhia, ‘I hōmai e ia he taro i te rangi hei kai mā rātou.’ ” ");
INSERT INTO mri_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nā, ko te mea­tanga a Īhu ki a rātou, “He pono, he pono tāku e mea nei ki a koutou, ehara i a Mohi nāna i hoatu tēnā taro ki a koutou i te rangi. Engari, tēnei te hoatu nei e tōku Matua ki a koutou te taro pono o te rangi. ");
INSERT INTO mri_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ko te taro hoki a te Atua ko ia e heke iho ana i te rangi, e hōmai ana i te ora ki te ao.” ");
INSERT INTO mri_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nā, ka mea rātou ki a ia, “E te Ariki, hōmai tēnei taro ki a mātou i ngā wā katoa.” ");
INSERT INTO mri_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ka mea a Īhu ki a rātou, “Ko ahau te taro o te ora. Ki te haere mai tētahi ki ahau, e kore rawa ia e hia­kai; ki te whaka­pono hoki tētahi ki ahau, e kore rawa ia e mate­wai. ");
INSERT INTO mri_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Otirā, i mea anō ahau ki a koutou, kua kite koutou i ahau, ā, kāhore i whaka­pono. ");
INSERT INTO mri_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ko ā te Matua e hōmai ai ki ahau ka haere katoa mai ki ahau; ā, ki te haere mai tētahi ki ahau, e kore rawa e pangā e ahau ki waho, ");
INSERT INTO mri_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","i heke iho hoki ahau i te rangi, ehara i te mea hei mahi i tāku i pai ai, engari, i tā tōku kai­tono mai i pai ai. ");
INSERT INTO mri_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ko tā te Matua i pai ai, nāna nei ahau i tono mai, koia tēnei, kia kaua e ngaro i ahau tētahi wāhi o ngā mea katoa i hōmai e ia ki ahau; engari, kia whaka­ara­hia ake e ahau ā te rā whaka­mutu­nga. ");
INSERT INTO mri_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ko tā tōku Matua hoki tēnei i pai ai, ko te tangata e kite ana i te Tama, e whaka­pono ana anō ki a ia, kia whi­whi ia ki te ora tonu; māku anō ia e whaka­ara ake ā te rā whaka­mutu­nga.” ");
INSERT INTO mri_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nā, ka kōrero kō­muhu­muhu ngā Hūrai ki a ia, mōna i mea, “Ko ahau te taro i heke iho i te rangi.” ");
INSERT INTO mri_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ka mea rātou, “Ehara oti tēnei i a Īhu, tama a Hōhepa, e mōhio nei tātou ki tōna pāpā rāua ko tōna whaea? Ha! He pēhea tāna e kī nei, ‘I heke iho ahau i te rangi?’ ” ");
INSERT INTO mri_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nā, ka whaka­hoki a Īhu, ka mea ki a rātou, “Kāti te kō­muhu­muhu i roto i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kāhore he tangata e āhei te haere mai ki ahau, ki te kāhore ia e kūmea mai e te Matua, nāna nei ahau i tono mai. Ā, māku anō ia e whaka­ara ake ā te rā whaka­mutu­nga. ");
INSERT INTO mri_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kua oti te tuhi­tuhi i roto i ngā poro­piti, ‘Ā, ka whaka­akona rātou katoa e te Atua.’ Nā, ko te tangata kua rongo ki te Matua, kua ākona hoki, ka haere mai ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ehara i te mea kua kite tētahi i te Matua; ko ia anake i puta mai i te Atua, ko ia kua kite i te Matua. ");
INSERT INTO mri_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","He pono, he pono tāku, e mea nei ki a koutou, Ki te whaka­pono tētahi, he ora tonu tōna. ");
INSERT INTO mri_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ko ahau te taro o te ora. ");
INSERT INTO mri_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","I kai rā ō koutou mātua i te mana i te koraha, ā, i mate rātou. ");
INSERT INTO mri_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ko te taro tēnei e heke iho ana i te rangi, kia kai ai te tangata i a ia, ā, kia kaua e mate. ");
INSERT INTO mri_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ko ahau te taro ora i heke iho i te rangi; ki te kai tētahi i tēnei taro, e ora tonu ia. Āe rā, ko te taro e hoatu e ahau ko ōku kiko­kiko, e hoatu e ahau hei oranga mō te ao.” ");
INSERT INTO mri_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nā, ka totohe ngā Hūrai tētahi ki tētahi, ka mea, “Me pēhea e hōmai ai e tēnei tangata ōna kiko­kiko kia kainga e tātou?” ");
INSERT INTO mri_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nā, ko te mea­tanga a Īhu ki a rātou, “He pono, he pono tāku e mea nei ki a koutou, ki te kāhore koutou e kai i ngā kiko­kiko o te Tama a te tangata, e inu i ōna toto, kāhore he ora i roto i a koutou ake. ");
INSERT INTO mri_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko ia e kai ana i ōku kiko­kiko, e inu ana i ōku toto, he ora tonu tōna; ā, māku ia e whaka­ara ake ā te rā whaka­mutu­nga. ");
INSERT INTO mri_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","He kai pono hoki ōku kiko­kiko, he mea pono ōku toto hei inu­manga. ");
INSERT INTO mri_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ko ia e kai ana i ōku kiko­kiko, e inu ana i ōku toto, e noho ana i roto i ahau, me ahau hoki i roto i a ia. ");
INSERT INTO mri_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nā, te Matua ora hoki ahau i tono mai, nō te Matua anō tōku ora; wai­hoki ki te kai tētahi i ahau, kei ahau he ora mōna. ");
INSERT INTO mri_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ko te taro tēnei i heke iho i te rangi. E kore e pērā i tā ō koutou mātua i kai rā, ā, mate ana. Ki te kai tētahi i tēnei taro, e ora tonu ia.” ");
INSERT INTO mri_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","I kōrero­tia ēnei mea e ia i roto i te whare kara­kia, i a ia e whaka­ako ana i Kaperenauma. ");
INSERT INTO mri_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nā, he toko­maha āna ākonga i te rongo­nga, i mea, “He kupu pakeke tēnei; ko wai e āhei te whaka­rongo atu?” ");
INSERT INTO mri_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ka mōhio ia a Īhu i roto i a ia, e kō­muhu­muhu ana āna ākonga ki tēnei, ka mea ia ki a rātou, “E hē ana koutou ki tēnei? ");
INSERT INTO mri_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ka pēhea rā ki te kite koutou i te Tama a te tangata e kake atu ana ki te wāhi i noho ai ia i mua? ");
INSERT INTO mri_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ko te wairua te whaka­ora ana; kāhore a te kiko­kiko wāhi. Ko ngā kupu e kōrero nei ahau ki a koutou he wairua, he ora. ");
INSERT INTO mri_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tēnei anō ia ētahi o koutou kāhore ō rātou whaka­pono.” (I mātau hoki a Īhu nō te tīma­tanga ki ngā mea kāhore ō rātou whaka­pono, ki te tangata anō e tukua ai ia.) ");
INSERT INTO mri_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ā, ka mea ia, “Nā, konei ahau i mea ai ki a koutou, kāhore he tangata e āhei te haere mai ki ahau, ki te kāhore e hoatu ki a ia e tōku Matua.” ");
INSERT INTO mri_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","I taua wā, he toko­maha āna ākonga i hoki ki muri, ā, mutu ake tā rātou haere tahi me ia. ");
INSERT INTO mri_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nā, ka mea a Īhu ki te tekau mā rua, “E mea ana anō rānei koutou kia haere?” ");
INSERT INTO mri_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nā, ka whaka­hokia e Haimona Pita ki a ia, “E te Ariki, me haere mātou ki a wai? Kei a koe ngā kupu o te ora tonu. ");
INSERT INTO mri_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kua whaka­pono mātou, kua mātau, ko te Karaiti koe, ko te Tama a te Atua ora.” ");
INSERT INTO mri_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ka whaka­hokia e Īhu ki a rātou, “He teka ianei kotahi tekau mā rua koutou i whiri­whiria e ahau, he rēwera anō tētahi o koutou?” ");
INSERT INTO mri_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ko Hūrā Ikariote tama a Haimona tāna i kōrero ai; ko te tangata hoki ia meāke nei tuku i a ia; ko tētahi hoki ia o te tekau mā rua. ");
INSERT INTO mri_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","I muri i ēnei mea ka hāere­ere a Īhu i Kariri; kāhore hoki ia i pai ki te hāere­ere i Hūria, e rapu ana hoki ngā Hūrai kia whaka­matea ia. ");
INSERT INTO mri_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nā, kua tata te hākari a ngā Hūrai, te Hākari Whare Wharau. ");
INSERT INTO mri_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nā, ka mea ōna tēina ki a ia, “Haere atu i konei, anga atu ki Hūria, kia kite ai hoki āu ākonga i āu mahi e mahi nei koe. ");
INSERT INTO mri_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","E kore hoki tētahi tangata e mea huna i tētahi mea, ki te whai ia kia ara tōna ingoa. Ki te mea koe i ēnei mea, kia kite te ao i a koe.” ");
INSERT INTO mri_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Ko ōna tēina tonu hoki kīhai i whaka­pono ki a ia.) ");
INSERT INTO mri_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nā, ka mea a Īhu ki a rātou, “Kāhore anō kia taea noatia tōku tāima; ko tō koutou tāima ia kei ngā wā katoa. ");
INSERT INTO mri_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","E kore e āhei kia kino te ao ki a koutou; engari ka kino ki ahau, nō te mea e whaka­atu­ria ana e ahau te kino o āna mahi. ");
INSERT INTO mri_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Haere koutou ki tēnei hākari; e kore ahau e haere wawe ki tēnei hākari; kāhore hoki tōku tāima kia āta rite noa.” ");
INSERT INTO mri_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ā, ka mutu tēnei kōrero āna ki a rātou, ka noho tonu ia ki Kariri. ");
INSERT INTO mri_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ā, nō ka riro ōna tēina ki te hākari, ka haere anō hoki ia, ehara i te mea whaka­kite nui, engari i tū-ā-huna. ");
INSERT INTO mri_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Heoi, i rapu ngā Hūrai i a ia i te hākari, i mea, “Kei hea ia?” ");
INSERT INTO mri_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","He nui hoki te kōrero kō­muhu­muhu mōna i roto i te mano. Ko ētahi i mea, “He tangata pai ia,” ko ētahi i mea, “Kāhore, engari e whaka­pōhēhē ana ia i te iwi.” ");
INSERT INTO mri_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Heoi, kīhai i rahi te kōrero a tētahi tangata mōna, he wehi ki ngā Hūrai. ");
INSERT INTO mri_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nā, i waenga­nui o te hākari, ka haere a Īhu ki roto ki te teme­para whaka­ako ai. ");
INSERT INTO mri_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ā, ka mīharo ngā Hūrai, ka mea, “Nā te aha i hua ai te mōhio o tēnei tangata, ehara nei hoki ia i te mea whaka­ako?” ");
INSERT INTO mri_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ka whaka­hoki a Īhu ki a rātou, ka mea, “Ehara i te mea nāku ake tāku e whaka­ako nei, engari, nā tōku kai­tono mai. ");
INSERT INTO mri_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ki te pai tētahi tangata ki te mea i tāna e pai ai, e mātau ia ki te whaka­ako­ranga, nā te Atua rānei, he kōrero nāku ake rānei. ");
INSERT INTO mri_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ko te tangata nāna ake tāna kōrero, e whai ana ia i tōna ake korōria; tēnā ki te whai tētahi i te korōria o tōna kai­tono, e pono ana ia, ā, kāhore ōna hē. ");
INSERT INTO mri_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","He teka ianei nā Mohi te ture i hoatu ki a koutou, ā, kāhore e whaka­ritea te ture e tētahi o koutou? He aha koutou ka whai nei kia whaka­matea ahau?” ");
INSERT INTO mri_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nā, ka whaka­hoki te mano ka mea, “He rēwera tōu! Ko wai te whai ana kia whaka­matea koe?” ");
INSERT INTO mri_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ka whaka­hoki a Īhu, ka mea ki a rātou, “Kotahi āku mahi i mahi ai, ā, e mīharo­tia ana e koutou katoa. ");
INSERT INTO mri_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","I hōmai e Mohi te kotinga ki a koutou (ehara anō ia i te mea nā Mohi ake, engari nā ngā tūpuna), e kokoti ana hoki koutou i te tangata i te hāpati. ");
INSERT INTO mri_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ki te kotia te tangata i te hāpati, kei taka­hia te ture a Mohi; e riri ana oti koutou ki ahau, mōku i whaka­ora rawa i te tangata i te hāpati? ");
INSERT INTO mri_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kaua e waiho te whaka­wā i runga i tā te kanohi, engari kia tika tā koutou whaka­wā.” ");
INSERT INTO mri_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Me i reira ka mea ētahi o ngā tāngata o Hiruhārama, “Ehara oti tēnei i a ia e whāia nei e rātou kia whaka­matea? ");
INSERT INTO mri_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nā, māia tonu tāna kōrero, ā, kāhore ā rātou kupu ki a ia. E tino mātau ana rānei ngā ranga­tira, ko te Karaiti pū tēnei? ");
INSERT INTO mri_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Otiia, e mātau ana tātou ki te wāhi i puta mai ai tēnei; tēnā ka tae mai a te Karaiti, kāhore he tangata e mātau ki te wāhi e puta mai ai ia.” ");
INSERT INTO mri_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nā, ka karanga a Īhu i te teme­para i a ia e whaka­ako ana, ka mea, “E mātau ana koutou ki ahau, e mātau ana anō ki te wāhi i haere mai ai ahau. Ehara i ahau ake tāku haere mai, engari, e pono ana te kai­tono mai i ahau; kāhore nei koutou i mātau ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","E mātau ana ahau ki a ia; i puta mai hoki ahau i a ia, nāna anō ahau i tono mai.” ");
INSERT INTO mri_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ā, i whai rātou kia hopu­kia ia; otiia, kīhai i pā te ringa o tētahi ki a ia, kāhore hoki tōna hāora i taka noa. ");
INSERT INTO mri_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ā, he toko­maha o te mano whaka­pono ki a ia, i mea, “Ka tae mai a te Karaiti, tērā rānei e maha atu āna mere­kara e mea ai i a tēnei e mea nei?” ");
INSERT INTO mri_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","I rongo ngā Parihi i te mano e kōrero­rero ana i ēnei mea mōna; nā, ka tonoa mai e ngā Parihi rātou ko ngā tohu­nga nui he kātipa ki te hopu i a ia. ");
INSERT INTO mri_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nā, ka mea a Īhu ki a rātou, “He iti noa ake te wāhi e noho ai ahau ki a koutou, kātahi ahau ka haere ki tōku kai­tono mai. ");
INSERT INTO mri_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tērā koutou e rapu i ahau, heoi, e kore koutou e kite; e kore hoki koutou e āhei te haere ake ki te wāhi e noho ai ahau.” ");
INSERT INTO mri_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nā, ka mea ngā Hūrai ki a rātou anō, “E haere oti te tangata nei ki hea, e kore ai e kitea e tātou? E haere oti ia ki ngā manene i roto i ngā Kariki, ako ai i ngā Kariki? ");
INSERT INTO mri_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","He kī aha tēnei e kī nei ia, ‘Tērā koutou e rapu i ahau, ā, e kore e kite. E kore hoki koutou e āhei te haere ake ki te wāhi e noho ai ahau’?” ");
INSERT INTO mri_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","I te rā whaka­mutu­nga, i te rā nui o te hākari, ka tū a Īhu, ka karanga, ka mea, “Ki te mate­wai tētahi, haere mai ia ki ahau, kia inu. ");
INSERT INTO mri_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ki te whaka­pono tētahi ki ahau, ka rite ki tā te karaipi­ture, ‘Ka rere mai ngā wai ora i roto i tōna kōpū.’ ” ");
INSERT INTO mri_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I kōrero­tia tēnei e ia mō te Wairua, meāke nei riro i te hunga e whaka­pono ana ki a ia; kāhore anō hoki te Wairua Tapu kia hōmai noa; nō te mea kīanō a Īhu i whaka­korōria­tia noatia. ");
INSERT INTO mri_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ko ētahi o te mano i tō rātou rongo­nga i tēnei kupu, i mea, “He pono ko te Poro­piti tēnei.” ");
INSERT INTO mri_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ka mea ētahi, “Ko te Karaiti tēnei.” Ko ētahi i mea, “E puta mai rānei a te Karaiti i Kariri? ");
INSERT INTO mri_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kāhore koia te karaipi­ture i mea, e puta mai a te Karaiti i te uri o Rāwiri, i Pēterehema, i te kāinga i noho ai a Rāwiri?” ");
INSERT INTO mri_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nā, ka waiho ia hei take wehe­wehe­nga mā te mano. ");
INSERT INTO mri_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ko ētahi o rātou i mea kia hopu­kia ia; otirā, kīhai i pā ngā ringa o tētahi ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nā, ko te taenga atu o ngā kātipa ki ngā tohu­nga nui rātou ko ngā Parihi; ka mea atu ēnei ki a rātou, “He aha ia tē kawea mai ai e koutou?” ");
INSERT INTO mri_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ka whaka­hokia e ngā kātipa, “Kāhore rawa he tangata i rite āna kōrero ki a tēnei.” ");
INSERT INTO mri_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nā, ka whaka­hokia tā rātou e ngā Parihi, “Kua tini­hanga­tia anō hoki koutou? ");
INSERT INTO mri_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kua whaka­pono koia tētahi o ngā ranga­tira, o ngā Parihi rānei ki a ia? ");
INSERT INTO mri_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ko tēnei hunga ia e kore nei e mātau ki te ture, ka oti rātou te kanga.” ");
INSERT INTO mri_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ka mea a Nikorima ki a rātou, tērā i haere mai rā ki a ia i mua, ko ia hoki tētahi o rātou, ");
INSERT INTO mri_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ka whaka­hē­ngia rānei te tangata e tō tātou ture, i te mea kāhore anō i whaka­rongo noa ki a ia, i mātau hoki ki tāna mahi?” ");
INSERT INTO mri_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nā, ka whaka­hoki rātou, ka mea ki a ia, “Ko koe hoki tētahi nō Kariri? Tēnā rapua, ka kite koe, kāhore kia ara noa tētahi poro­piti i Kariri.” ");
INSERT INTO mri_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nā, hoki ana rātou ki tōna whare, ki tōna whare. ");
INSERT INTO mri_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ko Īhu ia i haere ki Maunga Ōriwa. ");
INSERT INTO mri_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ā, i te atatū ka hoki anō ia ki te teme­para, ā, tae katoa ana te iwi ki a ia. Nā, ka noho ia, ka whaka­ako i a rātou. ");
INSERT INTO mri_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kātahi, ka āra­hina mai ki a ia e ngā kara­ipi rātou ko ngā Parihi tētahi wahine i hopu­kia e pūremu ana; ā, whaka­tū­ria ana ki waenga­nui. ");
INSERT INTO mri_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ka mea rātou ki a ia, “E te Kai­whaka­ako, i hopu­kia pūtia te wahine nei e pūremu ana. ");
INSERT INTO mri_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","I whaka­hau a Mohi ki a mātou i roto i te ture, kia ākina ngā pēnei ki te kōhatu. Tēnā koa tāu kī?” ");
INSERT INTO mri_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","I pēnei ai rātou he whaka­mā­tau­tau mōna, kia whai take ai rātou e whaka­pā­ngia ai he hē ki a ia. Ka piko a Īhu, ā, tuhi­tuhi ana tōna ringa ki te whenua. ");
INSERT INTO mri_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ā, ka tohe tonu rātou ki te ui ki a ia ka whaka­tika ake ia, ka mea ki a rātou, “Ko te tangata o koutou kāhore ōna hara, māna te kōhatu mātā­mua e āki ki a ia.” ");
INSERT INTO mri_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nā, ka piko anō ia, ka tuhi­tuhi ki te whenua. ");
INSERT INTO mri_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ā, i tō rātou rongo­nga, ka haere taki­tahi atu ki waho, nā, ngā kaumātua i tīmata, ā, poto noa ō muri rawa. Ā, ko Īhu anake i mahue, me te wahine e tū ana i waenga­nui. ");
INSERT INTO mri_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ā, ko te maranga­tanga ake o Īhu, ka mea ki a ia, “E tai, kei hea rātou? Kāhore he tangata i whaka­tau hē ki a koe?” ");
INSERT INTO mri_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Anō rā ko tērā, “Kāhore, e te Ariki.” Ka mea a Īhu ki a ia, “Kāhore anō hoki ahau e whaka­tau i te hē ki a koe; haere, kāti te hara.” ");
INSERT INTO mri_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","I kī atu anō a Īhu ki a rātou, i mea, “Ko ahau te whaka­mārama o te ao; ki te aru tētahi i ahau, e kore ia e haere i te pōuri, engari, ka whi­whi ki te mārama o te ora.” ");
INSERT INTO mri_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nā, ka mea ngā Parihi ki a ia, “Ko koe anō tōu kai­whaka­atu; ehara tāu i te whaka­atu pono.” ");
INSERT INTO mri_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ka whaka­hoki a Īhu, ka mea ki a rātou, “Ahakoa ko ahau anō tōku kai­whaka­atu, he pono tāku whaka­atu; nō te mea e mātau ana ahau ki te wāhi i haere mai ai ahau, ki te wāhi hoki e haere atu nei ahau; ko koutou ia kāhore e mātau ki te wāhi i haere mai ai ahau, ki te wāhi anō e haere atu nei ahau. ");
INSERT INTO mri_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nā, te kiko­kiko tā koutou tikanga whaka­wā; e kore ahau e whaka­wā i tētahi. ");
INSERT INTO mri_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ā, ki te whaka­wā ahau, he tika tāku whaka­wā; ehara hoki i te mea ko ahau anake, engari, ko māua ko te Matua nāna nei ahau i tono mai. ");
INSERT INTO mri_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Āe, kua oti anō te tuhi­tuhi i roto i tō koutou ture, He pono te whaka­atu a ngā tāngata toko­rua. ");
INSERT INTO mri_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ko ahau tēnei hei kai­whaka­atu mōku anō, hei kai­whaka­atu anō mōku te Matua, nāna nei ahau i tono mai.” ");
INSERT INTO mri_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nā, ka mea rātou ki a ia, “Kei hea tōu Matua?” Ka whaka­hokia e Īhu, “Kāhore koutou e mātau ki ahau, kāhore anō ki tōku Matua; me i mātau koutou ki ahau, kua mātau anō ki tōku Matua.” ");
INSERT INTO mri_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","I kōrero­tia ēnei kupu e Īhu i te whare takoto­ranga taonga, i a ia e whaka­ako ana i roto i te teme­para; ā, kāhore tētahi i hopu i a ia; kīanō hoki tōna hāora i taka noa. ");
INSERT INTO mri_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Me i reira ka kī atu anō a Īhu ki a rātou, “E haere atu ana ahau, ā, tērā koutou e rapu i ahau, e mate anō hoki i roto i tō koutou hara. E kore koutou e āhei te haere ake ki te wāhi e haere ai ahau.” ");
INSERT INTO mri_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nā, ka mea ngā Hūrai, “E whaka­mate oti ia i a ia anō? Inā ia ka mea, ‘E kore koutou e āhei te haere ake ki te wāhi e haere ai ahau.’ ” ");
INSERT INTO mri_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Anō rā ko ia ki a rātou, “Nō raro nei koutou; nō runga ahau; nō tēnei ao koutou; ehara ahau i tēnei ao. ");
INSERT INTO mri_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Koia ahau i mea ai ki a koutou, e mate koutou i roto i ō koutou hara; ki te kore hoki koutou e whaka­pono ko ahau ia, e mate koutou i roto i ō koutou hara.” ");
INSERT INTO mri_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kātahi rātou ka mea ki a ia, “Ko wai koe?” Nā, ka mea a Īhu ki a rātou, “Ko tāku anō kōrero ai ki a koutou i te tīma­tanga. ");
INSERT INTO mri_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","He maha āku mea e kōrero ai, e whaka­wā ai mō koutou; otirā, e pono ana tōku kai­tono mai; e kōrero­tia ana hoki e ahau ki te ao ngā mea i rongo ai ahau ki a ia.” ");
INSERT INTO mri_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kīhai rātou i mātau ko te Matua tāna i kōrero ai ki a rātou. ");
INSERT INTO mri_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kātahi a Īhu ka mea ki a rātou, “Kia oti te Tama a te tangata te whaka­iri e koutou, ko reira koutou mātau ai ko ahau ia, ā, e kore e meatia tētahi mea e ahau ake; engari, ko ā tōku Matua i whaka­ako mai ai ki ahau, ko ēnei āku e kōrero nei. ");
INSERT INTO mri_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kei ahau nei anō tōku kai­tono mai; kīhai ahau i waiho e te Matua ko ahau anake, nō te mea e mahi tonu ana ahau i ngā mea e pai­ngia ana e ia.” ");
INSERT INTO mri_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nā, i a ia e kōrero ana i ēnei mea, he toko­maha i whaka­pono ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Me i reira ka mea a Īhu ki ngā Hūrai i whaka­pono ki a ia, “Ki te mau tonu koutou ki tāku kupu, he tino ākonga koutou nāku; ");
INSERT INTO mri_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ā, e mātau koutou ki te pono, mā te pono anō koutou ka ranga­tira ai.” ");
INSERT INTO mri_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ka whaka­hokia e rātou ki a ia, “He whānau mātou nā Āperahama, kāhore mātou i waiho noa hei pono­nga mā tētahi tangata. He aha tāu e mea, Ka ranga­tira koutou?” ");
INSERT INTO mri_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ka whaka­hokia e Īhu ki a rātou, “He pono, he pono tāku e mea nei ki a koutou, he pono­nga nā te hara ngā kai­mahi katoa i te hara. ");
INSERT INTO mri_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","E kore te pono­nga e noho tonu i te whare; ko te Tama ia e noho tonu ana. ");
INSERT INTO mri_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nā, i te mea ka whaka­rangatira­tia koutou e te Tama, he tino ranga­tira koutou. ");
INSERT INTO mri_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","E mātau ana anō ahau, he whānau koutou nā Āperahama; heoi, e whai ana koutou kia whaka­matea ahau, he kore hoki nō tāku kupu e mau i roto i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","E kōrero­tia ana e ahau tāku i kite ai ki tōku Matua; e mahia ana e koutou tā koutou i kite ai ki tō koutou matua.” ");
INSERT INTO mri_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ka whaka­hoki rātou, ka mea ki a ia, “Ko Āperahama tō mātou matua.” Ka mea a Īhu ki a rātou, “Me he tama­riki koutou nā Āperahama, kua mahia e koutou ngā mahi a Āperahama. ");
INSERT INTO mri_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tēnā ko tēnei e whai ana koutou kia whaka­matea ahau, te tangata nāna i kōrero te pono ki a koutou, tāku hoki i rongo ai ki te Atua. Kīhai a Āperahama i pēnā. ");
INSERT INTO mri_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","E mahi ana koutou i ngā mahi a tō koutou matua.” Kātahi rātou ka mea ki a ia, “Kīhai mātou i whānau pōriro; kotahi tō mātou Matua, ko te Atua.” ");
INSERT INTO mri_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ka mea anō a Īhu ki a rātou, “Me­he­mea ko te Atua tō koutou Matua, kua aroha koutou ki ahau; i haere mai hoki ahau i te Atua, ā, kua tae mai nei. Kīhai hoki ahau i haere noa mai, engari, nāna ahau i tono mai. ");
INSERT INTO mri_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","He aha rā koutou tē mātau ai ki tāku kōrero? Nō te mea e kore koutou e āhei te whaka­rongo ki tāku kupu. ");
INSERT INTO mri_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nā tō koutou matua koutou, nā te rēwera, e pai ana hoki kia mea i tā tō koutou matua i hia­hia ai. He kai­kōhuru ia nō te tīma­tanga, kīhai hoki i tū i roto i te pono, nō te mea kāhore he pono i roto i a ia. Ki te kōrero teka ia, e kōrero ana i āna; he kōrero teka hoki ia, ko te matua o te teka. ");
INSERT INTO mri_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","I tāku kōrero­tanga i te pono, kāhore koutou e whaka­pono ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ko wai o koutou hei whaka­atu he hara tōku? Ki te pono tāku kōrero, he aha koutou tē whaka­pono ai ki ahau? ");
INSERT INTO mri_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","E whaka­rongo ana te tangata a te Atua ki ngā kōrero a te Atua; koia koutou tē whaka­rongo ai, nō te mea ehara koutou i te Atua.” ");
INSERT INTO mri_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nā, ka whaka­hoki ngā Hūrai, ka mea ki a ia, “Kāhore koia i tika tā mātou i mea rā, nō Hamaria koe, ā, he rēwera tōu?” ");
INSERT INTO mri_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ka whaka­hokia e Īhu, “Kāhore ōku rēwera; engari e whaka­hōnore ana ahau i tōku Matua, ko koutou ia te whaka­kāhore ana i te hōnore mōku. ");
INSERT INTO mri_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kāhore āku whai i te korōria mōku; tērā anō te kai­whai, te kai­whaka­tika­tika. ");
INSERT INTO mri_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","He pono, he pono tāku e mea nei ki a koutou, ki te pupuri tētahi i tāku kupu, e kore rawa ia e kite i te mate.” ");
INSERT INTO mri_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ka mea ngā Hūrai ki a ia, “Kātahi mātou ka mōhio he rēwera tōu. Kua mate a Āperahama rātou ko ngā poro­piti, ā, e mea ana koe, ‘Ki te pupuri tētahi i tāku kupu, e kore rawa ia e pāngia e te mate.’ ");
INSERT INTO mri_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","He nui oti koe i tō mātou matua, i a Āperahama kua mate nei? Kua mate anō ngā poro­piti. Ki tāu ko wai koe?” ");
INSERT INTO mri_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ka whaka­hokia e Īhu, “Ki te whaka­hōnore ahau i ahau anō, he hōnore noa tōku. Ko tōku Matua hei whaka­hōnore i ahau; ko tā koutou e mea nei ko ia tō koutou Atua. ");
INSERT INTO mri_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Heoi, kāhore koutou i mātau ki a ia, ko ahau ia e mātau ana ki a ia, ā, ki te mea ahau, ‘Kāhore ahau e mātau ki a ia,’ he tangata teka ahau, he pēnā me koutou. Otirā e mātau ana ahau ki a ia, e pupuri ana i tāna kupu. ");
INSERT INTO mri_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I hari tō koutou matua, a Āperahama, mōna ka kite i tōku rā; i kite ia, ā, koa ake.” ");
INSERT INTO mri_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kātahi, ka mea ngā Hūrai ki a ia “Kāhore noa i rima tekau noa ōu tau, ā, kua kite koe i a Āperahama?” ");
INSERT INTO mri_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ka mea a Īhu ki a rātou, “He pono, he pono tāku e mea nei ki a koutou, kāhore noa anō a Āperahama, ko ahau tēnei.” ");
INSERT INTO mri_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nā, ka mau rātou ki ētahi kōhatu hei epa ki a ia, heoi, huna ana a Īhu i a ia, puta ana i roto i te teme­para. ");
INSERT INTO mri_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nā, i a Īhu e haere ana, ka kite ia i tētahi tangata i matapō, nō tōna whānau­tanga mai anō. ");
INSERT INTO mri_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nā, ka ui āna ākonga ki a ia, ka mea, “E te Kai­whaka­ako, ko wai i hara, ko tēnei, ko ōna mātua rānei i whānau matapō ai ia?” ");
INSERT INTO mri_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ka whaka­hokia e Īhu, “Ehara i te mea ko tēnei kua hara, ko ōna mātua rānei; engari, kia ai ia hei whaka­kite­nga mō ngā mahi a te Atua. ");
INSERT INTO mri_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Me mahi e tātou ngā mahi a tōku kai­tono mai i te mea e ao ana; meāke ko te pō e kore ai e taea he mahi e tētahi tangata. ");
INSERT INTO mri_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","I ahau i te ao nei, ko ahau te mārama o te ao.” ");
INSERT INTO mri_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ka mutu ēnei kōrero āna, ka tūwha ia ki te whenua, ā, poke­pokea ana tētahi paru ki te hūware, pania atu ana te paru ki ngā kanohi o te matapō, ");
INSERT INTO mri_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","nā, ka mea ki a ia, “Haere ki te horoi ki te kau­kau­ranga i Hiroama,” ko Tono te whaka­māori­tanga. Nā, haere ana ia, horoi ana, ā, hoki ti­tiro ana mai. ");
INSERT INTO mri_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nā, ka mea ngā tāngata e noho tata ana, rātou ko ngā tāngata i kite i tōna matapō­tanga i mua, “Ehara ianei tēnei i taua tangata i noho rā, i tono mea rā māna?” ");
INSERT INTO mri_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ka mea ētahi, “Ko ia tēnei”. Ko ētahi i mea, “Kāhore, engari rite tonu ki a ia te āhua”. Ka mea ia, “Ko ahau rā ia.” ");
INSERT INTO mri_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kātahi rātou ka mea ki a ia, “Nā te aha rā i kite ai ōu kanohi?” ");
INSERT INTO mri_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ka whaka­hoki ia ka mea, “Nā te tangata, e huaina nei ko Īhu, i poke­poke he paru, pania ana e ia ki ōku kanohi, ka mea mai ki ahau, ‘Haere ki Hiroama horoi ai.’ Nā, ko tōku haere­nga atu, ko tāku horoi­nga, kite ana ahau.” ");
INSERT INTO mri_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nā, ka mea rātou ki a ia, “Kei hea ia?” Ka mea ia, “E kore ahau e mōhio.” ");
INSERT INTO mri_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ka kawea atu ki ngā Parihi taua tangata i matapō i mua rā. ");
INSERT INTO mri_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nā, nō te hāpati i poke­pokea ai e Īhu te paru, i meinga ai ōna kanohi kia kite. ");
INSERT INTO mri_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nā, ka ui anō ngā Parihi ki a ia, ki te pēhea i kite ai ia. Ka mea ia ki a rātou, “I pania e ia he paru ki ōku kanohi, nā, horoi ana ahau, kite ana.” ");
INSERT INTO mri_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nā, ka mea ētahi o ngā Parihi, “Ehara tēnei i te tangata nā te Atua, inā hoki tē whaka­rite ia i te hāpati.” Ka mea ētahi, “Mā te aha e taea ai ēnei mere­kara e te tangata hara?” Nā, ka wehe­wehea rātou. ");
INSERT INTO mri_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ka mea anō rātou ki te matapō, “E pēhea ana koe ki a ia, ki tāna mea­tanga i ōu kanohi kia kite?” Ka mea ia, “He poro­piti ia.” ");
INSERT INTO mri_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Heoi, kāhore ngā Hūrai i whaka­pono i matapō taua tangata, kua meinga anō kia kite, karanga­tia noatia e rātou ngā mātua ōna i meinga nei kia kite, ");
INSERT INTO mri_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ā, ka ui rātou ki a rāua, ka mea, “Ko tā kōrua tama tēnei, e mea nei kōrua i whānau matapō mai? Nā te aha rā ia i ti­tiro ai ināia­nei?” ");
INSERT INTO mri_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ka whaka­hoki ōna mātua ki a rātou, ka mea, “E mōhio ana māua, ko tā māua tama tēnei, i whānau matapō mai anō. ");
INSERT INTO mri_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ko te mea ia i kite ai ia ināia­nei, kāhore i mōhio­tia e māua; kāhore hoki māua e mōhio nā wai i mea ōna kanohi kia kite. He kaumātua ia; ui atu ki a ia, māna ia e kōrero.” ");
INSERT INTO mri_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","I pēnei ōna mātua, nō te mea i mataku rāua i ngā Hūrai. Kua takoto noa ake hoki tā ngā Hūrai tikanga, nā, ki te whaka­ae tētahi, ko te Karaiti ia, me pei ki waho o te whare kara­kia. ");
INSERT INTO mri_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Koia ōna mātua i mea ai, “He kaumātua ia; ui atu ki a ia.” ");
INSERT INTO mri_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nā, ka karanga tuarua rātou ki te tangata i matapō i mua rā, ka mea ki a ia, “Hoatu he korōria ki te Atua; e mātau ana mātou he tangata hara tēnei.” ");
INSERT INTO mri_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nā, ka whaka­hoki ia, ka mea, “Kāhore ahau e mātau he tangata hara rānei ia; kotahi anō tāku e mātau nei, he matapō ahau i mua, ā, inā kua kite.” ");
INSERT INTO mri_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ka mea anō rātou ki a ia, “I aha ia ki a koe? I pēhea­tia ōu kanohi i meinga ai e ia kia kite?” ");
INSERT INTO mri_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ka whaka­hokia e ia ki a rātou, “Kua kōrero­tia anō e ahau ki a koutou inā tonu nei, ā, kīhai koutou i whaka­rongo. He aha koutou i hia­hia ai kia rongo anō? E mea ana oti koutou kia meinga hei ākonga māna?” ");
INSERT INTO mri_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nā, whaka­hī ana rātou ki a ia, ka mea, “Ko tāna ākonga koe; ko mātou ia he ākonga nā Mohi. ");
INSERT INTO mri_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","E mātau ana mātou i kōrero te Atua ki a Mohi; ko tēnei tangata ia kāhore mātou e mātau ki tōna wāhi i haere mai ai.” ");
INSERT INTO mri_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nā, ka whaka­hoki taua tangata, ka mea ki a rātou, “Ha! he mea whaka­mīharo rā tēnei kāhore koutou i mātau ki tōna wāhi i haere mai ai, otirā, kua meinga e ia ōku kanohi kia kite. ");
INSERT INTO mri_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","E mātau ana rā tātou, e kore te Atua e whaka­rongo ki ngā tāngata hara; tēnā ki te mea he tangata kara­kia tētahi ki te Atua, he mea i tāna e pai ai, ka whaka­rongo ia ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kāhore rawa i rangona nō te tīma­tanga rā anō o te ao, i whaka­tiro­hia e tētahi ngā kanohi o te tangata i whānau matapō. ");
INSERT INTO mri_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ki te mea kīhai i puta mai tēnei tangata i te Atua, e kore e taea e ia tētahi mea.” ");
INSERT INTO mri_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nā, ka whaka­hoki rātou, ka mea ki a ia, “I whānau pū koe i roto i ngā hara, ko koe rānei hei whaka­ako i a mātou?” Nā, peia ana ia e rātou ki waho. ");
INSERT INTO mri_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","I rongo a Īhu kua oti ia te pei e rātou ki waho; ā, i tōna kite­nga i a ia, ka mea ki a ia, “E whaka­pono ana rānei koe ki te Tama a te Atua?” ");
INSERT INTO mri_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ka whaka­hoki ia, ka mea, “Ko wai ia, e te Ariki, kia whaka­pono ai ahau ki a ia?” ");
INSERT INTO mri_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ka mea a Īhu ki a ia, “Kua kite koe i a ia, ko ia hoki tēnei e kōrero nei ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nā, ko tāna mea­tanga, “E te Ariki, e whaka­pono ana ahau.” Nā, koro­piko ana ia ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kātahi a Īhu ka mea, “I haere mai ahau ki tēnei ao ki te whaka­rite whaka­wā, he mea e kite ai te hunga kāhore nei i kite; e whaka­matapō­tia ai hoki te hunga e kite ana.” ");
INSERT INTO mri_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ā, ka rangona ēnei mea e ētahi o ngā Parihi e tū tahi ana me ia, ka mea rātou ki a ia, “E matapō ana anō rānei mātou?” ");
INSERT INTO mri_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ka mea a Īhu ki a rātou, “Me i matapō koutou, kāhore ō koutou hara. Tēnā ka mea nā koutou, ‘E kite ana mātou,’ nā, e mau nā tō koutou hara. ");
INSERT INTO mri_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“He pono, he pono tāku e mea nei ki a koutou, ki te kāhore tētahi e tomo rā te kūwaha ki te kāinga hipi, ki te piki kē, he tāhae ia, he tangata pāhua. ");
INSERT INTO mri_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tēnā ko te tangata e tomo ana rā te kūwaha, ko te hēpara ia o ngā hipi. ");
INSERT INTO mri_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ka uaki te kai­tiaki tatau ki a ia; ka rongo anō ngā hipi ki tōna reo. Nā, ka karanga­tia e ia āna hipi ake, tō tēnei ingoa, tō tēnei ingoa, ka āra­hina ki waho. ");
INSERT INTO mri_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ā, ka oti āna ake hipi te tuku ki waho, ka haere ia i mua i a rātou, ka aru ngā hipi i a ia; e mātau ana hoki rātou ki tōna reo. ");
INSERT INTO mri_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","E kore ia rātou e aru i te tauhou, engari ka oma i a ia; e kore hoki e mātau ki te reo o ngā tauhou.” ");
INSERT INTO mri_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","I kōrero­tia tēnei kupu whaka­rite e Īhu ki a rātou; heoi, kīhai rātou i mōhio ki ngā mea i kōrero­tia e ia ki a rātou. ");
INSERT INTO mri_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nā, ka mea anō a Īhu ki a rātou, “He pono, he pono tāku e mea nei ki a koutou, Ko ahau te tatau o ngā hipi. ");
INSERT INTO mri_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","He tāhae, he kai­pāhua te hunga katoa i haere mai i mua i ahau; heoi kīhai ngā hipi i whaka­rongo ki a rātou. ");
INSERT INTO mri_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ko ahau te tatau; ki te waiho ahau hei hua­rahi tomo­kanga mō tētahi, e ora ia, ā, ka haere ki roto, ka haere ki waho, ka kite hoki i te kai. ");
INSERT INTO mri_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Heoi anō tā te tāhae e haere mai ai, he tāhae, he patu, he whaka­mōtī hoki. I haere mai ahau kia whi­whi ai rātou ki te ora, inā, tōna nui noa atu. ");
INSERT INTO mri_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ko ahau te hēpara pai, he hēpara pai, ka tuku i a ia anō kia mate mō ngā hipi. ");
INSERT INTO mri_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tēnā ko te tangata e utua ana, ehara nei i te hēpara, ehara nei i a ia ngā hipi, i tōna kite­nga i te wuruhi e haere mai ana, whaka­rērea ake e ia ngā hipi, oma ana; nā, ka hopu­kia rātou e te wuruhi, ā, whaka­marara­tia ana ngā hipi. ");
INSERT INTO mri_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ka oma te tangata e utua ana, nō te mea e utua ana ia, kāhore hoki ōna whaka­aro ki ngā hipi. ");
INSERT INTO mri_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ko ahau te hēpara pai, e mātau ana hoki ki āku, ā, e mātau ana āku ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Pērā tonu me tō te Matua mātau ki ahau, me tōku mātau hoki ki te Matua. E tuku ana hoki ahau i ahau ki te mate mō ngā hipi. ");
INSERT INTO mri_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","He hipi atu anō āku, ehara nei i tēnei kāinga. Me ārahi mai rātou e ahau, ā, ka rongo rātou ki tōku reo, ā, e whaka­kotahi­tia te kāhui, kotahi anō hoki hēpara. ");
INSERT INTO mri_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Koia te Matua ka aroha mai ai ki ahau, nō te mea e tuku ana ahau i ahau kia mate, kia whaka­ora ake ai anō ahau i ahau. ");
INSERT INTO mri_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ehara i te mea mā tētahi tangata ahau e whaka­mate, engari, māku anō ahau e tuku ki te mate. Kei ahau te tikanga mō te tuku atu, kei ahau anō te tikanga mō te whaka­ora. Nā tōku Matua tēnei ture kua riro mai nei i ahau.” ");
INSERT INTO mri_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kātahi, ka wehe­wehea ngā Hūrai, nā ēnei kupu. ");
INSERT INTO mri_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","He toko­maha o rātou i mea, “He rēwera tōna, e hau­rangi ana; he aha koutou ka whaka­rongo ai ki a ia?” ");
INSERT INTO mri_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ko ētahi i mea, “Ehara ēnei i ngā kupu a te tangata e nohoia ana e te rēwera. E āhei koia i te rēwera te mea i ngā kanohi o ngā matapō kia kite?” ");
INSERT INTO mri_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nā, i Hiruhārama tēnei, i te Hākari Horo­horo­nga. He hōtoke; ");
INSERT INTO mri_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ā, e hāere­ere ana a Īhu i te teme­para, i te whaka­mahau o Horomona. ");
INSERT INTO mri_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nā, ka kara­potia ia e ngā Hūrai, ka mea rātou ki a ia, “Kia pēhea te roa o tāu waiho i ō mātou ngākau i hiki­rangi ana? Ki te mea ko te Karaiti koe, kōrero­tia mata­nui­tia mai ki a mātou.” ");
INSERT INTO mri_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ka whaka­hoki a Īhu ki a rātou, “Kua kōrero­tia e ahau ki a koutou, ā, kāhore koutou e whaka­pono. Ko ngā mahi e mahi nei ahau i runga i te ingoa o tōku Matua, ko ēnei hei kai­whaka­atu mōku. ");
INSERT INTO mri_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Otirā, e kore koutou e whaka­pono, nō te mea ehara koutou i te hipi nāku. ");
INSERT INTO mri_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","E rongo ana āku hipi ki tōku reo, e mātau ana ahau ki a rātou, e aru ana hoki rātou i ahau. ");
INSERT INTO mri_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","E hoatu ana e ahau ki a rātou he ora tonu; e kore rātou e ngaro ake ake, e kore anō hoki tētahi e kapo atu i a rātou i roto i tōku ringa. ");
INSERT INTO mri_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ko tōku Matua, nāna nei rātou i hōmai ki ahau, nui ake i te katoa; e kore anō rātou e taea e tētahi te kapo atu i roto i te ringa o tōku Matua. ");
INSERT INTO mri_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ko ahau, ko te Matua, kotahi māua.” ");
INSERT INTO mri_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kātahi, ka mau anō ngā Hūrai ki te kōhatu hei āki ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ka whaka­hokia e Īhu ki a rātou, “He maha ngā mahi pai kua whaka­kitea nei e ahau ki a koutou, he mea nā tōku Matua. Mō tēhea o aua mahi ka ākina ai ahau e koutou?” ");
INSERT INTO mri_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ka whaka­hoki ngā Hūrai ki a ia, ka mea, “Ehara te mahi pai i te mea e ākina ai koe; engari, mō te kohu­kohu, mō te mea hoki ko koe, tangata nei anō, e whaka­atua ana i a koe.” ");
INSERT INTO mri_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ka whaka­hokia e Īhu ki a rātou, “Kāhore rānei i tuhi­tuhia i roto i tō koutou ture, ‘I mea ahau, “He atua koutou”?’ ");
INSERT INTO mri_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ki te huaina e ia he atua te hunga i tae mai nei te kupu a te Atua ki a rātou, ā, e kore hoki e taea te whaka­kāhore te karaipi­ture. ");
INSERT INTO mri_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","E mea ana oti koutou ki tā te Matua i whaka­tapu ai, i tono mai ai hoki ki te ao, ‘E kohu­kohu ana koe’; nōku i mea, ‘Ko te Tama ahau a te Atua’? ");
INSERT INTO mri_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ki te kore ahau e mahi i ngā mahi a tōku Matua, aua ahau e whaka­pono­hia. ");
INSERT INTO mri_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tēnā, ki te mahi ahau, ahakoa kāhore koutou e whaka­pono ki ahau, whaka­pono­hia ngā mahi; kia mātau ai koutou kia whaka­pono ai, ko te Matua kei roto i ahau, me ahau hoki kei roto i a ia.” ");
INSERT INTO mri_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nā, ka whai anō rātou kia hopu­kia ia; heoi, puta ana ia i ō rātou ringa. ");
INSERT INTO mri_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nā, ka haere anō ia ki tāwāhi o Horano, ki te wāhi i mātua iri­iri ai a Hoani; ā, noho ana i reira. ");
INSERT INTO mri_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ā, toko­maha hoki i haere ki a ia; i mea rātou “Kīhai a Hoani i mahi i tētahi mere­kara; he pono ia ngā mea katoa i kōrero­tia e Hoani mō tēnei.” ");
INSERT INTO mri_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ā, he toko­maha o reira i whaka­pono ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nā, kei te mate tētahi tangata a Raharuhi o Petani, te kāinga o Meri rāua ko tōna tua­kana, ko Māta. ");
INSERT INTO mri_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Ko taua Meri tēnei nāna nei i whaka­wahi te Ariki ki te hinu, i muru hoki i ōna wae­wae ki ōna makawe; ā, he tu­ngāne nōna a Raharuhi i mate nei.) ");
INSERT INTO mri_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nā, ka tono tāngata ngā tuā­hine ki a ia, ka mea, “E te Ariki, tēnei kei te mate tāu tangata e aroha nei.” ");
INSERT INTO mri_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","I te rongo­nga ia o Īhu, ka mea ia, “Ehara tēnei i te mate e mate rawa ai ia, engari, hei mea mō te korōria o te Atua; mā tēnei hoki ka whai korōria ai te Tama a te Atua.” ");
INSERT INTO mri_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nā, i aroha a Īhu ki a Māta rāua ko tōna teina, ki a Raharuhi hoki. ");
INSERT INTO mri_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ā, nō ka rongo ia ki tōna mate­nga, e rua ōna rā i noho ai ki taua wāhi rā anō. ");
INSERT INTO mri_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Muri iho i tēnei, ka mea ia ki āna ākonga, “Tātou ka haere anō ki Hūria.” ");
INSERT INTO mri_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ka mea ngā ākonga ki a ia, “E te Kai­whaka­ako, i whai ngā Hūrai i mua tata ake nei kia ākina koe ki te kōhatu; ā, e haere atu ana koe ki reira?” ");
INSERT INTO mri_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ka whaka­hokia e Īhu, “He teka ianei tekau mā rua ngā hāora o te rā? I te haere tētahi i te awa­tea, e kore ia e tūtuki, nō te mea e kite ana ia i te mārama o tēnei ao. ");
INSERT INTO mri_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tēnā, ka haere tētahi i te pō, ka tūtuki ia, nō te mea kāhore he mārama roto i a ia.” ");
INSERT INTO mri_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ka kōrero­tia ēnei mea e ia, nā, muri iho ka mea ia ki a rātou, “Kei te moe tō tātou hoa a Raharuhi, otiia, ka haere ahau ki te whaka­ara i a ia i te moe.” ");
INSERT INTO mri_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nā, ko te mea­tanga a āna ākonga, “E te Ariki, ki te mea kei te moe ia, tērā ia e ora.” ");
INSERT INTO mri_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kāhore, ko tōna mate­nga tā Īhu i kōrero ai; ko rātou ia i mahara, i kōrero ia mō te takoto­ranga ina moe. ");
INSERT INTO mri_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kātahi, ka mea nui a Īhu ki a rātou, “Kua mate a Raharuhi. ");
INSERT INTO mri_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ā, e hari ana ahau, he whaka­aro hoki ki a koutou, nōku kāhore i reira, kia whaka­pono ai koutou. Ahakoa rā kia haere tātou ki a ia.” ");
INSERT INTO mri_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nā, ka mea a Tamati (e huaina nei ko Ririmu) ki ōna hoa ākonga, “Kia haere anō tātou, kia mate tahi me ia.” ");
INSERT INTO mri_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Heoi, i te taenga atu o Īhu, roko­hanga atu kua whā kē ōna rā i roto i te urupā. ");
INSERT INTO mri_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nā, e tata ana Petani ki Hiruhārama, kotahi pea tekau mā rima pā­ronga, ");
INSERT INTO mri_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","he toko­maha anō ngā Hūrai i tae ki a Māta rāua ko Meri, ki te whaka­mārie i a rāua mō tō rāua tu­ngāne. ");
INSERT INTO mri_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ā, nō te rongo­nga o Māta, tēnā a Īhu te haere mai nā, ka whaka­tau i a ia; ko Meri ia i noho i roto i te whare. ");
INSERT INTO mri_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nā, ka mea a Māta ki a Īhu, “E te Ariki, me i konei koe, kīhai i mate tōku tu­ngāne. ");
INSERT INTO mri_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Heoi, e mātau nei anō ahau, ko tāu e īnoi ai ki te Atua, e hōmai e te Atua ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ka mea a Īhu ki a ia, “E ara anō tōu tu­ngāne.” ");
INSERT INTO mri_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ka mea a Māta ki a ia, “E mātau ana ahau e ara anō ia i te aranga ā te rā whaka­mutu­nga.” ");
INSERT INTO mri_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ka mea a Īhu ki a ia, “Ko ahau te aranga, te ora. Ko ia e whaka­pono ana ki ahau, ahakoa kua mate, e ora anō; ");
INSERT INTO mri_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","e kore anō e mate ake ake ngā tāngata katoa e ora ana, e whaka­pono ana ki ahau. E whaka­pono ana rānei koe ki tēnei?” ");
INSERT INTO mri_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ka mea ia ki a ia, “Āe, e te Ariki, e whaka­pono ana ahau, ko te Karaiti koe, ko te Tama a te Atua, e haere mai ana ki te ao.” ");
INSERT INTO mri_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ā, ka mutu ēnei kōrero āna, ka haere ka karanga puku ki tōna teina, ki a Meri, ka mea, “Kua tae mai te Kai­whaka­ako, e karanga ana hoki ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ā, nō ka rongo ia, hohoro tonu te whaka­tika, ā, haere ana ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Nā, kāhore a Īhu i tomo noa ki te kāinga; heoi, kei taua wāhi anō ia i tūtaki ai a Māta ki a ia.) ");
INSERT INTO mri_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","I te kite­nga o ngā Hūrai e noho ana ki a ia i roto i te whare, e whaka­mārie ana i a ia, ka hohoro a Meri te whaka­tika, te puta ki waho. Ka aru rātou i a ia, ka mea, “E haere ana ia ki te urupā, ki reira tangi ai.” ");
INSERT INTO mri_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ā, nō ka tae a Meri ki te wāhi kei reira nei a Īhu, ka kite i a ia, ka takoto ki ōna wae­wae, ka mea ki a ia, “E te Ariki, me i konei koe, kīhai i mate tōku tu­ngāne.” ");
INSERT INTO mri_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ā, nō ka kite a Īhu i a ia e tangi ana, i ngā Hūrai hoki i haere tahi me ia e tangi ana, ka ngu­nguru ia, arā tōna wairua, ka kōingo. ");
INSERT INTO mri_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nā mea, “I whaka­takoto­ria ia e koutou ki hea?” Ka mea rātou ki a ia, “E te Ariki, haere mai kia kite.” ");
INSERT INTO mri_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tangi ana a Īhu. ");
INSERT INTO mri_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nā, ka mea ngā Hūrai, “Nana, tōna aroha ki a ia!” ");
INSERT INTO mri_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nā, ka mea ētahi o rātou, “Kāhore rānei i taea e tēnei tangata, nāna nei i whaka­titiro ngā kanohi o te matapō, te mea i tēnei tangata hoki kia kaua e mate?” ");
INSERT INTO mri_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nā, ka ngu­nguru anō a Īhu i roto i a ia, ka haere ki te urupā. He ana ia, kua oti te pā ki te kōhatu. ");
INSERT INTO mri_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ka mea a Īhu, “Tango­hia atu e koutou te kōhatu.” Ka mea ki a ia a Māta tua­hine o te tū­pā­paku, “E te Ariki, kua piro noa ake ia; ko tōna pō whā hoki tēnei.” ");
INSERT INTO mri_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Anō rā, ko Īhu ki a ia, “Kīhai koia ahau i mea ki a koe, ki te whaka­pono koe, e kite koe i te korōria o te Atua?” ");
INSERT INTO mri_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nā, ka tango­hia e rātou te kōhatu i te wāhi i takoto ai te tū­pā­paku. Nā, ka ara ake ngā kanohi o Īhu, ka mea ia, “E Pā, ko tāku whaka­whetai tēnei ki a koe, mōu i whaka­rongo ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","I mahara anō ahau e rongo tonu ana koe ki ahau; heoi, he whaka­aro ki te hunga e tū mai nei i kōrero ai ahau, kia whaka­pono ai rātou, nāu ahau i tono mai.” ");
INSERT INTO mri_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ā, nō ka pēnei tāna kī, he nui tōna reo ki te karanga, “E Raharuhi, puta mai!” ");
INSERT INTO mri_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nā, ko te pu­tanga mai o te tū­pā­paku, he mea here ngā ringa me ngā wae­wae ki ngā tākai; he mea takai tōna mata ki te tauera. Ka mea a Īhu ki a rātou, “Wete­kia, tukua kia haere.” ");
INSERT INTO mri_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nā, he toko­maha ngā Hūrai haere nei ki a Meri, ā, i tō rātou kite­nga i ngā mea i mea ai a Īhu, ka whaka­pono ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ko ētahi o rātou i haere ki ngā Parihi, i kōrero ki a rātou i ngā mea i mahia e Īhu. ");
INSERT INTO mri_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nā, ka whaka­minea he rū­nanga e ngā tohu­nga nui rātou ko ngā Parihi, ka mea, “Kei te aha tātou nei? He maha hoki ngā mere­kara e meatia nei e tēnei tangata. ");
INSERT INTO mri_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ki te pēnei tā tātou tuku i a ia, ka whaka­pono katoa ki a ia; ā, ka haere mai ngā Roma, ka tango i tō tātou kāinga, i tō tātou iwi.” ");
INSERT INTO mri_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nā, ko tētahi o rātou ko Kaiapa, ko te tohu­nga nui o taua tau, ka mea ki a rātou, “Kāhore koutou e mātau ki tētahi mea. ");
INSERT INTO mri_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tē whaka­aro, he pai mō tātou ki te mate te tangata kotahi mō te iwi, ā, kāhore e ngaro te iwi katoa.” ");
INSERT INTO mri_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nā, ehara tēnei kōrero i te mea nāna ake, engari, ko te tohu­nga nui ia mō tērā tau, heoi, ka poro­piti kia mate a Īhu mō taua iwi. ");
INSERT INTO mri_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hāunga anō taua iwi anake, engari, kia whaka­minea kia kotahi ngā tama­riki a te Atua kua marara noa atu. ");
INSERT INTO mri_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nō taua rā ake anō, ka rū­nanga rātou kia whaka­matea ia. ");
INSERT INTO mri_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Koia i mutu ai te haere mata­nui o Īhu i roto i ngā Hūrai. Heoi haere atu ana ia i reira ki te wāhi e tata ana ki te koraha, ki tētahi pā, ko Ēparaima te ingoa, ā, noho ana i reira rātou ko āna ākonga. ");
INSERT INTO mri_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nā, kua tata te Kape­nga a ngā Hūrai; he toko­maha hoki i haere atu i taua whenua i mua o te Kape­nga ki Hiruhārama ki te pure i a rātou. ");
INSERT INTO mri_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nā, ka rapu rātou i a Īhu ka kōrero­rero ki a rātou anō, i a rātou e tū ana i te teme­para, “E pēhea ana ō koutou whaka­aro? E kore rānei ia e haere mai ki te hākari?” ");
INSERT INTO mri_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nā, kua takoto te tikanga a ngā tohu­nga nui rātou ko ngā Parihi, ki te mātau tētahi tangata ki te wāhi e noho ai ia, me whaka­atu, kia hopu­kia ai ia e rātou. ");
INSERT INTO mri_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nā, e ono ngā rā i mua ake o te Kape­nga ka haere a Īhu ki Petani, kei reira nei a Raharuhi, i whaka­ara­hia ake nei e ia i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ā, takā ana e rātou he hapa māna i reira; ko Māta te kai­taka, ko Raharuhi tētahi o te hunga i noho tahi me ia. ");
INSERT INTO mri_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nā, ka mau a Meri ki tētahi pāuna hinu kakara he tino nara, he mea utu nui, whaka­wahia ana e ia ngā wae­wae o Īhu, me te muru anō i ōna wae­wae ki ōna makawe; kī noa te whare i te kakara o te hinu. ");
INSERT INTO mri_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nā, ka mea tētahi o āna ākonga, a Hūrā Ikariote, tēnei meāke nei tuku a ia, ");
INSERT INTO mri_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“He aha tēnei hinu tē hokona ai ki ngā pene e toru rau, ka hoatu ai ki te hunga rawa­kore?” ");
INSERT INTO mri_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","I kōrero­tia ai tēnei e ia, ehara i te mea he whaka­aro nōna ki te hunga rawa­kore; erangi, nō te mea he tāhae ia, i a ia hoki te pūtea, ko ia hoki hei mau i ngā mea i whao­ngia ki roto. ");
INSERT INTO mri_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nā, ko te mea­tanga a Īhu, “Waiho rā ū āna; i tohu­ngia tēnei e ia mō te rā o tōku tanu­manga. ");
INSERT INTO mri_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kei a koutou hoki ngā rawa­kore i ngā wā katoa; ko ahau ia e kore e noho tonu i a koutou.” ");
INSERT INTO mri_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","He toko­maha o ngā Hūrai i mātau kei reira a Īhu; ā, haere mai ana, ehara i te mea mō Īhu anake, erangi, kia kite hoki i a Raharuhi, i whaka­ara­hia nei e ia i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Otirā, kua takoto te whaka­aro o ngā tohu­nga nui kia whaka­matea anō a Raharuhi; ");
INSERT INTO mri_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nāna hoki i toko­maha ai ngā Hūrai i haere, i whaka­pono ki a Īhu. ");
INSERT INTO mri_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","I te aonga ake ka rongo te mano tini i haere nei ki te hākari, e haere ana a Īhu ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ka mau rātou ki ngā manga nīkau, haere ana ki te whaka­tau i a ia, me te karanga, “Ohana! Ka whaka­pai­ngia ia, e haere mai nei i runga i te ingoa o te Ariki, te Kīngi o Īharaira!” ");
INSERT INTO mri_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ā, nō ka kite a Īhu i tētahi kūao kāihe, ka noho ia i runga; ka pērā anō me te mea i tuhi­tuhia, ");
INSERT INTO mri_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kaua e mataku, e te tamā­hine a Hiona. Nā, kei te haere mai tōu Kīngi, e noho ana i runga i te kūao kāihe.” ");
INSERT INTO mri_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Otiia, kīhai āna ākonga i mātau wawe ki ēnei mea; engari, ka oti a Īhu te whaka­korōria, kātahi rātou ka mahara kua tuhi­tuhia ēnei mea mōna, kua meinga anō ēnei mea ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","I whaka­ae anō te hunga i tōna taha i tāna karanga­tanga i a Raharuhi i roto i te urupā, i tāna whaka­ara­hanga hoki i a ia i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nā, konei hoki te mano i whaka­tau ai i a ia, i rongo hoki rātou, kua meinga tēnei mere­kara e ia. ");
INSERT INTO mri_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nā, ka mea ngā Parihi ki a rātou anō, “Ka kite rānei koutou kāhore ā koutou wāhi? Nā, kua riro te ao ki te whai i a ia.” ");
INSERT INTO mri_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nā, he Kariki ētahi o te hunga i haere ki te hākari ki te kara­kia. ");
INSERT INTO mri_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ā, haere ana ēnei ki a Piripi o Petahaira o Kariri, kōrero ana ki a ia, mea atu ana, “E kara, e hia­hia ana mātou kia kite i a Īhu.” ");
INSERT INTO mri_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Haere ana a Piripi, ka kōrero ki a Anaru; ka haere a Anaru, a Piripi, ka kōrero ki a Īhu. ");
INSERT INTO mri_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ka kī a Īhu ki a rāua, ka mea, “Kua tae mai te hāora e whaka­korōria­tia ai te Tama a te tangata. ");
INSERT INTO mri_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","He pono, he pono tāku e mea nei ki a koutou, ki te kore tētahi pata wīti e marere ki te one­one, e pirau, ka takoto ko ia anake; tēnā ki te pirau, he nui ōna hua. ");
INSERT INTO mri_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ki te aroha tētahi ki tōna ora, ka mate anō ia; ki te kino tētahi ki te ora i tēnei ao, ka tūturu ki a ia te ora ake ake. ");
INSERT INTO mri_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ki te mea tētahi ko ia hei kai­mahi māku, me aru ia i ahau; ko te wāhi e noho ai ahau, ko reira anō tāku kai­mahi. Ki te mahi tētahi i āku mahi, mā tōku Matua ia e whaka­hōnore.” ");
INSERT INTO mri_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kua pōuri tēnei tōku wairua; ā, kia pēhea atu ahau? E Pā, whaka­ora­ngia ahau i tēnei wā. Otirā, ko te mea tēnei i haere mai ai ahau ki tēnei wā. ");
INSERT INTO mri_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","E Pā, whaka­korōria­tia tōu ingoa.” Nā, ka puta he reo i te rangi, “Kua whaka­korōria­tia e ahau, e whaka­korōria­tia anō.” ");
INSERT INTO mri_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","I te rongo­nga o ngā tāngata e tū ana i reira, ka mea, “He whati­tiri.” Ko ētahi i mea, “Kua kōrero tētahi ana­hera ki a ia.” ");
INSERT INTO mri_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ka whaka­hoki a Īhu, ka mea, “Ehara tēnei reo i puta mai nei i te mea mōku, engari mō koutou. ");
INSERT INTO mri_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ko āia­nei te whaka­wā mō tēnei ao; ko āia­nei makā ai te ranga­tira o tēnei ao ki waho. ");
INSERT INTO mri_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ā, ki te whaka­iri­hia ake ahau ki runga ake i te whenua, māku ngā tāngata katoa e kukume ki ahau.” ");
INSERT INTO mri_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(I pēnei ai ia hei whaka­atu i te mate e mate ai ia.) ");
INSERT INTO mri_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ka whaka­hokia e te mano ki a ia, “Kua rongo mātou ki tā te ture, e ora tonu ana a te Karaiti. He aha tāu e mea, ‘Me whaka­iri te Tama a te tangata?’ Ko wai koia tēnei Tama a te tangata?” ");
INSERT INTO mri_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Anō rā, ko Īhu ki a rātou, “He wāhi iti nei te maunga o te mārama i roto i a koutou. Haere rā i te mea e whai mārama ana koutou, kei roko­hina koutou e te pōuri. Ko ia hoki e haere ana i te pōuri e kore e kite i te wāhi e haere ai ia. ");
INSERT INTO mri_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","I te mea kei a koutou te mārama, me whaka­pono ki te mārama, kia meinga ai koutou he tama­riki nā te mārama.” I kōrero­tia e Īhu ēnei mea, ā, haere ana, huna ana i a ia, kei kitea e rātou. ");
INSERT INTO mri_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Heoi, ahakoa i meatia e ia aua mere­kara maha ki tō rātou aro­aro, kīhai rātou i whaka­pono ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","I rite ai te kōrero a Ihāia poro­piti, tāna i mea ai: “E te Ariki, ko wai i whaka­pono ki tā mātou kōrero? I whaka­kitea hoki ki a wai te ringa o te Ariki?” ");
INSERT INTO mri_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Koia hoki rātou tē āhei ai te whaka­pono, kua mea nei hoki a Ihāia, ");
INSERT INTO mri_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“I whaka­matapō­tia e ia ō rātou kanohi, i whaka­pakeke­tia ō rātou ngākau; kei kite ō rātou kanohi, kei mātau hoki ō rātou ngākau, kei tahuri rātou, ā, ka whaka­ora­ngia e ahau.” ");
INSERT INTO mri_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","I kōrero­tia ēnei mea e Ihāia, i te wā i kite ai ia i tōna korōria, i puaki ai hoki tāna kupu mōna. ");
INSERT INTO mri_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","He ahakoa rā he toko­maha anō ngā ranga­tira i whaka­pono ki a ia. Otirā, kīhai i whaka­ae ki a ia, he whaka­aro hoki ki ngā Parihi, kei peia rātou ki waho o te whare kara­kia; ");
INSERT INTO mri_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","rawe ake hoki ki a rātou tā te tangata korōria i tā te Atua. ");
INSERT INTO mri_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nā, ka karanga a Īhu, ka mea, “Ki te whaka­pono tētahi ki ahau, ehara ahau i tāna i whaka­pono mai ai, engari, ko tōku kai­tono mai. ");
INSERT INTO mri_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ko ia e kite ana i ahau, e kite ana hoki i tōku kai­tono mai. ");
INSERT INTO mri_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kua tae mai nei ahau hei whaka­mārama mō te ao, kei noho i te pōuri tētahi e whaka­pono ana ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nā, ki te rongo tētahi ki āku kupu, ki te kore hoki e puri­tia e ia, e kore ahau e whaka­hē i a ia; kīhai hoki ahau i haere mai ki te whaka­hē i te ao, engari, ki te whaka­ora i te ao. ");
INSERT INTO mri_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ko ia e whaka­kāhore ana ki ahau e kore hoki e tango ki āku kupu, tēnā anō te kai­whaka­hē mōna; ko te kupu i kōrero­tia e ahau, ko tēnā hei whaka­hē mōna ā te rā whaka­mutu­nga. ");
INSERT INTO mri_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nō te mea ehara i ahau ake āku kōrero; engari, nā te Matua i tonoa mai ai ahau, nāna i tuku mai te ture ki ahau, mō tāku e kōrero ai, mō tāku e kī ai. ");
INSERT INTO mri_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ā, e mātau ana ahau he ora tonu tāna ture. Nā, ko āku e kōrero nei rite tonu ki tā te Matua i mea mai ai ki ahau tāku kōrero.” ");
INSERT INTO mri_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nā, i mua ake o te Hākari o te Kape­nga, ka mahara a Īhu kua taka tōna wā e haere atu ai ia i tēnei ao ki te Matua; aroha ana ia ki ōna o te ao nei, aroha­ina ana rātou taea noatia te mutu­nga. ");
INSERT INTO mri_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ā, i te mutu­nga o te hapa, kua whaka­mahara­tia noatia ake anō hoki e te rēwera te ngākau o Hūrā Ikariote, tama a Haimona, kia tukua ia. ");
INSERT INTO mri_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ā, ka mahara a Īhu kua oti ngā mea katoa te hōmai e te Matua ki ōna ringa, i haere mai ia i te Atua, e hoki atu ana ki te Atua; ");
INSERT INTO mri_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ka whaka­tika ia i te hapa, ka whaka­rere i ōna kākahu, ka mau ki te tauera, ka whī­tiki i a ia. ");
INSERT INTO mri_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Me i reira, ka ringi­hia e ia he wai ki te pei­hana, ā, ka anga ka horoi i ngā wae­wae o ngā ākonga, ka muru hoki ki te tauera i whī­tiki­ria ai ia. ");
INSERT INTO mri_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ā, ka tae ia ki a Haimona Pita, ka mea tērā ki a ia, “E te Ariki, e horoi ana koe i ōku wae­wae?” ");
INSERT INTO mri_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ka whaka­hoki a Īhu, ka mea ki a ia, “E kore koe e mātau āia­nei ki tāku e mea nei; otirā, e mātau koe ā mua ake nei.” ");
INSERT INTO mri_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ka mea a Pita ki a ia, “E kore rawa koe e horoi i ōku wae­wae.” Ka whaka­hokia e Īhu ki a ia, “Ki te kore ahau e horoi i a koe, kāhore āu wāhi i roto i ahau.” ");
INSERT INTO mri_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ka mea a Haimona Pita ki a ia, “E te Ariki, aua rā ko ōku wae­wae anake, engari, ko ōku ringa me tōku māte­nga.” ");
INSERT INTO mri_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ka mea a Īhu ki a ia, “Ki te mea i te kau­kau tētahi, kāhore atu he aha māna, ko te horoi anake i ōna wae­wae, e mā katoa ana hoki ia. E mā ana koutou, otirā kāhore katoa.” ");
INSERT INTO mri_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","I mōhio hoki ia ki te tangata e tukua ai ia, koia ia i mea ai, “Kāhore koutou katoa i mā.” ");
INSERT INTO mri_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ā, ka oti ō rātou wae­wae te horoi, ka mau ia ki ōna kākahu, ka noho anō, nā, ka mea ki a rātou, “E mātau ana i rānei koutou ki tāku i mea nei ki a koutou? ");
INSERT INTO mri_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","E karanga­tia ana ahau e koutou, ‘E te Kai­whaka­ako, E te Ariki’, ā, he tika tā koutou kōrero, ko ahau hoki ia. ");
INSERT INTO mri_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nā, kua horoia nei ō koutou wae­wae e ahau, e tō koutou Ariki, e tō koutou Kai­whaka­ako me horoi anō hoki e koutou ngā wae­wae o tētahi, o tētahi o koutou. ");
INSERT INTO mri_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kua hoatu nei hoki e ahau he tauira mō koutou, kia rite ai tā koutou mahi ki tāku i mea nei ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","He pono, he pono tāku e mea nei ki a koutou, kāhore te pono­nga e nui ake i tōna ranga­tira; e kore anō te tangata i tonoa e nui atu i tōna kai­tono. ");
INSERT INTO mri_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ki te mātau koutou ki ēnei mea, ka koa ki te meatia e koutou. ");
INSERT INTO mri_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ehara tāku i te kōrero mō koutou katoa; e mātau ana ahau ki āku i whiri­whiri ai. Otirā, kia rite ai te karaipi­ture, ‘Ko ia e kai taro tahi nei māua kua hiki ake tōna reke­reke ki ahau.’ ");
INSERT INTO mri_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nā, ka kōrero­tia nei e ahau ki a koutou i te mea kāhore anō i puta noa, mō te puta rawa mai, kia whaka­pono ai koutou, ko ahau ia. ");
INSERT INTO mri_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","He pono, he pono tāku e mea atu nei ki a koutou, ki te tango tētahi ki tāku e tono ai, e tango ana ia i ahau; ā, ki te tango tētahi i ahau, e tango ana ki tōku kai­tono mai.” ");
INSERT INTO mri_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ā, nō ka kōrero­tia e Īhu ēnei mea, ka pōuri tōna wairua, ka kōrero ia, ka mea, “He pono, he pono tāku e mea nei ki a koutou, mā tētahi o koutou ahau e tuku.” ");
INSERT INTO mri_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nā, ka ti­tiro ngā ākonga tētahi ki tētahi, ka pōhēhē ko wai rānei tāna i kōrero ai. ");
INSERT INTO mri_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nā, i te whaka­whiri­naki ki te uma o Īhu tētahi o āna ākonga, ko tā Īhu hoki i aroha ai. ");
INSERT INTO mri_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nā, ka tā­whiri atu a Haimona Pita ki a ia, ka mea atu, “Kōrero­tia mai ki a mātou, ko wai tāna e kōrero nei.” ");
INSERT INTO mri_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nā, ka takoto atu ia ki te uma o Īhu, ka mea ki a ia, “E te Ariki, ko wai koia?” ");
INSERT INTO mri_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ka whaka­hokia e Īhu, “Ko te tangata e hoatu ai e ahau te mara­mara taro ki a ia, ina toua iho e ahau.” Ā, nō ka toua iho e ia te mara­mara taro, ka hoatu ki a Hūrā, tama a Haimona Ikariote. ");
INSERT INTO mri_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ā, muri iho i te mara­mara taro, ka tomo a Hātana ki roto ki a ia. Nā, ka mea a Īhu ki a ia, “Hohoro te mea i tāu e mea ai.” ");
INSERT INTO mri_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kāhore ia tētahi o te hunga i taua hapa i mātau mō te aha tēnei i kōrero­tia nei e ia ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","I mahara ētahi, nō te mea i a Hūrā te pūtea, tērā a Īhu te mea rā ki a ia, “Hokona ngā mea mā tātou mō te hākari; kia hoatu rānei tētahi mea mā ngā rawa­kore.” ");
INSERT INTO mri_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nā, ka tango­hia e ia te mara­mara taro, haere tonu atu ki waho. He pō anō hoki. ");
INSERT INTO mri_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nō tōna riro­nga atu ki waho, ka mea a Īhu, “Kātahi te Tama a te tangata ka whaka­korōria­tia, ka whai korōria anō te Atua i a ia. ");
INSERT INTO mri_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ā, ka whaka­korōria te Atua i a ia i roto i a ia ake, inā, ka hohoro tāna whaka­korōria i a ia. ");
INSERT INTO mri_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","E ngā tama­riki, poto kau nei tāku noho i a koutou, tērā koutou e rapu i ahau, ko tāku hoki i mea ai ki ngā Hūrai, E kore koutou e āhei te haere ake ki te wāhi e haere ai ahau; ko tāku kupu anō tēnā ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","He ture hou tāku ka hoatu nei ki a koutou, kia aroha koutou tētahi ki tētahi; kia rite ki tōku aroha ki a koutou, wai­hoki kia aroha koutou tētahi ki tētahi. ");
INSERT INTO mri_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mā konei ka mātau ai te katoa, he ākonga koutou nāku, me ka aroha koutou tētahi ki tētahi.” ");
INSERT INTO mri_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ka mea a Haimona Pita ki a ia, “E te Ariki, e haere ana koe ki hea?” Ka whaka­hokia e Īhu ki a ia, “E kore koe e āhei te aru i ahau āia­nei ki te wāhi e haere atu nei ahau; ā, mua ia ka aru koe i ahau.” ");
INSERT INTO mri_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ka mea a Pita ki a ia, “E te Ariki, he aha ahau tē aru ai i a koe āia­nei nei anō? Ka tuku ahau i ahau kia mate, he whaka­aro nāku ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ka whaka­hokia e Īhu ki a ia, “E tuku oti koe i a koe ki te mate, he whaka­aro nāu ki ahau? He pono, he pono tāku e mea nei ki a koe, e kore e tangi te tī­kao­kao, kia toru rā anō āu whaka­kāhore­tanga ki ahau.” ");
INSERT INTO mri_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Kei pōuri ō koutou ngākau; e whaka­pono ana koutou ki te Atua, whaka­pono hoki ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","He maha ngā nohoa­nga i roto i te whare o tōku Matua; me he kāhore, kua kōrero­tia e ahau ki a koutou. Ka haere hoki ahau ki te mea i tētahi wāhi hei tuku­nga ake mō koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ā, ki te haere ahau ki te mea wāhi hei tuku­nga ake mō koutou, ka haere mai anō ahau, ā, ka tango i a koutou ki ahau; kia noho ai hoki koutou ki te wāhi e noho ai ahau. ");
INSERT INTO mri_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nā, e mātau ana koutou ki te hua­rahi ki te wāhi e haere atu nei ahau.” ");
INSERT INTO mri_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nā, ka mea a Tamati ki a ia, “E te Ariki, kāhore mātou e mātau ki te wāhi e haere nā koe; me pēhea ka mātau ai mātou ki te hua­rahi?” ");
INSERT INTO mri_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ka mea a Īhu ki a ia, “Ko ahau te hua­rahi, te pono, te ora; e kore rawa tētahi tangata e haere ake ki te Matua, ki te kāhore ahau. ");
INSERT INTO mri_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Me i mātau koutou ki ahau, kua mātau anō ki tōku Matua. Nā i ēnei ake wā ka mōhio koutou ki a ia, kua kite anō hoki i a ia.” ");
INSERT INTO mri_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ka mea a Piripi ki a ia, “E te Ariki, whaka­kitea te Matua ki a mātou, ā, ka tatū ō mātou ngākau.” ");
INSERT INTO mri_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ka mea a Īhu ki a ia, “Roa noa atu tōku noho ki a koutou, ā, kāhore anō koe i mātau noa ki ahau, e Piripi? Ko ia kua kite i ahau kua kite hoki i te Matua; he aha koe ka mea ai, ‘Whaka­kitea mai te Matua ki a mātou?’ ");
INSERT INTO mri_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","E kore ianei koe e whaka­pono, ko ahau kei roto i te Matua, ko te Matua kei roto i ahau? Ko ngā kupu e kōrero nei ahau ki a koutou, ehara i te kōrero nāku ake; engari, nā te Matua e noho ana i roto i ahau, ko ia te mea ana i ngā mahi. ");
INSERT INTO mri_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Whaka­pono mai ki ahau, kei roto ahau i te Matua, ko te Matua hoki kei roto i ahau; ki te kāhore, whaka­aro ki ngā mahi, ka whaka­pono ai ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","He pono, he pono tāku e mea atu nei ki a koutou, ki te whaka­pono tētahi ki ahau, ko ngā mahi e mea nei ahau, e meinga anō e ia; ā, nui atu i ēnei āna e mea ai; nō te mea e haere ana ahau ki tōku Matua. ");
INSERT INTO mri_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ā, ko tā koutou e īnoi ai i runga i tōku ingoa, e meatia tēnei e ahau, kia whai korōria ai te Matua i te Tama. ");
INSERT INTO mri_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ki te īnoia e koutou tētahi mea i ahau i runga i tōku ingoa, māku e whaka­mana.” ");
INSERT INTO mri_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ki te aroha koutou ki ahau, kia mau ki āku ture. ");
INSERT INTO mri_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ka īnoi ahau ki te Matua, ā, māna e hoatu ki a koutou tētahi atu Kai­whaka­mārie, hei noho tonu ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ko te Wairua o te pono; e kore nei e riro i te ao, nō te mea e kore e kite i a ia, e kore anō e mātau ki a ia. Kei a koutou hoki ia e noho ana, ā, ka noho anō i roto i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“E kore koutou e waiho pani e ahau. E haere mai anō ahau ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Taro ake, ā, heoi anō kite­nga o te ao i ahau; ko koutou ia e kite i ahau; e ora ana ahau, ka ora anō koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ā taua rā koutou mātau ai kei roto ahau i tōku Matua, ko koutou anō kei roto i ahau, me ahau hoki kei roto i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ko te tangata kei a ia nei āku ture, e puri­tia ana hoki e ia, ko ia te aroha ana ki ahau: ki te aroha tētahi ki ahau, ka aroha­ina ia e tōku Matua, ā, ka aroha ahau ki a ia, ka whaka­atu i ahau ki a ia.” ");
INSERT INTO mri_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ka mea a Hūrā ki a ia (hāunga a Ikariote) “E te Ariki, he pēhea i whaka­atu ai koe i a koe ki a mātou, ā, kāhore ki te ao?” ");
INSERT INTO mri_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ka whaka­hoki a Īhu, ka mea ki a ia, “Ki te aroha tētahi ki ahau, e puri­tia e ia tāku kupu, ā, ka aroha­ina ia e tōku Matua, ka haere atu māua ki a ia, ka noho tonu ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ki te kāhore tētahi e aroha ki ahau, e kore e puri­tia e ia āku kupu. Nā, ehara i ahau ake te kupu e rongo nei koutou, engari, nā te Matua i tonoa mai ai ahau. ");
INSERT INTO mri_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Kua kōrero­tia nei e ahau ēnei mea ki a koutou, i ahau e noho nei i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nā, ko te kai­whaka­mārie, arā ko te Wairua Tapu, e tonoa mai e te Matua i runga i tōku ingoa, māna koutou e whaka­ako ki ngā mea katoa, māna koutou e whaka­mahara ki ngā mea katoa kua kōrero­tia nei e ahau ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“He rangi­mārie tāku e waiho nei ki a koutou, tēnei tāku rangi­mārie te hoatu nei e ahau ki a koutou. E kore e rite ki tā te ao hoatu tāku hoatu ki a koutou. Kei pōuri ō koutou ngākau, kei mataku. ");
INSERT INTO mri_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kua rongo nā koutou ki tāku i mea ai ki a koutou, ‘E haere ana ahau, ā, ka hoki mai anō ki a koutou.’ Me i aroha koutou ki ahau, kua hari koutou, nōku i mea, ‘E haere ana ahau ki te Matua.’ He nui ake hoki tōku Matua i ahau. ");
INSERT INTO mri_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nā, kua kōrero nei ahau ki a koutou; i te mea kāhore anō i puta, mō te puta rawa mai, ka whaka­pono koutou. ");
INSERT INTO mri_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","E kore e maha ake āku kōrero ki a koutou. E haere mai ana hoki te ariki o tēnei ao, kāhore hoki āna wāhi i roto i ahau; ");
INSERT INTO mri_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","otirā, kia mātau ai te ao, e aroha ana ahau ki te Matua; ko tā te Matua anō i whaka­hau mai ai ki ahau, ko tāku tēnā e mea nei. “Whaka­tika, ka haere atu tātou i konei.” ");
INSERT INTO mri_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ko ahau te wāina pono, ko tōku Matua te kai­mahi. ");
INSERT INTO mri_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ko ngā manga katoa i roto i ahau e kore e whai hua, e tango­hia e ia. Ko ngā mea katoa hoki e whai hua ana, ka whaka­paia e ia, kia maha atu ai ōna hua. ");
INSERT INTO mri_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nā, kua mā tēnei koutou i te kupu i kōrero­tia e ahau ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kia ū koutou ki roto ki ahau, me ahau hoki ki roto ki a koutou. Ka rite hoki ki te manga e kore e whai hua ko ia anake, ki te kāhore e ū ki te wāina; e kore anō hoki koutou, ki te kore e ū ki roto ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ko ahau te wāina, ko koutou ngā manga. Ki te ū tētahi ki roto ki ahau, me ahau hoki ki roto ki a ia, ka maha o tērā hua; ki te motu kē hoki i ahau, e kore tētahi mea e taea e koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ki te kore e ū tētahi ki roto ki ahau, ka makā atu ia, ānō he manga, ā, ka maroke; nā, ka kohiko­hia, ka makā ki te kāpura, ka tahuna. ");
INSERT INTO mri_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ki te ū koutou ki roto ki ahau, ki te ū anō āku kupu ki roto ki a koutou, īnoia e koutou tā koutou e pai ai, ā, ka meatia mā koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ka whaka­korōria­tia tōku Matua ki te pēnei, ki te whai hua maha koutou, ā, ka meinga koutou he ākonga nāku. ");
INSERT INTO mri_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Rite tonu ki tō te Matua aroha ki ahau tōku aroha ki a koutou; kia ū ki tōku aroha. ");
INSERT INTO mri_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ki te pupuri koutou i āku ture, ka ū koutou ki tōku aroha; me ahau hoki kua pupuri nei i ngā ture a tōku Matua, ka ū nei ki tōna aroha. ");
INSERT INTO mri_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Kua kōrero­tia ēnei mea e ahau ki a koutou, kia pūmau ai tōku koa i roto i a koutou, kia tino kī ai tō koutou koa. ");
INSERT INTO mri_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ko tāku ture tēnei, kia aroha koutou tētahi ki tētahi, me ahau hoki kua aroha nei ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kāhore he aroha o tētahi i rahi ake i tēnei, arā, kia tuku te tangata i a ia anō kia mate mō ōna hoa. ");
INSERT INTO mri_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ko koutou ōku hoa, ki te meatia e koutou āku e whaka­hau nei ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Heoi anō tāku mea­tanga he pono­nga koutou; e kore hoki te pono­nga e mōhio ki tā tōna ariki e mea ai; engari, kua oti koutou te hua e ahau he hoa; ko āku mea katoa hoki i rongo ai ahau ki tōku Matua, kua oti te whaka­kite e ahau ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kāhore koutou i whiri­whiri i ahau, engari, nāku koutou i whiri­whiri, nāku anō koutou i mea kia haere, kia whai hua, kia mau tonu hoki ō koutou hua; ā, ko tā koutou e īnoi ai ki te Matua i runga i tōku ingoa, ka hoatu e ia ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ko āku whaka­hau ēnei ki a koutou, kia aroha koutou tētahi ki tētahi.” ");
INSERT INTO mri_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ki te mea e kino­ngia ana koutou e te ao, e mōhio ana koutou i kino­ngia ahau i mua i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Me­he­mea nō te ao koutou, e aroha­ina e te ao ōna. Tēnā ko tēnei ehara nei koutou i te ao, nāku koutou i whiri­whiri i roto i te ao, koia te ao ka kino ai ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kia mahara ki te kupu i kōrero ai ahau ki a koutou, kāhore te pono­nga e rahi ake i tōna ariki. Ki te mea i whaka­toia ahau e rātou, ka whaka­toia anō koutou; ki te mea i pupuri rātou i tāku kupu, ka pupuri anō rātou i tā koutou. ");
INSERT INTO mri_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Otirā, e meatia katoa­tia ēnei mea e rātou ki a koutou he whaka­aro ki tōku ingoa, nō te mea kāhore rātou i mōhio ki tōku kai­tono mai. ");
INSERT INTO mri_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Me i kaua ahau te haere mai, te kōrero ki a rātou, pēnei kāhore ō rātou hara. Tēnā ko tēnei kāhore ō rātou whaka­ora­ora mō tō rātou hara. ");
INSERT INTO mri_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ko te tangata e whaka­kino ana ki ahau, e whaka­kino ana hoki ki tōku Matua. ");
INSERT INTO mri_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Me i kaua te mahia e ahau i roto i a rātou ngā mahi kāhore i mahia e tētahi atu, pēnei kāhore ō rātou hara. Tēnā ko tēnei kua kite rātou, kua whaka­kino anō hoki ki a māua tahi ko tōku Matua. ");
INSERT INTO mri_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mā tēnei ia ka rite ai te kupu i tuhi­tuhia ki tā rātou ture, ‘Kua kino noa rātou ki ahau.’ ");
INSERT INTO mri_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Otiia, ka tae mai te Kai­whaka­mārie e tonoa mai e ahau ki a koutou i te Matua, te Wairua o te pono, e puta mai ana i te Matua, ko ia hei kai­whaka­atu mōku. ");
INSERT INTO mri_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ko koutou anō hoki hei kai­whaka­atu, nō te mea i ahau koutou nō te tīma­tanga iho rā anō.” ");
INSERT INTO mri_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kua kōrero­tia e ahau ēnei mea ki a koutou, kei hē koutou. ");
INSERT INTO mri_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ka peia atu koutou i roto i ngā whare kara­kia; ā, meāke puta te wā e mea ai te kai­whaka­mate i a koutou, he mahi pai tāna ki te Atua. ");
INSERT INTO mri_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nā, e meatia ēnei mea, nō te mea kāhore rātou i mōhio ki te Matua, kāhore hoki ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Otiia, kua kōrero­tia ēnei mea e ahau ki a koutou, mō te puta rawa mai o taua wā, ka mahara koutou ki aua mea, he mea kōrero nāku ki a koutou. “Nā, kīhai ēnei mea i kōrero­tia e ahau ki a koutou i te tīma­tanga, nō te mea e noho ana ahau i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nā, e haere ana tēnei ahau ki tōku kai­tono mai; ā, kāhore tētahi o koutou i ui mai ki ahau, ‘Ko hea koe?’ ");
INSERT INTO mri_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Otirā, i tāku kōrero­tanga i ēnei mea ki a koutou, ka kī ō koutou ngākau i te pōuri. ");
INSERT INTO mri_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","He pono ia tāku kōrero ki a koutou; nui atu te pai mō koutou ki te haere ahau; ki te kāhore hoki ahau e haere, e kore te Kai­whaka­mārie e tae mai ki a koutou; ā, ki te haere ahau, māku ia e tono mai ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nā, ka tae mai ia, māna e whaka­atu ki te ao te hara, te tika, me te whaka­wā. ");
INSERT INTO mri_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Te hara, mō rātou kāhore e whaka­pono ki ahau; ");
INSERT INTO mri_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","te tika, nō te mea e haere ana ahau ki tōku Matua, ā, heoi anō tō koutou kite­nga i ahau; ");
INSERT INTO mri_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","te whaka­wā, nō te mea kua whaka­tikaia te whaka­wā mō te ranga­tira o tēnei ao. ");
INSERT INTO mri_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“He maha atu anō ngā mea hei kōrero māku ki a koutou, otirā, e kore e taea e koutou te mau āia­nei. ");
INSERT INTO mri_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Otirā, kia tae mai ia, te Wairua o te pono, māna koutou e ārahi ki te pono katoa; ehara hoki tāna i te kōrero nāna ake; engari, ka kōrero­tia e ia ngā mea e rongo ai ia; māna hoki e whaka­kite ki a koutou ngā mea e puta mai ana. ");
INSERT INTO mri_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ka whaka­korōria­tia ahau e ia; ka tango hoki ia i āku mea, ā, ka whaka­atu­ria ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ko ngā mea katoa a te Matua, nāku. Koia ahau i mea ai, ka tango­hia e ia āku mea, ā, ka whaka­atu­ria ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Taro ake, ā, e kore koutou e kite anō i ahau; ā, taro ake anō, ka kite koutou i ahau, nō te mea ka haere ahau ki te Matua.” ");
INSERT INTO mri_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nā, ka mea ētahi o āna ākonga tētahi ki tētahi, “He aha tēnei e mea nei ia ki a tātou, ‘Taro ake, ā, e kore koutou e kite i ahau; ā, taro ake anō, ka kite koutou i ahau’; me tēnei, ‘Nō te mea e haere ana ahau ki te Matua’?” ");
INSERT INTO mri_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nā, ka mea rātou, “He aha tēnei e mea nei ia, ‘Taro ake?’ E kore tātou e mātau ki tāna e mea nei.” ");
INSERT INTO mri_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ā, i mōhio a Īhu e hia­hia ana rātou ki te ui ki a ia, ka mea ki a rātou, “E rapu ana koutou ki a koutou anō ki tāku i mea rā, ‘Taro ake, ā, e kore koutou e kite i ahau; ā, taro ake anō ka kite koutou i ahau’? ");
INSERT INTO mri_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","He pono, he pono tāku e mea nei ki a koutou, Ka tangi koutou, ka auē, ko te ao ia ka hari; e pōuri anō koutou, otirā ka meinga tō koutou pōuri hei hari. ");
INSERT INTO mri_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","I te mea ka whaka­mamae te wahine, ka pōuri, nō te mea ka tae tōna wā. Ka whānau tāna tama­iti, heoi anō, mahara ki te mamae, i te hari hoki, nō te mea ka whānau he tangata ki te ao. ");
INSERT INTO mri_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nā, tēnei koutou te pōuri nei; e kite anō ia ahau i a koutou, ā, ka hari ō koutou ngākau, e kore hoki e tango­hia i a koutou tō koutou hari e tētahi. ");
INSERT INTO mri_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nā, ā taua rā e kore koutou e ui ki tētahi mea i ahau. He pono, he pono tāku e mea nei ki a koutou, ko ā koutou e īnoi ai ki te Matua i runga i tōku ingoa, e hoatu e ia ki a koutou. ");
INSERT INTO mri_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kāhore anō i īnoia noatia e koutou tētahi mea i runga i tōku ingoa. Īnoia, ā, ka whi­whi koutou, kia tino nui ai tō koutou koa. ");
INSERT INTO mri_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“He mea whaka­rite tāku kōrero i ēnei mea ki a koutou. Otiia, meāke puta te wā e kore ai ahau e kōrero kupu whaka­rite ki a koutou, engari, ka mārama tonu tāku kōrero ki a koutou mō te Matua. ");
INSERT INTO mri_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ā taua rā, ka īnoi koutou i runga i tōku ingoa; ā, e kore ahau e mea ki a koutou e īnoi ahau ki te Matua mō koutou. ");
INSERT INTO mri_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","E aroha ana hoki te Matua ake anō ki a koutou, mō koutou i aroha ki ahau, i whaka­pono hoki i haere mai ahau i te Matua. ");
INSERT INTO mri_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","I haere mai ahau i te Matua, ā, kua tae mai nei ki te ao; ka mahue anō i ahau te ao, ā, ka haere ki te Matua.” ");
INSERT INTO mri_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ka mea āna ākonga ki a ia, “Nā, kua mārama tāu kōrero, ehara tāu kōrero i te kupu whaka­rite. ");
INSERT INTO mri_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kātahi mātou ka mōhio, tēnei koe te mōhio nei ki ngā mea katoa, e kore anō e mea mā tētahi e ui ki a koe; nā konei mātou i whaka­pono ai i haere mai koe i te Atua.” ");
INSERT INTO mri_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ka whaka­hokia e Īhu ki a rātou, “Kātahi koutou ka whaka­pono? ");
INSERT INTO mri_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nā, meāke puta te wā, ā, kua puta nei anō, e whaka­marara­tia ai koutou ki tōna wāhi, ki tōna wāhi, ā, ka waiho ko ahau anake. Otiia, he teka ko ahau anake, nō te mea kei ahau nei te Matua. ");
INSERT INTO mri_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kua kōrero­tia e ahau ēnei mea ki a koutou, kia whai mārie­tanga ai koutou i roto i ahau. Ko tā koutou i te ao nei, he mamate. Otirā kia māia; kua taea e ahau te ao!” ");
INSERT INTO mri_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ka kōrero­tia ēnei mea e Īhu, nā, ka anga ake ōna kanohi ki te rangi, ka mea, “E Pā, kua taea te hāora; whaka­korōria­tia tāu Tama, kia whaka­korōria­tia ai anō hoki koe e tāu Tama. ");
INSERT INTO mri_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kua tukua mai nei hoki e koe ki a ia ngā tikanga mō ngā kiko­kiko katoa, kia hoatu e ia te ora tonu ki te hunga katoa kua hōmai nei e koe ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ko te ora tonu hoki tēnei, kia mātau rātou ki a koe, ko koe anake te Atua pono, ki a Īhu Karaiti anō hoki i tonoa mai nei e koe. ");
INSERT INTO mri_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kua whaka­korōria­tia koe e ahau i runga i te whenua; ka oti i ahau te mahi i hōmai e koe kia mahia e ahau. ");
INSERT INTO mri_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nā, kia whai korōria ahau āia­nei i a koe ake, e Pā, hei te korōria i whi­whi ai ahau i a koe i mua atu o te ao. ");
INSERT INTO mri_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kua whaka­pua­kina e ahau tōu ingoa ki ngā tāngata i hōmai nei e koe ki ahau i roto i te ao. Nōu rātou, nāu anō hoki rātou i hōmai ki ahau, ā, kua puri­tia e rātou tāu kupu. ");
INSERT INTO mri_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kātahi rātou ka mātau nāu ngā mea katoa i hōmai nei e koe ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nō te mea kua hoatu e ahau ki a rātou ngā kupu i hōmai nei e koe ki ahau; ā, kua tango rātou, kua tino mātau anō, i haere mai ahau i a koe, kua whaka­pono rātou, nāu ahau i tono mai. ");
INSERT INTO mri_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Mō rātou tāku īnoi; kāhore āku īnoi mō te ao, engari, mō āu i hōmai ai ki ahau; nāu hoki rātou. ");
INSERT INTO mri_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ko āku mea katoa nāu, nāku hoki āu; ā, ka whai korōria ahau i a rātou. ");
INSERT INTO mri_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nā, heoi anō tōku noho ki te ao; kei te ao nei anō ēnei, ko ahau ia ka haere atu ki a koe. E te Matua tapu, puri­tia i runga i tōu ingoa te hunga kua hōmai nei e koe ki ahau, kia kotahi ai rātou, me tāua nei. ");
INSERT INTO mri_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","I ahau anō e noho ana i a rātou i te ao, i puri­tia rātou e ahau i runga i tōu ingoa. Kua tiaki­na e ahau āu i hōmai ai ki ahau, ā, kāhore tētahi o rātou i ngaro, ko te tama anake o te ngaro­manga; kia rite ai te karaipi­ture. ");
INSERT INTO mri_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nā, ka haere atu nei ahau ki a koe, ā, e kōrero­tia ana e ahau ēnei mea i te ao nei, kia tino nui ai tōku koa i roto i a rātou. ");
INSERT INTO mri_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kua hoatu e ahau tāu kupu ki a rātou; e kino ana hoki te ao ki a rātou, nō te mea ehara rātou i te ao, me ahau hoki ehara i te ao. ");
INSERT INTO mri_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kāhore āku īnoi kia tango­hia atu rātou e koe i te ao, engari, kia tiaki­na rātou e koe kei kino. ");
INSERT INTO mri_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ehara rātou i te ao, me ahau hoki ehara i te ao. ");
INSERT INTO mri_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Whaka­tapua rātou e koe i runga i tōu pono; ko tāu kupu te pono. ");
INSERT INTO mri_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nāu ahau i tono mai ki te ao, he pēnā anō tāku tono i a rātou ki te ao. ");
INSERT INTO mri_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","He whaka­aro hoki ki a rātou i whaka­tapu ai ahau i ahau, kia tapu ai hoki rātou i te pono. ");
INSERT INTO mri_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ehara tāku i te īnoi mō ēnei anake, engari, mō te hunga e meinga e tā rātou kupu kia whaka­pono ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kia kotahi ai rātou katoa; me koe hoki, e Pā, i roto i ahau, me ahau anō i roto i a koe, kia kotahi ai hoki rātou i roto i a tāua; kia whaka­pono ai te ao, nāu ahau i tono mai. ");
INSERT INTO mri_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kua hoatu anō e ahau ki a rātou te korōria i hōmai e koe ki ahau; kia kotahi ai rātou, me tāua nei hoki he kotahi. ");
INSERT INTO mri_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ko ahau i roto i a rātou, ko koe hoki i roto i ahau, kia tino tutuki ai rātou ki te kotahi­tanga; kia mōhio ai anō te ao, nāu ahau i tono mai, he rite hoki tōu aroha ki a rātou ki tōu aroha ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“E Pā, e mea ana ahau kia noho tahi ki ahau, ki te wāhi e noho ai ahau, āu i hōmai ai ki ahau; kia kite ai rātou i tōku korōria kua hōmai nei e koe ki ahau; nō mua atu hoki i te hanga­nga o te ao tōu aroha ki ahau. ");
INSERT INTO mri_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","E te Matua tika, ahakoa te ao tē mōhio ki a koe, e mōhio ana ahau ki a koe, ā, kua mōhio anō ēnei, nāu ahau i tono mai. ");
INSERT INTO mri_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kua whaka­pua­kina anō tōu ingoa e ahau ki a rātou, ā, ka whaka­pua­kina anō; kia mau ai i roto i a rātou te aroha i aroha­ina ai ahau e koe, me ahau anō i roto i a rātou.” ");
INSERT INTO mri_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ka mutu ēnei kōrero a Īhu ka haere ia, rātou ko āna ākonga, ki tāwāhi o te manga wai, arā o Kerono. Nā, he kāri kei reira, ā, tapoko atu ana ia, rātou ko āna ākonga. ");
INSERT INTO mri_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","I mātau­ria anō taua wāhi e Hūrā, e te tangata e tukua ai ia; he maha hoki ngā hoki­nga o Īhu, rātou ko āna ākonga ki reira. ");
INSERT INTO mri_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nā, ka hoatu ki a Hūrā tētahi mātua me ētahi kātipa e ngā tohu­nga nui rātou ko ngā Parihi, ā, haere ana ki reira, me ngā rohe­rohe, me ngā rama, me ngā patu. ");
INSERT INTO mri_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Heoi, i mātau a Īhu ki ngā mea katoa meāke pā ki a ia, ka puta atu, ka mea ki a rātou, “Ko wai tā koutou e rapu?” ");
INSERT INTO mri_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ka whaka­hokia e rātou ki a ia, “Ko Īhu o Nahareta.” Ka mea a Īhu ki a rātou, “Ko ahau ia.” Ā, i te tū anō i roto i a rātou a Hūrā, tōna kai­tuku. ");
INSERT INTO mri_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nā, i tāna kōrero­tanga ki a rātou, “Ko ahau ia,” hoki ana rātou ki muri, hinga ana ki te whenua. ");
INSERT INTO mri_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nā, ka ui anō ia ki a rātou, “Ko wai tā koutou e rapu?” Ka mea rātou, “Ko Īhu o Nahareta.” ");
INSERT INTO mri_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ka whaka­hokia e Īhu, “Kua mea ahau ki a koutou, ‘Ko ahau ia’, ki te mea e rapu ana koutou i ahau, tukua ēnei kia haere.” ");
INSERT INTO mri_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Kia rite ai te kupu i kōrero­tia e ia: “Kāhore i ngaro tētahi o te hunga i hōmai e koe ki ahau.”) ");
INSERT INTO mri_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nā, he hoari tā Haimona Pita, unuhia ana e ia, ā, hāua iho te pono­nga a te tohu­nga nui, tapa­hia ana tōna tari­nga matau. Ko te ingoa o taua pono­nga ko Maraku. ");
INSERT INTO mri_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ka mea a Īhu ki a Pita, “Kuhua tāu hoari ki te takoto­ranga. Ko te kapu i hōmai nei e tōku Matua ki ahau auaka rānei e inumia e ahau?” ");
INSERT INTO mri_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Heoi, ka hopu­kina a Īhu e taua ope, e te ranga­tira rātou ko ngā kātipa o ngā Hūrai, ā, hereherea ana ia. ");
INSERT INTO mri_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ā, ka āra­hina ki a Anaha i te tua­tahi; ko ia hoki te hunga­wai o Kaiapa, o te tohu­nga nui mō taua tau. ");
INSERT INTO mri_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nā, ko Kaiapa tēnei nāna rā i whaka­takoto te whaka­aro ki ngā Hūrai, he pai kē ki te mate te tangata kotahi mō te iwi. ");
INSERT INTO mri_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nā, ka aru a Haimona Pita i a Īhu, ā, ka aru anō hoki tētahi atu o ngā ākonga; nā, i mōhio­tia taua ākonga e te tohu­nga nui, ā, tomo tahi ana me Īhu ki te whare o te tohu­nga nui; ");
INSERT INTO mri_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ko Pita ia i tū i te kūwaha i waho. Nā, ka puta atu taua ākonga i mōhio­tia nei e te tohu­nga nui, ka kōrero ki te kai­tiaki o te tatau, ā, āra­hina ana a Pita ki roto. ");
INSERT INTO mri_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nā, ko te mea­tanga a te kōtiro tiaki o te tatau ki a Pita, “Ehara ianei koe i tētahi o ngā ākonga a tēnei tangata?” Ka mea ia, “Ehara!” ");
INSERT INTO mri_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nā, i reira ngā pono­nga me ngā kātipa e tū ana, kua whaka­ūngia hoki e rātou te kāpura waro; he maka­riri hoki; ā, e ina­ina ana rātou. Ko Pita hoki tētahi o rātou, e tū tahi ana e ina­ina ana. ");
INSERT INTO mri_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nā, ka ui te tohu­nga nui ki a Īhu, ki āna ākonga, ki tāna ako. ");
INSERT INTO mri_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ka whaka­hokia e Īhu ki a ia, “I mārama tonu tāku kōrero ki te ao; i ako tonu ahau i roto i te whare kara­kia, i te teme­para hoki, i te wāhi hui­hui o ngā Hūrai katoa; kāhore hoki tētahi mea i kōrero­tia puku­tia e ahau. ");
INSERT INTO mri_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","He aha koe ka ui ai ki ahau? Ui atu ki te hunga i rongo ki tāku i mea ai ki a rātou; Nana, e mōhio ana rātou ki āku i kōrero ai.” ");
INSERT INTO mri_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nā, i tāna kōrero­tanga i ēnei kupu, ka papaki tētahi o ngā kātipa i tū rā i a Īhu, ka mea, “E pēnā ana koe ki te tohu­nga nui?” ");
INSERT INTO mri_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ka whaka­hokia e Īhu ki a ia, “Ki te kino āku kōrero, whaka­atu­ria te kino. Ki te pai ia, he aha koe i papaki ai i ahau?” ");
INSERT INTO mri_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nā, ka tukua here­here­tia atu ia e Anaha ki a Kaiapa tohu­nga nui. ");
INSERT INTO mri_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nā, tērā a Haimona Pita te tū rā me te ina­ina. Nā, ka mea rātou ki a ia, “Ehara ianei koe i tētahi o āna ākonga?” Ka whaka­kāhore ia, ka mea, “Ehara!” ");
INSERT INTO mri_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ka mea tētahi o ngā pono­nga a te tohu­nga nui, he whanau­nga nōna i tapa­hia nei te tari­nga e Pita, “Kīhai ianei ahau i kite i a koe, kōrua tahi i te kāri?” ");
INSERT INTO mri_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nā, ka whaka­kāhore anō a Pita; ā, tangi tonu iho te tī­kao­kao. ");
INSERT INTO mri_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kātahi, ka āra­hina atu e rātou a Īhu i a Kaiapa ki te whare whaka­wā. He atatū. Ko rātou ia kīhai i tomo ki te whare whaka­wā, kei poke rātou, engari, kia kai ai rātou i te Kape­nga. ");
INSERT INTO mri_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nā, ka puta atu a Pirato ki a rātou, ka mea, “He aha tā koutou whaka­pae ki tēnei tangata?” ");
INSERT INTO mri_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ka whaka­hoki rātou, ka mea ki a ia, “Me i kaua ia te mahi i te kino, kīhai i kawea mai e mātou ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nā, ko te mea­tanga a Pirato ki a rātou, “Mauria atu ia, whaka­wā­kia ki tō koutou nā ture.” Ka mea ngā Hūrai ki a ia, “E kore e tika kia whaka­matea tētahi tangata e mātou.” ");
INSERT INTO mri_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kia rite ai tā Īhu kupu i kōrero ai, hei whaka­atu i te mate e mate ai ia. ");
INSERT INTO mri_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Me i reira ka tomo anō a Pirato ki te whare whaka­wā, ka karanga i a Īhu, ka mea ki a ia, “Ko te Kīngi rānei koe o ngā Hūrai?” ");
INSERT INTO mri_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ka whaka­hokia e Īhu ki a ia, “Nāu ake anō tēnei kupu, he kōrero rānei mōku nā te tangata kē ki a koe?” ");
INSERT INTO mri_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ka mea a Pirato, “He Hūrai koia ahau? Nā tōu iwi, nā ngā tohu­nga nui anō hoki, koe i kawe mai ki ahau; i aha koia koe?” ");
INSERT INTO mri_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ka whaka­hokia e Īhu, “Ehara tōku ranga­tira­tanga i tēnei ao; me­he­mea nō tēnei ao tōku ranga­tira­tanga, kua tatau āku pono­nga, kei tukua ahau ki ngā Hūrai. Tēnā ko tēnei ehara tōku ranga­tira­tanga i konei.” ");
INSERT INTO mri_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nā, ka mea a Pirato ki a ia, “He kīngi oti koe?” Ka whaka­hokia e Īhu, “Kua kōrero­tia mai nā e koe he kīngi ahau. Ko te mea tēnei i whānau ai ahau; nā, tēnei hoki ahau i haere mai ai ki te ao, hei kai­whaka­atu mō te pono. E whaka­rongo ana ki tōku reo ngā tāngata katoa o te pono.” ");
INSERT INTO mri_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ka mea a Pirato ki a ia, “He aha te pono?” Ā, nō te pua­kanga o tēnei kī, hoki ana ia ki waho, ki ngā Hūrai, ka mea ki a rātou, “Kāhore tētahi hē o tēnei tangata i mau i ahau. ");
INSERT INTO mri_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Otiia, he rite­nga tēnei nā koutou, kia tukua e ahau ki a koutou tētahi tangata i te Kape­nga. E pai ana rānei koutou kia tukua e ahau ki a koutou te Kīngi o ngā Hūrai?” ");
INSERT INTO mri_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Heoi, karanga katoa ana anō rātou, ka mea, “Auaka tēnei, engari a Parapa.” Nā, he tāhae a Parapa. ");
INSERT INTO mri_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kātahi, ka mau a Pirato ki a Īhu, ka whiu i a ia. ");
INSERT INTO mri_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ā, ka whiria e ngā hōia he karauna tā­tarā­moa, pōtaea ana ki tōna māte­nga, whaka­kākahu­ria ana hoki ia ki te kahu pāpura. ");
INSERT INTO mri_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nā, ka mea rātou, “Tēnā koe, e te Kīngi o ngā Hūrai!” Ā, pākia ana ia ki ō rātou ringa. ");
INSERT INTO mri_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ka haere anō a Pirato, ka mea ki a rātou, “Nā, tēnei te āra­hina atu nei ia e ahau ki a koutou, kia mōhio ai koutou, kāhore rawa i mau i ahau tētahi hē ōna.” ");
INSERT INTO mri_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nā, ka puta a Īhu ki waho, me te karauna tā­tarā­moa i runga i a ia, me te kākahu pāpura. Ka mea a Pirato ki a rātou, “Nā, te tangata nei!” ");
INSERT INTO mri_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ā, nō te kite­nga o ngā tohu­nga nui rātou ko ngā kātipa i a ia, ka karanga rātou, ka mea, “Rīpekatia, rīpeka­tia.” Ka kī a Pirato ki a rātou, “Tango­hia atu ia e koutou, rīpeka­tia; kāhore hoki i mau i ahau tētahi hē ōna.” ");
INSERT INTO mri_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ka whaka­hokia e ngā Hūrai ki a ia, “He ture tō mātou, ā, ki tō mātou ture he mea tika kia mate ia, mōna i mea ko te Tama ia a te Atua.” ");
INSERT INTO mri_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nō te rongo­nga o Pirato i tēnei kī, nui rawa tōna wehi; ");
INSERT INTO mri_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ka tomo anō ia ki te whare whaka­wā, ka mea ki a Īhu, “Nō hea koe?” Heoi, kāhore a Īhu kupu whaka­hoki ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nā, ka mea a Pirato ki a ia, “E kore koe e kōrero ki ahau? Kāhore koe e mōhio kei ahau te tikanga mō te rīpeka i a koe, kei ahau anō te tikanga mō te tuku i a koe kia haere?” ");
INSERT INTO mri_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ka whaka­hokia e Īhu, “Kāhore āu tikanga ki ahau, me kāhore i hōmai ki a koe i runga. Koia i nui rawa ai te hara o te kai­tuku i ahau ki a koe.” ");
INSERT INTO mri_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nā, i reira anō ka whai a Pirato kia tukua ia kia haere; otiia, ka karanga ngā Hūrai, ka mea, “Ki te tukua tēnei e koe, ehara koe i te hoa nō Hīhā. Ki te whaka­kīngi tētahi tangata i a ia, he whaka­kāhore tāna i a Hīhā.” ");
INSERT INTO mri_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ā, nō ka rongo a Pirato i tēnei kōrero, ka āra­hina e ia a Īhu ki waho, ā, noho ana ki runga ki te nohoa­nga whaka­wā, ki te wāhi e kīa nei ko te Whā­riki Kōhatu, ki te reo Hiperu, ko Kapata. ");
INSERT INTO mri_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ko te taka­nga ia o te Kape­nga, i tata pū ki te ono o ngā hāora. Ka mea ia ki ngā Hūrai, “Nā, tō koutou Kīngi!” ");
INSERT INTO mri_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nā, ko tā rātou karanga­tanga, “Whaka­matea, whaka­matea, rīpeka­tia!” Ka mea a Pirato ki a rātou, “Kia rīpeka koia ahau i tō koutou Kīngi?” Ka whaka­hokia e ngā tohu­nga nui, “Kāhore ō mātou kīngi, ko Hīhā anake.” ");
INSERT INTO mri_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nō reira, ka hoatu ia e ia ki a rātou kia rīpeka­tia. Ā, ka mau rātou ki a Īhu. ");
INSERT INTO mri_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ā, amo ana ia i tōna rīpeka, haere ana ki te wāhi e kīa nei ko te wāhi o te anga­anga, tōna ingoa ki te reo Hiperu, ko “Korokota.” ");
INSERT INTO mri_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nā, rīpeka­tia ana ia e rātou ki reira, ā, ia me ētahi atu toko­rua, kotahi ki tētahi taha, kotahi ki tētahi taha, ko Īhu ki waenga­nui. ");
INSERT INTO mri_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nā, tuhi­tuhia ana e Pirato tētahi ingoa, whaka­piri­tia ana ki te rīpeka. Ko te tuhi­tuhi tēnei, “Ko Īhu o Nahareta ko te Kīngi o ngā Hūrai.” ");
INSERT INTO mri_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ā, he toko­maha ngā Hūrai i kite i tēnei ingoa; i tata hoki ki te pā te wāhi i rīpeka­tia ai a Īhu; ā, i tuhi­tuhia taua mea ki te reo Hiperu, ki te reo Kariki, ki te reo Roma. ");
INSERT INTO mri_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nā, ka mea ngā tohu­nga nui o ngā Hūrai ki a Pirato, “Aua e tuhi­tuhia, ‘Ko te Kīngi o ngā Hūrai,’ engari, ‘Nāna i mea, Ko te Kīngi ahau o ngā Hūrai.’ ” ");
INSERT INTO mri_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ka whaka­hokia e Pirato, “Ko tāku i tuhi­tuhi ai kua tuhi­tuhia.” ");
INSERT INTO mri_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ā, ka oti a Īhu te rīpeka e ngā hōia, ka mau rātou ki ōna kākahu, wehea ake kia whā ngā wāhi, ki ia hōia he wāhi; me te koti anō. Nā, kāhore he tui o te koti, he mea whatu iho i runga ā puta noa. ");
INSERT INTO mri_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nā, ka mea rātou tētahi ki tētahi, “Kaua e haea e tātou, engari, me maka ki te rota kia kitea ai, mō wai rānei.” Nā, ka rite te karaipi­ture e mea nei: “I wehe­wehea ōku kākahu mō rātou, i maka rota hoki mō tōku weru­weru.” Ko tā ngā hōia tēnei i mea ai. ");
INSERT INTO mri_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nā, i te taha o te rīpeka o Īhu tōna whaea e tū ana, rātou ko te teina o tōna whaea, ko Meri wahine a Kereopa, ko Meri Makarini. ");
INSERT INTO mri_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ā, nō te kite­nga o Īhu i tōna whaea, i te ākonga hoki i aroha ai ia e tū tahi ana, ka mea ia ki tōna whaea, “E tai, Nana, tāu tama!” ");
INSERT INTO mri_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kātahi, ia ka mea ki taua ākonga, “Nā, tōu whaea!” Ā, nō taua hāora ka mau taua ākonga i a ia ki tōna whare. ");
INSERT INTO mri_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Muri iho i tēnei ka mōhio a Īhu ka oti ngā mea katoa, nā, ka mea ia, hei whaka­rite­nga mō te karaipi­ture, “He mate­wai tōku.” ");
INSERT INTO mri_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nā, tērā e tū rā tētahi oko, kī tonu i te winika; ā, ka whaka­kīa e rātou tētahi hau­tai ki te winika, whaka­noho­ia ana ki runga ki te hihopa, hoatu ana ki tōna māngai. ");
INSERT INTO mri_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ā, nō te inu­manga o Īhu i te winika, ka mea ia, “Kua oti.” Nā, ka tuohu tōna māte­nga, tukua ana tōna wairua. ");
INSERT INTO mri_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nā, i mea ngā Hūrai kia kaua e mau ngā tinana ki te rīpeka i te hāpati, ko te Taka­nga hoki tērā, he rā nui hoki taua hāpati, ka mea rātou ki a Pirato kia whatia ō rātou wae­wae, kia tango­hia atu hoki. ");
INSERT INTO mri_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nā, ka haere ngā hōia, ka whawhati i ngā wae­wae o tō mua, me o tērā i rīpeka­tia ngā­tahi­tia me ia. ");
INSERT INTO mri_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","I tō rātou taenga ia ki a Īhu, ka kite kua mate noa ake ia, kīhai i whatia e rātou ōna wae­wae. ");
INSERT INTO mri_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Engari, i wero­hia tōna kao­kao e tētahi o ngā hōia ki te mātia, ā, puta tonu he toto, he wai. ");
INSERT INTO mri_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ā, ko te tangata i kite, ko ia anō te kai­whaka­atu, ā, he pono tāna whaka­atu; e mōhio ana ia he kōrero pono tāna, he mea rā kia whaka­pono ai koutou. ");
INSERT INTO mri_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","I meatia hoki ēnei mea, kia rite ai te karaipi­ture, “E kore tētahi iwi ōna e whatia.” ");
INSERT INTO mri_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","E mea ana anō tētahi atu karaipi­ture, “Ka ti­tiro rātou ki tā rātou i wero ai.” ");
INSERT INTO mri_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Muri iho i ēnei mea, ka īnoi a Hōhepa o Arimatia ki a Pirato kia tango­hia e ia te tinana o Īhu. (He ākonga ia nā Īhu, otiia, he mea huna i te wehi ki ngā Hūrai.) Ā, whaka­ae ana a Pirato. Nō, ka haere ia, ka tango i te tinana o Īhu. ");
INSERT INTO mri_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","I haere mai anō a Nikorima, tērā i haere rā i mua ki a Īhu i te pō, me te mau mai anō i te maira, i te aroe, he mea whaka­nanu, kia kotahi pea rau pāuna. ");
INSERT INTO mri_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nā, ka tango rāua i te tinana o Īhu, takaia ana ki ngā kākahu rīnena me ngā mea kakara, ko tā ngā Hūrai rite­nga hoki tērā mō te tanu. ");
INSERT INTO mri_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nā, he kāri kei te wāhi i rīpeka­tia ai ia; i roto anō i taua kāri tētahi urupā hou, he mea kāhore anō i takoto­ria noatia e tētahi. ");
INSERT INTO mri_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nā, ka whaka­takoto­ria a Īhu e rāua ki reira, nō te mea he rā Taka­nga tērā nō ngā Hūrai; he tata hoki te urupā. ");
INSERT INTO mri_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","I te rā tua­tahi o te wiki ka haere a Meri Makarini ki te urupā i te atatū, i te mea e pōuri tonu ana, ā, ka kite i te kōhatu kua tango­hia atu i te urupā. ");
INSERT INTO mri_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nā, ka oma ia, ka haere ki a Haimona Pita rāua ko tērā ākonga i aroha ai a Īhu, ka mea ki a rāua, “Kua tango­hia e rātou te Ariki i te urupā, ā, kāhore mātou e mōhio ki te wāhi i waiho ai ia e rātou.” ");
INSERT INTO mri_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nā, ka puta atu a Pita, me taua ākonga, ka haere ki te urupā. ");
INSERT INTO mri_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ā, oma ngā­tahi ana rāua; otiia, i hohoro tērā ākonga i a Pita, ko ia anō kua tae wawe ki te urupā. ");
INSERT INTO mri_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nā, piko iho ana ia, ka kite i ngā tākai rīnena e takoto ana; heoi, kīhai i tomo ki roto. ");
INSERT INTO mri_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nā, ka haere anō a Haimona Pita i muri i a ia, ā, ko tōna tomo­kanga ki te urupā, ka kite i ngā tākai rīnena e takoto ana. ");
INSERT INTO mri_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Me te tauera i takaia ai tōna māte­nga, kīhai i takoto tahi me ngā tākai rīnena, he mea whaka­kopa ia ki tētahi wāhi i tahaki. ");
INSERT INTO mri_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kātahi, ka tomo tērā ākonga, i tae wawe nei ki te urupā, kite ana, whaka­pono ana. ");
INSERT INTO mri_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Kīanō hoki rātou i mōhio noa ki te karaipi­ture, kua takoto te tikanga kia ara ake ia i te hunga mate.) ");
INSERT INTO mri_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nā, hoki ana anō ngā ākonga ki tō rāua kāinga. ");
INSERT INTO mri_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ko Meri ia tū tonu i waho o te urupā tangi ai. Ā, i a ia e tangi ana, ka piko iho ki te urupā. ");
INSERT INTO mri_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ka kite i ngā ana­hera toko­rua, he mā ngā kākahu, e noho ana, ko tētahi ki te māte­nga, ko tētahi ki ngā wae­wae, i te wāhi i takoto ai te tinana o Īhu. ");
INSERT INTO mri_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ka mea rāua ki a ia, “E tai, he aha tāu e tangi?” Ka mea ia ki a rāua, “Kua tango­hia e rātou tōku Ariki, e kore hoki ahau e mātau ki te wāhi i whaka­takoto­ria ai ia.” ");
INSERT INTO mri_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ka pēnei āna kōrero, ka tahuri whaka­muri, ka kite i a Īhu e tū ana, otiia, kīhai i mōhio ko Īhu ia. ");
INSERT INTO mri_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ka mea a Īhu ki a ia, “E tai, he aha tāu e tangi? Ko wai tāu e rapu?” Hua noa ia ko te kai­ngaki kāri, nā, ko tāna mea­tanga ki a ia, “E mara, ki te mea kua mauria atu ia e koe, kōrero­tia ki ahau te wāhi i whaka­takoto­ria ai ia, ā, māku ia e tango atu.” ");
INSERT INTO mri_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ka mea a Īhu ki a ia, “E Meri!” Ka tahuri atu tērā, ka mea ki a ia, “E Rāponi!” Ko te tikanga tēnei, “E te Kai­whaka­ako.” ");
INSERT INTO mri_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ka mea a Īhu ki a ia, “Kei pā ki ahau; kīanō hoki ahau i kake noa ki tōku Matua. Engari, haere ki ōku tēina, ka mea atu ki a rātou, ‘Ka kake ahau ki tōku Matua, ki tō koutou Matua; ki tōku Atua, ki tō koutou Atua.’ ” ");
INSERT INTO mri_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Haere ana a Meri Makarini, kōrero ana ki ngā ākonga, “Kua kite ia i te Ariki!” Kua kōrero­tia hoki e ia ēnei mea ki a ia. ");
INSERT INTO mri_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","I taua rā tua­tahi anō o te wiki, i te ahi­ahi, i ngā tatau e kati ana o te wāhi i hui­hui ai ngā ākonga i te wehi i ngā Hūrai, ka haere mai a Īhu, ka tū i waenga­nui, ka mea ki a rātou, “Kia tau te rangi­mārie ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ā, ka puaki tēnei kupu āna, ka whaka­kitea e ia ōna ringa me tōna kao­kao ki a rātou. Nā, hari tonu ngā ākonga, i tō rātou kite­nga i te Ariki. ");
INSERT INTO mri_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ka mea anō a Īhu ki a rātou, “Kia tau te rangi­mārie ki a koutou. I tonoa mai ahau e te Matua, ka pērā anō tāku tono i a koutou.” ");
INSERT INTO mri_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ka kōrero­tia tēnei e ia, ka whaka­hā ia, ka mea ki a rātou, “Kia riro te Wairua Tapu i a koutou. ");
INSERT INTO mri_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ki te whaka­rērea noatia e koutou ngā hara o ētahi, ka whaka­rērea o rātou; ki te whaka­maua anō o ētahi e koutou, ka mau anō.” ");
INSERT INTO mri_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ko Tamati ia, ko tētahi o te tekau mā rua, tētahi o ōna ingoa ko Ririmu, kāhore i a rātou i te taenga mai o Īhu. ");
INSERT INTO mri_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ā, ko te mea­tanga a ērā ākonga ki a ia, “Kua kite mātou i te Ariki!” Ka mea ia ki a rātou, “Ki te kāhore ahau e kite i te ngau­nga o ngā whao i ōna ringa, e kuhu i tōku mati­hao ki te ngau­nga a ngā whao, e kuhu hoki i tōku ringa ki tōna kao­kao, e kore ahau e whaka­pono.” ");
INSERT INTO mri_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ā, ka pahemo ngā rā e waru, nā, kei roto anō āna ākonga, rātou ko Tamati. Ka haere mai a Īhu i te mea e kati ana ngā tatau, ka tū ki waenga­nui, ka mea, “Kia tau te rangi­mārie ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kātahi ia ka mea ki a Tamati, “Totoro mai tōu mati­hao, kia kite hoki koe i ōku ringa. Totoro mai hoki tōu ringa, ka kuhu ki tōku kao­kao. Aua e whaka­teka, engari, me whaka­pono.” ");
INSERT INTO mri_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nā, ka whaka­hoki a Tamati, ka mea ki a ia, “E tōku Ariki, e tōku Atua!” ");
INSERT INTO mri_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ka mea a Īhu ki a ia, “Nō tōu kite­nga i ahau, i whaka­pono ai koe, e Tamati. Ka koa te hunga kāhore i kite, ā, kua whaka­pono.” ");
INSERT INTO mri_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","He maha anō ērā atu tohu i oti i a Īhu, i te aro­aro o āna ākonga, kāhore nei i tuhi­tuhia ki tēnei puka­puka. ");
INSERT INTO mri_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Otiia, kua tuhi­tuhia ēnei, kia whaka­pono ai koutou ko te Karaiti a Īhu, ko te Tama a te Atua; kia whi­whi ai hoki ki te ora i runga i tōna ingoa, ina whaka­pono. ");
INSERT INTO mri_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Muri iho i ēnei mea ka whaka­kite a Īhu i a ia ki ngā ākonga i te moana o Tai­piria; ko tāna whaka­kite­nga tēnei. ");
INSERT INTO mri_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","E noho tahi ana a Haimona Pita, a Tamati, ko Ririmu nei tōna ingoa, a Natanahira o Kana o Kariri, ngā tama a Heperi, me tētahi toko­rua atu anō o āna ākonga. ");
INSERT INTO mri_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ka mea a Haimona Pita ki a rātou, “Ka haere ahau ki te hao.” Ka mea rātou ki a ia, “Ko tātou tahi e haere.” Haere ana rātou, eke ana ki runga ki te kai­puke; ā, i taua pō kīhai i mau tētahi mea. ");
INSERT INTO mri_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nā, ka pūao te ata, ko Īhu e tū ana i tātahi; otiia, kīhai ngā ākonga i mōhio ko Īhu ia. ");
INSERT INTO mri_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nā, ko te mea­tanga a Īhu ki a rātou, “E tama mā, kāhore ā koutou kai?” Ka whaka­hokia e rātou ki a ia, “Kāhore.” ");
INSERT INTO mri_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ka mea ia ki a rātou, “Makā te kupe­nga ki te taha matau o te kai­puke, ā, ka mau ētahi.” Nā, i tā rātou maka­nga atu, kīhai i taea te kukume i te tini o ngā ika. ");
INSERT INTO mri_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kātahi, ka mea te ākonga i aroha­ina e Īhu ki a Pita, “Ko te Ariki!” Ā, nō te rongo­nga o Haimona Pita, ko te Ariki, ka whī­tiki­ria tōna kākahu, e tū kau ana hoki ia, ā, rere ana ki te moana. ");
INSERT INTO mri_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ko ērā ākonga ia i hoe i runga i te poti, kīhai hoki i mamao atu i te whenua, me te mea e rua rau whatīa­nga, e kukume ana i te kupe­nga, i ngā ika. ");
INSERT INTO mri_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Heoi, nō tō rātou ūnga ki uta, ka kite i te kāpura waro me ngā ika e takoto ana i runga, me tētahi taro. ");
INSERT INTO mri_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ka mea a Īhu ki a rātou, “Hōmai ētahi o ngā ika kua mau nā i a koutou.” ");
INSERT INTO mri_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nā, haere ana a Haimona Pita, ā, kūmea ana e ia te kupe­nga ki uta, kī tonu i ngā ika nunui, kotahi rau e rima tekau mā toru; ā, ahakoa tini, kīhai i pakaru te kupe­nga. ");
INSERT INTO mri_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ka mea a Īhu ki a rātou, “Haere mai ki te kai.” Heoi, kīhai tētahi o ngā ākonga i māia ki te ui ki a ia, “Ko wai koe?” I mōhio hoki ko te Ariki. ");
INSERT INTO mri_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nā, ka haere a Īhu, ka mau ki te taro, ā, hoatu ana e ia ki a rātou, me ngā ika. ");
INSERT INTO mri_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ko te toru tēnei o ngā pu­tanga o Īhu ki āna ākonga, i muri i tōna aranga ake i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ā, ka mutu tā rātou kai, ka mea a Īhu ki a Haimona Pita, “E Haimona, tama a Hona, rahi atu rānei tōu aroha ki ahau i tō ēnei?” Ka mea tērā ki a ia, “Āe, e te Ariki; e mōhio ana koe e aroha ana ahau ki a koe.” Ka mea ia ki a ia, “Whāngai­nga āku reme.” ");
INSERT INTO mri_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ka mea anō ia ki a ia, ko te rua o ngā mea­tanga, “E Haimona, tama a Hona, e aroha ana koe ki ahau?” Ka mea tērā ki a ia, “Āe, e te Ariki; e mōhio ana koe e aroha ana ahau ki a koe.” Ka mea ia ki a ia, “Hēpara­tia āku hipi.” ");
INSERT INTO mri_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ka mea ia ki a ia, ko te toru o ngā mea­tanga, “E Haimona, tama a Hona, e aroha ana koe ki ahau?” Ka pōuri a Pita nō te mea ka toru rawa āna mea­tanga ki a ia, “E aroha ana koe ki ahau?” Ka mea anō ki a ia, “E te Ariki, e mōhio ana koe ki ngā mea katoa; e mōhio ana koe e aroha ana ahau ki a koe.” Ka mea a Īhu ki a ia, “Whāngai­nga āku hipi. ");
INSERT INTO mri_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","He pono, he pono tāku e mea nei ki a koe, i tōu tama­riki­tanga, i whī­tiki koe i a koe, i haere ki tāu wāhi i pai ai. Ka koro­heke­tia koe, ka whaka­mārō­tia e koe ōu ringa, he tangata kē hoki māna koe e whī­tiki, e kawe ki te wāhi e kore ai koe e pai.” ");
INSERT INTO mri_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(I kōrero­tia tēnei e ia, hei tohu mō te mate e whaka­korōria ai ia i te Atua.) Ā, ka puaki tēnei kupu ana, ka mea ia ki a ia, “Haere mai i muri i ahau.” ");
INSERT INTO mri_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nō te tahuri­tanga, o Pita, ka kite i te ākonga i aroha ai a Īhu e aru ana; ko tērā hoki i whaka­whiri­naki rā ki tōna uma i te hapa, i mea rā, “E te Ariki, ko wai te kai­tuku mōu?” ");
INSERT INTO mri_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ā, i te kite­nga o Pita i a ia, ka mea ki a Īhu, “E te Ariki, e aha rā tēnei?” ");
INSERT INTO mri_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ka mea a Īhu ki a ia, “Ki te pai ahau kia noho tonu ia kia tae mai rā anō ahau, hei aha māu? Haere mai koe i muri i ahau.” ");
INSERT INTO mri_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Heoi, ka puta atu tēnei kupu ki ngā hoa, e kore taua ākonga e mate. Otiia, kīhai a Īhu i mea ki a ia, “E kore ia e mate”; engari, “Ki te pai ahau kia noho tonu ia kia tae mai rā anō ahau, hei aha māu?” ");
INSERT INTO mri_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ko taua ākonga tēnei e whaka­atu nei i ēnei mea, ko te kai­tuhi­tuhi hoki ia i ēnei mea; e mōhio ana anō mātou e tika ana tāna whaka­atu. ");
INSERT INTO mri_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nā, tērā atu anō tōna tini o ngā mea i mea ai a Īhu me i tuhia katoa­tia, e mea ana ahau, e kore pea te ao nei e whai takoto­ranga mō ngā puka­puka e tuhia.");
INSERT INTO mri_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ko te puka­puka tua­tahi rā he mea tuhi­tuhi nāku, e Tiopira, mō ngā mea katoa i tīmata ai a Īhu te mahi, te ako, ");
INSERT INTO mri_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","taea noatia te rā i tango­hia atu ai ia, i muri i tāna whaka­ako­ranga, arā i tā te Wairua Tapu, ki ngā āpō­toro i whiri­whiria e ia. ");
INSERT INTO mri_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","He maha hoki ngā tohu i whaka­kite ora ai ia i a ia ki a rātou, i muri i tōna whaka­mamae­tanga, e whā tekau hoki ngā rā i kitea ai e rātou, kōrero­tia ai e ia ngā mea o te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ā, i a rātou ka hui­hui tahi me ia, ka whai kupu ia kia kaua rātou e haere atu i Hiruhārama, ā, ka mea, “Engari, kia tāria te mea i kōrero­tia i mua e te Matua, i rongo rā koutou ki ahau. ");
INSERT INTO mri_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","I iri­iri hoki a Hoani ki te wai; ko koutou ia, e kore e maha ake ngā rā, ka iri­iria ki te Wairua Tapu.” ");
INSERT INTO mri_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nō reira, i a rātou ka tāmene, ka ui rātou ki a ia, “E te Ariki, ko te wā ianei tēnei e whaka­hoki ai koe i te ranga­tira­tanga ki a Īharaira?” ");
INSERT INTO mri_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nā, ko tāna mea­tanga ki a rātou, “Ehara mā koutou te mōhio ki ngā tāima, ki ngā wā rānei, kua whaka­ritea e te Matua māna ake te tikanga. ");
INSERT INTO mri_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Otiia, ka riro he kaha i a koutou, ina haere mai te Wairua Tapu ki runga ki a koutou, ā, hei kai­whaka­atu koutou mōku ki Hiruhārama, ki Hūria katoa, ki Hamaria hoki, ā tae noa ki te pito whaka­mutu­nga o te ao.” ");
INSERT INTO mri_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ā, nō ka mutu tāna kōrero i ēnei mea, i a rātou anō e ti­tiro atu ana, ka tango­hia atu ia, ā, nā te kapua i kōpaki atu i ō rātou kanohi. ");
INSERT INTO mri_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ā, i a rātou e ti­tiro mata­tau atu ana ki te rangi, i a ia e haere ana, nā, ko ngā tāngata toko­rua e tū ana i tō rātou taha, he mā ngā kākahu. ");
INSERT INTO mri_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","E mea ana, “E ngā tāngata o Kariri, he aha tā koutou e tū, e mā­taki­taki atu nā ki te rangi? Ko tēnā Īhu kua tango­hia atu nā i a koutou ki te rangi, ka pērā anō tōna haere­nga mai me ia i tiro­hia atu nā e koutou e haere ana ki te rangi.” ");
INSERT INTO mri_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nā, hoki ana rātou ki Hiruhārama i te maunga e huaina nei ko Ōriwa, he wāhi e tata ana ki Hiruhārama, he haere­nga hāpati. ");
INSERT INTO mri_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ā, ka tomo rātou, ka kake ki te rūma i runga, ki te wāhi i noho ai rātou; arā a Pita, a Hēmi, a Hoani, a Anaru, a Piripi, a Tamati, a Patoromu, a Matiu, a Hēmi tama a Arapiu, a Haimona Heroti, a Hūrā te teina o Hēmi. ");
INSERT INTO mri_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ko ēnei katoa kotahi tonu te whaka­aro i ū ai ki te īnoi, ki te kara­kia, me ngā wāhine; me te whaea o Īhu, me Meri; me ōna tēina. ");
INSERT INTO mri_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","I aua rā, ka whaka­tika a Pita i waenga­nui o ngā ākonga; ā, he toko­maha ngā tāngata i hui­hui, kei te kotahi rau e rua tekau; ā, ka mea, ");
INSERT INTO mri_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“E hoa mā, e ōku tēina, i tika anō kia whaka­ritea tēnei karaipi­ture, tā te Wairua Tapu i kōrero­tia rā i mua e te māngai o Rāwiri mō Hūrā, mō te kai­ārahi i te hunga nāna i hopu a Īhu. ");
INSERT INTO mri_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","I hui­huia tahi­tia hoki ia ki a tātou, i a ia anō tētahi wāhi o tēnei mahi.” ");
INSERT INTO mri_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Nā, hokona ana e taua tangata tētahi māra ki te utu o tōna hara; ā, taka tūpou iho, kōara pū i waenga­nui, pakaru katoa ki waho ōna whēkau. ");
INSERT INTO mri_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","I mōhio­tia tēnei e te hunga katoa e noho ana i Hiruhārama; nā reira taua wāhi i huaina ai ki tō tātou reo ko Akērama, arā ko te Māra o te Toto.) ");
INSERT INTO mri_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Kua oti hoki te tuhi­tuhi ki te puka­puka o Ngā Waiata, ‘Kia uru­rua­tia tōna nohoa­nga, kaua hoki tētahi tangata e noho ki reira’, me tēnei: ‘Kia riro tāna mahi tiro­tiro i tētahi atu.’ ");
INSERT INTO mri_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Nō reira, ko ngā tāngata i haere tahi nei tātou, i ngā wā katoa i hāere­ere mai ai, i hāere­ere atu ai te Ariki, a Īhu i roto i a tātou, ");
INSERT INTO mri_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","hei te iri­iri­nga a Hoani tīmata ai, ā tae noa ki te rā i tango­hia atu ai ia i a tātou, me whaka­tū tētahi o ērā hei hoa mō tātou ki te whaka­atu i tōna aranga mai.” ");
INSERT INTO mri_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ā, toko­rua a rātou i whaka­rite ai, ko Hōhepa i huaina nei ko Pāhapa, ko tētahi o ōna ingoa ko Hutuha, rāua ko Matiaha. ");
INSERT INTO mri_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nā, ka īnoi rātou, ka mea, “Ko koe, e te Ariki, e mōhio ana ki ngā ngākau o te katoa, māu e whaka­atu ko wai o tēnei toko­rua tāu i whiri­whiri ai, ");
INSERT INTO mri_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hei tango i te wāhi i tēnei mahi minita, i te tū­ranga āpō­toro hoki, i taka atu a Hūrā, he mea kia haere ai ia ki tōna wāhi.” ");
INSERT INTO mri_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nā, ka makā e rātou ō rāua rota; ā, ka tau te rota ki a Matiaha; ā, uru ana ia ki ngā āpō­toro tekau mā tahi. ");
INSERT INTO mri_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ā, nō ka taka mai te rā o te Petekoha, e noho tahi ana rātou katoa i te wāhi kotahi. ");
INSERT INTO mri_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nā, puta whaka­rere mai ana he haruru nui nō te rangi, ānō he hau nui e keri ana, ā, kī katoa te whare i noho ai rātou. ");
INSERT INTO mri_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Heoi, puta mai ana ki a rātou ētahi arero he mea manga­nga, ānō he ahi, ā, tau iho ana ki runga ki tēnei, ki tēnei o rātou. ");
INSERT INTO mri_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nā, kī katoa rātou i te Wairua Tapu, ā, ka tīmata te kōrero rere­kē ana ngā reo, rite tonu ki tā te Wairua i hoatu ai ki a rātou kia kōrero­tia. ");
INSERT INTO mri_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","I Hiruhārama anō e noho ana ētahi Hūrai, he hunga whaka­aro, nō ngā iwi katoa i raro o te rangi. ");
INSERT INTO mri_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nā, i te wā i rangona ai taua haruru, ka whaka­rā­po­poto te mano, ka poro­raru, nō te mea ka rangona e tērā, e tērā, tōna reo e kōrero­tia ana e rātou. ");
INSERT INTO mri_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nā, ka oho rātou katoa, ka mīharo, ka mea, “Nā, ehara ianei ēnei katoa e kōrero nei i te hunga nō Kariri? ");
INSERT INTO mri_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","He aha tātou ka rongo nei, ia tangata, ia tangata, i ō tātou reo o tō tātou whānau­tanga? ");
INSERT INTO mri_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ko te hunga o Patia, o Meria, o Erama, ko ngā mea e noho ana i Mehopotamia, i Hūria, i Kaparokia, i Ponoto, i Āhia, ");
INSERT INTO mri_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","i Perikia, i Pamapu­ria, i Īhipa, i ngā wāhi o Ripia e pātata ana ki Hairini, me ngā manu­hiri o Roma, ngā Hūrai, ngā poro­hira­iti, ");
INSERT INTO mri_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ngā Kariti, ngā Ārapi, e rongo ana tātou i a rātou e whaka­puaki ana i ngā mahi tohu a te Atua, nō tātou anō ngā reo.” ");
INSERT INTO mri_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ā, mīharo katoa ana rātou, pōhēhē ana, ka mea tētahi ki tētahi, “He aha tēnei?” ");
INSERT INTO mri_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ko ētahi i tāwai, i mea, “E kī ana rātou i te wāina hou!” ");
INSERT INTO mri_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Otirā, ka whaka­tika a Pita me te tekau mā tahi, ka hiki­tia tōna reo, ka whai kupu ki a rātou, “E ngā tāngata o Hūria, me koutou katoa e noho nei i Hiruhārama, kia mōhio koutou ki tēnei, kia whai tari­nga mai ki āku kupu. ");
INSERT INTO mri_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kāhore hoki o ēnei hau­rangi me tā koutou e whaka­aro nei, ko te toru noa hoki tēnei o ngā hāora o te rā. ");
INSERT INTO mri_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Engari, ko te mea tēnei i kōrero­tia e Hoera poro­piti: ");
INSERT INTO mri_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ā, tēnei ake kei ngā rā whaka­mutu­nga, e ai tā te Atua, ka ringi­hia e ahau tōku Wairua ki ngā kiko­kiko katoa; ka poro­piti hoki ā koutou tama, ā koutou tamā­hine, e kite anō ā koutou tai­tama­riki i ngā kite­nga, ka moe­moeā hoki ō koutou kaumātua. ");
INSERT INTO mri_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Āe, ka ringi­hia anō e ahau tōku Wairua i aua rā, ki āku pono­nga tāne, ki āku pono­nga wāhine; ā, ka poro­piti rātou. ");
INSERT INTO mri_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ka whaka­kitea anō e ahau ngā mea whaka­mīharo i te rangi i runga, me ngā tohu ki te whenua i raro; he toto, he kāpura, he paowa po­ngere. ");
INSERT INTO mri_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ko te rā ka huri hei pōuri, ko te marama hoki hei toto, i mua o te pu­tanga mai o te rā o te Ariki, taua rā nui whaka­hara­hara, rongo­nui. ");
INSERT INTO mri_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nā, ko reira ora ai te hunga katoa e karanga ana ki te ingoa o te Ariki.’ ");
INSERT INTO mri_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“E ngā tāngata o Īharaira, kia rongo koutou ki ēnei kupu; Ko Īhu o Nahareta, he tangata i tino whai­tohu­ngia e te Atua ki a koutou i runga i ngā mere­kara, i ngā mea whaka­mīharo, i ngā tohu i mea ai te Atua kia mahia e ia i waenga­nui o koutou, e mōhio ana anō rā koutou. ");
INSERT INTO mri_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ko tēnei tangata i tukua atu, he mea i āta whaka­aroa, ā, i mōhio­tia noatia ake e te Atua, tango­hia ana e koutou, whaka­matea iho, he mea rīpeka nā te ringa o ngā tāngata kino. ");
INSERT INTO mri_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nā te Atua ia i whaka­ara ake, nāna i wewete ngā mamae o te mate; nō te mea e kore ia e taea te pupuri e taua mate. ");
INSERT INTO mri_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ko tā Rāwiri kōrero hoki tēnei mōna: ‘I kite ahau i te Ariki i mua i tōku aro­aro i ngā rā katoa; kei tōku ringa matau nei ia, e kore ai ahau e whaka­kori­koria. ");
INSERT INTO mri_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Koia i koa ai tōku ngākau, i whaka­mana­mana ai tōku arero; i takoto tū­mana­ko ai anō ōku kiko­kiko. ");
INSERT INTO mri_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nō te mea e kore e waiho e koe tōku wairua i te rēinga, e kore anō e tukua tāu Mea Tapu kia kite i te pirau. ");
INSERT INTO mri_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kua whaka­kitea e koe ki ahau ngā hua­rahi o te ora; ka meinga e koe kia kī tonu tōku koa i tōu aro­aro.’ ");
INSERT INTO mri_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“E ōku tēina, e tika ana kia aronui he kupu ki a koutou mō te tupuna nei mō Rāwiri, arā kua mate ia, kua tanu­mia, kei a tātou anō tōna urupā, ā, taea noatia tēnei rā. ");
INSERT INTO mri_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","I te mea he poro­piti ia, ā, i mōhio kua oati te Atua i te oati ki a ia, ka whaka­puta­ina ake tētahi, he hua nō tōna hope, hei noho ki runga ki tōna torōna. ");
INSERT INTO mri_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ā, i tāna kite wawe i tēnei, kōrero­tia ana e ia te aranga o te Karaiti, arā: ‘Kīhai tōna wairua i waiho i te rēinga, kīhai anō tōna kiko­kiko i kite i te pirau.’ ");
INSERT INTO mri_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kua whaka­ara­hia ake tēnei Īhu e te Atua: ko mātou katoa ngā kai­whaka­atu. ");
INSERT INTO mri_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ā, ka oti nei ia te whaka­nui e te ringa matau o te Atua, ā, ka hōmai nei ki a ia e te Matua te Wairua Tapu i kōrero­tia rā i mua, nā, kua ringi­hia mai e ia tēnei, e kite nei, e rongo nei koutou. ");
INSERT INTO mri_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kāhore hoki a Rāwiri i kake ki te rangi; heoi, e mea ana ia: ‘I mea te Ariki ki tōku Ariki, Hei tōku matau koe noho ai, ");
INSERT INTO mri_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kia meinga rā anō e ahau ōu hoa­riri hei tū­ranga wae­wae mōu.’ ");
INSERT INTO mri_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nō reira rā, kia mātau pū te whare katoa o Īharaira, kua meinga e te Atua hei Ariki, hei Karaiti, taua Īhu i rīpeka­tia nā e koutou.” ");
INSERT INTO mri_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nō rātou ka rongo, ka wero­wero i roto i ō rātou ngākau, ka mea ki a Pita rātou ko ērā atu āpō­toro, “E ngā tuā­kana, me aha mātou?” ");
INSERT INTO mri_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nā, ko te mea­tanga a Pita ki a rātou, “Rīpenetā, kia iri­iria, tēnā tangata, tēnā tangata o koutou i runga i te ingoa o Īhu Karaiti, hei muru­nga hara; ā, ka riro i a koutou te mea hōmai, arā te Wairua Tapu. ");
INSERT INTO mri_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ki a koutou hoki, ki ā koutou tama­riki, te kupu hōmai, ki te hunga katoa anō o tawhiti, ki ngā mea e karanga­tia e te Ariki, e tō tātou Atua, ki a ia.” ");
INSERT INTO mri_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","He maha atu anō ngā kupu i kōrero ai, i kauwhau ai ia, i mea ai, “Me whaka­ora koutou i a koutou i tēnei whaka­tupu­ranga parori kē.” ");
INSERT INTO mri_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nā, ko ngā mea tonu i tango i tāna kupu i iri­iria, me te mea e toru mano ngā wairua i honoa mai ki a rātou i taua rā. ");
INSERT INTO mri_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ā, i ū tonu rātou ki te whaka­ako­ranga a ngā āpō­toro, ki te kotahi­tanga, ki te whawhati taro, ā, ki te īnoi. ");
INSERT INTO mri_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tau iho ana te wehi ki ngā wairua katoa; he maha hoki ngā mea whaka­mīharo me ngā tohu i meinga e ngā āpō­toro. ");
INSERT INTO mri_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","I noho tahi anō te hunga whaka­pono katoa, i hui­huia anō hoki ā rātou mea katoa; ");
INSERT INTO mri_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","i hokona atu hoki ā rātou rawa me ngā taonga, tu­whai­na ana mā te katoa, rite tonu, ki te mate o tēnei, o tēnei. ");
INSERT INTO mri_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Haere tonu ana hoki rātou i tēnei rā, i tēnei rā ki te teme­para, kotahi tonu anō te whaka­aro; whawhati taro ana i ō rātou kāinga, kai ana i ā rātou kai i runga i te koa, i te ngākau tapa­tahi; ");
INSERT INTO mri_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","e whaka­moe­miti ana ki te Atua, e pai­ngia ana hoki e te iwi katoa. Ā, honoa mai ana e te Ariki ki a rātou i tēnā rā, i tēnā rā, i tēnā rā, te hunga e whaka­ora­ngia ana. ");
INSERT INTO mri_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nā, e haere tahi atu ana a Pita rāua ko Hoani ki te teme­para i te hāora īnoi, i te iwa o ngā hāora. ");
INSERT INTO mri_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nā, ka kawea mai tētahi tangata, he kopa nō te kōpū mai anō o tōna whaea, he mea whaka­takoto i ngā rā katoa ki te kūwaha o te teme­para i huaina nei ko Āta­ahua, ki te tono mea māna i te hunga e tomo ana ki te teme­para. ");
INSERT INTO mri_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nō tōna kite­nga i a Pita rāua ko Hoani meāke tomo ki te teme­para, ka tono ia i tētahi mea māna. ");
INSERT INTO mri_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nā, ka whaka­mau atu ngā kanohi o Pita rāua ko Hoani ki a ia, ka mea, “Ti­tiro mai ki a māua.” ");
INSERT INTO mri_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ka whaka­rongo ia ki a rāua, hua noa e riro mai tētahi mea a rāua māna. ");
INSERT INTO mri_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Anō rā ko Pita, “Ko te hiriwa me te kōura kāhore i ahau; ko te mea ia kei ahau, māku tēnā e hoatu ki a koe; i runga i te ingoa o Īhu Karaiti o Nahareta, whaka­tika, haere.” ");
INSERT INTO mri_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kātahi ia ka hopu i tōna ringa matau ka whaka­ara ake i a ia. I reira tonu kua whai kaha ōna wae­wae me ngā pona. ");
INSERT INTO mri_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ā, ko tōna mawhiti­tanga ake, ka tū, ka tīmata te haere, tomo tahi ana me rāua ki te teme­para, e haere ana, tūpeke ana, e whaka­moe­miti ana ki te Atua. ");
INSERT INTO mri_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ā, i kite te iwi katoa i a ia e haere ana, e whaka­moe­miti ana ki te Atua. ");
INSERT INTO mri_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kātahi rātou ka mōhio ki a ia, ko ia anō tērā i noho rā ki te tatau Āta­ahua o te teme­para, tono mea ai māna; nā, nui atu tō rātou mīharo me te ihi­ihi ki taua mea i pā ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","I a ia e pupuri ana ki a Pita rāua ko Hoani, ka oma atu te iwi katoa ki a rātou i te whaka­mahau i huaina nei ko tā Horomona, nui rawa te whaka­mīharo. ");
INSERT INTO mri_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ā, i te kite­nga o Pita, ka whai kupu atu ia ki te iwi, “E ngā tāngata o Īharaira, he aha tā koutou e mīharo nei ki tēnei tangata? He aha hoki koutou ka whaka­mau ai te ti­tiro ki a māua, me te mea he mana nō māua ake he ngākau kara­kia rānei i meatia ai ia kia haere? ");
INSERT INTO mri_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nā te Atua o Āperahama, o Īhaka, o Hākopa, nā te Atua o ō tātou mātua, i whaka­korōria tāna Tama a Īhu; ko tā koutou i tuku nā, i whaka­kāhore nā i te aro­aro o Pirato, kua oti rā i a ia kia tukua ia. ");
INSERT INTO mri_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Otirā, whaka­kāhore­tia ana e koutou te Mea Tapu, te Mea Tika, tonoa ana ko te tangata kōhuru kia hōmai ki a koutou. ");
INSERT INTO mri_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Patua ana hoki e koutou te Take o te Ora; kua whaka­ara­hia nei ia e te Atua i te hunga mate, ko mātou nei ōna kai­whaka­atu. ");
INSERT INTO mri_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ā, nā te whaka­pono ki tōna ingoa i meinga ai e tōna ingoa tēnei tangata kia kaha, e kite nei, e mātau nei koutou; āe rā, ko te whaka­pono ki a ia te mea nāna i hoatu tēnei ora nui ki tēnei i te aro­aro o koutou katoa. ");
INSERT INTO mri_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nā, e ōku tēina, e mahara ana ahau nā te kūware tēnā mahi a koutou, pērā i tā ō koutou ranga­tira. ");
INSERT INTO mri_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Engari, ko ngā mea a te Atua i whaka­kitea i mua e te māngai o ngā poro­piti katoa, mō tāna Karaiti kia whaka­mamae­tia, kua rite ēnei i a ia. ");
INSERT INTO mri_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nō reira, rīpe­netā, ā, tahuri mai anō koutou, kia murua ai ō koutou hara, kia puta mai ai i te aro­aro o te Ariki he wā whaka­hauora. ");
INSERT INTO mri_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ā, kia tonoa mai ai e ia te Karaiti i whaka­ritea nei mō koutou, arā a Īhu. ");
INSERT INTO mri_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kua takoto nei te tikanga kia noho ia ki te rangi ā taea noatia ngā wā o te whaka­hoki­nga mai o ngā mea katoa, i kōrero ai te Atua rā te māngai o āna poro­piti tapu nō te tīma­tanga mai anō o te ao. ");
INSERT INTO mri_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","I mea rā hoki a Mohi, ‘Mā te Ariki, mā te Atua, e whaka­ara ake he poro­piti mō koutou i roto i ō koutou tēina, he pēnei anō me ahau. Ko ia tā koutou e whaka­rongo ai i ngā mea katoa e mea ai ia ki a koutou. ");
INSERT INTO mri_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ā taua wā, ko ngā wairua katoa e kore e whaka­rongo ki taua poro­piti, ka whaka­matea rawa­tia i roto i te iwi.’ ");
INSERT INTO mri_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Āe rā, ko ngā poro­piti katoa o Hamuera iho anō, tae mai ki ō muri nei, ko te hunga katoa i kōrero, i whaka­atu anō hoki rātou i ngā rā nei. ");
INSERT INTO mri_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ko koutou aua tama a ngā poro­piti, a te kawe­nata hoki i whaka­takoto­ria e te Atua ki ō koutou mātua, i mea rā ia ki a Āperahama, ‘Mā tōu uri ka manaaki­tia ai ngā hapū katoa o te ao.’ ");
INSERT INTO mri_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mō koutou kē hoki i te tua­tahi, i tāna whaka­aranga ake ai i tāna Tama, i te tono­nga mai nei a te Atua i a ia ki a koutou hei manaaki i a koutou, hei i whaka­tahuri i tēnei, i tēnei o koutou i ō koutou kino.” ");
INSERT INTO mri_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ā, i a rāua e kōrero ana ki te iwi, ka puta oho­rere mai ki a rāua ngā tohu­nga, te ranga­tira o te teme­para me ngā Haruki ");
INSERT INTO mri_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","he nui te pāwera mō tā rāua ako i te iwi, mō te kauwhau hoki i runga i a Īhu i te aranga mai i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nā, ka mau ō rātou ringa ki a rāua, meinga ana kia tiaki­na kia ao rā anō te rā, i te mea hoki kua ahi­ahi. ");
INSERT INTO mri_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Otirā, he toko­maha o te hunga i rongo i te kupu i whaka­pono, ā, ko te toko­maha o ngā tāngata me te mea e rima mano. ");
INSERT INTO mri_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nā, i te aonga ake ka hui­hui ō rātou ranga­tira, ngā kaumātua, me ngā kara­ipi ki Hiruhārama, ");
INSERT INTO mri_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","rātou ko te tino tohu­nga, ko Anaha, ko Kaiapa, ko Hoani, ko Arēhanara, me ngā whanau­nga katoa o te tohu­nga nui. ");
INSERT INTO mri_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ā, nō ka whaka­tū­ria rāua ki waenga­nui, ka ui rātou, “Tēnā koa te mana, te ingoa rānei, i meatia ai tēnei e kōrua?” ");
INSERT INTO mri_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kātahi a Pita, kī tonu i te Wairua Tapu, ka mea ki a rātou, “E ngā ranga­tira o te iwi, e ngā kaumātua: ");
INSERT INTO mri_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","me­he­mea ki te uiuia māua āia­nei mō te mahi pai i mahia ki te tangata hauā, i pēhea­tia taua tangata i ora ai. ");
INSERT INTO mri_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kia mōhio koutou katoa, me te iwi katoa o Īharaira, nā te ingoa o Īhu Karaiti o Nahareta, i rīpeka­tia nā e koutou, i whaka­ara­hia rā e te Atua i te hunga mate, nāna tēnei i tū ora ai i tō koutou aro­aro. ");
INSERT INTO mri_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ko ia ‘te kōhatu i whaka­kāhore­tia nā e koutou, e ngā kai­hanga, ā, kua meinga nei hei ūpoko mō te koko­nga.’ ");
INSERT INTO mri_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kāhore hoki he ora i tētahi atu; kāhore hoki he ingoa kē atu i raro o te rangi kua hōmai ki ngā tāngata, e ora ai tātou.” ");
INSERT INTO mri_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nā, ka kite rātou i te māia o Pita rāua ko Hoani, ā, ka mātau ki a rāua ehara i te mea whaka­ako, engari, he hunga kūware, ka mīharo rātou; ka mōhio hoki he hoa rāua nō Īhu. ");
INSERT INTO mri_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ka kite hoki i te tangata i whaka­ora­ngia e tū tahi ana rātou, kāhore rawa i taea tētahi kupu whaka­hē mā rātou. ");
INSERT INTO mri_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nā, ka tono rātou i a rāua kia haere ki waho o te rū­nanga, ā, ka kōrero­rero ki a rātou anō, ");
INSERT INTO mri_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ka mea, “Me aha e tātou ēnei tāngata? Ka kite katoa nei hoki te hunga e noho ana i Hiruhārama, he mere­kara nui kua meinga nei, ā, e kore e āhei te whākore­kore e tātou. ");
INSERT INTO mri_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Otiia, kia kaua ai e hōrapa atu ki roto ki te iwi, kia kaha tā tātou whaka­wehi i a rāua kei kōrero ki tētahi tangata ā muri nei i runga i tēnei ingoa.” ");
INSERT INTO mri_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ā, karanga­tia ana rāua e rātou, ka mea ki a rāua “Kia kaua rawa e kōrero, kia kaua e whaka­ako, i runga i te ingoa o Īhu.” ");
INSERT INTO mri_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nā, ka whaka­hoki a Pita rāua ko Hoani ki a rātou, ka mea, “Whaka­aroa e koutou, ka tika rānei ki te aro­aro o te Atua ko koutou kia whaka­rangona, kaua te Atua? ");
INSERT INTO mri_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","E kore hoki e āhei kia kaua e kōrero­tia e māua ngā mea i kite ai, i rongo ai mātou.” ");
INSERT INTO mri_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Heoi, whaka­wehi ana anō rātou i a rāua, ā, tukua ana kia haere, kīhai hoki i kitea he mea e whiua ai rāua, i wehi i te iwi; i whaka­korōria katoa nei ngā tāngata i te Atua mō taua mea i meatia. ");
INSERT INTO mri_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nō te mea kua neke atu i te whā tekau ngā tau o te tangata i meinga nei ki a ia tēnei mere­kara whaka­ora. ");
INSERT INTO mri_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ā, ka oti rāua te tuku, ka haere ki ō rāua hoa, ā, kōrero­tia ana ngā mea katoa i kōrero ai ngā tohu­nga nui me ngā kaumātua ki a rāua. ");
INSERT INTO mri_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ā, i tō rātou rongo­nga, ka karanga ake rātou ki te Atua, he kotahi te reo, ka mea: “E te Ariki, nāu nei i hanga te rangi me te whenua, te moana, me ō reira mea katoa; ");
INSERT INTO mri_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","nāu te kupu i kōrero­tia e te Wairua Tapu, nā te māngai o tō mātou matua, o tāu pono­nga, o Rāwiri: ‘He aha ka nana ai ngā tauiwi, ka whaka­aro hori­hori ai ngā iwi? ");
INSERT INTO mri_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","I whaka­tika ake ngā kīngi o te whenua, i hui­hui ngā­tahi ngā ranga­tira, ki te whawhai ki te Ariki rāua ko tāna Karaiti.’ ");
INSERT INTO mri_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","He pono nei hoki te hui­hui­nga ki tēnei pā o Herora, o Ponotio Pirato, o ngā tauiwi, rātou ko te iwi o Īharaira, ki tāu tama tapu, ki a Īhu i whaka­wahia nei e koe, ");
INSERT INTO mri_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ki te mea i tā tōu ringa, i tā tōu whaka­aro i whaka­takoto ai i mua kia meatia. ");
INSERT INTO mri_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nā, ti­tiro iho, e te Ariki, āia­nei ki ā rātou kupu whaka­wehi. Tukua mai hoki ki au pono­nga kia tino māia te kōrero i tāu kupu. ");
INSERT INTO mri_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ko koe ia e totoro mai ana tōu ringa ki te whaka­ora; kia meatia hoki he tohu, he mea whaka­mīharo i runga i te ingoa o tāu Pono­nga tapu, o Īhu.” ");
INSERT INTO mri_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","I te mutu­nga o tā rātou īnoi, ka ngā­ueue te wāhi i mine ai rātou, ā, kī katoa rātou i te Wairua Tapu, nā, māia noa atu rātou ki te kōrero i te kupu a te Atua. ");
INSERT INTO mri_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kotahi anō ngākau, kotahi anō wairua o te mano o te hunga whaka­pono. Kīhai anō tētahi o rātou i mea, māna ake tētahi o āna taonga; heoi he mea hui­hui ā rātou mea katoa. ");
INSERT INTO mri_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ā, nui atu te kaha i whaka­pua­kina ai e ngā āpō­toro te aranga o te Ariki, o Īhu; he nui anō te aroha noa i runga i a rātou katoa. ");
INSERT INTO mri_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kāhore hoki tētahi o rātou i hapa; ko te hunga hoki he kāinga, he whare ō rātou, hokona atu ana e rātou, ā, mauria ana mai ngā utu o ngā mea i hokona, ");
INSERT INTO mri_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","whaka­takoto­ria ana ki ngā wae­wae o ngā āpō­toro. Nā, ka tu­whai­na mā ia tangata, mā ia tangata, he mea whaka­rite ki te mate o ia tangata. ");
INSERT INTO mri_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ā, ko Hohi i huaina e ngā āpō­toro ko Pānapa, (ko te tikanga tēnei ina whaka­māori­tia, ko te Tama a te Whaka­mārie­tanga,) he Rīwaiti, ko Kai­peru tōna kāinga. ");
INSERT INTO mri_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","He wāhi whenua tōna, nā, hokona atu ana, mauria ana ngā moni, whaka­takoto­ria ana ki ngā wae­wae o ngā āpō­toro. ");
INSERT INTO mri_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nā, ko tētahi tangata ko Anania tōna ingoa, rāua ko tāna wahine, ko Hapaira, i hoko atu i tētahi whenua. ");
INSERT INTO mri_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ā, puri­tia ana e ia tētahi wāhi o te utu, ko tāna wahine hoki i mōhio ki taua mea huna, mauria ana tētahi wāhi, whaka­takoto­ria ana ki ngā wae­wae o ngā āpō­toro. ");
INSERT INTO mri_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nā, ko te mea­tanga atu a Pita, “E Anania, nā te aha i whaka­kīa ai tōu ngākau e Hātana kia teka koe ki te Wairua Tapu, kia puri­tia atu ai tētahi wāhi o te utu o te whenua? ");
INSERT INTO mri_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","I te mea kāhore anō i riro, he teka ianei nāu ake tāu mea? Ā, ka oti te hoko atu he teka ianei kei a koe tonu te tikanga? Nā te aha tēnei mea i whaka­aroa ai i roto i tōu ngākau? Kīhai hoki koe i teka ki te tangata, engari ki te Atua.” ");
INSERT INTO mri_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ā, nō te rongo­nga o Anania i ēnei kupu, hinga ana ki raro, mate rawa. He nui anō te wehi i tau ki te hunga katoa i rongo i ēnei mea. ");
INSERT INTO mri_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nā, ka whaka­tika ngā tai­tama­riki, takai ana i a ia, ā, maua atu ana ia ki waho, tanu­mia ana. ");
INSERT INTO mri_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ā, pātata ki te toru hāora i muri, ka tomo mai tāna wahine, kīhai hoki i mōhio he aha te mea kua meatia. ");
INSERT INTO mri_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nā, ko te mea­tanga a Pita ki a ia, “Kōrero mai ki ahau, ko te utu rānei tērā i hokona atu ai e kōrua te whenua?” Ka mea ia, “Āe, koia tēnā.” ");
INSERT INTO mri_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ka mea a Pita ki a ia, “He aha kōrua i whaka­aro tahi ai ki te whaka­mā­tau­tau i te Wairua o te Ariki? Nana, kei te kūwaha ngā wae­wae o te hunga i tanu­mia ai tāu tāne, mā rātou koe e kawe ki waho.” ");
INSERT INTO mri_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nā, hinga tonu iho ia ki ōna wae­wae, hemo rawa. Ā, ko te tomo­nga mai o ngā tai­tama­riki, roko­hanga mai kua mate, nā kawea ana ia ki waho, tanu­mia ana ki te taha o tāna tāne. ");
INSERT INTO mri_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ā, nui atu te wehi o te hāhi katoa, o te hunga katoa anō i rangona ai ēnei mea. ");
INSERT INTO mri_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ā, nā ngā ringa o ngā āpō­toro i mahi ngā tohu maha, me ngā mea whaka­mīharo, i roto i te iwi; i noho hoki rātou katoa ki te whaka­mahau o Horomona, kotahi anō te whaka­aro. ");
INSERT INTO mri_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tēnā ko ērā atu tāngata kīhai rawa tētahi i māia ki te whaka­uru mai ki a rātou; otirā, whaka­nuia ana rātou e te iwi. ");
INSERT INTO mri_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ā, he nui noa atu te hunga whaka­pono i honoa mai ki te Ariki, tōna tini o te tāne, o te wāhine. ");
INSERT INTO mri_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nā reira hoki, ka mauria e rātou ngā tūroro ki ngā ara, whaka­takoto­ria ana ki runga i ngā moenga, i ngā whā­riki, me kore noa e tau­maru­maru iho ki tētahi o rātou te ātā­rangi o Pita, i a ia e haere ana. ");
INSERT INTO mri_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","I hui katoa mai anō te mano i ngā pā katoa e pātata ana ki Hiruhārama, me te mau mai i ngā tūroro, i te hunga e whaka­pō­rea­rea­tia ana e ngā wairua poke; ā, whaka­ora­ngia ana rātou katoa. ");
INSERT INTO mri_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Me i reira ka whaka­tika te tohu­nga nui rātou ko ōna hoa katoa, arā te wehe­nga ki ngā Haruki, kī tonu hoki rātou i te hae. ");
INSERT INTO mri_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ā, ka pā ō rātou ringa ki ngā āpō­toro, makā ana rātou ki te whare here­here nui. ");
INSERT INTO mri_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Otirā, nā tētahi ana­hera a te Ariki i uaki ngā tatau o te whare here­here i te pō; āra­hina mai ana rātou e ia ki waho, ka mea, ");
INSERT INTO mri_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Haere, e tū i roto i te teme­para, ka kōrero ki te iwi i ngā kupu katoa o tēnei ora.” ");
INSERT INTO mri_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ā, ka rongo rātou i tēnei, ka tomo ki te teme­para i te atatū, ka whaka­ako. Nā, ko te haere­nga o te tohu­nga nui rātou ko ōna hoa, karanga­tia ana kia hui­hui te rū­nanga me ngā kaumātua katoa o ngā tama a Īharaira, ā, tonoa ana he tangata ki te whare here­here hei tiki i a rātou. ");
INSERT INTO mri_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Otirā, ko ngā kātipa i tae mai, kīhai i kite i a rātou i roto i te whare here­here, nā, ka hoki mai, ka kōrero, ");
INSERT INTO mri_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ka mea, “Rokohina atu e mātou e tūtaki tonu ana te whare here­here ū tonu, me ngā kai­tiaki e tū ana i waho o ngā tatau; nō te hua­kanga atu, kāhore he tangata i kitea e mātou i roto.” ");
INSERT INTO mri_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ā, nō ka rongo te ranga­tira o te teme­para rātou ko ngā tohu­nga nui ki ēnei kupu, ka poro­raru rātou, he aha rā te tuku­nga iho o taua mea. ");
INSERT INTO mri_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nā, ko te haere­nga mai o tētahi, ka kōrero ki a rātou, ka mea, “Nana, ko te hunga i makā rā e koutou ki te whare here­here, e tū mai nei i te teme­para, e whaka­ako ana i te iwi!” ");
INSERT INTO mri_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kātahi, ka haere te ranga­tira rātou ko ngā kātipa, ā, āra­hina mai ana rātou, otirā, kīhai i taka­kino­tia; i wehi hoki rātou i te iwi, kei ākina rātou ki te kōhatu. ");
INSERT INTO mri_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ā, ka oti rātou te ārahi mai, ka whaka­tū­ria ki mua i te rū­nanga. Nā, ka ui te tohu­nga nui ki a rātou, ");
INSERT INTO mri_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ka mea, “Kīhai ianei mātou i āta whaka­tūpato i a koutou kia kaua e whaka­ako i runga i tēnei ingoa? Nā, kua kī nei Hiruhārama i tā koutou whaka­ako­ranga, ā, e mea ana koutou kia whaka­iria ngā toto o tēnei tangata ki runga i a mātou.” ");
INSERT INTO mri_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nā, ka whaka­hoki a Pita rātou ko ngā āpō­toro, ka mea, “Me whaka­rongo rā mātou ki te Atua, kaua ki te tangata. ");
INSERT INTO mri_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nā te Atua o ō tātou tūpuna i whaka­ara ake a Īhu, i whaka­matea nā e koutou, he mea whaka­iri ki te rākau. ");
INSERT INTO mri_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kua oti ia te whaka­noho e te ringa matau o te Atua ki runga, hei Piriniha, hei Kai­whaka­ora, hei hōmai i te rīpe­netā, i te muru­nga hara ki a Īharaira. ");
INSERT INTO mri_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ko mātou anō ngā kai­whaka­atu i ēnei mea; ko te Wairua Tapu hoki, i hōmai nei e te Atua ki te hunga e rongo ana ki a ia.” ");
INSERT INTO mri_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Otirā, i tō rātou rongo­nga i tēnei, tū tonu ki ō rātou ngākau, ā, ka whaka­aro kia whaka­matea rātou. ");
INSERT INTO mri_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nā, ka whaka­tika tētahi o ngā Parihi i roto i te rū­nanga, ko Kamariera te ingoa, he kai­whaka­ako i te ture, he tangata e whaka­nuia ana e te iwi katoa, ka mea, kia neke­hia atu aua tāngata ki waho mō tētahi wā poto nei. ");
INSERT INTO mri_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nā, ko tāna mea­tanga ki a rātou, “E ngā tāngata o Īharaira, kia tūpato ki tā koutou e mea ai ki ēnei tāngata. ");
INSERT INTO mri_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","I ngā rā ki muri ka whaka­tika ake a Teura, me te whaka­ari i a ia, ko ia he tangata nui; piri atu ana ki a ia ētahi tāngata, pātata ki te whā rau. Nā patua iho ia; ā, ko te hunga katoa i whaka­rongo ki a ia, whaka­marara­tia atu ana, ā, kore ake. ");
INSERT INTO mri_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ā muri iho i taua tangata ka whaka­tika ake ko Hūrā o Kariri i ngā rā o te tatau­ranga, ā, kūmea atu ana e ia ētahi o te iwi ki te whai i a ia; i ngaro anō hoki tēnā; ā, ko te hunga katoa i whaka­rongo ki a ia, whaka­marara­tia atu ana. ");
INSERT INTO mri_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nā, ko tāku kupu tēnei ki a koutou, kāti te mea ki ēnei tāngata. Waiho noa iho rātou! Ki te mea hoki nā te tangata tēnei whaka­aro, tēnei mahi, tērā e whaka­kāhore­tia, ");
INSERT INTO mri_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","otirā, me­he­mea nā te Atua, e kore rawa e taea e koutou te whaka­kāhore. Kei tūpono hoki e whawhai kē ana koutou ki te Atua!” ");
INSERT INTO mri_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ā, whaka­ae ana rātou ki a ia; nā, ka karanga­tia ngā āpō­toro ki a rātou, ka whiua, ka whaka­tūpato­ria kia kaua rawa e kōrero i runga i te ingoa o Īhu, ā, tukua ana rātou kia haere. ");
INSERT INTO mri_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Heoi, haere hari atu ana rātou i te aro­aro o te rū­nanga, mō rātou kua meinga e pai ana kia whaka­tau­reka­reka­tia mō te Ingoa. ");
INSERT INTO mri_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ā, i ngā rā katoa, i roto i te teme­para, i ngā kāinga rānei, kāhore e mutu ana tā rātou whaka­ako, tā rātou kauwhau i a Īhu, ko te Karaiti ia. ");
INSERT INTO mri_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nā, i aua rā, i te mea ka toko­maha haere ngā ākonga ka amu­amu ngā Hūrai Kariki ki ngā Hiperu, nō te mea i mahue ō rātou pouaru i ngā tūw­hanga mea o tēnei rā, o tēnei rā. ");
INSERT INTO mri_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kātahi, ka karanga­tia e te tekau mā rua te mano o ngā ākonga, ka mea, “E kore e pai kia whaka­rērea e mātou te kupu a te Atua, ā, kia mahi tēpu. ");
INSERT INTO mri_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nō reira, e ngā tēina, tiro­hia mai i roto i a koutou kia toko­whitu ngā tāngata e kōrero­tia paitia ana, e kī ana i te Wairua Tapu, i te mātau­ranga, ā, mā mātou rātou e whaka­tū ki tēnei mahi. ");
INSERT INTO mri_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ko mātou ia ka ū tonu ki te īnoi, ki te mahi i te kupu.” ");
INSERT INTO mri_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ā, pai katoa te mano ki taua kōrero; nā, whiri­whiria ana e rātou a Tepene, he tangata e kī ana i te whaka­pono, i te Wairua Tapu, rātou ko Piripi, ko Porokoru, ko Nikanora, ko Timona, ko Paramena, ko Nīkora, he poro­hira­iti nō Anatioka. ");
INSERT INTO mri_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nā, whaka­tū­ria ana rātou ki te aro­aro o ngā āpō­toro; ka īnoi ērā, ka whaka­pā i ngā ringa ki runga ki a rātou. ");
INSERT INTO mri_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Heoi, tupu ana te kupu a te Atua. Tino nui haere ana te toko­maha o ngā ākonga i Hiruhārama; ā, he ope nui o ngā tohu­nga i tahuri mai ki te whaka­pono. ");
INSERT INTO mri_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ā, ko Tepene, kī tonu i te whaka­pono, i te mana, nui atu ngā mere­kara me ngā tohu i meatia e ia i roto i te iwi. ");
INSERT INTO mri_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nā, ka whaka­tika ētahi o te whaka­mine­nga, e kīa nei ko te whaka­mine­nga o ngā Riperetini, ētahi hoki o te whaka­mine­nga o te hunga o Hairini, o te hunga o Arehāna­ria, o te hunga hoki o Kiri­kia, o Āhia, ka totohe ki a Tepene. ");
INSERT INTO mri_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Otirā, kīhai i taea e rātou te tū atu ki tōna mātau­ranga me te wairua i kōrero ai ia. ");
INSERT INTO mri_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nā, ka whaka­kīkī rātou i ētahi tāngata hei mea, “I rongo mātou i a ia e kōrero kohu­kohu ana mō Mohi, mō te Atua anō hoki.” ");
INSERT INTO mri_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nā, ka tahuri rātou ki te whaka­oho­oho i te iwi, i ngā kaumātua, me ngā kara­ipi hoki, nā, ka mau ia i a rātou, hopu­kia ana, kawea atu ana ki te rū­nanga. ");
INSERT INTO mri_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ā, whaka­tū­ria ana e rātou ētahi kai­whaka­pae teka, nāna i mea, “Kāhore e mutu te kōrero kino a tēnei tangata mō tēnei kāinga tapu, mō te ture hoki; ");
INSERT INTO mri_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","i rongo hoki mātou ki a ia e mea ana, ‘Mā tēnei Īhu o Nahareta e whaka­ngaro te kāinga nei, e whaka­puta kē hoki ngā rite­nga i hōmai e Mohi ki a tātou.’ ” ");
INSERT INTO mri_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ā, ko te hunga katoa e noho ana i te rū­nanga, ka ti­tiro pū ki a ia, ka kite i tōna mata, ānō he mata nō te ana­hera. ");
INSERT INTO mri_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kātahi, ka mea te tohu­nga nui, “He pono rānei ēnei mea?” ");
INSERT INTO mri_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nā, ka mea ia, “E ngā tēina, e ngā mātua, whaka­rongo mai. I puta te Atua o te korōria ki tō tātou matua, ki a Āperahama, i a ia i Mehopotamia, ā, kīanō i noho ki Harana, ");
INSERT INTO mri_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ka mea ki a ia, ‘Haere atu i tōu whenua, i ōu whanau­nga, ā, e tomo ki te whenua e whaka­kitea e ahau ki a koe.’ ");
INSERT INTO mri_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nā, puta mai ana ia i te whenua o ngā Karari, noho ana ki Harana. Ā, nō te mate­nga o tōna pāpā, ka whaka­hekea mai ia i reira e te Atua ki tēnei whenua e noho nei koutou. ");
INSERT INTO mri_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ā, kīhai i hoatu tētahi kāinga mōna i konei, kore rawa, ahakoa he tū­ranga wae­wae noa; heoi, i oati ia, tērā e hōmai a konei hei kāinga mōna, mō tōna uri hoki i muri i a ia, ahakoa rā i taua wā kāhore āna tama­riki. ");
INSERT INTO mri_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ā, i pēnei te kōrero a te Atua, ‘Tērā tōna uri e noho manene ki te whenua kē; ka meinga hoki hei pono­nga, ā, e whā rau tau e tūkino­tia ana. ");
INSERT INTO mri_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nā, ko te iwi e meinga ai rātou hei pono­nga, ka whaka­wā­kia e ahau,’ e ai tā te Atua, ‘muri iho i tēnei ka puta mai rātou, ā, ka mahi ki ahau i tēnei wāhi.’ ");
INSERT INTO mri_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ā, i hōmai anō e ia ki a ia te kawe­nata o te kotinga. Ā, whānau ake tā Āperahama ko Īhaka, ā, i te waru o ngā rā ka kotia; ā, nā Īhaka ko Hākopa; nā Hākopa hoki ngā tūpuna kotahi tekau mā rua. ");
INSERT INTO mri_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Nā, ka hae ngā tūpuna ki a Hōhepa, ā, hokona ana ia ki Īhipa; otirā i a ia te Atua; ");
INSERT INTO mri_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nāna ia i whaka­ora i ōna mate­nga katoa, ā, hoatu ana ki a ia he pai, he mātau­ranga i te aro­aro o Parao kīngi o Īhipa; ā, meinga ana ia e tērā hei kāwana mō Īhipa, mō tōna whare katoa hoki. ");
INSERT INTO mri_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nā, i reira ka puta he matekai ki te whenua katoa o Īhipa, o Kanaana, ā, he mate nui; kīhai rawa i kitea he oranga e ō tātou mātua. ");
INSERT INTO mri_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ā, nō te rongo­nga o Hākopa, e whai wīti ana a Īhipa, ka tonoa e ia ō tātou mātua, ko te tono­nga tua­tahi. ");
INSERT INTO mri_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ā, nō te tono­nga tuarua, ka whaka­mōhio­tia a Hōhepa ki ōna tuā­kana; ā, ka whaka­atu­ria ki a Parao te iwi o Hōhepa. ");
INSERT INTO mri_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nā, ka tono tāngata a Hōhepa ki te karanga i tōna pāpā, i a Hākopa ki a ia, i ōna huānga katoa hoki, e whitu tekau mā rima ngā wairua. ");
INSERT INTO mri_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nā, heke ana a Hākopa ki Īhipa, ā, ka mate a ia, me ō tātou mātua. ");
INSERT INTO mri_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ā, kawea atu ana rātou ki Hekeme, whaka­takoto­ria ana ki te urupā i hokona mai rā e Āperahama, he moni hiriwa te utu, i ngā tama a Hāmora i Hekeme. ");
INSERT INTO mri_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ā, nō ka tata mai te wā mō te mea i kōrero­tia rā i mua, i oati­tia rā e te Atua ki a Āperahama, ka tupu te iwi, ka tini haere ki Īhipa, ");
INSERT INTO mri_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ā, tae noa ki te pu­tanga ake o tētahi atu kīngi mō Īhipa, kīhai nei i mōhio ki a Hōhepa. ");
INSERT INTO mri_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ko ia te mea nāna i tini­hanga tō tātou iwi, i whaka­tupu kino ō tātou mātua, i meatia ai kia makā atu ā rātou tama­riki kei puta ki te ora. ");
INSERT INTO mri_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nō taua wā, ka whānau a Mohi, he tangata tino āta­ahua. E toru ngā marama i whaka­tupu­ria ai ia i roto i te whare o tōna pāpā, ");
INSERT INTO mri_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ā, nō ka makā atu ia, ka tango­hia ake ia e te tamā­hine a Parao, ā, ata­whai­tia ana hei tama­iti ake māna. ");
INSERT INTO mri_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nā, i āta whaka­akona a Mohi ki ngā mea katoa o te mātau­ranga o ngā Īhipiana; ā, he mana rawa ia, i te kupu, i te mahi. ");
INSERT INTO mri_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ā, ka tata ōna tau ki te whā tekau, ka uru mai te whaka­aro ki tōna ngākau kia haere ia ki ōna tuā­kana, ki ngā tama a Īharaira. ");
INSERT INTO mri_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ā, i tōna kite­nga i tētahi o rātou e tūkino­tia ana, ka āwhina ia i a ia, a patua iho e ia te Īhipiana, ā, ka whai utu mōna i tūkino­tia rā. ");
INSERT INTO mri_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hua noa e mōhio ōna tuā­kana, nōna te ringa e hōmai ai e te Atua te whaka­ora­nga mō rātou, heoi, kīhai rātou i mōhio. ");
INSERT INTO mri_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nā, i te aonga ake ka puta atu ia ki ētahi e whawhai ana ki a rāua, ka tahuri ki te wawao i a rāua, ka mea, ‘E hoa mā, he teina, he tua­kana kōrua; he aha kōrua ka kino ai ki a kōrua anō?’ ");
INSERT INTO mri_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Otirā, peia atu ana ia e te tangata nāna te hē ki tōna hoa; i mea ia, ‘Nā wai koe i mea hei ranga­tira, hei kai­whaka­wā mō māua? ");
INSERT INTO mri_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","E mea ana koe ki te whaka­mate i ahau, me koe i whaka­mate rā i te Īhipiana ina­nahi?’ ");
INSERT INTO mri_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nā, ka tahuti a Mohi i taua kōrero, ā, noho manene ana i Miriana. Ā, toko­rua āna tama i whānau ki reira. ");
INSERT INTO mri_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ā, nō ka tutuki ngā tau e whā tekau, ka puta ki a ia tētahi ana­hera a te Ariki i te koraha o Maunga Hinai, i roto i te mura ahi i te rākau. ");
INSERT INTO mri_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ā, nō te kite­nga o Mohi, ka mīharo ki taua whaka­kite­nga; ā, i a ia ka whaka­tata atu ki te mā­taki­taki, ka puaki mai te reo o te Ariki ki a ia, ");
INSERT INTO mri_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ko te Atua ahau o ōu mātua, ko te Atua o Āperahama, o Īhaka, o Hākopa.’ Nā, wiri ana a Mohi, kore rawa i kaha ki te ti­tiro atu. ");
INSERT INTO mri_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ā, ka mea mai te Ariki ki a ia, ‘Wete­kia atu ngā hū i ōu wae­wae; ko te wāhi hoki e tū nā koe he one­one tapu. ");
INSERT INTO mri_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kua tino kite hoki ahau i te mate o tōku iwi e noho nei i Īhipa, kua rongo hoki i tā rātou auē, ā, kua heke iho nei ahau ki te whaka­ora i a rātou. Nā, haere mai, ka tonoa koe e ahau ki Īhipa.’ ");
INSERT INTO mri_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Nā ko taua Mohi i whaka­kāhore­tia rā e rātou, i mea rā rātou, ‘Nā wai koe i mea hei ranga­tira, hei kai­whaka­wā?’ Ko ia anō i tonoa e te Atua hei ranga­tira, hei kai­whaka­ora, he mea nā te ringa o te ana­hera i puta mai rā ki a ia i te rākau. ");
INSERT INTO mri_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nā, taua tangata rātou i ārahi atu, i muri iho i tāna mahi­nga i ngā mea whaka­mīharo, i ngā tohu, ki te whenua o Īhipa, ki te Moana Whero, ki te koraha hoki i ngā tau e whā tekau. ");
INSERT INTO mri_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ko taua Mohi anō tēnei i mea atu rā ki ngā tama­riki a Īharaira, ‘Mā te Atua e whaka­ara ake he poro­piti mō koutou i roto i ō koutou tēina, he pēnei me ahau.’ ");
INSERT INTO mri_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ko ia anō tēnei i te whaka­mine­nga i te koraha, rāua ko te ana­hera i kōrero rā ki a ia i Maunga Hinai, ko ō tātou mātua hoki; i riro mai ai i a ia ngā kupu ora hei hōmai ki a tātou. ");
INSERT INTO mri_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Kīhai nei ō tātou mātua i pai ki te whaka­rongo ki a ia, heoi, peia atu ana ia e rātou, ā, hoki ana ō rātou ngākau ki Īhipa. ");
INSERT INTO mri_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ā, mea ana rātou ki a Ārona, ‘Hangā mā tātou ētahi atua hei haere ki mua i a tātou; ko tēnei Mohi hoki i āra­hina mai nei tātou i te whenua o Īhipa, kāhore tātou e mātau kua ahatia rānei.’ ");
INSERT INTO mri_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Heoi, hangā ana e rātou he kūao kau i aua rā, tāpaea ana he patu­nga tapu mā taua whaka­pakoko, ā, koa ana ō rātou ngākau ki ngā mahi a ō rātou ringa. ");
INSERT INTO mri_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nā, ka tahuri kē te Atua, tukua atu ana rātou kia kara­kia ki te ope o te rangi; kia pērā me te mea i tuhia ki te puka­puka a ngā poro­piti: ‘I hōmai koia e koutou ki ahau ngā patu­nga tapu me ngā whaka­here i ngā tau e whā tekau i te koraha, e te whare o Īharaira? ");
INSERT INTO mri_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nā, kua mau koutou ki te ta­pe­nā­kara o Moroko, ki te whetū o tō koutou atua o Reipana, ki ngā whaka­pakoko i hangā e koutou hei koro­piko atu; nā, māku koutou e kawe atu ki tāwāhi o Papurōna.’ ");
INSERT INTO mri_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“I ō tātou mātua te ta­pe­nā­kara o te whaka­atu­ranga i te koraha, tāna hoki i whaka­rite ai, i mea ai ki a Mohi kia hangā e ia, kia rite ki te tauira i kite ai ia. ");
INSERT INTO mri_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ā, i ō rātou nā rā, nā ō tātou mātua i mau mai, i a rātou ko Hohua i haere mai ai ki te noho i te whenua o ngā tauiwi, i peia atu nei e te Atua i te aro­aro o ō tātou mātua, ā, taea noatia ngā rā i a Rāwiri; ");
INSERT INTO mri_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","i pai­ngia nei ia e te Atua, ā, i īnoi hoki māna e rapu he nohoa­nga mō te Atua o Hākopa. ");
INSERT INTO mri_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nā, Horomona ia i hanga he whare mōna. ");
INSERT INTO mri_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“He ahakoa rā, e kore te Runga Rawa e noho ki ngā whare i hangā e te ringa; ko tā te poro­piti hoki tēnā i mea ai: ");
INSERT INTO mri_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ko te rangi tōku torōna, ko te whenua tōku tū­ranga wae­wae. He whare pēhea tā koutou e hanga ai mōku?’ e ai tā te Ariki; ‘ā, ko tēhea te wāhi e oki­oki ai ahau? ");
INSERT INTO mri_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ehara ianei i tōku ringa nāna ēnei mea katoa i hanga?’ ");
INSERT INTO mri_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“E te hunga kakī mārō, kāhore nei i kotia te ngākau me ngā tari­nga, he whaka­keke tonu tā koutou ki te Wairua Tapu; rite tonu tā koutou ki tā ō koutou mātua. ");
INSERT INTO mri_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ko tēhea o ngā poro­piti kīhai i whaka­tupu­ria kino­tia e ō koutou mātua? Whaka­matea iho e rātou te hunga i poro­piti­tia ai te haere­nga mai o te Mea Tika; ko koutou nei ōna kai­tuku, ōna kai­kōhuru. ");
INSERT INTO mri_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ko koutou, kua riro nā i a koutou te ture, i tā ngā ana­hera i whaka­takoto mai ai, heoi, kīhai i puri­tia e koutou.” ");
INSERT INTO mri_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ā, ka rongo rātou ki ēnei mea, nā tū rawa ki roto ki ō rātou ngākau, tetēā ana ō rātou niho ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Otiia ko ia, kī tonu i te Wairua Tapu, ti­tiro mata­tau atu ana ki te rangi, ka kite i te korōria o te Atua, i a Īhu hoki e tū ana i te ringa matau o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ā, ka mea, “Nana, e kite ana ahau ko ngā rangi e tūhāhā ana, ā, ko te Tama a te tangata e tū ana i te ringa matau o te Atua!” ");
INSERT INTO mri_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kātahi, rātou ka hāmama, he nui te reo, ka puru i ō rātou tari­nga, ā, kotahi tonu te omanga atu ki a ia, ");
INSERT INTO mri_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ka makā ia e rātou ki waho o te pā, ā, ākina ana ki te kōhatu. Ko ngā kai­titiro i whaka­takoto i ō rātou kākahu ki ngā wae­wae o tētahi tai­tama, ko Haora te ingoa. ");
INSERT INTO mri_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Heoi, ākina ana e rātou a Tepene ki te kōhatu, me ia e karanga ana ki te Ariki, e mea ana, “E te Ariki, e Īhu, tōku wairua ki a koe.” ");
INSERT INTO mri_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kātahi, ia ka tūturi ki raro, ka karanga, he nui te reo, “E te Ariki, kaua tēnei mea e whaka­iria ki a rātou.” Ā, i tāna kōrero­tanga i tēnei, ka moe. ");
INSERT INTO mri_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ā, i reira a Haora e whaka­ae ana ki tōna mate­nga. Nā, i taua rā ka oho he whaka­toi­nga nui ki te hāhi i Hiruhārama, ā, marara katoa ana rātou, puta noa i ngā wāhi o Hūria, o Hamaria; kāhore ia ngā āpō­toro. ");
INSERT INTO mri_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ā, nā te hunga whaka­aro a Tepene i tanu, ā, he nui tā rātou tangi­hanga mōna. ");
INSERT INTO mri_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ko Haora ia, tā­horoa ana e ia te hāhi, tomo ana ki tēnā whare, ki tēnā whare, tōia atu ana ngā tāne me ngā wāhine, hoatu ana ki roto ki te whare here­here. ");
INSERT INTO mri_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nō reira ko rātou tonu, ko ngā mea i whaka­marara­tia rā, i hāere­ere ki te kauwhau i te kupu. ");
INSERT INTO mri_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nā, ko Piripi i heke atu ki te pā o Hamaria, ā, kauwhau ana i a te Karaiti ki a rātou. ");
INSERT INTO mri_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ā, kotahi tonu te whaka­aro o ngā mano ki te whaka­rongo ki ngā mea i kōrero ai a Piripi, i a rātou e rongo ana, e kite ana i ngā tohu i mea ai ia. ");
INSERT INTO mri_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","I puta mai hoki ngā wairua poke i roto i te tini o ngā mea e nohoia ana, he nui te reo ki te karanga. He toko­maha anō ngā pararūtiki, ngā kopa i whaka­ora­ngia. ");
INSERT INTO mri_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ā, nui atu te hari o taua pā. ");
INSERT INTO mri_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nā, i reira tētahi tangata, ko Haimona te ingoa, he mahi mākutu tāna i mua atu i roto i taua pā, ā, mīharo ana te iwi o Hamaria, i mea hoki ia i a ia he tangata nui. ");
INSERT INTO mri_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","I whaka­rongo katoa hoki rātou ki a ia te iti me te rahi, i mea, “Ko taua kaha o te Atua tēnei tangata, e kīa nei ko te Nui.” ");
INSERT INTO mri_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ā, i whaka­rongo rātou ki a ia, nō te mea kua roa kē rātou e mīharo ana ki āna mahi mākutu. ");
INSERT INTO mri_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ā, nō rātou ka whaka­pono ki a Piripi; e kauwhau ana i te rongo­pai o te ranga­tira­tanga o te Atua, i te ingoa hoki o Īhu Karaiti, ka iri­iria rātou, ngā tāne me ngā wāhine. ");
INSERT INTO mri_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ko Haimona tonu tētahi i whaka­pono. Ā, ka iri­iria ka piri tahi ki a Piripi; ā, nō tōna kite­nga i ngā tohu me ngā mere­kara nunui i mahia, ka mīharo. ");
INSERT INTO mri_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ā, i te rongo­nga o ngā āpō­toro i Hiruhārama kua tango a Hamaria i te kupu a te Atua, ka tonoa atu e rātou a Pita rāua ko Hoani ki a rātou. ");
INSERT INTO mri_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nō tō rāua taenga iho, ka īnoi mō rātou, kia riro te Wairua Tapu i a rātou. ");
INSERT INTO mri_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kāhore anō hoki ia i tau noa ki tētahi o rātou; he mea iri­iri kau i runga i te ingoa o te Ariki, o Īhu. ");
INSERT INTO mri_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Me i reira ka whaka­pā­kia iho ō rātou ringa ki a rātou, ā, ka riro mai te Wairua Tapu i a rātou. ");
INSERT INTO mri_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ā, nō te kite­nga o Haimona, nā te whaka­pā­nga iho o ngā ringa o ngā āpō­toro i hōmai ai te Wairua Tapu, ka mea ki te hoatu moni ki a rāua, ");
INSERT INTO mri_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ka kī, “Hōmai hoki ki ahau tēnei mana, kia riro ai te Wairua Tapu i te tangata e whaka­pā­kia iho ai e ahau ōku ringa.” ");
INSERT INTO mri_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nā, ko te mea­tanga a Pita ki a ia, “Kia pirau ngā­tahi kōrua ko tāu moni, ina koe ka whaka­aro mā te moni ka whi­whi ai ki te mea hōmai noa a te Atua! ");
INSERT INTO mri_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kāhore he wāhi māu, kāhore he taunga mōu i tēnei mea; kāhore hoki i tika tōu ngākau i te aro­aro o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nā, rīpenetā­tia tēnei kino ōu, ā, īnoi ki te Atua, me kore noa e murua te whaka­aro o tōu ngākau. ");
INSERT INTO mri_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kua kite hoki ahau i a koe, kei roto koe i te au kawa, kei te here o te kino.” ");
INSERT INTO mri_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nā, ka whaka­hoki a Haimona, ka mea, “Mā kōrua e īnoi mōku ki te Ariki, kei pā ki ahau tētahi o ngā mea kua kōrero­tia mai nā e kōrua.” ");
INSERT INTO mri_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ā, ka mutu tā rāua whaka­atu, tā rāua kauwhau i te kupu a te Ariki, ka hoki ki Hiruhārama, he maha hoki ngā kāinga o ngā Hamari i kauwhau­tia ai e rāua te rongo­pai. ");
INSERT INTO mri_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nā, ka kōrero tētahi ana­hera a te Ariki ki a Piripi, ka mea, “Whaka­tika, haere ki te tonga, ki te ara e heke atu ana i Hiruhārama ki Kaha”; he koraha tērā. ");
INSERT INTO mri_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Whaka­tika ana ia, haere ana. Nā, ko tētahi tangata o Etiopia, he ūnaka, he tangata nui nā Kanarahi, kuīni o ngā Etiopiana, ko te kai­tiaki ia o āna taonga katoa, i haere ki Hiruhārama ki te kara­kia; ");
INSERT INTO mri_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ā, e hoki mai ana, e noho ana i runga i tōna hāri­ata, e kōrero ana i a Ihāia poro­piti. ");
INSERT INTO mri_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nā, ka mea te Wairua ki a Piripi, “Whaka­tata atu, ka haere atu koe ki te hāri­ata rā.” ");
INSERT INTO mri_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kātahi a Piripi ka oma atu ki a ia, ka rongo i a ia e kōrero ana i a Ihāia poro­piti, ka mea atu, “E mātau ana rānei koe ki tāu e kōrero nā?” ");
INSERT INTO mri_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Anō rā ko ia, “Me pēhea koia, ki te kore tētahi hei ara­taki i ahau?” Nā, ka mea ia ki a Piripi kia eke ki runga kia noho tahi me ia. ");
INSERT INTO mri_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nā, ko te wāhi o te karaipi­ture e kōrero nei ia, ko tēnei, “I āra­hina ia ānō he hipi kia patua; ā, me te reme e wa­hangū ana i te aro­aro o tōna kai­kuti­kuti, kīhai i kuihi tōna waha. ");
INSERT INTO mri_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","I tōna whaka­iti­nga i whaka­korea he whaka­wā mōna. Mā wai hoki tōna whaka­tupu­ranga e kōrero? Kua tango­hia atu nei tōna ora i te whenua.” ");
INSERT INTO mri_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nā, ka whaka­hoki te ūnaka ki a Piripi, ka mea, “Tēnā koa, mō wai tēnei kōrero a te poro­piti? Mōna ake anō, mō tētahi atu rānei?” ");
INSERT INTO mri_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nā, ka puaki te māngai o Piripi, ā, tīmata mai i taua karaipi­ture, kauwhau­tia ana e ia a Īhu ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ā, i a rāua e haere ana i te ara, ka tae atu rāua ki tētahi wai, ka mea te ūnaka, “Nā, he wai tēnei! He aha te mea e kore ai ahau e iri­iria?” ");
INSERT INTO mri_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mea atu ana a Piripi, “Ki te whaka­pono tōu ngākau katoa, e āhei anō koe.” Nā, ka whaka­hoki ia, ka mea, “E whaka­pono ana ahau ko Īhu Karaiti te Tama a te Atua.” ");
INSERT INTO mri_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kātahi ia ka whaka­hau i te hāri­ata kia tū; ka haere atu rāua toko­rua ki roto i te wai, a Piripi rāua ko te ūnaka; ā, iri­iria ana ia e ia. ");
INSERT INTO mri_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ā, i tō rāua pu­tanga ake i te wai, kā­hakina atu ana a Piripi e te Wairua o te Ariki; ā, mutu tonu te kite­nga atu o te ūnaka i a ia, heoi, haere hari atu ana ia i tōna ara. ");
INSERT INTO mri_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ko Piripi ia i kitea ki Ahota; ā, i a ia e haere ana, kauwhau­tia ana e ia te rongo­pai ki ngā pā katoa, ā tae noa ia ki Hiha­ria. ");
INSERT INTO mri_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ko Haora ia kei te kupu­kupu tonu i te whaka­wehi, i te mate mō ngā ākonga a te Ariki, ā, haere ana ki te tohu­nga nui, ");
INSERT INTO mri_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kei te tono puka­puka i a ia ki ngā whaka­mine­nga i Ramahiku, ina kitea e ia tētahi nō te Huarahi, ahakoa tāne, wāhine rānei, kia mauria here­here­tia mai e ia ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nā, i a ia e haere ana, ka whaka­tata ia ki Ramahiku; nā, oho­rere ana te whiti­nga mai ki a ia, huri noa, o tētahi mārama nō te rangi. ");
INSERT INTO mri_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ā, hinga ana ia ki te whenua, ka rongo ake i tētahi reo e mea ana ki a ia, “E Hāora, e Haora, he aha tāu e whaka­toi nei i ahau?” ");
INSERT INTO mri_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Anō rā ko ia, “Ko wai koe, e te Ariki?” Ka mea ia, “Ko Īhu ahau, e whaka­toia nei e koe; ehara tāu, te whana ki ngā koi­koi.” ");
INSERT INTO mri_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nā, wiri ana ia, ihi­ihi ana, ka mea, “E te Ariki, kia aha ahau?” Anō rā ko te Ariki ki a ia, “Whaka­tika, tomo atu ki te pā, ā, ka kōrero­tia ki a koe tāu e mea ai.” ");
INSERT INTO mri_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nā, ko ngā tāngata i haere tahi i a ia, tū reo­kore ana, rongo kau ana ki te reo, kāhore ia i kite tangata. ");
INSERT INTO mri_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nā, ka whaka­tika ake a Haora i te whenua, ā, i te tu­whera­tanga o ōna kanohi, kīhai rawa ia i kite aha; nā, āra­hina ā ringa­tia ana ia e rātou, mauria ana ia ki Ramahiku. ");
INSERT INTO mri_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ā, e toru ōna rā e kore ana e kite, kīhai hoki i kai, kīhai i inu. ");
INSERT INTO mri_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nā, i Ramahiku tētahi ākonga, ko Anania te ingoa; ka mea te Ariki ki a ia, he kite, “E Anania.” Ka mea tērā, “Tēnei ahau, e te Ariki.” ");
INSERT INTO mri_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Anō rā ko te Ariki ki a ia, “Whaka­tika, haere ki te ara e kīa nei ko Torotika, ka ui i te whare o Hūrā mō tētahi ko Haora te ingoa, nō Tarahu. Nā, kei te īnoi ia. ");
INSERT INTO mri_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ā, kua kite ia i tētahi tangata, ko Anania te ingoa, e tomo mai ana, e whaka­pā ana i ōna ringa ki a ia, kia kite ai ia.” ");
INSERT INTO mri_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Otirā, ka whaka­hoki a Anania, “E te Ariki, he toko­maha āku i rongo ai mō tēnei tangata, ki te nui o te kino i mea ai ia ki tāu hunga tapu i Hiruhārama; ");
INSERT INTO mri_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ā, tēnei anō kei a ia he mana nā ngā tohu­nga nui, kia herea te hunga katoa e karanga ana ki tōu ingoa.” ");
INSERT INTO mri_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Heoi, ka mea te Ariki ki a ia, “Haere; nō te mea he kaupapa whiri­whiri ia nāku, hei mau i tōku ingoa ki te aro­aro o ngā tauiwi, o ngā kīngi, o ngā tama hoki a Īharaira. ");
INSERT INTO mri_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ka whaka­kitea hoki e ahau ki a ia te nui o ngā mea e mamae ai ia mō tōku ingoa.” ");
INSERT INTO mri_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nā, haere ana a Anania, tomo ana ki roto ki te whare. Ka whaka­pā i ōna ringa ki a ia, ka mea, “E tōku teina, e Haora, nā te Ariki, nā Īhu, i puta rā ki a koe i te ara i haere mai nā koe, nāna ahau i tono mai, kia kite ai koe, ā, kia kī ai hoki i te Wairua Tapu.” ");
INSERT INTO mri_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nā, marere tonu iho ētahi mea, ānō he unahi, i ōna kanohi, ā, kite ana ia, ka whaka­tika, ka iri­iria. ");
INSERT INTO mri_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nā, ka kai ia, ka whai kaha. Nā, noho ana a Haora ki ngā ākonga i Ramahiku mō ētahi rā. ");
INSERT INTO mri_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ā, i reira tonu kauwhau­tia ana e ia a te Karaiti i roto i ngā whare kara­kia, ko te Tama ia a te Atua. ");
INSERT INTO mri_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ā, mīharo ana te hunga katoa i rongo, ka mea, “Ehara ianei tēnei i te kai­tūkino o te hunga i karanga ki tēnei ingoa i Hiruhārama? Ā, ko te mea anō tēnei i haere mai ai ia, kia herea rātou, kia āra­hina ki ngā tohu­nga nui?” ");
INSERT INTO mri_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ko Haora ia ka nui haere kē atu tōna kaha, ā, whaka­poro­raru­tia ana e ia ngā Hūrai e noho ana i Ramahiku, i a ia e whaka­kite ana ko te Karaiti tēnei. ");
INSERT INTO mri_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ā, ka maha ngā rā ka pahure, ka rū­nanga ngā Hūrai kia whaka­matea ia. ");
INSERT INTO mri_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Heoi, i mātau a Haora ki tā rātou whaka­papa­nga mōna. Ā, whanga ana rātou ki ngā tatau i te ao, i te pō, kia whaka­matea ia; ");
INSERT INTO mri_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","otiia, i mau ngā ākonga ki a ia i te pō, tukua iho ana e rātou rā te taiepa i roto i te kete. ");
INSERT INTO mri_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ā, nō tōna taenga mai ki Hiruhārama, ka whai ia kia uru atu ia ki ngā ākonga; heoi, wehi katoa ana rātou i a ia, kīhai i whaka­pono he ākonga ia. ");
INSERT INTO mri_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ko Pānapa ia i tango i a ia, ā, mauria ana ia ki ngā āpō­toro, kōrero­tia ana e ia ki a rātou tōna kite­nga i te Ariki i te ara, tāna kōrero­tanga ki a ia, tōna māia hoki ki te kauwhau i Ramahiku i runga i te ingoa o Īhu. ");
INSERT INTO mri_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nā, ka noho ia ki a rātou, hāere­ere atu ana, hāere­ere mai ana i Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Me te māia hoki ki te kauwhau i runga i te ingoa o te Ariki; ā, kōrero ana ia, totohe ana ki ngā Hūrai Kariki. Otirā ka whaka­ngākau rātou kia whaka­matea ia. ");
INSERT INTO mri_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nō te mōhio­tanga o ngā tuā­kana, ka mauria ia e rātou ki raro ki Hiha­ria, ā, tonoa atu ana ia ki Tarahu. ");
INSERT INTO mri_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nā, ka whai tānga manawa te hāhi, puta noa i Hūria katoa, i Kariri, i Hamaria, ā tupu ana; haere ana i runga i te wehi o te Ariki, i te whaka­mārie hoki a te Wairua Tapu, nō ka whaka­roaka. ");
INSERT INTO mri_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nā, i a Pita e hāere­ere ana puta noa ngā wāhi katoa, ka tae iho hoki ia ki te hunga tapu e noho ana i Raira. ");
INSERT INTO mri_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ka kitea e ia i reira tētahi tangata ko Inia te ingoa, kua waru ōna tau e takoto ana i runga i tōna moenga; he pararūtiki hoki ia. ");
INSERT INTO mri_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nā, ko te mea­tanga a Pita ki a ia, “E Inia, ka ora koe i a Īhu Karaiti; whaka­tika, whā­riki­tia tōu moenga.” Nā, whaka­tika tonu ake ia. ");
INSERT INTO mri_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","I kite katoa hoki i a ia te hunga e noho ana i Raira, i Harona, ā, tahuri ana ki te Ariki. ");
INSERT INTO mri_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nā, tērā tētahi ākonga i Hopa e noho ana, ko Tapita te ingoa, ko te whaka­māori­tanga ko Roka. He wahine tēnei i aro nui ki ngā mahi pai, ki ngā mahi ata­whai rawa­kore. ");
INSERT INTO mri_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ā, i aua rā ka tū­roro­tia ia, ka mate. Ā, ka oti ia te horoi e rātou, ka whaka­takoto­ria ia ki tētahi rūma i runga. ");
INSERT INTO mri_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nā, i te mea e tata atu ana a Raira ki Hopa, ka rongo ngā ākonga kei reira a Pita, ā, ka tonoa e rātou toko­rua ngā tāngata ki a ia, hei mea, “Kaua e whaka­roa te haere mai ki a mātou.” ");
INSERT INTO mri_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nā, whaka­tika ana a Pita, haere ana i a rāua. Ā, i tōna taenga atu ka āra­hina e rātou ki te rūma i runga. Ā, tū ana ngā pouaru katoa i tōna taha, tangi ana, ka whaka­kite ki a ia i ngā koti, i ngā kākahu i hangā e Roka, i a ia e noho ana i a rātou. ");
INSERT INTO mri_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Otiia, ka tonoa rātou katoa e Pita ki waho, ka tuku ia i ōna turi, ka īnoi; kātahi ka tahuri ake ia ki te tū­pā­paku, ka mea, “Tapita, e ara.” Nā, ka ti­tiro ōna kanohi, ā, i tōna kite­nga i a Pita, ka noho ia ki runga. ");
INSERT INTO mri_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kātahi, ka hoatu e ia tōna ringa ki a ia, ka whaka­ara ake i a ia. Ā, karanga­tia ana e ia te hunga tapu me ngā pouaru, ā, tukua oratia atu ana ia. ");
INSERT INTO mri_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ā, i mōhio­tia tēnei mea puta noa i Hopa katoa; he toko­maha hoki i whaka­pono ki te Ariki. ");
INSERT INTO mri_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ā, he maha ōna rā i noho ai ia ki Hopa, ki a Haimona kai­mahi hiako. ");
INSERT INTO mri_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nā, i Hiha­ria tētahi tangata, ko Koroniria te ingoa, he kene­turio nō te pū i kīa nei ko tō Itari. ");
INSERT INTO mri_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","He tangata kara­kia ia, e wehi ana i te Atua, rātou ko tōna whare katoa, he maha āna mahi ata­whai ki te iwi, me te īnoi tonu ki te Atua. ");
INSERT INTO mri_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","I kite nui ia, he whaka­rehu, i te mea ka tata ki te iwa o ngā hāora o te rā, i tētahi ana­hera a te Atua, e haere mai ana ki a ia, e mea ana hoki ki a ia, “E Koroniria!” ");
INSERT INTO mri_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nā, ka ti­tiro mata­tau atu ia ki a ia, ka wehi, ka mea, “He aha, e te Ariki?” Ka kī tērā ki a ia, “Kua puta ake āu īnoi me āu mahi ata­whai, hei whaka­mahara ki te aro­aro o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nā, tonoa āia­nei he tangata ki Hopa, ki te tiki i a Haimona, ko te rua nei o ōna ingoa ko Pita. ");
INSERT INTO mri_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","He manu­hiri ia nā Haimona kai­mahi hiako, i te taha nei o te moana tōna whare.” ");
INSERT INTO mri_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ā, nō te riro­nga atu o te ana­hera i kōrero nei ki a ia, ka karanga­tia e ia toko­rua o āna pono­nga tāne, me tētahi hōia kara­kia nō te hunga e mahi tonu ana ki a ia; ");
INSERT INTO mri_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ā, ka oti ngā mea katoa te kōrero ki a rātou, ka tonoa rātou e ia ki Hopa. ");
INSERT INTO mri_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nā i te aonga ake, i a rātou e haere ana, e whaka­tata atu ana ki te pā, ka kake a Pita ki runga ki te tuanui, i te ono o ngā hāora, ki te īnoi. ");
INSERT INTO mri_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nā ka pā ki a ia te matekai, ka mea ki te kai; otirā, i a rātou e taka mai ana, ka tau iho te wairua mata­kite ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nā, ka kite ia i te rangi kua tu­whera, me tētahi mea e heke iho ana, he mea tuku iho mā ngā pito e whā, ki te whenua. ");
INSERT INTO mri_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","I roto i taua mea ngā momo kararehe wae­wae whā katoa, ngā mea ngōki­ngōki katoa o te whenua, me ngā manu o te rangi. ");
INSERT INTO mri_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","I reira, ka puta mai he reo ki a ia, “Whaka­tika, e Pita; patua, kainga.” ");
INSERT INTO mri_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ko Pita ia i mea, “Kāhore, e te Ariki; kīanō ahau i kai i te mea noa, i te mea poke rānei.” ");
INSERT INTO mri_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ka puta mai anō he reo ki a ia, ka tua­rua­tia, “Ko ā te Atua i mea ai kia mā, kaua e whaka­noa­tia e koe.” ");
INSERT INTO mri_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","E toru mea­tanga o tēnei, ā, i reira tonu ka tango­hia atu taua mea ki te rangi. ");
INSERT INTO mri_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","I taua wā tonu, i a Pita e whaka­aro­aro ana i roto i a ia ki te tikanga o tēnei whaka­kite­nga, nā, ko ngā tāngata i tonoa mai rā e Koroniria, tērā kua uiui ki te whare o Haimona, tū ana i mua i te kūwaha. ");
INSERT INTO mri_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Karanga ana mai, ui ana, kei reira rānei e noho ana a Pita, te rua nei o ōna ingoa ko Haimona. ");
INSERT INTO mri_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ā, i a Pita e whaka­aro ana mō taua whaka­kite­nga, ka mea te Wairua ki a ia, “Nana, toko­toru ēnei tāngata e rapu ana i a koe. ");
INSERT INTO mri_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nā, whaka­tika, heke atu, haere tahi koutou, kei rua­rua; nāku hoki rātou i tono mai.” ");
INSERT INTO mri_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nā, ka heke atu a Pita ki aua tāngata, ka mea, “Nā, ko ahau tēnei e rapu nei koutou. He aha te take o tā koutou haere mai?” ");
INSERT INTO mri_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nā, ka mea rātou, “Ko Koroniria rā, he kene­turio, he tangata tika, e wehi ana i te Atua, e kōrero­tia paitia ana e te iwi katoa o ngā Hūrai, kua whaka­mahara­tia ia e te Atua nā tētahi ana­hera tapu kia tīkina atu koe ki tōna whare, kia rongo ia ki ētahi kupu i a koe.” ");
INSERT INTO mri_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nā, karanga ana ia i a rātou ki roto hei manu­hiri māna. Ā, i te aonga ake, ka whaka­tika ia ka haere atu me rātou, ā, ko ētahi o ngā tēina nō Hopa i haere tahi me ia. ");
INSERT INTO mri_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ā, ao ake ka tomo rātou ki Hiha­ria. Nā, ko Koroniria e tatari mai ana ki a rātou, he mea karanga nāna kia hui­hui mai ōna whanau­nga me ōna hoa tupu. ");
INSERT INTO mri_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ā, nō ka tomo atu a Pita, ka tūtaki a Koroniria ki a ia, ka hinga ki ōna wae­wae, ka koro­piko ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Otirā, ka whaka­ara ake a Pita i a ia, ka mea, “E tū ki runga; he tangata nei anō ahau.” ");
INSERT INTO mri_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nā, i a ia e kōrero ana ki a ia, ka tomo atu ia ki roto, ka kite i te mene­nga toko­maha, ");
INSERT INTO mri_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ka mea atu ki a rātou, “E mātau ana koutou e kore e tika kia hui­hui te tangata o ngā Hūrai, kia haere atu rānei ki te tangata iwi kē; otiia, kua whaka­kitea e te Atua ki ahau kia kaua e kīa tētahi tangata he noa, he poke. ");
INSERT INTO mri_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Koia ahau i haere mai ai, kīhai i aha i te tiki­nga ake i ahau. Nā, ka ui nei ahau, he aha te take i tīkina ake ai ahau?” ");
INSERT INTO mri_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ka mea a Koroniria, “Ka whā ngā rā ināia­nei tae mai ki tēnei hāora, e whaka­rite ana ahau i te īnoi­nga o te iwa o ngā hāora i roto i tōku whare; nā, ko te tangata e tū ana i tōku aro­aro, kanapa tonu te kākahu, ");
INSERT INTO mri_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","e mea ana, ‘E Koroniria, kua rangona tāu īnoi, ā, e mahara­tia ana āu mahi ata­whai i te aro­aro o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nā, tonoa he tangata ki Hopa, ka karanga ki a koe i a Haimona, te rua nei o ōna ingoa ko Pita; he manu­hiri ia i roto i te whare o Haimona kai­mahi hiako, i te taha moana.’ ");
INSERT INTO mri_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","I reira tonu ka tono tāngata atu ahau ki a koe. Nā, he pai rawa tōu haere­nga mai. Nō reira, kei konei katoa mātou kei te aro­aro o te Atua, whaka­rongo ai ki ngā mea katoa kua whaka­haua e te Ariki ki a koe.” ");
INSERT INTO mri_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nā, ka puaki te māngai o Pita, ka mea: “He pono ka kite ahau kāhore a te Atua whaka­pai kanohi, ");
INSERT INTO mri_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","otiia, i roto i ngā tini iwi ko te tangata e wehi ana ki a ia, ā, e mahi ana i te tika, ka pai­ngia e ia. ");
INSERT INTO mri_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ko te kupu i tukua mai e ia ki ngā tama­riki a Īharaira, he kauwhau i te rongo­pai o te rangi­mārie nā Īhu Karaiti; ko ia nei te Ariki o te katoa. ");
INSERT INTO mri_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ko taua kupu, kei te mōhio koutou, i kauwhau­tia rā puta noa i Hūria katoa, i tīmata mai i Kariri, i muri o te iri­iri i kauwhau­tia e Hoani; ");
INSERT INTO mri_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","arā, ko Īhu o Nahareta, tā te Atua whaka­wahinga i a ia ki te Wairua Tapu, ki te kaha; ā, hāere­ere ana ia ki te mahi i te pai, ki te whaka­ora i te hunga katoa i pēhia e te rēwera; nō te mea i a ia te Atua. ");
INSERT INTO mri_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ko mātou hoki ngā kai­whaka­atu o ngā mea katoa i mea ai ia ki te whenua o ngā Hūrai, ki Hiruhārama hoki. Ā, whaka­matea ana ia e rātou, he mea whaka­iri ki runga ki te rākau. ");
INSERT INTO mri_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nā, ko ia i whaka­ara­hia ake e te Atua i te toru o ngā rā, ā, meinga ana ia kia kitea nuitia, ");
INSERT INTO mri_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ehara i te mea e te iwi katoa, engari e te hunga i whiri­whiria i mua e te Atua, arā e mātou, i kai tahi nei, i inu tahi nei me ia, i muri i tōna aranga ake i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","I whai kupu hoki ia ki a mātou kia kauwhau ki te iwi, kia whaka­atu, ko ia tā te Atua i whaka­rite ai hei Kai­whaka­wā mō ngā tāngata ora, mō ngā tāngata mate. ");
INSERT INTO mri_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","He kai­whaka­atu ngā poro­piti katoa mōna, arā mā tōna ingoa ka whi­whi ai ki te muru­nga hara ngā tāngata katoa e whaka­rongo, ana ki a ia.” ");
INSERT INTO mri_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","I a Pita anō e kōrero ana i ēnei kupu, ka tau iho te Wairua Tapu ki te hunga katoa e whaka­rongo ana ki te kupu. ");
INSERT INTO mri_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ā, ko te hunga o te kotinga i whaka­pono nei, ko ngā mea i haere tahi mai me Pita, mīharo ana nō te mea kua ringi­hia tahi­tia iho te Wairua Tapu ki ngā tauiwi. ");
INSERT INTO mri_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","I rongo hoki rātou ki ngā reo i kōrero ai rātou, i whaka­nui ai i te Atua. I reira ka whaka­hoki a Pita, ");
INSERT INTO mri_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“E āhei rānei te whaka­kāhore e tētahi te wai, kei iri­iria ēnei kua whi­whi tahi nei me tātou ki te Wairua Tapu?” ");
INSERT INTO mri_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nā, ka whaka­hau ia kia iri­iria rātou i runga i te ingoa o Īhu Karaiti. I reira ka tohe rātou ki a ia kia noho mō ētahi rā. ");
INSERT INTO mri_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ā, ka rongo ngā āpō­toro me ngā tuā­kana i Hūria, kua tango hoki ngā tauiwi i te kupu a te Atua. ");
INSERT INTO mri_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ā, nō te taenga ake o Pita ki Hiruhārama, ka whaka­wā­kia ia e te hunga o te kotinga, ");
INSERT INTO mri_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","i mea rātou, “I haere koe ki roto ki ngā tāngata kīhai i kotia, i kai tahi me rātou!” ");
INSERT INTO mri_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nā, ka tīmata a Pita, ka kōrero whaka­tepe atu ki a rātou, ka mea: ");
INSERT INTO mri_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“I te pā ahau, i Hopa, e īnoi ana; ā, ka kite moe­moeā ahau i tētahi whaka­kite­nga, ko tētahi mea e heke iho ana, ānō he kākahu nui, he mea tuku iho i te rangi mā ngā pito e whā; ā, tae tonu mai ki ahau. ");
INSERT INTO mri_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nō te whaka­mau­nga atu o ōku kanohi ki taua mea, ka whaka­aro ahau, ā, ka kite i ngā kararehe wae­wae whā o te whenua, i ngā kararehe mohoao me ngā mea ngōki­ngōki me ngā manu o te rangi. ");
INSERT INTO mri_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ā, ka rongo hoki ahau he reo e mea mai ana ki ahau, ‘E ara, e Pita; patua, kainga.’ ");
INSERT INTO mri_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Otirā, ka kī atu ahau, ‘Kāhore, e te Ariki; kīanō hoki tētahi mea noa, poke rānei, i tapoko noa ki tōku māngai.’ ");
INSERT INTO mri_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nā, ka whaka­hoki tuarua mai he reo nō te rangi, ‘Ko ā te Atua i mea ai kia mā, kaua e meinga e koe kia noa.’ ");
INSERT INTO mri_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","E toru ngā mea­tanga o tēnei; ka hūtia katoa­tia atu anō ki te rangi. ");
INSERT INTO mri_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nā, i taua wā anō kua tū ngā tāngata toko­toru ki mua i te whare i noho ai ahau, he mea tono mai nō Hiha­ria ki ahau. ");
INSERT INTO mri_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nā, ka mea te Wairua ki ahau kia haere tahi mātou, kia kaua ahau e rua­rua. I haere tahi anō i ahau ēnei tēina toko­ono, ā, tomo ana mātou ki te whare o taua tangata. ");
INSERT INTO mri_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nā, ka kōrero­tia mai e ia ki a mātou tōna kite­nga i te ana­hera i tōna whare e tū ana, e mea ana ki a ia, ‘Tonoa ētahi tāngata ki Hopa, tīkina a Haimona, te rua nei o ōna ingoa ko Pita. ");
INSERT INTO mri_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Māna e kōrero ki a koe ētahi kupu, e ora ai koutou ko tōu whare katoa.’ ");
INSERT INTO mri_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ā, nōku ka tīmata ki te kōrero, ka tau iho te Wairua Tapu ki a rātou, ka pērā anō me ia ki a tātou i te tīma­tanga. ");
INSERT INTO mri_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kātahi ahau ka mahara ki te kupu a te Ariki, ki tāna i mea ai, ‘I iri­iri rā a Hoani ki te wai; ko koutou ia ka iri­iria ki te Wairua Tapu.’ ");
INSERT INTO mri_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nā, me­he­mea rite tonu tā te Atua mea i hoatu ai ki a rātou ki tāna i hōmai ai hoki ki a tātou, i a tātou i whaka­pono ai ki te Ariki, ki a Īhu Karaiti; ko wai ahau, kia āhei te tū atu ki te Atua?” ");
INSERT INTO mri_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ā, nō ka rongo rātou ki ēnei mea, mutu pū tā rātou kōrero, heoi, ka whaka­korōria i te Atua, ka mea, “Koia anō, kua hōmai hoki e te Atua ki ngā tauiwi te rīpe­netā e ora ai.” ");
INSERT INTO mri_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nā, ko te iwi i whaka­marara­tia atu i runga i te tūkino­tanga i puta ake i tō Tepene, hāere­ere ana rātou ā tae noa ki Pini­kia, ki Kai­peru, ki Anatioka, me te kauwhau anō i te kupu ki ngā Hūrai anake, kāhore ki ētahi atu. ");
INSERT INTO mri_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Otirā, ko ētahi o rātou, he tāngata nō Kai­peru, nō Hairini, i tō rātou taenga ki Anatioka, ka kōrero ki ngā Kariki hoki, ka kauwhau i te Ariki, i a Īhu. ");
INSERT INTO mri_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ko te ringa hoki o te Ariki i a rātou; ā, he toko­maha rawa i whaka­pono, i tahuri ki te Ariki. ");
INSERT INTO mri_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nā, ka tae tō rātou rongo ki ngā tari­nga o te hāhi i Hiruhārama, ā, ka tonoa e rātou a Pānapa kia haere ki Anatioka. ");
INSERT INTO mri_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nō tōna taenga atu, ka kite i te aroha noa o te Atua, ka hari, ka whaka­hau i a rātou katoa kia ū te ngākau, kia piri ki te Ariki. ");
INSERT INTO mri_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","He tangata pai hoki ia, kī tonu i te Wairua Tapu, i te whaka­pono. He nui anō te hunga i honoa ki te Ariki. ");
INSERT INTO mri_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Me i reira ka haere atu a Pānapa ki Tarahu, ki te rapu i a Haora, ");
INSERT INTO mri_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ā, nō ka kitea ia e ia, ka kawea mai ia e ia ki Anatioka. Ā, kotahi tino tau i hui­hui tahi ai rāua ki te hāhi, ā, he nui te hunga i whaka­akona. I mātua huaina hoki ngā ākonga he Karaiti­ana ki Anatioka. ");
INSERT INTO mri_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nā, i aua rā ka heke mai ētahi poro­piti i Hiruhārama ki Anatioka. ");
INSERT INTO mri_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ā, ka tū ake tētahi o rātou, ko Akapu te ingoa, ka whaka­kite, he mea nā te Wairua, tērā ka pā he mate nui i te hia­kai ki te whenua katoa; i puta anō tēnei i ngā rā o Karau­ria. ");
INSERT INTO mri_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nā, ka whaka­takoto tikanga ngā ākonga i runga i te mea e taea e tēnā, e tēnā, kia tukua atu he āwhina mō ngā tuā­kana e noho ana i Hūria. ");
INSERT INTO mri_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Pērā ana hoki rātou, tukua atu ana ki ngā kaumātua mā te ringa o Pānapa rāua ko Haora. ");
INSERT INTO mri_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nā, i taua wā, ka totoro atu ngā ringa o Kīngi Herora ki te tūkino i ētahi o te hāhi. ");
INSERT INTO mri_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ā, whaka­matea ana e ia ki te hoari a Hēmi, te tua­kana o Hoani. ");
INSERT INTO mri_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ā, nō tōna kite­nga e pai ana ki ngā Hūrai, ka anga ia ki te hopu hoki i a Pita. Nā, ko ngā rā ēnā o te Taro Rēwenakore. ");
INSERT INTO mri_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ā, nō ka mau ia, ka makā ki te whare here­here, ka tukua ki ngā hōia kotahi tekau mā ono kia tiaki­na; ko te whaka­aro mō muri iho i te Kape­nga ka whaka­puta mai ai i a ia ki te iwi. ");
INSERT INTO mri_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nā, ka puri­tia a Pita ki roto ki te whare here­here; otiia, kīhai i mutu­mutu te īnoi a te hāhi ki te Atua mōna. ");
INSERT INTO mri_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ā, nō ka tata a Herora te whaka­puta mai i a ia, i taua pō anō e moe ana a Pita i waenga­nui o ngā hōia toko­rua, he mea here ki ngā meka­meka e rua; me ngā kai­tiaki i mua i te tatau e tiaki ana i te whare here­here. ");
INSERT INTO mri_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nā, tū ana tētahi ana­hera nā te Ariki i tōna taha, ā, tīaho ana te mārama i roto i te rūma. Nā, ka papaki ia i te kao­kao o Pita, ka whaka­ara i a ia, ka mea, “E ara, hohoro.” Ā, marere iho ōna meka­meka i ōna ringa. ");
INSERT INTO mri_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ka mea atu anō te ana­hera ki a ia, “Whī­tiki i a koe, ka here i ōu pā­reke­reke.” Ā, meinga ana e ia. Ka mea anō ki a ia, “Kākahu­ria tōu kākahu, haere mai i muri i ahau.” ");
INSERT INTO mri_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nā, ka haere ia ki waho, ka aru i a ia, ā, kīhai ia i mahara he pono tā te ana­hera i mea ai; hua noa he reka­nga kanohi tāna i kite ai. ");
INSERT INTO mri_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ā, nō ka mahue i a rāua te tua­tahi, te tuarua o ngā kai­tiaki, ka tae rāua ki te tatau rino i te pu­tanga atu ki te pā; tu­whera noa ana tērā ki a rāua. Puta ana rāua ki waho, haere ana, puta rawa i tētahi ara, mawehe tonu atu te ana­hera i a ia. ");
INSERT INTO mri_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ā, i te hoki­nga ake o ngā whaka­aro o Pita, ka mea ia, “Kātahi ahau ka tino mōhio, kua tono mai te Ariki i tāna ana­hera, hei tango i ahau i roto i te ringa o Herora, i ngā mea katoa hoki e tāria nei e te iwi o ngā Hūrai.” ");
INSERT INTO mri_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ā, nō ka whaka­aro­aro ia ki taua mea, ka haere ia ki te whare o Meri, whaea o Hoani, ko te rua nei o ōna ingoa ko Māka; he toko­maha hoki kua hui­hui ki reira ki te īnoi. ");
INSERT INTO mri_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ā, nō te pātōtō­tanga a Pita i te tatau o te whati­toka, ka tae mai he kōtiro ki te whaka­rongo, ko Rora te ingoa. ");
INSERT INTO mri_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ā, nō ka mōhio ia ki te reo o Pita, kīhai i uakina te tatau i te hari, heoi, oma ana ki roto, ki te kōrero kei te tatau a Pita e tū ana. ");
INSERT INTO mri_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nā, ka mea rātou ki a ia, “E hau­rangi ana koe!” Heoi, ka tohe tonu ia he pono. Nā, ka mea rātou, “Ko tōna ana­hera.” ");
INSERT INTO mri_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Me te pātuki tonu anō tērā a Pita; ā, i tā rātou ua­kanga, ka kite i a ia, ka mīharo. ");
INSERT INTO mri_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nā, ka pēpehi atu tōna ringa i a rātou kia kaua e kuihi, ka kōrero­tia ki a rātou tōna whaka­puta­nga mai e te Ariki i te whare here­here. Ka mea, “Kōrero­tia ēnei mea ki a Hēmi rātou ko ngā tēina.” Nā, ka puta ia ki waho, haere ana he wāhi kē. ");
INSERT INTO mri_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nā, i te aonga ake anō o te rā, kīhai i iti te poro­raru o ngā hōia, i ahatia rānei a Pita. ");
INSERT INTO mri_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nā, ka rapu a Herora i a ia, ā, nō te kore­nga i kitea, ka whaka­wā i ngā kai­tiaki, ka whaka­hau kia whaka­matea. Nā, haere atu ana ia i Hūria ki raro ki Hiha­ria noho ai. ");
INSERT INTO mri_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nā, tino nui te riri o Herora ki te hunga o Tāira, o Hairona. Otirā, ka hui­hui mai rātou ki a ia, ā, ka oti a Parahitu, te kai­tiaki o te whare moenga o te kīngi, te whaka­kīkī e rātou, ka tono rātou kia houhia te rongo, nō te mea ko ngā kai i whāngaia ai tō rātou whenua nō te whenua o te kīngi. ");
INSERT INTO mri_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ā, i tētahi rā i whaka­ritea ka kākahu a Herora i te kākahu kīngi, ka noho ki runga ki te torōna, ā, whaka­tū ana ki a rātou. ");
INSERT INTO mri_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nā, ko te karanga­tanga a te hui­hui, “He reo atua, ehara i tō te tangata!” ");
INSERT INTO mri_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","I reira, pū anō ka patua ia e tētahi ana­hera a te Ariki, nō te mea kīhai i hoatu e ia te korōria ki te Atua, ā, kainga ana ia e te kutu­kutu, hemo ake. ");
INSERT INTO mri_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ko te kupu ia a te Atua i tupu, i nui haere. ");
INSERT INTO mri_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ā, ka hoki a Pānapa rāua ko Haora i Hiruhārama, i te otinga o tā rāua mahi, ka mauria a Hoani, ko te rua nei o ōna ingoa ko Māka. ");
INSERT INTO mri_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nā, tērā ētahi poro­piti me ētahi kai­whaka­ako i Anatioka, i te hāhi i reira, ko Pānapa, ko Himiona i huaina nei ko Nikera, ko Rukiu nō Hairini, ko Manaena, he mea whaka­tupu ngā­tahi nei rāua ko Herora teta­raki, me Haora. ");
INSERT INTO mri_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ā, i a rātou e kara­kia ana ki te Ariki, e noho­puku ana, ka mea te Wairua Tapu, “Motu­hia mai ki ahau a Pānapa rāua ko Haora ki te mahi i karanga­tia ai rāua e ahau.” ");
INSERT INTO mri_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nā, ka mutu tā rātou noho­puku me te īnoi, ā, ka popoki iho i ō rātou ringa ki a rāua ka tonoa atu rāua kia haere. ");
INSERT INTO mri_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nā, ka tonoa nei rāua e te Wairua Tapu, ka haere ki Herukia; ā, rere atu ana i reira ki Kai­peru. ");
INSERT INTO mri_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nā, i a rāua i Harami, ka kauwhau­tia e rāua te kupu a te Atua i roto i ngā whare kara­kia o ngā Hūrai. I a rāua anō a Hoani hei kai­mahi. ");
INSERT INTO mri_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ā, nō tō rātou pu­tanga i te motu katoa ki Papaho, ka kitea tētahi tangata mākutu, he poro­piti teka, he Hūrai, ko Paraīhu te ingoa. ");
INSERT INTO mri_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","I te tino kāwana ia, i a Herekiu Paora; he tangata mahara a Herekiu. Ā, karanga­tia ana e ia a Pānapa rāua ko Haora, ā, ka whai kia rongo i te kupu a te Atua. ");
INSERT INTO mri_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Otirā, i tau­tohe ki a rāua a Erima te kai­mākutu, ko te whaka­māori­tanga hoki tēnei o tōna ingoa, i mea kia tahuri kē te tino kāwana i te whaka­pono. ");
INSERT INTO mri_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Otirā, ko Haora, e huaina nei anō ko Paora, kī tonu i te Wairua Tapu, i whaka­mau i ōna kanohi ki a ia, ");
INSERT INTO mri_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ā, i mea, “E te tangata kī tonu i te tini­hanga, i ngā tini mahi poka­noa, e te tama a te rēwera, hoa­riri o ngā mahi tika katoa, e kore ianei e mutu tāu whaka­puta kē i ngā ara tika a te Ariki? ");
INSERT INTO mri_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nana, āia­nei pā ai te ringa o te Ariki ki a koe, ka matapō­tia koe, e kore e kite i te rā ā taka noa tētahi wā.” Nā, taka tonu iho ki a ia he kohu, he pōuri; ā, hāere­ere noa ia ki te rapu kai­ārahi mōna. ");
INSERT INTO mri_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ā, nō te kite­nga o te tino kāwana i taua mea­tanga, ka whaka­pono ia, i mīharo hoki ki te ako a te Ariki. ");
INSERT INTO mri_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nā, ka rere atu a Paora rātou ko ōna hoa i Papaho, ka ū ki Pereka i Pamapu­ria. Ā, whaka­rere ana a Hoani i a rāua, hoki ana ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ko rāua ia haere atu ana i Pereka, tae tonu atu ki Anatioka i Pihi­ria, ā, tomo ana ki te whare kara­kia i te rā hāpati, noho ana. ");
INSERT INTO mri_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ā, ka mutu te kōrero­tanga o te ture, o ngā poro­piti, ka tono tāngata ngā ranga­tira o te whare kara­kia ki a rāua, ka mea, “E hoa mā, ki te mea he kupu whaka­ako tā kōrua ki te hunga nei, kōrero­tia.” ");
INSERT INTO mri_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nā, ka tū a Paora ki runga, ka tā­whiri tōna ringa, ka mea: “E ngā tāngata o Īharaira, e te hunga e wehi ana ki te Atua, whaka­rongo mai. ");
INSERT INTO mri_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nā, te Atua o tēnei iwi, o Īharaira i whiri­whiri ō tātou mātua, ā, whaka­nuia ana e ia tēnei iwi, i a rātou e noho manene ana i te whenua o Īhipa, i runga tonu anō te ringa i āra­hina mai ai rātou e ia i reira. ");
INSERT INTO mri_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nā, me te mea e whā tekau ngā tau i whaka­manawa­nui ai ki tō rātou āhua i te koraha. ");
INSERT INTO mri_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ā, ka whitu ngā iwi ka ngaro i a ia i te whenua o Kanaana, ka hoatu e ia ki a rātou tō rātou whenua hei whenua pūmau, mō ngā tau me te mea e whā rau e rima tekau. ");
INSERT INTO mri_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Ā muri iho i ēnei mea, ka hoatu e ia ki a rātou he kai­whaka­wā, taea noatia a Hamuera poro­piti. ");
INSERT INTO mri_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ā muri iho ka tono rātou ki tētahi kīngi; ā, hoatu ana e te Atua ki a rātou a Haora, tama a Kihi, he tangata nō te pū o Pineamine, ā, e whā tekau ngā tau. ");
INSERT INTO mri_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ā, ka oti ia te whaka­taka, ka whaka­ara­hia ake e ia a Rāwiri hei kīngi mō rātou; i whaka­atu­ria hoki ia e ia, i kōrero­tia, ‘Kua kitea e ahau a Rāwiri tama a Hehe, he tangata e whaka­ae­tia ana e tōku ngākau; ka meatia e ia ngā mea katoa e pai ai ahau.’ ");
INSERT INTO mri_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","He uri nō tēnei tangata tā te Atua i hōmai ai ki a Īharaira, he Kai­whaka­ora, ko Īhu, hei whaka­rite i te mea i kōrero­tia ai i mua. ");
INSERT INTO mri_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nō mua tata anō hoki i tōna haere­nga mai te kauwhau­tanga a Hoani i te iri­iri rīpe­netā, ki te iwi katoa o Īharaira. ");
INSERT INTO mri_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ā, ka tutuki a Hoani ki tōna tutuki­tanga, ka mea ia, ‘Ko wai koia ahau ki tō koutou whaka­aro? Ehara rā ahau i a ia. Engari, tērā te haere mai ana tētahi i muri i ahau, ko ōna hū e kore ahau e tau hei wewete.’ ");
INSERT INTO mri_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“E ōku tuā­kana, e ngā tama o te kāwei o Āperahama, e te hunga i roto i a koutou e wehi ana ki te Atua, kua hōmai te kupu o tēnei ora kia whaka­pua­kina ki a tātou. ");
INSERT INTO mri_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nā, ko te hunga e noho ana Hiruhārama, me ō rātou ranga­tira, i te mea kīhai rātou i mōhio ki a ia, ki ngā reo rānei o ngā poro­piti e kōrero­tia ana i ngā hāpati katoa, nā rātou i whaka­rite aua reo, i a rātou i tuku i a ia ki te mate. ");
INSERT INTO mri_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ahakoa kīhai i kitea e rātou he mea e mate ai ia, ka tohe rātou ki a Pirato kia whaka­matea ia. ");
INSERT INTO mri_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ā, nō ka rite i a rātou ngā mea katoa i tuhi­tuhia mōna, tango­hia iho ana ia i te rākau, whaka­takoto­ria ana ki roto ki te urupā. ");
INSERT INTO mri_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Heoi, nā te Atua ia i whaka­ara ake i te hunga mate. ");
INSERT INTO mri_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ā, he maha ngā rā i kitea ai ia e te hunga i haere tahi i a ia i Kariri ki Hiruhārama, ko rātou nei ngā kai­whaka­atu mōna ki te iwi. ");
INSERT INTO mri_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nā, he kauwhau tēnei nā māua ki a koutou i te rongo­pai, i kōrero­tia i mua ki ngā mātua, ");
INSERT INTO mri_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","arā, kua mana tēnei i te Atua, hei mea mā ā tātou tama­riki, i a ia whaka­ara nei i a Īhu; ko te mea hoki tēnā i tuhi­tuhia i te rua o ngā waiata: ‘Ko tāku Tama koe; nō nāia­nei koe whaka­tupu­ria ai e ahau.’ ");
INSERT INTO mri_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ko tāna kōrero anō tēnei mōna whaka­ara­hia nei e ia i te hunga mate, tē hoki anō ki te pirau i muri iho: ‘Ka hoatu e ahau ki a koutou ngā mea tapu, ngā manaaki­tanga pono o Rāwiri.’ ");
INSERT INTO mri_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Koia hoki ia i mea ai i tētahi atu waiata: ‘E kore koe e tuku i tāu Mea Tapu kia kite i te pirau.’ ");
INSERT INTO mri_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ko Rāwiri hoki i mahi i tā te Atua i pai ai i tōna whaka­tupu­ranga anō, ā, moe iho, whaka­takoto­ria ana ki ōna mātua, kite ana i te pirau. ");
INSERT INTO mri_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ko tēnei ia i whaka­ara­hia ake nei e te Atua, kīhai ia i kite i te pirau. ");
INSERT INTO mri_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nā, kia mōhio koutou, e ōku tuā­kana, nā tēnei tangata te muru­nga hara e kauwhau­tia nei ki a koutou. ");
INSERT INTO mri_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Māna hoki ngā tāngata katoa e whaka­pono ana, ka whaka­tikaia ai i ngā mea katoa, e kore nei koutou e whaka­tikaia i runga i tā Mohi ture. ");
INSERT INTO mri_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nā, kia mahara, kei pā ki a koutou te mea i kōrero­tia rā e ngā poro­piti: ");
INSERT INTO mri_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ti­tiro mai, e te hunga whaka­hāwea, ka mīharo ai, ā, whaka­ngaro­mia iho! Ka mahia hoki e ahau he mahi i ō koutou rā, he mahi e kore e whaka­pono­hia e koutou, ki te whaka­pua­kina e te tangata ki a koutou!’ ” ");
INSERT INTO mri_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nā, i a rātou e puta ana ki waho, ka tohe rātou kia kauwhau­tia anō aua kupu ki a rātou i tō muri iho hāpati. ");
INSERT INTO mri_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Heoi, ka pākaru­karu te hui­hui, he toko­maha ngā Hūrai me ngā poro­hira­iti kara­kia i aru i a Paora rāua ko Pānapa, ā, ka kōrero rāua ki a rātou, ka ako kia mau tonu rātou ki te aroha noa o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nā, i tō muri iho hāpati ka hui­hui mai te pā, me te mea ko rātou katoa, ki te whaka­rongo ki te kupu a te Atua. ");
INSERT INTO mri_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nō te kite­nga ia o ngā Hūrai i te hui­hui, ka kī rātou i te hae, ka whaka­kāhore ki ngā mea i kōrero­tia e Paora, ka whaka­teka, ka kohu­kohu. ");
INSERT INTO mri_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kātahi a Paora rāua ko Pānapa ka kōrero māia atu, ka mea: “I takoto te tikanga kia mātua kōrero­tia te kupu a te Atua ki a koutou. Nā, ka peia nei e koutou, ka whaka­aro koutou e kore koutou e tau mō te ora tonu, nā, ka tahuri atu nei māua ki ngā tauiwi. ");
INSERT INTO mri_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","I pēnei hoki te ako a te Ariki ki a mātou: ‘Kua waiho koe e ahau hei mārama ki ngā tauiwi, kia ai koe hei oranga puta noa i ngā pito o te whenua.’ ” ");
INSERT INTO mri_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nā, i te rongo­nga o ngā tauiwi, ka hari, ka whaka­korōria i te kupu a te Ariki; ka whaka­pono anō te hunga i rite mō te ora tonu. ");
INSERT INTO mri_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ā, pakū ana te kupu a te Ariki puta noa i taua whenua. ");
INSERT INTO mri_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Otirā, i whaka­oho­kia e ngā Hūrai ngā wāhine kara­kia, ranga­tira, me ngā tāngata nunui o te pā, ā, ara ana i a rātou he whaka­toi mō Paora rāua ko Pānapa, peia ana rāua i ō rātou wāhi. ");
INSERT INTO mri_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Heoi, ruia atu ana e rāua te puehu o ō rāua wae­wae ki a rātou, ā, haere ana ki Ikoniuma. ");
INSERT INTO mri_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nā, kī tonu ngā ākonga i te hari, i te Wairua Tapu. ");
INSERT INTO mri_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ā, i Ikoniuma ka haere tahi rāua ki roto ki te whare kara­kia o ngā Hūrai, ā, ka kōrero, nō ka whaka­pono tōna tini o ngā Hūrai, o ngā Kariki. ");
INSERT INTO mri_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nā, ngā Hūrai whaka­teka ia i whaka­oho, i whaka­kino ngā ngākau o ngā tauiwi ki ngā tēina. ");
INSERT INTO mri_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nā, he nui te wā i noho ai rāua i reira, i māia ai te kōrero i ngā mea a te Ariki, nāna i whaka­ae te kupu o tōna aroha noa, me te hōmai anō e ia ngā tohu me ngā mea whaka­mīharo kia meatia e ō rāua ringa. ");
INSERT INTO mri_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Otiia, i wehe­wehea ngā tāngata o te pā; ko ētahi i ū ki ngā Hūrai, ko ētahi ki ngā āpō­toro. ");
INSERT INTO mri_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ā, i ngā tauiwi rātou ko ngā Hūrai, ko ō rātou ranga­tira hoki e huaki ana ki te whaka­tupu kino, ki te āki i a rāua ki te kōhatu. ");
INSERT INTO mri_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ka tūpato rāua, ā, rere ana ki Raihitara, ki Rerepe, ki ngā pā o Raikaonia, ki pahaki tata atu anō hoki. ");
INSERT INTO mri_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ā, kauwhau­tia ana e rāua te rongo­pai ki reira. ");
INSERT INTO mri_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","I Raihitara hoki e noho ana tētahi tangata wae­wae ngoi­kore, he kopa nō te kōpū mai o tōna whaea, kāhore i haere i mua iho. ");
INSERT INTO mri_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","I rongo tēnei i a Paora e kōrero ana; ko te tiro­hanga pu­tanga atu o tērā ki a ia, ka kite he whaka­pono tōna e ora ai, ");
INSERT INTO mri_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","he nui noa atu tōna reo ki te karanga atu, “E tū ōu wae­wae ki runga.” Nā, moko­whiti ake ana ia, haere ana. ");
INSERT INTO mri_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nō te kite­nga o ngā tāngata i tā Paora i mea ai, ka ara tō rātou reo, ka mea i te reo o Raikaonia, “Kua heke iho ngā atua ki a tātou, nō ngā tāngata te āhua!” ");
INSERT INTO mri_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ā, huaina ana e rātou a Pānapa ko Hupita, a Paora ko Merekurai, nō te mea ko ia te pū kōrero. ");
INSERT INTO mri_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nā, ka kawea mai e te tohu­nga o Hupita, i te ngutu nei o te pā tōna teme­para, he pūru, he tūpare ki ngā kūwaha, ka mea kia patua he whaka­here e rātou ko ngā mano. ");
INSERT INTO mri_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Otirā, i te rongo­nga o ngā āpō­toro, o Pānapa rāua ko Paora, ka hae­hae i ō rāua kākahu, ā, rere ana ki roto ki ngā tāngata, ka karanga atu, ");
INSERT INTO mri_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ka mea, “E mara mā, he aha koutou ka mea ai i ēnei mea? He tāngata anō māua, he rite tahi ki a koutou te tū, e kauwhau ana hoki i te rongo­pai, kia tahuri kē koutou i ēnei mea teka­teka noa ki te Atua ora, nāna nei i hanga te rangi me te whenua, te moana me ō reira mea katoa. ");
INSERT INTO mri_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","I ngā whaka­tupu­ranga hoki kua pahemo atu, i tukua e ia ngā iwi katoa kia haere i ō rātou ake ara. ");
INSERT INTO mri_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Otiia, kīhai i tukua e ia kia kāhore he kai­whaka­atu mōna; i ata­whai hoki ia, i hōmai anō e ia ki a koutou te ua o te rangi, me ngā pō hua, i mākona ai ō koutou ngākau i te kai, i te koa.” ");
INSERT INTO mri_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ā, ka kōrero­tia ēnei kupu, nā, mutu whaka­uaua i a rāua te mea a ngā tāngata ki te patu whaka­here mā rāua. ");
INSERT INTO mri_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Otirā, ka haere mai ētahi Hūrai i Anatioka, i Ikoniuma; ā, ka whaka­kīkī rātou i ngā mano, ā, ākina ana a Paora ki te kōhatu, tōia ana ki waho o te pā, hua noa kua mate. ");
INSERT INTO mri_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Otiia, i ngā ākonga e tū ana i tōna taha, ka whaka­tika ia, haere ana ki roto ki te pā. Ā, i te aonga ake ka haere rāua ko Pānapa ki Rerepe. ");
INSERT INTO mri_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ā, nō ka kauwhau rāua i te rongo­pai ki taua pā, ā, he toko­maha ka meinga hei ākonga, ka hoki rāua ki Raihitara, ki Ikoniuma, ki Anatioka; ");
INSERT INTO mri_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","whakaū ana i ngā wairua o ngā ākonga, whaka­hau ana i a rātou kia mau tonu ki te whaka­pono, kua takoto hoki te tikanga, me nā runga i ngā mate­nga maha he ara atu mō tātou ki te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ā, nō ka whaka­ritea e rāua he kaumātua mō rātou i tēnei hāhi, i tēnei hāhi, me te īnoi anō rāua me te noho­puku, ka tukua atu rātou e rāua ki te Ariki, i whaka­pono nei rātou. ");
INSERT INTO mri_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nā, ka haere rāua nā waenga­nui o Pihi­ria, tae tonu atu ki Pamapu­ria. ");
INSERT INTO mri_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ā, ka oti te kauwhau e rāua te kupu ki Pereka, ka haere rāua ki raro ki Ataria. ");
INSERT INTO mri_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ā, rere atu ana i reira ki Anatioka, ki te wāhi i tukua ai rāua ki te aroha noa o te Atua, mō te mahi ka oti nei i a rāua. ");
INSERT INTO mri_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nā, ka tae rāua ka hui­huia te hāhi, ka kōrero­tia ngā mea i mahi tahi ai te Atua me rāua ko tāna ua­kanga hoki i te tatau o te whaka­pono ki ngā tauiwi. ");
INSERT INTO mri_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ā, kīhai i iti te wā i noho ai rāua i reira ki ngā ākonga. ");
INSERT INTO mri_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nā, ka tae iho ētahi tāngata i Hūria ka whaka­ako i ngā tēina, “Ki te kore koutou e kotia, kia rite ki tā Mohi, e kore koutou e taea te whaka­ora.” ");
INSERT INTO mri_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nā, kīhai i iti te whawhai, te uiui a Paora rāua ko Pānapa ki a rātou, ka whaka­ritea ko Paora, ko Pānapa, ko ētahi atu hoki o rātou, e haere ki ngā āpō­toro, ki ngā kaumātua ki Hiruhārama, mō tēnei pūtake. ");
INSERT INTO mri_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Heoi, āra­hina ana rātou e te hāhi haere ana rā Pini­kia, rā Hamaria kōrero ana i te tahuri­tanga o ngā tauiwi, ā, hoatu ana e rāua he hari nui ki ngā tēina katoa. ");
INSERT INTO mri_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ā, nō tō rāua taenga ki Hiruhārama ka whaka­manu­hiri­tia rāua e te hāhi, e ngā āpō­toro hoki rātou ko ngā kaumātua, ka kōrero­tia ngā mea i mahi tahi ai te Atua me rāua. ");
INSERT INTO mri_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nā, ko te whaka­tikanga o ētahi tāngata whaka­pono nō te tītore­hanga ki ngā Parihi, ka mea, “Me kokoti rātou, me ako hoki kia whaka­ritea te ture a Mohi.” ");
INSERT INTO mri_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nā, ka hui­hui ngā āpō­toro rātou ko ngā kaumātua ki te whaka­aro ki tēnei mea. ");
INSERT INTO mri_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ā, ka nui te tau­tohe­tohe, ka whaka­tika a Pita, ka mea ki a rātou, “E ngā tuā­kana, e mātau ana koutou ki te whiri­whiringa a te Atua i mua rawa i roto i a koutou, ko tōku māngai e rongo ai ngā tauiwi i te kupu o te rongo­pai, e whaka­pono ai hoki. ");
INSERT INTO mri_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","I whaka­ae hoki ki a rātou te Atua e mātau nei ki ngā ngākau, i a ia i hoatu ai i te Wairua Tapu ki a rātou, rite tahi ki tāna ki a tātou; ");
INSERT INTO mri_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","kāhore hoki i puta kē tōna whaka­aro ki a tātou, ki a rātou, i ō rātou ngākau kua mā i a ia i runga i te whaka­pono. ");
INSERT INTO mri_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ko tēnei, he aha koutou ka whaka­mā­tau­tau ai i te Atua, ka whaka­takoto ioka ai ki te kakī o ngā ākonga, he mea kīhai nei i taea te mau e ō tātou mātua, e tātou rānei? ");
INSERT INTO mri_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Heoi, ka whaka­pono nei tātou, tērā tātou e ora i runga i te aroha noa o te Ariki, o Īhu Karaiti, ka pērā tahi hoki me rātou.” ");
INSERT INTO mri_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nā, noho puku ana te mano katoa, whaka­rongo ana ki a Pānapa rāua ko Paora e kōrero ana i ngā tohu, i ngā mea whaka­mīharo i mea ai te Atua kia mahia e rāua i roto i ngā tauiwi. ");
INSERT INTO mri_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ā, ka mutu tā rāua ka whaka­hoki a Hēmi, ka mea: “E ngā tuā­kana, whaka­rongo ki ahau! ");
INSERT INTO mri_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Kua kōrero­tia e Himiona tā te Atua tiro­hanga mai i mua, tāna tango­hanga i tētahi iwi i roto i ngā tauiwi mō tōna ingoa. ");
INSERT INTO mri_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","E rite ana anō ki tēnei ngā kōrero a ngā poro­piti; i tuhi­tuhia rā: ");
INSERT INTO mri_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘I muri o ēnei mea ka hoki mai ahau, ka hangā anō e ahau te ta­pe­nā­kara o Rāwiri, kua hinga nei; ka hangā anō e ahau ōna wāhi kua horoa, ā, ka whaka­ara­hia e ahau. ");
INSERT INTO mri_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kia rapu ai ngā toenga o ngā tāngata ki te Ariki, me ngā tauiwi katoa hoki i karanga­tia nei tōku ingoa ki runga ki a rātou, e ai tā te Ariki, e mahi nei i ēnei mea katoa. ");
INSERT INTO mri_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nāna nei i mea kia mōhio­tia ēnei mea katoa nō te tīma­tanga rā anō o te ao.’ ");
INSERT INTO mri_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Nā, ko tōku whaka­aro tēnei; kia kaua e whaka­rarua te hunga e tahuri ana mai ki te Atua i roto i ngā tauiwi; ");
INSERT INTO mri_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","engari, kia tuhi atu tātou ki a rātou, kia mawehe atu rātou i ngā poke o ngā whaka­pakoko, i te moe tāhae, i te mea kua nōtia te kakī, i te toto. ");
INSERT INTO mri_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nō ngā whaka­tupu­ranga hoki ō mua ngā kai­kauwhau i a Mohi i tēnei pā, i tēnei pā, he mea kōrero i roto i ngā whare kara­kia i ngā hāpati katoa.” ");
INSERT INTO mri_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kātahi, ka pai ngā āpō­toro rātou ko ngā kaumātua me te hāhi katoa, kia whiri­whiria ētahi tāngata i roto i a rātou kia tonoa hei hoa mō Paora rāua ko Pānapa ki Anatioka; a Hūrā, i huaina nei ko Pāhapa, rāua ko Hira, he hunga ingoa nui i roto i ngā tēina, ");
INSERT INTO mri_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ka tuhia hoki ēnei mea hei mau­ranga: “Nā ngā āpō­toro rātou ko ngā kaumātua, ko ngā tuā­kana, ki ngā tēina o roto i ngā tauiwi, i Anatioka, i Hīria, i Kiri­kia; tēnā koutou. ");
INSERT INTO mri_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nā, ka rongo nei mātou, tērā ētahi i haere atu nei i a mātou, i whaka­raru i a koutou ki ngā kōrero, i whaka­pōhēhē i ō koutou ngākau, kāhore nei ā mātou kupu ki a rātou. ");
INSERT INTO mri_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kotahi tonu tō mātou whaka­aro he pai kia whiri­whiria ētahi tāngata, kia tonoa atu ki a koutou, hei hoa mō ā mātou tāngata e aroha nei, mō Pānapa rāua ko Paora; ");
INSERT INTO mri_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","he hunga i tuku nei i a rāua ki te mate hei mea mō te ingoa o tō tātou Ariki, o Īhu Karaiti. ");
INSERT INTO mri_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nā, kua tonoa atu nei e mātou a Hūrā rāua ko Hira, mā rāua hoki e kōrero a kupu atu aua mea anō. ");
INSERT INTO mri_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","I pai hoki ki te Wairua Tapu, ki a mātou hoki, kia kaua e utaina ki a koutou tētahi atu whaka­tai­maha, ko ēnei mea tika anake; ");
INSERT INTO mri_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kia mawehe koutou i ngā mea e patua ana mā ngā whaka­pakoko, i te toto, i te mea kua nōtia te kakī, i te moe tāhae. Ka tiaki koutou i a koutou i ēnei mea, ka pai tā koutou mahi. Kia ora koutou.” ");
INSERT INTO mri_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ā, nō tō rātou tuku­nga atu, ka haere ki Anatioka. Nā, ka hui­huia te mano, ka hoatu te puka­puka. ");
INSERT INTO mri_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ā, ka oti te kōrero, ka koa rātou mō te kupu whaka­hauora. ");
INSERT INTO mri_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nā, he maha ngā kupu a Hūrā rāua ko Hira i whaka­hau ai, i whakaū ai i ngā tēina; he poro­piti hoki rāua. ");
INSERT INTO mri_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ā, ka roa iho rāua ki reira, ka tukua rāua e ngā tēina i runga i te rangi­mārie ki te hunga nāna rāua i tono atu. ");
INSERT INTO mri_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Heoi, i pai a Hira kia noho ki reira. ");
INSERT INTO mri_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ko Paora ia rāua ko Pānapa i noho i Anatioka, i whaka­ako, i kauwhau i te kupu a te Ariki, rātou tahi ko tērā hunga toko­maha. ");
INSERT INTO mri_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nā, muri iho i ētahi rā ka kī atu a Paora ki a Pānapa, “Tāua ka hoki, ka tiro­tiro i ngā tēina i ngā pā katoa i kauwhau­tia ai e tāua te kupu a te Ariki, i tō rātou pēhea­tanga.” ");
INSERT INTO mri_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ā, ka mea a Pānapa kia mauria hei hoa a Hoani, e huaina nei ko Māka. ");
INSERT INTO mri_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Otiia, kīhai a Paora i pai kia haere i tō rāua tira te tangata i whaka­rere rā i a rāua i Pamapu­ria, kīhai hoki i haere tahi me rāua ki te mahi. ");
INSERT INTO mri_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Heoi, nui atu tō rāua nga­ngare, mawehe ai rāua i a rāua, ā, mauria ana e Pānapa a Māka, rere ana ki Kai­peru. ");
INSERT INTO mri_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nā, tango ana a Paora i a Hira, haere ana, he mea tuku ki te aroha noa o te Atua e ngā tēina. ");
INSERT INTO mri_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ā, haere ana ia rā Hīria, rā Kiri­kia, whakaū ana i ngā hāhi. ");
INSERT INTO mri_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nā, ka tae atu hoki ia ki Rerepe, ki Raihitara, ā, i reira tētahi ākonga, ko Tīmoti te ingoa, he tama nā tētahi wahine whaka­pono, he Hūrai, ko tōna pāpā ia he Kariki. ");
INSERT INTO mri_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","He pai te kōrero mōna a ngā tēina i Raihitara, i Ikoniuma. ");
INSERT INTO mri_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","I mea a Paora kia haere ia hei hoa mōna, ā, tango­hia ana ia, kotia ana, he mea hoki mō ngā Hūrai e noho ana i aua wāhi; i mātau hoki rātou katoa he Kariki tōna pāpā. ");
INSERT INTO mri_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ā, i a rātou e hāere­ere ana i ngā pā, ka tukua e rātou hei pupuri mā rātou ngā tikanga i whaka­ritea e ngā āpō­toro, e ngā kaumātua, i Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nā, ka whaka­ū­kia ngā hāhi ki te whaka­pono, ka nui haere hoki i tēnei rā, i tēnei rā. ");
INSERT INTO mri_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nā, haere ana rātou nā waenga­nui o te whenua o Pirikia, o Karatia, kua āraia hoki e te Wairua Tapu kei kōrero i te kupu ki Āhia. ");
INSERT INTO mri_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ā, i te taenga atu ki Maihia, ka whaka­mātau rātou ki te haere ki Pitinia; heoi, kīhai i tukua e te Wairua o Īhu; ");
INSERT INTO mri_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","nā, kapea ana Maihia, ka haere ki Toroa. ");
INSERT INTO mri_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ā, ka kitea e Paora he kite­nga i te pō: He tangata nō Makeronia e tū ana, e tohe ana ki a ia, e mea ana, “Whiti mai ki Makeronia, āwhina­tia mātou.” ");
INSERT INTO mri_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ā, nō ka kitea te kite­nga, ka mea tonu mātou kia haere ki Makeronia, i whaka­aro hoki, nā te Atua mātou i karanga ki te kauwhau i te rongo­pai ki a rātou. ");
INSERT INTO mri_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Heoi, ko te rere­nga atu i Toroa, ka tika tonu mātou ki Hamotarakia, ā, ao ake te rā ki Neapori. ");
INSERT INTO mri_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","I reira atu ki Piripai, ko te pā nui ia o taua wāhi o Makeronia, he koroni nō Roma. Ā, noho ana mātou i taua pā ā taka noa ētahi rā. ");
INSERT INTO mri_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nā, i te rā hāpati ka haere mātou ki waho o te pā, ki te taha o tētahi awa, he whaka­aro ko te wāhi tērā hei karakia­tanga; ā, ka noho, ka kōrero ki ngā wāhine i haere tahi ake. ");
INSERT INTO mri_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nā, ka whaka­rongo tētahi wahine, ko Riria te ingoa, he kai­hoko pāpura, nō te pā o Taiataira, he wahine kara­kia ki te Atua. He mea whaka­puare tōna ngākau e te Ariki, i rongo ai ia ki ngā mea i kōrero­tia e Paora. ");
INSERT INTO mri_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ā, nō ka oti ia te iri­iri, rātou ko tōna whare, ka tohe ia, ka mea, “Ki te mea kua Whaka­aro koutou he pono tāku mahi ki te Ariki, tomo mai koutou, e noho ki tōku whare.” Nā, ka tohea mātou e ia. ");
INSERT INTO mri_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nā, i a mātou e haere ana ki te wāhi īnoi, ka tūtaki ki a mātou tētahi kōtiro, he wairua mata­kite nei tōna, he nui te utu i riro i a ia mā ōna ranga­tira, i a ia e poro­piti ana. ");
INSERT INTO mri_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ka whai ia i a mātou ko Paora, ka karanga, ka mea, “He pono­nga ēnei tāngata nā te Atua, nā te Runga Rawa, e whaka­pua­kina ana e rātou te ara o te ora ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nā, he maha ngā rā i mea ai ia tēnei. Otiia, ka hōhā a Paora, ka tahuri, ka mea ki te wairua, “Ko tāku kupu tēnei ki a koe i runga i te ingoa Īhu Karaiti, puta mai i roto i a ia.” Puta mai ana i taua hāora anō. ");
INSERT INTO mri_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Otirā, nō te kite­nga o ōna ranga­tira kua kore he mahi­nga moni mā rātou, ka mau ki a Paora rāua ko Hira, ka tōia ki te kāinga hoko ki ngā ranga­tira. ");
INSERT INTO mri_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ā, ka oti rāua te mau ki ngā kai­whaka­wā, ka mea, “Ko ēnei tāngata he Hūrai nei, e tino whaka­raru­raru ana i tō tātou pā, ");
INSERT INTO mri_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","e whaka­pua­kina ana hoki e rāua he rite­nga e kore nei e tika kia whaka­ae­tia, kia mahia e tātou, e ngā tāngata o Roma.” ");
INSERT INTO mri_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nā, ko te whaka­tikanga o te mano ki a rāua. Ka huhua ō rāua kākahu e ngā kai­whaka­wā, ka mea kia whiua ki te rākau. ");
INSERT INTO mri_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ā, ka maha ō rāua whiu­nga e rātou, ka makā rāua ki te whare here­here, ka tohu­tohu­tia te kai­tiaki here­here, kia mau tāna pupuri i a rāua. ");
INSERT INTO mri_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nō te riro­nga i a ia o taua kupu, ka makā rāua e ia ki te whare here­here i roto rawa, ka whaka­ūria ō rāua wae­wae ki te rākau. ");
INSERT INTO mri_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nā, i waenga­nui pō ka īnoi a Paora rāua ko Hira, ka waiata atu ki te Atua, me te whaka­rongo anō ngā here­here ki a rāua. ");
INSERT INTO mri_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nā, ka pā whaka­rere he rū nui, i ngarue ai ngā tū­ranga o te whare here­here. Ā, puare tonu atu ngā tatau katoa, whaka­koro­koroa ana ngā here­nga o ngā tāngata katoa. ");
INSERT INTO mri_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ā, ka oho te kai­tiaki here­here i te moe, ka kite i ngā tatau o te whare here­here e puare ana, nā, ka unu i tāna hoari, ka mea ki te patu i a ia anō, hua noa kua oma ngā here­here. ");
INSERT INTO mri_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nā, ka nui te reo o Paora ki te karanga, ka mea, “Kauaka tētahi mea kino e meatia ki a koe; ina tonu hoki mātou katoa.” ");
INSERT INTO mri_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ā, karanga­tia ana e ia he rama, ka rere ki roto, ka haere wiri, ka takoto ki te aro­aro o Paora rāua ko Hira. ");
INSERT INTO mri_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ka āra­hina hoki rāua ki waho, ka mea, “E hoa mā, me aha ka ora ai ahau?” ");
INSERT INTO mri_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ka mea rāua “Me whaka­pono ki te Ariki, ki a Īhu Karaiti, ka ora ai koe, koutou tahi ko tōu whare.” ");
INSERT INTO mri_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nā, ka kōrero­tia te kupu a te Ariki ki a ia, ki ngā tāngata katoa hoki i roto tōna whare. ");
INSERT INTO mri_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ā, ka mauria rāua e ia i taua hāora o te pō, ka horoia ō rāua whiu­nga; nā, iri­iria tonu­tia iho, a ia me āna tāngata katoa. ");
INSERT INTO mri_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ā, ka āra­hina rāua e ia ki tōna whare, ka whaka­tū­ria he tēpu kai ki mua i a rāua, ā, nui atu tōna hari, me tōna whare katoa, i te mea kua whaka­pono nei ki te Atua. ");
INSERT INTO mri_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","I te aonga ake ia o te rā, ka tonoa, ngā kātipa e ngā kai­whaka­wā, i mea, “Tukua aua tāngata kia haere.” ");
INSERT INTO mri_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nā, ka kōrero­tia e te kai­tiaki here­here ēnei kupu ki a Paora, ka mea, “Kua tono tāngata mai ngā kai­whaka­wā, kia tukua kōrua. Tēnā rā puta mai, haere i runga i te rangi­mārie.” ");
INSERT INTO mri_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nā, ko te kīanga atu a Paora, “Kua whiua nuitia nei māua e rātou, ahakoa kāhore i whaka­wā­kia, he tāngata hoki nō Roma, ā, kua makā māua ki te whare here­here. Ā, kei te makā puku­tia atu māua āia­nei e rātou? Kāhore rāpea; engari, mā rātou tonu e haere mai, e whaka­puta i a māua ki waho.” ");
INSERT INTO mri_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nā, ka kōrero­tia ēnei kupu e ngā kātipa ki ngā kai­whaka­wā; ā, ka wehi, i tō rātou rongo­nga nō Roma rāua. ");
INSERT INTO mri_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nā, ka haere mai rātou, ka tohe ki a rāua, ā, ka oti rāua te ārahi ki waho, ka mea rātou kia haere atu rāua i te pā. ");
INSERT INTO mri_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ā, ka puta atu rāua i te whare here­here, ka tomo ki te whare o Riria, ā, nō ka kite rāua i ngā tēina, ka whaka­mārie i a rātou, ka haere. ");
INSERT INTO mri_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nā, ka hāere­ere rāua i Amapipori, Aporonia, ka tae ki Teharonika; he whare kara­kia nō ngā Hūrai i reira. ");
INSERT INTO mri_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ā, ka tomo atu a Paora ki a rātou, he tikanga hoki nāna, ā, e toru ngā hāpati i kōrero­rero ai ki a rātou i roto i ngā karaipi­ture, ");
INSERT INTO mri_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","i whaka­puaki ai, i kōrero ai, kua takoto hoki te tikanga kia mamae a te Karaiti, kia ara mai hoki i te hunga mate; ā, “Ko tēnei Īhu, e kauwhau­tia nei e ahau ki a koutou, ko ia te Karaiti.” ");
INSERT INTO mri_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nā, ka whaka­pono ētahi o rātou, ka piri hoki ki a Paora rāua ko Hira; he toko­maha hoki o ngā Kariki kara­kia, kīhai hoki i rua­rua ngā wāhine ranga­tira. ");
INSERT INTO mri_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Heoi, ka hae ngā Hūrai, ka tango ki a rātou i ētahi tāngata kikino o te hunga māngere, ka hui­huia ngā tāngata, ka whaka­oho­tia te pā; nā, ko te hua­kanga ki te whare o Hahona, ka mea kia whaka­puta­ina rāua ki te iwi. ");
INSERT INTO mri_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ā, nō te kore­nga i kitea rāua ka tōia e rātou a Hahona rātou ko ētahi tēina ki ngā ranga­tira o te pā, ka karanga, “Kua tae mai ki konei ngā tāngata i whaka­tutū­ngia ai te ao; ");
INSERT INTO mri_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","kua puri­tia hoki e Hahona; e tika kē ana ngā mahi a tēnei hunga katoa i ngā ture a Hīhā, e mea ana, tērā atu tētahi kīngi, ko Īhu.” ");
INSERT INTO mri_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nā, ka rongo te mano rātou ko ngā ranga­tira o te pā ki ēnei mea, ka poro­raru. ");
INSERT INTO mri_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nā, ka tango rātou i ētahi moni pupuri i a Hahona rātou ko ērā atu, ā, tukua atu ana rātou. ");
INSERT INTO mri_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nā, tonoa tonu­tia atu e ngā tēina a Paora rāua ko Hira i te pō ki Peria; i tō rāua taenga atu, ka haere ki te whare kara­kia o ngā Hūrai. ");
INSERT INTO mri_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Engari, ēnei i nui atu te āhua ranga­tira i tō ngā tāngata o Teharonika, i hohoro tonu rātou te tango i te kupu, ā, i tēnei rā, i tēnei rā, i rapu i roto i ngā karaipi­ture i te tikanga o ēnei mea. ");
INSERT INTO mri_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nā, he toko­maha o rātou i whaka­pono; kīhai hoki i toko­iti ngā wāhine ranga­tira o ngā Kariki, me ngā tāne hoki. ");
INSERT INTO mri_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Otirā, i te mōhio­tanga o ngā Hūrai o Teharonika, tērā te kupu a te Atua te kauwhau­tia ana e Paora ki Peria, ka haere hoki rātou ki reira ki te whaka­oho, ki te whaka­raru­raru i ngā mano. ");
INSERT INTO mri_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nā, tonoa tonu­tia atu e ngā tēina a Paora kia haere tae noa ki te moana; ko Hira ia rāua ko Tīmoti i noho ki reira. ");
INSERT INTO mri_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nā, ka kawea a Paora e ōna kai­ārahi ki Atene; ā, ka riro he kupu ki a Hira rāua ko Tīmoti kia hohoro te haere ki a ia, ka hoki rātou. ");
INSERT INTO mri_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nā, i a Paora e tatari ana ki a rāua i Atene, ka oho tōna wairua i roto i a ia, i tāna kite­nga i te pā e kī ana i te whaka­pakoko. ");
INSERT INTO mri_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nā, totohe ana ia i roto i te whare kara­kia ki ngā Hūrai rātou ko ngā tāngata kara­kia, i te kāinga hoko hoki i ngā rā katoa ki ngā tāngata i pono ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ā, ka nga­ngare ki a ia ētahi tohu­nga o ngā Epikureana, o ngā Toika. Ko ētahi i mea, “He aha tā tēnei tangata kōrero­rero e mea nei?” I mea ētahi, “Me te mea he kai­whaka­puaki ia i ētahi atua tauhou.” Mō tāna kauwhau i a Īhu, i te aranga, ki a rātou. ");
INSERT INTO mri_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nā, ka mau rātou ki a ia, ka kawea ki Areopaka, ka mea, “Kia mōhio mātou, he aha rānei tēnei ako hou e kōrero­tia nei e koe? ");
INSERT INTO mri_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Poka kē hoki ngā mea e mauria mai nei e koe ki ō mātou tari­nga; koia mātou i mea ai kia mōhio, he aha ēnei mea.” ");
INSERT INTO mri_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ka mutu hoki tā ngā tāngata katoa o Atene, rātou ko ngā manu­hiri e noho ana i reira, e wātea ai, ko te kōrero rānei, ko te whaka­rongo rānei ki tētahi mea hou. ");
INSERT INTO mri_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nā, ka tū a Paora i waenga­nui o Areopaka, ka mea, “E ngā tāngata o Atene, i ngā mea katoa ka kite ahau he āhua nui kē tō koutou wehi ki ngā atua māori. ");
INSERT INTO mri_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","I ahau hoki e hāere­ere ana, e mā­taki­taki ana i ngā mea e kara­kia nei koutou, ka kite ahau i tētahi āta, i tuhia nei a runga, ‘Ki te Atua Ngaro’. Heoi, ko tā koutou e kara­kia kūware nei, ko ia tāku e whaka­atu nei ki a koutou. ");
INSERT INTO mri_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ko te Atua, nāna nei i hangā te ao me ngā mea katoa i roto, ko ia nei te Ariki o te rangi, o te whenua, e kore ia e noho ki ngā whare i hangā e te ringa. ");
INSERT INTO mri_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","E kore anō e mahia he mea māna e te ringa tāngata, me te mea he mate nōna ki tētahi aha rānei, ko ia hoki hei hōmai i te ora, i te manawa, i ngā mea katoa, ki ngā tāngata katoa. ");
INSERT INTO mri_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kotahi anō te toto i hangā ai e ia ngā iwi katoa o ngā tāngata, hei noho ki te mata katoa o te whenua, nāna hoki i whaka­takoto ō rātou wā i whaka­ritea i mua, me ngā kaha o tō rātou nohoa­nga. ");
INSERT INTO mri_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kia rapu ai rātou i te Atua, me kore e whā­whā, e kite i a ia, ahakoa rā kāhore ia i matara atu i a tātou katoa. ");
INSERT INTO mri_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Nāna hoki tātou i ora ai, i kori­kori ai, i noho ai.’ I pērā hoki te kōrero a ētahi o ō koutou kai­tito, ‘Ko tātou hoki tōna uri.’ ");
INSERT INTO mri_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nā, he uri nei tātou nō te Atua, e kore e tika kia mea tātou, kei te rite te Atua ki te kōura, ki te hiriwa, ki te kōhatu, ki te mea i whaka­iroa e te mōhio, e te whaka­aro o te tangata. ");
INSERT INTO mri_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nā, kāhore i whaka­aroa e te Atua ngā wā o te kūware­tanga; ināia­nei ia kua whaka­hau ia i ngā tāngata katoa o ngā wāhi katoa kia rīpe­netā. ");
INSERT INTO mri_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kua rite hoki i a ia he rā e whaka­wā ai ia i te ao i runga i te tika, arā mā te tangata kua whaka­ritea nei e ia; kua tukua nei hoki he tohu ki ngā tāngata katoa, i tāna whaka­ara­hanga i a ia i te hunga mate!” ");
INSERT INTO mri_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nā, ka rangona e rātou te aranga o te hunga mate, ka tāwai ētahi; ko ētahi i mea, “Taihoa mātou e whaka­rongo anō ki tēnei mea i a koe.” ");
INSERT INTO mri_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Heoi, puta atu ana a Paora i waenga­nui i a rātou. ");
INSERT INTO mri_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ko ētahi tāngata ia i piri ki a ia, i whaka­pono; i roto i a rātou a Rionaihia nō Areopaka, ko tētahi wahine, ko Ramari te ingoa, rātou ko ētahi atu. ");
INSERT INTO mri_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Muri iho i ēnei mea ka haere atu a Paora i Atene, ka tae ki Koriniti. ");
INSERT INTO mri_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nā, ka kite ia i tētahi Hūrai ko Akuira te ingoa, i whānau ki Ponoto, he mea tae hou mai i Itari, rāua ko tāna wahine, ko Pirihira; kua whaka­haua hoki e Karau­ria kia haere atu ngā Hūrai katoa i Roma. Ā, ka haere ia ki a rāua, ");
INSERT INTO mri_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ā, nō te mea kotahi tā rātou mahi, ka noho ia ki a rāua ka mahi rātou; he tui tēneti hoki tā rāua mahi. ");
INSERT INTO mri_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nā, ka kōrero­rero ia i roto i te whare kara­kia i ngā hāpati katoa, e tohe ana ki ngā Hūrai rātou ko ngā Kariki. ");
INSERT INTO mri_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nō te taenga mai ia o Hira rāua ko Tīmoti i Makeronia, ka tākare te ngākau o Paora, ka whaka­puaki ki ngā Hūrai ko Īhu te Karaiti. ");
INSERT INTO mri_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Heoi, i a rātou ka whaka­tika, ka kohu­kohu, ka ruia e ia ōna kākahu, ka mea ki a rātou, “Hei runga i ō koutou māte­nga ō koutou toto; ka mā ahau. Ko tēnei ka haere ahau ki ngā tauiwi.” ");
INSERT INTO mri_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nā, ka haere atu ia i reira, ka tomo ki te whare o tētahi tangata, ko Taituha Hutuha te ingoa, he tangata kara­kia ki te Atua; ko tōna whare i tata tonu ki te whare kara­kia. ");
INSERT INTO mri_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nā, ka whaka­pono a Kirihipu, te ranga­tira o te whare kara­kia, me tōna whare katoa ki te Ariki; he toko­maha hoki ngā Koriniti, i a rātou ka rongo, i whaka­pono, i iri­iria hoki. ");
INSERT INTO mri_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ā, ka kōrero moe­moeā te Ariki ki a Paora i te pō, “Kaua e wehi, engari me kōrero, kei noho puku; ");
INSERT INTO mri_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kei a koe hoki ahau, e kore hoki tētahi tangata e pā ki a koe, e hoatu i te kino ki a koe. He nui hoki āku tāngata i tēnei pā.” ");
INSERT INTO mri_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nā, kotahi te tau e ono marama i noho ai ia i reira, i whaka­ako ai i te kupu a te Atua i roto i a rātou. ");
INSERT INTO mri_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nā, i a Kario e noho ana hei kāwana mō Akāia, kotahi tonu whaka­tikanga o ngā Hūrai ki a Paora, ā, kawea ana ia ki te nohoa­nga whaka­wā, ");
INSERT INTO mri_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ka mea, “E kukume ana tēnei i ngā tāngata ki tētahi kara­kia ki te Atua e poka kē ana i tā te ture.” ");
INSERT INTO mri_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ā, e mea tonu ana te māngai o Paora ki te puaki, ka mea a Kario ki ngā Hūrai, “E ngā Hūrai, me­he­mea ko tētahi hanga hē, ko tētahi mahi kino rānei, he tika kia āta whaka­rongo ahau ki a koutou. ");
INSERT INTO mri_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ko tēnei he totohe kōrero, he mea ki ngā ingoa, ki tā koutou ture, kei a koutou te whaka­aro; e kore hoki ahau e pai kia waiho ahau hei kai­whaka­wā mō ēnā mea.” ");
INSERT INTO mri_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nā, peia atu ana rātou e ia i te nohoa­nga whaka­wā. ");
INSERT INTO mri_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nā, ka mau ngā Kariki katoa ki a Hotene, ranga­tira o te whare kara­kia, ā, whiua ana ia i mua o te nohoa­nga whaka­wā. Heoi, kīhai a Kario i whaka­aro ki tētahi o ēnei mea. ");
INSERT INTO mri_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ā, ka maha ngā rā i noho ai a Paora, ka poro­poro­aki ia ki ngā tēina, ā, rere ana ki Hīria, rātou ko Pirihira ko Akuira. He mea more­more tōna ūpoko i Kenekerea; he kī tau­rangi hoki nāna. ");
INSERT INTO mri_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ā, ka tae rātou ki Epeha, ka mahue rāua i a ia ki reira. Ko ia i tomo ki te whare kara­kia, kōrero­rero ai ki ngā Hūrai. ");
INSERT INTO mri_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ā, i tā rātou mea­tanga kia roa atu te wā e noho ai ia ki a rātou, kīhai ia i whaka­ae. ");
INSERT INTO mri_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Heoi, poro­poro­aki ana ki a rātou, ka mea, “E hoki mai anō ahau ki a koutou, ki te pai te Atua.” Ā, rere atu ana ia i Epeha. ");
INSERT INTO mri_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ā, nō ka ū ia ki Hiha­ria, ka haere atu ka oha ki te hāhi, ā, haere ana ki Anatioka. ");
INSERT INTO mri_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ā, roa­roa iho ki reira, ka haere, ā, hāere­erea mārie­tia ana e ia te whenua Karatia, o Pirikia, me te whakaū i ngā ākonga katoa. ");
INSERT INTO mri_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nā, ka haere mai tētahi Hūrai ki Epeha, ko Aporo te ingoa, i whānau ki Arēhānaria, he pū kōrero, he tangata kaha ki ngā karaipi­ture. ");
INSERT INTO mri_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","I whaka­akona tēnei tangata ki te ara o te Ariki; he tangata ia e toko tonu ake ana te ngākau, ka kōrero ia, tika tonu hoki tāna whaka­ako i ngā mea mō Īhu; heoi anō, tāna i mātau ai ko te iri­iri a Hoani. ");
INSERT INTO mri_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ka anga ia ka kōrero nui i roto i te whare kara­kia. Nō te rongo­nga o Akuira rāua ko Pirihira ki a ia, ka mau rāua ki a ia, ka āta whaka­atu ki a ia i te ara o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ā, nō ka mea ia kia haere ki Akāia, ka tau­tokona ia e ngā tēina, ā, ka tuhi­tuhi rātou ki ngā ākonga kia whaka­manu­hiri­tia ia e rātou. Ā, nō tōna taenga atu, ka whaka­kaha­ngia e ia te hunga i meinga nei e te aroha noa kia whaka­pono. ");
INSERT INTO mri_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kaha rawa hoki tāna whawhati i tā ngā Hūrai i roto i te hui­hui; whaka­atu­ria ana e ia tā ngā karaipi­ture mō Īhu, ko te Karaiti ia. ");
INSERT INTO mri_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","I a Aporo i Koriniti, ka puta atu a Paora nā ngā wāhi o runga, ka tae ki Epeha, ā, tūpono atu ko ētahi ākonga. ");
INSERT INTO mri_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ā, ka mea ki a rātou, “I riro rānei te Wairua Tapu i a koutou i tō koutou whaka­pono­tanga?” Anō rā, ko rātou ki a ia, “Kāhore, kīanō mātou i rongo noa me­he­mea te Wairua Tapu i hōmai.” ");
INSERT INTO mri_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ka mea ia ki a rātou, “I iri­iria oti koutou ki roto ki te aha?” Ka mea rātou, “Ki roto ki tā Hoani iri­iri.” ");
INSERT INTO mri_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nā, ka mea a Paora, “Ko tā Hoani iri­iri he iri­iri rīpe­netā. I mea ia ki te iwi, kia whaka­pono rātou ki tētahi e haere mai ana i muri i a ia, arā ki a Īhu.” ");
INSERT INTO mri_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ā, ka rongo rātou i tēnei, ka iri­iria i runga i te ingoa o te Ariki, o Īhu. ");
INSERT INTO mri_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nā, ka oti te whaka­pā e Paora ōna ringa ki runga ki a rātou, ka tae mai te Wairua Tapu ki a rātou; nā, ka kōrero­tia e rātou ngā reo, ka poro­piti hoki. ");
INSERT INTO mri_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ā, ko tō rātou toko­maha kei te tekau mā rua. ");
INSERT INTO mri_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nā, ka tomo ia ki te whare kara­kia, ka kōrero māia atu, e toru ngā marama i kōrero­rero ai, i kukume ai ki ngā mea o te ranga­tira­tanga o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ā, ka pakeke ētahi, ka whaka­teka, ka whaka­hāwea ki taua rite­nga i te aro­aro o te mano, ka mawehe atu ia i roto i a rātou, ka wehea kētia ngā ākonga, ka kōrero­rero i tēnei rā, i tēnei rā, i roto i te kura o Tairanu. ");
INSERT INTO mri_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nā, e rua ōna tau i pēnei ai; ā, ka rongo katoa te hunga e noho ana i Āhia, ngā Hūrai, ngā Kariki, i te kupu a te Ariki, a Īhu. ");
INSERT INTO mri_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nā, ehara i te mere­kara noa ake a te Atua i mea ai kia meatia e ngā ringa o Paora; ");
INSERT INTO mri_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ina hoki, i te mau­ranga atu i ngā aikiha me ngā ārai i tōna tinana ki te hunga mate, mutu ake ō rātou mate, ā, puta atu ana ngā wairua kino i roto i a rātou. ");
INSERT INTO mri_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kātahi, ka anga ētahi o ngā Hūrai hāere­ere noa, he hunga pei wairua, ka whaka­hua i te ingoa o te Ariki, o Īhu ki runga ki ētahi i ngā wairua kino, ka mea, “He whaka­hua tēnei nā mātou ki a koutou i a Īhu, i tā Paora e kauwhau nei.” ");
INSERT INTO mri_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nā, i pērā anō ngā tama toko­whitu a tētahi Hūrai, a Hewa, he tohu­nga nui ia. ");
INSERT INTO mri_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nā, ka whaka­hoki te wairua kino, ka mea ki a rātou, “E mōhio ana ahau ki a Īhu, e mātau ana ki a Paora; ko koutou ia, ko wai rā?” ");
INSERT INTO mri_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nā, ko te tū­peke­tanga o te tangata i a ia nei te wairua kino ki a rātou, kua kaha i a rātou, taea ana rātou e ia, nō ka oma ta­ha­nga rātou, ka oma mamae atu i taua whare. ");
INSERT INTO mri_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ā, ka mōhio­tia tēnei e ngā tāngata katoa e noho ana i Epeha, e ngā Hūrai rātou tahi ko ngā Kariki; ā, ka tau te wehi ki a rātou katoa, ā, whaka­nuia ana te ingoa o te Ariki, o Īhu. ");
INSERT INTO mri_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ā, he toko­maha o te hunga whaka­pono i haere mai, i whāki, i whaka­kite i ā rātou mahi. ");
INSERT INTO mri_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","He toko­maha anō o te hunga i mahi i ngā mahi tini­hanga, i hui­hui i ā rātou puka­puka, ā, tahuna ana i te aro­aro o te katoa. Ā, ka taua ngā utu o aua puka­puka, ka kitea e rima tekau mano hiriwa. ");
INSERT INTO mri_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Koia anō te nui o te tupu o te kupu a te Atua, te kaha. ");
INSERT INTO mri_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ā, nō ka rite ēnei mea, ka mea a Paora i roto i tōna wairua, kia tika nā Makeronia, nā Akāia, kia haere ki Hiruhārama; i mea ia, “Ka tae ahau ki reira, ko Roma anō tāku e tiki ai e ti­tiro.” ");
INSERT INTO mri_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ā, toko­rua āna i tono ai ki Makeronia o te hunga e mahi ana ki a ia, ko Tīmoti rāua ko Eratu; ko ia i noho iho i Āhia mō tētahi wā. ");
INSERT INTO mri_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nā, i taua wā kīhai i nohi­nohi te nga­ngau i puta ake mō taua Ara. ");
INSERT INTO mri_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tērā hoki tētahi tangata, ko Rimitiriu te ingoa, he kai­mahi hiriwa, nāna nei i hanga ngā teme­para hiriwa o Riana, kīhai hoki i no­nohi ngā utu i tika mai i tāna mahi ki ngā kai­hanga. ");
INSERT INTO mri_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nā, ka whaka­minea rātou e ia me ērā kai­mahi o ngā pērā, ā, ka mea, “E mara mā, e mātau ana koutou, nō tēnei mahi ā tātou rawa. ");
INSERT INTO mri_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nā, e kite ana, e rongo ana koutou, ehara i te mea ko Epeha anake, engari he iti te wāhi o Āhia katoa kua mahue nei i tēnei Paora te kukume, te whaka­peau kē i te tini o te tangata, e mea ana ia, ‘Ehara ēnei i te atua, e hangā nei e te ringa.’ ");
INSERT INTO mri_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nā, ehara i te mea ko tō tātou nei wāhi anake ka tata te kore noa iho; tērā anō hoki e whaka­kāhore­tia te teme­para o te atua nui, o Riana, ā, meāke memeha noa iho tōna nui, e karakia­tia nei e Āhia katoa, e te ao.” ");
INSERT INTO mri_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ā, nō tō rātou rongo­nga, ā, ka kī i te riri, ka karanga ake, ka mea, “He nui a Riana o ngā Epehi!” ");
INSERT INTO mri_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nā, ka tutū te puehu o te pā katoa, ā, ka oti te hopu e rātou a Kaiu rāua ko Aritaku, he hunga nō Makeronia, he hoa haere nō Paora, nā, kotahi tonu tā rātou kōkiri­tanga ki te whare mā­taki­taki. ");
INSERT INTO mri_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ā, i a Paora e mea ana kia tomo ki roto ki te iwi, kīhai ia i tukua e ngā ākonga. ");
INSERT INTO mri_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nā, ka unga tāngata mai ētahi o ngā ranga­tira o Āhia, i pai nei ki a ia, ka mea kia kaua ia e tuku i a ia ki roto ki te whare mā­taki­taki. ");
INSERT INTO mri_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Heoi, puta kē te karanga a ētahi, puta kē a ētahi; tino raru­raru hoki taua whaka­mine­nga; ko te nuinga kīhai i mātau ki te mea i hui­hui ai rātou. ");
INSERT INTO mri_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nā, ka mauria e rātou a Arēhanara i roto i te hui, nā ngā Hūrai ia i mea kia whaka­tika atu. Ā, tā­whiri ana te ringa o Arēhānara, i mea hoki kia kōrero­tia e ia tā rātou ki te iwi. ");
INSERT INTO mri_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Heoi, ka mātau rātou he Hūrai ia, kotahi tonu te reo o te katoa ki te karanga, ā tata noa ki te rua ngā hāora, “He nui a Riana o ngā Epehi!” ");
INSERT INTO mri_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ā, ka māriri iho te hui­hui i te kai­whaka­wā, ka mea ia, “E ngā Epehi, ko wai te tangata kāhore e mōhio ko te pā o ngā Epehi te kai­tiaki teme­para o te atua nui, o Riana, o te whaka­pakoko anō hoki i taka iho i a Hupita? ");
INSERT INTO mri_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nā, ka kore nei ēnei mea e taea te whākore­kore, heoi, kia āta noho, kaua hoki e hīkaka te mahi. ");
INSERT INTO mri_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kua āra­hina mai nei hoki e koutou ēnei tāngata ki konei, ehara nei i te hunga tāhae mea tapu, ehara hoki i te hunga kohu­kohu ki tō tātou atua. ");
INSERT INTO mri_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nā, ki te mea he kupu tā Rimitiriu rātou ko ōna hoa mahi mō tētahi tangata, e taea te whaka­wā, ā, tēnei anō ngā kāwana; mā rātou rātou e whaka­wā. ");
INSERT INTO mri_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nā, ki te mea he mea kē tā koutou e whai nā, waiho mā te rū­nanga tika te rite­nga. ");
INSERT INTO mri_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ko wai hoki ka tohu? Tērā pea tātou e whaka­wā­kia mō tēnei nga­ngau­tanga o nāia­nei, kāhore nei ōna take; kāhore hoki he take e tika ai tā tātou kōrero mō tēnei hui­hui.” ");
INSERT INTO mri_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ā, nō ka puaki ēnei kupu āna, ka tonoa atu e ia te whaka­mine­nga. ");
INSERT INTO mri_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ā, nō te mutu­nga o te nga­ngau, ka karanga­tia e Paora ngā ākonga, ka tohu­tohu i a rātou, ka poro­poro­aki, ā, tūria atu ana e ia, haere ana ki Makeronia. ");
INSERT INTO mri_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ā, ka hāere­erea e ia aua wāhi, me te whaka­hau i a rātou ki ngā kupu maha, ā, haere ana ia ki Kariki; ");
INSERT INTO mri_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ā, ka toru ōna marama ki reira. I ngā Hūrai anō e whaka­takoto whaka­aro ana mōna, i a ia meāke rere ki Hīria, ka whaka­aro ia kia hoki mā Makeronia. ");
INSERT INTO mri_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ā, i haere tahi i a ia tae noa ki Āhia, a Hopate o Peria, te tama a Piru; a Aritaku rāua ko Hekunu o Teharonika; a Kaiu o Rerepe; a Tīmoti hoki rātou ko Tikiku, ko Toropimu o Āhia. ");
INSERT INTO mri_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Otirā, kua haere atu ēnei i mua, ā, e tatari mai ana ki a mātou i Toroa. ");
INSERT INTO mri_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nā, i te mutu­nga o ngā rā o te Taro Rēwenakore ka rere atu mātou i Piripai, ā, pō rima ka tae atu ki a rātou ki Toroa, ā, e whitu ngā rā i noho ai ki reira. ");
INSERT INTO mri_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nā i te rā tua­tahi o te wiki, i te mea kua hui­hui mātou ki te whawhati taro, ka kauwhau a Paora ki a rātou, e mea ana hoki ki te haere i te aonga ake; ā, ka kūmea roatia tāna kōrero ā waenga­nui pō rā anō. ");
INSERT INTO mri_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ā, he maha ngā rama i te rūma i runga, i te wāhi i hui­hui ai mātou. ");
INSERT INTO mri_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nā, tērā tētahi tai­tama­riki, ko Ūtiku te ingoa, i te mata­pihi e noho ana, kua tino para­ngia e te moe; ā, ka roa tonu te kauwhau a Paora, nā, ka pēhia rawa­tia ia e te moe, nā, ka taka iho i te toru o ngā whaka­papa­ranga o ngā rūma, tango­hia rawa­tia ake kua mate. ");
INSERT INTO mri_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nā, ka heke iho a Paora, ā, hinga ana ki runga ki a ia, awhi ana i a ia, ka mea, “Kei nga­ngau koutou; kei roto hoki i a ia tōna wairua.” ");
INSERT INTO mri_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nā, ka kake atu anō ia, ka whawhati taro, ka kai, ā, ka roa rawa te kōrero ā pūao noa, ka haere. ");
INSERT INTO mri_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Heoi, āra­hina oratia atu ana e rātou taua tai­tama, kīhai hoki i nohi­nohi te koa. ");
INSERT INTO mri_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nā, ko mātou kua riro i mua ki te kai­puke, ā, rere ana ki Aho, i mea kia utaina a Paora i reira; nāna hoki i whaka­rite, i mea hoki ko ia me rā uta. ");
INSERT INTO mri_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ā, ka tūtaki ki a mātou ki Aho, ka utaina ia, ā, rere ana mātou ki Mitirini. ");
INSERT INTO mri_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Rere atu ana mātou i reira, ā, i te aonga ake ka taea te rite­nga atu o Kio; ao ake anō ka ū ki Hamo, ā, noho ana ki Torokiriuma; ao ake anō ka ū ki Miretu. ");
INSERT INTO mri_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","I mea hoki a Paora kia rere i waho ake o Epeha, kei roa ia ki Āhia; i pōrangi hoki me kore e roko­hanga atu ia e te rā o te Petekoha ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nā, ka tono tāngata atu ia i Miretu ki Epeha, hei tiki i ngā kaumātua o te hāhi. ");
INSERT INTO mri_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ā, nō tō rātou taenga mai ki a ia, ka mea ia ki a rātou, “E mātau ana koutou ki tāku tikanga i roto i a koutou i ngā rā katoa, nō te rā tua­tahi iho anō o tōku taenga mai ki Āhia, ");
INSERT INTO mri_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","pāpaku noa iho te ngākau i mahi ai ahau ki te Ariki, he maha ia ngā roi­mata me ngā whaka­mā­tau­tau i pā ki ahau, i ngā Hūrai e whaka­takoto whaka­aro ana mōku. ");
INSERT INTO mri_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kīhai i puri­tia e ahau tētahi o ngā mea pai i whaka­kitea atu anō ki a koutou i ākona nuitia ki a koutou, i tēnei whare, i tēnei whare. ");
INSERT INTO mri_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","I kauwhau­tia hoki ki ngā Hūrai ki ngā Kariki, te rīpe­netā whaka te Atua, me te whaka­pono ki tō tātou Ariki, ki a Īhu Karaiti. ");
INSERT INTO mri_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nā, tēnei ahau te haere nei ki Hiruhārama, he here­here­nga nā te wairua, kāhore hoki e mōhio ki ngā mea e pā ki ahau i reira. ");
INSERT INTO mri_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Heoi anō, ko tā te Wairua Tapu e whaka­atu nei ki ahau i tēnei pā, i tēnei pā, e mea ana, kei te tāria mai ahau e ngā meka­meka, e ngā mate. ");
INSERT INTO mri_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Otirā, kāhore ahau e ihu­puku ki te ora, hei painga ki ahau ake, engari, kia taea tāku e whai nei, me te mahi i hōmai ki ahau e te Ariki, e Īhu, arā kia whaka­atu­ria te rongo­pai o te aroha noa o te Atua. ");
INSERT INTO mri_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nā, e mōhio ana tēnei ahau, heoi anō, kite­nga o tōku mata e tētahi o koutou, e te hunga i kauwhau haere nei ahau i te ranga­tira­tanga o te Atua i roto i a koutou. ");
INSERT INTO mri_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Koia ahau ka mea nei ki a koutou āia­nei, Kāhore ōku poke i ngā toto o tētahi tangata. ");
INSERT INTO mri_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kīhai hoki ahau i manawa­pā ki te kauwhau i te whaka­aro katoa o te Atua ki a koutou. ");
INSERT INTO mri_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nā, kia tūpato ki a koutou, ki te kāhui katoa anō i meinga ai koutou e te Wairua Tapu hei kai­tiro­tiro, whāngaia te hāhi a te Atua i hokona nei e ia ki ōna ake toto. ");
INSERT INTO mri_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","E mōhio ana hoki ahau ki tēnei ka riro ahau tērā e puta mai ki a koutou he wuruhi nana­kia, e kore nei e tohu i te kāhui. ");
INSERT INTO mri_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ā, ka whaka­tika ake ētahi tāngata i roto i a koutou anō, kōrero ai i ngā mea parori kē, hei kukume i ngā ākonga kia whai i a rātou. ");
INSERT INTO mri_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nā reira, kia mata­ara, kia mahara anō ki ngā tau e toru kīhai nei ahau i māngere i te pō, i te ao, ki te whaka­tūpato i tēnei, i tēnei o koutou, me te tangi anō ahau. ");
INSERT INTO mri_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nā, tēnei ahau, te tuku nei i a koutou ki te Atua, ki te kupu hoki o tōna aroha noa, e kaha nei ki te whaka­tupu ake, ki te hoatu hoki i tētahi wāhi ki a koutou i roto i te hunga katoa kua oti te whaka­tapu. ");
INSERT INTO mri_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kīhai i hia­hia­tia e ahau te hiriwa, te kōura, te kākahu rānei, o tētahi. ");
INSERT INTO mri_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","E mōhio ana anō koutou, nā ēnei ringa i mahi ngā mea i matea e ahau, e ōku hoa hoki. ");
INSERT INTO mri_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","I ngā mea katoa i hoatu ahau he tauira ki a koutou, kia pēnei tā koutou mahi kia ata­whai­tia ai e koutou te hunga ngoi­kore, me te mahara ki ngā kupu a te Ariki, a Īhu, i mea rā ia, ‘Ko te whaka­whi­whi, nui atu te hari i tō te whi­whi.’ ” ");
INSERT INTO mri_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","I te mutu­nga o tēnei whai kupu āna ka tukua ōna turi ki raro, ka īnoi tahi ia me rātou katoa. ");
INSERT INTO mri_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","He nui hoki te tangi o te katoa; hinga iho rātou ki runga ki te kakī o Paora, ka kihi i a ia; ");
INSERT INTO mri_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","i tino mamae pū hoki rātou i te kupu i mea ai ia, heoi anō, tō rātou kite­nga i tōna mata. Nā, ka ārahi rātou i a ia ki te kai­puke. ");
INSERT INTO mri_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Heoi, ka wehe mātou i a rātou, ka rere, ā, tika tonu atu, tae noa ki Koha, ā, ao ake te rā kei Roro, i reira atu ki Pātara. ");
INSERT INTO mri_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nā, ka roko­hanga tētahi kai­puke e whaka­whiti atu ana ki Pini­kia, ā, eke ana mātou ki runga, rere ana. ");
INSERT INTO mri_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ā, ka kitea Kai­peru, ka mahue ake i te taha ki mauī, ka rere atu mātou ki Hīria, ā, ka ū ki Tāira; hei reira hoki te kai­puke ruke ai i tōna utanga. ");
INSERT INTO mri_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ā, ka kitea ngā ākonga, e whitu ngā rā i noho ai mātou ki reira. Ka kōrero hoki rātou ki a Paora, he mea nā te Wairua, kia kaua ia e haere ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ā, ka rite aua rā o mātou, ka puta atu mātou, ka haere; me te kawe anō rātou katoa, me ngā wāhine, me ngā tama­riki, i a mātou ā waho rā anō o te pā. Nā, ka tukua ō mātou turi ki te taha­tai, ka īnoi; ");
INSERT INTO mri_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","kātahi ka poro­poro­aki mātou tētahi ki tētahi; ā, eke ana mātou ki te kai­puke; ko rātou ia i hoki ki ō rātou kāinga. ");
INSERT INTO mri_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ā, ka tutuki tō mātou rere­nga atu i Tāira, ka tae ki Toromai, nā, ka oha atu ki ngā tēina, ā, kotahi te rā i noho ai ki a rātou. ");
INSERT INTO mri_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","I te aonga ake ka tūria atu e mātou, ka haere ki Hiha­ria; ā, tomo ana ki te whare o Piripi kai­kauwhau, ko ia nei tētahi o ngā toko­whitu; noho ana i a ia. ");
INSERT INTO mri_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nā, toko­whā ngā tamā­hine a taua tangata, he wāhina, he poro­piti. ");
INSERT INTO mri_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ā, ka maha ō mātou rā i noho ai, ka haere mai tētahi poro­piti i Hūria, ko Akapu te ingoa. ");
INSERT INTO mri_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ā, nō tō rātou taenga mai ki a mātou, ka mau ki te whī­tiki o Paora, herea iho e ia ōna ake ringa me ōna wae­wae, ka mea, “Ko tā te Wairua Tapu kōrero tēnei, E pēnei­tia te here te tangata nōna tēnei whī­tiki e ngā Hūrai i Hiruhārama, e tukua atu anō ia ki ngā ringa o ngā tauiwi.” ");
INSERT INTO mri_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Heoi, i tō mātou rongo­nga i ēnei mea, ka tohe mātou ko ngā tāngata o taua kāinga, kia kaua ia e haere ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nā, ko te whaka­hoki­nga a Paora, “He aha tā koutou e tangi, e whaka­ngākau­kore nei i ahau? Ehara hoki i te mea ko te here anake tāku e pai ai, engari ko te mate anō hoki ki Hiruhārama, mō te ingoa o te Ariki, o Īhu.” ");
INSERT INTO mri_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ā, nō tōna kore­nga i rongo, ka mutu tā mātou, ka mea, “Kia meatia tā te Ariki e pai ai.” ");
INSERT INTO mri_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ā, ka pahemo ēnei rā, ka takai mātou i ā mātou mea, ā, haere ana ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","I haere tahi anō i a mātou ētahi o ngā ākonga o Hiha­ria; nā rātou i mau ake a Nahona o Kai­peru, he ākonga tawhito hei tuku­nga atu mō mātou. ");
INSERT INTO mri_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ā, i tō mātou taenga ki Hiruhārama, ka koa ngā tēina ki a mātou. ");
INSERT INTO mri_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","I te aonga ake, ka haere tahi mātou ko Paora ki a Hēmi; i reira anō ngā kaumātua katoa. ");
INSERT INTO mri_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nā, ka oha ia ki a rātou, ka kōrero­tia taki­tahi­tia ngā mea i mea ai te Atua kia mahia e ia i roto i ngā tauiwi. ");
INSERT INTO mri_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nō tō rātou rongo­nga, ka whaka­korōria i te Atua, ka mea ki a ia, “Kua kite koe, e tō mātou teina, i ngā mano tini o ngā Hūrai kua whaka­pono nei; e uaua katoa ana hoki ki te ture. ");
INSERT INTO mri_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kua rongo anō hoki rātou ki a koe, e whaka­ako ana koe i ngā Hūrai katoa i roto i ngā tauiwi, kia whaka­rērea a Mohi, e mea ana kia kaua rātou e kokoti i ngā tama­riki, kia kaua anō e haere i runga i ngā rite­nga o mua. ");
INSERT INTO mri_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nā, me pēhea? E kore hoki e kore ka rongo rātou ki tōu taenga mai. ");
INSERT INTO mri_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nā, me mea e koe tēnei e kōrero­tia nei e mātou ki a koe. Toko­whā e mātou tāngata, he kupu tau­rangi tā rātou. ");
INSERT INTO mri_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tango­hia ēnei, kia purea ngā­tahi­tia koutou, māu anō e utu ā rātou mea, kia waru­hia ai ō rātou māte­nga. Ā, ka kite rātou katoa he teka noa ngā mea i kōrero­tia mōu; engari ko koe, he tika tāu haere, kei te whaka­rite anō koe i te ture. ");
INSERT INTO mri_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tēnā ko ngā tauiwi kua whaka­pono, kua tuhi­tuhi atu mātou, kua whaka­takoto tikanga atu, kia tūpato rātou i ngā mea e patua ana mā ngā whaka­pakoko, i te toto, i te mea kua nōtia te kakī, i te moe tāhae.” ");
INSERT INTO mri_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nā, ka mau a Paora ki aua tāngata, ā, i te aonga ake ka pure tahi, ka haere tahi rātou ki roto ki te teme­para, hei whaka­atu ka whaka­ritea ngā rā mō te pure­nga, kia whaka­herea rā anō he whaka­here mō tētahi, mō tētahi o rātou. ");
INSERT INTO mri_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Heoi, ka tata ngā rā e whitu te taka, ka kitea ia i roto i te teme­para e ētahi Hūrai o Āhia; nā rātou i whaka­oho te mano katoa, ā, ka pā ō rātou ringa ki a ia, ");
INSERT INTO mri_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ka karanga, “E ngā tāngata o Īharaira, āwhina­tia mai! Ko te tangata tēnei e whaka­ako nei i ngā tāngata katoa o ngā wāhi katoa ki ngā mea whaka­hē mō te iwi, mō te ture, mō tēnei kāinga hoki. Kua kawea mai anō e ia ētahi Kariki ki roto ki te teme­para, ā, ka noa nei i a ia tēnei wāhi tapu.” ");
INSERT INTO mri_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","I kite hoki rātou i mua he hoa nōna i roto i te pā, ko Toropimu o Epeha; tohu noa rātou, kua mauria mai ia e Paora ki roto ki te teme­para. ");
INSERT INTO mri_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nā, ka oho te pā katoa, ka oma ngā tāngata. Ā, ka mau rātou ki a Paora, tōia ana ia ki waho o te teme­para; tū­taki­na tonu­tia atu ngā tatau. ");
INSERT INTO mri_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nā, i a rātou e whai ana kia patua ia, ka tae te rongo ki te ranga­tira mano o te hapū hōia, kua tutū te puehu i Hiruhārama katoa. ");
INSERT INTO mri_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nā, hohoro tonu tāna mau ki ētahi hōia, ki ētahi kene­turio, ā, oma iho ana ki a rātou. Ā, nō tō rātou kite­nga i te ranga­tira mano, i ngā hōia hoki, ka mutu te patu i a Paora. ");
INSERT INTO mri_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nā, ka whaka­tata mai te ranga­tira mano, ka tango i a ia, ka mea kia herea ia ki ngā meka­meka e rua; ā, ka ui ko wai ia, i aha hoki ia. ");
INSERT INTO mri_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nā, he karanga anō tā ētahi, he karanga kē tā ētahi, i roto i te mano. Nā, kīhai ia i mōhio ki te tino tikanga, i te nga­ngau hoki, ā, whaka­haua ana kia āra­hina ia ki te pā. ");
INSERT INTO mri_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ā, nō tōna taenga ki te piki­tanga, ka hiki­tia ia e ngā hōia i te tau­tute­tute­nga hoki a te tāngata; ");
INSERT INTO mri_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","i aru hoki te hui­hui o te iwi, me te karanga, “Whaka­matea ia!” ");
INSERT INTO mri_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ā, nō ka whano a Paora te kawea ki roto ki te pā, ka mea ia ki te ranga­tira mano, “E pai ana rānei kia kōrero ahau i tētahi kupu ki a koe?” Ka mea ia, “E mātau ana rānei koe ki te reo Kariki? ");
INSERT INTO mri_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ehara oti koe i te Īhipiana, nāna nei i whaka­tupu te tutū i mua ake rā, ā, mauria ana e ia ngā tāngata kōhuru e whā mano ki te koraha?” ");
INSERT INTO mri_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ka mea a Paora, “He Hūrai ahau, nō Tarahu o Kiri­kia, he tangata tupu nō taua pā, ehara hoki i te pā ingoa­kore. Nā, ko tāku īnoi tēnei ki a koe, tukua ahau kia kōrero ki te iwi.” ");
INSERT INTO mri_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nā, tukua ana e ia, ā tū ana a Paora ki te piki­tanga, ka tā­whiri tōna ringa ki te iwi. Nā, mutu pū te turi­turi, ka kōrero ia, nō ngā Hiperu te reo, ka mea: ");
INSERT INTO mri_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“E ōku tuā­kana, e ōku mātua, whaka­rongo ki tēnei kōrero āku ki a koutou.” ");
INSERT INTO mri_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ā, ka rongo rātou ko te reo Hiperu tāna i kōrero ai ki a rātou, kātahi ka mutu rawa te kīkī. Ā, ka mea ia: ");
INSERT INTO mri_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“He Hūrai ahau, i whānau ki Tarahu o Kiri­kia, i whaka­tupu­ria i roto i tēnei pā ki ngā wae­wae o Kamariera, i āta whaka­akona ki te tino tikanga o te ture o ngā mātua, i uaua anō ahau mō te Atua, i pēnā me koutou katoa ināia­nei. ");
INSERT INTO mri_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ā, whaka­toia ana e ahau ngā tāngata o tēnei Tikanga, tae ana ki te mate; herea ana e ahau ngā tāne me ngā wāhine, ā, tukua ana ki ngā whare here­here. ");
INSERT INTO mri_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mā te tohu­nga, nui tēnei kōrero āku e whaka­tika, mā te hui­hui hoki o ngā kaumātua katoa. I riro mai hoki i ahau ā rātou puka­puka ki ngā tēina, ā, haere ana ahau ki Ramahiku, kia herea, kia āra­hina mai hoki te hunga o reira ki Hiruhārama kia whaka­mamae­tia.” ");
INSERT INTO mri_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nā, i ahau e haere ana, e whaka­tata ana ki Ramahiku, i te pou­tū­mārō­tanga, ka whiti whaka­rere mai ki ahau he mārama nui nō te rangi. ");
INSERT INTO mri_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ā, hinga ana ahau ki te whenua, ka rangona he reo e mea ana ki ahau, ‘E Haora, e Haora, he aha tāu e whaka­toi nei i ahau?’ ");
INSERT INTO mri_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nā, ka whaka­hokia e ahau, ‘Ko wai koe, e te Ariki?’ Ka mea ia ki ahau, ‘Ko Īhu ahau o Nahareta, e whaka­toia nei e koe.’ ");
INSERT INTO mri_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","I kite anō ōku hoa i te mārama, otirā kīhai i rongo i te reo ōna i kōrero ki ahau. ");
INSERT INTO mri_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ka mea ahau, ‘Me aha ahau, e te Ariki?’ Ka mea te Ariki ki ahau, ‘Whaka­tika, haere ki Ramahiku; ā, ka kōrero­tia ki a koe i reira ngā mea katoa kua whaka­ritea kia meinga e koe.’ ");
INSERT INTO mri_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Heoi, i te mea kāhore ahau i kite, nā te korōria hoki o taua mārama, ka āra­hina-ā-ringa­tia ahau e ōku hoa haere, ka tae ki Ramahiku. ");
INSERT INTO mri_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Nā, ko tētahi tangata, ko Anania, he tangata kara­kia, i rite tonu nei ki tā te ture āna mahi, ā, e kōrero­tia paitia ana e ngā Hūrai katoa e noho ana i reira. ");
INSERT INTO mri_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Haere mai ana ia ki ahau, ā, tū ana i tōku taha, ka mea mai ki ahau, ‘E tōku teina, e Haora, ti­tiro ake!’ Ā, i taua hāora anō ka ti­tiro ahau ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","I mea anō ia, ‘Nā te Atua o ō tātou mātua koe i whiri­whiri, kia mātau ki tāna e pai ai, kia kite i a te Tika, kia rongo hoki i te reo o tōna māngai. ");
INSERT INTO mri_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nō te mea ko koe hei kai­whaka­atu māna ki ngā tāngata katoa, mō ngā mea i kite ai, i rongo ai koe. ");
INSERT INTO mri_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nā, he aha tāu e whaka­roa nei? Whaka­tika, kia iri­iria koe, kia horoia ōu hara, me te karanga anō ki te ingoa o te Ariki.’ ” ");
INSERT INTO mri_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ā, nō tōku hoki­nga mai ki Hiruhārama, i ahau e īnoi ana i roto i te teme­para, ka puta te ngākau mata­kite ki ahau, ");
INSERT INTO mri_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ā, ka kite ahau i a ia e mea ana mai ki ahau, ‘E āhua, kia hohoro te haere atu i Hiruhārama; e kore hoki rātou e tango i tāu kōrero mōku.’ ");
INSERT INTO mri_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nā, ko tāku mea­tanga, ‘E te Ariki, e mātau ana rātou, he kai­here­here ahau, he kai­whiu i roto i ngā whare kara­kia, i te hunga i whaka­pono ki a koe. ");
INSERT INTO mri_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ā, i te whaka­heke­nga o ngā toto o tōu kai­whaka­atu, o Tepene, i reira ahau e tū ana, e whaka­ae ana, e tiaki ana hoki i ngā kākahu o ōna kai­whaka­mate.’ ");
INSERT INTO mri_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nā, ko tāna mea­tanga ki ahau, ‘Haere. Ka ungā hoki koe e ahau ki tawhiti ki ngā tauiwi.’ ” ");
INSERT INTO mri_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ā, whaka­rongo ana rātou ki a ia taea noatia tēnei kupu, nā, ka hāmama rātou, ka mea, “Whaka­matea atu te korokē nei i runga i te whenua! E kore hoki e pai kia ora ia.” ");
INSERT INTO mri_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Heoi, i a rātou e karanga ana, e ruke­ruke ana i ō rātou kākahu, e ākiri ana i te puehu ki te rangi. ");
INSERT INTO mri_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ka whaka­hau te ranga­tira kia kawea ia ki te pā, ka mea kia whiua, kia uia; kia mātau ai ia ki te mea i pēnei ai rātou te karanga ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ā, ka oti ia te here e rātou ki ngā here, ka mea a Paora ki te kene­turio e tū ana i reira, “He mea tika rānei kia whiua e koutou te tangata, he tangata nō Roma, i te mea kāhore anō i mau noa tōna hē?” ");
INSERT INTO mri_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ā, nō te rongo­nga o te kene­turio, ka haere, ka kōrero ki te ranga­tira mano, ka mea, “He aha tāu e mea ai? Nō Roma hoki te tangata nei.” ");
INSERT INTO mri_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nā, ka haere mai te ranga­tira mano, ka mea ki a ia, “Kōrero mai ki ahau, nō Roma koe?” Ka mea ia, “Āe.” ");
INSERT INTO mri_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nā, ka whaka­hoki te ranga­tira mano, “Nā te moni nui i whi­whi ai ahau ki tēnei taonga, hei tangata whenua nō Roma.” Ka mea a Paora, “Ko ahau i whānau tonu nō Roma.” ");
INSERT INTO mri_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nā whaka­rērea tonu­tia iho ia e te hunga e mea ana ki te ui ki a ia; i mataku hoki te ranga­tira mano, tōna rongo­nga nō Roma ia, mōna hoki i here i a ia. ");
INSERT INTO mri_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nā, i te aonga ake ka mea ia kia mātau ki te tikanga, ki te mea i whaka­wā­kia ai ia e ngā Hūrai, ka wewete i ōna here, ka whaka­hau kia haere mai ngā tohu­nga nui, me tō rātou rū­nanga katoa, ā, āra­hina iho ana a Paora, whaka­tū­ria ana ki tō rātou aro­aro. ");
INSERT INTO mri_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Nā, ka ti­tiro pū a Paora ki te rū­nanga, ka mea, “E ōku tuā­kana, tika tonu ki tōku mahara tāku whaka­haere i te aro­aro o te Atua, ā taea noatia tēnei rā.” ");
INSERT INTO mri_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nā, ka mea a Anania tohu­nga nui ki te hunga e tū ana i tōna taha, kia pākia tōna māngai. ");
INSERT INTO mri_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Anō rā, ko Paora ki a ia, “Tēnei ake ka papaki te Atua i a koe, e te paki­tara kua oti te pani ki te paru mā! Ā, ka noho mai koe hei whaka­wā i ahau i tā te ture i whaka­takoto ai, me te whaka­hau anō kia pākia ahau, e hē nei tēnā ki te ture?” ");
INSERT INTO mri_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nā, ka mea te hunga e tū tata ana, “E whaka­manu­manu ana koe ki te tohu­nga nui a te Atua?” ");
INSERT INTO mri_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Anō rā ko Paora, “Kīhau ahau i mātau, e ōku tuā­kana, ko ia te tohu­nga nui; kua oti hoki te tuhi­tuhi, ‘Aua e kōrero­tia kino­tia te ranga­tira o tōu iwi.’ ” ");
INSERT INTO mri_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ā, nō ka kite a Paora nō ngā Haruki ētahi, ko ētahi nō ngā Parihi, ka karanga ia i roto i te rū­nanga, “E ōku tuā­kana, he Parihi ahau, he tama nā ngā Parihi. Ko te aranga o te hunga mate e tūmanako­hia nei te mea e whaka­wā­kia nei ahau.” ");
INSERT INTO mri_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ā, nō tāna kōrero­tanga i tēnei, ka tohe­tohe ngā Parihi rātou ko ngā Haruki; ka wahi­rua hoki te hui­hui. ");
INSERT INTO mri_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","E mea ana hoki ngā Haruki, kāhore he aranga, kāhore he ana­hera, he wairua rānei; ko ngā Parihi ia e whaka­ae ana ki aua mea e rua. ");
INSERT INTO mri_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ā, ka nui te nga­ngare; ka whaka­tika ētahi o ngā kara­ipi o tō ngā Parihi taha, ka totohe, ka mea, “Kāhore anō i mau i a mātou te hē o tēnei tangata. Tēnā, ka pēhea, me­he­mea kua kōrero tētahi wairua ki a ia, tētahi ana­hera rānei?” ");
INSERT INTO mri_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ā, nō ka nui te nga­ngau, ka mataku te ranga­tira mano kei motu­motu­hia a Paora e rātou, nā, ungā ana e ia ngā hōia kia heke atu, ki te tango mai i a ia i roto i a rātou, kia āra­hina hoki ki te pā. ");
INSERT INTO mri_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ā, i taua pō ka tū te Ariki ki tōna taha, ka mea, “Kia māia! Kia pēnā i a koe i whaka­atu nā mōku i Hiruhārama, tāu whaka­atu hoki ki Roma.” ");
INSERT INTO mri_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ao ake te rā, ka hui­hui ētahi o ngā Hūrai, ka maka oati ki a rātou anō, ka mea, kia kaua rātou e kai, kia kaua e inu, kia whaka­matea rā anō e rātou a Paora. ");
INSERT INTO mri_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ā, e whā tekau nga­horo ngā tāngata nāna tēnei oati­tanga. ");
INSERT INTO mri_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nā, ka haere rātou ki ngā tohu­nga nui rātou ko ngā kaumātua, ka mea, “Kua oati mātou i tētahi oati nui, kia kaua e pā kai, kia mate rā anō a Paora i a mātou. ");
INSERT INTO mri_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nā, mā koutou tahi ko te rū­nanga e kī atu ki te ranga­tira mano kia āra­hina iho ia ki a koutou āpōpō, me te mea nei e mea ana koutou kia āta mōhio­tia te take ki a ia. Ko mātou ia, i te mea kīanō ia i tata noa, ka noho rite ki te whaka­mate i a ia.” ");
INSERT INTO mri_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Otirā, ka rongo te tama a te tua­hine o Paora ki tō rātou whaka­aro whaka­papa, ka haere ia, ka tomo ki te pā, ka kōrero ki a Paora. ");
INSERT INTO mri_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kātahi, ka karanga a Paora ki tētahi kene­turio, ka mea, “Ārahina atu te tama­iti nei ki te ranga­tira mano; he kōrero hoki tāna ki a ia”. ");
INSERT INTO mri_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nā, ka mau ia ki a ia, ka ārahi i a ia ki te ranga­tira mano, ka mea, “I karanga te here­here, a Paora, i ahau, i mea kia āra­hina mai tēnei tama­iti ki a koe, he kōrero hoki tāna ki a koe.” ");
INSERT INTO mri_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nā, ka mau te ranga­tira mano ki tōna ringa, ka haere ki tahaki, ka ui atu, “He aha tāu mea hei kōrero ki ahau?” ");
INSERT INTO mri_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Anō rā ko tērā, “Kua whaka­takoto whaka­aro ngā Hūrai kia mea ki a koe kia āra­hina iho a Paora āpōpō ki te rū­nanga, ānō e āta uia anō e koe tētahi atu mea mōna. ");
INSERT INTO mri_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nā, aua koe e rongo ki a rātou; e whā hoki tekau nga­horo tāngata o rātou e whanga ana ki a ia. Kua puaki tā rātou oati, kia kaua e kai, kia kaua e inu, kia mate rā anō ia i a rātou. Nā, kua rite tēnei rātou, e tatari ana ki te kupu whaka­ae i a koe.” ");
INSERT INTO mri_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kātahi, ka tukua atu taua tama­iti e te ranga­tira mano, ka mea ia, “Kaua e kōrero­tia ki tētahi tāu whaka­atu­ranga mai i ēnei mea ki ahau.” ");
INSERT INTO mri_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nā, toko­rua ngā kene­turio i karanga­tia e ia; i mea ia, “Kia rite mai ētahi hōia kia rua rau hei haere ki Hiha­ria, me ētahi hōia eke hōiho kia whitu tekau, me tētahi hunga mau mātia kia rua rau, i te toru o ngā hāora o te pō. ");
INSERT INTO mri_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ā, ka whaka­hau ia ki a rāua, kia whaka­ritea mai he kararehe, hei whaka­noho­anga iho mō Paora ki runga, kia kawea oratia ai ia ki a Pirika, ki te kāwana.” ");
INSERT INTO mri_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ā, i tuhi­tuhia e ia he puka­puka, ka pēnei: ");
INSERT INTO mri_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nā, Karau­ria Raihia ki a Pirika, ki te kāwana pai rawa, Tēnā koe. ");
INSERT INTO mri_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","I hopu­kia tēnei tangata e ngā Hūrai, ā, i a ia ka tata te whaka­matea e rātou, ka puta atu ahau me ngā hōia, ā, tango­hia mai ana ia; i rongo hoki ahau nō Roma ia. ");
INSERT INTO mri_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","I mea anō ahau kia rongo i te take i whaka­wā­kia ai ia e rātou, ā, āra­hina ana ia e ahau ki tō rātou rū­nanga. ");
INSERT INTO mri_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nā ka kite ahau he kupu tau­tohe nō tō rātou ture i whaka­wā­kia ai ia, kāhore hoki ōna hē i tika ai te mate, te here rānei. ");
INSERT INTO mri_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ā, nō te whaka­atu­ranga mai ki ahau, kei te whaka­papa­tia he mate mō te tangata nei, tonoa tonu­tia ia e ahau ki a koe, i mea hoki ahau ki ōna kai­whaka­pae, kia kōrero­tia ki a koe ngā mea mōna.” ");
INSERT INTO mri_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nā, ka mau ngā hōia ki a Paora, ka pērā me te mea i kōrero­tia ki a rātou, ā, āra­hina ana ia i te pō ki Anatipatari. ");
INSERT INTO mri_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ao ake te rā ka tukua atu ngā tāngata eke hōiho hei hoa haere mōna, ā, hoki ana rātou ki te pā. ");
INSERT INTO mri_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ā, nō te taenga o ērā ki Hiha­ria, ka hoatu te puka­puka ki te kāwana, ā, whaka­tū­ria ana a Paora ki tōna aro­aro. ");
INSERT INTO mri_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ā, nō te tiro­hanga iho o te kāwana, ka ui, nō tēhea kāwana­tanga ia; ā, i tōna rongo­nga nō Kiri­kia ia, ");
INSERT INTO mri_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ka mea ia, “Ka whaka­rongo ahau ki a koe, ina tae mai anō hoki ōu kai­whaka­pae.” Ā, i whaka­hau ia, kia tiaki­na ia i roto i te whare whaka­wā o Herora. ");
INSERT INTO mri_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nā, ka pahure ngā rā e rima, ka haere atu a Anania, te tohu­nga nui rātou ko ētahi kaumātua, ko tētahi kai­kōrero hoki, ko Tereturu, whaka­kite ai i ngā hē o Paora ki te kāwana. ");
INSERT INTO mri_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ā, ka oti ia te karanga, ka tīmata a Tereturu te whaka­wā, ka mea: “I te mea nāu i hua ai te rangi­mārie ki a mātou, he āta ngā­rahu hoki nāu i whaka­tika­tika­ina ai ngā kino ki tēnei iwi. ");
INSERT INTO mri_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nui atu tā mātou whaka­whetai mō aua mea ka riro mai nei i a mātou, i ngā wā katoa, i ngā wāhi katoa, e Pirika, e te tangata pai rawa. ");
INSERT INTO mri_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Otiia, e kore e nui atu tāku whaka­ware i a koe, koia ka īnoi atu ki a koe kia pai koe ki te whaka­rongo mai ki ētahi kupu toru­toru a mātou. ");
INSERT INTO mri_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","I mau hoki i a mātou te korokē nei, he tangata whaka­tūtehu, e whaka­oho ana i ngā Hūrai katoa o te ao, ko ia hoki te tino take o te tītore­hanga ki tā ngā Nahareti. ");
INSERT INTO mri_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","I mea hoki ia kia whaka­noa­tia te teme­para: nā ka hopu mātou i a ia, ka mea kia whaka­wā­kia ia ki tā tō mātou ture i whaka­takoto ai. ");
INSERT INTO mri_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Otirā, i puta mai a Raihia, te ranga­tira mano, ā, tango­hia kino­tia atu ana ia i ō mātou ringa. ");
INSERT INTO mri_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ā, ungā ana ōna kai­whaka­pae kia haere mai ki a koe: māu e ui ki a ia, kia rongo ai koe ki ēnei mea katoa e whaka­wā­kia nei ia e mātou.” ");
INSERT INTO mri_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ā, i whaka­ae hoki ngā Hūrai ki taua whaka­pae, i mea, “Koia tērā ko aua mea.” ");
INSERT INTO mri_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ā, ka tohu atu te kāwana ki a ia kia kōrero, ka whaka­hokia e Paora, “E mātau ana ahau, ka maha ōu tau e whaka­wā nei koe i tēnei iwi, koia i pai ai tōku ngākau ki te tohe i te tika o āku mea. ");
INSERT INTO mri_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","E takoto kau ana hoki hei mōhio­tanga mōu, kāhore i maha ake i te tekau mā rua ngā rā ōku i haere nei ki Hiruhārama, ki te kara­kia. ");
INSERT INTO mri_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Kīhai anō ahau i mau i a rātou i roto i te teme­para e totohe ana ki tētahi, e mea ana rānei i te mano kia tutū, kāhore i ngā whare kara­kia, kāhore anō hoki i te pā. ");
INSERT INTO mri_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","E kore anō e taea e rātou te whaka­tau ki ahau i tōu aro­aro ngā mea e whaka­wā­kia nei ahau e rātou. ");
INSERT INTO mri_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Otirā, me whāki tēnei e ahau ki a koe, ko te Ara e kīa nei e rātou he tītore­hanga, ko tāku tēnā i ahau e kara­kia nei ki te Atua o ōku mātua; e whaka­pono ana hoki ahau ki ngā mea katoa kua oti te whaka­rite i roto i te ture, kua oti hoki te tuhi­tuhi ki tā ngā poro­piti. ");
INSERT INTO mri_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","E tū­mana­ko ana ki tā te Atua, ki tā ēnei anō hoki e whaka­ae nei, arā tēnei ake ka ara te hunga mate, ngā tāngata tika, ngā tāngata hē. ");
INSERT INTO mri_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tēnei anō tāku e whai nei, kia hara­kore tonu tōku hine­ngaro i te aro­aro o te Atua, o ngā tāngata. ");
INSERT INTO mri_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Nā, muri iho i ngā tau e maha, ka tae mai ahau ki te kawe mai i ngā mea ata­whai rawa­kore ki tōku iwi, me ngā whaka­here. ");
INSERT INTO mri_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","I kitea ahau i reira e rātou, e purea ana i roto i te teme­para, kāhore he hui­hui, kāhore he nga­ngau. ");
INSERT INTO mri_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tērā anō rā ētahi Hūrai nō Āhia; ko te tikanga kia haere mai rātou ki a koe ki te whaka­wā, ki te mea he mea tā rātou mōku. ");
INSERT INTO mri_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Tēnei rānei mā ēnei tāngata tonu e kōrero, me i kitea e rātou he hē tōku, i ahau e tū ana i mua i te rū­nanga, ");
INSERT INTO mri_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ko taua kupu kotahi pea i karanga ai ahau, i ahau e tū ana i roto i a rātou, ‘Ko te aranga o te hunga mate te mea e whaka­wā­kia nei ahau e koutou ināia­nei.’ ” ");
INSERT INTO mri_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Otirā, i te mea he nui atu tōna mōhio ki taua Ritenga, ka ungā rātou e Pirika, ka mea ia, “Kia tae mai a Raihia, te ranga­tira mano, ka tino rapu ahau ki te tikanga o ā koutou mea.” ");
INSERT INTO mri_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nā, ka mea ia ki te kene­turio kia tiaki­na a Paora, kia waiho noa anō ia, kia kaua e rīria ōna hoa ina mahi ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nā, muri iho i ētahi rā ka tae mai a Pirika rāua ko tāna wahine ko Ruruhira, he Hūrai, ka mea ia kia tīkina atu a Paora, ā, ka whaka­rongo ki a ia ki te whaka­pono ki a te Karaiti. ");
INSERT INTO mri_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ā, i a ia e kōrero ana ki ngā mea o te tika, ki te hia­hia kia pēhia, ki te whaka­wā­kanga kei te haere mai, ka wiri a Pirika, ka mea, “Haere āia­nei. Kia wātea ahau, ka karanga atu ai anō i a koe.” ");
INSERT INTO mri_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tohu noa hoki ka hoatu ki a ia he moni e Paora; koia i hono ai te tiki atu i a ia, te kōrero ki a ia. ");
INSERT INTO mri_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Otirā, ka pahure ngā tau e rua, ka whaka­kapia a Pirika e Porohia Petuha, ā, i tōna hia­hia ki te whaka­mānawa­reka i ngā Hūrai, ka waiho e Pirika a Paora kia here ana. ");
INSERT INTO mri_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nō te taenga mai o Petuha ki te kāwana­tanga, ka toru ngā rā, ka haere atu ia i Hiha­ria ki Hiruhārama. ");
INSERT INTO mri_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nā, ka kōrero te tohu­nga nui me ngā ranga­tira o ngā Hūrai ki a ia mō Paora, ka tohe ki a ia, ");
INSERT INTO mri_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","kia whaka­ae­tia tā rātou mōna, kia tīkina atu ia ki Hiruhārama, he whanga hoki tō rātou mōna kia whaka­matea ki te ara. ");
INSERT INTO mri_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Otirā, ka whaka­hokia e Petuha, kei Hiha­ria a Paora e pupuri ana, ā, tērā e hohoro tōna haere ki reira. ");
INSERT INTO mri_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","I mea anō ia, “Me haere tahi anō i ahau ki raro ngā mea ō koutou e whai mana ana, ki te whaka­wā i taua tangata, ki te mea he kino tōna.” ");
INSERT INTO mri_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ā, ka noho ia i a rātou mō ngā rā e waru, nga­huru rānei, nā, ka haere ki Hiha­ria; ao ake te rā ka noho ki te nohoa­nga whaka­wā, ā, ka mea kia āra­hina mai a Paora. ");
INSERT INTO mri_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ā, nō tōna taenga atu, e tū ana tērā ngā Hūrai i haere mai i Hiruhārama, he maha, he nui ngā hē i whaka­pā­ngia e rātou ki a Paora; heoi kīhai i ū tā rātou. ");
INSERT INTO mri_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ā, ka utua e Paora, “Kāhore rawa ōku hara ki te ture a ngā Hūrai, kāhore hoki ki te teme­para, kāhore anō ki a Hīhā.” ");
INSERT INTO mri_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Heoi, ka mea a Petuha ki a Paora, i tōna hia­hia kia pai­ngia e ngā Hūrai, “E pai ana rānei koe kia haere ki Hiruhārama, ki reira whaka­wā­kia ai mō ēnei mea ki tōku aro­aro?” ");
INSERT INTO mri_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Anō rā ko Paora, “E tū ana ahau ki te nohoa­nga whaka­wā o Hīhā, hei reira tonu ahau whaka­wā­kia ai; kāhore ōku hē ki ngā Hūrai, kua tino kitea nā hoki e koe. ");
INSERT INTO mri_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Me he hē tōku, kua meinga rānei e ahau tētahi mea e tika ai te mate, e kore ahau e kino kia mate; tēnā ko tēnei he teka ngā mea e whaka­pā­ngia nei e rātou ki ahau, e kore e āhei kia tukua ahau e tētahi ki a rātou. He karanga tēnei nāku ki a Hīhā”. ");
INSERT INTO mri_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nā, ka kōrero­rero a Petuha ki te rū­nanga, ā, ka mea, “Kua karanga koe ki a Hīhā; nā me haere koe ki a Hīhā.” ");
INSERT INTO mri_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ā muri iho i ētahi rā, ka tae atu a Kīngi Akaripa, rāua ko Pereniki ki Hiha­ria, ā, ka oha ki a Petuha. ");
INSERT INTO mri_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ā, ka pō maha rāua e noho ana i reira, ka kōrero­tia e Petuha ki te kīngi te take mō Paora, ka mea, “Tēnei tētahi tangata i waiho iho e Pirika e here ana. ");
INSERT INTO mri_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ā, i ahau i Hiruhārama, ka kōrero­tia mai ia ki ahau e ngā tohu­nga nui, e ngā kaumātua o ngā Hūrai, ka tono rātou kia whaka­wā­kia ia. ");
INSERT INTO mri_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nā, ko tāku whaka­hoki­nga atu ki a rātou, ‘Ehara i te rite­nga nā ngā tāngata o Roma kia tukua he tangata kia mate i te mea kīanō i tū­ta­taki noa te tangata e whaka­wā­kia ana ki ngā kai­whaka­pae, i whai wāhi rānei ki te whaka­hoki kupu ki te kupu whaka­wā mōna.’ ");
INSERT INTO mri_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nō reira, i tō rātou mine­nga mai ki konei, kīhai ahau i whaka­roa; ao ake te rā ka noho ahau ki te nohoa­nga whaka­wā, ka mea kia āra­hina mai taua tangata. ");
INSERT INTO mri_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ā, i te tū­ranga o ngā kai­whaka­pae, kīhai tētahi hē o āku i whaka­aro ai i kōrero­tia e rātou mōna. ");
INSERT INTO mri_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Heoi, he kupu tau­tohe­tohe nō tā rātou kara­kia tā rātou i mea ai ki a ia, ko tētahi Īhu anō i mate, e kīa ana hoki e Paora kei te ora. ");
INSERT INTO mri_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Heoi, pōhewa noa iho ahau ki taua tau­tohe, ka mea hoki me kore ia e pai kia haere ki Hiruhārama, ki reira whaka­wā­kia ai mō aua mea. ");
INSERT INTO mri_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nō te karanga­tanga a Paora kia waiho ia kia whaka­rangona tāna e te eme­para, ka whaka­haua e ahau kia puri­tia ia, kia tukua rā anō ia e ahau ki a Hīhā.” ");
INSERT INTO mri_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ka mea a Akaripa ki a Petuha, “E hia­hia ana anō ahau kia rongo i taua tangata.” Ka mea ia, “Ko āpōpō koe rongo ai ki a ia.” ");
INSERT INTO mri_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Heoi, i te aonga ake, ka tae atu a Akaripa rāua ko Pereniki, me ngā whaka­pai­pai maha, ā, tomo ana ki te whare whaka­rongo, rātou ko ngā ranga­tira mano, ko ngā tāngata nunui o te pā, ā, ka whaka­haua e Petuha, ka mauria mai a Paora. ");
INSERT INTO mri_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nā, ka mea a Petuha, “E Kīngi Akaripa, e ngā tāngata katoa hoki e noho nei tātou, ka kite koutou i tēnei tangata, i tohe mai ai ki ahau te hui­hui katoa o ngā Hūrai i Hiruhārama, i konei anō hoki, i karanga ai, ehara rawa i te tika kia waiho ia kia ora ana. ");
INSERT INTO mri_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Otirā, i kite ahau, kāhore āna mahi e tika ai te mate; ā, i te mea nāna anō i karanga ki te eme­para, ka mea ahau kia ungā atu ia. ");
INSERT INTO mri_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kāhore ia āku tino mea e tuhi­tuhi atu ai ahau mōna ki tōku ariki. Koia ahau ka ārahi mai nei i a ia ki a koutou, ki a koe rawa anō, e Kīngi Akaripa, kia whai mea ai ahau hei tuhi­tuhi­nga atu, ua mutu te uiui. ");
INSERT INTO mri_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ki tāku hoki he mea hē kia ungā atu he here­here, ā, kia kaua hoki e kōrero­tia te mea i whaka­wā­kia ai ia.” ");
INSERT INTO mri_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Nā, ko te mea­tanga a Akaripa ki a Paora, “E āhei ana koe kia kōrero i āu kōrero.” Kātahi, ka totoro te ringa o Paora, ā, ka kōrero ia: ");
INSERT INTO mri_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“He koa ngā ngākau tēnei ki ahau, e Kīngi Akaripa, kia kōrero­tia e ahau ki a koe āia­nei ngā mea katoa e whaka­wā­kia nei ahau e ngā Hūrai; ");
INSERT INTO mri_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","he mōhio rawa hoki koe ki ngā rite­nga katoa, ki ngā tau­tohe hoki anō a ngā Hūrai; nā reira, kia pai koe ki te whaka­rongo mārie ki ahau. ");
INSERT INTO mri_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ko tāku whaka­haere mai o tōku tama­riki­tanga, nō te tīma­tanga mai rā anō i roto i tōku iwi, i Hiruhārama hoki, e mōhio ana ngā Hūrai katoa. ");
INSERT INTO mri_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Mōhio tonu rātou ki ahau ō mua iho, me i pai rātou ki te whaka­atu; ko tāku mahi, i whai i tā te tītore­hanga pakeke rawa o tō tātou kara­kia, i tā te Parihi. ");
INSERT INTO mri_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Tēnei ahau te tū nei i konei, te whaka­wā­kia nei mō te tū­mana­ko ki te mea i kōrero­tia e te Atua i mua ki ō tātou mātua. ");
INSERT INTO mri_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","E tū­mana­ko nei ō tātou iwi kotahi tekau mā rua kia uru ki tēnei, i a rātou e mahi tonu nei ki te Atua i te ao, i te pō. Ko tēnei e tūmanako­hia atu nei e te kīngi, te mea e whaka­wā­kia nei ahau e ngā Hūrai. ");
INSERT INTO mri_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","He aha rawa kia kore e whaka­pono­hia e koutou, ki te mea ka whaka­ara ake te Atua i te hunga mate? ");
INSERT INTO mri_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ko ahau nei, i whaka­aro ahau kia maha tonu ngā mea e mahia e ahau hei pēhi mō te ingoa o Īhu o Nahareta. ");
INSERT INTO mri_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Āe, i meinga anō tēnei e ahau ki Hiruhārama. He toko­maha anō te hunga tapu i uakina e ahau ki ngā whare here­here, he mea tuku mai hoki ngā tikanga nā ngā tohu­nga nui ki ahau; ā, i te whaka­mate­nga i a rātou, i whaka­ae ahau kia pērā­tia rātou. ");
INSERT INTO mri_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","He maha anō āku whiu­nga i a rātou i roto i ngā whare kara­kia katoa, i meinga anō rātou e ahau kia kohu­kohu; heoi, hau­rangi noa iho ahau ki a rātou, whāia ana e ahau, ā taea noatia ngā pā o tawhiti. ");
INSERT INTO mri_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Nāwai ā, i ahau e haere ana ki Ramahiku, me ngā tikanga, me te kupu whaka­ae a ngā tohu­nga nui, ");
INSERT INTO mri_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","i te pou­tū­mārō­tanga, e te kīngi, ka kitea e ahau i te ara he mārama i te rangi e tīaho ana ki ahau, ki ōku hoa haere anō, tērā atu i te mārama o te rā. ");
INSERT INTO mri_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Heoi, hinga ana mātou katoa ki te whenua, ka rongo ahau i te reo e kōrero ana ki ahau, nō ngā Hiperu anō hoki te reo, e mea ana, ‘E Haora, e Haora, he aha tāu e whaka­toi nei i ahau? Ehara tāu te whana ki ngā koi­koi.’ ");
INSERT INTO mri_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Anō rā ko ahau, ‘Ko wai koe, e te Ariki?’ Ka mea ia, ‘Ko Īhu ahau e whaka­toia nei e koe. ");
INSERT INTO mri_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Otirā whaka­tika, e tū ōu wae­wae ki runga. Ko te mea tēnei i puta ai ahau ki a koe, kia meinga koe hei kai­mahi, hei kai­whaka­atu mō ngā mea i kite nei koe, mō ngā mea anō e kitea ai ahau e koe. ");
INSERT INTO mri_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ka whaka­ora­ngia koe i te iwi, i ngā tauiwi, ka tonoa nei koe e ahau ki a rātou, ");
INSERT INTO mri_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","hei whaka­titiro i ō rātou kanohi, hei whaka­tahuri i a rātou i te pōuri ki te mārama, i te kaha o Hātana ki te Atua, kia whi­whi ai rātou ki te muru­nga hara, ki tētahi wāhi anō i roto i te hunga ka oti te whaka­tapu i runga i te whaka­pono ki ahau.’ ");
INSERT INTO mri_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Nō reira, kīhai ahau i whaka­tuturi, e Kīngi Akaripa, ki tō te rangi kite­nga. ");
INSERT INTO mri_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Heoi, i kōrero ahau ki te hunga i Ramahiku i te tua­tahi, ā, i Hiruhārama, ki te whenua katoa anō o Hūria, ki ngā tauiwi hoki, kia rīpe­netā, kia tahuri ki te Atua, me te mahi anō i ngā mahi tika o te rīpe­netā. ");
INSERT INTO mri_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nō reira ngā Hūrai i hopu ai i ahau i te teme­para, i whai ai ki te whaka­mate i ahau. ");
INSERT INTO mri_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Heoi, ka āwhina­tia mai ahau e te Atua, ka tū tonu nei ahau, ā mohoa noa nei, me te kōrero ki te iti, ki te rahi, kāhore āku kupu kē ake i tā ngā poro­piti rātou ko Mohi i mea ai meāke puta: ");
INSERT INTO mri_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","arā ko te Karaiti kia mate, ko ia te mātā­mua o te aranga o te hunga mate, māna anō e whaka­puaki te mārama ki te iwi, ki ngā tauiwi.” ");
INSERT INTO mri_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","I a ia e kōrero ana i ēnei mea, nui atu te reo o Petuha ki te karanga, “E Paora, he hau­rangi koe; nā te nui o tāu kōrero puka­puka i hau­rangi ai koe!” ");
INSERT INTO mri_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Anō rā ko ia, “Kāhore ōku hau­rangi, e Petuha, e te tangata pai rawa; engari he pono, he whai whaka­aro, āku kupu e whaka­puaki nei. ");
INSERT INTO mri_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","E mātau ana hoki te kīngi ki ēnei mea, i māia ai ahau ki te kōrero ki a ia. E mea ana hoki ahau, kāhore tētahi o ēnei mea i ngaro i a ia; kīhai hoki tēnei mea i mahia i te koko­nga. ");
INSERT INTO mri_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","E whaka­pono ana rānei koe ki ngā poro­piti, e Kīngi Akaripa? E mea ana ahau, tēnei koe te whaka­pono nei.” ");
INSERT INTO mri_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Anō rā ko Akaripa ki a Paora, “Wāhi iti kua riro atu ahau ki tāu, ki tā te Karaiti tikanga.” ");
INSERT INTO mri_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Nā, ko te mea­tanga a Paora, “Pai tonu kia īnoi ahau ki te Atua kia kaua e iti, engari kia tino nui, kia kaua anō e waiho i tōu kotahi, engari, kia tino rite ki ahau te hunga katoa e whaka­rongo nei ki ahau ināia­nei; ko ēnei meka­meka ia kia kore.” ");
INSERT INTO mri_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nā, ka whaka­tika te kīngi, me te kāwana, me Pereniki, me te hunga i noho tahi rātou. ");
INSERT INTO mri_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nā, i a rātou ka wehe kē, ka kōrero­rero ki a rātou anō, ka mea, “Kāhore he hanga a tēnei tangata e tika ai te mate, te here rānei.” ");
INSERT INTO mri_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Kātahi, ka mea a Akaripa ki a Petuha, “Ka tukua tēnei tangata kia haere, me i kaua ia te karanga ki a Hīhā.” ");
INSERT INTO mri_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ā, nō ka takoto te tikanga kia rere mātou ki Itari, ka tukua a Paora me ērā atu here­here ki tētahi kene­turio ko Huriu te ingoa, nō te hapū o Ākuhata. ");
INSERT INTO mri_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nā, eke ana mātou ki tētahi kai­puke o Ataramitiuma, e tika ana rā ngā kāinga o Āhia, rere ana mātou; ko Aritaku o Teharonika, he tangata nō Makeronia, tō mātou hoa. ");
INSERT INTO mri_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Pō tahi ka ū mātou ki Hairona. Nā, ka ngā­wari te mahi a Huriu ki a Paora, tukua ana ia kia haere ki ōna hoa kia ata­whai­tia. ");
INSERT INTO mri_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Rere atu ana i reira, ka miri haere mātou i te taha o Kai­peru, nō te mea i hē te hau. ");
INSERT INTO mri_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Whiti ana mātou i te moana o Kiri­kia, o Pamapu­ria, ka ū ki Maira, he pā nō Raikia. ");
INSERT INTO mri_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nā, ka mau i te kene­turio he kai­puke ki reira nō Arēhānaria, e rere ana ki Itari; ka utaina mātou e ia ki runga. ");
INSERT INTO mri_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ā, ka pō maha i pūhoi ai te rere, ka whiti whaka­uaua ki te rite­nga atu o Hiniru, ā, tē tukua mātou e te hau, ka miri haere mātou i te taha o Kariti i te rite­nga atu o Haramone; ");
INSERT INTO mri_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ā, ka pahemo whaka­uaua a reira, ka ū mātou ki tētahi kāinga, ko Ngā Kokoru Āta­ahua te ingoa; e tata ana a reira ki te pā o Rāhia. ");
INSERT INTO mri_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ā, ka maha ngā rā ka pahemo, nā, kua kino te rere­nga, nō te mea kua pahemo kē te Pō Noho­puku, ā, ka whaka­tūpato a Paora, ");
INSERT INTO mri_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ka mea ki a rātou, “E mara mā, e kite ana ahau i te kino, i te nui o te mate e pā mai i tēnei rere­nga, ehara i te mea ko te utanga anake me te kai­puke, engari, ko tātou anō.” ");
INSERT INTO mri_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Otirā, nui kē atu te āro o te kene­turio ki te kāpene rāua ko te tangata nōna te kai­puke i tāna ki ngā mea i kōrero ai a Paora. ");
INSERT INTO mri_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ā, i te mea kīhai i pai taua kokoru hei tūnga i te hōtoke, ka mea te toko­maha kia rere atu anō i reira, me kore e ū ki Pinike, ki reira tū ai i te hōtoke; he kokoru ia nō Kariti, e anga ana ki te uru mā tonga, ki te uru mā raki. ");
INSERT INTO mri_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ā, ka pā reka­reka te tonga, ka mea rātou kua taea tā rātou i whaka­aro ai, ka hūtia te punga; ā, miri haere ana i Kariti. ");
INSERT INTO mri_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nā, kīhai i roa ka puta he hau nui whaka­hara­hara, ko Urokarairona te ingoa. ");
INSERT INTO mri_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ā, ka kā­hakina te kai­puke, tē ngo­ngo ki te hau, nā, ka tukua e mātou ki tāna, ā, ka pāea. ");
INSERT INTO mri_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nā, ka miri i te taha ruru o tētahi motu, tōna ingoa ko Karaura; ka riro whaka­uaua mai te poti i a mātou. ");
INSERT INTO mri_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ā, ka hūtia ake, ka hanga ki te whakaū, meatia he awhi mō te tangere o te puke; ā, nō ka mataku kei eke ki te tahuna, ki Hatihi, ka tukua te rā, ā, ka pāea haere­tia. ");
INSERT INTO mri_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ā, nō ka tino ākina mātou e te tūpuhi, i te aonga ake ka ākiri­tia ngā utanga. ");
INSERT INTO mri_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ā, i te toru o ngā rā ka makā atu e rātou ki ō rātou ringa ngā mea ake o te kai­puke. ");
INSERT INTO mri_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ā, he maha ngā rā i kore ai e puta te rā me ngā whetū, kīhai anō i iti te tūpuhi i ākina ai mātou, nā, ka mahue katoa tō mātou whaka­aro ki te ora. ");
INSERT INTO mri_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Heoi, ka roa te noho­puku, nā, ka tū a Paora i waenga­nui o rātou, ka mea, “E mara mā, engari rā me i rongo koutou ki ahau, kia kaua e rere mai i Kariti, kei pā mai tēnei kino, tēnei mate. ");
INSERT INTO mri_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nā, ko tāku kupu tēnei ki a koutou, Kia mārama te ngākau; e kore hoki e mate tētahi o koutou, ko te kai­puke anake. ");
INSERT INTO mri_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","I tū hoki ki tōku taha i tēnei pō he ana­hera nā te Atua, nāna nei ahau, ko ia tāku e kara­kia atu nei, ");
INSERT INTO mri_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","i mea mai, ‘Aua e mataku, e Paora; me tū koe ki te aro­aro o Hīhā; nāna, kua hoatu ki a koe e te Atua te hunga katoa e rere tahi nā koutou.’ ");
INSERT INTO mri_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nā, kia mārama te ngākau, e mara mā; e whaka­pono ana hoki ahau ki te Atua, e rite anō ki tāna i kōrero mai ai ki ahau. ");
INSERT INTO mri_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Otirā kua takoto te tikanga kia eke tātou ki tētahi motu.” ");
INSERT INTO mri_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nā, i te tekau mā whā o ngā pō, i a mātou e kāhaki­hakina ana i te moana o Aria, i waenga­nui pō, ka mea ngā hēra­mana kei te whaka­tata rātou ki tētahi whenua. ");
INSERT INTO mri_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Nā, ka whaka­tātūtū rātou, ka kite e rua tekau mārō, ā, ka neke tata atu, ka whaka­tātūtū anō, ka kite kotahi tekau mā rima mārō. ");
INSERT INTO mri_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nā, ka mataku kei pāea mātou ki ngā toka, ka tukua ngā punga e whā i te kei, ka hia­hia ki te awa­tea. ");
INSERT INTO mri_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ā, i ngā hēra­mana e mea ana kia oma atu i te kai­puke, e tuku ana hoki i te poti ki te moana, he whaka­ware, kia kīa ai e tukua ana ētahi punga i te ihu. ");
INSERT INTO mri_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ka mea a Paora ki te kene­turio rātou ko ngā hōia, “Ki te kore ēnei e noho ki te kai­puke, e kore koutou e taea te whaka­ora.” ");
INSERT INTO mri_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Kātahi, ka tapa­hia ngā whaka­heke o te poti e ngā hōia, ā, tukua ana kia taka atu. ");
INSERT INTO mri_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ā, i te mea meāke pūao te rā, ka tohe a Paora ki a rātou katoa kia kai, ka mea, “Ko te tekau mā whā tēnei o ngā rā e tatari nei koutou, e noho­puku nei, tē ō te kai. ");
INSERT INTO mri_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Koia ahau ka tohe nei kia kai; ko tētahi mea hoki tēnei e ora ai koutou. E kore hoki e nga­horo tētahi huru­huru o te ūpoko o tētahi o koutou.” ");
INSERT INTO mri_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ā, nō tāna kōrero­tanga i ēnei kupu, ka mau ki te taro, ka whaka­whetai ki te Atua i te aro­aro o te katoa; ā, ka whawhati, ka tīmata te kai. ");
INSERT INTO mri_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nā, ka mārama ngā ngākau o rātou katoa, ka kai anō rātou. ");
INSERT INTO mri_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nā, e rua rau e whitu tekau mā ono mātou katoa i te kai­puke. ");
INSERT INTO mri_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ā, nō ka mākona i te kai, ka whaka­māmā rātou i te kai­puke, ka ākiri­tia te wīti ki te moana. ");
INSERT INTO mri_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ā, ka ao te rā kīhai rātou i mōhio ki tērā whenua; engari, i kite rātou i tētahi kokoru he one tō reira, ā, ka mea rātou me kore e āhei te āki atu i te kai­puke ki roto. ");
INSERT INTO mri_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nā, tapa­hia ana e rātou ngā punga, tukua ana ki te moana, i whaka­koro­koroa anō ngā here o te urungi, ka hūtia anō te rā nui ki te hau, ka tika atu ki te one. ");
INSERT INTO mri_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ā, ka puta atu ki tētahi wāhi, he tai papaki­rua, ka whaka­ekea te kai­puke; ā, titi tonu te ihu, mau tonu, ko te kei i pakaru i te kaha o te ngaru. ");
INSERT INTO mri_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ā, ki tā ngā hōia whaka­aro, me whaka­mate ngā here­here, kei kau tētahi ki uta, kei oma. ");
INSERT INTO mri_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ko te kene­turio ia i mea kia whaka­ora­ngia a Paora, kīhai hoki i tukua ki tā rātou i whaka­aro ai; nā, ka mea ia, kia mātua peke atu te hunga e mātau ana ki te kau, kia kau ki uta. ");
INSERT INTO mri_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ko ērā atu, ko ētahi i runga i ngā papa, ko ētahi i runga i ētahi o ngā mea o te kai­puke. Heoi, tae ora katoa ana rātou ki uta. ");
INSERT INTO mri_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ā, ka ora mātou, kātahi ka mōhio ko Merita te ingoa o te motu. ");
INSERT INTO mri_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nā, kīhai i nohi­nohi te ata­whai a ngā tāngata māori ki a mātou. Ka tahuna he kāpura, whaka­manu­hiri­tia ana mātou katoa, nō te mea e ua ana te ua, nō te mātao hoki. ");
INSERT INTO mri_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Nā, ka kohiko­hia e Paora he pūpū wahie, ā, makā ana e ia ki te kāpura; heoi puta mai ana he neke i te wera, ka mau ki tōna ringa. ");
INSERT INTO mri_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ā, i te kite­nga o ngā tāngata māori i te ngā­rara e were­were ana ki tōna ringa, ka mea rātou tētahi ki tētahi, “Koia, he tangata kōhuru tēnei, ka ora nei ia i te moana, nā, kīhai i tukua e te tika kia ora.” ");
INSERT INTO mri_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Otiia, i ruia atu e ia te ngā­rara ki te kāpura, ā, kīhai ia i mate, kīhai i aha. ");
INSERT INTO mri_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nā, whanga noa rātou kia tetere ia, kia hinga whaka­rere rānei, kia mate; heoi, ka roa noa tō rātou whanga­nga, ā, i te kite­nga kāhore he aha i pā ki a ia, ka puta kē ō rātou whaka­aro, ka mea, he atua ia. ");
INSERT INTO mri_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","I taua wāhi te kāinga o te tino ranga­tira o te motu, ko Pupiriu te ingoa. He manu­hiri mātou nāna; e toru ngā rā i ata­whai­tia ai mātou e ia. ");
INSERT INTO mri_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nā, i te takoto te papa o Pupiriu e mate ana i te kirikā, i te kōripi. Heoi, ka tomo a Paora ki a ia, ka īnoi, ka whaka­pā i ōna ringa ki a ia, ā, ora ake ia. ");
INSERT INTO mri_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ā, i te mea­tanga o tēnei, nā, ka haere mai anō ērā atu o te motu he mate o rātou, ā, whaka­ora­ngia ana. ");
INSERT INTO mri_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nui atu anō te hōnore i whaka­hōnore­tia ai mātou e rātou; ā, i tō mātou rere­nga ka utaina ngā mea e rite ana mā mātou. ");
INSERT INTO mri_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ā muri iho i ngā marama e toru, ka rere mātou i runga i tētahi kai­puke o Arēhānaria, i tū nei ki taua motu i te hōtoke, ko Katoro rāua ko Poruku te tohu. ");
INSERT INTO mri_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nā, ka ū ki Hairakuha, ā, e toru ō mātou rā i noho ai ki reira. ");
INSERT INTO mri_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nā, ka āwhio ake mātou i reira, ka ū ki Rekiuma. Ka pō tahi ka pā te tonga, ā, i te rua o ngā rā ka ū ki Puteori. ");
INSERT INTO mri_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ā, nō ka kitea ngā tuā­kana i reira, ka tohea mātou kia noho i a rātou, kia whitu ngā rā. Heoi, haere ana mātou ki Roma. ");
INSERT INTO mri_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ā, ka rongo ngā tuā­kana o reira ki a mātou, ka haere ake ki te whaka­tau i a mātou ki Te Mākete o Apiu, ki Whare­toru. Ā, i te kite­nga o Paora i a rātou, ka whaka­whetai ki te Atua, ka ora te ngākau. ");
INSERT INTO mri_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nā, ka tae mātou ki Roma, ka hoatu ngā here­here e te kene­turio ki te ranga­tira hōia. Ko Paora ia i tukua kia noho motu kē rāua ko tētahi hōia hei tiaki i a ia. ");
INSERT INTO mri_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ā, i muri i ngā rā e toru, ka hui­huia e Paora ngā tino tāngata o ngā Hūrai; ā, nō tō rātou mine­nga mai, ka mea ia ki a rātou, “E ōku tuā­kana, ko ahau kāhore ōku hara ki te iwi, ki ngā rite­nga rānei a ngā mātua, i tukua ai ahau i Hiruhārama hei here­here ki ngā ringa o ngā tāngata o Roma. ");
INSERT INTO mri_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ā, i mea rātou, i tā rātou whaka­wā­kanga i ahau kia tukua ahau, nō te mea kāhore he take e mate ai ahau. ");
INSERT INTO mri_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Heoi, ka whaka­hē tonu ngā Hūrai; e taea hoki te aha? Karanga ana ahau ki a Hīhā; kāhore ia āku mea e whaka­wā ai ahau i tōku iwi. ");
INSERT INTO mri_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Koia ahau i karanga ai i a koutou kia kite, kia kōrero ki ahau. Nō te mea hoki ko tā Īharaira e tū­mana­ko nei te mea i herea ai ahau ki tēnei meka­meka.” ");
INSERT INTO mri_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Nā, ko tā rātou mea­tanga ki a ia, “Kāhore he puka­puka mōu i tae mai ki a mātou i Hūria, kāhore anō tētahi o ngā tuā­kana i haere mai nei i kawe kupu mai, i kōrero mai rānei i tētahi kino mōu. ");
INSERT INTO mri_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Otirā, e mea ana mātou kia rongo ki a koe ki ōu whaka­aro. E mōhio ana hoki mātou ki tēnei wehe­nga, e kōrero­tia kino­tia ana i ngā wāhi katoa.” ");
INSERT INTO mri_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ā, ka oti te whaka­rite he rā ki a ia, he toko­maha i haere mai ki a ia ki tōna whare; ā, whaka­kitea ana e ia ki a rātou, whaka­atu­ria ana te ranga­tira­tanga o te Atua, ā, ka kukume i a rātou ki ngā mea o Īhu, tiki atu ai i tā te ture a Mohi, i tā ngā poro­piti, nō te ata ā ahi­ahi noa. ");
INSERT INTO mri_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ko ētahi i whaka­pono ki ngā mea i kōrero­tia, ko ētahi kīhai i whaka­pono. ");
INSERT INTO mri_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ā, te rite ā rātou kōrero, ka puta atu rātou, i muri i te kōrero­tanga a Paora i tētahi kupu, “Tika tonu te kōrero a te Wairua Tapu i a Ihāia poro­piti ki ō koutou mātua, ");
INSERT INTO mri_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","i mea nei, ‘Haere ki tēnei iwi, mea atu, Rongo noa koutou, e kore e mātau; ti­tiro noa koutou, e kore e kite. ");
INSERT INTO mri_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kua mā­to­toru hoki te ngākau o tēnei iwi, he pūhoi ngā tari­nga ki te whaka­rongo, ō rātou kanohi kua whaka­moea e rātou; kei kite ngā kanohi, kei rongo ngā tari­nga, kei mātau te ngākau, ā, ka tahuri rātou, ka ora i ahau.’ ");
INSERT INTO mri_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Nā, kia mōhio koutou, ka tukua tēnei whaka­ora­nga a te Atua ki ngā tauiwi, ā, ka rongo rātou.” ");
INSERT INTO mri_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ā, ka mutu ēnei kōrero āna, ka haere ngā Hūrai, he nui hoki tā rātou tau­tohe­tohe ki a rātou anō. ");
INSERT INTO mri_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ā, e rua tino tau i noho ai a Paora ki tōna whare i utua e ia, ā, manaaki­tia ana e ia te hunga katoa e tomo ana ki a ia; ");
INSERT INTO mri_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ā, māia tonu ia ki te kauwhau i te ranga­tira­tanga o te Atua, ki te whaka­ako i ngā mea o te Ariki, o Īhu Karaiti, kīhai anō i rīria.");
INSERT INTO mri_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nā Paora, nā te pono­nga a Īhu Karaiti, i karanga­tia hei āpō­toro, i motu­hia ki te rongo­pai a te Atua, ");
INSERT INTO mri_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","i kōrero­tia rā e ia i mua, arā e āna poro­piti i roto i ngā karaipi­ture tapu, ");
INSERT INTO mri_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","mō tāna Tama, i whānau nei he uri nō Rāwiri, nō te wāhi ki te kiko­kiko; ");
INSERT INTO mri_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","i whaka­pua­kina mai nei ko te Tama a te Atua i runga i te kaha, i runga i tā te Wairua o te tapu, i te mea ka whaka­ara­hia i te hunga mate; arā a Īhu Karaiti, tō tātou Ariki. ");
INSERT INTO mri_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Nāna nei mātou i whi­whi ai ki te aroha noa, ki te mahi āpō­toro, kia ngohe­ngohe ai, kia whaka­pono ai ngā iwi katoa, hei mea mō tōna ingoa. ");
INSERT INTO mri_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nō rātou nei hoki koutou, he mea karanga hei hunga mō Īhu Karaiti. ");
INSERT INTO mri_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ki te hunga katoa i Roma, e aroha­ina nei e te Atua, ka oti nei te karanga hei hunga tapu. Kia tau ki a koutou te aroha noa me te rangi­mārie, he mea nā te Atua, nā tō tātou Matua, nā te Ariki hoki, nā Īhu Karaiti. ");
INSERT INTO mri_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ko tāku mea tua­tahi, he whaka­whetai ki tōku Atua i roto i a Īhu Karaiti mō koutou katoa, nō te mea e kōrero­tia ana tō koutou whaka­pono i te ao katoa. ");
INSERT INTO mri_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ko te Atua, e mahi nei tōku wairua ki a ia i roto i te rongo­pai o tāna Tama, hei kai­whaka­atu mōku, mō te mau tonu o tāku whaka­hua­hua i a koutou, ā, i āku karakia­tanga i ngā wā katoa, ");
INSERT INTO mri_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","e īnoi ana me kore e pai te Atua kia whaka­tikaia tāku haere atu ki a koutou. ");
INSERT INTO mri_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nui atu hoki tōku hia­hia kia kite i a koutou, kia whaka­whi­whi ai ahau i a koutou ki tētahi mea hōmai, he mea wairua, kia whaka­ūngia ai koutou; ");
INSERT INTO mri_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","arā, kia ora ngā­tahi ō tātou ngākau, tōku i tō koutou whaka­pono, ō koutou i tōku. ");
INSERT INTO mri_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nā, e kore ahau e pai, e ōku tēina kia ngaro i a koutou te maha o āku mea­tanga kia haere atu ki a koutou, heoi, āraia mai ana ahau, ā, mohoa noa nei, kia whi­whi ai ahau ki tētahi hua i roto i a koutou hoki, kia pērā me te mea i ērā atu tauiwi. ");
INSERT INTO mri_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","He nama kei runga i ahau nā ngā Kariki, ā, nā ngā tau­tangata, nā te hunga mōhio, ā, nā te hunga whaka­aro­kore. ");
INSERT INTO mri_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nā reira, e ngākau nui ana ahau kia whaka­paua tāku ki te kauwhau hoki i te rongo­pai ki a koutou i Roma. ");
INSERT INTO mri_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kāhore hoki ōku whaka­mā ki te rongo­pai; ko te kaha hoki ia o te Atua hei whaka­ora mō ngā tāngata katoa e whaka­pono ana; mō te Hūrai ki mua, mō te Kariki anō hoki. ");
INSERT INTO mri_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ā, kei reira e whaka­kitea ana tā te Atua tika, he mea nō te whaka­pono ki te whaka­pono; kua oti nei hoki te tuhi­tuhi, “Mā te whaka­pono e ora ai te tangata tika.” ");
INSERT INTO mri_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","E whaka­kitea iho ana hoki i te rangi tō te Atua riri ki ngā karakia­kore­tanga katoa, ki ngā hē o ngā tāngata e pēhi ana i te pono i runga i te hē. ");
INSERT INTO mri_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kei roto nei i a rātou e mārama ana ngā mea o te Atua e taea te mōhio; kua whaka­mārama­tia hoki e te Atua ki a rātou. ");
INSERT INTO mri_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","E kitea nuitia ana hoki ngā mea ōna, kāhore nei i kitea, nō te hanga­nga iho rā o te ao, e mōhio­tia ana ki ngā mea i hangā, arā tōna kaha mau tonu, me tōna atua­tanga; kia kore ai he kupu whaka­hoki mā rātou. ");
INSERT INTO mri_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","I a rātou hoki e mātau ana ki te Atua, kīhai rātou i whaka­korōria i a ia hei Atua, kīhai hoki i whaka­whetai; heoi, kua kūware ō rātou whaka­aro, ā, whaka­pōuri­tia ana tō rātou ngākau pōhēhē. ");
INSERT INTO mri_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","I a rātou e mea ana he mōhio rātou, nā, ka wai­rangi, ");
INSERT INTO mri_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ā, whaka­putaia kētia ake te korōria o te Atua e kore nei e pirau, kia rite ki te āhua o te tangata pirau noa, o ngā manu hoki, o ngā kararehe wae­wae whā, o ngā mea ngōki­ngōki. ");
INSERT INTO mri_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Koia rātou i tukua ai e te Atua ki te mahi poke, i runga i ngā hia­hia o ō rātou ngākau, kia whaka­tūtūā­tia iho ai ō rātou tinana e rātou anō, tō tētahi e tētahi; ");
INSERT INTO mri_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","i te mea kua whaka­whiti rātou i tō te Atua pono mō te teka, ā, kara­kia ana, mahi ana ki te mea hanga, kapea ake te Kai­hanga, ko ia nei te whaka­pai­ngia ake ake. Āmine. ");
INSERT INTO mri_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Koia rātou i tukua ai e te Atua ki ngā hia­hia tūtūā. Ko ā rātou wāhine hoki, mahue ake i a rātou te tikanga māori, kei te ngau kē noa atu. ");
INSERT INTO mri_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Me ngā tāne anō, whaka­rērea ake e rātou te tikanga māori ki te wahine, ānō he ahi te kānga o tō rātou hia­hia ki a rātou anō; ngā tāne ki ngā tāne, mahi ai i te mea whaka­mā, me te whi­whi anō ki te utu e rite ana mō tō rātou ngau­nga kētanga. ");
INSERT INTO mri_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ā, i a rātou kīhai nei i pai kia mau tonu te Atua ki ō rātou mahara, tukua ana rātou e te Atua ki te hine­ngaro hē kia mahia ngā mea kāhore e tau kia mahia. ");
INSERT INTO mri_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Kī tonu rātou i ngā mahi hē katoa, i te kino, i te apo, i te mauā­hara; whawhao rawa i te hae, i te kōhuru, i te totohe, i te hīanga, i te whanokē; he hunga kō­humu­humu, ");
INSERT INTO mri_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","he hunga ngau­tuarā, kino ki te Atua, he hunga whaka­hīhī, whaka­kake, whaka­peha­peha, he kai­tito i ngā mea kino. E turi ana ki ngā mātua, ");
INSERT INTO mri_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","kāhore ō rātou mātau­ranga, he hunga kupu taka, kāhore nei he aroha, kāhore e tohu tangata. ");
INSERT INTO mri_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ahakoa e mātau ana anō rātou ki tā te Atua tikanga, he tika te mate mō ngā kai­mahi i ēnei mea, heoi, ka mahi tonu rātou i aua mea me te whaka­ae hoki ki te hunga e pērā ana te mahi. ");
INSERT INTO mri_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nā, kāhore he kupu whaka­hoki māu, e koe, e te tangata e whaka­hē ana; i a koe hoki e whaka­hē nā i tērā, e whaka­tau ana koe i te hē ki a koe anō; kei te mahi hoki koe, te kai­whaka­hē, i aua mea nā anō. ");
INSERT INTO mri_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nā, e mātau ana tātou kei runga i te pono te whaka­hē­nga a te Atua mō ngā kai­mahi i aua mea. ");
INSERT INTO mri_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ko tōu whaka­aro rānei tēnei, e te tangata e whaka­hē ana ki ngā kai­mahi i aua mea, e mahi nā anō koe i aua mea, ko koe e ora i tā te Atua whaka­hē? ");
INSERT INTO mri_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","E whaka­hāwea ana rānei koe ki ngā rawa o tōna ngā­wari, o tāna tikanga māhaki, o tōna manawa­nui, e ranea tonu nei; tē mahara ko te ngā­wari o te Atua hei ārahi i a koe ki te rīpe­netā? ");
INSERT INTO mri_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Heoi, pakeke tonu koe, kāhore e rīpe­netā tōu ngākau, e pū­ranga ana koe i te riri mōu, mō te rā o te riri, o te whaka­kite­nga mai anō i tā te Atua whaka­wā­kanga tika. ");
INSERT INTO mri_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Māna e hōmai ki tētahi, ki tētahi, kia rite ki ā rātou mahi. ");
INSERT INTO mri_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ki te hunga e whai ana ki te korōria, ki te hōnore, ki te pirau­kore, me te mau anō ki te mahi pai, he ora tonu. ");
INSERT INTO mri_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ki te hunga ia e totohe ana, e turi ana ki te pono, e whaka­rongo ana hoki ki te hē, he riri, he ārita­rita. ");
INSERT INTO mri_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","He pāwera, he raru, mō ngā wairua tangata katoa e mahi ana i te kino, mō te Hūrai ki mua, mō te Kariki anō hoki; ");
INSERT INTO mri_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","he korōria ia, he hōnore, he rangi­mārie, mō ngā tāngata katoa e mahi ana i te pai, mō te Hūrai ki mua, mō te Kariki anō hoki. ");
INSERT INTO mri_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kāhore hoki a te Atua whaka­pai kanohi. ");
INSERT INTO mri_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ko te hunga hoki i hara ture­kore, ka ngaro ture­kore anō hoki; me te hunga i hara i runga i te ture, kei te ture anō he whaka­hē mō rātou. ");
INSERT INTO mri_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","He teka hoki ko ngā kai­whaka­rongo o te ture e tika ki tā te Atua; engari, ko ngā kai­mahi o te ture e whaka­tikaia. ");
INSERT INTO mri_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","I te mea hoki e mahia māori­tia ana ngā mea o te ture e ngā tauiwi, kāhore nei ō rātou ture, ko ēnei, kāhore nei ō rātou ture, hei ture ki a rātou anō. ");
INSERT INTO mri_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","I te mea ka whaka­kite rātou i te mahi a te ture, he mea tuhi­tuhi ki ō rātou ngākau, me te whaka­ae tahi anō ō rātou hine­ngaro, ko ō rātou whaka­aro kei te whaka­hēhē, kei te whaka­tika­tika rānei i a rātou. ");
INSERT INTO mri_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","I te rā e whaka­wā ai te Atua i ngā mea ngaro a ngā tāngata, he mea whaka­rite tonu ki tāku rongo­pai, he mea­tanga nā Īhu Karaiti. ");
INSERT INTO mri_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Otirā, me­he­mea e tapa­ina ana koe he Hūrai, ā, e whaka­whiri­naki ana koe ki te ture, e whaka­mana­mana ana ki te Atua; ");
INSERT INTO mri_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ā, e mōhio ana ki tāna e pai ai, ā, e kitea ana e koe ngā mea e tino pai ana, he mea whaka­ako hoki koe nā te ture; ");
INSERT INTO mri_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ā, e ū ana tōu whaka­aro, ko koe hei kai­ārahi mō ngā matapō, hei mārama mō te hunga i roto i te pōuri, ");
INSERT INTO mri_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","hei kai­whaka­tika­tika mō ngā kūware, hei kai­whaka­ako mō ngā kō­hunga­hunga; kei a koe hoki te āhua o te mātau­ranga, o te pono i runga i te ture. ");
INSERT INTO mri_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","He kai­whaka­ako koe i tērā atu, e kore ianei koe e whaka­ako i a koe anō? E kauwhau nā koe kia kaua e tāhae, e tāhae ana rānei koe? ");
INSERT INTO mri_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ā, koe e mea nā, Kaua e pūremu, e pūremu ana rānei koe? Ā, koe e whaka­riha­riha nā ki ngā whaka­pakoko, e tāhae ana rānei koe i ngā mea o ngā teme­para? ");
INSERT INTO mri_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ā, koe e whaka­mana­mana nā ki te ture, kei te whaka­iti rānei koe i te Atua i te mea ka takahi koe i te ture? ");
INSERT INTO mri_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“Nā koutou hoki i kohu­kohua ai te ingoa o te Atua i roto i ngā tauiwi, i pērā­tia ai me te mea kua oti te tuhi­tuhi.” ");
INSERT INTO mri_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","E whai tikanga ana hoki te kotinga, ki te mahia e koe te ture; tēnā ki te takahi koe i te ture, ka riro tōu kotinga hei kotinga­kore. ");
INSERT INTO mri_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nā, ki te mau i te kotinga­kore ngā tikanga o te ture, e kore ianei tōna kotinga­kore e kīa hei kotinga? ");
INSERT INTO mri_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ā, ki te rite te ture i te mea kīhai kotia māori­tia, e kore ianei ia e whaka­hē i a koe, e whi­whi nā ki te kupu tuhi­tuhi me te kotinga, i a koe e takahi nā i te ture? ");
INSERT INTO mri_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ehara hoki i te Hūrai te mea ko waho noa iho tōna āhua Hūrai; ehara anō i te kotinga te mea nō waho, nō te kiko­kiko. ");
INSERT INTO mri_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Engari, he Hūrai ia, nō roto tōna āhua Hūrai; ā, ko te kotinga, nō te ngākau, he mea wairua, he teka nā te kupu tuhi­tuhi; ehara hoki i te mea e whaka­moe­miti­tia ana e te tangata, engari e te Atua. ");
INSERT INTO mri_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ha, he aha rā te painga i hua ki te Hūrai? He aha te rawa o te kotinga? ");
INSERT INTO mri_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","He nui rā i ngā mea katoa. Ko te tua­tahi, kua ākona rātou ki ngā kupu a te Atua. ");
INSERT INTO mri_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ka pēhea, me­he­mea kāhore he whaka­pono o ētahi? E taka rānei tō te Atua pono i tō rātou whaka­pono kore? ");
INSERT INTO mri_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kāhore rāpea! Engari ko te Atua kia kitea he pono, ko ngā tāngata katoa he teka kau; ko te mea hoki ia i tuhi­tuhia, “Kia tika ai tāu i tāu kōrero­tanga, kia puta ai tāu ina whaka­wā­kia koe.” ");
INSERT INTO mri_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ha, ki te mea nā tō tātou hē i kitea nuitia ai tō te Atua tika, me pēhea he kupu mā tātou? E hē ana rānei te Atua i a ia e whaka­pā ana i te riri? (He kupu tangata tēnei nāku.) ");
INSERT INTO mri_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kāhore rāpea! Pēnei me pēhea te Atua e whaka­wā ai i te ao? ");
INSERT INTO mri_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Nā, ki te mea nā tōku teka i hira rawa ai tō te Atua pono hei korōria mōna; he aha ahau i whaka­hē­ngia tonu­tia ai ānō hei tangata hara? ");
INSERT INTO mri_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","He aha hoki tē pēnei ai, ā, ko te kupu whaka­pae teka tēnei mō mātou, ā, ki tā ētahi ko tā mātou kupu tēnei, “Tātou ka mahi i te kino, kia puta ai he pai”? Tika tonu te tau o te hē ki a rātou. ");
INSERT INTO mri_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","He aha koia? He pai ake rānei tō mātou wāhi i tō rātou? Kāhore rā hoki; kua oti hoki te whaka­pā e mātou i mua he hē ki ngā Hūrai, ki ngā Kariki, kei raro katoa rātou i te hara; ");
INSERT INTO mri_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ko te mea hoki ia i tuhi­tuhia: “Kāhore he tangata tika, kāhore kia kotahi; ");
INSERT INTO mri_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","kāhore he tangata e mātau ana, kāhore he tangata e rapu ana i te Atua. ");
INSERT INTO mri_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kua peka kē rātou katoa, kua kino ngā­tahi; kāhore he tangata e mahi ana i te pai, kāhore rawa kia kotahi. ");
INSERT INTO mri_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","He urupā puare noa tō rātou koro­koro; e pati­pati ana ō rātou arero; kei roto i ō rātou ngutu te wai whaka­mate o ngā nākahi; ");
INSERT INTO mri_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","kī tonu ō rātou māngai i te kanga, i te nana­kia. ");
INSERT INTO mri_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ko ō rātou wae­wae, hohoro tonu ki te whaka­heke toto; ");
INSERT INTO mri_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","he whaka­ngaro, he ngākau pōuri, kei ō rātou ara; ");
INSERT INTO mri_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","kāhore hoki rātou i mōhio ki te ara o te rangi­mārie. ");
INSERT INTO mri_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Kāhore he wehi o te Atua i mua i ō rātou kanohi.” ");
INSERT INTO mri_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nā, e mātau ana tātou ki ngā kupu o te ture, e kōrero ana ki te hunga i te ture, kia kopia ai ngā māngai katoa, kia whaka­wā­kia ai te ao katoa e te Atua. ");
INSERT INTO mri_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nō te mea kāhore he mahi o te ture e tika ai tētahi kiko­kiko i tōna aro­aro; mā roto mai i te ture te mātau­ranga ki te hara. ");
INSERT INTO mri_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Otiia, kua whaka­kitea ināia­nei he tika a te Atua, motu kē i te ture, he mea whaka­atu nā te ture, nā ngā poro­piti; ");
INSERT INTO mri_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","arā, ko te tika a te Atua e nā runga mai ana i te whaka­pono ki a Īhu Karaiti ki te hunga katoa e whaka­pono ana. Kāhore hoki he poka­nga kētanga; ");
INSERT INTO mri_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kua hara katoa hoki, ā, kāhore e taea e rātou te korōria o te Atua; ");
INSERT INTO mri_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","he mea whaka­tika utu­kore nā tōna aroha noa, i runga i tā Karaiti Īhu hoko­nga; ");
INSERT INTO mri_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ko ia hoki tā te Atua i whaka­ari ai hei whaka­mārie, i runga i te whaka­pono, he mea nā ōna toto. Kia whaka­kitea ai tōna tika, i te mea ka whaka­pahemo­tia atu ngā hara ō mua, he mea hoki nā te manawa­nui o te Atua; ");
INSERT INTO mri_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","hei whaka­kite i tōna tika i tēnei wā nei anō; he mea kia tika ai ia anō, me te kai­whaka­tika i te tangata e whaka­pono ana ki a Īhu. ");
INSERT INTO mri_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nā, kei hea te whaka­mana­mana? Kua āraia atu. E tēhea rite­nga ture? E tō ngā mahi? Kāhore, engari, e te ture o te whaka­pono. ");
INSERT INTO mri_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Koia mātou ka mea ai, kei te whaka­pono he tika mō te tangata, motu kē i ngā mahi o te ture. ");
INSERT INTO mri_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ko te Atua oti te Atua o ngā Hūrai anake? Ehara rānei ia i te Atua o ngā tauiwi hoki? Āe rā, o ngā tauiwi anō hoki; ");
INSERT INTO mri_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ki te mea ia he kotahi te Atua, ā, māna e whaka­tika te kotinga i runga i te whaka­pono, me te kotinga­kore ina whaka­pono. ");
INSERT INTO mri_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","E taka rānei te ture i tā mātou, arā i te whaka­pono? Kāhore rāpea! Engari, nā tā mātou i ū ai te ture. ");
INSERT INTO mri_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","He aha rā, ki tā tātou, te mea i riro i a Āperahama, i tō tātou tupuna i runga i te kiko­kiko? ");
INSERT INTO mri_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Me­he­mea hoki nā ngā mahi i tika ai a Āperahama, he mea tāna e whaka­mana­mana ai ia; otirā, kāhore ki te Atua. ");
INSERT INTO mri_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","E pēhea ana oti tā te karaipi­ture? “I whaka­pono a Āperahama ki te Atua, ā, whaka­iria ana hei tika mōna.” ");
INSERT INTO mri_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nā, he tangata e mahi ana, e kore e kīa te utu mōna he mea aroha noa, engari, he mea mō tāna. ");
INSERT INTO mri_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Otirā, ko te tangata kāhore e mahi, engari, e whaka­pono ana ki te kai­whaka­tika i te tangata karakia­kore, ka whaka­iria tōna whaka­pono hei tika mōna. ");
INSERT INTO mri_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Pērā hoki me tā Rāwiri kōrero i te manaaki ki te tangata, ka whaka­iria nei e te Atua he tika ki a ia, motu kē i ngā mahi. ");
INSERT INTO mri_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","I kī ai ia, “Ka hari te hunga kua oti ā rātou mahi tutū te muru, ō rātou hara te hīpoki! ");
INSERT INTO mri_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ka hari te tangata e kore nei e whaka­iria e te Ariki he hara ki a ia.” ");
INSERT INTO mri_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","E kōrero­tia ana rānei tēnei hari­nga mō te kotinga, mō te kotinga­kore anō rānei? E mea ana hoki tātou, “I whaka­iria tōna whaka­pono hei tika mō Āperahama.” ");
INSERT INTO mri_vpl VALUES ("RM4_10","0