﻿USE sofia;
DROP TABLE IF EXISTS sofia.mri2012_vpl;
CREATE TABLE mri2012_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mri2012_vpl WRITE;
INSERT INTO mri2012_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","He mea hanga nā te Atua i te tīmatanga te rangi me te whenua, ");
INSERT INTO mri2012_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ā, kāhore he āhua o te whenua, i takoto kau; he pōuri anō a runga i te mata o te hōhonu. Nā, ka whakapāho te Wairua o te Atua i runga i te kare o ngā wai. ");
INSERT INTO mri2012_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ā, ka kī te Atua, “Kia mārama”; nā, ka mārama. ");
INSERT INTO mri2012_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ā, ka kite te Atua i te mārama, he pai; ā, ka wehea e te Atua te mārama i te pōuri. ");
INSERT INTO mri2012_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nā, ka huaina e te Atua te mārama ko te Awatea, ā, ko te pōuri i huaina e ia ko te Pō. Ā, ko te ahiahi, ko te ata, he rā kotahi. ");
INSERT INTO mri2012_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nā, ka mea te Atua, “Kia whai kikorangi a waenganui o ngā wai, hei wehe i waenganui o ngā wai.” ");
INSERT INTO mri2012_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nā, ka hangā e te Atua te kikorangi, ka wehea e ia ngā wai i raro o te kikorangi i ngā wai o runga o te kikorangi. Ā, ka oti. ");
INSERT INTO mri2012_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nā, ka huaina te kikorangi e te Atua ko te Rangi. Ā, ko te ahiahi, ko te ata, he rā tuarua. ");
INSERT INTO mri2012_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nā, ka mea te Atua, “Kia huihuia ngā wai i raro i te rangi kia kotahi te wāhi, ā, kia puta te tuawhenua.” Ā, ka oti. ");
INSERT INTO mri2012_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nā, ka huaina e te Atua te tuawhenua ko te “whenua”; ā, ko te huihuinga o ngā wai i huaina e ia ko ngā Moana. Ā, ka kite te Atua, he pai. ");
INSERT INTO mri2012_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nā, ka mea te Atua, “Kia pihi ake te tarutaru i te whenua: te otaota whai purapura, me te rākau hua, ki runga ki te whenua, e hua ana ōna hua, he mea rite tonu ki a ia, kei roto nei i a ia ōna purapura.” Ā, ka oti. ");
INSERT INTO mri2012_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nā, ka whakaputaina e te whenua te tarutaru: te otaota hoki e hua ana ōna hua he mea rite tonu ki a ia, me te rākau whai hua, kei roto nei i a ia ōna purapura he mea rite tonu ki a ia. Ā, ka kite te Atua, he pai. ");
INSERT INTO mri2012_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ā, ko te ahiahi, ko te ata, he rā tuatoru. ");
INSERT INTO mri2012_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nā, ka mea te Atua, “Kia whai mea whakamārama te kiko o te rangi, hei wehe i te awatea, i te pō; hei tohu anō aua mea, hei tāima, hei rā, hei tau. ");
INSERT INTO mri2012_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Hei whakamārama aua mea i te kiko o te rangi, hei whakamārama i te whenua.” Ā, ka oti. ");
INSERT INTO mri2012_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nā, ka hangā e te Atua ngā mea whakamārama nui e rua – ko te whakamārama nui hei tohutohu mō te awatea, ko te whakamārama tuaiti hei tohutohu mō te pō – i hangā anō hoki e ia ngā whetū. ");
INSERT INTO mri2012_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ā, whakanohoia ana aua mea e te Atua ki te kiko o te rangi, hei whakamārama mō te whenua, ");
INSERT INTO mri2012_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","hei tohutohu i te awatea, i te pō, hei wehe hoki i te mārama, i te pōuri. Ā, ka kite te Atua, he pai. ");
INSERT INTO mri2012_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ā, ko te ahiahi, ko te ata, he rā tuawhā. ");
INSERT INTO mri2012_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nā, ka mea te Atua, “Kia ngahue ake i roto i ngā wai te mea ora e ngōki ana, kia rere anō hoki te manu i runga ake i te whenua i te mata o te kiko o te rangi.” ");
INSERT INTO mri2012_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nā, ka hangā e te Atua ngā tohorā nunui, me ngā mea ora katoa, ngā mea ngōkingōki i ngahue ake nei i roto i ngā wai, o ia āhua, o ia āhua, me ngā manu whai parirau katoa, o ia āhua, o ia āhua. Ā, ka kite te Atua, he pai. ");
INSERT INTO mri2012_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nā, ka manaaki te Atua i a rātou, ka mea, “Kia hua koutou, kia tini, kia kapi hoki ngā wai o ngā moana i a koutou, kia tini anō hoki ngā manu ki runga ki te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ā, ko te ahiahi, ko te ata, he rā tuarima. ");
INSERT INTO mri2012_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Nā, ka mea te Atua, “Kia whakaputaina e te whenua te mea ora o ia āhua, o ia āhua, te kararehe me te mea ngōkingōki me te kīrehe o te whenua o ia āhua, o ia āhua.” Ā, ka oti. ");
INSERT INTO mri2012_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nā, ka hangā e te Atua te kīrehe o te whenua o ia āhua, o ia āhua, me te kararehe o ia āhua, o ia āhua, me ngā mea ngōkingōki katoa o te whenua o ia āhua, o ia āhua; ā, ka kite te Atua he pai. ");
INSERT INTO mri2012_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Nā, ka mea te Atua, “Kia hanga tātou i te tangata kia rite ki a tātou, hei tō tātou anō te āhua. Ā, kia waiho ko rātou hei rangatira mō ngā ika o te moana, mō te manu o te rangi, mō ngā kararehe hoki, mō te whenua katoa, mō ngā mea ngōkingōki katoa anō hoki e ngōkingōki ana i runga i te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nā, ka hangā e te Atua te tangata rite tonu ki a ia; i hangā e ia kia rite ki te Atua; i hangā rāua he tāne, he wahine. ");
INSERT INTO mri2012_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nā, ka manaakitia rāua e te Atua, ā, ka mea te Atua ki a rāua, “Kia hua, kia tini, kia kapi hoki te whenua i a kōrua, kia mate hoki ōna tara i a kōrua; ko kōrua hei rangatira mō te ika o te moana, mō te manu hoki o te rangi, mō ngā mea ora katoa anō hoki e ngōkingōki ana i runga i te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ā, ka mea te Atua, “Nā, kua oti te hoatu e ahau ki a kōrua ngā otaota katoa e whai purapura ana i runga i te mata o te whenua katoa, me te rākau katoa, he hua rākau tōna e whai purapura ana; hei kai ēnā mā kōrua. ");
INSERT INTO mri2012_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ā, kua hoatu anō e ahau ngā otaota matomato katoa hei kai mā ngā kararehe katoa o te whenua, mā ngā manu katoa o te rangi, mā ngā mea katoa hoki e ngōkingōki ana i runga i te whenua kei roto nei i a rātou he wairua ora.” Ā, ka oti. ");
INSERT INTO mri2012_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ā, ka kite te Atua i ngā mea katoa kua hangā nei e ia, nā, pai whakaharahara. Ā, ko te ahiahi, ko te ata, ko te rā tuaono. ");
INSERT INTO mri2012_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nā, ka oti te rangi me te whenua me ō reira mano katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ā, nō te whitu o ngā rā i oti ai i te Atua tāna mahi i mahi ai, nā, ka okioki ia i te rā whitu i āna mahi katoa i mahia e ia. ");
INSERT INTO mri2012_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nā, ka whakapaingia e te Atua te rā whitu, whakatapua ana hoki e ia; mōna i okioki i taua rā i āna mahi katoa i oti i te Atua te hanga. ");
INSERT INTO mri2012_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ko ngā whakatupuranga ēnei o te rangi, o te whenua, i te hanganga ai. I te rā i hangā ai e Ihowā, e te Atua, te whenua me te rangi. ");
INSERT INTO mri2012_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Kāhore anō hoki tētahi rākau riki o te pārae i te whenua, kāhore anō tētahi otaota o te pārae kia pihi noa – kāhore hoki a Ihowā, te Atua, i mea kia ua ki te whenua, ā, kāhore rawa he tangata hei mahi i te oneone; ");
INSERT INTO mri2012_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","engari, i pupū ake he kohu i te whenua, nā reira i whakamākūkū te mata katoa o te oneone – ");
INSERT INTO mri2012_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","nā, ka whakaahuatia te tangata e Ihowā, e te Atua, he puehu nō te oneone, ā, whakahāngia ana e ia ki roto ki ōna pongāihu te manawa ora; ā, ka wairua ora te tangata. ");
INSERT INTO mri2012_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nā, ka whakatōkia e Ihowā, e te Atua, tētahi kāri ki te taha ki te rāwhiti, ki Erene; ā, whakanohoia iho e ia ki reira te tangata i hangā e ia. ");
INSERT INTO mri2012_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ā, i whakatupuria e Ihowā, e te Atua, i roto i te oneone ngā rākau katoa he mea āhuareka ki te titiro, he pai hoki hei kai; ko te rākau hoki o te ora ki waenganui o te kāri, me te rākau o te mātauranga ki te pai, ki te kino. ");
INSERT INTO mri2012_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","I rere mai anō he awa i Erene hei whakamākūkū i te kāri; ā, i reira ka manganga e whā ngā tino awa. ");
INSERT INTO mri2012_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ko te ingoa o te tuatahi ko Pihona; ko ia tērā e taiāwhio rā i te whenua katoa o Hāwira, he kōura kei reira. ");
INSERT INTO mri2012_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","He pai hoki te kōura o taua whenua; kei reira te teriuma me te kōhatu onika. ");
INSERT INTO mri2012_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ko te ingoa o te rua o ngā awa ko Kihona; ko ia tērā e taiāwhio rā i te whenua katoa o Etiopia. ");
INSERT INTO mri2012_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ko te ingoa o te toru o ngā awa ko Hirekere; ko te mea tērā e rere rā i mua o Ahiria. Ko Uparati te whā o ngā awa. ");
INSERT INTO mri2012_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nā, ka tango a Ihowā, te Atua, i te tangata, ā, whakanohoia ana e ia ki te kāri o Erene, hei ngaki, hei tiaki hoki i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Nā, ka ako a Ihowā, te Atua, ki te tangata, ka mea, “E pai ana kia kai noa atu koe i ngā hua o ngā rākau katoa o te kāri; ");
INSERT INTO mri2012_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ko te rākau ia o te mātauranga ki te pai, ki te kino, kaua e kainga tētahi o ōna hua; ko te rā e kai ai koe i tētahi o ōna hua, ka mate koe, mate rawa.” ");
INSERT INTO mri2012_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Nā, ka mea a Ihowā, te Atua, “E kore e pai kia noho te tangata ko ia anake; me hanga e ahau tētahi hoa pai mōna.” ");
INSERT INTO mri2012_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Nā, he mea whakaahua mai nā Ihowā, nā te Atua, i roto i te oneone ngā kīrehe katoa o te pārae, me ngā manu katoa o te rangi; ā, kawea mai ana e ia ki a Ārama, kia kitea ai te ingoa e huaina e ia ki a rātou; ā, ko a Ārama i hua ai ki ngā mea ora katoa, hei ingoa ērā mō rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Nā, ka huaina e Ārama he ingoa mō ngā kararehe katoa, mō ngā manu o te rangi, mō ngā kīrehe katoa hoki o te pārae. Ko Ārama ia kāhore i kitea tētahi hoa pai mōna. ");
INSERT INTO mri2012_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nā, ka mea a Ihowā, te Atua, kia parangia a Ārama e te moe, ā, moe ana ia. Nā, tangohia ana e ia tētahi o ōna rara, ā, whakatūtakina atu ana te kikokiko hei whakakapi mō reira. ");
INSERT INTO mri2012_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nā, ka hanga a Ihowā, te Atua, i te rara i tangohia mai rā e ia i roto i a Ārama hei wahine, ā, kawea ana e ia ki a Ārama. ");
INSERT INTO mri2012_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ā, ka mea a Ārama, “Kātahi anō ki tēnei te wheua o roto o ōku wheua, me te kikokiko o roto o ōku kikokiko; me hua ia ko te Wahine, nōna hoki i tangohia mai i roto i te Tangata.” ");
INSERT INTO mri2012_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nō konei te tangata ka whakarere i tōna pāpā me tōna whaea, ā, ka piri ki tāna wahine; ā, hei kikokiko kotahi rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ā, e tū tahanga ana rāua tokorua, te tangata me tāna wahine, kīhai hoki i whakamā. ");
INSERT INTO mri2012_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nā, ko te nākahi he mōhio rawa i ngā kīrehe katoa o te pārae i hangā nei e Ihowā, e te Atua. Nā, ko tāna meatanga ki te wahine, “Koia, i mea anō te Atua, ‘Kaua e kainga e kōrua ngā hua o tētahi rākau o te kāri’?” ");
INSERT INTO mri2012_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ā, ka mea te wahine ki te nākahi, “E kai anō māua i ngā hua o ngā rākau o te kāri. ");
INSERT INTO mri2012_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ko ngā hua ia o te rākau i waenganui o te kāri, kua mea mai te Atua, ‘Kaua kōrua e kai i tētahi o ōna hua, kaua anō hoki e pā ki reira, kei mate kōrua.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nā, ko te meatanga a te nākahi ki te wahine, “E kore kōrua e mate rawa. ");
INSERT INTO mri2012_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Erangi, e mōhio ana te Atua ko te rā e kai ai kōrua i tētahi o ōna hua, kātahi ka mārama ō kōrua kanohi, ā, ka rite kōrua ki te Atua, ka mōhio ki te pai, ki te kino.” ");
INSERT INTO mri2012_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ā, i te kitenga o te wahine he pai te rākau rā hei kai, he āhuareka ki te titiro atu, he rākau hoki e minaminatia hei whakamōhio, nā, ka tango ia i ētahi o ōna hua, ka kai, ka hoatu hoki ki tāna tahu i tōna taha; ā, kai ana ia. ");
INSERT INTO mri2012_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nā, ka mārama ō rāua kanohi tahi, ka mōhio rāua kei te tū tahanga rāua; nā, ka tuia e rāua ētahi rau piki, meatia ana hei rāpaki mō rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ā, ka rongo rāua i te reo o Ihowā, o te Atua, e hāereere ana i te kāri i te hauhautanga o te rā; ā, ka piri a Ārama rāua ko tāna wahine i te aroaro o Ihowā, o te Atua, ki roto ki ngā rākau o te kāri. ");
INSERT INTO mri2012_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Nā, ka karanga a Ihowā, te Atua, ki a Ārama, ka mea ki a ia, “Kei hea koe?” ");
INSERT INTO mri2012_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ā, ka mea ia, “I rongo ahau ki tōu reo i te kāri, ā, wehi ana ahau, nōku i tū tahanga; nā piri ana ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nā, ka mea ia, “Nā wai i mea ki a koe e tū tahanga ana koe? Kua kainga rānei e koe ētahi o ngā hua o te rākau i kīia atu rā e ahau ki a koe, ‘Kaua ōna hua e kainga’?” ");
INSERT INTO mri2012_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nā, ka mea te tangata rā, “Nā te wahine i hōmai nei e koe hei hoa mōku, nāna i hōmai ētahi o ngā hua o te rākau ki ahau, ā, kainga ana e ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nā, ka mea a Ihowā, te Atua, ki te wahine, “He aha tēnei kua meatia nei e koe?” Ka mea te wahine, “Nā te nākahi ahau i māminga, ā, kai ana ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nā, ka mea a Ihowā, te Atua, ki te nākahi, “Mō tēnei mahi āu nui atu te kanga mōu i ō ngā kararehe katoa, i ō ngā kīrehe katoa o te pārae; ko tōu kōpū hei haere mōu, ko te puehu hei kai māu i ngā rā katoa e ora ai koe. ");
INSERT INTO mri2012_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ka whakatupuria hoki e ahau he pakanga mā kōrua ko te wahine, mā tōu uri rātou ko tōna uri; ka marū tōu mātenga i a ia, ka marū i a koe tōna rekereke.” ");
INSERT INTO mri2012_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ka mea ia ki te wahine, “Ka whakanuia rawatia e ahau tōu mamae, me tōu hapūtanga; ka mamae koe ina whānau tamariki; ka hiahia koe ki tō tahu, ko ia anō hoki hei rangatira mōu.” ");
INSERT INTO mri2012_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ā, ka mea ia ki a Ārama, “Mō tōu rongonga ki te reo o tāu wahine, mō tāu kainga hoki i te hua o te rākau i kīia atu e ahau ki a koe, i meatia atu rā, ‘Kaua e kainga ētahi o ōna hua.’ Ka oti te oneone te kanga mō tāu mahi; ka kainga e koe ōna hua i runga i te mamae i ngā rā katoa e ora ai koe. ");
INSERT INTO mri2012_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","He tātarāmoa anō hoki, he tūmatakuru āna e whakatupu ake ai māu; ā, ka kai koe i te otaota o te pārae. ");
INSERT INTO mri2012_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mā te werawera o tōu mata e kai ai koe i te taro, ā hoki noa koe ki te oneone; i tangohia mai nei hoki koe i reira; he puehu hoki koe, ā, ka hoki anō ki te puehu.” ");
INSERT INTO mri2012_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ā, i huaina e Ārama te ingoa o tāna wahine ko Iwi; nō te mea ko te whaea ia o ngā mea ora katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nā, ka hangā e Ihowā, e te Atua, ētahi kākahu hiako mō Ārama rāua ko tāna wahine, ā, whakakākahuria ana rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nā, ka mea a Ihowā, te Atua, “Nanā, kua rite nei te tangata ki tētahi o tātou, te mōhio ki te pai, ki te kino; nā, kei totoro atu tōna ringa āianei, kei tango i tētahi o ngā hua o te rākau o te ora, kei kai, ā, ka ora tonu.” ");
INSERT INTO mri2012_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Koia i tonoa atu ai ia e Ihowā, e te Atua, i te kāri o Erene hei ngaki i te oneone i tangohia mai nei ia i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Heoi, peia ana e ia te tangata; ā, whakanohoia ana ki te taha ki te rāwhiti o te kāri o Erene tētahi kerupima, me tētahi hoari mura, he mea piupiu tonu ki tētahi taha, ki tētahi taha, hei tiaki i te huarahi ki te rākau o te ora. ");
INSERT INTO mri2012_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nā, ka mōhio a Ārama ki a Iwi, ki tāna wahine, ā, ka hapū ia. Ā, ka whānau a Kaina, nā, ka mea ia, “Kua whakawhiwhia mai ahau e Ihowā ki tētahi tangata.” ");
INSERT INTO mri2012_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Nā, ka whānau anō tōna teina, a Āpera. Nā, he kaiwhāngai hipi a Āpera, ko Kaina ia he kaingaki whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ā, i te mutunga o ētahi rangi, ka kawea e Kaina ētahi o ngā hua o te whenua hei whakahere ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Me Āpera hoki, i kawea e ia ētahi o ngā whānau mātāmua o tāna kāhui, o ō rātou ngako hoki. Ā, ka aro a Ihowā ki a Āpera, ki tāna whakahere, ");
INSERT INTO mri2012_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","kīhai ia i aro ki a Kaina, ki tāna whakahere. Ā, he nui rawa te riri o Kaina, ā, whakapoururu ana tōna mata. ");
INSERT INTO mri2012_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nā, ka mea a Ihowā ki a Kaina, “He aha koe i riri ai, ā, he aha i whakapoururu ai tōu mata? ");
INSERT INTO mri2012_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","E kore ianei koe e kake, ki te mahi koe i te pai? Ki te kāhore koe e mahi i te pai, kei te kūwaha te hara e takoto ana. Nā, ko koe tāna e hiahia ai, ko koe ia hei rangatira mōna.” ");
INSERT INTO mri2012_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nā, ka kōrero a Kaina ki a Āpera, ki tōna teina, “Ā, i a rāua i te pārae.” Ka whakatika a Kaina ki a Āpera, ki tōna teina, ā, patua iho. ");
INSERT INTO mri2012_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kātahi a Ihowā ka mea ki a Kaina, “Kei hea a Āpera, tōu teina?” Ka mea ia, “Kāhore ahau e mōhio. Ko ahau ianei te kaitiaki o tōku teina?” ");
INSERT INTO mri2012_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nā, ka mea ia, “He mahi aha tēnei āu? E tangi mai ana te reo o te toto o tōu teina ki ahau i roto i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nā, ka kangā koe i runga i te whenua, i hāmama nei tōna waha hei rerenga atu mō te toto o tōu teina i whakahekea nei e tōu ringa. ");
INSERT INTO mri2012_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ka ngaki koe i te oneone, e kore e tukua tōna kaha ā muri ake nei ki a koe; ka waiho koe hei tangata hāereere noa, hei manene i runga i te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Nā, ka mea a Kaina ki a Ihowā, “He nui rawa te whiu mō tōku kino, e kore e taea e ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Titiro hoki, ka peia ahau e koe ināianei i te mata o te whenua, ā, ka ngaro i tōu kanohi. Ka waiho hoki ahau hei tangata hāereere noa, hei manene i runga i te whenua; ā, tēnei ake, ki te tūtaki tētahi tangata ki ahau, nā, ka patua ahau e ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nā, ka mea a Ihowā ki a ia, “Nā reira ki te patu tētahi i a Kaina, whitu ngā utu e rapua i a ia.” Nā, ka hōmai e Ihowā he tohu ki a Kaina, kei patua ia e tētahi tangata ina tūtaki ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Nā, ka haere atu a Kaina i te aroaro o Ihowā, ā, noho ana i te whenua o Noro, i te taha ki te rāwhiti o Erene. ");
INSERT INTO mri2012_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nā, ka mōhio a Kaina ki tāna wahine; ā, ka hapū ia, ka whānau a Ēnoka. Nā, ka hanga ia i tētahi pā, ā, huaina iho te ingoa o te pā ko Ēnoka, ko te ingoa o tāna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ā, whānau ake tā Ēnoka tama ko Irara; nā Irara ko Mehutaere: tā Mehutaere ko Metuhaere; tā Metuhaere ko Rameka. ");
INSERT INTO mri2012_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Nā, ka tangohia e Rameka ētahi wāhine tokorua māna; ko Āraha te ingoa o tētahi, ko Tira tō tētahi. ");
INSERT INTO mri2012_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Nā, ka whānau tā Āraha tama ko Iapara. Ko ia te matua o te hunga noho tēneti, rātou ko ngā tāngata whāngai kararehe. ");
INSERT INTO mri2012_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ā, ko te ingoa o tōna teina ko Iupara. Ko ia te matua o ngā mea rahurahu ki te hāpa, ki te ōkana. ");
INSERT INTO mri2012_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Me Tira anō hoki, whānau ake tāna ko Tuparakaina, he kaihanga ia i ngā mea tapahi katoa i te mea parāhi, i te mea rino. Ā, ko Naama te tuahine o Tuparakaina. ");
INSERT INTO mri2012_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Nā, ka mea a Rameka ki āna wāhine: “E Āraha rāua ko Tira, whakarongo mai ki tōku reo; e ngā wāhine a Rameka, kia whai taringa mai ki tāku kupu: Kua patua hoki he tangata e ahau mōku i motu, he taitamariki hoki mōku i marū. ");
INSERT INTO mri2012_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Nā, mō Kaina e whitu ngā utu, ina, kia whitu tekau mā whitu mō Rameka.” ");
INSERT INTO mri2012_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ā, i mōhio anō a Ārama ki tāna wahine; ka whānau tāna tama, ā, huaina iho tōna ingoa ko Heta; i mea hoki ia, “Ka rite mai nei i te Atua tētahi atu uri mōku hei whakakapi mō Āpera i patua nei e Kaina.” ");
INSERT INTO mri2012_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Me Heta anō hoki, i whānau tāna tama; ā, huaina ana tōna ingoa ko Ēnoha. Nō reira i tīmata ai te tangata te karanga ki te ingoa o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ko te pukapuka tēnei o ngā whakatupuranga o Ārama. I te rā i hangā ai te tangata e te Atua, i hangā ia e ia kia rite ki te Atua. ");
INSERT INTO mri2012_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I hangā rāua he tāne, he wahine, ā, i manaakitia rāua e ia, i huaina hoki tō rāua ingoa ko Ārama, i te rā i hangā ai rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ā, ka kotahi rau ka toru tekau ngā tau i ora ai a Ārama, nā, ka whānau tāna tama, nōna te āhua, rite tonu ki a ia; ā, huaina ana tōna ingoa ko Heta. ");
INSERT INTO mri2012_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ā, ko ngā rā o Ārama i muri i te whānautanga o Heta e waru rau tau. Ā, ka whānau he tama, he tamāhine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nā, ko ngā rā katoa i ora ai a Ārama e iwa rau e toru tekau tau; ā, ka mate ia. ");
INSERT INTO mri2012_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ā, kotahi rau e rima ngā tau i ora ai a Heta, ka whānau tāna tama, a Ēnoha. ");
INSERT INTO mri2012_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ā, e waru rau e whitu ngā tau i ora ai a Heta i muri iho i te whānautanga o tāna tama, o Ēnoha, ā, ka whānau he tama, he tamāhine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nā, ko ngā rā katoa o Heta e iwa āu kotahi tekau mā rua tau; ā, ka mate ia. ");
INSERT INTO mri2012_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ā, ka iwa tekau ngā tau i ora ai a Ēnoha, nā, ka whānau tāna tama a Kēnana. ");
INSERT INTO mri2012_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ā, e waru rau kotahi tekau mā rima ngā tau i ora ai a Ēnoha i muri iho i te whānautanga o tāna tama, o Kēnana, ā, ka whānau he tama, he tamāhine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nā, ko ngā rā katoa o Ēnoha e iwa rau mā rima tau; ā, ka mate. ");
INSERT INTO mri2012_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ā, ka whitu tekau ngā tau i ora ai a Kēnana, ka whānau tāna tama, a Mahararēre. ");
INSERT INTO mri2012_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ā, e waru rau e whā tekau ngā tau i ora ai a Kēnana i muri iho i te whānautanga o tāna tama, o Mahararēre, ā, ka whānau he tama, he tamāhine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Nā, ko ngā rā katoa o Kēnana e iwa rau kotahi tekau tau; ā, ka mate ia. ");
INSERT INTO mri2012_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ā, ka ono tekau mā rima ngā tau i ora ai a Mahararēre, nā, ka whānau tāna tama, a Iarere. ");
INSERT INTO mri2012_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ā, e waru rau e toru tekau ngā tau i ora ai a Mahararēre i muri i te whānautanga o tāna tama, o Iarere, ā, ka whānau he tama, he tamāhine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ā, e waru rau e iwa tekau mā rima tau ngā rā katoa o Mahararēre; ā, ka mate. ");
INSERT INTO mri2012_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ā, kotahi rau e ono tekau mā rua ngā tau i ora ai a Iarere, ā, ka whānau tāna tama, a Ēnoka. ");
INSERT INTO mri2012_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ā, e waru rau ngā tau i ora ai a Iarere i muri iho i te whānautanga o tāna tama, o Ēnoka, ā, ka whānau he tama, he tamāhine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ā, e iwa rau e ono tekau mā rua tau ngā rā katoa o Iarere; ā, ka mate. ");
INSERT INTO mri2012_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ā, e ono tekau mā rima ngā tau i ora ai a Ēnoka, nā, ka whānau tāna tama, a Matuhara. ");
INSERT INTO mri2012_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ā, e toru rau ngā tau i hāereere tahi ai a Ēnoka i te Atua i muri iho i te whānautanga o tāna tama, o Matuhara, ā, ka whānau he tama, he tamāhine māna, ");
INSERT INTO mri2012_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ā, e toru rau e ono tekau mā rima tau ngā rā katoa o Ēnoka. ");
INSERT INTO mri2012_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ā, i hāereere tahi a Ēnoka i te Atua; ā, kua kāhore ia, nā te Atua hoki ia i tango. ");
INSERT INTO mri2012_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ā, kotahi rau e waru tekau mā whitu ngā tau i ora ai a Matuhara, nā, ka whānau tāna tama, a Rameka, ");
INSERT INTO mri2012_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ā, e whitu rau e waru tekau mā rua ngā tau i ora ai a Matuhara i muri iho i te whānautanga o tāna tama, o Rameka, ā, ka whānau he tama, he tamāhine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ā, e iwa rau e ono tekau mā iwa tau ngā rā katoa o Matuhara; ā, ka mate. ");
INSERT INTO mri2012_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ā, kotahi rau e waru tekau mā rua ngā tau i ora ai a Rameka, nā, ka whānau tāna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ā, huaina ana e ia tōna ingoa ko Noa; i mea hoki ia, “Mā tēnei e whakahauora o ō tātou ngākau i ā tātou mahi, i te ruha hoki o ō tātou ringa, i te oneone kua oti nei te kanga e Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ā, e rima rau e iwa tekau mā rima ngā tau i ora ai a Rameka i muri i te whānautanga o tāna tama, o Noa, ā, ka whānau he tama, he tamāhine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ā, ko ngā rā katoa o Rameka e whitu rau e whitu tekau mā whitu; ā, ka mate ia. ");
INSERT INTO mri2012_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ā, ka rima rau ngā tau o Noa, nā, ka whānau ngā tama a Noa, ko Hema, ko Hama, ko Iapeta. ");
INSERT INTO mri2012_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nā, ka tīmata te tangata te tini haere ki runga ki te mata o te whenua, ā, ka whānau ā rātou tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ka kite ngā tama a te Atua i ngā tamāhine a te tangata, he ātaahua; nā, ka tango rātou i ā rātou i pai ai o rātou katoa, hei wāhine mā rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Nā, ka mea a Ihowā, “E kore tōku wairua e whakawā tonu i te tangata, he kikokiko nei anō hoki ia. Nā, kia kotahi rau kia rua tekau tau ōna rā.” ");
INSERT INTO mri2012_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","He roroa ngā tāngata o te whenua i aua rā – ā, i muri iho – i te haerenga o ngā tama a te Atua ki ngā tamāhine a te tangata, ā, ka whānau ā rātou tamariki. Ko rātou ngā mārohirohi ō mua, he tāngata whai ingoa. ");
INSERT INTO mri2012_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ā, ka kite te Atua he nui te kino o te tangata i runga i te whenua, he kino hoki ngā tokonga ake o ngā whakaaro katoa o tōna ngākau i ngā wā katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Nā, ka puta kē te whakaaro o Ihowā i hangā ai e ia te tangata ki runga ki te whenua, ā, ka pōuri tōna ngākau. ");
INSERT INTO mri2012_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nā, ka mea a Ihowā, “Ka whakangaromia atu e ahau i te mata o te whenua te tangata i hangā nei e ahau – te tangata, te kīrehe, te mea ngōkingōki, me ngā manu o te rangi; kua puta kē hoki tōku whakaaro i hangā ai rātou e ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ko Noa ia i manakohia e Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ko ngā whakatupuranga ēnei o Noa. Ko Noa he tangata tika, he ngākau tapatahi i ōna whakatupuranga. I hāereere tahi a Noa i te Atua. ");
INSERT INTO mri2012_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ā, whānau ake ngā tama a Noa tokotoru, ko Hema, ko Hama, ko Iapeta. ");
INSERT INTO mri2012_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nā, kua kino te whenua i te aroaro o Ihowā, kua kī katoa hoki te whenua i te tutū. ");
INSERT INTO mri2012_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nā, ka titiro te Atua ki te whenua, kua kino; kua hē hoki te ara o ngā kikokiko katoa o runga o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nā, ka mea te Atua ki a Noa, “Kua tae mai ki tōku aroaro te mutunga o ngā kikokiko katoa; nō te mea kua kī i a rātou te whenua i te tutū; nā, ka whakangaromia rātou tahi ko te whenua e ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hangā e koe tētahi āka mōu ki te rākau kopera; me hanga e koe ētahi rūma ki roto i te āka, ka pani ai i roto, i waho, ki te ware. ");
INSERT INTO mri2012_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nā, kia pēnei tāu hanga i taua mea. Kia toru rau whatīanga te roa o te āka, kia rima tekau whatīanga te whānui, ko te teitei kia toru tekau whatīanga. ");
INSERT INTO mri2012_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Me hanga e koe he matapihi mō te āka, kia kotahi te whatīanga ki raro iho i te tuanui, e whakaotia ai e koe; ā, ko te tatau o te āka me whakanoho e koe ki tōna taha; ka mea ai koe he papanga rūma, tō raro, te tuarua, me te tuatoru. ");
INSERT INTO mri2012_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nā, ko ahau, tēnei ahau te tuku atu nei i te waipuke ki runga ki te whenua, hei whakangaro i ngā kikokiko katoa e whai manawa ora ana i raro i te rangi; ā, ka mate ngā mea katoa i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Otiia, ka whakamanā e ahau tāku kawenata ki a koe; me haere koe ki roto ki te āka, koutou tahi ko āu tama, ko tāu wahine, ko ngā wāhine anō hoki a āu tama. ");
INSERT INTO mri2012_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Me mau e koe ki roto ki te āka ētahi o ngā mea ora katoa o ngā kikokiko katoa, kia rua o ia āhua, o ia āhua, kia ora tahi ai me koe; hei te toa, hei te uha. ");
INSERT INTO mri2012_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ko ētahi o ngā manu o ia āhua, o ia āhua, o ngā kararehe hoki o ia āhua, o ia āhua, o ngā mea ngōkingōki katoa o te whenua o ia āhua, o ia āhua, kia tātaki rua o te katoa e haere ki a koe, kia ora ai. ");
INSERT INTO mri2012_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tangohia mai hoki māu ētahi o ngā kai katoa e kainga ana, me āmene mai ki a koe; ā, hei kai tēnā māu, mā rātou hoki.” ");
INSERT INTO mri2012_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nā, ka meatia e Noa; rite tonu ki ngā mea katoa i whakahaua mai e te Atua ki a ia tāna i mea ai. ");
INSERT INTO mri2012_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nā, ka mea a Ihowā ki a Noa, “Haere mai koutou ko tōu whare katoa ki roto ki te āka; kua kite hoki ahau i a koe he tika ki tōku aroaro i tēnei whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tangohia e koe ētahi o ngā kīrehe pokekore, kia takiwhitu, te toa me tāna uha; o ngā kararehe poke hoki, kia takirua, te toa me tāna uha; ");
INSERT INTO mri2012_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","me ngā manu anō hoki o te rangi, kia takiwhitu, te toa me te uha; kia ora ai he uri ki runga ki te mata o te whenua katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kia whitu ake hoki ngā rā ka meatia e ahau kia ua te ua ki runga ki te whenua, kia whā tekau ngā rā, kia whā tekau ngā pō; ā, ka whakangaromia atu e ahau i runga i te mata o te whenua ngā mea ora katoa i hangā e ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ā, rite tonu tā Noa i mea ai ki a Ihowā katoa i whakahau ai ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nā, e ono rau ngā tau o Noa i te putanga mai o te waipuke ki runga ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nā, ka tomo a Noa rātou tahi ko āna tama, ko tāna wahine, ko ngā wāhine hoki a āna tama, ki roto ki te āka, i te wehi i ngā wai o te waipuke. ");
INSERT INTO mri2012_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Me ētahi o ngā kīrehe pokekore, o ngā kīrehe poke hoki, o ngā manu, o ngā mea katoa anō hoki e ngōkingōki ana i runga i te whenua; ");
INSERT INTO mri2012_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","i haere tātaki rua rātou ki roto ki te āka ki a Noa, te toa me te uha, i pērā tonu me tā te Atua i whakahau ai ki a Noa. ");
INSERT INTO mri2012_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Nā, i muri iho i ngā rā e whitu ka puta mai ngā wai o te waipuke ki runga ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nō te ono rau o ngā tau o te oranga o Noa, nō te rua o ngā marama, nō te tekau mā whitu o ngā rā o te marama, nō taua rangi anō i pakaru mai ai ngā mātāpuna katoa o te rire nui, ā, ka whakatuwheratia ngā matapihi o te rangi. ");
INSERT INTO mri2012_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ā, e whā tekau ngā rā, e whā tekau ngā pō, i ua ai te ua ki runga ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nō taua rangi pū anō i tomo ai a Noa, rātou ko Hema, ko Hama, ko Iapeta, ngā tama a Noa, rātou tahi ko te wahine a Noa, ko ngā wāhine tokotoru anō hoki a āna tama, ki roto ki te āka; ");
INSERT INTO mri2012_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","rātou ko ngā kīrehe mohoao katoa o ia āhua, o ia āhua, ko ngā kararehe katoa o ia āhua, o ia āhua, ko ngā mea ngōki katoa e ngōkingōki nei i runga i te whenua, o ia āhua, o ia āhua, me ngā manu katoa, o ia āhua, o ia āhua, me ngā mea whai parirau katoa, o ia āhua, o ia āhua. ");
INSERT INTO mri2012_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nā, ka haere ki roto ki te āka ki a Noa, tātaki rua o ngā kikokiko katoa, o ngā mea whai wairua ora. ");
INSERT INTO mri2012_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ko ngā mea i haere, i haere he toa he uha o ngā kikokiko katoa, he pērā tonu me tā te Atua i whakahau ai ki a ia; ā, tūtakina ana ia e Ihowā ki roto. ");
INSERT INTO mri2012_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ā, e whā tekau ngā rā o te waipuke ki runga ki te whenua; ā, ka nui haere ngā wai, ka whakamanutia ake te āka, ā, ka maiangi ake ki runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nā, ka kaha ngā wai, ā, ka tino nui haere ki runga ki te whenua; ā, ka tere te āka i runga i te kare o ngā wai. ");
INSERT INTO mri2012_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nā, kua tino kaha rawa ngā wai ki runga ki te whenua; ā, ka taupokina ngā maunga teitei katoa i raro i te rangi, ā puta noa. ");
INSERT INTO mri2012_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Kotahi tekau mā rima ngā whatīanga i pari ake ai ngā wai; ā, taupokina ana ngā maunga. ");
INSERT INTO mri2012_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nā, ka mate ngā kikokiko katoa i korikori i runga i te whenua; te manu, te kararehe, te kīrehe, ngā mea ngōki katoa hoki i ngōkingōki i runga i te whenua, me ngā tāngata katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ko ngā mea katoa kei roto nei i ō rātou pongāihu te manawa ora, o ngā mea katoa i te tuawhenua, i mate. ");
INSERT INTO mri2012_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ā, ngaro iho ngā mea ora katoa i runga i te mata o te whenua, te tangata, te kararehe, ngā mea ngōkingōki, me te manu o te rangi; i whakangaromia atu rātou i runga i te whenua. Ā, toe ake ko te kotahi o Noa, me ngā mea i a ia, i roto i te āka. ");
INSERT INTO mri2012_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ā, kotahi rau e rima tekau ngā rā i huri ai ngā wai ki runga ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nā, ka mahara te Atua ki a Noa, ki ngā mea ora katoa me ngā kararehe katoa anō hoki i a ia i roto i te āka. Nā, ka mea te Atua kia tika atu tētahi hau i runga i te whenua, ā, ka māriri ngā wai. ");
INSERT INTO mri2012_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ā, ka tūtakina atu ngā mātāpuna o te rire me ngā matapihi o te rangi, ka whakamutua anō hoki te ua o te rangi. ");
INSERT INTO mri2012_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nā, ka hoki haere ngā wai i runga i te whenua; ā, i te paunga o ngā rā kotahi rau e rima tekau kua iti iho ngā wai. ");
INSERT INTO mri2012_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ā, i tau iho te āka i te whitu o ngā marama, i te kotahi tekau mā whitu o ngā rā o te marama, ki runga ki ngā maunga o Ararata. ");
INSERT INTO mri2012_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Me te heke haere tonu o ngā wai, ā taea noatia te tekau o ngā marama; nō te tekau o ngā marama, nō te rā tuatahi o te marama, ka kitea ngā tihi o ngā maunga. ");
INSERT INTO mri2012_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ā, i te mutunga o ngā rā e whā tekau, nā, ka uakina e Noa te matapihi o te āka i hangā e ia. ");
INSERT INTO mri2012_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ā, ka tukua atu e ia he raweni, ā, ko tōna rerenga atu, ka kōpiko atu, ka kōpiko mai, ā, maroke noa ngā wai i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nā, ka tukua atu anō e ia he kūkupa, kia kitea ai kua iti iho rānei ngā wai i runga i te mata o te whenua, ");
INSERT INTO mri2012_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ā, kīhai i kitea e te kūkupa tētahi taunga iho mō te takahanga o tōna waewae, ā, ka hoki mai ki a ia, ki roto ki te āka; i runga hoki ngā wai i te mata o te whenua katoa. Nā, ka totoro atu tōna ringa, ā, hopukia ana ia, tangohia ana mai ki a ia ki roto ki te āka. ");
INSERT INTO mri2012_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nā, ka tatari anō ia, e whitu atu ngā rā; ā, ka tukua atu anō e ia te kūkupa i roto i te āka. ");
INSERT INTO mri2012_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ā, i te ahiahi ka rere mai te kūkupa ki a ia; nā, i roto i tōna waha he rau ōriwa, he mea kōrari mai; ā, ka mōhio a Noa kua iti iho ngā wai i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ā, ka tatari anō ia, e whitu atu anō ngā rā; ā, tukua atu ana e ia te kūkupa; ā, kīhai tēnā i hoki mai anō ki a ia i muri iho. ");
INSERT INTO mri2012_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ā, nō te ono rau mā tahi o ngā tau, nō te marama tuatahi, nō te rā tuatahi o te marama, i maroke atu ai ngā wai i runga i te whenua. Nā, ka hurahia atu e Noa te hīpoki o te āka, ā, ka kite, nā, kua maroke te mata o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ā, nō te rua o ngā marama, nō te rua tekau mā whitu o ngā rā o te marama, i maroke ai te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nā, ka kōrero te Atua ki a Noa, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Puta mai koe i te āka, koutou tahi ko tāu wahine, ko āu tama, me ngā wāhine a āu tama. ");
INSERT INTO mri2012_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kia puta tahi mai me koe ngā mea ora katoa i a koe nā, ngā kikokiko katoa, ngā manu, ngā kararehe, me ngā mea ngōki katoa e ngōkingōki ana i runga i te whenua; ā, kia whakatuputupu rātou ki runga ki te whenua, kia hua, kia ngahue ki runga ki te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nā, ka puta a Noa, rātou tahi ko āna tama, ko tāna wahine, me ngā wāhine a āna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ka puta hoki i roto i te āka ngā kīrehe katoa, ngā mea ngōkingōki katoa, ngā manu katoa, me ngā mea ngōki katoa i runga i te whenua o ia āhua, o ia āhua. ");
INSERT INTO mri2012_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nā, ka hangā e Noa tētahi āta mā Ihowā, ā, ka tango ia i ētahi o ngā kararehe pokekore katoa, o ngā manu pokekore katoa hoki, ā, whakaekea tinanatia ana e ia ki runga ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nā, ka hongi a Ihowā ki te kakara reka; ā, ka mea a Ihowā i roto i tōna ngākau, “E kore ahau e kanga anō i te oneone ā muri ake nei mō ngā mahi a te tangata; otiia he kino ngā tokonga ake o te ngākau o te tangata, o tōna taitamarikitanga ake anō; e kore anō hoki ahau e patu i ngā mea ora katoa ā muri ake nei, e pēnei me tēnei meatanga āku. ");
INSERT INTO mri2012_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","E mau ana te whenua, e kore e mutu te pō rui me te pō kokoti, te māeke me te mahana, te raumati me te hōtoke, te ao me te pō.” ");
INSERT INTO mri2012_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nā, ka manaakitia a Noa rātou ko āna tama e te Atua, i mea ia ki a rātou, “Kia hua, kia tini koutou, kia kapi anō hoki te whenua i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ā, ko tō koutou wehi, ko tō koutou whakamataku, ka tau ki runga ki ngā kīrehe katoa o te whenua, ki ngā manu katoa o te rangi, ki ngā mea katoa e ngahue ana i runga i te whenua, ki ngā ika katoa anō hoki o te moana; kua hoatu ēnā mea ki tō koutou ringa. ");
INSERT INTO mri2012_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Hei kai mā koutou ngā mea korikori katoa, ngā mea ora; rite tonu ki tāku hoatutanga i ngā otaota matomato tāku hoatutanga i ngā mea katoa ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Otiia kaua e kainga e koutou te kikokiko me tōna ora, arā ko ōna toto. ");
INSERT INTO mri2012_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nā, ko ō koutou toto, ko te toto e ora nei koutou, he pono ka rapua e ahau he utu. Ka rapua e ahau he utu i ngā kīrehe katoa; i te tangata anō hoki, ka rapua e ahau he utu mō te matenga o te tangata i te teina o ia tangata, o ia tangata. ");
INSERT INTO mri2012_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ko ia e whakaheke i ngā toto o te tangata, mā te tangata anō ōna toto e whakaheke; nō te Atua hoki te āhua i hangā ai e ia te tangata. ");
INSERT INTO mri2012_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ā, ko koutou, kia hua, kia tini; kia nui tō koutou uri ki runga ki te whenua, kia tini hoki ki reira.” ");
INSERT INTO mri2012_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ā, i kōrero te Atua ki a Noa rātou ko āna tama, i mea, ");
INSERT INTO mri2012_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ko ahau nei, nanā, ka whakapūmau ahau i tāku kawenata ki a koutou, ki tō koutou uri i muri i a koutou, ");
INSERT INTO mri2012_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ki ngā mea ora katoa hoki i a koutou, ki te manu, ki te kararehe, ki ngā kīrehe katoa hoki o te whenua e noho ana i a koutou; ki ngā mea katoa i puta mai i roto i te āka, puta noa ki ngā kīrehe katoa o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ā, ka whakapūmautia e ahau tāku kawenata ki a koutou; e kore e hātepea atu ngā kikokiko katoa ā muri ake nei e ngā wai o te waipuke; e kore anō e puta mai he waipuke ā muri ake nei hei whakangaro mō te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ka mea te Atua, “Ko te tohu tēnei o te kawenata, e whakatakotoria nei e ahau ki waenganui ōku, o koutou tae atu ki ngā mea ora katoa i a koutou, mō ngā whakatupuranga mutungakore: ");
INSERT INTO mri2012_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ka whakatakotoria e ahau tāku kōpere ki te kapua, ā, ka waiho hei tohu mō te kawenata i waenganui ōku, o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tēnei ake anō, i te wā e whakaputa ai ahau i te kapua ki runga ki te whenua, ka kitea te kōpere i te kapua, ");
INSERT INTO mri2012_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ā, ka mahara ahau ki tāku kawenata i waenganui ōku, o koutou me ngā mea ora katoa, arā ngā kikokiko katoa; e kore ngā wai e pupuke ā muri ake nei hei whakangaro i ngā kikokiko katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ā, ka piri te kōpere ki te kapua; ā, ka titiro atu ahau ki taua mea, kia mahara ai ahau ki te kawenata mau tonu i waenganui o te Atua, o ngā wairua ora katoa o ngā kikokiko katoa runga i te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nā, ka mea te Atua ki a Noa, “Ko te tohu tēnei o te kawenata e whakapūmautia nei e ahau ki waenganui ōku, o ngā kikokiko katoa i runga i te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nā, ko ngā tama a Noa, i puta mai nei i roto i te āka, ko Hema, ko Hama, ko Iapeta; ā, ko Hama te matua o Kanāna. ");
INSERT INTO mri2012_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ko ngā tama tokotoru ēnei a Noa; ā, nā ēnei i kapi ai te whenua katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nā, ka tīmata a Noa te ngaki whenua, ā, whakatōkia ana e ia he māra wāina. ");
INSERT INTO mri2012_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ā, ka inumia e ia te wāina, ka haurangi; nā, ka takoto tahanga i roto i tōna tēneti. ");
INSERT INTO mri2012_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ā, i te kitenga o Hama, o te matua o Kanāna, i tōna matua e takoto tahanga ana, ka kōrerotia e ia ki ōna tuākana tokorua i waho. ");
INSERT INTO mri2012_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Nā, ka tango a Hema rāua ko Iapeta i tētahi kākahu, makā iho e rāua ki runga ki ō rāua pokohiwi, nā, ka haere whakatuarā atu rāua, ā, hīpokina ana te wāhi takoto kau o tō rāua pāpā; me te ahu anō ō rāua kanohi ki muri, ā, kīhai rāua i kite i te wāhi takoto kau o tō rāua pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nā, ka maranga ake a Noa i tāna wāina, ka mōhio ki tā tāna pōtiki i mea ai ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nā, ka mea ia, “Ka kangā a Kanāna; ka waiho ia hei tino pononga mā ōna tuākana.” ");
INSERT INTO mri2012_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","I mea anō ia, “Kia whakapaingia a Ihowā, te Atua o Hema; ā, ka waiho a Kanāna hei pononga māna. ");
INSERT INTO mri2012_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ka meinga a Iapeta e te Atua kia tohatoha noa atu, kia noho hoki ia ki ngā tēneti o Hema; ā, hei pononga a Kanāna māna.” ");
INSERT INTO mri2012_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ā, e toru rau e rima tekau ngā tau i ora ai a Noa i muri i te waipuke. ");
INSERT INTO mri2012_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ā, ko ngā rā katoa o Noa e iwa rau e rima tekau tau; ā, ka mate ia. ");
INSERT INTO mri2012_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nā, ko ngā whakatupuranga ēnei o ngā tama a Noa, o Hema, o Hama, o Iapeta. I whānau hoki he tama mā rātou i muri i te waipuke. ");
INSERT INTO mri2012_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ko ngā tama a Iapeta: ko Kōmere, ko Makoko, ko Marai, ko Iawana, ko Tūpara, ko Meheke, ko Tīraha. ");
INSERT INTO mri2012_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ā, ko ngā tama a Kōmere: ko Ahekenata, ko Rīpata, ko Tokārama. ");
INSERT INTO mri2012_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ā, ko ngā tama a Iawana: ko Erihaha, ko Tarahihi, ko Kitimi, ko Totanimi. ");
INSERT INTO mri2012_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Nā ēnei ngā motu o ngā tauiwi i wehe puta noa i ō rātou whenua, tēnā iwi i tōna reo; tērā toronga, tērā toronga o rātou, i ō rātou iwi hoki.) ");
INSERT INTO mri2012_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ā, ko ngā tama a Hama: ko Kuhu, ko Mitiraima, ko Putu, ko Kanāna. ");
INSERT INTO mri2012_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ko ngā tama a Kuhu: ko Tepa, ko Hāwira, ko Hāpata, ko Rāma, ko Hapateka. Ā, ko ngā tama a Rāma: ko Hēpā, ko Rerana. ");
INSERT INTO mri2012_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ā, whānau ake tā Kuhu ko Nimirota, i tīmata ia hei tangata nui ki runga ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He māia ia i te aroaro o Ihowā ki te whai kīrehe mohoao; nō reira te kupu nei, “He pērā me Nimirota te māia i te aroaro o Ihowā ki te whai kīrehe mohoao.” ");
INSERT INTO mri2012_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ā, i Papera te tīmatanga o tōna kīngitanga, i Ereke, i Ākara, i Karane, i te whenua o Hinara. ");
INSERT INTO mri2012_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","I haere atu ia i taua whenua ki Ahiria, ā, hangā ana e ia a Ninewe, me te pā, me Rehopoto, me Kara, ");
INSERT INTO mri2012_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","me Rehena hoki, i waenganui o Ninewe, o Kara; he pā nui ia. ");
INSERT INTO mri2012_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ā, whānau ake a Mitiraima, ko ngā Rurimi, ko ngā Anamime, ko ngā Rehapimi, ko ngā Napatuhimi, ");
INSERT INTO mri2012_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ko ngā Pataruhimi, ko ngā Kaheruhimi, i puta mai hoki i ēnā ngā Pirihitini, ā, ko ngā Kapatorimi. ");
INSERT INTO mri2012_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ā, whānau ake tā Kanāna ko Hairona, ko tāna mātāmua, rāua ko Hete, ");
INSERT INTO mri2012_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","me te Iepuhi, me te Amori, me te Kirikahi, ");
INSERT INTO mri2012_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","me te Hiwi, me te Araki, me te Hini, ");
INSERT INTO mri2012_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","me te Arawari, me te Temari, me te Hāmati. Ā muri iho ka marara noa atu ngā hapū o ngā Kanaani. ");
INSERT INTO mri2012_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","I Hairona hoki te rohe ki ngā Kanaani, kei tōu haerenga atu ki Kerara, ki Kaha; kei tōu haerenga ki Horoma, ki Komora, ki Arema, ki Tepoimi, ā tae noa ki Raha. ");
INSERT INTO mri2012_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ko ngā tama ēnei a Hama, tērā toronga, tērā toronga o rātou, tērā reo, tērā reo o rātou, me ō rātou whenua, me ō rātou iwi. ");
INSERT INTO mri2012_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Me Hema anō hoki, me te pāpā o ngā tamariki katoa a Ēpere, te tuakana o Iapeta, i whānau anō hoki he tamariki māna. ");
INSERT INTO mri2012_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ko ngā tama a Hema: ko Erama, ko Āhura, ko Arapahata, ko Ruru, ko Arame. ");
INSERT INTO mri2012_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ā, ko ngā tamariki a Arame: ko Uhu, ko Huru, ko Ketere, ko Maha. ");
INSERT INTO mri2012_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Nā Arapahata ko Haraha, tā Haraha ko Ēpere. ");
INSERT INTO mri2012_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Tokorua ngā tama a Ēpere: ko Pereke te ingoa o tētahi. Nō tōna rā hoki i wehea ai te whenua; ā, ko Iokētana te ingoa o tōna teina. ");
INSERT INTO mri2012_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ā, whānau ake a Iokētana ko Aramotata, ko Herepe, ko Hataramaweta, ko Ieraha, ");
INSERT INTO mri2012_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ko Hatorama, ko Utara, ko Tikera, ");
INSERT INTO mri2012_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ko Opara, ko Apimaera, ko Hēpā, ");
INSERT INTO mri2012_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ko Ōpira, ko Hāwira, ko Iopapa; he tama katoa ēnei nā Iokētana. ");
INSERT INTO mri2012_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kei Meha hoki tō rātou nohoanga, ā tae noa koe ki Hepara; he maunga ia kei te rāwhiti. ");
INSERT INTO mri2012_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ko ngā tama ēnei a Hema, tōna hapū, tōna hapū, tōna reo, tōna reo, ō rātou kāinga, me ō rātou iwi. ");
INSERT INTO mri2012_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ko ngā toronga ēnei o ngā tama a Noa, i ō rātou whakatupuranga, me ō rātou iwi; ā, i wehea mai i ēnei ngā iwi o te whenua i muri iho i te waipuke. ");
INSERT INTO mri2012_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nā, kotahi tonu te reo o te whenua katoa, rite tonu anō ngā kōrero. ");
INSERT INTO mri2012_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ā, i a rātou e haere ana whaka te rāwhiti, nā, ka kite rātou i tētahi mānia i te whenua o Hinara; ā, noho ana rātou i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Nā, ka mea rātou ki tōna hoa, ki tōna hoa, “Tēnā, tātou ka hanga pereki, me āta tahu mārire anō hoki.” Nā, ka meinga e rātou he pereki hei kōhatu, he uku hoki tā rātou moata. ");
INSERT INTO mri2012_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nā, ka mea rātou, “Tēnā, tātou ka hanga i tētahi pā me tētahi pourewa, ā, kia tutuki a runga ki te rangi, kia whai ingoa ai tātou; kei marara noa atu tātou ki te mata o te whenua katoa.” ");
INSERT INTO mri2012_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Nā, ka heke iho a Ihowā kia kite i te pā me te pourewa, i hangā nei e ngā tama a te tangata. ");
INSERT INTO mri2012_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ā, ka mea a Ihowā, “Nanā, kotahi tonu te iwi nei, kotahi anō hoki tō rātou reo; ā, ka tīmataia nei tēnei mahi e rātou; e kore anō rātou e taea te pupuri mai i tētahi mea, e whakaaro ana rātou kia mahia. ");
INSERT INTO mri2012_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tēnā, tātou ka heke atu, ka whakapōauau i ō rātou reo i reira, kia kore ai rātou e mātau, ia tangata, ia tangata ki te reo o tōna hoa.” ");
INSERT INTO mri2012_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nā, whakamararatia atu ana rātou i reira e Ihowā ki runga ki te mata o te whenua katoa; ā, mahue ake i a rātou te hanga i te pā. ");
INSERT INTO mri2012_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nā konā i huaina ai tō reira ingoa ko Papera, nō te mea i whakapōauautia e Ihowā i reira te reo o te whenua katoa; nō reira anō hoki te whakamararatanga a Ihowā i a rātou ki te mata o te whenua katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ko ngā whakatupuranga ēnei o Hema. Ka kotahi rau ngā tau o Hema, nā, ka whānau a Arapahata i te rua o ngā tau i muri i te waipuke. ");
INSERT INTO mri2012_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ā, e rima rau ngā tau i ora ai a Hema i muri i te whānautanga o Arapahata, ā, ka whānau āna tama me āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ā, ka toru tekau mā rima ngā tau i ora ai a Arapahata, nā, ka whānau a Haraha; ");
INSERT INTO mri2012_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ā, e whā rau e toru ngā tau i ora ai a Arapahata i muri i te whānautanga o Haraha, ka whānau āna tama me āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ā, ka toru tekau ngā tau i ora ai a Haraha, nā, ka whānau a Ēpere; ");
INSERT INTO mri2012_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ā, e whā rau e toru ngā tau o Haraha i muri i te whānautanga o Ēpere, ka whānau āna tama me āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ā, e toru tekau mā whā ngā tau i ora ai a Ēpere, ka whānau a Pereke; ");
INSERT INTO mri2012_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","e whā rau e toru tekau ngā tau i ora ai a Ēpere i muri i te whānautanga o Pereke, ā, ka whānau āna tama me āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ā, ka toru tekau ngā tau o Pereke, ka whānau a Reu; ");
INSERT INTO mri2012_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ā, e rua rau e iwa ngā tau i ora ai a Pereke i muri i te whānautanga o Reu, ka whānau āna tama me āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ā, ka toru tekau mā rua ngā tau o Reu, nā, ka whānau a Heruka; ");
INSERT INTO mri2012_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ā, e rua rau mā whitu ngā tau i ora ai a Reu i muri i te whānautanga o Heruka, ka whānau āna tama me āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ā, ka toru tekau ngā tau o Heruka, nā, ka whānau a Nahora; ");
INSERT INTO mri2012_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ā, e rua rau ngā tau i ora ai a Heruka i muri i te whānautanga o Nahora, ka whānau āna tama me āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ā, e rua tekau mā iwa ngā tau i ora ai a Nahora, nā, ka whānau a Teraha; ");
INSERT INTO mri2012_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ā, kotahi rau kotahi tekau mā iwa ngā tau i ora ai a Nahora i muri i te whānautanga o Teraha, ā, ka whānau āna tama me āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ā, ka whitu tekau ngā tau i ora ai a Teraha, nā, ka whānau a Āperama, a Nahora, rātou ko Harana. ");
INSERT INTO mri2012_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nā, ko ngā whakatupuranga ēnei o Teraha. Nā Teraha ko Āperama, ko Nahora, rātou ko Harana; nā Harana ko Rota. ");
INSERT INTO mri2012_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ā, i mate a Harana i te oranga anō o tōna pāpā o Teraha i te whenua i whānau ai ia, i Uru o ngā Karari. ");
INSERT INTO mri2012_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nā, ka tango a Āperama rāua ko Nahora i ētahi wāhine mā rāua; ko te ingoa o te wahine a Āperama ko Harai, ko te ingoa o te wahine a Nahora ko Mireka tamāhine a Harana, pāpā o Mireka, pāpā anō hoki o Ihēka. ");
INSERT INTO mri2012_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ā, he pākoko a Harai; kāhore āna tamariki. ");
INSERT INTO mri2012_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Nā, ka tango a Teraha i a Āperama i tāna tama, rāua ko Rota tama a Harana, ko te tama a tāna tama, rātou ko tāna hunaonga, ko Harai wahine a tāna tama a Āperama; ā, whakatika tahi ana rātou i Uru o ngā Karari, haere ana ki te whenua o Kanaana; ka tae ki Harana, ā, noho ana i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ā, ko ngā rā o Teraha e rua rau mā rima tau; nā, ka mate a Teraha ki Harana. ");
INSERT INTO mri2012_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nā, ka mea atu a Ihowā ki a Āperama, “Haere atu i tōu whenua, i roto i ōu whanaunga, i te whare anō hoki o tōu pāpā, ki te whenua e whakaaturia e ahau ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ā, ka meinga koe e ahau hei iwi nui, ka manaakitia anō koe e ahau, ka whakanuia anō hoki tōu ingoa; ā, ka waiho koe hei manaakitanga. ");
INSERT INTO mri2012_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ā, ka manaaki ahau i te hunga e manaaki ana i a koe, ka kanga hoki i te tangata e kanga ana i a koe; ā, māu ka manaakitia ai ngā hapū katoa o te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Nā, haere ana a Āperama, pērā ana me tā Ihowā i kōrero ai ki a ia; i haere tahi anō a Rota i a ia. Ā, e whitu tekau mā rima ngā tau o Āperama i tōna hekenga mai i Harana. ");
INSERT INTO mri2012_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nā, ka tango a Āperama i a Harai, i tāna wahine rāua ko Rota tama a tōna teina, i ō rātou rawa katoa i whakaemi ai, i ngā mea ora katoa i whiwhi ai rātou ki Harana; ā, whakatika ana rātou, haere ana ki te whenua o Kanaana. Nā, ka tae rātou ki te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Nā, ka tika a Āperama nā waenganui o te whenua ki te wāhi o Hekeme, ki te oki i More. I taua whenua anō te Kanaani i taua wā. ");
INSERT INTO mri2012_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nā, ka puta a Ihowā ki a Āperama, ka mea, “Ka hoatu e ahau tēnei whenua ki tōu uri.” Nā, ka hangā e ia tētahi āta ki reira mā Ihowā i puta mai nei ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Nā, ka neke atu ia i reira ki te maunga i te rāwhiti o Pētēre, ā, ka whakatū i tōna tēneti; ko Pētēre ki te hauāuru, ko Hai ki te rāwhiti. I hangā anō e ia tētahi āta mā Ihowā ki reira, ā, karanga ana ki te ingoa o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Nā, ka tūria atu e Āperama, me te neke haere whaka te tonga. ");
INSERT INTO mri2012_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ā, he matekai tō te whenua; ā, ka haere a Āperama ki raro, ki Īhipa, ki reira noho ai; he nui hoki te matekai o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ā, i a ia ka tata te tae ki Īhipa; ka mea ia ki a Harai, ki tāna wahine, “Nanā, e mōhio ana ahau he wahine ātaahua koe ki te titiro atu; ");
INSERT INTO mri2012_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","nā, ākuanei kei te kitenga o ngā Īhipiana i a koe, ka mea rātou, ‘Ko tāna wahine tēnei’; ā, ka patua ahau e rātou, ka whakaora hoki i a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Me kī koe, nē, he tuahine koe nōku? Kia whiwhi ai ahau ki te pai i a koe; ā, kia ora ai tōku wairua i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ā, i te taenga o Āperama ki Īhipa, ka titiro ngā Īhipiana ki te wahine, he tino ātaahua. ");
INSERT INTO mri2012_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ka kite hoki ngā rangatira a Parao i a ia, ka kōrero whakamihi mōna ki a Parao, ā, ka kawea te wahine rā ki te whare o Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nā, ka atawhai ia i a Āperama, he mea hoki mō te wahine; ā, ka riro i a ia he hipi, he kau, he kāihe toa, he pononga tāne, he pononga wāhine, he kāihe uha, he kāmera. ");
INSERT INTO mri2012_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Nā, ka whiua e Ihowā a Parao rātou ko tōna whare, he nui ngā pakinga, mō Harai wahine a Āperama. ");
INSERT INTO mri2012_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Nā, ka karanga a Parao ki a Āperama, ka mea, “He aha tēnei mahi āu ki ahau? He aha koe tē kōrero mai ai ki ahau ko tāu wahine ia? ");
INSERT INTO mri2012_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nā te aha koe i mea ai, ‘Ko tāku tuahine ia’ i tango ai ahau i a ia hei wahine māku? Nā, tāu wahine, tangohia, haere.” ");
INSERT INTO mri2012_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Nā, ka whakatūpato a Parao ki ngā tāngata, kei aha atu ki a ia; ā, tukua atu ana ia e rātou, me tāna wahine, me āna mea katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Nā, ka haere mai a Āperama i Īhipa ki te tonga, rāua ko tāna wahine, me āna mea katoa, me Rota hoki. ");
INSERT INTO mri2012_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","He nui rawa hoki ngā kararehe, te hiriwa me te kōura ki a Āperama. ");
INSERT INTO mri2012_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nā, ka tūria mai e ia, ā, ka haere i te tonga ā tae noa ki Pētēre, ki te wāhi i oroko tū ai tōna tēneti, i waenganui o Pētēre, o Hai, ");
INSERT INTO mri2012_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ki te wāhi i te āta i hangā e ia ki reira i te tīmatanga. Nā, ka karanga a Āperama i reira ki te ingoa o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Nā, ko Rota, i haere tahi nei i a Āperama, he hipi anō āna, he kau, he tēneti. ");
INSERT INTO mri2012_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ā, kīhai i nui te whenua mō rāua, hei nohoanga tahitanga mō rāua. He nui hoki ō rāua rawa, tē āhei rāua te noho tahi. ");
INSERT INTO mri2012_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nā, ka tautohe ki a rātou ngā hēpara a Āperama me ngā hēpara a Rota. Nā, i taua whenua e noho ana te Kanaani me te Perihi i taua wā. ");
INSERT INTO mri2012_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Nā, ka mea a Āperama ki a Rota, “Kaua rā taua e whakatete ki a tāua, kaua hoki ā tāua hēpara e whakatete ki a rātou; he tēina nei hoki, he tuākana tāua. ");
INSERT INTO mri2012_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kāhore ianei te whenua katoa i tōu aroaro? Tēnā, wehe atu koe i ahau. Ki te anga koe ki mauī, ka ahu ahau ki matau, ā, ki te haere koe ki matau, nā, ka ahu ahau ki mauī.” ");
INSERT INTO mri2012_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nā, ka anga ake ngā kanohi o Rota, ka titiro ki te mānia katoa o Horano, he mākūkū katoa, i te mea kāhore anō kia whakangaromia noatia a Horoma, a Komora e Ihowā, he pērā ānō me te kāri a Ihowā, me te whenua hoki o Īhipa, i tōu haerenga ki Toara. ");
INSERT INTO mri2012_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nā, ka whiriwhiria e Rota ko te mānia katoa o Horano māna. Nā, ka haere a Rota whaka te rāwhiti, ā, ka wehe rāua i a rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ko Āperama i noho ki te whenua o Kanaana, ko Rota i noho ki ngā pā o te mānia, ā, whakatūria ana e ia tōna tēneti ki Horoma. ");
INSERT INTO mri2012_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Nā, he kino ngā tāngata o Horoma, he hunga hara rawa ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Nā, ka mea a Ihowā ki a Āperama, i muri i te wehenga atu o Rota i a ia, “Anga ake ōu kanohi, titiro atu hoki i te wāhi e tū nā koe, ki te raki, ki te tonga, ki te rāwhiti, ki te hauāuru; ");
INSERT INTO mri2012_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ko te whenua katoa hoki e kite atu nā koe, ka hoatu e ahau ki a koe, ki tōu uri hoki ake tonu atu. ");
INSERT INTO mri2012_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ka meinga hoki e ahau ōu uri kia rite ki te puehu o te whenua; ā, ki te āhei i tētahi tangata te tatau i te puehu o te whenua, e taua anō hoki ōu uri. ");
INSERT INTO mri2012_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Whakatika, hāereerea te whenua, tōna roa, tōna whānui; nō te mea ka hoatu e ahau ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Nā, nekehia ana tōna tēneti e Āperama, ā, haere ana, noho ana ki ngā oki i Mamere, ki ērā i Heperona, ā, hangā ana e ia tētahi āta mā Ihowā ki reira. ");
INSERT INTO mri2012_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nā, i ngā rā o Amarapera, kīngi o Hinara, o Arioka, kīngi o Eratara, o Keroraoma, kīngi o Erama, o Tirara hoki, kīngi o Koimi, ");
INSERT INTO mri2012_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ka whawhai ēnei ki a Pera, kīngi o Horoma, rātou ko Pīreta, kīngi o Komora, ko Hinapa, kīngi o Arema, ko Hemepera, kīngi o Tepoimi, ko te kīngi hoki o Pera, (arā o Toara). ");
INSERT INTO mri2012_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","I huihui katoa ēnei ki te raorao i Hirimi, arā ki te Moana Tote. ");
INSERT INTO mri2012_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kotahi tekau mā rua ngā tau i mahi ai rātou ki a Keroraoma, ā, i te kotahi tekau mā toru o ngā tau ka whakakeke rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Nā, i te tekau mā whā o ngā tau ka haere mai a Keroraoma, rātou ko ngā kīngi i whakauru ki a ia, ā, patua iho e rātou ngā Repaima i Ahateroto Karanaima, rātou ko ngā Tutimi i Hama me ngā Emime i Hawe Kiriataima, ");
INSERT INTO mri2012_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","me ngā Hori i tō rātou maunga, i Heira, ā tae noa ki Ereparana, ki te taha o te koraha. ");
INSERT INTO mri2012_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Nā, ka hoki rātou, ā, ka tae ki Enimihipata, (arā ki Karehe), ā, patua katoatia ana e rātou te whenua o ngā Amareki, rātou ko ngā Amori i noho rā i Hatetonatamara. ");
INSERT INTO mri2012_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nā, ka puta atu te kīngi o Horoma, rātou ko te kīngi o Komora, ko te kīngi o Arema, ko te kīngi o Tepoimi, me te kīngi o Pera, (arā o Toara) ā, ka tūria e rātou he pakanga ki a rātou ki te raorao i Hirimi ");
INSERT INTO mri2012_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ki a Keroraoma, kīngi o Erama, ki a Tirara, kīngi o Koimi, ki a Amarapera, kīngi o Hinara, rātou ko Arioka, kīngi o Eratara, tokowhā ēnei kīngi, tokorima hoki ērā. ");
INSERT INTO mri2012_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nā, kī tonu te raorao i Hirimi i te poka uku; nā, ka whati ngā kīngi o Horoma rāua ko Komora, ā, ka hinga ki reira; ā, rere ana ngā mōrehu ki te maunga. ");
INSERT INTO mri2012_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Nā, murua ana e rātou ngā taonga katoa o Horoma, o Komora, me ā rātou kai katoa, ā, haere ana. ");
INSERT INTO mri2012_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","I mauria anō e rātou a Rota, te tama a te teina o Āperama, me ōna taonga, ā, haere ana; i Horoma hoki ia e noho ana. ");
INSERT INTO mri2012_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Nā, ka tae he mōrehu, ka kōrero ki a Āperama Hiperu; i te noho hoki ia i ngā oki o Mamere Amori, teina o Ehekora, he teina ia nō Anera. Kotahi anō tō rātou whakaaro ko Āperama. ");
INSERT INTO mri2012_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ā, i te rongonga o Āperama, kua hereherea atu tōna irāmutu, tākiritia ana e ia āna tāngata mōhio, ngā mea i whānau ki tōna whare, e toru rau kotahi tekau mā waru, ā, whāia ana rātou ki Rāna. ");
INSERT INTO mri2012_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nā, wāhia ana rātou ko āna tāngata kia rua ngā matua, hei whakaeke mō rātou i te pō, ā, patua ana rātou e ia, whāia ana, ā tae noa ki Hopaha, ki te taha ki mauī o Ramahiku. ");
INSERT INTO mri2012_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ā, whakahokia mai ana e ia ngā taonga katoa, whakahokia mai ana anō hoki tōna irāmutu, a Rota, me ōna taonga, me ngā wāhine anō hoki, me ngā tāngata. ");
INSERT INTO mri2012_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Nā, ka puta mai te kīngi o Horoma ki te whakatau i a ia i tōna hokinga mai i te patu i a Keroraoma rātou ko ōna hoa, ko ngā kīngi ki te raorao o Hawe, (arā ki te Raorao o te Kīngi). ");
INSERT INTO mri2012_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ā, i maua mai e Merekihereke, e te kīngi o Harema, he taro, he wāina; he tohunga anō hoki ia nō te Atua, nō te Runga Rawa. ");
INSERT INTO mri2012_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Nā, ka manaaki ia i a ia, ka mea, “Kia manaakitia a Āperama e te Atua, e te Runga Rawa, nōna nei te rangi me te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kia manaakitia anō te Atua, te Runga Rawa, nāna nei i tuku mai ōu hoariri ki tōu ringa.” Ā, ka hoatu e ia ki a ia ngā whakatekau o ngā mea katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nā, ka mea te kīngi o Horoma ki a Āperama, “Hōmai ngā tāngata ki ahau, ko ngā taonga ia tangohia mōu.” ");
INSERT INTO mri2012_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Anō rā ko Āperama ki te kīngi o Horoma, “Kua totoro atu tōku ringa ki a Ihowā, ki te Atua, ki te Runga Rawa, nōna nei te rangi me te whenua; ");
INSERT INTO mri2012_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","e kore ahau e tango ahakoa he miro, ahakoa he here nō te hū, i tētahi mea rānei āu, kei mea koe, ‘Nāku a Āperama i whai taonga ai.’ ");
INSERT INTO mri2012_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kāti anō i a ngā taitama i kai ai, me te wāhi a ngā tāngata i haere tahi nei mātou – a Anera, rātou ko Ehekora, ko Mamere; mā rātou e tango te wāhi i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Muri iho i ēnei mea ka puta moemoeā mai te kupu a Ihowā ki a Āperama, ka mea: “Kaua e wehi, e Āperama. Ko ahau tōu whakangungu rākau, tōu utu nui whakaharahara.” ");
INSERT INTO mri2012_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Nā, ka mea a Āperama, “E te Ariki, e Ihowā, ko te aha e hōmai e koe ki ahau, e haere urikore nei ahau, ā, ko te taunga o tōku whare hei tēnei Eriētera o Ramahiku?” ");
INSERT INTO mri2012_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","I mea anō a Āperama, “Titiro hoki, kāhore nei i hōmai e koe he uri ki ahau; ā, ākuanei, kei tētahi tamaiti i whānau ki tōku whare te mahuetanga iho o ōku taonga.” ");
INSERT INTO mri2012_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Nā, kua puta mai te kupu a Ihowā ki a ia, i mea ia, “E kore e mahue iho ōu taonga mō tēnā; engari, ka mahue iho mō tētahi e puta mai i roto i ōu whēkau.” ");
INSERT INTO mri2012_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nā, ka kawea ia e ia ki waho, ā, ka mea mai, “Tēnā tirohia atu te rangi, taua hoki ngā whetū, ki te taea ēnā e koe te tatau.” Ā, ka mea ia ki a ia, “Ka pērā tōu uri.” ");
INSERT INTO mri2012_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","I whakapono hoki ia ki a Ihowā, ā, ka whakairia ki a ia hei tika. ");
INSERT INTO mri2012_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","I mea anō ia ki a ia, “Ko Ihowā ahau, nāna nei koe i kawe mai i Uru o ngā Karari, kia hoatu ai ki a koe tēnei whenua hei kāinga pūmau.” ");
INSERT INTO mri2012_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Anō rā ko ia, “E te Ariki, e Ihowā, mā te aha ka mōhio ai ahau ka riro mai tēnei i ahau?” ");
INSERT INTO mri2012_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nā, ka mea ia ki a ia, “Tīkina tētahi kau māku, hei te tau toru, me tētahi koati uha, hei te tau toru, me tētahi hipi toa, hei te tau toru, me tētahi kūkupa, me tētahi pī kūkupa.” ");
INSERT INTO mri2012_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Nā, tīkina ana e ia aua mea katoa, ā, tapahia ana i waenganui, whakatakotoria ana ngā wāhi kia rite mai ki ā rāua whakawahi; ko ngā manu ia kīhai i tapahia e ia. ");
INSERT INTO mri2012_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ā, ka rere iho ngā manu ki ngā tinana, ka āia atu e Āperama. ");
INSERT INTO mri2012_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nā, i te rerenga o te rā, ka parangia a Āperama e te moe; nā, ko te whakawehi o te pōuri kerekere e tau iho ana ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ā, ka mea ia ki a Āperama, “Kia tino mōhio koe, ka noho manene tōu uri ki tētahi whenua ehara nei i a rātou, ā, ka mahi ki a rātou; ā, e whā rau ngā tau e whakatupuria kinotia ai rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ka whakawākia anō e ahau te iwi e whakamahia ai rātou, ā muri iho ka puta mai rātou me ngā taonga maha. ");
INSERT INTO mri2012_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ko koe ia ka haere mārie ki ōu mātua; ka pai tōu koroheketanga, ā, tanumia noatia koe. ");
INSERT INTO mri2012_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Kei te whā ia o ngā whakatupuranga ka hoki mai rātou ki konei nō te mea kāhore anō kia tutuki noa te hara o ngā Amori.” ");
INSERT INTO mri2012_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nā, i te tōnga o te rā, nō ka pōuri, nā, ko te oumu paowa, me te rama e kā ana, e tika ana i waenganui o aua porohanga. ");
INSERT INTO mri2012_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","I taua rangi anō ka whakaritea e Ihowā he kawenata ki a Āperama, ka mea ia, “Ka hoatu e ahau tēnei whenua ki tōu uri, mai rā anō o te awa o Īhipa, ā tae noa ki te awa nui, ki te awa, ki Uparati; ");
INSERT INTO mri2012_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ngā Keni, ngā Keniti, ngā Karamoni, ");
INSERT INTO mri2012_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ngā Hiti, ngā Perihi, ngā Repaima, ");
INSERT INTO mri2012_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ngā Amori, ngā Kanaani, ngā Kirikahi, me ngā Iepuhi.” ");
INSERT INTO mri2012_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Nā, kāhore a Harai, te wahine a Āperama, i whai tamariki māna. Nā, he pononga wahine tāna, nō Īhipa, ko Hakara tōna ingoa. ");
INSERT INTO mri2012_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Nā, ka mea a Harai ki a Āperama, “Nanā, kua tūtakina nei ahau e Ihowā kei whānau tamariki. Māu e haere ki roto, ki tāku pononga; māna pea ahau e tū ai.” Ā, ka whakarongo a Āperama ki te reo o Harai. ");
INSERT INTO mri2012_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Nā, ka tango a Harai, wahine a Āperama i a Hakara, i te wahine o Īhipa, i tāna pononga, i te takanga o ngā tau kotahi tekau o te nohoanga o Āperama i te whenua o Kanaana, ā, hōmai ana e ia ki a Āperama, ki tāna tāne, hei wahine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Nā, ka haere ia ki roto, ki a Hakara, ā, ka hapū ia. Ā, nō tōna kitenga kua hapū ia, ka iti tōna rangatira wahine ki tāna titiro. ");
INSERT INTO mri2012_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Nā, ka mea a Harai ki a Āperama, “Hei runga i a koe tēnei tutū ki ahau. I hoatu e ahau tāku pononga wahine ki tōu uma; ā, nō tōna kitenga kua hapū ia, ka iti ahau ki tāna titiro iho. Mā Ihowā e whakariterite tāku kōrero me tāu hoki.” ");
INSERT INTO mri2012_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Nā, ka mea a Āperama ki a Harai, “Ha, kei tōu ringa anō tāu pononga; māu e mea ki a ia te mea e pai ana ki tāu titiro iho.” Nā, ka whakatupu kino a Harai i a ia, ā, rere ana ia i tōna aroaro. ");
INSERT INTO mri2012_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ā, ka kitea ia e te anahera a te Atua i tētahi puna wai i te koraha, i te puna i te huarahi ki Huru, ");
INSERT INTO mri2012_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ka mea, “E Hakara, e te pononga a Harai, i haere mai koe i hea? E anga ana hoki koe ko hea?” Ā, ka mea ia, “E rere ana ahau i a Harai, i tōku rangatira.” ");
INSERT INTO mri2012_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Nā, ka mea te anahera a Ihowā ki a ia, “Hoki atu ki tōu rangatira, kia whakaririka hoki koe i raro i ōna ringa.” ");
INSERT INTO mri2012_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ka mea anō te anahera a Ihowā ki a ia, “Ka whakanuia rawatia e ahau tōu uri, ā, e kore e taea te tatau, i te tini hoki.” ");
INSERT INTO mri2012_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","I mea anō te anahera a Ihowā ki a ia: “Nanā, e hapū ana koe, ā, ka whānau he tama, me hua e koe tōna ingoa ko Ihimaera; mō Ihowā i whakarongo ki tāu tangi. ");
INSERT INTO mri2012_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ā, ka rite ia ki te kāihe mohoao i waenganui o te tangata; ka ara tōna ringa ki te katoa, me te ringa o te katoa ki a ia; ā, ka noho ia i te aroaro o ōna tēina katoa.” ");
INSERT INTO mri2012_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nā, ka huaina e ia te ingoa o Ihowā i kōrero nei ki a ia, “He Atua koe e kite ana,” i mea hoki ia, “I titiro rānei ahau i konei ki muri i tōku kaititiro mai?” ");
INSERT INTO mri2012_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Koia i huaina ai taua puna ko Peere-Rahai-Roi; nā, kei waenganui i Karehe, i Perere. ");
INSERT INTO mri2012_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nā, ka whānau te tama a Hakara rāua ko Āperama; ā, huaina ana e Āperama te ingoa o tāna tama, i whānau nei i a Hakara, ko Ihimaera. ");
INSERT INTO mri2012_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Nā, e waru tekau mā ono ngā tau o Āperama i te whānautanga o Ihimaera tama a Hakara rāua ko Āperama. ");
INSERT INTO mri2012_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ā, i te mea ka iwa tekau mā iwa ngā tau o Āperama, ka puta mai a Ihowā ki a Āperama, ka mea ki a ia, “Ko ahau te Atua Kaha Rawa; hāereere i mua i tōku aroaro, kia tapatahi hoki te whakaaro. ");
INSERT INTO mri2012_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ā, ka waiho e ahau tāku kawenata ki waenganui i a tāua, ka tino whakanui rawa anō ahau i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Nā, ka kūpapa te kanohi o Āperama; ā, ka kōrero te Atua ki a ia, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nā, ko ahau, kei a koe tāku kawenata, ā, ka matua koe mō ngā iwi maha. ");
INSERT INTO mri2012_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","E kore hoki tōu ingoa e huaina ā muri ake nei ko Āperama, engari ko Āperahama te ingoa mōu; ka meinga hoki koe e ahau hei matua mō ngā iwi maha. ");
INSERT INTO mri2012_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ka meinga anō koe e ahau kia tino hua rawa, ka meinga koe e ahau hei take mō ngā iwi, ā, ka puta mai ngā kīngi i roto i a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ā, ka whakapūmautia e ahau tāku kawenata ki waenganui ōku, o koutou hoki ko ōu uri i muri i a koe, o tērā whakatupuranga, o tērā whakatupuranga o rātou, hei kawenata mau tonu, ā, hei Atua ahau mōu, mō ōu uri hoki i muri i a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ā, ka hoatu e ahau ki a koe, ki ōu uri hoki i muri i a koe, te whenua e noho manene nā koe, te whenua katoa o Kanaana, hei kāinga pūmau; ā, hei Atua ahau mō rātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","I mea anō te Atua ki a Āperahama, “Inā, ko koe, me whakarite e koe tāku kawenata, e koutou ko ōu uri i muri i a koe, e tērā whakatupuranga, e tērā whakatupuranga o rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ko tāku kawenata tēnei hei whakaritenga mā koutou i waenganui ōku, o koutou ko ōu uri i muri i a koe: Me kokoti ā koutou tāne katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Me kokoti e koutou tō koutou kiri matamata; ā, ka waiho tēnā hei tohu mō te kawenata i waenganui ōku, o koutou. ");
INSERT INTO mri2012_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Me kokoti e koutou ngā tamariki ina waru ngā rā, ngā tāne katoa o tēnā whakatupuranga, o tēnā whakatupuranga o koutou, ngā mea i whānau i roto i te whare, i hokona rānei ki te moni i tētahi tangata kē, ehara nei i te uri nōu. ");
INSERT INTO mri2012_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Me kokoti tonu te tangata i whānau i roto i tōu whare, i hokona rānei ki tāu moni, ā, ka mau tāku kawenata ki ō koutou kikokiko, hei kawenata mau tonu. ");
INSERT INTO mri2012_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ā, ko te tāne kīhai i kotia, kīhai nei i kotia tōna kiri matamata, ka hātepea atu tēnā wairua i roto i tōna iwi; kua whakatakā e ia tāku kawenata.” ");
INSERT INTO mri2012_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ā, ka mea te Atua ki a Āperahama, “Ko Harai, ko tāu wahine, kaua e huaina tōna ingoa ko Harai, engari ko Hara he ingoa mōna. ");
INSERT INTO mri2012_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ā, ka manaaki ahau i a ia, ka hoatu anō hoki i tētahi tama ki a koe i roto i a ia. Inā, ka manaaki ahau i a ia, ā, hei whaea ia mō ngā iwi; ka puta mai ngā kīngi mō ngā iwi i roto i a ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Nā, ka kūpapa te kanohi o Āperahama ki raro, ā, ka kata ia, ka mea hoki i roto i tōna ngākau, “Tērā rānei e whānau he tama mā te tangata kua kotahi rau nei ōna tau? E whānau tamariki rānei a Hara, te wahine kua iwa tekau nei ōna tau?” ");
INSERT INTO mri2012_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Nā, ka mea ake a Āperahama ki te Atua, “Kia ora noa oti a Ihimaera ki tōu aroaro!” ");
INSERT INTO mri2012_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nā, ka mea te Atua, “Ehara, ka whānau tā kōrua tama ko Hara; ā, me hua e koe tōna ingoa ko Īhaka. Ka whakapūmau anō ahau i tāku kawenata ki a ia, ki ōna uri hoki i muri i a ia, hei kawenata mau tonu. ");
INSERT INTO mri2012_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ko Ihimaera ia, nā, kua whakarongo ahau ki a koe; nanā, kua oti ia te manaaki e ahau, ā, ka meinga ia e ahau kia hua, kia tino nui rawa hoki; ka whānau āna tamariki kotahi tekau mā rua he ariki, ā, ka meinga ia e ahau hei iwi nui. ");
INSERT INTO mri2012_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ka whakapūmautia ia e ahau tāku kawenata ki a Īhaka, ka whānau nei i a kōrua ko Hara ā te tāima e rite ana ki tēnei o te tau e haere ake nei.” ");
INSERT INTO mri2012_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ā, ka mutu tāna kōrero ki a ia, ā, mawehe atu ana te Atua i a Āperahama ki runga. ");
INSERT INTO mri2012_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kātahi ka tango a Āperahama i a Ihimaera i tāna tama, rātou ko ngā mea katoa i whānau i roto i tōna whare, me ngā mea katoa i hokona ki tāna moni, ngā tāne katoa i roto i ngā tāngata o te whare o Āperahama; ā, kotia ana e ia tō rātou kiri matamata i taua rā pū anō, i pērā me tā te Atua i kōrero ai ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Nā, e iwa tekau mā iwa ngā tau o Āperahama i te kotinga o tōna kiri matamata. ");
INSERT INTO mri2012_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Kotahi tekau mā toru hoki ngā tau o tāna tama o Ihimaera i te kotinga o tōna kiri matamata. ");
INSERT INTO mri2012_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Nō taua rangi pū anō i kotia ai a Āperahama, rāua ko tāna tama, ko Ihimaera, ");
INSERT INTO mri2012_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ā, i kotia ngātahitia me ia ngā tāngata katoa o tōna whare, ngā mea i whānau i roto i te whare, me ngā mea i hokona ki te moni i te tangata iwi kē. ");
INSERT INTO mri2012_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ā, ka puta anō a Ihowā ki a ia i ngā oki o Mamere, i a ia e noho ana i te kūwaha o te tēneti i te tīkākātanga o te rā. ");
INSERT INTO mri2012_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ā, ka anga ake ōna kanohi, ka titiro, nā, ko ngā tāngata tokotoru e tū ana i tōna taha. Ā, nō tōna kitenga atu, ka rere atu ia i te kūwaha o te tēneti ki te whakatau i a rātou, ā, ka piko ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ka mea, “E tōku Ariki, ki te mea he pai tōku ki tāu titiro, kaua rā e kapea tāu pononga. ");
INSERT INTO mri2012_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kia tīkina koa tētahi wai, ka horoi i ō koutou waewae, ā, ka okioki koutou i raro i te rākau. ");
INSERT INTO mri2012_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ā, māku e tiki tētahi wāhi taro hei oranga mō ō koutou ngākau; hei muri rā ka haere ai koutou. He mea hoki kua tae mai nei koutou ki tā koutou pononga.” Ā, ka mea rātou, “Pēnātia me tāu i kī nā.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Nā, ka hohoro a Āperahama ki te tēneti ki a Hara, ā, ka mea, “Kia hohoro te pokepoke i tētahi parāoa pai, kia toru ngā mēhua, ka hanga i ētahi keke.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nā, ka rere a Āperahama ki te kāhui, ā, hopukia ana e ia tētahi kūao kau, he kiri ngāwari, he mea pai, ā, hoatu ana e ia ki tētahi taitamariki; ā, hohoro ana ia te taka i taua mea. ");
INSERT INTO mri2012_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Nā, ka tīkina e ia he pata, he waiū, me te kūao i raweketia e ia, ā, whakatakotoria ana ki tō rātou aroaro; me te tū anō ia i tō rātou taha i raro i te rākau, ā, ka kai rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nā, ka mea rātou ki a ia, “Kei hea a Hara, tāu wahine?” Ā, ka mea ia, “Arā, kei te tēneti.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Nā, ka mea ia, “He pono ka hoki mai anō ahau ki a koe ā te huringa mai anō o te wā; ā, ka whai tama tāu wahine, a Hara.” Nā, ka rongo atu a Hara i te kūwaha o te tēneti, i muri i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nā, kua koroheke rawa a Āperahama rāua ko Hara, kua maha ō rāua rā; kua mutu a Hara te pērā me ētahi wāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nā, ka kata a Hara i roto i a ia, ka mea, “Ka rūruhitia nei ahau, ā tērā rānei ahau e whai koa, he koroheke nei anō hoki tōku ariki?” ");
INSERT INTO mri2012_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nā, ka mea a Ihowā ki a Āperahama, “He aha a Hara i kata ai, i mea ai, ‘He pono, ka whānau tamariki rānei ahau, he rūruhi nei hoki ahau?’ ");
INSERT INTO mri2012_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","He pakeke rawa rānei tētahi mea ki a Ihowā? Kei te tāima i whakaritea, kei te hurihanga mai o te wā, ka hoki mai ahau ki a koe, ā, ka whai tamaiti a Hara.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Nā, ka whakawareware a Hara, ka mea, “Kīhai ahau i kata”; i wehi hoki ia. Ā, ka mea ia, “Kāhore; i kata tonu koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nā, ka whakatika atu ngā tāngata rā i reira, ā, ka titiro ki te ritenga mai o Horoma; i haere anō a Āperahama i a rātou, ki te tuku i a rātou kia haere. ");
INSERT INTO mri2012_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ā, ka mea a Ihowā, “Me huna rānei e ahau i a Āperahama tāku e mea ai. ");
INSERT INTO mri2012_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ka meinga nei hoki a Āperahama hei iwi nui, hei iwi kaha, ā, māna ka manaakitia ai ngā iwi katoa o te ao? ");
INSERT INTO mri2012_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","E mōhio ana hoki ahau ki a ia, hei mea kia whakahaua iho ai e ia āna tama, me tōna whare, i muri i a ia, ā, kia whakaritea e rātou te ara o Ihowā, ka mahi hoki i te tika, i te whakawā; ā, kia kawea mai ai e Ihowā ki runga ki a Āperahama ngā mea katoa i kōrerotia e ia mōna.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nā, ka mea a Ihowā, “I te mea he nui te karanga o Horoma, o Komora, he taimaha rawa hoki ō rāua kino; ");
INSERT INTO mri2012_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","me haere tēnei ahau kia kite he mea rite rānei tā rāua mahi ki tōna karanga kua tae ake nei ki ahau; ā, ki te kāhore, ka mōhio ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Nā, ka tahuri ngā tāngata rā i reira, ā, ka ahu ki Horoma; ko Āperahama ia i tū tonu i te aroaro o te Atua. ");
INSERT INTO mri2012_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nā, ka whakatata a Āperahama, ka mea, “Ka whakangaromia anō hoki e koe te tangata tika rāua ko te tangata kino? ");
INSERT INTO mri2012_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ākuanei pea e rima tekau ngā tāngata tika i roto i te pā; ka whakangaromia rānei e koe, e kore rānei koe e tohu i taua wāhi mō ngā tāngata tika e rima tekau i roto? ");
INSERT INTO mri2012_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kaua rā tēnā e waiho hei tikanga mō tāu mahi, te whakamate ngātahi i te tangata tika rāua ko te tangata kino. Pēnei ka rite te tangata tika ki te tangata kino; kaua rā koe e pērā. E kore rānei e tika te mahi a te Kaiwhakawā o te whenua katoa?” ");
INSERT INTO mri2012_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nā, ka mea a Ihowā, “Ki te kitea e ahau i Horoma e rima tekau ngā tāngata tika i roto i te pā, ka tohungia e ahau tēnā wāhi katoa, ka whakaaro hoki ki a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Nā, ka whakahoki a Āperahama, ka mea, “Nā, kua tīmata nei ahau te kōrero ki te Ariki; he puehu nei ahau, he pungarehu. ");
INSERT INTO mri2012_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tērā pea e kore te tokorima o te rima tekau o ngā tāngata tika ka kore te tokorima, e whakangaro rānei koe i te pā katoa?” Ka mea ia, “E kore e whakangaromia e ahau ki te mea ka kitea e ahau i reira ngā tāngata e whā tekau mā rima.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nā, ka kōrero atu anō ia ki a ia, ka mea, “Tērā pea e kitea e whā tekau kei reira.” Ka mea ia, “Ka whakaaro ahau ki te whā tekau, ā, e kore e meatia e ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Anō rā ko ia, “Kaua rā e riri te Ariki, ā, ka kōrero ahau. Tērā pea e kitea e toru tekau kei reira.” Ka mea ia, “E kore e meatia e ahau, ki te kitea e ahau e toru tekau kei reira.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ā, ka mea ia, “Nā, kua whakapakari nei ahau ki te kōrero ki te Ariki. Tērā pea e kitea e rua tekau kei reira.” Ka mea ia, “Ka whakaaro ahau ki ngā tekau e rua, ā, e kore e whakangaromia e ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Nā, ka mea ia, “Kaua e riri te Ariki ki te kōrero ahau, heoi anō ko tēnei kōrerotanga. Tērā pea e kitea kotahi tekau kei reira.” Ka mea ia, “Ka whakaaro ahau ki te tekau kotahi, ā, e kore e whakangaromia e ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Nā, ka haere a Ihowā i te mutunga o tāna kōrero ki a Āperahama; ā, hoki ana a Āperahama ki tōna wāhi. ");
INSERT INTO mri2012_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nā, ka haere mai ngā anahera tokorua ki Horoma i te ahiahi; ā, ko Rota i te kūwaha o Horoma e noho ana. Ā, ka kite a Rota i a rāua, ka whakatika ki te whakatau i a rāua, ā, ka tuohu tōna kanohi ki te whenua, ");
INSERT INTO mri2012_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ka mea ia, “Nanā, e ōku ariki, peka mai ki te whare o tā kōrua pononga, nē? Ki konei moe ai, horoi ai hoki i ō kōrua waewae, ā, ka moata ai te maranga, ka haere i tā kōrua haere.” Ka mea rāua, “Kāhore; engari ki te huarahi noa māua moe ai.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nā, ka kaha tāna tohe ki a rāua, ā, peka atu ana rāua ki a ia, haere ana ki tōna whare. Nā, ka taka ia i tētahi hākari mā rāua, ka tunu hoki i ētahi keke rēwenakore, ā, ka kai rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kīanō rāua i takoto noa, ka karapotia te whare e ngā tāngata o te pā, e ngā tāngata o Horoma, e te koroheke, e te taitamariki, e ngā tāngata katoa o ngā wāhi katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ā, ka karanga rātou ki a Rota, ka mea ki a ia, “Kei hea aua tāngata i haere mai nei ki a koe i te pō nei? Whakaputaina mai ki a mātou, kia mōhio ai mātou ki a rāua.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Nā, ka puta atu a Rota ki a rātou ki te kūwaha, me tāna tūtaki anō i te tatau i muri i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ka mea, “Kaua rā e kino, e ōku tuākana. ");
INSERT INTO mri2012_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nanā, tokorua āku tamāhine, kāhore nei i mōhio noa ki te tāne, me whakaputa atu rāua e ahau ki a koutou, ā, mā koutou e mea ki a rāua te mea e pai ana ki tā koutou titiro. Kaua ia e meatia tētahi mea ki ēnei tāngata; he mea hoki ka tae mai nei rāua ki te taumarumarutanga iho o tōku tuanui.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Anō rā ko rātou, “Tū atu!” Ā, ka mea anō rātou, “I haere mai tēnei korokē kotahi ki konei noho ai, ā, e whai ana kia māna e whakarite tikanga. Ākuanei tōu mate i a mātou nui atu i tō rāua.” Nā, ka āki rawa rātou ki te tangata rā, ki a Rota, ā, ka whakatata ki te wāhi i te tatau. ");
INSERT INTO mri2012_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Otirā, ka totoro atu te ringa o aua tāngata, ā, kūmea ana a Rota ki a rāua ki roto ki te whare, ā, tūtakina ana e rāua te tatau. ");
INSERT INTO mri2012_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Nā, ka whiua e rāua ngā tāngata i te kūwaha o te whare, te iti, te rahi, ki te matapōtanga; ā, ngenge noa rātou i te rapunga i te tatau. ");
INSERT INTO mri2012_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nā, ka mea aua tāngata ki a Rota, “Kāhore atu rānei ōu tāngata i konei? Me he hunaonga, he tama rānei āu, he tamāhine rānei āu, tētahi atu mea rānei āu i roto i te pā, mauria atu i tēnei wāhi. ");
INSERT INTO mri2012_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ka whakangaromia hoki tēnei wāhi e māua, nō te mea kua nui tō rātou karanga ki te aroaro o Ihowā; kua tonoa mai hoki māua e Ihowā ki te whakangaro.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Nā, ka haere a Rota, ka kōrero ki āna hunaonga i mārenatia nei ki āna tamāhine, ka mea, “Whakatika, haere atu i konei; ka whakangaromia hoki e Ihowā tēnei pā.” Otiia, ki te whakaaro o āna hunaonga i rite ia ki tētahi tangata e hangareka ana. ");
INSERT INTO mri2012_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ā, i te huakanga ake o te ata, ka akiaki ngā anahera i a Rota, ka mea, “Whakatika, haria tāu wahine, me ēnei tamāhine tokorua āu, kei hunā koe i roto i te kino o tēnei pā.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Otirā, i whakaroa ia; nā, ka hopu aua tāngata ki tōna ringa, ki te ringa o tāna wahine, ki ngā ringa o āna tamāhine tokorua; he tohu hoki nā Ihowā i a ia. Ā, kawea atu ana ia e rāua ki waho, ka waiho i waho o te pā. ");
INSERT INTO mri2012_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ā, ka oti rātou te kawe atu e rāua ki waho, ka mea ia, “Rere atu kia ora ai koe; kaua e titiro ki muri i a koe, kaua hoki e tū ki tētahi wāhi o te mānia; rere atu ki te maunga, kei ngaro koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Nā, ka mea a Rota ki a rāua, “Kaua rā e pēnā, e tōku Ariki. ");
INSERT INTO mri2012_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nanā, kua manakohia nei tāu pononga e koe, kua whakanuia anō e koe tōu aroha i whakaputaina nei, e koe ki ahau, i a koe i whakaora nei i tōku wairua; nā, e kore e taea e ahau te rere ki te maunga, kei mau ahau i tētahi kino, ā, ka mate. ");
INSERT INTO mri2012_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Titiro hoki, e tata ana tēnei pā hei rerenga atu, he mea nohinohi noa nei. Kia rere ahau ki reira nē? – Ehara ianei i te mea nohinohi? – ā, ka ora tōku wairua.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Anō rā ko ia ki a ia, “Nā, kua whakaae anō hoki ahau ki tēnei meatanga āu, kia kaua e hunā e ahau tēnei pā i kōrero mai nā koe. ");
INSERT INTO mri2012_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kia hohoro, rere atu ki reira; e kore hoki e taea e ahau tētahi mea, kia tae rā anō koe ki reira.” Nā reira i huaina ai te ingoa o taua pā ko Toara. ");
INSERT INTO mri2012_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kua rewa te rā ki runga ki te whenua, ka tae a Rota ki Toara. ");
INSERT INTO mri2012_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kātahi ka uaina e Ihowā ki Horoma, ki Komora, he whānāriki, he ahi nā Ihowā, nō te rangi; ");
INSERT INTO mri2012_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ā, hurihia iho e ia aua pā, me te mānia katoa, me ngā tāngata katoa o ngā pā, me ngā mea e tupu ana i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nā, i titiro tāna wahine ki muri i a ia, ā, meinga ana hei pou tote. ");
INSERT INTO mri2012_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ā, i maranga wawe a Āperahama i te ata ki te wāhi i tū ai ia i te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nā, ko tōna tirohanga atu ki te ritenga o Horoma, o Komora, ki te whenua katoa hoki o te mānia, ka kite, nā, e kake ana te paowa o te whenua, me te mea he paowa oumu. ");
INSERT INTO mri2012_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nā, i te whakangaromanga a Ihowā i ngā pā o te mānia, ka mahara te Atua ki a Āperahama, ā, tonoa ana e ia a Rota i roto i te hurihanga i tāna hurihanga i ngā pā i noho ai a Rota. ");
INSERT INTO mri2012_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Nā, ka piki atu a Rota i Toara, ka noho ki te maunga, rātou tahi ko āna tamāhine tokorua; i wehi hoki ia ki te noho i Toara; ā, ka noho i roto i tētahi ana, a ia me āna tamāhine tokorua. ");
INSERT INTO mri2012_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nā, ka mea te tuakana ki tō muri, “Kua koroheke tō tāua pāpā, ā, kāhore he tangata o te whenua hei haere mai ki a tāua, hei pērā me tō te whenua katoa tikanga. ");
INSERT INTO mri2012_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tēnā, tāua ka whakainu i tō tāua pāpā ki te wāina, ka takoto ai tāua ki a ia, kia tupu ai i a tāua tētahi uri mō tō tāua pāpā.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nā, ka whakainu rāua i tō rāua pāpā ki te wāina i taua pō; ā, ka haere atu te tuakana, ka takoto ki tōna pāpā, kīhai hoki tērā i mōhio ki tōna takotoranga iho, ki tōna whakatikanga ake. ");
INSERT INTO mri2012_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ā, i te aonga ake ka mea te tuakana ki tō muri, “Nanā, i takoto ahau inapō ki tōku pāpā; tāua anō ka whakainu i a ia ki te wāina i tēnei pō; ā, māu e haere atu, e takoto ki a ia, kia tupu ai i a tāua tētahi uri mō tō tāua pāpā.” ");
INSERT INTO mri2012_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Nā, ka whakainu anō rāua i tō rāua pāpā ki te wāina i taua pō; ā, ka whakatika tō muri, ka takoto hoki ki a ia; ā, kīhai ia i mōhio ki tōna takotoranga iho, ki tōna whakatikanga ake. ");
INSERT INTO mri2012_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Koia ka hapū ngā tamāhine tokorua a Rota i tō rāua pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ā, ka whānau tā te tuakana, he tama, ā, huaina ana e ia tōna ingoa ko Moapa; ko ia te pāpā o ngā Moapi, ā tae noa ki tēnei rā. ");
INSERT INTO mri2012_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Me tō muri, whānau ake anō tāna, he tama, ā, huaina iho e ia tōna ingoa ko Penami. Ko ia te pāpā o ngā tama a Āmona, ā tae noa ki tēnei rā. ");
INSERT INTO mri2012_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Nā, ka tūria atu e Āperahama i reira ki te whenua i te tonga, ā, ka noho ki waenganui o Karehe, o Huru, ā, ka noho ia ki Kerara, he noho manene. ");
INSERT INTO mri2012_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Nā, ko Hara, ko tāna wahine, ka kīia e Āperahama, “Ko tōku tuahine ia.” Ā, ka tonoa mai e Apīmereke kīngi o Kerara, tangohia atu ana a Hara. ");
INSERT INTO mri2012_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Nā, ka puta moemoeā mai te Atua ki a Apīmereke i te pō, ka mea ki a ia, “Nanā, ka mate koe mō te wahine i tangohia nei e koe; he wahine hoki ia nā te tāne.” ");
INSERT INTO mri2012_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Kāhore anō ia a Apīmereke kia tata noa ki a ia, ā, ka mea ia, “E te Ariki, ka whakamate anō rānei koe i te iwi tika? ");
INSERT INTO mri2012_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Kāhore rānei ia i mea mai ki ahau, ‘Ko tōku tuahine ia?’ Me te wahine hoki, i mea mai anō ia, ‘Ko tōku tungāne ia.’ He tapatahi tōku ngākau, he harakore hoki ōku ringa i mea ai ahau i tēnei mea.” ");
INSERT INTO mri2012_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ā, ka kōrero moemoeā mai te Atua ki a ia, “Āe rā, i mōhio tonu ahau he tapatahi tōu ngākau i a koe i mea ai i tēnei mea; i pupuri hoki ahau i a koe kei hara koe ki ahau. Nā reira, koe tē tukua ai e ahau kia pā ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nā, whakahokia ākuanei te wahine a tēnā tangata; nō te mea hoki he poropiti ia, ā, māna e īnoi mōu, ā, ka ora koe. Ki te kore e whakahokia e koe, kia mōhio koe, ka tino mate koe, koutou ko ngā mea katoa i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Nā, i te atatū ka maranga a Apīmereke, karangatia ana āna tāngata katoa, ā, kōrerotia ana ēnei mea katoa ki ō rātou taringa. Ā, nui atu te wehi o aua tāngata. ");
INSERT INTO mri2012_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Nā, ka karanga a Apīmereke ki a Āperahama, ka mea ki a ia, “He mahi aha tēnei āu ki a mātou? Ā, he aha tōku hara ki a koe, i tākina mai ai e koe he hara nui ki ahau, ki tōku kīngitanga anō hoki? Kua meinga e koe ētahi mea ki ahau kāhore nei i tika kia mahia.” ");
INSERT INTO mri2012_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ā, ka mea anō a Apīmereke ki a Āperahama, “I kite koe i te aha i meatia ai tēnei mea e koe?” ");
INSERT INTO mri2012_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Nā, ka mea a Āperahama, “I mahara hoki ahau, ‘He pono, kāhore te wehi o te Atua i tēnei wāhi; ā, ka patua ahau e rātou mō tāku wahine.’ ");
INSERT INTO mri2012_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","He pono anō ia he tuahine ia nōku, ko te tamāhine a tōku pāpā, otiia ehara i te tamāhine nā tōku whaea; ā, ka noho hei wahine māku. ");
INSERT INTO mri2012_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ā, i tā te Atua meatanga i ahau kia kōpiko haere ake i te whare o tōku pāpā, ka mea ahau ki a ia, ‘Ko tōu aroha tēnei, hei whakaputa māu ki ahau: hei ngā wāhi katoa e tae ai tāua, kōrero mōku, “Ko tōku tungāne ia.” ’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Nā, ka tīkina e Apīmereke he hipi, he kau, he pononga tāne, he pononga wāhine, ā, hoatu ana e ia ki a Āperahama, ā, whakahokia ana e ia a Hara, tāna wahine, ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ā, ka mea a Apīmereke, “Nanā, kei tōu aroaro tōku whenua; nohoia e koe te wāhi e pai ana ki tāu titiro.” ");
INSERT INTO mri2012_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ā, ki a Hara i mea ia, “Nanā, kua hoatu e ahau ki tōu tungāne kotahi mano ngā hiriwa; nā, hei uhi tēnā mō ōu kanohi ki ngā tāngata katoa i a koe; hei tohu hoki mō tōu tika i katoa.” ");
INSERT INTO mri2012_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kātahi ka īnoi a Āperahama ki te Atua; nā, kua ora i te Atua a Apīmereke, rātou ko tāna wahine, ko āna pononga wāhine; ā, ka whānau tamariki rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kua tūtakina rawatia hoki e Ihowā ngā kōpū katoa o te whare o Apīmereke, mō Hara, mō te wahine a Āperahama. ");
INSERT INTO mri2012_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Nā, ka tirohia mai a Hara e Ihowā, ka pērātia me tāna i kōrero ai, ā, rite tonu ki tāna kupu tā Ihowā i mea ai ki a Hara. ");
INSERT INTO mri2012_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nā, ka hapū a Hara, ā, ka whānau he tama mā Āperahama i tōna koroheketanga i te wā anō i whakaritea e te Atua ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Nā, ka huaina e Āperahama te ingoa o tāna tama i whānau nei māna, i whānau mai nei i a Hara, ko Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ā, ka waru ōna rā, ka kotia e Āperahama a Īhaka, tāna tama, ka pērātia me tā te Atua i whakahau ai ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ā, kotahi rau ngā tau o Āperahama i te whānautanga o tāna tama, o Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Nā, ka mea a Hara, “Kua meinga ahau e te Atua kia kata; ā, ka kata tahi mātou ko ngā tāngata e rongo mai ana.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ā, i mea anō ia, “Ko wai ō mua hei mea ki a Āperahama, tērā e whakangote tamariki a Hara? Kua whānau nei i ahau he tama māna, i a ia kua koroheketia.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nā, ka tupu te tamaiti rā, ā, ka whakamutua tāna kai ū; nā, ka tukua e Āperahama tētahi hākari nui i te rā i whakamutua ai te ngote ū a Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ā, ka kite a Hara i te tama a Hakara, a te wahine o Īhipa, i whānau nei i a rāua ko Āperahama, e kata whakahāwea ana. ");
INSERT INTO mri2012_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Nā, ka mea ia ki a Āperahama, “Peia atu tēnei pononga me tāna tama. E kore rawa te tama a tēnei wahine pononga e tū tahi me tāku tama, me Īhaka, i ngā whakarerenga iho.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ā, ko taua mea he hē rawa ki te titiro a Āperahama, ko tāna tama hoki ia. ");
INSERT INTO mri2012_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ka mea te Atua ki a Āperahama, “Kei kino tēnā ki tāu titiro, kaua e whakaaro ki te tamaiti rāua ko tāu pononga wahine. Engari, i ngā mea katoa i kōrero ai a Hara ki a koe, whakarongo atu ki tōna reo; kei a Īhaka hoki te karangatanga mō tōu uri. ");
INSERT INTO mri2012_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nā, ko te tama a te pononga wahine, ka meinga ia e ahau hei iwi, nō te mea he uri ia nōu.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Nā, ka maranga wawe a Āperahama i te ata, ka mau ki tētahi taro, ki tētahi tahā wai, ā, hoatu ana e ia ki a Hakara, whakawahā ana ki tōna pokohiwi, me te tamaiti hoki, ā, tonoa atu ana. Nā, ka haere ia, ka kōpikopiko i te koraha o Peerehepa. ");
INSERT INTO mri2012_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ā, ka pau te wai i roto i te tahā, nā, whakarērea iho e ia te tamaiti i raro i tētahi rākau iti. ");
INSERT INTO mri2012_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Nā, ka haere ia, ā, ka noho mai i tawhiti, me te anga nui mai anō ki a ia, he pērā te matara me te taunga pere; i mea hoki ia, “Kei kite ahau i te matenga o te tamaiti.” Nā, ka noho ia me te aronui mai anō ki a ia, ā, ka puaki tōna reo, ka tangi. ");
INSERT INTO mri2012_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ā, i rongo te Atua ki te reo o te tamaiti, ā, ka karanga mai te anahera a te Atua ki a Hakara i runga i te rangi, ka mea ki a ia, “He aha kei a koe, e Hakara? Kaua e wehi; kua rongo hoki te Atua ki te reo o te tamaiti i a ia e takoto nā. ");
INSERT INTO mri2012_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Whakatika, hāpainga ake te tamaiti, puritia hoki ki tōu ringa; nō te mea ka meinga ia e ahau hei iwi nui.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Nā, ka whakatirohia e te Atua ōna kanohi, ā, ka kite ia i tētahi puna wai. Nā, ka haere ia, ka whakakī i te tahā ki te wai, ā, whakainumia ana te tamaiti. ");
INSERT INTO mri2012_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ā, i noho te Atua ki te tamaiti, ā, ka tupu ia; i noho ia i te koraha, ā, ka mōhio ki te kōpere. ");
INSERT INTO mri2012_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nā, ka noho ia ki te koraha o Parana; ā, ka tīkina atu e tōna whaea he wahine māna i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ā, i taua wā anō ka kōrero a Apīmereke rāua ko Pikora, ko te rangatira o tāna ope, ki a Āperahama, ka mea, “Nā, kei a koe te Atua i ngā mea katoa e mea ai koe; ");
INSERT INTO mri2012_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","tēnā oatitia mai te Atua ki ahau, e kore koe e teka ki ahau, ki tāku tama, ki te tama rānei a tāku tama. Engari ka rite ki te aroha i whakaputaina e ahau ki a koe tāu mahi ki ahau, ki te whenua anō hoki i noho nei koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Nā, ka mea a Āperahama, “Ka oati ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Nā, ka whakawā a Āperahama i a Apīmereke mō tētahi puna wai i murua e ngā tāngata a Apīmereke. ");
INSERT INTO mri2012_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Nā, ka mea a Apīmereke, “Kāhore ahau e mōhio nā wai rānei tēnei mahi. Kīhai hoki koe i kōrero mai ki ahau, ā, kīhai ahau i rongo, nō tēnei rā tonu.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Nā, ka tīkina e Āperahama he hipi, he kau, ka hoatu ki a Apīmereke; nā, ka whakarite kawenata rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Nā, ka wehea e Āperahama ki tahaki e whitu ngā reme uha o ngā hipi. ");
INSERT INTO mri2012_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ā, ka mea a Apīmereke ki a Āperahama, “He aha te tikanga o ēnei reme uha e whitu i wehea nei e koe ki tahaki?” ");
INSERT INTO mri2012_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ka mea ia, “Ko ēnei reme uha e whitu me tango e koe i tōku ringa, kia ai ēnei mea hei whakaatu māku, nāku i keri tēnei poka.” ");
INSERT INTO mri2012_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Nā, reira i huaina ai e ia taua wāhi ko Peerehepa; nō rāua hoki i oati ki reira. ");
INSERT INTO mri2012_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Heoi, whakaritea ana e rāua te kawenata i Peerehepa. Ā, ka whakatika a Apīmereke rāua ko Pikora, ko te rangatira o tāna ope, ā, hoki ana ki te whenua o ngā Pirihitini. ");
INSERT INTO mri2012_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nā, ka whakatōkia e Āperahama he rākau, he tamarihi, ki Peerehepa, ā, ka karanga i reira ki te ingoa o Ihowā, o te Atua ora tonu. ");
INSERT INTO mri2012_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ā, ka noho a Āperahama ki te whenua o ngā Pirihitini mō ngā rā maha. ");
INSERT INTO mri2012_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nā, i muri i ēnei mea ka whakamātau te Atua i a Āperahama, ka mea ki a ia, “E Āperahama!” Ka mea ia, “Tēnei ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nā, ka mea ia, “Kawea atu tāu tamaiti, tāu huatahi, tāu e aroha nei, a Īhaka, ā, haere ki te whenua o Moria. Ka whakaeke i a ia ki reira hei tahunga tinana ki runga ki tētahi o ngā maunga e kōrero ai ahau ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nā, ka maranga wawe a Āperahama i te ata, ā, whakanohoia ana e ia tana kāihe, ā, mauria ana e ia ētahi o āna taitamariki hei hoa mōna, me Īhaka hoki, me tāna tama, ā, tātāngia ana e ia ngā wahie mō te tahunga tinana, ā, whakatika ana, haere ana ki te wāhi i kōrero ai te Atua ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","I te rā tuatoru ka maranga ngā kanohi o Āperahama, ā, ka kite ia i taua wāhi i tawhiti. ");
INSERT INTO mri2012_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Nā, ka mea a Āperahama ki āna taitamariki, “E noho kōrua i konei ki te kāihe. Ka haere māua ko te tamaiti nei ki kō, ki te koropiko, ka hoki mai ai ki a kōrua.” ");
INSERT INTO mri2012_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Nā, ka tango a Āperahama i te wahie mō te tahunga tinana, ā, whakawahā ana e ia ki a Īhaka, ki tāna tama, ā, ka mauria e ia he ahi i tōna ringa me tētahi māripi. Ā, haere tahi ana rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Nā, ka kōrero a Īhaka ki a Āperahama, ki tōna pāpā, ka mea, “E tōku matua!” Ka mea ia, “Tēnei ahau, e tāku tama.” Ā, ka mea ia, “Nanā, ko te ahi me ngā wahie; kei hea ia te reme hei tahunga tinana?” ");
INSERT INTO mri2012_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ka mea a Āperahama, “Kei te Atua te whakaaro, e tāku tamaiti, ki tētahi reme māna hei tahunga tinana.” Nā, ka haere tahi rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ā, ka tae rāua ki te wāhi i kōrero ai te Atua ki a ia; ā, ka hangā e Āperahama tētahi āta ki reira, ā, whakapapatia ana e ia ngā wahie, nā, ka herea e ia a Īhaka, tāna tama, whakatakotoria iho ki te āta, ki runga ki ngā wahie. ");
INSERT INTO mri2012_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Nā, ka totoro atu te ringa o Āperahama, ka mau ki te māripi hei patu mō tāna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Nā, ko te karangatanga mai a te anahera a Ihowā ki a ia i runga i te rangi, ka mea, “E Āperahama, e Āperahama!” Ka mea ia, “Tēnei ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Nā, ka mea ia, “Kaua e totoro tōu ringa ki te tamaiti, kaua anō hoki tētahi mea e meatia ki a ia. Kātahi hoki ahau ka mātau e wehi ana koe i te Atua, i a koe kīhai nei i kaiponu i tāu tamaiti, i tāu huatahi, i ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ā, ka maranga ake ngā kanohi o Āperahama, nā, ka kite ia ko tētahi hipi toa i muri i a ia, e mau ana ōna haona i roto i te puia rākau. Nā, ka haere a Āperahama, ka hopu i te hipi rā, ā, whakaekea ana e ia hei tahunga tinana, hei whakarite mō tāna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Nā, ka huaina e Āperahama te ingoa o taua wāhi ko Ihowātire. E kōrerotia nei ināianei, “Kei te maunga o Ihowā te kitea ai.” ");
INSERT INTO mri2012_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nā, ka karanga anō te anahera a Ihowā ki a Āperahama i te rangi, ");
INSERT INTO mri2012_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ka mea, “Kua waiho e ahau ko ahau anō hei oati, e ai tā Ihowā, mōu i mea i tēnei mea, mōu anō hoki kīhai i kaiponu i tāu tama, i tāu huatahi, ");
INSERT INTO mri2012_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nā, ka manaakitia rawatia koe e ahau, ā, ka whakanuia rawatia e ahau ōu uri kia pērā me ngā whetū o te rangi, me te onepū hoki i te tahatika o te moana. Ā, ka riro i ōu uri te kūwaha o ōna hoariri, ");
INSERT INTO mri2012_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","mā tōu uri anō hoki ka manaakitia ai ngā iwi katoa o te whenua; mōu i whakarongo ki tōku reo.” ");
INSERT INTO mri2012_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nā, ka hoki a Āperahama ki āna taitamariki, ā, whakatika ana rātou, haere tahi ana ki Peerehepa; ā, ka noho a Āperahama ki Peerehepa. ");
INSERT INTO mri2012_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nā, i muri i ēnei mea ka kōrerotia ki a Āperahama, ka meatia, “Nanā, kua whānau tamariki anō a Mireka rāua ko Nahora, ko tōu teina: ");
INSERT INTO mri2012_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ko Hutu, ko tāna mātāmua, rāua ko Putu, ko tōna teina, me Kemuera hoki, matua o Arame, ");
INSERT INTO mri2012_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","rātou ko Kehere, ko Hato, ko Piretata, ko Irirapa, ko Petuere.” ");
INSERT INTO mri2012_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ā, whānau ake tā Petuere ko Ripeka. Ko ēnei tokowaru te whānau a Mireka rāua ko Nahora, teina o Āperahama. ");
INSERT INTO mri2012_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ā, ko tāna wahine iti, tōna ingoa nei ko Reuma, i whānau anō āna: ko Tepa rātou ko Kahama, ko Tahaha, ko Maaka. ");
INSERT INTO mri2012_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nā, kotahi rau e rua tekau mā whitu ngā tau i ora ai a Hara. Ko ngā tau ēnei i ora ai a Hara. ");
INSERT INTO mri2012_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Nā, ka mate a Hara ki Kiriata Arapa (arā ki Heperona) i te whenua o Kanaana; ā, ka haere a Āperahama ki te uhunga ki a Hara, ki te tangi hoki ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ā, ka whakatika a Āperahama i te ritenga atu o tōna tūpāpaku, ka kōrero ki ngā tama a Hete, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“He manene ahau, he noho noa iho i roto i a koutou; hōmai tētahi wāhi ki ahau hei tanumanga i roto i a koutou, kia tanumia ai e ahau tōku tūpāpaku, kia ngaro ai i tāku tirohanga.” ");
INSERT INTO mri2012_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Nā, ka whakahoki ngā tama a Hete ki a Āperahama, ka mea ki a ia, ");
INSERT INTO mri2012_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Whakarongo ki a mātou, e tōku ariki; he rangatira nui koe i roto i a mātou. Whiriwhiria e koe tētahi o ō mātou urupā, ka tanu ai i tōu tūpāpaku. E kore e kaiponuhia e tētahi o mātou tana urupā i a koe, hei tanumanga mō tōu tūpāpaku.” ");
INSERT INTO mri2012_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Nā, ka whakatika a Āperahama, ka piko ki te tangata whenua, ki ngā tama a Hete, ");
INSERT INTO mri2012_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ā, ka kōrero ia ki a rātou, ka mea, “Ki te whai ngākau koutou kia tanumia e ahau tōku tūpāpaku kia ngaro atu i tāku tirohanga, whakarongo mai ki ahau, ka tohe atu ki a Eperona, tama a Tohara, mōku, ");
INSERT INTO mri2012_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kia hōmai e ia ki ahau tana ana, a Makapera, i te pito o tōna wāhi oneone. Kia hōmai e ia ki ahau i waenganui i a koutou mō ngā moni e rite ana hei utu, kia puritia e ahau hei urupā.” ");
INSERT INTO mri2012_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Nā, ko Eperona i roto i ngā tama a Hete e noho ana; nā, ka whakahoki a Eperona Hiti ki a Āperahama, me te whakarongo anō ngā tama a Hete, me ngā tāngata katoa hoki i tomo i te kūwaha o tōna pā, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Kāhore, e tōku ariki, whakarongo ki ahau; ka hoatu e ahau tēnā wāhi ki a koe, me te ana i reira, ka hoatu e ahau ki a koe. Ka hoatu e ahau i te aroaro o ngā tama a tōku iwi; tanumia tōu tūpāpaku.” ");
INSERT INTO mri2012_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Nā, ka tuohu a Āperahama i te aroaro o ngā tāngata whenua, ");
INSERT INTO mri2012_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ka kōrero ki a Eperona, me te whakarongo anō ngā tāngata whenua, ka mea, “Erangi ki te hōmai e koe, whakarongo ki ahau. Ka hoatu e ahau he hiriwa ki a koe mō taua wāhi; tangohia, ā, ka tanumia e ahau tōku tūpāpaku ki reira.” ");
INSERT INTO mri2012_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Nā, ko te whakahokinga a Eperona ki a Āperahama, ka mea ki a ia, ");
INSERT INTO mri2012_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“E tōku ariki, whakarongo mai ki ahau; he wāhi whenua e whā rau ngā hekere hiriwa tōna utu, he aha tēnā i waenganui ōku, ōu? Tanumia tōu tūpāpaku.” ");
INSERT INTO mri2012_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Nā, ka whakarongo a Āperahama ki a Eperona; ā, pāunatia ana e Āperahama ki a Eperona te hiriwa i kōrerotia e ia i te aroaro o ngā tama a Hete, e whā rau ngā hekere hiriwa, nō ngā moni e tangohia ana e ngā kaihokohoko. ");
INSERT INTO mri2012_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Nā, whakapūmautia ana te wāhi oneone o Eperona, i Makapera, i te ritenga o Mamere, te oneone, me te ana i reira, me ngā rākau katoa i runga i te oneone, i roto i ōna rohe katoa, ā tawhio noa, ");
INSERT INTO mri2012_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","hei wāhi mō Āperahama, i te tirohanga a ngā tama a Hete, i te aroaro o ngā tāngata katoa i tomo i te kūwaha o tōna pā. ");
INSERT INTO mri2012_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ā muri iho i tēnei ka tanumia e Āperahama a Hara, tāna wahine, ki roto ki te ana, i te wāhi i Makapera i te ritenga o Mamere, arā o Heperona i te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Heoi, whakapūmautia ana e ngā tama a Hete taua wāhi me te ana i reira mō Āperahama, kia puritia hei tanumanga. ");
INSERT INTO mri2012_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Nā, kua koroheketia a Āperahama, ā, kua maha rawa ōna rā; ā, i manaaki a Ihowā i a Āperahama i ngā mea katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Nā, ka mea a Āperahama ki te kaumātua o āna pononga i roto i tōna whare, ki te kaiwhakahaere o āna mea katoa, “Tēnā, whakapākia mai tōu ringa ki raro ki tōku hūhā, ");
INSERT INTO mri2012_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ā, me whakaoati koe e ahau ki a Ihowā, ki te Atua o te rangi, ki te Atua hoki o te whenua, kia kaua e tangohia e koe he wahine mā tāku tama i roto i ngā tamāhine a ngā Kanaani, a te iwi e noho nei ahau i roto i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Engari me haere koe ki tōku whenua, ki ōku whanaunga, ka tango mai ai i tētahi wahine mā tāku tama, mā Īhaka.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nā, ka mea te pononga ki a ia, “Ākuanei pea ka kore e pai te wahine ki te whai mai i ahau ki tēnei whenua; me whakahoki rānei e ahau tāu tama ki te whenua i haere mai nei koe i reira?” ");
INSERT INTO mri2012_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ka mea a Āperahama ki a ia, “Kia tino mōhio koe, kaua rawa tāku tama e whakahokia ki reira. ");
INSERT INTO mri2012_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ko Ihowā, ko te Atua o te rangi, nāna nei ahau i tango mai i te whare o tōku pāpā, i te whenua hoki i whānau ai ahau, i kōrero ki ahau, i oati hoki ki ahau, ‘Ka hoatu e ahau tēnei whenua ki ōu uri,’ māna e tono mai tāna anahera ki mua i koe, ā, ka riro mai i a koe tētahi wahine mā tāku tama i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ā, ki te kāhore te wahine e pai ki te whai mai i a koe, kātahi koe ka wātea i tēnei oati āku; otiia kaua e whakahokia e koe tāku tama ki reira.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Nā, ka whakapākia e te pononga tōna ringa ki raro i te hūhā o Āperahama, o tōna ariki, ā, ka oati ki a ia mō taua mea. ");
INSERT INTO mri2012_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nā, ka tangohia e te pononga ētahi kāmera kotahi tekau i roto i ngā kāmera a tōna ariki, ā, haere ana; i tōna ringa hoki ngā mea papai katoa a tōna ariki; ā, whakatika ana ia, haere ana ki Mehopotamia, ki te pā o Nahora. ");
INSERT INTO mri2012_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Nā, ka mea ia i ngā kāmera kia tūturi ki te taha o te puna wai i waho o te pā i te ahiahi, i te wā e puta mai ai ngā wāhine ki te utu wai. ");
INSERT INTO mri2012_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ā, ka mea ia, “E Ihowā, e te Atua o tōku ariki, o Āperahama, kia whai wāhi ahau ākuanei, whakaputaina hoki he aroha ki tōku ariki, ki a Āperahama. ");
INSERT INTO mri2012_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tēnei ahau te tū nei i te taha o te puna wai; ā, e haere mai ana ngā tamāhine a ngā tāngata o te pā ki te utu wai. ");
INSERT INTO mri2012_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ā, ko te kōtiro e mea ai ahau ki a ia, ‘Tukua iho tāu oko kia inu ai ahau,’ ā, ka mea ia, ‘E inu, me whakainu anō e ahau āu kāmera,’ kia rite ia i a koe mā tāu pononga, mā Īhaka; mā reira ka mōhio ai ahau e whakaputa aroha ana koe ki tōku ariki.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Heoi, kīanō i mutu noa tāna kōrero, nā, kua puta mai a Ripeka, tamāhine a Petuere, tama a Mireka, a te wahine a Nahora, teina o Āperahama, me tāna oko i runga i tōna pokohiwi. ");
INSERT INTO mri2012_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nā, ko te kōtiro rā he tino ātaahua ki te titiro atu, he wāhina, kāhore anō tētahi tāne kia mōhio noa ki a ia. Nā, ka heke atu ia ki te puna, ka whakakī i tāna oko, ā, ka haere ake. ");
INSERT INTO mri2012_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nā, ka rere te pononga rā ki te whakatūtaki i a ia, ka mea, “Hōmai he wai mōku, nē, o tāu oko kia iti nei?” ");
INSERT INTO mri2012_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ā, ka mea ia, “E inu, e tōku ariki,” nā, hohoro tonu tāna tuku iho i tāna oko ki runga ki tōna ringa, ā, whakainumia ana ia. ");
INSERT INTO mri2012_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ā, ka mutu tāna whakainu i a ia, ka mea ia, “Me utu anō hoki e ahau mō āu kāmera, kia poto rā anō rātou te whakainu.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nā, hohoro tonu tāna riringi atu i te wai o tāna oko ki roto ki te waka, ā, rere ana anō ki te puna ki te utu, ā, utuhia mai ana e ia mō ana kāmera katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ko taua tangata ia matatau tonu tāna titiro ki a ia, kīhai hoki i hamumu, kia mōhio ia ka whakatikaia rānei e Ihowā tōna ara, kāhore rānei. ");
INSERT INTO mri2012_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ā, ka mutu te inu o ngā kāmera, nā, ka tīkina e taua tangata tētahi whakakai kōura, he hāwhe hekere tōna taimaha, me ngā poroporo e rua mō ōna ringa, kotahi tekau ngā hekere kōura te taimaha; ");
INSERT INTO mri2012_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ā, ka mea, “Nā wai koe tamāhine? Tēnā, kōrero mai ki ahau; he wāhi rānei kei te whare o tōu pāpā hei moenga mō mātou?” ");
INSERT INTO mri2012_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nā, ka mea ia ki a ia, “He tamāhine ahau nā Petuere, tama a Mireka, i whānau nei i a rāua ko Nahora.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ā, ka mea anō ia ki a ia, “He nui ā mātou kakau wīti, me ā mātou otaota hei kai, me tētahi wāhi hoki hei moenga.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nā, tuohu ana taua tangata, koropiko ana ki a Ihowā, ");
INSERT INTO mri2012_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ā, ka mea, “Kia whakapaingia a Ihowā, te Atua o tōku rangatira, o Āperahama, kīhai nei i wareware ki tōna aroha, ki tōna pono ki tōku rangatira. Tēnā ko ahau, nā Ihowā anō ahau i arataki mai i te ara ki te whare o ngā tēina o tōku rangatira.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nā, ka oma te kōtiro rā, ka kōrero i ēnei mea ki te whare o tōna whaea. ");
INSERT INTO mri2012_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Nā, he tungāne tō Ripeka, ko Rāpana tōna ingoa; nā, ka rere a Rāpana ki taua tangata, ki waho, ki te puna. ");
INSERT INTO mri2012_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Nā, i tōna kitenga i te whakakai me ngā poroporo i ngā ringa o tōna tuahine, ā, ka rongo hoki ki ngā kupu a Ripeka, a tōna tuahine, i mea rā, “I pēnei ngā kōrero a taua tangata ki ahau,” ka haere ia ki taua tangata; nā, i te taha ia o ngā kāmera, i te puna wai e tū ana; ");
INSERT INTO mri2012_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ā, ka mea, “Tomo mai, e te manaakitanga a Ihowā; he aha koe i tū ai i waho? Kua oti hoki i ahau te whare te whakapai, me tētahi wāhi mō ngā kāmera.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Nā, ka haere taua tangata ki te whare, ā, wetekina ana e ia ngā mea o ngā kāmera; i hōmai anō e ia he kakau wīti me tētahi otaota hei kai mā ngā kararehe, me te wai hei horoi mō ōna waewae, mō ngā waewae hoki o ōna hoa. ");
INSERT INTO mri2012_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Nā, ka whakatakotoria he kai ki tōna aroaro; otiia ka mea ia, “E kore ahau e kai, kia kōrerotia rā anō e ahau tāku haere.” Ka mea tērā, “Kōrero.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Nā, ka mea ia, “He pononga ahau nā Āperahama. ");
INSERT INTO mri2012_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ā, kua manaakitia rawatia tōku ariki e Ihowā; kua nui ia; ā, kua hōmai hoki ki a ia he hipi, he kau, he hiriwa, he kōura, he pononga tāne, he pononga wāhine, he kāmera, he kāihe. ");
INSERT INTO mri2012_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ā, kua whānau he tama mā tōku ariki i a Hara, i te wahine a tōku ariki, i a ia kua rūruhitia; ā, kua hoatu e ia āna mea katoa ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nā, i whakaoati tōku ariki i ahau, i mea mai, ‘Kei tangohia e koe he wahine mā tāku tama i roto i ngā tamāhine a ngā Kanaani, e noho nei ahau i tō rātou whenua; ");
INSERT INTO mri2012_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","engari me haere koe ki te whare o tōku pāpā, ki ōku whanaunga ka tango ai i tētahi wahine mā tāku tama.’ ");
INSERT INTO mri2012_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Anō rā ko ahau ki tōku ariki, ‘E kore pea te wahine e whai mai i ahau.’ ");
INSERT INTO mri2012_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ā, ka mea mai ia ki ahau, ‘Mā Ihowā, kei tōna aroaro nei tōku hāereerenga, māna e tono tāna anahera hei hoa mōu, māna hoki e whakatika tōu ara; ā, ka tango mai koe i tētahi wahine mā tāku tama i roto i ōku whanaunga, i roto hoki i te whare o tōku pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kātahi koe ka wātea i tāku oati, ki te haere koe ki ōku whanaunga; ā, ki te kāhore e hōmai e rātou ki a koe, nā, ka wātea koe i tāku oati.’ ");
INSERT INTO mri2012_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“I haere mai ahau i tēnei rā ki te puna, ā, ka mea ahau, ‘E Ihowā, e te Atua o tōku ariki, o Āperahama, ki te mea e whakatika ana koe i tōku ara e haere nei ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nā, tēnei ahau te tū nei i te taha o te puna wai; ā, ko te kōtiro e puta mai ki te utu, ā, ka mea ahau ki a ia, “Hōmai he wāhi wai mōku i tāu oko kia inu ahau,” ");
INSERT INTO mri2012_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ā, ka mea mai ia ki ahau, “E inu, ā, me utu anō e ahau mō āu kāmera.” Kia rite ia i a Ihowā hei wahine mā te tama a tōku ariki.’ ");
INSERT INTO mri2012_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kīanō i mutu noa tāku kōrero i roto i tōku ngākau, nā, ko te putanga ake o Ripeka me tāna oko i runga i tōna pokohiwi; kua heke ki te poka ki te utu. Nā, ka mea ahau ki a ia, ‘Kia inu ahau, nē?’ ");
INSERT INTO mri2012_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Nā, ka hohoro ia, ka tuku i tāna oko i tōna pokohiwi, ā, ka mea mai, ‘E inu, me whakainu anō e ahau āu kāmera.’ Nā, inu ana ahau, ā, i whakainumia anō hoki e ia ngā kāmera. ");
INSERT INTO mri2012_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Nā, ka ui ahau ki a ia, ‘He tamāhine koe nā wai?’ “Ā, ka mea mai ia, ‘He tamāhine nā Petuere, tama a Nahora, i whānau nei mā rāua ko Mireka.’ “Nā, kuhua ana e ahau te whakakai ki tōna ihu, me ngā poroporo ki ōna ringa. ");
INSERT INTO mri2012_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nā, ka tuohu ahau, ka koropiko ki a Ihowā, ka whakapai hoki i a Ihowā, i te Atua o tōku ariki, o Āperahama, mōna i ārahi i ahau i te huarahi tika ki te tiki mai i te tamāhine a te teina o tōku ariki mā tāna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nā, ki te mea he aroha tō koutou, he mahi pono ki tōku ariki, kōrero mai ki ahau; ki te kāhore, kōrero mai; kia tahuri ake ai ahau ki matau rānei, ki mauī rānei.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Nā, ka whakahoki a Rāpana rāua ko Petuere, ka mea, “I puta mai tēnei mea i a Ihowā; e kore e taea e māua te kōrero ki a koe te pai, te kino rānei. ");
INSERT INTO mri2012_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nanā, kei tōu aroaro a Ripeka, tangohia, haere, ā, kia meinga ia hei wahine mā te tama a tōu ariki, hei pērā me tā Ihowā i kōrero ai.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ā, ka rongo te pononga a Āperahama i ā rāua kōrero, nā, piko ana ia ki te whenua, ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Nā, ka tangohia ake e te pononga he mea hiriwa, he mea kōura, he kākahu hoki, ā, hoatu ana e ia ki a Ripeka; ā, i hoatu e ia ētahi mea tino papai ki tōna tungāne rāua ko tōna whaea. ");
INSERT INTO mri2012_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nā, ka kai rātou, ka inu, rātou tahi ko ōna hoa haere, ā, moe iho i te pō. Ā, i te ata ka oho rātou, ka mea atu ia, “Tukua ahau kia haere ki tōku ariki.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nā, ka mea tōna tungāne rāua ko tōna whaea, “Waiho te kōtiro i a mātou mō ētahi rā torutoru, kia kotahi tekau pea; muri iho ka haere.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Nā, ka mea ia ki a rāua, “Kaua ahau whakawarea, kua whakatikaia nei hoki tōku ara e Ihowā; tukua ahau kia haere ki tōku ariki.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nā, ka mea rāua, “Me karanga e māua te kōtiro, ka ui ai ki tōna māngai.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Nā, ka karangatia e rāua a Ripeka, ka mea ki a ia, “Ka haere rānei koe i te tangata nei?” Ka mea ia, “Ka haere.” ");
INSERT INTO mri2012_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Nā, tukua ana e rātou a Ripeka, tō rātou tuahine, rātou ko tōna kaiwhakangote, ko te pononga hoki a Āperahama, me āna tāngata. ");
INSERT INTO mri2012_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Nā, ka manaaki rātou i a Ripeka, ka mea ki a ia, “E tō mātou tuahine, kia meinga koe hei whaea mō ngā mano tini; ā, kia riro i ōu uri te kūwaha o ō rātou hoariri!” ");
INSERT INTO mri2012_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Nā, ka whakatika a Ripeka, rātou ko āna kōtiro, ā, eke ana ki runga ki ngā kāmera, aru ana i taua tangata; nā, ka mauria e taua pononga a Ripeka, ā, haere ana. ");
INSERT INTO mri2012_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nā, ka hoki mai a Īhaka, i te haere i Peere-Rahai-Roi; i te wāhi hoki ki te tonga ia e noho ana. ");
INSERT INTO mri2012_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ā, ka puta atu a Īhaka ki te pārae i te tūahiahi ki te whakaaroaro; nā, ka maranga ake ōna kanohi, ka titiro, nā, ko ngā kāmera e haere mai ana. ");
INSERT INTO mri2012_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ā, ka whakaara ake a Ripeka i ōna kanohi, ā, nō tōna kitenga i a Īhaka, ka marere ia ki raro i te kāmera. ");
INSERT INTO mri2012_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ā, ka mea atu ia ki te pononga, “Ko wai tēnei tangata e haere mai nei i te pārae ki te whakatau i a tātou?” Anō rā ko te pononga, “Ko tōku ariki tēnā.” Nā, ka mau ia ki tētahi ārai kanohi, ka hīpoki i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nā, ka kōrerotia e te pononga ki a Īhaka ngā mea katoa i mea ai ia. ");
INSERT INTO mri2012_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Nā, ka kawea ia e Īhaka ki te tēneti o tōna whaea, o Hara. Ā, tangohia ana e ia a Ripeka, ā, ka noho ia hei wahine māna; ā, ka aroha ia ki a ia. Ā, ka whai tānga manawa a Īhaka i muri i te matenga o tōna whaea. ");
INSERT INTO mri2012_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nā, ka tangohia e Āperahama tētahi wahine anō, ko Ketura tōna ingoa. ");
INSERT INTO mri2012_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ā, whānau ake ā rāua tama ko Timirana, ko Iokohana, ko Merana, ko Miriana, ko Ihipaka, rātou ko Huaha. ");
INSERT INTO mri2012_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ā, whānau ake a Iokohana ko Hēpā, ko Rerana. Ā, ko ngā tama a Rerana ko Ahurimi, ko Retuhimi, ko Reumime. ");
INSERT INTO mri2012_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ā, ko ngā tama a Miriana ko Epa, ko Ēpere, ko Hanoka, ko Āpira, ko Ererāha. He tama katoa ēnei nā Ketura. ");
INSERT INTO mri2012_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ā, i hoatu e Āperahama āna mea katoa ki a Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ki ngā tama ia a ngā wāhine iti a Āperahama i hoatu e ia ētahi taonga, ā, tonoa atu ana e ia i a ia anō e ora ana kia matara atu i a Īhaka, i tāna tama, whaka te rāwhiti, ki te whenua i te rāwhiti. ");
INSERT INTO mri2012_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ko ngā rā ēnei o ngā tau o te oranga o Āperahama i ora ai ia, kotahi rau e whitu tekau mā rima ngā tau. ");
INSERT INTO mri2012_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Nā, ka hemo a Āperahama, ā, ka mate, he pai hoki tōna koroheketanga, he kaumātua, kua āta tutuki ōna tau; ā, kohia ana ia ki tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ā, ka tanumia ia e āna tama e Īhaka rāua ko Ihimaera ki te ana o Makapera, ki te wāhi o Eperona tama a Tohara Hiti, i te ritenga o Mamere, ");
INSERT INTO mri2012_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ki te wāhi i hokona rā e Āperahama i ngā tama a Hete. I tanumia ki reira a Āperahama, rāua ko Hara, ko tāna wahine. ");
INSERT INTO mri2012_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ā muri iho i te matenga o Āperahama ka manaakitia e te Atua a Īhaka, tāna tama; ā, ka noho a Īhaka ki te taha o Peere-Rahai-Roi. ");
INSERT INTO mri2012_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nā, ko ngā whakatupuranga ēnei o Ihimaera tama a Āperahama, i whānau nei mā Āperahama i a Hakara, i te Īhipiana, pononga wahine a Hara. ");
INSERT INTO mri2012_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ā, ko ngā ingoa ēnei o ngā tama a Ihimaera, ō rātou ingoa i ō rātou whakatupuranga: tā Ihimaera mātāmua ko Nepaioto; nā, ko Kerara, ko Arapēre, ko Mipihama, ");
INSERT INTO mri2012_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ko Mihima, ko Rūma, ko Maha, ");
INSERT INTO mri2012_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ko Hatara, ko Tema, ko Ieturu, ko Nāpihi, ko Kerema. ");
INSERT INTO mri2012_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ko ngā tama ēnei a Ihimaera, ko ō rātou ingoa hoki ēnei i ō rātou pā, i ō rātou puni; kotahi tekau mā rua ngā rangatira o ō rātou iwi. ");
INSERT INTO mri2012_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ā, ko ngā tau ēnei o te oranga o Ihimaera, kotahi rau e toru tekau mā whitu ngā tau; nā, ka hemo ia, ā, ka mate; ka kohia ki tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ā, ko ō rātou nohoanga i Hāwira ā tae noa ki Huru, i te ritenga o Īhipa ina haere koe ki Ahiria; ā, i noho ia ki te aroaro o ōna tēina katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nā, ko ngā whakatupuranga ēnei o Īhaka tama a Āperahama: nā Āperahama ko Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Nā, e whā tekau ngā tau o Īhaka i tāna tangohanga i a Ripeka, tamāhine a Petuere Hīriani o Paranārama, tuahine o Rāpana Hīriani, hei wahine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nā, ka īnoi a Īhaka ki a Ihowā mō tāna wahine, nō te mea he pākoko ia; ā, ka whakaae a Ihowā ki a ia, ā, ka hapū a Ripeka, tāna wahine. ");
INSERT INTO mri2012_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ā, ka takatakahi ngā tamariki i a rāua i roto i a ia; ā, ka mea ia, “Ki te mea ko tēnei, he aha ahau i pēnei ai?” Nā, haere ana ia ki a Ihowā ki te ui. ");
INSERT INTO mri2012_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ā, ka mea a Ihowā ki a ia, “E rua ngā iwi kei roto i tōu kōpū, ā, e rua ngā iwi e wehea mai i roto i ōu whēkau; ā, ka kaha tētahi iwi i tētahi iwi; ka waiho hoki te tuakana hei apa mō te teina.” ");
INSERT INTO mri2012_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ā, ka rite ōna rā e whānau ai ia, nā, he māhanga kei roto i tōna kōpū. ");
INSERT INTO mri2012_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Nā, ka puta mai te tuatahi, he whero, rite katoa ia ki te kākahu huruhuru; ā, huaina ana e rātou tōna ingoa ko Ēhau. ");
INSERT INTO mri2012_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ā muri iho ka puta mai tōna teina, me te pupuri anō tōna ringa i te rekereke o Ēhau; ā, huaina iho tōna ingoa ko Hākopa; ā, e ono tekau ngā tau o Īhaka i tō rāua whānautanga. ");
INSERT INTO mri2012_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nā, ka tupu ngā tamariki rā, ko Ēhau he tangata mōhio ki te hopu kīrehe mohoao, he tangata noho koraha; ko Hākopa ia he tangata āta noho, he tangata noho tēneti. ");
INSERT INTO mri2012_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Nā, i aroha a Īhaka ki a Ēhau, he kai nōna i āna i hopu ai; ko Ripeka i aroha ki a Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Nā, ka kōhuatia he kai e Hākopa, ā, ka haere mai a Ēhau i te koraha, ā, hemo ana ia. ");
INSERT INTO mri2012_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ā, ka mea a Ēhau ki a Hākopa, “E, hōmai he kai māku i taua mea whero e whero nā, nē? E hemo ana hoki ahau.” Koia i huaina ai tōna ingoa ko Ēroma. ");
INSERT INTO mri2012_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Nā, ko te meatanga mai a Hākopa, “Hokona mai ki ahau i tēnei rā tōu mātāmuatanga.” ");
INSERT INTO mri2012_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Nā, ka mea a Ēhau, “Nā, kua tata ahau te mate; ā, he aha te hua o te mātāmuatanga ki ahau?” ");
INSERT INTO mri2012_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ā, ka mea a Hākopa, “Oati mai ki ahau āianei.” Nā, ka oati ia ki a ia; ā, ka hokona atu e ia tōna mātāmuatanga ki a Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kātahi ka hoatu e Hākopa he taro ki a Ēhau me ngā pī i kōhuatia rā. Nā, ka kai ia, ka inu, ka whakatika hoki, ā, haere ana. Nā, whakahāweatia ana e Ēhau tōna mātāmuatanga. ");
INSERT INTO mri2012_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nā, ka matekai te whenua, hāunga te matekai tuatahi i puta mai i ngā rā o Āperahama. Ā, ka haere a Īhaka ki a Apīmereke, kīngi o ngā Pirihitini, ki Kerara. ");
INSERT INTO mri2012_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nā, ka puta mai a Ihowā ki a ia, ka mea, “Kaua e haere ki raro, ki Īhipa; e noho ki te whenua e kōrero ai ahau ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","E noho i tēnei whenua, ā, ka tata ahau ki a koe, ka manaaki hoki i a koe; ka hoatu nei hoki e ahau ēnei whenua katoa ki a koutou ko ōu uri, ā, ka whakapūmautia te oati i oati ai ahau ki a Āperahama, ki tōu pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ā, ka whakanuia e ahau ōu uri kia pērā me ngā whetū o te rangi, ka hoatu hoki e ahau ēnei whenua katoa ki ōu uri; ā, mā tōu uri ka manaakitia ai ngā iwi katoa o te whenua; ");
INSERT INTO mri2012_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","nō te mea i rongo a Āperahama ki tōku reo, i mau ki āku ako, ki āku whakahau, ki āku tikanga, ki āku ture.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Nā, ka noho a Īhaka i Kerara. ");
INSERT INTO mri2012_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ā, ka ui ngā tāngata o taua wāhi ki tāna wahine, ā, ka mea ia, “Ko tōku tuahine ia,” i wehi hoki ia, te mea ai, “Ko tāku wahine,” i mea hoki, “Kei patua ahau e ngā tāngata o tēnei wāhi mō Ripeka, he ātaahua hoki ia ki te titiro atu.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ā, ka maha ōna rā ki reira, ka titiro atu a Apīmereke, kīngi o ngā Pirihitini, i te matapihi, ā, ka kite, nā, ko Īhaka e tākaro ana ki a Ripeka, ki tāna wahine. ");
INSERT INTO mri2012_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nā, ka karangatia e Apīmereke a Īhaka, ka mea atu, “Koia anō, ko tāu wahine tonu ia. Nā te aha koe i mea ai, ‘Ko tāku tuahine ia’?” Ka mea a Īhaka ki a ia, “I mea hoki ahau, Kei mate ahau mōna.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Nā, ka mea a Apīmereke, “He aha tēnei mahi āu ki a mātou? Wāhi iti kua takoto tētahi o te iwi nei ki tāu wahine, ā, kua tākina mai e koe he hara ki runga ki a mātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Nā, ka whakatūpato a Apīmereke ki tōna iwi katoa, ka mea, “Ko te tangata e pā ki tēnei tangata, ki tāna wahine rānei, he pono ka mate ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ā, i rui a Īhaka ki taua whenua, ā, maea ake i taua tau anō kotahi rau. I manaakitia hoki ia e Ihowā, ");
INSERT INTO mri2012_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","nā, ka kake taua tangata, ka tino nui haere, nō ka nui noa ake ia. ");
INSERT INTO mri2012_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ā, ka whiwhi ia i ngā kāhui hipi, i ngā kāhui kau, i te tini o te pononga, ā, ka hae ngā Pirihitini ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Nā, ko ngā poka katoa i keria e ngā pononga a tōna pāpā i ngā rā o Āperahama, o tōna pāpā, i tanumia ērā e ngā Pirihitini, i whakakīia hoki ki te oneone. ");
INSERT INTO mri2012_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Nā, ka mea a Apīmereke ki a Īhaka, “Haere atu i roto i a mātou; he kaha rawa hoki koe i a mātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Nā, haere atu ana a Īhaka i reira, ā, whakatūria ana tōna puni ki te awaawa o Kerara, ā, noho ana i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Nā, ka keria anō e Īhaka ngā poka wai i keria rā i ngā rā o Āperahama, o tōna pāpā; i tanumia hoki e ngā Pirihitini i muri i te matenga o Āperahama. Ā, huaina ana e ia hei ingoa mō aua poka ko ngā ingoa i huaina iho e tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Nā, ka keri ngā pononga a Īhaka ki te awaawa, ā, ka kitea e rātou i reira he puna manawa-whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Nā, ka tautohe ngā hēpara o Kerara ki ngā hēpara a Īhaka, ka mea, “Nā mātou tēnei wai.” Ā, huaina ana e ia te ingoa o te poka ko Ēheke; mō rātou hoki i whakatetete ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nā, ka keri rātou i tētahi atu poka, ka tautohetia anō tērā e rātou; ā, huaina iho e ia tōna ingoa ko Hitina. ");
INSERT INTO mri2012_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nā, ka neke atu ia i reira, ā, ka keri i tētahi atu poka. Kīhai tērā i tautohetia e rātou; nā, ka huaina e ia tōna ingoa ko Rehopoto; i mea hoki ia, “Kātahi nei hoki a Ihowā ka whakawātea i tētahi nohoanga mō tātou, ā, ka hua tātou ki runga ki te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Nā, ka haere atu ia i reira ki runga, ki Peerehepa. ");
INSERT INTO mri2012_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ā, ka puta mai a Ihowā ki a ia i taua pō anō, ka mea, “Ko ahau te Atua o Āperahama, o tōu pāpā. Kaua e wehi, kei a koe nei hoki ahau, ā, ka manaaki ahau i a koe, ka whakanui hoki i ōu uri, he whakaaro ki a Āperahama, ki tāku pononga.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Nā, ka hangā e ia he āta ki reira, ā, ka karanga ki te ingoa o Ihowā, ā, whakatūria ana hoki e ia tōna tēneti ki reira. Ā, ka keria tētahi poka ki reira e ngā pononga a Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nā, ka haere mai a Apīmereke i Kerara ki a ia, rātou ko Ahutata ko tētahi o ōna hoa, ko Pikora hoki, ko te rangatira o tāna ope. ");
INSERT INTO mri2012_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ā, ka mea a Īhaka ki a rātou, “I haere mai koutou ki ahau ki te aha, inā hoki kua kino koutou ki ahau, kua pei hoki i ahau i roto i a koutou?” ");
INSERT INTO mri2012_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ā, ka mea rātou, “I kite mārama mātou, kei a koe a Ihowā; koia mātou i mea ai, ‘Kia takoto āianei he oati ki waenganui i a tātou, ki waenganui o mātou,’ ōu, kia whakarite kawenata hoki mātou ki a koe; ");
INSERT INTO mri2012_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kia kaua koe e tūkino i a mātou, kia pēnei me mātou kīhai nei i pā ki a koe, kīhai hoki i aha ki a koe, heoi ko te pai anake, i āta tuku anō i a koe. Ināianei ko koe te manaakitanga a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Nā, ka tukua e ia he hākari mā rātou, ā, ka kai rātou, ka inu. ");
INSERT INTO mri2012_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nā, ka maranga wawe rātou i te ata, ka oati rātou tētahi ki tētahi; ā, tukua ana rātou e Īhaka kia haere, ā, hoki mārie atu ana rātou i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ā, i taua rangi anō ka haere mai ngā pononga a Īhaka, ka kōrero ki a ia i te poka i keria e rātou, ā, ka mea ki a ia, “Kua kitea e mātou he wai.” ");
INSERT INTO mri2012_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ā, huaina iho e ia taua poka ko Hepaha. Nō konā te ingoa o tēnā pā, o Peerehepa, ā mohoa noa nei. ");
INSERT INTO mri2012_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ā, ka whā tekau ngā tau o Ēhau, ka tango ia i a Iuriti tamāhine a Peeri Hiti, hei wahine māna, rāua ko Pahemata tamāhine a Erona Hiti; ");
INSERT INTO mri2012_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ā, ka waiho rāua hei mea pōuri ki ngā ngākau o Īhaka, rāua ko Ripeka. ");
INSERT INTO mri2012_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Nā, i a Īhaka kua koroheketia, kua atarua hoki ngā kanohi, i kore ai ia e kite, ka karangatia e ia a Ēhau, tāna tama mātāmua, ka mea ki a ia, “E tāku tama!” Ā, ka mea ia ki a ia, “Tēnei ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Nā, ka mea ia, “Nanā, kua koroheke ahau, kāhore hoki ahau e mōhio ki te rā e mate ai ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nā reira mauria e koe āu rākau tāu papa pere me tāu kōpere, ka haere ki te koraha ki te hopu kai māku. ");
INSERT INTO mri2012_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ka taka ai i tētahi kai reka māku, hei tāku i pai ai, ka mau mai ai ki ahau kia kai ahau; kia manaaki ai tōku wairua i a koe i mua o tōku matenga.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ā, i rongo a Ripeka i te kōrerotanga Īhaka ki a Ēhau, ki tāna tama. Nā, ko te haerenga o Ēhau ki te koraha ki te hopu kai hei maunga mai māna. ");
INSERT INTO mri2012_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Nā, ka kōrero a Ripeka ki a Hākopa, ki tāna tama, ka mea, “Nanā, kua rongo ahau i tōu pāpā e kōrero ana ki a Ēhau, ki tōu tuakana, e mea ana, ");
INSERT INTO mri2012_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Mauria mai tētahi kai māku, ka taka ai i tētahi kai reka māku, kia kai ahau, kia manaaki ai ahau i a koe i te aroaro o Ihowā, keiwhā mate ahau.’ ");
INSERT INTO mri2012_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nā, whakarongo ki tōku reo, e tāku tama, kia rite ki tāku e whakahau nei ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Haere ināianei ki te kāhui, ka mau mai ki ahau i reira kia rua ngā kūao papai o ngā koati; ā, māku ēnā e taka hei kai reka mā tōu pāpā, hei pērā me tāna e pai ai. ");
INSERT INTO mri2012_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ā, māu e kawe ki tōu pāpā, kia kai ia, kia manaaki ai ia i a koe keiwhā mate ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Nā, ka mea a Hākopa ki a Ripeka, ki tōna whaea, “Nā, ko Ēhau, ko tōku tuakana, he tangata pūhuruhuru, ko ahau ia he kiri maheni. ");
INSERT INTO mri2012_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tērā pea tōku pāpā e whāwhā i ahau, ā, ki tāna ka rite ahau ki te tangata tinihanga; ā, he kanga te mea e riro mai i ahau, kāhore he manaaki.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nā, ko te meatanga a tōna whaea ki a ia, “Hei runga i ahau tōu kanga, e tāku tama; whakarongo mai ia ki tōku reo, haere, tīkina aua mea ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Nā, ka haere ia, ka tīkina, ka mauria mai ki tōna whaea, ā, ka takā e tōna whaea he kai reka, he pērā me tā tōna pāpā i pai ai. ");
INSERT INTO mri2012_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Nā, ka tīkina e Ripeka ngā kākahu papai o Ēhau, o tāna tama ō mua, i a ia hoki aua mea i roto i te whare; ā, whakakākahuria ana e ia ki a Hākopa, ki tāna tama ō muri. ");
INSERT INTO mri2012_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ā, ka whakapiritia e ia ngā hiako o ngā kūao koati ki ōna ringa, ki te wāhi māeneene hoki o tōna kakī. ");
INSERT INTO mri2012_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Nā, ka hoatu e ia te kai reka me te taro i hangā e ia ki te ringa o Hākopa, o tāna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Nā, ka tae ia ki tōna pāpā, ka mea, “E tōku matua!” Ā, ka mea ia, “Tēnei ahau; ko wai koe, e tāku tama?” ");
INSERT INTO mri2012_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Nā, ka mea a Hākopa ki tōna pāpā, “Ko Ēhau ahau, ko tāu mātāmua; kua oti i ahau tāu i kī mai ai ki ahau. Nā, maranga ake, e noho ki te kai i te kai i hopukia nei e ahau, kia manaaki ai tōu wairua i ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ā, ka mea a Īhaka ki tāna tama, “Nā te aha i hohoro ai te kitea e koe, e tāku tama?” Ka mea ia, “Nā Ihowā hoki, nā tōu Atua, i hōmai kia hohoro.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ā, ka mea a Īhaka ki a Hākopa, “Nuku mai nei nā, kia whāwhā ahau ki a koe, e tāku tama, ko tāku tama tonu rānei koe, ko Ēhau, kāhore rānei.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Nā, ka neke atu a Hākopa ki a Īhaka, ki tōna pāpā, ā, ka whāwhā tērā i a ia, ka mea, “Ko te reo, nō Hākopa te reo, ko ngā ringa ia, nō Ēhau ngā ringaringa.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ā, kīhai ia i mōhio ki a ia, nō te mea he huruhuru ōna ringa, i rite ki ngā ringa o Ēhau, o tōna tuakana; nā, ka manaaki ia i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ā, ka mea, “Ko tāku tama pū rānei koe, ko Ēhau?” Ā, ka mea ia, “Ko ahau tēnei.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Nā, ka mea ia, “Kawea mai kia tata ki ahau, kia kai ahau i te kai i hopukia e tāku tama, kia manaaki ai tōku wairua i a koe.” Nā, kawea atu ana e ia ki a ia, ā, ka kai ia. I mauria atu anō e ia he wāina ki a ia, ā, inu ana ia. ");
INSERT INTO mri2012_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kātahi ka mea a Īhaka, tōna pāpā, ki a ia, “Nuku mai nei, ka kihi i ahau, e tāku tama.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Nā, ka neke atu ia, ā, ka kihi ia i a ia; ā, ka hongi ia i te haunga o ōna kākahu, ka manaaki i a ia, ka mea, “Titiro hoki, rite tahi te haunga o tāku tama ki te haunga o te pārae i manaakitia e Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kia hōmai anō e te Atua ki a koe te tōmairangi o te rangi, me te mōmonatanga o te whenua, kia nui anō hoki te wīti me te wāina! ");
INSERT INTO mri2012_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kia mahi ngā iwi ki a koe, kia piko iho hoki ngā tauiwi ki a koe. Kia waiho koe hei rangatira mō ōu tēina, ā, kia piko iho ki a koe ngā tama a tōu whaea. Kia kangā te tangata e kanga ana i a koe, ā, kia manaakitia te tangata e manaaki ana i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ā, mutu ana te manaaki a Īhaka i a Hākopa, puta kau atu anō a Hākopa i te aroaro o Īhaka, o tōna pāpā, nā, ka tae mai a Ēhau, tōna tuakana, i tāna hopu kīrehe mohoao. ");
INSERT INTO mri2012_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kua oti anō hoki i a ia tētahi kai reka te taka, ā, kawea ana ki tōna pāpā, nā, ka mea ki tōna pāpā, “Kia ara ake tōku pāpā ki te kai i te mea i hopukia mai e tāna tama, kia manaaki ai tōu wairua i ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nā, ka mea a Īhaka, tōna pāpā, ki a ia, “Ko wai koe?” Ā, ka mea ia, “Ko tāu tama ahau, ko Ēhau, ko tāu mātāmua.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nā, tino wiri rawa ana a Īhaka, ā, ka mea, “Ha, ko wai rā tēnei i hopukia nei e ia he kai, ā, kawea ana mai ki ahau, ā, kainga katoatia ana e ahau i te mea kāhore anō koe i tae mai, ā, manaakitia ana ia e ahau? Āe rā, ka manaakitia anō ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ā, i te rongonga o Ēhau i ngā kupu a tōna pāpā, ka tangi ia, he tangi nui, he tangi tīwerawera, ā, ka mea ki tōna pāpā, “Manaakitia ahau, āe rā, ahau anō hoki, e tōku pāpā.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ā, ka mea ia, “I haere tinihanga mai tōu teina, ā, riro ana tōu manaaki i a ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Nā, ka mea ia, “Ka tika ha te tapanga i a ia ko Hākopa? Kua rua nei hoki ōku māmingatanga e ia. Ko tōku mātāmuatanga kua riro i a ia; ā, ināianei kua riro tōku manaaki i a ia.” Ka mea anō ia, “Kāhore rānei i mahue atu ki a koe tētahi manaaki mōku?” ");
INSERT INTO mri2012_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Nā, ka whakahoki a Īhaka, ka mea ki a Ēhau, “Nā, kua waiho ia e ahau hei rangatira mōu, kua hoatu hoki ōna tuākana katoa ki a ia hei apa; kua whakaūkia hoki ia e ahau ki te wīti, ki te wāina. Ā, he aha rā māu hei meatanga māku, e tāku tama?” ");
INSERT INTO mri2012_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Nā, ka mea a Ēhau ki tōna pāpā, “Kotahi tonu ia tāu manaaki, e tōku pāpā? Manaakitia ahau, āe rā, ahau anō hoki, e tōku pāpā.” Nā, nui atu te reo o Ēhau ki te tangi. ");
INSERT INTO mri2012_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nā, ka whakahoki a Īhaka, tōna pāpā, ka mea ki a ia: “Nā, nō te mōmonatanga o te whenua te nohoanga mōu, nō te tōmairangi hoki o te rangi i runga. ");
INSERT INTO mri2012_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mā tāu hoari hoki e ora ai koe, me mahi anō koe ki tōu teina; ā, tēnei ake, kei tōu kakenga hei rangatira, nā, ka wāhia atu e koe tāna ioka i tōu kakī.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Nā, ka mauāhara a Ēhau ki a Hākopa mō te manaaki i manaakitia ai ia e tōna pāpā, ā, ka mea a Ēhau i roto i tōna ngākau, “E tata ana ngā rā e uhungatia ai tōku pāpā; ko reira ahau patu ai i tōku teina, i a Hākopa.” ");
INSERT INTO mri2012_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Nā, ka kōrerotia ki a Ripeka ngā kupu a Ēhau, a tāna tama ō mua. Ā, ka tono tangata ia ki te karanga i a Hākopa, i tāna tama ō muri, ka mea ki a ia, “Nā, tēnei tōu tuakana, a Ēhau, mō te wāhi ki a koe, te whakamārie nei i a ia, te mea nei ki te patu i a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nō konei, e tāku tama, whakarongo ki tōku reo; whakatika, e rere ki a Rāpana, ki tōku tungāne, ki Harana, ");
INSERT INTO mri2012_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","hei a ia koe noho ai mō ētahi rangi, kia tahuri atu rā anō te āritarita o tōu tuakana – ");
INSERT INTO mri2012_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","kia tahuri kē atu rā anō i a koe te riri a tōu tuakana, kia wareware hoki i a ia tāu i mea ai ki a ia. Kātahi ahau ka tono tangata ki te tiki atu i a koe i reira. He aha kia tangohia atu ai kōrua tokorua i ahau i te rangi kotahi?” ");
INSERT INTO mri2012_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Nā, ka mea a Ripeka ki a Īhaka, “Kei te hōhā ahau ki te ora i ngā tamāhine a Hete. Ki te tango a Hākopa i tētahi wahine māna i roto i ngā tamāhine a Hete, i tētahi e pēnei ana me ēnei tamāhine o te whenua nei, hei aha ake mōku te ora?” ");
INSERT INTO mri2012_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Nā, ka karanga a Īhaka i a Hākopa, ka manaaki i a ia, ka tohutohu ki a ia, ā, ka mea ki a ia: “Kaua koe e tango wahine o ngā tamāhine o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Whakatika, haere ki Paranārama ki te whare o Petuere, pāpā o tōu whaea; ka tango mai i reira i tētahi wahine māu o ngā tamāhine a Rāpana, tungāne o tōu whaea. ");
INSERT INTO mri2012_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ā, mā te Atua Kaha Rawa koe e manaaki, māna koe e mea kia hua, kia nui, kia meinga hoki hei huihuinga iwi. ");
INSERT INTO mri2012_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Māna e hōmai ki a koe te manaaki o Āperahama, ki a koutou tahi ko ōu uri; kia riro ai i a koe te whenua e noho manene nei koe, i hōmai nei hoki e te Atua ki a Āperahama.” ");
INSERT INTO mri2012_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Nā, tonoa atu ana a Hākopa e Īhaka; ā, haere ana ia ki Paranārama ki a Rāpana, ki te tama a Petuere Hīriani, ki te tungāne o Ripeka, whaea o Hākopa rāua ko Ēhau. ");
INSERT INTO mri2012_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ā, ka kite a Ēhau kua manaaki a Īhaka i a Hākopa, kua tono hoki i a ia ki Paranārama ki te tiki wahine māna i reira; kua tohutohu hoki ki a ia, i a ia e manaaki ana i a ia, kua mea, “Kei tangohia e koe he wahine i ngā tamāhine o Kanaana,” ");
INSERT INTO mri2012_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ā, kua rongo a Hākopa ki tōna pāpā rāua ko tōna whaea, kua riro hoki ki Paranārama. ");
INSERT INTO mri2012_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ā, ka kite a Ēhau e kino ana ngā tamāhine o Kanaana ki te titiro a Īhaka, a tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Nā, haere ana a Ēhau ki a Ihimaera, ā, tangohia ana mai e ia ki roto ki āna wāhine a Maharata, te tamāhine a Ihimaera, tama a Āperahama, te tuahine o Nepaioto, hei wahine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Nā, ka tūria atu e Hākopa i Peerehepa, ā, haere ana ki Harana. ");
INSERT INTO mri2012_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ā, ka pono atu ia ki tētahi wāhi, ka moe i reira, kua tō hoki te rā. Nā, ka tīkina atu e ia tētahi o ngā kōhatu o taua wāhi, ā, meatia ana e ia hei urunga mōna, ka takoto ia i taua wāhi, ka moe. ");
INSERT INTO mri2012_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nā, moe iho ia, ko tētahi arawhata e tū ana i runga i te whenua, ko tōna pito i tutuki ki te rangi; nā, ko ngā anahera a te Atua e piki ana, e heke ana i runga i taua mea. ");
INSERT INTO mri2012_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nā, ko Ihowā e tū ana i runga atu i taua mea, e mea ana, “Ko Ihowā ahau, ko te Atua o Āperahama, o tōu pāpā, ko te Atua hoki o Īhaka; ko te whenua e takoto nā koe ka hoatu e ahau ki a koe, ki ōu uri anō hoki; ");
INSERT INTO mri2012_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ā, ka rite ōu uri ki te puehu o te oneone, ka tohatoha atu koe ki te hauāuru, ki te rāwhiti, ki te raki, ki te tonga; ā, māu, mā tōu uri hoki e manaakitia ai ngā hapū katoa o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nā, kei a koe tēnei ahau, ka tiaki ahau i a koe i ngā wāhi katoa e haere ai koe, ka whakahoki mai anō ahau i a koe ki tēnei whenua; e kore hoki ahau e whakarere i a koe, kia oti rā anō tāku i kī atu ai ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Nā, ka oho ake a Hākopa i tāna moe, ka mea, “He pono kei tēnei wāhi a Ihowā – ā, kīhai ahau i mōhio.” ");
INSERT INTO mri2012_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nā, ka wehi ia, ka mea, “Anō te wehi o tēnei wāhi! Ehara tēnei i te mea kē atu i te whare o te Atua, ā, ko te kūwaha tēnei ki te rangi.” ");
INSERT INTO mri2012_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nā, ka ara wawe a Hākopa i te ata, ā, ka mau ki te kōhatu i waiho rā hei urunga mōna, whakatūria ana e ia hei pou, ringihia iho e ia he hinu ki runga. ");
INSERT INTO mri2012_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ā, huaina iho e ia te ingoa o taua wāhi ko Pētēre; ko Rutu ia te ingoa o taua pā i mua. ");
INSERT INTO mri2012_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nā, ka puaki tā Hākopa kupu taurangi, ka mea ia, “Ki te mea ka tata mai ki ahau te Atua, ā, ka tiakina ahau e ia i tēnei ara e haere nei ahau, ā, ka hōmai e ia ki ahau he taro hei kai, me tētahi kākahu hei kākahu, ");
INSERT INTO mri2012_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ā, ka hoki mai ahau i runga i te rangimārie ki te whare o tōku pāpā; nā, ko Ihowā hei Atua ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ā, ko tēnei kōhatu i whakatūria nei e ahau hei pou, ka waiho hei whare mō te Atua; ā, o ngā mea katoa e hōmai e koe ki ahau, ka hoatu e ahau ki a koe ngā whakatekau.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Nā, ka tūria atu e Hākopa, ka haere ki te whenua o ngā tāngata o te rāwhiti. ");
INSERT INTO mri2012_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Nā, ka titiro atu ia, ā, ka kite i tētahi poka i te pārae; nā, ko ētahi kāhui hipi e toru e takoto ana i te taha; i whakainumia hoki e rātou ngā kāhui ki te wai o taua poka. He nui hoki te kōhatu i te waha o te poka. ");
INSERT INTO mri2012_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","I huihuia hoki ki reira ngā kāhui katoa; ā, whakatakā atu ana e rātou te kōhatu i te waha o te poka, kia whakainumia ai ngā hipi, nā, ka whakahokia anō e rātou te kōhatu ki te waha o te poka, ki tōna wāhi. ");
INSERT INTO mri2012_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Nā, ka mea a Hākopa ki a rātou, “E ōku tuākana, nō hea koutou?” Ā, ka mea rātou, “Nō Harana mātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Nā, ka mea ia ki a rātou, “E mōhio ana ianei koutou ki a Rāpana, tama a Nahora?” Ka mea rātou, “E mōhio ana anō mātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ā, ka mea ia ki a rātou, “E ora ana rānei ia?” Ka mea rātou, “E ora ana anō. Ko Rahera anō tēnei, ko tāna tamāhine, te haere mai nei me ngā hipi.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Nā, ka mea ia, “Nanā, he nui anō te rā, ehara tēnei i te wā hei huihuinga mai mō ngā kararehe. Whakainumia ngā hipi, haere hoki ki te whāngai.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nā, ka mea rātou, “E kore e taea e mātou, kia huihuia mai rā anō ngā kāhui katoa, kia whakatakā hoki e rātou te kōhatu i te waha o te poka; kātahi ka whakainu mātou i ngā hipi.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","I a ia anō e kōrero ana ki a rātou, ka puta mai a Rahera me ngā hipi a tōna pāpā; ko ia hoki te kaiwhāngai. ");
INSERT INTO mri2012_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ā, nō te kitenga o Hākopa i a Rahera tamāhine a Rāpana, tungāne o tōna whaea, me ngā hipi hoki a Rāpana, tungāne o tōna whaea, nā, ka haere a Hākopa, ā, whakatakā atu ana e ia te kōhatu i te waha o te poka, whakainumia ana e ia ngā hipi a Rāpana, tungāne o tōna whaea. ");
INSERT INTO mri2012_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Nā, ka kihi a Hākopa i a Rahera, ā, nui atu tōna reo ki te tangi. ");
INSERT INTO mri2012_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Nā, ka whakaaturia e Hākopa ki a Rahera ko ia te irāmutu o tōna pāpā, he tama hoki nā Ripeka, ā, ka rere ia ki te kōrero ki tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nā, i te taenga atu ki a Rāpana o te rongo o Hākopa, tama a tōna tuahine, ka rere ia ki te whakatau i a ia, ka awhi i a ia, ka kihi hoki i a ia, ā, kawea ana ki tōna whare. Ā, ka kōrerotia e ia ēnei mea katoa ki a Rāpana. ");
INSERT INTO mri2012_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Nā, ka mea a Rāpana ki a ia, “He pono ko tōku wheua, ko tōku kikokiko koe.” Ā, kotahi te marama i noho ai ia ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Nā, ka mea a Rāpana ki a Hākopa, “Nō te mea ko tāku irāmutu koe, me mahi noa anō koe ki ahau? Kōrero mai ki ahau, me aha he utu mōu?” ");
INSERT INTO mri2012_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Nā, tokorua ngā tamāhine a Rāpana; ko te ingoa o te tuakana ko Rea, ko te ingoa hoki o te teina ko Rahera. ");
INSERT INTO mri2012_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","He papahewa ngā kanohi o Rea; he mea āhuareka ia a Rahera, he ātaahua hoki ki te titiro atu. ");
INSERT INTO mri2012_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Nā, i aroha a Hākopa ki a Rahera; ā, ka mea ia, “Kia whitu ngā tau e mahi ai ahau ki a koe mō Rahera, mō tāu tamāhine ō muri.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Nā, ka mea a Rāpana, “Engari te hoatu e ahau ki a koe, kei hoatu ki te tangata kē; e noho ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Nā, e whitu ngā tau i mahi ai a Hākopa mō Rahera; ā, he rangi torutoru noa ake te rite o aua tau ki tōna whakaaro, i tōna aroha ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Nā, ka mea a Hākopa ki a Rāpana, “Hōmai tāku wahine, kua rite nei hoki ōku rā, kia haere ahau ki roto, ki a ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Nā, ka huihuia mai e Rāpana ngā tāngata katoa o taua wāhi, ā, tukua ana e ia he hākari. ");
INSERT INTO mri2012_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ā, i te ahiahi ka mau ia ki a Rea ki tāna tamāhine, ā, kawea ana ia ki a ia; ā, ka haere ia ki roto, ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ā, i hoatu e Rāpana a Tiripa, tāna pononga wahine, hei pononga mā Rea, mā tāna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ā, i te ata, nā, ko Rea ia; ā, ka mea ia ki a Rāpana, “He aha tēnei mahi āu ki ahau? Ehara ianei a Rahera i tāku i mahi ai ahau ki a koe? He aha rā koe i tinihanga, ai ki ahau?” ");
INSERT INTO mri2012_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Nā, ko te meatanga a Rāpana, “Ehara tēnei i te tikanga o tō mātou whenua, kia hoatu te teina ki mua o te tuakana. ");
INSERT INTO mri2012_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Whakatutukitia te wiki mō tēnei, ā, ka hoatu anō hoki tērā e mātou ki a koe mō te mahi e mahi ai koe ki ahau i ētahi atu tau e whitu.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ā, pērā ana a Hākopa, ā, whakatutukitia ana e ia te wiki mō tēnei; ā, ka hōmai e ia a Rahera, tāna tamāhine, ki a ia hei wahine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","I hōmai anō e Rāpana a Piriha, tāna pononga wahine, ki a Rahera, ki tāna tamāhine, hei pononga māna. ");
INSERT INTO mri2012_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Nā, ka haere anō hoki ia ki roto, ki a Rahera, ā, nui atu tōna aroha ki a Rahera i tōna ki a Rea; e whitu atu anō ngā tau i mahi ai ia ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ā, ka kite a Ihowā e kinongia ana a Rea, ka whakatuwheratia e ia tōna kōpū; he pākoko ia a Rahera. ");
INSERT INTO mri2012_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nā, ka hapū a Rea, ā, ka whānau he tama, ā, huaina ana e ia tōna ingoa ko Reupena; i mea hoki ia, “Mō Ihowā hoki i titiro mai ki tōku tangihanga; tā te mea hoki ākuanei tāku tahu aroha ai ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nā, ka hapū anō ia, ā, ka whānau he tama; ā, ka mea ia, “I rongo hoki a Ihowā e kinongia ana ahau, koia i hōmai ai hoki e ia tēnei ki ahau.” Ā, huaina ana e ia tōna ingoa ko Himiona. ");
INSERT INTO mri2012_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nā, ka hapū anō ia, ā, ka whānau he tama; ā, ka mea ia, “Kātahi anō tāku tahu ka piri mai ki ahau, nō te mea hoki ka tokotoru ā māua tama ka whānau”; nā reira i huaina ai e ia tōna ingoa ko Rīwai. ");
INSERT INTO mri2012_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nā, ka hapū anō ia, ā, ka whānau he tama; ā, ka mea ia, “Kātahi ahau ka whakamoemiti ki a Ihowā”; koia i huaina ai e ia tōna ingoa ko Hūrā; ā, ka mutu tāna whānau. ");
INSERT INTO mri2012_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ā, nō te kitenga o Rahera kāhore i whānau tētahi tama mā rāua ko Hākopa, ka hae a Rahera ki tōna tuakana; ā, ka mea ia ki a Hākopa, “Kia whai tamariki ahau, ki te kāhore, ka mate ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Nā, ka mura ake te riri a Hākopa ki a Rahera; ka mea ia, “Ko te Atua rānei ahau e kaiponu atu nei i te hua mō tōu kōpū?” ");
INSERT INTO mri2012_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ā, ka mea tērā, “Nā, tāku pononga wahine, a Piriha, haere ki roto, ki a ia; kia whānau ai ia ki runga ki ōku turi, ā, māna ka whai tamariki ai ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Nā, ka hōmai e ia a Piriha, tāna pononga wahine, ki a ia hei wahine, ā, ka haere atu a Hākopa ki roto, ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Nā, ka hapū a Piriha, ā, ka whānau tā rāua tama ko Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Nā, ka mea a Rahera, “Kua whakarite te Atua i tāku whakawākanga, kua rongo anō ki tōku reo, kua hōmai hoki e ia tētahi tama ki ahau.” Nā reira i huaina ai e ia tōna ingoa ko Rāna. ");
INSERT INTO mri2012_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nā, ka hapū anō a Piriha, te pononga wahine a Rahera, ā, ka whānau te rua o ā rāua tama ko Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nā, ka mea a Rahera, “Nui whakaharahara ngā nōnoketanga i nōnoke ai māua ko tōku tuakana, ā, taea ana ia e ahau.” Nā, huaina iho e ia tōna ingoa ko Napatari. ");
INSERT INTO mri2012_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","I te kitenga o Rea ka mutu ia te whānau, ka tango ia i a Tiripa, i tāna pononga wahine, ā, hoatu ana e ia ki a Hākopa hei wahine. ");
INSERT INTO mri2012_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nā, ka whānau te tama a Hākopa rāua ko Tiripa, pononga a Rea. ");
INSERT INTO mri2012_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ā, ka mea a Rea, “He waimarie!” Nā, huaina ana e ia tōna ingoa ko Kara. ");
INSERT INTO mri2012_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nā, ka whānau te rua o ngā tama a Hākopa rāua ko Tiripa, pononga a Rea. ");
INSERT INTO mri2012_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ā, ka mea a Rea, “E hari ana ahau, ka kīia nei hoki ahau e ngā tamāhine he mea hari”; ā, huaina ana e ia tōna ingoa ko Āhera. ");
INSERT INTO mri2012_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Nā, ka haere a Reupena i ngā rā o te kotinga wīti, ā, ka kite i ētahi manitareki i te koraha, ā, kawea ana e ia ki a Rea, ki tōna whaea. Ā, ka mea atu a Rahera ki a Rea, “Tēnā koa māku ētahi o ngā manitareki a tāu tama.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nā, ko te meatanga a tērā ki a ia, “He mea nohinohi ianei tāu tangohanga i tāku tahu? Ā, me tango anō koe i ngā manitareki a tāku tama?” Ā, ka mea atu a Rahera, “Nā, me takoto ia ki a koe i tēnei pō hei utu mō ngā manitareki a tāu tama.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ā, i te ahiahi ka haere mai a Hākopa i te māra, nā, ka puta atu a Rea ki te whakatau i a ia, ka mea, “Me haere mai koe ki ahau; kua oti hoki koe te hoko e ahau ki ngā manitareki a tāku tama.” Nā, ka takoto ia ki a ia i taua pō. ");
INSERT INTO mri2012_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","I whakarongo hoki te Atua ki a Rea, ā, ka hapū ia, ā, ka whānau te tokorima o ā rāua tama ko Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nā, ka mea a Rea, “Kua hōmai e te Atua tōku utu, mōku i hoatu i tāku pononga ki tāku tahu”; ā, huaina ana e ia tōna ingoa ko Ihākara. ");
INSERT INTO mri2012_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nā, ka hapū anō a Rea, ā, ka whānau te tokoono o ā rāua tama ko Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Nā, ka mea a Rea, “He pai te hākari i hōmai nei e te Atua ki ahau; kātahi tāku tahu ka noho ki ahau, mō te whānautanga o ā māua tama tokoono”; ā, huaina ana e ia tōna ingoa ko Hepurona. ");
INSERT INTO mri2012_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ā muri iho ka whānau he kōtiro, ā, huaina ana e ia tōna ingoa ko Rina. ");
INSERT INTO mri2012_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ā, i mahara te Atua ki a Rahera, i whakarongo hoki te Atua ki a ia, ā, whakatuwheratia ana e ia tōna kōpū. ");
INSERT INTO mri2012_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nā, ka hapū ia, ā, ka whānau he tama. Ā, ka mea ia, “Kua whakamutua e te Atua tōku tāwainga.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nā, huaina ana e ia tōna ingoa ko Hōhepa; ā, ka mea, “Ka tāpiritia mai e Ihowā tētahi atu tama māku.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Nā, ka whānau rā a Hōhepa i a Rahera, ka mea a Hākopa ki a Rāpana, “Tukua ahau, kia haere ai ahau ki tōku ake wāhi, ki tōku whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Hōmai āku wāhine me āku tamariki i mahi ai ahau ki a koe, ā, ka haere ahau. E mōhio ana hoki koe ki tāku mahi i mahi ai ahau ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Nā, ka mea a Rāpana ki a ia, “Ki te mea e manakohia ana ahau e koe, e noho; kua kite hoki ahau nāu i manaakitia ai ahau e Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","I mea anō ia, “Whakaritea ki ahau te utu mōu, ā ka hoatu e ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ā, ka mea ia ki a ia, “E mōhio ana koe ki tāku mahinga ki a koe, ki āu kararehe hoki i ahau, tō rātou pēheatanga. ");
INSERT INTO mri2012_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","I mua atu hoki i ahau he iti āu mea, nā, kua nui noa atu tēnei; ā, kua manaakitia koe e Ihowā ahakoa tahuri ahau ki hea, ki hea. Nā, ināianei āhea rānei ahau mea ai hoki i tētahi mea mō tōku ake whare?” ");
INSERT INTO mri2012_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ā, ka mea tērā, “Ko te aha tāku e hoatu ai ki a koe?” Ā, ka mea a Hākopa, “Kaua e hōmai tētahi mea ki ahau. Ki te meatia mai e koe tēnei mea āku, ka whāngai anō ahau, ka tiaki i āu hipi. ");
INSERT INTO mri2012_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ka tika ahau nā waenganui i tāu kāhui katoa ākuanei, ā, ka wehea i reira ngā mea whai tongitongi katoa, ngā mea purepure, me ngā mea pākākā katoa i roto i ngā hipi, me ngā purepure, me ngā mea whai tongitongi i roto i ngā koati; ā, ko ērā hei utu mōku. ");
INSERT INTO mri2012_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Pēnei ka whakatikaia ahau e tōku tika āpōpō ake nei, ina tae atu ki tōu aroaro ki te utu mōku. Ko ngā mea i roto i ngā koati kāhore nei he tongitongi, kāhore he purepure, me ngā mea kāhore e pākākā i roto i ngā hipi, he mea tāhae tēnā nāku.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Nā, ka mea a Rāpana, “Āe, pai tonu kia pēnā me tāu i kī mai nā.” ");
INSERT INTO mri2012_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nā, ka wehea e ia i taua rangi ngā koati toa, ngā mea whakahekeheke, me ngā mea purepure, me ngā koati uha e whai tongitongi ana, me ngā mea purepure, ngā mea he mā tētahi wāhi, me ngā mea pākākā o ngā hipi, ā, hoatu ana ki ngā ringa o āna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nā, ka whakatakiwātia e ia he takiwā i waenganui i a ia, i a Hākopa, kia toru ngā rā e haerea ai; ā, ka whāngai a Hākopa i ngā hipi a Rāpana i mahue iho. ");
INSERT INTO mri2012_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kātahi ka tīkina e Hākopa ētahi rākau māna, he pāpara mata, he aramona, he pereni; ā, tīhorea ana e ia ētahi tīhorenga mā i aua mea, ā, ka meinga kia āta kitea te wāhi mā o ngā rākau. ");
INSERT INTO mri2012_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ā, i whakatūria e ia aua rākau i tīhorea rā ki roto ki ngā hake, ki roto ki ngā waka wai, kia taurite mai ki ngā hipi, ina haere ngā hipi ki te inu; i whakahapūtia hoki i te haerenga ki te inu. ");
INSERT INTO mri2012_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Nā, ka whakahapūtia ngā kāhui ki mua i ngā rākau, ā, he whakahekeheke, he mea tongitongi, he purepure ngā kūao i whānau. ");
INSERT INTO mri2012_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Nā, ka wehea atu ngā reme e Hākopa, ā, whakaangahia ana e ia ngā kanohi o ngā kāhui ki ngā mea whakahekeheke, ki ngā mea pākākā katoa i roto i te kāhui a Rāpana. Nā, ko āna ake kāhui i wehea e ia ki te whanga, kīhai hoki i tukua ki roto ki te kāhui a Rāpana. ");
INSERT INTO mri2012_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nā, i ngā wā katoa e whakahapūtia ai ngā mea kaha o te kāhui ka whakatūria e Hākopa ngā rākau ki te tirohanga a te kāhui, ki roto ki ngā hake, kia whakahapūtia ai rātou ki waenga i ngā rākau; ");
INSERT INTO mri2012_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ā, ki te mea he ngoikore te kāhui, kīhai i whakatūria e ia. Nā, i a Rāpana ngā mea ngoikore, ā, i a Hākopa ngā mea kaha. ");
INSERT INTO mri2012_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nā, ka tino nui haere rawa taua tangata, ā, ka whai kāhui nunui anō ia, me ngā pononga wāhine, me ngā pononga tāne, me ngā kāmera, me ngā kāihe. ");
INSERT INTO mri2012_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ā, i rongo ia i ngā kupu a ngā tama a Rāpana, e kī ana, “Kua riro i a Hākopa ngā mea katoa a tō tātou pāpā; nā ngā mea hoki a tō tātou pāpā i whiwhi ai ia ki tēnei korōria katoa.” ");
INSERT INTO mri2012_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ā, ka titiro a Hākopa ki te mata o Rāpana, nā, kīhai i pērā ki a ia me tō ērā rangi ake. ");
INSERT INTO mri2012_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ā, ka mea a Ihowā ki a Hākopa, “E hoki ki te whenua o ōu mātua, ki ōu whanaunga hoki; ā, ka tata ahau ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nā, ka tono tangata a Hākopa hei karanga i a Rahera rāua ko Rea ki tāna kāhui, ki te pārae, ");
INSERT INTO mri2012_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ā, ka mea ia ki a rāua, “E kite ana ahau i te mata o tō kōrua pāpā, kāhore e pērā mai ki ahau me tō ērā rangi ake; otiia i tata mai ki ahau te Atua o tōku pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","E mōhio ana anō kōrua, i poto katoa atu tōku kaha ki tāku mahi ki tō kōrua pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ko tō kōrua pāpā ia i tinihanga ki ahau, ka tekau rawa āna whakaputanga kētanga i ōku utu; otiia kīhai ia i tukua e te Atua kia tūkino i ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mehemea i kōrero pēnei ia, ‘Hei ngā mea whai tongitongi te utu mōu,’ nā, he mea tongitongi katoa ngā whānau o ngā kāhui, ā, mehemea ia i kī pēnei, ‘Hei ngā mea whakahekeheke he utu mōu,’ nā, he whakahekeheke katoa ngā whānau o ngā kāhui. ");
INSERT INTO mri2012_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Koia i tangohia ai e Ihowā ngā hipi a tō kōrua pāpā, ā, hōmai ana ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Nā, i te wā i whakahapūtia ai te kāhui, ka maranga ake ōku kanohi, ā, ka kite moemoeā ahau, ko ngā toa i ekengia ai ngā kāhui, he whakahekeheke, he mea whai tongitongi, he mea kōtingotingo. ");
INSERT INTO mri2012_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","I kōrero moemoeā mai anō te anahera a te Atua ki ahau, ‘E Hākopa,’ ā, ka mea atu ahau, ‘Tēnei ahau.’ ");
INSERT INTO mri2012_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Nā, ka mea mai ia, ‘Tēnā, whakaarahia ake ōu kanohi, ka titiro ki ngā toa katoa e ekeeke ana i ngā kāhui, he whakahekeheke, he whai tongitongi, he kōtingotingo hoki; kua kite hoki ahau i ngā mea katoa i mea nei a Rāpana ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ko ahau te Atua o Pētēre, o te wāhi i whakawahi nā koe i te pou, i puaki ai hoki tāu kupu taurangi ki ahau. Kāti, whakatika, haere atu i tēnei whenua, hoki atu ki te whenua i whānau ai koe.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Nā, ka whakahoki a Rahera rāua ko Rea, ka mea ki a ia, “Tērā atu anō ianei tētahi wāhi, tētahi taonga tupu rānei mō māua i roto i te whare o tō māua pāpā? ");
INSERT INTO mri2012_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Kāhore ianei māua i te kīia e ia he wāhine kē noa atu? Kua hokona nei hoki māua e ia, kua pau rawa anō i a ia ā māua moni. ");
INSERT INTO mri2012_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mō tātou nei hoki, mō ā tātou tamariki ngā taonga katoa i tangohia nei e te Atua i tō māua pāpā. Nā, tēnā, meatia ngā mea katoa i kīia e te Atua ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Nā, ka whakatika a Hākopa, ā, whakaekea ana e ia āna tamariki me āna wāhine ki runga ki ngā kāmera; ");
INSERT INTO mri2012_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ā, kāwhakina atu ana e ia āna kararehe katoa, me ōna taonga katoa i whiwhi ai ia, ngā kararehe i whiwhi ai ia, i riro hoki i a ia i Paranārama, ā, haere ana ki a Īhaka, ki tōna pāpā, ki te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Nā, ko Rāpana kua riro ki te kutikuti i āna hipi; kātahi ka tāhaetia e Rahera ngā whakapakoko a tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nā, tahuti ana a Hākopa i a Rāpana Hīriani, kīhai hoki i whakaaturia tōna omanga ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nā, ka oma ia, me āna mea katoa; i whakatika ia, ka whiti i te awa, i ahu hoki tōna mata ki te maunga, ki Kireara. ");
INSERT INTO mri2012_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ā, i te toru o ngā rā ka kōrerotia ki a Rāpana, kua oma a Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Nā, ka tango ia i ōna tēina hei hoa mōna, ā, ka whai i a ia, e whitu ngā rā ki te ara; ā, mau atu ia i a ia ki Maunga Kireara. ");
INSERT INTO mri2012_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Nā, ka puta moemoeā te Atua ki a Rāpana Hīriani i te pō, ka mea ki a ia, “Kia tūpato kei kōrero koe ki a Hākopa, ahakoa pai, ahakoa kino.” ");
INSERT INTO mri2012_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Nā, ka mau a Hākopa i a Rāpana. Nā tērā kua whakatūria e Hākopa tōna tēneti ki te maunga. Heoi, whakatūria ana hoki e Rāpana rātou ko ōna tēina ki Maunga Kireara. ");
INSERT INTO mri2012_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Nā, ka mea a Rāpana ki a Hākopa, “He mahi aha tāu, i tahuti mai nei koe i ahau, i kāhaki mai nei hoki i āku tamāhine, ānō he pārau nā te hoari? ");
INSERT INTO mri2012_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","He aha i hunā ai e koe tōu omanga, i tahuti mai ai i ahau? Ā, kīhai i kōrero mai ki ahau, kia tukua ai koe e ahau i runga i te hari, i ngā waiata, i te timipera, i te hāpa. ");
INSERT INTO mri2012_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kīhai anō ahau i tukua e koe kia kihi i āku tama, i āku tamāhine? He mahi pōauau tēnei mahi āu. ");
INSERT INTO mri2012_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","He kaha kei tōku ringa hei whakatupu kino i a koutou; otiia kua kōrero mai te Atua o tō koutou pāpā ki ahau inapō, kua mea mai, ‘Kia tūpato kei kōrero atu koe, ahakoa pai, ahakoa kino, ki a Hākopa.’ ");
INSERT INTO mri2012_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nā, ahakoa i whakamatea e koe tōu haere, nō te mea i koroa e koe te whare o tōu pāpā, he aha rā koe i tāhae ai i ōku atua?” ");
INSERT INTO mri2012_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Nā, ka whakahoki a Hākopa, ka mea ki a Rāpana, “Nō te mea hoki i wehi ahau; i mea hoki ahau, ‘Kei tangohia e koe āu tamāhine i ahau.’ ");
INSERT INTO mri2012_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ko te tangata e kitea e koe ōu atua i a ia, kaua ia e whakaorangia; tirohia iho e koe i te aroaro o ō tāua tēina ko ēhea mea āu kei ahau, ka tango atu ai māu.” Kīhai hoki a Hākopa i mōhio, kua tāhaetia aua mea e Rahera. ");
INSERT INTO mri2012_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Nā, ka haere a Rāpana ki te tēneti o Hākopa, ki te tēneti hoki o Rea, ki te tēneti anō hoki o ngā pononga wāhine tokorua; ā, kīhai i kitea. Ā, ka puta atu ia i te tēneti o Rea, ā, ka tomo atu ki te tēneti o Rahera. ");
INSERT INTO mri2012_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Nā, tērā kua tīkina ngā whakapakoko e Rahera, kua whaongia ki roto ki te nohoanga kāmera, ā, nohoia iho e ia. Nā, poto katoa te tēneti te whāwhā e Rāpana, ā, kīhai i kitea. ");
INSERT INTO mri2012_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Nā, ka mea ia ki tōna pāpā, “Kei riri mai tōku ariki mōku e kore e āhei te whakatika ake ki tōu aroaro; nō te mea ko tō te wāhine mate tēnei kei ahau.” Nā, rapu noa ia, kīhai i kitea ngā whakapakoko. ");
INSERT INTO mri2012_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Nā, ka riri a Hākopa, ka ngangare ki a Rāpana; ā, ka oho a Hākopa, ka mea ki a Rāpana, “He aha tōku hara? He aha tōku hē, i tākare ai koe ki te whai mai i ahau? ");
INSERT INTO mri2012_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kua whāwhākia nei e koe āku mea katoa, he aha te mea i kitea e koe o ngā mea katoa o tōu whare? Hōmai ki konei ki te aroaro o ōku tēina, o ōu tēina, mā rātou e whakariterite tā tāua whakawā. ");
INSERT INTO mri2012_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ka rua tekau ēnei tau ōku ki a koe; kīhai i whānau whakatahe āu hipi, āu koati, kīhai anō i kainga e ahau ngā hipi toa o tāu kāhui. ");
INSERT INTO mri2012_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ko te mea i haea e ngā kīrehe mohoao kīhai i kawea e ahau ki a koe; nāku anō tēnā i whakautu; i rapu utu anō koe mō tēnā i tōku ringa, ahakoa mō te mea i tāhaetia i te awatea, mō te mea rānei i tāhaetia i te pō. ");
INSERT INTO mri2012_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ko tāku hanga tēnā: i te awatea i pau ahau i te matewai, i te pō i te huka; ā, tūrere ana te moe i ōku kanohi. ");
INSERT INTO mri2012_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","“Ka rua tekau ēnei tau ōku ki tōu whare; kotahi tekau mā whā ngā tau i mahi ai ahau ki a koe mō āu tamāhine tokorua, e ono tau hoki mō āu hipi; ā, ka tekau āu whakaputanga kētanga i ngā utu mōku. ");
INSERT INTO mri2012_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Me i kāhore i tata mai ki ahau te Atua o tōku pāpā, te Atua o Āperahama, te wehi hoki o Īhaka, ina kua tonoa kautia mai ahau e koe. I kite mai te Atua i tōku tūkinotanga, i te mahi hoki a ōku ringa, i rīria ai koe e ia inapō.” ");
INSERT INTO mri2012_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Nā, ko te whakahokinga a Rāpana, ko te meatanga ki a Hākopa, “He tamāhine nāku ēnei tamāhine, he tamariki anō nāku ēnei tamariki, he kāhui anō hoki nāku ēnei kāhui, ā, ko ngā mea katoa e kite nei koe, nāku. Ā, he aha tāku e mea ai ākuanei ki ēnei tamāhine āku, ki a rāua tamariki rānei i whānau nei i a rāua? ");
INSERT INTO mri2012_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nā, tēnā, haere mai, kia whakarite kawenata tāua, a koe me ahau; ā, ka waiho hei kaiwhakaatu ki a tāua.” ");
INSERT INTO mri2012_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Nā, ka tīkina tētahi kōhatu e Hākopa, ā, whakaarahia ake e ia hei pou. ");
INSERT INTO mri2012_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ā, ka mea a Hākopa ki ōna tēina, “Kohia mai he kōhatu.” Nā, ka tīkina atu e rātou ētahi kōhatu, ka hangā he pūranga. Ā, kai ana rātou ki reira ki runga ki te pūranga. ");
INSERT INTO mri2012_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ā, huaina iho taua mea e Rāpana ko Iekarahaharuta; nā Hākopa ia i hua ko Kareere. ");
INSERT INTO mri2012_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nā, ka mea a Rāpana, “Hei kaiwhakaatu tēnei pūranga i tēnei rā ki a tāua.” Nā reira i huaina ai tōna ingoa ko Kareere; ");
INSERT INTO mri2012_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ko Mihipa hoki; i mea hoki ia, “Mā Ihowā e titiro mai ki a tāua, ina matara atu tāua i a tāua. ");
INSERT INTO mri2012_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ki te tūkino koe i āku tamāhine, ki te tango rānei i ētahi wāhine kē atu i āku tamāhine, kāhore he tangata i a tāua; kia mahara, hei kaititiro te Atua ki ahau, ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","I mea anō a Rāpana ki a Hākopa, “Titiro ki tēnei pūranga, ā, titiro hoki ki tēnei pou i waiho iho nei e ahau i waenganui i a tāua. ");
INSERT INTO mri2012_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Hei kaiwhakaatu tēnei pūranga, hei kaiwhakaatu anō hoki tēnei pou, mōku kei haere ki tua atu o tēnei pūranga ki a koe, mōu hoki kei haere ake ki ahau ki tua o tēnei pūranga, o tēnei pou hoki, mō te kino. ");
INSERT INTO mri2012_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mā te Atua o Āperahama, mā te Atua hoki o Nahora, mā te Atua o tō rāua pāpā, e whakarite tā tāua whakawā.” Nā, ka oatitia e Hākopa te wehi o tōna pāpā, o Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Nā, patua ana e Hākopa he patunga tapu ki runga ki te maunga, ā, karangatia ana e ia ōna tēina ki te kai taro. Nā, ka kai taro rātou, ā, ka moe ki te maunga. ");
INSERT INTO mri2012_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ā, ka maranga wawe a Rāpana i te ata, ka kihi i āna tama, i āna tamāhine, ka manaaki hoki i a rātou; nā, haere ana a Rāpana, hoki ana ki tōna wāhi. ");
INSERT INTO mri2012_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Nā, haere ana a Hākopa i tōna huarahi, ā, ka tūtaki ki a ia ngā anahera a te Atua. ");
INSERT INTO mri2012_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ā, ka mea a Hākopa i tōna kitenga i a rātou, “Ko te ope tēnei a te Atua!” Nā, huaina iho e ia te ingoa o tēnā wāhi ko Mahanaima. ");
INSERT INTO mri2012_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nā, ka tono tāngata atu a Hākopa ki mua i a ia ki a Ēhau, ki tōna tuakana, ki te whenua o Heira, ki te whenua o Ēroma. ");
INSERT INTO mri2012_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ka ako hoki ia ki a rātou, ka mea, “Kia pēnei he kōrero atu mā koutou ki tōku ariki, ki a Ēhau: ‘E pēnei ana te kupu a tāu pononga, a Hākopa, i a Rāpana ahau e noho ana ā tae mai ki tēnei wā; ");
INSERT INTO mri2012_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","he kau anō āku, he kāihe, he hipi, he pononga tāne, he pononga wāhine. Ā, kua tono tāngata nei ahau ki te kōrero ki tōku ariki, kia manakohia ai ahau e koe.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nā, ka hoki mai ngā karere ki a Hākopa, ka mea, “I tae atu mātou ki tōu tuakana, ki a Ēhau, ā, tēnei anō ia te haere mai nei ki te whakatau i a koe, rātou tahi ko ngā tāngata e whā rau.” ");
INSERT INTO mri2012_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Nā, he nui te wehi o Hākopa, ka mānukanuka; nā, ka wehea e ia ōna tāngata, me ngā hipi, me ngā kau, me ngā kāmera, kia rua ngā rōpū; ");
INSERT INTO mri2012_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","i mea hoki ia, “Ki te tae mai a Ēhau ki te rōpū tuatahi, ā, ka patua e ia, nā, ka mawhiti te rōpū i mahue.” ");
INSERT INTO mri2012_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Nā, ka mea a Hākopa, “E te Atua o tōku pāpā, o Āperahama, e te Atua o tōku pāpā, o Īhaka, e Ihowā, nāu nei te kupu ki ahau, ‘Hoki atu ki tōu whenua, ki ōu whanaunga hoki, ā, ka pai tāku mahi ki a koe.’ ");
INSERT INTO mri2012_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","He iti rawa ahau, he nui āu arohatanga katoa, me te pono katoa hoki i whakaputaina mai e koe ki tāu pononga; i whiti mai hoki ahau me tōku tokotoko i tēnei Horano; ā, ka rua nei ōku rōpū. ");
INSERT INTO mri2012_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tēnā rā, whakaorangia ahau i te ringa o tōku tuakana, i te ringa o Ēhau; e wehi ana hoki ahau i a ia, kei haere mai ia ki te patu i ahau, i te whaea rātou tahi ko ngā tamariki. ");
INSERT INTO mri2012_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","I mea mai nei hoki koe, ‘Inā, ka pai tāku mahi ki a koe, ā, ka meinga e ahau ōu uri kia rite ki te onepū o te moana, e kore nei e taea te tatau i te tini.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ā, i moe ia ki reira i taua pō; ā, i tangohia e ia i roto i ngā mea i pono ki tōna ringa he hākari mā Ēhau, mā tōna tuakana: ");
INSERT INTO mri2012_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","e rua rau ngā koati uha, e rua tekau hoki ngā koati toa, e rua rau ngā hipi uha, e rua tekau ngā hipi toa, ");
INSERT INTO mri2012_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","e toru tekau ngā kāmera whai waiū, me ā rātou kūao, e whā tekau ngā kau, kotahi tekau hoki ngā pūru, e rua tekau ngā kāihe uha, me ngā kūao hoki kotahi tekau. ");
INSERT INTO mri2012_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ā, ka hoatu e ia ki ngā ringa o āna pononga tēnei kāhui, tēnei kāhui, motumotu rawa; ka mea ia ki āna pononga, “Haere i mua i ahau, kia whai takiwā tētahi kāhui, tētahi kāhui.” ");
INSERT INTO mri2012_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","I ako anō ia i te tuatahi, i mea: “E tūtaki a Ēhau, tōku tuakana, i a koe, e mea, ‘Nā wai koe? Ā, e haere ana koe ki hea? Ā, nā wai ēnei mea i tōu aroaro?’ ");
INSERT INTO mri2012_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Nā, ka mea atu koe, ‘Nā tāu pononga, nā Hākopa; i hōmai e ia hei hākari mā tōku ariki, mā Ēhau, ā, tēnei anō hoki ia kei muri i a mātou.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","He pērā anō tāna ako ki te tuarua, ki te tuatoru hoki, ki ngā tāngata katoa anō hoki i haere i muri i ngā kāhui, i mea ia: “Ko te tikanga tēnei mō ngā kupu e kōrero ai koutou ki a Ēhau, ina tūtaki ki a ia, ");
INSERT INTO mri2012_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ā, me kī atu e koutou, ‘Nā, tēnei anō hoki tāu pononga, a Hākopa, kei muri i a mātou.’ ” I mea hoki ia, “Me whakamārie ia e ahau ki te hākari e haere ana i mua i ahau, ā muri iho ka kite ahau i tōna kanohi; tērā pea ia e manako ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nā, ka haere atu te hākari i mua i a ia; ā, ko ia i moe i taua pō i te puni. ");
INSERT INTO mri2012_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ā, i whakatika ia i taua pō, i tango hoki i āna wāhine tokorua, me āna wāhine pononga tokorua, me āna tamariki tekau mā tahi, ā, ka whiti i te whitinga i Iapoko. ");
INSERT INTO mri2012_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ā, i tango ia i a rātou, i mea hoki kia whiti i te awa, ā, i tukua atu e ia kia whiti ngā mea i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ā, i mahue iho a Hākopa ko ia anake; ā, nōnoke ana rāua ko tētahi tangata, ā, tākiri noa te ata. ");
INSERT INTO mri2012_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ā, nō te kitenga o tērā kīhai ia i taea e ia, ka pā ia ki te ateatenga o tōna hūhā; ā, ka takoki te ateatenga o te hūhā o Hākopa i a rāua e nōnoke ana. ");
INSERT INTO mri2012_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nā, ka mea ia, “Tukua ahau, kua tākiri hoki te ata.” Ā, ka mea ia, “E kore koe e tukua e ahau, kia manaakitia rā anō ahau e koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ā, ka mea ia, “Ko wai tōu ingoa?” Ā, ka mea ia, “Ko Hākopa.” ");
INSERT INTO mri2012_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ā, ka mea ia, “Heoi anō kīanga ko Hākopa tōu ingoa, engari ko Īharaira. Nō te mea kua tohe koe ki te Atua, ki te tangata hoki, ā, i a koe anō te mutunga.” ");
INSERT INTO mri2012_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Nā, ka ui a Hākopa, ka mea, “Tēnā koa, kōrerotia mai tōu ingoa.” Anō rā ko ia, “He aha tōku ingoa i uia ai e koe?” Ā, ka manaaki ia i a ia i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nā, huaina ana e Hākopa te ingoa o taua wāhi ko Peniere, i mea hoki ia, “Mōku i titiro ki te Atua, he kanohi, he kanohi, ā, kei te ora nei ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ā, i tara mai te rā ki a ia i a ia ka whiti i Penuere, kei te totitoti anō tōna hūhā. ");
INSERT INTO mri2012_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Koia ngā tama a Īharaira tē kai ai i te uaua i memenge, arā i tērā i te ateatenga o te hūhā, ā tae noa ki tēnei rā. Nō te mea hoki i pā ia ki te ateatenga o te hūhā o Hākopa, ki te uaua i memenge. ");
INSERT INTO mri2012_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ā, ka maranga ake ngā kanohi o Hākopa, nā, ka titiro atu ia, ā, ko Ēhau e haere mai ana, rātou ko ngā tāngata e whā rau. Nā, ka wehea e ia ngā tamariki ki a Rea, ki a Rahera, ki ngā pononga wāhine hoki tokorua. ");
INSERT INTO mri2012_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","I makā anō e ia ngā pononga wāhine me ā rāua tamariki ki mua, ko Rea rātou ko āna tamariki ki muri mai, ā, ko Rahera rāua ko Hōhepa ki muri rawa. ");
INSERT INTO mri2012_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nā, ko ia i haere ki mua i a rātou, ā, e whitu ōna pikonga ki te whenua, ā, whakatata noa ia ki tōna tuakana. ");
INSERT INTO mri2012_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Nā, ka rere a Ēhau ki te whakatau i a ia, ā, ka awhi i a ia, ka hinga hoki ki runga ki tōna kakī, ka kihi i a ia; nā, ka tangi rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Nā, ka maranga ōna kanohi, ka kite ia i ngā wāhine, rātou ko ngā tamariki; ā, ka mea, “Ko wai ēnei i a koe nei?” Ā, ka mea ia, “Ko ngā tamariki, ko ngā ohaohatanga a te Atua ki tāu pononga.” ");
INSERT INTO mri2012_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nā, ka whakatata ngā pononga wāhine, rāua ko ā rāua tamariki, ā, ka piko iho. ");
INSERT INTO mri2012_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Nā, ka whakatata hoki a Rea, rātou ko āna tamariki, ā, ka piko iho; ā muri iho ka whakatata a Hōhepa rāua ko Rahera, ā, ka piko iho rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ā, ka mea ia, “Hei aha māu tēnei rōpū katoa i tūtaki nei ki ahau?” Anō rā ko ia, “Kia manakohia mai ai ahau e tōku ariki.” ");
INSERT INTO mri2012_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ā, ka mea a Ēhau, “He nui kei ahau; waiho anō i a koe tāu, e tōku teina.” ");
INSERT INTO mri2012_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Anō rā ko Hākopa, “Kaua rā; mehemea kua manakohia mai ahau e koe, nā, me tango e koe te hākari a tōku ringa. Ka kite atu nei hoki ahau i tōu kanohi, me te mea e titiro atu ana ki te kanohi o te Atua, ā, ka pai mai anō koe ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tangohia rā tāku manaaki i kawea atu nā ki a koe; kua atawhai mai nei hoki te Atua ki ahau, ā, e hua ana āku mea.” Nā, ka tohe ia ki a ia, ā, ka tangohia e ia. ");
INSERT INTO mri2012_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Nā, ka mea ia, “Hāpainga, tātou ka haere, me haere anō ahau i mua i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ā, ka mea ia ki a ia, “E mōhio ana tōku ariki he kahakore ngā tamariki, ā, kei ahau hoki ngā kāhui me ngā kau whai kūao. Kia kotahi noa rangi e akiakina ana rātou, nā, ka mate katoa ngā kāhui. ");
INSERT INTO mri2012_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ko koe, ko tōku ariki, e haere i mua i tāna pononga; ā, ka rite tāku āta arataki ki te haere a ngā mea i tōku aroaro nei, ki te haere hoki a ngā tamariki, ā, kia tae rā anō ahau ki tōku ariki, ki Heira.” ");
INSERT INTO mri2012_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Nā, ka mea a Ēhau, “Kāti, me waiho e ahau ki a koe ētahi o ngā tāngata i ahau nei.” Ā, ka mea ia, “Hei aha koa? Kia manakohia mai ahau e tōku ariki.” ");
INSERT INTO mri2012_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Nā, ka hoki a Ēhau i taua rangi anō, ka haere ki Heira. ");
INSERT INTO mri2012_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ā, ka tūria atu e Hākopa ki Hukota, ka hangā e ia tētahi whare mōna, i hangā anō hoki e ia ētahi tīhokahoka mō āna kararehe. Nā reira i huaina ai te ingoa o taua wāhi ko Hukota. ");
INSERT INTO mri2012_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ā, ka tae a Hākopa ki Hareme, ki tētahi pā o Hekeme, ki te whenua o Kanaana, i tōna haerenga mai i Paranārama; ā, ka noho ki te ritenga atu o te pā. ");
INSERT INTO mri2012_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nā, ka hokona e ia te wāhi whenua i tū ai tōna tēneti i te ringa o ngā tama a Hāmora, pāpā o Hekeme, ki ngā moni kotahi rau. ");
INSERT INTO mri2012_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nā, ka whakatūria e ia tētahi āta ki reira, ā, huaina iho e ia ko Erērohe Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Nā, ka haere atu a Rina, tamāhine a Rea, i whānau nei i a rāua ko Hākopa, kia kite i ngā tamāhine o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ā, ka kite a Hekeme, tama a Hāmora Hiwi, rangatira o taua whenua, i a ia; ā, ka hopukia ia e ia, ā, ka takoto ki a ia, ka whakaiti hoki i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nā, ka piri tōna wairua ki a Rina, tamāhine a Hākopa, ā, ka aroha ia ki te kōtiro rā, ka whakamārie hoki i te ngākau o taua kōtiro. ");
INSERT INTO mri2012_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Nā, ka kōrero a Hekeme ki a Hāmora, ki tōna pāpā, ka mea, “Tīkina te kōtiro nei hei wahine māku.” ");
INSERT INTO mri2012_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nā, i rongo a Hākopa kua pōkea a Rina, tāna tamāhine, e ia; ā, i te pārae āna tama, i āna kararehe. Nā, ka whakarongo puku a Hākopa, kia tae mai rā anō rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Nā, ka haere a Hāmora pāpā o Hekeme ki a Hākopa ki te kōrero ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Nā, ka haere mai ngā tama a Hākopa i te pārae, i tō rātou rongonga; ā, ka matangerengere aua tāngata, ka tino riri hoki, mō tāna mahi wairangi i roto i a Īharaira, i a ia i takoto rā ki te tamāhine a Hākopa; he mahi hoki kīhai i tika. ");
INSERT INTO mri2012_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Nā, ka kōrero a Hāmora ki a rātou, ka mea, “Ko Hekeme, ko tāku tama, piri tonu tōna wairua ki tā koutou tamāhine. Hōmai ia ki a ia, nē? hei wahine. ");
INSERT INTO mri2012_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ā, kia mārenatia tātou ki a tātou; hōmai ā koutou tamāhine ki a mātou, ā, me tango hoki ā mātou tamāhine mā koutou. ");
INSERT INTO mri2012_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ā, me noho koutou ki a mātou; ā, ka takoto atu te whenua i mua i a koutou; e noho i reira, ka hokohoko i reira, ka whakatupu rawa mā koutou i reira.” ");
INSERT INTO mri2012_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ā, ka mea a Hekeme ki tōna pāpā rātou ko ōna tungāne, “Kia manakohia mai ahau e koutou, ā, ko tā koutou e kī mai ai ki ahau ka hoatu e ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ahakoa pēhea te nui o te tāpākūhā me te hākari e meatia mai e koutou ki ahau, ka hoatu e ahau tā koutou e kī mai ai ki ahau; otirā hōmai te kōtiro hei wahine māku.” ");
INSERT INTO mri2012_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Nā, ka whakahoki tinihanga, ngā tama a Hākopa ki a Hekeme rāua ko Hāmora, ko tōna pāpā, i mea hoki rātou mō Rina, mō tō rātou tuahine, whakapokea e ia; ");
INSERT INTO mri2012_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ka mea rātou ki a rāua, “E kore tēnei mea e taea e mātou te mea, te hoatu i tō mātou tuahine ki te tangata kāhore i kotia; he tāwainga hoki tēnā mō mātou. ");
INSERT INTO mri2012_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tēnei ia te mea e whakaae ai mātou ki a koutou. Ki te pēneitia koutou me mātou, ki te kotia ō koutou tāne katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kātahi ka hoatu e mātou ā mātou tamāhine ki a koutou, ka tangohia mai hoki ā koutou tamāhine mā mātou, ā, ka noho mātou i roto i a koutou, ā, ka meinga tātou hei iwi kotahi. ");
INSERT INTO mri2012_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ki te kāhore ia koutou e rongo ki tā mātou, kia kotia koutou; nā, ka tango mātou i tā mātou tamāhine, ka haere.” ");
INSERT INTO mri2012_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nā, i pai ā rātou kupu ki a Hāmora, ki a Hekeme hoki, ki te tama a Hāmora, ");
INSERT INTO mri2012_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ā, kīhai i whakaroa taua tamaiti ki te mea i taua mea, he matenui hoki nōna ki te tamāhine a Hākopa. He nui atu anō ia i ngā tāngata katoa o te whare o tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Nā, ka haere a Hāmora rāua ko Hekeme, ko tāna tama, ki te kūwaha o tō rāua pā, ā, ka kōrero ki ngā tāngata o tō rāua pā, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“He hunga āta noho tēnei ki a tātou nō reira tukua rātou kia noho ki tēnei whenua, kia hokohoko ki konei. Nā, ko te whenua nei, nanā, he nui noa atu mō rātou; me tango mai e tātou ā rātou tamāhine hei wāhine mā tātou, ka hoatu hoki i ā tātou tamāhine ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kotahi anō ia te mea e whakaae mai ai aua tāngata ki a tātou, kia noho ki a tātou, kia waiho hei iwi kotahi, ki te kotia ō tātou tāne katoa, ki te pērātia me rātou kua kotia nei. ");
INSERT INTO mri2012_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ko ā rātou kararehe, ko ā rātou taonga, me ā rātou kīrehe katoa, e kore ianei ēnā e riro mai i a tātou? Erangi me whakaae atu tātou ki a rātou, ā, ka noho rātou ki a tātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ā, i whakarongo ki a Hāmora rāua ko Hekeme, ko tāna tama, ngā tāngata katoa i haere atu i te kūwaha o tōna pā; ā, i kotia katoatia ngā tāne, ngā tāngata katoa i haere atu i te kūwaha o tōna pā. ");
INSERT INTO mri2012_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ā, i te toru o ngā rā, i a rātou e mamae ana, nā, ka tango ngā tama tokorua a Hākopa, a Himiona rāua ko Rīwai, ngā tungāne o Rina, i tāna hoari, i tāna hoari, ā, haere ohorere ana ki te pā, ā, patua iho e rāua ngā tāne katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","I patua anō hoki e rāua a Hāmora rāua ko Hekeme, ko tāna tama ki te mata o te hoari, ā, tangohia ana e rāua a Rina i roto i te whare o Hekeme, ā, haere ana. ");
INSERT INTO mri2012_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Nā, ka haere ngā tama a Hākopa ki te hunga i patua, ā, pāhuatia ana e rātou te pā, mō tō rātou tuahine i whakapokea e rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","I tangohia e rātou ā rātou hipi, ā rātou kau, ā rātou kāihe, me ngā mea hoki i te pā, me ngā mea anō hoki i te māra; ");
INSERT INTO mri2012_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","me ā rātou taonga katoa, ā, whakaraua ana ā rātou tamariki katoa, me ā rātou wāhine, i pāhuatia anō hoki ngā mea katoa i roto i te whare. ");
INSERT INTO mri2012_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Nā, ka mea a Hākopa ki a Himiona rāua ko Rīwai, “Ka raru ahau i a kōrua, ka meinga kia piro i roto i ngā tāngata whenua, i roto i ngā Kanaani rātou ko ngā Perihi, ā, ka huihui mai rātou ki ahau, ki te hunga tokoiti, ā, ka patua ahau; ā, ka ngaro ahau, ahau me tōku whare.” ");
INSERT INTO mri2012_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ā, ka mea rāua, “Kia pērātia koia e ia tō mātou tuahine me te wahine kairau?” ");
INSERT INTO mri2012_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nā, ka mea te Atua ki a Hākopa, “Whakatika, haere ake ki Pētēre, ki reira noho ai; ka hanga hoki ki reira i tētahi āta mā te Atua i puta mai nei ki a koe, i tōu rerenga mai i te aroaro o Ēhau, o tōu tuakana.” ");
INSERT INTO mri2012_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kātahi ka mea a Hākopa ki tōna whare, ki ōna tāngata katoa hoki, “Whakarērea atu ngā atua kē i roto i a koutou, e pure i a koutou, ā, kākahuria ētahi kākahu kē mō koutou. ");
INSERT INTO mri2012_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ā, whakatika tātou, ka haere ake ki Pētēre; ā, ka hangā e ahau ki reira tētahi āta mā te Atua i whakarongo mai nei ki ahau i te rā i pōuri ai ahau, i tata anō hoki ki ahau i te huarahi i haere ai ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Nā, ka hōmai e rātou ki a Hākopa ngā atua kē katoa i roto i tō rātou ringa, me ngā whakakai i ō rātou taringa; ā, ka hunā e Hākopa ki raro i te oki i Hekeme. ");
INSERT INTO mri2012_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Nā, ka tūria atu e rātou; i runga anō te wehi o te Atua i ngā pā i tētahi taha i tētahi taha o rātou, ā, kīhai rātou i whai i ngā tama a Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Heoi, ka tae a Hākopa ki Rutu, ki tērā hoki i te whenua o Kanaana, (arā ki Pētēre), a ia me tōna nuinga katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ā, ka hangā e ia he āta ki reira, ā, huaina iho e ia taua wāhi ko Erepetēre. Nō te mea hoki i puta mai te Atua ki a ia i reira, i tōna rerenga i te aroaro o tōna tuakana. ");
INSERT INTO mri2012_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nā, ka mate a Tepora kaiwhakangote o Ripeka, ā, ka tanumia ki raro i Pētēre, ki raro i te oki; ā, ka huaina tō reira ingoa ko Aronipakuta. ");
INSERT INTO mri2012_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","I puta mai anō te Atua ki a Hākopa i tōna haerenga mai i Paranārama, i manaaki hoki i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ā, ka mea te Atua ki a ia, “Ko Hākopa tōu ingoa; e kore tōu ingoa e huaina ko Hākopa ā muri ake nei, engari ko Īharaira hei ingoa mōu.” Nā, huaina ana e ia tōna ingoa ko Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","I mea anō te Atua ki a ia, “Ko ahau te Atua Kaha Rawa: kia hua koe, kia tini; kia puta he iwi, he huinga iwi anō hoki i roto i a koe, kia puta anō hoki ngā kīngi i roto i tōu hope. ");
INSERT INTO mri2012_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ko te whenua hoki i hoatu e ahau ki a Āperahama rāua ko Īhaka, ka hoatu anō e ahau ki a koe, ka hoatu anō hoki e ahau tēnā whenua ki ōu uri i muri i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Nā, ka mawehe atu te Atua i a ia ki runga, i te wāhi i kōrero ai ia ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nā, ka whakatūria e Hākopa he pou ki te wāhi i kōrero ai ia ki a ia, he pou kōhatu; ā, ka ringihia e ia he ringihanga ki runga, ā, i ringihia hoki e ia he hinu ki runga. ");
INSERT INTO mri2012_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ā, huaina iho e Hākopa te ingoa o te wāhi i kōrero ai te Atua ki a ia, ko Pētēre. ");
INSERT INTO mri2012_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Nā, ka hāpainga atu e rātou i Pētēre; ā, ka whano ka tae rātou ki Ēparata. Nā, ka whakawhānau a Rahera, ka whakauaua hoki tōna whānautanga. ");
INSERT INTO mri2012_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ā, i te mea ka whakauaua tōna whānautanga, ka mea te kaiwhakawhānau ki a ia, “Kaua e wehi; tā te mea he tama anō tēnei āu.” ");
INSERT INTO mri2012_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Nā, i te mea ka haere tōna wairua, (i mate hoki ia), ka huaina e ia tōna ingoa ko Penoni; nā tōna pāpā ia i hua ko Pineamine. ");
INSERT INTO mri2012_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Nā, ka mate a Rahera, ka tanumia ki te ara ki Ēparata, (koia nei a Pēterehema), ");
INSERT INTO mri2012_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ā, ka whakatūria e Hākopa he pou ki runga ki tōna rua. Ko te pou ia o te rua o Rahera ā tae noa ki tēnei rā. ");
INSERT INTO mri2012_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nā, ka tūria atu e Īharaira, ā, ka whakaarahia e ia tōna tēneti ki tua atu i te pourewa i Erara. ");
INSERT INTO mri2012_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ā, i a Īharaira e noho ana i taua whenua, nā, ka haere a Reupena ka takoto ki a Piriha wahine iti a tōna pāpā; ā, ka rongo a Īharaira. Nā, kotahi tekau mā rua ngā tama a Hākopa: ");
INSERT INTO mri2012_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ko ngā tama a Rea: ko Reupena, (ko te mātāmua a Hākopa), ko Himiona, ko Rīwai, ko Hūrā, ko Ihākara, ko Hepurona. ");
INSERT INTO mri2012_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ko ngā tama a Rahera: ko Hōhepa rāua ko Pineamine. ");
INSERT INTO mri2012_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ko ngā tama a Piriha, pononga wahine a Rahera: ko Rāna rāua ko Napatari. ");
INSERT INTO mri2012_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ko ngā tama a Tiripa, pononga wahine a Rea: ko Kara rāua ko Āhera. Ko ngā tama ēnei a Hākopa i whānau nei māna ki Paranārama. ");
INSERT INTO mri2012_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nā, kua tae a Hākopa ki a Īhaka, ki tōna pāpā, ki Mamere, ki te pā o Arapa, arā ki Heperona, ki te wāhi hoki i noho ai a Āperahama rāua ko Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ā, kotahi rau e waru tekau tau ngā rā o Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Nā, ka hemo a Īhaka, ka mate, ka kohia atu ki tōna iwi, he koroheke, kua maha hoki ōna rā; ā, nā āna tama, nā Ēhau rāua ko Hākopa ia i tanu. ");
INSERT INTO mri2012_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nā, ko ngā whakatupuranga ēnei o Ēhau, arā o Ēroma. ");
INSERT INTO mri2012_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","I tangohia āna wāhine e Ēhau i roto i ngā tamāhine o Kanaana: a Āraha, tamāhine a Erona Hiti, a Ahoripama, tamāhine a Anaha, tamāhine a Tipeona Hiwi; ");
INSERT INTO mri2012_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","rātou ko Pahemata, tamāhine a Ihimaera, tuahine o Nepaioto. ");
INSERT INTO mri2012_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ā, whānau ake tā Āraha rāua ko Ēhau ko Eripāta; whānau ake tā Pahemata ko Reuere; ");
INSERT INTO mri2012_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ā, whānau ake a Ahoripama, ko Ieuhu, ko Iārama, ko Koraha. Ko ngā tama ēnei a Ēhau i whānau nei māna ki te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Nā, ka tangohia e Ēhau āna wāhine, āna tama, āna tamāhine, ngā tāngata katoa o tōna whare, āna kararehe, āna kīrehe katoa, āna taonga katoa i whiwhi ai ia ki te whenua o Kanaana, ā, haere atu ana ki tētahi whenua kē atu i tōna teina i a Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","He nui rawa hoki nō ā rāua taonga, tē noho tahi ai rāua; kīhai hoki te whenua i noho manene nei rāua i nui hei nohoanga mō rāua, i ā rāua kararehe hoki. ");
INSERT INTO mri2012_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Nā, ka noho a Ēhau ki Maunga Heira; ko Ēroma a Ēhau. ");
INSERT INTO mri2012_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ā, ko ngā whakatupuranga ēnei a Ēhau pāpā o ngā Ēromi i Maunga Heira. ");
INSERT INTO mri2012_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ko ngā ingoa ēnei o ngā tama a Ēhau: ko Eripāta tama a Āraha wahine a Ēhau ko Reuere tama a Pahemata wahine a Ēhau. ");
INSERT INTO mri2012_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ā, ko ngā tama a Eripāta, ko Temana, ko Ōmara, ko Tepo, ko Katama, ko Kenaha. ");
INSERT INTO mri2012_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Nā, ko Timina he wahine iti nā Eripāta tama a Ēhau; ā, whānau ake tā rāua ko Eripāta, ko Amareke. Ko ngā tama ēnei a Āraha wahine a Ēhau. ");
INSERT INTO mri2012_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ko ngā tama hoki ēnei a Reuere: ko Nahata, ko Heraha, ko Hamaha, ko Miha; ko ngā tama ēnei a Pahemata wahine a Ēhau. ");
INSERT INTO mri2012_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Nā, ko ngā tama ēnei a Ahoripama a Anaha, tamāhine a Tipeona, a te wahine a Ēhau: ā, whānau ake ā rāua ko Ēhau ko Ieuhu, ko Iārama, ko Koraha. ");
INSERT INTO mri2012_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ko ēnei o ngā tama a Ēhau i waiho hei ariki. Ko ngā tama a Eripāta mātāmua a Ēhau: ko Temana ariki, ko Ōmara ariki, ko Tepo ariki, ko Kenaha ariki, ");
INSERT INTO mri2012_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ko Koraha ariki, ko Katama ariki, ko Amareke ariki. Nā Eripāta ēnei ariki i te whenua o Ēroma; ko ngā tama ēnei a Āraha. ");
INSERT INTO mri2012_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ā, ko ngā tama ēnei a Reuere tama a Ēhau: ko Nahata ariki, ko Heraha ariki, ko Hamaha ariki, ko Miha ariki. Nā Reuere ēnei ariki i te whenua o Ēroma; ko ngā tama ēnei a Pahemata wahine a Ēhau. ");
INSERT INTO mri2012_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ko ngā tama hoki ēnei a Ahoripama, wahine a Ēhau: ko Ieuhu ariki, ko Iārama ariki, ko Koraha ariki. Nā Ahoripama ēnei ariki, nā te tamāhine a Anaha, nā te wahine a Ēhau. ");
INSERT INTO mri2012_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ko ngā tama ēnei a Ēhau, arā a Ēroma, ā, ko ēnei anō ō rātou ariki. ");
INSERT INTO mri2012_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ko ngā tama ēnei a Heira Hori, ko ngā tāngata whenua hoki: ko Rōtana, ko Hopara, ko Tipeona, ko Anaha, ");
INSERT INTO mri2012_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ko Rīhona, ko Ētere, ko Rīhana. Ko ngā ariki ēnei o ngā Hori, ko ngā tama hoki a Heira i te whenua o Ēroma. ");
INSERT INTO mri2012_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ko ngā tama a Rōtana, ko Hori, ko Hēmama; ā, ko Timina te tuahine o Rōtana. ");
INSERT INTO mri2012_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ko ngā tama hoki ēnei a Hopara: ko Arawana, ko Manahata, ko Ēpara, ko Hepo, ko Ōnama. ");
INSERT INTO mri2012_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ko ngā tama hoki ēnei a Tipeona: ko Aiaha rāua ko Anaha. (Nā tēnei Anaha i kite ngā puia i te koraha, i a ia e whāngai ana i ngā kāihe a Tipeona, a tōna pāpā.) ");
INSERT INTO mri2012_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ko ngā tama hoki ēnei a Anaha: ko Rīhona, ko Ahoripama tamāhine a Anaha. ");
INSERT INTO mri2012_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ā, ko ngā tama ēnei a Rīhona; ko Hemerana, ko Ehepana, ko Itirana, ko Kerana. ");
INSERT INTO mri2012_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ko ngā tama ēnei a Ētere: ko Pirihana, ko Taawana, ko Akana. ");
INSERT INTO mri2012_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ko ngā tama ēnei a Rīhana: ko Uhu rāua ko Arana. ");
INSERT INTO mri2012_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Nō ngā Hori ēnei ariki: ko Rōtana ariki, ko Hopara ariki, ko Tipeona ariki, ko Anaha ariki, ");
INSERT INTO mri2012_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ko Rīhona ariki, ko Ētere ariki, ko Rīhana ariki; nō ngā Hori ēnei ariki, nō roto i ō rātou ariki i te whenua o Heira. ");
INSERT INTO mri2012_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ko ngā kīngi ēnei i kīngi i te whenua o Ēroma, i te mea kāhore anō he kīngi o ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ā, he kīngi nō Ēroma a Pera tama a Peoro, ā, ko Rinihapa te ingoa o tōna pā. ");
INSERT INTO mri2012_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Nā, ka mate a Pera, ā, ko Iopapa tama a Tera o Potora te kīngi i muri a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Nā, ka mate a Iopapa, ā, ko Hūhama o te whenua o Temani te kīngi i muri i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Nā, ka mate a Hūhama, ā, ko Harara tama a Perara, a te tangata nāna nei i patu a Miriana ki te pārae o Moapa, te kīngi i muri i a ia. Ā, ko Awiti te ingoa o tōna pā. ");
INSERT INTO mri2012_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Nā, ka mate a Harara, ā, ko Hāmara o Mahareka te kīngi i muri i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Nā, ka mate a Hāmara, ā, ko Haora o Rehopoto i te taha o te awa te kīngi i muri i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Nā, ka mate a Haora, ā, ko Paara-Hanana, ko te tama a Akaporo, te kīngi i muri i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Nā, ka mate a Paara-Hanana tama a Akaporo, ā, ko Harara te kīngi i muri i a ia; ā, ko Pau te ingoa o tōna pā; ko Mehetapere hoki te ingoa o tāna wahine, he tamāhine ia nā Matarere tamāhine a Metāhapa. ");
INSERT INTO mri2012_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Nā, ko ngā ingoa ēnei o ngā ariki, arā o ngā whānau a Ēhau, o tōna hapū, o tōna hapū, o tōna kāinga, o tōna kāinga, tōna ingoa, tōna ingoa: ko Timina ariki, ko Arawa ariki, ko Ietete ariki, ");
INSERT INTO mri2012_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ko Ahoripama ariki, ko Eraha ariki, ko Pinona ariki, ");
INSERT INTO mri2012_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ko Kenaha ariki, ko Temana ariki, ko Mipitara ariki, ");
INSERT INTO mri2012_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ko Makatiere ariki, ko Irama ariki. Nō Ēroma ēnei ariki, me ō rātou nohoanga i te whenua i nohoia e rātou. Ko Ēhau ia ko te pāpā o ngā Ēromi. ");
INSERT INTO mri2012_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ā, i noho a Hākopa i te whenua i noho manene ai tōna pāpā, i te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ko ngā whakatupuranga ēnei o Hākopa. Kotahi tekau mā whitu ngā tau o Hōhepa, ā, i te whāngai hipi ia, rātou ko ōna tuākana; he taitama hoki ia i te taha o ngā tama a Piriha, o ngā tama a Tiripa, a ngā wāhine a tōna pāpā; ā, ka kawea e Hōhepa te kōrero kino mō rātou ki tō rātou pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Nā, i arohaina nuitia a Hōhepa e Īharaira i āna tama katoa, nō te mea ko te tama ia o tōna koroheketanga; ā, ka hangā e ia tētahi koti purepure mōna. ");
INSERT INTO mri2012_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ā, ka kite ōna tuākana e arohatia nuitia ana ia e tō rātou pāpā i ōna tuākana katoa, nā, ka kino rātou ki a ia, kīhai anō hoki i āhei te āta kōrero ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nā, ka moe a Hōhepa i tētahi moe, ā, ka kōrerotia e ia ki ōna tuākana; ka nui haere anō tō rātou kino ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ā, i mea ia ki a rātou, “Tēnā, whakarongo ki tēnei moe i moe nei ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nanā, i te paihere wīti tātou i waenga māra, nā, ka whakatika ake tāku paihere, ā, ka tū. Ko te tino karapotinga mai o ā koutou paihere, kei te piko iho ki tāku paihere.” ");
INSERT INTO mri2012_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Nā, ka mea ōna tuākana ki a ia, “Koia rānei ko koe hei kīngi mō mātou? Hei rangatira anō rānei koe mō mātou?” Nā, ka nui haere anō tō rātou kino ki a ia mō āna moe, mō āna kupu. ");
INSERT INTO mri2012_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ā, i moe anō ia i tētahi atu moe, ā, ka kōrerotia e ia ki ōna tuākana, ka mea ia, “Nanā, tēnei anō hoki tētahi moe i moe ai ahau; nā, ko te rā me te marama, me ngā whetū kotahi tekau mā tahi, e piko mai ana ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ā, ka kōrerotia e ia ki tōna pāpā rātou ko ōna tuākana; nā, ka whakatūpehupehu tōna pāpā ki a ia, ka mea ki a ia, “He aha tēnei moe i moe nei koe? Tērā rānei mātou, ko tōu whaea, ko ōu tuākana, e haere mai ki te piko ki a koe, ki te whenua?” ");
INSERT INTO mri2012_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nā, ka hae ōna tuākana ki a ia; ko tōna pāpā ia i mahara ki te kupu. ");
INSERT INTO mri2012_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nā, ka haere ōna tuākana ki te whāngai i ngā hipi a tō rātou pāpā i Hekeme. ");
INSERT INTO mri2012_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ā, ka mea a Īharaira ki a Hōhepa, “Kāhore ianei ōu tuākana i te whāngai hipi i Hekeme? Haere mai, me tono koe e ahau ki a rātou.” Ka mea ia, “Tēnei ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Nā, ka mea ia ki a ia, “Tēnā, haere, tirohia, kei te ora rānei ōu tuākana, kei te ora anō rānei ngā hipi; ka whakahoki mai ai i te kōrero ki ahau.” Nā, ka tonoa atu ia e ia i te raorao o Heperona. Ā, ka haere ia ki Hekeme, ");
INSERT INTO mri2012_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ā, ka tūtaki tētahi tangata ki a ia, e pōhēhē ana hoki ia i te pārae, ā, ka ui taua tangata ki a ia, “He aha tāu e rapu nā?” ");
INSERT INTO mri2012_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nā, ka mea ia, “E rapu ana ahau i ōku tuākana. Tēnā koa, whakaaturia mai ki ahau, kei hea rātou e whāngai ana i te kāhui.” ");
INSERT INTO mri2012_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ka mea taua tangata, “Kua riro atu rātou i konei; i rongo hoki ahau i a rātou e kī ana, ‘Kia haere tātou ki Rōtana.’ ” Nā, ka haere a Hōhepa ki te whai i ōna tuākana, ā, ka kitea rātou e ia ki Rōtana. ");
INSERT INTO mri2012_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nā, ka kite mai rātou i a ia tawhiti, ā, i te mea kāhore anō ia i tata noa ki a rātou, ka whakatakoto whakaaro rātou mōna kia whakamatea. ");
INSERT INTO mri2012_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ā, ka mea rātou tētahi ki tētahi, “Nanā, ko te moemoeā tēnei te haere mai nei. ");
INSERT INTO mri2012_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tēnā, tātou ka haere, ka patu i a ia, ka maka hoki i a ia ki tētahi o ngā poka, ā, ka mea tātou. Nā tētahi mohoao nanakia ia i kai; ā, ka kite tātou i te tukunga iho o āna moe.” ");
INSERT INTO mri2012_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Nā, i rongo a Reupena, ā, ka whakaorangia ia e ia i roto i ō rātou ringa; ka mea ia, “Kaua ia e patua e tātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ka mea anō a Reupena ki a rātou, “Kaua e whakahekea he toto; makā atu ia ki roto ki tēnei poka i te koraha nei, kaua hoki tētahi ringa e pā ki a ia.” He mea hoki kia whakaora ai ia i a ia i roto i ō rātou ringa, kia whakahoki ai ia i a ia ki tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ā, i te taenga o Hōhepa ki ōna tuākana, ka huia e rātou te koti o Hōhepa, te koti purepure e mau ana i a ia; ");
INSERT INTO mri2012_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ā, mauria ana ia, makā ana e rātou ki te poka. He tuwhera kau anō te poka, kāhore he wai o roto. ");
INSERT INTO mri2012_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Nā, ka noho rātou ki te kai taro, ā, ka anga ake ō rātou kanohi, nā, ko tētahi tira Ihimaeri e haere mai ana i Kireara me ā rātou kāmera, he waha i ngā mea kakara, i te pama, i te maira, e haere ana ki te kawe ki raro, ki Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Nā, ka mea a Hūrā ki ōna tuākana rātou ko ōna tēina, “He aha te pai o tā tātou patu i tō tātou teina, o te huna hoki i ōna toto? ");
INSERT INTO mri2012_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tātou ka haere, ka hoko i a ia ki ngā Ihimaeri, ā, kaua ō tātou ringa e pā ki a ia; ko tō tātou teina nei hoki ia, ko tō tātou kikokiko.” Ā, i whakaae ōna tuākana rātou ko ōna tēina. ");
INSERT INTO mri2012_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nā, ka haere mai ngā Miriani, he hunga hokohoko; ka hūtia ake e rātou a Hōhepa i roto i te poka, ā, ka hokona atu a Hōhepa e rātou ki ngā Ihimaeri, ki ngā hiriwa e rua tekau; ā, ka kawea a Hōhepa e rātou ki Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ā, ka hoki mai a Reupena ki te poka; nā, kāhore a Hōhepa i roto i te poka; ā, ka haea e ia ōna kākahu. ");
INSERT INTO mri2012_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nā, ka hoki ia ki ōna tēina, ka mea, “Kāhore nei te tamaiti; ā, ko ahau, me haere ahau ki hea?” ");
INSERT INTO mri2012_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nā, ka tango rātou i te koti o Hōhepa, ā, ka patua he koati toa, ka tukua hoki te koti ki te toto. ");
INSERT INTO mri2012_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nā, ka hoatu te koti purepure kia kawea ki tō rātou pāpā; ka mea rātou, “I kitea tēnei e mātou; tēnā, tirohia ko te koti rānei o tāu tama, ehara rānei?” ");
INSERT INTO mri2012_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ā, ka mōhiotia e ia, ā, ka mea ia, “Ko te koti tēnei o tāku tama; kua kainga ia e te kīrehe nanakia; kua tino haea rawatia a Hōhepa.” ");
INSERT INTO mri2012_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Nā, ka haea e Hākopa ōna kākahu, ka kākahuria e ia tōna hope ki te kākahu taratara, ā, he maha ngā rā i uhungatia ai e ia tāna tama. ");
INSERT INTO mri2012_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ka whakatika hoki āna tama katoa me āna tamāhine katoa ki te whakamārie i a ia; ā, kīhai ia i pai kia whakamārietia; ka mea ia, “Engari ka heke tangi atu ahau ki tāku tama ki te pō.” Nā, ka uhungatia ia e tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nā, ka hokona atu ia e ngā Miriani ki Īhipa ki a Potiwhara, ki tētahi o ngā tāngata nui a Parao, ki te rangatira o ngā kaitiaki. ");
INSERT INTO mri2012_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","I taua wā ka maunu atu a Hūrā i roto i ōna tuākana, ā, peka ana ki tētahi Aturami, ko Hira tōna ingoa. ");
INSERT INTO mri2012_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ā, kitea ana e Hūrā i reira te tamāhine a tētahi Kanaani, ko Huaha tōna ingoa. Nā, ka tango ia i a ia, ā, haere ana ki roto, ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nā, ka hapū ia, ā, ka whānau he tama; ā, huaina iho tōna ingoa ko Ere. ");
INSERT INTO mri2012_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nā, ka hapū anō ia, ā, ka whānau he tama; ā, huaina iho tōna ingoa ko Onana. ");
INSERT INTO mri2012_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ā, ka hapū anō ia, ā, ka whānau he tama; ā, huaina iho tōna ingoa ko Heraha; i Ketipi hoki te tāne i tōna whānautanga. ");
INSERT INTO mri2012_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Nā, ka tangohia e Hūrā he wahine mā Ere, mā tāna mātāmua, ko tōna ingoa ko Tāmara. ");
INSERT INTO mri2012_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","He tangata kino a Ere mātāmua a Hūrā ki tā Ihowā titiro; ā, whakamatea ana ia e Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Nā, ka mea a Hūrā ki a Onana, “Haere ki roto, ki te wahine a tōu tuakana, hei whakakapi mō te whāwhārua, kia whai uri ai tōu tuakana.” ");
INSERT INTO mri2012_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","I mōhio anō a Onana e kore e waiho te uri mōna; ā, i tōna haerenga ki te wahine a tōna tuakana, nā, ka tukua e ia kia heke atu ki te whenua, kei hoatu e ia he uri ki tōna tuakana. ");
INSERT INTO mri2012_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","He kino hoki tāna mahi ki tā Ihowā titiro; nā, ka whakamatea hoki ia. ");
INSERT INTO mri2012_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kātahi ka mea a Hūrā ki a Tāmara, ki tāna hunaonga, “Me noho pouaru koe ki te whare o tōu pāpā, kia kaumātua rā anō a Heraha, tāku tama.” I mea hoki ia, “Kei mate anō hoki tēnei, kei pērā me ōna tuākana.” Nā, ka haere a Tāmara, ā, noho ana i te whare o tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ā, ka maha ngā rā, ka mate te tamāhine a Huaha, te wahine a Hūrā; ā, ka mārie a Hūrā, ā, ka haere rāua ko tōna hoa ko Hira Aturami ki runga ki Timinata, ki āna kaikutikuti hipi. ");
INSERT INTO mri2012_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ā, ka kōrerotia ki a Tāmara, ka meatia, “Ko tōu hungawai tēnei te haere ake nei ki Timinata, ki te kutikuti i āna hipi.” ");
INSERT INTO mri2012_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Nā, ka whakarērea atu e ia ōna kākahu pouaru, ka hīpoki i a ia ki tōna ārai, roropi tonu ki a ia, ā, ka noho i te tomokanga ki Enaima, i te huarahi ki Timinata. I kite hoki ia kua kaumātua a Heraha, ā, kāhore anō ia i hoatu hei wahine māna. ");
INSERT INTO mri2012_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Nā, ka kite a Hūrā i a ia, hua noa ia he wahine kairau; nō te mea i hīpokina tōna mata. ");
INSERT INTO mri2012_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nā, ka peka ia ki te ara ki a ia, ka mea, “Tukua atu ahau, nē? Kia haere atu ki a koe.” Kīhai hoki ia i mōhio ko tāna hunaonga ia. Ā, ka mea ia, “He aha tāu e hōmai ai ki ahau, ki te haere mai koe ki ahau?” ");
INSERT INTO mri2012_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ā, ka mea ia, “Ka tukua atu e ahau tētahi kūao koati o te kāhui.” Ā, ka mea ia, “Ka hōmai rānei e koe tētahi taunaha ki ahau, kia tukua mai rā anō taua mea e koe?” ");
INSERT INTO mri2012_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ā, ka mea ia, “He aha te taunaha e hoatu e ahau ki a koe?” Ka mea ia, “Ko tōu hīri, me āu tau, me tāu tokotoko i tōu ringa.” Nā, ka hoatu e ia ki a ia, ā, ka haere atu ia ki a ia, ā, ka hapū ia i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nā, ka whakatika ia, ā, haere ana, whakarērea ana e ia tōna ārai, ā, kākahuria iho ōna kākahu pouaru. ");
INSERT INTO mri2012_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Nā, ka hoatu te kūao koati e Hūrā kia kawea e tōna hoa e te Aturami, ki te tiki i te taunaha i te ringa o te wahine; ā, kīhai ia i kitea. ");
INSERT INTO mri2012_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ā, ka ui ia ki ngā tāngata o taua wāhi, ka mea, “Kei hea te wahine kairau i Enaima, nei i te taha o te ara?” Ā, ka mea rātou, “Kāhore he wahine kairau i konei.” ");
INSERT INTO mri2012_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Nā, ka hoki ia ki a Hūrā, ka mea, “Kāhore ia i kitea e ahau; e mea ana hoki ngā tāngata o tērā wāhi, kāhore he wahine kairau i reira.” ");
INSERT INTO mri2012_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Nā, ka mea a Hūrā, “Tukua kia tangohia e ia, kei tāwaia tāua. Titiro hoki, kua tukua atu nei e ahau te kūao nei, ā, kīhai ia i kitea e koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ā, ka toru ngā marama, nā, ka kōrerotia ki a Hūrā, ka meatia, “Kua kairau a Tāmara, tāu hunaonga; kua hapū anō hoki ia i ōna kairautanga.” Ā, ka mea a Hūrā, “Kawea ki waho, kia tahuna.” ");
INSERT INTO mri2012_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ā, ka kawea ia ki waho, ka tono tangata ia ki tōna hungawai, ka mea, “Nā te tangata nāna ēnei mea tōku hapū.” I mea anō ia, “Tēnā, tirohia, nā wai ēnei, te hīri nei, me ngā tau, me te tokotoko.” ");
INSERT INTO mri2012_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nā, ka mōhiotia e Hūrā, ā, ka mea ia, “Nui atu tōna tika i tōku; kīhai hoki ia i hoatu e ahau ki a Heraha, ki tāku tama.” Ā, kīhai ia i mōhio ki a ia i muri iho. ");
INSERT INTO mri2012_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ā, ka taka ki te wā e whānau ai ia, nā, he māhanga kei roto i tōna kōpū. ");
INSERT INTO mri2012_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ā, i tōna whānautanga, nā, ka torona te ringa o tētahi; nā, ka mau te kaiwhakawhānau ki te miro whero, ā, herea ana ki tōna ringa, ka mea, “Ko tēnei i puta mai i mua.” ");
INSERT INTO mri2012_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ā, i tāna whakahokinga atu i tōna ringa, nā, ka puta mai tōna tuakana; ā, ka mea ia, “Ka tae tōu pakaru mai! Nāu te pakaru mai.” Koia i huaina ai tōna ingoa ko Parete. ");
INSERT INTO mri2012_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ā muri iho ka puta tōna teina, i herea nei tōna ringa ki te miro whero, ā, ka huaina tōna ingoa ko Tera. ");
INSERT INTO mri2012_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ā, i kawea iho a Hōhepa ki Īhipa; nā, ka hokona ia e Potiwhara, he tangata nui nā Parao, he rangatira nō ngā kaitiaki, he Īhipiana, i roto i ngā ringa o ngā Ihimaeri, nāna nei ia i kawe ki reira. ");
INSERT INTO mri2012_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Nā, i a Hōhepa a Ihowā, ā, he tangata whai rawa ia; i noho anō ia i roto i te whare o tōna ariki, o te Īhipiana, ");
INSERT INTO mri2012_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ā, i kite tōna ariki kei a ia a Ihowā, pono tonu hoki i a Ihowā ngā mahi katoa a tōna ringa. ");
INSERT INTO mri2012_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nā, ka manakohia a Hōhepa e ia, ka mahi ia ki a ia; ā, ka waiho ia hei kaitirotiro mō tōna whare, ā, ka hōmai, e ia āna mea katoa ki tōna ringa. ");
INSERT INTO mri2012_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ā, i a ia ka waiho nei hei kaitirotiro mō tōna whare, mō āna mea katoa, nā, ka manaakitia e Ihowā te whare o te Īhipiana he whakaaro ki a Hōhepa i runga anō i āna mea katoa te manaaki a Ihowā, i te whare, i te māra. ");
INSERT INTO mri2012_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","I waiho hoki e ia i te ringa o Hōhepa āna mea katoa; kīhai hoki i mōhiotia e ia tētahi o āna mea, heoi anō ko te taro i kai ai ia. Ā, he tangata ātaahua a Hōhepa, he pai hoki ia ki te titiro atu. ");
INSERT INTO mri2012_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ā, i muri i ēnei mea, ka anga ngā kanohi o te wahine a tōna ariki ki a Hōhepa; ā, ka mea ia, “Takoto tāua.” ");
INSERT INTO mri2012_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ā, ka whakakāhore ia, ka mea hoki ki te wahine a tōna ariki, “Nā, e kore tōku ariki e mōhio ko te aha kei ahau i roto i te whare, kua hōmai nei hoki e ia āna mea katoa ki tōku ringa; ");
INSERT INTO mri2012_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","kāhore tētahi i roto i tēnei whare e nui ake i ahau; kāhore anō hoki i kaiponuhia e ia tētahi mea ki ahau, ko koe anake, nō te mea ko tāna wahine koe. Nā, me pēhea e mahi ai ahau i tēnei kino nui, e hara ai ki te Atua?” ");
INSERT INTO mri2012_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Heoi, kōrero noa ia ki a Hōhepa i tēnei rā, i tēnei rā, ā, kīhai ia i rongo ki a ia, kia takoto tahi rāua, kia noho tahi rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Nā, i taua wā ka haere a Hōhepa ki te whare ki te mahi i tāna mahi; ā, kāhore tētahi o ngā tāngata o te whare i reira i roto i te whare. ");
INSERT INTO mri2012_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Nā, ka hopukia ia e ia, arā tōna kākahu, ka mea, “Takoto tāua.” Nā, ka whakarērea e ia tōna kākahu ki tōna ringa, ā, rere ana, puta ana ki waho. ");
INSERT INTO mri2012_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ā, nō tōna kitenga kua whakarērea e ia tōna kākahu i roto i tōna ringa, ā, kua rere ki waho, ");
INSERT INTO mri2012_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nā, ka karanga ia ki ngā tāngata o tōna whare, ka kōrero ki a rātou, ka mea, “Titiro, kua kawea mai e ia tētahi Hiperu hei hangarau i a tātou! I haere mai ia ki ahau kia takoto māua, ā, he rahi tōku reo ki te hāmama. ");
INSERT INTO mri2012_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ā, ka rongo ia he rahi tōku reo ki te hāmama, nā, ka whakarērea e ia tōna kākahu ki ahau, ā, rere ana, puta ana ki waho.” ");
INSERT INTO mri2012_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nā, ka waiho e ia tōna kākahu ki tōna taha, kia hoki mai rā anō tōna ariki ki tōna whare. ");
INSERT INTO mri2012_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ā, ka kōrero ia ki a ia, ko aua kupu anō, ka mea, “I haere mai ki ahau taua pononga Hiperu, i kawea mai nei e koe ki a mātou, ki te hangarau i ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ā, ka rahi tōku reo ki te hāmama, nā, ka whakarērea e ia tōna kākahu ki ahau, ā, rere ana ki waho.” ");
INSERT INTO mri2012_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ā, ka rongo tōna ariki i ngā kupu a tāna wahine i kōrero ai ia ki a ia, i mea ai, “Ko ngā mea ēnei i mea ai tāu pononga ki ahau.” Nā, ka mura tōna riri. ");
INSERT INTO mri2012_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ā, ka mau te ariki o Hōhepa ki a ia, ā, makā ana ia ki te whare herehere, ki te wāhi i herea ai ngā herehere a te kīngi, ā, noho ana ia i reira, i te whare herehere. ");
INSERT INTO mri2012_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Otiia, i a Hōhepa a Ihowā, ka puta anō tōna aroha ki a ia, ā, ka hoatu ki a ia kia manakohia ia e te rangatira o te whare herehere. ");
INSERT INTO mri2012_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ā, i tukua e te rangatira o te whare herehere ki te ringaringa o Hōhepa ngā herehere katoa i roto i te whare herehere; ko ia anō te kaimahi o ngā mea katoa i meatia e rātou i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kīhai te rangatira o te whare herehere i titiro ki tētahi o ngā mea i tōna ringa; nō te mea i a ia a Ihowā, i mea anō a Ihowā kia pono tāna i mea ai. ");
INSERT INTO mri2012_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Nā, i muri i ēnei mea ka hara te kaiwhakainu a te kīngi o Īhipa, rāua ko tāna kaihanga taro, ki tō rāua ariki, ki te kīngi o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ā, ka riri a Parao ki āna kaitohutohu tokorua, ki te tino kaiwhakainu rāua ko te tino kaihanga taro. ");
INSERT INTO mri2012_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Nā, ka hōmai rāua e ia kia puritia ki te whare o te rangatira o ngā kaitiaki, ki te whare herehere, ki te wāhi i herea ai a Hōhepa. ");
INSERT INTO mri2012_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ā, ka meinga a Hōhepa e te rangatira o ngā kaitiaki hei kaititiro mō rāua, ā, ka mahi ia ki a rāua; ā, ka puritia rāua i ētahi rā. ");
INSERT INTO mri2012_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Nā, ka moe rāua i ā rāua moe, kotahi anō te pō i moemoeā ai rāua, tētahi, tētahi, me te tikanga anō o tāna moe, te kaiwhakainu rāua ko te kaihanga taro a te kīngi o Īhipa, i herea nei rāua i roto i te whare herehere. ");
INSERT INTO mri2012_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ā, i te taenga o Hōhepa ki a rāua i te ata, ka titiro ia ki a rāua, nā, e pōuri ana rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Nā, ka ui ia ki aua kaitohutohu a Parao, i puritia tahitia nei me ia i te whare o tōna ariki, ka mea, “He aha i whakapoururu ai ō kōrua kanohi ināianei?” ");
INSERT INTO mri2012_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ā, ka mea rāua ki a ia, “I moe māua i tētahi moe, ā, kāhore he kaiwhakaatu i tōna tikanga.” Nā, ka mea a Hōhepa ki a rāua, “Ehara ianei te Atua i te kaiwhakaatu? Tēnā, kōrerotia mai ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Nā, ka kōrerotia e te tino kaiwhakainu tāna moe ki a Hōhepa, ā, ka mea ki a ia, “Moe iho ahau, nā, ko tētahi wāina i tōku aroaro; ");
INSERT INTO mri2012_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nā, e toru ngā peka o te wāina. Ā, e āhua pihi ana, ā, ka kohera ōna puāwai; ā, e hua ana ngā tautau, maoa tonu ngā karepe. ");
INSERT INTO mri2012_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nā, ko te kapu a Parao i tōku ringa; ā, ka mau ahau ki ngā karepe, ā, tauia ana e ahau ki te kapu a Parao, ā, hoatu ana e ahau te kapu ki te ringa o Parao.” ");
INSERT INTO mri2012_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Nā, ko te meatanga a Hōhepa ki a ia, “Ko tōna tikanga tēnei: Ko aua peka e toru, e toru ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kia toru ake rā ka whakaara ake ai a Parao i tōu mātenga, ka whakahoki anō i a koe ki tāu mahi, ā, ka hoatu anō e koe te kapu a Parao ki tōna ringa, ka pērā hoki me mua, i te mea ko koe tāna kairiringi wāina. ");
INSERT INTO mri2012_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Otirā, kia mahara ki ahau ina pono te pai ki a koe, kia puta anō tōu aroha ki ahau, kōrerotia hoki ahau ki a Parao, kia puta atu ai ahau i tēnei whare. ");
INSERT INTO mri2012_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","I tāhaetia pūtia mai hoki ahau i te whenua o ngā Hiperu; ā, kāhore āku mahi i konei i makā ai ahau e rātou ki tēnei whare herehere.” ");
INSERT INTO mri2012_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ā, ka kite te tino kaihanga taro he pai te tikanga, ka mea ia ki a Hōhepa, “Moe iho hoki ahau, nā, e toru ngā kete taro mā i runga i tōku upoko; ");
INSERT INTO mri2012_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ā, i tō runga kete ko ngā tū āhua kai katoa mā Parao; nā, ko ngā manu e kai ana i aua mea i roto i te kete i runga i tōku upoko.” ");
INSERT INTO mri2012_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Nā, ka whakahoki a Hōhepa, ka mea, “Ko tōna tikanga tēnei: Ko aua kete e toru, e toru ngā rā ");
INSERT INTO mri2012_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","kia toru ake ngā rā, ka tangohia ake e Parao tōu upoko i runga i a koe, ā, ka whakairihia koe ki runga ki te rākau; ā, ka kainga e ngā manu ōu kikokiko e piri nā ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ā, i te toru o ngā rā, i te rā whānau o Parao, nā, ka tukua e ia he hākari mā āna tāngata katoa; ā, whakaarahia ake ana e ia te mātenga o te tino kaiwhakainu, me te mātenga o te tino kaihanga taro, i waenganui i āna pononga. ");
INSERT INTO mri2012_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ā, whakahokia ana e ia te tino kaiwhakainu ki tāna mahi whakainu, hei hoatu i te kapu ki te ringa o Parao; ");
INSERT INTO mri2012_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ko te tino kaihanga taro ia i whakairihia ake e ia, i pērātia me tā Hōhepa i whakaatu ai ki a rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Otiia, kīhai te tino kaiwhakainu i mahara ki a Hōhepa; i wareware hoki ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ā, ka taka ngā tau e rua, ka moe a Parao; nā, i te taha ia o te awa e tū ana. ");
INSERT INTO mri2012_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nā, ko te putanga ake o ngā kau e whitu i roto i te awa, he āhua pai, e whai kiko ana; ā, ka kai rātou i roto i ngā wīwī. ");
INSERT INTO mri2012_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nā, ko te putanga ake anō o ētahi kau e whitu i muri i a rātou i roto i te awa, he āhua kino, he kikokore; ā, tū ana rātou i te taha o ērā kau i te pareparenga o te awa. ");
INSERT INTO mri2012_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nā, ka kainga e ngā kau āhua kino, kikokore, ngā kau āhua pai e whitu, ngā mea mōmona. Ā, ka ara ake a Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ā, ka parangia anō ia, nā, ko te rua o āna moe. Nā, ko te putanga ake o ngā puku wīti e whitu, kotahi anō hoki te kakau, he mea whai kiko, he pai. ");
INSERT INTO mri2012_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Nā, ko ngā puku e whitu e tupu ake ana i muri i ērā, he mea kikokore, he mea ngingio i te marangai. ");
INSERT INTO mri2012_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ā, horomia ake ngā puku whai kiko e whitu, ngā mea whai kai, e ngā puku kikokore e whitu. Ko te aranga ake o Parao; nā, he moe! ");
INSERT INTO mri2012_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ā, i te ata; nā, ka pororaru tōna wairua; ā, ka tono tāngata ia ki te karanga i ngā tohunga māori katoa o Īhipa, me ngā mea mōhio katoa o reira. Ā, kōrerotia atu ana tāna moe e Parao ki a rātou, otiia, kīhai i taea e tētahi te whakaatu i te tikanga o aua moe ki a Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Nā, ka kōrero te tino kaiwhakainu ki a Parao, ka mea, “Kātahi ahau ka mahara ki ōku hē. ");
INSERT INTO mri2012_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","I riri mai a Parao ki āna pononga, ā, i tuku i ahau kia puritia ki roto ki te whare o te rangatira o ngā kaitiaki, ahau me te tino kaihanga taro. ");
INSERT INTO mri2012_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ā, ka moe māua i tētahi moe i te pō kotahi, ahau, a ia hoki; i moe māua ahau, a ia, me te tikanga anō o ā māua moe. ");
INSERT INTO mri2012_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nā, i reira i a māua tētahi taitama Hiperu, he pononga nā te rangatira o ngā kaitiaki; ā, ka kōrerotia e māua ki a ia, ā, whakaaturia mai ana e ia te tikanga o ā māua moe ki a māua; rite tonu tāna whakaaturanga ki tā tērā moe, ki tāku. ");
INSERT INTO mri2012_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ā, tika tonu tāna i whakaatu ai ki a māua; ko ahau i whakahokia e ia ki tāku mahi, ko tērā i tāronatia.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Nā, ka tono tangata a Parao, hei karanga i a Hōhepa, ā, ka hohoro rātou te mau mai i a ia i roto i te whare herehere. Nā, ka heu ia i a ia, ka tango i ētahi kākahu kē mōna, ā, haere ana ki a Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ā, ka mea a Parao ki a Hōhepa, “I moe ahau i tētahi moe, ā, kāhore he tangata hei whakaatu i tōna tikanga. Nā, kua tae mai tōu rongo ki ahau, e kōrerotia ana ki te rongo koe i te moe ka taea e koe te whakaatu tōna tikanga.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Nā, ka whakahoki a Hōhepa ki a Parao, ka mea, “Ehara i ahau; mā te Atua e whakahoki te kupu pai ki a Parao.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Nā, ka mea a Parao ki a Hōhepa, “I ahau e moe ana, nā, e tū ana ahau i te pareparenga o te awa; ");
INSERT INTO mri2012_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","nā, ka puta ake i te awa ngā kau e whitu, he mea whai kiko, he āhua pai; ā, ka kai rātou i roto i ngā wīwī. ");
INSERT INTO mri2012_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nā, ko te putanga ake o ētahi atu kau e whitu i muri i ērā, he hīroki, he āhua kino noa iho, he kikokore, kāhore ahau i kite i tō rātou rite te kino i te whenua katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nā, ka kainga ngā kau e whitu ō mua, ngā mea mōmona, e ngā kau hīroki, e ngā mea kino; ");
INSERT INTO mri2012_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ā, i tō rātou toremitanga ki roto i a rātou, e kore e mōhiotia kua toremi rātou ki roto i a rātou; he mau tonu hoki tō rātou āhua kino, he pērā me tō te tīmatanga. Nā, ka ara ahau. ");
INSERT INTO mri2012_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Nā, i kite anō ahau i ahau e moe ana, ko ngā puku wīti e whitu e tupu ake ana i te kakau kotahi, he mea whai kai, he mea pai. ");
INSERT INTO mri2012_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Nā, ko ngā puku e whitu, he mea taramore, he mea kikokore, i ngingio nei i te marangai, e tupu ake ana i muri i aua puku; ");
INSERT INTO mri2012_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ā, horomia ake ngā puku papai e whitu e ngā puku kikokore. Nā, ka kōrerotia e ahau ki ngā tohunga māori; ā, kāhore tētahi hei whakaatu ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Nā, ko te meatanga a Hōhepa ki a Parao, “Ko te moe a Parao kotahi tonu; e whakaaturia ana e te Atua ki a Parao ngā mea e meatia ana e ia. ");
INSERT INTO mri2012_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ko ngā kau pai e whitu, e whitu ngā tau; ko ngā puku pai anō e whitu, e whitu ngā tau; kotahi anō te moe. ");
INSERT INTO mri2012_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ā, ko ngā kau hīroki e whitu, ko ngā mea kino i puta ake rā i muri i a rātou, e whitu ēnā ngā tau; ā, ko ngā puku wīti e whitu, ko ngā mea i ngingio i te marangai, e whitu ēnā ngā tau matekai. ");
INSERT INTO mri2012_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ko te mea tēnā i kōrerotia e ahau ki a Parao; ko tā te Atua e mea ai e whakakitea ana e ia ki a Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nanā, e whitu ngā tau e haere mai nei e nui ai te hua o te whenua katoa o Īhipa; ");
INSERT INTO mri2012_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ā, e whitu ngā tau matekai e ara ake i muri i ērā; ā, ka wareware katoa te hua i te whenua o Īhipa; ā, ka ngaro te whenua i te matekai. ");
INSERT INTO mri2012_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ā, e kore taua hua e mōhiotia e te whenua, i taua matekai hoki ō muri; nō te mea he tino nanakia. ");
INSERT INTO mri2012_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ā, i tuaruatia ai te moe a Parao, he mea pūmau nā te Atua, ka hohoro anō te meatia e te Atua. ");
INSERT INTO mri2012_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Nā, reira, me titiro e Parao tētahi tangata mōhio, whai whakaaro, kia tukua e ia ngā tikanga o te whenua o Īhipa ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kia meatia tēnei e Parao, kia whakaritea hoki e ia ētahi kaitirotiro mō te whenua, ā, kia tangohia e ia te rima o ngā wāhi o te whenua o Īhipa i ngā tau hua e whitu. ");
INSERT INTO mri2012_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kia kohia hoki ngā kai katoa o ēnei tau pai e haere ake nei, kia āmitia mai hoki he wīti ki raro i te ringa o Parao, kia tohungia anō hoki he kai i roto i ngā pā. ");
INSERT INTO mri2012_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nā, ka pae taua kai mā te whenua mō ngā tau matekai e whitu e puta mai ana ki te whenua o Īhipa; e kore ai e ngaro te whenua i te matekai.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ā, he pai taua mea ki te titiro a Parao, ki te titiro hoki a āna tāngata katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Nā, ka mea a Parao ki āna tāngata, “E kitea rānei e tātou he pēnei, he tangata kei a ia nei te Wairua o te Atua?” ");
INSERT INTO mri2012_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ā, ka mea a Parao ki a Hōhepa, “Nā, kua whakakitea nei e te Atua ēnei mea katoa ki a koe, kāhore hoki he tangata hei rite mōu, te mōhio, te whai whakaaro. ");
INSERT INTO mri2012_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ko koe hei rangatira mō tōku whare, ā, mā tāu kupu tōku iwi katoa e tohutohu; ko te torōna anake te mea e nui ake ai ahau i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ā, ka mea a Parao ki a Hōhepa, “Titiro, kua waiho nei koe e ahau hei rangatira mō te whenua katoa o Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Nā, ka tangohia e Parao tōna mōwhiti i tōna ringa, ā, kuhua ana e ia ki te ringa o Hōhepa, i whakakākahuria hoki ia e ia ki ngā kākahu rīnena pai, ā, whakaheia ana he hei kōura ki tōna kakī. ");
INSERT INTO mri2012_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","I whakaekea anō ia e ia ki runga ki te tuarua o ōna hāriata; ā, ka karangatia e rātou i mua i a ia, “Kia piko te turi!” Ka waiho ia e ia hei rangatira mō te whenua katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","I mea anō a Parao ki a Hōhepa, “Ko Parao ahau, ā, ki te kāhore koe, e kore e ara ake te ringa, te waewae rānei o tētahi i te whenua katoa o Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Nā, ka huaina e Parao te ingoa o Hōhepa. Ko Tawhanatapaneaha; ā, i hōmai anō e ia hei wahine māna, a Ahenata, tamāhine a Potiwhera, tohunga o Ono. Nā, ka haere a Hōhepa ā puta noa i te whenua katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","E toru tekau ngā tau o Hōhepa i tōna tūranga i te aroaro o Parao, o te kīngi o Īhipa. Nā, ka puta atu a Hōhepa i te aroaro o Parao, ā, ka haere ā puta noa i te whenua katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ā, i ngā tau hua e whitu, me te mea he aohanga nā te ringa te hua o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nā, ka kohia e ia ngā kai katoa o ngā tau e whitu i puta ki te whenua o Īhipa, ā, rongoātia ana te kai ki ngā pā. Ko te kai o te māra i tētahi taha, i tētahi taha o te pā, i rongoātia e ia ki taua pā anō. ");
INSERT INTO mri2012_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Heoi, āmitia ana e Hōhepa he wīti, me te mea ko te onepū o te moana, he hira whakaharahara; ā, whakarērea noatia iho e ia te tatau; kāhore hoki i taea te tatau. ");
INSERT INTO mri2012_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nā, ka whānau ngā tama tokorua a Hōhepa, i te mea kāhore anō kia puta noa ngā tau matekai, i whānau hoki i a rāua ko Ahenata tamāhine a Potiwhera tohunga o Ono. ");
INSERT INTO mri2012_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ā, i huaina e Hōhepa te ingoa o te mātāmua ko Mānahi, “Nō te mea,” e kī ana ia, “kua meinga ahau e te Atua kia wareware ki tāku mahi nui katoa, ki te whare katoa anō hoki o tōku pāpā.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ā, i huaina e ia te ingoa o te tuarua ko Ēparaima, “Mōku hoki i meinga e te Atua kia hua ki te whenua o tōku tangihanga.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nā, ka taka ngā tau hua e whitu i puta mai rā ki te whenua o Īhipa, ");
INSERT INTO mri2012_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ā, ka tīmata ngā tau matekai e whitu te puta ake, ka pērā hoki me tā Hōhepa i kōrero ai. Ā, i ngā whenua katoa te matekai; ko te whenua katoa ia o Īhipa i whai taro. ");
INSERT INTO mri2012_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nā, i te matenga o te whenua katoa o Īhipa i te kai, ka tangi te iwi ki a Parao ki te taro mā rātou; ā, ka mea a Parao ki ngā Īhipiana katoa, “Haere ki a Hōhepa; me mea e koutou tāna e mea ai ki a koutou.” ");
INSERT INTO mri2012_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nā, i runga i te mata katoa o te whenua te matekai; ā, ka wāhia e Hōhepa ngā toa katoa, ā, hokona ana e ia ki ngā Īhipiana; he nanakia hoki te matekai i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ā, ka haere ngā whenua katoa ki Īhipa, ki a Hōhepa, ki te hoko wīti; nō te mea he nui rawa te matekai o ngā whenua katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nā, ka kite a Hākopa he wīti kei Īhipa, ka mea a Hākopa ki āna tama, “He aha koutou i tirotiro ai ki a koutou anō?” ");
INSERT INTO mri2012_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I mea anō ia, “Nanā, kua rongo ahau he wīti kei Īhipa; haere iho ki reira, ki te hoko i tētahi mā tātou i reira; kia ora ai tātou, kei mate.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Nā, ka haere ngā tuākana kotahi tekau o Hōhepa ki raro, ki Īhipa, ki te hoko wīti. ");
INSERT INTO mri2012_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ko Pineamine ia, teina o Hōhepa, kīhai i tonoa e Hākopa i roto i ōna tuākana; i mea hoki ia, “Kei pono tētahi aituā ki a ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ā, ka haere ngā tama a Īharaira ki te hoko i roto i te hunga i haere; he matekai hoki tō te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Nā, ko Hōhepa te kāwana o te whenua, ko ia te kaihoko ki ngā tāngata katoa o te whenua. Nā, ka haere mai ngā tuākana o Hōhepa, ā, ka piko ō rātou kanohi ki te whenua i tōna aroaro. ");
INSERT INTO mri2012_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ā, i te kitenga o Hōhepa i ōna tuākana, ka mōhio ia ki a rātou, otiia ka whakatangata kē ia ki a rātou, ka kōrero whakatuma ki a rātou; ka mea hoki ki a rātou, “I haere mai koutou i hea?” Ā, ka mea rātou, “I te whenua o Kanaana, ki te hoko kai.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ā, i mōhio a Hōhepa ki ōna tuākana ko rātou ia kīhai i mōhio ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nā, ka mahara a Hōhepa ki ngā moe i moe ai ia mō rātou, ā, ka mea ki a rātou, “He tūtei koutou; he whakataki i te wāteatanga o te whenua i haere mai ai koutou!” ");
INSERT INTO mri2012_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ā, ka mea rātou ki a ia, “Kāhore, e tōku ariki, engari i haere mai āu pononga ki te hoko kai. ");
INSERT INTO mri2012_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","He tama katoa mātou nā te tangata kotahi; he hunga pono mātou, ehara āu pononga i te tūtei.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ā, ka mea ia ki a rātou, “Kāhore, engari he whakataki i te wāteatanga o te whenua i haere mai ai koutou.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ā, ka mea rātou, “Kotahi tekau mā rua āu pononga, he tēina, he tuākana mātou, he tama nā te tangata kotahi, nō te whenua o Kanaana. Ko te whakaotinga kei tō mātou pāpā ināianei, ko tētahi kua kāhore.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nā, ko te meatanga a Hōhepa ki a rātou, “Ko ia tāku i kōrero ai ki a koutou, i mea ai, ‘He tūtei koutou.’ ");
INSERT INTO mri2012_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mā konei ka mōhiotia ai koutou: e ora ana a Parao e kore koutou e haere atu i konei, ki te kāhore tō koutou whakaotinga e haere mai ki konei. ");
INSERT INTO mri2012_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tukua atu tētahi o koutou ki te tiki i tō koutou teina, ko koutou hoki, ka herea koutou, kia mōhiotia ai ā koutou kōrero, he pono rānei tā koutou. Ā, ki te kāhore, e ora ana a Parao, inā, he tūtei koutou.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Nā, ka huihuia rātou e ia kia tiakina, e toru ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ā, i te toru o ngā rā ka mea a Hōhepa ki a rātou, “Ko tēnei tā koutou e mea ai kia ora ai koutou; he tangata wehi hoki ahau i te Atua: ");
INSERT INTO mri2012_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ki te mea he hunga pono koutou, me here tētahi o ō koutou tuākana i roto i te whare i tiakina ai koutou; otiia, me haere koutou ki te kawe wīti mō te matekai o ō koutou whare. ");
INSERT INTO mri2012_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ā, me kawe mai tō koutou teina, te whakaotinga, ki ahau; kia whakatikaia ai ā koutou kupu; ā, e kore koutou e mate.” Ā pēnā ana rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ā, ka mea rātou tētahi ki tētahi, “He pono kua whai hara tātou i tō tātou teina; i kite hoki tātou i te mamae o tōna wairua, i a ia i īnoi ai ki a tātou, ā, kīhai tātou i whakarongo atu; nā reira hoki i puta mai ai tēnei hē ki a tātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Nā, ka whakahoki a Reupena ki a rātou, ka mea, “Kāhore ianei ahau i kī atu ki a koutou, i mea, ‘Kaua e hara ki te tamaiti’; ā, kīhai koutou i rongo? Nā, ko ōna toto anō hoki tēnei te whakatakina nei.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ā, kīhai rātou i mōhio e rongo ana a Hōhepa; nō te mea he kaiwhakamāori hoki i waenganui i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Nā, ka tahuri kē atu ia i a rātou, ā, ka tangi. Ka hoki anō ia ki a rātou, ka kōrero ki a rātou, ka tango hoki i a Himiona i roto i a rātou, ā, herea ana e ia ki tō rātou aroaro. ");
INSERT INTO mri2012_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nā, ka whakahaua e Hōhepa kia whakakīia ā rātou pēke ki te wīti, kia whakahokia atu ngā moni a tēnei, a tēnei, ki ā rātou pēke, kia hoatu anō hoki ki a rātou he ō ki te ara; nā, pērā ana ia ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Nā, ka utaina e rātou ā rātou wīti ki ā rātou kāihe, ā, haere atu ana i reira. ");
INSERT INTO mri2012_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ā, i te whakatuwheratanga a tētahi o rātou i tāna pēke kia hoatu he kai mā tana kāihe i te whare tira, ka kitea e ia tāna moni; nā, kei te waha tonu o tāna pēke. ");
INSERT INTO mri2012_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ā, ka mea ia ki ōna tuākana, “Kua whakahokia mai tāku moni; ā, tēnei anō kei roto i tāku pēke.” Nā, kore ake ō rātou ngākau, ā, ka tahuri rātou me te wiri, ka mea tētahi ki tētahi, “He mahi aha tēnei a te Atua ki a tātou?” ");
INSERT INTO mri2012_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nā, ka tae rātou ki a Hākopa, ki tō rātou pāpā, ki te whenua o Kanaana, ā, ka kōrerotia ki a ia ngā mea katoa i pono ki a rātou; ka mea, ");
INSERT INTO mri2012_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“I kōrero whakatuma mai te rangatira o te whenua ki a mātou; i kīia anō mātou e ia he tūtei mō te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ā, ka mea mātou ki a ia, ‘He tangata pono mātou; ehara mātou i te tūtei. ");
INSERT INTO mri2012_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kotahi tekau mā rua mātou, he tuākana, he tēina, he tama nā tō mātou pāpā; kotahi kua kore, kei tō mātou pāpā hoki te whakaotinga ināianei, kei te whenua o Kanaana.’ ");
INSERT INTO mri2012_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Nā, ko te meatanga mai a taua tangata, a te rangatira o te whenua, ki a mātou, ‘Mā tēnei e mōhio ai ahau he hunga pono koutou; me waiho e koutou tētahi o ō koutou tuākana ki ahau, ā, me mau atu e koutou he kai mō te matekai o ō koutou whare, ā, ka haere. ");
INSERT INTO mri2012_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ā, me kawe mai tō koutou teina, te whakaotinga, ki ahau, kia mōhio ai ahau ehara koutou i te tūtei, engari he hunga pono koutou. Pēnei ka hoatu e ahau tō koutou tuakana ki a koutou, ā, ka hokohoko koutou ki tēnei whenua.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ā, i a rātou e ringiringi ana i ā rātou pēke, nā, ko te moni a tēnei, a tēnei e takai ana i roto i ā rātou pēke; ā, ka kite rātou ko tō rātou pāpā i ngā moni e takai ana, nā, ka wehi rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Nā, ka mea a Hākopa, tō rātou pāpā, ki a rātou, “Ka whakapania ahau e koutou: ko Hōhepa kua kāhore, ko Himiona hoki kua kāhore, ā, ka tangohia nei e koutou a Pineamine. He pēhi mōku ēnei mea katoa.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nā, ka kōrero a Reupena ki tōna pāpā, ka mea, “Whakamatea āku tama tokorua, ki te kāhore ia e kawea mai e ahau ki a koe; hōmai ia ki tōku ringa, ā, māku ia e whakahoki mai ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ā, ka mea ia, “E kore tāku tama e haere tahi i a koutou ki raro; kua mate hoki tōna tuakana, ā, ko ia anake ka mahue nei; ā, ki te pono he aituā ki a ia i te ara e haere nei koutou, kātahi ka meinga tōku koroheketanga e koutou kia heke tangi atu ki te pō.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ā, he tino nui te matekai o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ā, ka pau te wīti i maua mai e rātou i Īhipa, nā, ka mea tō rātou pāpā ki a rātou, “Hoki atu ki te hoko i tētahi wāhi kai mā tātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ā, ka kōrero a Hūrā ki a ia, ka mea, “I tino whakatūpato taua tangata i a mātou, i mea, ‘E kore koutou e kite i tōku mata ki te kāhore tō koutou teina i a koutou.’ ");
INSERT INTO mri2012_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ki te tukua e koe tō mātou teina hei hoa mō mātou, ka haere mātou ki raro ki te hoko kai māu. ");
INSERT INTO mri2012_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ki te kāhore ia e tukua e koe, e kore mātou e haere ki raro. Nō te mea i kī mai taua tangata ki a mātou, ‘E kore koutou e kite i tōku mata ki te kāhore tō koutou teina i a koutou.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Nā, ka mea a Īharaira, “He aha koutou i ngārahu kino ai ki ahau, i whakaatu ai ki taua tangata he teina anō tō koutou?” ");
INSERT INTO mri2012_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ā, ka mea rātou, “I tino ui taua tangata ki ō mātou āhua, ki ō mātou whanaunga hoki, i mea mai, ‘E ora ana anō rānei tō koutou pāpā? Tēnā anō rānei tētahi atu teina o koutou?’ Ā, rite tonu ki ēnei kupu tā mātou i kōrero ai ki a ia; tērā rānei mātou e āta mōhio ka kī mai ia, ‘Kawea mai tō koutou teina ki raro nei’?” ");
INSERT INTO mri2012_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Nā, ka mea a Hūrā ki tōna pāpā, ki a Īharaira, “Tukua te tamaiti ki ahau, ā, ka whakatika mātou, ka haere; kia ora ai tātou, kei mate tahi hoki mātou me koe, me ā mātou pōtiki. ");
INSERT INTO mri2012_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ko ahau hei utu mōna; me rapu ia e koe i tōku ringa. Ki te kāhore ahau e kawe mai i a ia ki a koe, e whakatū hoki i a ia ki tōu aroaro, nā, hei whakahēnga ahau māu i ngā rā katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Me i kāhore hoki mātou i roa nei, kua rua ēnei hokinga mai o mātou ināianei.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kātahi ka mea a Īharaira, tō rātou pāpā ki a rātou, “Ki te mea rā he pēnei te hanga, ko tēnei tā koutou e mea ai: maua atu ētahi o ngā hua papai o te whenua i roto i ā koutou oko, kawea atu hoki he hākari ki raro, ki taua tangata – tētahi wāhi pama, me tētahi wāhi honi, ētahi paihe, me ētahi maira, ētahi nati, me ētahi aramona. ");
INSERT INTO mri2012_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kia takirua hoki ngā hiriwa e maua atu i roto i ō koutou ringa; ko te moni hoki i whakahokia mai i te waha o ā koutou pēke, me whakahoki atu anō tēnā i roto i ō koutou ringa; he pōhēhē noa pea tēnā. ");
INSERT INTO mri2012_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kawea atu anō hoki tō koutou teina, ā, whakatika, hoki atu anō ki taua tangata. ");
INSERT INTO mri2012_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ā, mā te Atua Kaha Rawa e tuku mai ki a koutou kia arohaina mai e taua tangata, kia tonoa mai anō e ia tērā tuakana o koutou, rāua ko Pineamine. Ko ahau hoki, ki te whakapania ahau, ka whakapania ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Nā, ka mau aua tāngata ki taua hākari, e rua hoki ngā moni i maua atu e rātou i roto i ō rātou ringa, me Pineamine hoki; ā, whakatika ana rātou, haere ana ki raro, ki Īhipa, ā, ka tū ki te aroaro o Hōhepa. ");
INSERT INTO mri2012_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ā, ka kitea a Pineamine e Hōhepa i roto i a rātou, nā, ka mea ia ki te kaitohutohu o tōna whare, “Kawea ēnā tāngata ki te whare, patua he kai, takā hoki; ka kai tahi hoki mātou ko ēnā tāngata ina tū te rā.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nā, ka meatia e taua tangata tā Hōhepa i kī ai; ā, ka kawea aua tāngata e taua tangata ki te whare o Hōhepa. ");
INSERT INTO mri2012_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nā, ka wehi aua tāngata, mō rātou i kawea ki te whare o Hōhepa; ā, ka mea rātou, “Mō te moni i whakahokia i roto i ā tātou pēke i te haerenga tuatahi i kawea mai ai tātou; kia whai take mai ai ia ki a tātou, mō tāna rere mai ki a tātou ki te tango i a tātou hei pononga, me ā tātou kāihe hoki.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Nā, ka whakatata rātou ki te kaitohutohu o te whare o Hōhepa, ka kōrero ki a ia i te kūwaha o te whare, ");
INSERT INTO mri2012_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ka mea, “E te ariki, i haere mai anō mātou i mua ki te hoko kai. ");
INSERT INTO mri2012_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ā, nō tō mātou taenga ki te whare tira, i tā mātou whakatuwheratanga i ā mātou pēke, nā, ko te moni a tēnei, a tēnei, i te waha o tāna pēke, tā mātou moni, rite tonu te taimaha; ā, kua whakahokia mai taua mea e mātou i roto i ō mātou ringa. ");
INSERT INTO mri2012_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kua kawea mai anō e mātou i roto i ō mātou ringa tētahi atu moni hei hoko kai. Kāhore mātou e mōhio nā wai rānei i maka ā mātou moni ki ā mātou pēke.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ā, ka mea ia, “Kia tau te rangimārie ki a koutou, kaua e wehi. Nā tō koutou Atua, nā te Atua hoki o tō koutou pāpā i hōmai he taonga ki a koutou ki roto ki ā koutou pēke. I tae mai anō tā koutou moni ki ahau.” Ā, ka kawea e ia a Himiona ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nā, ka kawe taua tangata i aua tāngata ki te whare o Hōhepa, ka hoatu e ia he wai hei horoi mō ō rātou waewae; i hoatu anō e ia he kai mā ā rātou kāihe. ");
INSERT INTO mri2012_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nā, ka takā e rātou te hākari mō te taenga mai o Hōhepa i te awatea; i rongo hoki rātou me kai taro rātou ki reira. ");
INSERT INTO mri2012_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ā, i te taenga mai o Hōhepa ki te whare, ka kawea e rātou ki a ia te hākari a ō rātou ringa ki te whare, ā, ka piko ki a ia ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nā, ka ui ia ki a rātou ki te pai, ka mea, “Kei te pai rānei tō koutou pāpā, te koroheke i kōrerotia mai rā e koutou? E ora ana anō rānei ia?” ");
INSERT INTO mri2012_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ā, ka mea rātou ki a ia, “Kei te pai tāu pononga, tō mātou pāpā, e ora ana anō ia.” Nā, ka tuohu rātou, ka piko iho. ");
INSERT INTO mri2012_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ka maranga tōna kanohi, ka kite ia i a Pineamine, i tōna teina, i te tama a tōna whaea, ā, ka mea, “Ko tō koutou teina tēnei, ko te whakaotinga i kōrerotia rā e koutou ki ahau?” I mea anō ia, “Kia aroha te Atua ki a koe, e tāku tama.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Nā, ka hohoro a Hōhepa; he tokonga ake hoki nō tōna ngākau aroha ki tōna teina; ā, ka rapua e ia tētahi wāhi hei tangihanga. Ā, haere ana ia ki te rūma i roto, ki reira tangi ai. ");
INSERT INTO mri2012_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nā, ka horoia e ia tōna mata, ka puta ki waho, ka whakamanawanui, ka mea, “Whakatakotoria he taro.” ");
INSERT INTO mri2012_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nā, ka whakatakotoria e rātou, māna ki a ia anake, mā rātou ki a rātou anake, mā ngā Īhipiana, i kai tahi me ia, ki a rātou anake. E kore hoki e āhei i ngā Īhipiana te kai taro tahi me ngā Hiperu; he mea whakarihariha hoki tēnā ki ngā Īhipiana. ");
INSERT INTO mri2012_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Nā, ka noho rātou ki tōna aroaro, tō mua rite tonu anō ki tōna muanga, tō muri rite tonu anō ki tōna muringa; ā, mīharo ana aua tāngata tētahi ki tētahi. ");
INSERT INTO mri2012_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nā, ka tuwhaina atu e ia ētahi o ngā wāhi i tōna aroaro mā rātou. He nui rawa ia te wāhi i a Pineamine; me i takirimatia te wāhi a tētahi o rātou kua rite ki tāna. Nā, ka inu rātou, ka koa tahi me ia. ");
INSERT INTO mri2012_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nā, ka whakahau ia ki te kaitohutohu o tōna whare, ka mea, “Whakakīia ngā pēke a aua tāngata ki ngā kai e taea te whawhao ki roto, me maka anō te moni a tēnei, a tēnei, ki te waha o tāna pēke. ");
INSERT INTO mri2012_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Whaowhina hoki tāku kapu, te kapu hiriwa, ki te waha o te pēke a te whakaotinga, me te moni anō mō tāna wīti.” Nā, rite tonu tāna i mea ai ki tā Hōhepa kupu i kī ai. ");
INSERT INTO mri2012_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ā, ka mārama te ata, ka tonoa atu aua tāngata, rātou me ā rātou kāihe. ");
INSERT INTO mri2012_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ā, nō tō rātou haerenga atu i te pā, kīhai i matara, ka mea a Hōhepa ki te kaitohutohu o tōna whare, “Whakatika, whāia aua tāngata; ā, ka mau rātou i a koe, ka mea ki a rātou, ‘He aha i utua ai e koutou te pai ki te kino? ");
INSERT INTO mri2012_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ehara ianei tēnei i te mea e inu ai tōku ariki, i tāna hoki e kite tohu ai ia? Ka kino tā koutou mahi.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Nā, ka mau rātou i a ia, ā, kōrerotia ana e ia aua kupu ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ā, ka mea rātou ki a ia, “He aha ēnei kupu i kōrerotia ai e tōku ariki? Auē, kia meatia tēnei mea e āu pononga. ");
INSERT INTO mri2012_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nanā, ko te moni i kitea e mātou i te waha o ā mātou pēke, i whakahokia mai e mātou ki a koe i te whenua o Kanaana; ā, kia tāhae mātou hei aha i te hiriwa, i te kōura rānei, i roto i te whare o tōu ariki? ");
INSERT INTO mri2012_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ki te mea ka kitea taua mea ki tētahi o āu pononga, kia mate ia, kia waiho anō mātou hei pononga mā tōku ariki.” ");
INSERT INTO mri2012_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ā, ka mea ia, “Kia rite anō hoki āianei ki tā koutou i mea ai: e kitea taua mea ki tētahi, hei pononga ia māku; ā, kāhore he whakahē mō koutou.” ");
INSERT INTO mri2012_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Nā, hohoro tonu tā rātou tuku iho i tāna pēke, i tāna pēke, ki te whenua, ā, whakatuwheratia ana e rātou tāna pēke, tāna pēke. ");
INSERT INTO mri2012_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Nā, ka rapu ia, tīmata i te mātāmua, ā, whakamutu ki te whakaotinga; ā, ka kitea te kapu i roto i te pēke a Pineamine. ");
INSERT INTO mri2012_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nā, ka haehae rātou i ō rātou kākahu, ā, whakawahā ana e rātou tana kāihe, tana kāihe, hoki ana ki te pā. ");
INSERT INTO mri2012_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Nā, ka haere a Hūrā rātou ko ōna tuākana, ko ōna tēina, ki te whare o Hōhepa; ā, i reira tonu ia; ā, tāpapa ana ki te whenua i tōna aroaro. ");
INSERT INTO mri2012_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Nā, ka mea a Hōhepa ki a rātou, “He aha tēnei mea i meatia nei e koutou? Kīhai rānei koutou i mahara he tangata matakite te pēnei me ahau nei?” ");
INSERT INTO mri2012_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Nā, ka mea a Hūrā, “He aha tā mātou e mea ai ki tōku ariki? He aha tā mātou e kōrero ai? Me aha rānei hei whakatika i a mātou? Kua kitea e te Atua te hara o āu pononga; nā, tēnei mātou hei pononga mā tōku ariki, mātou tahi hoki ko te tangata i kitea nei te kapu ki a ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Anō rā ko ia, “Engari, kia meatia tēnei e ahau! Ko te tangata i kitea nei te kapu ki a ia, ko ia hei pononga māku; ko koutou ia, haere mārie koutou ki runga, ki tō koutou pāpā.” ");
INSERT INTO mri2012_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kātahi ka whakatata a Hūrā ki a ia, ka mea, “Tukua tāu pononga, e tōku ariki, kia kōrero i tētahi kupu ki ngā taringa o tōku ariki, kei mura hoki tōu riri ki tāu pononga; ko kōrua hoki ko Parao rite tahi. ");
INSERT INTO mri2012_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","I ui mai tōku ariki ki āna pononga, i mea, ‘He pāpā rānei tō koutou, he teina rānei?’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ā, ka mea mātou ki tōku ariki, ‘He pāpā anō tō mātou, he koroheke, me tētahi tama o tōna koroheketanga, he mea iti; kua mate hoki tōna tuakana, ā, ko ia anake i mahue o ngā tamariki a tōna whaea, e aroha ana hoki tōna pāpā ki a ia.’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Nā, ka mea mai koe ki āu pononga, ‘Kawea mai ia ki raro nei, ki ahau, kia tau atu ai ōku kanohi ki a ia.’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kātahi mātou ka mea ki tōku ariki, ‘E kore e āhei kia whakarērea tōna pāpā e taua tamaiti. Nō te mea ka mate tōna pāpā ki te mahue i a ia.’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nā, ka mea koe ki āu pononga, ‘Ki te kāhore tō koutou teina, te whakaotinga, e haere tahi mai i a koutou ki raro nei, e kore koutou e kite i tōku kanohi ā muri ake nei.’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ā, i tō mātou haerenga ki runga, ki tāu pononga, ki tōku pāpā, nā, ka kōrerotia e mātou ngā kupu a tōku ariki ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Ā, ka mea mai tō mātou pāpā, ‘Hoki atu ki te hoko i tētahi wāhi kai mā tātou.’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nā, ka mea mātou, ‘E kore e āhei ki a mātou te haere ki raro. Ki te mea kei a mātou tō mātou teina, te whakaotinga, nā, ka haere mātou ki raro; nō te mea hoki e kore e taea e mātou te titiro ki te kanohi o taua tangata, ki te kāhore tō mātou teina, te whakaotinga, i a mātou.’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Nā, ka mea tāu pononga, tōku pāpā, ki a mātou, ‘E mōhio ana koutou, tokorua ngā tama a māua ko tāku wahine. ");
INSERT INTO mri2012_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ā, i haere atu tētahi i tōku taha, i mea hoki ahau, “He pono kua haea pūtia ia.” Ā, kāhore ahau i kite i a ia ā mohoa noa nei. ");
INSERT INTO mri2012_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ki te tangohia anō hoki tēnei e koutou i tōku aroaro, ā, ka pono he aituā ki a ia, kātahi ka meinga e koutou kia heke tangi atu tōku koroheketanga ki te pō.’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Heoi, ki te haere atu ahau ki tāu pononga, ki tōku pāpā, ā, kāhore taua tamaiti i a mātou; kei roto nei hoki i tōna wairua tōna wairua e paihere ana. ");
INSERT INTO mri2012_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Nā, kei tōna kitenga kua kore tēnei tama, ka mate ia; ā, ka meinga e mātou, e āu pononga, te koroheketanga o tāu pononga, o tō mātou pāpā, kia heke tangi atu ki te pō. ");
INSERT INTO mri2012_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","I waiho hoki tāu pononga hei utu mō tēnei tama ki tōku pāpā, i mea ahau, ‘Ki te kāhore ia e kawea mai e ahau ki a koe, nā, hei whakahēnga ahau mā tōku pāpā i ngā rā katoa.’ ");
INSERT INTO mri2012_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Heoi, kia noho rā tāu pononga āianei hei utu mō tēnei tama, hei pononga mā tōku ariki; ā, kia haere tahi te tama i ōna tuākana ki runga. ");
INSERT INTO mri2012_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Me pēhea hoki ahau e haere ai ki runga, ki tōku pāpā, ki te kāhore te tama i ahau? Kei kite ahau i te kino e pā ana ki tōku pāpā.” ");
INSERT INTO mri2012_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Nā, kīhai i taea e Hōhepa te whakamanawanui i te aroaro o te hunga katoa e tū ana i tōna taha; ā, ka karanga ia, “Haere katoa atu ngā tāngata i tōku taha.” Ā, kīhai i tū tētahi tangata i tōna taha, i a Hōhepa e whakaatu ana i a ia ki ōna tuākana. ");
INSERT INTO mri2012_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nā, he nui tōna reo ki te tangi; ā, ka rongo ngā Īhipiana, ka rongo anō hoki te whare o Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Nā, ka mea a Hōhepa ki ōna tuākana, “Ko Hōhepa ahau; e ora ana anō rānei tōku pāpā?” Ā, kīhai ōna tuākana i āhei te whakahoki kupu ki a ia; i pororaru hoki rātou i tōna aroaro. ");
INSERT INTO mri2012_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ā, ka mea a Hōhepa ki ōna tuākana, “Whakatata mai rā ki ahau.” Ā, ka whakatata rātou. Ā, ka mea ia, “Ko Hōhepa ahau, ko tō koutou teina i hokona nei e koutou ki Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nā, kaua rā e pōuri, kaua hoki e mumura ō koutou kanohi, mō koutou i hoko i ahau ki konei; nō te mea he mea tono mai ahau e te Atua ki mua i a koutou hei whakaora tāngata. ");
INSERT INTO mri2012_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ka rua hoki ēnei tau o te matekai ki te whenua; kei muri anō ētahi atu tau e rima, e kore ai e parau, e kore ai e kokoti. ");
INSERT INTO mri2012_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kua tonoa mai nei hoki ahau e te Atua ki mua i a koutou kia whai putanga ai koutou ki te ao, kia ora ai hoki koutou i runga i te whakaoranga nui. ");
INSERT INTO mri2012_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Inā, ehara i a koutou nāna ahau i tono mai ki konei, engari nā te Atua. Kua waiho hoki ahau e ia hei matua ki a Parao, hei ariki anō mō tōna whare katoa, hei kāwana hoki mō te whenua katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hohoro, haere ki runga, ki tōku pāpā, mea atu ki a ia, ‘He pēnei te kupu a tāu tama a Hōhepa, Kua meinga ahau e te Atua hei ariki mō Īhipa katoa; haere mai ki ahau, kaua e whakaroa. ");
INSERT INTO mri2012_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ā, me noho koe ki te whenua o Kohena, ā, ka tata koe ki ahau, koutou ko āu tama, ko ngā tama hoki a āu tama, me āu kāhui, me āu kau, me āu mea katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ā, ka atawhai ahau i a koe ki reira – e rima hoki ēnei tau matekai kei muri nei – kei rawakoretia koutou ko tōu whare me āu mea katoa.’ ");
INSERT INTO mri2012_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Nā, ka kite nei ō koutou kanohi, me ngā kanohi o tōku teina, o Pineamine, ko tōku waha tēnei te kōrero nei ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ā, mā koutou e kōrero ki tōku pāpā tōku korōria katoa i Īhipa, me ngā mea katoa i kite nei koutou; kia hohoro anō tā koutou kawe mai i tōku pāpā ki konei.” ");
INSERT INTO mri2012_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Nā, ka hinga ia ki runga ki te kakī o Pineamine, o tōna teina, ā, ka tangi, ka tangi anō a Pineamine i runga i tōna kakī. ");
INSERT INTO mri2012_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ā, ka kihi ia i ōna tuākana katoa, ka tangi hoki ki a rātou. Ā muri iho ka kōrero ōna tuākana ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nā, ka tae te rongo ki te whare o Parao, ka kōrerotia, “Kua tae mai ngā tuākana o Hōhepa.” He mea pai anō tēnā ki te whakaaro o Parao, o āna tāngata hoki. ");
INSERT INTO mri2012_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Nā, ka mea a Parao ki a Hōhepa, “Kōrero ki ōu tuākana, ‘Ko tēnei tā koutou e mea ai: whakawahā ā koutou kararehe, ā, whakatika, haere ki te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Tīkina hoki tō koutou pāpā, me ngā tāngata o ō koutou whare, ā, haere mai ki ahau; ā, ka hoatu e ahau ki a koutou ngā mea papai o te whenua o Īhipa, ā, ka kai koutou i te mōmonatanga o te whenua.’ ");
INSERT INTO mri2012_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Nā, kua whakahaua nei koe, meatia tēnei e koutou, ‘Mauria atu ētahi kāta mā koutou i te whenua o Īhipa mō ā koutou tamariki, mō ā koutou wāhine, ā, kawea mai tō koutou pāpā, haere mai hoki. ");
INSERT INTO mri2012_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ā, kaua e whakaaro ki ā koutou mea; mā koutou hoki ngā mea pai o te whenua katoa o Īhipa.’ ” ");
INSERT INTO mri2012_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Nā, ka pērā ngā tama a Īharaira, ā, ka hōmai he kāta e Hōhepa ki a rātou, ka pērā me tā Parao i kī ai, i hōmai anō e ia he ō mō rātou ki te ara. ");
INSERT INTO mri2012_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","I hōmai anō hoki e ia ki a rātou katoa he whakatakirua mō ngā kākahu o tētahi, o tētahi; ki a Pineamine ia i hōmai e ia e toru rau hiriwa, takirima anō hoki ngā kākahu. ");
INSERT INTO mri2012_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ā, ko ngā mea tēnei i hōmai e ia kia kawea ki tōna pāpā; kotahi tekau ngā kāihe e waha ana i ngā mea papai o Īhipa, me ngā kāihe uha kotahi tekau, ko tā rātou kawenga he wīti, he taro, hei kai mā tōna pāpā ki te ara. ");
INSERT INTO mri2012_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Nā, ka tonoa atu e ia ōna tuākana, ā, haere ana rātou; ka mea hoki ia ki a rātou, “Kei ngangau koutou ki te ara.” ");
INSERT INTO mri2012_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nā, haere ana rātou i Īhipa ki runga, ā, ka tae ki te whenua o Kanaana, ki a Hākopa, ki tō rātou pāpā, ");
INSERT INTO mri2012_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ā, ka kōrero ki a ia, ka mea, “E ora ana anō a Hōhepa, ko ia hoki te kāwana o te whenua katoa o Īhipa.” Nā, ka whakapau te manawa o Hākopa, kīhai hoki ia i whakapono ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nā, ka kōrerotia e rātou ki a ia ngā kupu katoa a Hōhepa i kōrero ai ia ki a rātou; ā, ka kite ia i ngā kāta i tukua mai e Hōhepa hei tiki mai mōna, nā, ka ora ake te wairua o Hākopa, o tō rātou pāpā; ");
INSERT INTO mri2012_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ā, kātahi a Īharaira ka mea, “Heoi anō; e ora ana anō tāku tama, a Hōhepa. Ka haere ahau kia kite i a ia keiwhā mate ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nā, ka tūria e Īharaira me āna mea katoa, ā, ka tae ki Peerehepa, ā, ka patua e ia ētahi patunga tapu mā te Atua o tōna pāpā, o Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nā, ka kōrero moemoeā te Atua ki a Īharaira i te pō, ka mea, “E Hākopa, e Hākopa.” Ā, ka mea ia, “Tēnei ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ā, ka mea ia, “Ko te Atua ahau, ko te Atua o tōu pāpā; kaua e wehi ki te haere ki raro, ki Īhipa; ka meinga hoki koe e ahau hei iwi nui ki reira. ");
INSERT INTO mri2012_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ka haere tahi ahau i a koe ki raro, ki Īhipa; māku anō koe e whakahoki mai ki runga nei; ā, mā te ringa o Hōhepa e pēhi ōu kanohi.” ");
INSERT INTO mri2012_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Nā, ka whakatika atu a Hākopa i Peerehepa, ā, ka kawea a Hākopa, tō rātou pāpā, e ngā tama a Īharaira, me ā rātou tamariki, me ā rātou wāhine, i runga i ngā kāta i tukua mai e Parao hei tiki atu i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","I kawea anō e rātou ā rātou kararehe, me ā rātou taonga i whiwhi ai ki te whenua o Kanaana, ā, haere ana ki Īhipa a Hākopa rātou tahi ko ōna uri katoa, ");
INSERT INTO mri2012_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ko āna tama; ko ngā tama hoki a āna tama, ko āna tamāhine, me ngā tamāhine a āna tama, me ōna uri katoa i kawea e ia ki Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nā, ko ngā ingoa ēnei o ngā tama a Īharaira, i haere nei ki Īhipa, ko Hākopa rātou ko āna tama. Ko Reupena, mātāmua a Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ko ngā tama a Reupena: ko Hanoka, ko Paru, ko Heterono, ko Karami. ");
INSERT INTO mri2012_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ko ngā tama a Himiona: ko Iemuere, ko Iamini, ko Ohara, ko Iakini, ko Tohara, rātou ko Hauru, ko te tama a tētahi wahine Kanaani. ");
INSERT INTO mri2012_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ko ngā tama a Rīwai: ko Kerehona, ko Kohata, ko Merari. ");
INSERT INTO mri2012_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ko ngā tama a Hūrā: ko Ere, ko Onana, ko Heraha, ko Parete, ko Tera (ko Ere ia rāua ko Onana i mate ki te whenua o Kanaana). Ko ngā tama a Parete: ko Heterono rāua ko Hāmuru. ");
INSERT INTO mri2012_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ko ngā tama a Ihākara: ko Tora, ko Puwa ko Hopa, ko Himirono. ");
INSERT INTO mri2012_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ko ngā tama a Hepurona: ko Herete, ko Erono, ko Iahareere. ");
INSERT INTO mri2012_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ko ngā tama ēnei a Rea, i whānau nei i a rāua ko Hākopa ki Paranārama, rātou ko tāna tamāhine Rina. E toru tekau mā toru ngā wairua katoa o āna tama, o āna tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ko ngā tama a Kara: ko Hipiona, ko Haki, ko Huni, ko Etepono, ko Eri, ko Arori, ko Areri. ");
INSERT INTO mri2012_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ko ngā tama a Āhera: ko Imina, ko Ihua, ko Ihui, ko Peria, rātou ko Hera, ko tō rātou tuahine. Ko ngā tama a Peria: ko Hēpere rāua ko Marakiere. ");
INSERT INTO mri2012_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ko ngā tama ēnei a Tiripa, a tērā i hōmai nei e Rāpana ki a Rea, ki tāna tamāhine, i whānau nei i a rāua ko Hākopa; kotahi tekau mā ono wairua. ");
INSERT INTO mri2012_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ko ngā tama a Rahera, wahine a Hākopa: ko Hōhepa rāua ko Pineamine. ");
INSERT INTO mri2012_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ā, whānau ake a Hōhepa i te whenua o Īhipa, ko Mānahi rāua ko Ēparaima, he whānau ēnei nā rāua ko Ahenata, tamāhine a Potiwhera tohunga o Ono. ");
INSERT INTO mri2012_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ko ngā tama a Pineamine: ko Pera, ko Pekere, ko Ahapere, ko Kera, ko Naamana, ko Ehi, ko Roho, ko Mupimi, ko Hupimi, ko Arare. ");
INSERT INTO mri2012_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ko ngā tama ēnei a Rahera, i whānau nei mā Hākopa; ko ngā wairua katoa kotahi tekau mā whā. ");
INSERT INTO mri2012_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ko ngā tama a Rāna: ko Huhimi. ");
INSERT INTO mri2012_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ko ngā tama a Napatari: ko Iahateere, ko Kuni, ko Iētere, ko Hireme. ");
INSERT INTO mri2012_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ko ngā tama ēnei a Piriha, a tērā i hōmai nei e Rāpana ki tāna tamāhine, ki a Rahera, ā, whānau ake ēnei i a rāua ko Hākopa; e whitu aua wairua katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ko ngā wairua katoa i haere tahi nei i a Hākopa ki Īhipa, i puta mai nei i roto i tōna hope, e ono tekau mā ono ngā wairua katoa; hāunga ngā wāhine a ngā tama a Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ko ngā tama a Hōhepa, i whānau nei māna ki Īhipa, e rua ngā wairua, e whitu tekau ngā wairua katoa o te whare o Hākopa i haere nei ki Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nā, ka tonoa e ia a Hūrā ki mua a ia, ki a Hōhepa, hei ārahi i a ia ki Kohena; ā, ka tae rātou ki te whenua o Kohena. ");
INSERT INTO mri2012_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Nā, ka whakanohoia e Hōhepa tōna hāriata, ā, haere ana ki te whakatau i tōna pāpā, i a Īharaira ki Kohena. Ā, ka tae atu ki tōna aroaro, nā, ka hinga ia ki runga ki tōna kakī, ā, he roa tāna tangihanga i runga i tōna kakī. ");
INSERT INTO mri2012_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Nā, ka mea a Īharaira ki a Hōhepa, “He pai ki te mate ahau āianei, nōku hoki ka kite i tōu mata, nō te mea e ora ana anō koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Nā, ka mea a Hōhepa ki ōna tuākana, ki te whare anō hoki o tōna pāpā, “Ka haere ahau ki runga, ki te kōrero ki a Parao, ki te mea ki a ia, ‘Kua tae mai ki ahau ōku tuākana, me te whare o tōku pāpā, i noho rā i te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nā, he hēpara aua tāngata, he hunga whāngai kararehe rātou; kua kawea mai anō e rātou ā rātou kāhui, ā rātou kau, me ā rātou mea katoa.’ ");
INSERT INTO mri2012_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ā, ka karanga a Parao i a koutou, ka mea, ‘He aha tā koutou mahi?’ ");
INSERT INTO mri2012_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Me kī atu e koutou, ‘He hunga whāngai kararehe āu pononga, o tō mātou taitamarikitanga ake ā mohoa noa nei, mātou, me ō mātou mātua’ – kia noho ai koutou ki te whenua o Kohena; nō te mea hoki he mea whakarihariha ki ngā Īhipiana ngā hēpara katoa.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Nā, ka haere a Hōhepa, ka kōrero ki a Parao, ka mea, “Kua tae mai tōku pāpā me ōku tuākana, me ā rātou kāhui, ā rātou kau, ā rātou mea katoa, i te whenua o Kanaana; nā, kei te whenua rātou o Kohena.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Nā, ka tango ia i ētahi o ōna tuākana, tokorima, ā, whakatūria ana rātou e ia ki te aroaro o Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ā, ka mea a Parao ki ōna tuākana, “He aha tā koutou nā mahi?” Ā, ka mea rātou ki a Parao, “He hēpara āu pononga, mātou me ō mātou mātua.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","I mea anō rātou ki a Parao, “He noho ki tēnei whenua i haere mai ai mātou; nō te mea kāhore he kai mā ngā hipi a āu pononga; he nui hoki te matekai o te whenua o Kanaana; koia rā kia noho āu pononga ki te whenua o Kohena.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Nā, ka kōrero a Parao ki a Hōhepa, ka mea, “Kua tae mai nei tōu pāpā me ōu tuākana ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Kei tōu aroaro te whenua o Īhipa; whakanohoia e koe tōu pāpā me ōu tuākana ki te wāhi pai o te whenua; kia noho rātou ki te whenua o Kohena. Ki te mea hoki e mōhiotia ana e koe ētahi tāngata pakari i roto i a rātou, meinga rātou hei rangatira mō āku kararehe.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Nā, ka kawea mai a Hākopa, tōna pāpā, e Hōhepa, ka whakatūria ki te aroaro o Parao; ā, ka manaaki a Hākopa i a Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ā, ka mea a Parao ki a Hākopa, “Ka hia ōu tau?” ");
INSERT INTO mri2012_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ka mea a Hākopa ki a Parao, “Ka kotahi rau e toru tekau tau ngā rā o ngā tau o tōku noho manene. He torutoru, ā, he kino ngā rā o ngā tau o tōku ora, kīhai anō hoki i rite ki ngā rā o ngā tau o te ora o ōku mātua, i ngā rā i noho manene ai rātou.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Nā, ka manaaki a Hākopa i a Parao, ā, puta atu ana i te aroaro o Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Nā, ka whakanohoia e Hōhepa tōna pāpā me ōna tuākana, ā, hoatu ana e ia ki a rātou he kāinga i te whenua o Īhipa, i te wāhi pai rawa o te whenua, i te whenua o Ramehehe, pērā me tā Parao i whakahau ai. ");
INSERT INTO mri2012_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nā, ka atawhai a Hōhepa i tōna pāpā, rātou ko ōna tuākana, ko te whare katoa anō hoki o tōna pāpā ki te taro, he mea whakarite tonu ki ō rātou hapū. ");
INSERT INTO mri2012_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ā, kāhore he taro o te whenua katoa; he nui rawa hoki te matekai; ā, hemo noa iho te whenua o Īhipa i te matekai, me te whenua hoki o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ā, kohia ana e Hōhepa te moni katoa i kitea ki te whenua o Īhipa, ki te whenua hoki o Kanaana, mō te wīti i hokona e rātou; ā, kawea ana e Hōhepa te moni ki te whare o Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ā, nō te potonga o te moni o te whenua o Īhipa, o te whenua hoki o Kanaana, nā, ka haere ngā Īhipiana katoa ki a Hōhepa, ka mea, “Hōmai he taro ki a mātou; kia mate hoki mātou ki tōu aroaro hei aha? Kua poto nei hoki te moni.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Nā, ka mea a Hōhepa, “Hōmai ā koutou kararehe; ā, ka hoatu e ahau hei utu mō ā koutou kararehe, i te mea kua poto te moni.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Nā, ka kawea mai e rātou ā rātou kararehe ki a Hōhepa; ā, hoatu ana e Hōhepa he taro ki a rātou hei utu mō ngā hōiho, mō ngā kāhui hipi, mō ngā kāhui kau, mō ngā kāihe. Ā, whāngaia ana rātou e ia ki te taro i taua tau, hei utu mō ā rātou kararehe katoa. ");
INSERT INTO mri2012_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ā, nō te takanga o taua tau, ka haere mai rātou ki a ia i te rua o ngā tau, ka mea ki a ia, “E kore e hunā e mātou i tōku ariki, kua poto te moni; kei tōku ariki hoki ā mātou kāhui kararehe; kāhore he mea e toe ana hei tirohanga mā tōku ariki, ko ō mātou tinana anake, me ō mātou oneone. ");
INSERT INTO mri2012_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kia mate mātou ki tōu aroaro hei aha? Mātou tahi hoki me tō mātou oneone? Hokona mātou me tō mātou oneone ki te taro, ā, ka riro mātou me tō mātou oneone hei pononga mā Parao. Hōmai anō hoki he purapura, ā, ka ora mātou, ā, e kore e mate, e kore anō hoki e ururuatia te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Nā, ka hokona e Hōhepa te oneone katoa o Īhipa mō Parao. I hokona hoki e ngā Īhipiana tāna māra, tāna māra; he pēhi rawa hoki nā te matekai i a rātou. Ā, riro ana te whenua i a Parao; ");
INSERT INTO mri2012_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","tēnā ko ngā tāngata, i whakawhitiwhitia e ia ki ngā pā, i tētahi pito o ngā rohe o Īhipa ā puta noa ki tētahi pito o reira. ");
INSERT INTO mri2012_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ko te oneone anake ia o ngā tohunga kīhai i hokona e ia; i whakaritea hoki tētahi wāhi e Parao mā ngā tohunga, ā, i kai rātou i tā rātou wāhi i hōmai e Parao mā rātou; koia tē hokona ai e rātou ō rātou oneone. ");
INSERT INTO mri2012_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ā, ka mea a Hōhepa ki te iwi, “Nanā, kua hokona nei koutou e ahau ināianei, me tō koutou oneone, mā Parao. Nā, he purapura mā koutou, ruia te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ā, ka whai hua ā mua, me hōmai e koutou te rima o ngā wāhi ki a Parao, ā, mā koutou ngā wāhi e whā, hei purapura mō te māra, hei kai hoki mā koutou, mā te hunga hoki i roto i ō koutou whare, hei kai anō hoki mā ā koutou tamariki.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ā, ka mea rātou, “Ka ora mātou i a koe; kia manakohia mātou e tōku ariki, hei pononga mātou mā Parao.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nā, ka whakatakotoria te tikanga e Hōhepa mō te oneone o Īhipa ā tae noa mai ki tēnei rā, mā Parao te rima o ngā wāhi; hāunga ia te oneone o ngā tohunga, kīhai hoki tēnā i riro i a Parao. ");
INSERT INTO mri2012_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nā, ka noho a Īharaira ki te whenua o Īhipa, ki te whenua o Kohena; ka whai kāinga rātou ki reira, ka hua, ka nui whakaharahara. ");
INSERT INTO mri2012_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ā, kotahi tekau mā whitu ngā tau i ora ai a Hākopa ki te whenua o Īhipa; ā, kotahi rau e whā tekau mā whitu ngā tau o te oranga o Hākopa. ");
INSERT INTO mri2012_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Nā, ka whakatata ngā rā o Īharaira e mate ai ia; ā, ka karanga i tāna tama, i a Hōhepa, ka mea ki a ia, “Nā, ki te mea ka manakohia ahau e koe, tēnā, whakapākia mai tōu ringa ki raro i tōku hūhā, ā, whakaputaina mai he aroha, he pono ki ahau; kaua rā ahau e tanumia ki Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Engari, kia takoto ahau ki ōku mātua, me kawe atu ahau e koe i Īhipa, me tanu hoki ki tō rātou urupā.” Ā, ka mea ia, “Ka rite i ahau tāu kupu.” ");
INSERT INTO mri2012_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ā, ka mea ia ki a ia, “Oati mai ki ahau.” Ā, oati ana ia ki a ia, ā, ka piko a Īharaira ki runga ki te urunga o te moenga. ");
INSERT INTO mri2012_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nā, i muri i ēnei mea, ka kōrerotia ki a Hōhepa, “Nanā, e mate ana tōu pāpā.” Ā, ka tango ia i āna tamariki tokorua, i a Mānahi rāua ko Ēparaima, hei hoa mōna. ");
INSERT INTO mri2012_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ā, ka kōrerotia ki a Hākopa, ka meatia, “Nā, ko Hōhepa, ko tāu tama, tēnei te haere mai nei ki a koe,” nā, ka whakakaha ake a Īharaira i a ia, ā, ka noho ki runga i te moenga. ");
INSERT INTO mri2012_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Nā, ka mea a Hākopa ki a Hōhepa, “I puta mai te Atua Kaha Rawa ki ahau i Rutu, i te whenua o Kanaana, i manaaki i ahau, ");
INSERT INTO mri2012_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","i mea anō ki ahau, ‘Nā, ka meinga koe e ahau kia hua, ka whakanui ahau i a koe, ka meinga hoki koe e ahau hei huinga iwi; ā, ka hoatu e ahau tēnei whenua ki ōu uri i muri i a koe hei kāinga pūmau.’ ");
INSERT INTO mri2012_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Nā, ko āu tama tokorua, ko Ēparaima rāua ko Mānahi, i whānau nei māu ki te whenua o Īhipa i mua ake o tōku taenga mai ki a koe, ki Īhipa, māku ēnā; ka riro mai rāua i ahau, ka pērā anō me Reupena rāua ko Himiona. ");
INSERT INTO mri2012_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ā, ko tāu whānau e whānau māu i muri i a rāua, māu ēnā; ka huaina ki a rātou te ingoa o ō rātou tuākana i tō rātou kāinga pūmau. ");
INSERT INTO mri2012_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ko ahau hoki, i tōku haerenga mai i Parana, ka mate a Rahera ki tōku taha, ki te whenua o Kanaana, ki te ara, e takoto mai ana he wāhi e haere atu ai ki Ēparata; ā, tanumia ana e ahau ki reira ki te ara ki Ēparata” (arā ki Pēterehema). ");
INSERT INTO mri2012_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ā, ka kite a Īharaira i ngā tama a Hōhepa, ka mea, “Ko wai ēnei?” ");
INSERT INTO mri2012_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ā, ka mea a Hōhepa ki tōna pāpā, “Ko āku tama ēnei i hōmai e te Atua ki ahau i konei.” Ka mea ia, “Nekehia mai nei ki ahau, kia manaaki ai ahau i a rāua.” ");
INSERT INTO mri2012_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Nā, he atarua ngā kanohi o Īharaira, nā, te koroheke hoki, kīhai ia i āhei te kite atu. Nā, ka whakatata ia i a rāua ki a ia, ā, ka kihi ia i a rāua, ka awhi hoki i a rāua. ");
INSERT INTO mri2012_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Nā, ka mea a Īharaira ki a Hōhepa, “Kīhai ahau i mea ka kite ahau i tōu mata. Kua whakakitea mai nei anō hoki e te Atua ōu uri ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Nā, ka nekehia atu rāua e Hōhepa i roto i ōna turi, ā, ka piko tōna mata ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Nā, ka puritia rāua e Hōhepa, a Ēparaima e tōna ringa matau ki te mauī o Īharaira, a Mānahi e tōna mauī ki te matau o Īharaira, ā, ka whakatata atu ia i a rāua ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Nā, ka torona e Īharaira tōna ringa matau, ā, whakatakotoria ana e ia ki runga ki te mātenga o Ēparaima, ko ia anō hoki te teina, me tōna ringa mauī hoki ki runga ki te mātenga o Mānahi, he āta whakatakoto hoki nāna i ōna ringa, ko Mānahi hoki te mātāmua. ");
INSERT INTO mri2012_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nā, ka manaaki ia i a Hōhepa, ka mea, “Mā te Atua i hāereere nei ōku mātua, a Āperahama rāua ko Īhaka i tōna aroaro, mā te Atua nāna nei ahau i whāngai i ahau i ora nei ā taea noatia tēnei rā, ");
INSERT INTO mri2012_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","mā te anahera nāna nei ahau i whakaora i roto i ngā hē katoa, e manaaki ēnei tamariki; ā, kia huaina tōku ingoa ki a rāua, me te ingoa hoki o ōku mātua, o Āperahama rāua ko Īhaka; ā, kia tino nui haere rāua i waenganui i te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ā, nō te kitenga o Hōhepa kua whakatakotoria e tōna pāpā tōna matau ki runga ki te mātenga o Ēparaima, ka kino ki tāna titiro; ā, ka whakarewaina ake e ia te ringa o tōna pāpā, kia nekehia atu e ia i te mātenga o Ēparaima ki runga ki te mātenga o Mānahi. ");
INSERT INTO mri2012_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ā, ka mea a Hōhepa ki tōna pāpā, “Kaua e pēnā, e tōku pāpā; ko te tuakana hoki tēnei; whakatakotoria tōu matau ki runga ki tōna mātenga.” ");
INSERT INTO mri2012_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nā, ka whakakāhore tōna pāpā, ka mea, “E mōhio ana ahau, e tāku tama, e mōhio ana ahau. Ka whakatupu iwi anō tēnei, ka nui anō hoki ia. Otiia, ka nui atu tōna teina i a ia, ā, ka waiho ōna uri hei iwi maha.” ");
INSERT INTO mri2012_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nā, ka manaaki ia i a rāua i taua rangi, ka mea, “Ko koe tā Īharaira manaakitanga, ā, ka kōrerotia, ‘Kia meinga koe e te Atua kia rite ki a Ēparaima, kia rite hoki ki a Mānahi.’ ” Nā, ka makā e ia a Ēparaima ki mua i a Mānahi. ");
INSERT INTO mri2012_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nā, ka mea a Īharaira ki a Hōhepa, “Ka mate tēnei ahau; hei a koutou ia te Atua, māna hoki koutou e whakahoki ki te whenua o ō koutou mātua. ");
INSERT INTO mri2012_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nā, kotahi te wāhi ka hoatu nei e ahau mōu, e hira ake ai tōu i tō ōu tuākana, ko tāku hoki i tango ai i ngā Amori ki tāku hoari, ki tāku kōpere.” ");
INSERT INTO mri2012_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Nā, ka karanga a Hākopa ki āna tamariki, ka mea, “Huihui mai, ā, ka kōrerotia e ahau ki a koutou ngā mea e pono ki a koutou i ngā rā ō muri. ");
INSERT INTO mri2012_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Huihui mai, whakarongo hoki, e ngā tama a Hākopa; whakarongo hoki ki a Īharaira, ki tō koutou pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“E Reupena, ko koe tāku mātāmua, tōku pakaritanga, me te tīmatanga o tōku kaha; te hiranga ake o te korōria, te hiranga ake hoki o te kaha. ");
INSERT INTO mri2012_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","He mea pōkarekare, ānō he wai, e kore koe e kake; mō tōu pikitanga i te moenga o tōu pāpā; pōkea iho e koe a reira – i pikitia e ia tōku takotoranga! ");
INSERT INTO mri2012_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“He tuakana, he teina, a Himiona rāua ko Rīwai; he rākau riri kino ā rāua hoari. ");
INSERT INTO mri2012_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Kaua e tomo, e tōku wairua, ki tō rāua rūnanga; kaua e huihuia, e tōku korōria, ki tō rāua whakaminenga – i patu tangata hoki rāua i a rāua e riri ana, ā, he hīkaka nō rāua i kopa ai te kau. ");
INSERT INTO mri2012_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kia kangā tō rāua riri, i kaha nei; me tō rāua āritarita, nō te mea he nanakia! Ka wehea atu rāua e ahau ki roto ki a Hākopa, ka whakamararatia hoki rāua ki roto ki a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“E Hūrā, ko koe e whakamoemititia e ōu tuākana, e ōu tēina; ka ū tōu ringa ki te kakī o ōu hoariri; ka piko ki a koe ngā tama a tōu pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","He kūao raiona a Hūrā; i kake atu koe, e tāku tama, i te haenga. I piko, i tāpapa ia, i pērā me te raiona, i pērā hoki me te raiona kātua – mā wai ia e whakaoho? ");
INSERT INTO mri2012_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","E kore e riro kē te hēpeta i a Hūrā, me te tokotoko o te kāwana i waenganui o ōna waewae, kia tae mai rā anō a Hiro; ā, ka rongo ngā iwi katoa ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ka herea e ia tana kūao ki te wāina, te tama hoki a tana kāihe ki te wāina pai rawa; ka horoia e ia ōna kākahu ki te wāina, ōna weruweru hoki ki te toto o te karepe. ");
INSERT INTO mri2012_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ka mumura hoki ōna kanohi i te wāina, ka mā ōna niho i te waiū. ");
INSERT INTO mri2012_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Ka noho a Hepurona ki te wahapū o te moana; hei wahapū anō ia mō ngā kaipuke; ka tutuki atu hoki tōna rohe ki Hairona. ");
INSERT INTO mri2012_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“He kāihe kaha a Ihākara, e tāpapa ana i waenga o ngā moenga hipi e rua; ");
INSERT INTO mri2012_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ā, i tōna kitenga i te okiokinga he pai, i te whenua hoki he āhuareka; nā, ka tukua iho e ia tōna pokohiwi ki te pīkaunga, ā, meinga ana ia hei pononga hōmai takoha. ");
INSERT INTO mri2012_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Ka whakawā a Rāna i tōna iwi, ka pērā ānō me tētahi o ngā iwi o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Hei nākahi a Rāna ki te ara, hei neke hoki ki te huarahi, e ngau ai i te rekereke o te hōiho, ā, ka taka whakamuri tōna kaieke. ");
INSERT INTO mri2012_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Kua tatari atu ahau ki tāu whakaoranga, e Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Ko Kara, ka āki te ope ki runga ki a ia; otiia ka āki ia ki tō rātou rekereke. ");
INSERT INTO mri2012_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ko tā Āhera, ka mōmona tāna taro, ā, he kai kīngi ōna hua. ");
INSERT INTO mri2012_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Ko Napatari, he hāta kua tukua kia haere; e hōmai ana e ia ngā kupu papai. ");
INSERT INTO mri2012_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Ko Hōhepa he peka hua, he peka hua i te taha o te puna; e toro atu ana ōna manga ki tua o te taiepa. ");
INSERT INTO mri2012_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","I whakatupu kino ngā kaikōpere i a ia, i pere mai hoki, i kino hoki ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Otiia, i mau tāna kōpere i runga i te kaha, ā, i whakapakaritia ngā tākakau o ōna ringa e ngā ringa o te Mea Kaha o Hākopa, nō reira nei te hēpara, te kāmaka o Īharaira, ");
INSERT INTO mri2012_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","arā e te Atua o tōu pāpā, māna anō koe e āwhina; e te Kaha Rawa hoki, māna e tuku mai ki a koe ngā manaaki o te rangi i runga, ngā manaaki hoki o te rire e takoto ana i raro, ngā manaaki o ngā ū, o te kōpū hoki. ");
INSERT INTO mri2012_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Hira ake ngā manaaki a tōu pāpā i ngā manaaki a ōku tūpuna, tae atu ana ki tērā taha rawa o ngā pukepuke tū tonu; ka tau iho ēnā mea ki runga ki te mātenga o Hōhepa, ki te tumuaki hoki ōna i motuhia atu nei i ōna tuākana. ");
INSERT INTO mri2012_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Ka haehae a Pineamine ānō he wuruhi, ka kainga e ia te tūpāpaku i te ata, ā, i te ahiahi ka tuwhaina e ia ngā taonga parakete.” ");
INSERT INTO mri2012_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ko ēnei katoa ngā iwi kotahi tekau mā rua o Īharaira, ko te kōrero hoki tēnei a tō rātou pāpā ki a rātou, ko tāna manaaki i a rātou, i manaakitia rātou e ia, tēnei, tēnei, me tōna manaaki anō. ");
INSERT INTO mri2012_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ā, i whakahau ia ki a rātou, i mea ki a rātou, “Ka kohia atu ahau ki tōku iwi. Tanumia ahau ki ōku mātua, ki te ana i te pārae o Eperona Hiti, ");
INSERT INTO mri2012_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ki te ana i te pārae o Makapera, i te ritenga o Mamere, i te whenua o Kanaana, i hokona, me te pārae anō, e Āperahama i a Eperona Hiti, kia puritia hei tanumanga. ");
INSERT INTO mri2012_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","I tanumia a Āperahama rāua ko Hara, ko tāna wahine, ki reira; i tanumia a Īhaka rāua ko Ripeka, ko tāna wahine, ki reira; i tanumia hoki a Rea e ahau ki reira. ");
INSERT INTO mri2012_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","I hokona te pārae me te ana i reira i ngā tama a Hete.” ");
INSERT INTO mri2012_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ā, ka mutu te whakahau a Hākopa ki āna tama, ka pēpeke ake ōna waewae ki roto ki te moenga, ā, ka hemo, ka kohia atu ki tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nā, ka hinga a Hōhepa ki runga ki te mata o tōna pāpā, ā, ka tangi i runga i a ia, ka kihi hoki i a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Nā, ka whakahau a Hōhepa i āna tāngata, i ngā kairongoā, kia whakapakokotia tōna pāpā. Nā, whakapakokotia ana a Īharaira e ngā kairongoā. ");
INSERT INTO mri2012_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Nā, ka tutuki ōna rā e whā tekau; ko ngā rā hoki ēnā e whakatutukitia ana mō te hunga e whakapakokotia ana. Ā, e whitu tekau ngā rā i uhungatia ai ia e ngā Īhipiana. ");
INSERT INTO mri2012_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ā, ka taka ngā rā e uhungatia ai ia, ka kōrero a Hōhepa ki te whare o Parao, ka mea, “Nā, ki te mea kua manakohia ahau e koutou, tēnā, kōrero atu ki ngā taringa o Parao, mea atu, ");
INSERT INTO mri2012_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","I whakaoati tōku pāpā i ahau, i mea, ‘Ka mate tēnei ahau; hei roto tāku tanumanga i keria e ahau mōku ki te whenua o Kanaana, hei reira ahau tanumia ai e koe.’ Nā, kia tukua ahau e koe āianei kia haere ki runga, ki te tanu i tōku pāpā, ka hoki mai ai.” ");
INSERT INTO mri2012_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nā, ka mea a Parao, “Haere ki runga ki te tanu i tōu pāpā, kia rite ki tāna i whakaoati ai i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Nā, haere ana a Hōhepa ki runga ki te tanu i tōna pāpā, i haere tahi anō i a ia ngā pononga katoa a Parao, ngā kaumātua o tōna whare, me ngā kaumātua katoa o te whenua o Īhipa, ");
INSERT INTO mri2012_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","me te whare katoa anō hoki o Hōhepa, rātou ko ōna tuākana, me te whare anō hoki o tōna pāpā. Ko ā rātou tamariki anake, me ā rātou hipi, me ā rātou kau i mahue i a rātou i te whenua o Kohena. ");
INSERT INTO mri2012_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","I haere tahi anō i a ia ngā hāriata me ngā tāngata hōiho; he nui whakaharahara te tira. ");
INSERT INTO mri2012_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Nā, ka tae rātou ki te patunga wīti a Atara, i tāwāhi o Horano, ā, he tino nui whakaharahara te tangihanga i tangi ai rātou ki reira; e whitu hoki ngā rā i uhungatia ai e ia tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ā, ka kite ngā tāngata whenua, ngā Kanaani, i te uhunga i te patunga wīti a Atara, ka mea rātou, “He uhunga nui tēnei nā ngā Īhipiana!” Nā reira i huaina ai te ingoa o reira ko Apere Mitiraima kei tāwāhi hoki o Horano. ");
INSERT INTO mri2012_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Nā, rite tonu ki tāna i whakahau ai ki a rātou tā āna tama i mea ai ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","I kawea hoki ia e āna tama ki te whenua o Kanaana, ā, tanumia ana ki te ana i te pārae o Makapera, i hokona tahitia nei e Āperahama me te pārae i a Eperona Hiti, kia puritia hei tanumanga, kei te ritenga atu o Mamere. ");
INSERT INTO mri2012_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Nā, hoki ana a Hōhepa ki Īhipa, rātou tahi ko ōna tuākana, ko ngā tāngata katoa anō hoki i haere tahi i a ia ki runga ki te tanu i tōna pāpā, i te mutunga o tāna tanu i tōna pāpā. ");
INSERT INTO mri2012_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nā, i te kitenga o ngā tuākana o Hōhepa kua mate tō rātou pāpā, ka mea rātou, “Tērā pea e kino mai a Hōhepa ki a tātou, ā, ka utua mai e ia ā tātou kino katoa i meatia e tātou ki a ia.” ");
INSERT INTO mri2012_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Nā, ka tuku tangata rātou ki a Hōhepa, ā, ka mea, “I whakahau mai tōu pāpā i mua ake i tōna matenga, i mea mai, ");
INSERT INTO mri2012_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Kia pēnei tā koutou kupu ki a Hōhepa: Tēnā, whakarērea te hē o ōu tuākana, me tō rātou hara; he kino hoki tā rātou mahi ki a koe.’ Nā, tēnā whakarērea te hē o ngā pononga a te Atua o tōu pāpā.” Ā, ka tangi a Hōhepa i ā rātou kupu ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Nā, ka haere ōna tuākana, ka tāpapa ki tōna aroaro; ka mea, “Tēnei mātou hei pononga māu.” ");
INSERT INTO mri2012_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ā, ka mea a Hōhepa ki a rātou, “Kaua e wehi. He kaiwhakakapi oti ahau mō tō te Atua wāhi? ");
INSERT INTO mri2012_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ko koutou hoki, i hē ō koutou whakaaro ki ahau; he pai ia tō te Atua whakaaro, kia meatia ai tēnei ināianei, kia whakaorangia ai hoki ngā tāngata tokomaha. ");
INSERT INTO mri2012_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Heoi, kaua e wehi; māku koutou e atawhai, koutou ko ā koutou tamariki.” Ā, ka whakamārie ia i a rātou, ka whakamāmā hoki i ō rātou ngākau. ");
INSERT INTO mri2012_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nā, ka noho a Hōhepa ki Īhipa, rātou ko te whare o tōna pāpā; ā, kotahi rau kotahi tekau ngā tau i ora ai a Hōhepa. ");
INSERT INTO mri2012_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ā, i kite a Hōhepa i te tuatoru o ngā whakatupuranga o ngā tamariki a Ēparaima; i whakatupuria anō hoki ngā tamariki a Makiri, tama a Mānahi, ki runga ki ngā turi o Hōhepa. ");
INSERT INTO mri2012_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Nā, ka mea a Hōhepa ki ōna tuākana, “Ka mate ahau; otiia ka āta tirohia koutou e te Atua, ā, ka kawea atu koutou e ia i tēnei whenua ki runga, ki te whenua i oati ai ia ki a Āperahama, ki a Īhaka, ki a Hākopa.” ");
INSERT INTO mri2012_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Nā, ka whakaoatitia ngā tama a Īharaira e Hōhepa, ka mea ia, “Ka tīkina mai koutou, ka āta tirohia e te Atua, ā, me kawe atu e koutou ōku iwi i konei ki runga.” ");
INSERT INTO mri2012_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nā, ka mate a Hōhepa i te kotahi rau i te kotahi tekau o ōna tau; ā, ka whakapakokotia e rātou, ka whakatakotoria hoki ki te kāwhena i Īhipa.");
INSERT INTO mri2012_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Nā, ko ngā ingoa ēnei o ngā tama a Īharaira i haere ki Īhipa; i haere tahi mai rātou me Hākopa, me te whare o tēnei, o tēnei: ");
INSERT INTO mri2012_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ko Reupena, ko Himiona, ko Rīwai, ko Hūrā, ");
INSERT INTO mri2012_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ko Ihākara, ko Hepurona, ko Pineamine, ");
INSERT INTO mri2012_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ko Rāna, ko Napatari, ko Kara, ko Āhera. ");
INSERT INTO mri2012_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Nā, ko ngā wairua katoa i puta mai i te hope o Hākopa, e whitu tekau wairua; i Īhipa hoki a Hōhepa. ");
INSERT INTO mri2012_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Nā, kua mate a Hōhepa, me ōna tuākana katoa, me tērā whakapaparanga katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ā, ka tupu ngā tama a Īharaira, ka tini haere, ka hira rawa, ka kaha noa atu; ā, kapi ana te whenua i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nā, kua puta he kīngi hou mō Īhipa, kīhai i mōhio ki a Hōhepa. ");
INSERT INTO mri2012_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ā, ka kī ia ki tōna iwi, “Nanā, hira ake, kaha ake i a tātou te iwi o ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tēnā, kia āta ngārahu tātou ki a rātou; kei tini haere, ā, tēnei ake, ki te ara he pakanga, nā, ka uru hoki rātou ki ō tātou hoariri, ka whawhai ki a tātou, ā, ka maunu atu i te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nā, ka whakaritea he rangatira akiaki mō rātou, hei whakawhiu mō rātou ki ā rātou kawenga. Ā, hangā ana e rātou ngā pā takotoranga taonga mō Parao, a Pitoma, a Ramahehe. ");
INSERT INTO mri2012_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Engari whakawhiu noa rātou i a rātou, e hua tonu mai ana, e tupu ana, ā, pāwera ana rātou i ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ā, nanakia noa iho te whakamahinga a ngā Īhipiana i ngā tama a Īharaira; ");
INSERT INTO mri2012_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ā, meatia ana e rātou kia kawa ake rātou ki te ora, i te nui o te mahi, i te paru pokepoke, i te pereki, i ngā mahi katoa o te māra, ā rātou mahi katoa, i whakawhiua ai rātou ki te mahi. ");
INSERT INTO mri2012_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nā, ka mea te kīngi o Īhipa ki ngā wāhine whakawhānau i ngā wāhine a ngā Hiperu; ko te ingoa o tētahi ko Hipera, ko te ingoa hoki o tētahi ko Pua, ");
INSERT INTO mri2012_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","i kī ia, “E whakawhānau kōrua i ngā wāhine a ngā Hiperu, ā, ka kite i a rātou i runga i ngā kumete, ki te mea he tamaiti tāne, whakamatea; he kōtiro ia, kia ora tēnā.” ");
INSERT INTO mri2012_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Otirā, i wehi ngā kaiwhakawhānau ki te Atua, kīhai hoki i mea i tā te kīngi o Īhipa i mea ai ki a rāua, ā, whakaorangia ana e rāua ngā tamariki tāne. ");
INSERT INTO mri2012_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Nā, ka karangatia ngā kaiwhakawhānau e te kīngi o Īhipa, ā, ka mea ki a rāua, “Nā te aha tēnei mahi a kōrua, i whakaora ai kōrua i ngā tamariki tāne?” ");
INSERT INTO mri2012_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ā, ka mea ngā kaiwhakawhānau ki a Parao, “Nō te mea rā, ehara ngā wāhine a ngā Hiperu i te pēnā me ngā wāhine a ngā Īhipiana; e māia ana hoki rātou, kāhore anō kia tae atu te kaiwhakawhānau ki a rātou kua whānau.” ");
INSERT INTO mri2012_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nā, ka atawhai te Atua ki ngā kaiwhakawhānau; ā, ka nui haere te iwi, ā, kaha rawa ana. ");
INSERT INTO mri2012_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ā, nō te mea i wehi ngā kaiwhakawhānau ki te Atua, ka hangā e ia he whare mō rāua. ");
INSERT INTO mri2012_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Nā, ka ako a Parao ki tōna iwi katoa, ka mea, “Ko ngā tamariki tāne katoa e whānau mai, makā atu e koutou ki te awa, ko ngā kōtiro katoa ia, me whakaora.” ");
INSERT INTO mri2012_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Nā, ka haere tētahi tangata o te whare o Rīwai, ka tango i tētahi tamāhine a Rīwai hei wahine. ");
INSERT INTO mri2012_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ā, ka hapū te wahine, ka whānau he tāne; ā, ka kitea he tamaiti pai, e toru ngā marama i hunā ai ia e ia. ");
INSERT INTO mri2012_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ā, tē āhei ia te huna tonu i a ia, ka tango ia i tētahi āka kākaho mōna, pani rawa ki te uku, ki te ware, ā, whaowhina ana te tamaiti ki roto; whakatakotoria iho ki roto ki ngā wīwī i te pareparenga o te awa. ");
INSERT INTO mri2012_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ā, tū ana i tawhiti tōna tuahine, kia kite e ahatia rānei ia. ");
INSERT INTO mri2012_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Nā, ko te haerenga iho o te tamāhine a Parao ki te awa, ki te horoi; ko āna kōtiro hoki e haere ana i te taha o te awa. Ā, ka kite ia i te āka i roto i ngā wīwī, ka ngare i tāna kōtiro ki te tiki. ");
INSERT INTO mri2012_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ā, nō tāna hurahanga ake, ka kite i te tamaiti; nā, ka tangi te tamaiti. Ā, ka aroha ia ki a ia, ka mea, “Nō ngā tamariki a ngā Hiperu tēnei.” ");
INSERT INTO mri2012_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kātahi ka mea tōna tuahine ki te tamāhine a Parao, “Kia haere ahau ki te karanga i tētahi wahine whakangote o ngā Hiperu ki a koe hei whakangote māu i te tamaiti?” ");
INSERT INTO mri2012_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ā, ka kī te tamāhine a Parao ki a ia, “Haere.” Ā, haere ana te kōtiro, karanga ana i te whaea o te tamaiti. ");
INSERT INTO mri2012_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ā, ka mea te tamāhine a Parao ki a ia, “Tangohia te tamaiti nei, whakangotea māku, ā, māku e hoatu he utu ki a koe.” Nā, tango ana te wahine i te tamaiti, ā, whakangotea ana e ia. ");
INSERT INTO mri2012_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ā, ka nui te tamaiti, ka kawea e ia ki te tamāhine a Parao, ā, ka waiho ia hei tama māna. Ā, huaina iho e ia tōna ingoa ko Mohi; i mea hoki, “Nō te mea i tōia ake ia e ahau i roto i te wai.” ");
INSERT INTO mri2012_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ā, i aua rā, ka kaumātuatia a Mohi, nā, ka haere ki ōna tuākana, ka titiro hoki ki ā rātou kawenga; ā, ka kite ia i tētahi Īhipiana e patu ana i tētahi Hiperu, nō ōna tuākana. ");
INSERT INTO mri2012_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nā, ka tāhurihuri ia, ā, ka kite kāhore he tangata, patua iho te Īhipiana, ā, hunā iho ki te onepū. ");
INSERT INTO mri2012_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ā, ka haere ia i te rua o ngā rā, nā, tokorua ngā tāngata o ngā Hiperu e whawhai ana ki a rāua; ā, ka mea atu ia ki te tangata nāna te kino, “He aha koe i patu ai i tōu hoa?” ");
INSERT INTO mri2012_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Nā, ka mea tērā, “Nā wai koe i kī hei rangatira, hei kaiwhakawā mō mātou? E mea ana koe ki te patu i ahau me koe i patu rā i te Īhipiana?” Ā, ka wehi a Mohi, ka mea, “Koia hoki, kua rangona tēnei mea.” ");
INSERT INTO mri2012_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ā, ka rongo a Parao i taua mea, nā, ka whai kia patua a Mohi. Otiia i rere a Mohi i te aroaro o Parao, ā, noho ana i te whenua o Miriana; nā, kua noho ia ki te puna. ");
INSERT INTO mri2012_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Nā, tokowhitu ngā tamāhine a te tohunga o Miriana; ā, ka haere rātou, ka utuutu wai, ka whakakī i ngā waka, hei whakainu i ngā hipi a tō rātou pāpā. ");
INSERT INTO mri2012_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ā, ko te haerenga o ngā hēpara, kei te atiati i a rātou; ā, ka whakatika a Mohi ka araarai i a rātou, ka whakainu i ā rātou hipi. ");
INSERT INTO mri2012_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ā, ka tae rātou ki a Reuere, ki tō rātou pāpā, ka mea ia, “Nā te aha koutou i hohoro mai ai ināianei?” ");
INSERT INTO mri2012_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ā, ka mea rātou, “Nā tētahi Īhipiana i ora ai mātou i te ringa o ngā hēpara, nāna anō i utuutu he wai mā mātou, i whakainu hoki ngā hipi.” ");
INSERT INTO mri2012_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Nā, ka mea ia ki āna tamāhine, “Ā, kei hea ia? He aha taua tangata i whakarērea ai e koutou? Karangatia ki te kai taro.” ");
INSERT INTO mri2012_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ā, i pai a Mohi ki te noho ki taua tangata; ā, ka hōmai e ia a Hipora, tāna tamāhine, ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ā, ka whānau ia, he tāne, ā, huaina iho e ia tōna ingoa ko Kerehoma; i mea hoki ia, “He manene ahau i te whenua kē.” ");
INSERT INTO mri2012_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Nā, i muri i ngā rā e maha ka mate te kīngi o Īhipa; ā, ka hotu te manawa o ngā tama a Īharaira i te whakamahinga. Ā, auē ana rātou; ā, ka puta ake tā rātou auē ki te Atua, nō rātou hoki e whakamahia ana. ");
INSERT INTO mri2012_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ā, ka rongo te Atua ki tā rātou tangi, ka mahara te Atua ki tāna kawenata ki a Āperahama, ki a Hākopa, ki a Īhaka. ");
INSERT INTO mri2012_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nā, ka titiro te Atua ki ngā tama a Īharaira, ā, ka mōhio te Atua ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Nā, i te tiaki a Mohi i ngā hipi a tōna hungawai, a Ietoro, tohunga o Miriana; ā, ka ārahi ia i ngā hipi ki te taha ki muri o te koraha, ka tae ki te maunga o te Atua, ki Horepa. ");
INSERT INTO mri2012_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ā, ka puta ki a ia te anahera a Ihowā i roto i te mura ahi, i waenganui o tētahi rākau; ā, ka titiro ia, nā, e toro ana te rākau i te ahi, ā, kīhai i pau te rākau. ");
INSERT INTO mri2012_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nā, ka mea a Mohi, “Ka tahuri ahau, ka mātakitaki atu ki tēnei mea nui kua puta nei, he aha te rākau tē pau ai.” ");
INSERT INTO mri2012_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ā, ka kite a Ihowā e tahuri ana ia ki te mātakitaki, ka karanga te Atua ki a ia i waenganui o te rākau, ka mea, “E Mohi, e Mohi!” Ā, ka mea ia, “Tēnei ahau.” ");
INSERT INTO mri2012_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nā, ka mea ia, “Kaua e whakatata mai ki konei; wetekina ōu hū i ōu waewae, ko te wāhi hoki e tū nā koe, he wāhi tapu.” ");
INSERT INTO mri2012_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ka mea anō ia, “Ko ahau te Atua o tōu pāpā, te Atua o Āperahama, te Atua o Īhaka, te Atua o Hākopa.” Ā, huna ana a Mohi i tōna kanohi; i wehi hoki ia ki te titiro atu ki te Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ā, ka mea a Ihowā, “Kua kite pū ahau i te tūkino o tāku iwi i Īhipa, kua rongo hoki ki tā rātou auē i ō rātou kaiakiaki; e mōhio ana hoki ahau ki ō rātou mamae, ");
INSERT INTO mri2012_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ā, kua heke iho nei ahau ki te whakaora i a rātou i te ringa o ngā Īhipiana, ki te kawe atu i a rātou i tērā whenua ki tētahi whenua pai, whenua nui, ki tētahi whenua e rerengia ana e te waiū, e te honi, ki te wāhi o ngā Kanaani, o ngā Hiti, o ngā Amori, o ngā Perihi, o ngā Hiwi, o ngā Iepuhi. ");
INSERT INTO mri2012_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nā, kua tae ake te karanga a ngā tama a Īharaira ki ahau; kua kite hoki ahau i te tūkino e tūkinotia nei rātou e ngā Īhipiana. ");
INSERT INTO mri2012_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nā reira, haere mai, māku koe e unga ki a Parao, ā, māu e whakaputa mai tāku iwi, ngā tama a Īharaira, i Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Nā, ka mea a Mohi ki te Atua, “He aha ahau, kia haere ahau ki a Parao, kia whakaputa mai hoki i ngā tama a Īharaira i Īhipa?” ");
INSERT INTO mri2012_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ā, ka mea ia, “Kei a koe tonu rā ahau; ko te tohu anō tēnei mōu ka ungā nei e ahau. Ka whakaputaina mai e koe te iwi i Īhipa, ka mahi koutou ki te Atua ki runga i tēnei maunga.” ");
INSERT INTO mri2012_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Nā, ka mea a Mohi ki te Atua, “Nā, ka tae ahau ki ngā tama a Īharaira, ka mea ki a rātou, ‘Nā te Atua o ō koutou mātua ahau i ngare mai ki a koutou’; ā, ka mea mai rātou ki ahau, ‘Ko wai tōna ingoa?’ Me pēhea atu ahau ki a rātou?” ");
INSERT INTO mri2012_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nā, ka mea te Atua ki a Mohi, “KO AHAU ANŌ AHAU NEI.” I mea anō ia, “Kia pēnei atu koe ki ngā tama a Īharaira, ‘Nā te AHAU NEI ahau i ngare mai ki a koutou.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ā, ka mea anō te Atua ki a Mohi, “Kia pēnei atu koe ki ngā tama a Īharaira, ‘Nā Ihowā, nā te Atua o ō koutou mātua, nā te Atua o Āperahama, nā te Atua o Īhaka, nā te Atua hoki o Hākopa, i tono mai ahau ki a koutou.’ Ko tōku ingoa tēnei ake ake, ko tōku whakamaharatanga hoki tēnei ki ngā whakapaparanga katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Haere, whakaminea ngā kaumātua o Īharaira, mea atu ki a rātou, ‘Kua puta mai ki ahau a Ihowā, te Atua o ō koutou mātua, te Atua o Āperahama, o Īhaka, o Hākopa; e ai tāna: Kua tīkina mai, kua tirohia mārietia koutou e ahau, me ngā mea e meatia ana ki a koutou i Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kua mea nei anō ahau, ka whakaputaina mai koutou e ahau i te whakawhiu a Īhipa ki te whenua o ngā Kanaani o ngā Hiti, o ngā Amori, o ngā Perihi, o ngā Hiwi, o ngā Iepuhi, ki te whenua e rerengia ana e te waiū, e te honi.’ ");
INSERT INTO mri2012_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ā, e rongo rātou ki tōu reo; ā, ka haere koe, koutou tahi ko ngā kaumātua o Īharaira, ki te kīngi o Īhipa, ka mea ki a ia, ‘Kua tūtaki a Ihowā, te Atua o ngā Hiperu ki a mātou; tukua mātou kia haere, kia toru ngā rā e haere ana i te koraha, kia patu ai, mātou he whakahere mā Ihowā, mā tō mātou Atua.’ ");
INSERT INTO mri2012_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ā, e mōhio ana ahau e kore te kīngi o Īhipa e tuku i a koutou, kāhore, ki te kāhore he ringa kaha. ");
INSERT INTO mri2012_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ā, ka tākiritia tōku ringa, ka patua hoki a Īhipa ki āku merekara katoa, e mea ai ahau i waenganui ōna; ā muri iho, ka tukua mai koutou e ia. ");
INSERT INTO mri2012_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Ā, māku e mea kia paingia tēnei iwi i te aroaro o ngā Īhipiana; ā, ka haere koutou, e kore e haere kau. ");
INSERT INTO mri2012_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Engari me tono e ia wahine, e ia wahine, ki tōna hoa tata, ki te wahine hoki e noho ana i tōna whare, he mea hiriwa, he mea kōura, he kākahu; ā, ka hoatu ki ā koutou tama, ki ā koutou tamāhine; ā, ka pāhuatia e koutou ngā Īhipiana.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ā, ka whakahoki a Mohi, ka mea, “Nā, e kore rātou e whakapono ki ahau, e kore hoki e whakarongo ki tōku reo; e mea hoki rātou, ‘Kāhore a Ihowā i puta mai ki a koe.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ā, ka mea a Ihowā ki a ia, “He aha tēnā i tōu ringa?” Ā, ka mea ia, “He tokotoko.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Nā, ka mea ia, “Makā atu ki te whenua.” Nā, makā ana e ia ki te whenua, nā, he nākahi! Ko te tino rerenga o Mohi i tōna aroaro. ");
INSERT INTO mri2012_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ka mea anō a Ihowā ki a Mohi, “Totoro atu tōu ringa, hopukia i te hiku” – ko te toronga atu o tōna ringaringa, hopukina iho, nā, kua tokotoko anō ki tōna ringa – ");
INSERT INTO mri2012_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“kia whakapono ai rātou kua puta ki a koe a Ihowā, te Atua o ō rātou mātua, te Atua o Āperahama, te Atua o Īhaka, te Atua o Hākopa.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","I mea anō a Ihowā ki a ia, “Tēnā, kuhua tōu ringa ki tōu uma.” Ā, kuhua ana e ia tōna ringa ki tōna uma; te unuhanga anō, nā, kua repera tōna ringa, kua rite ki te hukarere. ");
INSERT INTO mri2012_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","I mea anō ia, “Whakahokia anō tōu ringa ki tōu uma” – ā, whakahokia ana anō e ia tōna ringa ki tōna uma; ā, nō te unuhanga i tōna uma, nā, kua hoki, kua rite ki tōna kiri anō – ");
INSERT INTO mri2012_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Ā, ki te kore rātou e whakapono ki a koe, ki te kore e whakarongo ki te reo o te tohu tuatahi, nā, ka whakapono rātou ki te reo o tō muri tohu. ");
INSERT INTO mri2012_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ā, ki te kore anō rātou e whakapono ki ēnei tohu e rua, ki te kore e whakarongo ki tōu reo, utuhia e koe ki te wai o te awa, ka riringi ki te oneone maroke; ā, ko te wai e utuhia e koe i te awa, hei toto ki runga ki te whenua maroke.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Nā, ka kī a Mohi ki a Ihowā, “E tōku Ariki, ehara ahau i te pūkōrero, i mua, i muri rānei i tāu kōrerotanga ki tāu pononga; he reo ngoikore hoki tōku, he arero paremo.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Nā, ka mea a Ihowā ki a ia, “Nā wai i hanga te māngai o te tangata? Nā wai hoki i mea kia wahangū, kia turi, kia titiro rānei, kia matapō rānei? Ehara koia i ahau, i a Ihowā? ");
INSERT INTO mri2012_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nā, haere, ā, hei tōu waha ahau, ako ai i a koe ki tāu e kōrero ai.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Nā, ka mea ia, “E tōku Ariki, māu rā e unga tāu e unga ai.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Nā, ka mura te riri a Ihowā ki a Mohi; ka mea ia, “Ehara ianei a Ārona Rīwaiti i te tuakana nōu? E mātau ana ahau he pūkōrero ia. Ina hoki, nā, e haere mai nei ia ki te whakatau i a koe; ā, ka kite i a koe, ka koa tōna ngākau. ");
INSERT INTO mri2012_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ā, māu e kōrero ki a ia, e hoatu ngā kupu ki tōna waha; ā, hei tōu māngai ahau, hei tōna māngai hoki, whakaako ai i a kōrua ki tā kōrua e mea ai. ");
INSERT INTO mri2012_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ā, ko ia hei kaikōrero māu ki te iwi; ā, ko ia, inā, ka ai ia hei māngai mōu, ko koe hoki hei Atua ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Maua atu anō tēnei tokotoko i tōu ringa, e mea ai koe i ngā tohu.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Nā, haere ana a Mohi, hoki ana ki a Ietoro, ki tōna hungawai, ā, ka mea ki a ia, “Tukua ahau kia haere, kia hoki ki ōku tuākana i Īhipa, kia kite kei te ora anō rānei rātou.” Ā, ka mea a Ietoro ki a Mohi, “Haere i runga i te pai.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","I mea anō a Ihowā ki a Mohi i Miriana, “Haere, e hoki ki Īhipa; kua mate katoa hoki ngā tāngata i whai i a koe kia patua.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Nā, ka mau a Mohi ki tāna wahine rātou ko āna tama, ā, whakanohoia ana ki runga ki te kāihe, ā, hoki ana ki te whenua o Īhipa; i tango anō a Mohi i te tokotoko a te Atua ki tōna ringa. ");
INSERT INTO mri2012_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","I mea anō a Ihowā ki a Mohi, “E haere koe, e hoki ki Īhipa, kia mahara kia meatia ki te aroaro o Parao ēnā merekara katoa kua hoatu nā e ahau ki tōu ringa. Otiia, māku e whakapakeke tōna ngākau, kia kore ai ia e tuku i te iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ā, ka mea koe ki a Parao, ‘Ko te kupu tēnei a Ihowā: Ko Īharaira tāku tama, tāku mātāmua. ");
INSERT INTO mri2012_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ko tāku kupu anō tēnei ki a koe, “Tukua tāku tama kia mahi ki ahau.” Ā, ki te kore koe e rongo ki te tuku i a ia, nā, ka patua e ahau tāu tama, tāu mātāmua.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ā, i a rātou i te whare tira i te ara, nā, pono pū a Ihowā ki a ia, ā, ka whai i a ia kia whakamatea. ");
INSERT INTO mri2012_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ā, ka tango a Hipora i tētahi kōhatu koi, ā, kotia iho te kiri matamata o tāna tama, nā, whakapākia ana e ia ki ōna waewae, ka mea, “He tāne toto koe ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Heoi, ka tuku atu ia i a ia. I reira anō ka mea te wahine, “He tāne toto koe; mō te kotinga hoki.” ");
INSERT INTO mri2012_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nā, ka mea a Ihowā ki a Ārona, “Haere ki te koraha, ki te whakatau i a Mohi.” Ā, haere ana ia, ā, ka tūtaki ki a ia ki te maunga o te Atua, ka kihi i a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ā, kōrerotia ana e Mohi ki a Ārona ngā kupu katoa a Ihowā i unga nei i a ia, me ngā tohu katoa i ako ai ia ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Nā, haere ana a Mohi rāua ko Ārona, ā, whakaminea ana ngā kaumātua katoa o ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Nā, kōrerotia ana e Ārona ngā kupu katoa i kōrero ai a Ihowā ki a Mohi, mahia ana hoki e ia ngā tohu i te tirohanga a te iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ā, whakapono tonu te iwi; ā, ka rongo rātou kua tae mai a Ihowā ki ngā tama a Īharaira, kua titiro ki tō rātou whakawhiunga, ka tuohu rātou, ka koropiko. ");
INSERT INTO mri2012_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ā muri iho, ka haere a Mohi rāua ko Ārona, ka kōrero ki a Parao, “Ko te kupu tēnei a Ihowā, a te Atua o Īharaira, ‘Tukua tāku iwi kia haere ki te taka hākari ki ahau i te koraha.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nā, ka mea a Parao, “Ko wai a Ihowā, kia rongo ahau ki tōna reo, kia tukua a Īharaira? Kāhore ahau e mōhio ki a Ihowā, e kore hoki e tukua atu e ahau a Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ā, ka mea rāua, “Kua tūtaki te Atua o ngā Hiperu ki a mātou. Kia haere rā mātou, kia toru ngā rā ki te ara i te koraha, ka mea patunga tapu ai mātou ki a Ihowā, ki tō mātou Atua; kei tōrere mai ia ki a mātou i te mate urutā rānei, i te hoari rānei.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Nā, ka mea te kīngi o Īhipa ki a rāua, “He aha kōrua, e Mohi kōrua ko Ārona, i whakaware ai i te iwi ki ā rātou mahi? Haere ki ā koutou kawenga.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","I mea anō a Parao, “Nanā, ka tini nei ngā tāngata o te whenua, nā kōrua hoki rātou i noho ai i ā rātou kawenga.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Nā, ka ako a Parao i taua rā ki ngā kaiakiaki o te iwi, ki ō rātou rangatira, ka mea: ");
INSERT INTO mri2012_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kaua e hoatu he tākakau ki te iwi ā muri ake nei, hei hanga pereki, pērā i ō mua rā; me haere rātou ki te kohikohi tākakau mā rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Otiia, whakaritea ki a rātou kia rite tonu ngā pereki te maha ki ērā i hangā e rātou i mua; kaua e whakahokia iho te maha; he māngere hoki rātou; koia rātou i karanga ai, i mea ai, ‘Kia haere mātou ki te mea patunga tapu ki tō mātou Atua.’ ");
INSERT INTO mri2012_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Whakanuia te mahi mā ngā tāngata rā, ā, ko tēnā hei mahi mā rātou; kaua hoki rātou e whakarongo ki ngā kupu horihori.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Nā, ka haere ngā kaiakiaki o te iwi, me ō rātou rangatira, ka kōrero ki te iwi, ka mea, “Ko te kupu tēnei a Parao, ‘E kore e hoatu e ahau he tākakau ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Haere ki te kohikohi tākakau mā koutou i te wāhi e kitea ai e koutou; otiia, kaua e whakahokia iho tētahi wāhi o tā koutou e mahi ai.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Nā, ka marara noa atu te iwi ki te whenua katoa o Īhipa, ki te kohikohi pūtake wīti hei tākakau. ");
INSERT INTO mri2012_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ā, ka whakatatutatu ngā kaiakiaki, ka mea, “Whakaotia ā koutou mahi, tō tēnei rangi, tō tēnei rangi, kia rite ki ō te wā i whai tākakau ai.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Nā, ka whiua ngā rangatira o ngā tama a Īharaira i whakaritea mō rātou e ngā kaiakiaki a Parao, ka mea rātou, “He aha tē whakaotia ai inanahi, ināianei, ā koutou pereki i whakaritea ki a koutou, tē pērā ai me ō mua rā?” ");
INSERT INTO mri2012_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Nā, ka haere ngā rangatira o ngā tama a Īharaira, me te tangi anō, ki a Parao, ka mea, “He aha koe i pēnei ai ki āu pononga? ");
INSERT INTO mri2012_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Kāhore he tākakau i hōmai ki āu pononga, ā, e mea ana rātou ki a mātou, ‘Hangā he pereki!’ Nā, ka whiua āu pononga; nō āu tāngata ia te hē.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nā, ka mea ia, “He māngere koutou, he māngere; nā reira koutou ka mea ai, ‘Tukua mātou kia haere ki te mea patunga tapu ki a Ihowā.’ ");
INSERT INTO mri2012_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nā, haere, e mahi; e kore hoki e hoatu he tākakau ki a koutou; otiia me hōmai anō ngā pereki i whakaritea rā.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nā, ka kite ngā rangatira o ngā tama a Īharaira i te kino mō rātou, i te kīanga rā, “Kaua e whakaokuokutia iho ā koutou pereki, hei mahinga mā koutou i tēnei rā, i tēnei rā.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ā, ka tūtaki rātou ki a Mohi rāua ko Ārona, e tū mai ana i mua i a rātou, i tō rātou haerenga mai i a Parao. ");
INSERT INTO mri2012_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ā, ka mea ki a rāua, “Mā Ihowā e titiro ki a kōrua, e whakawā. Nā kōrua hoki mātou i piro whakarihariha ai ki te aroaro o Parao, ki te aroaro hoki o āna pononga, nā kōrua i hoatu he hoari ki ō rātou ringa hei patu i a mātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Nā, ka hoki a Mohi ki a Ihowā, ā, ka mea, “E te Ariki, he aha koe i mahi hē ai ki tēnei iwi? He aha koe i unga ai i ahau? ");
INSERT INTO mri2012_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nō tōku haerenga atu hoki ki a Parao ki te kōrero i runga i tōu ingoa, i kino ai ia ki tēnei iwi; kāhore anō hoki koe kia whakaora noa i tāu iwi, kāhore rawa.” ");
INSERT INTO mri2012_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Nā, ka mea a Ihowā ki a Mohi, “Ākuanei koe kite ai i tāku e mea ai ki a Parao; he kaha hoki te ringa e tuku ai ia i a rātou, he kaha hoki te ringaringa e pei ai ia i a rātou i tōna whenua.” ");
INSERT INTO mri2012_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ā, ka kōrero te Atua ki a Mohi, ka mea ki a ia, “Ko IHOWĀ ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I ōku putanga ia ki a Āperahama, ki a Īhaka, ki a Hākopa, ko te Atua Kaha Rawa ahau, otiia kīhai rātou i mōhio ki ahau, ko IHOWĀ tōku ingoa. ");
INSERT INTO mri2012_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ka whakamanā anō e ahau tāku kawenata ki a rātou, kia hoatu te whenua o Kanaana ki a rātou, te whenua o tō rātou nohoanga manenetanga, i noho manene ai rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kua rongo anō ahau ki te auē a ngā tama a Īharaira, e whakamahia nei e ngā Īhipiana, kua mahara hoki ki tāku kawenata. ");
INSERT INTO mri2012_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Mō konei me kī e koe ki ngā tama a Īharaira: ‘Ko Ihowā ahau, ā, māku koutou e whakaputa i raro i ngā kawenga a ngā Īhipiana, māku hoki koutou e tango i tā rātou whakamahinga, he mārō hoki te ringa, he nui ngā whakawā, e whakaora ai ahau i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ā, ka tango ahau i a koutou hei iwi māku, ko ahau anō hei Atua mō koutou. Ā, e mōhio koutou ko Ihowā ahau, ko tō koutou Atua, e whakaputa ana i a koutou i raro i ngā kawenga a ngā Īhipiana. ");
INSERT INTO mri2012_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Māku anō hoki koutou e kawe atu ki te whenua i whakamārō ai ahau i tōku ringaringa mō reira kia hoatu ki a Āperahama, ki a Īhaka, ki a Hākopa; ā, ka hoatu a reira e ahau ki a koutou hei kāinga tūturu. Ko Ihowā ahau.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ā, he pēnā tā Mohi kōrero ki ngā tama a Īharaira; otiia kīhai rātou i whakarongo ki a Mohi i te mamae o te ngākau, i te kino o te mahi. ");
INSERT INTO mri2012_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Haere, kōrero ki a Parao kīngi o Īhipa kia tukua e ia ngā tama a Īharaira i tōna whenua.” ");
INSERT INTO mri2012_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Nā, ka kōrero a Mohi i te aroaro o Ihowā, ka mea, “Nanā, kāhore ngā tama a Īharaira i whakarongo ki ahau; me pēhea e rongo ai a Parao ki ahau, he ngutu kokotikore nei hoki ahau?” ");
INSERT INTO mri2012_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Nā, ka kōrero a Ihowā ki a Mohi rāua ko Ārona, hōmai ana e ia ki a rāua he ako ki ngā tama a Īharaira, ki a Parao hoki kīngi o Īhipa, mō ngā tama a Īharaira kia whakaputaina i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ko ngā upoko ēnei o ngā whare o ō rātou mātua: Ko ngā tama a Reupena mātāmua a Īharaira: ko Hanoka, ko Paru, ko Heterono, ko Karami; ko ngā hapū ēnei o Reupena. ");
INSERT INTO mri2012_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Nā, ko ngā tama a Himiona: ko Iemuere, ko Iamini, ko Ohara, ko Iakini, ko Tohara, ko Hauru, he tama nā tētahi wahine o ngā Kanaani; ko ngā hapū ēnei o Himiona. ");
INSERT INTO mri2012_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Nā, ko ngā ingoa ēnei o ngā tama a Rīwai i ō rātou whakatupuranga: ko Kerehona, ko Kohata, ko Merari; ko ngā tau hoki i ora ai a Rīwai, kotahi rau e toru tekau mā whitu tau. ");
INSERT INTO mri2012_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ko ngā tama a Kerehona: ko Ripini, ko Himei, i ō rāua hapū. ");
INSERT INTO mri2012_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ko ngā tama a Kohata: ko Āmarama, ko Itihara, ko Heperona, ko Utiere; ā, ko ngā tau i ora ai a Kohata, kotahi rau e toru tekau mā toru ngā tau. ");
INSERT INTO mri2012_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ko ngā tama a Merari: ko Māhari, ko Muhi. Ko ngā hapū ēnei o Rīwai i ō rātou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ā, i tango a Āmarama i a Iokepete, tuahine o tōna pāpā, hei wahine māna; ā, whānau ake ana ko Ārona rāua ko Mohi. Ko ngā tau hoki i ora ai a Āmarama, kotahi rau e toru tekau mā whitu tau. ");
INSERT INTO mri2012_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ko ngā tama a Itihara: ko Koraha, ko Nepeke, ko Tīkiri. ");
INSERT INTO mri2012_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ko ngā tama a Utiere: ko Mihāera, ko Eritapana, ko Hitiri. ");
INSERT INTO mri2012_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ā, ka tango a Ārona i a Erihepa tamāhine a Aminarapa, i te tuahine o Nāhona, hei wahine māna; ā, whānau ake ana ko Nātapa, ko Apihu, ko Ereātara, ko Itamara. ");
INSERT INTO mri2012_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ko ngā tama a Koraha: ko Ahiri ko Erekana, ko Apihapa; ko ngā hapū ēnei o ngā Korahi. ");
INSERT INTO mri2012_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ā, i tango a Ereātara tama a Ārona i tētahi o ngā tamāhine a Putiera hei wahine māna; ā, whānau ake tāna ko Pinehaha. Ko ngā upoko ēnei o ngā mātua o ngā Rīwaiti puta noa i ō rātou hapū. ");
INSERT INTO mri2012_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ko taua Ārona rāua ko Mohi tēnei i kōrero nei a Ihowā ki a rāua, “Kia whakaputaina mai ngā tama a Īharaira i te whenua o Īhipa, tēnei rōpū, tēnei rōpū o rātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ko rāua ēnei nāna i kōrero ki a Parao kīngi o Īhipa, kia whakaputaina mai ngā tama a Īharaira i Īhipa; ko taua Mohi rāua ko Ārona tēnei. ");
INSERT INTO mri2012_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ā, i te rā anō i kōrero rā a Ihowā ki a Mohi i te whenua o Īhipa, ");
INSERT INTO mri2012_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ka kōrero a Ihowā ki a Mohi, ka mea, “Ko Ihowā ahau; kōrerotia ki a Parao kīngi o Īhipa ngā mea katoa e kōrero nei ahau ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ā, ka mea a Mohi i te aroaro o Ihowā, “Nanā, he ngutu kokotikore ahau, ā, me pēhea e rongo ai a Parao ki ahau?” ");
INSERT INTO mri2012_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ā, ka mea a Ihowā ki a Mohi, “Nā, kua oti koe te mea e ahau hei atua ki a Parao; ko Ārona hoki, ko tōu tuakana, hei poropiti māu. ");
INSERT INTO mri2012_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kōrerotia ngā mea katoa e kī ai ahau ki a koe; ā, mā Ārona, mā tōu tuakana, e kōrero ki a Parao, kia tukua e ia ngā tama a Īharaira i tōna whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ā, māku e whakapakeke te ngākau o Parao, e whakamaha hoki āku tohu me āku merekara ki te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Otiia, e kore a Parao e rongo ki a kōrua, ā, ka pā tōku ringa ki Īhipa, he nui anō hoki ngā whakawā e whakaputaina ai e ahau āku mano tini, tāku iwi, ngā tama a Īharaira, i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","A, e mōhio ngā Īhipiana ko Ihowā ahau, ina totoro tōku ringa ki Īhipa, ā, ka whakaputaina mai e ahau ngā tama a Īharaira i roto i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","I mea anō a Mohi rāua ko Ārona i tā Ihowā i whakahau ai ki a rāua, pērā ana rāua. ");
INSERT INTO mri2012_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ā, e waru tekau ngā tau o Mohi, e waru tekau mā toru ngā tau o Ārona, i tā rāua kōrerotanga ki a Parao. ");
INSERT INTO mri2012_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ā, i kōrero a Ihowā ki a Mohi rāua ko Ārona, i mea, ");
INSERT INTO mri2012_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ki te puta ki a kōrua tā Parao kupu, ‘Tēnā koa, tētahi merekara i a kōrua,’ ko reira koe mea ai ki a Ārona, ‘E mau ki tāu tokotoko, makā iho ki te aroaro o Parao,’ ā, ka nākahi.” ");
INSERT INTO mri2012_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Nā, ka haere a Mohi rāua ko Ārona ki a Parao, ā, pērātia ana e rāua me tā Ihowā i mea ai; makā iho ana e Ārona tōna tokotoko ki te aroaro o Parao, ki te aroaro hoki o āna tāngata, nā, kua nākahi. ");
INSERT INTO mri2012_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Nā, ka karanga hoki a Parao i ngā tāngata mōhio, i ngā tohunga māori; nā, ko rātou, ko ngā tohunga o Īhipa, i pērā anō rātou ki ā rātou nei karakia māori. ");
INSERT INTO mri2012_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Makā iho ana hoki e tēnei, e tēnei, ā rātou tokotoko, ā, nākahi ana. Otiia, i horomia ā rātou tokotoko e te tokotoko a Ārona. ");
INSERT INTO mri2012_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Nā, ka whakapakeketia e ia te ngākau o Parao, ā, kīhai ia i rongo ki a rāua, ko tā Ihowā hoki i kī ai. ");
INSERT INTO mri2012_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","I mea anō a Ihowā ki a Mohi, “E pakeke ana te ngākau o Parao, kāhore ia e whakaae ana ki te tuku i te iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Haere ki a Parao i te ata, nā, e haere ana ia ki te wai; ā, hei te pareparenga o te awa tū atu ai koe ki a ia; ko te tokotoko hoki i nākahi rā, maua i tōu ringa. ");
INSERT INTO mri2012_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ā, ka mea koe ki a ia, ‘Nā Ihowā, nā te Atua o ngā Hiperu ahau i unga mai ki a koe; e mea ana ia: Tukua tāku iwi kia mahi ki ahau i te koraha, titiro, kāhore koe kia rongo ā mohoa noa nei. ");
INSERT INTO mri2012_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ko te kupu tēnei a Ihowā: Mā konei e mōhio ai koe ko Ihowā ahau. Nanā, māku e patu ngā wai i te awa ki te tokotoko i tōku ringa, ā, ka riro kē hei toto. ");
INSERT INTO mri2012_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","E mate hoki ngā ika i roto i te awa, ā, e piro te awa; ā, e anuanu ngā Īhipiana ki te inu i te wai o te awa.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ā, i kōrero a Ihowā ki a Mohi, “Mea atu ki a Ārona, ‘E mau ki tāu tokotoko, totoro hoki tōu ringa ki ngā wai o Īhipa, ki ō rātou wai e rere ana, ki ō rātou awa, ki ō rātou roto, ki ō rātou huihuinga wai katoa, kia meinga ai hei toto; ā, ka whai toto ngā oko rākau, kōhatu hoki, i te whenua katoa o Īhipa.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ā, pērātia ana e Mohi rāua ko Ārona me tā Ihowā i ako ai. Hāpainga ana e ia te tokotoko, patua ana ki ngā wai o te awa, i te tirohanga a Parao, i te tirohanga anō hoki a āna tāngata; ā, riro kē ana hei toto ngā wai katoa o te awa. ");
INSERT INTO mri2012_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ā, mate ana ngā ika i te awa, ā, piro ana te awa, kīhai hoki i āhei i ngā Īhipiana te inu i te wai o te awa. Nā, he toto tērā i te whenua katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ā, pērātia ana e ngā tohunga o Īhipa ki ā rātou nā mahi māori; ā; ka whakapakeketia te ngākau o Parao, kāhore hoki ia i whakarongo ki a rāua; i rite tonu ki tā Ihowā i kōrero ai. ");
INSERT INTO mri2012_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Nā, tahuri ana a Parao, haere ana ki roto ki tōna whare, kīhai anō hoki i whakaanga i tōna ngākau ki tēnei. ");
INSERT INTO mri2012_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nā, ka keri ngā Īhipiana katoa ki ngā taha o te awa i te wai hei inu; kīhai hoki i āhei te inu i te wai o te awa. ");
INSERT INTO mri2012_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nā, kua rite ngā rā e whitu i muri i tā Ihowā patunga i te awa. ");
INSERT INTO mri2012_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nā, ka kōrero a Ihowā ki a Mohi, “Haere ki a Parao, mea atu ki a ia, ‘Ko te kupu tēnei a Ihowā: Tukua tāku iwi kia haere, kia mahi rātou ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ā, ki te kore koe e rongo ki te tuku i a rātou, nā, ka patua e ahau ōu rohe katoa ki te poroka. ");
INSERT INTO mri2012_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ā, ka ngahuehue ake te poroka i te awa, ka tae rātou ki tōu whare, ki tōu whare moenga, ki runga hoki ki tōu moenga, ki roto hoki ki te whare o ōu tāngata, ki runga hoki ki tōu iwi, ki roto ki āu oumu, ki roto hoki ki āu pokepokenga parāoa. ");
INSERT INTO mri2012_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ā, e haere ake te poroka ki runga ki a koe, ki runga ki tōu iwi, ki runga hoki ki ōu tāngata katoa.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","I kōrero anō a Ihowā ki a Mohi, “Mea atu ki a Ārona, ‘Totoro tōu ringa, me tāu tokotoko, ki ngā wai e rere ana, ki ngā awa, ki ngā roto, kia haere ake ai ngā poroka ki te whenua o Īhipa.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ā, ka totoro atu te ringa o Ārona ki ngā wai o Īhipa; nā, kua puta ake te poroka, ā, kapi ana te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ā, i pērātia anō e ngā tohunga ki ā rātou karakia māori, ā, whakaputaina ake ana e rātou te poroka ki te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Nā, ka karanga a Parao ki a Mohi rāua ko Ārona, ka mea, “Īnoi atu ki a Ihowā, kia tangohia e ia ngā poroka i ahau, i tōku iwi hoki; ā, ka tuku ahau i te iwi ki te mea patunga tapu ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Nā, ka mea a Mohi ki a Parao, “Kia whakanuia ake koe i ahau; āhea īnoi ai ahau mōu, mō ōu tāngata, mō tōu iwi hoki, kia whakakāhoretia atu ngā poroka i a koe, i ōu whare anō hoki, kia toe ki te awa anake?” ");
INSERT INTO mri2012_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ā, ka mea ia, “Hei āpōpō.” Nā, ka mea ia, “Kia rite ki tāu nā, kia mōhio ai koe kāhore tētahi e rite ana ki a Ihowā, ki tō mātou Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ā, ka mawehe atu i a koe ngā poroka, i ōu whare hoki, i ōu tāngata, i tōu iwi anō hoki; ā, e toe ki te awa anake.” ");
INSERT INTO mri2012_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Nā, ka haere atu a Mohi rāua ko Ārona i a Parao; ā, ka karanga a Mohi ki a Ihowā, mō ngā poroka i whakamuia ake e ia ki a Parao. ");
INSERT INTO mri2012_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ā, pērātia ana e Ihowā me tā Mohi i mea ai; nā, ka mate atu ngā poroka i ngā whare, i ngā kāinga, i ngā māra anō hoki. ");
INSERT INTO mri2012_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ā, apoapohia ana e rātou, pūranga atu, pūranga atu; ā, piro ana te whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Otirā, i te kitenga o Parao ka whai tānga manawa, ka whakapakeke anō i tōna ngākau, kāhore hoki i rongo ki a rāua; ko tā Ihowā hoki i kī ai. ");
INSERT INTO mri2012_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Nā, ka mea a Ihowā ki a Mohi, “Mea atu ki a Ārona, ‘Totoro tāu tokotoko, patua te puehu o te whenua, kia kutu ai ki te whenua katoa o Īhipa.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ā, pērā ana rāua; ko te toronga atu o te ringa o Ārona me tāna tokotoko, patua ana te puehu o te whenua, ā, ka meinga hei kutu ki te tangata, ki te kararehe; he kutu kau te puehu katoa o te oneone, i te whenua katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ā, pērā ana anō ngā tohunga ki ā rātou mahi māori, kia puta ai te kutu; kīhai ia i taea e rātou; ā, muia ana te tangata me te kararehe e te kutu. ");
INSERT INTO mri2012_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Nā, ka mea ngā tohunga ki a Parao, “Nā te matikara o te Atua tēnei!” Ā, ka whakapakeketia te ngākau o Parao, kīhai hoki ia i rongo ki a rāua; ko tā Ihowā hoki i kī ai. ");
INSERT INTO mri2012_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nā, ka mea a Ihowā ki a Mohi, “Maranga wawe i te ata, e tū ki te aroaro o Parao; nā, e haere ana ia ki te wai; mea atu ki a ia, ‘Ko te kupu tēnei a Ihowā: Tukua tāku iwi ki te mahi ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ā, ki te kāhore koe e tuku i tāku iwi, nā, ka tukua atu e ahau ngā pōkai namu ki a koe, ki ōu tāngata, ki tōu iwi, ki ōu whare. E kī hoki ngā whare o ngā Īhipiana i ngā pōkai namu, me te whenua e noho nei rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Ā, ka wehea atu e ahau i taua rā te whenua o Kohena, e noho nei tāku iwi, kei whai pōkai namu a reira; kia mōhio ai koe ko Ihowā ahau i waenganui o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ka whakatakoto ārai anō ahau ki waenganui o tāku iwi, o tōu iwi. Ko āpōpō tēnei tohu meatia ai.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ā, pērā ana a Ihowā; nā, kua tae mai ngā pōkai namu, tōna nanakia rā, ki te whare o Parao, ki ngā whare o āna tāngata, ki te whenua katoa anō hoki o Īhipa; ā, ngaro ana te whenua i te huihuinga namu. ");
INSERT INTO mri2012_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Nā, ka karanga a Parao ki a Mohi rāua ko Ārona, ka mea, “Haere, meatia he patunga tapu ki tō koutou Atua, ki te whenua nei.” ");
INSERT INTO mri2012_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Nā, ka mea a Mohi, “E kore e pai kia pēnā; ka patua hoki e mātou mā Ihowā, mā tō mātou Atua, tā ngā Īhipiana e mōrikarika ai. Nā, ki te patua e mātou ki tō rātou aroaro ngā mea e mōrikarika ai ngā Īhipiana, e kore rānei rātou e āki i a mātou ki te kōhatu? ");
INSERT INTO mri2012_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ka haere mātou ki te koraha, kia toru ngā rā ki te ara, ka mea patunga tapu ai ki a Ihowā, ki tō mātou Atua, ka pērā ai me tāna e ako ai ki a mātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Nā, ka mea a Parao, “Ka tukua koutou ki te mea patunga tapu mā Ihowā, mā tō koutou Atua, ki te koraha. Otiia, aua e haere rawa ki tawhiti. Īnoi kōrua mōku.” ");
INSERT INTO mri2012_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ā, ka mea a Mohi, “Nanā, ka mawehe atu ahau i a koe, ka īnoi ahau ki a Ihowā kia tūrere atu ngā pōkai namu i a Parao, i ōna tāngata, i tōna iwi āpōpō; otiia kaua a Parao e tinihanga anō, ā, kore ake e tuku i te iwi ki te mea patunga tapu ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Nā, ka mawehe a Mohi i a Parao, ā, ka īnoi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ā, pērātia ana e Ihowā me tā Mohi i mea ai; i mea ia i ngā pōkai namu kia rere atu i a Parao, i ōna tāngata, i tōna iwi. Kīhai i toe tētahi. ");
INSERT INTO mri2012_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Nā, ka whakapakeke anō a Parao i tōna ngākau i taua tāima hoki, ā, kīhai i tuku i te iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Nā, ka mea a Ihowā ki a Mohi, “Haere ki a Parao, mea atu ki a ia, ‘Ko te kupu tēnei a Ihowā, a te Atua o ngā Hiperu: “Tukua tāku iwi kia haere ki te mahi ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ki te kore hoki koe e rongo ki te tuku, ki te pupuri tonu i a rātou; ");
INSERT INTO mri2012_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nanā, ka pā te ringa o Ihowā ki āu kararehe i te pārae: ki ngā hōiho, ki ngā kāihe, ki ngā kāmera, ki ngā kau, ki ngā hipi; ka pā he mate kino rawa. ");
INSERT INTO mri2012_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ā, e wehewehe a Ihowā i ngā kararehe a Īharaira, i ngā kararehe a Īhipa; e kore e mate tētahi o ngā mea katoa a ngā tama a Īharaira.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","I whakaritea anō e Ihowā he tāima, i mea ia, “Ko āpōpō a Ihowā mea ai i tēnei mea ki te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","I te aonga ake ka meatia taua mea e Ihowā; ā mate iho ngā kararehe katoa o Īhipa; ko ngā kararehe ia a ngā tama a Īharaira, kīhai i mate tētahi. ");
INSERT INTO mri2012_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nā, ka tonoa he kaititiro e Parao, nā, kāhore i mate kia kotahi o ngā kararehe a ngā tama a Īharaira. Ā, ka whakapakeketia te ngākau o Parao, kīhai hoki ia i tuku i te iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Nā, ka mea a Ihowā ki a Mohi rāua ko Ārona, “Aohia mai ētahi pungarehu mā kōrua i te oumu, kia kī ngā ringa, ā, mā Mohi e ruke whaka te rangi i te tirohanga a Parao. ");
INSERT INTO mri2012_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ā, ka whakapuehu ririki ki te whenua katoa o Īhipa, ā, ka meinga hei whēwhē pukupuku e tupu ana ki te tangata, ki te kararehe i te whenua katoa o Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Nā, ka aohia e rāua he pungarehu i te oumu, ā, tū ana ki te aroaro o Parao; ā, ka rukea e Mohi whaka te rangi, nā, he whēwhē pukupuku e tupu ana ki te tangata, ki te kararehe. ");
INSERT INTO mri2012_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ā, kīhai ngā tohunga i āhei te tū ki te aroaro o Mohi i ngā whēwhē; kei ngā tohunga hoki te whēwhē, kei ngā Īhipiana katoa anō hoki. ");
INSERT INTO mri2012_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nā, ka whakapakeke a Ihowā i te ngākau o Parao, ā, kīhai ia i rongo ki a rāua; ko tā Ihowā hoki i kī ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Nā, ka mea a Ihowā ki a Mohi, “Maranga wawe i te ata, ka tū ki te aroaro o Parao, ka mea ki a ia, ‘E pēnei mai ana a Ihowā, te Atua o ngā Hiperu: Tukua tāku iwi kia haere ki te mahi ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ko ā tēnei tāima hoki ka tukua atu e ahau āku whiu katoa ki tōu ngākau, ki ōu tāngata hoki, rātou ko tōu iwi; kia mōhio ai koe kāhore tētahi e rite ana ki ahau i te whenua katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ko ākuanei hoki tākiritia ai tōku ringa, ā, ka patu ahau i a koe, i tōu iwi hoki, ki te mate urutā; ā, ka ngaro atu koe i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Otiia mō konei pū ahau i whakaara ai i a koe, kia ai koe hei whakakitenga mō tōku kaha; kia kōrerotia ai hoki tōku ingoa ki te ao katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","E whakakake tonu ana anō koe ki tāku iwi, tē tuku ai i a rātou? ");
INSERT INTO mri2012_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nanā, kia pēnei āpōpō, ka uaina e ahau he whatu, he mea nanakia rawa, kāhore he pēnā i Īhipa o te pito nohoanga iho anō ā mohoa noa nei. ");
INSERT INTO mri2012_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Nā, ungā atu, huihuia āu kararehe, me āu mea katoa i te pārae; ko ngā tāngata katoa me ngā kararehe e rokohanga ki te pārae, ā, kīhai i huihuia ki te whare, ina, ka rere iho te whatu ki runga ki a rātou, ā, ka mate.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ko te tangata a Parao i wehi i te kupu a Ihowā, i meatia e ia ōna tāngata me āna kararehe kia rere ki ngā whare. ");
INSERT INTO mri2012_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ko te tangata ia kīhai i anga tōna ngākau ki te kupu a Ihowā, i waiho atu e ia āna tāngata me āna kararehe i te pārae. ");
INSERT INTO mri2012_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Nā, ka mea a Ihowā ki a Mohi, “Totoro atu tōu ringa ki te rangi, kia puta ai he whatu ki te whenua katoa o Īhipa, ki te tangata, ki te kararehe, ki ngā mea tupu katoa o te māra, i te whenua katoa o Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Nā, ka toro atu te tokotoko a Mohi whaka te rangi; ko te tino tukunga mai a Ihowā i ngā whatitiri, i te whatu; ā, rere ana te ahi ki runga i te whenua; ā, uaina iho ana e Ihowā te whatu ki te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Nā, he whatu tēnā, he ahi hoki e whakauru ana ki roto ki te whatu, he nanakia rawa, kāhore ōna rite i te whenua katoa o Īhipa, o te tīmatanga iho anō o taua iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Nā, i patua iho e te whatu, i te whenua katoa o Īhipa, ngā mea katoa i te pārae, te tangata, te kararehe; i patu anō te whatu i ngā otaota katoa o te māra, i whatiwhati hoki i ngā rākau katoa o te māra. ");
INSERT INTO mri2012_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ko te whenua ia o Kohena, i ngā tama a Īharaira, kāhore he whatu. ");
INSERT INTO mri2012_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Nā, ka tono tangata a Parao hei karanga i a Mohi rāua ko Ārona, ā, ka mea ia ki a rāua, “Kua hara ahau i tēnei wā; he tika a Ihowā, tēnā ko ahau, mātou tahi ko tōku iwi, he kino. ");
INSERT INTO mri2012_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Īnoi ki a Ihowā; kua iro nā hoki i ēnei whatitiri nunui me ngā whatu; ā, ka tuku ahau i a koutou, ā, heoi anō tō koutou nohoanga.” ");
INSERT INTO mri2012_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Nā, ka mea a Mohi ki a ia, “Kia puta atu ahau ki waho i te pā, ka whakatuwhera atu ahau i ōku ringa ki a Ihowā; ā, e mutu ngā whatitiri, ā, ka kore noa iho te whatu; kia mōhio ai koe nō Ihowā te whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ko koe ia, me āu tāngata, e mōhio ana ahau kāhore anō koutou i wehi noa i a Ihowā, i te Atua.” ");
INSERT INTO mri2012_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(I patua te kōrari, me te pārei; kua pupuku hoki te pārei, kua pua hoki te kōrari. ");
INSERT INTO mri2012_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ko te wīti ia me te rai kīhai i patua; kāhore hoki ēnā i tupu noa.) ");
INSERT INTO mri2012_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Nā, ka mawehe atu a Mohi i a Parao ki waho i te pā, ā, ka whakatuwhera i ōna ringa ki a Ihowā; ā mutu iho ngā whatitiri me te whatu, kīhai hoki te ua i ringihia ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ā, nō te kitenga a Parao kua mutu te ua, te whatu, me ngā whatitiri, ka hara anō ia, ka whakapakeke i tōna ngākau, rātou tahi ko ōna tāngata. ");
INSERT INTO mri2012_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Heoi, whakapakeketia ana te ngākau o Parao, kīhai hoki ia i tuku i ngā tama a Īharaira; ko tā Ihowā hoki i kōrero ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Nā, ka mea a Ihowā ki a Mohi, “Haere ki a Parao; kua whakapakeke hoki ahau i tōna ngākau, i te ngākau hoki o ōna tāngata, kia whakakite ai ahau i ēnei tohu āku ki tōna aroaro, ");
INSERT INTO mri2012_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","kia kōrero ai hoki koe ki ngā taringa o tāu tama, o te tama hoki a tāu tama, i tāku i mahi ai ki Īhipa, i āku tohu hoki i meatia e ahau i roto i a rātou – kia mōhio ai koutou ko Ihowā ahau.” ");
INSERT INTO mri2012_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ā, haere ana a Mohi rāua ko Ārona ki a Parao, mea ana ki a ia, “Ko te kupu tēnei a Ihowā, a te Atua o ngā Hiperu, ‘Kia pēhea te roa ōu kāhore nei e ngohengohe ki tōku aroaro? Tukua tāku iwi kia haere, kia mahi ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ko tēnei, ka kore koe e rongo ki te tuku i tāku iwi, nanā, āpōpō ahau kawe mai ai i te māwhitiwhiti ki tōu rohe. ");
INSERT INTO mri2012_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ā, e kapi i a rātou te mata o te whenua, e kore anō e āhei te kite i te whenua; ā, e kai rātou i ngā toenga i mahue, i toe mā koutou i te whatu, e kai hoki rātou i ngā rākau katoa e tupu ana mā koutou i te māra. ");
INSERT INTO mri2012_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ā, e kī i a rātou ōu whare, me ngā whare o ōu tāngata katoa, me ngā whare o ngā Īhipiana katoa; he mea kīhai nei i kitea e ōu mātua, e ngā mātua rānei o ōu mātua, o te rā iho anō i noho ai rātou ki te whenua ā moroki noa nei.’ ” Ā, tahuri ana ia, haere atu ana i a Parao. ");
INSERT INTO mri2012_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ā, ka mea ngā tāngata a Parao ki a ia, “Kia pēhea te roa o tēnei tangata ka waiho nei hei rore ki a tātou? Tukua ngā tāngata ki te mahi ki a Ihowā, ki tō rātou Atua. Kīanō koe i mōhio noa kua ngaro a Īhipa?” ");
INSERT INTO mri2012_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Nā, ka whakahokia a Mohi rāua ko Ārona ki a Parao; ā, ka mea ia ki a rāua, “Haere, e mahi ki a Ihowā ki tō koutou Atua; ko wai mā oti e haere?” ");
INSERT INTO mri2012_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ā, ka mea a Mohi, “E haere rā mātou me ā mātou taitamariki, me ō mātou koroheke, me ā mātou tama, me ā mātou tamāhine, e haere me ā mātou hipi, me ā mātou kau; he hākari hoki tā mātou ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Nā, ka mea ia ki a rāua, “Kia pēnā te noho o Ihowā ki a koutou, me ahau ka tuku nei i a koutou me ā koutou pōtiki. Mā koutou e titiro; he kino hoki kei mua i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Kāhore rā hoki! Haere e ngā tāne, e mahi ki a Ihowā; ko tā koutou hoki tēnā i whai nā.” Ā, peia ana rāua i te aroaro o Parao. ");
INSERT INTO mri2012_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Nā, ka mea a Ihowā ki a Mohi, “Totoro atu tōu ringaringa ki te whenua o Īhipa mō te māwhitiwhiti kia puta ki te whenua o Īhipa, ki te kai i ngā otaota katoa o te whenua, i ngā mea katoa i toe i te whatu.” ");
INSERT INTO mri2012_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Nā, ka toro atu te tokotoko a Mohi ki runga i te whenua o Īhipa, ā, kua puta he hau i a Ihowā, he marangai, ki te whenua, ā, pau katoa taua rangi, pau katoa taua pō; ā, huaki ake te ata, nā, kua kawea mai ngā māwhitiwhiti e te marangai. ");
INSERT INTO mri2012_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ā, puta ake ana te māwhitiwhiti ki te whenua katoa o Īhipa, ā, tau iho ki ngā rohe katoa o Īhipa, he nanakia rawa; kāhore he māwhitiwhiti ō mua atu hei rite mō ēnei, e kore anō hoki e rite ā muri ake nei. ");
INSERT INTO mri2012_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ngaro ana hoki i a rātou te mata o te whenua katoa, pōuri ana te whenua; ā, kainga ake e rātou ngā otaota katoa o te whenua, me ngā hua katoa o ngā rākau i toe i te whatu. Kīhai i mahue tētahi tupu o ngā rākau, o ngā otaota rānei o te māra, i te whenua katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Nā, ka hohoro a Parao te karanga ki a Mohi rāua ko Ārona ka mea, “Kua hara ahau ki a Ihowā, ki tō koutou Atua, ki a kōrua hoki. ");
INSERT INTO mri2012_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Nā, whakarērea tōku hara, heoi rawa anō ko tō tēnei tāima, ā, īnoi ki a Ihowā, ki tō koutou Atua, kia tangohia atu e ia ko tēnei mate anake i ahau.” ");
INSERT INTO mri2012_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ā, mawehe ana ia i a Parao, īnoi ana ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nā, whakatakā ana e Ihowā he hauāuru nui rawa, nāna i kāhaki atu ngā māwhitiwhiti, i whiu ki te Moana Whero; kīhai i toe tētahi māwhitiwhiti i ngā rohe katoa o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Otiia whakapakeke ana a Ihowā i te ngākau o Parao, ā, kīhai ia i tuku i ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ā, ka mea a Ihowā ki a Mohi, “Totoro ake tōu ringaringa ki te rangi, kia whai pōuri ai ki te whenua o Īhipa, he pōuri e hakiri mai ana ki te ringa.” ");
INSERT INTO mri2012_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Nā, ka toro atu te ringa o Mohi ki te rangi, ā, kua pōuri kerekere i te whenua katoa o Īhipa, e toru ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kāhore tētahi i kite i tētahi, kīhai anō hoki i whakatika atu tētahi i tōna wāhi i ngā rā e toru. Tēnā ko ngā tama a Īharaira, mārama ana ō rātou nā nohoanga. ");
INSERT INTO mri2012_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Nā, ka karanga a Parao ki a Mohi, ka mea, “Haere, e mahi ki a Ihowā, otiia me waiho ā koutou hipi me ā koutou kau. Ko ā koutou tamariki nonohi hoki me haere tahi i a koutou.” ");
INSERT INTO mri2012_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ā, ka mea a Mohi, “Me hōmai anō e koe ki a mātou he patunga tapu, he tahunga tinana, hei mahinga mā mātou ki a Ihowā, ki tō mātou Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Me haere anō ā mātou kararehe i a mātou; e kore tētahi maikuku e mahue. Ka tangohia hoki e mātou ētahi o ēnā hei mahinga ki a Ihowā, ki tō mātou Atua; e kore hoki mātou e mōhio ki tā mātou e mahi ai ki a Ihowā, kia tae rā anō ki reira.” ");
INSERT INTO mri2012_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Otiia whakapakeketia ana e Ihowā te ngākau o Parao, ā, kīhai ia i pai ki te tuku i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Nā, ka mea a Parao ki a ia, “Mawehe atu i ahau, kia tūpato kei kite koe i tōku kanohi ā muri ake nei; ko te rā hoki e kite ai koe i tōku kanohi, ka mate koe.” ");
INSERT INTO mri2012_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Anō rā ko Mohi, “Ka tika tāu kōrero, heoi anō tāku kitenga i tōu kanohi ki muri ake nei.” ");
INSERT INTO mri2012_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Nā, ka mea a Ihowā ki a Mohi, “Kia kotahi atu whiu e whakapāngia e ahau ki a Parao, ki Īhipa; muri iho ka tukua koutou e ia i konei. Ka tukua koutou, inā, ka tino peia katoatia koutou e ia i konei. ");
INSERT INTO mri2012_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kōrero ināianei ki ngā taringa o te iwi, ā, mā te tāne, mā te wahine, e tono he mea hiriwa, he mea kōura i tōna hoa, i tōna hoa.” ");
INSERT INTO mri2012_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Ā, i meinga anō e Ihowā kia paingia te iwi e ngā Īhipiana. Ko te tangata nei hoki ko Mohi, i nui rawa ki te whenua o Īhipa, ki te aroaro o ngā tāngata a Parao, ki te aroaro anō hoki o te iwi.) ");
INSERT INTO mri2012_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Nā, ka mea a Mohi, “Ko te kupu tēnei a Ihowā: ‘Hei waenganui pō ahau ka tika nā waenganui o Īhipa; ");
INSERT INTO mri2012_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ā, ka mate ngā mātāmua katoa o te whenua o Īhipa, te mātāmua a Parao e noho ana i runga i tōna torōna, ā tae iho ana ki te mātāmua a te pononga wahine i tua i te mira; me ngā mātāmua katoa a ngā kararehe. ");
INSERT INTO mri2012_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ā, ka nui te tangi i te whenua katoa o Īhipa, kāhore he pērā i mua, e kore anō hoki e pērā e takoto ake nei. ");
INSERT INTO mri2012_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Otirā, e kore e oraora te arero o tētahi kurī ki tētahi o ngā tama a Īharaira, ki te tangata, ki te kararehe;’ kia mōhio ai koutou e tītore ana a Ihowā i waenga o ngā Īhipiana, o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ā, e haere ake ēnei tāngata katoa āu ki ahau, e piko ki ahau, e mea, ‘Haere koe me te iwi katoa e haere ana i raro i ōu waewae.’ Ā muri iho ka haere ahau.” Ā, puta ana ia i a Parao, he nui hoki tōna riri. ");
INSERT INTO mri2012_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ā, ka mea a Ihowā ki a Mohi, “E kore a Parao e rongo ki a kōrua, kia maha ai āku merekara ki te whenua o Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ā, meatia ana e Mohi rāua ko Ārona ēnei merekara katoa ki te aroaro o Parao; ā, i whakapakeke anō a Ihowā i te ngākau o Parao, ā, kīhai ia i tuku i ngā tama a Īharaira i tōna whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ā, i kōrero a Ihowā ki a Mohi rāua ko Ārona i te whenua o Īhipa, i mea: ");
INSERT INTO mri2012_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ko tēnei marama hei marama tīmatanga ki a koutou; hei tīmatanga tēnei mō ngā marama o tō koutou tau. ");
INSERT INTO mri2012_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kōrero ki te huihuinga katoa o Īharaira, mea atu, Hei te tekau o ngā rā o tēnei marama, me tango he reme mā rātou e tēnei, e tēnei, kia rite ki ngā whare o ngā mātua, he whare, he reme. ");
INSERT INTO mri2012_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ā ki te tokoouou te whare mō te reme, mā rāua ko tōna hoa noho tata ki tōna whare e tango, kia rite ki te tokomaha o ngā tāngata; whakaritea te tokomaha o ngā tāngata mō te reme ki te kai a tēnei, a tēnei. ");
INSERT INTO mri2012_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kei whai koha tā koutou reme, hei te toa, hei te tau tahi; tangohia mai i ngā hipi, i ngā koati rānei. ");
INSERT INTO mri2012_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ā, me tiaki e koutou taea noatia te tekau mā whā o ngā rā o tēnei marama; ā, mā te huihui katoa o tō Īharaira whakaminenga e patu i te ahiahi. ");
INSERT INTO mri2012_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ā, me tango e rātou tētahi wāhi o ngā toto, ka tā atu ai ki ngā pou e rua, ki te kōrupe hoki o te tatau o ngā whare e kainga ai tēnā mea e rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ā, me kai te kikokiko i taua pō anō, he mea tunu ki te ahi, he taro rēwenakore hoki; he pūwhā kawa hoki tā rātou e kīnaki ai ki taua mea. ");
INSERT INTO mri2012_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kaua tētahi wāhi e kainga matatia, he mea kōhua rānei ki te wai, engari kia tunua ki te ahi; ko tōna pane, ko ōna waewae, me ōna whēkau. ");
INSERT INTO mri2012_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kaua hoki e whakatoea tētahi wāhi ōna ki te ata; ā, ko te wāhi ōna e toe ki te ata, tahuna ki te ahi. ");
INSERT INTO mri2012_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ā, me pēnei tā koutou kai i taua mea; kia whītikiria ō koutou hope, hei ō koutou waewae ō koutou hū, ko ā koutou tokotoko hoki ki ō koutou ringaringa; kia hohoro hoki te kai. Ko te Kapenga hoki a Ihowā tēnā. ");
INSERT INTO mri2012_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Tā te mea ka tika ahau rā waenganui o te whenua o Īhipa i taua pō, ka patu hoki i ngā mātāmua katoa i te whenua o Īhipa, i te tangata ā tae iho ana ki te kararehe; ā, ka puta āku whakawā ki ngā atua katoa o Īhipa. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ā, hei tohu mō koutou te toto i ngā whare e noho ai koutou; ā, ka kite ahau i te toto, ka kape ahau i a koutou, e kore anō hoki te whiu e pā ki a koutou hei whakamate, ina patu ahau i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ā, hei whakamaharatanga mō koutou tēnei rā; hei konei koutou tuku ai i te hākari ki a Ihowā, tuku iho ki ō koutou whakatupuranga; ko te ture tēnei ake nei, ake nei, kia hākaritia e koutou tēnei rā. ");
INSERT INTO mri2012_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","E whitu ngā rā e kai ai koutou i te taro rēwenakore; hei te rā tuatahi anō ka whakakorea ai te rēwena o ō koutou whare; tā te mea ki te kai tētahi i te taro rēwena i te rā tuatahi, ā taea noatia te whitu o ngā rā, ka hātepea atu taua wairua i roto i a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Hei te rā tuatahi hoki he huihuinga tapu, hei te rā tuawhitu hoki he huihuinga tapu mō koutou; kaua tētahi mahi e mahia i aua rā; heoi anō ko te kai mā tēnei, mā tēnei, tā koutou e raweke ai. ");
INSERT INTO mri2012_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Kia mau hoki ki te Hākari o te Taro Rēwenakore; nō te mea, nō tēnei rangi pū anō i whakaputaina ai e ahau ō koutou rōpū i te whenua o Īhipa. Mō konei, kia mau ki tēnei rā, i ō koutou whakatupuranga; hei tikanga tēnei ake ake. ");
INSERT INTO mri2012_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Hei te marama tuatahi, hei te kotahi tekau mā whā o ngā rā, i te ahiahi, ka kai koutou i te taro rēwenakore, ā tae noa ki te rua tekau mā tahi o ngā rā o te marama, i te ahiahi. ");
INSERT INTO mri2012_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Kaua he rēwena e kitea ki ō koutou whare i ngā rā e whitu; tā te mea ki te kai tētahi i te mea kua rēwenatia, inā, ka hātepea atu taua wairua i roto i te huihui o Īharaira, ahakoa tangata kē, ahakoa tangata whenua rānei. ");
INSERT INTO mri2012_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Kaua e kainga tētahi mea kua rēwenatia; hei te taro rēwenakore he kai mā koutou i ō koutou nohoanga katoa.” ");
INSERT INTO mri2012_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Nā, ka karanga a Mohi ki ngā kaumātua katoa o Īharaira, ka mea ki a rātou, “Tīkina, tangohia mai mā koutou he reme, kia rite ki ō koutou whānau, patua hoki te Kapenga. ");
INSERT INTO mri2012_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ā, tangohia he paihere hihopa, ka tuku ki te toto i te peihana, nā, ka tātā atu i te kōrupe me ngā pou e rua ki te toto i te peihana; kaua hoki tētahi o koutou e puta ki waho o te kūwaha o tōna whare, ā taea noatia te ata. ");
INSERT INTO mri2012_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","He mea hoki, ka haere atu a Ihowā ki te patu i ngā Īhipiana; ā, ka kite ia i te toto i te kōrupe, i ngā pou e rua hoki, ka kapea e Ihowā te kūwaha, e kore hoki e tukua e ia te kaiwhakamate kia haere ki roto ki ō koutou whare patu ai. ");
INSERT INTO mri2012_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Kia mau hoki ki tēnei mea, hei ture mōu, mō āu tamariki, ake ake. ");
INSERT INTO mri2012_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ā tēnei ake, ā te wā e tae ai koutou ki te whenua e hōmai e Ihowā ki a koutou, ki tāna i kōrero ai, nā, kia mau ki tēnei mahi. ");
INSERT INTO mri2012_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ā tēnei ake, ki te mea ā koutou tamariki ki a koutou, ‘He aha tēnei e mahia nei e koutou?’ ");
INSERT INTO mri2012_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Nā, ka mea atu, ‘Ko te patunga rā i tā Ihowā Kapenga, nāna rā i kape ngā whare o ngā tama a Īharaira i Īhipa, i a ia i patu ai i ngā Īhipiana, ā, whakaorangia ake ō mātou whare.’ ” Nā, tuohu ana te iwi, koropiko ana. ");
INSERT INTO mri2012_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Nā, ka haere ngā tama a Īharaira, ā, mea ana i tā Ihowā i whakahau ai ki a Mohi rāua ko Ārona, pērā ana rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nāwai ā, ka waenganui pō, nā, patua ana e Ihowā ngā mātāmua katoa i te whenua o Īhipa, te mātāmua a Parao e noho ana i runga i tōna torōna, ā tae iho ana ki te mātāmua a te herehere i roto i te whare herehere; me ngā mātāmua katoa a te kararehe. ");
INSERT INTO mri2012_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Nā, ka maranga ake a Parao i te pō, rātou ko āna tāngata katoa, ko ngā Īhipiana katoa; nā, he nui te tangi i Īhipa; kāhore hoki he whare i kore te tūpāpaku. ");
INSERT INTO mri2012_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nā, ka karanga ia ki a Mohi rāua ko Ārona i te pō, ā, ka mea, “Whakatika, haere atu i roto i tōku iwi, koutou ko ngā tama a Īharaira; haere ki te mahi ki a Ihowā, ki te pērā me tā koutou i kī ai. ");
INSERT INTO mri2012_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tangohia hoki ā koutou hipi, ā koutou kau hoki, ā koutou i kī ai, ā, haere atu; me manaaki anō hoki i ahau.” ");
INSERT INTO mri2012_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ā, akiaki ana ngā Īhipiana ki te iwi, kia tonoa wawetia atu ai rātou i te whenua; i mea hoki rātou, “Ka mate katoa tātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ā, maua atu ana e te iwi tā rātou, parāoa pokepoke, i te mea kāhore anō i rēwenatia noatia, he mea takai ā rātou pokepokenga parāoa ki ō rātou kākahu, nā, kei ō rātou pokohiwi. ");
INSERT INTO mri2012_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Nā, ka pērā ngā tama a Īharaira me tā Mohi i kī ai; nā, kei te tono mea hiriwa, mea kōura, kākahu, i ngā Īhipiana. ");
INSERT INTO mri2012_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ā, nā Ihowā i mea kia paingia te iwi e ngā Īhipiana, ā, hōmai ana e rātou; ā, pāhuatia ana e rātou ngā Īhipiana. ");
INSERT INTO mri2012_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nā, ka tūria mai e ngā tama a Īharaira i Ramehehe ki Hukota, tata tonu ngā tāne ki ngā mano e ono rau, he mea haere i raro, hāunga ngā tamariki. ");
INSERT INTO mri2012_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","He nui te whakauru i haere i a rātou; me te hipi, me te kau, he tini kē te kararehe. ");
INSERT INTO mri2012_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ā, tunua iho e rātou ētahi taro rēwenakore i te parāoa pokepoke i maua atu e rātou i Īhipa, kāhore hoki i rēwenatia; nō te mea hoki i peia rātou i Īhipa, kīhai hoki i āhei te noho iho, kīhai hoki rātou i taka i te ō mō rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Nā, ko te nohoanga o ngā tama a Īharaira, i noho rā ki Īhipa, e whā rau e toru tekau ngā tau. ");
INSERT INTO mri2012_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ā, i te mutunga o ngā tau e whā rau e toru tekau, i taua rā pū anō, nā, ka puta ngā mano katoa o Ihowā i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ka maharatia taua pō nei, hei mea ki a Ihowā, mō tō rātou whakaputanga i te whenua o Īhipa. Ko taua pō tēnei o Ihowā hei maharatanga mā ngā tama katoa a Īharaira, i ō rātou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","I mea anō a Ihowā ki a Mohi rāua ko Ārona, “Ko te tikanga tēnei mō te Kapenga: Kaua tētahi tangata kē e kai i tēnā mea; ");
INSERT INTO mri2012_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","engari, ngā pononga katoa a te tangata i utua ki te moni, kia oti te kokoti e koe, ka kai ai i tēnā mea. ");
INSERT INTO mri2012_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Kaua te manene, te kaimahi rānei, e kai i tēnā mea. ");
INSERT INTO mri2012_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Kia kotahi te whare e kainga ai; kaua e mauria tētahi wāhi o te kikokiko ki waho i te whare; kaua hoki e whatia tētahi wheua ōna. ");
INSERT INTO mri2012_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Mā te huihuinga katoa o Īharaira tēnā mahi. ");
INSERT INTO mri2012_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Nā, he tangata kē e noho ana i a koe, ā, ka mahi i te Kapenga a Ihowā, kotia āna tāne katoa, kātahi ka whakatata ai ia ki tēnā mahi; ā, ka rite ki te tangata whenua. Kei kainga e te kokotikore. ");
INSERT INTO mri2012_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kia kotahi anō te ture mō te tangata whenua rāua ko te tangata kē e noho ana i roto i a koutou.” ");
INSERT INTO mri2012_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Nā, ka pērā ngā tama katoa a Īharaira me tā Ihowā i ako ai ki a Mohi rāua ko Ārona; pērā ana rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Nā, nō taua rā pū anō i whakaputaina mai ai e Ihowā ngā tama a Īharaira i te whenua o Īhipa, tēnei rōpū, tēnei rōpū o rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ā, i kōrero a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Whakatapua māku ngā mea mātāmua katoa; ngā mea katoa a ngā tama a Īharaira e oroko puta mai ana i te kōpū, a te tangata, a te kararehe, māku.” ");
INSERT INTO mri2012_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ā, i mea a Mohi ki te iwi, “Kia mahara ki tēnei rā i haere atu ai koutou i Īhipa, i te whare pononga; he kaha hoki te ringa i whakaputaina ai koutou e Ihowā i konei. Kaua hoki te taro rēwena e kainga. ");
INSERT INTO mri2012_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ko te rā tēnei i haere atu ai koutou, ko Apipi te marama. ");
INSERT INTO mri2012_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Nā, ka kawea koe a mua e Ihowā ki te whenua o ngā Kanaani, o ngā Hiti, o ngā Amori, o ngā Hiwi, o ngā Iepuhi, i oati ai ia ki ōu mātua ka hoatu ki a koe, he whenua e rerengia ana e te waiū, e te honi, ko reira koe mahi ai i tēnei mea, i tēnei marama anō. ");
INSERT INTO mri2012_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","E whitu ngā rā e kai ai koe i te taro rēwenakore, ā, hei te rā whitu te hākari a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","E whitu ngā rā e kainga ai te taro rēwenakore; aua hoki te taro rēwena e kitea ki a koe; aua anō e kitea ki a koe he rēwena i ōu rohe katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ā, māu e kōrero ki tāu tama i taua rā, e mea, ‘Mō tā Ihowā i mea ai ki ahau tēnei, i tōku haerenga mai i Īhipa.’ ");
INSERT INTO mri2012_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Hei tohu anō tēnā ki a koe i tōu ringa, hei whakamahara hoki ki waenganui i ōu kanohi; kia mau ai te ture a Ihowā i roto i tōu waha; he kaha hoki te ringa i whakaputaina ai koe e Ihowā i Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Nā, kia mau ki tēnei tikanga i tōna wā anō, i tēnei tau, i tēnei tau.” ");
INSERT INTO mri2012_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Nā, ka kawea koe e Ihowā ki te whenua o ngā Kanaani, ki tāna i oati ai ki a koutou ko ōu mātua, ā, ka hōmai a reira e ia ki a koe, ");
INSERT INTO mri2012_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ko reira wehea ai e koe mā Ihowā ngā mea katoa e puta tuatahi mai ana i te kōpū, me ngā mātāmua katoa o āu kararehe; ko ngā tāne mā Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Otiia, me utu e koe ki te reme ngā mātāmua katoa a te kāihe; ā, ki te kāhore e utua e koe, whatia tōna kakī. Ko ngā mātāmua katoa hoki a te tangata, i roto i āu tamariki, me utu e koe. ");
INSERT INTO mri2012_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Ā tēnei ake, ki te ui tāu tama ki a koe ā mua, ki te mea, ‘He aha tēnei?’ Nā, ka mea ki a ia, ‘He kaha te ringa i whakaputaina mai ai mātou e Ihowā i Īhipa, i te whare pononga. ");
INSERT INTO mri2012_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ā, i te mea ka pakeke a Parao ki te tuku i a mātou, nā, patua iho e Ihowā ngā mātāmua katoa o te whenua o Īhipa, te mātāmua a te tangata, te mātāmua anō hoki a te kararehe. Nā reira i patua ai e ahau mā Ihowā ngā mea katoa e puta tuatahi mai ana i te kōpū, ngā toa; ko ngā mātāmua katoa ia o āku tama e utua ana e ahau.’ ");
INSERT INTO mri2012_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ā, hei tohu tēnā ki tōu ringa hei pare ki waenganui i ōu kanohi; he kaha hoki te ringa i whakaputaina mai ai mātou e Ihowā i Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ā, i te tukunga o te iwi e Parao, kīhai a Ihowā i ārahi i a rātou nā te huarahi i te whenua o ngā Pirihitini, ahakoa tata tērā; i mea hoki te Atua, “Kei āwangawanga te iwi, ua kite rātou i te pakanga, ā, ka hoki ki Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Engari i ārahina āwhiotia te iwi e te Atua nā te huarahi i te koraha o te Moana Whero, ā, haere tōpuni ana ngā tama a Īharaira i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","I maua atu anō e Mohi ngā wheua o Hōhepa; nāna hoki i whakaoati mārie ngā tama a Īharaira, i mea, “Ka tīkina mai koutou, ka āta tirohia e te Atua; ā, mā koutou e mau atu ōku wheua i konei.” ");
INSERT INTO mri2012_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ā, ka tūria mai e rātou i Hukota, ā, noho rawa ki Ētama, ki te pito o te koraha. ");
INSERT INTO mri2012_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ā, haere ana a Ihowā i mua i a rātou, i te pou kapua i te awatea, hei ārahi i a rātou i te huarahi; i te pou kāpura anō i te pō, hei whakamārama i a rātou; kia haere ai rātou i te ao, i te pō. ");
INSERT INTO mri2012_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Kīhai i tangohia e ia te pou kapua i te aroaro o te iwi i te awatea, me te pou kāpura hoki i te pō. ");
INSERT INTO mri2012_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Nā, ka kōrero a Ihowā ki a Mohi, ka mea: ");
INSERT INTO mri2012_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Kōrero ki ngā tama a Īharaira, kia tahuri, kia noho ki te ritenga atu o Pihahirota, i waenganui o Mikitoro, o te moana, ki te ritenga o Paara-Hepona; hei te wāhi e hāngai tonu ana ki reira, hei te taha o te moana koutou noho ai. ");
INSERT INTO mri2012_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ā, e kīia ngā tama a Īharaira e Parao, ‘E pōhēhē ana rātou i te whenua, kua tūtakina mai rātou e te koraha.’ ");
INSERT INTO mri2012_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ā, māku e whakapakeke te ngākau o Parao, kia whai ai ia i a rātou; ā, ka whai korōria ahau i a Parao rātou ko tōna nuinga katoa; ā, ka mōhio ngā Īhipiana ko Ihowā ahau.” Ā, pērā ana rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ā, ka kōrerotia ki te kīngi o Īhipa, kua whati te iwi; nā, ka puta kē te ngākau o Parao rātou ko āna tāngata, ki te iwi, ā, ka mea rātou, “He aha tēnei mahi a tātou, i tukua atu ai a Īharaira i ā tātou mahi?” ");
INSERT INTO mri2012_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Nā, ka here ia i tana hāriata, i mauria anō hoki e ia tōna iwi; ");
INSERT INTO mri2012_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ā, tākiritia ake e ia e ono rau hāriata, whiriwhiri rawa, me ngā hāriata katoa o Īhipa, rite katoa i te rangatira. ");
INSERT INTO mri2012_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Nā, whakapakeke ana a Ihowā i te ngākau o Parao kīngi o Īhipa, ko te tino whāinga i muri i ngā tama a Īharaira. Tēnā ko ngā tama a Īharaira, kei runga tonu te ringaringa i haere atu ai rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Nā, whai ana ngā Īhipiana i a rātou, ngā hōiho katoa, ngā hāriata a Parao, me āna hōia eke hōiho, me āna mano, ā, mau rawa rātou, i a rātou e noho ana i te tahatai, i Pihahirota, e titiro atu nei ki Paara-Hepona. ");
INSERT INTO mri2012_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ā, i te whakatatanga mai o Parao, nā, ka anga ake ngā kanohi o ngā tama a Īharaira, nā, ko ngā Īhipiana e whai ana i muri i a rātou; ā, tino wehi ana rātou. Nā, ka karanga ngā tama a Īharaira ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ā, ka mea rātou ki a Mohi, “He onge koia nō te urupā o Īhipa i kāhaki mai ai koe i a mātou ki te koraha mate ai? He aha rā tēnei mahi āu ki a mātou, i ārahina mai ai mātou e koe i Īhipa? ");
INSERT INTO mri2012_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ehara koia tēnei i tā mātou kupu i kī rā ki a koe i Īhipa, i mea rā, ‘Waiho rā mātou kia whakamahia ana e ngā Īhipiana’? Pai kē kia whakamahia mātou e ngā Īhipiana i tō mātou mate ki te koraha.” ");
INSERT INTO mri2012_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nā, ka mea a Mohi ki te iwi, “Kaua e wehi; tū mārie, ka titiro atu ki te whakaoranga a Ihowā e whakaputaina mai e ia ki a koutou i tēnei rā. Nā, ko ngā Īhipiana e kitea atu rā e koutou i tēnei rā, e kore e kitea anō e koutou ā muri ake nei. ");
INSERT INTO mri2012_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mā Ihowā tā koutou pakanga; ko koutou ia e kore e hamumu.” ");
INSERT INTO mri2012_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Nā, ka mea a Ihowā ki a Mohi, “He aha koe i karanga ai ki ahau? Kī atu ki ngā tama a Īharaira kia mārō te haere. ");
INSERT INTO mri2012_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Nā, hāpainga e koe tāu tokotoko, ka whakamārō atu ai i tōu ringa ki runga ake i te moana, kia wehea ai; nā, ka haere atu ngā tama a Īharaira mā waenga moana, i te wāhi maroke. ");
INSERT INTO mri2012_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ā, ko ahau, inā, māku e whakapakeke ngā ngākau o ngā Īhipiana, ā, ka whai rātou i muri i a rātou; ā, ka whai korōria ahau i a Parao, i āna mano, i ana hāriata, i āna hōia eke hōiho. ");
INSERT INTO mri2012_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ā, ka mōhio ngā Īhipiana ko Ihowā ahau, ina whai korōria ahau i a Parao, i ana hāriata, i āna hōia eke hōiho.” ");
INSERT INTO mri2012_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Nā, ka whakatika te anahera a te Atua, i haere rā i mua i te ope o Īharaira, ā, haere ana ki muri i a rātou; i neke atu anō te pou kapua i tō rātou aroaro, ā, tū ana i muri i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","I haere hoki ki waenganui o te nohoanga o ngā Īhipiana, o te nohoanga hoki o Īharaira. Ā, tērā te kapua me te pōuri, otiia e whakamārama ana ia i te pō, ā, kīhai tētahi i whakatata ki tētahi ā pau katoa te pō. ");
INSERT INTO mri2012_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Nā, torona atu ana e Mohi tōna ringa ki runga i te moana; ā, panaia ana ki muri e Ihowā te moana ki tētahi hau nui, ki te marangai, ā, pau noa taua pō, nā, kua maroke te moana, kua tuwhera ngā wai. ");
INSERT INTO mri2012_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ā, haere ana ngā tama a Īharaira i waenga moana rā te wāhi maroke; hei taiepa anō ngā wai ki a rātou i te taha ki matau, ki mauī. ");
INSERT INTO mri2012_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Nā, ka whai ngā Īhipiana, ā, haere ana i muri i a rātou, ngā hōiho katoa a Parao, ana hāriata, me āna hōia eke hōiho, ki waenga moana. ");
INSERT INTO mri2012_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ā, i tō te ata whakaaraara, nā, ka titiro a Ihowā ki te ope o ngā Īhipiana, i roto i te pou ahi, i te pou kapua, ka whakararu hoki i te ope o ngā Īhipiana, ");
INSERT INTO mri2012_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ā, whakamareretia ana e ia ngā wīra o ngā hāriata, kia pūhoi ai te haere; ā, ka mea ngā Īhipiana, “Kia oma atu tātou i te aroaro o Īharaira; kei a rātou hoki a Ihowā e whawhai mai ana ki ngā Īhipiana.” ");
INSERT INTO mri2012_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Nā, ka mea a Ihowā ki a Mohi, “Whakamārōkia tōu ringa ki runga i te moana, kia hoki ai ngā wai ki runga ki ngā Īhipiana, ki ō rātou hāriata, ki ā rātou hōia eke hōiho.” ");
INSERT INTO mri2012_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ā, ko te whakamārōkanga o te ringa o Mohi ki runga i te moana, nā, tākiri rawa ake te ata, kua hoki te moana ki tōna tūturutanga; tūtataki pū ki ngā Īhipiana e rere ana; ā, tāia iho ngā Īhipiana e Ihowā ki waenga moana. ");
INSERT INTO mri2012_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ā, hoki ana ngā wai, taupokina iho ngā hāriata, me ngā hōia eke hōiho, me te ope katoa o Parao, i haere i muri i a rātou ki te moana; kīhai rawa tētahi o rātou i toe. ");
INSERT INTO mri2012_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Tēnā ko ngā tama a Īharaira, i haere rātou rā te wāhi maroke i waenganui o te moana; ko ngā wai hoki hei taiepa ki a rātou, ki te taha matau, ki te taha mauī. ");
INSERT INTO mri2012_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ā, whakaorangia ana e Ihowā a Īharaira i taua rā i ngā ringa o ngā Īhipiana; ā, ka kite a Īharaira i ngā Īhipiana i te tahatai, he tūpāpaku katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ā, i kite a Īharaira i te mahi nui i mahia e Ihowā ki ngā Īhipiana; ā, ka wehi te iwi a Ihowā, whakapono ana ki a Ihowā, ki tāna pononga hoki, ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kātahi ka waiata a Mohi rātou ko ngā tama a Īharaira i tēnei waiata ki a Ihowā, ā, ka whakahua, ka mea: “Ka waiata ahau ki a Ihowā, he hira noa atu hoki tōna korōria; ko te hōiho rāua ko tōna kaieke, kua pangā e ia ki te moana. ");
INSERT INTO mri2012_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ko Ihowā tōku kaha, tāku waiata, ko ia anō hoki hei whakaora mōku; ko tōku Atua tēnei, ā, māku ia e whakakorōria; ko te Atua o tōku pāpā, ā, māku ia e whakanui. ");
INSERT INTO mri2012_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","He tangata whawhai a Ihowā; ko Ihowā tōna ingoa. ");
INSERT INTO mri2012_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ko ngā hāriata a Parao, me tāna ope, kua makā e ia ki te moana; ko āna rangatira whiriwhiri toremi iho ki te Moana Whero. ");
INSERT INTO mri2012_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Taupokina iho rātou e ngā wai hōhonu; totohu ana rātou ki te rire, ānō he kāmaka. ");
INSERT INTO mri2012_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Ka whai korōria tōu ringa matau, e Ihowā, mō te kaha; nā tōu ringa, e Ihowā i mongamonga ai te hoa whawhai. ");
INSERT INTO mri2012_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Nā te nui o tōu kaha ka turakina e koe te hunga i whakatika mai rā ki a koe. Te whakaputanga o tōu riri, pau katoa rātou, me he tumutumu otaota. ");
INSERT INTO mri2012_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nā te hau hoki o tōu ihu i haupū ai ngā wai; i tū ake ngā roma, ānō he pūranga, ā, whakatotoka ana te rire i te takere o te moana. ");
INSERT INTO mri2012_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“I mea te hoariri, ‘Ka whai atu ahau, ka hopu, ka tuwha i ngā taonga, ka nā tōku ngākau i a rātou; ka unuhia tāku hoari, mā tōku ringa rātou e huna.’ ");
INSERT INTO mri2012_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","I pupuhi atu koe ki tāu hau, taupokina iho rātou e te moana; totohu iho rātou, ānō he matā, i ngā wai nui. ");
INSERT INTO mri2012_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Ko wai o ngā atua hei rite mōu, e Ihowā? Ko wai hei rite mōu, e whakamoemititia nei mō te tapu, e wehingia nei, e whakapaingia nei, e mahi nei i ngā mea whakamīharo? ");
INSERT INTO mri2012_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","I totoro atu tōu ringa matau, horomia ana rātou e te whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Nā tōu atawhai i ārahina mai ai e koe te iwi kua hokona nei e koe; nā tōu kaha i aratakina ai rātou e koe ki tōu nohoanga tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ka rongo ngā iwi, ka tūiri; mau tonu te matapōuri ki ngā tāngata o Pirihitia. ");
INSERT INTO mri2012_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Nō reira i ohorere ai ngā rangatira o Ēroma; ko ngā tāngata nunui o Moapa, mau tonu te wiri ki a rātou; memeha noa ngā tāngata katoa o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Tau ana ki a rātou te tūiri me te wehi; mā te nui o tōu ringa e tū tonu ai rātou, ānō he kōhatu, kia pahemo rā anō tāu iwi, e Ihowā, kia pahemo rā anō tēnei iwi kua hokona nei e koe. ");
INSERT INTO mri2012_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Māu rātou e kawe atu, e whakatupu ki te maunga, ki tōu kāinga ō mua iho, ki te wāhi, e Ihowā, i hangā e koe hei nohoanga mōu, ki te wāhi tapu, e te Ariki, i whakapūmautia e ōu ringa. ");
INSERT INTO mri2012_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Hei kīngi a Ihowā ake ake.” ");
INSERT INTO mri2012_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","I haere hoki ngā hōiho a Parao, me ana hāriata, me āna hōia eke hōiho ki te moana, ā, nā Ihowā i whakahoki ngā wai o te moana ki runga ki a rātou; tēnā ko ngā tama a Īharaira, i haere rā te wāhi maroke, i waenga moana. ");
INSERT INTO mri2012_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ā, ka tango a Miriama poropiti, tuahine o Ārona, i te timipera ki tōna ringa; ā, haere atu ana ngā wāhine katoa i muri i a ia me ngā timipera, me te kanikani anō rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ā, i whakahokia e Miriama tā rātou: “Waiata ki a Ihowā, he hira noa atu hoki tōna korōria; nāna hoki te hōiho rāua ko tōna kaieke i whiu ki te moana.” ");
INSERT INTO mri2012_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ā, ārahina atu ana e Mohi a Īharaira i te Moana Whero, ā, ka haere rātou ki te koraha o Huri, ā, e toru ngā rā i haere ai rātou i te koraha, ā, kīhai i kitea he wai. ");
INSERT INTO mri2012_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Nā, ka tae rātou ki Mara, kīhai hoki i āhei te inu i ngā wai o Mara; he kawa hoki. Nā reira i huaina ai tōna ingoa ko Mara. ");
INSERT INTO mri2012_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Nā, ka amuamu te iwi ki a Mohi, ka mea, “Ko te aha hei inu mā mātou?” ");
INSERT INTO mri2012_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Nā, ka karanga ia ki a Ihowā; ā, ka whakakitea mai he rākau e Ihowā ki a ia, ā, pangā ana e ia ki ngā wai, nā, ka reka ngā wai. I hōmai e ia he ture ki a rātou i reira, me tētahi ritenga; i whakamātauria rātou e ia ki reira. ");
INSERT INTO mri2012_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I mea hoki ia, “Ki te rongo mārie koe ki te reo o Ihowā, o tōu Atua, ā, ka mahi i te mea tika ki tāna titiro, ā, ka whai taringa ki āna whakahau, ka pupuri hoki i āna tikanga katoa, e kore rawa tētahi o aua mate i whakapāngia ki ngā Īhipiana e ahau, e whakapāngia atu e ahau ki a koe. Ko Ihowā hoki ahau e whakaora nei i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Nā, ka tae rātou ki Erimi, kotahi tekau mā rua nei ngā puna wai i reira, me ngā nīkau e whitu tekau; ā, ka noho rātou ki reira, ki te taha o ngā wai. ");
INSERT INTO mri2012_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nā, ka tūria e rātou i Erimi, ā, ka tae te huihuinga katoa o ngā tama a Īharaira ki te koraha o Hini, ki waenganui o Erimi o Hinai, i te tekau mā rima o ngā rā o te rua o ngā marama o tō rātou haerenga mai i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nā, ka amuamu te huihui katoa o ngā tama a Īharaira ki a Mohi rāua ko Ārona i te koraha. ");
INSERT INTO mri2012_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ā, ka mea ngā tama a Īharaira ki a rāua, “Ē, te mate atu rā mātou i te ringa o Ihowā i te whenua o Īhipa, i a mātou e noho ana i te taha o ngā kōhua kikokiko, e kai taro ana, ā mākona noa! Nā kōrua nei hoki mātou i kawe mai ki tēnei koraha kia kōhurutia ai tēnei whakaminenga katoa ki te matekai.” ");
INSERT INTO mri2012_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Nā, ka mea a Ihowā ki a Mohi, “Nanā, ka uaina iho e ahau he taro i te rangi mā koutou; ā, mā te iwi e haere, e kohikohi i tō tēnei rangi, i tō tēnei rangi, kia whakamātau ai ahau i a rātou, e haere rānei rātou i tāku ture, kāhore rānei. ");
INSERT INTO mri2012_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ā, te ono o ngā rā, ka takā e rātou tā rātou e mau mai ai; kia takiruatia tā rātou i kohikohi ai i ētahi rangi ake ka rite ki tō tēnei.” ");
INSERT INTO mri2012_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Nā, ka mea a Mohi rāua ko Ārona ki ngā tama katoa a Īharaira, “Ka ahiahi, nā, ka mōhio koutou nā Ihowā koutou i ārahi mai i te whenua o Īhipa; ");
INSERT INTO mri2012_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ā, i te ata, nā, ka kite koutou i te korōria o Ihowā; e whakarongo mai ana hoki ia ki ā koutou amuamu ki a Ihowā. Tēnā ko māua, he aha māua, i amuamu ai koutou ki a māua?” ");
INSERT INTO mri2012_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","I mea anō a Mohi, “Ka mōhio koutou, ua hōmai e Ihowā ki a koutou he kikokiko hei kai i te ahiahi, ā, i te ata he taro, ā mākona noa, nō te mea kua rongo a Ihowā ki ā koutou amuamu e amuamu nā koutou ki a ia – ko māua ia, hei aha? Kīhai koutou i amuamu ki a māua, engari ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Nā, ka mea a Mohi ki a Ārona, “Mea atu ki te huihui katoa o ngā tama a Īharaira, ‘Whakatata mai ki te aroaro o Ihowā kua rongo hoki ia ki ā koutou amuamu.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ā, i a Ārona e kōrero ana ki te huihui katoa o ngā tama a Īharaira, nā, ka tahuri rātou whaka te koraha, nā, ko te korōria o Ihowā e puta mai ana i roto i te kapua. ");
INSERT INTO mri2012_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nā, ka kōrero a Ihowā ki a Mohi, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Kua rongo ahau ki ngā amuamu a ngā tama a Īharaira; kōrero atu ki a rātou, mea atu, ‘Kia ahiahi ka kai koutou i te kikokiko, ā, i te ata ka mākona i te taro; ā, ka mōhio koutou ko Ihowā ahau, ko tō koutou Atua.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ā, i te ahiahi, nā, ka puta mai te koitareke, ā, kapi ana te puni; ā, i te ata kua takoto te tōmairangi i te nohoanga, tawhio noa, tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ā, ka mimiti ake te papanga tōmairangi, nā, he mea ririki, pōtakataka nei, kei te mata o te koraha, ririki, me te haupapa, i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ā, i te kitenga o ngā tama a Īharaira, ka mea rātou tētahi ki tētahi, “He aha tēnā?” Kīhai hoki rātou i mōhio he aha rānei. Nā, ka mea a Mohi ki a rātou, “Ko te taro rā tēnā ka hōmai nei e Ihowā ki a koutou hei kai. ");
INSERT INTO mri2012_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ko te mea tēnā i ākona mai rā e Ihowā, ‘Kohikohia mai i reira e tērā, e tērā, kia rite ki tāna e kai ai; he omere mā te tangata, kia rite ki tō koutou tokomaha; kohikohia e tērā, e tērā, mā te hunga i tōna tēneti.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ā, pērā ana ngā tama a Īharaira, nā, kohikohia ana, tā tētahi he nui, tā tētahi he iti. ");
INSERT INTO mri2012_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ā, ka mēhuatia e rātou ki te omere, kīhai i hira tā te tangata i te wāhi nui, kīhai hoki he hapa o tāna i te wāhi nohinohi. Rite tonu ki te kai a tērā, a tērā, tā rātou i kohikohi ai. ");
INSERT INTO mri2012_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Nā, ka mea a Mohi ki a rātou, “Kaua e whakatoea tētahi wāhi o tēnā ki te ata.” ");
INSERT INTO mri2012_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Engari kīhai rātou i whakarongo ki a Mohi; ā, whakatoea ana e ētahi tētahi wāhi o taua mea mō te ata, ā, muia ana e te kutukutu, ā, piro ake; ā, riri ana a Mohi ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ā, kohikohia ana taua mea e rātou i tēnei ata, i tēnei ata, rite tonu ki tā tēnei tangata, ki tā tēnei tangata, e kai ai; ā, ka mahana te rā, nā, kua rewa. ");
INSERT INTO mri2012_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ā, i te ono o ngā rā ka takiruatia te taro i kohikohia e rātou, e rua hoki ngā omere mā te tangata kotahi; ā, ka haere mai ngā rangatira katoa o te huihui, ka kōrero ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Nā, ka mea ia ki a rātou, “Ko ia tēnei tā Ihowā i kōrero rā, ‘Ko āpōpō te okiokinga o te hāpati tapu o Ihowā; tunua tā koutou e tunu ai, kōhuatia hoki tā koutou e kōhua ai; ā, ko te toenga, waiho mā koutou, rongoātia mō te ata.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ā, rongoātia atu ana e rātou mō te ata, i pērā anō me tā Mohi i kī ai; kīhai hoki i piro, kāhore hoki i whai kutukutu. ");
INSERT INTO mri2012_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Nā, ka mea a Mohi, “Kainga tēnā i tēnei rā; he hāpati hoki tēnei rā nā Ihowā; e kore tēnā mea e kitea e koutou ki te pārae i tēnei rā. ");
INSERT INTO mri2012_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","E ono ngā rā e kohikohi ai koutou i tēnā mea; ā, i te whitu o ngā rā ko te hāpati, ko reira kore ai.” ");
INSERT INTO mri2012_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ā, i te whitu o ngā rā ka haere atu ētahi o te iwi ki te kohikohi, ā, kīhai i kitea. ");
INSERT INTO mri2012_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Nā, ka mea a Ihowā ki a Mohi, “Kia pēhea te roa o koutou e kore nei e pupuri i āku whakahau, i āku ture? ");
INSERT INTO mri2012_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Titiro, nō te mea kua hoatu e Ihowā te hāpati ki a koutou, koia i hoatu ai e ia i te rā ono he taro mō ngā rangi e rua. E noho koutou e tērā, e tērā, ki tōna wāhi anō; kaua tētahi e haere atu i tōna nohoanga i te rā whitu.” ");
INSERT INTO mri2012_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nā, ka noho te iwi i te rā whitu. ");
INSERT INTO mri2012_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ā, huaina iho e te whare o Īharaira te ingoa o taua mea he mana. Tōna rite kei te purapura korianara, mā tonu; tōna reka kei te papa honi. ");
INSERT INTO mri2012_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","I mea anō a Mohi, “Ko te mea tēnei i ākona mai nei e Ihowā, ‘Whakakīia tētahi omere ki taua mea, ka rongoā ai mā ō koutou whakapaparanga; kia kite ai rātou i te taro i whāngaia ai koutou e ahau i te koraha i tāku whakaputanga mai i a koutou i te whenua o Īhipa.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ā, ka mea a Mohi ki a Ārona, “Tangohia tētahi oko, whaowhina hoki he mana ki roto, kia kotahi whakakīnga o te omere, ka whakatakoto ki te aroaro o Ihowā, rongoā ai mā ō koutou whakatupuranga.” ");
INSERT INTO mri2012_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ā, whakatakotoria ana taua mea e Ārona ki mua i te Whakaaturanga rongoā ai, pērā tonu ia me tā Ihowā i ako ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ā, e whā tekau ngā tau i kai ai ngā tama a Īharaira i te mana, ā tae noa ki te whenua tāngata; he mana tā rātou i kai ai, ā tae noa ki ngā rohe o te whenua o Kanaana. ");
INSERT INTO mri2012_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Nā, ko te omere, ko te wāhi whakatekau o te epa. ");
INSERT INTO mri2012_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nā, ka haere te huihui katoa o ngā tama a Īharaira i te koraha o Hini i ō rātou haerenga, i pērā tonu me tā Ihowā i ako ai, ā, noho rawa atu ki Repirimi; otiia kāhore he wai hei inu mā te iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Nā, ka ngangau te iwi ki a Mohi, ka mea, “Hōmai rā he wai mō mātou, kia inu ai mātou.” Ā, ka mea a Mohi ki a rātou, “He aha koutou i ngangau ai ki ahau? He aha koutou i whakamātautau ai i a Ihowā?” ");
INSERT INTO mri2012_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Nā, ka mate te iwi i te wai i reira; ā, amuamu ana te iwi ki a Mohi, ā, ka mea, “He aha mātou i kawea mai ai e koe i Īhipa kia kōhurutia ai mātou, me ā mātou tamariki, me ā mātou kararehe ki te matewai?” ");
INSERT INTO mri2012_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Nā, ka karanga a Mohi ki a Ihowā, ka mea, “Me pēhea ahau ki te iwi nei? Whano rātou āki i ahau ki te kōhatu.” ");
INSERT INTO mri2012_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nā, ka mea a Ihowā ki a Mohi, “Haere i mua i te iwi, ka tango hoki i ētahi o ngā kaumātua o Īharaira hei hoa mōu; ko tāu tokotoko hoki i patua e koe ki te awa, me mau atu i tōu ringa, ka haere. ");
INSERT INTO mri2012_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nanā, tēnā ahau te tū atu nā i tōu aroaro i reira, i runga i te kāmaka i Horepa, ā, māu e patu te kāmaka, ā, ka puta he wai i reira, hei inu mā te iwi.” Ā, pērātia ana e Mohi i te tirohanga a ngā kaumātua o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ā, huaina ana e ia te ingoa o taua wāhi ko Maha, ko Meripa; mō te ngangautanga a ngā tama a Īharaira, mō tā rātou whakamātau hoki i a Ihowā, i a rātou i mea rā, “Kei roto rānei a Ihowā i a tātou, kāhore rānei?” ");
INSERT INTO mri2012_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Nā, ka haere mai a Amareke, kei te whawhai ki a Īharaira ki Repirimi. ");
INSERT INTO mri2012_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nā, ka mea a Mohi ki a Hohua, “Whiriwhiria mai ētahi tāngata mā tāua, ka haere ki te whawhai ki a Amareke. Ka tū ahau āpōpō ki runga i te tihi o te pukepuke, me te rākau anō hoki a te Atua ki tōku ringa.” ");
INSERT INTO mri2012_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Nā, pērātia ana e Hohua me tā Mohi i kōrero ai ki a ia; ko te tino whawhaitanga ki a Amareke; ko Mohi ia, rātou ko Ārona, ko Huru, i piki ki te tihi o te pukepuke. ");
INSERT INTO mri2012_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ā, ka maiangi ake te ringa o Mohi, nā, ka kaha a Īharaira; ā, ka tukua iho tōna ringa, nā, ka kaha a Amareke. ");
INSERT INTO mri2012_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Otiia ka taimaha ngā ringa o Mohi; ā, ka mau rāua ki tētahi kōhatu, ā, whakatakotoria ana ki raro i a ia, ā, noho ana ia i runga; ā, puritia ake ana ōna ringa e Ārona rāua ko Huru, kotahi i tētahi taha, kotahi i tētahi taha; kātahi ka tūturu tonu ōna ringa, ā tō noa te rā. ");
INSERT INTO mri2012_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nā, patua ana a Amareke, rātou ko tōna iwi, e Hohua ki te mata o te hoari. ");
INSERT INTO mri2012_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Nā, ka mea a Ihowā ki a Mohi, “Tuhituhia tēnei ki te pukapuka, hei whakamaharatanga; kōrerotia hoki ki ngā taringa o Hohua. Ka tino horoia atu hoki e ahau te maharatanga o Amareke i raro i te rangi.” ");
INSERT INTO mri2012_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ā, hangā ana e Mohi he āta, ā, huaina iho tōna ingoa ko “Ihowānihi.” ");
INSERT INTO mri2012_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","I mea hoki ia, “Kua ara nei te ringa ki te torōna o Ihowā, nā, he pakanga tā Ihowā ki a Amareke i tēnei whakapaparanga, i tēnei whakapaparanga.” ");
INSERT INTO mri2012_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ā, ka rongo a Ietoro, te tohunga o Miriana, te hungawai o Mohi, ki ngā mea katoa i meatia e te Atua ki a Mohi, ki a Īharaira hoki, ki tāna iwi; ki a Ihowā anō hoki kua whakaputa mai i a Īharaira i Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Kātahi a Ietoro, hungawai o Mohi, ka tango i a Hipora, wahine a Mohi, i muri nei i tāna tononga i a ia kia hoki, ");
INSERT INTO mri2012_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","me āna tamariki tokorua, ko te ingoa o tētahi ko Kerehoma, i mea hoki ia, “He manene ahau i te whenua kē,” ");
INSERT INTO mri2012_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ko te ingoa hoki o tētahi ko Eriētere; “Mōku hoki i āwhinatia mai e te Atua o tōku pāpā, nāna hoki ahau i whakaora i te hoari a Parao.” ");
INSERT INTO mri2012_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Nā, ka haere mai a Ietoro, te hungawai o Mohi, rātou ko āna tamariki, ko tāna wahine, ki a Mohi, ki te koraha i noho ai ia, ki te maunga o te Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ā, ka mea ki a Mohi, “Ko ahau, ko Ietoro, ko tōu hungawai, kua tae mai ki a koe, me tāu wahine, rātou ko āna tama tokorua.” ");
INSERT INTO mri2012_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Nā, ka haere a Mohi ki te whakatau i tōna hungawai, ā, ka tuohu, ka kihi hoki i a ia; ā, ka ui rāua ki a rāua ki te pai i tētahi, i tētahi; ā, haere ana rāua ki te tēneti. ");
INSERT INTO mri2012_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Nā, ka kōrerotia e Mohi ki tōna hungawai ngā mea katoa i meatia e Ihowā ki a Parao rātou ko ngā Īhipiana, mō Īharaira, me ngā mate katoa hoki i pono ki a rātou i te ara, me rātou hoki kua whakaorangia nei e Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nā, ka hari a Ietoro mō ngā mea pai katoa i meatia e Ihowā ki a Īharaira, mō rātou hoki i whakaorangia e ia i te ringa o ngā Īhipiana, ");
INSERT INTO mri2012_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ā, ka mea a Ietoro, “Kia whakapaingia a Ihowā nāna nei koutou i whakaora i te ringa o ngā Īhipiana, i te ringa hoki o Parao; nāna hoki te iwi nei i whakaora i raro i te ringa o ngā Īhipiana. ");
INSERT INTO mri2012_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kātahi ahau ka mōhio he nui ake a Ihowā i ngā atua katoa; āe rā, i te mea hoki ka whakapehapeha rātou, hira ake ana anō ia i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Nā, ka tangohia e Ietoro, e te hungawai o Mohi tētahi tahunga tinana me ētahi patunga tapu mā te Atua; ā, haere mai ana a Ārona, me ngā kaumātua katoa o Īharaira, ki te hungawai o Mohi, ki te kai taro ki te aroaro o te Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ā, i te aonga ake o te rā ka noho a Mohi ki te whakawā i te iwi; ā, ka tū te iwi i te taha o Mohi nō te ata ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ā, nō te kitenga o te hungawai o Mohi i ngā mea katoa i mea ai ia ki te iwi, ka mea ia, “He aha tēnei mea e mea nei koe ki te iwi? He aha koe i noho ai ko koe anake, i tū ai hoki te iwi katoa i tōu taha nō te ata ā tae noa ki te ahiahi?” ");
INSERT INTO mri2012_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ā, ka mea a Mohi ki tōna hungawai, “E haere mai ana hoki te iwi ki ahau, ki te rapu tikanga i te Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ka ai he mea ki a rātou, nā, ka haere mai ki ahau; ā, māku e whakarite te whakawā a tētahi ki tētahi; e whakaatu hoki ngā tikanga a te Atua me āna ture.” ");
INSERT INTO mri2012_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nā, ka mea te hungawai o Mohi ki a ia, “Ehara tēnei i te pai e mea nei koe. ");
INSERT INTO mri2012_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ka honia noatia iho koe, koutou tahi ko tēnei iwi i a koe nei; he pēhi rawa hoki tēnei mea i a koe; e kore e taea e koe anake. ");
INSERT INTO mri2012_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nā, whakarongo mai ki tōku reo, māku koe e tohutohu; hei a koe te Atua, hei te aroaro o te Atua koe mō te iwi, ā, māu e kawe ngā kōrero ki te Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Māu anō rātou e whakaako ki ngā tikanga, ki ngā ture, e whakaatu hoki ki a rātou te huarahi e haere ai rātou, me ngā mahi e mahi ai rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Māu anō hoki e titiro i roto i te iwi katoa ētahi tāngata māia, e wehi ana i te Atua; hei te hunga pono, e kino ana ki te apo; ka waiho ai hei rangatira mō rātou, hei rangatira mō ngā mano, hei rangatira mō ngā rau, hei rangatira mō ngā rima tekau, hei rangatira mō ngā tekau. ");
INSERT INTO mri2012_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ā, mā rātou te iwi e whakawā i ngā wā katoa; ā, ko ngā mea nunui katoa, me kawe mai ki a koe; ko ngā mea nohinohi katoa ia, mā rātou e whakarite; pēnei ka māmā koe, ā, mā koutou tahi te pīkaunga. ");
INSERT INTO mri2012_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ki te mea koe i tēnei mea, ā, ka kī mai te Atua ki a koe, kātahi koe ka matatū ake, ā, ka haere mārie tēnei iwi katoa ki ō rātou kāinga.” ");
INSERT INTO mri2012_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ā, rongo tonu a Mohi ki te kupu a tōna hungawai, ā, meatia katoatia iho e ia ngā mea i kōrero ai ia. ");
INSERT INTO mri2012_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ā, whiriwhiria ana e Mohi ētahi tāngata māia i roto i a Īharaira katoa, ā, waiho iho rātou e ia hei upoko mō te iwi, hei rangatira mō ngā mano, hei rangatira mō ngā rau, hei rangatira mō ngā rima tekau, hei rangatira hoki mō ngā tekau. ");
INSERT INTO mri2012_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ā, nā rātou te iwi i whakawā i ngā wā katoa; ko te mea pakeke i kawea e rātou ki a Mohi; ko ngā mea nohinohi katoa ia nā rātou anō i whakarite. ");
INSERT INTO mri2012_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Nā, ka tukua atu e Mohi tōna hungawai; ā, haere ana ia ki tōna whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Nō te toru o ngā marama o te haerenga mai o ngā tama a Īharaira i te whenua o Īhipa, nō taua rangi anō, ka tae rātou ki te koraha o Hinai. ");
INSERT INTO mri2012_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ā, i tō rātou haerenga atu i Repirimi, ka tae ki te koraha o Hinai, ka noho iho rātou i te koraha; ā, noho ana a Īharaira ki reira, ki te ritenga atu o te maunga. ");
INSERT INTO mri2012_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Nā, ka piki a Mohi ki te Atua, ā, ka karanga a Ihowā ki a ia i te maunga, ka mea, “Kia pēnei tāu kōrero ki te whare o Hākopa, tāu kauwhau hoki ki ngā tama a Īharaira: ");
INSERT INTO mri2012_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Kua kite koutou i ngā mea i mea ai ahau ki ngā Īhipiana, i tāku whakawahanga hoki i a koutou i runga i ngā parirau ēkara, me te kawenga mai i a koutou ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Heoi, ki te āta whakarongo koutou ki tōku reo, ki te pupuri hoki i tāku kawenata, ka waiho koutou hei taonga mōku, motu kē i ngā iwi katoa; i ahau hoki te whenua katoa; ");
INSERT INTO mri2012_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ā, ka waiho koutou e ahau hei kīngi, hei tohunga, hei iwi tapu hoki.’ Ko ngā kupu ēnei e kōrero ai koe ki ngā tama a Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Nā, ka haere iho a Mohi, ka karanga ia ki ngā kaumātua o te iwi, ā, hoatu ana e ia ki tō rātou aroaro ēnei kupu katoa i ākona nei e Ihowā ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Nā, ka pā katoa te iwi ki te whakahoki, ka mea: “Ka mahia e mātou ngā mea katoa i kōrerotia mai nā e Ihowā.” Ā, kawea ana e Mohi ngā kupu a te iwi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nā, ka mea a Ihowā ki a Mohi, “Nanā, ka haere atu ahau ki a koe i roto i tētahi kapua mātotoru, kia rongo ai te iwi, ua kōrero ahau ki a koe, kia whakapono ai hoki rātou ki a koe ā mua tonu atu. Ā, kōrerotia ana e Mohi ngā kupu a te iwi ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Nā, ka mea a Ihowā ki a Mohi, “Haere ki te iwi, ka whakatapu hoki i a rātou ākuanei, āpōpō hoki, kia horoi hoki rātou i ō rātou kākahu, ");
INSERT INTO mri2012_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","kia takatū hoki mō te rā tuatoru; tā te mea hei te rā tuatoru a Ihowā haere iho ai ki te aroaro o te iwi katoa, ki runga ki Maunga Hinai. ");
INSERT INTO mri2012_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ā, whakatakotoria e koe he rohe mō te iwi, tawhio noa, tawhio noa, ka mea atu, ‘Kia mōhio koutou kei piki ki te maunga, kei pā rānei ki tōna taha; ko ngā tāngata katoa e pā ana ki te maunga, inā, me whakamate. ");
INSERT INTO mri2012_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kaua te ringa e pā ki a ia, engari me āki ki te kōhatu, me wero rānei ki te tao; ahakoa kararehe, ahakoa tangata, e kore e ora.’ Ka kukume roa te tangi o te tētere, ka haere mai ai rātou ki te maunga.” ");
INSERT INTO mri2012_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Nā, ka haere iho a Mohi i te maunga ki te iwi, ka whakatapu ia i te iwi, ā, horoia ana e rātou ō rātou kākahu. ");
INSERT INTO mri2012_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ā, i mea ia ki te iwi, “Kia takatū koutou i te toru o ngā rā; kaua e whakatata atu ki te wahine.” ");
INSERT INTO mri2012_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ā, ka taka ki te toru o ngā rā, i te ata, nā, ka puta mai ngā whatitiri, me ngā uira, me te kapua mātotoru i runga i te maunga, me te tangi o te tētere, tōna nui nā! Ā, wiri katoa ana te hunga i te puni. ");
INSERT INTO mri2012_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Nā, ka ārahina atu te iwi e Mohi i te puni ki te whakatau i te Atua; ā, tū ana rātou ki raro i te maunga. ");
INSERT INTO mri2012_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ā, he paowa kau Maunga Hinai, nō te mea kua heke iho a Ihowā ki runga, i roto i te ahi; ā, kake ana tōna paowa, ānō he paowa oumu, ā, wiri pū te maunga katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ā, i te mea ka nui haere rawa te tangi o te tētere, ka kōrero atu a Mohi, ā, ka kōrero ā-reo tangata mai te Atua ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Nā, ka heke iho a Ihowā ki Maunga Hinai, ki te tihi o te maunga; ā, karangatia iho ana a Mohi e Ihowā ki te tihi o te maunga; ā, piki atu ana a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nā, ka mea a Ihowā ki a Mohi, “Heke atu, kauwhautia te iwi rā, kei wāhi ake rātou ki a Ihowā ki te mātakitaki, ā, he tokomaha o rātou e hinga. ");
INSERT INTO mri2012_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ko ngā tohunga hoki e whakatata ana ki a Ihowā, kia tapu rātou, kei auta atu a Ihowā ki a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ā, ka mea a Mohi ki a Ihowā, “E kore e āhei i te iwi te piki ake ki Maunga Hinai; nāu hoki i kauwhau iho ki a mātou, i mea, ‘Taiepatia te maunga, whakatapua hoki.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Nā, ka mea a Ihowā ki a ia, “Haere, heke atu; ka piki mai anō koe, kōrua ko Ārona; ko ngā tohunga ia, me te iwi, kei wāhi mai rātou, kei piki ki a Ihowā; kei auta atu ia ki a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ā, heke atu ana a Mohi ki te iwi, kōrero ana ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nā, ka kōrerotia e te Atua ēnei kupu katoa, ka mea: ");
INSERT INTO mri2012_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ko Ihowā ahau, ko tōu Atua, nāku koe i whakaputa mai i te whenua o Īhipa, i te whare pononga; ");
INSERT INTO mri2012_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","aua ētahi atua kē atu mōu ki mua i ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Kei hanga koe i te whakapakoko mōu, i tētahi ritenga rānei o ngā mea o te rangi i runga, o te whenua rānei i raro, o te wai rānei i raro i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kei koropiko koe ki ēnā mea, kei mahi rānei ki ēnā mea; ko Ihowā hoki ahau, ko tōu Atua, he Atua hae, e mea ana i ngā hara o ngā mātua kia tau iho ki ngā tamariki ā te toru, te whā rā anō o ngā whakatupuranga o te hunga e kino ana ki ahau; ");
INSERT INTO mri2012_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","e whakaputa aroha ana hoki ki ngā mano, ki te hunga e aroha ana ki ahau, e whakarite ana i āku ture. ");
INSERT INTO mri2012_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Kei whakahuatia noatia e koe te ingoa o Ihowā, o tōu Atua; e kore hoki a Ihowā e mea, he harakore te tangata e whakahua noa ana i tōna ingoa. ");
INSERT INTO mri2012_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Kia mahara ki te rā hāpati, kia whakatapua. ");
INSERT INTO mri2012_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","E ono ngā rā e mahi ai koe, e mea ai hoki i āu mea katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Tēnā ko te rā whitu, he hāpati nō Ihowā, nō tōu Atua; kaua e mahia tētahi mahi i reira – e koe, e tāu tama, e tāu tamāhine, e tāu pononga tāne, e tāu pononga wahine, e āu kararehe hoki, me tōu tangata kē i roto i ōu tatau. ");
INSERT INTO mri2012_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","E ono hoki ngā rā i hangā ai e Ihowā te rangi, me te whenua, te moana, me ngā mea katoa i roto, ā, okioki ana i te rā whitu. Nā reira i whakapaingia ai te rā hāpati e Ihowā, ā whakatapua ana. ");
INSERT INTO mri2012_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Whakahōnoretia tōu pāpā me tōu whaea; kia roa ai ōu rā ki te whenua e hōmai nei e Ihowā, e tōu Atua, ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Kaua e patu. ");
INSERT INTO mri2012_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Kaua e pūremu. ");
INSERT INTO mri2012_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Kaua e tāhae. ");
INSERT INTO mri2012_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Kaua e whakapae teka ki tōu hoa. ");
INSERT INTO mri2012_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Kaua e hiahia ki te whare o tōu hoa. Kaua e hiahia ki te wahine a tōu hoa, ki tāna pononga tāne rānei, ki tāna pononga wahine rānei, ki tāna kau rānei, ki tana kāihe rānei, ki tētahi mea rānei a tōu hoa.” ");
INSERT INTO mri2012_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ā, i kite te iwi katoa i ngā whatitiri, i ngā uira, i te tangi o te tētere, i te maunga hoki e paowa ana; ā, i te kitenga o te iwi, ka wiri rātou, ā, tū rawa i tawhiti. ");
INSERT INTO mri2012_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ā, ka mea rātou ki a Mohi, “Māu e kōrero mai ki a mātou, ā, ka whakarongo atu mātou; engari kaua te Atua e kōrero ki a mātou, kei mate mātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Nā, ka mea a Mohi ki te iwi, “Kaua e wehi; he whakamātau hoki i a koutou i haere mai ai te Atua, kia mau ai hoki tōna wehi i ō koutou kanohi, kei hara koutou.” ");
INSERT INTO mri2012_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ā, tū ana te iwi i tawhiti; ko Mohi ia, i whakatata ki te pōuri kerekere i noho ai te Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ā, ka mea a Ihowā ki a Mohi: “Kia pēnei tāu kupu ki ngā tama a Īharaira: ‘Ka kite koutou kua kōrero ahau i te rangi ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kei hanga koutou he atua kē atu ki tōku taha; kei hanga koutou he atua hiriwa, he atua kōura rānei, mō koutou. ");
INSERT INTO mri2012_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Hangā he āta oneone māku, ki runga patu ai koe i āu tahunga tinana, i āu whakahere mō te pai, i āu hipi, i āu kau. I ngā wāhi katoa e whakamaharatia ai e ahau tōku ingoa ka haere atu ahau ki a koe, ka manaaki i a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ā, ki te hanga koe i te āta kōhatu māku, kei hangā e koe ki te kōhatu hahau; ki te hāpai hoki koe i tāu toki ki taua mea, kua whakanoatia e koe. ");
INSERT INTO mri2012_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kaua anō e piki nā te arawhata ki tōku āta, kei kitea koe i reira e tū tahanga ana.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ā, ko ngā whakariteritenga ēnei e whakatakotoria e koe ki tō rātou aroaro: ");
INSERT INTO mri2012_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ki te hoko koe i tētahi pononga Hiperu, e ono ngā tau e mahi ai ia; ā, i te whitu ka haere noa atu, kaua he utu. ");
INSERT INTO mri2012_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ki te mea he takakau ia i tōna haerenga mai, me haere atu anō he takakau; ki te mea he wahine tāna, ko rāua ko tāna wahine e haere. ");
INSERT INTO mri2012_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ki te mea nā tōna ariki te wahine i hoatu ki a ia, ā, ka whānau ā rāua tama, tamāhine rānei; mā tōna ariki te wahine rātou ko āna tamariki, ko ia anake e haere. ");
INSERT INTO mri2012_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Ā, ki te mea matanui te pononga, ‘E aroha ana ahau ki tōku ariki, ki tāku wahine, ki āku tamariki; e kore ahau e haere noa atu,’ ");
INSERT INTO mri2012_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","nā, me kawe ia e tōna ariki ki te Atua. Me kawe hoki ia e ia ki te tatau, ki te pou rānei o te tatau; ā, ka pokaia tōna taringa e tōna ariki ki te oka; ā, ka oti iho ia hei kaimahi māna. ");
INSERT INTO mri2012_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ki te hokona atu hoki e tētahi tangata tāna tamāhine hei pononga, e kore e rite tōna haerenga ki waho ki te haerenga o ngā pononga tāne. ");
INSERT INTO mri2012_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ki te kino ia ki te titiro a tōna ariki, i taumau nei i a ia māna, nā, me whakahoki ia mō tētahi utu; e kore e āhei te hoko i a ia ki tētahi iwi kē; mōna hoki i tinihanga ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ā, ki te taumautia ia e ia mā tāna tama, kia rite ki te tikanga ki ngā tamāhine tupu tāna e mea ai ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ki te tango ia i tētahi atu wahine māna kaua e whakaititia e ia te kai mā tērā, te kākahu mōna, me tā rāua moe tahi. ");
INSERT INTO mri2012_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ā, ki te kāhore ēnei mea e toru e meatia e ia ki a ia, nā, me haere noa atu ia, kaua he moni.” ");
INSERT INTO mri2012_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ki te patu tētahi i te tangata kia mate, me tino whakamate anō ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ā, ki te kāhore tētahi e whanga atu, ā, ka mea te Atua kia tūpono ki tōna ringa; nā, māku e whakarite ki a koe te wāhi e rere ai ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Tēnā ko tēnei, i poka noa te tangata ki tōna hoa, ki te kōhuru tinihanga i a ia; me tango ia e koe i tāku āta, kia mate ai ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Me tino whakamate anō hoki te tangata e patu ana i tōna pāpā, i tōna whaea rānei. ");
INSERT INTO mri2012_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ko te tangata hoki e tāhae ana i tētahi tangata, ā, hokona ana e ia, e kitea ana rānei ki tōna ringa, me tino whakamate anō ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Me tino whakamate anō hoki te tangata e kanga ana i tōna pāpā, i tōna whaea rānei. ");
INSERT INTO mri2012_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ki te whawhai hoki ētahi tāngata ki a rāua, ā, ka ākina tōna hoa e tētahi ki te kōhatu, ka motokia rānei, ā, kāhore ia e mate, engari ka takoto i runga i te moenga; ");
INSERT INTO mri2012_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ki te ara ake ia, ā, ka hāereere ki waho me te toko i tāna tokotoko, kātahi ka kore te hara o te tangata i patua ai ia; otiia me utu e ia tōna whakamāngeretanga ki te mahi, me mea hoki kia āta rongoātia kia ora ai. ");
INSERT INTO mri2012_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ki te patu hoki te tangata i tāna pononga tāne, i tāna pononga wahine rānei, ki te rākau, ā, ka mate i raro iho i tōna ringa; me āta takitaki tōna matenga. ");
INSERT INTO mri2012_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Otiia ki te ora ia, kotahi, e rua rānei, ngā rā, e kore e takitakina; nō te mea ko tāna moni ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ki te whawhai ētahi tāngata ki a rātou, ā, ka whara tētahi wahine e hapū ana, ā, ka materoto tāna tamaiti, otiia kāhore atu he hē, me tango he utu i a ia, arā tā te tahu o te wahine e whakarite ai ki a ia; hei tā ngā kaiwhakawā e mea ai tāna e hōmai ai. ");
INSERT INTO mri2012_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Engari ki te mate, nā, me hōmai e koe he mate hei utu mō te mate, ");
INSERT INTO mri2012_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","he kanohi mō te kanohi, he niho mō te niho, he ringa mō te ringa, he waewae mō te waewae, ");
INSERT INTO mri2012_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","he wera mō te wera, he motu mō te motu, he kārawarawa mō te kārawarawa. ");
INSERT INTO mri2012_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ki te patua e te tangata te kanohi o tāna pononga tāne, te kanohi rānei o tāna pononga wahine, ā, ka matapōtia; me tuku kia haere noa atu, hei utu mō tōna kanohi. ");
INSERT INTO mri2012_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ā, ki te patua e ia kia marere te niho o tāna pononga tāne, te niho rānei o tāna pononga wahine; me tuku kia haere noa atu, hei utu mō tōna niho.” ");
INSERT INTO mri2012_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ki te werohia tētahi tangata tētahi wahine rānei, e te kau, ā, ka mate; me tino āki te kau ki te kōhatu, kaua anō hoki ōna kikokiko e kainga; ā, ka tukua noatia atu te rangatira o te kau. ");
INSERT INTO mri2012_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Otiia ki te mea he kau wero ia nō mua, ā, kua whakaaturia ki tōna rangatira, ā, kāhore ia e tiaki i a ia, ā, ka mate i a ia tētahi tangata, tētahi wahine rānei; me āki te kau ki te kōhatu, me whakamate anō hoki tōna rangatira. ");
INSERT INTO mri2012_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ki te whakaritea kia hōmai e ia he moni, me hōmai e ia hei utu mō tōna ora te mea i whakaritea ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ki te mea he tama, he kōtiro rānei i werohia e ia, kia rite anō ki tēnei tikanga te meatanga ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ki te wero te kau i tētahi pononga tāne, i tētahi pononga wahine rānei; kia toru tekau ngā hekere hiriwa e hōmai ki tō rāua ariki, me āki hoki te kau ki te kōhatu. ");
INSERT INTO mri2012_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ki te whakatuwhera hoki te tangata i tētahi poka, ki te keria rānei e te tangata tētahi poka, ā, e kore e hīpokina e ia, ā, ka taka he kau, he kāihe rānei ki roto; ");
INSERT INTO mri2012_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","me utu e te tangata nāna te poka, me hōmai he moni e ia ki tō rāua ariki; ā, māna te mea mate. ");
INSERT INTO mri2012_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ki te tukia te kau a tētahi tangata e te kau e tētahi, ā, ka mate; nā, me hoko e rāua te kau ora, ka wehe ai i ōna utu; me wehe anō hoki e rāua te mea kua mate. ");
INSERT INTO mri2012_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Otiia ki te mea i mōhiotia he kau wero ia nō mua, ā, kāhore i tiakina e tōna ariki, me utu e ia te kau ki te kau; ā, māna te mea mate.” ");
INSERT INTO mri2012_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ki te tāhae te tangata i te kau, i te hipi rānei, ā, ka patua, ka hokona rānei e ia; kia rima ngā kau e hōmai e ia hei utu mō te kau kotahi, kia whā hoki ngā hipi mō te hipi kotahi. ");
INSERT INTO mri2012_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Ki te mau te tāhae e poka ara ana, ā, ka patua, ka mate, kāhore he toto e heke mōna. ");
INSERT INTO mri2012_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ki te mea kua whiti te rā ki a ia, ka heke he toto mōna; me hōmai hoki e ia he utu; ki te kāhore āna mea, nā, me hoko ia mō tāna tāhae. ");
INSERT INTO mri2012_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Ki te mau pū ki tōna ringa te mea i tāhaetia, he kau, he kāihe rānei, he hipi rānei, ā, e ora ana; kia rua ngā utu e hōmai e ia. ");
INSERT INTO mri2012_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ki te mea tētahi tangata kia kainga tētahi māra, tētahi kāri wāina rānei, ā, ka tukua atu e ia tana kararehe hei kai i te māra a tētahi; me utu e ia ki ngā hua papai rawa o tāna māra, ki ngā hua papai rawa hoki o tāna kāri wāina. ");
INSERT INTO mri2012_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ki te toro atu te ahi, ā, ka pono ki ngā tātarāmoa, ā, ka pau ngā whakapū wīti, te wīti rānei e tū ana, te māra rānei; me āta whakautu e te tangata nāna i tahu te ahi. ");
INSERT INTO mri2012_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ki te hōmai e te tangata tētahi moni ētahi mea rānei, ki tōna hoa kia tiakina, ā, ka tāhaetia i roto i te whare o taua tangata; ki te kitea te tāhae, kia rua ngā utu e hōmai e ia. ");
INSERT INTO mri2012_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ki te kāhore i kitea te tāhae, nā, me kawe te rangatira o te whare ki te Atua, kia kitea me kāhore i totoro tōna ringaringa ki ngā taonga a tōna hoa. ");
INSERT INTO mri2012_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","I ngā whakawākanga hara katoa mō te kau, kāihe, hipi, kākahu, mō te ngaromanga o tētahi mea e kīia ana e tētahi nōna, me haere te kōrero a te tokorua ki te Atua; ko te tangata kua whakataua te hē ki a ia e te Atua, kia rua ngā utu e hōmai e ia ki tōna hoa. ");
INSERT INTO mri2012_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ki te hōmai e tētahi he kāihe ki tōna hoa, he kau rānei, he hipi rānei, tētahi rānei o ngā tini kararehe, kia tiakina; ā, ka mate, ka whara rānei, ka pāhuatia rānei, kīhai anō hoki i kitea. ");
INSERT INTO mri2012_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ka waiho i waenganui i a rāua te oati a Ihowā, mō tōna ringa kīhai i totoro atu ki te taonga o tōna hoa; ā, me whakaae mai e te rangatira o taua mea, e kore anō hoki e utua. ");
INSERT INTO mri2012_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Otiia, ki te mea kua tāhaetia atu i a ia, me hoatu he utu ki tōna rangatira. ");
INSERT INTO mri2012_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ki te mea kua haehaea, me kawe mai e ia hei whakaatu, ā, e kore e utua e ia te mea i haea. ");
INSERT INTO mri2012_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ki te tīkina anō hoki e te tangata tētahi mea a tōna hoa, ā, ka whara, ka mate rānei, me te ngaro anō te rangatira o taua mea, me āta whakautu anō e ia. ");
INSERT INTO mri2012_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Kei reira te rangatira, e kore e utua; ki te mea e utua ana tōna tukunga, i haere mai hoki mō tōna utu.” ");
INSERT INTO mri2012_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ki te whakawai te tangata i te kōtiro kīhai i taumautia, ā, ka moe rāua, me whakarite he tāpākūhā, ā, me mārena e ia hei wahine māna. ");
INSERT INTO mri2012_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ki te tino whakakāhore rawa tōna pāpā, ā, e kore e tukua ki a ia, me hōmai e ia ngā moni e rite ana ki te kaireperepe mō ngā kōtiro. ");
INSERT INTO mri2012_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Kei tukua e koe te wahine mākutu kia ora. ");
INSERT INTO mri2012_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ko te tangata i takotoria e ia he kararehe, me whakamate rawa. ");
INSERT INTO mri2012_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Me whakangaro rawa te tangata e patu whakahere ana mā tētahi atua kē; engari mā Ihowā anake. ");
INSERT INTO mri2012_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Kaua hoki e whakatoia te manene, kaua anō hoki ia e tūkinotia; he manene hoki koutou i mua, i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Kaua e whakatupuria kinotia te pouaru, te pani rānei. ");
INSERT INTO mri2012_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ki te anga koe ki te whakatupukino i a rāua, ā, ka tangi rāua ki ahau, inā, ka whakarongo ahau ki tā rāua karanga; ");
INSERT INTO mri2012_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ā, ka mura tōku riri, ka patua anō hoki koutou ki te hoari; ā, ka pouarutia ā koutou wāhine, ka pania anō hoki ā koutou tamariki. ");
INSERT INTO mri2012_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ki te whakatārewa koe i te moni ki tētahi o tāku iwi, ki tētahi o ōu rawakore, kei rite tāu ki a ia ki tā te kaiwhakatuputupu moni, kei tangohia i a ia te moni whakatuputupu. ");
INSERT INTO mri2012_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ki te tangohia e koe te kākahu o tōu hoa hei taunaha, kaua e tukua kia rere te rā ka whakahoki ai ki a ia; ");
INSERT INTO mri2012_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ko tēnā anake nā hoki hei uhi mōna, hei kākahu mōna, mō tōna kiri; ā, ko te aha hei moenga iho mōna? Ki te karanga mai hoki ia ki ahau, nā, ka whakarongo atu ahau; nō te mea he mahi tohu tangata tāku. ");
INSERT INTO mri2012_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Kaua e kohukohu ki te Atua, kaua anō hoki e kanga ki te ariki o tōu iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Kei whakaroa koe ki te hōmai i ngā mātāmua o ōu hua, o ōu wai. “Me hōmai e koe te mātāmua o āu tamariki ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Kia pērā anō tāu e mea ai ki āu kau, ki āu hipi: e whitu ngā rā e noho ai ia ki tōna whaea; i te waru o ngā rā me hōmai ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Hei tāngata tapu hoki koutou māku; kaua anō e kai i te kikokiko i haea ki te pārae; me maka mā te kurī.” ");
INSERT INTO mri2012_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Kei puaki i a koe te kōrero tito noa. Kei totoro tahi tōu ringa me te tangata kino, kei meinga hei kaiwhakaatu teka. ");
INSERT INTO mri2012_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Kei whai tahi me te tokomaha ki te kino. Kaua anō hoki e hamumu i te totohenga, hei mea kia riro ai i tā te tokomaha, hei whakapeau kē i te tika; ");
INSERT INTO mri2012_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","kaua anō e whakanuia te rawakore, ina tohe ia. ");
INSERT INTO mri2012_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ki te tūtaki koe ki te kau a tōu hoariri, ki tana kāihe rānei, e atiti noa ana, me āta whakahoki e koe ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ki te kite koe i te kāihe a tōu hoariri e takoto ana i raro i tāna pīkaunga, ā, ka ngākaukore koe ki te whakaara, me āta whakaara tahi e kōrua. ");
INSERT INTO mri2012_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Kei whakapeaua kētia e koe te whakawā mō tōu tangata rawakore, ina tohe ia. ");
INSERT INTO mri2012_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kia matara koe i te teka; kaua anō e whakamatea te tangata harakore rāua ko te tangata tika; e kore hoki ahau e whakatika i tā te tangata hara. ");
INSERT INTO mri2012_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Kaua anō e tango i te utu whakapati; he mea whakamatapō hoki te utu whakapati i te kānohi kite, he mea whakaparori kē hoki i ngā kupu a te hunga tika. ");
INSERT INTO mri2012_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Kaua anō e tūkinotia te manene; e mōhio ana hoki koutou ki te ngākau o te manene; he manene hoki koutou i mua, i te whenua o Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Kia ono hoki ngā tau e rui ai koe i tōu oneone, e kohikohi ai hoki i ōna hua; ");
INSERT INTO mri2012_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","i te whitu ia me waiho kia takoto kau ana, kia pariri, ā, ka kai ngā tāngata rawakore o tōu iwi; ā, mā ngā kīrehe o te pārae ā rātou toenga e kai. Kia pēnā anō koe ki tāu māra wāina, ki tāu māra ōriwa. ");
INSERT INTO mri2012_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“E ono ngā rā e mahi ai koe i āu mahi, ā, i te whitu ka okioki; kia okioki ai tāu kau, me tāu kāihe, kia whai tānga manawa ai hoki te tama a tāu pononga wahine me te manene. ");
INSERT INTO mri2012_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Kia tūpato anō ki ngā mea katoa kua kōrerotia nei e ahau ki a koutou. Kaua hoki e whakahuatia te ingoa o ngā atua kē, kei rangona hoki ki tōu māngai.” ");
INSERT INTO mri2012_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“E toru ngā wā o te tau e tuku hākari ai koe ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Kia mau ki te Hākari o te Taro Rēwenakore; e whitu ngā rā e kai ai koe i te taro rēwenakore, e pērā ai me tāku i whakahau ai ki a koe, i te wā anō i whakaritea o te marama, o Apipi; nō reira hoki koe i haere mai ai i Īhipa. “Kaua anō hoki tētahi e puta kau mai ki tōku aroaro. ");
INSERT INTO mri2012_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Ki te Hākari o te Kotinga, o te mātāmua o āu mahi, i ruia e koe ki te māra. “Ki te Hākari o te Kohikohinga i te mutunga o te tau, ina oti te kohikohi mai e koe āu mahi i te māra. ");
INSERT INTO mri2012_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“E toru ngā wā o te tau e kitea ai ōu tāne katoa ki te aroaro o te Ariki, o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Kaua e whakaherea tahitia me te taro rēwena te toto o tāku patunga tapu; kei toe anō hoki ki te ata te ngako o tāku hākari. ");
INSERT INTO mri2012_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Me kawe e koe ki te whare o Ihowā, o tōu Atua ngā mea mataati o ngā mātāmua o tōu oneone. “Kaua e kōhuatia te kūao koati ki te waiū o tōna whaea.” ");
INSERT INTO mri2012_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Nanā, ka tonoa nei e ahau he anahera ki mua i a koe, hei tiaki i a koe i te ara, hei kawe hoki i a koe ki te wāhi i whakaritea e ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Kia tūpato ki a ia, whakarongo hoki ki tōna reo, kaua e whakapātaritari ki a ia; nō te mea e kore ia e whakarere noa iho i tō koutou hara; kei a ia nei hoki tōku ingoa. ");
INSERT INTO mri2012_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ki te āta whakarongo i a koe ki tōna reo, ki te mea hoki i ngā mea katoa e kōrero ai ahau; nā, ko ahau hei hoariri mō ōu hoariri, hei hoa whawhai hoki ki ōu hoa whawhai. ");
INSERT INTO mri2012_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ka haere hoki tāku anahera ki mua i a koe, hei kawe i a koe ki ngā Amori, ki ngā Hiti, ki ngā Perihi, ki ngā Kanaani, ki ngā Hiwi, ki ngā Iepuhi; ka hunā rātou e ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Kei koropiko koe ki ō rātou atua, kei mahi hoki ki a rātou, kei rite hoki āu mahi ki ā rātou mahi. Engari, me turaki rawa e koe, me wāwāhi rawa anō hoki ā rātou whakapakoko. ");
INSERT INTO mri2012_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ā, me mahi koutou ki a Ihowā, ki tō koutou Atua, ā, ka manaakitia e ia tāu taro, me tōu wai; ka whakakorea atu anō hoki e ahau te mate i roto i a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","E kore tētahi mea e whānau whakatahe, e pākoko rānei, i tōu whenua; ka āta tutuki anō i ahau te maha o ōu rā. ");
INSERT INTO mri2012_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Ka tukua atu e ahau tāku wehi ki mua i a koe, ā, ka whakamatea ngā iwi katoa e haere atu nei koe ki a rātou, ka meinga anō hoki e ahau kia tahuri ngā tuarā o ōu hoariri katoa ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ka ungā anō e ahau te horonete ki mua i a koe, māna e pei ngā Hiwi, ngā Kanaani, me ngā Hiti i tōu aroaro. ");
INSERT INTO mri2012_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","E kore rātou e peia e ahau i tōu aroaro i te tau kotahi; kei ururuatia te whenua, ā, ka nui rawa i a koe te kīrehe o te pārae. ");
INSERT INTO mri2012_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ka peia rikirikitia atu rātou e ahau i tōu aroaro, kia hua rā anō koe, kia riro rā anō hoki te whenua i a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Ā, ka whakatakotoria e ahau tōu rohe ki te Moana Whero ā tae noa ki te Moana o ngā Pirihitini, ki te koraha hoki ā tae noa ki te awa. Ka tukua atu nei hoki e ahau ki ō koutou ringa ngā tāngata o te whenua, ā, ka peia rātou e koe i tōu aroaro. ");
INSERT INTO mri2012_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kaua e whakarite kawenata ki a rātou, ki ō rātou atua rānei. ");
INSERT INTO mri2012_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kaua rātou e noho ki tōu whenua, kei mea rātou i a koe kia hara ki ahau; tā te mea, ki te mahi koe ki ō rātou atua, ka ai tēnā hei rore mōu.” ");
INSERT INTO mri2012_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Nā, ka mea ia ki a Mohi, “Piki ake ki a Ihowā koutou ko Ārona, ko Nātapa, ko Apihu, kia whitu tekau anō hoki o ngā kaumātua o Īharaira; ā, me koropiko mai koutou i tawhiti. ");
INSERT INTO mri2012_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ko Mohi anake hoki e whakatata mai ki a Ihowā; ko rātou ia, kaua rātou e whakatata mai; me te iwi hoki, kaua rātou e piki tahi ake me ia.” ");
INSERT INTO mri2012_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Nā, ka haere a Mohi, ka kōrerotia e ia ki te iwi ngā kupu katoa a Ihowā, me ngā whakariteritenga katoa; ā, kotahi anō te reo o te iwi katoa ki te whakahoki, ka kī rātou, “Ka meatia e mātou ngā mea katoa i kōrerotia mai e Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Nā, ka tuhituhia e Mohi ngā kupu katoa a Ihowā. Ā, ka maranga wawe ia i te ata, ā, hangā ana e ia tētahi āta ki raro iho i te maunga, me ngā pou kotahi tekau mā rua mō ngā iwi kotahi tekau mā rua o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","I ungā anō e ia ētahi taitama o ngā tama a Īharaira, hei whakaeke i ngā tahunga tinana, hei patu hoki i ngā pūru hei patunga mō te pai ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Nā, ka tango a Mohi i tētahi wāhi o te toto, ā, makā ana e ia ki roto ki ngā peihana; ko tētahi wāhi hoki o te toto i tāia atu ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Nā, ka mau ia ki te Pukapuka o te Kawenata, ā, kōrerotia ana ki ngā taringa o te iwi; ā, ka mea rātou, “Ko ngā mea katoa i kīia mai nā e Ihowā ka meatia e mātou, ka rongo anō mātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Nā, ka mau a Mohi ki te toto, ā, tāia atu ana e ia ki te iwi, me te kī anō ia, “Nanā, te toto nei o te kawenata e whakaritea nei e Ihowā ki a koutou mō ēnei mea katoa.” ");
INSERT INTO mri2012_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Nā, ka piki ake a Mohi rātou ko Ārona, ko Nātapa, ko Apihu, me ngā kaumātua e whitu tekau o Īharaira; ");
INSERT INTO mri2012_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","nā, ka kite i te Atua o Īharaira. Kei raro anō i ōna waewae me te mea ko te hāpira i hangā hei whāriki, he rite tonu anō ki te tino rangi te mārama. ");
INSERT INTO mri2012_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ā, kīhai i totoro tōna ringa ki tētahi o ngā rangatira o ngā tama a Īharaira; heoi, ka titiro atu rātou ki te Atua, ka kai hoki, ka inu. ");
INSERT INTO mri2012_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nā, ka mea a Ihowā ki a Mohi, “Piki ake ki ahau ki te maunga, ā, hei reira koe noho ai; ā, ka hoatu e ahau ki a koe ngā papa kōhatu, me te ture, me te whakahau kua oti nei i ahau te tuhituhi, hei whakaako māu ki a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Nā, ko te whakatikanga ake o Mohi, rāua ko tāna tangata, ko Hohua; ka piki atu a Mohi ki te maunga o te Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","I mea anō ia ki ngā kaumātua, “Tāria ake māua i konei, kia hoki mai rā anō māua ki a koutou; nā, ko Ārona rāua ko Huru tēnā hei hoa mō koutou. Ki te whai take tētahi tangata, me haere ia ki a rāua.” ");
INSERT INTO mri2012_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Nā, piki ana a Mohi ki te maunga, e taupokina ana hoki te maunga e te kapua. ");
INSERT INTO mri2012_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ā, i tau te korōria o Ihowā ki runga ki Maunga Hinai; ā, e ono ngā rā i taupokina ai a reira e te kapua; ā, i te whitu o ngā rā ka karanga ia ki a Mohi i waenganui o te kapua. ");
INSERT INTO mri2012_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ā, i rite te āhua o te korōria o Ihowā ki te ahi e kai ana i runga i te tihi o te maunga, i te tirohanga a ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Nā, ka haere a Mohi ki waenganui o te kapua, ā, pikitia ana e ia te maunga. Ā, e whā tekau ngā rā o Mohi ki runga ki te maunga, e whā tekau hoki ngā pō. ");
INSERT INTO mri2012_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nā, ka kōrero a Ihowā ki a Mohi, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Kōrero atu ki ngā tama a Īharaira, kia maua mai e rātou he whakahere māku. Me tango e koutou te whakahere māku i ngā tāngata katoa e hihiko noa mai ana ō rātou ngākau. ");
INSERT INTO mri2012_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ko te whakahere anō tēnei e tangohia e koutou i a rātou; he kōura, he hiriwa, he parāhi, ");
INSERT INTO mri2012_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","me te kākahu purū, me te pāpura, me te ngangana, me te rīnena pai, me te huruhuru koati, ");
INSERT INTO mri2012_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","me ngā hiako hipi kua oti te whakawhero, me ngā hiako pateri, me ētahi rākau, he hitimi, ");
INSERT INTO mri2012_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","te hinu mō te whakamārama, ngā mea kakara mō te hinu whakawahi, mō te whakakakara reka hoki, ");
INSERT INTO mri2012_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ngā kōhatu onika, me ngā kōhatu hei whakanoho ki te epora, ki te kōuma. ");
INSERT INTO mri2012_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Ā, kia hangā e rātou he wāhi tapu mōku; kia noho ai ahau i waenganui i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kia rite ā koutou e hanga ai ki ngā mea katoa e whakakitea nei e ahau ki a koe, ki te tauira o te tapenākara, ki te tauira hoki o ōna mea katoa.” ");
INSERT INTO mri2012_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Me hangā anō hoki e rātou he āka, ki te hitimi te rākau; kia rua ngā whatīanga me te hāwhe te roa, kia kotahi whatīanga me te hāwhe te whānui, ā, kia kotahi whatīanga me te hāwhe te teitei. ");
INSERT INTO mri2012_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ā, me whakakikorua e koe ki te kōura parakore; me whakakikorua e koe taua mea, a roto, a waho, me hanga anō hoki e koe he niao kōura ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kia whā anō ngā mōwhiti kōura e whakarewaina mō taua āka, ka whakanoho ai ki ngā poti e whā; kia rua mōwhiti ki tētahi taha ōna, kia rua mōwhiti ki tētahi taha ōna. ");
INSERT INTO mri2012_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Me hanga anō e koe ētahi rākau amo, ki te hitimi te rākau, ka whakakikorua hoki ki te kōura. ");
INSERT INTO mri2012_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ka kuhu ai i ngā rākau amo ki roto ki ngā mōwhiti i ngā taha o te āka, kia ai aua mea hei maunga mō te āka. ");
INSERT INTO mri2012_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Hei ngā mōwhiti o te āka ngā amo mau ai; kaua e unuhia ki waho. ");
INSERT INTO mri2012_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ā, me hoatu e koe ki roto ki te āka te whakaaturanga e hoatu e ahau ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Me hanga anō e koe te taupoki ki te kōura parakore; kia rua ngā whatīanga me te hāwhe tōna roa, kia kotahi hoki whatīanga me te hāwhe tōna whānui. ");
INSERT INTO mri2012_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Me hanga anō ētahi kerupima, kia rua, he mea patu te kōura e hangā ai aua mea ā puta noa, mō ngā pito e rua o te taupoki. ");
INSERT INTO mri2012_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Me hanga hoki tētahi kerupi ki tētahi pito, me tētahi kerupi ki tētahi pito; me hono ngā kerupima ki te taupoki, ki ōna pito e rua. ");
INSERT INTO mri2012_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ā, ka roha whakarunga ngā parirau o ngā kerupima, me te uhi anō i te taupoki ki ō rāua parirau, ka anga anō ō rāua mata ki a rāua; ka anga ki te taupoki ngā mata o ngā kerupima. ");
INSERT INTO mri2012_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ā, me whakanoho e koe te taupoki ki runga ki te āka; me hoatu anō ki roto ki te āka te whakaaturanga e hoatu e ahau ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ā, ka tūtaki ahau ki a koe ki reira, ka kōrerotia anō ki a koe i runga i te taupoki i waenganui i ngā kerupima e rua, i ērā i runga i te āka o te whakaaturanga, ngā mea katoa e whakahau ai ahau ki a koe mō ngā tama a Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Me hanga anō e koe tētahi tēpu, ki te hitimi te rākau; kia rua ngā whatīanga te roa, kia kotahi whatīanga te whānui, kia kotahi whatīanga me te hāwhe te teitei. ");
INSERT INTO mri2012_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Me whakakikorua taua mea ki te kōura parakore, ka hanga ai i tētahi niao kōura mōna ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Me hanga anō he awhi mō taua mea, hei te whānui ringa ā tawhio noa; me hanga anō he niao kōura mō tōna awhi ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Me hanga anō ētahi mōwhiti kōura, kia whā, mō taua mea, ka whakanoho ai i ngā mōwhiti ki ngā poti e whā i ōna waewae e whā. ");
INSERT INTO mri2012_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Hei te taha tonu ake o te awhi ngā mōwhiti, hei kuhunga atu mō ngā amo hei maunga mō te tēpu. ");
INSERT INTO mri2012_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","He hitimi te rākau e hangā ai e koe ngā amo; me whakakikorua anō ki te kōura; ā, ka ai aua mea hei maunga mō te tēpu. ");
INSERT INTO mri2012_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Me hanga anō ōna rīhi, ōna koko, ōna kapu, me ngā peihana mō ngā ringihanga; me hanga ki te kōura parakore. ");
INSERT INTO mri2012_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Me whakatakoto tonu te taro aroaro ki te tēpu, ki tōku aroaro.” ");
INSERT INTO mri2012_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Me hanga anō te tūranga rama ki te kōura parakore. Me patu te mahinga o te tūranga rama tae noa ki tōna take, ki ōna peka; ko ōna kapu, ko ōna puku, me ōna puāwai he kotahi me ia. ");
INSERT INTO mri2012_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ā, kia ono ngā peka e puta ake i ōna taha; e toru ngā peka o te tūranga rama i tētahi taha, e toru hoki ngā peka o te tūranga rama i tētahi taha. ");
INSERT INTO mri2012_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kia toru ngā kapu, he mea rite ki te puāwai aramona, te puku, me te puāwai, ki te peka kotahi; me ngā kapu e toru, he mea rite ki te puāwai aramona ki tētahi atu peka, te puku, me te puāwai. Me pērā tonu i ngā peka e ono e puta ake ana i te tūranga rama. ");
INSERT INTO mri2012_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kia whā ia ngā kapu o te tūranga rama, kia rite ki te puāwai aramona, te puku, me te puāwai, o tētahi, o tētahi. ");
INSERT INTO mri2012_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ā, e rua ōna peka, kia kotahi puku o raro ake, he mea kotahi; e rua ōna peka, kia kotahi puku o raro ake, he mea kotahi; e rua ōna peka, kia kotahi puku o raro ake, he mea kotahi anō, o ngā peka e ono e puta mai ana i te tūranga rama. ");
INSERT INTO mri2012_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Nō te mea kotahi ngā puku, ngā peka; ko taua mea katoa, he mea patu, kotahi tonu, he kōura parakore. ");
INSERT INTO mri2012_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Me hanga ōna rama e whitu; ā, me tahu ōna rama, hei whakamārama i tōna hāngaitanga atu. ");
INSERT INTO mri2012_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Me kōura parakore anō ōna kuku me ōna oko ngārahu. ");
INSERT INTO mri2012_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kia kotahi taranata kōura parakore e hangā ai taua mea, me ēnā oko katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Kia tūpato anō kia hangā aua mea kia rite ki te tauira i whakakitea ki a koe i te maunga.” ");
INSERT INTO mri2012_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Me hanga anō e koe te tapenākara, kia tekau pīhi rīnena miro pai; he purū hoki, he pāpura, he ngangana; me whatu ki roto ētahi kerupima; kia tohunga rawa te mahi. ");
INSERT INTO mri2012_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kia rua tekau mā waru whatīanga te roa o te pīhi kotahi, kia whā whatīanga te whānui o te pīhi kotahi; kia rite te nui o ngā pīhi katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Me hono ngā pīhi e rima tētahi ki tētahi; me ērā atu pīhi e rima hoki, me hono tētahi ki tētahi. ");
INSERT INTO mri2012_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Me hanga anō ētahi koropiko purū ki te taha o tētahi pīhi, ki te taha e honoa ana. Me pēnā anō e koe ki te taha ki waho o tētahi pīhi, ki te taha e honoa mai ai te rua. ");
INSERT INTO mri2012_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Kia rima tekau ngā koropiko e hangā e koe ki tētahi pīhi, kia rima tekau hoki ngā koropiko e hangā ki te taha o te pīhi e honoa mai ai te rua, kia hāngai ai ngā koropiko tētahi ki tētahi. ");
INSERT INTO mri2012_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Me hanga anō ētahi toromoka kōura, kia rima tekau, ka hono ai i ngā pīhi ki ngā toromoka; ā, ka kotahi te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Me hanga anō hoki ētahi pīhi ki te huruhuru koati, hei tēneti mō runga i te tapenākara; kia kotahi tekau mā tahi ngā pīhi e hangā e koe. ");
INSERT INTO mri2012_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Kia toru tekau whatīanga te roa o tētahi pīhi, kia whā hoki whatīanga te whānui o tētahi pīhi, kia rite tonu te nui o ngā pīhi kotahi tekau mā tahi. ");
INSERT INTO mri2012_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ā, me hono ngā pīhi e rima ki a rātou anō, me ngā pīhi e ono ki a rātou anō; ā, me whawhati te tuaono o ngā pīhi ki te wāhi ki mua o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Me hanga anō kia rima tekau ngā koropiko mō te tapa o tō waho pīhi, i te hononga, me ngā koropiko e rima tekau ki te tapa o te pīhi o waho rawa, e honoa mai ai te rua. ");
INSERT INTO mri2012_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","“Me hanga anō ētahi toromoka parāhi, kia rima tekau, ā, ka kuhu i ngā toromoka ki ngā koropiko, ka hono hoki i te tēneti kia kotahi. ");
INSERT INTO mri2012_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ā, ko te wāhi i kohirahira atu o ngā pīhi o te tēneti, te taha o te pīhi i mahue atu rā, me whakapahika ki waho atu o te tuarongo o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ā, ko te wāhi e roa iho ana o ngā pīhi o te tēneti, kia kotahi whatīanga o tētahi pito, kia kotahi whatīanga o tētahi pito, e pūrero iho i ngā taha o te tapenākara, i tētahi taha, i tētahi taha, hei uhi. ");
INSERT INTO mri2012_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Me hanga anō e koe ētahi hiako hipi, he mea kua oti te whakawhero, hei uhi mō te tēneti, me ētahi hiako pateri, hei uhi mō waho atu.” ");
INSERT INTO mri2012_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Me hanga anō ētahi papa mō te tapenākara, ki te hitimi te rākau, he mea whakatū. ");
INSERT INTO mri2012_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kia kotahi tekau whatīanga te roa o te papa, kia kotahi hoki whatīanga me te hāwhe te whānui o te papa kotahi. ");
INSERT INTO mri2012_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Kia rua ngā arero o te papa kotahi, kia ririte ki a rāua; kia pēnā tonu tāu e mea ai ki ngā papa katoa o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Nā, me hanga ngā papa mō te tapenākara, kia rua tekau ngā papa mō te taha ki te tonga whaka te tonga. ");
INSERT INTO mri2012_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Me hanga anō ngā tūranga hiriwa e whā tekau mō raro iho i ngā papa e rua tekau; kia rua ngā tūranga ki raro i tētahi papa mō ōna arero e rua, kia rua hoki tūranga ki raro i tētahi papa mō ōna arero e rua. ");
INSERT INTO mri2012_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kia rua tekau hoki ngā papa mō te rua o ngā taha o te tapenākara, mō te taha ki te raki, ");
INSERT INTO mri2012_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","me ngā tūranga hiriwa e whā tekau o aua mea, ngā tūranga e rua mō raro i tētahi papa, me ngā tūranga e rua mō raro i tētahi atu papa. ");
INSERT INTO mri2012_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ā, mō te tuarongo o te tapenākara whaka te hauāuru me hanga e koe kia ono ngā papa. ");
INSERT INTO mri2012_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kia rua ngā papa e hangā e koe mō ngā koki o te tapenākara i te tuarongo. ");
INSERT INTO mri2012_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ā, me hono aua papa i raro, me hono anō hoki i runga rawa ki te mōwhiti kotahi; me pēnā aua papa e rua, me waiho mō ngā koki e rua. ");
INSERT INTO mri2012_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Nā, ka waru ēnā papa me ngā tūranga hiriwa; kotahi tekau mā ono ngā tūranga; e rua ngā tūranga mō raro i tētahi papa, e rua hoki ngā tūranga mō raro i tētahi atu papa. ");
INSERT INTO mri2012_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Me hanga anō hoki e koe ētahi kaho, ki te hitimi te rākau; kia rima mō ngā papa o tētahi taha o te tapenākara, ");
INSERT INTO mri2012_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","kia rima hoki ngā kaho mō ngā papa o tētahi atu taha o te tapenākara, kia rima hoki ngā kaho mō ngā papa o tētahi pito o te tapenākara, arā o te tuarongo whaka te hauāuru. ");
INSERT INTO mri2012_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ā, ko tō waenga kaho, i waenganui o ngā papa, ka rere atu i tētahi pito, ki tētahi pito. ");
INSERT INTO mri2012_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ā, me whakakikorua e koe ngā papa ki te kōura, me hanga anō hoki ngā mōwhiti ki te kōura hei kuhunga mō ngā kaho; me whakakikorua anō hoki ngā kaho ki te kōura. ");
INSERT INTO mri2012_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Nā, me whakaara e koe te tapenākara; kia rite hoki ki tōna tauira i whakakitea ki a koe i te maunga.” ");
INSERT INTO mri2012_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Me hanga anō e koe he ārai ki te mea purū, ki te pāpura, ki te ngangana, ki te rīnena miro pai; kia whatua anō hoki he kerupima ki roto; kia tohunga rawa te mahi. ");
INSERT INTO mri2012_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ka whakairi ai ki runga ki ngā pou hitimi e whā, he mea whakakikorua ki te kōura; me kōura ngā matau, ki runga anō i ngā tūranga hiriwa e whā. ");
INSERT INTO mri2012_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ā, me whakairi e koe te ārai ki raro i ngā toromoka, ka kawe ai i te āka o te whakaaturanga ki reira, ki roto i te ārai; ā, ko te ārai hei wehe mā koutou i te Wāhi Tapu, i te Wāhi Tino Tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Me whakatakoto anō e koe te taupoki ki runga ki te āka o te whakaaturanga, ki te Wāhi Tino Tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Me whakatū anō te tēpu ki waho mai o te ārai, me te tūranga rama ki te ritenga atu o te tēpu, ki te taha o te tapenākara whaka te tonga. Me whakatū hoki e koe te tēpu ki te taha ki te raki. ");
INSERT INTO mri2012_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Me hanga anō he pā mō te whatitoka o te tēneti, ki te mea purū, ki te pāpura, ki te ngangana, ki te rīnena miro pai, he mea whakairo ki te ngira. ");
INSERT INTO mri2012_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Me hanga anō mō te pā kia rima ngā pou hitimi, ka whakakikorua ki te kōura, me kōura ngā matau o aua mea; me whakarewa anō hoki e koe ētahi tūranga parāhi e rima mō aua mea.” ");
INSERT INTO mri2012_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Me hanga anō e koe tētahi āta, ki te hitimi te rākau, kia rima ngā whatīanga te roa, kia rima whatīanga te whānui; kia tapawhā te āta; kia toru hoki ngā whatīanga te teitei. ");
INSERT INTO mri2012_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Me hanga ōna haona ki ngā koki e whā; kia kotahi te rākau o taua mea, o ōna haona; me whakakikorua anō ki te parāhi. ");
INSERT INTO mri2012_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Me hanga anō ōna takotoranga mō ōna pungarehu, me ōna koko pungarehu, me ōna peihana, me ōna mārau, me ōna oko ngārahu; me hanga ōna mea katoa ki te parāhi. ");
INSERT INTO mri2012_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Me hanga anō tōna pae kupenga ki te parāhi, he mea rīpekapeka; ā, me hanga ki runga i taua mea rīpekapeka ngā mōwhiti parāhi e whā ki ōna pito e whā. ");
INSERT INTO mri2012_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ā, me whakanoho taua mea ki raro i te awhi o te āta, ki raro iho, kia takapū ai taua mea rīpekapeka ki waenganui o te āta. ");
INSERT INTO mri2012_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Me hanga ētahi amo mō te āta, he amo hitimi, ka whakakikorua hoki ki te parāhi. ");
INSERT INTO mri2012_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ā, ka kuhua ngā amo ki ngā mōwhiti, hei ngā taha e rua o te āta ngā amo, hei amo. ");
INSERT INTO mri2012_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kia tuwhera kau a roto, me hanga e koe ki te papa; kia rite tāu e hanga ai ki tērā i whakakitea ki a koe ki te maunga.” ");
INSERT INTO mri2012_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Me hanga anō te marae o te tapenākara. Hei te rīnena miro pai he pā mō te taha ki te tonga whaka te tonga; kia kotahi rau whatīanga te roa mō tētahi taha; ");
INSERT INTO mri2012_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ko ngā pou kia rua tekau, ko ngā tūranga o aua mea kia rua tekau, me parāhi; me hiriwa ia ngā matau o ngā pou, me ngā awhi. ");
INSERT INTO mri2012_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Me ngā pā mō te taha ki te raki kia kotahi rau whatīanga te roa, me ngā pou e rua tekau, me ngā tūranga e rua tekau, he parāhi; me ngā matau hiriwa o ngā pou, me ngā awhi hiriwa. ");
INSERT INTO mri2012_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Me ngā pā mō te whānui o te marae ki te taha ki te hauāuru kia rima tekau whatīanga; kia kotahi tekau ngā pou, me ngā tūranga kotahi tekau. ");
INSERT INTO mri2012_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kia rima tekau hoki whatīanga te whānui o te marae ki te taha ki te rāwhiti whaka te rāwhiti. ");
INSERT INTO mri2012_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Kia tekau mā rima whatīanga ngā pā o tētahi taha o te kūwaha, kia toru ngā pou, kia toru hoki ngā tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Kia tekau mā rima hoki whatīanga o ngā pā o tērā taha; kia toru ngā pou, kia toru hoki ngā tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Kia rua tekau hoki whatīanga o te pā mō te kūwaha o te marae, he purū, he pāpura, he ngangana, he rīnena miro pai, he mea whakairo ki te ngira; kia whā hoki ngā pou, kia whā hoki ngā tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Me whakawhaiawhi ngā pou katoa o te marae ā taka noa ki te hiriwa; me hiriwa ngā matau, me parāhi ngā tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kia kotahi rau whatīanga te roa o te marae, kia rima tekau hoki te whānui i ngā wāhi katoa, kia rima hoki whatīanga te teitei, ki te rīnena miro pai, me parāhi hoki ngā tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Me parāhi ngā oko katoa o te tapenākara mō ngā mahi katoa o reira, ngā titi katoa o reira, me ngā titi katoa o te marae.” ");
INSERT INTO mri2012_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Me whakahau anō e koe ngā tama a Īharaira kia kawea mai ki a koe he hinu ōriwa, he mea parakore, he mea tuki, mō te whakamārama, kia kā tonu ai te rama. ");
INSERT INTO mri2012_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Me whakapai e Ārona rātou ko āna tama taua mea i roto i te tapenākara o te whakaminenga, i waho o te ārai e iri ana i mua mai o te whakaaturanga, i te ahiahi ā tae noa ki te ata, ki te aroaro o Ihowā; hei tikanga tēnei mō ake tonu atu, mā ō rātou whakatupuranga, mō ngā tama a Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Tangohia mai anō ki a koe a Ārona, tōu tuakana, rātou ko āna tama i roto i ngā tama a Īharaira, hei tohunga māku, a Ārona rātou ko Nātapa, ko Apihu, ko Ereātara, ko Itamara, ngā tama a Ārona. ");
INSERT INTO mri2012_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Me hanga anō e koe ētahi kākahu tapu mō Ārona, mō tōu tuakana, hei korōria, hei ātaahua. ");
INSERT INTO mri2012_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Me kōrero anō e koe ki ngā ngākau mōhio katoa, ki āku i whakakī ai ki te wairua mōhio, kia hangā e rātou ngā kākahu mō Ārona, mō tōna whakatapunga, mō tāna mahi tohunga ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ā, ko ngā kākahu ēnei e hangā e rātou; he kōuma, he epora, he koroka, he koti whakairo, he pōtae tohunga, he whītiki. Nā, me hanga ētahi kākahu tapu mō Ārona, mō tōu tuakana, rātou ko āna tama, mō tāna mahi tohunga ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Me tango hoki he kōura, he purū, he pāpura, he ngangana, he rīnena pai.” ");
INSERT INTO mri2012_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Ā, ka hangā te epora ki te kōura, ki te purū, ki te pāpura, ki te ngangana, ki te rīnena miro pai; kia tohunga rawa te mahi. ");
INSERT INTO mri2012_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kia rua ngā wāhi i ngā pokohiwi, he mea hono ki a rāua i ngā pito e rua; kia kotahi ai. ");
INSERT INTO mri2012_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ā, ko te whītiki whakairo o te epora, kia kotahi anō te mea e hangā ai rāua, kia rite hoki tō rāua hanganga; he mea kōura, purū, pāpura, ngangana, rīnena miro pai. ");
INSERT INTO mri2012_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Me tango anō e koe ngā kōhatu onika e rua, ka tuhi ai i ngā ingoa o ngā tama a Īharaira ki aua mea; ");
INSERT INTO mri2012_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","kia ono ngā ingoa o rātou ki tētahi kōhatu, me ērā ingoa atu hoki e ono ki tētahi atu kōhatu; kia rite ki ō rātou whānautanga. ");
INSERT INTO mri2012_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Hei te mahi a te kaituhi kōhatu tāu tuhi i ngā ingoa o ngā tama a Īharaira ki ngā kōhatu e rua, kia rite ki te tuhinga o te hīri; me mea e koe kia whakanohoia aua mea ki ngā nohoanga kōura. ");
INSERT INTO mri2012_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ā, me whakanoho e koe ngā kōhatu e rua ki ngā pokohiwi o te epora, hei kōhatu whakamahara mō ngā tama a Īharaira; ā, ka mau ō rātou ingoa ki runga ki ngā pokohiwi e rua o Ārona i te aroaro o Ihowā, hei whakamahara. ");
INSERT INTO mri2012_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Me hanga anō e koe ngā nohoanga kōhatu ki te kōura; ");
INSERT INTO mri2012_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","me ngā mekameka kōura parakore e rua; me whiri tāu mahinga i aua mea, ka whakaū ai i ngā mekameka whiri ki ngā nohoanga.” ");
INSERT INTO mri2012_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Kia tohunga rawa te hanga o te kōuma whakawā, kia rite tāu mahinga ki te mahinga o te epora; me hanga e koe taua mea ki te kōura, ki te purū, ki te pāpura, ki te ngangana, ki te rīnena miro pai. ");
INSERT INTO mri2012_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kia whā ōna taha, me rererua; kia kotahi whanganga a te ringa tōna roa, kia kotahi whanganga hoki a te ringa tōna whānui. ");
INSERT INTO mri2012_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Me whakanoho anō ki taua mea ētahi nohoanga kōhatu; kia whā ngā rārangi kōhatu. Mō te rārangi tuatahi he harariu, he tōpaha, he kapakara; ko te rārangi tuatahi tēnei. ");
INSERT INTO mri2012_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mā te rārangi tuarua he emerara, he hapaira, he taimana. ");
INSERT INTO mri2012_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Mō te rārangi tuatoru he rikuri, he akete, he ametihita. ");
INSERT INTO mri2012_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mō te rārangi tuawhā he perira, he onika, he hahapa; me whakanoho ki te kōura ki te wāhi e mau ai. ");
INSERT INTO mri2012_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Nā, ka tekau mā rua ngā kōhatu me ngā ingoa o ngā tama a Īharaira; ko te maha kei ō rātou ingoa; ko te tuhi hei o te hīri, tēnei tangata me tōna ingoa, tēnei tangata me tōna ingoa, rite tonu ki ngā iwi kotahi tekau mā rua. ");
INSERT INTO mri2012_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Me hanga anō e koe ki te kōura parakore ētahi mekameka, he mahi whiri, mō te kōuma, mō ngā pito. ");
INSERT INTO mri2012_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Me hanga anō e koe ētahi mōwhiti kōura kia rua mō te kōuma, ka whakanoho ai i ngā mōwhiti e rua ki ngā pito e rua o te kōuma. ");
INSERT INTO mri2012_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Me whakaū anō ngā mekameka kōura, ngā mea whiri, ki ngā mōwhiti e rua i ngā pito o te kōuma. ");
INSERT INTO mri2012_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ko ērā pito e rua hoki o ngā mekameka whiri e rua, me whakaū e koe ki ngā nohoanga kōhatu e rua, ka whakanoho ai ki ngā pokohiwi o te epora, ki te taha ki mua. ");
INSERT INTO mri2012_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Me hanga anō ētahi mōwhiti kōura kia rua, ka whakanoho ai ki ngā pito e rua o te kōuma ki tōna remu, ki te taha ki roto whaka te epora. ");
INSERT INTO mri2012_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Me hanga anō hoki e koe ētahi atu mōwhiti kōura kia rua, ka whakanoho ai ki ngā pokohiwi e rua o te epora ki te taha ki raro, ki te taha ki mua, ki te ritenga mai anō o tōna hononga, ki runga ake o te whītiki whakairo o te epora. ");
INSERT INTO mri2012_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Me here anō e rātou te kōuma, ko ōna mōwhiti ki ngā mōwhiti o te epora, ki ētahi miro purū, kia mau ai ki runga ake o te whītiki whakairo o te epora, kei takoto kē hoki te kōuma i te epora. ");
INSERT INTO mri2012_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Ā, ka mau ngā ingoa o ngā tama a Īharaira ki te ngākau o Ārona, arā ki te kōuma o te whakawā, ina haere ia ki te wāhi tapu, hei whakamahara ki te aroaro o Ihowā i ngā rā katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Me whakanoho anō hoki e koe ngā Urimi me ngā Tumime ki te kōuma whakawā; ā, hei te ngākau o Ārona aua mea, ina haere ki te aroaro o Ihowā; ā, ka mau tonu ki te ngākau o Ārona te whakawā o ngā tama a Īharaira i te aroaro o Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Me hanga anō e koe te koroka o te epora, hei te purū anake. ");
INSERT INTO mri2012_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Me whakakōhao a runga, i waenganui; me whakawhaiwhiri anō ki te mea whatu tōna kōhao ā huri noa, kia rite ki te kōhao o te pukupuku, kei pakaru. ");
INSERT INTO mri2012_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ā, i te remu i raro me hanga e koe ētahi pamekaranete ki te mea purū, pāpura, ngangana, hei te remu ā huri noa; me ētahi pere kōura ki ngā takiwā o aua mea ā huri noa, ");
INSERT INTO mri2012_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","he pere kōura he pamekaranete, he pere kōura he pamekaranete, ki te remu o te koroka ā huri noa. ");
INSERT INTO mri2012_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ā, me kākahu taua mea e Ārona ina minita; ā, ka rangona tōna tangi ina haere ki roto, ki te wāhi tapu, ki te aroaro o Ihowā, ina puta mai hoki ki waho kei mate ia. ");
INSERT INTO mri2012_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Me hanga anō e koe tētahi pāraharaha ki te kōura parakore, tuhia iho, he tuhi hīri anō: HE TAPU KI A IHOWĀ. ");
INSERT INTO mri2012_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ā, me whakanoho e koe ki te tau purū, kia mau ai ki te pōtae tohunga; hei te taha ki mua o te pōtae. ");
INSERT INTO mri2012_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ā, ka mau tēnā ki te rae o Ārona, kia mauria ai e Ārona te kino o ngā mea tapu e whakatapua e ngā tama a Īharaira i ā rātou hoatutanga tapu katoa; ā, ka mau tonu tēnā ki tōna rae, kia manakohia ai rātou i te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ā, me whakairo e koe ki te mūmū te koti rīnena pai, me hanga anō te pōtae tohunga ki te rīnena pai; hei te mea i hangā ki te ngira te mea e hangā ai e koe te whītiki. ");
INSERT INTO mri2012_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Me hanga anō ētahi koti mō ngā tama a Ārona, me hanga anō ētahi whītiki mō rātou, me hanga hoki ētahi pōtae mō rātou, hei korōria, hei ātaahua. ");
INSERT INTO mri2012_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ka whakakākahu atu ai ki a Ārona, ki tōu tuakana, rātou ko āna tama; nā, ka whakawahi koe i a rātou, ka whakatohunga hoki i a rātou, ka whakatapu hoki i a rātou, kia mahi, tohunga ai ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Me hanga anō ētahi tarau rīnena mō rātou, hei kākahu mō ngā wāhi takoto tahanga o rātou; mō te hope ā tae noa ki ngā hūhā; ");
INSERT INTO mri2012_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ā, hei kākahu ēnā mō Ārona, mō āna tama, ina haere ki roto ki te tapenākara o te whakaminenga, ina whakatata rānei ki te āta, ki te minita i roto i te wāhi tapu; kei whai hara, ā, ka mate. “Hei tikanga pūmau tēnei mōna, mō ōna uri hoki i muri i a ia.” ");
INSERT INTO mri2012_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ā, ko tēnei tāu e mea ai ki a rātou, ina whakatapu i a rātou hei tohunga māku. Tīkina he pūru, hei te kūao, me ngā hipi toa e rua, hei te mea kohakore, ");
INSERT INTO mri2012_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","he taro rēwenakore, he keke rēwenakore, i kōnatunatua ki te hinu, he mea angiangi anō hoki, he rēwenakore, i pania ki te hinu. He mea hanga e koe ki te parāoa wīti. ");
INSERT INTO mri2012_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Nā, ka makā ki te kete kotahi, ā, ka kawea i roto i te kete, me te pūru me ngā hipi toa e rua. ");
INSERT INTO mri2012_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Nā, ka kawe i a Ārona rātou ko āna tama, ki te whatitoka o te tapenākara o te whakaminenga, ka horoi i a rātou ki te wai. ");
INSERT INTO mri2012_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Nā, ka mau koe ki ngā kākahu, ā, ka whakakākahu i a Ārona ki te koti, ki te koroka o te epora, ki te epora, ki te kōuma, ka whītiki hoki i a ia ki te whītiki whakairo o te epora. ");
INSERT INTO mri2012_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ā, ka pōtae i tōna mātenga ki te pōtae tohunga, ka whakanoho anō i te karauna tapu ki runga ki te pōtae. ");
INSERT INTO mri2012_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Nā, ka mau ki te hinu whakawahi, ka riringi ki runga ki tōna mātenga, ka whakawahi i a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ā, ka kawe koe i āna tama, ka whakakākahu hoki i a rātou ki ngā koti. ");
INSERT INTO mri2012_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Me whītiki anō rātou e koe, a Ārona rātou ko āna tama, ka pōtae anō hoki i ngā pōtae ki a rātou; ā, mā rātou te mahi tohunga; kia pūmau tonu anō hoki tēnei tikanga. Nā, ka whakatohunga koe i a Ārona rātou ko āna tama. ");
INSERT INTO mri2012_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Nā, ka mea kia kawea tētahi pūru ki mua o te tapenākara o te whakaminenga; ā, ka popoki iho ngā ringa o Ārona rātou ko āna tama ki runga ki te pane o te pūru. ");
INSERT INTO mri2012_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Nā, ka patu koe i te pūru ki te aroaro o Ihowā, ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Nā, me tango tētahi wāhi o te toto a te pūru, me pani e tōu ringa ki ngā haona o te āta, ka riringi katoa ai i ngā toto ki te tūranga o te āta. ");
INSERT INTO mri2012_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Nā, ka tango koe i te ngako katoa e whiwhiwhiwhi ana ki ngā whēkau, me te pā i runga ake i te ate, me ngā whatukuhu e rua, me te pā i aua mea, ka tahu ai ki runga ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ko te kikokiko ia o te pūru, me tōna hiako, me ōna paru, me tahu e koe ki te ahi ki waho o te puni; he whakahere hara hoki tēnā. ");
INSERT INTO mri2012_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Nā, ka mau koe ki tētahi o ngā hipi toa; ā, ka popoki iho ngā ringaringa o Ārona rātou ko āna tama ki runga ki te mātenga o te hipi. ");
INSERT INTO mri2012_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Nā, ka patu koe i te hipi, ā, ka tango i ōna toto, ka tāuhi ai ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Nā, ka tapatapahi koe i te hipi, ā, ka horoi i ōna whēkau, me ōna waewae, ka maka ai ki runga ki ngā wāhi ōna i tapahia, ki runga hoki i tōna mātenga. ");
INSERT INTO mri2012_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Kātahi koe ka tahu i te hipi katoa ki runga ki te āta. He tahunga tinana tēnā ki a Ihowā, he kakara reka, he whakahere ahi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Nā, ka mau koe ki te rua o ngā hipi, ā, ka popoki iho ngā ringaringa o Ārona rātou ko āna tama ki runga ki te mātenga o te hipi. ");
INSERT INTO mri2012_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Nā, ka patu koe i te hipi, ā, ka tango i tētahi wāhi o ōna toto, ka pani atu ki te matamata o te taringa matau o Ārona, ki te matamata anō hoki o ngā taringa matau o āna tama, ki te koromatua anō hoki o ō rātou ringa matau, ki te koromatua anō hoki o ō rātou waewae matau, me tāuhiuhi atu anō hoki te toto ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Me tango anō e koe tētahi wāhi o ngā toto i runga i te āta, o te hinu whakawahi anō hoki, ā, ka tāuhiuhi atu ki a Ārona, ki ōna kākahu, ki a rātou, tahi anō ko āna tama, ki ngā kākahu hoki o āna tama. Nā, ka tapu ia, me ōna kākahu, me āna tama, me ngā kākahu anō hoki o āna tama. ");
INSERT INTO mri2012_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Me tango anō hoki e koe te ngako o te hipi toa, me te hiawero, me te ngako e whiwhiwhiwhi ana ki ngā whēkau, me te pā i te ate, i ngā whatukuhu e rua; me te ngako i aua mea, me te peke matau (he hipi whakatohungatanga hoki), ");
INSERT INTO mri2012_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","me te rohi taro kotahi, me tētahi keke taro hinu, me tētahi keke angiangi i roto i te kete taro rēwenakore i te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Nā, ka hoatu katoa e koe ki ngā ringa o Ārona, ki ngā ringa anō o āna tama; ā, me poipoi hei whakahere poipoi ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Nā, ka tango koe i aua mea i ō rātou ringa, ka tahu ai ki runga ki te āta, hei tahunga tinana, hei kakara reka ki te aroaro o Ihowā, hei whakahere ahi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Nā, ka tango koe i te uma o te hipi toa o te whakatohungatanga o Ārona, ā, ka poipoi hei whakahere poipoi i te aroaro o Ihowā; ko te wāhi hoki tēnā māu. ");
INSERT INTO mri2012_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Me whakatapu anō e koe te uma o te whakahere poipoi, me te peke o te whakahere hapahapai, ērā e poipoia ana, e hapahapainga ana, o te hipi o te whakatohungatanga, o tā Ārona, o tā āna tama. ");
INSERT INTO mri2012_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ā, ka waiho mā Ārona rātou ko āna tama, e ngā tama a Īharaira; kia pūmau tonu tēnei tikanga. He whakahere hapahapai hoki; ā, ka waiho e ngā tama a Īharaira hei whakahere hapahapai, he mea nō ā rātou patunga mō te pai, arā he whakahere hapahapai nā rātou ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Ā, ka riro ngā kākahu tapu o Ārona i āna tama i muri i a ia, hei kākahu e whakawahia ai, e whakatohungatia ai rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ā, e whitu ngā rā e kākahuria ai aua mea e te tama e meinga hei tohunga i muri i a ia, ina haere ia ki roto ki te tapenākara o te whakaminenga ki te minita i roto i te wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Me tango anō e koe te hipi toa o te whakatohungatanga, ā, ka kōhua i ōna kikokiko ki te wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ā, mā Ārona rātou ko āna tama e kai te kikokiko o te hipi, me te taro i roto i te kete, ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Me kai anō e rātou aua mea o te whakamārie, hei whakatohunga, hei whakatapu mō rātou. Kauaka ia te tangata kē e kai; he mea tapu hoki ēnā. ");
INSERT INTO mri2012_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ā, ki te toe tētahi wāhi o te kikokiko o ngā whakatohungatanga, o te taro rānei, ki te ata, me tahu e koe taua toenga ki te ahi; kei kainga, he mea tapu hoki. ");
INSERT INTO mri2012_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Kia pēnei tāu e mea ai ki a Ārona rātou ko āna tama; kia rite ki ngā mea katoa i whakahaua atu nei e ahau ki a koe. E whitu ngā rā e whakatohunga ai koe i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ā, me tuku e koe i tēnei rā, i tēnei rā, tētahi kau hei whakahere hara, hei whakamārie. Me pure anō e koe te āta, ina oti i a koe te whakamārie mō taua mea; me whakawahi anō kia tapu ai. ");
INSERT INTO mri2012_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","E whitu ngā rā e whakamārie ai koe mō te āta, hei whakatapu; ā, ka meinga hei āta tino tapu; ko ngā mea katoa e pā ana ki te āta, ka tapu.” ");
INSERT INTO mri2012_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ā, ko tēnei tāu e tuku ai ki runga ki te āta; e rua reme, he tau tahi me mea tonu tēnei i ngā rā katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ko tētahi reme me tuku i te ata, ko te rua o ngā reme me tuku i te ahiahi. ");
INSERT INTO mri2012_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ko te reme me te whakatekau o te parāoa, he mea kōnatunatu ki te hinu tuki, he whakawhā nō te hine, me te whakawhā o te hine wāina, hei ringihanga. ");
INSERT INTO mri2012_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ā, me tuku e koe tētahi reme i te ahiahi; kia rite tāu tukunga ki tō te whakahere totokore o te ata, me tōna ringihanga hoki, hei kakara reka, hei whakahere ahi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Hei tahunga tinana tēnei e mau tonu ana i ō koutou whakatupuranga, i te whatitoka o te tapenākara o te whakaminenga, i te aroaro o Ihowā, i te wāhi e tūtaki ai ahau ki a koutou, kōrero ai ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ā, ka tūtaki ahau ki reira ki ngā tama a Īharaira, ka tapu anō a reira i tōku korōria. ");
INSERT INTO mri2012_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Ka whakatapua anō e ahau te tapenākara o te whakaminenga me te āta; ka whakatapua anō a Ārona rātou ko āna tama, hei tohunga māku. ");
INSERT INTO mri2012_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ā, ka noho ahau ki waenganui i ngā tama a Īharaira, ā, hei Atua ahau mō rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ā, ka mōhio rātou ko Ihowā ahau, ko tō rātou Atua, i whakaputaia mai ai rātou i te whenua o Īhipa, kia noho ai ahau i waenganui i a rātou; ko Ihowā ahau, ko tō rātou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ā, me hanga e koe he āta hei tahunga mea kakara; ko te rākau e hangā ai he hitimi. ");
INSERT INTO mri2012_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kia kotahi whatīanga te roa, kia kotahi hoki whatīanga te whānui; kia tapawhā. Kia rua whatīanga te teitei; nō taua mea rā anō ngā haona. ");
INSERT INTO mri2012_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Me whakakikorua ki te kōura parakore a runga me ōna taha ā taka noa, me ōna haona hoki; me hanga anō te niao kōura ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Me hanga anō ētahi mōwhiti kōura mōna kia rua, mō raro i tōna niao, ki ōna koki e rua, me hanga ki ōna taha e rua, hei kuhunga mō ngā amo, hei amohanga. ");
INSERT INTO mri2012_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","He hitimi anō hoki te rākau e hangā ai e koe ngā amo, me whakakikorua ki te kōura. ");
INSERT INTO mri2012_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ka whakatū ai ki mua o te ārai, o tērā i te āka o te whakaaturanga, ki mua o te taupoki i runga o te whakaaturanga, o te wāhi e tūtaki ai ahau ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Ā, me tahu e Ārona he whakakakara reka ki runga, i tēnei ata, i tēnei ata; me tahu e ia te whakakakara ki runga, ina whakapaia e ia ngā rama. ");
INSERT INTO mri2012_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ā, ka tahuna e Ārona ngā rama i te ahiahi, me tahu he whakakakara ki runga i taua āta, he whakakakara e mau tonu ana ki te aroaro o Ihowā i ō koutou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kei whakaekea he whakakakara kē ki runga, he tahunga tinana rānei, he whakahere totokore rānei; kaua anō e ringihia he ringihanga ki runga. ");
INSERT INTO mri2012_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Nā, ka whakamārie a Ārona ki runga ki ōna haona, kia kotahi te meatanga i te tau. Ka whakamārie ia ki te toto o te whakahere hara o te whakamārie ki runga ki taua mea, kia kotahi te meatanga i te tau, puta noa i ō koutou whakatupuranga. He mea tapu rawa tēnā ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“E taua e koe ngā tāngata o ngā tama a Īharaira, arā ngā mea o rātou e taua ana, me hōmai e tērā, e tērā, he utu mō tōna wairua ki a Ihowā, ina taua rātou; kia kore ai he whiu i roto i a rātou ina taua. ");
INSERT INTO mri2012_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ko tēnei tā rātou e hōmai ai, ko ngā tāngata katoa e haere ana ki roto ki te hunga kua taua, hei te hāwhe o te hekere, o te hekere o te wāhi tapu (e rua tekau ngā kera kei roto i te hekere kotahi) hei te hāwhe hekere te whakahere ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ko ngā tāngata katoa e haere ana ki roto ki te hunga kua taua, ko ngā mea e rua tekau ō rātou tau, me ngā mea i maha atu, me hōmai e rātou he whakahere ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","E kore e maha ake a te tangata taonga, e kore anō hoki e torutoru iho i te hāwhe hekere a te rawakore, ina hōmai he whakahere ki a Ihowā, hei whakamārie mō ō koutou wairua. ");
INSERT INTO mri2012_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Nā, me tango e koe te moni whakamārie a ngā tama a Īharaira, ā, ka waiho mō ngā mahi o te tapenākara o te whakaminenga; ā, hei whakamahara tēnā ki ngā tama a Īharaira ki te aroaro o Ihowā, hei whakamārie mō ō koutou wairua.” ");
INSERT INTO mri2012_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Me hanga anō e koe he takotoranga wai ki te parāhi, ki te parāhi anō hoki tōna tūranga, hei horoinga. Ka whakatū ai ki te takiwā o te āta o te tapenākara o te whakaminenga, me riringi anō he wai ki roto; ");
INSERT INTO mri2012_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ā, me horoi ō rātou ringa me ō rātou waewae e Ārona rātou ko āna tama ki reira. ");
INSERT INTO mri2012_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ka haere rātou ki roto ki te tapenākara o te whakaminenga, me horoi rātou ki te wai, kei mate; ki te whakatata rānei rātou ki te āta ki te minita, ki te tahu i te whakahere ahi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Nā, ka horoi i ō rātou ringa, i ō rātou waewae, kei mate; ā, ka waiho hei tikanga pūmau mā rātou, māna, mā ōna uri, i ō rātou whakatupuranga.” ");
INSERT INTO mri2012_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Tīkina māu he tino mea kakara: he maira pai, kia rima rau hekere, he hinamona reka, me hāwhe tērā, arā, kia rua rau kia rima tekau hekere, me te karamuha reka, kia rua rau kia rima tekau hekere, ");
INSERT INTO mri2012_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","he kahia hoki, kia rima rau hekere – ki ngā hekere o te wāhi tapu – me te hinu ōriwa, kia kotahi hine; ");
INSERT INTO mri2012_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ā, me hanga e koe hei hinu mō te whakawahinga tapu, he hinu whakaranu, he mea kakara, ko tā te kaiwhakaranu e hanga ai; ka waiho hei hinu mō te whakawahinga tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ka whakawahia ai te tapenākara o te whakaminenga, me te āka hoki o te whakaaturanga, ");
INSERT INTO mri2012_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","me te tēpu, me ngā oko katoa i runga, me te tūranga rama, me ōna oko, me te āta whakakakara, ");
INSERT INTO mri2012_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","me te āta tahunga tinana, me ōna oko katoa, me te takotoranga wai, me tōna tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ā, me whakatapu kia tino tapu; ka tapu ngā mea katoa e pā ana ki aua mea. ");
INSERT INTO mri2012_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Me whakawahi anō e koe a Ārona rātou ko āna tama, me whakatapu hoki rātou hei tohunga māku. ");
INSERT INTO mri2012_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Me kōrero anō e koe ki ngā tama a Īharaira, me kī atu, ‘Hei hinu tēnei māku, mō te whakawahinga tapu i ō koutou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Kei ringihia ki te kikokiko tangata kei hangā anō tētahi mea pēnā, e rite ana ki tōna hanganga; he tapu tēnā, ā, ka tapu ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ki te whakaranua e te tangata tētahi mea pēnā; ki te makā rānei e ia ki runga ki te tangata kē, inā, ka hātepea atu ia i roto i tōna iwi.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","I mea anō a Ihowā ki a Mohi, “Tīkina māu he mea kakara, he takete, he oneka, he karapanuma; ēnei mea kakara me te parakihe parakore (kia rite te taimaha o tētahi, o tētahi), ");
INSERT INTO mri2012_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ka whakaranu ai hei mea kakara, ko tā te kaiwhakaranu e hanga ai, he mea rongoā ki te tote, he mea parakore, he mea tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Nā, ka tukia tētahi wāhi kia ririki rawa, ka whakatakoto ai i tētahi wāhi ki mua mai o te whakaaturanga i roto i te tapenākara o te whakaminenga, ki te wāhi e tūtaki ai ahau ki a koe; hei mea tino tapu tēnā ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ā, ko taua mea kakara ka hangā nei e koe, kei hangā tētahi mā koutou he rite te hanganga ki tō tērā; hei mea tapu tēnā ki a koe mā Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ki te hangā e te tangata he mea pēnā, hei honginga māna, ka hātepea atu ia i roto i tōna iwi.” ");
INSERT INTO mri2012_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Titiro, kua whakahuatia nei e ahau te ingoa o Petarēre, tama a Uri, ko ia nei he tama nā Huru, nō te iwi o Hūrā: ");
INSERT INTO mri2012_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","kua whakakīia anō ia e ahau ki te Wairua o te Atua, ki te ngākau tūpato, ki te whakaaro, ki te mōhio, ki ngā mahi katoa hoki, ");
INSERT INTO mri2012_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","hei whakaaro ki ngā mahi a te tohunga, hei mahi i te kōura, i te hiriwa, i te parāhi, ");
INSERT INTO mri2012_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","mō te whakairo kōhatu hoki, mō te whakanoho hoki, mō te whakairo rākau, mō te mahi anō hoki i ngā mahi katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","“Nā, tēnei anō te hoatu nei e ahau hei hoa mōna a Ahoriapa tama a Ahihamaka, nō te iwi o Rāna; kua whakanohoia anō e ahau he mahara ki ngā ngākau o te hunga ngākau mahara katoa, hei hanga i ngā mea katoa i whakahaua atu nei e ahau ki a koe: ");
INSERT INTO mri2012_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","i te tapenākara o te whakaminenga, i te āka o te whakaaturanga, i tōna taupoki, i ngā mea katoa o te tapenākara, ");
INSERT INTO mri2012_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","i te tēpu, i ōna mea, i te tūranga parakore o ngā rama, i ōna mea katoa, i te āta mō te whakakakara, ");
INSERT INTO mri2012_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","i te āta mō te tahunga tinana, i ōna mea katoa, i te takotoranga wai rāua ko tōna tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","I ngā kākahu mō te mahi minita, i ngā kākahu tapu mō Ārona, mō te tohunga, i ngā kākahu mō āna tama, mō te mahi tohunga, ");
INSERT INTO mri2012_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","i te hinu whakawahi, i te whakakakara reka mō te wāhi tapu. Kia rite tā rātou e mea ai ki ngā mea katoa i whakahaua atu e ahau ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Kōrero anō ki ngā tama a Īharaira, mea atu: Me whakarite anō e koutou āku hāpati; hei tohu hoki ki waenganui ōku, o koutou, i ō koutou whakatupuranga; kia mōhio ai ko ahau, ko Ihowā, te whakatapu nei i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Nā, me whakarite te hāpati; he tapu hoki tēnā ki a koutou; he mate kau mō te tangata e whakanoa ana i taua rā. Ko te tangata hoki e mahi ana i tētahi mahi i reira, inā, ka hātepea atu taua wairua i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","E ono ngā rā e mahia ai te mahi; kei te whitu ia o ngā rā te hāpati okiokinga, he tapu ki a Ihowā; ko te tangata e mahi ana i tētahi mahi i te rā hāpati he mate kau mōna. ");
INSERT INTO mri2012_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Mō reira me mahara ngā tama a Īharaira ki te hāpati, kia whakaritea te hāpati i ō rātou whakatupuranga; kia mau tonu tēnei kawenata. ");
INSERT INTO mri2012_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","He tohu tēnā rā ki waenganui ōku, o ngā tama a Īharaira, ake ake; e ono hoki ngā rā i hangā ai e Ihowā te rangi me te whenua, ā, i te whitu o ngā rā ka okioki, ā, tā ana tōna manawa.” ");
INSERT INTO mri2012_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","I hōmai anō e ia ki a Mohi, i te mutunga o tāna kōrero ki a ia i runga i Maunga Hinai, e rua ngā papa whakaaturanga, he papa kōhatu, he mea tuhituhi nā te ringa o te Atua. ");
INSERT INTO mri2012_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ā, nō te kitenga o te iwi i roa te hekenga iho o Mohi i runga i te maunga, ka huihui te iwi ki a Ārona, ka mea ki a ia, “Whakatika, hangā ētahi atua mō tātou, hei haere i mua i a tātou; ko tēnei Mohi hoki, ko te tangata nāna tātou i kawe mai ki runga nei i te whenua o Īhipa, kāhore tātou e mōhio kua ahatia rānei ia.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Nā, ka mea a Ārona ki a rātou, “Whakia mai ngā whakakai kōura i ngā taringa o ā koutou wāhine, o ā koutou tama, o ā koutou tamāhine, ka kawe mai ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Nā, whakia ana e te iwi katoa ngā whakakai kōura i ō rātou taringa, ā, kawea ana mai ki a Ārona. ");
INSERT INTO mri2012_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Nā, ka tangohia e ia i ō rātou ringa, ā, whakaahuatia ana e ia ki te purupuru tāna kūao kau i whakarewa ai. Nā, ka mea rātou, “Ko ōu atua ēnei, e Īharaira, nāna nei koe i kawe mai ki runga nei i te whenua o Īhipa!” ");
INSERT INTO mri2012_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ā, nō te kitenga o Ārona, hangā ana e ia tētahi āta ki mua i taua mea; ā, ka karanga a Ārona, ka mea, “Ko āpōpō, he hākari ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nā, ka maranga wawe rātou i te aonga ake, ā, whakaekea ana he tahunga tinana, i kawea anō he whakahere mō te pai; nā, ka noho te iwi ki te kai, ki te inu, ā, ka whakatika ki te tākaro. ");
INSERT INTO mri2012_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Nā, ka mea a Ihowā ki a Mohi, “Haere, heke atu, kua hē hoki tōu iwi i kawea mai nei e koe i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kua hohoro rātou te peka kē i te huarahi i kīia e ahau ki a rātou; kua hangā mā rātou he kūao kau, he mea whakarewa, kua koropiko ki taua mea, kua patu whakahere māna, ā, e mea ana, ‘Ko ōu atua ēnei, e Īharaira, i kawea mai ai koe i te whenua o Īhipa.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","I mea anō a Ihowā ki a Mohi, “Kua kite ahau i tēnei iwi, nā, he iwi kakī mārō rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Nā, tukua atu ahau, ā, ka mura tōku riri ki a rātou, ā, ka pau rātou i ahau; ka hangā anō koe hei iwi nui.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nā, ka īnoi a Mohi ki a Ihowā, ki tōna Atua, ka mea, “He aha tōu riri i mura ai, e Ihowā, ki tāu iwi i kawea mai nei e koe i te whenua o Īhipa i runga i te kaha nui, i te ringa mārō? ");
INSERT INTO mri2012_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ha, kia kōrero ngā Īhipiana, kia mea, ‘He whakaputanga atu ki te hē tāna i a rātou, kia whakamatea ai rātou ki ngā maunga, kia whakangaromia atu ai i te mata o te whenua’? Tahuri i tōu riri nui e mura nei, kia puta kē hoki tōu whakaaro ki tēnei kino mō tāu iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kia mahara ki āu pononga, ki a Āperahama, ki a Īhaka, ki a Īharaira, ki tāu oatitanga hoki i a koe ki a rātou, ki tāu meatanga ki a rātou, ‘Ka whakanuia e ahau ō koutou uri kia rite ki ngā whetū o te rangi; ko tēnei whenua katoa hoki i kōrerotia atu nei e ahau, ka hoatu e ahau ki ō koutou uri, ā, ka nohoia e rātou ake ake.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Nā, ka puta kē tā Ihowā i whakaaro ai mō te kino i kīia e ia kia meatia ki tāna iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Nā, ka tahuri a Mohi, ka heke iho i te maunga, me ngā papa e rua o te whakaaturanga i tōna ringa; he mea tuhi ngā taha e rua o ngā papa; i tētahi taha, i tētahi taha te tuhi. ");
INSERT INTO mri2012_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","He mea mahi hoki nā te Atua aua papa, me te tuhituhi hoki, nā te Atua te tuhituhi, he mea whaowhao ki ngā papa. ");
INSERT INTO mri2012_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ā, ka rongo a Hohua i te reo o te iwi e hāmama ana, ka mea ki a Mohi, “He ngē whawhai kei te puni rā.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Nā, ka mea ia: “Ehara tērā reo i te hāmama mō te hinganga o te taua, ehara hoki tērā reo i te hāmama o te hunga e hinga ana; he reo waiata tāku e rongo nei.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ā, ka tata ia ki te puni, nā, ka kite ia i te kūao kau, i te kanikani. Nā, ka mura te riri o Mohi, ā, ka makā atu e ia ngā papa i roto i ōna ringa, ā, pākarua ana aua mea e ia i raro i te maunga. ");
INSERT INTO mri2012_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Nā, ka tango ia i te kūao kau i hangā e rātou, ā, tahuna ana e ia ki te ahi, ā, hurihia ana, ā, ngotangota noa, ā, ruiruia ana e ia ki te wai, whakainumia atu ana mā ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Nā, ka mea a Mohi ki a Ārona, “I aha tēnei iwi ki a koe, i tākina ai e koe tēnei hara nui ki a rātou?” ");
INSERT INTO mri2012_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ā, ka mea a Ārona, “Kei mura mai te riri o tōku ariki; e mōhio ana koe ki tēnei iwi, mō te kino tonu rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","I mea hoki rātou ki ahau, ‘Hangā ētahi atua mō tātou hei haere i mua i a tātou; ko tēnei Mohi hoki, ko te tangata nāna nei tātou i kawe mai i te whenua o Īhipa, kāhore tātou e mōhio kua ahatia rānei ia.’ ");
INSERT INTO mri2012_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nā, ka mea ahau ki a rātou, ‘Ki te mea he kōura tō tētahi, whakia mai.’ Nā, ka hōmai e rātou ki ahau; ā, makā ana e ahau ki te ahi; ā, puta ake ko te kūao kau nei.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ā, i te kitenga o Mohi i te iwi e korara noa ana, (nā Ārona hoki rātou i tuku kia korara, hei taunu mā ō rātou hoariri). ");
INSERT INTO mri2012_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Nā, ka tū a Mohi ki te kūwaha o te puni, ka mea, “Ko wai tō Ihowā haere mai ki ahau?” Nā, ka huihui ngā tama katoa a Rīwai ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Nā, ka mea ia ki a rātou, “Ko te kupu tēnei a Ihowā, a te Atua o Īharaira, ‘Whakanohoia e tērā, e tērā tāna hoari ki tōna hūhā, ā, haere atu, hoki mai, i tētahi kūwaha ki tētahi kūwaha, i waenga puni, ā, patua e tērā tōna teina, e tērā tōna hoa, e tērā tōna hoa e noho tata ana.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Nā, rite tonu ki te kupu a Mohi tā ngā tama a Rīwai i mea ai; ā, tata tonu ki te toru mano ngā tāngata i hinga i taua rangi. ");
INSERT INTO mri2012_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Nā Mohi hoki i mea, “Hei runga i tāna tama, i tōna teina, te whakatohungatanga ki a Ihowā o tērā, o tērā, o koutou āianei; kia hōmai ai e ia he manaaki ki a koutou āianei.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nā, i te aonga ake, ka mea a Mohi ki te iwi, “Kua hara koutou, he nui te hara. Nā, me haere ahau āianei ki runga, ki a Ihowā; tērā pea e taea e ahau te whakamārie mō tō koutou hara.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Nā, ka hoki a Mohi ki a Ihowā, ka mea, “Auē! Kua hara tēnei iwi, he nui te hara, kua hangā hoki e rātou ētahi atua kōura mō rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nā, māu e horoi tō rātou hara; ā, ki te kāhore, tēnā rā, horoia atu ahau i roto i tāu pukapuka i tuhituhia e koe.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nā, ka mea a Ihowā ki a Mohi, “Ko te tangata e hara ana ki ahau, ka horoia atu ia e ahau i roto i tāku pukapuka. ");
INSERT INTO mri2012_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Nā, haere rā, ārahina atu te iwi ki te wāhi i kōrerotia atu e ahau ki a koe, tēnā tāku anahera te haere atu nā i mua i a koe. Ahakoa rā, ko ā te rā e mea ai ahau, inā, ka meinga e ahau tō rātou hara kia tau ki runga ki a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Nā, ka whiua e Ihowā te iwi mō tā rātou hanganga i te kūao kau, i hangā nei e Ārona. ");
INSERT INTO mri2012_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Nā, ka mea a Ihowā ki a Mohi, “Haere, tūria atu ki runga, koutou ko te iwi i kawea mai nei e koe i te whenua o Īhipa, ki te whenua i oati ai ahau ki a Āperahama, ki a Īhaka, ki a Hākopa, i mea ia, ‘Ka hoatu e ahau ki ōu uri.’ ");
INSERT INTO mri2012_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ā, ka ungā he anahera e ahau ki mua i a koe, māku anō hoki e pei ngā Kanaani, ngā Amori, ngā Hiti, ngā Perihi, ngā Hiwi, me, ngā Iepuhi. ");
INSERT INTO mri2012_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ki te whenua e rerengia ana e te waiū, e te honi; e kore hoki ahau e haere atu i roto i a koe; he iwi kakī mārō hoki koe; kei pau koe i ahau ki te ara.” ");
INSERT INTO mri2012_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ā, i te rongonga o te iwi i tēnei rongo kino, ka pōuri, kīhai anō i whakanohoia e tētahi ōna whakapaipai. ");
INSERT INTO mri2012_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ā, i kī atu a Ihowā ki a Mohi, “Mea atu ki ngā tama a Īharaira, ‘He iwi kakī mārō koutou. Kia mea kau ka puta atu ahau ki waenganui i a koe, ā, ka ngaro koe i ahau. Nā, whakarērea atu ōu whakapaipai, ā, ka mōhio ahau ki tāku e mea ai ki a koe.’ ” ");
INSERT INTO mri2012_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Nā, i aurutia e ngā tama a Īharaira ō rātou whakapaipai i Maunga Horepa ahu atu. ");
INSERT INTO mri2012_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Nā, tango ai a Mohi i te tapenākara ka whakatū ki waho o te puni ki tētahi wāhi mamao atu i te puni, ā, huaina ana e ia, “Ko te tapenākara o te whakaminenga”. Ā, i haere ngā tāngata katoa e rapu ana i a Ihowā, ki te tapenākara o te whakaminenga, ki waho o te puni. ");
INSERT INTO mri2012_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ā, i a Mohi e haere ana ki te tapenākara ka whakatika te iwi katoa, ā, ka tū tērā, tērā, i te kūwaha o tōna tēneti, ā, ka titiro ki muri i a Mohi, ā haere noa ia ki roto ki te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ā, i a Mohi e haere ana ki roto ki te tapenākara, ka heke iho te pou kapua, ā, tū ana i te whatitoka o te tapenākara, ā, ka kōrero a Ihowā ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ā, ko te kitenga o te iwi katoa i te pou kapua e tū ana i te whatitoka o te tapenākara, nā, ka whakatika te iwi katoa, ka koropiko hoki ia tangata, ia tangata, i te whatitoka o tōna tēneti. ");
INSERT INTO mri2012_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Nā, ka kōrero a Ihowā ki a Mohi, he kanohi, he kanohi, pērā hoki me te tangata e kōrero nei ki tōna hoa. Ā, hoki ana ia ki te puni; ko tāna tangata ia, ko Hohua, tama a Nunu, kīhai taua taitamariki i neke atu i roto i te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ā, i mea a Mohi ki a Ihowā, “Titiro, kua mea mai nei koe ki ahau, ‘Kawea tēnei iwi ki runga’; ā, kāhore i whakaaturia mai e koe ki ahau tāu e ungā ai hei hoa mōku. Kua mea mai anō koe ki ahau, ‘E mōhio ana ahau ki a koe, ki tōu ingoa hoki, kua manakohia anō koe e ahau.’ ");
INSERT INTO mri2012_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nā, ki te mea kua manakohia ahau e koe, tēnā, whakaaturia mai ki ahau ōu ara, kia mōhio ai ahau ki a koe, kia manakohia ai ahau e koe; kia mahara hoki he iwi nāu tēnei iwi.” ");
INSERT INTO mri2012_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nā, ka mea ia, “Ka haere atu tōku aroaro, ā, ka mea ahau i a koe kia okioki.” ");
INSERT INTO mri2012_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Nā, ka mea ia ki a ia, “Ki te kāhore tōu aroaro e haere, kaua mātou e kawea ki runga i konei. ");
INSERT INTO mri2012_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mā te aha hoki e mōhiotia ai kua manakohia mātou ko tāu iwi e koe? He teka ianei māu kia haere tahi i a mātou? Pēnei ka motuhia mātou ko tāu iwi i ngā iwi katoa i te mata o te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Nā, ka mea a Ihowā ki a Mohi, “Ko tēnei mea anō i kōrerotia mai nā e koe, ka rite i ahau; nō te mea e manakohia ana koe e ahau, ā, e mōhio ana ahau ki a koe, ki tōu ingoa hoki.” ");
INSERT INTO mri2012_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Nā, ka mea ia, “Tēnā rā, whakakitea mai ki ahau tōu korōria.” ");
INSERT INTO mri2012_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nā, ka mea ia, “Ka meatia e ahau tōku pai katoa kia haere atu i tōu aroaro, ā, ka karangatia e ahau te ingoa o Ihowā i tōu aroaro, ka atawhai hoki ahau i tāku e atawhai ai, ka tohu hoki i tāku e tohu ai.” ");
INSERT INTO mri2012_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","I mea anō ia, “E kore e taea e koe te titiro ki tōku mata; e kore hoki tētahi tangata e titiro ki ahau, ā, e ora.” ");
INSERT INTO mri2012_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","I mea anō a Ihowā, “Nanā, he wāhi tēnei kei ahau, ā, me tū koe ki runga ki te kāmaka; ");
INSERT INTO mri2012_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ā, ka haere atu tōku korōria, nā, ka kawea koe e ahau ki roto ki te kapiti kōhatu, ā, ka taupokina koe e ahau ki tōku ringa, i ahau e haere atu ana. ");
INSERT INTO mri2012_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ā, ka tangohia e ahau tōku ringa, ā, ka kite koe i muri ōku; ko tōku mata ia e kore e kitea.” ");
INSERT INTO mri2012_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Nā, ka mea a Ihowā ki a Mohi, “Tāraia māu ētahi papa kōhatu, kia rua, kia rite ki ō mua; ā, ka tuhituhia e ahau ki aua papa ngā kupu i mau ki ō mua papa, i wāhia nā e koe. ");
INSERT INTO mri2012_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ā, kia takatū i te ata, ka haere ake i te ata ki Maunga Hinai, ā, me tū koe i tōku aroaro, ki reira, ki te tihi o te maunga. ");
INSERT INTO mri2012_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kaua hoki tētahi e haere ake i a koe, kei kitea hoki tētahi i te maunga katoa; ko ngā hipi hoki, me ngā kau, kaua e kai ki te ritenga o taua maunga.” ");
INSERT INTO mri2012_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Nā, tāraia ana e ia ētahi papa kōhatu e rua, rite tonu ki ō mua; ā, ka maranga wawe a Mohi i te ata, ka piki atu ki Maunga Hinai, ka pērā anō me tā Ihowā i whakahau ai ki a ia, me te mau anō i ngā papa kōhatu e rua ki tōna ringa. ");
INSERT INTO mri2012_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nā, ka heke iho a Ihowā i roto i te kapua, ka tū tahi me ia ki reira, ā, ka karangatia te ingoa o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Nā, ka haere atu a Ihowā i tōna aroaro, ā, ka karangatia, “Ko Ihowā, ko Ihowā ko te Atua tohu, atawhai, he tukuroa nei i te riri, he nui nei te aroha, te pono, ");
INSERT INTO mri2012_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","e rongoā nei i te aroha mō ngā mano, e muru nei i te kino, i te tutū, i te hara, e kore rawa anō hoki e tuku noa i te hē; e mea nei i te hara o ngā mātua kia tau iho ki ngā tamariki, ki ngā tamariki a ngā tamariki ā te toru, te whā rā anō o ngā whakatupuranga.” ");
INSERT INTO mri2012_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Nā, ka hohoro a Mohi, ka tuohu iho ki te whenua, koropiko ana; ");
INSERT INTO mri2012_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ā, ka mea, “Ki te mea kua manakohia mai ahau e koe, e te Ariki, kia haere rā tōku Ariki i waenganui i a mātou; he iwi kakī mārō hoki tēnei; murua atu hoki tō mātou kino, me tō mātou hara, waiho hoki mātou hei taonga tupu mōu.” ");
INSERT INTO mri2012_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nā, ka mea ia: “Nanā, ka whakarite kawenata ahau. Ka meatia e ahau he mea whakamīharo ki te aroaro o tōu iwi katoa, he mea kīhai i meatia i te whenua katoa, i ngā iwi katoa anō hoki; ā, ka kitea te mahi a Ihowā e te iwi katoa kei roto nei koe i a rātou. He mea whakamataku hoki tāku e mahi tahi ai ahau me koe. ");
INSERT INTO mri2012_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Kia mau ki tāku e whakahau atu nei ki a koe ināianei. Nanā, ka peia atu e ahau ngā Amori, ngā Kanaani, ngā Hiti, ngā Perihi, ngā Hiwi, ngā Iepuhi. ");
INSERT INTO mri2012_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kia tūpato kei whakarite kawenata koe ki ngā tāngata o te whenua e haere nei koe ki reira; kei waiho hei rore i waenganui i a koe. ");
INSERT INTO mri2012_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Engari, me wāwāhi ā rātou āta, me pākarukaru ā rātou whakapakoko, me tua hoki ā rātou Aherimi. ");
INSERT INTO mri2012_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","(Kāhore atu hoki he hei atua koropikotanga māu, ko Ihowā hoki ko Hae nei tōna ingoa, he Atua hae ia). ");
INSERT INTO mri2012_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Kei whakarite kawenata koe ki ngā tāngata o te whenua, ā, ka whai atu rātou, ka pūremu atu ki ō rātou atua, ā, ka patu whakahere mā ō rātou atua, ā, ka karangatia koe e tētahi, nā, ka kai koe i tāna patunga tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ā, ka tango koe i ā rātou tamāhine mā āu tama, ā, ka whai atu, ka pūremu atu ā rātou tamāhine ki ō rātou atua, ā, ka meinga āu tamariki kia whai atu, kia pūremu atu ki ō rātou atua. ");
INSERT INTO mri2012_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Kaua e whakarewaina he atua mōu. ");
INSERT INTO mri2012_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Kia mau ki te Hākari Taro Rēwenakore. E whitu ngā rā e kai ai koe i te taro rēwenakore, e pērā ai me tāku i whakahau ai ki a koe, i te wā anō i whakaritea o te marama, o Apipi; ko Apipi hoki te marama i haere mai ai koe i Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Ko ngā mea katoa e puta tuatahi mai ana i te kōpū, nāku; me ngā mātāmua a āu kararehe, a ngā kau, a ngā hipi. ");
INSERT INTO mri2012_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","“Ā, me utu e koe ki te reme te mātāmua a te kāihe; ā, ki te kāhore utua e koe, whatia tōna kakī. Me utu e koe ngā mātāmua o āu tama. “E kore anō hoki tētahi e puta kau mai ki tōku aroaro. ");
INSERT INTO mri2012_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“E ono ngā rā e mahi ai koe, i te whitu ia o ngā rā me okioki; me okioki anō koe i te ruinga, i te kotinga. ");
INSERT INTO mri2012_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Me mahi anō te Hākari o Ngā Wiki, arā o ngā mātāmua o te kotinga wīti, me te Hākari o te Kohikohinga i te takanga o te tau. ");
INSERT INTO mri2012_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","E toru ngā wā o te tau e kitea ai ōu tāne katoa ki te aroaro o te Ariki, o Ihowā, o te Atua o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ka peia hoki e ahau ngā tauiwi i tōu aroaro, ka whakanuia anō ōu rohe; ā, e kore tētahi e minamina ki tōu whenua, ina haere koe ki runga kia kitea ki te aroaro o Ihowā, o tōu Atua, i ngā wā e toru o te tau. ");
INSERT INTO mri2012_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Kaua he rēwena ina whakahekea te toto o tāku patunga tapu; kei toe anō hoki ki te ata te patunga tapu o te Hākari o te Kapenga. ");
INSERT INTO mri2012_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Me kawe ki te whare o Ihowā, o tōu Atua, ngā mea mataati o ngā mātāmua o tōu oneone. “Kaua e kōhuatia te kūao koati ki te waiū o tōna whaea.” ");
INSERT INTO mri2012_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Nā, ka mea a Ihowā ki a Mohi, “Tuhituhia ēnei kupu; kei ēnei kupu hoki te tikanga o te kawenata e whakaritea nei e ahau ki a koe, ki a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Nā, i reira ia i a Ihowā e whā tekau ngā rā, e whā tekau ngā pō; kīhai i kai taro, kīhai anō i inu wai. Nā, tuhituhia ana e ia ki ngā papa ngā kupu o te kawenata, ngā ture kotahi tekau.” ");
INSERT INTO mri2012_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ā, i te hekenga iho o Mohi i runga i Maunga Hinai me ngā papa e rua o te whakaaturanga i te ringa o Mohi, i tōna hekenga iho i runga i te maunga, nā, kīhai a Mohi i mōhio e tīaho ana te kiri o tōna mata, nōna i kōrero ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ā, i te tirohanga a Ārona rātou ko ngā tama katoa a Īharaira ki a Mohi, nā, e tīaho ana te kiri o tōna mata; nā, ka wehi rātou ki te whakatata ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Nā, ka karanga a Mohi ki a rātou; ā, ka hoki ki a ia a Ārona rātou ko ngā rangatira katoa o te whakaminenga; ā, ka kōrero a Mohi ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ā muri iho ka whakatata ngā tama katoa a Īharaira, ā, ka whakahaua iho e ia ki a rātou ngā mea katoa i kōrerotia e Ihowā ki a ia i Maunga Hinai. ");
INSERT INTO mri2012_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ā, ka mutu tā Mohi kōrero ki a rātou, ka makā ki tōna mata he ārai. ");
INSERT INTO mri2012_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Otiia, ka haere a Mohi ki te aroaro o Ihowā, ki te kōrero ki a ia, ka tangohia e ia te ārai ā puta noa mai ki waho, ā, ko tōna putanga mai ki waho, ka kōrerotia e ia ki ngā tama a Īharaira ngā mea i whakahaua ki a ia; ");
INSERT INTO mri2012_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ā, i kite ngā tama a Īharaira i te mata o Mohi, e tīaho ana te kiri o te mata o Mohi. Nā, ka whakahokia e Mohi te ārai ki tōna mata ā haere noa ia ki te kōrero ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Nā, ka huihuia e Mohi te whakaminenga katoa o ngā tama a Īharaira, ā, ka mea ia ki a rātou, “Ko ngā kupu ēnei i whakahaua mai e Ihowā kia mahia: ");
INSERT INTO mri2012_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","E ono ngā rā e mahia ai te mahi; ko te rā whitu ia me waiho hei rā tapu, hei hāpati okiokinga ki a Ihowā; ki te mahia he mahi e tētahi tangata i taua rā, me whakamate. ");
INSERT INTO mri2012_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kei tahuna he ahi, puta noa i ō koutou nohoanga, i te rā hāpati.” ");
INSERT INTO mri2012_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","I kōrero anō a Mohi ki te whakaminenga katoa o ngā tama a Īharaira, i mea: Ko te mea tēnei i whakahau mai ai a Ihowā, i mea ai: ");
INSERT INTO mri2012_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Tangohia i roto i a koutou he whakahere mā Ihowā; ko ngā tāngata katoa he ngākau hihiko ō rātou, me kawe mai e rātou taua mea hei whakahere ki a Ihowā: he kōura, he hiriwa, he parāhi, ");
INSERT INTO mri2012_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","he purū, he pāpura, he ngangana, he rīnena pai, he huruhuru koati, ");
INSERT INTO mri2012_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","me ngā hiako hipi kua oti te whakawhero, me ngā hiako pateri, me ētahi rākau, hei te hitimi, ");
INSERT INTO mri2012_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","me te hinu mō te whakamārama, me ngā mea kakara mō te hinu whakawahi, mō te whakakakara reka hoki, ");
INSERT INTO mri2012_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","me ngā kōhatu onika, me ngā kōhatu hei whakanoho ki te epora, ki te kōuma. ");
INSERT INTO mri2012_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Me haere mai anō ngā tāngata ngākau mōhio katoa i roto i a koutou, ki te hanga i ngā mea katoa i whakahaua mai e Ihowā; ");
INSERT INTO mri2012_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","i te tapenākara, i tōna tēneti, i tōna uhi hoki, i ōna toromoka, i ōna papa, i ōna kaho, i ōna pou, i ōna tūranga pou, ");
INSERT INTO mri2012_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","i te āka, me ōna amo, i te taupoki, me te ārai hīpoki, ");
INSERT INTO mri2012_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","i te tēpu, me ōna amo, me ōna oko katoa, me te taro aroaro, ");
INSERT INTO mri2012_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","i te tūranga rama hoki mō te whakamārama me ōna mea, me ōna rama, me te hinu hoki mō te whakamārama, ");
INSERT INTO mri2012_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","me te āta whakakakara, me ōna amo, me te hinu whakawahi, me te whakakakara reka, me te pā mō te whatitoka i te tomokanga atu o te tapenākara, ");
INSERT INTO mri2012_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","i te āta mō te tahunga tinana, me tōna pae kupenga parāhi, i ōna amo me ōna mea katoa, i te takotoranga wai me tōna tūranga, ");
INSERT INTO mri2012_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","i ngā pā o te marae, i ōna pou, me ngā tūranga pou, me te pā mō te whatitoka o te marae, ");
INSERT INTO mri2012_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","i ngā titi o te tapenākara, me ngā titi o te marae, me ngā aho, ");
INSERT INTO mri2012_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","i ngā kākahu mō te mahi minita ina minita ki te wāhi tapu, i ngā kākahu tapu mō Ārona, mō te tohunga, me ngā kākahu mō āna tama, mō te mahi tohunga.” ");
INSERT INTO mri2012_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kātahi ka haere atu te whakaminenga katoa o ngā tama a Īharaira i te aroaro o Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Nā, ka haere rātou, ngā tāngata i toko ake ō rātou ngākau me ngā tāngata i hihiko noa ake ō rātou wairua, me te kawe anō i te whakahere mā Ihowā, mō te mahi o te tapenākara o te whakaminenga, mō ōna mahi katoa, mō ngā kākahu tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","I haere hoki rātou, ngā tāne, ngā wāhine, ngā mea i hihiko noa te ngākau, ā, kawea ana e rātou ngā poroporo, ngā whakakai, ngā mōwhiti, ngā heitiki, he mea kōura katoa; i tukua anō hoki e tērā, e tērā, he whakahere kōura ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ā, ko ngā tāngata katoa i kitea nei he purū ki a rātou, he pāpura, he ngangana, he rīnena pai, he huruhuru koati, he hiako hipi kua oti te whakawhero, he hiako pateri, i kawea mai e rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ko ngā tāngata katoa i whakahere nei i te hiriwa, i te parāhi, i kawea mai e rātou te whakahere ki a Ihowā; me ngā tāngata katoa i kitea nei he rākau hitimi ki a rātou mō tētahi meatanga o te mahi, i kawea mai anō e rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Me ngā wāhine ngākau mōhio katoa, i whatu ō rātou ringa, ā, kawea mai ana tā rātou i whatu ai, te purū, te pāpura, te ngangana, te rīnena pai. ");
INSERT INTO mri2012_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ā, i whatu anō ngā wāhine katoa, i toko ake nei ō rātou ngākau ki te mōhio, i te huruhuru koati. ");
INSERT INTO mri2012_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","I kawea mai anō e ngā rangatira ngā kōhatu onika, me ngā kōhatu hei whakanoho, mō te epora, mō te kōuma; ");
INSERT INTO mri2012_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","me te mea kakara, me te hinu mō te whakamārama, mō te hinu whakawahi, mō te whakakakara reka. ");
INSERT INTO mri2012_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","I kawea mai he whakahere tuku noa ki a Ihowā e ngā tama a Īharaira, e ngā tāne, e ngā wāhine katoa, i toko ake nei ō rātou ngākau ki te kawe mai, mō ngā tini mahi i whakahaua e Ihowā kia mahia, ā, i kōrerotia e Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Nā, ka mea a Mohi ki ngā tama a Īharaira: “Titiro, kua karangatia e Ihowā te ingoa o Petarēre tama a Uri, tama a Huru, o te iwi o Hūrā; ");
INSERT INTO mri2012_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","kua whakakīia anō hoki e ia ki te Wairua o te Atua, ki te ngākau tūpato, ki te whakaaro, ki te mōhio, ki ngā mahi katoa anō hoki, ");
INSERT INTO mri2012_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","hei whakaaro ki ngā mahi a te tohunga, mō te mahi i te kōura, i te hiriwa, i te parāhi, ");
INSERT INTO mri2012_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","mō te tuhi kōhatu, mō te whakanoho, mō te whakairo rākau, mō te mahi i ngā mahi katoa a te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Kua hōmai anō te ako ki tōna ngākau, ki a rāua ko Ahoriapa, tama a Ahihamaka, o te iwi o Rāna. ");
INSERT INTO mri2012_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Kua whakakīia rāua e ia ki te ngākau mahara, hei mahi i ngā tini mahi, a te kaituhi, a te mea mōhio, a te kaiwhakairo purū, pāpura, ngangana, rīnena pai, a te kaiwhatu hoki, a ngā kaimahi i ngā tini mahi, a ngā tohunga ki te mahi.” ");
INSERT INTO mri2012_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Nā, ka mahi a Petarēre rāua ko Ahoriapa, rātou ko ngā tāngata ngākau mōhio katoa, i hōmai nei e Ihowā he ngākau tūpato ki a rātou me te whakaaro e mōhiotia ai te mahi i ngā tini mahi, o ngā mea o te wāhi tapu, o te pērā me ngā mea katoa i whakahaua e Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ā, i karangatia e Mohi a Petarēre rāua ko Ahoriapa, me ngā tāngata ngākau mōhio katoa; i hōmai nei e Ihowā he mahara ki ō rātou ngākau, ngā tāngata katoa i toko ake ō rātou ngākau kia haere ki te mahi, mahi ai. ");
INSERT INTO mri2012_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Nā, ka tangohia e rātou i te aroaro o Mohi ngā whakahere katoa i kawea e ngā tama a Īharaira hei hanga i ngā mea mō te wāhi tapu, kia oti. I kawea anō e rātou he whakahere hōmai noa ki a ia i tēnei ata, i tēnei ata. ");
INSERT INTO mri2012_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Nā, ka haere mai ngā tāngata mōhio katoa, ngā kaimahi o ngā mea katoa o te wāhi tapu, tērā, tērā, i tāna mahi i mahi ai; ");
INSERT INTO mri2012_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ā, ka kōrero ki a Mohi, ka mea, “He nui noa atu tā te iwi e kawe mai nei mō te mahinga o ngā mea i whakahaua e Ihowā kia meatia.” ");
INSERT INTO mri2012_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Nā, ka whakahau a Mohi, ā, ka pā te karanga i te puni, ka mea: “Kaua tētahi tāne, wahine rānei e mahi i tētahi atu, mahi hei whakahere mō te wāhi tapu.” Nā, ka whakamutua te kawe mai a te iwi. ");
INSERT INTO mri2012_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","He nui hoki, ā, toe ake, ngā mea i a rātou mō te mahinga o ngā mea katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Nā ngā tāngata ngākau mōhio katoa o ngā kaimahi i hanga te tapenākara ki ngā pīhi kotahi tekau, ki te rīnena miro pai, ki te purū, ki te pāpura, ki te ngangana. He tohunga rawa te mahinga o ngā kerupima i whatua ki roto. ");
INSERT INTO mri2012_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","E rua tekau mā waru whatīanga te roa o te pīhi kotahi, e whā whatīanga te whānui o te pīhi kotahi; rite tonu te nui o ngā pīhi katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","I honoa e ia ngā pīhi e rima tētahi ki tētahi; me ērā atu pīhi e rima hoki, i honoa e ia tētahi ki tētahi. ");
INSERT INTO mri2012_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ā, i hangā anō e ia ētahi koropiko purū ki te taha o tētahi pīhi, ki te taha e honoa ana. I pērā anō tāna mahi ki te taha ki waho o tētahi pīhi, ki te hononga mai o te rua. ");
INSERT INTO mri2012_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","E rima tekau ngā koropiko i hangā e ia ki tētahi pīhi, e rima tekau hoki ngā koropiko i hangā e ia ki te taha o te pīhi i te hononga mai o te rua; ā, i mau ngā koropiko tētahi ki tētahi. ");
INSERT INTO mri2012_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","I hangā anō hoki e ia ētahi toromoka kōura e rima tekau, ā, honoa ana ngā pīhi tētahi ki tētahi ki ngā toromoka; ā, ka kotahi anō te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","I hangā anō e ia ētahi pīhi ki te huruhuru koati, hei tēneti mō runga i te tapenākara; kotahi tekau mā tahi ngā pīhi i hangā e ia. ");
INSERT INTO mri2012_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","E toru tekau whatīanga te roa o te pīhi kotahi, e whā hoki ngā whatīanga te whānui o te pīhi kotahi, rite tonu te nui o ngā pīhi kotahi tekau mā tahi. ");
INSERT INTO mri2012_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ā, i honoa e ia ngā pīhi e rima ki a rātou anō, me ngā pīhi e ono ki a rātou anō. ");
INSERT INTO mri2012_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","I hangā anō e ia ngā koropiko e rima tekau ki te tapa ki waho o te pīhi i te hononga, i hangā anō e ia ngā koropiko e rima tekau ki te tapa o te pīhi e honoa mai ai te rua. ");
INSERT INTO mri2012_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","I hangā anō e ia ngā toromoka parāhi e rima tekau, hei hono i te tēneti kia kotahi. ");
INSERT INTO mri2012_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","I hangā anō hoki e ia ētahi hiako hipi he mea whakawhero, hei uhi mō te tēneti, me ētahi hiako pateri hei uhi mō waho atu. ");
INSERT INTO mri2012_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","I hangā anō hoki e ia ētahi papa mō te tapenākara, he hitimi te rākau, he mea tū ki runga. ");
INSERT INTO mri2012_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kotahi tekau whatīanga te roa o te papa kotahi, kotahi whatīanga me te hāwhe te whānui o te papa kotahi. ");
INSERT INTO mri2012_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","E rua ngā arero o te papa kotahi, he mea hono ki a rāua; he pērā tonu tāna i mea ai ki ngā papa katoa o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","I hangā anō e ia ngā papa mō te tapenākara: e rua tekau ngā papa mō te taha ki te tonga whaka te tonga; ");
INSERT INTO mri2012_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","e whā tekau hoki ngā tūranga hiriwa i hangā e ia mō ngā papa e rua tekau; e rua ngā tūranga i raro i tētahi papa mō ōna arero e rua, e rua hoki ngā tūranga i raro i tētahi atu papa mō ōna arero e rua. ");
INSERT INTO mri2012_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ā, e rua tekau ngā papa i hangā e ia mō tērā taha o te tapenākara, mō te taha ki te raki. ");
INSERT INTO mri2012_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Me ngā tūranga hiriwa e whā tekau; ngā tūranga e rua mō raro iho i tētahi papa, me ngā tūranga e rua mō raro i tētahi atu papa. ");
INSERT INTO mri2012_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ā, mō te tuarongo o te tapenākara whaka te hauāuru, e ono ngā papa i hangā e ia. ");
INSERT INTO mri2012_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","E rua hoki ngā papa i hangā e ia mō ngā koki o te tapenākara i te tuarongo. ");
INSERT INTO mri2012_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ā, i honoa aua papa i raro, i honoa anō i runga ki te mōwhiti kotahi; i pērātia e ia aua papa e rua i ngā koki e rua. ");
INSERT INTO mri2012_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Nā, ka waru aua papa; me ngā tūranga hiriwa, kotahi tekau mā ono ngā tūranga; e rua ngā tūranga i raro i tētahi papa, i tētahi papa. ");
INSERT INTO mri2012_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","I hangā anō e ia ētahi kaho, he hitimi te rākau; e rima mō ngā papa o tētahi taha o te tapenākara, ");
INSERT INTO mri2012_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","e rima hoki ngā kaho mō ngā papa o tētahi taha o te tapenākara, ā, e rima ngā kaho mō ngā papa o te tapenākara, mō te tuarongo ki te hauāuru. ");
INSERT INTO mri2012_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ā, ko tō waenga kaho i meinga e ia kia rere nā waenganui o ngā papa i tētahi pito ki tētahi pito. ");
INSERT INTO mri2012_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","I whakakikoruatia anō e ia ngā papa ki te kōura, ā, ka hangā ngā mōwhiti o aua papa ki te kōura hei kuhunga mō ngā kaho; i whakakikoruatia anō e ia ngā kaho ki te kōura. ");
INSERT INTO mri2012_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","I hangā anō e ia he ārai ki te purū, ki te pāpura, ki te ngangana, ki te rīnena miro pai; he tohunga rawa te mahinga o ngā kerupima i whatua e ia ki roto. ");
INSERT INTO mri2012_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","I hangā anō e ia ōna pou e whā ki te hitimi, ā, whakakikoruatia iho e ia ki te kōura; he kōura ngā matau. I whakarewaina anō e ia ngā tūranga hiriwa e whā mō aua mea. ");
INSERT INTO mri2012_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","I hangā anō he pā mō te whatitoka o te tēneti ki te purū, ki te pāpura, ki te ngangana, ki te rīnena miro pai hoki, he mea mahi ki te ngira; ");
INSERT INTO mri2012_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","me ōna pou e rima, me ngā matau a aua pou. Ā, i whakakikoruatia e ia ngā pito ki runga o aua pou me ngā awhi ki te kōura; ko ngā tūranga e rima ia he parāhi. ");
INSERT INTO mri2012_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","I hangā anō e Petarēre te āka, he hitimi te rākau; e rua whatīanga me te hāwhe te roa, kotahi whatīanga me he hāwhe te whānui, kotahi whatīanga me te hāwhe te teitei. ");
INSERT INTO mri2012_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ā, i whakakikoruatia e ia ki te kōura parakore a roto, a waho; i hangā anō e ia he niao kōura ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","I whakarewaina anō ngā mōwhiti kōura e whā mō ōna koki e whā; e rua ngā mōwhiti mō tētahi taha, e rua hoki ngā mōwhiti mō tētahi taha. ");
INSERT INTO mri2012_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","I hangā anō e ia he amo, he hitimi te rākau, ā, whakakikoruatia iho ki te kōura. ");
INSERT INTO mri2012_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ā, i kuhua e ia ngā amo ki ngā mōwhiti i ngā taha o te āka, hei amo mō te āka. ");
INSERT INTO mri2012_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","I hangā anō e ia te taupoki ki te kōura parakore; e rua whatīanga me te hāwhe te roa, kotahi whatīanga me te hāwhe te whānui. ");
INSERT INTO mri2012_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","I hangā anō ngā kerupima e rua ki te kōura, he mea patu tāna mahinga, ki ngā pito e rua o te taupoki. ");
INSERT INTO mri2012_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Kotahi te kerupi ki tēnei pito, kotahi kerupi ki tērā pito; i honoa ngā kerupima ki te taupoki ki ōna pito e rua. ");
INSERT INTO mri2012_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ā, i roha atu whakarunga ngā parirau o ngā kerupima, i uhi i te taupoki ki ō rāua parirau, me te anga anō ō rāua mata ki a rāua; i anga whaka te taupoki ngā mata o ngā kerupima. ");
INSERT INTO mri2012_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","I hangā anō te tēpu, he hitimi te rākau; e rua whatīanga te roa, kotahi whatīanga te whānui, kotahi whatīanga me te hāwhe te teitei. ");
INSERT INTO mri2012_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ā, i whakakikoruatia ki te kōura parakore, i hangā anō hoki he niao kōura mō taua mea ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","I hangā anō e ia he awhi mō taua mea, he whānui ringa te nui ā tawhio noa; i hangā anō he niao kōura mō te awhi ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ā, i whakarewaina ngā mōwhiti kōura e whā, ā, whakanohoia iho ngā mōwhiti ki ngā koki e whā i ōna waewae e whā. ");
INSERT INTO mri2012_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","I te ritenga ake o te awhi ngā mōwhiti, hei kuhunga mō ngā amo, hei maunga mō te tēpu. ");
INSERT INTO mri2012_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ā, i hangā e ia ngā amo, he hitimi te rākau, ā, whakakikoruatia iho ki te kōura, hei amo mō te tēpu. ");
INSERT INTO mri2012_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","I hangā anō ngā oko mō runga i te tēpu ki te kōura parakore, ōna rīhi, ōna koko, ōna peihana me ōna kapu mō ngā ringihanga. ");
INSERT INTO mri2012_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","I hangā anō te tūranga rama ki te kōura parakore. Ko tāna hanganga i te tūranga rama he mea patu; nō reira anō tōna take, tōna peka, ōna kapu, ōna puku, me ōna puāwai. ");
INSERT INTO mri2012_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ā, e ono ngā peka i puta ake i ōna taha; e toru ngā peka o te tūranga rama i tētahi taha, e toru hoki ngā peka o te tūranga rama i tētahi taha. ");
INSERT INTO mri2012_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","E toru ngā kapu, he mea rite ki te puāwai aramona, te puku, me te puāwai, ki tētahi peka; e toru hoki ngā kapu, he mea rite ki te puāwai aramona ki tētahi atu peka, te puku me te puāwai. He pērā tonu i ngā peka e ono e puta ake ana i te tūranga rama. ");
INSERT INTO mri2012_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ā, e whā ngā kapu o te tūranga rama, he mea rite ki te puāwai aramona, me te puku, me te puāwai o tētahi, o tētahi. ");
INSERT INTO mri2012_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ā, e rua ngā peka, kotahi puku, o raro ake, nō taua kōura rā anō, e rua hoki ngā peka, kotahi puku, o raro ake nō taua kōura rā anō, e rua hoki ngā peka, kotahi puku, o raro ake, nō taua kōura rā anō, rite tonu ki ngā peka e ono e puta mai ana i roto i taua mea. ");
INSERT INTO mri2012_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Nō te mea kotahi ngā puku, ngā peka; he kōura parakore katoa; kotahi tonu, he mea patu. ");
INSERT INTO mri2012_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","I hangā anō hoki e ia ki te kōura parakore ngā rama e whitu o taua mea, me ōna kuku, me ōna oko ngārahu. ");
INSERT INTO mri2012_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Kotahi anō te taranata kōura parakore i hangā ai taua mea, me ōna oko katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","I hangā anō e ia te āta hei tahunga mea kakara, he hitimi te rākau; kotahi whatīanga te roa, kotahi whatīanga te whānui; he tapawhā; e rua whatīanga te teitei; nō taua mea rā anō ōna haona. ");
INSERT INTO mri2012_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ā, whakakikoruatia iho e ia taua mea ki te kōura parakore, ā runga, me ōna taha, ā pōtae katoa, me ōna haona. I hangā anō e ia he niao kōura mō taua mea ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","I hangā anō ngā mōwhiti kōura e rua mō taua mea, mō raro iho i tōna niao, ki ōna koki e rua, ki ōna taha e rua, hei kuhunga mō ngā amo, hei amohanga. ");
INSERT INTO mri2012_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","I hangā anō ngā amo, he hitimi te rākau, ā, whakakikoruatia iho ki te kōura. ");
INSERT INTO mri2012_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","I hangā anō e ia te hinu tapu hei whakawahi, me te whakakakara parakore ki ngā mea kakara, tā te kaiwhakaranu hoki e hanga ai. ");
INSERT INTO mri2012_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","I hangā anō e ia he āta mō ngā tahunga tinana, he hitimi te rākau. E rima ngā whatīanga te roa, e rima whatīanga te whānui, he tapawhā; e toru ngā whatīanga te teitei. ");
INSERT INTO mri2012_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","I hangā anō ōna haona ki ōna koki e whā; kotahi te rākau o taua mea, o ōna haona; ā, whakakikoruatia iho e ia ki te parāhi. ");
INSERT INTO mri2012_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","I hangā anō ngā oko katoa o te āta, ngā pāta, me ngā koko pungarehu, me ngā peihana, me ngā mārau, me ngā oko ngārahu. I hangā e ia ōna mea katoa ki te parāhi. ");
INSERT INTO mri2012_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","I hangā anō ki te parāhi he pae kupenga mō te āta, he mea rīpekapeka, mō raro i tōna awhi, ki raro iho, i waenganui. ");
INSERT INTO mri2012_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ā, e whā ngā mōwhiti parāhi i whakarewaina e ia mō ngā koki e whā o te pae kupenga parāhi, hei kuhunga mō ngā amo. ");
INSERT INTO mri2012_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","I hangā anō ngā amo, he hitimi te rākau, ā, whakakikoruatia iho ki te parāhi. ");
INSERT INTO mri2012_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Nā, kuhua ana e ia ngā amo ki ngā mōwhiti i ngā taha o te āta, hei amo; i hangā e ia te āta ki te papa, he mea tuwhera kau a roto. ");
INSERT INTO mri2012_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","I hangā anō te takotoranga wai ki te parāhi, me tōna tūranga hoki ki te parāhi, ki ngā whakaata o ngā wāhine i huihui mai, i huihui mai nei ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","I hangā anō te marae; he rīnena miro pai ngā pā o te marae, o te taha ki te tonga whaka te tonga, kotahi rau whatīanga; ");
INSERT INTO mri2012_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","e rua tekau ngā pou o aua mea, e rua tekau anō hoki ngā tūranga parāhi; he hiriwa ngā matau o ngā pou me ngā awhi. ");
INSERT INTO mri2012_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Me ngā pā mō te taha ki te raki, kotahi rau whatīanga, e rua tekau ngā pou, e rua tekau hoki ngā tūranga parāhi. He hiriwa ngā matau o ngā pou me ngā awhi. ");
INSERT INTO mri2012_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","He pā anō hoki mō te taha ki te hauāuru, e rima tekau whatīanga, kotahi tekau ngā pou, kotahi tekau anō hoki ngā tūranga; he hiriwa ngā matau o ngā pou me ngā awhi. ");
INSERT INTO mri2012_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","E rima tekau hoki whatīanga o te taha ki te rāwhiti whaka te rāwhiti. ");
INSERT INTO mri2012_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kotahi tekau mā rima whatīanga o ngā pā o tētahi taha o te kūwaha; e toru ngā pou, e toru hoki ngā tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ā, kotahi tekau mā rima whatīanga o ngā pā o tērā taha o te kūwaha o te marae, o tēnei, o tērā; e toru ngā pou, e toru hoki ngā tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","He rīnena miro pai ngā pā katoa o te marae ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","He parāhi ngā tūranga mō ngā pou, he hiriwa ngā matau o ngā pou me ngā awhi; i whakakikoruatia anō hoki ki te hiriwa ngā pito ki runga. I whakawhaiawhitia anō hoki ngā pou katoa o te marae ki te hiriwa. ");
INSERT INTO mri2012_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","He mea hanga hoki ki te ngira te pā mō te kūwaha o te marae, he purū, he pāpura, he ngangana, he rīnena miro pai. E rua tekau whatīanga te roa, e rima whatīanga te teitei, arā te whānui, rite tonu anō ki ngā pā o te marae. ");
INSERT INTO mri2012_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ā, e whā ngā pou o aua pā, e whā anō hoki ngā tūranga parāhi; he hiriwa ngā matau; i whakakikoruatia anō hoki ngā pito o aua pou me ngā awhi ki te hiriwa. ");
INSERT INTO mri2012_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","He parāhi anō ngā titi katoa o te tapenākara, o te marae ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ko ngā mea tēnei o te tapenākara, arā o te tapenākara o te whakaaturanga, ko ngā mea i whakaritea e Mohi i tāna kōrero hei mahi mā ngā Rīwaiti i raro i te ringa o Itamara, tama a Ārona tohunga. ");
INSERT INTO mri2012_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Nā, hangā ana e Petarēre tama a Uri, tama a Huru, o te iwi o Hūrā, ngā mea katoa i whakahaua e Ihowā ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ko tōna hoa ko Ahoriapa, tama a Ahihamaka nō te iwi o Rāna, he kaimahi, he mea mōhio, he kaiwhakairo hoki i te purū, i te pāpura, i te ngangana, i te rīnena pai. ");
INSERT INTO mri2012_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ā, ko te kōura katoa i mahia mō ngā mea, mō ngā mea katoa o te wāhi tapu, te kōura o te whakahere, e rua tekau mā iwa taranata, e whitu rau e toru tekau hekere, he hekere wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ā, ko te hiriwa o te hunga i taua o te whakaminenga, kotahi rau taranata, kotahi mano e whitu rau e whitu tekau mā rima hekere, he hekere wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Kotahi te pekaha a te tangata, arā kotahi te hāwhe hekere, ko te hekere hoki o te wāhi tapu, nā te hunga hoki i haere kia taua, nā ngā mea e rua tekau, maha atu rānei, ō rātou tau; e ono rau hoki ō rātou mano e toru mano e rima rau e rima tekau. ");
INSERT INTO mri2012_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ā, i whakarewaina ngā taranata hiriwa kotahi rau hei tūranga pou mō te wāhi tapu, hei tūranga pou hoki mō te ārai; kotahi rau taranata, kotahi rau ngā tūranga, kotahi te taranata, kotahi te tūranga. ");
INSERT INTO mri2012_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ā, i hangā e ia ngā hekere kotahi mano e whitu rau e whitu tekau mā rima hei matau mō ngā pou, ā, whakakikoruatia iho e ia ngā pito ki runga, whakawhaiawhitia hoki. ");
INSERT INTO mri2012_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ā, e whitu tekau ngā taranata o te parāhi o te whakahere, e rua hoki mano e whā rau hekere. ");
INSERT INTO mri2012_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Hangā ake e ia ngā tūranga pou mō te whatitoka o te tapenākara o te whakaminenga, te āta parāhi; me tōna pae kupenga, te mea parāhi; me ngā mea katoa o te āta; ");
INSERT INTO mri2012_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","me ngā tūranga pou o te marae ā tawhio noa, me ngā tūranga pou mō te kūwaha o te marae, me ngā titi katoa o te tapenākara, me ngā titi katoa o te marae ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","I hangā anō hoki e rātou te purū, te pāpura, me te ngangana, hei kākahu minita mō te minitatanga i te wāhi tapu, i hangā anō ngā kākahu tapu mō Ārona; ko tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","I hangā anō e ia te epora ki te kōura, ki te purū, ki te pāpura, ki te ngangana, ki te rīnena miro pai. ");
INSERT INTO mri2012_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","I patua anō hoki te kōura hei pāraharaha, ā, ripiripia ana hei mangemange, ā, mahia ana ki roto ki te purū, ki te pāpura, ki te ngangana, ki te rīnena pai, he tohunga rawa te mahi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","I hangā anō ngā pokohiwi o te epora hei hononga; he mea hono ki ngā taha e rua. ");
INSERT INTO mri2012_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Me te whītiki whakairo e mau ana ki tōna epora, kotahi anō te mea i hanga ai rāua, me te hanganga anō; he kōura, he purū, he pāpura, he ngangana, he rīnena miro pai; ko tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","I mahia anō ngā kōhatu onika, he mea whakanoho ki te nohoanga kōura, tuhituhi rawa ki ngā ingoa o ngā tama a Īharaira, he tuhi hīri te tuhi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ā, whakanohoia iho e ia ki ngā pokohiwi o te epora hei kōhatu whakamahara mō ngā tama a Īharaira; hei pērā me tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","He tohunga rawa te mahi i hangā ai e ia te kōuma, he pērā anō me te mahinga o te epora: he kōura, he purū, he pāpura, he ngangana, he rīnena miro pai. ");
INSERT INTO mri2012_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","He tapawhā, he rererua te kōuma i hangā e rātou; kotahi whanganga a te ringa te roa, kotahi hoki whanganga te whānui, he mea rererua. ");
INSERT INTO mri2012_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","E whā hoki ngā rārangi kōhatu i whakanohoia e rātou ki taua mea. Ko te rārangi tuatahi, he harariu, he tōpaha, he kapakara; ko te rārangi tuatahi tēnei. ");
INSERT INTO mri2012_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ko te rārangi tuarua, he emerara, he hapaira, he taimana. ");
INSERT INTO mri2012_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ko te rārangi tuatoru, he rikuri, he akete, he ametihita. ");
INSERT INTO mri2012_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ko te rārangi tuawhā, he perira, he onika, he hahapa; he mea whakapiri ki te nohoanga kōura i ngā wāhi i mau ai. ");
INSERT INTO mri2012_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ā, rite tonu ngā kōhatu ki ngā ingoa o ngā tama a Īharaira kotahi tekau mā rua, rite tonu ki ō rātou ingoa, i rite te tuhi ki tō te hīri, tēnei tangata me tōna ingoa, tēnei tangata me tōna ingoa; rite tonu ki ngā iwi kotahi tekau mā rua. ");
INSERT INTO mri2012_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","I hangā anō e rātou ki te kōura parakore ngā mekameka, he mea whiri, mō te kōuma, mō ngā pito. ");
INSERT INTO mri2012_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","I hangā anō ētahi nohoanga kōura e rua, me ētahi mōwhiti kōura e rua; ā, whakanohoia iho ētahi mōwhiti e rua ki ngā pito e rua o te kōuma. ");
INSERT INTO mri2012_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","I whakanohoia anō ngā mekameka kōura e rua, ngā mea whiri, ki ngā mōwhiti e rua i ngā pito o te kōuma. ");
INSERT INTO mri2012_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","I whakaūkia anō ngā pito e rua o ngā mekameka whiri e rua ki ngā nohoanga e rua, ā, whakanohoia ana ki ngā pokohiwi e rua o te epora, ki te taha ki mua. ");
INSERT INTO mri2012_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","I hangā anō ngā mōwhiti kōura e rua, ā, whakanohoia ana ki ngā pito e rua o te kōuma, ki tōna remu, ki te taha ki roto whaka te epora. ");
INSERT INTO mri2012_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","I hangā anō ētahi atu mōwhiti kōura e rua, ā, whakanohoia ana ki ngā pokohiwi e rua o te epora, ki te taha ki raro, ki te taha ki mua, ki te ritenga o tōna hononga ake, ki runga ake o te whītiki whakapaipai o te epora. ");
INSERT INTO mri2012_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ā, herea iho e rātou te kōuma, ōna mōwhiti ki ngā mōwhiti o te epora, ki te miro purū, kia mau ai ki runga ake o te whītiki whakapaipai o te epora, kei takoto kē te kōuma i te epora; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","I hangā anō e ia te koroka o te epora, he mea whatu, he purū katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ko te kōhao i waenganui o te koroka, he pērā me te kōhao o te pukupuku, me te whiri anō i te kōhao ā huri noa, kei pakaru. ");
INSERT INTO mri2012_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","I hangā anō ētahi pamekaranete mō te remu o te koroka ki te purū, ki te pāpura, ki te ngangana, ki te rīnena miro. ");
INSERT INTO mri2012_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","I hangā anō e rātou ētahi pere ki te kōura parakore, ā, whakanohoia ana ngā pere ki te takiwā o ngā pamekaranete, ki te remu o te koroka ā huri noa, ki te takiwā o ngā pamekaranete; ");
INSERT INTO mri2012_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","he pere he pamekaranete, he pere he pamekaranete, ki te remu o te koroka ā huri noa, hei mea minita; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","I hangā anō ētahi koti ki te rīnena pai, ki te mea whatu, mō Ārona rātou ko āna tama; ");
INSERT INTO mri2012_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","me te pōtae tohunga ki te rīnena pai, me ētahi pōtae pai ki te rīnena pai me ngā tarautete rīnena ki te rīnena miro pai. ");
INSERT INTO mri2012_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Me te whītiki ki te rīnena miro pai, ki te purū, ki te pāpura, ki te ngangana, ki ngā mea i hangā ki te ngira; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","I hangā anō te pāraharaha o te karauna tapu ki te kōura parakore, ā, ko te tuhi i tuhia, he tuhi hīri, “HE TAPU KI A IHOWĀ.” ");
INSERT INTO mri2012_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Nā, ko tētahi miro purū, kia mau ai ki te pōtae tohunga, ki te taha ki runga; ko tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Nā, ka oti katoa te mahi o te tapenākara o te tēneti o te whakaminenga. Rite tonu tā ngā tama a Īharaira i mea ai ki ngā mea katoa i whakahaua e Ihowā ki a Mohi; i pērā anō rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Nā, ka kawea e rātou te tapenākara ki a Mohi, te tēneti me ōna mea katoa, ōna toromoka, ōna papa, ōna kaho, ōna pou, me ōna tūranga pou, ");
INSERT INTO mri2012_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","me te uhi iho, ngā hiako hipi kua oti te whakawhero, me tētahi uhi, arā ngā hiako pateri, me te ārai hīpoki, ");
INSERT INTO mri2012_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","me te āka o te whakaaturanga, me ōna amo, me te taupoki, ");
INSERT INTO mri2012_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","te tēpu me ōna oko katoa, me te taro aroaro, ");
INSERT INTO mri2012_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","te tūranga rama parakore me ōna rama, ngā rama rārangi, me ōna oko katoa, me te hinu mō te whakamārama, ");
INSERT INTO mri2012_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","te āta kōura, te hinu whakawahi, te whakakakara reka, te pā mō te whatitoka o te tapenākara, ");
INSERT INTO mri2012_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","te āta parāhi, me tōna pae kupenga parāhi, ōna amo me ōna oko katoa, te takotoranga wai me tōna tūranga, ");
INSERT INTO mri2012_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ngā pā o te marae, ōna pou, me ōna tūranga pou, me te pā mō te kūwaha o te marae, ōna aho, me ōna titi, me ngā oko katoa mō ngā mahi o te tapenākara, mō te tēneti o te whakaminenga, ");
INSERT INTO mri2012_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ngā kākahu minita mō ngā minitatanga ki te wāhi tapu, me ngā kākahu tapu mō Ārona tohunga, me ngā kākahu mō āna tama, ina minita. ");
INSERT INTO mri2012_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Rite tonu ki ngā mea katoa i whakahaua e Ihowā ki a Mohi tā ngā tama a Īharaira mahinga i ngā mahi katoa. ");
INSERT INTO mri2012_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Nā, ka tirohia iho e Mohi te mahi katoa, nā, rite tonu tā rātou mahi ki tā Ihowā i whakahau ai, i pērā anō rātou; ā, manaakitia ana rātou e Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ā, i kōrero a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Hei te rā tuatahi o te marama tuatahi koe whakaara ai i te tapenākara o te tēneti o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ā, me hoatu ki roto te āka o te whakaaturanga, ka hīpoki ai i te āka ki te ārai. ");
INSERT INTO mri2012_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Me kawe anō te tēpu ki roto, ka āta whakatakoto ai i ngā mea e whakatakotoria ana ki runga; me kawe anō e koe te tūranga rama ki roto, ka tahu ai i ōna rama. ");
INSERT INTO mri2012_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Me whakatū anō e koe te āta kōura mō te whakakakara ki mua o te āka o te whakaaturanga, ka whakairi ai i te pā o te whatitoka ki te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Me whakatū anō e koe te āta mō te tahunga tinana ki mua o te whatitoka o te tapenākara o te tēneti o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Me whakatū anō te takotoranga wai ki te takiwā o te āta, o te tēneti o te whakaminenga, ka riringi wai ai ki roto. ");
INSERT INTO mri2012_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Me whakatū anō te marae ā tawhio noa, ka whakairi ai i te pā ki te kūwaha o te marae. ");
INSERT INTO mri2012_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Nā, ka tango i te hinu whakawahi, ka whakawahi ai i te tapenākara me ngā mea katoa i roto, ka whakatapu ai i taua mea, i ōna mea katoa; ā, ka tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Me whakawahi anō te āta mō te tahunga tinana me ōna oko katoa, me whakatapu anō te āta; ā, ka meinga hei āta tino tapu. ");
INSERT INTO mri2012_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Me whakawahi anō te takotoranga wai me tōna tūranga, me whakatapu. ");
INSERT INTO mri2012_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Me kawe anō e koe a Ārona rātou ko āna tama ki te whatitoka o te tapenākara o te whakaminenga, ka horoi ai i a rātou ki te wai, ");
INSERT INTO mri2012_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ka whakakākahu ai i ngā kākahu tapu ki a Ārona, ka whakawahi ai i a ia, ka whakatapu ai i a ia; ā, ka waiho ia hei tohunga māku. ");
INSERT INTO mri2012_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Nā, me kawe mai āna tama, me whakakākahu ngā koti ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Me whakawahi, kia rite ki tāu whakawahinga i tō rātou pāpā, ā, ka meinga rātou hei tohunga māku. Ā, ka ai tō rātou whakawahinga hei whakatohunga i a rātou mō ake tonu atu, puta noa i ō rātou whakatupuranga.” ");
INSERT INTO mri2012_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","I pērā anō a Mohi; rite tonu tāna i mea ai ki ngā mea katoa i whakahaua e Ihowā ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Nā, i te marama tuatahi o te rua o ngā tau, i te rā tuatahi o te marama ka whakaarahia te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","I whakaarahia hoki e Mohi te tapenākara, i whakatakotoria ōna tūranga, i whakaarahia ōna papa, i kuhua ōna kaho, ā, whakaarahia ana ōna pou. ");
INSERT INTO mri2012_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","I hīpokina anō e ia te tēneti ki runga i te tapenākara, ā, makā iho ana te hīpoki o te tēneti ki runga ake, ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Nā, ka mau ia ki te whakaaturanga, ā, hoatu ana ki roto ki te āka, ā, kuhua ana ngā amo ki te taha o te āka, nā, ka makā iho te taupoki ki runga ki te āka. ");
INSERT INTO mri2012_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Nā, ka maua e ia te āka ki roto ki te tapenākara, ā, whakairihia ake ana te ārai hīpoki, hei hīpoki mō te āka o te whakaaturanga; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","I whakatūria anō e ia te tēpu ki te tēneti o te whakaminenga, ki te taha whaka te raki o te tapenākara, ki waho mai o te ārai. ");
INSERT INTO mri2012_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","I whakarārangitia hoki te taro ki runga, ki te aroaro o Ihowā; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","I whakatūria anō e ia te tūranga rama ki te tēneti o te whakaminenga, ki te ritenga atu o te tēpu, ki te taha whaka te tonga o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ā, tahuna ana e ia ngā rama ki te aroaro o Ihowā; ko tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","I whakatūria hoki e ia te āta kōura ki te tēneti o te whakaminenga ki mua mai o te ārai. ");
INSERT INTO mri2012_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ā, tahuna ana e ia he whakakakara reka ki runga; ko tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","I whakairihia anō te pā mō te whatitoka o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ā, i whakatūria e ia te āta mō te tahunga tinana ki te whatitoka o te tapenākara o te tēneti o te whakaminenga, ā, whakaekea ana ki runga te tahunga tinana me te whakahere totokore; ko tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ā, i whakatūria e ia te takotoranga wai ki te takiwā o te āta, o te tēneti o te whakaminenga, ā, ringihia ana he wai ki roto hei horoi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ā, i horoia e Mohi, e Ārona hoki rātou ko āna tama, ō rātou ringa me ō rātou waewae ki reira; ");
INSERT INTO mri2012_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","i tō rātou haerenga ki roto ki te tēneti o te whakaminenga, i te mea rānei ka whakatata ki te āta, ka horoi rātou; ko tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","I whakatūria anō te marae o te tapenākara, o te āta ā tawhio noa, ā, whakairihia ana te pā o te kūwaha o te marae. Nā, ka oti te mahi i a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kātahi ka taupokina iho te tēneti o te whakaminenga e te kapua, ā, ka kī te tapenākara i te korōria o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ā, kīhai i taea e Mohi te tomo ki te tēneti o te whakaminenga nō te mea e taungia iho ana e te kapua, e kī ana hoki te tapenākara i te korōria o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ā, ka riro ake te kapua i te tapenākara, ka haere ngā tama a Īharaira i ō rātou haerenga katoa; ");
INSERT INTO mri2012_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ki te mea ia kīhai i riro te kapua, kīhai i haere, ā taea noatia te rā i riro ake ai. ");
INSERT INTO mri2012_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","I runga hoki i te tapenākara te kapua o Ihowā i te awatea, ā, he ahi kei runga i te pō, i te tirohanga a te whare katoa o Īharaira, i ō rātou haerenga katoa.");
INSERT INTO mri2012_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Nā, ka karanga a Ihowā ki a Mohi, ka kōrero ki a ia i roto i te tapenākara o te whakaminenga, ka mea: ");
INSERT INTO mri2012_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: Ki te kawea e tētahi tangata o koutou he whakahere ki a Ihowā, me kawe tā koutou whakahere i roto i ngā kararehe, arā i roto i ngā kau, i roto rānei i ngā hipi. ");
INSERT INTO mri2012_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Ki te mea he tahunga tinana tāna whakahere nō ngā kau, me tāpae e ia he toa, he kohakore; ka tuku ai ki te whatitoka o te tapenākara o te whakaminenga, hei mea e manakohia ai ia i te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ā, me popoki tōna ringa ki te pane o te tahunga tinana; ā, ka manakohia tāna, hei whakamārie mōna. ");
INSERT INTO mri2012_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Nā, me patu te kau ki te aroaro o Ihowā; ā, me kawe te toto e ngā tohunga, e ngā tama a Ārona, me tāuhiuhi te toto ki te āta ā tawhio noa, ki tērā i te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Nā, me tīhore e ia te tahunga tinana, ā, me tapatapahi tēnei wāhi ōna, tēnei wāhi ōna. ");
INSERT INTO mri2012_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Nā, me maka he ahi e ngā tama a Ārona tohunga ki runga ki te āta, me whakapai hoki ngā wahie ki runga ki te ahi. ");
INSERT INTO mri2012_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Nā, ka whakarārangi ai ngā tohunga, ngā tama a Ārona, i ngā pīhi, te pane me te ngako, ki ngā wahie o te ahi i te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ko ōna whēkau ia, me ōna waewae, me horoi ki te wai, ka tahu katoa ai te tohunga ki runga ki te āta hei tahunga tinana, hei whakahere ahi, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Nā, nō te kāhui tāna whakahere nō ngā hipi, nō ngā koati rānei, hei tahunga tinana; me kawe e ia he toa, he mea kohakore, ");
INSERT INTO mri2012_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ka patu ai ki te taha ki te raki o te āta, ki te aroaro o Ihowā; ā, mā ngā tohunga, mā ngā tama a Ārona, e tāuhiuhi ōna toto ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Nā, ka tapatapahi ai ia he wāhi, he wāhi, tōna pane, tōna ngako; ā, mā te tohunga e whakarārangi ki ngā wahie o te ahi i runga i te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ko ngā whēkau ia, me ngā waewae, me horoi ki te wai; ā, ka kawe katoa ai te tohunga, ka tahu ai ki te āta. He tahunga tinana hoki, he whakahere ahi, he kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Nā, mehemea he tahunga tinana nō ngā manu tāna whakahere ki a Ihowā, nā, me kawe e ia tāna whakahere i roto i ngā kūkupa i roto rānei i ngā pī kūkupa. ");
INSERT INTO mri2012_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ā, mā te tohunga e kawe ki te āta, e whakawiri atu tōna pane, ka tahu ai ki runga ki te āta; ā, ko ōna toto me tuku kia heke ki te taha o te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ā, ko tōna puku me tōna paru me tango, ā, ka makā ki te taha ki te rāwhiti o te āta, ki te wāhi o ngā pungarehu. ");
INSERT INTO mri2012_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Nā, me hahae e ia mā ōna parirau, otiia kaua e motuhia rawatia; ā, mā te tohunga e tahu ki runga ki te āta, ki ngā wahie o te ahi. He tahunga tinana tēnā, he whakahere ahi, he kakara reka ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Ā, ki te kawea e tētahi he whakahere totokore ki a Ihowā, hei te parāoa pai he whakahere māna; ā, me riringi e ia he hinu ki runga ki taua mea, ka maka hoki i te parakihe ki runga; ");
INSERT INTO mri2012_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ā, ka kawe ai ia ki ngā tohunga, ki ngā tama a Ārona. Nā, me ao e ia i roto i taua mea, kia kī tōna ringa i te parāoa pai, i te hinu, me te parakihe katoa hoki; nā, ka tahu te tohunga i te whakamahara o taua mea ki te āta, hei whakahere ahi, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ā, ko te toenga o te whakahere totokore, mā Ārona rātou ko āna tama; he mea tino tapu tēnā i roto i ngā whakahere ahi a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Ā, ki te kawea e koe hei whakahere he whakahere totokore i tunua ki te oumu, hei ngā keke parāoa, hei ngā mea rēwenakore, me kōnatunatu ki te hinu, hei ngā keke angiangi rānei kāhore nei he rēwena, he mea pani ki te hinu. ");
INSERT INTO mri2012_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ā, ki te mea he whakahere totokore te whakahere, he mea i tunua ki te pāraharaha, hei te mea parāoa pai, kīhai nei i rēwenatia, kua oti nei te konatu ki te hinu. ");
INSERT INTO mri2012_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Me whatiwhati e koe, ka riringi ai ki te hinu; he whakahere totokore tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Nā, mehemea he whakahere totokore tāu whakahere, he mea i parāipanatia, me hanga ki te parāoa, ki te hinu. ");
INSERT INTO mri2012_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ā, me kawe e koe te whakahere totokore, i hangā ki ēnei mea, ki a Ihowā; ā, ka tukua atu ki te tohunga, nā māna e mau atu ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Nā, ka tangohia e te tohunga i roto i te whakahere totokore te whakamahara o taua mea, ka tahu ai ki te āta; hei whakahere ahi, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ā, mā Ārona rātou ko āna tama te toenga o te whakahere totokore; he mea tino tapu tēnā i roto i ngā whakahere ahi a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Kei hangā ki te rēwena tētahi whakahere totokore e kawea ana e koutou mā Ihowā; kei tahuna hoki e koutou he rēwena, he honi rānei, i roto i tētahi o ngā whakahere ahi a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Nā, hei whakahere tūāpora, me whakahere ēnā mā Ihowā; otiia e kore e tahuna ki te āta hei kakara reka. ");
INSERT INTO mri2012_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Me kīnaki anō ki te tote āu whakahere totokore katoa ina whakaherea. Kei whakamutua hoki te tote o te kawenata a tōu Atua mō tāu whakahere totokore; me whakahere he tote e koe ki runga i āu whakahere katoa. ");
INSERT INTO mri2012_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Nā, mehemea he whakahere tūāpora tāu whakahere totokore ki a Ihowā, hei te wīti hou, i whakamaroketia ki te ahi, hei te wīti i patua i roto i ngā puku hou, tāu whakahere totokore o āu tūāpora. ");
INSERT INTO mri2012_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Me riringi anō he hinu ki taua mea, me whakatakoto hoki he parakihe ki runga; he whakahere totokore tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Nā, me tahu e te tohunga te whakamahara o taua mea, arā tētahi wāhi o te wīti i patua, o te hinu, me te parakihe katoa; hei whakahere ahi taua mea ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Nā, mehemea he patunga mō te pai tāna e tāpae ai; ki te mea nō ngā kau tāna whakahere, ahakoa toa, ahakoa uha, kia kohakore tāna e tuku ai ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Nā, ka popoki tōna ringa ki te mātenga o tāna whakahere, ka patu ai ki te whatitoka o te tapenākara o te whakaminenga. Nā, ka tāuhiuhia te toto e ngā tohunga, e ngā tama a Ārona, ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Nā, me tāpae e ia he whakahere ahi ki a Ihowā i roto i te patunga mō te pai; ko te ngako e whiwhiwhiwhi ana ki ngā whēkau, me te ngako katoa o ngā whēkau, ");
INSERT INTO mri2012_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","me ngā whatukuhu e rua, me tō reira ngako, tērā i te hope, me te taupā i te ate, me ngā whatukuhu, me tango tērā e ia. ");
INSERT INTO mri2012_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ā, me tahu e ngā tama a Ārona ki te āta, ki runga i te tahunga tinana i runga i ngā wahie o te ahi. He whakahere ahi tēnā, he kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Ā, ki te mea nō ngā hipi tāna e tāpae ai ki a Ihowā hei patunga mō te pai; he toa, he uha rānei, kei whai koha tāna e tuku ai. ");
INSERT INTO mri2012_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ki te tāpaea e ia he reme hei whakahere māna, me tāpae ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Me popoki hoki tōna ringa ki te pane o tāna whakahere, ka patu ai ki mua i te tapenākara o te whakaminenga. Ā, ka tāuhiuhia ōna toto e ngā tama a Ārona ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Me tāpae anō e ia tētahi wāhi o te patunga mō te pai hei whakahere ahi ki a Ihowā; ko tōna ngako me te hiawero katoa, kia tino tata ki te tiki tāna tapahanga; ā, ko te ngako e whiwhiwhiwhi ana ki ngā whēkau, me te ngako katoa o ngā whēkau, ");
INSERT INTO mri2012_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","me ngā whatukuhu e rua, me tō reira taupā, tērā i te hope, me te taupā o te ate, me ngā whatukuhu, me tango tērā e ia. ");
INSERT INTO mri2012_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ā, mā te tohunga e tahu ki runga ki te āta; he kai hoki nō tā Ihowā whakahere ahi. ");
INSERT INTO mri2012_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Ā, ki te mea he koati tāna whakahere, me tāpae ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Ā, ka popoki tōna ringa ki tōna pane, ka patu ai ki mua o te tapenākara o te whakaminenga; ā, mā ngā tama a Ārona e tāuhiuhi ōna toto ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","“Ā, me tāpae atu e ia tētahi wāhi ōna hei whakahere ahi māna ki a Ihowā; ko te ngako e whiwhiwhiwhi ana ki ngā whēkau, me te ngako katoa o ngā whēkau, ");
INSERT INTO mri2012_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","me ngā whatukuhu e rua, me tō reira ngako, tērā i te hope, me te taupā i te ate, me ngā whatukuhu, me tango tērā e ia. ");
INSERT INTO mri2012_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ā, me tahu e te tohunga ki te āta he kai tēnā nō te whakahere ahi, hei kakara reka. Ko te ngako katoa mā Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Hei tikanga mau tonu tēnei mō ō koutou whakatupuranga, i ō koutou nohoanga katoa, kia kaua e kainga tētahi ngako, toto rānei, e koutou.” ");
INSERT INTO mri2012_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Kōrero ki ngā tama a Īharaira, mea atu: Ki te pōhēhē tētahi tangata, ā, ka hara ki tētahi o ngā mea i whakahaua e Ihowā kia kaua e meatia, ā, ka mea i tētahi o aua mea. ");
INSERT INTO mri2012_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Ki te hara te tohunga i whakawahia, e tau ai he hē ki runga ki te iwi; nā, me whakahere e ia ki a Ihowā mō tōna hara i hara ai ia tētahi pūru, hei te kūao kohakore, hei whakahere hara. ");
INSERT INTO mri2012_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Nā, me kawe e ia te pūru ki te whatitoka o te tapenākara o te whakaminenga, ki te aroaro o Ihowā; ā, ka popoki i tōna ringa ki te mātenga o te pūru, ka patu ai te pūru ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Nā, me tango e te tohunga i whakawahia tētahi wāhi o ngā toto o te pūru, ā, ka kawe ki te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ā, ka tou te tohunga i tōna maihao ki te toto, ā, kia whitu āna tāuhiuhinga i te toto ki te aroaro o Ihowā, ki mua o te ārai o te wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Me pani anō e te tohunga tētahi wāhi o ngā toto ki ngā haona o te āta whakakakara reka, ki te aroaro o Ihowā, ki tērā i te tapenākara o te whakaminenga. Ka riringi ai i ngā toto katoa o te pūru ki te tūranga o te āta mō te tahunga tinana, ki tērā i te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ā, me tango e ia ngā ngako katoa o te pūru whakahere hara; te ngako e whiwhiwhiwhi ana ki ngā whēkau, me ngā ngako katoa o ngā whēkau, ");
INSERT INTO mri2012_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","me ngā whatukuhu e rua, me tō reira ngako, tērā i te hope, me te taupā o te ate, me ngā whatukuhu, me tango tērā e ia, ");
INSERT INTO mri2012_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","kia rite ki te tangohanga o tō te pūru o te patunga mō te pai. Ā, me tahu e te tohunga ki runga ki te āta mō te tahunga tinana. ");
INSERT INTO mri2012_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ko te hiako ia o te pūru, ko ōna kikokiko katoa, ko tōna pane, ko ōna i waewae, ko ōna whēkau, me tōna paru – ");
INSERT INTO mri2012_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","arā, ko te pūru katoa hoki – me kawe e ia ki waho o te puni, ki tētahi wāhi pokekore, ki te wāhi e ringihia ai ngā pungarehu, ka tahu ai ki te rākau ki te ahi; hei te ringihanga pungarehu tahu ai. ");
INSERT INTO mri2012_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Ā, ki te pōhēhē te whakaminenga katoa o Īharaira, ā, ka hara, ā, ka ngaro taua mea i ngā kanohi o te whakaminenga, ā, ka tika kē i tētahi o ngā whakahau a Ihowā tētahi o ā rātou mahi, he mea e kore e tika kia meatia, ā, ka whai hara rātou; ");
INSERT INTO mri2012_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ā, ka kitea te hara i hara ai rātou, kātahi ka whakaherea e te whakaminenga tētahi pūru kūao mō te hara, me kawe hoki ki mua o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ka popoki ai ngā ringa o ngā kaumātua o te whakaminenga ki te pane o te pūru ki te aroaro o Ihowā; ā, hei te aroaro o Ihowā patu ai i te pūru. ");
INSERT INTO mri2012_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","“Ā, mā te tohunga i whakawahia e kawe tētahi wāhi o ngā toto o te pūru ki te tapenākara o te whakaminenga; ");
INSERT INTO mri2012_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ka tou ai te tohunga i tōna maihao ki te toto, ā, kia whitu āna tāuhiuhinga ki te aroaro o Ihowā ki mua o te ārai. ");
INSERT INTO mri2012_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Me pani anō e ia tētahi wāhi o te toto ki ngā haona o te āta i te aroaro o Ihowā, ki tērā i te tapenākara o te whakaminenga, ka riringi ai i ngā toto katoa ki te tūranga o te āta tahunga tinana, ki tērā i te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Me tango anō e ia ōna ngako katoa, ka tahu ai ki runga ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ko tāna tēnā e mea ai ki te pūru; kia rite ki tāna i mea ai ki te pūru whakahere hara, kia pērā tāna meatanga ki tēnei; ā, me mea e te tohunga he whakamārie mō rātou, ā, ka murua tō rātou hara. ");
INSERT INTO mri2012_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ā, me kawe e ia te pūru ki waho o te puni, ka tahu, ka pērā anō me ia i tahu i te pūru tuatahi; ko te whakahere hara tēnā mō te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Ki te hara tētahi rangatira, ā, ka mahi i runga i te pōhēhē i tētahi o ngā mea i whakahaua e Ihowā, e tōna Atua, kia kaua e mahia, ā, ka whai hara, ");
INSERT INTO mri2012_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ki te mōhiotia e ia tōna hara i hara ai, me kawe tāna whakahere, he koati, hei te toa, hei te mea kohakore. ");
INSERT INTO mri2012_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ā, ka popoki tōna ringa ki runga ki te mātenga o te koati, ka patu ai ki te wāhi e patua nei te tahunga tinana ki te aroaro o Ihowā; he whakahere hara tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ā, me tango e te tohunga tētahi wāhi o te toto o te whakahere hara ki tōna maihao, ka pani ai ki ngā haona o te āta tahunga tinana, me riringi anō ōna toto ki te tūranga o te āta tahunga tinana. ");
INSERT INTO mri2012_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Nā, me tahu e ia ōna ngako katoa ki te āta, me pērā me te ngako o ngā patunga mō te pai; ā, ka whakamārie te tohunga mōna, mō tōna hara, ā, ka murua. ");
INSERT INTO mri2012_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Ā, ki te pōhēhē tētahi tangata noa atu, ā, ka hara, nōna i mea i tētahi mea e tika kē ana i tētahi o ngā whakahau a Ihowā, he mea e kore e tika kia meatia, ā, ka whai hara; ");
INSERT INTO mri2012_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ki te mōhiotia e ia tōna hara i hara ai, me kawe e ia tāna whakahere, he koati, he uha, he kohakore, mō tōna hara i hara ai. ");
INSERT INTO mri2012_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ā, ka popoki tōna ringa ki te mātenga o te whakahere hara, ka patu ai i te whakahere hara ki te wāhi mō te tahunga tinana. ");
INSERT INTO mri2012_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Nā, ka tango te tohunga i tētahi wāhi o ōna toto ki tōna maihao, ka pani ai ki ngā haona o te āta tahunga tinana, ka riringi ai i ōna toto katoa ki te tūranga o te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Me tango anō e ia ōna ngako katoa, me pērā me te ngako e tangohia ana i ngā patunga mō te pai; ā, me tahu e te tohunga ki runga ki te āta hei kakara reka ki a Ihowā. Nā, ka whakamārie te tohunga mōna, ā, ka murua tōna. ");
INSERT INTO mri2012_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Ā, ki te mea he reme tāna whakahere e kawea ana e ia mō te hara, me kawe e ia hei te uha, hei te mea kohakore. ");
INSERT INTO mri2012_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Nā, ka popoki tōna ringa ki te mātenga o te whakahere hara, ā, ka patua hei whakahere hara ki te wāhi e patua nei e rātou te tahunga tinana. ");
INSERT INTO mri2012_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Nā, me tango e te tohunga tētahi wāhi o te toto o te whakahere hara ki tōna maihao, ka pani ai ki ngā haona o te āta tahunga tinana, me riringi anō ōna toto katoa ki te tūranga o te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Me tango anō e ia ōna ngako katoa, kia rite ki te tangohanga o te ngako o te reme o ngā patunga mō te pai; ka tahu ai e te tohunga ki runga ki te āta, ki runga ki ngā whakahere ahi ki a Ihowā. Nā, ka whakamārie te tohunga mō tōna hara i hara ai, ā, ka murua.” ");
INSERT INTO mri2012_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Ki te hara tētahi, mōna i rongo ki te reo whakaoati, he kaiwhakaatu nei ia mō tāna i kite ai, i mōhio ai rānei, ki te kāhore e whakaaturia e ia, nā, me waha e ia tōna hara. ");
INSERT INTO mri2012_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Ki te pā tētahi ki te mea poke – ki te tinana rānei o te kīrehe poke, ki te tinana rānei o te kararehe poke, ki te tinana rānei o ngā mea ngōki – arā o ngā mea poke, ā, e huna ana i a ia, ā, ka poke ia, nā, ka whai hara ia. ");
INSERT INTO mri2012_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Ki te pā rānei ia ki te poke tangata, ki ngā tini poke e poke ai te tangata, ā, ka huna i a ia; ina mōhiotia e ia, ka whai hara ia. ");
INSERT INTO mri2012_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Ki te oati rānei tētahi, he mea puta ohorere i ōna ngutu, kia mahi i te kino, i te pai rānei, i ngā tini mea rānei e puaki ohorere mai i te tangata ina oati, ā, e huna ana i a ia; ina mōhiotia e ia, nā, ka whai hara ia i tētahi o ēnei mea. ");
INSERT INTO mri2012_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Ā, ki te mea kua whai hara ia i tētahi o ēnei mea, nā, me whāki tōna hara i taua mea; ");
INSERT INTO mri2012_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ā, me kawe e ia tāna whakahere mō te hē ki a Ihowā, mō tōna hara i hara ai, he uha nō te kāhui, he reme, he kūao koati rānei, hei whakahere hara; ā, mā te tohunga e whakamārie mōna, mō tōna hara. ");
INSERT INTO mri2012_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Ā, ki te kāhore e taea e ia i ōna rawa he reme, me kawe e ia ki a Ihowā mō tōna hē i hē ai, kia rua ngā kūkupa, kia rua rānei ngā pī kūkupa; ko tētahi hei whakahere hara, ko tētahi hei tahunga tinana. ");
INSERT INTO mri2012_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Me kawe rāua e ia ki te tohunga, ka whakahere ai e ia, ko te mea mō te whakahere hara ki mua, ka kikini ai i tōna pane i te ritenga o tōna kakī, otiia kaua e motuhia rawatia. ");
INSERT INTO mri2012_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Nā, ka tāuhiuhi ai ia i tētahi wāhi o ngā toto o te whakahere hara ki te taha o te āta; ka whakatē ai i te toenga o te toto ki te tūranga o te āta; he whakahere hara tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ā, ko te rua me tuku hei tahunga tinana, kia rite ki te tikanga; ā, ka whakamārie te tohunga mōna, mō tōna hara i hara ai, ā, ka murua. ");
INSERT INTO mri2012_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Ā, ki te kāhore e taea e ia i ōna rawa te kawe ngā kūkupa e rua, ngā pī kūkupa rānei e rua, nā, me kawe tāna whakahere e te tangata i hara, te whakatekau epa parāoa, hei whakahere hara; kaua e meatia ki te hinu, kaua anō e meatia he parakihe ki runga; he whakahere hara hoki. ");
INSERT INTO mri2012_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Nā, me kawe e ia ki te tohunga, ā, ka aohia ake e te tohunga, kia kī tōna ringa, he whakamahara nō taua mea, ka tahu ai ki runga ki te āta, ki runga ki ngā whakahere ahi ki a Ihowā; he whakahere hara tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ā, ka whakamārie te tohunga mōna, mō tōna hara i hara ai ki tētahi o ēnei mea, ā, ka murua. Ā, mā te tohunga te toenga, ānō he whakahere totokore.” ");
INSERT INTO mri2012_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ki te kino te mahi a tētahi, he hara pōhēhē, ki ngā mea tapu a Ihowā; nā, me kawe e ia tāna whakahere mō te hē ki a Ihowā, kia kotahi hipi toa, hei te mea kohakore, nō te kāhui hipi, me whakarite anō e koe ōna utu ki te hekere hiriwa, hekere o te wāhi tapu, hei whakahere mō te hē. ");
INSERT INTO mri2012_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ka utu ai i tōna hara ki te mea tapu, me tāpiri anō ki te wāhi whakarima, ka hōmai ki te tohunga; ā, ka whakamārie te tohunga mōna ki te hipi toa e whakaherea ana mō te hē, ā, ka murua tōna. ");
INSERT INTO mri2012_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Ā, ki te hara tētahi, ki te poka kē i tētahi o ngā whakahau a Ihowā, he mahi poka noa; ahakoa e kore e mōhiotia e ia, kua hara ia, ā, ka waha ia i tōna kino. ");
INSERT INTO mri2012_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ā, me kawe e ia he hipi toa ki te tohunga, he kohakore, nō te kāhui, kei tau te utu, hei whakahere mō te hē. Ā, ka whakamārie te tohunga mōna, mō tōna pōhēhē i pōhēhē ai ia, ā, kīhai nei i mātau, ā, ka murua tōna hē. ");
INSERT INTO mri2012_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","He whakahere tēnā mō te hē; he pono tōna hē ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ki te hara tētahi, ā, ka hē tāna ki a Ihowā, ā, ka teka hoki ki tōna hoa, he mea i tukua ki a ia kia tiakina, he whakaaetanga rānei, he mea rānei i pāhuatia, he whakahaere hē rānei ki tōna hoa; ");
INSERT INTO mri2012_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","i kitea rānei e ia te mea i ngaro, ā, ka kōrero teka ki taua mea, ka oati teka; i tētahi rānei o ēnei tini mea e mea ai te tangata, e whai hara ai. ");
INSERT INTO mri2012_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","“Nā, kua hara nei ia, kua hē, me whakahoki e ia te mea i pāhuatia, te mea rānei i murua e ia, te mea rānei i waiho ki a ia kia tiakina, te mea ngaro rānei i kitea e ia, ");
INSERT INTO mri2012_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ngā mea katoa rānei i oati teka ai ia. Me utu e ia taua mea kia tino rite, ka tāpiri anō ki te wāhi whakarima; me hōmai e ia ki te tangata nōna, i te rā e kitea ai kua hara ia. ");
INSERT INTO mri2012_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ā, me kawe e ia tāna whakahere mō te hē ki a Ihowā, he hipi toa, he kohakore nō te kāhui, kei tau te utu, hei whakahere mō te hē, ki te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ā, mā te tohunga e whakamārie mōna ki te aroaro o Ihowā, ā, ka murua te hē o tāna i ngā mea katoa i mea ai ia, i hara ai.” ");
INSERT INTO mri2012_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Whakahaua a Ārona rātou ko āna tama, mea atu: Ko te ture tēnei mō te tahunga tinana. Me uta te tahunga tinana ki runga ki te takuahi o te āta ā pau noa te pō, taea noatia te ata; kia kā tonu hoki te ahi o te āta ki runga ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ā, me kākahu e te tohunga tōna kākahu rīnena, me mau anō ōna tarau rīnena ki tōna kiri, ka kohi ai i ngā pungarehu i pau tahi me te tahunga tinana i te ahi i runga i te āta, ā, ka waiho i te taha o te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Nā, ka whakarere atu ia i ōna kākahu, ka kākahu i ētahi atu kākahu, ā, ka mau i ngā pungarehu ki waho i te puni, ki te wāhi pokekore. ");
INSERT INTO mri2012_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kia kā tonu anō te ahi o te āta, kei pirau. Me whakaū anō e te tohunga ngā wahie ki runga, i tēnei ata, i tēnei ata; me āta whakatakoto anō e ia te tahunga tinana ki runga, ā, me tahu e ia te ngako o ngā whakahere mō te pai ki runga. ");
INSERT INTO mri2012_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Kia kā tonu te ahi i runga i te āta; kei pirau.” ");
INSERT INTO mri2012_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Nā, ko te ture tēnei mō te whakahere totokore. Mā ngā tama a Ārona e tāpae ki te aroaro o Ihowā, ki mua i te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Me ao e ia, kia kī tōna ringa, i te parāoa pai o te whakahere totokore, i te hinu hoki, me te parakihe katoa anō hoki i runga i te whakahere totokore, ka tahu ai ki runga ki te āta hei kakara reka, hei whakamahara mō taua mea ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ā, mā Ārona rātou ko āna tama e kai te toenga o taua mea; me kai kore rēwena ki te wāhi tapu; hei te marae o te tapenākara o te whakaminenga rātou kai ai. ");
INSERT INTO mri2012_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","E kore e tunua rēwenatia; kua hoatu e ahau taua mea hei wāhi mā rātou i roto i āku whakahere ahi. He tino tapu tēnā, rite tonu anō ki te whakahere hara, ki te whakahere mō te hē. ");
INSERT INTO mri2012_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Hei kai tēnā mā ngā tāne katoa o ngā tama a Ārona, hei wāhi pūmau mā rātou puta noa i ō koutou whakatupuranga o ngā whakahere ahi a Ihowā; ka tapu ngā tāngata katoa e pā ana ki ēnā.” ");
INSERT INTO mri2012_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ko te whakahere tēnei mā Ārona rātou ko āna tama, ko tā rātou e whakahere ai ki a Ihowā i te rā e whakawahia ai ia: ko te whakatekau epa parāoa hei whakahere totokore, hei mea mau tonu, ko tētahi wāhi ōna i te ata, ko tētahi wāhi i te ahiahi. ");
INSERT INTO mri2012_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Me hanga ki te hinu ki runga i te pāraharaha; ā, ka oti te tunu, ka kawe ki roto; ā, ka whakahere i ngā wāhi i tunua o te whakahere totokore, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mā te tohunga i whakawahia i roto i āna tama hei whakakapi mōna e mahi; he tikanga pūmau, me tahu katoa ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Me tahu katoa ngā whakahere totokore katoa a te tohunga; kaua hei kainga.” ");
INSERT INTO mri2012_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Kōrero ki a Ārona rātou ko āna tama, mea atu: Ko te ture tēnei mō te whakahere hara. Ko te wāhi e patua ai te tahunga tinana, ko reira patu ai i te whakahere hara, ki te aroaro o Ihowā; he tino tapu tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ko te tohunga nāna i whakahere taua mea mō te hara, māna e kai; me kai ki te wāhi tapu, ki te marae o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ki te pā tētahi mea ki tōna kikokiko, ka tapu; ā, ki te maringi tētahi wāhi o ōna toto ki tētahi kākahu, me horoi ki te wāhi tapu te mea i maringi nei taua toto ki runga. ");
INSERT INTO mri2012_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ko te oko oneone ia i kōhuatia ai me wāhi; ā, ki te mea i kōhuatia ki te oko parāhi, nā, me mukumuku, ka horoi ai ki te wai. ");
INSERT INTO mri2012_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Mā ngā tāne katoa i roto i ngā tohunga e kai; he mea tino tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Kaua hei kainga te whakahere hara, e kawea nei tētahi wāhi o ōna toto ki roto ki te tapenākara o te whakaminenga hei whakamārie ki te wāhi tapu; me tahu ki te ahi.” ");
INSERT INTO mri2012_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Nā, ko te ture tēnei mō te whakahere mō te hē; he tino tapu tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Hei te wāhi e patua ai te tahunga tinana patua ai e rātou te whakahere mō te hē; me tāuhiuhi anō e ia ōna toto ki te āta, ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Me whakahere anō e ia ōna ngako katoa; ko te hiawero mōmona me te ngako e whiwhiwhiwhi ana ki ngā whēkau, ");
INSERT INTO mri2012_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","me ngā whatukuhu e rua, me tō reira ngako, tērā i te hope, me te taupā i te ate, me ngā whatukuhu, me tango tērā e ia. ");
INSERT INTO mri2012_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ā, mā te tohunga e tahu ki runga ki te āta, hei whakahere ahi ki a Ihowā; he whakahere mō te hē tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Mā ngā tāne katoa i roto i ngā tohunga e kai tēnā; me kai ki te wāhi tapu; he mea tapu rawa tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Ko te whakahere hara, ko te whakahere mō te hē, rite tonu rāua. Kotahi anō te ture mō ēnā; ka riro mā te tohunga nāna tēnā i mea hei whakamārie. ");
INSERT INTO mri2012_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ā, ko te tohunga nāna i whakahere te tahunga tinana a tētahi tangata, mā taua tohunga anō te hiako o te tahunga tinana i whakaherea e ia. ");
INSERT INTO mri2012_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Me te whakahere totokore katoa, ngā mea e tunua ana ki te oumu, me ngā mea katoa e parāipanatia ana, e meatia ana rānei ki te pāraharaha, mā te tohunga ēnā nāna i whakahere. ");
INSERT INTO mri2012_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ko ngā whakahere totokore katoa ia i kōnatunatua ki te hinu, ngā mea maroke rānei, mā ngā tama katoa a Ārona; kia rite te wāhi mā tētahi, mā tētahi.” ");
INSERT INTO mri2012_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Ā, ko te ture tēnei mō te patunga mō te pai e tāpaea ana ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“Ki te whakaherea hei whakawhetai, nā, me tāpae tahi me te patunga whakawhetai ngā keke rēwenakore i kōnatunatua ki te hinu, me ētahi mea angiangi anō hoki, hei ngā mea rēwenakore i pania ki te hinu, me ētahi keke parāoa pai i kōnatunatua ki te hinu, ā, tunua iho. ");
INSERT INTO mri2012_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Me tāpae anō e ia, hei tāpiri mō ngā keke, ētahi taro rēwena hei whakahere māna, i runga anō i te patunga whakawhetai o āna whakahere mō te pai. ");
INSERT INTO mri2012_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ā, me tāpae tētahi o tēnā, arā o te whakahere katoa, hei whakahere hapahapai ki a Ihowā, ā, mā te tohunga tēnā, mā te kaitāuhiuhi o te toto o ngā whakahere mō te pai. ");
INSERT INTO mri2012_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nā, ko te kikokiko o āna whakahere mō te pai, arā whakawhetai, me kai i te rā anō i tāpaea ai; kei whakatoea tētahi wāhi mō te ata. ");
INSERT INTO mri2012_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Ki te mea ia he kupu taurangi te patunga o tāna whakahere, he whakahere noa ake rānei, me kai i te rā anō i whakaherea ai e ia tāna patunga; ā, i te aonga ake me kai te toenga. ");
INSERT INTO mri2012_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ko te wāhi ia o te kikokiko o te patunga i toe ki te rā tuatoru, me tahu ki te ahi. ");
INSERT INTO mri2012_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Nā, ki te kainga he kikokiko o te patunga o āna whakahere mō te pai i te toru o ngā rā, e kore e manakohia, e kore anō e kīia nā te kaiwhakahere. Ka waiho hei mea whakarihariha, ā, ka waha tōna kino e te tangata nāna i kai. ");
INSERT INTO mri2012_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“E kore anō hoki e kainga te kikokiko i pā ki te mea poke; me tahu ki te ahi. Ko te kikokiko ia me kai e ngā tāngata pokekore katoa, ");
INSERT INTO mri2012_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ki te kainga ia e tētahi te kikokiko o te patunga mō te pai a Ihowā, me te mau anō tōna poke, ka hātepea atu tēnā wairua i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Me te tangata anō i pā ki te mea poke – ki te poke tangata, ki te kararehe poke rānei, ki tētahi poke whakarihariha rānei – ā, ka kai i te kiko o te patunga mō te pai a Ihowā, ka hātepea atu taua wairua i roto i tōna iwi.” ");
INSERT INTO mri2012_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Kōrero ki ngā tama a Īharaira, mea atu: Kei kainga tētahi ngako, o te kau, o te hipi, o te koati. ");
INSERT INTO mri2012_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Me te ngako o te mea mate māori, me te ngako o te mea i haea e te kīrehe, ka waiho mō ngā tini meatanga kē atu; e kore rawa ia e kainga. ");
INSERT INTO mri2012_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ā, ko te tangata e kai ana i te ngako o ngā kararehe, e meinga nei hei whakahere ahi mā Ihowā, inā, ka hātepea atu i roto i tōna iwi taua wairua nāna nei i kai. ");
INSERT INTO mri2012_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kaua anō te toto e kainga, o te manu, o te kararehe rānei, i ō koutou nohoanga katoa. ");
INSERT INTO mri2012_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ki te kai tētahi i te toto, ka hātepea atu taua wairua i roto i tōna iwi.” ");
INSERT INTO mri2012_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Kī atu ki ngā tama a Īharaira, mea atu: Ki te tāpae tētahi i tāna patunga mō te pai ki a Ihowā, me kawe tāna whakahere ki a Ihowā, he wāhi nō tāna patunga mō te pai, ");
INSERT INTO mri2012_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","mā ōna ringa ake e kawe ngā whakahere ahi mā Ihowā; ko te ngako me te uma, me kawe tēnā e ia kia poipoia ai te uma hei whakahere poipoi ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ā, me tahu te ngako e te tohunga ki runga ki te āta; ko te uma ia mā Ārona rātou ko āna tama. ");
INSERT INTO mri2012_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ko te hūhā matau o ā koutou patunga mō te pai me hoatu ki te tohunga, hei whakahere hapahapai. ");
INSERT INTO mri2012_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Me waiho te hūhā matau hei wāhi mā te tama a Ārona, māna nei e tāpae te toto me te ngako o ngā whakahere mō te pai. ");
INSERT INTO mri2012_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Kua tangohia nei hoki e ahau i ngā tama a Īharaira te uma poipoi me te peke hapahapai, i roto i ā rātou patunga mō te pai, ā, kua hoatu ki te tohunga ki a Ārona rātou ko āna tama, i roto i te wāhi a ngā tama a Īharaira; he tikanga tūturu tēnei.” ");
INSERT INTO mri2012_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Nō te whakawahinga tēnei o Ārona, nō te whakawahinga hoki o āna tama, nō ngā whakahere ahi a Ihowā, o te rā i meinga ai rātou e ia kia whakatata ki a Ihowā, ki te mahi tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ko ngā mea i whakahaua mai e Ihowā kia hōmai ki a rātou e ngā tama a Īharaira i te rā i whakawahia ai rātou e ia. Hei tikanga mau tonu tēnei i ō rātou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ko te ture tēnei mō te tahunga tinana, mō te whakahere totokore, mō te whakahere hara, mō te whakahere mō te hē, mō ngā whakatohungatanga, mō ngā patunga mō te pai. ");
INSERT INTO mri2012_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ko tā Ihowā hoki i whakahau nei i Maunga Hinai ki a Mohi, i te rā i whakahaua ai e ia ngā tama a Īharaira kia tāpaea ā rātou whakahere ki a Ihowā, i te koraha o Hinai. ");
INSERT INTO mri2012_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Tīkina atu a Ārona rātou tahi ko āna tama, me ngā kākahu, me te hinu whakawahi, me te pūru mō te whakahere hara, me ngā hipi toa e rua, me te kete taro rēwenakore; ");
INSERT INTO mri2012_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","huihuia anō hoki e koe te whakaminenga katoa ki te whatitoka o te tapenākara o te whakaminenga.” ");
INSERT INTO mri2012_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Ā, rite tahi ki tā Ihowā i whakahau ai tā Mohi i mea ai; ā, huihuia ana te whakaminenga ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Nā, ka mea a Mohi ki te whakaminenga, “Ko te mea tēnei i whakahaua e Ihowā kia meatia.” ");
INSERT INTO mri2012_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Nā, ka kawea mai a Ārona rātou ko āna tama e Mohi, ā, horoia ana rātou e ia ki te wai. ");
INSERT INTO mri2012_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ā, i whakakākahuria e ia te koti ki a ia, i whītikiria hoki te whītiki, i whakakākahuria atu hoki te koroka, i meatia atu anō hoki te epora ki a ia, ā, whītikiria ana ki a ia te whītiki whakairo o te epora, kia mau ai te epora ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","I whakamaua anō te kōuma ki a ia; ā, whakanohoia ana e ia ngā Urimi me ngā Tumime ki te kōuma. ");
INSERT INTO mri2012_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ā, i pōtaea e ia te pōtae tohunga ki tōna mātenga; i makā iho anō te pāraharaha kōura, te karauna tapu, ki te pōtae tohunga, ki te wāhi ki mua; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Nā, ka mau a Mohi ki te hinu whakawahi, ā, whakawahia ana e ia te tapenākara, me ngā mea katoa i roto, hei whakatapu. ");
INSERT INTO mri2012_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ā, e whitu āna tāuhiuhinga atu i te hinu ki te āta, nā, whakawahia ana e ia te āta me ōna oko katoa, te takotoranga wai anō me tōna tūranga, kia tapu ai. ");
INSERT INTO mri2012_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","I ringihia anō e ia tētahi wāhi o te hinu whakawahi ki runga ki te mātenga o Ārona, ā, whakawahia ana ia kia tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ā, i ārahina mai e Mohi ngā tama a Ārona, ā, whakakākahuria ana ngā koti ki a rātou, whītikiria ana hoki ngā whītiki ki a rātou, pōtaea ana hoki ngā pōtae ki a rātou; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ā, i kawea anō e ia te pūru mō te whakahere hara; nā, ka popoki ngā ringa o Ārona rātou ko āna tama ki te mātenga o te pūru mō te whakahere hara, ");
INSERT INTO mri2012_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ā, patua iho e ia. Ā, ka tango a Mohi i te toto, ā pania atu ana ki tōna maihao ki ngā haona o te āta ā tawhio noa, ā, horohoroa ana e ia te āta, ringihia ana hoki e ia te toto ki te tūranga o te āta, ā, whakatapua ana, hei whakamārie mōna. ");
INSERT INTO mri2012_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Nā, ka tango ia i ngā ngako katoa o ngā whēkau, me te taupā o te ate, me ngā whatukuhu e rua, me tō reira ngako, ā, tahuna ana e Mohi ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ko te pūru ia me tōna hiako, ōna kikokiko, me tōna paru, i tahuna e ia ki te ahi i waho o te puni; i pērātia anō me tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","I kawea anō e ia te hipi toa mō te tahunga tinana, ā, ka popoki ngā ringa o Ārona rātou ko āna tama ki te mātenga o te hipi, ");
INSERT INTO mri2012_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ā, patua iho e ia. Ā, tāuhiuhia atu ana te toto e Mohi ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Nā, ka tapatapahia te hipi; ā, tahuna ana te pane e Mohi, me ngā tapahanga, me te ngako. ");
INSERT INTO mri2012_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Nā, ka horoia e ia ngā whēkau, me ngā waewae ki te wai; ā, tahuna katoatia ana e Mohi te hipi ki runga ki te āta; he tahunga tinana tērā, he kakara reka, he whakahere ahi ki a Ihowā; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Nā, ka kawea e ia te rua o ngā hipi toa, te hipi mō te whakatohungatanga; ā, ka popoki ngā ringa o Ārona rātou ko āna tama ki te mātenga o te hipi. ");
INSERT INTO mri2012_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ā patua iho e ia; nā, ka tangohia e Mohi tētahi wāhi o ōna toto, ā, pania ana e ia ki te matamata o te taringa matau o Ārona, ki te koromatua anō o tōna ringa matau, ki te koromatua anō hoki o tōna waewae matau. ");
INSERT INTO mri2012_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Nā, ka ārahina e ia ngā tama a Ārona, ā, pania ana e Mohi tētahi wāhi o ngā toto ki te matamata o ō rātou taringa matau, ki ngā koromatua hoki o ō rātou ringa matau, ki ngā koromatua anō hoki o ō rātou waewae matau; ā, ka tāuhiuhia e Mohi te toto ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Nā, ka tangohia e ia te ngako me te hiawero, me ngā ngako katoa o ngā whēkau, me te taupā o te ate, me ngā whatukuhu e rua, me tō reira ngako, me te hūhā matau. ");
INSERT INTO mri2012_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","I tangohia anō e ia i roto i te kete taro rēwenakore i te aroaro o Ihowā, kotahi keke rēwenakore, kotahi keke taro hinu me tētahi o ngā mea angiangi, ā, makā iho e ia ki runga ki te ngako, ki runga hoki ki te hūhā matau. ");
INSERT INTO mri2012_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ā, hoatutia katoatia ana e ia ki ngā ringa o Ārona, ki ngā ringa anō o āna tama, ā, poipoia ana hei whakahere poipoi ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Nā, ka tangohia e Mohi i ō rātou ringa, ā, tahuna ana ki runga ki te āta, ki runga ki te tahunga tinana: hei whakatohunga; hei kakara reka, hei whakahere ahi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Nā, ka tangohia e Mohi te uma, ā, poipoia ana e ia hei whakahere poipoi ki te aroaro o Ihowā; i a Mohi tēnā wāhi o te hipi toa o te whakatohungatanga; ko tā Ihowā hoki i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Nā, ka tango a Mohi i tētahi wāhi o te hinu whakawahi, o te toto anō i runga i te āta, ā, tāuhiuhia ana e ia ki a Ārona, ki ōna kākahu, ki a rātou tahi anō ko āna tama, ki ngā kākahu anō o āna tama; ā, whakatapua ana e ia a Ārona, ōna kākahu, āna tama, me ngā kākahu o āna tama. ");
INSERT INTO mri2012_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Nā, ka mea a Mohi ki a Ārona rātou ko āna tama, “Kōhuatia te kikokiko ki te whatitoka o te tapenākara o te whakaminenga; kainga hoki ki reira me te taro i te kete o te whakatohungatanga; kia rite ki tāku i whakahau ai, i mea ai, ‘Me kai e Ārona rātou ko āna tama’; ");
INSERT INTO mri2012_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ā, ko te toenga o te kikokiko, o te taro, me tahu ki te ahi. ");
INSERT INTO mri2012_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Nā, kaua koutou e puta i te whatitoka o te tapenākara o te whakaminenga kia whitu rā anō ngā rā, kia taka rā anō ngā rā o tō koutou whakatohungatanga; e whitu hoki ngā rā e whakatohunga ai ia i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ko ngā mea i meatia ināianei, he mea whakahau mai nā Ihowā kia meatia, hei whakamārie mō koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ā, me noho koutou ki te whatitoka o te tapenākara o te whakaminenga i te ao, i te pō, kia whitu rā anō ngā rā, ki te tiaki i ngā mea a Ihowā, kei mate koutou; ko te mea hoki tēnei i whakahaua ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Nā, ka meatia e Ārona, rātou ko āna tama, ngā whakahau katoa a Ihowā, i kōrerotia e Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ā, i te waru o ngā rā ka karangatia e Mohi a Ārona rātou ko āna tama, ko ngā kaumātua o Īharaira; ");
INSERT INTO mri2012_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ā, ka mea ia ki a Ārona, “Tīkina tētahi kūao kau māu, hei whakahere hara, me tētahi hipi toa hei tahunga tinana, hei te mea kohakore, ka whakahere ai ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ā, me kōrero koe ki ngā tama a Īharaira, me kī atu: ‘Tīkina he koati toa mā koutou hei whakahere hara; me tētahi kūao kau, me tētahi reme, hei te tau tahi, hei te mea kohakore, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","me tētahi pūru, me tētahi hipi toa hei whakahere mō te pai, hei patunga tapu ki te aroaro o Ihowā; me tētahi whakahere totokore, hei te mea konatu ki te hinu; ko āianei hoki a Ihowā puta mai ai ki a koutou.’ ” ");
INSERT INTO mri2012_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Nā, ka kawea e rātou tā Mohi i whakahau ai ki te roro o te tapenākara o te whakaminenga; ā, ka whakatata katoa te whakaminenga, ka tū hoki ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Nā, ka mea a Mohi, “Ko te mea tēnei i whakahaua mai nei e Ihowā kia meatia e koutou; ā, ka puta mai te korōria o Ihowā ki a koutou.” ");
INSERT INTO mri2012_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ā, ka mea a Mohi ki a Ārona, “Whakatata ki te āta, mahia tāu whakahere hara, me tāu tahunga tinana, ka whakamārie ai mōu, mō te iwi hoki. Ka whakahere atu ai hoki i te whakahere a te iwi, ka whakamārie ai mō rātou, ko tā Ihowā hoki i whakahau ai.” ");
INSERT INTO mri2012_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Nā, ka haere a Ārona ki te āta, ā, patua ana e ia te kūao kau, te whakahere hara, te mea hoki mōna. ");
INSERT INTO mri2012_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ā, ka kawea e ngā tama a Ārona te toto ki a ia; ā, ka toua e ia tōna maihao ki te toto, ā, pania ana ki ngā haona o te āta, ringihia ana hoki te toto e ia ki te tūranga o te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ko te ngako ia, me ngā whatukuhu, me te taupā i te ate o te whakahere hara, i tahuna e ia ki runga ki te āta; ko tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ā, ko te kikokiko hoki, me te hiako, i tahuna e ia ki te ahi i waho o te puni. ");
INSERT INTO mri2012_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ā, patua ana e ia te tahunga tinana; ā, ka hōmai e ngā tama a Ārona te toto ki a ia, ā, tāuhiuhia ana e ia ki te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Nā, ka hōmai e rātou te tahunga tinana ki a ia, tēnā tapahanga, tēnā tapahanga, me te pane; ā, tahuna ana e ia ki runga ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ā, i horoia anō e ia ngā whēkau me ngā waewae, ā, tahuna ana ki runga ki te tahunga tinana ki runga ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","I kawea anō e ia te whakahere a te iwi, ā, ka mau ki te koati, ki te whakahere hara mō te iwi, ā, patua ana e ia, whakaherea ana hoki mō te hara; i pērātia anō me te tuatahi. ");
INSERT INTO mri2012_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","I kawea anō e ia te tahunga tinana, ā, mahia ana e ia, pērātia ana i tō te tikanga. ");
INSERT INTO mri2012_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","I kawea anō e ia te whakahere totokore, ā, aohia ana tētahi wāhi e ia, kī tonu te ringa, ā, tahuna ana ki runga ki te āta, hei tāpiri mō te tahunga tinana o te ata. ");
INSERT INTO mri2012_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","I patua anō hoki e ia te pūru, me te hipi toa, hei patunga mō te pai mō te iwi; ā, ka hōmai e ngā tama a Ārona te toto ki a ia, ā, tāuhiuhia ana e ia ki te āta ā tawhio noa, ");
INSERT INTO mri2012_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","me te ngako o te pūru; ā, o te hipi toa – ko te hiawero mōmona, me te whiwhiwhiwhi o ngā whēkau, me ngā whatukuhu, me te taupā i te ate – ");
INSERT INTO mri2012_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ā, i makā iho e rātou ngā ngako ki runga ki ngā uma, ā, tahuna ana e ia ngā ngako ki runga ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","I poipoia anō e Ārona ngā uma me te hūhā matau hei whakahere poipoi ki te aroaro o Ihowā; i pērātia anō me tā Mohi i whakahau ai. ");
INSERT INTO mri2012_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kātahi ka whakarewaina atu e Ārona ōna ringa ki te iwi, ā, manaakitia iho rātou e ia; nā, ka heke iho ia i te meatanga i te whakahere hara, i te tahunga tinana, i ngā whakahere mō te pai. ");
INSERT INTO mri2012_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Nā, ka haere a Mohi rāua ko Ārona ki roto ki te tapenākara o te whakaminenga, ā, ka puta mai anō, ka manaaki hoki i te iwi; nā, ka puta mai te korōria o Ihowā ki te iwi katoa. ");
INSERT INTO mri2012_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","I puta mai anō he ahi i te aroaro o Ihowā, ā, pau ake te tahunga tinana, me ngā ngako, i runga i te āta; ā, nō te kitenga o te iwi katoa, ka hāmama rātou, ā, kūpapa ana ki raro. ");
INSERT INTO mri2012_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nā, ka mau a Nātapa rāua ko Apihu, ngā tama a Ārona, ki ā rāua tahu kakara, ā, makā ana he ahi ki roto, ā, whakatakotoria iho e rāua he whakakakara ki runga, nā, whakaherea ana e rāua he ahi kē ki te aroaro o Ihowā, he mea kīhai i whakahaua e ia ki a rāua. ");
INSERT INTO mri2012_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Nā, ko te putanga mai o te ahi i te aroaro o Ihowā, ā, pau ake rāua, ā, mate iho rāua i te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Nā, ka mea a Mohi ki a Ārona, “Ko te mea tēnei i kōrero rā a Ihowā, i mea rā, ‘Me whakatapu ahau e te hunga katoa e whakatata mai ana ki ahau, me whakakorōria anō hoki ahau ki te aroaro o te iwi katoa.’ ” Ā, whakarongo puku ana a Ārona. ");
INSERT INTO mri2012_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Nā, ka karanga a Mohi ki a Mihāera rāua ko Eritapana, ngā tama a Utiere matua kēkē o Ārona, ka mea ki a rāua, “Haere mai, maua atu ō kōrua tuākana i mua i te wāhi tapu, ki waho o te puni.” ");
INSERT INTO mri2012_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Nā, ka haere rāua, ka mau i a rāua i roto i ō rāua koti ki waho o te puni; i pērā anō rāua me tā Mohi i kī ai. ");
INSERT INTO mri2012_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Nā, ka mea a Mohi ki a Ārona, rātou ko āna tama ko Ereātara, ko Itamara, “Kaua ngā makawe o ō koutou mātenga e waiho kia mahora noa, kaua anō hoki e haea ō koutou kākahu; kei mate koutou, kei rīria hoki te iwi katoa. Engari kia tangihia e ō koutou tēina, e te whare katoa o Īharaira, te tahunga i tahuna nei e Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kaua hoki koutou e puta i te whatitoka o te tapenākara o te whakaminenga, kei mate koutou; kei runga hoki i a koutou te hinu whakawahi a Ihowā.” Nā, ka meatia e rātou tā Mohi i kōrero ai. ");
INSERT INTO mri2012_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Nā, ka kōrero a Ihowā ki a Ārona, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Kaua e inumia he wāina, tētahi wai whakahaurangi rānei, e koutou tahi ko āu tama, ina haere ki te tapenākara o te whakaminenga, kei mate koutou. Hei tikanga pūmau tēnei ki ō koutou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kia taea ai hoki te wehe, te tapu me te noa, te poke me te pokekore; ");
INSERT INTO mri2012_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","kia taea ai hoki te whakaako i ngā tama a Īharaira ki ngā tikanga katoa i kōrerotia e Ihowā ki a rātou, arā e Mohi.” ");
INSERT INTO mri2012_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","I kōrero anō a Mohi ki a Ārona, ki āna tama anō i ora, ki a Ereātara, ki a Itamara: “Tīkina te whakahere totokore e toe ana o ngā whakahere ahi a Ihowā, ka kai rēwenakore ai ki te taha o te āta, he tino tapu hoki; ");
INSERT INTO mri2012_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ā, me kai ki te wāhi tapu, ko taua wāhi hoki o ngā whakahere ahi a Ihowā māu, mā āu tama hoki; ko te mea tēnā i whakahaua ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ko te uma poipoi me te hūhā hapahapai me kai ki te wāhi pokekore, e koe, e koutou tahi ko āu tama, ko āu tamāhine; i whakaritea hoki ēnā hei wāhi māu, hei wāhi hoki mā āu tama, he mea hōmai nō roto i ngā patunga mō te pai a ngā tama a Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Me kawe tahi mai e rātou te hūhā hapahapai, te uma poipoi, me te ngako mō ngā whakahere ahi, ā, ka poipoia hei whakahere poipoi ki te aroaro o Ihowā; ā, ka waiho mā koutou tahi ko āu tama; hei tikanga pūmau tēnei; ko tā Ihowā hoki i whakahau ai. ");
INSERT INTO mri2012_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Nā, ka āta rapu a Mohi i te koati o te whakahere hara, nā, kua tahuna – nā, ka riri ia ki a Ereātara rāua ko Itamara, ki ngā tama a Ārona i ora, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“He aha tē kainga ai e koutou te whakahere hara ki te wāhi tapu, he tino tapu nei hoki, ā, kua hōmai anō mā koutou, mā koutou hoki e waha te kino o te whakaminenga, e whakamārie hoki mō rātou ki te aroaro o Ihowā? ");
INSERT INTO mri2012_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Titiro hoki, kāhore anō ōna toto i kawea ki roto ki te wāhi tapu; ko te tikanga kia kainga tēnā e koutou ki te wāhi tapu, ko tāku hoki i whakahau ai.” ");
INSERT INTO mri2012_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Nā, ka mea atu a Ārona ki a Mohi, “Nanā, nōnāianei i whakaherea ai e rātou tā rātou whakahere hara, me tā rātou tahunga tinana, ki te aroaro o Ihowā; ā, kua pā mai ēnei mea ki ahau! Ā, me i kainga te whakahere hara e ahau ināianei, tērā rānei e manakohia mai e Ihowā?” ");
INSERT INTO mri2012_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ā, ka rongo a Mohi, nā, ka whakaae. ");
INSERT INTO mri2012_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ā, i kōrero a Ihowā ki a Mohi rāua ko Ārona, i mea ki a rāua: ");
INSERT INTO mri2012_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Kōrero ki ngā tama a Īharaira, mea atu: Ko ngā kīrehe ēnei e kainga e koutou o ngā kararehe katoa i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Ko ngā mea katoa i roto i ngā kararehe e tararua ana te matimati, e tino mawehe ana hoki te tītorehanga, e whakahoki ake ana hoki i te kai, ko tēnā tā koutou e kai ai. ");
INSERT INTO mri2012_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“Otiia, kaua e kainga ēnei o ngā mea e whakahoki ake ana i te kai, o ngā mea hoki e tararua ana te matimati: ko te kāmera, nō te mea e whakahoki ake ana anō ia i te kai, otiia kāhore i tararua te matimati; hei mea poke tēnā ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Me te koni, nō te mea e whakahoki ake ana anō ia i te kai, otiia kāhore i tararua te matimati; hei mea poke ia ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Me te hea, nō te mea e whakahoki ake ana anō ia i te kai, otiia kāhore i tararua te matimati; hei mea poke ia ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Me te poaka, ahakoa e tararua ana te matimati, e tino mawehe ana hoki te tītorehanga, kāhore e whakahokia ake te kai; hei mea poke ia ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kaua e kainga tētahi wāhi o ō rātou kikokiko, kaua anō e pā ki ō rātou tinana mate; hei poke ēnā ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Ko ēnei ā koutou e kai ai o ngā mea katoa o roto o ngā wai. Ko ngā mea katoa o ngā wai, o ngā moana, o ngā awa, he tara ō rātou, he unahi, ko ēnā ā koutou e kai ai. ");
INSERT INTO mri2012_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ā, ko ngā mea katoa kāhore he tara, kāhore he unahi, o ngā moana, o ngā awa, o roto o ngā mea katoa e tere ana i ngā wai, o ngā mea ora katoa o ngā wai; hei mea whakarihariha ēnā ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Inā, hei mea whakarihariha anō ēnā ki a koutou; kei kainga tētahi wāhi o ō rātou kikokiko e koutou, ā, me whakarihariha atu ki ō rātou tinana mate. ");
INSERT INTO mri2012_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ko ngā mea katoa o ngā wai kāhore he tara, kāhore he unahi, hei mea whakarihariha ēnā ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Ko ēnei anō o ngā manu ā koutou e whakarihariha ai; e kore e kainga, he whakarihariha hoki: ko te ēkara, ko te wāwāhi-iwi, ko te ahipare, ");
INSERT INTO mri2012_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ko te whatura, ko te kāiaia, me ngā mea pērā; ");
INSERT INTO mri2012_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ko ngā raweni katoa, me ngā mea pērā; ");
INSERT INTO mri2012_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","me te otereti, me te kāhu pō, me te koekoeā, me te kāhu, me ngā mea pērā, ");
INSERT INTO mri2012_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","me te ruru nohinohi, me te kawau, me te ruru nui, ");
INSERT INTO mri2012_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","me te wani, me te perikana, me te kia ēkara, ");
INSERT INTO mri2012_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","me te tāka, me te heroni, me ngā mea pērā, me te hupou, me te pekapeka. ");
INSERT INTO mri2012_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Ko ngā mea ngōkingōki katoa e rere ā-manu ana, e whā ngā waewae hei haere, me whakarihariha atu e koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Otiia, me kai anō ēnei e koutou o ngā mea ngōkingōki katoa e rere ā-manu ana, e whā nei ngā waewae hei haere, ā, he waewae anō ō rātou kei runga ake i ngā raparapa, hei mokowhiti i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ko ēnei o rātou e kainga e koutou; ko te māwhitiwhiti, me ngā mea e rite ana ki a ia, me te tātarakihi, me ngā mea e rite ana ki a ia, me te pākauroharoha, me ngā mea e rite ana ki a ia, me te koeke, me ngā mea e rite ana ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ko ngā mea ngōkingōki kē atu ia, ko ngā mea rere ā-manu, e whā nei ō rātou waewae, me whakarihariha atu e koutou.” ");
INSERT INTO mri2012_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“He mea hoki ēnei e poke ai koutou; ki te pā tētahi ki ō rātou tinana mate, ka poke ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ā, ki te mauria e te tangata tētahi wāhi o ō rātou tinana mate, me horoi e ia ōna kākahu, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Ko ngā kararehe katoa e tararua ana te matimati, ā, kāhore anō i tino mawehe te tītorehanga, kāhore rānei e whakahoki ake i te kai, hei mea poke ki a koutou; ka poke ngā tāngata katoa e pā ana ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nā, ko ngā mea katoa he tū ā-ringaringa nei ngā waewae e haere ai rātou, o roto o ngā kīrehe katoa e whā nei ngā waewae hei haere, hei mea poke ēnā ki a koutou; ki te pā tētahi ki ō rātou tinana mate, ka poke ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ā, ki te mauria e tētahi te tinana mate o tētahi o rātou, me horoi e ia ōna kākahu, ka poke hoki ia ā ahiahi noa; kia poke ēnā ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Ka poke anō hoki ēnei ki a koutou o ngā mea ngōkingōki katoa e ngōkingōki ana i runga i te whenua: ko te wīhara, ko te kiore, me te tuatara, me ngā mea e rite ana ki a ia, ");
INSERT INTO mri2012_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","me te koka, me te korokotaera, me te mokomoko, me te moeone, me te kamiriona. ");
INSERT INTO mri2012_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Kia poke ēnei ki a koutou o ngā mea ngōkingōki katoa; ki te pā atu tētahi ki a rātou, ina mate, ka poke ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ā, ki te taka tētahi o rātou, ina mate, ki runga ki tētahi mea, ka poke taua mea; ahakoa he oko rākau, he mea kākahu, hiako rānei, pēke rānei; ahakoa he oko aha rānei, aha rānei, e meatia ai tētahi mea, me maka ki te wai, ā, ka poke ā ahiahi noa; kātahi ka kore te poke. ");
INSERT INTO mri2012_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ā, ki te taka tētahi o rātou ki roto ki tētahi oko oneone, ahakoa he aha rānei, he aha rānei, kei roto, kua poke, ā, me wāhi. ");
INSERT INTO mri2012_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ki te maringi taua wai ki runga ki tētahi o ngā kai e kainga ana, ka poke; ka poke anō hoki ngā wai katoa e inumia ana i roto i aua oko katoa. ");
INSERT INTO mri2012_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ka poke anō hoki ngā mea katoa kua taka nei tētahi wāhi o ō rātou tinana mate ki runga; ahakoa oumu, tūranga kōhua rānei, me wāhi kia ngotangota; he mea poke hoki, ā, ka poke anō ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Otiia ki te mea he puna, he poka rānei, he nui nei te wai, kāhore ōna poke; ki te pā ia tētahi ki ō rātou tinana mate, ka poke. ");
INSERT INTO mri2012_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ki te taka anō hoki tētahi wāhi o ō rātou tinana mate ki ngā purapura e whakatōkia ana, e kore e poke. ");
INSERT INTO mri2012_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Otiia, ki te mea kua oti te purapura te mea ki te wai, ā, ka taka tētahi wāhi o ō rātou tinana mate ki runga, ka poke ēnā ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Ā, ki te mate māori tētahi o ngā kararehe e kainga ana e koutou; ki te pā tētahi ki tōna tinana mate, ka poke ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ā, ki te kai tētahi i tētahi wāhi o tōna tinana, me horoi e ia ōna kākahu, ka poke hoki ia ā ahiahi noa; ki te mauria hoki e tētahi tōna tinana, me horoi e ia ōna kākahu, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Hei mea whakarihariha ngā mea ngōkingōki katoa e ngōkingōki ana i runga i te whenua; e kore e kainga. ");
INSERT INTO mri2012_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ko ngā mea katoa ko te kōpū hei haere, me ngā mea katoa ko taua tū haere o ngā wae e whā, arā ko ngā mea katoa he maha ngā waewae, i roto i ngā mea ngōki katoa e ngōki nei i runga i te whenua, kaua ēnā e kainga; he mea whakarihariha hoki. ");
INSERT INTO mri2012_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kei waiho tētahi mea ngōkingōki, hei take e whakariharihangia ai koutou, hei mea rānei e poke ai, e noa ai. ");
INSERT INTO mri2012_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Nō te mea hoki ko Ihowā ahau, ko tō koutou Atua; mō reira me whakatapu koutou e koutou, ā, ka tapu; he tapu hoki ahau; kaua anō hoki e whakapokea koutou ki tētahi mea ngōkingōki e ngōkingōki ana i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ko Ihowā hoki ahau, i kawe mai nei i a koutou i te whenua o Īhipa, kia waiho ai ahau hei Atua mō koutou; mō reira kia tapu koutou, he tapu hoki ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Ko te ture tēnei mō te kararehe, mō te manu, mō ngā mea ora katoa e tere ana i ngā wai, mō ngā mea katoa hoki e ngōki ana i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kia wehea ai te poke me te pokekore, te kararehe e kainga me te kararehe e kore e kainga.” ");
INSERT INTO mri2012_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Kōrero ki ngā tama a Īharaira, mea atu: Ki te hapū tētahi wahine, ā, ka whānau he tāne, nā, kia whitu ngā rā e poke ai ia; kia rite tōna pokenga ki ngā rā o tōna mate paheke. ");
INSERT INTO mri2012_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ā, i te waru o ngā rā ka kotia te kiri matamata o te tamaiti. ");
INSERT INTO mri2012_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ā, me noho te wahine ki te toto o tōna purenga, kia toru tekau mā toru ngā rā. Kaua ia e pā ki tētahi mea tapu, e haere rānei ki te wāhi tapu, kia taka rā anō ngā rā mō tōna purenga. ");
INSERT INTO mri2012_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ki te mea ia ka whānau he kōtiro, kia rua ngā wiki e poke ai, kia rite ki ō tōna paheketanga; ā, kia ono tekau mā ono ngā rā e noho ai ia ki te toto o tōna purenga. ");
INSERT INTO mri2012_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Ā, ka rite ngā rā mō tōna purenga mō te tama, mō te kōtiro rānei, me kawe mai e ia he reme, hei te tau tahi, hei tahunga tinana, me te pī kūkupa, me te kūkupa rānei, hei whakahere hara ki te whatitoka o te tapenākara o te whakaminenga, ki te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ā, māna e whakahere ki te aroaro o Ihowā, ā, ka meinga he whakamārie mōna; ā, ka kore ōna poke i te rerenga o ōna toto. “Ko te ture tēnei mō te wahine kua whānau nei tāna tama, kōtiro rānei. ");
INSERT INTO mri2012_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ā, ki te kāhore e taea e ia i ōna rawa te kawe mai he reme, me kawe mai ngā kūkupa e rua, ngā pī kūkupa rānei e rua; ko tētahi hei tahunga tinana, ko tētahi hei whakahere hara; ā, mā te tohunga e whakamārie mōna, ā, ka kore ōna poke.” ");
INSERT INTO mri2012_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ā, i kōrero a Ihowā ki a Mohi rāua ko Ārona, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ki te mea he puku tō te kiri o te kikokiko o tētahi tangata, he paku rānei, he wāhi tū ā-kanapa rānei, ā, ka rite, i te kiri o tōna kikokiko, ki te pānga mai o te repera; nā, me kawe ia ki a Ārona tohunga, ki tētahi rānei o āna tama, o ngā tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Nā, ka tirohia e te tohunga te mea i pā ki te kiri o te kikokiko; ā, ki te mea kua puta kē, kua mā te huruhuru o te wāhi i pāngia, ā, ki te titiro atu, kua hōhonu iho te mea i pā mai i te kiri o tōna kikokiko, he pānga mai tēnā nō te repera; ā, ka titiro te tohunga ki a ia, ā, ka mea he poke ia. ");
INSERT INTO mri2012_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“Ā, ki te mea e mā ana te wāhi tū ā-kanapa o te kiri o tōna kikokiko, ā, ki te titiro atu kīhai i hōhonu iho i te kiri, ā, kīhai i puta kē, kīhai i mā te huruhuru o reira. Nā, ka tūtakina atu e te tohunga te tangata i pāngia, kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ā, ka tirohia ia e te tohunga i te whitu o ngā rā; nā, kua tūturu te mea i pā mai rā, ki tāna titiro iho, ā, kīhai i hōrapa atu te mate ki te kiri; kātahi ka tūtakina atu anō ia e te tohunga, kia whitu atu anō rā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ā, ka tirohia anō ia e te tohunga i te whitu o ngā rā; ā, ki te mea kua āhua mangu te mea i pā mai rā, ā, kīhai i hōrapa atu te mate ki te kiri, nā, ka mea te tohunga, kāhore ōna poke; he paku kau. Ā, ka horoia e ia ōna kākahu, ā, ka kore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mehemea ia kua nui te hōrapatanga atu o te paku ki te kiri, i muri i te tirohanga a te tohunga i a ia kia purea ai ia, me titiro anō te tohunga ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ā, ki te mea ka kite iho te tohunga, nā, kua hōrapa atu te paku ki te kiri, kātahi ka mea te tohunga, he poke ia; he repera tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Ki te pāngia te tangata e te repera, nā, me kawe ia ki te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ā, ka tirohia e te tohunga, ki te mea kua mā te puku o te kiri; ā, kua puta kē te huruhuru, kua mā, he wāhi ora anō nō te kikokiko ora kei te puku; ");
INSERT INTO mri2012_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","he repera tawhito tēnā i te kiri o tōna kikokiko, me mea te tohunga he poke ia. E kore anō hoki ia e tūtakina atu; e poke ana hoki. ");
INSERT INTO mri2012_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Ā, ki te hōrapa noa atu te repera ki te kiri, ā, ka ngaro i te repera te kiri katoa o te tangata i pāngia, o tōna māhunga iho, ā tae noa ki tōna waewae, o ngā wāhi katoa e titiro ai te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Nā, ka titiro iho te tohunga, ā, ki te mea kua kapi katoa ōna kikokiko i te repera; nā, ka mea ia, kāhore he poke o te tangata i pāngia; kua puta kē, kua mā katoa; kāhore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Otiia, ka poke ia i te rā e kitea ai e ora ana tētahi wāhi o ōna kikokiko. ");
INSERT INTO mri2012_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ā, me titiro iho anō te tohunga ki te kiko ora, ā, ka mea, he poke ia; he mea poke hoki te kikokiko ora; he repera hoki. ");
INSERT INTO mri2012_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Otiia ki te hoki anō ki te mā te kikokiko ora, me haere ia ki te tohunga; ");
INSERT INTO mri2012_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ā, ka titiro te tohunga ki a ia, ā, ki te mea kua puta kē te wāhi i pāngia kua mā, nā, ka mea te tohunga, he pokekore te tangata i pāngia; kāhore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Me te kikokiko hoki, he whēwhē nei tō tōna kiri i mua, ā, kua ora, ");
INSERT INTO mri2012_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ā, ka puta ake i te wāhi o te whēwhē he puku mā, he wāhi tū ā-kanapa rānei, he mea mā, āhua pūwhero, ā, ka whakakitea ki te tohunga; ");
INSERT INTO mri2012_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ā, ki te mea, i te tirohanga a te tohunga, nā, kei raro iho i te kiri, ki te titiro atu, ā, kua puta kē, kua mā te huruhuru o reira. Kātahi ka mea te tohunga, he poke ia, he pānga mai tēnā nō te repera; e tupu ana i runga i te whēwhē. ");
INSERT INTO mri2012_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ki te tirohia ia e te tohunga, nā, kāhore he huruhuru mā o reira, ā, kāhore i raro i te kiri, engari e āhua mangu ana, nā, me tūtaki atu ia e te tohunga, kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ā, ki te mea kua hōrapa nui atu ki te kiri, nā, ka mea te tohunga, he poke ia; he pānga mate tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ki te tūturu ia te wāhi tū ā-kanapa ki taua wāhi, ā, kāhore e hōrapa atu, he nawe whēwhē tēnā; ā, ka mea te tohunga, kāhore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Ki te mea rānei he wera anō nā te ahi kei te kiri o tētahi kikokiko, ā, he wāhi mā kanapa, he mea āhua whero, he mea mā rānei kei te kikokiko ora i wera nei; ");
INSERT INTO mri2012_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","nā, me titiro e te tohunga. Nā, ki te mea kua puta kē, kua mā te huruhuru o te wāhi kanapa, ā, ka hōhonu iho i te kiri ki te titiro atu; he repera tēnā e tupu ake ana i runga i te wera. Ā, me mea te tohunga, he poke ia; he pānga tēnā nō te repera. ");
INSERT INTO mri2012_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Otiia ki te tirohia e te tohunga, nā, kāhore he huruhuru mā o te wāhi kanapa, ā, kāhore i raro i te kiri, otiia e āhua pōuri ana; nā, me tūtaki ia e te tohunga kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ā, i te whitu o ngā rā me titiro te tohunga ki a ia; ā, ki te mea kua hōrapa nui atu ki te kiri, kātahi ka kīia ia e te tohunga, he poke; he pānga tēnā nō te repera. ");
INSERT INTO mri2012_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ā, ki te tūturu te wāhi tū ā-kanapa ki tēnā wāhi, ā, kāhore e hōrapa atu ki te kiri, otiia he āhua pōuri; he puku tēnā nō te weranga, ā, ka kīia ia e te tohunga he pokekore; he nawe wera hoki. ");
INSERT INTO mri2012_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Nā, he tāne, he wahine i pāngia te mātenga, te pāhau rānei, ");
INSERT INTO mri2012_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","me titiro te tohunga ki te mea i pā mai. Ā, ki te mea he hōhonu iho i te kiri ki tāna titiro; ā, he āhua mā kōwhai nei, he ririki te huruhuru; kātahi ka kīia ia e te tohunga, he poke. He pātito tēnā, he repera nō te mātenga, nō te pāhau. ");
INSERT INTO mri2012_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ā, ki te titiro te tohunga ki te pātito i pā nei, ā, kīhai i hōhonu iho i te kiri ki te titiro, ā, kāhore o reira huruhuru mangu. Nā, ka tūtakina atu e te tohunga te tangata i pāngia nei e te pātito, kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ā, i te whitu o ngā rā ka titiro te tohunga ki te mate; ā, ki te kāhore i hōrapa atu te pātito, ā, kāhore ōna huruhuru mā kōwhai nei, ā, ki te titiro kāhore te pātito i hōhonu iho i te kiri. ");
INSERT INTO mri2012_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Nā, ka heua ia, ko te pātito ia e kore e heua; ā, ka tūtakina atu e te tohunga te tangata i te pātito, kia whitu atu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ā, i te whitu o ngā rā, me titiro te tohunga ki te pātito, ā, ki te kāhore i hōrapa te pātito ki te kiri, ā, kāhore anō e hōhonu iho i te kiri ki te titiro; kātahi ka kīia ia e te tohunga, he pokekore. Ā, ka horoia e ia ōna kākahu, ā, ka kore te poke. ");
INSERT INTO mri2012_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","“Otiia, ki te hōrapa nui te pātito ki te kiri i muri i te whakakorenga o tōna poke; ");
INSERT INTO mri2012_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","nā, me titiro anō te tohunga ki a ia; ā, ki te mea kua hōrapa tēnā te pātito ki te kiri, e kore e rapua e te tohunga te huruhuru mā kōwhai; he poke ia. ");
INSERT INTO mri2012_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ki te tūturu ia te pātito ki tāna titiro, ā, kua tupu te huruhuru mangu ki reira; kua mahu te pātito, kāhore ōna poke; ā, ka kīia e te tohunga he pokekore. ");
INSERT INTO mri2012_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Ki te mea he wāhi kanapa tō te kiri o te kikokiko o tētahi tangata, o tētahi wahine rānei, arā he wāhi kanapa mā nei; ");
INSERT INTO mri2012_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","nā, me titiro e te tohunga; ā, ki te mea he mā mangu nei ngā wāhi kanapa o te kiri o tō rātou kikokiko; he pāpaka tēnā e tupu ana i te kiri; kāhore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Me te tangata hoki kua horo ngā huruhuru o tōna mātenga, he pākira ia, kāhore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Me te tangata hoki kua horo ngā huruhuru o te wāhi o tōna mātenga whaka tōna mata, he rae pākira ia; kāhore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ā, ki te mea kua pāngia tētahi wāhi o te mātenga pākira, o te rae pākira rānei, he mea mā āhua whero nei, he repera tēnā e tupu ana i tōna mātenga pākira, i tōna rae pākira rānei. ");
INSERT INTO mri2012_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Nā, me titiro ia e te tohunga; nā, ki te mā āhua whero te puku; i pā ki tōna mātenga pākira, ki tōna rae pākira rānei, ki te rite ki te putanga o te repera ki te kiri o te kikokiko; ");
INSERT INTO mri2012_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","he repera ia, he poke. Me tino mea te tohunga, he poke ia; ko tōna mātenga i pāngia. ");
INSERT INTO mri2012_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Ā, ko te repera i pāngia nei, me haehae ōna kākahu, kia roha noa atu ngā makawe o tōna māhunga, ka ārai i tōna ngutu o runga, ā, ka karanga, ‘He poke, he poke!’ ");
INSERT INTO mri2012_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ka poke ia i ngā rā katoa e pāngia ai; he poke ia; me noho ko ia anake; ko waho o te puni te nohoanga mōna. ");
INSERT INTO mri2012_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Me te kākahu anō hoki i pāngia e te repera, ahakoa he kākahu huruhuru, he kākahu rīnena rānei; ");
INSERT INTO mri2012_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ahakoa i te whenu, i te aho rānei; i ngā mea rīnena, huruhuru rānei; ahakoa i te hiako, i tētahi mea hiako rānei. ");
INSERT INTO mri2012_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Ki te mea he mā kākāriki, he pūwhero rānei te wāhi i pāngia o te kākahu, o te hiako rānei, o te whenu rānei, o te aho rānei, o tētahi mea hiako rānei, he pānga tēnā nō te repera, ā, me whakakite ki te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Nā, ka tirohia e te tohunga te wāhi i pāngia, ā, ka tūtakina atu e ia te mea i pāngia, kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ā, i te whitu o ngā rā ka tirohia e ia te wāhi i pāngia; ki te mea kua hōrapa te mea i pā ki te kākahu, ki te whenu rānei, ki te aho rānei, ki tētahi hiako, ki tētahi mea rānei i hangā ki te hiako. He repera ngau kino te mea i pā; he mea poke tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Nā, ka tahuna e ia taua kākahu, ahakoa he whenu, he aho rānei, ahakoa he huruhuru, he rīnena rānei, ahakoa he mea hiako te mea i pāngia; he repera ngau kino tēnā; me tahu ki te ahi. ");
INSERT INTO mri2012_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Ā, ki te titiro te tohunga, nā, kīhai te mea i pā i hōrapa atu ki te kākahu, ki te whenu, ki te aho, ki tētahi mea hiako rānei. ");
INSERT INTO mri2012_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Kātahi ka whakahau te tohunga kia horoia te mea i pāngia, ā, ka tūtakina atu e ia, kia whitu atu anō ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ā, me titiro e te tohunga te mea i pā mai, i muri i te horoinga; ā, ki te mea kīhai i rerekē te kara o te wāhi i pāngia, ā, kīhai i hōrapa atu te mea i pā mai; he poke tēnā. Me tahu e koe ki te ahi; kua ngaua a roto, ahakoa i tiwha te taha ki roto, te taha rānei ki waho. ");
INSERT INTO mri2012_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“Ā, ki te mea ka kite te tohunga, nā, kua tāpouri te wāhi i pāngia i muri i te horoinga; kātahi ka haea atu e ia i roto i te kākahu, i te hiako rānei, i te whenu rānei, i te aho rānei. ");
INSERT INTO mri2012_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ā, ki te kitea anō i te kākahu, i te whenu rānei, i te aho rānei, i tētahi mea hiako rānei; he mea tupu tēnā; me tahu e koe ki te ahi taua mea i pāngia. ");
INSERT INTO mri2012_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ko te kākahu hoki, ko te whenu rānei, ko te aho rānei, ko te mea hiako rānei i horoia e koe, ā, kua riro te mate, nā, ka horoia anō, ā, ka kore ōna poke.” ");
INSERT INTO mri2012_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ko te ture tēnei mō te pānga mai o te repera ki te kākahu huruhuru, ki te kākahu rīnena rānei, ki te whenu, ki te aho rānei, ki tētahi mea hiako rānei, mō te kī he pokekore, mō te kī rānei he poke. ");
INSERT INTO mri2012_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ā, i kōrero a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ko te ture tēnei mō te repera, i te rā e purea ai: Me kawe ki te tohunga; ");
INSERT INTO mri2012_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ā, ka haere te tohunga ki waho o te puni, ā, ka titiro te tohunga, ā, ki te mea kua ora te repera i pā ki taua tangata i reperatia; ");
INSERT INTO mri2012_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","kātahi ka whakahau te tohunga kia tīkina mā te tangata e purea ana kia rua ngā manu, hei ngā mea ora, hei ngā mea pokekore, me te rākau hīta, me te ngangana, me te hihopa. ");
INSERT INTO mri2012_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ā, ka whakahau te tohunga kia patua tētahi o ngā manu ki roto ki tētahi oko oneone, ki runga i te wai rere. ");
INSERT INTO mri2012_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Nā, ko te manu ora me mau e ia, me te rākau hīta, me te ngangana, me te hihopa, ā, ka toua tahitia me te manu ora ki te toto o te manu i patua ki runga i te wai rere. ");
INSERT INTO mri2012_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ā, kia whitu āna tāuhiuhinga ki te tangata e purea ana i te repera, ā, ka kīia he pokekore, ā, ka tukua atu te manu ora ki te mata o te pārae. ");
INSERT INTO mri2012_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Ā, me horoi ōna kākahu e te tangata e purea ana, me heu katoa hoki ōna huruhuru; ka horoi anō i a ia ki te wai, ā, ka kore ōna poke. Ā muri iho, ka haere mai ki te puni; otiia kia whitu ngā rā e noho ai i waho i tōna tēneti. ");
INSERT INTO mri2012_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Nā, i te whitu o ngā rā, me heu katoa ōna makawe o tōna mātenga, tōna pāhau, ōna tukemata, arā ōna huruhuru katoa, me heu. Me horoi hoki ōna kākahu, me horoi anō hoki ōna kikokiko ki te wai, ā, ka kore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Ā, i te waru o ngā rā me tiki e ia ētahi reme toa, kia rua, hei ngā mea kohakore, me tētahi reme uha tau tahi, hei te mea kohakore, kia toru hoki ngā whakatekau parāoa hei whakahere totokore, hei te mea konatu ki te hinu, kia kotahi hoki te roko hinu. ");
INSERT INTO mri2012_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ā, mā te tohunga, mā te kaipure, e whakatū te tangata e purea ana, me aua mea hoki, ki te aroaro o Ihowā, ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Nā, ka mau te tohunga ki tētahi o ngā reme toa, ā, ka whakaherea hei whakahere mō te hē, me te roko hinu hoki, ā, ka poipoia hei whakahere poipoi ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Me patu anō e ia te reme toa ki te wāhi e patua ai e ia te whakahere hara me te tahunga tinana, ki te wāhi tapu; i te mea mā te tohunga te whakahere hara, māna anō hoki te whakahere mō te hē; he mea tino tapu tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Nā, ka mau te tohunga ki tētahi wāhi o te toto o te whakahere mō te hē, ā, ka pania e te tohunga ki te matamata o te taringa matau o te tangata e purea ana, ki te koromatua hoki o tōna ringa matau, ki te koromatua anō hoki o tōna waewae matau. ");
INSERT INTO mri2012_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","“Nā, ka mau te tohunga ki tētahi wāhi o te roko hinu, ka riringi ki te kapu o tōna ake ringa mauī; ");
INSERT INTO mri2012_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ā, ka toua e te tohunga tōna maihao matau ki te hinu i tōna ringa mauī, ā, kia whitu ngā tāuhiuhinga i te hinu e tōna maihao, ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ā, me pani e te tohunga tētahi wāhi o te toenga o te hinu i tōna ringa ki te matamata o te taringa matau o te tangata e purea ana, ki te koromatua hoki o tōna ringa matau, ki te koromatua anō hoki o tōna waewae matau ki runga i te toto o te whakahere mō te hē. ");
INSERT INTO mri2012_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ā, ko te toenga o te hinu i te ringa o te tohunga, me riringi ki te mātenga o te tangata e purea ana; ā, ka whakamārie te tohunga mōna ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Ā, ka whakaherea e te tohunga te whakahere hara, ka whakamārie hoki mō te tangata e purea ana, arā mō tōna poke; ā muri iho, ka patua e ia te tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ā, ka whakaekea te tahunga tinana me te whakahere totokore e te tohunga ki te āta. Ā, ka whakamārie te tohunga mōna, ā, ka kore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Ā, ki te mea he rawakore ia, ā, e kore ēnā mea e taea, nā, me tiki e ia kia kotahi reme toa hei whakahere mō te hē, hei mea poipoi, hei whakamārie mōna, kia kotahi anō hoki te whakatekau parāoa, hei te mea i kōnatunatua ki te hinu, hei whakahere totokore, me tētahi roko hinu; ");
INSERT INTO mri2012_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","me ētahi kūkupa kia rua, ētahi pī kūkupa rānei kia rua, ngā mea e taea e tōna ringa; ko tētahi hei whakahere hara, ko tētahi hei tahunga tinana. ");
INSERT INTO mri2012_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Ā, hei te waru o ngā rā ka kawe ai ki te tohunga hei purenga mōna, ki te whatitoka o te tapenākara o te whakaminenga, ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Nā, ka mau te tohunga ki te reme mō te whakahere mō te hē, me te roko hinu, ā, ka poipoia e te tohunga hei whakahere poipoi ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ā, ka patua e ia te reme e whakaherea ana mō te hē, ā, ka tango te tohunga i tētahi wāhi o te toto o te whakahere mō te hē, ka pani ai ki te matamata o te taringa matau o te tangata e purea ana, ki te koromatua hoki o tōna ringa matau, ki te koromatua anō hoki o tōna waewae matau. ");
INSERT INTO mri2012_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","“Ā, me riringi e te tohunga tētahi wāhi o te hinu ki te kapu o tōna ake ringa mauī; ");
INSERT INTO mri2012_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ā, ka tāuhiuhia e te tohunga ki tōna maihao matau tētahi wāhi o te hinu i tōna ringa mauī, kia whitu ngā meatanga ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ā, ka pania e te tohunga tētahi wāhi o te hinu i tōna ringa ki te matamata o te taringa matau o te tangata e purea ana, ki te koromatua hoki o tōna ringa matau, ki te koromatua anō hoki o tōna waewae matau, ki te wāhi i te toto o te whakahere mō te hē. ");
INSERT INTO mri2012_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ā, ko te toenga o te hinu i te ringa o te tohunga, me riringi ki te mātenga o te tangata e purea ana, hei whakamārie mōna ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ā, me whakahere tētahi o ngā kūkupa, o ngā pī kūkupa rānei, o ngā mea hoki i taea e tōna ringa; ");
INSERT INTO mri2012_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","āe rā, o ngā mea i taea e tōna ringa, ko tētahi hei whakahere hara, ko tētahi hei tahunga tinana, me te whakahere totokore hoki; ā, ka whakamārie te tohunga mō te tangata e purea ana, ki te aroaro o Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ko te ture tēnei mō te tangata i pāngia e te repera, e kore nei e taea e tōna ringa ngā mea mō tōna purenga. ");
INSERT INTO mri2012_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","I kōrero anō a Ihowā ki a Mohi rāua ko Ārona, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“E tae koutou ki te whenua o Kanaana e hoatu nei e ahau hei kāinga tupu mō koutou, ā, ka whakapāngia atu e ahau te repera ki tētahi whare o te whenua e nohoia e koutou; ");
INSERT INTO mri2012_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ā, ka haere te tangata nōna te whare, ka kōrero ki te tohunga, ka mea, ‘Ki tāku titiro, me te mea kua pāngia te whare.’ ");
INSERT INTO mri2012_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Nā, ka whakahau te tohunga kia whakawāteatia te whare, i te mea kāhore anō te tohunga i haere noa kia kite i te mea i pā mai; kei poke ngā mea katoa o roto o te whare; ā, ka oti, ka haere te tohunga kia kite i te whare. ");
INSERT INTO mri2012_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Nā, ka titiro ia ki te mea i pā mai, ā, ki te mea kua pāngia ngā tara o te whare, ā, kua whai kōputaputa he mea mā kākāriki, pūwhero rānei, ā, ki te titiro atu kua ngoto ki roto ki te tara. ");
INSERT INTO mri2012_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Nā, ka puta te tohunga ki waho o te whare ki te kūwaha o te whare, ā, ka tūtakina te whare, kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ā, ka haere mai anō te tohunga i te whitu o ngā rā, ā, ka titiro; ā, ki te mea kua hōrapa ki ngā pakitara o te whare te mea i pā mai; ");
INSERT INTO mri2012_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","nā, ka whakahau te tohunga kia tangohia ngā kōhatu i pāngia, kia makā ki te wāhi poke ki waho o te pā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ā, ka mea ia kia waruhia a roto o te whare ā taka noa, ā, me riringi e rātou te puehu i waruhia e rātou ki waho o te pā, ki te wāhi poke. ");
INSERT INTO mri2012_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ā, ka tīkina e rātou ētahi atu kōhatu, ka whakanoho atu ai ki te wāhi o aua kōhatu; me tiki anō e ia he moata kē, ka pani ai ki te whare. ");
INSERT INTO mri2012_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ā, ki te hoki mai te mea i pā mai, ā, ka tupu ki te whare i muri i tāna tangohanga i ngā kōhatu, i tāna waruhanga i te whare, i te paninga hoki; ");
INSERT INTO mri2012_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kātahi ka haere te tohunga, ā, ka titiro; ā, ki te mea kua hōrapa ki te whare te mea i pā mai, he repera ngau kino tō te whare; he poke. ");
INSERT INTO mri2012_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Nā, ka wāwāhi i te whare, i ōna kōhatu, i ōna rākau, i te moata katoa o te whare; ā, ka kawea atu ki waho o te pā, ki te wāhi poke. ");
INSERT INTO mri2012_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Ki te haere hoki tētahi ki roto ki te whare, i te mea e tūtaki ana, ka poke ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ki te takoto hoki tētahi ki roto i te whare, me horoi e ia ōna kākahu; ki te kai anō hoki tētahi ki roto i te whare, me horoi anō e ia ōna kākahu. ");
INSERT INTO mri2012_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Ā, ki te haere te tohunga ki roto, ā, ka titiro, ā, kīhai i hōrapa ki te whare te mea i pā mai, i muri iho i te paninga o te whare. Nā, ka kīia e te tohunga he pokekore te whare, nō te mea kua kore taua mea i pā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ā, ka tīkina e ia ētahi manu, kia rua, hei horohoro mō te whare, he rākau hīta, he ngangana, he hihopa. ");
INSERT INTO mri2012_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ā, ka patua e ia tētahi o ngā manu ki roto ki te oko oneone, ki runga i te wai rere. ");
INSERT INTO mri2012_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Nā, ka mau ki te rākau hīta, ki te hihopa, ki te ngangana, me te manu ora, ka tou ai ki te toto o te manu i patua, ki te wai rere hoki, nā, kia whitu āna tāuhiuhinga ki te whare. ");
INSERT INTO mri2012_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ā, ka horohoroa e ia te whare ki te toto o te manu, ki te wai rere hoki, ki te manu ora, ki te rākau hīta, ki te hihopa, ki te ngangana. ");
INSERT INTO mri2012_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Engari, me tuku e ia te manu ora ki waho o te pā, ki te mata o te pārae; nā, ka whakamārie mō te whare; ā, ka kore ōna poke.” ");
INSERT INTO mri2012_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ko te ture tēnei mō ngā pānga katoa o te repera: mō te pātito hoki, ");
INSERT INTO mri2012_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","mō te repera hoki o te kākahu, o te whare, ");
INSERT INTO mri2012_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","mō te puku, mō te paku, mō te wāhi tū ā-kanapa nei. ");
INSERT INTO mri2012_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Hei whakaatu ko āhea poke ai, ko āhea pokekore ai; ko te ture tēnei mō te repera. ");
INSERT INTO mri2012_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","I kōrero anō a Ihowā ki a Mohi rāua ko Ārona, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: Ki te mea he rere tō tētahi tangata, nō roto i tōna kikokiko, e poke ana ia i tōna rere. ");
INSERT INTO mri2012_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ā, ko tōna poke tēnei i a ia e rere nei; ahakoa rere te rere o tōna kikokiko, ahakoa kua mimiti te rere o tōna kikokiko, he mea whakapoke tēnā i a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“He poke ngā moenga katoa e takoto ai te tangata i te rere; ka poke anō hoki ngā mea katoa e noho ai ia. ");
INSERT INTO mri2012_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ki te pā hoki tētahi ki tōna moenga, me horoi e ia ōna kākahu, me ia anō hoki me horoi ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ki te noho hoki tētahi ki runga ki tētahi mea i nohoia e te tangata i te rere, me horoi e ia ōna kākahu, me ia anō hoki me horoi ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“Ā, ki te pā tētahi ki te kikokiko o te tangata i te rere, me horoi e ia ōna kākahu, me ia anō hoki me horoi ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Ā, ki te tuwha atu te tangata i te rere ki tētahi tangata pokekore, nā, me horoi e ia ōna kākahu, me ia anō hoki me horoi ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“Me te nohoanga hōiho i nohoia e te tangata he rere tōna, kua poke. ");
INSERT INTO mri2012_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Nā, he mea nō raro i a ia, ko te tangata i pā atu, kua poke ā ahiahi noa; ki te mauria hoki e tētahi, tētahi o aua mea, me horoi ōna kākahu, me ia anō hoki me horoi ki te wai, ka poke hoki ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Nā, ko te tangata i pā tērā i te rere ki a ia, ā, kīhai i horoia ōna ringa ki te wai, me horoi ōna kākahu, me ia anō hoki me horoi ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Me wāwāhi anō hoki te oko oneone i pāngia e te tangata he rere tōna; ko ngā oko rākau katoa ia me horoi ki te wai. ");
INSERT INTO mri2012_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Ā, e purea i tōna rere te tangata he rere tōna, nā, me tatau e ia ngā rangi e whitu mō tōna purenga, nā, ka horoia e ia ōna kākahu, me horoi anō hoki tōna kikokiko ki te wai rere, ā, ka kore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ā, i te waru o ngā rā me tiki e ia, kia rua ngā kūkupa, kia rua rānei ngā pī kūkupa, ā, ka haere ki te aroaro o Ihowā ki te whatitoka o te tapenākara o te whakaminenga, ka hoatu ai ki te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kātahi ka whakaherea aua mea e te tohunga, tētahi hei whakahere hara, tētahi hoki hei tahunga tinana; ā, ka whakamārie te tohunga mōna ki te aroaro o Ihowā mō tōna rere. ");
INSERT INTO mri2012_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Ki te paheke mai hoki te purapura moenga o tētahi tangata, nā, me horoi e ia tōna tinana katoa ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Me horoi anō hoki ki te wai ngā kākahu katoa, me ngā hiako kei aua mea nei te purapura moenga, ka poke hoki aua mea ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ki te moe māori hoki tētahi tangata ki tētahi wahine, me horoi rāua ki te wai, ka poke hoki rāua ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Ā, ki te mea he rere tō tētahi wahine, ā, he toto te rere o tōna kikokiko, me whakamotuhake kia whitu ngā rā. Ka poke anō hoki ngā tāngata katoa e pā ana ki a ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“Ka poke anō ngā mea katoa e takotoria ana e ia i tōna whakamotuhaketanga; ka poke anō ngā mea katoa e noho ai ia. ");
INSERT INTO mri2012_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ki te pā hoki tētahi ki tōna moenga, me horoi e ia ōna kākahu, a ia ake anō hoki me horoi ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ki te pā atu hoki tētahi ki tētahi mea i noho ai ia, me horoi e ia ōna kākahu, a ia ake anō hoki me horoi ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ahakoa i runga taua mea i te moenga, i runga rānei i tētahi mea e nohoia ana e ia, ki te pā atu tētahi, ka poke ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“Ki te takoto hoki tētahi tangata ki a ia, ā, ka mau ki a ia ōna whakapoke, ka poke, e whitu ngā rā; ka poke katoa anō ngā moenga katoa e takoto ai ia. ");
INSERT INTO mri2012_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Ā, ki te maha ngā rā o te rerenga toto o tētahi wahine, ā, ehara i te wā e paheke ai, ki te roa atu rānei te rerenga i tō te wā e paheke ai; ka pērā anō me ngā rā o tōna paheketanga, ngā rā katoa e rere ai tōna whakapoke; ka poke ia. ");
INSERT INTO mri2012_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ka pērā anō ki a ia me te moenga o tōna paheketanga ngā moenga katoa e takoto ai ia i ngā rā katoa e rere ai; ka poke anō hoki ngā mea katoa e noho ai ia, ka rite ki te whakapoke o tōna paheketanga. ");
INSERT INTO mri2012_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ka poke anō hoki te tangata e pā ana ki aua mea, me horoi anō hoki e ia ōna kākahu, a ia ake anō hoki me horoi ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Otiia ki te mea kua whakapokekoretia taua wahine i te rere, kātahi ka taua e ia ngā rangi e whitu, ā muri iho ka kore ōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ā, i te waru o ngā rā me tiki e ia kia rua ngā kūkupa, kia rua rānei pī kūkupa māna, ā, ka kawea ki te tohunga, ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ā, me whakahere tētahi e te tohunga hei whakahere hara, me tētahi hoki hei tahunga tinana, ā, ka whakamārie te tohunga mōna ki te aroaro o Ihowā mō te rere o tōna whakapoke. ");
INSERT INTO mri2012_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Nā, me pēnā tā koutou wehe i ngā tama a Īharaira i ō rātou whakapoke; kei mate rātou i ō rātou poke, ina whakapokea e rātou tōku tapenākara e tū nā i roto i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ko te ture tēnei mō te tangata he rere tōna, mō te tangata hoki kua paheke atu tōna purapura moenga, ā poke iho; ");
INSERT INTO mri2012_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","mō te wahine hoki e paheke ana, mō te tangata hoki he rere tōna, mō te tāne rāua ko te wahine, mō te tangata hoki i takoto ki te wahine poke. ");
INSERT INTO mri2012_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ā, i kōrero a Ihowā ki a Mohi i muri i te matenga o ngā tama tokorua a Ārona, i te mea i whakahere nei rāua ki te aroaro o Ihowā, ā mate iho. ");
INSERT INTO mri2012_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","I kōrero anō a Ihowā ki a Mohi: “Kōrero ki a Ārona, ki tōu tuakana, kei haere i ngā wā katoa ki te wāhi tapu, ki roto i te ārai, i tērā i mua mai o te taupoki o te āka; kei mate; ka puta atu hoki ahau i roto i te kapua ki runga ki te taupoki. ");
INSERT INTO mri2012_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Ko ngā mea tēnei hei haerenga mō Ārona ki roto ki te wāhi tapu: ko te kūao pūru hei whakahere hara, me te hipi toa hei tahunga tinana. ");
INSERT INTO mri2012_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Me kākahu e ia te koti rīnena tapu; hei tōna kikokiko ngā tarau rīnena, me whītiki anō ki a ia te whītiki rīnena, me pōtae anō te pōtae rīnena; ko ngā kākahu tapu ēnei; mō reira me horoi e ia tōna kikokiko ki te wai, ka kākahu ai. ");
INSERT INTO mri2012_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Nā, ka mau ia ki ētahi koati kia rua a te whakaminenga o ngā tama a i Īharaira hei whakahere hara, kia kotahi hoki te hipi toa hei tahunga tinana. ");
INSERT INTO mri2012_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Ā, ka whakaherea e Ārona tāna pūru mō te whakahere hara, te mea hoki mōna, ā, ka whakamārie mōna, mō tōna whare hoki. ");
INSERT INTO mri2012_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Nā, ka mau ia ki ngā koati e rua, ka tāpae ki te aroaro o Ihowā ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Nā, ka makā he rota e Ārona mō ngā koati e rua, tētahi rota mō tā Ihowā, tētahi rota mō te koati haere noa. ");
INSERT INTO mri2012_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ā, ka kawea mai e Ārona te koati i puta nei tā Ihowā rota ki a ia, ā, ka whakaherea hei whakahere hara. ");
INSERT INTO mri2012_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ko te koati ia i puta nei te rota ki a ia hei koati haere noa, ka tāpaea oratia ki te aroaro o Ihowā, ki te whakamārie mōna, kia tukua ai ki te koraha hei koati haere noa. ");
INSERT INTO mri2012_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Ā, ka kawea e Ārona te pūru mō te whakahere hara, te mea mōna ake, ā, ka whakamārie mōna, mō tōna whare hoki, ā, ka patua te pūru mō te whakahere hara, te mea hoki mōna ake. ");
INSERT INTO mri2012_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Nā, ka mau ki te tahu kakara, kī tonu i ngā waro ahi nō runga i te āta, i te aroaro o Ihowā; kia kī hoki ōna ringa i te whakakakara reka, tuki rawa kia ririki, ka kawe ai ki roto i te ārai. ");
INSERT INTO mri2012_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Nā, ka maka i te whakakakara ki te ahi ki te aroaro o Ihowā, kia ngaro ai i te kapua whakakakara te taupoki i runga i te whakaaturanga, kei mate hoki ia. ");
INSERT INTO mri2012_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Nā, ka tango i tētahi wāhi o te toto o te pūru, ā, ka tāuhiuhia e tōna maihao ki te taupoki ki te taha ki te rāwhiti; kia whitu ngā tāuhiuhinga a tōna maihao i te toto ki te taha ki mua o te taupoki. ");
INSERT INTO mri2012_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Kātahi ka patua e ia te koati o te whakahere hara, te mea mō te iwi, ā, ka kawea ōna toto ki roto i te ārai, ā, ka pērā tāna meatanga ki taua toto, me tāna ki te toto o te pūru, ā, ka tāuhiuhia e ia ki te taupoki, ki mua hoki o te taupoki. ");
INSERT INTO mri2012_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ā, ka whakamārie mō te wāhi tapu, mō te poke o ngā tama a Īharaira, mō ā rātou mahi tutū i ō rātou haranga katoa. Kia pērā hoki tāna meatanga mō te tapenākara o te whakaminenga e tū ana i roto i a rātou waenganui o tō rātou poke. ");
INSERT INTO mri2012_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kaua anō hoki he tangata mō roto te tapenākara o te whakaminenga, ina haere ia ki te whakamārie i roto i te wāhi tapu, ā puta noa mai ki waho, kia oti rā anō te whakamārie mōna, mō tōna whare, mō te whakaminenga katoa anō hoki o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Nā, ka puta ia ki te āta, ki tērā i te aroaro o Ihowā, mea ai i tō reira whakamārie; ka tango hoki i tētahi wāhi o te toto o te pūru, o te toto hoki o te koati, ka pani ai ki ngā haona o te āta ā tawhio noa. ");
INSERT INTO mri2012_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Kia whitu hoki ngā tāuhiuhinga a tōna maihao i te toto, ā, ka purea, ka whakatapua, kia mā ai i te poke o ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Ā, ka oti tāna whakamārie mō te wāhi tapu, mō te tapenākara o te whakaminenga, mō te āta, nā, me kawe mai e ia te koati ora. ");
INSERT INTO mri2012_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Nā, ka popoki ngā ringa e rua o Ārona ki te mātenga o te koati ora, ka whāki ai i ngā kino katoa o ngā tama a Īharaira ki runga i a ia, i ā rātou mahi tutū katoa, me ō rātou hara katoa; me uta hoki ki runga ki te mātenga o te koati, ka tuku ai kia kawea ki te koraha e tētahi tangata e noho rite ana. ");
INSERT INTO mri2012_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Nā, ka mauria e te koati ō rātou kino katoa i runga i a ia ki tētahi whenua mokemoke; ā, ka tukua atu te koati ki te koraha. ");
INSERT INTO mri2012_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Nā, ka haere a Ārona ki roto ki te tapenākara o te whakaminenga, ā, ka unuhia atu ngā kākahu rīnena i kākahuria e ia i tōna haerenga ki roto ki te wāhi tapu, ka waiho hoki ki reira. ");
INSERT INTO mri2012_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Me horoi anō e ia tōna kikokiko ki te wai ki te wāhi tapu, ka kākahu ai i ōna kākahu, ā, ka puta mai ia ki waho, ka mea hoki i tāna tahunga tinana, i te tahunga tinana hoki a te iwi, hei whakamārie mōna, mō te iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Me tahu anō e ia te ngako o te whakahere hara ki runga ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Ko te kaituku hoki o te koati hei koati haere noa, me horoi e ia ōna kākahu, me horoi anō tōna kikokiko ki te wai, ā muri iho, ka haere mai ki te puni. ");
INSERT INTO mri2012_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ā, ko te pūru mō te whakahere hara, me te koati mō te whakahere hara, nō rāua nei ngā toto i kawea ki roto ki te wāhi tapu hei whakamārie, me mau ki waho o te puni; ā, ka tahuna ki te ahi ō rāua hiako, ō rāua kikokiko, me tō rāua paru. ");
INSERT INTO mri2012_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Nā, ko te kaitahu, me horoi ōna kākahu, me horoi anō tōna kikokiko ki te wai, ā muri iho, ka haere mai ki te puni. ");
INSERT INTO mri2012_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Hei tikanga pūmau anō tēnei mā koutou; i te whitu o ngā marama, i te tekau o ngā rā o te marama, me whakapōuri ō koutou wairua, kaua rawa tētahi mahi e mahia, e te tangata whenua, e te manene rānei i roto i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ko ā taua rangi hoki te tohunga whakamārie ai mō koutou, hei pure i a koutou i ō koutou hara katoa, kia mā ai koutou i te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hei hāpati okiokinga taua rā ki a koutou, me whakapōuri ō koutou wairua; hei tikanga pūmau. ");
INSERT INTO mri2012_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Me whakamārie anō te tohunga e whakawahia nei ia, e whakatohungatia hoki hei tohunga i muri i tōna pāpā, me kākahu anō ngā kākahu rīnena, ngā kākahu tapu, ");
INSERT INTO mri2012_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","me whakamārie ia mō te wāhi tapu, me whakamārie anō mō te tapenākara o te whakaminenga, mō te āta hoki; me whakamārie anō mō ngā tohunga, mō ngā tāngata katoa hoki o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Hei tikanga pūmau tēnei ki a koutou, kia whakamārie mō ngā tama a Īharaira, mō ō rātou hara katoa; kia kotahi meatanga i te tau.” Nā, ka meinga e ia tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Kōrero ki a Ārona, ki āna tama, ki ngā tama katoa a Īharaira, mea atu ki a rātou: Ko te mea tēnei i whakahau ai a Ihowā, i mea ai: ");
INSERT INTO mri2012_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ki te patua e tētahi tangata o te whare o Īharaira he kau, he reme, he koati rānei, i roto i te puni, ki te patua rānei e ia ki waho o te puni, ");
INSERT INTO mri2012_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ā, e kore e kawea ki te whatitoka o te tapenākara o te whakaminenga, kia whakaherea he whakahere ki a Ihowā ki mua i te tapenākara o Ihowā. Ka whakairia he toto ki taua tangata; kua whakaheke toto ia; ā, ka hātepea atu taua tangata i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","He mea kia kawea ai e ngā tama a Īharaira ā rātou patunga e whakaherea ana e rātou i te mata o te pārae, kia kawea ai hoki ki a Ihowā, ki te whatitoka o te tapenākara o te whakaminenga, ki te tohunga, ka patu ai hei whakahere mō te pai ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ā, ka tāuhiuhia te toto e te tohunga ki te āta a Ihowā i te whatitoka o te tapenākara o te whakaminenga, me tahu anō e ia te ngako hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ā, ka mutu ā rātou patunga tapu ki ngā rēwera i whāia nei e rātou, pūremu atu ai. Hei tikanga pūmau tēnei ki a rātou i ō rātou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Me kī atu anō ki a rātou: Ki te whakaherea e tētahi tangata o te whare o Īharaira, o ngā manene rānei i roto i a koutou, tētahi tahunga tinana, patunga tapu rānei, ");
INSERT INTO mri2012_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ā, e kore e kawea ki te whatitoka o te tapenākara o te whakaminenga, whakahere ai ki a Ihowā; inā, ka hātepea atu taua tangata i roto i tōna iwi.” ");
INSERT INTO mri2012_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Ki te kainga hoki tētahi toto e tētahi tangata o te whare o Īharaira, o ngā manene rānei i roto i a koutou; ka ū atu tōku mata ki taua wairua i kainga ai te toto, ā, ka hātepea atu e ahau i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kei roto hoki i te toto te oranga o te kikokiko; kua hoatu anō e ahau ki a koutou mō runga i te āta, hei whakamārie mō ō koutou wairua; ko te toto hoki, nā tōna ora, te mea hei whakamārie. ");
INSERT INTO mri2012_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Koia ahau i mea ai ki ngā tama a Īharaira: Kaua tētahi o koutou e kai toto, kaua anō hoki te manene i roto i a koutou e kai toto. ");
INSERT INTO mri2012_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Ki te whai hoki tētahi o ngā tama a Īharaira, o ngā manene rānei i roto i a koutou, ā, ka mau tētahi kīrehe, tētahi manu rānei e tika ana kia kainga; me riringi ōna toto, ka tanu ai ki te puehu. ");
INSERT INTO mri2012_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Nō te mea ko te toto o te kikokiko e kotahi katoa āna me te ora o te kikokiko; koia ahau i mea ai ki ngā tama a Īharaira: Kaua rawa e kainga te toto o tētahi kikokiko; ko te toto hoki te ora o ngā kikokiko katoa; ki te kainga e tētahi, ka hātepea atu. ");
INSERT INTO mri2012_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Ki te kainga hoki e tētahi te mea i mate māori, te mea rānei i haea e te kīrehe, ahakoa tangata whenua, iwi kē rānei, me horoi ōna kākahu, me ia anō me horoi ki te wai, ka poke hoki ā ahiahi noa; kātahi ka kore te poke. ");
INSERT INTO mri2012_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ā, ki te kāhore e horoia e ia, ki te kāhore hoki e horoia tōna tinana, nā, ka waha e ia tōna kino.” ");
INSERT INTO mri2012_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: Ko Ihowā ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kei rite ā koutou mahi ki ngā mahi a te whenua o Īhipa, i noho nā koutou. Kei rite hoki ā koutou mahi ki ngā mahi a te whenua o Kanaana, e kawea nei koutou e ahau ki reira. Kei haere i runga i ā rātou tikanga. ");
INSERT INTO mri2012_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Me mahi āku whakaritenga, kia mau ki āku tikanga, me haere hoki i reira; ko Ihowā ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Inā, kia mau ki āku tikanga, ki āku whakaritenga; ki te mahia hoki ēnā e te tangata, mā reira e ora ai. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Kaua tētahi o koutou e whakatata ki tētahi o ōna whanaunga tupu, hura ai i tō rātou kiri tahanga: Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“Kei hurahia e koe tōu pāpā, tōu whaea rānei, kia takoto tahanga; ko tōu whaea ia; kei hurahia e koe kia takoto tahanga. ");
INSERT INTO mri2012_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Kei hurahia e koe kia takoto tahanga te wahine a tōu pāpā; ko te wāhi takoto tahanga ia o tōu pāpā. ");
INSERT INTO mri2012_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Kei hurahia e koe kia takoto tahanga tōu tuahine, te tamāhine a tōu pāpā, te tamāhine rānei a tōu whaea, ahakoa i whānau ki te kāinga, i whānau rānei ki tētahi atu wāhi; kei hurahia rāua e koe kia takoto tahanga. ");
INSERT INTO mri2012_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Kei hurahia e koe kia takoto tahanga te tamāhine a tāu tama, te tamāhine rānei a tāu tamāhine, kei hurahia rāua e koe kia takoto tahanga; nōu hoki te wāhi o rāua i takoto tahanga nā. ");
INSERT INTO mri2012_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Kei takoto tahanga i a koe te tamāhine a te wahine a tōu pāpā, te whānau a tōu pāpā, he tuahine ia nōu, kei hurahia ia e koe kia takoto tahanga. ");
INSERT INTO mri2012_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Kei hurahia te tuahine o tōu pāpā kia takoto tahanga; he whanaunga tupu ia nō tōu pāpā. ");
INSERT INTO mri2012_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Kei hurahia e koe te tuakana, teina rānei, o tōu whaea kia takoto tahanga; he whanaunga tupu hoki ia nō tōu whaea. ");
INSERT INTO mri2012_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“Kei hurahia e koe kia takoto tahanga te teina, tuakana rānei, o tōu pāpā, kei whakatata koe ki tāna wahine; ko tōu whaea kēkē ia. ");
INSERT INTO mri2012_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“Kei hurahia e koe tāu hunaonga kia takoto tahanga; ko te wahine ia a tāu tama, kei hurahia ia e koe kia takoto tahanga. ");
INSERT INTO mri2012_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Kei hurahia e koe kia takoto tahanga te wahine a tōu tuakana, teina rānei; nō tōu tuakana, teina rānei, taua wāhi i takoto tahanga nā. ");
INSERT INTO mri2012_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Kei hurahia e koe kia takoto tahanga te wahine rāua ko tāna tamāhine, kaua anō e tangohia te tamāhine a tāna tama, te tamāhine rānei a tāna tamāhine, hura ai i a ia kia takoto tahanga; he whanaunga pū hoki rātou ki a ia; he mea kino tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“Kaua anō hoki e tangohia he wahine ki te taha o tōna tuakana, teina rānei, hei whakatetetete ki a ia; kaua ia e hurahia kia takoto tahanga, me te ora anō hoki tērā. ");
INSERT INTO mri2012_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Kaua anō hoki e whakatata ki te wahine ki te hura i a ia kia takoto tahanga, i a ia e poke ana i te paheketanga. ");
INSERT INTO mri2012_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Kaua anō hoki e takoto pūremu ki te wahine a tōu hoa, whakapoke ai i a koe ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Kaua anō e tukua tētahi o ōu uri kia haere nā waenga ahi hei mea ki a Moreke, kaua anō e whakanoatia te ingoa o tōu Atua. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Kei takotoria wahinetia te tāne; he mea whakarihariha tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Kaua anō hoki e takoto ki tētahi kararehe, whakapoke ai i a koe ki taua mea. Kaua hoki tētahi wahine e tū ki te aroaro o tētahi kararehe, takoto tahi ai rāua; he mea anuanu tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Kei poke koutou i tētahi o ēnei mea; e poke ana hoki i ēnei mea katoa ngā iwi ka peia nei e ahau i tō koutou aroaro. ");
INSERT INTO mri2012_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Kua poke anō hoki te whenua; koia ahau i mea ai kia tau iho tōna kino ki runga ki a ia; ā, e whakaruaki ana te whenua i ōna tāngata. ");
INSERT INTO mri2012_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Mō reira kia mau ki āku tikanga ki āku whakaritenga whakawā; kaua anō e mahia tētahi o ēnei mea whakarihariha e te tangata whenua, e te manene rānei i roto i a koutou ");
INSERT INTO mri2012_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(nō te mea kua mahia ēnei mea whakarihariha katoa e ngā tāngata whenua ō mua i a koutou, ā, poke iho te whenua); ");
INSERT INTO mri2012_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","kei whakaruakina anō hoki koutou e te whenua, ina poke i a koutou, pērā me ngā iwi e whakaruakina nei i tō koutou aroaro. ");
INSERT INTO mri2012_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“Ki te mahia hoki tētahi o ēnei mea whakarihariha e tētahi tangata, inā, ka hātepea atu ngā wairua e pēnā i roto i tō rātou iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Nō reira kia mau ki āku i whakahau atu ai, kei mahia e koutou tētahi o ēnei ritenga whakarihariha i mahia nei i mua i a koutou, kei poke hoki koutou i aua mea. Ko Ihowā ahau, ko tō koutou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Kōrero ki te whakaminenga katoa o ngā tama a Īharaira, mea atu ki a rātou: Kia tapu koutou; he tapu hoki ahau, a Ihowā, tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Me wehi tērā, tērā, ki tōna whaea, ki tōna pāpā, kia mau hoki ki āku hāpati: ko Ihowā ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Kei tahuri ki te whakapakoko, kei whakarewaina he atua mā koutou. Ko Ihowā ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Ki te whakaherea anō he patunga mō te pai ki a Ihowā, hei te patunga e manakohia ai koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Me kai i te rangi anō i whakaherea ai, i te aonga ake anō hoki; ā, ki te toe tētahi wāhi ki te toru o ngā rā, me tahu ki te ahi. ");
INSERT INTO mri2012_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ki te kainga hoki tētahi wāhi i te toru o ngā rā, ka whakariharihangia; e kore e manakohia. ");
INSERT INTO mri2012_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ā, ka waha ō rātou hara e ngā tāngata katoa i kainga ai, nō te mea kua whakanoatia te mea tapu a Ihowā; ā, ka hātepea atu taua tangata i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ina kotia e koutou ngā hua o tō koutou whenua, kaua e kotia rawatia ngā kokonga o tāu māra, kaua anō hoki e hamua ngā toenga o āu hua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kaua hoki e hamua tāu māra wāina, kaua anō e kohia ngā karepe taka o tāu māra wāina; me waiho mā te rawakore, mā te tangata iwi kē. Ko Ihowā ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Kaua e tāhae; kaua hoki e teka, kaua anō e tinihanga tētahi ki tētahi. ");
INSERT INTO mri2012_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kei oatitia tekatia hoki tōku ingoa, kaua anō hoki e whakanoatia te ingoa o tōu Atua. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Kaua e tūkinotia tōu hoa; kaua hoki e pāhuatia. “Kaua ngā utu o te kaimahi e takoto tonu ki a koe i te pō, ā tae noa ki te ata. ");
INSERT INTO mri2012_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Kaua e kangā te turi, kaua anō e makā he whakatūtuki ki te aroaro o te matapō; engari me wehi ki tōu Atua. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Kei whakahaere hē ina whakawā; kaua e whakaaro ki te kanohi o te rawakore, kaua hoki e whakahōnoretia te kanohi o te nui; me whakawā koe mō tōu hoa i runga i te tika. ");
INSERT INTO mri2012_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Kaua e kōpikopiko i roto i tōu iwi kawekawe kōrero ai; kaua anō hoki e tū kia whakahekea te toto o tōu hoa. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Kei kino koe ki tōu teina i roto i tōu ngākau; rīria mārietia tōu hoa, kaua e waiho he hara i runga i a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Kaua e rapu utu, kaua hoki e mauāhara ki ngā tamariki a tōu iwi; engari arohaina tōu hoa ānō ko koe. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Kia mau ki āku tikanga. Kaua e whakatupuria he uri mō āu kararehe ki tērā atu tū kararehe. Kaua e whakauruurua ngā purapura e whakatōngia e koe ki tāu māra. Kaua anō hoki e meatia ki a koe he kākahu ko tētahi wāhi he rīnena, ko tētahi he huruhuru. ");
INSERT INTO mri2012_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Ki te takoto pūremu hoki tētahi ki te wahine pononga kua oti te taumau mā te tāne, ki te mea kīhai i utua, i whakahokia, kīhai anō hoki i tukua kia haere noa atu; ka whiua rāua. E kore rāua e whakamatea, nō te mea kīhai ia i tukua kia haere noa atu. ");
INSERT INTO mri2012_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ā, me kawe e te tāne tāna whakahere mō te hē ki a Ihowā, ki te whatitoka o te tapenākara o te whakaminenga, he hipi toa hei whakahere mō te hē. ");
INSERT INTO mri2012_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ā, ka whakamārie te tohunga mōna ki te hipi toa, ki te whakahere mō te hē, ki te aroaro o Ihowā, mō tōna hara i hara ai; ā, ka murua tōna hara i hara ai. ");
INSERT INTO mri2012_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“E tae hoki koutou ki te whenua, ā, ka whakatōngia e koutou ngā rākau kai katoa; me waiho ngā hua hei mea kokotikore. Kia toru ngā tau e waiho ai e koutou hei mea kokotikore; e kore e kainga. ");
INSERT INTO mri2012_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","I te whā ia o ngā tau ka tapu ngā hua katoa o reira, hei whakamoemiti ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Engari i te rima o ngā tau me kai e koutou ngā hua o reira, ā, ka maha ake ōna hua mā koutou. Ko Ihowā ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Kaua e kainga tototia tētahi mea. Kaua anō hoki e rapu tikanga i ngā tohu, i ngā kapua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“Kaua e whakaporotakatia ngā taha o ō koutou māhunga, kaua anō hoki e whakaahuatia kinotia ngā taha o tōu pāhau. ");
INSERT INTO mri2012_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Kaua e haea ō koutou kikokiko mō te tūpāpaku, kaua anō hoki e tāia he tohu ki a koutou. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Kaua e whakanoatia tāu tamāhine, e meinga hei wahine kairau; kei riro te whenua i te kairau, ā, ka kī te whenua i te kino. ");
INSERT INTO mri2012_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Kia mau ki āku hāpati, kia hopohopo hoki ki tōku wāhi tapu. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Kaua e whakaaro atu ki ngā waka atua, kaua anō hoki e whai atu ki ngā mata māori, whakapokea ai e rātou. Ko Ihowā ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Me whakatika ake koe i te aroaro o te mātenga hina, me whakahōnore hoki te mata o te koroheke, me wehi anō hoki ki tōu Atua. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Ki te noho hoki te tangata iwi kē ki a koe, ki tōu whenua, kaua koutou e mahi i te kino ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ki tā koutou kia rite ki tētahi o ō koutou tangata whenua te manene e noho ana i a koutou, arohaina ia ānō ko koe; he manene hoki koutou i mua, i te whenua o Īhipa. Ko Ihowā ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Kei hē tā koutou whakahaere ina whakawā, i te rūri rānei, i te pāuna taimaha rānei, i te mēhua rānei. ");
INSERT INTO mri2012_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Kia tika ā koutou pāuna, kia tika ngā whakataimaha, kia tika te epa, kia tika hoki te hine. Ko Ihowā ahau, ko tō koutou Atua, i kawe mai nei i a koutou i te whenua o Īhipa. ");
INSERT INTO mri2012_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Mō reira kia mau ki āku tikanga katoa, me āku whakaritenga katoa, mahia anō hoki. Ko Ihowā ahau.” ");
INSERT INTO mri2012_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Me kōrero anō koe ki ngā tama a Īharaira: Ahakoa nō ngā tama a Īharaira, nō te manene rānei e noho ana i a Īharaira, te tangata i hoatu e ia tōna uri ki a Moreke, inā, me whakamate ia; me āki e ngā tāngata whenua ki te kōhatu. ");
INSERT INTO mri2012_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ka ū atu anō hoki tōku mata ki taua tangata, ā, ka hātepea atu e ahau i roto i tōna iwi; mōna i hoatu i tōna uri ki a Moreke, whakapoke ai i tōku wāhi tapu, whakanoa ai hoki i tōku ingoa tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ā, ki te hunā e ngā tāngata whenua ō rātou kanohi, kei kite i taua tangata, ina hoatu e ia tōna uri ki a Moreke, ā, e kore e whakamate i a ia; ");
INSERT INTO mri2012_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ko reira ū atu ai tōku mata ki taua tangata, ki ōna whanaunga hoki, ā, ka hātepea atu e ahau i roto i tō rātou iwi, a ia, me ngā tāngata katoa e whai ana i a ia, pūremu atu ai, pūremu ai ki a Moreke. ");
INSERT INTO mri2012_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Ki te tahuri anō tētahi wairua ki ngā waka atua, ki ngā mata māori, whai atu ai, pūremu atu ai ki a rātou, ka ū atu anō tōku mata ki taua wairua, ā, ka hātepea atu i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Engari whakatapua koutou, kia tapu anō hoki; ko Ihowā hoki ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ā, kia mau ki āku tikanga, me mahi anō hoki; ko Ihowā ahau e whakatapu nei i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Ki te kangā hoki e tētahi tōna pāpā, tōna whaea rānei, me whakamate rawa; kua kanga e ia tōna pāpā, whaea rānei; ko runga anō i a ia ōna toto. ");
INSERT INTO mri2012_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Ā, ki te pūremu tētahi ki te wahine a te tangata, me whakamate rawa te kaipūremu ki te wahine a tōna hoa, te kaipūremu rāua ko te wahine i pūremutia. ");
INSERT INTO mri2012_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“Me te tangata hoki i takoto ki te wahine a tōna pāpā, kua hurahia e ia tōna pāpā kia takoto tahanga; me whakamate rāua tokorua, ko runga i a rāua ō rāua toto. ");
INSERT INTO mri2012_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Ki te takoto hoki te tangata ki tāna hunaonga wahine, me whakamate rawa rāua tokorua; he mahi anuanu tā rāua; ko runga i a rāua ō rāua toto. ");
INSERT INTO mri2012_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Ki te takoto hoki he tāngata ki a rāua whakatāne ki te pērā me te takoto ki te wahine, he mahi whakarihariha tā rāua, me whakamate rawa rāua; ko runga i a rāua ō rāua toto. ");
INSERT INTO mri2012_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Ki te tango hoki te tangata i te wahine rāua ko tōna whaea, he mea kino tēnā. Me tahu rātou ki te ahi, te tāne me ngā wāhine; kei whai kino koutou i roto i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Ki te takoto hoki te tangata ki te kararehe, me whakamate rawa ia; me whakamate anō hoki te kararehe. ");
INSERT INTO mri2012_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Ki te whakatata hoki te wahine ki tētahi kararehe, ā, ka takoto ki a ia, me whakamate e koe te wahine rāua ko te kararehe; me whakamate rawa rāua, ko runga i a rāua ō rāua toto. ");
INSERT INTO mri2012_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Ki te tango hoki te tangata i tōna tuahine, i te tamāhine a tōna pāpā, i te tamāhine rānei a tōna whaea, ā, ka kite i a ia e takoto tahanga ana, ā, ka kite anō te wahine i a ia e takoto tahanga ana. He mea kino tēnā; ā, ka hātepea atu rāua i te tirohanga a ngā tamariki o tō rāua iwi. Nāna hoki i hura tōna tuahine kia takoto tahanga; ka waha e ia tōna kino. ");
INSERT INTO mri2012_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Ki te takoto hoki te tangata ki te wahine i a ia e paheke ana, ā, ka hura i a ia kia takoto tahanga; kua takoto kau i a ia tōna puna, kua whakaaturia anō e te wahine te puna o ōna toto; ā, ka hātepea atu rāua i roto i tō rāua iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Kaua anō e hurahia kia takoto tahanga te teina, tuakana rānei, o tōu whaea, te tuahine rānei o tōu pāpā. E hurahia ana hoki e ia tōna whanaunga tupu; ka waha e rāua tō rāua kino. ");
INSERT INTO mri2012_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Ki te takoto hoki he tangata ki te wahine a tōna matua kēkē, kua hurahia e ia kia takoto tahanga tōna matua kēkē. Ka waha e rāua tō rāua hara; ka mate urikore rāua. ");
INSERT INTO mri2012_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“Ki te tango hoki te tangata i te wahine a tōna tuakana, teina rānei, he mea poke tēnā. Kua hurahia e ia tōna tuakana, teina rānei, kia takoto tahanga; e kore rāua e whai tamariki. ");
INSERT INTO mri2012_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Engari kia mau ki āku tikanga katoa me āku whakaritenga katoa, me mahi anō hoki; kei whakaruakina koutou e te whenua ka kawea nei koutou e ahau ki reira noho ai. ");
INSERT INTO mri2012_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kaua anō e haere i runga i ngā ritenga o te iwi ka peia nei e ahau i tō koutou aroaro; nā rātou hoki ēnei mahi katoa, koia i whakarihariha ai ahau ki a rātou, ");
INSERT INTO mri2012_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","i mea ai hoki ki a koutou: Ka riro tō rātou whenua i a koutou, ka hoatu hoki e ahau ki a koutou hei kāinga pūmau, he whenua e rerengia ana e te waiū, e te honi. Ko Ihowā ahau, ko tō koutou Atua, i wehe mai nei i a koutou i roto i ngā iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Mō reira me wehe kē e koutou ngā kararehe pokekore me ngā mea poke, ngā manu hoki, ngā mea poke me ngā mea pokekore kei ai hei take whakarihariha mō ō koutou wairua tētahi kararehe, manu rānei, tētahi mea rānei e ngahue ana i te whenua, o ngā mea i wehea atu e ahau i a koutou hei mea poke. ");
INSERT INTO mri2012_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ā, ka tapu koutou ki ahau; nō te mea he tapu ahau, a Ihowā, ā, kua wehea mai koutou e ahau i roto i ngā iwi, kia waiho māku. ");
INSERT INTO mri2012_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Me whakamate rawa anō hoki te tangata, te wahine rānei, he atua māori tōna; me te mata māori hoki. Me āki rāua ki te kōhatu; ko runga i a rāua ō rāua toto.” ");
INSERT INTO mri2012_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","I mea anō a Ihowā ki a Mohi: “Kōrero ki ngā tohunga, ki ngā tama a Ārona, mea atu ki a rātou: Kaua tētahi e whakapoke i a ia mō te tūpāpaku o tōna iwi; ");
INSERT INTO mri2012_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","engari, mō tōna whanaunga, mō te mea e tata ana ki a ia, mō tōna whaea, mō tōna pāpā, mō tāna tama, mō tāna tamāhine, mō tōna tuakana, teina rānei, ");
INSERT INTO mri2012_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","mō tōna tuahine hoki, ki te mea he wāhina, he mea e tata ana ki a ia, ā, kāhore āna tāne; e āhei ana kia poke ia mōna. ");
INSERT INTO mri2012_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kaua ia, he ariki nei nō tōna iwi, e whakapoke i a ia kia noa. ");
INSERT INTO mri2012_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Kaua e whakatiwhaia ō rātou mātenga, kaua hoki e heua ngā taha o ō rātou pāhau, kaua anō hoki e haea tō rātou kikokiko. ");
INSERT INTO mri2012_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kia tapu rātou ki tō rātou Atua, kaua hoki e whakanoatia te ingoa o tō rātou Atua; nō te mea ko rātou hei whakahere i ngā whakahere ahi a Ihowā, i te kai a tō rātou Atua; mō reira kia tapu rātou. ");
INSERT INTO mri2012_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Kaua rātou e tango i te wahine kairau, i te mea noa rānei, hei wahine; kaua anō hoki rātou e tango i te wahine i whakarērea e tāna tāne; he tangata tapu hoki ia nā tōna Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mō reira me whakatapu ia e koe, māna hoki e whakahere te kai a tōu Atua; kia tapu ia ki a koe; he tapu hoki ahau, a Ihowā, tōu kaiwhakatapu. ");
INSERT INTO mri2012_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Me te tamāhine hoki a tētahi tohunga, ki te whakanoa ia i a ia, ki te kairau, kua whakanoatia e ia tōna pāpā; me tahu ki te ahi. ");
INSERT INTO mri2012_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Me te tino tohunga hoki i roto i ōna tēina, te tangata i ringihia nei tōna mātenga ki te hinu whakawahi, ā, i whakatohungatia hei kākahu i ngā kākahu, kaua e tukua e ia ōna makawe kia mahora noa, kaua anō hoki e haea ōna kākahu. ");
INSERT INTO mri2012_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kaua hoki ia e haere atu ki tētahi tūpāpaku mate, kaua anō hoki ia e whakapoke i a ia mō tōna pāpā, mō tōna whaea rānei. ");
INSERT INTO mri2012_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kaua hoki ia e haere ki waho o te wāhi tapu, kei noa i a ia te wāhi tapu o tōna Atua; kei runga hoki i a ia te karauna o te hinu whakawahi o tōna Atua. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Me tango anō hoki e ia he wahine i tōna wāhinatanga. ");
INSERT INTO mri2012_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","He pouaru, he wahine rānei i whakarērea, he wahine noa rānei, he wahine kairau rānei, kaua ēnei e tangohia e ia. Engari, me tango e ia he wāhina i roto i tōna iwi ake hei wahine, ");
INSERT INTO mri2012_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","kaua hoki e whakanoatia e ia ōna uri i roto i tōna iwi: ko Ihowā hoki ahau te whakatapu nei i a ia.” ");
INSERT INTO mri2012_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Kōrero ki a Ārona, mea atu: Ki te mea he koha tō tētahi o ōu uri i ō rātou whakatupuranga, kaua ia e whakatata mai ki te whakahere i te kai a tōna Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Kaua hoki e whakatata mai tētahi tangata he koha tōna: te matapō, te kopa, te tangata he ihu parehe tōna, i hira ake rānei tētahi wāhi ōna, ");
INSERT INTO mri2012_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","te tangata rānei i whati te waewae, i whati rānei te ringa, ");
INSERT INTO mri2012_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","te tuarā piko rānei, te mea i pūwhenua te tupu, ki te papahewa, rānei tōna kanohi, ki te mea rānei he pāpaka, he hakihaki rānei tōna, ki te mea rānei kua kōmurumurua ōna mea. ");
INSERT INTO mri2012_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Kaua tētahi o ngā uri o te tohunga, o Ārona, ki te mea he koha tōna, e whakatata mai ki te whakahere i ngā whakahere ahi a Ihowā; he koha tōna, kaua ia e whakatata ki te whakahere i te kai a tōna Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Me kai e ia te kai a tōna Atua, te mea tapu rawa, me te mea tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Otiia kaua ia e haere ki te ārai, e whakatata rānei ki te āta; he koha hoki tōna; kei noa i a ia ōku wāhi tapu. Ko Ihowā hoki ahau te whakatapu nei i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ko ngā kōrero ēnei a Mohi ki a Ārona rātou ko āna tama, ki ngā tama katoa anō hoki a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Kōrero ki a Ārona rātou ko āna tama kia wehea rātou i ngā mea tapu a ngā tama a Īharaira, e whakatapua ana e rātou māku kei noa tōku ingoa tapu. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Mea atu ki a rātou: Ki te whakatata tētahi o ō koutou uri katoa, puta noa i ō koutou whakatupuranga, ki ngā mea tapu e whakatapua ana e ngā tama a Īharaira mā Ihowā, me te mau anō tōna poke, ka hātepea atu taua wairua i tōku aroaro. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Ki te mea he repera tētahi o ngā uri o Ārona, ki te mea rānei he rere tōna; kei kainga e ia ngā mea tapu; kia kore rā anō ōna poke. Ki te pā hoki tētahi ki te mea i poke i te tūpāpaku, ki te tangata rānei kua paheke atu tōna purapura moenga; ");
INSERT INTO mri2012_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ki te pā rānei tētahi ki te mea ngōki, e poke ai ia, ki te tangata rānei e poke ai ia, ahakoa he aha rānei, he aha rānei, tōna poke. ");
INSERT INTO mri2012_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ka poke ā ahiahi noa te tangata i pā ki taua mea, kaua anō hoki ia e kai i ngā mea tapu, ki te kāhore i horoia e ia tōna kikokiko ki te wai. ");
INSERT INTO mri2012_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ā, ka tō te rā, ka kore ōna poke; ā muri iho, ka kai i ngā mea tapu, nō te mea ko tāna kai tēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","He mea mate māori, i haea rānei e te kīrehe, kaua tēnā e kainga e ia, kei poke. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Inā, kia mau rātou ki tāku i whakarite ai, kei whai hara, ā, ka mate ki te whakanoatia e rātou. Ko Ihowā ahau te whakatapu nei i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Kaua tētahi manene e kai i te mea tapu. Kaua te tangata e noho ana ki te tohunga, te kaimahi rānei, e kai i te mea tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Otiia, ki te hokona tētahi tangata e te tohunga ki tāna moni, e kai anō ia; me ngā tāngata anō i whānau ki tōna whare, e kai anō rātou i tāna kai. ");
INSERT INTO mri2012_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","He tamāhine hoki nā te tohunga kua riro i te tangata iwi kē, kaua ia e kai i te whakahere poipoi o ngā mea tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Otiia, ki te mea he pouaru te tamāhine a te tohunga, i whakarērea atu rānei, ā, kāhore āna tamariki, kua hoki mai anō ki te whare o tōna pāpā, kua pērā me ia i tōna taitamāhinetanga, e kai anō ia i te kai a tōna pāpā; kaua ia te tangata kē e kai. ");
INSERT INTO mri2012_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Ā, ki te kai pōhēhē te tangata i te mea tapu, me tāpiri e ia te whakarima o taua mea, ā, ka hōmai tahi me te mea tapu ki te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kei whakanoatia e rātou ngā mea tapu a ngā tama a Īharaira, e whakaherea ana mā Ihowā; ");
INSERT INTO mri2012_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","kei meinga rātou kia whakawaha i te kino o te hē, ina kai i ā rātou mea tapu. Ko Ihowā hoki ahau te whakatapu nei i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Kōrero ki a Ārona, ki āna tama, ki ngā tama katoa anō a Īharaira, mea atu ki a rātou: Ko te tangata o te whare o Īharaira, o ngā manene rānei i roto i a Īharaira, e mea ana ki te tāpae i tāna whakahere, he kī taurangi, he mea tuku noa rānei nāna, tā rātou e tāpae ai ki a Ihowā hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kia manakohia ai koutou, ko tā koutou e tāpae ai hei te toa kohakore, nō roto i ngā kau, i ngā hipi rānei, i ngā koati rānei. ");
INSERT INTO mri2012_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kaua rawa ia e whakaherea tētahi mea he koha tōna; nō te mea e kore e manakohia hei mea mā koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Ki te whakaherea anō hoki e tētahi he patunga mō te pai ki a Ihowā, hei whakamana mō te kī taurangi, hei whakahere tuku noa ake rānei, he kau, he hipi rānei, hei te mea kohakore, kia manakohia ai; kei whai koha. ");
INSERT INTO mri2012_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","He matapō, he whati, he kopa, kua whai puku, he pāpaka, he mea hakihaki rānei – kaua ēnā e whakaherea mā Ihowā, kaua anō e hōmai hei whakahere ahi ki runga ki te āta mā Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","He pūru he reme rānei, e hira ake ana, kua kore rānei tētahi wāhi ōna, e whakaherea anō tēnā e koe hei whakahere noa ake; otiia e kore e manakohia mō te kī taurangi. ");
INSERT INTO mri2012_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Kaua e whakaherea mā Ihowā te mea i romia, te mea rānei i kurua, i unuhia rānei, i pokaia rānei; kaua anō hoki e pēnā i tō koutou whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Kaua anō hoki tētahi o ēnei e tāpaea hei kai mā tō koutou Atua, ina hōmai e te tangata iwi kē; he whakahē hoki kei roto, he koha kei roto. E kore ēnei e manakohia hei mea mā koutou.” ");
INSERT INTO mri2012_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ka whānau he kau, he hipi, he koati rānei, kia whitu ngā rā e waiho ai ki tōna whaea; ā, i te waru o ngā rā, i ō muri iho hoki, ka manakohia hei whakahere ahi mā Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Otiia, ahakoa he kau, he hipi rānei, kaua rāua ko tāna kūao e patua i te rangi kotahi. ");
INSERT INTO mri2012_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Ka patua anō e koutou he patunga whakawhetai ki a Ihowā, hei te patunga e manakohia ai koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Me kai i taua rangi anō; kaua e waiho tētahi wāhi ki te ata. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Nā, kia mau ki āku whakahau, mahia hoki. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kaua anō e whakanoatia tōku ingoa tapu; engari me whakatapu ahau i roto i ngā tama a Īharaira. Ko Ihowā ahau te whakatapu nei i a koutou, ");
INSERT INTO mri2012_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","i whakaputa mai nei hoki i a koutou i te whenua o Īhipa, kia waiho ai hei Atua mō koutou. Ko Ihowā ahau.” ");
INSERT INTO mri2012_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: Ko ngā hākari nunui a Ihowā, e karangatia e koutou hei huihuinga tapu, ko ēnei āku hākari.” ");
INSERT INTO mri2012_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“E ono ngā rā e mahia ai te mahi; ko te whitu ia o ngā rā he hāpati okiokinga, he huihuinga tapu. Kaua tētahi mahi e mahia; he hāpati tēnā nō Ihowā, i ō koutou nohoanga katoa. ");
INSERT INTO mri2012_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Ko ngā hākari nunui ēnei a Ihowā, ko ngā huihuinga tapu e karangatia e koutou i ngā wā e rite ai. ");
INSERT INTO mri2012_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Kei te marama tuatahi, kei te tekau mā whā o te mārama, i te ahiahi, ko te Kapenga a Ihowā, ");
INSERT INTO mri2012_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ā, i te tekau mā rima o ngā rā o taua marama anō ko te Hākari Taro Rēwenakore a Ihowā; e whitu ngā rā e kai ai koutou i te taro rēwenakore. ");
INSERT INTO mri2012_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Hei te rā tuatahi he huihuinga tapu mā koutou; kaua tētahi mahi a te kaimahi e mahia. ");
INSERT INTO mri2012_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Engari, kia whitu ngā rā e whakahere ai koutou i te whakahere ahi mā Ihowā; ā, i te whitu o ngā rā he huihuinga tapu; kaua e mahia tētahi mahi a te kaimahi.” ");
INSERT INTO mri2012_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: E tae koutou ki te whenua e hoatu e ahau ki a koutou, ā, ka kotia ōna hua, me kawe mai tētahi paihere o ngā hua mataati o tā koutou kotinga ki te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ā, māna e poipoi te paihere ki te aroaro o Ihowā, kia manakohia ai mō koutou; me poipoi e te tohunga i te aonga ake o te hāpati. ");
INSERT INTO mri2012_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Me whakahere anō hoki i te rā e poipoia ai e koutou te paihere, he reme toa, hei te mea kohakore, hei te tau tahi, hei tahunga tinana ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ā, ko te whakahere totokore, kia rua ngā whakatekau o te epa parāoa, he mea konatu ki te hinu, hei whakahere ahi mā Ihowā, hei kakara reka; me wāina hoki tōna ringihanga, ko te whakawhā o te hine. ");
INSERT INTO mri2012_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kaua anō hoki e kai i te taro, i te mea pāhūhū, i ngā puku hou rānei, kia taea rā anō te tino rā e kawea ai te whakahere ki tō koutou Atua. He tikanga pūmau mā ō koutou whakatupuranga i ō koutou nohoanga katoa.” ");
INSERT INTO mri2012_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Me tatau anō e koutou i te aonga ake o te hāpati, i te rā i kawea ai te paihere mō te whakahere poipoi; kia tino rite ngā hāpati e whitu. ");
INSERT INTO mri2012_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Kia tae rā anō ki te aonga ake o te whitu o ngā hāpati tā koutou tatau i ngā rā e rima tekau; ka whakahere ai koutou i te whakahere totokore, i te mea hou ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Me kawe mai e koutou i roto i ō koutou nohoanga, kia rua ngā taro poipoi e rua nei ō rāua whakatekau o te epa; he mea parāoa, he mea i tunua rēwenatia, ā, ko ngā tūāpora ēnā mā Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Me whakahere tahi anō me te taro kia whitu ngā reme, hei te mea kohakore, hei te tau tahi, me tētahi pūru kūao, me ngā hipi toa e rua. Hei tahunga tinana ēnā ki a Ihowā, te whakahere totokore anō hoki, me ngā ringihanga, hei whakahere ahi, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Nā, ka whakaherea tētahi koati toa hei whakahere hara, kia rua anō hoki ngā reme toa, hei te tau tahi, hei patunga mō te pai. ");
INSERT INTO mri2012_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Me poipoi ngātahi e te tohunga me te taro o ngā tūāpora, hei whakahere poipoi, ki te aroaro o Ihowā, me ngā reme e rua; ka tapu ēnā ki a Ihowā mā te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Me karanga anō i taua tino rā he huihuinga tapu mā koutou; kaua e mahia tētahi mahi a te kaimahi. He tikanga pūmau i ō koutou nohoanga katoa, mā ō koutou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Ā, ka kotia ngā hua o tō koutou whenua, kaua e tino whakapotoa ngā kokonga o tāu māra ina kotia e koe, kaua anō hoki e hamua ngā toenga o āu hua; me waiho mā te rawakore, mā te manene. Ko Ihowā ahau, ko tō koutou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Kōrero ki ngā tama a Īharaira, mea atu: Hei te whitu o ngā marama, hei te tuatahi o te marama, he hāpati mā koutou, he whakamaharatanga, he whakatangihanga tētere, he huihuinga tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Kaua e mahia tētahi mahi a te kaimahi; engari me whakahere he whakahere ahi mā Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ko te tekau anō hoki o tēnei marama, o te whitu, hei Rā Whakamārietanga; hei huihuinga tapu tēnā mā koutou. Me whakapōuri hoki ō koutou wairua; me whakahere anō hoki he whakahere ahi ki a Ihowā; ");
INSERT INTO mri2012_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ā, kaua rawa e mahia he mahi i taua rangi; he Rā Whakamārie hoki tēnā, e meinga ai he whakamārie mō koutou ki te aroaro o Ihowā, o tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Nā, ko te wairua e kore e whakapōuritia i taua rā, ka hātepea atu i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ki te mahia hoki e tētahi wairua tētahi mahi i taua rā, ka whakangaromia e ahau taua wairua i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Kei mahia tētahi mahi, he tikanga pūmau tēnā mā ō koutou whakatupuranga i ō koutou nohoanga katoa. ");
INSERT INTO mri2012_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hei hāpati okiokinga tēnā mō koutou, me whakapōuri ō koutou wairua; me whakahāpati tā koutou hāpati i te iwa o te marama i te ahiahi; i te ahiahi ā tae noa ki tētahi ahiahi.” ");
INSERT INTO mri2012_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Kōrero ki ngā tama a Īharaira, mea atu: Ko te kotahi tekau mā rima o ngā rā o tēnei marama, o te whitu, te Hākari Whare Wharau ki a Ihowā, kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Hei te rā tuatahi he huihuinga tapu; kaua e mahia tētahi mahi a te kaimahi. ");
INSERT INTO mri2012_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","E whitu ngā rā e whakahere ai koutou i te whakahere ahi ki a Ihowā; hei te rā waru he huihui tapu mō koutou; ā, ka whakahere he whakahere ahi ki a Ihowā; he huihui nui tēnā, kaua te mahi a te kaimahi e mahia. ");
INSERT INTO mri2012_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Ko ngā hākari ēnei a Ihowā e karangatia e koutou hei huihui tapu, hei whakaherenga mō te whakahere ahi ki a Ihowā, mō te tahunga tinana, mō te whakahere totokore, mō te patunga tapu, mō ngā ringihanga, tēnei mea i tōna rangi, tēnei mea i tōna rangi. ");
INSERT INTO mri2012_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Hāunga ngā hāpati a Ihowā, hāunga ā koutou mea hōmai noa, hāunga ā koutou kī taurangi katoa, hāunga ā koutou whakahere tuku noa katoa e hōmai ana ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“I te tekau mā rima hoki o ngā rā o te whitu o ngā marama, ina poto i a koutou te kohikohi ngā hua o te whenua, me whakarite e koutou he hākari ki a Ihowā, kia whitu ngā rā. Ko te rā tuatahi hei hāpati, ko te rā tuawaru hoki hei hāpati. ");
INSERT INTO mri2012_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Nā, i te rā tuatahi ka mau ki ngā peka rākau papai, ki ngā peka nīkau, ki ngā peka hoki o ngā rākau pūruru, ki ngā wirou o te awa; ā, ka koa koutou ki te aroaro o Ihowā, o tō koutou Atua, kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kia whitu hoki ngā rā o te tau e whakarite ai koutou i te hākari ki a Ihowā. Hei tikanga pūmau tēnei, puta noa i ō koutou whakatupuranga; ko ā te whitu o ngā marama whakaritea ai e koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Kia whitu ngā rā e noho ai koutou i roto i ngā wharau; ko ngā tāngata whenua katoa o Īharaira me noho i roto i ngā wharau. ");
INSERT INTO mri2012_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Kia mōhio ai ō koutou whakatupuranga i meinga e ahau ngā tama a Īharaira kia noho i roto i ngā wharau, i tāku whakaputanga mai i a rātou i te whenua o Īhipa. Ko Ihowā ahau, ko tō koutou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Nā, ka kōrerotia atu e Mohi ngā hākari a Ihowā ki ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Whakahaua ngā tama a Īharaira kia kawea e rātou ki a koe, he hinu ōriwa, hei te mea parakore, hei te mea tuki, mō te whakamārama, kia kā tonu ai ngā rama. ");
INSERT INTO mri2012_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Me whakapai tonu tēnā e Ārona ki waho o te ārai o te whakaaturanga, i roto i te tapenākara o te whakaminenga, ki te aroaro o Ihowā, i te ahiahi ā tae noa ki te ata; he tikanga pūmau, mā ō koutou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Me whakapai tonu e ia ngā rama i runga i te tūranga parakore o ngā rama ki te aroaro o Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Me tiki anō e koe he parāoa pai, ka tunu ai kia tekau mā rua ngā keke; kia rua ngā whakatekau o te epa ki te keke kotahi. ");
INSERT INTO mri2012_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ka whakatakoto ai e koe, kia rua ngā rārangi, kia ono ki te rārangi kotahi, ki runga ki te tēpu parakore i te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Me maka anō hoki e koe he parakihe parakore ki runga i tētahi rārangi, i tētahi rārangi, kia ai taua mea i runga i te taro hei whakamahara, hei whakahere ahi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Me whakarārangi tonu e ia, i tēnei hāpati, i tēnei hāpati, ki te aroaro o Ihowā, he mea mō ngā tama a Īharaira; hei kawenata pūmau. ");
INSERT INTO mri2012_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ā, mā Ārona rātou ko āna tama tēnā; me kai e rātou ki te wāhi tapu; he tino tapu hoki tēnā māna i roto i ngā whakahere ahi a Ihowā; hei tikanga pūmau.” ");
INSERT INTO mri2012_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ā, i haere atu i roto i ngā tama a Īharaira tētahi tama a tētahi wahine o Īharaira, ko tōna pāpā nō Īhipa; nā, ka whawhai tēnei tama a te wahine o Īharaira ki tētahi tangata o Īharaira i roto i te puni. ");
INSERT INTO mri2012_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Nā, ka kohukohu te tama a te wahine o Īharaira i te ingoa o Ihowā, ka kanga hoki. Ā, kawea ana ia e rātou ki a Mohi, ā, ko te ingoa o tōna whaea ko Heromiti, he tamāhine nā Tipiri, nō te iwi o Rāna. ");
INSERT INTO mri2012_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Nā, ka hoatu ia e rātou kia tiakina, mā te kupu hoki a Ihowā te tikanga ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Nā, ka kōrero a Ihowā ki a Mohi, ka mea: ");
INSERT INTO mri2012_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Kawea te tangata i kanga rā ki waho o te puni; ā, ko ngā tāngata katoa i rongo i a ia, me popoki ō rātou ringa ki tōna mātenga, ka āki ai te whakaminenga katoa i a ia ki te kōhatu. ");
INSERT INTO mri2012_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Me kōrero anō e koe ki ngā tama a Īharaira, me kī atu: Ki te kanga tētahi tangata i tōna Atua, ka waha e ia tōna hara. ");
INSERT INTO mri2012_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ā, ko te tangata e kohukohu i te ingoa o Ihowā, me tino whakamate ia; me tino āki ia e te whakaminenga ki te kōhatu. Ko te manene rāua tahi ko te tangata whenua ka whakamatea, ina kohukohua e ia te ingoa o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Ki te whakamate hoki tētahi i tētahi tangata me tino whakamate anō ia. ");
INSERT INTO mri2012_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ki te whakamate hoki tētahi i te kararehe, me utu e ia; he kararehe mō te kararehe. ");
INSERT INTO mri2012_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ki te mate hoki i te tangata tētahi wāhi o tōna hoa; me mea ki a ia tāna i mea ai: ");
INSERT INTO mri2012_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","he whati mō te whati, he kanohi mō te kanohi, he niho mō te niho; ko te mate i meatia e ia ki te tangata, me mea anō ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ki te whakamate hoki tētahi i te kararehe, me utu e ia; ki te whakamate hoki tētahi i te tangata, me whakamate anō ia. ");
INSERT INTO mri2012_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kia kotahi anō tā koutou whakawā mō te manene, mō te tangata whenua. Ko Ihowā hoki ahau, ko tō koutou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Nā, ka kōrero a Mohi ki ngā tama a Īharaira, ā, kawea ana e rātou ki waho o te puni te tangata nāna te kanga, ā, ākina ana hoki ki te kāmaka. Ā, meatia ana e ngā tama a Īharaira tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","I kōrero anō a Ihowā ki a Mohi i Maunga Hinai, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: E tae koutou ki te whenua e hoatu e ahau ki a koutou, nā, ka whakahāpati te whenua i tētahi hāpati ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","E ono ngā tau e whakatōngia ai e koe tāu māra, e ono hoki ngā tau e tapatapahia ai e koe tāu māra wāina, e kohia ai hoki ōna hua; ");
INSERT INTO mri2012_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ko te whitu ia o ngā tau hāpati okiokinga mō te whenua, hei hāpati ki a Ihowā. Kaua e whakatōngia tāu māra, e tapatapahia rānei tāu māra wāina. ");
INSERT INTO mri2012_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kaua e kotia te mea i tupu noa ake i tērā kotinga āu, kaua anō e whakia ngā karepe o tāu wāina kīhai nei i mahia; he tau okiokinga hoki tēnā mō te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ā, hei kai mā koutou te hāpati o te whenua – māu, mā tāu pononga tāne, mā tāu pononga wahine, mā tāu kaimahi, mā tōu manene hoki e noho ana i a koe; ");
INSERT INTO mri2012_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","mā āu kararehe hoki, mā te kīrehe hoki o tōu whenua, ōna hua katoa, hei kai.” ");
INSERT INTO mri2012_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Ā, me tatau e koe kia whitu ngā tau hāpati, kia whitu ngā whitu o ngā tau; ā, ko taua takiwā, ko ngā tau hāpati e whitu, ka kīia e koe e whā tekau mā iwa tau. ");
INSERT INTO mri2012_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Kātahi ka whakatangihia e koe te tētere tangi nui i te tekau o ngā rā o te whitu o ngā marama – ko ā te Rā Whakamārietanga – mea ai koutou kia pakū atu te tangi o te tētere puta noa i tō koutou whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ā, me whakatapu te rima tekau o ngā tau, ka karanga ai i te haere noa puta noa i te whenua mā ngā tāngata katoa o te whenua; hei Tiupiri nui tēnā mā koutou; ā, me hoki koutou ki tōna kāinga, ki tōna kāinga, me hoki anō ki ōna whanaunga, ki ōna whanaunga. ");
INSERT INTO mri2012_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ko tēnā tau, ko te rima tekau, hei Tiupiri mā koutou: kaua e rui, kaua e kokoti i te mea tupu noa ake o tēnā tau, kaua hoki e whakia ngā wāina kīhai i mahia. ");
INSERT INTO mri2012_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ko te Tiupiri hoki ia; kia tapu ki a koutou; ko ōna hua o te māra hei kai mā koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Me hoki koutou i tēnei tau Tiupiri, ki tōna kāinga, ki tōna kāinga. ");
INSERT INTO mri2012_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ki te hokona atu anō e koe tētahi mea ki tōu hoa, ki te hokona mai rānei tētahi mea e te ringa o tōu hoa, kaua e tūkinotia tētahi e tētahi. ");
INSERT INTO mri2012_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kia rite āu utu ki tōu hoa ki te maha o ngā tau i muri i te Tiupiri; kia rite anō ki te maha o ngā tau hua tāna hoko ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kia rite tāu whakanui i te utu o taua mea ki te maha o ngā tau, kia rite hoki tāu whakaiti i ōna utu ki te torutoru o ngā tau; e rite ana hoki ki te maha o ngā tau hua tāna hoko ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ā, kaua e tūkino tētahi ki tētahi, engari e wehi koe ki tōu Atua. Ko Ihowā hoki ahau, ko tō koutou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Mō reira me mahi e koutou āku tikanga, me pupuru āku whakaritenga, me mahi hoki; ā, ka noho hūmārie koutou i runga i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ā, ka tukua ōna hua e te whenua, ā, ka kai koutou, ka mākona, ka noho hūmārie hoki ki reira. ");
INSERT INTO mri2012_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ā, ki te mea koutou, ‘He aha he kai mā tātou i te whitu o ngā tau? Titiro hoki, e kore tātou e rui, e kore hoki e kohi i ā tātou hua.’ ");
INSERT INTO mri2012_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Māku rā e whakahau iho tāku manaaki ki a koutou i te ono o ngā tau, ā, ka whai hua mō ngā tau e toru. ");
INSERT INTO mri2012_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ā, ka rui koutou i te waru o ngā tau, ka kai anō i ngā hua pakoko; ā tae noa ki te iwa o ngā tau, me kai ngā mea pakoko, kia riro rā anō ngā hua o tēnā tau.” ");
INSERT INTO mri2012_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Kaua e hokona te whenua, he mea oti tonu atu; nōku hoki te whenua; he manene hoki koutou, he noho noa ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Me whakaae hoki ki te utu e hoki ai te whenua, i tō koutou whenua katoa. ");
INSERT INTO mri2012_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Ki te rawakoretia tōu teina, ā, ka hokona e ia tētahi wāhi o tōna kāinga, me haere mai tōna whanaunga e tata rawa ana ki a ia, ka utu i te mea i hokona atu e tōna teina kia hoki ai. ");
INSERT INTO mri2012_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ā, ki te kāhore he kaiutu a tētahi tangata, ā, ka whiwhi taonga ia, ā, ka taea anō e ia te utu. ");
INSERT INTO mri2012_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Nā, me tatau e ia ngā tau i hokona ai, ā, ka whakahoki i te tuhene ki te tangata i hokona atu ai; ā, ka hoki ai ia ki tōna kāinga. ");
INSERT INTO mri2012_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Otiia, ki te kāhore e taea e ia te whakahoki mai ki a ia anō, nā, me waiho tāna i hoko ai ki te ringa o te tangata nāna i hoko, ā tae noa ki te tau Tiupiri. Ā, i te Tiupiri ka riro, ā, ka hoki ia ki tōna kāinga. ");
INSERT INTO mri2012_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Ki te hokona e te tangata he whare nohoanga i te pā taiepa, e āhei ia te utu kia hoki mai anō i roto i te tau kotahi i muri i te rironga; kotahi tino tau hei whakahokinga māna. ");
INSERT INTO mri2012_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ā, ki te kāhore e utua, ā tino taka noa te tau, kātahi ka whakapūmautia mō ake tonu atu te whare i te pā taiepa mō te tangata nāna i hoko, puta noa i ōna whakatupuranga; e kore e riro i te Tiupiri. ");
INSERT INTO mri2012_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ko ngā whare ia o ngā kāinga, kāhore nei he taiepa ā tawhio noa, ka kīia e rite ana ki ngā pārae o te whenua; ka hoki anō ēnā ina utua, ka riro anō i te Tiupiri. ");
INSERT INTO mri2012_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Ko ngā pā ia o ngā Rīwaiti, me ngā whare o ngā pā e nohoia ana e rātou, e hoki ki ngā Rīwaiti, ahakoa utua i tēhea wā. ");
INSERT INTO mri2012_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ā, mehemea nā tētahi o ngā Rīwaiti i utu – nā, ka riro te whare i hokona rā me tōna pā i te Tiupiri – ko ngā whare hoki o ngā pā o ngā Rīwaiti tō rātou kāinga pūmau i roto i ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ko te māra ia i te taha o ō rātou pā kaua e hokona; nō te mea he wāhi pūmau tēnā nō rātou.” ");
INSERT INTO mri2012_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Ā, ki te rawakoretia tōu teina, ā, ka wiri tōna ringa i roto i a koe; me atawhai e koe; me noho manene ia, me noho noa rānei i a koe. ");
INSERT INTO mri2012_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Kaua e tangohia i a ia he moni whakatuputupu, he whakanuinga rānei; engari me wehi koe ki tōu Atua; kia noho ai tōu teina i a koe. ");
INSERT INTO mri2012_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kaua tāu moni e hoatu ki a ia hei mea whakatuputupu, kaua anō hoki āu kai e hoatu ki a ia, me te whakaaro anō ki tētahi whakanuinga ake. ");
INSERT INTO mri2012_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ko Ihowā ahau, ko tō koutou Atua, i kawe mai nei i a koutou i te whenua o Īhipa, e mea nei kia hoatu te whenua o Kanaana, ki a koutou kia waiho anō ahau hei Atua mō koutou.” ");
INSERT INTO mri2012_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Ā, ki te rawakoretia tōu teina e noho ana i roto i a koe, ā, ka hokona ki a koe; kaua ia e whakamahia e koe ki te mahi pononga. ");
INSERT INTO mri2012_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Kia rite ia i roto i a koe ki te kaimahi, ki te noho noa. Ka mahi anō ia ki a koe, ā tae noa ki te tau Tiupiri. ");
INSERT INTO mri2012_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ko reira ia mawehe ai i a koe, rātou ko āna tamariki, ā, ka hoki ki ōna whanaunga, ka hoki anō ki te kāinga o ōna mātua. ");
INSERT INTO mri2012_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ko rātou hoki āku pononga, i whakaputaina mai ai e ahau i te whenua o Īhipa; kaua rātou e hokona hei pononga. ");
INSERT INTO mri2012_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kaua e taikaha tāu whakarangatira ki a ia; engari me wehi ki tōu Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Tēnā ko ngā pononga tāne me ngā pononga wāhine māu; me hoko e koe i ngā iwi i tētahi taha ōu, i tētahi taha he pononga tāne, he pononga wāhine māu. ");
INSERT INTO mri2012_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Mā koutou anō hoki e hoko ētahi o ngā tamariki a ngā manene e noho ana i roto i a koutou, ētahi hoki o roto o ō rātou hapū i roto i a koutou, o ngā mea i whānau i a rātou ki tō koutou whenua; ā, puritia iho mā koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Me waiho hoki ēnā e koutou hei taonga tupu e tukua iho kia puritia e ā koutou tama i muri i a koutou; hei pononga rātou mā koutou ake ake. Kaua ia e taikaha tā koutou whakarangatira ki a koutou anō, ki ō koutou tēina, ki ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Ki te whai rawa hoki te manene, noho noa rānei, i roto i a koe, ā, ka rawakoretia tōu teina i tōna taha, ā, ka hoko i a ia ki te manene, ki te noho noa rānei i roto i a koe, ki te toronga rānei o te hapū o te manene; ");
INSERT INTO mri2012_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","e whakahokia anō ia mō te utu i muri i tōna hokonga; mā tētahi o ōna tēina ia e whakahoki, ");
INSERT INTO mri2012_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","mā tōna matua kēkē, mā te tamaiti rānei a tōna matua kēkē ia e whakahoki, mā tētahi rānei o ōna whanaunga tupu o tōna hapū ia e whakahoki; māna anō rānei ia e whakahoki, ki te taea e ia. ");
INSERT INTO mri2012_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Nā, ka tatau ia, rāua ko te tangata nāna ia i hoko, ka tīmata i te tau i hokona ai ia ki a ia, tae noa ki te tau Tiupiri; ā, ka rite te utu e hokona ai ia ki te maha o ngā tau; kia rite ki ō te kaimahi ōna rā ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ki te maha ake ngā tau, kia rite ki ēnā te utu mō tōna hokinga e whakahokia atu e ia i roto i te moni i hokona ai ia. ");
INSERT INTO mri2012_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ā, ki te torutoru ngā tau e toe ana ki te tau Tiupiri, nā, ka tatau rāua; ā, kia rite ki ōna tau te utu e whakahokia e ia ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ko tōna noho ki a ia kia rite ki tā te kaimahi e utua ana i te tau; kaua hoki tērā e whakatupu rangatira nanakia ki a ia i tāu tirohanga. ");
INSERT INTO mri2012_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Ā, ki te kāhore ia e hokona i ēnei tikanga, nā, me haere atu ia i te tau Tiupiri, rātou tahi ko āna tamariki. ");
INSERT INTO mri2012_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","He pononga hoki ki ahau ngā tama a Īharaira; ko āku pononga rātou i whakaputaina mai e ahau i te whenua o Īhipa: ko Ihowā ahau, ko tō koutou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Kei hanga koutou he whakapakoko mā koutou, kei whakaara rānei he whakapakoko, he mea whaowhao, he pou rānei, kaua anō hoki he kōhatu āhua ki tō koutou whenua hei koropikotanga atu; ko Ihowā hoki ahau, ko tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Kia mau ki āku hāpati, kia hopohopo anō ki tōku wāhi tapu. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Ki te haere koutou i runga i āku tikanga, ā, ka pupuri i āku whakahau, ka mahi hoki. ");
INSERT INTO mri2012_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Nā, ka hoatu e ahau he ua ki a koutou i tōna pō anō, ā, ka tukua ōna hua e te whenua, ā, ka hua ngā hua o ngā rākau o te pārae. ");
INSERT INTO mri2012_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ā, ka tutuki atu tā koutou patunga wīti ki te whakinga wāina, me te whakinga wāina ki te wā ruinga; ā, ka kai koutou i tā koutou taro, ka mākona, ka ū anō te noho ki tō koutou whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Ā, ka tukua iho e ahau te āta noho ki te whenua, ā, ka takoto iho koutou, kāhore anō hoki he tangata hei mea i a koutou kia wehi. Ka whakakāhoretia atu anō hoki e ahau ngā kīrehe kino i te whenua, e kore anō hoki te hoari e tika nā waenga o tō koutou whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ā, ka whāia e koutou ō koutou hoariri, ā, ka hinga rātou i te hoari ki tō koutou aroaro. ");
INSERT INTO mri2012_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ka whāia hoki te rau kotahi e te tokorima o koutou, ā, ka whati ngā mano kotahi tekau i te rau kotahi o koutou; nā, ka hinga ō koutou hoariri i te hoari ki tō koutou aroaro. ");
INSERT INTO mri2012_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Ka whai whakaaro hoki ahau ki a koutou, ā, ka meinga koutou kia hua, kia tini; ā, ka pūmau tāku kawenata ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ā, ka kai koutou i te kai kua roa e pakoko ana, ā, ka whakaputa i te pakoko ki waho mō te hua hou. ");
INSERT INTO mri2012_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ā, ka whakatūria e ahau tāku tapenākara ki waenganui i a koutou, e kore anō tōku wairua e whakarihariha ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ka hāereere anō hoki ahau i roto i a koutou, ā, hei Atua ahau mō koutou, ko koutou hoki hei iwi māku. ");
INSERT INTO mri2012_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ko Ihowā ahau, ko tō koutou Atua i kawe mai nei i a koutou i te whenua o Īhipa, kei waiho hei pononga mā rātou; motu pū hoki i ahau ngā here o tō koutou ioka, ā, meinga ana koutou kia haere tū.” ");
INSERT INTO mri2012_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Tēnā ko tēnei, ka kore koutou e whakarongo ki ahau, ka kore e mahi i ēnei whakahau katoa; ");
INSERT INTO mri2012_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ā, ka whakahāwea ki āku tikanga, ka whakarihariha rānei ō koutou wairua ki āku whakaritenga, ā, kāhore e mahia āku whakahau katoa, engari ka whakatakā tāku kawenata. ");
INSERT INTO mri2012_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Nā, ka meinga anō hoki tēnei e ahau ki a koutou; ka meinga e ahau hei rangatira mō koutou te pāwera, te kohi, me te kirikā, hei ngau i ngā kanohi, hei whakapōuri i te ngākau. Ā, ka maumau tā koutou rui i ā koutou purapura; nō te mea ka kainga e ō koutou hoariri. ");
INSERT INTO mri2012_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ā, ka ū atu tōku mata ki a koutou, ā, ka patua koutou i te aroaro o ō koutou hoariri, ka meinga hei kīngi mō koutou te hunga e kino ana ki a koutou; ā, ka rere koutou, ahakoa kāhore he kaiwhai. ");
INSERT INTO mri2012_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Ā, ki te kāhore tonu koutou e rongo ki ahau i ēnei meatanga, nā, e whitu atu āku pakinga i a koutou mō ō koutou hara. ");
INSERT INTO mri2012_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ka whati anō i ahau te whakapehapeha o tō koutou kaha; ā, ka meinga tō koutou rangi kia whakarino, tō koutou whenua hoki kia whakaparāhi. ");
INSERT INTO mri2012_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ā, ka poto kau ō koutou uaua; nō te mea e kore tō koutou whenua e tuku ake i ōna hua, e kore anō hoki e hua ngā hua o ngā rākau o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Ā, ki te anga kē atu tā koutou haere i ahau, ki te kore e rongo ki ahau; nā, ka hoatu e ahau kia whitu atu anō ngā whiu ki a koutou, kia rite ki ō koutou hara. ");
INSERT INTO mri2012_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ka tukua anō e ahau te kīrehe koraha ki a koutou, hei kāwhaki i ā koutou tama, hei whakamōtī i ā koutou kararehe, hei mea i a koutou kia torutoru; ā, ka ururuatia ō koutou huanui. ");
INSERT INTO mri2012_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Ā, ki te kāhore koutou e hoki ake ki te pai i ēnei meatanga āku, ā, ka anga kē atu koutou i ahau; ");
INSERT INTO mri2012_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","heoi, ka anga kē atu hoki ahau i a koutou; ā, ka whiua koutou e ahau, e ahau anō nei, kia whitu atu anō, mō ō koutou hara. ");
INSERT INTO mri2012_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ā, ka kawea e ahau he hoari ki a koutou, hei tohe i te utu mō tāku kawenata. Ā, ka huihui koutou ki roto ki ō koutou pā; ā, ka tukua e ahau te mate urutā ki a koutou; ā, ka hoatu koutou ki te ringa o te hoariri. ");
INSERT INTO mri2012_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ki te whati i ahau tā koutou tokotoko, arā te taro, ka tunua tā koutou taro e ngā wāhine kotahi tekau ki te oumu kotahi, ā, ka whakahokia e rātou tā koutou taro, he mea pāuna; ā, ka kai koutou, ā, e kore e mākona. ");
INSERT INTO mri2012_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Ā, ki te kāhore koutou e rongo ki ahau i ēnei meatanga katoa, ā, ka anga kē atu anō koutou i ahau. ");
INSERT INTO mri2012_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Kātahi ahau ka tahuri kino atu i a koutou; ā, māku nei anō koutou e papaki, e whitu atu pakinga, mō ō koutou hara. ");
INSERT INTO mri2012_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ā, e kai koutou i te kikokiko o ā koutou tama, ka kainga hoki e koutou te kikokiko o ā koutou tamāhine. ");
INSERT INTO mri2012_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ā, ka ngaro i ahau ā koutou wāhi teitei, ka tapahia anō hoki ā koutou whakapakoko, ka makā ō koutou tinana ki runga ki ngā tinana o ā koutou whakapakoko; ā, ka whakarihariha anō hoki tōku wairua ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ka ururua anō i ahau ō koutou pā, ka hoki ō koutou wāhi tapu, e kore anō hoki ahau e hongi ki ā koutou kakara reka. ");
INSERT INTO mri2012_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ā, ka tūhea i ahau te whenua; e mīharotia ai e ō koutou hoariri e noho ana i reira. ");
INSERT INTO mri2012_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ā, ka whakamararatia koutou ki roto ki ngā tauiwi, ka maunu hoki i ahau te hoari hei whai i a koutou. Ā, ka tūheatia tō koutou whenua, ka ururuatia hoki ō koutou pā. ");
INSERT INTO mri2012_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“Ko reira koa ai te whenua i ōna hāpati, i ngā rā katoa ōna e takoto tūhea ana, i a koutou hoki i te whenua o ō koutou hoariri; ko reira hoki te whenua okioki ai, koa ai hoki i ōna hāpati. ");
INSERT INTO mri2012_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ka okioki i ngā rā katoa o tōna tūheatanga; ko te okioki kīhai i a ia i ō koutou hāpati, i a koutou e noho ana i reira. ");
INSERT INTO mri2012_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Tēnā ko ngā mōrehu o koutou ka ungā e ahau he whakangohe ki ō rātou ngākau i ngā whenua o ō rātou hoariri; ā, ka whati rātou i te ngaehe rau rākau e āia ana; ā, ka rere rātou, ānō e rere ana i te hoari; ā, ka hinga ahakoa kāhore he kaiwhai. ");
INSERT INTO mri2012_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ā, ka tutetute rātou tētahi ki tētahi, ānō e whāia ana e te hoari, i te mea kāhore he kaiwhai. Ā, ka kore he tūranga ake mō koutou ki te aroaro o ō koutou hoariri. ");
INSERT INTO mri2012_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ā, ka ngaro koutou i ngā tauiwi, ka pau anō i te whenua o ō koutou hoariri. ");
INSERT INTO mri2012_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ā, ko ngā toenga o koutou, ka memeha haere i roto i tō rātou kino i ngā whenua o ō koutou hoariri; ka memeha haere rātou i roto i ngā kino ō rātou ko ō rātou mātua. ");
INSERT INTO mri2012_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Ā, ka whākina e rātou tō rātou kino, me te kino o ō rātou mātua, i tō rātou haranga i hara ai ki ahau, me tō rātou haerenga kētanga atu i tāku – ");
INSERT INTO mri2012_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","i anga kē atu ai ahau i a rātou, i kawea ai rātou ki te whenua o ō rātou hoariri; ki te iro i reira ō rātou ngākau kokotikore, ā, ka whakaae ki te pakinga mō tō rātou kino. ");
INSERT INTO mri2012_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Kātahi ahau ka mahara ki tāku kawenata ki a Hākopa; ki tāku kawenata hoki ki a Īhaka; ka mahara anō ki tāku kawenata ki a Āperahama; ka mahara ki te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ka mahue anō te whenua i a rātou, ā, ka koa ki ōna hāpati, i a ia e takoto tūhea ana, i te mea kāhore nei rātou: me rātou hoki, ka whakaae ki te whiu mō tō rātou kino. Mō tēnei hoki, āe rā mō tēnei, i whakahāwea rātou ki āku whakaritenga, ā, i whakarihariha tō rātou wairua ki āku tikanga. ");
INSERT INTO mri2012_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Nā, ahakoa he pēnā, e kore ahau e whakakāhore ki a rātou, i a rātou i te whenua o ō rātou hoariri, e kore anō e whakarihariha ki a rātou, e huna rawa i a rātou, e whakataka rānei i tāku kawenata ki a rātou. Ko Ihowā hoki ahau, ko tō rātou Atua. ");
INSERT INTO mri2012_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Engari, he mea mō rātou, ka mahara ahau ki te kawenata o ō rātou tūpuna, i kawea mai nei e ahau i te whenua o Īhipa i te tirohanga a ngā tauiwi, ki ahau hei Atua mō rātou. Ko ahau a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ko ngā tikanga ēnei, me ngā whakaritenga, me ngā ture i whakatakotoria e Ihowā ki waenganui ōna, o ngā tama a Īharaira, ki Maunga Hinai, he mea nā te ringa o Mohi. ");
INSERT INTO mri2012_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: Ki te motuhia e te tangata, he mea kī taurangi, mā Ihowā ngā tāngata, me whakarite e koe ngā moni. ");
INSERT INTO mri2012_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ā, kia pēnei tāu whakarite mō te tāne e rua tekau ōna tau, he maha ake rānei, ā, ono tekau noa ngā tau, arā kia rima tekau ngā hekere hiriwa e whakaritea e koe, hei te hekere o te wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ā, ki te mea he wahine, kia toru tekau ngā hekere e whakaritea e koe. ");
INSERT INTO mri2012_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ā, ki te mea e rima ōna tau, tae noa atu rānei ki te rua tekau tau, nā, kia rua tekau ngā hekere e whakaritea e koe mō te tāne, kia tekau hoki ngā hekere mō te wahine. ");
INSERT INTO mri2012_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ā, ki te mea kotahi tōna marama ā tae noa atu rānei ki te rima ōna tau, nā, kia rima ngā hekere hiriwa e whakaritea e koe mō te tāne, kia toru ngā hekere hiriwa e whakaritea e koe mō te wahine. ");
INSERT INTO mri2012_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ā, ki te mea e ono tekau ōna tau, he maha atu rānei; ki te mea he tāne, kia kotahi tekau mā rima ngā hekere e whakaritea e koe, kia kotahi tekau hoki ngā hekere mō te wahine. ");
INSERT INTO mri2012_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ā, ki te iti iho ōna rawa i āu i whakarite ai, nā, me tū ia ki te aroaro o te tohunga, ā, me whakarite ōna utu e te tohunga. Kei ngā mea e taea atu e te ringa o te tangata nāna te kī taurangi te tikanga mō tā te tohunga e whakarite ai hei utu mōna. ");
INSERT INTO mri2012_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Ā, mehemea he kararehe nō reira nei te whakahere a te tangata ki a Ihowā, ka tapu katoa ngā mea o tēnā i hōmai e ia mā Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kaua e whakareretia kētia e ia, e whakawhitia rānei, he pai mō te kino, he kino rānei mō te pai. Ā, ki te tūpono ka whakawhitia e ia he kararehe ki tētahi kararehe, nā, ka tapu taua mea me te mea i whakawhitia ai. ");
INSERT INTO mri2012_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ā, ki te mea he poke te kararehe, he mea e kore e whakaherea tētahi pērā mā Ihowā, nā, ka whakatūria e ia te kararehe ki te aroaro o te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ā, me whakarite ōna utu e te tohunga, ahakoa pai, ahakoa kino; me waiho i tāu i whakarite ai, e te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Otiia, ki te mea ia kia utua kia hoki ai, nā, me tāpiri tōna wāhi whakarima ki tāu i whakarite ai. ");
INSERT INTO mri2012_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Ki te whakatapua anō e te tangata tōna whare kia tapu ki a Ihowā, nā, me whakarite ōna utu e te tohunga, ahakoa pai, ahakoa kino; ko tā te tohunga e whakarite ai, ka tūturu ki reira. ");
INSERT INTO mri2012_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ā, ki te mea te kaiwhakatapu kia utua kia hoki ai tōna whare, nā, me tāpiri tōna whakarima o te moni i whakaritea e koe, ā, ka riro i a ia. ");
INSERT INTO mri2012_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Ā, ki te whakatapua e te tangata mō Ihowā tētahi wāhi māra o tōna kāinga, nā, kia rite ki ngā purapura mō reira tāu whakaritenga utu: kotahi te homa pārei hei purapura, kia rima tekau hekere hiriwa. ");
INSERT INTO mri2012_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ki te mea nō te tau Tiupiri tāna whakatapunga i tāna māra, ka tūturu anō ki tāu utu i whakarite ai. ");
INSERT INTO mri2012_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mehemea ia nō muri i te Tiupiri tāna whakatapunga i tāna māra, nā, mā te tohunga e tatau ngā moni ki a ia, kia rite ki ngā tau e toe ana ki te tau Tiupiri, ka tango ai i roto i tāu i whakarite ai. ");
INSERT INTO mri2012_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ā, ki te mea te kaiwhakatapu o te māra kia utua kia hoki atu ai, nā, me tāpiri tōna whakarima o te moni i whakaritea e koe, ā, ka whakatūturutia māna. ");
INSERT INTO mri2012_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ā, ki te kāhore ia e utu kia hoki ai te māra, ki te mea rānei i hokona e ia te māra ki te tangata kē, e kore e utua kia hoki atu i muri iho. ");
INSERT INTO mri2012_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Engari ka tapu te māra ki a Ihowā, ina riro atu i te Tiupiri, he māra hoki i oti rawa; hei kāinga tēnā mō te tohunga. ");
INSERT INTO mri2012_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Ki te whakatapua ia e tētahi ki a Ihowā he māra i hokona mai e ia, ehara nei i te māra tupu nāna; ");
INSERT INTO mri2012_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kātahi ka taua e te tohunga ki a ia ngā utu i whakaritea e koe mō te takiwā atu ki te tau Tiupiri. Ā, ka hōmai e ia tāu i whakarite ai i taua rangi, he mea tapu hoki nā Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ko ā te tau Tiupiri hoki ai te māra ki te tangata i hokona mai nei i a ia, arā ki te tangata nōna te tūturutanga o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Hei te hekere o te wāhi tapu te tikanga mō āu whakaritenga katoa; e rua tekau ngā kera o te hekere kotahi. ");
INSERT INTO mri2012_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Ko te mātāmua ia o ngā kararehe, i meinga nei hei mātāmua ki a Ihowā, kaua ēnā e whakatapua e te tangata; ahakoa kau, hipi rānei; nā Ihowā ēnā. ");
INSERT INTO mri2012_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ā, ki te mea nō ngā kararehe poke, nā, kia rite ki tāu whakaritenga tāna utu mō te whakahokinga atu, me tāpiri anō e ia tōna whakarima; ā, ki te kāhore e utua, e whakahokia, nā, me hoko; kia rite ngā utu ki āu i whakarite ai. ");
INSERT INTO mri2012_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Kaua ia e hokona, e utua rānei kia hoki atu te mea i oti rawa, i tukua pūtia mai e te tangata ki a Ihowā i roto i ōna taonga katoa, te tangata rānei, te kararehe rānei, te māra rānei o tōna kāinga tupu; he tino tapu ki a Ihowā ngā mea katoa i oti. ");
INSERT INTO mri2012_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“Ki te tukua pūtia mai tētahi tangata, he mea oti rawa, e kore e utua, e whakahokia; me whakamate rawa. ");
INSERT INTO mri2012_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Me ngā whakatekau katoa o te whenua, o te purapura rānei o te whenua, o ngā hua rānei o te rākau, nā Ihowā ēnā; he tapu ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ā, ki te mea te tangata kia utua, kia hoki ai ētahi o āna whakatekau; me tāpiri mai tētahi o ōna wāhi whakarima. ");
INSERT INTO mri2012_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ā, ko ngā whakatekau katoa o ngā kau, o ngā hipi, o ngā mea katoa e haere mai ana i raro i te tokotoko, ka tapu tēnā whakatekau ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Kaua e tirohia iho e ia, wehe ai i te pai i te kino, kaua anō hoki e whakawhitia; ā, ki te whakawhitia e ia, nā, ka tapu taua mea me tōna utu anō; e kore e utua kia hoki.” ");
INSERT INTO mri2012_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ko ngā whakahau ēnei ki ngā tama a Īharaira i whakahaua e Ihowā ki a Mohi ki Maunga Hinai.");
INSERT INTO mri2012_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ā, i kōrero a Ihowā ki a Mohi i te i koraha o Hinai i roto i te tapenākara o te whakaminenga, i te rā tuatahi o te rua o ngā marama, i te rua o ngā tau o tō rātou haerenga mai i te whenua o Īhipa, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Tirohia te tokomaha o te whakaminenga katoa o ngā tama a Īharaira, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa i ngā ingoa o ngā tāne katoa, tēnei pane, tēnei pane ō rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ko ngā mea e rua tekau, he maha atu rānei ngā tau, ko ngā mea hoki e kaha ana i roto i a Īharaira ki te haere ki te whawhai, mā kōrua ko Ārona rātou e tatau, tēnei ope, tēnei ope. ");
INSERT INTO mri2012_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kia kotahi hoki te tangata o tēnei iwi, o tēnei iwi, hei hoa mō kōrua; arā ko ngā upoko o tēnei whare, o tēnei whare o ō rātou mātua. ");
INSERT INTO mri2012_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ko ngā ingoa hoki ēnei o ngā tāngata e tū tahi me kōrua: Nō Reupena; ko Erituru, tama a Hereuru. ");
INSERT INTO mri2012_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Nō Himiona; ko Herumiere, tama a Turiharai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Nō Hūrā; ko Nāhahona, tama a Aminarapa. ");
INSERT INTO mri2012_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Nō Ihākara; ko Netanēre, tama a Tuara. ");
INSERT INTO mri2012_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Nō Hepurona; ko Eriapa, tama a Herona. ");
INSERT INTO mri2012_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Nō ngā tama a Hōhepa: nō Ēparaima; ko Erihama, tama a Amihuru; nō Mānahi; ko Kamariere, tama a Peraturu. ");
INSERT INTO mri2012_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Nō Pineamine; ko Apirana, tama a Kirioni. ");
INSERT INTO mri2012_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Nō Rāna; ko Ahiētere, tama a Amiharai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Nō Āhera; ko Pakiere, tama a Okorana. ");
INSERT INTO mri2012_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Nō Kara; ko Eriāhapa, tama a Teuere. ");
INSERT INTO mri2012_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nō Napatari; ko Ahira, tama a Enana.” ");
INSERT INTO mri2012_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ko ngā mea whai ingoa ēnei o te whakaminenga, ko ngā ariki o ngā iwi o ō rātou mātua; ko rātou ngā upoko o ngā mano i roto i a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Nā, ka tīkina e Mohi rāua ko Ārona ēnei tāngata nō rātou ngā ingoa kua whakahuatia nei, ");
INSERT INTO mri2012_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ā, huihuia ana e rātou te whakaminenga katoa i te rā tuatahi o te rua o ngā marama. Ā, ka whakaaturia e rātou ō rātou whakapapa, tēnei hapū, tēnei hapū, me ngā whare o ō rātou mātua, tatau rawa ngā ingoa, he pane, he pane, ngā mea e rua tekau, he maha atu rānei ō rātou tau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Rite tonu ki tā Ihowā i whakahau ai ki a Mohi tāna tauanga i a rātou i te koraha o Hinai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ā, ko ngā tama a Reupena, mātāmua a Īharaira: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa, he pane, he pane, o ngā tāne katoa e rua tekau. He maha atu rānei ngā tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ko ngā mea o rātou, o te iwi o Reupena, i taua, e whā tekau mā ono mano e rima rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Nō ngā tama a Himiona: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, ko ngā mea o rātou i taua, tatau rawa ngā ingoa, he pane, he pane, o ngā tāne katoa e rua tekau he maha atu rānei ngā tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ko ngā mea i taua o rātou, o te iwi o Himiona, e rima tekau mā iwa mano e toru rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Nō ngā tama a Kara: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ngā tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ko ngā mea i taua o rātou, o te iwi o Kara, e whā tekau mā rima mano e ono rau e rima tekau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Nō ngā tama a Hūrā: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ko ngā mea i taua o rātou, o te iwi o Hūrā, e whitu tekau mā whā mano e ono rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Nō ngā tama a Ihākara: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ko ngā mea i taua o rātou, o te iwi o Ihākara, e rima tekau mā whā mano e whā rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Nō ngā tama a Hepurona: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ko ngā mea i taua o rātou, o te iwi o Hepurona, e rima tekau mā whitu mano e whā rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Nō ngā tama a Hōhepa: arā nō ngā tama a Ēparaima: i ō rātou torōna, i ō rātou hapū, i ngā whare o ō rātou Matua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ko ngā mea i taua o rātou, o te iwi o Ēparaima, e whā tekau mano e rima rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Nō ngā tama a Mānahi: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ko ngā mea i taua o rātou, o te iwi o Mānahi, e toru tekau mā rua mano e rua rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Nō ngā tama a Pineamine: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ko ngā mea i taua o rātou, o te iwi o Pineamine, e toru tekau mā rima mano e whā rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Nō ngā tama a Rāna: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ko ngā mea i taua o rātou, o te iwi o Rāna, e ono tekau mā rua mano e whitu rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Nō ngā tama a Āhera: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ko ngā mea i taua o rātou, o te iwi o Āhera, e whā tekau mā tahi mano e rima rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Nō ngā tama a Napatari: i ō rātou toronga, i ō rātou hapū, i ngā whare o ō rātou mātua, tatau rawa ngā ingoa o ngā mea e rua tekau, he maha atu rānei ō rātou tau, o ngā mea katoa i kaha ki te haere ki te whawhai. ");
INSERT INTO mri2012_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ko ngā mea i taua o rātou, o te iwi o Napatari, e rima tekau mā toru mano e whā rau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ko ngā mea ēnei i taua nei e Mohi, e Ārona rātou ko ngā ariki kotahi tekau mā rua o Īharaira; takikotahi te tangata o rātou ki te whare o ōna mātua. ");
INSERT INTO mri2012_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ā, ko aua tāngata i taua o ngā tama a Īharaira, i ngā whare o ō rātou mātua, ngā mea e rua tekau, he maha atu rānei ō rātou tau i roto i a Īharaira i kaha ki te haere ki te whawhai – ");
INSERT INTO mri2012_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ko aua tāngata katoa i taua e ono rau e toru mano e rima rau e rima tekau. ");
INSERT INTO mri2012_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ko ngā Rīwaiti ia, i te iwi o ō rātou mātua, kīhai i taua i roto i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Nā Ihowā hoki i kōrero ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Otiia kaua e taua te iwi o Rīwai, kaua anō e tirohia tō rātou tokomaha i roto i ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Engari me whakarite ngā Rīwaiti mō te tapenākara o te whakaaturanga, mō ōna oko katoa, mō ōna mea katoa hoki. Mā rātou te tapenākara e amo, me ōna oko katoa; ā, me mahi ki reira, me noho hoki ki tētahi taha, ki tētahi taha o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ā, ka maunu atu te tapenākara, mā ngā Rīwaiti e wāhi iho; ka whakatūria anō hoki te tapenākara, mā ngā Rīwaiti e whakatū; ā, ko te tangata kē e whakatata atu, ka whakamatea. ");
INSERT INTO mri2012_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Me whakatū anō ō rātou tēneti e ngā tama a Īharaira ki tōna puni, ki tōna puni, ki tōna kara, ki tōna kara, puta noa i ō rātou ope. ");
INSERT INTO mri2012_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ko ngā Rīwaiti ia, me whakatū o rātou ki tētahi taha, ki tētahi taha o te tapenākara o te whakaaturanga, kei puta he riri ki te whakaminenga o ngā tama a Īharaira; ā, mā ngā Rīwaiti e tiaki te tapenākara o te whakaaturanga.” ");
INSERT INTO mri2012_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Nā, i pērā ngā tama a Īharaira; rite tonu ki tā Ihowā katoa i whakahau ai ki a Mohi tā rātou mahi. ");
INSERT INTO mri2012_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","I kōrero anō a Ihowā ki a Mohi rāua ko Ārona, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Me whakatū tōna tēneti e ngā tama a Īharaira, ki te taha o tōna kara, o tōna kara, ki ngā tohu o ngā whare o ō rātou mātua; hei te takiwā atu ki te tapenākara o te whakaminenga te tūranga o ō rātou tēneti ā tawhio noa.” ");
INSERT INTO mri2012_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ki te taha ki te rāwhiti, arā ki te putanga mai o te rā, whakatū ai ngā tāngata o te kara o te puni o Hūrā, me ō rātou ope. Ko Nāhahona tama a Aminarapa hei rangatira mō ngā tama a Hūrā. ");
INSERT INTO mri2012_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ā, ko tōna ope, ko ngā mea o rātou i taua, e whitu tekau mā whā mano e ono rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Nā, ko ngā mea e whakatū tēneti ki tua atu i a ia ko te iwi o Ihākara; ā, ko Netanēre tama a Tuara hei rangatira mō ngā tama a Ihākara; ");
INSERT INTO mri2012_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ko tōna ope, ko ngā mea o rātou i taua, e rima tekau mā whā mano e whā rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ā, ko te iwi o Hepurona: ā, ko Eriapa tama a Herona, hei rangatira mō ngā tama a Hepurona; ");
INSERT INTO mri2012_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ā, ko tōna ope, ko ngā mea o rātou i taua, e rima tekau mā whitu mano e whā rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ko ngā tāngata katoa i taua o te puni o Hūrā kotahi rau e waru tekau mā ono mano e whā rau, i ō rātou ope. Ko ēnei e haere wawe. ");
INSERT INTO mri2012_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Hei te taha ki te tonga te kara o te puni o Reupena, me ō rātou ope. Ā, ko Erituru tama a Hereuru, hei rangatira mō ngā tama a Reupena; ");
INSERT INTO mri2012_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ā, ko tōna ope, ko ngā mea o rātou i taua, e whā tekau mā ono mano e rima rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ā, me whakatū ki tōna taha ko te iwi o Himiona; ā, ko Herumiere tama a Turiharai, hei rangatira mō ngā tama a Himiona. ");
INSERT INTO mri2012_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ko tōna ope, ko ngā mea o rātou i taua, e rima tekau mā iwa mano e toru rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ko reira te iwi o Kara; ā, ko Eriāhapa tama a Reuere, hei rangatira mō ngā tama a Kara; ");
INSERT INTO mri2012_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ā, ko tōna ope, ko ngā mea o rātou i taua, e whā tekau mā rima mano e ono rau e rima tekau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ko ngā tāngata katoa i taua o te puni o Reupena kotahi rau e rima tekau mā tahi mano e whā rau e rima tekau, i ō rātou ope. Me haere rātou hei tuarua mō ngā matua. ");
INSERT INTO mri2012_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ko reira maunu atu ai te tapenākara o te whakaminenga, ko te puni o ngā Rīwaiti ki waenganui o ngā puni; kia rite tō rātou haerenga ki tō rātou nohoanga iho, ia tangata ki tōna wāhi, i te taha anō o ō rātou kara. ");
INSERT INTO mri2012_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Hei te taha ki te hauāuru te kara o te puni o Ēparaima, me ō rātou ope. Ko te rangatira mō ngā tama a Ēparaima, ko Erihama, tama a Amihuru; ");
INSERT INTO mri2012_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ā, ko tōna ope, ko ngā mea o rātou i taua, e whā tekau mano e rima rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ā, ki tōna taha ko te iwi o Mānahi; ā, ko te rangatira mō ngā tama a Mānahi ko Kamariere, tama a Peraturu; ");
INSERT INTO mri2012_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ā, ko tōna ope, ko ngā mea o rātou i taua, e toru tekau mā rua mano e rua rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ko reira te iwi o Pineamine; ā, ko te rangatira mō ngā tama a Pineamine ko Apirana tama a Kirioni; ");
INSERT INTO mri2012_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ā, ko tōna ope, ko ngā mea o rātou i taua, e toru tekau mā rima mano e whā rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ko ngā tāngata katoa i taua o te puni o Ēparaima kotahi rau e waru mano, kotahi rau, i ō rātou ope. Ā, ka hāpainga rātou hei tuatoru mō ngā matua. ");
INSERT INTO mri2012_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Hei te taha ki te raki te kara o te puni o Rāna, me ō rātou ope; ā, ko te rangatira mō ngā tama a Rāna ko Ahiētere tama a Amiharai; ");
INSERT INTO mri2012_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ā, ko tōna ope, ko ngā mea o rātou i taua, e ono tekau mā rua mano e whitu rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Nā, me whakatū ki tōna taha ko te iwi o Āhera; ā, ko te rangatira mō ngā tama a Āhera ko Pakiere tama a Okorana; ");
INSERT INTO mri2012_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ā, ko tōna ope, ko ngā mea o rātou i taua, e whā tekau mā tahi mano e rima rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ko reira te iwi o Napatari; ā, ko te rangatira mō ngā tama a Napatari ko Ahira tama a Enana; ");
INSERT INTO mri2012_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ā, ko tōna ope, ko ngā mea o rātou i taua, e rima tekau mā toru mano e whā rau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ko ngā mea katoa i taua o te puni o Rāna kotahi rau e rima tekau mā whitu mano e ono rau. Hei muri rawa rātou haere ai, me ō rātou kara. ");
INSERT INTO mri2012_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ko ēnei o ngā tama a Īharaira i taua, i ngā whare o ō rātou mātua; taua ake o ngā puni, i ō rātou ope, e ono rau e toru mano e rima rau e rima tekau. ");
INSERT INTO mri2012_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ko ngā Rīwaiti ia, kīhai i taua i roto i ngā tama a Īharaira; ko tā Ihowā hoki tēnā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Nā, ka pērātia e ngā tama a Īharaira; ka pērātia katoatia i tā Ihowā i whakahau ai ki a Mohi: Tā rātou whakanoho ki te taha o ā rātou kara, tō rātou hāpainga atu, tēnei, tēnei, i roto i tōna hapū anō, rite tonu ki ngā whare o ō rātou mātua. ");
INSERT INTO mri2012_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Nā, ko ngā whakatupuranga anō hoki ēnei o Ārona rāua ko Mohi i te rā i kōrero ai a Ihowā ki a Mohi i Maunga Hinai. ");
INSERT INTO mri2012_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ko ngā ingoa hoki ēnei o ngā tama a Ārona: ko Nātapa, ko te mātāmua, rātou ko Apihu, ko Ereātara, ko Itamara. ");
INSERT INTO mri2012_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Nō ngā ingoa ēnei Ārona, o ngā tohunga i whakawahia, i whakatohungatia nei e ia hei tohunga. ");
INSERT INTO mri2012_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","I mate hoki a Nātapa rāua ko Apihu ki te aroaro o Ihowā, i tā rāua whakaherenga i te ahi kē ki te aroaro o Ihowā, ki te koraha o Hinai, kāhore anō hoki ā rāua tamariki; ā, i mahi a Ereātara rāua ko Itamara i ngā mahi a te tohunga i te tirohanga mai a tō rāua pāpā, a Ārona. ");
INSERT INTO mri2012_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ā, i kōrero a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Whakatātaia mai te iwi o Rīwai, whakatūria hoki ki te aroaro o Ārona tohunga, kia mahi ai rātou ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ā, mā rātou e tiaki ngā mea hei tiakanga māna, hei tiakanga hoki mā te whakaminenga katoa, ki mua i te tapenākara o te whakaminenga, e mahi hoki ngā mahi o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Mā rātou anō e tiaki ngā mea katoa o te tapenākara o te whakaminenga, me ngā mea hei tiakanga mā ngā tama a Īharaira, kia mahi ai hoki ngā mahi o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ā, me hoatu e koe ngā Rīwaiti ki a Ārona rātou ko āna tama e hoatutia katoatia ana rātou ki a ia mō ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Me whakarite anō e koe a Ārona rātou ko āna tama, ā, ka ū rātou ki tā rātou mahi tohunga; ko te tangata kē e whakatata mai ka whakamatea.” ");
INSERT INTO mri2012_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ko ahau nei, nanā, kua tango ahau i ngā Rīwaiti i roto i ngā tama a Īharaira hei utu mō ngā mātāmua katoa e oroko puta mai ana i te kōpū i roto i ngā tama a Īharaira. Māku hoki ngā Rīwaiti, ");
INSERT INTO mri2012_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","nō te mea, nāku ngā mātāmua katoa; nō te rā anō i patu ai ahau i ngā mātāmua katoa o te whenua o Īhipa tāku whakatapunga i ngā mātāmua katoa a Īharaira māku, i ā te tangata, i ā te kararehe; māku ērā. Ko Ihowā ahau.” ");
INSERT INTO mri2012_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","I kōrero anō a Ihowā ki a Mohi, i te koraha o Hinai, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Taua ngā tama a Rīwai, tēnei whare, tēnei whare o ō rātou mātua, tēnei hapū, tēnei hapū o rātou; me tatau rātou e koe, ngā tāne katoa kotahi nei te marama, ahu atu. ");
INSERT INTO mri2012_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Nā, ka taua rātou e Mohi ka pērātia me tā Ihowā i kī ai, i whakahau ai. ");
INSERT INTO mri2012_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ā, ko ngā tama ēnei a Rīwai me ō rātou ingoa: ko Kerehona, ko Kohata, ko Merari. ");
INSERT INTO mri2012_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ā, ko ngā ingoa ēnei o ngā tama a Kerehona, o tēnei hapū, o tēnei hapū o rātou: ko Ripini rāua ko Himei. ");
INSERT INTO mri2012_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Me ngā tama a Kohata, o tēnei hapū, o tēnei hapū o rātou: ko Āmarama, ko Itihara, ko Heperona, ko Utiere. ");
INSERT INTO mri2012_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Me ngā tama a Merari, o tēnei hapū, o tēnei hapū o rātou: ko Māhari, ko Muhi. Ko ngā hapū ēnei o ngā Rīwaiti, o tēnei whare, o tēnei whare o ō rātou mātua. ");
INSERT INTO mri2012_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Nā, Kerehona te hapū o ngā Ripini, me te hapū o ngā Himei; ko ngā hapū ēnei o ngā Kerehoni. ");
INSERT INTO mri2012_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ko ngā mea o rātou i taua, ko te tokomaha o ngā tāne katoa, kotahi nei te marama ahu atu, ko ngā mea o rātou i taua e whitu mano e rima rau. ");
INSERT INTO mri2012_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Hei muri i te tapenākara, hei te taha ki te hauāuru, te puni o ngā Kerehoni. ");
INSERT INTO mri2012_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ko Eriāhapa hoki, ko te tama a Raere, hei ariki mō te whare o te matua o ngā Kerehoni. ");
INSERT INTO mri2012_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ā, ko tā ngā tama a Kerehona e tiaki ai i roto i te tapenākara o te whakaminenga, ko te tapenākara, ko te tēneti, me tōna hīpoki, ko te pā o te whatitoka o te tapenākara o te whakaminenga, ");
INSERT INTO mri2012_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","me ngā pā o te marae, me te pā o te whatitoka o te marae, o tērā i te tapenākara, i te āta hoki ā tawhio noa, me ōna aho hoki mō ōna meatanga katoa. ");
INSERT INTO mri2012_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Nā, Kohata hoki te hapū o ngā Amarami, me te hapū o ngā Itihari, me te hapū o ngā Heperoni, me te hapū o ngā Utieri; ko ngā hapū ēnei o ngā Kohati. ");
INSERT INTO mri2012_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ko te tokomaha o ngā tāne katoa, kotahi nei te marama, ahu atu, e waru mano e ono rau, ko rātou ngā kaitiaki o te wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Hei te taha whaka te tonga o te tapenākara he puni mō ngā hapū o ngā tama a Kohata. ");
INSERT INTO mri2012_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ā, ko Eritapana, tama a Utiere, hei ariki mō te whare o te matua o ngā hapū o ngā Kohati. ");
INSERT INTO mri2012_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ā, ko tā rātou e tiaki ai ko te āka, ko te tēpu, ko te tūranga rama, ko ngā āta, ko ngā oko o te wāhi tapu, arā ko ngā mea e minita ai rātou, me te pā ārai, me ngā mea katoa o ēnā mahinga. ");
INSERT INTO mri2012_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ā, ko Ereātara tama a Ārona tohunga hei ariki mō ngā ariki o ngā Rīwaiti, māna hoki e tirotiro ngā kaitiaki e tiaki ana i te wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Nā Merari te hapū o ngā Māhari, me te hapū o ngā Muhi: ko ngā hapū ēnei o Merari. ");
INSERT INTO mri2012_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ā, ko ngā mea o rātou i taua, ko te tokomaha o ngā tāne katoa, kotahi nei te marama ahu atu, e ono mano e rua rau. ");
INSERT INTO mri2012_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ā, ko Turiere, ko te tama a Apihaira hei ariki mō te whare o te matua o ngā hapū o Merari; hei te taha ki te raki o te tapenākara he puni mō ēnei. ");
INSERT INTO mri2012_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ko tā ngā tama hoki a Merari e tūpato ai, e tiaki ai, ko ngā papa o te tapenākara, me ōna kaho, me ōna pou, me ngā tūranga pou, me ngā mea katoa o aua mea, me ngā mea katoa o ēnā mahinga; ");
INSERT INTO mri2012_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","me ngā pou o te marae ā tawhio noa, me ngā tūranga, me ngā titi, me ngā aho. ");
INSERT INTO mri2012_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ā, ko ēnei e noho ki mua i te tapenākara, ki te rāwhiti, ki mua i te tapenākara o te whakaminenga, ki te putanga mai o te rā, ko Mohi rātou ko Ārona, ko āna tama, hei tiaki i te wāhi tapu, i ngā mea hei tiakanga mā ngā tama a Īharaira; ā, ko te tangata kē e whakatata mai, ka whakamatea. ");
INSERT INTO mri2012_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ko ngā Rīwaiti katoa i taua, ko ērā i taua rā e Mohi rāua ko Ārona, i tā Ihowā whakahau, i ō rātou hapū, ko ngā tāne katoa kotahi nei te marama ahu atu, e rua tekau mā rua mano. ");
INSERT INTO mri2012_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ā, i mea a Ihowā ki a Mohi, “Taua ngā tāne mātāmua katoa o ngā tama a Īharaira, ngā mea kotahi nei te marama, me ngā mea i maha atu, tuhituhia hoki te maha o ō rātou ingoa. ");
INSERT INTO mri2012_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ā, me tango ngā Rīwaiti māku – ko Ihowā ahau – hei utu mō ngā mātāmua katoa o ngā tama a Īharaira; me ngā kararehe a ngā Rīwaiti hei utu mō ngā mātāmua katoa i roto i ngā kararehe a ngā tama a Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Nā, ka taua e Mohi, ka pērātia me tā Ihowā i whakahau ai ki a ia, ngā mātāmua katoa i roto i ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ā, ko ngā tāne mātāmua katoa, ko te maha o ngā ingoa, kotahi nei te marama ā ahu atu, ko ngā mea o rātou i taua, e rua tekau mā rua mano e rua rau e whitu tekau mā toru. ");
INSERT INTO mri2012_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ā, i kōrero a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Tangohia ngā Rīwaiti hei utu mō ngā tāne mātāmua katoa i roto i ngā tama a Īharaira, me ngā kararehe a ngā Rīwaiti hei utu mō ā rātou kararehe; ā, māku ngā Rīwaiti. Ko Ihowā ahau. ");
INSERT INTO mri2012_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Nā, hei whakahoki atu, hei utu mō te rua rau e whitu tekau mā toru, mō ngā mātāmua o ngā tama a Īharaira i hira ake i te tokomaha o ngā Rīwaiti; ");
INSERT INTO mri2012_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","me tango e koe kia rima hekere mō tēnei pane, mō tēnei pane; kia rite ki te hekere o te wāhi tapu āu e tango ai; e rua tekau ngā kera o te hekere kotahi. ");
INSERT INTO mri2012_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Me hoatu te moni e utua ai ngā tuhene o rātou ki a Ārona rātou ko āna tama.” ");
INSERT INTO mri2012_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Nā, ka tango a Mohi i te moni whakahoki i ngā tāngata i hira ake i ērā i utua ki ngā Rīwaiti; ");
INSERT INTO mri2012_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","i tangohia e ia te moni i ngā mātāmua a ngā tama a Īharaira; kotahi mano e toru rau e ono tekau mā rima hekere; he pērā me te hekere o te wāhi tapu; ");
INSERT INTO mri2012_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ā, i hoatu e Mohi te moni a te hunga i utua ki a Ārona rātou ko āna tama, i pērā me tā Ihowā i kī ai, me tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","I kōrero anō a Ihowā ki a Mohi rāua ko Ārona, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Taua ngā tama a Kohata, i roto i ngā tama a Rīwai, tēnei hapū, tēnei hapū o rātou, i ngā whare o ō rātou mātua, ");
INSERT INTO mri2012_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ngā mea e toru tekau, he maha atu rānei ō rātou tau, ā tae noa ki ngā mea e rima tekau ō rātou tau, ngā mea katoa e uru ana ki te mahi, ki te mea i ngā mea o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Ko te mahi tēnei mā ngā tama a Kohata i roto i te tapenākara o te whakaminenga, ko ngā mea tino tapu. ");
INSERT INTO mri2012_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ā, ka maunu te puni, me haere a Ārona ki roto, rātou ko āna tama, ka tuku i te ārai hīpoki ki raro, ā, ka hīpoki iho ki te āka o te whakaaturanga. ");
INSERT INTO mri2012_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Nā, ka makā iho te hīpoki ki runga, arā ngā hiako pateri, ā, ka uhi iho i tētahi kākahu ki runga, he mea purū katoa, ka kuhu i ngā amo. ");
INSERT INTO mri2012_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Me uhi anō ki te kākahu purū te tēpu taro aroaro, ka whakatakoto ai i ngā rīhi ki runga, me ngā koko, me ngā peihana, me ngā kapu hei ringihanga; hei runga anō hoki te taro pūmau takoto ai. ");
INSERT INTO mri2012_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ka uhi ki te kākahu ngangana, ka hīpoki ai ki te hiako pateri hei hīpoki mō runga, ka kuhu i ōna amo. ");
INSERT INTO mri2012_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Nā, ka mau rātou ki tētahi kākahu purū, ka hīpoki ai i te tūranga whakamārama, i ōna rama hoki, i ōna kuku, i ōna oko ngārahu, i ōna oko hinu katoa, i ngā mea e minita ai rātou ki reira. ");
INSERT INTO mri2012_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ka hoatu ai me ōna mea katoa ki roto ki te tākai, hei te mea hiako pateri, ka whakaeke ai ki runga ki te amo. ");
INSERT INTO mri2012_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Ā, me uhi iho e rātou he kākahu purū ki runga ki te āta kōura, ka hīpoki ai ki tētahi hīpoki hiako pateri, ka kuhu ai i ōna amo. ");
INSERT INTO mri2012_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Nā, ka mau ki ngā mea e minita ai rātou i te wāhi tapu, ka hoatu ki roto ki te kākahu purū, ka hīpoki ki tētahi hīpoki hiako pateri, ka whakaeke ki te amo. ");
INSERT INTO mri2012_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Nā, ka tahi atu rātou i ngā pungarehu o te āta, ka hīpoki ai ki te kākahu pāpura. ");
INSERT INTO mri2012_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Me whakatakoto anō ki runga ōna oko katoa e minita ai rātou ki reira, ngā tahu kakara, ngā mārau kikokiko, ngā koko pungarehu, ngā peihana, ngā mea katoa o te āta; ka hīpoki ai ki te hīpoki hiako pateri, ka kuhu ai i ōna amo. ");
INSERT INTO mri2012_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Ā, ka oti i a Ārona rātou ko āna tama te hīpoki te wāhi tapu, me ngā mea katoa o te wāhi tapu, ina tata te puni te maunu; ka mutu, nā, ka haere mai ngā tama a Kohata ki te kauhoa. Otiia, kaua rātou e pā ki tētahi mea tapu kei mate rātou. Ko ēnei ngā mea a ngā tama a Kohata e mau ai o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Ā, ko tā Ereātara, ko tā te tama a te tohunga, a Ārona, e whakaaro ai, ko te hinu mō te whakamārama, ko te whakakakara reka, ko te whakahere totokore o tēnei rā, o tēnei rā, ko te hinu whakawahi, me te tirotiro i te tapenākara katoa, i ngā mea katoa hoki o reira, i te wāhi tapu, i ōna mea hoki. ");
INSERT INTO mri2012_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","“I kōrero anō a Ihowā ki a Mohi rāua ko Ārona, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Kei hātepea atu e koutou te iwi o ngā hapū o ngā Kohati i roto i ngā Rīwaiti. ");
INSERT INTO mri2012_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Engari, ko tēnei tā koutou e mea ai ki a rātou, kia ora ai rātou, kei mate, ina whakatata ki ngā mea tino tapu: me haere a Ārona rātou ko āna tama ki roto, ka whakarite ai i a rātou ki tāna mahi, ki tāna mahi, ki tāna amohanga, ki tāna amohanga. ");
INSERT INTO mri2012_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Otiia, kaua rātou e haere ki roto ki te mātakitaki i te wāhi tapu ahakoa he wā poto, kei mate rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Taua hoki ngā tama a Kerehona, i ngā whare o ō rātou mātua, i ō rātou hapū. ");
INSERT INTO mri2012_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ko ngā mea e toru tekau, he maha atu rānei ngā tau, ā tae noa ki ngā mea e rima tekau ō rātou tau, āu e tatau ai; ko ngā mea katoa hoki e uru ana ki te mahi i ngā mahi o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ko te mahi tēnei mā ngā hapū o ngā Kerehoni, ko te mahi, ko te amo. ");
INSERT INTO mri2012_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Mā rātou hoki e amo ngā pā o te tapenākara, te tapenākara hoki o te whakaminenga, tōna hīpoki, me te hīpoki hiako pateri i waho ake, me te pā o te whatitoka o te tapenākara o te whakaminenga; ");
INSERT INTO mri2012_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","me ngā pā o te marae, me te pā mō te whatitoka o te kūwaha o te marae, o tērā i te tapenākara, i te āta ā tawhio noa, me ngā aho, me ngā mea katoa mō te mahinga o aua mea, me ngā mea katoa i hangā mō aua mea; ko tā rātou mahi tēnā. ");
INSERT INTO mri2012_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Kei a Ārona rātou ko āna tama te tikanga mō ngā mahi katoa a ngā tama a ngā Kerehoni, mō ā rātou amohanga katoa, mō ā rātou mahi katoa; mā koutou hoki e whakarite ki a rātou te tikanga mō ngā mea katoa e amo ai rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ko te mahi tēnei mā ngā hapū o ngā tama a Kerehona i te tapenākara o te whakaminenga; ā, ko ngā tikanga mā rātou kei a Itamara tama a te tohunga, a Ārona.” ");
INSERT INTO mri2012_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Ko ngā tama a Merari, me tatau rātou e koe i ō rātou hapū, i ngā whare o ō rātou mātua; ");
INSERT INTO mri2012_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ko ngā mea e toru tekau, he maha atu rānei ō rātou tau, ā tae noa ki ngā mea e rima tekau ō rātou tau, āu e tatau ai, ko ngā tāngata katoa e uru ana ki te mahi, ki te mahi i te mahi o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ā, ko te tikanga anō tēnei mō tā rātou e amo ai, i ā rātou mahinga katoa i te tapenākara o te whakaminenga; ko ngā papa o te tapenākara, me ōna kaho, me ōna pou, me ōna tūranga pou; ");
INSERT INTO mri2012_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","me ngā pou o te marae ā tawhio noa, me ngā tūranga pou, me ngā titi, me ngā aho, me ngā mea katoa o aua mea, me ngā mea katoa o ēnā mahinga: me tatau ā-ingoa ngā mea kei a rātou nei te tikanga mō te amo. ");
INSERT INTO mri2012_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ko te mahi tēnei a ngā hapū o ngā tama a Merari, i ā rātou mahinga katoa i te tapenākara o te whakaminenga, i raro i te ringa o Itamara tama a te tohunga, a Ārona.” ");
INSERT INTO mri2012_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Nā, ka taua e Mohi rātou ko Ārona, ko ngā ariki o te whakaminenga, ngā tama a ngā Kohati, i ō rātou hapū, i ngā whare anō o ō rātou mātua, ");
INSERT INTO mri2012_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ngā mea e toru tekau, he maha atu rānei ō rātou tau, ā tae noa ki ngā mea e rima tekau ō rātou tau, ngā tāngata katoa i uru ki te mahi, ki te mahi i te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Ā, taua ake o rātou, i ō rātou hapū, e rua mano e whitu rau e rima tekau. ");
INSERT INTO mri2012_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ko ēnei i taua o ngā hapū o ngā Kohati, ko ngā tāngata hei mahi i te tapenākara o te whakaminenga, i taua nei e Mohi rāua ko Ārona, pērā me tā Ihowā i whakahau ai, nā te ringa o Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ā, taua ake o ngā tama a Kerehona i ō rātou hapū, i ngā whare o ō rātou mātua, ");
INSERT INTO mri2012_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ngā mea e toru tekau, he maha atu rānei ō rātou tau, ā tae noa ki ngā mea e rima tekau ō rātou tau, ngā mea katoa i uru ki te mahi, ki te mahi i te tapenākara o te whakaminenga, ");
INSERT INTO mri2012_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","taua ake o rātou i ō rātou hapū, i ngā whare o ō rātou mātua, e rua mano e ono rau e toru tekau. ");
INSERT INTO mri2012_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ko ēnei i taua o ngā hapū o ngā tama a Kerehona, o ngā tāngata katoa hei mahi i te tapenākara o te whakaminenga, i taua nei e Mohi rāua ko Ārona, pērā me tā Ihowā i whakahau ai. ");
INSERT INTO mri2012_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ā, taua ake o ngā hapū o ngā tama a Merari, i ō rātou hapū, i ngā whare o ō rātou mātua, ");
INSERT INTO mri2012_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ngā mea hoki e toru tekau, he maha atu rānei ō rātou tau, ā tae noa ki ngā mea e rima tekau ō rātou tau, ngā tāngata katoa i uru ki te mahi, hei mahi i te tapenākara o te whakaminenga, ");
INSERT INTO mri2012_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","taua ake o rātou i ō rātou hapū, e toru mano e rua rau. ");
INSERT INTO mri2012_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ko ēnei i taua o ngā hapū o ngā tama a Merari, i taua nei e Mohi rāua ko Ārona, pērā me tā Ihowā i whakahau ai, nā te ringa o Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ko ngā tāngata katoa o ngā Rīwaiti i taua, a Mohi rātou ko Ārona, ko ngā ariki o Īharaira i tatau ai, i ō rātou hapū, i ngā whare o ō rātou mātua, ");
INSERT INTO mri2012_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ko ngā mea hoki e toru tekau, he maha atu rānei ō rātou tau, ā tae noa ki ngā mea e rima tekau ō rātou tau, ko ngā tāngata katoa i uru ki te mahi i ngā mahi e mahia ana, ki te mahi hoki, ki te amoamo i roto i te tapenākara o te whakaminenga; ");
INSERT INTO mri2012_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","taua ake o rātou e waru mano e rima rau e waru tekau. ");
INSERT INTO mri2012_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Rite tonu ki tā Ihowā i whakahau ai te tauanga o rātou e te ringa o Mohi, tēnei, tēnei, me tāna mahi, me tāna amo. Nā, poto ake rātou te tatau e ia, te pērā me tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Whakahaua ngā tama a Īharaira kia motuhia kētia atu ngā repera katoa i roto i te puni, ngā tāngata katoa e rere ana te pirau, me ngā tāngata katoa e poke ana i te tūpāpaku. ");
INSERT INTO mri2012_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ko te tāne, ko te wahine, me ngare atu, me ngare e koutou ki waho o te puni; kei poke i a rātou ō rātou puni e nohoia nei e ahau.” ");
INSERT INTO mri2012_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Nā, pērātia ana e ngā tama a Īharaira, ā, motuhia kētia ana rātou i roto i te puni; rite tonu ki tā Ihowā i kōrero ai ki a Mohi tā ngā tama a Īharaira i mea ai. ");
INSERT INTO mri2012_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Mea atu ki ngā tama a Īharaira: Ki te mahia e te tangata, e te wahine rānei, tētahi mea e hara ai te tangata, hei mahi i te kino ki a Ihowā, ā, ka hē taua wairua; ");
INSERT INTO mri2012_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","nā, me whāki tō rātou hara i hara ai. Me whakahoki e ia te mea i hē ai ia, te tino mea, me tāpiri anō ki tōna whakarima, ka hoatu ai ki te tangata i hara nei ia ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Otiia ki te kāhore he whanaunga o taua tangata hei hoatutanga mō te utu, me hoatu te utu mō te hara ki a Ihowā, arā ki te tohunga; hei tāpiri mō te hipi whakamārie hei whakamārie mōna. ");
INSERT INTO mri2012_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Nā, ko ngā whakahere hapahapai katoa o ngā mea tapu katoa a ngā tama a Īharaira, e kawea ana ki te tohunga, māna ērā. ");
INSERT INTO mri2012_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Māna ake ngā mea tapu a te tangata; ko tā te tangata e hoatu ai ki te tohunga, māna tēnā.” ");
INSERT INTO mri2012_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: Ki te peka kē te wahine a tētahi tangata, ā, ka hara ki a ia, ");
INSERT INTO mri2012_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ā, ka takoto, ka pūremu tētahi ki a ia, ā, ka ngaro i ngā kanohi o tāna tahu, ka huna, ā, ka poke te wahine, kāhore anō hoki he kaiwhakaatu mō tōna hē, kāhore anō ia i mau rawa. ");
INSERT INTO mri2012_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ā, ka tau ki a ia te wairua hae, ā, ka hae ia ki tāna wahine, ā, ka poke te wahine. Ki te tau rānei ki a ia te wairua hae, ā, ka hae ia ki tāna wahine kīhai nei i poke; ");
INSERT INTO mri2012_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","kātahi ka kawe taua tangata i tāna wahine ki te tohunga, me kawe anō e ia tā te wahine whakahere hei mea mōna, te whakatekau epa parāoa pārei. Kaua he hinu e ringihia ki runga, kaua anō he parakihe e hoatu ki runga; he whakahere totokore hoki mō te hae, he whakahere whakamahara, hei whakamahara ki te kino. ");
INSERT INTO mri2012_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Nā, ka nekehia mai ia e te tohunga, ā, ka whakatūria ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ā, ka mau te tohunga ki te wai tapu i te oko oneone; ka mau anō te tohunga ki tētahi wāhi o te puehu o te papa o te tapenākara, ka maka ai ki te wai. ");
INSERT INTO mri2012_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Nā, ka whakatūria e te tohunga te wahine ki te aroaro o Ihowā, ā, ka tuku ngā makawe o te wahine kia mahora noa, ka hoatu ai i te whakahere whakamahara ki ōna ringa, arā i te whakahere totokore mō te hae. Hei te ringa ia o te tohunga te wai kawa e tau ai te kanga. ");
INSERT INTO mri2012_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Nā, ka whakaoati te tohunga i a ia, ā, ka mea ki te wahine, ‘Ki te mea kāhore anō tētahi tangata i takoto ki a koe, ki te kāhore anō hoki koe i peka atu, i poke, i te mea i raro koe i tāu tāne, kia ora koe i tēnei wai kawa e tau ai te kanga. ");
INSERT INTO mri2012_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ki te mea ia kua peka kē koe, i te mea i raro koe i tāu tāne, ā, kua poke koe, ā, kua takoto ki a koe tētahi tangata ehara nei i te tāne nāu,’ ");
INSERT INTO mri2012_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","– kātahi ka whakaoati te tohunga i te wahine ki te oati kanga, ā, ka mea te tohunga ki te wahine – ‘mā Ihowā koe e mea hei kanga, hei oati i roto i tōu iwi, ina mea a Ihowā kia pirau tōu hūhā, kia pupuhi hoki tōu puku; ");
INSERT INTO mri2012_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ā, ka tae ki roto ki ōu whēkau tēnei wai e tau ai te kanga, e pupuhi ai tōu puku, e pirau ai tōu hūhā.’ “Me kī te wahine, ‘Āmine, Āmine.’ ");
INSERT INTO mri2012_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Ā, me tuhituhi ēnei kanga e te tohunga ki te pukapuka, ka horoi atu anō e ia ki roto ki te wai kawa. ");
INSERT INTO mri2012_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Nā, ka whakainumia e ia te wahine ki te wai kawa e tau ai te kanga, ā, ka tae te wai e tau ai te kanga ki roto ki a ia, ka kawa. ");
INSERT INTO mri2012_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“Me tango hoki e te tohunga te whakahere mō te hae i te ringa o te wahine, ā, ka poipoia te whakahere ki te aroaro o Ihowā, ka whakaherea ki runga ki te āta. ");
INSERT INTO mri2012_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Nā, ka aohia e te tohunga tētahi wāhi o te whakahere, kia kī te ringa, ko tōna whakamaharatanga hoki, ā, ka tahuna ki runga ki te āta, ā muri iho ka whakainumia te wahine ki te wai. ");
INSERT INTO mri2012_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ā, ka oti ia te whakainu ki te wai, nā, ki te mea kua poke ia, kua hara ki tāna tahu, nā, ka tae ki roto ki a ia te wai e tau ai te kanga, ka kawa, ā, ka pupuhi tōna puku, ka pirau hoki tōna hūhā. Ā, hei mea kanga tēnā wahine i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ā, ki te mea kīhai i poke te wahine, ā, e mā ana; nā, ka ora, ā, ka whai tamariki. ");
INSERT INTO mri2012_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Ko te ture tēnei mō ngā hae, mehemea te wahine, kei raro nei ia i tāna tāne, ka peka kē, ā, ka poke; ");
INSERT INTO mri2012_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ina tau iho rānei te wairua hae ki tētahi, ā, ka hae ia ki tāna wahine. Nā, me whakatū taua wahine e ia ki te aroaro o Ihowā; nā, ka mahia e te tohunga tēnei ture katoa ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Nā, ka kore he hē mō te tangata, ā, ka waha e taua wahine tōna kino.” ");
INSERT INTO mri2012_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: E momotu te tangata, te wahine rānei i a ia, he kī taurangi nā te Natari, mōna kia wehea mā Ihowā; ");
INSERT INTO mri2012_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","me wehe ia i a ia kei tata ki te wāina, ki te wai whakahaurangi rānei, kaua hoki ia e inu i te winika wāina, i te winika whakahaurangi, kaua hoki e inu i te wai karepe, ā, kaua e kai i te karepe hou, maroke rānei. ");
INSERT INTO mri2012_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","I ngā rā katoa e wehea ai ia kaua ia e kai i tētahi mea nō te wāina te mea i hangā ai, ahakoa nganga, ahakoa peha. ");
INSERT INTO mri2012_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“I ngā rā katoa o tāna kī taurangi wehe i a ia, kaua te heu e pā ki tōna mātenga; kia tutuki rā anō ngā rā e wehea ai ia ki a Ihowā, ka tapu ia, ā, me tuku e ia ngā makawe o tōna mātenga kia tupu, kia roroa. ");
INSERT INTO mri2012_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","I ngā rā katoa e wehe ai ia i a ia ki a Ihowā kaua ia e whakatata ki te tūpāpaku. ");
INSERT INTO mri2012_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Kaua ia e whakapoke i a ia mō tōna pāpā, mō tōna whaea, mō tōna tuakana, teina rānei, mō tōna tuahine, ina mate rātou; nō te mea kei runga i tōna mātenga te wehenga a tōna Atua. ");
INSERT INTO mri2012_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ka tapu ia ki a Ihowā i ngā rā katoa e wehea ai ia. ");
INSERT INTO mri2012_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Ā, ki te mate tētahi tangata ki tōna taha, he mea pā whakarere, ā, kua poke i a ia tōna mātenga i wehea nei; nā, me heu e ia tōna mātenga i te rā e purea ai ia, me heu e ia i te whitu o ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ā, i te waru o ngā rā me kawe mai e ia he kūkupa kia rua, he pī kūkupa rānei kia rua, ki te tohunga, ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ā, me whakahere tētahi e te tohunga hei whakahere hara, me tētahi hei tahunga tinana, ā, ka whakamārie mōna, nōna hoki i whai hara i te tūpāpaku, ka whakatapua anō tōna mātenga i taua rā anō. ");
INSERT INTO mri2012_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ā, me whakatapu e ia ki a Ihowā ngā rā o tōna wehenga, me kawe mai anō he reme toa, he tau tahi, hei whakahere mō te hē. Ko ngā rā ia ō mua ka whakatakā, nō te mea kua poke tōna wehenga. ");
INSERT INTO mri2012_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Ā, ko te ture tēnei mō te Natari, ina rite ngā rā e wehea ai ia: me kawe ia ki te whatitoka o te tapenākara o te whakaminenga; ");
INSERT INTO mri2012_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ā, me whakahere e ia tāna whakahere ki a Ihowā, kia kotahi te reme toa tau tahi, hei te mea kohakore, hei tahunga tinana, me tētahi reme uha tau tahi, hei te mea kohakore, hei whakahere hara, me tētahi hipi toa kohakore, hei whakahere mō te pai, ");
INSERT INTO mri2012_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","me tētahi kete taro rēwenakore, me ngā keke parāoa pai i kōnatunatua ki te hinu, me ētahi me angiangi anō hoki, hei ngā mea rēwenakore i pania ki te hinu, me te whakahere totokore, me ngā ringihanga o aua mea. ");
INSERT INTO mri2012_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Ā, me kawe aua mea e te tohunga ki te aroaro o Ihowā, ā, ka whakaherea tāna whakahere hara, me tāna tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","me whakahere anō e ia te hipi toa, hei patunga mō te pai ki a Ihowā, me te kete taro rēwenakore; me whakahere anō e te tohunga tāna whakahere totokore, me tāna ringihanga. ");
INSERT INTO mri2012_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Ā, me heu e te Natari tōna mātenga, i wehea nei, ki te whatitoka o te tapenākara o te whakaminenga, ka tango ai i ngā makawe o tōna mātenga i wehea nei, ā, ka maka ki te ahi, ki tērā i raro i te patunga mō te pai. ");
INSERT INTO mri2012_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Ā, me tango e te tohunga te peke o te hipi toa, ina oti te kōhua, me tētahi o ngā keke rēwenakore i te kete, me tētahi o ngā keke angiangi, o ngā mea rēwenakore, ā, ka hoatu e ia ki ngā ringa o te Natari, i muri i te heunga o ōna makawe i wehea nei. ");
INSERT INTO mri2012_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Nā, ka poipoia e te tohunga hei whakahere poipoi ki te aroaro o Ihowā. Ka tapu tēnei mā te tohunga, me te uma poipoi, me te hūhā hapahapai; ā muri iho ka inu wāina te Natari. ");
INSERT INTO mri2012_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Ko te ture tēnei mō te Natari, nāna te kī wehe, mō tāna whakahere hoki ki a Ihowā ina wehea, hei tāpiri mō tā tōna ringa i whiwhi ai. Kia rite ki tāna kī i kī ai; kei te ture o tōna wehenga te tikanga mō tāna e mea ai.” ");
INSERT INTO mri2012_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Kōrero ki a Ārona rātou ko āna tama, mea atu: Kia pēnei tā koutou manaaki i ngā tama a Īharaira; mea atu ki a rātou, ");
INSERT INTO mri2012_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Mā Ihowā koe e manaaki, māna koe e tiaki; ");
INSERT INTO mri2012_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mā Ihowā e mea kia tīaho tōna mata ki a koe, māna anō hoki koe e atawhai; ");
INSERT INTO mri2012_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mā Ihowā tōna kanohi e whakaara ki a koe, māna anō e tuku te rangimārie ki a koe.’ ");
INSERT INTO mri2012_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ā, ka karangatia e rātou tōku ingoa ki runga ki ngā tama a Īharaira; ā, māku rātou e manaaki.” ");
INSERT INTO mri2012_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ā, i te rā i oti ai i a Mohi te tapenākara te whakaara, i whakawahia ai, i whakatapua ai hoki te tapenākara me ōna mea katoa, te āta, me ōna mea katoa, ā, ka oti te whakawahi, te whakatapu. ");
INSERT INTO mri2012_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Nā, ka whakahere ngā ariki o Īharaira, ngā upoko o ngā whare o ō rātou mātua; ko rātou ngā ariki o ngā iwi, i a rātou hoki ngā tikanga mō te hunga i taua. ");
INSERT INTO mri2012_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ā, ka kawea mai e rātou tā rātou whakahere ki te aroaro o Ihowā, e ono ngā kāta whai taupoki, kotahi tekau mā rua ngā kau; tokorua ngā ariki kotahi anō te kāta, kotahi anō hoki te pūru a tētahi, a tētahi; ā, whakatūtūria ana e rātou ki te aronga o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ā, i kōrero a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Tangohia tā rātou, hei mea mō te mahi o te tapenākara o te whakaminenga; ā, me hoatu e koe ki ngā Rīwaiti, kia rite ki te mahi a tēnei, a tēnei.” ");
INSERT INTO mri2012_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Nā, tangohia ana e Mohi ngā kāta me ngā kau, ā, hoatu ana e ia ki ngā Rīwaiti. ");
INSERT INTO mri2012_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","E rua ngā kāta, e whā ngā kau i hoatu e ia ki ngā tama a Kerehona, he mea whakarite ki tā rātou mahi. ");
INSERT INTO mri2012_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","E whā ngā kāta, e waru ngā kau i hoatu e ia ki ngā tama a Merari, he mea whakarite ki tā rātou mahi, i te ringa o Itamara tama a te tohunga, a Ārona. ");
INSERT INTO mri2012_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ki ngā tama ia a Kohata, kīhai i hoatu e ia; nō te mea ko te mahi o te wāhi tapu mā rātou ko te kauhoa i runga i ō rātou pokohiwi. ");
INSERT INTO mri2012_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ā, i whakahere anō ngā ariki hei tāinga kawa mō te āta i te rā i whakawahia ai, i whakahere ngā ariki i ā rātou whakahere ki mua i te āta. ");
INSERT INTO mri2012_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Nā, ka mea a Ihowā ki a Mohi, “Me hoatu e rātou ā rātou whakahere, tēnā ariki i tōna rā, tēnā ariki i tōna rā, hei tāinga kawa mō te āta.” ");
INSERT INTO mri2012_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Nā, ko te tangata nāna te whakahere i te rā tuatahi, ko Nāhahona tama a Aminarapa, nō te iwi o Hūrā. ");
INSERT INTO mri2012_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ā, ko tāna whakahere, he rīhi hiriwa, kotahi rau e toru tekau hekere te taimaha, he peihana, hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","kotahi koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","e rua hoki ngā pūru hei patunga mō te pai, e rima hipi toa, e rima koati toa, e rima reme toa, he tau tahi; ko te whakahere tēnei a Nāhahona tama a Aminarapa. ");
INSERT INTO mri2012_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","I te rā tuarua nā Netanēre te whakahere; he tama ia nā Tuara, he ariki nō Ihākara. ");
INSERT INTO mri2012_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ko tāna whakahere i whakahere ai, he rīhi hiriwa, kotahi rau e toru tekau hekere te taimaha, he peihana hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu aua mea e rua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","he koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","e rua hoki ngā pūru hei patunga mō te pai, e rima hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Netanēre tama a Tuara. ");
INSERT INTO mri2012_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","I te rā tuatoru nā Eriapa, nā te tama a Herona, he ariki nō ngā tama a Hepurona. ");
INSERT INTO mri2012_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ko tāna whakahere he rīhi hiriwa, kotahi rau e toru tekau hekere te taimaha, he peihana, hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","kotahi koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","e rua hoki ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Eriapa tama a Herona. ");
INSERT INTO mri2012_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","I te rā tuawhā nā Erituru, nā te tama a Hereuru, he ariki nō ngā tama a Reupena. ");
INSERT INTO mri2012_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ko tāna whakahere he rīhi hiriwa, kotahi rau e toru tekau hekere te taimaha, he peihana hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu, hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","he koko kōura, tekau ōna hekere, kī tonu i te whakakakara. ");
INSERT INTO mri2012_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","e rua ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi; ko te whakahere tēnei a Erituru tama a Hereuru. ");
INSERT INTO mri2012_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","I te rā tuarima, nā Herumiere, nā te tama a Turiharai, he ariki nō ngā tama a Himiona. ");
INSERT INTO mri2012_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","He rīhi hiriwa tāna whakahere, kotahi rau e toru tekau hekere tōna taimaha, he peihana hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","kotahi koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","e rua hoki ngā pūru hei patunga mō te pai, e rima hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Herumiere tama a Turiharai. ");
INSERT INTO mri2012_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","I te rā tuaono nā Eriāhapa, tama a Teuere, he ariki nō ngā tama a Kara. ");
INSERT INTO mri2012_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","He rīhi hiriwa tāna whakahere, kotahi rau e toru tekau hekere te taimaha, he peihana hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","he koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","e rua hoki ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Eriāhapa tama a Teuere. ");
INSERT INTO mri2012_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","I te rā tuawhitu nā Erihama; tama a Amihuru, he ariki nō ngā tama a Ēparaima. ");
INSERT INTO mri2012_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","He rīhi hiriwa tāna whakahere, kotahi rau e toru tekau hekere te taimaha, he peihana hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","kotahi koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","e rua hoki ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Erihama tama a Amihuru. ");
INSERT INTO mri2012_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","I te rā tuawaru nā Kamariere, tama a Peraturu, he ariki nō ngā tama a Mānahi. ");
INSERT INTO mri2012_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","He rīhi hiriwa tāna whakahere, kotahi rau e toru tekau hekere te taimaha, he peihana hiriwa e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","kotahi koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","e rua hoki ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Kamariere tama a Peraturu. ");
INSERT INTO mri2012_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","I te rā tuaiwa nā Apirana, tama a Kirioni, he ariki nō ngā tama a Pineamine. ");
INSERT INTO mri2012_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","He rīhi hiriwa tāna whakahere, kotahi rau e toru tekau hekere te taimaha, he peihana hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","he koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","e rua hoki ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Apirana tama a Kirioni. ");
INSERT INTO mri2012_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","I te tekau o ngā rā nā Ahiētere, tama a Amiharai, he ariki nō ngā tama a Rāna. ");
INSERT INTO mri2012_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","He rīhi hiriwa tāna whakahere, kotahi rau e toru tekau hekere te taimaha, he peihana, hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","kotahi koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","e rua hoki ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Ahiētere tama a Amiharai. ");
INSERT INTO mri2012_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","I te tekau mā tahi o ngā rā nā Pakiere, tama a Okorana, he ariki nō ngā tama a Āhera. ");
INSERT INTO mri2012_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","He rīhi hiriwa tāna whakahere, kotahi rau e toru tekau hekere te taimaha, he peihana hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","kotahi koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","e rua hoki ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Pakiere tama a Okorana. ");
INSERT INTO mri2012_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","I te tekau mā rua o ngā rā nā Ahira, tama a Enana, he ariki nō ngā tama a Napatari. ");
INSERT INTO mri2012_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","He rīhi hiriwa tāna whakahere, kotahi rau e toru tekau hekere te taimaha, he peihana hiriwa, e whitu tekau ōna hekere, he hekere wāhi tapu; kī tonu rāua i te parāoa pai i kōnatunatua ki te hinu hei whakahere totokore; ");
INSERT INTO mri2012_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","kotahi koko kōura, tekau ōna hekere, kī tonu i te whakakakara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","kotahi pūru, he kūao, kotahi hipi toa, kotahi reme toa, he tau tahi, hei tahunga tinana; ");
INSERT INTO mri2012_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","kotahi koati toa hei whakahere hara; ");
INSERT INTO mri2012_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","e rua hoki ngā pūru hei patunga mō te pai, e rima ngā hipi toa, e rima koati toa, e rima reme toa, he tau tahi. Ko te whakahere tēnei a Ahira tama a Enana. ");
INSERT INTO mri2012_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ko tā ngā ariki a Īharaira tāinga kawa tēnei mō te āta, i te rā i whakawahia ai: tekau mā rua ngā rīhi hiriwa, tekau mā rua ngā peihana hiriwa, tekau mā rua ngā koko kōura; ");
INSERT INTO mri2012_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","kotahi rau e toru tekau ngā hekere o te rīhi hiriwa kotahi, e whitu tekau hoki o te peihana kotahi; e rua mano e whā rau ngā hekere o ngā oko hiriwa katoa, he hekere wāhi tapu. ");
INSERT INTO mri2012_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Tekau mā rua ngā koko kōura, kī tonu i te whakakakara, tekau ngā hekere o tētahi, o tētahi, he hekere wāhi tapu; kotahi rau e rua tekau hekere te kōura katoa o ngā koko. ");
INSERT INTO mri2012_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ko ngā kau katoa mō te tahunga tinana tekau mā rua ngā pūru, kotahi tekau mā rua ngā hipi toa, tekau mā rua ngā reme toa tau tahi, me ō rātou whakahere totokore; tekau mā rua anō ngā kūao koati hei whakahere hara. ");
INSERT INTO mri2012_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ko ngā kau katoa hoki mō te patunga mō te pai, e rua tekau mā whā ngā pūru, e ono tekau ngā hipi toa, e ono tekau hoki ngā koati toa, e ono tekau ngā reme toa tau tahi. Ko te tāinga kawa tēnei o te āta i muri i tōna whakawahinga. ");
INSERT INTO mri2012_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ā, i te haerenga o Mohi ki roto ki te tapenākara o te whakaminenga ki te kōrero ki a ia, nā, ka rongo ia ki te reo o tētahi e kōrero ana ki a ia i runga i te taupoki, i tērā i runga i te āka o te whakaaturanga, i waenganui i ngā kerupima e rua; ā, ka kōrero ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Kōrero ki a Ārona, mea atu ki a ia: Ka tahuna e koe ngā rama, kia mārama i ngā rama e whitu te wāhi i mua o taua tūranga rama.” ");
INSERT INTO mri2012_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","I pērā anō a Ārona; i meinga e ia kia kā ngā rama ki te wāhi i mua o te tūranga rama; i pērā ia me tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ā, ko te mahinga tēnei o te tūranga rama, he mea patu te kōura; ko tōna take, ko ōna puāwai, he mea patu; ko tāna hanga i te tūranga rama rite tonu ki te tauira i whakakitea e Ihowā ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Tangohia ngā Rīwaiti i roto i ngā tama a Īharaira, ka pure i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ko tēnei tāu e mea ai ki a rātou, hei pure i a rātou: tāuhiuhia ki a rātou he wai hei pure, kia heua ō rātou tinana katoa, ā, me horoi e rātou ō rātou kākahu, kia mā ai. ");
INSERT INTO mri2012_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kātahi rātou ka mau ki tētahi pūru kūao, me tōna whakahere totokore, arā, te parāoa pai i kōnatunatua ki te hinu; me tango anō e koe tētahi atu pūru kūao hei whakahere hara. ");
INSERT INTO mri2012_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Nā, ka kawe koe i ngā Rīwaiti ki mua i te tapenākara o te whakaminenga, ka tāwhiu mai ai i te huihui katoa o ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Nā, ka kawe koe i ngā Rīwaiti ki te aroaro o Ihowā; ā, ka popoki ngā ringa o ngā tama a Īharaira ki ngā Rīwaiti; ");
INSERT INTO mri2012_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ā, me whakahere e Ārona ngā Rīwaiti ki te aroaro o Ihowā, hei whakahere poipoi mā ngā tama a Īharaira, ā, ka waiho rātou hei mahi i te mahi a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Nā, ka popoki ngā ringa o ngā Rīwaiti ki runga ki ngā mātenga o ngā pūru; ā, me tuku tētahi e koe hei whakahere hara, tētahi hoki hei tahunga tinana ki a Ihowā, hei whakamārie mō ngā Rīwaiti. ");
INSERT INTO mri2012_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Nā, ka whakatū koe i ngā Rīwaiti ki te aroaro o Ārona, ki te aroaro anō o āna tama, ka whakahere ai hei whakahere poipoi ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Nā, me momotu e koe ngā Rīwaiti i roto i ngā tama a Īharaira, ā, māku ngā Rīwaiti. ");
INSERT INTO mri2012_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Ā muri iho, ka haere ngā Rīwaiti ki roto, ki te mahi i te mahi o te tapenākara o te whakaminenga; ā, me pure rātou e koe, me whakahere hoki hei whakahere poipoi. ");
INSERT INTO mri2012_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ka tukua rawatia mai hoki rātou ki ahau i roto i ngā tama a Īharaira; hei utu mō ngā mea katoa e oroko puta mai ana i te kōpū, arā mō ngā mātāmua o ngā tama katoa a Īharaira i tangohia ai rātou e ahau māku. ");
INSERT INTO mri2012_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Nāku hoki ngā mātāmua katoa o ngā tama a Īharaira, ngā tāngata me ngā kararehe; nō te rā i patua ai e ahau ngā mātāmua katoa o te whenua o Īhipa tāku whakatapunga i a rātou māku. ");
INSERT INTO mri2012_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nā, ka tangohia nei e ahau ngā Rīwaiti hei utu mō ngā mātāmua katoa o ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","He mea hoatu nāku ngā Rīwaiti i roto i ngā tama a Īharaira ki a Ārona rātou ko āna tama, hei mahi i ngā mahi a ngā tama a Īharaira, i te tapenākara o te whakaminenga, hei whakamārie mō ngā tama a Īharaira; kei pā te whiu ki ngā tama a Īharaira, ina whakatata ngā tama a Īharaira ki te wāhi tapu.” ");
INSERT INTO mri2012_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Nā, ko tā Mohi rātou ko Ārona, ko te whakaminenga katoa o ngā tama a Īharaira i mea ai ki ngā Rīwaiti, pērā tonu me ngā mea katoa i whakahau ai a Ihowā ki a Mohi mō ngā Rīwaiti; i pērā tonu ngā tama a Īharaira ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Nā, ka horohoroa ngā Rīwaiti, ā, ka horoia ō rātou kākahu; ā, whakaherea ana rātou e Ārona hei whakahere poipoi ki te aroaro o Ihowā; ā, ka whakamārie a Ārona mō rātou hei pure mō rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ā, ka mutu tērā, ka tomo ngā Rīwaiti ki te mahi i ā rātou mahi i te tapenākara o te whakaminenga, i te aroaro o Ārona, i te aroaro anō hoki o āna tama; pērā tonu me tā Ihowā i whakahau ai ki a Mohi mō ngā Rīwaiti tā rātou i mea ai ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Ko te mea tēnei mā ngā Rīwaiti; ka rua tekau mā rima ō rātou tau, ka maha ake rānei, me tomo rātou ki te mahi i ngā mahi o te tapenākara o te whakaminenga; ");
INSERT INTO mri2012_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ka maha ake ō rātou tau i te rima tekau, me whakamutu tā rātou mahi i ngā mahi o reira, kaua anō hoki he mahi mā rātou i muri iho. ");
INSERT INTO mri2012_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Engari, me minita tahi me ō rātou tuākana i te tapenākara o te whakaminenga, me tiaki i ngā mea e tiakina ana, kaua hoki e mahi i tētahi mahi. Ko tēnei tāu e mea ai ki ngā Rīwaiti, ina tiaki rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","I kōrero anō a Ihowā ki a Mohi i te koraha o Hinai, i te rua o ngā tau o tō rātou haerenga mai i te whenua o Īhipa, i te tahi o ngā marama, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Me mahi anō te Kapenga e ngā tama a Īharaira i tōna wā anō. ");
INSERT INTO mri2012_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Me mahi i te tekau mā whā o ngā rā o tēnei marama, i te ahiahi, i tōna wā anō; kia rite ki ōna tikanga katoa, ki ōna ritenga katoa, tā koutou meatanga.” ");
INSERT INTO mri2012_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Nā, ka kōrero a Mohi ki ngā tama a Īharaira kia mahia te Kapenga. ");
INSERT INTO mri2012_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ā, ka mahia e rātou te Kapenga i te tekau mā whā o ngā rā o te marama tuatahi, i te ahiahi, i te koraha o Hinai; rite tonu ki ngā mea katoa i whakahau ai a Ihowā ki a Mohi tā ngā tama a Īharaira i mea ai. ");
INSERT INTO mri2012_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nā, tērā ētahi tāngata i poke i te tūpāpaku, i kore ai e āhei te mahi i te Kapenga i taua rā. Nā, ka haere rātou ki te aroaro o Mohi rāua ko Ārona i taua rā; ");
INSERT INTO mri2012_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ā, ka mea aua tāngata ki a ia, “Kua poke mātou i te tūpāpaku; he aha mātou tē tukua ai ki te whakahere i te whakahere mā Ihowā i tōna wā i rite ai, i roto i ngā tama a Īharaira?” ");
INSERT INTO mri2012_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Nā, ka mea a Mohi ki a rātou, “E tū koutou, ā, me whakarongo atu ahau ki tā Ihowā e whakahau ai mō koutou.” ");
INSERT INTO mri2012_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ā, i kōrero a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Kōrero ki ngā tama a Īharaira, mea atu: Ki te poke i te tūpāpaku tētahi o koutou, o ō koutou uri rānei, ki te mea rānei kei tawhiti e haere ana, me mahi anō e ia te Kapenga ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Me mahi e rātou i te rua o ngā marama, i te tekau mā whā o ngā rā, i te ahiahi, me kīnaki ki te taro rēwenakore, ki ngā pūwhā kawa. ");
INSERT INTO mri2012_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Kaua tētahi wāhi o tēnā mea e whakatoea e rātou mō te ata, kaua anō hoki e whatia tētahi o ōna wheua; kia rite ki ngā tikanga katoa o te Kapenga tā rātou mahinga i tēnā mahi. ");
INSERT INTO mri2012_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Ko te tangata ia kāhore ōna poke, ā, kāhore anō i te haere, ā, e māngere ana ki te mahi i te Kapenga, inā, ka hātepea atu taua wairua i roto i tōna iwi; kāhore nei hoki i kawea e ia te whakahere mā Ihowā i tōna wā i rite ai, ka waha e taua tangata tōna hara. ");
INSERT INTO mri2012_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Ā, ki te noho he manene i roto i a koutou, ā, ka mea ki te mahi i te Kapenga ki a Ihowā; kia rite ki ngā tikanga o te Kapenga, ki ngā ritenga anō o taua mahi, tāna e mea ai. Kia kotahi anō tā koutou tikanga mō te manene rāua ko te tangata whenua.” ");
INSERT INTO mri2012_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ā, i te rā i whakaarahia ai te tapenākara, ka taupokina te tapenākara e te kapua, arā te tēneti o te whakaaturanga; ā, i te ahiahi i rite a runga o te tapenākara ki te āhua ahi, taea noatia te ata. ");
INSERT INTO mri2012_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","I pērā tonu: i taupokina e te kapua i te awatea, e te āhua ahi hoki i te pō. ");
INSERT INTO mri2012_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ka riro ake hoki te kapua i runga i te tapenākara, nā, muri iho, ka haere ngā tama a Īharaira; ā, i te wāhi i tau ai te kapua ka whakatūria e ngā tama a Īharaira ō rātou tēneti ki reira. ");
INSERT INTO mri2012_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nā, ko ngā haerenga o ngā tama a Īharaira nā te whakahau a Ihowā, ā, ko ō rātou nohoanga iho nā te whakahau anō a Ihowā. I noho anō rātou i ngā rā katoa i tau ai te kapua ki runga ki te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ā, ka maha ngā rā i roa ai te kapua ki runga ki te tapenākara, nā, ka rite i ngā tama a Īharaira tā Ihowā i whakarite ai, ā, kīhai i haere. ");
INSERT INTO mri2012_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ā, he wā anō i torutoru ngā rā o te kapua ki runga ki te tapenākara; heoi nā te whakahau a Ihowā ka noho rātou i ō rātou tēneti, ā, nā te whakahau anō a Ihowā ka haere rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ā, i ētahi wā i tūturu te kapua i te ahiahi taea noatia te ata; ā, ka riro ake te kapua i te ata, nā, ka haere rātou. Ahakoa he ao, he pō rānei, i riro ake ai te kapua, i haere anō rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ahakoa e rua ngā rā, kotahi marama rānei, kotahi tau rānei, i roa ai te kapua ki runga ki te tapenākara, i mau ai ki reira, nā, noho ā-puni tonu iho ngā tama a Īharaira, kāhore hoki i haere; tōna rironga ake ki runga, nā, ka haere rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Nā te whakahau a Ihowā tā rātou noho, nā te whakahau hoki a Ihowā tā rātou haere. I rite i a rātou tā Ihowā i whakarite ai, tā Ihowā i whakahau ai, i kōrerotia ai e Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Hangā ētahi tētere hiriwa māu, kia rua; me patupatu tō rāua hanganga, ina hangā e koe; hei tāwhiunga māu i te hui, mō ngā maunutanga anō hoki o ngā puni. ");
INSERT INTO mri2012_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ā, ka whakatangihia aua mea, me huihui te whakaminenga katoa ki a koe, ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ā, ki te mea kotahi anō e whakatangihia, nā, me huihui ki a koe ngā ariki, ngā upoko o ngā mano o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ka whakatangihia he whakaoho e koutou, nā, ka hāpainga ngā puni e noho ana ki te taha ki te rāwhiti. ");
INSERT INTO mri2012_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ā, i te rua o ā koutou whakatangihanga o te whakaoho, nā, ka hāpainga ngā puni e noho ana ki te taha ki te tonga. Me whakatangi he whakaoho e rātou mō ō rātou maunutanga. ");
INSERT INTO mri2012_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Otiia, ka meatia kia huihuia te whakaminenga, me whakatangi e koutou, engari kaua e whakatangihia he whakaoho. ");
INSERT INTO mri2012_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Ā, mā ngā tama a Ārona, mā ngā tohunga, e whakatangi ngā tētere, ā, hei tikanga tēnā ki a koutou ake ake, i ō koutou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ā, ki te anga koutou ki te whawhai i tō koutou whenua ki te hoariri e whakatupu kino ana i a koutou, nā, me whakatangi he whakaoho ki ngā tētere; ā, ka maharatia koutou e Ihowā, e tō koutou Atua, ka whakaorangia hoki i ō koutou hoariri. ");
INSERT INTO mri2012_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","I te rā anō e hari ai, i ō koutou rā nunui hoki, i ngā tīmatanga o ō koutou marama, me whakatangi ngā tētere ki ā koutou tahunga tinana, ki ā koutou patunga mō te pai; ā, hei whakamahara ēnā ki a koutou ki te aroaro o tō koutou Atua. Ko Ihowā ahau, ko tō koutou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ā, i te rua tekau o te rua o ngā marama, i te rua o ngā tau, kua riro ake te kapua i runga i te tapenākara o te whakaaturanga. ");
INSERT INTO mri2012_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Nā, ka hāpainga e ngā tama a Īharaira i te koraha o Hinai; ā, ka tau te kapua ki te koraha o Parana. ");
INSERT INTO mri2012_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ā, rite tonu tā rātou hāpainga mataati ki te kupu a Ihowā i kōrerotia e Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ko te tuatahi i maunu, ko te kara o te puni o ngā tama a Hūrā, me ō rātou rōpū; ā, ko te kaiwhakahaere o tāna ope ko Nāhahona tama a Aminarapa. ");
INSERT INTO mri2012_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ā, ko te kaiwhakahaere o te ope o te iwi o ngā tama a Ihākara ko Netanēre tama a Tuara. ");
INSERT INTO mri2012_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Ko te kaiwhakahaere hoki o te ope o te iwi o ngā tama a Hepurona ko Eriapa tama a Herona. ");
INSERT INTO mri2012_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Nā, ka wāhia te tapenākara; ā, ka tūria atu e ngā tama a Kerehona, rātou ko ngā tama a Merari, ko rātou ki te amo i te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Nā, ka maunu ko te kara o te puni o Reupena, me ō rātou rōpū. Ko te kaiwhakahaere o tāna ope ko Erituru tama a Hereuru. ");
INSERT INTO mri2012_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ā, ko te kaiwhakahaere o te ope o te iwi o ngā tama a Himiona ko Herumiere tama a Turiharai. ");
INSERT INTO mri2012_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ā, ko te kaiwhakahaere o te ope o te iwi o ngā tama a Kara ko Eriāhapa tama a Teuere. ");
INSERT INTO mri2012_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Nā, ka tūria atu e ngā Kohati me te amo i te nohoanga tapu; ā tae rawa atu rātou kua tū te tapenākara i ētahi. ");
INSERT INTO mri2012_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Nā, ka maunu atu ko te kara o te puni o ngā tama a Ēparaima, me ō rātou rōpū; ā, ko te kaiwhakahaere o tāna ope ko Erihama tama a Amihuru. ");
INSERT INTO mri2012_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ā, ko te kaiwhakahaere o te ope o te iwi o ngā tama a Mānahi ko Kamariere tama a Peraturu. ");
INSERT INTO mri2012_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Ā, ko te kaiwhakahaere o te ope o te iwi o ngā tama a Pineamine ko Apirana tama a Kirioni. ");
INSERT INTO mri2012_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Nā, ka maunu ko te kara o te puni o ngā tama a Rāna, ko te hiku tēnā o ngā puni katoa, puta noa i ō rātou ope. Ā, ko te kaiwhakahaere o tāna ope ko Ahiētere tama a Amiharai. ");
INSERT INTO mri2012_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ā, ko te kaiwhakahaere o te ope o te iwi o ngā tama a Āhera ko Pakiere tama a Okorana. ");
INSERT INTO mri2012_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ā, ko te kaiwhakahaere o te ope o te iwi o ngā tama a Napatari ko Ahira tama a Enana. ");
INSERT INTO mri2012_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ko ngā maunutanga ēnei o ngā tama a Īharaira, me ō rātou ope, i ō rātou whakatikanga atu. ");
INSERT INTO mri2012_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Nā, ka mea a Mohi ki a Hōpapa, tama a Reuere Miriani, a te hungawai o Mohi, “E haere ana mātou ki te wāhi mea nei a Ihowā, ‘Ka hoatu a reira e ahau ki a koutou’; haere mai tātou, ka pai tā mātou mahi ki a koe; he pai hoki te kōrero a Ihowā mō Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ā, ka mea tērā ki a ia, “E kore ahau e haere; engari me haere ahau ki tōku whenua, ki ōku whanaunga.” ");
INSERT INTO mri2012_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ā, ka mea ia, “Kaua rā mātou e whakarērea; e mōhio ana hoki koe ki ngā puni mō mātou i te koraha, ā, ka ai koe hei kanohi mō mātou. ");
INSERT INTO mri2012_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Nā, tēnei ake, ki te haere koe i a mātou, inā, tēnei ake ko te pai e meatia mai e Ihowā ki a mātou ka meatia hoki e mātou ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Nā, ka tūria atu e rātou i te maunga o Ihowā, e toru ngā rā i haere ai; ā, i haere te āka o te kawenata o Ihowā i mua i a rātou, i ngā rā e toru i haere ai, ki te titiro okiokinga mō rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ā, i runga i a rātou te kapua o Ihowā i te awatea, i tō rātou whakatikanga atu i te puni. ");
INSERT INTO mri2012_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ā, ka maunu te āka, nā, ka mea a Mohi, “Whakatika, e Ihowā, ā, kia marara ōu hoariri; kia rere hoki i tōu aroaro te hunga e kino ana ki a koe.” ");
INSERT INTO mri2012_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ā, ka tū te āka, nā, ka mea ia, “Hoki mai, e Ihowā, ki ngā mano tini o Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ā, ka tāki amuamu te iwi, ka kōrero kino ki ngā taringa o Ihowā; ā, nō te rongonga o Ihowā, ka mura tōna riri. Ā, ka kā te ahi a Ihowā i roto i a rātou, ā, pau ake te hunga i ngā pito ki waho o te puni. ");
INSERT INTO mri2012_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Nā, ka tangi te iwi ki a Mohi; ā, ka īnoi a Mohi ki a Ihowā, nā, ka mate te ahi. ");
INSERT INTO mri2012_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ā, huaina iho te ingoa o tēnā wāhi ko Tapera; nō te kānga hoki o te ahi a Ihowā i roto i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Nā, ka minamina ngā whakauru i roto i a rātou; me ngā tama hoki a Īharaira i tangi anō, i mea, “Mā wai e hōmai he kikokiko hei kai mā tātou? ");
INSERT INTO mri2012_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","E mahara ana tātou ki ngā ika i kainga noatia e tātou ki Īhipa; ki ngā kūkamo, ki ngā merengi, ki ngā rīki, ki ngā aniana, me te karika. ");
INSERT INTO mri2012_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ko tēnei ia, kua maroke ō tātou wairua; kāhore rawa nei tētahi mea; kāhore he mea kē hei tirohanga mā tātou ko tēnei mana anake.” ");
INSERT INTO mri2012_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Nā, ko te rite o te mana kei te pua korianara; ko tōna kara kei te kara teriuma. ");
INSERT INTO mri2012_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","I kōpikopiko te iwi ki te kohi, ā, hurihia ana e rātou ki ngā mira, i tukia rānei ki te kumete, ā, tunua ana e rātou ki te kōhua, hangā ana hoki hei keke; ko tōna reka kei tō te hinu hou. ");
INSERT INTO mri2012_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ā, i te taunga iho o te haunui ki te puni i te pō, i tau anō te mana ki runga. ");
INSERT INTO mri2012_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ā, i rongo a Mohi i te iwi e tangi ana, puta noa i ō rātou hapū, tēnei, tēnei, i te whatitoka o tōna tēneti; ā, he nui te muranga o te riri o Ihowā; ā, i kino hoki ki tā Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Nā, ka mea a Mohi ki a Ihowā, “He aha koe i whakatupu kino ai i tāu pononga? He aha ahau tē manakohia ai e koe, i whakawahā ai e koe tēnei iwi katoa ki ahau? ");
INSERT INTO mri2012_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","He uri ianei nōku tēnei iwi katoa? I whānau rānei rātou i ahau, i mea ai koe ki ahau, ‘Hikitia ki tōu uma, kia rite ki tā te matua atawhai, ki tāna hiki i te pōtiki,’ ki te whenua i oatitia e koe ki ō rātou mātua? ");
INSERT INTO mri2012_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Nō hea aku kikokiko hei hoatutanga māku ki tēnei iwi katoa? E tangi mai ana hoki rātou ki ahau, e mea mai ana, ‘Hōmai he kikokiko ki a mātou hei kai mā mātou.’ ");
INSERT INTO mri2012_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","E kore tēnei iwi katoa e taea e ahau anake te waha, he taimaha rawa māku. ");
INSERT INTO mri2012_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ā, ki te pēnei tāu mahi ki ahau, tēnā, whakamatea rawatia ahau, ki te mea kua manakohia mai ahau e koe; kaua hoki ahau e kite i te hē mōku.” ");
INSERT INTO mri2012_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Nā, ka mea a Ihowā ki a Mohi: “Huihuia mai ki ahau kia whitu tekau o ngā kaumātua o Īharaira, āu i mōhio ai he kaumātua nō te iwi, he rangatira nō rātou; me kawe mai rātou ki te tapenākara o te whakaminenga, me tū tahi koutou ki reira. ");
INSERT INTO mri2012_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ā, māku e haere iho, e kōrero ki a koe ki reira; me tango anō e ahau tētahi wāhi o te wairua i runga i a koe, ka hoatu ki runga ki a rātou; ā, ko rātou hei hoa mōu ki te waha i te pīkaunga, arā i te iwi; kei waha e koe anake. ");
INSERT INTO mri2012_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Me kī atu hoki e koe ki te iwi: ‘Whakatapu i a koutou mō āpōpō, ā, ka kai kikokiko koutou. Kua tangi nā hoki koutou ki ngā taringa o Ihowā, kua mea, “Mā wai e hōmai he kikokiko hei kai mā mātou? He pai hoki ngā mea i a mātou i Īhipa.” Mō reira ka hōmai e Ihowā he kikokiko ki a koutou, ā, ka kai koutou. ");
INSERT INTO mri2012_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","E kore e kotahi te rā e kai ai koutou, e kore anō hoki e rua ngā rā, e kore e rima ngā rā, e kore e tekau ngā rā, e kore e rua tekau ngā rā; ");
INSERT INTO mri2012_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","engari, kia pau te marama, ā, puta noa i ō koutou ihu, ā, ngaruru iho koutou. Mō koutou i whakahāwea ki a Ihowā e noho nei i waenganui i a koutou, i tangi hoki ki tōna aroaro, i mea, “He aha tātou i haere mai ai i Īhipa?” ’ ");
INSERT INTO mri2012_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","“Ko te iwi kei roto nei ahau i a rātou e ono rau mano, he hunga haere raro, ā, kua mea mai nei koe, ‘Ka hoatu e ahau he kikokiko ki a rātou, ā, kia kotahi tino marama e kai ai rātou.’ ");
INSERT INTO mri2012_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Me patu rānei ngā hipi me ngā kau mā rātou, kia rato ai rātou? Me kohi mai rānei ngā ika katoa o te moana mā rātou, kia rato ai rātou?” ");
INSERT INTO mri2012_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Anō rā ko Ihowā ki a Mohi, “Kua mutua rānei te ringa o Ihowā? Ka kite koe āianei he pono rānei tāku kupu ki a koe, kāhore rānei.” ");
INSERT INTO mri2012_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Nā, ka puta a Mohi ki waho, ā, kōrerotia ana e ia ngā kupu a Ihowā ki te iwi, ā, huihuia ana e ia e whitu tekau o ngā kaumātua o te iwi, ā, whakatūria ana ki tētahi taha, ki tētahi taha o te tapenākara. ");
INSERT INTO mri2012_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Nā, ko te hekenga iho o Ihowā i roto i te kapua, ko te kōrerotanga hoki ki a ia, nā, ka tangohia e ia tētahi wāhi o te wairua i runga i a ia, ā, hoatu ana ki ngā kaumātua e whitu tekau. Ā, i te taunga iho o te wairua ki a rātou, ka poropiti rātou, ā, kore ake i pērā i muri. ");
INSERT INTO mri2012_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ā, tokorua i mahue ki te puni, ko Ererara te ingoa o tētahi, ko Merara te ingoa o tētahi. Nā, ko te taunga iho o te wairua ki runga ki a rāua; nō te hunga hoki rāua i tuhituhia, otiia kīhai i haere ki te tapenākara; nā, ka poropiti rāua i roto i te puni. ");
INSERT INTO mri2012_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Nā, ka oma tētahi taitama ki te kōrero ki a Mohi, ā, ka mea, “Kei te poropiti a Ererara rāua ko Merara i roto i te puni.” ");
INSERT INTO mri2012_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nā, ko te ohonga o te tangata a Mohi, o Hohua tama a Nunu, ko tētahi hoki ia o āna taitamariki, ka mea, “E tōku ariki, e Mohi, rīria rāua.” ");
INSERT INTO mri2012_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Anō rā ko Mohi ki a ia, “He whakaaro ki ahau i hae ai koe? He oranga ngākau rā me i poropiti katoa te iwi o Ihowā, me i tukua iho hoki e Ihowā tōna wairua ki a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Nā, ka haere a Mohi ki roto ki te puni, ā, ia me ngā kaumātua o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Nā, ka puta he hau i a Ihowā, ā, kawea ana mai ngā koitareke i te moana, kua makā ki te taha o te puni, kia kotahi pea te rā e haere ai i tētahi taha, kia kotahi pea hoki te rā e haere ai i tērā taha, ā tawhio noa te puni, me te mea ānō e rua whatīanga te teitei i runga i te mata o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Nā, ka tū te iwi ā pau katoa taua rā, taua pō katoa hoki, me te rā katoa hoki i te aonga ake, ki te kohikohi i ngā koitareke; kotahi tekau ngā homa a te tangata nāna te kohinga iti. Ā, horahorangia noatia atu ana e rātou hei kai mā rātou, ā tawhio noa te puni. ");
INSERT INTO mri2012_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ā, i te mea kei ō rātou niho anō te kikokiko, i te mea kāhore anō i ngaua noatia, nā, ka mura te riri o Ihowā ki te iwi, ā, whiua ana te iwi e Ihowā ki tētahi whiu nui rawa atu. ");
INSERT INTO mri2012_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Nā, huaina iho e ia te ingoa o taua wāhi ko Kipiroto Hataawa; nō te mea i tanumia e rātou ki reira te hunga i minamina. ");
INSERT INTO mri2012_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Nā, ka tūria atu e te iwi i Kipiroto Hataawa ki Hateroto; ā, noho ana i Hateroto. ");
INSERT INTO mri2012_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Nā, ka whakahē a Miriama rāua ko Ārona ki a Mohi mō te wahine Kuhi i mārenatia e ia (he wahine Kuhi hoki tāna i mārena ai); ");
INSERT INTO mri2012_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ā, ka mea rāua, “Koia rānei i a Mohi anake ngā kōrero a Ihowā? Kāhore rānei ana kōrero hoki i a māua?” Ā, ka rongo a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Nā, he tangata māhaki rawa a Mohi i ngā tāngata katoa o te mata o te whenua. ");
INSERT INTO mri2012_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Nā, i ohorere tonu te kōrerotanga a i Ihowā ki a Mohi rātou ko Ārona, ko Miriama, “Puta mai koutou tokotoru ki te tapenākara o te whakaminenga.” Ā, ka puta atu rātou tokotoru. ");
INSERT INTO mri2012_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Nā, ka heke iho a Ihowā i roto i te pou kapua, ā, ka tū ki te whatitoka o te tapenākara, ka karanga hoki ki a Ārona rāua ko Miriama; ā, ka puta rāua. ");
INSERT INTO mri2012_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ā, ka mea ia, “Tēnā, whakarongo ki āku kōrero: Ki te mea he poropiti kei a koutou, ka whakaatu atu ahau, a Ihowā i ahau ki a ia, he mea whakakite, he kōrero moemoeā ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ehara tāku pononga, a Mohi i te pērā; he pono ia i tōku whare katoa. ");
INSERT INTO mri2012_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ka kōrero ahau ki a ia, he māngai, he māngai, he kōrero mata nui, kāhore hoki he kupu ngaro; ā, e kite anō ia i te āhua o Ihowā. He aha rā kōrua tē wehi ai ki te whakahē mō tāku pononga, mō Mohi?” ");
INSERT INTO mri2012_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nā, ka mura te riri o Ihowā ki a rāua, ā, haere ana ia. ");
INSERT INTO mri2012_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Nā, ka riro atu te kapua i runga i te tapenākara; nā! He repera a Miriama, kua rite ki te hukarere; ā, ka titiro a Ārona ki a Miriama, e! He repera. ");
INSERT INTO mri2012_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Nā, ka mea a Ārona ki a Mohi, “Auē, e tōku ariki, kaua e utaina ki a māua tēnei hara i pōauau nei, i hara nei māua. ");
INSERT INTO mri2012_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Kei rite ia ki te mea kua mate, ki te mea kua pau tētahi wāhi o ōna kikokiko i te putanga mai i te kōpū o tōna whaea.” ");
INSERT INTO mri2012_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Nā, ka karanga atu a Mohi ki a Ihowā, ka mea, “E te Atua, tēnā rā, whakaorangia ia.” ");
INSERT INTO mri2012_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Nā, ka mea a Ihowā, ki a Mohi, “Me i tuwha kau tōna pāpā ki tōna mata e kore ianei ia e whakamā, ā, whitu noa ngā rā? Kia whitu ngā rā e tūtakina atu ai ia ki waho o te puni, ā muri iho ka mauria mai anō.” ");
INSERT INTO mri2012_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Nā, tūtakina atu ana a Miriama ki waho o te puni, e whitu ngā rā; kīhai anō hoki te iwi i haere, kia whakahokia mai rā anō a Miriama. ");
INSERT INTO mri2012_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ā muri iho ka tūria e te iwi i Hateroto, ā, noho ana i te koraha o Parana. ");
INSERT INTO mri2012_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Me unga e koe ētahi tāngata hei tūtei mō te whenua o Kanaana, mō tērā e hoatu nei e ahau ki ngā tama a Īharaira. Kia kotahi o tēnei iwi, o tēnei iwi o ō rātou mātua e tonoa e koutou, hei te rangatira anake.” ");
INSERT INTO mri2012_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Nā, ka unga a Mohi i a rātou i te koraha o Parana, ka pērā me tā Ihowā i kī ai; he upoko katoa ēnei tāngata nō ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ko ō rātou ingoa ēnei: nō te iwi o Reupena, ko Hāmua tama a Tākuru; ");
INSERT INTO mri2012_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","nō te iwi o Himiona, ko Hāpata tama a Hori; ");
INSERT INTO mri2012_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","nō te iwi o Hūrā, ko Karepe tama a Iepune; ");
INSERT INTO mri2012_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","nō te iwi o Ihākara, ko Ikara tama a Hōhepa; ");
INSERT INTO mri2012_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","nō te iwi o Ēparaima, ko Hohea tama a Nunu; ");
INSERT INTO mri2012_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","nō te iwi o Pineamine, ko Parati tama a Rapu; ");
INSERT INTO mri2012_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","nō te iwi o Hepurona, ko Kariere tama a Hori; ");
INSERT INTO mri2012_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","nō te iwi o Hōhepa, arā nō te iwi o Mānahi, ko Kari tama a Huhi; ");
INSERT INTO mri2012_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","nō te iwi o Rāna, ko Amiere tama a Kemari; ");
INSERT INTO mri2012_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","nō te iwi o Āhera, ko Heturu tama a Mikaere; ");
INSERT INTO mri2012_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","nō te iwi o Napatari, ko Nahapi tama a Wopohi; ");
INSERT INTO mri2012_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","nō te iwi o Kara, ko Keuere tama a Maki. ");
INSERT INTO mri2012_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ko ngā ingoa ēnei o ngā tāngata i ungā nei e Mohi hei tūtei mō te whenua. Ā, huaina iho e Mohi a Hohea tama a Nunu ko Hohua. ");
INSERT INTO mri2012_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Nā, ka ungā rātou e Mohi hei tūtei mō te whenua o Kanaana, ka mea ia ki a rātou, “Haere atu ki runga nā konei, nā te tonga, ka kake ki te maunga; ");
INSERT INTO mri2012_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ka titiro ai i te whenua, he aha rānei; i te iwi anō hoki e noho ana i reira, he kaha rānei, he kahakore rānei, he tokoouou rānei, he tokomaha rānei. ");
INSERT INTO mri2012_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","He pēhea te whenua e nohoia ana e rātou, he pai rānei, he kino rānei; he pēhea hoki ngā pā e nohoia ana e rātou, he tēneti rānei, he mea taiepa rānei; ");
INSERT INTO mri2012_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","he pēhea hoki te whenua, he mōmona rānei, he kikokore rānei, he rākau rānei tō reira, kāhore rānei. Kia māia hoki, maua mai anō ētahi o ngā hua o te whenua.” Nā, ko taua wā ko te wā o ngā karepe mātāmua. ");
INSERT INTO mri2012_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Nā, ko tō rātou haerenga ki runga, tūteia ana e rātou te whenua i te koraha o Hini, ā tae noa ki Rehopo, ki te haerenga atu ki Hāmata. ");
INSERT INTO mri2012_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ā, i haere rātou nā te tonga, ka tae ki Heperona; ā, i reira a Ahimana, a Hehai, a Tāramai, ngā tama a Anaka. (Nā, ko Heperona, ko tōna hanganga, e whitu ngā tau i mua i tō Toana i Īhipa.) ");
INSERT INTO mri2012_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ā, ka tae iho rātou ki te awaawa ki Ehekora, ka tapahia i reira he manga karepe, kotahi te tautau, ka amohia e te tokorua i runga i te tokotoko; i mauria mai anō ētahi pamekaranete, me ētahi piki. ");
INSERT INTO mri2012_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ā, huaina iho taua wāhi ko te raorao o Ehekora, nō te tautau karepe i tapahia e ngā tama a Īharaira i reira. ");
INSERT INTO mri2012_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Nō te paunga o ngā rā e whā tekau ka hoki mai rātou i te tūtei i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Nā, haere ana, ā, ka tae ki a Mohi rātou ko Ārona, ko te whakaminenga katoa o ngā tama a Īharaira, ki te koraha o Parana, ki Karehe; ki te whakahoki i te kōrero ki a rātou ko te whakaminenga katoa, ā, whakakitea ana e rātou ngā hua o te whenua ki a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ā, ka kōrero ki a ia, ka mea, “I tae mātou ki te whenua i ungā nei mātou e koe, nā, he pono e rerengia ana e te waiū, e te honi; ko ōna hua tēnei. ");
INSERT INTO mri2012_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Otiia he kaha te iwi e noho ana i taua whenua, he mea taiepa hoki ngā pā, he nunui rawa; i kite anō mātou i ngā tama a Anaka ki reira. ");
INSERT INTO mri2012_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","E noho ana ngā Amareki i te whenua ki te tonga; ko ngā Hiti, ko ngā Iepuhi, ko ngā Amori, e noho ana i ngā maunga; kei te taha o te moana ngā Kanaani e noho ana, kei te taha anō o Horano.” ");
INSERT INTO mri2012_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Nā, ka whakamārietia te iwi e Karepe i te aroaro o Mohi, ā, ka mea ia, “Kia hohoro tā tātou haere ki te tango i reira; e taea hoki e tātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ko ngā tāngata ia i haere tahi me ia ki runga, i mea, “E kore e āhei i a tātou te haere ki runga, ki taua iwi; he kaha ake hoki rātou i a tātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Nā, ka kawea e rātou he kōrero kino mō te whenua i tūteia e rātou ki ngā tama a Īharaira, i mea rātou, “Ko taua whenua i haerea rā e mātou, i tūteia, he whenua e ngau ana i ōna tāngata; he tangata nunui rawa hoki te hunga katoa i kitea e mātou ki reira. ");
INSERT INTO mri2012_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","He nunui rawa hoki ngā tāngata i kitea e mātou ki reira, he tama nā Anaka, he uri nō ngā tāngata roroa; ā, ki tā mātou titiro, me he māwhitiwhiti mātou; he pērā anō mātou ki tā rātou titiro.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Nā, ka hāmama te reo o te whakaminenga katoa; ā, ka tangi te iwi i taua pō. ");
INSERT INTO mri2012_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ā, amuamu ana ngā tama katoa a Īharaira ki a Mohi rāua ko Ārona; ā, ka mea te whakaminenga katoa ki a rāua, “Auē, me i mate tātou ki te whenua o Īhipa! Auē, me i mate rānei tātou ki tēnei koraha! ");
INSERT INTO mri2012_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","He aha tātou i kawea mai ai e Ihowā ki tēnei whenua, kia hinga i te hoari? Ka waiho ā tātou wāhine, ā tātou tamariki hei taonga pārau; ehara ianei te hoki ki Īhipa i te mea pai mō tātou?” ");
INSERT INTO mri2012_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ā, ka mea rātou tētahi ki tētahi, “Me whakatū he upoko mō tātou, ka hoki ki Īhipa.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Nā, ka tāpapa a Mohi rāua ko Ārona ki te aroaro o te huihui katoa o te whakaminenga o ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ā, ka haehae a Hohua, tama a Nunu, rāua ko Karepe, tama a Iepune, i ō rāua kākahu; ko rāua hoki ētahi o ngā kaitūtei o te whenua; ");
INSERT INTO mri2012_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ā, ka kōrero rāua ki te whakaminenga katoa o ngā tama a Īharaira, ka mea, “He whenua pai rawa te whenua i haerea nei, i tūteia nei e mātou. ");
INSERT INTO mri2012_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ki te aro mai a Ihowā ki a tātou, ka kawea tātou e ia ki taua whenua, ka hōmai anō e ia ki a tātou; he whenua e rerengia ana e te waiū, e te honi. ");
INSERT INTO mri2012_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Kaua rāia koutou e tutū ki a Ihowā, kaua hoki e wehi i ngā tāngata o taua whenua, he taro hoki rātou mā tātou. Kua mahue rātou i tō rātou whakamarumaru, ā, kei a tātou a Ihowā; kaua e wehi i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Heoi, ko tā te whakaminenga katoa kī, “Me āki rāua ki te kōhatu.” Nā, ko te putanga mai o te korōria o Ihowā i runga i te tapenākara o te whakaminenga ki te aroaro o ngā tama katoa a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Nā, ka mea a Ihowā ki a Mohi, “Kia pēhea ake te roa o te whakahāwea a tēnei iwi ki ahau? Āhea rānei rātou whakapono ai ki ahau, he maha nei hoki āku tohu i whakakitea i roto i a rātou? ");
INSERT INTO mri2012_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ka patua rātou e ahau ki te mate urutā, ka peia atu, ā, ka meinga koe hei iwi nui atu, kaha atu, i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Anō rā ko Mohi ki a Ihowā, “Ākuanei ka rongo ngā Īhipiana; nāu hoki tēnei iwi i whakaputa mai i runga i tōu kaha i roto i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Nā, ka kōrero rātou ki ngā tāngata o tēnei whenua. Kua rongo hoki rātou kei roto koe, e Ihowā, i tēnei iwi; e kitea ana anō koe e Ihowā, titiro atu, titiro mai, e tū ana hoki tōu kapua i runga i a rātou, e haere ana hoki koe i mua i a rātou i roto i te pou kapua i te awatea, i roto hoki i te pou ahi i te pō. ");
INSERT INTO mri2012_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Nā, ki te whakamatea e koe tēnei iwi, ānō he tangata kotahi, kātahi ngā iwi i rongo nei ki tōu rongo ka whai kupu, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Nō te mea kīhai i kaha a Ihowā ki te kawe i tēnei iwi ki te whenua i oati ai ia ki a rātou, koia i whakamatea ai rātou e ia ki te koraha.’ ");
INSERT INTO mri2012_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Nā, kia nui rā te kaha o tōku Ariki, kia rite ki tāu i kōrero ai, i mea ai, ");
INSERT INTO mri2012_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘He pūhoi a Ihowā ki te riri, he nui tōna atawhai, e muru ana i te kino, i te tutū, e kore rawa anō e tuku noa i te hunga hē; e mea ana i te kino o ngā mātua kia tau ki ngā tamariki, ā te toru, te whā rā anō, o ngā whakatupuranga.’ ");
INSERT INTO mri2012_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Tēnā, murua te kino o tēnei iwi, kia rite ki te nui o tōu atawhai, ki tāu muru hoki i ngā hara o tēnei iwi, o Īhipa mai anō, ā taea noatia a konei.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Nā, ka mea a Ihowā, “Kua murua e ahau, kua pērātia me tāu i kī mai nā. ");
INSERT INTO mri2012_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Otiia – e ora nei ahau, ā, ka kapi te whenua katoa i te korōria o Ihowā – ");
INSERT INTO mri2012_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","nā, i te mea ko ēnei tāngata katoa, i kite nei i tōku korōria, i āku merekara hoki i meinga ki Īhipa, ki te koraha, ā, ka tekau nei ā rātou whakamātautauranga i ahau, kāhore anō i whakarongo ki tōku reo; ");
INSERT INTO mri2012_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","inā, e kore rawa rātou e kite i te whenua i oati ai ahau ki ō rātou mātua, e kore anō tētahi o te hunga i whakahāwea nei ki ahau e kite i reira. ");
INSERT INTO mri2012_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","“Engari tāku pononga a Karepe, he wairua kē hoki tōna, ā, kua tino whai ia i ahau; e kawea ia e ahau ki te whenua i haere atu nā ia; ā, ka riro a reira i ōna uri. ");
INSERT INTO mri2012_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","“Nā, kei te raorao ngā Amareki me ngā Kanaani e noho ana. Tahuri atu koutou āpōpō, haere atu ki te koraha, nā te huarahi ki te Moana Whero.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","I kōrero anō a Ihowā ki a Mohi rāua ko Ārona, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Kia pēhea ake te roa o tāku whakamanawanui ki tēnei whakaminenga kino, e amuamu nei ki ahau? Kua rangona e ahau ngā amuamu a ngā tama a Īharaira, e amuamu nei rātou ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Mea atu ki a rātou, ‘E ora ana ahau,’ e ai tā Ihowā, ‘ko tā koutou i kōrero mai ai ki ōku taringa, he pono, ko tāku tēnā e mea ai ki a koutou: ");
INSERT INTO mri2012_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ka hinga ō koutou tinana ki tēnei koraha; ā, ko koutou katoa i taua, puta noa atu i tō koutou tokomaha, ngā mea e rua tekau, he maha ake hoki, ō rātou tau, te hunga hoki i amuamu nei ki ahau, ");
INSERT INTO mri2012_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","e kore koutou e tae ki te whenua i oati ai ahau ka whakanohoia koutou ki reira, heoi anō ko Karepe tama a Iepune, rāua ko Hohua tama a Nunu. ");
INSERT INTO mri2012_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Otiia, ko ā koutou pōtiki, i mea nā koutou ka waiho hei taonga pārau, ka kawea e ahau ki reira, ā, ka mōhio rātou ki te whenua i whakahāweatia nei e koutou. ");
INSERT INTO mri2012_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ko koutou ia, ka hinga ō koutou tinana ki tēnei koraha. ");
INSERT INTO mri2012_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ā, ka kōpikopiko noa ā koutou tamariki i te koraha, e whā tekau ngā tau, mā rātou hoki e waha ā koutou pūremutanga, kia poto rā anō ō koutou tinana ki te koraha. ");
INSERT INTO mri2012_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kia rite rā anō ki te maha o ngā rā, ki ngā rā e whā tekau, i tūteia ai e koutou te whenua, he tau he rā, he tau he rā; e whā tekau ngā tau e waha ai e koutou ō koutou kino, ā, ka mōhio koutou ki te takanga o tāku kupu.’ ");
INSERT INTO mri2012_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nāku, nā Ihowā te kupu, inā, ka meatia tēnei e ahau ki tēnei whakaminenga kino katoa, kua huihui nei ki te whakahē ki ahau. Ka poto rātou ki tēnei koraha, ka mate anō hoki ki konei.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Nā, ko ngā tāngata i ungā e Mohi hei tūtei mō te whenua, i hoki mai nei, i mea nei kia amuamutia ia e te whakaminenga katoa, i tā rātou kawenga mai i te kōrero kino mō te whenua, ");
INSERT INTO mri2012_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ko aua tāngata, nā rātou nei i kawe mai te kōrero kino mō te whenua, i mate rātou i te whiu ki te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ko Hohua ia, tama a Nunu, rāua ko Karepe, tama a Iepune, ko rāua i ora o ngā tāngata i haere ki te tūtei i te whenua. ");
INSERT INTO mri2012_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Nā, kōrerotia ana e Mohi ēnei kupu katoa ki ngā tama katoa a Īharaira; ā, ka pōuri rawa te iwi. ");
INSERT INTO mri2012_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Nā, ka maranga wawe rātou i te ata, ā, ka haere ki te tihi o te maunga, me te kī anō, “Tēnei mātou, ā, ka haere mātou ki runga, ki te wāhi i kōrerotia mai e Ihowā; kua hara hoki mātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Nā, ka mea a Mohi, “He aha koutou i takahi ai i te kupu a Ihowā, i te mea kāhore e whai wāhi? ");
INSERT INTO mri2012_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Kaua e haere, kāhore nā hoki a Ihowā i a koutou, kei patua koutou ki te aroaro o ō koutou hoariri. ");
INSERT INTO mri2012_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Kei reira hoki ngā Amareki rātou ko ngā Kanaani, kei mua i a koutou, ā, ka hinga koutou i te hoari; mō koutou kua tahuri atu i te whai i a Ihowā, koia a Ihowā tē piri ai ki a koutou.” ");
INSERT INTO mri2012_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Heoi, ka pokanoa rātou ki te piki ki te tihi o te maunga; otiia kīhai te āka o te kawenata a Ihowā, me Mohi hoki, i hiki atu i te puni. ");
INSERT INTO mri2012_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Nā, ka heke iho ngā Amareki rātou ko ngā Kanaani e noho ana i taua maunga, ā, patua ana rātou, tukituki rawa, ā taea noatia a Horema. ");
INSERT INTO mri2012_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","I kōrero anō a Ihowā, ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: E tae koutou ki te whenua e noho ai koutou, ki tāku e hoatu ai ki a koutou, ");
INSERT INTO mri2012_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ā, ka mea i te whakahere ahi ki a Ihowā – i te tahunga tinana, i te patunga tapu rānei hei whakamana mō te kī taurangi, i te whakahere tuku noa rānei, i ā koutou hākari nunui rānei – hei whakakakara reka ki a Ihowā, he mea nō ngā kau, nō ngā hipi rānei. ");
INSERT INTO mri2012_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Nā, me kawe mai tāna whakahere e te kaiwhakahere ki a Ihowā he whakahere totokore, ko te whakatekau o te epa o te parāoa pai, he mea kōnatunatu ki te whakawhā o te hine hinu. ");
INSERT INTO mri2012_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Kia rite mai anō i a koe te whakawhā o te hine wāina, hei ringihanga, hei kīnaki mō te tahunga tinana, mō te patunga tapu rānei, mō te reme kotahi. ");
INSERT INTO mri2012_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Ki te mea he hipi toa, kia rite i a koe hei whakahere totokore ngā whakatekau e rua o te epa o te parāoa pai, he mea kōnatunatu ki te whakatoru o te hine hinu. ");
INSERT INTO mri2012_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Me whakahere anō e koe te whakatoru o te hine wāina hei ringihanga, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Ā, ka mea koe i te pūru hei tahunga tinana, hei patunga tapu rānei, hei whakamana i te kupu taurangi, hei whakahere rānei mō te pai ki a Ihowā; ");
INSERT INTO mri2012_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","nā, me kawe tahi anō e ia me te pūru, hei whakahere totokore, kia toru ngā whakatekau o te epa o te parāoa pai, he mea kōnatunatu ki te hāwhe o te hine hinu. ");
INSERT INTO mri2012_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Me kawe anō e koe te hāwhe o te hine wāina hei ringihanga, hei whakahere ahi, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Kia pēnei te meatanga mō te pūru kotahi, mō te hipi toa kotahi, mō te reme toa, mō te kūao koati. ");
INSERT INTO mri2012_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Kia rite ki te maha o ā koutou e tuku ai tā koutou e mea ai ki tētahi, ki tētahi, kia rite tonu ki te maha o rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Kia pēnei te meatanga a ngā tāngata whenua katoa i ēnei mea, ina whakahere i te whakahere ahi, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ā, ki te noho i a koe tētahi manene, tētahi noa atu rānei, i roto i a koutou i ō koutou whakatupuranga, ā, ka mea kia whakahere i te whakahere ahi, i te kakara reka ki a Ihowā; kia rite tāna e mea ai ki tā koutou e mea ai. ");
INSERT INTO mri2012_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Mō te whakaminenga kia kotahi te tikanga mō koutou, mō te manene hoki e noho tahi ana me koutou, hei tikanga pūmau i ō koutou whakatupuranga; kia pērā anō me koutou te manene i te aroaro o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Kia kotahi anō te ture, kia kotahi anō te ritenga mō koutou, mō te manene hoki e noho ana i a koutou. ");
INSERT INTO mri2012_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","“I kōrero anō a Ihowā ki a Mohi, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Kōrero ki ngā tama a Īharaira, mea atu ki a rātou: E tae koutou ki te whenua e kawea nei koutou e ahau ki reira, ");
INSERT INTO mri2012_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","nā, e kai koutou i te taro o te whenua, me whakahere he whakahere hapahapai ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Me whakahere he keke nō tā koutou parāoa pokepoke mataati hei whakahere hapahapai; kia rite ki te whakahere hapahapai o te patunga wīti tā koutou hapahapai. ");
INSERT INTO mri2012_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Me hoatu tētahi wāhi o tā koutou pokepokenga mataati ki a Ihowā, hei whakahere hapahapai, puta noa i ō koutou whakatupuranga. ");
INSERT INTO mri2012_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Ā, ki te mea kua pōhēhē koutou, ā, kīhai i rite ēnei whakahau katoa i kōrerotia nei e Ihowā ki a Mohi – ");
INSERT INTO mri2012_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","arā ngā mea katoa i whakahaua ai koutou e Ihowā, i kōrerotia e Mohi, o te rā anō i whakahau ai a Ihowā ā tuku iho ki ō koutou whakatupuranga – ");
INSERT INTO mri2012_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ko reira, ki te meatia tētahi mea, he pōhēhē hoki, e ngaro ana i ngā kanohi o te whakaminenga, nā, me whakahere e te whakaminenga katoa tētahi pūru kūao hei tahunga tinana, hei kakara reka ki a Ihowā, me tōna whakahere totokore, me tōna ringihanga; kia rite ki te tikanga, kia kotahi hoki koati toa hei whakahere hara. ");
INSERT INTO mri2012_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Ā, ka whakamārie te tohunga mō te whakaminenga katoa o ngā tama a Īharaira, ā, ka murua tō rātou hē; he pōhēhē hoki; ā, me kawe tā rātou whakahere, hei whakahere ahi ki a Ihowā, me tā rātou whakahere hara ki te aroaro o Ihowā, mō tō rātou pōhēhē. ");
INSERT INTO mri2012_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ā, ka murua taua hē o te whakaminenga katoa o ngā tama a Īharaira, o te manene anō e noho ana i a rātou; nō te mea i pōhēhē katoa te iwi. ");
INSERT INTO mri2012_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Ki te pōhēhē anō tētahi wairua, ā, ka hara, nā, me kawe mai e ia he koati uha, hei te tau tahi, hei whakahere hara. ");
INSERT INTO mri2012_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ā, me whakamārie te tohunga mō te wairua i hara pōhēhē, ina hara pōhēhē ia, ki te aroaro o Ihowā, hei whakamārie mōna; ā, ka murua tāna. ");
INSERT INTO mri2012_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","“Kia kotahi anō tā koutou ture mō te tangata i hara pōhēhē, mō te tangata whenua o ngā tama a Īharaira rāua ko te manene e noho ana i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Ko te wairua ia i whakakake, ahakoa tangata whenua, manene rānei, he kohukohu tāna i a Ihowā; ā, ka hātepea atu taua wairua i roto i tōna iwi. ");
INSERT INTO mri2012_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","I whakahāwea ia ki te kupu a Ihowā, i whakataka hoki i tāna whakahau; ka tino hātepea atu taua wairua; ka mau tōna kino ki a ia.” ");
INSERT INTO mri2012_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ā, i ngā tama a Īharaira i te koraha, ka kitea tētahi tangata e kohikohi rākau ana i te rā hāpati. ");
INSERT INTO mri2012_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Nā, ka kawea ia e ngā tāngata, i kite rā i a ia e kohikohi ana i ngā rākau, ki a Mohi rāua ko Ārona, ā, ki te whakaminenga katoa. ");
INSERT INTO mri2012_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Nā, hoatu ana ia e rātou kia tiakina, nō te mea kāhore anō i whakaaturia me aha ia. ");
INSERT INTO mri2012_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ā, ka mea a Ihowā ki a Mohi, “Me whakamate rawa tēnā tangata; mā te whakaminenga katoa ia e āki ki te kōhatu ki waho o te puni.” ");
INSERT INTO mri2012_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Nā, kawea ana ia e te whakaminenga katoa ki waho o te puni, ā, ākina ana ki te kōhatu, ā, ka mate; pērā me tā Ihowā i whakahau ai ki a Mohi. ");
INSERT INTO mri2012_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Kōrero ki ngā tama a Īharaira, mea atu ki a rātou kia hangā ētahi tāniko mō rātou, mō ngā taha o ō rātou kākahu, puta noa i ō rātou whakatupuranga, kia karapitia hoki te tāniko o te pito ki te miro purū; ");
INSERT INTO mri2012_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ā, hei tāniko tēnā mō koutou, hei titiro iho mā koutou, nā, ka mahara ki ngā whakahau katoa a Ihowā, ā, ka mahi; kei rapu koutou i tā ō koutou ngākau, i tā ō koutou kanohi, arā i ngā mea e whāia atu nei, e pūremutia atu nei e koutou. ");
INSERT INTO mri2012_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Kia mahara ai koutou ki te mahi i āku whakahau katoa, kia tapu ai hoki ki tō koutou Atua. ");
INSERT INTO mri2012_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ko Ihowā ahau, ko tō koutou Atua i kawe mai nei i a koutou i te whenua o Īhipa, kia waiho ai ahau hei Atua mō koutou: Ko Ihowā ahau, ko tō koutou Atua.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Nā, ka tango tāngata a Koraha tama a Itihara, tama a Kohata, tama a Rīwai, rātou ko Ratana, ko Āpirama, tama a Eriapa, ko Ono hoki, tama a Perete, he tama nā Reupena; ");
INSERT INTO mri2012_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ā, ka whakatika rātou ki te aroaro o Mohi, me ētahi o ngā tama a Īharaira, e rua rau e rima tekau, he rangatira nō te whakaminenga, e rangona ana i roto i te huihui, he hunga whai ingoa. ");
INSERT INTO mri2012_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ka whakahuihui rātou i a rātou ki a Mohi rāua ko Ārona, ka mea ki a rāua, “He kaha rawa tā kōrua tango tikanga, he tapu kau nei te whakaminenga katoa, kei waenganui anō hoki a Ihowā i a rātou. He aha rā kōrua i whakanui ai i a kōrua ki runga ake i te whakaminenga a Ihowā?” ");
INSERT INTO mri2012_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ā, nō te rongonga o Mohi, ka hinga tāpapa iho ia; ");
INSERT INTO mri2012_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ā, ka kōrero ki a Koraha rātou ko tāna hui katoa, ka mea: “Ā te ata ka whakaaturia mai e Ihowā ko wai tāna, ko wai te mea tapu; ka meinga anō e ia kia whakatata ki a ia. Ko tāna i whiriwhiri ai, ko ia tāna e mea ai kia whakatata ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ko tēnei tā koutou e mea ai: Tīkina ētahi tahu kakara mā koutou, e Koraha rātou ko tāna hui katoa; ");
INSERT INTO mri2012_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ka makā hoki he ahi ki roto, ka mea ai i te whakakakara ki runga, ki te aroaro o Ihowā āpōpō, ā, ko te tangata e whiriwhiri ai a Ihowā, ko ia te mea tapu; kāti tā koutou, e ngā tama a Rīwai.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","I mea anō a Mohi ki a Koraha, “Nā, whakarongo mai, e ngā tama a Rīwai! ");
INSERT INTO mri2012_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","He mea iti ianei ki tā koutou kia wehea koutou e te Atua o Īharaira i roto i te huihui o Īharaira, kia meinga kia whakatata ki a ia, kia mahi i te mahi o te tapenākara o Ihowā, kia tū hoki ki te aroaro o te hui, hei minita mā rātou? ");
INSERT INTO mri2012_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kua meinga anō koe e ia kia tata, koutou tahi ko ōu tēina katoa, ko ngā tama a Rīwai; nā, me whai anō hoki e koutou te tohungatanga? ");
INSERT INTO mri2012_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Koia koutou ko tāu hui katoa ka huihui nei ki a Ihowā; ko Ārona hoki, he aha ia, i amuamu ai koutou ki a ia?” ");
INSERT INTO mri2012_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Nā, ka tono tāngata a Mohi hei karanga i a Ratana rāua ko Āpirama, i ngā tama a Eriapa; ā, ka mea rāua, “E kore māua e haere atu. ");
INSERT INTO mri2012_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","He mea iti ianei tāu kawe mai i a mātou i te whenua e rerengia ana e te waiū, e te honi, kia mate ai mātou ki te koraha, ā, ka mea rawa hoki koe i a koe hei rangatira ki runga i a mātou? ");
INSERT INTO mri2012_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kāhore anō hoki koe i kawe i a mātou ki te whenua e rerengia ana e te waiū, e te honi, i hōmai rānei i ngā māra, i ngā kāri, hei kāinga. Ka pokaia rānei e koe ngā kanohi o ngā tāngata nei? E kore mātou e haere atu!” ");
INSERT INTO mri2012_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Nā, ko te tino riringa o Mohi, ka mea ki a Ihowā, “Kaua e tahuri ki tā rātou whakahere. Kāhore anō kia kotahi te kāihe i tangohia e ahau i a rātou, kāhore anō ahau i kino noa ki tētahi o rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Nā, ka mea a Mohi ki a Koraha, “Puta mai koutou ko tāu hui katoa ki te aroaro o Ihowā āpōpō, a koe, me rātou ko Ārona, āpōpō. ");
INSERT INTO mri2012_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ā, me mau e tēnei, e tēnei o koutou tāna tahu kakara, ka mea he whakakakara ki runga, ka kawe ai tēnā i tāna tahu kakara, i tāna ki te aroaro o Ihowā, kia rua rau kia rima tekau ngā tahu kakara; ā, koe me tāu tahu kakara, a Ārona hoki me tāna.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Nā, ka mau rātou ki tāna tahu kakara, ki tāna tahu kakara, ā, hoatu ana he ahi ki roto, meatia ana hoki he whakakakara ki runga, ā, ka tū tahi me Mohi rāua ko Ārona ki te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Nā, ka tāwhiua e Koraha te whakaminenga katoa ki a rāua ki te whatitoka o te tapenākara o te whakaminenga; ā, ka puta mai te korōria o Ihowā ki te whakaminenga katoa. ");
INSERT INTO mri2012_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Nā, ka kōrero a Ihowā ki a Mohi rāua ko Ārona, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Wehea atu kōrua i roto i tēnei whakaminenga, e kore hoki e aha ka pau rātou i ahau.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Nā, ka tāpapa rāua, ka mea, “E te Atua, e te Atua o ngā wairua o ngā kikokiko katoa, kia hara rānei te tangata kotahi, ā, ka riri koe ki te whakaminenga katoa?” ");
INSERT INTO mri2012_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Nā, ka kōrero a Ihowā ki a Mohi, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Kōrero ki te whakaminenga, mea atu: ‘Whakatika i te tapenākara o Koraha, o Ratana, o Āpirama.’ ” ");
INSERT INTO mri2012_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Nā, ka whakatika a Mohi, ka haere ki a Ratana rāua ko Āpirama; me te whai tahi anō ngā kaumātua o Īharaira i a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Nā, ka kōrero ia ki te whakaminenga, ka mea, “Tēnā, mawehe mai i ngā tēneti o ēnei tāngata kikino, kaua hoki e pā ki tētahi mea a rātou, kei ngaro koutou i roto i ō rātou hara katoa.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Nā, ka whakatika rātou i ngā taha katoa o te tapenākara o Koraha, o Ratana, o Āpirama. Ā, ka puta a Ratana rāua ko Āpirama, ka tū ki ngā whatitoka o ō rāua tēneti, rātou ko ā rātou wāhine, ko ā rātou tama, ko ā rātou kōhungahunga hoki. ");
INSERT INTO mri2012_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Nā, ka mea a Mohi, “Mā tēnei e mōhio ai koutou nā Ihowā ahau i unga mai ki te mahi i ēnei mahi katoa; ā, ehara i te mea whakaaro noa ake nāku. ");
INSERT INTO mri2012_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ki te mea ko te mate o ngā tāngata katoa te mate mō ēnei, ko te whiu rānei o ngā tāngata katoa te whiu mō rātou, kāhore ahau i ungā mai e Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Tēnā ko tēnei, ka pokaia houtia e Ihowā he mahi hou, ā, ka hāmama te waha o te oneone, ā, ka horomia rātou me ā rātou mea katoa, ā, ka heke ora rātou ki te rua; kātahi koutou ka mōhio i whakahāwea ēnei tāngata ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ā mutu kau tāna kōrero i ēnei kōrero katoa, ko te tino kowheratanga o te oneone i raro i a rātou; ");
INSERT INTO mri2012_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","nā, hāmama ana te waha o te whenua, horomia ake hoki rātou me ō rātou whare, me ngā tāngata katoa o Koraha, me ō rātou rawa katoa. ");
INSERT INTO mri2012_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ā, heke ora ana rātou me ā rātou mea katoa ki te rua, nā, ka taupokina iho rātou e te whenua; ā, ngaro iho rātou i roto i te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Nā, rere ana a Īharaira katoa i ngā taha katoa o rātou i tō rātou auē; i mea hoki, “Kei horomia hoki tātou e te whenua.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Nā, ka puta mai he ahi i a Ihowā, ā, pau ake ngā tāngata e rua rau e rima tekau i whakahere nei i te whakakakara. ");
INSERT INTO mri2012_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Nā, ka kōrero a Ihowā ki a Mohi, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Mea atu ki a Ereātara tama a te tohunga, a Ārona, kia tangohia ake e ia ngā tahu kakara i roto i te tahunga, ā, rukerukea atu hoki e koe te ahi ki kō; he tapu hoki ēnā; ");
INSERT INTO mri2012_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ko ngā tahu kakara anō a taua hunga i hara rā ki ō rātou wairua, me hangā hei papa pāraharaha, hei kōpaki mō te āta. I tāpaea hoki ki te aroaro o Ihowā, koia i tapu ai; ā, ka waiho hei tohu ki ngā tama a Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Nā, tīkina atu ana e te tohunga, e Ereātara, ngā tahu kakara parāhi i tāpaea e te hunga i tahuna rā, ā, ka hangā hei papa pāraharaha, hei kōpaki mō te āta. ");
INSERT INTO mri2012_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Hei whakamahara mō ngā tama a Īharaira, kei whakatata he tangata kē, ehara nei i te uri nō Ārona, ki te tahu whakakakara ki te aroaro o Ihowā. Kei rite ki a Koraha rātou ko tāna hui; ko tā Ihowā tēnei i kōrerotia e Mohi ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Otiia, i te aonga ake ka amuamu te whakaminenga katoa o ngā tama a Īharaira ki a Mohi rāua ko Ārona, ka mea, “Nā kōrua i mate ai te iwi a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ā, i te huihuinga o te whakaminenga katoa ki a Mohi rāua ko Ārona, i tō rātou tahuritanga ake ki te tapenākara o te whakaminenga, e! Kua taupokina e te kapua, ā, ka kitea te korōria o Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Nā, ka haere a Mohi rāua ko Ārona ki mua i te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ā, ka kōrero a Ihowā ki a Mohi, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Whakatika atu kōrua i roto i tēnei whakaminenga, e kore e aha ka pau rātou i ahau.” Nā, ka tāpapa iho rāua. ");
INSERT INTO mri2012_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Nā, ka mea a Mohi ki a Ārona, “E mau ki te tahu kakara, meatia iho hoki he ahi i te āta, ka hoatu ai i te whakakakara ki runga, ā, kia hohoro te haere ki te whakaminenga, te whakamārie mō rātou; kua puta he riri i te aroaro o Ihowā; kua tīmata te whiu.” ");
INSERT INTO mri2012_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Nā, tīkina ana e Ārona, pērātia ana me tā Mohi i kī ai, ā, rere ana ia ki waenganui o te whakaminenga; nā, kua tīmata tēnā te whiu i roto i te iwi. Nā, ka makā iho e ia he whakakakara, ā, ka whakamārie mō te iwi. ");
INSERT INTO mri2012_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Nā, tū ana ia i waenganui o te hunga mate, o te hunga ora; ā, ka mutu te whiu. ");
INSERT INTO mri2012_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Nā, ko ngā tāngata i mate i te whiu, kotahi tekau mā whā mano e whitu rau, hāunga ērā i mate i tō Koraha rā. ");
INSERT INTO mri2012_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Nā, hoki ana a Ārona ki a Mohi, ki te whatitoka o te tapenākara o te whakaminenga, ā mutu iho te whiu. ");
INSERT INTO mri2012_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Kōrero ki ngā tama a Īharaira, tangohia mai anō he tokotoko i tēnei, i tēnei, o rātou, i ngā whare o ō rātou mātua, i ngā ariki katoa o ngā whare o ō rātou mātua, kia kotahi tekau mā rua ngā tokotoko. Me tuhituhi te ingoa o tēnei, o tēnei, ki tāna tokotoko. ");
INSERT INTO mri2012_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Me tuhituhi anō hoki te ingoa o Ārona ki te tokotoko a Rīwai. Ā, kia kotahi te tokotoko mā ia upoko o te whare o ō rātou mātua. ");
INSERT INTO mri2012_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ā, me whakatakoto e koe ki roto ki te tapenākara o te whakaminenga ki mua o te whakaaturanga, ki te wāhi e tūtaki ai ahau ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Nā, ko te tangata e whiriwhiri ai ahau, ka pihi tāna tokotoko, ā, ka pēhia atu e ahau te amuamu a ngā tama a Īharaira, e amuamu nei ki a kōrua.” ");
INSERT INTO mri2012_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Nā, ka kōrero a Mohi ki ngā tama a Īharaira, ā, hōmai ana e ō rātou ariki katoa ki a ia, he tokotoko e tēnei ariki, he tokotoko e tēnei ariki, e ngā whare o ō rātou mātua, kotahi tekau mā rua ngā tokotoko; i roto anō i ā rātou tokotoko te tokotoko a Ārona. ");
INSERT INTO mri2012_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ā, whakatakotoria ana ngā tokotoko e Mohi ki te aroaro o Ihowā ki te tapenākara o te whakaaturanga. ");
INSERT INTO mri2012_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ā, i te aonga ake, nā, ka haere a Mohi ki te tapenākara o te whakaaturanga, e! Kua pihi te tokotoko a Ārona, tā te whare o Rīwai, kua wana, kua rāpupuku, kua kohera hoki he puāwai, kua hua he aramona. ");
INSERT INTO mri2012_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Nā, kawea ana e Mohi ngā tokotoko katoa i te aroaro o Ihowā ki ngā tama katoa a Īharaira; ā, tirohia iho ana e rātou, tangohia ana hoki e rātou tāna tokotoko, tāna tokotoko. ");
INSERT INTO mri2012_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Nā, ka mea a Ihowā ki a Mohi, “Whakahokia mai te tokotoko a Ārona ki mua i te Whakaaturanga, kia tiakina, hei tohu ki te hunga tutū; ā, ka kore i a koe ā rātou amuamu e rongo nei ahau, kei mate rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ā, pērātia ana e Mohi, rite tonu ki tā Ihowā i whakahau ai ki a ia tāna i mea ai. ");
INSERT INTO mri2012_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Nā, ka mea ngā tama a Īharaira ki a Mohi, “Nanā, ka mate mātou, ka ngaro mātou, ngaro katoa. ");
INSERT INTO mri2012_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ko te tangata e whakatata ana ki te tapenākara o Ihowā, ka mate. Kia poto rānei mātou katoa ki te mate?” ");
INSERT INTO mri2012_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","I mea anō a Ihowā ki a Ārona, “Māu, mā āu tama, mā koutou ko te whare o tōu pāpā e waha te kino o te wāhi tapu; ā, mā koutou ko āu tama e waha te kino o tā koutou mahi tohunga. ");
INSERT INTO mri2012_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ā, ko ōu tēina hoki, o te iwi o Rīwai, o te iwi o tōu pāpā, me whakatata tahi me koe, kia tāpiritia ai rātou ki a koe, hei minita ki a koe; ko koutou tahi ia ko āu tama hei te tapenākara o te whakaaturanga. ");
INSERT INTO mri2012_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ā, mā rātou tāu mahi e tiaki, me te mahi tiaki o te tapenākara katoa. Otiia, kaua e whakatata ki ngā oko o te wāhi tapu, ki te āta rānei, kei mate ko rātou, ko koutou rānei. ");
INSERT INTO mri2012_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ā, ka tāpiritia rātou ki a koe, hei tiaki i ngā mea o te tapenākara o te whakaminenga, mō ngā mahi katoa o te tapenākara; kaua hoki te tangata kē e tata ki a koutou. ");
INSERT INTO mri2012_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Mā koutou hoki e tiaki ngā mea o te wāhi tapu, me ngā mea o te āta; kei puta he riri ki ngā tama a Īharaira ā muri ake nei. ");
INSERT INTO mri2012_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Me ahau hoki, nanā, kua tango ahau i ō koutou tēina, i ngā Rīwaiti i roto i ngā tama a Īharaira; he mea hoatu ki a koutou mā Ihowā, hei mahi i ngā mahi o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ko koutou ia ko āu tama, kia mau ki tā koutou mahi tohunga ki ngā mea katoa o te āta, o roto atu anō hoki i te ārai, hei mahi mā koutou. He mea hoatu noa atu tā koutou mahi tohunga e hoatu nei e ahau; ā, ka whakamatea te tangata kē e whakatata mai ana.” ");
INSERT INTO mri2012_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","I kōrero anō a Ihowā ki a Ārona: “Nā, kua tukua atu nei e ahau ki a koe te tiaki o āku whakahere hapahapai, o ngā mea tapu katoa a ngā tama a Īharaira; he mea hoatu nāku ki a koutou ko āu tama, he whakaaro hoki ki te whakawahinga, he tikanga pūmau. ");
INSERT INTO mri2012_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ko ngā mea tēnei māu o ngā mea tino tapu e kore nei e tukua ki te ahi; ko ā rātou whakahere katoa, ko ā rātou whakahere totokore katoa, me ā rātou whakahere hara katoa, me ā rātou whakahere katoa mō te hē, e tāpaea ki ahau; ka tino tapu mā koutou ko āu tama. ");
INSERT INTO mri2012_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Hei te wāhi tino tapu kai ai, mā ngā tāne katoa e kai; he tapu tēnā māu. ");
INSERT INTO mri2012_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Māu anō tēnei: ko ngā whakahere hapahapai e hōmai ana e rātou me ngā whakahere poipoi katoa a ngā tama a Īharaira; kua hoatu aua mea e ahau ki a koe, ki a koutou ko āu tama, ko āu tamāhine, he tikanga pūmau; e kainga tēnā e ngā mea pokekore katoa o tōu whare. ");
INSERT INTO mri2012_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Ko ngā wāhi papai katoa o te hinu, me ngā wāhi papai katoa o te wāina, o te wīti hoki, ko ngā tūāpora o aua mea e hōmai ana ki a Ihowā, kua hoatu ēnā e ahau ki a koe. ");
INSERT INTO mri2012_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Māu ngā hua mataati o ngā mea katoa o te whenua, e kawea mai ana ki a Ihowā; me kai e ngā mea pokekore katoa o tōu whare. ");
INSERT INTO mri2012_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Māu ngā mea katoa i oti rawa i roto i a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ko ngā mea katoa e oroko puta mai ana i te kōpū o ngā kikokiko katoa, ko ngā mea hoki e whakaherea ana mā Ihowā, o te tangata, o te kararehe, māu ēnā. Otiia, me tino whakahoki atu e koe ki te utu ngā mātāmua a te tangata, me tango utu anō mō ngā mātāmua a te kararehe poke. ");
INSERT INTO mri2012_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ā, ko ngā mea e utua ana e whakahokia ana, ka kotahi marama o tōna whānautanga, me tango ōna utu; kia rite ki tāu e whakarite ai, kia rima hekere ngā moni; hei ngā hekere wāhi tapu, (e rua tekau nei ngā kera). ");
INSERT INTO mri2012_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Ko te mātāmua ia a te kau, me te mātāmua a te hipi, me te mātāmua a te koati, kaua e whakahokia atu e koe; he tapu ēnā. Me tāuhi e koe ō rātou toto ki te āta, me tahu anō ō rātou ngako hei whakahere ahi, hei kakara reka ki a Ihowā. ");
INSERT INTO mri2012_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ā, māu ō rātou kikokiko, ka pērā me te uma poipoi, me te hūhā matau, nāu hoki ēnā. ");
INSERT INTO mri2012_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ko ngā whakahere hapahapai katoa o roto o ngā mea tapu e tāpaea ana e ngā tama a Īharaira ki a Ihowā, kua hoatu e ahau ki a koutou ko āu tama, ko āu tamāhine; hei tikanga pūmau. Hei kawenata tote i te aroaro o Ihowā ake ake, ki a koutou tahi ko ōu uri.” ");
INSERT INTO mri2012_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ā, i kōrero a Ihowā ki a Ārona, “Kāhore he kāinga tupu mōu i tō rātou whenua, kāhore anō hoki he wāhi mōu i roto i a rātou; ko ahau te wāhi mōu, tōu kāinga tupu i roto i ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Kua hoatu nei hoki e ahau ki ngā tama a Rīwai ngā whakatekau katoa i roto i a Īharaira hei taonga tupu, hei utu mō tā rātou mahi e mahi ai rātou, mō te mahinga i te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kaua anō hoki ngā tama a Īharaira e whakatata ā muri ake nei ki te tapenākara o te whakaminenga, kei whai hara, kei mate. ");
INSERT INTO mri2012_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Mā ngā Rīwaiti ia e mahi ngā mahi o te tapenākara o te whakaminenga, me waha anō hoki e rātou tō rātou kino; hei tikanga pūmau ia mā ō koutou whakatupuranga, kia kāhore he kāinga tupu mō rātou i roto i ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ko ngā whakatekau hoki a ngā tama a Īharaira, e tāpaea nei hei whakahere hapahapai ki a Ihowā, kua hoatu e ahau hei wāhi tupu ki ngā Rīwaiti. Koia ahau i mea ai ki a rātou, e kore rātou e whai kāinga tupu i roto i ngā tama a Īharaira.” ");
INSERT INTO mri2012_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","I kōrero anō a Ihowā ki a Mohi, i mea, ");
INSERT INTO mri2012_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Kōrero anō ki ngā Rīwaiti, mea atu ki a rātou: ‘Ka tangohia e koutou ngā whakatekau a ngā tama a Īharaira e hoatu nei e ahau ki a koutou i roto i ā rātou mea hei wāhi tupu mō koutou, me tāpae he whakahere hapahapai ki a Ihowā i roto i taua mea, he wāhi whakatekau o aua whakatekau. ");
INSERT INTO mri2012_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ā, ka kīia tēnei whakahere hapahapai he mea nā koutou, he pērā me te wīti o te patunga wīti, me te pūrenatanga hoki o te poka wāina. ");
INSERT INTO mri2012_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Nā, me tāpae anō hoki e koutou he whakahere hapahapai ki a Ihowā i roto i ā koutou whakatekau katoa e tangohia ana e koutou i ngā tama a Īharaira; me hōmai te whakahere hapahapai a Ihowā i roto i taua mea ki te tohunga, ki a Ārona. ");
INSERT INTO mri2012_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Me tāpae ngā whakahere hapahapai katoa mā Ihowā i roto i ngā mea katoa e hōmai ana ki a koutou, i roto i ngā mea papai katoa o ēnā, arā te wāhi tapu o roto.’ ");
INSERT INTO mri2012_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Me kī atu ki a rātou: ‘Ka hapahapai koutou i te wāhi tino pai o taua mea, me kī tēnā he mea nā ngā Rīwaiti, he pērā me te hua o te patunga wīti, me te pūrenatanga hoki o te poka wāina. ");
INSERT INTO mri2012_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ā, me kai tēnā e koutou ko ō koutou whare ki ngā wāhi katoa; ko tō koutou utu hoki ia mō tā koutou mahi i te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ā, e kore e waha e koutou he hara i reira, ina hapahapainga tōna wāhi pai; kaua anō e whakapokea ngā mea tapu a ngā tama a Īharaira, kei mate koutou.’ ” ");
INSERT INTO mri2012_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","I kōrero anō a Ihowā ki a Mohi rāua ko Ārona, i mea: ");
INSERT INTO mri2012_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ko te tikanga tēnei o te ture i whakahaua e Ihowā, i mea ia: Kōrero ki ngā tama a Īharaira kia tīkina he kūao kau uha, he mea whero māu, hei te mea kāhore he nawe, kāhore he koha, ā, kāhore anō hoki i utaina ki te ioka. ");
INSERT INTO mri2012_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Me hoatu e koutou ki a Ereātara, tohunga, māna ia e kawe ki waho o te puni, me patu hoki e tētahi ki tōna aroaro. ");
INSERT INTO mri2012_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Nā, ka tango a Ereātara, tohunga, i tētahi wāhi o ōna toto ki tōna maihao, kia whitu ana tāuhiuhinga i ōna toto ki te roro tonu o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Nā, mā tētahi e tahu te kau i tāna tirohanga atu; ko tōna hiako, me ōna kiko, me ōna toto, me tahu tahi me tōna paru. ");
INSERT INTO mri2012_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Nā, ka mau te tohunga ki te rākau hīta, ki te hihopa, ki te mea ngangana, ā, ka makā e ia ki waenganui o te tahunga o te kau. ");
INSERT INTO mri2012_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Kātahi ka horoi te tohunga i ōna kākahu, ka horoi anō hoki i tōna kiri ki te wai, ā muri iho ka haere ki te puni, ka poke hoki te tohunga ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Me te kaitahu anō, me horoi ōna kākahu ki te wai, me horoi anō tōna kiri ki te wai, ka poke hoki ia ā ahiahi noa. ");
INSERT INTO mri2012_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Ā, me āmene ngā pungarehu o te kau e tētahi tangata pokekore, ā, ka waiho i waho o te puni, i te wāhi pokekore, ka tiaki ai mō te whakaminenga o ngā tama a Īharaira hei wai wehenga; hei horohoro tēnā mō te hara. ");
INSERT INTO mri2012_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Me horoi anō hoki ōna kākahu e te kaiāmene i ngā pungarehu o te kau, ka poke hoki ia ā ahiahi noa. Me waiho anō tēnā hei tikanga tūturu mā ngā tama a Īharaira, mā te manene hoki e noho manene ana i roto i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Ki te pā tētahi ki te tinana mate o tētahi tangata, ka poke ia, e whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Me pure ia e ia ki taua wai i te toru o ngā rā, ā, i te whitu o ngā rā ka kore ōna poke. Otiia ki te kore ia e pure i a ia i te toru o ngā rā, e kore ia e pokekore i te whitu o ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ki te pā tētahi ki te tinana mate o tētahi tangata kua mate, ā, kāhore e pure i a ia, e whakapokea ana e ia te tapenākara o Ihowā. Ka hātepea taua wairua i roto i a Īharaira; nō te mea kīhai i tāuhiuhia ki a ia te wai wehenga, ka poke anō ia; e mau ana anō ki a ia tōna poke. ");
INSERT INTO mri2012_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Ko te ture tēnei ina mate te tangata i roto i te tēneti. Ko ngā tāngata katoa e tomo ana ki te tēneti, me ngā tāngata katoa i roto i te tēneti, ka poke kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ko ngā oko katoa anō e puare kau ana, kāhore nei i herea te taupoki, ka poke. ");
INSERT INTO mri2012_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Ki te pā hoki tētahi ki te tangata i patua ki te hoari ki waenga pārae, ki te tūpāpaku rānei, ki te wheua tangata rānei, ki te urupā rānei, ka poke ia kia whitu ngā rā. ");
INSERT INTO mri2012_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Nā, mō te tangata poke, me tiki e rātou ētahi o ngā pungarehu o te kau i tahuna hei horohoronga mō ngā hara, ka riringi ai ki te wai ora, ki roto anō ki te oko. ");
INSERT INTO mri2012_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Nā, ka mau tētahi tangata pokekore ki te hihopa, ka tuku ki te wai, nā, ka tāuhiuhi i te tēneti me ngā oko katoa, i ngā tāngata anō hoki o reira, me te tangata i pā atu nei ki te wheua ki te tangata rānei i patua, ki te tūpāpaku rānei, ki te urupā rānei. ");
INSERT INTO mri2012_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Me tāuhiuhi anō hoki e te tangata pokekore te tangata poke i te toru o ngā rā, i te whitu hoki o ngā rā; ā, me pure ia e ia anō i te whitu o ngā rā ka horoi ai i ōna kākahu, ka horoi anō hoki i a ia ki te wai, ā, i te ahiahi ka kore te poke. ");
INSERT INTO mri2012_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Ā, ki te poke tētahi tangata, ā, kāhore e pure i a ia, ka hātepea atu taua wairua i roto i te huihui, mōna i whakapoke i te wāhi tapu o Ihowā. Kīhai te wai o te wehenga i tāuhiuhia ki a ia; he poke. ");
INSERT INTO mri2012_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ā, hei tikanga tūturu tēnei mā rātou. “Me horoi ōna kākahu e te kaitāuhiuhi o te wai wehenga; ka poke anō ā ahiahi noa te tangata e pā ana ki te wai wehenga. ");
INSERT INTO mri2012_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ka poke anō ngā mea katoa e pā ai te tangata poke; ka poke anō ā ahiahi noa te wairua e pā ana.” ");
INSERT INTO mri2012_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Nā, ka tae ngā tama a Īharaira, arā te whakaminenga katoa, ki te koraha o Hini i te marama tuatahi; ā, ka noho te iwi ki Karehe. Nā, ka mate a Miriama ki reira, ā, tanumia ana ki reira. ");
INSERT INTO mri2012_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ā, kāhore he wai mō te whakaminenga; ā, ka huihui ki te ngangare ki a Mohi rāua ko Ārona. ");
INSERT INTO mri2012_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Nā, ka ngangau te iwi ki a Mohi, ka kōrero, ka mea, “Auē, me i mate mātou i te matenga o ō mātou tuākana i te aroaro o Ihowā! ");
INSERT INTO mri2012_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","He aha hoki i kawea mai ai e kōrua te whakaminenga a Ihowā ki tēnei koraha, kia mate tahi mātou me ā mātou kararehe ki konei? ");
INSERT INTO mri2012_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","He aha hoki mātou i meinga ai e kōrua kia haere mai i Īhipa, kia kawea mai mātou ki tēnei wāhi kino? Ehara nei i te wāhi purapura, i te wāhi piki, wāina, pamekaranete; kāhore anō hoki he wai hei inu.” ");
INSERT INTO mri2012_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Nā, ka haere a Mohi rāua ko Ārona i te aroaro o te whakaminenga ki te whatitoka o te tapenākara o te whakaminenga, ā, ka kūpapa iho ō rāua mata. Nā, ko te putanga mai o te korōria o Ihowā ki a rāua. ");
INSERT INTO mri2012_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ā, ka kōrero a Ihowā ki a Mohi, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Maua atu te tokotoko, huihuia mai anō te whakaminenga e kōrua ko tōu tuakana, ko Ārona, ka kōrero ai kōrua ki te kāmaka i mua i ō rātou kanohi, kia tukua mai tōna wai; ā, ka whakaputaina mai e koe he wai mō rātou i roto i te kāmaka; ā, ka meinga e koe te whakaminenga me ā rātou kararehe kia inu.” ");
INSERT INTO mri2012_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Nā, ka maua e Mohi te tokotoko i te aroaro o Ihowā, pērā ana ia me tāna i whakahau ai. ");
INSERT INTO mri2012_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","I huihuia hoki te whakaminenga e Mohi rāua ko Ārona ki mua o te kāmaka, ā, ka mea ia ki a rātou, “Whakarongo mai, e te hunga tutū; me whakaputa mai rānei e maua he wai mō koutou i roto i tēnei kāmaka?” ");
INSERT INTO mri2012_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Nā, ka ara te ringa o Mohi, ā, e rua āna patunga i te kāmaka ki tāna tokotoko; ko te tino putanga mai o te wai, tōna nui, ā, inu ana te iwi me ā rātou kararehe. ");
INSERT INTO mri2012_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nā, ka mea a Ihowā ki a Mohi rāua ko Ārona, “Kāhore nei kōrua i whakapono ki ahau, kia whakatapu i ahau i te tirohanga a ngā tama a Īharaira, mō reira e kore kōrua e kawe i tēnei whakaminenga ki te whenua e hoatu nei e ahau ki a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ko te wai tēnā o Meripa; i ngangau hoki ngā tama a Īharaira ki a Ihowā ki reira, ā, meinga ana rātou hei whakatapu mōna. ");
INSERT INTO mri2012_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Nā, ka unga tāngata a Mohi i Karehe ki te kīngi o Ēroma: “Ko te kupu tēnei a tōu teina, a Īharaira: E mōhio ana koe ki ngā hē katoa i pono mai ki a mātou: ");
INSERT INTO mri2012_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ki te hekenga o ō mātou mātua ki Īhipa, ki tō mātou nohoanga hoki i Īhipa, ā, maha noa ngā rā; ā, ka tūkino ngā Īhipiana i a mātou ko ō mātou mātua; ");
INSERT INTO mri2012_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ā, i tā mātou karangatanga atu ki a Ihowā, nā, ka rongo ia ki tō mātou reo, ā, ungā ana e ia he anahera hei whakaputa mai i a mātou i Īhipa. “Nā, kei Karehe tēnei mātou, kei te pā whakamutunga o tōu rohe. ");
INSERT INTO mri2012_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tēnā, tukua atu mātou mā tōu whenua; e kore mātou e haere nā ngā māra, nā ngā māra wāina rānei, e kore anō mātou e inu i te wai o ngā puna. Ka haere mātou i te huanui o te kīngi, e kore mātou, e peka ki matau, ki mauī, kia pahemo rā anō i a mātou ōu rohe.” ");
INSERT INTO mri2012_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Nā, ka mea a Ēroma ki a ia, “E kore koe e tika nā tōku wāhi, kei haere ahau me te hoari ki te tū i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Nā, ka mea ngā tama a Īharaira ki a ia, “Ka haere mātou nā te huanui; ā, ki te inu ahau me āku kāhui i tōu wai, me utu e ahau. Heoi rawa tāku e mea ai, ko te haere kau o ōku waewae nā konā.” ");
INSERT INTO mri2012_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Nā, ka mea ia, “E kore koe e haere rā konei.” Ā, ka puta a Ēroma me te ope nui, me te ringa kaha, ki te tū i a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Heoi, kīhai a Ēroma i pai ki te tuku i a Īharaira kia haere nā tōna rohe; nā, peka kē ana a Īharaira i a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Nā, ka tūria atu e rātou i Karehe; ā, ka tae ngā tama a Īharaira, arā te whakaminenga katoa ki Maunga Horo. ");
INSERT INTO mri2012_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Nā, ka kōrero a Ihowā ki a Mohi rāua ko Ārona i Maunga Horo, i te rohe o te whenua o Ēroma, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Ka kohia atu a Ārona ki tōna iwi; e kore hoki ia e tae ki te whenua ka hoatu nei e ahau ki ngā tama a Īharaira, mō kōrua i whakatoi ki tāku kupu i te wai o Meripa. ");
INSERT INTO mri2012_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Tangohia a Ārona rāua ko Ereātara, ko tāna tama, kawea hoki rāua ki runga ki Maunga Horo. ");
INSERT INTO mri2012_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Unuhia hoki ngā kākahu o Ārona, ka whakakākahu ai ki tāna tama, ki a Ereātara; ā, ka kohia atu a Ārona ki tōna iwi, ka mate hoki ki reira.” ");
INSERT INTO mri2012_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Nā, ka pērā a Mohi me tā Ihowā i whakahau ai, ā, haere ana rātou ki runga ki Maunga Horo i te tirohanga a te whakaminenga katoa. ");
INSERT INTO mri2012_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Nā, ka unuhia e Mohi ngā kākahu o Ārona, ā, whakakākahuria ana e ia ki tāna tama, ki a Ereātara; ā, ka mate a Ārona ki reira, ki te tihi o te maunga. Ā, ka heke iho a Mohi rāua ko Ereātara i runga i te maunga. ");
INSERT INTO mri2012_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ā, nō te kitenga o te whakaminenga katoa kua mate a Ārona, e toru tekau ngā rā i tangihia ai a Ārona e rātou, e te whare katoa o Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ā, ka rongo a Kīngi Arara, te Kanaani, i noho nei ki te taha ki te tonga, e haere ana a Īharaira nā te ara o Atarimi; nā, ka tatau ia ki a Īharaira, ā, whakaraua ana ētahi o rātou e ia. ");
INSERT INTO mri2012_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Nā, ka puta te kī taurangi a Īharaira ki a Ihowā, ka mea, “Ki te tukua mai e koe tēnei iwi ki tōku ringa ka tino whakangaromia e ahau ō rātou pā.” ");
INSERT INTO mri2012_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ā, i whakarongo a Ihowā ki te reo o Īharaira, ā, hōmai ana e ia ngā Kanaani; ā, tino whakangaromia ana rātou me ō rātou pā e rātou; ā, huaina iho te ingoa o taua wāhi ko Horema. ");
INSERT INTO mri2012_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Nā, ka tūria atu e rātou i Maunga Horo nā te ara o te Moana Whero ki te taiāwhio i te whenua o Ēroma; ā pōuri noa iho te wairua o te iwi i te ara. ");
INSERT INTO mri2012_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ā, ka whakahē te iwi i te Atua, i a Mohi hoki, “He aha i kawea mai ai mātou ki runga nei i Īhipa kia mate ki te koraha? Kāhore nei hoki he taro, kāhore he wai; ā, e whakarihariha ana tō mātou wairua ki tēnei taro māmā.” ");
INSERT INTO mri2012_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Nā, ka tukua mai e Ihowā he nākahi tū ā-ahi ki te iwi, ā, ka ngaua te iwi; ā, he tokomaha o Īharaira i mate. ");
INSERT INTO mri2012_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Nā, ka haere te iwi ki a Mohi, ka mea, “Kua hara mātou i a mātou i whakahē i a Ihowā, i a koe hoki; īnoi ki a Ihowā kia tangohia atu e ia ngā nākahi i a mātou.” Nā, ka īnoi a Mohi mō te iwi. ");
INSERT INTO mri2012_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Nā, ka mea a Ihowā ki a Mohi, “Hangā tētahi nākahi tū ā-ahi māu, ka whakanoho ki te pou; nā, mehemea kua ngaua tētahi, ā, ka titiro atu ia ki reira, ka ora.” ");
INSERT INTO mri2012_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Nā, hangā ana e Mohi te nākahi ki te parāhi, ā, whakanohoia ana ki te pou; nā, mehemea kua ngaua tētahi e te nākahi, ka titiro ia ki te nākahi parāhi, kua ora. ");
INSERT INTO mri2012_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Nā, ka tūria atu e ngā tama a Īharaira, ā, noho ana i Opoto. ");
INSERT INTO mri2012_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ā, ka tūria atu i Opoto, ā, noho ana i Iteaparimi, i te koraha i te ritenga atu o Moapa, whaka te rāwhiti. ");
INSERT INTO mri2012_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ā, ka haere atu rātou i reira, ā, noho ana i te raorao i Terete. ");
INSERT INTO mri2012_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Nā, ka tūria atu i reira, ā, noho ana i tērā taha o Aranona, o tērā i te koraha e puta mai ana i ngā wāhi o ngā Amori; ko Aranona hoki te rohe ki a Moapa, kei waenganui o Moapa, o ngā Amori. ");
INSERT INTO mri2012_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Koia i kōrerotia ai i te Pukapuka o ngā Whawhai a Ihowā, “Ko tāna i mea ai ki te Moana Whero, ki ngā awa hoki o Aranona, ");
INSERT INTO mri2012_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ki ngā hurihanga wai anō hoki, e anga ana ki te nohoanga i Ara, e piri nei ki te rohe o Moapa.” ");
INSERT INTO mri2012_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ā, i haere atu rātou i reira ki Pēre; ko te puna ia i kōrero ai a Ihowā ki a Mohi, “Huihuia te iwi, ā, māku e hoatu he wai ki a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Nā, ka waiatatia tēnei waiata e Īharaira: “Pupuke ake, e te puna! Waiatatia! ");
INSERT INTO mri2012_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Te puna i keria e ngā rangatira, i keria e ngā ariki o te iwi, ki te hēpeta, ā, ki ā rātou tokotoko.” Nā, ka tūria atu e rātou i te koraha ki Matana, ");
INSERT INTO mri2012_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","i Matana hoki ki Nahariere; ā, i Nahariere ki Pamoto, ");
INSERT INTO mri2012_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ā, i Pamoto ki te raorao i te whenua o Moapa, ki te tihi o Pihika, e titiro iho ana ki te koraha. ");
INSERT INTO mri2012_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Nā, ka unga tāngata a Īharaira ki a Hihona kīngi o ngā Amori, hei mea: ");
INSERT INTO mri2012_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Tukua atu ahau nā tōu whenua; e kore mātou e peka ki ngā māra, ki ngā māra wāina rānei; e kore mātou e inu i te wai o ngā puna. Ka haere mātou nā te huanui o te kīngi, kia pahemo rā anō ōu rohe i a mātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Otiia kīhai a Hihona i tuku i a Īharaira kia tika nā tōna wāhi; nā, huihuia ana e Hihona tōna iwi katoa, ā, puta mai ana ki te tū i a Īharaira ki te koraha, nā, ka haere ia ki Iahata; ā, ka tatau ia i a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ā, patua iho ia e Īharaira ki te mata o te hoari, tangohia ana e rātou tōna whenua, o Aranona atu ā tae noa ki Iapoko, ki ngā tama rā anō a Āmona; he rohe hoki e kore e taea tō ngā tama a Āmona. ");
INSERT INTO mri2012_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ā, riro ana i a Īharaira ēnei pā katoa; ā, nohoia ana e Īharaira ngā pā katoa o ngā Amori, a Hehepona, me ōna pā ririki. ");
INSERT INTO mri2012_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","He pā hoki a Hehepona nō Hihona kīngi o ngā Amori; i whawhai hoki ia ki tō mua kīngi o Moapa, ā, tangohia ana ia tōna whenua katoa i tōna ringa ā tae noa ki Aranona. ");
INSERT INTO mri2012_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Koia te hunga kōrero whakatauki ka mea ai, “Haere mai ki Hehepona, kia hangā; kia whakaūngia te pā o Hihona. ");
INSERT INTO mri2012_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Kua puta atu hoki he ahi i Hehepona, he mura i te pā o Hihona. Ā, pau ake a Ara o Moapa, me ngā ariki o ngā wāhi tiketike o Aranona. ");
INSERT INTO mri2012_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Auē te mate mōu, e Moapa! Ka ngaro koe, e te iwi o Kemoho! Kua hoatu e ia āna tama i rere mōrehu, me āna tamāhine, hei pononga mā Hihona, mā te kīngi o ngā Amori. ");
INSERT INTO mri2012_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“I kōpere atu mātou ki a rātou kua ngaro a Hehepona, tae noa ki Ripono, kua hunā e mātou tae noa ki Nopa e totoro atu nei ki Merepa.” ");
INSERT INTO mri2012_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Nā, ka noho a Īharaira ki te whenua o ngā Amori. ");
INSERT INTO mri2012_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ā, ka tono tāngata a Mohi ki te tūtei i Iatere, ā, ka riro i a rātou ngā pā o reira, i panā hoki ngā Amori e noho ana i reira. ");
INSERT INTO mri2012_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Nā, ka tahuri rātou, ā, ka haere ki runga nā te ara o Pahana; nā, ko te putanga mai o Oka kīngi o Pahana, ki te whakatūtaki i a rātou, a ia, me tōna iwi katoa ki te whawhai ki Eterei. ");
INSERT INTO mri2012_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ā, ka mea a Ihowā ki a Mohi, “Kei wehi i a ia; kua hoatu hoki ia e ahau ki tōu ringa, me tōna iwi katoa, me tōna whenua; ā, ka rite tāu e mea ai ki a ia ki tāu i mea ai ki a Hihona kīngi o ngā Amori i noho rā i Hehepona.” ");
INSERT INTO mri2012_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Nā, patua iho ia e rātou, me āna tama, me tōna iwi katoa, ā, kore noa e toe tētahi mōrehu ōna; ā, tangohia ana e rātou tōna whenua. ");
INSERT INTO mri2012_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Nā, ka tūria atu e ngā tama a Īharaira, ā, ka noho ki ngā mānia o Moapa, ki tēnei taha o Horano ki te ritenga atu o Heriko. ");
INSERT INTO mri2012_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ā, i kite a Pāraka tama a Tiporo i ngā mea katoa i mea ai a Īharaira ki ngā Amori. ");
INSERT INTO mri2012_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Nā, nui atu te wehi o Moapa ki te iwi, nō te mea he tokomaha; ā, tuatea noa iho a Moapa i ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Nā, ka mea a Moapa ki ngā kaumātua o Miriana, “Ākuanei tēnei hui horomiti ai i ngā tāngata katoa i ngā taha katoa o tātou, pērā ai me te kau e horomiti nei i te tarutaru o te māra.” Ā, ko Pāraka tama a Tiporo te kīngi o Moapa i taua wā. ");
INSERT INTO mri2012_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Nā, ka tukua e ia he karere ki a Paraama tama a Peoro ki Petoro, i te taha o te awa, ki te whenua o ngā tama o tōna iwi, ki te tiki i a ia, hei mea: “He iwi tēnei kua puta mai i Īhipa, nā, kapi ana i a rātou te mata o te whenua; e noho nei anō rātou i tōku aroaro. ");
INSERT INTO mri2012_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Nā, tēnā, haere mai hei kaikanga māku i te iwi nei; he kaha kē hoki rātou i ahau; tērā pea ka toa ahau, ka patua rātou e mātou, ā, ka peia atu rātou i te whenua; e mōhio ana hoki ahau ko tāu e manaaki ai ka manaakitia, ko tāu hoki e kanga ai ka kangā.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ā, ka haere ngā kaumātua o Moapa rātou ko ngā kaumātua o Miriana me ngā utu mākutu i ō rātou ringa; ā, ka tae ki a Paraama, ā, kōrerotia ana e rātou ngā kupu a Pāraka. ");
INSERT INTO mri2012_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Nā, ka mea ia ki a rātou, “E noho ki konei i tēnei pō, ā, māku e whakahoki he kōrero ki a koutou, ko tā Ihowā hoki e kōrero ai ki ahau.” Nā, ka noho ngā rangatira o Moapa ki a Paraama. ");
INSERT INTO mri2012_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nā, ka haere te Atua ki a Paraama, ka mea, “Ko wai ēnā tāngata i a koe nā?” ");
INSERT INTO mri2012_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ā, ka mea a Paraama ki te Atua, “Kua unga tāngata mai a Pāraka tama a Tiporo, kīngi o Moapa, ki ahau, hei kī mai: ");
INSERT INTO mri2012_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘He iwi tēnei kua puta mai i Īhipa, ā, kapi ana i a rātou te mata o te whenua; tēnā, haere mai hei kaikanga māku i a rātou; tērā pea e taea e ahau te whawhai ki a rātou, te pei hoki i a rātou.’ ” ");
INSERT INTO mri2012_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nā, ka mea te Atua ki a Paraama, “Kaua e haere i a rātou; kaua e kangā tēnā iwi; kua oti hoki rātou te manaaki.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Nā, ka maranga a Paraama i te ata, ka mea ki ngā rangatira a Pāraka, “Haere ki tō koutou whenua; e kore hoki a Ihowā e pai ki te tuku i ahau kia haere i a koutou.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Nā, ka whakatika ngā rangatira o Moapa, ka haere ki a Pāraka, ka mea, “Kīhai a Paraama i pai ki te haere tahi mai i a mātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Nā, ka tonoa e Pāraka ētahi atu rangatira, he tokomaha atu, he nunui atu i ērā. ");
INSERT INTO mri2012_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ā, ka tae rātou ki a Paraama, ka mea ki a ia: “Ko te kupu tēnei a Pāraka tama a Tiporo: ‘Kei puritia atu koe e tētahi mea, haere mai ki ahau. ");
INSERT INTO mri2012_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ka whakanuia rawatia hoki koe e ahau, ka meatia anō e ahau ngā mea katoa e mea mai ai koe ki ahau; haere mai rā hei kaikanga māku i tēnei iwi.’ ” ");
INSERT INTO mri2012_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Nā, ka utu Paraama, ka mea ki ngā tāngata a Pāraka, “Ahakoa i kī tōna whare i te hiriwa, i te kōura, e hōmai e Pāraka ki ahau, e kore e āhei i ahau te whakawhiti ki kō atu i te kupu a Ihowā, a tōku Atua, te mea i te mea iti iho, i te mea nui ake rānei. ");
INSERT INTO mri2012_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nā, e noho ki konei i tēnei pō, kia mōhio ahau ki tā Ihowā e mea mai ai anō ki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ā, i puta mai te Atua ki a Paraama i te pō, ā, ka mea ki a ia, “Ki te haere mai aua tāngata ki te karanga i a koe, whakatika, haere i a rātou; ko te kupu ia e kōrero ai ahau ki a koe, ko tēnā tāu e mea ai.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Nā, ka maranga a Paraama i te ata, ā, whakanohoia ana e ia tana kāihe, ā, haere ana i ngā rangatira o Moapa. ");
INSERT INTO mri2012_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nā, ka mura te riri o te Atua mōna i haere, ā, ka tū te anahera a Ihowā ki te ara hei hoariri mōna. Ā, i runga ia i tōna kāihe e noho ana, ko āna tāngata tokorua hoki ōna hoa. ");
INSERT INTO mri2012_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ā, ka kite te kāihe i te anahera a Ihowā e tū ana i te ara, me tāna hoari i tōna ringa, unu rawa, ka peka atu te kāihe i te ara, ā, ka haere ki te pārae. Nā, ka whiua e Paraama te kāihe kia anga ki te ara. ");
INSERT INTO mri2012_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Kātahi ka tū te anahera a Ihowā ki tētahi huarahi whāwhārua o ngā māra wāina, he taiepa kei tēnei taha, he taiepa hoki kei tērā taha. ");
INSERT INTO mri2012_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ā, nō te kitenga o te kāihe i te anahera a Ihowā, ka whakapiri ki te taiepa, ā, karapitia ana te waewae o Paraama ki te taiepa; nō, ka whiua anō e ia. ");
INSERT INTO mri2012_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Nā, ka neke anō te anahera a Ihowā, ā, ka tū ki te wāhi kūiti, kāhore nei he ara hei pekanga ki matau, ki mauī. ");
INSERT INTO mri2012_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ā, nō te kitenga o te kāihe i te anahera a Ihowā, ka takoto ki raro i a Paraama; ā, ka mura te riri o Paraama, ka patua e ia te kāihe ki tāna rākau. ");
INSERT INTO mri2012_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Nā, ka whakahamumutia e Ihowā te waha o te kāihe, ā, ka kōrero ki a Paraama, “I aha ahau ki a koe, i toru ai ēnei patunga āu i ahau?” ");
INSERT INTO mri2012_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ā, ka mea a Paraama ki te kāihe, “Mō tāu māminga rā ki ahau. Me he hoari i tōku ringa, inā, kua whakamatea koe e ahau ināianei.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Nā, ka mea ake te kāihe ki a Paraama, “Ehara ianei ahau i tāu kāihe, i ekengia nei e koe o tōku rironga mai rā anō i a koe, ā tae noa mai ki tēnei rā? He pēnei rānei tāku hanga ki a koe i mua?” Ā, ka mea ia, “Kāhore.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Kātahi ka whakatirohia e Ihowā ngā kanohi o Paraama, ā, ka kite ia i te anahera a Ihowā e tū ana i te ara, me tāna hoari i tōna ringa, unu rawa; nā, ka tuohu ia, ka piko iho tōna mata. ");
INSERT INTO mri2012_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Nā, ka mea te anahera a Ihowā ki a ia, “Nā te aha ēnei patunga e toru āu i tāu kāihe? Nanā, i puta atu ahau hei hoariri mōu, nō te mea e peau kē ana tōu ara i tōku aroaro. ");
INSERT INTO mri2012_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ā, i kite te kāihe i ahau, ā, e toru ōna pekanga ki tahaki i tōku aroaro. Me i kāhore ia te peka atu ki tahaki i tōku aroaro, inā, kua patua tēnei koe e ahau, ā, ko ia kua whakaorangia.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Nā, ka mea a Paraama ki te anahera a Ihowā, “Kua hara ahau; nōku kīhai i mōhio ko koe te tū mai ana i te ara ki te whakatūtaki i ahau; nā, ki te hē tēnei ki tāu titiro, me hoki ahau.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Nā, ka mea te anahera a Ihowā ki a Paraama, “Haere i aua tāngata; ko te kupu ia e kōrero ai ahau ki a koe, ko tēnā anake tāu e kōrero ai.” Nā, ka haere a Paraama i ngā rangatira a Pāraka. ");
INSERT INTO mri2012_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ā, ka rongo a Pāraka e tae mai ana a Paraama, ka haere ia ki te whakatau i a ia ki tētahi pā o Moapa i te rohe o Aranona, i te rohe whakamutunga. ");
INSERT INTO mri2012_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ā, ka mea a Pāraka ki a Paraama, “Kāhore ianei ahau i āta unga ki a koe, ki te karanga i a koe? He aha koe tē haere mai ai ki ahau? He pono rānei e kore e āhei i ahau te whakanui i a koe?” ");
INSERT INTO mri2012_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Nā, ka mea a Paraama ki a Pāraka, “Nā, kua tae mai nei ahau ki a koe. E taea rānei e ahau te kōrero tētahi mea, ahakoa iti? Ko te kupu e hōmai e te Atua ki tōku māngai, ko tēnā tāku e kōrero ai.” ");
INSERT INTO mri2012_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Nā, ka haere a Paraama i a Pāraka, ā, ka tae rāua ki Kiriata Hutoto. ");
INSERT INTO mri2012_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Nā, ka patua he kau, he hipi, e Pāraka, ā, ka unga tāngata ki a Paraama rātou ko ōna hoa, ko ngā rangatira. ");
INSERT INTO mri2012_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ā, i te ata ka mau a Pāraka ki a Paraama, ā, kawea ana e ia ki runga ki ngā wāhi teitei o Paara, ā, ka kite atu ia i reira i te hiku o te iwi. ");
INSERT INTO mri2012_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Nā, ka mea a Paraama ki a Pāraka, “Hangā ētahi āta māku kia whitu, kia rite mai hoki māku he pūru kia whitu, he hipi toa hoki kia whitu.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Nā, rite tonu tā Pāraka i mea ai ki ngā mea i kōrerotia e Paraama; ā, whakaekea ana e Pāraka rāua ko Paraama he pūru, he hipi, ki tētahi āta, ki tētahi āta. ");
INSERT INTO mri2012_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Nā, ka mea a Paraama ki a Pāraka, “E tū ki te taha o tāu tahunga tinana, ā, ka haere ahau; tērā pea a Ihowā e tūpono mai ki ahau. Ā, me kōrero atu e ahau ki a koe te kupu e whakakitea mai e ia ki ahau.” Nā, ka haere ia ki tētahi puke hamore. ");
INSERT INTO mri2012_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nā, ka tūpono a Ihowā ki a Paraama; ā, ka mea ia ki a ia, “Kua oti i ahau ngā āta e whitu, kua whakaekea anō hoki he pūru, he hipi, ki tēnei āta, ki tēnei āta.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Nā, ka hōmai e Ihowā he kupu ki te waha o Paraama, ka mea, “Hoki atu ki a Pāraka, ā, kia pēnei tāu kī atu.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ā, ka hoki atu ia ki a ia, nā, i te taha ia o tāna tahunga tinana e tū ana, rātou ko ngā rangatira katoa o Moapa. ");
INSERT INTO mri2012_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Nā, ka ara tāna kī pepeha, ka mea: “Nā, Pāraka kīngi o Moapa ahau i ārahi mai i Arame, i ngā maunga o te rāwhiti, i mea: ‘Haere mai hei kaikanga māku mō Hākopa; haere mai hoki hei whakatara ki a Īharaira.’ ");
INSERT INTO mri2012_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Me aha e kanga ai ahau i tā te Atua i kore ai e kanga? Me aha hoki e whakatara ai ahau ki tā Ihowā kīhai i whakatara? ");
INSERT INTO mri2012_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Tēnei hoki ahau kei te tihi o ngā kāmaka e titiro atu ana ki a ia, e kite atu ana i a ia i runga i ngā pukepuke. Nanā, he iwi noho ko ia anake, e kore anō hoki e tāua i roto i ngā tauiwi. ");
INSERT INTO mri2012_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Mā wai e tatau te puehu o Hākopa, e titiro rānei te maha o te whakawhā o Īharaira? Hei te mate o te hunga tika he matenga mōku, kia rite hoki tōku whakamutunga ki tōna!” ");
INSERT INTO mri2012_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Nā, ka mea a Pāraka, ki a Paraama, “He aha tāu e mea nei ki ahau? I tīkina atu koe e ahau hei kanga i ōku hoariri, nā, kua manaakitia rawatia rātou e koe.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Nā, ka whakautua e ia, ka mea, “Kaua rānei ahau e mahara ki te whakapuaki i te kupu e hōmai e Ihowā ki tōku waha?” ");
INSERT INTO mri2012_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Nā, ka mea a Pāraka ki a ia, “Tēnā, haere mai tāua ki tētahi wāhi kē atu, e kite ai koe i a rātou. Ko tō rātou pito tāu e kite ai; e kore hoki koe e kite i a rātou katoa; ā, hei reira puaki ai i a koe tāku kanga mō rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Nā, ka kawea ia e ia ki te māra o Topimi, ki te tihi o Pihika, ā, hangā ana e ia e whitu ngā āta, whakaekea atu ana hoki e ia he pūru, he hipi, ki tēnei āta, ki tēnei āta. ");
INSERT INTO mri2012_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Nā, ka mea ia ki a Pāraka, “E tū ki konei ki te taha o tāu tahunga tinana, ka whakatau ahau ki kō, ki a Ihowā.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Nā, ka tūpono a Ihowā ki a Paraama, ka hōmai e ia he kupu ki tōna waha, ka mea, “Hoki atu ki a Pāraka, kia pēnei hoki tāu kī atu.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ā, ka haere atu ia ki a ia, nā, e tū ana ia i te taha o tāna tahunga tinana, rātou ko ngā rangatira o Moapa. Ā, ka mea a Pāraka ki a ia, “I pēhea mai te kupu a Ihowā?” ");
INSERT INTO mri2012_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Nā, ka ara tāna kī pepeha, ka mea: “Whakatika, e Pāraka, whakarongo mai; kia whai taringa mai ki ahau, e te tama a Tiporo. ");
INSERT INTO mri2012_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ehara te Atua i te tangata e teka ai; i te tama rānei a te tangata e puta kē ai ōna whakaaro. Tērā rānei ia e kōrero, ā, kore ake e mahi? E puaki rānei tāna kupu, ā, kāhore e mana? ");
INSERT INTO mri2012_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nanā, kua riro mai i ahau te kupu manaaki; kua oti hoki i a ia te kupu manaaki; ā, e kore e taea e ahau te whakaputa kē. ");
INSERT INTO mri2012_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Kāhore i tirohia e ia he kino i a Hākopa, kāhore anō hoki i kitea he tutū i a Īharaira. Kei a ia a Ihowā, tōna Atua, kei roto hoki i a rātou te hāmama a te kīngi. ");
INSERT INTO mri2012_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nā, Ihowā rātou i whakaputa mai i Īhipa; kei tō te unikanga tōna kaha. ");
INSERT INTO mri2012_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","He pono kāhore he mākutu mō Hākopa, kāhore anō hoki he whaiwhaiā mō Īharaira. Hei tēnei wā anō ka kōrerotia a Hākopa, āe rā, a Īharaira, ‘Anō te mahi a te Atua!’ ");
INSERT INTO mri2012_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Nanā, ka whakatika te iwi ānō he raiona kātua, ka ara ake anō hoki ānō he raiona; e kore e takoto, kia kainga rā anō te tūpāpaku, kia inumia hoki ngā toto o te parekura.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Nā, ka mea a Pāraka ki a Paraama, “Kaua rawa e kanga i a rātou, kaua rawa rānei e manaaki i a rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Nā, ka whakautua e Paraama, ka mea ki a Pāraka, “Kāhore ianei ahau i kōrero ki a koe, i mea, ‘Ko ngā mea katoa e kōrero mai ai a Ihowā, ko tēnā tāku e mea ai’?” ");
INSERT INTO mri2012_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Nā, ka mea a Pāraka ki a Paraama, “Tēnā, me kawe koe e ahau ki tētahi atu wāhi; tērā pea e pai te Atua kia whakapuakina e koe i reira tāku kanga mō rātou.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Kātahi ka kawea a Paraama e Pāraka ki te tihi o Peoro, e titiro iho ana ki te koraha. ");
INSERT INTO mri2012_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ā, ka mea a Paraama ki a Pāraka, “Hangā he āta māku ki konei kia whitu, kia rite hoki māku ki konei he pūru kia whitu, he hipi toa kia whitu.” ");
INSERT INTO mri2012_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ā, rite tonu tā Pāraka i mea ai ki ngā mea i kōrerotia e Paraama, ā, whakaekea ana e ia he pūru, he hipi, ki runga ki tēnei āta, ki tēnei āta. ");
INSERT INTO mri2012_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ā, nō te kitenga o Paraama ko tā Ihowā i pai ai he manaaki i a Īharaira, kīhai ia i haere me mua rā ki te whai i te mea mākutu; engari i anga tōna mata ki te koraha. ");
INSERT INTO mri2012_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Nā, ka maranga ngā kanohi o Paraama, ā, ka kite i a Īharaira e noho ana i ō rātou iwi. Nā, ko te putanga mai o te Wairua o te Atua ki a ia. ");
INSERT INTO mri2012_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Nā, ka ara tāna kī pepeha, ka mea: “He kī tēnei nā Paraama, tama a Peoro, he kī hoki nā te tangata i kopi rā tōna kanohi, ");
INSERT INTO mri2012_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","he kī nā te tangata e rongo ana i ngā kupu a te Atua, e kite ana i te whakakitenga a te Kaha Rawa, e taka iho ana, me te titiro anō ōna kanohi. ");
INSERT INTO mri2012_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Anō te pai o ōu tēneti, e Hākopa, o ōu nohoanga, e Īharaira! ");
INSERT INTO mri2012_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Ānō ko ngā awaawa e takoto atu ana, rite tahi ānō ki ngā kāri i te taha o te awa, ki ngā aroe i whakatōkia e Ihowā, ki ngā hīta i te taha o ngā wai. ");
INSERT INTO mri2012_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ka maringi iho he wai i āna pere, ā, hei roto āna purapura i ngā wai maha. “Ka nui ake hoki tōna kīngi i a Akaka, ā, ka kake tōna kīngitanga. ");
INSERT INTO mri2012_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Nā te Atua ia i whakaputa mai i Īhipa; ko tōna kaha, rite pū ki tō te unikanga; ka pau ngā iwi, ōna hoariri, i a ia, ka whatiwhatiia e ia ō rātou wheua, ka werohia hoki rātou ki āna pere. ");
INSERT INTO mri2012_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","I tāpapa ia, i takoto, ānō he raiona, ānō he raiona kātua; mā wai ia e whakaoho? “Ka manaakitia te tangata e manaaki ana i a koe, ka kangā hoki te tangata e kanga ana i a koe.” ");
INSERT INTO mri2012_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Nā, ka mura te riri o Pāraka ki a Paraama, ka papaki ōna ringa. Nā, ka mea a Pāraka ki a Paraama, “He kanga i ōku hoariri i karanga ai ahau i a koe, nā, ka toru nei āu manaakitanga i a rātou. ");
INSERT INTO mri2012_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Nā, rere atu āianei ki tōu wāhi; i mea ahau kia whakanuia rawatia koe; heoi, kua puritia nei koe e Ihowā kei whai korōria.” ");
INSERT INTO mri2012_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Nā, ka mea atu a Paraama ki a Pāraka, “Kāhore ianei ahau i kōrero, i mea ki āu karere i ungā ake rā e koe ki ahau, ");
INSERT INTO mri2012_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Ahakoa i kī tōna whare i te hiriwa, i te kōura, e hōmai e Pāraka ki ahau, e kore e āhei i ahau te whakawhiti kē i te kupu a Ihowā, te mea i te pai, i te kino rānei, i tā tōku ngākau ake; ko tā Ihowā e kōrero ai, ko tēnā tāku e kōrero ai?’ ");
INSERT INTO mri2012_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Nā, ka haere tēnei ahau ki tōku iwi; haere mai, māku e whakaatu ki a koe tā tēnei iwi e mea ai ki tōu iwi i ngā rā whakamutunga.” ");
INSERT INTO mri2012_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Nā, ka ara tāna kī pepeha, ka mea: “He kī tēnei nā Paraama, nā te tama a Peoro, he kī hoki nā te tangata i kopi rā tōna kanohi, ");
INSERT INTO mri2012_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","he kī nā te tangata, e rongo ana i ngā kupu a te Atua, e mōhio ana ki ngā mea a te Runga Rawa, e kite nei i te whakakitenga mai a te Kaha Rawa, e taka iho ana, me te titiro anō ōna kanohi. ");
INSERT INTO mri2012_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“E kite anō ahau i a ia, otiia kāhore āianei; e titiro atu ahau ki a ia, otiia e kore e tata. Tērā e puta he whetū i roto i a Hākopa, ka ara ake anō hoki he Hēpeta i roto i a Īharaira, ā, ka patua e ia ngā pito o Moapa, ka hunā anō hoki e ia ngā tama katoa a Hete. ");
INSERT INTO mri2012_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ā, ka riro a Ēroma, ka riro anō a Heira, ko ōna hoariri nei ērā; ā, ka māia te mahi a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ā, ka whai rangatiratanga tētahi e puta mai i roto i a Hākopa, ā, ka hunā e ia ngā mōrehu o te pā.” ");
INSERT INTO mri2012_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Nā, ka titiro ia ki a Amareke, ā, ka ara tāna kī pepeha, ka mea: “Ko Amareke te tīmatanga o ngā iwi; ko tōna whakamutunga ia he whakangaromanga.” ");
INSERT INTO mri2012_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Nā, ka titiro ia ki te Keni, ā, ka ara tāna kī pepeha, ka mea: “He kaha tōu nohoanga, kua hangā anō hoki tōu ōhanga ki te kāmaka. ");
INSERT INTO mri2012_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","He ahakoa rā ka pau te Keni; ā, whakaraua noatia koe e Ahiria.” ");
INSERT INTO mri2012_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Nā, ka ara anō tāna kī pepeha, ka mea: “Auē, ko wai e ora, ina meatia tēnei e te Atua? ");
INSERT INTO mri2012_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ā, ka ū mai he kaipuke i te taha o Kitimi, ā, ka tūkinotia e rātou a Ahiria, ka tūkinotia anō a Ēpere, ko ia anō hoki ka whakangaromia.” ");
INSERT INTO mri2012_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Kātahi ka whakatika a Paraama, ā, haere ana, hoki ana ki tōna wāhi; me Pāraka anō hoki i haere i tōna ara. ");
INSERT INTO mri2012_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Nā, ka noho a Īharaira ki Hitimi, ā, ka anga te iwi ka moepuku ki ngā tamāhine a Moapa. ");
INSERT INTO mri2012_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Nā rātou hoki i karanga te iwi ki ngā patunga tapu mā ō rātou atua; nā, kai ana te iwi, ā, koropiko ana ki ō rātou atua. ");
INSERT INTO mri2012_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Nā, ka whakaūkia a Īharaira ki a Paara-Peoro, ā, ka mura te riri o Ihowā ki a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Nā, ka mea a Ihowā ki a Mohi, “Tangohia ngā ariki katoa o te iwi, tāronatia hoki ki te aroaro o Ihowā, i te ritenga atu o te rā, kia tahuri atu ai i a Īharaira te riri o Ihowā e mura nei.” ");
INSERT INTO mri2012_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Nā, ka mea a Mohi ki ngā kaiwhakawā o Īharaira, “Patua e tēnei, e tēnei o koutou ōna tāngata i whakaūkia ki a Paara-Peoro.” ");
INSERT INTO mri2012_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Nā, ka puta tētahi o ngā tama a Īharaira, e mau ana mai i tētahi wahine Miriani ki ōna tēina i te tirohanga atu a Mohi, i te tirohanga atu anō hoki a te whakaminenga katoa o ngā tama a Īharaira, i a rātou e tangi ana i te whatitoka o te tapenākara o te whakaminenga. ");
INSERT INTO mri2012_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ā, nō te kitenga o Pinehaha, tama a Ereātara, tama a Ārona tohunga, ka whakatika i te whakaminenga. Ka hopu i te tao ki tōna ringa; ");
INSERT INTO mri2012_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","nā, ka haere i muri i te tangata o Īharaira ki te tēneti, ā, werohia ana rāua tokorua, te tangata o Īharaira, me te wahine hoki i tōna tia. Ā mutu iho te whiu o ngā tama a Īharaira. ");
INSERT INTO mri2012_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ā, ko te hunga i mate i te whiu e rua tekau mā whā mano. ");
INSERT INTO mri2012_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Nā, ka kōrero a Ihowā ki a Mohi, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Nā Pinehaha, tama a Ereātara, tama a Ārona tohunga, tōku riri i anga kē atu ai i ngā tama a Īharaira, i tōna ngākau hae pēnei i tōku i roto i a rātou, i kore ai ngā tama a Īharaira e poto i ahau, i ahau e hae ana. ");
INSERT INTO mri2012_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Mō reira me kī atu e koe, ‘Nanā, ka hoatu e ahau ki a ia tāku kawenata mō te rangimārie; ");
INSERT INTO mri2012_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ā, ka mau ki a ia, ki ōna uri hoki i muri i a ia, hei kawenata kia mau tonu te mahi tohunga; mōna i hae, he whakaaro ki tōna Atua, i mea whakamārietanga anō hoki mō ngā tama a Īharaira.’ ” ");
INSERT INTO mri2012_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ā, ko te ingoa o te tangata o Īharaira i patua, i patua tahitia rā me te wahine Miriani, ko Tīmiri tama a Hāru, he rangatira nō tētahi whare kaumātua i roto i ngā Himioni. ");
INSERT INTO mri2012_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ko te ingoa hoki o te wahine Miriani i patua nei ko Kohopi, he tamāhine nā Turu; he rangatira ia nō tētahi iwi, nō tētahi whare kaumātua o Miriana. ");
INSERT INTO mri2012_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Nā, ka kōrero a Ihowā ki a Mohi, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Whakataria he pakanga ki ngā Miriani, patua hoki; ");
INSERT INTO mri2012_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","e whakatari ana hoki rātou i a koutou ki ā rātou mahi tinihanga, i tinihangatia rā koutou e rātou i te mea mō Peoro, i te mea hoki mō Kohopi, tamāhine a te rangatira o Miriana, he tuahine nō rātou, i patua rā i te rā o te whiunga mō Peoro.” ");
INSERT INTO mri2012_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ā, i muri iho i te whiu ka kōrero a Ihowā ki a Mohi rāua ko Ereātara, tama a Ārona tohunga, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Taua ngā tāngata o te whakaminenga katoa o ngā tama a Īharaira, ngā mea e rua tekau, he maha atu rānei ō rātou tau, i ngā whare o ō rātou mātua, ngā mea katoa e kaha ana i roto i a Īharaira ki te haere ki te whawhai.” ");
INSERT INTO mri2012_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Nā, ka kōrero a Mohi rāua ko Ereātara tohunga ki a rātou i ngā mānia o Moapa, i te wāhi o Horano e tata ana ki Heriko, ka mea, ");
INSERT INTO mri2012_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Taua ngā tāngata e rua tekau, he maha atu rānei ō rātou tau,” kia rite ki tā Ihowā i whakahau ai ki a Mohi rātou ko ngā tama a Īharaira, i puta mai i te whenua o Īhipa: ");
INSERT INTO mri2012_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ko Reupena mātāmua o Īharaira. Ko ngā tama a Reupena: ko Hanoka, nāna te hapū o ngā Hanoki; nā Paru, ko te hapū o ngā Parui; ");
INSERT INTO mri2012_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","nā Heterono, ko te hapū o ngā Heteroni; nā Karami, ko te hapū o ngā Karami. ");
INSERT INTO mri2012_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ko ngā hapū ēnei o ngā Reupeni; taua ake o rātou e whā tekau mā toru mano e whitu rau e toru tekau. ");
INSERT INTO mri2012_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ā, ko ngā tama a Paru; ko Eriapa. ");
INSERT INTO mri2012_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Ā, ko ngā tama a Eriapa; ko Nemuere, ko Ratana, ko Āpirama. Ko taua Ratana rāua ko Āpirama tēnei i whai ingoa nei i roto i te whakaminenga, i whawhai nei ki a Mohi rāua ko Ārona i roto i te hui a Koraha, i tā rātou whawhaitanga ki a Ihowā, ");
INSERT INTO mri2012_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ā, ko te hāmamatanga o te māngai o te whenua, horomia ana rātou ko Koraha, i te matenga o taua hui; i te wā i kainga ai e te ahi ngā tāngata e rua rau e rima tekau; nā waiho ana rātou hei tohu. ");
INSERT INTO mri2012_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Kīhai ia i mate ngā tama a Koraha. ");
INSERT INTO mri2012_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ko ngā tama a Himiona, i ō rātou hapū: nā Nemuere, ko te hapū o ngā Nemueri; nā Iamini, ko te hapū o ngā Iamini; nā Iakini, ko te hapū o ngā Iakini; ");
INSERT INTO mri2012_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","nā Tera, ko te hapū o ngā Terahi; nā Hauru, ko te hapū o ngā Hauri. ");
INSERT INTO mri2012_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ko ngā hapū ēnei o ngā Himioni, e rua tekau mā rua mano e rua rau. ");
INSERT INTO mri2012_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ko ngā tama a Kara, i ō rātou hapū: nā Tepono, ko te hapū o ngā Teponi; nā Haki, ko te hapū o ngā Haki; nā Huni, ko te hapū o ngā Huni; ");
INSERT INTO mri2012_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","nā Otoni, ko te hapū o ngā Otoni; nā Eri, ko te hapū o ngā Eri; ");
INSERT INTO mri2012_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","nā Āroro, ko te hapū o ngā Arori; nā Areri, ko te hapū o ngā Areri. ");
INSERT INTO mri2012_vpl VALUES ("NU26_