﻿USE sofia;
DROP TABLE IF EXISTS sofia.kwo_vpl;
CREATE TABLE kwo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kwo_vpl WRITE;
INSERT INTO kwo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Fetali lietu inengutu leteleeke kurulene eetegeni inengoie katu nanabulitu ame glei serinapoolanei, ame aroo amee glei lelali bali lerilu lufwa mei, mwa. ");
INSERT INTO kwo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Marena, aroo ame neri preme lelali, eetegeni inengoi tete melee mei wolu sekaleleeke, rutu lalee inengu maretekume. ");
INSERT INTO kwo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Te tetoo Selilu Fetali eetegeni inengule faleleeke inengutu lufwale ambrei leleeke lalalee. Te oofulilu falerilu fifirule fulefolee ekeni lufwalu tupu menime, ");
INSERT INTO kwo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","esulu ekeni lufwa metie ootupapoleeke furaleleeke oofulilu lalalee. Esulu Selilu Fetali bali mwamole Idenei leleeke, lalali kumori porite. Te eetegeni balifie Fetali ekeni lufwa nali ambrei leleelule eetei sinelee. ");
INSERT INTO kwo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Te Fetali teka teka le eetegeni inengoi ambrei leteleeke, serinapoolanelu ooloo foopori wolitu feti lepoone. Eetegeni ka mareteku wolilu feti, eetegeni bali babi ka bofoo temelalee, oofulilu fanetelari ka te bofoo mei temelalee eetegeni ka wolilu ramelutu nembulu ramelutu falerilu ka. ");
INSERT INTO kwo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Te Paielu Abramele nafolee, “Oone oonanoo inengule, apanele, aianelu poritefule, grialeteluke wa, wokoo bofoo ame nia fetou naworife lelaielufile. ");
INSERT INTO kwo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Tetoo mene oonambuanelu yarife lewieke lalarife lelalu. Mene ame amwime leoolafe, te oonanoofime oonambuanelu arile ame amwime letelafe, te mene oonane glei teieworife lelaie. Mene ame inepane oonane teiewori preme leoolananelu panele mei fune glei teietefe. Te inepane oonane oorerei leoolananelu panele mene ame fetatelafe. Te mene oonane amwi lewieke, oonane ame paielu lufwafe leworife lelaie, tefe oone mei bofoo bofoofu inalilufwale amwi letelale. ");
INSERT INTO kwo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Tetoo mene oonane inepane teiewori preme lenanelu panele mei glei teietefe. Te inepane oonane oorerei leoolananelu panele mene ame oorerei letelarife lelaie. Oonanoofime tetoo mene ame inalilufwale mareteku te wokoo te wokoofule amwime leterife lelaie.” ");
INSERT INTO kwo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Te Paielu nafoleefe, tefe Abrame wokoo Haranele grialeleeke, walali, te Lote mei weife wane. Ekenitu Abramelu yare wolu 75 lefoolali, ");
INSERT INTO kwo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","tetoo nariemu Saraitu, moolu lefoo Lotetu weife ifwatelee. Yesou nali tapoolanelule mei maretekume tewapoone. Te nalife amee amee afoolananelu inalilufwale tukwe nali bwaleetu Haranefule marememe Kenaneile ifwatelalee. Te ifwateleeke, ");
INSERT INTO kwo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","tetoo Abrame nali ifwatelaleelu pane mare Kenanelu amboi ifeletemeleeke, te ka soulu Morei temelaleelu tekoi kuru ifeletelee, wokoo Sekemei. Ekenitu Kenanefu inengu yari ame lalaneime. ");
INSERT INTO kwo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ekenifi boe Paielu sekalefoleeke te nafolee, “Eetegeni inengu oonambuanelufu arile ame fanetefe.” Te ekeise tetoo Abrame Paielule bolele tome ifi tuneke fanenanelu ilekuli titu rigani leleelufi, nali wolume eetei punepofoleelu tekoo. ");
INSERT INTO kwo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Te ekenifu furaleleeke luwari porite luwalee, afune tupu tupulu kumori porite Betele wokoo bwagei temepoolanelume, te itele babi babi tuelee Betelelu ambo guelu, Ailu ambo guelu leleelufi. Betele wokoo yereri porite lalali, te Ai wokoo kumori porite lalalee. Te ekeni tekoi Abrame Paielule eetei bolele tome ifi tuneke fanenanelu ilekulile titu leleeke, te Paielulu bilule rufofoleeke, te na woponefoolalee. ");
INSERT INTO kwo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Te Abrame nali ifwateleelu pane, mare boe fufuru ifenateleeke, ekeni tekoole grialeneke luwari porite amee luwalane. Te eetei ite ite nalene lalane, eetei ite ite nalene lalane, apoofwane Negevelu inengu porite. ");
INSERT INTO kwo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Te Kenanei pupu lie selilu sekaleteleefe, tefe fori yesou gifefe troone troone alane. Tefe Abrame nali ifwateleelu pane mare Kenanele grialeneke Isipeile masekonife waneke oolalane, ekeni lie nembulu feti sekalelaleefe. ");
INSERT INTO kwo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Te Isipei kuruwolerife letewanei, tetoo Abrame nariemule nafolee, “Nanooa, bie fie. Oone ame ramulu reetu lalalu. ");
INSERT INTO kwo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","13","Mena Isipei kuruwoleneke, te lufwa oonane fetaoonei, nanookoe ame pai nafiewobile. Nanoo oonane rame leooneke, te eese nenei, ‘Nanoo Abramelu nariemu,’ nenei, nanoo kose oonane ooloome leooneke, te menane teieooneke tafilafe. Eetete nemboue lebe, ‘Mene Abramelu yafoli,’ nate. Oone eese lelu, nanoo ame menane wolilu ameele leooneke, tetoo menane glei teieooneke tafilafe. Mwa.” ");
INSERT INTO kwo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Te Abrame Isipei woseka leleeke te Isipefu inalilufwa Saraile fetaneke metie mwa, inali nanoolu oofi pifeletelee, kaulefu sumule atukwe aferieleefe. ");
INSERT INTO kwo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tefe Isipefu lufwa telu Saraile fetaneke te kinele nafoone, inali bofoo wolilu eetetie iferineke ifelalane. Tefe Kin Fero nateleeke nalilu iteile ifwane. ");
INSERT INTO kwo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Te Kin Fero Saraile ree porite ange fetaleeke metie nafiefolee. Tefe Abramele Sarailufe kine sakeneefe metie amee sere sere ifalee. Te sakeneefe eesalu yesoule nifwalee, bole ameflee sipsipele, memele, bulmakaule, donkile sitefutu kabinetu, kamele bole, te amee amee afoolananelu inalile tukwe lufwale tukwe nifwalee. ");
INSERT INTO kwo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mwa. Paielu nanoo metie telu telu ree kokoule Kin Fero nalife, nalilu itefu panele tukweme fatietelee. Nali Abramelu nariemule neuneleeke nali falerife, tefe eetegeni ritilule fatietelee. ");
INSERT INTO kwo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Te Kin Fero Abramele fieri nafoleeke, te nafolee, “Ooneboe menane glefeme eesalu amee lewolu. Oone glei menane amwi nawolu, ‘Sarai nianoo inali.’ Mwa. ");
INSERT INTO kwo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Oone menane meme nawoluke nawolu, ‘Nanoo nianoo wofoli’ nawolu, tefe mene nia falerife neunie. Eete oonanoo inali te neuneluke ifwa.” ");
INSERT INTO kwo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Te Kin Fero nalilu kworoofame alananelu panele fieri nateleeke, te natelee, “Oone wamoke Abramele fame lefomoke, eetegeni wokoole afeteli grialeleeke wabee.” Tefe ekepane waneke Abramele noopoo nafoomeneime, te nariemule neuneleeke, nalilu yesoule maretekume peeneleeke, Isipele grialeleeke walee. ");
INSERT INTO kwo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Abrame metie bole ameflee aipoe, bwalee aipoe leleelu lufwa. Nanoo Isipele grialeleeke Negeve porite walee. Tetoo nariemule neunelee, nalilu yesou mareteku peeneleeke, te Lote mei weife nifetewalee. ");
INSERT INTO kwo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Te Abrame nali ifatelaleealeelu pane mare eetegeni tekoole grialeneke boe wane bulari porite, oosulu afweeme. Te eetei ite ite nalene lalane, eetei ite ite nalene lalane, eese afwaneke boe Betelelu ambo guelu, Ailu ambo guelu leleelufi babi babi bebriefu ite frabufi kuruwolene. ");
INSERT INTO kwo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Te Abrame nali wolume leleelu ilekuli porite waleeke, te boe eeteise tetoo bolele ifi tome amee tueleeke isokwi bri lefoolali, merekeilu seralu peenalefoolali te Paielulu bilule rufofoleeke na woponefolee. ");
INSERT INTO kwo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Te Lote weife Abrametu wane. Nanoo mei bole ameflee aipoe, inalilufwa aipoe tefoo lufwa. ");
INSERT INTO kwo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nanoo weife eesalu yesou aipoe tefoo pane, tefe weife glei mwamolei lalabile, inengu glei selilu. ");
INSERT INTO kwo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Te bofootu Abramelu bole amefleele gipofoolanelu panetu Lotelu bole amefleele gipofoolanelu panetu nali kwaife fame na fame na nafwane. (Eetegeni lietu Kenanefu panetu Peresefu panetu ame teime lalaneime.) ");
INSERT INTO kwo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tefe Abrame Lotele nafolee, “Mene weife mwamole fweelu. Mene weife fame na nenei, tetoo menane amee amee aoolananelu lufwatu, oonane amee amee aoolananelu lufwatu kose nali kwaife fame na nebile. ");
INSERT INTO kwo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tefe inengu selilu lafwalee. Bie oona molukwe glelu porite fete fete aluke, tetoo eetei oolalarife namunefoluke, tetoo wale akeporite menane grialewoluke, oona kumori porite foofwafe nelu, tetoo mene yereri porite fooforefe, te oona bulari porite foofobulafe nelu, tetoo mene luwarilume foofoluwafe.” ");
INSERT INTO kwo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Te weife teime temepoolanei tetoo Lote Jordane porite waleelu wokoo pri porite oofwanefwaleelu, Soare wokeime wolelee. Te ekeni inengu mareteku melee sai sai lafwanelufe tefe inengu metie wolilu letewalee, Idene bali, Isipelu inengu atukwe letewalee. (Ekeni krietu Sodometu Gomoratu Paielu ame teieteri preme lelali.) ");
INSERT INTO kwo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Te Lote Jordane melee porite lafwaleelu wokoo prile namunefolee maretekume falerife, ekeni wokoo pri kumori porite lalalee, tefe kumori porite walee. Abrametu Lotetu weife wolu fime fime ane. ");
INSERT INTO kwo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abrame Kenanelu inengoi teime amelee. Te Lote ekeni wokoo prifi lapruefwanelu wokoo mare oolamene. Te nali ite Sodome wokoo bwagei tuelee. ");
INSERT INTO kwo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomefu inalilufwa nembue ame glei wolilu ameetu lalane. Mwa. Nanoo Paielule metie oorerei lefoolanane. ");
INSERT INTO kwo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lotelu pepelufi, tetoo Paielu Abramele nafolee, “Nembue eke temelalufime, ookumolu, ooyerelu, oobulalu, ooluwalu le. ");
INSERT INTO kwo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Te inengu eke fetafwalulu mareteku nia ame oonafe foofwalarife seinaoolaielu, oonambuanelufu arile tukwe. Ekeni inengu oonanoo same lafwaoolarife lelalee. ");
INSERT INTO kwo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Oonambuanelufu ari ame nia amwi letieke tetoo sai sai lerife lelane ka fulu atukwe. Lufwa bofoo eetegeni inengoi temepoolanelu ka fulule nemboue mareteku namuneteleeke tatukwe pookanaleteli, tetoo nali oonanoo arile mei mareteku nemboue namunetebe. ");
INSERT INTO kwo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Te furaleluke ekeni inengu lemeleelu atukwe, nia oonane mareteku seinawielufile waluke eetei oolala.” ");
INSERT INTO kwo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abrame eetegeni tekoole grialeleeke, waleeke Hebrone wokoo bwagei oolalalee. Te ka selilu temepoolanelu tekoi masekoni itele eetei tuelee. Ekeni kalume leleelu ambo Mamrelu. Te Paielule bolele tome amee ifi tuneke tatukwe isokwi bri lefoolali fanenanelu ilekulile ekenifi lelee. ");
INSERT INTO kwo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Eetegeni lietu tetoo eetegeni 4 lenelu kine, Amrafele nanoo Sinarefu kine, Arioke nanoo Elasarefu kine, Kedorlaomere nanoo Elamefu kine, Tidale nanoo Goimelu kine, nanoo nali kwaife sagoo leneke, ");
INSERT INTO kwo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","te fame tewatene, tupane yarilutu leneke oolalanelu kinele. Te tupane oolalanelu kine nanoo Bera, nanoo Sodomefu kine, Birsa nanoo Gomorafu kine, Sinape nanoo Atmafu kine, Semebere nanoo Seboimefu kine, Belafu kine mei mare, (eetegeni wokoolu bilu bofoo Soare), ekepane 4 lenelu kine eetegeni kinele ifapureletene. ");
INSERT INTO kwo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Te eetegeni yarilutu lenelu kine Sidimelu Wokoo Prifi, (Detsi Beebe), nali kwaife lukulene na sere lerife, nalilu kworoofame lufwa mare. ");
INSERT INTO kwo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kedorlaomere nanoo ipoelu lufwa nanoo 4 lenelu kinele nambuletelaleelu lufwa, te nali nanoolu ameime lamenei yare 12 leteleeke, te boe 13 lelali tetoo nalife ifapurelene, nali nanoolu amei same lalarife ulabee nenelufe. ");
INSERT INTO kwo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tefe yare 14 lelali Kedorlaomere nali, nalilu kworoofame lufwatume, nali mare sagoo lenelu 3 lenelu kinelu kworoofame lufwatume mare sagoo ifeleteleeke, te wane. Kedorlaomere nanoo 3 lenelu kinele ifwateleeke 5 oolalanelu kinele, tetoo afoi Refaimefu inalilufwale bebeneneke, Asterot Karnaime wokoo soulufi, te Susefu inalilufwale, nanoo Hame wokoo soulufi bebeneneke, te Emefu inalilufwale Kiriataimelu wokoo prifi eetei bebenene. ");
INSERT INTO kwo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Te Horefu inalilufwale Seirelu afune tupulu tupulu meleelufi bebe bonene, te gululu ifeletemeneke Elparane wokeime wolenelu, te wanekeme pepelu tekoo inengu guelufime wolene. ");
INSERT INTO kwo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tetoo teime luluneneke Kadese wokeile wane (bebriefu bilu Enmispate nafoone). Te Amalekelu inengu lemeleelu atukwe, tatukwe falerife ifapure ifapure ifafwateleeke, te Amorefu inalilufwa Hasason Tamarelu wokei lalanelule bebenene. ");
INSERT INTO kwo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nembue yarilutu lenelu kine mare aneri lerife lelane kworootu. Tefe yarilutu lenelu kine, mwamole mwamole nalilu kworoofame lufwale seboo ifenafwateneke Sidimelu wokoo prifi kuru kuru aneke te mare sagoo leneke, te kworoo kworoo leneke 4 lenelu kinele ifwapureleterife lelane. ");
INSERT INTO kwo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Te yarilutu lenelu kinetu 4 lenelu kinetu aneri lelane Sidimelu wokoo prifi. ");
INSERT INTO kwo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Te eetegeni wokoo prifi koltale pupufwatenelu gugulu aipoe lelee, tefe Sodomefu kinetu Gomorafu kinetu nalilu kworoofame amee alananelu lufwa wofrife brunalelanei, tetoo ekeni gugulufi yekuru napoofwane, te lufwa telu afune tupulu tupulu meleelume brunalene. ");
INSERT INTO kwo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Te 4 lenelu kine te yesou te yesou wolilule, fori yesou Sodomefule, Gomorafule maretekume peeneteneke tewapoone, yesou bofoo glei grialenei, mwa. ");
INSERT INTO kwo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Te tupane kine Abramelu nambue Lotele mei neuneneke ifwane, nalilu yesou maretekume peenefooneke tewapofoone, ekeni lietu Lote nali mei ame Sodomei lalalee. ");
INSERT INTO kwo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Te bofoo lufwaleme tialeleelu, tetoo waleekeme eetegeni yesoufe Abramele alipofolee. Abrame nanoo fime Hibrufu lufwa. Nanoo ame teime Mamrelu ambo tekoi temepoolanelu ka seselilu bwagei lalalee. Mamre nanoo Amorefu lufwa, te nalilu retifu lufwa Eskole, Anere, nali Abramelu ambrefe leneke mare kworoo talanelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tefe Abrame nambue Lotele beleneke ifwanelu nale fieleefe te nalife nifetalanelu lufwa 318 le fieri nateleeke rine. Te Lotele beleneke ifwanelu lufwale gululu ifeletewatenekeme Dane wokeime wolene. ");
INSERT INTO kwo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tetoo eetegeni wokei Abrame krieime nanoo nalife nifetalananelu lufwale famefe ifwaterife lelaleelule, telutu teka leleeke amee feti porite gulunaneteli, te telutu teka leleeke aneboi amee porite gulunanetelee, te krieimeme bebenelee tupane 4 lenelu kinele. Te telule gululu ifeletemeneke Damaskuse wokoole grialeneke bulari porite amee Hoba wokeime wolene. ");
INSERT INTO kwo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Te yesou maretekume boe wolu peenene, tupane lufwale bebeneneke ifwatenelu lufwalule tewapotenelu. Abrame boe neunelee nambue Lotele te nambuelu yesou mei tatukwe peenefolee 4 lenelu kine bebeneneke ifwatenelu inalile, inalilufwale mei maretekume boe wolu neunatelee. ");
INSERT INTO kwo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Tetoo Sodomefu kine rieleeke fetalee Save Wokoo Prifi (bofoo bilu Kinelu Wokoo Pri) Abrame wolu neunateleeke 4 lenelu kine bebeneneke ifwatenelu inalilufwale. ");
INSERT INTO kwo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","19","Te Melkisedeke Salemelu kine, nanoo tabetu wainetu peeneleeke Abramele teripofolee. Nanoo Paie Tefoo Feti Gotelu prise, nali Abramele aikopi lefoleeke tetoo nafolee, “Nemboue, Paie Tefoo Gote nalilu bilu same wafoolabee. Nali aikopi lewoleeke oone tetoo bebeneluke neunatelu eke bebeneneke ifwatenelu inalilufwale, nali efenele, inengule brege leteleelu. ");
INSERT INTO kwo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nemboue, Paie Tefoo Gote nalilu bilu same wafoolabee tetoo nalilu kaiseklilutu 4 lenelu kine oonane ree fueleoone bebenelalu.” Te yesoule te fu mwamole te fu mwamole afwateleeke te ameelu 10 leleeke, te bofoo ameelule peeneleeke Melkisedekele nifwalee. ");
INSERT INTO kwo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodomefu kine nali Abramele nafolee, “Oone eke neunatelulu inalilufwa menane seinatue te yesou mareteku eetete oonafe tapoola.” ");
INSERT INTO kwo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tefe Abrame Sodomefu kinele nafolee. “Mwa. Paielu Paie Tefoo Gote nali efenele inengule brege leteleelu bilutu mene bi naoolaie, ");
INSERT INTO kwo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mene yesou bofoo oonanoofu glei falefe. Tetoo leeloo tetoo kretepoolanelu roorile, priemoole mei glei peenefe. Mwa. Oone kose nele, ‘Abrame nanoo menanoo yesoutu lalaleelu lufwa.’ ");
INSERT INTO kwo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nia mei yesou bofoo glei faletefe. Mwa. Kame fori yesouleme menanoo kworoofame lufwa wolu foopoonelu eeteleme eetetie, te kame Anere, Eskole, Mamre nanoo nia kafee ifeletelaielu lufwaleme nalife nemboue peenebile.” ");
INSERT INTO kwo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Eetegeni yesoufe, tetoo, Paielu boe Abramele rarauetu atukwe fwarinelali, nafolee, “Abrame, oone kose wofri lele mani, mwa, mene oonanoo foreni, mene ame oonane paie tefoo lufwafe leworife lalaie.” ");
INSERT INTO kwo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tetoo Abrame fune nafolee, “O Paielu Gote, oone menane glesoule fanewole, tetoo oone menane eesalu lufwafe lewole, mene ame akibolu lufwafe lieke lalaie, tefe ine menanoo gugulule faleleeke lalabe, tetoo menanoo yesoule mareteku peenebe, mwa? Nembue lalaleelu lufwakoe Eliesere Damaskusefu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Te Abrame boe Paielule nafolee, “Oone menane ari bofoo glei fanewolu, mwa, tefe nie, niafe aikopi aoolaleealeelu lufwa nianoo itefu, nali ame nianoo gugulule falebe.” ");
INSERT INTO kwo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mwa. Paielu fune Abramele nafolee, “Ekeni lufwakoe glei oonanoo gugulule faleleeke lalabe, te oonanoo yesou mareteku mei, glei peenewobe. Eete glefe? Oonanoo fweelu nalimeme ame oonanoo gugulule faleleeke tetoo yesou oonanoole mareteku peenebe.” ");
INSERT INTO kwo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Te itefu ifesekaleleeke te nafolee, “Bie mwame ooti leluke limwafule fetate, oone nemboue pe namunetele?” Eese nafoleeke, te boe nafolee, “Oonambuanelufu ari ame eetegeni limwafu atukwe lerife lelane.” ");
INSERT INTO kwo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abrame Paielulu nale fiefoleeke nifeleefe, tefe Paielu Abramele eetegeni bilule fanelee, “Lie platefu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Tetoo Paielu Abramele nafolee, “Nia Paielu ine oonane Urefule neunawieke iferiewie Kaldiafu inalilufwalu inengufule, eetegeni inengu Kenanele nia oonafe ifalarife seinaoolaie.” ");
INSERT INTO kwo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tefe, Abrame Paielule nafolee, “O Paielu Gote, mene ake liekeme rame lefe inengu eetegeni oona seinawolulu marena pe, niafe mareteku seinawolu?” ");
INSERT INTO kwo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tefe Paielu Abramele nafolee, “Oone oonanoo geni bole ameflee, bulmakau kapulu sitefu, meme kapulu sitefu, sipsipe kapulu kabine, yare ame mwangife lelanelu genileme fete fete ateluke, neunate, te kaulefu mei are bofoo bolu bofoo sekaue, eese leluke menane iferietue.” ");
INSERT INTO kwo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Te Abrame eetegeni yesou maretekume Paielule ifwatefoleeke, te babi pootepoofwaleeke mopu mopuelule maretekume babri babrilufi luafwalee. Te kaulefu bolutu sekauetu, mwa, glei pootepolee. ");
INSERT INTO kwo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Te kaulefu yepi eetegeni bolele fooporife ange rinelu, mwa, Abrame metie kepureletelee. ");
INSERT INTO kwo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Lie pine pine afereli, te Paielu nali Abramele menengu amee lefoleeke, rofoo peti lelali, tetoo eetegeni yesoule rarauetu atukwe fetaleelu, timenee atukwe pineteriefolee. Te binalefoolali, tetoo nanoolu oofi glei pifelefolee. Mwa. ");
INSERT INTO kwo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Te Paielu nafolee, “Oonambuanelufu ari ame waneke lufwa wokoolu inengoi oolalabile, ekeni inengoi masekonife rawie inalilufwafe lebile. Tetoo nali inengu yarile ambei letelanelu inalilufwafe leneke, tetoo inengu yariane glei amwi letelabile. Te kame nalilu ameime lalanei yare ameelu 400 letebe. ");
INSERT INTO kwo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nia ame tupane oonane eesalu amee ifamoolanelule fune mei ame teietefe, tetoo oonambuanelufu ari ame yesou aipoe leneke tetoo ekeni inengule grialebile. ");
INSERT INTO kwo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mwa. Oone ame lafwalaluke, lufwasekli leluke, tafilalu, tetoo teime fatiewobile. ");
INSERT INTO kwo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nembue oonambuanelufu ari eetegeni inengoile glei afeteli riebile. Mwa. Neembee yare ameelu 400, tetoo boe eetegeni inengoile riebile. Eete glefe? Amorefu inalilufwa nalilu fwagilu amee nembue ame glei selime letelalee, mwa. Bie ekeni amee nalilu selime leteleeke, tetoo nia ame teie teie atieke eetegeni inengule grialebile.” ");
INSERT INTO kwo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Oo wolu mare pinaleleeke tetoo yesou are kuruleneke bole mopu mopuelu lailanelu babime walanei booreletewatene. Eetegeni yesou are bofoo itefu bregeefi wifu lelali te bofoo i rilu yesinei rinafwalee. ");
INSERT INTO kwo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Te ekeni lietume tetoo Paielu Abramele ameelu amwi sere lefoleeke te nafolee, “Nia ame oonambuanelufu arile eetegeni inengule mareteku nalife seinatefe. Isipelu wokoo bwagei lalaleelu melee tukweelufime woleleeke te waleekeme melee (retilu) Yufretisetume wolelee. ");
INSERT INTO kwo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Tetoo nanoo ame eetegeni inengule mareteku faletewabile: Kenilule, Kenaselule, Katmonelule, ");
INSERT INTO kwo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitelule, Pereselule, ");
INSERT INTO kwo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorelule, Refaimelule, Kenanelule, Girgaselule, te Jebuselule inengutume wolebile.” ");
INSERT INTO kwo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, Abramelu nariemu, ari bobolufe leleelu inali. Nanoo nalife amee amee afoolaleealeelu auteli ramulu Isipefule ifalalee. Eetegeni autelilu bilu Hagare. ");
INSERT INTO kwo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tefe Sarai nali nungulile nafolee, “Fetawolu pe menane! Paielu nali mene ari terierife glei i nawolee. Tefe oone menane amee amee aoolaleealeelu auteli ramulule wari ifa. Nanoo ari terieleeke lupoleli, tetoo ekeni ari eetete menanoo ari niafe lupolewolee.” Abrame Sarailu nale metie fiefoleeke nifelee. ");
INSERT INTO kwo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Te yare wolu yarilutu yarilutu lelalee Kenanelu inengoi lamenei, tetoo nariemu nali, nalife amee amee afoolaleealeelu auteli ramulule nungulile seinafoleeke falelee. ");
INSERT INTO kwo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Te Abrame Hagarele wari ifaleeke, wolu arietu lelalee. Hagare nali, wolu tetoo lelaleefe, tefe Saraile oo maumau ifalalee. ");
INSERT INTO kwo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Te Sarai nungulile nafolee, “Nembue menane glei reeyemee leoolalee eete oonanoo yesou, oonameme amwi sere le. Mene nia ifalaielu auteli ramulule, oonane eese lewielufe nembue nanoo menane oo maumau leoolalee. Paielu nalime rame lelee, eetegeni yesou eete inelu.” ");
INSERT INTO kwo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Te nunguli nariemule fune nafolee, “Fila. Hagare, nanoo oonane amee amee aoolaleealeelu auteli ramulu eetete oonanoo yesou, oona menengu leluke tetoo glelu amee lefole.” Te Sarai Hagarele glei amwi lefoolaleefe, tefe Hagare metie soosoolutu tialelee. ");
INSERT INTO kwo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Te Surelu wokoo afweele nifeleeke, pepelu amboi woseka lelee. Te Paielulu ensele, gugu melee bofoo lalaleelu bwagei sekalefoleeke, ");
INSERT INTO kwo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","te nafolee. “Hagara! Oone Saraile amee amee afoolalualulu inali. Akenifu rielu, tetoo akeme walalu?” Te Hagare fune nafolee, “Mene Saraile grialieke, tiaferie.” ");
INSERT INTO kwo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Te Paielulu ensele nafolee, “Oone lunaleluke boe Sarailufile wa, te kame nanoolu naleme fiefoolalu nifefoola.” ");
INSERT INTO kwo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Te Paielulu ensele boe same nafolee, “Mene ame, oonambuanelufu arile amwi letieke, motukwe leneke tetoo lufwa glei namunetebile.” ");
INSERT INTO kwo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Te Paielulu ensele boe nelee, “Oone nembue wolu arietu lelu, ari kaporele lupolerife lelalu. Ari bilu Ismaele, Paielu nali oonanoo soosoolu eele wolu fiewolee. ");
INSERT INTO kwo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tetoo, oonanoo arikoe sabei kulitu temelali, amwi mwamolei glei lalarife lelalee. Mwa. Kame kaulefu bomu atukwe arefelarife lelalee. Te ame inalilufwa oogegeretu fetalarife lelane. Te fune mei oogegeretu fetatelali, retifu na neri preme lerife lelalee.” ");
INSERT INTO kwo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tetoo Hagare Paielule menengu lefolee, nali na nafoleelule tefe eetegeni bilule Paielule fanelee, “Gote oona menane fetawolulu.” Eetetie eese nelee, “Mene nembue eetegeni Gote nali menane fetawoleelule wolu fetaie.” ");
INSERT INTO kwo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Te eetegeni yewilufe tefe gugu meleele eese nafoolane, “Oofulilu tefoo fetawoleelu Gotelu gugu melee.” Eetegeni gugu melee Kadese wokoo Berete wokoo babi babime lalalee. ");
INSERT INTO kwo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Tetoo Hagare ari kapore Abramelule lupolelee, te Abrame bilu Ismaele nafolee. ");
INSERT INTO kwo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Eketu Abramelu yare wolu 86 lefoolali, tetoo lupolelee. ");
INSERT INTO kwo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramelu yare wolu 99 lefoolali tetoo Paielu boe sekalefoleeke te nafolee, “Nia eetetie Kaiseklilu Same Lafwalarilu Gote, oone menaneme same reeyemee letewaoolalu nifeoola tetoo wolilu ameele nianoo oofi lela. ");
INSERT INTO kwo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mene ame na nia weife sere lenelule nifefe, tetoo oonambuanelufu arile mene ame amwi letieke tetoo sai sai lerife lelane.” ");
INSERT INTO kwo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Te Abrame tumefreleleeke tupu sunalelali tetoo Gote nafolee, ");
INSERT INTO kwo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Bie fila! Mene niafe oonane naoolaie, inalilufwa ame te wokoo te wokoo eetegeni inengoi fime fime aneke laprufwanei sabei oonanoofu ari nali ari lelanelule tetoo mene oonane yarife leteluke lalarife leoolaie. ");
INSERT INTO kwo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tefe oonane boe glei Abrame naoolabile, mwa. Nembue oonanoo bilu Abrahame naoolarife lelane. ");
INSERT INTO kwo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ame nia oonane amwi lewieke, tetoo ame ari aipoe aipoe tefoo lufwafe leluke, tetoo oonambuanelufu ari fime fime aneke tetoo te wokoo te wokoole wokoo soulufe letewaterife letelaie. Te telule ame kinefe leterife lelaie. ");
INSERT INTO kwo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nianoo na oone same nifelarife, fatilaie, tetoo marekulitu lafwalarife, eetegeni na nembue mena pe lelaielufe? Eie, mene oonambuanelufu arile tukwe te nanoolufu ari sabei ari leterierife lelanelufe tukwe fatilaie. Nia eetetie mwamole Gote lamoolaie. ");
INSERT INTO kwo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Inengu mareteku eke oone eetei masekonife lalalulu, eete Kenanelu inengu. Ekeni inengu mareteku mene ame oonafe tukwe, oonambuanelufu ari sabei ari letewarife lelanelule tukwe, fanewofe. Nia tetoo nanoolu Gotefe letieke latelafe. ");
INSERT INTO kwo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Te Gote Abrahamele nafolee, “Mene kame oonafe naoolaie oone nianoo nale amwi bele, sabei oonambuanelufu arile tukwe te nanoolufu ari sabei ari letewarife lelanelutu oona mareme nia namwielu naleme nifelabu.” ");
INSERT INTO kwo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tefe Gote nelee, eetegeni amee nianoo, oonambuanelufu ari sabei ari letewarife lelanelutu oonapotu lufwalu ree leeloole mareteku kreenaporilu amee eete lemwielule amwime nifelabu. ");
INSERT INTO kwo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Tefe nembuefu ari kapore sabeifu ari kaporele mei mareteku eetegeni ameele same letewalarife lelane, ame fweelufime lie tialoo are lelali. Eetegeni amee eete mene lielu oonetu weife ame eesalu amee alarilu akeriefe lalabe, te menanoo nasile menengu lefoolarife. ");
INSERT INTO kwo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Eke oona ifatelalu luponulanelu kapore arile, bwaleetu neunatelulu luponulanelu kapore arile mei eesalu ameele letewatebu. Eetegeni amee eete oonanoo reele eese letelamolu eetete nianoo amee oone tetoo menengu leoolarife. ");
INSERT INTO kwo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Abrahame, bofoo lufwalu ree leeloole kreenapori preme lenei, eetete nanoo glei eesalu amee leteneke lalanelu lufwa, mwa, nanoo mene lielu ameele futeni lefoleelu lufwafe lelee. Tefe eesalu lufwale grialemoke nalime lalabee. ");
INSERT INTO kwo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Gote Sarailufe Abrahamele nafolee, “Nembue oonariemu Saraile kose bilu Sarai nafoolale mani. Mwa. Nanoolu bilukoe nembue kame Sara nafoola. ");
INSERT INTO kwo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mene ame aikopi lefwieke, tetoo oonane ari kapore mwamole fatiewoli, tetoo mene ame aikopi lefwieke, tetoo nanoolu nambuanelufu ari ari lelanelu ame fime fime aneke, te wokoo te wokoole wokoo soulufe letewaterife letelaie, tetoo telu ame kinefe letewalabile.” ");
INSERT INTO kwo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Gote, Sara ari kapore ame terieleeke lupolebe nafoleefe, tefe Abrahame tumefreleleeke tupu sunalelali te nalife yeu natu nelee, “Eesalu lufwasekli nemboue pe ari kaporele fatiebe yare wolu 100 lefoolali? Sara mei nemboue pe eesalu inasekli ari mwamole fatiebe yare wolu 90 lefoolali?” ");
INSERT INTO kwo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Te Abrahame Gotele nafolee, “Nemboue pe Ismaeleleme aikopi lefoluke, tetoo menanoo gugulule faleleeke te yesou mareteku peenebe?” ");
INSERT INTO kwo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tetoo Gote nafolee, “Marena. Oonariemu Sara ari kapore mwamole lupolebe, tetoo bilu Aiseke nafo. Mene ekeni amee oonetu weife lenelu boe ame Aiseketu weife sere lebile. Tetoo nanoolu nambuanelufu ari neembee eetegeni amee sere leneluleme nifetalabile.” ");
INSERT INTO kwo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Paielu Ismaelelelufe Abrahamele nafolee, “Mene wolu fiewie, oone menane Ismaelele amwi leforife nawolulu. Eetete marena, mene ame amwi lefwieke tetoo ari aipoe tefoo lufwafe leleeke, te nanoolu nambuanelufu ari mei eetutume letewabile. Te nanoolu ari nalime ame 12 leneke lalarife lelanelu yefeelu lufwalu yarife lefwieke, tetoo nanoolu nambuanelufu arile lufwa bofoo glei buruanaletebile. Eetetie eesalu lufwafe leforife lelaie. ");
INSERT INTO kwo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mwa. Mene eetegeni amee sere lewielule glei bofoo lufwatu lerife lelaie. Mene metie Aiseketume lerife lelaie, Sara ame lupolerife lelaleelu aritu, eete na ifenaoolaielu eesalu lietume bofoo yaretu.” ");
INSERT INTO kwo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Te Gote Abrahamele eetegeni nale nafoolaleeke, pepeleleeke, tetoo Abrahamele grialeleeke walee. ");
INSERT INTO kwo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Tetoo eetegeni lietume Abrahame lefoo Ismaelele neuneleeke, tupane nalilu itei yefeeane luponunelu ari kapore, nali bwaleetu peeneleelu ari kapore, seselilu lufwa Abrahame nalilu itefu, metie marememe nalilu ree leeloole kreenapoofwatelee, Gote nali nafoleefe. ");
INSERT INTO kwo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahame metie lufwasekli leleeke, yare wolu 99 lefoolali, tetoo nalilu ree leeloole tekalefoone, ");
INSERT INTO kwo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","te lefoo Ismaele mei yare wolu 13 lelalee. ");
INSERT INTO kwo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahame weife lefoole tukwe mwamole lietume nalilu lufwalu ree leeloole kreenapotene. ");
INSERT INTO kwo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Tetoo Abrahame nalilu itefu lufwatume, te tupane ine nali bwaleetu neunateleelu panetu maretekume nanoolu ree leeloole kreenapoofwatene. ");
INSERT INTO kwo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Te bofootu Paielu Abrahamele boe na ifenerife rielee, Mamrelu ambo tekoi temepoolanelu ka seselilu bwageile. Te feiferi lietu Abrahame lie gaga nelaleelu ree petife nalilu amblenifi lafieleeke lamelee. ");
INSERT INTO kwo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Tetoo, oowaleelu te lufwa mwangife wotemepoolanei fetatelee. Te esulu gugutupoleeke pinetewalee wofetaterife, te ipoe rugunalelali ");
INSERT INTO kwo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","te natelee, “Oone Paielu. Oone menanoo itele boorelefobule mani, mwa. ");
INSERT INTO kwo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Oone bie eetegeni ka pilu ambei laprumoke yenalelabu. Mene ame oonane melee fooporife, kulile suwanaleterife tukwe wofalemwieke teriemofe. ");
INSERT INTO kwo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tetoo mene oonane fori yesoule peenemoolaie, tetoo arie tirenumoke wabule. Oone nembue menanoo nale fiemoke iteile rimo.” Eese nateleefe te fune nafoone. “We. Nembouo! Oona eke nelulu atukwe eese le.” ");
INSERT INTO kwo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Te Abrahame afetelime walee iteile nariemu Saralufile. Te waleeke, nafolee, “Bie afeteli tabe ti mwangife leluke tupwala.” ");
INSERT INTO kwo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Te nali afetelime pipinaneleeke nalilu bole bulmakau kapulu ulielu tefooleme neuneleeke fanelee nalilu amee amee lufwale tetoo borei teka leleeke tueterife. ");
INSERT INTO kwo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Te eetegeni bole wolu koomoleefe, tetoo tabetume, bulmakau totoo nangulutume peeneteleeke, te tewapoteleeke nifwatelee. Te foopoolanei, nali roboi tememelee ka nanglilu bofoofi. ");
INSERT INTO kwo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Te foopoolanelu wolu pookanaleteneke, tetoo fiefoone, “Oonariemu akei?” “Eke itei oolalalee” nateleeke, ");
INSERT INTO kwo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","te Paielu nafolee, “Krie nia wolu namunefwie nembue eesalu wositume, bofoo yaretu mene tetoo boe ame riefe, ekenitu tetoo oonariemu ari kaporele teriebe.” Sara nali fietemelee amblenei tememeli ekeni lufwalu bwagei. ");
INSERT INTO kwo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Te Abrahametu nariemu Saratu weife metie wolu lufwasekli, inasekli lelane, Sara tetoo ari terierife, mwa. ");
INSERT INTO kwo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tefe yeuleme nelali, te nalife menengu leleeke nelee, “Mene mwa, wolu inasekli lie, nianoo lufwa mei same, wolu lufwasekli lelee. Nemboue pe weife wariarife? Mwa.” ");
INSERT INTO kwo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tefe Paielu nariemulufe Abrahamele eesalu fiefori lelee, “Glefe oonariemu yeu nelee? Nanoo kose mwa nebe mani. Mwa. Nanoo ame ari kaporele teriebe. ");
INSERT INTO kwo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yesou bofoo mene lerilu mwa pai, menane gigime pai lewolee? Mene boe ame oonanoofile riefe eetegeni krie mene namunefwielutu, tetoo Sara ari kaporele teriebe.” ");
INSERT INTO kwo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara metie wofri leleeke meme nelee, nali yeu neleelule, tefe Paielu nafolee, “Marena. Oone glei menane meme nawole, mwa, oone eketie yeu nelu.” ");
INSERT INTO kwo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Te ekepane fufuru neneke wane Sodome wokoo porite. Abrahame afoi sinaterife walee wokoo Sodomele fetarilu oo wolitu leleelufi kuruleneke, te temepooneke Sodomele oowafoomene. ");
INSERT INTO kwo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Tetoo Paielu nelee, “Mene Abrahamele eetegeni amee lerife lelaielule glei ambutelefofe, mwa. ");
INSERT INTO kwo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Marena, bofoo wokoofu inalilufwa Abrahamelu nambuanelufu arile glei rune letebile, mwa. Tetoo wokoofu inalilufwa telu eetegeni inengu lemeleelu atukwememe wokoo wokoo letewalanelu inalilufwa nanoolufi mene ame amwime letieke, tetoo wolilu lafieri letewalabile. ");
INSERT INTO kwo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mene nalife wolu namunefwie, nalilu arile nateleeke ifwaterife, te nanoolu nambuanelufu arile mei eetegeni na nia nafwieke nateleelu naleme same tafwalanei woli wolilu ameeleme nianoo oofi afwalarife lelane.” Te eese nafwafoleeke, te nelee, “Te yesou te yesoule mene wolu nasi nawie, eetete mene ame leterife lelaie.” ");
INSERT INTO kwo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Te Paielu nafolee, “Sodomefu Gomorafu inalilufwalu fwagilu amee nali alanelule glei grialetelane. Te eetegeni fwagilu amee alanelu na ulu nali metie selime letelalee. ");
INSERT INTO kwo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tefe mene ame tiralefe, eetegeni ameele alanelu inalilufwale yefetaterife. Nanoolu na ulu mene fielule rame lerife, eetegeni na marena pe?” ");
INSERT INTO kwo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Te weife nanoolume koona mufenuneke te Sodomeile wanei, tetoo Paielu nanoo weife Abrahametu teime temepoomene. ");
INSERT INTO kwo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Te Abrahame Paielulu bwageileme waleeke eesalu fiefori lelee, “Oone woli wolilu inalilufwatume, fwagilu amee inalilufwatume nembuari leterife lelalu pe?” ");
INSERT INTO kwo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Te nafolee, “Tetoo oone ake letele, inalilufwa wolilu eetegeni wokei 50 leneke lalanei? Oone eetupane mareme pe nembuari letele? Oone nemboue pe inalilufwa wolilu 50 leneke lalanelu wokoo soulule nembuari lefori preme lele? ");
INSERT INTO kwo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Oone wolilu amee tefoo, fwagilu amee tefoo inalilufwatume, nembuari leterife pe nelu? Oone glei eesalu ameele alalulu Gote. Mwa. Oone eetegeni inengufu inalilufwalu nale fietelalu na sere letelalu wolilu ameeleme nifelalualulu Gote.” ");
INSERT INTO kwo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Te Paielu fune nafolee, “Tetoo mene Sodomefu inalilufwa wolilu 50 fetatiei, mene eetegeni wokoo soulule glei nembuari lefofe, mwa, mene tupanelufe grialefe.” ");
INSERT INTO kwo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Te Abrahame fune nafolee, “Paielu, oone tukweelu pe, mene na same ifenaoolaielu, mene oonanoo oofi eetegeni inengu asalu keme lie, tetoo mene yesou bofoo lerife nefe. ");
INSERT INTO kwo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tetoo inalilufwa wolilu 50 fu 5 oofe leneke, te 45 me lalanei, ake letele? Eetegeni wokoo soulule teiforime lele pe, inalilufwa 5 oofe lenelufe?” Te nelee, “Mene inalilufwa wolilu 45 leneke lalanelule fetatiei, eetegeni wokoo soulule glei teiefofe.” ");
INSERT INTO kwo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Te Abrahame boe same nafolee, “Tetoo oone ake letele inalilufwa wolilu 40 leneke lalanei?” Te Paielu fune nafolee, “Mene inalilufwa wolilu 40 leneke lalanelufe, glei eese letefe.” ");
INSERT INTO kwo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tetoo Abrahame nafolee, “Paielu, oone tukweelu pe, oone menane kose fame lewole mani, mwa, bie mene na boe ifenawofe. Inalilufwa 30 leneke lalanei?” Te nafolee, “Mene inalilufwa 30 lalanei fetatiei, glei eese letefe.” ");
INSERT INTO kwo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Te nafolee, “Paielu, oone tukweelu pe, mene na same ifenaoolaielu. 20 leneke lalanei?” Te fune nafolee. “Tetoo 20 leneke lalanelufe mene glei teiefofe.” ");
INSERT INTO kwo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Te Abrahame boe nafolee, “Paielu, oone menane kose fame lewole mani, mwa, bie mene oonane na mwamolefe boe nepolewofe. Te kame yarilutu yarilutu leneke lalanei?” Te fune nafolee, “Eetegeni yarilutu yarilutu lalanelufe tefe mene glei teietefe.” ");
INSERT INTO kwo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Te Paielu na nafwaleelu pepe leleeke, te Abrahamele grialeleeke wali, te Abrahame mei esulu walee. ");
INSERT INTO kwo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Lote lafieleeke lamemelee, eetei lukulenalanei, wari alananelu ambleni selilufi. (Eetegeni ambleni Sodome wokoo soulule fwai ifenalenelu feefi lokulenelu ambleni.) Tetoo Paielulu ensele are rine, eetegeni ensele are nali wolume Paielule nifeneke Abrahamele wofetanelu nalimeme wane. Te Lote rilanei fetateleefe esulu furaleleeke walee. Tetoo nali paielu lufwale atelananelu atukwe tupu sunetalali, ");
INSERT INTO kwo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","te natelee, “Oone weife lufwa paielu, tefe oone weife riebu menanoo iteile. Bie oone weife kuli melee suwananetemoke tetoo nia ifeluemofe nianoo itei, tetoo sabei kwotue krieime wabule.” Te fune nafoone, “Mwa, mene weifekoe teime eetei lukulelananelu tekoi luerife lelane.” ");
INSERT INTO kwo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mwa. Lote metie kaiseklime letelee kame neunateleeke ifwatelee nalilu iteile. Te nalilu amee amee lufwale nafoleeke, te nanoo tabe foflilule tupwateleeke, te fori yesou wolilule mumusi leteleeke, te weife foopoolane. ");
INSERT INTO kwo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Te ame lueri preme lelaneime tetoo Sodomefu lufwa maretekume rineke eetei luerife lelanelu itele fwai nalefoone, lufwasekli lufwatu rawielu lufwatume. ");
INSERT INTO kwo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Te Lotele fieri nafoone, “Ekepane oonanoo itei luerife neunatelulu lufwa ekei pe lalane? Nateluke riebi mene nembulu amee ifaterife.” ");
INSERT INTO kwo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Te Lote amblenile oorapoleeke, boe amwime kafieleeke, ");
INSERT INTO kwo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","te natelee, “Oone bie menanoo nale fiewobu. Oone mareteku eete lelamolu amee glei wolilu ameele lelamo. Eesalu amee lebule mani, mwa.” ");
INSERT INTO kwo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Te natelee, “Nianoo auteli ramulu are eetetie lalane. Lufwa bofoo glei angime nembulu amee ifatelanei, mwa. Bie mene ite menefule neunatieke sinatemofe, tetoo kame oonanoo menengutu ifafwatebu. Tupane lufwa rineke menanoo itei lulanelufe tefe regi letelaie. Tefe oone kose bofoo amee letebule mani.” ");
INSERT INTO kwo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Eetegeni nale fiefoonelufe tetoo fune nafoone, “Bie menane usiale, ekeni lufwakoe fime bofoo wokoofu kame menanoo wokoo ootutufe wari alaleelu. Oone bie usiale. Oone usialeri preme lelu, eetete mene oonane glei ooloome lemobile.” Te Lotele amblenime puletewanei, te ambleni mwee metie titiki naporife lenelu. ");
INSERT INTO kwo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mwa. Tupane weife Lotele beleneke meneile glitewaneke, te amblenile katu kafine. ");
INSERT INTO kwo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Te weife lufwalu oole mareteku wifumolutu leteneke mumu apoolanei amblenile fetarife gigime letelee. ");
INSERT INTO kwo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Te weife Lotele nafoone, “Eetegeni wokoo nanoo glei wolilu ameele alanane, mwa. Tefe Paielu menane weife neleeke rine, eetegeni wokoo soulule teieforife.” Te nafoone, “Oonanoo poritefu telu ake lalabile, eetegeni wokoo soulufi? Wonepaitane, wolualiane kaporane, oonariemu marememe neunateluke eetegeni wokoole afetelime grialemoke wabu. Mene weife eetegeni wokoo soulule metie teieforife lelane. Paielu nali, eetegeni wokoofu inalilufwalu fwagilu amee alananelu na ulule ange fiemeleefe, tefe rine eetegeni wokoo soulule teieforife.” ");
INSERT INTO kwo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Te Lote nepaitanele naterife walee, lualianele peeneforife lelanelu lufwale. Te natelee, “Eetegeni wokoole grialebu. Paielu wokoo soulule metie teieforife lelalee.” Mwa. Nanoo weife menengu lene, nanookoe usikefe pai nelalee. ");
INSERT INTO kwo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Te oo wolu mare taki nalelaleefe, tefe Paielulu ensele Lotele noopoo nafoone eetegeni wokoole afeteli grialerife. Te nafoone, “Oone oonariemule wolualianele neunateluke eetegeni wokoole afetelime grialemoke wabu. Oone mei kose tupane marememe nembuari lebule.” ");
INSERT INTO kwo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lote metie ame menengu aipoe aipoe lelaleefe, tefe ame wari preme lelalee. Te Paielu metie Lotele keemakee lefolee, tefe nalilu ensele nanoolu ameele, te nariemulu ameele, lualianelu ameele tukwe bebenateneke ambolufile ifwatene. ");
INSERT INTO kwo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Te ifwateneke, te ensele bofoo natelee, “Sei! Oone mei kose nembuari lebule, oonanoo ree kekritife brunalebu, boe kose aikoemwi lebule mani, mwa. Tetoo afoi mei wokoo prifi kose yenalebule mani, eetekoe oone mei kose mare nembuari lebule. Sei, afune mwaileme kuli mwai lebu.” ");
INSERT INTO kwo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Te Lote nafolee, “Paielu, oone menane metie keemakee lewoluke wolilu ameele lewolu, tefe mene tafilari preme lie. Mwa, oone wokoole teiefoolalu mene afuneile glei afeteli kuli mwai lieke wosekalefe, mwa. Metie mokeneime oolalalee. Eetete mene ame walaieme afoi kose nembuari lefe. ");
INSERT INTO kwo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Bie oone eeteme oowa, ekeni wokoo tukweelule feta. Eetete roboi lalalee, mene ekei afeteli woseka lefe. Tetoo mene glei nembuari lefe.” ");
INSERT INTO kwo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Te Paielulu ensele Lotele nafolee, “Nembouo! Mene ekeni wokoole glei teiefofe, mwa. ");
INSERT INTO kwo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Sei! Bie afeteli kuli mwaile. Mene ekeni wokoole glei amee glieforife lelaie, mwa. Bie oone ekeni wokoo tukweelufi woseka leluke, tetoo mene teiefofe.” (Tefe ekeni wokoo bilu Soare nafoone.) ");
INSERT INTO kwo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Te Lote Soare wokei lie wolu mwai botemelali woseka lelee. ");
INSERT INTO kwo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tetoo Paielu Sodomele tukwe Gomorale tukwe i tefoo ti asalule lie meneime bofina letelee. ");
INSERT INTO kwo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Eetegeni amee leleeke wokoo soulu are metie teietelee, eetegeni wokoo prile mei, te wokoo arelefu inalilufwa mareteku mei, inengoi serinelananelu yesoutume mareteku troonalene. ");
INSERT INTO kwo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Te Lote nariemu aikoemwi leleelu, mwa, metie tife leleeke temelalee. ");
INSERT INTO kwo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Te kwotue krieime Abrahame furaleleeke nali weife Paielutu eetei temepoomenelu tekoile boe walee. ");
INSERT INTO kwo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Te Abrahame Sodomelu Gomoralu wokoo prime weeyereleeke oofwanepoleelu, wifulu metie aiyeaiye apoolanei fetatelee. ");
INSERT INTO kwo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Eetete Gote eetegeni wokoo soulu are wokoo prifule teieterife lelali, te Abrahamelufe Lotele wolu Sodomefule neuneleeke ifwali, tetoo nanoolu mwi teiefolee. ");
INSERT INTO kwo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Te Lote nanoo Soare wokei lalarife wofri leleefe, tefe lualianele neunateleeke afuneme peepee ifenateleeke te timenee menei ifelatemelee. ");
INSERT INTO kwo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Bofoo lietu yafee nali moole nafolee, “Aie wolu lufwasekli lerife lelalee, te eeteise mei lufwa bofoo glei lalane, tetoo menafe weife peenerife ute bebriefe aferilanelu amee atukwe. ");
INSERT INTO kwo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Sei! Bie mena aiele wainele fanebile, tetoo foleeke, ifeluneke tetoo ari aielufime weenetewalabile, kose tabe atukwe oolaielutu bwalebe.” ");
INSERT INTO kwo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Te ekeni krietume lualiane wainele faneneke te yafee nali molukwe ifeluwolee. Te yari mei glei rame lelee luali selilu waleeke ifeluwoleeke furaleleelule. ");
INSERT INTO kwo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Te bofoo lietu yafee moole nafolee, “Morietu kriei mene weife wolu lune, te boe nembue mei mene weife ame wainele faneneke, tetoo oone waluke weife luwobu. Tetoo menanoo aielu arifi weenetewalabile.” ");
INSERT INTO kwo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tefe weife yarile wainele faneneke folee, ekeni krietume tetoo moo mei weife lune. Yari boe glei rame lefalelee, luali tukweelu waleeke ifeluwoleeke furaleleelule. ");
INSERT INTO kwo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tefe yarilufime lualiane are arietu lelane. ");
INSERT INTO kwo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yafee ari kaporele lupoleleeke, te bilu Moape nafolee, nanoo nembue Moapelu nambue. ");
INSERT INTO kwo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Te moo mei ari kaporeleme lupoleleeke, te bilu Benami nafolee, te nanoo mei Amonelu nambue. ");
INSERT INTO kwo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahame Mamrele grialeleeke, te boe Negeve porite amee waleelu, bofoo wokoo Kadesetu Suretu lalanelu babi babime oolalalee. Sabei tetoo Gerare wokei oolalarife walee. ");
INSERT INTO kwo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ekeni wokei tetoo Abrahame nariemu Sarale tutulefe, “Sara nianoo wofoli” natelee, tefe Abimeleke nalilu amee amee lufwale nateleeke waneke, te Sarale neuneneke ifwafoone. Abimeleke ekeni wokei kinefe leteleeke latelaleelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mwa. Bofoo krietu Gote Abimelekele rarauetu fwarinelali nafolee, “Oonekoe oona tafilarilu afweele oorapoolalu oone eke neunelulu inalikoe lufwa tefoo.” ");
INSERT INTO kwo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Te Abimeleke Sarale ame reti glei belelalee, mwa. Tefe nelee, “Paielu, lufwa ame fwagilu amee bofoo leri preme lelaleelule nemboue pe ame teiefole nalilu inalilufwatume? ");
INSERT INTO kwo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Eetetie Abrahame nali nariemulefe nawolee, ‘Nanoo nianoo wofoli.’ Te nariemu Sara mei same nunguli Abrahamelufe nawolee, ‘Nanoo nianoo raroo.’ Tefe mene nanoolu nariemule neunelaiei nie, menekoe wolilu ameele pai lelaie. Tefe mene glei fwagilu ameele lie. Mwa.” ");
INSERT INTO kwo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Te boe Gote fune rarauetu Abimelekele fwarinelali nafolee, “Marena. Nia wolu rame lewie, oone wolilu ameefe neunelu, tefe nia oonane menengu wolilule fanewieke tetoo oone glei bofoo amee lefolu, mwa. Mwa tete oone fwagilu amee menanoo oofi lerife lelulu. ");
INSERT INTO kwo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Boe nariemule ifwafoe Abrahamele nanoo nianoo ragoofu nale alipoolaleelu lufwa ame oonane aikopi lewoleeke, tetoo oone glei tafilale. Oone ifwafori preme lelu, tete oona ifatelalulu inalilufwatume mare troonalebule.” ");
INSERT INTO kwo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Te kwotue krieime Abimeleke nalilu ipoelu lufwale maretekume nateleeke, te Paielu nali rarauetu fwarinelali nafoleelu nale alipotelee. Te tupane metie wofri lene. ");
INSERT INTO kwo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Te Abimeleke Abrahamele fieri nafoleeke, te nafolee, “Ooneboe menane glelu ameefe eese lewolu, meneboe oonane akeke lewielufe, tefe oone eesalu ameele lewolu, eetegeni glei wolilu amee. Tefe mene nia ifatelaielu inalilufwatu mare eetegeni fwagilu ameefe ritilu falelane.” ");
INSERT INTO kwo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Te nafolee, “Oone glefe eese lelu?” ");
INSERT INTO kwo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Te Abrahame fune nafolee, “Menekoe nie. Eetegeni wokoofu pane Gotele glei pai wofri lefoonane. Kose nanoo menanoo inalife menane teiewobile nie. ");
INSERT INTO kwo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tefe marena, Sarakoe menanoo wofoli, te mwamole aie, te mileme fime fime anelufe, tefe mene falie. ");
INSERT INTO kwo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Te Gote nawoli, aielu itele grialieke bofoofile wari wariefe waiei, mene Sarale nafwie, ‘Oone menane wolilu amee lewofe nelu, tetoo mene weife akeme akeme wanei, oone inalilufwale natelua, “Abrahame nanoo menanoo raroo.” ’ ” ");
INSERT INTO kwo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Te Abimeleke Sarale boe Abrahamele sinafoolali, bole ameflee sipsipele, bulmakaule, nalife amee amee afoolananelu inalilufwale tukwe nifwalee. ");
INSERT INTO kwo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Te Abrahamele nafolee, “Feta, eetegeni inengu eete lafwaleelu maretekume menanoo. Tefe oona glelu porite amee oolalafe nelu eete nemboue, tetoo waluke ekei oolala.” ");
INSERT INTO kwo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimeleke Sarale nafolee, “Mene oonanoo raroole silva bwalee 1,000 fanie, oonane eete lewoleelu fwagilu amee ritilule sere lerife.” ");
INSERT INTO kwo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Paielu Abimelekelu itefu inali mareteku ari teriporife glei i natelee. Paielu eese leteleelu, Abimeleke nali Abrahamelu nariemule neunelee, nalife falerife. Tefe Abrahame Paielule na woponefoleeke, tetoo Abimeleke nemboue lelee. Te Abimelekelu nariemule, nalilu itefu inalile ari teriporife boe i natelee. ");
INSERT INTO kwo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Te Paielu Sarale boe rieleeke fetalee wolume nali nasi lefoolali nafoleelu ameeleme lefolee. ");
INSERT INTO kwo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Te Abrahame wolu mare lufwasekli lelali, tetoo Sara ari kaporele teriefoleeke lupolefolee, Paielu nali Abrahamele wolume nasi lefoolali namunefoleelu krietume. ");
INSERT INTO kwo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Te Abrahame lefoole bilu Aiseke nafolee. ");
INSERT INTO kwo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Te lupoleleelu krie wolu tialoo are lelali tetoo Aisekelu ree leeloole tekalefolee, Gote nali nateleeke nifelanelu amee atukweme lefoone. ");
INSERT INTO kwo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sara Aisekele tetoo lupolelee, Abrahame yare wolu 100 lefoolali. ");
INSERT INTO kwo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Te Sara nalife nelee, “Mene metie paie paie alaiei yeufe tafile tafile alaie, Gote nali amwi sere lewoleefe. Tefe inalilufwa mareteku eetegenile fineke ame mare paie paie apoofwalabile.” ");
INSERT INTO kwo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Te boe nungulilufe mei nafolee, “Bebriefe lufwa bofoo ine Abrahamele nafolee, ‘Oonanoo inali ame ari lupoleleeke, tetoo totoole fofoolabe.’ Mwa. Nanookoe wolu mare lufwasekli lelalime mene ari kaporele lupolefwie.” ");
INSERT INTO kwo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Te Aiseke wolu totoo grialeleeke warialalee, tetoo eetegeni lietu yari kakali selilule ifelelee. ");
INSERT INTO kwo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ismaele Abrahamelu lefoo bofoo, Hagare Isipefu inali lupolefoleelu ari, Aisekele eeneri na nafoolali Sara fiefolee. ");
INSERT INTO kwo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tefe nungulile nafolee, “Oone nembueme ekeni amee amee alaleealeelu inalile lefootu nateluke wabi, bofoo ariefu ari glei oonanoo gugulule faleleeke lalabe, mwa, te oonanoo yesou mei mwa, glei menanoo arilu yesoule tukwe peenebe. Eetegeni yesou mareteku nianoo ari Aisekelu.” ");
INSERT INTO kwo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tefe Abrahamelu menengu metie glei amwi lafiefoolalee, mwa. Ismaele mei Abrahamelu lefoo lalalee. ");
INSERT INTO kwo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tefe Paielu Abrahamele nafolee, “Abrahame, oone kose Hagare weife lefootu menengu are letelale mani. Oone kame Saralu menenguleme nife. Oonambuanelufu ari, ari lelaleelu eetete Aisekelufu ari. ");
INSERT INTO kwo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Te oonafe amee amee lemomeleelu inalilu ari mei ame nia amwi amee sere sere lefwieke tetoo wokoo soulu faleneke alabile. Nanoolu ari mei oonanoo fweelu.” ");
INSERT INTO kwo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Te kwotue krieime Abrahame fori yesoule peenelee, meme leelootu meleele rifeleeke, te Hagarele nifwaleelu sulu lefoole sinafoleeke, weife wane. Te waleeke pepelu inengoi teme teme amelee Bersebalu wokoo porite. ");
INSERT INTO kwo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Melee meme leeloofu soonalenelufe, tefe Hagare lefoo Ismaelele ifwaleeke, te ka tukweelu ambei grialelee. ");
INSERT INTO kwo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Te nali waleeke ee fieri pike oolafieleeke, oolalalee. Nanoo lefoo Ismaele tafilafoolali fetalarife ulabee neleeke, tefe waleelu oolafieleeke eeleme wonelalee. ");
INSERT INTO kwo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Tetoo Paielu Ismaele ee nelaleelu eele fiefoleeke, te nalilu ensele efenefu yefeele eesalu fiefori lelee, “Hagare. Oone kose wofri lele mani. Gote nali oonanoo arilu eele wolu fiefolee. ");
INSERT INTO kwo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tefe waluke oonanoo arile boletaluke, te amei beleluke ifwa, mene ame nanoolu arile amwi letieke, te ekepanelu nambuanelufu ari neembee ame weenetewabile.” ");
INSERT INTO kwo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Gote nali Hagarele gugu meleele fetou nelee. Tetoo worifeleeke lefoole tewafoleeke, te faneleeke folee. ");
INSERT INTO kwo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Te Ismaele seli letakomoolali Gote nali amwime aikopi letewafoolalee. Nanookoe pepelu inengoi lameli, te metie wopi nungunanerilu ameele amwime yefee lefolee. ");
INSERT INTO kwo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ismaele ame teime Paranefu pepelu inengoi lameli, tetoo yefee Hagare waleeke Isipefu inali bofoole neunafoleeke iferiefolee. ");
INSERT INTO kwo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ekeni krietu Abimeleke weife Fikoletu, kworoofame alananelu lufwale nambuletelaleealeelutu, weife waneke, Abrahamele oonafoone, “Gle gle ameele lelalulule Gote nali metie oonane amwime aikopi lewoleealee. ");
INSERT INTO kwo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Oone nembue menane, nianoo arile tukwe, nianoo ambuanelufu arile tukwe, nasi amwime lewo nembueme Gotelu oofi oone kose, kose kosefe nawole mani. Mwa. Nia oonane wolilu amee lewielu atukwe, oone mei same menane wolilu ameeleme lewo, eetegeni inengu monguelufi rieluke lalalulu inengufu inalilufwale mei eesalu ameeleme letela.” ");
INSERT INTO kwo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Te Abrahame nafolee, “Mene oonane nemboue lewofe.” ");
INSERT INTO kwo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tefe Abrahame ame Abimelekele na bofoo ame naforife lelalee. Abrahamelu gugu meleele Abimelekele amee amee afoolanelu lufwa nanoo nalife fame ifeleneke ifelalanelufe. ");
INSERT INTO kwo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tetoo Abimeleke nafolee, “Mene glei rame lie eetegeni yesou ine lelee. Oone menane glei nawolu, menane nembueme naoolalu rame lelaie eetegeni yesoufe.” ");
INSERT INTO kwo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tefe Abrahame bole ameflee sipsipele, bulmakaule iferieteleeke te Abimelekele nifwalee, tetoo weife nasi amwi lerife. ");
INSERT INTO kwo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Te Abrahame sipsipe sitefule tialoo mwamole woleleeke, te fime kwaife ifwatefolee. ");
INSERT INTO kwo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleke Abrahamele fiefolee, “Oone glelu yewilufe sipsipe sitefuleme tialoo mwamole leluke fime kwaife iferietewolu?” ");
INSERT INTO kwo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Te Abrahame nafolee, “Oone kame neunate, eetegeni bole ameflee sipsipe sitefule menanoo amefu tialoo mwamole nifwaoolaielu tetoo oone menane eese naworife, ‘Marena, eetegeni gugu meleele oona puelulu’ naworife. ” ");
INSERT INTO kwo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Te weife eesalu amee lenelufe, tefe ekeni tekoole Berseba nafoolane. ");
INSERT INTO kwo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Te weife eetegeni ameele Bersebai lelaneke, tetoo Abimeleke Fikoletu, nanoo kworoofame alananelu lufwale nambuletelalee aleelu lufwatu, boe mare wane, Filistialu inengu porite. ");
INSERT INTO kwo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Tetoo Abrahame ka bofoole Bersebai frelelee, tetoo ekeni tekoi na woponefolee Paielule, nali Same Lafwalarife Lelaleelu Gote. ");
INSERT INTO kwo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Te Abrahame Filistialu inengoi lameli wosi teime soo lemelee. ");
INSERT INTO kwo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bofootu, Gote Abrahamelu menengule, tetoo rame leforife popoi lefolee. Te bilu rufofoleeke nafolee, “Abrahame!” Te Abrahame, “Wa” nafoleeke, nafolee, “Mene eete fieoolaie.” ");
INSERT INTO kwo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Te nafolee, “Oone ari kapore mwamole ifalalu oonanoo fweelu Aisekele neuneluke Morialu porite ifwa afune tupulu bofoo ame fetou nawofe, tetoo ekeise menane Aisekele fanewo, ifi bofatieluke, isokwi bri lebee.” ");
INSERT INTO kwo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Te lufereleeke kwotukrieime furaleleelu sulu donkile mumusi leleeke, te berefule ateleeke tetoo lefoo Aisekele neunelee, nalilu amee amee lufwa are neunatelee te eese leleeke ifwatelee Gote nafoleelu porite. ");
INSERT INTO kwo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Te afoi rofoo are leleeke te mwangifelu lietu Abrahame oowaleelu fetalee, nafoleelu tekoo ame mokeneime oolalalee. ");
INSERT INTO kwo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Te nali ifwateleelu amee amee lufwale natelee, “Oone teime eetei lalamoi donkile ifelalabu, mene nianoo aritu waneke Paielule reeyemee lefooneke boe ame riebile.” ");
INSERT INTO kwo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Te nateleeke berefu donki mwafule faleleeke lefoo Aisekele fanelee, te nali pisoole itu peenelee. Te weife walanei afoi, ");
INSERT INTO kwo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","lefoo yarile fiefolee, “Aie!” Te yari “Wa!” nafoleeke te nafolee, “Sei, glesou?” Te nafolee, “Aie feta! Mena berefutu itu wolu, tetoo sipsipe kapuluboe akei, tetoo ifi tuneke isokwi bri leforife?” ");
INSERT INTO kwo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Te lefoole nafolee, “Aria! Ame Gote nali ekeni yesoule tinebe, tetoo ifi tuneke, isokwi bri leforife.” ");
INSERT INTO kwo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Te weife Gote nafoleelufi kuruwoleneke te yari eetei tueri ilekulile titu rigani letakumoleeke, te berefule tepumwai soone soone atelee. Te lefoole mweetu kuliamee bulupofoleeke te berefu pumwai soonalelee. ");
INSERT INTO kwo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Te Abrahame amee feenetewaleeke pisoole faleleeke, te borei frelerife lelali, ");
INSERT INTO kwo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","tetoo Paielulu ensele efenefu fieri nafolee, “Abrahame, Abrahame!” ");
INSERT INTO kwo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Te Abrahame “Wa” nafoleeke, nafolee, “Mene eete!” Te nafolee, “Oone kose oonanoo arile borei teka lele mani, tetoo kose bofoo amee lefole mani, mwa! Oone oonanoo ari kapore mwamole ipoe menane faneworife fetaoolaielu glei keningi ifelelufe, tefe nembueme wolu rame lie, oone menane metie wofri leoolalu reeyemee leoolalualu.” ");
INSERT INTO kwo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Te Abrahame ipoe boletaleeke oofwaneleelu te fetalee nalilu fime porite sipsipe kabine yeielu leblilufi gwalefoleeke lalalee. Tetoo waleeke beleleeke iferielee Gotele fanerife. Te borei teka leleeke, ifi tueleeke maretekume isokwi bri lelee. Eetegeni sipsipe lefoo Aisekelu gugulule falefolee. ");
INSERT INTO kwo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Te Abrahame ekeni tekoole nafolee, “Paielu Nali Fanebe” nafolee. Tetoo nembue mei inalilufwa same nafoolanane, “Paielulu afune tupulu mwai fanebe.” ");
INSERT INTO kwo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Te Paielulu ensele efenei Abrahamele boe fieri nafoleeke, ");
INSERT INTO kwo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","te nafolee, “Oone ekeni amee lelufe tetoo ari kapore oonanoo mwamole ipoe glei keningi ifelelu menane faneworife, mwa, tefe Gote nelee, ‘Mene nia nianoo bilutu marenafe naoolaie, ");
INSERT INTO kwo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ame nia amwime lewofe tetoo oonambuanelufu ari metie motukwe lelanei, tetoo wafene atukwe, limwafu atukwe lebile. Te eetupane kworootu aleri alananelu panele ame buruanaleteneke tetoo nanoolu wokei laprufwabile. ");
INSERT INTO kwo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Oonambuanelufu arifime tetoo mene ame inalilufwale mareteku te wokoo te wokoofule amwime letelafe. Eete oona menanoo nale fieluke nifewolufe.’ ” ");
INSERT INTO kwo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Te Abrahame nali ifwateleelu amee amee lufwa are lalanelufile lefootu waneke, tetoo boe Bersebaile wane. Te Abrahame teime Bersebai amelee. ");
INSERT INTO kwo_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Bebriefe feti Israelefu inalilufwa ame yefeelu lufwalu amei lalanei tetoo nambwi lie sekaleteleefe, tefe inalilufwa metie gifefe troone troone alane. Te lufwa bofoo Judafu Betleheme wokei lalalee, te nariemutu ari kapore are Moapeme waneke te teime lamene. ");
INSERT INTO kwo_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Eetegeni lufwalu bilu Elimeleke, te nariemulu bilu Naomi, te lefoo are bilu bofoo Malone, te bofoo Kilione. Tupane Efratalu weeluane nanoo Judafu Betleheme wokei lamene. Te Moapelu inengoi waneke lamene. ");
INSERT INTO kwo_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Tetoo eeteise Elimeleke, Naomilu nunguli, tafilalee, te nembue yefee nalime lefooane are ifelatelalee. ");
INSERT INTO kwo_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Sabei nanoolu ari Moapefu inalile peenene. Te tupanelu nariemuanelu bilu bofoo Rute te bofoo Orpa. Te teime lamenei yare yarilutu yarilutu letelee. ");
INSERT INTO kwo_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mwa, Malonetu Kilionetu mei teimeme troonalene. Tefe nembue Naomi nalime lalalee. ");
INSERT INTO kwo_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Te Naomi teime lalali, Israelefu nale fielee, Paielu wolu klomwee liele fanetelee tefe fori yesou balifule foopoolanelufe, tefe Naomi lefoo tarilu seikolu inali are mare Moapefu warife lelane. ");
INSERT INTO kwo_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Te grialeneke, Naomi seikolu inali are Judafu inengoile ifwaterife. ");
INSERT INTO kwo_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Mwa, Naomi tupane inalile natelalee, “Oone boe oonanoo mianelu iteile wamoke, te mare oolalabu. Oone weife menane tukwe te tupane lufwa troonanelule tukwe nembouelu amee lepomoome. Tefe Paielu mei oonane ame sameme eesalu ameele lemobe. ");
INSERT INTO kwo_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Tefe Paielu nalime oonane aikopi lemobe tetoo oone weife ame lufwa boe peenemoi tetoo amwime lalabule.” Tetoo Naomi eeteise fwakee fwakee atelaleeke te nanoo mareteku metie ee napoomeneke, ");
INSERT INTO kwo_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","te Naomile nafoone, “Mwa. Mene oonetu oonanoo weeluanelufile ifwapo.” ");
INSERT INTO kwo_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Te Naomi natelee, “Nemboue oone weife oonanoo wokeile boe wabu. Boleboe glefe oone weife menane nifeworife? Meneboe nembue pe ari kaporele are boe luponuieke tetoo boe peenemobile? Mwa. ");
INSERT INTO kwo_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Tefe oone weife oonanoo wokeile wabu. Mene wolu inasekli lie boe glei lufwa falieke, tetoo boe ari lefe. Mwa. Eete mei nembue eesalutu boe lufwa bofoole eetegeni kriei falieke te ari luponuiei, ");
INSERT INTO kwo_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","oone weife glei ooletemoomeke selime lenei peenebule. Tetoo oone weife kame eese lemoke lalabule pai? Mwa, menanoo auteli, mene metie yau tafwaile fwieke tefwee leoolaleelu atukwe menane Paielu eesalu amee lewolee, tefe oone weife menane kose nifewobule mani.” ");
INSERT INTO kwo_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Tetoo weife Rutetu Orpatu boe metie eeleme nefalene. Te Orpa Naomile fwafwakee ifaleeke, te Rute mwa, Naomilu amei beletameli tekeneime lefoolalee. ");
INSERT INTO kwo_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Tefe Naomi Rutele nafolee, “Bie feta, oonanoo womoo nalilu weeluanelufile, te nalilu nambuanelu gotelufile walali, te oone mei weife wabu.” ");
INSERT INTO kwo_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Mwa, Rute boe nafolee, “Oone kose mene oonane grialeworife nawole mani, te oone kose menane ble nawole mani oonetu warife. Eetegeni wokoo oone walalulu mene mei ame wafe. Te eetegeni wokoo oone lalalulu mei mene ame lalafe. Oonanoo weelu ame menanoo weelufe lebile te oonanoo Gote ame menanoo Gotefe lebe. ");
INSERT INTO kwo_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Oone tafilaluke eetei fatieworife lelanelu tekoi mei menane mei nemboue eetegeni tekoi fatiewobile. Mwa, mene oonetu weife tafilufime tetoo oone fime mene fime abile. Mene bi nelaie, nianoo nale mareteku nifeteri preme liei, Paielu nanoo menane metie teieworime lebe.” ");
INSERT INTO kwo_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi Rutele fetaleelu nanoo weife warife tekeneime lefoolalee, tefe na nerilu mwa. ");
INSERT INTO kwo_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Te weife Betlehemeile waneke, kuruwolelanei inalilufwa mareteku metie na nafwafoone. Te inali nene, “Eetekoe Naomi pai?” ");
INSERT INTO kwo_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Te Naomi natelee, “Oone menane kose Naomi nawobule mani, mwa. Kaiseklilu Same Lafwalarilu Gote menane glei amwi lemolee, tefe oone menane Mara nawobu. ");
INSERT INTO kwo_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Mene eetegeni wokoofu paie paietu waielu te nembue Paielu menane reelufe iferiewolee. Mwa. Tefe boleboe glefe oone menane menengu mutukwe naoomo? Mwa. Kaiseklilu Same Lafwalarilu Gote menane na pume naoolalee, tefe metie ritilu fanewoleefe, tefe tafwai tefweelu atukwe lewolee.” ");
INSERT INTO kwo_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Naomi weife Rutetu rinelu, eetegeni Moapefu lualikelu. Betlehemei barli ooloo wi lepoolanei, nembuame kreenapoolanelu lietume weife kuruwolene. ");
INSERT INTO kwo_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Wolume Naomi Elimelekele falelee. Te Boase, Elimeleke mare mwamole tabe oolaielufu, nanoo yesou pumwai lalaleelu tefoo, ramelu tefoo lufwafe lelee. ");
INSERT INTO kwo_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Te Moapefu Rute Naomile nafolee, “Mene balifile wafe pe? Barli ooloo wilume letewane, te balifi amee amee alananelu pane barlile krinapoofwalanei, te mene yekuru nafwanelule plee nafwaterife walaie. Tupane lufwa menane seinaoonei, tetoo mene nifetefe.” Te Naomi nafolee, “We, aite nemboue wa.” ");
INSERT INTO kwo_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Te Rute waleeke, tupane barli ooloole amee amee alananelu pane nambuleooneke walanei te fime walali plee nafwatelee. Rute glei rame lefolee, eetegeni bali Boaselule, Elimeleke mare mwamole tabe oolaielufu lufwa. ");
INSERT INTO kwo_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Te nembue Boase Betlehemefu nalilu balifile rieleeke, te amee amee alananelu panele natelee, “Paielu nemboue oonane mare ifelamoolabe.” Te fune nafoone, “Paielu nemboue oonane aikopi lewobe.” ");
INSERT INTO kwo_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Tetoo Boase nalilu balifi nambuletelaleealeelu lufwale nafolee, “Eetegeni inali ramulu boleboe akenifu?” ");
INSERT INTO kwo_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Te ekeni lufwa fune nafolee, “Eetegeni inali ramulu Moapefu, Naomitu Moape inengule grialeneke, rinelu. ");
INSERT INTO kwo_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Nali menane fiewolee, balifi amee amee alananelu panele nifeterife nawolee, tetoo fime barli kalu tomelule plee nafwaterife. Nanoo kwotue lietu amee amee lelaleeke, te itei yenepoleleeke, te boe furaleleeke amee amee wolelalee.” ");
INSERT INTO kwo_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Te Boase Rutele nafolee, “Aite, bie fie. Oone kose lufwa bofoolu balifu barli kalu tomelule plee natelaluale mani. Mwa. Oone eeteime lalalu, tetoo tupane inali ramulu mare menanoo balifi amee amee lelabu. ");
INSERT INTO kwo_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Akeni bali tupulule tupane boalelanelule fetatelu tetoo nifetewatelua. Mene lufwale wolu natie oonane glei ameefwa nalewobile. Mwa. Te oona boru fooroonalewoli, lufwa bulue bogumweetu meleele rifeneke fatinelu genile, waluke wofoe.” ");
INSERT INTO kwo_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Te Rute tumoinu krutupoleeke, rugunalelalee, keree inengoi fatieleeke te Boasele nafolee, “Mene rawie inali, glefe oone menane fetawoluke, keemakee lewolu?” ");
INSERT INTO kwo_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Te Boase fune nafolee, “Menanete wolu naoone, oonanoo suguli tafilaleeke tetoo mikelule nembouelu ameele fetou nafoomelu. Oone oonanoo miele, aiele, wokoole tukwe wogrialeteluke, te oone rawie inalilufwalufu rieluke lalalu, bebriefe oone rame leteri preme lelulu panelufi. ");
INSERT INTO kwo_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Tefe Paielu oonanoo nembouelu amee wolu rame lewolee, te nali nemboue oonane sasenee yesou fune wolilule mareteku nifwawobee. Oone wolu Paielufile rielu, nali Israelelu Gote, oone nalilu tukwia ambei lalalu tetoo nalimeme amwime oofulineoolabe.” ");
INSERT INTO kwo_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Te Rute Boasele fune nafolee, “Oone menane metie wolilu ameele lewolu, mene glei oonanoo amee amee inali, mwa. Oone menane kame na tafilutu nawolu. Eetegenife oone menane kame melee petilu atukwe sunanewolu.” ");
INSERT INTO kwo_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Te fori yesou fooporife yenalelanei, te Boase Rutele nafolee, “Oone eeteme rie, te tabe bofoo faleluke, wainei pieleluke, te foe.” Tefe Rute tupane inalilufwalu bwagei mare laprueleneke lalanei, te Boase telu barli ooloo i frulule nifwalee. Rute fopoleeke yelu lefoleefe te telu lualee. ");
INSERT INTO kwo_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Te Rute wolu furaleleeke barli kalu tome boe plee nafwaterife lelali, tetoo Boase balifi amee amee alananelu panele natelee, “Eke bulupoofwamoke luamolufi ekeise nemboue plee natelabee, tetoo kose ble nafobule mani, mwa. ");
INSERT INTO kwo_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ekeni mei, bulupoolamolu kalu tome telule gliapomoke teime grialetebu tetoo plee naferietebe. Oone kose ble nafobule mani, mwa.” ");
INSERT INTO kwo_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Te Rute teime eetegeni balifime barli kalu tomelule plee naferieteleeke te lie wolu ambei yetemelee. Tetoo kalu tome katu tainepoofwaleeke, barli ooloole yekuru nenelu genile plee nateleeke, eetegeni barli ooloo ritilu 10 kg atukwe lelee. ");
INSERT INTO kwo_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Rute buluele arueleeke, wokeile tewalee. Te yefeekelu Rute terielaleefe fetalalee. Te telu liei fopoleeke yelu lefoleefe lualeelu eetele faleleeke yefeekelule fanelee. ");
INSERT INTO kwo_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tefe Naomi Rutele nafolee, “Ooneboe nembue barli ooloo glefuleme plee natelu? Inelu balifule? Te Paielu eetegeni lufwa oonane aikopi lewoleelule nemboue aikopi lefoolabe.” Te Rute Naomile fune nafolee, “Menekoe Boase nafoonelu lufwalu balifi amieke rie.” ");
INSERT INTO kwo_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Te Naomi lualile nafolee, “Paielu Boasele nemboue aikopi lefoolabe, inepane oofulilu lalanelu, te inepane troonalenelu mei menengu ruforitu letelaleealee.” Te boe nafolee, “Ekeni lufwa nanookoe mwamole tabe oolaielufu, tefe ilekuli groo lerife lelaleelu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Te Rute Naomile nafolee, “Boase menane na bofoo nawolee, ‘Oone menanoo balifi amee amee alananelu pane mare alabu, barlitu witetu tatukweme plee nafwatemoke te soonaletebu.’ ” ");
INSERT INTO kwo_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Te Naomi Rutele nafolee, “Aite, nemboue oone Boaselu balifi amee amee alananelu inali mare alabu. Kose oonane bofoo lufwalu balifi teiewobile.” ");
INSERT INTO kwo_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Tefe Rute nanoolu inali ramulule nifetewatelee, barli ooloole, wite ooloole Boaselu balifuleme afwatelaneime wolu soonaletene. Te Rute ame yefeekelutu lalane. ");
INSERT INTO kwo_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Naomi lualikelu Rutele nafolee, “Aitea, niame ame lufwa woliluleme amwi oorafwieke, tetoo oone falele pe? Oonanoo lafierilu tetoo amwi feti lewobe. ");
INSERT INTO kwo_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Eetegeni lufwa Boase, ute oona nalilu balifi inali mare amee amee afoomoomelu, nanookoe menanoo mwamole oolaielufu. Fie, nembue kriei barli ooloo yekuru nelanei atelanelu tekoi amee amee wolerife lelalee. ");
INSERT INTO kwo_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Tefe melee rofoluke te nemboue seralule reefi buleteluke, te wamolulu leeloole sineluke, tetoo amee amee alarilu tekoile tirale. Oone kose oo lebati lefole mani, kose fetawobe. Tefe kame fetalalu, bie kakali lelee waine folee lebee. ");
INSERT INTO kwo_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Te eetei luerife lelaleelu reeafweele amwime fetala. Tetoo pitukoeme waluke, nalilu bebeti leeloo soulu kulika porite kuraleluke, te kulikai lue. Te sabei nali ame oonane na nawobe.” ");
INSERT INTO kwo_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Te Rute fune nafolee, “Nemboue eke nafwawolulu na mene ame nifefe.” ");
INSERT INTO kwo_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Te Rute barli ooloo yekuru nelanei atelananelu tekoile tiralelee, Naomilu naleme nifelee. ");
INSERT INTO kwo_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Te Boase wolu fori yesou foleeke, nanoolu menengu mutukwe lefoleeke, te rofoo lefoleefe waleeke, barli ooloo lukuletelanelu bwagei lulalee. Te Rute lulali fetaleefe, te pitukoememe waleeke, bebeti leeloo soulu kulika poritefule kuralefoleeke, tetoo Boaselu kulika porite luelee. ");
INSERT INTO kwo_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Krie keekee lelali te Boase betige lelee tetoo moporite ambure leleelu, mwa, inalileme nalilu kulika bwagei lulali oorinalefolee! ");
INSERT INTO kwo_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Te fiefolee, “Ooneboe ine?” Te Rute fune nafolee, “Mene Rute, mene oonafe amee amee aoolaielu inali. Oone Elimeleke mare mwamole tabe oolaielufu, tefe ilekuli groolerife rie, oone menane amwi amwi leoolarife.” ");
INSERT INTO kwo_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Te Boase nafolee, “Aite, Paielu oonane amwime lewobee. Oonekoe mwanga, eetegeni amee wolilu oone menane lewolulu, ekeni amee mikelule lefoomelule genile boore lefolu. Te ari rawielu motukwe lapruefwalanei, te telu yesou kalu babifu, te telu mwa, oone glei menengu letelu ekepane faleworife. ");
INSERT INTO kwo_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Tefe oone kose wofri lele mani, mwa. Menanoo fwi wokoofu inalilufwa mareteku wolu rame leoone, oonanoo wolilu ameele fetanelufe. Tefe mene ame letefe, yesou mareteku oone menane natewolulule. ");
INSERT INTO kwo_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ekeni na nelulu marena, mene oonanoo lufwatu weife mwamole tabe oolaielufu, tefe mene oonane ame amwi amwi leoolafe. Mwa. Ilekuli groolerife lelaleelu lufwa bofoo ame lalalee, mene nanoole taufofwielu. ");
INSERT INTO kwo_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Te bie nembue eetegeni krie oone teime lue, te kwotue mene ame waieke ekeni lufwalu menengule wofalefofe. Nali mwamole tabe neleeke i neli, eetete nemboue lebe. Nali ulabee neli, tetoo nia ame ilekuli groo lefe. Paielu wolu rame lelalee mene glei kosefe nawofe, mwa. Sei, oone boe lue.” ");
INSERT INTO kwo_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Te Rute Boaselu kulika porite lulaleeke, te kwotue krieime ame pinanelali furalelee. Te Boase nafolee, “Kose oonane inalilufwa eetegeni tekoofu walalu rame lewobile.” ");
INSERT INTO kwo_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Te Boase nafolee, “Oonanoo bebeti leeloo terieluke guelufi bebenetalalu amee gigi naletela.” Te Rute gigi netalali, te Boase barli ooloo fine fine atefoleelu bogumwee tialootu lelee. Eetegeni ritilu 20 kg atukwe lelee. Te Boase boletafoleeke tetoo arueleeke, te wokeile walee. ");
INSERT INTO kwo_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Te Rute itei woseka leleeke, te yefeekelu fiefolee, “Sei, aite, akeke lewolee?” Tetoo Rute yefeekelule Boase amee amee lefoleelule na ulufi letewafolee. ");
INSERT INTO kwo_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","“Eetegeni barli ooloo bogumwee tialootu lewolee, menane fanewoleeke te nawolee, ‘Oone glei preme mikelufile wale.’ ” ");
INSERT INTO kwo_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Te yefeekelu nafolee, “Aitea, bie oolefoolalu futeni fipwalefoola yesou gleleme lebe, Boase glei preme lalabe. Mwa. Eetegeni amee lerife neleelu bie nembuememe seree lebee.” ");
INSERT INTO kwo_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Te Boase wokoo geeneri ambleneile bulaleeke, lafieleeke lalalee. Te ilekuli groo lerilu lufwa bofoo sekaterieleefe fetaleeke, te eetegeni lufwale fieri nafolee, “Ei! Oone bie rieluke eetei lafie, mene oonane na tukweelule naworife lelaie.” Te weife lapruelene. ");
INSERT INTO kwo_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Te Boase eetegeni wokoofu yefeelu lufwaleme yarilutu yarilutu mei nateleeke, te rineke laprune. ");
INSERT INTO kwo_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Te ekeni ilekuli groo lerilu bofoole nafolee, “Naomi wolu wokoo Moapele wogrialeleeke rielee. Naomi nunguli Elimelekelu inengule bwaleefile faneterife lelalee. Elimeleke mena mare mwamole tabe oolaielu lufwa. ");
INSERT INTO kwo_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Eetegenife mene oonane fieoolaie, oona menengu akeke lelu tetoo oone nanoolu inengule fale, nembue menanoo wokoofu yefeelu lufwa telu mare lapruelelanei fetaoolanelu oofi falefe nelu o, oona ulabee nelu, tetoo menane nawo. Lufwa bofoo glei lalanei, te niame oonane taufowielu lufwa.” Te eetegeni lufwa Boasele nafolee, “We, mene ame bwaleefile fanetefe.” ");
INSERT INTO kwo_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Te Boase nafolee, “Oone eetegeni inengu Naomilu amee fanetefe nelulu, eetete tafilaleelu lufwalu seikolu inali, Moapefu Rutele mei falele, te eetegeni inengu tetoo eetegeni lufwa tafilaleelu bilufe same lafoolarife, nali mare mwamole tabe oolaielu lufwa falenei.” ");
INSERT INTO kwo_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Eetegenife tefe Boasele nafolee, “Marena nia metie mwa, glei eetegeni ameele lefe. Kose neembee nianoo arilu yesou boe glei ekeni inalilu arile yesoule nifwafe, tefe nembue oonameme fale. Mene oonane seinaoolaie.” ");
INSERT INTO kwo_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Te bebriefeme, Israelefu lufwa bofoo, lufwa bofoole na amwime neneke, tetoo yesou falerife o yesou fune fune arife te eesalu amee lenane. Kuli leeloole ligaleleeke, lufwa bofoole fanelee, tetoo rame leneke alarife.) ");
INSERT INTO kwo_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Tefe eetegeni lufwa Boasele nafolee, “Oonameme eetegeni inengule fale.” Te esulu kuli leeloo ligaleleeke, te Boasele fanelee. ");
INSERT INTO kwo_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Te Boase yefeelu panele tukwe inalilufwa mare lalanelule tukwe natelee, “Oone wolu fetamoke rame lelamo. Naomi nunguli Elimelekelu yesoule tukwe lefoo are Kilionelu Malonelu yesoule tukwe mareteku ifelatemeleelule nia nembue wolu peenie. ");
INSERT INTO kwo_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Mene nembue Moapefu Rutele mei wolu falie, Malonelu seikolule. Mene Rutele falielufe, tefe Malonelu inengu nalilufeme latelarife lelaie. Tefe eetegeni lufwa tafilaleelu bilutu, retifu pane Malonelu bilu glei menengu futi nebile, fwi wokoo mei same glei menengu futi nebile. Nembue oone mareteku lalamoi filamo.” ");
INSERT INTO kwo_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Te yefeelu lufwa, inalilufwa mare lukulenelu tekoi lalanei na fune, “We, marena mene mareteku oonanoo na fineke rame leoone. Te Paielu nanoole amwi aikopi lefobe, ekeni inali nembue oonanoo iteile rierife lelaleelule Reseletu, Leatu lenelu atukwe, te weife mena Israelelufe lene. Te oona mei Efratalu weelufu paie tefoo lufwafe lele tetoo Betlehemei oonanoo soulu bilu laoolabe. ");
INSERT INTO kwo_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Te Paielu ame oonane weife inalitu ari motukwe nifwamobe tetoo wee wee afwaneke, Pereselu weelu atukwe, Pereselu yari Juda, yefee Tamare.” ");
INSERT INTO kwo_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Te Boase Rutele faleleeke, te ifeluelee. Te Paielu Rutele aikopi lefoleefe tefe arietu leleeke, te ari kaporele lupolelee. ");
INSERT INTO kwo_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Te inali Naomile nafoone, “Mene Paielule paie paie afoolane, nembue oonane ilekuli grooleri lufwale fanewolee, nali eetegeni ari Rute nembue lupoleleelu, tetoo nanoolu bilu Israelei wee wee afwabe. ");
INSERT INTO kwo_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Te ooneboe ree fue nalewoleeke, te oonane yelune lewoleeke lalalu te amwime oofulineoolabe. Oonanoo wolualikelu oonane nafieoolaleealeelu, nembue ari wolu lupolelee. Te nali oonane gifeworife lelaleelu, kapore ari tialoo mwamole gifeworife lenelule boore letelee.” ");
INSERT INTO kwo_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Te Naomi naooele paflitalali gifelalee. ");
INSERT INTO kwo_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Te mwamole tikliafofu inali nafoone, “Naomi wolu kapore ari naooefe lefoleeke lalalee, lualikelu Rute lupoleleelu arile.” Te eetegeni ari bilu fanenelu Obete nafoone. Te sabei Obete Jesilu yarife lelee, te Jesi Devitelu yarife lelee. ");
INSERT INTO kwo_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Te Pereselu weelufu Pereselufi leleeke letewaleeke Devitelufi sekaleleelu, eese lelee: Perese Hesronelu yari, ");
INSERT INTO kwo_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","te Hesrone Ramelu yari, te Rame Aminadapelu yari, ");
INSERT INTO kwo_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","te Aminadape Nasonelu yari, te Nasone Salmonelu yari, ");
INSERT INTO kwo_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","te Salmone Boaselu yari, te Boase Obetelu yari, ");
INSERT INTO kwo_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","te Obete Jesilu yari, te Jesi Devitelu yari. ");
INSERT INTO kwo_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Bebriefe feti Jona Amitailu lefoo nanoo Gotelu ragoofu nale alipoolaleelu lufwa, Paielu nafolee, ");
INSERT INTO kwo_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Oone nembueme eetegeni wokoo soulume Ninivaile wa. Waluke, menanoo nafi yenalerilu nale alipote. Tupanelu fwagilu ameele mene wolu rame letie.” ");
INSERT INTO kwo_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Mwanga, nanookoe Paielulu nale niferife ulabee neleeke, Tarsise wokoo soulufile tialelalee. Tefe furaleleeke wokoo Jopaile walee. Te brai soulu bofoo Tarsiseile warife lelaleelule fetalee. Eetegeni wokoo mokenei feti. Te bwalee fanetelee, brai soulu ifwarife, nanookoe Paielule grialeleeke wafe neleeke lelalee. ");
INSERT INTO kwo_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Te walanei afoi Paielu fifri arootu leteleefe, tefe mwi melee koona beenaferieleelu brai soulule wabure yabure ifwafwali, brai soulu metie bebesee arife lelalee. ");
INSERT INTO kwo_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Tefe brai soulufi amee amee alanelu pane wofri feti leneke, te mwamole mwamole lufwa nalilu gotele na wopone wopone atene, tetoo nalife aikopi leterife. Te yesou brai soulu menei lailanelu geni kose riti lepooneke brai soulu meleeme lebe neneke, peeneneke meleeme wogrinene. Jona brai soulu ambei luemeli rofoo peti lemelee. ");
INSERT INTO kwo_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Tetoo brai soulule ifalaleelu lufwa ambeile tirafereleeke Jonale rofoofe lulali fetalee, te betige lefoleeke nafolee, “Ooneboe glefeme luemelua? Oone te furaleluke oonanoo gotele na woponefo! Tetoo menafe keemakee leleeke mena glei troonalebile.” ");
INSERT INTO kwo_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Te brai soulufi amee amee alanelu pane te nene, “Sei! Menanoo amee leneke lutufi kwalebile.” Te eese leneke, Jonalu bilu rufoenelufe lutufi kwanalelee. ");
INSERT INTO kwo_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Te Jonale nafoone, “Sei, oone bie ne eetegeni yesou menane eese lelaleelu yewilule! Te oone akekelu amee lelu? Te oone akefu, tetoo ooneboe inepanelu weeluanelu?” ");
INSERT INTO kwo_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Tetoo Jona fune natelee, “Mene Hibrulu weelufu, te mene Efenefu Paielu Gotele reeyemee afoolaielu lufwa. Nali eetegeni inengule meleele brege ateleelu Gote.” ");
INSERT INTO kwo_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Te Jona boe brai soulufi amee amee alanelu panele natelee, “Mene Paielule futeni lefwieke tiafe rie.” Tetoo nanoo eetegeni nale fineke wofri lene. Te Jonale boe nafoone, “Pasoa! Oone metie fwagilu ameele lelu!” ");
INSERT INTO kwo_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Eetegeni mwi melee koona beenelaleelu metie mwa kaisekli lelaleefe, tefe brai soulufi amee amee alanelu pane Jonale boe fiefoone, “Mena oonane akekelu amee lewobile, tetoo melee tafilebe?” ");
INSERT INTO kwo_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Te Jona fune eese natelee, “Oone menane boletamoke meleeme woponewobu tetoo melee tafilebe. Mene wolu rame lie, niafe eetegeni yesou oonane lemoolaleelule.” ");
INSERT INTO kwo_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Mwa, tupane glei eese lefoonei, mwa, brai soulufi amee amee alananelu pane ange brai soulule puletewaneke wafenei imi nalebile nenelu mwa. Melee koona beenelaleelu metie selime lelaleefe, tefe wafenei glei imimi wolenei, mwa. ");
INSERT INTO kwo_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Te Paielule na woponefooneke te fiefoone, “Paielu, mene oonane fieoolane. Mene eetegeni lufwale mwi melei woponenei oone menane kose nembuari lepole mani. Menane kose merekei lelu mani, eetete glei menanoo nembulu. Tefe Paielu, oone mei oonanoo menengule nifeluke eetegeni yesoule lelu.” ");
INSERT INTO kwo_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Te brai soulufi amee amee alanelu pane Jonale boletaneke melei woponenelufe, esulu melee tafilelee. ");
INSERT INTO kwo_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Tefe brai soulufi amee amee alanelu pane Paielule metie wofri lefoonelufe, tefe Paielule amee amee soulu leforife, bolele prafooneke tome amee fanelanei nasi sere lefoone. ");
INSERT INTO kwo_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Tetoo Paielu roree selilule namunefolee Jonale pelerife. Te peleleeke, Jona roreelu arie menei lameli lie mwangife krie mwangife lelee. ");
INSERT INTO kwo_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jona roreelu arie menei lalali, te Paielu Gotele na woponefoolali, te nafolee, ");
INSERT INTO kwo_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Paielu, menanoo ree glei pifeleoolali, mwa, tefe mene oonane na woponeoolaiei te oone menanoo ragoole fiewolu. Mene wolu troonalenelu wokeile rie te mene oonane ee nawielufe te oone menanoo eele fiewolu. ");
INSERT INTO kwo_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Te oone menane melee fooloofi yeponewolu te mene meleeme putukuneterie melee menane binanewolee te melee menanoo pumwai buerebuere amelee. ");
INSERT INTO kwo_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Menekoe eese nie, oone menane wolu ulabee pai nawolu nie. Tefe, Paielu mene oonanoo nembouelu itele boe ame fetafe. ");
INSERT INTO kwo_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Te melee menanoo pumwai koona binamelee te menanoo ragoo menengu yefoo nerilu metie gigime lewolee te melee fooloo babi lamie te melee menane binanewoli te melefu geni giginifee menane ipoele fuewolee. ");
INSERT INTO kwo_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Mene tetie melee ambeile putukuneterie melee menefu afune iterilume. Menane soulu melefu kuri muli lemoleelu atukwe lemie. Tefe Paielu, oona menanoo Gote, oone menane neunawoluke tetoo eetegeni kurile grialieke melee menefu fualieke, te mene boe oofuli lieke lalaie. ");
INSERT INTO kwo_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Paielu, mene oorife lie tefe mene oonaneme menengu lewieke na woponewieke te menanoo ragoo oonanoo nembouelu itei wosekalelali fielu ");
INSERT INTO kwo_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Inalilufwa telu nanookoe metie kose kose gote saueleme nelanei te oonane nifeworilu amee grialetene ");
INSERT INTO kwo_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Menete kame oonaneme saue naoolaiei, tetoo bole tome amee faneworife lelaie, ifi tuwieke isokwi bri lelali, te yesou mareteku wolume nasi sere lewielu oonane nifaworife. Eetete mene ame eese lefe. Oone Paielu, oonameme mena eetei paie napoolabile.” ");
INSERT INTO kwo_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Te Paielu roree selilule nafoleeke, Jonale wafenei boe gaiferelelee. ");
INSERT INTO kwo_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Paielu Jonale boe nafolee, ");
INSERT INTO kwo_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Oone nembuememe Niniva metie wokoo soulufile wa. Waluke, menanoo nafi yenalerilu na nawielule walipote.” ");
INSERT INTO kwo_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Te Jona Paielulu nale fieleeke, te Ninivaile walee. Niniva glei tukweelu wokoo, mwa. Lufwa waneke moporite kuruwolebile nenei lie mwangife lenane. ");
INSERT INTO kwo_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Te Jona wokei sekaleleeke, mwamole lietume walali, te ragoo mwai upe upe afwatelali, eese natelee, “Lie 40 leleeke tetoo Niniva nembuari lebe.” ");
INSERT INTO kwo_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ninivafu inalilufwa Paielulu nale fineke, te Gotele menengoi ifelalanei, te eese nene, “Sei, mena mareteku bie fori yesou ambopobile. Mena lufwa paie tefoo paie prelu mei keemakee lietu rani lenanelu leeloole sinapooneke lalabile.” ");
INSERT INTO kwo_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Fimelufe, Ninivafu kine eetegeni nale fieleeke, nalilu paie tefoo lafierilu reeafwee gugulule grialeleeke, te nalilu nembouelu ranile fooroonaleteleeke, keemakee lietu rani lenanelu leeloole sinapoleeke, ile pumwai lafieleeke lameli nali ameleelu fwagilu ameele reeyemee letelali keemakee letelalee. ");
INSERT INTO kwo_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Te kine Ninivafu inalilufwale natelee, “Eetegeni na nembue fimolu mene kine nielu, menane ambei leoolanelu ipoelu lufwatu, mene mare oonane namoolane, inalilufwa oone mareteku fori yesoule meleele kose foopobule mani. Kose wokoofu amefleele fori yesoule meleele nifwatebule mani. ");
INSERT INTO kwo_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Te inalilufwa maretekume keemakee lietu rani lenanelu leeloole sinapomoke lalamoi, te oonanoo fwagilu ameele keemakee letelabu. Oonanoo amefleele mei keemakee lietu rani lenanelu leeloole pumwai binaletebu. Oone kose kai lebule mani, Gotele ee naforime lelabu, tetoo oonanoo fwagilu ameele tukwe, inalilufwa telule teieteri ameele tukwe wogrinatebu. ");
INSERT INTO kwo_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Mena eese lenei, tetoo nemboue pe Paielu menafe keemakee leleeke glei teiebe.” ");
INSERT INTO kwo_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Te tupane eetegeni ameele eese lelanelule fetateleefe, tefe Paielu boe menengu rufoteleeke, glei teietelee. ");
INSERT INTO kwo_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Jonalu menengu Paielule glei paie paie afolee, mwa, Ninivale teiefori preme leleefe, tefe Jonalu menengu fame menengu lefolee. ");
INSERT INTO kwo_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Te Paielule fiefolee, “Paielu, mene ame wokoole grialeri preme lelaieime wolu rame lie, eetegeni yesou oone lerife lelalulu geni nembue wolu lelu. Tefe mene Tarsiseile tialie. Oone keemakee tefoo Gote. Oonanoo menengu glei afeteli nembuari lewolee aleelu Gote, eie, mwa. Oone metie marekulitu inalilufwale mareteku ooretatelalu alulu Gote. Oone metie fwagilu amee alananelu inalilufwale teieterife lelulu menengu selime lewoleelu mei boe menengu tafi lewoleeke, tetoo glei merekei letelualu. ");
INSERT INTO kwo_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Nemboue Paielu, nembue menane teiewoluke tafilafe. Tafilaiei eetete anefe. Te mene tafilari preme liei, eetete glei nemboue.” ");
INSERT INTO kwo_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Te Paielu fune nafolee, “Jona, oonanoo fame menengu ekeni i atukwe bunalewoleelu eete oonanoo yesou pai?” ");
INSERT INTO kwo_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Te Jona wokoo soulu grialeleeke kumori porite walee. Nanoo ite ite aleeke eetegeni pilu menei, ambei lafieleeke lamemelee. Nanookoe glesou pai wokei sekalebe neleeke fetamelee. ");
INSERT INTO kwo_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Te Paielu Gote korebou mweele leleeke serinelee, Jonale lie wofrife muli lefoolali, tetoo nanoolu reele peti lefoolarife. Tefe Jona eetegeni mweele paie paie feti afolee. ");
INSERT INTO kwo_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Te bofoo krietu, oo taki neterielee te Paielu afoo afoole namunefolee eetegeni korebou mweele teieforife. Te teiefoleeke, esulu falu lelee. ");
INSERT INTO kwo_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Lie wolu botemepoolali, te Paielu fifri lumoolu tefoole kumori porite leleeke rielee. Lie metie gaga nelali, Jonalu ipoele foonafoolaleefe, tefe oofwai nalefoleeke, oorife lerife leleelu. Te Jona menengu eese lelee, “Bie tafilafe. Tafilaiei eetete anefe. Mene tafilari preme liei, eetete glei nemboue.” ");
INSERT INTO kwo_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Te Gote Jonale nafolee, “Eetegeni korebou mwee wolu falu leleefe oone tefe pe tupu lelalue?” Te Jona fune nafolee, “We, menanoo menengu glei amwi lafieoolalee, mwa.” ");
INSERT INTO kwo_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Te Paielu nafolee, “Oone eetegeni mweele glei amee amee lefolu, eie, mwa, te mei nanoo glei oonanoo amee ameefi serinelee. Eetegeni mwee mwamole krietu selime leleeke, te bofoo krietu falu lelee. Mwanga, oonekoe eetegeni mwee falu leleefe yemereti keemakee lefolu. ");
INSERT INTO kwo_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Tetoo mene mei same eetegeni wokoo Niniva soume leleelule metie keemakee lefoolaie. Inalilufwa ameelu ka fulu atukwe lenelu 120,000 letelee. Bole ameflee mei, motukwe lene. Nanookoe ari woklilu keme leneke, te amee te ameefe amee feti wane, aneboi amee wane eese alanane.” ");
INSERT INTO kwo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Eetegeni na ulu wolilu Jises Kraiselu, Gotelu Lefoo. ");
INSERT INTO kwo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Eetegeni na bebriefe Gotelu ragoofu nale alipoolaleelu lufwa Aisaia Gote neleelu nale nali molukwe pilelee, “Nia ame bofoo lufwale namunefwieke nambuleoolali, tetoo nianoo nale alipoofwatelali, oonanoo afweele sere letewatewobe. ");
INSERT INTO kwo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pepelu wokei na upe upe ameli, eese namelee, ‘Paielulu afweele sere lefobu, afweele sere letewatefobu.’ ” ");
INSERT INTO kwo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tefe Jone rieli, inalilufwale melei pienulalee, nanoo amee amee, Jordane melei lufwa preme leleelu porite alaleealee. Nanoo inalilufwale natelee, “Oone oonanoo fwagilu ameele marekulitu mufenuetemoke, melei pienuemofe te Jisesele ifelalamoi, tetoo Gote oonanoo fwagilu ameele wogrinatemobe.” ");
INSERT INTO kwo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Te Judiafu inalilufwa, ekeni inengoi lalaleelu Jerusalemefu Jonelufile maretekume wawane. Te nali afwalanelu fwagilu ameele lebati pootepoofwaneke tetoo Jordane melei pienueri alee. ");
INSERT INTO kwo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Te Jone glei wolilu leelootu amelee, mwa. Nanoo kame kamele tifilutu lenelu leeloole sineleeke te amboore paiemoole amboorei krinaleleeke ameli, tetoo kleele, saure meleelu ambofule foopoofwalaleealee. ");
INSERT INTO kwo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Te nali nelee, “Lufwa bofoo menanoo mwi rilaleelu nanoolu kaiseklilu menanoole boore lefolee, tetoo nanoolu kaiseklilule lufwa bofoo mei glei boore lefoone, mwa. Te mene mei glei wolilu lufwa tetoo mene tumoinu krutupwieke, nanoolu kuli leeloofu priemoole klinepofofe, mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Te boe natelee, “Mene kame melei pienuemoolaielu lufwa, menanoo mwi rilaleelu nanoo Wolilu Fifrilutu pienuferiemorife lelalee.” ");
INSERT INTO kwo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ekenitu Jisese Galili inengoi lalaleelu wokoo Nasaretele wogrialeleeke, te rieleeke Jonele yeseka lefolee, te Jone nalimeme Jisesele Jordane melei pielelee. ");
INSERT INTO kwo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisese wolu meleele grialeleeke peenafwakumoli te liele ooti lefoleelu lie metie mopu leleeke menee fo nalelali, te Wolilu Fifri riefolee kaulefu bolu keme leleeke, arefe teriefolee. ");
INSERT INTO kwo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te lie menei Gotelu ragoofu na eesalu riefori lelee, “Oone menanoo Amete mene metie ooretaoolaiaie, mene na bofoo naworilu, mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tesulu Wolilu Fifri neuneleeke mokeneile ifwalee, lufwa prelu wokeile. ");
INSERT INTO kwo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ekeni wokei oolameli lie 40 lefoolalee, tetoo Sebore Lufwa popoi lefolee. Te ekeni wokei mei bolele foopoolanelu ambo klifu alane, Jisese ekeni wokei afwalali, tetoo Gotelu ensele rineke aikopi lefoone. ");
INSERT INTO kwo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Te Herot Antipasane Jonele wolu beleneke, kalabuse itei siwoneneke oolalali, tetoo Jisese waleeke woseka lelee Galilifi. Te Gotelu na ulu wolilule alipoofwatelali, ");
INSERT INTO kwo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","natelee, “Gote nali namunefoleelu krie wolu sekalelee, te Gotelu ameime lalarilu krie wolu roboi lefoolalee. Tefe oonanoo fwagilu ameele mufenuetemoke, tetoo kame eetegeni na ulu wolilu menengoi ifelalamolule nifelabu.” ");
INSERT INTO kwo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Te nateleeke, te Galili Beebe Soulu mitilume walali, tetoo Saimonele fetalee weife moo Andrutu nalilu walile wopone wopone ifamenei. Nanoo weife roreele walitu peenerilu amee amee alananelu ameele yefee lefoone. ");
INSERT INTO kwo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Te Jisese fieri nateleeke, natelee, “Oone weife rimoke menane nifewobu, tetoo nia ame oonane weife fetou namofe inalilufwale neunaterilu amee ameele, nembue eete roreele walitu peenelamolu amee atukwe, inalilufwale eetutu neunatemwabule.” ");
INSERT INTO kwo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tesulu weife walile teime grialeteneke, te nifene. ");
INSERT INTO kwo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","20","Te boe wapoleleelu Jemsele fetalee, Sebedilu lefoo, weife moo Jonetu, nanoo weife walile brai mwai laprueleneke bibri napotenelule kretepomene. Te niferife fieri nateleefe esulu, weife yarile tukwe, nalife aikopi leterife iferietenelu lufwale tukwe teime brai mwai grialeteneke, te nifetewane. ");
INSERT INTO kwo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Te Galili Beebe Soulule grialeneke waneke Kaperneamei kuruwolene. Tetoo Yenalerilu Lietu Jisese Judanelu alina iteile walee. ");
INSERT INTO kwo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te nali inalilufwale alipoteleelu nale fiefooneke metie betige lefooneke, te nene, “Eetegeni lufwa alipoleelu na nanoolu metie bofoo natu leleelu nale alipolee. Na kaisekli ramelu pane alipoolananelu na nanoolu mei fime bofoo natu leleelu nale alipoolanane, Jisese alipoolaleelu na nanoo rame rame tefoo lufwalu ramelu keme lefolee.” ");
INSERT INTO kwo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te eetegeni itei mei bibri lufwa bofoo mare lalane. Te eetegeni lufwalu reefu naifofu Jisesele fetaleefe, larifi na lelali te nafolee, ");
INSERT INTO kwo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaretefu Jisese, oone menane teierife pai rielu? Mene oonane wolu rame lewie, ekeni lufwa oonekoe Wolilu Lufwa, Gote nalilufu rielulu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Eetegeni naifofu Jisesele eese nafoolaleefe tefe Jisese fame lefoleeke nafolee, “Oone tetie, kame pepeleluke wa.” ");
INSERT INTO kwo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Esulu ekeni naifofu ekeni lufwale menengoi alifeleefe yefera leleeke lalali nali metie oosisitu grialeleeke amoifepolelee. ");
INSERT INTO kwo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Te inalilufwa mareteku ekenile fetaneke, metie betige lefooneke, te nali kwaife fune fieri fune fieri neneke te nene, “Eeteboe nembueme glefe eesalu ameele fetalane, eetegeni lufwa fime temolu ameele lelee. Nanoolu na metie kaiseklitu lefoleeke, naifofutume fiefoonane.” ");
INSERT INTO kwo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jisese eetegeni amee leleelu na ulu Galilifu pane maretekume metie fifwane. ");
INSERT INTO kwo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Te Jisese nalilu disaipeletu, te Jemse weife Jonele tukwe Judanelu alina itele grialeneke, te esulu Saimonelu, weife Andrulu iteile warime lene. Te Jemsetu moo Jonetu mei weife nifetene. ");
INSERT INTO kwo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ekeni ite menei Saimonelu yefeekelu reefe ameli, ree isokwi lefoomeleefe luemelee. Nanoolu ree nafe lufwa Jisesele wolu nafoonelufe, tefe ite meneile wopreipoone. ");
INSERT INTO kwo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Te Jisese waleeke amei beleleeke boletaleelu, tesulu ree metie fuenalefoleeke, te fori yesoufe aikopi letelee. ");
INSERT INTO kwo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te feiferilufe lie oolu wolu yefera leleeke tetoo Kaperneame nalilu kokou ree tefoo inalilufwale, bibri na tefoo inalilufwale Jiseselufile ifwatene. ");
INSERT INTO kwo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eetegeni wokoo nalimeme wawaneke alufi lukuleneke lalane. ");
INSERT INTO kwo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Te Jisese kokou ree tefoo panele mwamole mwamole glelu kokou ree lelanelule unapoofwatelee mwamole mwamole inalilufwalu reefule, tetoo reetu fuenetewapotene. Te bibri inalilufwalu reefu naifofule mei wawabu natelee afwateleeke, tetoo naifofu gri griatene. Te naifofu nanoo Jisese nalife wolu rame lefoone. Nanoo Gotelu Lefoo, nali wolu ble nateleefe, tefe kame pepeleneke lalanane, na bofoo boe glei nafoonane. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Te lufereleeke, te kwotuekrieime Jisese furaleleeke, pepelu tekoile walee, Gotele na woponeforife. ");
INSERT INTO kwo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Te Saimone nali mare kafee lelananelu pane mare Jisesele oorafwafooneke, ");
INSERT INTO kwo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","te fetane. Te fetaneke, nafoone, “Kaperneame oonane fetaworife ooraoolane.” ");
INSERT INTO kwo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Te fune natelee, “Mene glei tupanelufile boe wafe, mwa. Mena tale, wokoo eke lafwalanelufile wabile. Tetoo Gotelu nale alipoofwatefe, Gote nali eetegeni amee amee lerife nawoleefe, tefe mene wokoo wogrialieke rie.” ");
INSERT INTO kwo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Te Jisese Galilifi lafwalanelu wokoo tatukweme wokoo wokoo letewalali, te tupane nalilu Judanelu alina itei Gotelu nale alipoofwatelali, tetoo naifofule tukwe wawabu natelee afwatelali, gri griatene. ");
INSERT INTO kwo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Te lufwa bofoo seklai seklai reelume leleelu lufwa Jiseselufile rielee. Te tumoinu krutupoleeke, te Jisesele ragoo letaleekeme nafolee, “Oona i nelu menane aikopi lewoluke tetoo mene Gotelu oofi boe wolilu lufwafe lefe.” ");
INSERT INTO kwo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Te Jisese ekeni lufwalu nale fiefoleeke, metie keemakee lefoleeke, te amee geunatefoolali nafolee, “We, mene i nie, oone boe wolilu lufwafe le.” ");
INSERT INTO kwo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tesulu ekeni lufwalu seklai seklai ree metie fooroonalefoone. ");
INSERT INTO kwo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tefe Jisese eetegeni lufwale sinelali na sere lefolee, ");
INSERT INTO kwo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Oone kose bofoo lufwale eetegeni yesoufe alipofole mani. Oone kame waluke, Gotelu prisele wofetaluke, tetoo nali oonanoo reele fetawoleeke, oone fwagilu amee preme lelu, tetoo oone Gotele bole tome amee ifi tuneke isokwi bri lefoonanelu ameele lefo, Mosese neleelu na atukwe. Eetegeni ameele lelu tetoo inalilufwa rame leworife oonanoo fwagilu amee oonanoo reefu wolu grialewoleelule.” ");
INSERT INTO kwo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mwa, nanookoe ekeni amee Jisese wolefoleeke nafoleelu nale glei nifelee. Mwa. Nanookoe waleeke te inalilufwale lebati Jisese nali nanoolu reele unapofoleelu nale alipoofwatelalee. Eetegeni na ulu wolu selime letewalee ekeni wokei, tefe Jisese glei wokoome inalilufwalu oofi wabe. Mwa. Nanoo kame pepelu tekoi oolameli, te inalilufwalume te fu te fu maretekume wofetarife wawamene. ");
INSERT INTO kwo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Krie soo leleeke tetoo Jisese boe waleeke Kaperneamei woseka lelee. Te nanoo wolu sekaleleeke itei lalaleelu nale finelufe, ");
INSERT INTO kwo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tefe inalilufwa motukwe wawaneke itei luku wolenelu, ite metie keekee naneleeke amblenitume wolene. Tetoo bofoo gue glei preme lapolelalee, mwa. Jisese nali nale alipotemelee. ");
INSERT INTO kwo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Te lufwa telu wane, kuli troonalefoonelu ree lufwale rokweefi fueleneke, lufwa yerifurutu Jiseselufile ambuke tewane. ");
INSERT INTO kwo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Te amblenime tewanelu mwa, inalilufwa amblenitumeme kretane, tefe kame ite guglume peepee ifeneneke, nali na alipotelaleelu atukweme ite guglule pukunaleneke te mweele rokwee kafi liliapooneke tetoo mweefi bebeneneke, tepopo tepopo ifaferene Jiseselume. ");
INSERT INTO kwo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te Jisese wolu rame letelee, nanoo nalife menengoi ifelalane, tetoo ree lufwale nafolee, “Silu, mene oonanoo fwagilu ameele wolu wogrinatewie.” ");
INSERT INTO kwo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Te na kaisekli ramelu lufwa telu itei mare lapruelemenei, te eesalu menengu lemene, ");
INSERT INTO kwo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Boleboe glefeme eetegeni lufwa eesalu na nelee, nanookoe Gotelu gugulule rune leforife pai lelalee? Lufwa bofoo glei fwagilu ameele wogrinatebe, mwa, eetekoe fime Gote nalilu amee.” ");
INSERT INTO kwo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tesulu Jisese nanoolu menengule wolu rame letelee. Tefe natelee, “Oone oonanoo menengoi eesalu yesoule glefe menengu menengu letelamo? ");
INSERT INTO kwo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Eete menane glei gigime lewolee, mene eetegeni lufwale eese nafwiei, ‘Mene oonanoo fwagilu ameele wolu wogrinawie,’ mene eese nafwiei mei, mwa, ‘Oonete furaleluke oonanoo rokweele faleluke oonanoo iteile ambuke tewa,’ mwa, menane glei gigime lewolee. ");
INSERT INTO kwo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tefe oone tetoo rame lerife mene ame fetou namofe, Lufwalu Lefoo eetegeni inengoi lalaleelu nanookoe kaiseklilutu lelee, glelu glelu fwagilu ameele mei wogrinatebe.” Eese nateleeke, te kuli troonalefoonelu lufwale fetalali te nafolee, ");
INSERT INTO kwo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mene naoolaie, oone nembueme furaleluke oonanoo rokweele faleluke oonanoo iteile tewa.” ");
INSERT INTO kwo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Te inalilufwalu oofi ekeni lufwa metie furaleleeke, tesulu nalilu rokweele faleleeke, iteile walee. Te inalilufwa eetegeni ameele fetanelufe metie betige leneke te mwa, mareteku Gotele reeyemee lefoolanei, te nene, “Mwanga, bebriefe mena eesalu ameele glei fetane.” ");
INSERT INTO kwo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisese Kaperneamele grialeleeke te boe Galili Beebe Soulufile walee. Te inalilufwa motukwe wafoonelufe, te Gotelu nale alipotemelee. ");
INSERT INTO kwo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Te boe wapoleleelu Alfiuselu lefoo, Livaile fetalee, nanoo bwalee eetei peenetelaleelu itei lafieleeke lalali, te Jisese nafolee, “Oone menane nifewo.” Tesulu Livai nifetewalee. ");
INSERT INTO kwo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Te Jisese Livailu itei kakali lelali, te bwaleele peenetelananelu panetu, oosefi ifenatelananelu panetu, nalilu disaipele mare lalanei kakali lelane. Eesalu pane, motukwe Jisesele nifetalanane. ");
INSERT INTO kwo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te Farisifu na kaisekli ramelu lufwa telu nanoo Jisesele fetane, tupane mare laprueleneke kakali lelane. Te nalilu disaipelele fietene, “Glefeme nanoo bwaleele peenetelananelu panetume te oosefi ifenatelananelu panetume mare kakali lelanane?” ");
INSERT INTO kwo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Te Jisese eese nelanei fieteleefe tefe natelee, na kaisekli ramelu panele, “Ree tlinepoolanelu pane glei ree itei amee amee alananelu lufwale wofetatenane. Mwa. Kame ree tefoo paneleme wofetatenane. Tefe mene nie, mene glei wolilu paneleme neunaterife rie, mwa. Menekoe oosefi ifenatelananelu panele tukwe neunaterife rie.” ");
INSERT INTO kwo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Te bofoo lietu Jonelu disaipele nanoo Farisiane mare kakali leri preme lalane. Tefe lufwa telu waneke, Jisesele nafoone, “Glefeme Jonelu disaipeletu, te Farisilu disaipeletu nanoo kakali leri preme lalanei, te oonanoo disaipelane mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Te fune natelee, “Te lufwa bofoo inali sinafooneke, inalile yati ifofori ameele ifeletelali, te nalilu retifu panetu weeluanetu kame preme lalabile pe? Eie mwa. Nanookoe metie paie paie ifalanei kakali ifelelabile. ");
INSERT INTO kwo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Te sabei nalife bofoofile ifwanei, tetoo nalilu retifutu weeluanetu menengu lefoolanei kakali preme pe lalabile? ");
INSERT INTO kwo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Lufwa bofoo glei eese lenane, bebriefu leeloo pukunaleleelu meneelule boe leeloo amielu monguelu bofoole boe glei faleleeke tetoo kretepobe. Mwa. Eetete sabei eetegeni leeloole suwainalelali te ekeni amielu leeloo gigiapoleeke, te bebriefu leeloole gliapoli, tete brinalerime lebe. ");
INSERT INTO kwo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Lufwa bofoo glei sipsipe o meme leeloo bebriefufi waine meleelu temolule susunebe, mwa, eese leli, eetete sipsipe o meme leeloo bebriefu mopu leleeke waine metie susunebe. Sipsipe o meme leeloo bebriefutu wainetu nembuari lebile. Tefe waine meleelu temolule mei ekeni bole leeloo temolufime lele.” ");
INSERT INTO kwo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bofootu Yenalerilu Lietu Jisese nalilu disaipele mare wane wite bali soulume babi babime walanei, witele fetefwatelane. Te fetefwatelanei, tetoo nalilu disaipele wite ooloole fooroonetewatene. ");
INSERT INTO kwo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Te Farisiane fetateneke te Jisesele fiefoone, “Nembue Yenalerilu Lie boleboe glefeme oonanoo disaipele metie rune lefooneke wite ooloole fooroonetewatelane?” ");
INSERT INTO kwo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Te fune natelee, “Oonekoe Devitelu alinale glei pai rame lefomo? Bebriefe nalife nifetewanelu pane mare gife letenelufe, ");
INSERT INTO kwo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","tetoo Gotelu iteile waleeke, tabele folee, eke Gotelu guei nalife fanerife luanelu genile. Ekenitu Abiatare Gotelu prise paie tefoo. Te Devite tabele peeneleeke, te bofoole teime foleeke, te telule tewapotelee nali iferieteleelu panele nifwaterife. Eetegeni guefu tabe kame Gotelu priseleme foopoolanane. Glei pai fimo, eetegeni alinale?” ");
INSERT INTO kwo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Te boe natelee, “Gote eetegeni Yenalerilu Liele leleelu inalilufwale aikopi leterife lelee, glei inalilufwa eetegeni liele aikopi leforife lelee. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mene Lufwalu Lefoo tefe mene mei eetegeni Yenalerilu Liele tukwe bebenelaie.” ");
INSERT INTO kwo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisese boe waleeke Judanelu alina iteile wopreielee. Te lufwa bofoo, amee bofoo tafilafoleelu ekeni itei lalalee. ");
INSERT INTO kwo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Te lufwa telu Jisesele amwi oofulinelane, nanookoe Yenalerilu Lietu eetegeni lufwalu ameele sere leforife pai neneke, tefe menengu lefoolanei fetalane. Eesalu ameele leli, tetoo belebile neneke. ");
INSERT INTO kwo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Te Jisese amee tafilafoleelu lufwale nafolee, “Oone eeteme rie.” ");
INSERT INTO kwo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Te Jisese eesalu fieteri lelee, “Na kaisekli menafe ake nelee, Yenalerilu Lietu nemboue pe merekeilu ameele lelabile, fwagilu ameele pe lelabile? Nemboue pe lufwale aikopi letelanei paie napoolabile pe, teieteneke troonalelabile pe?” Mwa, nanoo na bofoo glei gliefoone. ");
INSERT INTO kwo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Te Jisese nali fetafwateleeke, metie mwa, fame menengu lefolee, nanoolu menengule fetateleelu, mwa, menengu metie footepotene. Jisese eetegenife menengu rufofoolalee, tetoo eetegeni lufwale nafolee, “Oone oonanoo ameele tetenepo,” te eetegeni lufwa nalilu ameele tetenepoleelu, tesulu nanoolu amee tafilafoleelu boe nemboue lefolee. ");
INSERT INTO kwo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Te Farisiane eese fetanelufe, tesulu ite grialeneke wane. Te Herotelu pane maretekume luku woleneke, te Jisesele tafilarife na falefoolane. ");
INSERT INTO kwo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisese nalilu disaipele mare eetegeni wokoole grialeneke, Galili Beebe Soulufile wane. Te inalilufwa nanoo motukwememe nifetewane. ");
INSERT INTO kwo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Te inalilufwa motukwe Jisese nali amee amee letewalaleelu nale, nali wolu fiefwafoonelufe tefe Galili distrikefu, Judia distrikefu, Jerusaleme wokoofu, Idumea distrikefu, Jordane melee moitepoi lafwalanelu wokoofu, Taire porite lalanelu wokoofu, te Saidone porite lafwanelu wokoofu inalilufwa, maretekume Jiseselufile wawane. ");
INSERT INTO kwo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Inalilufwa motukwe leleefe, tefe Jisese nalilu disaipelele natelee, “Brai bofoole wolu wofalemoke, fatiemoke lalabee, sabei sisinaferinei, tetoo braifi peenalefe.” ");
INSERT INTO kwo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jisese nali wolu bebriefe kokou kokou ree tefoo inalilufwalu reele fetafwateleeke ree unapoofwateleelu inalilufwa sai sai feti, tefe tupane inalilufwa nembue inepane reepotu wawanelu nanoo Jisesele ameetu geunateforife telule sisinafwatene. ");
INSERT INTO kwo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te naifofu nanoo Jisesele fetanei, tumoinu krutupofooneke, te nafoonane, “Oonekoe Gotelu Lefoo.” ");
INSERT INTO kwo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mwa. Jisese nalife eesalu amee tefoo lufwa nafoonarife ble natelee. ");
INSERT INTO kwo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Te Jisese afuneme peenaneleeke, te lufwa inepane nali menengu leteleelu lufwaleme nateleeke nalilufile wafoone. ");
INSERT INTO kwo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tetoo Jisese nali mare alarife, lufwa kame tialootu tialootu namuneteleeke, te bilu faneteleelu, aposele, natelee. Nanoo tetoo Jisese nali mare alarife, sabei sine sine ateleeke wawalanei, tetoo Gote nalilu nale alipoolarife. ");
INSERT INTO kwo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Eete mei naifofule wawabu natelee afwaterilu kaiseklilule tukwe nifwafwatelee. ");
INSERT INTO kwo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Eetetie lufwa tialootu tialootu nali namuneteleelu, nembouefe nafoleelu lufwa: Saimone nafoone (te bilu bofoo Jisese faneleelue Pita nafolee). ");
INSERT INTO kwo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Te bofoo Sebedilu lefooane mooyafee Jemsetu Jonetu (te bofoo bilu weife faneteleelu Boanergese natelee, eetegeni bilu yewilu Bianebianelu Sisilu). ");
INSERT INTO kwo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Te Andru, Filipe, Bartolomyu, Matyu, Tomase, Jemse nanoo Alfiuselu lefoo, Tadiuse, Saimone nanoo Selote panefu lufwa, ");
INSERT INTO kwo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","te Judas Iskariote, nanoo naliboe Jisesele merekei lefoleelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te Jisese iteile walee. Boe same inalilufwa motukwememe waneke kuruwolefoonelufe tefe nalilu disaipele mare kakali lerife lenelu mwa, nanoo kuruwoletenelufe, tefe glei kakali lene, mwa. ");
INSERT INTO kwo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Te Jiseselu retifu nali amee amee letewalaleelu nale wolu fiefoonelufe, tefe neunerife wane, nanoo bibri nafe pai alalee neneke. ");
INSERT INTO kwo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Te na kaisekli ramelu lufwa telu Jerusalemei lalanelu rineke, te Jisesele nafoone, “Belsebule pai ifalalee, tefe Belsebulelu kaiseklilutu naifofule grialeterife nateleeke amoirepofoonane. Te nali mei naifofulu ipoelu lufwafe letelee.” ");
INSERT INTO kwo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Te Jisese nateleeke nalilufile wafoone. Te telu yesou na buburele nafwateleelu eese natelee, “Ake lelee keme Sebore Lufwa boe nalife grialerife nafobe? ");
INSERT INTO kwo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Te lufwa telu mwamole wokoofu nali kwaife telutu gulunalene, te telutu moporite gulunalene, te eese aneke nali kwaife apure apure anei, nemboue pe, boe mwamolei lalabile? Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te mwamole fweelufu mei same, nali kwaife telutu gulunalene, telutu gulunalene, te nali kwaife apurelenei, mwamole fweelu boe glei mwamolei lalabile, mwa. ");
INSERT INTO kwo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tefe Sebore Lufwa mei, nali boe nalifeme fame na ifeneli, eetete nalilu weeluane fime fime anei, te boe glei mwamolei lalabile, mwa. Metie tatukweme mwa lebile.” ");
INSERT INTO kwo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Te natelee, “Lufwa bofoo kame glei kaiseklilu tefoo lufwalu ite meneile preieleeke yesoule wopeenefobe. Mwa. Bie ekeni lufwale beleleeke, kuli amee mweetu bulupofoleeke lalali, tetoo ite menefu yesoule nemboue wopeenefobe. ");
INSERT INTO kwo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mene oonane marenafe namoolaie, Gote nanoo inalilufwalu fwagilu ameele, eeneri nale, nemboue wogrinatebe. ");
INSERT INTO kwo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tetoo ine Wolilu Fifrile eeneri nafoli, eetete mwa, Gote glei eetegeni eeneri nale wogrinafobe, mwa, eetete neembee neembee mei, mwa. Eetegeni nafi glei paie nebe.” ");
INSERT INTO kwo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisese neleelu eete glefe, tupane nali nafoone, “Nanookoe naifofu reeme lefoleeke ifalaleelu nafoone.” ");
INSERT INTO kwo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Te eetegenitume Jiseselu yefee, mooane mare kuruleneke, ite ambolufi temepoolanei te naleme natene, Jisesele nafoomoke riebee, ");
INSERT INTO kwo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","inalilufwa metie motukweme Jisesele fwainalefooneke lapruelelanelu, te Jisesele eese nafoone, “Oonanoo mie, oonanoo womooane, wofoliane mare eketie ite ambolufi temepoolanei, oonane warife naoone.” ");
INSERT INTO kwo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Te Jisese fune natelee, “Ine menanoo mie, menanoo womooane?” ");
INSERT INTO kwo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Inalilufwa nalife fwainalefooneke lalanelule oosunetewateleeke, te nelee, ");
INSERT INTO kwo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Inali o lufwa nanoo Gotelu i nerilule nifelaleelu eetete nanoo menanoo womoo, menanoo wofoli, menanoo mie.” ");
INSERT INTO kwo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisese boe inalilufwale na alipoterilu amee ameele Galili Beebe Soulufi tei leleeke letewalee. Inalilufwa ekenitu waneke luku wolefoonelu glei mwamole mwamole inalilufwa, mwa. Metie motukwe. Tefe Jisese ekeni beebei lainelu brai bofoofi peenaleleeke te ekeni mwai bolafieleeke lalali, ");
INSERT INTO kwo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","tetoo na bubureleme motukwe nafwatelalee. Inalilufwa mareteku nanoo melee bwagei wafeneme temepoofwaneke te nale fiefoomene. Te natelee, ");
INSERT INTO kwo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Bie fiebu. Lufwa bofoo nalilu balifile waleeke, wite ooloole fifinapoofwalee. ");
INSERT INTO kwo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te fifinapoofwalali, te telu wite ooloo nali warialaleealeelu kuli gugulufi yekuru nene. Te eetegeni kuli gugulufi yekuru nenelule bobuteni tetie rineke foopoone. ");
INSERT INTO kwo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Te telu ooloo inengu ambelu tilume leleelu pumwai yekuru nene. Te ekeni inengufu wite ooloo afeteli i nalene. ");
INSERT INTO kwo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Te sabei lie gaga natelali, mwa, afetelime falu leneke tafilapoone, tife, tefe nanglilu glei amwi wanei. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Te telu ooloo nanoo meteimeteime nangliluleme leleelu inengoi yekuru nene. Te meteimeteime i naleneke metie wite i nalelanelule fwarinepoonelufe, tefe wite senaleneke glei oolootu lenei. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Te telu wite ooloo nanoo metie inengu wolilufi yekuru nenelufe, tefe amwi i naleneke, oolootu lene, telu ooloo kame areme areme lenei, te telu ooloo kame motukwe keke lenei, te telu ooloo metie motukwe feti lebile.” ");
INSERT INTO kwo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Te Jisese natelee, “Lufwa futenitu leli eetegeni nale amwi fiebee.” ");
INSERT INTO kwo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Te inalilufwa mareteku wolu wanei, tetoo nalilu disaipeletu nali ifelatelaleealeelu lufwatu nanoo Jisesele na bubure na yewilufe fiefoone. ");
INSERT INTO kwo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Te Jisese natelee, “Gotelu ameime lalarilu na yewilu ambuke lemeleelu nembue wolu lebati lemolee. Inepane menengu glei kaisekli letenelu, kame bubure naleme fifwalabile. ");
INSERT INTO kwo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tefe nale mei ‘fete fete soo lemebile. Nanoo yesou bofoole glei fetaneke, rame lefobile. Fierife mei futeni sootu mei lemebile. Mwa. Na yewilule glei rame lefobile. Nanoo kose rame lenei, fwagilu amee nalilule Gotele lebati pootepofoonei kose Gote nanoolu fwagilu ameele wogrinatebe.’ ” ");
INSERT INTO kwo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Te Jisese nalilu disaipelele natelee, “Eetegeni na bubure yewilule ooneboe glei pe rame lemo? Eese lemoi eetete mwa, oone na bubure yewilu mareteku glei rame letebule. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Eetegeni lufwa eke wite ooloole fifinapoleelu, eetete Gotelu nale fifinapolee. ");
INSERT INTO kwo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kuli gugulufi yeferaleleelu na bubure yewilu eetetie eese lelee, inalilufwa telu Gotelu nale fineke, tesulu Sebore Lufwa rieleeke, Gotelu nale nali menengoi fifinapoteleelule wogrinateleealee. ");
INSERT INTO kwo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Te inalilufwa telu inengu ambelu tilume leleelu inengoi yeferaleleelu wite ooloo atukwe lene, na fineke, te wolu rame lene neneke, paie paie apoolanei nifetalabile. ");
INSERT INTO kwo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Te boe mwa. Nanoolu nanglilu glei amwi wanei. Mwa. Kame nembueme lalane, kwotue te mwa. Inalilufwa Gotelu nale futeni lefoonane, eesalu inalilufwalufile waneke, te fwagilu ameele letenei, tetoo wolilu menengu Gotelufi luanelu menengu tesulu metie nembuari lepotenane. ");
INSERT INTO kwo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Te inalilufwa telu meteimeteimeleme leleelu inengu atukwe lene. Nanoo na fineke, ");
INSERT INTO kwo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nali metie inengufu yesou aipoe aipoe lerilu menengu rune rune atelanei, tetoo bwalee aipoe leneke, yesou pumwai lalarilu menengu tekee napotelanei, Gotelu nale tetoo bibinelanane wolilu menengu lerilu mwa. ");
INSERT INTO kwo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Te inalilufwa telu wolilu inengoi yekurulenelu wite ooloo atukwe lene, nanoo Gotelu nale amwime fineke, belenelu, metie oolootu leneke, te telu kame areme areme lenei, te telu kame motukwe keke lenei, te telu ooloo metie motukwememe lene.” ");
INSERT INTO kwo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Te Jisese nalilu disaipelele natelee, “Inali, o lufwa, komi ile ruteleeke terieleelu kame boole ambei o bulue ambei fatierife terielee, eie mwa. Nanookoe kame boole mwai bofatieleeke rinelali taki nanelarife terielee. ");
INSERT INTO kwo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Te glelu glelu yesou ambutenulanelu mareteku sabei ame lebati lebile. Te glelu glelu amee lufwa angime alanelu mei mareteku sabei ame lebati lebile. ");
INSERT INTO kwo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Oone futenitu lelu, eetegeni nale fieluke nife.” ");
INSERT INTO kwo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Te boe natelee, “Oone fimolu nale amwime menengu lefoolabu. Oonanoo menengu, Gotelu nale menengoi fatierife alamwamolu menengu, soulu o tukweelu Gote oonane mei ame eetutume lemobe. Gote boe ame tepumwai luamobe. ");
INSERT INTO kwo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Eetete ine nale wolu fieleeke nifelali, Gote boe ame tefe tukwe tepumwai fatiefobe. Te ine ramelu tukweeme talaleelule ekeni ramelutu amee amee leri preme lelali, eetete Gote nanoolufule peenefobe.” ");
INSERT INTO kwo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Te Jisese boe nelee, “Gotelu ameime lalarilu eetegeni atukwe lelee. Lufwa bofoo nalilu balifile waleeke wite ooloole fifinapoofwaleelu atukwe lelee. ");
INSERT INTO kwo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wite ooloo fifinapoofwaleeke, krielu lielu eetegeni lufwa rofoofe luelaleeke liei furalelee aleelu, eetegeni wite ooloo i naleneke te ake leneke tetoo boe selime lenelule, eetegeni lufwa glei rame leteleealee, mwa. ");
INSERT INTO kwo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Inengu nali wolilufe tefe i naleneke tetoo oolootu lelane. Nembouefe feti bie fulu molukwe leneke, te leelu lerife bubutu napoofwaneke te ooloo seselime leneke te ooloo feti menei lailanane. ");
INSERT INTO kwo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te wolu mwai lepoolanei fetateleefe, te kulepoofwaleealee, eete glefe, aterilu lie nalilu wolu sekalefoleefe.” ");
INSERT INTO kwo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Te boe nelee, “Gotelu ameime lalarilule glelu yesou keme lelee nafobile, te yesou glelu na bubure natu nafobile? ");
INSERT INTO kwo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nanookoe faku ooloo keme lelee. Glei selime leli, telu yesou ooloo atukwe mwa, nanookoe kame tukweeme lelee. ");
INSERT INTO kwo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sabei rineluke, serineneke, selime lebile, telu fori yesou balifule mei booreletebe, merilu mei selime lepofobile, tetoo eesalu ka merilu fulu petilu menei kaulefu ailu letenane.” ");
INSERT INTO kwo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Te Jisese inalilufwale nale alipotelali na bubureleme motukwe nafwatelaleealee nanoo rame leri pike. ");
INSERT INTO kwo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jisese inalilufwale nale alipotelali na yewilu bofoole glei pootaleteleealee, mwa. Kame na bubure naleme nalilu disaipele kwaifeme ifelatelali, tetoo na yewilu mareteku lebati pootepoofwateleealee. ");
INSERT INTO kwo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Te eetegeni lietume, feiferilufe Jisese nalilu disaipelele natelee, “Mena tale wabile beebe moitepoile.” ");
INSERT INTO kwo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Te tupane inalilufwale grialeteneke te Jisese nali wolu eetei lafieleeke lalaleelu braifi peepeeneneke, te mare wane. Te lufwa telu mei braitu telutu mare walane. ");
INSERT INTO kwo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Te fifri soulu afoolaleelu geni melee koona beenelaleelule terie terie alali braifi sune sune alaleefe, te melee braifi metie ragoo lelalee. ");
INSERT INTO kwo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Te Jisese kumulu porite ipoeka bofoo pumwai luemeli, te kelafooneke nafoone, “Paielu, mena metie nembuari lerife lelane, oone menane glei pai keemakee lelalu, mena troona lerife lelanelule?” ");
INSERT INTO kwo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Te esulu Jisese furaleleeke, fifri soulule ble nafoleefe, te melee koona beenelaleelule mei nafolee, “Tetie mai, oonete tafi le.” Te fifri soulu peti leleefe, te melee koona beenelaleelu mei tafi lelee. ");
INSERT INTO kwo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Te Jisese nalilu disaipelele eesalu fieteri lelee, “Boleboe glefeme wofri lelamo? Oone menengu preme pe lemo?” ");
INSERT INTO kwo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Te tupane metie wofri lelanei, te nali kwaife nene, “Eetegeni lufwaboe akekelu lufwa, tefe melee koona beenelaleelutu fifritu metie futeni mwamole lefoonane?” ");
INSERT INTO kwo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Te moitepoi imi oonalepoone Gerasalu inengoi. ");
INSERT INTO kwo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Te Jisese wolu braifu tiraleleeke te wafenei temelali, tetoo lufwa bofoo naifofu ifalananelu lufwa rieleeke Jisesele fetalee. Ekeni lufwa tafi lualananelu tekoi afwalaleeke rielee. ");
INSERT INTO kwo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nanoo ekeni tekoi lulaleealee. Lufwa bofoo ekeni lufwale glei nalime ameele mweetu bulupofoonane. Mwa. Te seinetu mei, ange kuli amee bulupofoomenei mei mwa, metie titikinapoleealee. ");
INSERT INTO kwo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Utetu utetu seinetu, ameele tetoo ange bulupofoomenei, mwa. Metie titikinaleteleealee. Te lufwa bofoo mei glei nalime belebe. Mwa. Nanoolu kaiseklilule bofoo glei buruanalefoonane. ");
INSERT INTO kwo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Utetu utetu, krielu, lielu, nanoo tafi lualananelu tekoi, afunei lafwalali, lari nafwalali, te nalilu ree telu telufi titu teke teke afwatelaleealee. ");
INSERT INTO kwo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tetoo Jisesele ame mokeneime wolelalime fetalee, te pipinafwaleeke, Jiseselu ootari porite tumoinu krutupoleeke, ");
INSERT INTO kwo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","te lari finanelali nelee, “Jisese, oone Paie Tefoo Feti Gotelu Lefoo, ooneboe menane akeke leworife lelalu? Gotelu bilutu bi nelu tetoo mene rame lefe, oone menane marenafe nawolu, menane glei teiewole. Mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Eke lari neleelu glefe, Jisese nali wolu nafoleefe, “Naifofu, oone ekeni lufwale afeteli griale.” ");
INSERT INTO kwo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Te Jisese fiefolee, “Oonanoo bilu ake naoone?” Te nafolee, “Menanoo bilu Motukwe. Eete glefe, mena metie motukwe lene.” ");
INSERT INTO kwo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Te Jisesele ee natumeme yetike yetike ifalalee, eetegeni inengule kose grialeneke wabile neleeke. ");
INSERT INTO kwo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Fori ameflee motukwe feti afune tupulufi mwamolei alanei kakali lelane. ");
INSERT INTO kwo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Te naifofu Jisesele nafoone, “Oone menane ekepane forilu reeme wolerife neluke wabile.” ");
INSERT INTO kwo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Te Jisese ooloome letelali wane. Te naifofu eetegeni lufwalu reefu kuruleneke, waneke forilu reeme wolene. Te ekepane fori mwamolei alanelu pipinapoofwaneke beebe melee tikotilume fifineneke, te meleeme leneke troonalene. Ekepane fori mwamolei amenelu metie motukwe 2,000 lelee. ");
INSERT INTO kwo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Te ekepane forile gipoolananelu lufwa fori brunalenelu nale wokeile tewarime leneke, te eetegeni nale wokoo wokoo wee wee ifelene. Te inalilufwa mareteku waneke, wofetane eetegeni yesou sekaleleelule. ");
INSERT INTO kwo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te Jiseselufi kuruwoleneke, te naifofu wolume ifamenelu lufwale fetane. Nembue wolu wolilu lufwafe leleeke, leeloole tamuleleeke, te lafieleeke lalali, inalilufwa fetaneke, metie wofri lene. ");
INSERT INTO kwo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jisese leteleelu yesoule fetatenelu inalilufwa nanoo inalilufwale alipotene eetegeni naifofu ifamenelu lufwale sekalefoleelu yesoufe te forilufe tukwe mei alipotene. ");
INSERT INTO kwo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Inalilufwa eetele finelufe tefe Jisesele noopoo ifenelane, nanoolu inengule grialeteleeke warife. ");
INSERT INTO kwo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Te Jisese braifi peenalelali, te nali naifofu grialerife nafoleelu lufwa fiefolee, “Nemboue pe mene weife wabile?” ");
INSERT INTO kwo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mwa, Jisese glei i nafolee. Te eetegeni lufwale nafolee, “Oone oonanoo wokeile waluke, te oonanoo weeluanelufile wa. Te Paielu oonane keemakee lewoleeke aikopi lewoleelule alipote.” ");
INSERT INTO kwo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tefe eetegeni lufwa waleeke, Dekapolise porite nalife, Jisese amee amee lefoleelu nale alipoofwatelee. Te inalilufwa mareteku fineke metie menengu preme lene. ");
INSERT INTO kwo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Te Jisese boe braitu prieleleeke, wafenei lalali, te inalilufwa motukweme rineke luku yelefoone. ");
INSERT INTO kwo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Te Judanelu alina itei amee amee alananelu yefeelu lufwa bofoo rielee. Bilu Jairuse nafoone. Nanoo Jisesele fetaleeke, te ootari porite tumoinu krutupoleeke, ");
INSERT INTO kwo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","te ragoo letaleekeme nafolee, “Menanoo auteli ari tukweelu melee wolu foworife lelalee. Tefe oone bie rieluke, oonanoo ameetu geunalefo tetoo nemboue lebee.” ");
INSERT INTO kwo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Te Jisese nanoo Jairusetu weife wane. Inalilufwa mei motukweme tifetewane. ");
INSERT INTO kwo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Te inali bofoo mei lalalee, nanoo utetu utetu fweeluleme terie terie alaleealeelu inali, eesalu ree lemeli, yare wolu tialootu tialootu lefolee. ");
INSERT INTO kwo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Marasine itei amee amee alananelu lufwale fetaterife wari amelee nalilu ree kokoule sere leforife. Eese afwalali teteree soulule falemeli, bwalee soonalemelee nalilu ree kokoule sere leforife. Mwa. Nanoolu reekoe nembue tefe tukwe metie nembuari lefoolalee. ");
INSERT INTO kwo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ekeni inali Jiseselu nale wolu fieleefe, tefe inalilufwa mwamolei tifetewalanelufi Jiseselu bwageile koona porite rieleeke, Jiseselu leeloo wamolulule amee feenetewaleeke geunatefolee. ");
INSERT INTO kwo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nanookoe nalife nelee, “Mene kame amee feenetewaieke, leelooleme geunatefwiei mei ame nemboue lefe.” ");
INSERT INTO kwo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ekeni inali Jiseselu leelooleme geunatefoleefe, tesulu fwee tekanalefoleeke, te nalilu reele sulelaleelu eetegeni ree wolu grialerife letewalee. ");
INSERT INTO kwo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Te Jisese nalife ree suleleeke, wolu rame lelee, ree fue nalefoleefe, tefe ambureleleeke te nelee, “Menaneboe ine geunatewolee?” ");
INSERT INTO kwo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Te nalilu disaipele nafoone, “Inalilufwa eke oonanoofi tife tife alanei, fetatele. Te ooneboe glefe nelu, ‘Menane ine geunatewolee?’ ” ");
INSERT INTO kwo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mwa. Jisese nanookoe ame fetafe neleeke oofwanefoolalee. ");
INSERT INTO kwo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Te ekeni inali wolu eesalu amee leleefe, tefe wofrife pupunelalee. Tefe Jiseselufile waleeke, ootari porite tumoinu krutupoleeke te yesou bofoole glei ambutelefolee. ");
INSERT INTO kwo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Te Jisese nafolee, “Autelia, oone menane menengu lewolulu menengu, nali oonanoo reele unawolee. Tefe oone kame menengu mutukwe leluke wa, oonanoo kokou ree wolu mwa lewolee.” ");
INSERT INTO kwo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisese ame na nelaleeme, tetoo lufwa telu Judanelu itefu nambulelaleelu lufwa Jairuselu itefu rine. Te Jairusele nafoone, “Oonanoo autelikoe wolu melee folee. Oone yemereti Ramelu Lufwale nafo nafo te grialete.” ");
INSERT INTO kwo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisese nanoo futenileme letemeleeke, tetoo Jairusele nafolee, “Oone kose wofri lele mani, oone kame menengu kaisekli le.” ");
INSERT INTO kwo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Te inalilufwale mareteku teime lalarife ble nateleeke, lalanei, te kame Pita, Jemse, Jone, Jone nanoo Jemselu moo, kame mwangifeme ifwatelee. ");
INSERT INTO kwo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te waneke, Jairuselu itei kuruwolene, te fietelalee inalilufwa metie mwa, ee pupusi lepoolanei itele pulelane. ");
INSERT INTO kwo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Te Jisese iteile preieleeke, te natelee, “Ooneboe glefe yemereti ee pupusi lepoolamoi, itele pulelamo? Eetegeni autelikoe glei tafilalee. Mwa. Nanookoe rofoofe lulalee.” ");
INSERT INTO kwo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Te nateleefe nanoo eeneritu yeutu tekalene. Mwa. Nanoo inalilufwale mareteku ite menefule nateleeke wokeile fooroonetereneke, te kame yefee, yari, nalilu disaipele mwangife ifwateleelule ifepreietelee ekeni auteli tafilu lalaleelu gueile. ");
INSERT INTO kwo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Te ekeni autelile amei belelali, te nafolee, “Talita kum.” Eetegeni na yewilu nelee, “Auteli tukweelu, mene naoolaie, oonete furale.” ");
INSERT INTO kwo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tesulu ekeni auteli tukweelu furaleleeke warialee. Te tupane eetele fetanelufe metie betige lene. Ekeni autelilu yare wolu tialootu tialootu lefoleelu. ");
INSERT INTO kwo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Te Jisese metie kaisekli fame letelee inalilufwale eetegeni yesou nafe rame lerife. Te natelee, “Fori yesou kakali lerife fanemoke fobee.” ");
INSERT INTO kwo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Te nalilu fwi wokeile walalee, nalilu disaipele mei mare nifetewane. ");
INSERT INTO kwo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Te Yenalerilu Lietu, Jisese Judanelu alina iteile waleeke, te inalilufwale Gotelu nale alipotemelee. Te inalilufwa mareteku inepane nanoolu nale fiefoomenelu nanoo metie betige lefooneke te nene, “Eetegeni lufwaboe eetegeni na akenifule falelee? Eeteboe glelu ramelu nale fanene. Eke brege brege leteleealeelu. ");
INSERT INTO kwo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Menakoe wolu rame lefoone nanookoe Marialu lefoo fate, kame kale te yesou te yesoufile mumusi letelaleealeelu lufwa, nanoolu mooane Jemse, Josepe, Judase, Saimone. Te nanoolu yafoliane mei nembue eetetie mare lalane.” Te nafwaneke, tetoo menengu nembulu lefoone. ");
INSERT INTO kwo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mwa, Jisese natelee, “Gotelu ragoofu nale alipoolaleelu lufwa nanoo wokoo wokoo wolu bilutu letewaleeke, nalilu wokeie, nalilu mwamole fweeluanelufie, nalilu itefu feti mei, mwa, bilu preme lelee.” ");
INSERT INTO kwo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Te ekeise bofoo brege bregelu amee glei letebe. Mwa. Nanoo kame mwamole mwamole ree lufwalu reefi amee luafwateleeke, tetoo reele unapoofwatelee. ");
INSERT INTO kwo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te Jisese metie betige letelee, nalife menengoi ifelalari preme lelanelufe. Jisese nalilu kaiseklilule fetou nateleelu, mwa, nalilu disaipele glei amwi rame lefoonei (Make 6:7—8:21) Jisese wokoo wokoo letewalali nale alipoofwatelalee. ");
INSERT INTO kwo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Te kame tialootu tialootu disaipelele fieri natelee, tetoo lufwa are areme namuneteleeke, tetoo amee ameefe wawarife natelee. Bie inalilufwalufu naifofule wawabu natene afwaterilu kaiseklilule fanetelee. ");
INSERT INTO kwo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Te faneteleeke, na amwi fatietelee, “Oone tewaporilu yesou kame, kafunele peenemo, te kuli leeloole letemo, te bebeti leeloole mwamole mwamole peenemo lebu. Kose oone eesalu yesoule peenebule mani, tabe, aue, bwalee mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Te boe natelee, “Oona bofoo wokei kurulemoi lufwa ine neunamoli ekeni iteime alamokeme riebu, kose ite ite preme. ");
INSERT INTO kwo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te telu wokei kuruwolemoi, te ekeni wokoo oonane neunamori preme lemoonei, o oonanoo nale fiemorife ulabee nenei, kose lalabule mani, mwa, eetegeni wokoole grialebu. Te ekeni wokoole grialerife lelamoi kame oonanoo kuli leeloofu inengu asalule pupunatemoke riebu, oone eese letemoi ame nali rame lebile glelu amee nembulu nali lenelule.” ");
INSERT INTO kwo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nalilu disaipele te wawaneke inalilufwale nale alipoofwatenei, te natene, “Oonanoo fwagilu ameele mufenuetebu.” ");
INSERT INTO kwo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Te naifofule inalilufwalu reefule mei grialeterife nafwatene. Tetoo inalilufwa kokou lelanelule motukwe Gote aikopi leterife nanoo Gotele fanenelu olife nangulule ipoi sunaletenei, tetoo kokou reele unapotene. ");
INSERT INTO kwo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Te Kin Herot Antipase nanoolu yafee Herot Filipe nafoone. Te yafee nariemu Herodiase nafoone. Jiseselu amee amee na ulu metie te wokoo te wokoo fifwane. Tefe inalilufwa telu nafoone, “Nanookoe Jone fate, Melei Pienulaleelu Lufwa nali boe ti menefu furalelee. Tefe nanoo kaiseklilutu lelee eetegeni brege bregele leterife.” ");
INSERT INTO kwo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te telu nene, “Nanookoe Elaija,” te telu fune nene, “Nanookoe Gotelu ragoofu nale alipoolaleelu lufwa, bofoo bebriefe amenelu Gotelu ragoofu nale alipoolanelu lufwa atukwe lelee.” ");
INSERT INTO kwo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot Antipase ekeni nale fieleeke, tefe nelee, “Bebriefe mene Jonele wolu borei tekalieke tafilaleelu, mwa, nembue nanoo boe wolu oofuli lelee.” ");
INSERT INTO kwo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Bebriefe Herot Antipase nali yafee nariemule yemee seiko lelee. Tefe Jone Herot Antipasele nafolee, “Oone ape nariemule yemee seiko lelulu amee ekeni glei wolilu ameele lelu, mwa.” Jone nafoleefe tefe Herot Antipase nali lufwale nateleeke, te waneke, Jonele wobeleneke, kalabuse ite meneile ifwane, te ameele seinetu fupwafooneke, grialene. ");
INSERT INTO kwo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiase eetegenife glei Jonele paie paie afoolalee, mwa, nanoolu menengukoe Jonele teiefoleekeme tafilarilu menenguleme lefoleelu, mwa. Afwee nali metie gigime lefolee, ");
INSERT INTO kwo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","eete glefe, Herot Antipase Jonele wofri lefolee. Nanoo nanoole wolu rame lefolee, Jone nanookoe Gotelu naleme nifelaleelu lufwa. Tefe Herot Antipase amwime oofulinelaleealee. Nanoo Jonelu nale fiefoleeke, menengu aipoe aipoe lefoolali, te menengu lefoolaleealee, mwa, nanookoe Jonelu nale boe nafiefoolaleealee. ");
INSERT INTO kwo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Te bofoo lietu, Herot Antipase nalife yefee lupoleleelu liele paie paie aforife, kakali soulu ifeleterife lelaleelu pumetu Herodiase glelu amee lerilu afwee munafolee. Herot Antipase ekeni kakali soulu leleelu kame nalilu yefee yefeelu lufwale, Romefu kworoofamelu yefeelule, Galilifu paie paielu lufwale, te eese leleeke luku ifeleteleeke kakali ifeletelalee. ");
INSERT INTO kwo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te eketu Herodiaselu luali wopreieleeke sabi nelee. Te tupane lufwa Herot Antipase nalipotu nanoolu sabile fetafooneke, nanoolu oofi metie pife letelee. Tefe Herot Antipase ekeni auteli ramulule nafolee, “Oona glelu yesoule nafiefolu kame nawo, mene ame fanewofe.” ");
INSERT INTO kwo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herot Antipase nasi lefolee, “Marena, lie eete, oone glelu yesoufe menane fiewolu mene ame fanewofe. Oona, mene eetei lalaielu inengule moporite seinaworife nawolu tetoo mene seinawofe.” ");
INSERT INTO kwo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Te eetegeni auteli ite menefu woseka leleeke, te waleeke, te yefeele fiefolee, “Mene glesoufe nafofe?” Te yefee lualile fune nafolee, “Jonelu ipoelufe nafoluke faleleeke oonane fanewobee.” ");
INSERT INTO kwo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Te eetegeni auteli afetelime boe Herot Antipaselufile waleeke te nafolee, “Nembueme oone menane Jonelu ipoelule bulue bogumwee bofoofi fatieluke fanewo.” ");
INSERT INTO kwo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herot Antipase eetegeni nale fieleeke, menengu preme lelee. Nanoo nali neleelu nale menengu lefolee. Liele wolu turaleleefe, te nali kakali ifeletelali lalanelu panelu oofi reeyemee falerife wofri lelee, tefe mwa, nanoo eetegeni autelilu nale glei buruananefolee. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tesulu Herot Antipase kworoofame lufwa bofoole nafoleeke, walee. Jonelu ipoelule wofaleleeke terierife. Eetegeni lufwa kalabuse iteile waleeke, Jonelu ipoelule borei wotekalelee. ");
INSERT INTO kwo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Wotekaleleeke, te bulue bogumwee bofoofi fatieleeke, terieleeke, eetegeni autelile fanelee. Te ekeni auteli yefeele fanelee. ");
INSERT INTO kwo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jone nalilu disaipele nanoo ekeni yesou Herot Antipase leleelu nale fineke, te waneke Jonelu ree tupulule wofaleneke, te tewaneke, ti menei fatine. ");
INSERT INTO kwo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Te aposele boe wolu ririaneke, te maretekume lukulene. Jisesele fwainalefooneke lalanei te glelu glelu amee amee nali letewalanelu nale, te nali alipoofwatenelu nale tukwe alipoofwafoone. ");
INSERT INTO kwo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Inalilufwa motukweme fune sigli fune sigli alanei, tetoo Jisese nalilu disaipele mare yenaleneke kakali lerilu, mwa, gigime letelee. Tefe Jisese natelee, “Sei! Mena kwaife bofoofile wabile, pena lelaleelufile tetoo yenalepobile.” ");
INSERT INTO kwo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Te braile faleneke, pepelu tekoile wane. ");
INSERT INTO kwo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mwa, inalilufwa motukwe nanoo walanei fetateneke, te wolu rame letene. Tefe inalilufwa wokoo wokoofu mareteku fufuruneneke te melee mitilume nifetewane, te Jisese nanoo nalilu disaipele mare ame ame wolepo lelanei, inalilufwa nanoo nali molukwe kuruwoleneke oolalanei oolefoolane. ");
INSERT INTO kwo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tefe Jisese imi oonalelali fetatelee, tupane inalilufwa weelutu teka leleeke lalanei, menengu rufotelee. Eete glefe? Nanoo yefeeyari preme lene, sipsipe bole atukwe. Te nale boe sameme alipotelalee. ");
INSERT INTO kwo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Te lie pine pine afereli, tetoo nalilu disaipele nalilufile waneke nafoone, “Eetegeni tekoo fime mokenei leleelufi alane. ");
INSERT INTO kwo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Te inalilufwale nateluke wawabi eke lafwanelu wokoome, tetoo fori yesoule nalife ekefule peeneneke kakali lebi.” ");
INSERT INTO kwo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Te Jisese fietelaleeke, tetoo fune natelee, “Oonameme fori yesoule fooporife nifwatebu.” Te fune nafoone, “Tetoo menaboe bwalee 200 akenifutume aikopi letebile?” ");
INSERT INTO kwo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Te boe fietelee, “Tetoo ooneboe tabe akake laiemoone? Bie wamoke wofetatebu.” Te wofetateneke, nafoone, “Mena tabe kame yarilutume, roree mei areme.” ");
INSERT INTO kwo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Te Jisese natelee, “Inalilufwale mareteku natemoke, nali kwaife fime gulune gulune afwaneke, tetoo nanambuli wolilu pumwai laprufwabi.” ");
INSERT INTO kwo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Te gulune gulune afwaneke lapruefwanelu inalilufwalu ameelu telu 100, te telu 50 lene afwane. ");
INSERT INTO kwo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Te Jisese ekeni tabele yarilutu peeneleeke, roreele mei are peeneleeke, te efeneme ooti lelali Gotele fiefolee, tabetu roreetu amwi amwi leterife. Te tabele mongue mongue ateleeke, te nalilu disaipelele nifwateleeke, inalilufwale lemwame letene. Te roreele mei sameme letelee. ");
INSERT INTO kwo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Inalilufwa mareteku foopoofwaneke, metie mwa, yelu lepotenelufe mongue monguelule grialetene. ");
INSERT INTO kwo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Te disaipele, ekeni mongue monguelule peenefwaneke, bulue tialootu tialootu letenelu, ragoo lene. ");
INSERT INTO kwo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eetegeni tabetu roreetu foopoonelu lufwalu ameelu 5,000 lelee. ");
INSERT INTO kwo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tesulu Jisese nalilu disaipelele nateleeke, braifi peepeeneneke, nali molukwe moitepoile prienulane, Betsaidaile. Te inalilufwale nateleeke, wawane. ");
INSERT INTO kwo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te wawaneke, nali tetoo afune mwame peenanelee, Gotele na woponeforife. ");
INSERT INTO kwo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te lie wolu feiferi lelali, brai nanoo ame beebei lelali, te Jisese nanoo nalime wafenei lalalee. ");
INSERT INTO kwo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Te fetalee fifri brai ipoelu porite foofoonaferieleeke, braipotu puletelali, te braile ange ange ifalane waterife. Oo wolu taki nalerife lelali, te Jisese tupanelufile melee mwame walee. Te booreletelali, ");
INSERT INTO kwo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nali melee mwame walali fetaneke, tetoo nene, komookoi paio nene. Tefe metie wofrife larinapoolane, glefe, ");
INSERT INTO kwo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","nali mareteku wolu nalilu ootu fetanelufe. Mwa. Jisese nali esulu na glietelee, “Menengu kaisekli lebu, eetekoe mene fate, kose wofri lebule mani.” ");
INSERT INTO kwo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Te braifile bopeenaneleeke, te mare laprueleneke, tesulu fifri metie peti lelee. Fifri eese leleefe fetaneke metie betige lene. ");
INSERT INTO kwo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Eete glefe? Nanoo ame amwi glei rame lelane Jisese tabetu roreetu leteleelu yesou yewilule, mwa, menengu footepoteneke alane. ");
INSERT INTO kwo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Te Jisese nalipotu wolu beebe prienuneke, Genesarete porite imi oonanepooneke, te braile lifatineke, ");
INSERT INTO kwo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","te titiri neneke wane. Tesulu inalilufwa Jisesele fetaneke, rame lefoone. ");
INSERT INTO kwo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Te pipine pipinetu wokoo wokoome wawane, ekeni inengu porite lafwanelu wokoofu inalilufwale naterife. Te inalilufwa nenei, Jisese wolu eetegenifi lalalee nenelule finei, te ree lufwale, inalile, arile rokweefi fuenuneke, ifwatenane. ");
INSERT INTO kwo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Te Jisese glelu glelu wokoome waleeke sekaleli, te inalilufwa sakenee tekoi kokou ree tefoo panele teise ifelatelanei, tetoo Jisesele ragootume nafoonane kokou ree tefoo panele kame ooloome letelali nanoolu leeloo gueluleme ameetu geune geune ifaforife nafoonane. Te inepane eese anelu, mareteku boe metie ree tlinepoofwanane. ");
INSERT INTO kwo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Te Farisi telu Jerusalemefu rinelu, na kaisekli ramelu lufwa mare sagoo leneke wane, Jisesele wofetarife. ");
INSERT INTO kwo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wofetalanei, tetoo nalilu disaipele telule fetatene nanoo kame fwagilu ameetu kakali lelane. Nanoo Farisi nali nateneke nifetatelananelu ameele glei nifenei. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisilume pe, Judane mei mareteku, nalilu nambuanelu alinale nifetatelanane. Nanoo ame amee suwainaleteri preme lelanei glei fwagilu ameetu kakali lenane. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te sakenee tekoile waneke te rinei mei, amee suwainaleteri preme lelanei, glei fwagilu ameetu kakali lenane. Mwa. Amee telu nali nifetatelananelu mei motukwe feti letelee nali nalilu nambuanelufule peenenelu. Amee telu nanoo eetetie eese alanane, ti wapoole, ti bulue bogumweele, ti suwiele, nali tei babri babri lulanei kakali lelananelu reeafweele suwanaletenane. ");
INSERT INTO kwo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Te Farisi telu na kaisekli ramelu lufwa nali mare Jisesele eesalu fiefori lene, “Boleboe glefeme oonanoo disaipele ambuanelu alinale niferi preme lelane? Tefe kame fwagilu ameetume kakali lelane.” ");
INSERT INTO kwo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Te Jisese natelee, “Gotelu ragoofu nale alipoolaleelu lufwa Aisaia nanookoe amwime oonane namolee, oonekoe kose kose nale yefee lefomolu pane. Nanoo eetetie eesalu nale pi lelee, ‘Eetupane inalilufwa nanoo kame yemereti ragoolufe menanoo bilule ye ne ye ne ifaoolanane. Mwa. Nanoolu menengukoe fime bofoofi luane. ");
INSERT INTO kwo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tefe nanoo menane reeyemee lewori preme leneke, glelu glelu amee aoolanane kame reelufe. Nanookoe kame lufwalu menengufu Fetalilu alinale alipotelanei, tetoo nenane, eete Gotelu na nenane.’ ");
INSERT INTO kwo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mwa. Oonekoe Gotelu na kaiseklile wolu fime ameetu luamoke, te kame oonanoo ambuanelu menengufu Fetalilu alinaleme nifetelamwamo.” ");
INSERT INTO kwo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Te boe natelee, “Oonekoe Gotelu na kaiseklile futeni leforife metie yefee lefomoke, kame oonambuanelu menengufu alinaleme nifetelamwamo. ");
INSERT INTO kwo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosese nelee, ‘Oone oonanoo mianele, aianele reeyemee letelamoi tetoo kame nanoolu naleme nifetelabu. Te ine yefeeyarile eeneri nateli, eetete nanoo tafilabe.’ ");
INSERT INTO kwo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mwa. Oone na wolu natemo, ‘Inali ine, lufwa ine yesou bofoo wolu talali, te yefeeyarile nifwaterife nateleeke, te boe mwa neleeke, eese neli, “Eetegeni yesou Goteluo,” neli,’ ");
INSERT INTO kwo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","eetete nanoo yefeeyarile glei aikopi leterife nelee. ");
INSERT INTO kwo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tefe eesalu na oona telule afoi alipoofwatelamwamo, Gotelu na kaiseklile bibinatelanei, tetoo menengu futi natelanane. Eetegenileme pe, eesalu yesou telu motukwe lelee, oone letelamwamolu.” ");
INSERT INTO kwo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Te Jisese boe lukuleneke lalanelu inalilufwale natelee, “Oone mareteku bie menanoo nale amwi fiemoke, tetoo rame lebu. ");
INSERT INTO kwo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Fori yesou ambolufu lufwalu ree meneeme preipoonei, eetegeni yesou lufwale glei fwagilu ameele fanebe. Mwa. Yesou lufwalu menengufu kurulelanelu nali fwagilu amee tefoo lufwafe letenane.” ");
INSERT INTO kwo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Te inalilufwa lukuleneke lalanelu tekoole grialeleeke, te iteile waleeke, nalilu disaipele fiefoone, eetegeni na bubure yewilule alipoterife. ");
INSERT INTO kwo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Te Jisese natelee, “Tetoo oone mei mareteku menengulu preme pe lemo? Oonekoe glei pai rame lemoi, ambolufu yesou lufwalu reeme preipoonelu lufwa glei fwagilu amee tefoo lufwafe lebe. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Eete glefe? Eetegeni fori yesou glei lufwalu menengu menime wanane. Nanookoe arielume waneke boe kuruwolenane.” Eetegeni na Jisese neleelu, nanookoe nelee, Gotelu oofi glelu glelu fori yesou bofoo glei fwagilu ameetu leneke lailane, mwa. ");
INSERT INTO kwo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Te boe nelee, “Eetekoe menefu yesou kurulelanelu nali lufwale fwagilu amee fanetenane. ");
INSERT INTO kwo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Menekoe eesalu nembu nembulu menengufe nie, tukuli taneri amee, tukuli amee, merekei amee, lufwa tefoo inali, inali tefoo lufwa taneri amee, ");
INSERT INTO kwo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yeklee amee, geegeenee amee, kose kose na, tuwi menengu tekee amee, legulu na, eeneri na, oonafeme menengu lemerilu amee, te menengu yefoo yefootu alanelu amee, ");
INSERT INTO kwo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","eetegeni fwagilu amee mareteku lufwalu menengoi lainelu nali kurulelanei tetoo Gotelu oofi eetegeni lufwa fwagilu ameetu lelee.” ");
INSERT INTO kwo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisese eetegeni wokoofu furaleleeke, Tairelu wokoo porite walee. Te waleeke, ite bofoome wopreieleeke lamemelee. Nanookoe tetoo glei rame lewobile neleeke. Mwa. Jisese inalilufwale glei ambuketebe. ");
INSERT INTO kwo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nanoo waleeke itei lalaleelu nale inali bofoo wolu fielee. Ekeni inalilu lualile naifofu reeme lefoleeke ifalaleelu. Tesulume eetegeni inali waleeke Jiseselu kuli bwageime tumoinu krutupolee. ");
INSERT INTO kwo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ekeni inali glei Hibru inali, mwa. Nanookoe fime Grike inali. Nanoo Siriafu Fonisia inali. Nanoo Jisesele lualilu ree menefu naifofule grialerife nafolee. ");
INSERT INTO kwo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Te Jisese nafolee, “Nembouefe mena bie fori yesou arile molukwe nifwatebile, kose arilu fori yesou mena klifule nifwatebile mani. Mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te ekeni inali fune nafolee, “Paielu, klifu mei boole ambei alanei ari foopoolanelu mongue monguelu yekuru nelanelule mei foopoolanane.” ");
INSERT INTO kwo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Te Jisese nafolee, “Oone eese nelulufe, tefe kame wa, oonanoo autelilu reefu naifofu wolu grialeleeke walee.” ");
INSERT INTO kwo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Te ekeni inali nalilu iteile waleeke, lualile fetaleelu, naifofu te wolu grialeleeke reeafoi lulalee. ");
INSERT INTO kwo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Te boe Taire wokoo poritefu furaleleeke, te Saidone wokoo porite woleleelu, te Galili Beebe Soulule fwai nalefoleeke, Dekapolise porite woseka lelee. ");
INSERT INTO kwo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ekeise tetoo lufwa telu, Jisesele lufwa bofoole ifwafoone. Ekeni lufwa nanoo futeni arememe footepofooneke, te natu googoo googoo neleealeelu lufwale iferine. Te Jisesele fiefoone, ekeni lufwale aikopi leforife, kame nalilu ameetu geunateforife. ");
INSERT INTO kwo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Te Jisese lukuleneke lalanelu tekoofule, ambolufile ifwaleeke, te amee klifulu arememe futeni meneeme sinapofoleeke, te nalilu amee klifulufi teea bisini leleeke, te ekeni lufwalu leele geunatefolee. ");
INSERT INTO kwo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Te ekeni lufwale metie keemakee lefoleeke, lieme ooti lelali, te Aramelu natu nafolee, “Efata.” Eetegeni na yewilu eese nelee, “Fo nalepobu!” ");
INSERT INTO kwo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tesulumeme futeni fo nalepofooneke, te na mei boe amwime na nelalee. ");
INSERT INTO kwo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Te Jisese inalilufwale ekenife ble natelee, nanoo kose bofoo lufwale ekeni amee leleelu nale alipoforife. Mwa. Nanoo metie alipoofwatene. ");
INSERT INTO kwo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Te inalilufwa ekeni nale fineke, metie betige leneke te nene, “Mwange, nanoo letelee aleelu yesou mareteku metie amwime lefoonane. Futeni footepoonelutu boe amwi na fifwalanei, te natu mumu lenelu mei boe na napoofwalane.” ");
INSERT INTO kwo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Te ekenitume inalilufwa motukwememe boe pune pune afoone, tetoo nanoo fori yesou mwa, tefe nalilu disaipelele fieri nateleeke nalilufile wafooneke te natelee, ");
INSERT INTO kwo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mene metie keemakee letelaie, nanoo nianoo naleme fiemenei lie metie mwangife letelee, tefe nanoo fori yesou kakali lerilu mwa. ");
INSERT INTO kwo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mene natieke gifati nalilu wokeile wawalanei kose afoi gifefe kuli amee soosoonapoteneke oorife lebile, eete glefe, telu nanoo wokoo mokenefu ririane.” ");
INSERT INTO kwo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Te nalilu disaipele nafoone, “Menakoe fime lufwa prelu amboi alane, tetoo tabe akenifule peeneneke tupane inalilufwale nifwatebile?” ");
INSERT INTO kwo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Te fietelee, “Tetoo ooneboe tabe akake laiemoone?” Te nafoone, “Menate tabe kame tialoo mwamoleme laine.” ");
INSERT INTO kwo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Te inalilufwale inengoi lapruefwarife natelee. Te ekeni tabele peeneleeke, Gotele fiefoleeke, mongue mongue ateleeke, nalilu disaipelele nifwateleeke, te inalilufwale lemwamo letene. ");
INSERT INTO kwo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Te roree tukweetukweelu mei, mwamole mwamole lailane. Eetele mei peeneleeke, te tabele leleelu atukweme, roreele mei same leteleeke, nalilu disaipelele nifwateleeke te inalilufwale lemwamo letene. ");
INSERT INTO kwo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Te inalilufwa foopoofwaneke, metie yelu lepotenelufe, te mongue monguelule bulue ragoo letenelu 7 lene. ");
INSERT INTO kwo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te inalilufwa ekeni tabetu roreetu foopoonelu inalilufwalu ameelu 4,000 lelee. Te inalilufwale nateleeke wawalanei, ");
INSERT INTO kwo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tesulu nali mei nalilu disaipele mare braifi peepeeneneke Dalmanutalu porite wane. ");
INSERT INTO kwo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Te Farisi waneke, Jisesele fame na ifenelane. Nanoo efenefu amee yemelarilule fetarife, bofoo brege bregele lefoleeke. Ekeni amee leli, tetoo rame lefooneke, naforife marena nanookoe efenefu lufwa. Mwa. Nanookoe tetoo rame lefobile neneke, tefe irefoolane. ");
INSERT INTO kwo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Te Jisese menengu ha naleleeke, te nelee, “Boleboe oone inalilufwa mareteku mene brege brege bofoole lefoolaiei ekenile fetarife glefe nelamwamo? Mene marenafe namoolaie mene bofoole brege brege lefwieke, te eetegenile oone fetarife te mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Te Jisese grialeteleeke, braifi wopeenaneleeke, te Galili Beebe Soulu moitepoome walee. ");
INSERT INTO kwo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Te nalilu disaipele tabele menengu futi nateneke, teripori preme lene. Kame mwamole terinelu braifi latelalee. ");
INSERT INTO kwo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nanoo ame braitu walaneime te Jisese disaipelele kaisekli lelarilu nale natelee, “Oone oonafe amwime regilelabu, Farisilu tabe kwalunelule tukwe Herotelu tabe kwalunelule tukwe.” ");
INSERT INTO kwo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Te eetegeni nale nali kwaife na faleneke, te nene, “Eke neleelu na glefe, mena tabe mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te Jisese wolu rame leteleefe, tefe natelee, “Boleboe oone glefeme nemo, ‘Mena tabe mwa’ nemo? Oonekoe ame glei pai fetamoi, o glei pai rame lemoi? Mwa pai, menengu preme pe lemo? ");
INSERT INTO kwo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ootu te lemo yesou fetaterilu, te mwa pai? Futenitu te lemo na fierilu te mwa pai? Wolu menengu futi natemo pai? ");
INSERT INTO kwo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tetoo mene tabe kame yarilutume lieke te 5,000 lufwale nifwatieke, te kakali leneke, yelu lepotenelufe, te mongue monguelu grialetenelule oone bulue akake footepoome?” Te nafoone, “Bulue tialootu tialootu lene.” ");
INSERT INTO kwo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Te boe tabe kame tialoo mwamoleme lieke te 4,000 inalilufwale nifwatieke, te kakali leneke, yelu lepotenelufe, te ragoo flilu grialetenelule oone bulue akake letemo?” Te nafoone, “Bulue tialoo mwamole lene.” ");
INSERT INTO kwo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Te natelee, “Oonekoe ame glei pai rame lelamoi?” ");
INSERT INTO kwo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Te Betsaidai kuruwoleneke, tetoo lufwa telu, lufwa bofoole ifwafoone. Te ifwafooneke, te Jisesele nafoone amee fatieforife. Ekeni lufwa oo footepofooneke alaleelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Te ekeni lufwale amei beleleeke ifwalee wokoo timelume. Te ekeni lufwa oo footepofoonelule, teea amei tepoleleeke, oole ameetu sereenanefoolali, te fiefolee, “Oone yesou bofoole fetalalu pe?” ");
INSERT INTO kwo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Te oofwanepoleeke, te nafolee, “We, inalilufwale tete fetatelaie, mwa, kame ka rufwa rufwa apoolanelu yemelarilu atukwe fetatelaie.” ");
INSERT INTO kwo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Te Jisese boe same ameetu oole geunatefoleeke, te oo taki nanepofooneke, te yesoule oorinetewatelalee. ");
INSERT INTO kwo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Te nalilu iteile warife nafoolali nafolee, “Oone kose wokoome wale mani. Mwa. Kame oonanoo iteileme wa.” ");
INSERT INTO kwo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Te ekeni wokoofu fufuru ifenateleeke, Sisaria Filipai wokoo soulu bwagei lanelu wokoome ifwatelalee. Te walanei afoi Jisese nalilu disaipelele fietelee, “Menaneboe inalilufwa akeke naoolanane?” ");
INSERT INTO kwo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Te fieteleefe, te fune nafoone, “Telu nelanane, oone Jone pai Melei Pienulalulu Lufwa naoolanane, te telu nelanane, oone Elaija pai, te telu nelanane, oone bebriefe amenelu Gotelu ragoofu nale alipoolanelu lufwa paie naoolanane.” ");
INSERT INTO kwo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Te fietelee, “Tetoo oona menane ine feti naoolamwamo?” Te Pita fune nafolee, “Oone Kraise, Gote nali oonane inalilufwa eetei paie naporife namunewoleelu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Te Jisese nalilu disaipelele ble natelee, nalife, bofoo lufwale alipoforife. ");
INSERT INTO kwo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Te Jisese nalilu disaipelele boe na naterife lelali, te natelalee, “Lufwalu Lefoo ame teteree soulule, ka petilule atukwe ambukelebee. Tetoo Judafu yefeelu lufwatu, Gotelu prise yefeelutu, te na kaisekli ramelu lufwatu ame koona mufenuefooneke, te teiefooneke tafilabe. Te lie mwangifelutu boe ame furalerife lelalee.” ");
INSERT INTO kwo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nanoo ekeni nale metie lebati feti alipoteleefe, tefe Pita ekeni nale fieleefe, tetoo Jisesele neuneleeke wokoo timelume ifwaleeke, tetoo ekeni nale nerife fame lefolee. ");
INSERT INTO kwo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Te Jisese nalilu disaipelele aikoe mwi leteleeke, te Pitale ble nafoleeke, te nafolee, “Sebore lufwa, oone menanoo mwi yele. Oone glei Gotelu menengutu lalalulu lufwa. Mwa. Oonekoe fime eetegeni inengufu lufwalu menengutu lalalu.” ");
INSERT INTO kwo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Te Jisese inalilufwale tukwe, nalilu disaipelele tukwe, fieri nateleeke nalilufile wafoone. Te na natelee, “Inali ine, lufwa ine menane nifeworife neli bie menengu amwime lelali, nalilu oofulilule tepoleleeke, tetoo ree tetereele ka monguelu petilule atukwe ambukeleleeke, menane nifewobee. ");
INSERT INTO kwo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Oone ine eetegeni inengufu oofulilu, inengufu yesoufi laoolali, eetete oone Gotelu nafi yenalele. Mwa. Te ine niafe tukwe nianoo na ulu wolilule tukwe menengu leteleeke, te nalilu oofulilu eetei lafoolaleeke te tafilali, eetete nanoo ame Gotelufi paie nebe. ");
INSERT INTO kwo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Te ine eetegeni inengufu yesou aipoe aipoe leleeke, te sameme lafwalarilu oofulilule glei faleli, tetoo eetegeni yesou mareteku akeke leneke aikopi lefobile? ");
INSERT INTO kwo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tetoo eetegeni oofulilu boe falerife inali o lufwa gle yesoule Gotele faneleeke tetoo Gote fanebe? Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Inalilufwa nembue lalanelu wolu Gotele grialeneke lalane, te niafe reeyemee lewoleeke na nerife tukwe reeyemee lelali, te sabei Lufwalu Lefoo yarilu i ranilu takilu soulufi lafieleeke Gotelu ensele mare rilanei, te nanoole mei ame reeyemee lefobe.” ");
INSERT INTO kwo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Te Jisese natelee, “Mene marenafeme namoolaie, telu nanoo nembue eetei temepoolanelu, nanoo ame oofulilu lalaneime, tetoo Gotelu ameime lalarilule ame fetabile nalilu kaiseklitu lebati lelali.” ");
INSERT INTO kwo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lie wolu tialootu leleeke, tetoo Jisese Pitale, Jemsele, Jonele eesame neunateleeke afune guglufi bofoo mwai feti leleelufile peepee ifenatelee. Te ekeise nalime lalanei, tetoo Jiseselu ree oo fwafwalee bofoo ootu sekalefolee. ");
INSERT INTO kwo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nanoolu leeloo retifu metie konembu lepofooneke taki nanepofooneke ootu renapofoolane. Lufwa bofoo eetegeni inengufu nalilu leeloole glei eese leteleeke konembu feti lefobile. ");
INSERT INTO kwo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Te Elaijatu, Mosesetu kurulefooneke, te Jisesele weife na ifenelanei tetoo nalilu disaipele fetatene. ");
INSERT INTO kwo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita eetele fetaleefe, tefe Jisesele nafolee, “Paielu, nemboue feti lelee mena eetei lalarife! Sei, mena masekoni ite mwangife letemobile pe, bofoo oonanoo, bofoo Moseselu, te bofoo Elaijalu?” ");
INSERT INTO kwo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita glei rame leli glelu na wolilu nerilule, mwa. Nanoo wofri wofritu lalane. ");
INSERT INTO kwo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Te maseboo pineterieteleeke binanetelali, te ragoo bofoo ekeni maseboo menefule fiefoonelu nelee, “Eete nianoo Amete, nia nafiefoolaieaielu, oone nanoolu nale fiefobu.” ");
INSERT INTO kwo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tesulu ekepane disaipele ekeni lufwalu ragoole fineke, fetarife ange oo teme teme aneke, mwa, lufwa bofoole glei fetane. Kame Jiseseleme fetane. ");
INSERT INTO kwo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Te afune guglu mwafu titirinapooferenei, afoi Jisese fame kaisekli letelee, “Oone eetegeni yesou nembue eke fetamolule, lufwa bofoole kose alipofobule mani. Mwa. Lufwalu Lefoo bie tafilaleeke boe furalebee.” ");
INSERT INTO kwo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nanoo ekeni nale fineke, talanei, te nali kwaife na faleneke, tetoo nene, “Ekeni na ‘tafilaleeke ti menefu furalebe’ neleelu na yewiluboe glefeme nelee?” ");
INSERT INTO kwo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Te nanooboe eesalu fiefori lene, “Boe glefeme na kaisekli ramelu lufwa eese nelanane ‘Elaija molukwe bie riebee’? ” ");
INSERT INTO kwo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Te Jisese fune natelee, “Ekeni na tete marenafe nemo Elaija bie nali molukwe rieleeke, yesou mareteku amwi amwi sere letewatebe. Tetoo Gotelu bukei lalaleelu na neleelu, ‘Lufwalu Lefoo ame teteree soulule faleleeke, te lufwa ame nembulu lufwale atelananelu atukwe glelu glelu nembu nembulu ameele ifafwabile’ te glefeme eesalu na nelee? ");
INSERT INTO kwo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mwa. Mene oonane namoolaie, Elaija nanookoe wolu rielee, lufwa nali ame nalilu menenguleme nifetalanei glelu glelu amee ameele afoolane, Gote nalilu lofoofi neleelu na atukwe.” ");
INSERT INTO kwo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisese nali ifwateleelu disaipele mwangife mare boe waneke disaipele telule kuruwoleteneke, te fetatelane, inalilufwa motukwememe fwainaneteneke, lalanei, te telu na kaisekli ramelu lufwa fame natu fune na fune na alane. ");
INSERT INTO kwo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Te ekepane inalilufwa mareteku Jisese rilali fetanelufe tesulu betige lefooneke, te afetelime nalilufile waneke paie paie ifalanei, ");
INSERT INTO kwo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","te Jisese fietelee, “Ooneboe glelu nafeme fune na fune na nelamo?” ");
INSERT INTO kwo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Te ekenifu lufwa bofoo Jisesele fune nafolee, “Ramelu Lufwa, menanoo ametele naifofu bofoo ifalali, natu mumu leleeke aoolaleefe, tefe oonanoofile iferie. ");
INSERT INTO kwo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Eetegeni naifofu nali reeme lefoolali, tetie menengoi alifelali inengoi woponeleeke puputeeai ragoome lefoolanei, te neenee giginaneteleeke kulitu ameetu gigiapofoonane. Mene oonanoo disaipelele natieke eetegeni naifofule ange grialerife nafoone ifane.” ");
INSERT INTO kwo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisese ekeni nale fieleeke, te inalilufwale natelee, “Ooneboe Gotele menengoi ifelalari preme lemolu inalilufwa. Meneboe krie ameelu akake lefe mare lalarife? Meneboe krie akake ame ifelamoolaiei, tetoo oonanoo nembulule falemoolafe? Ekeni arile te iferiebu.” ");
INSERT INTO kwo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Te ekeni arile Jiseselufile ifwafoone. Te ekeni arilu reeme lefoleelu naifofu nalife ifalaleealeelu Jisesele fetaleefe, tesulu ekeni arile metie nembu nembu puleri leleeke inengoi susukoo lelali puputeeai rulelalee. ");
INSERT INTO kwo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Te Jisese yarile fiefolee, “Aketu lelali eesalu ree tetoo lefolee?” Te yari nafolee, “Ame tukweelufime alali lefolee. ");
INSERT INTO kwo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Metie sameme ekeni naifofu reeme seenalefoolali tetoo ifi mei woponebe, melei mei woponebe eese ifalaleealee tetoo tafilabee neleeke. Nemboue pe oone yesou bofoole lele, menane keemakee leluke aikopi lepole?” ");
INSERT INTO kwo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Te Jisese nafolee, “Boleboe glefe oone menengu eese nelu, ‘Mene glei pe aikopi lewofe’ nelu? Oonanoo menengu nali ‘Mene Gotele menengoi ifelalaie’ nawoli, oone yesou mareteku nemboue letele.” ");
INSERT INTO kwo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tesulu yari ragoo letaleekeme nelee, “Menengu lewie, mwa, menengu glei soume lewoli, tefe menane aikopi lewo.” ");
INSERT INTO kwo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisese fetatelalee inalilufwa motukwememe nali alanelufile pipinapoofwane. Tefe ekeni arile ifalaleealeelu naifofule nafolee, “Nembue mene naoolaie oone natu mumu leluke futeni footepolulu naifofu, oone ekeni arile grialeluke te wa, te boe kose riefole mani!” ");
INSERT INTO kwo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Te ekeni naifofu metie oomesiari napoleeke te ekeni arile metie nembu nembu puleri leleeke, te griafatieleeke walee. Te ekeni ari metie tafilaleelu atukwe lelalee. Te inalilufwa motukwememe fetanelufe tefe nene, “Nanookoe wolu pai tafilalee?” ");
INSERT INTO kwo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mwa. Jisese ekeni arile amei beleleeke boletaleeke, te temelee. ");
INSERT INTO kwo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Te iteile waleeke, nalilu disaipelele ite menei ifelatelali, te nalilu disaipele nali fiefoone, “Boleboe glesou menane gigime lelee, ekeni arilufu naifofule grialerife nafoonelule?” ");
INSERT INTO kwo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Te natelee, “Bofoo ameete mwa, kame Goteleme na woponeforilu amee nalimeme tetoo eesalu naifofule grialerife nafole. Afwee bofoo te, mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Te ekenifu nanoo fufuru neneke Galili distrikeme leneke wane. Jisese metie ulabee nelee nali lalanelu tekoole lufwa rame leterife. ");
INSERT INTO kwo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Eete glefe? Nanoo nalilu disaipeleleme na fatietefe neleeke lelali, tetoo natelee, “Lufwalu Lefoole lufwa telu ame merekei lefooneke, tafilabe. Te lie mwangifelutu boe ame furalebe.” ");
INSERT INTO kwo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mwa. Nanookoe glei rame lene ekeni na yewilu Jisese nateleelu genile, te nanoo wofri lene ekeni na neleelu yewilufe boe fiefooneke alipoterife. ");
INSERT INTO kwo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Te Jisese nalilu disaipele mare Kaperneamei kuruwolene. Te ite bofoome wopreipooneke oolalanei, tetoo nalilu disaipelele fietelee, “Ooneboe glefe afweeme fune na fune na napoferilamo?” ");
INSERT INTO kwo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mwa. Nanoole na bofoo glei gliefoone. Nanookoe metie reeyemee lene naforife afweeme nali kwaife ine bilu soulule faleleeke, latelabe neneke tefe fune na fune na napoferilanelu nafe. ");
INSERT INTO kwo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Te Jisese lafieleeke lalali, te nalilu tialootu tialootu disaipelele fieri nateleeke te natelee, “Inali ine, lufwa ine paielufe lefe neli, bie nalife reeyemee leleeke lalali, tetoo eetegeni ameefi inalilufwale aikopi letelarilu lufwafe lebee.” ");
INSERT INTO kwo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Te ari woklilu bofoole neuneleeke te babi sineleeke temelali, te ekeni ari woklilule amee fwakee letalali, te natelee, ");
INSERT INTO kwo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ine menanoo bilutu ari woklilu eesalule aikopi lefoli, nanoo menane aikopi lewolee. Nanoo menane aikopi lewoleelu, glei menaneme aikopi lewoli, mwa. Nanookoe menanoo Aiele aikopi lefolee, ine nali nawoleeke rielu.” ");
INSERT INTO kwo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Te Jone Jisesele nafolee, “Ramelu Lufwa, mene lufwa bofoole fetanelu nanoo oonanoo bilutu naifofule wawabu natelee afwatelalee. Tefe mene ble nafoone ekeni amee ameele grialeterife, nanoo glei mena mare alananelu lufwa, mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Te Jisese fune nafolee, “Oone kose ble nafobule mani, mwa. Lufwa bofoo ine menanoo bilutu brege bregele atelaleealeelu lufwa nanooboe menafe glei afeteli nembulu na nebe. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Lufwa menafe oorerei preme alanelu pane menanoofu. ");
INSERT INTO kwo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ine menanoo ameefe oonane melee yefunatu fanemoli, eetete oone Kraiselu lufwa, tefe mene marenafe namoolaie, nanoo mei fune ame sabei wolilule fetatebe.” ");
INSERT INTO kwo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Te ine eesalu arile, menane menengoi ifelaoolaleelule glelu amee lefoleeke, te ekeni ari fwagilu ameele leli, ekeni inali o lufwale, ti porulule borei mweetu krinalefoomoke, beebe meleeme woponebu. ");
INSERT INTO kwo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Te oonanoo amee nali oonane fwagilu amee lerife irewoli, ekeni ameele tekaleluke wopone. Eetete nemboue lewolee, oone tetoo kame mwamole ameetu sameme lafwalarilu oofulilule falele. Kose oonane teteree sameme falemerilu wokei woponewobile, oone amee ame arememe tapoolalu. ");
INSERT INTO kwo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Te oonanoo kuli nali oonane fwagilu amee lerife irewoli, oone ekeni kulile tekaleluke wopone. Eetete nemboue lewolee, oone tetoo kame mwamole kulitu sameme lafwalarilu oofulilule falele. Kose oonane teteree sameme falemerilu wokei woponewobile oone kuli ame arememe tapoolalu. ");
INSERT INTO kwo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te oonanoo oo mei oonane fwagilu amee lerife irewoli, oone ekeni oole ligaleluke wopone. Eetete nemboue lewolee, oone tetoo kame mwamole ootu Gotelu ameime lalarilume wopreiele. Kose oonane teteree sameme falemerilu wokei woponewobile oone oo ame arememe tapoolalu. ");
INSERT INTO kwo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ekeni wokei ‘reele foopoolananelu lisi nanoo glei troonalenane, te i rilu koomopotenanelu mei glei grialebe.’ ");
INSERT INTO kwo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Maretekume ame ekeni ree tetereele faletewalabile. ");
INSERT INTO kwo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mwi wolilu yesou feti. Naliboe lee tekaleri preme leli, tetoo oone akeke lefoluke boe lee tekalebe. Mwile bolei buletenei bole glei brinapoonane. Tefe oone mei wolilu inalilufwafe lebu eetegeni mwi atukwe, oone mare alamolu apane mei tetoo oonanoo wolilu menengufe menengu mutukwe lemoolabi.” ");
INSERT INTO kwo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisese ekenifu furaleleeke Judia porite waleeke woseka leleeke, te Jordane melee moitepome walee. Te boe inalilufwa mareteku kuruwolefoonelufe tefe nali alaleealeelu amee atukwe Gotelu nale alipotelalee. ");
INSERT INTO kwo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Te Farisi telu Jisesele irefooneke, tetoo rame leforife te waneke, eesalu fiefori lene, “Menanoo na kaisekli, inali tefoo lufwa nalilu inalile grialerife, nemboue pe lelee?” ");
INSERT INTO kwo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Te Jisese fune natelee, “Mosese oonane glelu nale namolee?” ");
INSERT INTO kwo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nanoo nene, “Mosese nemboue we nelee, lufwa inalile grialerife, kame lofooleme pi leleeke, faneleeke te wabe.” ");
INSERT INTO kwo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mwa. Jisese natelee, “Oonanoo mwate mwatefe tefe Mosese ekeni nale pi leleeke oonane fanemolee. ");
INSERT INTO kwo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Oone pane bie fiebuo, bebriefe feti Gote yesou yesoule brege letelali ‘nanoo inalitu lufwatu letelee. ");
INSERT INTO kwo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tefe lufwa yefeeyarile tukwe grialetebe, nariemule kulifi ifepooreleli, ");
INSERT INTO kwo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","eetete nanoo weife glei fime fime abile, mwa, weife wolu mwamole reefe leneke lalane.’ ");
INSERT INTO kwo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tefe Gote wolu eetegeni afweele leli, boe bofoo lufwa glei tekalefobe. Mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Te nalilu disaipele mare boe iteile waneke, te fiefoone ekeni na lufwa inalile grialerilu nafe. ");
INSERT INTO kwo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Te natelee, “Lufwa bofoo nariemule grialeleeke inali bofoole wofaleli, eetete nalilu inalile teiefolee, nanoo yemee seiko ameele lelee. ");
INSERT INTO kwo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te inali bofoo nungulile grialeleeke lufwa bofoole wofaleli, eetete nalilu nungulile teiefolee, ekeni inali yemee seiko ameele lelee.” ");
INSERT INTO kwo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Te bofoo lietu inalilufwa nalilu arile Jiseselufile ifwatefoone tetoo amee ipoi fatiefoolali Gotele na woponefolee afwatelee tetoo amwi amwi leterife. Te nalilu disaipele fetatenelufe tefe ble natene. ");
INSERT INTO kwo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te Jisese ekele fetaleefe glei paie paie atelee, mwa. Tefe nalilu disaipelele natelee, “Oone kame tupane arile ooloome letelamoi menanoofile riebi. Kose ble nanetebule mani. Mwa. Gotelu ameime lalarilu eetekoe eesalu ari keme lenelu inalilufwalu. ");
INSERT INTO kwo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mene marenafe namoolaie, ine Gotelu amei lalarife i neli preme leli, eesalu ari atukwe, nanoo glei Gotelu ameime lalarilu inalilufwafe lebe. Mwa.” ");
INSERT INTO kwo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Te ari woklilule mwamole mwamole nalilu ameetu fwakee letelali, te bofoo amee ipoi fatiefoolali Gotele na woponefolee afwatelee amwi letewaterife. ");
INSERT INTO kwo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisese ekenifu te furaleleeke warife lelali, tetoo lufwa bofoo pipi naferieleeke, Jiseselu kuli bwageime tumoinu krutupoleeke, te fiefolee, “Wolilu Ramelu Lufwa, sameme lafwalarilu oofulilule mene ake lie keme falefe?” ");
INSERT INTO kwo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisese ekeni lufwale nafolee, “Glelu yewilufe tefe menane wolilu nawolu? Goteleme wolilu leleeke lalalee. ");
INSERT INTO kwo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Oone wolu rame letelu Gotelu na kaisekli eesalu nale nelee, ‘Merekei amee preme, tukuli taneri amee preme, tukuli amee preme, yemereti inalilufwale teie teie preme, telu panelu yesou pepere preme, miele aiele waige lufwale atukwe reeyemee atelamwabu.’ ” ");
INSERT INTO kwo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tetoo ekeni lufwa nafolee, “Ramelu Lufwa, ekeni na kaiseklile ame tukweelufime alaiei nifeterietemie.” ");
INSERT INTO kwo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Te Jisese ekeni lufwale nafiefoolaleelu menengutu ooririnafoolali, tetoo nafolee, “Oone ame mwamole yesoufeme lulu nelalu, waluke oonanoo yesoule bwaleefile nifwateluke, peeneoonei, te ekeni yesoufi falelulu bwaleele te waluke nifwate inepane bwaleefe, yesoufe, lulu napoolananelule. Oone eese lelu, tetoo oone efenefu yesoufe glei lulu nele. Oone menane nifewobu.” ");
INSERT INTO kwo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te ekeni lufwa ekeni nale fieleefe kereetu falu leleeke, te oo falu falutu walee, nanoo yesou pumwai lalaleefe. ");
INSERT INTO kwo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Te Jisese nalilu disaipelele oosunetewateleeke te nelee, “Yesou pumwai lalanelu inalilufwa Gotelu ameime lalarilu inalilufwafe lerife metie gigime letelee.” ");
INSERT INTO kwo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nalilu disaipele metie betige lefoone ekeni na neleefe, mwa, boe same natelee, “Oone nianoo ari keme lemo, tefe namoolaie, mareteku metie gigime letebe Gotelu ameime lalarilu inalilufwafe lerife. ");
INSERT INTO kwo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bole kamele natenelu nanoo soume lelee. Nanoo leeloo tetoo kretepoolananelu roori meneelume preierife mwa, glei gigime lefolee, ekeni lufwa, yesou pumwai lalaleelu nanoo Gotelu ameime lalarilu lufwafe lerife gigime lefoleelu atukwe.” ");
INSERT INTO kwo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Disaipele ekeni nale fineke metie mwa, betige leneke, te nali kwaife nene, “Tetoo ine feti Gotelufi paie nelabe?” ");
INSERT INTO kwo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Te Jisese ooririnatelali te nelee, “Inalilufwale tete mwa, gigime letelee, Gotele glei gigime lefolee. Metie mwa. Nanoolume te yesou te yesoule nemboue letebe.” ");
INSERT INTO kwo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Te Pita Jisesele nafolee, “Eete. Mena bofoo yesou mena tapoolananelu yesou bofoole glei teripoone, mwa. Mena kame eesalu reetu nifeoolane.” ");
INSERT INTO kwo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Te Jisese fune natelee, “Mene oonane marenafe namoolaie, inalilufwa mareteku niafe tukwe, nianoo na ulu wolilule tukwe menengu leteleeke te eetegenife nalilu, itele, yafeeanele, yafolianele, yarianele, yefeeanele, lefoo tarile te balile tukwe grialetenei, ");
INSERT INTO kwo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Gote ame ekepanele yesou soulule feti letebe, nembue ame eetegeni inengoime lalanei. Glei bebriefe tapomenelu yesou pike nifwatebe, mwa. Ekele mei booreletene, ite aipoe, yafeeane aipoe, yafoliane aipoe, yefeeane aipoe, yariane aipoe, lefooane aipoe, te bali aipoe ame eese letewabile. Ekenitu tetoo lufwa telu ame fwagilu ameele letewatebile. Te sabei nalilu lie sekalelali nanoo ame sameme lafwalarilu oofulilule falebe. ");
INSERT INTO kwo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mwa. Nembue motukwe nambulelanelu pane nanoo sabei ame fime lebile. Te fimefu nanoo ame nambulebile.” ");
INSERT INTO kwo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisese nalilu disaipele mare Jerusalemeile warife afweeme walanei, nali nambuleteleefe, tefe nalilu disaipele fetanelufe betige lefoone. Inalilufwa nifetelanelu nanoo wofri lene. Jisese nalilu tialootu tialootu disaipelele neunateleeke te ambolufi nale alipotelalee, glelu yesou nalife sekaleforife lelaleelule. ");
INSERT INTO kwo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Te natelee, “Eete. Nembue mena Jerusalemeile walanelu, Lufwalu Lefoole ame lufwa bofoo Gotelu prise yefeelule na kaisekli ramelu lufwale seinanetebe. Te ame Romelu amei woponebile. ");
INSERT INTO kwo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ekepane lufwa nanoole ame eeneri natu teea burutu faletewalanei te babritufwaneke tetoo tafilaterife lelalee. Te lie mwangifelutu boe ame oofuli lebe.” ");
INSERT INTO kwo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ekenifu tetoo Sebedilu lefooane, Jemsetu Jonetu nanoo weife Jiseselu ootari porite wotemepooneke te nafoone, “Ramelu Lufwa, mene weife yesou bofoofe fieworife lelane, oone tetoo ekeni yesoule menane weife leporife lelalu, mene eete oonane naworife lelanelu yesoufe.” ");
INSERT INTO kwo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Te Jisese fietelee, “Oone weife glesoufe nemo?” ");
INSERT INTO kwo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Te fune nafoone, “Oone menanefu bofoole namunefo, paielu lufwafe leleeke oonanoo amee feti porite lalalee, te bofoo oonanoo aneboi amee porite lalabe, sabei oone kinefe leluke lelalu.” ");
INSERT INTO kwo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tefe Jisese natelee, “Oone weife eke fiemelu yesoufe namoolaie, oone weife ame glei amwi rame lelamoi. Mwa. Eetegeni berefu petilu eete mene ambukelerife lelaielule nemboue pe oone weife ambukelebule? Te menane koomopoworife lelaleelu ifi nemboue pe oone weife eetegeni ifi koomopobule?” ");
INSERT INTO kwo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Te nanoo weife nafoone, “Mene weife nemboue.” Te Jisese natelee, “Eetegeni berefu petilu eete mene ambuketewarife lelaielule tete oone mei weife ambuketewabule. Te eetegeni i eete menane koomepoworife lelaleelu ekeni oonane mei koomepomobe. ");
INSERT INTO kwo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nali eete menanoo amee fetifu reeafweele tukwe aneboi ameefu reeafweele tukwe oonane bilutu letemorife, eete glei menanoo yesou, mwa. Eetegeni reeafweekoe Gote nali wolu namuneteleelu lufwalule mumusi leteleelu.” ");
INSERT INTO kwo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Te disaipele yarilutu yarilutu nanoo Jemsetu Jonetu Jisesele ekeni yesoufe fiefoonelu nale fineke metie fame letene. ");
INSERT INTO kwo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisese nalilu disaipelele boe fieri nateleeke te natelee, “Oone wolu rame lemo, lufwa ipoelu lufwafe lenelu, nanoo glei Hibrufu inalilufwafe lenelu, inalilufwale ifelatelananelu nanoo metie kaisekli lelanane inalilufwa nalilu ameime lalarife. Te nalilu paielu nanoo metie inalilufwale noopoo natelanane kame nalilu naleme nifetelarife. ");
INSERT INTO kwo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ekeni amee kose oonanoofi lamoolabe mani, mwa. Ine oonanoofi paielu lufwafe o inalife leleeke lalarife neli, bie oonane amee amee lemoolarilu lufwafe o inalife lebee. ");
INSERT INTO kwo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te ine yefeelufe lefe neli, nanoo bie inalilufwale mareteku kame aikopi letelarilu lufwafe o inalife lebee. ");
INSERT INTO kwo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Lufwalu Lefoo eete rieleelu mei nanoo glei yefeelu lufwafe leleeke, tetoo inalilufwa aikopi lefori amee ameefe rieli, eie mwa. Nanoo rieleelukoe inalilufwale aikopi leteleeke, te inalilufwalu fwagilu ameefe gugulufi tafilarife rielee.” ");
INSERT INTO kwo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Te Jisese nalilu disaipele mare waneke Jerikofi kuruwolene. Te nalilu disaipele, inalilufwa mareteku nanoo Jisese mare ekeni wokoo soulule grialelanei, te Timeuselu lefoo Bartimeuse, oo footepofooneke, afwee babrilufi lalalee. Tetoo bwalee eesalu yesoufe fifieri natemeleealee. ");
INSERT INTO kwo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nanoo Nasaretefu Jisese rilaleelu nale fieleefe tefe ragoo iteritume fieri nafolee, “Jisese! Devitelu Lefoo, oone menane keemakee lewo.” ");
INSERT INTO kwo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Te inalilufwa motukwe fame lefooneke te nafoone, “Oone pepe woleme la.” Mwa. Nanookoe metie boe ragoo iteritume fieri nafolee, “Devitelu Lefoo, oone menane keemakee lewo.” ");
INSERT INTO kwo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Te Jisese fiefoleeke temelali te nelee, “Eke fieri nafoomoke riebee.” Te fieri nafooneke te nafoone, “Oone menengu kaisekli leluke, te furaleluke wa, Jisese fieri nawolee.” ");
INSERT INTO kwo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Te nalilu bebeti leelule teime woponefatilaleeke afetelime gugu tepoleeke Jiseselufile walee. ");
INSERT INTO kwo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Te Jisese nafolee, “Mene oonane ake leworife nelu?” Te nanoo fune nafolee, “Ramelu Lufwa, menekoe oo lerife nie.” ");
INSERT INTO kwo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Te Jisese nafolee, “Oone nemboue wa, oone menane wolu menengoi ifelaoolalufe tefe oonane ekeni menengu nali woli lewolee.” Tesulu nanoolu oo tupwapofoonelu esulu Jisesele afweeme nifetewalee. ");
INSERT INTO kwo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisese nalilu disaipele mare Jerusalemele roboi letewafoonei tetoo Betfage wokootu Betani wokootu lalanelufi kuruwolene. Eetegeni wokoo are Olife Afune tupulu weenetereleelufi laine. Te eetei Jisese nalilu disaipelele are warife nateleeke, ");
INSERT INTO kwo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","te natelee, “Eete, nembue oone weife eke oolalaleelu wokeile wabu. Wamoke, tesulu ekeni wokei ame lebati fetabule donki kapulu bofoole mweetu lineke lalalee. Ekeni donkile lufwa bofoo glei tepumwai lafieleeke ifwalee. Mwee klinepofoomoke, menane iferiewobu. ");
INSERT INTO kwo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te lufwa bofoo oonane eesalu fiemori leli, ‘Oone weife donkile glefe ifwalamo?’ namoli, tetoo oone fune nafobu, ‘Paielu nanoo tetoo amee amee lerife neleefe, tefe ifwalane boe sinawobe.’ ” ");
INSERT INTO kwo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Te weife waneke, donki kapulu bofoole afwee babrilufi lalali fetane, ite ambleni bofoo bwagei linelule. Te weife mweele klinepofoolanei, ");
INSERT INTO kwo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tetoo lufwa telu ekei temepoolanelu te fietene, “Oone weife ekeni donkile ake ifelerife, tefe mwee klinepofoolamo?” ");
INSERT INTO kwo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Te Jisese nateleelu nale weife teleme natene. Tefe kame ooloome letelanei, ifwane. ");
INSERT INTO kwo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te weife donkile Jiseselufile iferiefooneke, te bebeti leelu wamolulule liganuneke donki mwai bofuenuneke, te Jisese tepumwai bolafielee. ");
INSERT INTO kwo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Inalilufwa motukweme nalilu bebeti leelu wamolulule liganufwaneke te afweeme fuenufwane. Te telu nanoo balifile wawaneke, ka merilu fulu tefoole kreeoonapooneke afweeme fuenufwane. ");
INSERT INTO kwo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Te inalilufwa Jisesele nambulefoonelutu fimelefoonelutu mareteku unetewafoonei, sabitu faletewafoonei eese nafwafoone, ");
INSERT INTO kwo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Gote amwi lefobee, eetegeni kine menafe ifelapoolarife lelaleelule Nanoo Devitelu nambuelufu rilaleelu kine ");
INSERT INTO kwo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Te Jisese Jerusalemei woseka leleeke, te Gotelu itefu geenerime walee. Te yesou yesoule mareteku oosunetewatelali, mwa, oo nali wolu pinalerife lelaleefe tefe nalilu tialootu tialootu disaipele mare Betanifile boe wane. ");
INSERT INTO kwo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Te kwotukriei Betanile grialeneke walanei afoi Jisese gife lefolee. ");
INSERT INTO kwo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Te nali ka fikele fetalee fulu aipoe leleeke afwee babrilufi wotemelali. Te nanglilufile wafolee ooloole oorateleeke tetoo fooporife. Mwa. Bofoo glei lalali fetalee. Kame fulu aipoe aipoe leleeke, ooloo preme temelalee. Eete glefe? Eete glei ekeni ka oolootu lerilu lie. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tefe Jisese ekeni kale nafolee, “Oone glei boe oolootu leluke tetoo inalilufwa pufwaneneke foopobile. Mwa feti.” Ekeni na neleelule nalilu disaipele wolu fiefoone. ");
INSERT INTO kwo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisese nalilu disaipele mare waneke, Jerusalemei kuruwoleneke, te Jisese waleeke Gotelu ite geeneri amblenime wopreielee. Te ekeni tekoi sakenee amee alanelu lufwale fame na natelee, ekeni tekoole grialeneke wawarife. Te bwalee ooloo eetei luaneke fune fune alanelu boolele, kaulefu bolu eetei sinateneke lailanelu boolele tukwe pule pule afwateli yekurunapoofwane. ");
INSERT INTO kwo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te boe yesoule peeneneke Gotelu ite geeneri meneile tewapo, teripo ifatelarife kaisekli fame letelee, ");
INSERT INTO kwo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","tetoo natelee, “Gotelu bukei neleelu na, ‘Menanoo ite kame temelali, latelarife lelalee inalilufwa te fu te fu ririalanei tetoo menane eetei na woponeoolarife.’ Mwa. Oonekoe metie wolu tukuli lufwalu itele atukwe ifelemo.” ");
INSERT INTO kwo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Inalilufwa mareteku nanoo na natelaleealeelule metie betige feti lefoonane. Tefe Gotelu prise yefeelutu, na kaisekli ramelu lufwatu eesalu ameele fetafoonelufe, metie wofri lefoone. Tefe na ambeme falefoolane tetoo merekei lefooneke tafilarife. ");
INSERT INTO kwo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Te feiferilufe, Jisese nalilu disaipele mare ekeni wokoo soulule grialeneke wane. ");
INSERT INTO kwo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Te Jisese nalilu disaipele mare boe kwotukrieime walanei, tetoo ekeni fikele fetane te wolu falu leleeke temelalee. ");
INSERT INTO kwo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jisese ekeni kale nafoleelu nale Pita menengu lefoleeke te nelee, “Paielu, eke feta! Oone morietu nafolulu ka, wolu falu lelee.” ");
INSERT INTO kwo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisese fune natelee, “Oone Gotele menengoi ifelalalu. ");
INSERT INTO kwo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ine ekeni afunele nafoli, ‘Oone ekenifu, te kulukwaleluke mwi meleefi prunale’ nafoli, ekeni inali o lufwa Gotelufime menengu ifelalali tete nemboue, nali eke leleelu menengu atukwe ekeni yesou ame sekalefobe. Tefe mene marenafe namoolaie, ekeni yesou Gote ame lefobe. ");
INSERT INTO kwo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Oone na woponefoomwamo yesou bofoole falerife, oona menengu lemoi, eetegeni yesou ame falebile, eetete mene marenafe namoolaie, oonanoo menengu fime ekeni yesoule ame fanemobe. ");
INSERT INTO kwo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Oona temepomoke Gotele na woponefoolamoi, te lufwa bofoo oonane glelu fwagilu amee lemoleelule oona menengu letemoi, oona bie ekeni lufwalu fwagilu ameele wogrinatefobu. Tetoo oonanoo Aie efenefu mei oonanoo fwagilu ameele wogrinatemobe.” ");
INSERT INTO kwo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Te Jisese nalilu disaipele mare Jerusalemei boe kuruwoleneke te Jisese Gotelu ite geeneri amblenime wopreieleeke wari alali, tetoo Gotelu prise yefeelu, na kaisekli ramelu lufwa, Judafu yefeelu lufwa mare waneke Jisesele wofetane. ");
INSERT INTO kwo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Te eesalu fiefori lene, “Ooneboe ekeni ameele alalulu oone akenifuleme faleluke tetoo ekeni yesoule letelalu? Ekeni amee alalulule ine eetegeni ameele ala nawolee?” ");
INSERT INTO kwo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Te fune natelee, “Mene oonane fiemoolaie. Eetegenife oone menane namoi, tetoo mene mei oonane namofe ine menane eetegeni ameele nemboue alarife nawoleelule. ");
INSERT INTO kwo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jone Melei Pienulaleelu Lufwa, ekeni lufwalu amee efenefu amee, o inengufu lufwalu amee? Sei, te nawobu.” ");
INSERT INTO kwo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Te nali kwaife na falene, “Mena, ‘Efenefu amee’ nafoonei, nanoo kose menane nebe, ‘Tetoo oone nanoo alipomoomeleelu nale glefe fiefori preme lemo?’ ");
INSERT INTO kwo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mwa. Mene, ‘Inalilufwalu amee’ nafoonei mei, mwa.” (Nanoo nenelu glefe, inalilufwale wofri letene. Inalilufwa Jonele wolu rame lefoone, nanoo Gotelu ragoofu nale alipoolaleelu lufwa.) ");
INSERT INTO kwo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tefe Jisesele kame nafoone, “Mene glei rame lene.” Te Jisese fune natelee, “Mene mei, mwa, oonane glei namofe ine menane eetegeni amee nemboue alarife nawoleelule.” ");
INSERT INTO kwo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Te Jisese eesalu na bubure natelee, “Bofootu, lufwa bofoo waine bali bofoole lemeleeke, te ekeni balile fee fwai ifenaleleeke, te waine ooloole eetei tainepoolanei afelepoolarilu bikale leleeke, te lufwa eetei lalanei ekeni balile regi lefoolarilu itele tuelee. Te ekeni balile lufwa telule masekonife seinatelee nalife tetoo bwalee eetei falelarife. Te bali yari nali grialeteleeke, wokoo mokeneileme walee. ");
INSERT INTO kwo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te waine ooloo wi lepoolanelu lietu, bali yari nali nalife amee amee afoolaleelu lufwa bofoole nafoleeke walee ekeni waine balile ifelalanelu panelufile. Nanoo tetoo ekeni balifu fori yesou telule nifwabile neleeke. ");
INSERT INTO kwo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mwa. Ekeni balile ifelalanelu pane, ekeni lufwale metie beleneke te babrituneke te nafooneke boe kame eesalu reetu walee. ");
INSERT INTO kwo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Te boe amee amee lufwa bofoole nafoleeke ekepanelufile walee. Te ekepane balile ifelalanelu pane, ekeni lufwale ipoi neebuluneke, te eeneritu tekalene. ");
INSERT INTO kwo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Te boe bofoole nafoleeke walee. Ekeni lufwa waleelu mwa, ekepane metie teiefoonekeme tafilalee. Te boe amee amee lufwale motukwememe nateleeke wane ekepane lufwa waine balile ifelalanelufile. Te tupane nanoo telule kame babritupoone, te telule teieteneke troonalene. ");
INSERT INTO kwo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Te bofoo lufwa kame nalime lalalee. Ekeni lufwa nalilu lefoo metie nafiefoolalee. Mwa. Nanookoe fimelufe nafoleeke, waine balile ifelalanelu panelufile walee. Yarikoe eese neleeke, ‘Nanoo nianoo ametelu nale ame fiefooneke oolume lefobile.’ ");
INSERT INTO kwo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mwa. Ekepane lufwa waine balile ifelalanelu, nanoo nali kwaife na falelanei, te nene, ‘Ekeni lufwa yarilu yesou mareteku kose peenebe. Sei! Mena teiefooneke tafilabee, tetoo eetegeni balifu yesoule mareteku menafe peenebile.’ ");
INSERT INTO kwo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Te neunenelu esulu metie teiefooneke, tafilalee. Te nanoolu ree tupulule faleneke bali timelume woponene. ");
INSERT INTO kwo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Te bali yari ekepanele akeke letebe? Nanookoe ame rieleeke ekepanele teieteleeke troonalebile. Tetoo ekeni balile lufwa telule fanetebe. ");
INSERT INTO kwo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ooneboe eesalu na Gotelu bukei pi lenelule fetamo pe: ");
INSERT INTO kwo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Paielu nali ekeni yesoule leleeke tetoo mene fetanelu metie menanoo oofi fime ootu lelee.’ ” ");
INSERT INTO kwo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Te Gotelu prise yefeelu, na kaisekli ramelu lufwa, Judafu yefeelu lufwatu nanookoe wolu rame lene, Jisese eke nelaleelu nakoe fime nalife natelalee, tefe ange belerife lenelu. Mwa. Inalilufwale wofri letene, tefe kame grialeneke wane. ");
INSERT INTO kwo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Te waneke, Farisi telule tukwe Herotelu poritefu lufwa telule tukwe nateneke, te Jiseselufile wane, nanoo bofoo natu irefooneke te nembulu nale neli tetoo belerife. ");
INSERT INTO kwo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Te ekepane nanoo waneke, te nafoone, “Ramelu Lufwa, mena wolu oonane rame leoone, oone glei kose kose na tefoo lufwa. Mwa. Tetoo oone lufwa bofoole mei glei wofri lefolualu. Mwa. Oone inalilufwa bilu tefoole o bilu prelule mareteku oone na nembulu bofoole glei woponetelualu. Oone inalilufwale Gotelu nale alipotelalualu, marena naleme alipotelalualu. Tetoo oone menengu ake lelu? Mena Sisarele bwalee fanerilu amee nemboue pe lelee? ");
INSERT INTO kwo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mena fanebile pe?” Mwa. Jisese wolu rame letelee, nanoolu kose kose nale tefe natelee, “Boleboe menane glefe ireoolamo? Bwalee bofoole teriemoke bie mene fetafe.” ");
INSERT INTO kwo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Te bwalee bofoole tewafooneke wofanene. Te fietelee, “Eetegeni yemelarilutu bilutuboe inelue?” Te nafoone, “Sisarelu.” ");
INSERT INTO kwo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Te ekepane lufwale natelee, “Sisarelu yesou eetete nanoo mei Sisare nalife boe nifwabu. Te Gotelu yesou nanoo mei Gote nalife nifwabu.” Ekepane nanoolu nale fiefooneke metie betige lefooneke wane. ");
INSERT INTO kwo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Te nanoolu mwi Sadyusi telu nanoo Jiseselufile wane. Ekepane lufwa nanoo eese nelananelu pane, troonalenelu pane boe glei fufuru nebile. Mwa. Te waneke Jisesele wofiefoone, ");
INSERT INTO kwo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ramelu Lufwa, Mosese na bofoo menafe pi leleelu eese nelee, ‘Lufwa bofoo ine inali faleleeke kame ari preme tafilali, ekeni lufwalu moo, yafeelu seikolule falebee tetoo weife lunei, te ekeni ari tetoo yafeelu bilutu lalabe.’ ");
INSERT INTO kwo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Te bofootu, mwamole fweelufu ari kapore tialoo mwamole leleeke amene. Yafee tolu lufwa nanoo molukwe inali faleleeke, te nanoo kame ari preme tafilalee. ");
INSERT INTO kwo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Te ekeni lufwalu seikolule temwifu lufwa falelee. Nanoo mei same metie ari prememe tafilalee. Te boe babifu lufwa mei sameme lelee. ");
INSERT INTO kwo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tefe ekepane lufwa ifafwaneke, maretekumeme ari prememe troonaleneke, te ekeni inali mei fimelufe tafilatelee. ");
INSERT INTO kwo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Te sabei troonalenelu pane boe fufuru nenei, ekeni inali inelu lufwafe lafoolabe? Oone wolu rame lelu, lufwa tialoo mwamole ekeni inalileme, nanoo falelee, nanoo falelee ifane.” ");
INSERT INTO kwo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Te Jisese natelee, “Oonekoe Gotelu bukei lainelu nale glei rame letemo. Mwa. Tetoo Gotelu kaiseklilule mei glei rame lefomoi. Mwa. Tetie ekeni yewilufe tefe oone mumu apoolamo. ");
INSERT INTO kwo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Te wolu troonalenelu inalilufwa boe fufuru nenei, ekepane boe glei inali o lufwa peenebile. Mwa. Nanookoe Gotelu ensele, efenei lalanelu keme kame preme alarife lelane. ");
INSERT INTO kwo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te inalilufwa troonaleneke boe fufuru nerife lelanelu na, oone Mosese pileleelu nale glei pai rame lemoi. Ka tukweelufi i rinelali, Mosesele Gote nafolee, ‘Nia Abrahamelu, Aisekelu, Jekopelu Gote ame lalaie.’ ");
INSERT INTO kwo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gote glei troonalenelu inalilufwalu Gote lalalee. Mwa. Nanookoe oofulilu lalanelu inalilufwalu Gote lalalee, tefe oonekoe metie mumu apoolamo.” ");
INSERT INTO kwo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Te na kaisekli ramelu lufwa bofoo waleelu nale fietelalee, Sadyusiane Jisesele na ifenelanei. Te Jisese nateleelu nale fiefoleelu nanoolu futenei metie nemboue lefolee. Tefe Jisesele fiefolee, “Glelu na, na kaiseklile mareteku booreletelee?” ");
INSERT INTO kwo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisese fune ekeni lufwalu nale fiefoleeke te nafolee, “Na kaisekli nale mareteku booreleteleelu eetetie eetegeni, ‘Israele, fiebu, Paielu nanoo menanoo Gote, nanoo nalimaku Paielu. ");
INSERT INTO kwo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Oone Goteleme nafiefoolamwabu, nanoo oonanoo Paielu, oonanoo menengulutume, wopulutume, ramelutume, kaiseklilutume nafiefoolamwabu.’ ");
INSERT INTO kwo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Te temwifu na kaisekli eetegenitu tapuru leleelu eetetie nelee, ‘Oone mwamole tikliafofule nafiete, eke oonafe nafilalualulu atukwe.’ Eetegeni na kaisekli are metie telu telu na kaiseklile mareteku booreletene.” ");
INSERT INTO kwo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Te ekeni na kaisekli ramelu lufwa Jisesele nafolee, “Ramelu Lufwa, nemboue, oone marenafe nelu, Gote tete mwamole, gote bofoo mwa. ");
INSERT INTO kwo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mena menanoo menengutume, ramelutume, kaiseklilutume, Gotele nafiefoolanabile. Te menafe nafilananelu atukwe, mwamole tikliafofule mei eetutume nafietelanabile. Mena eetegeni na kaisekli are eetegenile nifetelanei, eetegeni amee, bolele tome ifi tuneke isokwi bri lefoonanelu ameele mei booreletelee. Tetoo telu telu amee Gotele lefoonanelule mei booreletelee.” ");
INSERT INTO kwo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisese ekeni lufwa nanelali fiefoleelu, nanoolu na wolilu ramelu tefoo lufwa nelanelu na keme lefolee, tefe Jisese nafolee, “Oone Gotelu ameime lalarilu glei mokenei lelalu, mwa.” Boe sabei mei lufwa mare bofoo yesoufe fieforife wofri lene. ");
INSERT INTO kwo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisese ame Gotelu itelu geeneri menei Gotelu nale inalilufwale alipotelalime, tetoo fietelee, “Boleboe glefeme na kaisekli ramelu lufwa eese nelanane, ‘Kraise nanoo Devitelu lefoo’ nelanane? ");
INSERT INTO kwo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wolilu Fifri Devitele menengoi seenalefoolali tetoo Devite nelee: ");
INSERT INTO kwo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devite nali ekeni lufwale nafolee, ‘Nanoo nianoo Paielu.’ Tefe boe akeke leleeke ekeni lufwa Devitelu lefoofe lelee?” Inalilufwa metie motukwememe Jiseselu nale fiefoomerife paie paie amene. ");
INSERT INTO kwo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisese ame na natelalime, eese natelee, “Fwai, oone kose na kaisekli ramelu lufwa alananelu ameele nifetelabule mani, nanoo leeloo wolilu wamolulule sisileteneke wari alanane sakenee tekoi inalilufwa fetateneke tetoo, paie paietu na glietenarife. ");
INSERT INTO kwo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te Judanelu alina itei inalilufwa tetoo fetaterife nali molukwe nambuluneke ootari poritefu reeafoi oolapruelenane. Te soulu kakali lietu nanoo molukwe bilu tefoo lufwalu reeafoi laprueleneke lalanane. ");
INSERT INTO kwo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nanookoe seikolu inalilu yesou peperefe yefee feti lefoone. Nanoole tetoo fetatelarife kose kosefe inalilufwalu oofi Gotele na woponeforife, metie mwee glieri lemenane. Eesalu lufwa teteree glei tukweeme peenebile, lufwa telu peenerife lelanelu atukwe. Mwa feti.” ");
INSERT INTO kwo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisese inalilufwa, Gotele bwalee fanenanelu tekoi, moporite amee oolafieleeke lamemeli, inalilufwale fetatemelee bwaleele auei lualanei. Te bwalee tefoo pane nanoo bwalee seselime luane. ");
INSERT INTO kwo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te seikolu inali bofoo rieleeke koko bwalee ooloo are bwalee auei lualee. ");
INSERT INTO kwo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisese nalilu disaipelele fieri nateleeke, tetoo natelee, “Futeni amwi lelamoi filabu, seikolu inali feepoelu bofoo fetaielu koko bwalee ooloo areme auei lualee, ekeni seikolu inali feepoelu bwalee soulule fatielee, bwalee tefoo pane luanelu bwaleele booreletelee. ");
INSERT INTO kwo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ekepane lufwa bwalee soulu ame laietenei te kame tapoolaneluleme bwalee auei luane. Ekeni inali bwalee letifelu bofoo glei lafoolalee, mwa. Kame koko bwaleeleme ooloo are tatukwe lualee.” ");
INSERT INTO kwo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisese Gotelu ite geenerile grialeleeke walali, tetoo nalilu disaipele bofoo nafolee, “Ramelu Lufwa, bie fetate, ekeni ti glei tukweetukweelu, metie poru porulu. Boe glelu ite metie wolilu pilutu oofwainalepoolane.” ");
INSERT INTO kwo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Te Jisese fune nafolee, “Ooneboe ekeni ite sosoulule pe fetatelalu? Te ekeni ti poru porulu eke rigani letakumoonelu, boe glei pume ambei aneke same lailabile. Mwa. Eetete ame maretekume yekuru neneke tetoo fime fime aneke lailabile.” ");
INSERT INTO kwo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Te Jisese nanoo Olife Afune tupulufi lafieleeke lameli, te Gotelu ite geenerile oowafoomolee. Te Pita, Jemse, Jone, te Andru, nalime tetoo angime fiefoone, ");
INSERT INTO kwo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Sei! Oone bie menane napo, glelu ootu ekeni yesou oone nelulu kurulebile? Bie glelu oofwafwaleele molukwe fetalanei, tetoo rame leneke, eetegeni krie wolu roboi lelalee nebile?” ");
INSERT INTO kwo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Te Jisese fune natelee, “Oone oonafe amwi amwime regilelabu, kose oonane lufwa kose kose nale namobile mani. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lufwa motukwe ame rineke, menanoo bilule rufoeneke, tetoo oonane ame namobile, ‘Mene eetetie eetegeni Lufwa Nali!’ Nanoo ame inalilufwale kose kose natu naferietenei, tetoo ame menengu runalepoteneke, nifetebile. ");
INSERT INTO kwo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Te oone sabei, soulu apure leri lelanelu na ulule filamoi, oonanoo menengu kose ti napomobile mani. Mwa. Ekeni yesou bie kuruletewabi, tetoo nembuari lerilu kriekoe ame. ");
INSERT INTO kwo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bofoo na tefoo wokoo ame bofoo na tefoo wokoole ifapureletebile. Te telu kinelu pane mei ame bofoo geni kinefu panele ifapureletebile. Tewokoo tewokoo ame alineri afwatebe, te telu ame fori yesou gifefe troone troone abile. Eetegeni yesou maretekukoe, inali nembuame ari roboi letelanei luponuerife alananelu tetereele atukwe faletewarife lelane. ");
INSERT INTO kwo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Te ekeni krietu, oone mei oonafe amwime regilelamoi alabu. Nanoo ame oonane yemereti bebenamooneke, nalilu wokoofu paie paielu lufwalufile ifwamobile. Te nanookoe yemereti oonane Judanelu alina ite menei ame babritupomobile, menanoo bilule tetoo bibinebile neneke, oonane ame ifwamooneke eetegeni inengufu yefee yefeelu lufwalu oofi, kinelu oofi wotemepobule. Tefe oone ekenitume tetoo menanoo na ulu wolilule alipotebule. ");
INSERT INTO kwo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ekeni na ulu wolilu bie wokoo wokoo fifwabi. ");
INSERT INTO kwo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Te oonane bebenamooneke, eetegeni nafe fifieri namorife ifwamoonei oone kose wofri lelamoi, menengu are lebule mani, ‘Menaboe glelu naleme nebile.’ Mwa. Glelu glelu na mareteku Gote nali ekenitumeme namoleelule, oone alipotebu. Eete glefe? Eetegeni glei oonanoo menengufu nale nerife lelamoi, mwa, eetekoe Wolilu Fifri nali seenalemorife lelalee. ");
INSERT INTO kwo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mwamole fweelu nalime boe ame amburenuneke nalilu fweelule merekei leteneke troonalebile. Te yariane mei ame nalilu arile eesalu ameeleme letebile. Te ari mei yefeeyarile geegeenee letelanei, te merekei letenane, tetoo telu asulu leteneke te troonalebile. ");
INSERT INTO kwo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Inalilufwa mareteku oonane ame nembuari feti lemorife lelane, oone menanoofu pane. Inalilufwa eesalu ameele buruaneterietelanekeme, eetegeni inengu mwa lerilu kriei kuruwolenei, nanoo ame Gotelufi paie napobile.” ");
INSERT INTO kwo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisese boe nelee, “Oone ‘ree wofri tefoo yesou nembulule’ ame fetabule. Ekeni yesou nembulu wokoo bi nafoonelufi temelalee, (ine eetegeni nale fetali amwimeme menengutu talabee). Ekenitu inalilufwa mareteku Judiai lafwalanelu, bie afune mwaile brunetewabi. ");
INSERT INTO kwo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lufwa ine tikifi lalali boe kose furaleleeke nalilu yesoule peenerife ite meneile wopreiebe mani. ");
INSERT INTO kwo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te lufwa ine balifi oolalali nanoo mei boe kose nalilu leeloole falerife iteile wabe mani, mwa. ");
INSERT INTO kwo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Te ekeni krietu ari bootefu inalile tukwe, ari totoo foopoolanelule tukwe, keemakee letebu nanoo nembulufi lalarife lelane. ");
INSERT INTO kwo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Te Gotele na woponefoolabu, ekeni yesou klomwee krietu kose sekalebe. ");
INSERT INTO kwo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ekeni krie oo nembulu soulu rierife lelalee, bebriefe Gote yesou mareteku brege woleteleelu krie aferilaleeke oo nembulu nembue lalanelu krietu eesalu oo nembulu bofoo glei sekalelee, mwa. Tetoo sabei mei mwa, eesalu oo nembulu boe glei sekalebe. ");
INSERT INTO kwo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ekeni oo nembulu sekalerilu ameelu Paielu boe glei yeirelebe, eetete inalilufwa maretekume glei paie napobile. Mwa. Nanookoe inalilufwale nali wolu namuneteleelule menengu letelee, tefe nanoo ekeni oo nembulule yeirelebe. ");
INSERT INTO kwo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Eetegeni ootu inali o lufwa bofoo ine oonane namoli, ‘Kraise wolu eete lalalee!’ o ‘Ute oolalalee!’ namoli, oone kose ekeni nale fiefobule mani. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Lufwa telu ame rineke, kose kosefe namobile, ‘mene kraise, o Gotelu ragoofu nale alipoolaiaielu lufwa’ eetetie namooneke, brege bregele, te telu yesou mei fime bofoo oofwafwaleetu letelabile. Mene marenafeme namoolaie, nali nemboue nenei, Gote nali wolu namuneteleelu inalilufwalu menengule metie teme teme ifatebile. ");
INSERT INTO kwo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Oone bie oonafe amwime regilelabu, mene wolu naferiemwie yesou mareteku sabei kurulerife lelanelule.” ");
INSERT INTO kwo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jisese boe nelee, “Ekeni ritilu kurulelanelu krie bie tatukwe waleeke, te ekeni krietu, ‘te lie ame pinaleleeke, te wosi mei mwa, glei taki nalebe, ");
INSERT INTO kwo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","te limwafu mei fooroonetewabile, te kaiseklilu yesou efenefu mei reenapobile.’ ");
INSERT INTO kwo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tetoo Lufwalu Lefoo paie tefoo paielu lufwafe leleeke nalilu selilu kaiseklilutu, Gotelu ranilu masebootu taki neterieli, tetoo inalilufwa ame fetarife lelane. ");
INSERT INTO kwo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tetoo nanoo ame nalilu enselele nateleeke, nali wolu nalife namuneteleelu inalilufwaleme neune neune afwateneke, tetoo eetegeni inengutu, lietu lemeleelu atukwememe luku ifeletebe. ");
INSERT INTO kwo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Oone ka fikele rame letebu, nanoo klomweefe fulu fooroonalelanane, te fulu boe kekenapoofwalanei fetatelamoi eetete rame lebu, nambwi lie sekalerife lelalee. ");
INSERT INTO kwo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eetutu te oone ekeni yesou lepoolanei, fetatelamoi, eetete rame lebu, Lufwalu Lefoolu krie wolu rieleeke, ambleni bwagei lalalee. ");
INSERT INTO kwo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mene marenafeme namoolaie, ekeni krietu nembue eete lalanelu inalilufwa ame troonaleri preme lelaneime, tetoo eetegeni yesou mareteku kurulebile. ");
INSERT INTO kwo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lietu inengutu tatukwe ame mwa lebile, menanoo naleme marekulitu lafwalarife lelalee. ");
INSERT INTO kwo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ekeni yesou kurulerilu kriele tukwe, wosile tukwe lufwa bofoo glei rame lepoleteli mwa. Gotelu enseletu, Lefootu mei, mwa, glei rame lene. Aieleme rame lelee. ");
INSERT INTO kwo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tefe oonafe oo mwame lelamoi regilelabu, oone glei rame lemo ekeni yesou sekalerife lelaleelu kriele. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eetutu lerife atukwe, lufwa bofoo, nalilu itele grialeleeke bofoome warife lelali, te itele ifelafoolaleelu lufwale glelu amee amee lelarilule mwamole mwamole lufwale natelaleeke walee. Te amblenile ifelafoolaleelu lufwale nafolee amwime regilelali ifelalarife. ");
INSERT INTO kwo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tefe oone oonafe amwime regilelabu. Oone glei rame lefomoi ite yari rierife lelaleelu kriele. Mwa. Nanoo feiferi lietu pe sekalebe, o krie babi pe, o wokime ambeme pe, o kwotukriei pe. ");
INSERT INTO kwo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kame afeteli yesekapoleli oone kose rofufe ame lulalume fetawobe. ");
INSERT INTO kwo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Eetegeni na eete mene oonaneme glei namoolaie, eie, mwa, eetekoe inalilufwale mareteku natelaie, oone oo mwai lelamoi lalabu!” ");
INSERT INTO kwo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tetoo Gote Israelele Ooloome Leteleelu Liele tukwe, Tabe Leeloo Foopori Liele tukwe, laprueleneke menengu letelanei paie paie aterife lelanelu lie ameelu, ame are laietelane. Tetoo ekeni ambeme Gotelu prise yefeelutu, na kaisekli ramelu lufwatu, Jisesele irefoolane beleneke, tetoo teiefooneke tafilabee neneke. ");
INSERT INTO kwo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Te boe nene, “Mena kose eesalu ameele ekeni seselilu kakali letewanelu lietu lebile mani. Eetete inalilufwa menafe fetaneke, kose fame na neneke, apurelebile.” ");
INSERT INTO kwo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisese wokoo Betanifi Saimonelu itei lalalee. Nanoo bebriefe seklai seklai reetu leleeke ameleelu lufwa. Te nanoolu ite menei laprueleneke, lalanei tetoo inali bofoo walee, ekeni inali nanoo titu lenelu botole wolilu feti, wolilu seralu tefoo meleele terielee. Bwalee mwai letenanelu genile. Te ragoolule kulukwaleleeke Jisesele ipoi susunafolee. ");
INSERT INTO kwo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lufwa telu mare lalanelu ekele fetaneke, mwa, nanoolu menengu glei nemboue letene, mwa, tefe nali kwaife nene, “Boleboe glefeme ekeni melee seralu tefoole teiefolee? ");
INSERT INTO kwo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mena kame bwaleefile faneteneke falenei mena nemboue senene bwalee 300 falerife lenelu, tetoo eetegeni bwaleele feepoe lenelu panele aikopi leterife lenelu.” Tefe ekeni inalile fame na ifenelanei, ");
INSERT INTO kwo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","te Jisese natelee, “Oone ekeni inalile grialebu. Ooneboe glefe nanoolu menengule teiefoolamo? Nanookoe menane amee wolilule lewolee. ");
INSERT INTO kwo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Feepoelu panetu ame mare lalabule, glelu krietu aikopi leterilu menengu furalemoli, kame aikopi letebu. Menete mwa, oone mare glei same lalabile. ");
INSERT INTO kwo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ekeni inali nanoo glelu yesou lerife neleelu, wolu lelee. Nanookoe wolilu seralu tefoo meleelule menanoo reefi sunalewoleelu eetete ti menefu ree tupulu yemeelu lalali sese nelarife sere lewolee. ");
INSERT INTO kwo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mene marenafe namoolaie, eetegeni inengoi lapruefwalanelu inalilufwale, menanoo na ulu wolilule alipoofwatelanei, te eetegeni inali eese leleelu nale mei ame alipotelabile tetoo menengu lefoolarife.” ");
INSERT INTO kwo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ekenitu te nalilu tialootu tialootu disaipele bofoo, Judas Iskariote, nanoo Gotelu prise yefeelule waleeke wofetatelee, Jisesele seinaterife. ");
INSERT INTO kwo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tupane ekeni nale fineke mwa, metie paie paie apoone. Te na sere lefoone bwaleele fanerife. Te esulu Judase nanoo Jisesele seinateri afweele oorafoolalee. ");
INSERT INTO kwo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tabe Leeloo Foopori Lie molukwe sekalelee. Eesalu lietu tetoo bole ameflee sipsipe kapulule puketeneke te tupwaneke foopoolanei, tetoo Gote Israelele Ooloome Leteleelu Liele menengu lefoolanane. Te disaipele Jisesele fiefoone, “Oone menengu lelalulu, mene waneke ekeni liele sameletelananelule kakali leri yesoule akenifime mumusi letebile?” ");
INSERT INTO kwo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jisese nalilu disaipelele are nateleeke warife lelanei, te natelee, “Oone weife wamoke ekeni wokei kuruwolemoi, te lufwa bofoo ame besuani ifelemobe, meleele bregeetu terilali, ekeni lufwale nifetewabu. ");
INSERT INTO kwo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Te nifetewamoke, nanoo ite meneile breelelali fetamoi, tetoo ite yarile weife nafobu, ‘Ramelu Lufwa nelee, Mene nianoo disaipele mare Gote Israelele Ooloome Leteleelu Liele fori yesou ekeise foopoolanei tetoo menengu lefoolarife lelanelu gue menanoo ake porite lalalee?’ nafobu. ");
INSERT INTO kwo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nanoo ame fetou namorife lelalee mwafu guele lapruelerilu reeafweetume, booletume wolu sere letenelule. Tetoo oone weife ekeise mena kakali leri yesoule sere letebu.” ");
INSERT INTO kwo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Te nateleeke, te weife wane. Te weife wokoo soulufi kuruwoleneke, yesou mareteku fetatenelu, Jisese nali nateleelu na atukwememe leneke lailane. Te weife ekei fori yesoule sere letene. ");
INSERT INTO kwo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Te feiferi lietu, Jisese nalilu disaipelele tialootu tialootu ifwatelee. ");
INSERT INTO kwo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Te boolei lapruefwaneke, kakali lelanei, tetoo Jisese natelee, “Mene oonane marenafe namoolaie, lufwa bofoo oonanoofu eetei mare lalamolu, nanoo menane ame oorerei leoolanelu panelu amei si oonawobe. Nembue mene weife eetetie kakali lelane.” ");
INSERT INTO kwo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Te disaipele mareme ekeni nale finelufe, nanoolu menengu glei paie paie apotene, mwa. Tefe mwamole mwamole disaipele nafwane, “Oone menane pai nawolu?” ");
INSERT INTO kwo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Te Jisese natelee, “Ekeni lufwa bofoo, nanoo eketie tialootu tialootu lemolufu lufwa. Ekeni lufwa tabele faleleeke mene weifememe bregeefi lenelu wainei pielene alane. ");
INSERT INTO kwo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Marena, Lufwalu Lefoo ame tafilabe, wolu Gotelu lofoi pi lenelu na neleelu atukwe. Mwanga, mene ekeni lufwa nanoo Lufwalu Lefoole na ambeme falefoolaleelule fwai nafoolaie. Ekeni lufwale yefee lupoleri preme leli, eete nemboue. Yefee lupoleleefe, tefe nanoo ame oo nembulufi lalabe.” ");
INSERT INTO kwo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Te ame kakali lelaneime, Jisese tabe leelu bofoole faleleeke, te Gotele eetegeni tabele amwi leforife na woponefoleeke, te mongu mongue aleeke, nalilu disaipelele nifwatelali, te natelee, “Eetegeni tabe leelukoe menanoo ree, oone peenemoke foopobu.” ");
INSERT INTO kwo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Te boe waine meleele mei yefuna bofoofi sunaleleeke talali, te Gotele na woponefoleeke, nifwatelee. Te maretekume tooroonoopoe tooroonoopoe ifafwane. ");
INSERT INTO kwo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Te Jisese boe natelee, “Eetegenikoe menanoo fweelu, mene na wolilule sere lerife lie. Mene nianoo fweelule sunalielu inalilufwale motukwe aikopi leterife. ");
INSERT INTO kwo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mene marenafe namoolaie, mene boe eetegeni wainele glei forife lelaie, mwa. Menekoe sabei waine temolule Gotelu ameime lalarilufi forife lelaie.” ");
INSERT INTO kwo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Te saue bofoole nafoolaneke, tetoo eetegeni wokoo soulule grialeneke, te Olife Afuneme wane. ");
INSERT INTO kwo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisese nalilu disaipelele eese natelee, “Oone maretekume menane ame grialeworife lelamo, oone glei menengu kaisekli lebule. Mwa. Gotelu lofoi na pilenelu nelee, ‘Mene ame bole ameflee sipsipe gipoolaleealeelu lufwale prafwieke tafilali, tetoo nalilu bole ameflee sipsipe brune brune abile.’ ");
INSERT INTO kwo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mwa. Mene boe ame furalieke, tetoo nambulemwieke, Galilifi wolemoolafe.” ");
INSERT INTO kwo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Te Pita nafolee, “Telute ame oonane grialeooneke brune brune abile, menete, mwa, oonane glei grialewofe.” ");
INSERT INTO kwo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Te Jisese fune nafolee, “Mene oonane marenafe naoolaie, nembue eetegeni krieime aiefe ame arelufe na neri preme lelali, oone tetoo mwangifelufe menanoo bilule ame ambutelewole.” ");
INSERT INTO kwo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Te Pita metie mwa, nalife kaisekli lelali nafolee, “Mene glei grialewofe, mwa feti. Mene weifememe troonalerife lelane.” Te disaipele mareteku mei eesalu naleme nafwafoone. ");
INSERT INTO kwo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Te Jisese nalilu disaipelele safi kalume leleelufile (Getsemani nafoone) ifwateleeke, kuru weife leteleeke, tetoo natelee, “Oone eetei lalamoi menane ooleoolabu mene Aiele na woponefoolaie.” ");
INSERT INTO kwo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Te nanoo kame Pitale, Jemsele, Jonele ifwatelee. Nanoolu menengu metie mwa, popani afoolalee, reeyemee lefoolaleefe glei amwi lafiefoolalee, mwa. ");
INSERT INTO kwo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tefe natelee, “Menanoo menengu mwa, mweetu atukwe krinalewoleeke, tafilari woroome leoolalee. Oone eetei ooleoolamoi regilelabu.” ");
INSERT INTO kwo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Te nali wapoleleeke, inengoi soonaleleeke Gotele na woponefoolali nafolee, “Oona i nelu tetoo eetegeni oo nembulu menane grialewobee.” ");
INSERT INTO kwo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Gotele na woponefoolali, nafolee, “Aba, Aie, ooneleme yesou yesoule mareteku letelu. Menanoo menengu eese leoolalee, oone menanoo oo nembulu eetegenile falewoluke woponeworilu menenguleme leoolaie. Oone kose menanoo menengule nifewole mani. Mwa. Oone kame oonanoo menenguleme nife.” ");
INSERT INTO kwo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Te Jisese boe walee wofetaterife. Te wofetateleelu mwa, nanoo wolu rofoofe lune. Te Pitale kelafoolali nafolee, bofoo bilutu, “Saimone, ame pe lulalu? Oone lie oolu mwamole lalalu oolelarilu mwa pai glei pai mare lalalualu? ");
INSERT INTO kwo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oone oo lelamoi Aie Gotele na woponefoolabu, tetoo oone glei gugufi atukwe yekurunebule, mwa. Marena eetegeni ritilu falerilu menengu te i namoone, oonanoo ree nali soo alee lepomoolane.” ");
INSERT INTO kwo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Boe waleeke, wolume woponefoleelu naleme boe woponefolee. ");
INSERT INTO kwo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Te boe waleeke wofetateleelu mwa, rofoofe lulane, glefe, oo rofoofe ameetu susunapotenelufe. Te kelapoteleeke fufurunenelu mwa, nanoo oo rofootu na naforilu gigime letelee. ");
INSERT INTO kwo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Te Jisese boe mwangifelufe waleeke nalilu disaipelele wofetatelee. Te natelee, “Oone ame pe lulamoi yenalelamo? Lie wolu sekalelee, tetie mai, nembue Lufwalu Lefoole wolu oosefi ifenatelananelu lufwalu ameile seinatelane. ");
INSERT INTO kwo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Oone te fufurunemoke tale wabile. Eete fetabu, lufwa ine menane nembulu menengu tefoo lufwalu amei sinaworife lelaleelu lufwa wolu eete sekaleleeke rilalee.” ");
INSERT INTO kwo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisese ame na ifenatelalime, tesulu nalilu disaipele bofoo Judase nanoo rielee. Lufwa motukweme nali iferieteleelu, nanoo kosi wamolulule tukwe, kafune botukolile tukwe ameetu ameetu leneke rine. Nanoo Gotelu prise yefeelu, na kaisekli ramelu lufwa, te Judafu yefeelu lufwatu mare natenelufe wane. ");
INSERT INTO kwo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Te ekeni lufwa, Jisesele nali seinaterife lelaleelu, nanoo natelee, “Mene ame waieke lufwa bofoole kapoonefoolaiei, eetete Jisese nali, tetoo rimoke belemoke, te ifwalamoi amwime regiletewafobu!” ");
INSERT INTO kwo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Te Judase nanoo woseka leleelu esulu Jiseselufileme waleeke, te nafolee, “Ramelu Lufwa” nafoleeke, te kapoonefoolalee. ");
INSERT INTO kwo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tupane eetele fetanelufe te waneke, Jisesele metie belene. ");
INSERT INTO kwo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Te lufwa bofoo Jiseselu bwagei temepoolanelufu, nanoo kosi wamolulule glinaleleeke, Gotelu prise paie tefoole amee amee afoolaleelu lufwale kositu foonaleelu, mwa, futeni bofoole metie tekalefoleeke yeferalefolee. ");
INSERT INTO kwo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisese natelee, “Oone kositu, kafune botukolitu peenemoke rimolukoe menane beleworife rimo, eke famefe, tukulife ameleelu lufwale atukwe. ");
INSERT INTO kwo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ute krie ute krie mene mare Gotelu ite geeneri menei amiei, inalilufwale na alipotemiei, oone glefe menane ekenitu belewori preme lemo? Tefe ulabee, anefa Gotelu bukei lalaleelu na neleelu wolu bolelutu lelalee.” ");
INSERT INTO kwo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Esulu disaipele Jisesele maretekume grialeneke, brunalene. ");
INSERT INTO kwo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ari rawielu bofoo leeloo konembulule tamuleleeke, Jisesele nifetewalee. Te belelanelufe mwa, ");
INSERT INTO kwo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","metie ameele buruanaletelali, te leeloo tefelefoleeke yewi pokoo tialelee. ");
INSERT INTO kwo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tupane lufwa Jisesele beleneke, Gotelu prise paie tefoofile ifwane. Te ekeise Gotelu prise yefeelu, Judafu yefeelu lufwa, te na kaisekli ramelu lufwatu mareteku lukuleneke, lalane. ");
INSERT INTO kwo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Te Pita Jisesele fime fime afwafoleeke, mokenei keke temelaleelu, te boe waleeke, Gotelu prise paie tefoolu tikliafweefime wopreielee. Te ekeise tetoo Gotelu ite regi lefoolananelu lufwa mare ifi kinapomene. ");
INSERT INTO kwo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Te Gotelu prise yefeelu, Israelefu paie tefoo panetu maretekume, nanoo lufwa telule fieri nateneke ririane Jisese leteleelu ameele alipoterife. Nanookoe fwagilu amee bofoo wolu lelee pe neneke oorafoolane, tetoo eetegeni ameefi teiefooneke tafilabee neneke, mwa, nanoolu fwagilu amee bofoole glei fetafoone. ");
INSERT INTO kwo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lufwa motukweme yemereti kose kose nale finalefoomene, ekeni na glei marena na. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lufwa telu nanoo temepoolanelu yemereti kosefe nafoone, ");
INSERT INTO kwo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mene finelu nanoo eese nelee, ‘Mene ame Gotelu ite eke lufwa ameetu lenelule brinalieke, te boe tuieke lie mwangifelutu soonalefe, mwa, eete glei nianoo ameetu tuerife lelaie.’ ” ");
INSERT INTO kwo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ekeni na nenelu mei yewilu preme lene, kame mweeme kame i naporiane. ");
INSERT INTO kwo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Te Gotelu prise paie tefoo nanoo Israelefu paie tefoo panelu oofi temelali tetoo Jisesele eesalu fiefori lelee, “Oone na bofoo glei pe natele, eke yemereti yewilu prelu nale finaleoolanelule?” ");
INSERT INTO kwo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mwa. Jisese na bofoo glei nepolelee. Ekeni lufwa boe fiefolee, “Ooneboe Gotelu Lefoo pe, Kraise?” ");
INSERT INTO kwo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisese fune nafolee, “Nia eetetie mai, te ‘oone ame sabei Lufwalu Lefoole Kaiseklilu Tefoo Gotelu amee feti porite lafieleeke, efenefu masebootu rilali fetabule.’ ” ");
INSERT INTO kwo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mwa. Gotelu prise paie tefoo nanoo eetegeni nale fieleeke metie betige leleeke, nalilu leeloole brinaleleeke, te nelee, “Mwanga. Mena kose lufwa telule boe natebile mani, eetegeni lufwalu fwagilu amee yewilule alipoleelu nafe. ");
INSERT INTO kwo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Oona wolu fiefoomo, Gotele eeneri nafoleelule. Tefe oone menengu lelamolu menaboe glelu ameele lefobile?” Te maretekume unaleneke nene, “Nali wolu fwagilu amee bofoole lelee, tefe tafilabee.” ");
INSERT INTO kwo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Te lufwa telu nanoo Jisesele teea burutu ifaneke, te oole leeloo sielutu fuefooneke, bubualanei te nafoone, “Sei, oone menane ne! Inepane bubuaoolane?” Te Gotelu ite regi lefoolananelu lufwa boe neuneneke, buane buane ifane. ");
INSERT INTO kwo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Te Pita ame Gotelu prise paie tefoo lufwalu tikliafweefi teime yetemelalee. Ekeni lufwale amee amee afoolaleelu inali bofoo waleeke, ");
INSERT INTO kwo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","te Pitale fetalee, ifi kinamelee. Te ekeni inali Pitale oosunetewafoleeke, te nafolee, “Oone mei Nasaretefu Jisesetu mare amemolu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mwa. Pita metie oosai nafolee, “Mene glei rame lelaiei oone eke nelalulu nale.” Te ekeni tekoofu woseka leleeke waleeke tikliafwee fee amblenei wotemelali, te aiefe na nelee. ");
INSERT INTO kwo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ekenifi, te boe ekeni inali nali fetaleeke, te ekenifi temepoolanelu lufwale natelee, “Eetegeni lufwa mei nali mare amenelufu.” ");
INSERT INTO kwo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mwa. Boe sameme oosai nelee. Te pepelepoleli atukwe leneke roboi temepoolanelu lufwa Pitale nafoone, “Marena, oonekoe ekepane mare amemolu lufwa bofoo oona eetetie. Oonekoe Galilifu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nembue Pita metie oosai neleeke te nelee, “Lie eete temelalee, mene glei rame lefwie ekeni lufwa oone nafoolamolule. Mwa. Mene oosai niei, Gote nemboue menane teiewobee.” ");
INSERT INTO kwo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tesulu aiefe arelufe na nelee. Te Pita Jisese nali nafoleelu nale menengu lefolee, eese nafoleelu “Aiefe ame arelufe na neri preme lelali, oone tetoo mwangifelufe menanoo bilule ame ambutelewole.” Tefe Pita metie ee ba naleleeke eeleme nelalee. ");
INSERT INTO kwo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kwotuekrieime, Gotelu prise yefeelu, Judafu yefeelu lufwa, te na kaisekli ramelu lufwa, nanoo mare Israelefu paie tefoo pane, nali kwaife lukuleneke, te nali glelu amee leforilu nale amwi sere lene. Nale sere lelaneke, te Jiseselu ameele mweetu funeke, te ifwaneke Pailatelu amei tepolene. ");
INSERT INTO kwo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Te Pailate Jisesele eesalu fiefori lelee, “Ooneboe oona pe Judanelu kine?” Te Jisese fune nafolee, “Oona wolu nelu.” ");
INSERT INTO kwo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Te Gotelu prise yefeelu Jisesele yemereti te na te na yewilu prelule finalefoone, ");
INSERT INTO kwo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","tefe Pailate boe eesalu fiefori lelee, “Ooneboe na bofoo naterilu mwa pe? Te na te na oonane eke finalemoonelu nale wolu fietelu.” ");
INSERT INTO kwo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mwa, Jisese nanoo na bofoo boe glei nepolelee. Pailate fetaleefe, tefe nanoolu menengu metie gigime lefoolalee. ");
INSERT INTO kwo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ute ute yaretu Gotele paie paie afoonanelu soulu lietu, Pailate kalabuse ite menefu lufwa bofoole ambleni oorapofoleeke, inalilufwa nali i nafoonelu lufwaleme tepoleteleealee. ");
INSERT INTO kwo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ekeni krietu wokoofu lufwa nalilu gavmanele ifapureletelanei, tetoo lufwa telule puketeneke troonalene. Tefe nalilu gavmane tetoo lufwa telule bebeneneke, kalabuse itei sioonatene. Te lufwa bofoo Barabase mei kalabuse ite menei ekepane lufwa mare lamene. ");
INSERT INTO kwo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Te inalilufwa Pailatele kuruwolefooneke, te fiefoone ekeni amee nali atelaleealeelule leterife. ");
INSERT INTO kwo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Te Pailate fune natelee, “Oonanoo menenguboe mene Judanelu kinele pe ambleni oorapofwieke riemorife nemo?” ");
INSERT INTO kwo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailate wolu rame lelee, Gotelu prise yefeelu, nanookoe Jisesele kame yemereti nembu nembulu menengu lefoolananelufe beleneke ifwane. ");
INSERT INTO kwo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mwa. Ekepane prise yefeelu inalilufwalu menengule tuteli letene, tefe Pailatele fieri nafoone kalabuse itele ambleni oorapoleeke, Jisesele grialeleeke, Barabasele tepoleterife. ");
INSERT INTO kwo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Te Pailate boe fietelee, “Tetoo oonanoo menenguboe akeke lemoolane mene ekeni lufwale akekelu amee lefofe, oona eke Judanelu kine nafoolamwamolule?” ");
INSERT INTO kwo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Te inalilufwa mareteku unaleneke nene, “Tafilarife, kafi niletu koko nebu.” ");
INSERT INTO kwo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Te Pailate fietelee, “Glelu ameele lelee?” Mwa. Nanoo boe unaleneke nene, “Tafilarife, kafi niletu koko nebu.” ");
INSERT INTO kwo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Te Pailate inalilufwalu menengule tetoo peti leterife, tefe Barabasele ambleni oorapofoleeke tepoletelee. Te Pailate neleefe tefe kworoofame lufwa bofoo Jisesele brini keme lenelu mweetu bubualeeke, te kworoofame lufwa telulu amei tepoletelee, tetoo kafi niletu koko neneke tafilarife. ");
INSERT INTO kwo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Te kworoofame lufwa Jisesele gavana nalilu tikliafoile ifwane. Te kworoofame lufwale mareteku fieri nateneke rine. ");
INSERT INTO kwo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Te kine tapoolananelu leeloo lubulu bofoole Jisesele sinafooneke, te soomoiyefee mwee roorilu tefoole ramoneneke, kine tapoolananelu sepiole atukwe leneke, te Jisesele ipoi sinafoone. ");
INSERT INTO kwo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Te eeneri natume nafoone, “Yei, Judanelu kine oonekoe paielu!” ");
INSERT INTO kwo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Te petie yewilu bofootu ipoi buane buane ifaneke, te teea burutu falene. Te tumoinu krutupooneke, te paielu lufwalu bilule boletafoonanelu amee keme ifane. ");
INSERT INTO kwo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eetegeni fisere fisere na ifeneneke, te leeloole ligalefooneke te nalilu leelooleme boe sinatefoone. Te neuneneke ifwane kafi niletu koko nerife. ");
INSERT INTO kwo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Te lufwa bofoo bilu Saimone. Nanoolu lefooane Aleksanderetu Rufusetu. Nanoo Sairini wokoofu lufwa. Nanoo Jerusalemeile walali, te kworoofame lufwa Jisesele ifwalanei, nanoo booreletelali tetoo beleneke, te noopoo nafoonekeme, Jisese nalife eetei niletu koko nerife lelanelu kale ambuketewafolee. ");
INSERT INTO kwo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nanoo Jisesele neuneneke, afune tupulu bofoo, Golgotame ifwane. (Eetegeni bilu yewilu nene, Ipoe Kolilu Tekoo.) ");
INSERT INTO kwo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Te Jisesele wainele marasinetu leneke fanenelu, mwa, nanoo glei folee. ");
INSERT INTO kwo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Te kworoofame lufwa Jisesele kafi koko neneke, te Jiseselu leeloole nali kwaife lemwamolene. Te ka tukweetukweelule lufwalu ameelu atukwememe kreenapooneke, te bofooleme pi pi ifaneke, te telule kame preme grialetene. Te lufwa bofoo ameetu bebenetalali, te lufwa ine pilu tefoole boligaleli, nanoo yesou bofoole falebe. Eetetie eesalu usike ameetu Jiseselu leeloole peene peene ane. ");
INSERT INTO kwo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kwotue lietu, lie oolu tialoo mwangife lelali, nanoo Jisesele tetoo kafi niletu koko nene. ");
INSERT INTO kwo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te ekeni tekoi mei lufwa glelu yewilufe tafilaleelu nale pi leteneke, tetoo fatietenane, Jisesele mei na pi leneke ipoe kai fatiefoone. Na pi lefoonelu eesalu pileri lene, “Judanelu kine.” ");
INSERT INTO kwo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Te oosefi ifenatemenelu lufwale mei are fime ameetu nalilu bwagei, bofoo amee feti porite kafi niletu koko nenei, te bofoole aneboi amee porite kafi niletu koko nene, eese leteneke temepoolane. ");
INSERT INTO kwo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Te inalilufwa fune sigli fune sigli alanei, eeneri natu ipoele kokwani afoolanei, te nafoonane, “Sei ta, oone lufwa ga, oone Gotelu itele te brinaleluke, te boe tueluke lie mwangifelutu soonale, ");
INSERT INTO kwo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","te oonafe mei paie nerife, nile liganuleluke tiralela.” ");
INSERT INTO kwo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Te Gotelu prise yefeelu, na kaisekli ramelu lufwatu mei eeneri nafooneke, te nali kwaife nene, “Nanoo teluleme paie naporife letewateleeke, te nalife glei paie nebe. Mwa. ");
INSERT INTO kwo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ekeni Kraise, Israelelu kine nemboue ka mwafu nilele liganueleeke te tiralebee, mena fetaneke, tetoo nanoole menengoi ifelalabile.” Te oosefi ifenatelananelu lufwa are nalilu bwagei kafi niletu koko napoonelu mei weife eeneri nafoone. ");
INSERT INTO kwo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lie ooloo babi babi temelali, te eetegeni inengu maretekume metie pinaleleelu, lafwalaleekeme feiferi lie oolu mwangifelufi lelali, ");
INSERT INTO kwo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","tetoo Jisese nalilu natu ragoo mwai eese nelee, “Eloi, Eloi, lama sabaktani?” Eetegeni na yewilu eese nelee, “O nianoo Gote, nianoo Gote, oone menane glefeme oolume lewolu?” ");
INSERT INTO kwo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Inalilufwa telu roboi temepoolanelu ekeni nale fineke, te nene, “Bie fiebu, nanoo Elaijale fieri nafolee.” ");
INSERT INTO kwo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tesulu lufwa bofoo pipinafwaleeke giginifeele wainei pieleleeke te ka bofoofi fueleeke te Jisesele forife fanelee. Te ekeni lufwa natelee, “Bie awia, bie fetalabile ame Elaija pai rieleeke tetoo mwafule neuneleeke ifetiralebe.” ");
INSERT INTO kwo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Te Jisese metie lari soumeme woponeleeke, tesulu tafilalee. ");
INSERT INTO kwo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Te ekeni leeloo selilu Gotelu ite guei linelu geni babi babi mwai mopuboleleeke, te brinetereleeke, metie mopue are lelee. ");
INSERT INTO kwo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te Romefu kworoofamelu keptene Jiseselu bwagei temelaleelu, Jiseselu larile fiefoleeke te nalilu ootu akekelu amee leleeke tafilaleelule fetaleefe, tefe nelee, “Marena aga, ekeni lufwakoe Gotelu Lefoo.” ");
INSERT INTO kwo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Te inali telu mei mokenei keke wotemepomenei fetatemene. Te nanoolufu inali bofoo Makdalafu Maria, te bofoo mei Maria nanoolu lefoo rawielu Jemsetu Josepetu. Te inali bofoo Salome. ");
INSERT INTO kwo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jisese nali Galilifi ameli, ekepane inali nali nifetamenei aikopi lefoomene. Te inali telu mei Jerusalemeile nifetewanelu marememe lalane. ");
INSERT INTO kwo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Kwotuefe eesalu te Yenalerilu Lie lebe. Nembue eesalufe, feiferi lietu Arimateafu lufwa Josepe walee. Josepe Israelefu paie tefoo panelu paielu, nanoo wolilu lufwa inalilufwalu oofi. Te nanoo mei Gotelu ameime lalarilule fetarife oolefoolaleelu lufwa. Kwotuefe Yenalerilu Lie, tefe nembue yesou yesou ekeni lieile Mumusi Leterilu Lie. Josepe menengu kaisekli leleekeme waleeke, wopreieleeke, Pailatelu oofime wotemelee. Te Pailatele fiefolee, “Nemboue pe we nawole, mene Jiseselu ree tupulule falerife?” ");
INSERT INTO kwo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailate Jisese tafilaleelu nale fieleefe metie betige feti lelee. Tefe Romefu kworoofamelu keptenele fieri nafoleeke, te fiefolee, “Ie, eese pe, Jisese wolu tafilalee pe?” ");
INSERT INTO kwo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailate Romefu kworoofamelu keptenelu nale fieleeke, te Josepele nafolee, “Nemboue, Jiseselu ree tupulule faleluke tewa.” ");
INSERT INTO kwo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Te Josepe waleeke, leeloo temolu wamolulu konembulule wofaleleeke, terieleeke, te Jiseselu ree tupulule ka mwafule boliganueleeke terelee. Te leeloo konembulutu, fueleelu esulu tewaleeke timenee bofoofi wofatielee. Ekeni timenee lufwa nali ameetu lenelu. Te ekeni meneelule Josepe ti bofoole ambure ambure ifafwaleeke, tetoo kaprunefatielee. ");
INSERT INTO kwo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Te Makdalafu Mariatu, Josepelu yefee Mariatu weife Jisesele fatinelu tekoole fetamene. ");
INSERT INTO kwo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Te Yenalerilu Lie wolu pookanaleleeke, tetoo Makdalafu Mariatu, te bofoo Maria, nanoo Jemselu yefee, te Salome, nalime eese leneke wolilu seralu tefoo meleele bwaleetu peenene, Jiseselu ree tupulule tetoo suwanaleforife. ");
INSERT INTO kwo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Te nambulerilu lietu, kwotuekrieime ekepane inali nanoo wane Jisesele fatinelu timeneile. ");
INSERT INTO kwo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te ame walaneime nali kwaife nene, “Menafeboe ine aikopi lebe, ekeni ti soulu timenee tetoo kaprunalenelu genile ambure ambure ifafwarife?” ");
INSERT INTO kwo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Te roboi wotemepooneke te oowafoonelu mwa, ekeni ti soulu wolu ambolufi oolalali fetane. ");
INSERT INTO kwo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Te timeneeme wopreipooneke, te ari rawielu bofoole fetane, nanoo leeloo konembulutu amee feti porite lafieleeke lalali. Te ekeni ari rawielule metie betige lefooneke wofri lelanelufe, ");
INSERT INTO kwo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","tefe nanoo natelee, “Oone kose wofri lebule mani, mwa. Menekoe oonane wolu rame lemwie, oonekoe Nasaretefu Jisesele ooraferiefoomo eke kafi niletu koko nenelu lufwale. Nanookoe wolu furalelee, glei eetei lalalee. Mwa. Bie rimoke fetabu eetei fatinelu tekoole. ");
INSERT INTO kwo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Oone kame wamoke eetegeni nale, nalilu disaipelele natemo, te Pitale mei nafobu, Jisese nali molukwe wolu nambuleleeke Galilifi ooletelalee, nanoo ekenifi wofetarife lelalu, bebriefe nali wolu nasi leteleelu atukweme.” ");
INSERT INTO kwo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Inali timeneefu kuruyeleneke, metie pruelene. Nanookoe wofri menengufe menengu popani apotelanei pupunapoolane. Tefe lufwa bofoole glei na natenei, mwa. Eete glefe? Nanoo wofri lelanelufe. ");
INSERT INTO kwo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisese nambulerilu lietu furaleleeke, Makdalafu Mariale molukwe sekalefolee. Jisese nali bebriefe ekeni inalilu reefu naifofu tialoo mwamole leleeke ifamenelule grialerife nateleelu inali. ");
INSERT INTO kwo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Te Maria waleeke Jisese nali ifatemeleelu panele oonatelee. Ekepane nanoo menengu ruforitu lapruelemenei ee nafoomene. ");
INSERT INTO kwo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jisese boe wolu furaleleeke oofulilu lalali, Maria fetalee, Maria nateleelu nale fineke, mwa, nanoo glei marena nene. ");
INSERT INTO kwo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Te boe Jisese nalilu disaipele are wolu wokoo soulule grialeneke walanei tetoo Jisese bofoo oofwafwaleetu leleeke woseka letelee. ");
INSERT INTO kwo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Te weife waneke, ekeni nale disaipelele oonatene, te nanoo mei same, fineke, mwa, glei marena nene. ");
INSERT INTO kwo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Te fimelufe nalilu disaipele tialoo yarilutu laprueleneke kakali lelanei, tetoo Jisese punepoletelee. Te Jisese fame na natelee, nanoo wolilu menengu preme leneke, inalilufwalu nale glei fietene, nali wolu oofulilufi natemeleelu nale. ");
INSERT INTO kwo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Te nalilu disaipelele natelee, “Oone wabu, eetegeni inengume lapruefwalanelu inalilufwale eetegeni na ulu wolilule alipoofwatelabu. ");
INSERT INTO kwo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ine eetegeni nale fieleeke, menengoi lafoolaleeke, melei pielenei nanoo wolu paie nelee. Te ine eetegeni nale fieri preme leli, nanoo ame Gotelu nafi yenalebe. ");
INSERT INTO kwo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gote ame nalife menengoi ifelalanelu lufwalu ameetu brege bregele afwatebile. Nanoo ame menanoo bilutu naifofule grialeterife natene afwatenei, tetoo te na te natu nafwatebile. ");
INSERT INTO kwo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nanookoe ame fame tiafweele ameetu bebenafwalanei, glei angipoofwatebile, mwa, te ambookwanee fweelule foopoofwalanei, ekeni yesou glei teieteneke troonalebile, mwa. Te kokou ree inalilufwalufule ame unapoofwatenei tetoo reetu fuenetewapotebile.” ");
INSERT INTO kwo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Paielu Jisese nale wolu nalilu disaipelele alipoofwateleeke, tetoo Gote neuneleeke efeneile ifwalee. Nanoo Gotelu amee feti porite lafieleeke lalalee. ");
INSERT INTO kwo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Te disaipele waneke, te wokoo te wokoo lemenei nale alipoofwatelane. Te Paielu nali aikopi letemelee, te ekeni na ulu tetoo marena na ulu nerife tefe te brege bregele letewatelee. ");
INSERT INTO kwo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiofiluse, mene Luke nianoo buke wolumefufi yesou motukwe Jisese fetou ne fetou ne afwateleelu amee ameele mene eetegenile pi letewatieke, te Gote Jisesele efeneile ifwakumoleelu krietume woletie. Bie nalilu Wolilu Fifrilu kaiseklilutu nali wolu namuneteleelu aposelele te amee te amee letewaterilu nale natelaleeke, tetoo efeneile ifwalee. ");
INSERT INTO kwo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wolume teteree faleleeke, tafilaleelu boe furaleleeke, oofulilu reetu nalilu aposelele punepoletelee. Nali tupanele rame leforife nali oofulilu lalalee neleeke, tefe nalife lebati atemeleelu krie ameelu 40 lefolee. Tetoo Gotelu ameime lalarilu nale ifenatelee. ");
INSERT INTO kwo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Te nali ame ifelatelalime, tetoo bofootu nali mare kakali ifeletelali, te eese natelee, “Oone kose afeteli Jerusalemele grialemoke wabule mani. Mwa. Bie ekeni yesou Aie nali oonane wolu bebriefe nasi namolee fanemorife lelaleelule, teime lalamoi oolefoolabu. Oone wolu fimo ekeni yesoufe mene nelaiei. ");
INSERT INTO kwo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jone inalilufwale kame melei pienuemelee, oonete mwa, Wolilu Fifri ame seenalemorife lelaleelu krie glei mokenei lelalee.” ");
INSERT INTO kwo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Te ekenitu nalilu aposele mare lukuleneke tetoo eesalu fiefori lene, “Paielu, oone nembue eetetie pai mena Israelelu inengule oona kinefe leluke, menafe boe kaisekli ifelepoolale pe wolume laferilanelu keme?” ");
INSERT INTO kwo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Te fune natelee, “Eete glei oonanoo yesou, tetoo oone Gotelu kriele liele rame leteforife, mwa. Nanoo mei nalilu amei lafoolalee. ");
INSERT INTO kwo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Oonane ame sabei Wolilu Fifri riemobe tetoo oone soulu kaiseklile falebule, tetoo oone ame nianoo naleme inalilufwale alipoofwatebule Jerusalemefule, Judia provinseme, Samaria distrikeme, te te wokoo te wokoo eetegeni inengu lemeleelu atukweme wolebule.” ");
INSERT INTO kwo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eetegeni nale eese nateleeke, te temepoolanei Gote efeneile ifepeenalelali ange oofulinameneke, mwa, metie maseboome amoirepolelee. ");
INSERT INTO kwo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nanookoe Jisese efeneile waleelume ame ooti lefoomenei esulu lufwa are weife leeloo konembululeme leteneke punepo leteneke ifetemepotelane. ");
INSERT INTO kwo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Te weife natene, “Galili, ooneboe glefeme eeteise kame yemereti temepoolamoi lieme ooti lepoolamo? Ekeni Jisese nembue eete Gote efeneile ifwakumolee, boe rilali mei nembue eete fetamolu atukweme lerife lelalee.” ");
INSERT INTO kwo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Te Olife Afunefu boe Jerusalemeile wane. Eetegeni afune glei mokenei temelalee, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Te Jerusalemei kuruwoleneke, esulu ite mwaile peepeeneneke nali eetei lalananelu gueile preipoone. Te lufwa kame Pita, Jone, Jemse, Andru, Filipe, Tomase, Bartolomyu, Matyu, Alfiuselu lefoo Jemse, te Selote panefu lufwa Saimone nafoone, te bofoo Judase Jemselu lefoo. ");
INSERT INTO kwo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ekepane mareteku mwamole menengutu lukuleneke lalanei, tetoo Gotele na woponefoolane. Te Jiseselu yefee moo tari, te telu inali mei eetetie mare eesalu ameeleme alanane. ");
INSERT INTO kwo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ekeni lietu Jisesele menengoi ifelalanelu inalilufwalu ameelu 120 lene. Tetoo Pita temelali ");
INSERT INTO kwo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","natelee, “Apane wofoliane nefalemoolaie, bebriefe Wolilu Fifri Devitelu ragoo pi Judaselu nale nafolee, ekeni na Gotelu bukei lalalee. Nanookoe Judaselu nafe nelee nali Jisesele belerife akie ipoelu lufwale fatieteleefe. Tefe nembue eetegeni na wolu boletu lelee, Devite neleelu atukwememe. ");
INSERT INTO kwo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Bebriefe Judase mei mena mare eesalu amee ameele aferiemenelu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Nanoo Jisesele seinateleefe fanenelu bwaleele faleleeke, tetoo inengu monguelu bofoole falelee. Te ekeni inengoi yeferaleleeke arie mopu lefoleeke arielu finalefoone. ");
INSERT INTO kwo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusaleme eetegenile fineke, tetoo ekeni tekoole “Fwee Sunaleleelu Inengu” nafoone, nalilu natu Akeldama nafoone.) ");
INSERT INTO kwo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Te Pita boe natelee, “Devitelu saue bukei eke pilenelu na nelee, ‘Nemboue nanoolu gugulu kame preme lafoolabe, bofoo lufwa nanoolu gugulule glei falefoleeke, tetoo lalabe. Mwa.’ Te bofoo kalu ekeni bukei neleelu na nelee, ");
INSERT INTO kwo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Tefe mena Paielu Jisese lameli mare wariamenei amee amee lemenelu lufwa bofoo menanoofuleme namunefobile, ");
INSERT INTO kwo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jone inalilufwale melei pienuemeleelu lietu letewaleeke, tetoo Gote Jisesele neuneleeke efeneile ifepeenaneleelu lietume wolelee. Tetoo namunefooneke, aposelefe leleeke te Jisese furaleleeke oofulilu lalaleelu nale alipoofwatebile.” ");
INSERT INTO kwo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Te Pita eese nateleefe esulu lufwa are namunetene Josep Barsabase, bofoo bilu Jastuse nafoone, weife Matiasetu. ");
INSERT INTO kwo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Te Gotele na woponefoolanei nafoone, “Paielu, oone inalilufwalu menengule wolu rame letelu, eetegeni are lufwa inele oone namunefolu, menane fetou ne, ");
INSERT INTO kwo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tetoo aposelefe leleeke Judaselu gugulule falefoleeke tetoo lalabe. Judase wolu eetegeni amee ameele grialeleeke walee, nali eetei walarilu wokeile.” ");
INSERT INTO kwo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Te ka tukwee tukweelule are kreenapooneke, te lufwa bofoo ameetu bebenetapoolali, te lufwa are boliganuebile, te lufwa ka wamolule faleleelu nali ekeni lufwa mare alarife. Te eesalu ameetu tetoo Matiase Judaselu gugulule falefolee, te tialoo yarilutu aposelele nifetelee. ");
INSERT INTO kwo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Te Soulu Lie Pentikose wolu lelaleefe tefe Jisesele menengoi ifelalanelu inalilufwa mareteku ite bofoofi mwamolei lukuleneke lalane. ");
INSERT INTO kwo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Te esulu efenefu sineku bofoo fifri selilu ulu atukwe paniferieleeke, te eke nali lalanelu iteleme falelee. ");
INSERT INTO kwo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tetoo golinai i leelu atukwe pane pane apooneke puine puine apoofwanelu mwamole mwamole inalilufwalufi laifwatenei fetafwatene. ");
INSERT INTO kwo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wolilu Fifri tupane inalilufwale seenaleteleefe tefe bofoo bofoo natu na napoofwane. ");
INSERT INTO kwo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Te Judane telu wolu rineke Jerusalemei lalanelu, ekepane Gotele reeyemee lefoolananelu pane. Nanoo eetegeni inengume lafwanelu wokoofu mareteku ririane. ");
INSERT INTO kwo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Te nali ekeni sinekule finelufe metie waneke luku wolene. Te Jisesele menengoi ifelalanelu inalilufwa nelanelu nale fieteneke metie betige lene. Tupane mwamole mwamole nanoolu natu napoolanei fifwatenelufe, ");
INSERT INTO kwo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","tefe Judane metie menengu aipoe aipoe lelanei te nene, “Mwanga! Nanookoe mareteku fime Galilifu inalilufwa. ");
INSERT INTO kwo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Te boleboe ake lenekeme nanoo mwamole mwamole menanoo natu nelanei fietelane? ");
INSERT INTO kwo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Menakoe fime Partiafu, Midiafu, Elamefu, Mesopotemiafu, Judiafu, Kapadosiafu, Pontusefu, Esiafu, ");
INSERT INTO kwo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiafu, Pamfiliafu, Isipefu, Libiafu, Sairinifu, te mena Rome wokoo soulufu rinelutu, ");
INSERT INTO kwo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","mena Judanetu, rawietu menanoo Gotele reeyemee afoolanelu panetu, te Kritefutu, Arebiafutu mena mareteku Gotelu soulu amee ameele leteleelu nale menanoo natume nelanei fietelane.” ");
INSERT INTO kwo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Te mareteku metie betige leneke, te menengu ti napotelanei, te nali kwaife nene, “Eetegeni amee nembue eete lelaneluboe glelu yewilufe eese lelane?” ");
INSERT INTO kwo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tefe telu yemereti natene, “Nanookoe waine temolule foopooneke totoli napoolane.” ");
INSERT INTO kwo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Te Pita nali mare nale alipoolananelufu furaleleeke temelali, tetoo ragoo mwai natelee, “Oone Judiafu inalilufwatu mareteku Jerusalemei lalamolutu bie fieoolabu mene namorife lelaielu na yewilule. ");
INSERT INTO kwo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Eetepane lufwa wainele foopooneke, totoli napoolane natebule mani. Mwa. Nembue kwotue lietu lie oolu ame tialoo mwangife lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Eetegeni yesou eete lebati lelanelukoe bebriefeme Gotelu ragoofu nale alipoolaleelu lufwa bofoo Joele Gote neleelu nale eese nelee, ");
INSERT INTO kwo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Neembee lie ameelu amee feelu pike lelali mene ame Wolilu Fifrile eetegeni inengufu inalilufwale fanetefe. Tetoo ame oonanoo wolualiane, kaporane ame nia fetou natielu nale alipoolabile, oonanoo ari rarawielu ame yesoule rarauetu atukwe fetatelabile, tetoo lufwasekli mei raraue raraue apoolabile; ");
INSERT INTO kwo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","te ekeni lietu tetoo nianoo nale kulifi alananelu inalile, lufwale mene ame nianoo Wolilu Fifrile faneterife lelaie, tetoo nia fetou natielu nale alipoolabile. ");
INSERT INTO kwo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mene lie mwai yesoule ame bofoo amee boleterife lelaie, tetoo eetegeni inengoi mei ame brege brege aterife lelaie, eetetie eesalu lie ameelutu tetoo fweelutu, itu, i wifulu soulu aieaie alabe. ");
INSERT INTO kwo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Te lie pi naleleeke, te wosi mei ame wi leleeke, metie fwee atukwe lebe. Sabei Paielulu lietu sekalebe, tetoo nalilu takilule suagrile fetou nerife lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tetoo eetegeni lietu inalilufwa mareteku Paielulu bilutu aikopi leterife fifieri nafoomenelu nanoo ame eetei paie napooneke tetoo wolilu laprueleri lemerife lelane.’  ");
INSERT INTO kwo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Te oone Israelefu inalilufwa oone menanoo nale bie amwi filabu! Gote Nasaretefu Jiseselu amei te yesou te yesoule, brege brege atemeleelule, tetoo oone rame lerife nali nafoleeke rielee. ");
INSERT INTO kwo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tefe Gote eetegeni lufwale oonanoo amei tepolemolee, ute nali i neleelu menengule woroo lefolee. Te oona na kaiseklile mwate mwate lefoolananelu lufwalu amei seinatemoke, kafi niletu koko nemoke, tafilalee. ");
INSERT INTO kwo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mwa. Gote eetegeni lufwale wolu kelafoleeke, nanoo nembulu teteree faleleeke, tafilaleelu glei oolume lefoleeke lamelee. Te tafilu glei belemebe. ");
INSERT INTO kwo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Te bebriefe mei Devite nanoolufe eese nelee, ");
INSERT INTO kwo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tefe menanoo menengu metie mutukwe leoolali paie paie alarilu nale nie. Mene yesou merekeilule ooletelaie, Gote menane leworife lelaleelule. ");
INSERT INTO kwo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Oone menane naifofulu wokei glei ooloome leoolalu oolalafe, mwa. Te oone glei ooloome lefoolale oonanoo Wolilu Lufwa lufwalu ree tupulu sekura lebe. ");
INSERT INTO kwo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oone menane oofulilu eetei paie nerilu afweele wolu fetou nawolu. Mene weife lalarife ooloome leoolalu, tetoo mene sameme menengu mutukwe lelafe.’ ");
INSERT INTO kwo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Apane wofoliane! Mene oonane ambue Devitelufe amwi namorife lelaie. Nanookoe wolu bebriefeme tafilaleeke ti menei fatine. Te nembue mena ame eetei fatinelu wokoo Jerusalemei lalane. ");
INSERT INTO kwo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Devite Gotelu ragoofu nale alipoolaleelu lufwa. Nanookoe wolu rame lelee, Gote nalilu bilutu bi nafolee, ‘Sabei oonambuanelufu lefoo tarifu bofoo ame oona kememe kinefe lerife lelalee.’ ");
INSERT INTO kwo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Neembeefile fetafwaleefe, tefe Kraisele boe furaleleelufe nafolee, te Gote Kraisele glei ooloome lefoleeke troonalenelu inalilufwalu wokei oolalabe. Te teime glei sekura lelee. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Eetetie Jisesele Gote wolu kelafoleeke oofulilu lalalee. Tefe mene menanoo ootu fetanelufe, tefe mene na kulifi lemoolane. ");
INSERT INTO kwo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jisese wolu waleeke Gotelu amee feti porite oolalalee. Te Yarilu amefu Wolilu Fifrile wolu fanelee, bebriefe nasi lefoleelu atukwe. Te Jisese wolu menafe nalilu Fifrile sunalelee tefe oone fiemoomelu genile nembue fetalamo. ");
INSERT INTO kwo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devite glei efeneile walee. Mwa. Devite nali nelee, ");
INSERT INTO kwo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tetoo mene inepane oonane oorerei leoolanelule eetete mene ame oonanoo tukwia ambei teponuewofe.”’ ");
INSERT INTO kwo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tefe oone Israelefu pane, oone maretekume bie amwime rame lebu, Gote nali eetetie Jisese oona kafi niletu koko nemolule, wolu Paielufe lefoleeke, Kraisefe lefolee.” ");
INSERT INTO kwo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Inalilufwa Pita alipoteleelu nale finelu, metie nanoolu menengule wopitu atukwe puketerialeefe tefe menengu metie ti napotelane. Tefe Pitale tukwe aposelele tukwe eese natene, “Apane, menaboe akeke lebile?” ");
INSERT INTO kwo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Te Pita fune natelee, “Oonanoo fwagilu ameele mufenuetemoke tetoo oone mareteku Jises Kraiselu bilutu melei pienumobee. Tetoo Gote oonanoo fwagilu ameele menengufule wogrinatemoleeke tetoo Wolilu Fifri reeme seenalemobe. ");
INSERT INTO kwo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bebriefe Gote oonane nasi namoleelu nali nalilu Wolilu Fifri reeme seenalemorife oonanoo arile tukwe, mokenefu lalanelu inalilufwale tukwe. Te Paielu menanoo Gote nali oonane mareteku fieri namoleeke, te nasi lemolee, tetoo nalilu Wolilu Fifri reeme seenalemorife.” ");
INSERT INTO kwo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita nanoo Jiseselufime kaisekli lelari na te na te nale alipotelali, te natelee, “Oone fwai! Oone oonafe amwime tootookoo lelamoi lalabu! Oone kose ekepane lufwa, Jisesele mwate mwate ameetu teiefooneke tafilaleelu panetu, mare kose mwa lebule.” ");
INSERT INTO kwo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pitalu na metie inalilufwa telulu menengule atukwe kuraleteleefe, tefe melei pienune. Te ekeni krietu inalilufwa Jisesele menengoi ifelalanelufile yepreipoonelu inalilufwa metie 3,000 letelee. ");
INSERT INTO kwo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tupane nanoo aposelelu nale fietemerife tebiri nalemenei, te mare luku luku alanei apanele aikopi letelane, te Jisesele same lefoolanei kakali lerife, te na woponefori ameele tukwe afwalane. ");
INSERT INTO kwo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Te Gote nalilu aposelelu amei te amee te ameele letelali, inalilufwa mareteku fetateneke metie betige leteneke, wofri lelane. ");
INSERT INTO kwo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jisesele menengoi ifelalanelu pane nanookoe mwamole menengutu lalanei, te yesou te yesoufe nali kwaife aikopi alanane. ");
INSERT INTO kwo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Te tupane nalilu inengule, yesou bofoole, ekeni yesoufi bwalee peenerife seinatenei, te ekeni bwaleele peenelanelule yesoufe lulu napoolananelu panele lemwamo letelanane. ");
INSERT INTO kwo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Te te krie te krie mareteku sameme Gotelu ite geeneri menei luku luku alanei, te ite ite alanei fori yesoufe paie paietu alefe kakali alanane. ");
INSERT INTO kwo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Te nanoo Gotele paie paietu saue nafoolanei, Judafu inalilufwa mareteku nanoolu wolilu ameele fetateneke, menengu mutukwe letelanane. Te te krie te krie, Paielu eetei paie naporilu menengule tekee naletelaleelu ameelu metie peenalerime lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bofoo lietu, Pita weife Jonetu Gotelu iteile wane, feiferi lietu lie oolu wolu mwangifelufi lelali, Judane Gotele na woponefoolananelufe, tefe weife walane. ");
INSERT INTO kwo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Te lufwa telu kuli troonalefoonelu lufwale rokweefi terineke siyenene. Ekeni lufwalu kulikoe wolu arememe nembuari lefooneke tetoo yefee lupolelee. Tetoo te krie te krie nanoo Gotelu ite geeneri ambleneile iferie iferie ifalanane, eetegeni ambleni Pife Leleelu Ambleni nafoone. Eetei siyeneneke, lalaleealee, tetoo inalilufwale maretekume preipo preipo alanei bwaleefe sameme nini natelaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Te ekeni lufwa Pita weife Jonetu Gotelu iteile wopreiporife lelanei fetateleefe, tefe bwaleefe nini natelee. ");
INSERT INTO kwo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Te Pita weife Jonetu ekeni lufwale ooriri nafoolane. Te Pita nafolee, “Sei, oone menanoome oorila.” ");
INSERT INTO kwo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tetoo ekeni lufwa metie nanooleme oo teime letelalee. Nanoolu menengu eese nelee, “Menane ame bwaleele fanewobile.” ");
INSERT INTO kwo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tetoo Pita boe nafolee, “Mene bwalee letifelu glei talaiei. Mene kame menengu bofoo talaieluleme naworife lelaie. Mene nembue oonane Nasaretefu Jises Kraiselu bilutu naoolaie, ‘Oonete furaleluke wa.’” ");
INSERT INTO kwo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Te Pita ekeni lufwalu amee fetifi beletalali, te temerife boletalee, esulu nanoolu kuli gurelu isepulutume metie boe amwime kaisekli lefoone. ");
INSERT INTO kwo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Te prubuna leleeke, tesulu amwime temeleeke wari alee. Te Pita weife Jonetu wopreipoolanelufe tetoo nanoo mei marememe preipoone. Te Gotelu ite geeneri menei metie prune prune afwalali, tetoo Goteleme paie paie feti afwafoolalee. ");
INSERT INTO kwo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Te inalilufwa mareteku ekeni lufwale wari alali Gotele paie paie ifalali fetanelufe, ");
INSERT INTO kwo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","tefe mareteku metie menengu ti napotelane. Te wolu rame lefoone, eetegeni lufwakoe Gotelu ite geeneri Pife Leleelu Amblenifi lalali, inalilufwale bwaleefe nini natelaleealeelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Inalilufwa metie betige leneke, te maretekume pipi napooferine ekeni lufwale fetarife, nanoo tupanele fwakee ifeleteleeke temelalee. Gotelu ite tiki bilu Solomonelu Tiki nafoonelufi. ");
INSERT INTO kwo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita eetele fetaleeke, te inalilufwale natelee, “Israelefu pane, ooneboe glefe eetegeni ameele fetamolufe betige lelamo? Ooneboe glefe mare feti oo teime lepolamo? Oonekoe menane weife eese nelamo pai, menanoo kaiseklilutu sere lefoone nemo? Eete mene weife Gotelu oofi amwime lalanelufe, tefe eese nafoonelufe wari alee nemo pai? ");
INSERT INTO kwo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahamelu, Aisekelu, Jekopelu Gote, nali eetetie menanoo ambuanelu Gote, Jisesele Paielufe leleeke lalarife namunefolee, Gotelu naleme futeni mwamole lefoolaleealeelu lufwa. Oona eetegeni lufwale oorerei panelu amei tepoletemolu, Pailate tepoleleeke warife leleelu, mwa, oona mareteku Pailatele ulabee nafoomo. ");
INSERT INTO kwo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Eetegeni lufwakoe Lie Platefu Lufwa, te nanoo Kame Gotelu Naleme Nifelaleealeelu, mwa, oone Pailatele ulabee nafoomolu, te oone lufwa bofoo, kame merekei amee leteleelu lufwale tepolemolee. ");
INSERT INTO kwo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Lufwa Mena Eetei Oofulilu Falerilu Afoi Sinerife Leleelule oona metie teiefomoke tafilalee. Mwa. Nanoo Gote nali wolu tafi luananelufule kelafoleeke, te furaleleelule mene weife menanoo ootu fetanelufe, tefe mene eetegenife alipoolanane. ");
INSERT INTO kwo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mena Jiseselu bilufime, oona rame lefoomolu eetetie boe woli leleeke, temelali fetalamo. ");
INSERT INTO kwo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Marena, apane, mene wolu rame lie oone oonanoo nambulelanelu lufwatu mare glei Jisesele amwi rame lefoomelufe tefe eesalu amee lefomo. ");
INSERT INTO kwo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Eetegenife, tefe bebriefe Gote nalilu ragoofu nale alipomenelu lufwalu ragoofi eese naferilaleelu, nalilu Kraisele ame selilu tetereele faneneke, tafilabe nafoleelu, wolu sekalelee. ");
INSERT INTO kwo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tefe oona menengu wolilule falerife nemoi, nembue oonanoo fwagilu ameele mufenuetemoke, tetoo Gote nali wogrinatemobe. ");
INSERT INTO kwo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tefe nembue oone eese letemoi, tetoo Paielu oonane amwime tootookoo lelarilu menengu wolilule fanemobe. Te Gote ame Kraisele nafoleeke, boe riebe, eetegeni Kraise oonanoofe namunefoleelu. ");
INSERT INTO kwo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jisese nembue efenei lalali, eetegeni liele oolefoolalee. Gote wolu namunefolee, nali te yesou te yesou boe woli lerife, tefe bebriefe Gote nalilu ragoofu nale alipomenelu lufwalu ragoofi nelee. ");
INSERT INTO kwo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bebriefe Mosese nelee, ‘Paielu oonanoo Gote ame ape bofoo oonanoofule namuneforife lelalee, tetoo nanoo mene keme Gotelu ragoofu nale alipoolarilu lufwafe lebe. Te glelu glelu nale oonane na namoolali, tetoo oone nalilu naleme nifelabu. ");
INSERT INTO kwo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Oonanoofu bofoo ine ekeni lufwalu nale niferi preme lelali, eetete mwa, Gote nali ame nanoole metie teiefoleeke tetoo nanoo glei Israelefu inalilufwafe leleeke lalabe, mwa.’  ");
INSERT INTO kwo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Te Samuelelufi puleleeke, te nanoolu mwi leterilanelu Gotelu ragoofu nale alipomenelu lufwa mareteku eetegeni nafe naferinelu lie nembue wolu lebati lelee. ");
INSERT INTO kwo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gotelu ragoofu nale alipomenelu lufwalu nale tukwe, te Gote nali wolu ambuanelufe tukwe nasi lefoleelu oonafe tukwe lelee. Te Abrahamele nafolee, ‘Oonanoo arilu arifime tetoo mene amwime letelafe inalilufwa mareteku eetegeni inengu lemeleelu atukweme.’ ");
INSERT INTO kwo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Te Gote nali wolu nalilu naleme futeni mwamole lefoolalee aleelu lufwale namunefoleelu, te nanoo oonanoofile molukwe riemolee, oonane amwime lemorife, tetoo oone mareteku mwamole mwamole rame lefomoke, te oonanoo fwagilu ameele marekulitu wogrinelabule.” ");
INSERT INTO kwo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita weife Jonetu inalilufwale ame na ifenatelanei, tetoo Gotelu prisane, Sadyusiane, te Gotelu itele regi lefoolananelu yefeelu lufwa mei mareteku rineke yefetatene. ");
INSERT INTO kwo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nanoo eesalu menengu letene, Pita weife Jonetu inalilufwale Jisese tafilaleeke wolu boe furaleleelu nale, te inalilufwa wolu troonalenelu mei ame boe fufuru nerife lelane natelanelufe, tefe tupane metie fame menengu letelane. ");
INSERT INTO kwo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Te nanoo Pitale weife Jonetu bebeneneke, na ifenaterife lenelu. Mwa, lie oolu wolu ambei yetemelaleefe, tefe kalabuse itei sinateneke, wolune. ");
INSERT INTO kwo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mwa. Inalilufwa motukwe eetegeni nale fineke, Jisesele menengoi ifelalanelu panelu ameelu wolu 5,000 lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Te bofoo lietu Judafu nambulelanelu lufwatu, Judafu yefeelu lufwatu, na kaisekli ramelu lufwatu mare Jerusalemei lukulene. ");
INSERT INTO kwo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Te Anase Gotelu prise paie tefoo, Kaiafase, Jone, Aleksandere, te Anaselu weeluane mei mareteku lukulene. ");
INSERT INTO kwo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tupane Pitale weife Jonetu nanoolu oofi na ifenatelanei, te eesalu fieteri letene, “Oonaneboe kaiseklilu ine fanemolee, tefe eesalu ameele lemo? Te boe inelu bilutu eesalu ameele lemo?” ");
INSERT INTO kwo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wolilu Fifri nali Pitale seenalefoolaleefe, tetoo natelee, “Oone Judale nambuletelamolu lufwatu yefeelu lufwa mare, ");
INSERT INTO kwo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","oone nembue eetegenife pe menane fierife lelamo, mene weife kuli nembuari lefoonelu lufwale aikopi lefooneke woli leleelule rame leforife? ");
INSERT INTO kwo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Eese nemoi, tetoo oone mareteku Israelefu pane oone bie rame lebu, Nasaretefu Jises Kraiselu bilu kaiseklilutu eetegeni lufwale kuli boe woli lefooneke, oonanoo oofi nembue eetetie temelalee. Oone Jisesele tafilarife kafi niletu koko nemolu, mwa, Gote boe wolu kelafolee. ");
INSERT INTO kwo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisese nanoo golinai oone itele tupoolamolu pane nembulu nemoke woponemolu, mwa, nembue nanoo wolu wagulelufe freleneke temelaleelu golinaife lelee. ");
INSERT INTO kwo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mena lufwa bofoofi glei paie napobile. Mwa. Jiseselu bilutumeme mena inalilufwa mareteku amwi lapruelelabile. Gote nalifeme namunefolee, tetoo mena eetei paie naporife.” ");
INSERT INTO kwo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Israelefu paie tefoo pane Pitale weife Jonele tukwe rame letenelu nanoo kame wokoofu lufwa. Nanoole fetatenelu nanoo weife na aliporife metie tebiri nalemene, tefe ekepane menengu ti napoletelane. Te Jisese weife ifatemeleelule wolu rame letene. ");
INSERT INTO kwo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Te ekeni lufwa nanoolu ree nemboue leleeke weife ifetemepoolanelule fetanelufe, tefe nanoo na bofoo Pitale weife Jonele tukwe fune naterilu mwa. ");
INSERT INTO kwo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tefe tupane paielu lufwa nanoole weife natene, “Eetegeni Israelefu paie tefoo panelu ite menefu titirinemoke wabu,” te grialetene. Te weife wolu wanei, tetoo nali kwaife na faleneke te nene, ");
INSERT INTO kwo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Mena nanoole boe glelu ameele letebile? Mwa. Nanoo weife wolu eetegeni lufwale amwi sere lefoonelu na ulu Jerusalemefu inalilufwa maretekume wolu rame letewane. Tefe mwa, mena glei eetegenile ambutelefobile mwa, gigime feti lelee. ");
INSERT INTO kwo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tefe akeke letebile, bie mena ble natebile. Tetoo nanoo weife eetegeni bilule kose mare inalilufwalu futenei wee wee ifeletewabile.” ");
INSERT INTO kwo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Te fieri natene na ifenatenelu ite gueile rine, te rineke, nanoole weife Jiseselu bilule kose fetou fetou natelabile mani, te Jiseselu bilutu nale fatitewatenarife mei ble natene. ");
INSERT INTO kwo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nanoo eese letenelufe, tefe Pita weife Jonetu fune natene, “Sei, oone bie menengu lebu, Gotelu oofi glelu amee nemboue lelee? Mene weife oonanoo nale pe nifemobile, o Gotelu nale pe nifebile? Bie oonameme eetegeni nale menengu menengu ifabu. ");
INSERT INTO kwo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mwa, mene glei kame naleme fineke alipoolanei, eie, menekoe weife menanoo ootu fetanelufe, tefe mene weife metie sameme eetegeni nale alipotelarife lelane.” ");
INSERT INTO kwo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Esulu ekepane lufwa boe same ble natene. Nanoole teieterilu afwee gigime letelee, tefe kame ooloome leteneke wane. Inalilufwa mareteku Gote eesalu amee ekeni lufwale lefoleelule fetanelufe, metie Gotele paie paie ifelelanelufe, tefe tupane inalilufwale wofri letene. ");
INSERT INTO kwo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Te eetegeni lufwale nanoo sere lefoonelu mei nanoolu yare wolu 40 lefoleelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ekepane nanoo Pitale weife Jonele tukwe kame teponuneke wane. Te esulu waneke nalilu moanele wofetateneke, te ekepane ifenatenelu nale oonatene. ");
INSERT INTO kwo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Te nanoo wolu fietelaneke, te mareteku menengu mwamole leneke, Gotele na woponefoolanei eese nafoone, “Paielu Gote, oone liele, inengule, mwi meleele, yesou yesou mareteku eetegenifi laifwanelule letelulu Gote. ");
INSERT INTO kwo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bebriefe menanoo ambue Devite, nanoo oonanoo amee amee lufwa, nanoole Wolilu Fifri menengu bofoole faneleelu, eese nelee, ");
INSERT INTO kwo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Eetegeni inengufu kine nanoo famefe maretekume lukuleneke, te nambulelanelu lufwa mei wolu mare sagoo lene, tetoo Gotele tukwe nalilu Kraisele tukwe oorerei letelarilu nale falelane.’ ");
INSERT INTO kwo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Eetete marena, Herot Antipase, Pontius Pailate, rawie inalilufwa, Israele nali kulifi mare eetegeni wokoo soulufi sagoo leneke, oonane amee amee aoolaleelule wolilu lufwa Jisese, ute bebriefe oona namunefolulule teiefori nale falelane. ");
INSERT INTO kwo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Eetegeni amee nanoo eete lenelu eetete oonanoo menengufu menenguleme nifelane. Bebriefeme oonanoo kaiseklitu eetegeni yesoule lebati lerife nelulu. ");
INSERT INTO kwo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Paielu, nembue oone menane menengu lela, nanoo menane wofri natu mare yegrinelanei wopitu atukwe pukelane, tefe oone mene oonanoo amee amee lufwale aikopi leluke, kuli reenelepoolalu tetoo oonanoo nale alipoolabile. ");
INSERT INTO kwo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tetoo oonameme kokou reele unapoofwatelalu, te te yesou te yesoule brege brege letewatela, Jiseselu bilutu, oonanoo amee amee aoolaleelu wolilu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Te nanoo na woponefooneke, esulu Gote eke lukuleneke lalanelu itele alinelee. Te Wolilu Fifri inalilufwale mareteku seenaletelalee tetoo Gotelu nale alipotelarife, tebiri nalelanei, glei ragoo tepolelane. ");
INSERT INTO kwo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Inalilufwa mareteku Jisesele menengoi ifelalanelu nanoolu menengu mutukwe lepotenelufe, metie mwamole menengutu leneke, alane. Bofoo inalilufwa glei nalilu yesoule fetateleeke te eese nebe, “Ekeni yesou eete nianoo.” Mwa. Nanoolu yesou mareteku ifelatelananelukoe nanoo metie alefe ifatelanane. ");
INSERT INTO kwo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposele nanoo kame Paielu Jisese boe furaleleelu nale alipoolanelu, mwa, eetegeni na nanoo metie kaisekli letelalee. Gote nali nalilu inalilufwale mareteku ooretatelali, te aikopi letelalee. Te ekepane inalilufwa nanookoe metie nalilu ameime amwime alanane. ");
INSERT INTO kwo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ekepanelufu bofoo glei yesoufe lulu nenane. Mwa. Ekepane inalilufwa telu nalilu itele, inengule bofoofu lufwale bwaleefile seine seine atelanane. Te bwalee nifwatenei, tetoo ekepane inengu yari, ite yari ekeni bwaleele tewapooneke, ");
INSERT INTO kwo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposelele nifwatenane, ekeni bwaleele yesoufe lulu nelanelule aikopi letelarife. ");
INSERT INTO kwo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Te ekeise mei lufwa bofoo lalalee. Nanoolu bilu Josepe nafoone. Te boe aposele nali bofoo geni bilule fanenelu, Barnabase. Eetegeni bilu yewilu eese lelee, “Inalilufwale menengu wolilule fanetelaleealeelu lufwa.” Barnabase Livailu weelufu lufwa, nanoo Saipruse wokoo tupulufu. ");
INSERT INTO kwo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nanoo mei nalilu inengu monguelu bofoole bofoo lufwale seinafoleeke, tetoo ekeni lufwa bwaleetu falefolee. Te ekeni bwaleele faleleeke terieleekeme aposelele yefanetelee. ");
INSERT INTO kwo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ekenifi lufwa bofoo lalalee, bilu Ananaiase nafoonei, te nariemulu bilu Safaira nafoone. Bofoo lietu Ananaiase weife nariemutu inengu monguelule bwaleefile fanetene. ");
INSERT INTO kwo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Te ekeni bwalee monguelule nalife ambutelelee. Te bofoo monguelule tewaleeke aposelelu amei fanetelee. Te nariemu mei nunguli ekeni amee leleelule wolu rame lelee. ");
INSERT INTO kwo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Te Pita Ananaiasele nafolee, “Boleboe glelu yewilufeme Sebore Lufwa oonane seenalewoleeke, oonanoo inengu monguelufi falemolu bwaleele Wolilu Fifrile ambutelefolu? ");
INSERT INTO kwo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Oone ekeni inengule kame oonanoo menengume bwaleefile fanetelu. Bwalee oone falelulu eetete oonanoo yesou, oona glelu yesou lerife nelu kame oonanoo menengutu le. Ooneboe glefeme wolilu menengule faleri preme lelu? Oone glei lufwale meme natelu, mwa. Oonekoe Gote nalifeme meme nafolu.” ");
INSERT INTO kwo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaiase eetegeni nale eese nafoolaleelule fieleefe esulu yeferaleleeke tafilalee. Te lufwa Ananaiasele lefoleelu nale finelufe metie wofri letewane. ");
INSERT INTO kwo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Te ari rawielu rineke Ananaiasele buluetu funeke te tewaneke, ti menei wofatine. ");
INSERT INTO kwo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nunguli tafilaleelu lie oolu wolu mwangife leleeke, tetoo nariemu mei rieleeke yepreielee. Nanoo glei fielee nunguli tafilaleelu nale. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Te Pita nafolee, “Bie oone mei menane amwime nawo, oone weife sugulitu oonanoo inengu monguelufi falemolu bwaleekoe eetetie eesame pai?” Te fune nafolee, “We, eetetie kame eesame falenelu.” ");
INSERT INTO kwo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Te Pita nafolee, “Ooneboe glefe weife sugulitu na falemoke Paielulu Wolilu Fifrile sulu pe lefoolamo? Bie fie, sugulile wofatinelu lufwa eketie wolu amblenei yetemepoolane, tetoo oonane tewawobile.” ");
INSERT INTO kwo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tesulu Pitalu kulifi yeferaleleeke, tafilalee. Te ari rawielu yepreipooneke ekeni inalile tafilaleeke lalali fetanelufe, tesulu ree tupulule faleneke tewane ti menei nungulilu babrilufi fatierife. ");
INSERT INTO kwo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tefe Jerusalemei Gotelu inalilufwatu te inepane ekeni yesou eese leteleelu nale finelufe nanoo mareteku metie wofri letewane. ");
INSERT INTO kwo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposele inalilufwalu oofi te yesou te yesoule brege brege atemenelu amee, eetegeni glei nalilu suagritu atemene, mwa. Te Jisesele menengoi ifelalanelu inalilufwa nanoo mareteku menengu mwamoletu Gotelu itei wopreipooneke, Solomonelu tikifi lukuwolanane. ");
INSERT INTO kwo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Inalilufwa Jisesele menengoi ifelalari preme lenelu nanoo Jisesele menengoi ifelalanelu inalilufwale reeyemee letelane, tetoo ekepane inalilufwa wofri leteneke tefe glei waneke wofetatenane. ");
INSERT INTO kwo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tetie sameme inalilufwa motukweme Jisesele menengufi ifelalanelufe, tefe ameelu metie peenalerime lelalee, motukwememe lufwa te inali mei ririane. ");
INSERT INTO kwo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Inalilufwa aposele brege brege atemenelu yesoule wolu rame letenelufe tefe kokou ree tefoole afoile ifwateneke, rokweefi, isepufi fuenufwaneke, te Pita boore letewateli tetoo nanoolu yemelarilu fwarinepoofwaterife. ");
INSERT INTO kwo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusaleme bwagei lafwanelu wokoofu inalilufwa nanoo mei ririaneke, aposelele yefetatene. Nanoo kokou ree tefoole tukwe bibri nafe alanelu inalilufwale tukwe ifwatene. Eetepane inalilufwa nanoo maretekume ree fuenetewapotene. ");
INSERT INTO kwo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Gotelu prise paie tefoo moane mare, nanoo Sadyusilufi alanelu, aposele brege brege aferietenelufe tefe nanoole tupu letelane. ");
INSERT INTO kwo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Te ekepane nanoo mareme, aposelele bebeneneke, nembulu ameele alanelu lufwa kalabuse itei lalanelufile ifwatene. ");
INSERT INTO kwo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Te eke sinatenelu krietu, Gotelu ensele kalabuse ite amblenile oorapoteleeke te neunateleeke wane. Te ekeni ite alufi ifetemepotelali, tetoo natelee, ");
INSERT INTO kwo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Oone mareteku nembue eetefu wamokeme Gotelu ite geenerime wopreipomoke tetoo inalilufwale sameme lafwalarilu oofulilu nale alipotebu.” ");
INSERT INTO kwo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aposele ensele na natelali fiefoolaneke te kwotuekrieime oo puku netereli wanekeme, Gotelu ite geenerime wopreipooneke, tetoo inalilufwale Gotelu nale alipotemene. Eetegeni lietu, Gotelu prise paie tefoo, nalilu moane mare nali lukulenanelu itei kuruleneke, te Israelefu paie tefoo panele na wawateleeke lukuleneke na falerife. Ekeni lufwa nanoo mare Israelelu yefee yefeelu lufwa. Te tupane lufwa telule na kalabuse iteile watelee, aposelele iferieterife. ");
INSERT INTO kwo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Te Gotelu itele regi lefoolananelu lufwa kalabuse ite amblenile oorapoonelu, mwa, aposelele glei fetatenelufe te boe waneke natene, ");
INSERT INTO kwo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Mene ekeni itefu amblenile amwime kapupoofwaneke, te kalabuse itele regi lefoolananelu lufwa mei amblenile regi letelananeluleme fetatene. Mwa. Mene ekeni ite amblenile oorapoofwanelu, mene lufwa bofoo glei menei lalali fetane.” ");
INSERT INTO kwo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Gotelu itele regi lefoolananelu yefeelu lufwatu mare Gotelu prise yefeelutu ekeni nale natenelufe, mwa, nanoolu menengu ti napoteneke, te nene, “Pasoa! Ekepane boe akeme lene?” ");
INSERT INTO kwo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Te lufwa bofoo rieleeke ekepanele natelee, “Bie filabu, oone eke kalabuse itei sinatemolu pane nanookoe Gotelu ite geeneri menei wotemepoolanei Gotelu nale walipotelane.” ");
INSERT INTO kwo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tefe ekeni Gotelu itele regi lefoolananelu yefeelu lufwa nanoo nali mare amee amee alanelu panetu, boe waneke aposelele neunatene. Nanoo glei noopoo nateneke bofoo amee letenei. Mwa. Nanookoe inalilufwale wofri letene, menane kose titu peperee napobile nene. ");
INSERT INTO kwo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ekepane lufwa aposelele iferieteneke Israelefu paie tefoo panelufi sinatene. Te Gotelu prise paie tefoo ");
INSERT INTO kwo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","natelee, “Mene oonane wolu ble namoone inalilufwale na alipoterife ekeni lufwalu bilutu, mwa. Oonekoe metie sameme alipotelamoi, inalilufwa mareteku Jerusaleme poritefu wokoo wolu fieri ningilume lelane. Oonekoe eetegeni na menane yeponelamo eetegeni lufwale teiefooneke, tafilarife.” ");
INSERT INTO kwo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mwa. Pita aposele mare fune natene, “Mene Gotelu naleme nifelarife lelane. Mene lufwalu nale glei nifetelabile. ");
INSERT INTO kwo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Menanoo fetalilu Gote Jisesele kelafoleeke furalelee, oona kafi niletu koko nemoke, kweinelali tafilaleelule. ");
INSERT INTO kwo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Gote nali wolu neuneleeke, nalilu amee feti porite lafoolalee. Nali menafe afweele fetou napori lufwafe leleeke, tetoo paie naporife. Te mena Israele fwagilu ameele amenelufe tefe Gote menafe aikopi lepolee, tetoo mena menanoo fwagilu ameele mufenueteneke, tetoo nali menanoo fwagilu ameele wogrinebe. ");
INSERT INTO kwo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mene eetegeni yesou Gote leteleelule fetatenelufe, tefe mene mei eetegeni naleme alipoolanane. Te Wolilu Fifri mei eetegeni yesou naleme alipoolaleealee. Inalilufwa Gotelu nale fineke, nifetalaneluleme Gote Wolilu Fifrile fanetelee.” ");
INSERT INTO kwo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ekepane lufwa eetegeni nale finelufe, mwa, nanoolu menengu metie salu lepotene, aposelele kworootu bebeneneke troonalerife. ");
INSERT INTO kwo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tefe ta Farisi bofoo, ipoelu lufwa bilu Gamaliele, Gotelu na kaisekli ramelu lufwa, inalilufwa mareteku nanoole reeyemee lefoolanane. Te Gamaliele Israelefu paie tefoo panele natelee, “Bie ekepanele natemoke, ite alufi oolepolelabi.” ");
INSERT INTO kwo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wolu kuruyeleneke temepoolanei, te paie tefoo panele natelee, “Oone Israelefu pane, oone tupanele glelu amee leterife nemoi, bie oonafe amwime menengu lemoke, tetoo eese letebu. ");
INSERT INTO kwo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Oone wolu rame lemo, glei mwamue, lufwa bofoo Teudase nafoonelu natelee, ‘Mene yefeelu lufwafe lie.’ Lufwa guei nifetamenelu mei ameelu 400 letelee. Ekenife Romefu yefeelu feti lufwa nalilu kworoofame lufwale nateleeke, tetoo teiefooneke tafilalee, tefe nalife nifetamenelu pane mei brune brune aneke, ekeni amee amee mei same mwa letelee. ");
INSERT INTO kwo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Te ekeni lietu inalilufwalu bilule peenetelanei, tetoo lufwa bofoo Galilifu, Judase nafoone, inalilufwalu menengule tuteli letelee, tetoo Romefu yefeelu lufwale ifapureterife. Te Romefu pane teiefooneke tafilalee. Tefe Judasele nifetamenelu inalilufwa mei brune brune ane. ");
INSERT INTO kwo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tefe nembue mene oonane namoolaie, tupane aposelele kose bofoo amee letebule mani, kame ooloome letemoke wabi. Tefe ekeni amee amee nali lufwalu menengutu lelanei, eetete mwa letebe. ");
INSERT INTO kwo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nanoo eetegeni amee amee Gote nali leleeke letewali, eetete oone glei ble natebule. Oone kose Gotele ifapurelebule.” Te tupane Gamaliele nateleelu nale nifene. ");
INSERT INTO kwo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Te aposelele fieri nateneke iferietene. Tetoo lufwale nateneke, bubuapooneke, te Jiseselu nale inalilufwale alipotelarife ble natelaneke, teponuneke wane. ");
INSERT INTO kwo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Te aposele Israelefu paie tefoo panele grialeteneke, wane. Te waneke Gotele paie paie afoone, Gote nali eesalu menengule letelee, nanoo nemboue Jiseselu bilufi reeyemee falerife. ");
INSERT INTO kwo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Te te krie te krie, aposele Gotelu iteile wari amene, te ite ite letewalanei mei, nanoo glei eetegeni amee ameele tepolene, inalilufwale nale fetou fetou afwatelananelutu, alipotemenelutu eetetie eese natemene, Jisese nali Kraise, Gote nali inalilufwa eetei paie naporife namunefoleelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Te ekeni krietu, disaipelelu ameelu metie foo lelali, tetoo Grike natu nelanelu disaipele nanoo Hibru natu nelananelu disaipelele legulu letelanei, tetoo natene, “Te krie te krie oone inalilufwa fori yesoufe lulunelananelule aikopi letelamoi, tetoo menanoofu seiko seikolu inalile mei glei amee feenaletemwamo, mwa.” ");
INSERT INTO kwo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tefe tialootu tialootu aposele disaipelele mareteku fieri nateneke, lukulelanei, tetoo natene, “Mene Gotelu nale alipotelananelu amee ameele glei grialeneke fori yesou lemwamofe alabile, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tefe apane wofoliane, oone bie lafetebu tialoo mwamole lufwa oonanoofuleme, amee woliluleme nifelanelu inalilufwalu oofi, Wolilu Fifri seenaletelaleelu, wolilu menengu tefoo lufwaleme. Tetoo ekepane lufwa nanoo yesou lemwamofe alabi. ");
INSERT INTO kwo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tefe ta mena eetete Aiele sameme na woponefoolanei tetoo nalilu nale inalilufwale alipotelanei, aikopi letelabe.” ");
INSERT INTO kwo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Inalilufwa mareteku aposele nenelu nale fineke, tetoo mwamole menengutume Stivenele namunefoone, nanoo metie Jisesele menengoi ifelalaleelu, te mei Wolilu Fifri seenalefoleelu lufwa. Tetoo lufwa telule namunetenelu mei Filipele, Prokorusele, Nikanorele, Timonele, Parmenasele, Nikolasele. Nikolase Antiokefu lufwa, nanoo rawie, te nembue Gotele reeyemee lefoolaleealeelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tupanele aposelelufi sinateneke, te amee fatietelanei, Gotele na woponefoone eetegeni ameele lelarife. ");
INSERT INTO kwo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Te Gotelu nale wokoo wokoo wee wee ifeletewane. Tetoo Jerusaleme wokoo soulufi inalilufwa motukwe disaipelefe lene. Gotelu prise mei motukwe Jisesele menengoi ifelalarilu lufwafe leneke Gotelu nale nifelane. ");
INSERT INTO kwo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gote Stivenele ooretafoolaleefe, tefe Wolilu Fifri seenalefoolali, tetoo inalilufwalu oofi brege brege atelaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tefe mwa, lufwa telu Stivenele fune na fune na ifenene. Ekepane lufwa nanoo Judanelu alina itefu, ekeni itele eese nafoonane, Wolilu Lafieri Panelu Alina Ite. Ekepane lufwa wokoo bofoofu ririanelu Sairinifu, Aleksandriafu, provinse Silisiafu Esiafu eese ririane. ");
INSERT INTO kwo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mwanga! Wolilu Fifri Stivenele ramelu wolilule faneleefe, tefe ekepane Stivenelu nale glei mwate lefoonane. ");
INSERT INTO kwo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tefe ekepane angime telule tutulefe natene, “Mene Stivenelu nale fiefoonelu, Mosesele tukwe Gotele tukwe eeneri natelali fiefoone.” ");
INSERT INTO kwo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ekepane eese lenelu ameefi, tetoo inalilufwalu menengule, Judafu yefeelu lufwalu menengule, na kaisekli ramelu lufwalu menengule atukwe tuteli letenelufe, mwa, nanoo maretekumeme unetewaneke, Stivenele wobeleneke, te ifwane Israelefu paie tefoo panelufile. ");
INSERT INTO kwo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Te ekepane lufwa telule fime ameetu sinatene Stivenele te na te natu woglie yeglie ifarife. Te ekepane lufwa nene, “Eetegeni lufwakoe te krie te krie Gotelu na kaiseklile tukwe, Gotelu itele tukwe nalilu mwate mwate ameetu teieterife alalee. ");
INSERT INTO kwo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mene Stivene eese nelali fiefoone, ‘Nasaretefu Jisese ame Gotelu itele brinalebe’ nelee. ‘Te Mosese bebriefe menafe tinepoleelu ambuanelu alinale mei wabure yabure atebe’ nelee. ” ");
INSERT INTO kwo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Te Israelefu paie tefoo pane maretekume laprueleneke lalanei, Stivenele keree porite fetalanelu enselelu oofwafwalee atukwe lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Te Gotelu prise paie tefoo Stivenele eesalu fiefori lelee, “Ekeni na oonane eke yeponeoolanelu marena pe?” ");
INSERT INTO kwo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Te eetegenife Stivene fune natelee, “Apane, aiane, oone menanoo nale bie fieoolabu. Menanoo fetali Abrahame wokoo soulu Haraneile wari preme, ame teime Mesopotemiai lalali, efenefu Gote kaiseklilu tefoo menanoo ambue Abrahamele yefetalee. ");
INSERT INTO kwo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Te nafolee, ‘Oone oonanoo inengule, oonanoo retifule grialeteluke wa inengu bofoofile nia ame fetou nawofe.’ ");
INSERT INTO kwo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tefe Abrahame Kaldialu inengule grialeleeke, te waleeke wokoo soulu Haranei oolamelee. Yari tafilaleelu mwi, tetoo Gote nafoleeke, nembue oone eete lalamolu inengoile rielee. ");
INSERT INTO kwo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gote Abrahamele ekeise inengu bofoo tukweeme glei fanelee, tetoo eetei lalali, ekeni inengu tetoo nalilu nambuanelufu arile latelarife. Mwa. Gote eesalu nasi lefoleelu, sabei nali ame ekeni inengule fanebe, nalilu inengufe lefoleeke lafoolali, tetoo nalilu nambuanelufu arile tukwe latelabe. Gote Abrahamele ekeni nale nafoleelu, Abrahame ame ari preme alali, ");
INSERT INTO kwo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","tetoo Gote Abrahamele eesalu nale nafolee, ‘Oonambuanelufu ari ame waneke bofoo inengoi oolalanei yare 400 woletebe. Te ekeise mei oonambuanelu ari ekeni inengufu panelu ameime lalanei, te kame nanooleme amee amee letelanei noopoo natelarife lelane. ");
INSERT INTO kwo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mwa, eetegeni amee letenelufe nanoo ame nianoo nafi yenalepobile. Te sabei oonanoo ambuanelufu ari ame ekeni inengule grialeneke, boe rineke eetegeni inengoi menane reeyemee leoolarife lelane.’ ");
INSERT INTO kwo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Te Gote Abrahamele lufwalu ree leeloole kreenapoolarilu ameele fanelee, tetoo Gotelu nasile menengu lefoolarife. Te fimelufe Abrahame Aisekelu yarife lelee, tetoo Aisekele mei krie tialoo are lefoolali tetoo nalilu ree leeloole teka lefoone, te nanoo Jekopelu yarife leleeke, te nanoole mei eesalu ameeleme lefoone. Te Jekope nanoo tialootu tialootu ari kaporelu yarife lelee, menanoo fetaliane. ");
INSERT INTO kwo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ekepane Josepele tupu lefoomene, tefe nanoo kame lufwa wokoolu amei lalarife bwalee tei falerife seinatene. Te rawie wokoofu ifwanekeme Isipei siwonene. Tetoo ekenifi Gote nali metie amwime oofulinemelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Mwa! Nanookoe glelu glelu oo nembulufi lalali Gote nali aikopi lefoleealee. Te Gote Josepele wolilu ramelu nale wolilu ameele tukwe faneleeke ameli, te eetegenife Kin Fero Josepelu amee wolilule fetafoleefe, tefe kine metie paie paie afoolaleealee. Tefe Fero Josepele Isipei nambulelarilu lufwafe namunefolee, tetoo nalilu yesoule tukwe itefu inalilufwale tukwe ifelatelarife. ");
INSERT INTO kwo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Te ekenitu Isipele, Kenanele, nambwi lie letelaleefe, fori yesou gifefe troone troone alanelufe, tefe menanoo fetali mei fori yesoufe ange ange alane. ");
INSERT INTO kwo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mwa, Jekope fori yesou Isipei lailane nenelu nale fieleefe, tefe nanoo menanoo fetalile ‘Wabu’ nateleefe, te nembuame wane. ");
INSERT INTO kwo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Te boe wanelu tetoo Josepe yafeeanele eese natelee, ‘Nia Josepe eetetie,’ te ekenitume tetoo Kin Fero mei Josepelu weeluanele rame letelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Te Josepe yarile tukwe nalilu retifule tukwe, mareteku ameelu 75 lenelule, iferieterife yafeeanelu ragoo pi natelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Te Jekope Isipeile luwaleeke, oolalali, tetoo tafilalee. Te menanoo fetali mei maretekume teimeme troonalene. ");
INSERT INTO kwo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Te tafilule Kenanelu inengoi lalaleelu wokoo Sekemeile tewapo tewapo ane. Ekeni ti menee tafi eetei lualanelu Abrahame nali wolume Hamorelu lefooanelule bwaleetu faleteleelu. ");
INSERT INTO kwo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Te Gote Abrahamele nasi nafoleelu oo, eetetie wolu roboi lelalee. Te eketu Israelefu pane Isipei lalanelu ameelu metie foo letelalee. ");
INSERT INTO kwo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tetoo lufwa bofoo Isipelu kinefe leteleelu, Josepele rame lefori preme lelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Te ekeni kine menanoo fetalile nembuari leteri ameele oorafoolali, tetoo ari kaporele luponulanei babukotu wogrinelarife noopoo natemelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Te ekeni lietume Mosesele yefee lupolelee, nanoo nembouelu oofwafwalee tefoo ari. Yefeetu yaritu angime ite meneime gifemenei wosi mwangife letelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Te fimelufe yefee bulue tumweefi fueleleeke, ragoolule kretepoleeke, tewaleeke melei fatielee, tetoo Kin Ferolu luali fetaleeke, neunelee, nalilu arife leforife. ");
INSERT INTO kwo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Te ekenifi tetoo Isipe Mosesele wolilu rame ramelule mareteku teu lefooneke yefee letelee, tefe nanoo menengu keke naleleeke na nerilule tukwe glelu glelu ameele tukwe yefee letelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ekenitu, Moseselu yare ameelu wolu 40 lefoleeke, te nalilu retifu Israelele menengu letelee waleeke, fwainaleterife. ");
INSERT INTO kwo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mwa. Waleelu afoi Isipefu lufwa Israelefu lufwale teiefoolali fetaleefe, te Israelefu lufwale aikopi lefoleeke, Isipefu lufwale teiefoleeke, tafilalee. ");
INSERT INTO kwo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosese menengu lelee, nalilu yafeeane tetoo rame lerife, Mosese nalilu amei Gote aikopi leterife lelaleelule. Mwa. Nanoo glei eesalu menengu lene. ");
INSERT INTO kwo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Te bofoo lietu rieleelu, lufwa are Israelefuleme weife apurelemenei fetateleefe, te bebenerife waleeke, te roboime natelee, ‘Ei, womoo ape aga? Oone weife glefeme eesalu kikriti fame lememo?’ ");
INSERT INTO kwo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Te ekeni lufwa bofoole fame tewafoleelu Mosesele puleleeke te nafolee, ‘Oonaneboe ine namunewolee nambulelarilu lufwafe leluke menanoo nale fipwalelarife? Mwanga. ");
INSERT INTO kwo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Menekoe wolu rame lie oonekoe morietu Isipefu lufwale teiefolulu lufwa.’ ");
INSERT INTO kwo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosese eetegeni nale fieleefe, tefe Midianelu inengoile tialeleeke oolameli tetoo inali faleleeke ari kaporeleme are lelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yare ameelu wolu 40 lefoleeke, te Mosese Sainai Afune pepelu inengoi lalali, te Gotelu ensele senalenelu ka merilu bofoofi irilu reetu punepolefolee. ");
INSERT INTO kwo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosese fetaleeke, metie na nerilutu gigime lefolee eetegeni yesoule fetalaleefe. Nanookoe amwi fetafe neleeke roboileme walali, te Paielu nafolee, ");
INSERT INTO kwo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mene oonanoo ambuanelu Gote, Abrahamelu, Aisekelu, Jekopelu.’ Te Mosese metie remeruru nelali, oofwaneporife wofri lelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Te Paielu nafolee, ‘Oone kuli leeloole liganue. Eetegeni inengu oone temelalulu eetete nianoo, eete glei lufwalu. ");
INSERT INTO kwo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mene nembulu ameele nianoo inalilufwale Isipei letelanelule wolu fetatie. Mene nanoolu eele wolu fietie, te nembue eete tiralielu Isipelu ameefule boe neunaterife. Tefe oone Isipeile boe warife nawie.’ ");
INSERT INTO kwo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Eetetie Mosese, nali tupanele wolume na natelali te nanoolu nale mwate lefooneke, tetoo nafoone, ‘Oonaneboe ine namunewolee menane nambulelarilu lufwafe leluke menanoo nale fipwalelarife?’ Eetetie lufwa Gote namunefolee, Israelefu panele nambuletelali, tetoo nembulufule aikopi letelarife. Gotelu ensele Mosesele kafi punepo lefoleelu Mosesele aikopi lefolee. ");
INSERT INTO kwo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nanoo Israelefu panele Isipele grialerife brege brege atelee, te Retsile mei eese lelee. Te lufwa prelu inengoi mei, ifwafwatelali, te yare 40 letelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Eetetie Mosese Israelele natelee, ‘Gote ame oonanoo ape bofoole mene keme lerife namunefoleeke, tetoo nanoo Gotelu ragoofu nale alipoolarilu lufwafe leleeke lalabe.’ ");
INSERT INTO kwo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Eetetie nali menanoo fetalile lufwa prelu inengoi luku ifeleteleeke ifelatemeli, tetoo Sainai Afuneile peenaleleeke Gotelu ensele na ifenelee. Eetegeni na oofulilu tefoo Gote Mosesele nafoleelu, eetegeni nale boe menafe alipolee. ");
INSERT INTO kwo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Menanoo fetali Moseselu nale fierife ulabee nene. Nanookoe boe luluneneke Isipeile wari menengu letelane. ");
INSERT INTO kwo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tefe Aronele nafoone, ‘Mene glei rame lelane Mosese gleleme wolelalee, eetegeni lufwa Isipefule neunapoleeke eeteme iferipoleelu. Tefe oone bie menanoo gotele lete, tetoo nanoo menafe nambulelarife.’ ");
INSERT INTO kwo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Te eetegenitu bulmakau silu yemelarilule leneke, tetoo eetegeni gotele bole fanerilu saue nafoolanei, sabitu ye ne ye ne ifamene, nalilu ameetu lenelu gotele. ");
INSERT INTO kwo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tefe Gote mufeletelee, te ooloome letelali, tetoo liele, wosile, limwafule reeyemee letelabile neleeke, Gotelu ragoofu nale alipoolananelu lufwalu bukei lalaleelu na atukwe, ‘Israele inalilufwa oone lufwa prelu inengoi lamemoi yare ameelu 40 lememoi, tetoo bulmakaule, sipsipele puketemoke, ifi tupwalamolu amee, eetegeni amee menane pe leoolamwamolufe? Eie, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Eetegeni bole leeloo masekoni ite oone ambuketalamolu eete glei menanoo, eetete fime gote Molekelu. Te Refanelu limwafu yemelarilule mei ambuketamoome. Oone eetegeni gotelu yemelarilule reeyemee letemoke ooretaletememolufe, tefe mene oonane namwie oonanoo inengule grialemoke warife, tetoo wamoke Babilonelu inengu kumori porite oolalabule.’ ");
INSERT INTO kwo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Te menanoo fetali lufwa prelu inengoi lamenei, tetoo ekeise Gotelu bole leeloo masekoni itele tafoomene eetei reeyemee afoolarife. Te ekeni masekoni itei Gote eetei lalaleealeelu. Te ekeni ite tunelu mei Gote nali Mosesele nafoleeke fetou neleelu yemelariluleme nifene. ");
INSERT INTO kwo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tetoo ekenitu ekepane fetaliane bole leeloo masekoni itele faleneke te Josua mare rawielu inengule falerife rine. Te Gote nali menanoo fetalilu oofi tupanele sisi nafwatelee. Tetoo Gotelu bole leeloo masekoni ite teime tememeli, Devitelu lietume wolelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Te Gote ekeni lufwale amwi lefoolaleealee, tetoo nanoole na woponefoolali i nafoleeke Jekopelu Gote eetei lalarilu ite soulu nembouelule tueforife. ");
INSERT INTO kwo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mwa. Eetegeni ite soulule lefoo Solomone fime tuelee. ");
INSERT INTO kwo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tefe ta Paie Tefoo Gote lufwa ameetu tuenelu itei glei lalaleealee. Gotelu ragoofu nale alipoolaleelu lufwa eese nelee, ");
INSERT INTO kwo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Paielu Gote nelee, Efene eetete nia eetei lafieke lalaielu reeafwee gugulu, te inengue nia kuli eetei luaieke laieoolane. Tefe oone menane akekelu itele tuewobule? Tetoo mene eetei yenalelarilu tekoo akeporite oola oolabe? ");
INSERT INTO kwo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Niameme eetegeni yesoule mareteku letie.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Te Stivene Israelefu paie tefoo panele boe natelee, “Oone mwate mwate tefoo pane, oonanoo menengu metie kretapomooneke rawie inalilufwa fwagilu amee tefoo keme lemo. Tefe oonanoo futeni mareteku footepomooneke, tetoo Gotelu nale glei filamwamo. Tetoo utetu utetu Wolilu Fifrile metie mwate lefoolamwamo, oonanoo fetaliane bebriefe amenelu atukwe. ");
INSERT INTO kwo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Oonanoo fetaliane Gotelu ragoofu nale alipoolanelu lufwale bebriefe mareteku lamenelule teietene. Nanookoe bebriefe Lie Platefu Lufwa Kraise ame riebe natemenelule teietemenei troonalemene. Te nembue oone ekeni lufwa wolu rieleelule oorerei lufwalu amei sioonatemoke, teiefooneke, tafilalee, ");
INSERT INTO kwo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","oone Gotelu na kaiseklile nalilu enselefule falemolu, mwa, oone glei nifemo.” ");
INSERT INTO kwo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Israelefu paie tefoo pane Stivenelu nale fineke menengu metie nembuari lepotelanei, te neenee amee kukwapofoone. ");
INSERT INTO kwo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mwa. Wolilu Fifri Stivenele seenalefoolali, efeneme ooti lelali Gotelu takilu ranilule fetalee, te Jisese Gotelu amee feti porite efenei temelalee. ");
INSERT INTO kwo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Te Stivene nelee, “Fiebu. Mene efene munelali fetalaie, Lufwalu Lefoo Gotelu amee feti porite temelalee.” ");
INSERT INTO kwo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nanoo eetegeni nale fineke, metie maretekume oomesiari napooneke, futeni ameetu footepoofwanelu, esulu unetewaneke wobelene. ");
INSERT INTO kwo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Te wokoo soulule geeneri letewanelu babrilume ifwaneke, titu peperee namene tafilarife. Lufwa wolume na nafoomenelu, nalilu leeloo wamolulule lifanuneke, ari rawielulu kuli bwagei luane, nanoolu bilu Sole. ");
INSERT INTO kwo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nanoo Stivenele titu peperee namenei, Stivene Jisesele eesalu nale woponefolee, “Paielu Jisese, oone menanoo yemelarilule neunawo.” ");
INSERT INTO kwo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Te esulu tumoinu krutupoleeke te ragoo mwai nelee, “Paielu, oone kose eetegeni fwagilufe fune teietele mani.” Stivene eese neleeke, tafilalee. ");
INSERT INTO kwo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Eetegeni amee eete Stivenele lefoonelu Solelu menengoi pife lefolee. Ekenitu Stivenele teiefooneke tafilaleelu Gotelu inalilufwa Jerusalemei lalanelule teieterilu ameele eetei pulefoolane. Tefe tupane brune brune anelu Judiame, Samariame letewaneke wamene. Te kame aposeleleme teime Jerusalemei lamene. ");
INSERT INTO kwo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Lufwa telu Gotele amwi ooretafooneke nifemenelu Stivenele ti menei fatilanei ee nenelu ee sameme nafoomene. ");
INSERT INTO kwo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Te Sole Gotelu inalilufwale ite ite letewalali teietemeli, kalabuse iteile bebeneleeke glitewapolee atemelee. ");
INSERT INTO kwo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Brune brune anelu inalilufwa inalilufwale Jiseselu nale alipoofwatemene. ");
INSERT INTO kwo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipe mei tiraleleeke, Samaria distrikei oolalaleelu wokoo soulu bofoofi oolameli Kraiselu na ulu wolilule alipotemelee. ");
INSERT INTO kwo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mwa. Inalilufwa sai sai Filipelu nale fiefoomenei, te brege brege ameele mei fetafoomenei tefe nanoo futeni amwime lefoomene. ");
INSERT INTO kwo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Te Filipe naifofu reeme letewatenelule wawabu natelee afwateli, tetoo lari oomesiari napooneke grigriatene. Te inalilufwa telu kuli amee troonalepotenelule te telu kuli ua ua apotenelule tukwe mei sere letewateleeke te boe ree tlinepoofwane. ");
INSERT INTO kwo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tefe ekeni wokoo soulufu inalilufwa paie paie alanei menengu mutukwe lelane. ");
INSERT INTO kwo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lufwa bofoo ekeni wokoo soulufi lalaleelu bilu Saimone. Bebriefe asulu ameele ameleelu lufwa, te Samariafu inalilufwa fetaneke menengu ti napotemene. Te Saimone nalife natemelee, “Nia paie tefoo lufwa.” ");
INSERT INTO kwo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Te paie paielu inalilufwatu paie prelu inalilufwatu, mareteku nanoole futeni amwime lefoomenei, nafoomene, “Nalife ekeni Gotelu suagrile, Soulu Suagri nafoonane. ” ");
INSERT INTO kwo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nanoo atelaleealeelu ameele fetatefooneke, betige lefoonelufe tefe nanoolu nale amwime fiefoomene. ");
INSERT INTO kwo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Filipe Gotelu ameime lalarilu na ulu wolilule tukwe, Jises Kraiselu bilule tukwe alipoteleefe tefe ta inalitu lufwatu Jisesele menengoi ifelalarife, tefe melei pienuelee. ");
INSERT INTO kwo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tetoo Saimone mei Jisesele menengoi ifelalarife tefe melei pielelee. Tetoo Filipetu weife amenei, brege brege atemeli fetaleeke, tetoo betige lelee. ");
INSERT INTO kwo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposele Jerusalemei lalanelu, Samaria wolu Gotelu nale fineke nifelanelu nale finelufe, tefe nanoo Pitatu weife Jonetu nateneke tupanelufile wane. ");
INSERT INTO kwo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Weife wofetateneke, esulu Gotele na woponefoone Samariafu inalilufwale Wolilu Fifri seenaleterife. ");
INSERT INTO kwo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nanoole Paielu Jiseselu bilutu melei pienueli, Wolilu Fifri ame nanoole glei reeme letelee. ");
INSERT INTO kwo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Te weife Gotele na woponefooneke, amee fatietene, tetoo Wolilu Fifri seenaletelee. ");
INSERT INTO kwo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimone, Pitale weife Jonetu inalilufwale amee fatietelanei Wolilu Fifri seenaletelaleefe fetateleefe, tefe bwaleetu falefe neleeke, fietelee, ");
INSERT INTO kwo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Sei, oone weife bie menane ekeni suagrile fanewobu. Tetoo mene mei lufwa bofoole amee fatiefwiei Wolilu Fifri seenalefobe.” ");
INSERT INTO kwo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Eie, mwa. Pita Saimonele nafolee, “Oone oonapotu oonanoo bwaleele nembuari ifele. Gote nalilu Wolilu Fifri kame Jisesele menengoi ifelalaneluleme seenaleteleealee, tefe ta oonekoe eesalu menengu pai lelu, ‘Mene bwaleetu nemboue falefe?’ Mwa! ");
INSERT INTO kwo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Oonanoo menengu Gotelu oofi glei nemboue lelee. Tefe oone glei eetegeni amee amee, Gotelu genile mene eete lelanelufi, lalale. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Oone bie oonanoo fwagilu ameele koona mufelete. Eese leluke, tetoo Paielule na woponefoolalu oonanoo fwagilu menengoi laioolanelule nemboue pe wogrinatewobe. ");
INSERT INTO kwo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mene eete nielu, mene oonane fetawielu, oonekoe Gotelu amee ameele lerilu menengu, tekee naoolalee ifu neengeelule folulu atukwe, tetoo oonanoo fwagilu nali metie beleoolalee.” ");
INSERT INTO kwo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Te Saimone fune natelee, “Oone weife bie Paielule na woponefobu, tetoo menane keemakee lewobe, te ekeni nembuari lerife oone weife naoomolu menane tetoo glei lewobe.” ");
INSERT INTO kwo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Te Pita Jonetu weife Paielulu nale inalilufwale alipotemene, Paielu nalife amee amee leteleelu yesoufe tukwe alipotemene. Te mwi, tetoo boe Jerusalemeile wane. Te weife walanei Samariai te wokoo te wokoole Jiseselu na ulu wolilule alipoofwatelane. ");
INSERT INTO kwo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bofoo krietu Paielulu ensele bofoo rieleeke Filipele nafolee, “Oone teluwa, afwee bofoo Jerusalememe leleeke tirafereleelu Gasai wosekaleleelule nife. Ekeni afwee lufwa prelu inengume leleeke walee.” ");
INSERT INTO kwo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Te Filipe furaleleeke, ekeni afweeme walali tetoo lufwa bofoole fetalee. Ekeni lufwa Itiopiafu Kandasilu yefee yefeelu lufwa, bwalee itele ifelafoolaleelu lufwa. Kandasi Itiopiafu kwine. Eketie ekeni lufwa Jerusalemeile waleeke Gotele reeyemee lefolee. ");
INSERT INTO kwo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Te eese lefoleeke, tetoo boe nalilufile karisei bolafieleeke walalee. Tetoo ekeni lufwa, bebriefe feti Gotelu ragoofu nale alipoolaleelu lufwa, Aisaia bukei pileleelu nale faleleeke fetafwalali na nafwalalee. ");
INSERT INTO kwo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tetoo Wolilu Fifri Filipele nafolee, “Oone bie karise bwageile wa.” ");
INSERT INTO kwo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tetoo Filipe ekeni kariseme pipinafwaleeke roboime lefolee. Filipe ekeni lufwa Aisaia pileleelu nale nelali fiefoolaleeke, te nafolee, “Sei! Ooneboe ekeni nale nelalulu, na yewilule rame lelu pe?” ");
INSERT INTO kwo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tetoo Kandasilu yefee yefeelu lufwa Filipele fune nafolee, “Tefe ege, menane lufwa bofoo glei eetegeni na yewilule alipowoli, mwa. Tetoo mene eetegeni nale mei glei rame lie.” Te ekeni lufwa Filipele boe nafolee, “Sei. Oone bie peenaleluke, eetei bolafie.” ");
INSERT INTO kwo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aisaialu na kalule fetafwaleelu, na nelee, ");
INSERT INTO kwo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ekepane nanoole reeyemee ameele fanenelu, nanoolu nafi yenalerilu glei merekeilu ameele lefoone. Mwa. Nanookoe ari preme tafilalee.” ");
INSERT INTO kwo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ekeni lufwa Filipele eesalu fiefori lelee, “Gotelu ragoofu nale alipoolaleelu lufwa Aisaia eete neleelu na boe inelefe nelee? Nanoo nalife pe nelee, o bofoo lufwalufe pe nelee?” ");
INSERT INTO kwo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipe ekeni lufwale alipofoleelu ekeni nafi pulefoleeke Jiseselu na ulu wolilufime yelefolee. ");
INSERT INTO kwo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Nanoo weife ame afweeme walanei, melee bofoo lalaleelufi kurulene, te yefee yefeelu lufwa nafolee, “Bie feta! Melee eketie lalalee. Glesou menane melei pieleworife muli leoolalee?” ");
INSERT INTO kwo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Te eese nafoleefe, esulu ekeni lufwa karisele ifalaleelu lufwale nafolee, “Ei, oone bie hosele bele.” Te temepoolanei, Filipe ekeni lufwatu meleememe titirinene. Tetoo Filipe ekeni lufwale Jiseselu bilutu melei pielelee. ");
INSERT INTO kwo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Te meleele grialeneke peepeenelanei, te esulu Paielulu Fifri Filipele ifamorielee. Ekeni lufwa Filipele oo ange teme teme ifaleeke, mwa, glei fetalee. Te ekeni lufwa paie paietume walalee. ");
INSERT INTO kwo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Te Filipe Asotusei lalaleefe rame lelee, te ekeni wokoo porite lafwalanelu inalilufwale na ulu wolilule alipoofwatelee. Tetoo fimelufe Sisaria wokoo soulufi woseka lelee. ");
INSERT INTO kwo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Eetegenitu Sole Paielulu disaipelele wofri natu natelee, mene oonane ame teiemwieke troonalebule. Tefe Sole Gotelu prise paie tefoole waleeke ");
INSERT INTO kwo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","wofiefolee, tetoo Judanelu alina itefu yefee yefeelu lufwa Damaskuse wokoofule na nafwaterife lofoo pi letelee. Te ekeni lofoo pilufi eese lelee, Sole Jisesele Niferilu Ameefe inalilufwa telule ekei fetateli, nemboue bebeneleeke, amee bulupoteleeke, Jerusalemeile ifwateleeke kalabuse itei sinatelee abe, lufwa inali mei. ");
INSERT INTO kwo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Te Jerusalemele grialeleeke Damaskuseile walee. Te ekeni wokoole roboi lefoolali, esulu efenefu takilu feenalefoleeke, ");
INSERT INTO kwo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","te inengoi yeferalelee. Tetoo lufwa bofoo nafoolali fiefolee, “Sole, Sole, ooneboe glefeme menane teiemelu?” ");
INSERT INTO kwo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Te Sole fune nafolee, “Paielu, ooneboe ine?” Te ekeni lufwa nafolee, “Mene Jisese oone menane teiemelu. ");
INSERT INTO kwo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nembue oone furaleluke, wokoo soulufile wa. Sabei lufwa bofoo oone lelarilu amee ameefe ame nawobe.” ");
INSERT INTO kwo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Te lufwa mare wanelu metie betige leneke penalepoolanei, lufwa bofoo na nameli fiefoomene, lufwalu reele glei fetane. ");
INSERT INTO kwo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Te Sole furaleleeke, oo tupwapoleelu, mwa oo metie wifulu kapru nalefoone, tefe amei beleneke te ifwaneke Damaskusei kuruwoifelene. ");
INSERT INTO kwo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Te ekenifi lamemeli lie mwangife lefolee, oo ame footepofooneke, kakali preme kame lamelee. ");
INSERT INTO kwo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jiseselu disaipele bofoo Damaskusei lalaleelu bilu Ananaiase. Te rarauetu atukwe Paielu fieri nafolee, “Ananaiase.” Te fune nafolee, “Paielu, mene eete lalaie.” ");
INSERT INTO kwo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Te Paielu nafolee, “Furaleluke, eetegeni afwee wa, afwee bilu Poopoolu Afwee. Te afoi Judaselu itei oone Tarsusefu lufwa bofoofe fiete, nanoolu bilu Sole nafoone. Nanoo eketie Gotele na woponefoolalee, ");
INSERT INTO kwo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","te rarauetu atukwe fetaleelu lufwa bilu Ananaiase rieleeke, amee fatiefolee tetoo boe oofwaneporife.” ");
INSERT INTO kwo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Te Ananaiase fune nafolee, “Paielu, mene eetegeni lufwalu nale fielu lufwa nafoolanane, ekeni lufwakoe te amee te amee nembulule oonanoo inalilufwale Jerusalemei atelaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ekeni wokoofu Gotelu prise yefeelu wolu i nafooneke, eetei mei eesalu amee leteleealee, Jisesele menengoi ifelalanelu inalilufwale bebeneleeke kalabuse itei sioonaterife.” ");
INSERT INTO kwo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Eetetie mwa, Paielu nafolee, “Oone warime le. Nembue ekeni lufwa menanoo amee amee lufwafe lelee. Mene wolu namunefwie rawie inalilufwale, kinele, Israelele tukwe menanoo nale alipotelarife lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nia ame fetou nafofe menanoo nale alipotelali tetoo teteree nembulule same falelabe.” ");
INSERT INTO kwo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Te Ananaiase waleeke, ite meneile wopreielee. Te Solele ipoi amee fatiefoolali te nafolee, “Ape Sole, Paielu Jisese oonane afoi lebati lewolee, oone rilalu. Te Paielu nembue menane oonanoofile rierife nawoleeke rieluke oone boe amwi oofwaneporife tetoo oonane Wolilu Fifri seenalewobe.” ");
INSERT INTO kwo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaiase eese neleeke, esulume frebi kelu oofi lafoolaleelu geni yeferalefoleeke, te boe amwi oofwanepolee. Te furaleleeke, melei pielelee. ");
INSERT INTO kwo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Te fori yesoule foleeke, kaisekli lelee. Sole disaipele mare ame Damaskusei lamenei. ");
INSERT INTO kwo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tetoo Judanelu alina iteile teme teme ameli eesalu nale alipotemelee, Jisese nanoo Gotelu Lefoo. ");
INSERT INTO kwo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Inalilufwa mareteku Solelu nale fiefooneke, betige lefooneke te nene, “Eketie, eetegeni lufwa nali wolume Jisesele menengoi ifelalanelu inalilufwale teietemeleelu lufwa. Jerusalemei wolu eese atemeleeke, te eeteme rieleelu mei same bebeneleeke, Gotelu prise yefeelu lufwalu amei sinaterife.” ");
INSERT INTO kwo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tefe mwa, Sole Jiseselu nale tebiri nalemeli alipotemelee, Judane Damaskusei lalanelule amwime lalarilu nale alipotelali natelee, “Jisese nalime Kraise, Gote nali inalilufwa eetei paie naporife namunefoleelu lufwa.” Judane Solelu nale fineke, na bofoo naforilu ange menengu lenelu, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Krie soo leneke Judane lukuleneke na falene Solele teiefooneke tafilarife. ");
INSERT INTO kwo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Judane wokoo soulu geeneri amblenile krielu lielu regi letemene teiefooneke tafilarife. Te Sole nalife eese leforife lelanelu nale wolu fielee. ");
INSERT INTO kwo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mwa. Nalilu disaipele nanookoe kriei neuneneke, wokoo soulu geeneri fwai ifenalenelu mwamo peepee ifeneneke, te tefei lafieleeke leeloo meneeme tetoo mwee ipoelufi amee bebeneneke tepopo tepopo ifafereneke inengoi yetemeleeke, te esulu Jerusalemeile walee. ");
INSERT INTO kwo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sole Jerusalemeile rieleeke, tetoo Jiseselu disaipele mare alarife neleelu, mwa, nanoo mareteku ame wofri lefoolane. Nanoolu menengu Solele glei disaipelefe lelee nafoone. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tefe Barnabase Solele neuneleeke aposelelufile ifwalee. Te ifwaleeke, wofetatenelu esulu Barnabase Solelu nale alipotelee, Sole Paielule afoi fetaleeke te Paielu na ifeneleelule alipotelee. Te Sole Damaskusei Jiseselu bilutu na alipotemeli glei wofri letelee. ");
INSERT INTO kwo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tefe Sole aposele mare Jerusalemei lamenei, wari ifamenei, tetoo Paielulu bilutu nale alipoterife, glei wofri letelee. ");
INSERT INTO kwo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Te Sole Grikelu natu lalanelu Judanele fame na ifenatelalee. Mwa. Nanookoe Solele tafilarife ange ange ifalane. ");
INSERT INTO kwo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Te Jiseselufe lenelu pane ekeni nale finelufe, tefe Solele neuneneke Sisariaile titiri ifeneneke, te Tarsuseile walee. ");
INSERT INTO kwo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tefe Gotelu inalilufwa Judiafu, Galilifu, Samariafu wolilu lafieri letewane, ekenitu lufwale glei teietemenei. Mwa. Nanoo Paielule reeyemee leforilu ameele nifemenei, te Wolilu Fifri nali kaisekli ifeletelaleefe, tefe inalilufwa motukweme Jiseselufi paie naporife ririane. ");
INSERT INTO kwo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Te Pita wokoo wokoo letewalali, te Lida wokeile luwaleeke Gotelu inalilufwa mare wamene. ");
INSERT INTO kwo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Eetegeni wokei lufwa bofoole fetalee, ekeni lufwalu bilu Ainiase. Nanoolu kuli areme troonalefooneke, reeafoimeme luemeli yare tialoo are lefolee. ");
INSERT INTO kwo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Te Pita nafolee, “Ainiase, nembue Jises Kraise oonane boe sere lewoleeke lalarife lelalu. Sei, te furaleluke, oonanoo isepule sere le.” Esulu furalelee. ");
INSERT INTO kwo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Te inalilufwa mareteku Lida wokoofutu inengu monguelu wokoo pri Saronefutu Ainiasele fetanelu boe woli leleefe, tefe mareteku Paielule menengoi ifelalarife lene. ");
INSERT INTO kwo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Te Jopa wokei disaipele inali bofoo lalalee, nanoolu bilu Tabita. Grikelu natu, Dorkase nafoone. Nanoo wolilu ameele alaleealeelu, inalilufwa yesoufe te krie te krie lulu napoolanei aikopi letelaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Eetegenitu Tabita reefe aleeke, tafilaleefe, te ree tupulule meleetu suwanaleneke, mwafu gueile peepee ifeneneke bofatine. ");
INSERT INTO kwo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida wokoo Jopa bwagei lalalee. Disaipele Pita Lidai lalaleelu nale finelufe, tefe nanoo lufwa are nateneke te waneke, nafoone, “Pita, bie menanoofile afeteli rie. Oone kose laripolele mani.” ");
INSERT INTO kwo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eese nafoonelufe, Pita esulu furaleleeke nifetewateleeke, woseka leleelu esulu ekeni mwafu gueile peepee ifenene. Seikolu inali mareteku ririaneke Pitalu bwagei temepoolanei ee napoolane. Tetoo fetou natefoone Tabita leteleeke tapoolanelu bebeti leeloole tukwe, oofulilufi mare amenei aikopi atemeli letemeleelule. ");
INSERT INTO kwo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Te Pita inalilufwale wawabu nateleeke, tumoinu krutupoleeke Gotele na woponefoleeke, te ree tupulule ooretafoolali te nafolee, “Tabita, te furale.” Te oo tupwapoleeke, Pitale fetaleeke furaleleeke lafieleefe, ");
INSERT INTO kwo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","tetoo Pita amei beleleeke boletaleeke, temelee. Te Pita Gotelu inalilufwale tukwe, seiko seikolu inalile tukwe fieri nateleeke, fetou natelali natelee, “Tabita tafilaleelu wolu eete oofuli leleeke lalalee.” ");
INSERT INTO kwo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ekeni brege amee leleelu na ulu wolu wokoo soulu Jopa porite fieri ningilume letewane, inalilufwa fifwanelufe motukwe Paielule menengoi ifelalarife lene. ");
INSERT INTO kwo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Te Pita Jopafu Saimonetu amenei krie soo lelee. Eetegeni lufwa te bole te bole leeloole peenelali lukuletelaleealee, tetoo yesou eetegenitu letelarife. ");
INSERT INTO kwo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Lufwa bofoo Sisaria wokoo soulufi lalaleelu Korniliuse nafoone. Nanoo Romefu kworoofamelu keptene. Nanoo Italifi Lalananelu Kworoofame Lufwalufu. ");
INSERT INTO kwo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Korniliuse Gote alaleealeelu amee wolilule amwi nifetelaleealeelu lufwa. Nalilu itei lalananelu nanoo mei same Gotelu ameele nifetalanane. Korniliuse raue tefoo lufwa, Judane yesoufe lulu napoolanelule aikopi letelaleealee. Te Gotele mei sameme na woponefoolaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bofoo lietu, feiferi lie oolu mwangifelufi lelali tetoo nanoo rarauetu atukwe amwime fetaleeke Gotelu ensele iteile wopreiefoleeke, te nafolee, “Korniliuse.” ");
INSERT INTO kwo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Te ooriri nafoolali metie wofri lelali, te nafolee, “Paielu, glesou?” Te Gotelu ensele Korniliusele nafolee, “Oone na woponefoomelulu nale Gote wolu fiewolee, oone inalilufwale yesoufe lulu napoolanei aikopi letemelulu ameele wolu rame lewolee. Gote ekenife paie paie awolee. ");
INSERT INTO kwo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Te nembue oone lufwa telule nateluke Jopaile wabi lufwa bofoole ooraforife, ekeni lufwalu bilu Saimone, te bofoo bilu Pita, oonafooneke riebee. ");
INSERT INTO kwo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ekeni lufwa bofoo Saimonelu itei lalalee. Saimone nanoo bole leeloo amee ameele lelaleealeelu lufwa. Nanoolu ite mwi melee bwagei temefoolalee.” ");
INSERT INTO kwo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Te Gotelu ensele Korniliusele na ifenameleeke, te grialeleeke walee. Te esulu Korniliuse nalife amee amee afoolananelu lufwa are, te kworoofame lufwa mwamole, eesame natelee. Ekeni kworoofame lufwa mei Gotelu amee wolilule amwime nifetelaleelu, nanoo teime Korniliusetu lalanelu. ");
INSERT INTO kwo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Korniliuse ekepane lufwale rarauetu atukwe fetateleelu yesou nale mareteku amwime alipotelaleeke, te nateleeke Jopaile wane. ");
INSERT INTO kwo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Te walanei, afoi rofoo mwamole leneke, te bofoo lietu boe same walaneime, lie oolu wolu babi babi lelali, wokoo soulu Jopale roboi lefoolanei tetoo Pita reeafwee atukwe fuelenelu ite mwaile peenalelee Gotele na woponeforife. ");
INSERT INTO kwo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita gife lefoolaleefe te fori yesoule tuerife lelanei, tetoo Pita ootu keme yesou bofoole fetalee. ");
INSERT INTO kwo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Te lie fo nalelali fetalee, te yesou bofoo leeloo soulu atukwe leleeke tiraferelee, guelu guelufi bebeneneke, te inengoile tepo tepo ifaferelee. ");
INSERT INTO kwo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ekeni leeloofi te bole te bole amefleele ambofule, arietu warialanelule, bosutu warialanelule, kaulefule mareteku lailane. ");
INSERT INTO kwo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Te Pita bofoo ragoofu nale eese nafoleelule fiefolee, “Pita, oone furaleluke bole prafo.” ");
INSERT INTO kwo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Te Pita fune nafolee, “Paielu, mene glei eese lefe, mene bofootu yesou bofoo oonanoo oofi fwagilutu lenelule glei foopoliei, mwa. Eetete menanoo amboporilu yesou.” ");
INSERT INTO kwo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ekeni lufwa boe arelelufe nafolee, “Gote leteleelu yesou wolu woli lenelule, eetegenile oone kose fwagilutu lene natele mani, mwa.” ");
INSERT INTO kwo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Te Pitale mwangifelufe nafoleeke, te esulu eetegeni leeloo boe tetoo lie mwame peenanelee. ");
INSERT INTO kwo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita eke rarauetu atukwe fetaleelu yewilule akeke lelee neleeke, ame menengu menengu lefoolali, tetoo ekepane lufwa Korniliuse nateleeke wanelu kurulelane. Te lufwa telule Saimonelu itefe fietene, te fetou natenelufe waneke amblenei temepooneke, ");
INSERT INTO kwo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","te fietene, “Saimone, bofoo bilu Pita nafoonelu lufwa eetei pe lalalee?” ");
INSERT INTO kwo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita ekeni rarauetu atukwe fetaleelule ame menengu menengu lefoolali, te Wolilu Fifri menengoi nafolee, “Pita, oone bie fie, lufwa mwangife eke rineke, oonane ooraoolane. ");
INSERT INTO kwo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tefe oone furaleluke te tirale, tetoo nifetewate, kose menengu are are preme ekepane lufwa mare warife. Nanookoe nia natielufe tefe rine.” ");
INSERT INTO kwo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Te Pita tupanelufile tirafereleeke, te natelee, “Ekeni lufwa oone eke oorafoolamolu eetetie nia, ooneboe glefe rimo?” ");
INSERT INTO kwo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tupane nafoone, “Korniliuse Romefu kworoofamelu keptene, nali menafe napoleeke rine. Nanookoe lufwa wolilu Gotele reeyemee lefoolaleealeelu lufwa. Judane mareteku nafoonane, nanoo lie platei teme laleelu lufwa. Gotelu ensele nafolee, ‘Oonane neunaooneke ifwaworife nalilu iteile, tetoo oone na natelalu fieoolarife.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Te Pita neunateleeke, iteile ifepreipoteleeke te ifeluetelee. Te bofoo lietu esulu Pita furaleleeke mare walanei, te telu disaipele Jopafu mei mare nifetewane. ");
INSERT INTO kwo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Te Pita tupane disaipele mare waneke te afoi rofoo mwamole leneke, te bofoo lietu Sisariafi kuruwolene. Te Korniliuse ooletemeleeke, te nalilu retifule tukwe nalilu moanele nafwateleeke, te mareteku lukuleneke lamene. ");
INSERT INTO kwo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Te Pita ite meneile wopreilali tetoo Korniliuse roboileme waleeke, Pitalu kuli bwageime tumoinu krutupoleeke, te reeyemee lefoolalee. ");
INSERT INTO kwo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mwa. Pita Korniliusele nafolee, “Oone furaleluke te teme. Mene mei oone kelu lufwa lalaie.” ");
INSERT INTO kwo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Te Pita Korniliusele na ifenafwali preielee, te inalilufwa motukwe lukuleneke lalanei fetatelee. ");
INSERT INTO kwo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Te Pita natelee, “Oona wolu rame lemo mene Judane rawie inalilufwa mare sagoo leneke alarife, bi neneke alane. Mwa. Gote menane wolu fetou nawolee, mene glei lufwa bofoole nafofe ‘Oone fwagilu ameetu leluke alalu Gotelu oofi,’ mwa. Tetoo mene mei menengu glei eese lewoli, rawie inalilufwa mare sagoo lerife bi nie. ");
INSERT INTO kwo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tefe mene oone na namolu nale fieke, rie, mene oonanoo nale glei futeni kookoo lemwiei, mwa. Tefe mene nembue oonane fiemoolaie oone menane glefe fieri namo?” ");
INSERT INTO kwo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Te Korniliuse fune nafolee, “Lie wolu mwangife lelaie, mene ite menei lamiei, Gotele na woponefoomiei, lie oolu mwangifelufi lelali nembue eesalu feiferi lie lelaleelu atukwe, esulu lufwa bofoo leeloo taki feti naleleelutu menane ootari porite yetemewoleefe fetaie. ");
INSERT INTO kwo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Te nanoo nawolee, ‘Korniliuse, oone Gotele na woponefoomelulu wolu fiewolee, eke oone inalilufwale yesoufe lulu napoolanelule aikopi letemelulu ameele wolu menengu letewolee. ");
INSERT INTO kwo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tefe oone lufwa telule nateluke Jopaile wabi, lufwa bofoole ooraforife, ekeni lufwalu bilu Saimone, te bofoo bilu Pita, oonafooneke riebee. Ekeni lufwa bofoo Saimonelu itei lalalee. Saimone nanoo bole leeloo amee ameele lelaleealeelu lufwa. Nanoolu ite mwi melee bwagei temefoolalee.’ ");
INSERT INTO kwo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tefe mene afetelime lufwa telule natieke oonanoofile rine. Eetete nembouelu ameefe rielu. Tefe nembue mene mareteku Gotelu oofi lalanei, menane Paielu nali oonane mareteku fanewoleelu nale alipoolalu fiefoolarife.” ");
INSERT INTO kwo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Te Pita nelee, “Marena, nembue mene wolu rame lie, Gote glei mwamole paneleme menengu tari lualeealee, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nanoo inalilufwa mareteku te wokoo te wokoofule inepane reeyemee lefooneke, glelu amee wolilule lelananelule ooretatelaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Oone tele rame lemo eetegeni na Gote mena Israelele napoleelu. Nanoo nalilu na ulu wolilule eese alipolee, ‘Jises Kraise mareteku inalilufwalu Paielu, nali menafe amwime lepoolaleealee Gotetu menengu mutukwe leneke alarife.’ ");
INSERT INTO kwo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Oona wolu rame letemo ekeni yesou mareteku Judia provinsei kuruletewanelule Galilifi pu lefolee, Jone melei pienueri nale alipoteleelu mwi. ");
INSERT INTO kwo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gote Nasaretefu Jisesele namunefoleeke, te Wolilu Fifrile tukwe soulu suagrile tukwe fanelee. Gote Jisesele ifelalaleefe tefe Jisese wokoo wokoo letewalali inalilufwale aikopi letewatelalee, te boe mareteku ree tlinepoofwane Sebore Lufwa teietemeleelule. ");
INSERT INTO kwo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mena aposele nanoo yesou mareteku Israelelu inengoi, Jerusalemei pu leteleeke atemeli menanoo ootu fetaneke, rame letenelu nale alipoolanane. Ekeni lufwale kafi niletu koko neneke, kweinelali tafilalee. ");
INSERT INTO kwo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mwa. Lie mwangifelutu tetoo Gote ti menefule kelafoleeke furalelee. Furaleleeke inalilufwale lebati lebati afwatelee. ");
INSERT INTO kwo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nanoo glei Judafu inalilufwale mareteku lebati leteli, mwa. Nanoo kame mena menanoo ootu fetanelu nale alipoolarife wolumeme Gote namunepoleelu inalilufwaleme lebati lebati afwalee. Te ti menefu wolu furaleleeke, mene mare kakali ifeletewane. ");
INSERT INTO kwo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Te Jisese menafe nalilu nale inalilufwale amwime alipotelanei natelarife nelee, Gote eetegeni lufwale namunefolee tefe wolu troonalenelule tukwe, oofulilu lalanelule tukwe nalilu nafi yenaleforife lelane. ");
INSERT INTO kwo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Gotelu ragoofu nale alipomenelu lufwa mareteku yesou nali ame leterife lelaleelu nale alipotemenelu nene, eetegeni lufwalu bilutu Gote fwagilu ameele wogrinatelaleealee inalilufwa mareteku nalife menengoi ifelalanelule.” ");
INSERT INTO kwo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita Gotelu nale alipotemelime, tetoo inalilufwa mareteku fiefoolanelule Wolilu Fifri seenaletelee. ");
INSERT INTO kwo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Wolilu Fifri rawie panele seenaleteleefe, tefe Judafu lufwa Jisesele menengoi ifelalanelu Pita mare rinelu metie betige letene. Te ekeni rawie pane fime bofoo natu napoofwalanei Gotele reeyemee ifalanei fietene. Te Pita natelee, ");
INSERT INTO kwo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Gote Wolilu Fifrile ekepanele wolu fanetelee eete menafe lepoleelu atukwe. Tefe menafe ine ble napobe tupanele melei pienuerife?” ");
INSERT INTO kwo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Te Pita inalilufwale natelee, “Sei, oone bie menane ooloome leoolabu, Jises Kraiselu samefe melei pienuemofe.” Nanoo tupanele melei wolu pienueleeke, tetoo Pitale boe lapolelarife nafoone. ");
INSERT INTO kwo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Te aposele apane mare Judiai fime fime aneke laprufwanelutu, rawie inalilufwa mei Gotelu nale wolu fineke nifelanelu nale fifwane. ");
INSERT INTO kwo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita Jerusalemeile wali, lufwalu ree leeloole kreenapoolananelu ameele nifetalananelu pane Pitale fame na ifenene. ");
INSERT INTO kwo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nanoo eese nafoone, “Ooneboe glelu ameele lelufe tefe lufwalu ree leeloole kreenapori prelu panelu iteile waluke mare kakali wolemo.” ");
INSERT INTO kwo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Te Pita glelu glelu yesou mareteku fetateleelu nale natelalee, ");
INSERT INTO kwo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mene wokoo Jopai lalaiei, bofootu Gotele na woponefoolaiei, tetoo rarauetu atukwe fetaie. Yesou lie mwafu leeloo soulu keme leleeke, te guelu guelufi bebeneneke, menanoomeme tepo tepo ifaferelee. ");
INSERT INTO kwo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mene ekeni leeloole oosunetewafwielu, tetoo te bole te bole amefleele ambofule, arietu warialanelule, bosutu warialanelule fetatie, te kaulefule mei fetatie. ");
INSERT INTO kwo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Te mene ragoo bofoole fielu, menane naoolalee, ‘Pita, oone furaleluke, bole bofoole prafoluke foe.’ ");
INSERT INTO kwo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Te mene nafwie, ‘Paielu, mene glei eese lefe, mwa. Mene bofootu oonanoo oofi eesalu bolele glei fwie.’ ");
INSERT INTO kwo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mwa. Te efenefu ragoo arelufe boe nawolee, ‘Gote leteleelu yesou wolu woli lenelule oone kose eetegenile fwagilutu lene natele mani, mwa.’ ");
INSERT INTO kwo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Te eetegeni na menane mwangifelufe naoolaleeke, tetoo ekeni leeloo boe lie mwame peenalelee. ");
INSERT INTO kwo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ekeni lietumeme lufwa mwangife mene lalanelu iteile rineke, lufwa bofoo Sisariafu menanoofile rierife natelee. ");
INSERT INTO kwo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Wolilu Fifri eese nawolee, ‘Oone mare wabu, kose menengu are lele mani.’ Te eetegeni apane tialootu nanoo mei mare waneke, ekeni lufwalu itei wopreiepoone. ");
INSERT INTO kwo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Te Korniliuse menane Gotelu ensele nanoolu itei wopreiefoleeke temefoolali fetaleelu nale nawolee, te ensele nafolee, ‘Oone lufwa telule nateluke, Jopaile waneke, Saimonele oorafobi, bofoo bilu Pita nafoone, nanoole nafomoke riebee. ");
INSERT INTO kwo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nanoo oonane ame na bofoole ifenamobe, tetoo ekenifi Gote ame oonapotu oonanoo itei lalanelu panetume mareteku paie napobile.’ ");
INSERT INTO kwo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mene ame nale nembuame nelaiei, te esulu Wolilu Fifri tupanele seenaletelee wolume menafe molukwe leleelu atukwe. ");
INSERT INTO kwo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tetoo mene boe eetegeni nale menengu lefwie wolume Paielu eese neleelule, ‘Jone inalilufwale kame melei pienuemelee, oonete mwa, Wolilu Fifri ame seenalemobe.’ ");
INSERT INTO kwo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bebriefe mena Paielu Jises Kraisele menengoi ifelalanelule Gote rauefe Wolilu Fifrile tinelee. Te nembue mei eetetie Gote rauefe tupanele fanetelee, tefe meneboe ine tetoo Gote nali amee amee leleelu ameele ake lieke muli letefofe?” ");
INSERT INTO kwo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Te ekepane Pitalu nale fiefooneke boe fame na nerilu menengu mwa. Nanoo Gotele reeyemee ifaneke te nene, “Marena, nembue mene wolu rame lelane Gote rawie inalilufwa Jisesele menengoi ifelalanelu mei ame paie napobile.” ");
INSERT INTO kwo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stivenele teiefooneke tafilaleelu krietu, telu inepane Jisesele menengoi ifelalanelule mei teie teie ifatene. Tefe nanoo brunaleneke teme teme letewanelu, telu Fonisia distrikeme, Saipruse wokoo tupulume, te Antioke wokoo soulume eese letewanelu Gotelu na ulu wolilule kame Judaneleme alipoofwatelane. ");
INSERT INTO kwo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tetoo nanoolufu pane telu Saiprusefu Sairini wokoo soulufu, nanoo Antiokeile waneke, te Paielu Jiseselu na ulu wolilule Grikele mei alipotemene. ");
INSERT INTO kwo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Paielulu kaiseklilu ifelatelaleefe, tefe inalilufwa motukwememe Paielule menengoi ifelalanei paie napobile nene. ");
INSERT INTO kwo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Te Gotelu inalilufwa Jerusalemefu eetegeni na ulule finelufe tefe Barnabasele Antiokeile warife nafoone. ");
INSERT INTO kwo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Te waleeke, woseka leleelu Gote amwime aikopi leteleefe fetatelee, tefe menengu mutukwe letelee. Nanoo mareteku inalilufwale Paielule marekulitume nifelarife menengu boe fanetelee. ");
INSERT INTO kwo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabase wolilu amee tefoo, Jisesele menengoi ifelalaleelu lufwa te Wolilu Fifri seenalefoolali, tefe inalilufwa motukwememe Paielulu weelufe letelee. ");
INSERT INTO kwo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tetoo Barnabase Solele ooraforife Tarsuseile walee. ");
INSERT INTO kwo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Solele fetaleefe, te neuneleeke Antiokeile iferielee. Te weife teime Antiokei Gotelu inalilufwale ifelatemenei yare mwamole lene, tetoo Gotelu nale inalilufwale motukwe fetou natemene. Te Antiokei molukwe rawie inalilufwa disaipelele bilu Kristene natene. ");
INSERT INTO kwo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Eetegeni krietu Gotelu ragoofu nale alipoolanelu lufwa telu Jerusalemefu Antiokeile titiri naferene. ");
INSERT INTO kwo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nanoolufu bofoo, Agabuse nafoone, Wolilu Fifri seenalefoolali tetoo temelali nelee, eetegeni lemeleelu inengoi pupu lie soulu ame leterife lelaleelu nale alipotelee. (Ekenifi Sisar Klodiuse paielu lufwafe leleeke lalaleelu lietu lerife lelalee.) ");
INSERT INTO kwo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tupane disaipele Agabuse neleelu nale fineke, te nanoo na sere lene Judiafu apanele aikopi leterife. Te disaipele mwamole mwamole bwaleele faneteri pikeme luane. ");
INSERT INTO kwo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Te ekepane Barnabasetu weife Solele tukwe nateneke, eetegeni luluanelu bwaleele tewaneke yefeelu lufwale wofanetene. ");
INSERT INTO kwo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ekeni krietu, Kin Herot Agripa kworoofame lufwale Jerusalemeile warife nateleeke, te waneke, Jerusalemefu Gotelu inalilufwa telule teieterife bebeneneke, kalabuse itei sinatene. ");
INSERT INTO kwo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Te Kin Herote neleeke, tetoo kworoofame lufwa bofoo Jonelu yafee Jemsele kwasuetu poofoleeke tafilalee. ");
INSERT INTO kwo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kin Herote Judafu inalilufwale nali leleelu ameele metie nafiefoolanelufe fetateleefe, tefe Pitale mei beleneke te kalabuse itei siwonene. Eetegeni ameele Tabe Leeloo Foopori Lietu lelee. ");
INSERT INTO kwo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Te Pitale beleneke, kalabuse itei siwonerife. Tetoo Herote Pitale kworoofame lufwa gulune gulune afwanelu yerifurutu lelee, ekeni 16 kworoofame lufwa regi letewafoonei ifwane. Te Herote menengu eese lelee, ekeni Gote Israelele Ooloome Leteleelu Lie bie waleeke tetoo Pitale kalabuse ite menefu neuwoneneke inalilufwalu oofi nale fipwalefoolarife ifwane. ");
INSERT INTO kwo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tefe Pita ame kalabuse itei lameli kworoofame lufwa regi regi ifamene. Mwa. Utetu utetu Gotelu inalilufwa Pitale aikopi leforife Gotele na woponefoolane. ");
INSERT INTO kwo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Te Kin Herote Pitale nale fipwafoolarilu lie kwotue lerife lelali, te nembue krie eesalufe Pita lulali, kworoofame lufwa are moporite moporite regi lefoolanei, tetoo seinetu amee are gugurelufi fupwafoone. Te telu itele regi lefoolananelu lufwa amblenile regi lefoomene ");
INSERT INTO kwo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mwa. Gotelu ensele Pitalu bwagei punepolefoleeke, te takilu metie kalabuse ite guei ianalelalee. Te Gotelu ensele Pitale kelaforife babrilufi beleleeke te kelafoolali eese nafoolalee, “Afeteli furale! Afeteli furale!” Eese nafoolalime, tetoo seine amee gugurelufu tupwapofoone. ");
INSERT INTO kwo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Te Gotelu ensele nafolee, “Oonanoo leeloole kuli leeloole mei sinapola!” Te Pita eese leteleeke, te boe Gotelu ensele nafolee, “Bebeti leeloo wamolulule sineluke tetoo menane nifewo.” ");
INSERT INTO kwo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Te ekeni guele grialeleeke te Gotelu enselele nifetewalee. Mwa. Pita, Gotelu enseletu weife kalabuse itele grialeneke walanelufe, glei rame leli, tefe Pita rarauetu atukwe pai lelaie nelee. ");
INSERT INTO kwo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Te weife waneke te kworoofame lufwa afwee guele regi lelaleelule boorelefooneke te boe temwifule boorelefooneke, te fee ambleni ainetu lenelufi kuruwolene. Kuru woleneke, ekeni ambleni nalime oorapoleeke lalali, tetoo weife mwamole afweeme walanei te esulu Gotelu ensele amoifepolelee. ");
INSERT INTO kwo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Te boe Pita menengu amwi faleleeke tetoo nelee, “Nembue mene wolu rame lie, Gote nalilu enselele nafoleeke rielee, tetoo nali menane Herotelu amefule tukwe, te Judane glelu glelu yesou mareteku wolu menengu leteneke menane leteworife lelanelu amefule tukwe neunawolee.” ");
INSERT INTO kwo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita eetegenife rame leleeke Jonelu yefee Marialu iteile walee. Te Jonelu bilu bofoo Make. Inalilufwa motukwe ekeni itei lukuleneke lalanei te Gotele na woponefoolane. ");
INSERT INTO kwo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Te Pita amblenei go go natelee. Te amee amee alaleelu auteli ramulu bofoo, bilu Roda nafoonelu fieleeke, te amblenile ooraporife walee. ");
INSERT INTO kwo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mwa. Roda Pitalu ragoole fiefoleefe, te metie paie paie aleeke, amblenile glei oorapolee, kame grialeleeke pipinafwaleeke te inalilufwale natelee, “Pita wolu rieleeke, eke amblenei yetemelalee.” ");
INSERT INTO kwo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ekepane inalilufwa nafoone, “Oonekoe mumu alalu pai, eke glei Pita.” Mwa. Ekeni auteli metie sameme natelalee, “Mene glei kosefe nelaie. Marenafe nemoolaie.” Te nene, “Ensele Pitale regi lefoolaleealeelu pai a!” ");
INSERT INTO kwo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mwa. Pita ame sameme amblenei teime go go natelalee. Te fimelufe lufwa amblenile oorapooneke te Pitale fetanelufe tefe metie betige lepoone. ");
INSERT INTO kwo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Te Pita tupanele amee natu pepelerife natelee. Te pepeleneke lalanei, glelu amee Gote lefoleeke kalabuse itele grialeleelu nale amwime alipotelee. Te Pita mei eese nelee, “Jemsele, te apanele eetegenife natebu.” Te Pita Marialu itele grialeleeke, te bofoofile walee. ");
INSERT INTO kwo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Te kwotuekrieime, kworoofame lufwa Pitale fetari preme lenelufe, tefe betige lepooneke, te nali kwaife eese fifieri napoofwane, ake leleeke tialelee e? ");
INSERT INTO kwo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Te Herote Pita tialeleelu nale wolu rame leleefe tefe kworoofame lufwale nateleeke Pitale oorafwafoolane. Oorafoomeneke mwa, nanoo glei fetanei. Te itele regi lefoolananelu lufwale fietelee, “Te oone akeke lememoi tetoo Pita tialelee.” Fune glei na gliefoonei. Tefe Herote natelee Pitale regi lefoomenelu kworoofame lufwale ifwateneke nembueme teieteneke troonalerife nelee. Te Herote Judiafu Sisariaile tirafereleeke tetoo teime lamemelee. ");
INSERT INTO kwo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Te ekeni krietu Herote Tairefu, Saidonefu inalilufwale metie fame kaisekli letemelee. Tefe ekepane wokoo soulufu inalilufwale namunetenelu lufwa mareteku sagoo leneke te Sisariaile rineke Herotele yefetane. Herote fori yesou eetei peenenanelu wokoole ifelatelaleelu lufwa. Te Herotele yefetarife rine, bie Blastuse Herotelu guele ifelafoolaleealeelu lufwale wofetabile na ifeneneke te nali we naterife, tetoo waneke Herotele wofetane. Te Herotele keemakee leterife fiefoone tetoo nali fame leteleelu nale sere lerife te boe fori yesou peene peene amee alarife. ");
INSERT INTO kwo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Te Herote, lie bofoole namunefoleelutu, kinelu rani leeloole sinapoleeke, te kine nali lalaleealeelu reeafoi lafieleeke tetoo ekepanele na ifenatemelee. ");
INSERT INTO kwo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Te inalilufwa kinele una lefooneke te nene, “Ekeni ragookoe bofoo gotelu ragoofu, glei lufwalu ragoofu. Mwa.” ");
INSERT INTO kwo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tesulu Gotelu ensele rieleeke Herotele teiefolee. Nali glei eese neli, Gote glei mene keme leli, tefe lisi reele fofwafoolaneke te tafilalee. ");
INSERT INTO kwo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tetoo Gotelu nale metie sameme wokoo wokoome inalilufwale alipoofwatelanei tetoo inalilufwa Jisesele menengoi ifelalanelu ameelu peenalerimeme lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Te Barnabase Soletu weife bwalee nifwaterilu amee ameele pookanaleneke, te boe Antiokeile wane. Te Jonele mei weife ifwane, bofoo bilu Make. ");
INSERT INTO kwo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Te Gotelu inalilufwa Siria provinsefu Antiokefu telu Gotelu ragoofu nale alipoolanelu lufwa, te ramelu lufwa telu Jiseselu nale inalilufwale fetou natelananelu nanoo mei lalane. Barnabase, Simeone bilu bofoo Nigere, te Lusiuse Sairinifu lufwa, Manaine Herot Antipasele kafee lefoolaleelu lufwa, te Sole mare lalane. ");
INSERT INTO kwo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Te ekepane lufwa fori yesoule ambopooneke Gotele reeyemee lefoolanei, tetoo Wolilu Fifri natelee, “Oone nembuememe Barnabase weife Soletu namunetemoke menanoo amei teponuewobu, tetoo nia natielu amee ameele lelarife.” ");
INSERT INTO kwo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tefe tupane fori yesoule ambopooneke, Gotele na woponefooneke, tetoo nanoole weife amee mwai fatieteneke, te nateneke wane. ");
INSERT INTO kwo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Te Wolilu Fifri Barnabasele weife Solele tukwe nateleeke wane. Te weife Selusiaile waneke, te brai soulufi peepeeneneke, te Saipruse wokoo tupulufile ifwatelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Te Salamisei kuruwoleneke, Gotelu na Judanelu alina iteme inalilufwale alipoofwatemene. Te Jon Make mei nifetewateleeke, tetoo aikopi letemelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Te nanoo Saipruse wokoo tupulume wolemenekeme, te Pafose wokoo soulufi kurulene. Te asulu lufwa bofoo Judafu Pafosei lalali fetane, Barjisese nafoone. Nalimeme kose kose ragoofu nale alipoolaleelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ekeni lufwa Saiprusefu gavana Sergius Pauluse mare lalananelu lufwa. Sergius Pauluse wolilu rame ramelu lafoolaleelu lufwa. Nali Gotelu nale fierife Barnabasele Solele tukwe rierife natelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Te asulu tefoo lufwa Elimase (nalilu bilu yewilu Grike natu eetetie eese nafoone, te amee te amee asulufe yefee leleelu lufwa) nanoo Barnabasele weife Solele tukwe nanoolu amee ameele bibinatelalee. Nanoo kose gavana Jisesele menengoi ifelalabe nelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Te Sole, bilu bofoo Pole, Wolilu Fifri seenalefolee, Elimasele oo teime teime lefoolali, te nafolee, ");
INSERT INTO kwo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Oonekoe Sebore lufwalu ari, te wolilu ameele mareteku oorerei letelalu alulu lufwa. Oone sameme inalilufwale tukwe nembu nembulu yesoufe kose kosefe natelalu, tetoo wolilu afweele tukwe teietelalualu. Oone Gotelu wolilu ameele kose amburenueluke, boe fwagilu ameefe lebile mani. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bie fie, nembue Paielu oonane teieworife lelalee, tetoo oonanoo oo footepooneke, oone glei afeteli liele fetale.” Pole eese neleefe, tesulu maseboo atukwe kapruneteriefoleeke Elimaselu oole footepoforime lelee, tefe mumu alali tetoo lufwa bofoo aikopi leforife oorafwatelalee amei beleneke afweeme ifwarife. ");
INSERT INTO kwo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Te gavana ekeni ameele fetaleefe, nanoo Jisesele menengoi ifelalarilu lufwafe lelee. Te Pole Barnabasetu Paielulu nale alipoolanelule fieteleefe nanoolu menengu ti nafolee. ");
INSERT INTO kwo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Te Pole wari ifatelaleelu lufwa mare, Pafosefu brai soulu neunateleeke, te Perga wokoo soulu Pamfilia distrikei lalaleelufile ifwatelee. Te ekeise Jon Make grialeteleeke, te Jerusalemeile walee. ");
INSERT INTO kwo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Te Pergafu Pole weife Barnabasetu kulitu lemeneke te Pisidia distrikefu Antiokei kuruwolene. Te Yenalerilu Lietu Judanelu alina iteile wopreipooneke, oolapruelene. ");
INSERT INTO kwo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Te Moseselu Na Kaisekli te Gotelu Ragoofu Nale Alipoolanelu bukefu nale fetafwalali nafwateleeke, te Judanelu alina itefu paie paielu lufwa, lufwa bofoole nafooneke Polele tukwe Barnabasele tukwe oonaterife nafoone, “Apane, oone na bofoo kuli reeneletelamoi nembue alipobu.” ");
INSERT INTO kwo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Te Pole furaleleeke, amee natu nateleeke, pepelelanei natelee, “Oone Israelefu pane, oone Gotele reeyemee lefoolamwamolu rawie inalilufwatu, bie oone menanoo nale fieoolabu. ");
INSERT INTO kwo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Menanoo Israelelu Gote menanoo fetalile molukwe namunetelee nalilu inalilufwafe lerife. Te Isipei amenei, Gote aikopi leteleefe inalilufwa ari lemenei ka fulu atukwe lelane. Tetoo Gote nalilu soulu kaiseklilutu Israele inalilufwale Isipefu neunateleeke, te wane. ");
INSERT INTO kwo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Te pepelu inengoi oolamenei tetoo yare ameelu 40 letelee, ekenitu glelu glelu ameele amenei te Gote glei tupu na natemelee, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Te Gote Israelefu lufwale kaiseklilule faneteleeke, te Kenane inengoi inalilufwa lalanelu weelu tialoo mwamole lenelule kila letene, tetoo Israelele inengu fanetelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ekenitu mareteku kurulenelu yare ameelu 450 letelee. Tetoo Gote lufwale namunetelee ipoelu lufwafe leneke, Israelele ifelatelarife. Ekeni ipoelu lufwalu amei lafwalaneime Gotelu ragoofu nale alipoolaleelu lufwa Samuelelu krietume yelene. ");
INSERT INTO kwo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Eetegeni lietu Israelefu inalilufwa lufwa bofoole kinefe fiefoone ifelatelarife. Te Gote Solele namunefolee kinefe leteleeke, ifelatelarife. Sole Kiselu lefoo, Benjaminelu weelufu, te yare ameelu lameleelu 40 lefolee. ");
INSERT INTO kwo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Gote glei Kin Solele kinefe lafwalarife i nafolee, mwa. Nanookoe Devitele wolu namunefolee kinefe leterife. Gote Devitelufe inalilufwale natelee, ‘Mene Jesilu lefoo, Devitele wolu fetaie, nanoo menanoo menengoi laoolaleelu lufwa. Yesou mareteku mene leterife nafwielule nanoo nemboue mareteku letebe.’ ");
INSERT INTO kwo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Gote wolume nasi letelee, Devitelu nambuanelufu ari weenalelanelu bofoo ame Israelele rieleeke, Israele eetei paie naporilu lufwa, Jiseselufe nelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisese nalilu amee ameele ame pulefori preme lelali, tetoo Jone Israelefu inalilufwale nalilu fwagilu ameele mareteku mufenueteneke, te melei pienueri nale alipotemelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jone nalilu amee ameele pookanalerife lelaleelu lie wolu roboi lefoolali, tetoo nelee, ‘Oone menengu ake leoolamo, meneboe ine? Mene glei eke oolefoolamolu lufwa. Mwa. Te bie filabu, nanoo rierife lelaleelu liekoe wolu roboi lelee, mene glei wolilu lufwa tetoo nanoolu kuli leeloofu priemoole klinepofofe. Mwa.’ ");
INSERT INTO kwo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Apane, oone Abrahamelufi weeneterieleelufu silu, rawie inalilufwatu Gotele reeyemee lefoolamwamolu, bie fiewobu. Jisese inalilufwale eetei paie naporife lelaleelu nale eetegenife Gote wolu menafe Jisesele nafoleeke rielee. ");
INSERT INTO kwo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Te Jerusalemefu inalilufwa, nambulelanelu lufwatu mare glei rame lefoone, eetetie Jisese Gote nali namunefoleelu lufwa. Marena, Judanelu alina itei Yenalerilu Liei maretekume telu lufwa Gotelu ragoofu nale alipoolanelu lufwa pilenelu nale alipotemelee, eetegenife glei amwi menengu lene. Mwa. Tefe Jisesele teiefooneke tafilarife nenelu lie eetetie bebriefu na wolu bolelutu lelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jisese fwagilu amee glei leleeke fetane, mwa. Kame yemereti Pailatele noopoo nafoomene tetoo teiefoleeke tafilarife. ");
INSERT INTO kwo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bebriefe lufwa Jisesele ame leforife lelanelu nale mareteku nanoo wolu leteneke, te ka mwafule faleneke ti menei wofatine. ");
INSERT INTO kwo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mwa. Gote ti menefule boe kelafoleeke, oofuli lelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Te tupane Galilifu Jerusalemeile mare peepee ifenenelu nalife fete fete amenei krie soo letelee. Nanoo nalilu ootu fetanelu naleme Judafu inalilufwale alipotelane. ");
INSERT INTO kwo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Mene nembue oonane na ulu wolilule namoolane, Gote menanoo fetalianele amwi nasi letelee, ");
INSERT INTO kwo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","eetete nembue Gote wolu Jisesele ti menefule kelafolee, tetoo menafe, ekeni fetalianelufu arile, fetou nelee ekeni nasi leleelu wolu bolelutu lelee. Ekeni nafe neleelu na, Saue Buke 2 fi neleelu, eetetie eese nelee, ");
INSERT INTO kwo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Gote Jisese tafilaleelule ti menefule kelafoleeke, tefe boe glei tafilaleeke, ti menei sekura lebe, mwa. Gote nelee, ‘Mene ame oonane amwi lemwieke, tetoo oonane aikopi wolilule nifwamorife lelaie, eke Devitele nasi lefwielu atukwe.’ ");
INSERT INTO kwo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Te Saue bukei bofoo na kalu lalaleelu eese nelee, ");
INSERT INTO kwo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mena rame lene, Devite ame eetegeni inengoi lameli, nanoo Gotelu menenguleme nifefoomelee. Sabei tafilaleeke, tetoo fetalianelu ti menei fatineke, sekura lelee. ");
INSERT INTO kwo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mwa. Ekeni lufwa Gote ti menefule kelafoleelu nanoolu ree tupulu glei sekura lefolee. ");
INSERT INTO kwo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tefe apane, mene oonane na lebati na alipomoolanelu tetoo oone rame letewarife, eetegeni Jisese rieleelukoe, oonanoo fwagilu ameele wogrinatemorife rielee. ");
INSERT INTO kwo_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moseselu Na Kaisekli oonanoo fwagilu ameele glei wogrinatemolee. Mwa. Jisesele menengoi ifelalanelu inalilufwa, Jisese nanoolu fwagilu ameele mareteku wogrinatelaleealee, tetoo lie platefu inalilufwa natelaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tefe oone amwi tootookoo lelabu, bebriefe Gotelu ragoofu nale alipomenelu lufwa nenelu na kose ekeni oonane kurulemobile. Nanoo eese nene, ");
INSERT INTO kwo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Oone eeneri na nelamwamolu inalilufwa, oone oofwanepoolabu, ame betige lemoke, nembuari lebule. Mene ame oonanoofi fime bofoo oo tefoo yesoule lemofe, eetegenife lufwa bofoo namoli mei, glei marena nebule mwa.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Te weife Barnabasetu Judanelu alina ite menefu warife lelanei, tetoo inalilufwa mareteku natene, “Boe mwafu Yenalerilu Lietu oone weifeme boe rimoke, tetoo menane ekeni yesou nafe boe yenebu.” ");
INSERT INTO kwo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Te inalilufwa Judanelu alina itele grialeneke, te Judafu inalilufwa, te Gotele reeyemee lefoolamwamolu rawie inalilufwatu motukweme Polele tukwe, Barnabasele tukwe nifetewatene. Te Pole weife Barnabasetu inalilufwale nale fanetewatelane, tetoo Gotelu menenguleme nifelanei, nanoolu keemakeefime lafwalabile. ");
INSERT INTO kwo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Te bofoo Yenalerilu Lietu ekeni wokoo soulufu inalilufwa motukwe ririaneke, Judanelu alina itei lukuleneke, te Pole weife Barnabasetu Paielu Jiseselu nale natemenei fietemene. ");
INSERT INTO kwo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mwa. Judafu ipoelu lufwa inalilufwale motukwe lukuleneke fetatenelufe te nanoole tupu letelane. Tefe Polelu nale futeni lefoolanei, eeneri nale nafoolane. ");
INSERT INTO kwo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mwa. Pole weife Barnabasetu glei ragoo glietenei, “Gote menafe napolee Judane oonane molukwe Gotelu na Jiseselufe neleelule alipomoone. Mwa. Oone wolu ulabee nemo. Oone nemolufe, mene eetegeni same lafwalarilu oofulilule glei falerife mare namoolabile. Bie fiebu! Nembue mene rawie inalilufwale Gotelu nale alipotelabile. ");
INSERT INTO kwo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Paielu wolu menafe napolee, ");
INSERT INTO kwo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Te rawie inalilufwa ekeni nale fiemeneke, te ekeni na melee petilu atukwe menengoi sunaleteleefe tefe menengu metie mutukwe letelanei, te nene, “Gotelu na Jiseselufe neleelu wolilu feti lelee.” Te rawie inalilufwalufule Gote namuneteleeluleme, same lafwalarilu oofulilule ifelalabile, eke Jisesele menengoi ifelalarilu panefe lenelu. ");
INSERT INTO kwo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Te ekeni krietu Jisesele menengoi ifelalanelu te wokoo te wokoome wari afwalanei Gotelu na Jiseselufe neleelule alipoofwatelane. ");
INSERT INTO kwo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mwa. Judane Antiokefu paie tefoo rawie inali Gotele reeyemee afoolanelule tukwe, te paie paielu lufwalu menengule tukwe tuteli letene. Tefe fame natu sugurune sugurune ifatene Polele weife Barnabasele tukwe, te noopoo natemeneime, tetoo ekeni distrikele grialeneke wane. ");
INSERT INTO kwo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tefe weife inengu asalu nalilu kulifule pupunateneke, te wokoo soulu Aikoniameile wane. ");
INSERT INTO kwo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antiokefu Jisesele menengoi ifelalanelu inalilufwa paie paie apoolane te mei Wolilu Fifri seenaletelaleefe. ");
INSERT INTO kwo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Te Pole weife Barnabasetu Aikoniamei wolume Antiokei amenelu amee amee atukwememe Judanelu alina iteile waneke Jiseselu nale amwime alipotemene. Tefe Judanelu, Grikelu inalilufwa Jisesele menengoi ifelalarife lelanelu ameelu metie peenaletelalee. ");
INSERT INTO kwo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mwa. Judane telu, Jiseselu nale menengoi ifelalari preme lenelu, rawie inalilufwalu menengule atukwe tuteli letene, tefe inalilufwa telu Polele, Barnabasele weife Jisesele menengoi ifelalanelu inalilufwale neeneekeke fame letene. ");
INSERT INTO kwo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mwa. Jisesele menengoi ifelalanelu inalilufwalu ameelu motukwe lelee tefe Poletu Barnabasetu teime lamenei krie soo letelee. Tetoo weife glei ree pritetene Paielulu keemakee nale alipoterife, mwa. Gote nali Polelu Barnabaselu ameetu brege brege letemenelufe tefe inalilufwale eesalule fetou natelarife natelee, ekeni na aposele Jiseselufe alipoolanelu nanoo marena nale alipoolane. ");
INSERT INTO kwo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Aikoniamefu inalilufwa nali kwaife wolu fime fime anelu, te telutu tekaleleeke Judanelu porite gulunalenei, te telutu tekaleleeke aposelelu porite gulunalene. ");
INSERT INTO kwo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Te rawie inalilufwatu, Judanetu, te nalilu nambulelanelu lufwatu, maretekume lukuleneke neenee kukwapoone, tetoo aposelele titu puketeneke troonalerife. ");
INSERT INTO kwo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mwa. Poletu Barnabasetu ekeni amee leterife lelanelu nale finelufe, te esulu Likoniame distrikei lainelu wokoo soulu are, Listratu Derbetu te ekeni wokoo sosoulu bwagei lafwanelu wokoome brunetewane. ");
INSERT INTO kwo_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Te ekeni wokei Jiseselu na ulu wolilule weife teime alipotemene. ");
INSERT INTO kwo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Te Listrai lufwa bofoo kuli troonalefoonelu lafieleeke lamelee. Te yefee eesalu reetume lupoleleefe, tefe kame wariari preme alaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ekeni lufwa Polele Jiseselu nale alipoolaleelule fiefoomelee. Te Pole ekeni lufwale oo teime lefoomeleeke, te oo porite fetaleelu, ekeni lufwalu menengoi nelee, Jiseselume menane ame amwi lewobe. ");
INSERT INTO kwo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tefe Pole ekeni lufwale ragoo iteritu nafolee, “Sei, oone furaleluke teme.” Te ekeni lufwa fieleefe, esulu gugutepoleeke te temeleeke wari alee. ");
INSERT INTO kwo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Te inalilufwa motukwe Pole ekeni lufwale eese lefoleelule fetaneke, tetoo mareteku Likoniamelu natu ragoo iteritu eese nene, “Fetabu! Te gote wolu lufwafe leneke menanoofile titirinene.” ");
INSERT INTO kwo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Te ekepane Barnabasele nafoone, nanoo paielu gote Suse pai. Te Polele Hermese nafoone. Nanoo eese nenelu, Hermese gotanelu na alierilu, te Pole Hermese keme na mare nelaleealeelu lufwa, tefe Polele Hermese nafoone. ");
INSERT INTO kwo_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Te gote Suselu ite wokoo soulu ambolu porite teme lalee. Te Suselu prise rieleeke, bulmakau kabinele telutu leleeke, te rani yesou wolu gooroonepoonelutu geeneri letewafoonelu ambleneile iferietelee. Suselu prisetu inalilufwa wolu lukulenelutu mareteku Polele tukwe Barnabasele tukwe nalilu gotele atelananelu amee atukwe leterife. ");
INSERT INTO kwo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mwa. Aposele Poletu Barnabasetu weife ekeni yesoule tukwe leterife lelanelu nale fineke, te metie betige leneke, nalilu leeloole brinane ateneke, te weife inalilufwalume pipinapoofwanei ragoo iteritu eese nafwatene, ");
INSERT INTO kwo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Oone pane, oone menane kose ekeni bilutu nebule mani, mwa. Mene weifekoe glei gote, menekoe oone atukwe lenelu lufwa. Mene weife oonanoofile rinelukoe oonane na ulu wolilule namorife rine. Eete oone ekeni yesou oofulilu preme lenelule letelamolu ameele grialetemoke, te marena naleme nifelabu. Gote mwamole nalimaku same lalaleealeelu Gote, tefe mene nalilu nale namorife rine. Ekeni Gote eetegeni inengule, inalilufwale, bolele, inengoi serinapoolananelu yesoule brege leteleelu Gote. ");
INSERT INTO kwo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Marena! Bebriefe ambuanelu lietu, Gote oone rawie inalilufwale ooloome lemoleeke tetoo glelu glelu gotelu bilu mwai letelamwamo. ");
INSERT INTO kwo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mwa. Gote inalilufwale glei amoireteleealee. Mwa. Nanoo utetu utetu oonane wolilu ameeleme lemoolaleealee. Nanoo oonane aroole fanemoleealee, te fori yesou inengufule melee frialetelali tetoo amwi serinapoolanane. Oonane fori yesou motukweme nifwamoolaleealee, tetoo oonanoo menengu mutukwe lemoolanei paie paie apomoolanane.” ");
INSERT INTO kwo_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Weife ekeni nale ange natemenei, mwa, nanoo mwate mwatetume ekeni bulmakaule puketeneke, ifi tupuarife lenelu, mwa, glei lene. ");
INSERT INTO kwo_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Te krie soo leteleeke tetoo Judane telu wokoo Antiokefu, Aikoniamefu Listraile rine. Te nanoo Listrafu inalilufwalu menengule tuteli letenelufe, tefe Polele titu peperee neneke, oorife leleeke inengoi yeferalelee. Te nanoo tafilalee pai neneke, te beleneke, glitewaneke, ambolufi wotepoleneke oolamelee. ");
INSERT INTO kwo_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Te ekepane Jisesele menengoi ifelalanelu Polele fwainalefooneke temepoolanei, Pole furaleleeke tupane mare boe wokoo soulume wane. Te bofoo lietu Poletu Barnabasetu Listrale grialeneke weife Derbe wokeile wane. ");
INSERT INTO kwo_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Te ekeni wokei weife lapolemenei na ulu wolilule inalilufwale alipotemene. Te inalilufwa motukwe disaipelefe lene. Te weife boe Listrame, Aikoniameme letewaneke, te Antiokei kuruwolene. ");
INSERT INTO kwo_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Te eeteise weife disaipelele na fatietemenei kuli reeneletemenei te natene, “Oone Jiseselu menengoime lalabu. Mena Gotelu ameime lalabile nenei, mena glelu glelu oo nembulule falelabile.” ");
INSERT INTO kwo_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Te Pole weife Barnabasetu Gotelu inalilufwalufu wokoo mareteku mwamole mwamole wokoofule yefeelu lufwafe lerife namunefwatene. Pole Barnabasetu fori yesoule ambopooneke lalanei, Gotele na woponefoonane, te ekepane Jisesele menengoi ifelalanelule Jiseselu amei tepoletene. ");
INSERT INTO kwo_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Te Pisidiame waneke te Pamfiliai kuruwolene. ");
INSERT INTO kwo_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Te wokoo soulu Pergai kuruleneke, te ekeni wokoofu inalilufwale Gotelu nale alipotene. Eese leneke, tetoo weife mwi melee mitilufi lalaleelu Atalia wokoo soulume titirinene. ");
INSERT INTO kwo_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Te Ataliafu brai soulu neunateleeke, boe Siria provinsefu Antiokeile boe wane. Te eetegenifu inalilufwa Jisesele menengoi ifelalanelu nali wolume Polele Barnabasele tukwe namunetenelu, Gotelu amei teponunelu, tetoo waneke rawie inalilufwale nalilu amee ameele woletelarife, te nembue wolu pookanalene. ");
INSERT INTO kwo_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Te weife Antiokei kuruleneke, te Gotelu inalilufwale mareteku luku ifeleteneke, te yesou mareteku Gote nanoolu ameetu leteleelule, te rawie inalilufwa Jisesele wolu menengoi ifelalanelu nale tukwe alipotene. ");
INSERT INTO kwo_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Te Pole weife Barnabasetu teime Antiokefu disaipele mare lamenei wosi soo letelee. ");
INSERT INTO kwo_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Te Judiafu lufwa telu Antiokeile rineke, te Jisesele menengoi ifelalanelu inalilufwale natelane, “Lufwa bofoo oonanoo ree leeloole ame kreenapomori preme lemoolanei eke Moseselu na neleelu atukwe, eetete oone Gotelufi glei paie nebule.” ");
INSERT INTO kwo_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Te Pole weife Barnabasetu ekepane lufwa nenelu nale fietenelufe, tefe weife glei asekee na ifenatene, mwa. Tefe Polele, Barnabasele, telu Jisesele menengoi ifelalanelule tukwe namunetene, tetoo Jerusalemeile waneke, eke nenelu nafe aposelele tukwe, Gotelu inalilufwa yefeelu lufwale tukwe wofetaterife. ");
INSERT INTO kwo_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tefe Gotelu inalilufwa tupanele fori yesoule, bwaleele nifwateneke te nateneke, wane. Tupane Fonisiame, Samariame ekeni distrike arelume lemenei, Jisesele menengoi ifelalanelu inalilufwale natelane, rawie inalilufwa mei wolu motukwememe Jisesele menengoi ifelalanelu inalilufwafe lenelu nafe. Tefe Jisesele menengoi ifelalanelu inalilufwa mare eetegeni nale finelufe metie menengu mutukwe lene. ");
INSERT INTO kwo_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Te Pole Barnabasetu mare namunetenelu lufwa Jerusalemei kuruwoleneke, te Gotelu inalilufwatu, aposeletu, yefeelu lufwatu paie paietu kakali fri ifeleteneke, te iteile ifwatene. Te Gote nali tupanelu ameetu sere letewateleelu nale tatukweme alipotene. ");
INSERT INTO kwo_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mwa. Te Farisifu telu Jisesele menengoi ifelalanelu temepooneke te nene, “Rawie lufwa, Jisesele wolu menengoi ifelalanelule, lufwalu ree leeloole kreenapotebi, te mei Moseselu Na Kaiseklilule nifelarife natebi.” ");
INSERT INTO kwo_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Te ekeni nale amwi sere lerife tefe aposeletu yefeelu lufwatu mare lukulene. ");
INSERT INTO kwo_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nanoo ekeni nafe wolu fune na fune na neneke, tetoo Pita temeleeke natelee, “Apane, oone wolu rame lemo, bebriefe Gote menafe amee ameele lemwamoleleeke, te menane namunewoli, tetoo rawiele Jiseselu na wolilule menanoo ragoofule fineke, tetoo Jisesele menengoi ifelalarife. ");
INSERT INTO kwo_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Gote inalilufwalu menengule mareteku amwime rame leteleelu, nanoo menafe eesalu fetou neri lelee, rawie inalilufwale Gotelu Wolilu Fifrile fanetelee eete menafe tinepoleelu atukwe. ");
INSERT INTO kwo_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gote menafe alaleealeelu atukweme rawiele mei same eesalu ameeleme atelaleealee. Eete Gote nanoolu fwagilu ameele wogrinatelee, nali Jisesele menengoi ifelalanelufe. ");
INSERT INTO kwo_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tefe ooneboe glefe nembue Gotele tuteli ifalamoi, te ekeni Moseselu Na Kaiseklilule nifelarife ritilule rawie panelu ambotifi boluatelamo? Bebriefe mei menanoo fetaliane, te mena mei ekeni na kaiseklilule glei amwi nifemene. Mwa. Tefe oone kose nanoolu ambotifi eesalu ritilule boluatelabule mani. ");
INSERT INTO kwo_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Marena mena menengu lene, mena Paielu Jiseselu keemakeefi tetoo eetei paie napoone, te rawie inalilufwale mei sameme letelee.” ");
INSERT INTO kwo_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Te inalilufwa mareteku lalanelu metie pepeleneke, te Barnabase weife Polele tukwe futeni fipwaletelane. Te weife alipoofwatene Gotelu kaiseklilutu te yesou te yesoule brege bregele rawie inalilufwalu oofi afwatelanelule alipotene. ");
INSERT INTO kwo_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Weife na wolu pookanaleneke, te Jemse fune natelee, “Apane, menanoo nale fioolabu. ");
INSERT INTO kwo_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon Pita oonane wolu namolee Gote rawie inalilufwalufile molukwe rieteleelu tetoo nalilu inalilufwafe lerife namunetelee. ");
INSERT INTO kwo_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Te Gotelu ragoofu nale alipoolanelu lufwalu na mei eetegeni na atukweme lelee. Nanoo eesalu pileri lene, ");
INSERT INTO kwo_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Paielu nelee, “Sabei mene boe ame riefe, te ekeni ite Devitelu wolu prinalefoleelule, mene boe ame yesou temolutu tuefe, ");
INSERT INTO kwo_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tefe rawie inalilufwa menane ooraoolabile, ekepane mareteku nia wolu nianoofe lerife namunetielule.” ");
INSERT INTO kwo_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Eetegeni na Gote nalilu bebriefeme eetegeni yesou kurulerife neleelu.’ ");
INSERT INTO kwo_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Te nembue menanoo menengukoe eese lewolee, mena kose tupane rawie lufwa Gotele wolu menengoi ifelalanelule, te amee te amee nafe natelabile mani, Jisesele niferilu afwee gigime letebe. ");
INSERT INTO kwo_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tefe mena kame bie lofoofi pilu leneke, te amee lelarilu nafe natebile. Kose kose gotele luatelanelu fori yesoule kose foopoolabile mani, eetegeni amee lenei, eetete nanoo Gotelu oofi fwagilu ameetu lebile. Te kose tuwi amee preme. Te bolele borei krinaletelanei troonalelanelule mei, kose foopoolabile mani. Te bole fweelupotu mei kose foopoolabile mani. ");
INSERT INTO kwo_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mena wolu rame lene bebriefeme pulefooneke, leterieleelu amee, te nembue mei wokoo wokoo mareteku eesalu amee lelane, Moseselu nale alipoolanane Judanelu alina itei, te Yenalerilu Lietu mei sameme alipoolanane.” ");
INSERT INTO kwo_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Te aposeletu yefeelu lufwatu mare Gotelu inalilufwatume na faleneke, lufwa are nalilufuleme namunetene. Lufwa bofoo Judase nafoone, bofoo bilu Barsabase, te bofoo lufwa Sailase. Weife Jisesele menengoi ifelalanelufuleme nambuletelarilu lufwafe lene. Te nanoole weife nateneke, Polele Barnabasele tukwe Antiokeile walanei nifetewatene. ");
INSERT INTO kwo_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Lofoo pilenelu genile nanoolu amei tepoleteneke tewanelu, ekeni lofoofi eesalu nale pilene, “Mene aposele, te mene yefeelu lufwa, mene mare oonanoo apane, mene oonane eetegeni lofoo pileneke oonane riemolee, oone rawie Jisesele menengoi ifelalamolu Antiokefu, Siria provinsefu Silisiafu ekei mareteku lafwalamolule. Nemboue feti lie. ");
INSERT INTO kwo_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mene oonanoo na eesalule fine, menanoofu lufwa telu oonanoofile rineke, nanoolu nale fietemoke, arie glei paie paie atemoi. Tetoo nanoo oonane glelu glelu menengufe na namoonelu, mwa, mene glei eese lerife natene. ");
INSERT INTO kwo_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mene eetegeni yesou na ulule finelufe, tefe mena menengu mwamole leneke te na falene. Tetoo apanele are namunetene oonanoofile riemorife, apane mena nafietelananelu lufwa are Pole weife Barnabasetu. ");
INSERT INTO kwo_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nanoo menanoo Paielu Jises Kraiselu nale aliporife nalife glei menengu leneke ree pritetene. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tefe mene Judasetu Sailasetu nateneke oonanoofile rine. Tetoo eetegeni nale namorife lelane nalilu ragootu. ");
INSERT INTO kwo_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Wolilu Fifritu, te mena mei eesalu menengu lene, mena oonane glei bofoo geni ritilule fanemoolanei, mwa. Tefe oone kame eetegeni ameeleme nifelabu. ");
INSERT INTO kwo_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Oone kose kose gotele luatelanelu fori yesoule kose foopoomwabule mani. Mwa. Te bole fweelupotu mei kose foopoomwabule mani. Bofoo mei bolele borei krinaletelanei troonalelanelule kose foopoomwabule mani. Mwa. Oone tuwi ameele grialetebu. Oone eetegeni fwagilu ameele grialetemoi, tetoo oone metie amwime lalabu. Na tetie mai.” ");
INSERT INTO kwo_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Te Jerusalemefu aposeletu Gotelu inalilufwalu yefeelutu tupane lufwa yerifurutu natene, esulu Antiokeile titirinene. Te Antiokei Gotelu inalilufwale luku ifeleteneke, tetoo eetegeni lofoo pilenelule fanetene. ");
INSERT INTO kwo_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Inalilufwa lofoo pilu wolu fetaneke, te paie paie afoone eetegeni nale nanoolu menengu mutukwe letene. ");
INSERT INTO kwo_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sailasetu Judasetu nanoo weife Gotelu ragoofu nale alipoolanelu lufwa. Tefe weife Gotelu inalilufwale na wolilule finaletene, tetoo eetegeni natu menengule meleele atukwe sunaletene. ");
INSERT INTO kwo_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Teime Antiokei weife krie soo leneke, te Gotelu inalilufwa tupanele keemakeetu kapoonetelaneke, te nateneke, te boe Jerusalemefu Gotelu inalilufwalufile wane. ");
INSERT INTO kwo_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Te Pole weife Barnabasetu Antiokei lamene. Tetoo nanoo weife lufwa motukwe mare inalilufwale Gotelu nale fetou natemene, Paielulu na ulu wolilule alipotemene. ");
INSERT INTO kwo_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Te lapolelaneke, tetoo Pole Barnabasele nafolee, “Sei, mena weife bie waneke, boe te wokoo te wokoofu Gotelu inalilufwale mareteku fetafwatebile. Ute bebriefe mena weife Gotelu nale alipoofwatelanelule. Mena weife rame leterife, Jisesele nembuame menengoi ifelalanelu inalilufwafe lenelu nemboueme pe lalane?” ");
INSERT INTO kwo_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Te Barnabase Jonele mare ifwarife nelee. Nanoolu bilu bofoo Make nafoone. ");
INSERT INTO kwo_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Te Pole nelee, “Ekeni lufwakoe bebriefe menane weife wolu Pamfilia distrikei ulabee neleelu, Gotelu amee ameele letewarife. Tefe mene nembue weife glei ifwabile. Mwa.” ");
INSERT INTO kwo_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Te Jon Makele ifwarife weife fune na fune na nene. Tefe weife fime fime ane. Mwa. Barnabase Makele ifwalee. Te weife brai soulufi peepeeneneke, te mwi melei lalaleelu wokoo tupulu Saipruseile ifwatelee. ");
INSERT INTO kwo_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Te Pole mei Sailasele neunelee. Te weife warife lelanei te Antiokefu Jiseselu disaipele nanoole weife natene, “Paielulu keemakee oonane ifelamoolabee.” ");
INSERT INTO kwo_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Te weife Gotelu inalilufwale Jiseselu nale menengoi ekeni Siria provinsefule tukwe Silisiafule tukwe meleele atukwe sunaletene. ");
INSERT INTO kwo_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Te Pole waleeke, Derbe wokei wosekaleleeke, te Listraile mei walee. Te ekeni wokei Jiseselu disaipele lamelee, nanoolu bilu Timoti nafoone. Nanoolu yefeekoe Judafu inali. Ekeni inali Jisesele menengoi ifelalaleelu. Te yari fime Grikefu lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listrafu Aikoniamefu Jisesele menengoi ifelalanelu inalilufwa Timotile nafoonane, Timoti wolilu amee tefoo lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pole Timotile weife ifwari menengu lefoleefe, tefe nafoleeke, te ree leeloole teka lefolee. Nanookoe Judafu panele menengu letelee, ekeni wokoo soulu porite lafwalanelule, tefe Timotile eese lefolee. Judane wolu rame lefoone, nanoolu yari fime Grikefu lufwa, te eetegeni amee tupane glei alanane. ");
INSERT INTO kwo_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Te wanelu, wokoo wokoo letewalanei alipoofwatelane ute wolume aposeletu yefeelu lufwatu Jerusalemei sere lenelu nale Jiseselufe lenelule nafwatene. Te natene, “Oone eetegeni naleme nifetalabu.” ");
INSERT INTO kwo_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tefe Gotelu inalilufwalu menengule mareteku kuli reeneletemenei, ameelu metie te krie te krie peenalerime lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Te Wolilu Fifri Esia provinseme na alipoofwaterife ble nateleefe, tefe Pole, Sailase, Timoti Frigia distrikeme Galesia distrikeme afwane. ");
INSERT INTO kwo_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Te Misia distrike guelume wolu waneke, Bitinia provinseile warife lenelu, mwa, ekei Jiseselu Fifri ble natelee. ");
INSERT INTO kwo_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tefe kame Misia distrikele amoitefooneke, te titirinene wokoo soulu Troasei kuruwolene, melee soulufi lalaleelu. ");
INSERT INTO kwo_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Te ekeni krietu Pole rarauetu atukwe, tetoo lufwa bofoole fetalee Masedonia provinsei temelali, te Polele fieri nafolee, “Oone bie menanoofile rie, Masedonia provinseile rieluke, tetoo menane aikopi lepo.” ");
INSERT INTO kwo_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pole eetegeni yesoule fetaleefe, te esulu mena Masedoniaile wari afweele oorafoone. Menate rame lene, Gote nali menafe napolee, ekepanele na ulu wolilule alipoterife. ");
INSERT INTO kwo_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troasefu brai soulufi peepeeneneke, Samotrese wokoo tupulume ifwapoleeke, te bofoo lietu Neapoliseile ifwapolee. ");
INSERT INTO kwo_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ekeni mwi melee mitilufi lalaleelu wokoo soulule grialeneke, afweeme peepeeneneke te Filipai kuruwolene. Bebriefe Rome rineke eetei wokoofe lemenelu, te Masedonia distrikefu ekeni wokoo Filipai nembouefe letelaleelu. Te mena teime ekeni wokoo soulufi krie soo lene. ");
INSERT INTO kwo_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Yenalerilu Lietu ekeni wokoo soulule geeneri letewanelu amblenime kuruwolene, te melee mitilufile wane. Mena menengu eese lene, eetegeni melee bwagei na woponefoolananelu tekoo pai lalalee nene. Te ekeni melei inali telu lukulelanei fetatenelufe, te ifelaprueteneke na ifenatemene. ");
INSERT INTO kwo_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ekenifu Taiatairafu inali bofoo bilu Lidia nafoone, nanookoe leeloo lubulule bwaleefile letelaleealee. Lidia rawie inali, te mei Gotele reeyemee afoolaleealeelu. Te Gote Lidialu menengule falefolee, Pole alipotemeleelu nale futeni mwamole lefolee. ");
INSERT INTO kwo_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Tefe Lidia nalilu itefu panele tukwe maretekume melei pienune, te Lidia natelee, “Oone menane menengu eese leoomoi, ‘nanoo wolu Jisesele menengoi ifelalaleelu inalife lelee’ nemoi, te oone bie menanoo iteile riebu.” Eese neleefe, tetoo mena nanoolu nale fiefooneke nifene. ");
INSERT INTO kwo_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Te bofoo krietu mene eetei lukuleneke Gotele na woponefoonanelu tekoile walanei, te afoi auteli ramulu amee amee alaleealeelule fetane. Ekeni auteli ramulu naifofu seenalefoleeke ifalali, tetoo glelu glelu yesou sabei sekalerife lelaleelule alipotelaleealee, tetoo bwalee falefoonane. Eetegenife ekeni auteli ramulu nalife nambulefoolananelu lufwa bwalee soulule falelanane. ");
INSERT INTO kwo_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mena Polane mare walanei eetegeni auteli ramulu nifetapoolali eesalu nale upe upe afwalalee, “Tupane lufwa nanookoe Paie Tefoo Gotelu amee amee lufwa alane. Te nanoo oonane afwee bofoole eetei paie naporife namoolanane.” ");
INSERT INTO kwo_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Te te krie te krie ekeni auteli ramulu nifetatelali eetegeni naleme nafwalaleealee. Pole eetegeni nale upe upe ameleefe futeni sookootu lefoomeleefe, te aikoemwi leleeke ekeni auteli ramulule fetalali, te ekeni naifofule nafolee, “Mene nembue oonane Jises Kraiselu bilutu naoolaie, oone nembueme ekeni auteli ramulule grialeluke wa.” Esulu ekeni naifofu grialeleeke walee. ");
INSERT INTO kwo_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Te ekeni auteli ramulule nambulefoolananelu lufwa eetegeni ameele fetanelufe, mwa, bwalee falerilu afwee gigime letelalee. Tefe Polele weife Sailasele tukwe bebeneneke wokoofu nambuletelanelu lufwalu ameile glitewapoone eke sakenee alanelu tekoile. ");
INSERT INTO kwo_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Te ekepane nambuletelanelu lufwa ifwateneke nale fipwaletelananelu amei sinateneke, te natene, “Tupane lufwa nanookoe Judane, weife menanoo wokoofu inalilufwalu menengule teietelanei, menengu ti napotelane. ");
INSERT INTO kwo_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nanoo weife eetefu inalilufwalu menengule iretelane eke fwagilu amee mena Romefu inalilufwa glei alananelule.” ");
INSERT INTO kwo_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mwa. Te eke lukulenelu inalilufwa mei Polele Sailasele tukwe kame yemereti na ifenatene. Te tupane nale fipwaletelananelu lufwa nanoo lufwa bofoole leeloo liganueteneke, te kafune botukolitu bubuaporife natene. ");
INSERT INTO kwo_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Te nanoole weife metie koona babi kukunapooneke, te kalabuse itei sinatene. Te kalabuse itele regi lefoolaleealeelu lufwale neeneekeke fame lefoolanei, nafoone, “Oone amwime feti regi letela.” ");
INSERT INTO kwo_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Te nali eetegeni nale fieleefe, mwa, nanoole weife menefu gueileme ifwatelee. Te kulile ka meneeme sinapoteleeke, te seinetu krinaletelee. ");
INSERT INTO kwo_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Te krie babi lelali, Pole, Sailasetu weife Gotele na woponefoomenei, te sauetume ifamenei kalabuse itei lalanelu mei fietemene. ");
INSERT INTO kwo_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Esulu alineri selimeme afoolali, te ekeni ite reenelalee ka maretekume kulukunapooneke te amblenitume munapoofwane. Te ekepane kalabuse itei lalanelu kuliameele seinetu bulupoofwatenelu geni maretekume tupwapoofwatene. ");
INSERT INTO kwo_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Te ekeni itele regi lefoolaleealeelu lufwa furaleleeke te amblenile maretekume munapoofwaneke lailanei fetateleefe, te nanoo menengu eese lelee, ekepane mareteku kalabuse itei lalanelu wolu pai maretekume brunalene nelee. Tefe nanoo kwasuele ligalelee, tetoo nalife teieleeke tafilarife. ");
INSERT INTO kwo_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tetoo Pole ba nalefoleeke nelee, “Ei, oone kose oonafe teiele mani. Mwa. Mene maretekume eetetie lalane.” ");
INSERT INTO kwo_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Te ekeni lufwa kalabuse itele regi lefoolaleealeelu nanoo lufwa telule fieri natelee i rutepooneke teriporife. Te teripoonelufe, te esulu Pole, Sailasetu weife lalanelu ite gueme wofri menengutu wopreieleeke, te tumoinu krutupolee. ");
INSERT INTO kwo_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tetoo nanoo ite guefu ambolufile ifwatelee. Tetoo ekepanele weife fietelee, “Sei. Oone weife lufwa paielu, mene akeke liekeme, tetoo Gotelufi paie nefe?” ");
INSERT INTO kwo_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Te weife nafoone, “Oone Paielu Jisesele menengoi ifelalalu, eetete oone, oonanoo itefu panetume Gotelufi paie napobule.” ");
INSERT INTO kwo_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Te weife Gotelu nale ekeni lufwale tukwe nalilu itefu panetume teime alipotemene. ");
INSERT INTO kwo_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Te ekeni krietume kalabuse itele regi lefoolaleealeelu lufwa ekepane aposelele neunateleeke te fofoole suwanaletelee. Pole, Sailasetu weife ekeni lufwale tukwe nalilu itefu panele tukwe maretekume melei pienune. ");
INSERT INTO kwo_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tetoo ekeni lufwa nalilu iteile ifwateleeke, te kakali ifeletelee. Te nali, mare nalilu itefu panetume paie paie feti apoolane, ekepane nembue wolu Gotele menengoi ifelalanelufe. ");
INSERT INTO kwo_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kwotuekriei nale fipwaletelananelu lufwa polise lufwale nateneke, rine, te kalabuse itele regi lefoolaleealeelu lufwale nafoone, “Oone eetepanele weife teponueluke wabi.” ");
INSERT INTO kwo_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Te kalabuse itele regi lefoolaleealeelu lufwa waleeke Polele nafolee, “Nale fipwaletelananelu lufwa mene oonane teponuemwieke warife naoone. Tefe oone weife kalabuse itele grialemoke, menengu mutukwe lemoke wabu.” ");
INSERT INTO kwo_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mwa. Pole ekepane polise lufwale natelee, “Mene weife Rome retilu lufwa. Glefeme fwagilu amee nale fipwaletelananelu lufwa menane bebenenelu, mene fwagilu amee bofoo lene pe? Mwa. Menane kame yemereti bubuapoone inalilufwalu oofi. Tetoo menane kalabuse itei sinapoone. Te nembue nanoo menane angime pai teponuneke warife nene? Metie mwa! Nalimeme rineke menane weife teponuneke tetoo mene kalabuse itele grialeneke wabile.” ");
INSERT INTO kwo_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ekepane polise lufwa Polelu nale, boe nale fipwaletelananelu lufwale tewatene. Te nale fipwaletelananelu lufwa eesalu nale fine, Pole weife Sailasetu nanoo Rome retilu natenelufe, nanoo metie wofri lene. ");
INSERT INTO kwo_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tefe nale fipwaletelananelu lufwa kalabuse iteile waneke keemakee leteneke, te ite menefu ambolufile ifwateneke, fietelane tetoo weife eetegeni wokoo soulule grialeneke warife. ");
INSERT INTO kwo_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Weife kalabuse itele grialeneke wanelu esulu Lidialu iteileme boe wane. Weife Jisesele menengoi ifelalanelu panele wofetateneke, te nale natemene tetoo menengu kaisekli leterife. Te weife wokoo soulule grialeneke wane. ");
INSERT INTO kwo_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pole Sailasetu wokoo soulu are Amfipolisele Apoloniale tukwe boore leteneke, tetoo wokoo soulu Tesalonaikai kuruwolene. Ekenifi Judanelu alina ite bofoo temetelalee. ");
INSERT INTO kwo_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pole utetu utetu eesalu ameeleme alaleealee, nembue ekeni alina itei wopreielee. Te Pole Yenalerilu Lie krie mwangife lefolee Gotelu bukei lainelu nale alipotemelee. ");
INSERT INTO kwo_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nanookoe Gote nalilu na yewilu bukei lalaleelu nale alipotelali, te natelee, “Kraise ame teteree faleleeke tafilabe, te tafilu boe ame furalebe.” Tefe Pole nelee, “Mene nembue Jisese nalife oonane alipomoolaie, nali Kraise, Gote nali inalilufwale eetei paie naporife namunefoleelu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tetoo Judanelufu inalilufwa telu Jisesele menengoi ifelalarife lene, te Polele weife Sailasele tukwe nifetemene. Te Grike Gotele reeyemee lefoolananelutume mei motukweme, te bilu tefoo inali motukwe mei Jiseselufe lene. ");
INSERT INTO kwo_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tetoo Judane telu ekepane Judane Grikane Poletu weife Sailasetu nifetelanelule fetatenelufe, tefe tupu letelane. Te ekepane lufwa nali lufwa telu fwagilu ameele yefee lefoonelu sakenee tekoofule neunateneke, nanoolu menengule tuteli letenelufe tefe mareme unalene. Te unetewaneke Jesonelu ite amblenile pukunaleneke, Polele weife Sailasele tukwe ooratelane, tetoo inalilufwalu amei teponueterife. ");
INSERT INTO kwo_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mwa, ekepanele glei fetatenei, tefe nanoo kame Jesonele tukwe Jisesele menengoi ifelalanelu telule tukwe glitewapoone wokoofu paie paielu lufwalufile. Te maretekume upe upe afwatene, “Ekepane lufwakoe metie wa rie afwalanei eetegeni fwagilu ameele afwalane eetegeni inengu lemeleelu atukwe. Te nanoo weife nembue wolu rineke lalane. ");
INSERT INTO kwo_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Te Jesone nalime ekepane lufwale nalilu itei lalarife iferietelee. Ekepane Sisarelu na kaiseklilule metie futeni lefoolanane. Nanoo eese nenane, ‘Kine bofoo ame lalalee, nanoolu bilu Jisese!’” ");
INSERT INTO kwo_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ekenifi lukulenelu inalilufwa maretekume, paie paielu lufwatu ekeni nale finelufe metie betige lepooneke tetoo fame na napoofwane. ");
INSERT INTO kwo_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mwa, paie paielu lufwa natene, “Jesone oone mare Jisesele menengoi ifelalamolu, oonane eke bebenamoonelu yewilufe kame bwaleeleme tinebu.” Te ooloome letelanei wane. ");
INSERT INTO kwo_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Oo pinaleleeke, te ekeni krietume Jisesele menengoi ifelalanelu pane Polele weife Sailasetu wokoo soulu Beriaile warife natene. Te weife wolu kuruwoleneke, Judanelu alina iteile preipoone. ");
INSERT INTO kwo_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beriai lalanelu Judane nembouelu ameele alanane. Nanoolu amee Tesalonaikai lalanelu Judanelu ameele boore letene. Te nanoo Jiseselu nafe amwime fiefoolaneke, metie nafiefoone. Nanoo amwi rame lebile neneke, Polelu na marena pe? Tetoo te krie te krie Gotelu bukefu nale boe nalilu ootu fetafwalaneke, tetoo marena na nerife. ");
INSERT INTO kwo_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tefe Judafu inalilufwa motukwe Jisesele menengoi ifelalarife letewane, te Grike natu nelanelufu bilu tefoo inali, te lufwa mei same, Jisesele menengoi ifelalarife lene. ");
INSERT INTO kwo_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mwa. Tesalonaikafu Judane Pole Kraiselu nale Beriai alipotelaleelu na ulule finelufe, tefe nanoo mei Beriai kuruyelene, tetoo inalilufwalu menengule tuteli letenelufe, nanoo metie betige lepoone. ");
INSERT INTO kwo_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mwa. Te esulume Beriafu disaipele Polele mwi melee wafeneile ifeluwane. Te Sailase weife Timotitu teime Beriai lamene. ");
INSERT INTO kwo_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Te tupane Polele ifwarime leneke, wokoo soulu Atensei kuruwoifelene. Tupane Beriaile boe warife lelanei, te Pole nanoolu ragoo pi, Sailasele Timotile tukwe na naterife, “Oone weife menanoofile afeteli feti riebu.” ");
INSERT INTO kwo_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pole wokoo soulu Atensei Sailasele weife Timotile tukwe teime ooletemeli, te kose kose gotele fetafwateleefe tefe nanoolu menengu glei amwi lafiefolee. ");
INSERT INTO kwo_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tefe Pole Judanelu alina iteile waleeke, Judale tukwe, rawie pane Gotele reeyemee afoolananelule tukwe na ifenatelee. Te te krie te krie sakenee tekoi inalilufwale fetateli, tetoo ekei na ifenatelee amelee. ");
INSERT INTO kwo_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Te Epikurianelufu telu te Stoikanelufu telu menengule nifetenanelu yefeelu lufwa mare Polele na ifenene. Te telu nene, “Ekeni lufwakoe yemereti na nelaleealeelu, nanoo gle na nerife nelee?” Te telu nene, “Nanookoe fime bofoo wokoofu gotelu nale nerife lelalee.” Mwa. Pole nanookoe Jiseselufe, te nali ti menefu boe furaleleelufe tukwe alipoteleefe, tefe tupane ekeni nafe nene. ");
INSERT INTO kwo_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Te Polele wokoofu paie paielu lufwalufile eetei na nenanelu Areopaguse afuneile ifwane. Te nafoone, “Mene ekeni na temolule eke oone inalilufwale natelalu alule rame lerife. ");
INSERT INTO kwo_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Menekoe oonanoo nale fineke, mwa, menanoo menengu metie gigime lepoone. Tefe bie oone menafe eetegeni na yewilule alipoofwa.” ");
INSERT INTO kwo_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Te Atensefutu, rawie wokoofutu mareteku lalanelu, nanoo mwa, amee amee bofoo glei alanane. Te nanoo metie sameme menengu mutukwe lelanane na temolu fierife, te ekeni na temolu finelule boe nali kwaife menengu menengu letewafoolanane. ");
INSERT INTO kwo_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Te Pole Areopagusei, wokoofu paie paielu lufwalu oofi temelali te natelee, “Oone Atensefu pane, mene oonanoo menengule wolu rame lemwie, bofoo bofoo gotele te amee te amee leterilu menengu metie kaisekli lemoone. ");
INSERT INTO kwo_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mene walaiei fetafwatielu bofoo bofoo goteleme bilu mwai letelamolu amee letelamwamo. Te mene titu lenelu rigani bofoole fetaie, nanoo ekenifi eesalu nale pilene, EETEGENI RIGANI BOFOO GOTELU, MENE EKENI GOTELE GLEI RAME LEFOOMELULE. Tefe eetegeni Gotele oone glei rame lefoomelule, mene nembue ekeni Gotelu nale alipomorife lelaie. ");
INSERT INTO kwo_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Gote nali liele, inengule, te yesou te yesoule mareteku letewateleeke lailane. Ekeni Gote, nali Paielu. Eetegeni inengutu efenetu nalilu, tefe glei lufwa ameetu tupoolanelu ite menei lalaleealee. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tetoo Gote bofoo yesoufe mei glei lulu neleealee, te mena inalilufwa bofoo yesou lerife menanoo ameetu glei aikopi lefoonane. Nanookoe nalimeme oofulilule, menengu yefoole, yesou yesoule tukwe mareteku inalilufwale nifwatelaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Gote mwamole ambuele ambrei leleeke, tetoo nanoolufime inalilufwa eetegeni inengoi lapruefwane. Te Gote eetei lalarilu krie ameelule tukwe teka teka afwatelee, te inengu guelule mei teka teka afwatelee. ");
INSERT INTO kwo_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Gote eese leteleelu, tetoo nalife ame oorafoolane, tefe inalilufwa nalifeme amwime rame leforife. Te nanoo menafe mareteku mwamole mwamolele glei mokenei lepoolalee. ");
INSERT INTO kwo_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Eetete, ‘Mena nanoolufi oofuli lelanei, tetoo nalimeme kaisekli lepoolali alane.’ Oonanoofu rame ramelu lufwa telu nanoo nene, ‘Mena nanoolu ari lalane.’ ");
INSERT INTO kwo_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mena eetete Gotelu ari lalane, tefe mena kose Gotele eesalu menengu lefoonabile mani, nanoo gole keme, silva keme, ti keme lelee, eke mena lufwa ameetu letelanelu yesoule atukwe. ");
INSERT INTO kwo_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bebriefe lufwa rame leri preme lamenei, Gote mare na glei natemelee. Tefe ta nembue Gote na natelalee, te wokoo te wokoofu inalilufwa mareteku fwagilu ameele mufeleterime lebu. ");
INSERT INTO kwo_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Gote lie ameelu bofoo wolu teka lelee, nali inalilufwale mareteku amwi lafetebe, tetoo nalilu nafi yenaleforilu lufwale, wolu namunefolee. Eetegeni lufwa wolu tafilaleeke, Gote boe kelafoleeke, furalelee. Tefe mena mareteku rame lerife Gote nali eetegeni ameele lelee.” ");
INSERT INTO kwo_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tupane, lufwa tafilaleelu boe furaleleelu nale finelufe, tefe telu Polele eeneri nafoone. Te telu nafoone, “Mene oone eetegeni nafe boe nerife fipwaleoolane.” ");
INSERT INTO kwo_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tetoo Pole grialeteleeke walee. ");
INSERT INTO kwo_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mwa, inalilufwa telu Polele nifetewane, Jisesele menengoi ifelalarife lene. Nanoolufu lufwa mwamole Dionisiuse, nanoo Areopaguselu paie paielufu lufwa, te inali bofoo Damarise, te inalilufwa telu mei mare wane. ");
INSERT INTO kwo_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Fimelufe Pole Atensele grialeleeke Korine wokoo soulufile walee. ");
INSERT INTO kwo_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Juda lufwale eeteise fetalee, nanoolu bilu Akwila, nanoo Pontuse provinsefu. Nanoo nariemu Prisilatu weife Itali kantrile grialeneke, te nembuame rine, glei wolume. Sisar Klodiuse Judanele Rome wokoo soulule grialeneke wawarife natelee. Te Pole waleelu nanoo weife nariemutu wofetatelee. ");
INSERT INTO kwo_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Akwila nariemutu bole leeloole ite tetoo tupoolananelu amee ameeleme letelanane. Pole mei eesalu amee amee tefoo lufwa, tefe ekeni itei mare amenei, eetegeni amee ameele lemene. ");
INSERT INTO kwo_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pole Yenalerilu Lietu Judanelu alina iteile wari ameli, Judafu Grikefu inalilufwale Gotelu bukei lainelu nale ifenatemeli, tetoo Jisesele menengoi ifelalarife. ");
INSERT INTO kwo_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailase weife Timotitu Masedoniafu rinei, te Pole teime te krie te krie Judanele Gotelu nale Kraiselufe alipotemeli, Gote nali inalilufwa eetei paie naporife namunefoleelu lufwa natemelee, “Jisese nalife.” ");
INSERT INTO kwo_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tefe ta Judane nanoolu nale fieforife ulabee neneke eeneri nafoonelufe, tetoo Pole nalilu leeloofu alalele pupunateleeke, te natelee, “Oone nembuari lemoi, eete glei menanoo nembulu. Mwa. Eetete oonanoo fwagilu amee. Nembue mene rawie inalilufwalufile waieke, nale walipotelarife lelaie.” ");
INSERT INTO kwo_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Te esulu Pole Judanelu alina itele grialeleeke, te ite bofoo roboi temelaleelufile walee. Ekeni ite yarilu bilu Titius Jastuse, nanoo mei Gotele reeyemee lefoolaleelu lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Te Krispuse, Judanelu alina itefu yefeelu lufwa, te nariemu, ari maretekume, te itefu pane mareme Paielule menengoi ifelalarife lene. Te Korinefu inalilufwa motukwe Polelu nale fiefoomenelu, nanoo mei Jisesele menengoi ifelalarife letewane, tetoo maretekume melei pienufwane. ");
INSERT INTO kwo_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Te kriei Paielu Polele rarauetu atukwe na ifenelali, te nafolee, “Oone kose wofri lele mani. Boe sameme menanoo nafe inalilufwale alipoofwate. Tetoo boe kose ragoo glietele mani, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Eetete nia oonane ifelaoolaie, tetoo lufwa bofoo oonane glei teiewobile, mwa. Menanoo inalilufwa eetegeni wokoo soulufi motukwe laoolane.” ");
INSERT INTO kwo_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Te Pole Korinei lameli yare mwamole leleeke te boe wosi tialootu lefolee, te teime inalilufwale Gotelu nale fetou fetou nafwatelalee. ");
INSERT INTO kwo_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tetoo ekeni krietume Galio Akaia provinsei gavanafe lelee. Te Judane oorerei lefoolananelu mareme Polele Galiolufile eetei lafieleeke nali nale fipwaletelalee aleelu tekoile ifwane. Tetoo nafoone, ");
INSERT INTO kwo_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Ekeni lufwakoe inalilufwale iretelalee na kaiseklilule futeni lefoolanei, tetoo Gotele bofoo ameetu reeyemee lefoolanane.” ");
INSERT INTO kwo_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Te Pole fune na naterife leleelu, mwa. Galio Judanele natelee, “Oone Judane, eetegeni lufwa glelu na kaiseklilule futeni lefoleeke, bofoo amee nembulule leli, eetete mene nemboue oonanoo nale fiemofe. ");
INSERT INTO kwo_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tefe ta oonekoe eetegeni ameele menengu rufotelamo oona nanoolu nale nelamwamolu nale, oonanoo bilule, te oonanoo na kaiseklilule, tefe pai rimo menanoofile. Mwa. Mene ulabee nie, kame ooname sere lebu. Eesalu nale mene glei fiemoolafe.” ");
INSERT INTO kwo_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Tetoo nanoo ekeni tekoofule nateleeke wane. ");
INSERT INTO kwo_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Te Korine Sostenesele beleneke, te eetei nale fipwaletemeleelu tekoo roboi bubuane. Ekeni lufwa fime Judanelu alina itefu yefeelu lufwa. Te Galio ekeni lufwale eese lefoonelufe glei menengu rufofoli. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pole boe Korinei krie soo lemelee. Tetoo Jisesele menengoi ifelalanelule eetei amee gliapotelaleeke, te Prisila weife nunguli Akwilatu Pole mare Senkriaile wane. Tetoo brai soulu Siria provinse porite warife lelaleelufi peepeeneneke te ifwatelee. Te Senkriai Pole nalilu ipoe kwaleleeke gege nelee, nali wolume Gotele nasi lefoleelule nifeleeke pookanaleleefe, tefe ipoe kwalelee. ");
INSERT INTO kwo_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Te wolu Efesuse wokoo soulufi kuruleneke, te Pole nunguli nariemule teime gria leteleeke, te Judanelu alina iteile preieleeke, te na ifenatemelee. ");
INSERT INTO kwo_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Te tupane Polele nafoone, “Oone bie menane ifelapoolaluke, tetoo sabei wa.” Te Pole fune natelee, “Mwa. Mene glei eese lefe.” ");
INSERT INTO kwo_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Te tupanele amee gliapotelaleeke, te natelee, “Gote nali menane i nawoli boe ame rieke yefetamofe.” Te Efesusefu braifi peenaleleeke, te ifwalee. ");
INSERT INTO kwo_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Brai soulu Sisaria wokoo soulufi imi oonaleli, te Pole Jerusalemeile peenaleleeke, Gotelu inalilufwale fwainaletelali te nemboue lie natelalee. Te boe grialeteleeke, Antiokeile tiraferelee. ");
INSERT INTO kwo_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tetoo Pole ekeise lapolemeleeke, te boe walee. Te Galesia provinsei Frigia distrikei lafwanelu wokoome wa rie afwalali, te disaipelele mareteku kuli reeneleterife. ");
INSERT INTO kwo_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Juda bofoo Apolose nafoone, Aleksandria fwi wokoofu Efesuseile rielee. Nanoo amwime merekeilu naleme nelaleealee. Te Gotelu bukei lainelu nale metie rame letelee. ");
INSERT INTO kwo_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolosele Paielulu ameele teulefoone, te nanoolu menengoi soume lefoomeli, te menengu mutukwe lefoolali, inalilufwale Jiseselufe lerife amwime teuletelalee. Mwa. Nanookoe kame Jone melei pienuemeleelu ameeleme rame lelee. ");
INSERT INTO kwo_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolose Judanelu alina itei eeteise na alipoterilule pulefolee. Nanoo inalilufwale ragoo glei glietelee. Te Prisila weife nunguli Akwilatu nanoolu nale fiefooneke, te nafooneke ifwane Gotelu amee nafe nafooneke, tetoo amwi yefee lerife. ");
INSERT INTO kwo_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Te Apolose Akaia provinseile warife lelali, Efesusefu inalilufwa Jisesele menengoi ifelalanelu, Apolosele menengu wolilu nale amwime fatiefoone. Te na fatiefooneke, Akaiafu disaipelele lefoo piletene, tetoo Apolosele neunerife natene. Te Apolose Akaiai sekaleleeke, tetoo Gotelu keemakeefi Jisesele menengoi ifelalanelu inalilufwale metie aikopi letemelee. ");
INSERT INTO kwo_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Eetei Apolose inalilufwalu oofi tebiri na lemeli fune na glie glie atemelee Judanelu yewilu prelu nale bibinafwatelalee. Nanoo Gotelu bukefu nale alipotelali tetoo amwime rame leforife natelee, Kraise, Gote nali inalilufwa eetei paie naporife namunefoleelu lufwa nali Jisese. ");
INSERT INTO kwo_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Te eketu Apolose ame Korineime lalali, tetoo Pole afuneme lapruferinelu wokoome, wokoo wokoo leteriemeleeke, te fimelufe Efesusei sekalelee. Te ekeise disaipele telule fetateleeke, ");
INSERT INTO kwo_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","te fietelee, “Nembue oone Jisesele menengoi ifelalamolu, tetoo nembue Wolilu Fifri seenalemolee pe?” Te fune nafoone, “Mwa. Mene Wolilu Fifri lalaleelu nale glei finei.” ");
INSERT INTO kwo_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Te Pole natelee, “Oonane glelu pienuemori lemoone?” Te fune nafoone, “Mene Jone nali melei pienuemeleelu ameele lene.” ");
INSERT INTO kwo_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Te Pole nelee, “Bebriefe Jone inalilufwale melei pienuemeli, te natelee, ‘Oone oonanoo fwagilu ameele mufeletemoke, tetoo oonane melei pienuemobi. Tetoo oone ekeni lufwa menanoo mwi rilaleelule menengoi ifelalabu.’ Ute Jone neleelu lufwa eetete Jisese nafoone.” ");
INSERT INTO kwo_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tupane eetegeni nale finelufe, tetoo Paielu Jiseselu bilutu melei pienune. ");
INSERT INTO kwo_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Te Pole ameele ipoe mwai fatietelali, tetoo Wolilu Fifri seenaleteleeke, te bofoo bofoo natu napoofwane, te nanookoe Gote fetou neleelu nale alipoolane. ");
INSERT INTO kwo_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Te tupane lufwalu ameelu tialootu tialootu lelee. ");
INSERT INTO kwo_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Te Pole Judanelu alina iteile wari ameli, tetoo na ifenatelali nanoolu menengule atukwe faletelee Gotelu amei lalarilu nafe glei ragoo glietelee. Eetegeni ameele eese letewalali wosi mwangife lefolee. ");
INSERT INTO kwo_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mwa. Telu mwate mwate lelanelu Jisesele menengoi ifelalarife ulabee nene. Te mei inalilufwalu oofi Jisesele Niferilu Ameele eeneri nafoone. Tefe Pole mare Jisesele menengoi ifelalanelu inalilufwa Judanelu alina iteile boe glei wanei. Te Pole te krie te krie Tiranuselu ramelu fetou fetou iteile waleeke na ifenatelaleealee. ");
INSERT INTO kwo_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Te teime wokoofe lemeli yare are lefolee. Tefe Judafu panetu Grikefu panetu mareteku Esia provinsei lafwalanelu Paielulu nale fifwafoolane. ");
INSERT INTO kwo_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Gote Polelu amei fime oo tefoo yesoule brege brege atemelee. ");
INSERT INTO kwo_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Inalilufwa leeloo mopu mopuelule peeneneke Polelu rei geune geune ifateneke, te ree tefoo inalilufwale luaterife tewapooneke, te kokou kokou ree woli lepotene, te naifofu ifelatelanelu mei grialetenane. ");
INSERT INTO kwo_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Judafu lufwa telu naifofule grialeterife natene. Telu Paielu Jiseselu bilule suleforife rufoeneke, tetoo inalilufwalufu naifofu grialeterife, te nenane, “Eetegeni Jiseselu bilutu, Pole nalilu nale alipoolaleealeelu, mene namoolaie oone ekeni lufwale grialemoke, wabu.” ");
INSERT INTO kwo_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Te Judafu Gotelu prise yefeelu bofoo, Skeva nafoone, nanoolu ari kapore tialoo mwamole leleelu, nanoo naifofule eese nafoone. ");
INSERT INTO kwo_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mwa. Naifofu fune natelee, “Mene Jiseseleme rame lefwie, te Polele rame lefwie lie, tefe ta ooneboe ine pane?” ");
INSERT INTO kwo_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Te eetegeni lufwalufu naifofu lafoolaleelu, reti prunaleteleeke bubuapoolali metie teie teie atelee. Tefe leeloo preme te reele mei teieteleefe eetegeni itele grialeneke, brunalene. ");
INSERT INTO kwo_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Judatu Griketu Efesusei lalanelu eetegeni nale finelufe, tetoo maretekume metie wofri lelane, tefe nanoolu menengu eese letene, Jisese nanoo Paielu. ");
INSERT INTO kwo_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Inalilufwa motukwe Jisesele wolu menengoi ifelalanelu rineke te nembue angime asulu ameele nali bebriefe amenelule inalilufwalu oofi pootepoofwane. ");
INSERT INTO kwo_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Te inalilufwa motukwe asulu amee amenelu nale bukei piletenelule lukuleteneke, te inalilufwalu oofi tupwaneke, ifi isokwi bri lepoone. Eetegeni bukele peenemenelu bwaleele namunetenelu mareteku 50,000 silva lelee. ");
INSERT INTO kwo_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Eese lenelufe, Paielulu na inalilufwale amee amee soulu letelali, tetoo nanoolu oofulilule kaisekli ifeletemelee. Tetoo nanoo teme teme wari afwalanei nale alipoofwatelane. ");
INSERT INTO kwo_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ekeni wokoo Efesusei Gotelu amee amee wolu kaisekli lelaleefe, eetegeni yesou mareteku wolu lenelu mwi, tetoo Wolilu Fifri Polele seenalefoolaleefe, tefe eese nelee, provinse are Masedoniame, Akaiame afwaleeke, te sabei Jerusalemeile wabe. Te nelee, “Mene ekeni wokoole fetaieke, tetoo sabei mene Romele ame wofetarife lelaie.” ");
INSERT INTO kwo_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Te nalife aikopi lefoolananelu lufwa are, Timotitu weife Erastusetu, Masedoniaile nambulerife nateleeke, tetoo Pole Esia provinsei oolamelee. ");
INSERT INTO kwo_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Te ekeni krietu lufwa telu Jisesele Niferilu Ameefe oorerei lefoolanei, te fame lelanane. ");
INSERT INTO kwo_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Te Demitriuse ekeni famele ifefuraleleelu. Ekeni lufwa gote Artemisele amee amee lefoolananelu ite yemelarilule silvatu tukwee tukweeme letelaleealee, tetoo nalilu amee amee letelanelu lufwa mei bwalee selilu eetei peenelane. ");
INSERT INTO kwo_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Te Demitriuse ekepane lufwale tukwe fime bofoo yesoule amee amee letelananelu lufwale, maretekume luku ifeleteleeke, tetoo natelee, “Lufwa, oone wolu rame lemo, mena eetegeni amee amee lelanelufime tetoo bwalee eetei soume peenenane. ");
INSERT INTO kwo_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Oona wolu fimoke fetamolu, glei Efesuseime lelee, mwa. Nanookoe metie Esia provinseime leleeke pookanalerife lelalee. Pole inalilufwale motukwememe iretelaleefe, te natelee, mena ameetu atelananelu gote, eetete glei gote, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Polelu na nembue menanoo amee amee bilule kose nembuari letebe. Eete mei nanoolu na nembue inali soulu gote Artemiselu itele inalilufwalu menengufu kose mwa letebe. Ame inalilufwa Esiame lafwalanelutu, eetegeni inengufu inalilufwatume metie eetegeni inali soulu gote Artemisele reeyemee afoomene. Kose Polelu na inali soulu gote Artemiselu bilule teiefobe.” ");
INSERT INTO kwo_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tefe ekepane lufwa eetegeni nale fineke, te maretekume metie fame menengu feti letelanelufe, tefe ambureri tuku naleneke, te nene, “Artemise Efesusefu, nanoo soulu inalife leleeke lalaleelu.” ");
INSERT INTO kwo_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tefe ekeni wokei ambureri tukune tukune alanei selime letelalee. Te inalilufwa mareteku weelutu tekaleleeke, lukulenanelu tekoile pipinapoofwanei, Gaiusele weife Aristarkusele tukwe bebeneneke ifwatene. Nanoo weife Masedoniafu Polelu moane, nali mare wokoo wokoo ifeletelaleelu. ");
INSERT INTO kwo_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pole inalilufwalume warife lelali, mwa, disaipele ble nafoone. ");
INSERT INTO kwo_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Te Esia provinsefu yefee yefeelu lufwa telu Polelu moane, te lufwa bofoole nafooneke walee Polele na bofoo naforife, nanoo kose lukulelanelu tekoile waleeke wofetatebe mani. ");
INSERT INTO kwo_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lukulenelu inalilufwalu menengu teme teme atene. Te telu bofoo nafe upe upe alanei, te telu mei bofoo nafe upe upe alane. Te inalilufwa motukwe lukulenelu yewilufe glei rame lepolenei, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Judane Aleksanderele noopoo nafooneke ootari porite wotemeteleefe, te lufwa telu menengu eese lene, nali pai yesou yewilu leleelu? Te Aleksandere inalilufwalu nale fune mei na glieterife ange amee natu pepe lerife natelee. ");
INSERT INTO kwo_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mwa. Nanookoe nanoole rawie lufwa pai nene, boe fetaneke te rame lefoone Aleksandere Juda lufwa. Te mareteku unetewaneke te ragoo mwaime upe upe afwanei eese nafoone, “Artemise Efesusefu, nanoo soulu inalife leleeke lalaleelu.” Mwa, sameme upe upe afwalaneime lie oolu are letelee. ");
INSERT INTO kwo_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Efesuse wokei nale piletelaleealeelu lufwa inalilufwale pepelerife nateleeke, te natelee, “Oone Efesusefu inalilufwa bie filabu, Efesusefu inali soulu gote Artemiselu itele tukwe, efenefu ti yeferaleleelule ifelatelane, eetele inalilufwa maretekume wolu rame lene? ");
INSERT INTO kwo_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tefe lufwa bofoo nale glei ramelie nebe, tefe oone kame pepe lelabu. Oone yesou bofoo lerife kose menengu yefoo yefootu preme. ");
INSERT INTO kwo_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Oone eetegeni lufwale are iferietemolu, mwa, weife glei mena amee amee afoolananelu gotelu itefu yesoule tukuli letene. Tetoo menanoo inali soulu gotele mei glei eeneri nafoonei. ");
INSERT INTO kwo_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demitriuse mare amee amee alanelu lufwatu, lufwa bofoole glelu nale sere lerife, eetete nale sere lerife lelanelu lietu, eetei na nelanei fipwatelananelu lufwa fietelabile. ");
INSERT INTO kwo_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Te oona na telule tapoolamoi, tete oone sere leri tekoi sere letebu, sere leri lietumeme. ");
INSERT INTO kwo_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tefe fiebu. Romefu yefee yefeelu lufwa eetegeni yesou nembue eete lelanelu nale finei, eetete mena nanoolu nafi yenalepobile. Te nanoo lukulelanei na unalemenelu nafe menafe finei, mena gle nale natebile? Eetegeni amee mena lenelukoe mwa, yewilu preme lelee. ");
INSERT INTO kwo_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Te nale piletelaleealeelu lufwa wolu nateleeke, te wawabu natelee.” ");
INSERT INTO kwo_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Te ekeni ambureri tukune tukune alanelu wolu penalenei, tetoo Pole disaipelele luku ifeleterife nafwatelee. Te Jisesele marekulitu nifelarife menengu faneteleeke, te kapoonefooneke, tetoo Masedonia provinseile walee. ");
INSERT INTO kwo_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Te ekeni provinsei lafwanelu wokoome, wokoo wokoo letewalali, Jisesele marekulitu nifelarilu menengule fanetemeleeke, tetoo Grikei woseka lelee. ");
INSERT INTO kwo_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Te nanoo teime lamelime wosi mwangife leleeke, te Siria provinseile brai soulufi warife leleelu, mwa, Judane telu Polele teiefooneke, tafilarilu nale fieleefe, tefe nanoo teime lunaleleeke boe Masedoniaile walee. ");
INSERT INTO kwo_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Beriafu lufwa bilu Sopatere, Piruselu lefoo, nanoo Poletu wane. Te lufwa bofoo mei, Tesalonaikafu Aristarkuse weife Sekundusetu, Derbefu Gaiuse, Timotitu, Esia provinsefu Tikikuse weife Trofimusetu marememe Pole mare wane. ");
INSERT INTO kwo_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Te ekepane tialoo mwamole lufwa nambuleneke menafe Troase wokei oolemene. ");
INSERT INTO kwo_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tabe Leeloo Foopori Lie wolu leneke, te mene Filipaifu brai soulutu wane. Te mene lemeneke, lie yarilutu Troasei tupanele kuruletene. Tetoo mene mare teime lapolemenei lie tialoo mwamole lepolee. ");
INSERT INTO kwo_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nambulerilu lietu mena Jisesele menengoi ifelalanelu inalilufwa mareteku kakali lerife luku lene. Pole disaipelele nale alipotemeli, sameme na ifenafwatelarime krie keekee letelalee. Kwotue Troasele grialeleeke wari menengu lefoolaleefe. ");
INSERT INTO kwo_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mena eetei lukulelanelu mwafu guei komi i motukwe rinapoolane. ");
INSERT INTO kwo_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Te ari rawielu bilu Yutikuse nafoone, leeloo menee lenelufi lafieleeke lamelee. Tetoo Pole nale same glieri glierime letewalaleefe, tefe Yutikuse metie rofoofe feene feene ameleeke, esulu rofoo futi neleefe, te mwangifelu boole mwafu wokeime yeferaleleefe, tefe telu lufwa boletanelu, mwa, wolu tafilalee. ");
INSERT INTO kwo_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pole tiraleleeke, Yutikuselu ree tupulule rukunaleleeke, te amei beleleeke, natelee, “Oone kose betige lemoke menengu menengu lefoolabule mani, nanookoe ame oofulilu lalalee.” ");
INSERT INTO kwo_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Te Pole boe mwaile peenanelee. Te Paielule menengu lefoolarilu tabele mongue mongue aleeke, te inalilufwale ifefotelee. Pole na ifenafwatelarime leleeke, oo taki naneleeke, te walee. ");
INSERT INTO kwo_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Yutikuse boe oofuli leleefe, tefe Jisesele menengoi ifelalanelu inalilufwalu menengu mutukwe lefooneke, ifwane. ");
INSERT INTO kwo_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Te Pole menafe Asose wokeile nambulerife napolee. Tefe mene brai soulufi peepeeneneke Asoseile wane. Te nanoo kame wokoo afwee riefe nelee. ");
INSERT INTO kwo_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Te Pole fime rieleeke, Asose wokei yefetapoli, te mena mare brai soulufi Mitilini wokeile wane. ");
INSERT INTO kwo_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Te Mitilinifu walanei tetoo bofoo lietu Kiose wokoo tupulule roboi letewafoone. Te boe lie bofootu te waneke Samose wokoo tupulufi iminanepoone. Te ekefu boe lie bofootu te wane Miletuse wokei kuruwolerife. ");
INSERT INTO kwo_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pole eesalu menengu lelee, Efesuse wokoole kame sigli naleneke warife, te nanoo boe Esia provinsei krie soo lerife ulabee nelee. Pole menengu lelee, afeteli Jerusalemei woseka lerife, ameelu bofoo wolu roboi lelaleefe nali Soulu Lie Pentikosele menengu lefoolananelule. ");
INSERT INTO kwo_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mene wokoo Miletusei kuruwoleneke, te Pole Gotelu inalilufwa Efesusei lalanelu yefeelu lufwale na wateleeke, te menanoofile rine. ");
INSERT INTO kwo_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Te kuruwolenelufe, te natelee, “Mene Esia provinsei nembouefe sekalieke oone mare lamenei utetu utetu amee amee eetei lemielule oona menane wolu rame leoomo. ");
INSERT INTO kwo_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nia Paielule amee amee lefoolaiei reeyemeetu, yebutenitu, te glelu glelu oo nembulutu Judane menane natu tekaleoolanei tetoo menanoo menengule teieoonane. ");
INSERT INTO kwo_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tetoo mene glei pritetiei, oonane aikopife glelu na wolilule alipomorife. Mwa. Inalilufwa lukulelananelu tekoi, oonanoo itei mei, mene oonane mareteku fetou ne fetou ne amoomie. Eetegenile oone wolu rame lemo. ");
INSERT INTO kwo_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mene sameme Judale tukwe Grikele tukwe na alipoterife tebiri na lemiei, tetoo nanoo fwagilu ameele mufenueteneke Gotelufile rineke, te menanoo Paielu Jisesele menengoi ifelalabi. ");
INSERT INTO kwo_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Te filabu. Nembue Wolilu Fifri menane seenaleoolaleefe tefe mene Jerusalemeile boe walaie. Gle yesou pai menane wosekaleworife lelaleelule mene eetele glei rame lelaiei, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Eetegenileme wokoo wokoome mene wawaielu Wolilu Fifri nali nale alipowoleealee, mene kalabuse itei mei ame lalafe, te glelu glelu oo nembulu mei ame fetafe. ");
INSERT INTO kwo_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tefe ta, mene glei niafe eesalu menengu liaie, nianoo oofulilu wolilu yesou nieke, te mene glei nianoo oofulilule beletalarife kaisekli lie. Mwa. Mene Paielu Jiseselufu falieluleme eetegeni afweele nifelaie, te amee ameele soonalerife. Eetegeni amee amee eetete na ulu wolilu Gotelu keemakee menafe lepoleelule alipoolaie. ");
INSERT INTO kwo_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Tefe nembue mene wolu rame lie oone bebriefe mene oonanoofi aferilaiei Gotelu ameime lalarilu nafe alipoferiemoolaielu menane boe oo glei fetaworife lelamo, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Tefe nembue mene oonane namoolaie, inalilufwa bofoo fwagilupotu mwa leli, eetete glei menanoo nembulu, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mene Gotelu menengufu nale mareteku alipoofwalaiei, mene glei pritetiei, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Fwai, oonafe amwime regi lelamoi, te Jisesele menengoi ifelalanelu inalilufwale tukwe, eetetie Jiseselu fweelutu nalilufi paie naporilu. Tetoo Wolilu Fifri nali wolu namunemolee Gotelu inalilufwale oofulinetelananelu lufwafe lelee. ");
INSERT INTO kwo_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mene wolu rame lie, mene oonane grialemwieke waiei, lufwa telu ame oonanoofile rineke, fame tefoo klifu atukwe Gotelu inalilufwale teiemobile. ");
INSERT INTO kwo_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Lufwa telu oonanoofu ame disaipelele kose kose natu seree neteriemobile, tetoo nanoolu nale nifeterife menengule irepotebile. ");
INSERT INTO kwo_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Tefe oonafe amwime regi lelabu. Te kose oona mene lemielu amee ameele menengu futi natebule mani, mwa. Eke mene lielu krielu amee amee ifeletewamoolaiei, menanoo ree glei soo alee lewolee, oonane menengu wolilule yebuteni ootu nafwamoolaieime yare mwangife lewolee. ");
INSERT INTO kwo_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nembue mene oonane Gotelu amei tepoinumoolaie, te oone mei mareteku nalilu keemakee nafi lalarife. Eetegeni keemakee na eetete oonane kuli reenelemoolali, te nali nemboue oonane efenefu sasenee yesoule mareteku nifwamoolabe, Gote nali inalilufwale nalife namuneteleelule mareteku nifwatelaleealeelu atukwe. ");
INSERT INTO kwo_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mene bofoo lufwalu leeloofe, silvafe golefe glei menengu runanetiei. Mwa. ");
INSERT INTO kwo_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Oona wolu menane rame lemo, mene nianoo ameime laferilaiei lufwa mare ifelaferietelaielule mei aikopi leterietemie. ");
INSERT INTO kwo_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mene amee ameele mareteku aferietelaielu, mene eesalu ameele fetou namwie, mena suagri lelarilu ameele nifelabile, tetoo inalilufwa nalife aikopi lerilu gigime letelananelule, mena aikopi letelabile. Mena Paielu Jisese neleelu nale menengu lefobile. Nali nelee, ‘Aikopi falerilu amee eetete nemboue, tefe rauefe yesou lemwamofe alarilu amee eetete metie nembouelu amee.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pole eetegeni nale neleeke, te tumoinu krutupooneke, eetepane yefeelu lufwa mare Gotele na woponefoone. ");
INSERT INTO kwo_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Eese leneke, te mareteku ee napooneke, fwafwakee ifalanei kapoonefoone. ");
INSERT INTO kwo_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pole nali tupanele nanoolu oo boe glei fetafobile neleeke, tefe nanoo metie menengu rufofoolane. Te ifwaneke, brai soulufi siwonene. ");
INSERT INTO kwo_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Mene Efesusefu Gotelu inalilufwalu yefeelu lufwale griafaleteneke, te brai soulufi wane. Te brai soulu Kose wokoole ooretetewafoli wane. Bofoo lietu mene Rodese wokoo tupulufile waneke, te boe ekefu, Patara wokoo soulufi kuruwolene. ");
INSERT INTO kwo_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tetoo brai soulu mwi meleele tekalerife Fonisiame warife lelaleelule Patarai fetaneke, te mene ekeni brai soulufi peepeeneneke boe wane. ");
INSERT INTO kwo_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Te walaneime, wokoo tupulu Saiprusele fetane, te luwari porite wanei, te mene Siria provinsele ooretetewafoonei waneke, wokoo soulu Tairei kuruwolene. Ekenifi brai soulufu yesoule peene peene aneke luluane. ");
INSERT INTO kwo_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Te mene Jisesele menengoi ifelalanelule oorafwateneke, fetateneke, te teime mare lameneime krie tialoo mwamole lepolee. Wolilu Fifri Jisesele menengoi ifelalanelule na bofoole Polelufe nateleefe, tefe Jerusalemeile warife ange ble nafoone. ");
INSERT INTO kwo_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Brai soulu boe warife lelali, mene mei warife lelane. Te walanei, ekepane Jisesele menengoi ifelalanelu lufwatu nalilu nariemuane, nalilu ari mare ekeni wokoo soulu ambolufi sioonaporife. Tetoo mwi melee wafenei mene mareteku tumoinu krutupooneke, Gotele na woponefoone. ");
INSERT INTO kwo_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Te mareteku paie paietu fwafwakee apooneke, te mene brai soulufi peepeeneneke, ifwapoli, tetoo ekepane boe nalilu iteile wawane. ");
INSERT INTO kwo_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Te mene Tairele grialeneke, te boe waneke Tolemese soulu wokei kuruwolene. Te ekeise Jisesele menengoi ifelalanelule mare paie paie ifatelaneke, tetoo bofoo lietu mare teime lamene. ");
INSERT INTO kwo_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Te bofoo geni lietu mene grialeneke, te waneke Sisariai kuruwolene. Te Filipelu iteileme waneke mare oolamene, te nanoo na ulu wolilu Jiseselu naleme inalilufwale alipotelaleealeelu lufwa. Aposele nanoole mei seiko seikolu inalile aikopi letelarife namunefoonelu lufwa, nanoolufi tetoo tialoo mwamole lelee. ");
INSERT INTO kwo_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Te nanoo auteli ramulu yerifurutu lelee, lufwa ame glei peenefoonei, te maretekume Gote fetou nateleelu nale alipoolanane. ");
INSERT INTO kwo_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Te mene teime lamenei rofoo soo lene, te Gote fetou nafoleelu nale alipoolaleelu lufwa bofoo, bilu Agabuse nafoone, nanoo Judia distrikefu, Sisariaile tiraferelee. ");
INSERT INTO kwo_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Te Agabuse mene lalanelufileme rieleeke, te Polelu amboore paiemoole faleleeke, tetoo nalilu kuli ameele bulupoleeke, te nelee, “Wolilu Fifri nelee, ‘Eetetie eetegeni ameefe Jerusalemefu Judane nanoo ame amboore paiemoo yarile beleneke kuli amee bulupofooneke, tetoo rawie inalilufwale seinatebile.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Te mene eetegeni na neleelule finelufe, tefe mene eetegeni wokoofu inalilufwa mare Polele ble nafoone, Jerusaleme wokeile warife. ");
INSERT INTO kwo_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mwa. Pole fune na napolee, “Ooneboe glefeme ee napoolamoi menanoo menengule atukwe teieoolamo? Mene niafe wolu sere lie nali kalabuse itei seinetu kuli amee bulupooneke sinawobile nenei nemboue eese lewobi, te nali teieooneke tafilafe nenei mei kame eese lewobi, Paielu Jiseselu bilufe Jerusalemei tafilafe mene niafe wolu sere lie.” ");
INSERT INTO kwo_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mene ange ble nafoone Jerusaleme wokeile warife mwa, tefe mene nafoone, “Paielu nali glelu amee lewobe neli, nanoo kame lebee.” ");
INSERT INTO kwo_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Te bofoo krietu, Jerusalemeile warife mene yesoule sere letene. ");
INSERT INTO kwo_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Te Sisariafu disaipele telu mene mare Nasonelu iteileme wane tetoo tei oolalarife. Nanoo Saiprusefu lufwa, wolumefu disaipele. ");
INSERT INTO kwo_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Te mene Jerusalemei kuruwolelanei, mwa, Jisesele menengoi ifelalanelu inalilufwa paie paie feti ifapooneke, te ifwapoone. ");
INSERT INTO kwo_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Te bofoo lietu Pole mene mare wane, Jemsele wofetarife. Te ekeise Jerusalemefu Gotelu inalilufwalu yefeelu mareteku mei wolu luku leneke lalane. ");
INSERT INTO kwo_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Te Pole paie paie feti ifateleeke, te eke Gote nali mareteku yesoule rawie inalilufwalufi Pole nali amee amee leterietefoleelu nale alipotelee. ");
INSERT INTO kwo_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Te fiefoomeneke nene, marena, Gote nali Paielu, tetoo Polele nafoone, “Ape, oona ramele ekepane Judane wolu Jisesele menengoi ifelalanelu ameelu ka fulu atukwe letewaneke alane. Te maretekume Moseselu Na Kaisekli lalaleelu naleme tekeneime lefoolanei nifelanane. ");
INSERT INTO kwo_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tetoo lufwa telu oonanefe natenane, Pole nalimeme Judane teime ekei rawie inalilufwalufi lalananelule natelaleealee Moseselu Na Kaiseklilufi lalaleelu nale grialerife, te natelaleealee, kose kapore arilu ree leeloole kreenapotelanabile mani, te mei kose bebriefu ameele boe nifetelabile mani natelalee. ");
INSERT INTO kwo_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Menate rame lene, ekepane oone wolu rielulu nale ame fiebile, tetoo mena boe ake lebile? ");
INSERT INTO kwo_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Tefe mene oonane amee amee bofoole lerife naooneke lele. Lufwa yerifurutu Gotele bi nafoonelu menane ifelalane. ");
INSERT INTO kwo_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Oone ekepane lufwale neunateluke, te oona mare Gotelu iteile wamoke, te Moseselu ameeleme nifemoke, tetoo oona mare Gotelu oofi nemboue lebule. Te eetegeni amee lerilu yesoule oonameme bwaleetu yerefurutu lufwale peenetele, tetoo ekepane lufwa ipoe kokwapooneke gege napoone. Oone eese lelu, tetoo lufwa mareteku rame lebile, ekeni na finelu oonane naooneluke glei marena na. Mwa. Nanoo mei rame lebile, oone mei Moseselu Na Kaisekliluleme nifelalualu. ");
INSERT INTO kwo_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mene ekepane rawie inalilufwa Jisesele menengoi ifelalanelule mena nale lofoofi wolu pileneke fanetene. Mena nalife eesalu ameefe amwime regi letelarife natene, kose fori yesoule kose kose gotele luatelanelule tukwe, bole fwee tefoole tukwe, lufwa borei krinaleteneke troonalenelu bolele tukwe, kose foopoolanabile mani, te kose tuwi amee alabile mani natene. ” ");
INSERT INTO kwo_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tefe Pole ekepane lufwa Gotele bi nafoonelule neunateleeke, nalipotu ifwatelee, bofoo krietu Gotelu maretekume melee ropofori ameele lene, tetoo Gotelu oofi nemboue lerife. Te Gotelu ite geenerime wopreielee prisele naterife, glelu kriele namunefolee melee ropoforife ameelu wolu leleelu, tetoo yesou mwamole mwamole teripofooneke nifwarife. ");
INSERT INTO kwo_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Pole tialoo mwamolelu lietu ekeni amee leterieteleeke soonaleterife roboi lelali, te Judane Esia provinsefu rinelu Polele Gotelu ite geeneri menei lalali fetane. Ekepane Judane mareteku inalilufwalu menengule tuteli letenelufe, te mwa, nanoo metie Polele fame na ifeneneke tetoo Polele belefatineke, kekee nene. ");
INSERT INTO kwo_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Te ragoo iteritu nene, “Oone Israelefu lufwa, oone bie menane aikopi lepobu. Eetegeni lufwa nali te wokoo te wokoofu inalilufwale mareteku na natelaleelu menane Judale tukwe, Moseselu Na Kaiseklilule tukwe, te eetegeni Gotelu itele mei oorerei letelaleealee. Nanookoe Grikefule mei Gotelu ite geeneri meneile iferietelee, te Gote nali nalife namunefoleelu tekoole fwagilu reetu rinei, tetoo Gotelu oofi glei nemboue leleealee.” ");
INSERT INTO kwo_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Eetete nanoo wolu Efesusefu Trofimuse weife Poletu Jerusalemei lamenei fetatenelufe, tefe nanoo menengu lene, Pole ekeni lufwale Gotelu iteile wolu pai iferielee nene. ");
INSERT INTO kwo_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Inalilufwa eetegeni nale fineke, tefe Jerusaleme mareteku metie betige lepooneke, te pipi napoofwaneke Polele beleneke, te Gotelu ite geeneri menefu ambolufile glitewane. Esulu geeneri amblenile maretekume kapupoofwane. ");
INSERT INTO kwo_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tupane lufwa Polele teiefooneke, tafilarife lelaleefe, te esulu Romefu kworoofamelu yefeelu fielee Jerusalemefu inalilufwa maretekume metie fame alane. ");
INSERT INTO kwo_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Te ekeni yefeelu lufwa boe telu Romefu kworoofamelu keptenele te telu kworoofame lufwale tukwe neunateleeke tetoo pipinapooferene eke alanelu tekoile. Judafu pane Polele eese bubualanelu, mwa, Romefu kworoofamelu yefeelule nalilu kworoofame lufwale tukwe mare iferietelali fetatenelufe grialene glei boe bubuanei. ");
INSERT INTO kwo_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Te Romefu kworoofamelu yefeelu rieleeke, tetoo Polele amei belelee. Tetoo nalilu kworoofame lufwale nateleeke, Polele seine are leneke bulupofoone. Te Judale ooraforife fietelee, “Eeteboe lufwa ine, te glele lelee?” ");
INSERT INTO kwo_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Te inalilufwa motukwe, bofoo bofoo nafe upe upe afwalanei, kworoofame lufwa yefeelu ekeni na yewilule fierilu mwa, tefe nalilu kworoofame lufwale nateleeke, nali tei lalananelu tekoile ifwane. ");
INSERT INTO kwo_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pole ekeni ite tiklifi wolelali, tetoo kworoofame lufwa inalilufwa metie tekenei lefoolanelufe Polele teiefooneke tafilarife eese fetatenelufe, metie afetelime boletaneke ifepeenane. ");
INSERT INTO kwo_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Te inalilufwa weelutu tekaleleeke, fime nifetewatelanei upe upe afwanei eese napoofwane, “Kame teiefomoke tafilabee!” ");
INSERT INTO kwo_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ekepane kworoofame lufwa Polele nali lalananelu tekoile ifepreierife lelanei, tetoo Pole Romefu kworoofamelu yefeelule Grike natu fiefolee, “Tefe, mene nemboue pe oonane bofoo nafe nawofe?” Te fune nafolee, “Ei, oonekoe Grike nale rame lelu pai? ");
INSERT INTO kwo_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mwa. Menekoe oonane eesalu menengu lewie, oonekoe Isipe pai nawie, nali wolume Rome gavmanele fame tewafoleelu lufwa pai nawie. Eetetie nali pai 4,000 lufwale kositu famefe alananelule neunateleeke, te lufwa prelu inengoile ifwatelulu.” ");
INSERT INTO kwo_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Te Pole fune nafolee, “Eie, menekoe fime, Juda bofoo. Menanoo fwi wokoo Tarsuse, Silisia provinsei lalalee. Menekoe ekeni soulu wokoofu retilu lufwa. Nemboue pe, oone bie menane ree faluele mene eke lukulelanelu inalilufwale na natefe?” ");
INSERT INTO kwo_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Te nanoo ekenife i nafoleeke, te Pole tiklifi temelali, tetoo inalilufwale amee natu pepelerife natelee. Te futenitu kweenalenelufe tetoo Hibru natu nafwatelee, ");
INSERT INTO kwo_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Apane, aiane, menane bie fioolabu. Nembue mene nianoofe oonane namoolaie mene fwagilu amee bofoole glei liei, mwa.” ");
INSERT INTO kwo_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pole Hibru natu natelaleefe tefe kame pepeme lelanei fiefoolane. Pole boe na same nafwalee, ");
INSERT INTO kwo_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Menete Judafu lufwa, menane mie Silisia provinsei lalaleelu wokoo Tarsusei lupolewoleeke, te Jerusalemeime mene seli lie. Mene Gamalielelu amei lamiei, nanoo fetalilu na kaiseklilule amwime fetou fetou nawoleelu lufwa. Mene metie Gotelu ameele kaisekli ifeleteriefwie, eke nembue oone alamolu atukwe. ");
INSERT INTO kwo_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mene mei Jiseselu Ameele Nifelanelu inalilufwale teietieke, tetoo troonalerife, ameele seinetu bulupotieke te kalabuse itei sine sine atemie. ");
INSERT INTO kwo_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Gotelu prise paie tefoo, te Israelefu paie tefoo pane mareteku mare mene aferielu ameele wolu rame letenelule eetegenife fietemoi ame oonane namobile. Te tupane lofoo pilu letenelule mene Damaskusei lalanelu weeluanele tewapotie, eke Jiseselu Ameele Nifelanelu inalilufwale bebenieke ifwatieke Jerusalemei kalabuse itei sinaterife tefe waie. Tetoo ekepane paielu lufwalu amei teponuetieke te nali glelu amee letebile nenei kame eese letebi. ");
INSERT INTO kwo_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Tetoo mene Damaskuse wokoole wolu roboi letewafwiei, lie babikeke temelali, tetoo, efenefu takilu menane feenalewolee. ");
INSERT INTO kwo_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Tefe mene wokei yeferalieke lalaiei te bofoo lufwalu ragoole naoolali filaie, ‘Sole, Sole, ooneboe menane glefeme teiemelu?’ ");
INSERT INTO kwo_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Te mene fiefwie, ‘Oone ine? Paielu pe?’ Te nanoo fune nawolee, ‘Menete Nasaretefu Jisese, oone menane teiemelu.’ ");
INSERT INTO kwo_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Lufwa mare walanelu kame efenefu feenaleleelule fetane, te lufwa bofoo menane na nawoleelu ragoole glei rame lefoonei, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Te mene nafwie, ‘Paielu mene nembue ake lefe?’ Tetoo nanoo fune nawolee, ‘Oone furaleluke Damaskuse wokeile wa. Te ekenifi lufwa bofoo ame naworife lelalee, mene oonane wolu namunewie menanoo amee ameele letewarife.’ ");
INSERT INTO kwo_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Eetegeni feenalewoleefe mwa, yesou bofoole glei fetaiei. Tefe tupane menane amei beleooneke Damaskuseile ifwaoone. ");
INSERT INTO kwo_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Te ekenifi lufwa bofoo lalalee nanoolu bilu Ananaiase. Nanoo metie Gotele reeyemee lefoolali, tetoo na kaiseklilule mei amwime nifelaleealee, te Judane mareteku ekei lalanelu eese nafoonane, nanoo lie platefu lufwa. ");
INSERT INTO kwo_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nanoo menanoofile rieleeke yetemeleeke, te nawolee, ‘Ape Sole, oonanoo oo wolu nemboue leoone.’ Eese nawoleefe esulu mene nalife fetaie. ");
INSERT INTO kwo_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Te nawolee, ‘Menanoo fetalianelu Gote nali oonane wolu namunewolee, oone nalifile rame lefolu, tetoo oone nalilu menenguleme amwime nifefoolarife, tetoo Lie Platefu Lufwale fetale, te oone nalilu ragootu na nelaleelule fiefole. ");
INSERT INTO kwo_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Oone nalilu nale alipotelarilu lufwafe lerife lelalu tetoo inalilufwale mareteku oonanoo ootu fetaluke, fielulule alipotelale. ");
INSERT INTO kwo_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tefe nembue oone kose kai lele mani. Te furaleluke, melei pielewobi tetoo Lie Platefu Lufwale nafoluke oonanoo nembulule wogrinawobe.’ ");
INSERT INTO kwo_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Mene wolu Jerusalemei boe sekalieke, te Gotelu ite geeneri menei na woponefoomiei, tetoo ootu keme Paielule fetaie, ");
INSERT INTO kwo_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","nanoo menane nawolee, ‘Oone afeteli Jerusalemele grialeluke wa, oone menanoo nale ekeni wokei alipotelalu nanoo glei fieworife lelane, mwa.’ ");
INSERT INTO kwo_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Te mene fune nafwie, ‘Paielu, Jerusalemei eetei lalanelu nali wolu rame lene mene nalilu alina iteme ite ite letewatelaiei oonane menengoi ifelaoolanelule bubuapoofwalaie, tetoo kalabuse itei sine sine afwatelaie. ");
INSERT INTO kwo_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Te Stivenele teiefooneke tafilalee, nanoo oonanoo nale alipoolaleealeelu lufwa, ekenitu nia roboi tememiei, tupane eesalu amee lefoonelu menanoo oofi nemboue lewolee. Mene tupane lufwa luanelu bebeti leeloole ifelatemie, nanoo Stivenele teiefoomenei.’ ");
INSERT INTO kwo_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Te Paielu niane nawolee, ‘Oone tewa, mene ame oonane nawofe rawie inalilufwalufile wokoo mokeneile feti warife lelalu.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pole rawie panefe neleefe tefe Judane eetegeni naleme boe fierife ulabee nene. Tefe mareteku unaleneke ragoo mwai nene, “Eke teiefoomoke tafilabee kose eetegeni inengoi oofuli lelabe mani.” ");
INSERT INTO kwo_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nanoo metie fame menengufe unaleneke, bebeti leeloole liganufwaneke wogrinafwanelu esulu inengu asalule ameetu amborepoofwaneke mwame bofine bofine afwatenei, ");
INSERT INTO kwo_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","te Romefu kworoofamelu yefeelu noopoo nafoleeke, te kworoofame lufwa Polele beleneke, nali lalananelu tekoile ifwane. Te nalilu kworoofame lufwale natelee, Polele bubuaneke, tetoo fieforife glelu yewilufe tefe inalilufwa fame teriefoone. ");
INSERT INTO kwo_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tefe amee tewapofooneke, kafi fupwafooneke, te Pole Romefu kworoofamelu keptene roboi temefoolaleelule fiefolee, “Eete nemboue pe lelee, Rome retilu lufwale eesalu ameele letelabile? Romefu na kaisekli eese pe nelee? Lufwa bofoo ame na sere leri preme lelali bubuanei eete wolilu pe?” ");
INSERT INTO kwo_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Te Romefu kworoofamelu keptene eetegeni nale fieleefe te waleeke nalilu yefeelu lufwale oonafolee, “Oone glelu ameele lele? Nanookoe Rome retilu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Te Romefu kworoofamelu yefeelu rieleeke Polele fetaleeke nafolee, “Menane nawo, marena pe oone Rome retilu lufwa pe?” Te fune nafolee, “We, marena.” ");
INSERT INTO kwo_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Te Romefu kworoofamelu yefeelu nalilufe Polele nafolee, “Mene bwalee selilu fetile fanetie Rome retilu lufwafe lerife.” Pole fune nafolee, “Mene mwa. Menanoo mie aietu lupoleoonelu nanoo weife Rome retilu. Tete mene mei Rome retilu lufwafe lie.” ");
INSERT INTO kwo_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kworoofame lufwa Polele bubuarife lenelu, mwa, eetegeni nale finelufe esulu amee tepolene. Te Romefu kworoofamelu yefeelu mei ree pritefolee. Nali kworoofame panele nateleeke, Pole, nali Rome retilu lufwa, seinetu funelufe nelee. ");
INSERT INTO kwo_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Romefu kworoofamelu yefeelu Judanelu menengule amwime rame leterife glelu amee nembulule Pole leleelufe, tefe bofoo lietu eese lefoone neleeke, Polelu seinele tupwapofolee. Te Gotelu prise yefeelu, Israelefu paie tefoo panele na wawatelee, ririaneke mareteku lukulelanelufi Polele ifetitiri ifeneleeke ootari porite siyenelee. ");
INSERT INTO kwo_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pole Israelefu paie tefoo panele oo teime letelali te natelee, “Apane, mene wari amiei Gotelu oofi leterilaielu amee menanoo menengu metie mutukwe lewolee. Eetegenitu, mene amee bofoo nembulu lerilu menengu glei lewoli, mwa.” ");
INSERT INTO kwo_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Gotelu prise paie tefoo Ananaiase, Pole neleelu nale fieleefe, te nanoolu bwagei temepoolanelu lufwale natelee ragoi buanateforife. ");
INSERT INTO kwo_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tetoo Pole Ananaiasele nafolee, “Gote oonane ame funawobe, oone ite goli footenelu labo bulenelu keme leluke, sekuralule muli letelalu, tetoo lufwa glei fetatebile. Oone kame Moseselu Na Kaiseklile nifelalu menane pai na fipwaleoolarife lalalu. Tefe oona eetegeni na kaiseklile futeni lefoolalulu menane funaworife natelu.” ");
INSERT INTO kwo_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Lufwa Polelu bwagei temepoolanelu nafoone, “Ie, ooneboe glefeme Gotelu prise paie tefoole eeneri nafolu?” ");
INSERT INTO kwo_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Te Pole nelee, “Apane, mene nanoole glei rame lefwiei, nanoo Gotelu prise paie tefoo lufwafe leleelule. Moseselu Na Kaisekli Gotelu bukei pileleelu eese nelee, ‘Oone kose oonane nambulemoolaleelu lufwa bofoole eeneri nafoomwabule mani.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Te Pole wolu rame letelee, lukulelanelu lufwa telu Sadyusifule te telu Farisifule, tefe Israelefu paie tefoo panele ragoo mwai natelalee, “Menanoo apane, mene Farisifu, te mei mene Farisilu weelufu ari. Mene eesalu menengoi temelaie, troonalelanelu boe ame fufuru nebile, tefe menane eetegeni yewilufe nembue beleoone.” ");
INSERT INTO kwo_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Farisitu Sadyusitu mare lukulenelu Pole eetegeni nale neleefe, esulu kukusi aneke te menengu teme teme apotene. ");
INSERT INTO kwo_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadyusi eesalu menengu lene, troonalelanelu inalilufwa glei boe fufuru neneke oofuli lebile, Gotelu ensele mei mwa, naifofu mei mwa. Te Farisiane nanoo glei eesalu menengutu alane. ");
INSERT INTO kwo_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tefe unalelanelufe, tetoo telu Farisifu na kaisekli ramelu lufwa na ifenene, “Mene ekeni lufwalu amee nembulu bofoo leleelule glei fetafoonei, mwa. Naifofu bofoo pe, ensele bofoo pe nali nafoomelee,” eese natene. ");
INSERT INTO kwo_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Na ifenenelu mare wolu fametu kurulelanelule fetateleefe, tefe Romefu kworoofamelu yefeelu wofri lelee, kose tupane Polele woglie yeglie ifanei kose tafilabe nelee. Tefe kworoofame lufwale nateleeke, afetelime titirineneke te waneke, Polele belelanelu lufwale buruanetewateneke te neuneneke, kworoofame lufwalu lalananelu tekoile siwonerife ifwane. ");
INSERT INTO kwo_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Te kriei Paielu Polelu bwagei temelali te nafolee, “Oone kose ree pritetele mani, oone Jerusalemei nianoo nale alipoofwate, oone Romei mei eesalu ameeleme letewa.” ");
INSERT INTO kwo_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Te kwotue kriei Judane lukuleneke Polele tafilarife na faleneke, nalife bi nene, fori yesoule, meleele tukwe ambopooneke lalanei bie Polele teiefooneke tafilabee. ");
INSERT INTO kwo_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ekenife bi nenelu lufwalu ameelu metie 40 le boorelefolee. ");
INSERT INTO kwo_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Tetoo Gotelu prise yefeelule tukwe Judafu yefeelu lufwale tukwe waneke natene, “Mene na faleneke metie bi nene, kakali preme lalabile, bie Pole tafilaleekeme, tetoo boe kakali lebile. ");
INSERT INTO kwo_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Tefe nembue oone, Israelefu paie tefoo pane mare Romefu kworoofamelu yefeelule na wafobee, Polele oonanoofile ifetiraleleeke, tetoo oone Polelu nale boe amwi fieforife. Eesalu yeunatu nafobu. Mena kame lalanei oolefoolane, nanoo oonane sekalemori preme leli, tetoo mena ame teiefooneke tafilabe. ” ");
INSERT INTO kwo_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mwa. Neetee ekeni amee leforife lelanelu nale fieleefe, tefe kworoofame lufwalu tekoile waleeke nerie Polele oonafolee. ");
INSERT INTO kwo_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tetoo Pole Romefu kworoofamelu keptene bofoole rierife nafoleeke te rielee, “Eetegeni ari rawielule neuneluke Romefu kworoofamelu yefeelufile ifwa, nanoo bofoo yesou nafe naforife lelalee.” ");
INSERT INTO kwo_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Tefe nanoo ari rawielule Romefu kworoofamelu yefeelufile ifwaleeke, te nafolee, “Kalabuse itefu lufwa Pole menane fieri nawoleeke, eetegeni ari rawielule oonanoofile iferie oonane bofoo nafe naworife.” ");
INSERT INTO kwo_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Te Romefu kworoofamelu yefeelu ari rawielule amei beleleeke, te nalime ite babrilume ifwaleeke, nafolee, “Sei. Oone glelu nafe menane naworife rielu?” ");
INSERT INTO kwo_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Te nanoo fune nafolee, “Judane telu wolu na faleneke, te oonane fieworife tetoo kwotue oone Polele Israelefu paie tefoo panelufile ifwarife, Polelu nale boe amwi fieforife. Nanoo oonane ame eetegeni yeunatu naworife lelane. ");
INSERT INTO kwo_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Te lufwa noopoo naoolanei oone kose nanoolu amei tepoletele mani, lufwalu ameelu metie wolu 40 le boorelefoleeke Polele oolefoolane. Te tupane wolu bi nene, fori yesoule, meleele tukwe ambopooneke lalanei bie Pole tafilabee. Tefe nembue nanoo oonane i naterife ooleoolane.” ");
INSERT INTO kwo_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Te Romefu kworoofamelu yefeelu ari rawielule kaisekli natu nafolee, “Oone menane nembue eete nawolulu nale lufwa bofoole kose nafole mani,” te nafoolaleeke, wa nafolee. ");
INSERT INTO kwo_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Te nali nalilu Romefu kworoofamelu keptenele are fieri nateleeke, te natelee, “Oone kworoofame lufwale 200 lemo, kworoofame lufwa hosetu alananelu lufwale 70 lemo, te wopitu aleri alananelu kworoofame lufwale 200 lemo mumusi letemo lebu. Eese lemoke, tetoo nembue feiferi krietu lie oolu tialoo mwangifelufi lelali Sisariaile ifwabu. ");
INSERT INTO kwo_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Polelu hosele mei sere letefomoke tetoo ifwamoke Gavana Felikselufi amwi siwonebu.” ");
INSERT INTO kwo_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Te ekeni kworoofamelu yefeelu lofoo bofoole eesalu pileri lelee, ");
INSERT INTO kwo_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mene Klodius Lisiase, mene eetegeni lofoo pilu Paie Tefoo Gavana Felikse oonane lewie, ye kelika. ");
INSERT INTO kwo_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Judane eetegeni lufwale beleneke teiefooneke wolu tafilarife leleelu. Mwa, nanoo mene Rome retilu lufwa neleelule fiefwielufe tefe mene nianoo kworoofame lufwale natieke mare nanoolu amefule neunene. ");
INSERT INTO kwo_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mene eetegeni lufwale na woponefoonelu yewilule rame lefe nieke, tefe nanoole Israelefu paie tefoo panelufi sinatie. ");
INSERT INTO kwo_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mene fietielufe eese naoone, nalilu na kaisekli telule menengu letelanei, tefe eetegeni na pume lefoone. Ekeni na telule glei amwi nifetelaleealee nene. Mwa. Nanoo bofoo yesou glei leli, tefe teiefooneke tafilarife, kalabuse itei sinerife lenelu mei, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Te nembue nia wolu fie nanoo eetegeni lufwale teiefooneke tafilarife na angime falefoomenelufe, esulu mene kworoofame lufwale natieke oonanoofile iferieoone. Te mene nanoole na pume lefoomenelu lufwale mei natieke mare rine, oonanoo ootari porite temepooneke nali eke fanenelu ritilu nale oonane alipoworife, oone tetoo ekeni yewilule rame lele. Na tetie mai.” ");
INSERT INTO kwo_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Te kworoofame lufwa eetegeni nale nifeneke Polele neuneneke krieimeme sinafwane wokoo soulu Antipatriseile. ");
INSERT INTO kwo_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Te bofoo lietu kworoofame lufwa 400 teime sineneke boe Jerusalemeile nalilu tekoile walanei, te kworoofame lufwa hosetu alananelu Polele Sisariaile sinafwane. ");
INSERT INTO kwo_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Te Sisariai kuruwoleneke, te lofoo pilule gavanale faneneke, esulu Polele mei nanoolu ootari porite sinene. ");
INSERT INTO kwo_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gavana ekeni lofoo pilule fetaleeke, te Polele fiefolee, “Ooneboe gle provinsefu?” Te Pole fune nafolee, “Mene Silisiafu.” ");
INSERT INTO kwo_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Eesalu nale fieleefe, tefe nanoo nafolee, “Mene oonanoo nale fieworife, bie oonane na pume lemoonelu lufwa nanoo kurulenei, tetoo oonanoo nale fiefe.” Te kworoofame lufwale gavmane ite wolumefu Herote tueleelufi Polele regi lefoolarife natelee. ");
INSERT INTO kwo_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Te krie wolu yarilutu leleeke, Gotelu prise paie tefoo lufwa Ananaiase, Judafu yefeelu lufwa telule tukwe, Romelu na kaiseklilu ramelu tefoo lufwa bofoo Tertulusele neunateleeke, mare Sisaria wokoo soulufile titiri ifenatelee. Te gle nale Pole neleefe gavanalu nafi yenalerife alipofoone. ");
INSERT INTO kwo_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Te gavana fieri nafoleeke, te rieleeke, tetoo Tertuluse Polele na pume naforife na pulelee, “Paielu lufwa Felikse, oonanoo lietu oone menane amwime ifelaferilalu tetoo nembouelu lafierileme leterilane te mwa, fame amee mei glei lemenei. Tefe oonanoo nembouelu menengu oone eetetie aikopi leterietelalu menanoo poritefule, te bebriefe yesou amwi laieri preme lenelule boe oona amwi sere letewatelu. ");
INSERT INTO kwo_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mene oone eetegeni yesou letewatelulule fetateneke, menanoo menengu metie paie paie aoolane. ");
INSERT INTO kwo_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Tefe mene kose oonane natu gliewiei oone futeni sookootu lele. Oone nemboue pe menane keemakee lewoluke, menanoo na tukweelubolufe fieworife? ");
INSERT INTO kwo_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Mene eetegeni lufwale fetalanelu nanoo futeni futeni alaleelu lufwa, nanoo Judanelufi eetegeni inengu lemeleelu atukweme lukulelanei mareteku na unetewalanane. Nanoo fime amee tefoo paielu lufwafe letelee, eetetie menane grialepoonelu panele, tetoo nanoole Nasaretefu pane natene. ");
INSERT INTO kwo_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Te mei Gotelu itele fwagilu ameele tei leterife lelaleefe, tefe mena belene. Tefe oonameme eetegeni lufwale nemboue fiefo glelu ameele mareteku leteleelule nalilu ragootu nawobee, mena nalife eetegeni ameefe na pume lefoone.” ");
INSERT INTO kwo_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Te Judane mei Tertuluse Polele na pume neleelu nafime teime temepooneke, te maretekume nene eetegeni na marena. ");
INSERT INTO kwo_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Te gavana Polele na nerife ipoe kie nafoleefe, tefe Pole nafolee, “Mene wolu oonane rame lewie oone eetei lafwanelu wokoofu inalilufwale glelu amee lenei, tetoo na fipwaletelalualulu lufwa te yare glei mwamole leoolali, tefe menekoe kame ragoo tafilutu naworife lelaie. ");
INSERT INTO kwo_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Bie ekenife oona fifieri nafwatelu, ame naworife lelane, lie wolu tialootu tialootu lelee, tetoo Jerusalemeile Gotele reeyemee leforife waie. ");
INSERT INTO kwo_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Menane na pume leoolanelu mene inalilufwa bofoole fame na ifenelaielule, te mene inalilufwale mare luku ifeletieke menengule tuteli letielule, niane glei fetaoonei, mwa, Gotelu ite geeneri menei, Judanelu alina itei, te wokoo babifi bofootu, eesalu ameelule lelaiei glei fetaoonei, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Tefe ekeni na nianoofe eke ifenaoonelu yewilule nanoo glei oonane amwime fetou nawobile, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mene kame oonane pootalewie, Jisesele Niferilu Ameele, tupane fime amee tefoo natemene. Mwa. Mene ekeni ameefe, tefe menanoo fetalianelu Goteleme reeyemee lefoolaiaie, te menanoo menengoi mei Moseselu Na Kaiseklilule, te Gotelu Ragoofu Nale Alipoolanelu Lufwalu bukei pilenelule ifelalaie. ");
INSERT INTO kwo_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mene kame Goteleme oolefoolaie, nalime lie platefu inalilufwale tukwe fwagilu amee tefoole tukwe wolume troonalenelu boe fufuru nerife lelane. Te tupane mei nene. ");
INSERT INTO kwo_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tefe te krie te krie niafe amwime lelaie tetoo Gotelu oofi, inalilufwalu oofi lie platefu lufwafe lefe. ");
INSERT INTO kwo_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Mene rawie lufwalu wokei afwalaiei yare motukwe lewoleeke, tetoo Jerusalemeile boe rie. Te menanoo retifule aikopi leterife bwaleele teripotie tetoo yesoufe lulu nelanelule aikopife, te nia mei nianoo yesoule Gotele fanie. ");
INSERT INTO kwo_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tefe eesalu ameele Gotelu itei lelaiei, tetoo tupane menane fetaoonelu mene wolu Gotelu oofi nemboue lie. Te ekeise mei lufwa motukwe glei fetatenei, tetoo lamenei na unalemerife mwa. ");
INSERT INTO kwo_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Te ekeise Esia provinsefu Judane telu niane beleoone. Nemboue ekepane nali ekeni nafe nawobile nenei riebi tetoo nalimeme oonanoo oofime mene glelu amee lielule ifenawobi, tetoo oone marena nerife. ");
INSERT INTO kwo_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Te ekepane glei lalanei, tefe nemboue pe eete lalanelu pane menanoo glelu amee lielule fetaoonelufe Israelefu paie tefoo panelufi wotemiei nawobile? ");
INSERT INTO kwo_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Te na bofoo nielule tele pai finelufe tefe glei paie paie anei, mwa. Te mene tupanelufu temieke, natielu, ‘Inalilufwa troonalenelu boe ame fufuru nerife lelane, eetetie eetegeni na yewilufe nembue oone menane tefe belemoke iferiemo.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikse Jisesele Niferilu Ameele wolu rame lelee, tefe Pole wolu na neleeke te Felikse natelee, “Mene boe ame eetegeni nale bofoo lietu sere lerife lelane. Bie Romefu kworoofamelu yefeelu Lisiase rieli, tetoo eetegeni nale sere lebe.” ");
INSERT INTO kwo_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Te Romefu kworoofamelu keptenele Polele kame regi lefoolarilu tekoi siwonerife nafolee. Te kame ooloome lefoolamoi lalabee, tetoo nalilu moane yefetarife ririalanei ble natemwabule mani. ");
INSERT INTO kwo_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Te krie wolu soo leleeke, Felikse weife nariemu Drusilatu rine, te nariemu Juda inali. Te Polele rierife nafooneke, tetoo na fifwaforife, Pole Krais Jisesele menengoi ifelalarilu ameefe nafwafolee. ");
INSERT INTO kwo_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Te Pole lie platefu amee letewarilule tukwe, te menengule amwime tootookoo letelarife tukwe, te sabei Gotelu nafi yenaleporife tukwe na ifenatelee. Tefe Felikse eetegeni na fieleefe, mwa, wofri lelali, te nafolee, “O, tetie mai, te wa. Sabei bofootu boe nawofe.” ");
INSERT INTO kwo_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Te ekenitu Feliksekoe bofoo menengu lefoomeli, te nelee, Pole ame ireworife bwalee fanewobe, tetoo ooloome lefofe. Tefe utetu utetu weife na namerife kulitu kulitu lefoomelee. ");
INSERT INTO kwo_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Te yare wolu are leleeke, te Porsius Festuse Felikselu gugulule boe falefolee. Felikse Judane nanoole menengu mutukwe lewobile neleeke, tefe Polele ooloome lefolee teime kalabusei lalarife. ");
INSERT INTO kwo_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festuse Judia provinseile rieleeke, krie wolu mwangife leleeke, te Sisariafu Jerusalemeile kumolee. ");
INSERT INTO kwo_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Gotelu prise yefeelutu Judafu paielu panetu mare Festuselufile waneke, gle nale Polelu pume lefoolanelu nafe alipofoone, Festusele metie na gigi lefoolanei nafoone, ");
INSERT INTO kwo_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“Oone menane aikopi leluke, ekeni lufwale nafolukeme, Jerusalemeile riebee.” Tupane menengu lefoolane, lufwa telu ame afoi ambukepofooneke, regi lefoolanei Polele teiefooneke tafilarife. ");
INSERT INTO kwo_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festuse fune natelee, “Pole ame Sisariai Romefu kworoofame lufwalu amei oolalalee. Nia mei ekeme warife wolu roboi leoolalee. ");
INSERT INTO kwo_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tefe oonanoofu paielu lufwa telu mene mare wabile. Pole leleelu ameefi pai, tetoo tupane Polele na pume leforife alipobi.” ");
INSERT INTO kwo_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festuse na natemeli lie tialoo are pai lelee, yarilutu yarilutu pai lelee, tetoo Sisariaile yerelee. Te lie bofootu na fipwaletelananelu reeafoi lalali, tetoo Polele siyenerife natelee. ");
INSERT INTO kwo_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pole sekaleli, Judane lufwa Jerusalemefu yerenelu, fwai nalefooneke temepoolanei, nanoole metie na pume finalefoolane. Mwa. Ekeni na Polelufe eke ifenenelu yewilule glei amwime Festusele nafoonei, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pole fune natelee, “Mene Judalu na kaiseklile, Gotelu itele, Sisarele bofoo amee nembulu glei letie.” ");
INSERT INTO kwo_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mwa. Festuse nalife Judane tetoo paie paie awobile neleeke, tefe Polele fiefolee, “Oone nemboue pe Jerusalemeile na wonerife wale? Tetoo mene oonanoo nale Jerusalemei boe wofipwaleoolafe.” ");
INSERT INTO kwo_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Mwa. Pole nafolee, “Eetegeni na fipwaletelananelu reeafoi nembue mene eetei temelaielu, eetete Sisarelu. Oone kame eeteime menane na fipwaleoola. Oone wolu rame lelu, mene glei nembulu amee bofoo Judanele letiei. ");
INSERT INTO kwo_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nia nembulu amee bofoo liei eetegenife tafilarife nenei, eetete nemboue mene tafilafe. Mwa, eetegeni nafe menane beleoonelu glei marena na, lufwa bofoo glei menane tupanelu amei sinawobe, mwa. Sisare nalime menanoo nale fipwaleoolabee.” ");
INSERT INTO kwo_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Tefe Festuse, lufwa menengu fanenanelu mare na faleneke, te Polele nafolee, “Oone nelulu Sisare nalimeme oonanoo nale fipwaleoolabee. Sei. Oone Sisarelufile wa.” ");
INSERT INTO kwo_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Krie soo leleeke Kin Agripa yafoli Bernisitu weife Sisariaile rine, Festusele paie paie ifarife wane. ");
INSERT INTO kwo_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Weife ekei lamenei krie soo lemenelufe, tefe Festuse Polelufe kinele nafolee, “Bebriefe Felikse lufwa bofoole kworoofame lufwalu amei sineleelu, nembue ame teime lalalee. ");
INSERT INTO kwo_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Mene ame teime Jerusalemei oolalaiei, Gotelu prise yefeelu lufwatu Judafu yefeelu lufwa mare Polele na pume naforife, te tupane menane naoone, oone menane eetegeni lufwalu nembulu ameefe we napolu, tetoo kworoofame lufwa teiefobi. ");
INSERT INTO kwo_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mwa, mene fune natie, ‘Mene Romefu panelu amee eetetie eese lelee, ine bofoo inalilufwale na pume lelaleelule bie nanoolu oofi temeleeke, tetoo fune glesou na pume letelaleelule natebe. Tefe mena Romefu pane lufwa bofoole glei yemereti teiefori amee lebile.’ ");
INSERT INTO kwo_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Tefe mene boe Sisariaile rilaiei, tupane lufwa mare rine. Tetoo mene glei kai lefe, bofoo krietu na fipwaletelarilu reeafoi lafieke, te ekeni lufwale iferineke siyenerife natie. ");
INSERT INTO kwo_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Polele na pume lefoonelu pane temepoolanei, tupane glei Pole wolu nembulu amee bofoo leleefe eetegenifi tafilarife menane naoonei, mwa, mene wolu eesalu menengu lie pai naoome, eie, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nanoo kame nalilu gotele reeyemee lefoolanelu ameefe tukwe, te bofoo lufwa Jisese, wolu tafilaleelu nale tukwe ifenene. Mwa, Pole ekeni Jiseselufe nafolee, nanoo boe oofulilu lalalee nateleefe. ");
INSERT INTO kwo_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mene eetegeni na yewilule rame lerife nielu, mwa, menanoo menengu glei rame lepoliei. Mene tefe fiefwie, nanoo nemboue pe Jerusalemeile warife, tetoo mene nanoolu nale ekeise wofipwalefoolafe? ");
INSERT INTO kwo_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mwa. Pole teime gavmanelu itei lalarife nelee, sabei Sisare nalime nale fipwaleforife lelalee. Tefe mene nie, nanoo bie teime gavmanelu iteime lalali, afweele oorafofe Sisarelufile warife.” ");
INSERT INTO kwo_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa eetegeni nale fieleeke Festusele nafolee, “Mene nia ekeni lufwalu nale fieforife.” Te Festuse nafolee, “Kwotue oone nemboue fiele.” ");
INSERT INTO kwo_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tefe Kin Agripatu yafoli Bernisitu fime oo tefoo ranile leteneke rine. Te nanoo weife Romefu kworoofamelu yefeelu panetu eetegeni wokoo soulufu paie paielutu mare luku luku gueile wopreipoone. Te Festuse Polele iferierife neleefe tetoo sinaferine. ");
INSERT INTO kwo_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festuse natelee, “Kin Agripa te mena mareteku eetei lalanelu, oone eetegeni lufwale fetabu. Judane maretekume Jerusalemei, te eetei lalanelu mei eetegeni lufwalufe unaleneke menane fieri naoone, kose ooloome lefoluke oofuli lebe mani. ");
INSERT INTO kwo_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mwa. Mene nanoole fetaielu yesou bofoo glei leli, tetoo tafilarife. Nanookoe Sisare nalime nanoolu nale fipwalefoolarife nelee. Eetegenife nia wabee nafwie. ");
INSERT INTO kwo_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mwa. Mene na yewilu feti glelule pilieke, te menanoo paielule wafobe, tetoo nanoo rame lebe glefeme eetegeni lufwale belene. Tefe Kin Agripa, mene eetegeni lufwale oonanoofile, oone mare lalamolufile iferie. Mena nanoolu nale bie amwi rame letefooneke, tetoo mene lefoo pilefe. ");
INSERT INTO kwo_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nia kworoofame lufwalu amei sineleelu lufwa bofoole wabee nafwiei, te mene glei nanoole belenelu yewilufe nafwiei, mene ree su lielu, eetegeni amee glei wolilu.” ");
INSERT INTO kwo_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tetoo Agripa Polele nafolee, “Oone oonafe nate.” Tefe Pole ipoe amee yefee yefee aleeke tetoo nalife natelee. ");
INSERT INTO kwo_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kin Agripa, Judane menane na pume namenelu nafe, oonane naworife lelaie, tefe menengu lie eetete nemboue mene menanoo na oonane alipoworife. ");
INSERT INTO kwo_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Oona wolu rame lelu menanoo Judalu ameele, gle yesoufe fame na nelananelule. Tefe mene nafieoolaie oone bie amwime lalalu, menane mareteku naferieoolanelu nale naoolaiei fipwalula. ");
INSERT INTO kwo_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Judane mareteku menanoo lafierilule amwime rame lene, mene ame tukweelufi amiei menanoo weeluanelufi lamieke, te mei Jerusalemei oolalaie. ");
INSERT INTO kwo_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nanoo menane wolume rame leoone, nali i nenei, tetoo nalimeme nemboue menanoo ameele alipowobile. Menane rame leoone, mene Farisilu ameele nifetemie, te nifeterilu metie gigime lelee. ");
INSERT INTO kwo_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Te nembue mene eetei temelaielufe tefe beleoone. Beleoonelu yewilu eetegenife, menanoo menengu Gotele oolefoolaie bebriefe menanoo fetalianele lerife nasi nateleelule. ");
INSERT INTO kwo_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Mena Israele weeluane tialootu tialootu, krielu lielu Gotele menengu marena neneke reeyemee afoomenei eetegeni nasile oolefoomene. Te Kin Agripa, eetetie oolefoolaielufe, Judane menane na pume naoomene. ");
INSERT INTO kwo_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Glefeme oonanoofu telu eesalu menengu lene, Gote troonalenelule boe glei oofuli lerife letebe? ");
INSERT INTO kwo_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Bebriefe nia nie, mene amee amee motukwe letelaiei Nasaretefu Jiseselu bilule oorerei lefoomie. ");
INSERT INTO kwo_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Te mene ekeni ameele Jerusalemei letie. Gotelu prise yefeelu menane seinaooneke, tetoo Gotelu inalilufwale motukwe kalabuse itei sine sine atemie. Te nanoole teieteneke troonaleri ameele lenelufe, mene metie natie anefa troonalebi. ");
INSERT INTO kwo_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mene metie te wokoo te wokoome Judanelu alina iteile warie amiei inalilufwale bebe nie teietie afwalaie. Mene metie ange Paielule eeneri na naforife noopoo natemie. Mene fame menengu letelaiei mokenefu wokeile mei waieke teietie afwalaie. ");
INSERT INTO kwo_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Te Gotelu prise yefeelu menane seinaooneke eesalu amee lerife naooneke, tefe Damaskuse wokeile waie. ");
INSERT INTO kwo_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kin Agripa, lie babi temelali afweeme walaiei, tetoo fetaie efenefu takilule, metie ianeterielee lie takilule boore lefolee, te mene mare walanelu taki nalelali temepoolane. ");
INSERT INTO kwo_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Mene mareteku inengoi yekuruneke, te mene bofoo lufwalu ragoo efenefu fiefwielu menane Hibru natu nawolee, ‘Sole, Sole, oone menane glefeme teieoolalu? Oone yesou nalutu lenelule kulitu poune poune atelalu oonafe teteree falelalu.’ ");
INSERT INTO kwo_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Tetoo mene fiefwie, ‘Oone ine? Paielu pe?’ Te Paielu fune nawolee, ‘Mene Paielu, oone menane teiemelu. ");
INSERT INTO kwo_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mwa. Nembue te furaleluke teme. Mene oonane punepolewieke oonane namunewie, menanoo amee ameele leoolalu, tetoo nembue eete wolu fetalulu yesou nale alipotelalu, sabei mei ame fetou nateworife lelaielu yesoule tukwe alipotelale. ");
INSERT INTO kwo_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mene oonanoo weeluanetu rawie inalilufwatu glei ooloome letelaiei oonane nembuari lewobile. Mwa. Mene naoolaie nanoolufile warife, ");
INSERT INTO kwo_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","nanoolu oole tupwapoteluke tetoo pilule grialeteneke takilufile rierife, te Sebore Lufwalu bialile grialeteneke Gotelufile riebi. Tefe mene nanoolu fwagilule wolu wogrinatie. Tetoo nanoo menane wolu menengoi ifelaoolanelu inalilufwalufile rine. Te ekeni ameefi, mareteku lie platefu inalilufwafe lene.’ ");
INSERT INTO kwo_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kin Agripa, mene eetegenile efenefu rarauetu atukwe nale fieke glei futeni lefwiei. ");
INSERT INTO kwo_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mene Damaskusefu inalilufwale molukwe alipotieke, te boe Jerusalemefu inalilufwale alipotieke, te Judiafule alipoofwatie, te boe rawie inalilufwatume wolie. Mene eesalu nale alipotie, ‘Oone oonanoo fwagilu ameele mufeletemoke, Gotele menengoi ifelalanelu inalilufwafe lemoke alamoi, tetoo wolilu ameeleme fetou natelabu.’ ");
INSERT INTO kwo_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Eetetie eetegeni yewilufeme Judane menane Gotelu ite geeneri menei beleooneke, te teieooneke tafilarife lielu. ");
INSERT INTO kwo_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Gote aikopi lewoleeke, amwime laferilaieime nembue eetei lalaie. Tefe nembue mene eetei temelaiei bilu preme lenelu panele te paielu lufwale tukwe alipotie. Mene glei bofoo nale alipotiei, kame bebriefe Gotelu ragoofu nale alipoolanelu lufwatu Mosesetu glesou yesou kurulerife nenelule alipotie. ");
INSERT INTO kwo_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Tupane nene, Kraise metie teteree falebee, tetoo nali molukwe furaleleelu lufwafe lerife lelalee, tetoo Gotelu wolilu takilu na ulule Israelele tukwe rawie inalilufwale tukwe alipoterife lelalee.” ");
INSERT INTO kwo_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pole nale ame alipotelali, te Festuse ragoo iteritu nafolee, “Pole, oone bibri nafe pai nelalu, oone ramelufe yefee leri amee amee motukwe lelalufe, tefe oonanoo selilu ramelu nali bibri na ifenaoolalee.” ");
INSERT INTO kwo_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Te Pole nafolee, “Paielu lufwa Festuse, mene glei bibri nale nelaiei, mwa. Mene marenafe nie, mene menengu nembouelutu nelaie. ");
INSERT INTO kwo_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kin Agripa eetegeni yesou Kraiselufe mareteku mene nielule wolu rame leleefe, tefe mene alipofori sereme lie, glei wofri lefwiei. Mene te rame lie, ekeni Kraiselufe nanoolu oofi, futenifi mareteku wolu rame lefolee, bofoole glei mumu lefoli, Jises Kraise teteree faleleeke, tafilaleeke furaleelu glei angime lelee. ");
INSERT INTO kwo_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kin Agripa, oone Gotelu ragoofu nale alipoolananelu nale menengoi ifelalatelalu pe? Mene wolu rame lie, oone menengu eese lelu.” ");
INSERT INTO kwo_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Te Agripa Polele eesalu fiefori lelee, “Nembueme pe, mene Kristene lieke, Jisesele nifelarife nawole pe?” ");
INSERT INTO kwo_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Te Pole fune nafolee, “Nembueme pe, sabei pe, mene Gotele eesalu nale woponefwie, oone nembue tupane menanoo nale fiemenelule, oone mareteku mene keme lebule. Mwa, kose oonane seine luamobile mani.” ");
INSERT INTO kwo_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Te kine furalelali, te gavanatu, Bernisitu, lufwa mare lamenelu mei fufuru neneke temepoone. ");
INSERT INTO kwo_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Te ekeni guele grialeneke wane, nali kwaife na neneke, te nene, “Eetegeni lufwa bofoo amee nembulule glei lelee, tetoo tafilabe, o kalabuse lebe.” ");
INSERT INTO kwo_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Te Agripa Festusele nafolee, “Oone ekeni lufwale wolu tepoleluke, nemboue wabe, mwa, nembue nali wolu nelee Sisare nale fipwalefoolarife.” ");
INSERT INTO kwo_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Na wolu sere lene wokoo soulu Italifile melee afwee braitu warife, te Pole mare kalabuse itei lalanelu lufwa telu mareme Romefu kworoofamelu keptenelu amei sinatefoone, nanoolu bilu Juliuse. Nanoo Sisarelu Poritefu Kworoofame Lufwalufu. ");
INSERT INTO kwo_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Te mene Adramitiume wokoofu brai soulu bofoofi peepeenene. Ekeni brai soulu Esialu melee fooloo porite warife lelaleelu, eetei imimi nene eetei imimi nene afwarife lelane. Te mene wafene grialeneke, te wane. Te Masedoniafu lufwa Aristarkuse, Tesalonaika wokei lalaleelu mare wane. ");
INSERT INTO kwo_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Te bofoo krietu Saidone wokei kuruwolene, te Juliuse Polele nembouelu ameefe tepolelee, kame nalilu moanelufile warialali glelu yesoufe lulu nelali tetoo aikopi ifalabile. ");
INSERT INTO kwo_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Te boe Saidone wokoole grialeneke te wane, mwa, menane fifri soulu feti puleterielee. Tefe Saipruse wokoo tupulume ekeni fifrile muli lefoolaleefe kumori porite wolene. ");
INSERT INTO kwo_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Te mene mwi meleeme tekatewapooneke, te Silisia provinse porite te Pamfilia distrike porite roboi letewafoonei te waneke, Lisia distrikei lalaleelu Maira wokei kurulene. ");
INSERT INTO kwo_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Te Romefu kworoofamelu keptene, brai soulu bofoo boe Italifile warife lelaleelule oorafwateleelu te Aleksandriafule fetaleeke, te peepeeneneke wane. ");
INSERT INTO kwo_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Te mwa, fifri soulu feti menafe ootari porite foofoonaferieleefe, tefe kame pitukoeme wameli, te krie soo lene. Te Niduse wokoo bwagei kuruwolerife lenelu gigime leleefe, tefe mene boe wokoo tupulu Kriteme luwane ekeni fifrile muli lefoolaleefe Salmone tupulule roboi letewafoone, ekeni wokoo tupulumeme warime lene. ");
INSERT INTO kwo_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Brai soulu Kritelu wafene babrilume nifetewaleeke, mwa, fifri soulu boe ootari porite fooneterieteleefe tefe gigime feti letelee. Mene bofoo wokoo Nemboue Melee Fooloo nafoonelu wokei kuruwolene, Lasea wokoo bwagei lalalee. ");
INSERT INTO kwo_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mwa. Krie soo leteriemeneime, mwi melee mare koona beenelaleefe mene wofri lelane, te Fori Yesou Ambopoonelu Lie wolu pookanaleneke, tefe Pole natelee, ");
INSERT INTO kwo_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Oone fieoolabu, mene wolu rame lie, mena nembue walanei afoi ritilu soulule falebile. Motukwe yesoutu, te brai soulu nembuari lerife lelane, tetoo mena glei oofuli lebile.” ");
INSERT INTO kwo_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mwa. Romefu kworoofamelu keptene Polelu nale glei nifefoli, nanookoe kame brai soulule ifalaleelu lufwalu nale te brai yarilu nale nifetelee. ");
INSERT INTO kwo_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Eetegeni melee fooloofi brai soulu eetei lalarilu mwa, glei wolilu, tetoo fifritu melee koona beenaferielee. Tefe motukwe na neneke, te nene, mena yereri porite teme warife bie Finikse wokei tei kuruwoleneke, tetoo fifri soulule laripolefoolabile. Te Finikselu mwi melee fooloo luwari porite wokoo tupulu yereri porite Kritele ooretafoolalee. ");
INSERT INTO kwo_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Te fifri luwari porite foofoonaferielee tukweeme keke, tefe menengu eese lene, brai soulu nemboue amwi ekeni mwi melee fooloome wabe. Tefe ankale boglineke, te mwai kweinelali te Kritelu wafenele roboi letewafoolanei wane. ");
INSERT INTO kwo_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mwa, glei kai leli, fifri soulu paniferieli foofoonaferielee, “bulari porite babrilume kumori porite babrilume fifri” nafoone. Eetegeni fifri Krite wokoo tupulume teme fooneterielee tetoo brai soulule puletewalee. ");
INSERT INTO kwo_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Mwa. Brai soulufi amee amee alanelu pane nanooboe brai soulutu luluneneke, boe tewabile nenelu metie mwa, ange ange ane. Tefe kame fifri nalime puletewapoomelee. ");
INSERT INTO kwo_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Te mene luwarime leneke, te wokoo tupulu tukweelu lalaleelu Kauda nafoone, te ekeni fifrile muli lefoolaleefe tetoo mene brai tukweelule glieterierife ange ange ifaferineke brai soulu bwageime yelelee. ");
INSERT INTO kwo_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Te brai tukweelule boletaneke mwai bofatineke, tetoo mweetu krine krine ifane. Te boe same mwee telu brai soulule ambeme leteneke te krine krine aneke, tetoo brai soulule kaisekli leforife. Mwa. Nanoo wofri feti lelane kose brai soulu waleeke Afrikalu wafenei tei kwaleleeke lalabe nene, tefe ekeni leeloo soulu linelule ambeile tereneke, tetoo fifri brai soulule puletewalee. ");
INSERT INTO kwo_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Fifritu mwi melee koona beenaferieli menane metie eebure ambure ifapoolaleefe, tefe boe bofoo lietu amee amee alanelu lufwa brai soulu fuenalerife yesou telule mwi melei wogrinene. ");
INSERT INTO kwo_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Te boe mwangifelu lietu mwa, nalilu ameetu brai soulufi amee amee ifatelanelu yesoule mwi melei wogrinene. ");
INSERT INTO kwo_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Krie soo letewanei, te oopinaletemeli tetoo lie ooloole tukwe, limwafule glei fetatene mwa, te mwa, fifri soulu foofoo naferieli mwi melee koona beenaferielee brai soulule bune bune ifwafwalee. Tefe nembueme mene menengu lene, mene maretekume glei oofulilerife lelane. ");
INSERT INTO kwo_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Te lufwa mareteku glei kakali lenei, mwa, krie soo letelee. Te Pole nanoolufi temeleeke natelee, “Lufwa oona menanoo nale glei fiemo, mena ame wokoo tupulu Kritele grialeri preme lelanei, tetoo nembue mena eesalu ritilule glei falerife lenelu, te yesou mei glei wogrinerife lenelu, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Te nembue mene namoolaie, oone menengu mutukwe lebu, menanoofu bofoo lufwa glei tafilabe, mwa, kame brai soululeme teiefobe. ");
INSERT INTO kwo_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nembue kriei Gotelu ensele rieleeke, menanoo babrilufi, yetemelee. Mene Gotelu amee amee lufwa, te nalife reeyemee lefoolaiaie. ");
INSERT INTO kwo_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Te niane nawolee, ‘Pole, oone kose wofri lele mani, oone waluke Sisarelu ootari porite woteme. Te fie, Gote wolu oone na woponefoomelule fiewoleeke, te nawolee, lufwa eke mareteku brai soulufi lalanelu mwa, glei troonalebile.’ ");
INSERT INTO kwo_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Tefe oone pane lufwa, oonanoo menengu kaisekli lebu, eetete mene Gotele menengoi ifelalaie, te eke nawoleelu atukweme lerife lelane. ");
INSERT INTO kwo_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mwa, mena kame wokoo tupulu bofoofi kwalebile.” ");
INSERT INTO kwo_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Te krie ameelu 14 teime ame fifri foofoo nelali brai soulule puletewalalee, Meditereniane Mwi Meleeme tekatewamene. Te krie babi lelali, te brai soulufi amee amee alanelu nene, wafene bwagei pai lelalee. ");
INSERT INTO kwo_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Te akerieri mweetu mwi melee fooloole akeriefoonelu 40 mita pike lelee. Te brai soulu boe wapoleleeke, te boe akeriefoonelu melee fooloole 30 mita pike lelee. ");
INSERT INTO kwo_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Mwa, mene wofri lene kose brai soulu ti porite waleeke tifi poune poune afwaleeke mopu mopue abe neneke, tefe ankale yerifurutu brai soulu kumulu porite wogrinene tetoo brai soulu teime lalarife. Tetoo nalilu kose kose gotele oo taki nalerife na woponetene. ");
INSERT INTO kwo_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Te brai soulufi amee amee alanelu nali kwaife pruelebile neneke, tefe brai tukweelule mweetu beletereneke melei fatine. Te nanookoe eetegeni na yeunatu nene, “Mene ankale ipoelu porite melei lualane.” ");
INSERT INTO kwo_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Te Pole Romefu kworoofamelu keptenele tukwe kworoofame lufwale tukwe natelee, “Tupane lufwa lalari preme lenei, eetete oone glei oofuli lerife lelamo, mwa.” ");
INSERT INTO kwo_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Te tupane kworoofame lufwa brai tukweelufu mweele kreenapooneke, te melei fufele nelalee. ");
INSERT INTO kwo_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Te oo taki nalerife roboi lelali, te Pole tupane lufwale natelalee, mareteku kakali lerife. Te natelee, “Te lie wolu 14 lelee, tetoo oone oolemoomeime kakali preme lamoome. ");
INSERT INTO kwo_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Tefe nembue eete namoolaielu oone fori yesou foopobu. Tetoo kaisekli lelamoi lalarife, te mei lufwa bofoo glei nembuari lebe, mwa. Maretekume nemboue oofuli lerife lelamo.” ");
INSERT INTO kwo_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Te nanoo na neleeke, tabele faleleeke, tetoo tupanelu ootari porite Gotele na woponefoleeke, te eetegeni tabele mongue leleeke, tetoo foolalee. ");
INSERT INTO kwo_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Te maretekume menengu mwamole leneke, te kakali lelane. ");
INSERT INTO kwo_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Te mene inalilufwa brai soulufi lalanelu maretekume ameelu 276 lelee. ");
INSERT INTO kwo_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Te mareteku wolu kakali leneke, yelu letenelufe, tetoo brai soulu fuenanerife te wite ooloole maretekume ekeni brai soulufi lailanelule melei wogrinene. ");
INSERT INTO kwo_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Te lie wolu mare taki naleleeke, te inengu fetanelule glei rame lefoonei, mwa. Te oofwanenelu melee fooloole fetane wagoo tupulu wofrinefeleelu wafene mei nemboue lelee, te nanoo menengu lene, nemboue pai brai soulu ekeise kwalebe nene, tetoo ekeni wafenei iminalerife. ");
INSERT INTO kwo_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Tefe mwee ankafi liliapoonelule kreenapooneke teime melee menei grialetene, te eketume mweele pulei fupwanelule klinepoone. Te boe brai soulu ipoelu porite leeloole boglineke, tetoo fifri puletewateleeke ekeni wafenei iminaleporife. ");
INSERT INTO kwo_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Te mwa, brai soulu ipoelu porite metie wafene tupulu mwai kwaleleeke, te ipoelu wafenei lekaleleeke lalalee. Tetoo melee metie koona beenelaleelu afune atukwe temeterieleeke, brai soulu kumulu porite bune bune ifalaleefe metie mopu mopu alee. ");
INSERT INTO kwo_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Te kworoofame lufwa nanookoe kalabuse lufwa iferietenelule teieteneke troonalerife, kose melee lepupooneke brunalebile nene. ");
INSERT INTO kwo_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Te mwa, Romefu kworoofamelu keptene kose tupane Polele teiefobile neleeke, tefe kworoofame lufwale ble natelee eesalu amee leterife. Te maretekume natelee, “Inepane melee lepuerife rame lemoi tetoo tukwianepomoke lepupoofwamoke wafenei oolalabu. Te inepane mumulu mareteku kale, brai soulu mopu mopuelu eetele peenemoke tetoo lepupobu,” ");
INSERT INTO kwo_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","te maretekume lepupoofwaneke, wafeneime peepeewonene, te bofoo glei tafilalee, mwa. ");
INSERT INTO kwo_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Mene amwime wafenei peepeewoneneke, te nembue rame lelane eetegeni Malta wokoo tupulu nafoonelufi lalane. ");
INSERT INTO kwo_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Eetegeni wokoofu inalilufwa menafe metie amwi lene. Aroo same nafwalali, bebeti lepotelanelufe nimbie ife atukwe i fufaneke, te ifi kinaporife ifwapoone. ");
INSERT INTO kwo_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pole ka falulu lailanelu genile ambolepoleeke ifi lualali, tiafwee bofoo berefu falulu menei lalaleelu i rilu gaga nafoleefe yesekaleleelu tefe metie amei neenee lele naleleeke kweinafoomelee, tetoo neenee yeielu meneeme nembulu meleelu wapofoone. ");
INSERT INTO kwo_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wokoofu inalilufwa ekeni tiafwee amei kweinafoolali fetafoonelufe, tefe nali kwaife nene, “Ie, ekeni lufwakoe lufwale puketelaleelu pai? Nanoo glei mwi melei tafilali, mwa, tefe nembue inali soulu gote nafoonelu Fune Nembulufe Teietelaleelu, nanoole glei ooloome lefoleeke oofulilu lalabe.” ");
INSERT INTO kwo_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mwa. Pole ekeni tiafweele amefule fifri leleeke, tepoleleeke ifi yeferaleleeke, tetoo Polele glei teiefolee. ");
INSERT INTO kwo_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Inalilufwakoe oolefoomenei, menengulume lefoomene Polelu ree raramu napofobile pai, kame yeferaleleeke tafilabe pai. Mwa. Nanoo ooletewafoolanei Pole glei eese leleefe fetanei, tefe menengu letewaneke te nene, “Nanoo fime bofoo gote.” ");
INSERT INTO kwo_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Maltafu paielu lufwa bilu Publiuse, nanoolu inengu monguelu lalaleelu bwagei peepeenene. Eetegeni lufwa nalilu iteile ifwapoleeke, te amwi ifelepomeli krie mwangife lene. ");
INSERT INTO kwo_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiuselu yari reefe amelee tetoo ree ningitu arie melee soulutu lefoomelee. Tefe Pole waleeke, Gotele na woponefoleeke, amee fatiefolee, tetoo ree woli lefolee. ");
INSERT INTO kwo_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nanoo eese leleefe, te ekeni wokoo tupulufu ree tefoo inalilufwa mei Polelufile ririanelufe, te nanoolu reele boe woli letewatelee. ");
INSERT INTO kwo_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nanoo menane metie wolilu ameele lemene, te mene grialeteneke warife lelanei, mena lulu napoolanelu yesou mareteku teripooneke tinepoone, tetoo brai soulufi luaneke, te ifwapolee. ");
INSERT INTO kwo_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Mene Maltai lamenei wosi mwangife leneke, te Aleksandriafu brai soulu bofoofi peepeeneneke wane. Ekeni brai soulu mei fifri selilu alaleefe ekeni wokoo tupulufi lamemelee. Te brai soulu ipoelufi gote Suselu lefooanelu yemelarilule are pileteneke laine. Lefooane are yefee mwamole lietu luponuelee. ");
INSERT INTO kwo_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Waneke, wokoo Sirakyusei kuruwoleneke te eetei krie mwangife lene. ");
INSERT INTO kwo_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Te ekefu boe wanelu Regiume wokei kuruwolene. Bofoo krietu fifri luwari poritefu foofoonaferieleefe, tefe Regiumele grialene. Te krie arelutu waneke Puteoli wokei kuruwolene. ");
INSERT INTO kwo_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Eetegeni wokei Jisesele menengoi ifelalanelu inalilufwa telule fetatene. Tupane menafe mare lalarife fine, tefe mare ifelatemenei krie tialoo mwamole lene. Te boe grialeteneke waneke, Romei kuruwolene. ");
INSERT INTO kwo_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romefu Jisesele menengoi ifelalanelu inalilufwa mene rilanelu nale finelufe, esulu afoi alualu ifeletene. Te mene telu lufwale bofoo wokei fetatene, wokoo bilu Apiuselu Sakenee Tekoo. Te mei telule bofoo wokei fetatene, wokoo bilu Lueri Ite Mwangife. Pole fetateleefe menengu mutukwe lefoleeke, Gotele paie paie afolee. ");
INSERT INTO kwo_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Mene Romei kuruwoleneke, Romefu paielu lufwa bofoo Polele nalime ite bofoofi lalarife nafoleeke, tetoo kworoofame lufwa bofoole regi lefoolarife nafolee. ");
INSERT INTO kwo_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pole krie mwangife leleeke, te Romefu Judanelufu paie paielu lufwale luku ifeleterife natelee. Nanoo lukuleneke te natelee, “Apane, mene menanoo weeluanele tukwe, fetalianelu ameele tukwe glei mwate mwate letiei, mwa, menane Jerusalemei kalabuse leooneke, Romelu amei sioonaoone. ");
INSERT INTO kwo_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Tetoo Rome menanoo nale fieoomeneke, te mwa, mene yesou bofoo lielu nembulule glei fetaoonei, tetoo eetegenifi tafilafe, tefe tepoleworife lenelu. ");
INSERT INTO kwo_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mwa. Judane eetegeni nale mwate letelanelufe, tefe Sisare nalimeme menanoo nale fipwalularife nie. Mene glei menanoo weeluanele na pume letiei. Eie. ");
INSERT INTO kwo_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Tefe eetegeni yewilufe mene oonane fetamorife, na namorife fieri namwieke rimo. Mene menengu eese lie, ekeni lufwa mena Israele mareteku oolefoolanelu, te eetegeni yewilufe, tefe eetegeni seine nembue eete fuewoleelu.” ");
INSERT INTO kwo_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Te Judanelufu paie paielu lufwa Polele nafoone, “Menane Judiafu lufwa telu oonanoofe lofoo piletenelu mene glei peenenei, te Judane mei rinelu bofoo glei nembulu na oonanoofe nenei. ");
INSERT INTO kwo_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mwa. Mene oonameme oonanoo menengule alipoolalu fierife, mene te rame lene, te wokoo te wokoofu inalilufwa mena Judafu eetegeni fime amee tefoo ameele lelanelule eeneri natenane.” ");
INSERT INTO kwo_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Te krie bofoole namunefooneke, te lufwa motukwe Pole lalaleelu iteile rine. Te kwotuekriei leleeke letewalaneke feiferi wolelee, Gotelu ameime lalarilu nale alipoofwatelalee. Te mei Pole Moseselu Na Kaiseklilufu, te Gotelu Ragoofu Nale Alipoolanelu bukefu mei kulukwanueleeke, tetoo tebiri nalemeli Jiseselufe natemelee. ");
INSERT INTO kwo_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Tefe lufwa telu nene, eetegeni na Pole nelaleelu eetete wolilu. Mwa. Telu glei Polelu nale marena nenei. ");
INSERT INTO kwo_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nanookoe nali kwaife fame na nafwaneke te wane. Mwa. Warife lelanei, Pole eetegeni na fiemenelule natelee, “Wolilu Fifri Gotelu ragoofu nale alipoolaleelu lufwa Aisaialu ragoi oonanoo fetalianele marenafe natelee, ");
INSERT INTO kwo_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Oone eetepane inalilufwalufile waluke nate, “Oone na filarife futeni soo lemebule, mwa, yewilule glei rame lefobule. Oone fetarife oo soo lemebule, mwa, oone yesou bofoo amwi glei fetari sere lefobule.” ");
INSERT INTO kwo_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Eetepane inalilufwalu menengu wolu footepoteneke lalane, nanoolu futeni na fierilu mei, mwa. Te nanoolu oo footepotene, kose yesou bofoo fetaneke futeni fineke na yewilule rame lefooneke, te menengu ooretalefooneke boe menanoofe lerife mene amwi letiei, woli lebile neneke.’ ” ");
INSERT INTO kwo_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Pole boe natelee, “Tetoo oone rame lerife, Gote eetegeni na wolilu menafe eetei paie naporife, eetele Gote wolu rawie inalilufwale tewatelee, nanoo tetoo fiebile.” ");
INSERT INTO kwo_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Yare areme Pole bofoo itei lamemelee, te ite yarile bwalee fane fane ifamelee. Pole metie paie paie amelee lufwa nanoole ririafoomenelufe. ");
INSERT INTO kwo_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nanoo Gotelu ameime lalarilu nale alipotemeli, te inalilufwale Paielu Jises Kraiselufe ifenatemelee, glei ragoo glieteli tebiri nalemeli, te lufwa bofoo glei ble nafoonei. ");
INSERT INTO kwo_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Mene Pole, Sailase, Timoti mene eetegeni nale lofoofi pileneke, oonane riemolee. Oone Tesalonaikafu Gotelu inalilufwa wolu menanoo Aie Gote weife Paielu Jises Kraiselufe lemolu, Gotelu keemakee oonane metie binanemoolali, tetoo menengu mutukwe lemoke lalabu. ");
INSERT INTO kwo_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Mena oonanoofe te krie te krie Gotele paie paie afoolanei, oonane menengu lemoolanane. ");
INSERT INTO kwo_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Mena metie sameme menanoo Aie Gotele paie paie letewafoolanane, Jisesele menengoi ifelalamolu menengu oonanoo nali wolilu amee ameele letewamoolaleealee, te wolilu amee Gotelu inalilufwa oone inalilufwa telule ooretaterilu amee oonane seenalemoolaleealee, tefe oone metie menengu kaiseklime lelamoi, menanoo Paielu Jises Kraisele oolefoolamo. ");
INSERT INTO kwo_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Mena tete wolu rame lene, Gote oonane ooretamoolaleelu apane wofoliane, Gote oonane nalilufeme leforife namunemolee. ");
INSERT INTO kwo_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Eetegeni na ulu wolilu oonanoofile riemoleelu, glei kame nalufe neleelu na, eie, mwa. Nanookoe metie kaiseklilutu, Wolilu Fifritu, te mene Jisesele menengoi ifelalanelu menengu menanoofule wolu fetatemo. Oone wolu rame lemo, mena oonanoofi lamenei, eke amee amee lemenelu ameele eetete oonanoo aikopife lemene. ");
INSERT INTO kwo_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Oone Gotelu nale falemoke, te nembulule motukwe falemoome, oone glei tupu lemoomei, eie mwa. Oone alamolu amee eetete mene Paielulu akerie akeriefe leneke, amenelu atukweme alamwamo, te Wolilu Fifri seenalemoolalee oone metie paie paie amoome. ");
INSERT INTO kwo_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Tefe oone Masedoniafule Akaiafule tukwe Jisesele menengoi ifelalanelu inalilufwale wolilu ameele wolu fetou natemo. ");
INSERT INTO kwo_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Oone wolu Paielulu nale alipotemo, eetegeni na awamoo ningilu atukwe sameme wari warime lelalee. Eetegeni na glei kame Masedonialu, Akaialu poritememe walali. Eie, mwa. Wokoo wokoo mareteku oonanoo nale wolu rame letewamoone, oone Gotele menengoi ifelalamolu menengufe, tefe mene na boe naterilu, mwa. ");
INSERT INTO kwo_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Nanoo mei nalimeme mene oonanoofi lamenei, eke amee amee soulule lemenelu na eetetie bolelutu leleelu nale alipoolanane. Te oonanoo rurule mufeletemoke, marena Gotelufile wamolu nale alipoolanane, eetegeni Gote same lalaleealeelu Gote. Te oone Gote nalilu amee amee lufwafe lefoomolu nale tukwe alipoolanane. ");
INSERT INTO kwo_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Te oone nalilu Lefoo efenefu boe rierife lelaleelule oolefoolamolu lufwa, ine nali wolu tafilaleeke, te boe yari kelafoleeke furaleleelu Jisese, nanoo menafe aikopi lepolee, tetoo mena amwime lalarife, neembee neembee inalilufwa Gotelu nafi glei yenalefobile. ");
INSERT INTO kwo_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Apane wofoliane, oonameme wolu menane rame lepoomo, mene oonanoofi lamenei, mene eetegenitu afwalanelu amee amee glei preme leli, mwa. ");
INSERT INTO kwo_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Mene ame oonanoofile rieri preme lelanei, ame teime Filipaifime oolamenei, tetoo menane eeneri natu finalemenei, tetoo selilu ree teteree nembulule falemene. Te mene eke oonanoofile rineluke, menanoo Gote nali menafe aikopi ifelepomeli, tetoo mene kaisekli lelanei, oonane Gotelu na ulu wolilule alipomoomene. Te mene oorerei panele mei glei ree pritetenei, mwa. ");
INSERT INTO kwo_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Mene oonane namoonelukoe Jisesele menengoi ifelalarilu nale alipomoone, mene oonane glei nembulu nale, fwagilu ameetu, kose kose natu na seree neteriemoone, mwa. ");
INSERT INTO kwo_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Te Gote nalimeme menane ree sulepoleeke, tetoo nalilu menengume menane na ulu wolilule alipoolarilu amee ameele tinelee. Tefe mene glei inalilufwa menane eetegeni amee ameele fetaneke, tetoo ooretalarife, eie mwa, eetekoe fime Gote nali menanoo menengule ootu ootu letelaleealee. Te menanoo menengu Gote nalimeme menanoo ameele ooretapoolabee. ");
INSERT INTO kwo_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Oone wolu rame lemo, te Gote mei wolu rame lelee, mene glei oonanoo yesoule peenemorilu menengutu oonane na seree neteriemoone. Eete mei, menane glei lufwa bofoo paie paie arife namoomenei, mene kame oonane na woliluleme naferiemoone. ");
INSERT INTO kwo_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Mene eete alanelu amee amee mene glei oone telu pane mare menanoo bilu mwai lelarife lelanei, eie, mwa. ");
INSERT INTO kwo_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Eetete marena, mene Kraiselu aposelefe leneke alane, tefe menanoo ree nali i nenei, tete mene oonane nemboue namobile menane aikopi lepoolarife. Mwa. Mene glei paielu lufwa atukwe leneke, oonanoofi lamenei, mwa. Menekoe ree googoo preme amenei, tetoo inali bofoo nalilu arile totoole fanemeleelu atukwe lemene. ");
INSERT INTO kwo_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Mene oonane metie ooretamoolanane, tefe mene oonane wolu Gotelu na ulu woliluleme alipomoone. Mene mei wolu i nene, menanoo wopulufu menengu oonane aikopi lemorife, oone wolu menanoo ambrefe lemolufe. ");
INSERT INTO kwo_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Apane wofoliane, oona wolu menane rame lemo, mene oonane Gotelu na ulu wolilule alipomoomenelutu, mene bofoo amee amee soulule lemene. Mene bofoo lufwale te yesou te yesou aikopife glei fiefoonei, mwa. Mene metie krielu, lielu amee amee glei amee tepolenei, mene menafe aikopife sameme letewalane. ");
INSERT INTO kwo_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Oone oonanoo ootu wolu fetamoke rame lemo, te Gote mei wolu rame lelee, mene oonane amee amee ifelemoomenelule, tetoo oone Jisesele menengoi ifelalarife. Tefe mene amee amee nemboueluleme Gotelu oofi leterine, tetoo mene glei fwagilu amee bofoole lenei, mwa. ");
INSERT INTO kwo_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Oona wolu rame lemo, mene ekeni amee oonane lemoomeneluke eke lufwa nalilu arile amwi letelananelu atukwe lemoomene. ");
INSERT INTO kwo_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","Te mene oonanoo menengule amwi sere letemorilu nale tukwe, menengu teime kaisekli lemoolarilu nale tukwe, naferiemoone. Tetoo oonanoo wolilu ameefe, Gote eetele fetamoleeke, paie paie alalee, tetoo amwime warialarilu nale tukwe namoone. Eetete Gote nali wolu nalilu amei lalarife, nalilu soulu takilufi efenei lalarife tukwe fieri namolee. ");
INSERT INTO kwo_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Te mene mei Gotele sameme paie paie afoolanane eetetie eetegenife, oone Gotelu nale menanoofule fimoke falemolu, eetele oone glei lufwalu nale atukwe falemo. Eetekoe Gote nalilu nale falemo. Eetetie eetegeni na nali oone Jisesele menengoi ifelalamolu inalilufwale tekee namoolalee. ");
INSERT INTO kwo_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Apane wofoliane, oone metie Gotelu inalilufwa Judiai lafwalanelu keme lemo. Eketie ekepane nali Krais Jiseselufe lenelu. Oone Tesalonaikafu inalilufwa soulu nembulule oonanoo weeluanelu amefule faletemoome, eke Judane Judiafu weeluanele letemenelu atukwe. ");
INSERT INTO kwo_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Eetetie Judane nalimeme Paielu Jisesele tukwe, telu Gotelu ragoofu nale alipoolanelu lufwale tukwe teietemenei trooneterilane, te telu menane kurune kurune apoonelufe, tefe mene wane. Ekepane Gotele glei reeyemee lefoolanane, tefe mareteku inalilufwale metie oorerei letelanane. ");
INSERT INTO kwo_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Ekepanekoe menane ble napoolanane, tetoo mene kose rawiele Jiseselu na ulu wolilule alipotebile neneke, mwa. Judane Aie Gote kose ekepanele paie napoolarife metie ulabee nene. Eetetie eese alanelu ameefe, tefe nanoo fwagilu ameele glei grialetelanei, mwa. Te ekeni amee nali alanelu ameelu metie selime letelee. Tefe Gotelu fame menengu wolu rieteleeke latelalee. ");
INSERT INTO kwo_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Apane wofoliane, mene eete oonane grialemori atukwe leneke waneluke, Judane nali menane kurune kurune apoonelufe. Tefe mene oonane mokenei wolemoomene, eke lufwa bofoo nalilu arile grialeteleeke mokenei keke oolalaleelu atukwe lemoomene. Mene oonane boe glei fetamoolanei, mwa. Menanoo menengu metie oonanoofime lelane. Tefe mene oonanoofile rierife afweele oorafoolanei, ange ange alane, boe rineke yefetamorife. Menanoo ree i neneke lalane, oonane boe yefetamorife. ");
INSERT INTO kwo_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Mene oonanoofile rierife tete ree i napoone, mene Pole, mene te krie te krie oonanoofile rierife boe ange riefe niei, boe ange riefe niei, metie mwa. Sebore Lufwa nali menanoo afweele teka teka amolee. ");
INSERT INTO kwo_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Menanoo Paielu Jisese boe rilaleelu lietu tetoo menane glelu yesou kaisekli lepoolali tetoo mena nalilu ootari porite temepofoolanei paie paie afobile? Menaboe glelu yesoule nifwarife teripofobile mena eke wolilu amee ameele lemenelufe? Menekoe kame oonaneme paie paie amoolarife lelane. ");
INSERT INTO kwo_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","We, marena. Menekoe oonaneme paie paie amoolanane, tefe menanoo menengu mutukwe feti lepooneke lalane. ");
INSERT INTO kwo_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Mena oonane metie menengu rufomoolanelufe, tefe mene weife boe eesalu menengu lene, mene glei kai lebile. Mwa. Tefe mene weife Sailasetu na falene kame teime wokoo soulu Atensei lalarife, ");
INSERT INTO kwo_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","tefe mene weife Timotileme na nafooneke oonanoofile riemolee. Timoti menanoo womoo, Gotelu amee ameele lelaleealee, te Kraiselu na ulu wolilule mei alipoolaleealee. Tetoo oonane aikopi lemoolali, oonanoo menengu tetoo Jiseselufime lelarife. ");
INSERT INTO kwo_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Te oone Jisesele menengoi ifelalamoi glelu oo nembulu riemoolalee oonanoofu bofoo telu panelu menengule kose teietelabile mani. Oona te wolu rame lemo, Gote nali menafe eesalu nembulufi lalarife namunepolee. ");
INSERT INTO kwo_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Tetoo ute mena oonanoofi ekei lamenei, mena eetetie oonane namoone, glelu glelu oo nembulu menafe ame bibinapoolabile. Te oona wolu amwime rame lemo, ekeni oo nembulu tete wolu fetane. ");
INSERT INTO kwo_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Eetetie eetegeni yewilufe tefe mene glei kai lefe. Mwa. Tefe mene Timotile nafwieke oonanoofile riemolee. Tetoo mene oone Jisesele menengoi ifelalamolule rame lemorife. Mene wofri lelaiei nie, oone Jisesele menengoi ifelalamolule ree sulemorife Sebore Lufwa wolu pai bofoo natu na seree neteriemolee nie, te mene amee amee leterinelu kose mwa lebe. ");
INSERT INTO kwo_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Timoti eetetie oonanoofu nembuame rieleeke, menanoofi wolu yesekaleleeke, tetoo nanoo menane na ulu wolilule feti alipolee. Nanoo oone Jisesele menengoi ifelalamoi kaisekli feti lelamoi, te telule ooretatelamwamolu nafe tukwe menane alipolee. Te nelee, oone menane sameme paie paie alamolu menengu, oone glei menengu futi napoomwamo. Mwa. Tetoo oone menane fetaporilu menengu te lemoolane. Te mene mei oonane metie fetamorife, menengu rufomoolanane. ");
INSERT INTO kwo_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Apane wofoliane, mene oone Jisesele menengoi ifelalamolu nale fineke, te ekeni amee ameefi menane glelu glelu oo nembulu riemelee menanoo menengule kaisekli lepomelee. ");
INSERT INTO kwo_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Menekoe oonane wolu rame lemoone, oone Paielufime lalamolufe, tefe nembue menanoo oofulilu amwi feti lelane. ");
INSERT INTO kwo_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Menekoe oonanoofe menanoo Gotelu oofi metie sameme paie paie amoolanane. Tetoo mene menengu eetetie lene, eetegeni paie paie menanoofi metie selime lepoolalee. ");
INSERT INTO kwo_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Krielu lielu mene metie Gotele sameme na woponefoolanane, tetoo menane aikopi lepoleeke, oonanoofile boe rineke yefetamorife, oone Jisesele menengoi ifelalarilu menengufe lulu napoolamoi, tetoo eetegeni menengule boe aikopi ifelemoolanei kaisekli lemorife. ");
INSERT INTO kwo_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Nembue menanoo reekoe i nelane menanoo Aie Gote nali weife Paielu Jisesetu ame menane afweele oorapooneke tetoo oonanoofile boe riebile. ");
INSERT INTO kwo_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Menanoo menengu te eese lelane, Paielu nali ame oonane bofoofu panele ooretatelarilu amee oonanoofi selime seenalemoolali, te ekeni ameetu oona kwaife Gotelu inalilufwale ooretatelamoi, tetoo inalilufwale mei maretekume sameme letelabule, eete mene oonane ooretamoonelu atukweme. ");
INSERT INTO kwo_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Eetetie eetegeni ameefi tetoo Gote oonanoo menengule kaisekli lemoolabe, menanoo Paielu Jisese boe rilali nalilu inalilufwatu mare tetoo oone nalilufe feti lemoke fwagilu amee preme lalamoi yefetamobe, menanoo Aie Gotelu oofi. Marena. ");
INSERT INTO kwo_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Eetetie apane wofoliane, mene oonane glelu glelu amee wolilu mareteku Gotelule wolu fetou namoone Gote nalilu menenguleme nifelarife, te nembue oone eetegeni ameele eketie nifetelamo. Tefe nembue mene oonane metie kuli reenelemoolanei namoolane Paielu Jiseselu bilutu ekeni ameele sameme letewalabu. ");
INSERT INTO kwo_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Oona wolu rame letemo eetegeni na soulu mene oonane fanemoonelu Paielu Jisese nalilu naleme nifelarife. ");
INSERT INTO kwo_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Te Gotelu menengu eese lefolee, oone fime ootu feti lemoke lalamolu, tefe oona glelu glelu reeyemee ameele, eke tukuli taneri ameetu wanelule marekulitu mokeneime letelabu. ");
INSERT INTO kwo_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Tetoo oonanoo ambefu menengu nembulu menengoi tekee namoolaleealeelu genile amwime regi letelamoi, tetoo Gote ooretamoolaleelu ameefi wolilu takilu ameele sameme letewalabu. ");
INSERT INTO kwo_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","Oonanoo ambefu menengu nembulu eke tukuli taneri ameetu waleelu geni kose oonane iremobe eke rawie Gotele rame lefori preme leneke alananelu atukwe. ");
INSERT INTO kwo_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Oone kose oonanoo apane Jisesele menengoi ifelalanelule amee bofoo nembulule letemwabule mani. Eetegeni nembulu menengutu oone eesalu ameefe kose iretelabule mani, nariemuanele tukwe. Eetegeni ameefe mene oonane bebriefe wolu na ifenaferiemoone. Paielu Jisese nali lufwa inepane eesalu fwagilu ameele alananelule ame teie teie aterife lelalee. ");
INSERT INTO kwo_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Gote menafe fieri napoleeluke mena glei fwagilu amee tefoo ameele nifetelanei lalarife fieri napolee, eie, mwa. Nanoo menane fieri napoleeluke mena menanoo oofulilule nalife nifwaneke, te nalilu wolilu takilu ameime lalanei, tetoo nifelarife. ");
INSERT INTO kwo_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Tefe ine eetegeni nale fieleeke, futeni leli, eetete glei lufwalu nale futeni lefolee, eie, mwa, nanookoe Gote nalilu nale futeni lefolee. Eetegeni Gote nali oonane Wolilu Fifrile nifwamolee. ");
INSERT INTO kwo_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Nembue mene oone inalilufwale ooretatelamwamolu nale boe glei lefoofi pilemobile, eie, mwa. Gote nali oonane rame ramelule wolu fanemolee oona kwaife fune ooretafolee fune ooretafolee alarilu ameele, ");
INSERT INTO kwo_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","eetutume oone Masedonialu porite lafwalanelu apanele wofolianele letelamo. Eketie ekeni ameefe mene oonane metie ooretamoolanei kuli reenelemoolarife lelane, ekeni ameeleme sameme letewalabu. ");
INSERT INTO kwo_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Oone oonafe amwime tootookoome lemoke oonanoo ameetume amee amee lelamoi, tetoo rawie inalilufwale yesoufe nini nini preme alamoi lalarife, mene wolume eetefe namoone. ");
INSERT INTO kwo_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Tetoo oone oonanoo oofulilule amwime tootookoo ifeletemoke regi letelamoi tetoo ambolufi lalanelu panele reeyemee letemoke, te te yesou te yesou aikopife oonanoo ameetume amee amee lelamoi lalabu. Oone kose rawie amei lalamoi kame lueri lueri leme lelamoi yesoufe nini natelabule mani. ");
INSERT INTO kwo_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Apane wofoliane, menekoe oone amwime rame lerife, namoolane glelu amee sabei ekepane inalilufwa troonalenelule letelali fetatebile. Te oonanoo menengu kose rufomoolabile mani, eke inalilufwa telu Gotele menengoi ifelalari preme leneke alanelu atukwe, tetoo nanoo ti menefu boe fufurunerilu menengu mei glei letelanei. Mwa. ");
INSERT INTO kwo_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Mena menengu lene, Jisese tafilaleeke te boe ti menefu furaleleefe, tefe mena wolu rame lene, Gote nali Jiseselu kaiseklilutu Jisesele menengoi ifelalanelu pane troonalepoonelule nali boe ame kelapoteleeke, te Jisese nali boe kulifi iferietebe. ");
INSERT INTO kwo_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Mene Paielulu nale oonane alipomenei eetetie namoone, ute Paielu nali boe rilaleelu lietu mena inalilufwa ame oofulilu lalanelu mena glei wolume troonalenelu inalilufwale nambuletebile. Eie, mwa. ");
INSERT INTO kwo_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Paielu nali efenefu tiralerife lelali, usi o nebe, te nalilu ensele nali nembouefe namunefoleelu ame Gotelu fifrile ragoo mwai fulelabe. Tetoo inalilufwa Kraisele wolume menengoi ifelameneke troonalenelu molukwe fufuru nerife lelane. ");
INSERT INTO kwo_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Te ekeni mwi mena inalilufwa inepane ame oofulilu lalanelule neunapoleeke ifwapobe, tetoo mareteku Paielule lie wifulufi alualu ifelebile. Te mena tetoo Paielutu marekulitu same lafwalabile. ");
INSERT INTO kwo_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Tefe oona kwaife eetegeni nale alipoolarife fune aikopi fune aikopi alamoi, tetoo oonanoo menengu mei eetegeni nafime laiemoolabile. ");
INSERT INTO kwo_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Apane wofoliane, nembue mene yesou mareteku ame kurulerife lelanelu nafe glei boe pileneke namobile, eie, mwa. ");
INSERT INTO kwo_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Oona wolu fimo, Paielu rierife lelaleelu lie kame tukuli lufwa kriei rieleelu atukwe lerife lelalee. ");
INSERT INTO kwo_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Te inalilufwa nelanei, “Nembue wolilu oo lelaleefe, mena menengu mutukwe lelane,” tetoo nembuari leteri yesoule ame betige lefobile, eke ari bootefu inali, ari lupolelali tetereefe alaleelu atukwe. Tetoo ekeni yesoule glei pruelefobile. Mwa. ");
INSERT INTO kwo_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Te apane wofoliane, oone glei pilufi lalamolu tetoo oone eetegeni lie lelaleelule fetamoke betige lepobule, eke tukuli lufwa rilali bofoo lufwa fetaleeke betige lefoleelu atukwe. Mwa. ");
INSERT INTO kwo_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Oone mareteku lie platelufi lalamolu inalilufwa, oone liefu, menakoe glei kriefu, pilufi lalanelu atukwe lenei, mwa. ");
INSERT INTO kwo_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Eetetie tefe, mena tootookoome lelabile, kose rofoofe lulabile mani, eke rawie inalilufwa alanelu atukwe. Tefe mena bie fufuruneneke oolelanei, tetoo menengu taki nanepooneke te wolilu menengule falebile. ");
INSERT INTO kwo_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Mena te rame letene, rofoofe lulananelu inalilufwa kriei lulanane. Te inalilufwa melee tefweelule foopooneke biakwai lelananelu, kriei mei biakwai lelanane. ");
INSERT INTO kwo_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Mena tete lie platefu pane, mena wolilu menengu tefoo inalilufwafe lebile. Tefe Jisesele menengoi ifelalanelu ameele tukwe, te rawiele ooretatelarilu ameele tukwe, fatule atukwe sinapobile. Tetoo Gote menafe eetei paie naporife oolefoolanelu amee ekenile mena kaiseklilu sepiole atukwe lukwenuebile, tetoo mena temepooneke, tei kaisekli lelanei amwime regi lepoolabile. ");
INSERT INTO kwo_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Mena glei Gotelu fame menengoi lalarife namunepolee. Mwa. Menafe namunepoleelukoe, menanoo Paielu Jises Kraise nalimeme menafe eetei paie naporife tefe namunepolee. ");
INSERT INTO kwo_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Jisese eete tafilaleelukoe menafe aikopi leporife, tefe mena ame oofulilu lalanelutume, inepane wolu troonalenelutume mena mare ame same lafwalarilu oofulilule falebile. ");
INSERT INTO kwo_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Eetete oona kwaife mei inalilufwale na woliluleme natelamoi, kuli reeneletelabu eke nembue oona alamolu atukwe. ");
INSERT INTO kwo_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Apane mene nembue oonane namoolane, oone bie tupane nambulemorife lelanelu lufwale reeyemee letebu, oonane aikopi lemoolanelule. Paielu nali namunetelee, tefe oonane paielu lufwafe lemoone. Tetoo oonane nale alipomoolanei te oonanoo amee ameele sere letemoolarife. ");
INSERT INTO kwo_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Oone nanoole amwime reeyemee letelabu, tupanelu amee ameele, tetoo tupanele ooretatelarime letelabu. Tetoo oone menengu mutukwetu maretekume alefe alarilu ameetu alabu. ");
INSERT INTO kwo_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Apane wofoliane, mene oonane inalilufwa kame wee napoolananelu panelu amee ameele sere letelamolule tukwe, reeyemee alanei wofri lelananelu panele nembouelu naleme fanetelamolufe tukwe, te Gotele reelufe nifelanelule kuli reeneletelamolule aikopi letelarife tukwe namoolane. Te oone ekepanele kame ragoo tafilutu ifenatelabu. ");
INSERT INTO kwo_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Lufwa ine oonane glelu amee nembulule lemoonei, te oone kose ekeni ameefe fune amee nembulu letebule mani. Oone oona kwaife Gotelu inalilufwale tukwe, preme lalanelu inalilufwale tukwe sameme mareteku wolilu ameeleme fetou natelabu. ");
INSERT INTO kwo_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Oone sameme paie paie alamoi, ");
INSERT INTO kwo_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","te na woponeforife mei sameme letewalabu. ");
INSERT INTO kwo_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Glelu glelu oo oonane binanemoolali mei, oone kame Goteleme paie paie afoolabu, Gotelu i eetetie eese lefolee oonafe, inalilufwa oone Krais Jisesele ifelelamolule. ");
INSERT INTO kwo_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Wolilu Fifri oonane amee amee bofoole lerife menengoi tekee nalemoolali kose ile atukwe unabule mani. ");
INSERT INTO kwo_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Te Gote nali lufwale nafoleelu nale oonane namorife lelali, oone kose eetegeni nale bofoo menengu lefobule mani. ");
INSERT INTO kwo_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Oone ekeni nale lapotelamoke, te na woliluleme bebe nelamoi, ");
INSERT INTO kwo_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","tetoo reeyemee ameele maretekume mokenei letelamoi lalabu. ");
INSERT INTO kwo_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Gote menengu mutukwe amee yewilu. Te nalimeme oonanoo oofulilule mareteku nalife nifwarilu ameele lemoolali, tetoo oone nali kememe lemoke lalabule. Tetoo nalimeme oonanoo reele tukwe, wopulule tukwe mareteku nalife nifwamoke amwime regi ifeletemoolali tetoo oone fwagilu amee preme lalabule menanoo Paielu Jises Kraise boe rierife lelaleelutu. ");
INSERT INTO kwo_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Te Gote oonane fieri namoleelu, oonane ekeni ameele lemorife, tefe fieri namolee. Nali nelaleealeelu naleme mareteku nifetelaleealee. ");
INSERT INTO kwo_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Apane wofoliane, oone menanoofe Gotele na woponefoolamwabu menane tetoo aikopi lelarife. ");
INSERT INTO kwo_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Mena Gotelu inalilufwalu amee eese lelee, oone mwamole mwamole metie telu panele wolilu ameefe kapoonetelamwabu. ");
INSERT INTO kwo_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Mene Paielulu bilutu oonane namoolaie, oone eetegeni lofoo pilule fetalamoi, Gotelu inalilufwale mareteku na natelamwabu. ");
INSERT INTO kwo_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Menanoo Paielu Jises Kraiselu keemakee oonane sameme ifelamoolabee. ");
INSERT INTO kwo_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Mene Pole, Sailase, Timoti, mene eese leneke eetegeni nale oonane pilemoone, oone Gotelu inalilufwa wokoo soulu Tesalonaikai lalamolule, oone menanoo Aie Gotelufi Paielu Jises Kraiselufi lalamolule. ");
INSERT INTO kwo_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Keemakeetu menengu tafilutu lalarilu amee menanoo Aie Gotelufu weife Paielu Jises Kraiselufu oonane metie ifelamoolabee. ");
INSERT INTO kwo_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Apane wofoliane, te krie te krie mene oonane menengu lemoolanei Gotele paie paie afoolanane. Mene eete lemoonelu, nemboue feti lelee. Oone Jisesele menengoi ifelalamolu menengu nali oonanoo menengule seenalemoolali sameme letewalabu, eete oone mwamole mwamole mareteku oona alefe fune fune alamolu menengu oonanoo selimeme lemoolalee. ");
INSERT INTO kwo_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Tete mene mwangife tari Gotelu inalilufwalufile teme wane teme wane alanei, oonanoo naleme mene natelanane, “Tesalonaikane teime kaisekli lelanei te Jisesele menengoi ifelalanelule amee giginaletelanei tetoo glelu glelu fwagilu ameele tukwe, te yesou te yesoufe tukwe, fwagilu amee tefoo pane nembuari letelanei, ree fueletelanane.” ");
INSERT INTO kwo_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Eetetie ekeni yesou oonane lepomoomenelu Gote eesalufe fetou nelee, wolilu ameele lelali, te oonanoo ameele futeni su lemoolaleealee. Oone nembulule berefu petilule atukwe ambuketapoolamolu, oone Gotelu ameime lalarilu ameele yefee lefomo. ");
INSERT INTO kwo_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Tefe Gote oonane inepane oorerei lemoolananelu inalilufwale mei ame futeni su lepoolali, tetoo fune ame oorerei letebe. ");
INSERT INTO kwo_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Eetegeni fwagilu ameele nembue oonane eete lepomoolanelule nali ame unapomoleeke, tetoo oonafe yenaleporilu liele tinebe, menafe mei lebe. Gote ame letebe, Paielu Jisese nalilu enseletu mare ame efenefu rineke lebati lerife lelane, ");
INSERT INTO kwo_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","i rilutu. Tetoo ekenitu ine Gotele ame rame lefori preme leneke, te menanoo Paielu Jiseselu na ulu wolilule niferife ulabee nenelule ame teietebe. ");
INSERT INTO kwo_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Eetepane ame teteree marekulitu falelarife lelane. Nanookoe Jisesele tukwe, Jiseselu kaisekli soulu takilule tukwe ame mokenei lefoolabile. ");
INSERT INTO kwo_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Gote namunefoleelu lie, ekenitu Paielu ame rieleeke, mareteku wolu Jisesele menengoi ifelalanelule ame Jiseselu bilule mwai lefoolanei, paie paie feti afoolabile. Te oone mei ame mare paie paie apobule, Jiseselu nale mene oonanoofi alipomoonelule, oone wolu nifemo oonanoo menengutu. ");
INSERT INTO kwo_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Eetetie eese lelee, te krie te krie menanoo Gotele na woponefoolanane tetoo oonane aikopi lemoolarife. Menanoo menengu eesalu lene, nali oonane fieri namoleelu nalilu amee ameele lelarife, oonane ame seenalemoleeke, tetoo oone Gotele niferilu amee yefee lefobule. Mene Gotele na woponefoolanane nali tetoo oonane nalilu kaiseklilutu kaisekli ifelemoolali, oone tetoo te amee te amee mareteku woliluleme letelarife lelamolule tukwe, te glelu glelu amee oonanoo Jisesele menengoi ifelalamolu menengu nali oonane seenalemoolarife tukwe, tefe oone ame eese lelabule. ");
INSERT INTO kwo_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Menanoo Gotelu keemakeetume Paielu Jises Kraiselu keemakeetume oonane lemooneke, tefe oone ekeni ameefi Paielu Jiseselu bilule mwai lefoolamoi, tetoo oonanoo bilule mei mwai lemoolabe. ");
INSERT INTO kwo_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Apane wofoliane, nembue oone futeni amwime lelabu, mene menanoo Paielu Jises Kraise boe ame rierife lelaleelufe tukwe, mare lukulerilu nafe tukwe namorife lelane. ");
INSERT INTO kwo_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","Sei, lufwa telu oonane Paielulu lie nanookoe wolu sekalelee namoone pai. Te lufwa bofoo menengu eesalule lelee, Wolilu Fifri nali eesalu na buburele natelee pai nelee, te lufwa bofoo Gotelu nale alipotelali, eetegeni nale nelee pai, mena eesalu nale lofoofi pi leneke fatietene. Eie, ulabee, oone boe eesalu nale akeporite fimoi, oone kose betige lemoke, oonanoo menengu ti napomoolabile mani. ");
INSERT INTO kwo_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Oone kose tutule tefoo lufwa bofoole ooloome lefoolamoi nalilu ameetu wafoleelu nale namoolali eetele kose fiefobule mani. Eetegeni oo glei kame riebe, mwa. Bie inalilufwa kame Gotele oorerei lefoolabile, te Gotelu na kaiseklile futeni lefoolaleealeelu lufwa tetoo ame lebati lerife lelalee, eetegeni lufwa tetereelu same lafwalarilu wokei nembuari lerife lelalee. ");
INSERT INTO kwo_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Nanoo ame te yesou te yesoule mareteku lufwa nalilu gotele atukwe rufoeneke amee amee lefoolananelule ame oorerei letelabe. Te ame mwate mwate ameele letewalali nalifeme nambulelali, tetoo nalilu biluleme mwai lelaleealee. Tefe, ame Gotelu ite menei lafieleeke lalali, te nalimeme ame nebe, “Mene nia eetetie Gote.” ");
INSERT INTO kwo_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Mene ekei oonanoofi lamiei, oonane eetegeni yesoufe wolu namwie. Oone wolu pai menengu futi natemo? ");
INSERT INTO kwo_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Te oone wolu rame lefoomo, nembue ekeni lufwalu afweele muli lefoolaleelu yesoule. Nanoo ame lebati lebe, lie Gote nali nanoole rierife namunefoleelu lietu. ");
INSERT INTO kwo_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Te nembue Gotelu na kaiseklile futeni leforilu ameele angime lelalee, tetoo eetegeni lufwa nanoolu afweele muli lefoolaleelu nanoo ame ree falefobe. ");
INSERT INTO kwo_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Tetoo Gotelu na kaiseklile futeni lefolee aleelu lufwa ame lebati lebe. Te Paielu Jisese kame ragoo fifrilutu teiefoleeke tafilabe, te nalilu efenefu takilu fefelutu atukwe lebati sekapolebe, te ekeni lufwale teiefoleeke suagri preme lebe. ");
INSERT INTO kwo_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Sebore Lufwa nali Gotelu na kaiseklile futeni lefolee aleelu lufwalu reelufe lelee, nalilu bialitu lelee, te kose kose ameetu, glelu glelu ambrei amee ameele tukwe lelee. ");
INSERT INTO kwo_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Te kose kose fwagilu amee mareteku ekepane inalilufwa nembuari lerilu afweeme walanelule ame tutule nale natebe. Gote nanoo nalilu marena nale ifenatemelee, eetei paie naporife, mwa, marena nale ulabee nafoone. ");
INSERT INTO kwo_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Tefe Gote nanoolu menengule ambeme leterife teietelee, tetoo nanoo kose kose naleme menengoi bebenelabile neleeke. ");
INSERT INTO kwo_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Tefe inalilufwa mareteku marena nale glei menengoi luaneke, te kame nalilu fwagilu ameele leterife paie paie alanelu, nanoo ame Gotelu nafi yenalepobile. ");
INSERT INTO kwo_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Mwa. Apane wofoliane, Paielu oonaneme ooretamoolaleealeelu inalilufwa, mene oonanoofe Gotele metie paie paie afoolanane. Gote oonane wolumeme namuneteleelu inalilufwalu weelufi lalarife namunemolee, tetoo eetei paie naporife. Wolilu Fifri oonane seenalemoolaleefe, tefe oone Gote nalilu inalilufwa wolilufeme lemolu amee ameefe tukwe, te nalilu marena naleme menengoi luamolufe tukwe, tefe eetei paie nemo. ");
INSERT INTO kwo_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Nanoo menengu leleelukoe oone tetoo menanoo Paielu Jises Kraiselu selilu kaiseklilu bilu ambei lafoolarife, tefe oonane nali wolu fieri namolee eetegeni na ulu wolilu mene oonane alipomoomenelu nafi. ");
INSERT INTO kwo_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Tefe apane wofoliane, oone kuli kaisekli lemoke temepoolamoi, Gotelu na mareteku mene oonane wolu ragootu lofoo pilutu nafwamoonelu nale tukwe oone eetele nifetelabu. ");
INSERT INTO kwo_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Menanoo Paielu Jises Kraise nali, menanoo Aie Gotetu nanoo menafe ooretaporime lenelu, nali menanoo menengule mutukwe lepolee, tetoo amwi feti lafwalarife lelanelule tukwe, Jiseselu menengutu Gotele oolefoolanei menafe amwi feti lepoolarife tukwe, eetete nalilu menengu pepetu menafe eese lepolee. ");
INSERT INTO kwo_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","Te nanoo oonanoo menengule amwi sere letemoolali tetoo oone te amee te amee woliluleme letelarife tukwe na woliluleme nelarife tukwe aikopi lemoolabe. ");
INSERT INTO kwo_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Apane wofoliane, mene na bofoole eete talane. Eetegeni na eetetie eese lelee, oone metie Gotele na woponefoolabu, tetoo nanoo menane aikopi lepoleeke, tetoo Paielulu nale teme teme ifalanei, tetoo eetegeni nale reeyemee lefoolabile, oone lemolu atukwe. ");
INSERT INTO kwo_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Eete mei oone menanoofe Gotele na woponefoolabu, tetoo nanoo menane aikopi leleeke, fwagilu ameele alananelu panelu amefule neunapobe. Oone wolu rame letemo, inalilufwa nanoo glei motukwe Jisesele menengoi ifelalanei. ");
INSERT INTO kwo_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Mwa. Paielu glei te menengu te menengu alaleealee. Tefe nali ame oonane seenalemoolali, regi lemoolabe, Sebore Lufwalu amee nembulufe. ");
INSERT INTO kwo_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Te mena oonanoofe wolu rame lene, Paielu nali eketie oonane lemolee, tefe mene oonane te amee te ameele mareteku letelarife namoonelule eketie letelamo. Tetoo sabei mei oone metie sameme letewalabule. ");
INSERT INTO kwo_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Mene menengu eese lene, Paielu nalimeme ame oonanoo menengule eetememe walabu namoolali, tetoo oone inalilufwale ooretatelamolu amee eketie Gotelu ameetu wafolee, tetoo oone Kraiselu ameefi temepomoke oo nembulu binanemoolali Jisese nali letewalaleelu amee atukweme letewalabule. ");
INSERT INTO kwo_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Apane wofoliane, mene oonane menanoo Paielu Jises Kraiselu bilutu, na kaisekli lemoolane, apane telu kuli amee wogrineri preme wee napoolananelu panele, mene natenelu nale nanoo niferi preme lelanelule mokeneime letelabu. ");
INSERT INTO kwo_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Oone tele rame lemo, oone menanoo amee amee akerie akeriefeme lemoke alabu, mene oonanoofi lamenei, glei kame lapruelemenei, mwa. ");
INSERT INTO kwo_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Mene oonanoo amefu fori yesoule glei preme peenemoomene, mwa. Menekoe metie bwaleetumeme peenemoomene. Mene krielu lielu, metie amee woponerife foofooki lemenei rafu rafutu lemene, mene oonane menane amee feenanerife oonanoofi glei fatiemobile nene. ");
INSERT INTO kwo_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Mene fori yesou oonanoofule peenemorife glei ulabee nene. Menekoe nemboue peenemobile, mwa. Eete glefe, mene oonane afoi sinamoone, oone tetoo wolilu amee ameeleme lelarilu akerie akeriefe. ");
INSERT INTO kwo_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Te mene ame oonanoofi lamenei, tetoo mene oonane namoomene, lufwa amee amee lerife ulabee neli, tetoo nanoo fori yesoule kose falebe mani. ");
INSERT INTO kwo_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Mene oonanoofu telu kame wee napoolananelu panelu nale wolu fietene, nanoo amee amee bofoo glei lepolenane, mwa. Nanookoe kame telu panelu amee ameefe na faletewatelanane, eete glei nanoolu amee amee. ");
INSERT INTO kwo_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Eesalu lufwa oonanoofu nanoo Paielu Jises Kraiselu pane, tefe mene nanoole na kaiseklile tukwe kuli reeneletelanelule tukwe eese natelane, te nalilu ameetume amee amee lelanei, tetoo fori yesoufe tukwe nalife aikopi lelabile. ");
INSERT INTO kwo_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Apane wofoliane, oone wolilu ameele lelamolule boe kose amee teponuebule mani. ");
INSERT INTO kwo_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Te lufwa bofoo nali na mareteku mene lofoofi piletenelule nifeteri preme leli, oone eetegeni lufwale amwime oosunalefomoke rame lefomoi, tetoo mokeneime lefomoke lalabu. Nanoo ame nali alaleealeelu ameefe reeyemee lebe. ");
INSERT INTO kwo_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Mene glei oonanoo menengule eesalu lufwale nanoo oonanoo oorerei lufwa namoone, mwa. Oonanoo menengoi nanoole “Ape,” nafomo, tetoo na woliluleme na fatiefobu, nanoolu menengule amwi sere leforife. ");
INSERT INTO kwo_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Paielu, nanoo menengu mutukwe amee yewilu, nalimeme tetoo oonanoo menengule mutukwe lemoleeke lalamoi, eetegeni ameele lelarilu yesoule sameme teme teme letewalabule. Paielu oonane marekulitu ifelamoolabee. ");
INSERT INTO kwo_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Mene Pole mene niameme eetegeni na wolilu lie namwielu nale pi lemwie. Mene eetetie eesalu nale lofoofi pi letiaie, lofoo pilu mareteku mene letiaielufi. Eetete menanoo amee amee lofoo pilu mareteku letelaiei eesalu nale pi letiaie. ");
INSERT INTO kwo_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Menanoo Paielu Jises Kraiselu keemakee wolilu oonane mareteku ifelamoolabee. ");
INSERT INTO kwo_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Mene Jemse mene Gotetu Paielu Jises Kraisetu weife nanoolu amee ameele letelaielu lufwa. Mene eetegeni nale pilieke, oone tialootu tialootu lemolu weelu Israelefu eke brune brune amoke rawie inengume letewamoke laprufwamolule namoolaie. Oone amwi pe lalamo? ");
INSERT INTO kwo_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Apane wofoliane, oone glelu glelu oo nembulule fetatelamoi tetoo eetegeni inengufu fwagilu amee lerife menengu tekee namoolalee, te oone eetegeni oole fetatelamoi oonanoo menengu kose ti napomoolabile mani, mwa, kame paie paie alabu. ");
INSERT INTO kwo_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Eete eese nielu glefe? Yesou eke kurulemoonelu eetete oonanoo menengu Gotelufi laiemoolanelule sulemorife, tetoo oone Gotelufime amee giginalelarilu amee, nalilu naleme niferilu amee tetoo lebati lemobile. ");
INSERT INTO kwo_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Te eetegeni amee bolelutu lemoonei eetete oone wolu oonafe mumusi lemo, tetoo oone Gotelu amee amee bofoofe glei lulunapobule. Mwa. Eesalu oo nembulule fetalamoi, tetoo oone amwime lalabule. ");
INSERT INTO kwo_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Te oonanoofu inali o lufwa Gotelu menengule amwime nifeforilu menengu preme leli, eetete nanoo Goteleme na woponefobee, te Gote ame wolilu menengule fanebe. Nanoo raue tefoo, wolilu menengule mareteku nifwatelaleealee, glei tupu na nateleealee. ");
INSERT INTO kwo_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Te nanoo Gote nalilu menengutumeme na woponefobee, kose menengu te me te me lefoolaleelu menengutu na woponefobe mani. Nanoo eesalu menengutu na woponefoli, nanookoe melee bolefoolali genapoolanelu atukwe lefolee. ");
INSERT INTO kwo_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Eesalu inali o lufwa kose yesou Paielulu amefule ame “falefe” nebe mani. Mwa. ");
INSERT INTO kwo_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Nanookoe glei menengu mwamole tefoo. Nanoo glei mwamole ameeleme nifelaleealee. ");
INSERT INTO kwo_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Te Jisesele menengoi ifelalaleelu inali o lufwa nanoo yesoufe feepoe lefaleleeke lalaleelu, nanoo kame menengu mutukwe leleeke lalabee. Gote nanoolu bilule ame mwai fatiefobe. ");
INSERT INTO kwo_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Te bwalee pumwai lalaleelu inali o lufwa mei menengu mutukwe leleeke lalabee, Gote ame fime porite sinebe. Eete glefe, nanoo ame nanambuli leeloo atukwe ploofopoleleeke, mwa lebe. ");
INSERT INTO kwo_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Eetete lie soulu gaga feti naferieli, te nanambulile alifefoleeke falu lepoonane. Te leeloo ploofopoleleeke yeferaleli tetoo oo pifelefoleelu ranilu mei mwa lefobe. Eetutu inali o lufwa bwalee pumwai lalaleelu, te glelu amee ame lalali alaleealeelufi nanoo mei mareteku i atukwe tareeneterepooneke mwa lepobile. ");
INSERT INTO kwo_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Inali o lufwa oo nembulule fetaleeke, te eetegeni nembulufi lalali, Gotele menengoi ifelalaleelu menengu, eetele glei menengu futi neleelu, eetete nanoo nemboueme paie paie feti alabe. Nanoo sulefoleelu wolu buruanalefolee, tefe Gote sameme lafwalarilu oofulilule nali wolu nasi nateleelu inalilufwa nalifeme ooretafoolanelufe fanetebe. ");
INSERT INTO kwo_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Tefe fwagilu amee bofoolu menengule irefoleeke, te fwagilu amee leleeke lalali, te nanoo kose eese nebe mani, “Gote nali irewoleeke eetegeni ameele lie,” eie, mwa. Fwagilu amee Gotele glei irefoonane. Te Gote nali glei fwagilu amee lerife iretelaleealee. ");
INSERT INTO kwo_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Eetekoe mena mwamole mwamole inalilufwalufu nembulu menengu tekee napoolananelu nali, fwagilu amee lerife menengule irepoolanane. Tetoo nalime noopoo natelanei, tetoo menengu fufuru natenane. ");
INSERT INTO kwo_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Tetoo eetegeni tekee natelanelu nembulu menengule arile atukwe terieleeke, tetoo fwagilu ameele lupoleli, te eetegeni fwagilu amee selime lefoleeke, esulu troole gliebe. ");
INSERT INTO kwo_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Mene ooretalemoolaiaielu apane wofoliane, kose oonanoo nembulu menengu oonane iremobile mani. ");
INSERT INTO kwo_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Wolilu yesou mareteku rauefe nifwaterilu amee, nanookoe efenefu rilanane. Eetegeni Aie nali mwafu takilu yesoule leteleelu, nanookoe glei bofoo ameetu leleealee, lie yemelarilu keme wamolume lelee, turume lelee alaleealee, mwa. ");
INSERT INTO kwo_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Nali menafe fime ootu leleelu oofulilule tinepolee, tefe nali menane nembouefeme nalilu weelufe leneke lalanei, mareteku inalilufwale tukwe, yesoule tukwe nalilu marena natu woli lepolee. ");
INSERT INTO kwo_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Mene ooretalemoolaiaielu apane wofoliane, oone eetele amwime rame lebu, inalilufwa mareteku oone bofoolu nale futeni amwime letelamwabu, oone kose afetelime na glietelamoi, fame na natemwabule mani. ");
INSERT INTO kwo_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Eetete, inalilufwalu fame menengu Gotelu wolilu amee ameele glei nifetebe, mwa. ");
INSERT INTO kwo_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Tefe oone glelu amee ootukwe lemoonelule tukwe, te glelu amee nembulu oone sameme alamolule tukwe mareteku metie grialetebu. Te oone oonafe reeyemee ameetu eetegeni na Gote nali wolu oonanoo menengoi luamoleelule nifelamoi, tetoo Gotele reeyemee lefoolabu. Eetegeni nafi tetoo oone paie napobule. ");
INSERT INTO kwo_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Eetegeni na oone wolu falemolule oone nifebu. Te oone kose futeni futeni preme. Oone eese alamoi, eetete oone oona kwaife kose kosefe alamo. ");
INSERT INTO kwo_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Eetete, inali o lufwa Gotelu nale futeni lefoleeke, te niferi preme leli, nanoo melei nalilu oofwafwaleele amwimeme oo sere lefoomeleelu inali o lufwa atukwe lelee. ");
INSERT INTO kwo_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Nanoo nalife wolu oo amwi sere lefoleeke, te grialeleeke wali, esulu nalilu oofwafwaleele akeke lefoleeke lafoolaleelule menengu futi nebe. ");
INSERT INTO kwo_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Mwa, Gotelu na kaisekli eetegeni nali menafe afoi sinapoleelu, tetoo mena ekeni fwagilu ameele buruanalefooneke, tetoo mena eetei paie naporife lepolee. Te inali o lufwa Gotelu nale amwime fetaleeke, te eetegeni nale nifeforime leli, tetoo Gote nanoole aikopi lefoleefe tefe nanoolu amee amee mareteku letelaleelu nemboue feti lebile. Nanoo kose nale futeni fieleeke, afeteli menengu futi nebe mani. ");
INSERT INTO kwo_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Eetete inali o lufwa menengu eese leli, nanoo Gotele reeyemee lefoolali paie paie afoolarilu amee laoolalee neleeke, te eetegeni menengutume nanoo nalilu ragoole amwi footepori preme leli, eetete nanoo kame reelufe alaleealee. Tefe, Gotelu amee amee nanoolufu, mwa, bolelu preme lefobe. ");
INSERT INTO kwo_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Gotele reeyemee lefoolalu paie paie afoolarilu amee, eete nanoo menanoo Aie Gotelu menengufu amee, nanoo glei inengufu nembulu menengutu sagoo lenei, mwa, eete eesalu ameefe nelee, ambli arile, seikolu inalile, ambli ambli lepoolanelule oo fetatelarife. Eete mei menafe eetegeni inengufu nembulu menengule tukwe fwagilu ameele tukwe lerife, amwime tootookoo lelabile. ");
INSERT INTO kwo_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Apane, wofoliane, oonanoo menengu, metie Paielu Jises Kraisetu lalarilu ameele lelamwamolu ameetu, oone kose boe eetegeni ameetu inalilufwa paie tefooleme menengu ooretaletelamwabule mani, mwa. ");
INSERT INTO kwo_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Eetete, lufwa bofoo oonanoo luku luku iteile leeloo wolilule sinapoleeke amee rani keelu keelu aleeke wopreieli, te eketume feepoelu lufwa mei nanoo leeloo reekee tefoole sinapoleeke yepreielee. ");
INSERT INTO kwo_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Te oone eetegeni lufwa wolilu rani tefooleme eese nafomoi, “Sei, oone eeteise amwi reeafwee wolilufi lafie,” te feepoelu lufwale eese nafomoi, “Oone kame eeteise temela,” o, “Kame nianoo kuli bwagei lafie,” nafomoi, ");
INSERT INTO kwo_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","eetete oone lufwa bofooleme menengu ooretalefoolalualu, te oone kame nembulu menengutu nale fipwaletelaleealeelu lufwa atukwe lemo, tetoo feepoelu lufwale mei glei eesalu menenguleme letelamwamo, mwa. ");
INSERT INTO kwo_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Mene ooretalemoolaiaielu apane, wofoliane, bie filabu. Gote eetegeni inengufu feepoelu lufwale Gotele menengoi ifelalarilu amee menengu selime feti letelarife namunetelee. Te nanoole nalilu amei lalarife, eke nali wolu nasi leteleelu inalilufwale nalife ooretalefoolananelule faneterife lelaleelule namunetelee. ");
INSERT INTO kwo_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Mwa, oone feepoelu lufwale reeyemee nifwatelamwamo. Te yesou pumwai lalanelu lufwa nembulule fanemooneke fime wogrinamoolanane. Tetie nalime oonane bebenamooneke nale fipwaletelananelu tekoile ifwamoonane. ");
INSERT INTO kwo_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Eete mei nanooboe Kraiselu wolilu bilu oonanoofi lamoolaleelule teiefoolanane. ");
INSERT INTO kwo_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Tefe mena bie eetegeni soulu menengutu Jiseselufime Gotelufime lalanei niferi niferime lefoolabile, eke Gotelu na bebriefe pileneke lalaleelu, eetetie eese nelee, “Oone mwamole tikliafweefule ooretate, eke oonafe ooretalalualulu atukwe,” oone amwi niferime lefoolamoi, eetete oone wolilu ameele lelamo. ");
INSERT INTO kwo_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Mwa, oone kose teluleme amwi amee sere sere atelamoi, te prelu panele kame ooloome letelabule mani, eetete oone wolu fwagilu ameele lemo, te eetegeni Gotelu na kaiseklile buruanaletemwamolu lufwafe lemo. ");
INSERT INTO kwo_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Te oone Gotelu na kaiseklile mareteku amwi nifetelalulu, mwa, oone kame na bofoole eetegeni nafi lalaleelu niferi preme lelu, eetete oone wolu Gotelu na kaiseklile tatukweme buruanaletelananelu inalife, lufwafe lelu. ");
INSERT INTO kwo_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Glefe, nanoo wolu eese nelee, “Oone inali tefoo lufwa, lufwa tefoo inali, oone tukuli taneri amee preme,” eetegeni Gote mei nelee, “Oone kose lufwale o inalile, teiefoluke tafilabe mani, mwa.” Te oone tukuli taneri amee preme alalulu, te, oone kame lufwale teiefoluke tafilali, eetete oone wolu Gotelu na kaiseklile futeni lefoolalualu lufwafe leluke lalalu. ");
INSERT INTO kwo_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Oone amwi eetegenile rame lebu. Gotelu na na kaiseklile nembulu kaiseklilule buruananeteleeke tetoo mena eetei paie napoolanelu nali menanoo nale, amee ameele tukwe ame futeni su letelabe. ");
INSERT INTO kwo_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Eete glefe? Ine bofoole glei keemakee lefoli, te Gotelu nafi yenalefoolali lafetefobe. Gote glei nanoole keemakee lefobe, mwa. Inele keemakee atelaleealeelu Gotelu nafi glei yenalebe. Mwa. ");
INSERT INTO kwo_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Apane wofoliane, inali o lufwa eese neli, “Mene Gotele menengoi ifelalaiaie” neli, te nanoo wolilu amee amee preme leli, akeke leleeke aikopi lefobe? Gotele menengoi ifelalaleelu menengu kame lafoolali, mwa, glei paie nefalebe. ");
INSERT INTO kwo_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Te ape bofoo, wofoli bofoo leeloo letifelu bofoo lafoolari preme lefaleleeke, te fori yesoufe mei lielu lielu lulunelaleealeelu lalali, ");
INSERT INTO kwo_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","te oonanoofu bofoo nafoli, “Oone kame menengu mutukwe leluke wafale. Oone bebeti leeloo wolilule sineluke te kakali leluke yelu lewobee,” mwa, oone glei reefu yesoule nifwamo. Eesalu na kame ragoolufe nelanelu, akeke leleeke aikopi letebe? Mwa. ");
INSERT INTO kwo_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Gotele menengoi ifelalarilu menengu mei eetegeni atukwememe lelee. Nanoo bofoole glei aikopi lefoli, eetete nanoolu menengu mwa, preme lelee. ");
INSERT INTO kwo_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Mwa, inali o lufwa bofoo ame nebe, “Oone Gotele menengoi ifelalalu, te mene aikopi ameetu lie.” Te mene nanoole fune na nafofe, “Tetoo oone Gotele menengoi ifelalalulu menengu oonanoole menane akeke leluke fetou nawole, nanoolu aikopi amee oonanoofi laoolari preme lewoli? Mwa. Mene bofoole aikopi lefoolaielu amee nali eetegeni Gotele menengoi ifelalaielu menengule oonane ame lebati fetou nawofe.” ");
INSERT INTO kwo_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","“Mwamole Goteleme lalalee” oonanoo menengu wolu eese lewoleeke laoolali, eetete oone nembouelu menengule lelu. Te naifofu mei menengu eese leneke, wofrife pupunapoolanane. ");
INSERT INTO kwo_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Oonekoe ipoe preme lelulu, ooneboe amwi pe rame lerife, oone glei bofoole aikopi letelalu, mwa, eke Gotele menengoi ifelalananelu menengu eetete oonanoofi kame preme lelee. ");
INSERT INTO kwo_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Abrahame, menanoo fetali, te nalilu lefoo Aisekele Gotele fanerife ti rigani pumwai soobonaleleefe, tefe Gote eetegeni ameele fetafoleeke te nafolee, “Oone lie platefu lufwa.” ");
INSERT INTO kwo_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Oone wolu fetamo Abrahame Gotele menengoi ifelameleelu menengu, wolilu ameetume wafoone, tetoo ekeni Gotele menengoi ifelameleelu menengu metie lebati lefolee. ");
INSERT INTO kwo_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Bebriefu alina Gotelu pilu eetetie eese neleelu, “Abrahame Gotele futeni mwamole lefoomelee, tefe Gote Abrahamele nafolee, lie platefu lufwa,” te nanookoe Gotelu ambrefe lelee. ");
INSERT INTO kwo_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Nembuete rame lemo, inali o lufwa nanoo wolilu inalife lufwafe lenanelu, Gotele futeni mwamole lefoolaleealeelu ameetu lefoone, ekeni inali o lufwa glei wolilu inalife, lufwafe lenanelu kame Gotele menengoi ifelalaleelu menengu lenei, eetete mwa, nanookoe kame bofoo bofoole aikopi letelaleelu ameetu lelee. ");
INSERT INTO kwo_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Eetutume lelee afoi temelaleelu inali bofoo Rahape, nanoo mei wokoo afueterife wanelu lufwale neunateleeke, te ambutenueleeke ifelatemelee. Te sabei boe nali bofoo afweeme sinateleeke wanelufe, tefe Gote nanoole lie platefu inali nafolee. ");
INSERT INTO kwo_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Tefe ree kame menengu yefoo preme leli, nanoo wolu tafilalee, te eetegeni atukwememe lelee, Gotele menengoi ifelalaleelu menengu, wolilu amee preme leli, eetete wolu tafilaleeke lalalee. ");
INSERT INTO kwo_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Apane wofoliane, oonanoofu kose ramelu tefoo lufwafe motukwe lebule mani, oone bie rame lebu, mena maretekume Gotelu nafi yenalepoolanei, Gote ame sabei mena ramelu tefoo lufwale amwimeme ootu ootu leporife lelalee. ");
INSERT INTO kwo_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Glefe, mena maretekume mumu apoolanane. Te lufwa bofoo nanoo nali nelaleealeelu nafi nembulu na bofoo glei nepolelee aleelu, eetegeni lufwa nanoo wolilu lufwafe lelee. Nanoo wolu menengu keke naleleefe tefe telu telu ree nalilufule ame mareteku amwime tootookoo letelabe. ");
INSERT INTO kwo_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Te mena aine monguelu tukweelu fetile hoselu ragoi wopoorenueteneke, te mweele liliapoteneke eetei amee bebeneneke ifatelanei, tetoo nanoo menanoo menenguleme nifelanane. ");
INSERT INTO kwo_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Brai soulule mei fetatebu, nanoo mei selilu feti yesou. Fifri soulu nalimeme puletewatenei, tetoo brai soulule ifalaleelu lufwa kame riago kelu yesoutu meleele brai soulu guelufi fuelefolee fuelefolee ifwafwali, tetoo glelu porite nanoolu menengu warife wolu leleelumeme wanane. ");
INSERT INTO kwo_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Te menanoo ragoo mei eetutume alanane. Nanoo yesou tukweeluboelu, menanoo reefi lalaleelu, nanoo metie bibinelali glei belenane mwa. I leelu tukweelu fetabu, ambo soulule mei yesoutu falu letewanelule, nemboue tatukwe kopriletewabe. ");
INSERT INTO kwo_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Ragoo nanoo metie i atukwe lelee. Nanoo telu telu ree mare menanoo reefi lalanelu. Mareteku eetegeni inengufu fwagilu amee ragoo tefoo lufwafe leleeke latelalee. Nanoo ree retilule tatukwe fwagilu ameetu lerife teiefoolaleealee. Nanoo yemelariluleme metie tatukwe teiefolee, ile atukwe fufafwalaleealee, eetete teteree sameme falemerilu wokoo i nali fufafwalaleealee. ");
INSERT INTO kwo_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Inalilufwa glelu bole ambofule, kaulefule, kawee, te mwi melefu bolele tukwe, neunateneke amefleefe gipoolanane. ");
INSERT INTO kwo_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Mwa, inalilufwa mareteku, nanoolufu bofoo glelu glelu na nembulu nerife glei ble nafobile. Nanookoe nembulu feti yesou, lufwa glei belebe mwa, ambookwanee fweelu atukwe lelee, lufwale inengu menei sinateleealee. ");
INSERT INTO kwo_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Mena mei eetegeni ragootume, Aie Paielule, paie paie afoonane, te Gote nali atukweme leteleelu inalilufwale mei nembu na naterife boe eetegeni ragootumeme na natenane. ");
INSERT INTO kwo_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Te na wolilutu, na nembulutu mei mwamole ragoomeme nelanane. Apane wofoliane, eetegeni amee kose eese alabile mani, mwa. ");
INSERT INTO kwo_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Nemboue pe inengu menefu rilaleelu melee gugufi rilutu wowilutu sagoolebile? ");
INSERT INTO kwo_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Apane wofoliane, nemboue pe ka foieboo mekeie ooloofe lebile? Nemboue pe mweeo weelufi ka foieboo ooloo kweinapoolabile? Tetoo inengu menefu rilaleelu gugu meleefi, wowilu rutulaleealeelu boe glei rilu meleefe lebe. ");
INSERT INTO kwo_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Oonanoofu bofoo ine amwime tootookoo lelaleealee? Eesalu amee tefoo lufwa lalali, eetete nanoo lie platefu, eke lelaleelu wolilu ameele lebati fetou natebee. Eetegeni wolilu menengu lafoolalee, nanoo ambei lelali, reeyemee letelabee. ");
INSERT INTO kwo_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Oone yesou pepere lefori ameele, legulu ameele, oonafeme menengu lemerilu ameele, fune boore fune boore ameele, oone eetegeni ameele sabi sabi ifenatelamoi, kose ekeni menengutu Gotelu marena nale bibinelamwabule mani, mwa. ");
INSERT INTO kwo_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Eesalu nembulu wari warielu amee, eete glei mwafu rielee, eie, eetekoe fime eetegeni inengufu lufwalu, glei Wolilu Fifrilu, Sebore Lufwalu amee. ");
INSERT INTO kwo_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Glefe, ekeni legulu menengutu, oonafeme menengu lemerilu amee fune boore fune boore alananelufi alamolu amee, eetete fime fime alarilu ameetu, te amee te amee nembulutu mei alanane. ");
INSERT INTO kwo_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Te wolilu ramelu menengu, nanoo Gotelufu rielee, eetete fwagilu amee prelu, tetoo menengu amwime lelali alefe alarilu amee, tootookoo lelali, reeyemee letelarilu amee, telule keemakee leteleeke, wolilu ameele letelee aleelu eesalu tefoo lufwafe lerife leteleealee. Nanoo mei mareteku inalilufwale eetetie eesalu ameeleme letelabee, tetoo nanoo niferime lelabee. Nanoo glei meme ameetu lalali, mwa, wolilu menenguleme nifelaleealee. ");
INSERT INTO kwo_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Te fame menengule unapoolananelu pane, nanoo yesou fleeloole atukwe rinelanei, tetoo sabei wolilu amee balifu yesou atukwe serinapoolanabile. ");
INSERT INTO kwo_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Soulu apureleri eke oonanoofi lemoolaleelu geniboe glelu yewilufe? Te fame menengu gliemoonanelu mei oonanoofi lemoolaleelu glelu yewilufe? Eetekoe oonanoo nembulu menengu tekee napomoolananelu nali tetoo oonanoo reele fooroo fooroo ifamoolananelu ekeni nali kworoofame lufwa atukwe leneke, oonanoo ree telu telufi apure lelanane. ");
INSERT INTO kwo_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Yesou peenerife menengu ti napomoolananelu, mwa, oone glei peenemwamo. Tefe oone oona kwaife bofoo bofoole teietelamoi troonanelamwamo. Te oone yesou peenerife menengu rune rune letelamwamolu, mwa, glei peenelamwamo. Tefe oone oona kwaife fame menengu lemoolanei, tetoo soulu aleri lelamwamo. Oone yesou peeneri preme lelamwamolu glefe, oona Gotele na woponefori preme alamwamo. ");
INSERT INTO kwo_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Oone Gotele na woponefoolamoi, te oone yesou peeneri preme lemwamolu, oona kame oonanoo reele fooroo fooroo ifatelamo. ");
INSERT INTO kwo_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Oone yemee seiko alananelu pane atukwe, eetegeni inengufu fwagilu ameele mou ambrefe letemolu eesalu amee eetete Gotele oorerei lefoolarilu amee, oone eetele glei pai rame lemo? Tefe ine eetegeni inengufu fwagilu ameele mou ambrefe leteleeke lalarife neli, nanookoe wolu Gotelu oorerei inalife, lufwafe lelee. ");
INSERT INTO kwo_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Gote nali nalilu yemelarilu menanoofi lualeelule ooretalelali, tetoo nanoolufime marekulitu lafoolarife, eetegeni nale bebriefe pileneke lameleelule oonekoe eese pai nemo, yewilu prelu na? ");
INSERT INTO kwo_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Mwa, nanoo metie nalilu inalilufwale keemakee letelaleealee, eetegeni yewilufe tefe na neleeke lalalee, “Gote mwate mwate tefoo inalilufwale oorerei letelali, te reeyemee tefoo inalilufwale keemakee letelaleealee.” ");
INSERT INTO kwo_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Oone Gotele reeyemee lefoolabu. Tetoo Sebore Lufwale oorerei lefoolamoi, tialebe. ");
INSERT INTO kwo_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Te oone Gotele roboime wolefobu, tetoo nanoo mei oonane roboime yelemobe. Oone oosefi ifenatelananelu, oonanoo amee boe wolilufe lemobi. Te oone menengu are lemolu pane, oone eetegeni nembulu menengu oonanoofule grialeterime lebu. ");
INSERT INTO kwo_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Menengu rufotemoke, keemakee letelamoi, kame eeleme natelabu, inengu reetu lalamoi. ");
INSERT INTO kwo_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Oone Paielule reeyemee lefoolabu, tetoo nali oonane ame paielu inalilufwafe lerife lemobe. ");
INSERT INTO kwo_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Apane wofoliane, oone kose Gotelu inalilufwa telule tupu na natelamwabule mani. Ine apele tupu lefoolali, nale futeni su lefoolalee, nanookoe Gotelu na kaiseklile tupu lefoolali futeni su lefoolalee. Eete oone glei Gotelu na kaiseklile niferilu inalife lufwafe lefole, mwa, oonekoe wolu nale futeni su letelari inalife lufwafe lelu. ");
INSERT INTO kwo_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Gote nali nalilu na kaiseklile fatielee, kame nalimeme futeni su letelari lufwafe leleeke lalali, tetoo eetei paie naporilu amee, teieporilu amee, nalilu ameime lalalee. Te ooneboe glelu feti, tefe oonanoo retifulu ameele futeni su lefoolalu, tetoo bilule teiefoolalualu? ");
INSERT INTO kwo_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Bie fiebu, oone eese nelamwamolu lufwa, “Kwotue pe, nembue pe, mena ame wokoo soulufile waneke yare mwamole wolelanei tetoo bwalee falerilu amee ameele lelanei, yesou pumwai lalabile.” ");
INSERT INTO kwo_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Oone eese nelamolu pane, oone oonanoo oofulilu kwotue akeke pai lemorife lelane, oone glei rame letemoi, mwa. Glefe, oonekoe i wifu letewaleeke mwa leleelu atukwe lebule. ");
INSERT INTO kwo_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Nemboue pai lebe oone eese nerife, “Paielu nali i neli tetoo mena ame oofulilu lalaneime, eetegeni ameele letelanei lalabile.” ");
INSERT INTO kwo_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Te nembue oonafeme menengu lemerilu menengu kame oonanoo futeni futeni ameefi alamwamo, eesalu amee eetete nembulu. ");
INSERT INTO kwo_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Menengu amwi lelabu, oone wolilu amee wolu rame leluke, te leri preme lelu, eetete oone wolu fwagilu ameetu lelu. ");
INSERT INTO kwo_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Fwai! Oone yesou yesoufe wolu oonanoo kulitu temepoomolu pane, oone kame menengu ruforitu lalamoi ee finalepoolabu, oonane metie breegee sua lemorife lelanelu oo nembulu wolu amee feelu pike lemoolalee. ");
INSERT INTO kwo_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Oonanoo yesou yesou wolilu maretekumeme wolu laku folepoolanei lemule lepooneke lailane. ");
INSERT INTO kwo_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Oonanoo goletu, silvatu mei wolu fifelu fri napomoonelu, ekeni fifelu nanoo oonanoo nembulule ame fetou namobe Gotelu nafi yenaleporilufi. Eketie, ekeni fifelu nali ame oonanoo reefi i atukwe kumopomobile. Tetoo mwa leporilu lietu bwaleele, wolilu yesoule oone kame yemereti tetepwi letemoome. ");
INSERT INTO kwo_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Oonanoo balifu fori yesoule papomoonanelu amee amee inalilufwalu bwaleele fetatebu, oone nanoole nifwaterife lelulu bwaleele amee reeneleluke, boe oonafe ambutelelulu bwalee nali oonane nembulufi sinamorife lelalee. Te Kaiseklilu Same Lafwalarilu Paielu wolu lufwa fori yesou papooneke gulunatenanelu lufwalu ritilu nale fieteleeke lalalee. ");
INSERT INTO kwo_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Oona eetegeni inengoi wolilu lafieri amwime lemoome te oona ooretaletemoomelu yesou pumwai lapruelemoome. Oone bole ameflee atukwe lemo lufwa bofoo wolilu fori yesoutu gipoleeke borutu asu asu leneke tetoo sabei boe nali ekeni lietume pukemobe. ");
INSERT INTO kwo_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Oonekoe wolilu amee tefoo lufwale kworootu bebenamomo, fwagilu amee tefoo lufwale atukwe. Nanoo oonane glei oorerei lemomoone. Mwa. ");
INSERT INTO kwo_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Tefe apane wofoliane, oone menengu amwime tootookoo lelamoi aikopile oolefoolabu, oonanoo Paielu boe rierife lelaleelule. Oone rame lebu bali yari wolilu fori yesou nalilu balifi rineleelule woroo letelee, tefe nanoo nalife amwime tootookoo lelali, kame menengu tafilutu lalali, nalilu bali yesou selime leneke, bolelutu leporife, aroole oolefoolalee. ");
INSERT INTO kwo_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Oone mei menengu amwime tootookoo lemoke lalamoi, aikopile oolefoolabu, Paielu rierife lelaleelule, oone kose amee teponuebule mani, mwa. Nanoo rierife lelaleelu lie wolu amee feelu pike lelalee. ");
INSERT INTO kwo_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Apane wofoliane oone legulu na preme, oone kose oo nembulufi lalabule, Gotelu nafi yenalelamoi. Filabu, ekeni Lufwa wolu amblenei yetemelalee. ");
INSERT INTO kwo_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Apane wofoliane oone Gotelu ragoofu nale alipoolananelu inalilufwale menengu letebu. Nanoo Paielulu bilutu Gotelu nale alipotemenei, nanoo nembulule berefu petilule atukwe ambuke tapomenei, nalife amwime regi lepoomene. Eesalu lufwalu amee nanoo alanelu menane fetou nene, eetegeni amee nanoo alanelule nifetebile. ");
INSERT INTO kwo_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Te, mena wolu rame lene, nanoo Gotelufime amee giginalemenei, nembulu tetereele falemene, mene eetele natelanane, nanoo wolu menengu mutukwe feti lene. Oone wolu fimo, Jope nanoo nembulu tetereele falemelee, nanoo mei Gotelufime amee giginalemelee. Te oone wolu fetafoomo glelu amee Paielu lefoleelule. Eese lefoleelu glefe, Paielu nanoo keemakee lelali, aikopi lelaleealee. ");
INSERT INTO kwo_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Apane wofoliane, nembouelu na eese lelee, oone kose efenefu yesoutu, inengufu yesoutu bi nelamwabule mani, bofoo yesou bilutu mei sameme, mwa. Oone we nelu, tete kame we naleme ne, te mwa nelu mei, kame mwa naleme ne, oone eese lelamolufe, tefe oone glei Gotelu nafi yenalebule. ");
INSERT INTO kwo_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Oonanoofu bofoo wolu oo nembulufi lalali, te nanoo Goteleme na woponefoolabee. Te oonanoofu bofoo wolu paie paie alali, te nanoo kame Goteleme reeyemee ifalabee. ");
INSERT INTO kwo_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Oonanoofu bofoo reefe alali Gotelu inalilufwalu yefeelu lufwale natebee. Tetoo nanoole Gote aikopi leforife nanoo Gotele fanenelu olife nangulule Paielulu bilutu ipoi sunalefoolanei, tetoo na woponefobi. ");
INSERT INTO kwo_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Te Jisesele menengoi ifelalaleelu lufwa nanoo Gotele na woponefoolali tetoo ree lufwalu ree kokoule unapofoleeke, ree tlinelalee. Te nali fwagilu amee lemeli, eetetie Paielu ekeni fwagilu ameele mei wogrinatefobe. ");
INSERT INTO kwo_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Tefe oone oona kwaife oonanoo fwagilu ameele lebati pootepoofwamoke, tetoo Gotele na woponefoomoke, aikopi lemoleeke, tetoo ree tlinepoolabule. Wolilu amee tefoo inali o lufwa Gotele na woponefoleealeelu kaiseklilutu lefolee. ");
INSERT INTO kwo_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Elaija mei nanoo mena eesalu lufwa. Nanoo Gotele mwamole menengutume na woponefoli, tetoo aroo nafori preme lerife. Te aroo nafori preme lemeli, yare mwangife leleeke te boe wosi tialootu lelee. ");
INSERT INTO kwo_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Te boe nali Gotele na woponefoleeke, te aroo boe nafoleeke te balifu yesou boe serinapoofwane. ");
INSERT INTO kwo_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Apane wofoliane oonanoofu bofoo marena nale grialeleeke mumu alali, te inali o lufwa na nafoleeke, boe lunaleleeke rieli, ");
INSERT INTO kwo_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","bofoo ine nanoole aikopi lefoleelu nanoo amwime rame lebee, ekeni inali o lufwa waleeke, ekeni lufwale oosefi ifenatelaleealeelu amefule neuneleeke, te Gotelufi siwoneli, eetete ekeni inali o lufwa ekeni lufwalufi nanoolu wopulu paie nelalee, tetoo glei tafilabe, mwa. Te nanoolu fwagilu amee motukwe lefoonelule mei Gote ame wogrinatefobe. ");
ALTER TABLE kwo_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
