﻿USE sofia;
DROP TABLE IF EXISTS sofia.bwd_vpl;
CREATE TABLE bwd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bwd_vpl WRITE;
INSERT INTO bwd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeisu Keliso yana gabuyavo ifufudi taidei anafaiweya. Banae ani Deivida unumina wagaine gitubuyegemona, aku Deivida ani Ebelaamo unumina wagaine gitubuyegemo. ");
INSERT INTO bwd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebelaamo banae natuna Aisake, Aisake natuna Iyakobo, ada Iyakobo natuna Iyuda, aku wa tubuiyanavo nodi. ");
INSERT INTO bwd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ada banae Iyuda natunavo Felesi ke Sala, aku inadi ani Temali. Ada Felesi natuna Esiloni, aku Esiloni natuna Lama, ");
INSERT INTO bwd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ada Lama natuna Aminadaba, aku Aminadaba natuna Nasoni, ada Nasoni natuna Salamoni, ");
INSERT INTO bwd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ada Salamoni natuna Bowasa aku Bowasa inana ani Leyabi. Bowasa natuna Obedi aku Obedi inana ani Luti, ada Obedi natuna Iyese. ");
INSERT INTO bwd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Aku Iyese natuna Kini Deivida, ada banae Deivida natuna Solomoni aku inana ani nagona Ulaiya vavinena. ");
INSERT INTO bwd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ada Solomoni natuna Leoboamu, aku Leoboamu natuna Abaiya, aku Abaiya natuna Asa. ");
INSERT INTO bwd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ada Asa natuna Iyeosafadi, aku Iyeosafadi natuna Iyolama, ada Iyolama natuna Usaiya. ");
INSERT INTO bwd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiya natuna Iyotama, aku Iyotama natuna Eyasi, ada Eyasi natuna Esekaiya. ");
INSERT INTO bwd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ada Esekaiya natuna Manasa, aku Manasa natuna Emoni, ada Emoni natuna Iyosaiya. ");
INSERT INTO bwd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iyosaiya natuna Iyekonaiya wa tubuiyanavo. Ada badiyavo imiyamiya aku meBabiloni ielai ada tufona moyaidi meIsileli ikiveyabidi inauwedi yadi fafaliya. ");
INSERT INTO bwd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ada yadi nau-nai Babiloni muline, Iyekonaiya natuna Salatiyeli gitubuga, ada Salatiyeli natuna Selubabeli. ");
INSERT INTO bwd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ada Selubabeli natuna Ebeuda, aku Ebeuda natuna Eliakimu, ada Eliakimu natuna Eso, ");
INSERT INTO bwd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","aku Eso natuna Sadoki, ada Sadoki natuna Ekimu, aku Ekimu natuna Eliuda. ");
INSERT INTO bwd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ada Eliuda natuna Eliesa, aku Eliesa natuna Madani, ada Madani natuna Iyakobo. ");
INSERT INTO bwd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iyakobo natuna Iyosefa banae Meli moganedi, ada Meli ivenatunena Yeisu Banae ivewagana Keliso. ");
INSERT INTO bwd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ada Yeisu Keliso yana unuma-dina adiyegana anafaiweya, aku givevuvu Ebelaamo wagaine ada gielai Deivida wagaine ani adiyoo fotini, aku Deivida wagaine ada gielai tova-nai meIsileli moyaidi ikiveyabidi inauwedi Babiloni wagaine ani kaduwe adiyoo fotini. Ada tova-nai meIsileli inauwedi Babiloni wagaine ada gielai Yeisu Banae Mesaiya wagaine, ani kadu adiyoo fotini. ");
INSERT INTO bwd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ada taidei anafaiweya Yeisu Keliso yana tubuga ifuifufuna. Inana Meli ani Iyosefa gisetago-moena aku aimo keke ida miyaluga ke nodi idada aku Meli gilutovonina giveifuga, ada tainei ani Aluwaluwa Tabuna yana toyogina wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aku moganena Iyosefa ani bana kaliva iwakana ke yana dewa bikana, ada keke nuwanuwana yoo matadiya Meli gina kivevovomumu faina, ginuwanuwa vaita ikavuya-deya gina viyoliliyena. ");
INSERT INTO bwd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ada aimoina ginuwanuwa anafaiweya aku Yaubada yana anelose seyana gienoavaisena, ani gielai wagaine ada givonenaga, “Iyosefa, oyeni Deivida yana tubudelideli, keke una matauta Meli faine aku auwe una vagaulena ke una nagina, faina kwamana kamone ani Aluwaluwa Tabuna giveifugena. ");
INSERT INTO bwd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ada kaduwe aimo natuna kaliva gina venatunena ke una vewagana ‘Yeisu’, faina Banae yana kalivayavo yadi dewa koyona wagaine gina kibababaledi.” ");
INSERT INTO bwd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aku gaitoma taidei giyegemona velemoena, faina tova tuwaina Yaubada yana vona gavaiyamu yana falofita givonayena ani anafaiweya gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ada falofita-nai givonaga, “Wana itana, vavine seyana akeduna matabolana gina veifuga ada natuna kaliva gina venatunena, ada ina vewagana Imanueli.” E, yegana taidei anakivila ani ‘Yaubada ide nodi kamiyamiya’. ");
INSERT INTO bwd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","E ada Iyosefa gienovilana ada Yaubada yana anelose giveimeyena anafaiweya gigugai. Ginau Meli givagaulena ada ginauwena yana manuweya. ");
INSERT INTO bwd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aku nodi imiyamiya ada vovona keke gida kiluvaluva aku givenatuna natuna kaliva. Ada Iyosefa kwamana givewagana Yeisu. ");
INSERT INTO bwd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ada Yeisu gitubuga melala Bedeliema wagaine, aku tova-nai wagaine ani Elodi giveiveimeya Yudiya anafafali wagaine. Ada kaliva tufodi badi ailabama anatonuwauya, ani kauwana ebalakavina wagaine ielai Yelusalema. ");
INSERT INTO bwd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ada itolidadana, ivonaga, “Gadedeku meIsileli yami kini gitubuga? Faina wadedeku fafali kauwana ebalakavina wagaine amiyamiya aku ailabama seyana gilaka aitana ani banae kwamana-nai anaiyaiyaya. Ada aelai ana oduodu wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aku Kini Elodi gikaiyanogala vaita meIsileli yadi kini evaguna, ada tayuwe wagaine giasekolukolu ada kaduwe meYelusalema moyaidi nodi. ");
INSERT INTO bwd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ada Elodi Yaubada yana veyavo anatovegugai lakaidiyavo ke Mosese yana veimeya anatovewalayavo gidouwedi ivagauta aku gitolidadanedi, givonaga, “Gava melala wagaine Mesaiya gina tubuga?” ");
INSERT INTO bwd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ada badiyavo ivona, “Bedeliema Yudiya anafafali wagaine gina tubuga, faina Yaubada yana falofita seyana yana buki wagaine givetokilumina givonaga, ");
INSERT INTO bwd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O meBedeliema, Iyuda anafafali wagaine wamiyamiya. Yami melala kabisona aku anayegana lakaina Iyuda anamelala wagaidiya, faina toveimeya lakaina aimo wagaimiya gina tubuyegemona, ada yaku yoo meIsileli gina itaveyabidi.’” ");
INSERT INTO bwd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aku Elodi vona-dina tayuwe ginogalidi, ada ailabama aditonuwauya gidouwevagauwidi ikavuya-deya ke gitolidadanedi, e ada gina alamane-dewedewena wagaidiya evo vaita gavatoveya ailabama-nai giyegemona. ");
INSERT INTO bwd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ada tova-nai yana alamana givaina wagaidiya ada giveimeyedi, givonaga, “Wananau Bedeliema wagaine ada kwamana-nai wanalele-dewedewena. Ada kai bademowa wana nuwagana aga wanaela wana mataweku, ada Iya kaduwe gananau anafaiweya gana oduodu wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ada tonuwauya Kini nodi iveifuifufu giavaina, imididi inau. Ada inaunau aku ailabama-nai giyegemona kauwana ebalakavine imaduitana anafaiweya, ani kaduwe iita-vagilena, ada wagaine nuwadi giafolena ke ivemwamwala lakaina. Ada iitaitana aku ginagoyedi ke gadedeku kwamana yana ebamiya getane-deya giilovau. ");
INSERT INTO bwd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ada manuwa wagaine iluku ke iitana kwamana inana Meli nodi imiyamiya, ada tugadi ivetodonedi ke ioduodu aku kwamana iawadavadavana. Ada muliya yadi fose iiyavuga ada yadi nuwakabubu lokoloko kaikaiwabu ivelena, gola ada bunama iluwei badi fatadi lakaina adiyegana falanikisenisi ke mulo. ");
INSERT INTO bwd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aku muliya avaita wagaine Yaubada gimatawedi ada giawatadi keke Elodi wagaine inayewa, e ada iyewadi mali edeya ada inau yadi melaleya. ");
INSERT INTO bwd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tova-nai tonuwauya inau aku Yaubada yana anelose seyana Iyosefa gienoavaisena ani gielai wagaine ada givonena, “Una mididi ke kwamana inana nodi una vaidi ada wanaota wananau fafali Itipita wagaine. Wadedeku wana miyamiya aku tova-nai gana mataweni ada wana yewami wanaelai. Faina banae Elodi aimo kwamana gina lelena ke gina luvealikana.” ");
INSERT INTO bwd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Anelose anafaiweya givona ada bogi nafona wagaine Iyosefa gimididi ada kwamana inana nodi ginauwedi Itipita, wadedeku maita matatuwadana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ada wadedeku imiyamiya aku Elodi gialika, ada au Itipita isegena. Taidei wagaine ada gavana Yaubada yana vona falofita Oseya givetokilumina, ani giyegemona velemoena, givonaga, “Itipita-deya Natuku gadouwe gielai.” ");
INSERT INTO bwd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aku aimo Elodi wayawaine, e tova-nai wagaine ailabama anatonuwauya ifwayana ada inukavu inau e ada Elodi giboda-wayogedi. Tayuwe wagaine yana alamana givaina ada agona giuga velemoena. Ada yana tolugaviya giveimeyedi ke inanau melala Bedeliema wagaine, kaduwe lilivane melala-dina wagaidiya biyabiyama kaliva matatabudi ina luvealikadi. Biyabiyama-dina adimalamala iluwei ke tufodi evagu-moedi, tainei tova-nai gialamanena anafaiweya ailabama yana yegemona tonuwauya wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ada biyabiyama iluvealikadi faina, Yaubada yana vona ani tova tuwaina falofita Iyelemaiya givonayena ani giyegemona velemoena, givonaga, ");
INSERT INTO bwd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Melala anayegana Lama wagaine vavine bonadi inogalina itagilukuikui. Litiyeli ani natudiyavo faidiya itagitagiya, ada vonanuwakabubu ivenikoiyena, faina natudiyavo ialika-yabu.” ");
INSERT INTO bwd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aku tova-nai Elodi gialika, ada muliya Itipita wagaine KAUVEYA yana anelose seyana Iyosefa gienoavaisena ani giyegemona wagaine givonenaga, ");
INSERT INTO bwd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Una mididi ada kwamana inana nodi una vaidi wanayewa Isileli anafafali wagaine. Faina biyavo-dina ibalalava vaita kwamana ina luvealikana ani bademowa ialika.” ");
INSERT INTO bwd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ada Iyosefa gimididi kwamana inana nodi givaidi giyewedi Isileli anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aku tova-nai iyegemo ada Iyosefa gikaiyanogala vaita Akelio gifatana tamana Elodi, ada Yudiya anafafali wagaine giveiveimeya. Taidei faina Iyosefa gimatauta ada keke nuwanuwana wadedeku ginamiya. Aku avaita wagaine Yaubada givonamatawena e ada ginau Galili anafafali wagaine gimiya. ");
INSERT INTO bwd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ada Iyosefa ginau melala Nasaledi wagaine gimiya. Ada taidei wagaine tova tuwaina Yaubada yana vona falofita ivonayena Tokibababala faine ani giyegemo velemoena, ivona, “Banae ina vewagana kwana Nasaledi.” ");
INSERT INTO bwd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aku tayuwe tova-nai Iyoni Tobabitaiso giyegemona ke gilulumamala Yudiya anafafali kavovona wagaine, ");
INSERT INTO bwd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","givonavonaga, “Yami dewa koyodi wana dibusoyogedi ada wagaidiya wana nuwavilana, faina Yaubada yana ebaveimeya bademowa givelilivana.” ");
INSERT INTO bwd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Banae Iyoni-nai faine falofita Aiseya givonaye-vagaina, givona, “Kaliva seyana givedovedou fafali kavovona wagaine, givonavona, ‘KAUVEYA yana wai aseasemiya wana kidewedewena ke wana kivetunutunugina Bana faine.’” ");
INSERT INTO bwd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Aku banae Iyoni ananuya ani kevakeva kameli vutuvutuna wagaine ibubuna, aku anabeleta labene giyogona ani kevakeva kwafilina wagaine. Aku anaga ani bilolo ke mawa vutona. ");
INSERT INTO bwd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ada kaliva moyaidi ielaelai bana wagaine, meYelusalema ke Yudiya anafafali wagaine kaduwe gufa Yolidani anafafali anakaliva moyaidi ielai. ");
INSERT INTO bwd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ada yadi dewa koyodi iawaawamogataledi, ada Iyoni gikivebabitaisodi gufa Yolidani wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aku Falisiyavo ke Sadusiyavo moyaidi kaduwe ielai Iyoni gikikivebabitaiso fafali-nai wagaine. Ada Iyoni giitadi ke givonediga, “Imi vaita mota natunavo anafaiweya, mota-nai koyo-moena giluluvealika! Gaito givonemi evona vaita amifaiweya wanaota Yaubada yana nuwakoyo lakaina gielaelai wagaine? ");
INSERT INTO bwd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gilubodami wanadewa tunutunugina e ada yami nuwavilana anaita gina mogatala velemoena. ");
INSERT INTO bwd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ada keke wana nuwanuwa taumiyavo wagaimiya ke wanavona, ‘Imeyavo ani Ebelaamo unumina faina, kadu ide Yaubada natunavo. E ada Yaubada keke gina vematavulogima.’ Faina gana vonemi, Yaubada anafata kabala taidei wagaidiya Ebelaamo natunavo gina bubudi. ");
INSERT INTO bwd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kaduwe tova malinai-mowa Yaubada yana matavuloga anailama bademowa igui gimanini, ada ai ina luinubadi. Ada ai seyana seyana guwadi keke iwakana ani inatala ginaobu ke ina batugena ai alalata wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iyayeku ani gakivebabitaisomi gufa wagaine, faina yami dewa koyona wagaine wanuwavilana anaiyaiyaya. Aku kaliva seyana mulikuya gielaelai ani Banae lakai-moena aku Iyayeku kwamana kabisoku. E ada keke akulauboda Bana wagaine gana vetogugai ke anaageyafayafa ganawai. Banae gina kivebabitaisomi Aluwaluwa Tabuna wagaine ada kadu ai alalata. ");
INSERT INTO bwd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ada witi anadiu lakaina ani bademowa nimana wagaine ke witi anaebavagakolukolu wagaine gina lubutuna. Ada witi-moena gina vagauwina yana kweda wagaine gina dodona, aku witi yogona ai alalata wagaine ginaleva gina alaina, ai-nai keke maita gida weuwe.” Taidei anafaiweya Iyoni gilumamala. ");
INSERT INTO bwd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aku Yeisu Galili anafafali gitauya ginau gufa Yolidani wagaine giyegemo ada Iyoni gina kivebabitaisona faina. ");
INSERT INTO bwd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aku Iyoni nuwanuwana gina awatana ada givonaga, “Gavaiyamu-yo Iya wagaikuya uela una babitaiso? Iya au kwamana kabisoku e ada akulauboda Oye wagainiya gadaela uda kivebabitaisoku.” ");
INSERT INTO bwd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aku Yeisu givonena, givona, “Auwe keke una nuwanuwa. Tova malinai una kivebabitaisoku, faina taidei adalauboda gavaiyamu Yaubada kaliva giveimeyeda ani matatabuna kana gugaiyena.” E ada anafaiweya givona faina, Iyoni giawaegau ada gikivebabitaisona. ");
INSERT INTO bwd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ada Yeisu gibabitaiso giavaina, au gifumatana gufa wagaine ani maduga-mowa gabama giawaina aku giitana Yaubada Aluwaluwana giobuobuelai vaita manuga bunebune anafaiweya, ada givetogana Banae wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ada gabameya-deya Yaubada bonana giyegemo, givonaga, “Taidei ani Natu aseaseku, Banae nuwaku gikivemwamwalina lakaina.” ");
INSERT INTO bwd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aku Yeisu gibabitaiso gufa Yolidani wagaine, muliya Aluwaluwa Tabuna ginagoyena ada ginauwena fafali kavovona wagaine ke Seitani gina aladibidibiyena. ");
INSERT INTO bwd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ada yadayada foti (40) ke bogi foti wagaidiya kani giiloilovau, ada tova-nai anaebalauyabu wagaine mafa gilavuna. ");
INSERT INTO bwd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ada toaladibidibi Seitani ani giyegemona Yeisu wagaine ada givonenaga, “Kai Oyeni velemoena Yaubada Natuna aga kabala taidei una veimeyedi inave aa.” ");
INSERT INTO bwd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aku Yeisu gilufata givona, “Yaubada yana vona vetovetokilumina givonaga, ‘Keke aa gaga wagaine kaliva yawai ina nuwanuwaga, aku Yaubada yana vona seyana seyana giyegeyegemona awane, ani wagaine yawai ina nuwanuwagana.’” ");
INSERT INTO bwd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kaduwe Seitani Yeisu ginauwena Yelusalema, tayuwe Yaubada yana melala tabutabuna, ada manuwa tabu tabone-mwane givemididina ");
INSERT INTO bwd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ada givonena, “Kai Oyeni velemoena Yaubada Natuna, aga una towavila unaobu babi wagaine, faina Buki Tabu wagaine ivetokilumina, givona, ‘Yaubada yana aneloseyavo gina veimeyedi o fainiya, ke nimadiya ina kilakaini e ada keke age una vetutu kabala wagaine.’” ");
INSERT INTO bwd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aku Yeisu Seitani givonena, “Aku kaduwe Yaubada yana vona vetovetokilumina givonaga, ‘Keke KAUVEYA ya Yaubada una galuvaluva.’” ");
INSERT INTO bwd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kaduwe, Seitani gilakavena oya manamanawe-moena tabone, ada ebaveimeya moyaidi babi matatabuna wagaine wa adikaikaiwabu nodi givewalena. ");
INSERT INTO bwd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ada givonena, givona, “Kai una iboula-mowa ke una oduodu Iya wagaikuya, aga ebaveimeya taidei moyaina gana veleni.” ");
INSERT INTO bwd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aku Yeisu givonena, “Seitani, auwe unanau! Faina Yaubada yana vona vetovetokilumina givonaga, ‘KAUVEYA ya Yaubada wagaine una oduodu, ada Banae anakaibe-mowa faine una gugai.’” ");
INSERT INTO bwd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ada Seitani gisegena aku Yaubada yana aneloseyavo iyegemona ke Yeisu ilemelemena. ");
INSERT INTO bwd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aku Yeisu valeya ginogalina ani Iyoni deliya isena, e ada giyewana ginau Galili anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ada yana melala Nasaledi wagaine ginau aku keke wadedeku gidamiya, aku ginau melala lakaina Kafaneumi wagaine gimiya. Tayuwe lavu lilivane tainei unuma Sebuloni ke Nafitalai yadi fafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Taidei faina tova tuwaina wagaine falofita Aiseya ani Yaubada yana vona givonayena, ani giyegemona velemoena, givonaga, ");
INSERT INTO bwd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebuloni ke Nafitalai unumidi ani yadi fafali wagaine tayuwe Lavu Galili waina aku gufa Yolidani fafalina, badi biyavo-dina keke meIsileli ani imiyamiya Galili anafafali wagaine, ");
INSERT INTO bwd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","kaliva-dina imiyamiya yuyuvana bakibaki wagaine ani malina lakaina iitana. Ada badi gavega alika aiwauna anafafali wagaine imiyamiya, ani malinai malina gituimalidi.” Taidei anafaiweya Aiseya givona. ");
INSERT INTO bwd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ada tova tayuwe wagaine-deya Yeisu givebutu gilulumamala, givonaga, “Yami dewa koyodi wana dibusoyogedi ke wana nuwavilana, faina Yaubada yana ebaveimeya bademowa givelilivana.” ");
INSERT INTO bwd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Aku tova seyana Yeisu gibala ginaunau Lavu Galili taliyeya aku kaliva adiselu giitadi, seyana Saimoni kadu anayegana anavelu Pita, ada anatubuluga Andulu. Ada guvata iyavuyavulena, faina badi toyauba. ");
INSERT INTO bwd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ada givonedi, givona, “Wanaela wana muliyeku, ada gana kidewedewemi ke imi kaliva aditoyauba.” ");
INSERT INTO bwd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ada maduga-mowa adiselu yadi guvata imadusegedi aku imuliyena. ");
INSERT INTO bwd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kaduwe gibala ginaunau aku kaliva seyana anatubuluga nodi giitadi, tainei Iyemesa ke Iyoni, badi Sebedi natunavo. Ada tamadi nodi waka wagaine yadi guvata ikidewadewa. Au Yeisu gidouwedi ");
INSERT INTO bwd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ada maduga-mowa yadi waka ke kaduwe tamadi imaduyabuyabuna aku Yeisu imuliyena. ");
INSERT INTO bwd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeisu gibalawalilivuga Galili anafafali matatabuna wagaine, ada meIsileli yadi manuwa ebavewala wagaidiya givevewala kaduwe valeya iwakana gilumamalena Yaubada yana ebaveimeya faina. Ada kaliva ke vevine wa adiveoga tulina tulina ani matatabudi gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ada Yeisu valeyana gimutula ginau Siliya anafafali matatabuna ada toveoga moyaidi ialiyedi wagaine. Badi adiveoga tulina tulina ke gavega iuloulolo lakai-moena, ada kaduwe badi aluwaluwa koyodi nafodiya imiyamiya, ke tufodi tova maufona wagaine vovodi matatabuna iyaviyavivila ke iitaita-vagata, ada kadu badi vovodi memeluyadi ani ialiyedi Yeisu gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ada yoo lakai-moena Yeisu imulimuliyena. Badi ielai Galili wagaine ke melala lakaidi adiyoo teni adiyegana Dekafolisi, kaduwe Yelusalema wagaine ke Yudiya anafafali ada gufa Yolidani fafalina kaliva-dina ani ielaelai Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ada Yeisu yoo giitadi wagaine, gilaka ginau oyaoyana wagaine givetogana aku kaduwe yana tonogalayavo inau Bana wagaine ivagauta. ");
INSERT INTO bwd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ada givebutu givewala wagaidiya, givonaga, ");
INSERT INTO bwd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Badi gavega aluwaluwadi wagaine ilutovonina vaita keke tamo yadi iwakana aku au Yaubada yana leme gaga wagaine ina veiwaka, ani Yaubada giawanuwakabubuyedi, e ada Banae yana ebaveimeya wagaine imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Badi gavega wa yadi tagiya imiyamiya ani Yaubada giawanuwakabubuyedi, e ada nuwadi gina kiveiwakanena. ");
INSERT INTO bwd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Badi gavega yadi dewa bikana ada tonuwaobu ani Yaubada giawanuwakabubuyedi, e ada babi matatabuna gina veledi. ");
INSERT INTO bwd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Badi gavega nuwanuwadi lakai-moena yadi nuwanuwa ina yegayegana ani Yaubada giawanuwakabubuyedi, e ada nuwanuwa yegayegana gina veledi aseasediya. ");
INSERT INTO bwd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Badi gavega tonuwakalikali ani Yaubada giawanuwakabubuyedi, e ada badi kadu nuwakalikali ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Badi gavega aseasedi yegayegana ani Yaubada giawanuwakabubuyedi, e ada Banae ina itana. ");
INSERT INTO bwd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Badi gavega tokukuya ani Yaubada giawanuwakabubuyedi, e ada Banae gina awavenatunedi. ");
INSERT INTO bwd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Badi gavega Yaubada yana nuwanuwa tunutunugina iidibumwaigena ada taidei faina mali kaliva igugai koyona wagaidiya, ani Yaubada giawanuwakabubuyedi, e ada Banae yana ebaveimeya wagaine imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kai kaliva ina awavekoyoyemi ke ina kiveulolonimi imi wamulimuliyeku faina, aga Yaubada giawanuwakabubuyemi. Kadu kai kaliva fwaya ina faisewana ke ina ifufu koyona faimiya imi wamulimuliyeku faina, aga Yaubada giawanuwakabubuyemi. ");
INSERT INTO bwd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Au wana gakaikai ke wana vemwamwala-mowa, faina gabameya fatami iwakana ke lakaina gimiyamiya. Faina tova tuwaina dewa-dina anafaiweya ani Yaubada yana falofitayavo idewayedi. ");
INSERT INTO bwd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Imiyavo vaita leyaga anafaiweya tomiyababi faidiya. Aku kai leyaga anadigadigaga gina avaina, aga keke anafata kana kiveleyagi-vagile. Yana iwakana bade giavaina e ada keke kana vegugaiye, aku au kana segena ke kaliva ina vagavebabibabina. ");
INSERT INTO bwd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kaduwe imi vaita malina anafaiweya babi anakalivayavo faidiya. Ada anafaiweya kai melala lakaina oya tabone gina mididi, aga keke anafata ina sewavuye. ");
INSERT INTO bwd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ada kaduwe, kai kaliva mayale ina kabuna, aga keke wela inavai ada ina vetalakabubu mayale-nai wagaine. Aku mayale anaebaibo wagaine ina selakaina e ada kaliva moyaidi manuwa negenine gina malidi. ");
INSERT INTO bwd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Taidei anafaiweya imi kaduwe. Gilubodami ada yami dewa tunutunugina anafaiweya malina wana seyegemonena kaliva wagaidiya ada anaiwakana ina itana, e ada tayuwe wagaine Tamami gabameya ina awadavadavana. ");
INSERT INTO bwd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Keke wana nuwanuwa vaita Iya gaelai ke Mosese yana veimeya o kai falofita yadi vewala gana vaiyavule, keke. Iya gaelai ke veimeya-dina adinuwanuwa nafo-moena gana ivemogatalina velemoena. ");
INSERT INTO bwd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Faina gavonemi velemoena, Mosese yana veimeya ani keke gina avaidi, au matana kabiso-moena ivetokilumina ani keke maita ginaavai. Keke-mowa. Aku ina miyamiya analaba gabama ke babi ina awala. Ee, veimeya-dina matatabudi ina miyamiya analaba adinuwanuwa ke yadi faisewa gina yegemona velemoena. ");
INSERT INTO bwd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Taidei faina, Mosese yana veimeya wagaidiya, ani kai veimeya seyana vaita keke lakaina aku badi gavega ina yawelina ada kaduwe kaliva ina vewaledi ke badi kadu ina yawelina, aga badiyavo adiyegana kabiso-moedi Yaubada yana ebaveimeya wagaine. Aku badi gavega veimeya-dina ina muliyedi ada kaliva ina vewaledi ke badi kadu ina muliyedi, ani badiyavo adiyegana lakaina Yaubada yana ebaveimeya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Faina gana vonemi, gilubodami ada yami dewa gina veiwakasegena badi Falisiyavo ke Mosese yana veimeya anatovewalayavo yadi dewa. Aku kai keke, aga keke-mowa wanaluku Yaubada yana ebaveimeya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bademowa wanogalina veimeya-nai tuwai-moena gielai yada yoo wagaidiya, givonaga, ‘Keke kaliva wana luvealika. Kai gaito gina luvealika, aga banae ina nauwena vonayavuga wagaine ada veimeya gina nuwagana.’ ");
INSERT INTO bwd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ada tayuwe veimeya givona anafaiweya, aku Iya gana vonemi, kai gaito gina nuwakoyo tubuiyana wagaine, aga banae ina nauwena vonayavuga wagaine ada veimeya gina nuwagana. Ada kai gaito vona koyona gina inanana tubuiyana wagaine, aga ebavonayavuga lakaina wagaine ina vevonayavugina. Kaduwe kai tubuiya una vonena ‘Kuluwa dayodayona,’ aga gilubodani ina batugeni aiyabeyabela nafone eli wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Taidei faina kai ya velekavovo una nauwena vaita Yaubada matane unasena ebavebolavoi wagaine, aku nuwa gina afolena ani tubuiya wagaine udewa koyona ada ukivenuwavitana, ");
INSERT INTO bwd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","aga auwe ya velekavovo unasena ebavebolavoi wadebaine aku unanau. Nagona tubuiya nodi wana vebonaluga, ayo muliya unaela ya nuwakabubu una velekavovoyena. ");
INSERT INTO bwd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kai tamo gaito giawavekoyoyeni e ada amiselu wanauna wana vonayavuga tovevonayavuga wagaine, aga unamadu ada nodi wanamadu kivetuvetunugina ke wana vetubuiyana, aenanai aimo ginaseni tovevonayavuga nimane, ada banae ginaseni filisimani nimane ke ginaseni deli wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gavonemi velemoena, keke inamadu etoyavuni aku nagona gavaiyei mani ina venuwadadanena anatubuga anafaiweya, ani unafata-yabuna ayo muliya ina etoyavuni. ");
INSERT INTO bwd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kaduwe bademowa wanogalina veimeya-nai givona, ‘Keke unaudo.’ ");
INSERT INTO bwd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aku Iya gana vonemi, kai gavakaliva vavine gina italuvadigena nuwanuwana nodi inadau, wada tayuwe ani bademowa aseasene-deya vavine-nai wagaine giudo. ");
INSERT INTO bwd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kai mata aiyatagi gina nagoyeni ke una koyokoyona, aga au una etomwamwali una segena. Faina kai talai seyana una segena e ada keke una koyokoyona, ani ina iwaka-vagaina ayo kai vovo anamatatabuna inasege ginaluku eli wagaine. Tainei koyo-moena. ");
INSERT INTO bwd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kaduwe kai nima aiyatagi gina sitaitaini ke una koyokoyona, aga au una dabayavule una segena. Faina kai talai seyana una segena e ada keke una koyokoyona, ani ina iwaka-vagaina ayo kai vovo anamatatabuna ginaluku eli wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ada kaduwe Mosese yana veimeya wagaine givonaga, ‘Kai gaito seyana vavinena gina viyoliliyena, aga viyolili anamatawa vavinena gina velena.’ ");
INSERT INTO bwd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aku Iya gana vonemi, gavakaliva vavinena keke idaudo aku gina viyoliliyedi, tayuwe ani vaita kaliva-nai vavinena gina luimilidi e ada kai vavine-nai viyoviyolilina ginanagi kaliva evaguna nodi, wada iudo. Ada gavakaliva vavine viyoviyolilidi gina nagidi, wada kaduwe giudo. ");
INSERT INTO bwd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kaduwe wanogalina tuwaina Mosese yana veimeya wagaine givonaga, ‘Yami vonadabadaba wana itaveyabina ada keke wana yaweyaweli, aku wana gugaiyena anafaiweya KAUVEYA wagaine.’ ");
INSERT INTO bwd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aku Iya gana vonemi, kai wana vonadabadaba, aga keke tamo gavana kaduwe wana inainana ayo yami vona-nai gina kivetoyogi. Keke wana vonadabadaba toyogina gabama wagaine, faina gabama ani Yaubada yana veimeya anaebavetoga kaikaiwabuna. ");
INSERT INTO bwd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kaduwe keke babi anamatatabuna wagaine wana vonadabadaba toyogina, faina babi ani Yaubada agena adiebaibo. Kaduwe keke Yelusalema wagaine wana vonadabadaba toyogina, faina Yelusalema ani Yaubada banae Togetane-mwane yana melala lakaina. ");
INSERT INTO bwd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ada kaduwe keke wana vonadabadaba toyogina kuluwami wagaine, faina imi keke amifata kuluwami seyana ani wanagai gina kwaya o kai ginabowa. ");
INSERT INTO bwd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Taidei faina, au wanavona-mowa ‘ika’, faina waalamanena aimo wanagana. Ada kaduwe wanavona ‘keke’, faina waalamanena aimo keke wanagai. Gavana wana vetutamwata vaita yami vona wana kivetoyogina faina, tainei ani gielai kaliva koyona Seitani wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kaduwe bademowa wanogalina veimeya-nai tuwai-moena gielai yada yoo wagaidiya, givonaga, ‘Kai seyana gaito mata gina kivekoyona, aga kaduwe fatana matana una kivekoyona’. Ada kaduwe, ‘Kai seyana gaito o nigo gina kivekoyona, aga fatana bana nigona una kivekoyona’. ");
INSERT INTO bwd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aku Iya gana vonemi, kai seyana gaito gikoyona wagaimiya, aga keke wana veluege. Kai seyana gaito gina nuwakoyo ada aiyatagimi aiyaimi gina tafina, au wana miyavilami ke wana awaege kadu aimaulimi aiyaimi gina tafina. ");
INSERT INTO bwd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","O kai seyana gaito gina nauwemi vonayavuga wagaine ada amiseti gina vaina, aga aminuya badobadona kadu wana velena. ");
INSERT INTO bwd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kaduwe kai gaito seyana gina veimeyemi ke yana lokoloko gina vewaimi ada nodi wananau kilomita seyana, aga kaduwe wananau kilomita anavelu. ");
INSERT INTO bwd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kai gaito gina veolemi tamo gavana faina, aga wana velena. Ada kai banae gaito gina veolemi tamo gavana faina ke gina vegugaiyena muliya gina veyewa ginaelai, aga wana awaegena. Keke wana awata. ");
INSERT INTO bwd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Bademowa wanogalina veimeya-nai givonaga, ‘Kaliva wana nuwakabubuyedi aku nibaimiyavo wana agougedi.’ ");
INSERT INTO bwd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aku Iya gana vonemi, Nibaimiyavo wana nuwakabubuyedi, ada badi gavega ikiveuloulolonimi ani wana veoveola faidiya. ");
INSERT INTO bwd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Taidei anafaiweya wanadewa ada Tamami gabameya ani imi natunavo velemoena e ada nunune wanaunau. Faina Banae kauwana gigai gitafalelega toiwakana ke tokoyona wagaidiya, anafaiweya kaduwe wei giimilina ke toyegayegana ada keke toyegayegana wagaidiya gilugalugaga. ");
INSERT INTO bwd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kai amitonuwakabubu gaga wanuwakabubuyedi, aga gavalaufata iwakana tayuwe faine evona Yaubada gina velemi? Keke tamo. Au badi takesi anatoyaudi kiyakiyafudiyavo, ani kaduwe anafaiweya inuwakabubu tubuiyadiyavo-gaga wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ada kaduwe, kai tubuiyamiyavo-gaga wana vesiuleyedi aku kaliva tulidiyavo keke, aga keke wana nuwanuwa vaita yami dewa iwaka-moena ayo muliya mali kaliva yadi dewa. Au badi keke meIsileli, biyavo-dina Yaubada wagaine keke ida oduodu, ani taidei anafaiweya igugai, ada tubuiyadiyavo-gaga ivesiuleyedi. ");
INSERT INTO bwd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","E ada Tamami gabameya Banae yegayegana matatabuna anafaiweya, imi gilubodami yami dewa matatabuna gina yegayegana ada wagaine wana kumaga. ");
INSERT INTO bwd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Wana itaveyabimi ada yami gugai iwakana keke wana veveitadi kaliva matadiya evona vaita ina kaiyemi faina. Kai wanadewa anafaiweya, aga keke fatami iwakana wana nuwaga Tamami gabameya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Taidei faina, tova-nai wanalema fanifani wagaidiya, aga keke wana ivemogatali anafaiweya meyalugaluga yadi dewa. Badi nuwanuwadi adiyegana ina kilakaina faina, nagona kaula ina yuvena ke kaliva moyaidi ina itadi, aku muliya yadi nuwakabubu fanifani ina veledi. Taidei anafaiweya idewadewa manuwa ebavewala wagaidiya o kai melaleya kaliva yadi ebavagauta wagaidiya. Gavonemi velemoena, bademowa fatadi ivai-vagaina kaliva idavadi wagaine, aku vaita fatadi ida nuwagana Yaubada wagaine ani keke. ");
INSERT INTO bwd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aku tova-nai fanifani wana lemedi, aga wana ikavuyena keke seyana gaito gina alamane. ");
INSERT INTO bwd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E ada gavana waikavuyena ani bade Tamami giitana, ada gina fatami iwakana. ");
INSERT INTO bwd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Tova-nai wana veoveola Yaubada wagaine, aga keke meyalugaluga yadi deweya wanadewa. Badi nuwanuwadi lakaina manuwa ebavewala wagaidiya o kai wai bolagalaga wagaidiya ina mididi ada ina veoveola ke kaliva moyaidi ina itadi. Gavonemi velemoena, badi bademowa fatadi ivai-vagaina kaliva yadi dava wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aku imiyavo ani tova-nai wana veoveola, wanaluku yami manuwa anavetawana wagaine, anawana wana falina, ada ikavuya-deya amikaibe wana veoveola Tamami wagaine. Ada Tamami giitaitana gavana waikavuyena ani aimo gina fatami iwakana. ");
INSERT INTO bwd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kaduwe wana veoveola Yaubada wagaine, aku keke vona wana luvavagile anafaiweya biyavo-dina keke Yaubada ida alamane yadi dewa. Badi inuwanuwa vaita yadi veoveola manamanawena faina, yadi yaubada fwayafwaya gina nogalidi. ");
INSERT INTO bwd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Keke wanadewa anafaiweya biyavo-dina, faina Tamami bademowa gialamanena gavana wagaine wavemaufo ayo muliya imi wana veolena. ");
INSERT INTO bwd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","E ada taidei anafaiweya wana veoveola, ‘Tamama umiyamiya gabameya, ayegana tabu ana vemoimoinena. ");
INSERT INTO bwd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ya ebaveimeya gidaelai. Ya nuwanuwa migabama igugai anafaiweya, ime babiya kaduwe ada gugaiyena. ");
INSERT INTO bwd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amaga malinai faina uda velema. ");
INSERT INTO bwd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yama koyona uda venuwaegedi anafaiweya ime kaliva yadi koyona wagaimeya bademowa avenuwaegau. ");
INSERT INTO bwd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ada ebaaladibidibi wagaidiya keke uda awaegema, aku koyona wagaine uda kibababalema. Faina Oyeni ya ebaveimeya, ke Oyeni ya toyogina, ada Oyeni ya iwakana mamalina inamiya-vagata keke ginaavai. Anafaiweya.’ Taidei anafaiweya wana veoveola. ");
INSERT INTO bwd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Faina kai kaliva yadi koyona wagaimiya wana venuwaegedi, aga kaduwe Tamami gabameya yami koyona gina venuwaegedi. ");
INSERT INTO bwd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aku kai kaliva yadi koyona keke wana venuwaegedi aga, kadu Tamami gabameya imi yami koyona keke gina venuwaegedi. ");
INSERT INTO bwd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ada tova-nai taumiyavo wana awatami ada kani wana ilovau, aga keke wanadewa meyalugaluga yadi dewa anafaiweya, magigidi ina kokomidi anafaiweya tonuwavita. Faina magigidi igadi ikokokomidi anafaiweya tonuwavita, ada wagaine kaliva moyaidi iveveitadi e ada ina alamanedi evona badi aa anakani iiloilovau. Gavonemi velemoena, badi bademowa fatadi ivai-vagaina kaliva yadi dava wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aku tova-nai kani wana ilovau, aga magigimi wana kolana ada kuluwami wana fakilina ke amiita wana vewala vemwamwala, ");
INSERT INTO bwd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","e ada kaliva keke ina alamane vaita kani wailovau. Aku Tamami keke amifata wanaita ani anakaibe gialamanena. Ada Tamami giitaitana gavana waikavuyena ani gina fatami iwakana. ");
INSERT INTO bwd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Keke babi anakaikaiwabu moyaina wana lokonedi babi taidei wagaine, faina idedeku gaitoma matatabuna ani tumotumo ikikivekoyodi, o kai itaitaiga, o kai tokiyafu imanuwa-iyawela ke ikiyakiyafu. ");
INSERT INTO bwd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aku aiyada yami lokoloko kaikaiwabu velemoena wana lokonedi ani gavana Yaubada yana nuwanuwa wana gugaiyena. Ada taidei ani yami lokoloko kaikaiwabuna velemoena gabama wagaine. Faina wadedeku tumotumo ke taiga keke ina kivekoyodi, kaduwe tokiyafu keke adifata manuwa ina yaweli ada ina kiyafu. ");
INSERT INTO bwd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Faina gadedeku yami kaikaiwabu velemoena gimiyamiya, ani tayuwe wagaine tova moyaina yami nuwanuwa ke aseasemi kaduwe ina miyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matada vaita vovoda anamayale anafaiweya. Kai matami iwakana, aga vovomi kaduwe matatabuna mamalina. ");
INSERT INTO bwd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aku kai matami ikoyo, aga vovomi kaduwe matatabuna giyuyuvana. E ada kai malina negenimiya giyuyuvana, aga yuyuvana bakibaki. ");
INSERT INTO bwd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Keke seyana gaito anafata gina vetogugai kauveya iluwei wagaidiya. Faina seyana gina dibusoyogena aku seyana gina nuwakabubuyena, o kai seyana wagaine gina idibumwaiga aku seyana gina awaegegena. Kaduwe anafaiweya, keke anafata wana vetogugai Yaubada wagaine aku kaduwe kaikaiwabu wagaine. Kai wana vetogugai kaikaiwabu wagaine, wada vaita yami yaubada ani au yami kaikaiwabu. ");
INSERT INTO bwd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Taidei faina gana vonemi, keke wana venuwana yami miyami faina, kai gavana wanakani o kai wanayuga, o kai vovomi faina, gavanuya wanaose. Faina yawaimi ani gaitoma lakaina ayo muliya aa. Ada kaduwe vovomi ani gaitoma lakaina ayo muliya nuya. ");
INSERT INTO bwd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wana itana manuga iyaveyavega. Keke ida bakubakula kai aa ida iyaiyala ke ida vedovedodoga kweda wagaine, e aku Tamami gabameya ani giitaitaveyabidi ke adiga giveleveledi. Ada imiyavo amiita lakaina ayo muliya manuga. ");
INSERT INTO bwd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gavaiyamu, kai tamo gaito wagaimiya yana venuwana wagaine anafata yawaina anaetowava maita-moena gina vemanawe? Au keke. ");
INSERT INTO bwd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ada gavana faina wavevenuwana nuya faina? Veiya walaiya itabotabo ani wana nuwenuwedi. Keke ida faifaisewa kai adinuya ida ionaonaga ");
INSERT INTO bwd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","e aku gana vonemi, Kini Solomoni anaveigavu kaikaiwabu-moedi, aku veiya taidei adiita ani iwaka-vagaidi ayo muliya Solomoni anaveigavu. ");
INSERT INTO bwd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ada Yaubada kai wala matatabuna giveiveigavuna veiya wagaine, ada malinai itabotabo aku malabutu ina alika ke kaliva ina batugedi aiya gina alaidi, aga gavaiyamu imiyavo? Gavana faina wanuwanuwa vaita Yaubada keke imi kaduwe gina veiveigavumi? Imi yami vetumagana Banae wagaine keke lakaina. ");
INSERT INTO bwd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tainei faina keke wana venuwana ada wanavona, ‘Gadedeku aa kanavai kanakani, o kai gufa kanayuga, o kai nuya kanavai kanaose?’ ");
INSERT INTO bwd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Faina babi anakaliva adiyoo moyaidi badi keke Yaubada ida alamane, ani tova moyaina taidei gaitoma-dina imadumadu leledi. Aku imiyavo ani bademowa Tamami gabameya gialamanena gavana amilauboda velemoena yami miya faina, e ada keke wana venuwana gaitoma-dina faidiya. ");
INSERT INTO bwd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aku gaitoma lakaina, ani Yaubada yana ebaveimeya ananuwanuwa wagaine wanamadu awaegemi ke yana nuwanuwa tunutunugina wana muliyena, ada Banae taidei gaitoma-dina moyaidi gina velevelemi. ");
INSERT INTO bwd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tainei faina keke wana venuwana malabutu faina. Faina malabutu ani kadu yadayada seyana wa anavita anaetowava anafaiweya, e ada keke tova malinai anavita wana vetutamwai malabutu anavita nodi. ");
INSERT INTO bwd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Keke kaliva wanavona venuvenuwadadanedi, e ada imi kaduwe Yaubada keke ginavona venuvenuwadadanemi. ");
INSERT INTO bwd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Faina gavaiyamu kaliva wavona venuvenuwadadanedi, anafaiweya kaduwe vona venuvenuwadadana wana nuwagana. Ada etowava-nai wagaine wavutuga, anafaiweya etowava-nai wagaine Yaubada gina vutuga wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Gavana faina geyalili kabiso-moena tubuiya matana wagaine ani uitaita, aku tauni mata wagaine ani ai tuli gimiyamiya, aku keke uda itainana? ");
INSERT INTO bwd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gavaiyamu-yo tubuiya wagaine uvonavona, ‘Tubuiyaku, unagai geyalili kabisona gana vaina mata wagaine,’ aku o tauni ani ai tuli mataniya? ");
INSERT INTO bwd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O meyalugaluga, gilubodana nagona ai tuli tauni mataniya una vaiyavulena, e ada muliya unaita dewadewa ke geyalili kabisona tubuiya matane una vaina. ");
INSERT INTO bwd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yaubada yana valeya iwakana keke wana awamogatale kavokavovo badi gavega wagaidiya ananogala idibusoyogena. Kai wana gugai anafaiweya, aga vaita gaitoma tabutabuna waveleveledi galuweta wagaidiya, o kai vaita kadu kabala kaikaiwabuna bawe wagaidiya waveleveledi. Ada aimo ina vagatagotagona, ke kaduwe ina miyaviladi ada ina yovami. ");
INSERT INTO bwd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Wana veoveola Yaubada wagaine ada gina velemi. Wana lelele ada wana nuwagana. Wana lufifita ke wagaimiya Yaubada wana gina yavuna. ");
INSERT INTO bwd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Faina gavega ina veoveola, Yaubada gina veledi. Kaduwe gavega ina lelele, ina nuwagana. Ada badi gavega ina lufifita, aga Yaubada wana gina yavuna faidiya. ");
INSERT INTO bwd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Imi wagaimiya ani kai gaito natu ginaela gina veola aa faina aga gavaiyamu, kabala una velena? Keke. ");
INSERT INTO bwd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O kai gina veola igana faina aga gavaiyamu, mota una velena? Keke. ");
INSERT INTO bwd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Imi tokoyona aku nuwakabubu iwakana waveleveledi natumiyavo, aku velemoena Tamada gabameya ani Banae iwaka-moena. E ada kai gavega ina veoveola wagaine, gina veleveledi gaitoma iwakadi. ");
INSERT INTO bwd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","E ada kai nuwanuwami kaliva inadewa iwakana wagaimiya, aga nagona imi wanadewa iwakana badi wagaidiya. Taidei veimeya-nai, ani giitavana Mosese yana veimeya matatabuna ada kaduwe falofitayavo yadi vona. ");
INSERT INTO bwd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Wana kikiwena wagaine wanaluku, faina eli anawana ani lalafana ke anawai anana meyameyaganina ada kaliva moyaidi wai-nai wagaine inaunau. ");
INSERT INTO bwd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aku yawai-vagata anawana kikiwena ada anawai ani anana vitana, ada wai-nai kaliva moyaidi keke ida nuwanuwaga, adigavaiyei gaga inuwanuwagana. ");
INSERT INTO bwd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Wana itaveyabimi falofita fwayafwaya faidiya. Badi inaelai wagaimiya anafaiweya sifi yadi dewa bikana, aku velemoena badi nuwainagediya vaita galuweta dalodalovidi anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","E ada yadi dewa wagaine wana itainanadi, kai guwadi iwakana o koyona. Gavaiyamu, anafata gileifi wana koludi sikakakama wagaine o kai alaa guwana wana koluna gudana onaonagidi wagaine? Keke. ");
INSERT INTO bwd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kai ai iwakana, aga guwana iwakana. Kai ai koyona, kaduwe guwana koyona. ");
INSERT INTO bwd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ai iwakana aga keke guwa koyona gina veguwaye, kaduwe ai koyona keke guwa iwakana gina veguwaye. ");
INSERT INTO bwd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ada gava ai keke guwana iwakana, ani inatala ginaobu ada ai alalata wagaine ina batugena. ");
INSERT INTO bwd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","E ada anafaiweya falofita fwayafwaya, guwadi wagaine wana itainanadi. ");
INSERT INTO bwd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Keke vaita badi moyaidi ivonavona wagaikuya ‘Kauveya, Kauveya’ ani inaluku Yaubada yana ebaveimeya wagaine. Tainei-mowa badi gavega Kamaku gabameya yana nuwanuwa wagaine igugai, badiyavo-gaga inaluku. ");
INSERT INTO bwd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tova gielaelai wagaine tomiyababi matatabudi ani Yaubada gina vevonayavugidi. Ada yadayada-nai wagaine, kaliva moyaidi Iya wagaikuya inavona ‘Kauveya, Kauveya, ayeganeya afalofisai, kaduwe ayeganeya aluwaluwa koyodi aveimeyedi iyegemona kaliva wagaidiya, ada ayeganeya gugai ebameyasidobodobo agugaiyedi.’ ");
INSERT INTO bwd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aku Iya gana lufata wagaidiya, gana vonaga, ‘Iya keke maita gada alamanemi. Imiyavo ani tova moyaina veimeya moyaina waawaegegedi ada yami gugai koyona. Wananau tabae!’ ");
INSERT INTO bwd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Taidei faina badi gavega yaku vona taidei inogalina ke igugaiyena ani badi vaita tonuwanuwa velemoena anafaiweya, bana yana manuwa givemididina ani anaavutuwa kwakwana ke kabala-gaga wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ada muliya wei gilugaga lakaina ke wayagata imadu ada gufa ituwalakaidi. Ada mala toyogina giveyuve manuwa-nai wagaine aku keke gidabe, faina avutuwa kwakwana ke kabala-gaga wagaine givemididina. ");
INSERT INTO bwd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Aku badi gavega yaku vona inoganogalina aku keke ida vegugaiye, ani badi anafaiweya kaliva kwavakwavana yana manuwa givemididina makama wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tova-nai wei gilugaga lakaina ke wayagata imadu ada gufa ituwalakaidi, ada mala giveyuve toyogina manuwa-nai wagaine ada giaguwei gibeu lakaina, e au matatabuna giayaweyaweli-yabuna.” ");
INSERT INTO bwd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ada taide nuwanuwa-dina anafaiweya Yeisu giifufuyedi giavaina, moyaidi meyadi gisidobodobona yana vewala-nai wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Faina keke Mosese yana veimeya anatovewalayavo ivewala anafaiweya Yeisu gida vewala, aku vaita kaliva seyana wa yana veimeya anafaiweya givewavewala. ");
INSERT INTO bwd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tova-nai Yeisu giobuelai oya wagaine ada yoo lakaina imuliyena. ");
INSERT INTO bwd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","E aku kaliva seyana banae vovona lefelo gikivekoyona, ani gielai Yeisu wagaine ada tugana givetodonena aku givona, “Kauveya, gaalamanena O afaiweya una kiveyegayeganeku. E ada kai nuwanuwa aga uda gugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ada Yeisu nimana gitunena ke gisena kaliva wagaine aku givonena, “Ika, nuwanuwaku. Una yegayegana.” Ada maduga-mowa analefelo giavaina. ");
INSERT INTO bwd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ada Yeisu kaliva givonena, “Una nogalina. Keke tamo gaito una awatalatalaine, aku unanau ada tauni una vewaleni Yaubada yana veyavo anatovegugai wagaine ke gina itani vovo ani gibwaina. Ada una vebolavoi Yaubada wagaine anafaiweya Mosese giveimeya badi gavega iveiwaka faidiya, e ada kaliva ina alamanena o velemoena bade uveiwaka.” ");
INSERT INTO bwd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ada Yeisu ginau Kafaneumi, aku tova-nai gina giluku ani meLoma tolugaviya aditonagona seyana gielai Yeisu wagaine ada lema faina giveola tagitagiya-mowa. ");
INSERT INTO bwd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Givonaga, “Kauveya, yaku togugai au manuweya gidaudau. Banae vovona memeluyana ada talaina iuloulolo lakaina.” ");
INSERT INTO bwd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ada Yeisu givonena, “Ganaela gana kivebwainina.” ");
INSERT INTO bwd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aku tolugaviya aditonagona gilufata wagaine, givona, “Kauveya, Iya keke kaliva iwakaku e ada keke analauboda o unaela unaluku yaku manuweya. Aku udavona-mowa ada yaku togugai gina bwaina. ");
INSERT INTO bwd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Faina Iya kaduwe akutoveimeya yana veimeya dibune gamiyamiya, ada yaku tolugaviyamomo yaku veimeya dibune imiyamiya. Yaku tolugaviya seyana gana vonena, ‘Unanau.’ Ada au ginanau. Kadu seyana gana vonena, ‘Unaelai.’ Ada au ginaelai. Anafaiweya kaduwe yaku togugai wagaine ganavona, ‘Taidei una faisewana.’ Ada gina faisewana.” ");
INSERT INTO bwd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ada Yeisu ginogalina tolugaviya aditonagona yana vona taidei ada meyana gisidobona, ada kaliva-dina imulimuliyena ani givonedi, “Gavonemi velemoena, Iya ganudadananau Isileli anafafali moyaidi wagaidiya, aku keke tamo gaito gada nuwaga yana vetumagana anatoyogina kaliva taide kwana Loma anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ada gana vonemi, aimo badi keke meIsileli moyaidi inaelai kauwana ebalakavine ke kauwana ebaoluna wagaine, ada Yaubada yana ebaveimeya wagaine Ebelaamo, Aisake, ke Iyakobo nodi adiivi ina vaidi ke ina enokekela abutu kanina wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aku badi meIsileli evona vaita Yaubada yana ebaveimeya anakalivayavo, ani ina batugedi ina yegemona wamelaleya yuyuvana bakibaki wagaine, ada wadedeku-deya ina tagitagiya ke ina kudaligoligota.” ");
INSERT INTO bwd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ada Yeisu gimiyavilana tolugaviya aditonagona givonena, “Unanau ya manuweya ada gavaiyamu uvetumagana anafaiweya, au taidei anafaiweya gina yegemona fainiya.” Ada tayuwe tova-nai Yeisu givonavona tolugaviya aditonagona wagaine, au yana togugai gibwaina. ");
INSERT INTO bwd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ada tolugaviya aditonagona ginau, aku muliya Yeisu gina giluku Pita yana manuwa wagaine, ani giitana Pita lawana vavine iveoga, vovodi gilukalalava lakaina ada iviya idaudau. ");
INSERT INTO bwd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ada ginau nimadi giabina ani veoga-nai giavaina aku vovodi gituluna. Ada imididi ke ivebutu Yeisu anaga ikidewadewa. ");
INSERT INTO bwd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aku mala givelavilavi wagaine, kaliva moyaidi gavega nafodiya aluwaluwa koyodi imiyamiya ani tubuiyadiyavo ialiyedi Yeisu wagaine. Ada aluwaluwa-dina giveyegemonidi yana vona wagaine, ada badi gavega iveoga ani matatabudi gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Taidei gaitoma-dina gifaisewadi ani gavana falofita Aiseya gifalofisai au giyegemo velemoena, givona, “Tauna Banae ani adaveoga givaiyavuledi ada gikivebwainida.” ");
INSERT INTO bwd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aku tova-nai wagaine Yeisu giitadi yoo lakaina imidififina faina, yana tonogalayavo giveimeyedi ke Banae nodi ina damana lavu fafaline. ");
INSERT INTO bwd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aku Mosese yana veimeya anatovewala seyana gielai Banae wagaine ada givona, “Tovewala, gadedeku O una naunau aga Iya nodi.” ");
INSERT INTO bwd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ada Yeisu gilufata wagaine, givonaga, “Galuweta walawala wa adiluwa, ada kaduwe manuga wa adiuba, aku Banae Kaliva Natuna keke tamo yana ebamiya ke gina venobali gina veyawai.” ");
INSERT INTO bwd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ada kadu kaliva seyana, banae yana tonogala seyana, gielai ada givonena, givona, “Kauveya, uda awaegeku nagona gadanau ada kamaku gada tavuna ayo gadaela gada muliyeni.” ");
INSERT INTO bwd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aku Yeisu givonena, givona, “Badi gavega aluwaluwadi alialikana ani unasei taudiyavo yadi toalika ina tavuna. Aku oyeni ani unaela una muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ada Yeisu giifufu giavaina, yana tonogalayavo nodi iyage waka wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ada keke tova manamanawena aku mala gifuwana ada lavu gimaduna, ada buli lakaidi waka iiwatavutavuna. Aku Yeisu ani waka muline givenobali gidaudau. ");
INSERT INTO bwd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","E ada yana tonogalayavo ina ilivaguna, ivonena, “Kauveya, uda kibababaleda! Kabiso-moena kana yababa!” ");
INSERT INTO bwd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ada Yeisu givonedi, “Imi yami vetumagana kabiso-moena. Gavana faina wamatauta?” Ada au gimididi mala ke buli giawatadi, ada maduga-mowa lavu matatabuna giniwalova. ");
INSERT INTO bwd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ada tonogalayavo meyadi gisidobodobona, ivona, “Ida gavakaliva ayo mala ke buli ani bonana imatawalewaleyena!” ");
INSERT INTO bwd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aku Yeisu gidamana ke giyalili lavu fafaline meGadala adifafali wagaine, ani kaliva adiselu iyegemona didikula adifafaliya ke ielai Bana wagaine. Kaliva-dina ani aluwaluwa koyodi nafodiya imiyamiya ke imanimanini koyo-moena. Taidei faina keke seyana gaito anafata wai-nai wagaine ginana. ");
INSERT INTO bwd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","E aku Yeisu iitana wagaine ada ivekovakova bonadi lakaina, ivonaga, “O Yaubada Natuna, gavana unagai wagaimeya? Gavaiyamu, uelai ke una kiveuloulolonima? Aku matavuloga anatova-moena ani aimo-yo ginaelai.” ");
INSERT INTO bwd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","E aku gadedeku iyalalakata wagaine aku maita-moena ginauwena, ani bawe moyaidi iduwaduwala. ");
INSERT INTO bwd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Au aluwaluwa koyodi Yeisu ialamamaiyena, ivonaga, “Kai una veyegemonema kaliva taidei wagaidiya, aga uda imilima adanau tayuwe bawe moyaidi wagaidiya adaluku.” ");
INSERT INTO bwd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ada Yeisu givonedi, “Wananau.” E ada iyegemona kaliva-dina wagaidiya aku inau ada iluku bawe wagaidiya. Ada au bawe matatabudi iluyabayabanunuga oya wagaine iobu ke ikamomola lavu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aku kaliva bawe itaitaveyabidi, ani iveotaota inau melala lakaina wagaine ada bawe faidiya iawatalatalaina ke kaduwe kaliva adiselu aluwaluwa koyodi nafodiya imiyamiya ani gavaiyamu iveiwaka faina valeyadi iawamogatalena. ");
INSERT INTO bwd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","E ada kaliva moyaidi melala lakaina wagaine iyegemona inau Yeisu ina itana. Ada inuwagana wagaine, ivonena ke ialamamaiyena vaita yadi fafali gina madusegeku ginanau. ");
INSERT INTO bwd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ada Yeisu giyage-vagila waka wagaine ada giyewana lavu fafaline tauna yana melala wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aku wadedeku-deya kaliva seyana gimiyamiya, banae vovona memeluyana, e ada kaliva tufodi vaya wagaine iwai ialiyena Yeisu wagaine. Ada Yeisu kaliva-dina yadi vetumagana giitana ada kaliva-nai wagaine givona, “Natuku, una vemwamwala. Ya koyona bademowa gavenuwaegedi.” ");
INSERT INTO bwd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aku veimeya anatovewalayavo tufodi inogalina ada taudiyavo nuwainagediya ivona, “Kaliva taidei givona awadamana.” ");
INSERT INTO bwd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aku Yeisu yadi nuwanuwa gialamanena e ada givonedi, givona, “Gavaiyamu-yo aseasemiya wanuwanuwa koyona? ");
INSERT INTO bwd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Faina gavavona meyameyagani-moena ganavona, ‘Ya koyona bademowa gavenuwaegedi’, o kai ganavona, ‘Una mididi ke una nudadana’? ");
INSERT INTO bwd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aku nuwanuwaku wana alamanena ani Banae Kaliva Natuna wa yana veimeya, e ada anafaiweya kaliva yadi koyona gina venuwaegedi babi taidei wagaine.” E ada au kaliva-nai vovona memeluyana ani Yeisu givonena, “Una mididi, avaya una waina ada unanau ya manuweya.” ");
INSERT INTO bwd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Au kaliva gimididi ada anavaya giwai ginau manuweya. ");
INSERT INTO bwd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ada gugai taidei yoo iitana wagaine meyadi gisidobodobona velemoena ada Yaubada iawadavadavana, faina veimeya ke toyogina giveledi kaliva-mowa e ada adifaiweya ina gugai taidei anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ada Yeisu fafali-nai gisegena aku gitauya ginaunau ani takesi anatoyaudi anayegana Madiu giitana takesi anavada wagaine givetovetoga. Ada Yeisu Madiu givonena, “Unaela una muliyeku.” Ada gimididi ke Yeisu gimuliyena. ");
INSERT INTO bwd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ada muliya Yeisu ginau Madiu yana manuwa wagaine ina vebailavi, aku badi takesi anatoyaudi moyaidi ke tokoyona kaduwe ielai, ada Yeisu yana tonogalayavo nodi ienokekela ikanikani. ");
INSERT INTO bwd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aku Falisiyavo tufodi ani iitadi, ada Yeisu yana tonogalayavo itolidadanedi, ivona, “Gavana faina yami tovewala takesi anatoyaudi ke tokoyona nodi ikanikani?” ");
INSERT INTO bwd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aku Yeisu yadi tolidadana ginogali-yo gilufata wagaidiya, givona, “Badi gavega iwakadiyavo ani keke nuwanuwadi doketa, aku badi toveoga-gaga ani nuwanuwadi. ");
INSERT INTO bwd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Aku imiyavo ani wananau Yaubada yana vona seyana ananuwanuwa wana lelena ke wana alamanena, givonaga, ‘Keke nuwanuwaku kevakeva wana vebolavoiye akuebaveyavo faina. Iya nuwanuwaku kaliva wana nuwakalikaliyedi.’ Faina Iya gaelai ani keke toyegayegana gana douwedi faina. Aiyada gaelai ke tokoyona gana douwedi.” ");
INSERT INTO bwd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aku aimo-yo seyana tova Iyoni Tobabitaiso yana tonogalayavo ielai Yeisu wagaine ada itolidadanena, ivona, “Gavana vuvuna ayo imeyavo ada Falisiyavo ani tova ke tova kani ailoilovau aku O ya tonogalayavo ani keke?” ");
INSERT INTO bwd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ada Yeisu givona matalivulivuna wagaidiya, givona, “Nagi anakani vemwamwala wagaine ani gavaiyamu, tonagi kaliva tubuiyanavo nodi ina miyamiya aku tubuiyanavo ina nuwavita e ada kani ina ilovau? Keke, faina tonagi-nai nodi imiyamiya. Aku tova gielaelai wagaine kaliva tufodi inaela tonagi kaliva ina vaina tubuiyanavo wagaidiya-deya ke ina nauwena, e ada yadayada-dina wagaidiya kani ina iloilovau.” ");
INSERT INTO bwd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ada kaduwe givona matalivulivuna-vagila, givona, “Keke nuya tuwaina kana bwadi nuya diyana evaguna wagaine. Faina aimo nuya diyana evaguna ginabuta wagaine gina siyauta, e ada nuya tuwaina gina agigina lakai-moena. ");
INSERT INTO bwd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kaduwe anafaiweya, keke waini evaguna ina iwavedama tuwava kevakeva bubuna tuwaina wagaidiya. Faina waini evaguna yana lutuga wagaine tuwava bubu-dina gina fuwadi ada waini gina maduyabu ke tuwava bubu inakoyo. Aku analauboda waini evaguna ina iwana tuwava evaguna wagaidiya, e ada waini ke tuwava yadi miya iwakana.” ");
INSERT INTO bwd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeisu taidei anafaiweya aimo giifuifufu ani manuwa ebavewala anatonagona seyana gielai, ada tugana givetodonena Yeisu magigine ke givona, “Malinai-mowa natuku vavine yawaina giavaina. Aku udaela nima udasena bana wagaine ke yawaina gida nuwaga-vagilena.” ");
INSERT INTO bwd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Au Yeisu gimididi gimuliyena, ada kaduwe yana tonogalayavo nodi inau. ");
INSERT INTO bwd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aku yoo-dina wagaidiya vavine seyana banae anaveoga ani malamala tuwelo dayagina gimadumadu. Ada vavine-nai Yeisu wamuline gielai, ke ananuya bwatana wagaine nimadidina gisedi. ");
INSERT INTO bwd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Faina nuwainagene-deya givona, “Kai ananuya gagana wagaine nimadidiku ganasedi, aga gana veiwaka.” ");
INSERT INTO bwd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ada Yeisu gimiyavila giitana ada givona, “Natuku, una vemwamwala. Ya vetumagana gikivebwainini.” Ada tayuwe tova-nai wagaine vavine gibwaina. ");
INSERT INTO bwd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ada Yeisu gina giluku tonagona yana manuweya, ada giitana ani kulele anatoveneganega yadi kulele iyuveyuvedi alika faina, ke kaduwe totagiya yoo ani itagilukuikui ada ivevetalageyo, ");
INSERT INTO bwd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ada givonedi, “Wana yegemona wananau. Kwamana keke gida alika aku gidaudau.” Aku badi iveleigena. ");
INSERT INTO bwd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","E au yoo giveyegemonidi wamelaleya aku Bana giluku, ada kwamana nimane gikiveyabina ada au gimididi. ");
INSERT INTO bwd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ada valeya taidei gimutula ginau tayuwe fafali-nai matatabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ada Yeisu wadedeku-deya giyegemona ginaunau ani kaliva adiselu matadi koyo-moedi imulitagoiye inau aku ivedoudou, ivonavona, “Oye Deivida yana tubudelideli, uda nuwakalikaliyema!” ");
INSERT INTO bwd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ada Yeisu gina giluku manuwa wagaine aku badi adiselu-dina matadi koyo-moedi ani ielai Bana wagaine, ada gitolidadanedi, “Gavaiyamu, wavetumagana vaita taidei Iya akufata gana gugai?” Badi ilufata ivonaga, “Ika Kauveya.” ");
INSERT INTO bwd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ada nimana gisena matadiya aku givona, “Yami vetumagana faina ada anafaiweya gina yegemona wagaimiya.” ");
INSERT INTO bwd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ada au matadi giyegayegana. Ada Yeisu veimeya toyogina giveledi, givona, “Wana itaveyabina keke seyana gaito gina alamane gaitoma taidei.” ");
INSERT INTO bwd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aku badi adiselu iyegemona inau, ada valeyana iveinalina tayuwe fafali-nai matatabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ada kaliva-dina adiselu inaunau aku kaliva seyana tubuiyanavo ialiyena Yeisu wagaine. Kaliva-nai aluwaluwa koyona nafone gimiyamiya ke giveiveimeyena faina, banae gaugauna. ");
INSERT INTO bwd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","E ada Yeisu aluwaluwa koyona giveyegemonina ada kaliva-nai gaugauna au giifufu. Ada yoo meyadi gisidobodobona ke ivona, “Keke tamo anafaiweya adaita Isileli wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aku Falisiyavo ivonaga, “Ina aluwaluwa koyodi aditonagona Seitani, ani banae yana toyogina wagaine e ada Yeisu aluwaluwa koyodi giveveyegemonidi.” ");
INSERT INTO bwd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ada Yeisu gibalawalilivuga melala moyaidi lakaidi ke kabikabisodi wagaidiya, ada meIsileli yadi manuwa ebavewala wagaidiya givevewala, kaduwe valeya iwakana gilumamalena Yaubada yana ebaveimeya faina. Ada kaliva ke vevine wa adiveoga tulina tulina ani matatabudi gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ada yoo lakaina giitadi wagaine ginuwakalikaliyedi, faina adivita lakaina wagaidiya ivenuwana lakaina ada kabekabebediyavo, vaita sifi keke aditoitaveyabina anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ada yana tonogalayavo givonedi, givona, “Bavagu lakai-moena aku tofaisewa keke moyaidi. ");
INSERT INTO bwd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Taidei faina bavagu anaKauveya wana veolena ke tofaisewa gina imilidi ina yegemona inanau yana bakula giboyalina bavagu faina.” ");
INSERT INTO bwd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ada Yeisu yana tonogalayavo adituwelo gidouwevagauwidi ke veimeya giveledi e ada wa yadi veimeya aluwaluwa bwanebwanenedi ina veyegemonidi kaliva wagaidiya, ada kaduwe kaliva wa adiveoga tulina tulina ani matatabudi ina kivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ada afositolo-dina adituwelo adiyegana taidei anafaiweya. Nagona Saimoni banae ivewagana Pita, ada taina Andulu, Iyemesa ke taina Iyoni, adiselu Sebedi natunavo. ");
INSERT INTO bwd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi ada Batolomiu ke Tomasi ada Madiu banae takesi anatoyaudi, Iyemesa banae Alifiyo natuna, ke Tadiyasi, ");
INSERT INTO bwd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ada Saimoni Seloti, ada Yudasa Isakaliyota banae Yeisu gina atuegena nibainavo nimadiya. ");
INSERT INTO bwd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ada kaliva-dina adituwelo Yeisu giimilidi ke giveimeyedi, givonaga, “Badi keke meIsileli ani keke wagaidiya wana nauna, kaduwe keke meSameliya yadi melala lakaidi wagaidiya wanaluku. ");
INSERT INTO bwd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Aku wananau meIsileli wagaidiya, badi Yaubada imiyasegena e ada vaita sifi nunusegediyavo anafaiweya imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Wananau aku wana lulumamala wagaidiya wanavona, ‘Yaubada yana ebaveimeya bademowa givelilivana.’ ");
INSERT INTO bwd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ada toveoga wana kivebwainidi, toalika wana siveyawadi, tolefelo wana kiveyegayeganedi, ada aluwaluwa koyodi wana veyegemonidi kaliva wagaidiya. Iya gavele-kavovomi ke imi wanuwagana, e ada imi kaduwe kaliva wanavele-kavovodi. ");
INSERT INTO bwd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Keke tamo mani amifoseya wanawai. ");
INSERT INTO bwd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Keke fose lakaina wanawai yami nau-nai faina, keke seti anavelu, keke ageyafayafa anavelu, kaduwe keke aiwala. Faina tofaisewa adilauboda adiga ina nuwagana badi biyavo-dina ilemelemedi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aku gavamelala lakaina o kai melala kabisona wagaine wanaluku, wana madulele gavakaliva yana dewa iwakana ada gina vagaulemi wananau yana manuweya, ada nodi wanamiya analaba wana tauya-vagila. ");
INSERT INTO bwd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ada manuwa-nai wagaine wanaluku aga manuwa anatomiya wanamadu vesiuleyedi. ");
INSERT INTO bwd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kai gabu-dina nuwadi iwakana ke ina vetubuiyanemi, aga wanavona nuwakabubuyedi, wanavona, ‘Yaubada yana nuwaniwalova gina miyamiya wagaimiya.’ Ada yami vona ina venogalena ke yami nuwaniwalova-nai ginamiya wagaidiya. Aku kai keke nuwadi iwakana ke ina vetubuiyanemi, aga yami nuwaniwalova-nai gina yewana wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ada kai tamo gaito keke gina vagaulemi o kai keke yami vona gina nogali, aga kaliva-nai yana manuwa kai melala-nai wana segena wagaine, anasivu agemiya wana vatuegegena. ");
INSERT INTO bwd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gavonemi velemoena, aimo vonayavuga anayadayada wagaine melala-nai anatomiya idibusoyogemi, ani adimatavuloga koyo-moena ayo muliya meSodoma ke meGomola adimatavuloga. ");
INSERT INTO bwd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Waitana, Iya gaimiimilimi wana yegemona wananau vaita sifi anafaiweya, wanaunau galuweta walawala manimaninidi adimwatuguya. Taidei faina wana vetonuwanuwa velemoena, aku kaduwe wana dewadewa bikana vaita bunebune yadi dewa anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ada wana itaveyabimi, faina aimo kaliva ina kiveyabimi ina nauwemi ina vevonayavugimi, ada yadi manuwa ebavewala wagaidiya ina lavulavumi. ");
INSERT INTO bwd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ada imi yaku tonogalayavo faina, ina vaimi ina nauwemi toveimeya lakaidiyavo ke kiniyavo wagaidiya. E aku taidei tova-dina wagaidiya ani yami tova iwakana ke Iya faikuya valeya iwakana wana awatalatalaina badi wagaidiya, ada kaduwe badi keke meIsileli wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aku tova-nai ina vevonayavugimi, keke wana venuwana gavaiyamu wanavona. Faina gavana Yaubada nuwanuwana wana vonayena ani tova-nai wagaine gina alavelevelemi. ");
INSERT INTO bwd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Faina yami ifufu ani keke taumiyavo yami nuwenuweya gina yegemona, aku Tamami gabameya Aluwaluwana ani awamiya gina vonavona. ");
INSERT INTO bwd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kaliva seyana tauna anatubuluga ginavai toveimeyayavo nimadiya ginasena ke ina luvealikana, ada tama natudiyavo ina vaidi toveimeyayavo nimadiya inasedi ke ina luvealikadi. Kaduwe biyabiyama inadiyavo ke tamadiyavo ina venibainedi ada ina vaidi toveimeyayavo nimadiya inasedi ke ina luvealikadi. ");
INSERT INTO bwd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ada kaliva moyaidi ina agougemi, faina imi yaku tonogalayavo. E aku badi gavega ina atuvefaila-vagata yadi vetumagana wagaine ke Yaubada ina labina analaba yawaidi anaebalauyabu wagaine, Banae gina kibababaledi. ");
INSERT INTO bwd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tova-nai valeya iwakana wana awamogatalena melala seyana wagaine aku ina kiveuloulolonimi, aga wanaota wananau mali melala wagaine. Gavona velemoena wagaimiya, aimo keke yami gugai wana luyabu Isileli melalidi moyaina nafodiya aku Banae Kaliva Natuna ginayewa. ");
INSERT INTO bwd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tonogala ani keke ida kaiwabusege yadi tovewala, kaduwe togugai ani keke ida kaiwabusege aditoveimeya. ");
INSERT INTO bwd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Taidei faina gavaiyamu idewena tovewala, anafaiweya kaduwe ina dewena yana tonogala. Ada gavaiyamu idewena toveimeya, anafaiweya kaduwe ina dewena yana togugai. E ada Iya yami yoo anatonagona, ada kai bademowa Iya iawavekoyoyeku ke ivewagaku Biyelisibuli, aga imi yaku yooyavo ina awavekoyoyemi velemoena. ");
INSERT INTO bwd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Taidei faina kaliva-dina ikiveuloulolonimi ani keke wana matausedi. Faina gaitoma-dina tova malinai ivetalafufudi ani aimo ina vetaladadedi, kaduwe gaitoma-dina sewasewavuyedi ani aimo kaliva moyaidi ina alamanedi. ");
INSERT INTO bwd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gavana yuyuvaneya gavonayena makakaumiga wagaimiya ani aimo yadeyadeya wana awamogatale. Ada gavana gaifufu kavuyena wagaimiya, ani aimo wamelaleya wana awatalatalainena. ");
INSERT INTO bwd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Badi gavega vovomi gaga ina luvealikana aku keke adifata aluwaluwami ina luvealika, ani keke wana matausedi. Aku aiyada Yaubada wana matausena, faina Banae anafata vovomi ke aluwaluwami nodi gina luyavulelugedi eli wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wana itana manuga kibita. Kai iluwei kana kimonedi aga fatadi keke lakaina, wani toya-gaga. E aku keke seyana ginabe babiya aku Tamami gabameya nagona gina awaegau. ");
INSERT INTO bwd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Aku imiyavo ani Banae ginuwanuwa lakaina faimiya ayo manuga kibita moyaidi. Ika velemoena, kuluwami anavutuvutu adiveyawa gialamane-yabudi. E ada keke wana matauta. Imi amiita lakaina Yaubada matane. ");
INSERT INTO bwd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“E ada gavakaliva keke gina matauta aku kaliva matadiya gina awamogatala, ginavona, ‘Iya Yeisu Keliso yana kaliva’, aga Iya kaduwe anafaiweya Kamaku matane gabameya gana awamogatala, ganavona, ‘Banae yaku kaliva’. ");
INSERT INTO bwd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aku gavakaliva gina matauta ada kaliva matadiya gina veweyeku ginavona, ‘Iya keke Yeisu yana kaliva’, aga anafaiweya kaduwe Iya Kamaku matane gabameya gana veweyena, ganavona, ‘Banae keke yaku kaliva’. ");
INSERT INTO bwd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Keke wana nuwanuwa vaita gaelai babiya ke miya niwalova gada aliye. Keke miya niwalova ganasei faina gadaela, keke. Aku Iya gaelai ani venibaina gana aliyena. ");
INSERT INTO bwd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","E ada Iya faikuya ‘kaliva gina venibaina tamana wagaine, kaduwe vavine gina venibaina inana wagaidiya, kaduwe vavine lawadi nodi ina venibaina. ");
INSERT INTO bwd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ada kaliva nibainavo ani au tauna yana gabuyavo.’ ");
INSERT INTO bwd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kai gavega inadiyavo o kai tamadiyavo faidiya ani adinuwanuwa ivewainagoyedi ayo muliya Iyayeku, aga keke adilauboda badi yaku tonogalayavo. Kaduwe gavega natudiyavo kaliva o kai vevine inuwakabubuyedi lakaina ayo muliya Iyayeku, aga keke adilauboda badi yaku tonogalayavo. ");
INSERT INTO bwd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kaduwe gavega keke yawaidi ina awaege ke taudiyavo adikelose ina avala ada ina muliyeku, aga keke adilauboda badi yaku tonogala. ");
INSERT INTO bwd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ada badi gavega nuwanuwadi taudiyavo yawaidi ina kibababaledi, ani yawaidi ina nusegedi. Aku gavega Iya faikuya yawaidi ina nusegedi, ani yawaidi miyamiyani-vagaina ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Badi gavega imi ina sivaivaimi, ina Iya kadu isivaivaiku. Ada gavega Iya isivaivaiku, ina Banae giimiliku kadu isivaivaina. ");
INSERT INTO bwd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kadu badi gavega Yaubada yana falofita isivaivaina faina banae Yaubada yana falofita, aga falofita fatana iwakana anafaiweya badi ina vaina. Ada gavega isivaivaina toyegayegana faina kaliva-nai yegayegana, aga toyegayegana fatana iwakana anafaiweya badi ina vaina. ");
INSERT INTO bwd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ada badi gavega gufa vei ina velena kwamana kabisona taidei anafaiweya faina banae yaku tonogala, aga gavonemi velemoena, fatadi iwakana ina nuwagana.” ");
INSERT INTO bwd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeisu yana tonogalayavo adituwelo givewaledi giavaina, gitauya ginau Galili melala-dina wagaidiya ke givevewala ada Yaubada valeyana gilulumamalena. ");
INSERT INTO bwd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aku Iyoni Tobabitaiso deli wagaine gimiyamiya ani Mesaiya yana faisewa valeyana ginogalina, e ada yana tonogalayavo tufodi giimilidi Bana wagaine ina tolidadana. ");
INSERT INTO bwd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ada ielai Yeisu wagaine ivonaga, “Gavaiyamu, Oye kaliva-moe Tauni Mesaiya, Banae aveitabodebodena vaita ginaelai? O kai kaliva seyana aimo ana bodana?” ");
INSERT INTO bwd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ada Yeisu gilufata Iyoni yana tomatawa wagaidiya, givona, “Wana yewami Iyoni wagaine ke gavana gagugaiyedi waitadi kadu gaifufuyedi wanogalidi, ani faidiya wana ifufuyena. Taidei anafaiweya wanavona, ");
INSERT INTO bwd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Badi matadi koyo-moedi ani iita iwakana, tovefela inunudadana, badi gavega lefelo wagaidiya ani ibwaina ke yadi yegayegana ivaina, badi tagadi bwadana ani giafolena, toalika iyawa-vagila, ada kaduwe fanifanidiyavo ani Yaubada yana valeya iwakana inoganogalina.’ ");
INSERT INTO bwd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kaduwe Iyoni wana vonena, ‘Badi gavega keke ida nuwakila ke yadi vetumagana Iya wagaikuya keke idasege, ani Yaubada giawanuwakabubuyedi.’” ");
INSERT INTO bwd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ada badi Iyoni yana tomatawa itauya inaunau, aku Yeisu givebutu yoo wagaidiya giifufu Iyoni faine, givonaga, “Tova-nai wayegemona wanau fafali kavovona wagaine Iyoni wana itana faina, imi gavaiyamu wanuwanuwa, vaita gavana wadaita? Vaita kaliva yana nuwanuwa tova moyaina gisevedavedama anafaiweya laimwagu lukuna mala giliuda gifilina? ");
INSERT INTO bwd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kai keke, aga wanau gavana wadaita? Kai kaliva giveigavu nuya adiita iwakadi wagaine? Keke, faina badi gavega wa adiveigavu kaikaiwabuna ada imiya kaikaiwabu ani kini yadi manuwa kaikaiwabudi wagaidiya imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","E aku imi wanau evona gavana wadaita? Anaita Yaubada yana falofita seyana wada itana? Ika velemoena, au falofita waitana, aku bana Iyoni ani anayegana lakai-moena ke anaita lakaina ayo falofitayavo moyaidi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Faina bana Iyoni faine Yaubada yana vona vetovetokilumina Buki Tabu wagaine givona, ‘Una itana, yaku tomatawa gana imilina ke wai gina nagona, ada ya wai kaliva aseasediya gina kidewedewena.’ ");
INSERT INTO bwd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ada gavonemi velemoena, kaliva moyaidi vevine ivenatunedi wagaidiya, ani keke seyana gaito anayegana lakaina ani Iyoni Tobabitaiso anayegana gidasege. E aku Yaubada yana ebaveimeya wagaine, gaito anayegana kabiso-moena ani banae gitubusegena Iyoni. ");
INSERT INTO bwd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tova-nai Iyoni Tobabitaiso yana tova laumamala givevuvu wagaine ada gielai malinai, Yaubada yana ebaveimeya wa yana toyogina gilaka ginaunau, ada badi gavega yawaidi iawaegena Banae wagaine, ani ibalalava ke yana ebaveimeya wagaine inaluku. ");
INSERT INTO bwd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ada tova tuwaina gielai anaetowava Iyoni yana tova wagaine, ani Mosese yana Veimeya anabuki kadu falofita moyaidi ifalofisai Yaubada yana ebaveimeya yanaela faina. ");
INSERT INTO bwd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ada kai wana awaegau ada nuwami gina malina gavana Iya gavonavonayena Iyoni faina, banae ani au Ilaitiya anafaiweya, ada banae faine falofitayavo ifalofisai vaita ginaelai. ");
INSERT INTO bwd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Imi gavega wa tagami ani vona taidei wada nogalina. ");
INSERT INTO bwd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Aku tova malinai anayooyavo, ani gavana wagaine gana itaveluveye? Badi anafaiweya biyabiyama ivetovetoga iveneganega maketi wagaidiya, ada yoo seyana ivedovedou kadu yoo seyana wagaidiya, ivonavona, ");
INSERT INTO bwd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nagi anakweli aveneganegayedi aku imi keke wada tavotavola. Ada alika anaitavuna anakweli aveneganegayedi aku imi keke wada tagitagiya.’ ");
INSERT INTO bwd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Taidei anafaiweya gavona, faina kaliva malinai ani badiyavo anafaiweya. Faina Iyoni gielai ada keke aa iwakana gida kanikani kaduwe keke waini gida yuyui, aku au kaliva iawavekoyoyena, ivonaga, ‘Banae aluwaluwa koyona nafone gimiyamiya.’ ");
INSERT INTO bwd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aku Banae Kaliva Natuna gielai ada aa iwakana gikanikani ke waini giyuyuga, ani kaduwe Banae iawavekoyoyena, ivona, ‘Wana itana, kaliva taidei awatabewa ada waini giyugayuga-faila. Kaduwe takesi anatoyaudi ke tokoyona givetubuiyanedi.’ Aku badi gavega Yaubada yana nuwauya imulimuliyena, ani kaliva ina itanuwagana yadi gugai wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aku melala tufodi wagaidiya Yeisu yana gugai ebameyasidobodobo moyaina gigugaiyedi, aku kaliva yadi dewa koyona wagaine keke ida nuwavila. Taidei faina Yeisu givebutu giawavekoyoyedi, ");
INSERT INTO bwd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","givonediga, “Oiyoi meKolasini! Vita lakaina wana nuwagana! Oiyoi meBedasaida! Vita lakaina wana nuwagana! Faina gugai ebameyasidobodobo gafaisewadi amimwatuguya nonogana keke wada nuwavila. Aku kai gugai-dina gada faisewadi badi kaliva koyodiyavo meTaiya ke meSaidoni adimwatuguya, aga badi tuwai-moena ida nuwavilana ke wa adinuya koyodi ida vetovetoga avu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gana vonemi, aimo vonayavuga anayadayada wagaine, imi meKolasini ke meBedasaida ani amimatavuloga koyo-moena ayo muliya meTaiya ke meSaidoni. ");
INSERT INTO bwd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aku imi meKafaneumi, evona taumiyavo wana kilakaimi vaita wanalaka gabameya? Keke! Velemoena ina segeobuyemi eli wagaine. Faina taidei yaku gugai ebameyasidobodobo moyaina gagugaiyedi amimwatuguya nonogana keke wada nuwavila. Kai meSodoma adimwatuguya gugai-dina gada gugaiyedi, aga tuwai-vagaina ida nuwavilana ke tova malinai aimo ida miyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Gana vonemi, aimo vonayavuga anayadayada wagaine, imi meKafaneumi amimatavuloga koyo-moena ayo muliya meSodoma adimatavuloga.” ");
INSERT INTO bwd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tayuwe tova-nai wagaine Yeisu givona, “Kamaku, Oyeni gabama ke babi adiKaiwabu ke adiKauveya, ada gavesiule wagainiya faina gaitoma-dina adialamana usewavuyena badi tonuwanuwa velemoena ke toalamana wagaidiya e ada keke ina alamane, aku badi anafaiweya biyabiyama ani wagaidiya uivemogatalina. ");
INSERT INTO bwd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ika Kamaku, taidei ya vemwamwala faina, anafaiweya ugugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kaduwe Yeisu yoo wagaidiya givona, “Gaitoma moyaina bademowa Kamaku gisedi nimakuya. Keke tamo gaito Banae Yaubada Natuna gida alamanena, au Tamana anakaibe gialamanena. Ada kaduwe anafaiweya Tamana, keke tamo gaito gida alamane. Au Natuna anakaibe gialamanena Tamana, ada kaduwe biyavo-dina givenuwadadanedi, ani badi wagaidiya Tamana gina ivemogatalina ke ina alamanena.” ");
INSERT INTO bwd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Imi gavega wakabekabebena faina yami veinuwana vitana wawaiwaina, ani Iya wagaikuya wanaelai ada veyawai gana velemi. ");
INSERT INTO bwd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yaku ewa wana vaina ada Iya wagaikuya alamana wana vaina, faina Iya tonuwaobu ada kaduwe yaku dewa bikana. Taidei wagaine yami veyawai velemoena wana nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Faina yaku ewa ke yaku veinuwana ani keke vitana aku meyameyaganina.” ");
INSERT INTO bwd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Muliya Sabate seyana wagaine Yeisu yana tonogalayavo nodi inunugolota bakula witi wagaidiya. Aku tonogalayavo mafa gilavudi faina, ivebutu witi guwana ikidakadaka ikanikani. ");
INSERT INTO bwd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aku badi Falisiyavo ani iitadi ada Yeisu ivonena, ivona, “Una itana, ya tonogalayavo witi guwana ikidakadakadi, e ada Sabate anaveimeya keke ida itaveyabi.” ");
INSERT INTO bwd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bana givonedi, givonaga, “Aku maita waveyawanuwagana gavana Kini Deivida gigana tova-nai yana yooyavo nodi mafa gilavudi wagaine? ");
INSERT INTO bwd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Giluku Yaubada yana manuwa wagaine ada beledi vevetabuna Yaubada matane isena, ani givaina ada banae ke yana kalivayavo nodi ikanina. Aku beledi-nai ani anaveimeya vitana velemoena. Keke kaliva-kavokavovo inakani aku badi veyavo anatovegugai-gaga adiawaega ke ina kanina. ");
INSERT INTO bwd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ada kaduwe maita waveyawana adaVeimeya anabuki wagaine, ani veyavo anatovegugaiyavo manuwa tabu negenine ifaifaisewa Sabate wagaine, e ada Sabate idewena vaita keke tabutabuna, nonogana Yaubada matane badi kaduwe keke yadi koyona? ");
INSERT INTO bwd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gavonemi velemoena, manuwa tabu ani tabutabuna velemoena, aku malinai idedeku kaliva seyana nodi kamiyamiya ani gitubusegena manuwa tabu. ");
INSERT INTO bwd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yaubada yana vona seyana givonaga, ‘Keke nuwanuwaku kevakeva wana vebolavoiye akuebaveyavo faina. Iya nuwanuwaku kaliva wana nuwakalikaliyedi.’ Kai vona tainei ananuwanuwa maita wada alamanena, aga yaku tonogalayavo badi Yaubada matane keke wa yadi koyona, ani keke wada awavekoyoyedi vaita wa yadi koyona imiyamiya ke matavuloga adilauboda. ");
INSERT INTO bwd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Faina Banae Kaliva Natuna ani Tauna Sabate anaKauveya.” ");
INSERT INTO bwd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ada Yeisu bakula waina gielai, ada gina giluku yadi manuwa ebavewala wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aku manuwa-nai wagaine ani kaliva seyana gimiyamiya nimana memeluyana. Ada kaduwe kaliva tufodi imiyamiya, ani badi vuvu ilelelena ke Yeisu ina awavekoyoyena. E ada itolidadanena ivona, “Gavaiyamu, adaveimeya giawaegau ada analauboda Sabate wagaine kaliva kana kivebwainina o kai keke?” ");
INSERT INTO bwd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeisu givonedi, givona, “Tamo gaito wagaimiya kai yana sifi ginabeu kavuya Sabate wagaine, aga gavaiyamu, ginana gina silakai ginalaka o kai keke? Sabate e aku au ginana gina silakaina. ");
INSERT INTO bwd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kaliva ani velemoena gaitoma lakai-moena ada muliya sifi. Taidei faina gavakaliva Sabate wagaine aku tubuiyana gina lemena, tainei velemoena ani Sabate anaveimeya giitaveyabina.” ");
INSERT INTO bwd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Taidei anafaiweya Yeisu givonedi aku nimakoyo wagaine givona, givonaga, “Nima una sivetotona.” Ada nimana gisivetotona, ani au giveiwaka-yabu anafaiweya nimana fafalina iwakana. ");
INSERT INTO bwd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aku badi Falisiyavo itauya ada inau iveifuifufuyena gavaiyamu Yeisu ina luvealika. ");
INSERT INTO bwd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aku Yeisu gialamanena Falisiyavo yadi nuwanuwa faina, melala-nai gisegena. Ada ginaunau aku yoo lakaina imuliyena, ada yadi toveoga matatabudi gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aku giawatadi evona keke valeyana ina ifufuyedadane e ada kaliva ina alamane Banae gaito. ");
INSERT INTO bwd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Taidei anafaiweya gigugai e ada Yaubada yana vona tuwaina falofita Aiseya givonayena, ani gina yegemona velemoena. Banae Yeisu faine Yaubada givona, ");
INSERT INTO bwd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wana itana yaku togugai gavenuwadadanena. Banae ganuwakabubuyena lakaina ada nuwaku gikivemwamwalina lakaina. Aluwaluwaku ganasena Banae wagaine, ke yaku veimeya tunutunugina gina awamogatalena badi keke meIsileli adiyoo tulina tulina wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Banae keke kaliva nodi ina gavekwavekwageya o kai gina awafatafata, kadu keke tamo gaito bonana ina nogali melaleya. ");
INSERT INTO bwd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kaukaula giafilina ani keke gina kidobo, kadu mayale gialata weuweu meyana ani keke gina yuveweu. E, anafaiweya kaliva aluwaluwadi ikabekabebena ani keke gina dibusoyogedi aku gina lemedi. Ada yana gugai wagaine gina atuvefaila ke gina vevilaga-deeya, Yaubada yana veimeya tunutunugina wagaine mali nuwanuwa gina toyogisegedi. ");
INSERT INTO bwd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ada badi keke meIsileli Bana wagaine ina nuwavetumagana adikibababala faina.” Taidei anafaiweya Aiseya yana vona anatubuga. ");
INSERT INTO bwd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aku kaliva seyana banae aluwaluwa koyona nafone gimiyamiya faina, bana matana koyo-moena ke kaduwe gaugauna. Ada kaliva-nai ialiyena Yeisu wagaine ke gikiveiwakanena, e ada givebutu giifufu ke giita. ");
INSERT INTO bwd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ada kaliva moyaidi meyadi gisidobodobona ke ivetolitoli ada ivona, “Kai ida Banae Deivida yana tubudelideli?” ");
INSERT INTO bwd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aku Falisiyavo kaliva yadi vona inogalina ada taudiyavo-gaga ivonavona, “Ina aluwaluwa koyodi aditonagona Biyelisibuli, ani banae yana toyogina wagaine e ada kaliva taidei aluwaluwa koyodi giveveyegemonidi.” ");
INSERT INTO bwd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aku Yeisu yadi nuwanuwa gialamanena ada givonedi, “Gava ebaveimeya seyana aku anayoo taudiyavo ina ludakadi e ada yoo tulina tulina nodi ina lulugaviya, aga ebaveimeya-nai ginabeu. Kaduwe gavamelala o unuma anakalivayavo taudiyavo ina ludakadi ke nodi ina lulugaviya, aga melala-nai o kai unuma-nai ginabeu. ");
INSERT INTO bwd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kaduwe anafaiweya, kai Seitani tauna yana togugai giveveyegemonidi, tainei aluwaluwa koyodi, aga gavaiyamu yana ebaveimeya gina mididi? Keke meyameyaganina. ");
INSERT INTO bwd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Imi wavona vaita Biyelisibuli yana toyogineya aluwaluwa koyodi gaveveyegemonidi. Aku kai Iya Biyelisibuli yana toyogineya gaveveyegemonidi, aga gaito yami tomuliyayavo toyogina giveledi ayo aluwaluwa koyodi iveveyegemonidi? E ada taumiyavo yami tomuliyayavo inavona venuvenuwadadanemi vaita wavona sidamana. ");
INSERT INTO bwd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aku velemoena ida Yaubada Aluwaluwana yana toyogineya, ada taidei wagaine aluwaluwa koyodi gaveveyegemonidi. E ada waitana, bademowa Yaubada yana ebaveimeya giyegemona wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kai kaliva totoyogina yana manuweya gina miyamiya, aga keke tamo gaito anafaiweya ginaluku kaliva yana lokoloko ginavai. Aku kai nagona kaliva-nai totoyogina gina yogona, aga muliya yana lokoloko gina vaidi. ");
INSERT INTO bwd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Banae gaito Iya keke nodi, ani banae givenibaineku. Kaduwe banae gaito keke kaliva gida vagavagauwidi ke Iya nodi ada gugai seyana, ina banae gidewadewa vaita kaliva gida wavidi e ada keke ina muliyeku. ");
INSERT INTO bwd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tainei faina gana vonemi, kaliva yadi dewa koyodi seyana seyana ani Yaubada anafaiweya gina venuwaegedi, ada kaduwe gavavona wagaine inavona awadamana ani anafaiweya gina venuwaegedi. Aku Aluwaluwa Tabuna ani badi gavega Banae inavona awadamanena, tainei yadi koyona ani keke-mowa Yaubada gina venuwaege. ");
INSERT INTO bwd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ada gavega inavona koyona Bana Kaliva Natuna faine, tainei Yaubada gina venuwaegena. Aku Aluwaluwa Tabuna ani badi gavega Banae inavona awadamanena, tainei yadi koyona ani keke-mowa Yaubada gina venuwaege. Keke tova malinai ke kadu keke tova gielaelai wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kai ai iwakana aga anafaiweya kadu guwana iwakana. O kai ai koyona aga anafaiweya kadu guwana koyona. Ai guwana kana itana wagaine, kana alamanena ai-moena iwakana o kai koyona. ");
INSERT INTO bwd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Imi vaita mota natunavo anafaiweya, mota-nai koyo-moena giluluvealika! Imi kaliva koyomiyavo e ada keke amifata ifufu iwakana wana ifufuye. Faina gavana givemaga-iwaiwana kaliva aseasediya, tainei awadiya ivonavonayena. ");
INSERT INTO bwd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaliva iwakadi ani ivonavona iwakana, faina nuwanuwa iwakadi ivelakavidi aseasedi wagaidiya ani iyegeyegemona. Aku kaliva koyodi ani ivonavona koyona, faina nuwanuwa koyodi ivelakavidi aseasedi wagaidiya iyegeyegemona. E ada gavana aseaseda givemagana, aga yada vona wagaine gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aku gana vonemi, aimo tova vevonayavuga wagaine kaliva yadi vona kavokavovo seyana seyana faine, Yaubada wagaine ina awatalatalaina. ");
INSERT INTO bwd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","E ada taumiyavo yami vona ani gina ivemogatalimi. Faina kai yami vona iwakadi, aga Yaubada gina awaveiwakanemi. Aku kai yami vona koyodi, aga Yaubada gina awavekoyoyemi e ada amilauboda matavuloga wana nuwagana.” ");
INSERT INTO bwd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","E aku tufodi Falisiyavo kaduwe veimeya anatovewalayavo Yeisu ivonena, ivona, “Tovewala, nuwanuwama gugai ebameyasidobodobo seyana una faisewana ke ana itana.” ");
INSERT INTO bwd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aku Yeisu givonedi, givonaga, “Tova malinai anayooyavo ani koyodiyavo, ada keke ida luveyabina Yaubada wagaine. Tainei faina nuwanuwadi iyaiyaya ebameyasidobodobo ina itana. Aku keke tamo ina nuwaga, tainei-mowa iyaiyaya-nai giyegemona falofita Iyona wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Faina Iyona banae igana lakaina kamone gimiyamiya yadayada toiye ke bogi toiye, ada kadu anafaiweya Banae Kaliva Natuna gina miyamiya babi nafone yadayada toiye ke bogi toiye. ");
INSERT INTO bwd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aimo vevonayavuga anatoveya, meNinive ina mididi imi malinai anakalivamomo nodi, ada gavana iwakana igugai ani gina vewala vaita imi yami dewa koyo-moena, e ada amilauboda Yaubada yana matavuloga wana nuwagana. Faina tuwaina badi meNinive bana Iyona yana laumamala inogalina ke inuwavilana. Aku wana itana, tova malinai idedeku seyana gielai ani Banae gitubusegena Iyona. ");
INSERT INTO bwd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kaduwe anafaiweya, aimo vevonayavuga anatoveya, wabolimaneya anakwini ina mididi imi malinai anakalivamomo nodi, ada gavana iwakana igugai ani gina vewala vaita imi yami dewa ani koyo-moena, e ada amilauboda Yaubada yana matavuloga wana nuwagana. Faina badi fafali atuwada lakaina wagaine aku itauya ielai Kini Solomoni yana vewala nuwanuwauya ina nogala. Aku wana itana, tova malinai seyana gielai idedeku ani Banae gitubusegena Solomoni. ");
INSERT INTO bwd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tova-nai aluwaluwa bwanebwanenena kaliva gina miyasegena, aga gina tauya ginanau fafali ayayana wagaidiya ebaveyawai gina lelena, aku keke tamo gina nuwaga. ");
INSERT INTO bwd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","E ada gina vonaga, ‘Gana yewaku yaku ebamiya gasegena wagaine.’ Ada aluwaluwa-nai gina yewana yana ebamiya gina itana kakawana ke yegayegana, vaita tamo gaito gida sedewedewe. ");
INSERT INTO bwd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","E ada gina tauya ginanau, kadu aluwaluwa bwanebwanenedi adiseveni gina vagauledi badi koyo-moedi ayo muliya tauna. Ani inaelai ada matatabudi inaluku kaliva-nai wagaine inamiya. Ada nagona kaliva yana miya koyona, aku muliya aluwaluwa koyodi moyaidi iluku wagaine ada yana miya ani velemoena au gikoyo-mowa. Tainei anafaiweya tova malinai anayoo koyodiyavo ani gina yegemona wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeisu aimo yoo wagaidiya giifuifufu aku inana ke tainavo ielai. Ada wamelaleya imidimididi aku nuwanuwadi ina ifufu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ada kaliva seyana gimatawena, givona, “Ina ada taimomo imidimididi waiyedeya. Nuwanuwadi ina ifufu wagainiya.” ");
INSERT INTO bwd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeisu givona, “Gaito inaku? Ada gavega kaikuweyavo?” ");
INSERT INTO bwd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ada yana tonogalayavo wagaidiya nimana gitunena ada givona, “Taidei badi inaku kadu kaikuweyavo. ");
INSERT INTO bwd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Faina badi gavega Kamaku gabameya yana nuwanuwa ivegugaiyena, badi Iya tubuiyaku, novuku, ke inaku.” ");
INSERT INTO bwd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aku tayuwe yadayada-nai wagaine Yeisu giyegemona manuwa wagaine ada ginau Lavu Galili taliyeya givetoga. ");
INSERT INTO bwd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ada yoo lakaina ivagauta faina, banae waka wagaine giyage givetoga aku yoo-dina ani taliya wagaine imididina. ");
INSERT INTO bwd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ada gaitoma moyaina givewavewaledi vona matalivulivuna wagaidiya, givonaga, “Kaliva seyana ginau ke yana bakula wagaine witi waifeina gina yavuledi. ");
INSERT INTO bwd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ada waifei giyavuyavuledi aku tufona ibeu wai wagaine, ada manuga iela imadukani-yabudi. ");
INSERT INTO bwd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kadu tufona ibeu kakanafaya wagaine, bana wagaine babi keke badobadona. Ada maduga-mowa waifei ikabu, faina babi keke gidaobu lakaina. ");
INSERT INTO bwd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aku kauwana gilaka wagaine witi kabudi evagudi gikabudi ke imayewadi, faina walamidi keke idaobu velemoena. ");
INSERT INTO bwd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kadu tufona ibeu sikakakama wagaine, ada nodi itabo-tamwai ilaka ani sikakakama gitabo toyogina ke witi gifaimununa. ");
INSERT INTO bwd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aku tufona ibeu babi iwakana wagaine ke itabo iwakana. Ada waifei iveguwa ani tufona guwa inuwagadi analedi (100), tufona sikisiti (60), kaduwe tufona teti (30). ");
INSERT INTO bwd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Imi gavega wa tagami ani vona taidei wada nogalina.” ");
INSERT INTO bwd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aku Yeisu yana tonogalayavo ielai wagaine ada itolidadana, ivonaga, “Gavana faina vona matalivulivuna wagaidiya uvevewala yoo wagaidiya?” ");
INSERT INTO bwd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ada Yeisu gilufata givona, “Imi wagaimiya ani amiawaega ke Yaubada yana ebaveimeya ananuwanuwa sewasewavuyedi wana alamanedi. Aku badi wagaidiya keke. ");
INSERT INTO bwd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Faina badi gavega Yaubada yana vona inogalina ke ivevefaisewana ani badi kaduwe alamana gina veledi, e ada Yaubada anaalamana badi wagaidiya gina tubuga-mowa. Aku gavega Yaubada yana vona keke ida vevefaisewa, badi yadi alamana kabisona ani Yaubada gina vaiyegena wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Taidei faina, yaku ifufu ani vona matalivulivuna wagaine. ‘Faina iitaita aku keke idaita ke ida alamane, ada kaduwe inoganogala aku keke nuwadi gida mamali.’ ");
INSERT INTO bwd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","E ada badi faidiya tuwaina Aiseya gifalofisai ani giyegemona velemoena, givonaga, ‘Tova moyaina bonaku wana noganogalina aku keke nuwami gina mamali. Kaduwe yaku gugai wana itaitana aku keke ananuwanuwa wana itainana. ");
INSERT INTO bwd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Faina ida yoo-nai ani aseasedi ikuga, ada tagadi ikulu, ke matadi ikibodadi. Aku kai ida awaegedi, aga matadiya idaita, ke tagadiya ida nogala, ada aseasedi wagaine nuwadi gida mamalina, e ada wagaikuya ida miyaviladi ke gada kiveiwakanedi.’ Taidei anafaiweya Aiseya givona. ");
INSERT INTO bwd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Aku imiyavo ani ebavemwamwala wagaimiya, faina matami giitaita ke tagami ginoganogala. ");
INSERT INTO bwd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Faina gavonemi velemoena, tova tuwaina falofitayavo ke kaliva toyegayegana moyaidi nuwanuwadi lakaina ina itana gaitoma taidei waitaitadi, aku keke idaita. Kaduwe nuwanuwadi ina nogalidi gaitoma taidei wanoganogalidi, aku keke ida nogali. ");
INSERT INTO bwd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“E ada waifei anatoiyavuyavula anavona matalivulivuna, ani taidei anaalamana wana nogalina. ");
INSERT INTO bwd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Witi waifei-dina wai wagaine ibeu, ani vaita badi gavega vona inogalina Yaubada yana ebaveimeya faina. Inogalina aku ananuwanuwa keke ida alamane, e ani Seitani gielai ke vona-nai ibakulina aseasedi wagaidiya ani givaiyavulena. ");
INSERT INTO bwd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aku waifei ibeu kakanafaya wagaine, ani badi gavega Yaubada yana vona inogalina ada maduga-mowa wa yadi vemwamwala ivetumaganena. ");
INSERT INTO bwd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aku vona-nai ani keke idavai ada idasei aseasediya ida miyami. Vaita walamidi keke idasei, e ada tova maufo-moena iatuvefaila. Aku tova-nai vita gina yegemona, o kai yadi awaega Yaubada yana vona wagaine faina, kiveuloulolona ina nuwagana kaliva wagaidiya, maduga-mowa yadi vetumagana-nai ina segena. ");
INSERT INTO bwd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aku waifei giyavuyavulena sikakakama wagaine ananuwanuwa ani taidei anafaiweya. Badi gavega Yaubada yana vona inogalina aku babi anagaitoma moyaina faidiya ivevenuwana lakaina, ada kaikaiwabu ananuwakabubu lakaina aseasedi wagaidiya gifwayautuvidi. E ada taidei gaitoma-dina ani Yaubada yana vona-nai ifaifaimunudi, ada keke ida veveguwa. ");
INSERT INTO bwd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aku waifei ibeu babi iwakana wagaine ananuwanuwa ani badi gavega Yaubada yana vona inogalina ke ananuwanuwa ialamanena, e ada yadi dewa wagaidiya guwa iwakana iseyegemonena. Tufona iveguwa analedi (100), tufona sikisiti (60), ada tufona teti (30).” ");
INSERT INTO bwd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aku Yeisu kaduwe vona matalivulivuna seyana giifufuyena, givonaga, “Yaubada yana ebaveimeya taidei anafaiweya. Kaliva seyana witi waifei iwakadi giyavuledi yana bakula wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aku bogi seyana moyaidi idaudau aku kaliva-nai nibaina gielai ke lomata waifeidi kaduwe giyavuledi witi adimwatuguya, ada gitauya ginau. ");
INSERT INTO bwd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aku tova-nai witi itabo ada iveguwa, ani kaduwe lomata itabo. ");
INSERT INTO bwd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ada tonibakula yana togugaiyavo ielai bana wagaine ivona, ‘Kauveya, witi waifei iwakana ya bakula wagaine ubakulina, aku gavaiyamu ada lomata kaduwe itabo?’ ");
INSERT INTO bwd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Banae givona, ‘Tainei ani nibaiku seyana yana gugai.’ “Ada togugaiyavo itolidadana, ivona, ‘Ada gavaiyamu, nuwanuwa ime anana lomata ana abudi?’ ");
INSERT INTO bwd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Aku bana givona, ‘Auwe, keke lomata wana abudi. Faina kai wana abudi aga witi nodi wana abu-tamwaidi. ");
INSERT INTO bwd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Auwe ginamiya ke witi ada lomata nodi inatabo-tamwai analaba witi-moena anaitalaga anatova. Ada toitalaga gana vonedi lomata ina maduabudi, ada ina itavadi ina kabudi. Aku muliya e witi ina talana ada yaku aa anamanuwa wagaine ina dodona.’” ");
INSERT INTO bwd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeisu kadu vona matalivulivuna seyana giifufuyena, givona, “Yaubada yana ebaveimeya vaita musita waifeina anafaiweya, ani kaliva givai gibakulina yana bakula wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","E, aku waifei moyaidi wagaidiya ani musita waifeina kabiso-moena, aku ginatabo ginalaka ada gavana gitabotabo bakula wagaine ani matatabuna gina tabosegedi. E, anaetowava vaita ai anafaiweya, e ada manuga inaelai ada adiuba ina bubudi lagana wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kaduwe Yeisu givona matalivulivuna-vagila, givona, “Yaubada yana ebaveimeya vaita falawa anayisti anafaiweya. Vavine seyana yisti ivaina ke falawa lakaina negenine iluvilana. E ada tainei gaitoma-nai kabiso-moena ani giluku-nau falawa wagaine ke matatabuna gilutuga.” ");
INSERT INTO bwd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ada gaitoma-dina taidei moyaina ani Yeisu giifufuyedi vona matalivulivuna wagaidiya. Keke gida ifufu-mowa kaliva wagaidiya aku vona matalivulivuna gaga wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Taidei anafaiweya gidewa e ada gavana tuwaina falofita givonayena ani gina yegemona velemoena, givonaga, “Gana ifufu wagaidiya vona matalivulivuna wagaidiya. Gaitoma-dina sewasewavuyena babi anaebavevuvu wagaine, ani tova malinai gana ifufuyedi.” ");
INSERT INTO bwd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","E ayo Yeisu yoo gisegedi aku giluku manuwa wagaine. Ada yana tonogalayavo ielai wagaine, ivona, “Lomata bakuleya anavona matalivulivuna ani gavana anaalamana? Uda kivemalina wagaimeya.” ");
INSERT INTO bwd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeisu givonaga, “Banae kaliva-nai witi waifeina iwakana gibakulina ani Banae Kaliva Natuna. ");
INSERT INTO bwd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aku bakula ani babi matatabuna, ada waifei iwakana ani badi kaliva-dina Yaubada yana ebaveimeya wagaine imiyamiya. Aku gudana ani badi kaliva-dina Seitani yana ebaveimeya wagaine imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ada kaliva nibaina banae gudana anatobakula ani Seitani. Witi anaitalaga anatova ani tainei tova anaebalauyabu, ada toitalaga-dina ani Yaubada yana aneloseyavo. ");
INSERT INTO bwd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ada gudana iabudi ke iveividi ada ai alalata wagaine ikabudi, ani anafaiweya tova anaebalauyabu wagaine gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Banae Kaliva Natuna yana aneloseyavo gina imilidi yana ebaveimeya matatabuna wagaine ke ina vagauwidi biyavo-dina kaliva inagonagoyedi ke ina koyokoyona, kaduwe badi gavega tova moyaina Yaubada yana veimeya igadibudibusoyogena. ");
INSERT INTO bwd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ada ina batugedi ai alalata wagaine, wadedeku-deya ina tagiya lakaina ke ina kudaligoligota. ");
INSERT INTO bwd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","E ayo badi yegayegadiyavo, ani Tamadi Yaubada yana ebaveimeya wagaine ina vemalina vaita kauwana anafaiweya. Imi gavega wa tagami ani vona taidei wada nogalina.” ");
INSERT INTO bwd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kaduwe Yeisu givona matalivulivuna, givonaga, “Yaubada yana ebaveimeya anafaiweya lokoloko kaikaiwabuna isewavuyena babi negenine. Aku aimo-yo seyana kaliva ginuwagana ada kaduwe givetavu-vagilena. Ada wa yana vemwamwala nodi ginau ada yana lokoloko matatabuna givekimonedi ada manina givaina, ada giyewana ke babi-nai gikimonena.” ");
INSERT INTO bwd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kaduwe vona matalivulivuna seyana giifufuyena, givonaga, “Yaubada yana ebaveimeya anafaiweya kaliva seyana ginau ke fwalu iwakana gilelele gina kimonena faina. ");
INSERT INTO bwd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ada gilelele ani seyana kaikaiwabuna velemoena ginuwagana aku fatana lakaina. E ada giyewana ke yana lokoloko matatabuna givaidi givekimonedi, ada mani givaina ke ginau fwalu-nai gikimonena.” ");
INSERT INTO bwd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kaduwe Yaubada yana ebaveimeya anafaiweya vaita guvata lavu wagaine isegena ada igana tulina tulina iveonadi. ");
INSERT INTO bwd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ada tova-nai guvata gimaga, toyauba itai gilaka avaleya ada igana iwakadi ivaidi idododi fuwama wagaidiya. Aku igana koyodi isegedi. ");
INSERT INTO bwd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Taidei anafaiweya tova anaebalauyabu wagaine gina yegemona. Yaubada yana aneloseyavo ina obuelai ke kaliva koyodiyavo ina luvisidi kaliva iwakadiyavo wagaidiya-deya, ");
INSERT INTO bwd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ada ai alalata wagaine ina batugedi. Wadedeku-deya ina tagiya lakaina aku ina kudaligoligota.” ");
INSERT INTO bwd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ada Yeisu yana tonogalayavo gitolidadanedi, givonaga, “Gavaiyamu, vona matalivulivuna moyaina gaifufuyedi ani nuwami gimalina?” Badi ivona, “Ika, aalamanena.” ");
INSERT INTO bwd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ada Yeisu givona wagaidiya, givonaga, “Iwakana. E ada kaduwe nuwami gida malina taide yaku vona faine. Kai imiyavo ada kadu badi gavega bademowa alaalamanimiyavo Yaubada yana veimeya tuwaina-deya faidiya ani wana vetonogala Yaubada yana ebaveimeya wagaine, aga imiyavo vaita toni manuwa kaikaiwabuna seyana anafaiweya. Bana yana manuwa wagaine-deya yana kaikaiwabu evagudi giseseyegemonedi kadu yana kaikaiwabu tuwaidi, e ada gaitoma-dina wagaidiya kaliva gina lemelemedi.” ");
INSERT INTO bwd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tova-nai Yeisu yana ifufu matalivulivuna giavaina, tayuwe fafali-nai gisegena ");
INSERT INTO bwd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aku giyewana tauna yana melala Nasaledi wagaine. Ada yadi manuwa ebavewala wagaine giluku givewavewala, ada badi ivanevanenegena ani meyadi gisidobodobona ke ivona, “Kaliva taidei ani gadedeku-deya yana nuwauya ke kaduwe gugai-dina toyogidi givaidi? ");
INSERT INTO bwd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aku banae ani au manuwa anatoiyogona natuna, kaduwe inana adiyegana Meli. Ada tainavo kaalamanedi Iyemesa, Iyosefa, ke Saimoni, ada Yudasa. ");
INSERT INTO bwd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Novunavo kaduwe nodi kamiyamiya. E, banae wagaideya giveinala. Aku gadedeku yana alamana taidei givai?” ");
INSERT INTO bwd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","E ada idibusoyogena. Aku Yeisu givonedi, givonaga, “Falofita ani fafali moyaina wagaidiya kaliva ivemoimoinena. Aku tauna yana yoo yana fafali wagaine ke tauna yana gabumomo ani keke ida vemoimoine.” ");
INSERT INTO bwd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","E ada badi meNasaledi keke ida vetumagana faina, ada keke gugai ebameyasidobodobo moyaina gida gugaiyedi wadedeku. ");
INSERT INTO bwd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tayuwe tova-nai wagaine Elodi, banae Galili anatoveimeya, ani Yeisu valeyana ginogalina. ");
INSERT INTO bwd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ada yana togugaiyavo givonedi, givonaga, “Banae kaliva-nai ani au Iyoni Tobabitaiso. Gialika aku Yaubada alikeya gisiveyawa-vagilena, ada tainei faina wa yana toyogina ke gugai ebameyasidobodobo gifaifaisewadi.” ");
INSERT INTO bwd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Elodi givona anafaiweya faina tuwaina anatubuluga Filipi vavinena adiyegana Elodiyasi, ani Elodi tauna giluobuyedi. E ada bana Iyoni gielaelai ada givona-vavagilena Elodi, givonenaga, “Taidei ya dewa-nai udewayena tawaga Filipi vavinena uluobuyedi ani ina veimeya uyawelina.” Ada Elodi keke gida vemwamwala Iyoni yana vona-dina wagaidiya, e ada yana togugaiyavo giveimeyedi ke Iyoni ikiveyabi iyogona ada deli wagaine isena. ");
INSERT INTO bwd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ada Elodi nuwanuwana Iyoni gina luvealikana aku yoo gimatausedi, faina kaliva moyaidi ivetumaganena vaita banae Yaubada yana falofita seyana. ");
INSERT INTO bwd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aku Elodi yana tubuga anayadayada anaebanuwaududu wagaine, kanibutu lakaina gifaisewana. Ada yana yoo nodi ikanikani aku Elodiyasi natudi vavine kabisona ani giela gitavotavola yoo matadiya, ada Elodi givemwamwala lakaina. ");
INSERT INTO bwd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Taine faina Elodi vavine-nai kabisona wagaine givonadabadaba toyogina vaita gavana faina gina veolena ani gina velena. ");
INSERT INTO bwd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ada kwamana-nai inana Elodiyasi ivonena ada yadi nuwanuwa gimuliyena, e ada giveolena Elodi, givonaga, “Nuwanuwaku idedeku Iyoni Tobabitaiso kuluwana nauwa wagaine uda veleku.” ");
INSERT INTO bwd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tayuwe wagaine Kini Elodi nuwana givita lakaina, aku anawakawakayavo matadiya givonadabadaba toyogina faina, auwe giveimeya ke Iyoni kuluwana ina velena. ");
INSERT INTO bwd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ada yana kalivamomo givonedi inau deli wagaine Iyoni odona ilugoloina, ");
INSERT INTO bwd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ada kuluwana nauwa wagaine idodona ada ialiyena kwamana ivelena, ada ginauwena inana wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aku Iyoni yana tonogalayavo ielai vovona ivaina ada inauwe itavuna. Itavuna giavaina, inau Yeisu wagaine ada iawatalatalainena gavana giyegemona faine. ");
INSERT INTO bwd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ada Yeisu Iyoni yana alika valeyana ginogalina faina, ada gina giyage waka wagaine ada fafali-nai gisegena aku ginau seyana fafali kavovona wagaine anakaibe ginamiya. Aku yoo inogalina Yeisu bade ginau, e ada yadi melala seyana seyana isegedi aku agediya imuliye inau fafali-nai wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ada Yeisu waka wagaine giyalili ani yoo lakaina giitadi wagaine ginuwakalikaliyedi, ada yadi toveogayavo gikiveiwakanedi. ");
INSERT INTO bwd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mala givelavilavi aku yana tonogalayavo ielai Yeisu wagaine ivona, “Ida mwatugu kavovona wagaine kamiyamiya ada mala gibogibogi. Kaliva uda imilidi idanau melala wagaidiya adiga ida kimone.” ");
INSERT INTO bwd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aku Yeisu givonedi, “Auwe inamiya. Imi taumiyavo aa wana veledi inakani.” ");
INSERT INTO bwd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Badi ivonaga, “Ime wagaimeya beledi faifi-gaga ada igana iluwei.” ");
INSERT INTO bwd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ada Yeisu givonaga, “Wana aliyedi wagaikuya.” ");
INSERT INTO bwd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ada yoo giveimeyedi ina vetoga talaguwala wagaine, ada moyaidi ivetogadi aku beledi faifi kadu igana iluwei givaidi ada giitalaka gabama wagaine aku givona vesiule Yaubada wagaine. Ada beledi gikiineinedi giveledi tonogalayavo ke badi ivutugena yoo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ada moyaidi ikani ke kamodi ifata. Ada tonogalayavo inau ada aditufo ikwakwana ani fuwama tuwelo ivemagadi. ");
INSERT INTO bwd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Badi kaliva-gaga beledi ikanina ani iveyawadi adiyoo faifi tausani (5,000), aku kaduwe vevine ke biyabiyama nodi ikani. Aku kai ida veyawa-tamwaidi aga aimo gavaiyei. ");
INSERT INTO bwd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ada kani muline, maduga-mowa Yeisu yana tonogalayavo waka wagaine giveyagedi ke wai inanago ina damana lavu fafaline. Aku Banae ginamiya ada yoo gina imilidi ina vebiawaawala. ");
INSERT INTO bwd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ada yoo giimilidi aku anakaibe gilaka oyeya ke gina veoveola Tamana wagaine. Ada bademowa mala gibogi aku Yeisu anakaibe, ");
INSERT INTO bwd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","aku badi yana tonogalayavo waka wagaine ani bade inau atuwada aku buli ani waka giluvilavilana, faina mala gilubibibi wadebaidiya-deya ke giluveyeveyewadi. ");
INSERT INTO bwd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ada malalavuga anafafali wagaine Yeisu ani lavu getane givaga-mowa ada ginaunau wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ada tonogalayavo iitana lavu getane ginunudadana, ada badi imatauta lakaina ke ivekwekwekwela ivona, “Ida balauma!” ");
INSERT INTO bwd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aku maduga-mowa Yeisu givonedi, givona, “Wana asevatu. Ida Iya Tauku. Keke wana matauta.” ");
INSERT INTO bwd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ada Pita givona, “Kauveya, kai velemoena Oyeni, aga una veimeyeku ada lavu getane ganaelai wagainiya.” ");
INSERT INTO bwd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeisu givona, “Unaelai.” Ada Pita waka wagaine giobu ada givebutu lavu getane ginaunau Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ada ginaunau ani buli lakaidi giitadi ada au gimatauta ada givebutu gikamomola, e ada givedou, givona, “Kauveya, una kibababaleku!” ");
INSERT INTO bwd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ada maduga-mowa Yeisu nimana gitunena ada gisilakaina aku givonena, “Ya vetumagana kabisona. Gavana faina unuwakila?” ");
INSERT INTO bwd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ada ielai waka wagaine iyage ani au mala giatagona. ");
INSERT INTO bwd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ada tonogalayavo waka wagaine imiyamiya ani Yeisu wagaine ioduvemoimoina, ivona, “Vona velemoena Oyeni Yaubada Natuna.” ");
INSERT INTO bwd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aku lavu italadamanina ada ina iyalili Genesaleti anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ada meGenesaleti Yeisu iitainanana wagaine, matawa iimilina fafali-nai anamelala moyaina wagaidiya ke kaliva yadi toveogayavo ialiyedi Bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ada iveolena toyogina vaita toveoga gina awaegedi ke ananuya bwatana-ga nimadididi inasedi, ada badi gavega nimadididi isedi wagaine ani matatabudi iveiwaka. ");
INSERT INTO bwd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aku Falisiyavo ke veimeya anatovewalayavo tufodi ani Yelusalema-deya ielai ada Yeisu wagaine ivona, ");
INSERT INTO bwd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Gavana faina ya tonogalayavo iyaweyaweli yada kaliva lakaidiyavo adigiduwa anaveimeya? Kani anatova keke nimadi ida kolakola ayo ida kanikani aku wa nima bwanenedi ikanikani.” ");
INSERT INTO bwd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeisu givonedi, givonaga, “Aku imi kaduwe, gavana faina taumiyavo amigiduwa tuwaina waitaitaveyabi aku Yaubada yana veimeya ani wayaweyaweli? ");
INSERT INTO bwd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Faina Yaubada giveimeyeda givona, ‘Ina ke tama una vemoimoinedi.’ Kaduwe veimeya seyana ani, ‘Kai gaito inana o tamana wagaidiya ginavona awadamana, aga banae gilubodana gina alika.’ ");
INSERT INTO bwd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aku imiyavo ani wavona vaita kai kaliva inana o tamana gina vonedi ginavona, ‘Gava yaku giba wagaine vaita gada lememi, ani taine yaku nuwakabubu-nai bade gaawaegena Yaubada wagaine. Taide faina keke akufaiweya gana lememi.’ ");
INSERT INTO bwd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kai taidei anafaiweya kaliva inavona, aga imi au waawaveiwakanena, e ada kaliva inana ke tamana keke gida vemoimoinedi ke yana leme gida veleveledi. Ada tayuwe wagaine amigiduwa-nai tamamiyavo nagona wagaidiya wavesesedamani waaliyena, aku Yaubada yana vona ani anaveimeya wavegaitoma-kavokavovoyena. ");
INSERT INTO bwd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Imi meyalugaluga! Tova tuwaina Aiseya gifalofisai imi faimiya ada givona velemoena, givonaga, ");
INSERT INTO bwd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ida yoo-nai ani awakebuladiya ivemoimoineku, aku aseasedi ani imiya atuwada Iya wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yadi vewala ani keke Iya Yaubada yaku nuwanuwa wagaine, aku au kaliva-mowa yadi nuwenuweya. E ada Iya wagaikuya ioduodu-wayoga.’” ");
INSERT INTO bwd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ada Yeisu yoo gidouwedi ke ivagauta wagaine ada givonedi, “Yaku vona wana nogalina ada nuwami gina malina. ");
INSERT INTO bwd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gavana kaliva awadiya ginaluku ani keke gina kivebwanene Yaubada matane, aku gavana awadiya ina yegemona, tainei gina kivebwanenedi Yaubada matane.” ");
INSERT INTO bwd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ada Yeisu yana tonogalayavo iela wagaine ada ivonena, ivona, “Kai ualamanena ya vona tainei wagaine ada Falisiyavo ukivenuwakoyodi?” ");
INSERT INTO bwd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ada Yeisu gilufata givonaga, “Ai seyana seyana Kamaku gabameya keke gida bakulidi ani ina abuyavuledi gina avaina. ");
INSERT INTO bwd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Keke wana nuwanuwa taide kaliva-dina faidiya. Badi tokivetuvetunuga aku matadi koyo-moedi. Ada kai matana koyo-moena seyana ani kadu matana koyo-moena seyana gina nagoyena, aga adiselu ina beuluga olu wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ada Pita givona Yeisu wagaine, givonaga, “Vona matalivulivuna taidei uda kivemalina wagaimeya. Gavana faina uvona, ‘Kai kaliva gavana gina kanina aga keke gina kivebwanene’?” ");
INSERT INTO bwd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ada Yeisu givonedi, givona, “Taumada, imi kaduwe nodi aimo keke nuwami gidamali. ");
INSERT INTO bwd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gavaiyamu, keke wada alamane vaita gavana kai ginaluku kaliva awadiya, aga ginanau kamodi wagaine ada gina yegemona? ");
INSERT INTO bwd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aku gavadi ina yegemona kaliva awadiya, tainei aseasedi-deya iyegeyegemona, ada gaitoma-dina taidei ani kaliva ikikivebwanenena Yaubada matane. ");
INSERT INTO bwd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Faina kaliva nuwainagediya-deya ani nuwanuwa koyodi iyegeyegemona, anafaiweya luvealika, udo, vovo anaawaege-kavokavovo, kiyafu, toitavedama yana fwaya, kaduwe kaliva anaveloi ani anayegana anakivekoyo faina. ");
INSERT INTO bwd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Taidei gaitoma-dina ani kaliva ikikivebwanenedi. Aku kai wa nima bwanenedi inakani aga keke gina kivebwanene Yaubada matane.” ");
INSERT INTO bwd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ada Yeisu melala-nai gisegena aku ginau melala Taiya ke Saidoni adifafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ada tayuwe fafali-nai wagaine vavine seyadi imiyamiya, badi keke vine Isileli aku Kenani adiyoo wagaine. Ada ielai Yeisu wagaine itagivedadaga, ivona, “Kauveya, Oyeni Deivida yana tubudelideli, uda nuwakalikaliyema! Natuma vavine ani aluwaluwa koyona nafone gimiyamiya ada gikikivekoyona velemoena.” ");
INSERT INTO bwd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aku Yeisu keke tamo gavana gidavona wagaidiya. Ada yana tonogalayavo ielai wagaine ialamamaiyena, ivona, “Uda imilidi idanau, faina imulimuliyeda aku ivedovedou bonadi lakaina.” Ada ivedibusoyosoyoga. ");
INSERT INTO bwd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aku Yeisu gilufata, givona, “Yaubada giimiliku badi meIsileli-gaga wagaidiya, badi vaita anafaiweya sifi nunusegediyavo ada gabama anawai keke ida alamane.” ");
INSERT INTO bwd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yeisu anafaiweya givona aku vavine auwe ielai wagaine ada tugadi ivetodonedi aku ivona, “Kauveya, uda lemema!” ");
INSERT INTO bwd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeisu givonedi, givona, “Gavaiyamu, biyabiyama adiga ani kanavai kana batugena galuweta wagaidiya? Taidei keke gida luboda.” ");
INSERT INTO bwd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Badi ivona, “Ika Kauveya. Aku galuweta tunovudiyavo adimukumuku imavumavuga teibeli dibune ani ikwakwakwa ikanikani.” ");
INSERT INTO bwd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ada Yeisu gilufata, givona, “Vavine, velemoena yami vetumagana lakaina. Ada gavana waveoleku, anafaiweya gina yegemona.” Ada au tova-nai wagaine vavine natudi giveiwaka. ");
INSERT INTO bwd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ada Yeisu tayuwe fafali-nai gisegena, ada Lavu Galili taliyeya gibala ada gina gilaka oyaoyana wagaine givetoga. ");
INSERT INTO bwd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ada yoo lakaina ielai wagaine ada yadi toveoga ialiyedi, anafaiweya tovefela, badi matadi koyo-moedi, tolefelo ke gaugaudiyavo ada kaduwe veoga tulina tulina. Moyaidi ialiyedi isedi Yeisu agene ke gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ada kaliva ani iitadi gaugaudiyavo iifuifufu, badi talaidi ikoyo ani iveiwaka, ke tovefela inudadana ada badi matadi koyo-moedi iita, ada taidei iitana wagaine meIsileli yadi Yaubada iawadavadavana. ");
INSERT INTO bwd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ada Yeisu yana tonogalayavo gidouwedi ielai ada givonedi, givona, “Yoo taidei ganuwakalikaliyedi, faina tova malinai bademowa yadayada toiye nodi kamiyamiya, ada keke tamo aa gidatufo ayo inakani. Ada keke nuwanuwaku wa mafalavugidi gana imilidi, aimo waiya inaala faina.” ");
INSERT INTO bwd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yana tonogalayavo ivonena, ivona, “Ida mwatugu kavovona wagaine kamiyamiya, e ada gadedeku aa kanavai ayo yoo lakaina kana vekanidi?” ");
INSERT INTO bwd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeisu givona, “Gavaiyei beledi wagaimiya?” Badi ivona, “Beledi seveni idauwe ada igana kabikabisodi toiye-mowa.” ");
INSERT INTO bwd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ada yoo givonedi ke ivetoga babi wagaine ");
INSERT INTO bwd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","aku beledi seveni ke igana nodi givaidi ke givona vesiule Yaubada wagaine, muliya gikiineinedi ke giveledi yana tonogalayavo, ada badi ivutugena yoo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ada moyaidi ikani ke adifaiweya matatabudi. Ada mukumukuna aditufo ivagauwina, ada fuwama seveni ivemagadi. ");
INSERT INTO bwd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Badi kaliva-gaga iveyawadi ani adiyoo fowa tausani (4,000), aku vevine ke biyabiyama ani nodi ikani, aku kai ida veyawa-tamwaidi aga aimo gavaiyei. ");
INSERT INTO bwd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ada Yeisu yoo giimilidi inau, aku giyage waka wagaine ada gidamana ginau Magadani anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aku Falisiyavo ke Sadusiyavo tufodi ani ielai Yeisu wagaine, ada nuwanuwadi ina galuvaluvana faina, iveolena ke gugai ebameyasidobodobo seyana Yaubada wagaine gida faisewana ke ida itana. ");
INSERT INTO bwd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aku Yeisu givona, “Tova-nai mala gina bogibogi aku kai mala gina yabelina, aga faina imi wavonavona, ‘O, malabutu tova iwakana.’ ");
INSERT INTO bwd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ada kaduwe mala gina lavulavuna aku kai mala gina yabelina ada kadu gina yuyuvana, aga faina imi wavonavona, ‘O, wei gina lugaga.’ Taidei anafaiweya tova mala anaiyaiyaya waitaitana ada waalamanena, aku gaitoma-dina malinai iyegeyegemona, ani keke amifaiweya wana itainanadi. ");
INSERT INTO bwd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tova malinai anayooyavo ani koyodiyavo, ada keke ida luveyabina Yaubada wagaine. Tainei faina nuwanuwadi iyaiyaya ebameyasidobodobo ina itana, aku keke tamo ina nuwaga, tainei-mowa iyaiyaya-nai giyegemona Iyona wagaine.” Taidei anafaiweya givonedi aku gisegedi ada ginau. ");
INSERT INTO bwd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yeisu yana tonogalayavo nodi idamana lavu fafaline aku tonogalayavo nuwadi givulu ada keke tamo beledi idavai. ");
INSERT INTO bwd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ada Yeisu givonedi, givona, “Taumiyavo wana itaveyabimi badi Falisiyavo ke Sadusiyavo adifalawa anayisti wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ada badi tonogalayavo ivebutu taudiyavo-gaga wagaidiya ivonavona, ivona, “Taidei anafaiweya givona faina keke tamo beledi kada aliye.” ");
INSERT INTO bwd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aku Yeisu yadi nuwanuwa gialamanena e ada givonedi, givona, “Imi yami vetumagana kabisona. Gavana vuvuna waveifuifufu amibeledi keke wadavai faina? ");
INSERT INTO bwd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gavaiyamu, aimo keke wadaita ke wada alamane? Kai keke wada nuwaududu beledi faifi kaliva faifi tausani (5,000) faidiya, ada gavaiyei fuwama adimukumuku tufo wakwakwadi? ");
INSERT INTO bwd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kaduwe beledi seveni gakiineinedi kaliva fowa tausani (4,000) faidiya, ani mukumuku wagaine gavaiyei fuwama wavemagadi? ");
INSERT INTO bwd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Gavaiyamu-yo keke nuwami gidamali? Iya gavonavona ani keke beledi-mowa faina, aku Iya gavona ani imi taumiyavo wana itaveyabimi Falisiyavo ke Sadusiyavo yadi yisti wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Givonedi ada au nuwadi gimalina ada keke vaita yisti-mowa falawa wagaine ivilavilana faine, aku velemoena ani matadi gina faifaila Falisiyavo ke Sadusiyavo yadi vewala koyona wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ada Yeisu yana tonogalayavo nodi inaunau aku Sisalia-Filipai anafafali iyegemona, ada wadedeku yana tonogalayavo gitolidadanedi, givona, “Wana voneku, gavaiyamu kaliva ivonavona Iya Kaliva Natuna faikuya ani evona vaita Iya gaito?” ");
INSERT INTO bwd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Badi ivona, “Tufodi ivona vaita Oye Iyoni Tobabitaiso. Aku tufodi ivona vaita Oye falofita Ilaitiya, kaduwe tufodi ivona vaita Oye Iyelemaiya, o kai tova tuwaina anafalofita seyana.” ");
INSERT INTO bwd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ada Yeisu gitolidadanedi, givonaga, “Aku imiyavo, gavaiyamu wavonavona, evo Iya vaita gaito?” ");
INSERT INTO bwd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimoni-Pita givonena, givona, “Oyeni ani au Mesaiya, Yaubada Tomiya-vagata Natuna.” ");
INSERT INTO bwd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeisu givona, “Saimoni Iyona natuna, Yaubada giawanuwakabubuyeni. Faina keke seyana kaliva-mowa gida vewaleni, aku Kamaku gabameya Banae giawamogatalena wagainiya. ");
INSERT INTO bwd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","E ada Iya kaduwe gana voneni, oyeni Pita, ada babi kwakwana taidei gina veavutuwa ke yaku ekalesiya gana yogona tabone, tainei yaku yoo imiyamiya babi matatabuna wagaine. Ada Seitani ke yana yoo ani keke ina toyogisege. ");
INSERT INTO bwd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iya ebaveimeya gabameya anaebayavuga gana veleni, ada gavana babiya una awatana, anafaiweya kaduwe Yaubada bademowa giawatana gabameya. Ada gavana babiya una awaegena, anafaiweya kaduwe Yaubada bademowa giawaegena gabameya.” ");
INSERT INTO bwd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yeisu vona-nai giluyabuna, ada yana tonogalayavo giawatadi keke seyana gaito gina awamogatale vaita Banae ani Mesaiya. ");
INSERT INTO bwd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ada tova tayuwe wagaine-deya, Yeisu givebutu ada gavana aimo Bana wagaine gina yegemona ani yana tonogalayavo givewaledi, givona, “Iya akuveimeya gavaina ke gananau Yelusalema wagaine, ada badi kaliva lakaidiyavo ke Yaubada yana veyavo anatovegugai lakaidiyavo kaduwe veimeya anatovewalayavo ani nimadiya uloulolo moyaina gana nuwagana. Ada ina luvealikaku, aku yadayada anaveto wagaine alikeya Yaubada gina siveyawaku.” ");
INSERT INTO bwd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aku bana Pita ani Yeisu givagaule ginauwena tabae ada givebutu giduweyena, givona, “Keke Kauveya, keke tainei anafaiweya! Taidei keke-bamowa gina yegemona wagainiya.” ");
INSERT INTO bwd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aku Yeisu gimiyavilana ada Pita wagaine givona, “Seitani, una segeku unanau tabae! O ugaluvaluva una siveyewaku yaku wai tunutunugina wagaine. Ida ya nuwanuwa ani keke Yaubada yana nuwanuwa anafaiweya, aku kaliva-mowa yadi nuwanuwa.” ");
INSERT INTO bwd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ada Yeisu givona yana tonogalayavo wagaidiya, givona, “Kai badi gavega nuwanuwadi inaela ina muliyeku, aga gilubodana taudiyavo yadi nuwanuwa ina dibusoyogedi aku taudiyavo adikelose ina avalana ke ina muliyeku. ");
INSERT INTO bwd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Faina badi gavega nuwanuwadi taudiyavo yawaidi ina kibababaledi ani yawaidi ina nusegena. Aku gavega Iya faikuya yawaidi ina nusegena ani yawaidi miyamiyani-vagaina ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Faina kai gavega babi anagiba matatabuna inavai-yabudi aku taudiyavo yawaidi adikibababala-vagata ida nusegena, aga gavana anaiwakana? Au keke. Kai yawaidi adikibababala-vagata ina nusegena, aga keke tamo fatana anafaiweya inasei ayo yawaidi kaduwe ina nuwaga. ");
INSERT INTO bwd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Faina Banae Kaliva Natuna aimo gina obuelai Tamana yana iwakana mamalina wagaine wa yana aneloseyavo nodi, ada kaliva seyana seyana yadi dewa anafaiweya gina fatadi. ");
INSERT INTO bwd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aku gavona velemoena wagaimiya, tufomi idedeku wamidimididi ani aimo keke alika wanamadu lutovoni, aku nagona wana itana Banae Kaliva Natuna wa yana ebaveimeya gina yegemona.” ");
INSERT INTO bwd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ada yadayada sikisi giavaidi, Yeisu yana tonogalayavo aditoto, Pita ada Iyemesa ke anatubuluga Iyoni ani givagauledi nodi ilaka oya lakaina wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ada wadedeku-deya adiloi matadiya aku Yeisu anaita gisevedavedama. Ada magigina gilunamanamalena vaita kauwana anafaiweya, ada ananuya gikwayafofolina vaita malina anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ada aditoto matadiya aku Yaubada yana kalivayavo adiselu tova tuwaina wagaine imiyamiya, tainei Mosese kadu Ilaitiya, ani iyegemona ada Yeisu nodi iifuifufu. ");
INSERT INTO bwd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ada au Pita Yeisu givonena, “Kauveya, ida iwaka-moena faina ime nodi idedeku kamiyamiya. Ada kai ya nuwanuwa anafaiweya, aga vada toiye idedeku gana yogodi. Seyana O fainiya, seyana Mosese faine, kaduwe seyana Ilaitiya faine.” ");
INSERT INTO bwd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ada aimo giifuifufu aku buibui mamali-moena giyegemona ke gibwatavudi, ada bonabona buibui wagaine-deya givonaga, “Taidei ani Iya Natu aseaseku, Banae gikivemwamwaliku lakaina. Bonana wana nogalina.” ");
INSERT INTO bwd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aku tonogalayavo inogalina wagaine, imatauta lakaina ada babi wagaine ivetalatala. ");
INSERT INTO bwd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ada Yeisu gielai nimana gisena wagaidiya aku givona, “Wana mididi. Keke wana matauta.” ");
INSERT INTO bwd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ada iitalaka ani keke tamo gaito idaita aku Yeisu anakaibe-mowa. ");
INSERT INTO bwd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","E ada itauya oyeya-deya iobuobuelai aku Yeisu giveimeyedi, givona, “Gavana waitanuwagana vewala-nai wagaine ani keke seyana gaito wana vonevone analaba Banae Kaliva Natuna alikeya Yaubada gina siveyawana. Aku muliya ani iwakana, wana awamogatalena.” ");
INSERT INTO bwd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ada yana tonogalayavo itolidadanena, ivona, “E aku gavana faina veimeya anatovewalayavo ivona vaita gilubodana Ilaitiya gina maduelai, aku muliya Mesaiya?” ");
INSERT INTO bwd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeisu gilufata, givona, “Ina vona velemoena, Ilaitiya ginaelai ke gaitoma matatabuna gina sedewedewe-vagiledi. ");
INSERT INTO bwd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aku Iya gana vonemi, bana Ilaitiya bademowa gielai aku kaliva keke ida inana, ada gavana anafaiweya yadi nuwanuwa koyona ani igugaiyena wagaine. Tainei anafaiweya Banae Kaliva Natuna kaduwe vita moyaina gina nuwagana badi nimadiya.” ");
INSERT INTO bwd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ada tonogalayavo au nuwadi gimalina tova-nai Ilaitiya faine givona ani velemoena Iyoni Tobabitaiso faine givonavona. ");
INSERT INTO bwd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ada Yeisu yana tonogalayavo aditoto nodi oyeya-deya iobuelai yoo wagaidiya, ani kaliva seyana gielai Yeisu wagaine ada tugana givetodonena, givona, ");
INSERT INTO bwd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kauveya, natuku kaliva uda nuwakalikaliyena. Banae tova maufona wagaine vovona matatabuna ina yaviyavivila ke gina itaita-vagata. Yana veoga koyo-moena. Tova ke tova aiya o kai gufeya gibeubeu. ");
INSERT INTO bwd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ada gaaliyena ya tonogalayavo wagaidiya aku keke adifata ina kiveiwakane.” ");
INSERT INTO bwd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeisu givonaga, “Imi tova malinai anayooyavo ani yami vetumagana keke, ada nuwanuwa moyaina tunutunugidi ani wakikivebaladi. Gavaiyei tova Iya nodi kana miyamiya? Gavaiyei tova gana atuvefailemi? Kwamana wana aliyena wagaikuya.” ");
INSERT INTO bwd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ada kwamana tamana gialiyena, ada Yeisu aluwaluwa koyona giawatana ke kwamana wagaine giyegemona ayo maduga-mowa giveiwaka. ");
INSERT INTO bwd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aku muliya tonogalayavo ielai Yeisu wagaine ada adiloi gaga aku itolidadanena, ivona, “Gavana faina ime keke amafata aluwaluwa koyona ana veyegemoni?” ");
INSERT INTO bwd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yeisu givona, “Faina yami vetumagana kabiso-moena. Aku gavonemi velemoena, kai yami vetumagana anatubuga vaita musita waifeina kabiso-moena anafaiweya, aga amifata oya taidei wagaine wanavona, ‘Una mididi unanau tayuwe.’ Ada ginanau. Kai yami vetumagana tainei anafaiweya aga wagaimiya gaitoma matatabuna meyameyaganidi.  ");
INSERT INTO bwd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aku aluwaluwa koyodi taidei anafaiweya ani keke amifaiweya wana veyegemonidi, tainei-mowa wana veoveola Yaubada wagaine aku kani wana ilovau.” ");
INSERT INTO bwd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ada tova seyana wagaine Yeisu yana tonogalayavo nodi ivagauta Galili wagaine aku givonedi, “Tova kabisona Banae Kaliva Natuna ina atuegena kaliva nimadiya, ");
INSERT INTO bwd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ada ina luvealikana. Aku yadayada anaveto wagaine Yaubada gina siveyawana alikeya.” Taidei anafaiweya Yeisu givona, ada tonogalayavo inuwavita lakaina. ");
INSERT INTO bwd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ada Yeisu yana tonogalayavo nodi ina iyegemona Kafaneumi wagaine, ada takesi anatoyaudi manuwa tabu faina ani ielai Pita wagaine itolidadana, ivona, “Gavaiyamu, bana yami tovewala, manuwa tabu anatakesi gisesena o keke?” ");
INSERT INTO bwd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita givonaga, “Ika, gisesena.” Ada Pita gina giluku manuwa wagaine ada takesi faina aimo keke gidavona aku Yeisu gimaduvona, givonaga, “Saimoni, gavaiyamu ya nuwanuwa? Babi matatabuna anakiniyavo ani gavega wagaidiya takesi ivaivai? Taudiyavo natudiyavo wagaidiya o kai mali kaliva wagaidiya?” ");
INSERT INTO bwd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita givona, “Mali kaliva wagaidiya ivaivaina.” Yeisu givona, “Uvona velemoena. Taidei faina kiniyavo natudiyavo keke takesi ida sesei. ");
INSERT INTO bwd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","E aku ide keke nuwanuwada takesi anatoyaudi nuwadi kana kivekoyo. Tainei faina unanau lavu wagaine maina una batugena, ada igana gina madukani una taina ani awana una kilana ada siliva mani una nuwagana. Mani-nai una nauwena ada takesi unasena oye ke Iyayeku faideya.” ");
INSERT INTO bwd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tainei tova-nai tonogalayavo ielai Yeisu wagaine ivonaga, “Gaito anayegana lakai-moena Yaubada yana ebaveimeya wagaine?” ");
INSERT INTO bwd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ada Yeisu kwamana kabisona gidouwe gielai ke tonogalayavo nefanidiya givemididina ");
INSERT INTO bwd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aku givona, “Gavona velemoena wagaimiya, kai keke yami nuwanuwa wana sevedavedame ke wana veanafaiweya biyabiyama kabisodi, aga keke maita wanaluku Yaubada yana ebaveimeya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Taidei faina kai gaito tauna gina kiobuyena anafaiweya kwamana kabisona taidei, aga banae anayegana lakai-moena Yaubada yana ebaveimeya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Badi gavega kwamana kabisona taidei anafaiweya akuyeganeya ina sivaivaina, ina Iya kadu isivaivaiku. ");
INSERT INTO bwd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Aku kai kwamana seyana anafaiweya taidei givetumaganeku aku dewa koyona wagaine wanagai yana vetumagana wagaikuya gina segena, aga amimatavuloga vita-moena wana nuwagana Yaubada wagaine. Ebaita ganasena. Kai kabala lakaina ina yogovefosena odomiya ada wa kabalimi ina vekamomolimi leyageya wana alika, tainei vitana. Aku kai matavuloga Yaubada wagaine wana nuwagana, tainei vita-moena. ");
INSERT INTO bwd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Oiyoi! Babi anakalivayavo vita lakai-moena ina nuwagana, faina tova moyaina aladibidibi tulina tulina iyegeyegemona wagaidiya ada ibeubeu. Velemoena, ebaaladibidibi moyaidi iyegeyegemona ke kaliva inagadi inabeu ke ina koyona. Aku badi gavega koyona anaebabe ikiveyegemonina ani vita lakai-moena ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","E ada kai nima o age gina sitaitaini ke una koyokoyona, aga au una dabayavule una segena. Auwe wa nima seya-moena aku unamiya wa ya dewa iwakana ada unaluku yawai-vagata wagaine. Ina iwaka-vagaina ayo kai wa nima iluwei, aku wa ya dewa koyona ani unaluku eli anaai alalata keke gida weuwe wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kaduwe kai mata gina nagoyeni ke una koyokoyona, aga au una etomwamwali una segena. Auwe wa mata seya-moena aku wa ya dewa iwakana unamiya ada unaluku yawai-vagata wagaine. Ina iwaka-vagaina ayo kai wa mata iluwei aku wa ya dewa koyona ani ina batugeni unaluku aiyabeyabela eli wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Wana itaveyabimi ada biyabiyama taidei anafaiweya ani keke tamo wana itatago. Faina gana vonemi, tova moyaina yadi aneloseyavo gabameya Kamaku matane imiyamiya, ada kai wana gugai koyona biyabiyama-dina wagaidiya aga faidiya ina awatalatalaina Banae wagaine.  ");
INSERT INTO bwd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Faina Bana Kaliva Natuna gielai e ada badi gavega Yaubada yana wai ibavuyena ani gina kibababaledi. ");
INSERT INTO bwd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Gavaiyamu yami nuwanuwa? Kai kaliva seyana yana sifiyavo wani analedi (100) imiyamiya aku seyana ginuvuyo, aga gavaiyamu gidagai? Yana sifi adinaeniti naeni (99) ani gina nusedi oyaoyana wagaine aku ginanau ada sifi-nai ginuvuyo gina lelena. ");
INSERT INTO bwd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ada kai gina nuwagana aga gavonemi velemoena, gina vemwamwala lakai-moena banae sifi-nai seyana faine ayo badi sifi-dina keke ida nuvuyo faidiya. ");
INSERT INTO bwd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ada tainei anafaiweya, taidei biyabiyama-dina wagaidiya ani Tamami gabameya keke nuwanuwana seyana ginavuyo yawai-vagata anawai faina. ");
INSERT INTO bwd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kai tubuiya tovetumagana ginadewa koyona wagainiya, unanau ada yana koyona faina una kivetuvetununa. Keke yoo matadiya unavone, aku amiselu amikavuya wana ifufu. Kai bona gina nogalina, aga aseasena bademowa ukivilana ke nodi wana veseyana-vagilemi. ");
INSERT INTO bwd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aku kai bona keke gina nogali, aga kaliva seyana kai iluwei una nauwedi ke badi ina nogalina. Anafaiweya adaveimeya givona, ‘Gilubodana toitavedama adiselu o aditoto ina awatalatalaina seya-moena gavana giyegemona faina. Taidei wagaine gavana velemoena ani ina kivealamanidi, e ada kaliva ina alamanena ida vona velemoena.’ ");
INSERT INTO bwd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aku kaduwe kai yadi vona keke gina venogale, aga gaitoma matatabuna una ifufuyena tovetumagana adiyoo matadiya. Ada kaduwe kai yadi kivetuvetunu keke gina nogali, aga banae wana segena ke wana dewena anafaiweya banae kaliva-kavokavovo keke Yaubada anatovetumagana, o kai tokoyona takesi anatoyaudi anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Gavona velemoena, gavana babiya wana awatana, anafaiweya kaduwe Yaubada bademowa giawatana gabameya. Ada gavana babiya wana awaegena, anafaiweya kaduwe Yaubada bademowa giawaegena gabameya. ");
INSERT INTO bwd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kaduwe gana vonemi, kai tovetumagana amiselu wagaimiya aku gavana tamo faina idedeku babiya wana veola yami nuwanuwa seyana wagaine, aga Kamaku gabameya ani yami nuwanuwa anafaiweya gina velemi. ");
INSERT INTO bwd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Faina kai amiselu o amitoto wana vagauta akuyeganeya, Iya imi nodi kana miyamiya.” ");
INSERT INTO bwd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Aku Pita gielai Yeisu wagaine gitolidadana, givona, “Kauveya, kai tubuiyaku gina koyokoyona wagaikuya aku yana koyona gavaiyei tova gana venuwaegedi? Kai tova seveni o gavaiyei tova?” ");
INSERT INTO bwd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeisu givona, “Gana voneni, keke tova seveni gaga, aku tova ke tova yana dewa una venuvenuwaegena. Keke una ilova. ");
INSERT INTO bwd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Taidei anafaiweya kaliva yadi koyona wana venuwaegedi. Faina Yaubada yana ebaveimeya taidei anafaiweya. Kini seyana nuwanuwana yana togugaiyavo adiketowai ina fatana. ");
INSERT INTO bwd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ada givebutu gidouwedi ielai aku kaliva seyana anaketowai lakai-moena, vaita gavaiyei milioni kina anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ada togugai-nai keke anafata anaketowai ginafata, taidei faina yana kini giveimeya ada togugai-nai tauna, vavinena, ke natunavo ina vekimoneyedi ina vetogugai yogoyogodiyavo, ada kaduwe yana kevakeva ke yana lokoloko matatabuna ina vekimoneyedi aku fatadi ina vaina ada anaketowai ina fatana. ");
INSERT INTO bwd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Taidei anafaiweya giveimeya, aku togugai-nai wa yana nuwavita lakaina tugana givetodonena yana kini matane, aku giveola tagitagiya wagaine, givona, ‘Kauveya, uda atuvefaila faikuya ada aimo akuketowai matatabuna gana fatana.’ ");
INSERT INTO bwd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aku kini bade gialamanena yana togugai anaketowai lakaina aimo keke anafata, e ada ginuwakalikaliyena ke anaketowai givenuwaegena aku giawaege ginau. ");
INSERT INTO bwd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aku togugai-nai giyegemona ginanau ani giitana tubuiyana togugai seyana giketowai bana wagaine, ani anatubuga wani analedi kina (K100). Ada agona gikiveyabina ke gina kifuwana aku givonena, ‘Aketowai una madufatana!’ ");
INSERT INTO bwd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ada tubuiyana tugana givetodonena aku giveola tagitagiya, givona, ‘Tubuiyaku, uda atuvefaila faikuya ada aimo akuketowai matatabuna gana fatana.’ ");
INSERT INTO bwd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aku yana veola keke gida venogale. Au ginauwena deli wagaine giselukuwena ke gina miyamiya aku anaketowai gina fatana. ");
INSERT INTO bwd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Aku togugaiyavo tufodi iitana gavana giyegemona tubuiyadi wagaine ada inuwavita lakaina, ada inau yadi kini-nai wagaine iawatalatalaina togugai koyona yana dewa matatabuna faina. ");
INSERT INTO bwd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","E ada kini yana togugai-nai gidouwe gielai ada givonena, ‘Oye togugai koyona! Uveola-nuwakalikali wagaikuya ada aketowai lakai-moena ani matatabuna gavenuwaegena. ");
INSERT INTO bwd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Iya oye ganuwakalikaliyeni, aku gavaiyamu-yo o keke tubuiya uda nuwakalikaliye?’ ");
INSERT INTO bwd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ada yana kini ginuwakoyo lakai-moena, e ada giveimeya ke togugai-nai iimili ginau deli anatoitaveyabina manimaninidiyavo nimadiya, ada ina vematavulogina aku analaba anaketowai matatabuna ginafata-yabuna.” ");
INSERT INTO bwd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ada Yeisu yana vona giluyabuna, givona, “Kai keke tubuiyami wana nuwakalikaliye ke yana koyona wana venuwaege aseasemiya, aga Kamaku gabameya gimiyamiya ani taidei anafaiweya ginadewa wagaimiya.” ");
INSERT INTO bwd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aku Yeisu ifufu-dina giluyabu ada Galili gisegena aku gina giluku Yudiya anafafali wagaine. Tainei gufa Yolidani fafaline. ");
INSERT INTO bwd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ada yoo lakaina imuliyena ada wadedeku-deya yadi toveoga gikiveiwakanedi. ");
INSERT INTO bwd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aku Falisiyavo tufodi ielai Yeisu wagaine ke ina galuvaluvana, e ada itolidadanena, ivona, “Gavaiyamu, kai kaliva nuwanuwana vavinena gina viyoliliyedi tamo vuvu gina itanuwagana faina, aga yada veimeya giawaegena o keke?” ");
INSERT INTO bwd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeisu gilufata, givona, “Kai keke wada veyawa vaita Banae-nai gibubudi ani tuwai-moena ibubuna vaguvagu anatova wagaine-deya ani kaliva ke vavine gibubudi, ");
INSERT INTO bwd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ada givona, ‘Taidei faina kaliva inana ke tamana gina miyasegedi aku ginanau ada vavinena nodi ina miyaluga ke adiselu ina vevovo seyana’? ");
INSERT INTO bwd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nagona adiselu imiya tulina tulina ada anaita ani iluwei, aku malinai iveseyana. Taidei faina gavana Yaubada giavina ke givemiyalugedi ani keke tamo gaito gida vemiyadakadi.” ");
INSERT INTO bwd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Badi Falisiyavo ivona, “Aku gavana faina Mosese veimeya gisei evona kai kaliva nuwanuwana vavinena gina viyoliliyedi, aga viyolili anamatawa vavinena gina veledi, ayo muliya gina imilidi inanau?” ");
INSERT INTO bwd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeisu givona, “Imi aseasemi kugadi faina, nuwanuwami taumiyavo yami edaeda wagaine wana gugai. E ada Mosese giawaegemi vavinemiyavo wana viyoliliyedi. Aku tova nagona ibubuna vaguvagu wagaine, Yaubada keke gida awaegemi viyolili faina. ");
INSERT INTO bwd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ada Iya gana vonemi, gavakaliva vavinena gina viyoliliyedi aku vavine evaguna gina nagina, banae giudo. Keke anaawaega ada vavinena gina viyoliliyedi, aku au vuvu seya-moena ani, kai vavinena tauna giawaegena ada mali kaliva nodi iudo. Taidei-mowa wagaine e kaliva yadi nagi gina yawelina.” ");
INSERT INTO bwd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aku Yeisu yana tonogalayavo ivonena, ivona, “Wada vita-moena! Kai kaliva yadi nagi vavinediyavo nodi ani anaveimeya taide anafaiweya, aga kaliva keke idanagi.” ");
INSERT INTO bwd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Banae givonaga, “Vona taidei keke vaita kaliva moyaidi adifaiweya ina muliye, aku badi gavega wagaidiya Yaubada veimeya gisena ani adifaiweya ina muliyena. ");
INSERT INTO bwd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Faina kaliva yadi vuvu tulina tulina faidiya ada keke inanagi. Tufodi itubuga anafaiweya ada keke inanagi, aku tufodi ani daba ivaina ada keke adifaiweya inanagi. Aku tufodi taudiyavo iawatadi e ada keke inanagi aku Yaubada yana gugai ina gugai faina. Badi gavega adifata vona taidei faina, aga ina muliyena.” ");
INSERT INTO bwd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kaliva tufodi biyabiyama ialiyedi Yeisu wagaine ada vaita nimana ginasena wagaidiya ke gina veoveola faidiya. Aku tonogalayavo taidei iitana ada iawatadi. ");
INSERT INTO bwd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aku Yeisu givona, “Biyabiyama keke wana awatadi aku wana awaegedi inaelai wagaikuya, faina Yaubada yana ebaveimeya anakalivayavo ani taide biyabiyama-dina anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ada nimana gisena biyabiyama wagaidiya ke giawanuwakabubuyedi, e ayo gisegedi aku gitauya ginau. ");
INSERT INTO bwd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tova seyana tubulakata seyana gielai Yeisu wagaine givonaga, “Tovewala, gavana iwakana gada gugai ayo yawai-vagata gada nuwaga?” ");
INSERT INTO bwd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeisu givona, “Gavana faina Iya utolidadaneku gavana iwakana faine? Yaubada Tauna anakaibe-mowa iwakana. Aku kai nuwanuwa yawai-vagata wagaine unaluku, aga Yaubada yana veimeya una itaitaveyabidi.” ");
INSERT INTO bwd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ada bana givona, “Gava veimeya?” Yeisu givona, “Keke una luvealika, keke unaudo, keke una kiyafu, kaliva yadi gugai faidiya keke una awatalatalaina fwayafwaya, ");
INSERT INTO bwd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ina ke tama una vemoimoinedi, kaduwe kaliva una nuwakabubuyedi o tauni unuwakabubuyeni anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kaliva tubulakaina givona, “Tainei veimeya-dina matatabudi gaitaveyabidi. Aku gavana wagaine gavemaufo e ada gida lubodaku kadu gada gugai?” ");
INSERT INTO bwd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeisu givona, “Kai nuwanuwa una tunutunugina velemoena Yaubada matane, aga unanau ya lokoloko moyaina una vekimoneyedi ke manina una veledi fanifani, e ada kaikaiwabu velemoena gabameya una nuwagana. Ada unaela una muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aku kaliva tubulakaina ginogalina Yeisu yana vona, ada au magigina gikokomina ke wa yana nuwavita gitauya ginau. Faina banae yana lokoloko moyai-moena. ");
INSERT INTO bwd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ada Yeisu yana tonogalayavo givonedi, givona, “Gavona velemoena, badi tokaikaiwabu yadi luku Yaubada yana ebaveimeya wagaine ani au vitana velemoena. ");
INSERT INTO bwd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yaku vona gana luvagilena. Tokaikaiwabu faidiya ani vita-moena. Wana itana, kevakeva lakaina anayegana kameli ani kai gina balalava ada vaita gaima matana wagaine gina lukufolega ani gavaiyamu, anafata? Keke. Ada tokaikaiwabu ani ananuwanuwa anafaiweya. Kai badi taudiyavo yadi toyogina wagaine ina balalava ke Yaubada yana ebaveimeya wagaine inaluku, ani ibalalava-wayoga.” ");
INSERT INTO bwd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ada tonogalayavo vona taidei inogalina wagaine, meyadi ibovu ada ivona, “Kai taidei anafaiweya, aga gaito anafaiweya kibababala gina nuwaga?” ");
INSERT INTO bwd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aku Yeisu giitafasedi ada givona, “Kaliva wagaidiya ani gaitoma taidei keke maita meyameyaganina, aku Yaubada wagaine ani gaitoma matatabuna meyameyaganina.” ");
INSERT INTO bwd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ada Pita givonena, givonaga, “Una itana, ime gaitoma moyaina asegedi ada aela O amuliyeni. E ada gavana ana nuwaga?” ");
INSERT INTO bwd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeisu givonedi, givona, “Gavonemi velemoena, aimo tova gielaelai wagaine gaitoma moyaina adikiveevagu wagaine, Banae Kaliva Natuna yana veimeya anaebavetoga kaikaiwabuna wagaine gina vetoga tova-nai, imi wamuliyeku ani kaduwe veimeya anaebavetoga kaikaiwabuna tuwelo wagaidiya wana vetogami aku meIsileli unumidi adituwelo wagaidiya wana veiveimeya. ");
INSERT INTO bwd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ada badi gavega Iya faikuya inuwanuwa e ada yadi manuwa isegedi o kai tubuiyadiyavo o novudiyavo, kai inadiyavo o tamadiyavo o natudiyavo, kai yadi babi isegedi, ani badi gaitoma-dina fatadi analedi wa anavetutamwata inavaina. Ada kaduwe yawai miyamiyani-vagaina ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aku moyaidi tova malinai wai inagonagona ani aimo tova gielaelai wai ina muline-mwena, aku badi gavega tova malinai wai imuline-mwena ani tova gielaelai aimo wai ina nagona.” ");
INSERT INTO bwd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Taidei anafaiweya gavona faina Yaubada yana ebaveimeya anafaiweya kaliva seyana banae wa yana gileifi anabakula. Ada seyana tova malabutuya-mwaeya gitauya ginau maketi wagaine ke tofaisewa gina leledi ina faisewa yana bakula wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ada kaliva tufona ginuwagadi ada nodi iifufu ke iawaegau ani ina faisewa yana bakula wagaine yadayada seyana, ada yadayada seyana analaufata mani siliva seyana gina veledi. E ada giimilidi inau yana bakuleya. ");
INSERT INTO bwd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kauwana gilaka anafaiweya naeni kiloki malabutuya. Ada kaliva-nai ginau-vagila maketi wagaine ani giitana kaliva tufodi imiya-kavokavovo. ");
INSERT INTO bwd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ada givonedi, ‘Imi kaduwe wananau yaku gileifi anabakula wagaine wana faisewa, ada gavana yami faisewa anaiwakana, fatana gana velemi.’ ");
INSERT INTO bwd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ada kaliva-dina inau bakuleya. “Aku kauwana gielai givugivudeya ke kaduwe au gienovilana kauwana teli kiloki wagaine, ginau-vagila anafaiweya ada kaduwe kaliva tufodi givaidi inau yana bakuleya. ");
INSERT INTO bwd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ada mala givelavilavi kauwana faifi kiloki wagaine, kadu kaliva-nai ginau melaleya ani giitana kaliva tufodi imiya-kavokavovo, ada gitolidadanedi givona, ‘Gavana faina idedeku yadayada anamatatabuna wamiya-kavokavovo?’ ");
INSERT INTO bwd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Badi ivona, ‘Keke seyana gaito gida vaima faisewa faina.’ “Ada banae givona, ‘Iwakana, imi kaduwe wananau yaku gileifi anabakula wagaine wana faisewa.’ Ada badi kaduwe inau yana bakuleya. ");
INSERT INTO bwd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Aku bade mala givelavilavi-mowa ada tonibakula-nai yana togugaiyavo aditoitaveyabina givonenaga, ‘Tofaisewa matatabudi una yowanidi ada fatadi una veledi. Badi wai imuli-moe gavaidi, wagaidiya una maduvevuvu fatadi una veledi, ke matatabudi una fatadi anafaiweya ada ginanau badiyavo ebavevuvu wagaine gavaidi ani wagaidiya una luyabu.’ ");
INSERT INTO bwd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ada tofaisewa-dina wai imuli yadi faisewa ivebutuna faifi kiloki wagaine, ani ielai ada kaliva seyana seyana fatadi ivaina mani siliva seyana. ");
INSERT INTO bwd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aku tofaisewa wai inagona ani ielai fatadi ina vaina, ada inuwanuwa vaita fatadi gina kilakaina, aku keke. Badi kaduwe mani siliva seya-moena ivaina. ");
INSERT INTO bwd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yadi mani ivaina ada ivebutu tonibakula wagaine igavoluvolu, ");
INSERT INTO bwd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ivonaga, ‘Kaliva-dina taidei wai imuli-moe ifaisewa kauwana bai seya-moena, aku imeyavo ani yadayada matatabuna afaisewa toyogina ada kauwana lakaina gikabuma, aku fatama anafaiweya badiyavo.’ ");
INSERT INTO bwd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Aku tonibakula-nai tofaisewa seyana givonenaga, ‘Tubuiyaku, una nogalina. Iya keke gada gugai koyona wagainiya, faina nodi kaveimeya vaita siliva seyana una vaina yadayada seyana anafaisewa faina. ");
INSERT INTO bwd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Au ya mani unavai unanau. Iya nuwanuwaku kaliva wai gimulina ani yana mani gana velena anafaiweya oye gaveleni. ");
INSERT INTO bwd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ida Iya yaku mani, ada gilubodana tauku gana veimeya gavaiyamu gana vegugaiye. Gavaiyamu, ago giuga faina Iya kaliva galemedi iwakana ada keke gada nuwanuwalolona?’” ");
INSERT INTO bwd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ada Yeisu yana vona giluyabuna givona, “E ada badi gavega tova malinai wai imuline-mwena ani aimo tova gielaelai wai ina nagona, aku badi gavega tova malinai wai inagonagona ani aimo tova gielaelai wai ina muline-mwena.” ");
INSERT INTO bwd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeisu gilakalaka Yelusalema faina aku yana tonogalayavo adituwelo givonedi ielai wagaine ada adiloi aku givonedi, givona, ");
INSERT INTO bwd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Wana nogalina. Ideyavo kalakalaka Yelusalema, ada Banae Kaliva Natuna ina atuegena veyavo anatovegugai lakaidiyavo ke veimeya anatovewalayavo nimadiya, ada badi ina veimeya analuvealika faina. ");
INSERT INTO bwd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ada muliya inasena badi keke meIsileli nimadiya ke badi ina awaveleigena, ina lubibiwalina, ada kelose wagaine ina tutuvefosena gina alika. Aku yadayada anaveto wagaine Yaubada gina siveyawana alikeya.” ");
INSERT INTO bwd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aku tova-nai wagaine Sebedi vavinena wa natudiyavo adiselu nodi Yeisu wagaine ielai, ada vavine-dina tugadi ivetodonena ke Yeisu ina veolena gaitoma seyana gina gugaiyena faidiya. ");
INSERT INTO bwd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ada Yeisu gitoliyedi, “Gavana nuwanuwami?” Ada badi ivonaga, “Natumeyavo adiselu uda awaegedi ke aimo tova-nai una veimeya vaguvagu ya ebaveimeya wagaine, ani lilivaniya ida vetoga. Seyana aiyataginiya ke seyana aimauliniya.” ");
INSERT INTO bwd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Aku Yeisu givonedi natudiyavo nodi, givona, “Gavana waveola faine ani ananuwanuwa keke wada alamane. Gavaiyamu, aimo uloulolo anavei wagaine ganayuga ani imi amiselu amifaiweya wana yugena?” Badi adiselu ivona, “Amafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeisu givona wagaidiya, “Vona velemoena akuvei-nai wagaine wanayuga. Aku gaito aiyatagikuya gina vetoga ke gaito aimaulikuya, ina Iya keke yaku ebaveimeya, aku badi gavega Kamaku givenuwadadanedi ani faidiya gikidewedewena.” ");
INSERT INTO bwd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aku tonogalayavo aditeni inogalina gavana Iyemesa ke anatubuluga nodi yadi veola faina, ada inuwakoyo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Au Yeisu gidouwedi ivagauta wagaine ada givonedi, “Waalamanena badi keke meIsileli aditoveimeyayavo ani iveiveimeya toyogina yadi kalivayavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aku imiyavo ani keke anafaiweya wanadewa. Aiyada badi gavega amimwatuguya nuwanuwadi taudiyavo adiyegana lakaina, aga gilubodana ina vetogugai moyaimi wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kaduwe gaito wagaimiya nuwanuwana gina vetonagona, aga gilubodana gina vetogugai yogoyogona moyaimi wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tainei anafaiweya Banae Kaliva Natuna giobuelai babiya, keke vaita kaliva inagugai Banae faine, aku velemoena ani Banae gina gugai kaliva faidiya ada yawaina gina awaegena moyaidi aditutuveobu faina.” ");
INSERT INTO bwd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aku Yeisu yana tonogalayavo nodi Yeliko-deya iyegemona inaunau aku yoo lakaina imuliyena. ");
INSERT INTO bwd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aku kaliva adiselu matadi koyo-moedi, ani wai lilivane ivetogadi aku inogalina kaliva ivonavona vaita Yeisu giela ginaunau. Ada ivebutu ivedoudou, “Kauveya, Oye Deivida yana tubudelideli, uda nuwakalikaliyema!” ");
INSERT INTO bwd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aku yoo lakaina tomatakoyo iduweyedi ada ivona, “Auwe gina kulumi!” Aku badi keke. Au bonadi gilaka-mowa ivedoudou, “Kauveya, Oye Deivida yana tubudelideli, uda nuwakalikaliyema!” ");
INSERT INTO bwd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ada Yeisu au ginumididi aku gidouwedi ielai wagaine ada givonedi, “Gavana nuwanuwami ganagai faimiya?” ");
INSERT INTO bwd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Badi ivona, “Kauveya, nuwanuwama matama ida veiwaka.” ");
INSERT INTO bwd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ada Yeisu ginuwakalikaliyedi ke nimadidina gisena matadiya, ada maduga-mowa matadi iyegeyegana ke Yeisu imuliyena. ");
INSERT INTO bwd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yeisu yana tonogalayavo nodi ilakalaka Yelusalema faina, aku nagona melala kabisona Bedipegi wagaine iyegemona, tainei Oya Olive dibune. Wadedeku-deya, aku yana tonogalayavo adiselu giimilidi ke wai ina nagona, ");
INSERT INTO bwd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","givonedi, “Imi wai wana nagona melala wadebaimiya wagaine, ada wana lukuluku ani wanamadu itadi doniki wa natudi isifodi. Wana yavudi ada wana aliyedi wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ada kai tamo gaito gina tolidadanemi gavana wagugai, au wana vonena, ‘Kauveya gina vegugaiyedi tufona yana faisewa wagaine, ada tova kabisona gina imili-vagile inaelai.’ E ada kaliva-nai ginamadu awaegedi wana aliyedi.” ");
INSERT INTO bwd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Taidei gaitoma-dina iyegemona e ada tuwaina gavana falofita givonayena, ani anafaiweya gina yegemona velemoena, givonaga, ");
INSERT INTO bwd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“MeSaiyoni wana vonedi, ‘Wana itana, yami Kini gielaelai wagaimiya. Banae tonuwaobu, ada doniki wagaine givetogana. Doniki natudi wagaine givetoga gielaelai.’” ");
INSERT INTO bwd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ada tonogalayavo adiselu inau ada gavaiyamu givonedi, anafaiweya igugai. ");
INSERT INTO bwd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Doniki wa natudi ialiyedi ada adinuya badobadodi iyavelidi doniki tubulakaina domone ke Yeisu giyage. ");
INSERT INTO bwd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ada kaliva moyaidi yoo wagaidiya adinuya badobadodi iyavelidi waiya, aku tufodi ai lagadi wa lukudi ikuyadi ke wai wagaine isedi. ");
INSERT INTO bwd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ada yoo tufodi wai inagona Yeisu debaine kaduwe tufodi wai imulina, aku moyaidi ikovakova, ivonaga, “Osana! Kana davana Deivida yana tubudelideli! Banae gielaelai KAUVEYA anayeganeya ani wa anaawanuwakabubu! Osana! Yaubada Togetanemwane kaawadavadavana!” ");
INSERT INTO bwd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Taidei anafaiweya bonadi lakaina wagaine idavadavana aku Yeisu giluku Yelusalema ginaunau. E aku melala-nai anakaliva moyaidi giivenuwanuwadi toyogina ada ivonavona, “Ida gavakaliva?” ");
INSERT INTO bwd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ada yoo-dina Yeisu ikwayabuna ilufata ivona, “Ida falofita Yeisu, kwana Nasaledi, Galili anafafali gielai.” ");
INSERT INTO bwd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ada Yeisu giluku manuwa tabu anafafali wagaine, ada badi gavega ikimokimone ke ivevekimone ani giveyegemonidi. Ada mani anatosevedavedama yadi teibeli ke kaduwe bunebune aditolufalifaliyavo yadi ebavetoga gibwataviladi. ");
INSERT INTO bwd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ada givonedi, “Yaubada bonana ivetokilumina Buki Tabu wagaine givonaga, ‘Yaku manuwa ani ina vewagana manuwa ebaveoveola.’ Aku imiyavo wagana vaita tokiyafu yadi manuwa.” ");
INSERT INTO bwd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ada badi matadi koyo-moena ke tovefela ielai Yeisu wagaine manuwa tabu anafafaliya, ada gikiveiwakanedi. ");
INSERT INTO bwd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aku veyavo anatovegugai lakaidiyavo ke veimeya anatovewalayavo, ani iitana gugai ebameyasidobodobo Yeisu gigugaiyedi, kaduwe biyabiyama iluku manuwa tabu anafafali wagaine ivekovakova, ivonavona, “Osana! Deivida yana tubudelideli kana davana!” E ada gaitoma-dina taidei faidiya inuwakoyo Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ada itolidadanena ivona, “Maita unogalina gavana biyabiyama taidei ivonavona?” Yeisu givonaga, “Ika ganogalina. Aku maita waveyawana Buki Tabu wagaine givona, ‘Biyabiyama ada bebeta uvewaledi ke awadiya iawadavadava velemoena’?” ");
INSERT INTO bwd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ada Yeisu gisegedi aku giyegemona Yelusalema-deya ada ginau melala Bedani wagaine gidau. ");
INSERT INTO bwd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Malabutuya-mwaeya Yeisu giyewayewa-vagila Yelusalema aku mafa gilavuna. ");
INSERT INTO bwd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ada ai guwaguwa seyana anafaiweya alaa giitana wai lilivane. E ada ginau wagaine aku luku gagana ginuwagana, keke tamo guwana. Ada givona ai wagaine, givonaga, “Keke tamo tova kaduwe una veguwa.” Ada maduga-mowa ai-nai gimayewana. ");
INSERT INTO bwd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yana tonogalayavo iitana ayo meyadi gisidobodobona, ivona, “Gavaiyamu ada ai gimadumayewa-moe?” ");
INSERT INTO bwd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeisu givonaga, “Gavonemi velemoena, kai wa yami vetumagana aku keke wana nuwakila, aga amifata ai taidei wagaine wanadewa anafaiweya Iya gadewa. Ada keke taidei gagana, aku kaduwe kai oya taidei wagaine wanavona, ‘Unaobu leyageya,’ aga gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kai wa yami vetumagana Yaubada wagaine, aga gavana wana veoveola faine ani wana nuwagana.” ");
INSERT INTO bwd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeisu giyewa giluku manuwa tabu anafafali wagaine, ada givewavewala aku veyavo anatovegugai lakaidiyavo ke meIsileli yadi kaliva lakaidiyavo ielai Bana wagaine. Ada itolidadanena, ivonaga, “Ida gava veimeya wagaine gaitoma-dina taidei ugugaiyedi? Ada gaito veimeya taidei giveleni?” ");
INSERT INTO bwd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeisu givonedi, “Iya kadu tolidadana seyana gana tolidadanemi gaitoma seyana faine. Ada kai wana lufata wagaikuya, aga Iya kaduwe gana vonemi gava veimeya wagaine gugai taidei gagugaiyedi. ");
INSERT INTO bwd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iyoni Tobabitaiso ani gaito veimeya givele ke kaliva gikivebabitaisodi? Yaubada o kaliva?” Ada taudiyavo iveifuifufuyena, ivona, “Gavaiyamu kanavona? Kai kanavona, ‘Yaubada veimeya givelena,’ aga gina voneda, ‘E ada gavana faina Iyoni yana vona keke wada vetumagane?’ ");
INSERT INTO bwd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aku kai kanavona, ‘Kaliva veimeya ivelena,’ aga yoo kamatausedi, kai ina manini wagaideya, faina kaliva moyaidi ivetumagana vaita Iyoni banae Yaubada yana falofita seyana.” ");
INSERT INTO bwd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","E ada ilufata Yeisu wagaine ivona, “Keke ada alamane.” Bana givona, “E ada Iya kadu keke gana vonemi gaito yana veimeya wagaine ida gaitoma-dina gagugaiyedi.” ");
INSERT INTO bwd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ada kadu givonedi, “Gavaiyamu yami nuwanuwa? Kaliva seyana natunavo adiselu. Ada ginau tomoinagona givonena, ‘Natuku, malinai unanau yaku bakula wagaine una faisewa.’ ");
INSERT INTO bwd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Aku gilufata givona, ‘Iya auwe.’ Aku muliya yana nuwanuwa gisevedavedama ada ginau gifaisewa. ");
INSERT INTO bwd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ada kaliva-nai ginau kaduwe kwamaneya givonena anafaiweya. Ada gilufata givona, ‘Iwakana. Gananau.’ Aku keke gidana. ");
INSERT INTO bwd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","E ada adiselu wagaidiya, gavakaliva tamana yana vona gimuliye?” Badi veyavo anatovegugai lakaidiyavo ke meIsileli aditonagonayavo ivona, ivonaga, “Tomoinagona.” Yeisu givona wagaidiya, “Gavonemi velemoena, badi takesi anatoyaudiyavo ke wai dobona anavevineyavo, biyavo-dina kavewagadi tokoyona, ani badi ina maduluku Yaubada yana ebaveimeya wagaine, aku imiyavo ani gavaiyamu? ");
INSERT INTO bwd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Faina Iyoni Tobabitaiso gielai wagaimiya ada dewa yegayegana anawai givewalemi, aku imi keke yana laumamala wada vetumagane. Aku badi takesi anatoyaudiyavo ke wai dobona anavevineyavo ani ivetumaganena ada yadi dewa koyodi wagaidiya inuwavilana. Aku imi matamiya waitana inuwavilana, nonogana keke Iyoni wada vetumagane e ada wada nuwavila.” ");
INSERT INTO bwd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kaduwe Yeisu givona, “Kadu vona matalivulivuna seyana wana nogalina. Toni babi seyana, yana babi wagaine gileifi bulavadi analoi gibakulina. Bakula-nai gikalififina ada olu giyala giobu kabisona gileifi anaebavagafuwafuwa faina. Ada vada tulatulana giyogona e ada tofaisewa getane ina miyamiya aku matadi inasege ina nudadana bakula-nai anayavaga faina. Ada toni bakula gaitoma moyaina gibubudi giavaina, muliya kaliva tufodi nodi iveimeya ke bakula ina kidewedewena ada ina itaveyabina, aku ikolu anatoveya toni bakula-nai anavutuvutuga guwa ina velevelena. Aku tauna ani yana melala gisege ginau mali fafaliya gimiya. ");
INSERT INTO bwd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ada imiyamiya aku gileifi anaikolu anatova giyegemona, ada tonibakula-nai yana togugaiyavo giimilidi inanau bakula anatoitaveyabina wagaidiya vaita anavutuvutuga gileifi guwana ina vaina, anafaiweya gavaiyamu yadi awaegena tova-nai veimeya ibubuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ada yana togugaiyavo inau wagaidiya aku toitaveyabina ikiveyabidi ada seyana ilumalimaliwavuna, seyana iluvealikana, aku seyana kabala wagaidiya itutuvealikana. ");
INSERT INTO bwd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ada kadu togugai velugadiyavo tufona moyaidi giimilidi, aku toitaveyabina kadu anafaiweya idewedi. ");
INSERT INTO bwd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ebalauyabu wagaine natuna kaliva giimilina wagaidiya. Ada givonaga, ‘Ida natuku, ada ina vemoimoinena.’ ");
INSERT INTO bwd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Aku natuna ani tova-nai giyegemona ada toitaveyabina-dina iitana, taudiyavo iveifuifufu, ivona, ‘Ida tau-moena toni laova. Ada aimo bakula taidei ginavai gina veimeyena. E ada wanaela kana luvealikana ada yana bakula kana vaina.’ ");
INSERT INTO bwd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ada au ikiveyabina ke itai iyegemonena gileifi anabakula wagaine ada iluvealikana.” ");
INSERT INTO bwd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yeisu yana vona matalivulivuna giluyabuna aku gitolidadanedi, givona, “E ada tonibakula tova-nai gina yewana yana bakula wagaine, gavaiyamu badi toitaveyabina gina dewedi?” ");
INSERT INTO bwd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ada badi veyavo anatovegugaiyavo ke tonagonayavo ilufata, ivonaga, “Ginaelai kaliva-dina koyodi gina munudi velemoena ke ina alika. Aku toitaveyabina evagudi nodi ina veimeya yana bakula faine ke ina itaveyabina, ada badi anavutuvutuga ina velevelena guwa ikolu anatova wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ada Yeisu givona wagaidiya, “Kai vona seyana Buki Tabu wagaine keke wada veyawa, givonaga, ‘Ogola-nai manuwa toiyogona idibusoyogena ani banae gimidinagona ogola velugadiyavo wagaidiya. Ida KAUVEYA yana gugai, ada matadeya ani iwaka-vagaina.’ ");
INSERT INTO bwd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Tainei faina gana vonemi, Yaubada yana ebaveimeya gina vaiyavulena imi wagaimiya aku badi keke meIsileli gina veledi, ada biyavo-dina guwa iwakana ina veguwayena anafaiweya Yaubada yana ebaveimeya analauboda. ");
INSERT INTO bwd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ada moyaidi gavega inabeu ogola-nai wagaine ani ina bidobodobodi kabiso kabiso, aku badi gavega wagaidiya ogola-nai ginabeu gina lutagodi ani gina lufuwafuwadi vaita avu anafaiweya.” Taidei anafaiweya Yeisu givona. ");
INSERT INTO bwd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aku badi veyavo anatovegugai lakaidiyavo ke Falisiyavo ani Yeisu yana vona matalivulivuna inogalina wagaine, nuwadi gimalina vaita badi faidiya givonavona. ");
INSERT INTO bwd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tainei faina wai ilelena vaita ina kiveyabina aku yoo imatausedi, faina kaliva moyaidi inuwanuwayena vaita Banae Yaubada yana falofita seyana. ");
INSERT INTO bwd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeisu kaduwe givona matalivulivuna wagaidiya, givona, ");
INSERT INTO bwd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yaubada yana ebaveimeya anafaiweya kini seyana natuna kaliva yana nagi anakani vemwamwala gikidewedewena. ");
INSERT INTO bwd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ada yana togugaiyavo giimilidi inau ada badi gavega ginuwabiyedi ani ina matawedi inaelai. Aku idibusoyoga. ");
INSERT INTO bwd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kaduwe yana togugaiyavo tufona giimilidi ada givonedi, ‘Badi gavega nuwabi inuwagana ani wana vonedi, “Yaku aa bademowa gakidewadewa, ada yaku bulumakau lakaidi ke natudiyavo yafayafadi imunudi ke ilutalatalaidi. Gaitoma matatabuna gakidewadewa gibodaboda. Wanaelai nagi anakani vemwamwala wagaine.”; ");
INSERT INTO bwd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Taidei anafaiweya imatawedi aku kini yana nuwabi ivegaitoma-kavokavovoyena, ada au yadi faiseweya iabinaunau. Kaliva seyana ginau yana bakula wagaine, seyana ginau yana sitoweya, ");
INSERT INTO bwd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","aku tufodi ani yana togugaiyavo ikiveyabidi ada ikivekoyodi velemoena ada iluvealikadi. ");
INSERT INTO bwd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kini valeyadi ginogalina wagaine ginuwakoyo lakai-moena, ada yana tolugaviya giimilidi ke toluvealika-dina ani iluvealikadi ada yadi melala lakaina ikabuna. ");
INSERT INTO bwd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Aku kini kaduwe yana togugaiyavo gidouwedi ielai ada givonedi, givona, ‘Nagi anakani vemwamwala bademowa gakidewedewena aku badi ganuwabiyedi ani ganuwenuwedi vaita badi kaliva iwakadiyavo, aku keke anafaiweya. E ada keke adilauboda inaela. ");
INSERT INTO bwd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tainei faina wananau melala anawai lakaidi wagaidiya ke gavega wana nuwagadi aga wana nuwabiyedi inaelai nagi anakani vemwamwala wagaine.’ ");
INSERT INTO bwd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ada togugaiyavo iyegemona inau wai wagaidiya kaliva moyaidi ivagauledi, badi iwakadiyavo kadu koyodiyavo. E ada kani vemwamwala anamanuwa ebavagauta ivemagana. ");
INSERT INTO bwd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“E aku kini nuwanuwana wakawaka-dina gina itadi, e ada giluku ginau ani giitana kaliva seyana keke nagi ananuya gidaose. ");
INSERT INTO bwd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ada gitolidadanena, ‘Tubuiyaku, gavaiyamu-yo nagi ananuya keke udaose aku ulukuela yaku kanibutu wagaine?’ Ada kaliva awana giyagona, keke gida lufata. ");
INSERT INTO bwd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Au kini yana togugaiyavo givonedi, ‘Nimana, agena wana yogodi ada wana nauwe yuyuvaneya wana batuge gina yegemona. Ada wadedeku-deya gina tagitagiya ke nigona gina vekudaligoligota uloulolo wagaine.’” ");
INSERT INTO bwd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeisu yana vona giluyabuna givonaga, “Faina kaliva moyaidi adiyowana inuwagana, aku adigavaiyei gaga venuwadadana inuwagana.” ");
INSERT INTO bwd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aku Falisiyavo Yeisu yana ifufu inogalina ada itauya ina iveimeya ke seba inasena tolidadana wagaine, aku Yeisu ina vebavuna ke vona gina sidamanena. ");
INSERT INTO bwd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","E ada yadi tonogalayavo tufodi ke kaduwe Elodi yana kalivayavo tufodi nodi iimilidi ielai Yeisu wagaine ivonena, ivonaga, “Tovewala, ime aalamanena Oye uvonavona velemoena, keke uda vefwayafwaya. Yaubada yana wai faina uvevewala tunutunugina. Ada kai kaliva anayegana lakaina o kai keke, Oye ani keke uda nuwanuwa faine e ada keke uda venuwana gavaiyamu ina nuwanuwa. ");
INSERT INTO bwd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","E ada uda vonema gavaiyamu ya nuwanuwa. Ide meIsileli adaveimeya Mosese wagaine ani giawaegeda ada Sisa wagaine takesi kana lufata o kai keke?” ");
INSERT INTO bwd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aku Yeisu bade gialamanena inuwainage gavaiyamu tauna ina kivekoyo, ada givonedi, givona, “Imi meyalugaluga! Gavana faina wagaluvaluvaku? ");
INSERT INTO bwd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wana vewaleku gana itana mani-nai takesi faina.” Ada mani-moena ialiye ivelena. ");
INSERT INTO bwd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ada gitolidadanedi, givona, “Gaito taidei anununa? Ada gaito taidei anayegana ivetokilumi?” ");
INSERT INTO bwd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Badi ilufata ivona, “Sisa.” Banae givonedi, givona, “Taidei faina gavana Sisa yana gaitoma aga wana velena Sisa. Aku gavana Yaubada yana gaitoma aga wana velena Yaubada.” ");
INSERT INTO bwd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ada badi yana laufata inogalina wagaine meyadi gisidobodobona, e ada isegena aku itauya inau. ");
INSERT INTO bwd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aku yadayada-nai wagaine Sadusi tufodi ielai Yeisu wagaine, badi ivetumagana evona kaliva yadi alika muline keke inayawa-vagila. ");
INSERT INTO bwd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ada biyavo-dina itolidadanena, ivona, “Tovewala, Mosese veimeya seyana givetokilumina, givona, ‘Kai kaliva seyana vavinena gina alikalovena aku keke natunavo, aga gilubodana anatubuluga sikwana gina nagina, ada tubuiyana fatana faina natunavo gina vetubudi. E ada taidei wagaine ada toalika yana tubudelideli ina miyamiya.’” ");
INSERT INTO bwd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ada ebaita ivelena, ivona, “Seyana kaliva anatubulugayavo nodi adiseveni ime wagaimeya imiyamiya. Ada tomoinagona ginagi ada natunavo keke aku gialika. Ada sikwana ani taina anavelu ginagina ");
INSERT INTO bwd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","aku dewa-nai anafaiweya giyegemona ani, natuna keke aku gialika. Ada anafaiweya taina anaveto wagaine, ada anafaiweya kaduwe dewa-nai giyegemona matatabudi adiseveni wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Muline-mwane vavine gialika. ");
INSERT INTO bwd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","E ada, yawa-vagila anatoveya ani gavakaliva vavinena? Faina adiseveni-dina vavine-nai inagina.” ");
INSERT INTO bwd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aku Yeisu gilufata wagaidiya, givona, “Taidei yami sidamana, faina Buki Tabu keke wada alamane ada kaduwe Yaubada yana toyogina keke wada alamane. ");
INSERT INTO bwd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Faina tova-nai toalika inayawa-vagila, keke ina naginagi kadu keke ina vevenagi, aku au yadi miya vaita Yaubada yana aneloseyavo gabameya anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aku toalika yadi yawa-vagila faina, maita waveyawana gavana Yaubada givona wagaimiya o kai keke? Tova tuwai-moena tova-nai Ebelaamo, Aisake ke Iyakobo ialika muline, Yaubada givona Mosese wagaine, ");
INSERT INTO bwd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","givonaga, ‘Iya Ebelaamo yana Yaubada, Aisake yana Yaubada, ke Iyakobo yana Yaubada.’ Ada Yaubada ani keke kaliva alialikadiyavo yadi Yaubada, aku velemoena Banae ani kaliva wayawaidi yadi Yaubada.” ");
INSERT INTO bwd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ada yoo inogalina ani meyadi gisidobodobona yana vewala wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ada Yeisu yana laufata wagaine badi Sadusiyavo yadi vona givetufagoloina, e aku badi Falisiyavo anavaleya inogalina ada au ivagauta seyana. ");
INSERT INTO bwd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ada wagaidiya-deya, seyana banae Mosese yana veimeya anatonuwauya velemoena, ani banae gitolidadanena Yeisu vaita gina veonana, ");
INSERT INTO bwd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","givona, “Tovewala, veimeya moyaina Yaubada Mosese givelena wagaidiya ani gava veimeya lakai-moena?” ");
INSERT INTO bwd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeisu givona, “KAUVEYA Banae ya Yaubada una nuwakabubuyena asease matatabuna wagaine, ke aluwaluwa matatabuna wagaine, ada nuwa matatabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Veimeya taidei wai ginagona ada lakai-moena. ");
INSERT INTO bwd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kaduwe veimeya lakaina anavelu ani veimeya nagona ananuwanuwa anafaiweya. Taidei anafaiweya givona, ‘Kaliva una nuwakabubuyedi o tauni unuwakabubuyeni anafaiweya.’ ");
INSERT INTO bwd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Taidei veimeya-dina ani lakaidi, e ada Mosese yana veimeya matatabuna ke falofitayavo yadi vewala, ani ikwaiyoyo taidei veimeya-dina iluwei wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ada Falisiyavo aimo ebaga-nai wagaine aku Yeisu gitolidadanedi, givona, ");
INSERT INTO bwd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gavaiyamu yami nuwanuwa Banae Mesaiya faina? Banae gaito yana tubudelideli?” Badi ivona, “Deivida yana tubudelideli.” ");
INSERT INTO bwd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeisu givona wagaidiya, “Ada Deivida yana tubudelideli, aku gavaiyamu ayo tuwaina Deivida Mesaiya giawavekauveyaye, tova-nai Aluwaluwa Tabuna yana kivetuvetunu wagaine Deivida givona, ");
INSERT INTO bwd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Banae KAUVEYA Yaubada ani Iya yaku Kauveya givonena, givona, “Aiyatagikuya una vetoga analaba nibaimomo gana seobuyedi ada yadi toyogina gina avaina velemoena.”; ” ");
INSERT INTO bwd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Kai taidei anafaiweya Deivida ani Mesaiya givewagana ‘yaku Kauveya’, aku gavaiyamu-yo Mesaiya aimo gitubuga Deivida yana tubudelideli seyana?” ");
INSERT INTO bwd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Taidei anafaiweya Yeisu gitolidadanedi, aku keke tamo gaito anafaiweya ginafata, au iveyamata. Ada tayuwe yadayada-nai wagaine-deya, keke seyana gaito kaduwe gida asevatu ke Bana gida tolidadane. Au iilovau. ");
INSERT INTO bwd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ada Yeisu givona yoo ke yana tonogalayavo wagaidiya, givona, ");
INSERT INTO bwd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tova tuwaina Mosese ani tovewala lakaina Yaubada yana veimeya faidiya, aku malinai veimeya anatovewalayavo ke Falisiyavo ani badi bade isikulu Yaubada yana veimeya faidiya, e ada Mosese yana kabu ivaina. ");
INSERT INTO bwd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tainei faina gavana ivevewala, anafaiweya wana itaveyabina ke wana gugaiyena. Aku gavaiyamu idewadewa, tainei keke wana muliye, faina gavana ivevewala ani taudiyavo yawaidi wagaine keke ida vegugaiye. ");
INSERT INTO bwd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Badiyavo ani kaliva iveiveimeyedi ke yadi veimeya tulina tulina vitadi ina mulimuliyedi, vaita veinuwana vitadi kaliva iveavaladi ina waidi. Aku badi taudiyavo ani keke maita nimadi inatune ayo nimadididi seyana wagaine vita-dina ina kilakaidi ke inaleme. ");
INSERT INTO bwd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Gaitoma moyaina igugaiyedi ke kaliva ina itadi ina kaiyedi. Waitadi, Buki Tabu anamaita tufodi ivetokilumidi ada iitavadi ke adifose kabiso-moedi wagaidiya idododi ke iyogovefosedi debaidiya ke nimafoudiya. Kaduwe adinuya luveyalilina bwatadi manamanawe-moena ina osedi e ada kaliva ina veitadi evona vaita Yaubada wagaine ioduodu velemoena. ");
INSERT INTO bwd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nuwanuwadi lakaina kanibutu lakaidi wagaidiya ina vetovetoga ebavetoga-dina isedi kaliva wa adivemoimoina faidiya, ada kaduwe manuwa ebavewala wagaidiya ina vetovetoga fafali-dina kaikaiwabudi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kai maketi wagaine inanau, aga nuwanuwadi lakaina kaliva wa yadi vemoimoina ina vesiuleyedi ke ina vewagadi ‘labai’. ");
INSERT INTO bwd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Aku imiyavo ani keke wana awaega ke ina vewagami ‘labai’. Faina yami tovewala anakaibe-mowa, ada moyaimi tubuiyamiyavo nodi amiitaita seya-moena. ");
INSERT INTO bwd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ada kaduwe babi taidei wagaine keke seyana gaito wana awavetamane, faina Banae Tamami anakaibe-mowa ani gabameya. ");
INSERT INTO bwd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kaduwe keke wana awaege ina awavetonagonayemi, faina amiTonagona anakaibe-mowa Banae Keliso. ");
INSERT INTO bwd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gavakaliva wagaimiya gina vetonagona, aga banae gilubodana wagaimiya gina vetogugai-mowa. ");
INSERT INTO bwd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Badi gavega taudiyavo ina kilakaidi ani Yaubada gina kiobuyedi, aku badi gavega taudiyavo ina kiobuyedi, badi Yaubada gina kilakaidi.” ");
INSERT INTO bwd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Imi veimeya anatovewalayavo ke Falisiyavo, imi meyalagalaga ani vita lakaina wana nuwagana! Faina imi taumiyavo keke wanaluku Yaubada yana ebaveimeya wagaine, ada kaduwe yami vewala fwaya wagaine kaliva waawatadi ada keke inaluku. Gavana wagugai ani anafaiweya vaita kali anawana wafalifalina, e ada badi gavega nuwanuwadi inaluku wagaine ani keke adifaiweya.  ");
INSERT INTO bwd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Oiyoi imi veimeya anatovewalayavo ada Falisiyavo! Imi meyalugaluga ani vita lakaina wana nuwagana! Faina tova ke tova waveoveola-faila e ada kaliva wana veitadi ke ina kaiyemi, aku kaduwe sikwasikwayavo yadi manuwa ke yadi lokoloko wavai-kavovodi. Taidei faina amimatavuloga ani koyo-moena. ");
INSERT INTO bwd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Oiyoi imi veimeya anatovewalayavo ada Falisiyavo, imi meyalagalaga! Vita lakaina wana nuwagana! Keke kanavona! Imi waawakawaka ada wanaunau atuwadeya leyaga tabone ke avaleya, e ada vaita kaliva seyana wanavai wana kivenuwavilana ke gina vetonogala wagaimiya. Ada tova-nai yami dewa-nai koyona wana vewalena, ayo banae gina dewayena ani koyo-moena. Imiyavo amilauboda matavuloga lakaina wana nuwagana eli anaai alalata wagaine, aku banae yami tonogala gikoyo-mowa, ani analauboda-mowa matavuloga lakai-moena gina nuwagana eli anaai alalata wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Imi tonagonayavo matami koyo-moena ani vita lakaina wana nuwagana! Faina wavona, ‘Kai gavakaliva gina vonadabadaba manuwa tabu anayeganeya, tainei keke tamo gavana. Aku kai gavakaliva gina vonadabadaba manuwa tabu anaveigavu gola wagaine, aga gilubodana yana vonadabadaba gina faisewana.’ Taidei anafaiweya wavona. ");
INSERT INTO bwd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Imi kwavakwavamiyavo matami koyo-moedi! Gavana lakaina velemoena, gola kai manuwa tabu? Manuwa tabu ani gikikivetabuna gola ada tainei ani gaitoma lakai-moena. ");
INSERT INTO bwd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kaduwe yami vewala wagaine wavona, ‘Kai gaito gina vonadabadaba ebavebolavoi anayeganeya, tainei keke tamo gavana. Aku kai gaito gina vonadabadaba vebolavoi anavelekavovo gimiyamiya ebavebolavoi tabone, tainei gaitoma lakaina, ada gilubodana yana vonadabadaba-nai gina faisewana.’ ");
INSERT INTO bwd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Imi kaliva matami koyo-moedi! Gavana lakai-moena, velekavovo o kai ebavebolavoi? Ebavebolavoi ani lakai-moena, ada gikikivetabuna velekavovo. ");
INSERT INTO bwd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Taidei faina gavakaliva kai gina vonadabadaba ebavebolavoi anayeganeya, wada kaduwe givonadabadaba gaitoma matatabuna wagaidiya ebavebolavoi-nai wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kaduwe gaito gina vonadabadaba manuwa tabu anayeganeya, kaduwe givonadabadaba Yaubada anayeganeya, Banae gimiyamiya manuwa tabu-nai negenine. ");
INSERT INTO bwd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ada kai kaliva nuwanuwana yana vona gina awavelemoena faina ginavona gabama anayeganeya, ani ina anafaiweya ginavona Yaubada yana veimeya anaebavetoga anayeganeya, ada kaduwe Banae Yaubada-moena givetovetoga wagaine anayeganeya. ");
INSERT INTO bwd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Imi veimeya anatovewalayavo ada Falisiyavo, imi meyalagalaga ani vita lakaina wana nuwagana! Faina veimeya lakai-moedi ani wavegaitoma-kavokavovoyedi. Veimeya-dina taidei anafaiweya. Kaliva wa adivita ani wana veimeya tunutunugina faidiya. Kaliva wana nuwakalikaliyedi. Gavana wavona evona wanagana ani wana gugaiyena velemoena. E, taidei veimeya-dina wavegaitoma-kavokavovoyedi e aku veimeya kabisodi ani wamuliye-dewedewedi. E, veimeya-dina kabisodi anafaiweya aa adikivemagamaga-dina yogiyogi tulina tulina magadi lakaina wagaidiya, ani adibavagu wagaine wavutugedi adivutuga teni ada seyana waatuegena Yaubada faine. Taidei veimeya-dina gilubodami wada itaveyabidi, aku giluboda-moemi veimeya-dina lakaidi wada vemoimoinedi. ");
INSERT INTO bwd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Imi kaliva aditonagona, aku matami koyo-moedi. Veimeya adinuwanuwa keke vitana ani waitaitaveyabidi, aku veimeya lakaidi keke maita wada nuwenuwedi. Amibwaiya namosili giluku ani wavaiyavulena, aku kevakeva lakaina kameli anafaiweya keke wadaita e ani watonona. ");
INSERT INTO bwd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Imi veimeya anatovewalayavo ada Falisiyavo, imi meyalagalaga ani vita lakaina wana nuwagana! Wana itana, amivei ke nauwa domodi wakiveyegayeganedi aku negenidi keke wada ikolakola. Ada kadu anafaiweya imiyavo. Taumiyavo waseyegemonemi vaita imi vetavetabumiyavo, aku velemoena nuwainagenimi ani tova moyaina waamoumoula. Ada kaduwe gavanuwanuwa itaitaluvadiga giyegemona yami nuwenuweya, ani keke maita wada awata aku au wagugaiyena. ");
INSERT INTO bwd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Imi Falisiyavo matami koyo-moedi! Nagona vei ada nauwa negenina wana kiveyegayeganena, e ada au kadu domona gina yegayegana. ");
INSERT INTO bwd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Imi veimeya anatovewalayavo ada Falisiyavo, imi meyalagalaga ani vita lakaina wana nuwagana! Faina imiyavo vaita didikula kaliva iveigavudi anafaiweya. Getadiya adiita iwakadi ada yegayegadi, aku negenidiya toalika luludi ada lada givemagana. ");
INSERT INTO bwd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tainei anafaiweya imi amiita, vaita yegayegamiyavo kaliva matadiya aku nuwainagemiya ani vefwayafwaya gimiyamiya, ada tova moyaina veimeya moyaina waawaegegedi e ada wadewadewa koyona. ");
INSERT INTO bwd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Imi veimeya anatovewalayavo ada Falisiyavo, imi meyalagalaga ani vita lakaina wana nuwagana! Faina tova tuwaina falofitayavo ke kaliva yegayegadiyavo ialika, ani adididikula wagaidiya adiebanuwaududu wakidewedewedi ada waveiveigavudi, imi taumiyavo yami tubudelideliyavo badi iluvealikadi. ");
INSERT INTO bwd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ada wavonaga, ‘Kai ide nodi kadamiya yada tubudelideliyavo yadi toveya, aga aimo keke kada lemedi ke falofita kada luvealikadi.’ ");
INSERT INTO bwd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Taidei anafaiweya yami vona faina au, taumiyavo waawamogatalemi vaita falofita aditoluvealika ani yadi gabuyavo imiyavo. ");
INSERT INTO bwd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","E ada yami tubudelideliyavo yadi koyona ivebutuna ani imi wana luyabuna! ");
INSERT INTO bwd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Imi vaita mota anafaiweya! Ada imi mota natunavo, mota-nai koyo-moena giluluvealika. Gavaiyamu wanaga ke wanaota eli wagaine? Aimo keke amifaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Taidei faina wana nogalina. Falofita ke tonuwanuwa velemoedi ke veimeya anatovewalayavo gana imilidi wagaimiya, aku tufodi wana luvealikadi, tufodi wana kivebolagalagadi, ada tufodi yami manuwa ebavewala wagaidiya bulava wagaine wana lubibiwalidi ke kadu wana kiveuloulolonidi melala ke melala wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","E ada au badi gavega Yaubada yana kaliva yegayegadiyavo moyaidi iluvealikadi ani adimatavuloga ginaelai imi wagaimiya. Kaliva-nai toyegayegana anayegana Ebeli ani analuvealika wagaine givebutu, ada luvealika ginau anaetowava Belekaiya natuna Sekalaiya, banae manuwa tabu ada ebavebolavoi adimwatuguya waluvealikana. ");
INSERT INTO bwd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gavonemi velemoena, kaliva-dina adiluvealika fatana ani imi tova malinai anayooyavo wana nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O meYelusalema, meYelusalema, imi Yaubada yana falofitayavo waluvealikadi, ada badi yana valeya anatoaliya giimilidi wagaimiya ani kabaleya watutuvealikadi. Kamukamu natudiyavo ivagauwidi ke ofadiya ilukabubudi anafaiweya, tova bademowa gavaiyei nuwanuwaku gana vagauwimi seyana wagaine. Aku imi keke nuwanuwami. ");
INSERT INTO bwd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wana itana, Yaubada yami manuwa tabu gina segena ke taumiyavo gaga wanamiya. ");
INSERT INTO bwd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Faina gana vonemi, aimo keke wanaita-vagileku analaba wana vonaga, ‘Banae gielaelai KAUVEYA anayeganeya ani wa anaawanuwakabubu.’” ");
INSERT INTO bwd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ada Yeisu manuwa tabu wagaine giyegemona ginaunau, aku yana tonogalayavo ielai wagaine ke manuwa tabu anaiyogona iwaka-moena faina ina vewalena. ");
INSERT INTO bwd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aku Banae givonediga, “Taidei gaitoma-dina matatabuna waitaitadi, aku gavonemi velemoena, kabala-dina taidei aimo keke seyana ginatufo tabodiya inamiya, aku moyaina ina vetutuyaweyawelidi inaobu.” ");
INSERT INTO bwd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ada Yeisu ginau Oya Olive gilaka givetogana ada yana tonogalayavo ielai wagaine, ada adiloi gaga aku itolidadanena, ivonaga, “Uda vonema, gaitoma-dina taidei uvonayedi ani gavatova wagaine ina yegemona? Ada ya yewa-vagila faina ke tova anaebalauyabu faina, ani gavana gina veiyaiyaya tova-nai taidei gaitoma-dina ina yegemona?” ");
INSERT INTO bwd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeisu gilufata, givona, “Wana itaveyabimi ada keke seyana gaito yana vefwayafwaya wagaine gina sibalemi. ");
INSERT INTO bwd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Faina aimo kaliva moyaidi akuyeganeya inaelai ina vonaga, ‘Iya game-nai tauku Mesaiya!’ Ada yadi fwaya-nai wagaine kaliva moyaidi ina vuyoyedi. ");
INSERT INTO bwd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kaduwe gaviya lakaidi valeyadi wana nogalina lilivamiya ke atuwadeya. Aku keke wana aseuloulolo, faina gilubodana gaitoma-dina taidei ina yegemona. Aku ebalauyabu anatova ani aimoina. ");
INSERT INTO bwd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Faina yoo seyana ina mididi ke mali yoo nodi ina lugaviya, ada kadu anafaiweya ebaveimeya seyana gina alakaidi ke mali ebaveimeya nodi ina lugaviya. Ada fafali tulina tulina wagaidiya loka ina yegemona kadu mabibi inamadu. ");
INSERT INTO bwd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aku gaitoma-dina taidei ani tova vitana anaebavevuvu-mowa, vaita vavine waifugana gina vefaena yana venatuna anauloulolo anafaiweya. Au aimo tova vitana kadu ielaelai. ");
INSERT INTO bwd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","E ada kaliva ina kiveyabimi ke ina kiveuloulolonimi ke ina luvealikami, ada babi anakaliva adiyoo moyaidi ina agougemi faina imi yaku tonogalayavo. ");
INSERT INTO bwd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tayuwe tova-dina kaliva moyaidi yadi vetumagana ina segena, ada seyana seyana taudiyavo tubuiyadiyavo ina agougedi ada ina atuegedi toveimeya wagaidiya adimatavuloga faina. ");
INSERT INTO bwd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ada kaduwe kaliva moyaidi inaelai ada inavona evona badi falofita velemoena, aku badiyavo falofita fwayafwaya. Ada kaliva moyaidi ina vuyoyedi yadi fwaya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ada tova moyaina veimeya moyaina kaliva ina awaegegedi ke koyona gina veinala-mowa faina, moyaidi yadi nuwakabubu gina avaina. ");
INSERT INTO bwd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aku badi gavega ina atuvefaila-vagata yadi vetumagana wagaine ke Yaubada ina labina analaba yawaidi anaebalauyabu wagaine, Banae gina kibababaledi. ");
INSERT INTO bwd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aku nagona ani babi matatabuna wagaine Yaubada yana ebaveimeya anavaleya iwakana taidei ina lumamalena e ada babi anakaliva adiyoo moyaidi ina nogalina, ada muliya ebalauyabu gina yegemona.” ");
INSERT INTO bwd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kaduwe givonaga, “Aimoina gaitoma koyo-moena bwanebwanenena Yaubada matane, ani wana itana gina midimididi Tutulagolota-nai Tabutabuna Yaubada yana manuwa tabu negenine. Tuwai-moena falofita Daniela gimaduvonayena anafaiweya ani gina yegemona. E, imi gavega vona taidei wana veyawana ani nuwami gida malina. ");
INSERT INTO bwd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Gaitoma koyo-moena kaliva ina itana wagaine, badi gavega Yudiya anafafali wagaine ina miyamiya ani gilubodadi inaota inalaka oya wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aku badi gavega yadi manuwa getane ani idaobu aku keke idaluku yadi manuweya yadi lokoloko idavai. ");
INSERT INTO bwd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ada kai badi gavega yadi bakuleya ina miyamiya aga keke idayewa melaleya adinuya badobadona idavai. Au ida maduota. ");
INSERT INTO bwd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ada kaduwe ota anatova wagaine, ani vevine waifugadiyavo ke vevine tovesusu ina venuwakalikali velemoena, faina keke adifaiweya ina maduota. ");
INSERT INTO bwd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","E ada wana veoveola ke tova iwakana Yaubada gina velemi yami tova ota wagaine, aku keke tulutulu anatoveya, kai Sabate wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Faina tayuwe tova-nai vita lakai-moena gina yegemona. Tainei vita-nai ani keke seyana anafaiweya gida miyami tova-nai Yaubada givebutu gaitoma matatabuna gibubudi ada gielai malinai. Kaduwe, keke aimo gina yegemona-vagila anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Vita tainei ani kai Yaubada keke anatova gida kivemaufo, aga kaliva matatabuna idakwa. Aku Banae yana kaliva venuvenuwadadanidiyavo ani badi faidiya tayuwe tova-nai gina kivemaufona. ");
INSERT INTO bwd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tayuwe tova-nai wagaine kai tamo gaito gina vonemi, ‘Wanaela wana itana, Mesaiya Tauna idauwe!’ o kai ginavona, ‘Wana itana, Banae tayuwe!’ aga keke yana vona-nai wana vetumagane. ");
INSERT INTO bwd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Faina mesaiya fwayafwaya ke falofita fwayafwaya aimo ina yegeyegemona ada iyaiyaya lakaidi ke gugai ebameyasidobodobo ina faifaisewadi, ke vaita Yaubada yana kaliva venuvenuwadadanidi ina vuyoyedi, kai anafata. ");
INSERT INTO bwd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wana nogalina, gaitoma taidei faidiya gavonamatawe-vagaimi. ");
INSERT INTO bwd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Taidei faina kai tamo gaito gina vonemi, ginavona, ‘Wana itana, tayuwe walaiya Mesaiya Tauna gimiyamiya,’ keke wanana walaiya. O kai ginavona, ‘Banae taidei vetawaneya gimiyamiya,’ aga keke wana vetumagane. ");
INSERT INTO bwd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Atunama gina atunama wayavalaseya-deya ada mwatugu matatabuna ginamali-yabuna ada ginanau wabolimaneya, e ada kaliva moyaidi ina itana. Ada kadu anafaiweya Banae Kaliva Natuna yana yewa-vagila, ani moyaidi ina itana. ");
INSERT INTO bwd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gadedeku kevakeva alialikana wagaine, wadedeku bwayobwayo ina vagauta. ");
INSERT INTO bwd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Aku tova vitana muline au kauwana gina yuyuvana ke kaduwe vaikoi yana malina ginaweu. Ailabama mwatuguya inabeu, kaduwe gabameya gaitoma toyogidi ina aliuliudi. ");
INSERT INTO bwd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","E ada Banae Kaliva Natuna yana ela anaiyaiyaya gina yegemona mwatugu wagaine, ada tomiyababi adiyoo tulina tulina matatabudi ina itana e ada inatagi-nuwanuwai. Ada Banae gabama anabuibui tabodiya ina itana, gina elaelai wa yana toyogina ke wa yana iwakana mamalina lakaina nodi. ");
INSERT INTO bwd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ada tova-nai wagaine, kaula ina yuvena bonana lakaina, ada yana aneloseyavo gina imilidi inanau babi matatabuna wagaine, ke yana yoo venuvenuwadadanidiyavo ina vagauwidi. Fafali tulina tulina wabolimaneya, wayavalaseya, walaubeuya, waoyeya, ina vagauwidi. ");
INSERT INTO bwd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Wana itana ai alaa ada wana nuwenuwena. Kai alaa lukuna bademowa gina mavuna ada kabuna evaguna gina kabukabu, tainei wagaine wana alamanena vaita bademowa ginaginana lakaina yana tova givelilivana ke kauwana toyogina gina vebutu. ");
INSERT INTO bwd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","E ada kaduwe anafaiweya, tova-nai wana itadi iyaiyaya-dina moyaidi ina yegeyegemona, aga wana alamanena vaita Banae Kaliva Natuna yana yewa-vagila anatova bademowa gilugavogavona. ");
INSERT INTO bwd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gavonemi velemoena, tova malinai anayooyavo ani keke ina alika-yabu aku taidei gaitoma-dina matatabuna inamadu yegemona. ");
INSERT INTO bwd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Gabama ke babi gina avaidi aku yaku vona keke maita ginaavai, au ginamiya-vagata. ");
INSERT INTO bwd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Aku yadayada-nai kai kauwana anabai ani keke seyana gaito gida alamane. Badi aneloseyavo gabameya keke ida alamane, kaduwe Banae Kaliva Natuna Tauna keke gida alamane, aku Tamana anakaibe-mowa gialamanena. ");
INSERT INTO bwd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tuwaina Nowa yana toveya kaliva ke vevine idewadewa anafaiweya, ada kaduwe Banae Kaliva Natuna yana yewa anatova anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Faina yadayada-dina wagaidiya muliya-yo mala gituwa aku kaliva imiyabavubavu-mowa. Aa ikanikani, iyugayuga, ada inaginagi ke ivevenagi analaba yadayada-nai Nowa giyage aki wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ada au wa yadi yavuyoga imiyamiya ani wayagata lakaina gielai, ada matatabuna gituwaafufudi. E ada kadu anafaiweya Banae Kaliva Natuna yana yewa wagaine gina yegemona. Badi keke tovetumagana ani yadi nuwanuwa evona vaita keke seyana gavana gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tova-nai wagaine kaliva adiselu bakula wagaine ina faifaisewa aku seyana ina nauwena, seyana ginamiya. ");
INSERT INTO bwd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kaduwe vevine adiselu aa ina auaulana ani anafaiweya, seyana ina nauwena aku seyana ginamiya. ");
INSERT INTO bwd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tainei faina wana itaita, faina keke wada alamane gavayadayada wagaine yami Kauveya ginayewa-vagila. ");
INSERT INTO bwd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aku taidei wana alamanena. Kai toni manuwa gida alamanena gavakauwana bogi wagaine tokiyafu gidaelai, aga gida itaitaboda ke tokiyafu keke gida iyawela gidaluku yana manuweya. ");
INSERT INTO bwd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","E ada imi kaduwe anafaiweya, tova moyaina wana itaveyabimi ke wana veitabodaboda, faina gavakauwana keke wada veitabodaboda wagaine ani Banae Kaliva Natuna ginayewa-vagilena.” ");
INSERT INTO bwd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Gava togugai ani banae wa anavetumagana ada kadu tonuwanuwa velemoena? Banae togugai-nai ani yana kauveya gina venuwadadanena ke yana togugaiyavo ani gina itaitaveyabidi, ada adiga gina veleveledi aditova velemoena wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kai yana kauveya ginayewa-vagila ada gina itanuwagana gigugugai ani giveimeyena anafaiweya, aga banae togugai-nai gina vemwamwala. ");
INSERT INTO bwd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gavonemi velemoena, togugai-nai ani yana kauveya ginasena ke yana giba matatabuna gina itaveyabidi. ");
INSERT INTO bwd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aku kai banae togugai ani kaliva koyona, aga nuwainagene ginavona, ‘Ida yaku kauveya givekwalu lakaina. Kai keke gina maduela.’ ");
INSERT INTO bwd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","E ada gina vebutu tubuiyanavo togugaiyavo gina lavulavudi, ada badi iyuga kwavakwava ani nodi ina kanikani ke ina yugayuga. ");
INSERT INTO bwd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","E aku yadayada-nai togugai keke gida itaitaboda wagaine, ani yana kauveya gina yewana ada togugai gina veyaulovogina, faina keke gida alamane yadayada-nai o kai gavakauwana anabai wagaine ginayewa. ");
INSERT INTO bwd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ada yana kauveya gina nuwagana ke gina lumalimaliwavuna, ada ginasena badi meyalagalaga adimatavuloga anafafali wagaine. Wadedeku-deya nodi ina tagitagiya lakaina ke nigodi ina vekudaligoligota uloulolo lakaina faina.” ");
INSERT INTO bwd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Aku kaduwe Yeisu yana yewa-vagila faina givona matalivulivuna-vagila, givona, “Tayuwe tova-nai wagaine Yaubada yana ebaveimeya ani taidei anafaiweya. Akeakedu aditeni imiyamiya aku yadi mayale ivaidi ada itauya inau, tonagi kaliva yana vavine tamana yana manuweya gina vagaulena ani ina bodana. ");
INSERT INTO bwd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ada vevine adifaifi ani kwavakwavadiyavo, aku kadu adifaifi ani tonuwanuwa velemoedi. ");
INSERT INTO bwd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Badi kwavakwavadiyavo yadi mayale inauwedi aku keke mayale anagufa idavai. ");
INSERT INTO bwd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aku tonuwanuwa velemoedi ani yadi mayale ivaidi kaduwe gufa anavetutamwata wa tuwavina ivaina. ");
INSERT INTO bwd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tonagi kaliva givekwalu lakaina faina, vevine iboda-deeya, matadi gineganega ada au ienowavulu. ");
INSERT INTO bwd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Idaudau aku boginafa kaliva ivedovedou ivona, ‘Tonagi kaliva giyegemona! Wanaela wana madubodebodena.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ada akeakedu imididi yadi mayale adiwiki ikidewedewedi. ");
INSERT INTO bwd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Badi kwavakwavadiyavo tubuiyadiyavo tonuwanuwa velemoedi ivonedi, ivona, ‘Maita gufa wada velema, faina yama mayale giweuweu.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Aku tonuwanuwa velemoedi ilufata, ivona, ‘Ida keke anafata moyaida faideya. Wananau sitowa wagaine yami gufa wana kimonena.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ada badi itauya inaunau yadi gufa ina kimonena aku tonagi kaliva giyegemona, ada badi akeakedu-dina bade ikidewadewa, ani nodi iluku nagi anakani vemwamwala wagaine. Ada wana ifalina. ");
INSERT INTO bwd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aku aimo vevine adifaifi-dina keke yadi mayale anagufa ida maduvai, ani iyewadi ielai ada ivedou, ‘Kauveya, Kauveya, wana una yavuna. Ime aelai.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Aku bana givona, ‘Gavonemi velemoena, keke gada alamanemi.’” ");
INSERT INTO bwd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ada Yeisu yana vona giluyabuna, givona, “Taidei faina wana veitabodaboda, faina Bana Kaliva Natuna yana yewa-vagila anatova o kai anakauwana keke wada alamane.” ");
INSERT INTO bwd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kaduwe Yeisu givona matalivulivuna-vagila givona, “Yaubada yana ebaveimeya ani taidei anafaiweya. Kaliva lakaina seyana ginanau mali fafali wagaine faina, yana togugaiyavo gidouwedi ielai ada wa yana vetumagana yana lokoloko gisena nimadiya ke ina vegugaiye gina tubuga. ");
INSERT INTO bwd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Giveledi gavaiyamu togugai seyana seyana yana alamana anaetowava wagaine ina vegugaiyena. Kaliva seyana faifi tausani kina (K5,000) givelena, kaliva seyana tu tausani kina (K2,000) givelena, ada seyana givelena wani tausani kina (K1,000). Ada muliya gitauya ginau. ");
INSERT INTO bwd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ada togugai-nai banae givelena faifi tausani kina, ani maduga-mowa ginau ada gikimone ke kaduwe givekimone-vagiledi, e ada yana vetutamwata faifi tausani kina ginuwagana kaduwe. ");
INSERT INTO bwd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tainei anafaiweya togugai anavelu tu tausani kina (K2,000) givelena, ani givefaisewana wagaine kaduwe tu tausani kina givetutamwaina. ");
INSERT INTO bwd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aku togugai banae wani tausani kina (K1,000) givelena, ani ginau olu giyalana ada yana kauveya yana mani gikumulina. ");
INSERT INTO bwd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Imiyamiya tova manamanawena aku badi togugai-dina yadi kauveya giyewa gielai, ada gidouwedi ielai ke yadi faisewa mani wagaine ani nodi ina kivetuvetunugina. ");
INSERT INTO bwd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ada togugai banae faifi tausani kina (K5,000) givelena, ani kaduwe yana vetutamwata faifi tausani kina nodi gialiyena ada givona, ‘Kauveya, uveleku faifi tausani kina aku una itana, yaku vetutamwata kaduwe faifi tausani kina ganuwagana.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Yana kauveya givonaga, ‘O togugai iwaka! Wa ya idibumwaiga yaku nuwanuwa umuliyena, ada gaitoma kabisodi aku ufaisewa-dewedewena. Taidei faina gugai moyaina ke lakaidi nimaniya ganasedi. Oye unaelai Iya nodi kana vemwamwala.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kadu togugai banae tu tausani kina (K2,000) givelena, ani gielai givonaga, ‘Kauveya, uveleku tu tausani kina aku una itana, yaku vetutamwata kaduwe tu tausani kina ganuwagana.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Yana kauveya givona, ‘O togugai iwaka! Wa ya idibumwaiga yaku nuwanuwa umuliyena, ada gaitoma kabisodi aku ufaisewa-dewedewena. Taidei faina gugai moyaina ke lakaidi nimaniya ganasedi. Oye unaelai Iya nodi kana vemwamwala.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ada togugai banae wani tausani kina (K1,000) givelena ani gielai givonaga, ‘Kauveya, bademowa gaalamanena o ya veimeya toyogina, kaduwe keke waifei uda bakubakula aku uiyaiyala-kavovo, ada keke uda faifaisewa aku aa uveiveiva-kavovo. ");
INSERT INTO bwd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tainei faina gamatauta, e ada ganau ya mani babi negenine gasewavuyena. Ada una itana, ya mani taidei.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ada yana kauveya givona, ‘O togugai koyo ada dibusoyogina. O uvona ani ualamaneku Iya keke gada bakubakula aku gaiyaiyala-kavovo, kaduwe keke gada faifaisewa aku gaveiveiva-kavovo. ");
INSERT INTO bwd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","E ada udanau yaku mani udasena banika wagaine, ada gada yewaku wagaine gada vaina wa anavetutamwata nodi.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","E ada yana kauveya givona badi yana togugaiyavo velugadiyavo wagaidiya, givona, ‘Yaku mani wani tausani kina (K1,000) gavelena ani wana vaiyewena, ada kaliva-nai banae yaku mani teni tausani kina wagaine gimiyamiya, ani banae wana velena. ");
INSERT INTO bwd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Faina badi gavega adivutuvutuga ivefaisewana ke ivetutamwaina, aga adivetutamwata kaduwe ina nuwagana e ada gina tubuga-mowa. Aku gavega adivutuvutuga keke ida vefaisewa ke ida vetutamwai, aga gavana kabisona gimiyamiya wagaidiya ani ina vaiyegena wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ada tainei togugai koyona wana seyegemonena wamelaleya ke yuyuvaneya gina miyamiya, wadedeku-deya kaliva adiuloulolo lakaina faina ina tagitagiya ke nigodi ina vekudaligoligota.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Aimo Banae Kaliva Natuna ginayewa-vagilena wa yana iwakana mamalina, ada aneloseyavo nodi inaelai, ada tova-nai wagaine gina vetogana yana veimeya anaebavetoga kaikaiwabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ada babi anakaliva adiyoo moyaidi ina vagauta Bana matane, ada gina ludakadi anafaiweya toitaveyabina yana kevakevayavo giluludakadi ke sifi tulina kadu goti tulina. ");
INSERT INTO bwd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ada sifi ginasedi aiyatagine aku goti ginasedi aimauline. ");
INSERT INTO bwd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ada Banae Kini ginavona badi aiyatagine imiyamiya wagaidiya, ginavona, ‘Imi Kamaku giawanuwakabubuyemi ani wanaelai wanaluku yana ebaveimeya wagaine, taidei ebaveimeya-nai gikidewedewe-vagaina faimiya tuwaina babi anaibubuna vaguvagu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Faina mafa gilavuku aku aa waveleku, ada meyaku gikwakwa aku gufa waveleku, kaduwe Iya kwana mamataga aku wavagauleku yami manuweya walukuweku. ");
INSERT INTO bwd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ada akunuya keke ani nuya waveleku, kadu gaveoga aku waitaveyabiku, ada deli wagaine gamiyamiya aku waelai wamadubodaku.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ada badi kaliva yegayegadiyavo ina vonaga, ‘Kauveya, gavatova aitani mafa gilavuni ada avekanini, o kai meya gikwakwa ada gufa aveleni uyuga? ");
INSERT INTO bwd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ada gavatova o aitani kwana mamataga ada asivaivaini uluku yama manuweya, o kai anuya keke ada nuya aveleni? ");
INSERT INTO bwd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gavatova aitani uveoga o kai deliya uluku aku aela amadubodani?’ ");
INSERT INTO bwd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ada Banae Kini gina lufata, ‘Gavona velemoena, gavana wagana seyana tubuiyakuweyavo wagaidiya banae anayegana keke lakaina, ina kadu anafaiweya wagugaiyena Iya wagaikuya.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Aku badi aimauline imiyamiya ani gina vonediga, ‘Imi wana segeku wananau, imi Yaubada gialatabutabuyemi. Wananau wanaluku ai alalata-vagata wagaine Yaubada gikidewedewe-vagaina Seitani yana aneloseyavo nodi faidiya. ");
INSERT INTO bwd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Faina mafa gilavuku aku keke aa wada veleku, kaduwe meyaku gikwakwa aku keke gufa wada veleku. ");
INSERT INTO bwd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Iya kwana mamataga aku keke wada sivaivaiku yami manuweya. Ada akunuya keke aku nuya keke wada veleku. Ada gaveoga kadu deli wagaine gamiyamiya aku keke wada madubodaku.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Taidei anafaiweya gina vonedi, aku badi ina vonaga, ‘Kauveya, gavatova aitani mafa gilavuni, o meya gikwakwa, o oye kwana mamataga, o anuya keke, o uveoga, o kai deli wagaine umiyami aku keke ada lemeni?’ ");
INSERT INTO bwd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ada banae gina vonedi, ‘Gavonemi velemoena, kaliva keke wa anayegana ani tova-nai keke udaleme, ina kadu anafaiweya keke wada gugaiye Iya wagaikuya.’ ");
INSERT INTO bwd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ada badi inanau matavuloga-vagata anafafali wagaine, aku badi yegayegadiyavo inanau yawai-vagata anafafali wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ada Yeisu gaitoma taidei moyaina givewala giavaina, yana tonogalayavo wagaidiya givonaga, ");
INSERT INTO bwd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Waalamanena yadayada iluwei kana segedi aku Nugulina Abutuna gina yegemona, ada Banae Kaliva Natuna ina atuegena kaliva nimadiya ke ina kivebolagalagana.” ");
INSERT INTO bwd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aku veyavo anatovegugai lakaidiyavo kaduwe meIsileli yadi kaliva lakaidiyavo ani ivagauta veyavo anatovegugai aditonagona yana manuweya, banae anayegana Kaiyafasi. ");
INSERT INTO bwd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ada tonagona-dina iveimeya evona Yeisu ina kiveyabina ikavuya-deya ke ina luvealikana. ");
INSERT INTO bwd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aku ivona, “Keke Abutu anatova wagaine kana kiveyabi, faina kaliva ina nuwakoyoyeda ke gaviya ina silakaina.” ");
INSERT INTO bwd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ada Yeisu ginau Bedani melala wagaine gimiyamiya Saimoni yana manuweya. Banae tuwaina givelefelo aku bade giveiwaka, e aku aimo ivewagana Saimoni tolefelo. ");
INSERT INTO bwd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ada imiyamiya ani vavine seyana gielai Yeisu wagaine ada bunama magana iwaka-moena gialiyena, fatana lakaina. Anatuwava kabala anayegana alabasita. Ada Yeisu teibeli lilivane gienokekela gikanikani aku kuluwana wagaine vavine-nai bunama giiwana. ");
INSERT INTO bwd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aku yana tonogalayavo iitana ada inuwakoyo ivona, “Ee! Gavana faina taidei anafaiweya givenuwaegege? ");
INSERT INTO bwd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kai bunama taidei kada vekimonena aga mani lakaina kadavai tofanifani kada veledi.” ");
INSERT INTO bwd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Aku Yeisu yadi nuwanuwa gialamanena e ada givonedi, givona, “Gavaiyamu-yo vita wavele vavine-nai? Gavana gigana wagaikuya ani iwakana velemoena. ");
INSERT INTO bwd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Fanifani tova moyaina wagaimiya imiyamiya, aku Iyayeku ani aimo keke tova moyaina nodi kana miyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bunama taidei giiwavekelolona vovokuya ke gikidewedewe-vagaiku akuibo didikuleya faina. ");
INSERT INTO bwd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gavonemi velemoena, gadedeku babi matatabuna wagaine valeya iwakana ina lumamalena, kaduwe vavine taidei yana gugai iwaka-vagaina wagaikuya ina ifufuyena anaebanuwaududu faina.” ");
INSERT INTO bwd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","E ayo tonogala adituwelo wagaidiya kaliva seyana anayegana Yudasa Isakaliyota. Ani banae ginau veyavo anatovegugai lakaidiyavo wagaidiya ");
INSERT INTO bwd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","gitolidadana givona, “Kai Yeisu ganasena nimamiya, aga gavana wada veleku?” Ada au mani siliva anayoo teti (30) ivelena. ");
INSERT INTO bwd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ada tayuwe tova-nai wagaine Yudasa givebutu gilelele tova iwakana ke Yeisu gina ivemogatalina meIsileli tonagonayavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Abutu-nai anayegana Beledi Keke wa anaYisti giyegemo, ada anayadayada nagona wagaine tonogalayavo ielai Yeisu wagaine, ivona, “Gadedeku nuwanuwa Nugulina aana ana kidewadewa ke kanakani?” ");
INSERT INTO bwd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Givonedi, “Wananau Yelusalema ada kaliva seyana wana itana, ada wana vonena wanavona, ‘Tovewala givona, Yaku tova bademowa givelilivana. Iya nuwanuwaku ya manuweya yaku tonogalayavo nodi anaela Nugulina aana anakani.’” ");
INSERT INTO bwd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ada tonogalayavo Yeisu giveimeyedi anafaiweya inau ke Nugulina aana ikidewedewena. ");
INSERT INTO bwd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mala gibogi Yeisu yana tonogalayavo adituwelo nodi ienokekela inakani. ");
INSERT INTO bwd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ada ikanikani aku Yeisu givona, “Vona velemoena, gavona wagaimiya, kaliva seyana wagaimiya gina ivemogataliku nibaikuweyavo wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ada inuwavita lakaina ke seyana seyana itolidadanena, ivona, “Kauveya, kai Iyayeku?” ");
INSERT INTO bwd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeisu givona, “Kaliva-nai Iya nodi nauwa wagaine beledi anaituvina, ani banae gina ivemogataliku nibaikuweyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Banae Kaliva Natuna gina alika Yaubada yana vona vetovetokilumina givonayena anafaiweya, aku kaliva-nai gina ivemogatalina nibainavo wagaidiya, ani aimo vita lakai-moena gina nuwagana! Kai keke gida tubuga, ina iwaka-moena.” ");
INSERT INTO bwd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ada Yudasa banae gina ivemogatalina nibainavo wagaidiya givonaga, “Labai, kai Iyayeku?” Yeisu givona, “Inogame-nai uvona.” ");
INSERT INTO bwd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ada ikanikani aku Yeisu beledi givaina ke Yaubada wagaine givona vesiule ada gikiinena ke yana tonogalayavo giveledi, givona, “Wanavai wana kanina. Taidei vovoku.” ");
INSERT INTO bwd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ada kaduwe waini wa veina givaina ke givona vesiule Yaubada wagaine ada giveledi, givona, “Moyaimi wanayuga wagaine, ");
INSERT INTO bwd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","faina taidei ani dayagiku, ida dayaga-nai Yaubada yana veyavo anawai faina. Gimadumadu tomiyababi moyaidi faidiya e ada yadi koyona Yaubada gina venuwaegedi. ");
INSERT INTO bwd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gavonemi, keke kaduwe waini ganayu-vagile analaba yadayada-nai wagaine Iya imi nodi waini evaguna kanayuna Kamaku yana ebaveimeya wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ada kweli davadava ikweliyena. Ada ikweli giavaina, ina ilaka Oya Olive wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ada Yeisu givonedi, givona, “Bogibogi taidei moyaimi yami vetumagana wagaikuya gina kabekabebena ke wanaota-yabuyabuku. Faina Yaubada yana vona seyana ivetokilumina givona, ‘Sifi aditoitaveyabina gana mununa ada sifi wauma ina awalanau.’ ");
INSERT INTO bwd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aku ganayawa-vagila muline, wai gana nagona Galili, ada wadedeku-deya imi wanaela gana itami.” ");
INSERT INTO bwd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ada Pita gilufata, givonaga, “Kai badi moyaidi inaota-yabuyabuni aku Iya au keke-mowa!” ");
INSERT INTO bwd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeisu givonaga, “Gavona velemoena wagainiya, bogibogi taidei kamukamu keke gina kwage aku nagona unamadu veweyeku tova toiye vaita keke uda alamaneku.” ");
INSERT INTO bwd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita givona, “Kai O ina luvealikani aga Iya nodi ina luvealikada. Keke-mowa gana veweyeni!” Ada tonogalayavo moyaidi kaduwe ivona anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ada Yeisu yana tonogalayavo nodi inau fafali seyana anayegana Gedesemani wagaine, ada givonedi, givona, “Idedeku wana vetoga aku gananau tayuwe gana veoveola.” ");
INSERT INTO bwd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ada Pita ke Sebedi natunavo adiselu givaidi nodi inau. Aku Yeisu givebutu giaseuloulolo ke ginuwavita lakaina, ");
INSERT INTO bwd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ada givonedi, givona, “Nuwaku givita lakaina vaita yawaiku gida alagoloi. Idedeku wana miyamiya aku wana itaita.” ");
INSERT INTO bwd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ada ginau maita-moena ada wamagigine givetalatala babi wagaine ke giveoveola, givona, “O Kamaku, kai ya nuwanuwa anafaiweya, aga uloulolo anavei taidei uda vaiyegena wagaikuya. Aku keke yaku nuwanuwa, au Oyeni ya nuwanuwa anafaiweya una gugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ada giyewana yana tonogalayavo aditoto giitadi idaudau, ada givona Pita wagaine, givonaga, “Gavaiyamu, keke amifaiweya kauwana anabai seya-moena wana atuvefaila ke wana itaita? ");
INSERT INTO bwd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wana itaita ke wana veoveola e ada keke aladibidibi wagaine wanabe. Aluwaluwami nuwanuwana aku vovomi gikabekabebena.” ");
INSERT INTO bwd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kaduwe tova anavelu ginau giveoveola-vagila, givona, “O Kamaku, kai keke analauboda taidei uloulolo anavei unamadu vaiyavule aku nagona gana yugena, aga ya nuwanuwa anafaiweya una gugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Giveoveola giavaina, kaduwe giyewana ani giitadi idaudau, faina badi matadi gikoyo-mowa. ");
INSERT INTO bwd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ada au gisegedi kaduwe ginau giveoveola tova anaveto bademowa giveola anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ada kaduwe giyewana yana tonogalayavo wagaidiya givonedi, givona, “Gavaiyamu, aimo wadaudau ada waveyaveyawai? Wana itana, bademowa tova giyegemona ke Banae Kaliva Natuna ina atuegena tokoyona nimadiya. ");
INSERT INTO bwd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wana mididi kananau. Waitana, kaliva-nai ginaseku nibaikuweyavo nimadiya ani giyegemona bademowa!” ");
INSERT INTO bwd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ada Yeisu aimo giifuifufu ani Yudasa giyegemona, banae tonogala seyana adituwelo wagaidiya. Ada kaduwe yoo lakaina nodi ielai ani wa yadi benisi ke feto, badi kaliva-dina ani veyavo anatovegugai lakaidiyavo ke meIsileli yadi kaliva lakaidiyavo iimilidi ielai. ");
INSERT INTO bwd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aku Yudasa bademowa yoo iyaiyaya seyana gimaduveledi, givona, “Banae gaito gana veyaugina ani kaliva-nai. Wana kiveyabina.” ");
INSERT INTO bwd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","E ada gielai ke tunutunugina ginau Yeisu wagaine ada givona, “Labai, siule!” Ada giveyaugina. ");
INSERT INTO bwd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeisu givonena, givona, “Tubuiyaku, gavana ya nuwanuwa faina uelai ani una madugana.” Ada givonavona ani yoo ielai ikiveyabina. ");
INSERT INTO bwd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aku kaliva seyana Yeisu yana yoo wagaine ani yana benisi gisiwakana, ada veyavo anatovegugai aditonagona yana togugai gitalana ke tagana gitalayoe gibeu. ");
INSERT INTO bwd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aku Yeisu givonena, givona, “Ya benisi una seyewena anafoseya! Faina gavega ivemunumunuga ke kaliva imunumunudi ani vemunumunuga gina nuwagadi, e ada gina munudi ina alika. ");
INSERT INTO bwd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gavaiyamu, kai keke wada alamane Iya akufata gana veola Kamaku wagaine, ada maduga-mowa aneloseyavo gavaiyei tausani gina imilidi ina lemeku? ");
INSERT INTO bwd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aku kai tainei anafaiweya gada veola lema faina, aga gavaiyamu Yaubada yana vona guwana ginasei? Faina Buki Tabu wagaine gimaduvona anafaiweya, gilubodana gida yegemona velemoena wagaikuya.” ");
INSERT INTO bwd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ada tova-nai wagaine Yeisu yoo givonedi, givonaga, “Gavaiyamu, Iya vaita tobaninivula anafaiweya ada waelai wabenisimiyavo ke wafetomiyavo ada wana kiveyabiku? Yadayada seyana seyana manuwa tabu wagaine gavetovetoga ada gavevewala, aku keke wada kiveyabiku. ");
INSERT INTO bwd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aku ida gaitoma moyaina giyegemona e ada gavaiyamu tuwai-moena falofitayavo ivetokilumina Buki Tabu wagaine, ani gina yegemona velemoena.” Taidei anafaiweya givona ada tonogalayavo moyaidi iota-yabuyabuna. ");
INSERT INTO bwd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","E au kaliva-dina Yeisu ikiveyabina ani inauwena Kaiyafasi yana manuweya. Bana Kaiyafasi ani veyavo anatovegugai aditonagona. Ada veimeya anatovewalayavo kaduwe kaliva lakaidiyavo bademowa yana manuweya ivagauta ada imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aku Pita bana atuwadeya Yeisu gimuliye gielai, ani veyavo anatovegugai aditonagona yana manuwa anaebaga wagaine giluku. Ada gina givetoga manuwa tabu anafilisimaniyavo nodi, ke gavana inagana Yeisu wagaine ani gina itana. ");
INSERT INTO bwd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aku veyavo anatovegugai lakaidiyavo ke meIsileli yadi Kanisela anayoo matatabuna toveloi ileledi, e ada wagaidiya vaita Yeisu ina awavekoyoyena, ada yadi fwaya-nai wagaine vaita adifaiweya alika wagaine inasena. ");
INSERT INTO bwd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aku keke ida nuwaga. Toveloi moyaidi ilakaela iveloina, aku keke kaliva iluwei ida veaigaigabu yadi vona wagaidiya. Ada ilele ilele eee au kaliva adiselu imidiyegemona ");
INSERT INTO bwd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ke ivona, “Kaliva taidei givona, ‘Iya akufaiweya Yaubada yana manuwa tabu gana yawelina ada yadayada toiye wagaine kaduwe gana vemididi-vagilena.’” ");
INSERT INTO bwd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ada veyavo anatovegugai aditonagona gimididi aku Yeisu gitolidadanena, givona, “Gavaiyamu, keke afaiweya una lufata? Gavana faina kaliva taidei yadi awavekoyo fainiya keke udafata?” ");
INSERT INTO bwd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aku Yeisu giveyamata. Ada bana veyavo anatovegugai aditonagona Yeisu givonena, “Yaubada Tomiya-vagata anayeganeya gaveimeyeni, unavona velemoena wagaimeya. Gavaiyamu, velemoena Oyeni Mesaiya, Yaubada Natuna, o kai keke?” ");
INSERT INTO bwd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeisu givona, “Au uvona anafaiweya. Aku moyaimi gana vonemi, aimo tova gielaelai Banae Kaliva Natuna ani wana itana, gina vetoga gina miyamiya Yaubada Totoyogi-vagaina aiyatagine. Ada wana itana gabama anabuibui tabodiya gina elaelai.” ");
INSERT INTO bwd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yeisu taidei anafaiweya givona, e ada veyavo anatovegugai aditonagona-nai ginuwakoyo lakaina ke tauna ananuya gikelilina aku givona, “Aaaa! Taidei vona awadamana Yaubada wagaine! Waitana! Gavana faina toitavedama kaduwe aimo kana lelele? Bademowa yana vona awadamana wanogalina. ");
INSERT INTO bwd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Gavaiyamu wana veimeya?” Badi ivonaga, “Yaubada wagaine givona awadamana faina, analauboda gina alika!” ");
INSERT INTO bwd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ada Yeisu magigina ikiwalina ke itututuna. Ada tufodi itafina aku iawaveleigena, ivona, ");
INSERT INTO bwd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“O Mesaiya, una falofisai wagaimeya gaito gilavuni!” ");
INSERT INTO bwd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aku Pita aimo givetovetoga wamelaleya, tayuwe ebaga-nai wagaine aku togugai vavine gielai wagaine, givona, “Oyeni kaduwe Yeisu kwana Galili nodi wamiyamiya.” ");
INSERT INTO bwd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aku moyaidi matadiya givewa givonaga, “Iya keke gada alamane gavana uvonavonaye.” ");
INSERT INTO bwd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ada giyegemona ginau ebaga anaebaluku wagaine aku kadu togugai vavine seyana giitana, ada givona badi wadedeku wagaidiya, givona, “Kaliva taidei ani Yeisu kwana Nasaledi nodi imiyamiya.” ");
INSERT INTO bwd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kaduwe givewa-vagila givona, “Yaubada matane gavona velemoena, kaliva tainei ani Iya keke gada alamane.” ");
INSERT INTO bwd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ada tova kabisona tomididi-dina lilivane ielai Pita wagaine ivona, “Au velemoena oyeni seyana wagaidiya, faina bona-itu ananogala wagaine aalamanena.” ");
INSERT INTO bwd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","E au Pita givonaga, “Kai keke ganavona velemoena aga gilubodana Yaubada gina vematavulogiku. Aku ganavona velemoena, Bana Kaliva-nai ani keke gada alamane.” Ada anafaiweya givona ani kamukamu gikwage. ");
INSERT INTO bwd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ada au nuwana giamutuna Yeisu yana vona, “Kamukamu keke gina madukwage aku nagona unavewa tova toiye vaita keke uda alamaneku.” Ada Pita yana vewa-nai nuwana giafolena, e ada manuwa anaebaga wagaine-deya giyegemona wamelaleya ada wa yana nuwavita lakaina gitagiya toyogina. ");
INSERT INTO bwd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mala gilavuna malabutuya-mwaeya badi veyavo anatovegugai lakaidiyavo kaduwe kaliva lakaidiyavo moyaidi, ivagauta ada iveimeya evona Yeisu inasena alika wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ada Yeisu nimana iyogodi ke inauwe iatuegena Pailato wagaine, banae kwana Loma kabemali. ");
INSERT INTO bwd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aku Yudasa banae Yeisu gina atuegena nibainavo nimadiya ani giitana bade iawaegau ke ina luvealikana, ee wagaine nuwana givita lakaina yana gugai faina. Ada mani-nai teti givai gialiyena badi veyavo anatovegugai lakaidiyavo ke kaliva lakaidiyavo wagaidiya giveyewana. ");
INSERT INTO bwd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ada givonedi, givona, “Iya gakoyona, faina kaliva yegayegana keke tamo yana koyona ani gasena nimamiya ada gina alika.” Badi ivonaga, “Gavana tamo anavita ime wagaimeya? Ina tauni avita!” ");
INSERT INTO bwd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ada au mani siliva gisegelukuwedi manuwa tabu negenine aku gitauya ginau. Ada bulava wagaine odona gisifona ke tauna giluvekwaiyoyona ada agona gisifuwana. ");
INSERT INTO bwd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","E aku veyavo anatovegugai lakaidiyavo inau mani siliva ivaidi ada ivonaga, “Ida mani-nai ani kaliva gialika wagaine, e ada keke gida luboda kanadodo velekavovo anatutulagolota wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ada iveifuifufu ke iawaegau ada mani-nai wagaine wela anatoibubuna yana babi ikimonena evona wakawaka adididikula faina. ");
INSERT INTO bwd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Taidei faina babi-nai ivewagana ‘Dayaga anaBabi’, ada yegana-nai aimo tova taidei gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Taidei wagaine gavana falofita Iyelemaiya givonayena Keliso faine ani giyegemona velemoena, givona, “Ada badi mani siliva teti ivaina, tainei kaliva-nai fatana anafaiweya meIsileli isena, ");
INSERT INTO bwd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ada wagaine wela anatoibubuna yana babi ikimonena. Taidei anafaiweya KAUVEYA gikivetunutunugiku ina gugai.” ");
INSERT INTO bwd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aku Yeisu gimididi Pailato matane, banae toveimeya, ada toveimeya-nai gitolidadanena Yeisu, givona, “Gavaiyamu, velemoena Oyeni meIsileli yadi kini?” Yeisu givonaga, “Au uvona anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aku veyavo anatovegugai lakaidiyavo ke kaliva lakaidiyavo iawavekoyoyena, ani keke tamo gavana Yeisu gidavona. ");
INSERT INTO bwd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ada Pailato givonena, “Gavaiyamu, yadi awavekoyo wagainiya ani moyai-moena. Maita unoganogalina kai keke?” ");
INSERT INTO bwd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aku yadi awavekoyo faina, Yeisu keke tamo gida lufata. E ada Pailato meyana gisidobodobona. ");
INSERT INTO bwd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aku Nugulina Abutuna anatova seyana seyana wagaidiya, kabemali toveimeya yana dewa ani kaliva yogoyogona seyana deli wagaine gina etoyavuna, banae-nai faine yoo ina veolena. ");
INSERT INTO bwd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ada tayuwe tova-nai wagaine kaliva seyana yogoyogona gimiyamiya anayegana Balabasi, ani kaliva moyaidi ialamanena banae yana dewa koyo-moena. ");
INSERT INTO bwd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ada bademowa yoo ivagauta ada Pailato gitolidadanedi, givona, “Gavakaliva nuwanuwami gana etoyavu wagaimiya, Balabasi o kai Yeisu Banae ivewagana Mesaiya?” ");
INSERT INTO bwd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Faina gialamanena velemoena veyavo anatovegugai lakaidiyavo nuwanuwadi lakaina kaliva badi ina vemoimoinedi, aku iitanuwagana moyaidi ani Yeisu ivemoimoinena ke imulimuliyena, e ada agodi giuga Banae wagaine. Ada taide vuvuna-nai faine Yeisu ikiveyabi inauwena ada iatuegena Pailato wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aku Pailato aimo givetovetoga vevonayavuga anaivi wagaine, ani vavinena anamatawa iimilina gielai wagaine, ivonaga, “Gilubodana keke tamo gavana unagai kaliva tainei totunutunugina wagaine. Bogi wagaine banae kaliva-nai aavaisena ada auloulolo lakaina faine.” ");
INSERT INTO bwd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aku veyavo anatovegugai lakaidiyavo ada kaliva lakaidiyavo, ani yoo nuwadi ikanina ke Pailato ina veolena ada Balabasi gina etoyavuna aku Yeisu ginasena alika wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ada toveimeya gitolidadanedi, givonaga, “Kaliva taidei iluwei wagaidiya ani gavakaliva nuwanuwami gana etoyavu wagaimiya?” Badi ivona, “Balabasi!” ");
INSERT INTO bwd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ada Pailato givona, “Ada gavana ganagai Yeisu wagaine, banae ivewagana Mesaiya?” Aku moyaidi ivona, “Una kivebolagalagana!” ");
INSERT INTO bwd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ada kadu Pailato givona, “Gavana faina? Gavakoyona gigai?” Aku badi bonadi kaduwe gilaka-mowa, iagofaifaina ivona, “Una kivebolagalagana!” ");
INSERT INTO bwd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ada Pailato giitana keke anafata gavana ginagai, faina kaliva ilaka-mowa ada ialakalakaidi tova kabiso-moena ina manini. E ada yoo matadiya gufa givaina ke nimana gikolana ada givona, “Kaliva taidei analuvealika anavita ani Iya keke ganawai. Imi taumiyavo anavita wana waina.” ");
INSERT INTO bwd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ada kaliva moyaidi ivona, “Analuvealika ada anavita ani ime ana waina ada kaduwe natumeyavo.” ");
INSERT INTO bwd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","E ada Balabasi gietoyavuna faidiya. Ada Pailato giveimeya ke tolugaviya Yeisu ilubibiwalina ke nimadiya gisena ada ina kivebolagalagana. ");
INSERT INTO bwd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ada toveimeya-nai yana tolugaviya Yeisu inauwena ilukuwena veimeya anamanuwa lakaina anaebageya, ada tolugaviya adiyooyavo idouwevagauwidi. ");
INSERT INTO bwd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ada Yeisu ananuya iveyalilina aku nuya yabeyabelina luveyalilina vaita kini adiveigavu anafaiweya iveosena. ");
INSERT INTO bwd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ada bulava akakaluluna imetana ke kuluwane isena ada aiwala ani nimana aiyatagine iveyabina evona vaita Banae kini anafaiweya. Ada magigine tugadi ivetodonedi ke iawaveleigena, ivonavona, “Siule! Oyeni meIsileli yadi kini!” ");
INSERT INTO bwd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ada ikiwalitagotagona ke yana aiwala ivai kuluwana ilavulavuna. ");
INSERT INTO bwd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Iawaveleigena giavaina, nuya yabeyabelina iveyalilina aku Tauna ananuya iveosena, ada iyegemone inauwena ke ina kivebolagalagana. ");
INSERT INTO bwd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ada itauya Yeisu inaunauwena aku kaliva seyana kwana Sailini inudebaina, anayegana Saimoni. Ada iluyayalina ke Yeisu anakelose gina avalana. ");
INSERT INTO bwd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ada fafali-nai ivewagana Goligota wagaine ielai. Tainei ‘Goligota’ anakivila ani ‘Kuluwa Sewakelu anaFafali’. ");
INSERT INTO bwd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wadedeku-deya waini ke mulamula yuyuna nodi ivila-tamwaina ani Yeisu ivelena vaita ginayuna, aku giyuluvaluvana ada giawatukaikai. ");
INSERT INTO bwd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ada ikivebolagalagana giavaina, tolugaviya ani Yeisu ananuya ivai ivutugena taudiyavo gaga wagaidiya, taine kabala anaselakalakata anavenuwadadana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ada ivutuga giavaina, ivetogadi aku Yeisu kelose wagaine iitaitana aku imiyamiyaboda. ");
INSERT INTO bwd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aku anaawavekoyo ivetokilumina ani itutuvefosena kelose wagaine kuluwana getane, ani vetokiluma givona, “TAIDEI BANAE YEISU, MeISILELI YADI KINI.” ");
INSERT INTO bwd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","E au tobaninivula adiselu Yeisu nodi ikivebolagalagadi adikelose wagaine, seyana aiyatagine kadu seyana aimauline. ");
INSERT INTO bwd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aku kaliva wai wagaine inaunau ani kuluwadi ilewalewana aku Yeisu ivona awadamanena, ");
INSERT INTO bwd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ivonavona, “O uvona evona manuwa tabu uda yawelina ke yadayada toiye wagaine uda vemididi-vagilena! Ada nikayo Tauni uda kibababaleni! Kai Oyeni Yaubada Natuna, Tauni una etoyavuni kelose wagaine unaobu!” ");
INSERT INTO bwd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ada kadu anafaiweya veyavo anatovegugai lakaidiyavo ke veimeya anatovewalayavo kaduwe kaliva lakaidiyavo, ani Yeisu iawaveleigena ivonavona, ");
INSERT INTO bwd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mali kaliva gikibababaledi aku keke anafata Tauna gina kibababale. Evona, Banae Mesaiya kadu Isileli anakini, aga malinai-mowa kelose wagaine gidaobu, e ada kanaita kana vetumaganena. ");
INSERT INTO bwd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Banae Yaubada givetumaganena, ada kai Yaubada nuwanuwana aga gina kibababalena, faina Banae givona, ‘Iya Yaubada Natuna.’” ");
INSERT INTO bwd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ada tobaninivula adiselu nodi ikivebolagalagadi ani kaduwe anafaiweya Yeisu iawavekoyoyena. ");
INSERT INTO bwd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aku bademowa kauwana gielai anafaiweya givugivudeya ani yuyuvana babi matatabuna giyuyuvanibodena, ada gimiya analaba au gienovilana teli kiloki wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ada tova-nai wagaine Yeisu givedou bonana lakaina, givona, “Eloi, Eloi, lama sabakitani?” Vona taidei anakivila “O yaku Yaubada, yaku Yaubada, gavana faina unuyabuyabuku?” ");
INSERT INTO bwd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ada kaliva tufodi wadedeku-deya imidimididi ani bonana inogalina ke ivona, “Wada Ilaitiya gidoudouwena, bana Yaubada yana falofita.” ");
INSERT INTO bwd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ada maduga-mowa kaliva seyana gimadu ginau balou givaina ada giutuvina waini gikoyo wagaine, ada aiwala bwatane give etoonana ke gitune lakavena Yeisu awane gisena vaita ginayuna. ");
INSERT INTO bwd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aku tufodi ivona, “Auwe ginamiya. Kana itana kai Ilaitiya ginaelai ke gina kibababalena o kai keke.” ");
INSERT INTO bwd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeisu kaduwe givedou moiyalina ada aluwaluwana giawaegena ada au gialika. ");
INSERT INTO bwd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ada tayuwe tova-nai wagaine, manuwa tabu anaTutulagolota Tabutabu-moena ani anawana anaebaseboda kaleko giagigi-lugena, tabone ada giobu dibune. Ada kaduwe mabibi gimadu ada kabala giayavalidi. ");
INSERT INTO bwd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ada kaduwe didikula giayavudi aku Yaubada yana kalivayavo tabutabudi tuwaina ialika, ani tufona moyaidi gisiveyawadi alikeya ");
INSERT INTO bwd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ada didikuleya iyegemona. Ada Yeisu yana yawa-vagila muline, badi kaliva-dina ina iluku melala-nai tabutabuna wagaine ada kaliva moyaidi iitadi. ");
INSERT INTO bwd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aku tolugaviya aditonagona ke badi yana tolugaviya nodi Yeisu iitaitaveyabina, ani mabibi gimadu ke kaduwe gaitoma moyaina iyegemona ani iitadi wagaine, imatauta lakaina ada ivona, “Vona velemoena taidei Banae Yaubada Natuna!” ");
INSERT INTO bwd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kaduwe vevine tufona moyaidi badi Yeisu yana tonogalayavo, ani imididi maita tabae kelose wagaine aku imatawabuwabu. Galili wagaine vevine-dina tova moyaina ilemelemena, ada Galili-deya ikwayabu ielai Yelusalema. ");
INSERT INTO bwd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Badi vevine-dina wagaidiya ani Meli vine Magidala, ada Meli anavelu ani Iyemesa ke Iyosefa inadi, ada kaduwe Sebedi natunavo inadi. ");
INSERT INTO bwd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aku bademowa mala givelavilavi ani tokaikaiwabu seyana gielai, banae kwana Alimatiya anayegana Iyosefa. Bana kaduwe givetonogala Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Banae ginau Pailato wagaine ada Yeisu vovona faina giveolena ke gina kiwafina. Ada Pailato yana tolugaviya giveimeyedi ke Yeisu vovona Iyosefa ina velena. ");
INSERT INTO bwd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ada Iyosefa vovo givaina ada lifi kwayakwaya-moena aku yegayegana wagaine gifaina, ");
INSERT INTO bwd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ada ginauwena tauna anadidikula evaguna wagaine gilukuwena. Didikula-nai ani luwa lakaina gitalafolena yavola maufona anakabala wagaine. Ada kabala lakaina givekaliwawana didikula awana wagaine gisebodana, aku gitauya ginau. ");
INSERT INTO bwd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aku Meli vine Magidala kaduwe wagakoyona nodi ivetogadi babiya, wada didikula-nai iitadamanena. ");
INSERT INTO bwd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nugulina anakidewadewa anayadayada bademowa giavaina ada mala gilavuna veyavo anatovegugai lakaidiyavo ada Falisiyavo inau Pailato wagaine ");
INSERT INTO bwd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ada ivona, “Kauveya, tova-nai tovefwayafwaya tayuwe aimo wayawaina gimiyamiya aku givona ani yana vona anuwaududuna evona, yadayada toiye gina avaina ada ginayawa-vagila. ");
INSERT INTO bwd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Taidei faina uda veimeya ke ya tolugaviyamomo idanau ke yadayada toiye anadidikula ina itaveyabi-dewedewena, aenanai yana tonogalayavo inaelai ke vovona ina kiyafu ina nauwena aku kaliva ina vonedi vaita Yeisu gidayawa-vagila. E ada fwaya tainei wai gimulina ani au koyo-moena ayo yana fwaya nagona.” ");
INSERT INTO bwd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailato givonedi, givona, “Iwakana. Tolugaviya wana vaidi wana nauwedi ada wanasedi didikula ina itaveyabi-dewedewena.” ");
INSERT INTO bwd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","E ada inau ke didikula awana kabala kafukafuwana wagaine isebababalina, ani afaina iomafifina fwayafwaya wagaine ke imakana. Ada didikula wagaine tolugaviya ivemidididi ke ina itaveyabi-dewedewena. ");
INSERT INTO bwd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aku Sabate bademowa giavaina aku Sanidei aimo malalavuga ani Meli vine Magidala ada wagakoyona nodi inau ke didikula ina itana. ");
INSERT INTO bwd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ada maduga-mowa mabibi lakaina gimadu. Faina KAUVEYA yana anelose giobuelai gabameya-deya ada ginau didikula awane taine kabala lakaina wagaine isebodana, ani kabala-nai givekaliwawana didikula awane ada gisena afaine aku gitogalaka getane. ");
INSERT INTO bwd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ada anelose-nai ani anaita vaita atunama anafaiweya ada ananuya kwayakwaya fofolina vaita buibui anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ada tolugaviya didikula iitaitaveyabina ani iitana ke imatauta lakaina wagaine iala. Ada ibeu vaita toalika. ");
INSERT INTO bwd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aku anelose vevine givonedi, givona, “Keke wana matauta, faina gaalamanena Yeisu ikivebolagalagana ani walelelena. ");
INSERT INTO bwd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Banae keke idedeku gida miyami, faina Yaubada bademowa alikeya gisiveyawana, anafaiweya givonayena. Wanaela wana itana fafali-nai wagaine gidau. ");
INSERT INTO bwd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","E au wana madunau ke yana tonogalayavo wana vonedi, ‘Yeisu bademowa alikeya giyawa-vagila, ada wai ginagonagona Galili wagaine. Wadedeku-deya wana itana.’ Tainei-mowa amimatawa anatubuga.” ");
INSERT INTO bwd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","E ada vevine-dina wa yadi matauta aku kaduwe wa yadi vemwamwala lakaina nodi didikula isegena ada imadu inau ke Yeisu yana tonogalayavo ina vonedi. ");
INSERT INTO bwd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ada inaunau ani Yeisu ginuwagadi ada givona, “Siule!” Ada ielai wagaine tugadi ivetodonedi aku agena iabina ada ioduodu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ada Yeisu givona, “Keke wana matauta. Wananau ke tubuiyakuweyavo wana vonedi inanau Galili, ada wadedeku ina itaku.” ");
INSERT INTO bwd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Badi vevine itauya inaunau aku tolugaviya-dina tufodi didikula iitaitaveyabina ani ina iluku Yelusalema, ada gavana iyegemona anafaiweya ani iawatalatalainena veyavo anatovegugai lakaidiyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","E ada veyavo anatovegugai lakaidiyavo ke kaliva lakaidiyavo nodi ivagauta ada iveimeya, ada inuwanuwa giavaina, mani lakaina tolugaviya iveledi. ");
INSERT INTO bwd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ada ivonedi, “Kaliva wana vonedi, ‘Bogi wagaine ime adaudau aku yana tonogalayavo ielai ada vovona ikiyafuna.’ ");
INSERT INTO bwd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aku kai toveimeya lakaina kwana Loma valeya taidei anafaiweya gina nogalina, aga ime anana nodi ana ifufu ke nuwana ana kanina, e ada keke vita gina yegemona wagaimiya.” ");
INSERT INTO bwd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ada tolugaviya mani ivaina aku iveimeyedi anafaiweya ani inau. Ada Yeisu vovona anakiyafu ifufuna ani gimutula Isileli anamatatabuna wagaine, ada gielai anaetowava tova malinai aimo iifuifufuyena. ");
INSERT INTO bwd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ada tonogalayavo adileveni inau Galili, ada oya-nai Yeisu givonayena ani wagaine ilaka. ");
INSERT INTO bwd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ada iyegemona aku tova-nai Yeisu iitana ada ioduodu wagaine, aku tufodi inuwakila. ");
INSERT INTO bwd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ada Yeisu gielai lilivadiya ke givonedi, givona, “Veimeya matatabuna gabama wagaine ada kaduwe babi wagaine ani Kamaku givele-yabuku. ");
INSERT INTO bwd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Taidei faina wananau fafali matatabuna wagaidiya, ada babi anakaliva adiyoo moyaidi wana vewaledi ke ina vetonogala wagaikuya. Ada wana kivebabitaisodi Tamada anayeganeya, ada Natuna anayeganeya, ke Aluwaluwa Tabuna anayeganeya. ");
INSERT INTO bwd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tova moyaina wana vevewaledi e ada veimeya moyaina gavelemi ani ina muliyedi. Ada taidei wana nuwaududuna, Iya imi nodi kana miyamiya tova matatabuna anaetowava tova anaebalauyabu.” ");
INSERT INTO bwd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yeisu Keliso Banae Yaubada Natuna anavaleya iwakana anaebavevuvu ani taidei anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tuwai-moena falofita Aiseya giifufuyena yana buki wagaine, givona, “Una nogalina. Yaku tomatawa gana imili wai gina nagona ke ya wai kaliva aseasediya gina kidewedewena. ");
INSERT INTO bwd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Fafali kavovona wagaine gina vedovedou, ‘KAUVEYA yana wai aseasemiya wana kidewedewena ke wana kivetunutunugina Bana faine.’” ");
INSERT INTO bwd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ada Iyoni giyegemona ke gilulumamala fafali kavovona wagaine ada kaliva gikikivebabitaisodi, nuwavilana anaiyaiyaya faina. Ada givonavonaga, “Yami dewa koyona wagaidiya wana nuwavilana ke wana babitaiso e ada Yaubada yami koyona gina venuwaegedi.” ");
INSERT INTO bwd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ada kaliva moyaidi ielaelai bana wagaine, Yudiya anafafali wagaine kaduwe meYelusalema ielai Iyoni yana laumamala ina nogala faina. Ada yadi dewa koyodi iawaawamogataledi, ada Iyoni gikivebabitaisodi gufa Yolidani wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Aku banae Iyoni ananuya ani kevakeva kameli vutuvutuna wagaine ibubuna, aku anabeleta labene giyogona ani kevakeva kwafilina wagaine. Aku anaga ani bilolo ke mawa vutona. ");
INSERT INTO bwd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ada giawamogatala kaliva wagaidiya, givonaga, “Kaliva seyana mulikuya gielaelai ani Banae lakai-moena, aku Iyayeku kwamana kabisoku. E ada keke akulauboda Bana wagaine gana vetogugai ke gana iboula ada anaageyafayafa anabulava gana kiyavu. ");
INSERT INTO bwd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iya gufa wagaine gakivebabitaisomi aku Banae, ani Aluwaluwa Tabuna wagaine gina kivebabitaisomi.” ");
INSERT INTO bwd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aku tova-nai wagaine Yeisu gielai Nasaledi-deya Galili anafafali wagaine, ada Iyoni gikivebabitaisona gufa Yolidani wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ada Yeisu gifumatana gufa wagaine ani maduga-mowa giitalaka giitana gabama giawaina aku Aluwaluwa Tabuna giobuobuelai Bana wagaine vaita manuga bunebune anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ada gabameya-deya Yaubada bonana giyegemona, givona, “Oyeni Natu aseaseku. Nuwaku ukivemwamwalina lakaina.” ");
INSERT INTO bwd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ada maduga-mowa Yaubada Aluwaluwana Yeisu giimilina ada ginau fafali kavovona wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ada yadayada foti (40) wagaidiya fafali-nai wagaine gimiyamiya aku Seitani gialaaladibidibiyena. Ada kevakeva walawala nodi imiyamiya aku aneloseyavo iela ilemelemena. ");
INSERT INTO bwd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tova-nai Kini Elodi giveimeya yana toveya, Iyoni ikiveyabina ke deli wagaine isena. Ada muliya Yeisu ginau Galili anafafali wagaine ada Yaubada anavaleya iwakana gilulumamalena, ");
INSERT INTO bwd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","givona, “Tova-moena bademowa giyegemo! Yaubada yana ebaveimeya bademowa givelilivana. Yami dewa koyona wana dibusoyogedi ke wana nuwavilana, ada valeya iwakana wana vetumaganena.” ");
INSERT INTO bwd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ada tova seyana Yeisu Lavu Galili taliyeya givetaliyabalabala aku Saimoni ke anatubuluga Andulu giitadi. Adiselu guvata iyavuyavulena lavu wagaine, faina badi toyauba. ");
INSERT INTO bwd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ada Yeisu givonedi, givona, “Wanaela wana muliyeku ada gana kidewedewemi ke imi kaliva aditoyauba.” ");
INSERT INTO bwd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ada maduga-mowa adiselu yadi guvata imadusegedi aku Yeisu imuliyena. ");
INSERT INTO bwd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kaduwe maita-moena ginau ada kaliva adiselu giitadi, tainei Iyemesa ke Iyoni, badi Sebedi natunavo. Waka wagaine yadi guvata ikidewadewa. ");
INSERT INTO bwd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ada maduga-mowa gidouwedi ke ina muliyena, ada tamadi yana togugaiyavo nodi waka wagaine isegedi aku imuliyena. ");
INSERT INTO bwd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeisu yana tonogalayavo nodi inau melala anayegana Kafaneumi wagaine, ada Sabate wagaine Yeisu giluku manuwa ebavewala wagaine ke givebutu givewala. ");
INSERT INTO bwd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aku kaliva moyaidi inogalina ani meyadi gisidobodobona yana vewala-nai wagaine. Faina keke Mosese yana veimeya anatovewalayavo anafaiweya gida vewala, aku vaita kaliva seyana wa yana veimeya anafaiweya givewavewala. ");
INSERT INTO bwd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aku yadi manuwa ebavewala-nai wagaine kaliva seyana aluwaluwa bwanebwanenena nafone ani givedou bonana lakaina, givona, ");
INSERT INTO bwd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Aa! Yeisu kwana Nasaledi, gavana nuwanuwa unagai wagaimeya? Gavaiyamu, uelai una luyavulema faina? Iya gaalamaneni o gavakaliva. Oyeni Yaubada yana Kaliva Tabutabuna!” ");
INSERT INTO bwd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aku Yeisu aluwaluwa bwanebwanenena giawatana, givona, “Gina kuluni, ada una yegemona kaliva-nai wagaine!” ");
INSERT INTO bwd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ada aluwaluwa bwanebwanenena kaliva gigai givetatava lakaina aku gikwekwela moiyalina, ada muliya kaliva-nai nafone giyegemona. ");
INSERT INTO bwd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ada kaliva moyaidi meyadi gibovu ke taudiyavo ivetolitoli, ivonaga, “Ida gavana? Yana vewala evaguna kadu wa anaveimeya toyogina! Au aluwaluwa bwanebwanenedi nonogana giveimeyedi ada yana veimeya imatawalewaleyena.” ");
INSERT INTO bwd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ada Yeisu valeyana maduga-mowa iifufuyedadanena Galili yana ebaveimeya matatabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yeisu manuwa ebavewala wagaine giyegemona ada Iyemesa ke Iyoni nodi inau Saimoni ke Andulu yadi manuweya. ");
INSERT INTO bwd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aku Saimoni lawana vavine ani iveoga. Vovodi gilukalalava lakaina ada iviya idaudau, ada Yeisu imadumatawena yadi veoga faina. ");
INSERT INTO bwd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","E ada ginau wagaidiya ke nimadi giabina ada gisivemidididi ani veoga-nai giavaina aku vovodi gituluna. Ada ivebutu adiwakawaka adiga ikidewadewa. ");
INSERT INTO bwd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aku kauwana bademowa giolu ada lavilavi-nai wagaine kaliva moyaidi gavega wa adiveoga ke moyaidi nafodiya aluwaluwa koyona imiyamiya ani Yeisu wagaine tubuiyadiyavo ialiyedi. ");
INSERT INTO bwd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ada melala-nai anatomiya moyaidi ivagauta Saimoni yana manuwa-nai awane imididi, ");
INSERT INTO bwd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ada kaliva moyaidi wa adiveoga tulina tulina ani Yeisu gikivebwainidi. Ada kaduwe aluwaluwa koyona kaliva nafodiya giveyegemonidi, aku aluwaluwa-dina giawatadi ada keke gida awaegedi ina ifufu, faina ialamanena Banae Tauna au Mesaiya. ");
INSERT INTO bwd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Aku yadayada anavelu mala aimo keke gidalavu aku Yeisu gimididi ke manuwa gisegena aku ginau mamaveya mwatugu-kavovona wagaine ada giveoveola. ");
INSERT INTO bwd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aku Saimoni tubuiyanavo nodi inau ke Yeisu ilelena, ");
INSERT INTO bwd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ada inuwagana wagaine ivonena, ivonaga, “Kaliva moyaidi ileleleni.” ");
INSERT INTO bwd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yeisu givona, “Kananau melala lilivadeya ke badi kaduwe wagaidiya gana lulumamala. Taide vuvuna-nai faina Iya gaelai.” ");
INSERT INTO bwd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ada Yeisu gibalawalilivuga Galili anafafali matatabuna wagaine, ada meIsileli yadi manuwa ebavewala wagaidiya gilulumamala ke kaduwe aluwaluwa koyodi giveveyegemonidi kaliva wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aku kaliva seyana banae vovona lefelo gikivekoyona ani gielai Yeisu wagaine ada tugana givetodonena aku giveolena toyogina, givona, “Gaalamanena O afaiweya una kiveyegayeganeku. E ada kai nuwanuwa aga uda gugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ada Yeisu ginuwakalikaliyena ke nimana gisena kaliva-nai wagaine aku givonena, “Ika, nuwanuwaku. Una yegayegana.” ");
INSERT INTO bwd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ada kaliva-nai analefelo maduga-mowa giavaina, e ada gibwaina ke giyegayegana. ");
INSERT INTO bwd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ada Yeisu veimeya toyogina givelena, ");
INSERT INTO bwd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","givonenaga, “Una nogalina. Keke tamo gaito una awatalatalaine, aku unanau Yaubada yana veyavo anatovegugai wagaine e ada gina itani vovo ani gibwaina. Ada ya yegayegana Yaubada matane faina ani una vebolavoi Mosese giveimeya anafaiweya. E ada kaliva moyaidi ina alamanena o velemoena bade uveiwaka.” ");
INSERT INTO bwd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aku kaliva-nai ginau ada valeya-nai giawamogatalena kaliva moyaidi wagaidiya, ada au valeyana giakwalelega. E ada yoo lakai-moena aimo ina vagauta faina, Yeisu keke anafaiweya gina awakawaka melala wagaidiya aku ginau fafali mwatugu kavovodi wagaidiya. Aku kaliva melala tulina tulina wagaine ielaelai Bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yadayada gavaiyei giavaidi, kaduwe Yeisu giyewa-vagilena Kafaneumi wagaine, ada kaliva ikaiyanogala vaita Yeisu kadu gimiyamiya yana manuweya. ");
INSERT INTO bwd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","E ada yoo lakaina ivagauta ada waiyeda ke manuwa-moena ani keke tamo mwatugu gidatufo. Ada Yeisu valeya iwakana gilulumamalena wagaidiya ");
INSERT INTO bwd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","aku kaliva adilaufuli ielai ani kaliva iwai ialiyena, banae vovona memeluyana. ");
INSERT INTO bwd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ada vaita kaliva-nai ina lukuwena Yeisu wagaine aku keke adifata, faina yoo lakaina. E ada iwai ilakavena manuwa getane, ada manuwa getana anaseboda kabisona ikakidi ada awagane kaliva iseobuyena anavaya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ada Yeisu kaliva-dina yadi vetumagana giitana ke kaliva-nai wagaine givona, “Natuku, ya koyona bademowa gavenuwaegedi.” ");
INSERT INTO bwd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aku veimeya anatovewalayavo tufodi nodi ivetovetoga aku taudiyavo nuwainagediya itolidadana, ivona, ");
INSERT INTO bwd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Gavana faina givonavona anafaiweya? Ida kaliva-nai Yaubada givona awadamanena! Keke seyana gaito anafata koyona gina venuwaegedi aku Yaubada anakaibe-mowa.” ");
INSERT INTO bwd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aku maduga-mowa Yeisu aluwaluwane-deya yadi nuwanuwa gialamanena e ada givonedi, givona, “Gavaiyamu-yo taidei anafaiweya aseasemiya wanuwanuwa? ");
INSERT INTO bwd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gavavona meyameyagani-moena ganavone kaliva-nai vovona memeluyana wagaine, ganavona, ‘Ya koyona bademowa gavenuwaegedi,’ o kai ganavona, ‘Una mididi, avaya una waina ke una nudadana’? ");
INSERT INTO bwd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aku nuwanuwaku wana alamanena ani Banae Kaliva Natuna wa yana veimeya e ada Bana anafaiweya kaliva yadi koyona gina venuwaegedi babi taidei wagaine.” Ada au kaliva-nai vovona memeluyana ani Yeisu givonena, ");
INSERT INTO bwd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iya gavoneni, una mididi, avaya una waina ada unanau ya manuweya.” ");
INSERT INTO bwd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Au kaliva-nai gimididi, anavaya giwai-yo moyaidi matadiya giyegemona ginau. E ada yoo-dina meyadi gisidobona ke Yaubada idavana ada ivona, “Keke seyana tova gugai taidei anafaiweya kadaita!” ");
INSERT INTO bwd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kaduwe Yeisu giyewa-vagilena Lavu Galili taliyeya, aku yoo lakaina ivagauta wagaine ada givewaledi. ");
INSERT INTO bwd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ada Yeisu fafali-nai gisegena aku gitauya ginaunau ani Alipiyo natuna Livai giitana. Banae takesi anatoyaudi ke yana takesi anavada wagaine givetovetoga. Ada Yeisu givonena, “Unaela una muliyeku.” Ada gimididi ke Yeisu gimuliyena. ");
INSERT INTO bwd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ada muliya Yeisu ginau Livai yana manuweya ada yana tonogalayavo nodi teibeli lilivane ienokekela ikanikani, aku badi takesi anatoyaudi ada kaduwe tokoyona moyaidi nodi, faina yoo lakaina imuliyena. ");
INSERT INTO bwd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aku veimeya anatovewalayavo, badi Falisi adiyoo, ani iitana Yeisu takesi anatoyaudi ke tokoyona nodi ikanikani e ada yana tonogalayavo itolidadanedi, ivona, “Gavana faina takesi anatoyaudi ke tokoyona Banae badi nodi ikanikani?” ");
INSERT INTO bwd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aku Yeisu yadi tolidadana ginogalina-yo gilufata wagaidiya, givona, “Badi gavega iwakadiyavo ani keke nuwanuwadi doketa, aku badi toveoga gaga ani nuwanuwadi. Iya gaelai ani keke toyegayegana gana douwedi faina. Aiyada gaelai ke tokoyona gana douwedi.” ");
INSERT INTO bwd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aku aimo seyana tova Iyoni yana tonogalayavo ada Falisiyavo yadi tonogalayavo ani kani iloilovau. Ada kaliva tufodi ielai Yeisu wagaine ke itolidadanena, ivona, “Gavana vuvuna ayo Iyoni yana tonogalayavo ada Falisiyavo yadi tonogalayavo ani tova ke tova kani iloilova, aku ya tonogalayavo ani keke?” ");
INSERT INTO bwd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ada Yeisu givona matalivulivuna wagaidiya, givona, “Nagi anakani vemwamwala wagaine ani gavaiyamu, tonagi kaliva tubuiyanavo nodi ina miyamiya aku tubuiyanavo kani ina ilovau? Keke, faina tonagi-nai nodi imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aku tova gielaelai wagaine, kaliva tufodi inaela tonagi kaliva ina vaina tubuiyanavo wagaidiya-deya ke ina nauwena. E ada yadayada-dina wagaidiya kani ina iloilovau.” ");
INSERT INTO bwd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ada kaduwe givona matalivulivuna-vagila, givona, “Keke nuya tuwaina kana bwadi nuya diyana evaguna wagaine. Faina aimo nuya diyana evaguna ginabuta wagaine gina siyauta, e ada nuya tuwaina gina agigina lakai-moena. ");
INSERT INTO bwd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kaduwe anafaiweya, keke waini evaguna kana iwavedama tuwava kevakeva bubuna tuwaina wagaidiya. Faina waini evaguna yana lutuga wagaine tuwava bubu-dina gina fuwadi, e ada waini ke tuwava bubu inakoyo. Aku analauboda waini evaguna kana iwana tuwava evaguna wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabate seyana wagaine Yeisu yana tonogalayavo nodi witi anabakula wagaidiya inunugolota, aku tonogalayavo ivebutu witi guwana ikidakadaka. ");
INSERT INTO bwd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aku badi Falisiyavo ani iitadi ada Yeisu ivonena, ivona, “Una itana. Gavana faina Sabate anaveimeya keke ida itaveyabi?” ");
INSERT INTO bwd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Bana givonedi, givonaga, “Aku maita waveyawanuwagana gavana Kini Deivida gigana tova-nai yana yooyavo nodi mafa gilavudi wagaine? ");
INSERT INTO bwd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Giluku Yaubada yana manuwa wagaine ada beledi vevetabuna Yaubada matane isena, ani givai gikanina, ada kaduwe yana kalivayavo giveledi ikani. Taine Yaubada yana veyavo anatovegugai aditonagona anayegana Ebayada yana tova wagaine. Aku beledi-nai ani wa anaveimeya vitana velemoena, keke kaliva-kavokavovo inakani aku badi veyavo anatovegugai gaga adiawaega ke ina kanina.” ");
INSERT INTO bwd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ada kaduwe Yeisu givonedi, “Yaubada keke kaliva gida bubudi Sabate anaawata faina, aku aiyada Sabate gibubuna kaliva adilema faina. ");
INSERT INTO bwd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Taidei faina Banae Kaliva Natuna ani Tauna Sabate anaKauveya.” ");
INSERT INTO bwd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kaduwe tova seyana Yeisu giyewa manuwa ebavewala wagaine giluku. Aku manuwa-nai wagaine ani kaliva seyana gimiyamiya, nimana memeluyana. ");
INSERT INTO bwd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aku kaduwe kaliva tufodi imiyamiya, ani badi vuvu ilelelena ke Yeisu ina awavekoyoyena. E ada Bana iitaitavenanauna ke ina itana kai Sabate wagaine aku nimakoyo gina kivebwainina o kai keke. ");
INSERT INTO bwd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ada Yeisu kaliva nimana koyona wagaine givonaga, “Unaelai idedeku.” ");
INSERT INTO bwd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ada kaliva wagaidiya givona, “Sabate faina, gavaiyamu Veimeya anabuki wagaine giveimeyeda? Kana gugai iwakana kaliva wagaine o kai kana gugai koyona wagaine? Kai kaliva kana kibababalena o kai kana luvealikana?” Taidei anafaiweya Yeisu gitolidadanedi aku badi iveyamata. ");
INSERT INTO bwd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ada Yeisu wa yana nuwakoyo giitadadana moyaidi wagaidiya aku kadu wa yana nuwavita nodi yadi debai toyoga faina, aku givona nimakoyo wagaine, givonaga, “Nima una sivetotona.” Ada kaliva-nai nimana gisivetotona ada au giveiwaka-yabu. ");
INSERT INTO bwd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aku badi Falisiyavo itauya inau Elodi yana yoo nodi ivagauta ada iveifuifufuyena gavaiyamu Yeisu ina luvealika. ");
INSERT INTO bwd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Aku Yeisu yana tonogalayavo nodi iyegemona ada inau Lavu Galili taliya wagaine aku yoo lakai-moena imuliyedi. Badiyavo ielai Galili ke Yudiya wagaidiya, ");
INSERT INTO bwd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kaduwe Yelusalema ke Idumea, ada gufa Yolidani fafaline, ada kaduwe Taiya ke Saidoni. Yoo-dina gavana gigugaiyena inogalina faina ada ielai wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ada yoo lakai-moena faina, Yeisu yana tonogalayavo givonedi waka ina kidewedewena Bana faine, faina yoo lakai-moena aimo ina tutuwaiwainena. ");
INSERT INTO bwd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kaliva moyaidi gikiveiwakanedi faina, toveoga ififina ada ivetoefaefa ke Bana wagaine nimadididi inasedi e ada ina veiwaka. ");
INSERT INTO bwd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ada gavatoveya badi wa aluwaluwa bwanebwanenedi Yeisu inaita-moena ani aluwaluwa-dina nafodiya inagadi ke, wa yadi vetatava tugadi ina vetovetodonedi Yeisu debaine ada ina vedovedou, “Oyeni ani Yaubada Natuna!” ");
INSERT INTO bwd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aku Yeisu giawatadi toyogina evona keke valeyana ina ifufuyedadane e ada kaliva ina alamane Banae gaito. ");
INSERT INTO bwd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ada Yeisu gilaka oya wagaine aku kaliva-dina nuwanuwana ani gidouwedi ada ilaka Bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ada kaliva adituwelo givenuwadadanedi ada givewagadi ‘afositolo’. Givenuwadadanedi e ada badi Banae nodi ina miyamiya ke gina imilidi ina lumamala, ");
INSERT INTO bwd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ada veimeya gina veledi e ada wa yadi veimeya aluwaluwa koyodi ina veyegemonidi. ");
INSERT INTO bwd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ada kaliva-dina givenuwadadanedi ani adiyegana taidei anafaiweya. Saimoni aku anayegana Yeisu givewagana ani Pita, ");
INSERT INTO bwd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iyemesa ke taina Iyoni adiselu Sebedi natunavo aku Yeisu givewagadi ‘Bowanedisi’, anakivila ani ‘Atala Natunavo’, ");
INSERT INTO bwd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kaduwe Andulu ke Filipi ke Batolomiu ke Madiu ke Tomasi ada Iyemesa banae Alifiyo natuna, Tadiyasi ke Saimoni Seloti, ");
INSERT INTO bwd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ada Yudasa Isakaliyota, bana Yeisu gina atuegena nibainavo nimadiya. ");
INSERT INTO bwd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ada bademowa Yeisu yana yoo nodi iyewa manuwa seyana wagaine, aku kaduwe yoo lakaina ivagauta ada Yeisu ke yana tonogalayavo nodi keke tamo mwatugu ayo inakani. ");
INSERT INTO bwd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ada yana gabuyavo inogalina Yeisu keke gida veyaveyawai e ada inau ina vagaulena, faina ivona, “Givekabakabaleya.” ");
INSERT INTO bwd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ada veimeya anatovewalayavo Yelusalema-deya iobuelai, ani ivonaga, “Kaliva taidei ani Biyelisibuli nafone gimiyamiya.” Ada kaduwe ivona, “Banae aluwaluwa koyodi aditonagona yana toyogina wagaine aluwaluwa koyodi giveveyegemonidi.” ");
INSERT INTO bwd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ada taidei anafaiweya ivonavona faina, Yeisu gidouwe vagauwidi ke vona matalivulivuna wagaidiya giifuifufuyedi, givona, “Gavaiyamu, meyameyaganina Seitani tauna gina veyegemonina? Keke-mowa. ");
INSERT INTO bwd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kai ebaveimeya seyana aku anayoo taudiyavo ina ludakadi e ada yoo tulina tulina nodi ina lulugaviya, aga ebaveimeya-nai ginabeu. ");
INSERT INTO bwd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kaduwe kai unuma seyana aku anakalivayavo taudiyavo ina ludakadi ke nodi ina lulugaviya, aga unuma-nai ginabeu. ");
INSERT INTO bwd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kaduwe anafaiweya, kai Seitani tauna yana yoo gina venibainena e ada yana ebaveimeya gina ludakana, aga keke meyameyaganina gina mididi aku au anaebalauyabu gina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kai kaliva totoyogina yana manuweya gina miyamiya, aga keke tamo gaito anafaiweya ginaluku kaliva yana lokoloko ginavai. Aku kai nagona kaliva-nai totoyogina gina yogona aga muliya yana lokoloko gina vaidi. ");
INSERT INTO bwd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Gavonemi velemoena, kaliva yadi dewa koyodi moyaidi ani Yaubada anafaiweya gina venuwaegedi, ada kaduwe gavavona wagaine inavona awadamana ani anafaiweya gina venuwaegedi. ");
INSERT INTO bwd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aku Aluwaluwa Tabuna ani badi gavega Banae inavona awadamanena, tainei yadi koyona ani keke-mowa Yaubada gina venuwaege. Koyona-nai aimo ginamiya-vagata wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Vona taidei Yeisu giinanana faina kaliva tufodi ivona, “Banae ani aluwaluwa bwanebwanenena gimiyamiya nafone.” ");
INSERT INTO bwd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Aku Yeisu inana ke tainavo ani ielai ada wamelaleya imidimididi, aku kaliva seyana ivonena ke Yeisu gina matawena. ");
INSERT INTO bwd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ada yoo lilivane ivetovetoga ani Yeisu imatawena, ivonaga, “Kauveya, ina ke tubuiyamomo waiyedeya imidimididi. Nuwanuwadi ina itani.” ");
INSERT INTO bwd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ada Yeisu givona wagaidiya, givona, “Gaito inaku? Ada gavega kaikuweyavo?” ");
INSERT INTO bwd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aku badi itogafifina ani giitafasedi ada givona, “Taidei yoo-dina badi inaku ke kaikuweyavo. ");
INSERT INTO bwd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Faina badi gavega Yaubada yana nuwanuwa ivevegugaiyena, badi Iya tubuiyaku, novuku ke inaku.” ");
INSERT INTO bwd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aku seyana tova kaduwe Yeisu givebutu givewala Lavu Galili taliyeya. Aku yoo ivagauta ani lakai-moena, e ada waka wagaine giyage giluvealugau aku yoo-dina ani imiya taliyeya. ");
INSERT INTO bwd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ada gaitoma moyaina givewavewaledi vona matalivulivuna wagaidiya, ada yana vewala wagaine givonedi, givonaga, ");
INSERT INTO bwd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wana nogalina. Kaliva seyana ginau ke yana bakula wagaine witi waifeina gina yavuledi. ");
INSERT INTO bwd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ada waifei giyavuyavuledi aku tufona ibeu wai wagaine aku manuga iela imadukani-yabudi. ");
INSERT INTO bwd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kadu tufona ibeu kakanafaya wagaine, bana wagaine babi keke badobadona, ada maduga-mowa waifei ikabu, faina babi keke gidaobu lakaina. ");
INSERT INTO bwd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aku kauwana gilaka wagaine, witi kabudi evagudi gikabudi ke imayewadi, faina walamidi keke idaobu velemoena. ");
INSERT INTO bwd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kadu tufona ibeu sikakakama wagaine, ada sikakakama gitabo toyogina ke witi gifaimununa, e ada keke gida veguwa. ");
INSERT INTO bwd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aku tufona ibeu babi iwakana wagaine ke itabo iwakana. Ada waifei giveguwa ani tufona guwa inuwagadi teti (30), tufona sikisiti (60), kaduwe tufona analedi (100).” ");
INSERT INTO bwd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ada Yeisu givonedi, “Imi gavega wa tagami ani vona taidei wada nogalina.” ");
INSERT INTO bwd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ada aimo Yeisu anakaibe gimiyamiya aku yana yoo tuwelo ke yoo tufona nodi ielai ada yana vona matalivulivuna adialamana faine itolidadanena. ");
INSERT INTO bwd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ada givonedi, “Imi wagaimiya ani amiawaega ke Yaubada yana ebaveimeya ananuwanuwa sewasewavuyena wana alamanena. Aku badi gavega keke Yaubada yana yoo wagaidiya ani vona matalivulivuna gaga wagaine ina nogalina ");
INSERT INTO bwd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ayo ina itaita aku keke inaita ke ina alamane, ada kadu ina noganogala aku keke nuwadi ginamali, faina kai wa yadi alamana aga ida nuwavilana ke yadi koyona gada venuwaegedi.” ");
INSERT INTO bwd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ada givonediga, “Vona matalivulivuna taidei ani ananuwanuwa maita nuwami gimalina? Kai keke, aga gavaiyamu-yo wana alamanedi vona matalivulivuna-dina moyaidi aimo gana ifufuyedi? ");
INSERT INTO bwd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Waifei anatoiyavuyavula-nai ani Yaubada yana vona giyavuyavulena. ");
INSERT INTO bwd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ada waifei-dina ibeu wai wagaine ananuwanuwa ani vaita badi gavega Yaubada yana vona inogalina anafaiweya. Inogalina e ani Seitani gielai ke vona-nai ibakulina aseasedi wagaidiya ani givaiyavulena. ");
INSERT INTO bwd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aku waifei ibeu kakanafaya wagaine ananuwanuwa ani badi gavega Yaubada yana vona inogalina ada maduga-mowa wa yadi vemwamwala ivetumaganena. ");
INSERT INTO bwd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aku vona-nai ani keke idavai ada idasei aseasediya ida miyami, vaita walamidi keke idasei, e ada tova maufo-moena iatuvefaila. Badi Yaubada yana vona ivetumaganena, aku kai tova vitana gina yegemona wagaidiya o kai kaliva ina kiveuloulolonidi aga maduga-mowa yadi vetumagana-nai ina segena. ");
INSERT INTO bwd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aku waifei giyavuyavulena sikakakama wagaine ananuwanuwa ani taidei anafaiweya. Badi gavega Yaubada yana vona inogalina ");
INSERT INTO bwd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","aku babi anagaitoma moyaina ananuwanuwa ke kaikaiwabu ananuwakabubu lakaina aseasedi wagaidiya, ani ifwayafwayadi e ada keke ida veveguwa. Kaduwe badi gaitoma moyaidi tulina tulina iitaitaluvadigedi, ada taidei wagaine Yaubada yana vona-nai inogalina ani gifaifaimununa e ada keke ida guwaguwa. ");
INSERT INTO bwd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aku waifei-dina ibeu babi iwakana wagaine ananuwanuwa ani badi gavega Yaubada yana vona inogalina ada ivetumaganena, e ada yadi dewa wagaidiya guwa iwakana iseseyegemonena. Tufona teti (30), tufona sikisiti (60), ke tufona analedi (100).” ");
INSERT INTO bwd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kaduwe givonediga, “Gavaiyamu, mayale kana kabuna ada ivi dibune kanasena? O kai wela wagaine kana lukabubuna? Keke. Au mayale anaebaibo wagaine kanasena. ");
INSERT INTO bwd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Faina gaitoma-dina tova malinai sewasewavuyedi ani aimo ina ivemogatalidi, kaduwe gaitoma-dina lulukabubudi ani aimo ina seyegemonedi malina wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Imi gavega wa tagami ani vona taidei wada nogalina.” ");
INSERT INTO bwd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kaduwe givona, “Yaubada yana nuwanuwa wana nogalina. Wana nogali-dewedewena. Kai Yaubada bonana ananogala wagaine wana idibumwaiga, aga alamana wana vaina ada kaduwe Yaubada yami alamana gina kiveinalina. ");
INSERT INTO bwd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Faina badi gavega Yaubada yana vona inogalina ke ivevefaisewana ani badi kaduwe alamana gina veledi, e ada Yaubada anaalamana badi wagaidiya gina tubuga-mowa. Aku gavega Yaubada yana vona keke ida vevefaisewa, badi yadi alamana kabisona ani Yaubada gina vaiyegena wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ada kaduwe Yeisu givona, “Yaubada yana ebaveimeya ani anafaiweya kaliva waifei giyavulena yana bakuleya. ");
INSERT INTO bwd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ada bogi wagaine ginadau ada malabutuya gina mididi aku waifei itabotabo, aku keke gida alamane gavaiyamu waifei-dina itabotabo. ");
INSERT INTO bwd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Faina babi giveiveimeya waifei yadi kabu ada yadi taula ke yadi veguwa. ");
INSERT INTO bwd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ada kai lukuna gina tafana aga bademowa gikumagina ada kwasikwasi wagaine ina dabana, faina iyala yana tova.” ");
INSERT INTO bwd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ada kaduwe Yeisu givonediga, “Yaubada yana ebaveimeya ani gavana wagaine kada vonaveluveye? O kai gava vona matalivulivuna kada awaluveluve anakivemala faine? ");
INSERT INTO bwd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yana ebaveimeya ani vaita musita waifeina seyana anafaiweya. Waifei matatabuna imiyamiya babiya ani wagaidiya musita waifeina ani kabiso-moena. ");
INSERT INTO bwd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","E aku ina bakulina wagaine, au ginatabo lakaina, ada gavana gitabotabo bakula wagaine ani matatabuna gina tabosegedi. Kaduwe lagana ginasedi ke aiwaudiya manuga adiuba ina bubudi.” ");
INSERT INTO bwd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ada vona matalivulivuna moyaidi anafaiweya wagaidiya Yeisu giifufuyedi, anafaiweya adifata ina alamanedi. ");
INSERT INTO bwd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Keke gida ifufu-mowa kaliva wagaidiya aku vona matalivulivuna gaga wagaidiya, aku tova-nai adiloi gaga Yeisu ke yana tonogalayavo nodi, aga gaitoma moyaina faina gikikivemalina wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ada yadayada-nai analavilavi wagaine, Yeisu yana tonogalayavo givonedi, “Kana damana lavu fafaline.” ");
INSERT INTO bwd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ada yoo lakaina imadu yabuyabudi aku waka-nai wagaine Yeisu gimiyamiya ani yana tonogalayavo iyage ada nodi itauya. Kadu waka tufodi nodi inau. ");
INSERT INTO bwd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aku yadi damana-nai wagaine mala lakaina inuwagana, ada buli lakaidi waka iiwatavutavuna. ");
INSERT INTO bwd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aku Yeisu ani waka muline giveunugana ada gienowavulu. E ada yana tonogalayavo ina ilivaguna, ivonena, “Tovewala, kai keke uda nuwanuwa kana yababa faina?” ");
INSERT INTO bwd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ada Yeisu gimididi ke mala giawatana, ada givona buli wagaidiya, “Auwe! Gina kuluni!” Ada maduga-mowa mala giavaina ke giniwalova. ");
INSERT INTO bwd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ada Yeisu yana tonogalayavo givonedi, “Gavana faina wamatauta? Gavaiyamu, aimoina keke wa yami vetumagana?” ");
INSERT INTO bwd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aku tonogalayavo imatauta lakaina ke taudiyavo ivetolitoli, ivonaga, “Ida gavakaliva ayo mala ke buli bonana imatawalewaleye!” ");
INSERT INTO bwd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aku Yeisu yana tonogalayavo nodi idamana ke iyalili lavu fafaline, tayuwe meGelasa yadi fafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ada waka wagaine Yeisu giobu ani kaliva seyana giyegemona didikula adifafaliya ke gielai Bana wagaine. Kaliva-nai ani aluwaluwa bwanebwanenena nafone gimiyamiya, ");
INSERT INTO bwd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ada yana ebamiya ani didikula-dina wagaidiya. Ada keke tamo gaito anafata ginayogo seini wagaine, ");
INSERT INTO bwd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","faina tova ke tova nimana ke agena iyogoyogodi aku seini gigologoloidi, kaduwe agena analokafu gidobodobodi, e ada keke tamo gaito anafata gina kiveyabi. ");
INSERT INTO bwd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ada kaduwe yadayada ke bogi wagaidiya ani didikula ke oya wagaidiya givekovakova aku tauna kabala wagaidiya gitalatalana. ");
INSERT INTO bwd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aku tova-nai atuwadeya giitana Yeisu ada gimadu ginau ke tugana givetodonena Yeisu debaine. ");
INSERT INTO bwd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Aku Yeisu aluwaluwa bwanenena givonena, givonaga, “O aluwaluwa bwanebwanenena, una yegemona kaliva taidei wagaine!” E aku banae givedou moiyalina, givona, “Yeisu, O Yaubada Togetanemwane Natuna! Gavana unagai wagaikuya? Yaubada anayeganeya gaveoleni, keke una kiveulouloniku!” ");
INSERT INTO bwd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ada Yeisu gitolidadanena, “Gavaiyamu ayegana?” Bana gilufata, “Iya akuyegana Manuwafo, faina imeyavo ani moyai-moema.” ");
INSERT INTO bwd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aku giveoveola toyogina Yeisu wagaine vaita keke aluwaluwa bwanebwanenedi gina imilidi fafali-nai wagaine ina yegemona. ");
INSERT INTO bwd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","E aku lilivadiya oya afaine ani bawe moyaidi iduwaduwala, ");
INSERT INTO bwd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ada aluwaluwa bwanebwanenedi Yeisu ialamamaiyena, ivonaga, “Uda imilima adana tayuwe bawe-dina wagaidiya adaluku!” ");
INSERT INTO bwd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Au giawaegedi. E ada aluwaluwa bwanebwanenedi iyegemona kaliva-nai wagaine aku inau bawe wagaidiya iluku, ada au bawe-moedi matatabudi iluyabayabanunuga oya wagaine iobu ke ikamomola lavu wagaine. Bawe-dina adiyoo anafaiweya tu tausani (2,000). ");
INSERT INTO bwd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aku kaliva bawe iitaitaveyabidi ani iveotaota imadu inau, ada gaitoma-nai iitana ani iawamogatalena melala lakaina ke melala kabisodi matatabuna wagaidiya. Ada kaliva itauya ke ina itana gavana giyegemona. ");
INSERT INTO bwd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ada ielai Yeisu wagaine ani iitana kaliva-nai aluwaluwa bwanebwanenedi iyegemona wagaine ani givetovetoga, aku bademowa yana nuwanuwa giveiwaka ke wa ananuya gimiyamiya. Ada yoo-dina iitana ani imatauta lakaina. ");
INSERT INTO bwd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ada badiyavo toitavedama ani iawamogatala kaliva wagaidiya gavana giyegemona kaliva-nai wagaine ke kaduwe gavaiyamu bawe iga faina. ");
INSERT INTO bwd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ada au yoo-dina Yeisu iveoveolena toyogina ke yadi fafali gina segena. ");
INSERT INTO bwd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ada Yeisu gina waka wagaine giyageyage aku kaliva-nai aluwaluwa bwanebwanenedi iyegemona wagaine ani gialamamaiyena, givonaga, “Iya nodi kadanau!” ");
INSERT INTO bwd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aku Yeisu giawatana ke givonenaga, “Unanau ya manuweya ada ya gabuyavo ina itani, aku tauni una awamogataleni Yaubada yana leme ke yana nuwakalikali wagainiya faina.” ");
INSERT INTO bwd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ada au, bana kaliva-nai giyewa ginau ke tauna giawamogatalena meDekafolisi wagaidiya Yeisu yana leme wagaine faina. Ada kaliva moyaidi meyadi gisidobodobona. ");
INSERT INTO bwd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ada kaduwe Yeisu giyewa-vagilena lavu fafaline waka wagaine, aku yoo lakaina ivagauta taliya-nai wagaine imidififina. ");
INSERT INTO bwd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aku kaliva seyana gielai anayegana Yailo, banae manuwa ebavewala anatonagona seyana. Ada tonagona-nai Yeisu giitana ke agene tugana givetodonena ");
INSERT INTO bwd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aku giveola toyogina Bana wagaine, givonaga, “Natuku vavine kabisona ani giveoga, ada tova kabisona gina alika. Udaela nima udasena bana wagaine e ada gida veiwaka ke gidamiya.” ");
INSERT INTO bwd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Au Yeisu kaliva-nai nodi inau. Ada yoo lakaina imuliyena aku Yeisu ififina ada ivetutuwaiwainau. ");
INSERT INTO bwd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aku yoo-dina wagaidiya vavine seyana banae anaveoga ani malamala tuwelo dayagina gimadumadu. ");
INSERT INTO bwd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bade ginaunau doketa moyaidi wagaidiya yadi leme faine, e aku au nimadiya uloulolo lakaina ginuwagana. Yana mani matatabuna bade givele-yabudi fatadi faina, aku doketa yadi galuvaluva wagaine ani keke gida bwaibwaina aku anaveoga gitubutubuga-mowa. ");
INSERT INTO bwd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aku vavine-nai Yeisu valeyana bademowa ginogalina faina, yoo negenidiya Yeisu wamuline gielai ada nimadidina gisedi ananuya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Faina nuwainagene-deya givona, “Kai ananuya gagana wagaine nimadidiku ganasedi, aga gana veiwaka.” ");
INSERT INTO bwd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ada nimadidina gisedi ananuya wagaine, ke maduga-mowa dayagina gimadumadu ani giilovau. Ada tauna vovona nafone-deya gilutovonina vaita bademowa giveiwaka. ");
INSERT INTO bwd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ada Yeisu gilutovonina vaita toyogina Tauna wagaine giyegemona, e ada maduga-mowa gimiyavilana yoo nefanidiya aku gitolidadana, givona, “Gaito nimadidina gisedi akunuya wagaine?” ");
INSERT INTO bwd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ada yana tonogalayavo ivonenaga, “Bademowa uitana kaliva iyoofifini ada ivetuvetutuni, aku utolidadana ‘Gaito nimadidina gisedi wagaikuya?’” ");
INSERT INTO bwd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aku Yeisu aimo giitadadana yoo wagaidiya ke gina itana gaito nimadidina gisedi bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Au vavine-nai bademowa gialamanena gavana giyegemona bana wagaine faina, ada wa yana matauta ke wa yana vetatava aku gielai tugana givetodonena Yeisu agene, ada giawamogatala gavana matatabuna giyegemona wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ada Yeisu givonena, “Natuku, ya vetumagana gikivebwainini. Una mididi ke wa ya nuwaniwalova unanau, faina bademowa uveiwaka.” ");
INSERT INTO bwd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ada aimo giifuifufu aku kaliva tufodi Yailo yana manuweya-deya ielai ada ivonaga, “Natu bademowa yawaina giavaina. Keke aimo Kauveya una luluveyavale e ada yana tova una venuwaegege.” ");
INSERT INTO bwd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aku Yeisu vona taidei ginogalina ada givona Yailo wagaine, givona, “Keke una matauta, au una vetumagana.” ");
INSERT INTO bwd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ada keke seyana gaito gida awaege gina muliye, tainei-mowa Pita ada Iyemesa ke anatubuluga Iyoni. ");
INSERT INTO bwd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ada iyegemona Yailo yana manuweya ada Yeisu giitadi totagiya itagilukuikui ke ivevetalageyo. ");
INSERT INTO bwd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Giluku ke givona wagaidiya, givona, “Gavaiyamu-yo waaseuloulolo ke watagitagiya? Kwamana keke gida alika aku gidaudau.” ");
INSERT INTO bwd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aku badi iveleigena. E au Yeisu moyaidi giveyegemonidi melaleya, aku kwamana-nai inana ke tamana ada anatomuliya aditoto nodi iluku tutulagolota-nai wagaine kwamana ivenobalina. ");
INSERT INTO bwd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ada nimana gikiveyabina aku Tauna meyana wagaine givonenaga, “Talita kumi!” Anakivila ani “Natuku vavine kabiso, gavoneni, una mididi!” ");
INSERT INTO bwd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ada maduga-mowa kwamana gimididi ke ginudadana. Kwamana-nai anamalamala tuwelo. Ada inana ke tamana meyadi gisidobona. ");
INSERT INTO bwd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aku Yeisu veimeya toyogina giveledi, keke ina awamogatale yana gugai faina. Ada kaduwe givonedi vaita aa tamo inavele kwamana gina kanina. ");
INSERT INTO bwd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ada Yeisu Yailo yana fafali gisegena aku giyewa Tauna yana melala Nasaledi wagaine, ada yana tonogalayavo imuliye nodi inau. ");
INSERT INTO bwd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ada Sabate wagaine gina giluku manuwa ebavewala wagaine ada givebutu givewala. Ada givewavewala aku badi ivanevanenegena ani meyadi gisidobodobona ke ivonaga, “Kaliva taidei ani gadedeku gaitoma taidei givaidi? Ida nuwauya givaina ani gavana vuvuna? Gavaiyamu e ayo gugai ebameyasidobodobo toyogi-vagaidi gigugaiyedi? ");
INSERT INTO bwd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aku banae ani au manuwa anatoiyogona, kaduwe Meli natu-moedi. Tainavo ani Iyemesa ke Iyosefa, ada Yudasa ke Saimoni. Kaduwe novunavo nodi kamiyamiya.” Ada idibusoyogena. ");
INSERT INTO bwd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ada Yeisu givona wagaidiya, givona, “Falofita ani fafali moyaina wagaidiya kaliva ivemoimoinena, aku tauna yana yoo yana fafali wagaine keke ida vemoimoine.” ");
INSERT INTO bwd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E ada wadedeku keke anafata gugai ebameyasidobodobo gina gugaiyedi, aku inogame-nai toveoga adigavaiyei gaga wagaidiya nimana gisena ke gikiveiwakanedi. ");
INSERT INTO bwd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aku meyana gisidobodobona, faina kaliva keke ida vetumagane. Ada wadedeku Yeisu gisegena aku gibalawalilivuga melala seyana seyana wagaidiya givevewala. ");
INSERT INTO bwd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ada tonogalayavo adituwelo gidouwevagauwidi ke givebutu giimilidi adiselu adiselu. Ada veimeya giveledi e ada wa yadi veimeya aluwaluwa bwanebwanenedi ina veyegemonidi kaliva wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ada kaduwe giveimeyedi, givonaga, “Keke tamo gavana wanavai yami nau-nai faina, tainei-mowa aiwala gaga. Keke aa, keke fose, kaduwe keke mani. ");
INSERT INTO bwd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ageyafayafa wana osedi, aku keke seti anavelu wanaose. ");
INSERT INTO bwd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gavatoveya toni manuwa yana manuweya gina lukuwemi, manuwa-nai wagaine wana miyamiya analaba melala-nai wana miyasegena. ");
INSERT INTO bwd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kai melala seyana wagaine wanaluku aku anakaliva keke ina vagaulemi ada yami laumamala keke ina nogali, aga melala-nai wana segena wagaine, anasivu agemiya wana vatuegegena. Wada iyaiyaya seyana aimo Yaubada yana matavuloga wagaidiya faina.” Taidei anafaiweya Yeisu afositolo adituwelo givona wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","E ada badi itauya inau kaliva adiyoo tulina tulina moyaidi wagaidiya, ke ilulumamala vaita yadi dewa koyona wagaidiya ina nuwavilana aku ina awaegedi Yaubada wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ada kaduwe aluwaluwa bwanebwanenedi moyaina iveveyegemonidi kaliva wagaidiya, ada toveoga moyaidi bunama kuluwadiya iiwaiwavekelolodi ke ikikiveiwakanedi. ");
INSERT INTO bwd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ada bademowa Yeisu valeyana gimutula fafali moyaina wagaidiya, e ada Kini Elodi ginogalina. Kaliva tufodi ivona, “Yaubada Iyoni Tobabitaiso alikeya gisiveyawa-vagilena. Tainei faina wa yana toyogina ke gugai ebameyasidobodobo gifaifaisewadi.” ");
INSERT INTO bwd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ada tufodi ivona, “Banae Ilaitiya.” Kaduwe tufodi ivona, “Banae falofita, tova tuwaina anafalofita seyana anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aku Elodi ginogalina wagaine, givonaga, “Wada Iyoni Tobabitaiso odona galugoloina ani giyawa-vagila!” ");
INSERT INTO bwd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Elodi givona anafaiweya faina tuwaina anatubuluga Filipi vavinena adiyegana Elodiyasi ani Elodi tauna giluobuyedi. Ada taidei faina bana Iyoni gielaelai ada givona-vavagilena Elodi, givonenaga, “Taidei ya dewa-nai udewayena tawaga Filipi vavinena uluobuyedi, ani ina veimeya uyawelina.” Ada Elodi keke gida vemwamwala Iyoni yana vona-dina wagaidiya e ada yana togugaiyavo giveimeyedi ke Iyoni ikiveyabi iyogona ada deli wagaine isena. ");
INSERT INTO bwd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ada tayuwe wagaine Elodiyasi nuwadi gikoyo lakaina Iyoni wagaine, ke yadi nuwakoyo ikitaitaina e ada nuwanuwadi Iyoni ina luvealikana. Aku keke adifata, ");
INSERT INTO bwd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","faina Elodi gialamanena Iyoni banae totunutunugina ada kaduwe tabutabuna, e ada gimatausena. Taidei faina Elodi Iyoni giyavana ke gikibababalena. Banae keke wa yana vemwamwala Iyoni yana ifufu wagaine aku auwe nuwanuwana gina noganogala. ");
INSERT INTO bwd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aku Elodiyasi wai ilelele vaita Iyoni ina luvealikana, ani yadi tova iwakana inuwagana tova-nai Elodi yana tubuga anayadayada anatova wagaine. Elodi tauna yana ebanuwaududu anakanibutu lakaina gifaisewana kaliva lakaidiyavo moyaidi faidiya, badi yana kabemali aditoveimeya lakaidiyavo ada tolugaviya aditonagonayavo ke kaduwe kaliva lakaidiyavo Galili wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ada nodi ikanikani aku Elodiyasi natudi vavine kabisona ani gielai gitavotavola yoo matadiya, ada Elodi ke anawakawakayavo gikivemwamwalidi. E ada kini givonadabadaba toyogina kwamana-nai wagaine, givonaga, “Gavana una veola wagaikuya, gana veleni. ");
INSERT INTO bwd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Gavoneni velemoena, kai una veoleku tufona yaku ebaveimeya faina, aga gana ludaka gana veleni.” ");
INSERT INTO bwd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ada kwamana giyegemona ke inana givonedi, “Gavana gada veola?” Ada inana ivonena, “Kini una vonena, ‘Iyoni Tobabitaiso kuluwana.’” ");
INSERT INTO bwd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ada maduga-mowa natudi giyewana kini wagaine ada giveolena, givonaga, “Nuwanuwaku tova malinai-mowa Iyoni Tobabitaiso kuluwana nauwa wagaine uda veleku.” ");
INSERT INTO bwd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tayuwe wagaine Kini Elodi nuwana givita lakaina, aku anawakawakayavo matadiya givonadabadaba toyogina faina, auwe keke anafaiweya kwamana-nai yana nuwanuwa gina dibusoyoge. ");
INSERT INTO bwd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","E ada maduga-mowa Kini giveimeya ada tolugaviya seyana ginau ke deli wagaine Iyoni odona gilugoloina, ");
INSERT INTO bwd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ada kuluwana nauwa wagaine gidodona ada gialiye kwamana givelena. Ada banae ginauwe inana giveledi. ");
INSERT INTO bwd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ada tova-nai Iyoni yana tonogalayavo valeyana inogalina, iela vovona ivaina ada didikula luwa yaiyaina wagaine isena. ");
INSERT INTO bwd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aku afositoloyavo Yeisu wagaine iyewadi, ada gavana anafaiweya igugaiyena ke ivewalanau ani iawatalatalainena. ");
INSERT INTO bwd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aku kaliva moyaidi ielaelai ada inaunau e ada keke tamo mwatugu ke Yeisu yana afositoloyavo nodi ina veyawai-yo inakani. Taidei faina Yeisu givonedi, “Kananau makakaudaga wagaine ada maita kana veyawai.” ");
INSERT INTO bwd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ada adiloi gaga waka iyagena ke inau seyana fafali kavovona wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aku badi inaunau ani kaliva moyaidi iitadi ke iinanadi. Ada ialamanena gavafafali wagaine inaunau, e ada yadi melala seyana seyana isegedi aku agediya wai inago imadu inau fafali-nai wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ada Yeisu waka wagaine giyalili ani yoo lakaina giitadi wagaine ginuwakalikaliyedi, faina badiyavo vaita sifi keke wa aditoitaveyabina anafaiweya. E ada givebutu gaitoma moyaina givewavewaledi. ");
INSERT INTO bwd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mala givelavilavi aku yana tonogalayavo ielai Yeisu wagaine ivona, “Ida mwatugu kavovona wagaine kamiyamiya ada mala gibogibogi. ");
INSERT INTO bwd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kaliva uda imilidi idanau melala wagaidiya adiga ida kimone.” ");
INSERT INTO bwd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aku Bana gilufata wagaidiya, givonaga, “Imi taumiyavo aa wana veledi inakani.” Badi ivona, “Gavaiyamu, nuwanuwa ananau ada mani lakaina ana segena aa wagaine, ada ana veledi inakani?” ");
INSERT INTO bwd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ada Yeisu givonedi, “Gavaiyei beledi wagaimiya? Wanana wanalele.” Ada inau ke beledi ilelena ada inuwagadi, ada iyewadi Yeisu wagaine imatawena, ivona, “Beledi faifi ada igana iluwei.” ");
INSERT INTO bwd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ada Yeisu yana tonogalayavo givonedi, “Kaliva wana vutugedi yoo yoo wagaidiya ada ina vetoga talaguwaleya.” ");
INSERT INTO bwd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ada yoo ivutugedi ivetoga tufodi analedi (100), tufodi fifiti (50). ");
INSERT INTO bwd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ada Yeisu beledi faifi ke igana iluwei givaidi ada giitalaka gabama wagaine aku givona vesiule Yaubada wagaine, ada beledi gikiineinedi ke giveledi tonogalayavo ke badi ivutugena kaliva wagaidiya. Kadu igana anafaiweya, gikiineinena ke givutuga moyaidi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ada moyaidi ikani ke kamodi ifata. ");
INSERT INTO bwd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ada tonogalayavo inau beledi ke igana aditufo ikwakwana ani fuwama tuwelo ivemagadi. ");
INSERT INTO bwd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Badi kaliva gaga beledi ikanina ani adiyoo faifi tausani (5,000). ");
INSERT INTO bwd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ada kani muline, maduga-mowa Yeisu yana tonogalayavo waka wagaine giveyagedi ke wai inanago ina damana lavu fafaline melala anayegana Bedesaida wagaine, aku Banae ginamiya ke yoo gina imilidi ina vebiawaawala. ");
INSERT INTO bwd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ada kaliva givetalakafoiyedi, aku anakaibe gilaka oya wagaine ke gina veoveola Tamana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ada bademowa mala gibogi aku tonogalayavo lavu nefanine waka wagaine, aku Yeisu anakaibe-mowa avaleya. ");
INSERT INTO bwd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Aku giitadi yana tonogalayavo voi wagaine ivenuwakalikali velemoena, faina mala gilubibibi wadebaidiya-deya ke giluveyeveyewadi. Ada malalavuga anafafali wagaine Banae ani lavu getane givaga-mowa ada ginaunau wagaidiya. Ada evona vaita gida nugulidi ");
INSERT INTO bwd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","aku tonogalayavo iitana lavu getane ginunudadana, ada yadi nuwanuwa vaita balauma. E ada ikwekwela, ");
INSERT INTO bwd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","faina matatabudi iitana ada imatauta lakaina. Aku maduga-mowa givona wagaidiya, givona, “Wana asevatu, ida Iya Tauku. Keke wana matauta.” ");
INSERT INTO bwd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ada ginau wagaidiya ke waka wagaine giyage ani au mala giatagona. Ada meyadi gisidobodobona, ");
INSERT INTO bwd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","faina keke nuwadi gidamali tova-nai beledi gikiinena wagaine. Au aseasedi ikuga. ");
INSERT INTO bwd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ada lavu italadamanina ke inau fafaline Genesaleti taliyeya ada waka ilomuna. ");
INSERT INTO bwd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aku waka wagaine idaobu ani maduga-mowa kaliva Yeisu iitainanana, ");
INSERT INTO bwd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ada imadu inau yadi fafali moyaina wagaidiya yadi toveogayavo adiivi wagaidiya iwaidi ialiyedi gadedeku inogalina Yeisu gimiyamiya wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ada gadamamauwe Yeisu ginaunau, kai melala kabisodi o lakaidi o kai awaawana wagaidiya, ani toveoga ialialiyedi ke melala nefanine isesedi. Ada iveoveolena toyogina vaita toveoga gina awaegedi ke ananuya bwatana-ga nimadididi inasena wagaine. Ada badi gavega nimadididi isena ani matatabuna iveiwaka. ");
INSERT INTO bwd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tova seyana Falisiyavo ke veimeya anatovewalayavo tufodi ielai Yelusalema-deya ada ivagauta Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","E aku iitana yana tonogalayavo tufodi ani nima anaikola anaveimeya keke ida muliye aku au ikanikani. E ada badi yadi nuwenuweya vaita tonogala-dina Yaubada matane wa nima bwanenedi ikanikani. ");
INSERT INTO bwd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Faina Falisiyavo ke meIsileli matatabudi adigiduwa tuwaina-deya yadi kaliva lakaidiyavo wagaidiya anafaiweya, nagona nimadi inakola-dewedewedi, muliya inakani. ");
INSERT INTO bwd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kai inayewa maketi anafafali wagaine, aga keke ina madukani aku nagona taudiyavo inakola-dewedewedi. Ada kaduwe yadi veimeya moyaina iitaitaveyabidi, anafaiweya vei, tuwava, nauwa, ke ivi ikolakoladi yadi tafalolo anaveimeya anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Taidei faina Falisiyavo ke veimeya anatovewalayavo itolidadanena Yeisu, ivona, “Gavana faina ya tonogalayavo keke ida muliye yada kaliva lakaidiyavo adigiduwa anaveimeya? Faina wa nima bwanenedi ikanikani.” ");
INSERT INTO bwd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeisu givonediga, “Aiseya gifalofisai ke givetokilumina vona velemoena imi meyalugaluga faimiya. Falofisai-nai wagaine Yaubada givona, ‘Ida yoo-nai ani awakebuladiya ivemoimoineku, aku aseasedi ani imiya atuwada Iya wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yadi vewala ani keke Iya Yaubada yaku nuwanuwa wagaine aku au kaliva-mowa yadi nuwenuweya. E ada Iya wagaikuya ioduodu-wayoga.’ ");
INSERT INTO bwd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ada Yaubada yana veimeya tabu wasemuliyena, aku kaliva-mowa adigiduwa tuwaina wakiveyabina toyogina.” ");
INSERT INTO bwd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ada Yeisu givonedi, givonaga, “Imiyavo Yaubada yana veimeya waseseliyena e ada taumiyavo amigiduwa tuwaina wana itaitaveyabina. E aku gavaiyamu, wanuwanuwa vaita taide wai-nai ani iwakana faimiya? Keke. ");
INSERT INTO bwd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Faina tuwaina Yaubada yana veimeya Mosese giawamogatalena, givona, ‘Ina ke tama una vemoimoinedi.’ Kaduwe veimeya seyana ani, ‘Kai gaito inana o tamana wagaidiya ginavona awadamana, aga banae gilubodana gina alika.’ ");
INSERT INTO bwd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Aku imiyavo ani wavona vaita kai kaliva inana o tamana gina vonedi ginavona, ‘Gava yaku giba wagaine vaita gada lememi, taine yaku nuwakabubu-nai bade gaawaegena Yaubada wagaine. Taide faina keke akufaiweya gana lememi.’ ");
INSERT INTO bwd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ada tayuwe wagaine Yaubada anayeganeya seba wasesena, e ada kaliva inana ke tamana keke gida vemoimoinedi ke yana leme gida veleveledi. ");
INSERT INTO bwd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ada taidei amigiduwa-nai tamamiyavo nagona wagaidiya wavesesedamani waaliyena, aku Yaubada yana vona ani anaveimeya wavegaitoma-kavokavovoyena. Kaduwe gaitoma moyaidi anafaiweya wagugaiyedi.” ");
INSERT INTO bwd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ada kaduwe Yeisu yoo gidouwedi ke ivagauta wagaine ada givonedi, “Moyaimi, yaku vona wana nogalina ada nuwami gina malina. ");
INSERT INTO bwd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Keke tamo gava aa kaliva ina kanina e ani Yaubada matane gina kivebwanenedi. Aku gavana kaliva aseasedi negenidiya imiyamiya e aku ina yegemona, taine Yaubada matane gina kivebwanenedi.” ");
INSERT INTO bwd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Taidei anafaiweya Yeisu givona aku yoo gisegedi ke giluku manuwa wagaine, ada yana tonogalayavo itolidadanena yana vona matalivulivuna-nai faina. ");
INSERT INTO bwd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ada Yeisu givonedi, givona, “Taumada, imi kaduwe nodi keke nuwami gidamali. Gavaiyamu, keke wada alamane vaita gavana kai ginaluku kaliva awadiya ani keke gina kivebwanene Yaubada matane? ");
INSERT INTO bwd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Faina tova-nai ginaluku, keke aseasedi wagaidiya ginana aku ginanau kamodi wagaidiya ada gina yegemona.” Ee, yana vona taidei wagaine Yeisu giawamogatala vaita keke tamo aa awaawatana, aku aa matatabuna ani yegayegadi Yaubada matane kani faina. ");
INSERT INTO bwd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ada kaduwe givona, “Aku gavadi ina yegemona kaliva nuwainagediya ani gaitoma-dina kaliva ikikivebwanenena. ");
INSERT INTO bwd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Faina kaliva nuwainagediya-deya ani nuwanuwa koyodi iyegeyegemona, anafaiweya vovo anaawaege-kavokavovo, baninivula, kiyafu, luvealika, udo, ");
INSERT INTO bwd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","italuvadiga, dewa koyona, fwaya, gadawedawelo, nuwalaka, dewa kavokavovo, kaliva anaveloi ani anayegana anakivekoyo faina. Ada kaduwe, kaliva yadi giba o kai adiivi iitaitaluvadigedi e ada iagouga faidiya. ");
INSERT INTO bwd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Taidei gaitoma-dina koyodi moyaidi iyegeyegemona kaliva nuwainagediya, ada ikikivebwanenena Yaubada matane.” ");
INSERT INTO bwd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ada Yeisu fafali-nai gisegena aku ginau melala Taiya anafafali wagaine. Ada ginau manuwa seyana wagaine giluku, ada keke nuwanuwana tamo gaito gina alamane vaita Banae wadedeku-deya gimiyamiya, aku keke anafaiweya sewasewavuyena gina miyami. ");
INSERT INTO bwd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aku vavine seyadi, badi natudi vavine kabisona ani aluwaluwa bwanebwanenena nafone gimiyamiya. Badi inogalina Yeisu valeyana, ada maduga-mowa ielai wagaine ke agena wagaine iiboula-mowa. ");
INSERT INTO bwd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Vavine-dina badi vine Gilisi, aku Fonisiya itubuga, Siliya anafafali wagaine. Ada Yeisu ialamamaiyena vaita natudi wagaine aluwaluwa koyona gida veyegemonina. ");
INSERT INTO bwd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bana givonedi, givona, “Gilubodana nagona biyabiyama adiga inakani. Keke gida luboda biyabiyama adiga kanavai kana batuge galuweta wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Badi ivona, “Ika, Kauveya. Aku galuweta teibeli dibune ani biyabiyama adimukumuku ikwakwakwa.” ");
INSERT INTO bwd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ada Yeisu givonedi, “Yami vona taidei faina ada wananau yami manuweya. Aluwaluwa koyona bademowa giyegemona natumi wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ada vavine iyewadi yadi manuweya ada inuwagana natudi gidaudau ivi wagaine, aku bademowa aluwaluwa koyona kwamana wagaine giyegemona ke ginau. ");
INSERT INTO bwd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ada Yeisu Taiya anafafali gisegena aku gigolota Saidoni ada ginau Lavu Galili wagaine, tayuwe Dekafolisi anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ada wadedeku-deya kaliva seyana tagana kuluna ada meyana gidalu ani ialiyena Yeisu wagaine. Ada ialamamaiyena vaita nimana ginasena wagaine ke gina kiveiwakanena. ");
INSERT INTO bwd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ada Yeisu kaliva giabi ginauwena maita tabae aku yoo gisegedi, ada nimadidina gisedi tagana wagaidiya e ayo nimadidi gikiwalidi ke gisedi kaliva meyana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ada giitalaka gabameya ke giluyawai aku givona, “Efata!” Vona taidei anakivila, ‘Gina ayavuni!’ ");
INSERT INTO bwd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ada maduga-mowa kaliva tagana giafoledi ada giifufu dewadewa. ");
INSERT INTO bwd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ada Yeisu kaliva giawatadi keke tamo gaito inavone, aku auwe badi iifuifufuyedadanena kaliva wagaidiya. Tova ke tova giawaawatadi aku auwe badi ikwagekwageye-moena. ");
INSERT INTO bwd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ada badiyavo gavega valeya-nai inogalina ani meyadi gisidobodobona lakaina ada ivonaga, “Yana gugai matatabuna iwakadi! Badi tagadi kuludi inoganogala ke gaugaudiyavo iifuifufu!” ");
INSERT INTO bwd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tayuwe tova-nai wagaine, aimo kaduwe seyana yoo lakaina ivagauta Yeisu wagaine. Ada imiyamiya aku adiga giavaina, e ada Yeisu yana tonogalayavo gidouwedi ielai, ada givonedi, givona, ");
INSERT INTO bwd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yoo taidei ganuwakalikaliyedi, faina tova malinai bademowa yadayada toiye nodi kamiyamiya ada keke tamo aa gidatufo ayo inakani. ");
INSERT INTO bwd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kai wa mafalavugidiyavo gana imilidi inayewa yadi melaleya aga aimo waiya inaala. Faina tufodi atuwadeya ielai.” ");
INSERT INTO bwd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yana tonogalayavo ilufata, “Ida mwatugu kavovona wagaine kamiyamiya. E ada gadedeku aa kanavai ayo yoo taidei kana vekanidi?” ");
INSERT INTO bwd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeisu gitolidadanedi, “Gavaiyei beledi wagaimiya?” Badi ivona, “Beledi seveni idauwe.” ");
INSERT INTO bwd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ada yoo givonedi ke ivetoga babi wagaine aku beledi seveni givaidi ke givona vesiule Yaubada wagaine. Muliya gikiineinedi ke giveledi yana tonogalayavo ina vutugena yoo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ada kaduwe badi wagaidiya igana kabisodi toiye, ani Yeisu givaidi ke givona vesiule faidiya, ada tonogalayavo givonedi kaduwe ina vutugena. ");
INSERT INTO bwd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ada moyaidi ikani ke adifaiweya matatabudi, ada mukumukuna aditufo ivagauwina ada fuwama seveni ivemagadi. ");
INSERT INTO bwd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ada kaliva-dina adiyoo anafaiweya fowa tausani (4,000). Ada Yeisu giimilidi iyewa. ");
INSERT INTO bwd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aku maduga-mowa yana tonogalayavo nodi waka wagaine iyage ada inau Dalimanuta anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Aku Falisiyavo tufodi ielai ada ivebutu Yeisu nodi ivevonavona. Nuwanuwadi ina galuvaluvana faina, iveolena ke gugai ebameyasidobodobo seyana Yaubada wagaine gida faisewana. ");
INSERT INTO bwd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ada Yeisu giluyawai lakaina aku givonedi, “Gavana faina imi tova malinai anakaliva nuwanuwami iyaiyaya ebameyasidobodobo? Gavonemi velemoena, keke tamo iyaiyaya wana nuwaga.” ");
INSERT INTO bwd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ada gisegedi aku giyage-vagila waka wagaine ada idamana lavu fafaline. ");
INSERT INTO bwd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aku tonogalayavo nuwadi givulu ada keke tamo beledi idavai awaga faina, aku beledi seya-moena gitufo waka wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ada Yeisu givonamatawedi, givona, “Taumiyavo wana itaveyabimi badi Falisiyavo ke Elodi adifalawa anayisti wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ada badi tonogalayavo ivebutu taudiyavo gaga wagaidiya ivonavona, ivona, “Taidei anafaiweya givona, faina keke tamo beledi kada aliye.” ");
INSERT INTO bwd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aku Yeisu yadi nuwanuwa gialamanena e ada givonedi, givona, “Gavana vuvuna waveifuifufu amibeledi keke wadavai faina? Gavaiyamu, aimo keke wadaita ke wada alamane, ada aimo keke nuwami gidamali? Aseasemi gikuga ani gavana vuvuna? ");
INSERT INTO bwd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Imi wa matami aku kai keke wadaita? Ada kaduwe wa tagami aku kai keke wada nogali? Ada gavaiyamu, kai keke amifata wana nuwaududu? ");
INSERT INTO bwd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tova-nai beledi faifi gakiineinena kaliva faifi tausani (5,000) faidiya, ani mukumuku wagaine gavaiyei fuwama wavemagadi?” Ada ivonena, “Tuwelo.” ");
INSERT INTO bwd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bana givona, “Kaduwe beledi seveni gakiineinedi kaliva fowa tausani (4,000) faidiya, ani mukumuku wagaine gavaiyei fuwama wavemagadi?” Ada ivonena, “Seveni.” ");
INSERT INTO bwd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yeisu givonedi, “Gavaiyamu-yo aimo keke nuwami gidamali?” ");
INSERT INTO bwd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ada melala Bedesaida wagaine ielai aku kaliva tufodi ani kaliva seyana matana koyo-moena ialiyena Yeisu wagaine, ada ialamamaiyena vaita nimadidina gidasedi bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeisu kaliva-nai matana koyo-moena nimane gikiveyabina ada melala-nai wagaine iyegemona ke inau wamelaleya. Ada wadedeku-deya Yeisu kaliva-nai matana gikiwalidi ada nimana gisedi kaliva wagaine aku gitolidadanena, “Gavaiyamu, afaiweya gavana tamo una itana?” ");
INSERT INTO bwd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ada kaliva-nai giitadadana ada givona, “Kaliva gaitaitadi aku adiita vaita ai ida nunudadana anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ada Yeisu nimana gisevagiledi kaliva matane, ada kaliva-nai matana gimalina ke gaitoma matatabuna giita-dewedewedi velemoena. ");
INSERT INTO bwd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ada Yeisu kaliva-nai givonena, “Keke una yewani melala wagaine aku unanau ya manuweya.” ");
INSERT INTO bwd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ada Yeisu yana tonogalayavo nodi inau melala-dina Sisalia-Filipai anafafali wagaidiya. Ada wai wagaine inaunau aku yana tonogalayavo gitolidadanedi, givonaga, “Wana voneku, gavaiyamu kaliva ivonavona evona vaita Iya gaito?” ");
INSERT INTO bwd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Badi ivonena, “Tufodi ivona vaita Oye Iyoni Tobabitaiso, aku tufodi ivona vaita Oye falofita Ilaitiya, kaduwe tufodi ivona vaita Oye tova tuwaina anafalofita seyana.” ");
INSERT INTO bwd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ada kaduwe gitolidadanedi, givona, “Aku imiyavo, gavaiyamu wavonavona, evo Iya vaita gaito?” Ada Pita gilufata, “Oyeni ani au Mesaiya.” ");
INSERT INTO bwd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeisu vona-nai giluyabuna, ada veimeya toyogina giveledi, givona, “Keke tamo gaito wagaine wana awatalatalaina faikuya.” ");
INSERT INTO bwd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ada givebutu yana tonogalayavo givewaledi, givona, “Banae Kaliva Natuna anaveimeya givaina ke gaitoma moyaina gina uloloyedi kaliva nimadiya. Badi meIsileli yadi kaliva lakaidiyavo, ke Yaubada yana veyavo anatovegugai lakaidiyavo, kaduwe veimeya anatovewalayavo, ani nodi ina awaididiyena. Ada ina luvealikana, aku yadayada anaveto wagaine alikeya ginayawa-vagila.” ");
INSERT INTO bwd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yeisu yana vona-dina gikivemalina velemoena wagaidiya, aku bana Pita ani Yeisu givagaule ginauwena tabae ada givebutu giduweyena. ");
INSERT INTO bwd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aku Yeisu gimiyavilana ada yana tonogalayavo giitadi aku giduweyena Pita, givona, “Seitani, una segeku unanau tabae! Ida ya nuwanuwa ani keke Yaubada yana nuwanuwa anafaiweya, aku kaliva-mowa yadi nuwanuwa.” ");
INSERT INTO bwd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ada Yeisu yana tonogalayavo ke yoo nodi gidouwedi, ada ivagauta wagaine aku givonedi, “Badi gavega nuwanuwadi inaela ina muliyeku, ani gilubodana taudiyavo yadi nuwanuwa ina dibusoyogedi aku taudiyavo adikelose ina avalana ke ina muliyeku. ");
INSERT INTO bwd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Faina badi gavega nuwanuwadi taudiyavo yawaidi ina kibababaledi, ani yawaidi ina nusegedi. Aku gavega yawaidi ina nusegena Iya faikuya ke valeya iwakana faine, ani yawaidi ina kibababaledi. ");
INSERT INTO bwd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Faina kai gavega babi anagiba matatabuna inavai-yabudi aku taudiyavo yawaidi adikibababala-vagata ida nusegedi, aga gavana anaiwakana? Au keke. ");
INSERT INTO bwd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kai yawaidi adikibababala-vagata ina nusegena, aga keke tamo fatana anafaiweya inasei ayo yawaidi kaduwe ina nuwaga. ");
INSERT INTO bwd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ada kai badi gavega Iya faikuya ke yaku vona faina ina vovomumu ke ina veweyeku tova malinai anakaliva koyodiyavo ke udoudodiyavo matadiya, aga aimo kadu Banae Kaliva Natuna gina vovomumuyedi ke gina veweyedi. Taidei gina yegemona tova-nai ginaelai Tamana yana iwakana mamalina wagaine ada yana anelose tabutabudiyavo nodi.” ");
INSERT INTO bwd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ada kaduwe Yeisu givonedi, givona, “Gavona velemoena wagaimiya, tufomi idedeku wamidimididi ani aimo keke alika wanamadu lutovoni, aku nagona wana itana Yaubada yana ebaveimeya wa yana toyogina gina yegemona.” ");
INSERT INTO bwd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ada yadayada sikisi giavaidi, Yeisu yana tonogalayavo aditoto Pita ada Iyemesa ke Iyoni givagauledi ada nodi ilaka oya lakaina wagaine. Ada wadedeku-deya adiloi matadiya aku Yeisu anaita gisevedavedama. ");
INSERT INTO bwd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ada ananuya gikwayafofolidi ke gilunamanamaledi, ani keke tamo gaito babi matatabuna wagaine ginakola anaita anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ada aditoto matadiya aku Yaubada yana kalivayavo adiselu tova tuwaina wagaine imiyamiya, tainei Mosese kadu Ilaitiya, ani iyegemona ada Yeisu nodi iifuifufu. ");
INSERT INTO bwd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ada au Pita Yeisu givonena, “Labai, ida iwaka-moena faina ime nodi idedeku. Ada vada toiye ana yogodi, seyana O fainiya, seyana Mosese faine, kaduwe seyana Ilaitiya faine.” ");
INSERT INTO bwd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Taidei anafaiweya givona faina keke gida alamane gavana gina vonaye, e ada givona-kavokavovo. Faina tubuiyanavo nodi imatauta-mowa. ");
INSERT INTO bwd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ada buibui giyegemo ke gibwatavudi, ada bonabona giyegemona buibui wagaine-deya, givonaga, “Taidei ani Iya Natu aseaseku. Bonana wana nogalina.” ");
INSERT INTO bwd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ada maduga-mowa iitadadana vaita gaito nodi ida itana aku keke, au Yeisu anakaibe-mowa. ");
INSERT INTO bwd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ada itauya oyeya-deya iobuobuelai aku Yeisu giveimeyedi, givona, “Gavana waitana ani keke seyana gaito wana vonevone analaba Banae Kaliva Natuna ginayawa-vagila alikeya. Aku muliya ani iwakana, wana awamogatalena.” ");
INSERT INTO bwd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ada yana veimeya imuliyena ke taudiyavo gaga wagaidiya ikavuyena, aku taudiyavo ivetolitoli ‘alika muline yawa-vagila’ anaalamana faina. ");
INSERT INTO bwd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ada Yeisu itolidadanena, “Gavana faina veimeya anatovewalayavo ivona vaita gilubodana Ilaitiya gina maduelai aku muliya Mesaiya ginaelai?” ");
INSERT INTO bwd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ada Yeisu gilufata, givona, “Ina vona velemoena, Ilaitiya gina maduelai ke gaitoma matatabuna gina sedewedewe-vagiledi. Aku gavana faina Buki Tabu wagaine ivona vaita Banae Kaliva Natuna aimo gaitoma moyaidi gina ulouloloyedi lakaina, ada kaliva ina awaididiyena? ");
INSERT INTO bwd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aku Iya gana vonemi, Ilaitiya bademowa gielai, ada gavana anafaiweya kaliva yadi nuwanuwa koyona ani igugaiyena wagaine. Tainei anafaiweya Bana faine Veyavo Anawai Tuwaina anaBuki wagaine ivetokilumina.” ");
INSERT INTO bwd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ada Yeisu yana tonogalayavo aditoto nodi oyeya-deya iobuelai, inuwagadi tonogala velugadiyavo yoo lakaina nodi, ani Mosese yana veimeya anatovewalayavo nodi ivevonavona. ");
INSERT INTO bwd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aku kaliva moyaidi Yeisu iitana wagaine itataweyana, ada imadubodebode inau Bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ada Yeisu gitolidadanedi, givona, “Gavana wavevonavonaye nodi?” ");
INSERT INTO bwd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ada kaliva seyana yoo wagaidiya gilufata, givonaga, “Tovewala, natuku kaliva gaaliyena wagainiya, faina aluwaluwa koyona nafone gimiyamiya e ada natuku keke anafata gina ifufu. ");
INSERT INTO bwd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gavatoveya aluwaluwa-nai kwamana gina kidonedonena, aga gibaibaina babi wagaine aku awabugo gialaiwaiwagena. Kaduwe, gikudaligoligota, ada vovona matatabuna iyaviyavivila ke giitaita-vagata. E ada ya tonogalayavo gaveoledi vaita aluwaluwa-nai ida veyegemonina, aku keke adifata.” ");
INSERT INTO bwd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ada Yeisu givonediga, “Imi tova malinai anayooyavo ani yami vetumagana keke. Gavaiyei tova Iya nodi kana miyamiya? Gavaiyei tova gana atuvefailemi? Kwamana wana aliyena wagaikuya.” ");
INSERT INTO bwd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ada kwamana ialiyena Yeisu wagaine. Aku aluwaluwa-nai giitana Yeisu wagaine, maduga-mowa kwamana gigai givetatava lakaina, ada gibeu babiya ke gienokalikaliwawa aku awane buwobuwo giyalaiwaiwaigena. ");
INSERT INTO bwd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ada Yeisu kwamana-nai tamana gitolidadanena, “Gavaiyei tova anafaiweya gidewa?” Ada tamana givonaga, “Bebetane-deya givevuvu. ");
INSERT INTO bwd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ada tova ke tova aluwaluwa-nai kwamana gibatubatugena ai alalata o kai gufeya, faina nuwanuwana gina luvealikana. Aku kai afaiweya aga uda nuwakalikaliyema ke uda lemema.” ");
INSERT INTO bwd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ada Yeisu givonenaga, “Gavana faina uvona ‘Kai afata?’ Kai gaito wa yana vetumagana, aga gaitoma matatabuna meyameyaganina wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ada maduga-mowa kwamana tamana gitagivedavedadaga, givona, “Iya gavetumagana. Aku yaku vetumagana keke lakaina, e ada uda lemeku ke gida tubuga.” ");
INSERT INTO bwd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aku Yeisu giitadi yoo imadu ielaelai wagaidiya, e ada aluwaluwa bwanebwanenena giawatana, givonaga, “Oyeni aluwaluwa koyona kwamana tagana ukivekuludi ke agona usebodana, gaveimeyeni una yegemona kwamana wagaine ada keke kaduwe unaluku-vagila wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ada aluwaluwa koyona gikwekwela ke kwamana gigai givetatava lakaina aku giyegemona. Ada kwamana anaita vaita gida alika, e ada moyaidi ivonaga, “Wada bademowa gialika.” ");
INSERT INTO bwd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aku Yeisu kwamana-nai nimane gikiveyabi ke gisivemididina, ada gimididi. ");
INSERT INTO bwd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ada muliya Yeisu giluku seyana manuwa wagaine e au adiloi gaga, aku yana tonogalayavo itolidadanena, ivonaga, “Gavaiyamu-yo ime keke amafata aluwaluwa koyona ana veyegemoni?” ");
INSERT INTO bwd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ada gilufata wagaidiya, “Taine aluwaluwa koyona-nai ada badi kadu banae anafaiweya ani yadi toyogina lakaina, e ada veoveola gaga wagaine ada Yaubada gina veyegemonidi.” ");
INSERT INTO bwd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ada Yeisu yana tonogalayavo nodi fafali-nai isegena aku igolota Galili wagaine. Keke nuwanuwana kaliva ina alamane gadedeku imiyamiya, ");
INSERT INTO bwd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","faina yana tonogalayavo givewavewaledi. Givona, “Banae Kaliva Natuna ani ina atuegena kaliva nimadiya ada ina luvealikana. Aku yadayada anaveto wagaine ginayawa-vagila alikeya.” ");
INSERT INTO bwd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aku yana vona-nai faina ani keke nuwadi gidamali e aku anatolidadana imatausena. ");
INSERT INTO bwd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ada ielai Kafaneumi wagaine. Ada tova-nai badi yana tonogalayavo nodi manuweya imiyamiya, Yeisu gitolidadanedi, “Gavana waiya wavevonavonaye?” ");
INSERT INTO bwd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aku badi iveyamata, faina wai wagaine ivevonavona evona gaito wagaidiya anayegana lakai-moena. ");
INSERT INTO bwd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ada Yeisu givetoga aku tonogalayavo adituwelo gidouwevagauwidi ke givonedi, givona, “Badi gavega nuwanuwadi ina vetonagona, aga gilubodana ina vetomuliya ada ina vetogugai moyaidi wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ada kwamana kabisona giabi gialiyena ke tonogalayavo nefanidiya givemididina, ada nimana avalane gisena aku givonedi, givona, ");
INSERT INTO bwd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Badi gavega kwamana taidei anafaiweya akuyeganeya isivaivaina, ina Iya kadu isivaivaiku. Ada gavega Iya isivaivaiku, ina keke Iyayeku gaga ida sivaivaiku aku Banae giimiliku kadu isivaivaina.” ");
INSERT INTO bwd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ada Iyoni givonenaga, “Tovewala, ime kaliva aitana ani ayeganeya aluwaluwa koyodi giveveyegemonidi. Aku banae keke yada yoo wagaine, e ada aawatana.” ");
INSERT INTO bwd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ada Yeisu givona, “Keke wana awata, faina kai seyana gaito akuyeganeya gugai ebameyasidobodobo gigugaiyedi, aga banae aimo keke anafaiweya ginamadu awavekoyoyeku. ");
INSERT INTO bwd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Faina badi gavega keke ida venibaineda ani badiyavo adatoleme. ");
INSERT INTO bwd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ada gavonemi velemoena, badi gavega gufa ina veyumi faina imiyavo Keliso yana yoo, fatadi iwakana ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Aku kai kwamana seyana anafaiweya taidei givetumaganeku aku dewa koyona wagaine wanagai yana vetumagana wagaikuya gina segena, aga amimatavuloga vita-moena wana nuwagana Yaubada wagaine. Ebaita ganasena. Kai kabala lakaina ina yogovefosena odomiya ada wa kabalimi ina vekamomolimi leyageya wana alika, tainei vitana. Aku kai matavuloga Yaubada wagaine wana nuwagana, tainei vita-moena. ");
INSERT INTO bwd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","E ada kai nima seyana gina sitaitaini ke una koyokoyona, aga au una dabayavule una segena. Auwe wa nima seya-moena aku unamiya wa ya dewa iwakana ada unaluku yawai-vagata wagaine. Ina iwaka-vagaina ayo kai wa nima iluwei aku wa ya dewa koyona ani unaluku eli anaai alalata keke gida weuwe wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kaduwe, kai age seyana gina sitaitaini ke una koyokoyona, aga au una dabayavule una segena. Auwe wa age seya-moena faina felafela aku unamiya wa ya dewa iwakana ada yawai-vagata wagaine unaluku. Ina iwaka-vagaina ayo kai wa age iluwei aku wa ya dewa koyona ani ina batugeni unaluku eli wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ada kai mata seyana gina nagoyeni ke una koyokoyona, aga au una etomwamwali una segena. Auwe wa mata seya-moena aku wa ya dewa iwakana unamiya ada unaluku Yaubada yana ebaveimeya wagaine. Ina iwaka-vagaina ayo kai wa mata iluwei aku wa ya dewa koyona ani ina batugeni unaluku eli wagaine, ");
INSERT INTO bwd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","wadedeku ‘kaliva vovodi adimotamota itugatugadi ani motamota-dina keke ida alialika, ada kaduwe ai alalata keke gida weuwe.’ ");
INSERT INTO bwd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Aku imi yaku tonogalayavo ani moyaimi wagaimiya vita tulina tulina vaita ai alalata anafaiweya ina yegemona ke ina alailuvaluvami. E ada kai yami dewa vaita leyaga iwakana anadigadigaga anafaiweya o kai keke, ani gina seyegemonena. Taidei gina lememi ke wana veasekumaga. ");
INSERT INTO bwd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Leyaga gaitoma iwakana, aku kai leyaga anadigadigaga gina avaina, aga keke anafata kana kiveleyagi-vagile. Aku leyaga yegayegana anavegugai ani iwakana kaliva wagaidiya, ada kadu anafaiweya imiyavo wana dewadewa iwakana. Kaduwe kukuya wagaine wana miyamiya.” ");
INSERT INTO bwd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ada Yeisu Kafaneumi gisegena aku ginau Yudiya anafafali wagaine ke gidamana gufa Yolidani fafaline. E au yoo lakaina kadu ivagauta Bana wagaine, ada yana dewa tova moyaina anafaiweya, kaduwe givewavewaledi. ");
INSERT INTO bwd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aku Falisiyavo tufodi ielai Yeisu wagaine. Nuwanuwadi ina galuvaluvana e ada itolidadanena, ivona, “Gavaiyamu, adaveimeya giawaegau vaita kaliva vavinena gina viyoliliyedi?” ");
INSERT INTO bwd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ada Yeisu gilufata, givonediga, “Aku gava veimeya Mosese givelemi?” ");
INSERT INTO bwd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ada Falisiyavo ivona, “Mosese giawaegau kai gavakaliva nuwanuwana vavinena gina viyoliliyedi, aga viyolili anamatawa gina vetokilumina ada vavinena gina veledi ayo muliya gina imilidi inanau.” ");
INSERT INTO bwd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aku Yeisu givona wagaidiya, givona, “Imi aseasemi kugadi faina, nuwanuwami taumiyavo yami edaeda wagaine wana gugai. Taidei faina Mosese veimeya tainei givetokilumina faimiya. ");
INSERT INTO bwd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aku velemoena ibubuna vaguvagu anatova wagaine-deya, ani ‘Yaubada kaliva ke vavine gibubudi.’ ");
INSERT INTO bwd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Taidei faina kaliva inana ke tamana gina miyasegedi, aku ginanau ada vavinena nodi ina miyaluga ");
INSERT INTO bwd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ke adiselu ina vevovo seyana.’ Nagona adiselu imiya tulina tulina ada anaita ani iluwei, aku malinai iveseyana. ");
INSERT INTO bwd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Taidei faina, gavana Yaubada giavina ke givemiyalugedi, ani keke tamo gaito gida vemiyadakadi.” ");
INSERT INTO bwd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ada muliya Yeisu yana tonogalayavo nodi inau manuweya aku tonogalayavo itolidadanena viyolili faina. ");
INSERT INTO bwd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ada givona wagaidiya, givona, “Gavakaliva vavinena gina viyoliliyedi aku vavine evaguna gina nagina, wada giudo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ada anafaiweya kai vavine moganena gina viyoliliyena aku kaliva evaguna gina nagina, wada kaduwe giudo.” ");
INSERT INTO bwd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ada kaliva tufodi biyabiyama ialiyedi Yeisu wagaine ada vaita nimana ginasena wagaidiya ke gina awanuwakabubuyedi, aku tonogalayavo iawatadi. ");
INSERT INTO bwd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ada Yeisu giitana wagaine, keke gida vemwamwala e ada yana tonogalayavo giduweyedi, givonediga, “Keke biyabiyama wana awatadi aku wana awaegedi inaelai wagaikuya, faina Yaubada yana ebaveimeya anakalivayavo ani taide biyabiyama-dina anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gavona velemoena wagaimiya, kai gaito keke gina awaege Yaubada gina veiveimeya aseasene vaita kwamana kabisona anafaiweya, aga keke-bamowa ginaluku Yaubada yana ebaveimeya wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ada biyabiyama-dina giwaidi ada nimana gisena seyana seyana wagaidiya ke giawanuwakabubuyedi. ");
INSERT INTO bwd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ada wadedeku-deya Yeisu gitauya ginanau, aku kaliva seyana gimadu gielai ada tugana givetodonena Bana matane aku gitolidadanena, givona, “Tovewala iwaka, gavana analauboda ganagai ayo yawai-vagata gana nuwaga?” ");
INSERT INTO bwd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ada Yeisu gilufata, “Gavana faina uvona Iya iwakaku? Keke tamo gaito iwakana aku Banae Yaubada anakaibe-mowa. ");
INSERT INTO bwd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aku yana veimeya bademowa ualamanena, ‘Keke una luvealika, keke unaudo, keke una kiyafu, kaliva yadi gugai faidiya keke una awatalatalaina fwayafwaya, keke kaliva una fwayadi aku yadi giba una vaidi, ada kaduwe ina ke tama una vemoimoinedi.’” ");
INSERT INTO bwd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ada kaliva-nai givona, “Tovewala, yaku tova kwamana wagaine-deya gavebutu veimeya-dina taidei matatabuna gaitaveyabidi ada gielai malinai.” ");
INSERT INTO bwd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ada Yeisu kaliva-nai giitana ke ginuwakabubuyena ada givonena, “Gaitoma seya-moena wagaine o uvemaufo. Unanau ya lokoloko matatabuna una vekimoneyedi ke manina una veledi fanifani, e ada kaikaiwabu velemoena gabameya una nuwagana. Ada unaela una muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aku kaliva vona taidei ginogalina, ada au magigina gikokomina ke wa yana nuwavita nodi gitauya ginau, faina banae tokaikaiwabu lakaina. ");
INSERT INTO bwd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ada Yeisu giitadadana ada yana tonogalayavo givonedi, “Badi tokaikaiwabu yadi luku Yaubada yana ebaveimeya wagaine, ani au vitana velemoena.” ");
INSERT INTO bwd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aku tonogalayavo meyadi gisidobodobona yana vona faina. Aku kaduwe Yeisu givonedi, “Natukuweyavo, Yaubada yana ebaveimeya analuku ani vitana velemoena! ");
INSERT INTO bwd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wana itana, kevakeva lakaina anayegana kameli ani kai gina balalava ada vaita gaima matana wagaine gina lukufolega ani gavaiyamu, anafata? Keke. Ada tokaikaiwabu ani ananuwanuwa anafaiweya. Kai badi taudiyavo yadi toyogina wagaine ina balalava ke Yaubada yana ebaveimeya wagaine inaluku, ani ina balalava-wayoga.” ");
INSERT INTO bwd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ada Yeisu yana vona taidei faina, yana tonogalayavo meyadi gisidobodobona lakaina ke ivetolitoli taudiyavo wagaidiya, ivona, “Kai taidei anafaiweya, aga gaito anafaiweya kibababala gina nuwaga?” ");
INSERT INTO bwd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ada Yeisu giitafasedi aku givonedi, givona, “Kaliva wagaidiya ani gaitoma taidei keke maita meyameyaganina, aku Yaubada wagaine ani keke anafaiweya. Faina Banae wagaine gaitoma matatabuna meyameyaganina.” ");
INSERT INTO bwd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ada Pita givonena, givonaga, “Una itana, ime gaitoma moyaina asegedi ada aela O amulimuliyeni.” ");
INSERT INTO bwd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ada Yeisu givona, “Gavonemi velemoena, badi gavega inuwanuwa Iya faikuya ke valeya iwakana faina, e ada yadi manuwa isegedi o kai tubuiyadiyavo o novudiyavo, kai inadi o tamadi o natudiyavo, kai yadi babi isegedi, ");
INSERT INTO bwd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ani badi tova malinai gaitoma-dina fatadi analedi wa anavetutamwata ina vaina, anafaiweya manuwa, tubuiyadiyavo, novudiyavo, inadiyavo, natudiyavo, ada yadi babi. Kaduwe yadi awaega Iya wagaikuya faina, uloulolo ina nuwagana kaliva nimadiya. Ada aimo tova gielaelai wagaine yawai miyamiyani-vagaina ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aku moyaidi tova malinai wai inagonagona ani aimo tova gielaelai wai ina muline-mwena, aku badi gavega malinai wai imuli-mwena ani aimo tova gielaelai wai ina nagona.” ");
INSERT INTO bwd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ada Yeisu ginagoyedi ke ilakalaka Yelusalema aku yana tonogalayavo meyadi gisidobodobona, ada yoo nodi imuliyena ani imatauta. Ada yana tonogalayavo adituwelo kaduwe givonedi ielai wagaine ke gimatawedi aimoina gavana gina yegemo Bana wagaine faina. ");
INSERT INTO bwd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ada givonediga, “Wana nogalina. Ideyavo kalakalaka Yelusalema, ada Banae Kaliva Natuna ina atuegena veyavo anatovegugai lakaidiyavo ke veimeya anatovewalayavo nimadiya, ada ina veimeya analuvealika faina. Ada muliya inasena badi keke meIsileli nimadiya. ");
INSERT INTO bwd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ada badiyavo ina awaveleigena, ina kiwalina ke ina lubibiwalina, ada ina luvealikana. Aku yadayada anaveto wagaine ginayawa-vagila alikeya.” ");
INSERT INTO bwd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aku tova-nai wagaine Iyemesa ke Iyoni, badiyavo Sebedi natunavo, ani Yeisu wagaine ielai ada ivona, “Tovewala, nuwanuwama gavana ana veoleni aga uda gugaiyena faimeya.” ");
INSERT INTO bwd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ada gitolidadanedi, “Gavana nuwanuwami ganagai faimiya?” ");
INSERT INTO bwd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ada ilufata, “Uda awaegema ke aimo tova-nai wa ya iwakana mamalina una veiveimeya, ani ime amaiselu lilivaniya ada vetoga. Seyana aiyataginiya ke seyana aimauliniya.” ");
INSERT INTO bwd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aku Yeisu givona wagaidiya, givona, “Gavana waveola faine ani ananuwanuwa keke wada alamane. Gavaiyamu, aimo uloulolo anavei-nai wagaine ganayuga ani imi amiselu amifaiweya wana yugena? Ada kaduwe babitaiso-nai wagaine gana babitaiso ani amifaiweya wagaine wana babitaiso?” ");
INSERT INTO bwd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Badi adiselu ilufata, ivona, “Amafaiweya.” Ada Yeisu givona, “Vona velemoena, vei-nai wagaine ganayuga ani kadu imi wanayuga. Ada babitaiso-nai wagaine gana babitaiso ani imi kaduwe wagaine wana babitaiso. ");
INSERT INTO bwd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aku gaito aiyatagikuya gina vetoga ke gaito aimaulikuya, ina Iya keke yaku ebaveimeya, aku badi gavega Kamaku givenuwadadanedi ani faidiya gikidewedewena.” ");
INSERT INTO bwd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aku tonogalayavo aditeni inogalina wagaine, inuwakoyo Iyemesa ke Iyoni wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Au Yeisu gidouwedi ivagauta wagaine ada givonedi, “Waalamanena badi keke meIsileli aditoveimeyayavo ani iveiveimeya toyogina yadi kalivayavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aku imiyavo ani keke anafaiweya wanadewa. Aiyada badi gavega nuwanuwadi taudiyavo adiyegana lakaina amimwatuguya, gilubodadi ina vetogugai moyaimi wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ada badi gavega nuwanuwadi ina vetonagona, aga gilubodadi ina vetogugai yogoyogona moyaimi wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Faina Banae Kaliva Natuna giobuelai babiya, keke vaita kaliva ina gugai Banae faine, aku velemoena ani Banae gina gugai kaliva faidiya ada yawaina gina awaegena ke gina nusegena moyaidi aditutuveobu faina.” ");
INSERT INTO bwd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aku Yeisu yana tonogalayavo nodi inaunau aku melala anayegana Yeliko wagaine iyegemo. Ada melala-nai isege inaunau yoo lakaina nodi, aku kaliva seyana matana koyo-moena givetovetoga wai lilivane. Anayegana Batimiyo, bana Timiyo natuna. Tova moyaina banae mani faina giawaveoveola. ");
INSERT INTO bwd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aku tova-nai ginogalina Yeisu kwana Nasaledi gielaelai, givebutu givedoudou moiyalina, givona, “Yeisu, Oye Deivida yana tubudelideli, uda nuwakalikaliyeku!” ");
INSERT INTO bwd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aku kaliva moyaidi Batimiyo iduweyena, ivona, “Auwe! Gina kulu-moeni!” Aku bana keke. Bonana gilaka-mowa givedoudou, “Oye Deivida yana tubudelideli, uda nuwakalikaliyeku!” ");
INSERT INTO bwd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ada Yeisu au ginumididi ke givona, “Wanavone ginaelai.” Ada kaliva-nai matana koyo-moena idouwena ke ivonena, “Una vemwamwala ke una mididi unaelai! Givedovedou fainiya!” ");
INSERT INTO bwd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ada maduga-mowa ananuya badobadona giveyalilina aku gitowamididi gielai Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ada Yeisu gitolidadanena, “Gavana nuwanuwa ganagai fainiya?” Ada bana matana koyo-moena givona, “Labai, nuwanuwaku gadaita.” ");
INSERT INTO bwd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ada Yeisu givonena, “Iwakana, unanau. Ya vetumagana bademowa gikiveiwakaneni.” Ada maduga-mowa matana iveiwaka ada Yeisu gimuliyena wai wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yeisu yana tonogalayavo nodi ilakalaka Yelusalema faina, aku nagona melala kabisodi Bedani ke Bedipegi wagaidiya inuyegemona, tainei Oya Olive dibune. Ada yana tonogalayavo adiselu giimilidi ke wai ina nagona, ");
INSERT INTO bwd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","givonedi, “Imi wai wana nagona melala wadebaimiya wagaine, ada wana lukuluku ani wana nuwagana doniki natudi seyana isifona. Tainei kevakeva-nai evaguna, banae keke tamo gaito gidayage. Wana yavuna ada wana aliyena. ");
INSERT INTO bwd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ada kai tamo gaito gina tolidadanemi, ginavona, ‘Gavana faina wayavuyavu?’ au wana vonena, ‘Kauveya gina vegugaiyena tufona yana faisewa wagaine, ada tova kabisona gina imili-vagile ginaelai.’” ");
INSERT INTO bwd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ada adiselu inau ke doniki natudi inuwagana edawana lilivane isifona. Ada iyavuyavuna ani ");
INSERT INTO bwd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","kaliva tufodi lilivadiya imidimididi ivona, “Gavana faina doniki wayavuyavu?” ");
INSERT INTO bwd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ada Yeisu givona anafaiweya, adiselu ivonedi, ada wagaidiya iawaegena. ");
INSERT INTO bwd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ada doniki-nai inauwena Yeisu wagaine ada adinuya badobadodi iyavelidi domone ke Bana giyage. ");
INSERT INTO bwd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ada kaliva moyaidi yoo wagaidiya adinuya badobadodi iyavelidi waiya, aku tufodi ai lagadi wa lukudi ikuyadi ke wai wagaine isedi. ");
INSERT INTO bwd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ada yoo tufodi wai inagona Yeisu debaine kaduwe tufodi wai imulina, aku moyaidi iawadavadavana bonadi lakaina, ivonavona, “Osana! Banae gielaelai KAUVEYA anayeganeya ani wa anaawanuwakabubu! ");
INSERT INTO bwd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tamada nagona Deivida yana ebaveimeya gielaelai ani Yaubada giawanuwakabubuyena! Osana tabone-mwane!” ");
INSERT INTO bwd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ada Yeisu giyegemona Yelusalema ke ginau manuwa tabu wagaine giluku. Giitadadana ke gaitoma moyaina giitadi negenine aku bademowa mala givelavilavi faina, Bana yana tonogalayavo adituwelo nodi iyewadi Bedani. ");
INSERT INTO bwd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mala gilavuna, imididi ada Bedani-deya iyewayewa-vagila Yelusalema aku Yeisu mafa gilavuna. ");
INSERT INTO bwd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ada atuwadeya ai guwaguwa seyana anafaiweya alaa giitana, e ada ginau ke gina itana kai tamo guwana gina nuwagana wagaine. Aku luku gagana ginuwagana, faina anatutuya wagaine giyoyoyo ani aimo. ");
INSERT INTO bwd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ada givona ai wagaine, givonaga, “Keke tamo tova kaduwe unaguwa-vagila ke kaliva wagainiya inakani.” Ada vona taidei tonogalayavo inogalina. ");
INSERT INTO bwd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ada ielai Yelusalema ada Yeisu gina giluku manuwa tabu anafafali wagaine. Ada badi gavega ikimokimone ke ivevekimone ani giveyegemonidi, ada mani anatosevedavedama yadi teibeli gibwataviladi, ada kaduwe bunebune aditovedama yadi ebavetoga. ");
INSERT INTO bwd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ada giawatadi keke seyana gaito giba-dina gina waidi gina nugolota manuwa tabu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ada givewavewaledi, givona, “Yaubada bonana ivetokilumina Buki Tabu wagaine givonaga, ‘Yaku manuwa ani ina vewagana manuwa ebaveoveola babi anakaliva adiyoo moyaidi faidiya.’ ‘Aku imiyavo wagana vaita tokiyafu yadi manuwa.’” ");
INSERT INTO bwd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ada badi veyavo anatovegugai lakaidiyavo ke veimeya anatovewalayavo, ani Yeisu yana vona inogalina ada ivebutu wai ilele ina luvealikana faina. Aku imatausena, faina Yeisu yana vewala wagaine kaliva moyaidi meyadi gisidobodobona. ");
INSERT INTO bwd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ada bademowa mala givelavilavi ada Yeisu yana tonogalayavo nodi Yelusalema isegena. ");
INSERT INTO bwd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ada mala gilavuna malabutuya iyewayewa Yelusalema wai-nai wagaine aku ai-nai Yeisu gialatabutabuyena ani iitana, bademowa ai-moena matatabuna gimayewana. ");
INSERT INTO bwd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ada Yeisu yana vona ai wagaine ani Pita ginuwaududuna ada givonaga, “Labai, una itana! Ai-nai ualatabutabuyena ani bademowa gimayewana!” ");
INSERT INTO bwd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ada Yeisu gilufata, givona, “Yami vetumagana wanasena Yaubada wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gavonemi velemoena, gaito aseasene keke gida nuwakila, aku givetumagana vaita gavaiyamu ginavona ani anafaiweya gina yegemona velemoena, ani kai oya taidei gina vonena, ‘Tauni una abuni ke unana leyageya una togaobu’, aga au anafaiweya gina yegemona bana faine. ");
INSERT INTO bwd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tainei faina gavonemi, gavana wana veoveola faine ani wana vetumagana vaita bademowa wanuwagana, ada gina yegemona anafaiweya. Wana nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kaduwe, gavatoveya Yaubada wagaine wana veoveola aku wana nuwaududuna seyana gaito gidewa koyona wagaimiya, aga wana venuwaegena. E ada Tamami gabameya imi kaduwe yami koyona gina venuwaegedi. ");
INSERT INTO bwd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aku kai kaliva yadi koyona wagaimiya keke wana venuwaegedi, aga kaduwe Tamami gabameya imi yami koyona keke gina venuwaegedi.” ");
INSERT INTO bwd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ada kadu iyewa Yelusalema. Ada Yeisu gina giluku manuwa tabu anafafali wagaine ginunudadana, aku veyavo anatovegugai lakaidiyavo ada veimeya anatovewalayavo ke kaliva lakaidiyavo ielai Bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ada itolidadanena, ivona, “Ida gava veimeya wagaine gaitoma-dina taidei ugugaiyedi? Gaito veimeya taidei giveleni-yo ugugaiyedi?” ");
INSERT INTO bwd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ada Yeisu givonedi, “Iya kadu tolidadana seyana gana tolidadanemi gaitoma seyana faine. Kai wana lufata wagaikuya aga Iya kaduwe gana vonemi gava veimeya wagaine gugai taidei gagugaiyedi. ");
INSERT INTO bwd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wana voneku, Iyoni Tobabitaiso ani gaito veimeya givele ke kaliva gikivebabitaisodi? Yaubada o kaliva?” ");
INSERT INTO bwd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ada taudiyavo iveifuifufuyena, ivona, “Gavaiyamu kanavona? Kai kanavona ‘Yaubada veimeya givelena,’ aga ginavona, ‘E ada gavana faina Iyoni yana vona keke wada vetumagane?’ ");
INSERT INTO bwd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aku gavaiyamu, kai kadavona ‘Kaliva veimeya ivelena’?” Taidei anafaiweya ivona faina yoo imatausedi, faina ialamanena kaliva moyaidi ivetumagana vaita Iyoni banae Yaubada yana falofita seyana. ");
INSERT INTO bwd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","E ada ilufata Yeisu wagaine, ivona, “Keke ada alamane.” Bana givona, “E ada Iya kadu keke gana vonemi gaito yana veimeya wagaine gaitoma-dina taidei gagugaiyedi.” ");
INSERT INTO bwd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ada Yeisu vona matalivulivuna wagaidiya kaliva giifufuyedi, givona, “Kaliva seyana yana babi wagaine gileifi bulavadi analoi gibakulina. Bakula-nai gikalififina ada olu giyala giobu kabisona gileifi anaebavagafuwafuwa faina. Ada vada tulatulana giyogona e ada tofaisewa getane ina miyamiya aku matadi inasege ina nudadana bakula-nai anayavaga faina. Ada toni bakula gaitoma moyaina gibubudi giavaina, muliya kaliva tufodi nodi iveimeya ke bakula ina kidewedewena ada ina itaveyabina, aku ikolu anatoveya toni bakula-nai anavutuvutuga guwa ina velevelena. Aku tauna ani yana melala gisege ginau mali fafaliya gimiya. ");
INSERT INTO bwd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ada imiyamiya aku gileifi anaikolu anatova giyegemona, ada tonibakula-nai yana togugai seyana giimilina ginanau bakula anatoitaveyabina wagaidiya vaita anavutuvutuga gileifi guwana gina vaina, anafaiweya gavaiyamu yadi awaegena tova-nai veimeya ibubuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ada togugai-nai ginau wagaidiya aku toitaveyabina ikiveyabi ilumalimaliwavuna, ada keke idavele aku makagekagena iimili giyewa. ");
INSERT INTO bwd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ada kadu togugai anavelu giimilina toitaveyabina wagaidiya, aku banae kuluwana ilavuna ke idewa koyo-moena wagaine ada ikivevovomumuna. ");
INSERT INTO bwd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kaduwe togugai anaveto giimilina wagaidiya, aku banae iluvealikana. Ada kadu muliya tufona moyaidi giimilidi wagaidiya, aku tufodi ilumalimaliwavudi aku tufodi iluvealikadi. ");
INSERT INTO bwd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aku kaliva seya-moena gimiyamiya, banae natu aseasena. Muline-mwane banae toitaveyabina wagaidiya giimilina, givona, ‘Ida natuku, ada ina vemoimoinena.’ ");
INSERT INTO bwd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Aku natuna ani tova-nai giyegemona ada toitaveyabina-dina iitana, taudiyavo iveifuifufu, ivona, ‘Ida tau-moena toni laova, ada aimo bakula taidei ginavai gina veimeyena. E ada wanaela kana luvealikana ada yana bakula kana vaina.’ ");
INSERT INTO bwd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ada au ikiveyabi iluvealikana ke itai iyegemonena gileifi anabakula wagaine.” ");
INSERT INTO bwd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yeisu yana vona matalivulivuna giluyabuna aku gitolidadanedi, givona, “E ada tonibakula-nai gavana ginagai? Vona velemoena kaliva-nai ginaelai ada bakula anatoitaveyabina-dina gina luvealikadi, aku gileifi anabakula-nai ani toitaveyabina evagudi nimadiya ginasena. ");
INSERT INTO bwd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kai vona seyana Buki Tabu wagaine keke wada veyawa, givonaga, ‘Ogola-nai manuwa toiyogona idibusoyogena ani banae gimidinagona ogola velugadiyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ida KAUVEYA yana gugai, ada matadeya ani iwaka-vagaina.’” ");
INSERT INTO bwd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ada meIsileli aditonagonayavo Yeisu yana vona matalivulivuna inogalina wagaine, nuwadi gimalina vaita badi faidiya givonavona. Tainei faina wai ilelena vaita ina kiveyabina, aku yoo imatausedi. E ada imadusege inau. ");
INSERT INTO bwd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ada tonagonayavo iimilidi Falisiyavo tufodi ke Elodi yana kalivayavo tufodi, e ada yadi tolidadana wagaine Yeisu ina vebavuna ke vona gina sidamanena. ");
INSERT INTO bwd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ada ielai Bana wagaine ivonena, “Tovewala, ime aalamanena Oye uvonavona velemoena. Keke uda vefwayafwaya. Ada kai kaliva anayegana lakaina o kai keke, keke uda nuwanuwa faine e ada keke uda venuwana gavaiyamu ina nuwanuwa, aku au Yaubada yana wai faina uvevewala tunutunugina. E ada gavaiyamu, ide meIsileli adaveimeya Mosese wagaine, ani giawaegeda ada Sisa wagaine takesi kana lufata o kai keke? Takesi-nai kada fatana kai keke?” ");
INSERT INTO bwd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aku Yeisu bademowa yadi meyalugaluga gialamanena, ada gitolidadanedi, givona, “Gavana faina wagaluvaluvaku? Nika, mani-nai wana aliye gana itana.” ");
INSERT INTO bwd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ada mani-moena ialiye ivelena. Bana gitolidadanedi, givona, “Gaito taidei anununa? Ada gaito taidei anayegana ivetokilumi?” Badi ilufata ivona, “Sisa.” ");
INSERT INTO bwd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Banae givonedi, givona, “Gavana Sisa yana gaitoma aga wana velena Sisa, aku gavana Yaubada yana gaitoma aga wana velena Yaubada.” Ada Yeisu yana vona taidei faina meyadi gisidobodobona. ");
INSERT INTO bwd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ada Sadusi tufodi ielai Yeisu wagaine, badi ivetumagana evona kaliva yadi alika muline keke inayawa-vagila. Ada biyavo-dina itolidadanena ivona, ");
INSERT INTO bwd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tovewala, Mosese veimeya seyana givetokilumina faideya givona, Kai kaliva seyana vavinena gina alikalovena aku keke tamo natuna, aga gilubodana kaliva-nai anatubuluga sikwana gina nagina, ada tubuiyana fatana faina natunavo gina vetubudi. Taidei wagaine ada toalika yana tubudelideli ina miyamiya.” ");
INSERT INTO bwd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ada ebaita ivelena, ivona, “Seyana kaliva anatubulugayavo nodi adiseveni. Ada tomoinagona ginagi ada natunavo keke aku gialika. ");
INSERT INTO bwd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ada sikwana ani taina anavelu ginagina, ada natunavo keke aku gialika. Ada anafaiweya taina anaveto, natunavo keke aku gialika. ");
INSERT INTO bwd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ada kaduwe anafaiweya tainavo matatabudi, sikwa-nai inagina ani ialika aku natudiyavo keke. Muline-mwane kadu vavine gialika. ");
INSERT INTO bwd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","E ada yawa-vagila anatoveya ani gavakaliva vavinena? Faina adiseveni-dina vavine-nai inagina.” ");
INSERT INTO bwd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aku Yeisu gilufata wagaidiya, givona, “Taidei yami sidamana, faina Buki Tabu keke wada alamane ada kaduwe Yaubada yana toyogina keke wada alamane. ");
INSERT INTO bwd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Faina tova-nai toalika inayawa-vagila, keke ina naginagi kadu keke ina vevenagi, aku au yadi miya vaita Yaubada yana aneloseyavo gabameya anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aku toalika yadi yawa-vagila faina, maita waveyawana Mosese yana buki wagaine o kai keke? Tova-nai Mosese fafali kavovona wagaine ginunudadana, aku ai kabisona giyabeyabela wagaine-deya Yaubada bonana giyegemona bana wagaine, givona, ‘Iya Ebelaamo yana Yaubada, Aisake yana Yaubada, ke Iyakobo yana Yaubada.’ ");
INSERT INTO bwd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ada Yaubada ani keke kaliva alialikadiyavo yadi Yaubada, aku velemoena Banae ani kaliva wayawaidi yadi Yaubada. Ada imi yami vewala gaitoma taidei faina ani wasidamanena velemoena.” ");
INSERT INTO bwd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ada Mosese yana veimeya anatovewala seyana gielai wagaidiya ada yadi vevonavona ginogalina. Ada kaduwe Yeisu yana laufata iwakana ginogalina, e ada bana kaduwe gitolidadana Yeisu wagaine, givona, “Veimeya moyaina Yaubada Mosese givelena wagaidiya ani gava veimeya lakai-moena?” ");
INSERT INTO bwd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ada Yeisu gilufata, givona, “Veimeya lakai-moena taidei anafaiweya. ‘Imi meIsileli wana nogalina. Yada KAUVEYA Yaubada anakaibe-mowa. ");
INSERT INTO bwd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ada KAUVEYA Banae ya Yaubada una nuwakabubuyena asease matatabuna wagaine ke aluwaluwa matatabuna wagaine, kadu nuwa matatabuna wagaine ke ya toyogina matatabuna wagaine.’ ");
INSERT INTO bwd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ada veimeya lakaina anavelu ani taidei anafaiweya. ‘Kaliva una nuwakabubuyedi o tauni unuwakabubuyeni anafaiweya.’ Veimeya iluwei taidei, ani veimeya matatabuna itubusegedi.” ");
INSERT INTO bwd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ada veimeya anatovewala-nai Yeisu yana vona ginogalina ada givona, “Tovewala, ya vona tainei ani vona velemoena, faina Yaubada anakaibe-mowa ada keke tamo kaduwe. ");
INSERT INTO bwd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ada gilubodana kana nuwakabubuyena aseaseda matatabuna wagaine, ke nuwada matatabuna wagaine, ke yada toyogina matatabuna wagaine. Ada kaduwe kaliva kana nuwakabubuyedi ide taudeyavo kanuwakabubuyeda anafaiweya. Faina kai taidei veimeya-dina kana itaveyabidi velemoena, aga Yaubada matane taidei iwaka-moena ayo vebolavoi alaalai-yabudi ada velekavovo matatabudi kavelevelena.” ");
INSERT INTO bwd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ada Yeisu kaliva-nai yana laufata wa yana nuwauya ani ginogalina wagaine, givonena, “Oyeni bademowa uvelilivana Yaubada yana ebaveimeya wagaine.” Ada tayuwe yadayada-nai wagaine-deya, keke tamo gaito kaduwe gida asevatu ke Bana gida tolidadane. Au iilovau. ");
INSERT INTO bwd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ada Yeisu manuwa tabu wagaine givewavewala kaliva wagaidiya aku givona, “Gavaiyamu-yo veimeya anatovewalayavo ivona evona Banae Mesaiya ani Deivida yana tubudelideli seyana? ");
INSERT INTO bwd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Faina Aluwaluwa Tabuna yana kivetuvetunu wagaine Deivida tauna givona, ‘Banae KAUVEYA Yaubada ani Iya yaku Kauveya givonena, givona, “Aiyatagikuya una vetoga analaba nibaimomo gana seobuyedi ada yadi toyogina gina avaina velemoena.”; ");
INSERT INTO bwd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Au taidei anafaiweya Deivida tauna ani Mesaiya givewagana ‘yaku Kauveya’, aku gavaiyamu-yo Mesaiya aimo gitubuga Deivida yana tubudelideli seyana?” Ada Yeisu yana vewala yoo lakaina moyaidi nuwadi givaina. ");
INSERT INTO bwd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ada yana vewala-nai wagaine givonedi, “Wana itaveyabimi Mosese yana veimeya anatovewalayavo yadi dewa wagaine. Badi nuwanuwadi adinuya manamanawedi ina osedi aku ina nunudadana, ada nuwanuwadi kaliva wa yadi vemoimoina ina vesiuleyedi maketi wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kaduwe nuwanuwadi manuwa ebavewala wagaidiya ina vetovetoga fafali-dina kaikaiwabudi wagaidiya, ada kaduwe kanibutu lakaidi aditoveya ani nuwanuwadi ina vetovetoga ebavetoga-dina isedi kaliva wa adivemoimoina faidiya. ");
INSERT INTO bwd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Badiyavo tova ke tova kaliva matadiya ina veoveola-faila aku kaduwe sikwasikwa ifwayafwayadi e ada yadi manuwa ke yadi giba ina lemalemadi. Biyavo-dina taidei adimatavuloga vitana velemoena ina nuwagana.” ");
INSERT INTO bwd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ada Yeisu givetoga maita tabae velekavovo anaebavedodoga wagaine, aku kaliva yadi velekavovo iboibou ani gimatawabuwabuyedi. Kaikaiwabudiyavo moyaidi ielai yadi velekavovo mani lakaina iboibou. ");
INSERT INTO bwd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ada kaduwe sikwa fanifanidi ielai ke yadi velekavovo mani kabisona iluwei idododi. Mani-nai vaita toya seyana anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ada Yeisu yana tonogalayavo gidouwedi ielai ke givonedi, “Vona velemoena, sikwa taidei yadi velekavovo ani kaliva moyaidi yadi velekavovo gitubusegedi. ");
INSERT INTO bwd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Faina kaliva moyaidi ivele-kavovo ani yadi kaikaiwabu lakaina gimiyamiya aku anatufo kabisona isena. Aku badi fanifanidi ani mani-nai kabisona vaita gida lemedi ani matatabuna ise-yabuna.” ");
INSERT INTO bwd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yeisu manuwa tabu wagaine giyegeyegemona aku yana tonogala seyana givona, “Tovewala, una itadi. Kabala lakaidi ani adiita iwaka-vagaidi! Ada manuwa tabu anaiyogona iwaka-moena!” ");
INSERT INTO bwd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aku Yeisu gilufata, “Manuwa taidei lakaidi uitadi, aku aimo keke seyana kabala-dina unaita-vagiledi yadi ebamiya wagaidiya. Matatabuna ina vetutuyaweyawelidi inaobu.” ");
INSERT INTO bwd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aku Yeisu ginau Oya Olive gilaka givetogana, wada laubeu fafaline manuwa tabu wagaine-deya. Aku Pita, Iyemesa, Iyoni ke Andulu adiloi gaga inau Yeisu wagaine ada itolidadanena, ");
INSERT INTO bwd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ivona, “Uda vonema, gaitoma-dina taidei uvonayedi ani gavatova wagaine ina yegemona? Ada gava iyaiyaya anaita ayo ana alamane anatova gina yegemona?” ");
INSERT INTO bwd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ada Yeisu givonedi, “Wana itaveyabimi ada keke seyana gaito yana vefwayafwaya wagaine gina sibalemi. ");
INSERT INTO bwd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Faina aimo kaliva tufona moyaidi akuyeganeya inaelai ina vonaga, ‘Iya game-nai tauku Mesaiya!’ Ada yadi fwaya-nai wagaine kaliva moyaidi ina vuyoyedi. ");
INSERT INTO bwd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kaduwe gaviya lakaidi butuna ina lavulavuga valeyadi wana nogalina lilivamiya ke atuwadeya. Aku keke wana aseuloulolo, faina gilubodana gaitoma-dina taidei ina yegemona. Aku ebalauyabu anatova ani aimoina. ");
INSERT INTO bwd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Faina yoo seyana ina mididi ke mali yoo nodi ina lugaviya, ada kadu anafaiweya ebaveimeya seyana gina alakaidi ke mali ebaveimeya nodi ina lugaviya. Ada fafali moyaina wagaidiya mabibi inamadu, kadu loka ina yegemona. Taidei gaitoma-dina ani tova mulolova anaebavevuvu-mowa. Au aimo tova vitana kadu ielaelai. ");
INSERT INTO bwd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Aku taumiyavo wana itaveyabimi, faina aimo kaliva ina kiveyabimi ke ina nauwemi ebavonayavuga wagaidiya ada kaduwe manuwa ebavewala wagaidiya ina lavulavumi. Ada imi yaku tonogalayavo faina, toveimeya lakaidiyavo ke kiniyavo matadiya wana mididi e ada valeya iwakana faikuya wana awatalatalaina badi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aku gilubodana nagona Yaubada yana ebaveimeya anavaleya iwakana ina lumamalena babi anakaliva adiyoo moyaidi wagaidiya, ada muliya ebalauyabu gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aku tova-nai ina kiveyabimi ke ina vevonayavugimi, keke wana venuwana gavaiyamu wanavona faina. Au tayuwe tova-nai wagaine gavavona Aluwaluwa Tabuna gina alavelevelemi ani wana vonayena. Faina yami ifufu ani keke taumiyavo yami nuwenuweya gina yegemona aku Aluwaluwa Tabuna givonavona. ");
INSERT INTO bwd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ada kaliva seyana tauna anatubuluga ginavai toveimeyayavo nimadiya ginasena ke ina luvealikana, ada tama natudiyavo ina vaidi toveimeyayavo nimadiya inasedi ke ina luvealikadi. Kaduwe biyabiyama inadiyavo ke tamadiyavo ina venibainedi ada ina vaidi toveimeyayavo nimadiya inasedi ke ina luvealikadi. ");
INSERT INTO bwd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ada kaliva moyaidi ina agougemi faina imi yaku tonogalayavo. E aku badi gavega ina atuvefaila-vagata yadi vetumagana wagaine ke Yaubada ina labina analaba yawaidi anaebalauyabu wagaine, Banae gina kibababaledi. ");
INSERT INTO bwd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Aku aimo gaitoma koyo-moena bwanebwanenena Yaubada matane ani aimo wana itana gina midimididi manuwa tabu wagaine. Ada tova-nai wagaine badi gavega Yudiya anafafali wagaine ina miyamiya ani gilubodadi inaota inalaka oya wagaidiya. Ee, gavega vona taidei ina veyawana ani nuwadi gida malina. ");
INSERT INTO bwd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ada badi gavega yadi manuwa getane ani idaobu aku keke idaluku yadi manuweya ke seyana gavana idavai ida nauwe. Au ida maduota. ");
INSERT INTO bwd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ada kai badi gavega yadi bakuleya ina miyamiya aga keke idayewa manuweya ke adinuya badobadona idavai. Au ida maduota. ");
INSERT INTO bwd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ada kaduwe ota anatova wagaine ani vevine waifugadiyavo ke vevine tovesusu ina venuwakalikali velemoena, faina keke adifaiweya ina maduota. ");
INSERT INTO bwd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","E ada wana veoveola ke tova iwakana Yaubada gina velemi yami tova ota wagaine, aku keke tulutulu anatoveya. ");
INSERT INTO bwd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Faina yadayada-dina wagaidiya ani vita lakai-moena gina yegemona. Tainei vita-nai ani keke seyana anafaiweya gida miyami tova-nai Yaubada givebutu gaitoma matatabuna gibubudi ada gielai malinai. Kaduwe, keke aimo gina yegemona-vagila anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vita tainei ani kai Yaubada keke anatova gida kivemaufo, aga kaliva matatabuna idakwa. Aku Banae yana kaliva venuvenuwadadanidi, biyavo-dina Tauna faine givenuwadadanedi ani badi faidiya tayuwe tova-nai gina kivemaufona. ");
INSERT INTO bwd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tayuwe tova-nai wagaine kai tamo gaito gina vonemi, ‘Wanaela wana itana, Mesaiya Tauna idauwe!’ o kai ginavona, ‘Wana itana, Banae tayuwe!’ aga keke yana vona-nai wana vetumagane. ");
INSERT INTO bwd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Faina keliso fwayafwaya ke falofita fwayafwaya aimo ina yegeyegemona ada iyaiyaya lakaidi ke gugai ebameyasidobodobo ina faifaisewadi, ke vaita meyameyaganina Yaubada yana kaliva venuvenuwadadanidiyavo ina vuyoyedi. ");
INSERT INTO bwd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","E ada imiyavo ani wana itaveyabimi! Gaitoma taidei moyaidi faidiya gavonamatawe-vagaimi.” ");
INSERT INTO bwd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ada kaduwe Yeisu givona, “Aku tova vitana gina avaina, muline kauwana gina yuyuvana ada vaikoi yana malina ginaweu. ");
INSERT INTO bwd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ailabama mwatuguya inabeu, ada gaitoma toyogidi wagabameya gina aliuliudi. ");
INSERT INTO bwd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ada tayuwe tova-nai wagaine Banae Kaliva Natuna ina itana buibui wagaidiya gina elaelai wa yana toyogina lakaina ke wa yana iwakana mamalina nodi. ");
INSERT INTO bwd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ada tova-nai wagaine yana aneloseyavo gina imilidi inanau babi matatabuna wagaine ke yana yoo venuvenuwadadanidiyavo ina vagauwidi. Fafali tulina tulina wabolimaneya wayavalaseya walaubeuya waoyeya ina vagauwidi. ");
INSERT INTO bwd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Wana itana ai alaa ada wana nuwenuwena. Kai alaa lukuna bademowa gina mavuna ada kabuna evaguna gina lukabukabu, tainei wagaine wana alamanena vaita bademowa ginagina lakaina yana tova givelilivana ke kauwana toyogina gina vebutu. ");
INSERT INTO bwd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","E ada kaduwe anafaiweya, tova-nai wana itadi iyaiyaya-dina ina yegeyegemona, aga wana alamanena vaita Banae Kaliva Natuna yana yewa-vagila anatova bademowa gilugavogavona. ");
INSERT INTO bwd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gavonemi velemoena, tova malinai anayooyavo ani keke ina alika-yabu aku taidei gaitoma-dina matatabuna inamadu yegemona. ");
INSERT INTO bwd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Gabama ke babi gina avaidi aku yaku vona keke maita ginaavai, au ginamiya-vagata. ");
INSERT INTO bwd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Aku yadayada-nai kai kauwana anabai ani keke seyana gaito gida alamane. Badi aneloseyavo gabameya keke ida alamane, kaduwe Banae Kaliva Natuna Tauna keke gida alamane, aku Tamana anakaibe-mowa gialamanena. ");
INSERT INTO bwd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","E ada wana itaveyabimi ke wana veitabodaboda, faina yaku yewa-vagila anatova keke wada alamane. ");
INSERT INTO bwd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Anafaiweya kaliva lakaina seyana ginanau mali fafaliya faina, yana togugaiyavo yadi gugai seyana seyana giveledi, aku banae manuwa anawana anatoitaveyabina veimeya givelena ke gina itaita. ");
INSERT INTO bwd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tainei faina wana itaita, faina keke wada alamane toni manuwa yana tova yewa-vagila, kai lavilaviya, boginafeya, malalavulavugeya o kai malabutuya. ");
INSERT INTO bwd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wana itaita aenanai gina yegemonimi ada gina nuwagami wana daudau. ");
INSERT INTO bwd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gavana gavonayena imi wagaimiya ani kadu kaliva moyaidi faidiya, gavona, ‘Wana itaita.’” ");
INSERT INTO bwd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ada yadayada iluwei gina avaidi muline, kanibutu gina yegemona anayegana Nugulina ke Beledi Keke wa Anayisti Anakanibutu. Aku veyavo anatovegugai lakaidiyavo ke Mosese yana veimeya anatovewalayavo ani wai ilelelena ke Yeisu ina kiveyabina ada ina luvealikana, aku ikavuya-deya, ");
INSERT INTO bwd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","faina ivona, “Keke Abutu anatova wagaine kana kiveyabi, faina kaliva ina nuwakoyoyeda ke gaviya ina silakaina.” ");
INSERT INTO bwd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ada Yeisu ginau Bedani melala wagaine gimiyamiya Saimoni yana manuweya. Banae tuwaina givelefelo aku giveiwaka, e aku aimo ivewagana Saimoni tolefelo. Ada ienokekela ikanikani ani vavine seyana bunama anayegana ‘nadi’ gialiyena, magana iwaka-moena kadu fatana lakaina. Bunama-nai tuwava kabala anayegana alabasita negenine gimiyamiya. Ada vavine-nai anatuwava odona giludobona ada Yeisu kuluwane giiwana. ");
INSERT INTO bwd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aku kaliva tufodi iitana ada inuwakoyo vavine wagaine ke taudiyavo gaga ivonavona, “Gavana faina bunama givenuwaegege? ");
INSERT INTO bwd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kada vekimoneyena, e ada anafaiweya kaliva fatana malamala seyana wagaine kada nuwagana ke tofanifani kada veledi.” Ada vavine iduweyena toyogina. ");
INSERT INTO bwd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aku Yeisu givona, “Wanase-moe ginamiya. Gavaiyamu-yo vita wavele vavine-nai? Gavana gigana wagaikuya ani iwakana velemoena. ");
INSERT INTO bwd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Fanifani ani tova moyaina wagaimiya imiyamiya ada kai gavatova wagaine nuwanuwami wana lemedi, aga amifaiweya yami nuwakabubu wana veledi. Aku Iyayeku ani aimo keke tova moyaina nodi kana miyami. ");
INSERT INTO bwd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Banae ani gavana anafaiweya, taine gigugaiyena. Vovoku gimadu bunamina akuibo didikuleya faina. ");
INSERT INTO bwd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gavonemi velemoena, gadedeku babi matatabuna wagaine valeya iwakana ina lumamalena, vavine taidei yana gugai iwaka-vagaina wagaikuya ina ifufuyena anaebanuwaududu faina.” ");
INSERT INTO bwd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","E ayo Yudasa Isakaliyota, banae adituwelo seyana, ginau veyavo anatovegugai lakaidiyavo wagaidiya ke Yeisu gina ivemogatalina wagaidiya faina. ");
INSERT INTO bwd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Badi Yudasa yana vona inogalina wagaine ivemwamwala lakaina, ada ivonadabadaba bana wagaine vaita mani ina velena. E ada Yudasa givebutu wai gilele ke gavatova iwakana wagaine Yeisu gina atuegena wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Abutu-nai anayegana Beledi Keke wa Anayisti anayadayada nagona giyegemo. Yadayada-nai wagaine meIsileli tova moyaina Nugulina analami ivevebolavoiyedi. E ada Yeisu yana tonogalayavo ielai wagaine ke itolidadana, ivona, “Gadedeku nuwanuwa anana ke aa ana kidewadewa Nugulina anakani faina?” ");
INSERT INTO bwd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ada Yeisu yana tonogalayavo adiselu giimilidi aku givonedi, “Wananau Yelusalema ada kaliva seyana gufa wa tuwavina giavalana, ani nodi wana venuwaga. Banae wana muliyena, ");
INSERT INTO bwd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ada gavamanuwa wagaine ginaluku aga toni manuwa wana vonena, ‘Tovewala givona, Gadedeku wakawaka yadi tutulagolota ada wagaine yaku tonogalayavo nodi Nugulina aana anakani?’ ");
INSERT INTO bwd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ada banae gina vewalemi tutulagolota lakaina manuwa getane, bademowa giba matatabuna isedewedewena. Wadedeku-deya adaga wana kidewadewa.” ");
INSERT INTO bwd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ada tonogalayavo adiselu itauya inau melala lakaina wagaine, ada gavana Yeisu givonayedi ani inuwagana anafaiweya. E ada wadedeku Nugulina aana ikidewedewena. ");
INSERT INTO bwd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mala gibogi Yeisu gielai yana tonogalayavo adituwelo nodi. ");
INSERT INTO bwd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ada teibeli lilivane ienokekela ikanikani aku Yeisu givona, “Vona velemoena, gavona wagaimiya, kaliva seyana wagaimiya gina ivemogataliku nibaikuweyavo wagaidiya, banae Iya nodi akanikani.” ");
INSERT INTO bwd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ada nuwadi givita ke seyana seyana ivona Yeisu wagaine, “Kai Iyayeku?” ");
INSERT INTO bwd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ada gilufata wagaidiya, givona, “Banae amituwelo wagaimiya, banae-nai Iya nodi beledi autuvina nauwa wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Velemoena Banae Kaliva Natuna gina alika Yaubada yana vona vetovetokilumina givonayena anafaiweya, aku kaliva-nai gina ivemogatalina nibainavo wagaidiya ani aimo vita lakai-moena gina nuwagana! Kai keke gida tubuga, ina iwaka-moena.” ");
INSERT INTO bwd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ada ikanikani aku beledi givaina, Yaubada wagaine givona vesiule, ada gikiinena ke tonogalayavo giveledi aku givona, “Wana vaina. Taidei vovoku.” ");
INSERT INTO bwd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ada kaduwe waini wa veina givaina ke givona vesiule Yaubada wagaine, ada giveledi matatabudi wagaine iyuga. ");
INSERT INTO bwd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ada kaduwe givonedi, “Taidei ani dayagiku Yaubada yana veyavo anawai faina. Gimadumadu tomiyababi moyaidi faidiya. ");
INSERT INTO bwd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gavonemi velemoena, keke kaduwe waini ganayu-vagile analaba yadayada-nai wagaine Yaubada yana ebaveimeya wagaine waini evaguna ganayuna.” ");
INSERT INTO bwd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ada kweli davadava ikweliyena. Ada ikweli giavaina, ina ilaka Oya Olive wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ada Yeisu givonedi, givona, “Imi moyaimi yami vetumagana wagaikuya gina kabekabebena ke wanaota-yabuyabuku. Faina Yaubada yana vona seyana ivetokilumina givona, ‘Sifi aditoitaveyabina gana mununa ada sifi wauma ina awalanau.’ ");
INSERT INTO bwd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aku ganayawa-vagila muline, wai gana nagona Galili, ada wadedeku-deya imi wanaela gana itami.” ");
INSERT INTO bwd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ada Pita gilufata, givonaga, “Kai badi moyaidi inaota-yabuyabuni aku Iya au keke-mowa!” ");
INSERT INTO bwd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ada Yeisu givona Pita wagaine, “Gavoneni velemoena, bogibogi taidei kamukamu keke gina kwage tova iluwei aku nagona unamadu veweyeku tova toiye vaita keke uda alamaneku.” ");
INSERT INTO bwd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ada Pita giawafatafata toyogina, givonaga, “Kai O ina luvealikani aga Iya nodi ina luvealikada. Keke-mowa gana veweyeni!” Ada tonogalayavo moyaidi ivona anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ada Yeisu yana tonogalayavo nodi inau fafali seyana anayegana Gedesemani wagaine ada givonedi, givona, “Idedeku wana vetoga aku ganana gana veoveola.” ");
INSERT INTO bwd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ada Pita, Iyemesa, ke Iyoni givaidi nodi inau. Aku Yeisu givebutu giaseuloulolo lakaina ");
INSERT INTO bwd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ada givonedi, givona, “Nuwaku givita lakaina, vaita yawaiku gida alagoloi. Idedeku wana miyamiya aku wana itaita.” ");
INSERT INTO bwd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aku ginau maita-moena ada wamagigine givetalatala babi wagaine ke giveola Tamana wagaine vaita uloulolo anatova gida vaiyavulena. ");
INSERT INTO bwd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Givona, “Kamaku, Kamaku-yo, O wagainiya gaitoma matatabuna meyameyaganina. Uloulolo anavei taidei uda vaiyegena wagaikuya. Aku keke yaku nuwanuwa, au Oyeni ya nuwanuwa anafaiweya una gugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ada Yeisu giyewana giitadi aditoto idaudau, ada Pita wagaine givona, “Saimoni, udaudau. Gavaiyamu, keke afaiweya kauwana anabai seya-moena una atuvefaila ke una itaita? ");
INSERT INTO bwd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Imi wana itaita ke wana veoveola e ada keke aladibidibi wagaine wanabe. Aluwaluwami nuwanuwana aku vovomi gikabekabebena.” ");
INSERT INTO bwd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kaduwe ginau giveoveola-vagila, ada vona-dina giinana-vagiledi. ");
INSERT INTO bwd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Giveoveola giavaina, kaduwe giyewana ani giitadi idaudau, faina badi matadi gikoyo-mowa. Ada gilivagudi aku keke ida alamane gavana inavona Bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ada au gisegedi aku kaduwe gina giveoveola, ada kaduwe tova anaveto giyewa-vagilena ke givona wagaidiya, givona, “Gavaiyamu, aimo wadaudau ada waveyaveyawai? Auwe! Bademowa tova giyegemona ke Banae Kaliva Natuna ina atuegena tokoyona nimadiya. ");
INSERT INTO bwd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wana mididi kananau. Waitana, kaliva-nai ginaseku nibaikuweyavo nimadiya ani giyegemona bademowa!” ");
INSERT INTO bwd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ada Yeisu aimo giifuifufu ani Yudasa giyegemona, banae tonogala seyana adituwelo wagaidiya. Ada kaduwe yoo lakaina nodi ielai ani wa yadi benisi ke feto, badi kaliva-dina ani veyavo anatovegugai lakaidiyavo ke veimeya anatovewalayavo ada kaliva lakaidiyavo yoo-dina iimilidi ielai. ");
INSERT INTO bwd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aku Yudasa bademowa yoo iyaiyaya seyana gimaduveledi, givona, “Banae gaito gana veyaugina ani kaliva-nai. Wana kiveyabina ada wana nauwena ke wana itaveyabi-dewedewena e ada keke meyameyaganina ginaota.” ");
INSERT INTO bwd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","E ada gielai tunutunugina ginau Yeisu wagaine ada givona, “Labai!” Ada giveyaugina. ");
INSERT INTO bwd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ada Yeisu ikiveyabina. ");
INSERT INTO bwd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aku kaliva seyana lilivadiya gimidimididi ani yana benisi gisiwakana ada kaliva seyana tagana gitalayoe gibeu. Bana kaliva-nai ani veyavo anatovegugai aditonagona yana togugai seyana. ");
INSERT INTO bwd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ada Yeisu givona wagaidiya, givona, “Gavaiyamu, Iya vaita tobaninivula anafaiweya e ada waelai wabenisimiyavo ke wafetomiyavo ada wana kiveyabiku? ");
INSERT INTO bwd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yadayada seyana seyana Iya imi nodi manuwa tabu wagaine gavevewala aku keke wada kiveyabiku. Aku gavana Buki Tabu wagaine ivetokilumina ani analauboda gina yegemona velemoena.” ");
INSERT INTO bwd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Taidei anafaiweya givona ada tonogalayavo moyaidi iota-yabuyabuna. ");
INSERT INTO bwd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aku tubulakata seyana Yeisu gimulimuliyena, ananuya kwayakwayana seya-moena gisiwalina. Ada kaliva tufodi ikiveifana, ");
INSERT INTO bwd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ada ananuya gimaduyabuyabuna aku wakonekonena giota. ");
INSERT INTO bwd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aku Yeisu inauwena veyavo anatovegugaiyavo aditonagona yana manuweya. Ada veyavo anatovegugai lakaidiyavo ke kaliva lakaidiyavo ada veimeya anatovewalayavo ivagauta manuwa-nai wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aku Pita bana atuwadeya Yeisu gimuliye gielai veyavo anatovegugai aditonagona yana manuwa anaebaga wagaine giluku. Ada gina givetoga manuwa tabu anafilisimaniyavo nodi ke ai givevevala. ");
INSERT INTO bwd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aku veyavo anatovegugai lakaidiyavo ke meIsileli yadi Kanisela moyaidi toveloi ileledi e ada wagaidiya vaita Yeisu ina veloina, ada yadi fwaya-nai wagaine vaita adifaiweya alika wagaine inasena. Aku keke ida nuwaga. ");
INSERT INTO bwd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Toveloi moyaidi ilakaela iveloina, aku keke kaliva iluwei ida veaigaigabu yadi vona wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","E aku kaliva tufodi imidiyegemona ke vona fwaya ivonayena Yeisu faine, ivona, ");
INSERT INTO bwd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ime anogalina ani givonaga, ‘Manuwa tabu taidei kaliva nimadiya iyogona ani gana yawelina, ada yadayada toiye wagaine kadu seyana gana yogona. Ada manuwa tabu-nai taidei ani keke gina mididi babi taidei anakalivayavo nimadiya.’” ");
INSERT INTO bwd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aku kaduwe badiyavo yadi awatalatalaina keke ida veaigaigabu. ");
INSERT INTO bwd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ada banae veyavo anatovegugai aditonagona moyaidi nefanidiya gimidiyegemona aku Yeisu gitolidadanena, givona, “Gavaiyamu, keke afaiweya una lufata? Gavana faina kaliva taidei yadi awavekoyo fainiya keke udafata?” ");
INSERT INTO bwd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aku Yeisu keke tamo laufata gida vonaye, au giveyamata-mowa. Ada kaduwe bana veyavo anatovegugai aditonagona gitolidadane-vagilena, givona, “Gavaiyamu, vona velemoena Oyeni Mesaiya, Banae kadavadavana Natuna?” ");
INSERT INTO bwd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ada Yeisu givona, “IYA TAUKU GAMIYAMIYA. Ada aimo wana itana Banae Kaliva Natuna ani Yaubada Totoyogi-vagaina aiyatagine gina vetoga gina miyamiya, ada gabama anabuibui tabodiya gina elaelai.” ");
INSERT INTO bwd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yeisu taidei anafaiweya givona ada veyavo anatovegugai aditonagona-nai ginuwakoyo lakaina ke tauna ananuya gikelilina aku givona, “Aaa! Gavana faina toitavedama kaduwe aimo kana lelele? ");
INSERT INTO bwd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bademowa yana vona awadamana wanogalina. Gavaiyamu wana veimeya?” Ada moyaidi iawavekoyoyena ke iveimeya, yana vona awadamana faina analauboda gina alika. ");
INSERT INTO bwd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ada tufodi ivebutu Yeisu ikiwalina aku magigina ikiwafina ada itafivilavilana aku ivonavonaga, “Una falofisai!” Ada manuwa tabu anafilisimaniyavo ivaina ke ilavulavuna. ");
INSERT INTO bwd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aku Pita gimiyamiya dibune ebaga-nai wagaine aku veyavo anatovegugai aditonagona yana togugai vavine seyana gielai. ");
INSERT INTO bwd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ada giitana Pita ai givevevala ani giitadonedonena ke givona, “Oyeni kaduwe Yeisu kwana Nasaledi nodi.” ");
INSERT INTO bwd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aku givewa, givona, “Iya keke gada alamane ada keke nuwaku gidamali gavana uvonevone!” ");
INSERT INTO bwd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","E, ada ginau tabae wana wagaine ada kamukamu gikwage. Ada vavine-nai wadedeku giitana ke givona-vagila tomididi wagaidiya, givonaga, “Tayuwe kaliva-nai ani Yeisu yana kaliva seyana.” ");
INSERT INTO bwd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aku kaduwe givewa. Ada tova kabisona tomididi-dina lilivane ivona Pita wagaine, ivona, “Velemoena, oyeni yana yoo seyana, faina oyeni kwana Galili.” ");
INSERT INTO bwd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aku Pita givona, “Kai keke ganavona velemoena, aga gilubodana Yaubada gina vematavulogiku. Aku ganavona velemoena, Bana Kaliva-nai wavonayena ani keke gada alamane!” ");
INSERT INTO bwd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ada maduga-mowa kamukamu gikwage anavelu ke Pita giduna vona-nai Yeisu givonayena wagaine, givona, “Muliya-yo kamukamu gina kwage tova iluwei aku nagona unavewa tova toiye vaita keke uda alamaneku.” Ada Pita yana vewa-nai nuwana giafolena, au gitagilumaibulu. ");
INSERT INTO bwd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mala gilavuna malabutuya-mwaeya, maduga-mowa badi veyavo anatovegugai lakaidiyavo ada kaliva lakaidiyavo ke veimeya anatovewalayavo ada kaduwe meIsileli yadi Kanisela, moyaidi ivagauta ke nodi iveimeya gavana inagai. Ada Yeisu nimana iyogodi ke inauwe iatuegena Pailato wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ada Pailato gitolidadanena, givonaga, “Gavaiyamu, Oyeni meIsileli yadi Kini?” Ada Yeisu gilufata ke givona, “Au uvona anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ada veyavo anatovegugai lakaidiyavo Yeisu iawavekoyoyena gaitoma moyaidi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ada kaduwe Pailato Yeisu gitolidadane-vagilena, “Gavaiyamu, keke maita ya laufata? Uitana, yadi awavekoyo wagainiya ani moyai-moena.” ");
INSERT INTO bwd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aku kaduwe Yeisu keke tamo laufata gida vonaye. E ada Pailato meyana gisidobona. ");
INSERT INTO bwd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aku Nugulina Abutuna anatova seyana seyana wagaidiya, Pailato yana dewa ani kaliva yogoyogona seyana deli wagaine gina etoyavuna, banae-nai faine yoo ina veolena. ");
INSERT INTO bwd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ada tayuwe tova-nai wagaine kaliva seyana yogoyogona gimiyamiya anayegana Balabasi, ani kabemali nibaidiyavo nodi deli wagaine imiyamiya, faina badiyavo veimeya iawaegegena ada nodi ilugaviya ke kaliva tufodi iluvealikadi. ");
INSERT INTO bwd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ada tova-nai yoo lakaina ivagauta ada iveola Pailato wagaine anafaiweya yana gugai malamala seyana seyana. ");
INSERT INTO bwd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ada Pailato gitolidadanedi, givona, “Gavaiyamu, nuwanuwami Banae meIsileli yami Kini gana etoyavuna faimiya?” ");
INSERT INTO bwd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Faina gialamanena velemoena veyavo anatovegugai lakaidiyavo nuwanuwadi lakaina kaliva badi ina vemoimoinedi, aku iitanuwagana moyaidi ani Yeisu ivemoimoinena ke imulimuliyena, e ada agodi giuga Banae wagaine. Ada taide vuvuna-nai faine Yeisu ikiveyabi inauwena ada iatuegena Pailato wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aku veyavo anatovegugai lakaidiyavo yoo-dina iivenuwanuwadi toyogina ke Pailato ina veolena vaita Yeisu ginamiya aku Balabasi gina etoyavuna. E ada taidei anafaiweya Pailato ivonena. ");
INSERT INTO bwd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ada Pailato kaduwe yoo gitolidadane-vagiledi, givona, “Gavana ganagai kaliva-nai wagaine banae wavewagana ‘MeIsileli yadi Kini’?” ");
INSERT INTO bwd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aku yoo ivedou, ivonaga, “Una kivebolagalagana!” ");
INSERT INTO bwd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ada Pailato givona, “Gavana faina? Gavakoyona gigai?” Aku badi bonadi kaduwe gilaka-mowa, ivedoudou ivona, “Una kivebolagalagana!” ");
INSERT INTO bwd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ada Pailato nuwanuwana yoo gina kivemwamwalidi faina, Balabasi gietoyavuna faidiya. Ada Pailato giveimeya ke tolugaviya Yeisu ilubibiwalina, ada nimadiya gisena ke ina kivebolagalagana. ");
INSERT INTO bwd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ada Pailato yana tolugaviyayavo Yeisu ikiveyabina ada inauwena veimeya anamanuwa lakaina anaebageya, ada tolugaviya adiyooyavo idouwevagauwidi. ");
INSERT INTO bwd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ada nuya yabeyabelina luveyalilina wagaine Yeisu iveosena, ke bulava akakaluluna imetana ani kedukedu kaikaiwabuna anafaiweya ada kuluwane isena. ");
INSERT INTO bwd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ada ivevuvu ke awaveleigeya iludakedakeyena, ivona, “Siule! Oyeni meIsileli yadi Kini!” ");
INSERT INTO bwd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ada aiwala ivai kuluwana ilavulavuna, ada ikiwalitagotagona aku awaveleigeya tugadi ivetodonedi ke ioduodu wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iawaveleigena giavaina, nuya yabeyabelina iveyalilina aku tauna ananuya iveosena ada iyegemone inauwena ke ina kivebolagalagana. ");
INSERT INTO bwd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ada itauya Yeisu inaunauwena aku kaliva seyana kwana Sailini inudebaina, anayegana Saimoni. Yana fafaliya gitauya ke Yelusalema wagaine gielaelai. Banae Alekisanida ke Lufuso tamadi. Ada tolugaviya iluyayalina ke Yeisu anakelose gina avalana. ");
INSERT INTO bwd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ada Yeisu inauwena fafali-nai ivewagana Goligota wagaine. Tainei ‘Goligota’ anakivila ani ‘Kuluwa Sewakelu Anafafali’. ");
INSERT INTO bwd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ada waini ke mulamula nodi ivila ivelena, aku keke gidayui. ");
INSERT INTO bwd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ada ikivebolagalagana. Aku ananuya ivai ivutugedi taudiyavo gaga wagaidiya, taine kabala anaselakalakata anavenuwadadana wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wada malabutuya kauwana naeni kiloki wagaine Yeisu ikivebolagalagana. ");
INSERT INTO bwd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aku anaawavekoyo ivetokilumina anakelose wagaine ani givona, “MeISILELI YADI KINI.” ");
INSERT INTO bwd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ada kaduwe tobaninivula adiselu Yeisu nodi ikivebolagalagadi adikelose wagaine, seyana aiyatagine, kadu seyana aimauline. ");
INSERT INTO bwd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ada kaliva wai wagaine inaunau ani Yeisu ivona awadamanena, ivona, “O uvona evona manuwa tabu uda yawelina aku yadayada toiye wagaine kadu udayogo-vagilena. Nikayo! ");
INSERT INTO bwd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tauni una kibababaleni ada una etoyavuni kelose wagaine unaobu!” ");
INSERT INTO bwd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ada kadu anafaiweya veyavo anatovegugai lakaidiyavo ke veimeya anatovewalayavo ani Yeisu iawaveleigena, ivona, “Mali kaliva gikibababaledi, aku keke anafata Tauna gina kibababale! ");
INSERT INTO bwd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Evona, Banae Mesaiya kadu Isileli anakini, malinai-mowa kelose wagaine gidaobu, e ada kanaita kana vetumagana!” Ada adiselu nodi ikivebolagalagadi ani badi kaduwe iawavekoyoyena. ");
INSERT INTO bwd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ada bademowa kauwana gielai anafaiweya givugivudeya ani yuyuvana babi matatabuna giyuyuvanibodena, ada gimiya analaba kauwana au gienovilana teli kiloki wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ada tova-nai wagaine Yeisu givedou bonana lakaina, givona, “Eloi, Eloi, lama sabakitani?” Vona taidei anakivila, “O yaku Yaubada, yaku Yaubada, gavana faina unuyabuyabuku?” ");
INSERT INTO bwd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ada kaliva tufodi wadedeku-deya imidimididi ani bonana inogalina ke ivona, “Wana nogalina! Wada Ilaitiya gidoudouwena, bana Yaubada yana falofita.” ");
INSERT INTO bwd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ada wagaidiya-deya kaliva seyana gimadu ginau balou giutuvina waini gikoyo wagaine, ada aiwala bwatane give etoonana ke gitune lakavena Yeisu awane gisena vaita ginayuna, ada givona, “Kanaboda aku kana itana. Kai Ilaitiya ginaela gina kakili gina seobuyena o kai keke.” ");
INSERT INTO bwd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ada Yeisu givedou moiyalina ke yawaina giavaina. ");
INSERT INTO bwd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ada manuwa tabu anaTutulagolota Tabutabu-moena ani anawana anaebaseboda kaleko giagigi-lugena, tabone ada giobu dibune. ");
INSERT INTO bwd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aku tolugaviya aditonagona gimidimididi Yeisu wamagigine, ani giitana yana alika anaita anafaiweya ada givona, “Vona velemoena, taidei Banae Yaubada Natuna!” ");
INSERT INTO bwd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aku kadu vevine tufodi badi Yeisu yana tonogalayavo, ani imididi maita tabae kelose wagaine aku imatawabuwabu. Badi wagaidiya-deya Meli vine Magidala, ada Meli Iyosefa taina Iyemesa nodi inadi, ke Salome. ");
INSERT INTO bwd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Biyavo-dina tuwaina Galili wagaine Yeisu imuliyena ke tova moyaina ilemelemena. Ada kadu vevine tufodi Yeisu nodi ielai Yelusalema ani iitaita. ");
INSERT INTO bwd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yadayada-nai ani Tova Kidewadewa, faina malabutu Sabate. Ada bademowa mala givelavilavi ani ");
INSERT INTO bwd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iyosefa kwana Alimatiya giyegemona. Banae meIsileli yadi Kanisela anayoo seyana, ada kaliva moyaidi matadiya banae ani wa anavemoimoina ada wa anavetumagana. Aku kaduwe, gibodaboda gavatova Yaubada yana ebaveimeya gina lakayegemona. Banae kaliva-nai wa yana asevatu ginau Pailato wagaine Yeisu vovona faina giveolena ke gina kiwafina. ");
INSERT INTO bwd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ada Pailato gitataweyana faina ginogalina vaita Yeisu bademowa gialika, e ada tolugaviya aditonagona gidouwe gielai ada gitolidadanena, “Velemoena Yeisu bademowa gialika?” ");
INSERT INTO bwd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ada tova-nai Pailato yana alamana givaina tolugaviya aditonagona wagaine, Yeisu vovona giawaegena Iyosefa wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ada Iyosefa gina toalika analifi kwayakwaya-moena gikimone ginauwena, ada Yeisu vovona gikakilina kelose wagaine ke nuya-nai wagaine gifaina. Ada vovona ginauwena ke gilukuwena didikula wagaine. Didikula-nai ani luwa lakaina italafolena yavola maufona anakabala wagaine. Ada kabala lakaina givekaliwawana ke didikula awana gisebodana. ");
INSERT INTO bwd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ada Meli vine Magidala ke Meli Iyosefa inana iitana gadedeku Yeisu vovona gisena. ");
INSERT INTO bwd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ada Sabate bademowa giavaina, Meli vine Magidala ke Meli Iyemesa inana ada Salome, ani badiyavo bunama iwakana ikimonena ke inanau Yeisu vovona ina bunamina. ");
INSERT INTO bwd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ada Sanidei kauwana gikedufolega vevine-dina aditoto inau Yeisu anadidikula wagaine. ");
INSERT INTO bwd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ada inaunau aku taudiyavo ivonavona, “Ide kanaunau, aku gaito kabala lakaina gina vekaliwawa didikula awane faideya?” ");
INSERT INTO bwd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Faina kabala-nai ani lakaina. Aku inuyegemona didikula luwa wagaine ada iitanau, ani iitana seyana gaito bademowa kabala lakaina givekaliwawana didikula awane ada gisena afaine. ");
INSERT INTO bwd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ada iluku didikula negenine aku iitana aiyatagidiya waina ani tubulakata seyana ananuya luveyalilina ke kwayakwayana givetovetoga. Ada vevine-dina iasekolukolu ");
INSERT INTO bwd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","aku kaliva-nai givonedi, givona, “Keke wana asekolukolu. Yeisu kwana Nasaledi walelelena, Banae ikivebolagalagana. Aku Yaubada bademowa gisiveyawa-vagilena alikeya! Banae keke idedeku. Wana itana fafali-nai wagaine isena. ");
INSERT INTO bwd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aku wananau yana tonogalayavo ada Pita nodi wana vonedi, ‘Yeisu wai ginagonagona Galili wagaine. Wadedeku-deya wana itana boi gimatawemi anafaiweya.’” ");
INSERT INTO bwd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ada vevine-dina ani meyadi gisidobodobo-moena ke vetatava gikimunumunudi, ada didikuleya-deya iyegemona ada iota inau. Ada imadumadu aku keke tamo gaito ida awatalatalaine, faina imatauta. ");
INSERT INTO bwd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aku tova-nai wiki-nai anayadayada nagona wagaine malabutuya-mwaeya Yeisu giyawa-vagila, ada gimaduyegemona Meli vine Magidala wagaine, banae wagaine-deya tuwaina aluwaluwa bwanebwanenedi adiyoo seveni Yeisu giveyegemonidi. ");
INSERT INTO bwd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meli-nai ginau ke badi boi Yeisu nodi imiyamiya ani gimatawedi. Badi wa yadi nuwavita itagitagiya aku gimatawedi, givona, “Yeisu wayawaina gimiyamiya! Iya tauku gaitana!” ");
INSERT INTO bwd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Aku yana vona keke ida vetumagane. ");
INSERT INTO bwd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ada muliya Yeisu yana tonogalayavo adiselu Yelusalema-deya iyegemona ada inaunau seyana melala wagaine, ani waiya-deya Yeisu giyegemona wagaidiya aku Tauna anaita gisevedavedamana wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ada iyewa Yelusalema ke yana tonogala velugadiyavo imatawedi, aku badi yadi vona keke ida vetumagane. ");
INSERT INTO bwd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muliya badi afositoloyavo ileveni teibeli lilivane ienokekela ikanikani, aku Yeisu giyegemona wagaidiya. Ada giduweyedi yadi vetumagana keke faina kadu badi debaidi gitoyoga faina. Faina Yaubada Banae Yeisu gisiveyawa-vagilena alikeya ada kaliva tufodi Bana iitana ke iifuifufuyena wagaidiya, aku yadi awatalatalaina ani afositoloyavo keke ida vetumagane. ");
INSERT INTO bwd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ada gimatawedi, givona, “Wananau babi matatabuna wagaine ada valeya iwakana wana lumamalena kaliva matatabudi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Badi gavega ina vetumaganeku ada ina babitaiso ani kibababala ina nuwagana. Aku gavega keke ida vetumagana, badi Yaubada matane ani wa yadi koyona e ada adilauboda matavuloga ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ada badi ivetumaganeku ani Yaubada yana toyogina anaiyaiyaya ina seyegemonedi taidei anafaiweya. Akuyeganeya aluwaluwa koyodi kaliva wagaidiya ina veyegemonidi, ada meya tulina tulina wagaidiya ina ifuifufu. ");
INSERT INTO bwd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ada kai mota ina kiveyabidi o kai gufa golagoladi inayudi, aga keke ina alika. Nimadi inasena toveoga vovodiya ke ina veiwaka.” ");
INSERT INTO bwd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ada Kauveya Yeisu yana vona wagaidiya giavaina, Yaubada gisilakaina gabameya ada Yaubada aiyatagine givetogana. ");
INSERT INTO bwd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ada tonogalayavo inau ada valeya iwakana ilumamalena fafali moyaidi wagaidiya. Ada Kauveya badi nodi igugai ke iyaiyaya ebameyasidobodobo gifaifaisewadi badi nimadiya, e ada kaliva iitadi ke nuwadi gimalina vaita yadi laumamala ani vona velemoena. ");
INSERT INTO bwd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Siule kauveya Tiyofilo. Kaliva moyaidi igaluvaluva ada gavana Yeisu gigugai adamwatugu wagaine ada gaitoma-dina iyegemona ani anavaleya ina vetokilumina. ");
INSERT INTO bwd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ada ebavevuvu wagaine badi kaliva-dina gavega gaitoma-dina aditoitavedama ani valeya-nai iifufuyena wagaimeya ada faine ivetoawatalatalaina kaliva moyaidi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","E ada Iya tauku yadi ifufu matana matana galelena gavana velemoena giyegemona. Ada ganuwanuwa vaita iwakana yadi awatalatalaina ganase-dewedewedi ada gana vetokilumina o fainiya, ");
INSERT INTO bwd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","e ada gaitoma-dina bademowa ivewaleni ani anavelemoena una alamanedi. ");
INSERT INTO bwd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ifufu-moena taidei anafaiweya. Tova-nai Elodi givekini Yudiya anafafali wagaine aku Yaubada yana veyavo anatovegugai seyana gimiyamiya anayegana Sekalaiya. Banae veyavo anatovegugaiyavo adiyoo wagaine aku Abaiya anatofaisewa anayoo wagaine gifaifaisewa. Sekalaiya ada vavinena Elisabeta adiselu ani badi Eloni yana tubudelideli. ");
INSERT INTO bwd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ada adiselu ani Yaubada matane yadi dewa tunutunugina, faina yana veimeya ke yana awata matatabuna imuliyena, ada keke tamo adiawavekoyo. ");
INSERT INTO bwd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aku adiselu natudiyavo keke, faina Elisabeta kakalina, ada kaduwe adiselu ivesilakai-mowa. ");
INSERT INTO bwd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Aku tova seyana Sekalaiya yana yoo yadi tova faisewa bade giyegemona e ada nodi ifaifaisewa manuwa tabu anafafali wagaine. Ada Yaubada yana veyavo anatovegugai anafaisewa ani Sekalaiya gifaifaisewana ");
INSERT INTO bwd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","aku veyavo anatovegugai adigiduwa anafaiweya, kabala adiselakalakata anavenuwadadana wagaine Sekalaiya venuwadadana givaina e ada ginaluku manuwa tabu anaTutulagolota Tabutabu-moena wagaine, ada inisenisi gina kabuna Yaubada matane. ");
INSERT INTO bwd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ada gina giluku ke inisenisi gikabukabuna aku kaliva moyaidi iveoveola wamelaleya, ");
INSERT INTO bwd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ada au KAUVEYA yana anelose giyegemo Sekalaiya wagaine, gimididi inisenisi anaebavebolavoi wa aiyatagine waina. ");
INSERT INTO bwd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ada Sekalaiya giitana wagaine au giabalutuga ada matauta gikimunumununa. ");
INSERT INTO bwd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aku anelose givonena, givona, “Sekalaiya, keke una matauta, ya veola Yaubada bademowa ginogalina. Ada vavine Elisabeta aimo natu kaliva gina venatunena ada una vewagana Iyoni. ");
INSERT INTO bwd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Banae ya ebavemwamwala ke ya ebagakaikai, ada kaliva moyaidi ina vemwamwala yana tubuga wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Faina aimo anaita lakaina Kauveya matane. Ada banae keke-mowa waini ke gufa toyogidi ginayuga. Ada aimo inana kamone aku Aluwaluwa Tabuna wagaine ginamaga. ");
INSERT INTO bwd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ada banae ani meIsileli kaliva moyaidi nuwadi gina sevedavedamedi ada gina yewedi Yaubada yadi Kauveya wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ada Iyoni wai gina nagona, muliya Kauveya yana ela, ada aluwaluwana wagaine yana toyogina ke yana dewa anafaiweya falofita Ilaitiya. Ada tama aseasedi gina kivenuwavilana natudiyavo wagaidiya ke ina nuwakabubuyedi, ada badi togadibudibusoyoga keke Yaubada ida mulimuliye ani gina kivenuwaviladi e ada badi yadi nuwanuwa tunutunugina ani bonadi ina nogali ke ina muliyedi. Ada taidei anafaiweya kaliva gina kidewadewa-vagaidi Kauveya faina.” ");
INSERT INTO bwd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ada Sekalaiya anelose gitolidadanena, givona, “Gavaiyamu gana alamane vaita taidei vona velemoena? Faina Iya bademowa gavesilakai-mowa, ada kaduwe vavineku silakai.” ");
INSERT INTO bwd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anelose gilufata, givona, “Iya Gabaliyeli. Iya ida tauku Yaubada matane gamidimididi, ada Iya giimiliku wagainiya ke gana mataweni valeya taidei iwakana. ");
INSERT INTO bwd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aku una itana. Yaku vona-dina keke uda vetumaganedi faina, malinai-mowa ago gina abodana ada keke afata una ifufu analaba yadayada-nai Yaubada givenuwadadanena wagaine yaku vona-dina ina yegemona velemoena.” ");
INSERT INTO bwd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aku kaliva wamelaleya ani Sekalaiya ibodabodana tova manamanawena, ada yana miya faila manuwa tabu negenine faine ivenuwavogana. ");
INSERT INTO bwd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ada ibodaboda aku tova-nai giyegemona wagaine, keke anafata gina ifufu wagaidiya, ada nuwadi giafolena vaita bana anavewala Yaubada giseyegemonena manuwa tabu nafone. Ada nimana gaga wagaine iyaiyaya gigugaiyedi aku au banae gaugauna gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ada tova-nai yana gugai anatova giluyabuna, ada au giyewana yana manuweya. ");
INSERT INTO bwd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ada taidei tova-dina muline, vavinena Elisabeta giveifuga ada vaikoi faifi keke gida nunudadana, au gimiyamiya manuweya, ");
INSERT INTO bwd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","e ada givona, “Kauveya vona velemoena Banae Tonuwakabubu! Faina tuwaina kakaliku ada wa yaku vovomumu, aku malinai gilemeku ada natuku ganuwagana wagaine yaku vovomumu kaliva matadiya givaiyavulena.” ");
INSERT INTO bwd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Aku Elisabeta bademowa yana vaikoi sikisi ginuwagana ada Yaubada anelose anayegana Gabaliyeli giimili ginau Nasaledi melala lakaina wagaine, tainei Galili anafafali. ");
INSERT INTO bwd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ada ginau vavine akeduna seyana matabolana anayegana Meli wagaine, aku kaliva anayegana Iyosefa ani gisetagona gina nagina, ada banae Kini Deivida yana tubudelideli wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anelose ginau wagaine ada givona, “Siule Meli, oyeni Yaubada nodi ada Banae velemoena giawanuwakabubuyeni lakai-moena.” ");
INSERT INTO bwd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aku Meli giaseuloulolo lakai-moena yana vona-nai wagaine ada givenuwavogana vona vesiule taidei gavana anaalamana. ");
INSERT INTO bwd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aku anelose givonena, givona, “Meli, keke una matauta, faina oyeni awaveiwaka unuwagana Yaubada wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ada aimo una veifuga ke kwamana kaliva una venatunena, ada una vewagana Yeisu. ");
INSERT INTO bwd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Banae aimo anayegana lakaina ada kaliva ina vewagana Yaubada Togetane-mwane Natuna. Ada Kauveya Yaubada gina kivekaikaiwabuna ke gina vekini anafaiweya yana tubudelideli Deivida ada yana ebaveimeya gina velena ");
INSERT INTO bwd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ke gina vetoveimeya-vagata Iyakobo yana tubudelideliyavo wagaidiya, ada yana ebaveimeya keke ginaavai.” ");
INSERT INTO bwd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aku Meli gitolidadanena anelose, “Ida taidei gavaiyamu? Faina Iya matabolaku.” ");
INSERT INTO bwd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anelose gilufata givona, “Aluwaluwa Tabuna gina vemagani, ada Togetane-mwane yana toyogineya gina aiwautagoni. E ada kwamana tabutabuna una venatunena ani ina vewagana Yaubada Natuna. ");
INSERT INTO bwd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aku una itana, kadu ina seyana ya gabu wagaine, bana Elisabeta, ani yana vesilakai wagaine aku giveifuga ada kwamana ginuwagana kamone. Evona ivona banae kakalina ani bademowa yana vaikoi sikisi ginuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Faina Yaubada wagaine gaitoma matatabuna meyameyaganina.” ");
INSERT INTO bwd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ada Meli givonaga, “Iya Kauveya yana togugai, ada gavana anafaiweya uvonayena ani gida yegemona wagaikuya.” E ada muliya anelose gisegena aku ginau. ");
INSERT INTO bwd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tayuwe tova-nai Meli gikidewadewa ada maduga-mowa ginau melala seyana lakaina Iyuda anaoyaoya wagaidiya, ");
INSERT INTO bwd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ada wadedeku gina giluku Sekalaiya yana manuweya ada givesiule Elisabeta wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ada tova-nai yana vesiule Elisabeta ginogalina, au kamona negenine bebeta gialakalakaina, ada Aluwaluwa Tabuna Elisabeta givemagana. ");
INSERT INTO bwd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ada bonana lakaina wagaine givona, “Oyeni ani vevine anamatatabuna wagaidiya Yaubada giawanuwakabubuyeni velemoena, ada kaduwe kwamana-nai una venatunena ani Yaubada giawanuwakabubuyena lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aku gavana faina Iya awaveiwaka lakaina ganuwaga ada yaku Kauveya inana uela wagaikuya una madubodaku? ");
INSERT INTO bwd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Uitana, tova-nai ya vona vesiule ganogalina ada bebeta kamoku negenine givemwamwala faina gialakalakaina. ");
INSERT INTO bwd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kauveya yana vona wagainiya ani uvetumaganena vaita gina yegemona velemoena, e ada yana nuwakabubu wagainiya faina una vemwamwala-mowa!” ");
INSERT INTO bwd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ada Meli gidava kweli wagaine, givona, “Aseasekuya Kauveya gadavadavana, ");
INSERT INTO bwd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ada Yaubada akuTokibababala wagaine aluwaluwaku givemwamwala, ");
INSERT INTO bwd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","faina Iya Banae yana togugai keke wa akuyegana aku giita nuwakabubuyeku. Tova malinai anayoo ada tova gielaelai anayoo ani aimo moyaidi ina vemwamwala faikuya ada inavona, ‘Vona velemoena vavine taidei Yaubada giawanuwakabubuyena velemoena.’ ");
INSERT INTO bwd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Faina Banae Totoyogi-moena ani gaitoma lakai-moedi gifaisewadi faikuya, ada Banae anayegana ani tabutabuna. ");
INSERT INTO bwd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ada yana nuwakalikali ginaunau badi gavega wa yadi matauta ivemoimoinena, biyavo-dina tuwaina imiyamiya, malinai imiyamiya, ada kaduwe aimo ina miyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bademowa nimane gaitoma toyogi-moedi gigadi. Badi gavega nuwainagediya inuwalaka ani bademowa giluveyawaliyedi iawalanau. ");
INSERT INTO bwd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Badi kiniyavo toyogidiyavo yadi veimeya anaebavetoga kaikaiwabudi wagaidiya giveobudi aku tonuwaobu gikilakaidi. ");
INSERT INTO bwd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tomafalavuga givemagadi gaitoma iwakadi wagaine aku tokaikaiwabu giimilidi makagekagediyavo inau. ");
INSERT INTO bwd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Tuwai-moena ani Yaubada givona vaita tubudeyavo tamadiyavo tainei Ebelaamo ke yana tubudelideliyavo wagaidiya ani gina nuwakalikaliye-vagaidi. Taidei faina Banae ide meIsileli yana togugaimomo ani ginuwakalikaliyeda, keke gida venuwavuluyeda.” ");
INSERT INTO bwd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ada vaikoi toiye anafaiweya Meli Elisabeta nodi imiyamiya ada muliya giyewana yana melaleya. ");
INSERT INTO bwd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ada Elisabeta yana tova venatuna giyegemona, ada kwamana kaliva givenatunena. ");
INSERT INTO bwd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ada tubuiyadiyavo ke yadi gabuyavo inogalina ani gavaiyamu Kauveya ginuwakalikaliyedi lakaina, ada badi nodi ivemwamwala. ");
INSERT INTO bwd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ada yadayada anaveeita wagaine, Elisabeta yadi yooyavo ielai ke bebeta vovona bubuna ina tomogoloina ada anayegana ina velena anafaiweya tamana Sekalaiya anayegana, ");
INSERT INTO bwd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","e aku inana ilufata, ivona, “Keke. Kana vewagana Iyoni.” ");
INSERT INTO bwd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kaliva ivona wagaidiya, ivona, “Imiye ani keke tamo gaito yami gabu wagaine yegana-nai gidawai.” ");
INSERT INTO bwd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ada au gabu tufodi nimadiya iyaiyaya ifaisewana tamana wagaine, vaita ina lelena gavayegana nuwanuwana kwamana ina veyegane. ");
INSERT INTO bwd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ada Sekalaiya giveola ebavetokiluma faina ada kwamana anayegana givetokilumina, givona, “Anayegana Iyoni.” Ada au moyaidi meyadi isidobodobona. ");
INSERT INTO bwd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ada maduga-mowa awana giayavuna ke meyana gibikana ada givebutu giifufu aku Yaubada gidavana. ");
INSERT INTO bwd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ada yadi yoo lilivadiya imiyamiya ani meyadi isidobona, ada Yudiya anaoyaoya wagaidiya ani taidei gaitoma-dina matatabuna faidiya kaliva iifuifufuyena. ");
INSERT INTO bwd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ada badi moyaidi gavega inogalina wagaine ivenuwavoganena, ada ivetolitoli ivona, “Kwamana taidei aimo gavaiyamu ginadewa?” Faina iitana Kauveya nimana yana toyogina aiwauna wagaine gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ada Iyoni tamana Sekalaiya ani Aluwaluwa Tabuna givemagana e ada gifalofisai, givona, ");
INSERT INTO bwd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kauveya kana davana, Banae meIsileli yada Yaubada, faina gielai gimadubodada ada yana kalivamomo gitutuveobuda vita wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yada Yaubada-nai ani Tokibababala toyogi-moena giseyegemonena faideya yana togugai Deivida unumina wagaine, ");
INSERT INTO bwd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","anafaiweya tuwai-moena Yaubada givonayena yana falofita tabutabudiyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ada givona ani gina kibababaleda nibaideyavo wagaidiya ke badi gavega iagougeda. ");
INSERT INTO bwd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ada kaduwe tuwaina tamadeyavo nagona wagaidiya givonadabadaba vaita badi gina nuwakalikaliyedi. Ada taidei yana veyavo anawai tabutabuna gina nuwaududuna. ");
INSERT INTO bwd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ada vonadabadaba toyogina tamada Ebelaamo wagaine givonayena, ");
INSERT INTO bwd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","vaita gina kibababaleda nibaideyavo nimadiya e ada adafaiweya kana gugai Banae faine aku keke kana matauta. ");
INSERT INTO bwd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kaduwe kanadewa tunutunugina ke kana nuwanuwa yegayegana Banae matane yawaida anamatatabuna wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ada kaduwe Sekalaiya natuna wagaine givona, “Ada oye natuku ani ina vewagani Togetane-mwane yana falofita, faina oye Kauveya faine wai una nagona ada yana wai una kidewedewena. ");
INSERT INTO bwd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ada yana kalivamomo una kivemalidi ke ina alamanena ada yadi dewa koyodi ina segedi ke Kauveya yadi koyona gina venuwaegedi, ada taidei anafaiweya adikibababala ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gaitoma-dina aimo ina yegemona faina yada Yaubada ani Tonuwakalikali, ada yana dewa bikana. Ada anafaiweya mala gina lavuna ke kauwana ginalaka wagabameya ke gina tuimalida, kaduwe anafaiweya adaTokibababala Banae Mesaiya ani wagabameya gina obuelai gina madubodada. ");
INSERT INTO bwd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ada badi gavega yuyuvana wagaine imiyamiya kaduwe badi gavega alika imatausena ani anamalina-nai gina tuimalidi, ada malina-nai ide matatabuda gina luvetuvetunuda aku kana naunau nuwaniwalova anawai wagaine.” Taidei anafaiweya Sekalaiya yana vona. ");
INSERT INTO bwd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ada kwamana-nai giveinala ke aluwaluwana wagaine gitoyogina, ada fafali kavovona wagaine gimiya analaba yana yegemona vaguvagu meIsileli yoo matadiya. ");
INSERT INTO bwd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tayuwe tova-nai Iyoni aimo kabisone, aku kwana Loma anayegana Sisa Ogosita banae anafaiweya kini, ada giveimeya ke senisisi ina vaina yana ebaveimeya anamatatabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Taidei senisisi-nai wai nagona gimaduyegemona tova-nai Kuliniyasi givetoveimeya Siliya anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ada kaliva seyana seyana anayegana ina vetokilumina faina, inau taudiyavo yadi melala wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","E ada Iyosefa kaduwe Galili melalina Nasaledi wagaine gitauya gilaka ginau Yudiya anafafali wagaine, aku tainei Kini Deivida yana melala lakaina Bedeliema wagaine, faina banae Deivida yana tubudelideli ada gabu-dina wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ada wadedeku Meli nodi inau adiyegana ina vetokiluma faina, aku vavine-nai gisetagona aimo gina nagina ani bademowa giveifuga. ");
INSERT INTO bwd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ada aimo Bedeliema wagaine imiyamiya aku Meli yana tova venatuna giyegemona, ");
INSERT INTO bwd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ada yana tomoinagona bebeta kaliva givenatunena. Ada bebeta ikiwafiwafina nuya diyadi wagaidiya ke kevakeva adiafo wagaine ivenobalina, faina keke tamo mwatugu ebada faidiya manuwa wakawaka wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aku wadedeku Bedeliema lilivane ani awaawana-dina wagaidiya sifi aditoitaveyabina tufodi imiyamiya, ada bogibogi-nai wagaine yadi sifiyavo iitaitaveyabidi. ");
INSERT INTO bwd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tova-nai wagaine KAUVEYA yana anelose seyana giyegemona wagaidiya ada Kauveya yana iwakana mamalina gilunamanamalena ani gituimalidi, ada iaseulolo lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aku anelose wagaidiya givona, “Keke wana matauta. Iya valeya iwakana gaaliyena wagaimiya, ada taidei valeya-nai ani ebavemwamwala lakai-moena kaliva moyaidi faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tova malinai Deivida melalina wagaine amiTokibababala gitubuga, Banae Mesaiya au yada Kauveya. ");
INSERT INTO bwd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yami iyaiyaya ani bebeta wana nuwagana nuya diyadi wagaidiya ikiwakiwafina, ada kevakeva bulumakau adiafo wagaine gidaudau.” ");
INSERT INTO bwd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ada maduga-mowa kaduwe gabama anaaneloseyavo yoo lakai-moena iyegemona ada banae nodi ivebutu Yaubada iawadavadavana ivonavona, ");
INSERT INTO bwd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yaubada gabama getane-mwane kana awadavadavana, ada kaliva babi wagaine gavega yana awaveiwaka wagaidiya ani miya niwalova gimiyamiya wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ada aneloseyavo tova-nai isegedi aku ina iluku gabameya, ada au sifi aditoitaveyabina seyana seyana ivetolitoli ivona, “Kananau Bedeliema ada kana itana gaitoma taidei giyegemona, gavaiyamu Kauveya givoneda faine.” ");
INSERT INTO bwd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","E ada imadu inau Meli ke Iyosefa inuwagadi, ada iitana bebeta gidaudau kevakeva adiafo wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ada tova-nai kwamana-nai iitana, au valeyana gavaiyamu anelose gimatawedi ivemogatalina, ");
INSERT INTO bwd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ada badi gavega sifi aditoitaveyabina yadi vona inogalina ani meyadi gisidobodobona. ");
INSERT INTO bwd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aku Meli ani gaitoma-dina aseasediya isedi ada ivenuwadadanedi lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","E ada sifi aditoitaveyabina iyewadi ada Yaubada anayegana ikilakaina ke idavadavana faina gaitoma moyaina inogalidi ke iitadi ani au gavaiyamu anelose-nai givonedi anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yadayada anaveeita wagaine tainei bebeta vovona bubuna ina tomogoloina, ada tova-nai wagaine anayegana ivelena Yeisu, yegana-nai anelose givelena muliya-yo inana giveifuga. ");
INSERT INTO bwd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ada tova-nai Meli adikiveyegayegana anatova iluyabuna anafaiweya Mosese yana veimeya, ada Iyosefa ke Meli kwamana inauwena Yelusalema wagaine ke Yaubada matane inasena. ");
INSERT INTO bwd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Faina Yaubada yana Veimeya anabuki wagaine ivetokilumina, givona, “Tomoinagona seyana seyana ina seliyedi Yaubada wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aku vevine adikiveyegayegana yadi tova venatuna muline faina, Yaubada yana veimeya givona, “Manuga bunebune iluwei o kai kabututula kabisodi iluwei.” E ada kaduwe tainei yadi vebolavoi inauwena Yelusalema wagaine ina vebolavoiyena. ");
INSERT INTO bwd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aku tova-nai wagaine kaliva seyana gimiyamiya Yelusalema wagaine, anayegana Simiyoni. Banae toyegayegana ada wa yana matauta Yaubada givemoimoinena, ada giitaitaboda gavatoveya meIsileli adietoyavuga ida nuwaga yadi miya vitana wagaine ke miya niwalova gida yegemo. Ada Aluwaluwa Tabuna gimiyamiya wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ada Aluwaluwa Tabuna giivemogatalina banae wagaine vaita keke gina madualika aku nagona Kauveya yana Mesaiya gina itana. ");
INSERT INTO bwd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ada au Aluwaluwa Tabuna Simiyoni ginagoyena ke ginau manuwa tabu wagaine giluku. Aku tova-nai wagaine Yeisu inana ke tamana inauwe ilukuwena ke gavana Yaubada yana veimeya anafaiweya ina gugai faine, ");
INSERT INTO bwd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","aku Simiyoni inuwagana ada bana bebeta givai giwaina ada Yaubada gidavana givonaga, ");
INSERT INTO bwd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kauveya, anafaiweya uvonadabadaba ada tova malinai una awaegeku Iya ya togugai gana veyawai nuwaniwalova wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Faina bademowa tauku matakuya gaitana ya Tokibababala uimilina gielai, ");
INSERT INTO bwd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tauna Banae ukidewedewena gina dinava yoo tulina tulina moyaidi faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ada Banae anafaiweya malina ani Yaubada giluvemogatalina badi keke meIsileli wagaidiya, ada ya kalivamomo meIsileli ani Banae faine kaliva moyaidi ina awadavadavama.” ");
INSERT INTO bwd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ada Simiyoni yana vona bebeta-nai faine ani inana ke tamana meyadi gibovu. ");
INSERT INTO bwd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","E ada Simiyoni giawanuwakabubuyedi aku inana Meli wagaidiya givona, “Taidei Banae Yaubada givenuwadadanena ada meIsileli badi gavega keke ina vetumagane aga aimo vita lakaina ina nuwagana, aku gavega ina vetumaganena ani Yaubada gina kibababaledi ke ina vemwamwala-vagata. Ada Yaubada gisena ani Banae gina veiyaiyaya, aku kaliva moyaidi ina vonaveyewa faine, ");
INSERT INTO bwd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","e ada aseasedi ananuwanuwa moyaina gina mogatala. Ada imi taumi ani aseasemi gina ulolo lakaina vaita benisi gida etoyavali.” ");
INSERT INTO bwd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kaduwe wadedeku seyana falofita vavine gimiyamiya anayegana Ana, Fenuweli natuna, Aseli anaunuma wagaine. Banae tuwaina, akedune ginagi moganena nodi imiyamiya malamala seveni, ");
INSERT INTO bwd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ada muliya gisikwa ke gimiyamiya analaba malamala eiti-fowa (84), ada au givesilakai-mowa. Ada tova ke tova bogi ke yadayada wagaidiya gina nauna manuwa tabu anafafali wagaine gioduodu, ada tauna giawatana ada kani giiloilovau aku giveoveola. ");
INSERT INTO bwd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","E ada Simiyoni yana ifufu giavaina ani vavine-nai gilaka gielai Iyosefa ke Meli wagaidiya ada givesiule Yaubada wagaine ke giifufu kwamana faine moyaidi wagaidiya, badi gavega iitaitaboda aimoina Yelusalema anatutuveobu faina. ");
INSERT INTO bwd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ada Iyosefa ke Meli igugai anafaiweya gavana Yaubada yana veimeya ananuwanuwa, e ada iyewadi Galili anafafaliya ke taudiyavo yadi melala lakaina Nasaledi wagaine iyegemona. ");
INSERT INTO bwd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ada kwamana-nai giveinala ke wa yana toyogina, ada nuwauya wagaine gimaga. Ada Yaubada yana nuwadoga wagaine gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aku malamala seyana seyana ani Yeisu inana ke tamana inaunau Yelusalema wagaine Nugulina Abutuna faina. ");
INSERT INTO bwd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ada tova-nai Yeisu anamalamala tuwelo ginuwagana, ada banae nodi inau Abutu wagaine anafaiweya adigiduwa. ");
INSERT INTO bwd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ada Abutu anayadayada giavaidi aku inana ke tamana iyewayewadi melaleya ani kwamana Yeisu gimiyayewa Yelusalema wagaine, aku badi keke ida alamane. ");
INSERT INTO bwd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inuwanuwa vaita banae nodi adiyoo nafone, ada yadayada seyana anamatatabuna inaunau. Muliya ivebutu ilelena yadi gabuyavo ke tubuiyadiyavo wagaidiya ");
INSERT INTO bwd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","aku keke ida nuwaga, e ada iyewadi Yelusalema ina lelena. ");
INSERT INTO bwd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ada yadayada anaveto wagaine inuwagana manuwa tabu nafone givetovetoga veimeya anatovewalayavo adimwatuguya, ada ginoganogala wagaidiya kadu gitolitolidadanedi. ");
INSERT INTO bwd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ada moyaidi gavega inogalina yana nuwauya ada yana laufata wagaidiya meyadi ibovu. ");
INSERT INTO bwd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aku tova-nai inana ke tamana iitana ada itataweyana, ada inana ivona wagaine, ivona, “Natuku, gavana faina taidei anafaiweya udewa wagaimeya? Tama ke imae wa yama aseuloulolo lakaina o aleleleni.” ");
INSERT INTO bwd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Banae givonaga, “Gavaiyamu-yo waleleleku? Kai keke wada alamane gilubodaku ada Kamaku yana manuweya gana miyamiya?” ");
INSERT INTO bwd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aku gavana givonayena ani badi keke nuwadi gidamali. ");
INSERT INTO bwd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ada Yeisu nodi iobu inau Nasaledi wagaine ke bonadi gimatawalewaleyena. Aku inana ani gaitoma-dina taidei matatabuna inuwaveyalaidi aseasediya. ");
INSERT INTO bwd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ada Yeisu giveinala ke yana nuwauya kadu giveinala-mowa, ada Yaubada ke kaliva nodi ivemwamwala Bana faine. ");
INSERT INTO bwd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Malamala fifitini ani Sisa Tibeliyasi giveiveimeya Loma yana ebaveimeya wagaine, tova-nai Ponitiyo Pailato banae Yudiya anafafali anatoveimeya ada Elodi banae Galili anafafali anatoveimeya, aku anatubuluga Filipi ani Ituleya ke Telikonitisi adifafali aditoveimeya, ada Lisaniya banae Abilini anafafali anatoveimeya. ");
INSERT INTO bwd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aku badi Yaubada yana veyavo anatovegugai aditonagona adiselu ani Anasi ke Kaiyafasi imiyamiya kaduwe. Ada tayuwe tova-nai wagaine ani Yaubada bonana gielai Sekalaiya natuna Iyoni wagaine, banae gimiyamiya fafali kavovona wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ada Iyoni anavedo Yaubada wagaine ginogalina, gimididi ada ginau Gufa Yolidani anafafali moyaina wagaidiya ke gilulumamala, givonavonaga, “Yami dewa koyona wagaidiya wana nuwavilana ke wana babitaiso e ada Yaubada yami koyona gina venuwaegedi.” ");
INSERT INTO bwd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tuwai-moena falofita Aiseya giifufuyena yana buki wagaine, givona, “Kaliva seyana givedovedou fafali kavovona wagaine, givonavona, ‘KAUVEYA yana wai aseasemiya wana kidewedewena ke wana kivetunutunugina Bana faine. ");
INSERT INTO bwd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Oya lakaidi awagadi laulaubeuna ani wana tavudi inalaka, natu-oyaoyadi wanayala ubalidi ina velaubeu. Wai nubalabaladi wana luvetunugidi, ada wai dabodabona wana luvedamadi. ");
INSERT INTO bwd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ada kaliva moyaidi Yaubada yana kibababala ina itana.’” ");
INSERT INTO bwd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aku yoo ielaelai Iyoni wagaine ina babitaiso ani givona wagaidiya, givona, “Imi vaita mota natunavo anafaiweya, mota-nai koyo-moena giluluvealika! Gaito givonemi evona vaita amifaiweya wanaota Yaubada yana nuwakoyo lakaina gielaelai wagaine? ");
INSERT INTO bwd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gilubodami wanadewa tunutunugina e ada yami nuwavilana anaita gina mogatala velemoena. Ada keke wana nuwanuwa taumiyavo wagaimiya ke wanavona, ‘Imeyavo ani Ebelaamo unumina faina, kadu ime Yaubada natunavo. E ada Yaubada keke gina vematavulogima.’ Faina gana vonemi, Yaubada anafata kabala taidei wagaidiya Ebelaamo natunavo gina bubudi. ");
INSERT INTO bwd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kaduwe tova malinai-mowa Yaubada yana matavuloga anailama bademowa igui gimanini ada ai ina luinubadi. Ada ai seyana seyana guwadi keke iwakana ani inatala ginaobu ke ina batugena ai alalata wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ada kaliva Iyoni itolidadanena, ivonaga, “Ada gavana anagai?” ");
INSERT INTO bwd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Iyoni gilufata, givona, “Gaito anaseti iluwei aga seyana gina velena banae gaito anaseti keke, ada kaduwe gaito wa anaga aga gina vutuga anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kaduwe takesi anatoyaudi iela ina babitaiso ada itolidadanena, “Tovewala, ime gavana anagai?” ");
INSERT INTO bwd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Givonediga, “Au takesi gaga anaetowava anafaiweya wana vaina, keke wanadewa koyona ada wana vetutamwata taumiyavo faimiya.” ");
INSERT INTO bwd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kaduwe tolugaviya tufona itolidadanena, “Ada gavana analauboda ana gugai?” Gilufata, givona, “Kaliva keke wana awavematausidi o kai wana veloidi aku mani wanavai. Ada mani-nai wavaivaina fatami faina ani wana vemwamwala faine.” ");
INSERT INTO bwd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kaliva matatabudi ani iveitabodaboda Tokibababala yana ela faina, e ada tova-nai Iyoni iitana ada inuwanuwa aseasediya ivona, “Kai ida Tauna Mesaiya-menai.” ");
INSERT INTO bwd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aku Iyoni moyaidi givonedi, “Iyayeku ani gakivebabitaisomi gufa wagaine, aku kaliva seyana Banae lakai-moena muliya Iyayeku ani gielaelai. Iya kwamana kabisoku faina, keke akulauboda ke Bana wagaine gana vetogugai ke anaageyafayafa anabulava gana kiyavudi. Banae ani gina kivebabitaisomi Aluwaluwa Tabuna wagaine ada kadu ai alalata. ");
INSERT INTO bwd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ada witi anadiu lakaina ani bademowa nimana wagaine ke witi-moena gina luvisina yogona wagaine-deya ada yana ebavagakolukolu gina kwakwa-yabuna. E ayo witi-moena gina vagauwina yana kweda wagaine gina dodona, aku witi yogona ai alalata wagaine ginaleva gina alaina, ai-nai keke maita gida weuwe.” ");
INSERT INTO bwd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ada vona moyaina wagaidiya Iyoni kaliva givagadonedi ada valeya iwakana gilumamalena wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aku toveimeya-nai Elodi ani seyana tova Iyoni giduweyena, givona, “Keke iwakana faina atubuluga vavinena Elodiyasi ani uluobuyedi ada vavine.” Kaduwe Elodi yana dewa moyaina koyona faina ada Iyoni giduweyena. ");
INSERT INTO bwd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aku Elodi ani ginuwakoyo, ada yana dewa koyona moyaina adivetutamwata ani dewa koyo-moena gifaisewana, tainei Iyoni giselukuwena deli wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aku Iyoni aimo keke deliya ida selukuwe wagaine aku kaliva moyaidi gikikivebabitaisodi, ada tova-nai wagaine Yeisu kaduwe Iyoni gikivebabitaisona. Aku Yeisu yana babitaiso giavaina, giveoveola ani gabama giawaina ");
INSERT INTO bwd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ada Aluwaluwa Tabuna giobuelai Banae wagaine vaita manuga bunebune anafaiweya. Ada gabameya-deya bonabona giyegemona, givona, “Oyeni Natu aseaseku, ada nuwaku ukivemwamwalina lakaina.” ");
INSERT INTO bwd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aku Yeisu Tauna yana gugai givebutu tova-nai anamalamala teti (30), ada inuwanuwa evona Banae kaliva natuna ada tamana Iyosefa, aku Iyosefa tamana Eli, ");
INSERT INTO bwd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli tamana Matata, Matata tamana Livai, Livai tamana Meleki, Meleki tamana Iyanai, Iyanai tamana Iyosefa, ");
INSERT INTO bwd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iyosefa tamana Matatiyasi, Matatiyasi tamana Emosi, Emosi tamana Naumi, Naumi tamana Esilai, Esilai tamana Nagai, ");
INSERT INTO bwd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tamana Mada, Mada tamana Matatiyasi, Matatiyasi tamana Semeini, Semeini tamana Iyoseki, Iyoseki tamana Iyoda, ");
INSERT INTO bwd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Iyoda tamana Iyowanani, Iyowanani tamana Lesa, Lesa tamana Selubabeli, Selubabeli tamana Salatiyeli, Salatiyeli tamana Neli, ");
INSERT INTO bwd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli tamana Meleki, Meleki tamana Adadi, Adadi tamana Kosamu, Kosamu tamana Elimadamu, Elimadamu tamana Ele, Ele tamana Iyosuwa, ");
INSERT INTO bwd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Iyosuwa tamana Eliesa, Eliesa tamana Iyolimi, Iyolimi tamana Matata, Matata tamana Livai, Livai tamana Simiyoni, ");
INSERT INTO bwd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simiyoni tamana Iyuda, Iyuda tamana Iyosefa, Iyosefa tamana Iyonama, Iyonama tamana Eliyakimi, ");
INSERT INTO bwd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimi tamana Meleya, Meleya tamana Mena, Mena tamana Matatia, Matatia tamana Nedani, Nedani tamana Deivida, ");
INSERT INTO bwd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deivida tamana Iyese, Iyese tamana Obedi, Obedi tamana Bowasa, Bowasa tamana Salamoni, Salamoni tamana Nasoni, ");
INSERT INTO bwd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoni tamana Aminadaba, Aminadaba tamana Adimina, Adimina tamana Ani, Ani tamana Esiloni, Esiloni tamana Felesi, Felesi tamana Iyuda, ");
INSERT INTO bwd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iyuda tamana Iyakobo, Iyakobo tamana Aisake, Aisake tamana Ebelaamo, Ebelaamo tamana Tila, Tila tamana Naoli, ");
INSERT INTO bwd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naoli tamana Selugi, Selugi tamana Leu, Leu tamana Felege, Felege tamana Iba, Iba tamana Sila, ");
INSERT INTO bwd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila tamana Keinane, Keinane tamana Afakasadi, Afakasadi tamana Semi, Semi tamana Nowa, Nowa tamana Lemeki, ");
INSERT INTO bwd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemeki tamana Metusela, Metusela tamana Inoki, Inoki tamana Iyeledi, Iyeledi tamana Maalaleli, Maalaleli tamana Keinani, ");
INSERT INTO bwd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinani tamana Inosi, Inosi tamana Sete, Sete tamana Adama, Adama tamana Yaubada. ");
INSERT INTO bwd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ada Yeisu Aluwaluwa Tabuna wagaine gimaga, ada wadedeku gufa Yolidani-deya giyewa ginau fafali kavovona wagaine Aluwaluwa Tabuna ginagonagoyena. ");
INSERT INTO bwd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wadedeku yadayada foti (40) Seitani gialadibidibiyena. Ada yadayada-dina wagaidiya keke tamo gidakani, ada tova-nai anaebalauyabu wagaine mafa gilavuna. ");
INSERT INTO bwd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ada Seitani au giyegemona Bana wagaine ada givonenaga, “Kai Oyeni velemoena Yaubada Natuna, aga kabala taidei una veimeyena ginave aa.” ");
INSERT INTO bwd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeisu gilufata givona, “Yaubada yana vona vetovetokilumina givonaga, ‘Keke aa gaga wagaine kaliva yawai ina nuwanuwaga.’” ");
INSERT INTO bwd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kaduwe, Seitani gilakavena oya tabone-mwane, ada maduga-mowa vaita mata alovo anafaiweya wagaine givewalena ebaveimeya moyaidi babi matatabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ada givonena, givona, “Ebaveimeya kaikaiwabudi taidei moyaina wa yadi toyogina bademowa iveleku ada adiveimeya nimakuya gimiyamiya, ada gaito nuwanuwaku gana velena aga akulauboda gana velena. ");
INSERT INTO bwd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","E ada Oyeni ani, kai una oduodu Iya wagaikuya aga matatabuna gana veleni ya ebaveimeya.” ");
INSERT INTO bwd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aku Yeisu gilufata givona, “Yaubada yana vona vetovetokilumina givonaga, ‘KAUVEYA ya Yaubada wagaine una oduodu ada Banae anakaibe-mowa faine una gugai.’” ");
INSERT INTO bwd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kaduwe Seitani Yeisu ginauwena Yelusalema, ada manuwa tabu tabone-mwane givemididina ada givonena, “Kai Oyeni velemoena Yaubada Natuna aga idedeku-deya una towavila unaobu, ");
INSERT INTO bwd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","faina Buki Tabu wagaine ivetokilumina, givona, ‘Yaubada yana aneloseyavo gina veimeyedi o fainiya ke ina itaveyabini, ");
INSERT INTO bwd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ada nimadiya ina kilakaini e ada keke age una vetutu kabala wagaine.’” ");
INSERT INTO bwd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ada Yeisu gilufata givona, “Buki Tabu wagaine givona, ‘Keke KAUVEYA ya Yaubada una galuvaluva.’” ");
INSERT INTO bwd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tova-nai Seitani yana aladibidibi-dina matatabuna bademowa giluyabu, e au gisegena aku ginau analaba aimo yana tova seyana iwakana gina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ada Aluwaluwa Tabuna yana toyogina wagaine Yeisu giyewa ginau Galili anafafali wagaine, ada valeyana gimutula fafali-dina moyaina wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ada givewala-nau yadi manuwa ebavewala wagaidiya, ada moyaidi idavana. ");
INSERT INTO bwd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","E, ada Yeisu givewala ginaunau aku gielai Nasaledi, tayuwe melala-nai wagaine giveinala. Ada yana dewa anafaiweya, Sabate wagaine gina giluku manuwa ebavewala wagaine, ada gimididi Buki Tabu gina veyawa. ");
INSERT INTO bwd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ada buki uwalugena ivelena ani falofita Aiseya yana vetokiluma, giluyavuyavuna ada ginuwagana fafali-nai ivetokilumina ani taidei anafaiweya givona, ");
INSERT INTO bwd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“KAUVEYA Aluwaluwana wagaikuya gimiyamiya, faina givenuwadadaneku ke gitoyogiveleku e ada valeya iwakana gana lumamalena tofanifani wagaidiya. Banae giimiliku ke etoyavuga gana awamogatalena yogoyogodiyavo faidiya, ada badi matadi koyo-moedi faidiya ani matadi gina veiwaka. Ada badi gavega yadi miya mali kaliva nimadiya ikivevitana ani gana etoyavudi ke ina veyawai, ");
INSERT INTO bwd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ada gana awamogatalena KAUVEYA yana kibababala anatova bademowa giyegemona faina.” ");
INSERT INTO bwd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","E ada Yeisu giveyawa giavaina, Buki Tabu giuwana ada giveyewana tolema wagaine aku givetogana. Ada moyaidi manuwa ebavewala negenine matadi ginau wagaine, ");
INSERT INTO bwd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ada givebutu givona wagaidiya, givona, “Malinai yami nogala wagaine ani Yaubada yana vona taidei giyegemona velemoena.” ");
INSERT INTO bwd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ada kaliva moyaidi Yeisu yana vona iawaveiwakanena ada vona iwaka-vagaidi giifufuyedi faina, meyadi gisidobona aku ivonaga, “Ida Iyosefa natuna, aiyo?” ");
INSERT INTO bwd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeisu givona wagaidiya, givona, “Gaalamanena. Yada vona seyana wagaine wana voneku, ‘O Tokivebwaina, tauni una kivebwainini.’ Ada kaduwe wana voneku, ‘Kivebwaina-dina anogalina ufaisewadi Kafaneumi wagaine ani anafaiweya kaduwe idedeku uda gugaiyedi. Faina taidei ani O Tauni ya melala.’” ");
INSERT INTO bwd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ada kaduwe givonedi, “Gavonemi velemoena, falofita ani tauna yana yoo yana fafali wagaine keke ida vemoimoine. ");
INSERT INTO bwd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aku gana vonemi velemoena, tuwaina falofita Ilaitiya yana toveya ani Isileli wagaine malamala toiye anatufo ani keke maita wei gida lugaga, ada loka lakaina giyegemona fafali matatabuna wagaine. Ada tova tayuwe wagaine sikwasikwayavo moyaidi Isileli anafafaliya imiyamiya ");
INSERT INTO bwd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","aku Yaubada Ilaitiya keke gida imili gidana vevine Isileli sikwasikwa-dina tamo wagaine, aku giimili ginau fafali-nai Saidoni anamelala Selefadi wagaine, sikwa seyadi wagaidiya badi keke vine Isileli. ");
INSERT INTO bwd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kaduwe falofita Ilaisa yana toveya tolefelo moyaidi imiyamiya Isileli negenine aku keke seyana Ilaisa gida kivebwaini ke gida kiveyegayegane Yaubada matane, tainei-mowa Nemani anakaibe, bana keke kwana Isileli aku kwana Siliya.” ");
INSERT INTO bwd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ada kaliva matatabudi manuwa ebavewala negenine ani Yeisu yana vona taidei inogalina wagaine inuwakoyo lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ada yoo itowamididi Yeisu iwavi giyegemona wamelaleya melala lakaina wagaine ada inauwena oya kabune, faina yadi melala-nai iyogona ani oya tabone ada nuwanuwadi Yeisu yavoleya ina velovona ke ina luvealikana. ");
INSERT INTO bwd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Aku Yeisu yoo adimwatuguya giyegemona ada tunutunugina ginau. ");
INSERT INTO bwd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ada Yeisu giobu ginau Kafaneumi, tainei melala lakaina Galili wagaine, ada Sabate wagaine givebutu kaliva givewaledi. ");
INSERT INTO bwd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ada kaliva meyadi gisidobodobona yana vewala-nai wagaine, faina yana ifufu ani veimeya wa anatoyogina nodi. ");
INSERT INTO bwd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aku wadedeku manuwa ebavewala wagaine kaliva seyana aluwaluwa bwanebwanenena nafone gimiyamiya. Ada givedou bonana lakaina, givona, ");
INSERT INTO bwd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A! Yeisu kwana Nasaledi, gavana nuwanuwa unagai wagaimeya? Gavaiyamu, uelai una luyavulema faina? Iya gaalamaneni o gavakaliva. Oyeni Yaubada yana Kaliva Tabutabuna!” ");
INSERT INTO bwd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Aku Yeisu giawatana givona, “Gina kuluni, ada una yegemona kaliva-nai wagaine.” Ada aluwaluwa bwanebwanenena yoo nefanidiya kaliva gibaina aku giyegemona, ada keke tamo kaliva vovona gida kivekoyo. ");
INSERT INTO bwd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kaliva moyaidi meyadi gibovu ada taudiyavo ivetolitoli, ivona, “Ida gavavona taidei? Veimeya wa anatoyogina nodi ada aluwaluwa bwanebwanenedi giveiveimeyedi ada iyegeyegemona!” ");
INSERT INTO bwd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ada Yeisu valeyana gimutula melala seyana seyana lilivadiya ani wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeisu manuwa ebavewala gisegena ada ginau Saimoni yana manuweya. Aku Saimoni lawana vavine ani iveoga, vovodi gilukalalava lakaina, ada Yeisu iveolena ke gina lemedi. ");
INSERT INTO bwd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ada Yeisu ginau adiivi lilivane gimididi aku veoga-nai giveimeyena, ada gisegedi-ku iveiwaka. Ada badi au itowamididi ke ivebutu adiga ikidewadewa. ");
INSERT INTO bwd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aku kauwana yana tova olu wagaine, kaliva moyaidi wa adiveoga tulina tulina ani tubuiyadiyavo ialiyedi Yeisu wagaine, ada nimana gisena seyana seyana wagaidiya ke gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ada kaduwe aluwaluwa koyona kaliva moyaidi nafodiya imiyamiya ani iyegemona aku ikovakova, “Oyeni Yaubada Natuna!” Aku Banae giawatadi ada keke gida awaegedi ina ifufu, faina ialamanena Banae Tauna au Mesaiya. ");
INSERT INTO bwd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ada malabutuya-mwaeya Yeisu Kafaneumi-deya giyegemona ginau mwatugu kavovona mamaveya. Ada kaliva ivebutu ilelena ada tova-nai inuwagana ke ibalalava vaita ina awatana keke gina segedi ginana. ");
INSERT INTO bwd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aku givonedi, “Iya gilubodaku kaduwe mali melala lakaidi wagaidiya gana lulumamalena Yaubada yana ebaveimeya anavaleya iwakana. Taide vuvuna-nai faina Iya giimiliku.” ");
INSERT INTO bwd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ada au giyegemona ginau Yudiya melala-dina wagaidiya ada gilulumamala-nau manuwa ebavewala wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tova seyana Yeisu gimididi Lavu Genesaleti taliyeya ada Yaubada yana vona gilulumamalena aku kaliva ani iyooyoofifina ke ina nogalina. ");
INSERT INTO bwd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aku giitana taliya lilivane waka iluwei toyauba isedi ada inau yadi guvata iikolakola. ");
INSERT INTO bwd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ada waka seyana wagaine Yeisu giyage, tainei Saimoni yana waka, ada giveolena maita-moena ina talalaka. Ada au waka wagaine givetogana aku kaliva givewaledi. ");
INSERT INTO bwd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tova-nai giifufu giavaina, Saimoni wagaine givona, “Waka una talalakavena gawaneya ke guvata una seobuye una yakunena ada igana una veonana.” ");
INSERT INTO bwd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aku Saimoni givonaga, “Kauveya, bogi anamatatabuna afaisewa toyogina, aku keke tamo ada veona. Aku uvona faina au guvata gana seobuyedi.” ");
INSERT INTO bwd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ada toyauba yadi guvata iyakunedi anafaiweya Yeisu givonedi ani au igana iveonadi, anayoo lakai-moena wagaine yadi guvata ivebutu ina agigidi. ");
INSERT INTO bwd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","E ada tubuiyadiyavo iluyaudiyedi waka velugana wagaine inaela ina lemedi, ada ielai ke waka iluwei ivemagadi velemoena, tayuwe wagaine ivebutu ina kamomola. ");
INSERT INTO bwd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aku Saimoni-Pita tova-nai gaitoma taidei giitana ada au Yeisu agene tugana givetodonena ada givona, “Kauveya, una segeku unanau, faina Iya tokoyona.” ");
INSERT INTO bwd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Faina tubuiyanavo nodi igana moyaina iveonadi wagaine meyadi gisidobodobona. ");
INSERT INTO bwd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","E, anafaiweya kadu Iyemesa ke Iyoni, badi Sebedi natunavo ani Saimoni anakeluyavo nodi tova moyaina iyubayubau. Ada Yeisu Saimoni givonena, “Keke una matauta. Tova malinai ke gina naunau ani oye kaliva aditoyauba.” ");
INSERT INTO bwd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ada iyalili ke yadi waka itaidi ilaka avaleya, ada gaitoma matatabuna au ilovedi imiya aku Yeisu imuliyena. ");
INSERT INTO bwd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Seyana tova Yeisu melala seyana lakaina wagaine gimiyamiya aku kaliva seyana gielai ani vovona matatabuna lefelo gikiwafina. Ada tova-nai kaliva-nai Yeisu giitana, au giodu magigina babi wagaine aku gialamamaiyena, givona, “Kauveya, gaalamanena O afaiweya una kiveyegayeganeku. E ada kai nuwanuwa aga uda gugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ada Yeisu nimana gitunena ke gisena kaliva wagaine aku givona, “Ika, nuwanuwaku. Una yegayegana.” Ada maduga-mowa analefelo giavaina. ");
INSERT INTO bwd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ada Yeisu giveimeyena givona, “Una nogalina. Keke tamo gaito una awatalatalaine aku unanau veyavo anatovegugai wagaine tauni una vewaleni, e ada gina itani vovo ani gibwaina. Ada ya yegayegana Yaubada matane faina ani una vebolavoi Yaubada wagaine Mosese giveimeya anafaiweya e ada kaliva moyaidi ina alamanena o velemoena bade uveiwaka.” ");
INSERT INTO bwd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aku Yeisu yana faisewa valeyana gimutula lakai-moena wagaine, kaliva yoo yoo ielai bonana ina nogalina ada adiveoga wagaidiya ina bwaina. ");
INSERT INTO bwd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aku Yeisu yana dewa ani tova moyaina yoo gisegesegedi aku ginaunau fafali kavovona giveoveola. ");
INSERT INTO bwd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yadayada seyana wagaine Yeisu kaliva givewavewaledi manuwa seyana wagaine aku Falisiyavo ada Mosese yana veimeya anatovewalayavo wadedeku kadu ivetoga, biyavo-dina ielai melala moyaina wagaidiya Galili ke Yudiya adifafali wagaidiya ada kadu Yelusalema. Ada Yaubada yana toyogina gimiyamiya Yeisu wagaine ke toveoga gina kivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ada kaliva tufodi ielai ani kaliva iwai ialiyena vaya wagaine, banae vovona memeluyana. E ani ibalalava vaita ina lukuwena manuwa negenine ke Yeisu matane inasena ");
INSERT INTO bwd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","aku wai keke ida nuwaga, faina yoo lakaina. E ada iwai ilakavena manuwa getane ada manuwa getana anaseboda kabisona ikakidi ada awagane kaliva iseobuyena anavaya wagaine yoo nefanidiya Yeisu magigine-mwane. ");
INSERT INTO bwd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ada Yeisu kaliva-dina yadi vetumagana giitana ke givona kaliva-nai wagaine, givona, “Natuku, ya koyona bademowa gavenuwaegedi.” ");
INSERT INTO bwd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aku Falisiyavo ke veimeya anatovewalayavo taudiyavo nuwainagediya ivona, “Ida gavakaliva ayo givonavona awadamana Yaubada wagaine? Keke seyana gaito anafata koyona gina venuwaegedi aku Yaubada anakaibe-mowa.” ");
INSERT INTO bwd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aku Yeisu yadi nuwanuwa gialamanena e ada gitolidadanedi, givona, “Gavaiyamu-yo taidei anafaiweya aseasemiya wanuwanuwa? ");
INSERT INTO bwd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gavavona meyameyagani-moena ganavona, ‘Ya koyona bademowa gavenuwaegedi’ o kai ganavona, ‘Una mididi ke una nudadana’? ");
INSERT INTO bwd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aku nuwanuwaku wana alamanena ani Banae Kaliva Natuna wa yana veimeya e ada anafaiweya kaliva yadi koyona gina venuwaegedi babi taidei wagaine.” Ada au kaliva-nai vovona memeluyana ani Yeisu givonena, “Iya gavoneni, una mididi, avaya una waina ada unanau ya manuweya.” ");
INSERT INTO bwd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ada maduga-mowa moyaidi matadiya gimididi ada anavaya giwaina ada ginau manuweya aku Yaubada giawadavadavana. ");
INSERT INTO bwd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ada kaliva moyaidi meyadi gisidobodobona ada Yaubada idavana, ivona, “Vona velemoena! Malinai gaitoma taidei ebanuwavogana velemoena kaitadi.” ");
INSERT INTO bwd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Muliya Yeisu giyegemona ginaunau aku giitana takesi anatoyaudi anayegana Livai ani yana takesi anavada wagaine givetovetoga. Ada Yeisu givonena, givona, “Unaela una muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ada gimididi gaitoma matatabuna gisedi aku Yeisu gimuliyena. ");
INSERT INTO bwd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ada muliya Livai yana manuweya kanibutu lakaina gifaisewana Yeisu faine, ada yoo lakai-moena ani takesi anatoyaudi ke kaduwe kaliva tufona badi nodi ienokekela teibeli lilivane ikanikani. ");
INSERT INTO bwd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aku Falisiyavo ada veimeya anatovewalayavo badi Falisi adiyoo ani Yeisu yana tonogalayavo wagaidiya igavoluvolu, ivona, “Gavana faina takesi anatoyaudi ke tokoyona nodi wakanikani ada wayugayuga?” ");
INSERT INTO bwd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeisu givonedi, “Badi gavega iwakadiyavo ani keke nuwanuwadi doketa, aku badi toveoga gaga ani nuwanuwadi. ");
INSERT INTO bwd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iya gaelai ani keke toyegayegana gana douwedi faina. Aiyada gaelai ke tokoyona gana douwedi ke yadi dewa koyona wagaidiya ina nuwavilana aku ina awaegedi Yaubada wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aku aimo seyana tova kaliva tufodi ielai Yeisu wagaine ke ivonena, “Iyoni yana tonogalayavo ani tova ke tova kani iiloilovau aku iveoveola, kaduwe Falisiyavo yadi tonogalayavo anafaiweya, aku O ya tonogalayavo ani kani gaga ada yuga gaga isei ginaunau.” ");
INSERT INTO bwd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ada Yeisu givona matalivulivuna wagaidiya, givona, “Nagi anakani vemwamwala wagaine ani gavaiyamu, amifaiweya tonagi tubuiyanavo wana veimeyedi kani ina iloilovau tova-nai tonagi kaliva nodi ina miyamiya? Keke, faina tonagi-nai nodi imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aku tova gielaelai wagaine kaliva tufodi inaela tonagi kaliva inavai tubuiyanavo wagaidiya-deya ke ina nauwena. E ada yadayada-dina wagaidiya kani ina iloilovau.” ");
INSERT INTO bwd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kaduwe givona matalivulivuna-vagila, givona, “Keke nuya evaguna wagaine kana kelili ebaibwadi faina ada kana etovefose nuya tuwaina wagaine. Kai kana gugaiyena aga nuya evaguna ginabuta wagaine gina siyauta ke gina agigina, ada kaduwe ebaibwadi nuya evaguna wagaine keke gida luboda gina vefafaliye nuya tuwaina. ");
INSERT INTO bwd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kaduwe anafaiweya, keke waini evaguna kana iwavedama tuwava kevakeva bubuna tuwaina wagaidiya. Faina waini evaguna yana lutuga wagaine tuwava bubu-dina gina fuwadi ada waini gina maduyabu ke tuwava bubu inakoyo. ");
INSERT INTO bwd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aku analauboda waini evaguna kana iwana tuwava evaguna wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ada kaduwe keke seyana gaito waini tuwaina ginayuga ayo muliya nuwanuwana waini evaguna, faina ginavona, ‘Ya! Waini tuwaina iwaka-moena.’” ");
INSERT INTO bwd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabate seyana wagaine Yeisu yana tonogalayavo nodi inunugolota bakula witi wagaidiya aku yana tonogalayavo ivebutu witi guwadi ikidakadaka imutumutudi nimadiya ada nafodi ikanikanidi. ");
INSERT INTO bwd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aku badi Falisiyavo ani iitadi ada itolidadana, ivona, “Gavana faina imi wagugai anafaiweya ada Sabate anaveimeya keke wada itaveyabi?” ");
INSERT INTO bwd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeisu gilufata wagaidiya, givonaga, “Aku maita waveyawanuwagana gavana Kini Deivida gigana tova-nai yana yooyavo nodi mafa gilavudi wagaine? ");
INSERT INTO bwd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Giluku Yaubada yana manuwa wagaine ada beledi vevetabuna Yaubada matane isena ani givai gikanina, ada kaduwe yana kalivayavo giveledi ikani. Aku beledi-nai ani wa anaveimeya vitana velemoena. Keke kaliva-kavokavovo inakani aku badi veyavo anatovegugai gaga adiawaega ke ina kanina.” ");
INSERT INTO bwd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ada kaduwe givona wagaidiya, givona, “Banae Kaliva Natuna ani Tauna Sabate anaKauveya.” ");
INSERT INTO bwd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kaduwe Sabate seyana wagaine Yeisu ginau manuwa ebavewala wagaine giluku givewavewala aku manuwa-nai wagaine ani kaliva seyana gimiyamiya nimana aiyatagina memeluyana. ");
INSERT INTO bwd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aku kaduwe badi Falisiyavo ada veimeya anatovewalayavo imiyamiya, ani badi vuvu ilelelena ke Yeisu ina awavekoyoyena. E ada Bana iitaitavenanauna ke ina itana kai Sabate wagaine aku nimakoyo-nai gina kivebwaina o keke. ");
INSERT INTO bwd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aku Yeisu gialamanena gavana inuwenuwena ada givona kaliva nimana koyona wagaine, “Unaela una mididi moyaidi matadiya.” Ada au wadedeku gimididi. ");
INSERT INTO bwd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ada Yeisu givonedi givona, “Yaku tolidadana wagaimiya, Sabate faina, gavaiyamu Veimeya anabuki wagaine giveimeyeda? Kana gugai iwakana kaliva wagaine o kai kana gugai koyona wagaine? Kai kaliva kana kibababalena o kai kana luyavulena?” ");
INSERT INTO bwd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ada giitadadana moyaidi wagaidiya aku givona nimakoyo wagaine, givonaga, “Nima una sivetotona.” Kaliva gigugai anafaiweya ada nimana au giveiwaka-yabu. ");
INSERT INTO bwd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aku badi Falisiyavo inuwakoyo velemoena ada ivebutu taudiyavo gaga iveifuifufuyena gavana idagai Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ada imiyamiya aku yadayada seyana wagaine Yeisu giyegemona ginau gilaka oya wagaine gina veoveola, ada bogi anamatatabuna giveoveola Yaubada wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mala gilavuna yana tonogalayavo gidouwedi ielai wagaine ada wagaidiya-deya givenuwadadanedi adituwelo, ani badi biyavo-dina givewagadi ‘afositolo’. ");
INSERT INTO bwd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ada tonogala-dina adiyegana taidei anafaiweya. Saimoni aku anayegana Yeisu givewagana ani Pita, anatubuluga Andulu, Iyemesa, Iyoni, Filipi, ke Batolomiu, ");
INSERT INTO bwd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Madiu, ke Tomasi, Iyemesa banae Alifiyo natuna, Saimoni bana ivewagana Seloti, ");
INSERT INTO bwd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ada Yudasa banae Iyemesa natuna, ada Yudasa Isakaliyota banae aimo Yeisu gina atuegena nibainavo nimadiya. ");
INSERT INTO bwd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aku Yeisu badi nodi iobuelai ada laulaubeuna wagaine imididi. Wadedeku yana tonogalayavo yoo lakaina imiyavagauta ada kaliva yoo tulituli fafali Yudiya anamatatabuna wagaine ielai, kaduwe Yelusalema, ada melala imiyamiya Taiya ke Saidoni aditaliyeya ani wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Biyavo-dina ielai Yeisu wagaine yana vewala ina nogala ke adiveoga wagaidiya ina bwaina. Ada badi aluwaluwa bwanebwanenedi ikivekoyodi ani gikiveiwakanedi. ");
INSERT INTO bwd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ada kaliva moyaidi igaluvaluva Yeisu wagaine nimadididi inasedi, faina toyogina Bana wagaine giyegeyegemona ke moyaidi gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ada tayuwe gaitoma-dina giavaina, Yeisu gimiyavilana yana tonogalayavo giitafasedi aku givonedi, givona, “Imi gavega fanifanimiyavo ani Yaubada giawanuwakabubuyemi faina Banae yana ebaveimeya wagaine wamiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Imi gavega malinai mafa gilavulavumi ani Yaubada giawanuwakabubuyemi faina aimo kamomi gina ivefatana. Imi gavega watagitagiya malinai, Yaubada giawanuwakabubuyemi faina aimo wana veleiga. ");
INSERT INTO bwd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kai kaliva ina agougemi ke yadi yoo wagaine amiyegana ina vaiyavulena imi Bana Kaliva Natuna wamulimuliyena faina, aga Yaubada gina awanuwakabubuyemi. Kadu kai ina awalakalakavemi ke ina awavekoyoyemi Banae wamulimuliyena faina, aga Yaubada gina awanuwakabubuyemi. ");
INSERT INTO bwd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Au yadayada-nai wagaine wa yami vemwamwala lakaina wana towavila wana tavola ke wana kasisi, faina gabameya fatami iwakana ke lakaina gimiyamiya. Faina tova tuwaina dewa-dina anafaiweya badi tamadiyavo nagona ani Yaubada yana falofitayavo idewayedi. ");
INSERT INTO bwd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aku oiyoi imi gavega wavekaikaiwabu! Vita lakaina wana nuwagana! Faina yami veiwaka bademowa wanuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Oiyoi imi gavega malinai wakani iwakana! Vita lakaina wana nuwagana! Faina aimo mafa gina lavumi. Ada oiyoi imi gavega malinai wa yami veleiga! Vita lakaina wana nuwagana! Faina aimo wana nuwavita ada wana tagiya. ");
INSERT INTO bwd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Oiyoi! Imi gavega malinai kaliva moyaidi iawaveiwakanemi! Vita lakaina wana nuwagana! Faina tamadiyavo tuwaina ani falofita fwayafwaya anafaiweya idewedi. ");
INSERT INTO bwd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Aku imi gavega wavanevanenegeku ani gana vonemi, nibaimiyavo wana nuwakabubuyedi. Badi gavega iagouga wagaimiya ani wana gugai iwakana wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Badi gavega ialatabutabuyemi ani wana awanuwakabubuyedi. Ada badi gavega igugai koyona wagaimiya ani wana veoveola faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kai tamo gaito gina nuwakoyo ada aiyaimi seyana gina tafina, aga wana awaege kadu fafalina gina tafina. Ada kai tamo gaito aminuya badobadona gina vaina, aga keke wana awata aku amiseti kaduwe gina vaina. ");
INSERT INTO bwd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kai gaito gina veolemi gavana tamo faina aga wana velena. Ada kai gaito seyana yami giba seyana gina vaina, aga keke wanavone ke wana vaiyewe kaduwe. ");
INSERT INTO bwd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kai nuwanuwami kaliva inadewa iwakana wagaimiya, aga nagona ani imi wanadewa iwakana badi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kai gavega amitonuwakabubu gaga wanuwakabubuyedi, aga gavaiyamu, wanuwanuwa vaita amiawaveiwakana wana nuwagana? Keke. Au badi tokoyona ani badi gavega inuwakabubuyedi ani badiyavo kaduwe inuwakabubuyedi. ");
INSERT INTO bwd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ada kai badi gavega igugai iwakana wagaimiya ada wagaidiya gaga wana gugai iwakana, aga gavaiyamu, wanuwanuwa vaita amiawaveiwakana wana nuwagana? Keke. Au badi tokoyona ani kaduwe anafaiweya idewadewa. ");
INSERT INTO bwd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ada kai kaliva gavana seyana wana veledi ada wana itaitaboda inafata-vagilena, aga gavaiyamu, wanuwanuwa vaita amiawaveiwakana wana nuwagana? Keke. Au badi tokoyona ani kaduwe anafaiweya ivelavelau tokoyona wagaidiya e ada anatubuga anafaiweya ina nuwaga-vagilena. ");
INSERT INTO bwd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aku nibaimiyavo wana nuwakabubuyedi ke wana gugai iwakana wagaidiya ada wana velavelau wagaidiya aku keke wana itaitaboda anafata-veyewa faina. Kai taidei anafaiweya wanadewa aga aimo fatami iwakana ke lakaina wana nuwagana, ada imi Yaubada Togetanemwane natunavo. Faina Banae ani badi gavega keke tovonavesiule ada kaduwe tokoyona aku wa yana nuwakalikali gidewedewedi iwakana. ");
INSERT INTO bwd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tamami gabameya ginuwakalikaliyemi anafaiweya, imi kadu kaliva wana nuwakalikaliyedi. ");
INSERT INTO bwd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Keke kaliva wanavona venuvenuwadadanedi, ada kaduwe Yaubada imi keke ginavona venuvenuwadadanemi. Kaliva keke wana itavenuwadadane vaita wa yadi koyona imiyamiya ke matavuloga adilauboda, ada kaduwe Yaubada keke gina nuwanuwa anafaiweya faimiya. Kaliva yadi dewa koyona wana venuwaegedi, ada kaduwe Yaubada yami dewa koyona gina venuwaegedi. ");
INSERT INTO bwd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kaliva wagaidiya wana vutuga ada Yaubada gina vutuga wagaimiya. Yami vutuga fatana anaveyewa ani anaetowava ginamaga-mowa, faina ginadodo ginalaka kaduwe gina atudonedone ginaobu ada kadu ginadodo-vagile gina vemaga-iwaiwana ada gina iwana magigimiya. Faina etowava-nai wagaine wavutuga, anafaiweya etowava-nai wagaine Yaubada gina vutuga wagaimiya.” ");
INSERT INTO bwd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ada Yeisu kadu givonedi vona matalivulivuna taidei wagaine, givona, “Kaliva matana koyo-moena ani keke anafata tubuiyana matana kaduwe koyo-moena gina nagoye, faina aimo adiselu ina beuluga olu wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tonogala ani keke ida kaiwabusege yadi tovewala, aku badi gavega alamana inavai-dewedewena ke yadi sikulu ina luyabu aga inadewa yadi tovewala anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gavana faina geyalili kabiso-moena tubuiya matana wagaine ani uitaita aku tauni mataniya ani ai tuli gimiyamiya aku keke uda itainana? ");
INSERT INTO bwd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gavaiyamu-yo tubuiya wagaine uvonavona, ‘Tubuiyaku, unagai geyalili kabisona gana vaina mata wagaine’ aku o tauni ani ai tuli mataniya? O meyalagalaga, gilubodana nagona ai tuli tauni mataniya una vaiyavulena, e ada muliya unaita dewadewa ke geyalili kabisona tubuiya matane una vaina.” ");
INSERT INTO bwd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kaduwe givona, “Ai iwakana keke gina veguwaye guwa koyona, kaduwe ai koyona keke gina veguwaye guwa iwakana. ");
INSERT INTO bwd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ai seyana seyana tauna guwana wagaine kana itainanana kai ai iwakana o ai koyona. Keke alaa guwana kaliva ida kolukolu sikakakama wagaine, kadu gileifi guwana keke kaliva ida kolukolu gudana onaonagidi wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kadu anafaiweya kaliva iwakadi. Ivonavona iwakana faina nuwanuwa iwakadi ivelakavidi aseasedi wagaidiya ani iyegeyegemona. Aku kaliva koyodi ani ivonavona koyona faina nuwanuwa koyodi ivelakavidi aseasedi wagaidiya iyegeyegemona. Faina gavana givemaga-iwaiwana kaliva aseasediya, tainei awadiya ivonavonayena. ");
INSERT INTO bwd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Gavana faina akuyegana wainainana, ‘Kauveya, Kauveya,’ aku gavana gavonevonemi ani keke wada gugugai? ");
INSERT INTO bwd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gavega ielaelai wagaikuya ada yaku vona inoganogalidi ke ivegugaiyedi ani badi gana vewalemi gavaiyamu adiitaita. ");
INSERT INTO bwd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Badi vaita kaliva manuwa giyogona anafaiweya. Nagona babi giyala giobu dibune-mwane ada avutuwa gisena ani kabala wagaine gitutubakibaki gididina. Ada aimo tova-nai wei gilugaga lakaina ke wayagata gimaduna manuwa-nai tayuwe wagaine aku keke anafata gina etoyaweli, faina giyogona velemoena. ");
INSERT INTO bwd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aku badi gavega yaku vona inoganogalina aku keke ida vegugaiye ani badi anafaiweya kaliva manuwa giyogona babi gagana wagaine, keke avutuwa kabala wagaine gida tutubakidi gida dididi. Ada aimo tova-nai wei gilugaga lakaina ke wayagata gimadu manuwa tayuwe wagaine, au maduga-mowa gibeu ada matatabuna giayaweyaweli-yabuna.” ");
INSERT INTO bwd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tova-nai Yeisu giluyabu yana vona-dina taidei kaliva wagaidiya, ada muliya ginau Kafaneumi wagaine giluku. ");
INSERT INTO bwd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wadedeku-deya Loma tolugaviya aditonagona seyana gimiyamiya, ada yana togugai seyana giveoga lakaina ke tova kabisona gida alika. Ada tonagona-nai giawaveiwakanena velemoena togugai-nai. ");
INSERT INTO bwd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ada tolugaviya aditonagona Yeisu valeyana ginogalina, ada meIsileli yadi kaliva lakaidi tufodi giimilidi inau Yeisu wagaine ke ina veolena ginaelai yana togugai gina kivebwainina. ");
INSERT INTO bwd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ada tova-nai Yeisu wagaine ielai ada iveolena toyogina, ivona, “Kaliva taidei analauboda-mowa oye una lemena, ");
INSERT INTO bwd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","faina banae ide yada kalivamomo meIsileli moyaidi ginuwakabubuyedi, ada yada manuwa ebavewala giyogona tauna yana mani wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","E ada Yeisu nodi inau. Aimo manuwa lilivane ginuitaitana aku tonagona tubuiyanavo giimilidi bonana giveledi anafaiweya, ina vonena, “Kauveya, Tauni keke una kivevitani, faina Iya keke kaliva iwakaku e ada keke analauboda o unaela unaluku yaku manuweya. ");
INSERT INTO bwd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tainei faina keke gadaela wagainiya. Aku udavona-mowa ada yaku togugai gina bwaina. ");
INSERT INTO bwd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Faina Iya kaduwe akutoveimeya yana veimeya dibune gamiyamiya, ada yaku tolugaviyamomo yaku veimeya dibune imiyamiya. Yaku tolugaviya seyana gana vonena, ‘Unanau,’ ada au ginanau. Kadu seyana gana vonena, ‘Unaelai,’ ada au ginaelai. Anafaiweya kaduwe yaku togugai wagaine ganavona, ‘Taidei una faisewana,’ ada gina faisewana.” ");
INSERT INTO bwd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ada Yeisu ginogalina tolugaviya aditonagona yana vona taidei ada bana faine meyana gisidobona, ada gimiyavilana yoo imulimuliyena ani wagaidiya givona, “Gana vonemi, Iya ganudadananau Isileli anafafali moyaidi wagaidiya aku keke tamo gaito gada nuwaga yana vetumagana anatoyogina kaliva taide kwana Loma anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ada badi kaliva-dina gavega tonagona giimilidi ani iyewadi manuweya, ada inuwagana togugai bademowa iwakana. ");
INSERT INTO bwd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ada yadayada tayuwe muline, Yeisu ginau melala lakaina anayegana Neini wagaine, ada yana tonogalayavo ke yoo lakaina nodi inau. ");
INSERT INTO bwd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ada melala lakaina anawana lilivane ginunuyegemona ani giitana kaliva toalika iwai iyegeyegemona. Aku toalika-nai inana sikwasikwadi badi natudi kaliva anakaibe-mowa tubueyana. Ada yoo lakaina sikwa-dina ikwayabudi nodi melala lakaina wagaine ielai. ");
INSERT INTO bwd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ada tova-nai Kauveya sikwa giitadi wagaine, ginuwakalikaliyedi ke givonedi, “Keke wana tagiya.” ");
INSERT INTO bwd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ada ginau vaya wagaine nimadidina gisedi ada badi towai inumididi aku Yeisu givona, “Kwamana, gavona wagainiya, una mididi.” ");
INSERT INTO bwd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ada toalika gimididi givetoga ke givebutu giifufu, ada Yeisu gilemena ada inana giveledi. ");
INSERT INTO bwd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ada moyaidi imatauta lakaina ke Yaubada iawadavadavana ivona, “Falofita lakaina giyegemona wagaideya!” ada “Yaubada gielai yana kalivamomo gina lemeda.” ");
INSERT INTO bwd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ada valeya taidei Yeisu faine gimutula Yudiya anafafali matatabuna ada kaduwe gibalawalilivuga lilivane melala-dina wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aku Iyoni Tobabitaiso yana tonogalayavo inau ada Iyoni ivonena gaitoma moyaina gavana Yeisu gifaifaisewadi. E ada Iyoni yana tonogalayavo adiselu gidouwedi ielai ");
INSERT INTO bwd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ada giimilidi Kauveya wagaine ina tolidadanena, ina vonaga, “Gavaiyamu, Oye kaliva-moe Tauni Mesaiya, Banae ide kaveitabodebodena vaita ginaelai? O kai kaliva seyana aimo ana bodana?” ");
INSERT INTO bwd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ada kaliva-dina adiselu ielai Yeisu wagaine, ivonaga, “Iyoni Tobabitaiso giimilima aelai wagainiya ana tolidadana, ‘Gavaiyamu, Oye kaliva-moe Tauni Mesaiya, Banae ide kaveitabodebodena vaita ginaelai? O kai kaliva seyana aimo ana bodana?’” ");
INSERT INTO bwd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ada tayuwe tova-nai wagaine kaliva moyaidi badi gavega adiveoga tulidi tulidi, kaduwe gavega aluwaluwa koyodi wagaidiya ani Yeisu gikivebwainidi ada kaduwe tufona moyaidi matadi koyo-moedi ani matadi gikiveiwakanedi. ");
INSERT INTO bwd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ada Yeisu gilufata Iyoni yana tomatawa wagaidiya, givona, “Wana yewami Iyoni wagaine ke gavana gagugaiyedi waitadi kadu gaifufuyedi wanogalidi ani faidiya wana ifufuyena. Taidei anafaiweya wanavona, ‘Badi matadi koyo-moedi ani iita iwakana, tovefela inunudadana, badi gavega lefelo wagaidiya ani ibwaina ke yadi yegayegana ivaina, badi tagadi bwadana ani giafolena, toalika iyawa-vagila, ada kaduwe fanifanidiyavo ani Yaubada yana valeya iwakana inoganogalina.’ ");
INSERT INTO bwd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kaduwe Iyoni wana vonena, ‘Badi gavega keke ida nuwakila ke yadi vetumagana Iya wagaikuya keke idasege ani Yaubada giawanuwakabubuyedi.’” ");
INSERT INTO bwd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ada badi Iyoni yana tomatawa isegedi inau aku Yeisu givebutu yoo wagaidiya giifufu Iyoni faine, givonaga, “Tova-nai wayegemona wanau fafali kavovona wagaine Iyoni wana itana faina, imi gavaiyamu wanuwanuwa, vaita gavana wadaita? Vaita kaliva yana nuwanuwa tova moyaina gisevedavedama anafaiweya laimwagu lukuna mala giliuda gifilina? ");
INSERT INTO bwd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kai keke, aga wanau gavana wadaita? Kai kaliva giveigavu nuya adiita iwakadi wagaine? Keke, faina badi gavega wa adiveigavu kaikaiwabuna ada imiya kaikaiwabu ani kini yadi manuwa kaikaiwabudi wagaidiya imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","E aku imi wanau evona gavana wadaita? Anaita Yaubada yana falofita seyana wada itana? Ika velemoena, au falofita waitana, aku bana Iyoni ani anayegana lakai-moena ke anaita lakaina ayo falofitayavo moyaidi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bana Iyoni-nai faine Buki Tabu wagaine ivetokilumina, ivona, ‘Yaku tomatawa gana imili wai gina nagona ke ya wai kaliva aseasediya gina kidewedewena.’ ");
INSERT INTO bwd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Gana vonemi, kaliva moyaidi vevine ivenatunedi wagaidiya ani keke seyana gaito anayegana lakaina ani Iyoni anayegana gidasege. E aku Yaubada yana ebaveimeya wagaine gaito anayegana kabiso-moena ani banae gitubusegena Iyoni.” ");
INSERT INTO bwd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ada kaliva moyaidi kaduwe takesi anatoyaudi nodi tova-nai Yeisu yana vona inogalina ada iawaveiwakana, ivona, “Vona velemoena Yaubada yana wai ani tunutunugina.” Taidei anafaiweya ivona faina badi bademowa ibabitaiso Iyoni wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aku Falisiyavo ada veimeya anatonuwauya Yaubada yana nuwanuwa taudiyavo faidiya ani idibusoyogena, faina badi debaidi gitoyoga ada keke nuwanuwadi ina nuwavila ke Iyoni gina kivebabitaisodi. ");
INSERT INTO bwd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ada kaduwe Yeisu givona, “Tova malinai anayooyavo ani gavana wagaine gana itaveluveye? Badi gavana anafaiweya adiita? ");
INSERT INTO bwd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Badi anafaiweya biyabiyama ivetovetoga iveneganega maketi wagaine ada yoo seyana ivedovedou kaduwe yoo seyana wagaidiya, ivonavona, ‘Nagi anakweli aveneganegayedi aku imi keke wada tavotavola. Ada alika anaitavuna anakweli aveneganegayedi aku imi keke wada tagitagiya.’ ");
INSERT INTO bwd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Taidei anafaiweya gavona faina kaliva malinai ani badiyavo anafaiweya. Faina Iyoni Tobabitaiso gielai ada keke aa iwakana gida kanikani kaduwe keke waini gida yuyui, aku au imi waawavekoyoyena wavonaga, ‘Banae aluwaluwa koyona nafone gimiyamiya.’ ");
INSERT INTO bwd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aku Banae Kaliva Natuna gielai ada aa iwakana gikanikani ke waini giyuyuga, ani kaduwe Banae waawavekoyoyena, wavona, ‘Wana itana, kaliva taidei awatabewa ada waini giyugayuga-faila, kaduwe takesi anatoyaudi ke tokoyona givetubuiyanedi!’ ");
INSERT INTO bwd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aku badi gavega Yaubada yana nuwauya imulimuliyena ani kaliva ina itanuwagana yadi gugai wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tova seyana Falisi seyana anayegana Saimoni ani ginuwabiyena Yeisu ada nodi inakani, e ada Yeisu ginau Falisi-nai yana manuweya ada gienokekela inakani teibeli wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ada melala-nai wagaine vavine seyana bana tokoyona. Ada tova-nai alamana givaina vaita Yeisu Falisi yana manuweya gienokekela gikanikani teibeli wagaine ani ginau manuwa-nai wagaine. Ada bunama magana iwaka-moena givai gialiyena anatuwava kabala anayegana ‘alabasita’ wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ada gielai Yeisu muline gimididi gitagitagiya agene, aku matailuna wagaine Yeisu agena givebutadi ani givebutu kuluwana manamanawena wagaine giluegegedi. Ada wa yana vemoimoina nodi agena giveyaveyaugidi aku bunama giiwavekelolona ke gibunamidi. ");
INSERT INTO bwd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aku Falisi-nai banae ginuwabiyena Yeisu ani giitana ada nuwainagene-deya givona, “Kai kaliva taidei falofita velemoena, aga gida alamanena vavine taidei banae gaito, faina nimadidina gisedi wagaine aku banae tokoyona.” ");
INSERT INTO bwd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ada Yeisu gialamanena Falisi-nai yana nuwanuwa ada givonena, “Saimoni, Iya nuwanuwa seyana gana voneni.” Ada givona, “Tovewala, una voneku.” ");
INSERT INTO bwd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ada Yeisu vona matalivulivuna wagaine givonena, “Kaliva adiselu iketowai kaliva seyana yana mani wagaine. Ada seyana anaketowai faifi analedi (500) siliva aku seyana fifiti (50). ");
INSERT INTO bwd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","E aku adiselu yadi mani keke ada keke adifaiweya adiketowai inafata, e ada tonimani au adiselu givenuwaegedi adiketowai. Ada una voneku, adiselu wagaidiya gavakaliva aimo tonimani gina nuwakabubuye lakai-moena?” ");
INSERT INTO bwd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimoni gilufata givona, “Iya ganuwanuwa banae kaliva-nai anaketowai lakaina givenuwaegena.” Yeisu givona, “Uvenuwadadana tunutunugina.” ");
INSERT INTO bwd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ada gimiyavilana vavine wagaine aku Saimoni wagaine givona, “Uitana vavine taidei. Iya gaelai ya manuweya galuku gavetoawakawaka aku adagiduwa veawakawaka faidiya keke uda gugaiye. Keke uda veimeya ada gufa ida aliye ageku idakola, aku banae ani ageku givebutadi matailuna wagaine ada kuluwana wagaine giluegegedi. ");
INSERT INTO bwd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Oye keke uda veyaugiku adagiduwa anafaiweya, aku vavine taidei tova-nai galuku wagaine badi ivebutu ageku iveyaugi-vavagilena. ");
INSERT INTO bwd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Oye bunama keke uda iwavekelolo kuluwaku wagaine adagiduwa anafaiweya, aku banae ani bunama giiwavekelolona ageku wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Taidei faina gana voneni ani vavine taidei yana koyona moyaina bademowa venuvenuwaegedi faina, ginuwakabubu lakai-moena. Aku banae gaito ani yana koyona keke moyaina aku Yaubada givenuwaegedi, ani banae yana nuwakabubu kabisona.” ");
INSERT INTO bwd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ada Yeisu givona vavine wagaine, “Ya koyona bademowa gavenuwaegedi.” ");
INSERT INTO bwd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aku badi gavega ivetoga ada nodi ikanikani teibeli wagaine ani ivebutu taudiyavo wagaidiya ivonavona, “Ida gavakaliva taidei ayo koyona givenuwaegedi?” ");
INSERT INTO bwd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aku Yeisu vavine wagaine givona, “Ya vetumagana gikibababaleni. Wa ya nuwaniwalova unanau.” ");
INSERT INTO bwd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ada keke tova manamanawena aku Yeisu gibalawalilivuga melala lakaidi ke melala kabisodi wagaidiya, gilulumamala valeya iwakana Yaubada yana ebaveimeya faina. Ada tonogalayavo adituwelo nodi, ");
INSERT INTO bwd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ada kaduwe vevine tufodi gikiveiwakanedi aluwaluwa koyodi o kai veoga vitadi wagaidiya. Ani vevine-dina anafaiweya Meli vine Magidala banae wagaine aluwaluwa bwanebwanenedi seveni Yeisu giveyegemonidi, ");
INSERT INTO bwd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ada Yowana badi Kusa vavinena, banae kaliva-nai ani Elodi yana manuwa matatabuna anatoveimeya, ke Susana ada kaduwe vevine moyaidi. Taidei vevine-dina ani taudiyavo yadi lokoloko wagaidiya Yeisu yana tonogalayavo nodi ilemelemedi. ");
INSERT INTO bwd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ada seyana tova melala seyana seyana wagaidiya kaliva moyaidi itauya ielai Yeisu wagaine ivagauta, ada vona matalivulivuna taidei wagaine givonedi, givona, ");
INSERT INTO bwd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kaliva seyana ginau ada yana bakula wagaine witi waifeina gina yavuledi. Ada waifei giyavuyavuledi aku tufona ibeu wai wagaine ke kaliva iela ivaga tabodiya inau aku manuga ielai ke waifei-dina iitadi ada imadukani-yabudi. ");
INSERT INTO bwd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kadu tufona ibeu kakanafaya wagaine, ada tova-nai ilukabukabu ilaka ani imayewadi, faina babi ayayana. ");
INSERT INTO bwd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kadu tufona ibeu sikakakama wagaine, ada nodi itabo-tamwai ilaka ani sikakakama witi gifaimunudi ialika. ");
INSERT INTO bwd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aku tufona ibeu babi iwakana wagaine ani itabo iwakana, ada iveguwa anayoo analedi moyai-moena.” Ada Yeisu anafaiweya givona giavaina ke bonana moiyalina givona, “Imi gavega wa tagami ani vona taidei wada nogalina.” ");
INSERT INTO bwd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Muliya yana tonogalayavo itolidadanena vona matalivulivuna taidei anaalamana faine ada ");
INSERT INTO bwd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yeisu givona, “Imi wagaimiya ani amiawaega ke Yaubada yana ebaveimeya ananuwanuwa sewasewavuyedi wana alamanena, aku badi mali kaliva wagaidiya gana ifufu matalivulivuna, e ada ‘auwe ina itaita aku keke inaita ke ina alamane, ada ina noganogala aku keke nuwadi ginamali.’ ");
INSERT INTO bwd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Taidei anafaiweya vona matalivulivuna ananuwanuwa. Waifei ani Yaubada yana vona. ");
INSERT INTO bwd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ada waifei-dina ibeu wai wagaine ananuwanuwa ani badi gavega Yaubada yana vona inogalina. Inogalina e ani Seitani gielai ada vona-nai givaiyavulena aseasediya e ada keke ina vetumagana ke adikibababala ina nuwaga. ");
INSERT INTO bwd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aku waifei ibeu kakanafaya wagaine ananuwanuwa ani badi gavega Yaubada yana vona inogalina ada wa yadi vemwamwala ivetumaganena. Aku vona-nai ani keke idavai ada idasei aseasediya ida miyami, vaita walamidi keke idasei. E ada tova maufo-moena ivetumagana, aku tova galuvaluva anatova wagaine, maduga-mowa ina segena. ");
INSERT INTO bwd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aku waifei giyavuyavulena sikakakama wagaine ananuwanuwa ani taidei anafaiweya. Badi gavega Yaubada yana vona inogalina, aku yawaidi yana nauna wagaine ani babi anagaitoma moyaina ananuwanuwa ada kaikaiwabu ke babi anavemwamwala wagaine ivenuwana lakaina. E ada venuwana-nai ani banae anafaiweya vaita Yaubada yana vona-nai gifaifaimununa, e ada yawaidi wagaine iveguwa ani keke gida kumagi. ");
INSERT INTO bwd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aku waifei ibeu babi iwakana wagaine ananuwanuwa ani badi gavega iwakadiyavo ada Yaubada yana vona inogalina ada aseasediya isedi ke inuwaudududi, ada wa yadi atuvefaila guwa iwakana iseseyegemonena.” ");
INSERT INTO bwd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kaduwe Yeisu givonedi, givonaga, “Keke seyana gaito mayale ginakabu ada gina sewavuye wela dibune o kai ivi dibune. Au gina selakaina anaebaibo wagaine, e ada badi gavega ina lukuelai ani adifaiweya malina ina itana. ");
INSERT INTO bwd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Faina gaitoma-dina tova malinai sewasewavuyedi ani aimo ina ivemogatalidi, kaduwe gaitoma-dina lulukabubudi ani aimo ina seyegemonedi malina wagaine ke kaliva moyaidi ina alamanedi. ");
INSERT INTO bwd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tainei faina wana venuwadadana velemoena gavaiyamu Yaubada yana vona wanoganogalina. Faina badi gavega Yaubada yana vona inogalina ke ivevefaisewana ani badi kaduwe alamana gina veledi. Aku badi gavega Yaubada yana vona faina ivetumagana vaita taudiyavo au adifaiweya e ada vona-nai keke ida vevefaisewa, aga taidei alamana-nai kabisona wagaidiya ani Yaubada gina vaiyegena wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yeisu aimo yoo wagaidiya giifuifufu aku inana ke tainavo ielai ina itana, aku yoo lakaina faina keke adifaiweya inana lilivane. ");
INSERT INTO bwd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Au seyana kaliva gimatawena givona, “Ina ada taimomo imidimididi waiyedeya. Nuwanuwadi ina itani.” ");
INSERT INTO bwd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeisu givonaga, “Badi gavega Yaubada bonana inogalina ada ivegugaiyena, badi Iya inaku ke tubuiyakuweyavo.” ");
INSERT INTO bwd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tova seyana Yeisu yana tonogalayavo nodi waka wagaine iyage, ada givonediga, “Kana damana lavu fafaline.” E ada itauya idamadamana. ");
INSERT INTO bwd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Inaunau aku Yeisu givenobali gidaudau. Mala toyogina au gifuwa giobuelai lavu wagaine, e ada gufa waka giiwatavutavuna ada igilagi lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Badi tonogalayavo ina ilivaguna, ivona, “Kauveya! Kauveya! Kabiso-moena kana yababa!” Au Yeisu gimididi ada mala ke buli ivelavelalaga giawatadi, ada mala giatagona ke matatabuna giniwalova. ");
INSERT INTO bwd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aku yana tonogalayavo givonedi, “Yami vetumagana gadedeku wasei?” Ada meyadi ibovu aku imatauta, ada taudiyavo ivetolitoli ivona, “Ida gavakaliva ayo mala ke buli nonogana giveimeyedi ada bonana inogali!” ");
INSERT INTO bwd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aku Yeisu yana tonogalayavo nodi idamana ke iyegemona meGelasa yadi fafali wagaine, tainei Lavu Galili fafalina kana itadamanena. ");
INSERT INTO bwd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ada Yeisu giobu taliyeya ani kaliva seyana melala lakaina wagaine gielai wagaine. Kaliva-nai ani aluwaluwa koyodi nafone imiyamiya, ada tova manamanawena keke nuya gida oseosedi. Kaduwe, keke gida miyami manuweya aku didikula wagaidiya gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Didikula wagaidiya gimiyamiya faina tova-nai kai aluwaluwa koyodi yadi toyogina ginagai gina avaulina kaliva wagaine, aga nimana ke agena auwe kaliva ina seinidi ada anatoitaveyabina ina itaitana aku seini gina gologoloidi, ada aluwaluwa koyodi kaliva-nai iluluvemadugina ke gina naunau mamaveya mwatugu-kavovona wagaine. E ada Yeisu aluwaluwa bwanebwanenedi giveimeyedi ke ina yegemona kaliva wagaine, aku kaliva-nai givedou moiyalina ada gibeu Yeisu magigine aku bonana lakaina wagaine givona, “Yeisu, O Yaubada Togetane-mwane Natuna, gavana unagai wagaikuya? Gaveoveola keke una kiveulouloloniku!” ");
INSERT INTO bwd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeisu gitolidadanena, givona, “Gavaiyamu ayegana?” Banae gilufata, givona, “Iya Manuwafo.” Anayegana-nai giinanana anafaiweya faina aluwaluwa bwanebwanenedi moyaidi nafone imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ada badi aluwaluwa-dina ialamamaiyena vaita keke gina veimeyedi inana olu keke wa anaebalauyabu wagaine. Tayuwe fafali-nai ani aluwaluwa koyodi ada Seitani nodi yadi ebamiya. ");
INSERT INTO bwd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","E aku lilivadiya oya afaine ani bawe moyaidi iduwaduwala, ada aluwaluwa bwanebwanenedi Yeisu ialamamaiyena ke gina imilidi inaluku bawe wagaidiya, ada giawaegedi. ");
INSERT INTO bwd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","E ada au iyegemona kaliva-nai wagaine aku inau bawe wagaidiya iluku. Ada au bawe matatabudi oya wagaine iluyabayabanunuga iobu lavu wagaine ke ikamomola. ");
INSERT INTO bwd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aku kaliva bawe iitaitaveyabidi ani tova-nai iitana gavana giyegemona bawe wagaidiya ada iveotaota imadu inau ada iawatalatalaina melala lakaina ke melala kabisodi matatabuna wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ada kaliva itauya inau gavana giyegemona ina itana. Ada ielai Yeisu wagaine ani iitana kaliva-nai aluwaluwa bwanebwanenedi iyegemona wagaine ani givetovetoga Yeisu agene, aku bademowa yana nuwanuwa giveiwaka ke wa ananuya gimiyamiya. Ada yoo-dina iitana ani imatauta lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ada kaliva-dina gavega iitana gavana giyegemona ani ivonedi gavaiyamu Yeisu kaliva gikivebwaini. ");
INSERT INTO bwd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ada Gelasa yana ebaveimeya anakalivayavo moyaidi Yeisu iveolena gina segedi ginanau, faina imatauta-mowa. E ada giyage waka wagaine ada isegedi aku itauya inau. ");
INSERT INTO bwd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bana kaliva aluwaluwa bwanebwanenedi iyegemona wagaine ani gialamamaiyena, nuwanuwana vaita nodi idanau, aku Yeisu giveyewana ada givonena, givona, ");
INSERT INTO bwd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Una yewani unanau ya manuweya ada una ifufu gavaiyamu Yaubada gigugai lakaina fainiya.” Ada au bana kaliva-nai giyewa ginau ada gavaiyamu Yeisu gigugai lakaina faine ani giifufudadanena melala lakaina matatabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ada kaduwe Yeisu giyewa-vagilena lavu fafaline wagaine, yoo wadedeku-deya ivesiuleyena, faina moyaidi iveitabodaboda faine. ");
INSERT INTO bwd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aku kaliva seyana gielai anayegana Yailo, banae manuwa ebavewala anatonagona seyana. Ada Yeisu agene tugana givetodonena aku giveola toyogina vaita nodi idanau yana manuweya, ");
INSERT INTO bwd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","faina natuna vavine tubueyana anamalamala tuwelo ani gialialika. E ada Yeisu gitauya nodi inaunau Yailo yana manuweya, aku nau-nai wagaine yoo ififina ivetutuwaiwainau. ");
INSERT INTO bwd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aku yoo-dina wagaidiya vavine seyana banae anaveoga ani malamala tuwelo dayagina gimadumadu. Doketa fatadi wagaine yana mani matatabuna giluyabuna, aku keke tamo gaito anafaiweya gina kiveiwakane. ");
INSERT INTO bwd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ada vavine-nai Yeisu wamuline gielai ke ananuya bwatana wagaine nimadidina gisedi, ada maduga-mowa dayagina gimadumadu ani giilovau. ");
INSERT INTO bwd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Au Yeisu givona, “Gaito nimadidina gisedi wagaikuya?” Ani moyaidi ivewa, ada Pita givona, “Kauveya, kaliva iyoofifini ada ivetuvetutuni!” ");
INSERT INTO bwd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aku Yeisu givona, “Gaito seyana nimadidina gisedi wagaikuya, faina galutovonina vaita toyogina giyegemona wagaikuya-deya.” ");
INSERT INTO bwd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Au vavine giitana keke anafata gina ikavuya e ada wavetatavina gielai ada giodu tugana givetodonena Yeisu agene. Ada kaliva moyaidi matadiya aku giifufu Yeisu wagaine gavana faina nimadidina gisei wagaine ada gavaiyamu gimadubwaina. ");
INSERT INTO bwd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ada Yeisu givona wagaine, givona, “Natuku, ya vetumagana gikivebwainini. Wa ya nuwaniwalova unanau.” ");
INSERT INTO bwd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ada aimo giifuifufu aku kaliva seyana gielai Yailo yana manuweya-deya ada givona Yailo wagaine, “Natu bademowa yawaina giavaina. Tovewala keke una luluveyavale ke yana tova gina venuwaegege.” ");
INSERT INTO bwd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aku Yeisu vona taidei ginogalina ada givona Yailo wagaine, “Keke una matauta. Au una vetumagana ada gina veiwaka.” ");
INSERT INTO bwd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ada gielai Yailo yana manuweya aku keke seyana gaito gida awaege nodi inaluku, tainei-mowa Pita, Iyoni ke Iyemesa, ada kwamana inana ke tamana. ");
INSERT INTO bwd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ada kaliva moyaidi itagitagiya ke itagi-vonavona kwamana faine, aku Yeisu givonedi, givona, “Auwe tagiya. Kwamana keke gida alika aku gidaudau.” ");
INSERT INTO bwd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Aku badi ialamanena ani kwamana gialika e ada Yeisu iveleigena. ");
INSERT INTO bwd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aku Yeisu kwamana nimane gikiveyabi ada givona, “Natuku, una mididi!” ");
INSERT INTO bwd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ada kwamana aluwaluwana giyewa-vagila ada maduga-mowa gimididi. Ada Yeisu givonedi vaita aa tamo inavele gina kanina. ");
INSERT INTO bwd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kwamana inana tamana meyadi gisidobodobona, aku giveimeyedi keke seyana gaito inavone gavana giyegemona faina. ");
INSERT INTO bwd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ada Yeisu afositoloyavo adituwelo gidouwevagauwidi ada toyogina ke veimeya giveledi e ada wa yadi veimeya aluwaluwa bwanebwanenedi ina veyegemonidi kaliva wagaidiya, ada kaduwe kaliva wa adiveoga ina kivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ada giimilidi iyegemona ke Yaubada yana ebaveimeya faina ina lumamala ke toveoga ina kivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ada givonediga, “Keke tamo gavana wanavai yami nau-nai faina, keke aiwala, keke fose, keke aa, keke mani, ada keke seti anavelu. ");
INSERT INTO bwd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gavamanuwa wagaine wana maduluku, tainei wagaine wana miyamiya analaba wana tauya-vagila. ");
INSERT INTO bwd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ada gavamelala wagaine wanaluku aku anakaliva keke ina sivaivaimi nodi wanamiya, aga melala wana segena wagaine anasivu ageyafayafamiya wana vatuegegena. Wada iyaiyaya seyana aimo Yaubada yana matavuloga wagaidiya faina.” ");
INSERT INTO bwd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ada afositoloyavo iyegemona ada ina iluku-nau melala moyaina wagaidiya valeya iwakana ilulumamalena ada toveoga ikikivebwainidi fafali matatabuna wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aku Elodi, banae Galili anatoveimeya, ani ginogalina gaitoma-dina moyaidi iyegeyegemona ada givenuwavogana. Faina kaliva tufodi ivona evona Yaubada Iyoni Tobabitaiso alikeya gisiveyawana, ");
INSERT INTO bwd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","aku tufodi ivona vaita Ilaitiya giyegemona, kaduwe tufodi ivona vaita tova tuwaina anafalofita seyana giyawa-vagila. ");
INSERT INTO bwd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Aku Elodi givona, “Iya gaveimeya ada Iyoni odona ilugoloina, e aku ida gavakaliva valeyana taidei ganoganogali?” Ada wai gilelelena ke Yeisu gina itana. ");
INSERT INTO bwd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ada afositoloyavo iyewadi ielai ada gavana igai yadi nau-nai wagaine ani Yeisu iawatalatalainena. Ada muliya adiloi gaga givaidi nodi inau melala lakaina anayegana Bedesaida wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aku yoo ikaiyanogala gadedeku Yeisu yana tonogalayavo nodi ina e ada imuliye inau. Ada au ielai ada Yeisu givagauledi ke giifufu wagaidiya Yaubada yana ebaveimeya faina, ada gavega wa adiveoga ani gikivebwainidi. ");
INSERT INTO bwd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mala givelavilavi aku tonogalayavo adituwelo ielai Yeisu wagaine ivona, “Yoo uda imilidi idanau melala wagaidiya kadu anabudokayavo wagaidiya ada aa ke ebada idalele, faina ida mwatugu kavovona wagaine kamiyamiya.” ");
INSERT INTO bwd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aku Bana gilufata wagaidiya, givonaga, “Imi taumiyavo aa wana veledi inakani.” Badi ivonaga, “Ime wagaimeya beledi faifi gaga ada igana iluwei. Aku gavaiyamu, nuwanuwa ananau ada aa ana kimone yoo taidei faidiya?” ");
INSERT INTO bwd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Taidei anafaiweya ivona faina taine yoo-nai ani kai kaliva gaga ida veyawadi aga adiyoo anafaiweya faifi tausani (5,000). Aku Yeisu yana tonogalayavo givonedi, “Kaliva wana vonedi ina vetoga adiyoo anafaiweya fifiti (50) fifiti (50) wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ada tonogalayavo igugai anafaiweya, ada moyaidi ivetogadi. ");
INSERT INTO bwd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ada Yeisu beledi faifi kadu igana iluwei givaidi ada giitalaka gabama wagaine aku givona vesiule Yaubada wagaine, ada beledi gikiineinedi ke giveledi tonogalayavo ke badi ivutugena kaliva wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ada moyaidi ikani ke kamodi ifata. Ada aditufo ikwakwana ani fuwama tuwelo ivemagadi. ");
INSERT INTO bwd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tova seyana Yeisu anakaibe-mowa gina giveoveola aku kadu yana tonogalayavo lilivane imiyamiya. Ada gitolidadanedi, givona, “Wana voneku, gavaiyamu kaliva ivonavona evona vaita Iya gaito?” ");
INSERT INTO bwd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Badi ilufata ivona, “Tufodi ivona vaita Oye Iyoni Tobabitaiso. Aku tufodi ivona vaita Oye falofita Ilaitiya, kaduwe tufodi ivona vaita Oye ani tova tuwaina anafalofita seyana giyewa-vagilena wayawaina.” ");
INSERT INTO bwd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ada kaduwe gitolidadanedi, givona, “Aku imiyavo, gavaiyamu wavonavona, evo vaita Iya gaito?” Pita gilufata, givona, “Oyeni ani au Mesaiya Yaubada giimilini.” ");
INSERT INTO bwd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeisu vona-nai giluyabuna, ada giawatadi ada veimeya toyogina giveledi keke seyana gaito wagaine gaitoma taidei ina awamogatale. ");
INSERT INTO bwd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ada kaduwe givona, “Banae Kaliva Natuna anaveimeya givaina ke gaitoma moyaina gina uloloyedi kaliva nimadiya. Badi meIsileli yadi kaliva lakaidiyavo ke Yaubada yana veyavo anatovegugai lakaidiyavo kaduwe veimeya anatovewalayavo nodi ina awaididiyena. Ada ina luvealikana, aku yadayada anaveto wagaine alikeya Yaubada gina siveyawana.” ");
INSERT INTO bwd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ada moyaidi wagaidiya Yeisu givona, “Kai badi gavega nuwanuwadi inaela ina muliyeku, aga gilubodana taudiyavo yadi nuwanuwa ina dibusoyogedi aku yadayada seyana seyana taudiyavo adikelose ina avalana ke ina muliyeku. ");
INSERT INTO bwd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Faina badi gavega nuwanuwadi taudiyavo yawaidi ina kibababaledi ani yawaidi ina nusegedi. Aku gavega Iya faikuya yawaidi ina nusegedi ani yawaidi ina kibababaledi. ");
INSERT INTO bwd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Faina kai gavega babi anagiba matatabuna inavai-yabudi aku taudiyavo yawaidi adikibababala-vagata ida nusegedi, aga gavana anaiwakana? Au keke. ");
INSERT INTO bwd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kai badi gavega Iya faikuya ke yaku vona faina ina vovomumu, aga Banae Kaliva Natuna gina vovomumuyedi. Taidei gina yegemona tova-nai ginaelai wa yana iwakana mamalina wagaine ke Tamana yana iwakana mamalina wagaine ada aneloseyavo tabutabudiyavo yadi iwakana mamalina wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aku gavona velemoena wagaimiya, tufomi idedeku wamidimididi ani aimo keke alika wanamadu lutovoni aku nagona Yaubada yana ebaveimeya wana itana.” ");
INSERT INTO bwd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yeisu vona taidei givonayena anafaiweya ada yadayada eita giavaidi Pita, Iyoni, ke Iyemesa givagauledi nodi ilaka oya wagaine ina veoveola. ");
INSERT INTO bwd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ada Yeisu giveoveola aku magigina anaita gisevedavedama ada ananuya gikwayafofolina, anamalina vaita atunama anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ada kaliva adiselu, Mosese ke Ilaitiya, iyegemona gabama anamalina wagaine ada Yeisu nodi iifuifufu. Aku yadi veifuifufu-nai ani Yeisu yana alika faina, taine tova kabisona gina kiveyegemonina velemoena Yelusalema wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aku Pita ada tubuiyanavo nodi ienowavulu idaudau, ada tova-nai ienoviladi wagaine ani iitana Yeisu yana iwakana mamalina ada kaduwe kaliva adiselu Banae nodi imidimididi. ");
INSERT INTO bwd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ada Mosese ke Ilaitiya tova-nai Yeisu isege inaunau ani au Pita Yeisu givonena, givona, “Kauveya, ida iwaka-moena faina ime nodi idedeku kamiyamiya. Ada vada toiye ana yogodi, seyana O fainiya, seyana Mosese faine, kaduwe seyana Ilaitiya faine.” Taidei anafaiweya givona faina keke gida alamane gavana gina vonaye e ada givona-kavokavovo. ");
INSERT INTO bwd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ada aimo giifuifufu aku buibui giyegemo ke gibwatavudi, e ada tonogalayavo au imatauta. ");
INSERT INTO bwd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ada bonabona giyegemona buibui wagaine-deya, givona, “Taidei ani Iya Natuku, Banae gavenuwadadanena. Bonana wana nogalina.” ");
INSERT INTO bwd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ada bonabona givona giavaina ada iitadadana ani Yeisu anakaibe-mowa iitana. Ada gavana iitana tova-nai wagaine ani ikiveyabina nuwadiya, ada keke seyana gaito idavone tova tayuwe wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mala gilavuna Yeisu yana tonogalayavo aditoto nodi oyeya-deya iobuelai ada yoo lakaina ielai Yeisu ina itana. ");
INSERT INTO bwd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ada kaliva seyana yoo negenidiya givedou, givona, “Tovewala, gaveoveoleni natuku kaliva uda itana, faina bana au natuku tubueyana. ");
INSERT INTO bwd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aluwaluwa koyona gina kidonedonena ada maduga-mowa ginagai gina kwekwekwela, kaduwe aluwaluwa-nai ginagai gina vetatava lakaina e ada awabugo gialaiwaiwagena. Keke maita gida segesege aku giivekimana ke gikikivekoyo-moena. ");
INSERT INTO bwd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ada ya tonogalayavo gaalamamaiyedi ida veyegemonina, aku keke adifata.” ");
INSERT INTO bwd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeisu givonediga, “Imi tova malinai anayooyavo ani yami vetumagana keke, ada nuwanuwa matatabuna tunutunugidi ani wakikivebaladi. Gavaiyei tova Iya nodi kana miyami ada gana atuvefailemi? Natu una aliyena idedeku.” ");
INSERT INTO bwd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ada kwamana kaliva aimo gielaelai ani aluwaluwa koyona gibaina babi wagaine ayo gigai givetatava lakaina. Aku Yeisu aluwaluwa-nai giawatana ada kwamana wagaine giveyegemonina, ada kwamana gikiveiwakanena e ada givele-yewena tamana wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ada kaliva moyaidi meyadi gisidobodobona Yaubada yana toyogina lakaina wagaine. Ada aimo ivemeyasidobodobo Yeisu yana gugai-dina moyaina wagaine aku Banae yana tonogalayavo wagaidiya givona, ");
INSERT INTO bwd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Wana nogalavutuvutu velemoena gavana ganavona wagaimiya. Tova kabisona Banae Kaliva Natuna ina atuegena kaliva nimadiya ke ina kiveyabina.” ");
INSERT INTO bwd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aku yana vona-nai ani badi keke nuwadi gidamali faina. Anaalamana ani sewasewavuyena wagaidiya e ada keke ina alamane. Ada nuwanuwa-nai anaalamana faine badi keke nuwanuwadi ina tolidadane, faina imatauta. ");
INSERT INTO bwd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ada tonogalayavo ivebutu taudiyavo ivevonavona evona gaito wagaidiya-deya anayegana lakai-moena. ");
INSERT INTO bwd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aku Yeisu yadi nuwanuwa bademowa gialamanena, e ada kwamana kabisona givai lilivane givemididina ");
INSERT INTO bwd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ada givonedi, givona, “Badi gavega kwamana taidei kabisona akuyeganeya isivaivaina, ina Iya kadu isivaivaiku. Ada gavega Iya isivaivaiku, ina Banae giimiliku kadu isivaivaina. Faina gaito tauna gikiobuyena ke givetogugai moyaimi wagaimiya, banae anayegana lakai-moena.” ");
INSERT INTO bwd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ada Iyoni givona, “Kauveya, ime kaliva aitana ani ayeganeya aluwaluwa bwanebwanenedi giveyegemonidi. E ada aawatana, faina banae keke yada yoo wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeisu givona, “Keke wana awata, faina gavega keke ida venibainemi ani badi amitoleme.” ");
INSERT INTO bwd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tova bademowa givelilivana ada Yeisu ginayewa ginalaka gabameya, ada yana nuwanuwa gisena toyogina ginanau Yelusalema faina. ");
INSERT INTO bwd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ada yanana Yelusalema wagaine ani ginaluku Sameliya, e ada valeya anatonauwa gimadu imilidi wai inagona. Ada badi ina iluku melala seyana Sameliya wagaine ke ebamiya ina kidewadewa Yeisu faine ke gina veyawai yanana wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aku melala-nai anakalivamomo keke ida sivaivai, faina ialamanena ani Yeisu ginaunau Yelusalema faine. ");
INSERT INTO bwd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ada tonogalayavo Iyemesa ke Iyoni tova-nai iitana yadi awata-nai e ada ivona, “Kauveya, gavaiyamu? Nuwanuwa ada ai alalata ana douwe gina obuelai gabameya-deya ke gina luveyawaliyedi?” ");
INSERT INTO bwd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Aku Yeisu gimiyavila giduweyedi ada givona, “Auwe, keke anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ada au kadu melala seyana wagaine inau. ");
INSERT INTO bwd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ada inaunau wai wagaine aku kaliva seyana givona Yeisu wagaine, “Gadedeku O unanau aga Iya nodi.” ");
INSERT INTO bwd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeisu gilufata wagaine, givonaga, “Galuweta walawala wa adiluwa ada kaduwe manuga wa adiuba, aku Banae Kaliva Natuna ani keke tamo yana ebamiya ke gina venobali gina veyawai.” ");
INSERT INTO bwd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","E ayo Yeisu kadu kaliva seyana wagaine givona, “Una muliyeku.” Aku kaliva gilufata givona, “Kauveya, uda awaegeku nagona gadanau ada kamaku gada tavuna ayo gadaela gada muliyeni.” ");
INSERT INTO bwd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aku Yeisu givonena, “Badi gavega aluwaluwadi alialikana ani unasei taudiyavo yadi toalika ina tavuna. Aku oyeni ani unanau ada Yaubada yana ebaveimeya faina una lumamala.” ");
INSERT INTO bwd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kaduwe kaliva seyana givona Yeisu wagaine, “Kauveya, Iya gana muliyeni, aku nagona una awaegeku ganayewa yaku gabuyavo wagaidiya gana vetalakafoi.” ");
INSERT INTO bwd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeisu gilufata givona, “Kai seyana gaito gimulimuliyauta waka wagaine aku tova moyaina gimiyamiyavila mulina giitaitana, tainei keke analauboda. Ada kadu anafaiweya, kai seyana gaito gina gugugai Yaubada yana ebaveimeya faina aku kaduwe gina nuwanuwayewa tauna yana nuwanuwa faina, aga banae keke analauboda gina gugai Yaubada yana ebaveimeya faina.” ");
INSERT INTO bwd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Taidei tova-nai muline Kauveya Yeisu kaduwe tufona tonogalayavo givenuwadadanedi adiseveniti-tu, ada wai nagona giimilidi iluwei iluwei ina yegemona inanau melala lakaidi ke melala kabisodi seyana seyana wagaidiya, gadedeku givenuwadadanedi ani tova kabisona ginanau wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ada givonedi, “Bavagu lakai-moena aku tofaisewa keke moyaidi. Taidei faina bavagu anaKauveya wana veolena ke tofaisewa gina imilidi ina yegemona inanau yana bakula giboyalina bavagu faina. ");
INSERT INTO bwd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Waitana, Iya gaimiimilimi wana yegemona wananau vaita lami anafaiweya, wanaunau galuweta walawala manimaninidi adimwatuguya. ");
INSERT INTO bwd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","E ada wananau aku keke mani anaebavedodoga wanavai, keke fose, kaduwe keke ageyafayafa. Ada wai wagaine keke kaliva nodi wana mididi wana ifuifufu tova manamanawena. ");
INSERT INTO bwd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Gavamanuwa wagaine wanaluku, nagona manuwa anatomiya wana vonedi, wanavona, ‘Yaubada yana nuwaniwalova gina miyamiya wagaimiya.’ ");
INSERT INTO bwd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kai toni manuwa wadedeku banae nuwaniwalova anakaliva, aga yami vona gina venogalena ada yami nuwaniwalova-nai ginamiya wagaine. Aku kai keke, aga yami nuwaniwalova-nai gina yewana wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ada manuwa-nai seyana wagaine wana miyamiya, ada gavana ina velemi wana kanina ke wanayuga, faina togugai adilauboda fatana ina nuwagana badi biyavo-dina ilemelemedi wagaidiya. Aku keke wana miyamiyadadana mali manuwa mali manuwa wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Gavatoveya wanaluku melala seyana wagaine ada ina vagaulemi ke gava aa matamiya inasena, tainei wana kanina. ");
INSERT INTO bwd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Badi gavega toveoga wadedeku imiyamiya ani wana kiveiwakanedi ke wana vonedi, ‘Yaubada yana ebaveimeya bademowa gielai lilivamiya.’ ");
INSERT INTO bwd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Aku gavatoveya wanaluku melala seyana wagaine aku anakaliva keke ina vagaulemi, aga wananau melala-nai anawai nefanine ada wanavona, ");
INSERT INTO bwd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yami melala anasivu ifotadi agemeya ani avatuegegena wagaimiya. Taidei iyaiyaya seyana aimo Yaubada yana matavuloga wagaimiya faina. E aku taidei wana alamanena ani Yaubada yana ebaveimeya bademowa givelilivana.’ ");
INSERT INTO bwd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gana vonemi, aimo vonayavuga anayadayada wagaine, melala-nai anatomiya idibusoyogemi ani adimatavuloga koyo-moena ayo muliya meSodoma adimatavuloga.” ");
INSERT INTO bwd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kaduwe Yeisu givona, “Oiyoi meKolasini! Vita lakaina wana nuwagana! Oiyoi meBedasaida! Vita lakaina wana nuwagana! Faina gugai ebameyasidobodobo gafaisewadi amimwatuguya nonogana keke wada nuwavila. Aku kai gugai-dina gada faisewadi badi kaliva koyodiyavo meTaiya ke meSaidoni adimwatuguya aga badi tuwai-moena ida nuwavilana ke wa adinuya koyodi ida vetovetoga avu wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aimo vonayavuga anayadayada wagaine meTaiya ada meSaidoni ani adimatavuloga vitana, aku imi meKolasini ke meBedasaida ani vita-moena. ");
INSERT INTO bwd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ada imi meKafaneumi, gavaiyamu, evona taumiyavo wana kilakaimi vaita wanalaka gabameya? Keke! Velemoena ina segeobuyemi eli wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ada Yeisu yana tonogalayavo wagaidiya givona, “Badi gavega imi yami vona inogalina, ina Iya kadu yaku vona inogalina. Aku gavega imi idibusoyogemi, ina Iya kadu idibusoyogeku. Ada gavega Iya idibusoyogeku, ina Banae giimiliku kadu idibusoyogena.” ");
INSERT INTO bwd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ada tonogalayavo adiseveniti-tu wa yadi vemwamwala nodi iyewadi ada ivona, “Kauveya, badi aluwaluwa bwanebwanenedi nonogana ayeganeya aveimeyedi ina yegemona kaliva wagaidiya ani bonama iabina.” ");
INSERT INTO bwd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeisu gilufata givona, “Seitani gaitana gabameya-deya gibeu anafaiweya atunama. ");
INSERT INTO bwd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Waitana, Iya bademowa veimeya gavelemi ada mota ke alagavigavi wana vagatagodi aku keke ina yovami. Ada kaduwe amigaviya Seitani yana toyogina matatabuna wana toyogisegedi e ada keke tamo gavana ina kivekoyomi. ");
INSERT INTO bwd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","E aku keke wana vemwamwala aluwaluwa koyodi taudiyavo iawaegedi wagaimiya faina, aku velemoena wana vemwamwala faina amiyegana gabameya ivetokilumina.” ");
INSERT INTO bwd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tayuwe tova-nai wagaine Aluwaluwa Tabuna Yeisu gikivemwamwalina lakaina e ada givona, “Kamaku, Oyeni ani gabama ke babi adiKaiwabu ke adiKauveya, ada gavesiule wagainiya faina gaitoma-dina adialamana usewavuyena badi tonuwanuwa velemoena ke toalamana wagaidiya e ada keke ina alamane, aku badi vaita biyabiyama anafaiweya ani wagaidiya uivemogatalina. Ika Kamaku, taidei ya ebavemwamwala faina anafaiweya ugugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ada kaduwe Yeisu yoo wagaidiya givona, “Gaitoma moyaina bademowa Kamaku gisedi nimakuya. Keke tamo gaito Banae Yaubada Natuna gida alamane, au Tamana anakaibe gialamanena. Ada kaduwe anafaiweya Tamana, keke tamo gaito gida alamane, au Natuna anakaibe gialamanena ada kaduwe biyavo-dina givenuwadadanedi ani badi wagaidiya Tamana gina ivemogatalina ke ina alamanena.” ");
INSERT INTO bwd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ada gimiyavilana yana tonogalayavo adiloi gaga wagaidiya aku givonedi, “Ebavemwamwala wagaimiya gavana waitana faina. ");
INSERT INTO bwd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Faina gavonemi velemoena, tova tuwaina falofitayavo ada kiniyavo moyaidi nuwanuwadi lakaina ina itana gaitoma taidei waitaitadi, aku keke idaita. Ada kaduwe nuwanuwadi ina nogalidi gavana wanoganogalidi, aku keke ida nogali.” ");
INSERT INTO bwd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tova seyana Mosese yana veimeya anatonuwauya seyana nuwanuwana Yeisu gina galuvaluvana, e ada gimididi gitolidadanena, givona, “Tovewala, gavana gana gugai ayo yawai-vagata gana nuwaga?” ");
INSERT INTO bwd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeisu gilufata, givona, “Mosese yana veimeya wagaine gavaiyamu ivetokilumi? Gavaiyamu anaalamana veimeya wagaine givona miya-vagata faina?” ");
INSERT INTO bwd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Banae givona, “KAUVEYA Banae ya Yaubada una nuwakabubuyena asease matatabuna wagaine ke aluwaluwa matatabuna wagaine, kadu ya toyogina matatabuna wagaine ke nuwa matatabuna wagaine. Ada kaliva una nuwakabubuyedi o tauni unuwakabubuyeni anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeisu givona, “Ulufata tunutunugina. Taidei anafaiweya una gugai ada yawai-vagata una nuwagana.” ");
INSERT INTO bwd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aku veimeya anatonuwauya nuwanuwana tauna gina seyegemonina vaita banae toyegayegana, e ada gitolidadanena Yeisu, givona, “Ada gavakaliva gada nuwakabubuye?” ");
INSERT INTO bwd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeisu gilufata, givona, “Kwana Isileli seyana Yelusalema wagaine giobu ginaunau Yeliko. Ada wai wagaine tokiyafu ginuwagadi ada ikiveyabina, ananuya iveyalili-yabudi, ada ilumalimaliwavuna e ada kabisona ida luvealikana aku itauya inau. ");
INSERT INTO bwd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ada tayuwe tova-nai gilunuwagana ani veyavo anatovegugai seyana giobu ginaunau wai-nai wagaine, ani au giitana kaliva ada ginukeketa wai fafalina wagaine ginau. ");
INSERT INTO bwd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ada kaduwe anafaiweya Livai unumina anakaliva seyana ani gielai fafali-nai wagaine ani giitana kaliva-nai ada gikeketa wai fafaline ginau. ");
INSERT INTO bwd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aku muliya kwana Sameliya seyana ginaunau wai-nai wagaine, ada giyegemona kaliva-nai gidaudau wagaine ani giitana ada ginuwakalikaliyena. ");
INSERT INTO bwd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ginau kaliva wagaine ada bunama ke waini giiwadi anakima wagaidiya ada gifaidi. Muliya kaliva giwaina ada gidodona tauna yana doniki wagaine ke ginauwena manuwa wakawaka wagaine giitaveyabina. ");
INSERT INTO bwd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mala gilavuna yadayada anavelu wagaine, siliva iluwei givaidi ada manuwa wakawaka anatoitaveyabina givelena. Ada givonena, ‘Kaliva taidei una itaveyabina ada tova-nai ganayewa-vagileku idedeku-deya, aga gavaiyei mani uvefaisewana wagaine aimo kaduwe anafaiweya gana fataveyewana.’” ");
INSERT INTO bwd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ada Yeisu veimeya anatonuwauya gitolidadanena, givona, “Aditoto wagaidiya, gavakaliva banae kaliva-nai gigilagi tokiyafu nimadiya ani givetubuiyanena velemoena?” ");
INSERT INTO bwd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Veimeya anatonuwauya gilufata, givona, “Banae kaliva-nai ginuwakalikaliyena ada gilemena.” Yeisu givonena, “Unanau ada una dewa anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aku Yeisu yana tonogalayavo nodi yadi nau-nai wagaine ielai melala seyana wagaine ada vavine anayegana Mata banae givagauledi inau yana manuweya. ");
INSERT INTO bwd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ada banae anatubuluga anayegana Meli ani givetoga Kauveya agene ada gavana giifuifufu ani ginoganogala. ");
INSERT INTO bwd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Aku Mata ani aa moyaina gikidewadewa wagaine gifaisewa vologilogi. Ada gielai Yeisu wagaine givona, “Kauveya, gavaiyamu, keke uda nuwanuwa tainei akutubuluga gisegeku ada akukaibe-mowa gafaifaisewa? Unavone gina lemeku!” ");
INSERT INTO bwd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kauveya gilufata, givonenaga, “Mata, gaitoma moyaidi faidiya uvenuwana lakaina ada uvologilogi, ");
INSERT INTO bwd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","aku gilubodana gaitoma seya-moena analauboda. Gavana Meli givenuwadadanena ani iwaka-moena, ada keke kana vaiyavule wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tova seyana Yeisu giveoveola fafali seyana wagaine. Tova-nai giluyabu, yana tonogala seyana givonena, givona, “Kauveya, veoveola una vewalema anafaiweya Iyoni yana tonogalayavo givewaledi.” ");
INSERT INTO bwd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeisu givona wagaidiya, givona, “Tova-nai wana veoveola, aga taidei anafaiweya wanavona, ‘Tamama, ayegana tabu ana vemoimoinena. Ya ebaveimeya gidaelai. ");
INSERT INTO bwd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yadayada seyana seyana amaga uda velevelema. ");
INSERT INTO bwd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yama koyona uda venuwaegedi, faina imeyavo kaliva yadi koyona wagaimeya bademowa avenuwaegau. Ada ebaaladibidibi wagaidiya keke uda awaegema.’” ");
INSERT INTO bwd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kaduwe givona wagaidiya, givona, “Kai wagaimiya gaito seyana boginafa gidanau tubuiyana wagaine ada gidavona, ‘Kusebo, tubuiyaku seyana yanana wagaine gielai wagaikuya atuwadeya, aku keke tamo aa wagaikuya ada ganasei matane ke ginakani. E ada beledi toiye uda veleku.’ ");
INSERT INTO bwd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“E ada vetawaneya kaliva-nai ginavona, ‘Keke una siveiveitaku. Bademowa wana falifalina ada natukuweyavo nodi adaudau iviya. Keke akufaiweya gana mididi gavana tamo gana veleni.’ ");
INSERT INTO bwd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Gavonemi velemoena, au keke-mowa gina mididi ke tamo gavana ginavele faina banae ani tubuiyana, keke. Aku bana kaliva-nai gikwageye giveola-vavagila faina, gina mididi ada gavana nuwanuwana ani gina velena. ");
INSERT INTO bwd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ada Iya gana vonemi, wana veoveola Yaubada wagaine ada gina velemi. Wana lelele ada wana nuwagana. Ada wana lufifita ke wagaimiya Yaubada wana gina yavuna. ");
INSERT INTO bwd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Faina gavega ina veoveola, Yaubada gina veledi. Kaduwe gavega ina lelele, ina nuwagana. Ada badi gavega ina lufifita aga Yaubada wana gina yavuna faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Gava tama wagaimiya kai natuna ginaela gina veola igana faina aga gavaiyamu, mota gina velena? Keke. ");
INSERT INTO bwd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O kai gina veola fou faina, aga alagavigavi gina velena? Keke. ");
INSERT INTO bwd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Imi tokoyona aku nuwakabubu iwakana waveleveledi natumiyavo, aku velemoena Tamada gabameya ani Banae iwaka-moena. E ada kai badi gavega ina veoveolena Aluwaluwa Tabuna faina, aga Bana gina veledi.” ");
INSERT INTO bwd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tova seyana Yeisu aluwaluwa koyona giveyegemonina kaliva wagaine. Aluwaluwa-nai gaugauna. Ada aluwaluwa koyona kaliva gisegena wagaine, kaliva-nai gaugauna givebutu giifufu. Ada yoo meyadi gisidobodobona. ");
INSERT INTO bwd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aku tufodi ivona, “Ina Biyelisibuli banae aluwaluwa koyodi aditoveimeya ani banae yana toyogina wagaine Yeisu aluwaluwa koyodi giveveyegemonidi.” ");
INSERT INTO bwd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kaduwe tufodi nuwanuwadi Yeisu ina galuvaluvana faina, iveolena ke gugai ebameyasidobodobo seyana Yaubada wagaine gida faisewana ke ida itana. ");
INSERT INTO bwd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aku Yeisu yadi nuwanuwa gialamanena e ada givonedi, “Gava ebaveimeya seyana aku anayoo taudiyavo ina ludakadi e ada yoo tulina tulina nodi ina lulugaviya, aga ebaveimeya-nai ginabeu. Kaduwe gava unuma seyana aku anakalivayavo taudiyavo ina ludakadi ke nodi ina lulugaviya, aga unuma-nai ginabeu. ");
INSERT INTO bwd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kaduwe anafaiweya, kai Seitani tauna yana yoo gina venibainena e ada yana ebaveimeya gina ludakana, aga gavaiyamu yana ebaveimeya gina mididi? Keke meyameyaganina. Taidei gavona faina imi wavona evona Biyelisibuli yana toyogineya aluwaluwa bwanebwanenedi gaveveyegemonidi. ");
INSERT INTO bwd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aku kai Iya Biyelisibuli yana toyogineya gaveveyegemonidi, aga gaito yami tomuliyayavo toyogina giveledi ayo aluwaluwa koyodi iveveyegemonidi? E ada taumiyavo yami tomuliyayavo inavona venuvenuwadadanemi vaita wavona sidamana. ");
INSERT INTO bwd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aku kai Yaubada yana toyogineya aluwaluwa bwanenedi gaveveyegemonidi, aga wada alamanena vaita Yaubada yana ebaveimeya bademowa giyegemona wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kai kaliva totoyogina yana ebalugaviya analokoloko gina kiveyabidi ada tauna yana manuwa gina miyababalina, aga yana giba moyaina inamiya iwakadi. ");
INSERT INTO bwd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aku kai kaliva seyana toyogi-moena ginaela gina mununa ke gina toyogisegena, aga yana lokoloko gaviya givetumaganedi ani au ginavai gina nauwedi aku yana giba-dina givaidi ani gina vutugena. ");
INSERT INTO bwd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Banae gaito Iya keke nodi, ani banae givenibaineku. Kaduwe banae gaito keke kaliva gida vagavagauwidi ke Iya nodi ada gugai seyana, ina banae gidewadewa vaita kaliva gida wavidi e ada keke ina muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kaduwe Yeisu givona, “Tova-nai aluwaluwa bwanebwanenena kaliva gina miyasegena aga gina tauya ginanau fafali ayayana wagaidiya ebaveyawai gina lelena. Aku keke tamo gina nuwaga e ada gina vonaga, ‘Gana yewaku yaku ebamiya gasegena wagaine.’ ");
INSERT INTO bwd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ada aluwaluwa-nai gina yewana yana ebamiya-nai gina itana au yegayegana, vaita tamo gaito gida sedewedewe. ");
INSERT INTO bwd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","E ada gina tauya ginanau kadu aluwaluwa bwanebwanenedi adiseveni gina vagauledi badi koyo-moedi ayo muliya tauna, ani inaelai ada matatabudi inaluku kaliva-nai wagaine inamiya. Ada nagona kaliva yana miya koyona, aku muliya aluwaluwa koyodi moyaidi iluku wagaine ada yana miya ani velemoena au gikoyo-mowa.” ");
INSERT INTO bwd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ada taidei gaitoma-dina Yeisu givonavonayedi e aku vavine seyana ivedou yoo negenidiya ivonaga, “Badi vavine-dina ivenatuneni ke ivesusuni ani Yaubada giawanuwakabubuyedi.” ");
INSERT INTO bwd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aku Yeisu gilufata, givona, “Aku anavelemoena ani badi gavega Yaubada bonana inogalina ke imatawalewaleyena, ani Banae giawanuwakabubuyedi.” ");
INSERT INTO bwd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yoo iveiveinala aku Yeisu givona wagaidiya, givona, “Tova malinai anayooyavo ani koyodiyavo. Nuwanuwadi iyaiyaya ebameyasidobodobo ina itana, aku keke tamo ina nuwaga, tainei-mowa iyaiyaya-nai giyegemona Iyona wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Faina Iyona ani giveiyaiyaya meNinive wagaidiya, ada kaduwe anafaiweya Banae Kaliva Natuna gina veiyaiyaya badi tova malinai anayooyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aimo vonayavuga anatoveya, wabolimaneya anakwini ina mididi imi malinai anakalivamomo nodi ada gavana iwakana igugai ani gina vewala vaita imi yami dewa ani koyo-moena, e ada amilauboda Yaubada yana matavuloga wana nuwagana. Faina badi fafali atuwada lakaina wagaine aku itauya ielai Kini Solomoni yana vewala nuwanuwauya ina nogala. Aku wana itana, tova malinai seyana gielai idedeku ani Banae gitubusegena Solomoni. ");
INSERT INTO bwd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kaduwe anafaiweya, aimo vonayavuga anatoveya meNinive ina mididi imi malinai anakalivamomo nodi ada gavana iwakana igugai ani gina vewala vaita imi yami dewa koyo-moena, e ada amilauboda Yaubada yana matavuloga wana nuwagana. Faina tuwaina badi meNinive bana Iyona yana laumamala inogalina ke inuwavilana. Aku wana itana, tova malinai idedeku seyana gielai ani Banae gitubusegena Iyona.” ");
INSERT INTO bwd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kaduwe Yeisu givona, “Keke tamo gaito mayale ginakabu ada nauwa dibune ginasei o kai gina sewavuye. Au gina selakaina anaebaibo wagaine e ada badi gavega ina lukuelai ani adifaiweya malina ina itana. ");
INSERT INTO bwd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matada vaita vovoda anamayale anafaiweya. Kai matada iwakana, aga vovoda kaduwe matatabuna mamalina. Aku kai matada ikoyo, aga vovoda kaduwe giyuyuvana velemoena. ");
INSERT INTO bwd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Taidei faina wana itaveyabina ada malina wagaimiya ani keke yuyuvana. ");
INSERT INTO bwd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tayuwe faina, kai vovomi matatabuna mamalina ada keke seyana gavaiyomi yuyuvanina, aga imi velemoena mamalimi matatabuna, vaita mayale yana malina gituimalimi anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeisu giifufu giavaina, ada Falisi seyana ginuwabiyena nodi inakani, e ada gina giluku gienokekela teibeli wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ada gikanikani aku keke gidamadu venimaikola ani Falisi-nai giitana-yo yauna gisegena. ");
INSERT INTO bwd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aku Kauveya bademowa gialamanena Falisi yana nuwanuwa ada givonena, givona, “Wana itana, imi Falisiyavo ani amivei ke nauwa domodi wakiveyegayeganedi aku negenidi keke wada ikolakola. Ada kadu anafaiweya imiyavo. Taumiyavo waseyegemonemi vaita imi vevetabumiyavo velemoena, aku nuwainagenimi ani amoumoula ke nuwanuwa koyo-moedi ivemagana. ");
INSERT INTO bwd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Imi kwavakwavamiyavo. Toibubuna keke vovomiga gidabubu aku nuwainagemi kaduwe gibubuna. Taidei faina ada iluwei wana kiveyegayeganedi, vovomi ada nuwainagenimi. ");
INSERT INTO bwd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aku gavana amivei ke aminauwa negenidiya ani fanifani wana veledi, ada gaitoma matatabuna gina yegayegana faimiya. ");
INSERT INTO bwd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Imi Falisiyavo, vita lakaina wana nuwagana! Faina veimeya lakai-moedi wavegaitoma-kavokavovoyedi. Veimeya-dina anafaiweya kaliva wa adivita ani wana veimeya tunutunugina faidiya, ada Yaubada wana nuwakabubuyena. E, taidei veimeya-dina wavegaitoma-kavokavovoyedi e aku veimeya kabisodi ani wamuliye-dewedewedi. Veimeya-dina kabisodi anafaiweya aa adikivemagamaga-dina yogiyogi tulina tulina magadi lakaina wagaidiya ani adibavagu wagaine wavutugedi adivutuga teni ada seyana wavutugena Yaubada wagaine. Taidei veimeya-dina gilubodami wada itaveyabidi aku giluboda-moemi veimeya-dina lakaidi wada vemoimoinedi. ");
INSERT INTO bwd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Imi Falisiyavo, vita lakaina wana nuwagana! Faina manuwa ebavewala wagaidiya nuwanuwami lakaina wana vetoga ebavetoga-dina isedi kaliva wa adivemoimoina faidiya. Ada kaduwe maketi wagaidiya nuwanuwami kaliva wa yadi vemoimoina ina vesiuleyemi. ");
INSERT INTO bwd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Vita lakaina wana nuwagana! Faina imi vaita didikula keke wa ebaitana anafaiweya. Kaliva inuwanuwa vaita wada fafali iwakana e ada au ivagatagotago getane inaunau. Keke ida alamane vaita dibudiya vovo abudalidi imiyamiya.” ");
INSERT INTO bwd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aku veimeya anatonuwauya seyana givonena, givona, “Tovewala, Falisiyavo uifuifufuyedi aku ime kaduwe uawalavema.” ");
INSERT INTO bwd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeisu gilufata, givona, “Kaduwe imi veimeya anatonuwauya, vita lakaina wana nuwagana! Faina yami veimeya tulina tulina vitadi wagaidiya kaliva waveakutagodi iobu, e ada ivita-mowa aku taumiyavo ani keke maita nimadidimi seyana wadatune ke wada lemedi. ");
INSERT INTO bwd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vita lakaina wana nuwagana! Faina imi tamamiyavo tuwaina ani falofitayavo iluvealikadi aku imiyavo ani adididikula wagaidiya adiiyaiyaya wabubudi adiebanuwaududu faina. ");
INSERT INTO bwd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","E ada waawatalatalainena vaita gavana tamamiyavo igugai ani waawaveiwakanena, faina tamamiyavo ani falofitayavo iluvealikadi aku imiyavo adididikula wabubudi. ");
INSERT INTO bwd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Taidei faina Yaubada yana nuwauya wagaine givona, ‘Falofitayavo ke afositoloyavo gana imilidi wagaidiya, aku tufodi ina luvealikadi ada tufodi ina kiveulolonidi.’ ");
INSERT INTO bwd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Babi anaibubuna vaguvagu wagaine-deya ada gielai tova malinai, tamamiyavo nagona ani Yaubada yana falofita moyaidi iluvealikadi. Ada au imi tova malinai anayooyavo ani badi adimatavuloga ginaelai imi wagaimiya falofita-dina dayagidi gimadu faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ivevuvu Ebeli dayagina wagaine ada gielai Sekalaiya dayagina wagaine, banae ebavebolavoi ke manuwa tabu adimwatuguya iluvealikana. Ika, gavonemi velemoena, kaliva-dina adiluvealika fatana ani imi tova malinai anayooyavo wana nuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Imi veimeya anatonuwauya, vita lakaina wana nuwagana! Faina Yaubada anaalamana anawai keke wada kiyavu. Imi taumiyavo keke wadaluku ada kaduwe badi gavega nuwanuwadi inaluku ani faidiya wasebodana.” ");
INSERT INTO bwd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yeisu Falisi yana manuwa wagaine giifufu giavaina ada giobu ginanau. Aku badi Falisiyavo ke veimeya anatovewalayavo iagouga ada ivebutu tolidadana vitadi wagaine Yeisu itolififina, ");
INSERT INTO bwd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ada ibodabodana gavavona sidamana gina vonaye ada wagaine ina vebavuna. ");
INSERT INTO bwd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tayuwe tova-nai wagaine kaliva moyai-moedi ivagavagauta yoo tausani ke tausani ada ivetutuwaiwainau. Aku Yeisu givebutu nagona yana tonogalayavo wagaidiya gimaduvona, “Taumiyavo wana itaveyabimi badi Falisiyavo yadi meyalagalaga wagaine, faina yadi dewa nafone anafaiweya falawa anayisti ani gidamadamana kaliva wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gaitoma-dina ivetalafufudi ani aimo ina vetaladadedi, kaduwe gaitoma-dina sewasewavuyedi ani aimo kaliva moyaidi ina alamanedi. ");
INSERT INTO bwd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Taidei faina gavana yuyuvaneya wavonayena ani aimo malina wagaine ina nogalina, ada gavana vetawaneya waalakululuyena tubuiya tagana wagaine ani aimo manuwa wamelaleya ina awamogatalena. ");
INSERT INTO bwd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Tubuiyakuweyavo, gana vonemi, keke wana matausedi badi gavega vovomi ina luvealikana aku aimo ani keke adifaiweya gavana tamo koyona kadu inagai wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aku gana kivealamanimi ani gaito wana matause. Yaubada wana matausena, faina Banae wa yana veimeya ada anafata vovomi gina luvealikana ada kaduwe gina batugemi wanaobu eli wagaine. E ada ika, gana vonemi, Tauna Banae wana matausena. ");
INSERT INTO bwd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wana itana manuga kibita. Kai adifaifi kana vekimonedi aga fatadi keke lakaina, tu toya gaga. E aku kai au seya-moena, aku Yaubada keke gida venuwavuluye. ");
INSERT INTO bwd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aku imiyavo ani ginuwanuwa lakaina faimiya ayo manuga kibita moyaidi. Ika velemoena, kuluwami anavutuvutu adiveyawa gialamane-yabuna. E ada keke wana matauta. Imi amiita lakaina Yaubada matane. ");
INSERT INTO bwd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kaduwe gana vonemi, gavakaliva keke gina matauta aku kaliva matadiya gina awamogatala, ginavona, ‘Iya Yeisu Keliso yana kaliva’, aga Banae Kaliva Natuna kaduwe anafaiweya Yaubada yana aneloseyavo matadiya gina awamogatala, ginavona, ‘Banae yaku kaliva’. ");
INSERT INTO bwd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aku gavakaliva gina matauta ada kaliva matadiya gina veweyeku ginavona, ‘Iya keke Yeisu yana kaliva’, aga anafaiweya kaduwe Yaubada yana aneloseyavo matadiya gana veweyena, ganavona, ‘Banae keke yaku kaliva’. ");
INSERT INTO bwd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ada gavega inavona koyona Banae Kaliva Natuna faine, tainei Yaubada gina venuwaegena. Aku Aluwaluwa Tabuna ani badi gavega Banae inavona awadamanena, tainei yadi koyona ani keke-mowa Yaubada gina venuwaege. ");
INSERT INTO bwd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ada imi wamuliyeku faina, tova-nai kaliva ina nauwemi manuwa ebavewala wagaidiya o kai tonagonayavo ada toveimeyayavo wagaidiya ke ina vevonayavugimi, aga keke wana venuwana gavaiyamu taumiyavo wana awabababalimi o kai gavana wanavona. ");
INSERT INTO bwd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Faina tayuwe tova-nai wagaine Aluwaluwa Tabuna gina vewalemi gavana amilauboda anafaiweya wana vonayena.” ");
INSERT INTO bwd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yeisu giifuifufu aku yoo nafodiya kaliva seyana givona Yeisu wagaine, givona, “Tovewala, kawaku una vonena ada tamama laovina tufona gina vutugena wagaikuya.” ");
INSERT INTO bwd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aku Yeisu gilufata, givona, “Tubuiyaku, gaito yana veimeya ada Iya gana vetoveimeya amiselu wagaimiya, o kai yami giba gana vutuge faimiya?” ");
INSERT INTO bwd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kaduwe Yeisu givona moyaidi wagaidiya, “Wana itaveyabimi gaitoma moyaina adiitaluvadiga wagaidiya ada keke nuwami ginadola, faina kaliva yana kaikaiwabu moyaina wagaine keke yawaina anaiwakana gina nuwaga.” ");
INSERT INTO bwd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ada vona matalivulivuna seyana giifufuyena, givona, “Tokaikaiwabu seyana yana babi wagaine yana bavagu iwakana ada gimaliya lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ada ginuwanuwa, givonaga, ‘Iya yaku mwatugu keke lakaina ayo yaku aa lakaina ganadodo. Ada gavana ganagai?’ ");
INSERT INTO bwd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","E ada givona, ‘Taidei anafaiweya gana gugai. Yaku kweda gana yaweli ginaobu aku gana yogona lakai-moena, ada yaku aa ke yaku lokoloko matatabuna gana dododi. ");
INSERT INTO bwd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ada ganavona tauku wagaikuya, “Yawaiku wagaine gavana faine gana nuwanuwa? Faina gaitoma moyaina gavelakavidi malamala moyaina anafata, ada au ganamiya-mowa aku wa yaku gakaikai gana kanikani gana yugayuga ada gana vemwamwala-vagata.”; ");
INSERT INTO bwd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Aku Yaubada givonena, givona, ‘O kwavakwava! Bogibogi taidei wagaine yawai gana vaina wagainiya. E ada gaitoma moyaina ukidewedewena tauni fainiya ani gaito ginavai?’” ");
INSERT INTO bwd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ada Yeisu yana vona matalivulivuna idedeku giluyabuna ada givona, “Taidei anafaiweya gina yegemona badi gavega lokoloko moyaina iluvelaka taudiyavo faidiya aku keke ida luvelaka Yaubada faine.” ");
INSERT INTO bwd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aku Yeisu yana tonogalayavo wagaidiya givona, “Taidei faina gana vonemi, keke wana venuwana yawaimi faidiya, kai gavana wanakani, o kai vovomi faina, gavanuya wanaose. ");
INSERT INTO bwd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Faina yawaimi ani gaitoma lakaina ayo muliya aa, ada kaduwe vovomi ani gaitoma lakaina ayo muliya nuya. ");
INSERT INTO bwd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Manuga bwayobwayo wana nuwenuwedi. Keke ida bakubakula o bavagu ida veiveiva. Keke yadi tutulagolota aa faina o kai yadi kweda, e aku Yaubada givekavekanidi. Ada imiyavo amiita lakaina ayo muliya manuga. ");
INSERT INTO bwd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gavaiyamu, kai tamo gaito wagaimiya yana venuwana wagaine anafata yawaina anaetowava maita-moena gina kivemanawena? Au keke. ");
INSERT INTO bwd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ada kai ya venuwana wagaine gaitoma kabiso-moedi taidei anafaiweya keke afaiweya una faisewa, aga gavana faina gaitoma moyaina faidiya uvenuvenuwana? ");
INSERT INTO bwd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Veiya walaiya itabotabo ani wana nuwenuwedi. Keke ida faifaisewa o kai adinuya ida ionaonaga e aku gana vonemi, Kini Solomoni anaveigavu kaikaiwabu-moedi, aku veiya-dina adiita ani iwaka-moedi ayo muliya Solomoni anaveigavu. ");
INSERT INTO bwd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ada Yaubada kai wala matatabuna giveiveigavuna veiya wagaine, ada malinai itabotabo aku malabutu ina alika ke kaliva ina batugedi aiya gina alaidi, aga gavaiyamu imiyavo? Gavana faina wanuwanuwa vaita Yaubada keke imi kaduwe gina veiveigavumi? Imi yami vetumagana Banae wagaine keke lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","E ada aa ke gufa keke wana maduleledi, kaduwe keke wana venuwana ke wana aseuloulolo faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Faina babi anakaliva adiyoo moyaidi badi keke Yaubada ida alamane ani tova moyaina taidei gaitoma-dina imadumadu leledi. Aku imiyavo ani bademowa Tamami gabameya gialamanena gavana amilauboda velemoena yami miya faina, e ada keke wana venuwana gaitoma-dina faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Aku gaitoma lakaina ani Yaubada yana ebaveimeya ananuwanuwa wagaine wanamadu awaegemi, ada Banae gaitoma-dina taidei gina velevelemi. ");
INSERT INTO bwd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Yaku sifi amiyoo kabisona aku keke wana matauta, faina Tamami gabameya givemwamwala gina velemi yana ebaveimeya. ");
INSERT INTO bwd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yami lokoloko wana vekimonedi ada mani wana veledi fanifani. E ada tayuwe wagaine anafaiweya taumiyavo faimiya yami kaikaiwabu anafose gabameya bademowa wabubuna ada keke ginaavai. Wadedeku keke tokiyafu inaela, kaduwe keke kwalukwalu inaona ke ginakoyo. ");
INSERT INTO bwd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Faina gadedeku yami kaikaiwabu velemoena gimiyamiya ani tayuwe wagaine tova moyaina yami nuwanuwa ke aseasemi kaduwe ina miyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Wana kidewadewa-vagata ada nuya wanaose-vagaidi gugai faina aku yami mayale gina alata-vagata, ");
INSERT INTO bwd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","anafaiweya kaliva iitaitabodana yadi kauveya yana yewa-vagila nagi abutuna muline, ada tova-nai ginayewa gina lufifita, ada adifaiweya wana ina yavuna faine. ");
INSERT INTO bwd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tayuwe ebavemwamwala lakaina kai togugai-dina yadi kauveya gina nuwagadi ina itaitabodana yana yewa-vagila wagaine. Vona velemoena, gavona wagaimiya, kauveya tauna togugai adiveigavu gina osena, ada yana togugai gina vonedi ina vetogadi kani faina aku faidiya adiga gina kidewedewena ada gina vekanidi. ");
INSERT INTO bwd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ada kai togugai-dina yadi kauveya gina yewana boginafa o kai malalavuga ada gina nuwagadi ikidewadewa aku ibodaboda, aga kauveya-nai gina awanuwakabubuyedi badi togugai-dina. ");
INSERT INTO bwd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aku taidei wana alamanena. Kai toni manuwa gida alamanena gavakauwana tokiyafu gidaelai, aga gida itaitaboda ke tokiyafu keke gida iyawela gidaluku yana manuweya. ");
INSERT INTO bwd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","E ada imi kaduwe anafaiweya, tova moyaina wana itaveyabimi ke wana veitabodaboda, faina gavakauwana keke wada veitabodaboda wagaine ani Banae Kaliva Natuna ginayewa-vagilena.” ");
INSERT INTO bwd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ada Pita gitolidadana, givona, “Kauveya, tainei vona matalivulivuna uifufuyena ani gavega faidiya, ime tonogalayavo gaga wagaimeya o kai kaliva moyaima faimeya?” ");
INSERT INTO bwd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ada Kauveya gilufata, givona, “Gava togugai ani banae wa anavetumagana ada kadu tonuwanuwa velemoena? Banae togugai-nai ani yana kauveya gina venuwadadanena ke yana togugaiyavo ani gina itaitaveyabidi, ada adiga gina veleveledi aditova velemoena wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kai yana kauveya ginayewa-vagila ada gina itanuwagana gigugugai ani giveimeyena anafaiweya, aga banae togugai-nai vemwamwala gina nuwagana yana kauveya wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gavonemi velemoena, togugai-nai ani yana kauveya ginasena ke yana giba matatabuna gina itaveyabidi. ");
INSERT INTO bwd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aku kai banae togugai ani nuwainagene ginavona, ‘Ida yaku kauveya givekwalu lakaina. Kai keke gina maduela.’ E ada gina vebutu togugaiyavo kaliva ke vevine gina lavulavudi aku kaduwe gina kanikani-faila ke ginayuga kwavakwava. ");
INSERT INTO bwd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","E aku yadayada-nai togugai keke gida itaitaboda wagaine ani yana kauveya gina yewana ada togugai gina veyaulovogina, faina keke gida alamane yadayada-nai o kai gavakauwana anabai wagaine ginayewa. Ada yana kauveya gina nuwagana ke gina lumalimaliwavuna, ada ginasena badi togadibudibusoyoga nodi adimatavuloga anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ada gavatogugai yana kauveya yana nuwanuwa gialamanena aku keke gida kidewadewa o kai keke gida faisewa, aga banae ina mununa analavuga moyai-moena. ");
INSERT INTO bwd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aku gavatogugai keke gida alamane gavana yana kauveya yana nuwanuwa e ada gaitoma koyodi gifaisewadi aku analauboda matavuloga gina nuwagana, aga ina mununa analavuga keke moyaina. Badi gavega wagaidiya vutuvutuga lakaina Yaubada wa yana vetumagana nimadiya gisena, aga aimo kaduwe gina vonedi ada lakaina ina velena. Ada gavakaliva Yaubada wa yana vetumagana gaitoma lakaidi gisena nimane ke gina itaveyabidi, aga aimo gaitoma-dina lakaidi faidiya Yaubada gina veola banae wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Iya gaelai babiya ke ai alalata gana aliyena, ada yaku nuwanuwa lakaina vaita bademowa gidakuli gida alata. ");
INSERT INTO bwd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aku babitaiso seyana Iya faikuya gimiyamiya aimo gana lukuna, ada aseulolo giveakumunuku aku analaba gana luyabuna. ");
INSERT INTO bwd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gavaiyamu, imi yami nuwanuwa vaita Iya gaelai babiya ke miya niwalova gada aliye? Gana vonemi, Keke. Iya gaelai ani ludaka gana aliyena. ");
INSERT INTO bwd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Faina tova malinai ke gina naunau wagaine manuwa seyana anatomiya kaliva adifaifi, ada adiitoto ani ivenibaina kaliva adiselu wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yadi venibaina taidei anafaiweya. Tama gina venibaina natuna kaliva wagaine, ada ina kaduwe natudi vavine ina venibainena, ada vavine lawadi vavine ina venibaina wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kaduwe Yeisu yoo wagaidiya givona, “Tova-nai kauwana ebaoluna wagaine wana itana buibui givelakavi gilaka, ada maduga-mowa wanavona, ‘Ida wei gina lugaga,’ ada ika velemoena gina lugaga. ");
INSERT INTO bwd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ada wabolimaneya mala ginamadu aga wanavona, ‘Ida aimo ginaginana lakaina,’ ada ika anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Imi meyalagalaga! Babi ke mwatugu adiita wainanadi, e aku gavaiyamu-yo gaitoma-dina malinai iyegeyegemona ani keke wada itaitainanadi? ");
INSERT INTO bwd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“E ada gavaiyamu-yo dewa tunutunugina faina ani taumiyavo keke wanamadu venuwadadane ke wana gugaiye? ");
INSERT INTO bwd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kai tamo gaito giawavekoyoyeni e ada amiselu wanauna wana vonayavuga tovevonayavuga wagaine, aga una galuvaluva ada nodi wanamadu kivetunugina aenanai gina nauweni tovevonayavuga wagaine, ada banae ginaseni filisimani nimane, ada filisimani ginaseni deliya. ");
INSERT INTO bwd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gana vonemi, keke inamadu etoyavuni aku nagona gavaiyei mani ivenuwadadanena anatubuga anafaiweya ani unafata-yabuna ayo muliya ina etoyavuni.” ");
INSERT INTO bwd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tayuwe tova-nai wagaine kaliva tufodi ielai Yeisu wagaine ada meGalili iifufuyedi, kaliva-dina ina ivevebolavoi Yaubada wagaine aku Pailato giveimeya ada iluvealikadi, ada kaliva-dina dayagidi ke yadi kevakeva ivebolavoiyedi dayagidi nodi imadumadu. ");
INSERT INTO bwd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ada Yeisu gilufata, givona, “Gavaiyamu yami nuwanuwa, badi Galili-dina taidei anafaiweya igilagi ani yadi koyona lakaina ayo muliya meGalili moyaidi? ");
INSERT INTO bwd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gana vonemi, Keke! Aku kai keke wana nuwavila, aga imi kaduwe anafaiweya moyaimi wana alika. ");
INSERT INTO bwd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O kai badi kaliva adieitini (18) ialika Sailomu wagaine tova-nai manuwa tulatulana giadobo gibeu wagaidiya. Ada gavaiyamu yami nuwanuwa, evona badi kaliva-dina ani yadi koyona lakai-moena ayo muliya kaliva moyaidi Yelusalema wagaine imiyamiya? ");
INSERT INTO bwd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gana vonemi, Keke! Aku kai keke wana nuwavila, aga imi kaduwe anafaiweya moyaimi wana alika-vagata.” ");
INSERT INTO bwd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ada kaduwe vona matalivulivuna taidei giifufuyena, “Kaliva seyana yana bakula wagaine ai alaa gibakulina, ada ginaunau wagaine guwana gilelele aku keke tamo gida nuwanuwaga. ");
INSERT INTO bwd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ada bakula anatoitaveyabina wagaine givona, ‘Una itana, malamala toiye gaelaelai alaa taidei wagaine ada galelele guwana, aku keke tamo gada nuwanuwaga. Unatala ginaobu. Gavana faina babi givenuwaegege?’ ");
INSERT INTO bwd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aku toitaveyabina gilufata, givona, ‘Kauveya, auwe unasei ginamiya malamala seya-moena ke vuvuna gana tavubalawalilivugina babi ke ai yogodi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kai malamala gielaelai gina veguwa aga iwakana. Kai keke, e ada kanatala ginaobu.’” ");
INSERT INTO bwd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabate seyana Yeisu givewavewala meIsileli yadi manuwa ebavewala wagaine ");
INSERT INTO bwd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ada vavine seyana wadedeku imiyamiya, badi malamala eitini (18) aluwaluwa bwanebwanena giveiveimeyedi wagaine domodi gikivebuna. Ada iiboula-vagata. Keke anafata ina mididi tunutunugina. ");
INSERT INTO bwd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ada tova-nai Yeisu giitadi, gidouwedi ilaka ielai ada givona wagaidiya, “Vavine, amiuloulolo wagaine bademowa amietoyavuga wanuwagana.” ");
INSERT INTO bwd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ada nimana gisena wagaidiya ada maduga-mowa imididi tunutunugina ke Yaubada iawadavadavana. ");
INSERT INTO bwd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aku manuwa ebavewala anatonagona ginuwakoyo, faina Sabate wagaine Yeisu toveoga gikivebwainidi. E ada kaliva-nai yoo wagaidiya givona, “Yadayada sikisi imiyamiya ani adilauboda faisewa adiyadayada. Taidei faina wanaelai yadayada-dina wagaidiya ke wana kivebwaina, aku keke Sabate wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aku Kauveya bonana gifatana, givona, “Imi meyami lagalagana. Gavaiyamu, imi seyana seyana Sabate wagaine yami bulumakau o kai doniki yadi ebada wagaidiya waetoyavudi, ke wanagonagoyedi iyegeyegemona gufa waveleveledi o keke? ");
INSERT INTO bwd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","E aku vavine taidei badi Ebelaamo yana tubudelideli, ada Seitani giyogodi imiya malamala eitini, tova manamanawe-moena. Ada gavaiyamu, gavana giyogodi gilubodana anaetoyavuga Sabate wagaine ida nuwagana?” ");
INSERT INTO bwd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yeisu taidei anafaiweya givona ada nibainavo moyaidi ivovomumu, aku kaliva moyaidi ani ivemwamwala lakaina, faina Yeisu gaitoma moyaina iwaka-moedi gifaifaisewadi. ");
INSERT INTO bwd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ada Yeisu kadu givona, “Yaubada yana ebaveimeya ani gavana anafaiweya anaita? Gavana wagaine gana vonaveluveye? ");
INSERT INTO bwd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anafaiweya musita waifeina kabisona kaliva givai gibakulina yana bakuleya. Ada gitabo ke giveai, ada manuga iveuba lagana wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kaduwe givona, “Gavana wagaine Yaubada yana ebaveimeya gada itaveluveye? ");
INSERT INTO bwd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Anafaiweya falawa anayisti vavine givaina ada falawa lakaina negenine iluvilana, e ada tainei gaitoma-nai kabiso-moena ani giluku-nau falawa wagaine ke matatabuna gilutuga.” ");
INSERT INTO bwd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeisu ginaunau Yelusalema e aku ginulukulukuna givevewala melala lakaidi ada melala kabisodi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ada kaliva seyana gitolidadanena, “Kauveya gavaiyamu, aimo kaliva adigavaiyei gaga kibababala ina nuwagana o kai keke?” Ada Yeisu givona wagaidiya, ");
INSERT INTO bwd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Wana vevilaga toyogina ke wanaluku gabama anawana kikiwena wagaine. Faina gana vonemi, kaliva moyaidi ina balalava ke inaluku, aku keke adifata. ");
INSERT INTO bwd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tova-nai toni manuwa bademowa gina mididi ada wana gina falina, e ada imi wana mididi wamelaleya aku wana lufifita ada wana veoveola, ‘Kauveya, wana una yavuna. Ime aelai.’ “Aku gina lufata, gina vonemi, ‘Imiyavo ani Iya keke gada alamanemi, kadu keke gada alamane gadedeku-deya waela.’ ");
INSERT INTO bwd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ada imi wanavona, ‘Ime kaliva-mana nodi kakanikani, kayuyuga, ada yama melala wagaine uvevewala.’ ");
INSERT INTO bwd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Aku banae gina lufata, ginavona, ‘Iya keke gada alamane gadedeku-deya waela. Imi tova moyaina wagugai koyona. Wananau tabae!’ ");
INSERT INTO bwd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ada aimo Yaubada yana ebaveimeya gabama wagaine meIsileli tamadiyavo nagona Ebelaamo, Aisake, Iyakobo, kadu falofitayavo moyaidi wana itadi. E aku imi taumiyavo ani gina wavimi ke wadedeku wamelaleya wana miyamiya, ada wana tagitagiya lakaina ke wana vekudaligoligota. ");
INSERT INTO bwd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ada badi keke meIsileli moyaidi inaelai kauwana ebalakavine ke kauwana ebaoluna wagaine ada wayavalaseya ke wabolimaneya, ada Yaubada yana ebaveimeya wagaine ina enokekela abutu kanina wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ika, velemoena kaliva tufodi tova malinai wai imuli-mwena ani aimo tova gielaelai wai ina nagona, aku kaliva tufodi tova malinai wai inagonagona ani aimo tova gielaelai wai ina muli-mwena.” ");
INSERT INTO bwd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tayuwe tova-nai wagaine Falisiyavo tufodi ielai Yeisu wagaine, ivona, “Fafali taidei una segena ada mali fafaliya unanau, faina Elodi nuwanuwana o gina luvealikani.” ");
INSERT INTO bwd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeisu gilufata, givona, “Wananau tainei toikavuya vagita wana vonena, ‘Malinai ada malabutu aluwaluwa bwanebwanenedi gaveveyegemonidi ada toveoga gakikivebwainidi, ada yadayada anaveto wagaine yaku faisewa gana luyabuna.’ ");
INSERT INTO bwd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kai gavaiyamu e aku malinai ada malabutu ke velugana yadayada-nai Iya gana naunau, faina anavelemoena ani falofita keke analauboda ada mali melaleya gina alika aku Yelusalema gaga wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O meYelusalema, meYelusalema, imi Yaubada yana falofitayavo waluvealikadi, ada badi yana valeya anatoaliya giimilidi wagaimiya ani kabaleya watutuvealikadi. Kamukamu natudiyavo ivagauwidi ke ofadiya ilukabubudi anafaiweya, tova bademowa gavaiyei nuwanuwaku gana vagauwimi seyana wagaine. Aku imi keke nuwanuwami. ");
INSERT INTO bwd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wana itana, Yaubada yami manuwa tabu gina segena ke taumiyavo gaga wanamiya. Ada gana vonemi, aimo keke wanaita-vagileku analaba wana vonaga, ‘Banae gielaelai KAUVEYA anayeganeya ani wa anaawanuwakabubu.’” ");
INSERT INTO bwd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabate seyana Yeisu ginau Falisiyavo aditonagona seyana yana manuweya ginakani, ada wadedeku kaliva iitavenanauna gavana ginagai. ");
INSERT INTO bwd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","E aku Yeisu magigine ani kaliva seyana toveoga giela gimiyamiya, banae vovona matatabuna gitubukoyokoyo. ");
INSERT INTO bwd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ada Yeisu Falisiyavo ke veimeya anatonuwauyayavo gitolidadanedi, givona, “Gavaiyamu, adaveimeya wagaine giawaegau Sabate wagaine kana kivebwaina o keke?” ");
INSERT INTO bwd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aku badi iveyamata. Ada kaliva nimana gikiveyabina ada gikivebwainina, muliya giimili ginau. ");
INSERT INTO bwd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ada kaduwe givonedi, givona, “Tamo gaito wagaimiya kai natuna o kai yana bulumakau ginabeu kavuya Sabate wagaine, aga gavaiyamu, maduga-mowa unana una silakai ginalaka o kai keke? Sabate e aku au unana una silakaina.” ");
INSERT INTO bwd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ada au taidei anafaiweya givona aku badi keke adifata ina lufata. ");
INSERT INTO bwd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tova-nai Yeisu giitana gavega nuwabi inuwagana ani ivi kaikaiwabuna imadumaduvaidi wagaidiya ivetovetoga, e ada vona matalivulivuna taidei wagaine givonedi, ");
INSERT INTO bwd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kai gaito gina nuwabiyeni nagi abutuna wagaine, aga keke ebavetoga kaikaiwabuna una maduvai, faina kai aimo kaliva seyana ginaelai banae kaduwe nuwabi ginuwagana ada anavemoimoina lakai-moena ayo muliya oye. ");
INSERT INTO bwd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ada kai toni abutu amiselu ginuwabiyemi e ani ginaela ginavona wagainiya, ‘Kaliva taidei aivi una velena.’ E ada wa ya vovomumu nodi aku unana ivi dibune-mwane unavai una vetoga. ");
INSERT INTO bwd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aku kai nuwabi una nuwagana aga unanau ivi dibune una vaina, ada toni abutu ginaelai wagainiya ke ginavona, ‘Tubuiyaku, una togalaka ivi iwakana wagaine.’ Ada badi moyaidi nodi wakanikani ani matadiya aku avemoimoina gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Faina badi gavega taudiyavo ina kilakaidi ani Yaubada gina kiobuyedi, aku badi gavega taudiyavo ina kiobuyedi, badi Yaubada gina kilakaidi.” ");
INSERT INTO bwd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ada Yeisu anatonuwabi wagaine givona, “Tova-nai kanibutu unasena aga keke tubuiyamomo o atubulugayavo o aunuma o kaikaiwabudiyavo una nuwabiyedi. Kai unadewa anafaiweya aga aimo ya nuwabi ina fataveyewana, e ada fata bademowa uvaina. ");
INSERT INTO bwd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aku tova-nai kanibutu unasena aga fanifani, talaidi kabekabebedi, felafela, ke badi matadi koyo-moedi una nuwabiyedi. ");
INSERT INTO bwd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Badi keke adifaiweya ina fataveyewa wagainiya faina, Yaubada gina awanuwakabubuyeni. Ada aimo yegayegadiyavo yadi yawa-vagila anatoveya, Banae wagaine fata una vaina.” ");
INSERT INTO bwd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ada kaliva seyana nodi ikanikani ani Yeisu yana vona ginogalina ada givonena, givonaga, “Badi kaliva-dina aimo abutu kanina wagaine inakani Yaubada yana ebaveimeya wagaine ani yadi vemwamwala gavatubuga!” ");
INSERT INTO bwd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ada Yeisu gilufata, givona, “Kaliva seyana kanibutu lakaina gikidewedewena ada kaliva moyaidi ginuwabiyedi. ");
INSERT INTO bwd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ada kanibutu anatova giyegemona faina, yana togugai giimilina ada badi gavega nuwabi ivaina gina vonedi, ‘Wanaelai! Gaitoma matatabuna anakidewadewa bademowa giavaina.’ ");
INSERT INTO bwd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Aku moyaidi ivebutu ke gavana yadi nuwanuwa gisebodana faine iifufu, ada yadi vona aigaigabudi. Kaliva nagona givona, ‘Iya malinai yaku babi evaguna gakimonena, ada gilubodaku ganana gana itana. Taidei faina ada siule, keke akufaiweya ganaela.’ ");
INSERT INTO bwd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ada kaliva anavelu givona, ‘Iya yaku bulumakau nima fafali iluwei gakimonedi ada ganauna gana galuvaluvadi ke gana itadi, ebabakula inatai-dewedewena o kai keke. Taidei faina ada siule lakaina, keke akufaiweya ganaela.’ ");
INSERT INTO bwd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Kadu seyana givona, ‘Iya malinai ganagi-vagu, e ada keke akufaiweya ganaela.’ ");
INSERT INTO bwd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“E ada togugai giyewana yana kauveya wagaine ke kaliva-dina bonadi giifufuyena wagaine. Ada toni manuwa ginuwakoyo ada yana togugai givonena, ‘Unamadu unanau melala lakaina anawai moyaina wagaidiya ada tofanifani, tovefela, badi matadi koyo-moedi, ke tonubeube una vagauledi inaelai.’ ");
INSERT INTO bwd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ada togugai ginau gigugai anafaiweya, ada giyewana givona, ‘Kauveya, gavana uveimeya bademowa gagugaiyena, aku manuwa ani aimo keke gidamaga.’ ");
INSERT INTO bwd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ada kauveya yana togugai givonena, ‘Unanau fafali lakaina wamelaleya anawai lakaidi ke wai kabisodi wagaidiya kaliva una vonavagadonedi toyogina ke inaela yaku manuwa ina vemagana. ");
INSERT INTO bwd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gavonemi velemoena, badi kaliva-dina gamadu nuwabiyedi, ani wagaidiya keke tamo gaito yaku kani vemwamwala aana kabisona gina lutovoni.’” ");
INSERT INTO bwd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yoo lakaina Yeisu nodi inaunau ada gimiyavila wagaidiya givona, ");
INSERT INTO bwd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kai gavega inaela ina muliyeku aku kai inadiyavo o kai tamadiyavo faidiya ani adinuwanuwa ivewainagoyedi ayo muliya Iyayeku, aga keke adifaiweya ina vetonogala wagaikuya. Kaduwe gavega vavinediyavo o natudiyavo, o tubuiyadiyavo o novudiyavo, o kai taudiyavo yawaidi ani adinuwanuwa ivewainagoyedi ayo muliya Iyayeku, aga keke adifaiweya ina vetonogala wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ada gavega keke yawaidi ina awaege ke taudiyavo adikelose ina avala ada ina muliyeku, aga keke adifaiweya ina vetonogala wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kai kaliva seyana wagaimiya nuwanuwana manuwa tulatulana gina vemididina, aga nagona gina vetoga ada fatana faina gina venuwadadanena ke gina itana, kai yana mani anafata ada manuwa gina vemididina ani gina luyabuna o keke. ");
INSERT INTO bwd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Faina kai keke ada tova-nai avutuwa gina iyalalakata ada manuwa keke gina luyabu, e ada kaliva moyaidi ina itana ada ina awaveleigena, ");
INSERT INTO bwd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","inavona, ‘Kaliva taidei manuwa anaiyogona givevuvuna aku keke anafata gina luyabu.’ ");
INSERT INTO bwd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O kaduwe kai kini seyana nuwanuwana ada gina lugaviya kadu kini seyana yana yoo nodi. Ada nagona gina vetoga ke gina venuwadadana, gavaiyamu, yana kalivayavo teni tausani (10,000) adifata ina lugaviya kini-nai gielaelai yana tuweniti tausani (20,000) nodi o keke? ");
INSERT INTO bwd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kai keke anafata aga tomatawa gina maduimilidi ada badi mali yoo aimo atuwadeya ielaelai aku inanau wagaidiya ina veola kukuya faina. ");
INSERT INTO bwd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tainei anafaiweya, kai seyana gaito wagaimiya gaitoma matatabuna keke gina dibusoyogedi Iya faikuya, aga banae keke analauboda yaku tonogala. ");
INSERT INTO bwd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Leyaga gaitoma iwakana, aku kai anadigadigaga gina avaina, aga keke anafata kana kiveleyagi-vagile. ");
INSERT INTO bwd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Keke anafata babi gina kiveiwakane e ada gaitoma inatabo iwakana, e ada au kanasege-moena. “Imi gavega wa tagami ani vona taidei wada nogalina.” ");
INSERT INTO bwd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tova seyana takesi anatoyaudi ada tokoyona moyaidi ivagauta Yeisu wagaine ina nogala. ");
INSERT INTO bwd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Aku Falisiyavo ada Mosese yana veimeya anatovewalayavo ivebutu igavoluvolu, ivona, “Kaliva taidei ani tokoyona gisivaivaidi ada nodi ikanikani.” ");
INSERT INTO bwd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ada Yeisu vona matalivulivuna wagaine givonedi, ");
INSERT INTO bwd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kai wagaimiya kaliva seyana yana sifiyavo wani analedi (100) imiyamiya aku seyana ginusegena, e aga gavaiyamu gidagai? Yana sifi adinaenti naeni (99) ani gina nusedi mwatugu kavovona wagaine, aku ginanau ada sifi-nai ginusegena gina lelena-deeya, gina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ada gina nuwagana wagaine, wa yana vemwamwala avalane gina selakaina aku ginanau ");
INSERT INTO bwd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","yana manuweya. Ada tubuiyanavo ke yana yooyavo gina douwe vagauwidi seyana ada gina vonedi, ‘Wanaela nodi kana vemwamwala, faina yaku sifi ganusegena ani ganuwagana.’ ");
INSERT INTO bwd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Gana vonemi, tainei anafaiweya tokoyona seyana yana nuwavilana faina, gabameya vemwamwala lakai-moena ayo badi naenti naeni (99) yegayegadiyavo, badi keke ida nuwanuwa vaita adilauboda ida nuwavilana faina.” ");
INSERT INTO bwd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“O kai vavine seyana yadi mani siliva teni aku seyana isegena, aga gavaiyamu idaga? Mayale ina kabuna ada manuwa matatabuna ina divuna, ada inalele-dewedewe inana ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ada tova-nai ina nuwagana, tubuiyadiyavo ke yadi yooyavo ina douwevagauwidi ada ina vonedi, ‘Wanaela nodi kana vemwamwala, faina yama siliva asegena ani anuwagana.’ ");
INSERT INTO bwd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Gana vonemi, kaduwe anafaiweya tokoyona seyana gina nuwavilana faina, Yaubada yana aneloseyavo ina vemwamwala lakai-moena.” ");
INSERT INTO bwd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kaduwe Yeisu givona matalivulivuna, givona, “Kaliva seyana natunavo adiselu. ");
INSERT INTO bwd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ada kwamaneya tamana wagaine givona, ‘Kamaku, ya ebaveimeya lokolokona akuvutuvutuga uda veleku.’ Ada lokoloko givutugena natunavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Imiyamiya yadayada keke moyaina aku kwamaneya yana lokoloko matatabuna givaidi ada gitauya ginau mali fafali atuwadeya, wadedeku miya gakaikai wagaine yana kaikaiwabu matatabuna givetalayavuyavulena. ");
INSERT INTO bwd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tova-nai gaitoma matatabuna gisege-yabuna, ada wadedeku fafali-nai wagaine loka lakaina giyegemona. Ada au givebutu mafa gilavuna aku keke yana mani o kai anaga. ");
INSERT INTO bwd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","E ada ginau melala-nai anakaliva lakaina seyana wagaine givetogugai, ada giimili ginau yana babi seyana wagaine yana bawe gina itaveyabidi. ");
INSERT INTO bwd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aku mafa gilavuna e ada nuwanuwana lakaina bawe adifenifeni ikanikani wagaine ani maita kamone gidasena, faina keke seyana gaito maita aa gidavele. ");
INSERT INTO bwd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ada gimiyamiya aku tova-nai yana nuwanuwa gimalina, e au ginuwayewa givona, ‘Kamaku yana togugaiyavo moyaidi ani adiga ikanikani-vetufodi, aku Iya idedeku ani mafalavugeya gana alika-kavovo. ");
INSERT INTO bwd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Gana mididi gana yewaku kamaku wagaine ada ganavona wagaine, “Kamaku, Iya gakoyona Yaubada matane ada o mataniya. ");
INSERT INTO bwd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Iya keke iwakaku e ada keke akulauboda una vewagaku natu. Au una deweku vaita Iya ya togugai.”; ");
INSERT INTO bwd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Taidei anafaiweya ginuwanuwa e ada gimididi gitauya ginau tamana wagaine. “Aimo atuwada-deya gielaelai aku tamana giitana ada ginuwakalikaliyena. Gimadu ginau ada natuna giatulauwi giveyaugina. ");
INSERT INTO bwd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","E ada kwamana tamana wagaine givona, ‘Kamaku, Yaubada matane ada o mataniya Iya gakoyona, ada keke akulauboda una vewagaku natu.’ ");
INSERT INTO bwd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Aku tamana yana togugaiyavo wagaidiya givona, ‘Wanamadu, nuya luveyalilina wana aliye wana veosena. Nimakwasi wanasena nimane ada ageyafayafa wanasena agene. ");
INSERT INTO bwd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ada bulumakau natudi tubuyafayafana wana aliye wana mununa, ada kana kanibutu ke kana vemwamwala. ");
INSERT INTO bwd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Faina natuku taidei vaita gida alika ani bademowa giyawa-vagila, kaduwe vaita gada segena aku bademowa ganuwagana.’ Ada ivebutu ivemwamwalena. ");
INSERT INTO bwd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Aku tayuwe tova-nai wagaine natuna tomoinagona banae gimiyamiya bakuleya ani giyewa gielaelai melaleya. Manuwa lilivane giyegemona ani modawa butudi ke tavola ginogalina ");
INSERT INTO bwd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","e ada togugai seyana gidouwe gitolidadanena, givona, ‘Wada gavana tayuwe giyegeyegemona?’ ");
INSERT INTO bwd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Banae gilufata, givona, ‘O taini gielai, ada tama givona ada bulumakau natudi tubutubugina imununa, faina natuna velubwaibwaina ginuwagana.’ ");
INSERT INTO bwd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Aku tomoinagona ginuwakoyo ada gidibusoyoga keke nuwanuwana ginaluku manuweya. Tainei faina tamana giyegemo ginau wagaine ada givona-bikebikena vaita ginaluku ");
INSERT INTO bwd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","aku tamana wagaine givonalufata, givona, ‘Una itana, malamala-dina moyaina Iya gavetogugai wagainiya ada keke tamo ya veimeya gada dibusoyoge. Aku keke seyana kevakeva uda veleku, kai goti natudi, e ada tubuiyakuweyavo nodi adakani vemwamwala. ");
INSERT INTO bwd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aku natu taidei ani ya kaikaiwabu givenuwegegena ada giluyabuna wai dobona anavevineyavo nodi, ada gielai manuweya ani bana faine bulumakau natudi tubuyafayafana umununa!’ ");
INSERT INTO bwd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ada tamana givonena, ‘Natuku, oyeni tova moyaina Iya nodi, ada matatabuna gavana wagaikuya ani ya gaitoma. ");
INSERT INTO bwd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aku analauboda taini faine kanakani vemwamwala, faina banae vaita gida alika ani giyawa-vagila. Kaduwe vaita kadasege aku bademowa kanuwagana.’” ");
INSERT INTO bwd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kaduwe Yeisu giifufu yana tonogalayavo wagaidiya, givona, “Tokaikaiwabu seyana gimiyamiya, ada yana togugai seyana ani tokaikaiwabu-nai yana lokoloko moyaidi giitaitaveyabidi. Ada tokaikaiwabu-nai gikaiyanogala vaita togugai-nai yana lokoloko givetalayavuyavulena. ");
INSERT INTO bwd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","E ada gidouwe giluku gitolidadanena, givona, ‘Uda ifufu gada nogalina. Faina valeya ganogalina ani gavana tamo ugana ya faisewa wagaine. Taidei faina Iya nuwanuwaku yaku lokoloko matatabuna faidiya anabuki una aliyena ada una vewaleku gavaiyei mani anatubuga giluku, ke gavaiyei mani anatubuga giyegemona. Ada tova-nai una luyabuna, e ayo ya faisewa wagaine ginaavai-vagaini.’ ");
INSERT INTO bwd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ada toitaveyabina tauna nuwainagene givona, ‘Ida gavana ganagai? Faina yaku kauveya ani yaku faisewa wagaine givaiyavuleku. Keke akufata gana bakula, ada kai lokoloko gana awaveoveola aga ebavovomumu. ");
INSERT INTO bwd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O ika! Gaalamanena gavana gana gugai, e ada tova-nai yaku faisewa idedeku gana segena aga aimo kaliva ina sivaivaiku ganaluku yadi manuweya.’ ");
INSERT INTO bwd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“E ada kaliva-dina yana kauveya yana lokoloko anatoketowai ani gidouwedi seyana seyana ielai. Ada kaliva nagona gitolidadanena, givona, ‘Yaku kauveya yana lokoloko wagaine gavaiyei aketowai anatubuga?’ ");
INSERT INTO bwd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Banae gilufata, givona, ‘Bunama olive tuwava eita analedi (800).’ “Ada toitaveyabina toketowai givonena, ‘Unamadu ada aketowai anafefe unavai una sevedavedamena anatufo fowa analedi (400).’ ");
INSERT INTO bwd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kaduwe kaliva anavelu gitolidadanena, givona, ‘Ada oye gavaiyei uketowai?’ “Banae gilufata, givona, ‘Witi baiki wani tausani (1,000).’ “Toitaveyabina givonena, ‘Aketowai anafefe una vaina ada wani tausani (1,000) una sevedavedamena anatufo eita analedi (800).’ Ada kaduwe badi gavega iketowai yana kauveya yana mani wagaine, ani givonedi anafaiweya igugai. ");
INSERT INTO bwd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“E ada bana togugai-nai yana dewa keke tunutunugina nonogana yana kauveya-nai gidavana, faina bana wai seyana ginuwagana ke tauna gina kibababalena vita-nai gielaelai wagaine. Ika, badi babi anakalivayavo ani wa yadi nuwauya velemoena iyavivila kaliva wagaidiya ayo malina anakalivayavo. ");
INSERT INTO bwd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ada gana vonemi, yami kaikaiwabu ada yami mani wana vegugaiye-dewedewedi ke kaliva wana lemedi ada wana kivemwamwalidi, e ada tova-nai kaikaiwabu-dina anatova gina avaidi ada wana yegemona ebamiya-vagata anafafali wagaine, aimo kaliva-dina ina sivaivaimi. ");
INSERT INTO bwd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kai gaito wa anavetumagana gaitoma kabiso-moena anaitaveyabina wagaine, kaduwe aimo gaitoma lakaina anaitaveyabina wagaine banae wa anavetumagana. Aku gaito keke gida dewadewa tunutunugina gaitoma kabiso-moena anaitaveyabina wagaine, kaduwe aimo keke gina dewadewa tunutunugina gaitoma lakaina anaitaveyabina wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","E ada kai babi anakaikaiwabu anaitaveyabina wagaine imi keke wa amivetumagana, aga gavaiyamu gabama anakaikaiwabu velemoena faine? Gaito wa yana vetumagana ginasena nimamiya-yo wana itaveyabi? Au keke tamo. ");
INSERT INTO bwd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kaduwe kai gavakaliva yana lokoloko anaitaveyabina wagaine keke wa amivetumagana, aga gaito lokoloko gina velemi taumiyavo faimiya? ");
INSERT INTO bwd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Keke togugai seyana anafata gina vetogugai kauveya iluwei wagaidiya. Faina seyana gina dibusoyogena aku seyana gina nuwakabubuyena, o kai seyana wagaine gina idibumwaiga aku seyana gina awaegegena. Kaduwe anafaiweya, keke anafata wana vetogugai Yaubada wagaine aku kaduwe kaikaiwabu wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","E aku Falisiyavo, badi nuwanuwadi lakaina mani, ani vona taidei matatabuna inogalina wagaine, Yeisu ivekebulavogiyena. ");
INSERT INTO bwd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ada Yeisu givona wagaidiya, givona, “Imiyavo ani kaliva matadiya taumiyavo waseyegemonimi evona yegayegamiyavo, aku Yaubada gialamanena aseasemi. Faina gaitoma-dina kaliva inuwenuwedi evona gaitoma lakai-moedi ani Yaubada matane gaitoma koyo-moedi.” ");
INSERT INTO bwd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yeisu kaduwe Falisiyavo wagaidiya givona, “Tuwai-moena Yaubada yana veimeya givelena Mosese kadu yana nuwanuwa gialavelevelena falofitayavo. Ada badi yadi vetonagona dibune meIsileli imiyamiya, ada taide anafaiweya ginaunau analaba Iyoni Tobabitaiso yana toveya. Ada tainei tova-nai wagaine ada gielai malinai ani Yaubada yana ebaveimeya anavaleya iwakana ilumamalena, ada kaliva moyaidi ibalabalalava wai ilelele ke inaluku wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Aku keke vaita Yaubada yana veimeya maita gidaavai, keke ada keke. Gabama ada babi adifaiweya ina avaidi, aku veimeya matana kabiso-moena ivetokilumina ani keke tamo ginaavai. ");
INSERT INTO bwd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Gavakaliva vavinena gina viyoliliyedi aku vavine evaguna gina nagina, banae giudo. Ada gavakaliva vavine viyoviyolilidi gina nagidi, wada kaduwe giudo.” ");
INSERT INTO bwd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ada kaduwe Yeisu givewala, givona, “Tokaikaiwabu seyana gimiyamiya, banae yadayada seyana seyana gimiya kaikaiwabu-mowa ada gikanikani iwakana, ada nuya kaikaiwabudi gioseosedi, tainei yabeyabelina ke kwayakwaya-moena. ");
INSERT INTO bwd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aku kaduwe tofanifani seyana anayegana Lasalo, banae toawaveoveola ada vovona matatabuna koliya gaga. Ada tova moyaina tubuiyanavo ialialiye tokaikaiwabu-nai yana manuwa anakali anawana wagaine isesei givetovetoga, ");
INSERT INTO bwd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ada nuwanuwana lakaina tokaikaiwabu yana teibeli wagaine gavana mukumuku imavumavuga ani maita gidakani. Kaduwe galuweta ielaela anakoliya iyamoyamodi. ");
INSERT INTO bwd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Imiyamiya aku kwana fanifani gialika, ada aneloseyavo inauwena Ebelaamo lilivane isena. Kaduwe tokaikaiwabu gialika ada itavuna. ");
INSERT INTO bwd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Banae ginau eli wagaine wadedeku giuloulolo lakaina, aku giitalaka ani giitana Ebelaamo atuwada-mowa ada Lasalo ani lilivane gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ada givedou, givona, ‘Kamaku Ebelaamo, uda nuwakalikaliyeku! Lasalo uda imilina e ada nimadidina gida vebutana gufa wagaine ke meyaku gida ivetuluna, faina gauloulolo lakaina aiyabeyabela taidei wagaine!’ ");
INSERT INTO bwd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Aku Ebelaamo gilufata, givona, ‘Natuku, unaduna tuwaina wayawainiya. Oye gaitoma iwakadi unuwagadi, aku Lasalo gaitoma koyodi givaidi. Aku malinai idedeku-deya miyavita wagaidiya giveyaveyawai ke gimiya niwalova, e aku oyeni ani uuloulolo. ");
INSERT INTO bwd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ada kaduwe vuvu seyana ani adamwatugu wagaine awagana lakaina gilugoloi giobu, e ada idedeku-deya gavega nuwanuwadi vaita inaelai wagaimiya ani keke adifaiweya, kaduwe wagaimiya-deya keke seyana gaito ginaela wagaimeya.’ ");
INSERT INTO bwd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tokaikaiwabu givona, ‘Ada auwe aku kamaku, kai anafaiweya, aga gaveoleni Lasalo uda imili gidanau kamaku yana yoo wagaidiya, ");
INSERT INTO bwd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","faina Iya akutubulugayavo adifaifi imiyamiya. Gidanau ada gida madumatawedi aenanai kaduwe inaelai uloulolo taidei anafafali wagaine.’ ");
INSERT INTO bwd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ebelaamo gilufata, givona, ‘Keke. Bademowa Mosese yana veimeya ada Yaubada yana falofitayavo yadi buki imiyamiya tubuiyamomo wagaidiya. Gilubodana badi yadi ifufu ina nogalina.’ ");
INSERT INTO bwd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Aku banae givona, ‘Keke, kamaku Ebelaamo. Aku kai gaito alikeya ginayawa-vagila ada ginanau wagaidiya aga ina nuwavilana.’ ");
INSERT INTO bwd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aku Ebelaamo givonena, givona, ‘Kai Mosese ada falofitayavo bonadi keke ina nogali, aga kadu anafaiweya kai gaito alikeya ginayawa-vagila aku keke nuwadi ina sivila ke ina nuwavila.’” ");
INSERT INTO bwd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kaduwe Yeisu yana tonogalayavo wagaidiya givona, “Velemoena, ebaaladibidibi moyaidi ina yegeyegemona ke kaliva inagadi inabeu ke ina koyona. Aku gaito koyona anaaladibidibi gikiveyegemonina, ani vita lakai-moena gina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kai kabala lakaina ida yogovefosena bana odone ada wa kabalina ida batugena leyageya gida alika, aga tainei iwaka-moena bana faine. Faina gida madualika, e ada keke anafaiweya kwamana tamo gidagai koyona wagaine gidabe. ");
INSERT INTO bwd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Taidei faina taumiyavo wana itaveyabimi. Kai tubuiya seyana gina koyona aga una awatana, ada kai gina nuwavilana aga yana koyona una venuwaegena. ");
INSERT INTO bwd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ada kai yadayada seyana wagaine gina koyona wagainiya tova seveni, aku kaduwe ginayewa-vagile ginaelai wagainiya tova seveni ginavona, ‘Iya ganuwavilana,’ aga gilubodana yana koyona una venuwaegena.” ");
INSERT INTO bwd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ada afositoloyavo Kauveya wagaine ivona, “Yama vetumagana uda kiveinalina.” ");
INSERT INTO bwd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ada Kauveya givona, “Kai yami vetumagana anatubuga vaita musita waifeina kabiso-moena anafaiweya, aga amifata ai tuli taidei wagaine wanavona, ‘Tauni una abuni ke unana leyageya una mididi,’ ada bonami gina matawalewaleyena. ");
INSERT INTO bwd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kai kaliva seyana wagaimiya yana togugai gida veimeyena ke yana bakuleya gida faifaisewa, o kai yana sifi gida itaitaveyabidi, ada yana faisewa gida luyabuna ke gida yewana manuweya, aga gavaiyamu kaliva-nai bana wagaine gidavona? Kai gidavona, ‘Una maduela una vetoga ke unakani?’ ");
INSERT INTO bwd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Keke-mowa anafaiweya, aku aiyada gidavona, ‘Akubailavi una kidewadewa ada tauni una veigavu ke una ulili. Iya gana madukani ada muliya o tauni unakani ada unayuga.’ ");
INSERT INTO bwd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ada gavaiyamu, togugai-nai gina itaboda e ada vaita anatoveimeya gina vesiuleyena faina? Au keke. Faina tainei yana faisewa ada analauboda gigugai. ");
INSERT INTO bwd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ada kaduwe anafaiweya imiyavo. Tova-nai ina vonemi wana gugai ada gaitoma matatabuna anagugai wana luyabuna, aga wanavona, ‘Imeyavo amayegana togugai, ada gavana amaveimeya ani au agugai-mowa e ada taidei iwakana. Ime keke ada lelele vona vesiule ananuwaga.’” ");
INSERT INTO bwd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yeisu ginaunau Yelusalema, aku yana nau-nai wagaine giyegemona Galili ada Sameliya adietonaba wagaine ginaunau. ");
INSERT INTO bwd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ada wadedeku melala seyana wagaine Yeisu yana tonogalayavo nodi ina ilukuluku, aku kaliva aditeni lefelo givaidi nodi ivenuwaga, aku maita atuwadeya imididi ");
INSERT INTO bwd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ada bonadi lakaina wagaine ivedou, “Kauveya! Yeisu! Uda nuwakalikaliyema!” ");
INSERT INTO bwd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tova-nai giitadi ada givona, “Wananau veyavo anatovegugai wagaidiya taumiyavo wana vewalemi.” Ada itauya inaunau wai wagaine aku vovodi iyegayegana. ");
INSERT INTO bwd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aku wagaidiya kaliva seyana ani giitana au giveiwaka ada giyewana, aku bonana lakaina wagaine Yaubada giawadavadavana. ");
INSERT INTO bwd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ada gielai Yeisu wagaine giodu magigine aku tugana givetodonena ada givesiule wagaine, aku banae ani kwana Sameliya. ");
INSERT INTO bwd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ada Yeisu givona, “Gavaiyamu? Tolefelo aditeni Iya gakiveyegayeganedi, aku gadedeku adinaeni? ");
INSERT INTO bwd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Gavaiyamu-yo kwana mamataga anakaibe giyewa giela ke Yaubada gina awadavadava?” ");
INSERT INTO bwd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ada kaliva wagaine givona, “Una mididi unanau. Ya vetumagana gikiveiwakaneni.” ");
INSERT INTO bwd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tova seyana Falisiyavo Yeisu itolidadanena evona gavatova wagaine Yaubada yana ebaveimeya ginaela, ada gilufata, givona, “Yaubada yana ebaveimeya keke vaita wana itaeyeye aku ginaela. ");
INSERT INTO bwd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kaduwe kaliva keke inavona, ‘Taidei wagaine gina yegemona!’ o kai ‘Tayuwe wagaine gina yegemona!’ Faina Yaubada yana ebaveimeya gimiyamiya amimwatuguya.” ");
INSERT INTO bwd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ada yana tonogalayavo givonedi, givona, “Aimo tova gielaelai imi nuwanuwami lakaina wana itana Bana Kaliva Natuna yana tova anayadayada seyana, aku keke wanaita. ");
INSERT INTO bwd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ada kaliva ina vonemi, ‘Tayuwe wagaine wanana wana itana!’ o kai ‘Taidei wagaine wanaela wana itana!’ Keke yadi vona wana muliye wanana wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Atunama gina atunama ada ginanau tufone ke tufone ada mwatugu matatabuna ginamali-yabuna, e ada kaliva moyaidi ina itana. Ada kadu anafaiweya Banae Kaliva Natuna yana yewa-vagila anayadayada-nai, ani moyaidi ina itana. ");
INSERT INTO bwd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aku nagona uloulolo moyaina gina nuwagana, ada tova malinai anayoo ina vedomobubusena. ");
INSERT INTO bwd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tuwaina Nowa yana toveya kaliva ke vevine idewadewa anafaiweya, e ada kaduwe Banae Kaliva Natuna yana yewa anatova anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Faina yadayada-dina wagaidiya muliya-yo mala gituwa aku kaliva imiyabavubavu-mowa. Aa ikanikani, iyugayuga, ada inaginagi ke ivevenagi analaba yadayada-nai Nowa giyage aki wagaine. Ada au wa yadi yavuyoga imiyamiya, ani wayagata lakaina giela gituwavaidi ada moyaidi giluyavuledi. Ada aimo kaduwe anafaiweya Banae Kaliva Natuna yana tova wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kaduwe anafaiweya Lota yana tova wagaine, kaliva imiya bavubavu-mowa. Aa ikanikani, iyugayuga, ikimokimone ada ivevekimone, ibakubakula ada imanumanuwa iyogona. ");
INSERT INTO bwd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ada au wa yadi yavuyoga imiyamiya, ani yadayada-nai wagaine Lota gimididi Sodoma gisege ginau, ada ai alalata ke salufa giyabeyabela gabameya-deya gialiliwana, ada kaliva moyaidi giluyavuledi. ");
INSERT INTO bwd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","E ada kadu anafaiweya yadayada-nai wagaine Yaubada ani Bana Kaliva Natuna gina ivemogatalina, au yadayada-dina adiitaita ani anafaiweya ina yegemona. ");
INSERT INTO bwd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tayuwe yadayada-nai wagaine badi gavega yadi manuwa getane ani idaobu aku keke idaluku yadi manuweya yadi lokoloko idavai. Kadu anafaiweya badi gavega bakuleya, keke idayewa melaleya gavana tamo faina. Au ida maduota. ");
INSERT INTO bwd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Wanaduna Lota vavinena! ");
INSERT INTO bwd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Badi gavega nuwanuwadi taudiyavo yawaidi ina kibababaledi ani yawaidi ina nusegedi. Aku gavega Iya faikuya yawaidi ina nusegedi ani yawaidi ina kibababaledi. ");
INSERT INTO bwd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Gana vonemi, bogi-nai wagaine kaliva adiselu ivi seyana wagaine ina daudau aku seyana ina nauwena, seyana ginamiya. ");
INSERT INTO bwd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kaduwe vevine adiselu aa ina auaulana ani anafaiweya, seyana ina nauwena aku seyana ginamiya.”  ");
INSERT INTO bwd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","“Ada kaliva adiselu ina faifaisewa bakuleya ani seyana ina nauwena aku seyana ginamiya.” ");
INSERT INTO bwd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ada tonogalayavo itolidadanena, ivona, “Kauveya, gaitoma-dina taidei gadedeku ina yegemona?” Bana gilufata, givona, “Gadedeku kevakeva alialikana wagaine, wadedeku bwayobwayo ina vagauta.” ");
INSERT INTO bwd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ada vona matalivulivuna seyana giifufuyena ke gina vewaledi vaita tova moyaina ina veoveola ada yadi vetumagana keke gina kabekabebe. ");
INSERT INTO bwd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Givona, “Melala seyana wagaine tovevonayavuga seyana gimiyamiya. Banae keke maita Yaubada gida matause, kaduwe kaliva faidiya keke maita gida nuwanuwa. ");
INSERT INTO bwd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ada kaduwe wadedeku melala-nai wagaine seyana sikwa imiyamiya, badi tova moyaina ielayewayewa tovevonayavuga-nai wagaine ke iveoveolena, ivonena, ‘Kaliva seyana givenibainema. E ada uda lemema ke amavita una kivetununa ke yama veiwaka anavaina.’ ");
INSERT INTO bwd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ada tova manamanawena tovevonayavuga yadi veola gidibusoyogena, aku aimo nuwainegene-deya givona, ‘Vona velemoena Yaubada keke gada matause, ada kaduwe keke gada nuwanuwa kaliva faidiya, ");
INSERT INTO bwd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","aku sikwa taidei isifwayagi-moe ivedibusoyosoyoga-mowa. Taidei faina gana lemedi ke adivita gana kivetununa ada yadi veiwaka ina vaina. E ada keke kaduwe ina elayewayewa ke ina kivevologilogiyeku.’” ");
INSERT INTO bwd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ada Kauveya givona, “Tovevonayavuga yana dewa keke yegayegana aku gavana givonayena ani wana nuwenuwena. ");
INSERT INTO bwd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aku gavaiyamu, Yaubada Tauna yana kalivamomo venuvenuwadadanidi ani itagivedadaga wagaine bogi ke yadayada wagaidiya, ani adivita gina kivetununa ke yadi veiwaka gina veledi o keke? O kai yadi veola tova moyaina wagaine ani gina venogaledi o keke? ");
INSERT INTO bwd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Gavonemi ika. Velemoena Yaubada Banae iwaka-moena ayo tovevonayavuga-nai keke wa yana vemoimoina, e ada maduga-mowa adivita gina kivetununa ke yadi veiwaka gina veledi. Aku taidei yaku tolidadana, gavaiyamu, tova-nai Banae Kaliva Natuna gina yewana, aga gina nuwagana tomiyababi wa yadi vetumagana iveoveola o keke?” ");
INSERT INTO bwd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kaliva tufodi taudiyavo ivetumaganedi vaita badi yegayegadiyavo aku mali kaliva ani iitaitatagodi. Ada taidei vona matalivulivuna Yeisu giifufuyena wagaidiya, givona, ");
INSERT INTO bwd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kaliva adiselu ina iluku manuwa tabu ina veoveola. Seyana Falisi aku anavelu takesi anatoyaudi. ");
INSERT INTO bwd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falisi ani gimididi-mowa ada giveoveola tauna faine, givona, ‘Yaubada, gavesiule wagainiya faina Iya keke mali kaliva anafaiweya, badi tokiyafu, koyona anatogugaiyavo ke toudo, o taidei takesi anatoyaudi anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wiki seyana seyana ani yadayada iluwei wagaidiya Iya kani gailoilovau. Ada yaku lokoloko ke yaku mani galuluvisidi anabou teni ada wagaidiya bou seyana gavele-kavovoyena Oye wagainiya.’ ");
INSERT INTO bwd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Aku takesi anatoyaudi banae au gimididi maita tabae, ada wa yana vovomumu nodi keke maita gida itavedadaga gabama wagaine, aku aseasena gimunumununa ada givonavona, ‘Yaubada, Iya tokoyona. Uda nuwakalikaliyeku.’ ");
INSERT INTO bwd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Gana vonemi, banae takesi anatoyaudi gigugai tunutunugina Yaubada matane. Taidei faina tova-nai giyegemona ginau manuweya, Yaubada bademowa yana koyona givenuwaegedi ada gisena yegayegana Banae matane. Aku bana Falisi ani keke. Faina badi gavega taudiyavo ina kilakaidi ani Yaubada gina kiobuyedi, aku badi gavega taudiyavo ina kiobuyedi, badi Yaubada gina kilakaidi.” ");
INSERT INTO bwd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kaliva tufodi bebeta ialiyedi Yeisu wagaine ada vaita nimana ginasena wagaidiya ke gina awanuwakabubuyedi. Aku tonogalayavo taidei iitana ada iawatadi. ");
INSERT INTO bwd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Aku Yeisu biyabiyama gidouwedi ke inaelai Bana wagaine ada givona, “Biyabiyama kabikabisodi keke wana awatadi aku wana awaegedi inaelai wagaikuya, faina Yaubada yana ebaveimeya anakalivayavo ani taide biyabiyama-dina anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gavona velemoena wagaimiya, kai gaito keke gina awaege Yaubada gina veiveimeya aseasene vaita kwamana kabisona anafaiweya, aga keke-mowa ginaluku Yaubada yana ebaveimeya wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tonagona seyana Yeisu gitolidadanena, givona, “Tovewala iwakana, gavana gadagai ayo yawai-vagata gada nuwaga?” ");
INSERT INTO bwd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ada Yeisu gilufata, givona, “Gavana faina uvona Iya iwakaku? Keke tamo gaito iwakana aku Banae Yaubada anakaibe-mowa. ");
INSERT INTO bwd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aku yana veimeya bademowa ualamanena, ‘Keke unaudo, keke una luvealika, keke una kiyafu, kaliva yadi gugai faidiya keke una awatalatalaina fwayafwaya, ada kaduwe ina ke tama una vemoimoinedi.’” ");
INSERT INTO bwd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ada kaliva-nai givona, “Yaku tova kwamana wagaine-deya gavebutu veimeya-dina taidei matatabuna gaitaveyabidi ada gielai malinai.” ");
INSERT INTO bwd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeisu taidei ginogalina ada givonena, “Gaitoma seya-moena wagaine aimo uvemaufo. Unanau ya lokoloko matatabuna una vekimoneyedi ke manina una veledi tofanifani, e ada kaikaiwabu velemoena gabameya una nuwagana. Ada unaela una muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aku kaliva taidei ginogalina ada au magigina gikokomina ke ginuwavita lakaina, faina banae tokaikaiwabu lakaina. ");
INSERT INTO bwd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ada Yeisu giitana ginuwavita lakaina ada givona, “Badi tokaikaiwabu yadi luku Yaubada yana ebaveimeya wagaine ani vitana velemoena! ");
INSERT INTO bwd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Wana itana, kevakeva lakaina anayegana kameli ani kai gina balalava ada vaita gaima matana wagaine gina lukufolega ani gavaiyamu, anafata? Keke. Ada tokaikaiwabu ani ananuwanuwa anafaiweya. Kai badi taudiyavo yadi toyogina wagaine ina balalava ke Yaubada yana ebaveimeya wagaine inaluku, ani ibalalava-wayoga.” ");
INSERT INTO bwd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ada biyavo-dina Yeisu nodi ani vona taidei inogalina ada itolidadana, ivona, “Kai taidei anafaiweya aga gaito anafaiweya kibababala gina nuwaga?” ");
INSERT INTO bwd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aku Yeisu gilufata, givona, “Gavana kaliva wagaidiya keke maita meyameyaganina ani Yaubada wagaine meyameyaganina.” ");
INSERT INTO bwd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ada Pita givona, “Una itana, ime gaitoma moyaina asegedi ada aela O amuliyeni.” ");
INSERT INTO bwd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeisu givona wagaidiya, givona, “Vona velemoena, gavona wagaimiya, badi gavega Yaubada yana ebaveimeya faina inuwanuwa e ada yadi manuwa isegedi o kai vavinediyavo o tubuiyadiyavo, kai inadiyavo o tamadiyavo, kai natudiyavo isegedi, ");
INSERT INTO bwd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ani anavetutamwata moyai-moena ina nuwagana tova malinai wagaidiya, ada kaduwe tova gielaelai wagaine yawai-vagata ina nuwagana.” ");
INSERT INTO bwd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeisu yana tonogalayavo adituwelo givonedi ielai lilivane ada givonedi, “Wana nogalina. Ideyavo kalakalaka Yelusalema wagaine, ada gavana matatabuna falofitayavo ivetokilumina Banae Kaliva Natuna faine ani gina yegemona velemoena. ");
INSERT INTO bwd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Au badi keke meIsileli nimadiya ina atuegena ke ina awaveleigena, inavona awadamana wagaine, ina kiwalina, ");
INSERT INTO bwd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ada ina lubibiwalina ke ina luvealikana. Aku yadayada anaveto wagaine ginayawa-vagila alikeya.” ");
INSERT INTO bwd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Taidei anafaiweya Yeisu tonogalayavo gimatawedi, aku keke maita nuwadi gidamali yana vona-nai faina. Ananuwanuwa ani sewasewavuyena wagaidiya, ada gavana givonayena ani badi keke ida alamane. ");
INSERT INTO bwd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ada Yeisu ke badi gavega kaliva-dina nodi inaunau, ani bademowa Yeliko lilivane inunuyegemona aku kaliva seyana matana koyo-moena givetovetoga wai lilivane giawaveoveola. ");
INSERT INTO bwd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aku tova-nai yoo iela inaunau ani ginogalina, ada gitolidadana gavana taidei giyegeyegemona. ");
INSERT INTO bwd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ada kaliva ivonena, “Yeisu kwana Nasaledi giela ginaunau.” ");
INSERT INTO bwd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","E ada banae bonana lakaina givedou, givona, “Yeisu! Oye Deivida yana tubudelideli, uda nuwakalikaliyeku!” ");
INSERT INTO bwd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aku badi gavega wai inagona ani iduweyena ada ivona, “Auwe gina kuluni!” Aku bana keke. Bonana gilaka-mowa givedoudou, “Oye Deivida yana tubudelideli, uda nuwakalikaliyeku!” ");
INSERT INTO bwd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ada Yeisu au ginumididi ke giveimeya kaliva-nai matana koyona ina aliyena Bana wagaine. Tova-nai gielai lilivane, ada Yeisu gitolidadanena, givona, ");
INSERT INTO bwd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Gavana nuwanuwa gana gugai fainiya?” Banae gilufata, givona, “Kauveya, nuwanuwaku gadaita.” ");
INSERT INTO bwd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ada Yeisu givonena, givona, “Iwakana, unaita. Ya vetumagana gikiveiwakaneni.” ");
INSERT INTO bwd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ada maduga-mowa matana iyegayegana ada givebutu Yaubada giawadavadavana aku Yeisu gimulimuliyena. Ada kaliva moyaidi iitana gavana giyegemona, ada badi kaduwe Yaubada idavana. ");
INSERT INTO bwd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeisu gina giluku Yeliko ada nefanine ginaunau. ");
INSERT INTO bwd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ada kaliva seyana wadedeku gimiyamiya anayegana Sakiusa, banae takesi anatoyaudi ada aditonagona lakaina aku kaikaiwabuna. ");
INSERT INTO bwd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nuwanuwana gida itana gaito banae Yeisu, e aku keke anafata faina yoo lakaina ada banae kaliva maufona. ");
INSERT INTO bwd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","E ada wai gimadunago ginau ada gilaka ai anayegana sikamowa wagaine Yeisu gina itana, faina wai-nai wagaine gielaelai. ");
INSERT INTO bwd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ada tova-nai Yeisu ginuyegemo fafali-nai wagaine ada giitalaka aku givonena, givona, “Sakiusa, unamadu obuelai, Iya nuwanuwaku malinai ya manuweya gana miyamiya.” ");
INSERT INTO bwd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ada maduga-mowa giobuelai ada wa yana vemwamwala nodi givagaule inau yana manuweya. ");
INSERT INTO bwd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ada gaitoma taidei kaliva moyaidi iitana ada ivebutu igavoluvolu, ivona, “Sakiusa banae tokoyona aku Yeisu ginauna yana manuweya gina awakawaka.” ");
INSERT INTO bwd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aku Sakiusa gimididi ada Kauveya wagaine givona, “Kauveya, una itana. Malinai yaku lokoloko taidei gana ludakana nefanine ada bou seyana fanifani gana veledi, ada kaduwe kai tamo kaliva yana mani fwaya wagaine ada gavai-kavovona vetutamwata nodi, aga gavaiyei anatubuga gavai-kavovona ani gana fataveyewana tova laufuli anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ada Yeisu givonena, givona, “Tova malinai kibababala gielai manuwa taidei anatomiyayavo wagaidiya, faina kaliva taidei banae kaduwe Ebelaamo yana tubudelideli. ");
INSERT INTO bwd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Faina Bana Kaliva Natuna gielai ke badi gavega Yaubada yana wai ibavuyena ani gina leleledi ada gina kibababaledi.” ");
INSERT INTO bwd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kaliva aimo ivanevanenega gaitoma taidei wagaine aku vona matalivulivuna seyana giifufuyena wagaidiya, faina bademowa gielai Yelusalema lilivane ada kaliva inuwanuwa vaita Yaubada yana ebaveimeya kai malinai-mowa gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Givonaga, “Kaliva seyana kaikaiwabuna ginau fafali atuwadeya, ada wadedeku kini lakaina gina venuwadadanena ke gina vekini ayo muliya ginayewa yana ebaveimeya wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ada muliya-yo ginanau aku yana togugaiyavo aditeni gidouwedi ielai ada seyana seyana giveledi wani analedi kina (K100). Givonediga, ‘Mani taidei wana vefaisewa gina tubuga ada anavetutamwata lakaina wana vaina analaba Iya gana yewaku.’ ");
INSERT INTO bwd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Aku tauna yana kalivayavo idibusoyoge-moena, e ada tomatawa iimilidi ivemulitagoiye inau ke kini lakaina ina vonena, ‘Ime keke nuwanuwama kaliva taidei gina vekini faimeya.’ ");
INSERT INTO bwd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ada auwe gavaiyamu aku givekini ke yana ebaveimeya ginuwagana, ada giyewa yana melaleya. Gielai, ada aimo yana togugai-dina aditeni gimatawedi inaelai bana wagaine, biyavo-dina mani giveledi. Nuwanuwana gina alamanena gavaiyamu mani-nai ivegugaiye, ada gavaiyei maita vetutamwata inuwagadi. ");
INSERT INTO bwd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ada tofaisewa seyana wai ginago gielai givona, ‘Kauveya, ya mani wani analedi kina (K100) gavefaisewana, ada anavetutamwata wani tausani kina (K1,000) ganuwagana.’ ");
INSERT INTO bwd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Yana kauveya gilufata, givona, ‘O togugai iwaka, ugugai iwaka-moena. Gaitoma kabiso-moena wagaine wa avetumagana faina, melala lakaidi teni una vaidi una veimeyedi.’ ");
INSERT INTO bwd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Togugai anavelu gielai givona, ‘Kauveya, ya mani wani analedi kina (K100) gavefaisewana ada anavetutamwata faifi analedi kina (K500) ganuwagana.’ ");
INSERT INTO bwd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Yana kauveya gilufata, givona, ‘Ada oyeni melala lakaidi faifi una vaidi una veimeyedi.’ ");
INSERT INTO bwd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ada togugai anaveto gielai ada givona, ‘Kauveya, una itana ya mani taidei, gakiwafina nuya wagaine ada gasei gimiya. ");
INSERT INTO bwd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Taidei anafaiweya gagugai vuvuna o gamatauseni, faina gaalamaneni oye kaliva debai toyogina ada keke uda gugai-kavokavovo ya mani wagaine. Faina badi gavega ifaifaisewa fainiya ani keke udafata-dewedewedi, ada o tauni wagainiya gaitoma moyaina ukiveyabina.’ ");
INSERT INTO bwd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Yana kauveya gilufata, givona, ‘Oye togugai koyo-moe! Tauni ya vona-dina wagaine gana vevonayavugini. Bademowa ualamaneku Iya kaliva debaiku toyogina, ada badi gavega ifaifaisewa faikuya ani keke gadafata-dewedewedi, ada gaitoma moyaina gakiabina tauku wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ada nonogana gavana faina yaku mani keke udasei banika wagaine, e ada tova-nai gada yewaku ada gada vaina wa anavetutamwata nodi?’ ");
INSERT INTO bwd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“E ada kauveya givona badi gavega imidimididi lilivane wagaidiya, givona, ‘Yaku mani wani analedi kina (K100) gavelena ani wana vaiyewena, ada kaliva-nai banae wani tausani kina (K1,000) wagaine gimiyamiya ani banae wana velena.’ ");
INSERT INTO bwd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Badi ivonaga, ‘Aku kauveya, banae bademowa wani tausani kina (K1,000) wagaine!’ ");
INSERT INTO bwd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Aku bana gilufata, givona, ‘Ika, aku gana vonemi, badi gavega Yaubada yana vona inogalina ke ivevefaisewana ani badi kaduwe alamana gina veledi, e ada Yaubada anaalamana badi wagaidiya gina tubuga-mowa. Aku gavega Yaubada yana vona keke ida vevefaisewa, badi yadi alamana kabisona ani Yaubada gina vaiyegena wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aku badi nibaikuweyavo, biyavo-dina keke nuwanuwadi Iya gana vekini wagaidiya, ani wana aliyedi idedeku matakuya wana luvealikadi.’” ");
INSERT INTO bwd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeisu ifufu taidei giluyabuna ada gitauya wai ginagona aku yana tonogalayavo imuliyena ada nodi ilakalaka Yelusalema faina. ");
INSERT INTO bwd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ada melala Bedipegi ke Bedani wagaidiya inuyegemona, tainei oya Olive dibune, ada yana tonogalayavo adiselu giimilidi ke wai ina nagona, ");
INSERT INTO bwd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","givonedi, “Imi wai wana nagona melala wadebaimiya wagaine, ada wana lukuluku ani wana nuwagana doniki natudi isifona. Tainei kevakeva-nai evaguna, banae keke tamo gaito gidayage. Wana yavuna ada wana aliyena. ");
INSERT INTO bwd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ada kai tamo gaito gina tolidadanemi, ginavona, ‘Gavana faina wayavuyavu?’ au wana vonena, ‘Kauveya gina vegugaiyena tufona yana faisewa wagaine, ada tova kabisona gina imili-vagile ginaelai.’” ");
INSERT INTO bwd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","E ada adiselu giimilidi ani wai inago inau, ada givonedi anafaiweya inuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ada doniki natudi iyavuyavuna ani tunovuna itolidadanedi, “Gavana faina doniki wayavuyavu?” ");
INSERT INTO bwd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ada badi adiselu ilufata, ivona, “Kauveya gina vegugaiyena tufona yana faisewa wagaine, ada tova kabisona gina imili-vagile ginaelai.” ");
INSERT INTO bwd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ada doniki ialiyena Yeisu wagaine ada adinuya badobadodi iyavelidi domone ada ileme Bana giyage. ");
INSERT INTO bwd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ada gitauya ginaunau aku kaliva adinuya badobadodi iyaveyavelidi wai wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ada gielai fafali-nai lilivane gadedeku wai giobu ginau Oya Olive wagaine, ada tonogalayavo yoo lakaina ani inuwenuwedi gugai ebameyasidobodobo moyaina gigadi faina, e ada ivebutu bonadi lakaina wagaine, wa yadi vemwamwala Yaubada idavadavana. ");
INSERT INTO bwd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ada ivonavona, “Kini gielaelai KAUVEYA anayeganeya ani wa anaawanuwakabubu! Gabama ke babi wagaine miya niwalova kanuwagana, ada KAUVEYA Banae Togetane-mwane kana kaiyena ke kana davana!” ");
INSERT INTO bwd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aku Falisiyavo tufona yoo nafodiya ani Yeisu wagaine ivona, “Tovewala, ya tonogalayavo una awatadi ada una vonedi gina kuludi!” ");
INSERT INTO bwd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Banae gilufata, givona, “Gana vonemi, kai badi gina kuludi aga kabala ina kovamogatala.” ");
INSERT INTO bwd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aku Yelusalema lilivane gielai ani melala-moena giitana wagaine gitagiya, ");
INSERT INTO bwd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","givona, “MeYelusalema! Nuwanuwaku lakaina taidei yadayada-nai wagaine wada alamanena gavana yami miya niwalova gida kiveyegemoni, aku malinai sewasewavuyena matami wagaine ada keke amifata wanaita. ");
INSERT INTO bwd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ada tova gielaelai wagaine miya vitana ina yegemona wagaimiya, ada amigaviya inaelai ina kalififimi ke ina miyafifimi ada fafali matatabuna ina miyabodabodana, keke seyana awaga ginatufo. ");
INSERT INTO bwd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ada taumiyavo ke natumiyavo nodi yami melala anakali nafone-mwane aku ina munutagotagomi ada ina luyaweyawelimi. Keke seyana tamo kabala ina kisege ginatufo tauna tubuiyana getane ginamiya. Faina Yaubada yana tova gielai wagaimiya ani keke wada itainana.” ");
INSERT INTO bwd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ada Yeisu gina giluku manuwa tabu anafafali wagaine, ada badi gavega ivevekimone ani giveyegemonidi ");
INSERT INTO bwd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ada givonedi, givona, “Yaubada bonana ivetokilumina Buki Tabu wagaine givonaga, ‘Yaku manuwa ani manuwa ebaveoveola’. Aku imiyavo wagana vaita tokiyafu yadi manuwa.” ");
INSERT INTO bwd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ada yadayada seyana seyana Yeisu givevewala manuwa tabu wagaine. Aku veyavo anatovegugai lakaidiyavo ke veimeya anatovewalayavo ada kaliva aditonagonayavo ani wai ilelena ke ina luvealikana, ");
INSERT INTO bwd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","aku keke adifaiweya tamo wai ina nuwaga ada ina gugaiye, faina kaliva moyaidi Yeisu yana vona wagaine nuwadi giabina velemoena. ");
INSERT INTO bwd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tova seyana manuwa tabu wagaine Yeisu givewavewala ada valeya iwakana gilulumamalena kaliva wagaidiya, aku veyavo anatovegugai lakaidiyavo ada veimeya anatovewalayavo ke kaliva lakaidiyavo ielai Bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ada ivonena, “Una vonema, gava veimeya wagaine gaitoma-dina taidei ugugaiyedi? Gaito veimeya taidei giveleni?” ");
INSERT INTO bwd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ada Banae gilufata, “Iya kaduwe gana tolidadanemi gaitoma seyana faine. Wana voneku, ");
INSERT INTO bwd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Iyoni Tobabitaiso ani gaito veimeya givele ke kaliva gikivebabitaisodi? Yaubada o kaliva?” ");
INSERT INTO bwd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ada taudiyavo iveifuifufuyena, ivona, “Gavaiyamu kanavona? Kai kanavona, ‘Yaubada veimeya givelena,’ aga ginavona, ‘E ada gavana faina Iyoni yana vona keke wada vetumagane?’ ");
INSERT INTO bwd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aku kai kanavona, ‘Kaliva veimeya ivelena,’ aga kaliva moyaidi ina tutuvealikada kabala wagaidiya, faina badi inuwaveyalaina vaita Iyoni banae Yaubada yana falofita seyana.” ");
INSERT INTO bwd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","E ada badi ilufata, ivona, “Keke ada alamane gadedeku veimeya givai.” ");
INSERT INTO bwd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Bana givona, “E ada Iya kadu keke gana vonemi gaito yana veimeya wagaine ida gaitoma-dina gagugaiyedi.” ");
INSERT INTO bwd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ada Yeisu badi tonagona-dina nodi ivevonavona giavaina aku yoo wagaidiya ani givona matalivulivuna, givona, “Kaliva seyana yana babi wagaine gileifi bulavadi analoi gibakulina. Ada muliya kaliva tufodi nodi iveimeya ke bakula ina kidewedewena, ada ina itaveyabina aku ikolu anatoveya toni bakula-nai anavutuvutuga guwa ina velevelena. Aku tauna ani yana melala gisege ginau mali fafaliya gimiya tova manamanawena. ");
INSERT INTO bwd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ada imiyami aku gileifi anaikolu anatova giyegemona, ada tonibakula-nai yana togugai seyana giimilina ginanau bakula anatoitaveyabina wagaidiya vaita anavutuvutuga gileifi guwana ina velena, anafaiweya gavaiyamu yadi awaegena tova-nai veimeya ibubuna wagaine. Ada ginau wagaidiya aku toitaveyabina togugai ikiveyabi ilumalimaliwavuna, ada keke idavele aku makagekagena iimili giyewa. ");
INSERT INTO bwd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ada kadu togugai seyana giimilina. Aku kaduwe banae ilumalimaliwavuna ke idewa koyo-moena wagaine ada ikivevovomumuna, ada au makagekagena iveyewana. ");
INSERT INTO bwd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kaduwe togugai anaveto giimilina aku imunu iivekimana ada ibatuge giyegemona kali domone. ");
INSERT INTO bwd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“E ayo tonibakula ginuwanuwa, givona, ‘Gavana ganagai? Tauku natuku gana imilina, banae natu aseaseku. Kai banae ina vemoimoinena.’ ");
INSERT INTO bwd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Aku natuna ani tova-nai giyegemona ada toitaveyabina-dina iitana, taudiyavo iveifuifufu, ivona, ‘Ida tau-moena toni laova, ada aimo bakula taidei ginavai gina veimeyena. E ada wanaela kana luvealikana ada yana bakula kana vaina.’ ");
INSERT INTO bwd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ada au itai iyegemonena gileifi anabakula wagaine ada iluvealikana.” Yeisu yana vona matalivulivuna giluyabuna aku gitolidadanedi, givona, “E ada tonibakula-nai ani gavaiyamu gina dewedi? ");
INSERT INTO bwd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ginaelai ada bakula toitaveyabina-dina gina luvealikadi aku gileifi anabakula-nai ani toitaveyabina evagudi nimadiya ginasena.” Aku kaliva gaitoma taidei inogalina ada ivona, “Keke-bamowa taide gaitoma-nai gina yegemona!” ");
INSERT INTO bwd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ada Yeisu giita tunutunugina wagaidiya aku gitolidadana, givona, “Ada kai tainei anafaiweya, aga gavana vona-nai anaalamana ivetokilumina Buki Tabu wagaine, givonaga, ‘Ogola-nai manuwa toiyogona idibusoyogena ani banae gimidinagona ogola velugadiyavo wagaidiya’? ");
INSERT INTO bwd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Moyaidi gavega inabeu ogola-nai wagaine ani ina bidobodobodi kabiso kabiso, aku badi gavega wagaidiya ogola-nai ginabeu gina lutagodi ani gina lufuwafuwadi vaita avu anafaiweya.” Taidei anafaiweya Yeisu givona. ");
INSERT INTO bwd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aku badi Mosese yana veimeya anatovewalayavo ke veyavo anatovegugai lakaidiyavo nuwadi gimalina vaita badi faidiya givona matalivulivuna. Tainei faina wai ilelena vaita maduga-mowa Yeisu ina kiveyabina, aku yoo imatausedi. ");
INSERT INTO bwd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ada taidei faina Yeisu iitaita venanauna, e ayo toitavagivagiya tufodi iimilidi, badi kaliva-dina ani inadewa vaita kaliva velemoena iwakadiyavo. Badi inuwanuwa evona gavana tamo Yeisu ginavona sidamane, e ada wagaine ina kiveyabina ke kabemali toveimeya nimane inasena yana veimeya toyogina nafone. ");
INSERT INTO bwd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ada badi toitavagivagiya ielai Yeisu wagaine itolidadanena, ivona, “Tovewala, ime aalamanena gavana uifuifufuyedi ada uvevewala ani velemoena tunutunugina. Ada kai kaliva anayegana lakaina o kai keke, Oye ani keke uda nuwanuwa faine aku au Yaubada yana wai faina uvevewala tunutunugina. ");
INSERT INTO bwd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","E ada gavaiyamu, ide meIsileli adaveimeya Mosese wagaine ani giawaegeda ada Sisa wagaine takesi kana lufata o kai keke?” ");
INSERT INTO bwd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aku Yeisu giitaluku ke yadi nuwanuwakavu giitana ada givona, ");
INSERT INTO bwd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Wana vewaleku mani siliva.” Ada mani-moena ialiye ivelena. Ada gitolidadanedi, givona, “Gaito taidei anununa? Ada gaito anayegana ivetokilumi dobone?” ");
INSERT INTO bwd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Badi ilufata, ivona, “Sisa.” Banae givona wagaidiya, givona, “E ada gavana Sisa yana gaitoma aga wana velena Sisa, aku gavana Yaubada yana gaitoma aga wana velena Yaubada.” ");
INSERT INTO bwd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","E ada badi keke adifaiweya Yeisu ina vebavu gavavona tamo koyona gina vonaye yoo matadiya. Au yana laufata wagaine meyadi gisidobodobona ada gikulu-moedi. ");
INSERT INTO bwd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","E ada Sadusi tufodi ielai Yeisu wagaine, badi ivetumagana evona kaliva yadi alika muline keke inayawa-vagila. Ada biyavo-dina itolidadanena, ivona, ");
INSERT INTO bwd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tovewala, Mosese veimeya seyana givetokilumina faideya, givona, ‘Kai kaliva seyana vavinena gina alikalovena aku keke natunavo, aga gilubodana kaliva-nai anatubuluga sikwana gina nagina e ada tubuiyana fatana faina natunavo gina vetubudi. Taidei wagaine ada toalika yana tubudelideli ina miyamiya.’” ");
INSERT INTO bwd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ada ebaita ivelena, ivona, “Seyana kaliva anatubulugayavo nodi adiseveni. Ada tomoinagona ginagi ada natunavo keke aku gialika. ");
INSERT INTO bwd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ada sikwana ani taina anavelu ginagina ada gialika, keke natunavo. ");
INSERT INTO bwd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ada anafaiweya taina anaveto, ginagina vavine-nai, natunavo keke aku gialika. Ada dewa-nai seyana kaliva-dina adiseveni wagaidiya, natudiyavo keke aku ialika. ");
INSERT INTO bwd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Muline-mwane vavine kaduwe gialika. ");
INSERT INTO bwd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","E ada, yawa-vagila anatoveya ani gavakaliva vavinena? Faina adiseveni-dina vavine-nai inagina.” ");
INSERT INTO bwd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeisu gilufata, givona, “Badi kaliva ke vevine tova malinai babiya imiyamiya ani inaginagi ada isisivenagi. ");
INSERT INTO bwd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Aku aimo keke anafaiweya yawa-vagila anatoveya. Tova tayuwe wagaine badi gavega Yaubada giawaveiwakanedi ke ginuwenuwedi vaita adilauboda inayawa-vagila alikeya ke Banae nodi inamiya, ani keke ina naginagi kadu keke ina vevenagi. ");
INSERT INTO bwd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ada keke aimo ina alialika, faina badi yadi miya vaita Yaubada yana aneloseyavo anafaiweya. Ada kaduwe biyavo-dina ani Yaubada natunavo, faina gina siveyawadi alikeya. ");
INSERT INTO bwd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aku toalika inayawa-vagila faina, kana itana ai kabisona giyabeyabela ifufuna wagaine. Mosese Yaubada givewagana ani ‘Ebelaamo yana Yaubada, Aisake yana Yaubada, ke Iyakobo yana Yaubada.’ ");
INSERT INTO bwd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yaubada ani keke kaliva alialikadiyavo yadi Yaubada, aku velemoena Banae ani kaliva wayawaidi yadi Yaubada. Faina kai kaliva wayawaidi o kai bademowa ialika, e aku Yaubada matane ani moyaidi wayawaidiyavo.” ");
INSERT INTO bwd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ada Mosese yana veimeya anatovewalayavo tufodi ilufata, ivona, “Tovewala, ulufata iwakana.” ");
INSERT INTO bwd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ada tayuwe yadayada-nai wagaine-deya, keke tamo gaito kaduwe gida asevatu ke Bana gida tolidadane. Au iilovau. ");
INSERT INTO bwd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ada Yeisu givona wagaidiya, givona, “Gavaiyamu-yo ivona evona Banae Mesaiya ani Deivida yana tubudelideli seyana? ");
INSERT INTO bwd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Faina Deivida tauna giawatalatalaina Buki Same wagaine, givona, ‘Banae KAUVEYA Yaubada ani Iya yaku Kauveya givonena, givona, “Aiyatagikuya una vetoga ");
INSERT INTO bwd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","analaba nibaimomo gana seobuyedi ada yadi toyogina gina avaina velemoena.”; ");
INSERT INTO bwd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Au taidei anafaiweya Deivida ani Mesaiya givewagana ‘yaku Kauveya’, aku gavaiyamu-yo Mesaiya aimo gitubuga Deivida yana tubudelideli seyana?” ");
INSERT INTO bwd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ada kaliva moyaidi aimo ivanevanenega yana tolidadana-nai faina, aku Yeisu givona yana tonogalayavo wagaidiya, givona, ");
INSERT INTO bwd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Wana itaveyabimi Mosese yana veimeya anatovewalayavo yadi dewa wagaine. Badi nuwanuwadi adinuya manamanawedi ina osedi aku ina nunudadana, ada nuwanuwadi kaliva wa yadi vemoimoina ina vesiuleyedi maketi wagaine. Kaduwe nuwanuwadi manuwa ebavewala wagaidiya ina vetovetoga fafali-dina kaikaiwabudi wagaidiya, ada kaduwe kanibutu lakaidi aditoveya ani nuwanuwadi ina vetovetoga ebavetoga-dina isedi kaliva wa adivemoimoina faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Badiyavo tova ke tova kaliva matadiya iveoveola-faila e ada kaliva ina veitadi ke ina kaiyedi, aku kaduwe sikwasikwa ifwayafwayadi e ada yadi manuwa ke yadi giba ilemalemadi. Biyavo-dina taidei adimatavuloga vitana velemoena ina nuwagana.” ");
INSERT INTO bwd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeisu givetoga manuwa tabu wagaine ada giitanau giitadi kaliva kaikaiwabudiyavo yadi velekavovo isesedi velekavovo anaebavedodoga wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kaduwe sikwa seyadi fanifanidi giitadi, ielai ke yadi velekavovo mani kabisodi iluwei idododi. Mani-nai vaita toya seyana anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ada Yeisu givona, “Vona velemoena, sikwa taidei yadi velekavovo ani kaliva moyaidi yadi velekavovo gitubusegedi. ");
INSERT INTO bwd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Faina kaliva matatabudi ivele-kavovo ani yadi kaikaiwabu lakaina gimiyamiya ada anatufo kabisona isena, aku badi fanifanidi keke tamo gavana gida miyami aimo gina lemedi, aku yadi mani-nai kabisona vaita gida lemedi ani matatabuna ise-yabuna.” ");
INSERT INTO bwd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aku Yeisu yana tonogalayavo tufodi manuwa tabu ikaiyena ke idavadavana ivona, “Una itana, kabala lakaidi ada lunamanamalidi, adiita iwakadi! Kaliva yadi nuwakabubu iawaegedi Yaubada faine ani wagaidiya manuwa iveigavuna.” Aku Yeisu givona, ");
INSERT INTO bwd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Taidei gavana matatabuna waitaitana, ani tova gielaelai wagaine kabala-dina keke seyana ginatufo ke inamiya getane, aku seyana seyana ina vetutuyaweyawelidi inaobu.” ");
INSERT INTO bwd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ada badi itolidadana, ivona, “Tovewala, gaitoma-dina taidei uvonayedi ani gavatova wagaine ina yegemona? Ada gavana gina veiyaiyaya tova-nai taidei gaitoma-dina tova kabisona ina yegemona?” ");
INSERT INTO bwd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Banae gilufata, givona, “Wana itaveyabimi ada keke seyana gaito yana vefwayafwaya wagaine gina sibalemi. Faina aimo kaliva moyaidi akuyeganeya inaelai ina vonaga, ‘Iya game-nai tauku Keliso!’ ada kaduwe inavona, ‘Tova-nai ani bademowa givelilivana-mowa!’ Badi ivonavona anafaiweya ani keke wana muliyedi. ");
INSERT INTO bwd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ada tova-nai gaviya lakaidi valeyadi wana nogalina o kai wana kaiyanogala, vaita fafali tulina tulina anakaliva tufodi imididi ilulugaviya yadi kabemali anatonagonayavo wagaidiya, aga keke wana aseuloulolo. Faina gilubodana gaitoma-dina taidei nagona ina yegemona, aku ebalauyabu anatova ani aimo keke gina maduela.” ");
INSERT INTO bwd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kaduwe givona wagaidiya, givona, “Yoo seyana ina mididi ke mali yoo nodi ina lugaviya, ada kadu anafaiweya ebaveimeya seyana gina alakaidi ke mali ebaveimeya nodi ina lugaviya. ");
INSERT INTO bwd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ada mabibi lakaidi inamadu ada fafali tulina tulina wagaidiya loka ke veoga koyodi kaliva ina kivekoyodi. Ada gugai ebamatauta ke iyaiyaya toyogi-moedi wagabameya ina yegemona. ");
INSERT INTO bwd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Aku muliya-yo taidei gaitoma-dina moyaina ina yegemona, nagona kaliva ina kiveyabimi ke ina kiveuloulolonimi. Ada ina vaimi ina nauwemi manuwa ebavewala wagaidiya ina vemididimi ke tafalolo anatoveimeya lakaidiyavo ina vevonayavugimi, ada deliya inasemi. Kaduwe imi yaku tonogalayavo faina, ina nauwemi kiniyavo ke kabemali toveimeya lakaidiyavo matadiya ina vevonayavugimi. ");
INSERT INTO bwd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","E aku taidei tova-dina wagaidiya ani yami tova iwakana ke Iya faikuya wana awatalatalaina badi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Aku Iya gana alavelevelemi ke gana nuwauyavelemi, e ada nibaimiyavo wagaidiya keke tamo gaito anafata yami vona ina vonatago o kai ina veweye ke ina amalakiboye. Taidei faina aseasemiya wana nuwaveyalaina ada keke wana nuwanuwa vaita gavaiyamu taumiyavo aimo wana awabababalimi. ");
INSERT INTO bwd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ada taumiyavo inamiyavo o tamamiyavo o amitubulugayavo, o amiunumayavo o tubuiyamiyavo nonogana ina atuegemi toveimeyayavo nimadiya, ada tufomi ina luvealikami. ");
INSERT INTO bwd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ada kaliva moyaidi ina agougemi faina imi yaku tonogalayavo. ");
INSERT INTO bwd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aku keke wana matauta. Keke kuluwa anavutuvutu seyana wanasege. ");
INSERT INTO bwd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Atuvefaileya wana mididi toyogina, ada taidei wagaine taumiyavo yawaimi wana yavana. ");
INSERT INTO bwd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Aku tova-nai wana itana tolugaviya yoo moyaina Yelusalema ina miyafifina, tayuwe wana alamanena ani melala-nai analuyaweyawela givelilivana. ");
INSERT INTO bwd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tayuwe tova-nai badi Yudiya anafafali ina miyamiya ani gilubodadi inaota inalaka oya wagaidiya. Ada kaduwe gavega ina miyamiya Yelusalema wagaine ani inaota ina yegemona, ada badi gavega wamelaleya fafali lakaina wagaidiya ani keke inaela inaluku Yelusalema. ");
INSERT INTO bwd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Faina tayuwe tova-dina kaliva adimatavuloga ina nuwagana yadi koyona igugaiyena faina, e ada gaitoma-dina ivetokilumina Buki Tabu wagaine ani matatabuna gina luveyegemonina velemoena. ");
INSERT INTO bwd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ada kaduwe ota anatova wagaine ani vevine waifugadiyavo ke vevine tovesusu ina venuwakalikali velemoena, faina keke adifaiweya ina maduota. Faina yadayada-dina wagaidiya mulolova lakaina gina yegemona fafali-nai wagaine, ada Yaubada yana nuwakoyo lakaina anamanini vita-moena kaliva-dina taidei ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Gaviya lakaina gina yegemona ke moyaidi ina alika benisi wagaine aku tufodi ina kiveyabidi ina nauwedi babi anakaliva adiyoo tulina tulina wagaidiya. Ada badi keke meIsileli ani Yelusalema anatomiyayavo ina lugaviya wagaidiya ada ina toyogisegedi ke yadi melala lakaina inavai ina veimeyena. Ada keke kaliva ina vemoimoinedi aku ina veimeya toyogina wagaidiya analaba yadi tova veimeya Yaubada givenuwadadanena anafaiweya ina luyabuna. ");
INSERT INTO bwd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ada aimo iyaiyaya ebanuwavogana ina yegemona kauwana, vaikoi, ke ailabama wagaidiya. Ada babi taidei wagaine ebaveimeya tulina tulina wagaidiya kaliva ina asekolukolu, faina leyaga yana velalaga analunununuga ke buli anafaiweya oya, ada keke ida alamane gavana inagai. ");
INSERT INTO bwd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ada gabama wagaine gaitoma toyogidi ani Yaubada gina liudi, e ada wagaine kaliva ina venuwavogana gavana iyegeyegemona babi matatabuna wagaine. Ada ina matauta lakaina ke inaala. ");
INSERT INTO bwd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ada tayuwe tova-nai wagaine Banae Kaliva Natuna ina itana gina elaelai buibui wagaine wa yana toyogina ke wa yana iwakana mamalina lakaina nodi. ");
INSERT INTO bwd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ada tova-nai gaitoma-dina taidei ina vebutu ina yegemona, aga wa yami asevatu wana mididi ke wana italaka, faina tova-nai Yaubada gina tutuveobumi ani givelilivana.” ");
INSERT INTO bwd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ada vona matalivulivuna seyana giifufuyena, givonedi, “Wana itadi ai alaa ke ai moyaidi. ");
INSERT INTO bwd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tova-nai lukudi evagudi ina lukabukabu, aga bademowa taumiyavo waitaitana ada waalamanena vaita bademowa ginagina lakaina yana tova givelilivana ke kauwana toyogina gina vebutu. ");
INSERT INTO bwd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","E ada kaduwe anafaiweya, tova-nai wana itadi iyaiyaya-dina ina yegeyegemona, aga wana alamanena vaita Yaubada yana ebaveimeya anatova givelilivana. ");
INSERT INTO bwd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gavonemi velemoena, tova malinai anayooyavo ani keke ina alika-yabu aku taidei gaitoma-dina matatabuna inamadu yegemona. ");
INSERT INTO bwd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Gabama ke babi gina avaidi aku yaku vona keke maita gina avaidi, au ginamiya-vagata. ");
INSERT INTO bwd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Taumiyavo wana itaveyabimi aenanai nuwami gina dolana dewa kwavakwava wagaine, kai gufa lavulavugidi wanayuga kwavakwava, kaduwe babi anamiyami faine wana venuwana lakaina. Faina kai taidei anafaiweya wanadewa, aga yaku yewa-vagila anayadayada gina yegemona wagaimiya anafaiweya dai. ");
INSERT INTO bwd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Faina gina yegemona tomiyababi moyaidi wagaidiya babi matatabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aku tova moyaina wana veitabodaboda ada wana veoveola ke gaitoma-dina moyaidi ina yegemona ani amifaiweya wana osedi, e ada aimo amilauboda wa yami asevatu nodi wana mididi Bana Kaliva Natuna matane.” ");
INSERT INTO bwd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yadayada seyana seyana Yeisu givevewala manuwa tabu wagaine, ada bogi wagaidiya giyegeyegemona ginaunau oya anayegana Olive wagaine ada gimiyamiya malalavu. ");
INSERT INTO bwd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ada kaliva moyaidi malabutuya-mwaeya ielaelai manuwa tabu wagaine ke Yeisu bonana ina nogala. ");
INSERT INTO bwd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ada kanibutu seyana anatova ginunuyegemona, tainei Beledi Keke wa Anayisti Anakanibutu, anayegana kaduwe Nugulina. ");
INSERT INTO bwd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aku veyavo anatovegugai lakaidiyavo ke Mosese yana veimeya anatovewalayavo, ani wai ilele ke Yeisu ina luvealika-egena, aku yoo imatausedi. ");
INSERT INTO bwd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ada badi wai ilelele aku Seitani giluku Yudasa Isakaliyota wagaine, banae seyana tonogala adituwelo adiyoo wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ada ginau veyavo anatovegugai lakaidiyavo ke manuwa tabu anafilisimaniyavo wagaidiya, ada nodi iveifuifufu gavawai wagaine Yudasa gina nagoyedi e ada Yeisu nimadiya ginasei ke ina kiveyabina. ");
INSERT INTO bwd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Badi ivemwamwala lakaina ada iawaegau mani ina velena. ");
INSERT INTO bwd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","E ada Yudasa giawaegau ke givebutu gilelena yana tova iwakana anamwatugu ada Yeisu ginasena badi tonagonayavo nimadiya, aku keke kaliva moyaidi matadiya. ");
INSERT INTO bwd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Abutu-nai anayegana Beledi Keke wa Anayisti giyegemo, ada anayadayada bademowa giyegemona wagaine Nugulina analami ani ina munudi ke ina vebolavoiyedi. ");
INSERT INTO bwd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","E ada Yeisu giimilidi Pita ke Iyoni ada givonedi, “Wananau ke Nugulina aana wana kidewadewa faideya e ada nodi kanakani.” ");
INSERT INTO bwd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Badi itolidadanena, ivona, “Ada gadedeku nuwanuwa anakidewadewa?” ");
INSERT INTO bwd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Banae gilufata, givona, “Wana nogalina. Tova-nai wanaluku Yelusalema ada kaliva gufa wa tuwavina giavalana ani nodi wana venuwaga. Banae wana muliyena ke manuwa-nai wagaine ginaluku ani wadedeku nodi wanaluku. ");
INSERT INTO bwd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ada toni manuwa wana vonena, ‘Tovewala gitolidadana, Gadedeku wakawaka yadi tutulagolota ada wagaine yaku tonogalayavo nodi Nugulina aana anakani?’ ");
INSERT INTO bwd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ada banae gina vewalemi tutulagolota lakaina manuwa getane, bademowa giba matatabuna isedewedewena. Wadedeku-deya adaga wana kidewadewa.” ");
INSERT INTO bwd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ada adiselu itauya inau, ada gavana Yeisu givonayedi ani inuwagana anafaiweya. E ada wadedeku Nugulina aana ikidewadewa. ");
INSERT INTO bwd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tova-nai kani anatova giyegemona ada Yeisu yana afositoloyavo nodi ienokekela ke inakani teibeli wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ada Yeisu givona wagaidiya, givona, “Iya nuwanuwaku lakaina Nugulina taidei aana imi nodi kana kanina muliya-yo uloulolo gana nuwagana. ");
INSERT INTO bwd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Faina gavonemi velemoena, keke kaduwe ganakani-vagile analaba gina yegemona velemoena Yaubada yana ebaveimeya wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ada waini wa veina givaina, givona vesiule Yaubada wagaine ada givona, “Wana vaina ada wana vutugena wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Faina gavonemi velemoena, tova taidei ke gina naunau ani waini keke kaduwe ganayu-vagile analaba Yaubada yana ebaveimeya gina yegemona.” ");
INSERT INTO bwd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ada beledi givai givona vesiule Yaubada wagaine, ada gikiinena ke giveledi aku givona, “Taidei vovoku gaawaegena faimiya. Taidei wana gugaiyena akuebanuwaududu faina.” ");
INSERT INTO bwd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ada kani giavaina, kaduwe anafaiweya waini wa veina givaina ke givona, “Taidei waini ani Iya dayagiku iwaiwana faimiya, ida dayaga-nai Yaubada yana veyavo anawai evaguna faina. ");
INSERT INTO bwd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aku wana nogalina, kaliva-nai ginaseku nibaikuweyavo nimadiya ani banae Iya nodi teibeli taidei wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Anafaiweya tuwaina Yaubada givenuwadadanena ani Banae Kaliva Natuna ginanau alika wagaine, aku kaliva-nai gina ivemogatalina nibainavo wagaidiya ani aimo vita lakai-moena gina nuwagana!” ");
INSERT INTO bwd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ada tonogalayavo ivebutu ivetolitoli taudiyavo wagaidiya gaito taidei anafaiweya ginadewa. ");
INSERT INTO bwd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kaduwe ivevonavona evona gaito wagaidiya-deya anayegana lakai-moena. ");
INSERT INTO bwd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ada Yeisu givonedi, givona, “Badi keke meIsileli yadi kiniyavo ani iveiveimeya toyogina yadi kalivayavo wagaidiya, aku toveimeya-dina ani taudiyavo ivewagadi kaliva aditoleme. ");
INSERT INTO bwd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aku imiyavo ani keke anafaiweya wanadewa. Aiyada wagaimiya gaito anayegana lakai-moena, ani gilubodana gina nuwaobu vaita kwamana kabisona anafaiweya. Ada banae gaito givetonagona ani gilubodana gina vetogugai. ");
INSERT INTO bwd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Faina gaito lakai-moena? Banae gienokekela gikanikani o kai kaliva-nai givetogugai aa gikidewadewa? Velemoena ani banae gienokekela gikanikani. Ika taidei velemoena, e aku imi amimwatuguya ani Iya gavetogugai wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aku imi biyavo-mina Iya akuvita moyaina wagaidiya ani keke wada segeku aku lilivakuya wamiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ada anafaiweya Kamaku akuveimeya giveleku ke ebaveimeya wagaine gana veimeya, Iya kaduwe amiveimeya gavelemi ");
INSERT INTO bwd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","e ada yaku teibeli wagaine wanakani ke wanayuga yaku ebaveimeya wagaine. Kaduwe veimeya anaebavetoga kaikaiwabuna wagaidiya wana vetogami aku Isileli unumidi adituwelo wana veiveimeyedi.” ");
INSERT INTO bwd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kadu Yeisu givona, “Saimoni, Saimoni, Seitani ani Yaubada giveolena ada awaega givaina ke imi moyaimi gina sibutubutumi anafaiweya tobakula witi gisibutubutuna. ");
INSERT INTO bwd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aku Iya bademowa Yaubada gaveolena o fainiya e ada ya vetumagana wagaikuya keke ginabe matatabuna. E ada aimo tova-nai bademowa una nuwavilana ani tubuiyamomo unavona asevatudi.” ");
INSERT INTO bwd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aku Pita gilufata, givona, “Kauveya, Iya gaawaegeku ke O nodi kanaluku deli wagaine ada nodi kananau alika wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeisu givona, “Pita, gavoneni velemoena, malinai kamukamu keke gina madukwage aku nagona una veweyeku tova toiye vaita keke uda alamaneku.” ");
INSERT INTO bwd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ada Yeisu tonogalayavo gitolidadanedi, givona, “Tova-nai gaimilimi wayegemona wanau melala tulina tulina wagaidiya walumamala-nau, aku keke yami mani anaebavedodoga wadavai ke yami lokoloko anafose o kai amiageyafayafa. Aku gavaiyamu, tamo lokoloko wagaine wavemaufo?” Badi ilufata, ivona, “Keke.” ");
INSERT INTO bwd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ada givona wagaidiya, givona, “Aku tova malinai, kai wa ya mani aga una vaina, kadu anafaiweya ya lokoloko anafose. Ada kai ya benisi keke, aga anuya badobadona una vekimoneyena ke mani una vaina ada benisi una kimonena. ");
INSERT INTO bwd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Faina gana vonemi, gavana tuwaina Buki Tabu wagaine ivetokilumina, ani gilubodana gina yegemona velemoena Iya wagaikuya, givona, ‘Ada Banae veimeya anatoiyawela nodi iveyawa-tamwaidi.’ Ika, gavana ivetokilumina Iya faikuya ani anaetowava gilulunuwagana tunutunugina.” ");
INSERT INTO bwd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ada tonogalayavo ivona, “Kauveya, una itana, taidei benisi iluwei.” Banae gilufata, givona, “Auwe.” ");
INSERT INTO bwd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ada Yeisu giifufu giavaina, giyegemona ginau Oya Olive wagaine yana dewa anafaiweya, ada yana tonogalayavo imuliye nodi inau. ");
INSERT INTO bwd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ada fafali-nai wagaine iyegemona ada yana tonogalayavo wagaidiya givona, “Wana veoveola ada keke aladibidibi wagaine wanabe.” ");
INSERT INTO bwd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ada gisegedi ginau anafaiweya kabala kana batugena anaatuwada, ada tugana givetodonena aku giveoveola, ");
INSERT INTO bwd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","givona, “Kamaku, kai ya nuwanuwa anafaiweya, aga uloulolo anavei taidei uda vaiyegena wagaikuya. Aku keke yaku nuwanuwa, au Oyeni ya nuwanuwa anafaiweya una gugaiyena.” ");
INSERT INTO bwd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ada giveoveola ani gabameya anelose seyana giyegemona wagaine ada gikivetoyogina. ");
INSERT INTO bwd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ada aseasena giulolo lakaina faina, giveoveola toyogi-moena, e ada anaibala gieloelolo babi wagaine anafaiweya dayaga. ");
INSERT INTO bwd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ada giveoveola giavaina, gimididi giyewa tonogalayavo wagaidiya ani ginuwagadi idaudau, faina nuwavita gimunudi wagaine ikabekabebena. ");
INSERT INTO bwd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ada gitolidadanedi, “Gavana faina wadauda? Wana mididi wana veoveola e ada keke aladibidibi wagaine wanabe.” ");
INSERT INTO bwd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yeisu aimo giifuifufu ani yoo iyegemona, ada kaliva-nai anayegana Yudasa ginagoyedi, banae tonogala seyana adituwelo wagaidiya. Ada gilaka gielai Yeisu gina veyaugina ");
INSERT INTO bwd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","aku Yeisu givonena, givona, “Yudasa, aiyo, vetubuiyana anaveyauga wagaine Banae Kaliva Natuna unasena nibainavo nimadiya?” ");
INSERT INTO bwd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ada au Yeisu yana tonogalayavo iitana gavana gina yegemona ada ivona, “Kauveya, kai benisi wagaidiya ana imunuga?” ");
INSERT INTO bwd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ada tonogala seyana Yeisu yana yoo wagaine ani yana benisi gisiwakana ada kaliva seyana tagana aiyatagina gitalayoe gibeu. Bana kaliva-nai ani veyavo anatovegugai aditonagona yana togugai seyana. ");
INSERT INTO bwd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aku Yeisu gilufata, givona, “Auwe, keke anafaiweya wanadewa!” Ada nimadidina gisena kaliva tagana wagaine ke gikivebwainina. ");
INSERT INTO bwd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ada badi Yeisu faine ielai ani veyavo anatovegugai lakaidiyavo ke badi manuwa tabu anafilisimaniyavo ada meIsileli yadi kaliva lakaidiyavo. Ada Yeisu givona wagaidiya, givona, “Gavaiyamu, Iya vaita tobaninivula anafaiweya ada waelai wabenisimiyavo ke wafetomiyavo? ");
INSERT INTO bwd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yadayada seyana seyana Iya imi nodi manuwa tabu wagaine aku keke wada kiveyabiku. Aku malinai ani imiyavo yami tova, ada kaduwe yuyuvana yana tova veimeya.” ");
INSERT INTO bwd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","E au Yeisu ikiveyabina ada inauwena veyavo anatovegugai aditonagona yana manuweya. Aku Pita bana atuwadeya gimulimuliyedi. ");
INSERT INTO bwd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ada kaliva tufodi manuwa-nai anaebaga wagaine ai ikulina, ada wadedeku ivagauta ai ivevevala, ani Pita giela givetoga badi nodi. ");
INSERT INTO bwd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aku togugai vavine seyana ai malina wagaine giitana Pita givetovetoga, ada giitadonedonena ke givona, “Ei! Kaliva taidei kadu Banae nodi.” ");
INSERT INTO bwd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aku Pita givewa, givona, “Vavine, Iya keke maita kaliva-nai gada alamane.” ");
INSERT INTO bwd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ada maita-moena imiya ani kadu seyana gaito Pita giitana ada givona, “Oyeni kaduwe seyana badi wagaidiya.” Aku Pita kadu givewa-vagila, ada givona, “Kaliva, Iya keke!” ");
INSERT INTO bwd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ada maita imiya kauwana anaava givaina anafaiweya bai seyana ada kaduwe kaliva seyana giawafatafata givona, “Au velemoena tauna Banae nodi, faina banae kwana Galili.” ");
INSERT INTO bwd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aku Pita givewa-mowa ada givona, “Kaliva, gavana uvonevonena Iya keke gada alamane!” Ada tayuwe vona-nai givonavonayena ani kamukamu gikwage. ");
INSERT INTO bwd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ada Kauveya gimiyavilana ada giita tunutunugina Pita wagaine, e ada Pita giduna vona-nai Kauveya givonayena wagaine, givona, “Malinai kamukamu keke gina madukwage aku nagona unavewa tova toiye vaita keke uda alamaneku.” ");
INSERT INTO bwd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ada Pita yana vewa-nai nuwana giafolena, e ada manuwa anaebaga wagaine-deya giyegemona wamelaleya, ada au gitagilumaibulu. ");
INSERT INTO bwd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aku kaliva-dina badi Yeisu iitaitaveyabina ani iawaveleigena aku ilavulavuna. ");
INSERT INTO bwd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ada matana ifaibodana ada ivonena, “Una falofisai gaito gilavuni!” ");
INSERT INTO bwd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ada kaduwe vona koyo-moedi ivonayedi wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mala gilavuna malabutuya-mwaeya badi meIsileli yadi Kaniselayavo, tainei veyavo anatovegugai lakaidiyavo ada kadu Mosese yana veimeya anatovewalayavo, ani biyavo-dina ivagauta seyana. E aku Yeisu ani ialiyena matadiya ivemididina. ");
INSERT INTO bwd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ada ivonena, “Kai velemoena Oyeni Mesaiya, una vonema.” Ada Yeisu gilufata, givona, “Kai Iya gana vonemi aga keke wana vetumaganeku, ");
INSERT INTO bwd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ada kadu kai gana tolidadanemi aga keke wana lufata. ");
INSERT INTO bwd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aku tova malinai ke gina naunau ani Banae Kaliva Natuna gina vetoga gina miyamiya Yaubada Totoyogi-moena aiyatagine.” ");
INSERT INTO bwd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ada moyaidi itolidadana, “E ada gavaiyamu, velemoena Oyeni Yaubada Natuna?” Banae gilufata, givona, “Ika wavona velemoena, Iyayeku.” ");
INSERT INTO bwd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ada badi ivona, “Gavana faina toitavedama kaduwe yadi awatalatalaina aimo kana lelele? Tauna awane-mwane bademowa taudeyavo kanogalina.” ");
INSERT INTO bwd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","E au badi meIsileli aditoveimeyayavo matatabu-moedi imididi ada Yeisu iabi inauwena Pailato kwana Loma wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ada wadedeku ivebutu iawavekoyoyena, ivona, “Kaliva taidei anuwagana Banae yama kalivamomo meIsileli givevewale-koyodi. Ada giawatama evona keke takesi ana lufata Sisa wagaine, ada Tauna gikilakaina evona Banae Mesaiya, ada kini.” ");
INSERT INTO bwd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ada Pailato gitolidadanena Yeisu, givonaga, “Velemoena Oyeni meIsileli yadi kini?” Yeisu gilufata, givona, “Au uvona anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","E ada Pailato giawatalatalaina badi veyavo anatovegugai lakaidiyavo ke yoo wagaidiya, givona, “Iya keke tamo koyona gada nuwaga kaliva taidei wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aku badi iawafatafata toyogina, ivona, “Banae yana vewala koyona wagaine, kaliva moyaidi nuwadi gisigadagadana Yudiya anafafali matatabuna, ada Galili-deya givevuvuna gielai anaetowava idedeku Yelusalema.” ");
INSERT INTO bwd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ada Pailato ginogalina ani Yeisu yana vewala givevuvu Galili wagaine, e ada gitolidadana, givona, “Velemoena kaliva taidei kwana Galili?” ");
INSERT INTO bwd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ada tova-nai nuwana giafolena Yeisu banae Elodi yana ebaveimeya dibune gimiyamiya tainei Galili wagaine, e ada Yeisu giimili ginau Elodi wagaine, faina tova-nai wagaine Elodi tauna Yelusalema wagaine gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ada Elodi Yeisu giitana wagaine givemwamwala lakaina, faina tova manamanawena Yeisu valeyana ginoganogalina, ada nuwanuwana lakaina gina itana. E ada tayuwe wagaine ginuwavetumagana vaita gugai ebameyasidobodobo tamo ginagai gina itana. ");
INSERT INTO bwd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tolidadana moyaina givele-vavagilena, aku Yeisu keke tamo laufata gidavele. ");
INSERT INTO bwd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aku badi veyavo anatovegugai lakaidiyavo ke Mosese yana veimeya anatovewalayavo wadedeku nodi imidimididi, ada kaduwe iawaawavekoyoyena toyogi-moena. ");
INSERT INTO bwd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ada Elodi yana tolugaviyayavo nodi iawaveleigena ke iawadamanena. E au nuya kaikaiwabuna kini adiveigavu anafaiweya iveosena, ada giveyewa ginau Pailato wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aku tuwaina Elodi ke Pailato ivenibaina ke iludaka, e aku tayuwe yadayada-nai wagaine ani ivetubuiyana. ");
INSERT INTO bwd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ada Pailato ani veyavo anatovegugai lakaidiyavo ke toveimeyayavo kadu yoo nodi gidouwevagauwidi, ");
INSERT INTO bwd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ada wagaidiya givona, “Kaliva taidei waaliyena wagaikuya evona banae yami kalivamomo gisilakalakaidi ke kabemali yana veimeya ina luyawelina. Aku matamiya galelena Tauna wagaine, ada gaitoma-dina wagaidiya waawavekoyoyena ani koyona-dina keke tamo gada nuwaga wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kaduwe anafaiweya Elodi. Keke tamo koyona wagaine gida nuwaga. Tainei faina giveyewana wagaideya. Ada waitana, gavakoyona tamo gigai ayo analauboda alika gina nuwaga? ");
INSERT INTO bwd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tayuwe faina gana vematavulogina ada gana etoyavuna.” ");
INSERT INTO bwd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Taidei anafaiweya givona faina Loma kabemali toveimeya yana dewa ani Nugulina Abutuna anatova seyana seyana wagaidiya ani kaliva yogoyogona seyana deli wagaine gina etoyavuna meIsileli wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Aku yoo matatabu-moedi bonadi seya-moena wagaine iagofaifaina ivona, “Kaliva tainei wana nauwe wana luvealikana! Aku Balabasi una etoyavuna wagaimeya!” ");
INSERT INTO bwd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bana Balabasi ani tubuiyanavo nodi gaviya isisilakaina melala lakaina Yelusalema negenine ada kaduwe iluvealika, taidei faina banae deliya iselukuwena. ");
INSERT INTO bwd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aku Pailato nuwanuwana Yeisu gina etoyavuna faina, givona-vagila yoo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aku badi ikwageye-moe iagofaifaina, “Una kivebolagalagana! Una kivebolagalagana!” ");
INSERT INTO bwd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kadu tova anaveto Pailato givona wagaidiya, givona, “Gavana faina? Gavakoyona gigai? Keke seyana vuvu Iya gada nuwaga wagaine e ada faine alika gina nuwaga. Tainei faina matavuloga gaga gana velena. Ina lavulavuna e ada muliya gana etoyavuna.” ");
INSERT INTO bwd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aku badi vedo iluvavagilena bonadi lakaina wagaine, ada ivonavona nuwanuwadi ani Yeisu ina kivebolagalagana. Ada yadi vedo gitoyoga-mowa. ");
INSERT INTO bwd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","E ada Pailato au giawaegau yadi veola anafaiweya gina gugaiyena. ");
INSERT INTO bwd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ada kaliva-nai gaviya gisilakalakaina ke giluvealika faina deliya isena ada faine iveola ani Pailato gietoyavuna. Aku Yeisu ani kaliva yadi nuwanuwa anafaiweya ada giawaegena wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ada itauya Yeisu inaunauwena aku kaliva seyana kwana Sailini inudebaina, anayegana Saimoni. Banae yana fafaliya gitauya ke Yelusalema wagaine gielaelai. Ada tolugaviya ikiveyabina ada kelose iveavalana ke iveimeyena Yeisu muline ginanau. ");
INSERT INTO bwd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ada yoo lakaina Yeisu imuliyena, kaduwe vevine itaginuwanuwai Banae faine. ");
INSERT INTO bwd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ada ginaunau ani gimiyavilana aku wagaidiya givona, “Imi Yelusalema vevine, keke faikuya wana tagiya aku wana tagiya taumiyavo faimiya ada natumiyavo faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Faina aimo tova vitana ginaelai, ada tova-nai wagaine wana vonaga, ‘Badi vevine kakalidiyavo ani badi yadi veiwaka, faina keke ida venavenatuna ada keke ida vesuvesusu.’ ");
INSERT INTO bwd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ada oya wagaidiya inavona, ‘Imi oya, wadabe wada tavuma!’ ada oya kabisodi wagaidiya inavona, ‘Wada sewavuyema!’ ");
INSERT INTO bwd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Taidei faina wana itaveyabimi. Faina kai ina gugai anafaiweya banae keke wa yana koyona wagaine, aga gavaiyamu imiyavo?” ");
INSERT INTO bwd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ada tobaninivula kaliva adiselu ani badi kaduwe iyegemonedi ada Yeisu nodi ina luvealikadi. ");
INSERT INTO bwd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ada tova-nai ielai fafali-nai ivewagana ‘Kuluwa Sewakelu Anafafali’ wagaine, wadedeku Yeisu ikivebolagalagana. Ada tobaninivula nodi adikelose wagaidiya, seyana aiyatagine kadu seyana aimauline. ");
INSERT INTO bwd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ada Yeisu givona, “Kamaku, yadi dewa una venuwaegena, faina keke ida alamane gavana igugai.” Ada Yeisu ananuya tolugaviya ivai ivutugena taudiyavo gaga wagaidiya, taine kabala anaselakalakata anavenuwadadana wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ada kaliva imididi imatawabuwabu, aku badi toveimeyayavo ani iawaveleigena, ivona, “Mali kaliva gikibababaledi. Kai velemoena Banae Mesaiya, Banae-nai Yaubada givenuwadadanena, aga Tauna gida kibababalena!” ");
INSERT INTO bwd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ada badi tolugaviya kaduwe iawaveleigena, ada ielai vaita waini gikoyo ida velena, ");
INSERT INTO bwd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ivona, “Kai Oye meIsileli yadi kini aga Tauni una kibababaleni.” ");
INSERT INTO bwd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kaduwe anaawatalatalaina kuluwana getane ivetokilumina, taidei anafaiweya givona, “TAIDEI BANAE MeISILELI YADI KINI.” ");
INSERT INTO bwd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tobaninivula seyana wadedeku anakelose wagaine ani givona awadamana wagaine, givona, “Evona Oyeni Mesaiya? Tauni una kibababaleni, ada imeyavo kaduwe!” ");
INSERT INTO bwd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aku tobaninivula seyana ani banae tubuiyana giduweyena, givona, “Oye amatavuloga anafaiweya banae anamatavuloga anaita seyana. E ada gavaiyamu, maita Yaubada umatausena o keke? ");
INSERT INTO bwd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ideyavo ivematavulogida anatunutunugina velemoena, faina gavana yada koyona yada gugai wagaine kanuwagana anafaiweya. Aku kaliva taidei ani keke tamo koyona gida gugaiye.” ");
INSERT INTO bwd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","E au givona, “Yeisu, tova-nai unaelai ya ebaveimeya wagaine unaluku, aga una nuwaududuku.” ");
INSERT INTO bwd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ada Yeisu gilufata wagaine, givona, “Gavoneni velemoena, tova malinai o Iya nodi kana miyamiya Paladaisi wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ada bademowa kauwana gielai anafaiweya givugivudeya ani yuyuvana babi matatabuna giyuyuvanibodena, ada gimiya analaba kauwana au gienovilana teli kiloki wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Faina kauwana gikabukabuna ani giilovau. Ada manuwa tabu anaTutulagolota Tabutabu-moena ani anawana anaebaseboda kaleko giagigi-lugena. ");
INSERT INTO bwd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","E au Yeisu givedou moiyalina, givona, “Kamaku, aluwaluwaku nimaniya gaawaegena.” Taidei anafaiweya givona ada au yawaina giavaina. ");
INSERT INTO bwd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aku tolugaviya aditonagona gavana giyegemona ani giitana wagaine, givebutu Yaubada giawadavadavana, givona, “Vona velemoena kaliva taidei toyegayegana.” ");
INSERT INTO bwd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ada kaliva moyaidi ivagauta imatawabuwabu ani tova-nai iitadi gaitoma-dina taidei iyegemona, ada iyewadi yadi melaleya aku aseasedi itafitafidi yadi nuwavita lakaina faina. ");
INSERT INTO bwd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aku Yeisu tubuiyanavo moyaidi ada vevine Galili-deya imulimuliyena, ani badi imididi maita tabae kelose wagaine aku gaitoma-dina iyegemona iitadi. ");
INSERT INTO bwd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Aku kaliva seyana gimiyamiya anayegana Iyosefa, banae kwana Alimatiya, tainei Yudiya melalina seyana. Banae meIsileli yadi Kanisela anayoo seyana aku kaliva iwakana ke yana dewa tunutunugina. ");
INSERT INTO bwd_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Aku Kaniselayavo yadi veimeya ke yadi dewa Yeisu wagaine ani keke gida awaega seyana. Ada gibodabodana gavatova Yaubada yana ebaveimeya gina lakayegemona. ");
INSERT INTO bwd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Banae kaliva-nai ginau Pailato wagaine Yeisu vovona faina giveolena ke gina kiwafina. ");
INSERT INTO bwd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ada kelose wagaine vovona gikakili giobu ke toalika analifi kwayakwaya-moena wagaine gifaina, ada ginauwena didikula evaguna wagaine gilukuwena. Didikula-nai ani luwa lakaina gitalafolena yavola maufona anakabala wagaine, wada keke seyana toalika vovona idasei wagaine gidada. ");
INSERT INTO bwd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yadayada tayuwe ani Falaidei ada lavilavi wagaine Yeisu didikuleya isena, aku yadayada-nai ani MeIsileli yadi kidewadewa anatova, ada tova kabisona yadi Sabate gina vevuvu. ");
INSERT INTO bwd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ada badi vevine ielai Galili-deya Yeisu nodi ani vevine-dina Iyosefa imuliye nodi inau didikuleya, ada gavaiyamu Yeisu vovona isena didikula-nai negenine ani iitana. ");
INSERT INTO bwd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ada badi iyewadi manuweya ada ikidewadewa bunama magadi iwakadi. Aku Sabate wagaine iveyawai, anafaiweya Yaubada yana veimeya anamuliya. ");
INSERT INTO bwd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ada Sabate bade giavaina aku Sanidei aimo malalavuga ani vevine-dina inau didikuleya, ada bunama magadi iwakadi ikidewedewedi ani iwaidi inauwedi. ");
INSERT INTO bwd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Inau ada inuwagana kabala-nai didikula awana gisebodana ani bademowa wana wagaine ivekaliwawana, ");
INSERT INTO bwd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ada ina iluku aku Kauveya Yeisu vovona keke ida nuwaga. ");
INSERT INTO bwd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ada wadedeku nuwadi givoganina ada aimo inuwanuwa gaitoma taidei faina ani au kaliva adiselu iluveyakova ada lilivadiya imididi, aku adinuya ilunamanamaledi anafaiweya atunama. ");
INSERT INTO bwd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Vevine-dina wa yadi matauta ada ivetutuboubou magigidi babi wagaine, aku kaliva-dina ivona wagaidiya, “Gavana faina kaliva yawayawana walelele toalika yadi fafali wagaine? ");
INSERT INTO bwd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Banae keke idedeku, bademowa giyawa-vagila! Wana nuwaududuna gavaiyamu givonemi, tova-nai aimo imi nodi Galili wagaine, ");
INSERT INTO bwd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","givona, ‘Banae Kaliva Natuna ani gilubodana kaliva tokoyona ina veledi nimadiya, ada ina kivebolagalagana ada yadayada anaveto wagaine kaduwe ginayawa-vagila.’” ");
INSERT INTO bwd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ada vevine au yana vona iduna, ");
INSERT INTO bwd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ada didikuleya-deya iyewadi ielai, ada gaitoma-dina moyaina iawatalatalainedi afositolo adileveni, ada kaduwe badi gavega nodi imiyamiya wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vevine-dina ani Meli vine Magidala, Yowana, ke Meli banae Iyemesa inana ada kadu vevine tufona nodi, ani gaitoma-dina taidei iawatalatalainedi afositoloyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aku afositoloyavo ani vevine yadi ifufu keke ida vetumaganedi, faina yadi vona wagaidiya vaita idavona-kavokavovo. ");
INSERT INTO bwd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aku Pita gimididi ada gimadu ginau didikula wagaine. Gina gilukenala ke giitaluku ani toalika analifi gaga giitana. Ada gitauya ginaunau manuweya aku gavana taidei giyegemona faine givenuwavoganena. ");
INSERT INTO bwd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ada tayuwe yadayada-nai wagaine tonogalayavo adiselu inaunau melala ivewagana Emeusa wagaine. E, melala-nai taidei wagaine aku ginau Yelusalema ani anaatuwada kilomita ileveni (11) anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ada adiselu inaunau aku iveifuifufu gaitoma moyaina bademowa iyegemona faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ada gaitoma-dina ifuifufuyedi aku inaunau ada taudiyavo ivetolitolidadana, ani Yeisu tau-moena gielai lilivadiya ada nodi inaunau, ");
INSERT INTO bwd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","aku Yeisu anaita wagaidiya ani Yaubada keke gida awaege ada ina itainana. ");
INSERT INTO bwd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ada gitolidadanedi, givona, “Imi amiselu wanaunau, aku gavana waveifuifufuye?” Ada au inumididi aku magigidi anaita nuwavita gimunudi. ");
INSERT INTO bwd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ada wagaidiya seyana anayegana Keliyofasi banae gitoliyena, givona, “Anaita Oyeni akaibe-mowa wakawaka Yelusalema wagaine, ada gaitoma-dina iyegemona wadedeku taidei yadayada-dina wagaine ani keke uda alamanedi?” ");
INSERT INTO bwd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Banae gitolidadana, “Gava gaitoma?” Badi ilufata, ivona, “Yeisu kwana Nasaledi faine. Banae falofita, ada yana gugai ke yana vona wa anatoyogina Yaubada matane ada kaliva moyaidi matadiya. ");
INSERT INTO bwd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ada veyavo anatovegugai lakaidiyavo ke yada toveimeyayavo iawaegena alika anamatavuloga wagaine, e ada ikivebolagalagana. ");
INSERT INTO bwd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aku ime anuwaveyalaina vaita Banae Kaliva-nai tova kabisona ide meIsileli gina etoyavuda nibaideyavo wagaidiya. Ada taidei vita-dina moyaina ani ikivenuwanuwama, aku kaduwe nuwanuwa vita-moena ani malinai bademowa yadayada anaveto. ");
INSERT INTO bwd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Aku kaduwe yama vevineyavo tufodi malinai matabogibogina inau didikuleya, aku keke vovona ida nuwaga. E ada iyewadi iela ivonema vaita vewala giyegemona wagaidiya ada anelose iitadi wagaine, ada badi anelose-dina vevine ivonedi, ivona, ‘Yeisu wayawaina!’ Ada yadi vona wagaine meyama ivesidobona. ");
INSERT INTO bwd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","E ada tufona amayoo wagaine inau didikuleya ada gavana vevine ivonayena anafaiweya inuwagana, aku Banae ani keke idaita.” ");
INSERT INTO bwd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ada Yeisu givonedi adiselu, givona, “Ida imi gava vekwavakwava. Ada aseasemi yana vetumagana givekwalu-mowa, faina gavana matatabuna falofitayavo ivonayedi Mesaiya faine ani keke wada vetumagane. ");
INSERT INTO bwd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Gavaiyamu, kai keke nuwami gidamali ani analauboda ada gaitoma taidei moyaina nagona Mesaiya gina uloloyedi, aku muliya anavemoimoina lakaina gina nuwagana?” ");
INSERT INTO bwd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ada Yeisu gaitoma-dina Tauna faine ivonayedi Buki Tabu wagaine ani gikivemalina wagaidiya. Givevuvu Mosese yana vetokiluma wagaine, ada ginau falofitayavo moyaidi yadi vetokiluma wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ada melala-nai wagaine inaunau ani lilivane iyegemona, ada Yeisu gidewa vaita gida nunusegedi ");
INSERT INTO bwd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","aku badi iluveyavalena toyogina, ivonena, “Nodi kanamiya, faina kauwana giavaina ada mala bademowa givelavilavi.” Ada gina giluku nodi inamiya. ");
INSERT INTO bwd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ada nodi ivetoga teibeli wagaine aku Yeisu beledi givaina givesiule Yaubada wagaine, ke muliya gikiinena ada giveledi. ");
INSERT INTO bwd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ada au matadi gimalina ada iinanana, ani matadiya aku gibwavi. ");
INSERT INTO bwd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ada taudiyavo adiselu ivetolitoliyedi, ivona, “Keke fwaya, tova-nai kaelaelai waiya aku giifuifufu wagaideya ada Buki Tabu gikiyavuna, ani kalutovonina aseasedeya vaita ai ginaginana.” ");
INSERT INTO bwd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ada maduga-mowa itowamididi iyewadi Yelusalema. Wadedeku-deya tonogalayavo adileveni inuwagadi ada kadu tufodi tonogalayavo tubuiyadiyavo nodi ivagauta. ");
INSERT INTO bwd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ada adileveni ivona adiselu wagaidiya, ivonedi, “Vona velemoena! Kauveya giyawa-vagila, ada giyegemona Saimoni wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ada adiselu iifufu gavana giyegemona wai wagaine, ada kadu gavaiyamu Yeisu iitainana tova-nai beledi gikiinena wagaine. ");
INSERT INTO bwd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ada aimo iifuifufu gaitoma-dina faidiya, ani Yeisu au Tauna giluveyakova ada gimidiyegemona adimwatuguya ke givona, “Nuwaniwalova wagaimiya.” ");
INSERT INTO bwd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ada matatabudi au iabalutuga ada matauta gikimunudi velemoena. Inuwanuwa vaita balauma ida itaita. ");
INSERT INTO bwd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ada givona wagaidiya, givona, “Gavana faina wamatauta? Ada gavaiyamu-yo wanuwakila? ");
INSERT INTO bwd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wana itadi nimaku ke ageku. Ida Iya tau-moeku. Nimami wanasena wagaikuya ke wana itana. Balauma keke tamo wa vovona ke wa luluna, anafaiweya Iya wagaikuya waitaitana.” ");
INSERT INTO bwd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Taidei anafaiweya givona, ada nimana ke agena givewaledi. ");
INSERT INTO bwd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ada tayuwe wagaine ivemwamwala lakaina ke meyadi gibovu, aku aimo keke ida vetumagana velemoena. Tayuwe faina gitolidadanedi, “Maita aa idedeku?” ");
INSERT INTO bwd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ada igana kabukabuna tufona ivelena, ");
INSERT INTO bwd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ada au matadiya aku givai gikanina. ");
INSERT INTO bwd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ada givona wagaidiya, givona, “Wana nuwaududuna tuwaina aimo Iya nodi kamiyamiya wagaine, ada gavonemi ani gaitoma-dina matatabuna ivetokilumina Iya faikuya ani ina yegemona velemoena, anafaiweya Mosese yana veimeya wagaine ke falofitayavo yadi vetokiluma wagaine, ada Same wagaine.” ");
INSERT INTO bwd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ada Yeisu yadi alamana gikiyavuna e ada Buki Tabu nuwadi gina malina velemoena. ");
INSERT INTO bwd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ada givonedi, “Taidei anafaiweya ivetokilumina. Mesaiya gina uloulolo ke gina alika, aku yadayada anaveto wagaine alikeya ginayawa-vagila. ");
INSERT INTO bwd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ada Banae anayeganeya ina lumamala nuwavilana ke koyona anavenuwaega faidiya. Nagona ina vebutu Yelusalema wagaine ke ina naunauwena babi anakaliva adiyoo matatabudi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imiyavo ani toitavedama, ada wana awamogatala taidei gaitoma-dina faidiya. ");
INSERT INTO bwd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aku wana nogalina, Iya gananau ada Aluwaluwa Tabuna, Banae Kamaku givonadabadabayena, ani gana imilina wagaimiya. Keke Yelusalema wana madumadusege, aku wana bodaboda analaba toyogina gabameya gina veosemi.” ");
INSERT INTO bwd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ada wadedeku Yelusalema wagaine ginagoyedi iyegemona inau Bedani anafafali wagaine, ada nimana gikilakaidi ke giawanuwakabubuyedi. ");
INSERT INTO bwd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aimo giawanuwakabubuyedi ani Yaubada au gisilakaina, ada gisegedi aku gilaka gabameya. ");
INSERT INTO bwd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ada badi iawadavadavana ada wa yadi vemwamwala nodi iyewadi inau Yelusalema. ");
INSERT INTO bwd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ada tova ke tova inauna imiyamiya manuwa tabu wagaine, ada Yaubada wagaine ivesivesiule ke iawadavadava. ");
INSERT INTO bwd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tova nago-moena ibuibubuna moyaina adiebavevuvu wagaine, Banae-nai ivewagana Vona ani bademowa gimiyamiya. Ada Vona-nai Banae Yaubada nodi imiyamiya, ada kaduwe Banae Yaubada Tauna. ");
INSERT INTO bwd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Banae ebavevuvu wagaine Yaubada nodi imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ada gaitoma matatabuna Banae-nai wagaine Yaubada gibubudi. Keke tamo gava ibuibubuna gida yegemona-kavovo mali wai wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Banae wagaine ani yawai gimiyamiya, ada taidei yawai-nai ani tomiyababi yadi malina. ");
INSERT INTO bwd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ada malina-nai gituituimala yuyuvana wagaine aku yuyuvana yana toyogina ani keke anafata malina gina toyogisege. ");
INSERT INTO bwd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aku kaliva seyana gimiyamiya ani Yaubada giimili gielai, anayegana Iyoni. ");
INSERT INTO bwd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Banae gielai malina-nai faine gina vetoawatalatalaina, e ada kaliva moyaidi vona velemoena ina inanana ke ina vetumagana Banae wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aku bana Iyoni ani keke malina-moena e aku gielai ke gina vetoawatalatalaina malina-nai faine. ");
INSERT INTO bwd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aku Bana Tauna Vona, velemoena malina-moena kaliva seyana seyana gituituimalidi ani gielaelai babiya. ");
INSERT INTO bwd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ada Banae Vona gielai givekaliva-mowa babiya gimiyamiya, ada Banae wagaine Yaubada babi matatabuna ke gaitoma moyaina gibubudi, e aku babi anakalivayavo keke ida itainana. ");
INSERT INTO bwd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ada gielai Tauna yana kalivayavo yadi fafaliya aku yana kalivayavo keke ida sivaivai. ");
INSERT INTO bwd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aku badi kaliva-dina ivemwamwala yana ela faina ada ivetumagana vaita Banae Keliso ani gikivelaubodadi ke badi Yaubada natunavo velemoena ina miyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Badiyavo ani itubuga-vagila. Tubuga-vagila taidei ani keke kaliva ke vavine vovodi yadi venuwaga wagaine, o vavine moganedi yana nuwanuwa wagaine, e aku Yaubada wagaine itubuga. ");
INSERT INTO bwd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Banae ivewagana ‘Vona’ ani giela givekaliva-mowa ada gimiya ide nodi, ada yana iwakana mamalina ime aitana, ida iwakana-nai mamalina Yaubada Tamada Natuna anakaibe-mowa givelena. Banae wa yana nuwadoga lakaina kaliva wagaideya, ada tova matatabuna givonavona velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iyoni Tobabitaiso giela giawatalatalaina Banae faine, ada bonana lakaina wagaine yoo wagaidiya givona, “Tauna kaliva-nai taidei, Banae faine Iya gaawatalatalaina ada gavona, ‘Vona velemoena Iya gamaduelai, aku kaliva-nai mulikuya gielaelai ani Banae lakai-moena, keke Iyayeku. Faina Iya aimo keke gada tubuga aku Banae ani bademowa gimiyamiya.’” Taidei anafaiweya Iyoni givona. ");
INSERT INTO bwd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Banae yana nuwadoga magamaga-moena wagaine ide moyaida tova ke tova gaitoma iwakadi moyaidi kanuwanuwagadi. ");
INSERT INTO bwd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yaubada yana veimeya ani giseyegemonena Mosese wagaine. Aku Yaubada gaitoma iluwei giseyegemonedi Yeisu Keliso wagaine-deya. Seyana ani yana nuwadoga bana gilemelemeda, ada anavelu ani yana vona velemoena giveleveleda. ");
INSERT INTO bwd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Keke seyana gaito Yaubada gidaita, keke tamo tova, aku Natuna Keliso anakaibe-mowa giitana. Banae ani Tamana au nodi seya-moena, ada Banae-nai Yaubada giivemogatalina velemoena wagaideya. ");
INSERT INTO bwd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","MeIsileli tonagonayavo Yelusalema wagaine imiyamiya nuwanuwadi ina alamanena Iyoni Tobabitaiso banae gaito, e ada Yaubada yana veyavo anatovegugaiyavo ke kaliva tufodi Livai unumina wagaine nodi iimilidi inau Iyoni wagaine ina toliluveluvena. Ada ivona, “O gaito?” ");
INSERT INTO bwd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ada Iyoni giawamogatala tunutunugina, givona, “Iya keke Mesaiya, Banae-nai Yaubada givenuwadadanena.” ");
INSERT INTO bwd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ada badi itolidadanena, ivona, “E ada gavaiyamu? O Yaubada yana falofita Ilaitiya?” Iyoni givona, “Iya keke Ilaitiya.” Kaduwe badi itolidadana, ivona, “Kai o Falofita-menina ime abodabodana o keke?” Kaduwe givonaga, “Keke.” ");
INSERT INTO bwd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","E ada badi totolidadana ivona, “O gaito? Uda vonema e ada amafaiweya badi iimilima ana lufata wagaidiya. Gavaiyamu tauni fainiya uvonavona?” ");
INSERT INTO bwd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ada Iyoni yadi tolidadana gifatana, givona, “Iya kaliva-kuna gavedovedou fafali kavovona wagaine, gavona, ‘KAUVEYA yana wai aseasemiya wana kivetunutunugina.’ Taidei anafaiweya falofita-nai Aiseya givona.” ");
INSERT INTO bwd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aku taidei kaliva-dina itolidadanena ani badi Falisi adiyoo, ada wagaidiya-deya ielai. ");
INSERT INTO bwd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ada Iyoni itolidadanena, ivona, “O uvonema oyeni keke Mesaiya, o keke Ilaitiya, ada kadu o keke falofita-nai abodabodana. E aku gavaiyamu-yo kaliva ukikivebabitaisodi?” ");
INSERT INTO bwd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Iyoni gilufata givona, “Iyayeku ani gufa wagaine gakikivebabitaiso, aku bademowa amimwatuguya kaliva seyana gimidimididi Banae keke wada inana. ");
INSERT INTO bwd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Banae kaliva-nai mulikuya gielaelai ani lakai-moena aku Iyayeku kwamana kabisoku. E ada keke akulauboda Bana wagaine gana vetogugai ke anaageyafayafa anabulava gana kiyavu.” ");
INSERT INTO bwd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Taidei ifufu-nai giyegemona melala anayegana Bedani wagaine, tayuwe gufa Yolidani fafaline wagaine Iyoni kaliva gikikivebabitaisodi. ");
INSERT INTO bwd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Aku mala gilavuna Iyoni giifuifufu yoo wagaidiya ani giitanau giitana Yeisu gielaelai, ada givona, “Wana itana, Yaubada yana Lami Bana babi anakalivayavo yadi koyona gina vaiyavulena! ");
INSERT INTO bwd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Taidei kaliva-nai nagona gavonayena, gavona, ‘Kaliva seyana gielaelai mulikuya ani Banae lakai-moena keke anafaiweya Iyayeku, faina Iya aimo keke gada tubuga aku Banae ani bademowa gimiyamiya.’ ");
INSERT INTO bwd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tova-nai wagaine Iya Tauku aimo keke gada alamane Banae-nai faine gaifuifufu, aku gaelai kaliva gakikivebabitaisodi gufa wagaine e ada Banae gada ivemogatalina badi meIsileli wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kaduwe Iyoni giawamogatala taidei anafaiweya, givona, “Iya gaitana Yaubada Aluwaluwana giobuelai gabameya-deya vaita manuga bunebune anafaiweya, ada Yeisu wagaine givetoga gimiya. ");
INSERT INTO bwd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ika, Iya Tauku aimo keke gada alamane gaito Banae. Aku Banae giimiliku ke gana kikivebabitaiso gufa wagaine ani Banae-nai givona wagaikuya taidei anafaiweya, givona, ‘Kaliva-nai wagaine una itana Aluwaluwaku gina obuela ginamiya ani Banae kaliva-nai Aluwaluwa Tabuna wagaine gikikivebabitaiso.’ ");
INSERT INTO bwd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iya tau-moeku gaitana matakuya e ada gavonemi, ina velemoena Yaubada Natuna.” ");
INSERT INTO bwd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mala gilavuna kaduwe Iyoni wadedeku gimidimididi yana tonogalayavo adiselu nodi ");
INSERT INTO bwd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","aku giitana Yeisu giela ginaunau ada givona, “Wana itana, Banae Kaliva-nai ani Yaubada yana Lami!” ");
INSERT INTO bwd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ada tonogalayavo adiselu yana vona inogalina wagaine, itauya inau Yeisu imuliyena. ");
INSERT INTO bwd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ada Yeisu gimiyavila gidaita ani giitadi imulimuliyena ada gitolidadanedi, givona, “Gavana yami nuwanuwa?” Badi ivonaga, “Labai, gadedeku-deya umiyami?” E, vona taidei ‘labai’ ani anakivila ‘tovewala lakaina’. ");
INSERT INTO bwd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ada banae gilufata, givona, “Wanaela kananau ada wana itana.” E ada nodi itauya inau ada fafali-nai gimiyamiya wagaine iitana. Ada bademowa mala givelavilavi kauwana anabai fowa kiloki anafaiweya, e ada au nodi imiya ada mala gibogi. ");
INSERT INTO bwd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kaliva-dina adiselu Iyoni yana vona inogalina ke Yeisu imuliye nodi inau ani seyana wagaidiya anayegana Andulu, banae Saimoni-Pita anatubuluga. ");
INSERT INTO bwd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","E ada aimo Andulu gitauya ginau anatubuluga Saimoni gilelena. Ada ginuwagana ke givonenaga, “Ime Mesaiya anuwagana, Banae Venuvenuwadadanina Yaubada wagaine!” (Aku Giliki wagaine vona-nai ‘Mesaiya’ anakivila ani ‘Keliso’.) ");
INSERT INTO bwd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ada givagaule gialiyena Yeisu wagaine. Ada Yeisu Saimoni giitana aku givonena, givona, “Oyeni Saimoni, Iyoni natuna. Aku gana vewagani ‘Kifasi’.” (MeIsileli ivona ‘Kifasi’ aku meGiliki ivona ‘Pita’. Yegana-dina adikivila ‘kabala’.) ");
INSERT INTO bwd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mala gilavuna Yeisu nuwanuwana ginanau Galili anafafali, ada nagona kaliva seyana ginuwagana anayegana Filipi, ada givonena, givona, “Unaela una muliyeku nodi kananau.” ");
INSERT INTO bwd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Banae Filipi yana melala Bedesaida, wada kadu Andulu ke Pita yadi melala. ");
INSERT INTO bwd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi Yeisu yana vona ginogalina ada gitauya ginau ke Nataniyela ginuwagana, ada givonena, givona, “Kaliva-moena anuwagana, Bana faine Mosese givetokilumina Veimeya anabuki wagaine. Ada kadu falofitayavo ivetokiluma faine. Banae Yeisu kwana Nasaledi, Iyosefa natuna.” ");
INSERT INTO bwd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyela givona, “Gavana Nasaledi! Anafata tamo gaitoma iwakana wadedeku-deya gina yegemona, aiyo?” Filipi gilufata givonaga, “O unaela kananau ada una itana.” ");
INSERT INTO bwd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ada tova-nai Yeisu giitana Nataniyela gielaelai wagaine ada bana faine givona, “Wana itana, tayuwe kaliva-nai gielaelai ani kwana Isileli velemoena. Keke maita vefwayafwaya wagaine gida miyami.” ");
INSERT INTO bwd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyela gitolidadanena, givona, “Gavaiyamu e ayo o ualamaneku?” Ada Yeisu gilufata, givona, “Muliya-yo Filipi gidouweni, tova-nai aimo ai alaa dibune umiyamiya ani Iya gaitani.” ");
INSERT INTO bwd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ada Nataniyela gilufata, givona, “Labai, vona velemoena Oyeni Yaubada Natuna! Oyeni meIsileli yama Kini!” ");
INSERT INTO bwd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeisu givona, “Gavaiyamu, Iya gavoneni gaitani ai alaa dibune e ada taidei faina uvetumagana wagaikuya? Yaku vona o fainiya ani keke gaitoma lakaina, aku aimo gaitoma lakai-moedi una itadi.” ");
INSERT INTO bwd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E ada wagaidiya givonaga, “Vona velemoena, gavona wagaimiya, imi moyaimi wana itana gabama gina awaina ada Yaubada yana aneloseyavo ina lakalaka ada ina obuobu Kaliva Natuna wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yadayada anaveto wagaine seyana nagi anakanibutu giyegemo melala Kana wagaine Galili anafafaliya, ada badi Yeisu inana bademowa imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ada Yeisu ke yana tonogalayavo nodi kaduwe inuwabiyedi nagi anaabutu-nai wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Au ivagauta ada ikanikani ke iyuyuga aku bademowa waini iyu-yabuna, e ada Yeisu inana Banae wagaine ivona, “Adiwaini bademowa giavaina.” ");
INSERT INTO bwd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ada Yeisu gilufata wagaidiya ke givona, “Inaku, tainei ani keke ide yada gaitoma. Faina yaku tova aimo keke gida yegemo.” ");
INSERT INTO bwd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aku Yeisu inana ivona togugaiyavo wagaidiya, ivonaga, “Gavana gina vonemi ani wana gugai anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aku gufa adituwava lakaidi kabala wagaine ibubudi ani adiyoo sikisi imidimididi lilivadiya, seyana seyana anafata gina waina gufa wani analedi (100) lita. Badi meIsileli yadi tafalolo anaveimeya adikiveyegayegana Yaubada matane faine ani tuwava-dina ivevegugaiyedi yadi ikolakola faidiya. ");
INSERT INTO bwd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ada Yeisu givona togugaiyavo wagaidiya, givonaga, “Tuwava wana vemagadi gufa-mowa wagaine,” e ada ivemagasenasenadi. ");
INSERT INTO bwd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ada kadu givonedi, “E au gufa tufona wana koina ada wanawai wana nauwena kanibutu anatonagona wagaine.” Ada igugai anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aku gufa-mowa bade givewaini ani banae abutu anatonagona giyuluvaluvana aku keke gida alamane gadedeku-deya waini-nai ivai, aku badi togugaiyavo ialamanena. E ada tonagona-nai giyuna ke bana tonagi kaliva gidouwe gielai ");
INSERT INTO bwd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ada givonena, “Tova moyaina kani kasese-dewedewena wagaine, waini iwaka-moena kanamadu seyegemone wakawaka ina maduyuga ada bademowa iyuga adifata, e ayo muliya waini kavokavovo kana iwana. Aku oyeni ani gavaiyamu? Taidei waini iwaka-moena useyewena ada malinai-mowa useyegemonena.” ");
INSERT INTO bwd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Taidei Yeisu yana gugai ebameyasidobodobo anaebavevuvu ani melala Kana wagaine, Galili anafafaliya. Wadedeku yana iwakana mamalina giseyegemonena, ada yana tonogalayavo ivetumagana wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","E ada nagi taidei anaabutu-nai giavaina, Yeisu wa inana ke tainavo ada yana tonogalayavo nodi iobu inau melala Kafaneumi wagaine. Wadedeku-deya imiya yadayada gavaiyei gaga. ");
INSERT INTO bwd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ada meIsileli yadi Nugulina anaAbutu anatova givelilivana e ada Yeisu gilaka Yelusalema. ");
INSERT INTO bwd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ada wadedeku manuwa tabu anafafali wagaine kaliva ginuwagadi ivevekimone bulumakau, sifi, ada bunebune, tayuwe kaliva yadi vebolavoi faina. Ada kaduwe kaliva tufodi ivetogadi ke teibeli wagaidiya mani isevedavedama. ");
INSERT INTO bwd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ada giitadi e ada bulava gimetana ke biyavo-dina giveyegemonidi manuwa tabu anafafali wagaine, yadi sifi ke bulumakau nodi. Ada kaduwe mani anatosevedavedama yadi siliva gibiwadi aku yadi teibeli gibwataviladi. ");
INSERT INTO bwd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aku badi bunebune ivevekimone ani givonedi, givona, “Gaitoma-dina taidei wana vaidi wana nauwedi! Ida imi gavadewa ada Kamaku yana manuwa wakivila maketi!” ");
INSERT INTO bwd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ada yana tonogalayavo iitana ada iduna Buki Tabu wagaine ivetokilumina givona, “Ya manuwa tabutabuna ananuwakabubu ani aseasekuya gialalata ai alalata anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aku meIsileli aditonagona tufodi iitana e ada iela itolidadanena, ivona, “Gava iyaiyaya ebameyasidobo una gugaiye e ada adaita ke ada vetumagana vaita Oyeni wa ya veimeya nodi uelai e ada kaliva uwavidi?” ");
INSERT INTO bwd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Au Yeisu gilufata, givonediga, “Manuwa tabu taidei wana luyawelina, ada yadayada toiye wagaine kadu gana vemididi-vagilena.” ");
INSERT INTO bwd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","MeIsileli ilufata ivona, “Ida manuwa tabu anaiyogona ani kaliva inauwena-deya malamala foti-sikisi wagaidiya, e aku Oyeni ani yadayada toiye gaga wagaidiya ada una vemididina, aiyo?” ");
INSERT INTO bwd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aku manuwa tabu-nai Yeisu givonayena ani Tauna vovona. ");
INSERT INTO bwd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","E ada aimo tova-nai giyawa-vagila alikeya, yana vona-nai yana tonogalayavo inuwaududuna e ada ivetumaganena. Ada kaduwe ivetumaganena falofisai-nai Buki Tabu wagaine Banae yana yawa-vagila faina. ");
INSERT INTO bwd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","E aku Yeisu aimo Yelusalema wagaine Nugulina Abutuna anatoveya, ada kaliva moyaidi iitana gugai ebameyasidobodobo gigugugaiyedi ada ivetumagana ani Banae Mesaiya. ");
INSERT INTO bwd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Aku Yeisu Tauna kaliva moyaidi gialamanedi faina, badiyavo keke gida vetumaganedi. ");
INSERT INTO bwd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Keke vaita Banae gida vemaufo kaliva adinuwanuwa faidiya, keke. Tauna bademowa gialamanena, ada bademowa Bana anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aku kaliva seyana tayuwe gimiyamiya anayegana Nikodimo. Banae Falisi anakaliva ada meIsileli yadi Kanisela anayoo wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ada bogi seyana bana kaliva-nai ginau Yeisu wagaine ada givona, “Labai, aalamanena Oyeni tovewala Yaubada wagaine uelai, faina kai Yaubada keke kaliva nodi aga gugai ebameyasidobodobo ugugugaiyedi ani badi keke adifata.” ");
INSERT INTO bwd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeisu gilufata, givona, “Vona velemoena, gavona wagainiya, kai gaito keke gina tubuga-vagila, aga kadu keke anafata Yaubada yana ebaveimeya ginaita.” ");
INSERT INTO bwd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimo gitolidadana, givona, “Gavaiyamu, nagona kaliva gina tubuga bebetana anafaiweya aku aimo gina vekaliva lakata ani kaduwe gina tubuga-vagila? Keke analauboda ada ginaluku inana kamodiya ke gina tubuga tova anavelu!” ");
INSERT INTO bwd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeisu gilufata, givona, “Vona velemoena, gavona wagainiya, kai kaliva keke gina tubuga gufa wagaine ada Aluwaluwa Tabuna wagaine aga kadu keke anafata ginaluku Yaubada yana ebaveimeya wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kaliva ke vavinena nodi ina vevovo seyana ada kwamana ina venatunena, e ada kwamana-nai ani wa vovona ada wayawaina. Aku tova-nai kwamana o kai kaliva gina tubuga Aluwaluwa Tabuna wagaine, aga banae ani aluwaluwana wayawaina gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taidei yaku vona-nai ‘Gilubodami wana tubuga-vagila’ ani keke una tataweyane. ");
INSERT INTO bwd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mala gimadumaduga gadedeku yana nuwanuwa anafaiweya ginamadu. Butuna una nogalina, aku keke anafata una alamane gadedeku-deya gitauya giela o kai gadamamu ginauna. E ada tainei anafaiweya gavega moyaidi itubuga Yaubada Aluwaluwana wagaine. Kaliva adifaiweya ina itana vaita Aluwaluwa Tabuna kaliva gikive evaguna, aku keke ida alamane gavaiyamu gifaisewa.” ");
INSERT INTO bwd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimo gitolidadana, “Ida gavaiyamu gida yegemo?” ");
INSERT INTO bwd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeisu givonaga, “Oyeni ani Isileli anatovewala lakai, e aku gavaiyamu-yo keke nuwa gidamali gaitoma-dina faidiya? ");
INSERT INTO bwd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Vona velemoena, gavona wagainiya, gavana aalamanena ani avonayena, ada gavana aitana ani aawamogatalena, aku imi bonama keke wada venogale. ");
INSERT INTO bwd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Babi anagaitomayavo ani gavonayedi wagaimiya e aku keke wada vetumagana. E ada kai gabama anagaitomayavo faidiya ganavona, aga gavaiyamu wana vetumagana? ");
INSERT INTO bwd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Keke seyana gaito gidalaka gabameya, tainei-mowa Banae Kaliva Natuna giobuelai gabameya-deya. ");
INSERT INTO bwd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tuwai-moena Mosese mota gikilakaina wa aiwalana fafali kavovona wagaine, ada kadu anafaiweya Bana Kaliva Natuna. Gilubodana Banae ina kilakaina kelose wagaine ");
INSERT INTO bwd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","e ada gavega ina vetumaganena ani yawai-vagata ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Faina Yaubada babi anakalivayavo ginuwakabubuyedi lakai-moena e ada Natuna tubueyana giawaegena e ada gavega ina vetumagana wagaine ani keke ina alika-vagata aku yawai-vagata ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Faina Yaubada keke Natuna gida imili babiya ke babi anakalivayavo ginasedi matavuloga wagaine, keke. Aiyada giimilina ke kaliva gina kibababaledi faina. ");
INSERT INTO bwd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","E ada gavega Natuna ivetumaganena, badiyavo Yaubada keke ginasei vonayavuga wagaidiya yadi koyona faidiya. Aku badi gavega keke ida vetumagana, ina badi kaliva-dina anafaiweya yadi vonayavuga giavaina aku au ibodabodana adimatavuloga ina vaina. Faina keke ida vetumagana Natuna anakaibe-mowa anayegana wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tova-nai Yaubada kaliva wagaidiya matavuloga ginasena ani vuvuna taide anafaiweya. Malina giobuelai babiya, aku kaliva yuyuvana inuwakabubuyena velemoena ayo malina. Taidei faina nuwanuwadi ina gugai koyona. ");
INSERT INTO bwd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Faina badi gavega igugai koyona ani malina igadibudibusoyogena ada au keke nuwanuwadi malina wagaine inamiya, faina imatauta malina-nai yadi dewa koyona gina tuimalina ke gina lumogatalena, e ada wa yadi vovomumu ina miyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aku badi gavega vona velemoena imulimuliyena e ada idewadewa tunutunugina ani nuwanuwadi malina wagaine inamiya. Taidei wagaine yadi gugai ani moyaidi ina maduitadi e ada mamalina wagaidiya, faina Yaubada yana nuwanuwa anafaiweya igugugaiyedi.” ");
INSERT INTO bwd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","E ada aimo-yo Yeisu ke yana tonogalayavo nodi Yelusalema isege inau Yudiya anafafali wagaine, ada wadedeku nodi imiya aku Yeisu kaliva gikikivebabitaisodi. ");
INSERT INTO bwd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ada kaduwe Iyoni gikikivebabitaiso melala Aenoni wagaine, tainei melala Salimi lilivane, faina wadedeku gufa lakaina. E ada kaliva ke vevine inaunau bana wagaine babitaiso faine. ");
INSERT INTO bwd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tayuwe tova-nai wagaine Elodi aimo keke Iyoni gidasei deli wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aku seyana tova Iyoni yana tonogalayavo ada seyana kwana Isileli nodi igavekwavekwageya meIsileli adikiveyegayegana anawai faina. ");
INSERT INTO bwd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ada inau Iyoni wagaine ivonaga, “Labai, una duna kaliva-nai Yolidani fafaline Oyeni nodi, Banae kaliva-nai faine uawamogatala, uvona, ‘Banae Mesaiya’. Tauna Banae gikikivebabitaiso, ada kaliva moyaidi inaunau Bana wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ada Iyoni gilufata, givona, “Dewa taidei keke gida yegemona-kavovo. Ida-nai ani faina Yaubada gitoyogivelena e ada gifaifaisewana. ");
INSERT INTO bwd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imi taumiyavo boi wanogalina taidei gaifufuyena ada gavona, ‘Iya keke Keliso aku Iyayeku ani Yaubada giimiliku wai ganago gamaduelai Banae faine.’ ");
INSERT INTO bwd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ebaita ganasena. Banae ani anafaiweya tonagi kaliva bana gina nagina vavinena, aku Iyayeku anafaiweya tonagi kaliva tubuiyana, banae yadi nagi anawai gikidewedewena. Ada gimidimididi aku banae ani tonagi kaliva bonana ginogalina e ada givemwamwala lakaina. Ada taide malinai ani anafaiweya Iyayeku. Iya taide yaku vemwamwala-nai malinai bademowa magamaga-moena. ");
INSERT INTO bwd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ada gilubodana Banae anayegana gina veiveinala lakaina aku Iya akuyegana ani gina vevekabiso. ");
INSERT INTO bwd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Banae-nai gabameya-deya gielai ani kaliva moyaida gitubusegeda. Aku banae keke gabameya-deya aku au babi wagaine giyegemona ani bana babi anakaliva, ada babi ananuwanuwa giifuifufuyedi. Banae-nai gabameya-deya gielai ani kaliva moyaida gitubusegeda. ");
INSERT INTO bwd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ada gavadi giitadi ke ginogalidi gabameya ani giawamogataledi, aku keke seyana gaito yana awamogatala-nai ida vetumagane. ");
INSERT INTO bwd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aku gavakaliva Banae yana vona givenovenogalena ke givetumaganena, yana vetumagana-nai wagaine giawamogatalena Yaubada ani Banae velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kaliva-nai Yaubada giimilina ani Yaubada yana vona giifuifufuyena, faina Yaubada Banae wagaine Aluwaluwana keke maita gida nuwalolone, au givelevelena keke wa anaetowava. ");
INSERT INTO bwd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamana Yaubada ginuwakabubuyena Natuna ada gaitoma matatabuna nimane gisedi. ");
INSERT INTO bwd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gaito Yaubada Natuna givetumaganena ke tauna giawaegena wagaine ani banae bademowa yawai-vagata ginuwagana. Aku gaito Yaubada Natuna bonana givenikoiyena ani keke maita yawai-vagata gina lutovoni aku Yaubada yana nuwakoyo dibune gimiyamiya.” ");
INSERT INTO bwd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","E ada Yeisu yana tonogala ivevemoyai. Kaliva tufodi gaga Iyoni imuliyena, aku moyai-moedi Yeisu imulimuliyena ke gikikivebabitaisodi, ada Falisiyavo valeya-nai inogalina. ");
INSERT INTO bwd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aku anavelemoena ani Yeisu Tauna keke gida kikivebabitaisodi aku badi yana tonogalayavo gaga ikikivebabitaisodi. ");
INSERT INTO bwd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tova-nai Kauveya gialamanena Falisiyavo valeyana inogalina, ada Yudiya gisegena aku giyewa-vagilena kaduwe Galili wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Aku Galili anawai ginaunau Sameliya nefanine faina, Yeisu gina gigolota Sameliya anafafali wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","E ada inaunau aku iyegemona Sameliya anamelala seyana wagaine anayegana Saika, ada melala-nai ani edaubo Iyakobo yana babi-nai tova tuwaina givelena natuna Iyosefa. ");
INSERT INTO bwd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wadedeku kadu gufa kavu gimiyamiya Iyakobo giyalana, ada Yeisu gikabekabebena atuwada anana wagaine e ada givetogana kavu lilivane. Aku bademowa kauwana givugivudiya. ");
INSERT INTO bwd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ada gimiyamiya aku yana tonogalayavo inau melala wagaine aa ina kimone faina. Ada Yeisu anakaibe givetovetoga gufa kavu wagaine aku vavine seyadi vine Sameliya ielai gufa inakoi faina, ada Yeisu givonedi, givona, “Anafata gufa wada veleku maita gadayuga?” ");
INSERT INTO bwd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Badi vine Sameliya ivona, “Oyeni kwana Isileli aku ime ani vine Sameliya. Gavaiyamu-yo uveoveolema gufa yuga faina?” Taidei anafaiweya ivona faina meIsileli keke ida luveya meSameliya nodi. ");
INSERT INTO bwd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aku Yeisu gilufata, givonaga, “Kai wada alamanena gavana Yaubada givelavelau, ada kai wada alamanena Iya gaito gaveoveola gufa faina, aga wada veola wagaikuya yawai-vagata gufana ada gada velemi.” ");
INSERT INTO bwd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Badi vavine ivona, “Kauveya, ida gufa kavu giobu manamanawena, ada keke tamo ya ebaibolu. Gadedeku yawai-vagata gufana unavai? ");
INSERT INTO bwd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tamada Iyakobo gufa kavu taidei givelema, ada tauna giyuga wagaine ke kaduwe natunavo ada yana kevakevayavo. E ada gavaiyamu, o aita lakaina ayo tamada Iyakobo?” ");
INSERT INTO bwd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Bana Yeisu gilufata, givona, “Moyaidi iyuga gufa taidei wagaine ani aimo meyadi gina kwakwa-vagila, ");
INSERT INTO bwd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","aku gaito ginayuna gufa-nai Iya gana velena ani aimo keke tamo tova kaduwe meyana gina kwakwa. Gufa-nai gana velena ani aseasene gina miyamiya anafaiweya tovoga gigulagula-vagata ke yawai-vagata givelavelau.” ");
INSERT INTO bwd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Vavine ivonena, ivona, “Kauveya, gufa-nai uda velema e ada meyama keke gina kwakwa ke kaduwe keke tova moyaina ana elaela gufa ana iboibolu.” ");
INSERT INTO bwd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeisu givonedi, “Wanana moganemi wana vonena ada amiselu wanaelai.” ");
INSERT INTO bwd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Badi vavine ilufata, ivona, “Ime keke tamo moganema.” Yeisu givonedi, givona, “Wavona velemoena vaita imi moganemi keke. ");
INSERT INTO bwd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Anavelemoena ani imi moganemiyavo adifaifi bade wavaidi, ada kaliva-nai malinai wavai nodi wamiyamiya wada keke moganemi. Ada gavana wavonayena, tainei wavona tunutunugina.” ");
INSERT INTO bwd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ada vavine ivona, “Kauveya, bademowa aitanuwagana ani Oyeni falofita. ");
INSERT INTO bwd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ime meSameliya tamameyavo ani idedeku oya Gelasimu wagaine ioduodu Yaubada wagaine, aku imi meIsileli wavona vaita Yelusalema gaga wagaine kada oduodu Yaubada wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Bana Yeisu givonediga, “Vavine, yaku vona wana vetumaganena. Aimo tova gielaelai ani keke oya taidei wagaine kadu keke Yelusalema wagaine Yaubada Tamada wana oduodu wagaine, keke. ");
INSERT INTO bwd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Imi meSameliya keke wada alamane Kauveya-nai wagaine waoduodu. Aku ime meIsileli ani aalamane-moena ke aoduodu Banae wagaine, faina imeyavo givenuwadadanema ke tomiyababi adikibababala ani ime meIsileli wagaimeya-deya gina yegemona. ");
INSERT INTO bwd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aimo tova gielaelai ada tova-nai badi tooduodu velemoena ina oduodu Yaubada Tamada wagaine ani Aluwaluwa Tabuna gina nagonagoyedi ada nuwanuwa velemoena wagaine ina oduodu. Faina kaliva-dina ioduodu anafaiweya ani Yaubada Tamada nuwanuwana. Ada velemoena malinai tova-moena bademowa giyegemona. ");
INSERT INTO bwd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaubada Banae Aluwaluwa. E ada badi ina oduodu Banae wagaine ani adilauboda Aluwaluwana gina nagonagoyedi ada nuwanuwa velemoena wagaine ina oduodu.” ");
INSERT INTO bwd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Badi vavine ivona, “Aalamanena vaita Mesaiya gina yegemona, ani Banae-nai ivewagana Keliso. Ada tova-nai ginaelai aga gaitoma matatabuna gina kivemalina wagaimeya.” ");
INSERT INTO bwd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ada Yeisu givonaga, “Iya gaifuifufu wagaimiya ani Tauku Kaliva-mekuna.” ");
INSERT INTO bwd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ada tayuwe tova-nai wagaine tonogalayavo iyewadi ada iitana giifuifufu vavine nodi, e ada meyadi gisidobodobona. Aku keke seyana gaito Yeisu gida tolidadane, “Gavana nuwanuwa?” o kai “Gavana faina ada badi nodi waifuifufu?” ");
INSERT INTO bwd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ada vavine yadi tuwava gufa faine ani isei gimiya, aku iyewa inau melala lakaina wagaine ada kaliva ivonedi, ivona, ");
INSERT INTO bwd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Wanaela wana itana kaliva seyana! Gaitoma moyaina adewayedi yawaima wagaine ani givonema tunutunugina. Anaita kai Tauna Banae Mesaiya?” ");
INSERT INTO bwd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","E ada moyaidi melala-nai isegena aku inau Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ada badi yoo-dina aimo ielaelai aku yana tonogalayavo ilumodovena, ivonaga, “Labai, maita aa una kanina.” ");
INSERT INTO bwd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aku Banae givona wagaidiya, givona, “Iya wa akuga kani faina, aku akuga-nai ani mali aa nuwami keke gidamali faine.” ");
INSERT INTO bwd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ada yana tonogalayavo taudiyavo iveifuifufu, ivonaga, “Kai tamo gaito bademowa anaga givelena.” ");
INSERT INTO bwd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeisu givona, “Iya akuga ani Banae giimiliku yana nuwanuwa gana mulimuliyena ada yana faisewa gana luyabuna. Taidei ani vaita bana gikikivetoyogiku aa anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yami vona seyana ani taide anafaiweya, ‘Aimo vaikoi laufuli gina avaina ada bavagu anatova gina yegemona.’ Aku Iya gavonemi, matami gina abwana ada wana itana bakula matatabuna, bademowa waifei iboyala bavagu faina. ");
INSERT INTO bwd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bavagu anatova ani malinai! Toiyala aa iyalayalana anafaiweya, imi yaku tonogalayavo ani kaliva wana lemelemedi ke ina miyaviladi wagaikuya e ada yawai-vagata ina nuwagana. Ada toiyala guwadi inuwanuwagana anafaiweya, imi kaduwe guwami wana nuwagana. E ada tobakula ke toiyala adiselu nodi ina vemwamwala seyana. ");
INSERT INTO bwd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ada yami vona seyana givonaga, ‘Seyana gibakula e aku seyana giiyala’, ani taidei velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nagona yaku togugai ivevilaga ada yaku vona ibakulina kaliva aseasediya. Aku anaiyala faina ani imi malinai gaimiimilimi wananau ke badi yadi vevilaga-nai guwana ani imi wada yalana, tainei kaliva-dina yaku vona ibakulina aseasediya ani wana lemedi ke Iya wagaikuya ina vetumagana.” ");
INSERT INTO bwd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ada au vine Sameliya meSameliya moyaidi yadi melala wagaine iawatalatalainedi, ivona, “Gaitoma moyaina adewayedi yawaima wagaine ani givonema tunutunugina!” E ada badi yadi vona faina tufona moyaidi Yeisu ivetumaganena. ");
INSERT INTO bwd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","E ada meSameliya ielai Yeisu wagaine ada iveolena toyogina vaita nodi inamiya, e ada nodi imiya yadayada iluwei. ");
INSERT INTO bwd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ada Yeisu Tauna yana ifufu wagaine moyai-moedi kaduwe ivetumagana ");
INSERT INTO bwd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ada ivona vavine wagaidiya, ivonaga, “Nagona ime anogalina waifufu ada kaliva-nai wagaine avetumagana. Aku malinai tunutunugi-moena anogalina Tauna awane-deya. Tainei faine aalamanena ani velemoena Banae tomiyababi moyaida adaTokibababala.” ");
INSERT INTO bwd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yadayada iluwei giavaidi, Yeisu gitauya ginau Tauna yana fafali Galili wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ada nagona Yeisu Tauna bade gimaduvonayena ani falofita tauna yana yoo yana fafali wagaine ani keke ida vemoimoine. ");
INSERT INTO bwd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Aku tova-nai giela giyegemo Tauna yana fafali Galili wagaine ada meGalili isivaivaina. Faina gaitoma moyaina Banae gifaisewadi ani iitana Yelusalema wagaine, taine tova-nai badi kaduwe Nugulina Abutuna wagaine ilaka. ");
INSERT INTO bwd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ada kaduwe Yeisu ginu-vagila melala Kana gimadubodana tayuwe Galili anafafali wagaine, wadedeku-deya ani tuwaina gufa-mowa gisevedavedame givewaini. Ada kabemali aditoveimeya seyana, kaliva lakaina ani melala anayegana Kafaneumi wagaine gimiyamiya ada natuna kaliva giveoga. ");
INSERT INTO bwd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ada kaliva-nai ginogalina vaita Yeisu Yudiya-deya gielai Galili wagaine, ada ginau giveolena ke gina obuelai natuna gina kivebwainina, faina banae giveoga ada kabisona gina alika. ");
INSERT INTO bwd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ada Yeisu givonena, “Kai iyaiyaya lakaidi ke gugai ebameyasidobodobo keke wana itadi, aga keke maita wana vetumagana.” ");
INSERT INTO bwd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kabemali aditoveimeya givonaga, “Kauveya, uda maduobuela natuku uda itana aenanai gina alika.” ");
INSERT INTO bwd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeisu gilufata, givona, “Unanau. Natu wayawaina.” Ada kaliva-nai Yeisu yana vona givetumaganena ada au gitauya ginau. ");
INSERT INTO bwd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ada mala gilavuna aimo giyewayewa manuweya aku wai wagaine ginaunau ani yana togugaiyavo nodi ivenuwaga ada ivonena, ivonaga, “Natu wayawaina!” ");
INSERT INTO bwd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","E ada gitolidadanedi gavakauwana wagaine natuna giveiwaka, ada badi ivonena, “Boi yadeyadeya kauwana anafaiweya wani kiloki ani yana vovolukalalava-nai gimadu avai-moena.” ");
INSERT INTO bwd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Taidei faina bana tamana nuwana giafolefolena ani taidei anavelemoena tova-nai wagaine Yeisu givonena, givona, “Natu wayawaina.” Ada banae ke yana manuwa anatomiyayavo moyaidi ivetumagana vaita Yeisu ani Mesaiya. ");
INSERT INTO bwd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ida Yeisu yana ebameyasidobodobo ani anavelu gifaisewana tova-nai Yudiya-deya gielai Galili wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ada tayuwe tova-nai muline e au meIsileli yadi tafalolo anaabutu seyana ivemwamwalena, ada Yeisu gilaka Yelusalema. ");
INSERT INTO bwd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ada giluku Yelusalema ginaunau aku giyegemona gufa etobwebwetuna seyana, vona Ibeliu ivewagana Bedesida, wada sifi yadi ebaluku anawana lilivane. Gufa-nai afaine ani ebaveyawai faifi iyogo balawalilivugina, seyana seyana wa anakwalala. ");
INSERT INTO bwd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ada ebaveyawai wagaidiya ani kaliva moyai-vagaidi toveoga ienoliyaliya, anafaiweya badi matadi koyo-moena, badi tovefela, ke badi vovodi memeluyadi, ada biyavo-dina ibodabodana gufa yana yavivila faina. ");
INSERT INTO bwd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Taide anafaiweya ibodaboda faina tamo tova ani Yaubada yana anelose seyana gina obuelai ada gufa gina luvivivilina. Ada gavakaliva kai gina maduobu gufa anakiveyauvivila-nai wagaine aga gavaveoga givaina ani gina bwaina. ");
INSERT INTO bwd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ada kaliva seyana wadedeku gimiyamiya, banae wa veogina malamala teti-eita. ");
INSERT INTO bwd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ada Yeisu giela kaliva-nai giitana gienobalabala, ada gialamanena ani tayuwe anafaiweya gimiyamiya tova manamanawena ada gitolidadanena, givona, “Gavaiyamu, nuwanuwa una veiwaka?” ");
INSERT INTO bwd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ada toveoga-nai gilufata, givona, “Kauveya, akutolema keke. Tova-nai gufa giavivila, keke tamo gaito gida nauweku gufa wagaine. Gabalabalalava ke gaobuobu vaita gana maduluku, aku bademowa seyana gaito wai ginago gimadumadu obu.” ");
INSERT INTO bwd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ada Yeisu givonena, givona, “Una mididi, avaya unawai una nudadana.” ");
INSERT INTO bwd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ada maduga-mowa kaliva gibwaina ada anavaya giwai ginunudadana. Aku yadayada-nai kaliva-nai giveiwaka ani Sabate wagaine, ");
INSERT INTO bwd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","e ada meIsileli aditonagonayavo ani kaliva-nai giveiwaka ivonena, “Malinai Sabate, ada adaveimeya giawatada keke kana faifaisewa, e ada keke wa aawaega ke avaya unawai!” ");
INSERT INTO bwd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aku banae gilufata, givona, “Kaliva-nai gikiveiwakaneku ani banae givoneku, givona, ‘Avaya unawai una nudadana.’” ");
INSERT INTO bwd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ada badi itoliyena, “Gavakaliva taide givoneni, ‘Avaya unawai una nudadana’?” ");
INSERT INTO bwd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kaliva-nai gibwaina ani keke gida alamane gaito banae, faina wadedeku-deya yoo lakaina imiyamiya ada adimwatuguya Yeisu bademowa giamwaku ginau. ");
INSERT INTO bwd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Muliya Yeisu kaliva-nai ginuwagana manuwa tabu wagaine ada givonena, givona, “Uitana, bade uveiwaka! Ya dewa koyona unasege-vagaidi aenanai gaitoma koyo-moena gina yegemo wagainiya.” ");
INSERT INTO bwd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ada Yeisu yana ifufu giavaina, kaliva-nai gitauya ginau ada meIsileli aditonagona giawatalatalainedi, givona, “Banae kaliva-nai gikiveiwakaneku ani anayegana Yeisu.” ");
INSERT INTO bwd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ada Sabate wagaine gaitoma-dina taidei Yeisu gigugugaiyedi faina, meIsileli aditonagonayavo ikikiveuloulolonina. ");
INSERT INTO bwd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Aku Yeisu givona wagaidiya, givona, “Iya Kamaku yadayada seyana seyana gifaifaisewa ada gielai malinai, ada Iya kaduwe gafaifaisewa.” ");
INSERT INTO bwd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ada bademowa meIsileli wai ilelelena ke Yeisu ina luvealikana, aku au Bana yana vona faina inuwakoyo-mowa ada ivebutu toyogi-moena ilelele ke gavawai wagaine ina luvealika. Keke vaita Sabate anaveimeya veyawai gaga giyaweyawelina faina, aku kadu Yaubada giawavetamanena evona Tama-moena. Ada yana vona ananuwanuwa inuwanuwayena ani Tauna gikikilakaina vaita Yaubada nodi iveaigaigabu. ");
INSERT INTO bwd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","E ada Yeisu givonedi, givona, “Vona velemoena, gavona wagaimiya, Yaubada Natuna keke anafaiweya tamo gavana gina gugaiye Tauna anakaibe yana nuwanuwa wagaine. Gavana giitana Tamana gigugaiyena, tainei gagana anafaiweya gina gugugaiyena. Gavana Tamana gigugaiyena ani Natuna gigugaiyena anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Faina Tamana Natuna ginuwakabubuyena ada gaitoma moyaina gigugaiyedi ani givevewalena. Aku aimo gugai toyogi-moedi gina vewalena ke gina faisewadi e ada meyami ginabovu. ");
INSERT INTO bwd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tamana toalika gisisiveyawadi ada yawai giveleveledi, ada kaduwe anafaiweya Natuna gigugugai. Badi gavega nuwanuwana ani yawai giveleveledi. ");
INSERT INTO bwd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ada kaduwe Tamana keke tamo gaito gida vevonayavugi aku aiyada vevonayavuga anaveimeya matatabuna ani Natuna givelena, ");
INSERT INTO bwd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","e ada kaliva moyaidi Natuna ina vemoimoinena anafaiweya Tamana ivemoimoinena. Gavakaliva banae keke Natuna gida vemoimoine ani banae keke gida vemoimoine Tamana Tauna Banae giimilina. ");
INSERT INTO bwd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Vona velemoena, gavona wagaimiya, gaito yaku vona gina nogalina ke Banae giimiliku gina vetumaganena, banae yawai-vagata bademowa ginuwagana. Tauna banae bademowa alika wagaine-deya ginudamana yawai-vagata wagaine, e ada keke aimo tamo wa yana vuvu ke Yaubada gina itavenuwadadane vaita yana koyona faidiya analauboda matavuloga gina nuwaga, keke. ");
INSERT INTO bwd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Vona velemoena, gavona wagaimiya, tova gielaelai badi gavega alika anawai wagaine inaunau ani Yaubada Natuna bonana ina nogalina, ada gavega bonana ina vemoimoinena ani yawai-vagata ina nuwagana. Ada tova-moena bademowa giyegemona. ");
INSERT INTO bwd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Faina Tamada ani yawai vuvuna. Ada anafaiweya yawai Tauna wagaine, Bana Natuna givelena e ada Banae Natuna kaduwe yawai vuvuna. ");
INSERT INTO bwd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ada Banae ani Kaliva Natuna faina, Tamana veimeya givelena ke analauboda kaliva gina vevonayavugidi. ");
INSERT INTO bwd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Keke nuwami gina bovuye yaku vona, faina tova gielaelai wagaine badi moyaidi gavega adididikuleya idaudau ani Yaubada Natuna bonana ina nogalina ");
INSERT INTO bwd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ke ina yegemona. Badi gavega igugai iwakana ani inayawa-vagila ke yawai-vagata iwakana wagaine inamiya, aku badi gavega igugai koyona ani inayawa-vagila ke matavuloga ina nuwagana yadi dewa koyodi faidiya. ");
INSERT INTO bwd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Taidei veimeya-dina ani Iya keke akufata Tauku yaku nuwenuweya gada gugai aku gavana Kamaku wagaine ganogalina, tainei wagaine gaveiveimeya. Keke Tauku yaku nuwanuwa gada mulimuliye aku Banae giimiliku yana nuwanuwa. Taidei faina tova-nai kaliva gana vevonayavugidi ani tunutunugina. ");
INSERT INTO bwd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kai Iya Tauku akukaibe gaga faikuya gana awatalatalaineku kaliva wagaidiya, aga yaku awatalatalaina keke adifaiweya ina awavelemoenaye. ");
INSERT INTO bwd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aku velugana giawatalatalaina Iya faikuya ani Banae Kamaku. Ada gaalamanena yana awatalatalaina faikuya ani vona velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Valeya anatoyaudi waimilidi Iyoni wagaine ada giawatalatalaina vona velemoena Iya faikuya. ");
INSERT INTO bwd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aku kai kaliva ina awatalatalaina faikuya aga keke gada tunutunuvala wagaine, keke. Ida Iya gagaluvaluva gana ivenuwanuwami e ada Iyoni yana awatalatalaina wana vetumaganena ada Yaubada gina kibababalemi. ");
INSERT INTO bwd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Bana Iyoni yana awamogatala Iya faikuya ani vaita odama gida yabeyabela ke kaliva gida tuituimalidi anafaiweya, ada yana malina-nai faine tova maufona wa yami sefaga wavemwamwala. ");
INSERT INTO bwd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Aku gaitoma-nai giawamogataleku lakai-moena ayo Iyoni yana awamogatala faikuya ani gugai-nai Kamaku giveleku gana gugai, taine gugai ebameyasidobodobo gagugugaiyedi. Taide yaku gugai-dina iawavelemoena vaita Kamaku giimiliku. ");
INSERT INTO bwd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aku kaduwe Kamaku Banae giimiliku ani Tauna giawamogatala Iya faikuya. Aku keke tamo tova bonana wada nogali o kai anaitaita wadaita ");
INSERT INTO bwd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ada keke yana vona gida miyami aseasemiya, faina Iya giimiliku ani keke wada vetumagane. ");
INSERT INTO bwd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Buki Tabu waveyawa-dewedewena faina wanuwanuwa vaita yana vona wagaidiya-deya yawai-vagata wana nuwagana. Aku ifufu-dina ivetokilumidi matatabuna ani Iya faikuya iawatalatalaina, ");
INSERT INTO bwd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","e aku wadibusoyoga ada keke nuwanuwami wanaela Iya wagaikuya ke yawai-nai wana vaina. ");
INSERT INTO bwd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kaliva yadi awadavadava faikuya ani keke gadalele, ");
INSERT INTO bwd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","aku imiyavo gaalamanemi, keke maita aseasemiya Yaubada wada nuwakabubuye. ");
INSERT INTO bwd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Waitana, Iya gaelai Kamaku anayeganeya aku keke wada sivaivaiku. Aku kai gavakaliva tauna anayeganeya ginaelai, aga tauna banae wana sivaivaina. ");
INSERT INTO bwd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kai seyana gaito gina davami aga taumiyavo faimiya wavemwamwala, faina tubuiyamiyavo matadiya amiyegana lakaina. E aku imi gavaiyamu Yaubada anakaibe-mowa matane? Banae ani keke wada nuwanuwa faine ada keke yami nunu wadasei ke amiawadavadava wana nuwaga Banae wagaine-deya. E ada gavaiyamu Iya wagaikuya wana vetumagana? ");
INSERT INTO bwd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Keke wada nuwanuwa vaita Iya gana itavenuwadadanemi ke gana awavekoyoyemi Kamaku matane, keke. Banae amitoawavekoyo ani Mosese, tauna wagaine yami nuwavetumagana wasena ke wanuwanuwa vaita yana veimeya wamulimuliyena wagaine wana miyamiya iwakana. Aku velemoena ani bonana keke wadaabi faina, banae gina awavekoyoyemi Yaubada matane. ");
INSERT INTO bwd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kai Mosese yana vona wada vetumaganena aga Iya wada vetumaganeku, faina Iya faikuya givetokiluma. ");
INSERT INTO bwd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aku gavana Mosese givetokilumina ani keke wada vetumagane, e ada gavaiyamu Iya yaku vona-dina wana vetumaganedi?” Taidei anafaiweya Yeisu yana vona meIsileli aditonagonayavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aku muline Yeisu gidamana Lavu Galili fafaline. Lavu-nai kaduwe ivewagana Lavu Taibeliya. ");
INSERT INTO bwd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ada iyaiyaya ebameyasidobodobo gifaisewadi toveoga wagaidiya ke gikivebwainidi faina, yoo lakai-vagaina imulimuliyena. ");
INSERT INTO bwd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ada Yeisu gilaka oyaoyana wagaine givetoga yana tonogalayavo nodi. ");
INSERT INTO bwd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Aku tayuwe tova-nai meIsileli yadi Abutu Nugulina faina bade givelilivana. ");
INSERT INTO bwd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ada Yeisu matana gida segena ani giitadi yoo lakai-vagaina ielaelai Bana wagaine, e ada givona Filipi wagaine, givona, “Gadedeku maita beledi kada kimone ke kaliva idakani?” ");
INSERT INTO bwd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Bademowa Tauna gialamanena gavana ginagai, e aku taide anafaiweya Filipi gitolidadanena e ada gina galuvaluvana kai bana wa yana vetumagana kai keke. ");
INSERT INTO bwd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi gilufata, givona, “Kai mani lakaina kada vaina ayo kadana beledi kada kimonena aga aimo keke anafata. Kai beledi-nai kada dabadabana kabikabisodi ke kada vutugena aga keke adifaiweya kabiso kabiso inavai.” ");
INSERT INTO bwd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aku yana tonogala seyana anayegana Andulu, banae Saimoni-Pita anatubuluga ani givonena, givonaga, ");
INSERT INTO bwd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kwamana seyana idauwe ani bali beledina kabisodi faifi ada igana iluwei bana wagaine. Aku gavana anaiwakana kaliva taidei moyai-vagaina wagaidiya?” ");
INSERT INTO bwd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeisu givona, “Kaliva wana vonedi ina vetoga.” Tayuwe fafali-nai wagaine talaguwala lakaina, e ada moyaidi ivetogadi. Ada yoo-nai wagaine kaliva gaga iveyawadi adiyoo faifi tausani (5,000). ");
INSERT INTO bwd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ada Yeisu beledi givaidi ke givona vesiule Yaubada wagaine, ada givutugena biyavo-dina ivetogadi wagaidiya. Kadu igana anafaiweya gikiineinena ke ivutugena, ada moyaidi ikani adifaiweya matatabuna. ");
INSERT INTO bwd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tova-nai moyaidi ikani kamodi ifata, ada Yeisu givona yana tonogalayavo wagaidiya, givona, “Aditufo wana kwakwana e ada keke tamo kana venuwaegege.” ");
INSERT INTO bwd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","E ada aditufo ikwakwana ani fuwama tuwelo ivemagadi, tainei beledi faifi wagaine badi ikani ada gitufo. ");
INSERT INTO bwd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ada kaliva iitana Yeisu iyaiyaya ebameyasidobodobo gifaisewana ada ivona, “Ida velemoena Banae Falofita-nai faine ivona gina obuelai babi wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ada ivonavona aku Yeisu gialamanena tova kabisona inaela ina kiveyabina ke ina luyayali-moe gina vekini. Tayuwe faine gisegedi ada anakaibe kaduwe giyewana oya-nai wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ada yana tonogalayavo nodi imiyamiya aku mala givelavilavi, ada iobu lavu wagaine ke Yeisu ina bodana. ");
INSERT INTO bwd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Aku au bademo mala gibogi aku Yeisu aimo keke gidayewa wagaidiya, e ada waka iyagena ada ivebutu ivoi ilaka idamadamana lavu wagaine melala-nai Kafaneumi faina, lavu fafaline. ");
INSERT INTO bwd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ada ivoi inaunau aku mala gilubibibi toyogina ada buli ivevuvu iveveoya. ");
INSERT INTO bwd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ada ivoi inau maita adiatuwada givaina anafaiweya kilomita faifi o sikisi, ada iitayewa ani iitana Yeisu lavu getane ginunudadana ginunuyegemona waka-nai wagaine, ada imatauta lakaina. ");
INSERT INTO bwd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aku Yeisu givona wagaidiya, givona, “Ida Iya Tauku. Keke wana matauta.” ");
INSERT INTO bwd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bonana inogalina ada nuwanuwadi ginayage. Ada giela giyage ani maduga-mowa waka ginuabina avala-nai faina inaunau. ");
INSERT INTO bwd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mala gilavuna badi yoo imiya lavu fafaline anataliya wagaine ani inuwanuwa ada ivona, “Boi waka seya-moena aitana, ada Yeisu keke gidayage yana tonogalayavo nodi aku adiloi gaga itauya ada inau. Aku bana gadedeku gina?” ");
INSERT INTO bwd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aku waka tufona melala-nai Taibeliya wagaine-deya iela iyalili fafali-nai lilivane wadedeku Kauveya beledi faine givona vesiule Yaubada wagaine ada giveledi yoo ikani. ");
INSERT INTO bwd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","E ada tova-nai yoo iitanuwagana Yeisu wa yana tonogalayavo nodi keke, ada iyage waka-dina wagaidiya ke idamana Kafaneumi ina lelena. ");
INSERT INTO bwd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Badi kaliva-dina inau lavu fafaline ke Yeisu inuwagana ada itolidadanena, ivona, “Labai, gavatova idedeku uela?” ");
INSERT INTO bwd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeisu gilufata, givona, “Vona velemoena, gavona wagaimiya, Iya waleleku ani keke iyaiyaya ebameyasidobodobo waitana faina, aku imi beledi wakani kamomi ifata faina. ");
INSERT INTO bwd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Keke babi ana aa faine wana vedivediwe, taine aa-nai gimadumadukoyo. Aku aiyada wana vediwe aa miyamiyani-vagaina faine, aa-nai wagaine yawai-vagata wana nuwagana. Taidei aa-nai Bana Kaliva Natuna gina velemi, faina Banae idogame-nai Tamana Yaubada giawaveiwakanena ke giseliyena yana gugai taidei faine.” ");
INSERT INTO bwd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ada badi itolidadanena, ivona, “Gavana adagai ayo gugai-dina Yaubada nuwanuwana ada gugaiye?” ");
INSERT INTO bwd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeisu gilufata, givona, “Gugai-nai Yaubada nuwanuwana ani taidei anafaiweya. Iya giimiliku ani wana vetumaganeku.” ");
INSERT INTO bwd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Badi ivona, “Gava iyaiyaya ebameyasidobodobo una gugaiye anaita ayo ana vetumagana? Gavana unagai? ");
INSERT INTO bwd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tamadeyavo nagona mana ikanikanina fafali kavovona wagaine. Anafaiweya Buki Tabu wagaine ivetokilumina, givona, ‘Aa wagabameya-deya giveledi inakani.’ E aku oye ani gavana unagai?” ");
INSERT INTO bwd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeisu givona wagaidiya, givona, “Vona velemoena gavona wagaimiya, aa gabameya-deya ani ida keke Mosese gida velemi, aku Kamaku Banae-nai aa velemoena gabameya-deya givelevelemi. ");
INSERT INTO bwd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Faina Yaubada yana aa ani Tauna Banae giobuelai gabameya-deya ada yawai giveleveledi tomiyababi.” ");
INSERT INTO bwd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Badi ivona, “Kauveya, tova moyaina aa taidei uda velevelema.” ");
INSERT INTO bwd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aku Yeisu givonedi, givona, “Iya Tau-moeku aa-nai ani yawai givelavelau. Banae gaito ginaelai wagaikuya ani keke-mowa aimo mafa ginalavu, ada banae gaito gina vetumaganeku, keke meyana gina kwakwa. ");
INSERT INTO bwd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aku anafaiweya bademowa gavonemi, Iya waitaku e aku aimo keke wada vetumagana. ");
INSERT INTO bwd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Gavega moyaidi Kamaku gina veleku ani inaelai ina vetonogala wagaikuya, ada badi gavega inaelai wagaikuya, keke-mowa gana wavidi. ");
INSERT INTO bwd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Faina Iya gaobuelai gabama wagaine keke Tauku yaku nuwanuwa gana gugai faina, aku Banae giimiliku ani yana nuwanuwa gana gugai. ");
INSERT INTO bwd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ada Banae-nai giimiliku ani yana nuwanuwa taidei anafaiweya. Gavega moyaidi giveleku ani gana kibababale-vagaidi e ada keke seyana gaito gana nusege ayo gina alika-vagata, aku tova anaebalauyabu wagaine alikeya gana siveyawadi. ");
INSERT INTO bwd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Faina Kamaku yana nuwanuwa taidei anafaiweya. Gavega moyaidi iitalaka Natuna wagaine ke ina vetumaganena ani yawai-vagata ina nuwagana, ada tova anaebalauyabu Iya Tauku alikeya gana siveyawadi.” ");
INSERT INTO bwd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aku Yeisu yana vona-nai givona, “Iya Tau-moeku aa-nai gabameya-deya gaobuelai.” Ani meIsileli inogalina wagaine ivebutu igavoluvoluyena, ");
INSERT INTO bwd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ivona, “Ida Yeisu-moena Tauna taidei, Iyosefa natuna. Inana ke tamana kaalamanedi. Gavaiyamu-yo malinai givona evona giobuelai gabama wagaine?” ");
INSERT INTO bwd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Aku Yeisu gilufata, givona, “Auwe, keke wana gavoluvolu. ");
INSERT INTO bwd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Keke seyana gaito anafata tauna yana nuwanuwa wagaine ginaela gina muliyeku, aku kai Kamaku Banae giimiliku ani aseasena gina onana ke nuwana gina kanina aga ginaela gina muliyeku. Ada ebalauyabu anayadayada-nai wagaine alikeya gana siveyawana. ");
INSERT INTO bwd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tova tuwaina falofita Aiseya givetokiluma, givona, ‘Badiyavo ani moyaidi Yaubada gina vewaledi.’ Gavega moyaidi Kamaku bonana inogalina ke alamana ivaina ani inaelai wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Keke seyana gaito Kamaku gidaita, keke. Aku Banae gielai Yaubada wagaine-deya ani Banae-nai giitana. ");
INSERT INTO bwd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Vona velemoena, gavona wagaimiya, banae gaito givetumaganeku ani yawai-vagata bademowa ginuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iyayeku ani aa-nai bana yawai givelavelau. ");
INSERT INTO bwd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tamamiyavo nagona mana ikanina fafali kavovona wagaine aku keke idamiya-vagata, au ialika. ");
INSERT INTO bwd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aku aa-nai Iya gaifufuyena ani gabameya giobuelai, e ada gavega ina kanina ani keke ina alika. ");
INSERT INTO bwd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iya aa wayawaina gabameya-deya giobuelai. Ina velemoena vovoku ani tomiyababi moyaidi gana veledi e ada yawai ina nuwagana Yaubada wagaine. Kai gaito seyana aa taidei gina kanina, ginamiya-vagata.” ");
INSERT INTO bwd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ada meIsileli yana vona ananuwanuwa faina ivebutu ivevonavona, ivona, “Gavaiyamu-yo kaliva taidei vidona gina veleda ada kanakani? Keke maita gida luboda!” ");
INSERT INTO bwd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeisu givona wagaidiya, givona, “Vona velemoena, gavona wagaimiya, kai keke Banae Kaliva Natuna vidona wadakani ada dayagina wadayui, kadu yawai-nai Yaubada wagaine-deya ani keke wagaimiya. Keke. ");
INSERT INTO bwd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Gavega vidoku ikanikanina ke dayagiku iyuyuna ani bademowa yawai-vagata ivaina, ada tova anaebalauyabu wagaine alikeya gana siveyawadi. ");
INSERT INTO bwd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Faina vidoku ani aa velemoena ada dayagiku ani bwai velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Gavega vidoku ikanikanina ada dayagiku iyuyuna ani badiyavo imiyamiya Iya wagaikuya ada Iya gamiyamiya badi wagaidiya. Au yawaima seyana. ");
INSERT INTO bwd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ide Tamada Banae giimiliku ani wayawaina. Ada Banae yawaiku vuvuna faina, Iya kadu wayawaiku. E ada kadu anafaiweya, banae kaliva-nai Iya wagaikuya gikanikani ani wayawaina gina miyamiya, faina yawaina givaivaina wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ida aa-nai gaifuifufuyena ani aa-nai gabameya-deya giobuelai. Keke anafaiweya mana-nai tamamiyavo nagona tova tuwai-moena wagaine ikanina aku ialika. Aku aa-nai gavonayena ani tulina. Banae gaito aa taidei wagaine gikanikani ani ginamiya-vagata.” ");
INSERT INTO bwd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Taidei anafaiweya Yeisu givona manuwa ebavewala wagaine, tova-nai givewavewala melala-nai Kafaneumi wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ada yana vewala taidei inogalina wagaine, yana tonogalayavo tufona moyaidi ivona, “Vewala taidei vita-moena. Keke tamo gaito gina nogali.” ");
INSERT INTO bwd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aku Yeisu gialamanena yana tonogalayavo igavoluvolu yana vewala faina, ada givona wagaidiya, givona, “Gavaiyamu, yaku vewala ani vita-moena wagaimiya e ada giivenuwanuwami vaita yami vetumagana wagaikuya wana segena? ");
INSERT INTO bwd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","E aku kai Banae Kaliva Natuna wada itaitana aku gidalaka fafali-nai nagona gimiyamiya wagaine aga gavaiyamu wada nuwanuwa? ");
INSERT INTO bwd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yawai-vagata ani gavaiyamu, kaliva-mowa wagaidiya? Keke-mowa. Kaliva yadi toyogina keke maita anafata. Yaubada Aluwaluwana anakaibe ani Banae-menai kaliva yawai giveleveledi. Ada yaku vona-dina gavonemi vuvudi ani Yaubada Aluwaluwana, ke yawaina. ");
INSERT INTO bwd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Aku tufomi ani keke wada vetumagana.” Taidei anafaiweya Yeisu givona faina yana faisewa anaebavevuvu wagaine bademowa gimadu alamanena gavega keke ida vetumagana velemoena wagaine. Ada kadu gimadu alamanena bana kaliva-nai gina atuegena nibainavo nimadiya. ");
INSERT INTO bwd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","E ada givona, “Taidei vuvuna-nai bademowa gavonemi, ‘Keke seyana gaito anafata tauna yana nuwanuwa wagaine ginaela wagaikuya, tainei-mowa kai Kamaku gina awaege gina muliyeku.’” ");
INSERT INTO bwd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yeisu yana ifufu giavaina, e ayo yana tonogalayavo nagona ikwayakwayabuna ani tufona moyaidi isegena ada keke kadu ida muliye. ");
INSERT INTO bwd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","E ada Yeisu tonogalayavo adituwelo gitolidadanedi, givona, “Aku imiyavo ani gavaiyamu, nuwanuwami kaduwe wananau, aiyo?” ");
INSERT INTO bwd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimoni-Pita gifatana, givonenaga, “Kauveya, gaito wagaine adana? Oye wagainiya ani vona-dina yawai-vagata ivelavelau. ");
INSERT INTO bwd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ada ime bade avetumaganeni ke aalamanena Oyeni ani Yaubada yana Kaliva Tabutabu. Ya nuwanuwa matatabuna ani yegayega-vagaidi.” ");
INSERT INTO bwd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeisu gilufata, givona, “Iya amituwelo gavenuwadadanemi, aku seyana wagaimiya ani Seitani yana kaliva.” ");
INSERT INTO bwd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","E, Yeisu givona Yudasa faine, tauna Saimoni Isakaliyota natuna, faina tova kabisona banae Yudasa-nai ani Yeisu gina ivemogatalina nibainavo wagaidiya. Banae adituwelo wagaidiya seyana. ");
INSERT INTO bwd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tayuwe tova-nai muline, Yeisu gina gibalawalilivuga Galili anafafali wagaine. Keke nuwanuwana gina balawalilivuga meIsileli aditonagonayavo yadi fafali Yudiya wagaine, faina badi wai ilelelena ke ina luvealikana. ");
INSERT INTO bwd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aku bademowa miyavagauta seyana lakaina givelilivana meIsileli faidiya, anayegana ‘Manuwa Sinininila Anamiya Abutuna’, ");
INSERT INTO bwd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","e ada Yeisu tainavo ivonena, ivona, “Fafali taidei uda segena aku udanau Yudiya wagaine, e ada kaduwe badi ya tonogalayavo wadedeku-deya ina itana ya gugai ebameyasidobo ugugugaiyedi. ");
INSERT INTO bwd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Faina kai kaliva nuwanuwana valeyana gina iveakwalelegina e ada moyaidi ina alamanena aga keke ikavuya wagaine gida faifaisewa. Gaitoma taidei ufaifaisewadi, e ada Tauni babi anakalivayavo matadiya una vewaleni.” ");
INSERT INTO bwd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Taidei anafaiweya ivona faina badi tainavo nonogana keke ida vetumagana wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","E ada Yeisu givonedi, “Tova akulauboda ani aimo keke gida yegemona, aku imi faimiya gavatova nuwanuwami ani wada amilauboda. ");
INSERT INTO bwd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Babi anakalivayavo keke adifaiweya imi ina agougemi aku Iyayeku iagougeku, faina gaawaawamogatalena yadi dewa ani koyona. ");
INSERT INTO bwd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Imi wananau abutu wagaine. Iya yaku tova aimo keke gida yegemo e ada keke ganana.” ");
INSERT INTO bwd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Taidei anafaiweya givonedi ada gimiyayewa Galili. ");
INSERT INTO bwd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","E aku tainavo nagona itauya ilaka abutu faina, ada muliya banae kadu ginau. Aku yanana wagaine keke yoo matadiya aku ikavuya-deya ginau. ");
INSERT INTO bwd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aku wadedeku abutu wagaine meIsileli aditonagonayavo Yeisu iitaitalelena ada itolitolidadana, “Kaliva-nai gadedeku?” ");
INSERT INTO bwd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ada yoo taudiyavo wagaidiya igavoluvolu Bana Yeisu faine. Tufodi ivonavona, “Banae kaliva iwakana,” aku tufodi ivonavona, “Keke. Banae kaliva gifwayamikamikadi.” ");
INSERT INTO bwd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aku keke seyana gaito gida vonayegemona kaliva matadiya, faina meIsileli aditonagonayavo imatausedi. ");
INSERT INTO bwd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aku abutu anagugai bademowa nefanine iveluinainafa ani Yeisu gilaka manuwa tabu wagaine ada givebutu kaliva givewavewaledi. ");
INSERT INTO bwd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ada badi meIsileli aditonagonayavo inogalina ke meyadi gibovu ada ivona, “Taumada! Kaliva taidei ani gavaiyamu? Keke tamo labai gida vewale Mosese yana veimeya wagaine aku gavaiyamu giga ada taide alamana lakaina givai?” ");
INSERT INTO bwd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeisu gilufata, givona, “Yaku vewala taidei keke Tauku wagaikuya aku Banae giimiliku ani Tauna wagaine gielai. ");
INSERT INTO bwd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kai gaito nuwanuwana Yaubada yana nuwanuwa gina gugaiyena aga gina itanuwagana kai Iya yaku vewala gielai Yaubada wagaine-deya o kai Tauku wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Badi gavega ina ifuifufu taudiyavo yadi nuwanuwa wagaidiya-deya, aga au nuwanuwadi taudiyavo adiyegana anakilakata. Aku banae-nai nuwanuwana Banae giimilina gina kilakaina ani keke tamo fwaya anawai bana wagaine, au banae ani vona velemoena anakaliva. ");
INSERT INTO bwd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yaubada yana veimeya Mosese givelemi ani wana nuwenuwena. Keke tamo gaito wagaimiya veimeya-nai gida itaveyabi matatabuna, e aku gavaiyamu-yo wavona vaita Iya Sabate anaveimeya keke gada kikiveyabi e ada wabalabalalava wana luvealikaku?” ");
INSERT INTO bwd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ada yoo ilufata, ivona, “Oyeni ani aluwaluwa bwanebwanenena nafoniya gimiyamiya, faina uvonavona anafaiweya kabakabaleya. Gaito gibalabalalava ke gina luvealikani?” ");
INSERT INTO bwd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeisu givona wagaidiya, givona, “Gugai seya-moena ebameyasidobo gafaisewana Sabate wagaine ada imi moyaimi meyami gisidobodobona. ");
INSERT INTO bwd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Aku imi kadu wafaisewa Sabate tova-nai tomogolota kaliva wavelena anafaiweya Mosese veimeya givelemi. Aku velemoena, giduwa-nai ani keke Mosese gida vevuvu aku tamadeyavo nagona ivevuvuna. Aku Mosese au veimeya gaga gifaisewana faine. ");
INSERT INTO bwd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ada imi nuwanuwami yana veimeya-nai wana muliyena e ada aimo natumiyavo watomotomogoloidi. Aku kai bebeta kaliva anayadayada eita Sabate wagaine gina lunuwagana, au Sabate nonogana vovona wana tomogoloina e ada keke veimeya-nai wana yaweli. Aku kai imi taumiyavo gugai-nai wana gugaiyena Sabate wagaine, gavaiyamu-yo Iya wagaikuya wanuwakoyo faina Sabate wagaine gagugai iwakana ke kaliva vovona gakivebwaini-yabuna? ");
INSERT INTO bwd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gavana wanamadu itanuwagana wagaine ani keke anaita wagaine wadaita venuvenuwadadana, keke. Keke wanamadu, aku alamana faine wadalele-dewedewena e ada wana alamanena velemoena, e ayo wa yami alamana velemoena wagaine wanaita venuvenuwadadana tunutunugina.” ");
INSERT INTO bwd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tayuwe nuwanuwa-nai wagaine ada meYelusalema tufodi ivetolitoli, ivonaga, “Gavaiyamu, taide kaliva-nadi badi tonagonayavo nuwanuwadi ina mununa kai keke? ");
INSERT INTO bwd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aku waitana, tauna taidei giifuifufu yoo matadiya aku keke tamo vona seyana tonagona-dina ida vonaye wagaine! Kai badi ivetumagana vaita Banae Mesaiya? ");
INSERT INTO bwd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aku taidei kaliva-nai ani kaalamanena gadedeku-deya giela, aku aimo tova-nai Mesaiya gina yegemona aga keke seyana gaito gina alamane gadedeku wagaine giela.” ");
INSERT INTO bwd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ada aimo Yeisu givewavewala manuwa tabu anafafali wagaine aku meYelusalema-dina yadi vona ginogalina, ada au givona bonana lakaina wagaine, givonaga, “Imi wavona vaita Iya waalamaneku ada waalamanena gadedeku-deya gaela. Aku Iya keke Tauku yaku nuwenuweya gadaela, keke. Aku Banae-nai giimiliku ani yana dewa ke yana vona ani velemoena gaga. Aku Banae keke wada alamane. ");
INSERT INTO bwd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aku Iya gaalamanena faina Iya nodi amiya ada giimiliku gaelai.” ");
INSERT INTO bwd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Taidei anafaiweya Yeisu givona faina, badi tonagona ibalalava vaita ina kiveyabina aku keke seyana gaito nimana gidatune, faina yana tova aimo keke gida yegemo. ");
INSERT INTO bwd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aku kaliva tufona moyaidi yoo wagaidiya ani ivetumagana wagaine, ivona, “Tova-nai Mesaiya ginaelai aga keke iyaiyaya ebameyasidobodobo moyaina gina faisewadi ayo muliya kaliva taidei Yeisu, keke.” ");
INSERT INTO bwd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aku Falisiyavo inogalina yoo yoo ivebonamumu vaita Yeisu Banae Keliso, e ada badiyavo ke Yaubada yana veyavo anatovegugai lakaidiyavo ani manuwa tabu anafilisimaniyavo iimilidi ke Yeisu ina kiveyabina. ");
INSERT INTO bwd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ada Yeisu givona, “Aimo tova maufo-moena Iya imi nodi kana miyamiya aku gananau Banae giimiliku wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ada aimo wana leleku aku keke wana nuwagaku, faina gadedeku gana miyamiya ani imi keke amifata wanaela.” ");
INSERT INTO bwd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","MeIsileli aditonagonayavo taudiyavo iveifuifufu, ivona, “Gadedeku kaliva taidei ginana e ada ide keke adafata kana nuwaga? Kai yada yoo iawala inau meGiliki yadi fafaliya ani wagaidiya ginana badi gina vewaledi, kai keke? ");
INSERT INTO bwd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Gavana anaalamana faine ada givona, ‘Aimo wana leleku aku keke wana nuwagaku, faina gadedeku gana miyamiya ani imi keke amifata wanaela’?” ");
INSERT INTO bwd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aku Abutu-nai anaebalauyabu giyegemona, taine anayadayada-nai anatova lakaina, ada Yeisu gimididi yoo nefanidiya ada bonana lakaina wagaine givona, “Gavakaliva meyana gikwakwa ani gidaela wagaikuya ke gufa gidayuga. ");
INSERT INTO bwd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Gaito givetumagana wagaikuya ani aseasene-deya gufa tovoga wayawaina ginamadu. Taidei anafaiweya Buki Tabu givona.” ");
INSERT INTO bwd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Taidei yana vona ani Aluwaluwa Tabuna faine, Banae-nai gavega ivetumagana Yeisu wagaine ina nuwagana. Aku tayuwe tova-nai wagaine aimo keke Yeisu Aluwaluwa Tabuna gida velavela, faina aimo keke gida alika ke gidalaka gabameya gida miyami wa yana iwakana mamalina. ");
INSERT INTO bwd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tova-nai yana vona inogalina wagaine ada kaliva tufodi ivonaga, “Vona velemoena kaliva taidei tauna Falofita-nai tova tuwai-moena Yaubada givonadabadabayena ginaelai.” ");
INSERT INTO bwd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aku tufodi ivona, “Banae au Keliso.” Aku kaliva tufodi ani itolidadana, ivona, “Gavaiyamu-yo Keliso ginaela Galili wagaine-deya? ");
INSERT INTO bwd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Faina Buki Tabu givona vaita Keliso gina yegemona bana Deivida yana tubudelideli wagaine, ada gina tubuga melala-nai Bedeliema wagaine, wada Deivida yana melala.” ");
INSERT INTO bwd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ada au kaliva igavekwavekwageya ada iludakadakadi yadi nuwanuwa tulina tulina Yeisu faina. ");
INSERT INTO bwd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tufodi nuwanuwadi ina kiveyabina, aku keke seyana gaito nimana gidatune wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","E ada badi manuwa tabu anafilisimaniyavo iyewadi inau veyavo anatovegugai lakaidiyavo ke Falisiyavo wagaidiya, biyavo-dina badi iimilidi Yeisu ina kiveyabina. Ada iyegemo au badi itolidadanedi, ivona, “Gavana faina keke wada aliye?” ");
INSERT INTO bwd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Filisimaniyavo ilufata, ivona, “Tuwaina-moena ada analaba malinai, keke tamo gavakaliva yana vona anafaiweya kaliva taidei!” ");
INSERT INTO bwd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ada Falisiyavo ivona toyavagayavo wagaidiya, ivonaga, “Gavaiyamu, kadu imi nodi yana fwaya nuwami givaina, aiyo? ");
INSERT INTO bwd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wana nuwenuwena, tonagonayavo ke ime Falisiyavo nodi ani gavaiyamu? Tamo gaito wagaimeya yana ifufu givetuvetumaganena? Keke tamo. ");
INSERT INTO bwd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aku yoo taidei Bana yana vona ivenovenogalena ani keke maita Mosese yana veimeya ida alamane. Alatabutabu dibune imiyamiya!” ");
INSERT INTO bwd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Taide anafaiweya Falisiyavo ivona aku seyana adiyoo wagaine anayegana Nikodimo, bana seyana tova ginau Yeisu wagaine ani banae tubuiyanavo gitolidadanedi, givona, ");
INSERT INTO bwd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Aku ide keke kada nogala gavana givone. Ide meIsileli adaveimeya ani gavaiyamu, giawaegeda ke seyana gaito kanavona venuvenuwadadane ke kana awavekoyoyena muliya-yo kana vevonayavugina ke kana alamanena gavana gafaifaisewa, aiyo?” ");
INSERT INTO bwd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Badi ilufata, ivona, “Aaaa, o uvonavona anafaiweya e ani gavaiyamu, oye kadu kwana Galili? Una lelena Buki Tabu wagaine ada una nuwagana ani keke meyameyaganina ke tamo falofita gida yegemo Galili wagaine-deya, keke-mowa.”  ");
INSERT INTO bwd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ada moyaidi itauya inau tauna tauna yana manuweya. ");
INSERT INTO bwd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ada moyaidi inau aku Yeisu ginau Oya Olive wagaine gilaka. ");
INSERT INTO bwd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aku malalavuga gienoobu ada giyegemona-vagila manuwa tabu wagaine. Ada wadedeku kaliva moyaidi ivagauta Yeisu imiyafifina, ada givetogana ke givewaledi. ");
INSERT INTO bwd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ada givewavewaledi aku badi Mosese yana veimeya anatovewalayavo ke Falisiyavo ani vavine udoudodi ikiveyabidi ialiyedi Banae wagaine, badi kaliva seyana nodi idaudau aku inuwagadi. Ada iveimeyedi imididi yoo matadiya ");
INSERT INTO bwd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aku ivona Yeisu wagaine, ivonaga, “Tovewala, vavine taidei anuwagana mali kaliva nodi iudoudo. ");
INSERT INTO bwd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aku Mosese yana veimeya wagaine giveimeya vevine toudo taidei anafaiweya ani kana tutuvealikadi kabala wagaine. E aku Oyeni ani gavaiyamu udavona?” ");
INSERT INTO bwd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tolidadana taidei ifaisewana e ada yana laufata wagaine meyameyaganina vuvu inavai ina awavekoyoyena tovevonayavuga wagaine. Aku Yeisu giiboula ada babi wagaine givetovetokiluma nimadidina wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ada givetovetokiluma aku badi ikwageye-moe itolimamailena, ada bana gialakaina ke givonedi, givonaga, “Kai wagaimiya kaliva seyana keke tamo gida koyona, aga banae nagona kabala wagaine vavine-dina gina madufiyadi.” ");
INSERT INTO bwd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ada kadu giodu-vagila babi wagaine givetokiluma. ");
INSERT INTO bwd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ada au yana vona inogalina ada anakaibe anakaibe itauya inau, lakaidiyavo imadutauya aku kabisodiyavo wai imulina. Ada moyaidi inu-yabu aku au Yeisu anakaibe gitufo, ada vavine adikaibe-mowa ani Yeisu wadebaine imidimididi. ");
INSERT INTO bwd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ada Yeisu gialakaina ada gitolidadanedi, givona, “Vavine, aku gadedeku badiyavo? Gavaiyamu, keke seyana gaito gida awavekoyoyemi?” ");
INSERT INTO bwd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Badi vavine ivona, “Kauveya, keke tamo.” Ada Yeisu givona, “Iya kadu keke gana awavekoyoyemi. Auwe wananau, aku tova taidei ke gina naunau ani yami dewa koyona wanasege-vagaina.” ");
INSERT INTO bwd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ada kaduwe Yeisu givona kaliva-dina manuwa tabu wagaine, givona, “Iyayeku tomiyababi yadi malina. Gavakaliva gina muliyeku ani keke aimo yuyuvana wagaine gina nunudadana aku gina miyamiya malina-nai yawai givelevelau wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Falisiyavo ivona wagaine, ivona, “Oyeni Tauni fainiya uawatalatalaina e ada ya awatalatalaina keke vona velemoena.” ");
INSERT INTO bwd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aku Yeisu gilufata, givona, “Iya Tauku faikuya gaawatalatalaina nonogana yaku awatalatalaina ani vona velemoena, faina gaalamanena gadedeku wagaine gaela ke kaduwe gadedeku ganauna. Aku imiyavo ani keke tamo yami alamana gadedeku wagaine Iya gaela o kai gadedeku ganauna. ");
INSERT INTO bwd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Imi keke kaliva wada itavenuwadadane-dewedewedi, faina kaliva-mowa yana venuwadadana wamulimuliyena. Aku Iya keke anafaiweya gada gugai. ");
INSERT INTO bwd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aku kai Iya kaliva ganavona venuvenuwadadanedi aga yaku venuwadadana tunutunugina, faina Iya keke akukaibe-mowa gadavona venuvenuwadadana aku Kamaku nodi agugaiyena, Banae giimiliku. ");
INSERT INTO bwd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kaduwe yami Veimeya anabuki wagaine ivetokilumina, givona, ‘Kai tamo gavana giyegemona e ada kaliva adiselu ina awatalatalainena seyana, aga badi yadi ifufu ani vona velemoena.’ ");
INSERT INTO bwd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Iya idogamekuna gaawatalatalaina Tauku faikuya, ada kaduwe Kamaku giimiliku giawatalatalaina faikuya. E ada ina amaiselu yama awatalatalaina ani vona velemoena.” ");
INSERT INTO bwd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aku badi itolidadanena, ivona, “Gadedeku Tama?” Yeisu gilufata, givona, “Iya keke wada alamaneku, kaduwe Kamaku keke wada alamane. Kai wada alamaneku aga kaduwe Kamaku wada alamanena.” ");
INSERT INTO bwd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Taidei anafaiweya givewavewala aku gimidimididi ebavelekavovo anafafaliya, tainei manuwa tabu wagaine. E aku keke seyana gaito gida kiveyabi, faina yana tova aimo keke gida yegemo. ");
INSERT INTO bwd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kaduwe Yeisu givona wagaidiya, givona, “Iya gana segemi gananau, ada imi wana leleku aku wana lele-wayoga, ada wa yami koyona wana miyamiya aku wana alika. Ada fafali-nai wagaine ganaunau ani imi keke amifata wanaela.” ");
INSERT INTO bwd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Taidei wagaine meIsileli taudiyavo gaga wagaidiya ivetolitoli, ivona, “Gavaiyamu-yo givona, ‘Fafali-nai wagaine ganaunau ani imi keke amifata wanaela wagaine’? Kai ananuwanuwa ani Tauna gina luvealikana?” ");
INSERT INTO bwd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aku Bana Yeisu givonedi, givonaga, “Imiyavo ani babi taidei wagaine wayegemona aku Iyayeku gabameya gamiyamiya ani gaobuelai. ");
INSERT INTO bwd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bademowa gavonemi ani yami koyona nodi wana miyamiya aku wana alika. Faina kai keke wana vetumagana vaita IYA TAUKU GAMIYAMIYA, aga velemoena wa yami koyona wana alika.” ");
INSERT INTO bwd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Badi itolidadana, ivona, “O gaito velemoena?” Yeisu gilufata, givona, “Tuwaina-deya au gaifuifufuyena Iya gaito. ");
INSERT INTO bwd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gaitoma moyaina faidiya akufaiweya ganavona venuvenuwadadana yami koyona faine ke gana veimeya amimatavuloga faine. Aku Banae giimiliku ani velemoena, ada gavana ganogalina Bana wagaine, taide gaga gana awatalatalainena babi anakalivayavo wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Taidei anafaiweya Yeisu givona aku badi yana nuwanuwa ibavuyena. Keke ida alamane Tamana Yaubada faine givonevonedi. ");
INSERT INTO bwd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","E ada Yeisu givonedi, givona, “Aimo Banae Kaliva Natuna wana silakaina, ada tova-nai wagaine wana alamanena vaita ‘IYA TAUKU GAMIYAMIYA’. Ada kaduwe wana alamanena vaita keke tamo gavana gada gugai Tauku yaku nuwenuweya aku gavana Kamaku givewaleku ani anafaiweya gaifuifufuyena. ");
INSERT INTO bwd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ada Banae giimiliku ani Tauna Banae Iya nodi amiyamiya. Keke gida segeku akukaibe-mowa gada miyami, faina tova moyaina gavana gikivemwamwalina ani anafaiweya gagugai.” ");
INSERT INTO bwd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ada taidei yana vewala giifuifufu yoo wagaidiya aku tufona moyaidi ivebutu ivetumaganena. ");
INSERT INTO bwd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Badi meIsileli gavega ivetumagana Yeisu wagaine ani givona wagaidiya, givona, “Kai tova moyaina yaku vewala wana mulimuliyena ke wana miyamiya wagaine aga imiyavo velemoena yaku tonogalayavo. ");
INSERT INTO bwd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ada Yaubada yana vona velemoena ani wana alamanena ada vona velemoena gina etoyavumi e ada yavuyavumiyavo wana miyamiya.” ");
INSERT INTO bwd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aku badi ilufata, ivona, “Ime Ebelaamo yana tubudelideliyavo ada keke tamo gaito wagaine ada vetogugai yogoyogona. E ada gavaiyamu-yo uvona evona ime gina etoyavuma ke yavuyavumeyavo ana miyamiya?” ");
INSERT INTO bwd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeisu gilufata, givona, “Vona velemoena, gavona wagaimiya, gavega ikoyokoyona ani badiyavo koyona wagaine ivetogugai yogoyogona. Faina koyona-nai gikikiveyabidi e ada keke adifata inana. ");
INSERT INTO bwd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ada kaalamanena togugai yogoyogona keke gida miyamiya-vagata yana kauveya yana manuweya, aku kauveya-nai tauna natuna velemoena ani tamana yana manuweya ginamiya-vagata. ");
INSERT INTO bwd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","E ada kai Iya Kaliva Natuna gana etoyavumi aga keke aimo koyona yana veimeya dibune wana miyami aku velemoena yavuyavumiyavo. ");
INSERT INTO bwd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Gaalamanena imi Ebelaamo yana tubudelideliyavo, e aku wai walelele ke wana luvealikaku, faina aseasemi wagaidiya keke tamo mwatugu gida miyami yaku vona faine. ");
INSERT INTO bwd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Gaitoma-dina Kamaku bade givewaleku ani gaifuifufuyedi, aku imi kadu anafaiweya, gaitoma-dina tamami wagaine wanogalina, tainei wagugugaiyedi.” ");
INSERT INTO bwd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Badi ilufata, ivona, “Ime tamama ani Ebelaamo.” Yeisu givonaga, “Kai velemoena imi Ebelaamo natunavo aga wada vaina Ebelaamo nimana, aku keke wadavai. ");
INSERT INTO bwd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Iya Yaubada matane yana vona velemoena ganogalina ani bade gaifufuyena wagaimiya, e aku wabalabalalava wana luvealikaku. Aku Ebelaamo keke tamo gidadewa anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Imi tama-moemi yana dewa anafaiweya wadewadewa.” Badi ivona, “Ime keke eda natunavo. Ime Tamama anakaibe-mowa Tauna Yaubada.” ");
INSERT INTO bwd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeisu givona wagaidiya, givona, “Kai velemoena Banae Yaubada imi Tamami, aga Iya wada nuwakabubuyeku, faina Iya gamiyamiya Yaubada nodi aku gaelai ada imi nodi idedeku kamiyamiya. Iya keke gadaela Tauku yaku nuwenuweya aku Banae giimiliku. ");
INSERT INTO bwd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Gavaiyamu-yo yaku vona keke gida mamali wagaimiya? Faina imi keke amifata wana nogali gavana gavonevone. ");
INSERT INTO bwd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Imiyavo ani tamami au Seitani, ada nuwanuwami tamami yana nuwanuwa wana dewadewayena. Ebavevuvu wagaine-deya banae toluvealika. Banae yana nuwanuwa matatabuna ani vefwayafwaya e ada keke maita tauna gida awaege vona velemoena wagaine. Banae tofwaya, ada au fwaya matatabuna ani banae anatomaduvevuvu. E ada tova-nai gifwayafwaya, au tauna yana veuluva velemoena wagaine yana dewa-nai giyegeyegemona. ");
INSERT INTO bwd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aku Iyayeku ani yaku vona velemoena faina, keke wada vetumaganeku. ");
INSERT INTO bwd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Keke tamo gaito wagaimiya gida itaku gadewadewa koyona e ada gina seyegemone vaita Iya gakoyona, keke. Iya gavonavona velemoena, e aku gavaiyamu-yo keke wada vetumagane? ");
INSERT INTO bwd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Badi gavega Yaubada natunavo ani Bana bonana ivenovenogalena. Aku imiyavo ani keke Yaubada natunavo, e ada bonana keke wada venovenogale.” ");
INSERT INTO bwd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","MeIsileli ilufata, ivonenaga, “Velemoena avona tunutunugina, Oyeni ani kwana Sameliya, ada kaduwe Oyeni ani aluwaluwa bwanebwanenena nafoniya gimiyamiya.” ");
INSERT INTO bwd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeisu givonaga, “Iya keke aluwaluwa bwanebwanenena wagaikuya aku aiyada Iya Kamaku anayegana gakikilakaina. E aku imiyavo ani Iya akuyegana wakiobuyena. ");
INSERT INTO bwd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iya keke Tauku gada kilakaiku kaliva matadiya ke ina davadavaku, keke. Aku seyana gimiyamiya ani Banae nuwanuwana gina kilakaiku e ada kaliva ina davadavaku. Ada Banae-menai Tovevonayavuga. ");
INSERT INTO bwd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gavonemi velemoena, gaito kai yaku vona gina itaveyabidi aga keke tamo tova alika gina lutovoni, au keke-mowa.” ");
INSERT INTO bwd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ada meIsileli inogalina ada itataweyana, imaduvona-mowa, ivonaga, “Au, aalamane-moena aluwaluwa bwanebwanenena nafoniya gimiyamiya! Ebelaamo gialika ada kaduwe Yaubada yana falofitayavo ialika, e aku Oyeni uvona vaita gaito kai ya vona gina itaveyabidi aga keke tamo tova alika gina lutovoni. ");
INSERT INTO bwd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gavaiyamu, o matalakai ayo muliya tamama Ebelaamo? Banae gialika ada falofitayavo kaduwe. Aiyo! Aku O vaita gaito?” ");
INSERT INTO bwd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Bana Yeisu gilufata, givona, “Kai Iya Tauku gana kilakaiku aga yaku gakaikai keke tamo wa anaiwakana, e aku Banae-nai gikikilakaiku ani Kamaku. Banae faine wavona, ‘Bana yama Yaubada,’ ");
INSERT INTO bwd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","aku Banae ani keke maita wada alamane. Aku Iya gaalamanena velemoena. Kai gadavona, ‘Iya keke gada alamane,’ aga Iya gada vetovefwayafwaya anafaiweya imiyavo. Aku Banae gaalamanena, ada yana vona gaitaveyabina. ");
INSERT INTO bwd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tamami nagona Ebelaamo ani tuwai-moena gimadu alamanena Iya yaku obuela babiya faina, e ada wa yana vemwamwala ginuwanuwa tova-nai wagaine. Ada giitana ke givemwamwala lakaina.” ");
INSERT INTO bwd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","MeIsileli ivona wagaine, ivona, “Oyeni keke kaliva lakai ayo amalamala gidalaka fifiti (50) aku uvona vaita Ebelaamo uitana!” ");
INSERT INTO bwd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeisu gilufata, givona, “Vona velemoena, gavona wagaimiya, bana Ebelaamo aimo keke gida tubuga aku bademowa IYA TAUKU GAMIYAMIYA.” ");
INSERT INTO bwd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ada badi yana vona inogalina ada inuwakoyo lakaina, e ada kabala iyaudi ina ifiyafiyana aku Yeisu Tauna gisewavuyena ada adimwatuguya-deya giamwakuna ada ginau ke manuwa tabu anafafali gisegena. ");
INSERT INTO bwd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ada Yeisu ginaunau aku giitana kaliva seyana anatubukwamana wagaine ani matana koyo-moena. ");
INSERT INTO bwd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ada yana tonogalayavo itolidadanena, ivona, “Labai, gaito yana koyona e ada kaliva taidei gitubuga ada matana koyo-moena? Tauna yana koyona o inana tamana?” ");
INSERT INTO bwd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeisu givona, “Keke kaliva taidei yana koyona o kai inana tamana yadi koyona faina, aku taidei vita-nai giyegemona e ada Yaubada yana gugai ke yana toyogina gina seyegemonena bana yawaina wagaine, e ada moyaida kana itana. ");
INSERT INTO bwd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gilubodana Banae giimiliku ani yana gugai kana gugugaiyedi aimo yadayada anatoveya-deya. Tova kabisona bogi gina yegemo, ada tova-nai wagaine keke seyana gaito anafata gina gugai. ");
INSERT INTO bwd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Aku Iya aimo babiya gamiyamiya wagaine, Iyayeku tomiyababi yadi malina.” ");
INSERT INTO bwd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Taidei anafaiweya givona ada gikiwala babi wagaine ke kiwala wagaine babi gigai givetofula. Ada tofula-nai givaina ada giluababana kaliva matana wagaine ");
INSERT INTO bwd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aku givonenaga, “Unanau gufa bwanibwaniuna Sailomu wagaine mata una koladi.” E, ‘Sailomu’ anakivila ani ‘imila’. Ada kaliva-nai gilovoga ginau matana gikolana ada giyewana matana giita. ");
INSERT INTO bwd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aku badi imiyamiya banae yana manuwa lilivane ke badi gavega tova moyaina iitaitana giawaveoveola ani itolidadana ivona, “Gavaiyamu, anaita ida kaliva-nai ani banae tuwaina-deya givetovetoga ke giawaveoveola?” ");
INSERT INTO bwd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ada kaliva tufodi ivona, “Ika, au banae kaliva-nai!” Aku tufodi ivona, “Keke, aku anaita au bana anafaiweya.” Aku bana tauna giawafatafata givona, “Iya kaliva-moeku tauku.” ");
INSERT INTO bwd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Badi ivonena, “Ada gavaiyamu-yo mata giabwa uitaita?” ");
INSERT INTO bwd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Banae gilufata givona, “Kaliva seyana ivewagana Yeisu, Bana babi gigai givetofula ada giluababana mataku wagaine. Ada givoneku, givona, ‘Unanau Sailomu mata una koladi.’ E ada gana gakoladi ada akufata ganaita.” ");
INSERT INTO bwd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Badi itolidadanena ivona, “Banae gadedeku?” Bana givona, “Kaiwa, keke gada alamane.” ");
INSERT INTO bwd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aku bana tomatakoyo-nai bade giveiwaka ani inauwena Falisiyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aku yadayada-nai Yeisu babi gigai givetofula ke kaliva matana gigai giabwana ani Sabate wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tayuwe faina Falisiyavo kadu itolidadanena kaliva gavaiyamu ada giitaita iwakana. Bana gilufata givona, “Tofula matakuya gisena ada gakoladi ada au malinai gaitaita.” ");
INSERT INTO bwd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ada Falisiyavo tufodi ivonaga, “Taide bana kaliva-nai keke gidaela Yaubada wagaine-deya, faina Sabate anaveimeya keke gida itaveyabi.” Aku tufodi itolidadana, ivonaga, “Gavaiyamu, tokoyona anafata iyaiyaya-dina ebameyabovu anafaiweya gina gugaiyedi?” E ada yadi nuwanuwa tulina tulina wagaine au taudiyavo iludakadakadi. ");
INSERT INTO bwd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","E ada Falisiyavo imiyaviladi ada bana tomatakoyo bade giveiwaka itolidadane-vagilena, ivonenaga, “Tauna bana mata gigai gialeleleye uita ani gavana udavona kaliva-nai faine?” Kaliva gilufata givona, “Banae falofita.” ");
INSERT INTO bwd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aku badi meIsileli aditonagonayavo keke ida vetumagana vaita banae anatubukwamana wagaine matana koyo-moena ayo gida veiwaka ke gida itaita, ada tayuwe faina matawa iimilina kaliva-nai inana ke tamana inaelai. ");
INSERT INTO bwd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ada badi ielai ke itoliyedi, ivona, “Velemoena taidei banae natumi, ada wavona evona banae anatubukwamana matana koyo-moena? Kai taine velemoena aga gavaiyamu-yo malinai giitaita?” ");
INSERT INTO bwd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kaliva inana ke tamana ilufata ivonaga, “Ime aalamane-moena ani banae natuma, ada gitubuga wagaine matana koyo-moena. ");
INSERT INTO bwd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Aku gavaiyamu-yo malinai giitaita o gaito gigai matana giabwa, ime keke ada alamane. Tauna wana tolidadanena. Banae matalakaina, ada tauna faine gina ifufu.” ");
INSERT INTO bwd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Inana ke tamana meIsileli aditonagona imatausedi ada taidei faina anafaiweya ivona. Faina tonagona-dina bademowa iveimeya, kai gaito gina awatalatalaina evona Yeisu Banae au Mesaiya, aga banae kaliva-nai ina veyegemoni-vagaina manuwa ebavewala wagaine e ada keke wa anaawaega kadu gina lukuluku wagaine gina tafatafalolo. ");
INSERT INTO bwd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Taidei faina kaliva inana ke tamana ivona, “Banae matalakaina. Tauna wana toliyena.” ");
INSERT INTO bwd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","E ada tova anavelu tomatakoyo bade giveiwaka ani tonagona idouwe gielai, ada ivonena, ivona, “Una vonadabadaba Yaubada matane ada unavona tunutunugina. Faina ime aalamane-moena kaliva taidei ani tokoyona.” ");
INSERT INTO bwd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Banae gilufata givona, “Iya keke gada alamane kai banae tokoyona o kai keke. Aku gaitoma seyana gaalamanena ani Iya nagona mataku gikoyo-vagata, aku malinai mataku giitaita.” ");
INSERT INTO bwd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ada kaduwe itolidadane-vagilena, ivona, “Gavana gigai wagainiya? Mata gavaiyamu giga ayo giabwa?” ");
INSERT INTO bwd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Banae gilufata givonaga, “Bademowa gavonemi aku keke yaku vona wadavai. E ada gavana faina kadu wana nogali-vagile? Gavaiyamu, imi kaduwe nuwanuwami wana vetonogala Bana wagaine?” ");
INSERT INTO bwd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ada au ifainena, ivonaga, “Oyeni taidei kaliva-nai yana tonogala, aku imeyavo ani Mosese yana tonogalayavo! ");
INSERT INTO bwd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Imeyavo aalamanena vaita Yaubada giifufu Mosese wagaine, aku kaliva taidei ani keke-mowa ada alamane gadedeku wagaine giela.” ");
INSERT INTO bwd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aku kaliva-nai gilufata givona, “Taumada! Meyaku gisidobodobona! Imi keke wada alamane yana ela faina, e aku Banae ani mataku gigai giabwana. ");
INSERT INTO bwd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ide kaalamanena Yaubada keke tokoyona yadi veola gida venogaledi, aku gavega ivemoimoinena velemoena ada bonana imatawalewaleyena ani badi yadi veola ginogalina. ");
INSERT INTO bwd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tova anaebavevuvu vaguvagu wagaine ada gielai malinai ani keke tamo gaito valeyana kada nogali anafaiweya kaliva gitubuga matana koyo-moena aku tamo gaito gidagai ke gidaabwa. ");
INSERT INTO bwd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kai kaliva-nai taidei keke gidaela Yaubada wagaine-deya, aga keke anafata gugai taidei anafaiweya gina gugaiye.” ");
INSERT INTO bwd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Badi ilufata, ivonenaga, “Oyeni koyoneya utubuga! Oyeni tokoyona nonogana ugaluvaluva vaita una vewalema, aiyo!” Ada iveyegemonina manuwa ebavewala wagaine-deya. ");
INSERT INTO bwd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeisu valeyana ginogalina vaita badi iveyegemoni-vagaina, ada ginau gilele ginuwagana ke givonena, “Gavaiyamu, Bana Kaliva Natuna wagaine uvetumagana o keke?” ");
INSERT INTO bwd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bana kaliva gitolidadana, givona, “Kauveya, gaito Banae? Una voneku ke akufaiweya gana vetumagana wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeisu givonaga, “Bade uitana, ada Iya nodi kaifuifufu ani kaliva-kuna.” ");
INSERT INTO bwd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ada kaliva-nai givona, “Kauveya, Iya gavetumagana.” Ada au tugana givetodonena ke gioduodu wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ada Yeisu givona, “Iya gaobuelai babiya ke kaliva yadi nuwanuwa aseasediya ganavona venuwadadanedi. E ada badi gavega matadi koyona ani inaita, ada badi gavega inuwanuwa vaita matadi giitaita ani ina vematakoyo.” ");
INSERT INTO bwd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ada Falisiyavo tufodi Yeisu nodi ani yana vona inogalina ada au itolidadana, ivona, “Gavaiyamu, o uvonavona vaita ime kadu matama koyo-moedi, aiyo?” ");
INSERT INTO bwd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeisu givonedi, givonaga, “Kai imi matami koyo-moedi, aga Yaubada keke gida itavenuvenuwadadanemi vaita wa yami koyona wamiyamiya. Aku imi wavona, ‘Ime aitaitalele,’ ada taidei faina yami koyona au gimiyamiya wagaimiya, keke gidaavai. ");
INSERT INTO bwd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Vona velemoena, gavona wagaimiya, gavakaliva keke ginaluku sifi adikali anawana wagaine aku ginalaka golota mali waiya aga banae tokiyafu o kai tobaninivula. ");
INSERT INTO bwd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aku banae-nai ginaluku wana wagaine, tauna banae ani sifi aditoitaveyabina velemoena, ");
INSERT INTO bwd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ada banae faine wana anatoitaveyabina wana gina yavuna. Ada sifi bonana ina nogalina, ada tauna yana sifi gina douwedi adiyegana wagaine ke gina nagoyedi ina yegemona. ");
INSERT INTO bwd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ada tova-nai sifiyavo matatabudi ina yegemona-yabu, banae wai gina nagona aku badi ina muliyena, faina bona ituna iinanana. ");
INSERT INTO bwd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aku mali kaliva keke-mowa ina muliye aku inaota-yabuyabuna, faina mali kaliva bonana keke ida inana.” ");
INSERT INTO bwd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Vona matalivulivuna taidei Yeisu giifufuyena wagaidiya, aku badi keke nuwadi gidamali gavana givonavonaye wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Taidei faina Yeisu kaduwe givona-vagila, givona, “Vona velemoena, gavona wagaimiya, Iya Tauku ani kali anawana sifi ilukuluku wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Moyaidi gavega wai inago ielai iveseba vaita sifi ina itaveyabidi velemoena ani badi tokiyafu o kai tobaninivula, aku sifi ani keke bonadi ida venogale. ");
INSERT INTO bwd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iya Tauku kali anawana. Ada Iya wagaikuya gavega inaluku ani kibababala ina vaina, ada ina lukuluku ina yegeyegemona. Ada sifi adiga inuwanuwagana anafaiweya, badi yawai ana aa velemoena ina nuwanuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tokiyafu ani au bana gielai vuvu seya-moena faine, taine sifi gina kiyafudi, gina luvealikadi, ada gina luyavuledi. Aku Iyayeku ani gaelai e ada yaku sifiyavo wayawaidiyavo ina miyamiya, ada yawaidi-dina wagaidiya wa adinuwakabubu vefovefofona ina miyamiyanena. ");
INSERT INTO bwd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iyayeku sifi aditoitaveyabina iwakaku. Ada sifi aditoitaveyabina iwakana anafaiweya, Iya yawaiku gaawaegena gana alika yaku sifi faidiya. ");
INSERT INTO bwd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aku mali kaliva bana keke toni sifi aku au giitaitaveyabidi fatana faina ani keke aditoitaveyabina velemoena. Ada tova-nai galuweta walawala gina itana gielaelai aga sifi gina segedi aku ginaota ginanau. E ada galuweta walawala au gina yegemona sifi wagaidiya ada tufodi gina yovadi aku tufodi gina vemaduwawaliyedi. ");
INSERT INTO bwd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kaliva-nai ginaota faina banae keke maita gida nuwanuwa sifi-dina faidiya aku au bana fatana faine gifaifaisewa. ");
INSERT INTO bwd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Iyayeku sifi aditoitaveyabina iwakaku. Ada Bana Kamaku gialamaneku ada Iya Kamaku gaalamanena anafaiweya, kaduwe Iya yaku sifi gaalamanedi ada badi Iya ialamaneku. Ada yawaiku gaawaegena gana alika yaku sifi faidiya. ");
INSERT INTO bwd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aku sifi velugadi kaduwe Iya yaku sifi, ani badi keke taidei kali-nai wagaine. Badi kaduwe akulauboda gana vagauledi gana aliyedi, ada badi kadu bonaku ina venogalena. E ada sifiyavo ina vewauma seyana wagaine, adiyoo seyana, adiToitaveyabina seyana. ");
INSERT INTO bwd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ada yawaiku gaawaegena gana alika e ada muliya kaduwe ganavai-vagilena. Yawaiku gana awaegena faina, Kamaku ginuwakabubuyeku. ");
INSERT INTO bwd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Keke seyana gaito yawaiku ginavai wagaikuya, aku Iya Tauku yaku nuwanuwa wagaine yawaiku gana awaegena. Wa yaku veimeya ke yawaiku gana awaege gana alika, ada kaduwe Iya wa yaku veimeya ke ganavai-vagilena. Taidei anafaiweya Kamaku giveimeyeku.” ");
INSERT INTO bwd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aku Yeisu taidei anafaiweya giifufu wagaine, meIsileli kaduwe taudiyavo adiyoo iludakadakadi. ");
INSERT INTO bwd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Badi tufona moyaidi ivonaga, “Ida banae ani aluwaluwa koyona nafone gimiyamiya ke gikivekabaleyana e ada givonavona anafaiweya. Gavana faina bonana wavenovenogale?” ");
INSERT INTO bwd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aku tufodi ivona, “Ida yana ifufu keke kaliva aluwaluwa koyona nafone anafaiweya. Keke meyameyaganina aluwaluwa koyona badi matadi koyo-moedi ginagadi ada gina abwadi.” ");
INSERT INTO bwd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aku abutu seyana anatova giyegemo e ada kaliva ivagauta Yelusalema wagaine. Tainei abutu-nai anayegana Manuwa Tabu Anakiveyegayegana Anaebanuwaududu Abutuna, ada tova-nai tulutulu lakaina anatova. ");
INSERT INTO bwd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ada Yeisu ginunudadana ebavagauta anafafali seyana wagaine, taine ivewagana Kini Solomoni anayeganeya, wada manuwa tabu lilivane. ");
INSERT INTO bwd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ada meIsileli aditonagonayavo ivagauta Yeisu wagaine ada ivona, “Gavaiyamu-yo tova manamanawena ime ana vevenuwavoganeni? Gavaiyamu, velemoena Oyeni ani Mesaiya o kai keke? Uda vonema tunutunugina.” ");
INSERT INTO bwd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeisu gilufata givona, “Iya bademowa gavonemi aku imi keke wada vetumagana. Iyaiyaya ebameyasidobodobo gagugaiyedi Kamaku anayeganeya ani gaitoma-dina bade iawamogatala faikuya, ");
INSERT INTO bwd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","aku imi keke wada vetumagana, faina imi keke yaku sifiyavo. ");
INSERT INTO bwd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yaku sifiyavo ani bonaku ivenogalena. Iya gaalamanedi, ada badi imuliyeku. ");
INSERT INTO bwd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ada Iya yawai-vagata gaveledi ada au keke-mowa alika-vagata gina vaidi, ada keke seyana gaito yaku sifi gina silemaku nimakuya-deya. ");
INSERT INTO bwd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kamaku badi giveleku ani Banae anakaibe Totoyogi-moena. Ada keke seyana gaito anafata badi Kamaku nimane gina silema. ");
INSERT INTO bwd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Iyayeku ada Kamaku au amaiselu seyana.” ");
INSERT INTO bwd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aku yana vona-nai vaita Banae ada Tamana Yaubada au seyana ani meIsileli inogalina e ada iagouga lakaina, ada imididi kabala ivaidi evona ina tutuvealikana. ");
INSERT INTO bwd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Aku Yeisu givona wagaidiya, givonaga, “Gugai iwakadi moyaidi Tamada wagaine iyegemona ani Iya gavewalemi. Gavagugai faine nuwanuwami wana tutuvealikaku?” ");
INSERT INTO bwd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Badi ilufata ivona, “Ida keke gugai iwakana faina ana tutuvealikani, aku uvona awadamana faina. Oyeni au kaliva-mowa nonogana uvona vaita O Tauni Yaubada.” ");
INSERT INTO bwd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeisu givonediga, “Vona seyana yami Veimeya anaBuki wagaine maita waalamanena kai keke? Vona-nai Same wagaine tova-nai Yaubada tovevonayavuga givonedi, givona, ‘Imiyavo ani yaubadayavo.’ ");
INSERT INTO bwd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ada kaalamanena Yaubada yana vona ani kaliva keke adifata ina luyaweli. E ada kai biyavo-dina Yaubada yana vona giveledi ani giawaveyaubadayedi aga ");
INSERT INTO bwd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","taumada, Iyayeku ani gavaiyamu? Tamada Yaubada giseliyeku yana faisewa faine ke giimiliku babi wagaine, ada gavona, ‘Iyayeku Yaubada Natuna.’ E aku gavana vuvuna ida yaku vona faina imi wavona vaita Yaubada wagaine gavona awadamana? ");
INSERT INTO bwd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kai keke Kamaku yana gugai gada gugugaiyedi aga keke gada nuwanuwa vaita wada vetumaganeku. ");
INSERT INTO bwd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aku velemoena Iya yana gugai gagugugaiyena. Kai keke Iya Tauku wada vetumaganeku, aga au yaku gugai ebameyasidobodobo gafaisewadi ani wana itadi ke wana vetumaganedi. E ada wana alamanena ke nuwami gina malina ani Kamaku gimiyamiya Iya wagaikuya ada Iya kaduwe gamiyamiya Kamaku wagaine, ada au Ime seya-moena.” ");
INSERT INTO bwd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ada taide anafaiweya Yeisu givona faina, badi biyavo-dina kaduwe ibalalava vaita ina kiveyabina aku adimwatuguya giamwakuna, ada gisegedi aku ginau. ");
INSERT INTO bwd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aku Yeisu giyewa-vagilena gufa Yolidani fafaline wadedeku Iyoni nagona gikikivebabitaiso wagaine. Wadedeku-deya gimiyamiya ");
INSERT INTO bwd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","aku kaliva moyaidi inaunau wagaine. Ada iveifuifufu, ivonavona, “Iyoni keke tamo iyaiyaya ebameyasidobodobo gida gugaiyedi, aku vona moyaina Iyoni giifufuyena taidei kaliva-nai faine ani vona velemoena.” ");
INSERT INTO bwd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ada fafali-nai wagaine kaliva tufona moyaidi ivetumagana Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Aku kaliva seyana anayegana Lasalo, ada novunavo Meli ke Mata. Yadi melala anayegana Bedani. Meli-nai banae bunama giiwakelolona Yeisu agene ada kuluwana manamanawena wagaine giluegegedi. E, ada seyana tova Lasalo giveoga lakaina, ");
INSERT INTO bwd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ada novunavo adiselu ani Yeisu anamatawa iimilina, ivona, “Kauveya, tubuiya bana unuwakabubuyena lakaina ani giveoga.” ");
INSERT INTO bwd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aku Yeisu ginogalina ada givona, “Veoga-nai taidei ani ananunu keke alika faina, aku ananunu ani Yaubada anayegana gina kilakaina e ada wagaine-deya Banae Yaubada Natuna kadu anayegana gina kilakaina.” ");
INSERT INTO bwd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Taidei faina Yeisu ginuwakabubuyena Mata ada taina Meli ke novudi Lasalo nodi nonogana ");
INSERT INTO bwd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tova-nai ginogalina Lasalo giveoga, keke gida madutauya aku au gimiyayewa kaduwe yadayada iluwei wadedeku fafali-nai gimiyamiya wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Aku muliya yana tonogalayavo wagaidiya givona, “Wanaela kanayewa Yudiya ke Lasalo kana madubodana.” ");
INSERT INTO bwd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Badi ivonaga, “Aku Labai, yadayada iluwei giavaidi ani meIsileli tonagonayavo ibalalava vaita kabaleya ida tutuvealikani. Aku nuwanuwa una yewani?” ");
INSERT INTO bwd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeisu gilufata givona, “Bademowa kaalamanena yadayada seyana wagaine kauwana anabai anayoo tuwelo. Ada gavakaliva kai gina nudadana yadeyadeya aga keke agena gina vetutu, faina babi taidei anamalina wagaine giitaita. ");
INSERT INTO bwd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Aku kai kaliva gina nudadana bogibogi wagaine aga agena gina vetutuna, faina yana malina keke.” ");
INSERT INTO bwd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Taidei anafaiweya Yeisu givona, ada kadu givonedi, givona, “Tubuiyada Lasalo gienowavulu, aku Iya gananau ada gana livagu gina mididi.” ");
INSERT INTO bwd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yana tonogalayavo ilufata ivona, “Kauveya, kai bana gida daudau aga aimo dauya-deya gina veiwaka.” ");
INSERT INTO bwd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Aku Yeisu givonavona Lasalo yana alika faina, aku yana tonogalayavo inuwanuwa vaita gidavona au gida daudau-mowa. ");
INSERT INTO bwd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Taidei faina ada Yeisu givone-moedi givonaga, “Lasalo bademowa gialika. ");
INSERT INTO bwd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Aku gavemwamwala faina Iya keke bana nodi wadedeku, faina nuwanuwaku imiyavo wana vetumagana. E ada wana mididi kanana kana itana.” ");
INSERT INTO bwd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ada Tomasi, bana anayegana anavelu Didimasi ani tubuiyanavo givonedi, “E, ide kadu kananau e ada Yeisu nodi kana alika-tamwai.” ");
INSERT INTO bwd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ada Yeisu yana tonogalayavo nodi itauya inaunau aku inuyegemona Bedani wagaine ani ikaiyanogala vaita bademowa Lasalo vovona isena didikula luwa yaiyaina wagaine yadayada laufuli giavaidi wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bedani ani Yelusalema lilivane ada anaatuwada kilomita toiye anafaiweya kananau, ");
INSERT INTO bwd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","e ada Yelusalema-deya meIsileli moyaidi ielai Mata ke Meli wagaidiya ke inavona nuwakabubuyedi novudi yana alika faina. ");
INSERT INTO bwd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ada tova-nai Mata valeya ginogalina vaita Yeisu gielaelai, ada au giyegemona gina ginubodebodena, aku Meli banae gimiya manuweya. ");
INSERT INTO bwd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ginau Yeisu wagaine givona, “Kauveya, kai O udamiya idedeku aga novuku keke gida alika. ");
INSERT INTO bwd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aku auwe, gaalamanena gavana Yaubada una veolena ani gina veleni.” ");
INSERT INTO bwd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeisu givonena, givona, “Novu wayawaina ginayawa-vagila.” ");
INSERT INTO bwd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata gilufata givona, “Iya gaalamanena aimo tova anaebalauyabu ginayawa-vagila, tova-nai Yaubada kaliva alikeya gina siveyawadi.” ");
INSERT INTO bwd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeisu givona, “Iya Tauku ani yawa-vagila kaduwe yawai-vagata vuvudi. Banae gaito givetumagana wagaikuya ani kai gina alika, au alika keke anafata gina kiveyabi aku aimo wayawaina gina miyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ada banae gaito wayawaina ada givetuvetumagana wagaikuya ani keke tamo tova gina alika. Ada gavaiyamu, taidei uvetumaganena o keke?” ");
INSERT INTO bwd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata gilufata ada givonena, “Ika Kauveya, Iya gavetumagana ani Oyeni au Mesaiya, Yaubada Natuna. Ada Yaubada giimilini ime tomiyababi wagaimeya.” ");
INSERT INTO bwd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ada taidei anafaiweya Mata givona giavaina, muliya gitauya giyewana manuweya ke taina Meli gidouwe gielai ada gialakululuyena, givona, “Tovewala bademowa ginuyegemona yada melaleya ada nuwanuwana unaela gina itani.” ");
INSERT INTO bwd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ada Meli taide ginogalina wagaine, gimadumididi ke gitauya ginau Yeisu wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeisu aimo keke gidaluku melala wagaine aku aimo gimiyamiya fafali-nai wagaine Mata ginuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ada meIsileli-dina Meli nodi manuweya ivonabikebikena ani iitana gimadumididi giyegemona ginau, ada inuwanuwa sidamana, ivona, “Ginauna didikula luwa wagaine gina tagiya,” e ada imuliyena. ");
INSERT INTO bwd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Badi imuliyena aku bana Meli giyegemona Yeisu wagaine ada giitana, au wa yana vemoimoina giiboula-mowa agene ada givona, “Kauveya, kai Oye udamiya idedeku aga novuku keke gida alika.” ");
INSERT INTO bwd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ada tova-nai Yeisu giitana vaita Meli ada kadu meIsileli nodi itagitagiya ani yana nuwanuwa gikoyo kadu aluwaluwana gikabekabebena. ");
INSERT INTO bwd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ada gitolidadana, givona, “Gadedeku-deya watavu?” Badi ilufata ivona, “Kauveya, unaela kanana una itana.” ");
INSERT INTO bwd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ada au Yeisu gitagiya. ");
INSERT INTO bwd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bana gitagiya ada badi meIsileli ivona, “Waitana, Lasalo ani tubuiya-moena, ada ginuwakabubuyena lakaina.” ");
INSERT INTO bwd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aku kaliva tufodi ivonaga, “Banae-nai ani kaliva matadi koyo-moedi gikiveiwakanedi. E aku gavaiyamu-yo keke tamo gavana gidagai e ada kaliva taidei gidaleme ada keke gida alika?” ");
INSERT INTO bwd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","E ada kadu Yeisu analutovona Lasalo yana alika faine giyewa, ada nuwana gikoyo kadu aluwaluwana gikabekabebena. Ada gitauya ginau didikula wagaine. Didikula-nai ani luwa lakaina iyalana yaiyaina wagaine, ada awana isebabalina kabala lakaina wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ada au Yeisu givona, “Kabala awane-deya wana vekaliwawana.” Aku bana Mata tauna toalika novuna ani givona, “Kauveya, bademowa gilada. Ina yavuna ani wada magana gilada velemoena, faina bade yadayada laufuli giavaidi wagaine itavuna.” ");
INSERT INTO bwd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ada Yeisu givona, “Bade Iya gavoneni, gavona, ‘Kai una vetumagana, aga Yaubada yana toyogina una itana.’” ");
INSERT INTO bwd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","E ada au kabala ivaina. Ada Yeisu giitalaka gabama wagaine ada givona, “Kamaku, gavesiule wagainiya faina yaku veola uvenogalena. ");
INSERT INTO bwd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ada bade gaalamanena ani tova moyaina uvenovenogaleku, aku vona taide gavonayena e ada badi imidimididi idedeku ani ina nogalina ke ina vetumagana vaita O Tauni velemoena uimiliku gaobuelai.” ");
INSERT INTO bwd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Vona taidei giluyabuna, ada au givedou bonana lakaina wagaine, givona, “Lasalo-yo, una yegemona!” ");
INSERT INTO bwd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ada bana toalika giyegemona gielai. Nimana ke agena kaleko diyana aku manamanawedi wagaidiya ifaidi meIsileli adigiduwa toalika faidiya anafaiweya ani aimo gimiyamiya. Kaduwe kaleko magigina ikiwafina ani aimo gimiyamiya. Ada Yeisu givona wagaidiya, givona, “Didikula kalekodi wana vaiyavuledi e ada anafata gina nudadana.” ");
INSERT INTO bwd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tayuwe wagaine badi meIsileli gavega ielai Meli imadubodana ada iitana gavana Yeisu gigugai ani tufona moyaidi Banae ivetumaganena. ");
INSERT INTO bwd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aku tufodi itauya inau Falisiyavo wagaidiya ada iawatalatalaina gavana Yeisu gigana faina. ");
INSERT INTO bwd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ada badi veyavo anatovegugai lakaidiyavo ke Falisiyavo matawa iimilina ada yadi Kanisela anavagauta isena. Ada ivagauta ayo ivebutu ivonavona, “Gavaiyamu kanagai? Kaliva taidei iyaiyaya ebameyasidobodobo moyaina gifaifaisewadi! ");
INSERT INTO bwd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kai kanaita-moe aku taidei anafaiweya gina naunau aga au kaliva moyaidi ina vetumaganena ke ina muliyena. E ada badi adatoveimeya meLoma ani ina kaiyanogala ada inaela yada manuwa tabu ina yawelina ada kaduwe yada yoo nodi matatabuda ina vaiyavuleda.” ");
INSERT INTO bwd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aku kaliva seyana badi Kaniselayavo wagaidiya gimiyamiya, anayegana Kaiyafasi, tauna banae veyavo anatovegugai aditonagona tayuwe malamala-nai wagaine. Banae gimididi ada givona wagaidiya, givona, “Imi keke tamo gavana wada alamane. ");
INSERT INTO bwd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kaduwe keke nuwami gidamali vaita adalauboda-mowa kaliva seya-moena gida alika kaliva moyaida faideya, e ada yada yoo matatabuna keke inakwaa-yabu.” ");
INSERT INTO bwd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","E au taide yana vona-dina ani keke tauna yana nuwenuweya aku aiyada banae veyavo anatovegugai aditonagona malamala-nai tayuwe wagaine faina, Yaubada yana nuwanuwa wagaine gisena ke gifalofisai Yeisu ani gina alika meIsileli adiyoo matatabuna faidiya. ");
INSERT INTO bwd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ada keke meIsileli gaga faidiya aku kaduwe Yaubada natunavo moyaidi faidiya, ani badi imiyamiyanau fafali tulina tulina wagaidiya. Ada gina aliyedi seyana wagaine ke ina veyoo seyana. ");
INSERT INTO bwd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","E ada tayuwe yadayada-nai wagaine meIsileli aditonagonayavo ivevuvu nodi iifuifufuyena gavaiyamu Yeisu ina luvealika. ");
INSERT INTO bwd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tayuwe faina Yeisu keke aimo gida nunudadana meIsileli aditonagonayavo matadiya aku giyegemona ginau Ifeleimu wagaine, melala-nai fafali kavovona afaine, ada wadedeku-deya gimiya yana tonogalayavo nodi. ");
INSERT INTO bwd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aku meIsileli yadi Nugulina anaAbutu anatova givelilivana, ada kaliva moyaidi melala tulina tulina wagaidiya-deya ilakalaka Yelusalema wagaine. Muliya-yo Abutu-nai gina vevuvu ani adikiveyegayegana adigiduwa ina gugaiyedi e ada yegayegadiyavo Yaubada matane. ");
INSERT INTO bwd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Aku badi veyavo anatovegugai lakaidiyavo ke Falisiyavo bademowa veimeya isena vaita kai tamo gaito gialamanena gadedeku Yeisu gimiyamiya aga gina awamogatalena wagaidiya e ada inaela ina kiveyabina. E, ada kaliva moyaidi manuwa tabu anafafali wagaine imidimididi aku Yeisu iitaitalelena ke ivetolitoli, ivona, “Gavaiyamu wanuwanuwa, Banae ginaelai Abutu wagaine o kai keke?” ");
INSERT INTO bwd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aku yadayada sikisi aimo gimiyamiya ke Nugulina Abutuna gina yegemona aku Yeisu ginau Bedani, wadedeku-deya Lasalo gimiyamiya, tauna banae Yeisu gisiveyawana alikeya. ");
INSERT INTO bwd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Wadedeku Bedani wagaine aa ikidewadewa Yeisu faine. Ada Mata bana aa giulilina aku bana Lasalo badi tokani kadu Yeisu nodi ienokekela teibeli lilivane ikanikani. ");
INSERT INTO bwd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ada ikanikani aku bana Meli ani bunama wa tuwavina gialiyena, anaetowava lita afuna anafaiweya. Bunama-nai ivewagana ‘nadi’, tainei magana iwakana velemoena ke kaduwe fatana lakaina. Ani Yeisu agene giiwakelolona ada kuluwana manamanawena wagaine giluegegena. Ada manuwa matatabuna gimaga bunama-nai magana iwaka-moena wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aku Yeisu yana tonogala seyana, banae Yudasa Isakaliyota aimo gina ivemogatalina nibainavo wagaidiya ani givona, ");
INSERT INTO bwd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bunama-nai ani fatana lakaina! Kada vekimoneyena ada manina kadavai tofanifani kada veledi.” ");
INSERT INTO bwd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Vona taidei givonayena aku keke vaita velemoena banae gida nuwanuwa lakaina tofanifani faidiya, keke. Aku aiyada banae tokiyafu faina taidei anafaiweya givona. Banae-nai ani Yeisu ke tonogalayavo yadi mani anatoitaveyabina, ada mani-nai idododona fose wagaine ani tova ke tova banae mani tufona giyauyaudi wagaine ke tauna gilemelemena. ");
INSERT INTO bwd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeisu givonena, givona, “Vavine unase-moe ginamiya. Ida bunama-nai ivenuwadadanena ani ginamiya akuibo didikuleya anayadayada-nai faina. ");
INSERT INTO bwd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tofanifani tova moyaina wagaimiya imiyamiya, aku Iyayeku ani aimo keke tova moyaina nodi kana miyamiya.” ");
INSERT INTO bwd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tayuwe tova-nai meIsileli yoo lakaina ikaiyanogala vaita Yeisu bade wadedeku, e ada ielai. Aku keke Banae anakaibe faine aku kaduwe ina itana Lasalo, banae Yeisu gisiveyawana alikeya. ");
INSERT INTO bwd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Taidei faina veyavo anatovegugai lakaidiyavo veimeya ibubuna ada Lasalo kaduwe Yeisu nodi ina luvealikadi, ");
INSERT INTO bwd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","faina meIsileli moyaidi ialamanena Lasalo giyawa-vagila alikeya, e ada tufona moyaidi aditonagonayavo adimuliya isegesegena aku Yeisu wagaine ivetuvetumagana. ");
INSERT INTO bwd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mala gilavuna yoo lakaina ielai Nugulina Abutuna faina ani Yeisu valeyana inogalina vaita gilakalakaelai Yelusalema. ");
INSERT INTO bwd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ada ai lagadi wa lukudi bodaboda anafaiweya ivaidi ada iyegemona inau inamadu bodebodena aku iawadavadavana bonadi lakaina, ivonavona, “Osana! Banae gielaelai KAUVEYA anayeganeya ani wa anaawanuwakabubu! Banae meIsileli yada Kini!” ");
INSERT INTO bwd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ada yoo-dina idavadavana aku Yeisu ginuyegemona Yelusalema ani doniki natudi ginuwagana, ada givetoga tabone ke ginaunau. Tainei wagaine gavana tuwai-moena ivetokilumina Yeisu faine Buki Tabu wagaine ani anavelemoena giyegemona, givona, ");
INSERT INTO bwd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“MeSaiyoni, keke wana matauta. Wana itana, yami Kini gielaelai. Doniki natudi wagaine givetoga gielaelai.” ");
INSERT INTO bwd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tayuwe tova-nai wagaine gaitoma-dina iyegemona Yeisu wagaine ani yana tonogalayavo aimo keke nuwadi gidamali adialamana faidiya. Aku aimo Yeisu giyawa-vagila anatoveya ada wa yana iwakana mamalina gilaka Tamana wagaine, ani tayuwe tova-nai wagaine nuwadi giafolena vaita gaitoma-dina taide igugaiyedi Bana wagaine ani Tauna Bana faine vona-nai tova tuwaina ivetokilumina Buki Tabu wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ada badi yoo-dina boi Yeisu nodi aku Lasalo gisiveyawana alikeya ada gidouwena didikula luwa wagaine giyegemona, ani kaliva-dina Yeisu yana gugai ifuifufuyedadanena. ");
INSERT INTO bwd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Taide anafaiweya kaliva moyaidi inogalina vaita iyaiyaya ebameyasidobodobo taidei gifaisewana, ada vuvuna-nai faine iyegemona inubodebodena. ");
INSERT INTO bwd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ada taidei wagaine Falisiyavo yoo lakaina iitana inaunau Yeisu faine e ada taudiyavo iveifuifufu, ivona, “Wana itana, ide keke adafata! Bade kakabekabebena, faina kaliva moyai-moedi Banae imulimuliyena!” ");
INSERT INTO bwd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yoo-dina ilaka inau Yelusalema Abutu-nai faine ke Yaubada wagaine ina oduodu, ada kadu meGiliki tufodi adimwatugu wagaine imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ada badi meGiliki-dina ielai Filipi wagaine, banae kwana Bedesaida, melala-nai Galili anafafali wagaine. Ada iveolena, ivonaga, “Kauveya, nuwanuwama Yeisu ana itana.” ");
INSERT INTO bwd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ada Filipi ginau Andulu gimatawena, e ada Andulu ke Filipi adiselu inau ada Yeisu ivonena. ");
INSERT INTO bwd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeisu gilufata, givona, “Malinai tova-moena anamwatugu bade giyegemona ada Banae Kaliva Natuna anayegana lakaina Yaubada gina ivemogatalina. ");
INSERT INTO bwd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Vona velemoena, gavona wagaimiya, witi waifeina kai keke ginaobu babi negenine ada gina alika aga au anaita-nai anafaiweya gina miyamiya waifeina. Aku kai gina alika, aga gina veguwa moyaina. ");
INSERT INTO bwd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kaduwe badi gavega taudiyavo yawaidi inuwakabubuyedi ke inuwalolonedi ani ina nusegedi. E aku gavega taudiyavo yawaidi idedeku babiya keke ida nuwakabubuyedi ke ida nuwalolonedi, ani badi wagaidiya yawaidi-dina inamiya-vagata. ");
INSERT INTO bwd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Badi gavega nuwanuwadi ina gugai faikuya, gilubodadi kaduwe ina muliyeku, ada gadedeku Iya gana miyamiya wagaine, kadu wadedeku yaku togugai-dina nodi ana miyamiya. Ada gavega igugugai faikuya ani badi adiita lakaina Kamaku matane e ada adiyegana gina kilakaidi. ");
INSERT INTO bwd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Tova malinai Iya aseaseku giuloulolo lakaina, e aku gavana gadavona? Kai gadavona, ‘O Kamaku, taine uloulolo-nai lakaina gielaelai wagaikuya ani uda kibababaleku wagaine-deya?’ Aku keke. Taide vuvuna-nai faine gaelai, e ada tova taidei anaulolo gana nuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kamaku, ayegana lakaina una ivemogatalina ke kaliva ina kilakaini!” Ada giveola anafaiweya ada au Yaubada bonana giyegemona gabama wagaine, givona, “Bademowa akuyegana lakaina gaivemogatalina ada kaduwe gana ivemogatali-vagilena ke kaliva ina kilakaina.” ");
INSERT INTO bwd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ada yoo wadedeku imidimididi ani inogalina ada ivona, “Wada atala giluatala,” aku tufodi ivona, “Wada anelose givona Bana wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeisu givonaga, “Keke Iya faikuya bonana taide gida yegemona, keke. Au imi faimiya. ");
INSERT INTO bwd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Malinai ani babi anakalivayavo adimatavuloga anaveimeya bademowa giyegemo, e au malinai Seitani, banae babi anakalivayavo aditoveimeya ani Yaubada gina venega ginanau. ");
INSERT INTO bwd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aku Iyayeku ani tova-nai ina silakaiku babi wagaine-deya, ada kaliva moyaidi yadi nuwanuwa gana vaina.” ");
INSERT INTO bwd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Taide yana vona-nai givonayena e ada yana alika anawai gina ivemogatalina. ");
INSERT INTO bwd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ada yana vona inogalina ada yoo ilufata, ivona, “Ime anogalina yada Buki Veimeya yana vewala wagaine ani Mesaiya ginamiya-vagata, e aku gavaiyamu-yo O uvona vaita gilubodana Bana Kaliva Natuna-nai ina silakaina? Gaito taine Kaliva Natuna?” ");
INSERT INTO bwd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeisu givonediga, “Aimo tova maufo-moena malina amimwatuguya gina miyamiya. E ada aimo malina wagaimiya gimiyamiya anatoveya, gilubodana wana nunudadana wagaine aenanai yuyuvana gina bwatavumi. Faina badi gavega yuyuvana wagaine inunudadana ani keke ida alamane gadedeku-deya inauna. ");
INSERT INTO bwd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Malina aimo gimiyamiya wagaimiya anatoveya, wana vetumaganena e ada imiyavo ani malina natunavo.” Taidei anafaiweya Yeisu givona wagaidiya giavaina, gitauya ginau ke Tauna gisewavuyena ada keke inaita. ");
INSERT INTO bwd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yeisu iyaiyaya ebameyasidobodobo moyai-vagaidi gifaisewadi meIsileli matadiya, aku aimo keke-mowa ida vetumagane. ");
INSERT INTO bwd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Taidei anafaiweya idewa e ada falofita Aiseya yana vona givonaye-vagaina ani giluveyegemonina velemoena, givonaga, “KAUVEYA, ime ya valeya iwakana aawaawamogatalena aku gaito givenogale? Keke tamo. O KAUVEYA, ya toyogina uvewala kaliva wagaidiya, aku gaito givetumagane? Keke tamo.” ");
INSERT INTO bwd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Taidei faina keke adifata ina vetumagana, faina Aiseya kaduwe fafali seyana wagaine givona, ");
INSERT INTO bwd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yaubada matadi gikivekoyodi ada aseasedi gikivekugadi, e ada au keke adifaiweya matadi wagaine inaita o kai aseasediya ina alamane ada ina nuwavila Iya wagaikuya ke gana kiveiwakanedi.” ");
INSERT INTO bwd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Taidei anafaiweya Aiseya givona faina bana tuwaina-deya giitana Yeisu yana iwakana mamalina, e ada givonaye-vagaina yana vona taide wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ada meIsileli tonagonayavo wagaidiya tufona moyaidi Yeisu ivetumaganena. Aku Falisiyavo imatausedi faina, keke yadi vetumagana ida awayegeyegemone kaliva wagaidiya aenanai Falisiyavo ina veyegemoni-vagaidi manuwa ebavewala wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Faina biyavo-dina ani kaliva yadi awadavadava inuwakabubuyena lakai-moena ayo Yaubada yana awadavadava. ");
INSERT INTO bwd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ada Yeisu givona bonana lakaina wagaine, givona, “Gaito Iya givetumaganeku ani keke Iya akukaibe gaga gida vetumaganeku, aku kaduwe Banae giimiliku wagaine givetumagana. ");
INSERT INTO bwd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ada gaito Iya giitaitaku, kaduwe Banae giimiliku ani giitaitana. ");
INSERT INTO bwd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iyayeku gaobuelai babiya anafaiweya malina, e ada badi gavega ivetumagana wagaikuya ani keke aimo ina miyami yuyuvana wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ada gavakaliva banae yaku vona ginogalidi aku keke gida itaveyabidi, aga banae keke ganavona venuvenuwadadane vaita analauboda matavuloga faina, keke. Faina Iya keke gada obuela babiya ke kaliva ganavona venuvenuwadadanedi ada vematavuloga gana veledi. Iya gaelai ke gana kibababaledi. ");
INSERT INTO bwd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aku gavakaliva gina venikoiyeku ke yaku vona keke gina itaveyabi, ani bademowa tovevonayavuga gimiyamiya bana faine. Taidei yaku vona-dina gavonayedi aku bana gidibusoyogedi ani inavona venuvenuwadadanena ke ina kivelaubodana matavuloga gina nuwagana. Taide gina yegemona ani aimo vevonayavuga anatova lakaina wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Faina keke Iya Tauku yaku nuwenuweya gada ifuifufu, aku Banae Kamaku Iya giimiliku ani bade giveimeyeku gavaiyamu ganavona ada gavana gana vonaye. ");
INSERT INTO bwd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ada Iya gaalamanena Kamaku yana veimeya ani yawai-vagata anawai. Taidei faina gavana gavonayena ani au anafaiweya gavana Kamaku bade givoneku.” ");
INSERT INTO bwd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aku yadayada seya-moena gimiyamiya ada Nugulina Abutuna gina yegemo. Ada Yeisu gialamanena yana tova bademowa giyegemona ke babi taidei gina segena aku gina yewana Tamana wagaine. Ada Tauna yana tonogalayavo badiyavo babiya imiyamiya ani bade ginuwakabubuyedi velemoena, ada yana nuwakabubu-nai gina naunauwena yawaina anaebalauyabu wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","E, ada Yeisu yana tonogalayavo nodi lavilaviya ivevebailavi, ada Yudasa, banae Saimoni Isakaliyota natuna ani badi nodi. Aku banae ani bademowa Seitani nuwanuwa koyona gisena aseasene ke Yeisu nibainavo wagaidiya gina ivemogatalina. ");
INSERT INTO bwd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Aku Yeisu bademowa gialamanena Tamana gaitoma moyaina givele-yabuna ke wa yana veimeya, kadu Yaubada wagaine-deya gielai ada gina yewana Banae wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Taidei gaitoma-dina gialamanena, aku yadi kani wagaine gimididi ada ananuya manamanawena givaiyavulena aku tawelo agoiline giluwalina. ");
INSERT INTO bwd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ada gufa givaina ke giiwana nauwa wagaine, ada givebutu yana tonogalayavo agedi giikolakola ke tawelo labene giluwalina ani wagaine giluegegedi. ");
INSERT INTO bwd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ada giikolakola aku gielai Saimoni-Pita wagaine, ada vaita agena gida kolana ani Pita givonena, givonaga, “Kauveya, gavaiyamu, Oyeni ani Iya ageku una koladi, aiyo?” ");
INSERT INTO bwd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeisu gilufata, givonaga, “Gavana Iya gagugugai ani ananuwanuwa keke uda alamane malinai, aku aimo e nuwa gina malina.” ");
INSERT INTO bwd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aku bana Pita givonaga, “Au keke-mowa Iya ageku una ikolakola.” Yeisu gilufata givona, “Kai age keke ganakola, aga au oye keke tamo ya vuvu ke aimo yaku tonogala uda miyamiya.” ");
INSERT INTO bwd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ada Saimoni-Pita givonena, givona, “Kauveya, kai anafaiweya, aga keke ageku gaga aku kaduwe nimaku ke kuluwaku nodi.” ");
INSERT INTO bwd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeisu givona, “Badi gavega bademowa itowa, ina ani vovodi matatabuna yegayegana, aku agedi gagana ibwanene ani ina koladi. Ada imiyavo moyaimi yegayegamiyavo, aku wagaimiya-deya seyana ani keke yegayegana.” ");
INSERT INTO bwd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeisu bademowa gialamanena gaito gina ivemogatali nibainavo wagaidiya, taidei faina givona vaita keke matatabudi yegayegadiyavo. ");
INSERT INTO bwd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aku agedi anaikolakola giluyabu, ananuya giosena ke giyewa anaiviya gienokekela. Ada au gitolidadanedi, givona, “Gavaiyamu, nuwami gimalina gavana taidei gagugaiyena wagaimiya faina, o keke? ");
INSERT INTO bwd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Imiyavo wavewagaku, ‘Tovewala’ ada kaduwe ‘Kauveya’, ada taidei yami vona tunutunugina, faina velemoena Iya anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ada Iya yami Kauveya kadu yami Tovewala ani kai agemi gakoladi aga imi kadu gilubodami tubuiyamiyavo agedi wada kolakoladi. ");
INSERT INTO bwd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iya ebaita gasena faimiya e ada imi wanadewa anafaiweya Iya gadewa wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Vona velemoena, gavona wagaimiya, togugai ani keke ida kaiwabusege aditoveimeya. Ada kaduwe tomatawa ani keke ida kaiwabusege aditoimila. ");
INSERT INTO bwd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Taide yaku dewa-nai ananuwanuwa ani bade waalamanena, e ada kai wana muliyena aga Yaubada gina awanuwakabubuyemi. ");
INSERT INTO bwd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Keke vaita gada vonavona matatabumi faimiya. Imi gavega gavenuwadadanemi ani gaalamanemi. Aku vona-dina Buki Tabu wagaine gimadu vonaye-vagaidi ani ina yegemona velemoena, givonaga, ‘Kaliva-nai akubeledi nodi ana kanina ani banae gina miyavilana ke gina venibaineku.’ ");
INSERT INTO bwd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Waitana, taidei gaitoma-moena aimo keke gida yegemo, aku malinai gamaduvonayena wagaimiya e ada aimo tova-nai gina yegemona velemoena aga wana vetumagana vaita IYA TAUKU GAMIYAMIYA. ");
INSERT INTO bwd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Vona velemoena, gavona wagaimiya, kaliva gaimilidi ani badi gavega ina sivaivaidi, ina Iya kadu isivaivaiku. Ada gavega Iya isivaivaiku, ina Banae giimiliku kadu isivaivaina.” ");
INSERT INTO bwd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Aku Yeisu taide anafaiweya giifufu giavaina, au ginuwavita lakaina, ada givona yana tonogalayavo wagaidiya, givona, “Vona velemoena, gavona wagaimiya, kaliva seyana wagaimiya gina ivemogataliku nibaikuweyavo wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ada yana tonogalayavo yana vona inogalina, ada au taudiyavo iveitaita ke ivenuwavogana gaito faine givonavona. ");
INSERT INTO bwd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aku tonogala seyana banae Yeisu ginuwakabubuyena ani lilivane gienokekela. ");
INSERT INTO bwd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ada Saimoni-Pita au tonogala-nai giveawayayayena, givona, “Una toliyena, gaito faine givonavona?” ");
INSERT INTO bwd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","E ada tonogala-nai giluvala Yeisu wagaine ke givonena, givona, “Kauveya, tainei gaito faine uvonavona?” ");
INSERT INTO bwd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeisu givonena, givona, “Ida bana kaliva-nai ani beledi kasimina gana ituvina nauwa wa bwaina wagaine ke gana velena.” Ada beledi kasimina givaina ke giituvina ada givelena Yudasa, banae Saimoni Isakaliyota natuna. ");
INSERT INTO bwd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ada Yudasa beledi givai gida kanina ani Seitani giluku wagaine. E ada Yeisu givonenaga, “Gavana una gugaiyena ani una madugana.” ");
INSERT INTO bwd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Aku keke tamo gaito teibeli lilivane ienokekela ani keke nuwadi gidamali tayuwe gavana faina Yeisu givona anafaiweya bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasa banae yadi mani anatoitaveyabina faina, ada tufodi inuwanuwa vaita Yeisu givonevone gidana aa tufona gida kimone yadi kanibutu-nai faina, o kai tamo nuwakabubu gida veledi tofanifani. ");
INSERT INTO bwd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","E ada Yudasa beledi-nai kasimina givaina, ada au giyegemona ginau. Ada bademowa mala gibogi. ");
INSERT INTO bwd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tova-nai Yudasa bade giyegemona ginau aku Yeisu givona, “Malinai Banae Kaliva Natuna anayegana lakaina kaliva ina itanuwagana, ada Bana wagaine kaduwe Yaubada anayegana lakaina kaliva ina itanuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ada kai Kaliva Natuna gina seyegemonena Yaubada anayegana lakaina aga Yaubada kaduwe Kaliva Natuna anayegana lakaina gina seyegemonena Tauna wagaine. Keke tova manamanawena aku ginagana. ");
INSERT INTO bwd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Natukuweyavo, au tova kabisona Iya nodi kanamiya. Ada aimo wana leleku, aku vona-nai badi meIsileli aditonagonayavo gavonedi, e anafaiweya imi malinai kaduwe gavonevonemi, ‘Fafali-nai wagaine ganaunau ani imi keke amifata wanaela.’ ");
INSERT INTO bwd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aku veimeya evaguna gana velemi ani taide anafaiweya. Taumiyavo seyana seyana wana venuwanuwakabubu. Iya ganuwakabubuyemi anafaiweya, imi kaduwe amilauboda moyaimi nodi wana venuwanuwakabubu. ");
INSERT INTO bwd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kai taumiyavo wana venuwanuwakabubu, taidei dewa-nai wagaine kaliva moyaidi ina alamanena imi yaku tonogalayavo.” ");
INSERT INTO bwd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimoni-Pita gitolidadana, givona, “Kauveya, gadedeku unauna?” Yeisu gilufata, givonaga, “Iya gadedeku ganaunau ani malinai keke afata una muliyeku, aku aimoina ee una muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita givona, “Kauveya, gavaiyamu-yo keke akufata gana muliyeni malinai? Iya yawaiku gaawaegena ke O fainiya gana alika.” ");
INSERT INTO bwd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ada Yeisu givonena, givona, “Velemoena o yawai Iya faikuya una awaegena? Vona velemoena, gavona wagainiya, muliya-yo kamukamu gina kwage ani oye una veweyeku tova toiye vaita keke uda alamaneku.” ");
INSERT INTO bwd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeisu yana tonogalayavo wagaidiya givona, “Keke wana aseuloulolo. Yaubada wavetumaganena, ada Iya kaduwe wana vetumaganeku. ");
INSERT INTO bwd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kamaku yana manuwa wagaine ani ebamiya moyaina imiyamiya. Kai keke ida miyami aga keke gada matawemi anafaiweya. Ada Iya ganaunau ke yami ebamiya gana kidewedewedi. ");
INSERT INTO bwd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","E, gananau yami ebamiya gana kidewedewedi ayo ganayewa-vagileku gana vagaulemi kananau, e ada gadedeku Iya gana miyamiya wagaine, kadu imi nodi kanamiya. ");
INSERT INTO bwd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ada fafali-nai wagaine ganaunau ani anawai waalamanena.” ");
INSERT INTO bwd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi givonena, givona, “Kauveya, gadedeku unaunau ani ime keke ada alamane, e ada gavaiyamu anaga wai-nai ana alamane?” ");
INSERT INTO bwd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeisu givonena, givonaga, “Iya Tauku wai-menai ada Iyayeku vona velemoena vuvuna, ada kaduwe yawai-vagata vuvuna. Keke seyana gaito mali wai wagaine ginana Tamada wagaine, taine-mowa Iyayeku akukaibe wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kai wada alamaneku velemoena, kaduwe Kamaku wada alamanena. Ada tova malinai ke gina naunau, Banae waalamanena kadu bade waitana.” ");
INSERT INTO bwd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi givonaga, “Kauveya, Tama-moe uda vewalema e au amafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeisu givonena, givonaga, “Filipi, tova manamanawe-moena Iya amimwatuguya nodi kamiyamiya nonogana aimo keke uda alamaneku? Gavakaliva bade Iya giitaku ani tauna Tamada bademowa giitana. Gavaiyamu-yo uvona, ‘Tama-moe uda vewalema’? ");
INSERT INTO bwd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Gavaiyamu, kai keke wada vetumagana vaita Iya Kamaku wagaine gamiyamiya, ada Banae Kamaku ani Iya wagaikuya gimiyamiya? Vona-dina gavonayedi wagaimiya, ani keke Iya Tauku yaku nuwanuwa wagaine, aku ielai Banae Kamaku wagaine-deya, Banae gimiyamiya wagaikuya ke yana gugai gigugugaiyedi. ");
INSERT INTO bwd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wana vetumaganeku tova-nai gavona Iya gamiyamiya Kamaku wagaine ada Banae Kamaku gimiyamiya Iya wagaikuya. Aku kai keke amifaiweya yaku vona wana vetumagane aga au yaku gugai-dina ebameyasidobodobo gafaisewadi ani faidiya wana vetumaganeku. ");
INSERT INTO bwd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Vona velemoena, gavona wagaimiya, banae gaito gina vetuvetumagana wagaikuya ani gugai-dina Iya gagugugaiyedi anafaiweya, kadu bana ginagadi. Ada gugai ebameyasidobodobo gina gugaiyedi ani lakai-moedi ayo gugai-dina Iya gagugaiyedi, faina tova kabisona babi taidei gana segena aku gana yewaku Kamaku wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ada gavana wana veola akuyeganeya ani Iya gana faisewana, e ada Kamaku yana iwakana mamalina Iya Natuna gana ivemogatalina ke kaliva anayegana ina kilakaina. ");
INSERT INTO bwd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","E, kai gavagaitoma faina wana veola akuyeganeya, gana faisewana. ");
INSERT INTO bwd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kai wanuwakabubuyeku, aga yaku veimeya wana matawalewaleyedi. ");
INSERT INTO bwd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ada Kamaku gana veolena, ada Banae gina velemi amiTolema anavelu ke Banae gina kwayabumi ada nodi wanamiya-vagata. ");
INSERT INTO bwd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Taidei Toleme-nai ani Aluwaluwa Tabuna, Banae nuwanuwa velemoena vuvuna. Aku babi anakalivayavo keke Yaubada ida alamane, ani kadu keke adifaiweya Aluwaluwa Tabuna-nai ina alamane. Keke ida itainana ada keke ida alamane, ada taidei faina keke adifaiweya ina nuwaga. Aku imiyavo ani Banae waalamanena, faina wagaimiya gimiyamiya, ada aimo negenimiya gina miyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tova-nai gana segemi, keke vaita imi natuwaeda anafaiweya wana miyami ke amitoitaveyabina keke, aku ganaelai wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Keke tova manamanawena ada babi anakalivayavo kaduwe keke ina itaku, aku imiyavo ani wana itaitaku. Iyayeku wayawaiku gamiyamiya faina, imiyavo kaduwe wayawaimi wanamiya. ");
INSERT INTO bwd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yadayada-nai ganayawa-vagila wagaine, ani wana alamanena Iya gamiyamiya Kamaku wagaine, ada imiyavo kaduwe wamiyamiya wagaikuya, ada Iya kaduwe gamiyamiya wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Banae gaito yaku veimeya givai giidibumwaigedi ani banae-nai velemoena ginuwakabubuyeku. Ada banae ginuwakabubuyeku ani Kamaku gina nuwakabubuyena, ada kaduwe Iya gana nuwakabubuyena ke Iya Tauku gana ivemogataliku tauna kaliva-nai wagaine ke gina alamane-dewedeweku.” ");
INSERT INTO bwd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yeisu taidei anafaiweya giifuifufu aku tonogala seyana anayegana Yudasa, banae keke Yudasa Isakaliyota aku wagakoyona, ani givona Yeisu wagaine, givonaga, “Kauveya, gavaiyamu-yo imeyavo gaga wagaimeya Tauni una ivemogatalini aku keke babi anakalivayavo moyaidi wagaidiya?” ");
INSERT INTO bwd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeisu givona, givonaga, “Kai gavakaliva ginuwakabubuyeku, aga bonaku gina abina. Ada Kamaku gina nuwakabubuyena, ada Kamaku ke Iyayeku nodi anaelai ana miyamiya banae wagaine ke nodi anave ebaga. ");
INSERT INTO bwd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aku gavakaliva keke gida nuwakabubuyeku ani bonaku keke gida abiabi. Taidei vona-dina wanoganogalidi ani Iya keke Tauku yaku vona, aku Kamaku giimiliku ani Banae yana vona. ");
INSERT INTO bwd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Iya imi aimo nodi kamiyamiya aku gaitoma taidei gavonayedi wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aku Tolema, Banae Aluwaluwa Tabuna ani Kamaku gina imilina ke yaku kabu gina vaina. Ada gaitoma moyaina gina vewalemi ke nuwami gina talafolena gavana anafaiweya gavonayena wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Iya tova moyaina nuwaniwalova wagaine gamiyamiya, ada yaku nuwaniwalova-nai taidei gana velemi. Ika, Iya gana segemi, aku yaku nuwaniwalova gina miyamiya wagaimiya. Kai babi anakalivayavo adifaiweya nuwaniwalova ina velemi aga nuwaniwalova-nai ani tova maufona wagaine gina avaina. Aku yaku nuwaniwalova gana velemi ani keke ginaavai. E ada taidei faina keke wana aseuloulolo, ada keke wana matauta. ");
INSERT INTO bwd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yaku vona wagaimiya bademowa wanogalina, gavona, ‘Iya gana segemi gananau, aku aimo ganayewa-vagileku wagaimiya.’ Ada kai Iya wanuwakabubuyeku aga yakuna Kamaku wagaine faina wada vemwamwala, faina Banae lakai-moena ayo Iyayeku. ");
INSERT INTO bwd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ada yaku tauya faina malinai gavonevone-vagaimi muliya-yo gaitoma-moena gina yegemona, e ada tova-nai gina yegemona, wana vetumagana. ");
INSERT INTO bwd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Keke aimo nodi kana ifuifufu tova manamanawena, faina babi anakalivayavo aditoveimeya gielaelai, bana Seitani. Banae yana toyogina ani keke maita anafata gina toyogisegeku, ");
INSERT INTO bwd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","aku gavaiyamu Kamaku giveimeyeku anafaiweya ani gagugaiyena tunutunugina, e ada babi anakalivayavo ina alamanena Kamaku ganuwakabubuyena. Wanaelai, fafali taidei kana segena aku kananau.” ");
INSERT INTO bwd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kaduwe Yeisu giifufu, givonaga, “Iyayeku gileifi bulavina velemoena, ada Bana Kamaku tobakula. ");
INSERT INTO bwd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ada laga seyana seyana itubo wagaikuya aku keke ida veguveguwa ani Kamaku gina taladobodi. Aku laga-dina iveguveguwa ani gina kidewedewedi ke ina veguwa moyaina velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Aku imiyavo ani vona-nai gavonayena wagaimiya ani wavetumaganena wagaine Iya gakidewedewemi, e ada bademowa yegayegamiyavo. ");
INSERT INTO bwd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Iya wagaikuya wana miyamiya ada imi wagaimiya gana miyamiya. Kai lagana keke gileifi bulavi-moena wagaine gina miyamiya aku gina miyadaka anakaibe tabae, aga keke anafata gina veveguwa. Kaduwe anafaiweya imiyavo. Kai keke Iya wagaikuya wana miyamiya, aga keke anafata wana veveguwa. ");
INSERT INTO bwd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iyayeku gileifi bulavina ada imiyavo ani lagaku. Gaito gimiyamiya Iya wagaikuya ada Iya gamiyamiya bana wagaine ani gina veveguwa lakaina. Aku kai keke bana gida miyami Iya wagaikuya, aga keke gina veveguwa, faina taumiyavo yami toyogina wagaine ani keke amifata gavana tamo wana gugaiye. ");
INSERT INTO bwd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kai gaito keke gida miyami Iya wagaikuya, banae anafaiweya gileifi bulavina lagana keke gida veguwa. Ada bulavidi lagadi keke ida veguwa ani tobakula gina taladobodi, ada inabovu muline, gina vagauwidi gina levadi ai alalata wagaine gina alaidi. ");
INSERT INTO bwd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Aku kai Iya wagaikuya wana miyamiya ada yaku vona ina miyamiya aseasemiya, aga gavana nuwanuwami ani wana veola faina ada gina yegemona faimiya. ");
INSERT INTO bwd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kai wana veveguwa moyaina, taine dewa-nai gina kiveyegemonimi vaita imi yaku tonogalayavo. E ada kaliva ina itana ke imi faimiya Kamaku anayegana ina kikilakaina. ");
INSERT INTO bwd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Iya Kamaku ginuwakabubuyeku anafaiweya, Iya kaduwe imi ganuwakabubuyemi. Wana miyamiya wagaikuya e ada tova moyaina yaku nuwakabubu wagaimiya wana lulutovonina. ");
INSERT INTO bwd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Iya Kamaku yana veimeya gaidibudibumwaigedi e ada yana nuwakabubu wagaine gamiyamiya. Taidei anafaiweya kaduwe, kai imi yaku veimeya waidibudibumwaigedi, e aga wana miyamiya yaku nuwakabubu wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Taidei gaitoma-dina Iya gavonevonemi e ada yaku vemwamwala gina miyamiya wagaimiya ke yami vemwamwala gina tubuga-mowa. ");
INSERT INTO bwd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Taidei yaku veimeya ani Iya ganuwakabubuyemi anafaiweya, imiyavo kaduwe gilubodami moyaimi nodi wana venuwanuwakabubu. ");
INSERT INTO bwd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Banae gaito tauna yawaina gina awaegena ke gina alika tubuiyanavo faidiya, ani banae velemoena ginuwakabubuyedi, ada taide yana nuwakabubu-nai ani lakai-moena. ");
INSERT INTO bwd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kai wana gugaiyena gavana gaveimeyemi, aga imi tubuiyakuweyavo. ");
INSERT INTO bwd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Keke aimo gada awavetogugaiyemi, aku gaawavetubuiyanemi. Faina togugai keke gida alamane velemoena gugai-nai yana toveimeya gigugugaiyena. Aku imiyavo waalamanena, faina gavana Kamaku givoneku, mamauwe gaifufuyena anamatatabuna wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Imiyavo ani keke Iya wada venuwadadaneku, aku Iyayeku imi gavenuwadadanemi ke yami faisewa anaveimeya gavelemi. E ada gilubodana wana yegemona wananau ke wana guwaguwa, ada guwa-nai ani gina yoyo-vagata. Ada gavana Tamada wana veolena akuyeganeya, taine gina velemi yami nuwanuwa anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ada taidei yaku veimeya ani imi taumiyavo nodi wana venuwanuwakabubu. ");
INSERT INTO bwd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kai babi anakalivayavo iagoagougemi, aga nuwami gida malina ani Iya imadu agougeku. ");
INSERT INTO bwd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kai imi babi anakalivayavo yadi yoo ada babi ananuwanuwa wada nuwakabubuyena anafaiweya badiyavo, aga imi kadu babi anakalivayavo ida nuwakabubuyemi anafaiweya tubuiyadiyavo. Aku imiyavo keke anafaiweya, faina Iya gavenuwadadanemi ke gavemiyadakami babi anakalivayavo moyaidi wagaidiya-deya. Taidei faina babi anakalivayavo iagougemi. ");
INSERT INTO bwd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Wana nuwaududuna yaku vona gavonayena wagaimiya, ‘Togugai ani keke ida kaiwabusege aditoveimeya.’ E ada badi Iya ikiveuloloniku ani imi kaduwe ina kiveulolonimi. Ada badi Iya yaku vona ivenogalena ani imi kaduwe yami vona ina venogalena. ");
INSERT INTO bwd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Imiyavo ani Iya yaku kalivayavo akuyegana wawaiwaidadanena e ada ina kikiveulolonimi, faina keke ida alamane Banae-nai giimiliku. ");
INSERT INTO bwd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kai keke gadaela gadavona wagaidiya aga Yaubada gida itadi vaita keke wa yadi koyona. Aku bademowa gaelai ada gavonedi aku bonaku keke ida venogale faina, badi wa yadi koyona imiyamiya. E ada keke adifaiweya tamo seba inasei yadi koyona faina. ");
INSERT INTO bwd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Banae-nai Iya giagougeku ani kaduwe giagougena Kamaku. ");
INSERT INTO bwd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Gugai ebameyasidobodobo tuwaina-deya keke tamo gaito gida faisewa ani Iya gafaisewadi badi adimwatugu wagaine, ada bade iitadi. Kai keke gugai-dina gada faisewadi aga kaduwe Yaubada keke gina itadi wa yadi koyona. Aku yaku gugai-dina bademowa iitadi nonogana Iyayeku ke Kamaku nodi iagougema, ada taidei faina bade koyona anavita inuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Au taidei anafaiweya badi iagougema e ada vona seyana yadi Buki Tabu givonayena ani giluveyegemonina velemoena, givona, ‘Keke tamo gavana yadi vuvu aku iagougeku.’ ");
INSERT INTO bwd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aku Bana Tolema gimiyamiya Tamada wagaine ani Aluwaluwa Tabuna, Bana nuwanuwa velemoena vuvuna giyegeyegemona Tamada wagaine-deya. Iya gana imilina ginaelai wagaimiya, ada tova-nai ginaelai ayo faikuya gina awatalatalaina. ");
INSERT INTO bwd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ada imiyavo kaduwe wana awatalatalaina Iya faikuya kaliva wagaidiya, faina yaku faisewa anaebavevuvu wagaine ke gielai tova malinai ani imiyavo Iya nodi. ");
INSERT INTO bwd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Gaitoma taidei moyaina gaifufuyedi ke gina kivetoyogimi, aenanai yami vetumagana anawai wana nuvuyoyena. ");
INSERT INTO bwd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Faina ina veyegemoni-vagaimi manuwa ebavewala wagaidiya e ada keke amiawaega wana lukuluku ke badi nodi wana oduodu. Velemoena, aimo tova gina yegemona wagaine kaliva ina luvealikami, aku ina nuwanuwa sidamana vaita tainei yadi gugai-nai wagaine Yaubada ikivemwamwalina. ");
INSERT INTO bwd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Gaitoma-dina taidei anafaiweya ina faisewadi faina badi keke Kamaku ida alamane, ada Iya kaduwe keke ida alamaneku. ");
INSERT INTO bwd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iya taidei gamaduvonemi e ada dewa-nai anatova-moena gina yegemona wagaine ayo wana nuwaududuna vaita Iya bade gamaduvonemi. Nago-moena wagaine Iya keke gada maduvonemi, faina aimo Iya nodi kamiyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Aku tova malinai ganaunau Banae giimiliku wagaine, ada vaita tamo gaito wagaimiya uda toliyeku udavona, ‘Gadedeku unauna?’ Aku keke seyana wagaimiya gida tolidadana. ");
INSERT INTO bwd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aku taidei anafaiweya gavona faina, nuwami givita lakaina. ");
INSERT INTO bwd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","E aku au yakuna anavelemoena gaifufuyena. Imi yami iwakana faina ada Iya gananau, faina kai keke ganana aga amiTolema keke ginaela wagaimiya. Taidei faina Iya gananau ada Banae gana imili ginaelai wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tova-nai Tolema-nai ginaelai, babi anakalivayavo gina vewaledi yadi dewa koyona faina, ada dewa yegayegana Yaubada matane, ada kaduwe gina kivemalina adimatavuloga yadi dewa koyona faine. ");
INSERT INTO bwd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Badi yadi dewa koyona gina vewaledi, tainei idewadewayedi faina keke ida vetumagana Iya wagaikuya. ");
INSERT INTO bwd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ada dewa yegayegana faina, tova-nai Iya gananau Kamaku Yaubada wagaine ada keke aimo wanaita-vagileku, aga taidei gina awavelemoenayena badi wagaidiya vaita Iya velemoena yegayegaku Yaubada matane. ");
INSERT INTO bwd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ada koyona anamatavuloga faina, Aluwaluwa Tabuna gina vewaledi vaita taudiyavo yadi koyona anamatavuloga gina yegemona. Velemoena gina yegemona, faina babi taide anakalivayavo aditoveimeya lakaina, banae Seitani, ani bademowa Yaubada giveimeya anamatavuloga-vagata faina. ");
INSERT INTO bwd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Aimo nuwanuwaku gaitoma moyaina gana ifufuyedi wagaimiya, aku adivita keke amifaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aku tova-nai Aluwaluwa Tabuna ginaelai, Banae nuwanuwa velemoena vuvuna, ani gina luvetuvetunumi e ada nuwanuwa velemoena anaalamana wana vaivaina. Keke tauna yana nuwenuweya gina ifufu aku gavana ginogalina Kamaku wagaine-deya, tainei gina ifufuyena. Ada kaduwe gavadi aimoina ina yegemona ani gina awamogataledi wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yaku nuwanuwa gina nogalina ke gina ivemogatalina wagaimiya, ada taidei wagaine akuyegana gina kilakaina kaliva matadiya. ");
INSERT INTO bwd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Gaitoma matatabuna gavana Kamaku wagaine ani matatabuna Iya wagaikuya kaduwe. Taidei faina Iya gavonemi, Aluwaluwa yaku nuwanuwa gina nogalina ke gina ivemogatalina wagaimiya.” ");
INSERT INTO bwd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yeisu kaduwe givona, “Tova maufona wagaine Iya gana segemi ada keke wana itaku, aku aimo keke tova manamanawena ada kaduwe wanaita-vagileku.” ");
INSERT INTO bwd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ada yana tonogalayavo tufodi ivetolitolidadana, ivona, “Gavana ananuwanuwa, givona, ‘Tova maufona wagaine Iya gana segemi ada keke wana itaku, aku aimo keke tova manamanawena ada kaduwe wanaita-vagileku’? Kaduwe gavana ananuwanuwa, givona, ‘Faina Iya ganaunau Kamaku wagaine’? ");
INSERT INTO bwd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ada kaduwe givona, ‘Keke tova manamanawena’. Ide keke kada alamane gavana givonavonaye.” ");
INSERT INTO bwd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Aku Yeisu bade gialamanena nuwanuwadi ina toliyena, e ada givona wagaidiya, givona, “Gavaiyamu imi wavetolitolidadana gavana faina Iya gavona, ‘Tova maufona wagaine Iya gana segemi ada keke wana itaku, aku aimo keke tova manamanawena ada kaduwe wanaita-vagileku’? ");
INSERT INTO bwd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Vona velemoena, gavona wagaimiya, tova-nai Iya gana segemi wagaine, imiyavo wana tagiya ke wanatagi-lunuwanuwai Iya faikuya, aku babi anakalivayavo ani tova-nai wagaine ina vemwamwala lakaina. Aku aimo tova kabisona ada kadu wana vemwamwala. ");
INSERT INTO bwd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kai vavine ina vefaedi yadi venatuna anatova giyegemona faina, aga wa yadi nuwavita faina ialamanena vitana. Aku tova-nai natuna gina tubuga wagaine, e au adiuloulolo adivita-nai ina venuwavuluyedi, faina natudi ivenatunena ke giyegemona evaguna babi wagaine ani ebavemwamwala-mowa badi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ee, anafaiweya kaduwe imiyavo. Tova malinai wagaine imi wa yami nuwavita, aku aimo gana yewaku ke ganaita-vagilemi e ada wana vemwamwala, ada yami vemwamwala-nai ani keke seyana gaito anafata gina vaiyavule. ");
INSERT INTO bwd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ada tayuwe wa yami vemwamwala anatova wagaine, nuwami gina malina gaitoma moyaidi faidiya e ada keke kaduwe wana tolitolidadaneku yaku ifufu anaalamana faina. Gavonemi velemoena, tova-nai wagaine gavana Kamaku wana veolena akuyeganeya, taine gina velemi yami nuwanuwa anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tova nagona wagaine ada gielai malinai ani keke wada veoveola akuyeganeya. Aku malinai ee wana veoveola ke wana nuwagana, e ada wana vemwamwala-mowa. ");
INSERT INTO bwd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gaitoma-dina taidei gaifufuyedi wagaimiya ani gavona matalivulivunayedi, aku tova gielaelai keke ganavona anafaiweya wagaimiya aku aiyada gana ifufuye-moena wagaimiya Kamaku faine. ");
INSERT INTO bwd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ada tova-nai wagaine keke gana vonemi vaita Kamaku gana veolena imi faimiya. Keke. Au imi taumiyavo-mowa wana veolena akuyeganeya. ");
INSERT INTO bwd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Faina Kamaku ginuwakabubuyemi. Ginuwakabubuyemi faina imi Iya wanuwakabubuyeku ada wavetumagana Iya gaelai Yaubada wagaine-deya. ");
INSERT INTO bwd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ika, velemoena gaelai Kamaku wagaine-deya ada gaobuelai babiya, ada tova malinai babi gana segena ke gana yewaku Kamaku wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ada yana tonogalayavo ivonena, ivona, “E, malinai ani au uifufuye-moena aku keke uda ifufu matalivulivuna. ");
INSERT INTO bwd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Taide malinai e nuwama bade gimalina vaita Oyeni gaitoma matatabuna ualamanedi. Kai kaliva nuwanuwadi ina tolidadaneni tamo gavana faine, aga yadi nuwanuwa ualamane-vagaidi, e ada keke tamo yadi vuvu ayo tolidadana inasei wagainiya. Taidei wagaine avetumagana velemoena Oyeni uelai Yaubada wagaine-deya.” ");
INSERT INTO bwd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeisu gilufata, givonaga, “Malinai-mowa wavetumagana velemoena, aiyo? ");
INSERT INTO bwd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aku tova kabisona, velemoena tova kabiso-moena ani moyaimi ina luveawaliyemi ke wanaota wananau seyana seyana taumiyavo yami manuweya, ada Iya akukaibe wana siloveku ganamiya. Aku keke velemoena akukaibe, faina Kamaku nodi amiyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ada au taidei anafaiweya gaifufu wagaimiya faina nuwanuwaku imiyavo wana miyamiya wagaikuya e ada wa yami nuwaniwalova wana miyamiya. Babi taidei wagaine vita tulina tulina wana nuwanuwagadi, aku wana asevatu, faina babi anavita anatoyogina moyaina bade gatoyogisegedi.” ");
INSERT INTO bwd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yeisu taidei anafaiweya givona giavaina, giitalaka gabama wagaine aku giveola, givonaga, “Kamaku, tova-moena bademowa giyegemona. Oye Natu anayegana una kilakaina e ada kadu Banae ayegana gina kilakaina. ");
INSERT INTO bwd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Faina kaliva moyaidi usedi Natu yana veimeya dibune, e ada badi kaliva-dina uvenuwadadanedi inaelai Banae wagaine ani yawai-vagata gina veledi. ");
INSERT INTO bwd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wai-nai wagaine kaliva yawai-vagata ina nuwagana ani taidei anafaiweya. Oye Yaubada velemoena akaibe-mowa ani ina alamaneni, ada kaduwe Iya Yeisu, Mesaiya-mekuna uimiliku gaobuelai babiya ani ina alamaneku. ");
INSERT INTO bwd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ada faisewa-dina uveleku ani galuyabudi e ada ayegana lakaina gaseyegemonena kaliva matadiya babi taidei wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ada Kamaku, tova tuwai-moena tova-nai babi aimo keke uda bubu-vaguvaguye, Iya Oye nodi kamiyamiya yada iwakana mamalina wagaine. E ada tova malinai nuwanuwaku Iya kaduwe Oye nodi kana miyamiya, ada tuwaina anafaiweya, tova malinai kaduwe yada iwakana mamalina unavele-vagileku. ");
INSERT INTO bwd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Aku badi kaliva-dina uvenuwadadanedi babi taidei wagaine ke uveleku, ani bade wagaidiya O gaivemogatalini. Nagona badiyavo O ya kaliva aku uawaegedi Iya wagaikuya, ada ya vona bade imatawalewaleyena. ");
INSERT INTO bwd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ada malinai bademowa ialamanena gaitoma moyaidi uveleku ani ielai O wagainiya-deya. ");
INSERT INTO bwd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Faina vona-dina uveleku ani gaawatalatalainena wagaidiya, ada wa yadi vemwamwala inogalina. Bade ialamanena velemoena Iya gaelai O wagainiya-deya, ada ivetumagana vaita Oyeni Iya uimiliku. ");
INSERT INTO bwd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ada badi faidiya Iya gaveoveola wagainiya. Keke babi anakalivayavo badi keke ya yooyavo faidiya gada veoveola, keke. Aku aiyada badi gavega uveleku ani faidiya gaveoveola, faina badi O ya yooyavo. ");
INSERT INTO bwd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Gavega moyaidi Iya yaku kalivayavo ani badiyavo O ya kalivamomo, ada badi ya kalivamomo ani kaduwe Iya yaku kalivayavo. Ada badiyavo akuyegana ikikilakaina ke yaku iwakana mamalina ikikiveyegemonina. ");
INSERT INTO bwd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iya keke tova manamanawena ganamiya babi taidei wagaine, faina tova kabisona gana segena ke ganaelai wagainiya. Aku badi yaku tonogalayavo ani idedeku babiya ina miyamiya badi O idibusoyogeni adimwatuguya. Kamaku Oyeni tabutabu. Ya nuwanuwa matatabuna ani yegayega-vagaidi. Ada gaveoleni una yavayavadi ayegana anatoyogina wagaine, tainei yegana-nai uveleku, e ada badi ina veseyana anafaiweya ide seyana. ");
INSERT INTO bwd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tova-nai aimo badi nodi amiyamiya, gayavadi ke gaitaveyabidi ayegana yana toyogina wagaine, ayegana-nai uveleku. Ada keke seyana gaito agolaufofola gida nuwaga aku kaliva seya-moena, banae ginaunau agolaufofola wagaine, e ada anafaiweya Buki Tabu gimaduvonayena ani gina yegemona velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Iya tova malinai ganaelai O wagainiya, ada aimo gamiyamiya babi taidei wagaine aku gaitoma-dina taidei gavonayedi yaku tonogalayavo matadiya. Faina Iya gavemwamwala lakaina, ada nuwanuwaku yaku vemwamwala ginamaga gina aiwaiwana badi wagaidiya e ada kaduwe ina vemwamwala. ");
INSERT INTO bwd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Oye ya vona bade gaveledi ada ivenogalena, e ada badi iveanafaiweya Iyayeku. Ada Iyayeku ani keke babi anakalivayavo adiyoo, ada kadu anafaiweya badi yaku tonogalayavo ani keke babi anakalivayavo adiyoo. Ada badi yaku tonogalayavo ani keke babi anakalivayavo adiyoo faina, babi anakalivayavo iagougedi. ");
INSERT INTO bwd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Keke gada veoveoleni vaita yaku yooyavo taidei unavai una nauwedi babi taidei wagaine-deya, aku aiyada velemoena ani una yavadi kaliva koyona Seitani wagaine-deya. ");
INSERT INTO bwd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Badi babi anakalivayavo ani Iya keke yadi yoo, ada kadu anafaiweya badi yaku tonogalayavo ani babi anakalivayavo keke yadi yoo. ");
INSERT INTO bwd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ya vona ani velemoena gagana. Ada ya vona velemoena udasena nuwainagediya e ada tabutabudiyavo O fainiya una seliyedi. ");
INSERT INTO bwd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tova tuwaina Iya uimiliku gaobuelai babi anakalivayavo adimwatuguya gamiyamiya, ada kadu anafaiweya Iya yaku tonogalayavo gaimilidi kaliva-dina adimwatuguya. ");
INSERT INTO bwd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Badi faidiya Iya Tauku gaawaegeku ke gaseliye-yabuku O wagainiya, e ada badi kaduwe taudiyavo ina awaegedi velemoena ke ina seliye-yabudi O wagainiya. ");
INSERT INTO bwd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Yaku veoveola ani keke taidei yaku tonogalayavo gaga faidiya. Gaveoveola kaduwe badi gavega ina vetumagana Iya wagaikuya badi yadi laumamala wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Gaveoveola ke moyaidi idaelai nuwanuwa seyana wagaine ida veseyana. Kamaku, O wagaikuya umiyamiya ada Iya kaduwe wagainiya gamiyamiya. Ada anafaiweya, nuwanuwaku badi ina miyamiya wagaideya ke nodi kana veseyana. E ada babi anakalivayavo moyaidi keke ida alamaneni ani badi ina itadi ke ina vetumagana velemoena O uimiliku gaobuelai. ");
INSERT INTO bwd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","O iwakana mamalina ani uveleku. Ada iwakana mamalina-nai uveleku ani kadu badi gaveledi. E ada Oye ke Iyayeku seyana anafaiweya, badi kaduwe ina veseyana. ");
INSERT INTO bwd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","E, Iya gamiyamiya badi wagaidiya ada Oyeni umiyamiya wagaikuya, e ada ina veseyana velemoena. E ada babi anakalivayavo moyaidi ina alamanena ani O uimiliku gaobuelai, ada kadu ina alamanena Iya unuwakabubuyeku anafaiweya, badi kaduwe unuwakabubuyedi. ");
INSERT INTO bwd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Kamaku, nuwanuwaku yaku kaliva-dina uveleku ani gadedeku Iya gana miyamiya ee badi nodi kadu ana miyamiya, e ada yaku iwakana mamalina ina itana. Tuwai-bulubuluna aimo babi matatabuna keke gida yegemo-vaguvagu anatoveya, O unuwakabubuyeku, ada taide faina iwakana-nai mamalina uveleku. ");
INSERT INTO bwd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kamaku-yo, Oye yegayega. Babi anakalivayavo O keke ida alamaneni, aku Iya gaalamaneni, ada badi taidei tonogala-dina ialamanena O uimiliku gaobuelai. ");
INSERT INTO bwd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Oyeni badi wagaidiya gaivemogatalini ada kadu tova moyaina gana ivevemogatalini wagaidiya, e ada taidei nuwakabubu-nai wagaine unuwakabubuyeku ani gina miyamiya wagaidiya e ada kaduwe Iya Tauku gana miyamiya wagaidiya.” Taidei anafaiweya Yeisu yana veola Tamana wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yeisu giveoveola giavaina, yana tonogalayavo nodi itauya inau ada iobu bwagala-nai anayegana Kidiloni idamanina. Ada wadedeku fafaline ani ai olive ibakulidi anafafali, ada Bana yana tonogalayavo nodi iluku wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aku Yudasa, bana Yeisu gina atuegena nibainavo nimadiya ani ebaga-nai kadu gialamanena, faina tova ke tova wadedeku-deya Yeisu yana tonogalayavo nodi inauna ivagavagauta. ");
INSERT INTO bwd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","E au bana Yudasa fafali-nai waina yoo ginagoyedi. Yoo-nai ani Loma anatolugaviya adiyoo seyana ke kaduwe, manuwa tabu anafilisimani tufodi badi Falisiyavo, ke veyavo anatovegugai lakaidiyavo iimilidi. Ada odama ke mayale ada lokoloko gaviya iwaidi inauwedi, e ada nodi iyegemona ebaga-nai wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeisu bademowa gialamanena gavana moyaina ina yegemona Bana wagaine, e ada givaga-yegemona gitolidadana, givona, “Gaito walelele?” ");
INSERT INTO bwd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Badi ilufata, ivonaga, “Yeisu, kwana Nasaledi.” Ada Bana Yeisu givonaga, “Iya kaliva-moeku Tauku.” Ada Yudasa bana nuwanuwana Yeisu gina atuegena badi nimadiya ani wadedeku nodi imidimididi. ");
INSERT INTO bwd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tova-nai Yeisu givonedi, “Iya kaliva-moeku Tauku,” ani badi au ivaga-yewayewa ada ibeu babiya. ");
INSERT INTO bwd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Taidei faina kaduwe gitolidadanedi, givona, “Gaito walelele?” Ada badi kadu ilufata, ivona, “Yeisu, kwana Nasaledi.” ");
INSERT INTO bwd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeisu givonaga, “Bade gavonemi, ‘Iya kaliva-moeku Tauku’. E ada kai Iya kaliva-kuna waleleleku aga kaliva-dina taidei wana imilidi inanau.” ");
INSERT INTO bwd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Taidei anafaiweya givona faina yana veola-nai gimadu vonayena Tamana wagaine ani gina luveyegemonina velemoena, givonaga, “Kaliva-dina uveleku ani keke tamo gada nusege.” ");
INSERT INTO bwd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aku Saimoni-Pita, banae yana benisi giwaina ani gisiwakana ada kaliva seyana tagana aiyatagina gitalayoe gibeu. Bana kaliva-nai ani veyavo anatovegugai aditonagona yana togugai seyana, anayegana Malekasi. ");
INSERT INTO bwd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yeisu Pita givonena, “Ya benisi una seyewena anafoseya! Vei-nai Kamaku gisena faikuya ani gavaiyamu, nuwanuwa keke ganayuge?” ");
INSERT INTO bwd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ada tolugaviya adiyoo-nai wa aditonagona nodi ada kaduwe manuwa tabu anafilisimani-dina, ani biyavo-dina au Yeisu ikiveyabi nimana iyogodi, ");
INSERT INTO bwd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ada imadunauwena Anasi wagaine ke Yeisu yana vona gina nogalina. Anasi-nai ani Kaiyafasi vavinena tamadi. Aku Kaiyafasi tauna ani malamala-nai wagaine banae veyavo anatovegugai aditonagona. ");
INSERT INTO bwd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Bana Kaiyafasi ani banae-nai boi meIsileli tonagonayavo giluwageyedi, givona, “Kai kaliva seya-moena gida alika moyaida faideya aga iwakana.” ");
INSERT INTO bwd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Aku Saimoni-Pita ada kadu tonogala seyana adiselu atuwadeya Yeisu imulimuliyena, ani inau ada iyegemona veyavo anatovegugai aditonagona yana manuweya. Aku tonagona-nai ani tonogala-nai anavelu gialamanena, e ada banae Yeisu nodi iluku kali anawana wagaine, ada moyaidi imiyamiya Bana nodi, ");
INSERT INTO bwd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","aku Pita banae wamelaleya kali anawana wagaine gimidimididi. Ada tonogala anavelu banae veyavo anatovegugai aditonagona gialamanena, ani giyewa togugai vavine wana giitaitaveyabina ke givonena wana gida yavuna, e ada Pita givagaule kadu giluku. ");
INSERT INTO bwd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aku bana vavine-nai gitolidadanena Pita, givona, “Kai anaita oye ani kadu kaliva taidei yana tonogala seyana, aiyo?” Bana Pita gilufata, givona, “Iya, keke.” ");
INSERT INTO bwd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aku tayuwe tova-nai tulutulu anatova, e ada manuwa-nai anatogugaiyavo ke filisimaniyavo nodi ai ikulina ada imidififi ivevevala, ada Pita kadu nodi imidimididi aku ai givalavalana. ");
INSERT INTO bwd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ada Pita ani givevevala ai wagaine aku tayu manuwa-nai negenine-deya, bana veyavo anatovegugai aditonagona Anasi Yeisu gitoliluvaluvayena yana tonogalayavo faidiya ke kaduwe gavana kaliva givevewaledi faina. ");
INSERT INTO bwd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Bana Yeisu gilufata, givona, “Tova moyaina gavana gavevewala ani mogamogatalina kaliva moyaidi matadiya ada kaduwe manuwa ebavewala wagaidiya ke manuwa tabu wagaine, wadedeku-deya meIsileli moyaidi ivagavagauta. Keke tamo yaku vona gada vonaye ikavuya-deya. ");
INSERT INTO bwd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","E aku gavaiyamu-yo Iya utoliluvaluvayeku? Badi gavega ivanevanenegeku una toliluvaluvayedi. Badiyavo ialamanena gavana gavonavonaye.” ");
INSERT INTO bwd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Taidei anafaiweya Yeisu givona, ada au manuwa tabu anafilisimani seyana gimidimididi lilivane ani gitafina magigina wagaine ada givonena, givonaga, “Gavaiyamu ada taide anafaiweya Yaubada yana veyavo anatovegugai lakaina wagaine ulufata? Keke uda vemoimoine, aiyo?” ");
INSERT INTO bwd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aku Yeisu gilufata, givona, “Kai yaku vona-nai koyona aga una awatalatalaina koyona-nai Iya gafaisewana. Aku kai gavona tunutunugina aga gavana faina utafiku?” ");
INSERT INTO bwd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ada au Anasi Bana Yeisu nimana aimo yogoyogona giimili ginau Kaiyafasi wagaine, banae veyavo anatovegugai aditonagona. ");
INSERT INTO bwd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","E aku Saimoni-Pita aimo gimidimididi aku givevevala ani tufodi nodi ivevevala ivonena, ivona, “Gavaiyamu, kai oyeni ani kadu yana tonogala seyana, aiyo?” Aku Pita giveweyena ada givona, “Iya keke.” ");
INSERT INTO bwd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Aku veyavo anatovegugai lakaina yana togugai seyana, banae yana gabu seyana tagana Pita gilugoloina ani kaliva-nai gimididi Pita givonena, givonaga, “Aiyo, o vaita gada itani boi bana kaliva-nai nodi ai olive anafafali wagaine?” ");
INSERT INTO bwd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kadu Pita givewa-vagila ani kamukamu gikwage. ");
INSERT INTO bwd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Malabutuya-mwaeya Yeisu anavevonayavuga Kaiyafasi matane giavaina, ada Yeisu ivaina Kaiyafasi yana manuweya-deya ada inauwena aditoveimeya lakaina yana manuwa wagaine, anayegana Pailato. Banae toveimeya-nai keke kwana Isileli, ada taidei faina meIsileli-dina ikwayabudi nodi inau ani ivonaga, “Kai kanaluku kwana Loma yana manuweya aga adaawata kana yawelina, ke taudeyavo kana kivebwaneneda Yaubada matane e ada keke adafaiweya Nugulina Abutuna ana aa kanakani.” Taidei faina biyavo-dina imiya wamelaleya. ");
INSERT INTO bwd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ada badi keke idaluku faina, Pailato giyegemona gielai wagaidiya gitolidadanedi, givona, “Gavana tamo koyona giveinubaye kaliva taidei wagaine, e ada faina waaliye?” ");
INSERT INTO bwd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Badi ilufata, ivonaga, “Kai Banae velemoena keke koyona gida faifaisewa aga keke ada aliye ada atuege wagainiya.” ");
INSERT INTO bwd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ada Pailato givonedi, givona, “Au imi taumiyavo wanavai wana nauwena ke taumiyavo yami veimeya wagaidiya wana vevonayavugina.” Aku badi meIsileli ilufata, ivonaga, “Aku imi meLoma yami veimeya wasena ime meIsileli faimeya e ada keke wa amaawaega taumeyavo ana veimeya ke kaliva ana luvealika.” ");
INSERT INTO bwd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Taidei yadi vona-nai ani Yeisu yana vona giluveyegemonina velemoena, tova-nai gimadu vonayena gavaiyamu yana alika-nai gina alikaye. ");
INSERT INTO bwd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ada Pailato giluku-vagila manuwa wagaine ada gidouwedi Yeisu ialiyena wagaine ada gitoliyena, givona, “Gavaiyamu, velemoena Oyeni meIsileli yadi Kini?” ");
INSERT INTO bwd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeisu gilufata, givona, “Gavaiyamu, tainei tauni ya nuwenuweya ada anafaiweya uvona, o kai mali kaliva ivoneni Iya faikuya?” ");
INSERT INTO bwd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailato givonena, givona, “Iya keke kwana Isileli! E ada gavaiyamu gana alamane taide nuwanuwa-dina? O Tauni ya kalivamomo ke kadu veyavo anatovegugai lakaidiyavo, e biyavo-dina ialiyeni ada iatuegeni Iya wagaikuya. Gavana tamo koyona ugai?” ");
INSERT INTO bwd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ada Yeisu gilufata, givona, “Yaku ebaveimeya ani vuvuna keke babi taide wagaine-deya. Kai vuvuna gida miyamiya babi taidei wagaine aga yaku togugaiyavo ida mididi ida lugaviya ke ida babaliku, e ada meIsileli aditonagonayavo keke adifaiweya ina kiveyabiku. Aku keke. Yaku ebaveimeya vuvuna ani keke babi taidei wagaine-deya.” ");
INSERT INTO bwd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ada Pailato givona, “E ada gavaiyamu, velemoena Oye seyana kini?” Yeisu givona, “O tauni uvona Iya kini. Aku velemoena vuvuna-nai faine gaelai babi taidei wagaine ada kadu vuvuna-nai faine gatubuga ani nuwanuwa velemoena gana awamogatalena kaliva wagaidiya. Ada badi gavega nuwanuwadi nuwanuwa velemoena ani bonaku ina noganogalina.” ");
INSERT INTO bwd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailato gitolidadana, givona, “Aku nuwanuwa velemoena ani gavana?” Taidei anafaiweya givona ada giyegemona wamelaleya meIsileli-dina wagaidiya ada givonedi, givona, “Iya keke tamo koyona gada nuwaga Banae wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Waitana, tova malinai ani Nugulina Abutuna, ada yami dewa malamala seyana seyana ani taidei Abutu-nai anatoveya kaliva yogoyogona seyana deli wagaine gana etoyavuna ginaobu wagaimiya. E ada gavaiyamu, nuwanuwami Banae meIsileli yami kini gana etoyavuna?” ");
INSERT INTO bwd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aku badi iagofaifaina-vagila, ivona, “Keke! Keke Banae kaliva-nai! Una velema Balabasi!” Aku Balabasi bana tubuiyanavo nodi gaviya isisilakaina Loma anakabemali wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Aku Pailato bade yoo yadi vona ginogalina e ada giveimeya ke tolugaviya Yeisu ilubibiwalina. ");
INSERT INTO bwd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kaduwe bulava akakaluluna imetana ke kuluwane isena vaita kini anakedukedu kaikaiwabuna anafaiweya, ada nuya yabeyabelina iveosena vaita kiniyavo adinuya manamanawena anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","E aku inauna Banae wagaine iawaveleiga ivonavona, “Siule! Oyeni meIsileli yadi Kini!” Ada nimadiya itututuna. ");
INSERT INTO bwd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Aku Pailato nuwanuwana Yeisu gina etoyavuna, e ada kaduwe giyegemona wamelaleya ada meIsileli wagaidiya givona, “Wana itana. Kaliva taidei gaalialiyena wagaimiya e ada wana alamanena ani Iya keke seyana yana koyona gada nuwaga wagaine.” ");
INSERT INTO bwd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ada Yeisu wa anakedukedu akakaluluna ke nuya luveyalilina yabeyabelina ani giyegemona gielai. Ada au Pailato kaliva wagaidiya givona, “Wana itana kaliva-moena!” ");
INSERT INTO bwd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aku veyavo anatovegugai lakaidiyavo ke manuwa tabu anafilisimaniyavo nodi Yeisu iitana wagaine, ivebutu iagofaifaina, ivonaga, “Una kivebolagalagana! Una kivebolagalagana!” Aku Pailato givonedi, givona, “Imi taumiyavo wanavai wana nauwe wana kivebolagalagana. Iyayeku ani keke tamo koyona vuvuna gada nuwaga Banae wagaine ayo gana veimeya anamatavuloga faine.” ");
INSERT INTO bwd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aku badi meIsileli iselakalaka-mowa, ivona, “Ime wa yama veimeya, ada veimeya-nai faina gilubodana Banae gina alika, faina Banae Tauna gikilakaina evona vaita Banae Yaubada Natuna.” ");
INSERT INTO bwd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aku Pailato taidei ginogalina wagaine, au gimatauta koyokoyo-mowa. ");
INSERT INTO bwd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ada au giyewa giluku manuwa wagaine ke Yeisu gitolidadanena, givona, “O gavafafali wagaine?” Aku Yeisu keke tamo laufata gida vonaye, au giveyamata-mowa. ");
INSERT INTO bwd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailato givonena, givonaga, “Gavaiyamu-yo keke uda lufata wagaikuya? Maita ualamanena Iya wa yaku veimeya ke gana etoyavuni ada kadu wa yaku veimeya ke gana kivebolagalagani?” ");
INSERT INTO bwd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeisu gilufata, givona, “Kai Yaubada keke veimeya gida veleni ke una veimeyeku, aga oye keke afata gavana tamo udagai wagaikuya. Aku kaliva-nai giseku nimaniya ani bade gigugai wagaikuya yana nuwanuwa anafaiweya, aku oye ani keke nuwanuwa una gugaiye. Taidei faina banae yana dewa koyo-moena ayo ya dewa.” ");
INSERT INTO bwd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailato tayuwe vona-dina ginogalidi wagaine, ada nuwanuwana lakaina Yeisu gina etoyavuna, aku meIsileli keke nuwanuwadi ada agofaifaina ikwageye-moena, ivona, “Gavakaliva tauna gina kilakaina vaita banae kini e ani givevenibaina Sisa wagaine. E ada kai kaliva taidei una etoyavu ginanau aga oyeni aimo keke Sisa tubuiyana.” ");
INSERT INTO bwd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ada Pailato yadi vona ginogalina ada toyavaga giveimeyedi Yeisu ivagaule iyegemonena wamelaleya yoo Isileli matadiya. Ada Pailato givetogana vevonayavuga anaivi wagaine, fafali-nai anababi kabala beyabeyadi lakaidi wagaidiya ikiwafina. Taidei fafali-nai meIsileli bonadiya ivewagana ‘Gabata’. ");
INSERT INTO bwd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tayuwe tova-nai ani Nugulina Abutuna anawiki, ada yadayada-nai kidewadewa anatova faina ada bademowa kauwana givugivudiya. Ada Pailato meIsileli wagaidiya givona, “Wana itana, taidei yami Kini!” ");
INSERT INTO bwd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aku badi iagofaifaina, ivonavona, “Unavai una nauwena! Una nauwe una kivebolagalagana!” Pailato givonedi, givona, “Gavana? Banae yami Kini nonogana nuwanuwami gana kivebolagalagana?” Aku veyavo anatovegugai lakaidiyavo ilufata, ivona, “Keke tamo gaito yama kini aku Sisa anakaibe-mowa.” ");
INSERT INTO bwd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","E ada au Pailato ginogali-yo Yeisu giatuegena wagaidiya ke ina kivebolagalagana. Ada badi tolugaviya Yeisu au ivai iveimeyena ");
INSERT INTO bwd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ada anakelose iveavalana. Ada Tauna giwai nodi iyegemona Yelusalema anakali anawana wagaine, ada ilaka inau fafali ivewagana ‘Kuluwa Sewakelu Anafafali’. E, meIsileli bonadiya ivewagana ‘Goligota’. ");
INSERT INTO bwd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ada wadedeku-deya Yeisu ikivebolagalagana. Aku kaduwe kaliva adiselu nodi ikivebolagalagadi, seyana fafaline kadu seyana fafaline aku Yeisu nefanidiya gimiya. ");
INSERT INTO bwd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ada Pailato matawa seyana givetokilumina ke Yeisu anakelose kuluwane itutuvefosena. Ada anaveyawa taidei anafaiweya givona, “YEISU KWANA NASALEDI, MeISILELI YADI KINI.” ");
INSERT INTO bwd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Fafali-nai Yeisu ikivebolagalagana ani Yelusalema edaubo, e ada meIsileli tufona moyaidi inauna iyaiyaya-nai iveyaveyawana. Ada iyaiyaya-nai anavetokiluma ani meya toiye wagaidiya, meIsileli yadi vona Alamaiki, vona Latini, ada vona Giliki. ");
INSERT INTO bwd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","E aku veyavo anatovegugai lakaidiyavo iyaiyaya iitana ayo ivona Pailato wagaine, ivona, “Keke anafaiweya una vetokilumi, ‘MeIsileli yadi Kini’. Aku taide anafaiweya una vetokilumina, ‘Kaliva taidei givona, Iya MeIsileli yadi Kini.’” ");
INSERT INTO bwd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Aku Pailato gilufata, givona, “Gavana gavetokilumina, ginamiya anavetokiluma.” ");
INSERT INTO bwd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aku tolugaviya Yeisu ikivebolagalagana ani adiyoo laufuli. Ada ikivebolagalaga giavaina, badi ananuya ivaidi ke taudiyavo wagaidiya ivutugedi bou laufuli wagaidiya. E ada kaliva seyana seyana anavutuga isena, aku ananuya manamanawena gitufo. Taidei nuya-nai ani keke tamo wa anaavi, aku au iyogona nuya seya-moena wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Taidei faina ada taudiyavo iveifuifufu, ivona, “Auwe keke kana kelili aku kabala anaselakalakata wagaine anavenuwadadana kana itana gaito ginavai.” Au taidei anafaiweya tolugaviya ifaisewana, e ada Buki Tabu yana vona seyana gina yegemona velemoena, givonaga, “Badi akunuya ivutugedi taudiyavo wagaidiya, ada akunuya manamanawena faine kabala anaselakalakata wagaine ivenuwadadana gaito ginavai.” ");
INSERT INTO bwd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Aku Yeisu anakelose lilivane vevine tufodi imidimididi, badi inana ke inana aditubuluga, ada kadu Meli badi Kelofasi vavinena, ada Meli vine Magidala. ");
INSERT INTO bwd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tova-nai Yeisu inana giitadi ada tonogala-nai bana ginuwakabubuyena giitana lilivadiya gimidimididi, e ada inana wagaidiya givona, “Inaku, taidei natumi.” ");
INSERT INTO bwd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ada tonogala wagaine givona, “Uitana, ina taidei.” Ada tayuwe tova-nai wagaine tonogala-nai givagauledi ginauwedi yana manuweya nodi imiyamiya ada giitaveyabidi. ");
INSERT INTO bwd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ada Yeisu gialamanena gaitoma moyaidi Yaubada yana nuwanuwa anafaiweya bademowa giluyabudi, e ada givona, “Meyaku gikwakwa.” Taidei anafaiweya givona ke Buki Tabu yana vona gina yegemona velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ada wadedeku kelose lilivane ani waini gikoyo wa tuwavina gimiyamiya, e ada balou ivai iutuvina waini-nai gikoyo wagaine, ada ai isofa lagana wagaine balou ive etoonana ada itune lakavena ke Bana awane isena. ");
INSERT INTO bwd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yeisu waini koyona-nai giyui giavaina, givona, “Akufaisewa bademowa galuyabuna.” Tayuwe wagaine ada kuluwana giatago-moe giobu aku Yaubada wagaine aluwaluwana giawaegena ada au gialika. ");
INSERT INTO bwd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","E, Yeisu gialika aku yadayada-nai tainei ani kidewadewa anatova ada mala gina lavuna taine yadi Sabate lakaina, faina Sabate-nai ani Nugulina anaSabate. Ada meIsileli aditonagonayavo keke nuwanuwadi Sabate wagaine toalika-dina vovodi kelose wagaidiya ina miyami. Taidei faina inau ada Pailato iveolena ke tolugaviya gina veimeyedi ke kaliva-dina adikelose wagaidiya ani agedi ina dobodi e ada ina madualika aku vovodi ina kakilidi ina nauwedi. ");
INSERT INTO bwd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Taidei faina tolugaviya ielai ke kaliva-nai nagona imadu kivebolagalagana ani agena idobodi, ada kadu inau ke kaliva anavelu agena idobodi. ");
INSERT INTO bwd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aku tova-nai ielai Yeisu wagaine ida itana ani inuwagana bademowa gialika, e ada keke agena idadobo. ");
INSERT INTO bwd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Aku tolugaviya seyana yana giyo wagaine Yeisu ibaimina gionana, ada maduga-mowa gufa ke dayaga imadu-tamwai. ");
INSERT INTO bwd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","E, Iya Iyoni ani tauku matakuya gaitana e ada gaawamogatalena, faina nuwanuwaku imi kaduwe wana vetumagana. Yaku ifufu au velemoena, keke tamo fwaya wagaine, ada gaalamanena vona velemoena gaifufuyena. ");
INSERT INTO bwd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ada tolugaviya taide anafaiweya Yeisu idewena e ada vona-nai Buki Tabu wagaine ivetokilumina ani gina yegemona velemoena, givona, “Keke tamo seyana luluna inadobo.” ");
INSERT INTO bwd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ada kadu vona seyana Buki Tabu wagaine givonaga, “Bana kaliva-nai ililina ani ina itana.” ");
INSERT INTO bwd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Aku kaliva seyana gimiyamiya anayegana Iyosefa, banae kwana Alimatiya. Banae kaduwe givetonogala Yeisu wagaine aku ikavuya-deya, faina meIsileli aditonagonayavo gimatausedi. Ada banae ginau Pailato wagaine ke giveolena Yeisu vovona faina, ada au Pailato yana awaega wagaine, Iyosefa ginau ke Yeisu vovona givai ginauwena. ");
INSERT INTO bwd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kadu Nikodimo, banae nagona bogi seyana wagaine gina Yeisu gimadubodana ani Iyosefa adiselu inau. Ada bana Nikodimo ginauwena bunama seyana ani mulo ke aloisi nodi ilomwanina wagaine e ada magana iwakana. Anavita anafaiweya teti faifi (35) kilo. ");
INSERT INTO bwd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ada badi adiselu Yeisu vovona ivai inauwena ada nuya kwayakwaya-moena diyana aku manamanawena bunama-nai nodi ifai-tamwaina. Taidei meIsileli yadi atavutavuna anagiduwa anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Aku fafali-nai Yeisu ikivebolagalagana ani lilivane ai analoi imidimididi, ada ai-dina afaine ani didikula evaguna gimiyamiya. Didikula-nai ani kabala beyabeyana yavoyavoline aku italafolena ke luwa lakaina ibubuna, wada keke seyana toalika vovona idasei wagaine gidada. ");
INSERT INTO bwd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ada tayuwe yadayada-nai ani meIsileli yadi Sabate anakidewadewa anayadayada, ada didikula-nai lilivadiya faina, wadedeku Yeisu vovona ivedauvina. ");
INSERT INTO bwd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ada Sabate bade giavaina aku Sanidei aimo malalavuga ani Meli vine Magidala ginau didikula luwa wagaine, ada giitana kabala ivai iseliyena anawana wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Au gimaduga ada giyewana Saimoni-Pita ke tonogala velugana banae-nai Yeisu ginuwakabubuyena ada givonedi, givona, “Kauveya vovona ivaina didikuleya-deya ada keke ada alamane gadedeku-deya isei!” ");
INSERT INTO bwd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","E ada Pita ke tonogala-nai velugana yana vona inogalina wagaine ada ivebutu imaduga didikula luwa ina itana faina. ");
INSERT INTO bwd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Adiselu ivemadumaduga aku tonogala-nai velugana ani gimadusegena Pita, ada banae gimaduyegemona didikula luwa wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ada ginau anawana wagaine gilukenala ke giitaluku giitana nuya-dina kwayakwaya-moedi wagaidiya Yeisu vovona ifaina ani wadedeku imiyamiya. Aku keke gidaluku didikula negenine. ");
INSERT INTO bwd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aku Saimoni-Pita wai gimulina ada giyegemona ke tunutunugina giluku didikula luwa wagaine ani giitadi anafai nuya kwayakwaya-moedi imiyamiya, ");
INSERT INTO bwd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kadu nuya-nai wagaine Yeisu kuluwana ikiwafina ani giitana, aku keke anafai nuya kwayakwayadi nodi aku tabae gimiyamiya, ada uwauwana. ");
INSERT INTO bwd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ada tonogala velugana wai ginagona didikula luwa wagaine ani kaduwe giluku, ada giitana ke givetumagana. ");
INSERT INTO bwd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Faina Buki Tabu wagaine ivetokilumina ani gilubodana Yeisu ginayawa-vagila alika wagaine-deya. Aku vona-nai ananuwanuwa badi aimo keke nuwadi gidamali. ");
INSERT INTO bwd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ada tonogalayavo adiselu au iyewadi inau yadi manuweya. ");
INSERT INTO bwd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Aku Meli bademowa giyewana didikula luwa wagaine ada gimididi wamelaleya gitagitagiya. Ada aimo gitagitagiya aku gina giiboiboula didikula luwa negenina giitaitana ");
INSERT INTO bwd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ani au anelose iluwei giitadi adinuya kwayakwayadi ivetovetoga fafali-nai wagaine boi Yeisu vovona isena. Seyana kuluwane givetoga ada seyana agene givetoga. ");
INSERT INTO bwd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ada anelose-dina Meli itolidadanena, ivonaga, “Gavaiyamu-yo utagitagiya?” Banae gilufata, givona, “Yaku Kauveya vovona ivai inauwena, ada gadedeku-deya isena ani keke gada alamane.” ");
INSERT INTO bwd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ada givona giavaina, gida miyavilana ani giitana kaliva seyana gimidimididi muline. Banae Yeisu, aku keke gida inana. ");
INSERT INTO bwd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aku Yeisu givonena, givonaga, “Vavine, gavaiyamu-yo utagitagiya? Gaito ulelele?” Meli yana nuwanuwa vaita banae bakula-nai anatofaisewa, e ada givonena, givona, “Kauveya, kai yaku Kaiwabu vovona uwai unauwena, aga una voneku gadedeku-deya usei ada ganana ganavai gana nauwena.” ");
INSERT INTO bwd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ada au Yeisu givonena, givonaga, “Meli.” Ada banae au gimiyavilana wagaine ada meIsileli meyadiya givona, “Labonai!” Taidei anakivila ani ‘tovewala lakaina’. ");
INSERT INTO bwd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeisu givonena, givona, “Keke una kiveyabiku, faina aimo keke gadalaka Kamaku wagaine. E aku unanau tubuiyakuweyavo wagaidiya ada una vonedi, ‘Yeisu givona, Iya galakalaka Kamaku wagaine, Banae kadu imi Tamami, ada yaku Yaubada wagaine, Banae kadu imi yami Yaubada.’” ");
INSERT INTO bwd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ada Yeisu giifufu giavaina, Meli vine Magidala gitauya ginau tonogalayavo wagaidiya ada giawamogatala, givona, “Kauveya gaitana!” Ada gavana Yeisu givonayedi wagaine ani kaduwe giifufuyedi. ");
INSERT INTO bwd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ada yadayada-nai wagaine kauwana bademowa giolu ada mala gibogi, taine wiki anayadayada nagona ani badi tonogalayavo ivagauta seyana manuwa wagaine aku meIsileli aditonagonayavo imatausedi faina, manuwa anawana ilokadi. Ada wana lokalokadi aku au Yeisu gimidiyegemona adimwatuguya ada givona, “Nuwaniwalova wagaimiya!” ");
INSERT INTO bwd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Taidei anafaiweya givona ada anabwaya nimana ke ibaimina wagaidiya givewaledi. Ada Bana iitana ada iinanana Banae yadi Kauveya, ada ivemwamwala-mowa. ");
INSERT INTO bwd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ada kaduwe Yeisu givona wagaidiya, givona, “Nuwaniwalova wagaimiya! Kamaku giimiliku gaelai anafaiweya, ada imi kaduwe gaimiimilimi wananau tomiyababi adimwatuguya.” ");
INSERT INTO bwd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ada givona giavaina, yawaina gitunevedamana wagaidiya ada givona, “Aluwaluwa Tabuna wana nuwagana. ");
INSERT INTO bwd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kai gavega yadi koyona imi wana venuwaegedi aga kadu Yaubada yadi koyona gina venuwaegedi. Aku kai yadi koyona keke wana venuwaege aga kadu Yaubada badi yadi koyona keke gida venuwaege.” ");
INSERT INTO bwd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aku tonogala seyana, banae Yeisu yana yoo tuwelo wagaidiya anayegana Tomasi ani tova-nai Yeisu giyegemona badi wagaidiya, bana Tomasi-nai ani keke nodi ida miyami. Kaliva-nai anayegana anavelu ani Didimasi. ");
INSERT INTO bwd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ada bademowa Yeisu tonogalayavo gisegedi aku aimo-yo bana Tomasi gielai wagaidiya ke ivonena, ivona, “Kauveya bade aitana!” Aku banae givona wagaidiya, givona, “Keke-mowa! Keke akufaiweya gana vetumagane. Aku kai neli awaivina nimana wagaidiya gana itadi ada nimaku ganasena wagaidiya, ada kaduwe kai nimaku ganasena ibaimina wagaine giyoya ionana, e, taidei wagaine gana vetumagana.” ");
INSERT INTO bwd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ada aimo yadayada eita giavaidi aku kaduwe badi yana tonogalayavo ivagauta-vagila manuwa negenine imiyamiya, ada tainei tova-nai ani Tomasi nodi. E aku wana ani lokalokadi aku au Yeisu giyegemona ada gimididi adimwatuguya aku givonaga, “Nuwaniwalova wagaimiya.” ");
INSERT INTO bwd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ada givona Tomasi wagaine, givona, “Nimadidi unasena idedeku, ada nimaku una itadi, ada kaduwe nima una selukuwena akukima ibaimikuya. Nuwakila auwe unasena aku una vetumagana-mowa.” ");
INSERT INTO bwd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi givonaga, “Velemoena. Oyeni yaku Kauveya ada yaku Yaubada!” ");
INSERT INTO bwd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ada Yeisu givonena, givona, “O uitaku faina uvetumagana. Aku badi gavega keke ida itaku aku au ivetumagana ani Yaubada giawanuwakabubuyedi.” ");
INSERT INTO bwd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Aku Yeisu kadu gugai ebameyasidobodobo moyaidi gifaisewadi yana tonogalayavo matadiya, aku keke matatabudi gada vetokilumidi buki taidei wagaine. ");
INSERT INTO bwd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Aku gugai-dina taidei buki-nai wagaine ani gavetokilumidi e ada imi wana vetumagana vaita Yeisu Banae velemoena Mesaiya ada Yaubada Natu-moena, e ada yami vetumagana wagaine yawai velemoena wana nuwagana Tauna anayeganeya. ");
INSERT INTO bwd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Aku aimo seyana tova Yeisu kaduwe Tauna giivemogatalina yana tonogalayavo wagaidiya Lavu Tibeliya anataliya wagaine. Taide anafaiweya Tauna giivemogatalina. ");
INSERT INTO bwd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tonogalayavo adiseveni wadedeku-deya ani Saimoni-Pita, Tomasi banae ivewagana Didimasi, Nataniyela kwana Kena taine Galili anafafali wagaine, Sebedi natunavo adiselu, ada kaduwe tonogalayavo adiselu nodi. ");
INSERT INTO bwd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Aku bana Saimoni-Pita givonedi, givonaga, “Iya ganauna gana guvata.” Ada badi ivona, “Ime nodi kananau.” E ada itauya iobu lavu wagaine ada waka wagaine iyage inau. Ada iyubau bogi matatabuna eee mala gilavuna, aku iyuba-wayoga. ");
INSERT INTO bwd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ada au mala gilavuna malabutuya-mwaeya ani Yeisu gimidimididi taliyeya, aku tonogalayavo keke maita ida inana vaita banae Yeisu. ");
INSERT INTO bwd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ada au givedou wagaidiya, givona, “Natukuweyavo, gavaiyamu, kai tamo igana waveonadi?” Badi ilufata ivona, “Au keke-mowa seyana adavai.” ");
INSERT INTO bwd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Bana kaduwe givedou, givona, “Guvata wana yakunena waka wa aiyatagine mamauwe, ada igana wana nuwagadi.” Ada guvata iyakunena wagaine igana iveonana, ada keke adifata inatai guvata ginalaka faina igana moyai-moena. ");
INSERT INTO bwd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ada tonogala-nai Yeisu ginuwakabubuyena ani Pita wagaine givona, “Wada-nai ani Kauveya!” Ada tova-nai yana vona-nai Saimoni-Pita ginogalina, au ananuya faisewa faina gikaki gisena ani givai vovona gikiwafina ada gitowavila giobu gufa wagaine ada gikayo ginaunau taliyeya. ");
INSERT INTO bwd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Aku tonogalayavo waka wagaine itaitaina guvata igana ivemagana, faina adiatuwada badiyavo ke taliya ani lilivadiya-mwaeya, kai mita wani analedi (100) gagana. ");
INSERT INTO bwd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ada tova-nai iyalili, iitana ai gialakeyalena aku igana tabone gialaalaidi, ada kadu beledi gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeisu givonedi, givona, “Igana malinai waveonadi ani tufodi wana aliyedi.” ");
INSERT INTO bwd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimoni-Pita ginau waka wagaine giyage ke guvata gitai giobuyena taliyeya. Aku guvata ani gimaga igana lakaidi, anayoo wani analedi fifiti teli (153), ada igana moyai-moena nonogana guvata keke gida akelili. ");
INSERT INTO bwd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ada Yeisu givonedi, givona, “Wanaela wana veawagita.” Aku keke tamo gaito wagaidiya wa yana asevatu ke gida tolidadane gidavona, “O gaito?” Faina bademowa ialamanena Banae yadi Kauveya. ");
INSERT INTO bwd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Au Yeisu ginau beledi givai giveledi, kadu igana anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","E, Yeisu alikeya giyawa-vagila ada muliya giyegeyegemona yana tonogalayavo wagaidiya e ada taidei malinai ani yana yegemona anaveto. ");
INSERT INTO bwd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aku badi ikani giavaina, Yeisu givona Saimoni-Pita wagaine, givona, “Saimoni, oye Iyoni natuna, gavaiyamu, Iya unuwakabubuyeku lakaina ayo taidei?” Ada bana Pita givona, “Ika Kauveya, oye ualamanena ganuwakabubuyeni.” Yeisu givona, “Yaku lamiyavo una vekanidi.” ");
INSERT INTO bwd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeisu tova anavelu givona-vagilena, givona, “Saimoni, oye Iyoni natuna, gavaiyamu, o velemoena unuwakabubuyeku?” Banae gilufata givona, “Ika Kauveya, ualamanena ganuwakabubuyeni.” Yeisu givonenaga, “Yaku sifi una itaveyabidi.” ");
INSERT INTO bwd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ada kadu tova anaveto Yeisu givona-vagila wagaine, givona, “Saimoni, oye Iyoni natuna, gavaiyamu, unuwakabubuyeku?” Au Pita nuwana givita, faina tova toiye Yeisu gitoliluveluvena, givona, “Gavaiyamu, unuwakabubuyeku?” E ada banae givona, “Kauveya, gaitoma matatabuna ualamanena, kadu oye ganuwakabubuyeni ani bade ualamanena.” Yeisu givonaga, “Yaku sifi una vekanidi. ");
INSERT INTO bwd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Vona velemoena, gavona wagainiya, aimo ya tova tubulakata wagaine o tauni anuya uoseosena ke unaunau gadedeku tauni ya nuwanuwa. Aku ya tova vekaliva wagaine, au nima una tunena ada mali kaliva gina veoseni ada gadedeku wagaine keke nuwanuwa unana ani au gina vaini gina nauweni.” ");
INSERT INTO bwd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeisu taidei anafaiweya givona ani Pita yana alika faine, gava alika-nai wagaine Yaubada anayegana gina kilakai. Ada givona giavaina, Pita givonena, givona, “Una muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aku Pita gimiyavilana ada giitana tonogala-nai Yeisu ginuwakabubuyena ani gimulimuliyedi. Taidei kaliva-nai ani nagona tova-nai Nugulina anaebanuwaududu anakani wagaine, ani giluvala Yeisu wagaine ada givona, “Kauveya, gaito gina ivemogatalini nibaimomo wagaidiya?” ");
INSERT INTO bwd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ada kaliva-nai gimuliyedi ani Pita giitana ada Yeisu wagaine givona, givonaga, “Kauveya, gavana gina yegemona kaliva taidei wagaine?” ");
INSERT INTO bwd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeisu gilufata givona, “Kai nuwanuwaku banae gina miyamiya wayawaina analaba ganayewa-vagileku ganaelai, aga ida Iya yaku gaitoma. Aku oyeni una muliyeku.” ");
INSERT INTO bwd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","E ada Yeisu yana vona gimutula yana tonogalayavo moyaidi wagaidiya, aku badi inuwanuwa evona vaita taidei tonogala-nai keke gina alika. Aku anavelemoena ani Yeisu keke anafaiweya gidavona vaita banae keke gina alika, aku givona, “Kai nuwanuwaku banae gina miyamiya wayawaina analaba ganayewa-vagileku ganaelai, aga ida Iya yaku gaitoma.” ");
INSERT INTO bwd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tonogala-nai taidei ani banae gaitoma-dina taidei velemoena giitadi, e ada giawatalatalainedi ke givetokilumidi. Ada yana awatalatalaina kaalamanena ani vona velemoena. ");
INSERT INTO bwd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Aku kadu gaitoma moyai-moena Yeisu gifaisewadi. Kai matatabuna ida vetokilumidi aga ganuwanuwa vaita babi anamatatabuna wagaine keke mwatugu gida miyami anafata buki-dina faidiya. ");
INSERT INTO bwd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tubuiyaku Tiyofilo, tuwaina yaku buki nagona wagaine gaitoma moyaina Yeisu gigugaiyedi kaduwe givewalayena ani gavetokilumina. ");
INSERT INTO bwd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yana gugai anaebavevuvu wagaine gavebutu gavetokilumina, ada yana laka gabameya Banae ifuifufuna ganunauwena. Aku aimo keke gidalaka gabameya aku Aluwaluwa Tabuna yana kivetuvetunuga wagaine, badiyavo afositolo givenuwadadanedi ani adiveimeya giveledi. ");
INSERT INTO bwd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Banae yana uloulolo muline, alikeya giyawa-vagila ke badi afositolo-dina wagaidiya Tauna giseseyegemone-moena e ada keke adifaiweya yana yawa-vagila faina ina venuwana. Ada yadayada foti (40) wagaidiya giyegeyegemona badi wagaidiya ke givevewaledi Yaubada yana ebaveimeya faina. ");
INSERT INTO bwd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ada tova seyana badi Yeisu nodi ikanikani aku veimeya giveledi, givonaga, “Keke Yelusalema wana madumadusege aku wana bodana Aluwaluwa Tabuna, Banae Tamada givonadabadabayena. Bademowa gaifufuyena ke wanogalina. ");
INSERT INTO bwd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Faina Iyoni gufa wagaine gikikivebabitaiso, aku yadayada tufodi kana segedi, imiyavo Aluwaluwa Tabuna wagaine wana babitaiso.” Taidei anafaiweya Yeisu givonedi. ");
INSERT INTO bwd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kaduwe seyana tova afositoloyavo Yeisu nodi imiyavagauta ada itolidadanena, ivona, “Kauveya, gavaiyamu, tova taidei una vekini Isileli wagaine e ada moyaida meIsileli kana mididi ke taudeyavo yada ebaveimeya wagaine kana miyamiya?” ");
INSERT INTO bwd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yeisu givonedi, givona, “Kamaku anakaibe-mowa tova ada tutuya giveimeyena, aku imi keke amifaiweya tova-dina wana alamane. ");
INSERT INTO bwd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aku gaitoma seyana amifaiweya wana alamanena, imi aimo Aluwaluwa Tabuna gina toyogivelemi tova-nai tauna gina vemagami. Ada wana vetoawatalatalaina faikuya Yelusalema wagaine, kaduwe Yudiya ke Sameliya adifafali matatabuna wagaidiya ke kaduwe babi matatabuna wagaine.” ");
INSERT INTO bwd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ada Yeisu vona taidei giluyabuna muline, matadiya Yaubada gisilakaina gabameya. Ada gilakalaka aku tonogalayavo iitavedadaga ada iitavenanauna ke buibui gibabalina, ada keke adifaiweya inaita. ");
INSERT INTO bwd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yeisu gilakalaka aku badi aimo iitavedadaga-vagata mwatuguya aku kaliva adiselu adinuya kwayakwayafofolidi ani maduga-mowa lilivadiya imididi. ");
INSERT INTO bwd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ada ivonedi, “Imi meGalili, gavana faina idedeku wamidimididi aku waitaitavedadaga wagabameya? Banae taidei Yeisu Yaubada gabameya gisilakaina ke ginuyabuyabumi ani aimo tova muline gina obuelai-vagila. Banae gabameya waitana gilaka anafaiweya, kaduwe gabameya gina obuelai.” ");
INSERT INTO bwd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ada Oya Olive wagaine-deya afositoloyavo iyewa inau Yelusalema, keke atuwada, vaita kilomita seyana anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tova-nai iyegemona Yelusalema ada inau manuwa-nai imiyamiyanina wagaine ke ilaka manuwa getane yadi tutulagolota wagaine. Badiyavo imiyamiya ani Pita, Iyoni, Iyemesa, Andulu, Filipi, Tomasi, Batolomiu ke Madiu ada Iyemesa banae Alifiyo natuna, Saimoni Seloti, ada Yudasa banae Iyemesa natuna. ");
INSERT INTO bwd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Badiyavo tova moyaina ivagavagauta ke iveoveola aigaigabu, ada vevine nodi, kaduwe Meli Yeisu inana ke tainavo nodi. ");
INSERT INTO bwd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ada yadayada tufona giavaidi, tovetumagana imiyavagauta, adiyoo wani analedi tuweniti (120). Ada Pita adimwatuguya gimididi ke givonedi, ");
INSERT INTO bwd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Tubuiyakuweyavo, gavana tova tuwai-moena Buki Tabu wagaine ivetokilumina ani bademowa giyegemona velemoena. Ani tuwaina Aluwaluwa Tabuna Deivida awane Yudasa faine givonaye-vagaina, banae kaliva ginagoyedi ielai ke Yeisu ikiveyabina. ");
INSERT INTO bwd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Bana Yudasa ani nagona ime afositolo yama yoo seyana, faina Yeisu bana ime nodi ida faisewa-nai faina givenuwadadanema.” Taidei anafaiweya Pita givebutu giifuifufu. ");
INSERT INTO bwd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Aku Yudasa yana gugai koyona wagaine fatana givaina, ada mani-nai wagaine babi seyana gikimonena. Ani yana babi-nai wagaine wakuluwane gibeu ke ifugana givelubwakeiyena ada kamokamona gisesela, ke gialika. ");
INSERT INTO bwd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ada meYelusalema moyaidi valeyana inogalina, e ada babi-nai taudiyavo bonadiya ivewagana ‘Akelidama’. Yegana taidei anakivila ani ‘Dayaga anaBabi’. ");
INSERT INTO bwd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kaduwe Pita givona, “Faina tuwaina Yaubada yana vona Same wagaine Deivida givetokilumina Yudasa faine, givona, ‘Kaliva moyaidi yana manuwa ina nuyabuyabuna, ada keke tamo gaito wadedeku gina miyami.’ Kaduwe Yaubada yana vona seyana givona, ‘Kadu seyana gaito yana nagoya gina vaina.’ ");
INSERT INTO bwd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Yaubada yana vona taidei anafaiweya givona faina, kaliva seyana banae fatana faina gilubodada kada venuwadadanena, e ada Yeisu Keliso yana yawa-vagila faina bana ime afositolo nodi kaliva wagaidiya ana awatalatalaina. Ada bana kaliva-nai yada yoo wagaideya kana vaina. E, tamo gaito ide tuwaina kavevuvu Kauveya Yeisu nodi kamiyamiya kanunudadana, tuwaina Iyoni kaliva gikivebabitaisodi anatoveya ada kanauwena-deya Yaubada Yeisu gabameya gisilakaina ke gimadusegeda. Au tainei Yudasa fatana kanasena.” ");
INSERT INTO bwd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aku Pita taidei anafaiweya givona faina, kaliva adiselu ikilakailuvaluvadi. Seyana Iyosefa banae ivewagana Basabasi, ada kadu anayegana anaveto Yasito. Kaduwe kaliva anavelu anayegana Mataiyasi. ");
INSERT INTO bwd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Adiyegana ivenuwadadanedi muliya iveoveola, ivona, “Kauveya-yo, Oye kaliva seyana seyana yama nuwanuwa aseasemeya ualamanena. E ada Oye una vewalema kaliva taidei adiselu wagaidiya-deya gaito seyana uvenuwadadanena, ");
INSERT INTO bwd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ada banae Yudasa fatana ke afositolo yadi gugai gina vaina, gugai-nai Yudasa gimadusegena ke ginanau tauna yana fafali.” ");
INSERT INTO bwd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ada veoveola muline, kabala anaselakalakata anavenuwadadana wagaine inuwagana vaita Mataiyasi ani Yudasa fatana. E ada Mataiyasi banae giluku afositoloyavo adileveni nodi. ");
INSERT INTO bwd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aku Abutu Penitikosi anayadayada giyegemona wagaine, tovetumagana moyaidi bademowa imiyavagauta fafali seyana wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ada au maduga-mowa wagabameya butuna inogalina vaita mala toyogina giveyuveyuve anafaiweya, ada manuwa-nai wagaine ivetovetoga ani butuna givemagana. ");
INSERT INTO bwd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ada iitana gaitoma seyana anaita vaita aiyabeyabela meyana giludakadakana ke kaliva seyana seyana kuluwana getane givetoga. ");
INSERT INTO bwd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ada matatabudi Aluwaluwa Tabuna givemagadi ke ivebutu meya tulina tulina wagaidiya iifuifufu Aluwaluwa Tabuna gialaveleveledi mamauwe. ");
INSERT INTO bwd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aku wadedeku Yelusalema wagaine meIsileli tufona moyaidi imiyamiya, badi Yaubada wagaine ioduodu. Fafali tulina tulina moyaidi wagaidiya itauya ke ina Yelusalema imiyamiya. ");
INSERT INTO bwd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ada badi kaliva-dina kaliva yadi ifufu meya tulina tulina ani bonadi inogalina e ada moyaidi ivagauta. Ada nuwadi givoganina, faina kaliva seyana seyana ginogalina tauna meyane tovetumagana iifuifufu. ");
INSERT INTO bwd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ada moyaidi meyadi gisidobodobona ke taudiyavo wa yadi nuwavogana ivona, “Ida kaliva-dina iifuifufu ani badi moyaidi meGalili. ");
INSERT INTO bwd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","E ada gavaiyamu-yo moyaida kanogalidi taudeyavo meyada tulina tulina wagaidiya iifuifufu? ");
INSERT INTO bwd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ide yada fafali wagaidiya kaelai ani Patiya, Midiya, Elama, Mesopotemiya, Yudiya, Kafadosiya, Ponitasi, Eisiya. ");
INSERT INTO bwd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kadu Filidiya, Pamifiliya, Itipita ke Libiya anafafali Sailini lilivane. Ada kaduwe tufoda meLoma aku Yelusalema wagaine kawakawaka, ");
INSERT INTO bwd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","tufoda meIsileli velemoena aku tufoda keke meIsileli aku meIsileli yadi tafalolo wagaine kaawaegeda ke kadamana. E, kaduwe tufoda meKiliti ke Alebiya. Au yada fafali moyaina aku moyaida kanogalina taudeyavo meyada tulina tulina wagaidiya iifuifufu ada Yaubada yana gugai toyogina iawaawatalatalainedi!” ");
INSERT INTO bwd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ada moyaidi meyadi gisidobodobona ke nuwadi givoganina, ada taudiyavo gaga ivetolitoli, ivona, “Ida gavana?” ");
INSERT INTO bwd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aku tufodi ani tovetumagana iawaveleigedi, ivona, “Wada badi waini digadigagina iyuga ivekwavakwava.” ");
INSERT INTO bwd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ada bana Pita badi afositolo adileveni nodi gimididi ke bonana lakaina wagaine givona yoo wagaidiya, givona, “Imi meIsileli ke imi Yelusalema wagaine wamiyamiya, wana nogalina gavana ganavona ada nuwami gina malina. ");
INSERT INTO bwd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Taidei kaliva-dina keke gufa toyogina idayui ke ida vekwavakwava wanuwanuwa anafaiweya. Ida malabutuya kauwana naeni kiloki. Keke yuga anatova. ");
INSERT INTO bwd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Aku ida falofita Iyoweli tuwaina gimadu awamogatalena ani giyegemona velemoena anafaiweya. Givona, ");
INSERT INTO bwd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Yaubada givona, Aimo tova anaebalauyabu anayadayada-dina wagaidiya ani Aluwaluwaku gana biwana tomiyababi moyaidi wagaidiya. E ada natumiyavo kaliva ke vevine ina falofisai, yami tubulakata vewala ina itadi, kaduwe kaliva lakaidiyavo ina avaita. ");
INSERT INTO bwd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","E, tova-nai wagaine Aluwaluwaku kaduwe gana biwana yaku togugaiyavo kaliva ke vevine wagaidiya, ada ina falofisai. ");
INSERT INTO bwd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ada gugai ebameyasidobodobo aimo gana vewala gabameya, kauwana gina yuyuvana ke vaikoi gina yabelina anafaiweya dayaga. Kaduwe iyaiyaya lakaidi babiya gana seyegemonena, dayaga ke ai alalata kaduwe siyo badobadona. Aku muliya KAUVEYA yana yadayada lakaina gina yegemona, ani vevonayavuga anatova matamatausina. ");
INSERT INTO bwd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aku badi moyaidi gavega KAUVEYA ina veolena adikibababala faina ani gina kibababaledi.’” Ida Yaubada yana vona bana Iyoweli givetokilumina ani bana Pita giifufuyena. ");
INSERT INTO bwd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kaduwe Pita givona, “Imi meIsileli, yaku vona taidei wana nogalina. Yeisu kwana Nasaledi ani Yaubada Banae toyogina givelena ke gugai toyogina ada iyaiyaya lakaina gigugaiyedi amimwatuguya. Taidei gaitoma-dina imi taumiyavo waitadi ke waalamanedi, ada taidei wagaine Yaubada givewale-dewedewemi vaita Yeisu giimilina. ");
INSERT INTO bwd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Taine Yeisu-nai Banae ani tuwai-moena Yaubada Tauna giveimeya ke imi nimamiya gina awaegena, e ada gialamane-vagaina. Taidei kaliva-nai waluvealikana, faina badi tokoyona waveledi ke nimadiya itutuvefosena kelose wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Imi Yeisu waluvealikana, aku Yaubada alika anauloulolo giluyavuledi ke alikeya gisiveyawana, faina keke meyameyaganina alika yana toyogina Yeisu gina kiveyabi-vagai. ");
INSERT INTO bwd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Anafaiweya tuwai-moena Deivida Yeisu faine givonaye-vagaina, givona, ‘Iya gaalamanena tova moyaina KAUVEYA wagaikuya gimiyamiya. Banae lilivakuya gimiyamiya faina, aseaseku keke gina akolukolu. ");
INSERT INTO bwd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Taidei faina nuwaku giveiwaka, kaduwe wa yaku vemwamwala gaifuifufu. Aimo vovoku didikuleya gina daudau aku wa yaku nuwavetumagana gana miyamiya, ");
INSERT INTO bwd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","faina bademowa gaalamanena Iya keke toalika yadi fafaliya unasege-vagai. Kaduwe Iya ya Kaliva Tabutabuku ani keke vovoku una awaege ayo gina abudali. ");
INSERT INTO bwd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yawai-vagata anawai bademowa uvewaleku, ada Oye Iya nodi kana miyami faina, gana vemwamwala lakaina.’” ");
INSERT INTO bwd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ada kaduwe Pita givona, “Tubuiyakuweyavo, gana vonemi velemoena, tamada nagona Kini Deivida tuwaina gialika ada vovona isena didikula luwa wagaine, ada anadidikula-nai ani malinai wagaideya aimo gimiyamiya. ");
INSERT INTO bwd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Aku bana Deivida ani falofita, ada gialamanena Yaubada bademowa bana wagaine givonadabadaba toyogina vaita aimo Deivida tauna yana tubudelideli seyana, ani Yaubada ginasena gina vekini ke gina vetoga Deivida yana veimeya anaebavetoga kaikaiwabuna wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deivida gimadu alamanena Keliso yana yawa-vagila alikeya, taidei faina gimaduvonayena, givona, ‘Yaubada keke Banae toalika yadi fafali wagaine ginasege-vagai, ada vovona keke gina abudali.’ ");
INSERT INTO bwd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Taine Yeisu-nai Yaubada bademowa alikeya gisiveyawana, ada ime moyaima taumeyavo matameya aitana ke aawatalatalainena. ");
INSERT INTO bwd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yaubada gisiveyawana ke aiyatagine giveiotona. Ada Tamana Aluwaluwa Tabuna givelena tuwaina givonadabadabayena anafaiweya. E ada malinai Yeisu Aluwaluwa Tabuna gibiwana e ada ida gaitoma-dina waitaitana ke wanoganogalina. ");
INSERT INTO bwd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deivida yana vona ani keke tauna faine gidavona, faina banae keke gidalaka gabameya Yeisu anafaiweya. Aku givona, ‘Banae KAUVEYA Yaubada givona yaku Kauveya wagaine, “Aiyatagikuya una vetoga analaba ");
INSERT INTO bwd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nibaimomo gana seobuyedi ada yadi toyogina gina avaina velemoena.”; ");
INSERT INTO bwd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Taidei faina imi meIsileli moyaimi ani wana alamane-dewedewena, Banae Yeisu-nai wakivebolagalagana ani Yaubada gisena Kauveya, ada kaduwe Banae Keliso.” Taidei anafaiweya Pita gilumamala. ");
INSERT INTO bwd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ada tova-nai kaliva vona taidei inogalina, aseasedi gionana, e ada itolidadana Pita ke afositolo velugadiyavo wagaidiya ivona, “Tubuiyameyavo, gavana anagai?” ");
INSERT INTO bwd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ada Pita givonedi, “Imi seyana seyana yami gugai koyodi wana segedi ke wana nuwavilana, ada Yeisu Keliso anayeganeya wana babitaiso ke Yaubada yami koyona gina venuwaegedi. Ada Aluwaluwa Tabuna wana nuwagana, Bana adanuwakabubu. ");
INSERT INTO bwd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Faina Yaubada givonadabadaba Aluwaluwa Tabuna gina awaegena imi faimiya ke natumiyavo faidiya, ada kaduwe badi gavega atuwadeya imiyamiya faidiya. Ada gavega moyaidi Yaubada gina douwedi ke Bana wagaine inaelai, tainei badi wagaidiya gina awaegena.” ");
INSERT INTO bwd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ada Pita vona moyaina wagaine giawatalatalainedi ke kaduwe giveoledi toyogina, givonaga, “Imiyavo ani tova malinai anayoo koyodiyavo adimwatuguya wamiyamiya, e ada wana itaveyabimi. Yaubada wana veoveolena ke gina kibababalemi badi wagaidiya-deya.” ");
INSERT INTO bwd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","E ada badi gavega Pita yana vona ivetumaganena ani ibabitaiso ke tovetumagana adiyoo wagaine iluku. Ada taine yadayada-nai wagaine biyavo-dina ibabitaiso ani adiyoo teli tausani (3,000) anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ada tova moyaina tovetumagana iawaawaegedi afositoloyavo yadi vewala wagaine ada ivetubuiyana velemoena, kaduwe ivagavagauta ke nodi ikanikani, ada iveoveola aigaigabu Yaubada wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ada afositoloyavo gugai ebameyasidobodobo ke iyaiyaya lakaidi igugugaiyedi, e ada moyaidi Yaubada yana toyogina iitana wagaine wa yadi matauta ivemoimoinena. ");
INSERT INTO bwd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kaduwe tovetumagana moyaidi imiyamiyavagauta ke yadi nuwanuwa seya-moena wagaine yadi giba ivutuvutuga taudiyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Anafaiweya tova ke tova yadi babi ke yadi giba ina vekimoneyedi aku mani ina vaina ada ina vutugedi badi gavega ivemaufo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ada yadayada seyana seyana nodi imiyamiyavagauta manuwa tabu wagaine. Kaduwe taudiyavo yadi manuweya aa ikiineinena Yeisu anaebanuwaududu faina ke wa yadi vemwamwala ikanikani aigaigabu. ");
INSERT INTO bwd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ada tova moyaina Yaubada iawadavadavana, kaduwe kaliva moyaidi tovetumagana iawaveiwakanedi. Ada yadayada seyana seyana adiyoo giveiveinala, faina gavega Kauveya gikibababaledi ani giseselukuwedi adiyoo wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tova seyana wagaine Pita ke Iyoni inaunau manuwa tabu wagaine aku bademowa au gienovilana kauwana teli kiloki anafaiweya, tainei veoveola anatova. ");
INSERT INTO bwd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ada badi iyegeyegemona aku kaliva seyana inana kamodiya gitubuga felafelana, ani manuwa tabu anaebaluku wagaine iwaiwaina. E, ebaluku-nai ivewagana Ebaluku Anaita Iwakana. Ada yadayada seyana seyana tovefela-nai iwaiwaina, ada wadedeku isesena ke badi manuwa tabu anatoluku wagaidiya mani faina giveoveola. ");
INSERT INTO bwd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ada Pita ke Iyoni idaluku manuwa tabu wagaine ani giitadi, ada wagaidiya mani faina giveola. ");
INSERT INTO bwd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ada Pita ke Iyoni tovefela-nai iitavutuvutuna aku Pita givonena, “Una itama.” ");
INSERT INTO bwd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ada tovefela giitaitadi aku ginuwavetumagana vaita gavana tamo gina nuwagana wagaidiya-deya. ");
INSERT INTO bwd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aku Pita givona, “Keke tamo mani wagaikuya, aku gavana wagaikuya ani gana veleni. Yeisu Keliso kwana Nasaledi anayeganeya, una mididi una nudadana.” ");
INSERT INTO bwd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ada nimana aiyatagine giabi gisivemididina, ke maduga-mowa agena matatabuna itoyogina. ");
INSERT INTO bwd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ada gimadumididi-mowa ke givebutu ginunudadana. Ada nodi iluku manuwa tabu wagaine aku bana gimadutowatowavila aku Yaubada giawadavadavana. ");
INSERT INTO bwd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ada kaliva moyaidi iitana ginunudadana ke Yaubada giawadavadavana, ");
INSERT INTO bwd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ada iitainanana banae tovefela-nai tova moyaina manuwa tabu anaEbaluku Anaita Iwakana wagaine givetovetoga aku giawaveoveola. Ada au moyaidi itataweyana ke meyadi gisidobodobona yana veiwaka faina. ");
INSERT INTO bwd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ada imiyamiya manuwa tabu anafafali ivewagana Solomoni Yana Ebamiyami wagaine aku aimo kaliva-nai Pita ke Iyoni nimadi giabiabina. Ada kaliva moyaidi meyadi gisidobodobona ke imadu ielai wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ada tova-nai Pita yoo giitadi, givonedi, “Imi meIsileli, gavana vuvuna taidei giveyaulovogimi? Gavana faina waitavutuvutuma vaita taumeyavo yama toyogineya o kai yama yegayeganeya Yaubada matane kaliva taidei ada kiveiwakane ke gida nunudadana? Keke taidei anafaiweya wana nuwanuwa. ");
INSERT INTO bwd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aku tamadeyavo nagona yadi Yaubada, badi Ebelaamo, Aisake, ke Iyakobo yadi Yaubada, Banae-nai taidei gaitoma-nai gigugaiyena e ada yana togugai Yeisu anayegana gina kilakaina. Taine Yeisu-nai waawaididiyena ke Pailato nimane wasena gina luvealikana. Pailato nuwanuwana gina etoyavuna aku imi wadibusoyogena. ");
INSERT INTO bwd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Banae Tabutabuna kadu Toyegayegana ani imi wadibusoyogena, aku Pailato waveolena ke banae toluvealika gina etoyavuna wagaimiya. ");
INSERT INTO bwd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ada taidei anafaiweya Banae yawai vuvuna ani waluvealikana, aku Yaubada alikeya gisiveyawana. Ada yana yawa-vagila ime anatoitavedama. ");
INSERT INTO bwd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ada au Yeisu anayegana faina, Banae anayeganeya avetumagana faina, taidei kaliva waitana kaduwe waalamanena ani gitoyogina. Yana veiwaka moyaimi matamiya vuvuna ani vetumagana Yeisu anayeganeya. Taidei wagaine tovefela-nai giveiwaka velemoena. ");
INSERT INTO bwd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“E aku tubuiyakuweyavo, Iya gaalamanena gavaiyamu Yeisu wagaine imiyavo ke yami tonagonayavo wadewa ani keke nuwami gidamali-dewedewe. ");
INSERT INTO bwd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Aku tuwai-moena Yaubada yana falofita moyaidi awadiya gimadu vonayena vaita Keliso gina uloulolo. E ada imi yami dewa-nai wagaine Yaubada Tauna yana vona-nai giluveyegemonina velemoena. ");
INSERT INTO bwd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Taidei faina yami dewa koyodi wana segedi aku Yaubada wagaine wana miyavilami e ada yami koyona gina venuwaegedi. ");
INSERT INTO bwd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kai taidei anafaiweya wana gugai, aga kaliva faleda wagaine meyana gina kivebikana anafaiweya, Yaubada Banae aseasemi gina kikivebikana ke toyogina wana nuwagana. Ada kaduwe gina imilina Mesaiya, Banae bademowa givenuwadadanena imi faimiya, ani Banae Yeisu. ");
INSERT INTO bwd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yeisu bademowa gilaka gabameya ada wadedeku-deya gina miyamiya analaba gavatoveya Yaubada gaitoma moyaina babiya gina kiveevaguna, anafaiweya tuwaina yana falofita tabutabudiyavo imadu awamogatalena. ");
INSERT INTO bwd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Anafaiweya nagona Mosese givona, ‘Yaubada yami KAUVEYA aimo imi faimiya falofita seyana gina vemididina Iya anafaiweya. Banae taumiyavo yami yoo wagaidiya-deya. Ada gaitoma moyaina wagaidiya gina veimeyemi ani wana idibumwaigena. ");
INSERT INTO bwd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aku badi gavega falofita-nai yana vona keke ina nogali, badiyavo Yaubada gina luyavuledi yana yoo wagaidiya.’ Taidei anafaiweya Mosese givona. ");
INSERT INTO bwd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Tuwai-moena Samuwela wagaine-deya ada gielai falofita matatabudi wagaidiya, gavaiyei ifalofisai ani badi kaduwe iawatalatalaina malinai anatova faina. ");
INSERT INTO bwd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ada Yaubada yana falofita awadiya ide faideya givonadabadaba, ada Yaubada ani tuwaina tamadeyavo nagona wagaidiya yana veyavo anawai gisena ani keke taudiyavo gaga faidiya aku kaduwe ide faideya. Ebelaamo wagaine givona, ‘Kaliva seyana ya tubudelideli wagaine gina yegemona, ada kaliva moyaidi babi matatabuna wagaine gana awanuwakabubuyedi Banae wagaine.’ Taidei anafaiweya Yaubada givona. ");
INSERT INTO bwd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","E ada Yaubada yana togugai Yeisu alikeya gisiveyawana ada nagona ide meIsileli moyaida wagaideya giimilina. Faina nuwanuwana yana nuwadogeya gina lemelemeda e ada ide moyaida kana nuwavilana yada gugai koyodi wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ada Pita ke Iyoni aimo kaliva wagaidiya iifuifufu aku yoo tufona ielai wagaidiya, badiyavo Yaubada yana veyavo anatovegugaiyavo, ke manuwa tabu anatoyavagayavo aditonagona ada kaduwe Sadusiyavo. ");
INSERT INTO bwd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Badiyavo inuwakoyo faina badi adiselu kaliva ivewavewaledi vaita Yaubada Yeisu alikeya gisiveyawana anafaiweya, kaduwe toalika Yaubada gina siveyawadi alikeya. ");
INSERT INTO bwd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","E ada ikiveyabidi aku mala bademowa givelavilavi faina, deli wagaine isedi aku mala ginalavu-yo ina vevonayavugidi. ");
INSERT INTO bwd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aku kaliva moyaidi Pita ke Iyoni yadi laumamala inogalina ke ivetumaganena, ada tovetumagana adiyoo gitubuga faifi tausani (5,000) anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mala gilavuna meIsileli aditoveimeyayavo ke kaliva lakaidiyavo kaduwe Mosese yana veimeya anatovewalayavo Yelusalema wagaine ivagauta. ");
INSERT INTO bwd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ada veyavo anatovegugai aditonagona Anasi ke kaduwe Kaiyafasi, Iyoni ke Alekisanida nodi wadedeku-deya, ada kaduwe veyavo anatovegugai aditonagona yana gabu kaliva-dina nodi ivagauta. ");
INSERT INTO bwd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ada Pita ke Iyoni matadiya ivemidididi aku itolidadanedi, ivona, “Gaito yana toyogineya o kai gaito anayeganeya gugai taidei anafaiweya wagugaiye?” ");
INSERT INTO bwd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aku Pita Aluwaluwa Tabuna wagaine magamagana, ada givonedi, givona, “Imi toveimeyayavo ada kaliva lakaimiyavo, ");
INSERT INTO bwd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","malinai wavagaulema vonayavuga taidei wagaine ada watolidadanema gugai iwakana agugaiyena tovefela wagaine faina. Ada kaduwe watolidadanema gavaiyamu giveiwaka. ");
INSERT INTO bwd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","E ada imiyavo kaduwe meIsileli moyaimi, gana kivemalimi ke wana alamanena. Banae Yeisu Keliso kwana Nasaledi anayeganeya ada yana toyogineya ani tovefela taidei giveiwaka, e ada matamiya gimidimididi. Yeisu Banae imi wakivebolagalagana aku Yaubada alikeya gisiveyawa-vagilena. ");
INSERT INTO bwd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Banae-nai faine vona matalivulivuna seyana Buki Tabu wagaine givona, ‘Ogola-nai imi manuwa anatoiyogona wadibusoyogena, ani Banae gimidinagona ogola moyaidi.’ ");
INSERT INTO bwd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yeisu Banae anakaibe wagaine kibababala kana nuwagana. Faina keke tamo gaito babiya gida miyami ani Yaubada gida venuwadadane ke banae anayeganeya ide kaliva kibababala adafaiweya kana nuwaga.” Taidei anafaiweya Pita givonedi. ");
INSERT INTO bwd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Aku meIsileli yadi Kaniselayavo ani Pita ke Iyoni yadi asevatu iitana wagaine, meyadi gibovu. Faina ialamanena taidei kaliva-dina keke ida sikulu, badi kaliva-kavovodi. Aku nuwadi giamutuna tuwaina badi Yeisu nodi. ");
INSERT INTO bwd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aku iitana tovefela-nai bademowa giveiwaka ani adiselu lilivadiya gimidimididi, e ada keke adifaiweya kaduwe gavana tamo inavone. ");
INSERT INTO bwd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Au iveimeyedi ke ebavevonayavuga anafafali wagaine ina midiyegemona. Badi kaliva imidiyegemona ada Kaniselayavo ivebutu ke taudiyavo iveifuifufu, ivona, ");
INSERT INTO bwd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Gavana kanagai kaliva taidei wagaidiya? Faina kaliva moyaidi Yelusalema wagaine bademowa ialamanena gugai ebameyasidobodobo igugaiyena, ada ide keke adafaiweya kana veweye. ");
INSERT INTO bwd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Aku kada vonediga, ‘Keke tamo kaduwe gaito seyana wagaine wana ifuifufu Yeisu anayeganeya.’ Taidei anafaiweya kada awatadi e ada valeyana-nai keke gina mutula kaliva moyai-moedi wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ada iveifuifufu giavaina, Pita ke Iyoni idouwe-vagiledi iluku ke iveimeyedi, ivona, “Keke-mowa maita kaduwe Yeisu anayeganeya wana ifuifufu o wana vewala.” ");
INSERT INTO bwd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Taidei anafaiweya iveimeyedi aku badi Pita ke Iyoni ilufata, ivona, “Gavana iwakana Yaubada matane, kai imi ana matawalewaleyemi o kai Yaubada ana matawalewaleyena? Imi taumiyavo wana venuwadadanena, ");
INSERT INTO bwd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","faina ime keke amafaiweya ana ilova. Au gavana Yeisu yana gugai aitana ke yana vona anogalina ani ana ifuifufuyena.” ");
INSERT INTO bwd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Idamamauwe adiselu ivona e ada Kaniselayavo kaduwe iawavematausidi aku au iawaegedi inau. Gavaiyamu ina vematavulogidi ani faine inuwanuwa-wayoga. Yoo imatausedi e ada keke adifaiweya, faina gaitoma-nai giyegemona ani kaliva iitana e ada moyai-moedi Yaubada iawadavadavana. ");
INSERT INTO bwd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Faina tovefela-nai gugai ebameyasidobodobo wagaine giveiwaka ani banae keke tubulakaina, anamalamala foti (40) wa tufona. ");
INSERT INTO bwd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tova-nai Pita ke Iyoni Kaniselayavo isegedi aku yadi yoo wagaidiya iyewadi, ada veyavo anatovegugai lakaidiyavo ke kaliva lakaidiyavo gavaiyamu ivonedi ani mamauwe iifufuyedi. ");
INSERT INTO bwd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ada badi tovetumagana inogalina ke moyaidi Yaubada wagaine iveoveola aigaigabu, ivona, “Oye Toveimeya. Gabama, babi, ke leyaga, ada kaduwe gaitoma moyaidi wagaidiya imiyamiya ani O ububudi. ");
INSERT INTO bwd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tuwai-moena Aluwaluwa Tabuna ya vona giseyegemonina ya togugai tamama Deivida awane, givona, ‘Gavana faina badi keke meIsileli inuwakoyo-mowa? Gavana faina yadi veimeya koyona ibubu-wayogedi? ");
INSERT INTO bwd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Babi anakiniyavo ikidewadewa ada toveimeyayavo nodi ivagauta ke Yaubada ada Banae yana Mesaiya ina lugaviyadi.’ ");
INSERT INTO bwd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ada toveimeya yadi nuwakoyo malinai giyegemona velemoena anafaiweya givonayena. Faina Kini Elodi ke Ponitiyo Pailato ani meIsileli ada badi keke meIsileli nodi ivagauta Yelusalema wagaine ada iveimeya aigaigabu ke Yeisu ina luvealikana, Banae ya togugai tabutabuna uvenuwadadanena ke utoyogivelena ya faisewa faine. ");
INSERT INTO bwd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ada igugaiyena anafaiweya tuwai-moena uvenuwadadanena, Oye ya toyogina ke ya veimeya wagaine ada giyegemona anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","E ada Kauveya, badi Kaniselayavo iawavematauta wagaimeya ani O unogalina. E ada ime ya togugaiyavo una kivetoyogima ke wa yama asevatu ya vona ana lumamalena. ");
INSERT INTO bwd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ime ana lulumamala aku Oye nima una tunena toveoga wagaidiya ke ina veiwaka, ada iyaiyaya lakaidi ke gugai ebameyasidobodobo una gugaiyedi ya togugai tabutabuna Yeisu anayeganeya.” ");
INSERT INTO bwd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ada iveoveola giavaina, manuwa-nai wagaine ivagauta ani gialiuliuna. Kaduwe Aluwaluwa Tabuna moyaidi givemagadi ada Yaubada yana vona wa yadi asevatu ilumamalenauwena. ");
INSERT INTO bwd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Aku tovetumagana moyaidi yadi nuwanuwa seya-moena. Keke tamo gaito seyana gidavona, “Yaku lokoloko akukaibe faikuya.” Au yadi lokoloko ivutuvutugedi taudiyavo wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Badi afositolo wa yadi toyogina Kauveya Yeisu yana yawa-vagila alikeya faina iawatalatalaina, ada Yaubada yana nuwadoga lakaina moyaidi wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ada tovetumagana moyaidi wagaidiya ani keke tamo gaito fanifanina gida miyami, faina tova ke tova badi gavega wa yadi babi o wa yadi manuwa ani ivekivekimoneyedi, ada manidi ivaivaina ani ");
INSERT INTO bwd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ialialiyedi afositoloyavo iveleveledi. Ada afositolo ivutuvutugena badiyavo gavega adiga o kai yadi lokoloko keke wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ada Iyosefa, banae Livai unumina anakaliva, taidei anafaiweya gidewa. Bana yana melala ani imula anayegana Saifilasi wagaine. Badi afositolo kaliva-nai ivewagana Banabasi, anayegana anakivila ‘tokiveasevatu’. ");
INSERT INTO bwd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ani Banabasi-nai yana babi seyana givekimoneyena, ada babi manina givaina ani gialiyena afositoloyavo giveledi. ");
INSERT INTO bwd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Aku kaliva seyana gimiyamiya anayegana Ananaiyasi, ada vavinena adiyegana Safaila. Banae yadi babi seyana givekimoneyena. ");
INSERT INTO bwd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ada babi-nai fatana tufona giseyewena tauna faine aku tufona gialiyena afositoloyavo wagaidiya, aku givonedi vaita mani matatabuna gida aliye-yabu. Aku fatana tufona giseyewena ani badi vavinena ialamanena. ");
INSERT INTO bwd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ada Pita givonena, givona, “Ananaiyasi, gavana faina Seitani uawaege ayo nuwaniya giluku, e ada Aluwaluwa Tabuna wagaine ufwaya vaita babi fatana matatabuna uda aliye-yabu, aku keke. Tufona tauni fainiya useyewena. ");
INSERT INTO bwd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Aimo babi-nai keke uda vekimoneye wagaine, ina tauni ya babi. Ada kaduwe bade uvekimoneyena wagaine, babi fatana uvaina ani aimo ya veimeya wagaine. E aku gavana faina nuwainageniya fwaya ufaisewa ayo uvona vaita mani matatabuna udavele-yabuma? Keke kaliva gaga wagaimeya uda fwaya aku kaduwe Yaubada wagaine ufwaya.” ");
INSERT INTO bwd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ada Pita yana vona Ananaiyasi ginogalina wagaine, gibeu ada gialika. Ada badiyavo gavega valeyana inogalina ani imatauta lakaina. ");
INSERT INTO bwd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","E ayo tubulakata imididi vovona ikiwafina ke iwai inauwe itavuna. ");
INSERT INTO bwd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kauwana ginau anabai toiye muliya, vavinena ielai ada iluku manuwa-nai wagaine. Aku gavana giyegemona moganedi wagaine ani keke ida alamane. ");
INSERT INTO bwd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ada Pita givonedi, “Wana voneku, taidei anafaiweya mani anatubuga-nai yami babi fatana moganemi nodi wavaina?” Ada badi ivonaga, “Ika, babi fatana tainei anafaiweya.” ");
INSERT INTO bwd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ada Pita givonedi, “Gavana faina imi moganemi nodi wanuwanuwa vaita amifaiweya Kauveya Aluwaluwana wagaine wana fwaya ke wana itana kai fwaya fatana wana nuwagana o kai keke? Wana itana, badi kaliva-dina moganemi itavuna ani edawaneya iyegemo, ada imi kaduwe ina waimi ina nauwemi.” ");
INSERT INTO bwd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ada maduga-mowa Safaila Pita agene ibeu ke ialika. Ada tubulakata iluku ke iitadi vavine bademowa ialika, e ada iwaidi inauwedi moganedi lilivane itavudi. ");
INSERT INTO bwd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ada tovetumagana adiyoo matatabuna ke kaduwe badi gavega valeyadi inogalina ani imatauta lakaina. ");
INSERT INTO bwd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aku afositoloyavo nimadiya Yaubada gugai lakaidi ke gugai ebameyasidobodobo moyaidi gigugugaiyedi kaliva adimwatuguya. Ada badi tovetumagana moyaidi ani ivagavagauta manuwa tabu anafafali-nai wagaine ivewagana Solomoni Yana Ebamiyami. ");
INSERT INTO bwd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kaliva moyaidi ani tovetumagana iawaveiwakanedi, aku keke nodi ida vagavagauta faina imatauta. ");
INSERT INTO bwd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aku tova tova kaliva ke vevine ivetumagana Kauveya wagaine ani tovetumagana adiyoo wagaine ilukuluku. ");
INSERT INTO bwd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ada kaduwe, kaliva yadi toveoga wa vayadi o wa sitadi iwaidi inaunauwedi wai wagaidiya iseseobuyedi. Faina inuwavetumagana vaita Pita gina nugulidi wagaine, kai anununa toveoga tufodi gina aiwautagodi ke ina veiwaka. ");
INSERT INTO bwd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kaduwe kaliva moyaidi melala Yelusalema anafafali lilivane wagaidiya-deya ielai Yelusalema, yadi toveoga kadu badi aluwaluwa bwanebwanenedi ikivekoyodi ani ialiyedi. Ada moyaidi iveiwaka-yabu. ");
INSERT INTO bwd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aku bana veyavo anatovegugai aditonagona kaduwe tubuiyanavo moyaidi nodi badi yoo-dina ivewagadi Sadusi, ani iveumagigi-mowa afositoloyavo wagaidiya, ");
INSERT INTO bwd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","e ada inau afositolo ikiveyabidi ada deli wagaine isedi. ");
INSERT INTO bwd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Aku boginafa KAUVEYA yana anelose gielai ke deli anawana giyavuna aku afositolo giveyegemonidi. ");
INSERT INTO bwd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ada givonedi, givona, “Wananau manuwa tabu wagaine wana mididi ada kaliva wagaidiya wana ifufuye-yabuna yawai evaguna taidei faina.” ");
INSERT INTO bwd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ada anelose giveimeyedi anafaiweya inau, ada mala gilavuna manuwa tabu anafafali seyana wagaine iluku ke ivebutu ivewala. Aku bana veyavo anatovegugai aditonagona ada tubuiyanavo nodi ielai ke meIsileli yadi Kanisela idouwevagauwidi, e ada badiyavo ke meIsileli aditonagonayavo moyaidi ivagauta. Tova-nai ivagauta-yabu, manuwa tabu anafilisimani iimilidi inau deli wagaine ke afositolo ina aliyedi. ");
INSERT INTO bwd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aku filisimaniyavo inau deli wagaine ani afositolo badi keke. E ada Kanisela wagaidiya iyewadi ada imatawedi, ivona, ");
INSERT INTO bwd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Deli wagaine anau, wana falifalidi ke toyogidi aitadi, kaduwe wana anatoitaveyabina imidimididi edawaneya. Aku wana ayavuna wagaine, keke tamo gaito tutulagolota-nai negenine gida miyami!” ");
INSERT INTO bwd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ada manuwa tabu anafilisimani aditonagona ke veyavo anatovegugai lakaidiyavo ani filisimaniyavo yadi vona inogalina wagaine, nuwadi givoganina ke inuwanuwa, “Taidei gavana aimo gina yegemona?” ");
INSERT INTO bwd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Inuwanuwa ani, kaliva seyana giela givonedi, givonaga, “Wana nogalina! Badi kaliva-dina deli wagaine wasedi ani manuwa tabu wagaine imidimididi aku kaliva ivewavewaledi!” ");
INSERT INTO bwd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ada filisimani aditonagona yana kalivayavo nodi inau ada afositolo ivagauledi aku keke ida munudi, faina imatauta kai yoo kabaleya ina tutuvealikadi. ");
INSERT INTO bwd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ada tova-nai iyegemona ke afositolo ilukuwedi, Kanisela matadiya ivemidididi ke veyavo anatovegugai aditonagona gina toliluveluvedi. ");
INSERT INTO bwd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ada bana givonedi, givona, “Ime awata toyogina wagaimiya asena, ani taidei kaliva-nai keke-mowa maita anayeganeya wana vevewala. Aku yami vewala wanauwena-deya ke ginau Yelusalema matatabuna giluyabuna. Ada kaduwe, nuwanuwami taidei kaliva-nai yana alika anavita ime wagaimeya wanasena!” ");
INSERT INTO bwd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Aku Pita ada afositolo velugadiyavo ani Kaniselayavo ivonedi, ivona, “Ime keke kaliva ana matawalewaleyedi aku nagona Yaubada ana matawalewaleyena. ");
INSERT INTO bwd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Banae Yaubada, tamadeyavo nagona yadi Yaubada ani Yeisu alikeya gisiveyawana, Banae imi ai wagaine watutuvefosena ada waluvealikana. ");
INSERT INTO bwd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","E, Yaubada gisiveyawana ke aiyatagine gisena, ada bana adaToveimeya Lakaina ke kaduwe adaTokibababala. Tokibababala gisena ke Banae ide meIsileli gina lemeda ke kana nuwavilana ada yada koyona gina venuwaegedi. ");
INSERT INTO bwd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ada ime yana alika ke yana yawa-vagila anatoitavedama, ime kaduwe Aluwaluwa Tabuna nodi, Banae ani Yaubada givelena badi gavega bonana ivenogalena ani wagaidiya.” Taidei anafaiweya afositolo ivona. ");
INSERT INTO bwd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aku badi Kanisela vona taidei inogalina ayo inuwakoyo-mowa, ada nuwanuwadi afositolo ina luvealikadi. ");
INSERT INTO bwd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aku kaliva seyana Kanisela wagaidiya-deya anayegana Gamaliyeli, banae kaliva-nai Falisi anayoo ke veimeya anatovewala, ada kaduwe kaliva moyaidi ivemoimoinena. E ani banae adimwatuguya gimididi giveimeya ke afositolo ina veyegemonidi wamelaleya tova maufona wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Afositolo iyegemona aku bana Gamaliyeli givebutu Kanisela wagaidiya giifufu, givona, “Imi meIsileli, wana nuwanuwa-dewadewa gavana wanagai taidei kaliva-dina wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Faina malamala gavaiyei giavaidi wagaine kaliva seyana giyegemona anayegana Teudasi. Banae givona vaita bana tonagona lakaina, ada kaliva adiyoo fowa analedi (400) anafaiweya imuliyena. Aku muliya iluvealikana, ada anatomuliyayavo iawala ke yana veimeya matatabuna giavaina. ");
INSERT INTO bwd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kaduwe muliya kabemali yadi tova yegana yaudi anatoveya, kaliva seyana giyegemona anayegana Yudasa kwana Galili, ada kaduwe kaliva tufodi ginagoyedi. Aku kadu anafaiweya, banae iluvealikana ada anatomuliyayavo nuwadi giabidi ani iawala inau. ");
INSERT INTO bwd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","E ada malinai taidei kaliva-dina faidiya gana vonemi. Auwe wana kisegedi inanau. Faina kai yadi nuwanuwa ke yadi gugai vuvuna kaliva wagaidiya-deya, aga gina avaina. ");
INSERT INTO bwd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Aku kai vuvuna Yaubada wagaine, aga keke amifaiweya taidei kaliva-dina wana awatadi, faina wana itanuwagana Yaubada wagaine walulugaviya.” Taidei anafaiweya Gamaliyeli givona ada badi Kaniselayavo yana vona wagaine nuwadi giabidi. ");
INSERT INTO bwd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ada afositolo idouwe-vagiledi iluku, ada filisimani iveimeyedi ke ilavulavudi. Ada ilavudi giavaina, kaduwe iawatadi ivona, “Auwe wananau, aku keke maita kaduwe Yeisu anayeganeya wana ifuifufu kaliva wagaidiya.” E ada ietoyavudi inau. ");
INSERT INTO bwd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","E au afositolo Kanisela isegedi ke wa yadi vemwamwala inau. E, ivemwamwala faina inuwanuwa vaita badi iwakadiyavo Yaubada matane ke giawaegedi vovomumu ina nuwagana Yeisu anayegana faina. ");
INSERT INTO bwd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ada yadayada seyana seyana ivevewala ke ilulumamala ani Yeisu au Yaubada yana Mesaiya. Taidei anafaiweya inunauwena manuwa tabu wagaine ke kaduwe kaliva yadi manuwa wagaidiya, keke ida ilova. ");
INSERT INTO bwd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ada tayuwe yadayada-dina wagaidiya Yeisu yana tonogala adiyoo giveiveinala. Ada imiyamiya e aku tova seyana badi meya Giliki anatoifufu ani badi meya Ibeliu anatoifufu igavoluvoluyedi. Ivonavona vaita yadayada seyana seyana aa anavutuga wagaine taudiyavo yadi sikwasikwa adivutuga kabisona, aku badi meya Ibeliu anatoifufu ani yadi sikwasikwa adivutuga lakaina. ");
INSERT INTO bwd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","E ada afositolo adituwelo tonogala moyaidi idouwevagauwidi ada ivonedi, ivona, “Kai ime aa anavutuga ana itaveyabina aku Yaubada yana vona analaumamala ana ilovena, aga wada keke gida luboda. ");
INSERT INTO bwd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","E ada tubuiyameyavo, kaliva adiseveni wa adivetumagana wana venuwadadanedi amimwatuguya, badi imaga Aluwaluwa Tabuna wagaine ada kaduwe tonuwanuwa velemoedi. E ada aa anavutuvutuga ana veledi ina gugaiyena, ");
INSERT INTO bwd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","aku ime taumeyavo ani ana awaegema veoveola ke Yaubada yana vona analaumamala wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ada tovetumagana matatabudi afositolo yadi ifufu inogalina ada nuwadi givemwamwala. E ada kaliva seyana ivenuwadadanena ani anayegana Sitiveni, banae yana vetumagana lakaina kaduwe Aluwaluwa Tabuna wagaine gimaga-mowa. Ada kaduwe kaliva tufodi ivenuwadadanedi anafaiweya, adiyegana Filipi, Polokalasi, Naikena, Timoni ke Pamenasi, ada kaduwe Nikolasi kwana Anitiyoki banae keke kwana Isileli aku meIsileli yadi tafalolo wagaine gidamana. ");
INSERT INTO bwd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ada taidei kaliva-dina afositolo matadiya ivemidididi, ada nimadi isedi seyana seyana wagaidiya aku iveoveola faidiya. ");
INSERT INTO bwd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ada Yaubada yana vona gimutula ginau, ada kaliva moyaidi inogalina ke ivetumaganena. Ada tonogala yadi yoo Yelusalema wagaine giveinala-mowa, kaduwe veyavo anatovegugaiyavo tufona moyaidi valeya iwakana ivetumaganena ada imatawalewaleyena. ");
INSERT INTO bwd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aku banae Sitiveni ani aseasena gimaga Yaubada yana nuwadoga wagaine, kaduwe tova moyaina Yaubada yana toyogina wagaine gimiyamiya faina, gugai ebameyasidobodobo ke iyaiyaya lakaidi gigugugaiyedi kaliva adimwatuguya. ");
INSERT INTO bwd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aku kaliva tufodi ivenibainena, meIsileli adiyoo seyana. Badi kaliva-dina manuwa ebavewala wagaine ivagavagauta, ada manuwa-nai ivewagana Togugai Etoetoyavugidiyavo Yadi Manuwa Ebavewala. Ada badi meIsileli-dina yadi melala adiyegana Sailini kaduwe Alekisanidia, kaduwe badi meIsileli Silisiya ke Eisiya adifafali wagaidiya ani kaliva-dina ivebutu Sitiveni nodi ivevonavona toyogina. ");
INSERT INTO bwd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Aku Aluwaluwa Tabuna nuwauya lakai-vagaina Sitiveni givelena faina, yana vona wagaidiya iveyamata. Keke adifaiweya ina vonalufata. ");
INSERT INTO bwd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aku badi meIsileli kaliva tufodi ivonekavuyedi ke ina vonaga, “Bana kaliva-nai anogalina givona awadamana Mosese wagaine, ada kaduwe Yaubada wagaine.” ");
INSERT INTO bwd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","E ada badi yadi ifufu-nai wagaine, meIsileli yoo ada kaduwe kaliva lakaidiyavo ke veimeya anatovewalayavo ikivenuwakoyodi. E ada Sitiveni ivenibainena ke ina ikiveyabi inauwena meIsileli yadi Kanisela wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ada Sitiveni ilukuwena Kaniselayavo wagaidiya, aku kaduwe toveloi nodi ilukuwedi ke bana faine ifwaya ivona, “Bana kaliva-nai tova moyaina yada manuwa tabutabuna ada kaduwe Mosese yana veimeya giawaawavekoyoyedi. ");
INSERT INTO bwd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ime anogalina givona vaita Yeisu Banae kwana Nasaledi manuwa tabu gida yawelina, ada veimeya Mosese yada yoo nagona giveledi ke ivesesevedamana wagaideya, ani gida sevedavedamadi aku veimeya evagudi gidasedi.” Taidei anafaiweya Sitiveni iveloina. ");
INSERT INTO bwd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ada kaliva moyaidi ebavevonayavuga anafafali wagaine-deya ani Sitiveni iitavutuvutuna, ada magigina iitana vaita anelose magigina anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ada veyavo anatovegugai aditonagona Sitiveni gitolidadanena, givona, “Taidei anafaiweya velemoena uvona o kai keke?” ");
INSERT INTO bwd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ada Sitiveni gilufata taidei anafaiweya, givona, “Tubuiyakuweyavo ke kaduwe kamakuweyavo, yaku vona wana nogalina. Tova tuwaina wagaine Yaubada wa yana iwakana mamalina giyegemona tamada nagona Ebelaamo wagaine, tova-nai gimiyamiya Mesopotemiya anafafali aku aimo keke gidana melala Elani wagaine gida miyami. ");
INSERT INTO bwd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ee, Yaubada giyegemona wagaine ada givonena, givona, ‘Una mididi ada ya fafali, ya kalivayavo ke ya gabuyavo una madusegedi aku fafali seyana gana vewaleni wagaine unanau.’ ");
INSERT INTO bwd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Taidei anafaiweya Yaubada givonena ada Ebelaamo gitauya yana fafali Kalidiya gisegena aku ginau melala-nai anayegana Elani wagaine gimiyamiya. “Gimiyamiya aku tamana gialika, ada muline taidei fafali-nai wagaine kamiyamiya idedeku ani Yaubada giimili gielai. ");
INSERT INTO bwd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Taidei fafali-nai wagaine gielai aku keke maita babi gidavele, aku givonadabadabayena vaita taidei babi-nai gina velena, kaduwe aimo anaunumayavo ina tubulalaga wagaidiya gina veledi. Taidei anafaiweya Yaubada givonadabadaba aku tova-nai wagaine Ebelaamo natuna keke. ");
INSERT INTO bwd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kaduwe Yaubada Ebelaamo givonena, ‘Aimo ya tubudelideliyavo inanau ina veawawala mali fafali ke atuwadeya, ada wadedeku ina vetogugai yogoyogodi. Ada malamala fowa analedi (400) wagaidiya fafali-nai anatomiya ina veimeyedi ke ina luimiimilidi gugai vitadi wagaidiya ada yadi miya ina kivevitana. ");
INSERT INTO bwd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Aku fafali-nai anatomiya adiyoo wagaidiya ya tubudelideli ina vetogugai yogoyogodi ani aimo gana vematavulogidi. Ada muline ya tubudelideliyavo tayuwe fafali-nai wagaine ina yegemo aku taidei fafali-nai wagaine inaelai ke ina oduodu wagaikuya.’ Taidei anafaiweya Yaubada Ebelaamo wagaine givona. ");
INSERT INTO bwd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ada muliya Yaubada yana veyavo anawai gisena Ebelaamo wagaine ke giveimeyena anaunumayavo wagaidiya vovodi bubuna ina tomogoloidi yana veyavo anaiyaiyaya faina. E ada tova-nai Ebelaamo natuna Aisake givetubuna, ada anayadayada eita wagaine iyaiyaya-nai faina vovona bubuna gitomogoloina. Ada anafaiweya Aisake natuna Iyakobo givetubuna ada vovona bubuna gitomogoloina, ada kaduwe anafaiweya Iyakobo natunavo kaliva adituwelo vovodi bubudi gitomogoloidi, badi adituwelo tamadeyavo nagona. ");
INSERT INTO bwd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Aku tamadeyavo-dina ani taidi Iyosefa iveumagigiyena, e ada mali kaliva wagaidiya ivekimoneyena. Ada badi kaliva-dina Iyosefa inauwena Itipita wagaine ada givetogugai yogoyogona. Aku Yaubada nodi, ");
INSERT INTO bwd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ada anavita moyaina wagaidiya gikibababalena. Ee, nuwauya ada kaduwe yana vemoimoina Felo meItipita yadi kini matane givelena. Taidei faina Felo fafali Itipita matatabuna anatoveimeya Iyosefa gisena, kaduwe yana manuwa negenine ebaveimeya moyaidi wagaine givelena. ");
INSERT INTO bwd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ebaveimeya givaina muline, loka lakaina giyegemona fafali Itipita ada Kenani matatabuna wagaidiya, ada moyaidi vita lakaina inuwagana. Badi tamadeyavo adiga keke. ");
INSERT INTO bwd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Imiyamiya aku Iyakobo gikaiyanogala vaita aa Itipita wagaine gimiyamiya, e ada natunavo, badi tamadeyavo nagona, ani giimilidi inau Itipita. Yadina nagona wagaine taidi ibavuyena. ");
INSERT INTO bwd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ada muliya yadina anavelu wagaine Iyosefa tauna giawamogatalena tubuiyanavo wagaidiya vaita banae taidi, ada Felo gikaiyanogala Iyosefa yana gabuyavo faidiya. ");
INSERT INTO bwd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","E ayo Iyosefa matawa giimilina tamana Iyakobo wagaine ke banae ada yana gabu matatabudi ina elai Itipita wagaine ina miyamiya. Adiyoo seveniti faifi (75). ");
INSERT INTO bwd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ada au Iyakobo ginau Itipita wagaine, gina gimiyamiya anaunumayavo nodi, ada wadedeku-deya banae ke natunavo, badi tamadeyavo nagona, ialika. ");
INSERT INTO bwd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ada aimo vovodi iyewedi melala anayegana Sekemu ke didikula luwa wagaine isedi tuwaina Ebelaamo mani wagaine gikimonena unuma adiyegana Amo ani wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Malamala bademowa gavaiyei giavaidi aku Yaubada yana vonadabadaba-nai anatova givelilivana gina yegemona velemoena ani gina vaiyewedi Kenani anafafali wagaine, anafaiweya Ebelaamo wagaine tuwaina givonadabadabayena. Aku tova-nai wagaine yada yoo Itipita wagaine giveinala-mowa. ");
INSERT INTO bwd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ada yoo bademowa giveinala-mowa aku kadu kini seyana evaguna Itipita wagaine yana veimeya givevuvu, aku Iyosefa bademowa tuwaina gialika ani kini-nai keke banae gida alamane. ");
INSERT INTO bwd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Banae yada yoo gifwayadi lakaina, ada tamadeyavo giluimiimilidi ke giveimeyedi bebeta evagudiyavo melaleya inasese-kavovodi e ada inami ina alika. ");
INSERT INTO bwd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Taidei veimeya-nai anatoveya Mosese gitubuga, kwamana iwakana Yaubada matane. Ada vaikoi toiye wagaidiya inana ke tamana manuweya imiyanena ke iitaveyabina. ");
INSERT INTO bwd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Vaikoi toiye giavaidi, Mosese inauwe isena melaleya aku Felo natuna vavine ginuwagana ke gisilakaina, ada giawavenatunena vaita tauna natuna anafaiweya. ");
INSERT INTO bwd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ada meItipita yadi nuwauya moyaina Mosese ivewale-yabuna, ada yana vona ke yana gugai wagaidiya gitoyogina velemoena. ");
INSERT INTO bwd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Aku Mosese anamalamala foti (40) wagaine, ginuwanuwa yana yoo meIsileli gina madubodadi. ");
INSERT INTO bwd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ada giobu badi wagaidiya ani giitana kwana Itipita gimunumununa kwana Isileli seyana, e ada gina gikibababalena. Ada kwana Itipita nimana gifatana, ada giluvealikana. ");
INSERT INTO bwd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosese ginuwanuwa vaita yana yoo nuwadi gida malina vaita Yaubada Mosese tauna nimana wagaine gina kibababaledi. Aku badi keke nuwadi gidamali. ");
INSERT INTO bwd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yadayada anavelu wagaine Mosese giyegemonidi meIsileli adiselu ivemunumunuga, ada nuwanuwana ina ilovau aku gina veseyana-vagiledi e ada wa yadi nuwaniwalova nodi ina miyamiya. Taidei faina givonedi, givonaga, ‘Imi kaliva wana nogalina. Ina tubuiya nonogana. Gavana faina taumiyavo wavekivekivekoyo?’ ");
INSERT INTO bwd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Aku bana kaliva-nai nagona gimaduilavuga ke tubuiyana gilumalimaliwavuna ani banae Mosese giluegena aku givonena, ‘O gaito giseni-yo oyeni uvetoveimeya ke uvetovevonayavuga wagaimeya? ");
INSERT INTO bwd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kai unuwanuwa evona Iya kaduwe una luvealikaku boi kwana Itipita uluvealikana anafaiweya?’ ");
INSERT INTO bwd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ada Mosese kwana Isileli yana vona ginogalina wagaine, au Itipita gisegena ke giota ginau fafali Midiyani wagaine givekwana awawala. Ada wadedeku-deya ginagi ke kaliva adiselu givetubudi. ");
INSERT INTO bwd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Malamala foti giavaina, tova seyana Mosese gimiyamiya Oya Sainai anafafali kavovona wagaine aku anelose giyegemona bana wagaine. Ai kabisona seyana gialalata aku meyana wagaine anelose-nai giyegemona. ");
INSERT INTO bwd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ada Mosese giitana wagaine, meyana gisidobodobona faina ai-nai keke gida alalai-yabu. E ada maita ginau lilivane ke ginaita-dewedewena ani KAUVEYA bonana ginogalina, givonaga, ");
INSERT INTO bwd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iya tamamomo yadi Yaubada, badi Ebelaamo, Aisake, ke Iyakobo yadi Yaubada.’ Ada Mosese ginogalina wagaine, givebutu givetavetatava ke gimatauta lakaina ada keke-bamowa nuwanuwana ginaita wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ada KAUVEYA givonena, givona, ‘Aageyafayafa una kakina, faina babi-nai wagaine umidimididi ani tabutabuna. ");
INSERT INTO bwd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","MeItipita yaku yooyavo iluimiimilidi ada yadi mulolova gaitana. Yadi tagiya ganogalina, e ada gaobuelai ke gana kibababaledi faina. E ada una mididi, Itipita wagaine gana imilini ke unanau.’” Taidei anafaiweya KAUVEYA givona ani Sitiveni givonayena. ");
INSERT INTO bwd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kaduwe Sitiveni yana laumamala wagaine givona, “Aku taidei Mosese-nai badiyavo meIsileli idibusoyogena. Faina ivonenaga, ‘O gaito giseni-yo oyeni uvetoveimeya ke uvetovevonayavuga wagaimeya?’ E ani banae kaliva-nai Yaubada Tauna giimilina ke gina veimeyedi ada gina kibababaledi. E, anelose awane giimilina, tova-nai ai gialalata negenine giyegemona Mosese wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ada banae-nai meIsileli givagauledi giyegemonedi Itipita wagaine-deya, ada ebameyasidobodobo ke gugai lakaidi Itipita wagaine ada Leyaga Yabeyabelina wagaine gigugaiyedi. Ada fafali kavovona wagaine kaduwe gigugaiyedi anafaiweya malamala foti wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Kaduwe taidei Mosese-nai banae meIsileli givonedi, givona, ‘Yaubada aimo Falofita seyana gina vemididina imi faimiya Iya anafaiweya, Banae taumiyavo amiyoo wagaine-deya.’ ");
INSERT INTO bwd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kadu bana Mosese ani meIsileli nodi ivagauta fafali kavovona wagaine. Ada kaduwe banae tamadeyavo nagona nodi imiyamiya, ada gilaka Oya Sainai wagaine anelose nodi iifufu, ada Yaubada yana vona wayawaina ginogalina ke ide wagaideya gina vesesevedamana faina. ");
INSERT INTO bwd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Aku banae yana veimeya ani tamadeyavo-dina iawaegegena ada nuwainagediya inuwanuwa vaita ina yewadi Itipita wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Taidei anafaiweya inuwanuwa faina, Mosese tawagana Eloni wagaine ivona, ‘Kilumina una bubudi yada yaubada ke ina nagoyeda. Aku bana Mosese-nai Itipita wagaine givagauleda ani gavana giyegemona wagaine? Keke ada alamane!’ ");
INSERT INTO bwd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","E ada tayuwe tova-nai wagaine kilumina anaita vaita bulumakau natudi anafaiweya ibubuna. Ada kevakeva ialiyedi ivebolavoiyedi kilumina-nai wagaine, ada abutu ibubuna ke ivemwamwala lakaina gaitoma-nai taudiyavo nimadiya ibubuna faina. ");
INSERT INTO bwd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","E aku Yaubada givedomobubusedi ada gikisegedi ke ina oduodu kauwana, vaikoi, ada ailabama wagaidiya. Taidei gavana anafaiweya bademowa ivetokilumina gimiyamiya falofita yadi buki wagaine, givona, ‘Imi meIsileli, keke Iya faikuya kevakeva wada munumunudi ada wada vevebolavoiyedi malamala foti fafali kavovona wagaine. Keke. ");
INSERT INTO bwd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aku yaubada fwayafwaya-nai Molaki ani bana yana manuwa sinininila waavaladadanena, ke kaduwe yaubada fwayafwaya seyana anaita anafaiweya ailabama anayegana Lefani waavaladadanena. Adiselu wabubudi ke wana oduodu wagaidiya. Taidei faina gana wavimi ke wana yegemona atuwadeya melala Babiloni fafaline ke wana veawawala.’” Taidei anafaiweya Yaubada yana falofita awane meIsileli wagaidiya givona ani Sitiveni givonayena. ");
INSERT INTO bwd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kaduwe Sitiveni givona, “Manuwa sinininila tabutabuna giiveivemogatalina Yaubada badi nodi imiyamiya ani tamadeyavo nagona nodi fafali kavovona wagaine imiya. Yaubada Tauna Mosese giveimeyena ada giawavetunugina mamauwe ibubuna. ");
INSERT INTO bwd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ada manuwa sinininila-nai ani tamadeyavo isedamanena natudiyavo wagaidiya. Ada fafali taidei anatomiya adiyoo tulina tulina Yaubada givenegadi aku Iyosuwa tamadeyavo givagauledi ada manuwa sinininila tabutabuna nodi iluku fafali taidei wagaine. Ada gimiya analaba Deivida yana tova kini wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Bana Deivida aseasena iwakana Yaubada matane faina, Yaubada giawaveiwakanena, ada Deivida giveola, givona, ‘Oyeni tamama Iyakobo yana Yaubada. Iya nuwanuwaku uda awaegeku ke ya ebamiya gada yogona.’ ");
INSERT INTO bwd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Taidei anafaiweya Deivida givona aku bana keke gidayogo, aku natuna Solomoni Yaubada yana manuwa giyogona. ");
INSERT INTO bwd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“E aku Yaubada Togetanemwane ani keke gida miyami manuwa wagaidiya kaliva iyogodi, keke. Anafaiweya tuwai-moena falofita seyana givona, ");
INSERT INTO bwd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Iya KAUVEYA. Gabama ani yaku veimeya anaebavetoga kaikaiwabuna, ada babi ageku anaebaibo. E ada gavaiyamu manuwa wana yogona Iya faikuya? Gava ebamiya wana bubu ayo gana veyawai? ");
INSERT INTO bwd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Au keke amifaiweya, faina gabama ke babi ke adigaitoma moyaina ani Iya Tauku nimakuya gabubudi.’” Taidei anafaiweya tuwai-moena falofita givona, ada bana Sitiveni giifufuyena. ");
INSERT INTO bwd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kaduwe Sitiveni giifufu meIsileli yadi Kanisela wagaidiya, givona, “Imi tagami kuluna. Badi mali kaliva keke Yaubada ida vetumagane ani tayuwe anafaiweya imiyavo. Keke nuwanuwami Yaubada yana vona wana nogali, kaduwe keke nuwanuwami Banae nuwami gina kivemali. Tova moyaina Aluwaluwa Tabuna waveveluegena. Tamamiyavo nagona idewa anafaiweya, imi tova taidei wadewadewa. ");
INSERT INTO bwd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tamamiyavo-dina ani falofita matatabudi ikiveuloulolonidi, keke tamo gaito wagaidiya idadewe iwakana. Au badi falofita-dina Yaubada yana Toyegayegana yana obuela faina ivonaye-vagaina ani iluvealikadi. Ada tova malinai bademowa giobuelai aku imi waatuegena nibainavo nimadiya ke waluvealikana. ");
INSERT INTO bwd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Imiyavo ani Yaubada yana veimeya wavaina, veimeya-nai anelose iveledi tamamiyavo nagona. Aku taumada, keke wada itaveyabi.” Taidei anafaiweya Sitiveni yana laumamala giluyabuna. ");
INSERT INTO bwd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Aku badi Kaniselayavo Sitiveni taidei yana vona inogalina, ada magigidi gitafayaina ke agodi givetalakikita. ");
INSERT INTO bwd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aku Sitiveni ani Aluwaluwa Tabuna wagaine gimaga, ada giitalaka ada gabama giitafolena ke giitana Yaubada yana iwakana mamalina, ada kaduwe Yeisu Yaubada aiyatagine gimidimididi giitana. ");
INSERT INTO bwd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ada givona, “Wana itana! Gaitana gabama giawaina aku Banae Kaliva Natuna gimidimididi Yaubada aiyatagine!” ");
INSERT INTO bwd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Taidei anafaiweya givona ada badi Kaniselayavo ikovatalaga ke nimadiya tagadi ikibodadi, aku moyaidi aigaigabu Sitiveni wagaine imadu inau ");
INSERT INTO bwd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","isitaitai iyegemonena melala lakaina ke ivebutu kabala wagaine itutuvealikana. Ada badi toifiyaga adinuya anakiwafi iveyalilidi ke tubulakata seyana anayegana Saulo wagaine isedi ke gina itaveyabidi. ");
INSERT INTO bwd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ada badi ifiyafiyana kabala wagaine aku Sitiveni giveola Kauveya wagaine, givona, “Kauveya Yeisu, aluwaluwaku una vaina.” ");
INSERT INTO bwd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ada tugana givetodonena ke bonana lakaina wagaine givona, “Kauveya, yadi koyona taidei faina keke wagaidiya una lufata.” Vona taidei giinanana muline, yawaina giavaina. ");
INSERT INTO bwd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","E aku Saulo nodi wadedeku, ada badi Sitiveni itutuvealikana ani giawaveiwakanena. Aku yadayada-nai wagaine kaliva ivebutu tovetumagana adiyoo Yelusalema wagaine ikiveuloulolonidi lakaina. Taidei faina tovetumagana moyaidi iawala inau Yudiya ke Sameliya adifafali wagaidiya, aku afositolo gaga imiya Yelusalema wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Aku kaliva tufodi badi Yaubada anatooduoduyavo ani Sitiveni itavuna, ada bana faine itagiya lakaina. ");
INSERT INTO bwd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Aku bana Saulo givebutu tovetumagana adiyoo giluveyawaliyedi. Au manuwa seyana seyana wagaidiya ginaunau ke tovetumagana kaliva ke vevine gisitaitaidi ginaunauwedi deli wagaine gisesedi. ");
INSERT INTO bwd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Aku badi tovetumagana iawala ani inau fafali moyaina wagaidiya, ada yadi nau-nai wagaine valeya iwakana ilumamalenauwena. ");
INSERT INTO bwd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Bana Filipi ginau melala anayegana Sameliya wagaine ada meSameliya wagaidiya gilumamala Keliso faine. ");
INSERT INTO bwd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ada yoo lakaina yana laumamala inogalina kaduwe iyaiyaya ebameyasidobodobo gigugaiyedi iitana, e ada moyaidi inogala-dewadewa. ");
INSERT INTO bwd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Faina tauna aluwaluwa bwanebwanenedi giveimeyedi ina yegemona kaliva wagaidiya, ani ikova moiyalidi aku iyegemona. Kaduwe moyaidi tovefela o kai badi vovodi memeluyadi ani iveiwaka. ");
INSERT INTO bwd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ada moyaidi iveiwaka faina, meSameliya ivemwamwala lakaina. ");
INSERT INTO bwd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Aku tayuwe melala-nai wagaine kaliva seyana gimiyamiya anayegana Saimoni. Banae tokwelikweli yadi gugai tuwaina givaina ada yana gugai-nai wagaine meSameliya moyaidi meyadi givesidobodobona. Tauna givewagana vaita banae anayegana lakaina, ");
INSERT INTO bwd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ada kaliva moyaidi, lakaidiyavo kaduwe kabisodiyavo, yana vona inogali-dewedewena. E ada ivonavona, “Bana taidei kaliva-nai vaita Yaubada ivewagana Toyogina Lakai-moena.” ");
INSERT INTO bwd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ada iyaiyaya ebameyasidobodobo yana vekwelikweli-dina gigugaiyedi wagaidiya ani meyadi givesidobodobona. Ada taidei anafaiweya bademowa ginunauwena tova manamanawena faina, moyaidi nuwadi giabidi. ");
INSERT INTO bwd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aku tova-nai Filipi gilumamala Yaubada yana ebaveimeya anavaleya iwakana kadu Yeisu Keliso anayegana faina, inogalina ke ivetumaganena ada ibabitaiso, kaliva ke vevine. ");
INSERT INTO bwd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kaduwe bana Saimoni tauna Yeisu wagaine givetumagana ada gibabitaiso. Gibabitaiso muline, tova moyaina Filipi gimuliyedadanena, ada giitana iyaiyaya lakaidi ke gugai ebameyasidobodobo wagaine ada au meyana gibovu. ");
INSERT INTO bwd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aku afositolo Yelusalema wagaine meSameliya valeyadi inogalina vaita bademowa Yaubada yana vona ivetumaganena, ada Pita ke Iyoni iimilidi inau wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ada tova-nai iyegemona Sameliya, iveoveola tovetumagana faidiya ke Aluwaluwa Tabuna ina nuwagana. ");
INSERT INTO bwd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Faina Aluwaluwa Tabuna aimo keke tamo gaito badi wagaidiya gida vemaga. Au Kauveya Yeisu anayeganeya bademowa ibabitaiso. ");
INSERT INTO bwd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","E ayo Pita ke Iyoni nimadi isedi wagaidiya ke Aluwaluwa Tabuna inuwagana. ");
INSERT INTO bwd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aku Saimoni-nai giitaita badi afositolo nimadi tovetumagana wagaidiya isedi ada Yaubada Aluwaluwa Tabuna giveledi. E ada mani gitunena Pita ke Iyoni wagaidiya ");
INSERT INTO bwd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ada givonedi, givona, “Taidei toyogina Iya kaduwe wana veleku e ada badi gavega wagaidiya nimaku ganasedi, anafaiweya kaduwe Aluwaluwa Tabuna ina nuwagana.” ");
INSERT INTO bwd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aku Pita givonena, givona, “Taumada! O ya nuwanuwa vaita Yaubada yana nuwakabubu mani wagaine afaiweya una kimonena faina, oyeni ke ya mani-nai nodi wana kwayabu! ");
INSERT INTO bwd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ya nuwanuwa keke tunutunugina Yaubada matane faina, keke afaiweya taidei Yaubada yana gugai ime nodi kana gugai. ");
INSERT INTO bwd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Ya nuwakoyo bade unauwena-deya givegolagola ani gaitanuwagana. Kadu ya nuwanuwa koyona gikiveyabini e ada giyogoni umiyamiya. Taidei faina una nuwavilana ke ya nuwanuwa koyo-moena una dibusoyogena, ada Kauveya wagaine una veoveola e ada meyameyaganina ya nuwanuwa koyona gina venuwaegena.” Taidei anafaiweya Pita givona. ");
INSERT INTO bwd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ada Saimoni givona Pita ke Iyoni wagaidiya, “Amiselu wada veoveola Kauveya wagaine Iya faikuya ke taidei gaitoma-nai wavonayena ani keke maita gina yegemona wagaikuya.” ");
INSERT INTO bwd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ada Pita ke Iyoni Kauveya Yeisu faine iawatalatalainena kaduwe Kauveya yana vona ilumamalena kaliva wagaidiya, muliya-yo iyewadi Yelusalema. Ada yadi nau-nai wagaine meSameliya yadi melala moyaina wagaidiya valeya iwakana ilumamalenauwena. ");
INSERT INTO bwd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Badi inau aku Kauveya yana anelose seyana gielai Filipi wagaine ada givonena, givona, “Una mididi ada unanau wabolimaneya waina, e taine wai-nai Yelusalema-deya ginaunau Gasa. Tayuwe ani fafali kavovona wagaine.” ");
INSERT INTO bwd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ada Filipi gimididi ke gitauya ginaunau aku kaliva seyana wai wagaine ginuwagana. Banae kwana Itiofia, kaliva lakaina, Kanidesi badiyavo meItiofia yadi kwini yadi mani ke kaikaiwabu matatabuna anatoitaveyabina. Ada kaliva-nai bademowa Yelusalema wagaine gina gioduodu Yaubada wagaine, ");
INSERT INTO bwd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ada giyewayewana yana melala wagaine. Ada givetoga yana salioti wagaine aku falofita Aiseya yana buki wagaine giveyaveyawa. ");
INSERT INTO bwd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Bana ginaunau aku Aluwaluwa Tabuna Filipi wagaine givona, “Unanau tayuwe salioti lilivane una naunau.” ");
INSERT INTO bwd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ada gimadu ginau salioti-nai wagaine ke kaliva bonana ginogalina falofita Aiseya yana buki wagaine giveyaveyawa. E ada gitolidadanena, givona, “Gavaiyamu, taine uveyaveyawana ani ananuwanuwa nuwa gimalina?” ");
INSERT INTO bwd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ada gilufata, “Gavaiyamu gana alamane, faina akutokivetuvetunuga keke.” Ada givonena ke ginayage gina vetoga bana nodi salioti wagaine inanau, ada au giyage. ");
INSERT INTO bwd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ada Buki Tabu wagaine giveyaveyawa ani yana maita taidei anafaiweya givona, “Sifi inauwena ke ina luvealikana anafaiweya, Bana inauwena. Ada sifi kabisona vutuvutuna anatoitotoga matane keke gina kwage anafaiweya, Bana gikulu-moena. Keke tamo gavana gidavone. ");
INSERT INTO bwd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Keke tamo koyona gida gugaiye aku ikivevovomumu-kavovona, ada yana vonayavuga keke tunutunugina. Ada keke tamo gaito anaunumayavo faidiya gina ifuifufu, faina yawaina idabana babi wagaine-deya.” Taidei anafaiweya Aiseya givona ani kwana Itiofia giveyaveyawana. ");
INSERT INTO bwd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ada kwana Itiofia Filipi givonena, “Uda kivemaliku. Gaito faine falofita taidei anafaiweya givonavona? Givonavona tauna faine o kai seyana gaito faine?” ");
INSERT INTO bwd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","E ada Filipi maita-dina Aiseya yana buki wagaine givevuvu, ada valeya iwakana Yeisu faine giifufuyena. ");
INSERT INTO bwd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ada wai wagaine inaunau aku iyegemona seyana gufa wagaine, ada bana kwana Itiofia givona, “Uitana, gufa taidei gimiyamiya. Aku Iya faikuya ani gavaiyamu, kai tamo vuvu giawataku e ada keke akufaiweya gana babitaiso?”  ");
INSERT INTO bwd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipi givonena, givona, “Kai Yeisu Keliso wagaine velemoena uvetumagana aga afaiweya-mowa una babitaiso.” Ada bana kwana Itiofia givona, “Gavetumagana velemoena Yeisu Keliso Banae Yaubada Natuna.” ");
INSERT INTO bwd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ada yana salioti anatovemadu giveimeyena ke giilovau. Ada Filipi ke kwana Itiofia adiselu iobu gufa wagaine ada Filipi gikivebabitaisona. ");
INSERT INTO bwd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","40","Tova-nai gufa wagaine-deya ivilakata, ada Kauveya Aluwaluwana Filipi gisiveyavegina ada maduga-mowa giyegemona melala anayegana Asotasi. Ada kwana Itiofia keke gidaita-vagile aku wa yana vemwamwala ginau. Ada Filipi gilumamalanau melala moyaina wagaidiya analaba giyegemona Sisalia. ");
INSERT INTO bwd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Aku tova tayuwe wagaine Saulo aimo Yeisu yana tonogalayavo giawaawavematausidi vaita gina luvealikadi. Au ginau veyavo anatovegugai aditonagona wagaine ");
INSERT INTO bwd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","giveola ke leta gina vetokilumidi ada manuwa ebavewala moyaidi melala lakaina Damasiko wagaine gina nauwedi. Ada badi manuwa ebavewala aditonagonayavo leta-nai ina itana ada Saulo anaveimeya ina alamanena, e ada badi gavega Kauveya Yana Wai anatomuliya, kai kaliva o kai vavine, biyavo-dina gina kiveyabidi ke Yelusalema wagaine gina aliyedi. ");
INSERT INTO bwd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","E, ada gitauya ginaunau Damasiko wagaine aku bademowa ginunuyegemona melala lilivane ani maduga-mowa gabameya-deya malina lakaina ginununa ada Saulo gimalivuyona. ");
INSERT INTO bwd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ada gibeu babiya aku bonabona seyana ginogalina givonena, givona, “Saulo, Saulo! Gavana faina ukiveulouloloniku?” ");
INSERT INTO bwd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ada Saulo givona, “Kauveya, o gaito?” Ada kaduwe bonana ginogali-vagilena, givona, “Iya Yeisu, Iya ukiveulouloloniku. ");
INSERT INTO bwd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Aku una mididi unana melala lakaina wagaine unaluku, ada wadedeku seyana gaito gina mataweni gavana unagai.” ");
INSERT INTO bwd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Aku badi kaliva-dina Saulo ikwayabuna ani meyadi gibovu, au imididi-vagata. Faina bonabona gaga inogalina aku keke tamo gaito idaita. ");
INSERT INTO bwd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ada malina-nai giavaina, Saulo gimididi ada matana gialeleleyena aku keke tamo gavana anafaiweya gidaita. Bademowa matana gikoyo-mowa. Ada nimane iabi isivenavenau inauwena Damasiko wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ada yadayada toiye wagaidiya givematakoyo, ada keke tamo gavana gidakani o gidayui. ");
INSERT INTO bwd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Aku Damasiko wagaine tonogala seyana gimiyamiya, anayegana Ananaiyasi. Ada vewala seyana giyegemona bana wagaine, ada anavewala-nai wagaine Kauveya gidouwena, givona, “Ananaiyasi!” Ada givona, “Kauveya, Iyayeku.” ");
INSERT INTO bwd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ada Kauveya givonena, givona, “Una mididi ke wai anayegana Wai Tunutunugina wagaine unanau Yudasa yana manuweya, ada una tolidadana Saulo banae kwana Tasasi faine. Banae tova malinai giveoveola, ");
INSERT INTO bwd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ada anavewala wagaine giitana kaliva seyana anayegana Ananaiyasi, o unaelai ada nima unasedi bana wagaine ke ginaita-vagila.” ");
INSERT INTO bwd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Aku Ananaiyasi givona, “Kauveya, kaliva moyaidi ivoneku taidei kaliva-nai faine, ani ya kaliva tabutabudiyavo Yelusalema wagaine gikiveuloulolonidi lakaina! ");
INSERT INTO bwd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ada banae idedeku Damasiko wagaine gielai faina veyavo anatovegugai lakaidiyavo anaveimeya ivelena, ke ime gavega ayegana wagaine aoduodu ani gina kiveyabima ke gina nauwema.” ");
INSERT INTO bwd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Aku Kauveya givonena, givona, “Unanau, faina taidei kaliva-nai ani Iya gavenuwadadanena ke akuyegana gina kilakaina badiyavo gavega keke meIsileli, ada yadi kini wagaidiya, kaduwe meIsileli wagaidiya. ");
INSERT INTO bwd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aimo Iya gana vewalena, uloulolo lakaina gina nuwagana akuyegana faina.” ");
INSERT INTO bwd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ada Kauveya taidei anafaiweya givona, e ada Ananaiyasi gitauya ginau ada giluku manuwa-nai wagaine Saulo gimiyamiya. Ada nimana gisedi Saulo wagaine aku givona, “Tubuiyaku Saulo, Kauveya Yeisu wai wagaine giyegemona wagainiya tova-nai uelaelai idedeku, ani giimiliku ke unaita-vagila ada Aluwaluwa Tabuna gina vemagani.” ");
INSERT INTO bwd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ada maduga-mowa gaitoma vaita igana kwanavina anafaiweya ani Saulo matane ibeu, ada giita dewadewa. E au gimididi ada gibabitaiso. ");
INSERT INTO bwd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ada aa gikani muline, kaduwe yana toyogina ginuwaga-vagilena. Ada Saulo Damasiko wagaine gimiyamiya yadayada tufona Yeisu yana tonogalayavo nodi. ");
INSERT INTO bwd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ada manuwa ebavewala wagaidiya maduga-mowa gilukunau ke Yeisu faine gilumamala, givona, “Yeisu Banae Yaubada Natuna.” ");
INSERT INTO bwd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ada badi moyaidi gavega yana laumamala inogalina ani meyadi gisidobodobona ke ivebutu taudiyavo ivetolitoli, ivona, “Taumada! Kaliva-nai badi gavega Yeisu anayegana ivetumaganena Yelusalema wagaine ani gikiveuloulolonidi lakaina. Kaduwe taidei yana vuvuna-nai faina gielai idedeku, ada Yeisu anatomuliyayavo ide wagaideya-deya gina kiveyabidi gina nauwedi veyavo anatovegugai lakaidiyavo wagaidiya.” ");
INSERT INTO bwd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Taidei anafaiweya badi iifuifufu aku Saulo yana laumamala wagaine gitoyogina ada gitoyogi-moena. Ada meIsileli Damasiko wagaine imiyamiya ani giawavetunutunugidi vaita Yeisu velemoena Yaubada givenuwadadanena ani velemoena Venuvenuwadadanina. Ada yana awavetuvetunuga-nai wagaine gitoyogisegedi e ada keke adifaiweya bonana inafata. ");
INSERT INTO bwd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Aku yadayada gavaiyei giavaidi, meIsileli tufodi ivagauta ke iveimeya aigaigabu vaita Saulo ina luvealikana. ");
INSERT INTO bwd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ada yadayada ke bogi melala lakaina anaebaluku wagaine ibodabodana nuwanuwadi ina luvealikana faina, aku bademowa gaito seyana yadi nuwanuwa Saulo wagaine giawatalatalainena. ");
INSERT INTO bwd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Aku bogi seyana wagaine Saulo anatomuliyayavo ikavuya ivagaule inauwena, ada fuwama lakaina wagaine idodona ada melala anakali tutufolegeya iseobuyena babiya ke giota ginau. ");
INSERT INTO bwd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aku Saulo Yelusalema wagaine giyewana ada giyegemona wagaine, ginau tonogalayavo adiyoo wagaine gidaluku aku badi moyaidi imatausena, faina keke ida vetumagane vaita velemoena Yeisu wagaine gida vetonogala. ");
INSERT INTO bwd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Aku Banabasi gilemena, ada afositolo wagaidiya ginauwena ke bana faine gikivemalidi, Kauveya waiya giitana kaduwe bonana ginogalina ani giifufuyedi. Kaduwe givonedi, givona, “Banae Saulo wa yana asevatu Yeisu anayeganeya gilumamala Damasiko wagaine.” ");
INSERT INTO bwd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Taidei anafaiweya Banabasi givona e ada Saulo badi afositolo wagaidiya giluku nodi imiya Yelusalema wagaine. Ada Saulo wa yana asevatu gilulumamala Yeisu anayeganeya. ");
INSERT INTO bwd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kaduwe meIsileli badi tovona Giliki ani Saulo nodi ivevonavona, aku iveimeya aigaigabu ina luvealikana. ");
INSERT INTO bwd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aku tova-nai tovetumaganayavo ikaiyanogala yadi veimeya faina, Saulo inauwena Sisalia wagaine ada wadedeku-deya waka wagaine iveyagena ke ginau yana melala Tasasi wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","E ayo tovetumagana adiyoo imiyamiya Yudiya, Galili, ada kaduwe Sameliya adifafali wagaidiya ani wa yadi nuwaniwalova nodi imiyamiya, ada yadi vetumagana gitubutubuga. Kaduwe Aluwaluwa Tabuna gikikiveasevatudi ada moyaidi wa yadi matauta Kauveya ivemoimoinena, e ada adiyoo giveiveinala. ");
INSERT INTO bwd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Imiyamiya aku Pita melala tulina tulina wagaidiya ginaunau, ada tova seyana Yaubada yana kaliva tabutabudiyavo melala Lida wagaine imiyamiya ani wagaidiya gina gimadubodadi. ");
INSERT INTO bwd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Wadedeku-deya kaliva seyana ginuwagana, anayegana Iniya. Bana malamala eita gimiyamiya iviya, faina vovona memeluyana. ");
INSERT INTO bwd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ada Pita givonena, givona, “Iniya, Yeisu Keliso gikikiveiwakaneni. Una mididi aivi una uwana.” Ada maduga-mowa Iniya gimididi. ");
INSERT INTO bwd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ada meLida moyaidi kadu kaliva moyaidi imiyamiya laubeu anayegana Seloni wagaine, ani kaliva-nai iitana ada Kauveya Yeisu ivetumaganena. ");
INSERT INTO bwd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Aku vavine seyana melala-nai Yofa wagaine gimiyamiya, anayegana Tabita, ada banae tonogala. Vona Giliki wagaine anayegana Dokasa. Ada vavine-nai tova moyaina gugai iwakana gigugugaiyena ada fanifanidiyavo gilemelemedi. ");
INSERT INTO bwd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ada tova tayuwe wagaine Pita gielai melala Lida wagaine, aku Tabita veoga gikimunumunu-moena ke gialika. Ada vovona ikolana ada manuwa getana anatutulagolota wagaine isena. ");
INSERT INTO bwd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Aku melala Yofa ani Lida lilivane, ada tonogalayavo Yofa wagaine ikaiyanogala vaita Pita gimiyamiya Lida wagaine e ada kaliva adiselu iimilidi inau Pita ina vagaulena. Inau ada ivona, “Uda maduelai ime wagaimeya.” ");
INSERT INTO bwd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yadi vona Pita ginogalina ada gimididi nodi inau. Tova-nai giyegemona, iabi ilakavena manuwa getane anatutulagolota wagaine Tabita vovona isena. Ada sikwasikwa moyaidi Pita imidififina aku itagitagiya, ke kaduwe ivewavewalena nuya tulina tulina Tabita gionadi tova-nai aimo wayawaina wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Au Pita moyaidi givonedi iyegemona melaleya aku tugana givetodonena ke giveoveola Yaubada wagaine. E ada gimiyavilana toalika vovona wagaine ada givona, “Tabita, una mididi!” Au matana giabwana ada Pita giitana ani gimididi givetogana. ");
INSERT INTO bwd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ada Pita nimane giabi gisivemididina. E ayo tovetumagana ke sikwasikwa nodi gidouwedi iluku tutulagolota-nai wagaine, ada givewaledi Tabita wayawaina. ");
INSERT INTO bwd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ada vavine-nai valeyana gimutula ke meYofa moyaidi inogalina, ada tufona moyaidi Kauveya ivetumaganena. ");
INSERT INTO bwd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ada yadayada moyaina Pita gimiyamiya Yofa. Kaliva seyana anayegana Saimoni nodi, banae kevakeva bubudi anatokidewadewa. ");
INSERT INTO bwd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Aku kaliva seyana melala Sisalia wagaine gimiyamiya, anayegana Koneliyasi. Banae meLoma tolugaviya wani analedi (100) aditonagona, badiyavo imiyamiya tolugaviya adiyoo-nai lakaina wagaine iyegemona Itali anafafaliya. ");
INSERT INTO bwd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Banae keke kwana Isileli aku yana manuwa anatomiyayavo nodi wa yadi matauta Yaubada ivemoimoinena ada ioduodu wagaine. Kaduwe tauna tonuwadoga ke tova moyaina badi fanifanidiyavo gilemelemedi, ada tova moyaina Yaubada wagaine giveoveola. ");
INSERT INTO bwd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yadayada seyana teli kiloki lavilaviya ani vewala seyana giyegemona Koneliyasi wagaine. Ada anavewala-nai wagaine giita-dewedewena Yaubada yana anelose gielai wagaine ada anayegana giinanana, givona, “Koneliyasi.” ");
INSERT INTO bwd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ada Koneliyasi wa yana matauta lakaina anelose giitavutuvutuna aku givona, “Kauveya, gavana ya nuwanuwa?” Ada anelose givonena, “Bademowa Yaubada ya veoveola ginogalina ada ya nuwakabubu tofanifani wagaidiya giitana, e ada ginuwanuwa fainiya. ");
INSERT INTO bwd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ada kaliva tufodi una imilidi inanau Yofa wagaine ke kaliva seyana ina vagaulena, banae anayegana Saimoni-Pita. ");
INSERT INTO bwd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tova taidei gimiyamiya wagakoyona Saimoni nodi, bana kevakeva bubudi anatokidewadewa. Yana manuwa taliya lilivane.” ");
INSERT INTO bwd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Taidei anafaiweya anelose givona ada ginau, aku Koneliyasi yana togugaiyavo adiselu ke yana tolugaviya seyana gidouwedi ielai. Bana tolugaviya-nai Koneliyasi anatoleme, ada bana kaduwe Yaubada wagaine gioduodu. ");
INSERT INTO bwd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ada ielai wagaine ke giifufuyedi matatabuna gavana giyegemona wagaine, ada giimilidi inau Yofa. ");
INSERT INTO bwd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yadayada anavelu wagaine kauwana givugivudiya, aimo ielaelai aku bademowa inuyegeyegemona Yofa wagaine aku Pita gilaka manuwa getane gina veoveola faina. ");
INSERT INTO bwd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Aku mafa gilavuna ada nuwanuwana aa ginakani, aku aimo anaga ikidewadewa ani au vewala seyana giyegemona bana wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ada anavewala-nai wagaine giitana vaita gabama giawaina aku gaitoma seyana vaita nuya lalafana anafaiweya, ada bwatana laufuli wagaidiya iabi aku iseseobuyena babiya. ");
INSERT INTO bwd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Aku nuya-nai negenine kevakeva tulidi tulidi imiyamiya, madumadugidiyavo, yagayaganidiyavo ke yaveyavegadiyavo. ");
INSERT INTO bwd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ada bonabona seyana ginogalina, givona, “Pita, una mididi. Tamo kevakeva unamunu una kanina.” ");
INSERT INTO bwd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Aku Pita givona, “Kauveya, keke-bamowa! Keke tamo tova tamo gavana awaawatana o kai keke yegayegana Yaubada matane gadakani.” ");
INSERT INTO bwd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aku kaduwe bonabona-nai ginogali-vagilena, givona, “Gavana moyaina Yaubada bademowa gikiveyegayeganena, ani o keke una vewaga vaita keke yegayegana Banae matane.” ");
INSERT INTO bwd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ada taidei anafaiweya giyegemona tova toiye wagaine, au nuya-nai isilakaina gabameya. ");
INSERT INTO bwd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ada Pita aimo ginuwanuwa gavana taidei anavewala-nai ananuwanuwa, ani kaliva-dina Koneliyasi giimilidi bademowa inuwagana gadedeku Saimoni yana manuwa ada anaedawaneya imididina. ");
INSERT INTO bwd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ada itoliluvaluva ivona, “Kai ineneku Saimoni-Pita gimiyamiya?” ");
INSERT INTO bwd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Aku Pita ani anavewala-nai aimo faine ginuwanuwa aku Aluwaluwa Tabuna givonena, givona, “Una nogalina, kaliva aditoto o ileleleni. ");
INSERT INTO bwd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Una mididi unaobu, ada keke una venuwana aku au nodi wananau. Faina Iya gaimilidi ielai.” ");
INSERT INTO bwd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ada Pita giobu kaliva-dina wagaidiya ke givonedi, givona, “Kaliva-nai walelelena ani Iyayeku. Gavana vuvuna waela?” ");
INSERT INTO bwd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Aku kaliva ivona, “Koneliyasi, banae tolugaviya aditonagona seyana giimilima aelai. Banae kaliva iwakana. Tova moyaina Yaubada wagaine gioduodu ada meIsileli moyaidi ivemoimoinena lakaina. Ada Yaubada yana anelose tabutabuna seyana gielai wagaine ke givonena vaita o gina veoleni ke unaelai yana manuweya, e ada gina nogalina gavana unavona.” ");
INSERT INTO bwd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tova-nai Pita yadi vona ginogalina ada givagauledi aku givonedi, “Wanaela idedeku-deya kanadau, ada malabutuya kananau.” Mala gilavuna Pita gikidewadewa ke kaliva-dina nodi itauya, ada kaduwe tovetumagana tufodi Yofa wagaine-deya ikwayabudi nodi inau. ");
INSERT INTO bwd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yadayada anavelu Sisalia wagaine iyegemona, ada Koneliyasi tubuiyanavo kaduwe yana gabuyavo nodi gidouwevagauwidi ada ibodabodana. ");
INSERT INTO bwd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tova-nai Pita gilukuluku aku Koneliyasi giela tugana givetodonena ada gioduodu wagaine. ");
INSERT INTO bwd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aku Pita gisivemididina ke givonena, givonaga, “Una mididi! Iya kaduwe kaliva-mowa.” ");
INSERT INTO bwd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ada Pita Koneliyasi wagaine giifuifufu aku manuweya ilukuluku ani Pita ginuwagana yoo lakaina bademowa ivagauta. ");
INSERT INTO bwd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ada givonedi, givona, “Ime meIsileli amaawata seyana waalamane-dewedewena, vaita kwana Isileli keke meyameyaganina badi keke meIsileli gina awakawakadi o kai nodi ina luveya. Aku Yaubada givewaleku vaita keke tamo kaliva gada vewaga vaita banae keke yegayegana Ya